<?php

namespace Rahi\DashboardNew\Controller\Adminhtml\Pendingtoapproved;

use Psr\Log\LoggerInterface;
use Magento\Framework\Stdlib\DateTime\TimezoneInterface;
use Magento\Framework\Stdlib\BooleanUtils;

class Ajax extends \Magento\Backend\App\Action
{
    protected $_helper;
    protected $resultPageFactory;
    protected $jsonHelper;
    protected $_coreRegistry = null;
    protected $logger;
    protected $timezone;

    public function __construct(
        \Rahi\DashboardNew\Helper\Data $_helper,
        \Magento\Backend\App\Action\Context $context,
        \Magento\Framework\View\Result\PageFactory $resultPageFactory,
        \Magento\Framework\Json\Helper\Data $jsonHelper,
        \Magento\Framework\Controller\Result\JsonFactory $resultJsonFactory,
        \Magento\Framework\Registry $_coreRegistry,
        \Magento\Framework\Stdlib\DateTime\DateTime $date,
        TimezoneInterface $timezone,
        BooleanUtils $booleanUtils,
        LoggerInterface $logger
    ) {
        $this->resultPageFactory = $resultPageFactory;
        $this->jsonHelper = $jsonHelper;
        $this->_coreRegistry = $_coreRegistry;
        $this->resultJsonFactory = $resultJsonFactory;
        $this->logger = $logger;
        $this->_helper = $_helper;
        $this->_date = $date;
        $this->timezone = $timezone;
        $this->booleanUtils = $booleanUtils;
        parent::__construct($context);
    }

    public function execute()
    {
        try {
            $params = $this->_request->getParams();
            return $this->jsonResponse($params);
        } catch (\Magento\Framework\Exception\LocalizedException $e) {
            return $this->jsonResponse($e->getMessage());
        } catch (\Exception $e) {
            $this->logger->critical($e);
            return $this->jsonResponse($e->getMessage());
        }
    }

    public function jsonResponse($response = '')
    {
        $startDateSelected = $_POST['start'] . ' 00:00:00';
        $endDateSelected = $_POST['end'] . ' 23:59:59';
        $objectManager =  \Magento\Framework\App\ObjectManager::getInstance();

        $responseSent = array();
        $orderParentIdCollection = array();
        $totalPendingOrdersSelected = 1;
        $totalPendingOrdersSelectedCollection = array();
        $totalPendingOrdersSelectedCollectionLabels = array();
        $averageTimeOrdersSelected = 0;
        $timeDifference = 0;
        $timeDifferenceTotal = 0;

        $resource = $objectManager->get('Magento\Framework\App\ResourceConnection');
        $connection = $resource->getConnection();

        $sqlOrderApprovedHistory = "SELECT * FROM `rahi_equote_comments` WHERE `status` = 'Ready' and `created_at` >= '". $startDateSelected  ."' and `created_at` <= '".$endDateSelected."'  ORDER BY `entity_id` DESC";
        $orderApprovedHistoryCollection = $connection->fetchAll($sqlOrderApprovedHistory);

        $tbody = '<thead><tr class="GpnReport"><th class="GpnReport"><strong>Sr. No</strong></th><th class="GpnReport"><strong>Equote Id</strong></th><th class="GpnReport"><strong>Equote Status New</strong></th>
        <th class="GpnReport"><strong>Equote Status Ready</strong></th><th class="GpnReport"><strong>Time To change the status</strong></th></tr></thead><tbody>';
        if (!empty($orderApprovedHistoryCollection)) {
            $i = 1;
            foreach ($orderApprovedHistoryCollection as $orderApprovedHistoryCollectionItems) {
                $orderParentId = $orderApprovedHistoryCollectionItems['equote_id'];
                $orderStatusApproved = $orderApprovedHistoryCollectionItems['status'];
                $orderStatusApprovedDate = $orderApprovedHistoryCollectionItems['created_at'];

                $sqlOrderPendingHistory = "SELECT * FROM `rahi_equote_comments` WHERE `equote_id` = '" . $orderParentId . "'  AND `status` = 'New' ORDER BY `entity_id` DESC";
	        $resultOrderPendingHistory = $connection->fetchAll($sqlOrderPendingHistory);

                $orderPendingHistoryCollection = $resultOrderPendingHistory;
                if (!empty($orderPendingHistoryCollection)) {
                    foreach ($orderPendingHistoryCollection as $orderPendingHistoryCollectionItems) {
                        $orderParentIdCheck = $orderPendingHistoryCollectionItems['equote_id'];
                        if ($orderParentIdCheck == $orderParentId) {
                            $orderStatusPendingDate = $orderPendingHistoryCollectionItems['created_at'];
                            $timeDifferenceSeconds = strtotime($orderStatusApprovedDate) - strtotime($orderStatusPendingDate); 
                            $timeDifferenceTotal += $timeDifferenceSeconds;
                            $datetime1 = new \DateTime($orderStatusPendingDate);
                            $datetime2 = new \DateTime($orderStatusApprovedDate);
                            $interval = $datetime1->diff($datetime2);
                            $timeDifference = $interval->format('%m months %d days %H hours %i minutes %s seconds');
                        }

                        $orderParentIdCollection[] = $orderParentId;
                        $tbody .= "<tr class='GpnReport'><td><strong>" . $i . "</strong></td>";
                        $tbody .= "<td><strong>" . $orderParentId . "</strong></td>";
                        $tbody .= "<td><strong>" . $orderStatusPendingDate . "</strong></td>";
                        $tbody .= "<td><strong>" . $orderStatusApprovedDate . "</strong></td>";
                        $tbody .= "<td><strong>" . $timeDifference . "</strong></td>";
                        $tbody .= "</tr>";
                        $i++;
                    }
                    $totalPendingOrdersSelected = count($orderParentIdCollection);
                    $averageTimeOrdersSelected = intval($timeDifferenceTotal / $totalPendingOrdersSelected);
                }
            }
        }
        $totalPendingOrdersSelectedCollection[] = $totalPendingOrdersSelected;
        $totalPendingOrdersSelectedCollectionLabels[] = "Total New to Ready equotes in range";
        $tbody .= "</tbody>";
        $hours = floor($averageTimeOrdersSelected / 3600);
        $minutes = floor(($averageTimeOrdersSelected / 60) % 60);
        $seconds = $averageTimeOrdersSelected % 60;
        $tfoot = "<tfoot class='GpnReport'>";
        $tfoot .= "<tr class='GpnReport'><th class='total' colspan='4'><strong>Total New to Ready equotes in range:</strong></th><td><strong>" . $totalPendingOrdersSelected . "</strong></td></tr>";
        $tfoot .= "<tr class='GpnReport'><th class='total' colspan='4'><strong>Average time taken for equotes in range:</strong></th><td><strong>" . $hours . ':' . $minutes . ':' . $seconds . "</strong></td></tr>";
        $tfoot .= "<tr class='GpnReport'><th class='total' colspan='4'><strong>Timeline:</strong></th><td><strong>" . $startDateSelected . " PST to " . $endDateSelected . " PST </strong></td></tr>";
        $tfoot .= "</tfoot>";
        $responseSent['body'] = $tbody . $tfoot;
        $graphData['xValues']= $totalPendingOrdersSelectedCollectionLabels;
        $graphData['yValues']= $totalPendingOrdersSelectedCollection;
        $responseSent['graphData'] = $graphData;
        return $this->getResponse()->representJson($this->jsonHelper->jsonEncode($responseSent));
    }
}
