<?php

namespace Rahi\Login\Setup;

use Magento\Cms\Model\PageFactory;
use Magento\Framework\Setup\InstallDataInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\ModuleDataSetupInterface;

class InstallData implements InstallDataInterface
{
    private $pageFactory;
    private $blockFactory;

    public function __construct(PageFactory $pageFactory)
    {
        $this->pageFactory = $pageFactory;
    }

    public function install(ModuleDataSetupInterface $setup, ModuleContextInterface $context)
    {
        $cmsPageData = [
            'title' => 'Google Authentication Page', 
            'page_layout' => '1column', 
            'meta_keywords' => 'auth user',
            'meta_description' => 'auth user',
            'identifier' => 'google-auth-page',
            'content_heading' => 'Google Authentication Page', 
            'content' => "<h1>Please login via Punchout2GO Portal to access this portal..........</h1>", // page content
            'is_active' => 1, 
            'stores' => [0], 
            'sort_order' => 0 
        ];

        // create page
        $this->pageFactory->create()->setData($cmsPageData)->save();
    }
}