<?php

namespace Rahi\Equote\Controller\Adminhtml\AddItems;

use Magento\Catalog\Model\Product;
use Magento\Framework\Controller\Result\JsonFactory;
use Rahi\Equote\Helper\Data;
use Magento\Catalog\Api\ProductRepositoryInterface;
use Magento\Catalog\Model\Product\Action as ProductAction;

class Index extends \Magento\Backend\App\Action
{
    protected $jsonFactory;
    protected $categoryLinkManagementInterface;
    protected $productFactory;
    protected $helper;
    private $productRepository;
    private $productAction;

    public function __construct(
        JsonFactory $jsonFactory,
        Product $product,
        Data $helper,
        \Magento\CatalogInventory\Api\StockRegistryInterface $stockRegistry,
        \Magento\Catalog\Api\CategoryLinkManagementInterface  $categoryLinkManagementInterface,
        \Magento\Catalog\Model\ProductFactory $productFactory,
        ProductRepositoryInterface $productRepository,
        ProductAction $action,
        \Magento\Backend\App\Action\Context $context
    ) {
        $this->jsonFactory = $jsonFactory;
        $this->product = $product;
        $this->helper = $helper;
        $this->stockRegistry = $stockRegistry;
        $this->productRepository = $productRepository;
        $this->productAction = $action;
        $this->categoryLinkManagementInterface = $categoryLinkManagementInterface;
        $this->productFactory = $productFactory;
        parent::__construct($context);
    }
    public function execute()
    {
        $resultJson = $this->jsonFactory->create();
        $error = false;
        $postItems = $_POST['itemInfo']['0'];
        $countProducts = count($postItems);
        $form_key = $_POST['form_key'];
        $messages = [];
        foreach ($postItems as $postItemsEach) {
            $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
            $storeManager = $objectManager->create('\Magento\Store\Model\StoreManagerInterface');
            $websiteId = $storeManager->getWebsite()->getWebsiteId();
            $product = $objectManager->create('\Magento\Catalog\Model\Product');
            $product_resource = $product->getResource();
            $prod = $product->loadByAttribute('sku', $postItemsEach['mpn']);
            $exists = 0;
            $productId = $this->product->getIdBySku($postItemsEach['mpn']);
            $websiteIds = [1];
            $productIds = [$productId];
            if (isset($postItemsEach['eol'])) {
                if ($postItemsEach['eol'] == 1) {
                    continue;
                }
            }
            if (!$product->getIdBySku($postItemsEach['mpn'])) {
                $product->setSku($postItemsEach['mpn']);
                $product->setName($postItemsEach['mpn']);
                $product->setPrice(0.0);
                $product->setTypeId('simple');
                $product->setAttributeSetId(4);
                $product->save();
                $exists = 0;
            }
            if ($product->getIdBySku($postItemsEach['mpn'])) {
                $product->setTypeId('simple');
                $product->setAttributeSetId(4);
                $product->setStatus(1);
		//$product->save();
                $exists = 1;
            }
            $product->getSku($postItemsEach['mpn']);
            $product->setName($postItemsEach['mpn']);
            $product->setGpn($postItemsEach['gpn']);
            $product->setMpn($postItemsEach['mpn']);
            $categoryIds = array('2');
            $product->setTaxClassId(0);
            if ($exists == 0) {
                $product->save();
            } else {
                $prod = $product->loadByAttribute('sku', $postItemsEach['mpn']);
                $prod->save();
            }
            $storeIds = array_keys($storeManager->getStores());
            $optLabel = $postItemsEach['manufacturer'];
            $attrCode = 'manufacturer';
            $productAttrOptions = $this->helper->getAttributeOptionId($attrCode, $optLabel);
            $productId = $this->product->getIdBySku($postItemsEach['mpn']);
            if (!empty($postItemsEach['unit_price'])) {
                $prod->setData('price', $postItemsEach['unit_price']);
            }
            $visibility = "4";
            $prod->setData('manufacturer', $productAttrOptions);
            $prod->setData('visibility', $visibility);
            $prod->setData('ns_item_id', $postItemsEach['netsuite_id']);
            $prod->setData('lead_time', $postItemsEach['lead_time']);
            $prod->setData('status', "1");
            $prod->setData('description', $postItemsEach['description']);
            $prod->setData('website_ids', [1]);
            $cnt = 0;
            $categoryLinkRepository = $objectManager->get('\Magento\Catalog\Api\CategoryLinkManagementInterface');
            $categoryIds = array('2', '10');
            $sku = $postItemsEach['mpn'];
            $categoryLinkRepository->assignProductToCategories($sku, $categoryIds);
            $prod->save();
            if ($postItemsEach['mpn']) {
                $updateAttributes['status']  = 1;
                $updateAttributes['description']  = $postItemsEach['description'];
                $updateAttributes['lead_time'] = $postItemsEach['lead_time'];
                $updateAttributes['ns_item_id'] = $postItemsEach['netsuite_id'];
                $this->productAction->updateAttributes([$productId], $updateAttributes, $cnt);
                $cnt++;
            }
            $prod->setStockData(
                array(
                    'use_config_manage_stock' => 1,
                    'manage_stock' => 1,
                    'is_in_stock' => 1,
                    'qty' => 799
                )
            );
            $prod->save();
            $messages[] = __('Saved Successully.');
            $error = false;
            error_log("Saved.......");
        }
        return $resultJson->setData([
            'messages' => $messages,
            'error' => $error
        ]);
    }
}

