<?php
namespace Rahi\Equote\Controller\Adminhtml\Comments;

class Index extends \Magento\Backend\App\Action
{
    protected $_transportBuilder;
    protected $_inlineTranslation;
    protected $_customerRepositoryInterface;

    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Magento\Framework\Mail\Template\TransportBuilder $transportBuilder,
        \Magento\Framework\Translate\Inline\StateInterface $inlineTranslation,
        \Magento\Customer\Api\CustomerRepositoryInterface $customerRepositoryInterface
    )
    {
        $this->_transportBuilder = $transportBuilder;
        $this->_inlineTranslation = $inlineTranslation;
        $this->_customerRepositoryInterface = $customerRepositoryInterface;
        parent::__construct($context);
    }

    public function execute()
    {
        $data = $this->getRequest()->getParams();
        if ($data) {
		if($data['status'] == "New"){
                        $data['status'] ="Working";
                }

            $commentModel = $this->_objectManager->create('Rahi\Equote\Model\EquoteComments');
            $commentModel->setData($data);

            if($commentModel->save()){
                $equoteModel = $this->_objectManager->create('Rahi\Equote\Model\Equote');
                $equoteData = $equoteModel->load($commentModel->getEquoteId());
                $equoteData->setStatus($data['status']);
                $equoteModel->save();

                $blockInstance = $this->_objectManager->get('Rahi\Equote\Block\Adminhtml\EquoteItems');
                $result = $blockInstance->getEquoteComments()->addFilter('entity_id', $commentModel->getId())->getData();
                
                $this->sendEmail($commentModel,$equoteModel);

                echo json_encode($result['0']);
            }
        }
    }

    protected function _isAllowed()
    {
        return true;
    }

    public function sendEmail($commentModel,$equoteModel){
        $template = 'new_comment';
        $customerId = $equoteModel->getCustomerId();
        $customer = $this->_customerRepositoryInterface->getById($customerId);

        $recipient_address = $customer->getEmail();
        $recipient_name = $customer->getFirstname();
	$watchlist = array_filter(explode(",",$equoteModel['watchlist_emails']));
        $from_address = [
            'name' => "Punchout Portal",
            'email' => "no-reply@rahisystems.com"
        ];
        $vars = [
            'customer_name' => $recipient_name,
            'store_name' => 'Punchout Portal',
            'store_email' => 'GoogleAriba.Support@rahisystems.com',
            'equote_id'=>  $commentModel->getEquoteId(),
            'status' => $equoteModel->getStatus(),
            'created_at' => date("d/m/Y",$commentModel->getCreatedAt()),
            'comment' => $commentModel->getComment()
        ];
        $this->_inlineTranslation->suspend();
        $this->_transportBuilder->setTemplateIdentifier(
            $template
        )->setTemplateOptions(
            [
              'area'  => \Magento\Framework\App\Area::AREA_FRONTEND,
              'store' =>  \Magento\Store\Model\Store::DEFAULT_STORE_ID,
          ]
      )->setTemplateVars(
        $vars
    )->setFrom(
        $from_address
    )->addTo(
        $recipient_address,
        $recipient_name
    )->addCc(
       'GoogleAriba.Support@rahisystems.com',
       'Admin'
    )->addCc($watchlist);



    if (!isset($transport)) {
        $transport = $this->_transportBuilder->getTransport();
    }
    try {
        $transport->sendMessage();
        $this->_inlineTranslation->resume();
    } catch (\Exception $exception) {

    }
}
}

