<?php

namespace Rahi\Equote\Controller\Customer;

use Magento\Framework\App\Action\Context;
use Magento\Framework\View\Result\PageFactory;
use Magento\Framework\Controller\Result\Redirect;

class Index extends \Magento\Framework\App\Action\Action
{
    protected $resultPageFactory;
    protected $session;
    protected $resultRedirectFactory;

    public function __construct(
        \Magento\Framework\App\Action\Context $context,
        \Magento\Customer\Model\Session $customerSession,
        Redirect $resultRedirectFactory,
        PageFactory $resultPageFactory
    ) {
        $this->session = $customerSession;
        parent::__construct($context);
        $this->resultRedirectFactory = $resultRedirectFactory;
        $this->resultPageFactory = $resultPageFactory;
    }
    public function execute()
    {
        if ($this->session->isLoggedIn()) {
            $customerId = $this->session->getCustomer()->getId();
        }
        if (!$this->session->isLoggedIn()) {
            // $resultRedirect = $this->resultRedirectFactory->create();
            // $resultRedirect->setUrl($this->_redirect->getRefererUrl());
            $this->messageManager->addError(__('Please sign in to view or generate equote...'));
        }
        $this->_view->loadLayout();
        $this->_view->renderLayout();
        // return $resultRedirect;
    }
}
