<?php

/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

namespace Vendor\CustomSearch\Model\ResourceModel\Fulltext\Collection;

use Magento\Framework\Data\Collection;
use Magento\Framework\Search\Adapter\Mysql\TemporaryStorage;
use Magento\Framework\Search\Adapter\Mysql\TemporaryStorageFactory;
use Magento\Framework\Api\Search\SearchResultInterface;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Store\Model\ScopeInterface;

/**
 * Resolve specific attributes for search criteria.
 */
class SearchResultApplier extends \Magento\CatalogSearch\Model\ResourceModel\Fulltext\Collection\SearchResultApplier
{
    /**
     * @var Collection
     */
    private $collection;

    /**
     * @var SearchResultInterface
     */
    private $searchResult;

    /**
     * @var TemporaryStorageFactory
     */
    private $temporaryStorageFactory;

    /**
     * @var array
     */
    private $orders;

    /**
     * @var Data
     */
    protected $helper;

    /**
     * @param Collection $collection
     * @param SearchResultInterface $searchResult
     * @param TemporaryStorageFactory $temporaryStorageFactory
     * @param mixed $helper
     * @param array $orders
     */
    public function __construct(
        Collection $collection,
        SearchResultInterface $searchResult,
        TemporaryStorageFactory $temporaryStorageFactory,
        \Vendor\CustomSearch\Helper\Data $helper,
        ScopeConfigInterface $scopeConfig,
        array $orders
    ) {
        $this->collection = $collection;
        $this->searchResult = $searchResult;
        $this->temporaryStorageFactory = $temporaryStorageFactory;
        $this->helper = $helper;
        $this->scopeConfig = $scopeConfig;
        $this->orders = $orders;
    }

    /**
     * @inheritdoc
     */
    public function apply()
    {

        if (isset($_GET['q'])) {

            $product_ids = [];

            // $response = $this->sendApi(str_replace(' ', '+', $_GET['q']));
            // $data = json_decode($response, 1);

            // $product_ids = array_column($data, 'product_id');
            // print_r($product_ids); die;
            // $this->helper->setValue('pids', $product_ids);
            // $this->helper->getValue('pids'));
            $product_ids = $this->helper->getValue('pids');

            if (!empty($product_ids)) {
                // Explode the product IDs into an array

                // Optionally, you can validate each ID or process it
                // Example: ensure they are integers
                // $product_ids = array_map('intval', $product_ids);
                // Now, you can use the $product_ids array as needed

                $this->collection->getSelect();
                $this->collection->addAttributeToFilter('entity_id', ['in' => $product_ids]); //->setOrder('entity_id', 'FIELD(entity_id,'.implode(',', $product_ids).')');
                // Use Zend_Db_Expr to directly add the FIELD() SQL function to the select statement
                // Ensure the 'catalog_product_entity' table is being used and join it if necessary
                // if($product_ids !== null){
                $this->collection->getSelect()->join(
                    ['cpe' => 'catalog_product_entity'],  // Alias 'cpe' for 'catalog_product_entity'
                    'e.entity_id = cpe.entity_id',        // Make sure the join condition is correct
                    []
                );

                // Add the ORDER clause using the FIELD function with the correct alias
                $this->collection->getSelect()->order(new \Zend_Db_Expr('FIELD(cpe.entity_id, ' . implode(',', $product_ids) . ')'));
                // Optionally, you can add more filters, such as filtering by status if needed
                $this->collection->addAttributeToFilter('status', ['eq' => 1]);
                // }
            } else {
                $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
                $request = $objectManager->get(\Magento\Framework\App\RequestInterface::class);
                $currentUrl = $request->getServer('HTTP_REFERER');
                header("Location: $currentUrl");
                exit;

                // $this->collection->getSelect();
                // $this->collection->addAttributeToFilter('entity_id', ['in' => [null]]);
            }


            $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
            $request = $objectManager->create('Magento\Framework\App\RequestInterface');

            if ($request->getParam('prfilter_ajax')) {

                $urlVariables = $objectManager->create('Plumrocket\LayeredNavigationLite\Api\GetUrlVariablesInterface');
                $variables = $urlVariables->getFromAjaxParams($request->getParam('prfilter_variables', []));
                // $this->handleAjaxRequest($request);
                // return;

                if (isset($variables['is_available_in_nasa'])) {
                    $this->collection->addAttributeToFilter('is_available_in_nasa', ['in' => $variables['is_available_in_nasa']]);
                }

                if (isset($variables['is_available_in_apac'])) {
                    $this->collection->addAttributeToFilter('is_available_in_apac', ['in' => $variables['is_available_in_apac']]);
                }

                if (isset($variables['is_available_in_emea'])) {
                    $this->collection->addAttributeToFilter('is_available_in_emea', ['in' => $variables['is_available_in_emea']]);
                }
            }

            if (isset($_GET['is_available_in_nasa']) || isset($_GET['is_available_in_apac']) || isset($_GET['is_available_in_apac'])) {

                $urlVariables = $objectManager->create('Plumrocket\LayeredNavigationLite\Api\GetUrlVariablesInterface');
                $variables = $urlVariables->getFromAjaxParams($request->getParam('prfilter_variables', []));
                // $this->handleAjaxRequest($request);
                // return;
                if (isset($_GET['is_available_in_nasa'])) {
                    $this->collection->addAttributeToFilter('is_available_in_nasa', ['in' => $_GET['is_available_in_nasa']]);
                }

                if (isset($_GET['is_available_in_apac'])) {
                    $this->collection->addAttributeToFilter('is_available_in_apac', ['in' => $_GET['is_available_in_apac']]);
                }

                if (isset($_GET['is_available_in_emea'])) {
                    $this->collection->addAttributeToFilter('is_available_in_emea', ['in' => $_GET['is_available_in_emea']]);
                }
            }
        } else {
            // defualt core code
            $temporaryStorage = $this->temporaryStorageFactory->create();
            $table = $temporaryStorage->storeApiDocuments($this->searchResult->getItems());

            $this->collection->getSelect()->joinInner(
                [
                    'search_result' => $table->getName(),
                ],
                'e.entity_id = search_result.' . TemporaryStorage::FIELD_ENTITY_ID,
                []
            );

            if (isset($this->orders['relevance'])) {
                $this->collection->getSelect()->order(
                    'search_result.' . TemporaryStorage::FIELD_SCORE . ' ' . $this->orders['relevance']
                );
            }
        }

        // $this->collection->addAttributeToFilter('entity_id', ['in' => [248,350]]);
        // set flag  = null if response is null

        // if (isset($this->orders['relevance'])) {
        //     $this->collection->getSelect()->order(
        //         'search_result.' . TemporaryStorage::FIELD_SCORE . ' ' . $this->orders['relevance']
        //     );
        // }
    }
}
