require(["jquery", "jquery/ui"], function ($) {
    jQuery(document).ready(function () {
        jQuery('#btnExportXcl').on('click', function () {
            var dt = new Date();
            var Months = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
            var store = jQuery('#selectStore option:selected').text().trim();
            var time = dt.getDate() + "_" + Months[dt.getMonth()] + "_" + dt.getFullYear() + "_" + dt.getHours() + "_" + dt.getMinutes() + "_" + dt.getSeconds();
            if (jQuery("#GpnDistributionReport").length > 0) {
                jQuery("#GpnDistributionReport").table2excel({
                    name: "Excel Document Name",
                    filename: "GPN_Distribution_" + store + "_" + time + ".xls",
                    fileext: ".xls",
                    exclude_img: true,
                    exclude_links: true,
                    exclude_inputs: true
                });
            }
            if (jQuery("#InStockReport").length > 0) {
                jQuery("#InStockReport").table2excel({
                    name: "Excel Document Name",
                    filename: "Instock_Distribution_" + store + "_" + time + ".xls",
                    fileext: ".xls",
                    exclude_img: true,
                    exclude_links: true,
                    exclude_inputs: true
                });
            }
            if (jQuery("#AverageOrderReport").length > 0) {
                jQuery("#AverageOrderReport").table2excel({
                    name: "Excel Document Name",
                    filename: "Average_Order_Report" + store + "_" + time + ".xls",
                    fileext: ".xls",
                    exclude_img: true,
                    exclude_links: true,
                    exclude_inputs: true
                });
            }
            if (jQuery("#AverageCustomerVisitReport").length > 0) {
                jQuery("#AverageCustomerVisitReport").table2excel({
                    name: "Excel Document Name",
                    filename: "Average_Customer_Visit_Report" + store + "_" + time + ".xls",
                    fileext: ".xls",
                    exclude_img: true,
                    exclude_links: true,
                    exclude_inputs: true
                });
            }
            if (jQuery("#AverageTicketsReport").length > 0) {
                jQuery("#AverageTicketsReport").table2excel({
                    name: "Excel Document Name",
                    filename: "Average_Tickets_Report" + store + "_" + time + ".xls",
                    fileext: ".xls",
                    exclude_img: true,
                    exclude_links: true,
                    exclude_inputs: true
                });
            }
            if (jQuery("#AverageCustomersReport").length > 0) {
                jQuery("#AverageCustomersReport").table2excel({
                    name: "Excel Document Name",
                    filename: "Average_Customers_Report" + store + "_" + time + ".xls",
                    fileext: ".xls",
                    exclude_img: true,
                    exclude_links: true,
                    exclude_inputs: true
                });
            }     
            if (jQuery("#AverageCanceledOrderReport").length > 0) {
                jQuery("#AverageCanceledOrderReport").table2excel({
                    name: "Excel Document Name",
                    filename: "Average_Canceled_Order_Report" + store + "_" + time + ".xls",
                    fileext: ".xls",
                    exclude_img: true,
                    exclude_links: true,
                    exclude_inputs: true
                });
            }
            if (jQuery("#MostSearchedKeywords").length > 0) {
                jQuery("#MostSearchedKeywords").table2excel({
                    name: "Excel Document Name",
                    filename: "Most_Searched_Keywords_Report" + store + "_" + time + ".xls",
                    fileext: ".xls",
                    exclude_img: true,
                    exclude_links: true,
                    exclude_inputs: true
                });
            }
        });
jQuery('#btnExportCsv').on('click', function () {
    var dt = new Date();
    var Months = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
    var store = jQuery('#selectStore option:selected').text().trim();
    var time = dt.getDate() + "_" + Months[dt.getMonth()] + "_" + dt.getFullYear() + "_" + dt.getHours() + "_" + dt.getMinutes() + "_" + dt.getSeconds();
    if (jQuery("#StockReport").length > 0) {
        jQuery('#StockReport').tableExport({
            type: 'csv', fileName: "GPN_Distribution_" + store + "_" + time + "_",
        });
    }
});
});
});
