<?php

namespace Rahi\Equote\Controller\Adminhtml\AddItems;

use Magento\Catalog\Model\Product;
use Magento\Framework\Controller\Result\JsonFactory;
use Rahi\Equote\Helper\Data;
use Magento\Catalog\Api\ProductRepositoryInterface;
use Magento\Catalog\Model\Product\Action as ProductAction;
use Magento\Store\Model\StoreManagerInterface;

class Index extends \Magento\Backend\App\Action
{
    protected $jsonFactory;
    protected $categoryLinkManagementInterface;
    protected $productFactory;
    protected $helper;
    private $productRepository;
    private $productAction;
    protected $storeManager;

    public function __construct(
        JsonFactory $jsonFactory,
        Product $product,
        Data $helper,
        \Magento\CatalogInventory\Api\StockRegistryInterface $stockRegistry,
        \Magento\Catalog\Api\CategoryLinkManagementInterface  $categoryLinkManagementInterface,
        \Magento\Catalog\Model\ProductFactory $productFactory,
        ProductRepositoryInterface $productRepository,
        ProductAction $action,
        StoreManagerInterface $storeManager,
        \Magento\Backend\App\Action\Context $context
    ) {
        $this->jsonFactory = $jsonFactory;
        $this->product = $product;
        $this->helper = $helper;
        $this->stockRegistry = $stockRegistry;
        $this->productRepository = $productRepository;
        $this->productAction = $action;
        $this->categoryLinkManagementInterface = $categoryLinkManagementInterface;
        $this->productFactory = $productFactory;
        $this->storeManager = $storeManager;
        parent::__construct($context);
    }
    public function execute()
    {
        $resultJson = $this->jsonFactory->create();
        $error = false;
        $postItems = $_POST['itemInfo']['0'];
        $messages = [];


        foreach ($postItems as $postItemsEach) {
            $loadId = $postItemsEach['mpn'];
           /* if(isset($postItemsEach['sku'])) { // commented this code to disable Anixter Request Qoute logic and 
                $loadId = $postItemsEach['sku'];
            } else {
                $loadId = $postItemsEach['mpn'];
            }*/

            if (isset($postItemsEach['eol'])) {
                if ($postItemsEach['eol'] == 1) {
                    continue;
                }
            }
            $store = $this->storeManager->getStore($postItemsEach['store']);
            $targetStoreViewId = $store->getId();

            $visibility = [];
            $visibilityForTargetStoreView = \Magento\Catalog\Model\Product\Visibility::VISIBILITY_BOTH; // Set the visibility for the target store view
            $visibilityForOtherStoreViews = \Magento\Catalog\Model\Product\Visibility::VISIBILITY_NOT_VISIBLE;
            if (!$this->product->loadByAttribute('mpn', trim($loadId))) {
                $newProduct = $this->productFactory->create();
                $newProduct->setSku(trim($postItemsEach['mpn']));
                $newProduct->setMpn(trim($postItemsEach['mpn']));
                $newProduct->setName(trim($postItemsEach['mpn']));
                $newProduct->setPrice(0.0);
                $newProduct->setTypeId('simple');
                $newProduct->setStatus(1);
                $newProduct->setAttributeSetId(4);
                $newProduct->setCategoryIds([10, 13, $postItemsEach['category']]);
                $newProduct->setTaxClassId(0);
                $newProduct->setData('website_ids', [1]);
                $newProduct->setUrlKey($postItemsEach['mpn']);
                $newProduct->setStockData(
                    array(
                        'use_config_manage_stock' => 1,
                        'manage_stock' => 1,
                        'is_in_stock' => 1,
                        'qty' => 9999
                    )
                );
                foreach ($newProduct->getStoreIds() as $storeId) {
                    $newProduct->setStoreId($storeId);
                    if ($storeId == $targetStoreViewId) {
                        $newProduct->setVisibility('4', $storeId);
                    } else {
                        $newProduct->setVisibility("1", $storeId);
                    }
                    $newProduct->save();
                }
            }
            $product = $this->product->loadByAttribute('mpn', trim($loadId));
            $isAnixter = $product->getAnixterProduct();
            if ($isAnixter == 1) {
                $product->setAnixterProduct(0);
                $product->setCategoryIds([2, 10, 13, 14]);
            }
            $optLabel = $postItemsEach['manufacturer'];
            $attrCode = 'manufacturer';
            $productAttrOptions = $this->helper->getAttributeOptionId($attrCode, $optLabel);
            if (!empty($postItemsEach['gpn'])) {
                $product->setData('gpn', $postItemsEach['gpn']);
            }
            if (!empty($postItemsEach['unit_price'])) {
                $product->setData('price', $postItemsEach['unit_price']);
            }
            if (!empty($postItemsEach['manufacturer'])) {
                $product->setData('manufacturer', $productAttrOptions);
            }
            if (!empty($postItemsEach['netsuite_id'])) {
                $product->setData('ns_item_id', $postItemsEach['netsuite_id']);
            }
            $product->setData('ncnr', $postItemsEach['ncnr']);
            if (!empty($postItemsEach['lead_time'])) {
                $product->setData('lead_time', $postItemsEach['lead_time']);
            }
            if (!empty($postItemsEach['description'])) {
                $product->setData('description', $postItemsEach['description']);
            }
            if (!empty($postItemsEach['category'])) {
                $ids = [10, $postItemsEach['category']];
                $product->setData('category_ids', $ids);
            }
            $product->save();
            $messages[] = __('Saved Successully.');
            $error = false;
        }
        return $resultJson->setData([
            'messages' => $messages,
            'error' => $error
        ]);
    }
}
