<?php

namespace Rahi\Equote\Controller\Adminhtml\Index;

use Magento\Backend\App\Action;
use Magento\Framework\App\Filesystem\DirectoryList;
class Save extends \Magento\Backend\App\Action
{
    /**
     * @var PostDataProcessor
     */
    protected $dataProcessor;
    protected $formKey;
    protected $uploaderFactory;
    protected $adapterFactory;
    protected $filesystem;
    /**
     * @param Action\Context $context
     * @param PostDataProcessor $dataProcessor
     */
    public function __construct(Action\Context $context, PostDataProcessor $dataProcessor,\Magento\Framework\Data\Form\FormKey $formKey,
	        \Magento\MediaStorage\Model\File\UploaderFactory $uploaderFactory,
	        \Magento\Framework\Image\AdapterFactory $adapterFactory,
	        \Magento\Framework\Filesystem $filesystem
	)
    {
        $this->dataProcessor = $dataProcessor;
	$this->formKey = $formKey;
        $this->uploaderFactory = $uploaderFactory;
        $this->adapterFactory = $adapterFactory;
        $this->filesystem = $filesystem;

        parent::__construct($context);
    }

    /**
     * {@inheritdoc}
     */
    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed('Rahi_Equote::equote');
    }

    /**
     * Save action
     *
     * @return \Magento\Framework\Controller\ResultInterface
     */
    public function execute()
    {
        $data = $this->getRequest()->getPostValue();
        // echo "<pre>";
        // print_r($data);
        // exit;
        /** @var \Magento\Backend\Model\View\Result\Redirect $resultRedirect */
        $resultRedirect = $this->resultRedirectFactory->create();
	$QuoteTotal= 0;
        if ($data) {
 	     $itemsdata = $data['item_data'];
		foreach($itemsdata as $item){
		        if(isset($item['unit_price']) &&  $item['eol']==0){
        		        $QuoteTotal += ((float)$item['unit_price'] * (int)$item['requested_qty']); 
	       		}
		}
		$data['quote_total'] = $QuoteTotal;
            $model = $this->_objectManager->create('Rahi\Equote\Model\Equote');
            $id = $this->getRequest()->getParam('equote_id');
            if ($id) {
                $model->load($id);
            }
            $model->setData($data);
	        $quoteAttachments = $this->getRequest()->getFiles('attachment');
		$data['update_date'] = time();

            $this->_eventManager->dispatch(
                'equote_prepare_save',
                ['equote' => $model, 'request' => $this->getRequest()]
            );

            try {
                $model->save();
		$quoteId = $model->getId();
		if($quoteAttachments){
			 $i =0;
	                foreach ($quoteAttachments as $attachment) {
				if($attachment['error'] ==0){
		                        $quoteItemId = "";
		                        $up = 'attachment['.$i.']';
		                        $itemMpn = "";
		                        $this->uploadAttachment($up,$quoteId,$quoteItemId,$itemMpn); $i++;
				}
	                }
		}
		if(isset($data['delete_data'])){
                        $deletedata = $data['delete_data'];
                    foreach ($deletedata as $itemData) {
			$itemsModel = $this->_objectManager->create('Rahi\Equote\Model\EquoteItems');
                        if(isset($itemData['entity_id'])){
                        	$itemsModel->load($itemData['entity_id']);
                        	$itemsModel->delete();
			}
                    }
                }
                if ($itemsdata) {
		 $k=1;
		//print_r();
                    foreach ($itemsdata as $itemData) {
			$itemsModel = $this->_objectManager->create('Rahi\Equote\Model\EquoteItems');
                        $itemData['equote_id'] = $quoteId;
			$itemMpn = $itemData['mpn'];
                        $itemsModel->setData($itemData);
                        $itemsModel->save();
			$itemsDataAttach = $this->getRequest()->getFiles('item_data');
			$j =0;
			$quoteItemId =$itemsModel->getId();
			if($itemsDataAttach){
				$quoteItemAttachments = $itemsDataAttach[$k]['attachment']; 
        	        	foreach ($quoteItemAttachments as $itemsAttachment) {
					if($itemsAttachment['error'] ==0){
        	        	        	$upItem =$itemsAttachment;
	                        		$this->uploadAttachment($upItem,$quoteId,$quoteItemId,$itemMpn); $j++;
					}
                		}
			}
			$k++;
                    }
                }

                $this->messageManager->addSuccess(__('You saved this record.'));
                $this->_objectManager->get('Magento\Backend\Model\Session')->setFormData(false);
                if ($this->getRequest()->getParam('back')) {
                    return $resultRedirect->setPath('*/*/edit', ['equote_id' => $model->getId(), '_current' => true]);
                }
		return $resultRedirect->setPath('*/*/edit', ['equote_id' => $model->getId(), '_current' => true]);
            } catch (\Magento\Framework\Exception\LocalizedException $e) {
                $this->messageManager->addError($e->getMessage());
            } catch (\RuntimeException $e) {
                $this->messageManager->addError($e->getMessage());
            } catch (\Exception $e) {
                $this->messageManager->addException($e, __('Something went wrong while saving the record.'));
            }

            $this->_getSession()->setFormData($data);
            return $resultRedirect->setPath('*/*/edit', ['equote_id' => $this->getRequest()->getParam('equote_id')]);
        }
        return $resultRedirect->setPath('*/*/');
    }
     public function uploadAttachment($attachment,$quoteId,$quoteItemId,$itemMpn){
	try {
            $uploaderFactory = $this->uploaderFactory->create(['fileId' => $attachment]); 
            $uploaderFactory->setAllowedExtensions(['docx', 'doc','jpg', 'jpeg', 'gif', 'png','pdf','pptx', 'xls', 'xlsx']); // you can add more extension which need
            $uploaderFactory->setAllowRenameFiles(true);
            $uploaderFactory->setFilesDispersion(true);
            $mediaDirectory = $this->filesystem->getDirectoryRead(DirectoryList::MEDIA);
            $destinationPath = $mediaDirectory->getAbsolutePath('quaoteAttachments');
            $result = $uploaderFactory->save($destinationPath);
           $File_upload = $result['file'];
		$userName = $this->_objectManager->get('Magento\Backend\Model\Auth\Session')->getUser()->getName();
		$attachmentModel = $this->_objectManager->create('Rahi\Equote\Model\EquoteAttachments');
		$attachmentsData['path']=$File_upload;
		$attachmentsData['equote_id']=$quoteId;
		$attachmentsData['equote_item_id']=$quoteItemId;
		$attachmentsData['item_mpn']=$itemMpn;
		$attachmentsData['user_name']=$userName;
                $attachmentModel->setData($attachmentsData);
                $attachmentModel->save();
        }  catch (\Exception $e) {
            $this->messageManager->addError(__('File not Uplaoded, Please try Again'));
        }
    }
}
