<?php

namespace Rahi\Equote\Controller\Index;

use Magento\Framework\App\Filesystem\DirectoryList;

class Post extends \Magento\Framework\App\Action\Action
{
    protected $storeManager;
    protected $_transportBuilder;
    protected $_inlineTranslation;
    protected $_pageFactory;
    protected $uploaderFactory;
    protected $adapterFactory;
    protected $filesystem;
    /**
     * @var \Magento\Quote\Model\QuoteRepository
     */
    protected $quoteRepository;


    public function __construct(
        \Magento\Quote\Model\QuoteRepository $quoteRepository,
        \Magento\Framework\App\Action\Context $context,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        \Magento\Framework\Mail\Template\TransportBuilder $transportBuilder,
        \Magento\Framework\Translate\Inline\StateInterface $inlineTranslation,
        \Magento\Framework\View\Result\PageFactory $pageFactory,
        \Magento\MediaStorage\Model\File\UploaderFactory $uploaderFactory,
        \Magento\Framework\Image\AdapterFactory $adapterFactory,
        \Magento\Framework\Filesystem $filesystem
    ) {
        $this->quoteRepository = $quoteRepository;
        $this->storeManager = $storeManager;
        $this->_transportBuilder = $transportBuilder;
        $this->_inlineTranslation = $inlineTranslation;
        $this->_pageFactory = $pageFactory;
        $this->uploaderFactory = $uploaderFactory;
        $this->adapterFactory = $adapterFactory;
        $this->filesystem = $filesystem;
        return parent::__construct($context);
    }


    public function execute()
    {
        $customerSession = $this->_objectManager->create('Magento\Customer\Model\Session');
        if ($customerSession->isLoggedIn()) {

            $post = $this->getRequest()->getPostValue();
            if (!$post) {
                $this->__redirect('equote/index');
                return;
            }
            if (!isset($post['item_data'])) {
                $this->messageManager->addError(__('Please add items to save eQuote.'));
                $this->_redirect('equote/index');
                return;
            }

            $itemsdata = $post['item_data'];
            $postObject = new \Magento\Framework\DataObject();
            $postObject->setData($post);
            $quoteAttachments = $this->getRequest()->getFiles('attachment');
            $error = false;
            if (\Zend_Validate::is(trim($post['hideit']), 'NotEmpty')) {
                $error = true;
            }
            if ($error) {
                throw new \Exception();
            }

            if ($error == false) {
                try {
                    $customerId = 0;
                    $customerSession = $this->_objectManager->create('Magento\Customer\Model\Session');
                    if ($customerSession->isLoggedIn()) {
                        $customerId = $customerSession->getCustomer()->getId();
                        $customerName = $customerSession->getCustomer()->getName();
                    }
                    $post['created_at'] = time();
                    $post['updated_at'] = time();
                    $post['customer_id'] = $customerId;
                    $model = $this->_objectManager->create('Rahi\Equote\Model\Equote');
                    $model->setData($post);
                    $model->save();
                    $quoteId = $model->getId();




                    if ($quoteId) {
                        $data['equote_id'] = $quoteId;
                        $data['status'] = 'New';
                        $data['comment'] = 'Equote Placed';
                        $data['user_name'] = $customerName;
                        $commentModel = $this->_objectManager->create('Rahi\Equote\Model\EquoteComments');
                        $commentModel->setData($data);
                        $commentModel->save();
                    }

                    $i = 0;
                    foreach ($quoteAttachments as $attachment) {
                        if ($attachment['error'] == 0 && $attachment['name'] != '') {
                            echo "yes";
                            $quoteItemId = "";
                            $up = $attachment;
                            $itemMpn = "";
                            $this->uploadAttachment($up, $quoteId, $quoteItemId, $itemMpn, $customerName);
                            $i++;
                        }
                    }
                    if ($itemsdata) {
                        $k = 0;
                        $itemsModel = $this->_objectManager->create('Rahi\Equote\Model\EquoteItems');
                        $itemsDataAttach = $this->getRequest()->getFiles('item_data');
                        foreach ($itemsdata as $itemData) {
                            $itemData['equote_id'] = $quoteId;
                            $itemMpn = $itemData['mpn'];
                            $itemsModel->setData($itemData);
                            $itemsModel->save();
                            $quoteItemId = $itemsModel->getId();
                            $j = 0;
                            if ($itemsDataAttach) {
                                foreach ($itemsDataAttach as $value) {
                                    $quoteItemAttachments = $value['attachment'];
                                    foreach ($quoteItemAttachments as $itemsAttachment) {
                                        if ($itemsAttachment['error'] == 0 && $itemsAttachment['name'] != '') {
                                            $this->uploadAttachment($itemsAttachment, $quoteId, $quoteItemId, $itemMpn, $customerName);
                                            $j++;
                                        }
                                    }
                                }
                            }
                            $k++;
                        }
                        $this->sendEmail($customerSession->getCustomer(), $model->getData(), $itemsdata);
                    }
                   
                     /* commented this code to disable Anixter Request Qoute logic and 
                    $quote = $this->quoteRepository->get($post['quote_id']);
                    print_r($post);exit;
                    $quote->setWatchlistEmails('');
                    $this->quoteRepository->save($quote);

                    $cartObject = $this->_objectManager->create('Magento\Checkout\Model\Cart')->truncate();
                    $cartObject->saveQuote();*/
                    $this->messageManager->addSuccess(
                        __('Thanks for contacting us with your eQuote request. We\'ll respond to you very soon. You eQuote id is #' . $quoteId)
                    );

                    $this->_redirect('equote/customer/index');
                    return;
                } catch (\Exception $e) {

                    $this->messageManager->addError(
                        __($e->getMessage() . ' We can\'t process your request right now. Sorry, that\'s all we know.')
                    );
                    $this->_redirect('equote/index');
                    return;
                }
            } else {
                $this->messageManager->addError(
                    __(' Something went wrong.')
                );
                $this->_redirect('equote/index');
                return;
            }
        } else {
            $this->messageManager->addError(__('Please sign in to generate eQuote..'));
            $this->_redirect('equote/index');
            return;
        }
    }
    public function sendEmail($customerData, $equoteData, $itemsData)
    {

        $postObject = new \Magento\Framework\DataObject();
        $postObject->setData($equoteData);
        $watchlist = array_filter(explode(",", $equoteData['watchlist_emails']));
        //	print_r($watchlist);
        // die;
        $postObjectItems = new \Magento\Framework\DataObject();
        $postObjectItems->setData($itemsData);

        $template = 'new_quote';
        $recipient_address = $customerData->getEmail();
        $recipient_name = $customerData->getFirstname() . ' ' . $customerData->getLastname();
        $from_address = [
            'name' => "Punchout Portal",
            'email' => "no-reply@rahisystems.com"
        ];
        $vars = [
            'customer_name' => $customerData->getFirstname(),
            'store_name' => 'Punchout Portal',
            'store_email' => 'GoogleAriba.Support@rahisystems.com',
            'equote_id' =>  $equoteData['equote_id'],
            'created_at' => date("d/m/Y", $equoteData['created_at']),
            'equote_details' => $postObject,
            'items' => $postObjectItems
        ];
        $this->_inlineTranslation->suspend();
        $this->_transportBuilder->setTemplateIdentifier(
            $template
        )->setTemplateOptions(
            [
                'area'  => \Magento\Framework\App\Area::AREA_FRONTEND,
                'store' =>  \Magento\Store\Model\Store::DEFAULT_STORE_ID,
            ]
        )->setTemplateVars(
            $vars
        )->setFrom(
            $from_address
        )->addTo(
            $recipient_address,
            $recipient_name
        )->addCc('GoogleAriba.Support@rahisystems.com', 'Admin')->addCc($watchlist);

        if (!isset($transport)) {
            $transport = $this->_transportBuilder->getTransport();
        }
        try {
            $transport->sendMessage();
            $this->_inlineTranslation->resume();
        } catch (\Exception $exception) {
        }
    }
    public function uploadAttachment($attachment, $quoteId, $quoteItemId, $itemMpn, $customerName)
    {
        try {
            $uploaderFactory = $this->uploaderFactory->create(['fileId' => $attachment]);
            $uploaderFactory->setAllowedExtensions(['docx', 'doc', 'jpg', 'jpeg', 'gif', 'png', 'pdf', 'pptx', 'xls', 'xlsx', 'csv']); // you can add more extension which need
            $fileAdapter = $this->adapterFactory->create();
            $uploaderFactory->setAllowRenameFiles(true);
            $uploaderFactory->setFilesDispersion(true);
            $mediaDirectory = $this->filesystem->getDirectoryRead(DirectoryList::MEDIA);
            $destinationPath = $mediaDirectory->getAbsolutePath('quaoteAttachments');
            $result = $uploaderFactory->save($destinationPath);
            // save file name 
            $File_upload = $result['file'];
            $attachmentModel = $this->_objectManager->create('Rahi\Equote\Model\EquoteAttachments');
            $attachmentsData['path'] = $File_upload;
            $attachmentsData['equote_id'] = $quoteId;
            $attachmentsData['equote_item_id'] = $quoteItemId;
            $attachmentsData['item_mpn'] = $itemMpn;
            $attachmentsData['user_name'] = $customerName;
            $attachmentModel->setData($attachmentsData);
            if ($attachmentModel->save()) {
                $this->messageManager->addSuccess(__('File Uploaded!!'));
            } else {
                $this->messageManager->addError(__('File not Uploaded, Please try Again'));
            }
        } catch (\Exception $e) {
            die($e);
        }
    }
}
