<?php

namespace Rahi\Equote\Block;

use Magento\Framework\View\Element\Template;
use Rahi\Equote\Model\ResourceModel\Equote\CollectionFactory;

class Postform extends Template
{

    protected $scopeConfig;
    protected $collection;

    public function __construct(\Magento\Framework\View\Element\Template\Context $context, \Magento\Customer\Model\Session $customerSession, \Magento\Framework\Message\ManagerInterface $messageManager, \Rahi\Equote\Model\Equote $_equote_model,         CollectionFactory $blockCollectionFactory)
    {
        $this->scopeConfig = $context->getScopeConfig();
        $this->customerSession = $customerSession;
        $this->messageManager = $messageManager;
        $this->_equote_model = $_equote_model;
        $this->collection = $blockCollectionFactory->create();
        parent::__construct($context);
    }

    public function getFormAction()
    {
        return $this->getUrl('equote/index/post', ['_secure' => true]);
    }
    public function getCustomerId()
    {
        return $this->customerSession->getCustomer()->getId();
    }
    public function getCustomerName()
    {
        $customerFullName = $this->customerSession->getCustomer()->getFirstname() . ' ' . $this->customerSession->getCustomer()->getLastname();
        return $customerFullName;
    }
    public function getCollection()
    {
        $itemsCollection = $this->collection->getItems();
        return $itemsCollection;
    }
    public function getAvailableStatus()
    {
        $availableOptions = $this->_equote_model->getAvailableStatuses();
        return $availableOptions;
    }
    public function getViewUrl($equoteId)
    {
        return $this->getUrl('equote/view', ['equote_id' => $equoteId]);
    }
    public function getCustomerEmail()
    {
        $customerFullName = $this->customerSession->getCustomer()->getEmail();
        return $customerFullName;
    }
}
