<?php namespace Rahi\Equote\Controller\Customer;

use Magento\Framework\App\Action\Action;
use Magento\Quote\Model\QuoteRepository;

class Punchout extends Action
{
    protected $quoteRepository;
    protected $resultPageFactory;
    private   $productRepository; 
    protected $formKey;   
    protected $cart;

    public function __construct(
        \Magento\Framework\App\Action\Context $context,
        \Magento\Framework\View\Result\PageFactory $resultPageFactory,
        \Magento\Catalog\Api\ProductRepositoryInterface $productRepository,
        \Magento\Framework\Data\Form\FormKey $formKey,
        \Magento\Checkout\Model\Cart $cart,
	\Magento\Quote\Api\CartRepositoryInterface $quoteRepository
    )
    {
        $this->resultPageFactory = $resultPageFactory;
        $this->productRepository = $productRepository;
        $this->formKey = $formKey;
        $this->cart = $cart;
	$this->quoteRepository = $quoteRepository;
        parent::__construct($context);
    }

    public function execute()
    {
	try{
           $resultPage = $this->resultPageFactory->create();
           $data = $this->getRequest()->getParams();
           $equote_id = $data['equote_id'];
           $itemsDataCollection = $this->_objectManager->create('Rahi\Equote\Model\EquoteItems');
           $itemsDataCollection = $itemsDataCollection->getCollection()->addFieldToFilter('equote_id', $equote_id);
	   $EqouteData = $this->_objectManager->create('Rahi\Equote\Model\Equote');
	   $EqouteData = $EqouteData->getCollection()->addFieldToFilter('equote_id', $equote_id);
	   $EqouteDataResult = $EqouteData->getData();
	   $watchlist = ($EqouteDataResult['0']['watchlist_emails']) ? trim($EqouteDataResult['0']['watchlist_emails'], ',') : " " ;
           $this->cart->truncate();
           foreach ($itemsDataCollection->getData() as $dataItem){
		if(!empty($data['ready_to_punch'])){
        	        if(in_array($dataItem['mpn'], $data['ready_to_punch'])){
	        	    $product = $this->loadProduct($dataItem['mpn']);
	        	    $params = array(
	        	        'form_key' => $this->formKey->getFormKey(),
	        	        'product' => $product->getId(),
	        	        'qty'   =>$dataItem['requested_qty'],
			            );
			            $this->cart->addProduct($product, $params);
	        	}
	            }
	        }
	        $this->cart->save();
		$cartId = $this->cart->getQuote()->getId(); 
	        $quote = $this->quoteRepository->getActive($cartId);
	        $quote->setWatchlistEmails($watchlist);
		$quote->setIsEquote(1);
	        $this->quoteRepository->save($quote);

	}
	catch (\Exception $e) {
                $this->messageManager->addException($e, __('Product does not exists.'));
            }
        $this->_redirect("checkout/cart");
        return $resultPage;
    }
    public function loadProduct($sku)
    {
        return $this->productRepository->get($sku);
    }
}
