<?php

namespace Rahi\Equote\Model\Equote\Source;

use Magento\Framework\Data\OptionSourceInterface;

class Status implements OptionSourceInterface
{

    protected $_equote_model;
    
    public function __construct(\Rahi\Equote\Model\Equote $_equote_model)
    {

        $this->_equote_model = $_equote_model;
    }

    /**
     * Get options
     *
     * @return array
     */
    public function toOptionArray()
    {

        $availableOptions = $this->_equote_model->getAvailableStatuses();
        
        $options = [];
        foreach ($availableOptions as $key => $value) {
            $options[] = [
                'label' => $value,
                'value' => $key,
            ];
        }
        return $options;
    }
}
