<?php
namespace Rahi\Equote\Helper;

use Magento\Catalog\Helper\Image as OriginalImageHelper;
use Magento\Catalog\Model\Config\CatalogMediaConfig;
use Magento\Framework\App\ObjectManager;

class Image extends OriginalImageHelper
{
    /**
     * Retrieve default placeholder image URL
     *
     * @return string
     */
    private $viewAssetPlaceholderFactory;
    private $registry;
    public function __construct(
        \Magento\Framework\Registry $registry,
        \Magento\Framework\App\Helper\Context $context,
        \Magento\Catalog\Model\Product\ImageFactory $productImageFactory,
        \Magento\Framework\View\Asset\Repository $assetRepo,
        \Magento\Framework\View\ConfigInterface $viewConfig,
        \Magento\Catalog\Model\View\Asset\PlaceholderFactory $placeholderFactory = null,
        CatalogMediaConfig $mediaConfig = null

    ) {
            $this->registry = $registry;
            $this->viewAssetPlaceholderFactory = $placeholderFactory
            ?: ObjectManager::getInstance()->get(\Magento\Catalog\Model\View\Asset\PlaceholderFactory::class);
        $this->mediaConfig = $mediaConfig ?: ObjectManager::getInstance()->get(CatalogMediaConfig::class);
            parent::__construct($context,$productImageFactory,$assetRepo,$viewConfig,$placeholderFactory,$mediaConfig);
    }
    public function getDefaultPlaceholderUrl($placeholder = null)
    {
        
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();

        $storeManager = $objectManager->get('\Magento\Store\Model\StoreManagerInterface');

        // Get the base URL without the store code
        $baseUrlWithoutStoreCode = $storeManager->getStore()->getBaseUrl(\Magento\Framework\UrlInterface::URL_TYPE_LINK);

        // Get the media URL
        $mediaUrl = $storeManager->getStore()->getBaseUrl(\Magento\Framework\UrlInterface::URL_TYPE_MEDIA);
        $product = $this->getCurrentProduct();
        if (in_array(15, $product->getCategoryIds())) {
            return  $url=$mediaUrl.'catalog/product/placeholder/default/wesco.png';
        }
        try {
           
            $imageAsset = $this->viewAssetPlaceholderFactory->create(
                [
                    'type' => $placeholder ?: $this->_getModel()->getDestinationSubdir(),
                ]
            );
            
           
            $url = $imageAsset->getUrl();
        } catch (\Exception $e) {
            print_r($e);exit;
            $this->_logger->critical($e);
            $url = $this->_urlBuilder->getUrl('', ['_direct' => 'core/index/notFound']);
        }
        // print_r($url);
        // exit;
        return $url;
        // Return the path to your custom placeholder image
        //
    }
    public function getCurrentProduct()
      {
            return $this->registry->registry('current_product');
      }
}