<?php

namespace Rahi\Equote\Helper;

use Magento\Catalog\Model\Product;
use Magento\Catalog\Model\ProductFactory;
use Magento\Checkout\Model\Session;
use Magento\Quote\Api\CartRepositoryInterface;

class Sort extends \Magento\Framework\App\Helper\AbstractHelper
{

    protected $_productFactory;
    protected $checkoutSession;
    protected $cartRepository;


    public function __construct(
        ProductFactory $productFactory,
        \Magento\Framework\App\Helper\Context $context,
        Session $checkoutSession,
        CartRepositoryInterface $cartRepository,
        array $data = []
    ) {
        $this->_productFactory = $productFactory;
        $this->checkoutSession = $checkoutSession;
        $this->cartRepository = $cartRepository;
        parent::__construct($context);
    }
    public function getCategoryIdsByProductId($productId)
    {
        // Load the product by ID
        $product = $this->_productFactory->create()->load($productId);
        $target = array('13', '14');
        // Get category IDs associated with the product
        $categoryIds = $product->getCategoryIds();
       //print_r($productId);//exit;
        if(count(array_intersect($categoryIds, $target)) == 2){
            return true;
        }else{
            if (in_array('14', $categoryIds)) {
                    return false;
                }
            else {
                    return true;
            }
        }

        return true;
    }
    public function getCheckoutSessionProducts()
    {
        $quote = $this->checkoutSession->getQuote();
        $items = $quote->getAllItems();
        $products = 0;
        foreach ($items as $item) {
            $products =  $item->getProductId();
        }
        return $products;
    }

    /**
     * Get Quote Data From checkout session 
     * @return  array
     */
    public function getQuoteDetails()
    {
        $quote = $this->checkoutSession->getQuote();
        return $quote;
    }

}