<?php

namespace Rahi\Equote\Observer;

use Magento\Framework\Event\ObserverInterface;
use Magento\Catalog\Api\ProductRepositoryInterface;

/**
 * Observer class
 */
class Anixter implements ObserverInterface
{

    /**
     * var \Magento\Catalog\Api\ProductRepositoryInterface
     */
    protected $_productRepositoryInterface;
   

    /**
     * @param ProductRepositoryInterface $_productRepositoryInterface,
     
     */
    public function __construct(
        ProductRepositoryInterface $_productRepositoryInterface
    ) {
        $this->_productRepositoryInterface = $_productRepositoryInterface;
    }

    /**
     * For every add to cart product check if it is an Anixter product
     * if yes then set the flag to 1
     *
     * @param \Magento\Framework\Event\Observer $observer
     * @return void
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $item = $observer->getEvent()->getData('quote_item');
        $product = $observer->getEvent()->getData('product');
        $cartProduct = $this->_productRepositoryInterface->getById($product->getId());
        $categories = $cartProduct->getCategoryIds();
        $isAnixter = $cartProduct->getAnixterProduct();
        
        if ($isAnixter != null) {
            if ($item->getProductId() == $product->getId() && $isAnixter == "1") {
                $item->setIsAnixter(1);
            }
        } 
        if (!(in_array(13, $categories)) && in_array(14, $categories)) {
            if ($item->getProductId() == $product->getId()) {
                $item->setIsAnixter(1);
            }
        }        
    }
}
