<?php

namespace Rahi\Equote\Observer;

use Magento\Framework\Event\ObserverInterface;
use Magento\Quote\Model\ResourceModel\Quote\Item\CollectionFactory;

/**
 * Observer class
 */
class CartDeleteObserver implements ObserverInterface
{

    /**
     * var \Magento\Quote\Model\ResourceModel\Quote\Item\CollectionFactory
     */

    protected $_quoteItemCollectionFactory;
    /**
     * @var \Magento\Quote\Model\QuoteRepository
     */

    protected $_quoteRepository;

    /**
     * @param CollectionFactory $_quoteItemCollectionFactory,
     * @param QuoteRepository $_quoteRepository;
     */
    public function __construct(
        CollectionFactory $_quoteItemCollectionFactory,
        \Magento\Quote\Model\QuoteRepository $_quoteRepository
    ) {
        $this->_quoteItemCollectionFactory = $_quoteItemCollectionFactory;
        $this->_quoteRepository = $_quoteRepository;
    }

    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $quoteItem = $observer->getEvent()->getQuoteItem();
        $quoteId = $quoteItem->getQuoteId();


        $quoteItemCollection = $this->_quoteItemCollectionFactory->create();
        $quoteItemData = $quoteItemCollection->addFieldToFilter('quote_id', $quoteId)->getSize();

        if ($quoteItemData == 1) {
            $quote = $this->_quoteRepository->get($quoteId);
            $quote->setWatchlistEmails('');
            $this->_quoteRepository->save($quote);
        }


    }
}
