<?php

namespace Rahi\Equote\Plugin;

use Magento\Framework\Data\Tree\NodeFactory;
use Magento\Store\Model\StoreManagerInterface;


class EquoteLink
{
    protected  $storeManager;
    public function __construct(
        StoreManagerInterface $storeManager
    ) {
        $this->_storeManager = $storeManager;
    }
    public function afterGetHtml(\Magento\Theme\Block\Html\Topmenu $topmenu, $html)
    {
         $baseUrl =     $this->_storeManager->getStore()->getBaseUrl();
        $equoteLinkUrl = $baseUrl . 'equote/customer/index';
        $faqLinkUrl = $baseUrl . 'faq';
        $equoteLink = $topmenu->getUrl($equoteLinkUrl);
        //print_r($equoteLink);exit;
        $faqLink = $topmenu->getUrl($faqLinkUrl);
        $CurrentUrl = $topmenu->getUrl('*/*/*', ['_current' => true, '_use_rewrite' => true]);
        if (strpos($CurrentUrl, $baseUrl) !== false) {
            $html .= "<li class=\"level0 nav-9 category-item level-top ui-menu-item inactive\">";
        } else {
            $html .= "<li class=\"level0 nav-9 category-item level-top ui-menu-item\">";
        }
        $html .= "<a href=\"" . $equoteLink . "\" class=\"level-top ui-corner-all\"><span class=\"ui-menu-icon ui-icon ui-icon-carat-1-e\"></span><span>" . __("My eQuote") . "</span></a>";
        $html .= "</li>";

        if (strpos($CurrentUrl, $baseUrl) !== false) {
            $html .= "<li class=\"level0 nav-9 category-item level-top ui-menu-item inactive\">";
        } else {
            $html .= "<li class=\"level0 nav-9 category-item level-top ui-menu-item\">";
        }
        // $html .= "<a href=\"" . $faqLink . "\" class=\"level-top ui-corner-all\"><span class=\"ui-menu-icon ui-icon ui-icon-carat-1-e\"></span><span>" . __("FAQ") . "</span></a>";
        // $html .= "</li>";

        return $html;
    }
}


