<?php

namespace Rahi\Equote\Ui\Component\Listing\Column;

use \Magento\Framework\View\Element\UiComponent\ContextInterface;
use \Magento\Framework\View\Element\UiComponentFactory;
use \Magento\Ui\Component\Listing\Columns\Column;
use \Magento\Framework\Api\SearchCriteriaBuilder;
use \Rahi\Equote\Model\EquoteItemsFactory;

class Products extends Column
{
    protected $_searchCriteria;
    protected $_items;

    public function __construct(
        ContextInterface $context,
        UiComponentFactory $uiComponentFactory,
        SearchCriteriaBuilder $criteria,
        EquoteItemsFactory $items,
        array $components = [],
        array $data = [])
    {
        $this->_searchCriteria  = $criteria;
	$this->_items = $items;
        parent::__construct($context, $uiComponentFactory, $components, $data);
    }

    public function prepareDataSource(array $dataSource)
    {
        if (isset($dataSource['data']['items'])) {
            foreach ($dataSource['data']['items'] as &$items) {
                $productArr = [];
		$quote_items = [];
                $quote_items  = $this->_items->create()->getCollection()->addFieldToFilter('equote_id', ['=' => $items['equote_id'] ])->getData();
		foreach($quote_items as $quote_item){
	 	   $productArr[] = 'MPN: '.$quote_item['mpn'].', GPN: '.$quote_item['gpn'];
		}
               $items['products'] = implode('</br>',$productArr);
     	       unset($productArr);
            }
        }
        return $dataSource;
    }
}
