<?php
namespace Vendor\CustomSearch\Helper;
/**
 * class Helper Data
 */
use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Framework\App\Helper\Context;
use Magento\Store\Model\ScopeInterface;
use Magento\Framework\App\Request\DataPersistorInterface;

class Data extends AbstractHelper
{
    /**
     *  @var $dataPersistor DataPersistorInterface;
     */
    protected $dataPersistor;

    /**
     * __construct function
     *
     * @param Context $context
     * @param DataPersistorInterface $dataPersistor
     */
    public function __construct(
        Context $context,
        DataPersistorInterface $dataPersistor)
    {
        $this->dataPersistor = $dataPersistor;
        parent::__construct($context);
    }

    /**
     * setValue function
     *
     * @param [string] $parameter
     * @param [array] $value
     * @return array
     */
    public function setValue($parameter,$value)
    {
        $this->dataPersistor->set($parameter, $value);
    }

    /**
     * getValue function
     *
     * @param [string] $parameter
     * @return array
     */
    public function getValue($parameter)
    {
        return $this->dataPersistor->get($parameter);
    }

    /**
     * ClearValue function
     *
     * @param [string] $parameter
     * @return void
     */
    public function ClearValue($parameter)
    {
        $this->dataPersistor->clear($parameter);
    }

}