<?php
namespace Wesco\ImportManager\Block\Adminhtml;

use Magento\Backend\Block\Template\Context;
use Magento\Framework\View\Element\Template;
use Wesco\ImportManager\Helper\CsvHelper as CsvHelper;
use Magento\Framework\App\Request\DataPersistorInterface;
use Wesco\ImportManager\Model\ResourceModel\MyData\CollectionFactory as MyDataCollectionFactory;

class ImportForm extends Template
{
    protected $csvHelper;
    protected $dataPersistor;
    protected $myDataCollectionFactory;

    public function __construct(
        Context $context,
        CsvHelper $csvHelper,
        DataPersistorInterface $dataPersistor,
        MyDataCollectionFactory $myDataCollectionFactory,
        array $data = []
    ) {
        $this->csvHelper = $csvHelper;
        $this->dataPersistor = $dataPersistor;
        $this->myDataCollectionFactory = $myDataCollectionFactory;
        parent::__construct($context, $data);
    }

    public function getFormData()
    {
        return $this->dataPersistor->get('custom_import_form') ?? [];
    }

    public function getMyDataItems()
    {
        return $this->myDataCollectionFactory->create()->load();
    }

    public function getCsvData()
    { 
//         $formData = $this->getFormData();
//         //$filePath = $formData['csv_file'] ?? null;
// $tmpName = $_FILES['csv_file']['tmp_name'];
// $csvAsArray = array_map('str_getcsv', file($tmpName));
//         // if ($filePath && file_exists($filePath)) { print_r($filePath); die('hi');
//             //return $this->csvHelper->readCsv($csvAsArray);
//         // }
// print_r($csvAsArray); die('hi');
//         return [];

         if (isset($_FILES['csv_file']['tmp_name']) && is_uploaded_file($_FILES['csv_file']['tmp_name'])) {
        $tmpName = $_FILES['csv_file']['tmp_name'];

        $csvAsArray = array_map('str_getcsv', file($tmpName));
        return $this->csvHelper->parseCsvArray($csvAsArray); // ✅ Use new helper method
    }

    return [];
    }

    public function getImportItems()
    {
        $formData = $this->getFormData();

        if (!isset($formData['import_method'])) {
            return [];
        }

        if ($formData['import_method'] === 'csv_file') {
            return $this->getCsvData();
        }

        if ($formData['import_method'] === 'db_table') {
            return $this->getMyDataItems();
        }

        return [];
    }
}
