<?php
namespace Wesco\ImportManager\Block;

use Magento\Framework\View\Element\Template;
use Magento\Catalog\Model\ResourceModel\Product\Attribute\CollectionFactory;
use Magento\Framework\Data\Form\FormKey;

class AttributeDropdown extends Template
{
    protected $attributeCollectionFactory;

    protected $formKey;
    public function __construct(
        Template\Context $context,
        CollectionFactory $attributeCollectionFactory,
         FormKey $formKey,
        array $data = []
    ) {
        parent::__construct($context, $data);
        $this->formKey = $formKey;
        $this->attributeCollectionFactory = $attributeCollectionFactory;
    }

    public function getActiveProductAttributes()
    {
        $attributeCollection = $this->attributeCollectionFactory->create();
        $attributeCollection->addFieldToFilter('frontend_input', ['neq' => '']);
        $attributeCollection->setOrder('attribute_code', 'ASC');

        return $attributeCollection->getItems();
    }
     public function getFormActionUrl()
    {
        return $this->getUrl('importmanager/index/import');
    }
    public function getFormKey()
    {
        return $this->formKey->getFormKey();
    }
}
