<?php

namespace Wesco\ImportManager\Controller\Adminhtml\Index;

use Magento\Backend\App\Action;
use Magento\Catalog\Api\ProductRepositoryInterface;
use Wesco\ImportManager\Block\Adminhtml\ImportForm;
use Magento\Framework\Controller\Result\RawFactory;
use Magento\Catalog\Model\ProductFactory;

class Execute extends Action
{
    // const ADMIN_RESOURCE = 'Wesco_ImportManager::run';

    protected $productRepo;
    protected $importFormBlock;
    protected $resultRawFactory;


    public function __construct(
        Action\Context $context,
        ProductRepositoryInterface $productRepo,
        ImportForm $importFormBlock,
        RawFactory $resultRawFactory,
        ProductFactory $productFactory
    ) {
        parent::__construct($context);
        $this->productRepo = $productRepo;
        $this->importFormBlock = $importFormBlock;
        $this->resultRawFactory = $resultRawFactory;
        $this->productFactory = $productFactory;
    }

    public function execute()
    {
        $resultRaw = $this->resultRawFactory->create();

        $formData = $this->importFormBlock->getFormData();
        $items = $this->importFormBlock->getMyDataItems();
        $attributes = $formData['attributes'];
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
        $output = '';
        $productModel = $objectManager->create(\Magento\Catalog\Model\Product::class);
        foreach ($items as $item):
            $product = "";

            $product = $productModel->loadByAttribute('sku', $item[$attributes[0][2]]);
            $isExisting = $product && $product->getId();
            if (!$isExisting) {
                $product = $objectManager->create('Magento\Catalog\Model\Product');
            }
            // $shouldCreate = false;
            // $shouldUpdate = false;

            foreach ($attributes as $key => $value) {

                echo  $value[0];
                echo  $value[2];
                $behavior = $value[3];

                if (!$isExisting && $behavior === 'add_only' && $value[0] == 'sku') {
                    $shouldUpdate = true;
                    $product->setData($value[0], $item->getData($value[2]));
                    $product->setAttributeSetId(4);
                    $product->setTypeId('simple');
                    $product->setStatus(1);
                    $product->setVisibility(4);
                    $product->setWebsiteIds([1]);
                    $product->setStockData(['qty' => 100, 'is_in_stock' => 1]);
                } else if ($value[0] != 'sku') {

                    //$shouldCreate = true;
                    $product->setData($value[0], $item->getData($value[2]));
                }
            }

            try {
                $product->save();

                $output .=  "✅ Updated product with SKU " . $item[$attributes[0][2]] . "<br>";
            } catch (\Exception $e) {
                $output .=  "❌ Error with SKU " . $item[$attributes[0][2]] . ": " . $e->getMessage() . "<br>";
            }

        endforeach;

        return $resultRaw->setContents($output);
    }
}
