<?php

namespace Wesco\ImportManager\Controller\Adminhtml\Index;

use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\App\Request\DataPersistorInterface;

class Import extends Action
{
    protected $dataPersistor;

    public function __construct(
        Context $context,
        DataPersistorInterface $dataPersistor
    ) {
        parent::__construct($context);
        $this->dataPersistor = $dataPersistor;
    }

    public function execute()
    {

        $postData = $this->getRequest()->getPostValue();
        $fileData = $this->getRequest()->getFiles('csv_file');

        if ($postData) {
            // Initialize attributes array
            $attributes = [];

            // Check if 'product_attributes' exists and is an array
            if (!empty($postData['product_attributes']) && is_array($postData['product_attributes'])) {
                foreach ($postData['product_attributes'] as $index => $attributeCode) {
                    $csvFileName = isset($fileData['name']) ? $fileData['name'] : null;
                    $postData['csv_file'] = $csvFileName; // Store file name separately
                    // Store each row as a simple indexed array
                    $attributes[] = [
                        $attributeCode,
                        $postData['csv_column'][$index] ?? null,
                        $postData['db_column'][$index] ?? null,
                        $postData['import_behavior'][$index] ?? null,
                    ];
                }

                // Remove the individual keys from postData
                unset($postData['product_attributes']);
                unset($postData['csv_column']);
                unset($postData['db_column']);
                unset($postData['import_behavior']);
            }


            // Add the attributes array to postData
            $postData['attributes'] = $attributes;

            // Persist the form data
            $this->dataPersistor->set('custom_import_form', $postData);

            // Optionally, log or process the $postData array
            // $this->_logger->debug('Processed Post Data:', $postData);
        }

        // Return the appropriate result
        return $this->resultFactory->create(ResultFactory::TYPE_PAGE);
    }
}
