<?php
namespace Wesco\ImportManager\Helper;

use Magento\Framework\App\Helper\AbstractHelper;

class CsvHelper extends AbstractHelper
{
    public function __construct(
        \Magento\Framework\App\Helper\Context $context
    ) {
        parent::__construct($context);
    }

    /**
     * Parse a CSV array (not a file) into structured data
     *
     * @param array $csvAsArray
     * @return array
     */
    public function parseCsvArray(array $csvAsArray): array
    {
        if (empty($csvAsArray) || count($csvAsArray) < 2) {
            return []; // must have at least header + 1 row
        }

        $header = array_shift($csvAsArray); // remove header
        $data = [];

        foreach ($csvAsArray as $row) {
            $data[] = array_combine($header, $row);
        }

        return $data;
    }
}
