-- MySQL dump 10.13  Distrib 8.0.23, for Linux (x86_64)
--
-- Host: localhost    Database: sm_market_243_30
-- ------------------------------------------------------
-- Server version	8.0.23

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `admin_analytics_usage_version_log`
--

DROP TABLE IF EXISTS `admin_analytics_usage_version_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `admin_analytics_usage_version_log` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Log ID',
  `last_viewed_in_version` varchar(50) NOT NULL COMMENT 'Viewer last viewed on product version',
  PRIMARY KEY (`id`),
  UNIQUE KEY `ADMIN_ANALYTICS_USAGE_VERSION_LOG_LAST_VIEWED_IN_VERSION` (`last_viewed_in_version`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='Admin Notification Viewer Log Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_analytics_usage_version_log`
--

LOCK TABLES `admin_analytics_usage_version_log` WRITE;
/*!40000 ALTER TABLE `admin_analytics_usage_version_log` DISABLE KEYS */;
INSERT INTO `admin_analytics_usage_version_log` VALUES (1,'2.4.1');
/*!40000 ALTER TABLE `admin_analytics_usage_version_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_passwords`
--

DROP TABLE IF EXISTS `admin_passwords`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `admin_passwords` (
  `password_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Password ID',
  `user_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'User ID',
  `password_hash` varchar(255) DEFAULT NULL COMMENT 'Password Hash',
  `expires` int unsigned NOT NULL DEFAULT '0' COMMENT 'Deprecated',
  `last_updated` int unsigned NOT NULL DEFAULT '0' COMMENT 'Last Updated',
  PRIMARY KEY (`password_id`),
  KEY `ADMIN_PASSWORDS_USER_ID` (`user_id`),
  CONSTRAINT `ADMIN_PASSWORDS_USER_ID_ADMIN_USER_USER_ID` FOREIGN KEY (`user_id`) REFERENCES `admin_user` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COMMENT='Admin Passwords';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_passwords`
--

LOCK TABLES `admin_passwords` WRITE;
/*!40000 ALTER TABLE `admin_passwords` DISABLE KEYS */;
INSERT INTO `admin_passwords` VALUES (7,4,'99d5b388ecddce0ddac2d673d6f408677ab8e0a0f78fe1f91ffe18696020d5c5:7zjBDQq8nNT0BP9iZidJK9av12OQyRSi:3_32_2_67108864',0,1633404726),(8,4,'0a08bb59add5c67c63d9c631a2ff7855ef94431f3ff5715a0560627e7d92ff9d:qY8ymL0jOeAvk13AGsA4m6Koqr9I4MFW:3_32_2_67108864',0,1641192620),(9,5,'5c6f0d52b12346fd2145a160381c7a7a1be7fe999189e8553e4089424402300b:buOTTkwoTzLhJ9ytGZQJf32b9PkbMz73:3_32_2_67108864',0,1645843643);
/*!40000 ALTER TABLE `admin_passwords` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_system_messages`
--

DROP TABLE IF EXISTS `admin_system_messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `admin_system_messages` (
  `identity` varchar(100) NOT NULL COMMENT 'Message ID',
  `severity` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Problem type',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Create date',
  PRIMARY KEY (`identity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Admin System Messages';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_system_messages`
--

LOCK TABLES `admin_system_messages` WRITE;
/*!40000 ALTER TABLE `admin_system_messages` DISABLE KEYS */;
INSERT INTO `admin_system_messages` VALUES ('c79237a69f9c7b43241a29075febea12',1,'2022-03-14 09:19:12');
/*!40000 ALTER TABLE `admin_system_messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_user`
--

DROP TABLE IF EXISTS `admin_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `admin_user` (
  `user_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'User ID',
  `firstname` varchar(32) DEFAULT NULL COMMENT 'User First Name',
  `lastname` varchar(32) DEFAULT NULL COMMENT 'User Last Name',
  `email` varchar(128) DEFAULT NULL COMMENT 'User Email',
  `username` varchar(40) DEFAULT NULL COMMENT 'User Login',
  `password` varchar(255) NOT NULL COMMENT 'User Password',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'User Created Time',
  `modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'User Modified Time',
  `logdate` timestamp NULL DEFAULT NULL COMMENT 'User Last Login Time',
  `lognum` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'User Login Number',
  `reload_acl_flag` smallint NOT NULL DEFAULT '0' COMMENT 'Reload ACL',
  `is_active` smallint NOT NULL DEFAULT '1' COMMENT 'User Is Active',
  `extra` text COMMENT 'User Extra Data',
  `rp_token` text COMMENT 'Reset Password Link Token',
  `rp_token_created_at` timestamp NULL DEFAULT NULL COMMENT 'Reset Password Link Token Creation Date',
  `interface_locale` varchar(16) NOT NULL DEFAULT 'en_US' COMMENT 'Backend interface locale',
  `failures_num` smallint DEFAULT '0' COMMENT 'Failure Number',
  `first_failure` timestamp NULL DEFAULT NULL COMMENT 'First Failure',
  `lock_expires` timestamp NULL DEFAULT NULL COMMENT 'Expiration Lock Dates',
  `refresh_token` text COMMENT 'Email connector refresh token',
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `ADMIN_USER_USERNAME` (`username`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COMMENT='Admin User Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_user`
--

LOCK TABLES `admin_user` WRITE;
/*!40000 ALTER TABLE `admin_user` DISABLE KEYS */;
INSERT INTO `admin_user` VALUES (5,'admin','admin','admin@admin.com','ytcdemo','5c6f0d52b12346fd2145a160381c7a7a1be7fe999189e8553e4089424402300b:buOTTkwoTzLhJ9ytGZQJf32b9PkbMz73:3_32_2_67108864','2022-02-26 02:47:23','2022-03-14 03:47:52','2022-03-14 03:47:52',14,0,1,'{\"configState\":{\"themecore_theme_layout\":\"1\",\"themecore_product_listing\":\"1\",\"market_theme_install\":\"1\",\"market_mobile_theme_layout\":\"1\",\"market_theme_layout\":\"1\",\"market_product_information\":\"0\",\"system_full_page_cache\":\"1\",\"system_bulk\":\"1\",\"system_media_storage_configuration\":\"1\",\"system_upload_configuration\":\"1\",\"system_media_gallery\":\"1\",\"system_media_gallery_renditions\":\"1\",\"dev_css\":\"1\",\"dev_front_end_development_workflow\":\"0\",\"dev_restrict\":\"0\",\"dev_debug\":\"0\",\"dev_template\":\"1\",\"dev_translate_inline\":\"0\",\"dev_js\":\"1\",\"dev_image\":\"0\",\"dev_caching\":\"1\",\"dev_static\":\"0\",\"dev_grid\":\"0\",\"web_default\":\"1\",\"web_url\":\"0\",\"web_seo\":\"0\",\"web_unsecure\":\"0\",\"web_secure\":\"0\",\"web_cookie\":\"0\",\"web_browser_capabilities\":\"0\",\"themecore_general\":\"1\",\"themecore_product_detail\":\"1\",\"themecore_advanced\":\"1\",\"themecore_product_information\":\"1\",\"sales_identity\":\"1\",\"sales_zerograndtotal_creditmemo\":\"1\",\"sales_reorder\":\"1\",\"sales_general\":\"1\",\"sales_minimum_order\":\"1\",\"sales_orders\":\"1\",\"sales_gift_options\":\"1\",\"sales_totals_sort\":\"0\",\"sales_dashboard\":\"0\",\"sales_msrp\":\"0\",\"sales_instant_purchase\":\"0\",\"filterproducts_source\":\"1\",\"currency_options\":\"1\",\"currency_fixerio\":\"0\",\"currency_currencyconverterapi\":\"0\",\"currency_import\":\"0\"}}',NULL,NULL,'en_US',0,NULL,NULL,NULL);
/*!40000 ALTER TABLE `admin_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_user_expiration`
--

DROP TABLE IF EXISTS `admin_user_expiration`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `admin_user_expiration` (
  `user_id` int unsigned NOT NULL COMMENT 'User ID',
  `expires_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'User Expiration Date',
  PRIMARY KEY (`user_id`),
  CONSTRAINT `ADMIN_USER_EXPIRATION_USER_ID_ADMIN_USER_USER_ID` FOREIGN KEY (`user_id`) REFERENCES `admin_user` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Admin User expiration dates table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_user_expiration`
--

LOCK TABLES `admin_user_expiration` WRITE;
/*!40000 ALTER TABLE `admin_user_expiration` DISABLE KEYS */;
/*!40000 ALTER TABLE `admin_user_expiration` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_user_session`
--

DROP TABLE IF EXISTS `admin_user_session`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `admin_user_session` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `session_id` varchar(128) NOT NULL COMMENT 'Session ID value',
  `user_id` int unsigned DEFAULT NULL COMMENT 'Admin User ID',
  `status` smallint unsigned NOT NULL DEFAULT '1' COMMENT 'Current Session status',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created Time',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Update Time',
  `ip` varchar(15) NOT NULL COMMENT 'Remote user IP',
  PRIMARY KEY (`id`),
  KEY `ADMIN_USER_SESSION_SESSION_ID` (`session_id`),
  KEY `ADMIN_USER_SESSION_USER_ID` (`user_id`),
  CONSTRAINT `ADMIN_USER_SESSION_USER_ID_ADMIN_USER_USER_ID` FOREIGN KEY (`user_id`) REFERENCES `admin_user` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=382 DEFAULT CHARSET=utf8 COMMENT='Admin User sessions table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `adminnotification_inbox`
--

DROP TABLE IF EXISTS `adminnotification_inbox`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `adminnotification_inbox` (
  `notification_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Notification ID',
  `severity` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Problem type',
  `date_added` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Create date',
  `title` varchar(255) NOT NULL COMMENT 'Title',
  `description` text COMMENT 'Description',
  `url` varchar(255) DEFAULT NULL COMMENT 'Url',
  `is_read` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Flag if notification read',
  `is_remove` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Flag if notification might be removed',
  PRIMARY KEY (`notification_id`),
  KEY `ADMINNOTIFICATION_INBOX_SEVERITY` (`severity`),
  KEY `ADMINNOTIFICATION_INBOX_IS_READ` (`is_read`),
  KEY `ADMINNOTIFICATION_INBOX_IS_REMOVE` (`is_remove`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8 COMMENT='Adminnotification Inbox';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adminnotification_inbox`
--

LOCK TABLES `adminnotification_inbox` WRITE;
/*!40000 ALTER TABLE `adminnotification_inbox` DISABLE KEYS */;
INSERT INTO `adminnotification_inbox` VALUES (1,4,'2020-12-16 03:07:55','Disable Notice','To improve performance, collecting statistics for the Magento Report module is disabled by default. \nYou can enable it in System Config.','',0,0),(2,3,'2020-12-16 03:49:11','New version 2.9.7 of Magefan Magento 2 Blog Extension is now available.',' You can download the new version from Magefan Store or update it via composer. Get us in touch if you need our help with an update or you have any questions.\n                                    https://magefan.com/magento2-blog-extension?version=2.9.7\n                                 ','https://magefan.com/magento2-blog-extension?version=2.9.7',0,0),(3,4,'2020-12-16 03:49:11','FAQ: How to configure &quot;read more&quot; in your Magento 2 blog post',' If you still don&#039;t know how to configure read more functionality in your magento 2 blog post, please read this article.\n                    Online documentation for Magento 2 blog extension is also available on our website. http://goo.gl/XOEdpy ','http://magefan.com/blog/add-read-more-tag-to-blog-post-content/?from=notification1',0,0),(4,4,'2021-01-08 21:35:55','Happy new year! Is Your Website Selling as Much as It Can? Watch our on-demand webinar and learn how to turn your website into a conversion machine.','Watch our on-demand webinar: Is Your Website Selling As Much As It Can? Digital Strategist Ereika Stimley and eCommerce Consultant Corey Gelato will walk you through a website self-assessment and live demo that will help you uncover opportunities to increase conversions and grow revenues. Watch now: https://bit.ly/2EAujMc','https://bit.ly/2EAujMc',0,0),(5,4,'2021-01-14 01:32:42','You&#039;re invited to our webinar: Is Magento Commerce or Open Source right for you? ','Magento Commerce and Magento Open Source may sound alike, but each offers sharply distinct benefits. To get the facts, sign up for our webinar Is Magento Commerce or Open Source right for you? at 10:00 AM PT on February 4th. Register now: http://bit.ly/3icfnTM','http://bit.ly/3icfnTM',0,0),(6,4,'2021-02-10 15:06:05','Magento Commerce 2.4.2 delivers important security updates and features to help secure and optimize your store','Magento Open Source 2.4.2, along with security-only patches 2.3.6-p1 and 2.4.1-p1, is now generally available. The latest release of Magento Open Source includes important security enhancements along with new functionality and platform quality improvements. With these important updates we strongly recommend that you upgrade to ensure your sites maintain the highest level of security. You can review the release notes for more information about all of the enhancements. Learn how this release can help you save time and maximize resources at Magento.com/blog. ','https://devdocs.magento.com/guides/v2.4/release-notes/bk-release-notes.html',0,0),(7,4,'2021-02-10 15:08:37','Register now for Summit 2021 and stay ahead of commerce trends ','Learn best practices from digital commerce experts during two days of live keynotes, sessions, and sneak peeks. Understand the latest digital commerce trends, discover industry best practices, and network with peers around the world. Register now!','https://summit.adobe.com/na/?utm_source=m1o&amp;utm_medium=rss&amp;utm_campaign=NA_210427_12576_RSS_EVTR_ACOM_FM_Summit_2021_M1_OS',0,0),(8,4,'2021-02-22 23:52:27','Quarterly Business Planning - reach out to us today to get your free site assessment.','Would you like a free site assessment? Our best-in-breed commerce solution gives your business unmatched agility and scalability. It&#039;s time to experience limitless eCommerce with no comprises. Learn more: https://bit.ly/3lcgILt','https://bit.ly/3lcgILt',0,0),(9,4,'2021-03-23 00:33:54','You&#039;re invited to our webinar this week: How digital commerce can scale B2B selling','Digital commerce is fast becoming the default way to buy—even for B2B customers. In just 8 weeks, Byrne Electrical, the leading manufacturer of power and data solutions for numerous industries, launched an eCommerce portal for more than 1,100 of their customers. To learn how they did it, join George Fabis, Director of IT for Byrne, and Slava Kravchuk, CEO &amp; Founder of Atwix, a Magento Commerce solutions partner, for a live discussion on Thursday, March 25. Register Now: https://bit.ly/3r1MCvG','https://bit.ly/3r1MCvG',0,0),(10,3,'2021-04-12 08:15:30','New version 2.9.8 of Magefan Magento 2 Blog Extension is now available.',' You can download the new version from Magefan Store or update it via composer. Get us in touch if you need our help with an update or you have any questions.\n                                    https://magefan.com/magento2-blog-extension?version=2.9.8\n                                 ','https://magefan.com/magento2-blog-extension?version=2.9.8',0,0),(11,4,'2021-05-11 20:44:41','Magento Open Source 2.4.2-p1 &amp; 2.3.7 deliver important security updates','The latest releases of Magento Open Source – 2.3.7 and 2.4.2-p1 – are now generally available. The latest release of Magento Open Source includes important security updates. With these important updates we strongly recommend that you upgrade to ensure your sites maintain the highest level of security. You can review the release notes for more information about all of the updates. Learn how this release can help you save time and maximize resources at Magento.com/blog.','https://devdocs.magento.com/guides/v2.3/release-notes/bk-release-notes.html ',0,0),(12,3,'2021-05-24 03:01:35','New version 2.10.1 of Magefan Magento 2 Blog Extension is now available.',' You can download the new version from Magefan Store or update it via composer. Get us in touch if you need our help with an update or you have any questions.\n                                    https://magefan.com/magento2-blog-extension?version=2.10.1\n                                 ','https://magefan.com/magento2-blog-extension?version=2.10.1',0,0),(13,3,'2021-07-22 02:54:57','New version 2.10.2 of Magefan Magento 2 Blog Extension is now available.',' You can download the new version from Magefan Store or update it via composer. Get us in touch if you need our help with an update or you have any questions.\n                                    https://magefan.com/magento2-blog-extension?version=2.10.2\n                                 ','https://magefan.com/magento2-blog-extension?version=2.10.2',0,0),(14,3,'2021-08-03 00:00:00','New FREE Magento 2 Facebook Pixel Extension','Integrate Facebook Pixel just in a few clicks with the new FREE Magento 2 Facebook Pixel Extension. Hurry up to try it out! https://magefan.com/magento-2-facebook-pixel-extension','https://magefan.com/magento-2-facebook-pixel-extension?utm_source=website&amp;utm_medium=admin_notification&amp;utm_campaign=new_extension_fb_pixel',0,0),(15,4,'2021-08-10 17:53:11','Magento Open Source 2.4.3 available today!','Magento Open Source 2.4.3, along with security-only patches 2.4.2-p1 and 2.3.7-p2, is now generally available. Magento Open Source 2.4.3 includes 33 security and 370+ quality improvements, along with performance and scale enhancements.  With these important updates, we strongly recommend that you upgrade to maintain the highest level of security for your sites. Learn how this release can help you save time and maximize resources in our release blog. ','http://magento.com/blog/magento-news/get-ready-your-peak-season-adobe-commerce-243',0,0),(16,3,'2021-09-16 07:10:33','New version 2.10.3 of Magefan Magento 2 Blog Extension is now available.',' You can download the new version from Magefan Store or update it via composer. Get us in touch if you need our help with an update or you have any questions.\n                                    https://magefan.com/magento2-blog-extension?version=2.10.3\n                                 ','https://magefan.com/magento2-blog-extension?version=2.10.3',0,0),(17,4,'2021-10-22 19:06:48','Magento Technology Stack Evaluation Survey','Please take a few minutes to fill out this survey https://forms.office.com/r/DLN8K3h2h0. We appreciate your effort to support the future of Adobe Commerce!','https://forms.office.com/r/DLN8K3h2h0',0,0),(18,3,'2021-11-17 07:05:17','New version 2.10.4 of Magefan Magento 2 Blog Extension is now available.',' You can download the new version from Magefan Store or update it via composer. Get us in touch if you need our help with an update or you have any questions.\n                                    https://magefan.com/magento2-blog-extension?version=2.10.4\n                                 ','https://magefan.com/magento2-blog-extension?version=2.10.4',0,0),(19,4,'2021-11-17 00:00:00','Guess whose birthday it is today? Magefan&#039;s!','Hurry up to get FREE Installation Service with any of Magento 2 extension purchased on November 2021! ','https://magefan.com/magento2-extensions?utm_source=website_admin&amp;utm_medium=a_notification&amp;utm_campaign=magefan6&amp;utm_id=magefan%27sbday',0,0),(20,4,'2021-11-22 00:00:00','This Deal’s Unreal! ','Save up to 50% OFF all Magento 2 extensions this Black Friday. Explore the best offers of the year now! https://bit.ly/3HLUQ4Y','https://magefan.com/magento2-extensions?utm_source=admn-ntf&amp;utm_medium=notice&amp;utm_campaign=black-friday-sale&amp;utm_id=bf-2021',0,0),(21,4,'2021-11-28 00:00:00','Missed Black Friday Deals? Cyber Monday is here.','Save up to 30% off all Magento 2 extensions - this week only. Buy more and pay less this last BIG sale of the year! Visit our website https://bit.ly/3p78GWZ','https://magefan.com/magento2-extensions?utm_source=admn-ntfct&amp;utm_medium=notice&amp;utm_campaign=cyber-monday-sale&amp;utm_id=cm-2021',0,0),(22,4,'2021-12-06 00:00:00','NEW Magento 2 AMP Blog Release! ','This extension integrates our Magento 2 Blog Extension with Magento 2 AMP extension by  Plumrocket, our trusted partner.  Improve your Blog on mobile devices for better user engagement!  https://bit.ly/3y2Yy5z','https://magefan.com/magento-2-amp-blog-extension?utm_source=admin&amp;utm_medium=notifications&amp;utm_id=new-release-ampblog',0,0),(23,4,'2021-12-15 00:00:00','Save up to 15% OFF select M2 extensions - Happy Holidays from the Magefan team!  ','Wishing you and your families peaceful and joyful holidays! Check out our Christmas Sale https://bit.ly/3s51aPw','https://magefan.com/magento2-extensions?utm_source=admin-notif&amp;utm_medium=ntf&amp;utm_campaign=christmas-sale&amp;utm_id=15off ',0,0),(24,3,'2022-02-26 03:22:02','New version 2.10.5 of Magefan Magento 2 Blog Extension is now available.',' You can download the new version from Magefan Store or update it via composer. Get us in touch if you need our help with an update or you have any questions.\n                                    https://magefan.com/magento2-blog-extension?version=2.10.5\n                                 ','https://magefan.com/magento2-blog-extension?version=2.10.5',0,0),(25,2,'2022-03-01 23:33:53','Magento Open Source 2.4.4 Coming April 12','To help ensure this release delivers the highest standards of security and quality, general availability of Magento Open Source is now planned for April 12. For more information, visit our DevBlog. ','https://community.magento.com/t5/Magento-DevBlog/Adobe-Commerce-2-4-4-Now-Coming-April-12/ba-p/492935',0,0),(26,3,'2022-03-14 03:48:01','New version 2.10.6 of Magefan Magento 2 Blog Extension is now available.',' You can download the new version from Magefan Store or update it via composer. Get us in touch if you need our help with an update or you have any questions.\n                                    https://magefan.com/magento2-blog-extension?version=2.10.6\n                                 ','https://magefan.com/magento2-blog-extension?version=2.10.6',0,0);
/*!40000 ALTER TABLE `adminnotification_inbox` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adobe_stock_asset`
--

DROP TABLE IF EXISTS `adobe_stock_asset`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `adobe_stock_asset` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `media_gallery_id` int unsigned DEFAULT NULL COMMENT 'Media gallery ID',
  `category_id` int unsigned DEFAULT NULL COMMENT 'Category ID',
  `creator_id` int unsigned DEFAULT NULL COMMENT 'Creator ID',
  `is_licensed` int unsigned NOT NULL DEFAULT '0' COMMENT 'Is Licensed',
  `creation_date` varchar(255) DEFAULT NULL COMMENT 'Creation Date',
  PRIMARY KEY (`id`),
  KEY `ADOBE_STOCK_ASSET_MEDIA_GALLERY_ID_MEDIA_GALLERY_ASSET_ID` (`media_gallery_id`),
  KEY `ADOBE_STOCK_ASSET_ID` (`id`),
  KEY `ADOBE_STOCK_ASSET_CATEGORY_ID` (`category_id`),
  KEY `ADOBE_STOCK_ASSET_CREATOR_ID` (`creator_id`),
  CONSTRAINT `ADOBE_STOCK_ASSET_CATEGORY_ID_ADOBE_STOCK_CATEGORY_ID` FOREIGN KEY (`category_id`) REFERENCES `adobe_stock_category` (`id`) ON DELETE SET NULL,
  CONSTRAINT `ADOBE_STOCK_ASSET_CREATOR_ID_ADOBE_STOCK_CREATOR_ID` FOREIGN KEY (`creator_id`) REFERENCES `adobe_stock_creator` (`id`) ON DELETE SET NULL,
  CONSTRAINT `ADOBE_STOCK_ASSET_MEDIA_GALLERY_ID_MEDIA_GALLERY_ASSET_ID` FOREIGN KEY (`media_gallery_id`) REFERENCES `media_gallery_asset` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Adobe Stock Asset';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adobe_stock_asset`
--

LOCK TABLES `adobe_stock_asset` WRITE;
/*!40000 ALTER TABLE `adobe_stock_asset` DISABLE KEYS */;
/*!40000 ALTER TABLE `adobe_stock_asset` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adobe_stock_category`
--

DROP TABLE IF EXISTS `adobe_stock_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `adobe_stock_category` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `name` varchar(255) DEFAULT NULL COMMENT 'Name',
  PRIMARY KEY (`id`),
  KEY `ADOBE_STOCK_CATEGORY_ID` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Adobe Stock Category';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adobe_stock_category`
--

LOCK TABLES `adobe_stock_category` WRITE;
/*!40000 ALTER TABLE `adobe_stock_category` DISABLE KEYS */;
/*!40000 ALTER TABLE `adobe_stock_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adobe_stock_creator`
--

DROP TABLE IF EXISTS `adobe_stock_creator`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `adobe_stock_creator` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `name` varchar(255) DEFAULT NULL COMMENT 'Asset creator''s name',
  PRIMARY KEY (`id`),
  KEY `ADOBE_STOCK_CREATOR_ID` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Adobe Stock Creator';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adobe_stock_creator`
--

LOCK TABLES `adobe_stock_creator` WRITE;
/*!40000 ALTER TABLE `adobe_stock_creator` DISABLE KEYS */;
/*!40000 ALTER TABLE `adobe_stock_creator` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adobe_user_profile`
--

DROP TABLE IF EXISTS `adobe_user_profile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `adobe_user_profile` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `admin_user_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Admin User Id',
  `name` varchar(255) NOT NULL COMMENT 'Display Name',
  `email` varchar(255) NOT NULL COMMENT 'user profile email',
  `image` varchar(255) NOT NULL COMMENT 'user profile avatar',
  `account_type` varchar(255) DEFAULT NULL COMMENT 'Account Type',
  `access_token` text COMMENT 'Access Token',
  `refresh_token` text COMMENT 'Refresh Token',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created At',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Updated At',
  `access_token_expires_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'Access Token Expires At',
  PRIMARY KEY (`id`),
  KEY `ADOBE_USER_PROFILE_ADMIN_USER_ID_ADMIN_USER_USER_ID` (`admin_user_id`),
  KEY `ADOBE_USER_PROFILE_ID` (`id`),
  CONSTRAINT `ADOBE_USER_PROFILE_ADMIN_USER_ID_ADMIN_USER_USER_ID` FOREIGN KEY (`admin_user_id`) REFERENCES `admin_user` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Adobe IMS User Profile';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adobe_user_profile`
--

LOCK TABLES `adobe_user_profile` WRITE;
/*!40000 ALTER TABLE `adobe_user_profile` DISABLE KEYS */;
/*!40000 ALTER TABLE `adobe_user_profile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `amazon_customer`
--

DROP TABLE IF EXISTS `amazon_customer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `amazon_customer` (
  `entity_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity_id',
  `customer_id` int unsigned NOT NULL COMMENT 'Customer_id',
  `amazon_id` varchar(255) NOT NULL COMMENT 'Amazon_id',
  PRIMARY KEY (`entity_id`),
  UNIQUE KEY `AMAZON_CUSTOMER_CUSTOMER_ID_AMAZON_ID` (`customer_id`,`amazon_id`),
  UNIQUE KEY `AMAZON_CUSTOMER_CUSTOMER_ID` (`customer_id`),
  CONSTRAINT `AMAZON_CUSTOMER_CUSTOMER_ID_CUSTOMER_ENTITY_ENTITY_ID` FOREIGN KEY (`customer_id`) REFERENCES `customer_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='amazon_customer';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `amazon_customer`
--

LOCK TABLES `amazon_customer` WRITE;
/*!40000 ALTER TABLE `amazon_customer` DISABLE KEYS */;
/*!40000 ALTER TABLE `amazon_customer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `amazon_pending_authorization`
--

DROP TABLE IF EXISTS `amazon_pending_authorization`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `amazon_pending_authorization` (
  `entity_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity_id',
  `order_id` int unsigned NOT NULL COMMENT 'Order_id',
  `payment_id` int unsigned NOT NULL COMMENT 'Payment_id',
  `authorization_id` varchar(255) DEFAULT NULL COMMENT 'Authorization_id',
  `created_at` datetime NOT NULL COMMENT 'Created_at',
  `updated_at` datetime DEFAULT NULL COMMENT 'Updated_at',
  `processed` smallint unsigned DEFAULT '0' COMMENT 'Initial authorization processed',
  `capture` smallint unsigned DEFAULT '0' COMMENT 'Initial authorization has capture',
  `capture_id` varchar(255) DEFAULT NULL COMMENT 'Initial authorization capture id',
  PRIMARY KEY (`entity_id`),
  UNIQUE KEY `UNQ_E6CCA08713FB32BB136A56837009C371` (`order_id`,`payment_id`,`authorization_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='amazon_pending_authorization';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `amazon_pending_authorization`
--

LOCK TABLES `amazon_pending_authorization` WRITE;
/*!40000 ALTER TABLE `amazon_pending_authorization` DISABLE KEYS */;
/*!40000 ALTER TABLE `amazon_pending_authorization` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `amazon_pending_capture`
--

DROP TABLE IF EXISTS `amazon_pending_capture`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `amazon_pending_capture` (
  `entity_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity_id',
  `capture_id` varchar(255) NOT NULL COMMENT 'Capture_id',
  `created_at` datetime NOT NULL COMMENT 'Created_at',
  `order_id` int unsigned NOT NULL COMMENT 'order id',
  `payment_id` int unsigned NOT NULL COMMENT 'payment id',
  PRIMARY KEY (`entity_id`),
  UNIQUE KEY `AMAZON_PENDING_CAPTURE_ORDER_ID_PAYMENT_ID_CAPTURE_ID` (`order_id`,`payment_id`,`capture_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='amazon_pending_capture';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `amazon_pending_capture`
--

LOCK TABLES `amazon_pending_capture` WRITE;
/*!40000 ALTER TABLE `amazon_pending_capture` DISABLE KEYS */;
/*!40000 ALTER TABLE `amazon_pending_capture` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `amazon_pending_refund`
--

DROP TABLE IF EXISTS `amazon_pending_refund`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `amazon_pending_refund` (
  `entity_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity_id',
  `refund_id` varchar(255) NOT NULL COMMENT 'Refund_id',
  `created_at` datetime NOT NULL COMMENT 'Created_at',
  `order_id` int unsigned NOT NULL COMMENT 'Order_id',
  `payment_id` int unsigned NOT NULL COMMENT 'Payment_id',
  PRIMARY KEY (`entity_id`),
  UNIQUE KEY `AMAZON_PENDING_REFUND_ORDER_ID_PAYMENT_ID_REFUND_ID` (`order_id`,`payment_id`,`refund_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='amazon_pending_refund';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `amazon_pending_refund`
--

LOCK TABLES `amazon_pending_refund` WRITE;
/*!40000 ALTER TABLE `amazon_pending_refund` DISABLE KEYS */;
/*!40000 ALTER TABLE `amazon_pending_refund` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `amazon_quote`
--

DROP TABLE IF EXISTS `amazon_quote`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `amazon_quote` (
  `entity_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `quote_id` int unsigned NOT NULL COMMENT 'Quote ID',
  `amazon_order_reference_id` varchar(255) NOT NULL COMMENT 'Amazon Order Reference ID',
  `sandbox_simulation_reference` varchar(255) DEFAULT NULL COMMENT 'Sandbox simulation reference',
  `confirmed` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Quote confirmed with Amazon',
  PRIMARY KEY (`entity_id`),
  UNIQUE KEY `AMAZON_QUOTE_QUOTE_ID` (`quote_id`),
  CONSTRAINT `AMAZON_QUOTE_QUOTE_ID_QUOTE_ENTITY_ID` FOREIGN KEY (`quote_id`) REFERENCES `quote` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='amazon_quote';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `amazon_quote`
--

LOCK TABLES `amazon_quote` WRITE;
/*!40000 ALTER TABLE `amazon_quote` DISABLE KEYS */;
/*!40000 ALTER TABLE `amazon_quote` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `amazon_sales_order`
--

DROP TABLE IF EXISTS `amazon_sales_order`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `amazon_sales_order` (
  `entity_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `order_id` int unsigned NOT NULL COMMENT 'Order ID',
  `amazon_order_reference_id` varchar(255) NOT NULL COMMENT 'Amazon Order Reference ID',
  PRIMARY KEY (`entity_id`),
  UNIQUE KEY `AMAZON_SALES_ORDER_ORDER_ID` (`order_id`),
  CONSTRAINT `AMAZON_SALES_ORDER_ORDER_ID_SALES_ORDER_ENTITY_ID` FOREIGN KEY (`order_id`) REFERENCES `sales_order` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='amazon_sales_order';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `amazon_sales_order`
--

LOCK TABLES `amazon_sales_order` WRITE;
/*!40000 ALTER TABLE `amazon_sales_order` DISABLE KEYS */;
/*!40000 ALTER TABLE `amazon_sales_order` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `authorization_role`
--

DROP TABLE IF EXISTS `authorization_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `authorization_role` (
  `role_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Role ID',
  `parent_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Parent Role ID',
  `tree_level` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Role Tree Level',
  `sort_order` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Role Sort Order',
  `role_type` varchar(1) NOT NULL DEFAULT '0' COMMENT 'Role Type',
  `user_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'User ID',
  `user_type` varchar(16) DEFAULT NULL COMMENT 'User Type',
  `role_name` varchar(50) DEFAULT NULL COMMENT 'Role Name',
  PRIMARY KEY (`role_id`),
  KEY `AUTHORIZATION_ROLE_PARENT_ID_SORT_ORDER` (`parent_id`,`sort_order`),
  KEY `AUTHORIZATION_ROLE_TREE_LEVEL` (`tree_level`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COMMENT='Admin Role Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `authorization_role`
--

LOCK TABLES `authorization_role` WRITE;
/*!40000 ALTER TABLE `authorization_role` DISABLE KEYS */;
INSERT INTO `authorization_role` VALUES (1,0,1,1,'G',0,'2','Administrators'),(2,1,2,0,'U',1,'2','admin'),(3,1,2,0,'U',2,'2','admin'),(4,1,2,0,'U',3,'2','admin'),(5,1,2,0,'U',4,'2','admin'),(6,1,2,0,'U',5,'2','ytcdemo');
/*!40000 ALTER TABLE `authorization_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `authorization_rule`
--

DROP TABLE IF EXISTS `authorization_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `authorization_rule` (
  `rule_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Rule ID',
  `role_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Role ID',
  `resource_id` varchar(255) DEFAULT NULL COMMENT 'Resource ID',
  `privileges` varchar(20) DEFAULT NULL COMMENT 'Privileges',
  `permission` varchar(10) DEFAULT NULL COMMENT 'Permission',
  PRIMARY KEY (`rule_id`),
  KEY `AUTHORIZATION_RULE_RESOURCE_ID_ROLE_ID` (`resource_id`,`role_id`),
  KEY `AUTHORIZATION_RULE_ROLE_ID_RESOURCE_ID` (`role_id`,`resource_id`),
  CONSTRAINT `AUTHORIZATION_RULE_ROLE_ID_AUTHORIZATION_ROLE_ROLE_ID` FOREIGN KEY (`role_id`) REFERENCES `authorization_role` (`role_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='Admin Rule Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `authorization_rule`
--

LOCK TABLES `authorization_rule` WRITE;
/*!40000 ALTER TABLE `authorization_rule` DISABLE KEYS */;
INSERT INTO `authorization_rule` VALUES (1,1,'Magento_Backend::all',NULL,'allow');
/*!40000 ALTER TABLE `authorization_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `braintree_credit_prices`
--

DROP TABLE IF EXISTS `braintree_credit_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `braintree_credit_prices` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Row ID',
  `product_id` int unsigned NOT NULL COMMENT 'Product Id',
  `term` int NOT NULL COMMENT 'Credit Term',
  `monthly_payment` decimal(12,2) NOT NULL COMMENT 'Monthly Payment',
  `instalment_rate` decimal(12,2) NOT NULL COMMENT 'Instalment Rate',
  `cost_of_purchase` decimal(12,2) NOT NULL COMMENT 'Cost of purchase',
  `total_inc_interest` decimal(12,2) NOT NULL COMMENT 'Total Inc Interest',
  PRIMARY KEY (`id`),
  UNIQUE KEY `BRAINTREE_CREDIT_PRICES_PRODUCT_ID_TERM` (`product_id`,`term`),
  KEY `BRAINTREE_CREDIT_PRICES_PRODUCT_ID` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Braintree credit rates';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `braintree_credit_prices`
--

LOCK TABLES `braintree_credit_prices` WRITE;
/*!40000 ALTER TABLE `braintree_credit_prices` DISABLE KEYS */;
/*!40000 ALTER TABLE `braintree_credit_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `braintree_transaction_details`
--

DROP TABLE IF EXISTS `braintree_transaction_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `braintree_transaction_details` (
  `entity_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `order_id` int unsigned NOT NULL COMMENT 'Order Id',
  `transaction_source` varchar(12) DEFAULT NULL COMMENT 'Transaction Source',
  PRIMARY KEY (`entity_id`),
  KEY `BRAINTREE_TRANSACTION_DETAILS_ORDER_ID` (`order_id`),
  CONSTRAINT `BRAINTREE_TRANSACTION_DETAILS_ORDER_ID_SALES_ORDER_ENTITY_ID` FOREIGN KEY (`order_id`) REFERENCES `sales_order` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Braintree transaction details table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `braintree_transaction_details`
--

LOCK TABLES `braintree_transaction_details` WRITE;
/*!40000 ALTER TABLE `braintree_transaction_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `braintree_transaction_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache`
--

DROP TABLE IF EXISTS `cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cache` (
  `id` varchar(200) NOT NULL COMMENT 'Cache Id',
  `data` mediumblob COMMENT 'Cache Data',
  `create_time` int DEFAULT NULL COMMENT 'Cache Creation Time',
  `update_time` int DEFAULT NULL COMMENT 'Time of Cache Updating',
  `expire_time` int DEFAULT NULL COMMENT 'Cache Expiration Time',
  PRIMARY KEY (`id`),
  KEY `CACHE_EXPIRE_TIME` (`expire_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Caches';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache`
--

LOCK TABLES `cache` WRITE;
/*!40000 ALTER TABLE `cache` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache_tag`
--

DROP TABLE IF EXISTS `cache_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cache_tag` (
  `tag` varchar(100) NOT NULL COMMENT 'Tag',
  `cache_id` varchar(200) NOT NULL COMMENT 'Cache Id',
  PRIMARY KEY (`tag`,`cache_id`),
  KEY `CACHE_TAG_CACHE_ID` (`cache_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tag Caches';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_tag`
--

LOCK TABLES `cache_tag` WRITE;
/*!40000 ALTER TABLE `cache_tag` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `captcha_log`
--

DROP TABLE IF EXISTS `captcha_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `captcha_log` (
  `type` varchar(32) NOT NULL COMMENT 'Type',
  `value` varchar(255) NOT NULL COMMENT 'Value',
  `count` int unsigned NOT NULL DEFAULT '0' COMMENT 'Count',
  `updated_at` timestamp NULL DEFAULT NULL COMMENT 'Update Time',
  PRIMARY KEY (`type`,`value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Count Login Attempts';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `captcha_log`
--

LOCK TABLES `captcha_log` WRITE;
/*!40000 ALTER TABLE `captcha_log` DISABLE KEYS */;
INSERT INTO `captcha_log` VALUES ('2','admin',3,'2022-02-26 03:16:19'),('2','admin123',1,'2021-01-27 10:24:30');
/*!40000 ALTER TABLE `captcha_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_entity`
--

DROP TABLE IF EXISTS `catalog_category_entity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_entity` (
  `entity_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `attribute_set_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute Set ID',
  `parent_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Parent Category ID',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Creation Time',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Update Time',
  `path` varchar(255) NOT NULL COMMENT 'Tree Path',
  `position` int NOT NULL COMMENT 'Position',
  `level` int NOT NULL DEFAULT '0' COMMENT 'Tree Level',
  `children_count` int NOT NULL COMMENT 'Child Count',
  PRIMARY KEY (`entity_id`),
  KEY `CATALOG_CATEGORY_ENTITY_LEVEL` (`level`),
  KEY `CATALOG_CATEGORY_ENTITY_PATH` (`path`)
) ENGINE=InnoDB AUTO_INCREMENT=300 DEFAULT CHARSET=utf8 COMMENT='Catalog Category Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_entity`
--

LOCK TABLES `catalog_category_entity` WRITE;
/*!40000 ALTER TABLE `catalog_category_entity` DISABLE KEYS */;
INSERT INTO `catalog_category_entity` VALUES (1,3,0,'2020-12-16 03:06:55','2022-03-02 02:26:41','1',0,0,297),(2,3,1,'2020-12-16 03:06:57','2022-03-02 02:26:41','1/2',1,1,296),(3,3,2,'2020-12-16 07:17:43','2021-09-24 09:50:53','1/2/3',1,2,30),(4,3,2,'2020-12-16 07:17:57','2022-01-05 02:37:01','1/2/4',2,2,30),(5,3,2,'2020-12-16 07:18:08','2021-10-18 07:28:17','1/2/5',3,2,9),(6,3,2,'2020-12-16 07:18:20','2021-12-16 04:03:20','1/2/6',4,2,4),(7,3,2,'2020-12-16 07:18:37','2022-01-05 02:37:47','1/2/7',5,2,29),(8,3,2,'2020-12-16 07:18:58','2021-08-17 02:13:01','1/2/8',6,2,10),(9,3,2,'2020-12-16 07:19:25','2022-01-05 02:36:41','1/2/9',7,2,30),(10,3,2,'2020-12-16 07:19:41','2022-01-05 02:36:33','1/2/10',8,2,0),(11,3,2,'2020-12-16 07:20:02','2022-01-05 02:38:09','1/2/11',9,2,5),(12,3,2,'2020-12-16 07:20:24','2022-01-05 02:37:59','1/2/12',10,2,0),(13,3,2,'2020-12-16 07:20:45','2022-01-05 02:36:48','1/2/13',11,2,0),(14,3,2,'2020-12-16 07:20:58','2022-01-05 02:37:07','1/2/14',12,2,0),(15,3,2,'2020-12-16 07:21:13','2022-01-05 02:36:54','1/2/15',13,2,4),(16,3,2,'2020-12-16 07:21:34','2021-12-16 04:02:54','1/2/16',14,2,15),(17,3,2,'2020-12-16 07:21:46','2022-01-05 02:38:20','1/2/17',15,2,0),(18,3,3,'2020-12-16 07:24:31','2021-01-14 02:17:10','1/2/3/18',1,3,5),(19,3,3,'2020-12-16 07:25:05','2021-01-14 02:23:45','1/2/3/19',2,3,8),(20,3,3,'2020-12-16 07:26:49','2021-06-22 09:11:30','1/2/3/20',4,3,5),(21,3,3,'2020-12-16 07:27:05','2021-01-14 02:22:42','1/2/3/21',3,3,8),(22,3,18,'2021-01-14 02:15:54','2021-01-14 02:15:54','1/2/3/18/22',1,4,0),(23,3,18,'2021-01-14 02:16:21','2021-01-14 02:16:21','1/2/3/18/23',2,4,0),(24,3,18,'2021-01-14 02:16:37','2021-01-14 02:16:37','1/2/3/18/24',3,4,0),(25,3,18,'2021-01-14 02:16:51','2021-01-14 02:16:51','1/2/3/18/25',4,4,0),(26,3,18,'2021-01-14 02:17:10','2021-01-14 02:17:10','1/2/3/18/26',5,4,0),(27,3,19,'2021-01-14 02:17:28','2021-01-14 02:17:28','1/2/3/19/27',1,4,0),(28,3,19,'2021-01-14 02:17:41','2021-01-14 02:17:41','1/2/3/19/28',2,4,0),(29,3,19,'2021-01-14 02:17:57','2021-01-14 02:17:57','1/2/3/19/29',3,4,0),(30,3,19,'2021-01-14 02:18:35','2021-01-14 02:18:35','1/2/3/19/30',4,4,0),(31,3,19,'2021-01-14 02:18:51','2021-01-14 02:18:51','1/2/3/19/31',5,4,0),(32,3,19,'2021-01-14 02:19:08','2021-01-14 02:19:08','1/2/3/19/32',6,4,0),(33,3,19,'2021-01-14 02:19:26','2021-01-14 02:19:26','1/2/3/19/33',7,4,0),(34,3,21,'2021-01-14 02:19:43','2021-01-14 02:19:43','1/2/3/21/34',1,4,0),(35,3,21,'2021-01-14 02:20:12','2021-01-14 02:20:12','1/2/3/21/35',2,4,0),(36,3,21,'2021-01-14 02:20:25','2021-01-14 02:20:25','1/2/3/21/36',3,4,0),(37,3,21,'2021-01-14 02:20:45','2021-01-14 02:20:45','1/2/3/21/37',4,4,0),(38,3,21,'2021-01-14 02:21:01','2021-01-14 02:21:01','1/2/3/21/38',5,4,0),(39,3,21,'2021-01-14 02:21:45','2021-01-14 02:21:45','1/2/3/21/39',6,4,0),(40,3,21,'2021-01-14 02:22:17','2021-01-14 02:22:17','1/2/3/21/40',7,4,0),(41,3,21,'2021-01-14 02:22:42','2021-01-14 02:22:42','1/2/3/21/41',8,4,0),(42,3,19,'2021-01-14 02:23:45','2021-01-14 02:23:45','1/2/3/19/42',8,4,0),(43,3,20,'2021-01-14 02:24:44','2021-06-22 08:47:49','1/2/3/20/43',1,4,0),(44,3,20,'2021-01-14 02:24:58','2021-06-22 08:48:18','1/2/3/20/44',2,4,0),(45,3,20,'2021-01-14 02:25:41','2021-06-22 08:48:39','1/2/3/20/45',3,4,0),(46,3,20,'2021-01-14 02:25:55','2021-06-22 08:48:55','1/2/3/20/46',4,4,0),(47,3,20,'2021-01-14 02:26:15','2021-06-22 08:49:16','1/2/3/20/47',5,4,0),(48,3,9,'2021-01-14 08:26:44','2021-01-14 08:30:26','1/2/9/48',1,3,12),(49,3,9,'2021-01-14 08:26:56','2021-01-14 08:31:31','1/2/9/49',2,3,5),(50,3,9,'2021-01-14 08:27:08','2021-01-14 08:32:09','1/2/9/50',3,3,3),(51,3,9,'2021-01-14 08:27:20','2021-01-14 08:33:18','1/2/9/51',4,3,6),(52,3,48,'2021-01-14 08:27:47','2021-01-14 08:27:47','1/2/9/48/52',1,4,0),(53,3,48,'2021-01-14 08:27:57','2021-01-14 08:27:57','1/2/9/48/53',2,4,0),(54,3,48,'2021-01-14 08:28:08','2021-01-14 08:28:08','1/2/9/48/54',3,4,0),(55,3,48,'2021-01-14 08:28:20','2021-01-14 08:28:20','1/2/9/48/55',4,4,0),(56,3,48,'2021-01-14 08:28:32','2021-01-14 08:28:32','1/2/9/48/56',5,4,0),(57,3,48,'2021-01-14 08:28:44','2021-01-14 08:28:44','1/2/9/48/57',6,4,0),(58,3,48,'2021-01-14 08:28:58','2021-01-14 08:28:58','1/2/9/48/58',7,4,0),(59,3,48,'2021-01-14 08:29:21','2021-01-14 08:29:21','1/2/9/48/59',8,4,0),(60,3,48,'2021-01-14 08:29:37','2021-01-14 08:29:37','1/2/9/48/60',9,4,0),(61,3,48,'2021-01-14 08:30:02','2021-01-14 08:30:02','1/2/9/48/61',10,4,0),(62,3,48,'2021-01-14 08:30:14','2021-01-14 08:30:14','1/2/9/48/62',11,4,0),(63,3,48,'2021-01-14 08:30:26','2021-01-14 08:30:26','1/2/9/48/63',12,4,0),(64,3,49,'2021-01-14 08:30:50','2021-01-14 08:30:50','1/2/9/49/64',1,4,0),(65,3,49,'2021-01-14 08:30:59','2021-01-14 08:30:59','1/2/9/49/65',2,4,0),(66,3,49,'2021-01-14 08:31:11','2021-01-14 08:31:11','1/2/9/49/66',3,4,0),(67,3,49,'2021-01-14 08:31:21','2021-01-14 08:31:21','1/2/9/49/67',4,4,0),(68,3,49,'2021-01-14 08:31:31','2021-01-14 08:31:31','1/2/9/49/68',5,4,0),(69,3,50,'2021-01-14 08:31:45','2021-01-14 08:31:45','1/2/9/50/69',1,4,0),(70,3,50,'2021-01-14 08:31:55','2021-01-14 08:31:55','1/2/9/50/70',2,4,0),(71,3,50,'2021-01-14 08:32:09','2021-01-14 08:32:09','1/2/9/50/71',3,4,0),(72,3,51,'2021-01-14 08:32:22','2021-01-14 08:32:22','1/2/9/51/72',1,4,0),(73,3,51,'2021-01-14 08:32:33','2021-01-14 08:32:33','1/2/9/51/73',2,4,0),(74,3,51,'2021-01-14 08:32:47','2021-01-14 08:32:47','1/2/9/51/74',3,4,0),(75,3,51,'2021-01-14 08:32:57','2021-01-14 08:32:57','1/2/9/51/75',4,4,0),(76,3,51,'2021-01-14 08:33:07','2021-01-14 08:33:07','1/2/9/51/76',5,4,0),(77,3,51,'2021-01-14 08:33:18','2021-01-14 08:33:18','1/2/9/51/77',6,4,0),(78,3,7,'2021-01-14 09:09:17','2021-01-14 09:12:50','1/2/7/78',1,3,4),(79,3,7,'2021-01-14 09:09:47','2021-01-14 09:15:16','1/2/7/79',2,3,5),(80,3,7,'2021-01-14 09:10:15','2021-01-14 09:18:07','1/2/7/80',3,3,9),(81,3,78,'2021-01-14 09:10:50','2021-01-14 09:10:50','1/2/7/78/81',1,4,0),(82,3,78,'2021-01-14 09:11:30','2021-01-14 09:11:30','1/2/7/78/82',2,4,0),(83,3,78,'2021-01-14 09:11:53','2021-01-14 09:11:53','1/2/7/78/83',3,4,0),(84,3,78,'2021-01-14 09:12:50','2021-01-14 09:12:50','1/2/7/78/84',4,4,0),(85,3,79,'2021-01-14 09:13:10','2021-01-14 09:13:10','1/2/7/79/85',1,4,0),(86,3,79,'2021-01-14 09:13:22','2021-01-14 09:13:22','1/2/7/79/86',2,4,0),(87,3,79,'2021-01-14 09:13:38','2021-01-14 09:13:38','1/2/7/79/87',3,4,0),(88,3,79,'2021-01-14 09:14:38','2021-01-14 09:14:38','1/2/7/79/88',4,4,0),(89,3,79,'2021-01-14 09:15:16','2021-01-14 09:15:16','1/2/7/79/89',5,4,0),(90,3,80,'2021-01-14 09:15:34','2021-01-14 09:15:34','1/2/7/80/90',1,4,0),(91,3,80,'2021-01-14 09:15:45','2021-01-14 09:15:45','1/2/7/80/91',2,4,0),(92,3,80,'2021-01-14 09:15:55','2021-01-14 09:15:55','1/2/7/80/92',3,4,0),(93,3,80,'2021-01-14 09:16:11','2021-01-14 09:16:11','1/2/7/80/93',4,4,0),(94,3,80,'2021-01-14 09:16:27','2021-01-14 09:16:27','1/2/7/80/94',5,4,0),(95,3,80,'2021-01-14 09:16:38','2021-01-14 09:16:38','1/2/7/80/95',6,4,0),(96,3,80,'2021-01-14 09:16:49','2021-01-14 09:17:52','1/2/7/80/96',8,4,0),(97,3,80,'2021-01-14 09:17:34','2021-01-14 09:17:52','1/2/7/80/97',7,4,0),(98,3,80,'2021-01-14 09:18:07','2021-01-14 09:18:07','1/2/7/80/98',9,4,0),(99,3,4,'2021-01-14 09:37:52','2021-01-14 09:40:20','1/2/4/99',1,3,5),(100,3,4,'2021-01-14 09:38:19','2021-01-14 09:42:40','1/2/4/100',2,3,8),(101,3,4,'2021-01-14 09:38:45','2021-01-14 09:44:48','1/2/4/101',3,3,5),(102,3,4,'2021-01-14 09:39:00','2021-01-14 09:47:22','1/2/4/102',4,3,8),(103,3,99,'2021-01-14 09:39:20','2021-01-14 09:39:20','1/2/4/99/103',1,4,0),(104,3,99,'2021-01-14 09:39:34','2021-01-14 09:39:34','1/2/4/99/104',2,4,0),(105,3,99,'2021-01-14 09:39:50','2021-01-14 09:39:50','1/2/4/99/105',3,4,0),(106,3,99,'2021-01-14 09:40:07','2021-01-14 09:40:07','1/2/4/99/106',4,4,0),(107,3,99,'2021-01-14 09:40:20','2021-01-14 09:40:20','1/2/4/99/107',5,4,0),(108,3,100,'2021-01-14 09:40:38','2021-01-14 09:40:38','1/2/4/100/108',1,4,0),(109,3,100,'2021-01-14 09:40:52','2021-01-14 09:40:52','1/2/4/100/109',2,4,0),(110,3,100,'2021-01-14 09:41:05','2021-01-14 09:41:05','1/2/4/100/110',3,4,0),(111,3,100,'2021-01-14 09:41:18','2021-01-14 09:41:18','1/2/4/100/111',4,4,0),(112,3,100,'2021-01-14 09:41:31','2021-01-14 09:41:31','1/2/4/100/112',5,4,0),(113,3,100,'2021-01-14 09:41:45','2021-01-14 09:41:45','1/2/4/100/113',6,4,0),(114,3,100,'2021-01-14 09:42:18','2021-01-14 09:42:18','1/2/4/100/114',7,4,0),(115,3,100,'2021-01-14 09:42:40','2021-01-14 09:42:40','1/2/4/100/115',8,4,0),(116,3,101,'2021-01-14 09:43:33','2021-01-14 09:43:33','1/2/4/101/116',1,4,0),(117,3,101,'2021-01-14 09:43:52','2021-01-14 09:43:52','1/2/4/101/117',2,4,0),(118,3,101,'2021-01-14 09:44:05','2021-01-14 09:44:05','1/2/4/101/118',3,4,0),(119,3,101,'2021-01-14 09:44:35','2021-01-14 09:44:35','1/2/4/101/119',4,4,0),(120,3,101,'2021-01-14 09:44:48','2021-01-14 09:44:48','1/2/4/101/120',5,4,0),(121,3,102,'2021-01-14 09:45:16','2021-01-14 09:45:16','1/2/4/102/121',1,4,0),(122,3,102,'2021-01-14 09:45:30','2021-01-14 09:45:30','1/2/4/102/122',2,4,0),(123,3,102,'2021-01-14 09:45:44','2021-01-14 09:45:44','1/2/4/102/123',3,4,0),(124,3,102,'2021-01-14 09:45:58','2021-01-14 09:45:58','1/2/4/102/124',4,4,0),(125,3,102,'2021-01-14 09:46:13','2021-01-14 09:46:54','1/2/4/102/125',6,4,0),(126,3,102,'2021-01-14 09:46:28','2021-01-14 09:47:22','1/2/4/102/126',8,4,0),(127,3,102,'2021-01-14 09:46:46','2021-01-14 09:46:54','1/2/4/102/127',5,4,0),(128,3,102,'2021-01-14 09:47:13','2021-01-14 09:47:22','1/2/4/102/128',7,4,0),(129,3,5,'2021-01-16 07:43:31','2021-01-16 07:43:31','1/2/5/129',1,3,0),(130,3,5,'2021-01-16 07:43:42','2021-01-16 07:43:42','1/2/5/130',2,3,0),(131,3,5,'2021-01-16 07:43:54','2021-01-16 07:43:54','1/2/5/131',3,3,0),(132,3,5,'2021-01-16 07:44:05','2021-01-16 07:44:05','1/2/5/132',4,3,0),(133,3,15,'2021-01-16 07:44:22','2021-01-16 07:44:22','1/2/15/133',1,3,0),(134,3,15,'2021-01-16 07:44:33','2021-01-16 07:44:33','1/2/15/134',2,3,0),(135,3,15,'2021-01-16 07:44:52','2021-01-16 07:44:52','1/2/15/135',3,3,0),(136,3,15,'2021-01-16 07:45:02','2021-01-16 07:45:02','1/2/15/136',4,3,0),(137,3,11,'2021-01-16 07:45:21','2021-08-04 08:15:52','1/2/11/137',1,3,0),(138,3,11,'2021-01-16 07:45:31','2021-01-16 07:45:31','1/2/11/138',2,3,0),(139,3,11,'2021-01-16 07:45:42','2021-01-16 07:45:42','1/2/11/139',3,3,0),(140,3,11,'2021-01-16 07:45:52','2021-01-16 07:45:52','1/2/11/140',4,3,0),(141,3,6,'2021-01-16 07:48:20','2021-01-16 07:48:20','1/2/6/141',1,3,0),(142,3,6,'2021-01-16 07:48:38','2021-01-16 07:48:38','1/2/6/142',2,3,0),(143,3,6,'2021-01-16 07:48:55','2021-01-16 07:48:55','1/2/6/143',3,3,0),(144,3,6,'2021-01-16 07:49:21','2021-01-16 07:49:21','1/2/6/144',4,3,0),(145,3,2,'2021-05-27 02:22:52','2021-05-27 02:23:26','1/2/145',16,2,0),(147,3,16,'2021-06-23 02:41:07','2021-08-04 08:00:45','1/2/16/147',1,3,0),(148,3,16,'2021-06-23 02:41:53','2021-08-04 08:01:00','1/2/16/148',2,3,0),(149,3,16,'2021-06-23 02:42:18','2021-08-04 08:01:11','1/2/16/149',3,3,0),(150,3,2,'2021-07-03 01:37:25','2021-07-03 01:37:26','1/2/150',17,2,0),(151,3,8,'2021-07-14 07:59:58','2021-08-04 08:03:32','1/2/8/151',1,3,0),(152,3,8,'2021-07-14 08:00:46','2021-08-04 08:03:44','1/2/8/152',2,3,0),(153,3,8,'2021-07-14 08:01:01','2021-08-04 08:03:55','1/2/8/153',3,3,0),(154,3,8,'2021-07-14 08:01:20','2021-08-04 08:04:08','1/2/8/154',4,3,0),(155,3,8,'2021-07-14 08:01:32','2021-08-04 08:04:24','1/2/8/155',5,3,0),(156,3,8,'2021-07-14 08:01:48','2021-08-04 08:04:35','1/2/8/156',6,3,0),(157,3,8,'2021-07-14 08:02:12','2021-08-04 08:04:48','1/2/8/157',7,3,0),(158,3,8,'2021-07-14 08:02:51','2021-08-04 08:05:00','1/2/8/158',8,3,0),(159,3,8,'2021-07-14 08:03:35','2021-08-04 08:05:11','1/2/8/159',9,3,0),(160,3,16,'2021-07-19 02:29:05','2021-07-19 02:37:03','1/2/16/160',4,3,5),(161,3,16,'2021-07-19 02:34:06','2021-07-19 02:39:55','1/2/16/161',5,3,5),(162,3,160,'2021-07-19 02:35:04','2021-08-04 08:14:01','1/2/16/160/162',1,4,0),(163,3,160,'2021-07-19 02:35:33','2021-08-04 08:15:32','1/2/16/160/163',2,4,0),(164,3,160,'2021-07-19 02:36:01','2021-08-04 08:15:04','1/2/16/160/164',3,4,0),(165,3,160,'2021-07-19 02:36:26','2021-08-04 08:14:22','1/2/16/160/165',4,4,0),(166,3,160,'2021-07-19 02:37:03','2021-08-04 08:16:11','1/2/16/160/166',5,4,0),(167,3,161,'2021-07-19 02:37:30','2021-08-04 08:09:15','1/2/16/161/167',1,4,0),(168,3,161,'2021-07-19 02:38:08','2021-08-04 08:09:25','1/2/16/161/168',2,4,0),(169,3,161,'2021-07-19 02:38:29','2021-08-17 02:11:57','1/2/16/161/169',3,4,0),(170,3,161,'2021-07-19 02:38:56','2021-08-04 08:09:48','1/2/16/161/170',4,4,0),(171,3,161,'2021-07-19 02:39:55','2021-08-04 08:10:02','1/2/16/161/171',5,4,0),(172,3,2,'2021-07-26 08:14:35','2021-07-26 08:18:11','1/2/172',18,2,4),(173,3,172,'2021-07-26 08:16:09','2021-07-26 08:25:25','1/2/172/173',1,3,0),(174,3,172,'2021-07-26 08:16:35','2021-07-26 08:26:37','1/2/172/174',2,3,0),(175,3,172,'2021-07-26 08:17:02','2021-07-26 08:28:01','1/2/172/175',3,3,0),(176,3,172,'2021-07-26 08:17:33','2021-07-26 08:29:19','1/2/172/176',4,3,0),(177,3,178,'2021-07-30 02:06:43','2021-07-31 01:31:28','1/2/178/177',1,3,0),(178,3,2,'2021-07-31 01:31:08','2022-03-02 02:26:41','1/2/178',19,2,107),(179,3,178,'2021-08-04 07:42:43','2021-08-16 07:53:18','1/2/178/179',2,3,10),(180,3,179,'2021-08-04 07:43:07','2021-08-17 02:10:38','1/2/178/179/180',1,4,0),(181,3,179,'2021-08-04 07:43:31','2021-08-17 02:12:25','1/2/178/179/181',2,4,0),(182,3,179,'2021-08-04 07:43:47','2021-08-04 07:48:11','1/2/178/179/182',3,4,0),(183,3,179,'2021-08-04 07:44:03','2021-08-04 07:48:22','1/2/178/179/183',4,4,0),(184,3,179,'2021-08-04 07:45:41','2021-08-04 09:09:09','1/2/178/179/184',5,4,0),(185,3,179,'2021-08-16 07:46:01','2021-08-16 07:46:01','1/2/178/179/185',6,4,0),(186,3,179,'2021-08-16 07:46:18','2021-08-16 07:46:18','1/2/178/179/186',7,4,0),(187,3,179,'2021-08-16 07:46:32','2021-08-16 07:46:32','1/2/178/179/187',8,4,0),(188,3,179,'2021-08-16 07:46:53','2021-08-16 07:46:53','1/2/178/179/188',9,4,0),(189,3,179,'2021-08-16 07:47:15','2021-08-16 07:47:15','1/2/178/179/189',10,4,0),(190,3,8,'2021-08-16 07:50:42','2021-08-16 07:50:42','1/2/8/190',10,3,0),(191,3,178,'2021-08-17 02:03:24','2021-08-17 02:12:42','1/2/178/191',3,3,0),(192,3,11,'2021-08-27 02:06:34','2021-08-27 02:06:34','1/2/11/192',5,3,0),(193,3,5,'2021-09-21 01:28:16','2021-09-21 01:49:15','1/2/5/193',5,3,0),(194,3,5,'2021-09-21 01:42:26','2021-09-21 01:49:30','1/2/5/194',6,3,0),(195,3,5,'2021-09-21 01:42:48','2021-09-21 01:49:41','1/2/5/195',7,3,0),(196,3,5,'2021-09-21 01:43:03','2021-09-21 01:49:51','1/2/5/196',8,3,0),(197,3,5,'2021-09-21 01:43:24','2021-09-21 01:50:02','1/2/5/197',9,3,0),(198,3,7,'2021-09-25 07:42:40','2021-09-27 01:36:42','1/2/7/198',6,3,0),(199,3,7,'2021-09-25 07:43:00','2021-09-27 01:36:42','1/2/7/199',7,3,0),(200,3,7,'2021-09-25 07:43:24','2021-09-27 01:36:42','1/2/7/200',8,3,0),(201,3,7,'2021-09-25 07:43:39','2021-09-27 01:36:42','1/2/7/201',9,3,0),(202,3,7,'2021-09-25 07:43:59','2021-09-27 01:36:42','1/2/7/202',10,3,0),(203,3,7,'2021-09-25 07:44:26','2021-09-27 01:36:42','1/2/7/203',11,3,0),(204,3,7,'2021-09-27 01:35:37','2021-09-27 01:36:42','1/2/7/204',5,3,0),(205,3,7,'2021-09-27 01:36:14','2021-09-27 01:36:42','1/2/7/205',4,3,0),(206,3,178,'2021-09-30 02:10:41','2021-09-30 02:41:57','1/2/178/206',4,3,43),(207,3,206,'2021-09-30 02:11:07','2021-09-30 07:20:18','1/2/178/206/207',1,4,5),(208,3,206,'2021-09-30 02:11:23','2021-09-30 07:20:30','1/2/178/206/208',2,4,0),(209,3,206,'2021-09-30 02:11:39','2021-09-30 07:20:45','1/2/178/206/209',3,4,0),(210,3,206,'2021-09-30 02:11:55','2021-09-30 07:20:57','1/2/178/206/210',4,4,0),(211,3,206,'2021-09-30 02:12:17','2021-09-30 07:21:11','1/2/178/206/211',5,4,0),(212,3,206,'2021-09-30 02:12:36','2021-09-30 07:21:27','1/2/178/206/212',6,4,5),(213,3,206,'2021-09-30 02:12:50','2021-09-30 07:21:51','1/2/178/206/213',7,4,5),(214,3,206,'2021-09-30 02:13:05','2021-09-30 07:22:08','1/2/178/206/214',8,4,5),(215,3,206,'2021-09-30 02:13:21','2021-09-30 07:22:23','1/2/178/206/215',9,4,0),(216,3,206,'2021-09-30 02:13:38','2021-09-30 07:22:39','1/2/178/206/216',10,4,0),(217,3,206,'2021-09-30 02:14:07','2021-09-30 07:22:52','1/2/178/206/217',11,4,5),(218,3,206,'2021-09-30 02:22:37','2021-09-30 07:23:11','1/2/178/206/218',12,4,0),(219,3,207,'2021-09-30 02:24:25','2021-09-30 02:24:25','1/2/178/206/207/219',1,5,0),(220,3,207,'2021-09-30 02:24:46','2021-09-30 02:24:46','1/2/178/206/207/220',2,5,0),(221,3,207,'2021-09-30 02:25:06','2021-09-30 02:25:06','1/2/178/206/207/221',3,5,0),(222,3,207,'2021-09-30 02:25:21','2021-09-30 02:25:21','1/2/178/206/207/222',4,5,0),(223,3,207,'2021-09-30 02:25:38','2021-09-30 02:25:38','1/2/178/206/207/223',5,5,0),(224,3,217,'2021-09-30 02:26:15','2021-09-30 02:26:15','1/2/178/206/217/224',1,5,0),(225,3,217,'2021-09-30 02:26:32','2021-09-30 02:26:32','1/2/178/206/217/225',2,5,0),(226,3,217,'2021-09-30 02:26:55','2021-09-30 02:26:55','1/2/178/206/217/226',3,5,0),(227,3,217,'2021-09-30 02:33:35','2021-09-30 02:33:35','1/2/178/206/217/227',4,5,0),(228,3,217,'2021-09-30 02:34:02','2021-09-30 02:34:02','1/2/178/206/217/228',5,5,0),(229,3,213,'2021-09-30 02:34:23','2021-09-30 02:34:23','1/2/178/206/213/229',1,5,0),(230,3,213,'2021-09-30 02:34:40','2021-09-30 02:34:40','1/2/178/206/213/230',2,5,0),(231,3,213,'2021-09-30 02:34:55','2021-09-30 02:34:55','1/2/178/206/213/231',3,5,0),(232,3,213,'2021-09-30 02:35:09','2021-09-30 02:35:09','1/2/178/206/213/232',4,5,0),(233,3,213,'2021-09-30 02:35:25','2021-09-30 02:35:25','1/2/178/206/213/233',5,5,0),(234,3,212,'2021-09-30 02:35:52','2021-09-30 02:35:52','1/2/178/206/212/234',1,5,0),(235,3,212,'2021-09-30 02:36:10','2021-09-30 02:36:10','1/2/178/206/212/235',2,5,0),(236,3,212,'2021-09-30 02:36:36','2021-09-30 02:36:36','1/2/178/206/212/236',3,5,0),(237,3,212,'2021-09-30 02:36:52','2021-09-30 02:36:52','1/2/178/206/212/237',4,5,0),(238,3,212,'2021-09-30 02:37:25','2021-09-30 02:37:25','1/2/178/206/212/238',5,5,0),(239,3,206,'2021-09-30 02:38:38','2021-09-30 02:40:19','1/2/178/206/239',13,4,5),(240,3,239,'2021-09-30 02:39:06','2021-09-30 02:39:06','1/2/178/206/239/240',1,5,0),(241,3,239,'2021-09-30 02:39:22','2021-09-30 02:39:22','1/2/178/206/239/241',2,5,0),(242,3,239,'2021-09-30 02:39:46','2021-09-30 02:39:46','1/2/178/206/239/242',3,5,0),(243,3,239,'2021-09-30 02:40:02','2021-09-30 02:40:02','1/2/178/206/239/243',4,5,0),(244,3,239,'2021-09-30 02:40:19','2021-09-30 02:40:19','1/2/178/206/239/244',5,5,0),(245,3,214,'2021-09-30 02:40:45','2021-09-30 02:40:45','1/2/178/206/214/245',1,5,0),(246,3,214,'2021-09-30 02:41:00','2021-09-30 02:41:00','1/2/178/206/214/246',2,5,0),(247,3,214,'2021-09-30 02:41:18','2021-09-30 02:41:18','1/2/178/206/214/247',3,5,0),(248,3,214,'2021-09-30 02:41:40','2021-09-30 02:41:40','1/2/178/206/214/248',4,5,0),(249,3,214,'2021-09-30 02:41:57','2021-09-30 02:41:57','1/2/178/206/214/249',5,5,0),(250,3,178,'2021-10-08 02:43:49','2021-10-08 04:01:17','1/2/178/250',5,3,4),(251,3,178,'2021-10-08 02:44:25','2021-10-08 04:01:34','1/2/178/251',6,3,4),(252,3,178,'2021-10-08 02:44:52','2021-10-12 02:45:16','1/2/178/252',7,3,4),(253,3,178,'2021-10-08 02:45:16','2021-10-08 04:02:01','1/2/178/253',8,3,4),(254,3,178,'2021-10-08 02:48:10','2021-10-08 04:02:14','1/2/178/254',9,3,4),(255,3,251,'2021-10-08 03:05:04','2021-10-08 03:05:04','1/2/178/251/255',1,4,0),(256,3,251,'2021-10-08 03:05:52','2021-10-08 03:05:52','1/2/178/251/256',2,4,0),(257,3,251,'2021-10-08 03:06:19','2021-10-08 03:06:19','1/2/178/251/257',3,4,0),(258,3,251,'2021-10-08 03:06:58','2021-10-08 03:06:58','1/2/178/251/258',4,4,0),(259,3,250,'2021-10-08 03:08:26','2021-10-12 02:43:26','1/2/178/250/259',1,4,0),(260,3,250,'2021-10-08 03:08:58','2021-10-08 03:08:58','1/2/178/250/260',2,4,0),(261,3,250,'2021-10-08 03:09:32','2021-10-08 03:09:32','1/2/178/250/261',3,4,0),(262,3,250,'2021-10-08 03:09:59','2021-10-08 03:09:59','1/2/178/250/262',4,4,0),(263,3,252,'2021-10-08 03:10:55','2021-10-12 02:47:11','1/2/178/252/263',1,4,0),(264,3,252,'2021-10-08 03:11:23','2021-10-08 03:11:23','1/2/178/252/264',2,4,0),(265,3,252,'2021-10-08 03:11:48','2021-10-08 03:11:48','1/2/178/252/265',3,4,0),(266,3,252,'2021-10-08 03:12:12','2021-10-08 03:12:12','1/2/178/252/266',4,4,0),(267,3,253,'2021-10-08 03:14:41','2021-10-08 03:14:41','1/2/178/253/267',1,4,0),(268,3,253,'2021-10-08 03:15:26','2021-10-08 03:15:26','1/2/178/253/268',2,4,0),(269,3,253,'2021-10-08 03:16:37','2021-10-08 03:16:37','1/2/178/253/269',3,4,0),(270,3,253,'2021-10-08 03:17:08','2021-10-08 03:17:08','1/2/178/253/270',4,4,0),(271,3,254,'2021-10-08 03:18:46','2021-10-08 03:18:47','1/2/178/254/271',1,4,0),(272,3,254,'2021-10-08 03:19:22','2021-10-08 03:19:22','1/2/178/254/272',2,4,0),(273,3,254,'2021-10-08 03:19:53','2021-10-08 03:19:53','1/2/178/254/273',3,4,0),(274,3,254,'2021-10-08 03:20:21','2021-10-08 03:20:21','1/2/178/254/274',4,4,0),(275,3,178,'2021-10-08 03:45:40','2021-10-08 04:02:27','1/2/178/275',10,3,4),(276,3,275,'2021-10-08 03:46:38','2021-10-08 03:46:38','1/2/178/275/276',1,4,0),(277,3,275,'2021-10-08 03:47:10','2021-10-08 03:47:11','1/2/178/275/277',2,4,0),(278,3,275,'2021-10-08 03:47:38','2021-10-08 03:47:38','1/2/178/275/278',3,4,0),(279,3,275,'2021-10-08 03:48:05','2021-10-08 03:48:05','1/2/178/275/279',4,4,0),(280,3,178,'2021-10-18 08:57:35','2021-10-18 09:12:55','1/2/178/280',11,3,5),(281,3,280,'2021-10-18 08:58:13','2021-10-18 09:13:06','1/2/178/280/281',1,4,0),(282,3,280,'2021-10-18 08:58:26','2021-10-18 09:13:17','1/2/178/280/282',2,4,0),(283,3,280,'2021-10-18 08:58:39','2021-10-18 09:13:28','1/2/178/280/283',3,4,0),(284,3,280,'2021-10-18 08:58:51','2021-10-18 09:13:41','1/2/178/280/284',4,4,0),(285,3,280,'2021-10-18 08:59:10','2021-10-18 09:13:51','1/2/178/280/285',5,4,0),(286,3,178,'2021-11-23 01:43:59','2021-11-23 01:44:11','1/2/178/286',12,3,0),(287,3,178,'2021-11-29 01:15:50','2021-11-29 01:15:50','1/2/178/287',13,3,0),(288,3,178,'2021-12-13 07:45:52','2021-12-13 07:45:52','1/2/178/288',14,3,0),(289,3,178,'2021-12-22 09:38:53','2022-03-02 02:26:41','1/2/178/289',15,3,9),(290,3,289,'2021-12-22 09:39:51','2021-12-22 09:39:51','1/2/178/289/290',1,4,0),(291,3,289,'2021-12-22 09:40:17','2021-12-22 09:40:17','1/2/178/289/291',2,4,0),(292,3,289,'2021-12-22 09:40:38','2021-12-22 09:40:38','1/2/178/289/292',3,4,0),(293,3,289,'2021-12-22 09:40:59','2022-03-11 14:13:25','1/2/178/289/293',4,4,0),(294,3,178,'2022-01-04 02:20:16','2022-01-04 02:20:16','1/2/178/294',16,3,0),(295,3,289,'2022-03-02 02:11:38','2022-03-11 14:10:24','1/2/178/289/295',5,4,0),(296,3,289,'2022-03-02 02:14:06','2022-03-11 14:10:53','1/2/178/289/296',6,4,0),(297,3,289,'2022-03-02 02:15:30','2022-03-11 14:11:52','1/2/178/289/297',7,4,0),(298,3,289,'2022-03-02 02:16:39','2022-03-14 03:50:03','1/2/178/289/298',8,4,0),(299,3,289,'2022-03-02 02:26:41','2022-03-11 14:13:10','1/2/178/289/299',9,4,0);
/*!40000 ALTER TABLE `catalog_category_entity` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_entity_datetime`
--

DROP TABLE IF EXISTS `catalog_category_entity_datetime`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_entity_datetime` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` datetime DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_CATEGORY_ENTITY_DATETIME_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_CATEGORY_ENTITY_DATETIME_ENTITY_ID` (`entity_id`),
  KEY `CATALOG_CATEGORY_ENTITY_DATETIME_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_CATEGORY_ENTITY_DATETIME_STORE_ID` (`store_id`),
  CONSTRAINT `CAT_CTGR_ENTT_DTIME_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_CTGR_ENTT_DTIME_ENTT_ID_CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CATALOG_CATEGORY_ENTITY_DATETIME_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=187 DEFAULT CHARSET=utf8 COMMENT='Catalog Category Datetime Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_entity_datetime`
--

LOCK TABLES `catalog_category_entity_datetime` WRITE;
/*!40000 ALTER TABLE `catalog_category_entity_datetime` DISABLE KEYS */;
INSERT INTO `catalog_category_entity_datetime` VALUES (1,61,0,18,NULL),(2,62,0,18,NULL),(3,61,0,19,NULL),(4,62,0,19,NULL),(5,61,0,20,NULL),(6,62,0,20,NULL),(7,61,0,21,NULL),(8,62,0,21,NULL),(9,61,0,97,NULL),(10,62,0,97,NULL),(11,61,0,9,NULL),(12,62,0,9,NULL),(13,61,0,3,NULL),(14,62,0,3,NULL),(15,61,0,5,NULL),(16,62,0,5,NULL),(17,61,0,15,NULL),(18,62,0,15,NULL),(19,61,0,11,NULL),(20,62,0,11,NULL),(21,61,0,4,NULL),(22,62,0,4,NULL),(23,61,0,7,NULL),(24,62,0,7,NULL),(25,61,0,6,NULL),(26,62,0,6,NULL),(27,61,0,145,NULL),(28,62,0,145,NULL),(29,61,0,13,NULL),(30,62,0,13,NULL),(31,61,0,147,NULL),(32,62,0,147,NULL),(33,61,0,148,NULL),(34,62,0,148,NULL),(35,61,0,149,NULL),(36,62,0,149,NULL),(37,61,0,151,NULL),(38,62,0,151,NULL),(39,61,0,152,NULL),(40,62,0,152,NULL),(41,61,0,153,NULL),(42,62,0,153,NULL),(43,61,0,154,NULL),(44,62,0,154,NULL),(45,61,0,155,NULL),(46,62,0,155,NULL),(47,61,0,156,NULL),(48,62,0,156,NULL),(49,61,0,157,NULL),(50,62,0,157,NULL),(51,61,0,158,NULL),(52,62,0,158,NULL),(53,61,0,159,NULL),(54,62,0,159,NULL),(55,61,0,162,NULL),(56,62,0,162,NULL),(57,61,0,163,NULL),(58,62,0,163,NULL),(59,61,0,164,NULL),(60,62,0,164,NULL),(61,61,0,165,NULL),(62,62,0,165,NULL),(63,61,0,166,NULL),(64,62,0,166,NULL),(65,61,0,167,NULL),(66,62,0,167,NULL),(67,61,0,168,NULL),(68,62,0,168,NULL),(69,61,0,169,NULL),(70,62,0,169,NULL),(71,61,0,170,NULL),(72,62,0,170,NULL),(73,61,0,171,NULL),(74,62,0,171,NULL),(75,61,0,172,NULL),(76,62,0,172,NULL),(77,61,0,173,NULL),(78,62,0,173,NULL),(79,61,0,174,NULL),(80,62,0,174,NULL),(81,61,0,175,NULL),(82,62,0,175,NULL),(83,61,0,176,NULL),(84,62,0,176,NULL),(85,61,0,177,NULL),(86,62,0,177,NULL),(87,61,0,178,NULL),(88,62,0,178,NULL),(89,61,0,180,NULL),(90,62,0,180,NULL),(91,61,0,181,NULL),(92,62,0,181,NULL),(93,61,0,182,NULL),(94,62,0,182,NULL),(95,61,0,183,NULL),(96,62,0,183,NULL),(97,61,0,184,NULL),(98,62,0,184,NULL),(99,61,0,193,NULL),(100,62,0,193,NULL),(101,61,0,194,NULL),(102,62,0,194,NULL),(103,61,0,195,NULL),(104,62,0,195,NULL),(105,61,0,196,NULL),(106,62,0,196,NULL),(107,61,0,197,NULL),(108,62,0,197,NULL),(109,61,0,198,NULL),(110,62,0,198,NULL),(111,61,0,199,NULL),(112,62,0,199,NULL),(113,61,0,200,NULL),(114,62,0,200,NULL),(115,61,0,201,NULL),(116,62,0,201,NULL),(117,61,0,202,NULL),(118,62,0,202,NULL),(119,61,0,203,NULL),(120,62,0,203,NULL),(121,61,0,217,NULL),(122,62,0,217,NULL),(123,61,0,213,NULL),(124,62,0,213,NULL),(125,61,0,207,NULL),(126,62,0,207,NULL),(127,61,0,208,NULL),(128,62,0,208,NULL),(129,61,0,209,NULL),(130,62,0,209,NULL),(131,61,0,210,NULL),(132,62,0,210,NULL),(133,61,0,211,NULL),(134,62,0,211,NULL),(135,61,0,212,NULL),(136,62,0,212,NULL),(137,61,0,214,NULL),(138,62,0,214,NULL),(139,61,0,215,NULL),(140,62,0,215,NULL),(141,61,0,216,NULL),(142,62,0,216,NULL),(143,61,0,218,NULL),(144,62,0,218,NULL),(145,61,0,252,NULL),(146,62,0,252,NULL),(147,61,0,253,NULL),(148,62,0,253,NULL),(149,61,0,250,NULL),(150,62,0,250,NULL),(151,61,0,251,NULL),(152,62,0,251,NULL),(153,61,0,254,NULL),(154,62,0,254,NULL),(155,61,0,275,NULL),(156,62,0,275,NULL),(157,61,0,259,NULL),(158,62,0,259,NULL),(159,61,0,263,NULL),(160,62,0,263,NULL),(161,61,0,280,NULL),(162,62,0,280,NULL),(163,61,0,281,NULL),(164,62,0,281,NULL),(165,61,0,282,NULL),(166,62,0,282,NULL),(167,61,0,283,NULL),(168,62,0,283,NULL),(169,61,0,284,NULL),(170,62,0,284,NULL),(171,61,0,285,NULL),(172,62,0,285,NULL),(173,61,0,286,NULL),(174,62,0,286,NULL),(175,61,0,295,NULL),(176,62,0,295,NULL),(177,61,0,296,NULL),(178,62,0,296,NULL),(179,61,0,297,NULL),(180,62,0,297,NULL),(181,61,0,298,NULL),(182,62,0,298,NULL),(183,61,0,299,NULL),(184,62,0,299,NULL),(185,61,0,293,NULL),(186,62,0,293,NULL);
/*!40000 ALTER TABLE `catalog_category_entity_datetime` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_entity_decimal`
--

DROP TABLE IF EXISTS `catalog_category_entity_decimal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_entity_decimal` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` decimal(20,6) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_CATEGORY_ENTITY_DECIMAL_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_CATEGORY_ENTITY_DECIMAL_ENTITY_ID` (`entity_id`),
  KEY `CATALOG_CATEGORY_ENTITY_DECIMAL_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_CATEGORY_ENTITY_DECIMAL_STORE_ID` (`store_id`),
  CONSTRAINT `CAT_CTGR_ENTT_DEC_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_CTGR_ENTT_DEC_ENTT_ID_CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CATALOG_CATEGORY_ENTITY_DECIMAL_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Decimal Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_entity_decimal`
--

LOCK TABLES `catalog_category_entity_decimal` WRITE;
/*!40000 ALTER TABLE `catalog_category_entity_decimal` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_category_entity_decimal` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_entity_int`
--

DROP TABLE IF EXISTS `catalog_category_entity_int`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_entity_int` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` int DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_CATEGORY_ENTITY_INT_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_CATEGORY_ENTITY_INT_ENTITY_ID` (`entity_id`),
  KEY `CATALOG_CATEGORY_ENTITY_INT_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_CATEGORY_ENTITY_INT_STORE_ID` (`store_id`),
  CONSTRAINT `CAT_CTGR_ENTT_INT_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_CTGR_ENTT_INT_ENTT_ID_CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CATALOG_CATEGORY_ENTITY_INT_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1786 DEFAULT CHARSET=utf8 COMMENT='Catalog Category Integer Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_entity_int`
--

LOCK TABLES `catalog_category_entity_int` WRITE;
/*!40000 ALTER TABLE `catalog_category_entity_int` DISABLE KEYS */;
INSERT INTO `catalog_category_entity_int` VALUES (1,69,0,1,1),(2,69,0,2,1),(3,46,0,2,1),(4,46,0,3,1),(5,54,0,3,1),(6,69,0,3,1),(7,70,0,3,0),(8,71,0,3,0),(9,46,0,4,1),(10,54,0,4,1),(11,69,0,4,1),(12,70,0,4,0),(13,71,0,4,0),(14,46,0,5,1),(15,54,0,5,1),(16,69,0,5,1),(17,70,0,5,0),(18,71,0,5,0),(19,46,0,6,1),(20,54,0,6,1),(21,69,0,6,1),(22,70,0,6,0),(23,71,0,6,0),(24,46,0,7,1),(25,54,0,7,1),(26,69,0,7,1),(27,70,0,7,0),(28,71,0,7,0),(29,46,0,8,1),(30,54,0,8,1),(31,69,0,8,1),(32,70,0,8,0),(33,71,0,8,0),(34,46,0,9,1),(35,54,0,9,1),(36,69,0,9,1),(37,70,0,9,0),(38,71,0,9,0),(39,46,0,10,1),(40,54,0,10,1),(41,69,0,10,1),(42,70,0,10,0),(43,71,0,10,0),(44,46,0,11,1),(45,54,0,11,1),(46,69,0,11,1),(47,70,0,11,0),(48,71,0,11,0),(49,46,0,12,1),(50,54,0,12,1),(51,69,0,12,1),(52,70,0,12,0),(53,71,0,12,0),(54,46,0,13,1),(55,54,0,13,1),(56,69,0,13,1),(57,70,0,13,0),(58,71,0,13,0),(59,46,0,14,1),(60,54,0,14,1),(61,69,0,14,1),(62,70,0,14,0),(63,71,0,14,0),(64,46,0,15,1),(65,54,0,15,1),(66,69,0,15,1),(67,70,0,15,0),(68,71,0,15,0),(69,46,0,16,1),(70,54,0,16,1),(71,69,0,16,1),(72,70,0,16,0),(73,71,0,16,0),(74,46,0,17,1),(75,54,0,17,1),(76,69,0,17,1),(77,70,0,17,0),(78,71,0,17,0),(79,46,0,18,1),(80,54,0,18,1),(81,69,0,18,1),(82,70,0,18,0),(83,71,0,18,0),(84,46,0,19,1),(85,54,0,19,1),(86,69,0,19,1),(87,70,0,19,0),(88,71,0,19,0),(89,46,0,20,1),(90,54,0,20,1),(91,69,0,20,1),(92,70,0,20,0),(93,71,0,20,0),(94,46,0,21,1),(95,54,0,21,1),(96,69,0,21,1),(97,70,0,21,0),(98,71,0,21,0),(99,53,0,18,NULL),(100,53,0,19,NULL),(101,53,0,20,NULL),(102,53,0,21,NULL),(103,46,0,22,1),(104,54,0,22,1),(105,69,0,22,1),(106,70,0,22,0),(107,71,0,22,0),(108,46,0,23,1),(109,54,0,23,1),(110,69,0,23,1),(111,70,0,23,0),(112,71,0,23,0),(113,46,0,24,1),(114,54,0,24,1),(115,69,0,24,1),(116,70,0,24,0),(117,71,0,24,0),(118,46,0,25,1),(119,54,0,25,1),(120,69,0,25,1),(121,70,0,25,0),(122,71,0,25,0),(123,46,0,26,1),(124,54,0,26,1),(125,69,0,26,1),(126,70,0,26,0),(127,71,0,26,0),(128,46,0,27,1),(129,54,0,27,1),(130,69,0,27,1),(131,70,0,27,0),(132,71,0,27,0),(133,46,0,28,1),(134,54,0,28,1),(135,69,0,28,1),(136,70,0,28,0),(137,71,0,28,0),(138,46,0,29,1),(139,54,0,29,1),(140,69,0,29,1),(141,70,0,29,0),(142,71,0,29,0),(143,46,0,30,1),(144,54,0,30,1),(145,69,0,30,1),(146,70,0,30,0),(147,71,0,30,0),(148,46,0,31,1),(149,54,0,31,1),(150,69,0,31,1),(151,70,0,31,0),(152,71,0,31,0),(153,46,0,32,1),(154,54,0,32,1),(155,69,0,32,1),(156,70,0,32,0),(157,71,0,32,0),(158,46,0,33,1),(159,54,0,33,1),(160,69,0,33,1),(161,70,0,33,0),(162,71,0,33,0),(163,46,0,34,1),(164,54,0,34,1),(165,69,0,34,1),(166,70,0,34,0),(167,71,0,34,0),(168,46,0,35,1),(169,54,0,35,1),(170,69,0,35,1),(171,70,0,35,0),(172,71,0,35,0),(173,46,0,36,1),(174,54,0,36,1),(175,69,0,36,1),(176,70,0,36,0),(177,71,0,36,0),(178,46,0,37,1),(179,54,0,37,1),(180,69,0,37,1),(181,70,0,37,0),(182,71,0,37,0),(183,46,0,38,1),(184,54,0,38,1),(185,69,0,38,1),(186,70,0,38,0),(187,71,0,38,0),(188,46,0,39,1),(189,54,0,39,1),(190,69,0,39,1),(191,70,0,39,0),(192,71,0,39,0),(193,46,0,40,1),(194,54,0,40,1),(195,69,0,40,1),(196,70,0,40,0),(197,71,0,40,0),(198,46,0,41,1),(199,54,0,41,1),(200,69,0,41,1),(201,70,0,41,0),(202,71,0,41,0),(203,46,0,42,1),(204,54,0,42,1),(205,69,0,42,1),(206,70,0,42,0),(207,71,0,42,0),(208,46,0,43,1),(209,54,0,43,1),(210,69,0,43,1),(211,70,0,43,0),(212,71,0,43,0),(213,46,0,44,1),(214,54,0,44,1),(215,69,0,44,1),(216,70,0,44,0),(217,71,0,44,0),(218,46,0,45,1),(219,54,0,45,1),(220,69,0,45,1),(221,70,0,45,0),(222,71,0,45,0),(223,46,0,46,1),(224,54,0,46,1),(225,69,0,46,1),(226,70,0,46,0),(227,71,0,46,0),(228,46,0,47,1),(229,54,0,47,1),(230,69,0,47,1),(231,70,0,47,0),(232,71,0,47,0),(233,46,0,48,1),(234,54,0,48,1),(235,69,0,48,1),(236,70,0,48,0),(237,71,0,48,0),(238,46,0,49,1),(239,54,0,49,1),(240,69,0,49,1),(241,70,0,49,0),(242,71,0,49,0),(243,46,0,50,1),(244,54,0,50,1),(245,69,0,50,1),(246,70,0,50,0),(247,71,0,50,0),(248,46,0,51,1),(249,54,0,51,1),(250,69,0,51,1),(251,70,0,51,0),(252,71,0,51,0),(253,46,0,52,1),(254,54,0,52,1),(255,69,0,52,1),(256,70,0,52,0),(257,71,0,52,0),(258,46,0,53,1),(259,54,0,53,1),(260,69,0,53,1),(261,70,0,53,0),(262,71,0,53,0),(263,46,0,54,1),(264,54,0,54,1),(265,69,0,54,1),(266,70,0,54,0),(267,71,0,54,0),(268,46,0,55,1),(269,54,0,55,1),(270,69,0,55,1),(271,70,0,55,0),(272,71,0,55,0),(273,46,0,56,1),(274,54,0,56,1),(275,69,0,56,1),(276,70,0,56,0),(277,71,0,56,0),(278,46,0,57,1),(279,54,0,57,1),(280,69,0,57,1),(281,70,0,57,0),(282,71,0,57,0),(283,46,0,58,1),(284,54,0,58,1),(285,69,0,58,1),(286,70,0,58,0),(287,71,0,58,0),(288,46,0,59,1),(289,54,0,59,1),(290,69,0,59,1),(291,70,0,59,0),(292,71,0,59,0),(293,46,0,60,1),(294,54,0,60,1),(295,69,0,60,1),(296,70,0,60,0),(297,71,0,60,0),(298,46,0,61,1),(299,54,0,61,1),(300,69,0,61,1),(301,70,0,61,0),(302,71,0,61,0),(303,46,0,62,1),(304,54,0,62,1),(305,69,0,62,1),(306,70,0,62,0),(307,71,0,62,0),(308,46,0,63,1),(309,54,0,63,1),(310,69,0,63,1),(311,70,0,63,0),(312,71,0,63,0),(313,46,0,64,1),(314,54,0,64,1),(315,69,0,64,1),(316,70,0,64,0),(317,71,0,64,0),(318,46,0,65,1),(319,54,0,65,1),(320,69,0,65,1),(321,70,0,65,0),(322,71,0,65,0),(323,46,0,66,1),(324,54,0,66,1),(325,69,0,66,1),(326,70,0,66,0),(327,71,0,66,0),(328,46,0,67,1),(329,54,0,67,1),(330,69,0,67,1),(331,70,0,67,0),(332,71,0,67,0),(333,46,0,68,1),(334,54,0,68,1),(335,69,0,68,1),(336,70,0,68,0),(337,71,0,68,0),(338,46,0,69,1),(339,54,0,69,1),(340,69,0,69,1),(341,70,0,69,0),(342,71,0,69,0),(343,46,0,70,1),(344,54,0,70,1),(345,69,0,70,1),(346,70,0,70,0),(347,71,0,70,0),(348,46,0,71,1),(349,54,0,71,1),(350,69,0,71,1),(351,70,0,71,0),(352,71,0,71,0),(353,46,0,72,1),(354,54,0,72,1),(355,69,0,72,1),(356,70,0,72,0),(357,71,0,72,0),(358,46,0,73,1),(359,54,0,73,1),(360,69,0,73,1),(361,70,0,73,0),(362,71,0,73,0),(363,46,0,74,1),(364,54,0,74,1),(365,69,0,74,1),(366,70,0,74,0),(367,71,0,74,0),(368,46,0,75,1),(369,54,0,75,1),(370,69,0,75,1),(371,70,0,75,0),(372,71,0,75,0),(373,46,0,76,1),(374,54,0,76,1),(375,69,0,76,1),(376,70,0,76,0),(377,71,0,76,0),(378,46,0,77,1),(379,54,0,77,1),(380,69,0,77,1),(381,70,0,77,0),(382,71,0,77,0),(383,46,0,78,1),(384,54,0,78,1),(385,69,0,78,1),(386,70,0,78,0),(387,71,0,78,0),(388,46,0,79,1),(389,54,0,79,1),(390,69,0,79,1),(391,70,0,79,0),(392,71,0,79,0),(393,46,0,80,1),(394,54,0,80,1),(395,69,0,80,1),(396,70,0,80,0),(397,71,0,80,0),(398,46,0,81,1),(399,54,0,81,1),(400,69,0,81,1),(401,70,0,81,0),(402,71,0,81,0),(403,46,0,82,1),(404,54,0,82,1),(405,69,0,82,1),(406,70,0,82,0),(407,71,0,82,0),(408,46,0,83,1),(409,54,0,83,1),(410,69,0,83,1),(411,70,0,83,0),(412,71,0,83,0),(413,46,0,84,1),(414,54,0,84,1),(415,69,0,84,1),(416,70,0,84,0),(417,71,0,84,0),(418,46,0,85,1),(419,54,0,85,1),(420,69,0,85,1),(421,70,0,85,0),(422,71,0,85,0),(423,46,0,86,1),(424,54,0,86,1),(425,69,0,86,1),(426,70,0,86,0),(427,71,0,86,0),(428,46,0,87,1),(429,54,0,87,1),(430,69,0,87,1),(431,70,0,87,0),(432,71,0,87,0),(433,46,0,88,1),(434,54,0,88,1),(435,69,0,88,1),(436,70,0,88,0),(437,71,0,88,0),(438,46,0,89,1),(439,54,0,89,1),(440,69,0,89,1),(441,70,0,89,0),(442,71,0,89,0),(443,46,0,90,1),(444,54,0,90,1),(445,69,0,90,1),(446,70,0,90,0),(447,71,0,90,0),(448,46,0,91,1),(449,54,0,91,1),(450,69,0,91,1),(451,70,0,91,0),(452,71,0,91,0),(453,46,0,92,1),(454,54,0,92,1),(455,69,0,92,1),(456,70,0,92,0),(457,71,0,92,0),(458,46,0,93,1),(459,54,0,93,1),(460,69,0,93,1),(461,70,0,93,0),(462,71,0,93,0),(463,46,0,94,1),(464,54,0,94,1),(465,69,0,94,1),(466,70,0,94,0),(467,71,0,94,0),(468,46,0,95,1),(469,54,0,95,1),(470,69,0,95,1),(471,70,0,95,0),(472,71,0,95,0),(473,46,0,96,1),(474,54,0,96,1),(475,69,0,96,1),(476,70,0,96,0),(477,71,0,96,0),(478,46,0,97,1),(479,54,0,97,1),(480,69,0,97,1),(481,70,0,97,0),(482,71,0,97,0),(483,53,0,97,NULL),(484,46,0,98,1),(485,54,0,98,1),(486,69,0,98,1),(487,70,0,98,0),(488,71,0,98,0),(489,46,0,99,1),(490,54,0,99,1),(491,69,0,99,1),(492,70,0,99,0),(493,71,0,99,0),(494,46,0,100,1),(495,54,0,100,1),(496,69,0,100,1),(497,70,0,100,0),(498,71,0,100,0),(499,46,0,101,1),(500,54,0,101,1),(501,69,0,101,1),(502,70,0,101,0),(503,71,0,101,0),(504,46,0,102,1),(505,54,0,102,1),(506,69,0,102,1),(507,70,0,102,0),(508,71,0,102,0),(509,46,0,103,1),(510,54,0,103,1),(511,69,0,103,1),(512,70,0,103,0),(513,71,0,103,0),(514,46,0,104,1),(515,54,0,104,1),(516,69,0,104,1),(517,70,0,104,0),(518,71,0,104,0),(519,46,0,105,1),(520,54,0,105,1),(521,69,0,105,1),(522,70,0,105,0),(523,71,0,105,0),(524,46,0,106,1),(525,54,0,106,1),(526,69,0,106,1),(527,70,0,106,0),(528,71,0,106,0),(529,46,0,107,1),(530,54,0,107,1),(531,69,0,107,1),(532,70,0,107,0),(533,71,0,107,0),(534,46,0,108,1),(535,54,0,108,1),(536,69,0,108,1),(537,70,0,108,0),(538,71,0,108,0),(539,46,0,109,1),(540,54,0,109,1),(541,69,0,109,1),(542,70,0,109,0),(543,71,0,109,0),(544,46,0,110,1),(545,54,0,110,1),(546,69,0,110,1),(547,70,0,110,0),(548,71,0,110,0),(549,46,0,111,1),(550,54,0,111,1),(551,69,0,111,1),(552,70,0,111,0),(553,71,0,111,0),(554,46,0,112,1),(555,54,0,112,1),(556,69,0,112,1),(557,70,0,112,0),(558,71,0,112,0),(559,46,0,113,1),(560,54,0,113,1),(561,69,0,113,1),(562,70,0,113,0),(563,71,0,113,0),(564,46,0,114,1),(565,54,0,114,1),(566,69,0,114,1),(567,70,0,114,0),(568,71,0,114,0),(569,46,0,115,1),(570,54,0,115,1),(571,69,0,115,1),(572,70,0,115,0),(573,71,0,115,0),(574,46,0,116,1),(575,54,0,116,1),(576,69,0,116,1),(577,70,0,116,0),(578,71,0,116,0),(579,46,0,117,1),(580,54,0,117,1),(581,69,0,117,1),(582,70,0,117,0),(583,71,0,117,0),(584,46,0,118,1),(585,54,0,118,1),(586,69,0,118,1),(587,70,0,118,0),(588,71,0,118,0),(589,46,0,119,1),(590,54,0,119,1),(591,69,0,119,1),(592,70,0,119,0),(593,71,0,119,0),(594,46,0,120,1),(595,54,0,120,1),(596,69,0,120,1),(597,70,0,120,0),(598,71,0,120,0),(599,46,0,121,1),(600,54,0,121,1),(601,69,0,121,1),(602,70,0,121,0),(603,71,0,121,0),(604,46,0,122,1),(605,54,0,122,1),(606,69,0,122,1),(607,70,0,122,0),(608,71,0,122,0),(609,46,0,123,1),(610,54,0,123,1),(611,69,0,123,1),(612,70,0,123,0),(613,71,0,123,0),(614,46,0,124,1),(615,54,0,124,1),(616,69,0,124,1),(617,70,0,124,0),(618,71,0,124,0),(619,46,0,125,1),(620,54,0,125,1),(621,69,0,125,1),(622,70,0,125,0),(623,71,0,125,0),(624,46,0,126,1),(625,54,0,126,1),(626,69,0,126,1),(627,70,0,126,0),(628,71,0,126,0),(629,46,0,127,1),(630,54,0,127,1),(631,69,0,127,1),(632,70,0,127,0),(633,71,0,127,0),(634,46,0,128,1),(635,54,0,128,1),(636,69,0,128,1),(637,70,0,128,0),(638,71,0,128,0),(639,53,0,9,NULL),(640,53,0,3,NULL),(641,53,0,5,NULL),(642,53,0,15,NULL),(643,53,0,11,NULL),(644,53,0,4,NULL),(645,53,0,7,NULL),(646,53,0,6,NULL),(647,46,0,129,1),(648,54,0,129,1),(649,69,0,129,1),(650,70,0,129,0),(651,71,0,129,0),(652,46,0,130,1),(653,54,0,130,1),(654,69,0,130,1),(655,70,0,130,0),(656,71,0,130,0),(657,46,0,131,1),(658,54,0,131,1),(659,69,0,131,1),(660,70,0,131,0),(661,71,0,131,0),(662,46,0,132,1),(663,54,0,132,1),(664,69,0,132,1),(665,70,0,132,0),(666,71,0,132,0),(667,46,0,133,1),(668,54,0,133,1),(669,69,0,133,1),(670,70,0,133,0),(671,71,0,133,0),(672,46,0,134,1),(673,54,0,134,1),(674,69,0,134,1),(675,70,0,134,0),(676,71,0,134,0),(677,46,0,135,1),(678,54,0,135,1),(679,69,0,135,1),(680,70,0,135,0),(681,71,0,135,0),(682,46,0,136,1),(683,54,0,136,1),(684,69,0,136,1),(685,70,0,136,0),(686,71,0,136,0),(687,46,0,137,1),(688,54,0,137,1),(689,69,0,137,1),(690,70,0,137,0),(691,71,0,137,0),(692,46,0,138,1),(693,54,0,138,1),(694,69,0,138,1),(695,70,0,138,0),(696,71,0,138,0),(697,46,0,139,1),(698,54,0,139,1),(699,69,0,139,1),(700,70,0,139,0),(701,71,0,139,0),(702,46,0,140,1),(703,54,0,140,1),(704,69,0,140,1),(705,70,0,140,0),(706,71,0,140,0),(707,46,0,141,1),(708,54,0,141,1),(709,69,0,141,1),(710,70,0,141,0),(711,71,0,141,0),(712,46,0,142,1),(713,54,0,142,1),(714,69,0,142,1),(715,70,0,142,0),(716,71,0,142,0),(717,46,0,143,1),(718,54,0,143,1),(719,69,0,143,1),(720,70,0,143,0),(721,71,0,143,0),(722,46,0,144,1),(723,54,0,144,1),(724,69,0,144,1),(725,70,0,144,0),(726,71,0,144,0),(727,69,3,4,0),(728,69,3,9,0),(729,69,3,11,0),(730,69,3,12,0),(731,69,3,15,0),(732,69,3,10,0),(733,69,3,13,0),(734,69,3,7,0),(735,69,3,14,0),(736,69,3,6,0),(738,69,7,4,0),(739,69,7,6,0),(740,69,7,7,0),(741,69,7,9,0),(742,69,7,10,0),(743,69,7,11,0),(744,69,7,15,0),(745,69,7,13,0),(746,69,7,12,0),(747,69,7,14,0),(748,69,8,4,0),(749,69,8,5,0),(751,69,8,7,0),(752,69,8,9,0),(753,69,8,10,0),(754,69,8,11,0),(755,69,8,12,0),(756,69,8,13,0),(757,69,8,14,0),(758,69,8,15,0),(759,69,9,4,0),(760,69,9,6,0),(761,69,9,7,0),(762,69,9,9,0),(763,69,9,10,0),(764,69,9,11,0),(765,69,9,12,0),(766,69,9,13,0),(767,69,9,15,0),(768,69,9,14,0),(769,69,3,5,0),(770,46,0,145,1),(771,54,0,145,1),(772,69,0,145,0),(773,70,0,145,0),(774,71,0,145,0),(775,53,0,145,NULL),(776,69,12,4,0),(777,69,12,5,0),(778,69,12,13,0),(779,69,12,15,0),(780,69,12,14,0),(781,69,12,9,0),(782,69,12,10,0),(783,69,12,12,0),(784,69,12,7,0),(785,69,12,11,0),(786,53,0,13,NULL),(787,69,14,15,0),(788,69,14,4,0),(789,69,14,9,0),(790,69,14,10,0),(791,69,14,13,0),(792,69,14,7,0),(793,69,14,11,0),(794,69,14,12,0),(795,69,14,5,0),(796,69,14,14,0),(797,69,17,4,0),(798,69,17,9,0),(799,69,17,10,0),(800,69,17,13,0),(801,69,17,15,0),(802,69,17,5,0),(803,69,17,7,0),(804,69,17,11,0),(805,69,17,14,0),(806,69,17,12,0),(812,46,0,147,1),(813,54,0,147,1),(814,69,0,147,1),(815,70,0,147,0),(816,71,0,147,0),(817,46,0,148,1),(818,54,0,148,1),(819,69,0,148,1),(820,70,0,148,0),(821,71,0,148,0),(822,46,0,149,1),(823,54,0,149,1),(824,69,0,149,1),(825,70,0,149,0),(826,71,0,149,0),(827,53,0,147,NULL),(828,53,0,148,NULL),(829,53,0,149,NULL),(830,46,0,150,1),(831,54,0,150,1),(832,69,0,150,0),(833,70,0,150,0),(834,71,0,150,0),(835,46,0,151,1),(836,54,0,151,1),(837,69,0,151,1),(838,70,0,151,0),(839,71,0,151,0),(840,46,0,152,1),(841,54,0,152,1),(842,69,0,152,1),(843,70,0,152,0),(844,71,0,152,0),(845,46,0,153,1),(846,54,0,153,1),(847,69,0,153,1),(848,70,0,153,0),(849,71,0,153,0),(850,46,0,154,1),(851,54,0,154,1),(852,69,0,154,1),(853,70,0,154,0),(854,71,0,154,0),(855,46,0,155,1),(856,54,0,155,1),(857,69,0,155,1),(858,70,0,155,0),(859,71,0,155,0),(860,46,0,156,1),(861,54,0,156,1),(862,69,0,156,1),(863,70,0,156,0),(864,71,0,156,0),(865,46,0,157,1),(866,54,0,157,1),(867,69,0,157,1),(868,70,0,157,0),(869,71,0,157,0),(870,46,0,158,1),(871,54,0,158,1),(872,69,0,158,1),(873,70,0,158,0),(874,71,0,158,0),(875,46,0,159,1),(876,54,0,159,1),(877,69,0,159,1),(878,70,0,159,0),(879,71,0,159,0),(880,53,0,151,NULL),(881,53,0,152,NULL),(882,53,0,153,NULL),(883,53,0,154,NULL),(884,53,0,155,NULL),(885,53,0,156,NULL),(886,53,0,157,NULL),(887,53,0,158,NULL),(888,53,0,159,NULL),(889,69,18,4,0),(890,69,18,9,0),(891,69,18,10,0),(892,69,18,12,0),(893,69,18,13,0),(894,69,18,15,0),(895,69,18,11,0),(896,69,18,7,0),(897,69,18,5,0),(898,69,18,14,0),(899,69,19,4,0),(900,69,19,9,0),(901,69,19,10,0),(902,69,19,13,0),(903,69,19,15,0),(904,69,19,14,0),(905,69,19,12,0),(906,69,19,7,0),(907,69,19,6,0),(908,69,19,17,0),(910,46,0,160,1),(911,54,0,160,1),(912,69,0,160,1),(913,70,0,160,0),(914,71,0,160,0),(915,46,0,161,1),(916,54,0,161,1),(917,69,0,161,1),(918,70,0,161,0),(919,71,0,161,0),(920,46,0,162,1),(921,54,0,162,1),(922,69,0,162,1),(923,70,0,162,0),(924,71,0,162,0),(925,46,0,163,1),(926,54,0,163,1),(927,69,0,163,1),(928,70,0,163,0),(929,71,0,163,0),(930,46,0,164,1),(931,54,0,164,1),(932,69,0,164,1),(933,70,0,164,0),(934,71,0,164,0),(935,46,0,165,1),(936,54,0,165,1),(937,69,0,165,1),(938,70,0,165,0),(939,71,0,165,0),(940,46,0,166,1),(941,54,0,166,1),(942,69,0,166,1),(943,70,0,166,0),(944,71,0,166,0),(945,46,0,167,1),(946,54,0,167,1),(947,69,0,167,1),(948,70,0,167,0),(949,71,0,167,0),(950,46,0,168,1),(951,54,0,168,1),(952,69,0,168,1),(953,70,0,168,0),(954,71,0,168,0),(955,46,0,169,1),(956,54,0,169,1),(957,69,0,169,1),(958,70,0,169,0),(959,71,0,169,0),(960,46,0,170,1),(961,54,0,170,1),(962,69,0,170,1),(963,70,0,170,0),(964,71,0,170,0),(965,46,0,171,1),(966,54,0,171,1),(967,69,0,171,1),(968,70,0,171,0),(969,71,0,171,0),(970,53,0,162,NULL),(971,53,0,163,NULL),(972,53,0,164,NULL),(973,53,0,165,NULL),(974,53,0,166,NULL),(975,53,0,167,NULL),(976,53,0,168,NULL),(977,53,0,169,NULL),(978,53,0,170,NULL),(979,53,0,171,NULL),(980,69,20,4,0),(981,69,20,9,0),(982,69,20,13,0),(983,69,20,15,0),(984,69,20,10,0),(985,69,20,12,0),(986,69,20,11,0),(987,69,20,14,0),(988,69,20,17,0),(989,69,20,8,0),(990,46,0,172,1),(991,54,0,172,1),(992,69,0,172,0),(993,70,0,172,0),(994,71,0,172,0),(995,46,0,173,1),(996,54,0,173,1),(997,69,0,173,1),(998,70,0,173,0),(999,71,0,173,0),(1000,46,0,174,1),(1001,54,0,174,1),(1002,69,0,174,1),(1003,70,0,174,0),(1004,71,0,174,0),(1005,46,0,175,1),(1006,54,0,175,1),(1007,69,0,175,1),(1008,70,0,175,0),(1009,71,0,175,0),(1010,46,0,176,1),(1011,54,0,176,1),(1012,69,0,176,1),(1013,70,0,176,0),(1014,71,0,176,0),(1015,53,0,172,NULL),(1016,53,0,173,NULL),(1017,53,0,174,NULL),(1018,53,0,175,NULL),(1019,53,0,176,NULL),(1020,46,0,177,1),(1021,54,0,177,0),(1022,69,0,177,1),(1023,70,0,177,0),(1024,71,0,177,0),(1025,53,0,177,NULL),(1026,46,0,178,1),(1027,54,0,178,1),(1028,69,0,178,0),(1029,70,0,178,0),(1030,71,0,178,0),(1031,53,0,178,NULL),(1032,69,21,9,0),(1033,69,21,4,0),(1034,69,21,10,0),(1035,69,21,13,0),(1036,69,21,15,0),(1037,69,21,7,0),(1038,69,21,14,0),(1039,69,21,5,0),(1040,69,21,11,0),(1041,69,21,6,0),(1042,46,0,179,1),(1043,54,0,179,1),(1044,69,0,179,1),(1045,70,0,179,0),(1046,71,0,179,0),(1047,46,0,180,1),(1048,54,0,180,1),(1049,69,0,180,1),(1050,70,0,180,0),(1051,71,0,180,0),(1052,46,0,181,1),(1053,54,0,181,1),(1054,69,0,181,1),(1055,70,0,181,0),(1056,71,0,181,0),(1057,46,0,182,1),(1058,54,0,182,1),(1059,69,0,182,1),(1060,70,0,182,0),(1061,71,0,182,0),(1062,46,0,183,1),(1063,54,0,183,1),(1064,69,0,183,1),(1065,70,0,183,0),(1066,71,0,183,0),(1067,46,0,184,1),(1068,54,0,184,1),(1069,69,0,184,1),(1070,70,0,184,0),(1071,71,0,184,0),(1072,53,0,180,NULL),(1073,53,0,181,NULL),(1074,53,0,182,NULL),(1075,53,0,183,NULL),(1076,53,0,184,NULL),(1077,46,0,185,1),(1078,54,0,185,1),(1079,69,0,185,1),(1080,70,0,185,0),(1081,71,0,185,0),(1082,46,0,186,1),(1083,54,0,186,1),(1084,69,0,186,1),(1085,70,0,186,0),(1086,71,0,186,0),(1087,46,0,187,1),(1088,54,0,187,1),(1089,69,0,187,1),(1090,70,0,187,0),(1091,71,0,187,0),(1092,46,0,188,1),(1093,54,0,188,1),(1094,69,0,188,1),(1095,70,0,188,0),(1096,71,0,188,0),(1097,46,0,189,1),(1098,54,0,189,1),(1099,69,0,189,1),(1100,70,0,189,0),(1101,71,0,189,0),(1102,46,0,190,1),(1103,54,0,190,1),(1104,69,0,190,1),(1105,70,0,190,0),(1106,71,0,190,0),(1107,46,0,191,1),(1108,54,0,191,1),(1109,69,0,191,0),(1110,70,0,191,0),(1111,71,0,191,0),(1112,69,23,4,0),(1113,69,23,10,0),(1114,69,23,9,0),(1115,69,23,15,0),(1116,69,23,7,0),(1117,69,23,13,0),(1118,69,23,12,0),(1119,69,23,14,0),(1120,69,23,11,0),(1121,69,23,6,0),(1122,46,0,192,1),(1123,54,0,192,1),(1124,69,0,192,1),(1125,70,0,192,0),(1126,71,0,192,0),(1127,69,24,13,0),(1128,69,24,4,0),(1129,69,24,9,0),(1130,69,24,15,0),(1131,69,24,10,0),(1132,69,24,7,0),(1133,69,24,3,0),(1134,69,24,6,0),(1135,69,24,12,0),(1136,46,0,193,1),(1137,54,0,193,1),(1138,69,0,193,1),(1139,70,0,193,0),(1140,71,0,193,0),(1141,46,0,194,1),(1142,54,0,194,1),(1143,69,0,194,1),(1144,70,0,194,0),(1145,71,0,194,0),(1146,46,0,195,1),(1147,54,0,195,1),(1148,69,0,195,1),(1149,70,0,195,0),(1150,71,0,195,0),(1151,46,0,196,1),(1152,54,0,196,1),(1153,69,0,196,1),(1154,70,0,196,0),(1155,71,0,196,0),(1156,46,0,197,1),(1157,54,0,197,1),(1158,69,0,197,1),(1159,70,0,197,0),(1160,71,0,197,0),(1161,53,0,193,NULL),(1162,53,0,194,NULL),(1163,53,0,195,NULL),(1164,53,0,196,NULL),(1165,53,0,197,NULL),(1166,69,25,4,0),(1167,69,25,9,0),(1168,69,25,10,0),(1169,69,25,13,0),(1170,69,25,15,0),(1171,69,25,12,0),(1172,69,25,5,0),(1173,69,25,3,0),(1174,69,25,11,0),(1175,69,25,14,0),(1176,46,0,198,1),(1177,54,0,198,1),(1178,69,0,198,1),(1179,70,0,198,0),(1180,71,0,198,0),(1181,46,0,199,1),(1182,54,0,199,1),(1183,69,0,199,1),(1184,70,0,199,0),(1185,71,0,199,0),(1186,46,0,200,1),(1187,54,0,200,1),(1188,69,0,200,1),(1189,70,0,200,0),(1190,71,0,200,0),(1191,46,0,201,1),(1192,54,0,201,1),(1193,69,0,201,1),(1194,70,0,201,0),(1195,71,0,201,0),(1196,46,0,202,1),(1197,54,0,202,1),(1198,69,0,202,1),(1199,70,0,202,0),(1200,71,0,202,0),(1201,46,0,203,1),(1202,54,0,203,1),(1203,69,0,203,1),(1204,70,0,203,0),(1205,71,0,203,0),(1206,53,0,198,NULL),(1207,53,0,199,NULL),(1208,53,0,200,NULL),(1209,53,0,201,NULL),(1210,53,0,202,NULL),(1211,53,0,203,NULL),(1212,46,0,204,1),(1213,54,0,204,1),(1214,69,0,204,1),(1215,70,0,204,0),(1216,71,0,204,0),(1217,46,0,205,1),(1218,54,0,205,1),(1219,69,0,205,1),(1220,70,0,205,0),(1221,71,0,205,0),(1222,69,26,4,0),(1223,69,26,9,0),(1224,69,26,13,0),(1225,69,26,15,0),(1226,69,26,10,0),(1227,69,26,6,0),(1228,69,26,14,0),(1229,69,26,7,0),(1230,69,26,11,0),(1231,69,26,12,0),(1232,46,0,206,1),(1233,54,0,206,1),(1234,69,0,206,1),(1235,70,0,206,0),(1236,71,0,206,0),(1237,46,0,207,1),(1238,54,0,207,1),(1239,69,0,207,1),(1240,70,0,207,0),(1241,71,0,207,0),(1242,46,0,208,1),(1243,54,0,208,1),(1244,69,0,208,1),(1245,70,0,208,0),(1246,71,0,208,0),(1247,46,0,209,1),(1248,54,0,209,1),(1249,69,0,209,1),(1250,70,0,209,0),(1251,71,0,209,0),(1252,46,0,210,1),(1253,54,0,210,1),(1254,69,0,210,1),(1255,70,0,210,0),(1256,71,0,210,0),(1257,46,0,211,1),(1258,54,0,211,1),(1259,69,0,211,1),(1260,70,0,211,0),(1261,71,0,211,0),(1262,46,0,212,1),(1263,54,0,212,1),(1264,69,0,212,1),(1265,70,0,212,0),(1266,71,0,212,0),(1267,46,0,213,1),(1268,54,0,213,1),(1269,69,0,213,1),(1270,70,0,213,0),(1271,71,0,213,0),(1272,46,0,214,1),(1273,54,0,214,1),(1274,69,0,214,1),(1275,70,0,214,0),(1276,71,0,214,0),(1277,46,0,215,1),(1278,54,0,215,1),(1279,69,0,215,1),(1280,70,0,215,0),(1281,71,0,215,0),(1282,46,0,216,1),(1283,54,0,216,1),(1284,69,0,216,1),(1285,70,0,216,0),(1286,71,0,216,0),(1287,46,0,217,1),(1288,54,0,217,1),(1289,69,0,217,1),(1290,70,0,217,0),(1291,71,0,217,0),(1292,53,0,217,NULL),(1293,53,0,213,NULL),(1294,46,0,218,1),(1295,54,0,218,1),(1296,69,0,218,1),(1297,70,0,218,0),(1298,71,0,218,0),(1299,46,0,219,1),(1300,54,0,219,1),(1301,69,0,219,1),(1302,70,0,219,0),(1303,71,0,219,0),(1304,46,0,220,1),(1305,54,0,220,1),(1306,69,0,220,1),(1307,70,0,220,0),(1308,71,0,220,0),(1309,46,0,221,1),(1310,54,0,221,1),(1311,69,0,221,1),(1312,70,0,221,0),(1313,71,0,221,0),(1314,46,0,222,1),(1315,54,0,222,1),(1316,69,0,222,1),(1317,70,0,222,0),(1318,71,0,222,0),(1319,46,0,223,1),(1320,54,0,223,1),(1321,69,0,223,1),(1322,70,0,223,0),(1323,71,0,223,0),(1324,46,0,224,1),(1325,54,0,224,1),(1326,69,0,224,1),(1327,70,0,224,0),(1328,71,0,224,0),(1329,46,0,225,1),(1330,54,0,225,1),(1331,69,0,225,1),(1332,70,0,225,0),(1333,71,0,225,0),(1334,46,0,226,1),(1335,54,0,226,1),(1336,69,0,226,1),(1337,70,0,226,0),(1338,71,0,226,0),(1339,46,0,227,1),(1340,54,0,227,1),(1341,69,0,227,1),(1342,70,0,227,0),(1343,71,0,227,0),(1344,46,0,228,1),(1345,54,0,228,1),(1346,69,0,228,1),(1347,70,0,228,0),(1348,71,0,228,0),(1349,46,0,229,1),(1350,54,0,229,1),(1351,69,0,229,1),(1352,70,0,229,0),(1353,71,0,229,0),(1354,46,0,230,1),(1355,54,0,230,1),(1356,69,0,230,1),(1357,70,0,230,0),(1358,71,0,230,0),(1359,46,0,231,1),(1360,54,0,231,1),(1361,69,0,231,1),(1362,70,0,231,0),(1363,71,0,231,0),(1364,46,0,232,1),(1365,54,0,232,1),(1366,69,0,232,1),(1367,70,0,232,0),(1368,71,0,232,0),(1369,46,0,233,1),(1370,54,0,233,1),(1371,69,0,233,1),(1372,70,0,233,0),(1373,71,0,233,0),(1374,46,0,234,1),(1375,54,0,234,1),(1376,69,0,234,1),(1377,70,0,234,0),(1378,71,0,234,0),(1379,46,0,235,1),(1380,54,0,235,1),(1381,69,0,235,1),(1382,70,0,235,0),(1383,71,0,235,0),(1384,46,0,236,1),(1385,54,0,236,1),(1386,69,0,236,1),(1387,70,0,236,0),(1388,71,0,236,0),(1389,46,0,237,1),(1390,54,0,237,1),(1391,69,0,237,1),(1392,70,0,237,0),(1393,71,0,237,0),(1394,46,0,238,1),(1395,54,0,238,1),(1396,69,0,238,1),(1397,70,0,238,0),(1398,71,0,238,0),(1399,46,0,239,1),(1400,54,0,239,1),(1401,69,0,239,1),(1402,70,0,239,0),(1403,71,0,239,0),(1404,46,0,240,1),(1405,54,0,240,1),(1406,69,0,240,1),(1407,70,0,240,0),(1408,71,0,240,0),(1409,46,0,241,1),(1410,54,0,241,1),(1411,69,0,241,1),(1412,70,0,241,0),(1413,71,0,241,0),(1414,46,0,242,1),(1415,54,0,242,1),(1416,69,0,242,1),(1417,70,0,242,0),(1418,71,0,242,0),(1419,46,0,243,1),(1420,54,0,243,1),(1421,69,0,243,1),(1422,70,0,243,0),(1423,71,0,243,0),(1424,46,0,244,1),(1425,54,0,244,1),(1426,69,0,244,1),(1427,70,0,244,0),(1428,71,0,244,0),(1429,46,0,245,1),(1430,54,0,245,1),(1431,69,0,245,1),(1432,70,0,245,0),(1433,71,0,245,0),(1434,46,0,246,1),(1435,54,0,246,1),(1436,69,0,246,1),(1437,70,0,246,0),(1438,71,0,246,0),(1439,46,0,247,1),(1440,54,0,247,1),(1441,69,0,247,1),(1442,70,0,247,0),(1443,71,0,247,0),(1444,46,0,248,1),(1445,54,0,248,1),(1446,69,0,248,1),(1447,70,0,248,0),(1448,71,0,248,0),(1449,46,0,249,1),(1450,54,0,249,1),(1451,69,0,249,1),(1452,70,0,249,0),(1453,71,0,249,0),(1454,53,0,207,NULL),(1455,53,0,208,NULL),(1456,53,0,209,NULL),(1457,53,0,210,NULL),(1458,53,0,211,NULL),(1459,53,0,212,NULL),(1460,53,0,214,NULL),(1461,53,0,215,NULL),(1462,53,0,216,NULL),(1463,53,0,218,NULL),(1464,69,27,4,0),(1465,69,27,9,0),(1466,69,27,13,0),(1467,69,27,15,0),(1468,69,27,10,0),(1469,69,27,12,0),(1470,69,27,7,0),(1471,69,27,5,0),(1472,69,27,6,0),(1473,69,27,11,0),(1475,46,0,250,1),(1476,54,0,250,1),(1477,69,0,250,1),(1478,70,0,250,0),(1479,71,0,250,0),(1480,46,0,251,1),(1481,54,0,251,1),(1482,69,0,251,1),(1483,70,0,251,0),(1484,71,0,251,0),(1485,46,0,252,1),(1486,54,0,252,1),(1487,69,0,252,1),(1488,70,0,252,0),(1489,71,0,252,0),(1490,46,0,253,1),(1491,54,0,253,1),(1492,69,0,253,1),(1493,70,0,253,0),(1494,71,0,253,0),(1495,46,0,254,1),(1496,54,0,254,1),(1497,69,0,254,1),(1498,70,0,254,0),(1499,71,0,254,0),(1500,46,0,255,1),(1501,54,0,255,1),(1502,69,0,255,1),(1503,70,0,255,0),(1504,71,0,255,0),(1505,46,0,256,1),(1506,54,0,256,1),(1507,69,0,256,1),(1508,70,0,256,0),(1509,71,0,256,0),(1510,46,0,257,1),(1511,54,0,257,1),(1512,69,0,257,1),(1513,70,0,257,0),(1514,71,0,257,0),(1515,46,0,258,1),(1516,54,0,258,1),(1517,69,0,258,1),(1518,70,0,258,0),(1519,71,0,258,0),(1520,46,0,259,1),(1521,54,0,259,1),(1522,69,0,259,1),(1523,70,0,259,0),(1524,71,0,259,0),(1525,46,0,260,1),(1526,54,0,260,1),(1527,69,0,260,1),(1528,70,0,260,0),(1529,71,0,260,0),(1530,46,0,261,1),(1531,54,0,261,1),(1532,69,0,261,1),(1533,70,0,261,0),(1534,71,0,261,0),(1535,46,0,262,1),(1536,54,0,262,1),(1537,69,0,262,1),(1538,70,0,262,0),(1539,71,0,262,0),(1540,53,0,252,NULL),(1541,46,0,263,1),(1542,54,0,263,1),(1543,69,0,263,1),(1544,70,0,263,0),(1545,71,0,263,0),(1546,46,0,264,1),(1547,54,0,264,1),(1548,69,0,264,1),(1549,70,0,264,0),(1550,71,0,264,0),(1551,46,0,265,1),(1552,54,0,265,1),(1553,69,0,265,1),(1554,70,0,265,0),(1555,71,0,265,0),(1556,46,0,266,1),(1557,54,0,266,1),(1558,69,0,266,1),(1559,70,0,266,0),(1560,71,0,266,0),(1561,53,0,253,NULL),(1562,46,0,267,1),(1563,54,0,267,1),(1564,69,0,267,1),(1565,70,0,267,0),(1566,71,0,267,0),(1567,46,0,268,1),(1568,54,0,268,1),(1569,69,0,268,1),(1570,70,0,268,0),(1571,71,0,268,0),(1572,46,0,269,1),(1573,54,0,269,1),(1574,69,0,269,1),(1575,70,0,269,0),(1576,71,0,269,0),(1577,46,0,270,1),(1578,54,0,270,1),(1579,69,0,270,1),(1580,70,0,270,0),(1581,71,0,270,0),(1582,46,0,271,1),(1583,54,0,271,1),(1584,69,0,271,1),(1585,70,0,271,0),(1586,71,0,271,0),(1587,46,0,272,1),(1588,54,0,272,1),(1589,69,0,272,1),(1590,70,0,272,0),(1591,71,0,272,0),(1592,46,0,273,1),(1593,54,0,273,1),(1594,69,0,273,1),(1595,70,0,273,0),(1596,71,0,273,0),(1597,46,0,274,1),(1598,54,0,274,1),(1599,69,0,274,1),(1600,70,0,274,0),(1601,71,0,274,0),(1602,46,0,275,1),(1603,54,0,275,1),(1604,69,0,275,1),(1605,70,0,275,0),(1606,71,0,275,0),(1607,46,0,276,1),(1608,54,0,276,1),(1609,69,0,276,1),(1610,70,0,276,0),(1611,71,0,276,0),(1612,46,0,277,1),(1613,54,0,277,1),(1614,69,0,277,1),(1615,70,0,277,0),(1616,71,0,277,0),(1617,46,0,278,1),(1618,54,0,278,1),(1619,69,0,278,1),(1620,70,0,278,0),(1621,71,0,278,0),(1622,46,0,279,1),(1623,54,0,279,1),(1624,69,0,279,1),(1625,70,0,279,0),(1626,71,0,279,0),(1627,53,0,250,NULL),(1628,53,0,251,NULL),(1629,53,0,254,NULL),(1630,53,0,275,NULL),(1631,53,0,259,NULL),(1632,53,0,263,NULL),(1633,69,28,4,0),(1634,69,28,5,0),(1635,69,28,7,0),(1636,69,28,9,0),(1637,69,28,10,0),(1638,69,28,13,0),(1639,69,28,15,0),(1640,69,28,14,0),(1641,69,28,12,0),(1642,69,28,6,0),(1643,46,0,280,1),(1644,54,0,280,1),(1645,69,0,280,1),(1646,70,0,280,0),(1647,71,0,280,0),(1648,46,0,281,1),(1649,54,0,281,1),(1650,69,0,281,1),(1651,70,0,281,0),(1652,71,0,281,0),(1653,46,0,282,1),(1654,54,0,282,1),(1655,69,0,282,1),(1656,70,0,282,0),(1657,71,0,282,0),(1658,46,0,283,1),(1659,54,0,283,1),(1660,69,0,283,1),(1661,70,0,283,0),(1662,71,0,283,0),(1663,46,0,284,1),(1664,54,0,284,1),(1665,69,0,284,1),(1666,70,0,284,0),(1667,71,0,284,0),(1668,46,0,285,1),(1669,54,0,285,1),(1670,69,0,285,1),(1671,70,0,285,0),(1672,71,0,285,0),(1673,53,0,280,NULL),(1674,53,0,281,NULL),(1675,53,0,282,NULL),(1676,53,0,283,NULL),(1677,53,0,284,NULL),(1678,53,0,285,NULL),(1679,46,0,286,1),(1680,54,0,286,1),(1681,69,0,286,0),(1682,70,0,286,0),(1683,71,0,286,0),(1684,53,0,286,NULL),(1685,46,0,287,1),(1686,54,0,287,1),(1687,69,0,287,0),(1688,70,0,287,0),(1689,71,0,287,0),(1690,69,29,4,0),(1691,69,29,9,0),(1692,69,29,13,0),(1693,69,29,15,0),(1694,69,29,14,0),(1695,69,29,7,0),(1696,69,29,10,0),(1697,69,29,12,0),(1698,69,29,11,0),(1699,69,29,17,0),(1700,46,0,288,1),(1701,54,0,288,1),(1702,69,0,288,1),(1703,70,0,288,0),(1704,71,0,288,0),(1705,69,30,4,0),(1706,69,30,9,0),(1707,69,30,10,0),(1708,69,30,12,0),(1709,69,30,13,0),(1710,69,30,15,0),(1711,69,30,16,0),(1712,69,30,7,0),(1713,69,30,6,0),(1714,69,30,11,0),(1715,46,0,289,1),(1716,54,0,289,1),(1717,69,0,289,1),(1718,70,0,289,0),(1719,71,0,289,0),(1720,46,0,290,1),(1721,54,0,290,1),(1722,69,0,290,1),(1723,70,0,290,0),(1724,71,0,290,0),(1725,46,0,291,1),(1726,54,0,291,1),(1727,69,0,291,1),(1728,70,0,291,0),(1729,71,0,291,0),(1730,46,0,292,1),(1731,54,0,292,1),(1732,69,0,292,1),(1733,70,0,292,0),(1734,71,0,292,0),(1735,46,0,293,1),(1736,54,0,293,1),(1737,69,0,293,1),(1738,70,0,293,0),(1739,71,0,293,0),(1740,46,0,294,1),(1741,54,0,294,1),(1742,69,0,294,1),(1743,70,0,294,0),(1744,71,0,294,0),(1745,69,31,10,0),(1746,69,31,9,0),(1747,69,31,13,0),(1748,69,31,15,0),(1749,69,31,4,0),(1750,69,31,14,0),(1751,69,31,7,0),(1752,69,31,12,0),(1753,69,31,11,0),(1754,69,31,17,0),(1755,46,0,295,1),(1756,54,0,295,1),(1757,69,0,295,1),(1758,70,0,295,0),(1759,71,0,295,0),(1760,46,0,296,1),(1761,54,0,296,1),(1762,69,0,296,1),(1763,70,0,296,0),(1764,71,0,296,0),(1765,46,0,297,1),(1766,54,0,297,1),(1767,69,0,297,1),(1768,70,0,297,0),(1769,71,0,297,0),(1770,46,0,298,1),(1771,54,0,298,1),(1772,69,0,298,1),(1773,70,0,298,0),(1774,71,0,298,0),(1775,46,0,299,1),(1776,54,0,299,1),(1777,69,0,299,1),(1778,70,0,299,0),(1779,71,0,299,0),(1780,53,0,295,NULL),(1781,53,0,296,NULL),(1782,53,0,297,NULL),(1783,53,0,298,NULL),(1784,53,0,299,NULL),(1785,53,0,293,NULL);
/*!40000 ALTER TABLE `catalog_category_entity_int` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_entity_text`
--

DROP TABLE IF EXISTS `catalog_category_entity_text`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_entity_text` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` mediumtext COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_CATEGORY_ENTITY_TEXT_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_CATEGORY_ENTITY_TEXT_ENTITY_ID` (`entity_id`),
  KEY `CATALOG_CATEGORY_ENTITY_TEXT_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_CATEGORY_ENTITY_TEXT_STORE_ID` (`store_id`),
  CONSTRAINT `CAT_CTGR_ENTT_TEXT_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_CTGR_ENTT_TEXT_ENTT_ID_CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CATALOG_CATEGORY_ENTITY_TEXT_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=280 DEFAULT CHARSET=utf8 COMMENT='Catalog Category Text Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_entity_text`
--

LOCK TABLES `catalog_category_entity_text` WRITE;
/*!40000 ALTER TABLE `catalog_category_entity_text` DISABLE KEYS */;
INSERT INTO `catalog_category_entity_text` VALUES (1,47,0,18,NULL),(2,50,0,18,NULL),(3,51,0,18,NULL),(4,47,0,19,NULL),(5,50,0,19,NULL),(6,51,0,19,NULL),(7,47,0,20,NULL),(8,50,0,20,NULL),(9,51,0,20,NULL),(10,47,0,21,NULL),(11,50,0,21,NULL),(12,51,0,21,NULL),(13,47,0,97,NULL),(14,50,0,97,NULL),(15,51,0,97,NULL),(16,47,0,9,NULL),(17,50,0,9,NULL),(18,51,0,9,NULL),(19,47,0,3,NULL),(20,50,0,3,NULL),(21,51,0,3,NULL),(22,47,0,5,NULL),(23,50,0,5,NULL),(24,51,0,5,NULL),(25,47,0,15,NULL),(26,50,0,15,NULL),(27,51,0,15,NULL),(28,47,0,11,NULL),(29,50,0,11,NULL),(30,51,0,11,NULL),(31,47,0,4,NULL),(32,50,0,4,NULL),(33,51,0,4,NULL),(34,47,0,7,NULL),(35,50,0,7,NULL),(36,51,0,7,NULL),(37,47,0,6,NULL),(38,50,0,6,NULL),(39,51,0,6,NULL),(40,47,0,145,NULL),(41,50,0,145,NULL),(42,51,0,145,NULL),(43,47,0,13,NULL),(44,50,0,13,NULL),(45,51,0,13,NULL),(46,47,0,147,NULL),(47,50,0,147,NULL),(48,51,0,147,NULL),(49,47,0,148,NULL),(50,50,0,148,NULL),(51,51,0,148,NULL),(52,47,0,149,NULL),(53,50,0,149,NULL),(54,51,0,149,NULL),(55,47,0,151,NULL),(56,50,0,151,NULL),(57,51,0,151,NULL),(58,47,0,152,NULL),(59,50,0,152,NULL),(60,51,0,152,NULL),(61,47,0,153,NULL),(62,50,0,153,NULL),(63,51,0,153,NULL),(64,47,0,154,NULL),(65,50,0,154,NULL),(66,51,0,154,NULL),(67,47,0,155,NULL),(68,50,0,155,NULL),(69,51,0,155,NULL),(70,47,0,156,NULL),(71,50,0,156,NULL),(72,51,0,156,NULL),(73,47,0,157,NULL),(74,50,0,157,NULL),(75,51,0,157,NULL),(76,47,0,158,NULL),(77,50,0,158,NULL),(78,51,0,158,NULL),(79,47,0,159,NULL),(80,50,0,159,NULL),(81,51,0,159,NULL),(82,47,0,162,NULL),(83,50,0,162,NULL),(84,51,0,162,NULL),(85,47,0,163,NULL),(86,50,0,163,NULL),(87,51,0,163,NULL),(88,47,0,164,NULL),(89,50,0,164,NULL),(90,51,0,164,NULL),(91,47,0,165,NULL),(92,50,0,165,NULL),(93,51,0,165,NULL),(94,47,0,166,NULL),(95,50,0,166,NULL),(96,51,0,166,NULL),(97,47,0,167,NULL),(98,50,0,167,NULL),(99,51,0,167,NULL),(100,47,0,168,NULL),(101,50,0,168,NULL),(102,51,0,168,NULL),(103,47,0,169,NULL),(104,50,0,169,NULL),(105,51,0,169,NULL),(106,47,0,170,NULL),(107,50,0,170,NULL),(108,51,0,170,NULL),(109,47,0,171,NULL),(110,50,0,171,NULL),(111,51,0,171,NULL),(112,47,0,172,NULL),(113,50,0,172,NULL),(114,51,0,172,NULL),(115,47,0,173,NULL),(116,50,0,173,NULL),(117,51,0,173,NULL),(118,47,0,174,NULL),(119,50,0,174,NULL),(120,51,0,174,NULL),(121,47,0,175,NULL),(122,50,0,175,NULL),(123,51,0,175,NULL),(124,47,0,176,NULL),(125,50,0,176,NULL),(126,51,0,176,NULL),(127,47,0,177,NULL),(128,50,0,177,NULL),(129,51,0,177,NULL),(130,47,0,178,NULL),(131,50,0,178,NULL),(132,51,0,178,NULL),(133,47,0,180,NULL),(134,50,0,180,NULL),(135,51,0,180,NULL),(136,47,0,181,NULL),(137,50,0,181,NULL),(138,51,0,181,NULL),(139,47,0,182,NULL),(140,50,0,182,NULL),(141,51,0,182,NULL),(142,47,0,183,NULL),(143,50,0,183,NULL),(144,51,0,183,NULL),(145,47,0,184,NULL),(146,50,0,184,NULL),(147,51,0,184,NULL),(148,47,0,193,NULL),(149,50,0,193,NULL),(150,51,0,193,NULL),(151,47,0,194,NULL),(152,50,0,194,NULL),(153,51,0,194,NULL),(154,47,0,195,NULL),(155,50,0,195,NULL),(156,51,0,195,NULL),(157,47,0,196,NULL),(158,50,0,196,NULL),(159,51,0,196,NULL),(160,47,0,197,NULL),(161,50,0,197,NULL),(162,51,0,197,NULL),(163,47,0,198,NULL),(164,50,0,198,NULL),(165,51,0,198,NULL),(166,47,0,199,NULL),(167,50,0,199,NULL),(168,51,0,199,NULL),(169,47,0,200,NULL),(170,50,0,200,NULL),(171,51,0,200,NULL),(172,47,0,201,NULL),(173,50,0,201,NULL),(174,51,0,201,NULL),(175,47,0,202,NULL),(176,50,0,202,NULL),(177,51,0,202,NULL),(178,47,0,203,NULL),(179,50,0,203,NULL),(180,51,0,203,NULL),(181,47,0,217,NULL),(182,50,0,217,NULL),(183,51,0,217,NULL),(184,47,0,213,NULL),(185,50,0,213,NULL),(186,51,0,213,NULL),(187,47,0,207,NULL),(188,50,0,207,NULL),(189,51,0,207,NULL),(190,47,0,208,NULL),(191,50,0,208,NULL),(192,51,0,208,NULL),(193,47,0,209,NULL),(194,50,0,209,NULL),(195,51,0,209,NULL),(196,47,0,210,NULL),(197,50,0,210,NULL),(198,51,0,210,NULL),(199,47,0,211,NULL),(200,50,0,211,NULL),(201,51,0,211,NULL),(202,47,0,212,NULL),(203,50,0,212,NULL),(204,51,0,212,NULL),(205,47,0,214,NULL),(206,50,0,214,NULL),(207,51,0,214,NULL),(208,47,0,215,NULL),(209,50,0,215,NULL),(210,51,0,215,NULL),(211,47,0,216,NULL),(212,50,0,216,NULL),(213,51,0,216,NULL),(214,47,0,218,NULL),(215,50,0,218,NULL),(216,51,0,218,NULL),(217,47,0,252,NULL),(218,50,0,252,NULL),(219,51,0,252,NULL),(220,47,0,253,NULL),(221,50,0,253,NULL),(222,51,0,253,NULL),(223,47,0,250,NULL),(224,50,0,250,NULL),(225,51,0,250,NULL),(226,47,0,251,NULL),(227,50,0,251,NULL),(228,51,0,251,NULL),(229,47,0,254,NULL),(230,50,0,254,NULL),(231,51,0,254,NULL),(232,47,0,275,NULL),(233,50,0,275,NULL),(234,51,0,275,NULL),(235,47,0,259,NULL),(236,50,0,259,NULL),(237,51,0,259,NULL),(238,47,0,263,NULL),(239,50,0,263,NULL),(240,51,0,263,NULL),(241,47,0,280,NULL),(242,50,0,280,NULL),(243,51,0,280,NULL),(244,47,0,281,NULL),(245,50,0,281,NULL),(246,51,0,281,NULL),(247,47,0,282,NULL),(248,50,0,282,NULL),(249,51,0,282,NULL),(250,47,0,283,NULL),(251,50,0,283,NULL),(252,51,0,283,NULL),(253,47,0,284,NULL),(254,50,0,284,NULL),(255,51,0,284,NULL),(256,47,0,285,NULL),(257,50,0,285,NULL),(258,51,0,285,NULL),(259,47,0,286,NULL),(260,50,0,286,NULL),(261,51,0,286,NULL),(262,47,0,295,NULL),(263,50,0,295,NULL),(264,51,0,295,NULL),(265,47,0,296,NULL),(266,50,0,296,NULL),(267,51,0,296,NULL),(268,47,0,297,NULL),(269,50,0,297,NULL),(270,51,0,297,NULL),(271,47,0,298,NULL),(272,50,0,298,NULL),(273,51,0,298,NULL),(274,47,0,299,NULL),(275,50,0,299,NULL),(276,51,0,299,NULL),(277,47,0,293,NULL),(278,50,0,293,NULL),(279,51,0,293,NULL);
/*!40000 ALTER TABLE `catalog_category_entity_text` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_entity_varchar`
--

DROP TABLE IF EXISTS `catalog_category_entity_varchar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_entity_varchar` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` varchar(255) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_CATEGORY_ENTITY_VARCHAR_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_CATEGORY_ENTITY_VARCHAR_ENTITY_ID` (`entity_id`),
  KEY `CATALOG_CATEGORY_ENTITY_VARCHAR_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_CATEGORY_ENTITY_VARCHAR_STORE_ID` (`store_id`),
  CONSTRAINT `CAT_CTGR_ENTT_VCHR_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_CTGR_ENTT_VCHR_ENTT_ID_CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CATALOG_CATEGORY_ENTITY_VARCHAR_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2112 DEFAULT CHARSET=utf8 COMMENT='Catalog Category Varchar Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_entity_varchar`
--

LOCK TABLES `catalog_category_entity_varchar` WRITE;
/*!40000 ALTER TABLE `catalog_category_entity_varchar` DISABLE KEYS */;
INSERT INTO `catalog_category_entity_varchar` VALUES (1,45,0,1,'Root Catalog'),(2,52,0,2,'PRODUCTS'),(3,45,0,2,'Default Category'),(4,45,0,3,'Electronics'),(5,52,0,3,'PRODUCTS'),(6,119,0,3,'electronics'),(7,120,0,3,'electronics'),(8,45,0,4,'Smartphones & Tablets'),(9,52,0,4,'PRODUCTS'),(10,119,0,4,'smartphones-tablets'),(11,120,0,4,'smartphones-tablets'),(12,45,0,5,'Health & Beauty'),(13,52,0,5,'PRODUCTS'),(14,119,0,5,'health-beauty'),(15,120,0,5,'health-beauty'),(16,45,0,6,'Toys & Hobbies'),(17,52,0,6,'PRODUCTS'),(18,119,0,6,'toys-hobbies'),(19,120,0,6,'toys-hobbies'),(20,45,0,7,'Sports & Outdoors'),(21,52,0,7,'PRODUCTS'),(22,119,0,7,'sports-outdoors'),(23,120,0,7,'sports-outdoors'),(24,45,0,8,'Furniture'),(25,52,0,8,'PRODUCTS'),(26,119,0,8,'furniture'),(27,120,0,8,'furniture'),(28,45,0,9,'Automotive & Motorcycle'),(29,52,0,9,'PRODUCTS'),(30,119,0,9,'automotive-motorcycle'),(31,120,0,9,'automotive-motorcycle'),(32,45,0,10,'Laptops & Accessories'),(33,52,0,10,'PRODUCTS'),(34,119,0,10,'laptops-accessories'),(35,120,0,10,'laptops-accessories'),(36,45,0,11,'Jewelry & Watches'),(37,52,0,11,'PRODUCTS'),(38,119,0,11,'jewelry-watches'),(39,120,0,11,'jewelry-watches'),(40,45,0,12,'Flashlights & Lamps'),(41,52,0,12,'PRODUCTS'),(42,119,0,12,'flashlights-lamps'),(43,120,0,12,'flashlights-lamps'),(44,45,0,13,'Bags, Shoes & Accessories'),(45,52,0,13,'PRODUCTS'),(46,119,0,13,'bags-shoes-accessories'),(47,120,0,13,'bags-shoes-accessories'),(48,45,0,14,'Cameras & Photo'),(49,52,0,14,'PRODUCTS'),(50,119,0,14,'cameras-photo'),(51,120,0,14,'cameras-photo'),(52,45,0,15,'Holiday Supplies & Gifts'),(53,52,0,15,'PRODUCTS'),(54,119,0,15,'holiday-supplies-gifts'),(55,120,0,15,'holiday-supplies-gifts'),(56,45,0,16,'Apparel'),(57,52,0,16,'PRODUCTS'),(58,119,0,16,'apparel'),(59,120,0,16,'apparel'),(60,45,0,17,'Video Games'),(61,52,0,17,'PRODUCTS'),(62,119,0,17,'video-games'),(63,120,0,17,'video-games'),(64,45,0,18,'Televisions'),(65,52,0,18,'PRODUCTS'),(66,119,0,18,'televisions'),(67,120,0,18,'electronics/televisions'),(68,120,1,18,'electronics/electronics-accessories'),(69,120,2,18,'electronics/electronics-accessories'),(70,120,3,18,'electronics/electronics-accessories'),(71,45,0,19,'Small Appliances'),(72,52,0,19,'PRODUCTS'),(73,119,0,19,'small-appliances'),(74,120,0,19,'electronics/small-appliances'),(75,45,0,20,'Top Brands'),(76,52,0,20,'PRODUCTS'),(77,119,0,20,'top-brands'),(78,120,0,20,'electronics/top-brands'),(79,45,0,21,'Cameras & Accessories'),(80,52,0,21,'PRODUCTS'),(81,119,0,21,'cameras-accessories'),(82,120,0,21,'electronics/cameras-accessories'),(84,48,0,18,NULL),(85,49,0,18,NULL),(86,60,0,18,NULL),(87,63,0,18,NULL),(89,48,0,19,NULL),(90,49,0,19,NULL),(91,60,0,19,NULL),(92,63,0,19,NULL),(94,48,0,20,NULL),(95,49,0,20,NULL),(96,60,0,20,NULL),(97,63,0,20,NULL),(100,48,0,21,NULL),(101,49,0,21,NULL),(102,60,0,21,NULL),(103,63,0,21,NULL),(104,120,1,21,'electronics/cameras-accessories'),(105,120,2,21,'electronics/cameras-accessories'),(106,120,3,21,'electronics/cameras-accessories'),(108,45,0,22,'Top Selling TVs'),(109,52,0,22,'PRODUCTS'),(110,119,0,22,'top-selling-tvs'),(111,120,0,22,'electronics/televisions/top-selling-tvs'),(112,120,1,22,'electronics/electronics-accessories/top-selling-tvs'),(113,120,2,22,'electronics/electronics-accessories/top-selling-tvs'),(114,120,3,22,'electronics/electronics-accessories/top-selling-tvs'),(115,45,0,23,'Full HD TVs'),(116,52,0,23,'PRODUCTS'),(117,119,0,23,'full-hd-tvs'),(118,120,0,23,'electronics/televisions/full-hd-tvs'),(119,120,1,23,'electronics/electronics-accessories/full-hd-tvs'),(120,120,2,23,'electronics/electronics-accessories/full-hd-tvs'),(121,120,3,23,'electronics/electronics-accessories/full-hd-tvs'),(122,45,0,24,'Smart TVs'),(123,52,0,24,'PRODUCTS'),(124,119,0,24,'smart-tvs'),(125,120,0,24,'electronics/televisions/smart-tvs'),(126,120,1,24,'electronics/electronics-accessories/smart-tvs'),(127,120,2,24,'electronics/electronics-accessories/smart-tvs'),(128,120,3,24,'electronics/electronics-accessories/smart-tvs'),(129,45,0,25,'Ultra HD TVs'),(130,52,0,25,'PRODUCTS'),(131,119,0,25,'ultra-hd-tvs'),(132,120,0,25,'electronics/televisions/ultra-hd-tvs'),(133,120,1,25,'electronics/electronics-accessories/ultra-hd-tvs'),(134,120,2,25,'electronics/electronics-accessories/ultra-hd-tvs'),(135,120,3,25,'electronics/electronics-accessories/ultra-hd-tvs'),(136,45,0,26,'DTH Services'),(137,52,0,26,'PRODUCTS'),(138,119,0,26,'dth-services'),(139,120,0,26,'electronics/televisions/dth-services'),(140,120,1,26,'electronics/electronics-accessories/dth-services'),(141,120,2,26,'electronics/electronics-accessories/dth-services'),(142,120,3,26,'electronics/electronics-accessories/dth-services'),(143,45,0,27,'Microwaves & OTG'),(144,52,0,27,'PRODUCTS'),(145,119,0,27,'microwaves-otg'),(146,120,0,27,'electronics/small-appliances/microwaves-otg'),(147,45,0,28,'Air Purifiers'),(148,52,0,28,'PRODUCTS'),(149,119,0,28,'air-purifiers'),(150,120,0,28,'electronics/small-appliances/air-purifiers'),(151,45,0,29,'Vacuum Cleaners'),(152,52,0,29,'PRODUCTS'),(153,119,0,29,'vacuum-cleaners'),(154,120,0,29,'electronics/small-appliances/vacuum-cleaners'),(155,45,0,30,'Irons'),(156,52,0,30,'PRODUCTS'),(157,119,0,30,'irons'),(158,120,0,30,'electronics/small-appliances/irons'),(159,45,0,31,'Landline Phones'),(160,52,0,31,'PRODUCTS'),(161,119,0,31,'landline-phones'),(162,120,0,31,'electronics/small-appliances/landline-phones'),(163,45,0,32,'Home Security Systems'),(164,52,0,32,'PRODUCTS'),(165,119,0,32,'home-security-systems'),(166,120,0,32,'electronics/small-appliances/home-security-systems'),(167,45,0,33,'Sewing Machines'),(168,52,0,33,'PRODUCTS'),(169,119,0,33,'sewing-machines'),(170,120,0,33,'electronics/small-appliances/sewing-machines'),(171,45,0,34,'DSLRs'),(172,52,0,34,'PRODUCTS'),(173,119,0,34,'dslrs'),(174,120,0,34,'electronics/cameras-accessories/dslrs'),(175,120,1,34,'electronics/cameras-accessories/dslrs'),(176,120,2,34,'electronics/cameras-accessories/dslrs'),(177,120,3,34,'electronics/cameras-accessories/dslrs'),(178,45,0,35,'Camera Lenses'),(179,52,0,35,'PRODUCTS'),(180,119,0,35,'camera-lenses'),(181,120,0,35,'electronics/cameras-accessories/camera-lenses'),(182,120,1,35,'electronics/cameras-accessories/camera-lenses'),(183,120,2,35,'electronics/cameras-accessories/camera-lenses'),(184,120,3,35,'electronics/cameras-accessories/camera-lenses'),(185,45,0,36,'Action Cameras'),(186,52,0,36,'PRODUCTS'),(187,119,0,36,'action-cameras'),(188,120,0,36,'electronics/cameras-accessories/action-cameras'),(189,120,1,36,'electronics/cameras-accessories/action-cameras'),(190,120,2,36,'electronics/cameras-accessories/action-cameras'),(191,120,3,36,'electronics/cameras-accessories/action-cameras'),(192,45,0,37,'Binoculars and Telescopes'),(193,52,0,37,'PRODUCTS'),(194,119,0,37,'binoculars-and-telescopes'),(195,120,0,37,'electronics/cameras-accessories/binoculars-and-telescopes'),(196,120,1,37,'electronics/cameras-accessories/binoculars-and-telescopes'),(197,120,2,37,'electronics/cameras-accessories/binoculars-and-telescopes'),(198,120,3,37,'electronics/cameras-accessories/binoculars-and-telescopes'),(199,45,0,38,'Digital Cameras'),(200,52,0,38,'PRODUCTS'),(201,119,0,38,'digital-cameras'),(202,120,0,38,'electronics/cameras-accessories/digital-cameras'),(203,120,1,38,'electronics/cameras-accessories/digital-cameras'),(204,120,2,38,'electronics/cameras-accessories/digital-cameras'),(205,120,3,38,'electronics/cameras-accessories/digital-cameras'),(206,45,0,39,'Filters for MPTV'),(207,52,0,39,'PRODUCTS'),(208,119,0,39,'filters-for-mptv'),(209,120,0,39,'electronics/cameras-accessories/filters-for-mptv'),(210,120,1,39,'electronics/cameras-accessories/filters-for-mptv'),(211,120,2,39,'electronics/cameras-accessories/filters-for-mptv'),(212,120,3,39,'electronics/cameras-accessories/filters-for-mptv'),(213,45,0,40,'Consumables'),(214,52,0,40,'PRODUCTS'),(215,119,0,40,'consumables'),(216,120,0,40,'electronics/cameras-accessories/consumables'),(217,120,1,40,'electronics/cameras-accessories/consumables'),(218,120,2,40,'electronics/cameras-accessories/consumables'),(219,120,3,40,'electronics/cameras-accessories/consumables'),(220,45,0,41,'Phantom Cameras'),(221,52,0,41,'PRODUCTS'),(222,119,0,41,'phantom-cameras'),(223,120,0,41,'electronics/cameras-accessories/phantom-cameras'),(224,120,1,41,'electronics/cameras-accessories/phantom-cameras'),(225,120,2,41,'electronics/cameras-accessories/phantom-cameras'),(226,120,3,41,'electronics/cameras-accessories/phantom-cameras'),(227,45,0,42,'Air Conditioning'),(228,52,0,42,'PRODUCTS'),(229,119,0,42,'air-conditioning'),(230,120,0,42,'electronics/small-appliances/air-conditioning'),(231,45,0,43,'Panasonic'),(232,52,0,43,'PRODUCTS'),(233,119,0,43,'panasonic'),(234,120,0,43,'electronics/top-brands/panasonic'),(235,45,0,44,'Micromax'),(236,52,0,44,'PRODUCTS'),(237,119,0,44,'micromax'),(238,120,0,44,'electronics/top-brands/micromax'),(239,45,0,45,'Intex'),(240,52,0,45,'PRODUCTS'),(241,119,0,45,'intex'),(242,120,0,45,'electronics/top-brands/intex'),(243,45,0,46,'Samsung'),(244,52,0,46,'PRODUCTS'),(245,119,0,46,'samsung'),(246,120,0,46,'electronics/top-brands/samsung'),(247,45,0,47,'Karbonn'),(248,52,0,47,'PRODUCTS'),(249,119,0,47,'karbonn'),(250,120,0,47,'electronics/top-brands/karbonn'),(251,45,0,48,'Motorcycle'),(252,52,0,48,'PRODUCTS'),(253,119,0,48,'motorcycle'),(254,120,0,48,'automotive-motorcycle/motorcycle'),(255,45,0,49,'Car Lights'),(256,52,0,49,'PRODUCTS'),(257,119,0,49,'car-lights'),(258,120,0,49,'automotive-motorcycle/car-lights'),(259,45,0,50,'Car Accessories'),(260,52,0,50,'PRODUCTS'),(261,119,0,50,'car-accessories'),(262,120,0,50,'automotive-motorcycle/car-accessories'),(263,45,0,51,'Motorcycle Gadgets'),(264,52,0,51,'PRODUCTS'),(265,119,0,51,'motorcycle-gadgets'),(266,120,0,51,'automotive-motorcycle/motorcycle-gadgets'),(267,45,0,52,'Diagnostic Tools'),(268,52,0,52,'PRODUCTS'),(269,119,0,52,'diagnostic-tools'),(270,120,0,52,'automotive-motorcycle/motorcycle/diagnostic-tools'),(271,45,0,53,'Motorcycle Fairings'),(272,52,0,53,'PRODUCTS'),(273,119,0,53,'motorcycle-fairings'),(274,120,0,53,'automotive-motorcycle/motorcycle/motorcycle-fairings'),(275,45,0,54,'Car GPS & Accessories'),(276,52,0,54,'PRODUCTS'),(277,119,0,54,'car-gps-accessories'),(278,120,0,54,'automotive-motorcycle/motorcycle/car-gps-accessories'),(279,45,0,55,'Car DVRs'),(280,52,0,55,'PRODUCTS'),(281,119,0,55,'car-dvrs'),(282,120,0,55,'automotive-motorcycle/motorcycle/car-dvrs'),(283,45,0,56,'Car Electronics'),(284,52,0,56,'PRODUCTS'),(285,119,0,56,'car-electronics'),(286,120,0,56,'automotive-motorcycle/motorcycle/car-electronics'),(287,45,0,57,'Car Decals & Stickers'),(288,52,0,57,'PRODUCTS'),(289,119,0,57,'car-decals-stickers'),(290,120,0,57,'automotive-motorcycle/motorcycle/car-decals-stickers'),(291,45,0,58,'Car Lighting'),(292,52,0,58,'PRODUCTS'),(293,119,0,58,'car-lighting'),(294,120,0,58,'automotive-motorcycle/motorcycle/car-lighting'),(295,45,0,59,'Car Parts & Exterior Accessories'),(296,52,0,59,'PRODUCTS'),(297,119,0,59,'car-parts-exterior-accessories'),(298,120,0,59,'automotive-motorcycle/motorcycle/car-parts-exterior-accessories'),(299,45,0,60,'Motorcycle Helmets'),(300,52,0,60,'PRODUCTS'),(301,119,0,60,'motorcycle-helmets'),(302,120,0,60,'automotive-motorcycle/motorcycle/motorcycle-helmets'),(303,45,0,61,'Motorcyle Lighting'),(304,52,0,61,'PRODUCTS'),(305,119,0,61,'motorcyle-lighting'),(306,120,0,61,'automotive-motorcycle/motorcycle/motorcyle-lighting'),(307,45,0,62,'Motorcycle Accessories'),(308,52,0,62,'PRODUCTS'),(309,119,0,62,'motorcycle-accessories'),(310,120,0,62,'automotive-motorcycle/motorcycle/motorcycle-accessories'),(311,45,0,63,'Car Interior Accessories'),(312,52,0,63,'PRODUCTS'),(313,119,0,63,'car-interior-accessories'),(314,120,0,63,'automotive-motorcycle/motorcycle/car-interior-accessories'),(315,45,0,64,'Car LED Light Bulbs'),(316,52,0,64,'PRODUCTS'),(317,119,0,64,'car-led-light-bulbs'),(318,120,0,64,'automotive-motorcycle/car-lights/car-led-light-bulbs'),(319,45,0,65,'HID Xenon Kits'),(320,52,0,65,'PRODUCTS'),(321,119,0,65,'hid-xenon-kits'),(322,120,0,65,'automotive-motorcycle/car-lights/hid-xenon-kits'),(323,45,0,66,'Car Decoration Lights'),(324,52,0,66,'PRODUCTS'),(325,119,0,66,'car-decoration-lights'),(326,120,0,66,'automotive-motorcycle/car-lights/car-decoration-lights'),(327,45,0,67,'Car Fog Lights'),(328,52,0,67,'PRODUCTS'),(329,119,0,67,'car-fog-lights'),(330,120,0,67,'automotive-motorcycle/car-lights/car-fog-lights'),(331,45,0,68,'Car Tail Lights'),(332,52,0,68,'PRODUCTS'),(333,119,0,68,'car-tail-lights'),(334,120,0,68,'automotive-motorcycle/car-lights/car-tail-lights'),(335,45,0,69,'Car Chargers & Adapters'),(336,52,0,69,'PRODUCTS'),(337,119,0,69,'car-chargers-adapters'),(338,120,0,69,'automotive-motorcycle/car-accessories/car-chargers-adapters'),(339,45,0,70,'Car Decorations'),(340,52,0,70,'PRODUCTS'),(341,119,0,70,'car-decorations'),(342,120,0,70,'automotive-motorcycle/car-accessories/car-decorations'),(343,45,0,71,'Car Thermometers'),(344,52,0,71,'PRODUCTS'),(345,119,0,71,'car-thermometers'),(346,120,0,71,'automotive-motorcycle/car-accessories/car-thermometers'),(347,45,0,72,'Motorcycle Gear'),(348,52,0,72,'PRODUCTS'),(349,119,0,72,'motorcycle-gear'),(350,120,0,72,'automotive-motorcycle/motorcycle-gadgets/motorcycle-gear'),(351,45,0,73,'Motorcycle Lights'),(352,52,0,73,'PRODUCTS'),(353,119,0,73,'motorcycle-lights'),(354,120,0,73,'automotive-motorcycle/motorcycle-gadgets/motorcycle-lights'),(355,45,0,74,'Motorcycle Decorations'),(356,52,0,74,'PRODUCTS'),(357,119,0,74,'motorcycle-decorations'),(358,120,0,74,'automotive-motorcycle/motorcycle-gadgets/motorcycle-decorations'),(359,45,0,75,'Motorcycle Parts & Accessories'),(360,52,0,75,'PRODUCTS'),(361,119,0,75,'motorcycle-parts-accessories'),(362,120,0,75,'automotive-motorcycle/motorcycle-gadgets/motorcycle-parts-accessories'),(363,45,0,76,'Mirrors'),(364,52,0,76,'PRODUCTS'),(365,119,0,76,'mirrors'),(366,120,0,76,'automotive-motorcycle/motorcycle-gadgets/mirrors'),(367,45,0,77,'Other Gadgets'),(368,52,0,77,'PRODUCTS'),(369,119,0,77,'other-gadgets'),(370,120,0,77,'automotive-motorcycle/motorcycle-gadgets/other-gadgets'),(371,45,0,78,'Sports'),(372,52,0,78,'PRODUCTS'),(373,119,0,78,'sports'),(374,120,0,78,'sports-outdoors/sports'),(375,45,0,79,'Fitness'),(376,52,0,79,'PRODUCTS'),(377,119,0,79,'fitness'),(378,120,0,79,'sports-outdoors/fitness'),(379,45,0,80,'Outdoor Recreation'),(380,52,0,80,'PRODUCTS'),(381,119,0,80,'outdoor-recreation'),(382,120,0,80,'sports-outdoors/outdoor-recreation'),(383,45,0,81,'Team Sports'),(384,52,0,81,'PRODUCTS'),(385,119,0,81,'team-sports'),(386,120,0,81,'sports-outdoors/sports/team-sports'),(387,45,0,82,'Golf'),(388,52,0,82,'PRODUCTS'),(389,119,0,82,'golf'),(390,120,0,82,'sports-outdoors/sports/golf'),(391,45,0,83,'Running'),(392,52,0,83,'PRODUCTS'),(393,119,0,83,'running'),(394,120,0,83,'sports-outdoors/sports/running'),(395,45,0,84,'Swimming'),(396,52,0,84,'PRODUCTS'),(397,119,0,84,'swimming'),(398,120,0,84,'sports-outdoors/sports/swimming'),(399,45,0,85,'Exercise & Fitness'),(400,52,0,85,'PRODUCTS'),(401,119,0,85,'exercise-fitness'),(402,120,0,85,'sports-outdoors/fitness/exercise-fitness'),(403,45,0,86,'Yoga'),(404,52,0,86,'PRODUCTS'),(405,119,0,86,'yoga'),(406,120,0,86,'sports-outdoors/fitness/yoga'),(407,45,0,87,'Sports Medicine'),(408,52,0,87,'PRODUCTS'),(409,119,0,87,'sports-medicine'),(410,120,0,87,'sports-outdoors/fitness/sports-medicine'),(411,45,0,88,'Bodyweight'),(412,52,0,88,'PRODUCTS'),(413,119,0,88,'bodyweight'),(414,120,0,88,'sports-outdoors/fitness/bodyweight'),(415,45,0,89,'Line Dancing'),(416,52,0,89,'PRODUCTS'),(417,119,0,89,'line-dancing'),(418,120,0,89,'sports-outdoors/fitness/line-dancing'),(419,45,0,90,'Outdoor Clothing'),(420,52,0,90,'PRODUCTS'),(421,119,0,90,'outdoor-clothing'),(422,120,0,90,'sports-outdoors/outdoor-recreation/outdoor-clothing'),(423,45,0,91,'Camping & Hiking'),(424,52,0,91,'PRODUCTS'),(425,119,0,91,'camping-hiking'),(426,120,0,91,'sports-outdoors/outdoor-recreation/camping-hiking'),(427,45,0,92,'Climbing'),(428,52,0,92,'PRODUCTS'),(429,119,0,92,'climbing'),(430,120,0,92,'sports-outdoors/outdoor-recreation/climbing'),(431,45,0,93,'Cycling'),(432,52,0,93,'PRODUCTS'),(433,119,0,93,'cycling'),(434,120,0,93,'sports-outdoors/outdoor-recreation/cycling'),(435,45,0,94,'Skateboards & Scooters'),(436,52,0,94,'PRODUCTS'),(437,119,0,94,'skateboards-scooters'),(438,120,0,94,'sports-outdoors/outdoor-recreation/skateboards-scooters'),(439,45,0,95,'Water Sports'),(440,52,0,95,'PRODUCTS'),(441,119,0,95,'water-sports'),(442,120,0,95,'sports-outdoors/outdoor-recreation/water-sports'),(443,45,0,96,'Winter Sports'),(444,52,0,96,'PRODUCTS'),(445,119,0,96,'winter-sports'),(446,120,0,96,'sports-outdoors/outdoor-recreation/winter-sports'),(447,45,0,97,'Performance Training'),(448,52,0,97,'PRODUCTS'),(449,119,0,97,'performance'),(450,120,0,97,'sports-outdoors/outdoor-recreation/performance'),(452,48,0,97,NULL),(453,49,0,97,NULL),(454,60,0,97,NULL),(455,63,0,97,NULL),(456,120,1,97,'sports-outdoors/outdoor-recreation/performance'),(457,120,2,97,'sports-outdoors/outdoor-recreation/performance'),(458,120,3,97,'sports-outdoors/outdoor-recreation/performance'),(459,45,0,98,'Accessories'),(460,52,0,98,'PRODUCTS'),(461,119,0,98,'accessories'),(462,120,0,98,'sports-outdoors/outdoor-recreation/accessories'),(463,45,0,99,'Mobile Cases & Covers'),(464,52,0,99,'PRODUCTS'),(465,119,0,99,'mobile-cases-covers'),(466,120,0,99,'smartphones-tablets/mobile-cases-covers'),(467,45,0,100,'Mobile Accessories'),(468,52,0,100,'PRODUCTS'),(469,119,0,100,'mobile-accessories'),(470,120,0,100,'smartphones-tablets/mobile-accessories'),(471,45,0,101,'Tablets'),(472,52,0,101,'PRODUCTS'),(473,119,0,101,'tablets'),(474,120,0,101,'smartphones-tablets/tablets'),(475,45,0,102,'Popular Smartphones'),(476,52,0,102,'PRODUCTS'),(477,119,0,102,'popular-smartphones'),(478,120,0,102,'smartphones-tablets/popular-smartphones'),(479,45,0,103,'New Launches Covers'),(480,52,0,103,'PRODUCTS'),(481,119,0,103,'new-launches-covers'),(482,120,0,103,'smartphones-tablets/mobile-cases-covers/new-launches-covers'),(483,45,0,104,'Printed Back Covers'),(484,52,0,104,'PRODUCTS'),(485,119,0,104,'printed-back-covers'),(486,120,0,104,'smartphones-tablets/mobile-cases-covers/printed-back-covers'),(487,45,0,105,'Plain Back Covers'),(488,52,0,105,'PRODUCTS'),(489,119,0,105,'plain-back-covers'),(490,120,0,105,'smartphones-tablets/mobile-cases-covers/plain-back-covers'),(491,45,0,106,'Flip Covers'),(492,52,0,106,'PRODUCTS'),(493,119,0,106,'flip-covers'),(494,120,0,106,'smartphones-tablets/mobile-cases-covers/flip-covers'),(495,45,0,107,'Premium Covers'),(496,52,0,107,'PRODUCTS'),(497,119,0,107,'premium-covers'),(498,120,0,107,'smartphones-tablets/mobile-cases-covers/premium-covers'),(499,45,0,108,'Batteries'),(500,52,0,108,'PRODUCTS'),(501,119,0,108,'batteries'),(502,120,0,108,'smartphones-tablets/mobile-accessories/batteries'),(503,45,0,109,'Screen Guards'),(504,52,0,109,'PRODUCTS'),(505,119,0,109,'screen-guards'),(506,120,0,109,'smartphones-tablets/mobile-accessories/screen-guards'),(507,45,0,110,'Cables & Chargers'),(508,52,0,110,'PRODUCTS'),(509,119,0,110,'cables-chargers'),(510,120,0,110,'smartphones-tablets/mobile-accessories/cables-chargers'),(511,45,0,111,'Smartwatch Accessories'),(512,52,0,111,'PRODUCTS'),(513,119,0,111,'smartwatch-accessories'),(514,120,0,111,'smartphones-tablets/mobile-accessories/smartwatch-accessories'),(515,45,0,112,'Selfie Sticks'),(516,52,0,112,'PRODUCTS'),(517,119,0,112,'selfie-sticks'),(518,120,0,112,'smartphones-tablets/mobile-accessories/selfie-sticks'),(519,45,0,113,'Bluetooth Devices'),(520,52,0,113,'PRODUCTS'),(521,119,0,113,'bluetooth-devices'),(522,120,0,113,'smartphones-tablets/mobile-accessories/bluetooth-devices'),(523,45,0,114,'Mobile Holders'),(524,52,0,114,'PRODUCTS'),(525,119,0,114,'mobile-holders'),(526,120,0,114,'smartphones-tablets/mobile-accessories/mobile-holders'),(527,45,0,115,'Mobile Enhancements'),(528,52,0,115,'PRODUCTS'),(529,119,0,115,'mobile-enhancements'),(530,120,0,115,'smartphones-tablets/mobile-accessories/mobile-enhancements'),(531,45,0,116,'Tablet Accessories'),(532,52,0,116,'PRODUCTS'),(533,119,0,116,'tablet-accessories'),(534,120,0,116,'smartphones-tablets/tablets/tablet-accessories'),(535,45,0,117,'Tablet Covers'),(536,52,0,117,'PRODUCTS'),(537,119,0,117,'tablet-covers'),(538,120,0,117,'smartphones-tablets/tablets/tablet-covers'),(539,45,0,118,'Tablet Keyboards'),(540,52,0,118,'PRODUCTS'),(541,119,0,118,'tablet-keyboards'),(542,120,0,118,'smartphones-tablets/tablets/tablet-keyboards'),(543,45,0,119,'Stylus Pen'),(544,52,0,119,'PRODUCTS'),(545,119,0,119,'stylus-pen'),(546,120,0,119,'smartphones-tablets/tablets/stylus-pen'),(547,45,0,120,'Anti Radiation Chips'),(548,52,0,120,'PRODUCTS'),(549,119,0,120,'anti-radiation-chips'),(550,120,0,120,'smartphones-tablets/tablets/anti-radiation-chips'),(551,45,0,121,'Redmi Note 5 Pro'),(552,52,0,121,'PRODUCTS'),(553,119,0,121,'redmi-note-5-pro'),(554,120,0,121,'smartphones-tablets/popular-smartphones/redmi-note-5-pro'),(555,45,0,122,'Samsung Galaxy J6+'),(556,52,0,122,'PRODUCTS'),(557,119,0,122,'samsung-galaxy-j6'),(558,120,0,122,'smartphones-tablets/popular-smartphones/samsung-galaxy-j6'),(559,45,0,123,'Vivo V11 Pro'),(560,52,0,123,'PRODUCTS'),(561,119,0,123,'vivo-v11-pro'),(562,120,0,123,'smartphones-tablets/popular-smartphones/vivo-v11-pro'),(563,45,0,124,'Oppo F9 Pro'),(564,52,0,124,'PRODUCTS'),(565,119,0,124,'oppo-f9-pro'),(566,120,0,124,'smartphones-tablets/popular-smartphones/oppo-f9-pro'),(567,45,0,125,'Honor 9 Lite'),(568,52,0,125,'PRODUCTS'),(569,119,0,125,'honor-9-lite'),(570,120,0,125,'smartphones-tablets/popular-smartphones/honor-9-lite'),(571,45,0,126,'Vivo Y83 Pro'),(572,52,0,126,'PRODUCTS'),(573,119,0,126,'vivo-y83-pro'),(574,120,0,126,'smartphones-tablets/popular-smartphones/vivo-y83-pro'),(575,45,0,127,'Lenovo K8 Plus'),(576,52,0,127,'PRODUCTS'),(577,119,0,127,'lenovo-k8-plus'),(578,120,0,127,'smartphones-tablets/popular-smartphones/lenovo-k8-plus'),(579,120,1,127,'smartphones-tablets/popular-smartphones/lenovo-k8-plus'),(580,120,2,127,'smartphones-tablets/popular-smartphones/lenovo-k8-plus'),(581,120,3,127,'smartphones-tablets/popular-smartphones/lenovo-k8-plus'),(582,45,0,128,'Samsung Galaxy J2'),(583,52,0,128,'PRODUCTS'),(584,119,0,128,'samsung-galaxy-j2'),(585,120,0,128,'smartphones-tablets/popular-smartphones/samsung-galaxy-j2'),(586,120,1,128,'smartphones-tablets/popular-smartphones/samsung-galaxy-j2'),(587,120,2,128,'smartphones-tablets/popular-smartphones/samsung-galaxy-j2'),(588,120,3,128,'smartphones-tablets/popular-smartphones/samsung-galaxy-j2'),(590,48,0,9,'/media/catalog/category/cat-1.png'),(591,49,0,9,NULL),(592,60,0,9,NULL),(593,63,0,9,NULL),(595,48,0,3,'/media/catalog/category/cat-2.png'),(596,49,0,3,NULL),(597,60,0,3,NULL),(598,63,0,3,NULL),(600,48,0,5,'/media/catalog/category/cat-3.png'),(601,49,0,5,NULL),(602,60,0,5,NULL),(603,63,0,5,NULL),(605,48,0,15,'/media/catalog/category/cat-4.png'),(606,49,0,15,NULL),(607,60,0,15,NULL),(608,63,0,15,NULL),(610,48,0,11,'/media/catalog/category/cat-5.png'),(611,49,0,11,NULL),(612,60,0,11,NULL),(613,63,0,11,NULL),(615,48,0,4,'/media/catalog/category/cat-6.png'),(616,49,0,4,NULL),(617,60,0,4,NULL),(618,63,0,4,NULL),(620,48,0,7,'/media/catalog/category/cat-7.png'),(621,49,0,7,NULL),(622,60,0,7,NULL),(623,63,0,7,NULL),(625,48,0,6,'/media/catalog/category/cat-8.png'),(626,49,0,6,NULL),(627,60,0,6,NULL),(628,63,0,6,NULL),(634,45,0,129,'Bath & Body'),(635,52,0,129,'PRODUCTS'),(636,119,0,129,'bath-body'),(637,120,0,129,'health-beauty/bath-body'),(638,45,0,130,'Shaving & Hair Removal'),(639,52,0,130,'PRODUCTS'),(640,119,0,130,'shaving-hair-removal'),(641,120,0,130,'health-beauty/shaving-hair-removal'),(642,45,0,131,'Fragrances'),(643,52,0,131,'PRODUCTS'),(644,119,0,131,'fragrances'),(645,120,0,131,'health-beauty/fragrances'),(646,45,0,132,'Salon & Spa Equipment'),(647,52,0,132,'PRODUCTS'),(648,119,0,132,'salon-spa-equipment'),(649,120,0,132,'health-beauty/salon-spa-equipment'),(650,45,0,133,'Gift & Lifestyle Gadgets'),(651,52,0,133,'PRODUCTS'),(652,119,0,133,'gift-lifestyle-gadgets'),(653,120,0,133,'holiday-supplies-gifts/gift-lifestyle-gadgets'),(654,45,0,134,'Gift for Man'),(655,52,0,134,'PRODUCTS'),(656,119,0,134,'gift-for-man'),(657,120,0,134,'holiday-supplies-gifts/gift-for-man'),(658,45,0,135,'Gift for Woman'),(659,52,0,135,'PRODUCTS'),(660,119,0,135,'gift-for-woman'),(661,120,0,135,'holiday-supplies-gifts/gift-for-woman'),(662,45,0,136,'Lighter & Cigar Supplies'),(663,52,0,136,'PRODUCTS'),(664,119,0,136,'lighter-cigar-supplies'),(665,120,0,136,'holiday-supplies-gifts/lighter-cigar-supplies'),(666,45,0,137,'Men Watches'),(667,52,0,137,'PRODUCTS'),(668,119,0,137,'men-watches'),(669,120,0,137,'jewelry-watches/men-watches'),(670,45,0,138,'Wedding Rings'),(671,52,0,138,'PRODUCTS'),(672,119,0,138,'wedding-rings'),(673,120,0,138,'jewelry-watches/wedding-rings'),(674,45,0,139,'Earrings'),(675,52,0,139,'PRODUCTS'),(676,119,0,139,'earrings'),(677,120,0,139,'jewelry-watches/earrings'),(678,45,0,140,'Necklaces'),(679,52,0,140,'PRODUCTS'),(680,119,0,140,'necklaces'),(681,120,0,140,'jewelry-watches/necklaces'),(682,45,0,141,'Arts & Crafts'),(683,52,0,141,'PRODUCTS'),(684,119,0,141,'arts-crafts'),(685,120,0,141,'toys-hobbies/arts-crafts'),(686,45,0,142,'Grown-Up Toys'),(687,52,0,142,'PRODUCTS'),(688,119,0,142,'grown-up-toys'),(689,120,0,142,'toys-hobbies/grown-up-toys'),(690,45,0,143,'Puppets'),(691,52,0,143,'PRODUCTS'),(692,119,0,143,'puppets'),(693,120,0,143,'toys-hobbies/puppets'),(694,45,0,144,'Baby & Toddler Toys'),(695,52,0,144,'PRODUCTS'),(696,119,0,144,'baby-toddler-toys'),(697,120,0,144,'toys-hobbies/baby-toddler-toys'),(703,45,2,43,'Panasonic'),(704,45,0,145,'Features'),(705,52,0,145,'PRODUCTS'),(706,119,0,145,'features'),(707,120,0,145,'features'),(709,48,0,145,NULL),(710,49,0,145,NULL),(711,60,0,145,NULL),(712,63,0,145,NULL),(717,48,0,13,NULL),(718,49,0,13,NULL),(719,60,0,13,NULL),(720,63,0,13,NULL),(729,120,1,47,'electronics/top-brands/karbonn'),(730,120,2,47,'electronics/top-brands/karbonn'),(731,120,3,47,'electronics/top-brands/karbonn'),(732,120,4,47,'electronics/top-brands/karbonn'),(733,120,5,47,'electronics/top-brands/karbonn'),(734,120,6,47,'electronics/top-brands/karbonn'),(735,120,7,47,'electronics/top-brands/karbonn'),(736,120,8,47,'electronics/top-brands/karbonn'),(737,120,9,47,'electronics/top-brands/karbonn'),(738,120,10,47,'electronics/top-brands/karbonn'),(739,120,11,47,'electronics/top-brands/karbonn'),(740,120,12,47,'electronics/top-brands/karbonn'),(741,120,13,47,'electronics/top-brands/karbonn'),(742,120,14,47,'electronics/top-brands/karbonn'),(743,120,15,47,'electronics/top-brands/karbonn'),(744,120,16,47,'electronics/top-brands/karbonn'),(745,120,17,47,'electronics/top-brands/karbonn'),(763,120,1,46,'electronics/top-brands/samsung'),(764,120,2,46,'electronics/top-brands/samsung'),(765,120,3,46,'electronics/top-brands/samsung'),(766,120,4,46,'electronics/top-brands/samsung'),(767,120,5,46,'electronics/top-brands/samsung'),(768,120,6,46,'electronics/top-brands/samsung'),(769,120,7,46,'electronics/top-brands/samsung'),(770,120,8,46,'electronics/top-brands/samsung'),(771,120,9,46,'electronics/top-brands/samsung'),(772,120,10,46,'electronics/top-brands/samsung'),(773,120,11,46,'electronics/top-brands/samsung'),(774,120,12,46,'electronics/top-brands/samsung'),(775,120,13,46,'electronics/top-brands/samsung'),(776,120,14,46,'electronics/top-brands/samsung'),(777,120,15,46,'electronics/top-brands/samsung'),(778,120,16,46,'electronics/top-brands/samsung'),(779,120,17,46,'electronics/top-brands/samsung'),(780,120,1,45,'electronics/top-brands/intex'),(781,120,2,45,'electronics/top-brands/intex'),(782,120,3,45,'electronics/top-brands/intex'),(783,120,4,45,'electronics/top-brands/intex'),(784,120,5,45,'electronics/top-brands/intex'),(785,120,6,45,'electronics/top-brands/intex'),(786,120,7,45,'electronics/top-brands/intex'),(787,120,8,45,'electronics/top-brands/intex'),(788,120,9,45,'electronics/top-brands/intex'),(789,120,10,45,'electronics/top-brands/intex'),(790,120,11,45,'electronics/top-brands/intex'),(791,120,12,45,'electronics/top-brands/intex'),(792,120,13,45,'electronics/top-brands/intex'),(793,120,14,45,'electronics/top-brands/intex'),(794,120,15,45,'electronics/top-brands/intex'),(795,120,16,45,'electronics/top-brands/intex'),(796,120,17,45,'electronics/top-brands/intex'),(797,120,1,44,'electronics/top-brands/micromax'),(798,120,2,44,'electronics/top-brands/micromax'),(799,120,3,44,'electronics/top-brands/micromax'),(800,120,4,44,'electronics/top-brands/micromax'),(801,120,5,44,'electronics/top-brands/micromax'),(802,120,6,44,'electronics/top-brands/micromax'),(803,120,7,44,'electronics/top-brands/micromax'),(804,120,8,44,'electronics/top-brands/micromax'),(805,120,9,44,'electronics/top-brands/micromax'),(806,120,10,44,'electronics/top-brands/micromax'),(807,120,11,44,'electronics/top-brands/micromax'),(808,120,12,44,'electronics/top-brands/micromax'),(809,120,13,44,'electronics/top-brands/micromax'),(810,120,14,44,'electronics/top-brands/micromax'),(811,120,15,44,'electronics/top-brands/micromax'),(812,120,16,44,'electronics/top-brands/micromax'),(813,120,17,44,'electronics/top-brands/micromax'),(814,120,1,43,'electronics/top-brands/panasonic'),(815,120,2,43,'electronics/top-brands/panasonic'),(816,120,3,43,'electronics/top-brands/panasonic'),(817,120,4,43,'electronics/top-brands/panasonic'),(818,120,5,43,'electronics/top-brands/panasonic'),(819,120,6,43,'electronics/top-brands/panasonic'),(820,120,7,43,'electronics/top-brands/panasonic'),(821,120,8,43,'electronics/top-brands/panasonic'),(822,120,9,43,'electronics/top-brands/panasonic'),(823,120,10,43,'electronics/top-brands/panasonic'),(824,120,11,43,'electronics/top-brands/panasonic'),(825,120,12,43,'electronics/top-brands/panasonic'),(826,120,13,43,'electronics/top-brands/panasonic'),(827,120,14,43,'electronics/top-brands/panasonic'),(828,120,15,43,'electronics/top-brands/panasonic'),(829,120,16,43,'electronics/top-brands/panasonic'),(830,120,17,43,'electronics/top-brands/panasonic'),(916,45,0,147,'Men\'s Clothing'),(917,52,0,147,'PRODUCTS'),(918,119,0,147,'men-s-clothing'),(919,120,0,147,'apparel/men-s-clothing'),(920,45,0,148,'Women\'s wear'),(921,52,0,148,'PRODUCTS'),(922,119,0,148,'women-s-wear'),(923,120,0,148,'apparel/women-s-wear'),(924,45,0,149,'Accessories'),(925,52,0,149,'PRODUCTS'),(926,119,0,149,'accessories'),(927,120,0,149,'apparel/accessories'),(929,48,0,147,'/magento2/sm-marketnew242/pub/media/wysiwyg/category/cat-12.jpg'),(930,49,0,147,NULL),(931,60,0,147,NULL),(932,63,0,147,NULL),(934,48,0,148,'/magento2/sm-marketnew242/pub/media/wysiwyg/category/cat-13.jpg'),(935,49,0,148,NULL),(936,60,0,148,NULL),(937,63,0,148,NULL),(939,48,0,149,'/magento2/sm-marketnew242/pub/media/wysiwyg/category/cat-14.jpg'),(940,49,0,149,NULL),(941,60,0,149,NULL),(942,63,0,149,NULL),(943,45,0,150,'Product Types'),(944,52,0,150,'PRODUCTS'),(945,119,0,150,'product-types'),(946,120,0,150,'product-types'),(947,45,0,151,'Bathroom'),(948,52,0,151,'PRODUCTS'),(949,119,0,151,'bathroom'),(950,120,0,151,'furniture/bathroom'),(951,45,0,152,'Mirror'),(952,52,0,152,'PRODUCTS'),(953,119,0,152,'mirror'),(954,120,0,152,'furniture/mirror'),(955,45,0,153,'Sofa'),(956,52,0,153,'PRODUCTS'),(957,119,0,153,'sofa'),(958,120,0,153,'furniture/sofa'),(959,45,0,154,'Shelves'),(960,52,0,154,'PRODUCTS'),(961,119,0,154,'shelves'),(962,120,0,154,'furniture/shelves'),(963,45,0,155,'Chest'),(964,52,0,155,'PRODUCTS'),(965,119,0,155,'chest'),(966,120,0,155,'furniture/chest'),(967,45,0,156,'Chair'),(968,52,0,156,'PRODUCTS'),(969,119,0,156,'chair'),(970,120,0,156,'furniture/chair'),(971,45,0,157,'Bedroom'),(972,52,0,157,'PRODUCTS'),(973,119,0,157,'bedroom'),(974,120,0,157,'furniture/bedroom'),(975,45,0,158,'Wardrobe'),(976,52,0,158,'PRODUCTS'),(977,119,0,158,'wardrobe'),(978,120,0,158,'furniture/wardrobe'),(979,45,0,159,'Garden'),(980,52,0,159,'PRODUCTS'),(981,119,0,159,'garden'),(982,120,0,159,'furniture/garden'),(984,48,0,151,'/magento2/sm-marketnew242/pub/media/wysiwyg/category/icon-cat-1.png'),(985,49,0,151,NULL),(986,60,0,151,NULL),(987,63,0,151,NULL),(989,48,0,152,'/magento2/sm-marketnew242/pub/media/wysiwyg/category/icon-cat-2.png'),(990,49,0,152,NULL),(991,60,0,152,NULL),(992,63,0,152,NULL),(994,48,0,153,'/magento2/sm-marketnew242/pub/media/wysiwyg/category/icon-cat-3.png'),(995,49,0,153,NULL),(996,60,0,153,NULL),(997,63,0,153,NULL),(999,48,0,154,'/magento2/sm-marketnew242/pub/media/wysiwyg/category/icon-cat-4.png'),(1000,49,0,154,NULL),(1001,60,0,154,NULL),(1002,63,0,154,NULL),(1004,48,0,155,'/magento2/sm-marketnew242/pub/media/wysiwyg/category/icon-cat-5.png'),(1005,49,0,155,NULL),(1006,60,0,155,NULL),(1007,63,0,155,NULL),(1009,48,0,156,'/magento2/sm-marketnew242/pub/media/wysiwyg/category/icon-cat-6.png'),(1010,49,0,156,NULL),(1011,60,0,156,NULL),(1012,63,0,156,NULL),(1014,48,0,157,'/magento2/sm-marketnew242/pub/media/wysiwyg/category/icon-cat-7.png'),(1015,49,0,157,NULL),(1016,60,0,157,NULL),(1017,63,0,157,NULL),(1019,48,0,158,'/magento2/sm-marketnew242/pub/media/wysiwyg/category/icon-cat-8.png'),(1020,49,0,158,NULL),(1021,60,0,158,NULL),(1022,63,0,158,NULL),(1025,48,0,159,'/magento2/sm-marketnew242/pub/media/wysiwyg/category/icon-cat-9.png'),(1026,49,0,159,NULL),(1027,60,0,159,NULL),(1028,63,0,159,NULL),(1029,45,0,160,'Women'),(1030,52,0,160,'PRODUCTS'),(1031,119,0,160,'women'),(1032,120,0,160,'apparel/women'),(1033,45,0,161,'Men'),(1034,52,0,161,'PRODUCTS'),(1035,119,0,161,'men'),(1036,120,0,161,'apparel/men'),(1037,45,0,162,'Clothing'),(1038,52,0,162,'PRODUCTS'),(1039,119,0,162,'w-clothing'),(1040,120,0,162,'apparel/women/w-clothing'),(1041,45,0,163,'Shoes'),(1042,52,0,163,'PRODUCTS'),(1043,119,0,163,'w-shoes'),(1044,120,0,163,'apparel/women/w-shoes'),(1045,45,0,164,'HandBags'),(1046,52,0,164,'PRODUCTS'),(1047,119,0,164,'w-handbags'),(1048,120,0,164,'apparel/women/w-handbags'),(1049,45,0,165,'Sunglasses'),(1050,52,0,165,'PRODUCTS'),(1051,119,0,165,'w-sunglasses'),(1052,120,0,165,'apparel/women/w-sunglasses'),(1053,45,0,166,'Accessories'),(1054,52,0,166,'PRODUCTS'),(1055,119,0,166,'w-accessories'),(1056,120,0,166,'apparel/women/w-accessories'),(1057,45,0,167,'Clothing'),(1058,52,0,167,'PRODUCTS'),(1059,119,0,167,'m-clothing'),(1060,120,0,167,'apparel/men/m-clothing'),(1061,45,0,168,'Shoes'),(1062,52,0,168,'PRODUCTS'),(1063,119,0,168,'m-shoes'),(1064,120,0,168,'apparel/men/m-shoes'),(1065,45,0,169,'HandBags'),(1066,52,0,169,'PRODUCTS'),(1067,119,0,169,'m-handbags'),(1068,120,0,169,'apparel/men/m-handbags'),(1069,45,0,170,'Sunglasses'),(1070,52,0,170,'PRODUCTS'),(1071,119,0,170,'m-sunglasses'),(1072,120,0,170,'apparel/men/m-sunglasses'),(1073,45,0,171,'Accessories'),(1074,52,0,171,'PRODUCTS'),(1075,119,0,171,'m-accessories'),(1076,120,0,171,'apparel/men/m-accessories'),(1078,48,0,162,'/magento2/sm-marketnew242/pub/media/wysiwyg/category/icon-cat-10.png'),(1079,49,0,162,NULL),(1080,60,0,162,NULL),(1081,63,0,162,NULL),(1083,48,0,163,'/magento2/sm-marketnew242/pub/media/wysiwyg/category/icon-cat-11.png'),(1084,49,0,163,NULL),(1085,60,0,163,NULL),(1086,63,0,163,NULL),(1088,48,0,164,'/magento2/sm-marketnew242/pub/media/wysiwyg/category/icon-cat-12.png'),(1089,49,0,164,NULL),(1090,60,0,164,NULL),(1091,63,0,164,NULL),(1093,48,0,165,'/magento2/sm-marketnew242/pub/media/wysiwyg/category/icon-cat-13.png'),(1094,49,0,165,NULL),(1095,60,0,165,NULL),(1096,63,0,165,NULL),(1098,48,0,166,'/magento2/sm-marketnew242/pub/media/wysiwyg/category/icon-cat-14.png'),(1099,49,0,166,NULL),(1100,60,0,166,NULL),(1101,63,0,166,NULL),(1103,48,0,167,'/magento2/sm-marketnew242/pub/media/wysiwyg/category/icon-cat-10.png'),(1104,49,0,167,NULL),(1105,60,0,167,NULL),(1106,63,0,167,NULL),(1108,48,0,168,'/magento2/sm-marketnew242/pub/media/wysiwyg/category/icon-cat-15.png'),(1109,49,0,168,NULL),(1110,60,0,168,NULL),(1111,63,0,168,NULL),(1113,48,0,169,'/magento2/sm-marketnew242/pub/media/wysiwyg/category/icon-cat-12.png'),(1114,49,0,169,NULL),(1115,60,0,169,NULL),(1116,63,0,169,NULL),(1118,48,0,170,'/magento2/sm-marketnew242/pub/media/wysiwyg/category/icon-cat-13.png'),(1119,49,0,170,NULL),(1120,60,0,170,NULL),(1121,63,0,170,NULL),(1123,48,0,171,'/magento2/sm-marketnew242/pub/media/wysiwyg/category/icon-cat-14.png'),(1124,49,0,171,NULL),(1125,60,0,171,NULL),(1126,63,0,171,NULL),(1127,45,0,172,'Listing Layout'),(1128,52,0,172,'PRODUCTS'),(1129,119,0,172,'listing-layout'),(1130,120,0,172,'listing-layout'),(1131,45,0,173,'Without Sidebar'),(1132,52,0,173,'PRODUCTS'),(1133,63,0,173,'1column'),(1134,119,0,173,'without-sidebar'),(1135,120,0,173,'listing-layout/without-sidebar'),(1136,45,0,174,'Left Sidebar'),(1137,52,0,174,'PRODUCTS'),(1138,63,0,174,'2columns-left'),(1139,119,0,174,'left-sidebar'),(1140,120,0,174,'listing-layout/left-sidebar'),(1141,45,0,175,'Right Sidebar'),(1142,52,0,175,'PRODUCTS'),(1143,63,0,175,'2columns-right'),(1144,119,0,175,'right-sidebar'),(1145,120,0,175,'listing-layout/right-sidebar'),(1146,45,0,176,'Left Right Sidebar'),(1147,52,0,176,'PRODUCTS'),(1148,63,0,176,'3columns'),(1149,119,0,176,'left-right-sidebar'),(1150,120,0,176,'listing-layout/left-right-sidebar'),(1152,48,0,172,NULL),(1153,49,0,172,NULL),(1154,60,0,172,NULL),(1155,63,0,172,NULL),(1157,48,0,173,NULL),(1158,49,0,173,NULL),(1159,60,0,173,NULL),(1161,48,0,174,NULL),(1162,49,0,174,NULL),(1163,60,0,174,NULL),(1165,48,0,175,NULL),(1166,49,0,175,NULL),(1167,60,0,175,NULL),(1169,48,0,176,NULL),(1170,49,0,176,NULL),(1171,60,0,176,NULL),(1172,48,20,162,'/media/catalog/category/cat-20.jpg'),(1173,48,20,163,'/media/catalog/category/cat-23.jpg'),(1174,48,20,164,'/media/catalog/category/cat-22.jpg'),(1175,48,20,165,'/media/catalog/category/cat-21.jpg'),(1176,48,20,166,'/media/catalog/category/cat-25.jpg'),(1177,48,20,137,'/media/catalog/category/cat-24.jpg'),(1178,45,0,177,'Men Women Clothing'),(1179,52,0,177,'PRODUCTS'),(1180,119,0,177,'men-women-clothing'),(1181,120,0,177,'apparel/men-women-clothing'),(1183,48,0,177,NULL),(1184,49,0,177,NULL),(1185,60,0,177,NULL),(1186,63,0,177,NULL),(1187,45,0,178,'Sample Categories'),(1188,52,0,178,'PRODUCTS'),(1189,119,0,178,'sample-categories'),(1190,120,0,178,'sample-categories'),(1192,48,0,178,NULL),(1193,49,0,178,NULL),(1194,60,0,178,NULL),(1195,63,0,178,NULL),(1196,120,1,177,'sample-categories/men-women-clothing'),(1197,120,2,177,'sample-categories/men-women-clothing'),(1198,120,3,177,'sample-categories/men-women-clothing'),(1199,120,4,177,'sample-categories/men-women-clothing'),(1200,120,5,177,'sample-categories/men-women-clothing'),(1201,120,6,177,'sample-categories/men-women-clothing'),(1202,120,7,177,'sample-categories/men-women-clothing'),(1203,120,8,177,'sample-categories/men-women-clothing'),(1204,120,9,177,'sample-categories/men-women-clothing'),(1205,120,10,177,'sample-categories/men-women-clothing'),(1206,120,11,177,'sample-categories/men-women-clothing'),(1207,120,12,177,'sample-categories/men-women-clothing'),(1208,120,13,177,'sample-categories/men-women-clothing'),(1209,120,14,177,'sample-categories/men-women-clothing'),(1210,120,15,177,'sample-categories/men-women-clothing'),(1211,120,16,177,'sample-categories/men-women-clothing'),(1212,120,17,177,'sample-categories/men-women-clothing'),(1213,120,18,177,'sample-categories/men-women-clothing'),(1214,120,19,177,'sample-categories/men-women-clothing'),(1215,120,20,177,'sample-categories/men-women-clothing'),(1216,45,0,179,'Kids'),(1217,52,0,179,'PRODUCTS'),(1218,119,0,179,'kids'),(1219,120,0,179,'sample-categories/kids'),(1220,45,0,180,'Clothings'),(1221,52,0,180,'PRODUCTS'),(1222,119,0,180,'kid-clothings'),(1223,120,0,180,'sample-categories/kids/kid-clothings'),(1224,45,0,181,'Strollers'),(1225,52,0,181,'PRODUCTS'),(1226,119,0,181,'strollers'),(1227,120,0,181,'sample-categories/kids/strollers'),(1228,45,0,182,'Toys'),(1229,52,0,182,'PRODUCTS'),(1230,119,0,182,'toys'),(1231,120,0,182,'sample-categories/kids/toys'),(1232,45,0,183,'Newborns'),(1233,52,0,183,'PRODUCTS'),(1234,119,0,183,'newborns'),(1235,120,0,183,'sample-categories/kids/newborns'),(1236,45,0,184,'Baby Food'),(1237,52,0,184,'PRODUCTS'),(1238,119,0,184,'baby-food'),(1239,120,0,184,'sample-categories/kids/baby-food'),(1241,48,0,180,'/media/catalog/category/kid-1.jpg'),(1242,49,0,180,NULL),(1243,60,0,180,NULL),(1244,63,0,180,NULL),(1248,48,0,181,'/media/catalog/category/kid-2.jpg'),(1249,49,0,181,NULL),(1250,60,0,181,NULL),(1251,63,0,181,NULL),(1253,48,0,182,'/media/catalog/category/kid-3.jpg'),(1254,49,0,182,NULL),(1255,60,0,182,NULL),(1256,63,0,182,NULL),(1258,48,0,183,'/media/catalog/category/kid-4.jpg'),(1259,49,0,183,NULL),(1260,60,0,183,NULL),(1261,63,0,183,NULL),(1263,48,0,184,'/magento2/sm-marketnew242/pub/media/catalog/category/kid-5.jpg'),(1264,49,0,184,NULL),(1265,60,0,184,NULL),(1266,63,0,184,NULL),(1275,48,17,147,'/media/catalog/category/cat-12.jpg'),(1276,48,17,148,'/media/catalog/category/cat-13.jpg'),(1277,48,17,149,'/media/catalog/category/cat-14.jpg'),(1278,48,18,151,'/media/catalog/category/icon-cat-1.png'),(1279,48,18,152,'/media/catalog/category/icon-cat-2.png'),(1280,48,18,153,'/media/catalog/category/icon-cat-3.png'),(1281,48,18,154,'/media/catalog/category/icon-cat-4.png'),(1282,48,18,155,'/media/catalog/category/icon-cat-5.png'),(1283,48,18,156,'/media/catalog/category/icon-cat-6.png'),(1284,48,18,157,'/media/catalog/category/icon-cat-7.png'),(1285,48,18,158,'/media/catalog/category/icon-cat-8.png'),(1286,48,18,159,'/media/catalog/category/icon-cat-9.png'),(1287,48,19,162,'/media/catalog/category/icon-cat-10.png'),(1288,48,19,163,'/media/catalog/category/icon-cat-11.png'),(1289,48,19,164,'/media/catalog/category/icon-cat-12.png'),(1290,48,19,165,'/media/catalog/category/icon-cat-13.png'),(1291,48,19,166,'/media/catalog/category/icon-cat-14.png'),(1292,48,19,167,'/media/catalog/category/icon-cat-10_1.png'),(1293,48,19,168,'/media/catalog/category/icon-cat-15.png'),(1294,48,19,169,'/media/catalog/category/icon-cat-12_1.png'),(1295,48,19,170,'/media/catalog/category/icon-cat-13_1.png'),(1296,48,19,171,'/media/catalog/category/icon-cat-14_1.png'),(1298,48,22,3,'/media/catalog/category/icon-cat-16.png'),(1299,45,0,185,'Stuffed Animals'),(1300,52,0,185,'PRODUCTS'),(1301,119,0,185,'stuffed-animals'),(1302,120,0,185,'sample-categories/kids/stuffed-animals'),(1303,45,0,186,'Teethers'),(1304,52,0,186,'PRODUCTS'),(1305,119,0,186,'teethers'),(1306,120,0,186,'sample-categories/kids/teethers'),(1307,45,0,187,'Gyms & Playmats'),(1308,52,0,187,'PRODUCTS'),(1309,119,0,187,'gyms-playmats'),(1310,120,0,187,'sample-categories/kids/gyms-playmats'),(1311,45,0,188,'Interactive Toys'),(1312,52,0,188,'PRODUCTS'),(1313,119,0,188,'interactive-toys'),(1314,120,0,188,'sample-categories/kids/interactive-toys'),(1315,45,0,189,'Push Toys'),(1316,52,0,189,'PRODUCTS'),(1317,119,0,189,'push-toys'),(1318,120,0,189,'sample-categories/kids/push-toys'),(1319,45,0,190,'Arts, Crafts & Sewing'),(1320,52,0,190,'PRODUCTS'),(1321,119,0,190,'arts-crafts-sewing'),(1322,120,0,190,'furniture/arts-crafts-sewing'),(1323,48,22,8,'/media/catalog/category/cat-31.jpg'),(1324,48,22,16,'/media/catalog/category/icon-cat-17.png'),(1325,48,22,179,'/magento2/sm-marketnew242/pub/media/catalog/category/icon-cat-19.png'),(1326,45,22,179,'Toys & Babies'),(1327,45,0,191,'Food & Organic'),(1328,52,0,191,'PRODUCTS'),(1329,119,0,191,'food-organic'),(1330,120,0,191,'sample-categories/food-organic'),(1331,45,22,180,'Fashion Kids'),(1332,48,22,180,'/media/catalog/category/cat-26.jpg'),(1333,45,22,4,'Smartphones'),(1334,48,22,4,'/media/catalog/category/cat-27.jpg'),(1335,45,22,169,'Bag & Backpacks'),(1336,48,22,169,'/media/catalog/category/cat-28.jpg'),(1337,45,22,181,'Baby & Mom'),(1338,48,22,181,'/media/catalog/category/cat-29.jpg'),(1339,48,22,191,'/media/catalog/category/cat-30.jpg'),(1346,45,0,192,'Jewelry'),(1347,52,0,192,'PRODUCTS'),(1348,119,0,192,'jewelry'),(1349,120,0,192,'jewelry-watches/jewelry'),(1356,45,0,193,'Shop Skincare'),(1357,52,0,193,'PRODUCTS'),(1358,119,0,193,'shop-skincare'),(1359,120,0,193,'health-beauty/shop-skincare'),(1360,45,0,194,'Shop Lips & Eyes'),(1361,52,0,194,'PRODUCTS'),(1362,119,0,194,'shop-lips-eyes'),(1363,120,0,194,'health-beauty/shop-lips-eyes'),(1364,45,0,195,'Shop Perfume'),(1365,52,0,195,'PRODUCTS'),(1366,119,0,195,'shop-perfume'),(1367,120,0,195,'health-beauty/shop-perfume'),(1368,45,0,196,'Shop Facecare'),(1369,52,0,196,'PRODUCTS'),(1370,119,0,196,'shop-facecare'),(1371,120,0,196,'health-beauty/shop-facecare'),(1372,45,0,197,'Shop Brushes'),(1373,52,0,197,'PRODUCTS'),(1374,119,0,197,'shop-brushes'),(1375,120,0,197,'health-beauty/shop-brushes'),(1377,48,0,193,'/media/catalog/category/icon-cat-20.jpg'),(1378,49,0,193,NULL),(1379,60,0,193,NULL),(1380,63,0,193,NULL),(1382,48,0,194,'/media/catalog/category/icon-cat-21.jpg'),(1383,49,0,194,NULL),(1384,60,0,194,NULL),(1385,63,0,194,NULL),(1387,48,0,195,'/media/catalog/category/icon-cat-22.jpg'),(1388,49,0,195,NULL),(1389,60,0,195,NULL),(1390,63,0,195,NULL),(1392,48,0,196,'/media/catalog/category/icon-cat-23.jpg'),(1393,49,0,196,NULL),(1394,60,0,196,NULL),(1395,63,0,196,NULL),(1397,48,0,197,'/media/catalog/category/icon-cat-24.jpg'),(1398,49,0,197,NULL),(1399,60,0,197,NULL),(1400,63,0,197,NULL),(1403,60,25,13,NULL),(1404,63,25,13,NULL),(1409,45,0,198,'Clothing'),(1410,52,0,198,'PRODUCTS'),(1411,119,0,198,'clothing-sport'),(1412,120,0,198,'sports-outdoors/clothing-sport'),(1413,45,0,199,'Bag & Backpack'),(1414,52,0,199,'PRODUCTS'),(1415,119,0,199,'bag-backpack'),(1416,120,0,199,'sports-outdoors/bag-backpack'),(1417,45,0,200,'Sport Shoes'),(1418,52,0,200,'PRODUCTS'),(1419,119,0,200,'sport-shoes'),(1420,120,0,200,'sports-outdoors/sport-shoes'),(1421,45,0,201,'Gym Equipment'),(1422,52,0,201,'PRODUCTS'),(1423,119,0,201,'gym-equipment'),(1424,120,0,201,'sports-outdoors/gym-equipment'),(1425,45,0,202,'Accessories'),(1426,52,0,202,'PRODUCTS'),(1427,119,0,202,'accessories-sport'),(1428,120,0,202,'sports-outdoors/accessories-sport'),(1429,45,0,203,'Sport Bike'),(1430,52,0,203,'PRODUCTS'),(1431,119,0,203,'sport-bike'),(1432,120,0,203,'sports-outdoors/sport-bike'),(1434,48,0,198,'/media/catalog/category/cat-32.jpg'),(1435,49,0,198,NULL),(1436,60,0,198,NULL),(1437,63,0,198,NULL),(1439,48,0,199,'/media/catalog/category/cat-33.jpg'),(1440,49,0,199,NULL),(1441,60,0,199,NULL),(1442,63,0,199,NULL),(1444,48,0,200,'/media/catalog/category/cat-34.jpg'),(1445,49,0,200,NULL),(1446,60,0,200,NULL),(1447,63,0,200,NULL),(1449,48,0,201,'/media/catalog/category/cat-35.jpg'),(1450,49,0,201,NULL),(1451,60,0,201,NULL),(1452,63,0,201,NULL),(1454,48,0,202,'/media/catalog/category/cat-36.jpg'),(1455,49,0,202,NULL),(1456,60,0,202,NULL),(1457,63,0,202,NULL),(1459,48,0,203,'/media/catalog/category/cat-37.jpg'),(1460,49,0,203,NULL),(1461,60,0,203,NULL),(1462,63,0,203,NULL),(1463,45,0,204,'Women Products'),(1464,52,0,204,'PRODUCTS'),(1465,119,0,204,'women-products'),(1466,120,0,204,'sports-outdoors/women-products'),(1467,45,0,205,'Men Products'),(1468,52,0,205,'PRODUCTS'),(1469,119,0,205,'men-products'),(1470,120,0,205,'sports-outdoors/men-products'),(1472,120,1,204,'sports-outdoors/women-products'),(1473,120,2,204,'sports-outdoors/women-products'),(1474,120,3,204,'sports-outdoors/women-products'),(1475,120,4,204,'sports-outdoors/women-products'),(1476,120,5,204,'sports-outdoors/women-products'),(1477,120,6,204,'sports-outdoors/women-products'),(1478,120,7,204,'sports-outdoors/women-products'),(1479,120,8,204,'sports-outdoors/women-products'),(1480,120,9,204,'sports-outdoors/women-products'),(1481,120,10,204,'sports-outdoors/women-products'),(1482,120,11,204,'sports-outdoors/women-products'),(1483,120,12,204,'sports-outdoors/women-products'),(1484,120,13,204,'sports-outdoors/women-products'),(1485,120,14,204,'sports-outdoors/women-products'),(1486,120,15,204,'sports-outdoors/women-products'),(1487,120,16,204,'sports-outdoors/women-products'),(1488,120,17,204,'sports-outdoors/women-products'),(1489,120,18,204,'sports-outdoors/women-products'),(1490,120,19,204,'sports-outdoors/women-products'),(1491,120,20,204,'sports-outdoors/women-products'),(1492,120,21,204,'sports-outdoors/women-products'),(1493,120,22,204,'sports-outdoors/women-products'),(1494,120,23,204,'sports-outdoors/women-products'),(1495,120,24,204,'sports-outdoors/women-products'),(1496,120,25,204,'sports-outdoors/women-products'),(1498,120,1,205,'sports-outdoors/men-products'),(1499,120,2,205,'sports-outdoors/men-products'),(1500,120,3,205,'sports-outdoors/men-products'),(1501,120,4,205,'sports-outdoors/men-products'),(1502,120,5,205,'sports-outdoors/men-products'),(1503,120,6,205,'sports-outdoors/men-products'),(1504,120,7,205,'sports-outdoors/men-products'),(1505,120,8,205,'sports-outdoors/men-products'),(1506,120,9,205,'sports-outdoors/men-products'),(1507,120,10,205,'sports-outdoors/men-products'),(1508,120,11,205,'sports-outdoors/men-products'),(1509,120,12,205,'sports-outdoors/men-products'),(1510,120,13,205,'sports-outdoors/men-products'),(1511,120,14,205,'sports-outdoors/men-products'),(1512,120,15,205,'sports-outdoors/men-products'),(1513,120,16,205,'sports-outdoors/men-products'),(1514,120,17,205,'sports-outdoors/men-products'),(1515,120,18,205,'sports-outdoors/men-products'),(1516,120,19,205,'sports-outdoors/men-products'),(1517,120,20,205,'sports-outdoors/men-products'),(1518,120,21,205,'sports-outdoors/men-products'),(1519,120,22,205,'sports-outdoors/men-products'),(1520,120,23,205,'sports-outdoors/men-products'),(1521,120,24,205,'sports-outdoors/men-products'),(1522,120,25,205,'sports-outdoors/men-products'),(1529,45,0,206,'Auto'),(1530,52,0,206,'PRODUCTS'),(1531,119,0,206,'auto'),(1532,120,0,206,'sample-categories/auto'),(1533,45,0,207,'Tires & Wheels'),(1534,52,0,207,'PRODUCTS'),(1535,119,0,207,'tires-wheels'),(1536,120,0,207,'sample-categories/auto/tires-wheels'),(1537,45,0,208,'Components'),(1538,52,0,208,'PRODUCTS'),(1539,119,0,208,'components'),(1540,120,0,208,'sample-categories/auto/components'),(1541,45,0,209,'Steering Wheel'),(1542,52,0,209,'PRODUCTS'),(1543,119,0,209,'steering-wheel'),(1544,120,0,209,'sample-categories/auto/steering-wheel'),(1545,45,0,210,'Sport Brake'),(1546,52,0,210,'PRODUCTS'),(1547,119,0,210,'sport-brake'),(1548,120,0,210,'sample-categories/auto/sport-brake'),(1549,45,0,211,'Smart Pump'),(1550,52,0,211,'PRODUCTS'),(1551,119,0,211,'smart-pump'),(1552,120,0,211,'sample-categories/auto/smart-pump'),(1553,45,0,212,'Lights & Lighting'),(1554,52,0,212,'PRODUCTS'),(1555,119,0,212,'lights-lighting'),(1556,120,0,212,'sample-categories/auto/lights-lighting'),(1557,45,0,213,'Oils & Fluids'),(1558,52,0,213,'PRODUCTS'),(1559,119,0,213,'oils-fluids'),(1560,120,0,213,'sample-categories/auto/oils-fluids'),(1561,45,0,214,'Baby Car Seats'),(1562,52,0,214,'PRODUCTS'),(1563,119,0,214,'baby-car-seats'),(1564,120,0,214,'sample-categories/auto/baby-car-seats'),(1565,45,0,215,'Sport Car seat'),(1566,52,0,215,'PRODUCTS'),(1567,119,0,215,'sport-car-seat'),(1568,120,0,215,'sample-categories/auto/sport-car-seat'),(1569,45,0,216,'Automotive Parts'),(1570,52,0,216,'PRODUCTS'),(1571,119,0,216,'automotive-parts'),(1572,120,0,216,'sample-categories/auto/automotive-parts'),(1573,45,0,217,'Smart Devices'),(1574,52,0,217,'PRODUCTS'),(1575,119,0,217,'smart-devices'),(1576,120,0,217,'sample-categories/auto/smart-devices'),(1578,48,0,217,'/media/catalog/category/cat-48.jpg'),(1579,49,0,217,NULL),(1580,60,0,217,NULL),(1581,63,0,217,NULL),(1583,48,0,213,'/media/catalog/category/cat-44.jpg'),(1584,49,0,213,NULL),(1585,60,0,213,NULL),(1586,63,0,213,NULL),(1587,45,0,218,'Audio Equipments'),(1588,52,0,218,'PRODUCTS'),(1589,119,0,218,'audio-equipments'),(1590,120,0,218,'sample-categories/auto/audio-equipments'),(1591,45,0,219,'Tires'),(1592,52,0,219,'PRODUCTS'),(1593,119,0,219,'tires'),(1594,120,0,219,'sample-categories/auto/tires-wheels/tires'),(1595,45,0,220,'Tires Accessories'),(1596,52,0,220,'PRODUCTS'),(1597,119,0,220,'tires-accessories'),(1598,120,0,220,'sample-categories/auto/tires-wheels/tires-accessories'),(1599,45,0,221,'Tire Chains'),(1600,52,0,221,'PRODUCTS'),(1601,119,0,221,'tire-chains'),(1602,120,0,221,'sample-categories/auto/tires-wheels/tire-chains'),(1603,45,0,222,'Wheels'),(1604,52,0,222,'PRODUCTS'),(1605,119,0,222,'wheels'),(1606,120,0,222,'sample-categories/auto/tires-wheels/wheels'),(1607,45,0,223,'Wheels Accessories'),(1608,52,0,223,'PRODUCTS'),(1609,119,0,223,'wheels-accessories'),(1610,120,0,223,'sample-categories/auto/tires-wheels/wheels-accessories'),(1611,45,0,224,'Dash Cam'),(1612,52,0,224,'PRODUCTS'),(1613,119,0,224,'dash-cam'),(1614,120,0,224,'sample-categories/auto/smart-devices/dash-cam'),(1615,45,0,225,'Bluetooth Devices'),(1616,52,0,225,'PRODUCTS'),(1617,119,0,225,'bluetooth-devices'),(1618,120,0,225,'sample-categories/auto/smart-devices/bluetooth-devices'),(1619,45,0,226,'USB Connect'),(1620,52,0,226,'PRODUCTS'),(1621,119,0,226,'usb-connect'),(1622,120,0,226,'sample-categories/auto/smart-devices/usb-connect'),(1623,45,0,227,'Screen TV'),(1624,52,0,227,'PRODUCTS'),(1625,119,0,227,'screen-tv'),(1626,120,0,227,'sample-categories/auto/smart-devices/screen-tv'),(1627,45,0,228,'Speaker For Car'),(1628,52,0,228,'PRODUCTS'),(1629,119,0,228,'speaker-for-car'),(1630,120,0,228,'sample-categories/auto/smart-devices/speaker-for-car'),(1631,45,0,229,'Car Oils'),(1632,52,0,229,'PRODUCTS'),(1633,119,0,229,'car-oils'),(1634,120,0,229,'sample-categories/auto/oils-fluids/car-oils'),(1635,45,0,230,'Brake Fluids'),(1636,52,0,230,'PRODUCTS'),(1637,119,0,230,'brake-fluids'),(1638,120,0,230,'sample-categories/auto/oils-fluids/brake-fluids'),(1639,45,0,231,'Body Repair'),(1640,52,0,231,'PRODUCTS'),(1641,119,0,231,'body-repair'),(1642,120,0,231,'sample-categories/auto/oils-fluids/body-repair'),(1643,45,0,232,'Power Steering Fluids'),(1644,52,0,232,'PRODUCTS'),(1645,119,0,232,'power-steering-fluids'),(1646,120,0,232,'sample-categories/auto/oils-fluids/power-steering-fluids'),(1647,45,0,233,'Transmission Fluids'),(1648,52,0,233,'PRODUCTS'),(1649,119,0,233,'transmission-fluids'),(1650,120,0,233,'sample-categories/auto/oils-fluids/transmission-fluids'),(1651,45,0,234,'Headlights'),(1652,52,0,234,'PRODUCTS'),(1653,119,0,234,'headlights'),(1654,120,0,234,'sample-categories/auto/lights-lighting/headlights'),(1655,45,0,235,'Interior Light'),(1656,52,0,235,'PRODUCTS'),(1657,119,0,235,'interior-light'),(1658,120,0,235,'sample-categories/auto/lights-lighting/interior-light'),(1659,45,0,236,'LED Tail Lights'),(1660,52,0,236,'PRODUCTS'),(1661,119,0,236,'led-tail-lights'),(1662,120,0,236,'sample-categories/auto/lights-lighting/led-tail-lights'),(1663,45,0,237,'Rotating Warning Light'),(1664,52,0,237,'PRODUCTS'),(1665,119,0,237,'rotating-warning-light'),(1666,120,0,237,'sample-categories/auto/lights-lighting/rotating-warning-light'),(1667,45,0,238,'Lens Tape/Repair'),(1668,52,0,238,'PRODUCTS'),(1669,119,0,238,'lens-tape-repair'),(1670,120,0,238,'sample-categories/auto/lights-lighting/lens-tape-repair'),(1671,45,0,239,'Replacement Parts'),(1672,52,0,239,'PRODUCTS'),(1673,119,0,239,'replacement-parts'),(1674,120,0,239,'sample-categories/auto/replacement-parts'),(1675,45,0,240,'Brake Parts'),(1676,52,0,240,'PRODUCTS'),(1677,119,0,240,'brake-parts'),(1678,120,0,240,'sample-categories/auto/replacement-parts/brake-parts'),(1679,45,0,241,'Shock & Suspension'),(1680,52,0,241,'PRODUCTS'),(1681,119,0,241,'shock-suspension'),(1682,120,0,241,'sample-categories/auto/replacement-parts/shock-suspension'),(1683,45,0,242,'Exhaust & Emission'),(1684,52,0,242,'PRODUCTS'),(1685,119,0,242,'exhaust-emission'),(1686,120,0,242,'sample-categories/auto/replacement-parts/exhaust-emission'),(1687,45,0,243,'Replacement Filter'),(1688,52,0,243,'PRODUCTS'),(1689,119,0,243,'replacement-filter'),(1690,120,0,243,'sample-categories/auto/replacement-parts/replacement-filter'),(1691,45,0,244,'Lighting & Electrical'),(1692,52,0,244,'PRODUCTS'),(1693,119,0,244,'lighting-electrical'),(1694,120,0,244,'sample-categories/auto/replacement-parts/lighting-electrical'),(1695,45,0,245,'Footmuffs'),(1696,52,0,245,'PRODUCTS'),(1697,119,0,245,'footmuffs'),(1698,120,0,245,'sample-categories/auto/baby-car-seats/footmuffs'),(1699,45,0,246,'Raincovers'),(1700,52,0,246,'PRODUCTS'),(1701,119,0,246,'raincovers'),(1702,120,0,246,'sample-categories/auto/baby-car-seats/raincovers'),(1703,45,0,247,'Bases'),(1704,52,0,247,'PRODUCTS'),(1705,119,0,247,'bases'),(1706,120,0,247,'sample-categories/auto/baby-car-seats/bases'),(1707,45,0,248,'Birth - 4 Years'),(1708,52,0,248,'PRODUCTS'),(1709,119,0,248,'birth-4-years'),(1710,120,0,248,'sample-categories/auto/baby-car-seats/birth-4-years'),(1711,45,0,249,'Birth - 12 Months'),(1712,52,0,249,'PRODUCTS'),(1713,119,0,249,'birth-12-months'),(1714,120,0,249,'sample-categories/auto/baby-car-seats/birth-12-months'),(1716,48,0,207,'/media/catalog/category/cat-38.jpg'),(1717,49,0,207,NULL),(1718,60,0,207,NULL),(1719,63,0,207,NULL),(1721,48,0,208,'/media/catalog/category/cat-39.jpg'),(1722,49,0,208,NULL),(1723,60,0,208,NULL),(1724,63,0,208,NULL),(1726,48,0,209,'/media/catalog/category/cat-40.jpg'),(1727,49,0,209,NULL),(1728,60,0,209,NULL),(1729,63,0,209,NULL),(1731,48,0,210,'/media/catalog/category/cat-41.jpg'),(1732,49,0,210,NULL),(1733,60,0,210,NULL),(1734,63,0,210,NULL),(1736,48,0,211,'/media/catalog/category/cat-42.jpg'),(1737,49,0,211,NULL),(1738,60,0,211,NULL),(1739,63,0,211,NULL),(1741,48,0,212,'/media/catalog/category/cat-43.jpg'),(1742,49,0,212,NULL),(1743,60,0,212,NULL),(1744,63,0,212,NULL),(1747,48,0,214,'/media/catalog/category/cat-45.jpg'),(1748,49,0,214,NULL),(1749,60,0,214,NULL),(1750,63,0,214,NULL),(1752,48,0,215,'/media/catalog/category/cat-46.jpg'),(1753,49,0,215,NULL),(1754,60,0,215,NULL),(1755,63,0,215,NULL),(1757,48,0,216,'/media/catalog/category/cat-47.jpg'),(1758,49,0,216,NULL),(1759,60,0,216,NULL),(1760,63,0,216,NULL),(1763,48,0,218,'/media/catalog/category/cat-49.jpg'),(1764,49,0,218,NULL),(1765,60,0,218,NULL),(1766,63,0,218,NULL),(1776,45,0,250,'Power Tools'),(1777,52,0,250,'PRODUCTS'),(1778,119,0,250,'power-tools'),(1779,120,0,250,'sample-categories/power-tools'),(1780,45,0,251,'Lawn & Garden'),(1781,52,0,251,'PRODUCTS'),(1782,119,0,251,'lawn-garden'),(1783,120,0,251,'sample-categories/lawn-garden'),(1784,45,0,252,'Hand Tools'),(1785,52,0,252,'PRODUCTS'),(1786,119,0,252,'hand-tools'),(1787,120,0,252,'sample-categories/hand-tools'),(1788,45,0,253,'Tools Storage'),(1789,52,0,253,'PRODUCTS'),(1790,119,0,253,'tools-storage'),(1791,120,0,253,'sample-categories/tools-storage'),(1792,45,0,254,'Clean Tools'),(1793,52,0,254,'PRODUCTS'),(1794,119,0,254,'clean-tools'),(1795,120,0,254,'sample-categories/clean-tools'),(1796,45,0,255,'Wrenches'),(1797,52,0,255,'PRODUCTS'),(1798,119,0,255,'wrenches'),(1799,120,0,255,'sample-categories/lawn-garden/wrenches'),(1800,45,0,256,'Tool Sets'),(1801,52,0,256,'PRODUCTS'),(1802,119,0,256,'tool-sets'),(1803,120,0,256,'sample-categories/lawn-garden/tool-sets'),(1804,45,0,257,'Screwdivers'),(1805,52,0,257,'PRODUCTS'),(1806,119,0,257,'screwdivers'),(1807,120,0,257,'sample-categories/lawn-garden/screwdivers'),(1808,45,0,258,'Clamps & Vises'),(1809,52,0,258,'PRODUCTS'),(1810,119,0,258,'clamps-vises'),(1811,120,0,258,'sample-categories/lawn-garden/clamps-vises'),(1812,45,0,259,'Polisher'),(1813,52,0,259,'PRODUCTS'),(1814,119,0,259,'polisher'),(1815,120,0,259,'sample-categories/power-tools/polisher'),(1816,45,0,260,'Power Drills'),(1817,52,0,260,'PRODUCTS'),(1818,119,0,260,'power-drills'),(1819,120,0,260,'sample-categories/power-tools/power-drills'),(1820,45,0,261,'Nail Gun'),(1821,52,0,261,'PRODUCTS'),(1822,119,0,261,'nail-gun'),(1823,120,0,261,'sample-categories/power-tools/nail-gun'),(1824,45,0,262,'Grinder'),(1825,52,0,262,'PRODUCTS'),(1826,119,0,262,'grinder'),(1827,120,0,262,'sample-categories/power-tools/grinder'),(1829,48,0,252,'/magento2/sm-marketnew243/pub/media/catalog/category/cat-52.jpg'),(1830,49,0,252,NULL),(1831,60,0,252,NULL),(1832,63,0,252,NULL),(1833,45,0,263,'Brush'),(1834,52,0,263,'PRODUCTS'),(1835,119,0,263,'brush'),(1836,120,0,263,'sample-categories/hand-tools/brush'),(1837,45,0,264,'Caulking Gun'),(1838,52,0,264,'PRODUCTS'),(1839,119,0,264,'caulking-gun'),(1840,120,0,264,'sample-categories/hand-tools/caulking-gun'),(1841,45,0,265,'Clamps'),(1842,52,0,265,'PRODUCTS'),(1843,119,0,265,'clamps'),(1844,120,0,265,'sample-categories/hand-tools/clamps'),(1845,45,0,266,'Electric Planer'),(1846,52,0,266,'PRODUCTS'),(1847,119,0,266,'electric-planer'),(1848,120,0,266,'sample-categories/hand-tools/electric-planer'),(1850,48,0,253,'/media/catalog/category/cat-53.jpg'),(1851,49,0,253,NULL),(1852,60,0,253,NULL),(1853,63,0,253,NULL),(1854,45,0,267,'Tool Cabinet'),(1855,52,0,267,'PRODUCTS'),(1856,119,0,267,'tool-cabinet'),(1857,120,0,267,'sample-categories/tools-storage/tool-cabinet'),(1858,45,0,268,'Tool Case'),(1859,52,0,268,'PRODUCTS'),(1860,119,0,268,'tool-case'),(1861,120,0,268,'sample-categories/tools-storage/tool-case'),(1862,45,0,269,'Tool Bag'),(1863,52,0,269,'PRODUCTS'),(1864,119,0,269,'tool-bag'),(1865,120,0,269,'sample-categories/tools-storage/tool-bag'),(1866,45,0,270,'Tool Box'),(1867,52,0,270,'PRODUCTS'),(1868,119,0,270,'tool-box'),(1869,120,0,270,'sample-categories/tools-storage/tool-box'),(1870,45,0,271,'Mops'),(1871,52,0,271,'PRODUCTS'),(1872,119,0,271,'mops'),(1873,120,0,271,'sample-categories/clean-tools/mops'),(1874,45,0,272,'Brushes'),(1875,52,0,272,'PRODUCTS'),(1876,119,0,272,'brushes'),(1877,120,0,272,'sample-categories/clean-tools/brushes'),(1878,45,0,273,'Skin Scrubber'),(1879,52,0,273,'PRODUCTS'),(1880,119,0,273,'skin-scrubber'),(1881,120,0,273,'sample-categories/clean-tools/skin-scrubber'),(1882,45,0,274,'Accessories'),(1883,52,0,274,'PRODUCTS'),(1884,119,0,274,'accessories'),(1885,120,0,274,'sample-categories/clean-tools/accessories'),(1886,45,0,275,'Industrial Valves'),(1887,52,0,275,'PRODUCTS'),(1888,119,0,275,'industrial-valves'),(1889,120,0,275,'sample-categories/industrial-valves'),(1890,45,0,276,'Valve'),(1891,52,0,276,'PRODUCTS'),(1892,119,0,276,'valve'),(1893,120,0,276,'sample-categories/industrial-valves/valve'),(1894,45,0,277,'Ball Valve'),(1895,52,0,277,'PRODUCTS'),(1896,119,0,277,'ball-valve'),(1897,120,0,277,'sample-categories/industrial-valves/ball-valve'),(1898,45,0,278,'Gate Valve'),(1899,52,0,278,'PRODUCTS'),(1900,119,0,278,'gate-valve'),(1901,120,0,278,'sample-categories/industrial-valves/gate-valve'),(1902,45,0,279,'Solenoid Valve'),(1903,52,0,279,'PRODUCTS'),(1904,119,0,279,'solenoid-valve'),(1905,120,0,279,'sample-categories/industrial-valves/solenoid-valve'),(1907,48,0,250,'/media/catalog/category/cat-50.jpg'),(1908,49,0,250,NULL),(1909,60,0,250,NULL),(1910,63,0,250,NULL),(1912,48,0,251,'/media/catalog/category/cat-51.jpg'),(1913,49,0,251,NULL),(1914,60,0,251,NULL),(1915,63,0,251,NULL),(1919,48,0,254,'/media/catalog/category/cat-54.jpg'),(1920,49,0,254,NULL),(1921,60,0,254,NULL),(1922,63,0,254,NULL),(1924,48,0,275,'/media/catalog/category/cat-55.jpg'),(1925,49,0,275,NULL),(1926,60,0,275,NULL),(1927,63,0,275,NULL),(1929,48,0,259,NULL),(1930,49,0,259,NULL),(1931,60,0,259,NULL),(1932,63,0,259,NULL),(1935,48,0,263,NULL),(1936,49,0,263,NULL),(1937,60,0,263,NULL),(1938,63,0,263,NULL),(1945,45,0,280,'Organics'),(1946,52,0,280,'PRODUCTS'),(1947,119,0,280,'organics'),(1948,120,0,280,'sample-categories/organics'),(1949,45,0,281,'Chocolate'),(1950,52,0,281,'PRODUCTS'),(1951,119,0,281,'chocolate'),(1952,120,0,281,'sample-categories/organics/chocolate'),(1953,45,0,282,'Fresh Fruit'),(1954,52,0,282,'PRODUCTS'),(1955,119,0,282,'fresh-fruit'),(1956,120,0,282,'sample-categories/organics/fresh-fruit'),(1957,45,0,283,'Meat & Protein'),(1958,52,0,283,'PRODUCTS'),(1959,119,0,283,'meat-protein'),(1960,120,0,283,'sample-categories/organics/meat-protein'),(1961,45,0,284,'Milk & Drink'),(1962,52,0,284,'PRODUCTS'),(1963,119,0,284,'milk-drink'),(1964,120,0,284,'sample-categories/organics/milk-drink'),(1965,45,0,285,'Fast Food'),(1966,52,0,285,'PRODUCTS'),(1967,119,0,285,'fast-food'),(1968,120,0,285,'sample-categories/organics/fast-food'),(1970,48,0,280,'/media/catalog/category/cat-56.png'),(1971,49,0,280,NULL),(1972,60,0,280,NULL),(1973,63,0,280,NULL),(1975,48,0,281,'/media/catalog/category/cat-57.png'),(1976,49,0,281,NULL),(1977,60,0,281,NULL),(1978,63,0,281,NULL),(1980,48,0,282,'/media/catalog/category/cat-58.png'),(1981,49,0,282,NULL),(1982,60,0,282,NULL),(1983,63,0,282,NULL),(1985,48,0,283,'/media/catalog/category/cat-59.png'),(1986,49,0,283,NULL),(1987,60,0,283,NULL),(1988,63,0,283,NULL),(1990,48,0,284,'/media/catalog/category/cat-60.png'),(1991,49,0,284,NULL),(1992,60,0,284,NULL),(1993,63,0,284,NULL),(1995,48,0,285,'/media/catalog/category/cat-61.png'),(1996,49,0,285,NULL),(1997,60,0,285,NULL),(1998,63,0,285,NULL),(1999,45,0,286,'Bundle'),(2000,52,0,286,'PRODUCTS'),(2001,119,0,286,'bundle'),(2002,120,0,286,'sample-categories/bundle'),(2004,48,0,286,NULL),(2005,49,0,286,NULL),(2006,60,0,286,NULL),(2007,63,0,286,NULL),(2008,45,0,287,'360 Degree'),(2009,52,0,287,'PRODUCTS'),(2010,119,0,287,'360-degree'),(2011,120,0,287,'sample-categories/360-degree'),(2015,60,29,15,NULL),(2016,63,29,15,NULL),(2019,45,0,288,'Medicine'),(2020,52,0,288,'PRODUCTS'),(2021,119,0,288,'medicine'),(2022,120,0,288,'sample-categories/medicine'),(2030,45,0,289,'Fashion'),(2031,52,0,289,'PRODUCTS'),(2032,119,0,289,'fashion'),(2033,120,0,289,'sample-categories/fashion'),(2034,45,0,290,'For Men'),(2035,52,0,290,'PRODUCTS'),(2036,119,0,290,'for-men'),(2037,120,0,290,'sample-categories/fashion/for-men'),(2038,45,0,291,'For Women'),(2039,52,0,291,'PRODUCTS'),(2040,119,0,291,'for-women'),(2041,120,0,291,'sample-categories/fashion/for-women'),(2042,45,0,292,'For Kids'),(2043,52,0,292,'PRODUCTS'),(2044,119,0,292,'for-kids'),(2045,120,0,292,'sample-categories/fashion/for-kids'),(2046,45,0,293,'Accessories'),(2047,52,0,293,'PRODUCTS'),(2048,119,0,293,'accessories'),(2049,120,0,293,'sample-categories/fashion/accessories'),(2050,45,0,294,'Bicycle'),(2051,52,0,294,'PRODUCTS'),(2052,119,0,294,'bicycle'),(2053,120,0,294,'sample-categories/bicycle'),(2058,60,31,7,NULL),(2059,63,31,7,NULL),(2061,45,0,295,'Clothings'),(2062,48,0,295,'/media/catalog/category/1.jpg'),(2063,52,0,295,'PRODUCTS'),(2064,119,0,295,'clothings'),(2065,120,0,295,'sample-categories/fashion/clothings'),(2066,45,0,296,'Shoes & Sandals'),(2067,48,0,296,'/media/catalog/category/2.jpg'),(2068,52,0,296,'PRODUCTS'),(2069,119,0,296,'shoes-sandals'),(2070,120,0,296,'sample-categories/fashion/shoes-sandals'),(2071,45,0,297,'Handbags'),(2072,48,0,297,'/media/catalog/category/3_1.jpg'),(2073,52,0,297,'PRODUCTS'),(2074,119,0,297,'handbags'),(2075,120,0,297,'sample-categories/fashion/handbags'),(2076,45,0,298,'Sunglasses'),(2077,48,0,298,'/media/catalog/category/4.jpg'),(2078,52,0,298,'PRODUCTS'),(2079,119,0,298,'sunglasses'),(2080,120,0,298,'sample-categories/fashion/sunglasses'),(2081,45,0,299,'Watches'),(2082,48,0,299,'/media/catalog/category/5_1.jpg'),(2083,52,0,299,'PRODUCTS'),(2084,119,0,299,'watches'),(2085,120,0,299,'sample-categories/fashion/watches'),(2087,49,0,295,NULL),(2088,60,0,295,NULL),(2089,63,0,295,NULL),(2091,49,0,296,NULL),(2092,60,0,296,NULL),(2093,63,0,296,NULL),(2095,49,0,297,NULL),(2096,60,0,297,NULL),(2097,63,0,297,NULL),(2099,49,0,298,NULL),(2100,60,0,298,NULL),(2101,63,0,298,NULL),(2103,49,0,299,NULL),(2104,60,0,299,NULL),(2105,63,0,299,NULL),(2107,48,0,293,'/media/catalog/category/6_1.jpg'),(2108,49,0,293,NULL),(2109,60,0,293,NULL),(2110,63,0,293,NULL);
/*!40000 ALTER TABLE `catalog_category_entity_varchar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product`
--

DROP TABLE IF EXISTS `catalog_category_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product` (
  `entity_id` int NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category ID',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `position` int NOT NULL DEFAULT '0' COMMENT 'Position',
  PRIMARY KEY (`entity_id`,`category_id`,`product_id`),
  UNIQUE KEY `CATALOG_CATEGORY_PRODUCT_CATEGORY_ID_PRODUCT_ID` (`category_id`,`product_id`),
  KEY `CATALOG_CATEGORY_PRODUCT_PRODUCT_ID` (`product_id`),
  CONSTRAINT `CAT_CTGR_PRD_CTGR_ID_CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`category_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_CTGR_PRD_PRD_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=909 DEFAULT CHARSET=utf8 COMMENT='Catalog Product To Category Linkage Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product`
--

LOCK TABLES `catalog_category_product` WRITE;
/*!40000 ALTER TABLE `catalog_category_product` DISABLE KEYS */;
INSERT INTO `catalog_category_product` VALUES (1,3,1,0),(2,3,2,0),(3,3,3,0),(4,3,4,0),(5,137,4,0),(6,3,5,0),(7,3,6,0),(8,19,6,0),(9,29,6,0),(10,30,6,0),(11,3,7,0),(12,19,7,0),(13,33,7,0),(14,42,7,0),(15,3,8,0),(16,19,8,0),(17,29,8,0),(18,33,8,0),(19,42,8,0),(20,3,10,0),(21,19,10,0),(22,29,10,0),(23,30,10,0),(24,33,10,0),(25,3,11,0),(26,19,11,0),(27,27,11,0),(28,33,11,0),(29,42,11,0),(30,4,12,0),(31,102,12,0),(32,4,13,0),(33,102,13,0),(34,4,14,0),(35,101,14,0),(36,102,14,0),(37,4,15,0),(38,101,15,0),(39,102,15,0),(40,4,16,0),(41,101,16,0),(42,102,16,0),(43,4,17,0),(44,102,17,0),(45,4,18,0),(46,99,18,0),(47,103,18,0),(48,104,18,0),(49,105,18,0),(50,106,18,0),(51,107,18,0),(52,4,19,0),(53,102,19,0),(54,16,20,0),(55,7,21,0),(56,13,21,0),(57,16,21,0),(58,78,21,0),(59,80,21,0),(60,98,21,0),(61,7,22,0),(62,16,22,0),(63,80,22,0),(64,98,22,0),(65,135,22,0),(66,16,23,0),(67,134,23,0),(68,13,24,0),(69,16,24,0),(70,13,25,0),(71,16,25,0),(72,7,26,0),(73,13,26,0),(74,16,26,0),(75,78,26,0),(76,80,26,0),(77,81,26,0),(78,82,26,0),(79,83,26,0),(80,96,26,0),(81,97,26,0),(82,98,26,0),(83,13,27,0),(84,16,27,0),(85,11,28,0),(86,138,28,0),(87,139,28,0),(88,140,28,0),(89,137,28,0),(90,11,29,0),(91,11,30,0),(92,138,30,0),(93,139,30,0),(94,140,30,0),(95,11,31,0),(96,137,31,0),(97,11,32,0),(98,138,32,0),(99,139,32,0),(100,140,32,0),(101,11,33,0),(102,138,33,0),(103,139,33,0),(104,140,33,0),(105,11,34,0),(106,137,34,0),(107,11,35,0),(108,137,35,0),(109,4,36,0),(110,102,36,0),(111,4,37,0),(112,102,37,0),(113,4,38,0),(114,102,38,0),(115,4,39,0),(116,102,39,0),(117,4,40,0),(118,102,40,0),(119,13,41,0),(120,13,42,0),(121,13,43,0),(122,145,1,0),(123,145,2,0),(124,145,3,0),(125,145,4,0),(126,145,5,0),(127,145,6,0),(128,145,7,0),(129,145,8,0),(130,145,9,0),(131,145,10,0),(132,145,11,0),(133,145,12,0),(134,145,13,0),(135,145,14,0),(136,145,15,0),(137,145,16,0),(138,145,17,0),(139,145,18,0),(140,145,19,0),(141,145,20,0),(142,145,21,0),(143,145,22,0),(144,145,23,0),(145,145,24,0),(146,145,25,0),(147,145,26,0),(148,145,27,0),(149,145,28,0),(150,145,29,0),(151,145,30,0),(152,145,31,0),(153,145,32,0),(154,145,33,0),(155,145,34,0),(156,145,35,0),(157,145,36,0),(158,145,37,0),(159,145,38,0),(160,145,39,0),(161,145,40,0),(162,145,41,0),(163,145,42,0),(164,145,43,0),(165,13,44,0),(166,13,45,0),(167,13,46,0),(168,13,47,0),(169,13,48,0),(170,13,49,0),(171,150,50,0),(172,150,51,0),(173,150,52,0),(174,150,53,0),(175,150,54,0),(176,150,55,0),(177,150,56,0),(178,150,57,0),(179,150,58,0),(180,150,59,0),(181,150,60,0),(182,8,61,0),(183,151,61,0),(184,152,61,0),(185,153,61,0),(186,154,61,0),(187,155,61,0),(188,156,61,0),(189,157,61,0),(190,158,61,0),(191,159,61,0),(192,8,62,0),(193,151,62,0),(194,154,62,0),(195,155,62,0),(196,156,62,0),(197,157,62,0),(198,159,62,0),(199,8,63,0),(200,151,63,0),(201,152,63,0),(202,153,63,0),(203,156,63,0),(204,158,63,0),(205,159,63,0),(206,8,64,0),(207,151,64,0),(208,153,64,0),(209,154,64,0),(210,155,64,0),(211,156,64,0),(212,157,64,0),(213,158,64,0),(214,159,64,0),(215,8,65,0),(216,151,65,0),(217,153,65,0),(218,155,65,0),(219,156,65,0),(220,157,65,0),(221,158,65,0),(222,159,65,0),(223,8,66,0),(224,151,66,0),(225,153,66,0),(226,154,66,0),(227,155,66,0),(228,156,66,0),(229,157,66,0),(230,158,66,0),(231,159,66,0),(236,16,41,0),(237,149,41,0),(238,160,41,0),(239,164,41,0),(240,166,41,0),(241,16,68,0),(242,160,68,0),(243,161,68,0),(244,162,68,0),(245,167,68,0),(246,16,69,0),(247,160,69,0),(248,161,69,0),(249,162,69,0),(250,167,69,0),(251,16,70,0),(252,160,70,0),(253,161,70,0),(254,164,70,0),(255,166,70,0),(256,169,70,0),(257,171,70,0),(258,16,71,0),(259,161,71,0),(260,168,71,0),(261,16,72,0),(262,160,72,0),(263,161,72,0),(264,162,72,0),(265,167,72,0),(266,16,73,0),(267,160,73,0),(268,164,73,0),(269,166,73,0),(270,173,1,0),(271,173,2,0),(272,173,3,0),(273,173,4,0),(274,173,5,0),(275,173,6,0),(276,173,7,0),(277,173,8,0),(278,173,9,0),(279,173,10,0),(280,173,11,0),(281,173,12,0),(282,173,13,0),(283,173,14,0),(284,173,15,0),(285,173,16,0),(286,173,17,0),(287,173,18,0),(288,173,19,0),(289,173,20,0),(290,173,21,0),(291,173,22,0),(292,173,23,0),(293,173,24,0),(294,173,25,0),(295,173,26,0),(296,173,27,0),(297,173,28,0),(298,173,29,0),(299,173,30,0),(300,174,1,0),(301,174,2,0),(302,174,3,0),(303,174,4,0),(304,174,5,0),(305,174,6,0),(306,174,7,0),(307,174,8,0),(308,174,9,0),(309,174,10,0),(310,174,11,0),(311,174,12,0),(312,174,13,0),(313,174,14,0),(314,174,15,0),(315,174,16,0),(316,174,17,0),(317,174,18,0),(318,174,19,0),(319,174,20,0),(320,174,21,0),(321,174,22,0),(322,174,23,0),(323,174,24,0),(324,174,25,0),(325,174,26,0),(326,174,27,0),(327,174,28,0),(328,174,29,0),(329,174,30,0),(330,175,1,0),(331,175,2,0),(332,175,3,0),(333,175,4,0),(334,175,5,0),(335,175,6,0),(336,175,7,0),(337,175,8,0),(338,175,9,0),(339,175,10,0),(340,175,11,0),(341,175,12,0),(342,175,13,0),(343,175,14,0),(344,175,15,0),(345,175,16,0),(346,175,17,0),(347,175,18,0),(348,175,19,0),(349,175,20,0),(350,175,21,0),(351,175,22,0),(352,175,23,0),(353,175,24,0),(354,175,25,0),(355,175,26,0),(356,175,27,0),(357,175,28,0),(358,175,29,0),(359,175,30,0),(360,176,1,0),(361,176,2,0),(362,176,3,0),(363,176,4,0),(364,176,5,0),(365,176,6,0),(366,176,7,0),(367,176,8,0),(368,176,9,0),(369,176,10,0),(370,176,11,0),(371,176,12,0),(372,176,13,0),(373,176,14,0),(374,176,15,0),(375,176,16,0),(376,176,17,0),(377,176,18,0),(378,176,19,0),(379,176,20,0),(380,176,21,0),(381,176,22,0),(382,176,23,0),(383,176,24,0),(384,176,25,0),(385,176,26,0),(386,176,27,0),(387,176,28,0),(388,176,29,0),(389,176,30,0),(390,177,74,0),(391,177,75,0),(392,177,76,0),(393,177,77,0),(394,177,78,0),(395,177,79,0),(396,177,80,0),(397,179,81,0),(398,180,81,0),(399,179,82,0),(400,182,82,0),(401,183,82,0),(402,179,83,0),(403,182,83,0),(404,183,83,0),(405,179,84,0),(406,182,84,0),(407,183,84,0),(408,179,85,0),(409,182,85,0),(410,183,85,0),(411,179,86,0),(412,181,86,0),(413,183,86,0),(414,179,87,0),(415,182,87,0),(416,183,87,0),(417,179,88,0),(418,182,88,0),(419,183,88,0),(420,192,89,0),(421,192,90,0),(422,192,91,0),(423,192,92,0),(424,192,93,0),(425,192,94,0),(426,193,95,0),(427,194,95,0),(428,195,95,0),(429,196,95,0),(430,197,95,0),(431,193,96,0),(432,194,96,0),(433,195,96,0),(434,196,96,0),(435,197,96,0),(436,193,97,0),(437,194,97,0),(438,195,97,0),(439,196,97,0),(440,197,97,0),(441,193,98,0),(442,194,98,0),(443,195,98,0),(444,196,98,0),(445,197,98,0),(446,193,99,0),(447,194,99,0),(448,195,99,0),(449,196,99,0),(450,197,99,0),(451,193,100,0),(452,194,100,0),(453,195,100,0),(454,196,100,0),(455,197,100,0),(456,198,101,0),(457,200,101,0),(458,202,101,0),(459,203,101,0),(460,204,101,0),(461,204,102,0),(462,205,102,0),(463,205,101,0),(464,200,102,0),(465,202,102,0),(466,203,102,0),(467,199,103,0),(468,202,103,0),(469,203,103,0),(470,204,103,0),(471,205,103,0),(472,201,104,0),(473,203,104,0),(474,204,104,0),(475,202,105,0),(476,204,105,0),(477,201,106,0),(478,203,106,0),(479,204,106,0),(480,202,107,0),(481,204,107,0),(482,200,108,0),(483,202,108,0),(484,203,108,0),(485,204,108,0),(486,205,108,0),(487,198,109,0),(488,203,109,0),(489,205,109,0),(490,199,110,0),(491,202,110,0),(492,205,110,0),(493,198,111,0),(494,205,111,0),(495,198,112,0),(496,205,112,0),(497,213,113,0),(498,229,113,0),(499,230,113,0),(500,231,113,0),(501,232,113,0),(502,233,113,0),(503,207,114,0),(504,209,114,0),(505,222,114,0),(506,223,114,0),(507,239,115,0),(508,241,115,0),(509,242,115,0),(510,243,115,0),(511,212,116,0),(512,234,116,0),(513,235,116,0),(514,236,116,0),(515,237,116,0),(516,238,116,0),(517,218,117,0),(518,212,118,0),(519,234,118,0),(520,235,118,0),(521,236,118,0),(522,237,118,0),(523,238,118,0),(524,207,119,0),(525,219,119,0),(526,220,119,0),(527,221,119,0),(528,222,119,0),(529,223,119,0),(530,250,120,0),(531,251,120,0),(532,252,120,0),(533,253,120,0),(534,254,120,0),(535,260,120,0),(536,264,120,0),(537,268,120,0),(538,271,120,0),(539,273,120,0),(540,275,120,0),(541,277,120,0),(542,278,120,0),(543,279,120,0),(544,250,121,0),(545,251,121,0),(546,252,121,0),(547,253,121,0),(548,254,121,0),(549,256,121,0),(550,257,121,0),(551,258,121,0),(552,260,121,0),(553,261,121,0),(554,263,121,0),(555,265,121,0),(556,267,121,0),(557,268,121,0),(558,270,121,0),(559,271,121,0),(560,273,121,0),(561,275,121,0),(562,277,121,0),(563,278,121,0),(564,250,122,0),(565,251,122,0),(566,252,122,0),(567,253,122,0),(568,254,122,0),(569,255,122,0),(570,256,122,0),(571,257,122,0),(572,258,122,0),(573,260,122,0),(574,261,122,0),(575,264,122,0),(576,265,122,0),(577,268,122,0),(578,269,122,0),(579,271,122,0),(580,272,122,0),(581,274,122,0),(582,275,122,0),(583,276,122,0),(584,278,122,0),(585,279,122,0),(586,250,123,0),(587,251,123,0),(588,252,123,0),(589,253,123,0),(590,254,123,0),(591,255,123,0),(592,256,123,0),(593,257,123,0),(594,259,123,0),(595,260,123,0),(596,264,123,0),(597,265,123,0),(598,266,123,0),(599,268,123,0),(600,270,123,0),(601,272,123,0),(602,273,123,0),(603,274,123,0),(604,275,123,0),(605,276,123,0),(606,277,123,0),(607,278,123,0),(608,250,124,0),(609,251,124,0),(610,252,124,0),(611,253,124,0),(612,254,124,0),(613,255,124,0),(615,263,124,0),(616,268,124,0),(617,272,124,0),(618,275,124,0),(619,277,124,0),(620,278,124,0),(621,250,125,0),(622,251,125,0),(624,253,125,0),(625,254,125,0),(626,255,125,0),(627,256,125,0),(628,257,125,0),(629,258,125,0),(631,260,125,0),(632,261,125,0),(633,262,125,0),(635,264,125,0),(636,266,125,0),(637,267,125,0),(638,269,125,0),(639,270,125,0),(640,271,125,0),(641,272,125,0),(642,274,125,0),(643,275,125,0),(644,277,125,0),(645,278,125,0),(646,250,126,0),(647,251,126,0),(649,253,126,0),(650,254,126,0),(651,255,126,0),(652,256,126,0),(653,258,126,0),(655,261,126,0),(656,262,126,0),(658,264,126,0),(659,266,126,0),(660,267,126,0),(661,269,126,0),(662,270,126,0),(663,271,126,0),(664,272,126,0),(665,273,126,0),(666,274,126,0),(667,275,126,0),(668,277,126,0),(669,279,126,0),(670,250,127,0),(671,251,127,0),(673,253,127,0),(674,254,127,0),(675,256,127,0),(676,257,127,0),(677,258,127,0),(679,260,127,0),(680,261,127,0),(682,265,127,0),(683,266,127,0),(684,267,127,0),(685,268,127,0),(686,269,127,0),(687,271,127,0),(688,272,127,0),(689,273,127,0),(690,275,127,0),(691,276,127,0),(692,277,127,0),(693,278,127,0),(694,279,127,0),(695,250,128,0),(696,251,128,0),(697,252,128,0),(698,253,128,0),(699,254,128,0),(700,260,128,0),(701,263,128,0),(702,272,128,0),(703,275,128,0),(704,278,128,0),(705,250,129,0),(706,251,129,0),(707,252,129,0),(708,253,129,0),(709,254,129,0),(710,255,129,0),(711,257,129,0),(712,258,129,0),(713,260,129,0),(714,261,129,0),(715,264,129,0),(716,266,129,0),(717,268,129,0),(718,269,129,0),(719,270,129,0),(720,271,129,0),(721,272,129,0),(722,274,129,0),(723,275,129,0),(724,276,129,0),(725,278,129,0),(726,279,129,0),(727,250,130,0),(728,251,130,0),(730,253,130,0),(731,254,130,0),(732,275,130,0),(733,250,131,0),(734,251,131,0),(735,252,131,0),(736,253,131,0),(737,254,131,0),(738,275,131,0),(739,259,120,0),(740,259,121,0),(741,259,128,0),(742,259,129,0),(743,263,120,0),(744,263,122,0),(745,263,123,0),(746,263,129,0),(747,263,131,0),(748,280,132,0),(749,282,132,0),(750,280,133,0),(751,282,133,0),(752,280,134,0),(753,282,134,0),(754,280,135,0),(755,283,135,0),(756,280,136,0),(757,283,136,0),(758,280,137,0),(759,282,137,0),(760,280,138,0),(761,282,138,0),(762,280,139,0),(763,283,139,0),(764,286,140,0),(765,286,141,0),(766,286,142,0),(767,286,143,0),(768,286,144,0),(769,286,145,0),(770,286,146,0),(771,286,147,0),(772,286,148,0),(773,286,149,0),(774,286,150,0),(775,286,151,0),(776,286,152,0),(777,286,153,0),(778,286,154,0),(779,286,155,0),(780,286,156,0),(781,286,157,0),(782,286,158,0),(783,286,159,0),(784,286,160,0),(785,286,161,0),(786,286,162,0),(787,286,163,0),(788,286,164,0),(789,286,165,0),(790,286,166,0),(791,286,167,0),(792,286,168,0),(793,286,169,0),(794,286,170,0),(795,286,171,0),(796,286,172,0),(797,286,173,0),(798,286,174,0),(799,286,175,0),(800,286,176,0),(801,286,177,0),(802,286,178,0),(803,286,179,0),(804,286,180,0),(805,286,181,0),(806,286,182,0),(807,286,183,0),(808,286,184,0),(809,286,185,0),(810,286,186,0),(811,286,187,0),(812,287,188,0),(813,288,189,0),(814,288,190,0),(815,288,191,0),(816,288,192,0),(817,288,193,0),(818,288,194,0),(819,288,195,0),(820,288,196,0),(821,288,197,0),(822,288,198,0),(823,288,199,0),(824,288,200,0),(825,291,201,0),(826,291,202,0),(827,291,203,0),(828,291,204,0),(829,291,205,0),(830,291,206,0),(831,291,207,0),(832,291,208,0),(833,290,209,0),(834,290,210,0),(835,290,211,0),(836,290,212,0),(837,290,213,0),(838,290,214,0),(839,290,215,0),(840,290,216,0),(841,292,217,0),(842,292,218,0),(843,292,219,0),(844,292,220,0),(845,292,221,0),(846,292,222,0),(847,292,223,0),(848,292,224,0),(849,293,225,0),(850,293,226,0),(851,293,227,0),(852,293,228,0),(853,293,229,0),(854,293,230,0),(855,293,231,0),(856,293,232,0),(857,294,233,0),(858,294,234,0),(859,294,235,0),(860,294,236,0),(861,294,237,0),(862,294,238,0),(863,294,239,0),(864,294,240,0),(865,294,241,0),(866,295,242,0),(867,295,243,0),(868,295,244,0),(871,295,246,0),(872,295,247,0),(873,295,248,0),(874,295,249,0),(875,295,250,0),(876,295,251,0),(877,295,252,0),(878,295,253,0),(879,295,254,0),(880,295,255,0),(881,295,256,0),(882,296,256,0),(883,297,256,0),(884,298,256,0),(885,299,256,0),(886,295,257,0),(887,296,257,0),(888,297,257,0),(889,298,257,0),(890,299,257,0),(891,295,258,0),(892,296,258,0),(893,297,258,0),(894,298,258,0),(895,299,258,0),(896,293,255,0),(897,296,255,0),(898,297,255,0),(899,298,255,0),(900,296,251,0),(901,299,251,0),(902,297,246,0),(904,293,259,0),(905,293,260,0),(906,293,261,0),(907,293,262,0),(908,293,263,0);
/*!40000 ALTER TABLE `catalog_category_product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index`
--

DROP TABLE IF EXISTS `catalog_category_product_index`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category ID',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `CAT_CTGR_PRD_IDX_PRD_ID_STORE_ID_CTGR_ID_VISIBILITY` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `CAT_CTGR_PRD_IDX_STORE_ID_CTGR_ID_VISIBILITY_IS_PARENT_POSITION` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Product Index';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index`
--

LOCK TABLES `catalog_category_product_index` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_category_product_index` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index_replica`
--

DROP TABLE IF EXISTS `catalog_category_product_index_replica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_replica` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category ID',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `CAT_CTGR_PRD_IDX_PRD_ID_STORE_ID_CTGR_ID_VISIBILITY` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `CAT_CTGR_PRD_IDX_STORE_ID_CTGR_ID_VISIBILITY_IS_PARENT_POSITION` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Product Index';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index_replica`
--

LOCK TABLES `catalog_category_product_index_replica` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index_replica` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_category_product_index_replica` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index_store1`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store1`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store1` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `CAT_CTGR_PRD_IDX_STORE1_PRD_ID_STORE_ID_CTGR_ID_VISIBILITY` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_216E521C8AD125E066D2B0BAB4A08412` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Product Index Store1';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index_store1`
--

LOCK TABLES `catalog_category_product_index_store1` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index_store1` DISABLE KEYS */;
INSERT INTO `catalog_category_product_index_store1` VALUES (2,1,0,1,1,4),(2,2,0,1,1,4),(2,3,0,1,1,4),(2,4,0,1,1,4),(2,5,0,1,1,4),(2,6,0,1,1,4),(2,7,0,1,1,4),(2,8,0,1,1,4),(2,9,0,1,1,4),(2,10,0,1,1,4),(2,11,0,1,1,4),(2,12,0,1,1,4),(2,13,0,1,1,4),(2,14,0,1,1,4),(2,15,0,1,1,4),(2,16,0,1,1,4),(2,17,0,1,1,4),(2,18,0,1,1,4),(2,19,0,1,1,4),(2,20,0,1,1,4),(2,21,0,1,1,4),(2,22,0,1,1,4),(2,23,0,1,1,4),(2,24,0,1,1,4),(2,25,0,1,1,4),(2,26,0,1,1,4),(2,27,0,1,1,4),(2,28,0,1,1,4),(2,29,0,1,1,4),(2,30,0,1,1,4),(2,31,0,1,1,4),(2,32,0,1,1,4),(2,33,0,1,1,4),(2,34,0,1,1,4),(2,35,0,1,1,4),(2,36,0,1,1,4),(2,37,0,1,1,4),(2,38,0,1,1,4),(2,39,0,1,1,4),(2,40,0,1,1,4),(2,41,0,1,1,4),(2,42,0,1,1,4),(2,43,0,1,1,4),(2,44,0,1,1,4),(2,45,0,1,1,4),(2,46,0,1,1,4),(2,47,0,1,1,4),(2,48,0,1,1,4),(2,49,0,1,1,4),(2,50,0,1,1,4),(2,57,0,1,1,4),(2,58,0,1,1,4),(2,59,0,1,1,4),(2,60,0,1,1,4),(2,61,0,1,1,4),(2,62,0,1,1,4),(2,63,0,1,1,4),(2,64,0,1,1,4),(2,65,0,1,1,4),(2,66,0,1,1,4),(2,68,0,1,1,4),(2,69,0,1,1,4),(2,70,0,1,1,4),(2,71,0,1,1,4),(2,72,0,1,1,4),(2,73,0,1,1,4),(2,74,0,1,1,4),(2,75,0,1,1,4),(2,76,0,1,1,4),(2,77,0,1,1,4),(2,78,0,1,1,4),(2,79,0,1,1,4),(2,80,0,1,1,4),(2,81,0,1,1,4),(2,82,0,1,1,4),(2,83,0,1,1,4),(2,84,0,1,1,4),(2,85,0,1,1,4),(2,86,0,1,1,4),(2,87,0,1,1,4),(2,88,0,1,1,4),(2,89,0,1,1,4),(2,90,0,1,1,4),(2,91,0,1,1,4),(2,92,0,1,1,4),(2,93,0,1,1,4),(2,94,0,1,1,4),(2,95,0,1,1,4),(2,96,0,1,1,4),(2,97,0,1,1,4),(2,98,0,1,1,4),(2,99,0,1,1,4),(2,100,0,1,1,4),(2,101,0,1,1,4),(2,102,0,1,1,4),(2,103,0,1,1,4),(2,104,0,1,1,4),(2,105,0,1,1,4),(2,106,0,1,1,4),(2,107,0,1,1,4),(2,108,0,1,1,4),(2,109,0,1,1,4),(2,110,0,1,1,4),(2,111,0,1,1,4),(2,112,0,1,1,4),(2,113,0,1,1,4),(2,114,0,1,1,4),(2,115,0,1,1,4),(2,116,0,1,1,4),(2,117,0,1,1,4),(2,118,0,1,1,4),(2,119,0,1,1,4),(2,120,0,1,1,4),(2,121,0,1,1,4),(2,122,0,1,1,4),(2,123,0,1,1,4),(2,124,0,1,1,4),(2,125,0,1,1,4),(2,126,0,1,1,4),(2,127,0,1,1,4),(2,128,0,1,1,4),(2,129,0,1,1,4),(2,130,0,1,1,4),(2,131,0,1,1,4),(2,132,0,1,1,4),(2,133,0,1,1,4),(2,134,0,1,1,4),(2,135,0,1,1,4),(2,136,0,1,1,4),(2,137,0,1,1,4),(2,138,0,1,1,4),(2,139,0,1,1,4),(2,140,0,1,1,4),(2,141,0,1,1,4),(2,142,0,1,1,4),(2,143,0,1,1,4),(2,144,0,1,1,4),(2,145,0,1,1,4),(2,146,0,1,1,4),(2,147,0,1,1,4),(2,148,0,1,1,4),(2,149,0,1,1,4),(2,150,0,1,1,4),(2,151,0,1,1,4),(2,152,0,1,1,4),(2,153,0,1,1,4),(2,154,0,1,1,4),(2,155,0,1,1,4),(2,156,0,1,1,4),(2,157,0,1,1,4),(2,158,0,1,1,4),(2,159,0,1,1,4),(2,160,0,1,1,4),(2,161,0,1,1,4),(2,162,0,1,1,4),(2,163,0,1,1,4),(2,164,0,1,1,4),(2,165,0,1,1,4),(2,166,0,1,1,4),(2,167,0,1,1,4),(2,168,0,1,1,4),(2,169,0,1,1,4),(2,170,0,1,1,4),(2,171,0,1,1,4),(2,172,0,1,1,4),(2,173,0,1,1,4),(2,174,0,1,1,4),(2,175,0,1,1,4),(2,176,0,1,1,4),(2,177,0,1,1,4),(2,178,0,1,1,4),(2,179,0,1,1,4),(2,180,0,1,1,4),(2,181,0,1,1,4),(2,182,0,1,1,4),(2,183,0,1,1,4),(2,184,0,1,1,4),(2,185,0,1,1,4),(2,186,0,1,1,4),(2,187,0,1,1,4),(2,188,0,1,1,4),(2,189,0,1,1,4),(2,190,0,1,1,4),(2,191,0,1,1,4),(2,192,0,1,1,4),(2,193,0,1,1,4),(2,194,0,1,1,4),(2,195,0,1,1,4),(2,196,0,1,1,4),(2,197,0,1,1,4),(2,198,0,1,1,4),(2,199,0,1,1,4),(2,200,0,1,1,4),(2,201,0,1,1,4),(2,202,0,1,1,4),(2,203,0,1,1,4),(2,204,0,1,1,4),(2,205,0,1,1,4),(2,206,0,1,1,4),(2,207,0,1,1,4),(2,208,0,1,1,4),(2,209,0,1,1,4),(2,210,0,1,1,4),(2,211,0,1,1,4),(2,212,0,1,1,4),(2,213,0,1,1,4),(2,214,0,1,1,4),(2,215,0,1,1,4),(2,216,0,1,1,4),(2,217,0,1,1,4),(2,218,0,1,1,4),(2,219,0,1,1,4),(2,220,0,1,1,4),(2,221,0,1,1,4),(2,222,0,1,1,4),(2,223,0,1,1,4),(2,224,0,1,1,4),(2,225,0,1,1,4),(2,226,0,1,1,4),(2,227,0,1,1,4),(2,228,0,1,1,4),(2,229,0,1,1,4),(2,230,0,1,1,4),(2,231,0,1,1,4),(2,232,0,1,1,4),(2,233,0,1,1,4),(2,234,0,1,1,4),(2,235,0,1,1,4),(2,236,0,1,1,4),(2,237,0,1,1,4),(2,238,0,1,1,4),(2,239,0,1,1,4),(2,240,0,1,1,4),(2,241,0,1,1,4),(2,244,0,1,1,4),(2,246,0,1,1,4),(2,251,0,1,1,4),(2,255,0,1,1,4),(2,258,0,1,1,4),(2,259,0,1,1,4),(2,260,0,1,1,4),(2,261,0,1,1,4),(2,262,0,1,1,4),(2,263,0,1,1,4),(3,1,0,1,1,4),(3,2,0,1,1,4),(3,3,0,1,1,4),(3,4,0,1,1,4),(3,5,0,1,1,4),(3,6,0,1,1,4),(3,7,0,1,1,4),(3,8,0,1,1,4),(3,10,0,1,1,4),(3,11,0,1,1,4),(4,12,0,1,1,4),(4,13,0,1,1,4),(4,14,0,1,1,4),(4,15,0,1,1,4),(4,16,0,1,1,4),(4,17,0,1,1,4),(4,18,0,1,1,4),(4,19,0,1,1,4),(4,36,0,1,1,4),(4,37,0,1,1,4),(4,38,0,1,1,4),(4,39,0,1,1,4),(4,40,0,1,1,4),(5,95,10000,0,1,4),(5,96,10000,0,1,4),(5,97,10000,0,1,4),(5,98,10000,0,1,4),(5,99,10000,0,1,4),(5,100,10000,0,1,4),(7,101,10000,0,1,4),(7,102,10000,0,1,4),(7,103,10000,0,1,4),(7,104,10000,0,1,4),(7,105,10000,0,1,4),(7,106,10000,0,1,4),(7,107,10000,0,1,4),(7,108,10000,0,1,4),(7,109,10000,0,1,4),(7,110,10000,0,1,4),(7,111,10000,0,1,4),(7,112,10000,0,1,4),(7,21,0,1,1,4),(7,22,0,1,1,4),(7,26,0,1,1,4),(8,61,0,1,1,4),(8,62,0,1,1,4),(8,63,0,1,1,4),(8,64,0,1,1,4),(8,65,0,1,1,4),(8,66,0,1,1,4),(11,4,10000,0,1,4),(11,89,10000,0,1,4),(11,90,10000,0,1,4),(11,91,10000,0,1,4),(11,92,10000,0,1,4),(11,93,10000,0,1,4),(11,94,10000,0,1,4),(11,28,0,1,1,4),(11,29,0,1,1,4),(11,30,0,1,1,4),(11,31,0,1,1,4),(11,32,0,1,1,4),(11,33,0,1,1,4),(11,34,0,1,1,4),(11,35,0,1,1,4),(13,21,0,1,1,4),(13,24,0,1,1,4),(13,25,0,1,1,4),(13,26,0,1,1,4),(13,27,0,1,1,4),(13,41,0,1,1,4),(13,42,0,1,1,4),(13,43,0,1,1,4),(13,44,0,1,1,4),(13,45,0,1,1,4),(13,46,0,1,1,4),(13,47,0,1,1,4),(13,48,0,1,1,4),(13,49,0,1,1,4),(15,22,10000,0,1,4),(15,23,10000,0,1,4),(16,20,0,1,1,4),(16,21,0,1,1,4),(16,22,0,1,1,4),(16,23,0,1,1,4),(16,24,0,1,1,4),(16,25,0,1,1,4),(16,26,0,1,1,4),(16,27,0,1,1,4),(16,41,0,1,1,4),(16,68,0,1,1,4),(16,69,0,1,1,4),(16,70,0,1,1,4),(16,71,0,1,1,4),(16,72,0,1,1,4),(16,73,0,1,1,4),(19,6,0,1,1,4),(19,7,0,1,1,4),(19,8,0,1,1,4),(19,10,0,1,1,4),(19,11,0,1,1,4),(27,11,0,1,1,4),(29,6,0,1,1,4),(29,8,0,1,1,4),(29,10,0,1,1,4),(30,6,0,1,1,4),(30,10,0,1,1,4),(33,7,0,1,1,4),(33,8,0,1,1,4),(33,10,0,1,1,4),(33,11,0,1,1,4),(42,7,0,1,1,4),(42,8,0,1,1,4),(42,11,0,1,1,4),(78,21,0,1,1,4),(78,26,0,1,1,4),(80,21,0,1,1,4),(80,22,0,1,1,4),(80,26,0,1,1,4),(81,26,0,1,1,4),(82,26,0,1,1,4),(83,26,0,1,1,4),(96,26,0,1,1,4),(97,26,0,1,1,4),(98,21,0,1,1,4),(98,22,0,1,1,4),(98,26,0,1,1,4),(99,18,0,1,1,4),(101,14,0,1,1,4),(101,15,0,1,1,4),(101,16,0,1,1,4),(102,12,0,1,1,4),(102,13,0,1,1,4),(102,14,0,1,1,4),(102,15,0,1,1,4),(102,16,0,1,1,4),(102,17,0,1,1,4),(102,19,0,1,1,4),(102,36,0,1,1,4),(102,37,0,1,1,4),(102,38,0,1,1,4),(102,39,0,1,1,4),(102,40,0,1,1,4),(103,18,0,1,1,4),(104,18,0,1,1,4),(105,18,0,1,1,4),(106,18,0,1,1,4),(107,18,0,1,1,4),(134,23,0,1,1,4),(135,22,0,1,1,4),(137,4,0,1,1,4),(137,28,0,1,1,4),(137,31,0,1,1,4),(137,34,0,1,1,4),(137,35,0,1,1,4),(138,28,0,1,1,4),(138,30,0,1,1,4),(138,32,0,1,1,4),(138,33,0,1,1,4),(139,28,0,1,1,4),(139,30,0,1,1,4),(139,32,0,1,1,4),(139,33,0,1,1,4),(140,28,0,1,1,4),(140,30,0,1,1,4),(140,32,0,1,1,4),(140,33,0,1,1,4),(145,1,0,1,1,4),(145,2,0,1,1,4),(145,3,0,1,1,4),(145,4,0,1,1,4),(145,5,0,1,1,4),(145,6,0,1,1,4),(145,7,0,1,1,4),(145,8,0,1,1,4),(145,9,0,1,1,4),(145,10,0,1,1,4),(145,11,0,1,1,4),(145,12,0,1,1,4),(145,13,0,1,1,4),(145,14,0,1,1,4),(145,15,0,1,1,4),(145,16,0,1,1,4),(145,17,0,1,1,4),(145,18,0,1,1,4),(145,19,0,1,1,4),(145,20,0,1,1,4),(145,21,0,1,1,4),(145,22,0,1,1,4),(145,23,0,1,1,4),(145,24,0,1,1,4),(145,25,0,1,1,4),(145,26,0,1,1,4),(145,27,0,1,1,4),(145,28,0,1,1,4),(145,29,0,1,1,4),(145,30,0,1,1,4),(145,31,0,1,1,4),(145,32,0,1,1,4),(145,33,0,1,1,4),(145,34,0,1,1,4),(145,35,0,1,1,4),(145,36,0,1,1,4),(145,37,0,1,1,4),(145,38,0,1,1,4),(145,39,0,1,1,4),(145,40,0,1,1,4),(145,41,0,1,1,4),(145,42,0,1,1,4),(145,43,0,1,1,4),(149,41,0,1,1,4),(150,50,0,1,1,4),(150,57,0,1,1,4),(150,58,0,1,1,4),(150,59,0,1,1,4),(150,60,0,1,1,4),(151,61,0,1,1,4),(151,62,0,1,1,4),(151,63,0,1,1,4),(151,64,0,1,1,4),(151,65,0,1,1,4),(151,66,0,1,1,4),(152,61,0,1,1,4),(152,63,0,1,1,4),(153,61,0,1,1,4),(153,63,0,1,1,4),(153,64,0,1,1,4),(153,65,0,1,1,4),(153,66,0,1,1,4),(154,61,0,1,1,4),(154,62,0,1,1,4),(154,64,0,1,1,4),(154,66,0,1,1,4),(155,61,0,1,1,4),(155,62,0,1,1,4),(155,64,0,1,1,4),(155,65,0,1,1,4),(155,66,0,1,1,4),(156,61,0,1,1,4),(156,62,0,1,1,4),(156,63,0,1,1,4),(156,64,0,1,1,4),(156,65,0,1,1,4),(156,66,0,1,1,4),(157,61,0,1,1,4),(157,62,0,1,1,4),(157,64,0,1,1,4),(157,65,0,1,1,4),(157,66,0,1,1,4),(158,61,0,1,1,4),(158,63,0,1,1,4),(158,64,0,1,1,4),(158,65,0,1,1,4),(158,66,0,1,1,4),(159,61,0,1,1,4),(159,62,0,1,1,4),(159,63,0,1,1,4),(159,64,0,1,1,4),(159,65,0,1,1,4),(159,66,0,1,1,4),(160,41,0,1,1,4),(160,68,0,1,1,4),(160,69,0,1,1,4),(160,70,0,1,1,4),(160,72,0,1,1,4),(160,73,0,1,1,4),(161,68,0,1,1,4),(161,69,0,1,1,4),(161,70,0,1,1,4),(161,71,0,1,1,4),(161,72,0,1,1,4),(162,68,0,1,1,4),(162,69,0,1,1,4),(162,72,0,1,1,4),(164,41,0,1,1,4),(164,70,0,1,1,4),(164,73,0,1,1,4),(166,41,0,1,1,4),(166,70,0,1,1,4),(166,73,0,1,1,4),(167,68,0,1,1,4),(167,69,0,1,1,4),(167,72,0,1,1,4),(168,71,0,1,1,4),(169,70,0,1,1,4),(171,70,0,1,1,4),(172,1,10000,0,1,4),(172,2,10000,0,1,4),(172,3,10000,0,1,4),(172,4,10000,0,1,4),(172,5,10000,0,1,4),(172,6,10000,0,1,4),(172,7,10000,0,1,4),(172,8,10000,0,1,4),(172,9,10000,0,1,4),(172,10,10000,0,1,4),(172,11,10000,0,1,4),(172,12,10000,0,1,4),(172,13,10000,0,1,4),(172,14,10000,0,1,4),(172,15,10000,0,1,4),(172,16,10000,0,1,4),(172,17,10000,0,1,4),(172,18,10000,0,1,4),(172,19,10000,0,1,4),(172,20,10000,0,1,4),(172,21,10000,0,1,4),(172,22,10000,0,1,4),(172,23,10000,0,1,4),(172,24,10000,0,1,4),(172,25,10000,0,1,4),(172,26,10000,0,1,4),(172,27,10000,0,1,4),(172,28,10000,0,1,4),(172,29,10000,0,1,4),(172,30,10000,0,1,4),(173,1,0,1,1,4),(173,2,0,1,1,4),(173,3,0,1,1,4),(173,4,0,1,1,4),(173,5,0,1,1,4),(173,6,0,1,1,4),(173,7,0,1,1,4),(173,8,0,1,1,4),(173,9,0,1,1,4),(173,10,0,1,1,4),(173,11,0,1,1,4),(173,12,0,1,1,4),(173,13,0,1,1,4),(173,14,0,1,1,4),(173,15,0,1,1,4),(173,16,0,1,1,4),(173,17,0,1,1,4),(173,18,0,1,1,4),(173,19,0,1,1,4),(173,20,0,1,1,4),(173,21,0,1,1,4),(173,22,0,1,1,4),(173,23,0,1,1,4),(173,24,0,1,1,4),(173,25,0,1,1,4),(173,26,0,1,1,4),(173,27,0,1,1,4),(173,28,0,1,1,4),(173,29,0,1,1,4),(173,30,0,1,1,4),(174,1,0,1,1,4),(174,2,0,1,1,4),(174,3,0,1,1,4),(174,4,0,1,1,4),(174,5,0,1,1,4),(174,6,0,1,1,4),(174,7,0,1,1,4),(174,8,0,1,1,4),(174,9,0,1,1,4),(174,10,0,1,1,4),(174,11,0,1,1,4),(174,12,0,1,1,4),(174,13,0,1,1,4),(174,14,0,1,1,4),(174,15,0,1,1,4),(174,16,0,1,1,4),(174,17,0,1,1,4),(174,18,0,1,1,4),(174,19,0,1,1,4),(174,20,0,1,1,4),(174,21,0,1,1,4),(174,22,0,1,1,4),(174,23,0,1,1,4),(174,24,0,1,1,4),(174,25,0,1,1,4),(174,26,0,1,1,4),(174,27,0,1,1,4),(174,28,0,1,1,4),(174,29,0,1,1,4),(174,30,0,1,1,4),(175,1,0,1,1,4),(175,2,0,1,1,4),(175,3,0,1,1,4),(175,4,0,1,1,4),(175,5,0,1,1,4),(175,6,0,1,1,4),(175,7,0,1,1,4),(175,8,0,1,1,4),(175,9,0,1,1,4),(175,10,0,1,1,4),(175,11,0,1,1,4),(175,12,0,1,1,4),(175,13,0,1,1,4),(175,14,0,1,1,4),(175,15,0,1,1,4),(175,16,0,1,1,4),(175,17,0,1,1,4),(175,18,0,1,1,4),(175,19,0,1,1,4),(175,20,0,1,1,4),(175,21,0,1,1,4),(175,22,0,1,1,4),(175,23,0,1,1,4),(175,24,0,1,1,4),(175,25,0,1,1,4),(175,26,0,1,1,4),(175,27,0,1,1,4),(175,28,0,1,1,4),(175,29,0,1,1,4),(175,30,0,1,1,4),(176,1,0,1,1,4),(176,2,0,1,1,4),(176,3,0,1,1,4),(176,4,0,1,1,4),(176,5,0,1,1,4),(176,6,0,1,1,4),(176,7,0,1,1,4),(176,8,0,1,1,4),(176,9,0,1,1,4),(176,10,0,1,1,4),(176,11,0,1,1,4),(176,12,0,1,1,4),(176,13,0,1,1,4),(176,14,0,1,1,4),(176,15,0,1,1,4),(176,16,0,1,1,4),(176,17,0,1,1,4),(176,18,0,1,1,4),(176,19,0,1,1,4),(176,20,0,1,1,4),(176,21,0,1,1,4),(176,22,0,1,1,4),(176,23,0,1,1,4),(176,24,0,1,1,4),(176,25,0,1,1,4),(176,26,0,1,1,4),(176,27,0,1,1,4),(176,28,0,1,1,4),(176,29,0,1,1,4),(176,30,0,1,1,4),(177,74,0,1,1,4),(177,75,0,1,1,4),(177,76,0,1,1,4),(177,77,0,1,1,4),(177,78,0,1,1,4),(177,79,0,1,1,4),(177,80,0,1,1,4),(178,74,10000,0,1,4),(178,75,10000,0,1,4),(178,76,10000,0,1,4),(178,77,10000,0,1,4),(178,78,10000,0,1,4),(178,79,10000,0,1,4),(178,80,10000,0,1,4),(178,81,10000,0,1,4),(178,82,10000,0,1,4),(178,83,10000,0,1,4),(178,84,10000,0,1,4),(178,85,10000,0,1,4),(178,86,10000,0,1,4),(178,87,10000,0,1,4),(178,88,10000,0,1,4),(178,113,10000,0,1,4),(178,114,10000,0,1,4),(178,115,10000,0,1,4),(178,116,10000,0,1,4),(178,117,10000,0,1,4),(178,118,10000,0,1,4),(178,119,10000,0,1,4),(178,120,10000,0,1,4),(178,121,10000,0,1,4),(178,122,10000,0,1,4),(178,123,10000,0,1,4),(178,124,10000,0,1,4),(178,125,10000,0,1,4),(178,126,10000,0,1,4),(178,127,10000,0,1,4),(178,128,10000,0,1,4),(178,129,10000,0,1,4),(178,130,10000,0,1,4),(178,131,10000,0,1,4),(178,132,10000,0,1,4),(178,133,10000,0,1,4),(178,134,10000,0,1,4),(178,135,10000,0,1,4),(178,136,10000,0,1,4),(178,137,10000,0,1,4),(178,138,10000,0,1,4),(178,139,10000,0,1,4),(178,140,10000,0,1,4),(178,141,10000,0,1,4),(178,142,10000,0,1,4),(178,143,10000,0,1,4),(178,144,10000,0,1,4),(178,145,10000,0,1,4),(178,146,10000,0,1,4),(178,147,10000,0,1,4),(178,148,10000,0,1,4),(178,149,10000,0,1,4),(178,150,10000,0,1,4),(178,151,10000,0,1,4),(178,152,10000,0,1,4),(178,153,10000,0,1,4),(178,154,10000,0,1,4),(178,155,10000,0,1,4),(178,156,10000,0,1,4),(178,157,10000,0,1,4),(178,158,10000,0,1,4),(178,159,10000,0,1,4),(178,160,10000,0,1,4),(178,161,10000,0,1,4),(178,162,10000,0,1,4),(178,163,10000,0,1,4),(178,164,10000,0,1,4),(178,165,10000,0,1,4),(178,166,10000,0,1,4),(178,167,10000,0,1,4),(178,168,10000,0,1,4),(178,169,10000,0,1,4),(178,170,10000,0,1,4),(178,171,10000,0,1,4),(178,172,10000,0,1,4),(178,173,10000,0,1,4),(178,174,10000,0,1,4),(178,175,10000,0,1,4),(178,176,10000,0,1,4),(178,177,10000,0,1,4),(178,178,10000,0,1,4),(178,179,10000,0,1,4),(178,180,10000,0,1,4),(178,181,10000,0,1,4),(178,182,10000,0,1,4),(178,183,10000,0,1,4),(178,184,10000,0,1,4),(178,185,10000,0,1,4),(178,186,10000,0,1,4),(178,187,10000,0,1,4),(178,188,10000,0,1,4),(178,189,10000,0,1,4),(178,190,10000,0,1,4),(178,191,10000,0,1,4),(178,192,10000,0,1,4),(178,193,10000,0,1,4),(178,194,10000,0,1,4),(178,195,10000,0,1,4),(178,196,10000,0,1,4),(178,197,10000,0,1,4),(178,198,10000,0,1,4),(178,199,10000,0,1,4),(178,200,10000,0,1,4),(178,201,10000,0,1,4),(178,202,10000,0,1,4),(178,203,10000,0,1,4),(178,204,10000,0,1,4),(178,205,10000,0,1,4),(178,206,10000,0,1,4),(178,207,10000,0,1,4),(178,208,10000,0,1,4),(178,209,10000,0,1,4),(178,210,10000,0,1,4),(178,211,10000,0,1,4),(178,212,10000,0,1,4),(178,213,10000,0,1,4),(178,214,10000,0,1,4),(178,215,10000,0,1,4),(178,216,10000,0,1,4),(178,217,10000,0,1,4),(178,218,10000,0,1,4),(178,219,10000,0,1,4),(178,220,10000,0,1,4),(178,221,10000,0,1,4),(178,222,10000,0,1,4),(178,223,10000,0,1,4),(178,224,10000,0,1,4),(178,225,10000,0,1,4),(178,226,10000,0,1,4),(178,227,10000,0,1,4),(178,228,10000,0,1,4),(178,229,10000,0,1,4),(178,230,10000,0,1,4),(178,231,10000,0,1,4),(178,232,10000,0,1,4),(178,233,10000,0,1,4),(178,234,10000,0,1,4),(178,235,10000,0,1,4),(178,236,10000,0,1,4),(178,237,10000,0,1,4),(178,238,10000,0,1,4),(178,239,10000,0,1,4),(178,240,10000,0,1,4),(178,241,10000,0,1,4),(178,244,10000,0,1,4),(178,246,10000,0,1,4),(178,251,10000,0,1,4),(178,255,10000,0,1,4),(178,258,10000,0,1,4),(178,259,10000,0,1,4),(178,260,10000,0,1,4),(178,261,10000,0,1,4),(178,262,10000,0,1,4),(178,263,10000,0,1,4),(179,81,0,1,1,4),(179,82,0,1,1,4),(179,83,0,1,1,4),(179,84,0,1,1,4),(179,85,0,1,1,4),(179,86,0,1,1,4),(179,87,0,1,1,4),(179,88,0,1,1,4),(180,81,0,1,1,4),(181,86,0,1,1,4),(182,82,0,1,1,4),(182,83,0,1,1,4),(182,84,0,1,1,4),(182,85,0,1,1,4),(182,87,0,1,1,4),(182,88,0,1,1,4),(183,82,0,1,1,4),(183,83,0,1,1,4),(183,84,0,1,1,4),(183,85,0,1,1,4),(183,86,0,1,1,4),(183,87,0,1,1,4),(183,88,0,1,1,4),(192,89,0,1,1,4),(192,90,0,1,1,4),(192,91,0,1,1,4),(192,92,0,1,1,4),(192,93,0,1,1,4),(192,94,0,1,1,4),(193,95,0,1,1,4),(193,96,0,1,1,4),(193,97,0,1,1,4),(193,98,0,1,1,4),(193,99,0,1,1,4),(193,100,0,1,1,4),(194,95,0,1,1,4),(194,96,0,1,1,4),(194,97,0,1,1,4),(194,98,0,1,1,4),(194,99,0,1,1,4),(194,100,0,1,1,4),(195,95,0,1,1,4),(195,96,0,1,1,4),(195,97,0,1,1,4),(195,98,0,1,1,4),(195,99,0,1,1,4),(195,100,0,1,1,4),(196,95,0,1,1,4),(196,96,0,1,1,4),(196,97,0,1,1,4),(196,98,0,1,1,4),(196,99,0,1,1,4),(196,100,0,1,1,4),(197,95,0,1,1,4),(197,96,0,1,1,4),(197,97,0,1,1,4),(197,98,0,1,1,4),(197,99,0,1,1,4),(197,100,0,1,1,4),(198,101,0,1,1,4),(198,109,0,1,1,4),(198,111,0,1,1,4),(198,112,0,1,1,4),(199,103,0,1,1,4),(199,110,0,1,1,4),(200,101,0,1,1,4),(200,102,0,1,1,4),(200,108,0,1,1,4),(201,104,0,1,1,4),(201,106,0,1,1,4),(202,101,0,1,1,4),(202,102,0,1,1,4),(202,103,0,1,1,4),(202,105,0,1,1,4),(202,107,0,1,1,4),(202,108,0,1,1,4),(202,110,0,1,1,4),(203,101,0,1,1,4),(203,102,0,1,1,4),(203,103,0,1,1,4),(203,104,0,1,1,4),(203,106,0,1,1,4),(203,108,0,1,1,4),(203,109,0,1,1,4),(204,101,0,1,1,4),(204,102,0,1,1,4),(204,103,0,1,1,4),(204,104,0,1,1,4),(204,105,0,1,1,4),(204,106,0,1,1,4),(204,107,0,1,1,4),(204,108,0,1,1,4),(205,101,0,1,1,4),(205,102,0,1,1,4),(205,103,0,1,1,4),(205,108,0,1,1,4),(205,109,0,1,1,4),(205,110,0,1,1,4),(205,111,0,1,1,4),(205,112,0,1,1,4),(206,113,10000,0,1,4),(206,114,10000,0,1,4),(206,115,10000,0,1,4),(206,116,10000,0,1,4),(206,117,10000,0,1,4),(206,118,10000,0,1,4),(206,119,10000,0,1,4),(207,114,0,1,1,4),(207,119,0,1,1,4),(209,114,0,1,1,4),(212,116,0,1,1,4),(212,118,0,1,1,4),(213,113,0,1,1,4),(218,117,0,1,1,4),(219,119,0,1,1,4),(220,119,0,1,1,4),(221,119,0,1,1,4),(222,114,0,1,1,4),(222,119,0,1,1,4),(223,114,0,1,1,4),(223,119,0,1,1,4),(229,113,0,1,1,4),(230,113,0,1,1,4),(231,113,0,1,1,4),(232,113,0,1,1,4),(233,113,0,1,1,4),(234,116,0,1,1,4),(234,118,0,1,1,4),(235,116,0,1,1,4),(235,118,0,1,1,4),(236,116,0,1,1,4),(236,118,0,1,1,4),(237,116,0,1,1,4),(237,118,0,1,1,4),(238,116,0,1,1,4),(238,118,0,1,1,4),(239,115,0,1,1,4),(241,115,0,1,1,4),(242,115,0,1,1,4),(243,115,0,1,1,4),(250,120,0,1,1,4),(250,121,0,1,1,4),(250,122,0,1,1,4),(250,123,0,1,1,4),(250,124,0,1,1,4),(250,125,0,1,1,4),(250,126,0,1,1,4),(250,127,0,1,1,4),(250,128,0,1,1,4),(250,129,0,1,1,4),(250,130,0,1,1,4),(250,131,0,1,1,4),(251,120,0,1,1,4),(251,121,0,1,1,4),(251,122,0,1,1,4),(251,123,0,1,1,4),(251,124,0,1,1,4),(251,125,0,1,1,4),(251,126,0,1,1,4),(251,127,0,1,1,4),(251,128,0,1,1,4),(251,129,0,1,1,4),(251,130,0,1,1,4),(251,131,0,1,1,4),(252,125,10000,0,1,4),(252,126,10000,0,1,4),(252,127,10000,0,1,4),(252,120,0,1,1,4),(252,121,0,1,1,4),(252,122,0,1,1,4),(252,123,0,1,1,4),(252,124,0,1,1,4),(252,128,0,1,1,4),(252,129,0,1,1,4),(252,131,0,1,1,4),(253,120,0,1,1,4),(253,121,0,1,1,4),(253,122,0,1,1,4),(253,123,0,1,1,4),(253,124,0,1,1,4),(253,125,0,1,1,4),(253,126,0,1,1,4),(253,127,0,1,1,4),(253,128,0,1,1,4),(253,129,0,1,1,4),(253,130,0,1,1,4),(253,131,0,1,1,4),(254,120,0,1,1,4),(254,121,0,1,1,4),(254,122,0,1,1,4),(254,123,0,1,1,4),(254,124,0,1,1,4),(254,125,0,1,1,4),(254,126,0,1,1,4),(254,127,0,1,1,4),(254,128,0,1,1,4),(254,129,0,1,1,4),(254,130,0,1,1,4),(254,131,0,1,1,4),(255,122,0,1,1,4),(255,123,0,1,1,4),(255,124,0,1,1,4),(255,125,0,1,1,4),(255,126,0,1,1,4),(255,129,0,1,1,4),(256,121,0,1,1,4),(256,122,0,1,1,4),(256,123,0,1,1,4),(256,125,0,1,1,4),(256,126,0,1,1,4),(256,127,0,1,1,4),(257,121,0,1,1,4),(257,122,0,1,1,4),(257,123,0,1,1,4),(257,125,0,1,1,4),(257,127,0,1,1,4),(257,129,0,1,1,4),(258,121,0,1,1,4),(258,122,0,1,1,4),(258,125,0,1,1,4),(258,126,0,1,1,4),(258,127,0,1,1,4),(258,129,0,1,1,4),(259,120,0,1,1,4),(259,121,0,1,1,4),(259,123,0,1,1,4),(259,128,0,1,1,4),(259,129,0,1,1,4),(260,120,0,1,1,4),(260,121,0,1,1,4),(260,122,0,1,1,4),(260,123,0,1,1,4),(260,125,0,1,1,4),(260,127,0,1,1,4),(260,128,0,1,1,4),(260,129,0,1,1,4),(261,121,0,1,1,4),(261,122,0,1,1,4),(261,125,0,1,1,4),(261,126,0,1,1,4),(261,127,0,1,1,4),(261,129,0,1,1,4),(262,125,0,1,1,4),(262,126,0,1,1,4),(263,120,0,1,1,4),(263,121,0,1,1,4),(263,122,0,1,1,4),(263,123,0,1,1,4),(263,124,0,1,1,4),(263,128,0,1,1,4),(263,129,0,1,1,4),(263,131,0,1,1,4),(264,120,0,1,1,4),(264,122,0,1,1,4),(264,123,0,1,1,4),(264,125,0,1,1,4),(264,126,0,1,1,4),(264,129,0,1,1,4),(265,121,0,1,1,4),(265,122,0,1,1,4),(265,123,0,1,1,4),(265,127,0,1,1,4),(266,123,0,1,1,4),(266,125,0,1,1,4),(266,126,0,1,1,4),(266,127,0,1,1,4),(266,129,0,1,1,4),(267,121,0,1,1,4),(267,125,0,1,1,4),(267,126,0,1,1,4),(267,127,0,1,1,4),(268,120,0,1,1,4),(268,121,0,1,1,4),(268,122,0,1,1,4),(268,123,0,1,1,4),(268,124,0,1,1,4),(268,127,0,1,1,4),(268,129,0,1,1,4),(269,122,0,1,1,4),(269,125,0,1,1,4),(269,126,0,1,1,4),(269,127,0,1,1,4),(269,129,0,1,1,4),(270,121,0,1,1,4),(270,123,0,1,1,4),(270,125,0,1,1,4),(270,126,0,1,1,4),(270,129,0,1,1,4),(271,120,0,1,1,4),(271,121,0,1,1,4),(271,122,0,1,1,4),(271,125,0,1,1,4),(271,126,0,1,1,4),(271,127,0,1,1,4),(271,129,0,1,1,4),(272,122,0,1,1,4),(272,123,0,1,1,4),(272,124,0,1,1,4),(272,125,0,1,1,4),(272,126,0,1,1,4),(272,127,0,1,1,4),(272,128,0,1,1,4),(272,129,0,1,1,4),(273,120,0,1,1,4),(273,121,0,1,1,4),(273,123,0,1,1,4),(273,126,0,1,1,4),(273,127,0,1,1,4),(274,122,0,1,1,4),(274,123,0,1,1,4),(274,125,0,1,1,4),(274,126,0,1,1,4),(274,129,0,1,1,4),(275,120,0,1,1,4),(275,121,0,1,1,4),(275,122,0,1,1,4),(275,123,0,1,1,4),(275,124,0,1,1,4),(275,125,0,1,1,4),(275,126,0,1,1,4),(275,127,0,1,1,4),(275,128,0,1,1,4),(275,129,0,1,1,4),(275,130,0,1,1,4),(275,131,0,1,1,4),(276,122,0,1,1,4),(276,123,0,1,1,4),(276,127,0,1,1,4),(276,129,0,1,1,4),(277,120,0,1,1,4),(277,121,0,1,1,4),(277,123,0,1,1,4),(277,124,0,1,1,4),(277,125,0,1,1,4),(277,126,0,1,1,4),(277,127,0,1,1,4),(278,120,0,1,1,4),(278,121,0,1,1,4),(278,122,0,1,1,4),(278,123,0,1,1,4),(278,124,0,1,1,4),(278,125,0,1,1,4),(278,127,0,1,1,4),(278,128,0,1,1,4),(278,129,0,1,1,4),(279,120,0,1,1,4),(279,122,0,1,1,4),(279,126,0,1,1,4),(279,127,0,1,1,4),(279,129,0,1,1,4),(280,132,0,1,1,4),(280,133,0,1,1,4),(280,134,0,1,1,4),(280,135,0,1,1,4),(280,136,0,1,1,4),(280,137,0,1,1,4),(280,138,0,1,1,4),(280,139,0,1,1,4),(282,132,0,1,1,4),(282,133,0,1,1,4),(282,134,0,1,1,4),(282,137,0,1,1,4),(282,138,0,1,1,4),(283,135,0,1,1,4),(283,136,0,1,1,4),(283,139,0,1,1,4),(286,140,0,1,1,4),(286,141,0,1,1,4),(286,142,0,1,1,4),(286,143,0,1,1,4),(286,144,0,1,1,4),(286,145,0,1,1,4),(286,146,0,1,1,4),(286,147,0,1,1,4),(286,148,0,1,1,4),(286,149,0,1,1,4),(286,150,0,1,1,4),(286,151,0,1,1,4),(286,152,0,1,1,4),(286,153,0,1,1,4),(286,154,0,1,1,4),(286,155,0,1,1,4),(286,156,0,1,1,4),(286,157,0,1,1,4),(286,158,0,1,1,4),(286,159,0,1,1,4),(286,160,0,1,1,4),(286,161,0,1,1,4),(286,162,0,1,1,4),(286,163,0,1,1,4),(286,164,0,1,1,4),(286,165,0,1,1,4),(286,166,0,1,1,4),(286,167,0,1,1,4),(286,168,0,1,1,4),(286,169,0,1,1,4),(286,170,0,1,1,4),(286,171,0,1,1,4),(286,172,0,1,1,4),(286,173,0,1,1,4),(286,174,0,1,1,4),(286,175,0,1,1,4),(286,176,0,1,1,4),(286,177,0,1,1,4),(286,178,0,1,1,4),(286,179,0,1,1,4),(286,180,0,1,1,4),(286,181,0,1,1,4),(286,182,0,1,1,4),(286,183,0,1,1,4),(286,184,0,1,1,4),(286,185,0,1,1,4),(286,186,0,1,1,4),(286,187,0,1,1,4),(287,188,0,1,1,4),(288,189,0,1,1,4),(288,190,0,1,1,4),(288,191,0,1,1,4),(288,192,0,1,1,4),(288,193,0,1,1,4),(288,194,0,1,1,4),(288,195,0,1,1,4),(288,196,0,1,1,4),(288,197,0,1,1,4),(288,198,0,1,1,4),(288,199,0,1,1,4),(288,200,0,1,1,4),(289,201,10000,0,1,4),(289,202,10000,0,1,4),(289,203,10000,0,1,4),(289,204,10000,0,1,4),(289,205,10000,0,1,4),(289,206,10000,0,1,4),(289,207,10000,0,1,4),(289,208,10000,0,1,4),(289,209,10000,0,1,4),(289,210,10000,0,1,4),(289,211,10000,0,1,4),(289,212,10000,0,1,4),(289,213,10000,0,1,4),(289,214,10000,0,1,4),(289,215,10000,0,1,4),(289,216,10000,0,1,4),(289,217,10000,0,1,4),(289,218,10000,0,1,4),(289,219,10000,0,1,4),(289,220,10000,0,1,4),(289,221,10000,0,1,4),(289,222,10000,0,1,4),(289,223,10000,0,1,4),(289,224,10000,0,1,4),(289,225,10000,0,1,4),(289,226,10000,0,1,4),(289,227,10000,0,1,4),(289,228,10000,0,1,4),(289,229,10000,0,1,4),(289,230,10000,0,1,4),(289,231,10000,0,1,4),(289,232,10000,0,1,4),(289,244,10000,0,1,4),(289,246,10000,0,1,4),(289,251,10000,0,1,4),(289,255,10000,0,1,4),(289,258,10000,0,1,4),(289,259,10000,0,1,4),(289,260,10000,0,1,4),(289,261,10000,0,1,4),(289,262,10000,0,1,4),(289,263,10000,0,1,4),(290,209,0,1,1,4),(290,210,0,1,1,4),(290,211,0,1,1,4),(290,212,0,1,1,4),(290,213,0,1,1,4),(290,214,0,1,1,4),(290,215,0,1,1,4),(290,216,0,1,1,4),(291,201,0,1,1,4),(291,202,0,1,1,4),(291,203,0,1,1,4),(291,204,0,1,1,4),(291,205,0,1,1,4),(291,206,0,1,1,4),(291,207,0,1,1,4),(291,208,0,1,1,4),(292,217,0,1,1,4),(292,218,0,1,1,4),(292,219,0,1,1,4),(292,220,0,1,1,4),(292,221,0,1,1,4),(292,222,0,1,1,4),(292,223,0,1,1,4),(292,224,0,1,1,4),(293,225,0,1,1,4),(293,226,0,1,1,4),(293,227,0,1,1,4),(293,228,0,1,1,4),(293,229,0,1,1,4),(293,230,0,1,1,4),(293,231,0,1,1,4),(293,232,0,1,1,4),(293,255,0,1,1,4),(293,259,0,1,1,4),(293,260,0,1,1,4),(293,261,0,1,1,4),(293,262,0,1,1,4),(293,263,0,1,1,4),(294,233,0,1,1,4),(294,234,0,1,1,4),(294,235,0,1,1,4),(294,236,0,1,1,4),(294,237,0,1,1,4),(294,238,0,1,1,4),(294,239,0,1,1,4),(294,240,0,1,1,4),(294,241,0,1,1,4),(295,244,0,1,1,4),(295,246,0,1,1,4),(295,251,0,1,1,4),(295,255,0,1,1,4),(295,258,0,1,1,4),(296,251,0,1,1,4),(296,255,0,1,1,4),(296,258,0,1,1,4),(297,246,0,1,1,4),(297,255,0,1,1,4),(297,258,0,1,1,4),(298,255,0,1,1,4),(298,258,0,1,1,4),(299,251,0,1,1,4),(299,258,0,1,1,4);
/*!40000 ALTER TABLE `catalog_category_product_index_store1` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index_store10`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store10`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store10` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `IDX_BF8E9C147B9E369FA5F75474BF410B76` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_399EE76B5BD4142D9CCF0511849161E3` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Product Index Store10 Replica';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index_store10`
--

LOCK TABLES `catalog_category_product_index_store10` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index_store10` DISABLE KEYS */;
INSERT INTO `catalog_category_product_index_store10` VALUES (2,1,0,1,10,4),(2,2,0,1,10,4),(2,3,0,1,10,4),(2,4,0,1,10,4),(2,5,0,1,10,4),(2,6,0,1,10,4),(2,7,0,1,10,4),(2,8,0,1,10,4),(2,9,0,1,10,4),(2,10,0,1,10,4),(2,11,0,1,10,4),(2,12,0,1,10,4),(2,13,0,1,10,4),(2,14,0,1,10,4),(2,15,0,1,10,4),(2,16,0,1,10,4),(2,17,0,1,10,4),(2,18,0,1,10,4),(2,19,0,1,10,4),(2,20,0,1,10,4),(2,21,0,1,10,4),(2,22,0,1,10,4),(2,23,0,1,10,4),(2,24,0,1,10,4),(2,25,0,1,10,4),(2,26,0,1,10,4),(2,27,0,1,10,4),(2,28,0,1,10,4),(2,29,0,1,10,4),(2,30,0,1,10,4),(2,31,0,1,10,4),(2,32,0,1,10,4),(2,33,0,1,10,4),(2,34,0,1,10,4),(2,35,0,1,10,4),(2,36,0,1,10,4),(2,37,0,1,10,4),(2,38,0,1,10,4),(2,39,0,1,10,4),(2,40,0,1,10,4),(2,41,0,1,10,4),(2,42,0,1,10,4),(2,43,0,1,10,4),(2,44,0,1,10,4),(2,45,0,1,10,4),(2,46,0,1,10,4),(2,47,0,1,10,4),(2,48,0,1,10,4),(2,49,0,1,10,4),(2,50,0,1,10,4),(2,57,0,1,10,4),(2,58,0,1,10,4),(2,59,0,1,10,4),(2,60,0,1,10,4),(2,61,0,1,10,4),(2,62,0,1,10,4),(2,63,0,1,10,4),(2,64,0,1,10,4),(2,65,0,1,10,4),(2,66,0,1,10,4),(2,68,0,1,10,4),(2,69,0,1,10,4),(2,70,0,1,10,4),(2,71,0,1,10,4),(2,72,0,1,10,4),(2,73,0,1,10,4),(2,74,0,1,10,4),(2,75,0,1,10,4),(2,76,0,1,10,4),(2,77,0,1,10,4),(2,78,0,1,10,4),(2,79,0,1,10,4),(2,80,0,1,10,4),(2,81,0,1,10,4),(2,82,0,1,10,4),(2,83,0,1,10,4),(2,84,0,1,10,4),(2,85,0,1,10,4),(2,86,0,1,10,4),(2,87,0,1,10,4),(2,88,0,1,10,4),(2,89,0,1,10,4),(2,90,0,1,10,4),(2,91,0,1,10,4),(2,92,0,1,10,4),(2,93,0,1,10,4),(2,94,0,1,10,4),(2,95,0,1,10,4),(2,96,0,1,10,4),(2,97,0,1,10,4),(2,98,0,1,10,4),(2,99,0,1,10,4),(2,100,0,1,10,4),(2,101,0,1,10,4),(2,102,0,1,10,4),(2,103,0,1,10,4),(2,104,0,1,10,4),(2,105,0,1,10,4),(2,106,0,1,10,4),(2,107,0,1,10,4),(2,108,0,1,10,4),(2,109,0,1,10,4),(2,110,0,1,10,4),(2,111,0,1,10,4),(2,112,0,1,10,4),(2,113,0,1,10,4),(2,114,0,1,10,4),(2,115,0,1,10,4),(2,116,0,1,10,4),(2,117,0,1,10,4),(2,118,0,1,10,4),(2,119,0,1,10,4),(2,120,0,1,10,4),(2,121,0,1,10,4),(2,122,0,1,10,4),(2,123,0,1,10,4),(2,124,0,1,10,4),(2,125,0,1,10,4),(2,126,0,1,10,4),(2,127,0,1,10,4),(2,128,0,1,10,4),(2,129,0,1,10,4),(2,130,0,1,10,4),(2,131,0,1,10,4),(2,132,0,1,10,4),(2,133,0,1,10,4),(2,134,0,1,10,4),(2,135,0,1,10,4),(2,136,0,1,10,4),(2,137,0,1,10,4),(2,138,0,1,10,4),(2,139,0,1,10,4),(2,140,0,1,10,4),(2,141,0,1,10,4),(2,142,0,1,10,4),(2,143,0,1,10,4),(2,144,0,1,10,4),(2,145,0,1,10,4),(2,146,0,1,10,4),(2,147,0,1,10,4),(2,148,0,1,10,4),(2,149,0,1,10,4),(2,150,0,1,10,4),(2,151,0,1,10,4),(2,152,0,1,10,4),(2,153,0,1,10,4),(2,154,0,1,10,4),(2,155,0,1,10,4),(2,156,0,1,10,4),(2,157,0,1,10,4),(2,158,0,1,10,4),(2,159,0,1,10,4),(2,160,0,1,10,4),(2,161,0,1,10,4),(2,162,0,1,10,4),(2,163,0,1,10,4),(2,164,0,1,10,4),(2,165,0,1,10,4),(2,166,0,1,10,4),(2,167,0,1,10,4),(2,168,0,1,10,4),(2,169,0,1,10,4),(2,170,0,1,10,4),(2,171,0,1,10,4),(2,172,0,1,10,4),(2,173,0,1,10,4),(2,174,0,1,10,4),(2,175,0,1,10,4),(2,176,0,1,10,4),(2,177,0,1,10,4),(2,178,0,1,10,4),(2,179,0,1,10,4),(2,180,0,1,10,4),(2,181,0,1,10,4),(2,182,0,1,10,4),(2,183,0,1,10,4),(2,184,0,1,10,4),(2,185,0,1,10,4),(2,186,0,1,10,4),(2,187,0,1,10,4),(2,188,0,1,10,4),(2,189,0,1,10,4),(2,190,0,1,10,4),(2,191,0,1,10,4),(2,192,0,1,10,4),(2,193,0,1,10,4),(2,194,0,1,10,4),(2,195,0,1,10,4),(2,196,0,1,10,4),(2,197,0,1,10,4),(2,198,0,1,10,4),(2,199,0,1,10,4),(2,200,0,1,10,4),(2,201,0,1,10,4),(2,202,0,1,10,4),(2,203,0,1,10,4),(2,204,0,1,10,4),(2,205,0,1,10,4),(2,206,0,1,10,4),(2,207,0,1,10,4),(2,208,0,1,10,4),(2,209,0,1,10,4),(2,210,0,1,10,4),(2,211,0,1,10,4),(2,212,0,1,10,4),(2,213,0,1,10,4),(2,214,0,1,10,4),(2,215,0,1,10,4),(2,216,0,1,10,4),(2,217,0,1,10,4),(2,218,0,1,10,4),(2,219,0,1,10,4),(2,220,0,1,10,4),(2,221,0,1,10,4),(2,222,0,1,10,4),(2,223,0,1,10,4),(2,224,0,1,10,4),(2,225,0,1,10,4),(2,226,0,1,10,4),(2,227,0,1,10,4),(2,228,0,1,10,4),(2,229,0,1,10,4),(2,230,0,1,10,4),(2,231,0,1,10,4),(2,232,0,1,10,4),(2,233,0,1,10,4),(2,234,0,1,10,4),(2,235,0,1,10,4),(2,236,0,1,10,4),(2,237,0,1,10,4),(2,238,0,1,10,4),(2,239,0,1,10,4),(2,240,0,1,10,4),(2,241,0,1,10,4),(2,244,0,1,10,4),(2,246,0,1,10,4),(2,251,0,1,10,4),(2,255,0,1,10,4),(2,258,0,1,10,4),(2,259,0,1,10,4),(2,260,0,1,10,4),(2,261,0,1,10,4),(2,262,0,1,10,4),(2,263,0,1,10,4),(3,1,0,1,10,4),(3,2,0,1,10,4),(3,3,0,1,10,4),(3,4,0,1,10,4),(3,5,0,1,10,4),(3,6,0,1,10,4),(3,7,0,1,10,4),(3,8,0,1,10,4),(3,10,0,1,10,4),(3,11,0,1,10,4),(4,12,0,1,10,4),(4,13,0,1,10,4),(4,14,0,1,10,4),(4,15,0,1,10,4),(4,16,0,1,10,4),(4,17,0,1,10,4),(4,18,0,1,10,4),(4,19,0,1,10,4),(4,36,0,1,10,4),(4,37,0,1,10,4),(4,38,0,1,10,4),(4,39,0,1,10,4),(4,40,0,1,10,4),(5,95,10000,0,10,4),(5,96,10000,0,10,4),(5,97,10000,0,10,4),(5,98,10000,0,10,4),(5,99,10000,0,10,4),(5,100,10000,0,10,4),(7,101,10000,0,10,4),(7,102,10000,0,10,4),(7,103,10000,0,10,4),(7,104,10000,0,10,4),(7,105,10000,0,10,4),(7,106,10000,0,10,4),(7,107,10000,0,10,4),(7,108,10000,0,10,4),(7,109,10000,0,10,4),(7,110,10000,0,10,4),(7,111,10000,0,10,4),(7,112,10000,0,10,4),(7,21,0,1,10,4),(7,22,0,1,10,4),(7,26,0,1,10,4),(8,61,0,1,10,4),(8,62,0,1,10,4),(8,63,0,1,10,4),(8,64,0,1,10,4),(8,65,0,1,10,4),(8,66,0,1,10,4),(11,4,10000,0,10,4),(11,89,10000,0,10,4),(11,90,10000,0,10,4),(11,91,10000,0,10,4),(11,92,10000,0,10,4),(11,93,10000,0,10,4),(11,94,10000,0,10,4),(11,28,0,1,10,4),(11,29,0,1,10,4),(11,30,0,1,10,4),(11,31,0,1,10,4),(11,32,0,1,10,4),(11,33,0,1,10,4),(11,34,0,1,10,4),(11,35,0,1,10,4),(13,21,0,1,10,4),(13,24,0,1,10,4),(13,25,0,1,10,4),(13,26,0,1,10,4),(13,27,0,1,10,4),(13,41,0,1,10,4),(13,42,0,1,10,4),(13,43,0,1,10,4),(13,44,0,1,10,4),(13,45,0,1,10,4),(13,46,0,1,10,4),(13,47,0,1,10,4),(13,48,0,1,10,4),(13,49,0,1,10,4),(15,22,10000,0,10,4),(15,23,10000,0,10,4),(16,20,0,1,10,4),(16,21,0,1,10,4),(16,22,0,1,10,4),(16,23,0,1,10,4),(16,24,0,1,10,4),(16,25,0,1,10,4),(16,26,0,1,10,4),(16,27,0,1,10,4),(16,41,0,1,10,4),(16,68,0,1,10,4),(16,69,0,1,10,4),(16,70,0,1,10,4),(16,71,0,1,10,4),(16,72,0,1,10,4),(16,73,0,1,10,4),(19,6,0,1,10,4),(19,7,0,1,10,4),(19,8,0,1,10,4),(19,10,0,1,10,4),(19,11,0,1,10,4),(27,11,0,1,10,4),(29,6,0,1,10,4),(29,8,0,1,10,4),(29,10,0,1,10,4),(30,6,0,1,10,4),(30,10,0,1,10,4),(33,7,0,1,10,4),(33,8,0,1,10,4),(33,10,0,1,10,4),(33,11,0,1,10,4),(42,7,0,1,10,4),(42,8,0,1,10,4),(42,11,0,1,10,4),(78,21,0,1,10,4),(78,26,0,1,10,4),(80,21,0,1,10,4),(80,22,0,1,10,4),(80,26,0,1,10,4),(81,26,0,1,10,4),(82,26,0,1,10,4),(83,26,0,1,10,4),(96,26,0,1,10,4),(97,26,0,1,10,4),(98,21,0,1,10,4),(98,22,0,1,10,4),(98,26,0,1,10,4),(99,18,0,1,10,4),(101,14,0,1,10,4),(101,15,0,1,10,4),(101,16,0,1,10,4),(102,12,0,1,10,4),(102,13,0,1,10,4),(102,14,0,1,10,4),(102,15,0,1,10,4),(102,16,0,1,10,4),(102,17,0,1,10,4),(102,19,0,1,10,4),(102,36,0,1,10,4),(102,37,0,1,10,4),(102,38,0,1,10,4),(102,39,0,1,10,4),(102,40,0,1,10,4),(103,18,0,1,10,4),(104,18,0,1,10,4),(105,18,0,1,10,4),(106,18,0,1,10,4),(107,18,0,1,10,4),(134,23,0,1,10,4),(135,22,0,1,10,4),(137,4,0,1,10,4),(137,28,0,1,10,4),(137,31,0,1,10,4),(137,34,0,1,10,4),(137,35,0,1,10,4),(138,28,0,1,10,4),(138,30,0,1,10,4),(138,32,0,1,10,4),(138,33,0,1,10,4),(139,28,0,1,10,4),(139,30,0,1,10,4),(139,32,0,1,10,4),(139,33,0,1,10,4),(140,28,0,1,10,4),(140,30,0,1,10,4),(140,32,0,1,10,4),(140,33,0,1,10,4),(145,1,0,1,10,4),(145,2,0,1,10,4),(145,3,0,1,10,4),(145,4,0,1,10,4),(145,5,0,1,10,4),(145,6,0,1,10,4),(145,7,0,1,10,4),(145,8,0,1,10,4),(145,9,0,1,10,4),(145,10,0,1,10,4),(145,11,0,1,10,4),(145,12,0,1,10,4),(145,13,0,1,10,4),(145,14,0,1,10,4),(145,15,0,1,10,4),(145,16,0,1,10,4),(145,17,0,1,10,4),(145,18,0,1,10,4),(145,19,0,1,10,4),(145,20,0,1,10,4),(145,21,0,1,10,4),(145,22,0,1,10,4),(145,23,0,1,10,4),(145,24,0,1,10,4),(145,25,0,1,10,4),(145,26,0,1,10,4),(145,27,0,1,10,4),(145,28,0,1,10,4),(145,29,0,1,10,4),(145,30,0,1,10,4),(145,31,0,1,10,4),(145,32,0,1,10,4),(145,33,0,1,10,4),(145,34,0,1,10,4),(145,35,0,1,10,4),(145,36,0,1,10,4),(145,37,0,1,10,4),(145,38,0,1,10,4),(145,39,0,1,10,4),(145,40,0,1,10,4),(145,41,0,1,10,4),(145,42,0,1,10,4),(145,43,0,1,10,4),(149,41,0,1,10,4),(150,50,0,1,10,4),(150,57,0,1,10,4),(150,58,0,1,10,4),(150,59,0,1,10,4),(150,60,0,1,10,4),(151,61,0,1,10,4),(151,62,0,1,10,4),(151,63,0,1,10,4),(151,64,0,1,10,4),(151,65,0,1,10,4),(151,66,0,1,10,4),(152,61,0,1,10,4),(152,63,0,1,10,4),(153,61,0,1,10,4),(153,63,0,1,10,4),(153,64,0,1,10,4),(153,65,0,1,10,4),(153,66,0,1,10,4),(154,61,0,1,10,4),(154,62,0,1,10,4),(154,64,0,1,10,4),(154,66,0,1,10,4),(155,61,0,1,10,4),(155,62,0,1,10,4),(155,64,0,1,10,4),(155,65,0,1,10,4),(155,66,0,1,10,4),(156,61,0,1,10,4),(156,62,0,1,10,4),(156,63,0,1,10,4),(156,64,0,1,10,4),(156,65,0,1,10,4),(156,66,0,1,10,4),(157,61,0,1,10,4),(157,62,0,1,10,4),(157,64,0,1,10,4),(157,65,0,1,10,4),(157,66,0,1,10,4),(158,61,0,1,10,4),(158,63,0,1,10,4),(158,64,0,1,10,4),(158,65,0,1,10,4),(158,66,0,1,10,4),(159,61,0,1,10,4),(159,62,0,1,10,4),(159,63,0,1,10,4),(159,64,0,1,10,4),(159,65,0,1,10,4),(159,66,0,1,10,4),(160,41,0,1,10,4),(160,68,0,1,10,4),(160,69,0,1,10,4),(160,70,0,1,10,4),(160,72,0,1,10,4),(160,73,0,1,10,4),(161,68,0,1,10,4),(161,69,0,1,10,4),(161,70,0,1,10,4),(161,71,0,1,10,4),(161,72,0,1,10,4),(162,68,0,1,10,4),(162,69,0,1,10,4),(162,72,0,1,10,4),(164,41,0,1,10,4),(164,70,0,1,10,4),(164,73,0,1,10,4),(166,41,0,1,10,4),(166,70,0,1,10,4),(166,73,0,1,10,4),(167,68,0,1,10,4),(167,69,0,1,10,4),(167,72,0,1,10,4),(168,71,0,1,10,4),(169,70,0,1,10,4),(171,70,0,1,10,4),(172,1,10000,0,10,4),(172,2,10000,0,10,4),(172,3,10000,0,10,4),(172,4,10000,0,10,4),(172,5,10000,0,10,4),(172,6,10000,0,10,4),(172,7,10000,0,10,4),(172,8,10000,0,10,4),(172,9,10000,0,10,4),(172,10,10000,0,10,4),(172,11,10000,0,10,4),(172,12,10000,0,10,4),(172,13,10000,0,10,4),(172,14,10000,0,10,4),(172,15,10000,0,10,4),(172,16,10000,0,10,4),(172,17,10000,0,10,4),(172,18,10000,0,10,4),(172,19,10000,0,10,4),(172,20,10000,0,10,4),(172,21,10000,0,10,4),(172,22,10000,0,10,4),(172,23,10000,0,10,4),(172,24,10000,0,10,4),(172,25,10000,0,10,4),(172,26,10000,0,10,4),(172,27,10000,0,10,4),(172,28,10000,0,10,4),(172,29,10000,0,10,4),(172,30,10000,0,10,4),(173,1,0,1,10,4),(173,2,0,1,10,4),(173,3,0,1,10,4),(173,4,0,1,10,4),(173,5,0,1,10,4),(173,6,0,1,10,4),(173,7,0,1,10,4),(173,8,0,1,10,4),(173,9,0,1,10,4),(173,10,0,1,10,4),(173,11,0,1,10,4),(173,12,0,1,10,4),(173,13,0,1,10,4),(173,14,0,1,10,4),(173,15,0,1,10,4),(173,16,0,1,10,4),(173,17,0,1,10,4),(173,18,0,1,10,4),(173,19,0,1,10,4),(173,20,0,1,10,4),(173,21,0,1,10,4),(173,22,0,1,10,4),(173,23,0,1,10,4),(173,24,0,1,10,4),(173,25,0,1,10,4),(173,26,0,1,10,4),(173,27,0,1,10,4),(173,28,0,1,10,4),(173,29,0,1,10,4),(173,30,0,1,10,4),(174,1,0,1,10,4),(174,2,0,1,10,4),(174,3,0,1,10,4),(174,4,0,1,10,4),(174,5,0,1,10,4),(174,6,0,1,10,4),(174,7,0,1,10,4),(174,8,0,1,10,4),(174,9,0,1,10,4),(174,10,0,1,10,4),(174,11,0,1,10,4),(174,12,0,1,10,4),(174,13,0,1,10,4),(174,14,0,1,10,4),(174,15,0,1,10,4),(174,16,0,1,10,4),(174,17,0,1,10,4),(174,18,0,1,10,4),(174,19,0,1,10,4),(174,20,0,1,10,4),(174,21,0,1,10,4),(174,22,0,1,10,4),(174,23,0,1,10,4),(174,24,0,1,10,4),(174,25,0,1,10,4),(174,26,0,1,10,4),(174,27,0,1,10,4),(174,28,0,1,10,4),(174,29,0,1,10,4),(174,30,0,1,10,4),(175,1,0,1,10,4),(175,2,0,1,10,4),(175,3,0,1,10,4),(175,4,0,1,10,4),(175,5,0,1,10,4),(175,6,0,1,10,4),(175,7,0,1,10,4),(175,8,0,1,10,4),(175,9,0,1,10,4),(175,10,0,1,10,4),(175,11,0,1,10,4),(175,12,0,1,10,4),(175,13,0,1,10,4),(175,14,0,1,10,4),(175,15,0,1,10,4),(175,16,0,1,10,4),(175,17,0,1,10,4),(175,18,0,1,10,4),(175,19,0,1,10,4),(175,20,0,1,10,4),(175,21,0,1,10,4),(175,22,0,1,10,4),(175,23,0,1,10,4),(175,24,0,1,10,4),(175,25,0,1,10,4),(175,26,0,1,10,4),(175,27,0,1,10,4),(175,28,0,1,10,4),(175,29,0,1,10,4),(175,30,0,1,10,4),(176,1,0,1,10,4),(176,2,0,1,10,4),(176,3,0,1,10,4),(176,4,0,1,10,4),(176,5,0,1,10,4),(176,6,0,1,10,4),(176,7,0,1,10,4),(176,8,0,1,10,4),(176,9,0,1,10,4),(176,10,0,1,10,4),(176,11,0,1,10,4),(176,12,0,1,10,4),(176,13,0,1,10,4),(176,14,0,1,10,4),(176,15,0,1,10,4),(176,16,0,1,10,4),(176,17,0,1,10,4),(176,18,0,1,10,4),(176,19,0,1,10,4),(176,20,0,1,10,4),(176,21,0,1,10,4),(176,22,0,1,10,4),(176,23,0,1,10,4),(176,24,0,1,10,4),(176,25,0,1,10,4),(176,26,0,1,10,4),(176,27,0,1,10,4),(176,28,0,1,10,4),(176,29,0,1,10,4),(176,30,0,1,10,4),(177,74,0,1,10,4),(177,75,0,1,10,4),(177,76,0,1,10,4),(177,77,0,1,10,4),(177,78,0,1,10,4),(177,79,0,1,10,4),(177,80,0,1,10,4),(178,74,10000,0,10,4),(178,75,10000,0,10,4),(178,76,10000,0,10,4),(178,77,10000,0,10,4),(178,78,10000,0,10,4),(178,79,10000,0,10,4),(178,80,10000,0,10,4),(178,81,10000,0,10,4),(178,82,10000,0,10,4),(178,83,10000,0,10,4),(178,84,10000,0,10,4),(178,85,10000,0,10,4),(178,86,10000,0,10,4),(178,87,10000,0,10,4),(178,88,10000,0,10,4),(178,113,10000,0,10,4),(178,114,10000,0,10,4),(178,115,10000,0,10,4),(178,116,10000,0,10,4),(178,117,10000,0,10,4),(178,118,10000,0,10,4),(178,119,10000,0,10,4),(178,120,10000,0,10,4),(178,121,10000,0,10,4),(178,122,10000,0,10,4),(178,123,10000,0,10,4),(178,124,10000,0,10,4),(178,125,10000,0,10,4),(178,126,10000,0,10,4),(178,127,10000,0,10,4),(178,128,10000,0,10,4),(178,129,10000,0,10,4),(178,130,10000,0,10,4),(178,131,10000,0,10,4),(178,132,10000,0,10,4),(178,133,10000,0,10,4),(178,134,10000,0,10,4),(178,135,10000,0,10,4),(178,136,10000,0,10,4),(178,137,10000,0,10,4),(178,138,10000,0,10,4),(178,139,10000,0,10,4),(178,140,10000,0,10,4),(178,141,10000,0,10,4),(178,142,10000,0,10,4),(178,143,10000,0,10,4),(178,144,10000,0,10,4),(178,145,10000,0,10,4),(178,146,10000,0,10,4),(178,147,10000,0,10,4),(178,148,10000,0,10,4),(178,149,10000,0,10,4),(178,150,10000,0,10,4),(178,151,10000,0,10,4),(178,152,10000,0,10,4),(178,153,10000,0,10,4),(178,154,10000,0,10,4),(178,155,10000,0,10,4),(178,156,10000,0,10,4),(178,157,10000,0,10,4),(178,158,10000,0,10,4),(178,159,10000,0,10,4),(178,160,10000,0,10,4),(178,161,10000,0,10,4),(178,162,10000,0,10,4),(178,163,10000,0,10,4),(178,164,10000,0,10,4),(178,165,10000,0,10,4),(178,166,10000,0,10,4),(178,167,10000,0,10,4),(178,168,10000,0,10,4),(178,169,10000,0,10,4),(178,170,10000,0,10,4),(178,171,10000,0,10,4),(178,172,10000,0,10,4),(178,173,10000,0,10,4),(178,174,10000,0,10,4),(178,175,10000,0,10,4),(178,176,10000,0,10,4),(178,177,10000,0,10,4),(178,178,10000,0,10,4),(178,179,10000,0,10,4),(178,180,10000,0,10,4),(178,181,10000,0,10,4),(178,182,10000,0,10,4),(178,183,10000,0,10,4),(178,184,10000,0,10,4),(178,185,10000,0,10,4),(178,186,10000,0,10,4),(178,187,10000,0,10,4),(178,188,10000,0,10,4),(178,189,10000,0,10,4),(178,190,10000,0,10,4),(178,191,10000,0,10,4),(178,192,10000,0,10,4),(178,193,10000,0,10,4),(178,194,10000,0,10,4),(178,195,10000,0,10,4),(178,196,10000,0,10,4),(178,197,10000,0,10,4),(178,198,10000,0,10,4),(178,199,10000,0,10,4),(178,200,10000,0,10,4),(178,201,10000,0,10,4),(178,202,10000,0,10,4),(178,203,10000,0,10,4),(178,204,10000,0,10,4),(178,205,10000,0,10,4),(178,206,10000,0,10,4),(178,207,10000,0,10,4),(178,208,10000,0,10,4),(178,209,10000,0,10,4),(178,210,10000,0,10,4),(178,211,10000,0,10,4),(178,212,10000,0,10,4),(178,213,10000,0,10,4),(178,214,10000,0,10,4),(178,215,10000,0,10,4),(178,216,10000,0,10,4),(178,217,10000,0,10,4),(178,218,10000,0,10,4),(178,219,10000,0,10,4),(178,220,10000,0,10,4),(178,221,10000,0,10,4),(178,222,10000,0,10,4),(178,223,10000,0,10,4),(178,224,10000,0,10,4),(178,225,10000,0,10,4),(178,226,10000,0,10,4),(178,227,10000,0,10,4),(178,228,10000,0,10,4),(178,229,10000,0,10,4),(178,230,10000,0,10,4),(178,231,10000,0,10,4),(178,232,10000,0,10,4),(178,233,10000,0,10,4),(178,234,10000,0,10,4),(178,235,10000,0,10,4),(178,236,10000,0,10,4),(178,237,10000,0,10,4),(178,238,10000,0,10,4),(178,239,10000,0,10,4),(178,240,10000,0,10,4),(178,241,10000,0,10,4),(178,244,10000,0,10,4),(178,246,10000,0,10,4),(178,251,10000,0,10,4),(178,255,10000,0,10,4),(178,258,10000,0,10,4),(178,259,10000,0,10,4),(178,260,10000,0,10,4),(178,261,10000,0,10,4),(178,262,10000,0,10,4),(178,263,10000,0,10,4),(179,81,0,1,10,4),(179,82,0,1,10,4),(179,83,0,1,10,4),(179,84,0,1,10,4),(179,85,0,1,10,4),(179,86,0,1,10,4),(179,87,0,1,10,4),(179,88,0,1,10,4),(180,81,0,1,10,4),(181,86,0,1,10,4),(182,82,0,1,10,4),(182,83,0,1,10,4),(182,84,0,1,10,4),(182,85,0,1,10,4),(182,87,0,1,10,4),(182,88,0,1,10,4),(183,82,0,1,10,4),(183,83,0,1,10,4),(183,84,0,1,10,4),(183,85,0,1,10,4),(183,86,0,1,10,4),(183,87,0,1,10,4),(183,88,0,1,10,4),(192,89,0,1,10,4),(192,90,0,1,10,4),(192,91,0,1,10,4),(192,92,0,1,10,4),(192,93,0,1,10,4),(192,94,0,1,10,4),(193,95,0,1,10,4),(193,96,0,1,10,4),(193,97,0,1,10,4),(193,98,0,1,10,4),(193,99,0,1,10,4),(193,100,0,1,10,4),(194,95,0,1,10,4),(194,96,0,1,10,4),(194,97,0,1,10,4),(194,98,0,1,10,4),(194,99,0,1,10,4),(194,100,0,1,10,4),(195,95,0,1,10,4),(195,96,0,1,10,4),(195,97,0,1,10,4),(195,98,0,1,10,4),(195,99,0,1,10,4),(195,100,0,1,10,4),(196,95,0,1,10,4),(196,96,0,1,10,4),(196,97,0,1,10,4),(196,98,0,1,10,4),(196,99,0,1,10,4),(196,100,0,1,10,4),(197,95,0,1,10,4),(197,96,0,1,10,4),(197,97,0,1,10,4),(197,98,0,1,10,4),(197,99,0,1,10,4),(197,100,0,1,10,4),(198,101,0,1,10,4),(198,109,0,1,10,4),(198,111,0,1,10,4),(198,112,0,1,10,4),(199,103,0,1,10,4),(199,110,0,1,10,4),(200,101,0,1,10,4),(200,102,0,1,10,4),(200,108,0,1,10,4),(201,104,0,1,10,4),(201,106,0,1,10,4),(202,101,0,1,10,4),(202,102,0,1,10,4),(202,103,0,1,10,4),(202,105,0,1,10,4),(202,107,0,1,10,4),(202,108,0,1,10,4),(202,110,0,1,10,4),(203,101,0,1,10,4),(203,102,0,1,10,4),(203,103,0,1,10,4),(203,104,0,1,10,4),(203,106,0,1,10,4),(203,108,0,1,10,4),(203,109,0,1,10,4),(204,101,0,1,10,4),(204,102,0,1,10,4),(204,103,0,1,10,4),(204,104,0,1,10,4),(204,105,0,1,10,4),(204,106,0,1,10,4),(204,107,0,1,10,4),(204,108,0,1,10,4),(205,101,0,1,10,4),(205,102,0,1,10,4),(205,103,0,1,10,4),(205,108,0,1,10,4),(205,109,0,1,10,4),(205,110,0,1,10,4),(205,111,0,1,10,4),(205,112,0,1,10,4),(206,113,10000,0,10,4),(206,114,10000,0,10,4),(206,115,10000,0,10,4),(206,116,10000,0,10,4),(206,117,10000,0,10,4),(206,118,10000,0,10,4),(206,119,10000,0,10,4),(207,114,0,1,10,4),(207,119,0,1,10,4),(209,114,0,1,10,4),(212,116,0,1,10,4),(212,118,0,1,10,4),(213,113,0,1,10,4),(218,117,0,1,10,4),(219,119,0,1,10,4),(220,119,0,1,10,4),(221,119,0,1,10,4),(222,114,0,1,10,4),(222,119,0,1,10,4),(223,114,0,1,10,4),(223,119,0,1,10,4),(229,113,0,1,10,4),(230,113,0,1,10,4),(231,113,0,1,10,4),(232,113,0,1,10,4),(233,113,0,1,10,4),(234,116,0,1,10,4),(234,118,0,1,10,4),(235,116,0,1,10,4),(235,118,0,1,10,4),(236,116,0,1,10,4),(236,118,0,1,10,4),(237,116,0,1,10,4),(237,118,0,1,10,4),(238,116,0,1,10,4),(238,118,0,1,10,4),(239,115,0,1,10,4),(241,115,0,1,10,4),(242,115,0,1,10,4),(243,115,0,1,10,4),(250,120,0,1,10,4),(250,121,0,1,10,4),(250,122,0,1,10,4),(250,123,0,1,10,4),(250,124,0,1,10,4),(250,125,0,1,10,4),(250,126,0,1,10,4),(250,127,0,1,10,4),(250,128,0,1,10,4),(250,129,0,1,10,4),(250,130,0,1,10,4),(250,131,0,1,10,4),(251,120,0,1,10,4),(251,121,0,1,10,4),(251,122,0,1,10,4),(251,123,0,1,10,4),(251,124,0,1,10,4),(251,125,0,1,10,4),(251,126,0,1,10,4),(251,127,0,1,10,4),(251,128,0,1,10,4),(251,129,0,1,10,4),(251,130,0,1,10,4),(251,131,0,1,10,4),(252,125,10000,0,10,4),(252,126,10000,0,10,4),(252,127,10000,0,10,4),(252,120,0,1,10,4),(252,121,0,1,10,4),(252,122,0,1,10,4),(252,123,0,1,10,4),(252,124,0,1,10,4),(252,128,0,1,10,4),(252,129,0,1,10,4),(252,131,0,1,10,4),(253,120,0,1,10,4),(253,121,0,1,10,4),(253,122,0,1,10,4),(253,123,0,1,10,4),(253,124,0,1,10,4),(253,125,0,1,10,4),(253,126,0,1,10,4),(253,127,0,1,10,4),(253,128,0,1,10,4),(253,129,0,1,10,4),(253,130,0,1,10,4),(253,131,0,1,10,4),(254,120,0,1,10,4),(254,121,0,1,10,4),(254,122,0,1,10,4),(254,123,0,1,10,4),(254,124,0,1,10,4),(254,125,0,1,10,4),(254,126,0,1,10,4),(254,127,0,1,10,4),(254,128,0,1,10,4),(254,129,0,1,10,4),(254,130,0,1,10,4),(254,131,0,1,10,4),(255,122,0,1,10,4),(255,123,0,1,10,4),(255,124,0,1,10,4),(255,125,0,1,10,4),(255,126,0,1,10,4),(255,129,0,1,10,4),(256,121,0,1,10,4),(256,122,0,1,10,4),(256,123,0,1,10,4),(256,125,0,1,10,4),(256,126,0,1,10,4),(256,127,0,1,10,4),(257,121,0,1,10,4),(257,122,0,1,10,4),(257,123,0,1,10,4),(257,125,0,1,10,4),(257,127,0,1,10,4),(257,129,0,1,10,4),(258,121,0,1,10,4),(258,122,0,1,10,4),(258,125,0,1,10,4),(258,126,0,1,10,4),(258,127,0,1,10,4),(258,129,0,1,10,4),(259,120,0,1,10,4),(259,121,0,1,10,4),(259,123,0,1,10,4),(259,128,0,1,10,4),(259,129,0,1,10,4),(260,120,0,1,10,4),(260,121,0,1,10,4),(260,122,0,1,10,4),(260,123,0,1,10,4),(260,125,0,1,10,4),(260,127,0,1,10,4),(260,128,0,1,10,4),(260,129,0,1,10,4),(261,121,0,1,10,4),(261,122,0,1,10,4),(261,125,0,1,10,4),(261,126,0,1,10,4),(261,127,0,1,10,4),(261,129,0,1,10,4),(262,125,0,1,10,4),(262,126,0,1,10,4),(263,120,0,1,10,4),(263,121,0,1,10,4),(263,122,0,1,10,4),(263,123,0,1,10,4),(263,124,0,1,10,4),(263,128,0,1,10,4),(263,129,0,1,10,4),(263,131,0,1,10,4),(264,120,0,1,10,4),(264,122,0,1,10,4),(264,123,0,1,10,4),(264,125,0,1,10,4),(264,126,0,1,10,4),(264,129,0,1,10,4),(265,121,0,1,10,4),(265,122,0,1,10,4),(265,123,0,1,10,4),(265,127,0,1,10,4),(266,123,0,1,10,4),(266,125,0,1,10,4),(266,126,0,1,10,4),(266,127,0,1,10,4),(266,129,0,1,10,4),(267,121,0,1,10,4),(267,125,0,1,10,4),(267,126,0,1,10,4),(267,127,0,1,10,4),(268,120,0,1,10,4),(268,121,0,1,10,4),(268,122,0,1,10,4),(268,123,0,1,10,4),(268,124,0,1,10,4),(268,127,0,1,10,4),(268,129,0,1,10,4),(269,122,0,1,10,4),(269,125,0,1,10,4),(269,126,0,1,10,4),(269,127,0,1,10,4),(269,129,0,1,10,4),(270,121,0,1,10,4),(270,123,0,1,10,4),(270,125,0,1,10,4),(270,126,0,1,10,4),(270,129,0,1,10,4),(271,120,0,1,10,4),(271,121,0,1,10,4),(271,122,0,1,10,4),(271,125,0,1,10,4),(271,126,0,1,10,4),(271,127,0,1,10,4),(271,129,0,1,10,4),(272,122,0,1,10,4),(272,123,0,1,10,4),(272,124,0,1,10,4),(272,125,0,1,10,4),(272,126,0,1,10,4),(272,127,0,1,10,4),(272,128,0,1,10,4),(272,129,0,1,10,4),(273,120,0,1,10,4),(273,121,0,1,10,4),(273,123,0,1,10,4),(273,126,0,1,10,4),(273,127,0,1,10,4),(274,122,0,1,10,4),(274,123,0,1,10,4),(274,125,0,1,10,4),(274,126,0,1,10,4),(274,129,0,1,10,4),(275,120,0,1,10,4),(275,121,0,1,10,4),(275,122,0,1,10,4),(275,123,0,1,10,4),(275,124,0,1,10,4),(275,125,0,1,10,4),(275,126,0,1,10,4),(275,127,0,1,10,4),(275,128,0,1,10,4),(275,129,0,1,10,4),(275,130,0,1,10,4),(275,131,0,1,10,4),(276,122,0,1,10,4),(276,123,0,1,10,4),(276,127,0,1,10,4),(276,129,0,1,10,4),(277,120,0,1,10,4),(277,121,0,1,10,4),(277,123,0,1,10,4),(277,124,0,1,10,4),(277,125,0,1,10,4),(277,126,0,1,10,4),(277,127,0,1,10,4),(278,120,0,1,10,4),(278,121,0,1,10,4),(278,122,0,1,10,4),(278,123,0,1,10,4),(278,124,0,1,10,4),(278,125,0,1,10,4),(278,127,0,1,10,4),(278,128,0,1,10,4),(278,129,0,1,10,4),(279,120,0,1,10,4),(279,122,0,1,10,4),(279,126,0,1,10,4),(279,127,0,1,10,4),(279,129,0,1,10,4),(280,132,0,1,10,4),(280,133,0,1,10,4),(280,134,0,1,10,4),(280,135,0,1,10,4),(280,136,0,1,10,4),(280,137,0,1,10,4),(280,138,0,1,10,4),(280,139,0,1,10,4),(282,132,0,1,10,4),(282,133,0,1,10,4),(282,134,0,1,10,4),(282,137,0,1,10,4),(282,138,0,1,10,4),(283,135,0,1,10,4),(283,136,0,1,10,4),(283,139,0,1,10,4),(286,140,0,1,10,4),(286,141,0,1,10,4),(286,142,0,1,10,4),(286,143,0,1,10,4),(286,144,0,1,10,4),(286,145,0,1,10,4),(286,146,0,1,10,4),(286,147,0,1,10,4),(286,148,0,1,10,4),(286,149,0,1,10,4),(286,150,0,1,10,4),(286,151,0,1,10,4),(286,152,0,1,10,4),(286,153,0,1,10,4),(286,154,0,1,10,4),(286,155,0,1,10,4),(286,156,0,1,10,4),(286,157,0,1,10,4),(286,158,0,1,10,4),(286,159,0,1,10,4),(286,160,0,1,10,4),(286,161,0,1,10,4),(286,162,0,1,10,4),(286,163,0,1,10,4),(286,164,0,1,10,4),(286,165,0,1,10,4),(286,166,0,1,10,4),(286,167,0,1,10,4),(286,168,0,1,10,4),(286,169,0,1,10,4),(286,170,0,1,10,4),(286,171,0,1,10,4),(286,172,0,1,10,4),(286,173,0,1,10,4),(286,174,0,1,10,4),(286,175,0,1,10,4),(286,176,0,1,10,4),(286,177,0,1,10,4),(286,178,0,1,10,4),(286,179,0,1,10,4),(286,180,0,1,10,4),(286,181,0,1,10,4),(286,182,0,1,10,4),(286,183,0,1,10,4),(286,184,0,1,10,4),(286,185,0,1,10,4),(286,186,0,1,10,4),(286,187,0,1,10,4),(287,188,0,1,10,4),(288,189,0,1,10,4),(288,190,0,1,10,4),(288,191,0,1,10,4),(288,192,0,1,10,4),(288,193,0,1,10,4),(288,194,0,1,10,4),(288,195,0,1,10,4),(288,196,0,1,10,4),(288,197,0,1,10,4),(288,198,0,1,10,4),(288,199,0,1,10,4),(288,200,0,1,10,4),(289,201,10000,0,10,4),(289,202,10000,0,10,4),(289,203,10000,0,10,4),(289,204,10000,0,10,4),(289,205,10000,0,10,4),(289,206,10000,0,10,4),(289,207,10000,0,10,4),(289,208,10000,0,10,4),(289,209,10000,0,10,4),(289,210,10000,0,10,4),(289,211,10000,0,10,4),(289,212,10000,0,10,4),(289,213,10000,0,10,4),(289,214,10000,0,10,4),(289,215,10000,0,10,4),(289,216,10000,0,10,4),(289,217,10000,0,10,4),(289,218,10000,0,10,4),(289,219,10000,0,10,4),(289,220,10000,0,10,4),(289,221,10000,0,10,4),(289,222,10000,0,10,4),(289,223,10000,0,10,4),(289,224,10000,0,10,4),(289,225,10000,0,10,4),(289,226,10000,0,10,4),(289,227,10000,0,10,4),(289,228,10000,0,10,4),(289,229,10000,0,10,4),(289,230,10000,0,10,4),(289,231,10000,0,10,4),(289,232,10000,0,10,4),(289,244,10000,0,10,4),(289,246,10000,0,10,4),(289,251,10000,0,10,4),(289,255,10000,0,10,4),(289,258,10000,0,10,4),(289,259,10000,0,10,4),(289,260,10000,0,10,4),(289,261,10000,0,10,4),(289,262,10000,0,10,4),(289,263,10000,0,10,4),(290,209,0,1,10,4),(290,210,0,1,10,4),(290,211,0,1,10,4),(290,212,0,1,10,4),(290,213,0,1,10,4),(290,214,0,1,10,4),(290,215,0,1,10,4),(290,216,0,1,10,4),(291,201,0,1,10,4),(291,202,0,1,10,4),(291,203,0,1,10,4),(291,204,0,1,10,4),(291,205,0,1,10,4),(291,206,0,1,10,4),(291,207,0,1,10,4),(291,208,0,1,10,4),(292,217,0,1,10,4),(292,218,0,1,10,4),(292,219,0,1,10,4),(292,220,0,1,10,4),(292,221,0,1,10,4),(292,222,0,1,10,4),(292,223,0,1,10,4),(292,224,0,1,10,4),(293,225,0,1,10,4),(293,226,0,1,10,4),(293,227,0,1,10,4),(293,228,0,1,10,4),(293,229,0,1,10,4),(293,230,0,1,10,4),(293,231,0,1,10,4),(293,232,0,1,10,4),(293,255,0,1,10,4),(293,259,0,1,10,4),(293,260,0,1,10,4),(293,261,0,1,10,4),(293,262,0,1,10,4),(293,263,0,1,10,4),(294,233,0,1,10,4),(294,234,0,1,10,4),(294,235,0,1,10,4),(294,236,0,1,10,4),(294,237,0,1,10,4),(294,238,0,1,10,4),(294,239,0,1,10,4),(294,240,0,1,10,4),(294,241,0,1,10,4),(295,244,0,1,10,4),(295,246,0,1,10,4),(295,251,0,1,10,4),(295,255,0,1,10,4),(295,258,0,1,10,4),(296,251,0,1,10,4),(296,255,0,1,10,4),(296,258,0,1,10,4),(297,246,0,1,10,4),(297,255,0,1,10,4),(297,258,0,1,10,4),(298,255,0,1,10,4),(298,258,0,1,10,4),(299,251,0,1,10,4),(299,258,0,1,10,4);
/*!40000 ALTER TABLE `catalog_category_product_index_store10` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index_store10_replica`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store10_replica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store10_replica` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `CAT_CTGR_PRD_IDX_STORE10_PRD_ID_STORE_ID_CTGR_ID_VISIBILITY` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_F8ACF7CDE70069E0E1260FAB3C7FAF7E` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Product Index Store10';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index_store10_replica`
--

LOCK TABLES `catalog_category_product_index_store10_replica` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index_store10_replica` DISABLE KEYS */;
INSERT INTO `catalog_category_product_index_store10_replica` VALUES (2,1,0,1,10,4),(2,2,0,1,10,4),(2,3,0,1,10,4),(2,4,0,1,10,4),(2,5,0,1,10,4),(2,6,0,1,10,4),(2,7,0,1,10,4),(2,8,0,1,10,4),(2,9,0,1,10,4),(2,10,0,1,10,4),(2,11,0,1,10,4),(2,12,0,1,10,4),(2,13,0,1,10,4),(2,14,0,1,10,4),(2,15,0,1,10,4),(2,16,0,1,10,4),(2,17,0,1,10,4),(2,18,0,1,10,4),(2,19,0,1,10,4),(2,20,0,1,10,4),(2,21,0,1,10,4),(2,22,0,1,10,4),(2,23,0,1,10,4),(2,24,0,1,10,4),(2,25,0,1,10,4),(2,26,0,1,10,4),(2,27,0,1,10,4),(2,28,0,1,10,4),(2,29,0,1,10,4),(2,30,0,1,10,4),(2,31,0,1,10,4),(2,32,0,1,10,4),(2,33,0,1,10,4),(2,34,0,1,10,4),(2,35,0,1,10,4),(2,36,0,1,10,4),(2,37,0,1,10,4),(2,38,0,1,10,4),(2,39,0,1,10,4),(2,40,0,1,10,4),(2,41,0,1,10,4),(2,42,0,1,10,4),(2,43,0,1,10,4),(2,44,0,1,10,4),(2,45,0,1,10,4),(2,46,0,1,10,4),(2,47,0,1,10,4),(2,48,0,1,10,4),(2,49,0,1,10,4),(2,50,0,1,10,4),(2,57,0,1,10,4),(2,58,0,1,10,4),(2,59,0,1,10,4),(2,60,0,1,10,4),(2,61,0,1,10,4),(2,62,0,1,10,4),(2,63,0,1,10,4),(2,64,0,1,10,4),(2,65,0,1,10,4),(2,66,0,1,10,4),(2,68,0,1,10,4),(2,69,0,1,10,4),(2,70,0,1,10,4),(2,71,0,1,10,4),(2,72,0,1,10,4),(2,73,0,1,10,4),(2,74,0,1,10,4),(2,75,0,1,10,4),(2,76,0,1,10,4),(2,77,0,1,10,4),(2,78,0,1,10,4),(2,79,0,1,10,4),(2,80,0,1,10,4),(2,81,0,1,10,4),(2,82,0,1,10,4),(2,83,0,1,10,4),(2,84,0,1,10,4),(2,85,0,1,10,4),(2,86,0,1,10,4),(2,87,0,1,10,4),(2,88,0,1,10,4),(2,89,0,1,10,4),(2,90,0,1,10,4),(2,91,0,1,10,4),(2,92,0,1,10,4),(2,93,0,1,10,4),(2,94,0,1,10,4),(2,95,0,1,10,4),(2,96,0,1,10,4),(2,97,0,1,10,4),(2,98,0,1,10,4),(2,99,0,1,10,4),(2,100,0,1,10,4),(2,101,0,1,10,4),(2,102,0,1,10,4),(2,103,0,1,10,4),(2,104,0,1,10,4),(2,105,0,1,10,4),(2,106,0,1,10,4),(2,107,0,1,10,4),(2,108,0,1,10,4),(2,109,0,1,10,4),(2,110,0,1,10,4),(2,111,0,1,10,4),(2,112,0,1,10,4),(2,113,0,1,10,4),(2,114,0,1,10,4),(2,115,0,1,10,4),(2,116,0,1,10,4),(2,117,0,1,10,4),(2,118,0,1,10,4),(2,119,0,1,10,4),(2,120,0,1,10,4),(2,121,0,1,10,4),(2,122,0,1,10,4),(2,123,0,1,10,4),(2,124,0,1,10,4),(2,125,0,1,10,4),(2,126,0,1,10,4),(2,127,0,1,10,4),(2,128,0,1,10,4),(2,129,0,1,10,4),(2,130,0,1,10,4),(2,131,0,1,10,4),(2,132,0,1,10,4),(2,133,0,1,10,4),(2,134,0,1,10,4),(2,135,0,1,10,4),(2,136,0,1,10,4),(2,137,0,1,10,4),(2,138,0,1,10,4),(2,139,0,1,10,4),(2,140,0,1,10,4),(2,141,0,1,10,4),(2,142,0,1,10,4),(2,143,0,1,10,4),(2,144,0,1,10,4),(2,145,0,1,10,4),(2,146,0,1,10,4),(2,147,0,1,10,4),(2,148,0,1,10,4),(2,149,0,1,10,4),(2,150,0,1,10,4),(2,151,0,1,10,4),(2,152,0,1,10,4),(2,153,0,1,10,4),(2,154,0,1,10,4),(2,155,0,1,10,4),(2,156,0,1,10,4),(2,157,0,1,10,4),(2,158,0,1,10,4),(2,159,0,1,10,4),(2,160,0,1,10,4),(2,161,0,1,10,4),(2,162,0,1,10,4),(2,163,0,1,10,4),(2,164,0,1,10,4),(2,165,0,1,10,4),(2,166,0,1,10,4),(2,167,0,1,10,4),(2,168,0,1,10,4),(2,169,0,1,10,4),(2,170,0,1,10,4),(2,171,0,1,10,4),(2,172,0,1,10,4),(2,173,0,1,10,4),(2,174,0,1,10,4),(2,175,0,1,10,4),(2,176,0,1,10,4),(2,177,0,1,10,4),(2,178,0,1,10,4),(2,179,0,1,10,4),(2,180,0,1,10,4),(2,181,0,1,10,4),(2,182,0,1,10,4),(2,183,0,1,10,4),(2,184,0,1,10,4),(2,185,0,1,10,4),(2,186,0,1,10,4),(2,187,0,1,10,4),(2,188,0,1,10,4),(2,189,0,1,10,4),(2,190,0,1,10,4),(2,191,0,1,10,4),(2,192,0,1,10,4),(2,193,0,1,10,4),(2,194,0,1,10,4),(2,195,0,1,10,4),(2,196,0,1,10,4),(2,197,0,1,10,4),(2,198,0,1,10,4),(2,199,0,1,10,4),(2,200,0,1,10,4),(2,201,0,1,10,4),(2,202,0,1,10,4),(2,203,0,1,10,4),(2,204,0,1,10,4),(2,205,0,1,10,4),(2,206,0,1,10,4),(2,207,0,1,10,4),(2,208,0,1,10,4),(2,209,0,1,10,4),(2,210,0,1,10,4),(2,211,0,1,10,4),(2,212,0,1,10,4),(2,213,0,1,10,4),(2,214,0,1,10,4),(2,215,0,1,10,4),(2,216,0,1,10,4),(2,217,0,1,10,4),(2,218,0,1,10,4),(2,219,0,1,10,4),(2,220,0,1,10,4),(2,221,0,1,10,4),(2,222,0,1,10,4),(2,223,0,1,10,4),(2,224,0,1,10,4),(2,225,0,1,10,4),(2,226,0,1,10,4),(2,227,0,1,10,4),(2,228,0,1,10,4),(2,229,0,1,10,4),(2,230,0,1,10,4),(2,231,0,1,10,4),(2,232,0,1,10,4),(2,233,0,1,10,4),(2,234,0,1,10,4),(2,235,0,1,10,4),(2,236,0,1,10,4),(2,237,0,1,10,4),(2,238,0,1,10,4),(2,239,0,1,10,4),(2,240,0,1,10,4),(2,241,0,1,10,4),(2,244,0,1,10,4),(2,246,0,1,10,4),(2,251,0,1,10,4),(2,255,0,1,10,4),(2,258,0,1,10,4),(2,259,0,1,10,4),(2,260,0,1,10,4),(2,261,0,1,10,4),(2,262,0,1,10,4),(2,263,0,1,10,4),(3,1,0,1,10,4),(3,2,0,1,10,4),(3,3,0,1,10,4),(3,4,0,1,10,4),(3,5,0,1,10,4),(3,6,0,1,10,4),(3,7,0,1,10,4),(3,8,0,1,10,4),(3,10,0,1,10,4),(3,11,0,1,10,4),(4,12,0,1,10,4),(4,13,0,1,10,4),(4,14,0,1,10,4),(4,15,0,1,10,4),(4,16,0,1,10,4),(4,17,0,1,10,4),(4,18,0,1,10,4),(4,19,0,1,10,4),(4,36,0,1,10,4),(4,37,0,1,10,4),(4,38,0,1,10,4),(4,39,0,1,10,4),(4,40,0,1,10,4),(5,95,10000,0,10,4),(5,96,10000,0,10,4),(5,97,10000,0,10,4),(5,98,10000,0,10,4),(5,99,10000,0,10,4),(5,100,10000,0,10,4),(7,101,10000,0,10,4),(7,102,10000,0,10,4),(7,103,10000,0,10,4),(7,104,10000,0,10,4),(7,105,10000,0,10,4),(7,106,10000,0,10,4),(7,107,10000,0,10,4),(7,108,10000,0,10,4),(7,109,10000,0,10,4),(7,110,10000,0,10,4),(7,111,10000,0,10,4),(7,112,10000,0,10,4),(7,21,0,1,10,4),(7,22,0,1,10,4),(7,26,0,1,10,4),(8,61,0,1,10,4),(8,62,0,1,10,4),(8,63,0,1,10,4),(8,64,0,1,10,4),(8,65,0,1,10,4),(8,66,0,1,10,4),(11,4,10000,0,10,4),(11,89,10000,0,10,4),(11,90,10000,0,10,4),(11,91,10000,0,10,4),(11,92,10000,0,10,4),(11,93,10000,0,10,4),(11,94,10000,0,10,4),(11,28,0,1,10,4),(11,29,0,1,10,4),(11,30,0,1,10,4),(11,31,0,1,10,4),(11,32,0,1,10,4),(11,33,0,1,10,4),(11,34,0,1,10,4),(11,35,0,1,10,4),(13,21,0,1,10,4),(13,24,0,1,10,4),(13,25,0,1,10,4),(13,26,0,1,10,4),(13,27,0,1,10,4),(13,41,0,1,10,4),(13,42,0,1,10,4),(13,43,0,1,10,4),(13,44,0,1,10,4),(13,45,0,1,10,4),(13,46,0,1,10,4),(13,47,0,1,10,4),(13,48,0,1,10,4),(13,49,0,1,10,4),(15,22,10000,0,10,4),(15,23,10000,0,10,4),(16,20,0,1,10,4),(16,21,0,1,10,4),(16,22,0,1,10,4),(16,23,0,1,10,4),(16,24,0,1,10,4),(16,25,0,1,10,4),(16,26,0,1,10,4),(16,27,0,1,10,4),(16,41,0,1,10,4),(16,68,0,1,10,4),(16,69,0,1,10,4),(16,70,0,1,10,4),(16,71,0,1,10,4),(16,72,0,1,10,4),(16,73,0,1,10,4),(19,6,0,1,10,4),(19,7,0,1,10,4),(19,8,0,1,10,4),(19,10,0,1,10,4),(19,11,0,1,10,4),(27,11,0,1,10,4),(29,6,0,1,10,4),(29,8,0,1,10,4),(29,10,0,1,10,4),(30,6,0,1,10,4),(30,10,0,1,10,4),(33,7,0,1,10,4),(33,8,0,1,10,4),(33,10,0,1,10,4),(33,11,0,1,10,4),(42,7,0,1,10,4),(42,8,0,1,10,4),(42,11,0,1,10,4),(78,21,0,1,10,4),(78,26,0,1,10,4),(80,21,0,1,10,4),(80,22,0,1,10,4),(80,26,0,1,10,4),(81,26,0,1,10,4),(82,26,0,1,10,4),(83,26,0,1,10,4),(96,26,0,1,10,4),(97,26,0,1,10,4),(98,21,0,1,10,4),(98,22,0,1,10,4),(98,26,0,1,10,4),(99,18,0,1,10,4),(101,14,0,1,10,4),(101,15,0,1,10,4),(101,16,0,1,10,4),(102,12,0,1,10,4),(102,13,0,1,10,4),(102,14,0,1,10,4),(102,15,0,1,10,4),(102,16,0,1,10,4),(102,17,0,1,10,4),(102,19,0,1,10,4),(102,36,0,1,10,4),(102,37,0,1,10,4),(102,38,0,1,10,4),(102,39,0,1,10,4),(102,40,0,1,10,4),(103,18,0,1,10,4),(104,18,0,1,10,4),(105,18,0,1,10,4),(106,18,0,1,10,4),(107,18,0,1,10,4),(134,23,0,1,10,4),(135,22,0,1,10,4),(137,4,0,1,10,4),(137,28,0,1,10,4),(137,31,0,1,10,4),(137,34,0,1,10,4),(137,35,0,1,10,4),(138,28,0,1,10,4),(138,30,0,1,10,4),(138,32,0,1,10,4),(138,33,0,1,10,4),(139,28,0,1,10,4),(139,30,0,1,10,4),(139,32,0,1,10,4),(139,33,0,1,10,4),(140,28,0,1,10,4),(140,30,0,1,10,4),(140,32,0,1,10,4),(140,33,0,1,10,4),(145,1,0,1,10,4),(145,2,0,1,10,4),(145,3,0,1,10,4),(145,4,0,1,10,4),(145,5,0,1,10,4),(145,6,0,1,10,4),(145,7,0,1,10,4),(145,8,0,1,10,4),(145,9,0,1,10,4),(145,10,0,1,10,4),(145,11,0,1,10,4),(145,12,0,1,10,4),(145,13,0,1,10,4),(145,14,0,1,10,4),(145,15,0,1,10,4),(145,16,0,1,10,4),(145,17,0,1,10,4),(145,18,0,1,10,4),(145,19,0,1,10,4),(145,20,0,1,10,4),(145,21,0,1,10,4),(145,22,0,1,10,4),(145,23,0,1,10,4),(145,24,0,1,10,4),(145,25,0,1,10,4),(145,26,0,1,10,4),(145,27,0,1,10,4),(145,28,0,1,10,4),(145,29,0,1,10,4),(145,30,0,1,10,4),(145,31,0,1,10,4),(145,32,0,1,10,4),(145,33,0,1,10,4),(145,34,0,1,10,4),(145,35,0,1,10,4),(145,36,0,1,10,4),(145,37,0,1,10,4),(145,38,0,1,10,4),(145,39,0,1,10,4),(145,40,0,1,10,4),(145,41,0,1,10,4),(145,42,0,1,10,4),(145,43,0,1,10,4),(149,41,0,1,10,4),(150,50,0,1,10,4),(150,57,0,1,10,4),(150,58,0,1,10,4),(150,59,0,1,10,4),(150,60,0,1,10,4),(151,61,0,1,10,4),(151,62,0,1,10,4),(151,63,0,1,10,4),(151,64,0,1,10,4),(151,65,0,1,10,4),(151,66,0,1,10,4),(152,61,0,1,10,4),(152,63,0,1,10,4),(153,61,0,1,10,4),(153,63,0,1,10,4),(153,64,0,1,10,4),(153,65,0,1,10,4),(153,66,0,1,10,4),(154,61,0,1,10,4),(154,62,0,1,10,4),(154,64,0,1,10,4),(154,66,0,1,10,4),(155,61,0,1,10,4),(155,62,0,1,10,4),(155,64,0,1,10,4),(155,65,0,1,10,4),(155,66,0,1,10,4),(156,61,0,1,10,4),(156,62,0,1,10,4),(156,63,0,1,10,4),(156,64,0,1,10,4),(156,65,0,1,10,4),(156,66,0,1,10,4),(157,61,0,1,10,4),(157,62,0,1,10,4),(157,64,0,1,10,4),(157,65,0,1,10,4),(157,66,0,1,10,4),(158,61,0,1,10,4),(158,63,0,1,10,4),(158,64,0,1,10,4),(158,65,0,1,10,4),(158,66,0,1,10,4),(159,61,0,1,10,4),(159,62,0,1,10,4),(159,63,0,1,10,4),(159,64,0,1,10,4),(159,65,0,1,10,4),(159,66,0,1,10,4),(160,41,0,1,10,4),(160,68,0,1,10,4),(160,69,0,1,10,4),(160,70,0,1,10,4),(160,72,0,1,10,4),(160,73,0,1,10,4),(161,68,0,1,10,4),(161,69,0,1,10,4),(161,70,0,1,10,4),(161,71,0,1,10,4),(161,72,0,1,10,4),(162,68,0,1,10,4),(162,69,0,1,10,4),(162,72,0,1,10,4),(164,41,0,1,10,4),(164,70,0,1,10,4),(164,73,0,1,10,4),(166,41,0,1,10,4),(166,70,0,1,10,4),(166,73,0,1,10,4),(167,68,0,1,10,4),(167,69,0,1,10,4),(167,72,0,1,10,4),(168,71,0,1,10,4),(169,70,0,1,10,4),(171,70,0,1,10,4),(172,1,10000,0,10,4),(172,2,10000,0,10,4),(172,3,10000,0,10,4),(172,4,10000,0,10,4),(172,5,10000,0,10,4),(172,6,10000,0,10,4),(172,7,10000,0,10,4),(172,8,10000,0,10,4),(172,9,10000,0,10,4),(172,10,10000,0,10,4),(172,11,10000,0,10,4),(172,12,10000,0,10,4),(172,13,10000,0,10,4),(172,14,10000,0,10,4),(172,15,10000,0,10,4),(172,16,10000,0,10,4),(172,17,10000,0,10,4),(172,18,10000,0,10,4),(172,19,10000,0,10,4),(172,20,10000,0,10,4),(172,21,10000,0,10,4),(172,22,10000,0,10,4),(172,23,10000,0,10,4),(172,24,10000,0,10,4),(172,25,10000,0,10,4),(172,26,10000,0,10,4),(172,27,10000,0,10,4),(172,28,10000,0,10,4),(172,29,10000,0,10,4),(172,30,10000,0,10,4),(173,1,0,1,10,4),(173,2,0,1,10,4),(173,3,0,1,10,4),(173,4,0,1,10,4),(173,5,0,1,10,4),(173,6,0,1,10,4),(173,7,0,1,10,4),(173,8,0,1,10,4),(173,9,0,1,10,4),(173,10,0,1,10,4),(173,11,0,1,10,4),(173,12,0,1,10,4),(173,13,0,1,10,4),(173,14,0,1,10,4),(173,15,0,1,10,4),(173,16,0,1,10,4),(173,17,0,1,10,4),(173,18,0,1,10,4),(173,19,0,1,10,4),(173,20,0,1,10,4),(173,21,0,1,10,4),(173,22,0,1,10,4),(173,23,0,1,10,4),(173,24,0,1,10,4),(173,25,0,1,10,4),(173,26,0,1,10,4),(173,27,0,1,10,4),(173,28,0,1,10,4),(173,29,0,1,10,4),(173,30,0,1,10,4),(174,1,0,1,10,4),(174,2,0,1,10,4),(174,3,0,1,10,4),(174,4,0,1,10,4),(174,5,0,1,10,4),(174,6,0,1,10,4),(174,7,0,1,10,4),(174,8,0,1,10,4),(174,9,0,1,10,4),(174,10,0,1,10,4),(174,11,0,1,10,4),(174,12,0,1,10,4),(174,13,0,1,10,4),(174,14,0,1,10,4),(174,15,0,1,10,4),(174,16,0,1,10,4),(174,17,0,1,10,4),(174,18,0,1,10,4),(174,19,0,1,10,4),(174,20,0,1,10,4),(174,21,0,1,10,4),(174,22,0,1,10,4),(174,23,0,1,10,4),(174,24,0,1,10,4),(174,25,0,1,10,4),(174,26,0,1,10,4),(174,27,0,1,10,4),(174,28,0,1,10,4),(174,29,0,1,10,4),(174,30,0,1,10,4),(175,1,0,1,10,4),(175,2,0,1,10,4),(175,3,0,1,10,4),(175,4,0,1,10,4),(175,5,0,1,10,4),(175,6,0,1,10,4),(175,7,0,1,10,4),(175,8,0,1,10,4),(175,9,0,1,10,4),(175,10,0,1,10,4),(175,11,0,1,10,4),(175,12,0,1,10,4),(175,13,0,1,10,4),(175,14,0,1,10,4),(175,15,0,1,10,4),(175,16,0,1,10,4),(175,17,0,1,10,4),(175,18,0,1,10,4),(175,19,0,1,10,4),(175,20,0,1,10,4),(175,21,0,1,10,4),(175,22,0,1,10,4),(175,23,0,1,10,4),(175,24,0,1,10,4),(175,25,0,1,10,4),(175,26,0,1,10,4),(175,27,0,1,10,4),(175,28,0,1,10,4),(175,29,0,1,10,4),(175,30,0,1,10,4),(176,1,0,1,10,4),(176,2,0,1,10,4),(176,3,0,1,10,4),(176,4,0,1,10,4),(176,5,0,1,10,4),(176,6,0,1,10,4),(176,7,0,1,10,4),(176,8,0,1,10,4),(176,9,0,1,10,4),(176,10,0,1,10,4),(176,11,0,1,10,4),(176,12,0,1,10,4),(176,13,0,1,10,4),(176,14,0,1,10,4),(176,15,0,1,10,4),(176,16,0,1,10,4),(176,17,0,1,10,4),(176,18,0,1,10,4),(176,19,0,1,10,4),(176,20,0,1,10,4),(176,21,0,1,10,4),(176,22,0,1,10,4),(176,23,0,1,10,4),(176,24,0,1,10,4),(176,25,0,1,10,4),(176,26,0,1,10,4),(176,27,0,1,10,4),(176,28,0,1,10,4),(176,29,0,1,10,4),(176,30,0,1,10,4),(177,74,0,1,10,4),(177,75,0,1,10,4),(177,76,0,1,10,4),(177,77,0,1,10,4),(177,78,0,1,10,4),(177,79,0,1,10,4),(177,80,0,1,10,4),(178,74,10000,0,10,4),(178,75,10000,0,10,4),(178,76,10000,0,10,4),(178,77,10000,0,10,4),(178,78,10000,0,10,4),(178,79,10000,0,10,4),(178,80,10000,0,10,4),(178,81,10000,0,10,4),(178,82,10000,0,10,4),(178,83,10000,0,10,4),(178,84,10000,0,10,4),(178,85,10000,0,10,4),(178,86,10000,0,10,4),(178,87,10000,0,10,4),(178,88,10000,0,10,4),(178,113,10000,0,10,4),(178,114,10000,0,10,4),(178,115,10000,0,10,4),(178,116,10000,0,10,4),(178,117,10000,0,10,4),(178,118,10000,0,10,4),(178,119,10000,0,10,4),(178,120,10000,0,10,4),(178,121,10000,0,10,4),(178,122,10000,0,10,4),(178,123,10000,0,10,4),(178,124,10000,0,10,4),(178,125,10000,0,10,4),(178,126,10000,0,10,4),(178,127,10000,0,10,4),(178,128,10000,0,10,4),(178,129,10000,0,10,4),(178,130,10000,0,10,4),(178,131,10000,0,10,4),(178,132,10000,0,10,4),(178,133,10000,0,10,4),(178,134,10000,0,10,4),(178,135,10000,0,10,4),(178,136,10000,0,10,4),(178,137,10000,0,10,4),(178,138,10000,0,10,4),(178,139,10000,0,10,4),(178,140,10000,0,10,4),(178,141,10000,0,10,4),(178,142,10000,0,10,4),(178,143,10000,0,10,4),(178,144,10000,0,10,4),(178,145,10000,0,10,4),(178,146,10000,0,10,4),(178,147,10000,0,10,4),(178,148,10000,0,10,4),(178,149,10000,0,10,4),(178,150,10000,0,10,4),(178,151,10000,0,10,4),(178,152,10000,0,10,4),(178,153,10000,0,10,4),(178,154,10000,0,10,4),(178,155,10000,0,10,4),(178,156,10000,0,10,4),(178,157,10000,0,10,4),(178,158,10000,0,10,4),(178,159,10000,0,10,4),(178,160,10000,0,10,4),(178,161,10000,0,10,4),(178,162,10000,0,10,4),(178,163,10000,0,10,4),(178,164,10000,0,10,4),(178,165,10000,0,10,4),(178,166,10000,0,10,4),(178,167,10000,0,10,4),(178,168,10000,0,10,4),(178,169,10000,0,10,4),(178,170,10000,0,10,4),(178,171,10000,0,10,4),(178,172,10000,0,10,4),(178,173,10000,0,10,4),(178,174,10000,0,10,4),(178,175,10000,0,10,4),(178,176,10000,0,10,4),(178,177,10000,0,10,4),(178,178,10000,0,10,4),(178,179,10000,0,10,4),(178,180,10000,0,10,4),(178,181,10000,0,10,4),(178,182,10000,0,10,4),(178,183,10000,0,10,4),(178,184,10000,0,10,4),(178,185,10000,0,10,4),(178,186,10000,0,10,4),(178,187,10000,0,10,4),(178,188,10000,0,10,4),(178,189,10000,0,10,4),(178,190,10000,0,10,4),(178,191,10000,0,10,4),(178,192,10000,0,10,4),(178,193,10000,0,10,4),(178,194,10000,0,10,4),(178,195,10000,0,10,4),(178,196,10000,0,10,4),(178,197,10000,0,10,4),(178,198,10000,0,10,4),(178,199,10000,0,10,4),(178,200,10000,0,10,4),(178,201,10000,0,10,4),(178,202,10000,0,10,4),(178,203,10000,0,10,4),(178,204,10000,0,10,4),(178,205,10000,0,10,4),(178,206,10000,0,10,4),(178,207,10000,0,10,4),(178,208,10000,0,10,4),(178,209,10000,0,10,4),(178,210,10000,0,10,4),(178,211,10000,0,10,4),(178,212,10000,0,10,4),(178,213,10000,0,10,4),(178,214,10000,0,10,4),(178,215,10000,0,10,4),(178,216,10000,0,10,4),(178,217,10000,0,10,4),(178,218,10000,0,10,4),(178,219,10000,0,10,4),(178,220,10000,0,10,4),(178,221,10000,0,10,4),(178,222,10000,0,10,4),(178,223,10000,0,10,4),(178,224,10000,0,10,4),(178,225,10000,0,10,4),(178,226,10000,0,10,4),(178,227,10000,0,10,4),(178,228,10000,0,10,4),(178,229,10000,0,10,4),(178,230,10000,0,10,4),(178,231,10000,0,10,4),(178,232,10000,0,10,4),(178,233,10000,0,10,4),(178,234,10000,0,10,4),(178,235,10000,0,10,4),(178,236,10000,0,10,4),(178,237,10000,0,10,4),(178,238,10000,0,10,4),(178,239,10000,0,10,4),(178,240,10000,0,10,4),(178,241,10000,0,10,4),(178,244,10000,0,10,4),(178,246,10000,0,10,4),(178,251,10000,0,10,4),(178,255,10000,0,10,4),(178,258,10000,0,10,4),(178,259,10000,0,10,4),(178,260,10000,0,10,4),(178,261,10000,0,10,4),(178,262,10000,0,10,4),(178,263,10000,0,10,4),(179,81,0,1,10,4),(179,82,0,1,10,4),(179,83,0,1,10,4),(179,84,0,1,10,4),(179,85,0,1,10,4),(179,86,0,1,10,4),(179,87,0,1,10,4),(179,88,0,1,10,4),(180,81,0,1,10,4),(181,86,0,1,10,4),(182,82,0,1,10,4),(182,83,0,1,10,4),(182,84,0,1,10,4),(182,85,0,1,10,4),(182,87,0,1,10,4),(182,88,0,1,10,4),(183,82,0,1,10,4),(183,83,0,1,10,4),(183,84,0,1,10,4),(183,85,0,1,10,4),(183,86,0,1,10,4),(183,87,0,1,10,4),(183,88,0,1,10,4),(192,89,0,1,10,4),(192,90,0,1,10,4),(192,91,0,1,10,4),(192,92,0,1,10,4),(192,93,0,1,10,4),(192,94,0,1,10,4),(193,95,0,1,10,4),(193,96,0,1,10,4),(193,97,0,1,10,4),(193,98,0,1,10,4),(193,99,0,1,10,4),(193,100,0,1,10,4),(194,95,0,1,10,4),(194,96,0,1,10,4),(194,97,0,1,10,4),(194,98,0,1,10,4),(194,99,0,1,10,4),(194,100,0,1,10,4),(195,95,0,1,10,4),(195,96,0,1,10,4),(195,97,0,1,10,4),(195,98,0,1,10,4),(195,99,0,1,10,4),(195,100,0,1,10,4),(196,95,0,1,10,4),(196,96,0,1,10,4),(196,97,0,1,10,4),(196,98,0,1,10,4),(196,99,0,1,10,4),(196,100,0,1,10,4),(197,95,0,1,10,4),(197,96,0,1,10,4),(197,97,0,1,10,4),(197,98,0,1,10,4),(197,99,0,1,10,4),(197,100,0,1,10,4),(198,101,0,1,10,4),(198,109,0,1,10,4),(198,111,0,1,10,4),(198,112,0,1,10,4),(199,103,0,1,10,4),(199,110,0,1,10,4),(200,101,0,1,10,4),(200,102,0,1,10,4),(200,108,0,1,10,4),(201,104,0,1,10,4),(201,106,0,1,10,4),(202,101,0,1,10,4),(202,102,0,1,10,4),(202,103,0,1,10,4),(202,105,0,1,10,4),(202,107,0,1,10,4),(202,108,0,1,10,4),(202,110,0,1,10,4),(203,101,0,1,10,4),(203,102,0,1,10,4),(203,103,0,1,10,4),(203,104,0,1,10,4),(203,106,0,1,10,4),(203,108,0,1,10,4),(203,109,0,1,10,4),(204,101,0,1,10,4),(204,102,0,1,10,4),(204,103,0,1,10,4),(204,104,0,1,10,4),(204,105,0,1,10,4),(204,106,0,1,10,4),(204,107,0,1,10,4),(204,108,0,1,10,4),(205,101,0,1,10,4),(205,102,0,1,10,4),(205,103,0,1,10,4),(205,108,0,1,10,4),(205,109,0,1,10,4),(205,110,0,1,10,4),(205,111,0,1,10,4),(205,112,0,1,10,4),(206,113,10000,0,10,4),(206,114,10000,0,10,4),(206,115,10000,0,10,4),(206,116,10000,0,10,4),(206,117,10000,0,10,4),(206,118,10000,0,10,4),(206,119,10000,0,10,4),(207,114,0,1,10,4),(207,119,0,1,10,4),(209,114,0,1,10,4),(212,116,0,1,10,4),(212,118,0,1,10,4),(213,113,0,1,10,4),(218,117,0,1,10,4),(219,119,0,1,10,4),(220,119,0,1,10,4),(221,119,0,1,10,4),(222,114,0,1,10,4),(222,119,0,1,10,4),(223,114,0,1,10,4),(223,119,0,1,10,4),(229,113,0,1,10,4),(230,113,0,1,10,4),(231,113,0,1,10,4),(232,113,0,1,10,4),(233,113,0,1,10,4),(234,116,0,1,10,4),(234,118,0,1,10,4),(235,116,0,1,10,4),(235,118,0,1,10,4),(236,116,0,1,10,4),(236,118,0,1,10,4),(237,116,0,1,10,4),(237,118,0,1,10,4),(238,116,0,1,10,4),(238,118,0,1,10,4),(239,115,0,1,10,4),(241,115,0,1,10,4),(242,115,0,1,10,4),(243,115,0,1,10,4),(250,120,0,1,10,4),(250,121,0,1,10,4),(250,122,0,1,10,4),(250,123,0,1,10,4),(250,124,0,1,10,4),(250,125,0,1,10,4),(250,126,0,1,10,4),(250,127,0,1,10,4),(250,128,0,1,10,4),(250,129,0,1,10,4),(250,130,0,1,10,4),(250,131,0,1,10,4),(251,120,0,1,10,4),(251,121,0,1,10,4),(251,122,0,1,10,4),(251,123,0,1,10,4),(251,124,0,1,10,4),(251,125,0,1,10,4),(251,126,0,1,10,4),(251,127,0,1,10,4),(251,128,0,1,10,4),(251,129,0,1,10,4),(251,130,0,1,10,4),(251,131,0,1,10,4),(252,125,10000,0,10,4),(252,126,10000,0,10,4),(252,127,10000,0,10,4),(252,120,0,1,10,4),(252,121,0,1,10,4),(252,122,0,1,10,4),(252,123,0,1,10,4),(252,124,0,1,10,4),(252,128,0,1,10,4),(252,129,0,1,10,4),(252,131,0,1,10,4),(253,120,0,1,10,4),(253,121,0,1,10,4),(253,122,0,1,10,4),(253,123,0,1,10,4),(253,124,0,1,10,4),(253,125,0,1,10,4),(253,126,0,1,10,4),(253,127,0,1,10,4),(253,128,0,1,10,4),(253,129,0,1,10,4),(253,130,0,1,10,4),(253,131,0,1,10,4),(254,120,0,1,10,4),(254,121,0,1,10,4),(254,122,0,1,10,4),(254,123,0,1,10,4),(254,124,0,1,10,4),(254,125,0,1,10,4),(254,126,0,1,10,4),(254,127,0,1,10,4),(254,128,0,1,10,4),(254,129,0,1,10,4),(254,130,0,1,10,4),(254,131,0,1,10,4),(255,122,0,1,10,4),(255,123,0,1,10,4),(255,124,0,1,10,4),(255,125,0,1,10,4),(255,126,0,1,10,4),(255,129,0,1,10,4),(256,121,0,1,10,4),(256,122,0,1,10,4),(256,123,0,1,10,4),(256,125,0,1,10,4),(256,126,0,1,10,4),(256,127,0,1,10,4),(257,121,0,1,10,4),(257,122,0,1,10,4),(257,123,0,1,10,4),(257,125,0,1,10,4),(257,127,0,1,10,4),(257,129,0,1,10,4),(258,121,0,1,10,4),(258,122,0,1,10,4),(258,125,0,1,10,4),(258,126,0,1,10,4),(258,127,0,1,10,4),(258,129,0,1,10,4),(259,120,0,1,10,4),(259,121,0,1,10,4),(259,123,0,1,10,4),(259,128,0,1,10,4),(259,129,0,1,10,4),(260,120,0,1,10,4),(260,121,0,1,10,4),(260,122,0,1,10,4),(260,123,0,1,10,4),(260,125,0,1,10,4),(260,127,0,1,10,4),(260,128,0,1,10,4),(260,129,0,1,10,4),(261,121,0,1,10,4),(261,122,0,1,10,4),(261,125,0,1,10,4),(261,126,0,1,10,4),(261,127,0,1,10,4),(261,129,0,1,10,4),(262,125,0,1,10,4),(262,126,0,1,10,4),(263,120,0,1,10,4),(263,121,0,1,10,4),(263,122,0,1,10,4),(263,123,0,1,10,4),(263,124,0,1,10,4),(263,128,0,1,10,4),(263,129,0,1,10,4),(263,131,0,1,10,4),(264,120,0,1,10,4),(264,122,0,1,10,4),(264,123,0,1,10,4),(264,125,0,1,10,4),(264,126,0,1,10,4),(264,129,0,1,10,4),(265,121,0,1,10,4),(265,122,0,1,10,4),(265,123,0,1,10,4),(265,127,0,1,10,4),(266,123,0,1,10,4),(266,125,0,1,10,4),(266,126,0,1,10,4),(266,127,0,1,10,4),(266,129,0,1,10,4),(267,121,0,1,10,4),(267,125,0,1,10,4),(267,126,0,1,10,4),(267,127,0,1,10,4),(268,120,0,1,10,4),(268,121,0,1,10,4),(268,122,0,1,10,4),(268,123,0,1,10,4),(268,124,0,1,10,4),(268,127,0,1,10,4),(268,129,0,1,10,4),(269,122,0,1,10,4),(269,125,0,1,10,4),(269,126,0,1,10,4),(269,127,0,1,10,4),(269,129,0,1,10,4),(270,121,0,1,10,4),(270,123,0,1,10,4),(270,125,0,1,10,4),(270,126,0,1,10,4),(270,129,0,1,10,4),(271,120,0,1,10,4),(271,121,0,1,10,4),(271,122,0,1,10,4),(271,125,0,1,10,4),(271,126,0,1,10,4),(271,127,0,1,10,4),(271,129,0,1,10,4),(272,122,0,1,10,4),(272,123,0,1,10,4),(272,124,0,1,10,4),(272,125,0,1,10,4),(272,126,0,1,10,4),(272,127,0,1,10,4),(272,128,0,1,10,4),(272,129,0,1,10,4),(273,120,0,1,10,4),(273,121,0,1,10,4),(273,123,0,1,10,4),(273,126,0,1,10,4),(273,127,0,1,10,4),(274,122,0,1,10,4),(274,123,0,1,10,4),(274,125,0,1,10,4),(274,126,0,1,10,4),(274,129,0,1,10,4),(275,120,0,1,10,4),(275,121,0,1,10,4),(275,122,0,1,10,4),(275,123,0,1,10,4),(275,124,0,1,10,4),(275,125,0,1,10,4),(275,126,0,1,10,4),(275,127,0,1,10,4),(275,128,0,1,10,4),(275,129,0,1,10,4),(275,130,0,1,10,4),(275,131,0,1,10,4),(276,122,0,1,10,4),(276,123,0,1,10,4),(276,127,0,1,10,4),(276,129,0,1,10,4),(277,120,0,1,10,4),(277,121,0,1,10,4),(277,123,0,1,10,4),(277,124,0,1,10,4),(277,125,0,1,10,4),(277,126,0,1,10,4),(277,127,0,1,10,4),(278,120,0,1,10,4),(278,121,0,1,10,4),(278,122,0,1,10,4),(278,123,0,1,10,4),(278,124,0,1,10,4),(278,125,0,1,10,4),(278,127,0,1,10,4),(278,128,0,1,10,4),(278,129,0,1,10,4),(279,120,0,1,10,4),(279,122,0,1,10,4),(279,126,0,1,10,4),(279,127,0,1,10,4),(279,129,0,1,10,4),(280,132,0,1,10,4),(280,133,0,1,10,4),(280,134,0,1,10,4),(280,135,0,1,10,4),(280,136,0,1,10,4),(280,137,0,1,10,4),(280,138,0,1,10,4),(280,139,0,1,10,4),(282,132,0,1,10,4),(282,133,0,1,10,4),(282,134,0,1,10,4),(282,137,0,1,10,4),(282,138,0,1,10,4),(283,135,0,1,10,4),(283,136,0,1,10,4),(283,139,0,1,10,4),(286,140,0,1,10,4),(286,141,0,1,10,4),(286,142,0,1,10,4),(286,143,0,1,10,4),(286,144,0,1,10,4),(286,145,0,1,10,4),(286,146,0,1,10,4),(286,147,0,1,10,4),(286,148,0,1,10,4),(286,149,0,1,10,4),(286,150,0,1,10,4),(286,151,0,1,10,4),(286,152,0,1,10,4),(286,153,0,1,10,4),(286,154,0,1,10,4),(286,155,0,1,10,4),(286,156,0,1,10,4),(286,157,0,1,10,4),(286,158,0,1,10,4),(286,159,0,1,10,4),(286,160,0,1,10,4),(286,161,0,1,10,4),(286,162,0,1,10,4),(286,163,0,1,10,4),(286,164,0,1,10,4),(286,165,0,1,10,4),(286,166,0,1,10,4),(286,167,0,1,10,4),(286,168,0,1,10,4),(286,169,0,1,10,4),(286,170,0,1,10,4),(286,171,0,1,10,4),(286,172,0,1,10,4),(286,173,0,1,10,4),(286,174,0,1,10,4),(286,175,0,1,10,4),(286,176,0,1,10,4),(286,177,0,1,10,4),(286,178,0,1,10,4),(286,179,0,1,10,4),(286,180,0,1,10,4),(286,181,0,1,10,4),(286,182,0,1,10,4),(286,183,0,1,10,4),(286,184,0,1,10,4),(286,185,0,1,10,4),(286,186,0,1,10,4),(286,187,0,1,10,4),(287,188,0,1,10,4),(288,189,0,1,10,4),(288,190,0,1,10,4),(288,191,0,1,10,4),(288,192,0,1,10,4),(288,193,0,1,10,4),(288,194,0,1,10,4),(288,195,0,1,10,4),(288,196,0,1,10,4),(288,197,0,1,10,4),(288,198,0,1,10,4),(288,199,0,1,10,4),(288,200,0,1,10,4),(289,201,10000,0,10,4),(289,202,10000,0,10,4),(289,203,10000,0,10,4),(289,204,10000,0,10,4),(289,205,10000,0,10,4),(289,206,10000,0,10,4),(289,207,10000,0,10,4),(289,208,10000,0,10,4),(289,209,10000,0,10,4),(289,210,10000,0,10,4),(289,211,10000,0,10,4),(289,212,10000,0,10,4),(289,213,10000,0,10,4),(289,214,10000,0,10,4),(289,215,10000,0,10,4),(289,216,10000,0,10,4),(289,217,10000,0,10,4),(289,218,10000,0,10,4),(289,219,10000,0,10,4),(289,220,10000,0,10,4),(289,221,10000,0,10,4),(289,222,10000,0,10,4),(289,223,10000,0,10,4),(289,224,10000,0,10,4),(289,225,10000,0,10,4),(289,226,10000,0,10,4),(289,227,10000,0,10,4),(289,228,10000,0,10,4),(289,229,10000,0,10,4),(289,230,10000,0,10,4),(289,231,10000,0,10,4),(289,232,10000,0,10,4),(289,244,10000,0,10,4),(289,246,10000,0,10,4),(289,251,10000,0,10,4),(289,255,10000,0,10,4),(289,258,10000,0,10,4),(289,259,10000,0,10,4),(289,260,10000,0,10,4),(289,261,10000,0,10,4),(289,262,10000,0,10,4),(289,263,10000,0,10,4),(290,209,0,1,10,4),(290,210,0,1,10,4),(290,211,0,1,10,4),(290,212,0,1,10,4),(290,213,0,1,10,4),(290,214,0,1,10,4),(290,215,0,1,10,4),(290,216,0,1,10,4),(291,201,0,1,10,4),(291,202,0,1,10,4),(291,203,0,1,10,4),(291,204,0,1,10,4),(291,205,0,1,10,4),(291,206,0,1,10,4),(291,207,0,1,10,4),(291,208,0,1,10,4),(292,217,0,1,10,4),(292,218,0,1,10,4),(292,219,0,1,10,4),(292,220,0,1,10,4),(292,221,0,1,10,4),(292,222,0,1,10,4),(292,223,0,1,10,4),(292,224,0,1,10,4),(293,225,0,1,10,4),(293,226,0,1,10,4),(293,227,0,1,10,4),(293,228,0,1,10,4),(293,229,0,1,10,4),(293,230,0,1,10,4),(293,231,0,1,10,4),(293,232,0,1,10,4),(293,255,0,1,10,4),(293,259,0,1,10,4),(293,260,0,1,10,4),(293,261,0,1,10,4),(293,262,0,1,10,4),(293,263,0,1,10,4),(294,233,0,1,10,4),(294,234,0,1,10,4),(294,235,0,1,10,4),(294,236,0,1,10,4),(294,237,0,1,10,4),(294,238,0,1,10,4),(294,239,0,1,10,4),(294,240,0,1,10,4),(294,241,0,1,10,4),(295,244,0,1,10,4),(295,246,0,1,10,4),(295,251,0,1,10,4),(295,255,0,1,10,4),(295,258,0,1,10,4),(296,251,0,1,10,4),(296,255,0,1,10,4),(296,258,0,1,10,4),(297,246,0,1,10,4),(297,255,0,1,10,4),(297,258,0,1,10,4),(298,255,0,1,10,4),(298,258,0,1,10,4),(299,251,0,1,10,4),(299,258,0,1,10,4);
/*!40000 ALTER TABLE `catalog_category_product_index_store10_replica` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index_store11`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store11`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store11` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `CAT_CTGR_PRD_IDX_STORE11_PRD_ID_STORE_ID_CTGR_ID_VISIBILITY` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_9F0B77094AF348D2A235C90B326004F3` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Product Index Store11';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index_store11`
--

LOCK TABLES `catalog_category_product_index_store11` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index_store11` DISABLE KEYS */;
INSERT INTO `catalog_category_product_index_store11` VALUES (2,1,0,1,11,4),(2,2,0,1,11,4),(2,3,0,1,11,4),(2,4,0,1,11,4),(2,5,0,1,11,4),(2,6,0,1,11,4),(2,7,0,1,11,4),(2,8,0,1,11,4),(2,9,0,1,11,4),(2,10,0,1,11,4),(2,11,0,1,11,4),(2,12,0,1,11,4),(2,13,0,1,11,4),(2,14,0,1,11,4),(2,15,0,1,11,4),(2,16,0,1,11,4),(2,17,0,1,11,4),(2,18,0,1,11,4),(2,19,0,1,11,4),(2,20,0,1,11,4),(2,21,0,1,11,4),(2,22,0,1,11,4),(2,23,0,1,11,4),(2,24,0,1,11,4),(2,25,0,1,11,4),(2,26,0,1,11,4),(2,27,0,1,11,4),(2,28,0,1,11,4),(2,29,0,1,11,4),(2,30,0,1,11,4),(2,31,0,1,11,4),(2,32,0,1,11,4),(2,33,0,1,11,4),(2,34,0,1,11,4),(2,35,0,1,11,4),(2,36,0,1,11,4),(2,37,0,1,11,4),(2,38,0,1,11,4),(2,39,0,1,11,4),(2,40,0,1,11,4),(2,41,0,1,11,4),(2,42,0,1,11,4),(2,43,0,1,11,4),(2,44,0,1,11,4),(2,45,0,1,11,4),(2,46,0,1,11,4),(2,47,0,1,11,4),(2,48,0,1,11,4),(2,49,0,1,11,4),(2,50,0,1,11,4),(2,57,0,1,11,4),(2,58,0,1,11,4),(2,59,0,1,11,4),(2,60,0,1,11,4),(2,61,0,1,11,4),(2,62,0,1,11,4),(2,63,0,1,11,4),(2,64,0,1,11,4),(2,65,0,1,11,4),(2,66,0,1,11,4),(2,68,0,1,11,4),(2,69,0,1,11,4),(2,70,0,1,11,4),(2,71,0,1,11,4),(2,72,0,1,11,4),(2,73,0,1,11,4),(2,74,0,1,11,4),(2,75,0,1,11,4),(2,76,0,1,11,4),(2,77,0,1,11,4),(2,78,0,1,11,4),(2,79,0,1,11,4),(2,80,0,1,11,4),(2,81,0,1,11,4),(2,82,0,1,11,4),(2,83,0,1,11,4),(2,84,0,1,11,4),(2,85,0,1,11,4),(2,86,0,1,11,4),(2,87,0,1,11,4),(2,88,0,1,11,4),(2,89,0,1,11,4),(2,90,0,1,11,4),(2,91,0,1,11,4),(2,92,0,1,11,4),(2,93,0,1,11,4),(2,94,0,1,11,4),(2,95,0,1,11,4),(2,96,0,1,11,4),(2,97,0,1,11,4),(2,98,0,1,11,4),(2,99,0,1,11,4),(2,100,0,1,11,4),(2,101,0,1,11,4),(2,102,0,1,11,4),(2,103,0,1,11,4),(2,104,0,1,11,4),(2,105,0,1,11,4),(2,106,0,1,11,4),(2,107,0,1,11,4),(2,108,0,1,11,4),(2,109,0,1,11,4),(2,110,0,1,11,4),(2,111,0,1,11,4),(2,112,0,1,11,4),(2,113,0,1,11,4),(2,114,0,1,11,4),(2,115,0,1,11,4),(2,116,0,1,11,4),(2,117,0,1,11,4),(2,118,0,1,11,4),(2,119,0,1,11,4),(2,120,0,1,11,4),(2,121,0,1,11,4),(2,122,0,1,11,4),(2,123,0,1,11,4),(2,124,0,1,11,4),(2,125,0,1,11,4),(2,126,0,1,11,4),(2,127,0,1,11,4),(2,128,0,1,11,4),(2,129,0,1,11,4),(2,130,0,1,11,4),(2,131,0,1,11,4),(2,132,0,1,11,4),(2,133,0,1,11,4),(2,134,0,1,11,4),(2,135,0,1,11,4),(2,136,0,1,11,4),(2,137,0,1,11,4),(2,138,0,1,11,4),(2,139,0,1,11,4),(2,140,0,1,11,4),(2,141,0,1,11,4),(2,142,0,1,11,4),(2,143,0,1,11,4),(2,144,0,1,11,4),(2,145,0,1,11,4),(2,146,0,1,11,4),(2,147,0,1,11,4),(2,148,0,1,11,4),(2,149,0,1,11,4),(2,150,0,1,11,4),(2,151,0,1,11,4),(2,152,0,1,11,4),(2,153,0,1,11,4),(2,154,0,1,11,4),(2,155,0,1,11,4),(2,156,0,1,11,4),(2,157,0,1,11,4),(2,158,0,1,11,4),(2,159,0,1,11,4),(2,160,0,1,11,4),(2,161,0,1,11,4),(2,162,0,1,11,4),(2,163,0,1,11,4),(2,164,0,1,11,4),(2,165,0,1,11,4),(2,166,0,1,11,4),(2,167,0,1,11,4),(2,168,0,1,11,4),(2,169,0,1,11,4),(2,170,0,1,11,4),(2,171,0,1,11,4),(2,172,0,1,11,4),(2,173,0,1,11,4),(2,174,0,1,11,4),(2,175,0,1,11,4),(2,176,0,1,11,4),(2,177,0,1,11,4),(2,178,0,1,11,4),(2,179,0,1,11,4),(2,180,0,1,11,4),(2,181,0,1,11,4),(2,182,0,1,11,4),(2,183,0,1,11,4),(2,184,0,1,11,4),(2,185,0,1,11,4),(2,186,0,1,11,4),(2,187,0,1,11,4),(2,188,0,1,11,4),(2,189,0,1,11,4),(2,190,0,1,11,4),(2,191,0,1,11,4),(2,192,0,1,11,4),(2,193,0,1,11,4),(2,194,0,1,11,4),(2,195,0,1,11,4),(2,196,0,1,11,4),(2,197,0,1,11,4),(2,198,0,1,11,4),(2,199,0,1,11,4),(2,200,0,1,11,4),(2,201,0,1,11,4),(2,202,0,1,11,4),(2,203,0,1,11,4),(2,204,0,1,11,4),(2,205,0,1,11,4),(2,206,0,1,11,4),(2,207,0,1,11,4),(2,208,0,1,11,4),(2,209,0,1,11,4),(2,210,0,1,11,4),(2,211,0,1,11,4),(2,212,0,1,11,4),(2,213,0,1,11,4),(2,214,0,1,11,4),(2,215,0,1,11,4),(2,216,0,1,11,4),(2,217,0,1,11,4),(2,218,0,1,11,4),(2,219,0,1,11,4),(2,220,0,1,11,4),(2,221,0,1,11,4),(2,222,0,1,11,4),(2,223,0,1,11,4),(2,224,0,1,11,4),(2,225,0,1,11,4),(2,226,0,1,11,4),(2,227,0,1,11,4),(2,228,0,1,11,4),(2,229,0,1,11,4),(2,230,0,1,11,4),(2,231,0,1,11,4),(2,232,0,1,11,4),(2,233,0,1,11,4),(2,234,0,1,11,4),(2,235,0,1,11,4),(2,236,0,1,11,4),(2,237,0,1,11,4),(2,238,0,1,11,4),(2,239,0,1,11,4),(2,240,0,1,11,4),(2,241,0,1,11,4),(2,244,0,1,11,4),(2,246,0,1,11,4),(2,251,0,1,11,4),(2,255,0,1,11,4),(2,258,0,1,11,4),(2,259,0,1,11,4),(2,260,0,1,11,4),(2,261,0,1,11,4),(2,262,0,1,11,4),(2,263,0,1,11,4),(3,1,0,1,11,4),(3,2,0,1,11,4),(3,3,0,1,11,4),(3,4,0,1,11,4),(3,5,0,1,11,4),(3,6,0,1,11,4),(3,7,0,1,11,4),(3,8,0,1,11,4),(3,10,0,1,11,4),(3,11,0,1,11,4),(4,12,0,1,11,4),(4,13,0,1,11,4),(4,14,0,1,11,4),(4,15,0,1,11,4),(4,16,0,1,11,4),(4,17,0,1,11,4),(4,18,0,1,11,4),(4,19,0,1,11,4),(4,36,0,1,11,4),(4,37,0,1,11,4),(4,38,0,1,11,4),(4,39,0,1,11,4),(4,40,0,1,11,4),(5,95,10000,0,11,4),(5,96,10000,0,11,4),(5,97,10000,0,11,4),(5,98,10000,0,11,4),(5,99,10000,0,11,4),(5,100,10000,0,11,4),(7,101,10000,0,11,4),(7,102,10000,0,11,4),(7,103,10000,0,11,4),(7,104,10000,0,11,4),(7,105,10000,0,11,4),(7,106,10000,0,11,4),(7,107,10000,0,11,4),(7,108,10000,0,11,4),(7,109,10000,0,11,4),(7,110,10000,0,11,4),(7,111,10000,0,11,4),(7,112,10000,0,11,4),(7,21,0,1,11,4),(7,22,0,1,11,4),(7,26,0,1,11,4),(8,61,0,1,11,4),(8,62,0,1,11,4),(8,63,0,1,11,4),(8,64,0,1,11,4),(8,65,0,1,11,4),(8,66,0,1,11,4),(11,4,10000,0,11,4),(11,89,10000,0,11,4),(11,90,10000,0,11,4),(11,91,10000,0,11,4),(11,92,10000,0,11,4),(11,93,10000,0,11,4),(11,94,10000,0,11,4),(11,28,0,1,11,4),(11,29,0,1,11,4),(11,30,0,1,11,4),(11,31,0,1,11,4),(11,32,0,1,11,4),(11,33,0,1,11,4),(11,34,0,1,11,4),(11,35,0,1,11,4),(13,21,0,1,11,4),(13,24,0,1,11,4),(13,25,0,1,11,4),(13,26,0,1,11,4),(13,27,0,1,11,4),(13,41,0,1,11,4),(13,42,0,1,11,4),(13,43,0,1,11,4),(13,44,0,1,11,4),(13,45,0,1,11,4),(13,46,0,1,11,4),(13,47,0,1,11,4),(13,48,0,1,11,4),(13,49,0,1,11,4),(15,22,10000,0,11,4),(15,23,10000,0,11,4),(16,20,0,1,11,4),(16,21,0,1,11,4),(16,22,0,1,11,4),(16,23,0,1,11,4),(16,24,0,1,11,4),(16,25,0,1,11,4),(16,26,0,1,11,4),(16,27,0,1,11,4),(16,41,0,1,11,4),(16,68,0,1,11,4),(16,69,0,1,11,4),(16,70,0,1,11,4),(16,71,0,1,11,4),(16,72,0,1,11,4),(16,73,0,1,11,4),(19,6,0,1,11,4),(19,7,0,1,11,4),(19,8,0,1,11,4),(19,10,0,1,11,4),(19,11,0,1,11,4),(27,11,0,1,11,4),(29,6,0,1,11,4),(29,8,0,1,11,4),(29,10,0,1,11,4),(30,6,0,1,11,4),(30,10,0,1,11,4),(33,7,0,1,11,4),(33,8,0,1,11,4),(33,10,0,1,11,4),(33,11,0,1,11,4),(42,7,0,1,11,4),(42,8,0,1,11,4),(42,11,0,1,11,4),(78,21,0,1,11,4),(78,26,0,1,11,4),(80,21,0,1,11,4),(80,22,0,1,11,4),(80,26,0,1,11,4),(81,26,0,1,11,4),(82,26,0,1,11,4),(83,26,0,1,11,4),(96,26,0,1,11,4),(97,26,0,1,11,4),(98,21,0,1,11,4),(98,22,0,1,11,4),(98,26,0,1,11,4),(99,18,0,1,11,4),(101,14,0,1,11,4),(101,15,0,1,11,4),(101,16,0,1,11,4),(102,12,0,1,11,4),(102,13,0,1,11,4),(102,14,0,1,11,4),(102,15,0,1,11,4),(102,16,0,1,11,4),(102,17,0,1,11,4),(102,19,0,1,11,4),(102,36,0,1,11,4),(102,37,0,1,11,4),(102,38,0,1,11,4),(102,39,0,1,11,4),(102,40,0,1,11,4),(103,18,0,1,11,4),(104,18,0,1,11,4),(105,18,0,1,11,4),(106,18,0,1,11,4),(107,18,0,1,11,4),(134,23,0,1,11,4),(135,22,0,1,11,4),(137,4,0,1,11,4),(137,28,0,1,11,4),(137,31,0,1,11,4),(137,34,0,1,11,4),(137,35,0,1,11,4),(138,28,0,1,11,4),(138,30,0,1,11,4),(138,32,0,1,11,4),(138,33,0,1,11,4),(139,28,0,1,11,4),(139,30,0,1,11,4),(139,32,0,1,11,4),(139,33,0,1,11,4),(140,28,0,1,11,4),(140,30,0,1,11,4),(140,32,0,1,11,4),(140,33,0,1,11,4),(145,1,0,1,11,4),(145,2,0,1,11,4),(145,3,0,1,11,4),(145,4,0,1,11,4),(145,5,0,1,11,4),(145,6,0,1,11,4),(145,7,0,1,11,4),(145,8,0,1,11,4),(145,9,0,1,11,4),(145,10,0,1,11,4),(145,11,0,1,11,4),(145,12,0,1,11,4),(145,13,0,1,11,4),(145,14,0,1,11,4),(145,15,0,1,11,4),(145,16,0,1,11,4),(145,17,0,1,11,4),(145,18,0,1,11,4),(145,19,0,1,11,4),(145,20,0,1,11,4),(145,21,0,1,11,4),(145,22,0,1,11,4),(145,23,0,1,11,4),(145,24,0,1,11,4),(145,25,0,1,11,4),(145,26,0,1,11,4),(145,27,0,1,11,4),(145,28,0,1,11,4),(145,29,0,1,11,4),(145,30,0,1,11,4),(145,31,0,1,11,4),(145,32,0,1,11,4),(145,33,0,1,11,4),(145,34,0,1,11,4),(145,35,0,1,11,4),(145,36,0,1,11,4),(145,37,0,1,11,4),(145,38,0,1,11,4),(145,39,0,1,11,4),(145,40,0,1,11,4),(145,41,0,1,11,4),(145,42,0,1,11,4),(145,43,0,1,11,4),(149,41,0,1,11,4),(150,50,0,1,11,4),(150,57,0,1,11,4),(150,58,0,1,11,4),(150,59,0,1,11,4),(150,60,0,1,11,4),(151,61,0,1,11,4),(151,62,0,1,11,4),(151,63,0,1,11,4),(151,64,0,1,11,4),(151,65,0,1,11,4),(151,66,0,1,11,4),(152,61,0,1,11,4),(152,63,0,1,11,4),(153,61,0,1,11,4),(153,63,0,1,11,4),(153,64,0,1,11,4),(153,65,0,1,11,4),(153,66,0,1,11,4),(154,61,0,1,11,4),(154,62,0,1,11,4),(154,64,0,1,11,4),(154,66,0,1,11,4),(155,61,0,1,11,4),(155,62,0,1,11,4),(155,64,0,1,11,4),(155,65,0,1,11,4),(155,66,0,1,11,4),(156,61,0,1,11,4),(156,62,0,1,11,4),(156,63,0,1,11,4),(156,64,0,1,11,4),(156,65,0,1,11,4),(156,66,0,1,11,4),(157,61,0,1,11,4),(157,62,0,1,11,4),(157,64,0,1,11,4),(157,65,0,1,11,4),(157,66,0,1,11,4),(158,61,0,1,11,4),(158,63,0,1,11,4),(158,64,0,1,11,4),(158,65,0,1,11,4),(158,66,0,1,11,4),(159,61,0,1,11,4),(159,62,0,1,11,4),(159,63,0,1,11,4),(159,64,0,1,11,4),(159,65,0,1,11,4),(159,66,0,1,11,4),(160,41,0,1,11,4),(160,68,0,1,11,4),(160,69,0,1,11,4),(160,70,0,1,11,4),(160,72,0,1,11,4),(160,73,0,1,11,4),(161,68,0,1,11,4),(161,69,0,1,11,4),(161,70,0,1,11,4),(161,71,0,1,11,4),(161,72,0,1,11,4),(162,68,0,1,11,4),(162,69,0,1,11,4),(162,72,0,1,11,4),(164,41,0,1,11,4),(164,70,0,1,11,4),(164,73,0,1,11,4),(166,41,0,1,11,4),(166,70,0,1,11,4),(166,73,0,1,11,4),(167,68,0,1,11,4),(167,69,0,1,11,4),(167,72,0,1,11,4),(168,71,0,1,11,4),(169,70,0,1,11,4),(171,70,0,1,11,4),(172,1,10000,0,11,4),(172,2,10000,0,11,4),(172,3,10000,0,11,4),(172,4,10000,0,11,4),(172,5,10000,0,11,4),(172,6,10000,0,11,4),(172,7,10000,0,11,4),(172,8,10000,0,11,4),(172,9,10000,0,11,4),(172,10,10000,0,11,4),(172,11,10000,0,11,4),(172,12,10000,0,11,4),(172,13,10000,0,11,4),(172,14,10000,0,11,4),(172,15,10000,0,11,4),(172,16,10000,0,11,4),(172,17,10000,0,11,4),(172,18,10000,0,11,4),(172,19,10000,0,11,4),(172,20,10000,0,11,4),(172,21,10000,0,11,4),(172,22,10000,0,11,4),(172,23,10000,0,11,4),(172,24,10000,0,11,4),(172,25,10000,0,11,4),(172,26,10000,0,11,4),(172,27,10000,0,11,4),(172,28,10000,0,11,4),(172,29,10000,0,11,4),(172,30,10000,0,11,4),(173,1,0,1,11,4),(173,2,0,1,11,4),(173,3,0,1,11,4),(173,4,0,1,11,4),(173,5,0,1,11,4),(173,6,0,1,11,4),(173,7,0,1,11,4),(173,8,0,1,11,4),(173,9,0,1,11,4),(173,10,0,1,11,4),(173,11,0,1,11,4),(173,12,0,1,11,4),(173,13,0,1,11,4),(173,14,0,1,11,4),(173,15,0,1,11,4),(173,16,0,1,11,4),(173,17,0,1,11,4),(173,18,0,1,11,4),(173,19,0,1,11,4),(173,20,0,1,11,4),(173,21,0,1,11,4),(173,22,0,1,11,4),(173,23,0,1,11,4),(173,24,0,1,11,4),(173,25,0,1,11,4),(173,26,0,1,11,4),(173,27,0,1,11,4),(173,28,0,1,11,4),(173,29,0,1,11,4),(173,30,0,1,11,4),(174,1,0,1,11,4),(174,2,0,1,11,4),(174,3,0,1,11,4),(174,4,0,1,11,4),(174,5,0,1,11,4),(174,6,0,1,11,4),(174,7,0,1,11,4),(174,8,0,1,11,4),(174,9,0,1,11,4),(174,10,0,1,11,4),(174,11,0,1,11,4),(174,12,0,1,11,4),(174,13,0,1,11,4),(174,14,0,1,11,4),(174,15,0,1,11,4),(174,16,0,1,11,4),(174,17,0,1,11,4),(174,18,0,1,11,4),(174,19,0,1,11,4),(174,20,0,1,11,4),(174,21,0,1,11,4),(174,22,0,1,11,4),(174,23,0,1,11,4),(174,24,0,1,11,4),(174,25,0,1,11,4),(174,26,0,1,11,4),(174,27,0,1,11,4),(174,28,0,1,11,4),(174,29,0,1,11,4),(174,30,0,1,11,4),(175,1,0,1,11,4),(175,2,0,1,11,4),(175,3,0,1,11,4),(175,4,0,1,11,4),(175,5,0,1,11,4),(175,6,0,1,11,4),(175,7,0,1,11,4),(175,8,0,1,11,4),(175,9,0,1,11,4),(175,10,0,1,11,4),(175,11,0,1,11,4),(175,12,0,1,11,4),(175,13,0,1,11,4),(175,14,0,1,11,4),(175,15,0,1,11,4),(175,16,0,1,11,4),(175,17,0,1,11,4),(175,18,0,1,11,4),(175,19,0,1,11,4),(175,20,0,1,11,4),(175,21,0,1,11,4),(175,22,0,1,11,4),(175,23,0,1,11,4),(175,24,0,1,11,4),(175,25,0,1,11,4),(175,26,0,1,11,4),(175,27,0,1,11,4),(175,28,0,1,11,4),(175,29,0,1,11,4),(175,30,0,1,11,4),(176,1,0,1,11,4),(176,2,0,1,11,4),(176,3,0,1,11,4),(176,4,0,1,11,4),(176,5,0,1,11,4),(176,6,0,1,11,4),(176,7,0,1,11,4),(176,8,0,1,11,4),(176,9,0,1,11,4),(176,10,0,1,11,4),(176,11,0,1,11,4),(176,12,0,1,11,4),(176,13,0,1,11,4),(176,14,0,1,11,4),(176,15,0,1,11,4),(176,16,0,1,11,4),(176,17,0,1,11,4),(176,18,0,1,11,4),(176,19,0,1,11,4),(176,20,0,1,11,4),(176,21,0,1,11,4),(176,22,0,1,11,4),(176,23,0,1,11,4),(176,24,0,1,11,4),(176,25,0,1,11,4),(176,26,0,1,11,4),(176,27,0,1,11,4),(176,28,0,1,11,4),(176,29,0,1,11,4),(176,30,0,1,11,4),(177,74,0,1,11,4),(177,75,0,1,11,4),(177,76,0,1,11,4),(177,77,0,1,11,4),(177,78,0,1,11,4),(177,79,0,1,11,4),(177,80,0,1,11,4),(178,74,10000,0,11,4),(178,75,10000,0,11,4),(178,76,10000,0,11,4),(178,77,10000,0,11,4),(178,78,10000,0,11,4),(178,79,10000,0,11,4),(178,80,10000,0,11,4),(178,81,10000,0,11,4),(178,82,10000,0,11,4),(178,83,10000,0,11,4),(178,84,10000,0,11,4),(178,85,10000,0,11,4),(178,86,10000,0,11,4),(178,87,10000,0,11,4),(178,88,10000,0,11,4),(178,113,10000,0,11,4),(178,114,10000,0,11,4),(178,115,10000,0,11,4),(178,116,10000,0,11,4),(178,117,10000,0,11,4),(178,118,10000,0,11,4),(178,119,10000,0,11,4),(178,120,10000,0,11,4),(178,121,10000,0,11,4),(178,122,10000,0,11,4),(178,123,10000,0,11,4),(178,124,10000,0,11,4),(178,125,10000,0,11,4),(178,126,10000,0,11,4),(178,127,10000,0,11,4),(178,128,10000,0,11,4),(178,129,10000,0,11,4),(178,130,10000,0,11,4),(178,131,10000,0,11,4),(178,132,10000,0,11,4),(178,133,10000,0,11,4),(178,134,10000,0,11,4),(178,135,10000,0,11,4),(178,136,10000,0,11,4),(178,137,10000,0,11,4),(178,138,10000,0,11,4),(178,139,10000,0,11,4),(178,140,10000,0,11,4),(178,141,10000,0,11,4),(178,142,10000,0,11,4),(178,143,10000,0,11,4),(178,144,10000,0,11,4),(178,145,10000,0,11,4),(178,146,10000,0,11,4),(178,147,10000,0,11,4),(178,148,10000,0,11,4),(178,149,10000,0,11,4),(178,150,10000,0,11,4),(178,151,10000,0,11,4),(178,152,10000,0,11,4),(178,153,10000,0,11,4),(178,154,10000,0,11,4),(178,155,10000,0,11,4),(178,156,10000,0,11,4),(178,157,10000,0,11,4),(178,158,10000,0,11,4),(178,159,10000,0,11,4),(178,160,10000,0,11,4),(178,161,10000,0,11,4),(178,162,10000,0,11,4),(178,163,10000,0,11,4),(178,164,10000,0,11,4),(178,165,10000,0,11,4),(178,166,10000,0,11,4),(178,167,10000,0,11,4),(178,168,10000,0,11,4),(178,169,10000,0,11,4),(178,170,10000,0,11,4),(178,171,10000,0,11,4),(178,172,10000,0,11,4),(178,173,10000,0,11,4),(178,174,10000,0,11,4),(178,175,10000,0,11,4),(178,176,10000,0,11,4),(178,177,10000,0,11,4),(178,178,10000,0,11,4),(178,179,10000,0,11,4),(178,180,10000,0,11,4),(178,181,10000,0,11,4),(178,182,10000,0,11,4),(178,183,10000,0,11,4),(178,184,10000,0,11,4),(178,185,10000,0,11,4),(178,186,10000,0,11,4),(178,187,10000,0,11,4),(178,188,10000,0,11,4),(178,189,10000,0,11,4),(178,190,10000,0,11,4),(178,191,10000,0,11,4),(178,192,10000,0,11,4),(178,193,10000,0,11,4),(178,194,10000,0,11,4),(178,195,10000,0,11,4),(178,196,10000,0,11,4),(178,197,10000,0,11,4),(178,198,10000,0,11,4),(178,199,10000,0,11,4),(178,200,10000,0,11,4),(178,201,10000,0,11,4),(178,202,10000,0,11,4),(178,203,10000,0,11,4),(178,204,10000,0,11,4),(178,205,10000,0,11,4),(178,206,10000,0,11,4),(178,207,10000,0,11,4),(178,208,10000,0,11,4),(178,209,10000,0,11,4),(178,210,10000,0,11,4),(178,211,10000,0,11,4),(178,212,10000,0,11,4),(178,213,10000,0,11,4),(178,214,10000,0,11,4),(178,215,10000,0,11,4),(178,216,10000,0,11,4),(178,217,10000,0,11,4),(178,218,10000,0,11,4),(178,219,10000,0,11,4),(178,220,10000,0,11,4),(178,221,10000,0,11,4),(178,222,10000,0,11,4),(178,223,10000,0,11,4),(178,224,10000,0,11,4),(178,225,10000,0,11,4),(178,226,10000,0,11,4),(178,227,10000,0,11,4),(178,228,10000,0,11,4),(178,229,10000,0,11,4),(178,230,10000,0,11,4),(178,231,10000,0,11,4),(178,232,10000,0,11,4),(178,233,10000,0,11,4),(178,234,10000,0,11,4),(178,235,10000,0,11,4),(178,236,10000,0,11,4),(178,237,10000,0,11,4),(178,238,10000,0,11,4),(178,239,10000,0,11,4),(178,240,10000,0,11,4),(178,241,10000,0,11,4),(178,244,10000,0,11,4),(178,246,10000,0,11,4),(178,251,10000,0,11,4),(178,255,10000,0,11,4),(178,258,10000,0,11,4),(178,259,10000,0,11,4),(178,260,10000,0,11,4),(178,261,10000,0,11,4),(178,262,10000,0,11,4),(178,263,10000,0,11,4),(179,81,0,1,11,4),(179,82,0,1,11,4),(179,83,0,1,11,4),(179,84,0,1,11,4),(179,85,0,1,11,4),(179,86,0,1,11,4),(179,87,0,1,11,4),(179,88,0,1,11,4),(180,81,0,1,11,4),(181,86,0,1,11,4),(182,82,0,1,11,4),(182,83,0,1,11,4),(182,84,0,1,11,4),(182,85,0,1,11,4),(182,87,0,1,11,4),(182,88,0,1,11,4),(183,82,0,1,11,4),(183,83,0,1,11,4),(183,84,0,1,11,4),(183,85,0,1,11,4),(183,86,0,1,11,4),(183,87,0,1,11,4),(183,88,0,1,11,4),(192,89,0,1,11,4),(192,90,0,1,11,4),(192,91,0,1,11,4),(192,92,0,1,11,4),(192,93,0,1,11,4),(192,94,0,1,11,4),(193,95,0,1,11,4),(193,96,0,1,11,4),(193,97,0,1,11,4),(193,98,0,1,11,4),(193,99,0,1,11,4),(193,100,0,1,11,4),(194,95,0,1,11,4),(194,96,0,1,11,4),(194,97,0,1,11,4),(194,98,0,1,11,4),(194,99,0,1,11,4),(194,100,0,1,11,4),(195,95,0,1,11,4),(195,96,0,1,11,4),(195,97,0,1,11,4),(195,98,0,1,11,4),(195,99,0,1,11,4),(195,100,0,1,11,4),(196,95,0,1,11,4),(196,96,0,1,11,4),(196,97,0,1,11,4),(196,98,0,1,11,4),(196,99,0,1,11,4),(196,100,0,1,11,4),(197,95,0,1,11,4),(197,96,0,1,11,4),(197,97,0,1,11,4),(197,98,0,1,11,4),(197,99,0,1,11,4),(197,100,0,1,11,4),(198,101,0,1,11,4),(198,109,0,1,11,4),(198,111,0,1,11,4),(198,112,0,1,11,4),(199,103,0,1,11,4),(199,110,0,1,11,4),(200,101,0,1,11,4),(200,102,0,1,11,4),(200,108,0,1,11,4),(201,104,0,1,11,4),(201,106,0,1,11,4),(202,101,0,1,11,4),(202,102,0,1,11,4),(202,103,0,1,11,4),(202,105,0,1,11,4),(202,107,0,1,11,4),(202,108,0,1,11,4),(202,110,0,1,11,4),(203,101,0,1,11,4),(203,102,0,1,11,4),(203,103,0,1,11,4),(203,104,0,1,11,4),(203,106,0,1,11,4),(203,108,0,1,11,4),(203,109,0,1,11,4),(204,101,0,1,11,4),(204,102,0,1,11,4),(204,103,0,1,11,4),(204,104,0,1,11,4),(204,105,0,1,11,4),(204,106,0,1,11,4),(204,107,0,1,11,4),(204,108,0,1,11,4),(205,101,0,1,11,4),(205,102,0,1,11,4),(205,103,0,1,11,4),(205,108,0,1,11,4),(205,109,0,1,11,4),(205,110,0,1,11,4),(205,111,0,1,11,4),(205,112,0,1,11,4),(206,113,10000,0,11,4),(206,114,10000,0,11,4),(206,115,10000,0,11,4),(206,116,10000,0,11,4),(206,117,10000,0,11,4),(206,118,10000,0,11,4),(206,119,10000,0,11,4),(207,114,0,1,11,4),(207,119,0,1,11,4),(209,114,0,1,11,4),(212,116,0,1,11,4),(212,118,0,1,11,4),(213,113,0,1,11,4),(218,117,0,1,11,4),(219,119,0,1,11,4),(220,119,0,1,11,4),(221,119,0,1,11,4),(222,114,0,1,11,4),(222,119,0,1,11,4),(223,114,0,1,11,4),(223,119,0,1,11,4),(229,113,0,1,11,4),(230,113,0,1,11,4),(231,113,0,1,11,4),(232,113,0,1,11,4),(233,113,0,1,11,4),(234,116,0,1,11,4),(234,118,0,1,11,4),(235,116,0,1,11,4),(235,118,0,1,11,4),(236,116,0,1,11,4),(236,118,0,1,11,4),(237,116,0,1,11,4),(237,118,0,1,11,4),(238,116,0,1,11,4),(238,118,0,1,11,4),(239,115,0,1,11,4),(241,115,0,1,11,4),(242,115,0,1,11,4),(243,115,0,1,11,4),(250,120,0,1,11,4),(250,121,0,1,11,4),(250,122,0,1,11,4),(250,123,0,1,11,4),(250,124,0,1,11,4),(250,125,0,1,11,4),(250,126,0,1,11,4),(250,127,0,1,11,4),(250,128,0,1,11,4),(250,129,0,1,11,4),(250,130,0,1,11,4),(250,131,0,1,11,4),(251,120,0,1,11,4),(251,121,0,1,11,4),(251,122,0,1,11,4),(251,123,0,1,11,4),(251,124,0,1,11,4),(251,125,0,1,11,4),(251,126,0,1,11,4),(251,127,0,1,11,4),(251,128,0,1,11,4),(251,129,0,1,11,4),(251,130,0,1,11,4),(251,131,0,1,11,4),(252,125,10000,0,11,4),(252,126,10000,0,11,4),(252,127,10000,0,11,4),(252,120,0,1,11,4),(252,121,0,1,11,4),(252,122,0,1,11,4),(252,123,0,1,11,4),(252,124,0,1,11,4),(252,128,0,1,11,4),(252,129,0,1,11,4),(252,131,0,1,11,4),(253,120,0,1,11,4),(253,121,0,1,11,4),(253,122,0,1,11,4),(253,123,0,1,11,4),(253,124,0,1,11,4),(253,125,0,1,11,4),(253,126,0,1,11,4),(253,127,0,1,11,4),(253,128,0,1,11,4),(253,129,0,1,11,4),(253,130,0,1,11,4),(253,131,0,1,11,4),(254,120,0,1,11,4),(254,121,0,1,11,4),(254,122,0,1,11,4),(254,123,0,1,11,4),(254,124,0,1,11,4),(254,125,0,1,11,4),(254,126,0,1,11,4),(254,127,0,1,11,4),(254,128,0,1,11,4),(254,129,0,1,11,4),(254,130,0,1,11,4),(254,131,0,1,11,4),(255,122,0,1,11,4),(255,123,0,1,11,4),(255,124,0,1,11,4),(255,125,0,1,11,4),(255,126,0,1,11,4),(255,129,0,1,11,4),(256,121,0,1,11,4),(256,122,0,1,11,4),(256,123,0,1,11,4),(256,125,0,1,11,4),(256,126,0,1,11,4),(256,127,0,1,11,4),(257,121,0,1,11,4),(257,122,0,1,11,4),(257,123,0,1,11,4),(257,125,0,1,11,4),(257,127,0,1,11,4),(257,129,0,1,11,4),(258,121,0,1,11,4),(258,122,0,1,11,4),(258,125,0,1,11,4),(258,126,0,1,11,4),(258,127,0,1,11,4),(258,129,0,1,11,4),(259,120,0,1,11,4),(259,121,0,1,11,4),(259,123,0,1,11,4),(259,128,0,1,11,4),(259,129,0,1,11,4),(260,120,0,1,11,4),(260,121,0,1,11,4),(260,122,0,1,11,4),(260,123,0,1,11,4),(260,125,0,1,11,4),(260,127,0,1,11,4),(260,128,0,1,11,4),(260,129,0,1,11,4),(261,121,0,1,11,4),(261,122,0,1,11,4),(261,125,0,1,11,4),(261,126,0,1,11,4),(261,127,0,1,11,4),(261,129,0,1,11,4),(262,125,0,1,11,4),(262,126,0,1,11,4),(263,120,0,1,11,4),(263,121,0,1,11,4),(263,122,0,1,11,4),(263,123,0,1,11,4),(263,124,0,1,11,4),(263,128,0,1,11,4),(263,129,0,1,11,4),(263,131,0,1,11,4),(264,120,0,1,11,4),(264,122,0,1,11,4),(264,123,0,1,11,4),(264,125,0,1,11,4),(264,126,0,1,11,4),(264,129,0,1,11,4),(265,121,0,1,11,4),(265,122,0,1,11,4),(265,123,0,1,11,4),(265,127,0,1,11,4),(266,123,0,1,11,4),(266,125,0,1,11,4),(266,126,0,1,11,4),(266,127,0,1,11,4),(266,129,0,1,11,4),(267,121,0,1,11,4),(267,125,0,1,11,4),(267,126,0,1,11,4),(267,127,0,1,11,4),(268,120,0,1,11,4),(268,121,0,1,11,4),(268,122,0,1,11,4),(268,123,0,1,11,4),(268,124,0,1,11,4),(268,127,0,1,11,4),(268,129,0,1,11,4),(269,122,0,1,11,4),(269,125,0,1,11,4),(269,126,0,1,11,4),(269,127,0,1,11,4),(269,129,0,1,11,4),(270,121,0,1,11,4),(270,123,0,1,11,4),(270,125,0,1,11,4),(270,126,0,1,11,4),(270,129,0,1,11,4),(271,120,0,1,11,4),(271,121,0,1,11,4),(271,122,0,1,11,4),(271,125,0,1,11,4),(271,126,0,1,11,4),(271,127,0,1,11,4),(271,129,0,1,11,4),(272,122,0,1,11,4),(272,123,0,1,11,4),(272,124,0,1,11,4),(272,125,0,1,11,4),(272,126,0,1,11,4),(272,127,0,1,11,4),(272,128,0,1,11,4),(272,129,0,1,11,4),(273,120,0,1,11,4),(273,121,0,1,11,4),(273,123,0,1,11,4),(273,126,0,1,11,4),(273,127,0,1,11,4),(274,122,0,1,11,4),(274,123,0,1,11,4),(274,125,0,1,11,4),(274,126,0,1,11,4),(274,129,0,1,11,4),(275,120,0,1,11,4),(275,121,0,1,11,4),(275,122,0,1,11,4),(275,123,0,1,11,4),(275,124,0,1,11,4),(275,125,0,1,11,4),(275,126,0,1,11,4),(275,127,0,1,11,4),(275,128,0,1,11,4),(275,129,0,1,11,4),(275,130,0,1,11,4),(275,131,0,1,11,4),(276,122,0,1,11,4),(276,123,0,1,11,4),(276,127,0,1,11,4),(276,129,0,1,11,4),(277,120,0,1,11,4),(277,121,0,1,11,4),(277,123,0,1,11,4),(277,124,0,1,11,4),(277,125,0,1,11,4),(277,126,0,1,11,4),(277,127,0,1,11,4),(278,120,0,1,11,4),(278,121,0,1,11,4),(278,122,0,1,11,4),(278,123,0,1,11,4),(278,124,0,1,11,4),(278,125,0,1,11,4),(278,127,0,1,11,4),(278,128,0,1,11,4),(278,129,0,1,11,4),(279,120,0,1,11,4),(279,122,0,1,11,4),(279,126,0,1,11,4),(279,127,0,1,11,4),(279,129,0,1,11,4),(280,132,0,1,11,4),(280,133,0,1,11,4),(280,134,0,1,11,4),(280,135,0,1,11,4),(280,136,0,1,11,4),(280,137,0,1,11,4),(280,138,0,1,11,4),(280,139,0,1,11,4),(282,132,0,1,11,4),(282,133,0,1,11,4),(282,134,0,1,11,4),(282,137,0,1,11,4),(282,138,0,1,11,4),(283,135,0,1,11,4),(283,136,0,1,11,4),(283,139,0,1,11,4),(286,140,0,1,11,4),(286,141,0,1,11,4),(286,142,0,1,11,4),(286,143,0,1,11,4),(286,144,0,1,11,4),(286,145,0,1,11,4),(286,146,0,1,11,4),(286,147,0,1,11,4),(286,148,0,1,11,4),(286,149,0,1,11,4),(286,150,0,1,11,4),(286,151,0,1,11,4),(286,152,0,1,11,4),(286,153,0,1,11,4),(286,154,0,1,11,4),(286,155,0,1,11,4),(286,156,0,1,11,4),(286,157,0,1,11,4),(286,158,0,1,11,4),(286,159,0,1,11,4),(286,160,0,1,11,4),(286,161,0,1,11,4),(286,162,0,1,11,4),(286,163,0,1,11,4),(286,164,0,1,11,4),(286,165,0,1,11,4),(286,166,0,1,11,4),(286,167,0,1,11,4),(286,168,0,1,11,4),(286,169,0,1,11,4),(286,170,0,1,11,4),(286,171,0,1,11,4),(286,172,0,1,11,4),(286,173,0,1,11,4),(286,174,0,1,11,4),(286,175,0,1,11,4),(286,176,0,1,11,4),(286,177,0,1,11,4),(286,178,0,1,11,4),(286,179,0,1,11,4),(286,180,0,1,11,4),(286,181,0,1,11,4),(286,182,0,1,11,4),(286,183,0,1,11,4),(286,184,0,1,11,4),(286,185,0,1,11,4),(286,186,0,1,11,4),(286,187,0,1,11,4),(287,188,0,1,11,4),(288,189,0,1,11,4),(288,190,0,1,11,4),(288,191,0,1,11,4),(288,192,0,1,11,4),(288,193,0,1,11,4),(288,194,0,1,11,4),(288,195,0,1,11,4),(288,196,0,1,11,4),(288,197,0,1,11,4),(288,198,0,1,11,4),(288,199,0,1,11,4),(288,200,0,1,11,4),(289,201,10000,0,11,4),(289,202,10000,0,11,4),(289,203,10000,0,11,4),(289,204,10000,0,11,4),(289,205,10000,0,11,4),(289,206,10000,0,11,4),(289,207,10000,0,11,4),(289,208,10000,0,11,4),(289,209,10000,0,11,4),(289,210,10000,0,11,4),(289,211,10000,0,11,4),(289,212,10000,0,11,4),(289,213,10000,0,11,4),(289,214,10000,0,11,4),(289,215,10000,0,11,4),(289,216,10000,0,11,4),(289,217,10000,0,11,4),(289,218,10000,0,11,4),(289,219,10000,0,11,4),(289,220,10000,0,11,4),(289,221,10000,0,11,4),(289,222,10000,0,11,4),(289,223,10000,0,11,4),(289,224,10000,0,11,4),(289,225,10000,0,11,4),(289,226,10000,0,11,4),(289,227,10000,0,11,4),(289,228,10000,0,11,4),(289,229,10000,0,11,4),(289,230,10000,0,11,4),(289,231,10000,0,11,4),(289,232,10000,0,11,4),(289,244,10000,0,11,4),(289,246,10000,0,11,4),(289,251,10000,0,11,4),(289,255,10000,0,11,4),(289,258,10000,0,11,4),(289,259,10000,0,11,4),(289,260,10000,0,11,4),(289,261,10000,0,11,4),(289,262,10000,0,11,4),(289,263,10000,0,11,4),(290,209,0,1,11,4),(290,210,0,1,11,4),(290,211,0,1,11,4),(290,212,0,1,11,4),(290,213,0,1,11,4),(290,214,0,1,11,4),(290,215,0,1,11,4),(290,216,0,1,11,4),(291,201,0,1,11,4),(291,202,0,1,11,4),(291,203,0,1,11,4),(291,204,0,1,11,4),(291,205,0,1,11,4),(291,206,0,1,11,4),(291,207,0,1,11,4),(291,208,0,1,11,4),(292,217,0,1,11,4),(292,218,0,1,11,4),(292,219,0,1,11,4),(292,220,0,1,11,4),(292,221,0,1,11,4),(292,222,0,1,11,4),(292,223,0,1,11,4),(292,224,0,1,11,4),(293,225,0,1,11,4),(293,226,0,1,11,4),(293,227,0,1,11,4),(293,228,0,1,11,4),(293,229,0,1,11,4),(293,230,0,1,11,4),(293,231,0,1,11,4),(293,232,0,1,11,4),(293,255,0,1,11,4),(293,259,0,1,11,4),(293,260,0,1,11,4),(293,261,0,1,11,4),(293,262,0,1,11,4),(293,263,0,1,11,4),(294,233,0,1,11,4),(294,234,0,1,11,4),(294,235,0,1,11,4),(294,236,0,1,11,4),(294,237,0,1,11,4),(294,238,0,1,11,4),(294,239,0,1,11,4),(294,240,0,1,11,4),(294,241,0,1,11,4),(295,244,0,1,11,4),(295,246,0,1,11,4),(295,251,0,1,11,4),(295,255,0,1,11,4),(295,258,0,1,11,4),(296,251,0,1,11,4),(296,255,0,1,11,4),(296,258,0,1,11,4),(297,246,0,1,11,4),(297,255,0,1,11,4),(297,258,0,1,11,4),(298,255,0,1,11,4),(298,258,0,1,11,4),(299,251,0,1,11,4),(299,258,0,1,11,4);
/*!40000 ALTER TABLE `catalog_category_product_index_store11` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index_store11_replica`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store11_replica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store11_replica` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `IDX_C745732E55C32D6FA5D2C9868E174B08` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_8E65224CF04CDBE62BE589AFCF1494B1` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Product Index Store11 Replica';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index_store11_replica`
--

LOCK TABLES `catalog_category_product_index_store11_replica` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index_store11_replica` DISABLE KEYS */;
INSERT INTO `catalog_category_product_index_store11_replica` VALUES (2,1,0,1,11,4),(2,2,0,1,11,4),(2,3,0,1,11,4),(2,4,0,1,11,4),(2,5,0,1,11,4),(2,6,0,1,11,4),(2,7,0,1,11,4),(2,8,0,1,11,4),(2,9,0,1,11,4),(2,10,0,1,11,4),(2,11,0,1,11,4),(2,12,0,1,11,4),(2,13,0,1,11,4),(2,14,0,1,11,4),(2,15,0,1,11,4),(2,16,0,1,11,4),(2,17,0,1,11,4),(2,18,0,1,11,4),(2,19,0,1,11,4),(2,20,0,1,11,4),(2,21,0,1,11,4),(2,22,0,1,11,4),(2,23,0,1,11,4),(2,24,0,1,11,4),(2,25,0,1,11,4),(2,26,0,1,11,4),(2,27,0,1,11,4),(2,28,0,1,11,4),(2,29,0,1,11,4),(2,30,0,1,11,4),(2,31,0,1,11,4),(2,32,0,1,11,4),(2,33,0,1,11,4),(2,34,0,1,11,4),(2,35,0,1,11,4),(2,36,0,1,11,4),(2,37,0,1,11,4),(2,38,0,1,11,4),(2,39,0,1,11,4),(2,40,0,1,11,4),(2,41,0,1,11,4),(2,42,0,1,11,4),(2,43,0,1,11,4),(2,44,0,1,11,4),(2,45,0,1,11,4),(2,46,0,1,11,4),(2,47,0,1,11,4),(2,48,0,1,11,4),(2,49,0,1,11,4),(2,50,0,1,11,4),(2,57,0,1,11,4),(2,58,0,1,11,4),(2,59,0,1,11,4),(2,60,0,1,11,4),(2,61,0,1,11,4),(2,62,0,1,11,4),(2,63,0,1,11,4),(2,64,0,1,11,4),(2,65,0,1,11,4),(2,66,0,1,11,4),(2,68,0,1,11,4),(2,69,0,1,11,4),(2,70,0,1,11,4),(2,71,0,1,11,4),(2,72,0,1,11,4),(2,73,0,1,11,4),(2,74,0,1,11,4),(2,75,0,1,11,4),(2,76,0,1,11,4),(2,77,0,1,11,4),(2,78,0,1,11,4),(2,79,0,1,11,4),(2,80,0,1,11,4),(2,81,0,1,11,4),(2,82,0,1,11,4),(2,83,0,1,11,4),(2,84,0,1,11,4),(2,85,0,1,11,4),(2,86,0,1,11,4),(2,87,0,1,11,4),(2,88,0,1,11,4),(2,89,0,1,11,4),(2,90,0,1,11,4),(2,91,0,1,11,4),(2,92,0,1,11,4),(2,93,0,1,11,4),(2,94,0,1,11,4),(2,95,0,1,11,4),(2,96,0,1,11,4),(2,97,0,1,11,4),(2,98,0,1,11,4),(2,99,0,1,11,4),(2,100,0,1,11,4),(2,101,0,1,11,4),(2,102,0,1,11,4),(2,103,0,1,11,4),(2,104,0,1,11,4),(2,105,0,1,11,4),(2,106,0,1,11,4),(2,107,0,1,11,4),(2,108,0,1,11,4),(2,109,0,1,11,4),(2,110,0,1,11,4),(2,111,0,1,11,4),(2,112,0,1,11,4),(2,113,0,1,11,4),(2,114,0,1,11,4),(2,115,0,1,11,4),(2,116,0,1,11,4),(2,117,0,1,11,4),(2,118,0,1,11,4),(2,119,0,1,11,4),(2,120,0,1,11,4),(2,121,0,1,11,4),(2,122,0,1,11,4),(2,123,0,1,11,4),(2,124,0,1,11,4),(2,125,0,1,11,4),(2,126,0,1,11,4),(2,127,0,1,11,4),(2,128,0,1,11,4),(2,129,0,1,11,4),(2,130,0,1,11,4),(2,131,0,1,11,4),(2,132,0,1,11,4),(2,133,0,1,11,4),(2,134,0,1,11,4),(2,135,0,1,11,4),(2,136,0,1,11,4),(2,137,0,1,11,4),(2,138,0,1,11,4),(2,139,0,1,11,4),(2,140,0,1,11,4),(2,141,0,1,11,4),(2,142,0,1,11,4),(2,143,0,1,11,4),(2,144,0,1,11,4),(2,145,0,1,11,4),(2,146,0,1,11,4),(2,147,0,1,11,4),(2,148,0,1,11,4),(2,149,0,1,11,4),(2,150,0,1,11,4),(2,151,0,1,11,4),(2,152,0,1,11,4),(2,153,0,1,11,4),(2,154,0,1,11,4),(2,155,0,1,11,4),(2,156,0,1,11,4),(2,157,0,1,11,4),(2,158,0,1,11,4),(2,159,0,1,11,4),(2,160,0,1,11,4),(2,161,0,1,11,4),(2,162,0,1,11,4),(2,163,0,1,11,4),(2,164,0,1,11,4),(2,165,0,1,11,4),(2,166,0,1,11,4),(2,167,0,1,11,4),(2,168,0,1,11,4),(2,169,0,1,11,4),(2,170,0,1,11,4),(2,171,0,1,11,4),(2,172,0,1,11,4),(2,173,0,1,11,4),(2,174,0,1,11,4),(2,175,0,1,11,4),(2,176,0,1,11,4),(2,177,0,1,11,4),(2,178,0,1,11,4),(2,179,0,1,11,4),(2,180,0,1,11,4),(2,181,0,1,11,4),(2,182,0,1,11,4),(2,183,0,1,11,4),(2,184,0,1,11,4),(2,185,0,1,11,4),(2,186,0,1,11,4),(2,187,0,1,11,4),(2,188,0,1,11,4),(2,189,0,1,11,4),(2,190,0,1,11,4),(2,191,0,1,11,4),(2,192,0,1,11,4),(2,193,0,1,11,4),(2,194,0,1,11,4),(2,195,0,1,11,4),(2,196,0,1,11,4),(2,197,0,1,11,4),(2,198,0,1,11,4),(2,199,0,1,11,4),(2,200,0,1,11,4),(2,201,0,1,11,4),(2,202,0,1,11,4),(2,203,0,1,11,4),(2,204,0,1,11,4),(2,205,0,1,11,4),(2,206,0,1,11,4),(2,207,0,1,11,4),(2,208,0,1,11,4),(2,209,0,1,11,4),(2,210,0,1,11,4),(2,211,0,1,11,4),(2,212,0,1,11,4),(2,213,0,1,11,4),(2,214,0,1,11,4),(2,215,0,1,11,4),(2,216,0,1,11,4),(2,217,0,1,11,4),(2,218,0,1,11,4),(2,219,0,1,11,4),(2,220,0,1,11,4),(2,221,0,1,11,4),(2,222,0,1,11,4),(2,223,0,1,11,4),(2,224,0,1,11,4),(2,225,0,1,11,4),(2,226,0,1,11,4),(2,227,0,1,11,4),(2,228,0,1,11,4),(2,229,0,1,11,4),(2,230,0,1,11,4),(2,231,0,1,11,4),(2,232,0,1,11,4),(2,233,0,1,11,4),(2,234,0,1,11,4),(2,235,0,1,11,4),(2,236,0,1,11,4),(2,237,0,1,11,4),(2,238,0,1,11,4),(2,239,0,1,11,4),(2,240,0,1,11,4),(2,241,0,1,11,4),(2,244,0,1,11,4),(2,246,0,1,11,4),(2,251,0,1,11,4),(2,255,0,1,11,4),(2,258,0,1,11,4),(2,259,0,1,11,4),(2,260,0,1,11,4),(2,261,0,1,11,4),(2,262,0,1,11,4),(2,263,0,1,11,4),(3,1,0,1,11,4),(3,2,0,1,11,4),(3,3,0,1,11,4),(3,4,0,1,11,4),(3,5,0,1,11,4),(3,6,0,1,11,4),(3,7,0,1,11,4),(3,8,0,1,11,4),(3,10,0,1,11,4),(3,11,0,1,11,4),(4,12,0,1,11,4),(4,13,0,1,11,4),(4,14,0,1,11,4),(4,15,0,1,11,4),(4,16,0,1,11,4),(4,17,0,1,11,4),(4,18,0,1,11,4),(4,19,0,1,11,4),(4,36,0,1,11,4),(4,37,0,1,11,4),(4,38,0,1,11,4),(4,39,0,1,11,4),(4,40,0,1,11,4),(5,95,10000,0,11,4),(5,96,10000,0,11,4),(5,97,10000,0,11,4),(5,98,10000,0,11,4),(5,99,10000,0,11,4),(5,100,10000,0,11,4),(7,101,10000,0,11,4),(7,102,10000,0,11,4),(7,103,10000,0,11,4),(7,104,10000,0,11,4),(7,105,10000,0,11,4),(7,106,10000,0,11,4),(7,107,10000,0,11,4),(7,108,10000,0,11,4),(7,109,10000,0,11,4),(7,110,10000,0,11,4),(7,111,10000,0,11,4),(7,112,10000,0,11,4),(7,21,0,1,11,4),(7,22,0,1,11,4),(7,26,0,1,11,4),(8,61,0,1,11,4),(8,62,0,1,11,4),(8,63,0,1,11,4),(8,64,0,1,11,4),(8,65,0,1,11,4),(8,66,0,1,11,4),(11,4,10000,0,11,4),(11,89,10000,0,11,4),(11,90,10000,0,11,4),(11,91,10000,0,11,4),(11,92,10000,0,11,4),(11,93,10000,0,11,4),(11,94,10000,0,11,4),(11,28,0,1,11,4),(11,29,0,1,11,4),(11,30,0,1,11,4),(11,31,0,1,11,4),(11,32,0,1,11,4),(11,33,0,1,11,4),(11,34,0,1,11,4),(11,35,0,1,11,4),(13,21,0,1,11,4),(13,24,0,1,11,4),(13,25,0,1,11,4),(13,26,0,1,11,4),(13,27,0,1,11,4),(13,41,0,1,11,4),(13,42,0,1,11,4),(13,43,0,1,11,4),(13,44,0,1,11,4),(13,45,0,1,11,4),(13,46,0,1,11,4),(13,47,0,1,11,4),(13,48,0,1,11,4),(13,49,0,1,11,4),(15,22,10000,0,11,4),(15,23,10000,0,11,4),(16,20,0,1,11,4),(16,21,0,1,11,4),(16,22,0,1,11,4),(16,23,0,1,11,4),(16,24,0,1,11,4),(16,25,0,1,11,4),(16,26,0,1,11,4),(16,27,0,1,11,4),(16,41,0,1,11,4),(16,68,0,1,11,4),(16,69,0,1,11,4),(16,70,0,1,11,4),(16,71,0,1,11,4),(16,72,0,1,11,4),(16,73,0,1,11,4),(19,6,0,1,11,4),(19,7,0,1,11,4),(19,8,0,1,11,4),(19,10,0,1,11,4),(19,11,0,1,11,4),(27,11,0,1,11,4),(29,6,0,1,11,4),(29,8,0,1,11,4),(29,10,0,1,11,4),(30,6,0,1,11,4),(30,10,0,1,11,4),(33,7,0,1,11,4),(33,8,0,1,11,4),(33,10,0,1,11,4),(33,11,0,1,11,4),(42,7,0,1,11,4),(42,8,0,1,11,4),(42,11,0,1,11,4),(78,21,0,1,11,4),(78,26,0,1,11,4),(80,21,0,1,11,4),(80,22,0,1,11,4),(80,26,0,1,11,4),(81,26,0,1,11,4),(82,26,0,1,11,4),(83,26,0,1,11,4),(96,26,0,1,11,4),(97,26,0,1,11,4),(98,21,0,1,11,4),(98,22,0,1,11,4),(98,26,0,1,11,4),(99,18,0,1,11,4),(101,14,0,1,11,4),(101,15,0,1,11,4),(101,16,0,1,11,4),(102,12,0,1,11,4),(102,13,0,1,11,4),(102,14,0,1,11,4),(102,15,0,1,11,4),(102,16,0,1,11,4),(102,17,0,1,11,4),(102,19,0,1,11,4),(102,36,0,1,11,4),(102,37,0,1,11,4),(102,38,0,1,11,4),(102,39,0,1,11,4),(102,40,0,1,11,4),(103,18,0,1,11,4),(104,18,0,1,11,4),(105,18,0,1,11,4),(106,18,0,1,11,4),(107,18,0,1,11,4),(134,23,0,1,11,4),(135,22,0,1,11,4),(137,4,0,1,11,4),(137,28,0,1,11,4),(137,31,0,1,11,4),(137,34,0,1,11,4),(137,35,0,1,11,4),(138,28,0,1,11,4),(138,30,0,1,11,4),(138,32,0,1,11,4),(138,33,0,1,11,4),(139,28,0,1,11,4),(139,30,0,1,11,4),(139,32,0,1,11,4),(139,33,0,1,11,4),(140,28,0,1,11,4),(140,30,0,1,11,4),(140,32,0,1,11,4),(140,33,0,1,11,4),(145,1,0,1,11,4),(145,2,0,1,11,4),(145,3,0,1,11,4),(145,4,0,1,11,4),(145,5,0,1,11,4),(145,6,0,1,11,4),(145,7,0,1,11,4),(145,8,0,1,11,4),(145,9,0,1,11,4),(145,10,0,1,11,4),(145,11,0,1,11,4),(145,12,0,1,11,4),(145,13,0,1,11,4),(145,14,0,1,11,4),(145,15,0,1,11,4),(145,16,0,1,11,4),(145,17,0,1,11,4),(145,18,0,1,11,4),(145,19,0,1,11,4),(145,20,0,1,11,4),(145,21,0,1,11,4),(145,22,0,1,11,4),(145,23,0,1,11,4),(145,24,0,1,11,4),(145,25,0,1,11,4),(145,26,0,1,11,4),(145,27,0,1,11,4),(145,28,0,1,11,4),(145,29,0,1,11,4),(145,30,0,1,11,4),(145,31,0,1,11,4),(145,32,0,1,11,4),(145,33,0,1,11,4),(145,34,0,1,11,4),(145,35,0,1,11,4),(145,36,0,1,11,4),(145,37,0,1,11,4),(145,38,0,1,11,4),(145,39,0,1,11,4),(145,40,0,1,11,4),(145,41,0,1,11,4),(145,42,0,1,11,4),(145,43,0,1,11,4),(149,41,0,1,11,4),(150,50,0,1,11,4),(150,57,0,1,11,4),(150,58,0,1,11,4),(150,59,0,1,11,4),(150,60,0,1,11,4),(151,61,0,1,11,4),(151,62,0,1,11,4),(151,63,0,1,11,4),(151,64,0,1,11,4),(151,65,0,1,11,4),(151,66,0,1,11,4),(152,61,0,1,11,4),(152,63,0,1,11,4),(153,61,0,1,11,4),(153,63,0,1,11,4),(153,64,0,1,11,4),(153,65,0,1,11,4),(153,66,0,1,11,4),(154,61,0,1,11,4),(154,62,0,1,11,4),(154,64,0,1,11,4),(154,66,0,1,11,4),(155,61,0,1,11,4),(155,62,0,1,11,4),(155,64,0,1,11,4),(155,65,0,1,11,4),(155,66,0,1,11,4),(156,61,0,1,11,4),(156,62,0,1,11,4),(156,63,0,1,11,4),(156,64,0,1,11,4),(156,65,0,1,11,4),(156,66,0,1,11,4),(157,61,0,1,11,4),(157,62,0,1,11,4),(157,64,0,1,11,4),(157,65,0,1,11,4),(157,66,0,1,11,4),(158,61,0,1,11,4),(158,63,0,1,11,4),(158,64,0,1,11,4),(158,65,0,1,11,4),(158,66,0,1,11,4),(159,61,0,1,11,4),(159,62,0,1,11,4),(159,63,0,1,11,4),(159,64,0,1,11,4),(159,65,0,1,11,4),(159,66,0,1,11,4),(160,41,0,1,11,4),(160,68,0,1,11,4),(160,69,0,1,11,4),(160,70,0,1,11,4),(160,72,0,1,11,4),(160,73,0,1,11,4),(161,68,0,1,11,4),(161,69,0,1,11,4),(161,70,0,1,11,4),(161,71,0,1,11,4),(161,72,0,1,11,4),(162,68,0,1,11,4),(162,69,0,1,11,4),(162,72,0,1,11,4),(164,41,0,1,11,4),(164,70,0,1,11,4),(164,73,0,1,11,4),(166,41,0,1,11,4),(166,70,0,1,11,4),(166,73,0,1,11,4),(167,68,0,1,11,4),(167,69,0,1,11,4),(167,72,0,1,11,4),(168,71,0,1,11,4),(169,70,0,1,11,4),(171,70,0,1,11,4),(172,1,10000,0,11,4),(172,2,10000,0,11,4),(172,3,10000,0,11,4),(172,4,10000,0,11,4),(172,5,10000,0,11,4),(172,6,10000,0,11,4),(172,7,10000,0,11,4),(172,8,10000,0,11,4),(172,9,10000,0,11,4),(172,10,10000,0,11,4),(172,11,10000,0,11,4),(172,12,10000,0,11,4),(172,13,10000,0,11,4),(172,14,10000,0,11,4),(172,15,10000,0,11,4),(172,16,10000,0,11,4),(172,17,10000,0,11,4),(172,18,10000,0,11,4),(172,19,10000,0,11,4),(172,20,10000,0,11,4),(172,21,10000,0,11,4),(172,22,10000,0,11,4),(172,23,10000,0,11,4),(172,24,10000,0,11,4),(172,25,10000,0,11,4),(172,26,10000,0,11,4),(172,27,10000,0,11,4),(172,28,10000,0,11,4),(172,29,10000,0,11,4),(172,30,10000,0,11,4),(173,1,0,1,11,4),(173,2,0,1,11,4),(173,3,0,1,11,4),(173,4,0,1,11,4),(173,5,0,1,11,4),(173,6,0,1,11,4),(173,7,0,1,11,4),(173,8,0,1,11,4),(173,9,0,1,11,4),(173,10,0,1,11,4),(173,11,0,1,11,4),(173,12,0,1,11,4),(173,13,0,1,11,4),(173,14,0,1,11,4),(173,15,0,1,11,4),(173,16,0,1,11,4),(173,17,0,1,11,4),(173,18,0,1,11,4),(173,19,0,1,11,4),(173,20,0,1,11,4),(173,21,0,1,11,4),(173,22,0,1,11,4),(173,23,0,1,11,4),(173,24,0,1,11,4),(173,25,0,1,11,4),(173,26,0,1,11,4),(173,27,0,1,11,4),(173,28,0,1,11,4),(173,29,0,1,11,4),(173,30,0,1,11,4),(174,1,0,1,11,4),(174,2,0,1,11,4),(174,3,0,1,11,4),(174,4,0,1,11,4),(174,5,0,1,11,4),(174,6,0,1,11,4),(174,7,0,1,11,4),(174,8,0,1,11,4),(174,9,0,1,11,4),(174,10,0,1,11,4),(174,11,0,1,11,4),(174,12,0,1,11,4),(174,13,0,1,11,4),(174,14,0,1,11,4),(174,15,0,1,11,4),(174,16,0,1,11,4),(174,17,0,1,11,4),(174,18,0,1,11,4),(174,19,0,1,11,4),(174,20,0,1,11,4),(174,21,0,1,11,4),(174,22,0,1,11,4),(174,23,0,1,11,4),(174,24,0,1,11,4),(174,25,0,1,11,4),(174,26,0,1,11,4),(174,27,0,1,11,4),(174,28,0,1,11,4),(174,29,0,1,11,4),(174,30,0,1,11,4),(175,1,0,1,11,4),(175,2,0,1,11,4),(175,3,0,1,11,4),(175,4,0,1,11,4),(175,5,0,1,11,4),(175,6,0,1,11,4),(175,7,0,1,11,4),(175,8,0,1,11,4),(175,9,0,1,11,4),(175,10,0,1,11,4),(175,11,0,1,11,4),(175,12,0,1,11,4),(175,13,0,1,11,4),(175,14,0,1,11,4),(175,15,0,1,11,4),(175,16,0,1,11,4),(175,17,0,1,11,4),(175,18,0,1,11,4),(175,19,0,1,11,4),(175,20,0,1,11,4),(175,21,0,1,11,4),(175,22,0,1,11,4),(175,23,0,1,11,4),(175,24,0,1,11,4),(175,25,0,1,11,4),(175,26,0,1,11,4),(175,27,0,1,11,4),(175,28,0,1,11,4),(175,29,0,1,11,4),(175,30,0,1,11,4),(176,1,0,1,11,4),(176,2,0,1,11,4),(176,3,0,1,11,4),(176,4,0,1,11,4),(176,5,0,1,11,4),(176,6,0,1,11,4),(176,7,0,1,11,4),(176,8,0,1,11,4),(176,9,0,1,11,4),(176,10,0,1,11,4),(176,11,0,1,11,4),(176,12,0,1,11,4),(176,13,0,1,11,4),(176,14,0,1,11,4),(176,15,0,1,11,4),(176,16,0,1,11,4),(176,17,0,1,11,4),(176,18,0,1,11,4),(176,19,0,1,11,4),(176,20,0,1,11,4),(176,21,0,1,11,4),(176,22,0,1,11,4),(176,23,0,1,11,4),(176,24,0,1,11,4),(176,25,0,1,11,4),(176,26,0,1,11,4),(176,27,0,1,11,4),(176,28,0,1,11,4),(176,29,0,1,11,4),(176,30,0,1,11,4),(177,74,0,1,11,4),(177,75,0,1,11,4),(177,76,0,1,11,4),(177,77,0,1,11,4),(177,78,0,1,11,4),(177,79,0,1,11,4),(177,80,0,1,11,4),(178,74,10000,0,11,4),(178,75,10000,0,11,4),(178,76,10000,0,11,4),(178,77,10000,0,11,4),(178,78,10000,0,11,4),(178,79,10000,0,11,4),(178,80,10000,0,11,4),(178,81,10000,0,11,4),(178,82,10000,0,11,4),(178,83,10000,0,11,4),(178,84,10000,0,11,4),(178,85,10000,0,11,4),(178,86,10000,0,11,4),(178,87,10000,0,11,4),(178,88,10000,0,11,4),(178,113,10000,0,11,4),(178,114,10000,0,11,4),(178,115,10000,0,11,4),(178,116,10000,0,11,4),(178,117,10000,0,11,4),(178,118,10000,0,11,4),(178,119,10000,0,11,4),(178,120,10000,0,11,4),(178,121,10000,0,11,4),(178,122,10000,0,11,4),(178,123,10000,0,11,4),(178,124,10000,0,11,4),(178,125,10000,0,11,4),(178,126,10000,0,11,4),(178,127,10000,0,11,4),(178,128,10000,0,11,4),(178,129,10000,0,11,4),(178,130,10000,0,11,4),(178,131,10000,0,11,4),(178,132,10000,0,11,4),(178,133,10000,0,11,4),(178,134,10000,0,11,4),(178,135,10000,0,11,4),(178,136,10000,0,11,4),(178,137,10000,0,11,4),(178,138,10000,0,11,4),(178,139,10000,0,11,4),(178,140,10000,0,11,4),(178,141,10000,0,11,4),(178,142,10000,0,11,4),(178,143,10000,0,11,4),(178,144,10000,0,11,4),(178,145,10000,0,11,4),(178,146,10000,0,11,4),(178,147,10000,0,11,4),(178,148,10000,0,11,4),(178,149,10000,0,11,4),(178,150,10000,0,11,4),(178,151,10000,0,11,4),(178,152,10000,0,11,4),(178,153,10000,0,11,4),(178,154,10000,0,11,4),(178,155,10000,0,11,4),(178,156,10000,0,11,4),(178,157,10000,0,11,4),(178,158,10000,0,11,4),(178,159,10000,0,11,4),(178,160,10000,0,11,4),(178,161,10000,0,11,4),(178,162,10000,0,11,4),(178,163,10000,0,11,4),(178,164,10000,0,11,4),(178,165,10000,0,11,4),(178,166,10000,0,11,4),(178,167,10000,0,11,4),(178,168,10000,0,11,4),(178,169,10000,0,11,4),(178,170,10000,0,11,4),(178,171,10000,0,11,4),(178,172,10000,0,11,4),(178,173,10000,0,11,4),(178,174,10000,0,11,4),(178,175,10000,0,11,4),(178,176,10000,0,11,4),(178,177,10000,0,11,4),(178,178,10000,0,11,4),(178,179,10000,0,11,4),(178,180,10000,0,11,4),(178,181,10000,0,11,4),(178,182,10000,0,11,4),(178,183,10000,0,11,4),(178,184,10000,0,11,4),(178,185,10000,0,11,4),(178,186,10000,0,11,4),(178,187,10000,0,11,4),(178,188,10000,0,11,4),(178,189,10000,0,11,4),(178,190,10000,0,11,4),(178,191,10000,0,11,4),(178,192,10000,0,11,4),(178,193,10000,0,11,4),(178,194,10000,0,11,4),(178,195,10000,0,11,4),(178,196,10000,0,11,4),(178,197,10000,0,11,4),(178,198,10000,0,11,4),(178,199,10000,0,11,4),(178,200,10000,0,11,4),(178,201,10000,0,11,4),(178,202,10000,0,11,4),(178,203,10000,0,11,4),(178,204,10000,0,11,4),(178,205,10000,0,11,4),(178,206,10000,0,11,4),(178,207,10000,0,11,4),(178,208,10000,0,11,4),(178,209,10000,0,11,4),(178,210,10000,0,11,4),(178,211,10000,0,11,4),(178,212,10000,0,11,4),(178,213,10000,0,11,4),(178,214,10000,0,11,4),(178,215,10000,0,11,4),(178,216,10000,0,11,4),(178,217,10000,0,11,4),(178,218,10000,0,11,4),(178,219,10000,0,11,4),(178,220,10000,0,11,4),(178,221,10000,0,11,4),(178,222,10000,0,11,4),(178,223,10000,0,11,4),(178,224,10000,0,11,4),(178,225,10000,0,11,4),(178,226,10000,0,11,4),(178,227,10000,0,11,4),(178,228,10000,0,11,4),(178,229,10000,0,11,4),(178,230,10000,0,11,4),(178,231,10000,0,11,4),(178,232,10000,0,11,4),(178,233,10000,0,11,4),(178,234,10000,0,11,4),(178,235,10000,0,11,4),(178,236,10000,0,11,4),(178,237,10000,0,11,4),(178,238,10000,0,11,4),(178,239,10000,0,11,4),(178,240,10000,0,11,4),(178,241,10000,0,11,4),(178,244,10000,0,11,4),(178,246,10000,0,11,4),(178,251,10000,0,11,4),(178,255,10000,0,11,4),(178,258,10000,0,11,4),(178,259,10000,0,11,4),(178,260,10000,0,11,4),(178,261,10000,0,11,4),(178,262,10000,0,11,4),(178,263,10000,0,11,4),(179,81,0,1,11,4),(179,82,0,1,11,4),(179,83,0,1,11,4),(179,84,0,1,11,4),(179,85,0,1,11,4),(179,86,0,1,11,4),(179,87,0,1,11,4),(179,88,0,1,11,4),(180,81,0,1,11,4),(181,86,0,1,11,4),(182,82,0,1,11,4),(182,83,0,1,11,4),(182,84,0,1,11,4),(182,85,0,1,11,4),(182,87,0,1,11,4),(182,88,0,1,11,4),(183,82,0,1,11,4),(183,83,0,1,11,4),(183,84,0,1,11,4),(183,85,0,1,11,4),(183,86,0,1,11,4),(183,87,0,1,11,4),(183,88,0,1,11,4),(192,89,0,1,11,4),(192,90,0,1,11,4),(192,91,0,1,11,4),(192,92,0,1,11,4),(192,93,0,1,11,4),(192,94,0,1,11,4),(193,95,0,1,11,4),(193,96,0,1,11,4),(193,97,0,1,11,4),(193,98,0,1,11,4),(193,99,0,1,11,4),(193,100,0,1,11,4),(194,95,0,1,11,4),(194,96,0,1,11,4),(194,97,0,1,11,4),(194,98,0,1,11,4),(194,99,0,1,11,4),(194,100,0,1,11,4),(195,95,0,1,11,4),(195,96,0,1,11,4),(195,97,0,1,11,4),(195,98,0,1,11,4),(195,99,0,1,11,4),(195,100,0,1,11,4),(196,95,0,1,11,4),(196,96,0,1,11,4),(196,97,0,1,11,4),(196,98,0,1,11,4),(196,99,0,1,11,4),(196,100,0,1,11,4),(197,95,0,1,11,4),(197,96,0,1,11,4),(197,97,0,1,11,4),(197,98,0,1,11,4),(197,99,0,1,11,4),(197,100,0,1,11,4),(198,101,0,1,11,4),(198,109,0,1,11,4),(198,111,0,1,11,4),(198,112,0,1,11,4),(199,103,0,1,11,4),(199,110,0,1,11,4),(200,101,0,1,11,4),(200,102,0,1,11,4),(200,108,0,1,11,4),(201,104,0,1,11,4),(201,106,0,1,11,4),(202,101,0,1,11,4),(202,102,0,1,11,4),(202,103,0,1,11,4),(202,105,0,1,11,4),(202,107,0,1,11,4),(202,108,0,1,11,4),(202,110,0,1,11,4),(203,101,0,1,11,4),(203,102,0,1,11,4),(203,103,0,1,11,4),(203,104,0,1,11,4),(203,106,0,1,11,4),(203,108,0,1,11,4),(203,109,0,1,11,4),(204,101,0,1,11,4),(204,102,0,1,11,4),(204,103,0,1,11,4),(204,104,0,1,11,4),(204,105,0,1,11,4),(204,106,0,1,11,4),(204,107,0,1,11,4),(204,108,0,1,11,4),(205,101,0,1,11,4),(205,102,0,1,11,4),(205,103,0,1,11,4),(205,108,0,1,11,4),(205,109,0,1,11,4),(205,110,0,1,11,4),(205,111,0,1,11,4),(205,112,0,1,11,4),(206,113,10000,0,11,4),(206,114,10000,0,11,4),(206,115,10000,0,11,4),(206,116,10000,0,11,4),(206,117,10000,0,11,4),(206,118,10000,0,11,4),(206,119,10000,0,11,4),(207,114,0,1,11,4),(207,119,0,1,11,4),(209,114,0,1,11,4),(212,116,0,1,11,4),(212,118,0,1,11,4),(213,113,0,1,11,4),(218,117,0,1,11,4),(219,119,0,1,11,4),(220,119,0,1,11,4),(221,119,0,1,11,4),(222,114,0,1,11,4),(222,119,0,1,11,4),(223,114,0,1,11,4),(223,119,0,1,11,4),(229,113,0,1,11,4),(230,113,0,1,11,4),(231,113,0,1,11,4),(232,113,0,1,11,4),(233,113,0,1,11,4),(234,116,0,1,11,4),(234,118,0,1,11,4),(235,116,0,1,11,4),(235,118,0,1,11,4),(236,116,0,1,11,4),(236,118,0,1,11,4),(237,116,0,1,11,4),(237,118,0,1,11,4),(238,116,0,1,11,4),(238,118,0,1,11,4),(239,115,0,1,11,4),(241,115,0,1,11,4),(242,115,0,1,11,4),(243,115,0,1,11,4),(250,120,0,1,11,4),(250,121,0,1,11,4),(250,122,0,1,11,4),(250,123,0,1,11,4),(250,124,0,1,11,4),(250,125,0,1,11,4),(250,126,0,1,11,4),(250,127,0,1,11,4),(250,128,0,1,11,4),(250,129,0,1,11,4),(250,130,0,1,11,4),(250,131,0,1,11,4),(251,120,0,1,11,4),(251,121,0,1,11,4),(251,122,0,1,11,4),(251,123,0,1,11,4),(251,124,0,1,11,4),(251,125,0,1,11,4),(251,126,0,1,11,4),(251,127,0,1,11,4),(251,128,0,1,11,4),(251,129,0,1,11,4),(251,130,0,1,11,4),(251,131,0,1,11,4),(252,125,10000,0,11,4),(252,126,10000,0,11,4),(252,127,10000,0,11,4),(252,120,0,1,11,4),(252,121,0,1,11,4),(252,122,0,1,11,4),(252,123,0,1,11,4),(252,124,0,1,11,4),(252,128,0,1,11,4),(252,129,0,1,11,4),(252,131,0,1,11,4),(253,120,0,1,11,4),(253,121,0,1,11,4),(253,122,0,1,11,4),(253,123,0,1,11,4),(253,124,0,1,11,4),(253,125,0,1,11,4),(253,126,0,1,11,4),(253,127,0,1,11,4),(253,128,0,1,11,4),(253,129,0,1,11,4),(253,130,0,1,11,4),(253,131,0,1,11,4),(254,120,0,1,11,4),(254,121,0,1,11,4),(254,122,0,1,11,4),(254,123,0,1,11,4),(254,124,0,1,11,4),(254,125,0,1,11,4),(254,126,0,1,11,4),(254,127,0,1,11,4),(254,128,0,1,11,4),(254,129,0,1,11,4),(254,130,0,1,11,4),(254,131,0,1,11,4),(255,122,0,1,11,4),(255,123,0,1,11,4),(255,124,0,1,11,4),(255,125,0,1,11,4),(255,126,0,1,11,4),(255,129,0,1,11,4),(256,121,0,1,11,4),(256,122,0,1,11,4),(256,123,0,1,11,4),(256,125,0,1,11,4),(256,126,0,1,11,4),(256,127,0,1,11,4),(257,121,0,1,11,4),(257,122,0,1,11,4),(257,123,0,1,11,4),(257,125,0,1,11,4),(257,127,0,1,11,4),(257,129,0,1,11,4),(258,121,0,1,11,4),(258,122,0,1,11,4),(258,125,0,1,11,4),(258,126,0,1,11,4),(258,127,0,1,11,4),(258,129,0,1,11,4),(259,120,0,1,11,4),(259,121,0,1,11,4),(259,123,0,1,11,4),(259,128,0,1,11,4),(259,129,0,1,11,4),(260,120,0,1,11,4),(260,121,0,1,11,4),(260,122,0,1,11,4),(260,123,0,1,11,4),(260,125,0,1,11,4),(260,127,0,1,11,4),(260,128,0,1,11,4),(260,129,0,1,11,4),(261,121,0,1,11,4),(261,122,0,1,11,4),(261,125,0,1,11,4),(261,126,0,1,11,4),(261,127,0,1,11,4),(261,129,0,1,11,4),(262,125,0,1,11,4),(262,126,0,1,11,4),(263,120,0,1,11,4),(263,121,0,1,11,4),(263,122,0,1,11,4),(263,123,0,1,11,4),(263,124,0,1,11,4),(263,128,0,1,11,4),(263,129,0,1,11,4),(263,131,0,1,11,4),(264,120,0,1,11,4),(264,122,0,1,11,4),(264,123,0,1,11,4),(264,125,0,1,11,4),(264,126,0,1,11,4),(264,129,0,1,11,4),(265,121,0,1,11,4),(265,122,0,1,11,4),(265,123,0,1,11,4),(265,127,0,1,11,4),(266,123,0,1,11,4),(266,125,0,1,11,4),(266,126,0,1,11,4),(266,127,0,1,11,4),(266,129,0,1,11,4),(267,121,0,1,11,4),(267,125,0,1,11,4),(267,126,0,1,11,4),(267,127,0,1,11,4),(268,120,0,1,11,4),(268,121,0,1,11,4),(268,122,0,1,11,4),(268,123,0,1,11,4),(268,124,0,1,11,4),(268,127,0,1,11,4),(268,129,0,1,11,4),(269,122,0,1,11,4),(269,125,0,1,11,4),(269,126,0,1,11,4),(269,127,0,1,11,4),(269,129,0,1,11,4),(270,121,0,1,11,4),(270,123,0,1,11,4),(270,125,0,1,11,4),(270,126,0,1,11,4),(270,129,0,1,11,4),(271,120,0,1,11,4),(271,121,0,1,11,4),(271,122,0,1,11,4),(271,125,0,1,11,4),(271,126,0,1,11,4),(271,127,0,1,11,4),(271,129,0,1,11,4),(272,122,0,1,11,4),(272,123,0,1,11,4),(272,124,0,1,11,4),(272,125,0,1,11,4),(272,126,0,1,11,4),(272,127,0,1,11,4),(272,128,0,1,11,4),(272,129,0,1,11,4),(273,120,0,1,11,4),(273,121,0,1,11,4),(273,123,0,1,11,4),(273,126,0,1,11,4),(273,127,0,1,11,4),(274,122,0,1,11,4),(274,123,0,1,11,4),(274,125,0,1,11,4),(274,126,0,1,11,4),(274,129,0,1,11,4),(275,120,0,1,11,4),(275,121,0,1,11,4),(275,122,0,1,11,4),(275,123,0,1,11,4),(275,124,0,1,11,4),(275,125,0,1,11,4),(275,126,0,1,11,4),(275,127,0,1,11,4),(275,128,0,1,11,4),(275,129,0,1,11,4),(275,130,0,1,11,4),(275,131,0,1,11,4),(276,122,0,1,11,4),(276,123,0,1,11,4),(276,127,0,1,11,4),(276,129,0,1,11,4),(277,120,0,1,11,4),(277,121,0,1,11,4),(277,123,0,1,11,4),(277,124,0,1,11,4),(277,125,0,1,11,4),(277,126,0,1,11,4),(277,127,0,1,11,4),(278,120,0,1,11,4),(278,121,0,1,11,4),(278,122,0,1,11,4),(278,123,0,1,11,4),(278,124,0,1,11,4),(278,125,0,1,11,4),(278,127,0,1,11,4),(278,128,0,1,11,4),(278,129,0,1,11,4),(279,120,0,1,11,4),(279,122,0,1,11,4),(279,126,0,1,11,4),(279,127,0,1,11,4),(279,129,0,1,11,4),(280,132,0,1,11,4),(280,133,0,1,11,4),(280,134,0,1,11,4),(280,135,0,1,11,4),(280,136,0,1,11,4),(280,137,0,1,11,4),(280,138,0,1,11,4),(280,139,0,1,11,4),(282,132,0,1,11,4),(282,133,0,1,11,4),(282,134,0,1,11,4),(282,137,0,1,11,4),(282,138,0,1,11,4),(283,135,0,1,11,4),(283,136,0,1,11,4),(283,139,0,1,11,4),(286,140,0,1,11,4),(286,141,0,1,11,4),(286,142,0,1,11,4),(286,143,0,1,11,4),(286,144,0,1,11,4),(286,145,0,1,11,4),(286,146,0,1,11,4),(286,147,0,1,11,4),(286,148,0,1,11,4),(286,149,0,1,11,4),(286,150,0,1,11,4),(286,151,0,1,11,4),(286,152,0,1,11,4),(286,153,0,1,11,4),(286,154,0,1,11,4),(286,155,0,1,11,4),(286,156,0,1,11,4),(286,157,0,1,11,4),(286,158,0,1,11,4),(286,159,0,1,11,4),(286,160,0,1,11,4),(286,161,0,1,11,4),(286,162,0,1,11,4),(286,163,0,1,11,4),(286,164,0,1,11,4),(286,165,0,1,11,4),(286,166,0,1,11,4),(286,167,0,1,11,4),(286,168,0,1,11,4),(286,169,0,1,11,4),(286,170,0,1,11,4),(286,171,0,1,11,4),(286,172,0,1,11,4),(286,173,0,1,11,4),(286,174,0,1,11,4),(286,175,0,1,11,4),(286,176,0,1,11,4),(286,177,0,1,11,4),(286,178,0,1,11,4),(286,179,0,1,11,4),(286,180,0,1,11,4),(286,181,0,1,11,4),(286,182,0,1,11,4),(286,183,0,1,11,4),(286,184,0,1,11,4),(286,185,0,1,11,4),(286,186,0,1,11,4),(286,187,0,1,11,4),(287,188,0,1,11,4),(288,189,0,1,11,4),(288,190,0,1,11,4),(288,191,0,1,11,4),(288,192,0,1,11,4),(288,193,0,1,11,4),(288,194,0,1,11,4),(288,195,0,1,11,4),(288,196,0,1,11,4),(288,197,0,1,11,4),(288,198,0,1,11,4),(288,199,0,1,11,4),(288,200,0,1,11,4),(289,201,10000,0,11,4),(289,202,10000,0,11,4),(289,203,10000,0,11,4),(289,204,10000,0,11,4),(289,205,10000,0,11,4),(289,206,10000,0,11,4),(289,207,10000,0,11,4),(289,208,10000,0,11,4),(289,209,10000,0,11,4),(289,210,10000,0,11,4),(289,211,10000,0,11,4),(289,212,10000,0,11,4),(289,213,10000,0,11,4),(289,214,10000,0,11,4),(289,215,10000,0,11,4),(289,216,10000,0,11,4),(289,217,10000,0,11,4),(289,218,10000,0,11,4),(289,219,10000,0,11,4),(289,220,10000,0,11,4),(289,221,10000,0,11,4),(289,222,10000,0,11,4),(289,223,10000,0,11,4),(289,224,10000,0,11,4),(289,225,10000,0,11,4),(289,226,10000,0,11,4),(289,227,10000,0,11,4),(289,228,10000,0,11,4),(289,229,10000,0,11,4),(289,230,10000,0,11,4),(289,231,10000,0,11,4),(289,232,10000,0,11,4),(289,244,10000,0,11,4),(289,246,10000,0,11,4),(289,251,10000,0,11,4),(289,255,10000,0,11,4),(289,258,10000,0,11,4),(289,259,10000,0,11,4),(289,260,10000,0,11,4),(289,261,10000,0,11,4),(289,262,10000,0,11,4),(289,263,10000,0,11,4),(290,209,0,1,11,4),(290,210,0,1,11,4),(290,211,0,1,11,4),(290,212,0,1,11,4),(290,213,0,1,11,4),(290,214,0,1,11,4),(290,215,0,1,11,4),(290,216,0,1,11,4),(291,201,0,1,11,4),(291,202,0,1,11,4),(291,203,0,1,11,4),(291,204,0,1,11,4),(291,205,0,1,11,4),(291,206,0,1,11,4),(291,207,0,1,11,4),(291,208,0,1,11,4),(292,217,0,1,11,4),(292,218,0,1,11,4),(292,219,0,1,11,4),(292,220,0,1,11,4),(292,221,0,1,11,4),(292,222,0,1,11,4),(292,223,0,1,11,4),(292,224,0,1,11,4),(293,225,0,1,11,4),(293,226,0,1,11,4),(293,227,0,1,11,4),(293,228,0,1,11,4),(293,229,0,1,11,4),(293,230,0,1,11,4),(293,231,0,1,11,4),(293,232,0,1,11,4),(293,255,0,1,11,4),(293,259,0,1,11,4),(293,260,0,1,11,4),(293,261,0,1,11,4),(293,262,0,1,11,4),(293,263,0,1,11,4),(294,233,0,1,11,4),(294,234,0,1,11,4),(294,235,0,1,11,4),(294,236,0,1,11,4),(294,237,0,1,11,4),(294,238,0,1,11,4),(294,239,0,1,11,4),(294,240,0,1,11,4),(294,241,0,1,11,4),(295,244,0,1,11,4),(295,246,0,1,11,4),(295,251,0,1,11,4),(295,255,0,1,11,4),(295,258,0,1,11,4),(296,251,0,1,11,4),(296,255,0,1,11,4),(296,258,0,1,11,4),(297,246,0,1,11,4),(297,255,0,1,11,4),(297,258,0,1,11,4),(298,255,0,1,11,4),(298,258,0,1,11,4),(299,251,0,1,11,4),(299,258,0,1,11,4);
/*!40000 ALTER TABLE `catalog_category_product_index_store11_replica` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index_store12`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store12`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store12` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `IDX_16609E051506ED4B6244E0113C273205` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_4428CAC3271DF82611D82D3FF2E50FBB` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Product Index Store12';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index_store12`
--

LOCK TABLES `catalog_category_product_index_store12` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index_store12` DISABLE KEYS */;
INSERT INTO `catalog_category_product_index_store12` VALUES (2,1,0,1,12,4),(2,2,0,1,12,4),(2,3,0,1,12,4),(2,4,0,1,12,4),(2,5,0,1,12,4),(2,6,0,1,12,4),(2,7,0,1,12,4),(2,8,0,1,12,4),(2,9,0,1,12,4),(2,10,0,1,12,4),(2,11,0,1,12,4),(2,12,0,1,12,4),(2,13,0,1,12,4),(2,14,0,1,12,4),(2,15,0,1,12,4),(2,16,0,1,12,4),(2,17,0,1,12,4),(2,18,0,1,12,4),(2,19,0,1,12,4),(2,20,0,1,12,4),(2,21,0,1,12,4),(2,22,0,1,12,4),(2,23,0,1,12,4),(2,24,0,1,12,4),(2,25,0,1,12,4),(2,26,0,1,12,4),(2,27,0,1,12,4),(2,28,0,1,12,4),(2,29,0,1,12,4),(2,30,0,1,12,4),(2,31,0,1,12,4),(2,32,0,1,12,4),(2,33,0,1,12,4),(2,34,0,1,12,4),(2,35,0,1,12,4),(2,36,0,1,12,4),(2,37,0,1,12,4),(2,38,0,1,12,4),(2,39,0,1,12,4),(2,40,0,1,12,4),(2,41,0,1,12,4),(2,42,0,1,12,4),(2,43,0,1,12,4),(2,44,0,1,12,4),(2,45,0,1,12,4),(2,46,0,1,12,4),(2,47,0,1,12,4),(2,48,0,1,12,4),(2,49,0,1,12,4),(2,50,0,1,12,4),(2,57,0,1,12,4),(2,58,0,1,12,4),(2,59,0,1,12,4),(2,60,0,1,12,4),(2,61,0,1,12,4),(2,62,0,1,12,4),(2,63,0,1,12,4),(2,64,0,1,12,4),(2,65,0,1,12,4),(2,66,0,1,12,4),(2,68,0,1,12,4),(2,69,0,1,12,4),(2,70,0,1,12,4),(2,71,0,1,12,4),(2,72,0,1,12,4),(2,73,0,1,12,4),(2,74,0,1,12,4),(2,75,0,1,12,4),(2,76,0,1,12,4),(2,77,0,1,12,4),(2,78,0,1,12,4),(2,79,0,1,12,4),(2,80,0,1,12,4),(2,81,0,1,12,4),(2,82,0,1,12,4),(2,83,0,1,12,4),(2,84,0,1,12,4),(2,85,0,1,12,4),(2,86,0,1,12,4),(2,87,0,1,12,4),(2,88,0,1,12,4),(2,89,0,1,12,4),(2,90,0,1,12,4),(2,91,0,1,12,4),(2,92,0,1,12,4),(2,93,0,1,12,4),(2,94,0,1,12,4),(2,95,0,1,12,4),(2,96,0,1,12,4),(2,97,0,1,12,4),(2,98,0,1,12,4),(2,99,0,1,12,4),(2,100,0,1,12,4),(2,101,0,1,12,4),(2,102,0,1,12,4),(2,103,0,1,12,4),(2,104,0,1,12,4),(2,105,0,1,12,4),(2,106,0,1,12,4),(2,107,0,1,12,4),(2,108,0,1,12,4),(2,109,0,1,12,4),(2,110,0,1,12,4),(2,111,0,1,12,4),(2,112,0,1,12,4),(2,113,0,1,12,4),(2,114,0,1,12,4),(2,115,0,1,12,4),(2,116,0,1,12,4),(2,117,0,1,12,4),(2,118,0,1,12,4),(2,119,0,1,12,4),(2,120,0,1,12,4),(2,121,0,1,12,4),(2,122,0,1,12,4),(2,123,0,1,12,4),(2,124,0,1,12,4),(2,125,0,1,12,4),(2,126,0,1,12,4),(2,127,0,1,12,4),(2,128,0,1,12,4),(2,129,0,1,12,4),(2,130,0,1,12,4),(2,131,0,1,12,4),(2,132,0,1,12,4),(2,133,0,1,12,4),(2,134,0,1,12,4),(2,135,0,1,12,4),(2,136,0,1,12,4),(2,137,0,1,12,4),(2,138,0,1,12,4),(2,139,0,1,12,4),(2,140,0,1,12,4),(2,141,0,1,12,4),(2,142,0,1,12,4),(2,143,0,1,12,4),(2,144,0,1,12,4),(2,145,0,1,12,4),(2,146,0,1,12,4),(2,147,0,1,12,4),(2,148,0,1,12,4),(2,149,0,1,12,4),(2,150,0,1,12,4),(2,151,0,1,12,4),(2,152,0,1,12,4),(2,153,0,1,12,4),(2,154,0,1,12,4),(2,155,0,1,12,4),(2,156,0,1,12,4),(2,157,0,1,12,4),(2,158,0,1,12,4),(2,159,0,1,12,4),(2,160,0,1,12,4),(2,161,0,1,12,4),(2,162,0,1,12,4),(2,163,0,1,12,4),(2,164,0,1,12,4),(2,165,0,1,12,4),(2,166,0,1,12,4),(2,167,0,1,12,4),(2,168,0,1,12,4),(2,169,0,1,12,4),(2,170,0,1,12,4),(2,171,0,1,12,4),(2,172,0,1,12,4),(2,173,0,1,12,4),(2,174,0,1,12,4),(2,175,0,1,12,4),(2,176,0,1,12,4),(2,177,0,1,12,4),(2,178,0,1,12,4),(2,179,0,1,12,4),(2,180,0,1,12,4),(2,181,0,1,12,4),(2,182,0,1,12,4),(2,183,0,1,12,4),(2,184,0,1,12,4),(2,185,0,1,12,4),(2,186,0,1,12,4),(2,187,0,1,12,4),(2,188,0,1,12,4),(2,189,0,1,12,4),(2,190,0,1,12,4),(2,191,0,1,12,4),(2,192,0,1,12,4),(2,193,0,1,12,4),(2,194,0,1,12,4),(2,195,0,1,12,4),(2,196,0,1,12,4),(2,197,0,1,12,4),(2,198,0,1,12,4),(2,199,0,1,12,4),(2,200,0,1,12,4),(2,201,0,1,12,4),(2,202,0,1,12,4),(2,203,0,1,12,4),(2,204,0,1,12,4),(2,205,0,1,12,4),(2,206,0,1,12,4),(2,207,0,1,12,4),(2,208,0,1,12,4),(2,209,0,1,12,4),(2,210,0,1,12,4),(2,211,0,1,12,4),(2,212,0,1,12,4),(2,213,0,1,12,4),(2,214,0,1,12,4),(2,215,0,1,12,4),(2,216,0,1,12,4),(2,217,0,1,12,4),(2,218,0,1,12,4),(2,219,0,1,12,4),(2,220,0,1,12,4),(2,221,0,1,12,4),(2,222,0,1,12,4),(2,223,0,1,12,4),(2,224,0,1,12,4),(2,225,0,1,12,4),(2,226,0,1,12,4),(2,227,0,1,12,4),(2,228,0,1,12,4),(2,229,0,1,12,4),(2,230,0,1,12,4),(2,231,0,1,12,4),(2,232,0,1,12,4),(2,233,0,1,12,4),(2,234,0,1,12,4),(2,235,0,1,12,4),(2,236,0,1,12,4),(2,237,0,1,12,4),(2,238,0,1,12,4),(2,239,0,1,12,4),(2,240,0,1,12,4),(2,241,0,1,12,4),(2,244,0,1,12,4),(2,246,0,1,12,4),(2,251,0,1,12,4),(2,255,0,1,12,4),(2,258,0,1,12,4),(2,259,0,1,12,4),(2,260,0,1,12,4),(2,261,0,1,12,4),(2,262,0,1,12,4),(2,263,0,1,12,4),(3,1,0,1,12,4),(3,2,0,1,12,4),(3,3,0,1,12,4),(3,4,0,1,12,4),(3,5,0,1,12,4),(3,6,0,1,12,4),(3,7,0,1,12,4),(3,8,0,1,12,4),(3,10,0,1,12,4),(3,11,0,1,12,4),(4,12,0,1,12,4),(4,13,0,1,12,4),(4,14,0,1,12,4),(4,15,0,1,12,4),(4,16,0,1,12,4),(4,17,0,1,12,4),(4,18,0,1,12,4),(4,19,0,1,12,4),(4,36,0,1,12,4),(4,37,0,1,12,4),(4,38,0,1,12,4),(4,39,0,1,12,4),(4,40,0,1,12,4),(5,95,10000,0,12,4),(5,96,10000,0,12,4),(5,97,10000,0,12,4),(5,98,10000,0,12,4),(5,99,10000,0,12,4),(5,100,10000,0,12,4),(7,101,10000,0,12,4),(7,102,10000,0,12,4),(7,103,10000,0,12,4),(7,104,10000,0,12,4),(7,105,10000,0,12,4),(7,106,10000,0,12,4),(7,107,10000,0,12,4),(7,108,10000,0,12,4),(7,109,10000,0,12,4),(7,110,10000,0,12,4),(7,111,10000,0,12,4),(7,112,10000,0,12,4),(7,21,0,1,12,4),(7,22,0,1,12,4),(7,26,0,1,12,4),(8,61,0,1,12,4),(8,62,0,1,12,4),(8,63,0,1,12,4),(8,64,0,1,12,4),(8,65,0,1,12,4),(8,66,0,1,12,4),(11,4,10000,0,12,4),(11,89,10000,0,12,4),(11,90,10000,0,12,4),(11,91,10000,0,12,4),(11,92,10000,0,12,4),(11,93,10000,0,12,4),(11,94,10000,0,12,4),(11,28,0,1,12,4),(11,29,0,1,12,4),(11,30,0,1,12,4),(11,31,0,1,12,4),(11,32,0,1,12,4),(11,33,0,1,12,4),(11,34,0,1,12,4),(11,35,0,1,12,4),(13,21,0,1,12,4),(13,24,0,1,12,4),(13,25,0,1,12,4),(13,26,0,1,12,4),(13,27,0,1,12,4),(13,41,0,1,12,4),(13,42,0,1,12,4),(13,43,0,1,12,4),(13,44,0,1,12,4),(13,45,0,1,12,4),(13,46,0,1,12,4),(13,47,0,1,12,4),(13,48,0,1,12,4),(13,49,0,1,12,4),(15,22,10000,0,12,4),(15,23,10000,0,12,4),(16,20,0,1,12,4),(16,21,0,1,12,4),(16,22,0,1,12,4),(16,23,0,1,12,4),(16,24,0,1,12,4),(16,25,0,1,12,4),(16,26,0,1,12,4),(16,27,0,1,12,4),(16,41,0,1,12,4),(16,68,0,1,12,4),(16,69,0,1,12,4),(16,70,0,1,12,4),(16,71,0,1,12,4),(16,72,0,1,12,4),(16,73,0,1,12,4),(19,6,0,1,12,4),(19,7,0,1,12,4),(19,8,0,1,12,4),(19,10,0,1,12,4),(19,11,0,1,12,4),(27,11,0,1,12,4),(29,6,0,1,12,4),(29,8,0,1,12,4),(29,10,0,1,12,4),(30,6,0,1,12,4),(30,10,0,1,12,4),(33,7,0,1,12,4),(33,8,0,1,12,4),(33,10,0,1,12,4),(33,11,0,1,12,4),(42,7,0,1,12,4),(42,8,0,1,12,4),(42,11,0,1,12,4),(78,21,0,1,12,4),(78,26,0,1,12,4),(80,21,0,1,12,4),(80,22,0,1,12,4),(80,26,0,1,12,4),(81,26,0,1,12,4),(82,26,0,1,12,4),(83,26,0,1,12,4),(96,26,0,1,12,4),(97,26,0,1,12,4),(98,21,0,1,12,4),(98,22,0,1,12,4),(98,26,0,1,12,4),(99,18,0,1,12,4),(101,14,0,1,12,4),(101,15,0,1,12,4),(101,16,0,1,12,4),(102,12,0,1,12,4),(102,13,0,1,12,4),(102,14,0,1,12,4),(102,15,0,1,12,4),(102,16,0,1,12,4),(102,17,0,1,12,4),(102,19,0,1,12,4),(102,36,0,1,12,4),(102,37,0,1,12,4),(102,38,0,1,12,4),(102,39,0,1,12,4),(102,40,0,1,12,4),(103,18,0,1,12,4),(104,18,0,1,12,4),(105,18,0,1,12,4),(106,18,0,1,12,4),(107,18,0,1,12,4),(134,23,0,1,12,4),(135,22,0,1,12,4),(137,4,0,1,12,4),(137,28,0,1,12,4),(137,31,0,1,12,4),(137,34,0,1,12,4),(137,35,0,1,12,4),(138,28,0,1,12,4),(138,30,0,1,12,4),(138,32,0,1,12,4),(138,33,0,1,12,4),(139,28,0,1,12,4),(139,30,0,1,12,4),(139,32,0,1,12,4),(139,33,0,1,12,4),(140,28,0,1,12,4),(140,30,0,1,12,4),(140,32,0,1,12,4),(140,33,0,1,12,4),(145,1,0,1,12,4),(145,2,0,1,12,4),(145,3,0,1,12,4),(145,4,0,1,12,4),(145,5,0,1,12,4),(145,6,0,1,12,4),(145,7,0,1,12,4),(145,8,0,1,12,4),(145,9,0,1,12,4),(145,10,0,1,12,4),(145,11,0,1,12,4),(145,12,0,1,12,4),(145,13,0,1,12,4),(145,14,0,1,12,4),(145,15,0,1,12,4),(145,16,0,1,12,4),(145,17,0,1,12,4),(145,18,0,1,12,4),(145,19,0,1,12,4),(145,20,0,1,12,4),(145,21,0,1,12,4),(145,22,0,1,12,4),(145,23,0,1,12,4),(145,24,0,1,12,4),(145,25,0,1,12,4),(145,26,0,1,12,4),(145,27,0,1,12,4),(145,28,0,1,12,4),(145,29,0,1,12,4),(145,30,0,1,12,4),(145,31,0,1,12,4),(145,32,0,1,12,4),(145,33,0,1,12,4),(145,34,0,1,12,4),(145,35,0,1,12,4),(145,36,0,1,12,4),(145,37,0,1,12,4),(145,38,0,1,12,4),(145,39,0,1,12,4),(145,40,0,1,12,4),(145,41,0,1,12,4),(145,42,0,1,12,4),(145,43,0,1,12,4),(149,41,0,1,12,4),(150,50,0,1,12,4),(150,57,0,1,12,4),(150,58,0,1,12,4),(150,59,0,1,12,4),(150,60,0,1,12,4),(151,61,0,1,12,4),(151,62,0,1,12,4),(151,63,0,1,12,4),(151,64,0,1,12,4),(151,65,0,1,12,4),(151,66,0,1,12,4),(152,61,0,1,12,4),(152,63,0,1,12,4),(153,61,0,1,12,4),(153,63,0,1,12,4),(153,64,0,1,12,4),(153,65,0,1,12,4),(153,66,0,1,12,4),(154,61,0,1,12,4),(154,62,0,1,12,4),(154,64,0,1,12,4),(154,66,0,1,12,4),(155,61,0,1,12,4),(155,62,0,1,12,4),(155,64,0,1,12,4),(155,65,0,1,12,4),(155,66,0,1,12,4),(156,61,0,1,12,4),(156,62,0,1,12,4),(156,63,0,1,12,4),(156,64,0,1,12,4),(156,65,0,1,12,4),(156,66,0,1,12,4),(157,61,0,1,12,4),(157,62,0,1,12,4),(157,64,0,1,12,4),(157,65,0,1,12,4),(157,66,0,1,12,4),(158,61,0,1,12,4),(158,63,0,1,12,4),(158,64,0,1,12,4),(158,65,0,1,12,4),(158,66,0,1,12,4),(159,61,0,1,12,4),(159,62,0,1,12,4),(159,63,0,1,12,4),(159,64,0,1,12,4),(159,65,0,1,12,4),(159,66,0,1,12,4),(160,41,0,1,12,4),(160,68,0,1,12,4),(160,69,0,1,12,4),(160,70,0,1,12,4),(160,72,0,1,12,4),(160,73,0,1,12,4),(161,68,0,1,12,4),(161,69,0,1,12,4),(161,70,0,1,12,4),(161,71,0,1,12,4),(161,72,0,1,12,4),(162,68,0,1,12,4),(162,69,0,1,12,4),(162,72,0,1,12,4),(164,41,0,1,12,4),(164,70,0,1,12,4),(164,73,0,1,12,4),(166,41,0,1,12,4),(166,70,0,1,12,4),(166,73,0,1,12,4),(167,68,0,1,12,4),(167,69,0,1,12,4),(167,72,0,1,12,4),(168,71,0,1,12,4),(169,70,0,1,12,4),(171,70,0,1,12,4),(172,1,10000,0,12,4),(172,2,10000,0,12,4),(172,3,10000,0,12,4),(172,4,10000,0,12,4),(172,5,10000,0,12,4),(172,6,10000,0,12,4),(172,7,10000,0,12,4),(172,8,10000,0,12,4),(172,9,10000,0,12,4),(172,10,10000,0,12,4),(172,11,10000,0,12,4),(172,12,10000,0,12,4),(172,13,10000,0,12,4),(172,14,10000,0,12,4),(172,15,10000,0,12,4),(172,16,10000,0,12,4),(172,17,10000,0,12,4),(172,18,10000,0,12,4),(172,19,10000,0,12,4),(172,20,10000,0,12,4),(172,21,10000,0,12,4),(172,22,10000,0,12,4),(172,23,10000,0,12,4),(172,24,10000,0,12,4),(172,25,10000,0,12,4),(172,26,10000,0,12,4),(172,27,10000,0,12,4),(172,28,10000,0,12,4),(172,29,10000,0,12,4),(172,30,10000,0,12,4),(173,1,0,1,12,4),(173,2,0,1,12,4),(173,3,0,1,12,4),(173,4,0,1,12,4),(173,5,0,1,12,4),(173,6,0,1,12,4),(173,7,0,1,12,4),(173,8,0,1,12,4),(173,9,0,1,12,4),(173,10,0,1,12,4),(173,11,0,1,12,4),(173,12,0,1,12,4),(173,13,0,1,12,4),(173,14,0,1,12,4),(173,15,0,1,12,4),(173,16,0,1,12,4),(173,17,0,1,12,4),(173,18,0,1,12,4),(173,19,0,1,12,4),(173,20,0,1,12,4),(173,21,0,1,12,4),(173,22,0,1,12,4),(173,23,0,1,12,4),(173,24,0,1,12,4),(173,25,0,1,12,4),(173,26,0,1,12,4),(173,27,0,1,12,4),(173,28,0,1,12,4),(173,29,0,1,12,4),(173,30,0,1,12,4),(174,1,0,1,12,4),(174,2,0,1,12,4),(174,3,0,1,12,4),(174,4,0,1,12,4),(174,5,0,1,12,4),(174,6,0,1,12,4),(174,7,0,1,12,4),(174,8,0,1,12,4),(174,9,0,1,12,4),(174,10,0,1,12,4),(174,11,0,1,12,4),(174,12,0,1,12,4),(174,13,0,1,12,4),(174,14,0,1,12,4),(174,15,0,1,12,4),(174,16,0,1,12,4),(174,17,0,1,12,4),(174,18,0,1,12,4),(174,19,0,1,12,4),(174,20,0,1,12,4),(174,21,0,1,12,4),(174,22,0,1,12,4),(174,23,0,1,12,4),(174,24,0,1,12,4),(174,25,0,1,12,4),(174,26,0,1,12,4),(174,27,0,1,12,4),(174,28,0,1,12,4),(174,29,0,1,12,4),(174,30,0,1,12,4),(175,1,0,1,12,4),(175,2,0,1,12,4),(175,3,0,1,12,4),(175,4,0,1,12,4),(175,5,0,1,12,4),(175,6,0,1,12,4),(175,7,0,1,12,4),(175,8,0,1,12,4),(175,9,0,1,12,4),(175,10,0,1,12,4),(175,11,0,1,12,4),(175,12,0,1,12,4),(175,13,0,1,12,4),(175,14,0,1,12,4),(175,15,0,1,12,4),(175,16,0,1,12,4),(175,17,0,1,12,4),(175,18,0,1,12,4),(175,19,0,1,12,4),(175,20,0,1,12,4),(175,21,0,1,12,4),(175,22,0,1,12,4),(175,23,0,1,12,4),(175,24,0,1,12,4),(175,25,0,1,12,4),(175,26,0,1,12,4),(175,27,0,1,12,4),(175,28,0,1,12,4),(175,29,0,1,12,4),(175,30,0,1,12,4),(176,1,0,1,12,4),(176,2,0,1,12,4),(176,3,0,1,12,4),(176,4,0,1,12,4),(176,5,0,1,12,4),(176,6,0,1,12,4),(176,7,0,1,12,4),(176,8,0,1,12,4),(176,9,0,1,12,4),(176,10,0,1,12,4),(176,11,0,1,12,4),(176,12,0,1,12,4),(176,13,0,1,12,4),(176,14,0,1,12,4),(176,15,0,1,12,4),(176,16,0,1,12,4),(176,17,0,1,12,4),(176,18,0,1,12,4),(176,19,0,1,12,4),(176,20,0,1,12,4),(176,21,0,1,12,4),(176,22,0,1,12,4),(176,23,0,1,12,4),(176,24,0,1,12,4),(176,25,0,1,12,4),(176,26,0,1,12,4),(176,27,0,1,12,4),(176,28,0,1,12,4),(176,29,0,1,12,4),(176,30,0,1,12,4),(177,74,0,1,12,4),(177,75,0,1,12,4),(177,76,0,1,12,4),(177,77,0,1,12,4),(177,78,0,1,12,4),(177,79,0,1,12,4),(177,80,0,1,12,4),(178,74,10000,0,12,4),(178,75,10000,0,12,4),(178,76,10000,0,12,4),(178,77,10000,0,12,4),(178,78,10000,0,12,4),(178,79,10000,0,12,4),(178,80,10000,0,12,4),(178,81,10000,0,12,4),(178,82,10000,0,12,4),(178,83,10000,0,12,4),(178,84,10000,0,12,4),(178,85,10000,0,12,4),(178,86,10000,0,12,4),(178,87,10000,0,12,4),(178,88,10000,0,12,4),(178,113,10000,0,12,4),(178,114,10000,0,12,4),(178,115,10000,0,12,4),(178,116,10000,0,12,4),(178,117,10000,0,12,4),(178,118,10000,0,12,4),(178,119,10000,0,12,4),(178,120,10000,0,12,4),(178,121,10000,0,12,4),(178,122,10000,0,12,4),(178,123,10000,0,12,4),(178,124,10000,0,12,4),(178,125,10000,0,12,4),(178,126,10000,0,12,4),(178,127,10000,0,12,4),(178,128,10000,0,12,4),(178,129,10000,0,12,4),(178,130,10000,0,12,4),(178,131,10000,0,12,4),(178,132,10000,0,12,4),(178,133,10000,0,12,4),(178,134,10000,0,12,4),(178,135,10000,0,12,4),(178,136,10000,0,12,4),(178,137,10000,0,12,4),(178,138,10000,0,12,4),(178,139,10000,0,12,4),(178,140,10000,0,12,4),(178,141,10000,0,12,4),(178,142,10000,0,12,4),(178,143,10000,0,12,4),(178,144,10000,0,12,4),(178,145,10000,0,12,4),(178,146,10000,0,12,4),(178,147,10000,0,12,4),(178,148,10000,0,12,4),(178,149,10000,0,12,4),(178,150,10000,0,12,4),(178,151,10000,0,12,4),(178,152,10000,0,12,4),(178,153,10000,0,12,4),(178,154,10000,0,12,4),(178,155,10000,0,12,4),(178,156,10000,0,12,4),(178,157,10000,0,12,4),(178,158,10000,0,12,4),(178,159,10000,0,12,4),(178,160,10000,0,12,4),(178,161,10000,0,12,4),(178,162,10000,0,12,4),(178,163,10000,0,12,4),(178,164,10000,0,12,4),(178,165,10000,0,12,4),(178,166,10000,0,12,4),(178,167,10000,0,12,4),(178,168,10000,0,12,4),(178,169,10000,0,12,4),(178,170,10000,0,12,4),(178,171,10000,0,12,4),(178,172,10000,0,12,4),(178,173,10000,0,12,4),(178,174,10000,0,12,4),(178,175,10000,0,12,4),(178,176,10000,0,12,4),(178,177,10000,0,12,4),(178,178,10000,0,12,4),(178,179,10000,0,12,4),(178,180,10000,0,12,4),(178,181,10000,0,12,4),(178,182,10000,0,12,4),(178,183,10000,0,12,4),(178,184,10000,0,12,4),(178,185,10000,0,12,4),(178,186,10000,0,12,4),(178,187,10000,0,12,4),(178,188,10000,0,12,4),(178,189,10000,0,12,4),(178,190,10000,0,12,4),(178,191,10000,0,12,4),(178,192,10000,0,12,4),(178,193,10000,0,12,4),(178,194,10000,0,12,4),(178,195,10000,0,12,4),(178,196,10000,0,12,4),(178,197,10000,0,12,4),(178,198,10000,0,12,4),(178,199,10000,0,12,4),(178,200,10000,0,12,4),(178,201,10000,0,12,4),(178,202,10000,0,12,4),(178,203,10000,0,12,4),(178,204,10000,0,12,4),(178,205,10000,0,12,4),(178,206,10000,0,12,4),(178,207,10000,0,12,4),(178,208,10000,0,12,4),(178,209,10000,0,12,4),(178,210,10000,0,12,4),(178,211,10000,0,12,4),(178,212,10000,0,12,4),(178,213,10000,0,12,4),(178,214,10000,0,12,4),(178,215,10000,0,12,4),(178,216,10000,0,12,4),(178,217,10000,0,12,4),(178,218,10000,0,12,4),(178,219,10000,0,12,4),(178,220,10000,0,12,4),(178,221,10000,0,12,4),(178,222,10000,0,12,4),(178,223,10000,0,12,4),(178,224,10000,0,12,4),(178,225,10000,0,12,4),(178,226,10000,0,12,4),(178,227,10000,0,12,4),(178,228,10000,0,12,4),(178,229,10000,0,12,4),(178,230,10000,0,12,4),(178,231,10000,0,12,4),(178,232,10000,0,12,4),(178,233,10000,0,12,4),(178,234,10000,0,12,4),(178,235,10000,0,12,4),(178,236,10000,0,12,4),(178,237,10000,0,12,4),(178,238,10000,0,12,4),(178,239,10000,0,12,4),(178,240,10000,0,12,4),(178,241,10000,0,12,4),(178,244,10000,0,12,4),(178,246,10000,0,12,4),(178,251,10000,0,12,4),(178,255,10000,0,12,4),(178,258,10000,0,12,4),(178,259,10000,0,12,4),(178,260,10000,0,12,4),(178,261,10000,0,12,4),(178,262,10000,0,12,4),(178,263,10000,0,12,4),(179,81,0,1,12,4),(179,82,0,1,12,4),(179,83,0,1,12,4),(179,84,0,1,12,4),(179,85,0,1,12,4),(179,86,0,1,12,4),(179,87,0,1,12,4),(179,88,0,1,12,4),(180,81,0,1,12,4),(181,86,0,1,12,4),(182,82,0,1,12,4),(182,83,0,1,12,4),(182,84,0,1,12,4),(182,85,0,1,12,4),(182,87,0,1,12,4),(182,88,0,1,12,4),(183,82,0,1,12,4),(183,83,0,1,12,4),(183,84,0,1,12,4),(183,85,0,1,12,4),(183,86,0,1,12,4),(183,87,0,1,12,4),(183,88,0,1,12,4),(192,89,0,1,12,4),(192,90,0,1,12,4),(192,91,0,1,12,4),(192,92,0,1,12,4),(192,93,0,1,12,4),(192,94,0,1,12,4),(193,95,0,1,12,4),(193,96,0,1,12,4),(193,97,0,1,12,4),(193,98,0,1,12,4),(193,99,0,1,12,4),(193,100,0,1,12,4),(194,95,0,1,12,4),(194,96,0,1,12,4),(194,97,0,1,12,4),(194,98,0,1,12,4),(194,99,0,1,12,4),(194,100,0,1,12,4),(195,95,0,1,12,4),(195,96,0,1,12,4),(195,97,0,1,12,4),(195,98,0,1,12,4),(195,99,0,1,12,4),(195,100,0,1,12,4),(196,95,0,1,12,4),(196,96,0,1,12,4),(196,97,0,1,12,4),(196,98,0,1,12,4),(196,99,0,1,12,4),(196,100,0,1,12,4),(197,95,0,1,12,4),(197,96,0,1,12,4),(197,97,0,1,12,4),(197,98,0,1,12,4),(197,99,0,1,12,4),(197,100,0,1,12,4),(198,101,0,1,12,4),(198,109,0,1,12,4),(198,111,0,1,12,4),(198,112,0,1,12,4),(199,103,0,1,12,4),(199,110,0,1,12,4),(200,101,0,1,12,4),(200,102,0,1,12,4),(200,108,0,1,12,4),(201,104,0,1,12,4),(201,106,0,1,12,4),(202,101,0,1,12,4),(202,102,0,1,12,4),(202,103,0,1,12,4),(202,105,0,1,12,4),(202,107,0,1,12,4),(202,108,0,1,12,4),(202,110,0,1,12,4),(203,101,0,1,12,4),(203,102,0,1,12,4),(203,103,0,1,12,4),(203,104,0,1,12,4),(203,106,0,1,12,4),(203,108,0,1,12,4),(203,109,0,1,12,4),(204,101,0,1,12,4),(204,102,0,1,12,4),(204,103,0,1,12,4),(204,104,0,1,12,4),(204,105,0,1,12,4),(204,106,0,1,12,4),(204,107,0,1,12,4),(204,108,0,1,12,4),(205,101,0,1,12,4),(205,102,0,1,12,4),(205,103,0,1,12,4),(205,108,0,1,12,4),(205,109,0,1,12,4),(205,110,0,1,12,4),(205,111,0,1,12,4),(205,112,0,1,12,4),(206,113,10000,0,12,4),(206,114,10000,0,12,4),(206,115,10000,0,12,4),(206,116,10000,0,12,4),(206,117,10000,0,12,4),(206,118,10000,0,12,4),(206,119,10000,0,12,4),(207,114,0,1,12,4),(207,119,0,1,12,4),(209,114,0,1,12,4),(212,116,0,1,12,4),(212,118,0,1,12,4),(213,113,0,1,12,4),(218,117,0,1,12,4),(219,119,0,1,12,4),(220,119,0,1,12,4),(221,119,0,1,12,4),(222,114,0,1,12,4),(222,119,0,1,12,4),(223,114,0,1,12,4),(223,119,0,1,12,4),(229,113,0,1,12,4),(230,113,0,1,12,4),(231,113,0,1,12,4),(232,113,0,1,12,4),(233,113,0,1,12,4),(234,116,0,1,12,4),(234,118,0,1,12,4),(235,116,0,1,12,4),(235,118,0,1,12,4),(236,116,0,1,12,4),(236,118,0,1,12,4),(237,116,0,1,12,4),(237,118,0,1,12,4),(238,116,0,1,12,4),(238,118,0,1,12,4),(239,115,0,1,12,4),(241,115,0,1,12,4),(242,115,0,1,12,4),(243,115,0,1,12,4),(250,120,0,1,12,4),(250,121,0,1,12,4),(250,122,0,1,12,4),(250,123,0,1,12,4),(250,124,0,1,12,4),(250,125,0,1,12,4),(250,126,0,1,12,4),(250,127,0,1,12,4),(250,128,0,1,12,4),(250,129,0,1,12,4),(250,130,0,1,12,4),(250,131,0,1,12,4),(251,120,0,1,12,4),(251,121,0,1,12,4),(251,122,0,1,12,4),(251,123,0,1,12,4),(251,124,0,1,12,4),(251,125,0,1,12,4),(251,126,0,1,12,4),(251,127,0,1,12,4),(251,128,0,1,12,4),(251,129,0,1,12,4),(251,130,0,1,12,4),(251,131,0,1,12,4),(252,125,10000,0,12,4),(252,126,10000,0,12,4),(252,127,10000,0,12,4),(252,120,0,1,12,4),(252,121,0,1,12,4),(252,122,0,1,12,4),(252,123,0,1,12,4),(252,124,0,1,12,4),(252,128,0,1,12,4),(252,129,0,1,12,4),(252,131,0,1,12,4),(253,120,0,1,12,4),(253,121,0,1,12,4),(253,122,0,1,12,4),(253,123,0,1,12,4),(253,124,0,1,12,4),(253,125,0,1,12,4),(253,126,0,1,12,4),(253,127,0,1,12,4),(253,128,0,1,12,4),(253,129,0,1,12,4),(253,130,0,1,12,4),(253,131,0,1,12,4),(254,120,0,1,12,4),(254,121,0,1,12,4),(254,122,0,1,12,4),(254,123,0,1,12,4),(254,124,0,1,12,4),(254,125,0,1,12,4),(254,126,0,1,12,4),(254,127,0,1,12,4),(254,128,0,1,12,4),(254,129,0,1,12,4),(254,130,0,1,12,4),(254,131,0,1,12,4),(255,122,0,1,12,4),(255,123,0,1,12,4),(255,124,0,1,12,4),(255,125,0,1,12,4),(255,126,0,1,12,4),(255,129,0,1,12,4),(256,121,0,1,12,4),(256,122,0,1,12,4),(256,123,0,1,12,4),(256,125,0,1,12,4),(256,126,0,1,12,4),(256,127,0,1,12,4),(257,121,0,1,12,4),(257,122,0,1,12,4),(257,123,0,1,12,4),(257,125,0,1,12,4),(257,127,0,1,12,4),(257,129,0,1,12,4),(258,121,0,1,12,4),(258,122,0,1,12,4),(258,125,0,1,12,4),(258,126,0,1,12,4),(258,127,0,1,12,4),(258,129,0,1,12,4),(259,120,0,1,12,4),(259,121,0,1,12,4),(259,123,0,1,12,4),(259,128,0,1,12,4),(259,129,0,1,12,4),(260,120,0,1,12,4),(260,121,0,1,12,4),(260,122,0,1,12,4),(260,123,0,1,12,4),(260,125,0,1,12,4),(260,127,0,1,12,4),(260,128,0,1,12,4),(260,129,0,1,12,4),(261,121,0,1,12,4),(261,122,0,1,12,4),(261,125,0,1,12,4),(261,126,0,1,12,4),(261,127,0,1,12,4),(261,129,0,1,12,4),(262,125,0,1,12,4),(262,126,0,1,12,4),(263,120,0,1,12,4),(263,121,0,1,12,4),(263,122,0,1,12,4),(263,123,0,1,12,4),(263,124,0,1,12,4),(263,128,0,1,12,4),(263,129,0,1,12,4),(263,131,0,1,12,4),(264,120,0,1,12,4),(264,122,0,1,12,4),(264,123,0,1,12,4),(264,125,0,1,12,4),(264,126,0,1,12,4),(264,129,0,1,12,4),(265,121,0,1,12,4),(265,122,0,1,12,4),(265,123,0,1,12,4),(265,127,0,1,12,4),(266,123,0,1,12,4),(266,125,0,1,12,4),(266,126,0,1,12,4),(266,127,0,1,12,4),(266,129,0,1,12,4),(267,121,0,1,12,4),(267,125,0,1,12,4),(267,126,0,1,12,4),(267,127,0,1,12,4),(268,120,0,1,12,4),(268,121,0,1,12,4),(268,122,0,1,12,4),(268,123,0,1,12,4),(268,124,0,1,12,4),(268,127,0,1,12,4),(268,129,0,1,12,4),(269,122,0,1,12,4),(269,125,0,1,12,4),(269,126,0,1,12,4),(269,127,0,1,12,4),(269,129,0,1,12,4),(270,121,0,1,12,4),(270,123,0,1,12,4),(270,125,0,1,12,4),(270,126,0,1,12,4),(270,129,0,1,12,4),(271,120,0,1,12,4),(271,121,0,1,12,4),(271,122,0,1,12,4),(271,125,0,1,12,4),(271,126,0,1,12,4),(271,127,0,1,12,4),(271,129,0,1,12,4),(272,122,0,1,12,4),(272,123,0,1,12,4),(272,124,0,1,12,4),(272,125,0,1,12,4),(272,126,0,1,12,4),(272,127,0,1,12,4),(272,128,0,1,12,4),(272,129,0,1,12,4),(273,120,0,1,12,4),(273,121,0,1,12,4),(273,123,0,1,12,4),(273,126,0,1,12,4),(273,127,0,1,12,4),(274,122,0,1,12,4),(274,123,0,1,12,4),(274,125,0,1,12,4),(274,126,0,1,12,4),(274,129,0,1,12,4),(275,120,0,1,12,4),(275,121,0,1,12,4),(275,122,0,1,12,4),(275,123,0,1,12,4),(275,124,0,1,12,4),(275,125,0,1,12,4),(275,126,0,1,12,4),(275,127,0,1,12,4),(275,128,0,1,12,4),(275,129,0,1,12,4),(275,130,0,1,12,4),(275,131,0,1,12,4),(276,122,0,1,12,4),(276,123,0,1,12,4),(276,127,0,1,12,4),(276,129,0,1,12,4),(277,120,0,1,12,4),(277,121,0,1,12,4),(277,123,0,1,12,4),(277,124,0,1,12,4),(277,125,0,1,12,4),(277,126,0,1,12,4),(277,127,0,1,12,4),(278,120,0,1,12,4),(278,121,0,1,12,4),(278,122,0,1,12,4),(278,123,0,1,12,4),(278,124,0,1,12,4),(278,125,0,1,12,4),(278,127,0,1,12,4),(278,128,0,1,12,4),(278,129,0,1,12,4),(279,120,0,1,12,4),(279,122,0,1,12,4),(279,126,0,1,12,4),(279,127,0,1,12,4),(279,129,0,1,12,4),(280,132,0,1,12,4),(280,133,0,1,12,4),(280,134,0,1,12,4),(280,135,0,1,12,4),(280,136,0,1,12,4),(280,137,0,1,12,4),(280,138,0,1,12,4),(280,139,0,1,12,4),(282,132,0,1,12,4),(282,133,0,1,12,4),(282,134,0,1,12,4),(282,137,0,1,12,4),(282,138,0,1,12,4),(283,135,0,1,12,4),(283,136,0,1,12,4),(283,139,0,1,12,4),(286,140,0,1,12,4),(286,141,0,1,12,4),(286,142,0,1,12,4),(286,143,0,1,12,4),(286,144,0,1,12,4),(286,145,0,1,12,4),(286,146,0,1,12,4),(286,147,0,1,12,4),(286,148,0,1,12,4),(286,149,0,1,12,4),(286,150,0,1,12,4),(286,151,0,1,12,4),(286,152,0,1,12,4),(286,153,0,1,12,4),(286,154,0,1,12,4),(286,155,0,1,12,4),(286,156,0,1,12,4),(286,157,0,1,12,4),(286,158,0,1,12,4),(286,159,0,1,12,4),(286,160,0,1,12,4),(286,161,0,1,12,4),(286,162,0,1,12,4),(286,163,0,1,12,4),(286,164,0,1,12,4),(286,165,0,1,12,4),(286,166,0,1,12,4),(286,167,0,1,12,4),(286,168,0,1,12,4),(286,169,0,1,12,4),(286,170,0,1,12,4),(286,171,0,1,12,4),(286,172,0,1,12,4),(286,173,0,1,12,4),(286,174,0,1,12,4),(286,175,0,1,12,4),(286,176,0,1,12,4),(286,177,0,1,12,4),(286,178,0,1,12,4),(286,179,0,1,12,4),(286,180,0,1,12,4),(286,181,0,1,12,4),(286,182,0,1,12,4),(286,183,0,1,12,4),(286,184,0,1,12,4),(286,185,0,1,12,4),(286,186,0,1,12,4),(286,187,0,1,12,4),(287,188,0,1,12,4),(288,189,0,1,12,4),(288,190,0,1,12,4),(288,191,0,1,12,4),(288,192,0,1,12,4),(288,193,0,1,12,4),(288,194,0,1,12,4),(288,195,0,1,12,4),(288,196,0,1,12,4),(288,197,0,1,12,4),(288,198,0,1,12,4),(288,199,0,1,12,4),(288,200,0,1,12,4),(289,201,10000,0,12,4),(289,202,10000,0,12,4),(289,203,10000,0,12,4),(289,204,10000,0,12,4),(289,205,10000,0,12,4),(289,206,10000,0,12,4),(289,207,10000,0,12,4),(289,208,10000,0,12,4),(289,209,10000,0,12,4),(289,210,10000,0,12,4),(289,211,10000,0,12,4),(289,212,10000,0,12,4),(289,213,10000,0,12,4),(289,214,10000,0,12,4),(289,215,10000,0,12,4),(289,216,10000,0,12,4),(289,217,10000,0,12,4),(289,218,10000,0,12,4),(289,219,10000,0,12,4),(289,220,10000,0,12,4),(289,221,10000,0,12,4),(289,222,10000,0,12,4),(289,223,10000,0,12,4),(289,224,10000,0,12,4),(289,225,10000,0,12,4),(289,226,10000,0,12,4),(289,227,10000,0,12,4),(289,228,10000,0,12,4),(289,229,10000,0,12,4),(289,230,10000,0,12,4),(289,231,10000,0,12,4),(289,232,10000,0,12,4),(289,244,10000,0,12,4),(289,246,10000,0,12,4),(289,251,10000,0,12,4),(289,255,10000,0,12,4),(289,258,10000,0,12,4),(289,259,10000,0,12,4),(289,260,10000,0,12,4),(289,261,10000,0,12,4),(289,262,10000,0,12,4),(289,263,10000,0,12,4),(290,209,0,1,12,4),(290,210,0,1,12,4),(290,211,0,1,12,4),(290,212,0,1,12,4),(290,213,0,1,12,4),(290,214,0,1,12,4),(290,215,0,1,12,4),(290,216,0,1,12,4),(291,201,0,1,12,4),(291,202,0,1,12,4),(291,203,0,1,12,4),(291,204,0,1,12,4),(291,205,0,1,12,4),(291,206,0,1,12,4),(291,207,0,1,12,4),(291,208,0,1,12,4),(292,217,0,1,12,4),(292,218,0,1,12,4),(292,219,0,1,12,4),(292,220,0,1,12,4),(292,221,0,1,12,4),(292,222,0,1,12,4),(292,223,0,1,12,4),(292,224,0,1,12,4),(293,225,0,1,12,4),(293,226,0,1,12,4),(293,227,0,1,12,4),(293,228,0,1,12,4),(293,229,0,1,12,4),(293,230,0,1,12,4),(293,231,0,1,12,4),(293,232,0,1,12,4),(293,255,0,1,12,4),(293,259,0,1,12,4),(293,260,0,1,12,4),(293,261,0,1,12,4),(293,262,0,1,12,4),(293,263,0,1,12,4),(294,233,0,1,12,4),(294,234,0,1,12,4),(294,235,0,1,12,4),(294,236,0,1,12,4),(294,237,0,1,12,4),(294,238,0,1,12,4),(294,239,0,1,12,4),(294,240,0,1,12,4),(294,241,0,1,12,4),(295,244,0,1,12,4),(295,246,0,1,12,4),(295,251,0,1,12,4),(295,255,0,1,12,4),(295,258,0,1,12,4),(296,251,0,1,12,4),(296,255,0,1,12,4),(296,258,0,1,12,4),(297,246,0,1,12,4),(297,255,0,1,12,4),(297,258,0,1,12,4),(298,255,0,1,12,4),(298,258,0,1,12,4),(299,251,0,1,12,4),(299,258,0,1,12,4);
/*!40000 ALTER TABLE `catalog_category_product_index_store12` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index_store12_replica`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store12_replica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store12_replica` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `CAT_CTGR_PRD_IDX_STORE12_PRD_ID_STORE_ID_CTGR_ID_VISIBILITY` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_26FC86C5E205CE457A898997567F236E` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Product Index Store12 Replica';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index_store12_replica`
--

LOCK TABLES `catalog_category_product_index_store12_replica` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index_store12_replica` DISABLE KEYS */;
INSERT INTO `catalog_category_product_index_store12_replica` VALUES (2,1,0,1,12,4),(2,2,0,1,12,4),(2,3,0,1,12,4),(2,4,0,1,12,4),(2,5,0,1,12,4),(2,6,0,1,12,4),(2,7,0,1,12,4),(2,8,0,1,12,4),(2,9,0,1,12,4),(2,10,0,1,12,4),(2,11,0,1,12,4),(2,12,0,1,12,4),(2,13,0,1,12,4),(2,14,0,1,12,4),(2,15,0,1,12,4),(2,16,0,1,12,4),(2,17,0,1,12,4),(2,18,0,1,12,4),(2,19,0,1,12,4),(2,20,0,1,12,4),(2,21,0,1,12,4),(2,22,0,1,12,4),(2,23,0,1,12,4),(2,24,0,1,12,4),(2,25,0,1,12,4),(2,26,0,1,12,4),(2,27,0,1,12,4),(2,28,0,1,12,4),(2,29,0,1,12,4),(2,30,0,1,12,4),(2,31,0,1,12,4),(2,32,0,1,12,4),(2,33,0,1,12,4),(2,34,0,1,12,4),(2,35,0,1,12,4),(2,36,0,1,12,4),(2,37,0,1,12,4),(2,38,0,1,12,4),(2,39,0,1,12,4),(2,40,0,1,12,4),(2,41,0,1,12,4),(2,42,0,1,12,4),(2,43,0,1,12,4),(2,44,0,1,12,4),(2,45,0,1,12,4),(2,46,0,1,12,4),(2,47,0,1,12,4),(2,48,0,1,12,4),(2,49,0,1,12,4),(2,50,0,1,12,4),(2,57,0,1,12,4),(2,58,0,1,12,4),(2,59,0,1,12,4),(2,60,0,1,12,4),(2,61,0,1,12,4),(2,62,0,1,12,4),(2,63,0,1,12,4),(2,64,0,1,12,4),(2,65,0,1,12,4),(2,66,0,1,12,4),(2,68,0,1,12,4),(2,69,0,1,12,4),(2,70,0,1,12,4),(2,71,0,1,12,4),(2,72,0,1,12,4),(2,73,0,1,12,4),(2,74,0,1,12,4),(2,75,0,1,12,4),(2,76,0,1,12,4),(2,77,0,1,12,4),(2,78,0,1,12,4),(2,79,0,1,12,4),(2,80,0,1,12,4),(2,81,0,1,12,4),(2,82,0,1,12,4),(2,83,0,1,12,4),(2,84,0,1,12,4),(2,85,0,1,12,4),(2,86,0,1,12,4),(2,87,0,1,12,4),(2,88,0,1,12,4),(2,89,0,1,12,4),(2,90,0,1,12,4),(2,91,0,1,12,4),(2,92,0,1,12,4),(2,93,0,1,12,4),(2,94,0,1,12,4),(2,95,0,1,12,4),(2,96,0,1,12,4),(2,97,0,1,12,4),(2,98,0,1,12,4),(2,99,0,1,12,4),(2,100,0,1,12,4),(2,101,0,1,12,4),(2,102,0,1,12,4),(2,103,0,1,12,4),(2,104,0,1,12,4),(2,105,0,1,12,4),(2,106,0,1,12,4),(2,107,0,1,12,4),(2,108,0,1,12,4),(2,109,0,1,12,4),(2,110,0,1,12,4),(2,111,0,1,12,4),(2,112,0,1,12,4),(2,113,0,1,12,4),(2,114,0,1,12,4),(2,115,0,1,12,4),(2,116,0,1,12,4),(2,117,0,1,12,4),(2,118,0,1,12,4),(2,119,0,1,12,4),(2,120,0,1,12,4),(2,121,0,1,12,4),(2,122,0,1,12,4),(2,123,0,1,12,4),(2,124,0,1,12,4),(2,125,0,1,12,4),(2,126,0,1,12,4),(2,127,0,1,12,4),(2,128,0,1,12,4),(2,129,0,1,12,4),(2,130,0,1,12,4),(2,131,0,1,12,4),(2,132,0,1,12,4),(2,133,0,1,12,4),(2,134,0,1,12,4),(2,135,0,1,12,4),(2,136,0,1,12,4),(2,137,0,1,12,4),(2,138,0,1,12,4),(2,139,0,1,12,4),(2,140,0,1,12,4),(2,141,0,1,12,4),(2,142,0,1,12,4),(2,143,0,1,12,4),(2,144,0,1,12,4),(2,145,0,1,12,4),(2,146,0,1,12,4),(2,147,0,1,12,4),(2,148,0,1,12,4),(2,149,0,1,12,4),(2,150,0,1,12,4),(2,151,0,1,12,4),(2,152,0,1,12,4),(2,153,0,1,12,4),(2,154,0,1,12,4),(2,155,0,1,12,4),(2,156,0,1,12,4),(2,157,0,1,12,4),(2,158,0,1,12,4),(2,159,0,1,12,4),(2,160,0,1,12,4),(2,161,0,1,12,4),(2,162,0,1,12,4),(2,163,0,1,12,4),(2,164,0,1,12,4),(2,165,0,1,12,4),(2,166,0,1,12,4),(2,167,0,1,12,4),(2,168,0,1,12,4),(2,169,0,1,12,4),(2,170,0,1,12,4),(2,171,0,1,12,4),(2,172,0,1,12,4),(2,173,0,1,12,4),(2,174,0,1,12,4),(2,175,0,1,12,4),(2,176,0,1,12,4),(2,177,0,1,12,4),(2,178,0,1,12,4),(2,179,0,1,12,4),(2,180,0,1,12,4),(2,181,0,1,12,4),(2,182,0,1,12,4),(2,183,0,1,12,4),(2,184,0,1,12,4),(2,185,0,1,12,4),(2,186,0,1,12,4),(2,187,0,1,12,4),(2,188,0,1,12,4),(2,189,0,1,12,4),(2,190,0,1,12,4),(2,191,0,1,12,4),(2,192,0,1,12,4),(2,193,0,1,12,4),(2,194,0,1,12,4),(2,195,0,1,12,4),(2,196,0,1,12,4),(2,197,0,1,12,4),(2,198,0,1,12,4),(2,199,0,1,12,4),(2,200,0,1,12,4),(2,201,0,1,12,4),(2,202,0,1,12,4),(2,203,0,1,12,4),(2,204,0,1,12,4),(2,205,0,1,12,4),(2,206,0,1,12,4),(2,207,0,1,12,4),(2,208,0,1,12,4),(2,209,0,1,12,4),(2,210,0,1,12,4),(2,211,0,1,12,4),(2,212,0,1,12,4),(2,213,0,1,12,4),(2,214,0,1,12,4),(2,215,0,1,12,4),(2,216,0,1,12,4),(2,217,0,1,12,4),(2,218,0,1,12,4),(2,219,0,1,12,4),(2,220,0,1,12,4),(2,221,0,1,12,4),(2,222,0,1,12,4),(2,223,0,1,12,4),(2,224,0,1,12,4),(2,225,0,1,12,4),(2,226,0,1,12,4),(2,227,0,1,12,4),(2,228,0,1,12,4),(2,229,0,1,12,4),(2,230,0,1,12,4),(2,231,0,1,12,4),(2,232,0,1,12,4),(2,233,0,1,12,4),(2,234,0,1,12,4),(2,235,0,1,12,4),(2,236,0,1,12,4),(2,237,0,1,12,4),(2,238,0,1,12,4),(2,239,0,1,12,4),(2,240,0,1,12,4),(2,241,0,1,12,4),(2,244,0,1,12,4),(2,246,0,1,12,4),(2,251,0,1,12,4),(2,255,0,1,12,4),(2,258,0,1,12,4),(2,259,0,1,12,4),(2,260,0,1,12,4),(2,261,0,1,12,4),(2,262,0,1,12,4),(2,263,0,1,12,4),(3,1,0,1,12,4),(3,2,0,1,12,4),(3,3,0,1,12,4),(3,4,0,1,12,4),(3,5,0,1,12,4),(3,6,0,1,12,4),(3,7,0,1,12,4),(3,8,0,1,12,4),(3,10,0,1,12,4),(3,11,0,1,12,4),(4,12,0,1,12,4),(4,13,0,1,12,4),(4,14,0,1,12,4),(4,15,0,1,12,4),(4,16,0,1,12,4),(4,17,0,1,12,4),(4,18,0,1,12,4),(4,19,0,1,12,4),(4,36,0,1,12,4),(4,37,0,1,12,4),(4,38,0,1,12,4),(4,39,0,1,12,4),(4,40,0,1,12,4),(5,95,10000,0,12,4),(5,96,10000,0,12,4),(5,97,10000,0,12,4),(5,98,10000,0,12,4),(5,99,10000,0,12,4),(5,100,10000,0,12,4),(7,101,10000,0,12,4),(7,102,10000,0,12,4),(7,103,10000,0,12,4),(7,104,10000,0,12,4),(7,105,10000,0,12,4),(7,106,10000,0,12,4),(7,107,10000,0,12,4),(7,108,10000,0,12,4),(7,109,10000,0,12,4),(7,110,10000,0,12,4),(7,111,10000,0,12,4),(7,112,10000,0,12,4),(7,21,0,1,12,4),(7,22,0,1,12,4),(7,26,0,1,12,4),(8,61,0,1,12,4),(8,62,0,1,12,4),(8,63,0,1,12,4),(8,64,0,1,12,4),(8,65,0,1,12,4),(8,66,0,1,12,4),(11,4,10000,0,12,4),(11,89,10000,0,12,4),(11,90,10000,0,12,4),(11,91,10000,0,12,4),(11,92,10000,0,12,4),(11,93,10000,0,12,4),(11,94,10000,0,12,4),(11,28,0,1,12,4),(11,29,0,1,12,4),(11,30,0,1,12,4),(11,31,0,1,12,4),(11,32,0,1,12,4),(11,33,0,1,12,4),(11,34,0,1,12,4),(11,35,0,1,12,4),(13,21,0,1,12,4),(13,24,0,1,12,4),(13,25,0,1,12,4),(13,26,0,1,12,4),(13,27,0,1,12,4),(13,41,0,1,12,4),(13,42,0,1,12,4),(13,43,0,1,12,4),(13,44,0,1,12,4),(13,45,0,1,12,4),(13,46,0,1,12,4),(13,47,0,1,12,4),(13,48,0,1,12,4),(13,49,0,1,12,4),(15,22,10000,0,12,4),(15,23,10000,0,12,4),(16,20,0,1,12,4),(16,21,0,1,12,4),(16,22,0,1,12,4),(16,23,0,1,12,4),(16,24,0,1,12,4),(16,25,0,1,12,4),(16,26,0,1,12,4),(16,27,0,1,12,4),(16,41,0,1,12,4),(16,68,0,1,12,4),(16,69,0,1,12,4),(16,70,0,1,12,4),(16,71,0,1,12,4),(16,72,0,1,12,4),(16,73,0,1,12,4),(19,6,0,1,12,4),(19,7,0,1,12,4),(19,8,0,1,12,4),(19,10,0,1,12,4),(19,11,0,1,12,4),(27,11,0,1,12,4),(29,6,0,1,12,4),(29,8,0,1,12,4),(29,10,0,1,12,4),(30,6,0,1,12,4),(30,10,0,1,12,4),(33,7,0,1,12,4),(33,8,0,1,12,4),(33,10,0,1,12,4),(33,11,0,1,12,4),(42,7,0,1,12,4),(42,8,0,1,12,4),(42,11,0,1,12,4),(78,21,0,1,12,4),(78,26,0,1,12,4),(80,21,0,1,12,4),(80,22,0,1,12,4),(80,26,0,1,12,4),(81,26,0,1,12,4),(82,26,0,1,12,4),(83,26,0,1,12,4),(96,26,0,1,12,4),(97,26,0,1,12,4),(98,21,0,1,12,4),(98,22,0,1,12,4),(98,26,0,1,12,4),(99,18,0,1,12,4),(101,14,0,1,12,4),(101,15,0,1,12,4),(101,16,0,1,12,4),(102,12,0,1,12,4),(102,13,0,1,12,4),(102,14,0,1,12,4),(102,15,0,1,12,4),(102,16,0,1,12,4),(102,17,0,1,12,4),(102,19,0,1,12,4),(102,36,0,1,12,4),(102,37,0,1,12,4),(102,38,0,1,12,4),(102,39,0,1,12,4),(102,40,0,1,12,4),(103,18,0,1,12,4),(104,18,0,1,12,4),(105,18,0,1,12,4),(106,18,0,1,12,4),(107,18,0,1,12,4),(134,23,0,1,12,4),(135,22,0,1,12,4),(137,4,0,1,12,4),(137,28,0,1,12,4),(137,31,0,1,12,4),(137,34,0,1,12,4),(137,35,0,1,12,4),(138,28,0,1,12,4),(138,30,0,1,12,4),(138,32,0,1,12,4),(138,33,0,1,12,4),(139,28,0,1,12,4),(139,30,0,1,12,4),(139,32,0,1,12,4),(139,33,0,1,12,4),(140,28,0,1,12,4),(140,30,0,1,12,4),(140,32,0,1,12,4),(140,33,0,1,12,4),(145,1,0,1,12,4),(145,2,0,1,12,4),(145,3,0,1,12,4),(145,4,0,1,12,4),(145,5,0,1,12,4),(145,6,0,1,12,4),(145,7,0,1,12,4),(145,8,0,1,12,4),(145,9,0,1,12,4),(145,10,0,1,12,4),(145,11,0,1,12,4),(145,12,0,1,12,4),(145,13,0,1,12,4),(145,14,0,1,12,4),(145,15,0,1,12,4),(145,16,0,1,12,4),(145,17,0,1,12,4),(145,18,0,1,12,4),(145,19,0,1,12,4),(145,20,0,1,12,4),(145,21,0,1,12,4),(145,22,0,1,12,4),(145,23,0,1,12,4),(145,24,0,1,12,4),(145,25,0,1,12,4),(145,26,0,1,12,4),(145,27,0,1,12,4),(145,28,0,1,12,4),(145,29,0,1,12,4),(145,30,0,1,12,4),(145,31,0,1,12,4),(145,32,0,1,12,4),(145,33,0,1,12,4),(145,34,0,1,12,4),(145,35,0,1,12,4),(145,36,0,1,12,4),(145,37,0,1,12,4),(145,38,0,1,12,4),(145,39,0,1,12,4),(145,40,0,1,12,4),(145,41,0,1,12,4),(145,42,0,1,12,4),(145,43,0,1,12,4),(149,41,0,1,12,4),(150,50,0,1,12,4),(150,57,0,1,12,4),(150,58,0,1,12,4),(150,59,0,1,12,4),(150,60,0,1,12,4),(151,61,0,1,12,4),(151,62,0,1,12,4),(151,63,0,1,12,4),(151,64,0,1,12,4),(151,65,0,1,12,4),(151,66,0,1,12,4),(152,61,0,1,12,4),(152,63,0,1,12,4),(153,61,0,1,12,4),(153,63,0,1,12,4),(153,64,0,1,12,4),(153,65,0,1,12,4),(153,66,0,1,12,4),(154,61,0,1,12,4),(154,62,0,1,12,4),(154,64,0,1,12,4),(154,66,0,1,12,4),(155,61,0,1,12,4),(155,62,0,1,12,4),(155,64,0,1,12,4),(155,65,0,1,12,4),(155,66,0,1,12,4),(156,61,0,1,12,4),(156,62,0,1,12,4),(156,63,0,1,12,4),(156,64,0,1,12,4),(156,65,0,1,12,4),(156,66,0,1,12,4),(157,61,0,1,12,4),(157,62,0,1,12,4),(157,64,0,1,12,4),(157,65,0,1,12,4),(157,66,0,1,12,4),(158,61,0,1,12,4),(158,63,0,1,12,4),(158,64,0,1,12,4),(158,65,0,1,12,4),(158,66,0,1,12,4),(159,61,0,1,12,4),(159,62,0,1,12,4),(159,63,0,1,12,4),(159,64,0,1,12,4),(159,65,0,1,12,4),(159,66,0,1,12,4),(160,41,0,1,12,4),(160,68,0,1,12,4),(160,69,0,1,12,4),(160,70,0,1,12,4),(160,72,0,1,12,4),(160,73,0,1,12,4),(161,68,0,1,12,4),(161,69,0,1,12,4),(161,70,0,1,12,4),(161,71,0,1,12,4),(161,72,0,1,12,4),(162,68,0,1,12,4),(162,69,0,1,12,4),(162,72,0,1,12,4),(164,41,0,1,12,4),(164,70,0,1,12,4),(164,73,0,1,12,4),(166,41,0,1,12,4),(166,70,0,1,12,4),(166,73,0,1,12,4),(167,68,0,1,12,4),(167,69,0,1,12,4),(167,72,0,1,12,4),(168,71,0,1,12,4),(169,70,0,1,12,4),(171,70,0,1,12,4),(172,1,10000,0,12,4),(172,2,10000,0,12,4),(172,3,10000,0,12,4),(172,4,10000,0,12,4),(172,5,10000,0,12,4),(172,6,10000,0,12,4),(172,7,10000,0,12,4),(172,8,10000,0,12,4),(172,9,10000,0,12,4),(172,10,10000,0,12,4),(172,11,10000,0,12,4),(172,12,10000,0,12,4),(172,13,10000,0,12,4),(172,14,10000,0,12,4),(172,15,10000,0,12,4),(172,16,10000,0,12,4),(172,17,10000,0,12,4),(172,18,10000,0,12,4),(172,19,10000,0,12,4),(172,20,10000,0,12,4),(172,21,10000,0,12,4),(172,22,10000,0,12,4),(172,23,10000,0,12,4),(172,24,10000,0,12,4),(172,25,10000,0,12,4),(172,26,10000,0,12,4),(172,27,10000,0,12,4),(172,28,10000,0,12,4),(172,29,10000,0,12,4),(172,30,10000,0,12,4),(173,1,0,1,12,4),(173,2,0,1,12,4),(173,3,0,1,12,4),(173,4,0,1,12,4),(173,5,0,1,12,4),(173,6,0,1,12,4),(173,7,0,1,12,4),(173,8,0,1,12,4),(173,9,0,1,12,4),(173,10,0,1,12,4),(173,11,0,1,12,4),(173,12,0,1,12,4),(173,13,0,1,12,4),(173,14,0,1,12,4),(173,15,0,1,12,4),(173,16,0,1,12,4),(173,17,0,1,12,4),(173,18,0,1,12,4),(173,19,0,1,12,4),(173,20,0,1,12,4),(173,21,0,1,12,4),(173,22,0,1,12,4),(173,23,0,1,12,4),(173,24,0,1,12,4),(173,25,0,1,12,4),(173,26,0,1,12,4),(173,27,0,1,12,4),(173,28,0,1,12,4),(173,29,0,1,12,4),(173,30,0,1,12,4),(174,1,0,1,12,4),(174,2,0,1,12,4),(174,3,0,1,12,4),(174,4,0,1,12,4),(174,5,0,1,12,4),(174,6,0,1,12,4),(174,7,0,1,12,4),(174,8,0,1,12,4),(174,9,0,1,12,4),(174,10,0,1,12,4),(174,11,0,1,12,4),(174,12,0,1,12,4),(174,13,0,1,12,4),(174,14,0,1,12,4),(174,15,0,1,12,4),(174,16,0,1,12,4),(174,17,0,1,12,4),(174,18,0,1,12,4),(174,19,0,1,12,4),(174,20,0,1,12,4),(174,21,0,1,12,4),(174,22,0,1,12,4),(174,23,0,1,12,4),(174,24,0,1,12,4),(174,25,0,1,12,4),(174,26,0,1,12,4),(174,27,0,1,12,4),(174,28,0,1,12,4),(174,29,0,1,12,4),(174,30,0,1,12,4),(175,1,0,1,12,4),(175,2,0,1,12,4),(175,3,0,1,12,4),(175,4,0,1,12,4),(175,5,0,1,12,4),(175,6,0,1,12,4),(175,7,0,1,12,4),(175,8,0,1,12,4),(175,9,0,1,12,4),(175,10,0,1,12,4),(175,11,0,1,12,4),(175,12,0,1,12,4),(175,13,0,1,12,4),(175,14,0,1,12,4),(175,15,0,1,12,4),(175,16,0,1,12,4),(175,17,0,1,12,4),(175,18,0,1,12,4),(175,19,0,1,12,4),(175,20,0,1,12,4),(175,21,0,1,12,4),(175,22,0,1,12,4),(175,23,0,1,12,4),(175,24,0,1,12,4),(175,25,0,1,12,4),(175,26,0,1,12,4),(175,27,0,1,12,4),(175,28,0,1,12,4),(175,29,0,1,12,4),(175,30,0,1,12,4),(176,1,0,1,12,4),(176,2,0,1,12,4),(176,3,0,1,12,4),(176,4,0,1,12,4),(176,5,0,1,12,4),(176,6,0,1,12,4),(176,7,0,1,12,4),(176,8,0,1,12,4),(176,9,0,1,12,4),(176,10,0,1,12,4),(176,11,0,1,12,4),(176,12,0,1,12,4),(176,13,0,1,12,4),(176,14,0,1,12,4),(176,15,0,1,12,4),(176,16,0,1,12,4),(176,17,0,1,12,4),(176,18,0,1,12,4),(176,19,0,1,12,4),(176,20,0,1,12,4),(176,21,0,1,12,4),(176,22,0,1,12,4),(176,23,0,1,12,4),(176,24,0,1,12,4),(176,25,0,1,12,4),(176,26,0,1,12,4),(176,27,0,1,12,4),(176,28,0,1,12,4),(176,29,0,1,12,4),(176,30,0,1,12,4),(177,74,0,1,12,4),(177,75,0,1,12,4),(177,76,0,1,12,4),(177,77,0,1,12,4),(177,78,0,1,12,4),(177,79,0,1,12,4),(177,80,0,1,12,4),(178,74,10000,0,12,4),(178,75,10000,0,12,4),(178,76,10000,0,12,4),(178,77,10000,0,12,4),(178,78,10000,0,12,4),(178,79,10000,0,12,4),(178,80,10000,0,12,4),(178,81,10000,0,12,4),(178,82,10000,0,12,4),(178,83,10000,0,12,4),(178,84,10000,0,12,4),(178,85,10000,0,12,4),(178,86,10000,0,12,4),(178,87,10000,0,12,4),(178,88,10000,0,12,4),(178,113,10000,0,12,4),(178,114,10000,0,12,4),(178,115,10000,0,12,4),(178,116,10000,0,12,4),(178,117,10000,0,12,4),(178,118,10000,0,12,4),(178,119,10000,0,12,4),(178,120,10000,0,12,4),(178,121,10000,0,12,4),(178,122,10000,0,12,4),(178,123,10000,0,12,4),(178,124,10000,0,12,4),(178,125,10000,0,12,4),(178,126,10000,0,12,4),(178,127,10000,0,12,4),(178,128,10000,0,12,4),(178,129,10000,0,12,4),(178,130,10000,0,12,4),(178,131,10000,0,12,4),(178,132,10000,0,12,4),(178,133,10000,0,12,4),(178,134,10000,0,12,4),(178,135,10000,0,12,4),(178,136,10000,0,12,4),(178,137,10000,0,12,4),(178,138,10000,0,12,4),(178,139,10000,0,12,4),(178,140,10000,0,12,4),(178,141,10000,0,12,4),(178,142,10000,0,12,4),(178,143,10000,0,12,4),(178,144,10000,0,12,4),(178,145,10000,0,12,4),(178,146,10000,0,12,4),(178,147,10000,0,12,4),(178,148,10000,0,12,4),(178,149,10000,0,12,4),(178,150,10000,0,12,4),(178,151,10000,0,12,4),(178,152,10000,0,12,4),(178,153,10000,0,12,4),(178,154,10000,0,12,4),(178,155,10000,0,12,4),(178,156,10000,0,12,4),(178,157,10000,0,12,4),(178,158,10000,0,12,4),(178,159,10000,0,12,4),(178,160,10000,0,12,4),(178,161,10000,0,12,4),(178,162,10000,0,12,4),(178,163,10000,0,12,4),(178,164,10000,0,12,4),(178,165,10000,0,12,4),(178,166,10000,0,12,4),(178,167,10000,0,12,4),(178,168,10000,0,12,4),(178,169,10000,0,12,4),(178,170,10000,0,12,4),(178,171,10000,0,12,4),(178,172,10000,0,12,4),(178,173,10000,0,12,4),(178,174,10000,0,12,4),(178,175,10000,0,12,4),(178,176,10000,0,12,4),(178,177,10000,0,12,4),(178,178,10000,0,12,4),(178,179,10000,0,12,4),(178,180,10000,0,12,4),(178,181,10000,0,12,4),(178,182,10000,0,12,4),(178,183,10000,0,12,4),(178,184,10000,0,12,4),(178,185,10000,0,12,4),(178,186,10000,0,12,4),(178,187,10000,0,12,4),(178,188,10000,0,12,4),(178,189,10000,0,12,4),(178,190,10000,0,12,4),(178,191,10000,0,12,4),(178,192,10000,0,12,4),(178,193,10000,0,12,4),(178,194,10000,0,12,4),(178,195,10000,0,12,4),(178,196,10000,0,12,4),(178,197,10000,0,12,4),(178,198,10000,0,12,4),(178,199,10000,0,12,4),(178,200,10000,0,12,4),(178,201,10000,0,12,4),(178,202,10000,0,12,4),(178,203,10000,0,12,4),(178,204,10000,0,12,4),(178,205,10000,0,12,4),(178,206,10000,0,12,4),(178,207,10000,0,12,4),(178,208,10000,0,12,4),(178,209,10000,0,12,4),(178,210,10000,0,12,4),(178,211,10000,0,12,4),(178,212,10000,0,12,4),(178,213,10000,0,12,4),(178,214,10000,0,12,4),(178,215,10000,0,12,4),(178,216,10000,0,12,4),(178,217,10000,0,12,4),(178,218,10000,0,12,4),(178,219,10000,0,12,4),(178,220,10000,0,12,4),(178,221,10000,0,12,4),(178,222,10000,0,12,4),(178,223,10000,0,12,4),(178,224,10000,0,12,4),(178,225,10000,0,12,4),(178,226,10000,0,12,4),(178,227,10000,0,12,4),(178,228,10000,0,12,4),(178,229,10000,0,12,4),(178,230,10000,0,12,4),(178,231,10000,0,12,4),(178,232,10000,0,12,4),(178,233,10000,0,12,4),(178,234,10000,0,12,4),(178,235,10000,0,12,4),(178,236,10000,0,12,4),(178,237,10000,0,12,4),(178,238,10000,0,12,4),(178,239,10000,0,12,4),(178,240,10000,0,12,4),(178,241,10000,0,12,4),(178,244,10000,0,12,4),(178,246,10000,0,12,4),(178,251,10000,0,12,4),(178,255,10000,0,12,4),(178,258,10000,0,12,4),(178,259,10000,0,12,4),(178,260,10000,0,12,4),(178,261,10000,0,12,4),(178,262,10000,0,12,4),(178,263,10000,0,12,4),(179,81,0,1,12,4),(179,82,0,1,12,4),(179,83,0,1,12,4),(179,84,0,1,12,4),(179,85,0,1,12,4),(179,86,0,1,12,4),(179,87,0,1,12,4),(179,88,0,1,12,4),(180,81,0,1,12,4),(181,86,0,1,12,4),(182,82,0,1,12,4),(182,83,0,1,12,4),(182,84,0,1,12,4),(182,85,0,1,12,4),(182,87,0,1,12,4),(182,88,0,1,12,4),(183,82,0,1,12,4),(183,83,0,1,12,4),(183,84,0,1,12,4),(183,85,0,1,12,4),(183,86,0,1,12,4),(183,87,0,1,12,4),(183,88,0,1,12,4),(192,89,0,1,12,4),(192,90,0,1,12,4),(192,91,0,1,12,4),(192,92,0,1,12,4),(192,93,0,1,12,4),(192,94,0,1,12,4),(193,95,0,1,12,4),(193,96,0,1,12,4),(193,97,0,1,12,4),(193,98,0,1,12,4),(193,99,0,1,12,4),(193,100,0,1,12,4),(194,95,0,1,12,4),(194,96,0,1,12,4),(194,97,0,1,12,4),(194,98,0,1,12,4),(194,99,0,1,12,4),(194,100,0,1,12,4),(195,95,0,1,12,4),(195,96,0,1,12,4),(195,97,0,1,12,4),(195,98,0,1,12,4),(195,99,0,1,12,4),(195,100,0,1,12,4),(196,95,0,1,12,4),(196,96,0,1,12,4),(196,97,0,1,12,4),(196,98,0,1,12,4),(196,99,0,1,12,4),(196,100,0,1,12,4),(197,95,0,1,12,4),(197,96,0,1,12,4),(197,97,0,1,12,4),(197,98,0,1,12,4),(197,99,0,1,12,4),(197,100,0,1,12,4),(198,101,0,1,12,4),(198,109,0,1,12,4),(198,111,0,1,12,4),(198,112,0,1,12,4),(199,103,0,1,12,4),(199,110,0,1,12,4),(200,101,0,1,12,4),(200,102,0,1,12,4),(200,108,0,1,12,4),(201,104,0,1,12,4),(201,106,0,1,12,4),(202,101,0,1,12,4),(202,102,0,1,12,4),(202,103,0,1,12,4),(202,105,0,1,12,4),(202,107,0,1,12,4),(202,108,0,1,12,4),(202,110,0,1,12,4),(203,101,0,1,12,4),(203,102,0,1,12,4),(203,103,0,1,12,4),(203,104,0,1,12,4),(203,106,0,1,12,4),(203,108,0,1,12,4),(203,109,0,1,12,4),(204,101,0,1,12,4),(204,102,0,1,12,4),(204,103,0,1,12,4),(204,104,0,1,12,4),(204,105,0,1,12,4),(204,106,0,1,12,4),(204,107,0,1,12,4),(204,108,0,1,12,4),(205,101,0,1,12,4),(205,102,0,1,12,4),(205,103,0,1,12,4),(205,108,0,1,12,4),(205,109,0,1,12,4),(205,110,0,1,12,4),(205,111,0,1,12,4),(205,112,0,1,12,4),(206,113,10000,0,12,4),(206,114,10000,0,12,4),(206,115,10000,0,12,4),(206,116,10000,0,12,4),(206,117,10000,0,12,4),(206,118,10000,0,12,4),(206,119,10000,0,12,4),(207,114,0,1,12,4),(207,119,0,1,12,4),(209,114,0,1,12,4),(212,116,0,1,12,4),(212,118,0,1,12,4),(213,113,0,1,12,4),(218,117,0,1,12,4),(219,119,0,1,12,4),(220,119,0,1,12,4),(221,119,0,1,12,4),(222,114,0,1,12,4),(222,119,0,1,12,4),(223,114,0,1,12,4),(223,119,0,1,12,4),(229,113,0,1,12,4),(230,113,0,1,12,4),(231,113,0,1,12,4),(232,113,0,1,12,4),(233,113,0,1,12,4),(234,116,0,1,12,4),(234,118,0,1,12,4),(235,116,0,1,12,4),(235,118,0,1,12,4),(236,116,0,1,12,4),(236,118,0,1,12,4),(237,116,0,1,12,4),(237,118,0,1,12,4),(238,116,0,1,12,4),(238,118,0,1,12,4),(239,115,0,1,12,4),(241,115,0,1,12,4),(242,115,0,1,12,4),(243,115,0,1,12,4),(250,120,0,1,12,4),(250,121,0,1,12,4),(250,122,0,1,12,4),(250,123,0,1,12,4),(250,124,0,1,12,4),(250,125,0,1,12,4),(250,126,0,1,12,4),(250,127,0,1,12,4),(250,128,0,1,12,4),(250,129,0,1,12,4),(250,130,0,1,12,4),(250,131,0,1,12,4),(251,120,0,1,12,4),(251,121,0,1,12,4),(251,122,0,1,12,4),(251,123,0,1,12,4),(251,124,0,1,12,4),(251,125,0,1,12,4),(251,126,0,1,12,4),(251,127,0,1,12,4),(251,128,0,1,12,4),(251,129,0,1,12,4),(251,130,0,1,12,4),(251,131,0,1,12,4),(252,125,10000,0,12,4),(252,126,10000,0,12,4),(252,127,10000,0,12,4),(252,120,0,1,12,4),(252,121,0,1,12,4),(252,122,0,1,12,4),(252,123,0,1,12,4),(252,124,0,1,12,4),(252,128,0,1,12,4),(252,129,0,1,12,4),(252,131,0,1,12,4),(253,120,0,1,12,4),(253,121,0,1,12,4),(253,122,0,1,12,4),(253,123,0,1,12,4),(253,124,0,1,12,4),(253,125,0,1,12,4),(253,126,0,1,12,4),(253,127,0,1,12,4),(253,128,0,1,12,4),(253,129,0,1,12,4),(253,130,0,1,12,4),(253,131,0,1,12,4),(254,120,0,1,12,4),(254,121,0,1,12,4),(254,122,0,1,12,4),(254,123,0,1,12,4),(254,124,0,1,12,4),(254,125,0,1,12,4),(254,126,0,1,12,4),(254,127,0,1,12,4),(254,128,0,1,12,4),(254,129,0,1,12,4),(254,130,0,1,12,4),(254,131,0,1,12,4),(255,122,0,1,12,4),(255,123,0,1,12,4),(255,124,0,1,12,4),(255,125,0,1,12,4),(255,126,0,1,12,4),(255,129,0,1,12,4),(256,121,0,1,12,4),(256,122,0,1,12,4),(256,123,0,1,12,4),(256,125,0,1,12,4),(256,126,0,1,12,4),(256,127,0,1,12,4),(257,121,0,1,12,4),(257,122,0,1,12,4),(257,123,0,1,12,4),(257,125,0,1,12,4),(257,127,0,1,12,4),(257,129,0,1,12,4),(258,121,0,1,12,4),(258,122,0,1,12,4),(258,125,0,1,12,4),(258,126,0,1,12,4),(258,127,0,1,12,4),(258,129,0,1,12,4),(259,120,0,1,12,4),(259,121,0,1,12,4),(259,123,0,1,12,4),(259,128,0,1,12,4),(259,129,0,1,12,4),(260,120,0,1,12,4),(260,121,0,1,12,4),(260,122,0,1,12,4),(260,123,0,1,12,4),(260,125,0,1,12,4),(260,127,0,1,12,4),(260,128,0,1,12,4),(260,129,0,1,12,4),(261,121,0,1,12,4),(261,122,0,1,12,4),(261,125,0,1,12,4),(261,126,0,1,12,4),(261,127,0,1,12,4),(261,129,0,1,12,4),(262,125,0,1,12,4),(262,126,0,1,12,4),(263,120,0,1,12,4),(263,121,0,1,12,4),(263,122,0,1,12,4),(263,123,0,1,12,4),(263,124,0,1,12,4),(263,128,0,1,12,4),(263,129,0,1,12,4),(263,131,0,1,12,4),(264,120,0,1,12,4),(264,122,0,1,12,4),(264,123,0,1,12,4),(264,125,0,1,12,4),(264,126,0,1,12,4),(264,129,0,1,12,4),(265,121,0,1,12,4),(265,122,0,1,12,4),(265,123,0,1,12,4),(265,127,0,1,12,4),(266,123,0,1,12,4),(266,125,0,1,12,4),(266,126,0,1,12,4),(266,127,0,1,12,4),(266,129,0,1,12,4),(267,121,0,1,12,4),(267,125,0,1,12,4),(267,126,0,1,12,4),(267,127,0,1,12,4),(268,120,0,1,12,4),(268,121,0,1,12,4),(268,122,0,1,12,4),(268,123,0,1,12,4),(268,124,0,1,12,4),(268,127,0,1,12,4),(268,129,0,1,12,4),(269,122,0,1,12,4),(269,125,0,1,12,4),(269,126,0,1,12,4),(269,127,0,1,12,4),(269,129,0,1,12,4),(270,121,0,1,12,4),(270,123,0,1,12,4),(270,125,0,1,12,4),(270,126,0,1,12,4),(270,129,0,1,12,4),(271,120,0,1,12,4),(271,121,0,1,12,4),(271,122,0,1,12,4),(271,125,0,1,12,4),(271,126,0,1,12,4),(271,127,0,1,12,4),(271,129,0,1,12,4),(272,122,0,1,12,4),(272,123,0,1,12,4),(272,124,0,1,12,4),(272,125,0,1,12,4),(272,126,0,1,12,4),(272,127,0,1,12,4),(272,128,0,1,12,4),(272,129,0,1,12,4),(273,120,0,1,12,4),(273,121,0,1,12,4),(273,123,0,1,12,4),(273,126,0,1,12,4),(273,127,0,1,12,4),(274,122,0,1,12,4),(274,123,0,1,12,4),(274,125,0,1,12,4),(274,126,0,1,12,4),(274,129,0,1,12,4),(275,120,0,1,12,4),(275,121,0,1,12,4),(275,122,0,1,12,4),(275,123,0,1,12,4),(275,124,0,1,12,4),(275,125,0,1,12,4),(275,126,0,1,12,4),(275,127,0,1,12,4),(275,128,0,1,12,4),(275,129,0,1,12,4),(275,130,0,1,12,4),(275,131,0,1,12,4),(276,122,0,1,12,4),(276,123,0,1,12,4),(276,127,0,1,12,4),(276,129,0,1,12,4),(277,120,0,1,12,4),(277,121,0,1,12,4),(277,123,0,1,12,4),(277,124,0,1,12,4),(277,125,0,1,12,4),(277,126,0,1,12,4),(277,127,0,1,12,4),(278,120,0,1,12,4),(278,121,0,1,12,4),(278,122,0,1,12,4),(278,123,0,1,12,4),(278,124,0,1,12,4),(278,125,0,1,12,4),(278,127,0,1,12,4),(278,128,0,1,12,4),(278,129,0,1,12,4),(279,120,0,1,12,4),(279,122,0,1,12,4),(279,126,0,1,12,4),(279,127,0,1,12,4),(279,129,0,1,12,4),(280,132,0,1,12,4),(280,133,0,1,12,4),(280,134,0,1,12,4),(280,135,0,1,12,4),(280,136,0,1,12,4),(280,137,0,1,12,4),(280,138,0,1,12,4),(280,139,0,1,12,4),(282,132,0,1,12,4),(282,133,0,1,12,4),(282,134,0,1,12,4),(282,137,0,1,12,4),(282,138,0,1,12,4),(283,135,0,1,12,4),(283,136,0,1,12,4),(283,139,0,1,12,4),(286,140,0,1,12,4),(286,141,0,1,12,4),(286,142,0,1,12,4),(286,143,0,1,12,4),(286,144,0,1,12,4),(286,145,0,1,12,4),(286,146,0,1,12,4),(286,147,0,1,12,4),(286,148,0,1,12,4),(286,149,0,1,12,4),(286,150,0,1,12,4),(286,151,0,1,12,4),(286,152,0,1,12,4),(286,153,0,1,12,4),(286,154,0,1,12,4),(286,155,0,1,12,4),(286,156,0,1,12,4),(286,157,0,1,12,4),(286,158,0,1,12,4),(286,159,0,1,12,4),(286,160,0,1,12,4),(286,161,0,1,12,4),(286,162,0,1,12,4),(286,163,0,1,12,4),(286,164,0,1,12,4),(286,165,0,1,12,4),(286,166,0,1,12,4),(286,167,0,1,12,4),(286,168,0,1,12,4),(286,169,0,1,12,4),(286,170,0,1,12,4),(286,171,0,1,12,4),(286,172,0,1,12,4),(286,173,0,1,12,4),(286,174,0,1,12,4),(286,175,0,1,12,4),(286,176,0,1,12,4),(286,177,0,1,12,4),(286,178,0,1,12,4),(286,179,0,1,12,4),(286,180,0,1,12,4),(286,181,0,1,12,4),(286,182,0,1,12,4),(286,183,0,1,12,4),(286,184,0,1,12,4),(286,185,0,1,12,4),(286,186,0,1,12,4),(286,187,0,1,12,4),(287,188,0,1,12,4),(288,189,0,1,12,4),(288,190,0,1,12,4),(288,191,0,1,12,4),(288,192,0,1,12,4),(288,193,0,1,12,4),(288,194,0,1,12,4),(288,195,0,1,12,4),(288,196,0,1,12,4),(288,197,0,1,12,4),(288,198,0,1,12,4),(288,199,0,1,12,4),(288,200,0,1,12,4),(289,201,10000,0,12,4),(289,202,10000,0,12,4),(289,203,10000,0,12,4),(289,204,10000,0,12,4),(289,205,10000,0,12,4),(289,206,10000,0,12,4),(289,207,10000,0,12,4),(289,208,10000,0,12,4),(289,209,10000,0,12,4),(289,210,10000,0,12,4),(289,211,10000,0,12,4),(289,212,10000,0,12,4),(289,213,10000,0,12,4),(289,214,10000,0,12,4),(289,215,10000,0,12,4),(289,216,10000,0,12,4),(289,217,10000,0,12,4),(289,218,10000,0,12,4),(289,219,10000,0,12,4),(289,220,10000,0,12,4),(289,221,10000,0,12,4),(289,222,10000,0,12,4),(289,223,10000,0,12,4),(289,224,10000,0,12,4),(289,225,10000,0,12,4),(289,226,10000,0,12,4),(289,227,10000,0,12,4),(289,228,10000,0,12,4),(289,229,10000,0,12,4),(289,230,10000,0,12,4),(289,231,10000,0,12,4),(289,232,10000,0,12,4),(289,244,10000,0,12,4),(289,246,10000,0,12,4),(289,251,10000,0,12,4),(289,255,10000,0,12,4),(289,258,10000,0,12,4),(289,259,10000,0,12,4),(289,260,10000,0,12,4),(289,261,10000,0,12,4),(289,262,10000,0,12,4),(289,263,10000,0,12,4),(290,209,0,1,12,4),(290,210,0,1,12,4),(290,211,0,1,12,4),(290,212,0,1,12,4),(290,213,0,1,12,4),(290,214,0,1,12,4),(290,215,0,1,12,4),(290,216,0,1,12,4),(291,201,0,1,12,4),(291,202,0,1,12,4),(291,203,0,1,12,4),(291,204,0,1,12,4),(291,205,0,1,12,4),(291,206,0,1,12,4),(291,207,0,1,12,4),(291,208,0,1,12,4),(292,217,0,1,12,4),(292,218,0,1,12,4),(292,219,0,1,12,4),(292,220,0,1,12,4),(292,221,0,1,12,4),(292,222,0,1,12,4),(292,223,0,1,12,4),(292,224,0,1,12,4),(293,225,0,1,12,4),(293,226,0,1,12,4),(293,227,0,1,12,4),(293,228,0,1,12,4),(293,229,0,1,12,4),(293,230,0,1,12,4),(293,231,0,1,12,4),(293,232,0,1,12,4),(293,255,0,1,12,4),(293,259,0,1,12,4),(293,260,0,1,12,4),(293,261,0,1,12,4),(293,262,0,1,12,4),(293,263,0,1,12,4),(294,233,0,1,12,4),(294,234,0,1,12,4),(294,235,0,1,12,4),(294,236,0,1,12,4),(294,237,0,1,12,4),(294,238,0,1,12,4),(294,239,0,1,12,4),(294,240,0,1,12,4),(294,241,0,1,12,4),(295,244,0,1,12,4),(295,246,0,1,12,4),(295,251,0,1,12,4),(295,255,0,1,12,4),(295,258,0,1,12,4),(296,251,0,1,12,4),(296,255,0,1,12,4),(296,258,0,1,12,4),(297,246,0,1,12,4),(297,255,0,1,12,4),(297,258,0,1,12,4),(298,255,0,1,12,4),(298,258,0,1,12,4),(299,251,0,1,12,4),(299,258,0,1,12,4);
/*!40000 ALTER TABLE `catalog_category_product_index_store12_replica` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index_store13`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store13`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store13` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `CAT_CTGR_PRD_IDX_STORE13_PRD_ID_STORE_ID_CTGR_ID_VISIBILITY` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_755D4F0D55D5EE6C608F4FF47294DEAF` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Product Index Store13';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index_store13`
--

LOCK TABLES `catalog_category_product_index_store13` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index_store13` DISABLE KEYS */;
INSERT INTO `catalog_category_product_index_store13` VALUES (2,1,0,1,13,4),(2,2,0,1,13,4),(2,3,0,1,13,4),(2,4,0,1,13,4),(2,5,0,1,13,4),(2,6,0,1,13,4),(2,7,0,1,13,4),(2,8,0,1,13,4),(2,9,0,1,13,4),(2,10,0,1,13,4),(2,11,0,1,13,4),(2,12,0,1,13,4),(2,13,0,1,13,4),(2,14,0,1,13,4),(2,15,0,1,13,4),(2,16,0,1,13,4),(2,17,0,1,13,4),(2,18,0,1,13,4),(2,19,0,1,13,4),(2,20,0,1,13,4),(2,21,0,1,13,4),(2,22,0,1,13,4),(2,23,0,1,13,4),(2,24,0,1,13,4),(2,25,0,1,13,4),(2,26,0,1,13,4),(2,27,0,1,13,4),(2,28,0,1,13,4),(2,29,0,1,13,4),(2,30,0,1,13,4),(2,31,0,1,13,4),(2,32,0,1,13,4),(2,33,0,1,13,4),(2,34,0,1,13,4),(2,35,0,1,13,4),(2,36,0,1,13,4),(2,37,0,1,13,4),(2,38,0,1,13,4),(2,39,0,1,13,4),(2,40,0,1,13,4),(2,41,0,1,13,4),(2,42,0,1,13,4),(2,43,0,1,13,4),(2,44,0,1,13,4),(2,45,0,1,13,4),(2,46,0,1,13,4),(2,47,0,1,13,4),(2,48,0,1,13,4),(2,49,0,1,13,4),(2,50,0,1,13,4),(2,57,0,1,13,4),(2,58,0,1,13,4),(2,59,0,1,13,4),(2,60,0,1,13,4),(2,61,0,1,13,4),(2,62,0,1,13,4),(2,63,0,1,13,4),(2,64,0,1,13,4),(2,65,0,1,13,4),(2,66,0,1,13,4),(2,68,0,1,13,4),(2,69,0,1,13,4),(2,70,0,1,13,4),(2,71,0,1,13,4),(2,72,0,1,13,4),(2,73,0,1,13,4),(2,74,0,1,13,4),(2,75,0,1,13,4),(2,76,0,1,13,4),(2,77,0,1,13,4),(2,78,0,1,13,4),(2,79,0,1,13,4),(2,80,0,1,13,4),(2,81,0,1,13,4),(2,82,0,1,13,4),(2,83,0,1,13,4),(2,84,0,1,13,4),(2,85,0,1,13,4),(2,86,0,1,13,4),(2,87,0,1,13,4),(2,88,0,1,13,4),(2,89,0,1,13,4),(2,90,0,1,13,4),(2,91,0,1,13,4),(2,92,0,1,13,4),(2,93,0,1,13,4),(2,94,0,1,13,4),(2,95,0,1,13,4),(2,96,0,1,13,4),(2,97,0,1,13,4),(2,98,0,1,13,4),(2,99,0,1,13,4),(2,100,0,1,13,4),(2,101,0,1,13,4),(2,102,0,1,13,4),(2,103,0,1,13,4),(2,104,0,1,13,4),(2,105,0,1,13,4),(2,106,0,1,13,4),(2,107,0,1,13,4),(2,108,0,1,13,4),(2,109,0,1,13,4),(2,110,0,1,13,4),(2,111,0,1,13,4),(2,112,0,1,13,4),(2,113,0,1,13,4),(2,114,0,1,13,4),(2,115,0,1,13,4),(2,116,0,1,13,4),(2,117,0,1,13,4),(2,118,0,1,13,4),(2,119,0,1,13,4),(2,120,0,1,13,4),(2,121,0,1,13,4),(2,122,0,1,13,4),(2,123,0,1,13,4),(2,124,0,1,13,4),(2,125,0,1,13,4),(2,126,0,1,13,4),(2,127,0,1,13,4),(2,128,0,1,13,4),(2,129,0,1,13,4),(2,130,0,1,13,4),(2,131,0,1,13,4),(2,132,0,1,13,4),(2,133,0,1,13,4),(2,134,0,1,13,4),(2,135,0,1,13,4),(2,136,0,1,13,4),(2,137,0,1,13,4),(2,138,0,1,13,4),(2,139,0,1,13,4),(2,140,0,1,13,4),(2,141,0,1,13,4),(2,142,0,1,13,4),(2,143,0,1,13,4),(2,144,0,1,13,4),(2,145,0,1,13,4),(2,146,0,1,13,4),(2,147,0,1,13,4),(2,148,0,1,13,4),(2,149,0,1,13,4),(2,150,0,1,13,4),(2,151,0,1,13,4),(2,152,0,1,13,4),(2,153,0,1,13,4),(2,154,0,1,13,4),(2,155,0,1,13,4),(2,156,0,1,13,4),(2,157,0,1,13,4),(2,158,0,1,13,4),(2,159,0,1,13,4),(2,160,0,1,13,4),(2,161,0,1,13,4),(2,162,0,1,13,4),(2,163,0,1,13,4),(2,164,0,1,13,4),(2,165,0,1,13,4),(2,166,0,1,13,4),(2,167,0,1,13,4),(2,168,0,1,13,4),(2,169,0,1,13,4),(2,170,0,1,13,4),(2,171,0,1,13,4),(2,172,0,1,13,4),(2,173,0,1,13,4),(2,174,0,1,13,4),(2,175,0,1,13,4),(2,176,0,1,13,4),(2,177,0,1,13,4),(2,178,0,1,13,4),(2,179,0,1,13,4),(2,180,0,1,13,4),(2,181,0,1,13,4),(2,182,0,1,13,4),(2,183,0,1,13,4),(2,184,0,1,13,4),(2,185,0,1,13,4),(2,186,0,1,13,4),(2,187,0,1,13,4),(2,188,0,1,13,4),(2,189,0,1,13,4),(2,190,0,1,13,4),(2,191,0,1,13,4),(2,192,0,1,13,4),(2,193,0,1,13,4),(2,194,0,1,13,4),(2,195,0,1,13,4),(2,196,0,1,13,4),(2,197,0,1,13,4),(2,198,0,1,13,4),(2,199,0,1,13,4),(2,200,0,1,13,4),(2,201,0,1,13,4),(2,202,0,1,13,4),(2,203,0,1,13,4),(2,204,0,1,13,4),(2,205,0,1,13,4),(2,206,0,1,13,4),(2,207,0,1,13,4),(2,208,0,1,13,4),(2,209,0,1,13,4),(2,210,0,1,13,4),(2,211,0,1,13,4),(2,212,0,1,13,4),(2,213,0,1,13,4),(2,214,0,1,13,4),(2,215,0,1,13,4),(2,216,0,1,13,4),(2,217,0,1,13,4),(2,218,0,1,13,4),(2,219,0,1,13,4),(2,220,0,1,13,4),(2,221,0,1,13,4),(2,222,0,1,13,4),(2,223,0,1,13,4),(2,224,0,1,13,4),(2,225,0,1,13,4),(2,226,0,1,13,4),(2,227,0,1,13,4),(2,228,0,1,13,4),(2,229,0,1,13,4),(2,230,0,1,13,4),(2,231,0,1,13,4),(2,232,0,1,13,4),(2,233,0,1,13,4),(2,234,0,1,13,4),(2,235,0,1,13,4),(2,236,0,1,13,4),(2,237,0,1,13,4),(2,238,0,1,13,4),(2,239,0,1,13,4),(2,240,0,1,13,4),(2,241,0,1,13,4),(2,244,0,1,13,4),(2,246,0,1,13,4),(2,251,0,1,13,4),(2,255,0,1,13,4),(2,258,0,1,13,4),(2,259,0,1,13,4),(2,260,0,1,13,4),(2,261,0,1,13,4),(2,262,0,1,13,4),(2,263,0,1,13,4),(3,1,0,1,13,4),(3,2,0,1,13,4),(3,3,0,1,13,4),(3,4,0,1,13,4),(3,5,0,1,13,4),(3,6,0,1,13,4),(3,7,0,1,13,4),(3,8,0,1,13,4),(3,10,0,1,13,4),(3,11,0,1,13,4),(4,12,0,1,13,4),(4,13,0,1,13,4),(4,14,0,1,13,4),(4,15,0,1,13,4),(4,16,0,1,13,4),(4,17,0,1,13,4),(4,18,0,1,13,4),(4,19,0,1,13,4),(4,36,0,1,13,4),(4,37,0,1,13,4),(4,38,0,1,13,4),(4,39,0,1,13,4),(4,40,0,1,13,4),(5,95,10000,0,13,4),(5,96,10000,0,13,4),(5,97,10000,0,13,4),(5,98,10000,0,13,4),(5,99,10000,0,13,4),(5,100,10000,0,13,4),(7,101,10000,0,13,4),(7,102,10000,0,13,4),(7,103,10000,0,13,4),(7,104,10000,0,13,4),(7,105,10000,0,13,4),(7,106,10000,0,13,4),(7,107,10000,0,13,4),(7,108,10000,0,13,4),(7,109,10000,0,13,4),(7,110,10000,0,13,4),(7,111,10000,0,13,4),(7,112,10000,0,13,4),(7,21,0,1,13,4),(7,22,0,1,13,4),(7,26,0,1,13,4),(8,61,0,1,13,4),(8,62,0,1,13,4),(8,63,0,1,13,4),(8,64,0,1,13,4),(8,65,0,1,13,4),(8,66,0,1,13,4),(11,4,10000,0,13,4),(11,89,10000,0,13,4),(11,90,10000,0,13,4),(11,91,10000,0,13,4),(11,92,10000,0,13,4),(11,93,10000,0,13,4),(11,94,10000,0,13,4),(11,28,0,1,13,4),(11,29,0,1,13,4),(11,30,0,1,13,4),(11,31,0,1,13,4),(11,32,0,1,13,4),(11,33,0,1,13,4),(11,34,0,1,13,4),(11,35,0,1,13,4),(13,21,0,1,13,4),(13,24,0,1,13,4),(13,25,0,1,13,4),(13,26,0,1,13,4),(13,27,0,1,13,4),(13,41,0,1,13,4),(13,42,0,1,13,4),(13,43,0,1,13,4),(13,44,0,1,13,4),(13,45,0,1,13,4),(13,46,0,1,13,4),(13,47,0,1,13,4),(13,48,0,1,13,4),(13,49,0,1,13,4),(15,22,10000,0,13,4),(15,23,10000,0,13,4),(16,20,0,1,13,4),(16,21,0,1,13,4),(16,22,0,1,13,4),(16,23,0,1,13,4),(16,24,0,1,13,4),(16,25,0,1,13,4),(16,26,0,1,13,4),(16,27,0,1,13,4),(16,41,0,1,13,4),(16,68,0,1,13,4),(16,69,0,1,13,4),(16,70,0,1,13,4),(16,71,0,1,13,4),(16,72,0,1,13,4),(16,73,0,1,13,4),(19,6,0,1,13,4),(19,7,0,1,13,4),(19,8,0,1,13,4),(19,10,0,1,13,4),(19,11,0,1,13,4),(27,11,0,1,13,4),(29,6,0,1,13,4),(29,8,0,1,13,4),(29,10,0,1,13,4),(30,6,0,1,13,4),(30,10,0,1,13,4),(33,7,0,1,13,4),(33,8,0,1,13,4),(33,10,0,1,13,4),(33,11,0,1,13,4),(42,7,0,1,13,4),(42,8,0,1,13,4),(42,11,0,1,13,4),(78,21,0,1,13,4),(78,26,0,1,13,4),(80,21,0,1,13,4),(80,22,0,1,13,4),(80,26,0,1,13,4),(81,26,0,1,13,4),(82,26,0,1,13,4),(83,26,0,1,13,4),(96,26,0,1,13,4),(97,26,0,1,13,4),(98,21,0,1,13,4),(98,22,0,1,13,4),(98,26,0,1,13,4),(99,18,0,1,13,4),(101,14,0,1,13,4),(101,15,0,1,13,4),(101,16,0,1,13,4),(102,12,0,1,13,4),(102,13,0,1,13,4),(102,14,0,1,13,4),(102,15,0,1,13,4),(102,16,0,1,13,4),(102,17,0,1,13,4),(102,19,0,1,13,4),(102,36,0,1,13,4),(102,37,0,1,13,4),(102,38,0,1,13,4),(102,39,0,1,13,4),(102,40,0,1,13,4),(103,18,0,1,13,4),(104,18,0,1,13,4),(105,18,0,1,13,4),(106,18,0,1,13,4),(107,18,0,1,13,4),(134,23,0,1,13,4),(135,22,0,1,13,4),(137,4,0,1,13,4),(137,28,0,1,13,4),(137,31,0,1,13,4),(137,34,0,1,13,4),(137,35,0,1,13,4),(138,28,0,1,13,4),(138,30,0,1,13,4),(138,32,0,1,13,4),(138,33,0,1,13,4),(139,28,0,1,13,4),(139,30,0,1,13,4),(139,32,0,1,13,4),(139,33,0,1,13,4),(140,28,0,1,13,4),(140,30,0,1,13,4),(140,32,0,1,13,4),(140,33,0,1,13,4),(145,1,0,1,13,4),(145,2,0,1,13,4),(145,3,0,1,13,4),(145,4,0,1,13,4),(145,5,0,1,13,4),(145,6,0,1,13,4),(145,7,0,1,13,4),(145,8,0,1,13,4),(145,9,0,1,13,4),(145,10,0,1,13,4),(145,11,0,1,13,4),(145,12,0,1,13,4),(145,13,0,1,13,4),(145,14,0,1,13,4),(145,15,0,1,13,4),(145,16,0,1,13,4),(145,17,0,1,13,4),(145,18,0,1,13,4),(145,19,0,1,13,4),(145,20,0,1,13,4),(145,21,0,1,13,4),(145,22,0,1,13,4),(145,23,0,1,13,4),(145,24,0,1,13,4),(145,25,0,1,13,4),(145,26,0,1,13,4),(145,27,0,1,13,4),(145,28,0,1,13,4),(145,29,0,1,13,4),(145,30,0,1,13,4),(145,31,0,1,13,4),(145,32,0,1,13,4),(145,33,0,1,13,4),(145,34,0,1,13,4),(145,35,0,1,13,4),(145,36,0,1,13,4),(145,37,0,1,13,4),(145,38,0,1,13,4),(145,39,0,1,13,4),(145,40,0,1,13,4),(145,41,0,1,13,4),(145,42,0,1,13,4),(145,43,0,1,13,4),(149,41,0,1,13,4),(150,50,0,1,13,4),(150,57,0,1,13,4),(150,58,0,1,13,4),(150,59,0,1,13,4),(150,60,0,1,13,4),(151,61,0,1,13,4),(151,62,0,1,13,4),(151,63,0,1,13,4),(151,64,0,1,13,4),(151,65,0,1,13,4),(151,66,0,1,13,4),(152,61,0,1,13,4),(152,63,0,1,13,4),(153,61,0,1,13,4),(153,63,0,1,13,4),(153,64,0,1,13,4),(153,65,0,1,13,4),(153,66,0,1,13,4),(154,61,0,1,13,4),(154,62,0,1,13,4),(154,64,0,1,13,4),(154,66,0,1,13,4),(155,61,0,1,13,4),(155,62,0,1,13,4),(155,64,0,1,13,4),(155,65,0,1,13,4),(155,66,0,1,13,4),(156,61,0,1,13,4),(156,62,0,1,13,4),(156,63,0,1,13,4),(156,64,0,1,13,4),(156,65,0,1,13,4),(156,66,0,1,13,4),(157,61,0,1,13,4),(157,62,0,1,13,4),(157,64,0,1,13,4),(157,65,0,1,13,4),(157,66,0,1,13,4),(158,61,0,1,13,4),(158,63,0,1,13,4),(158,64,0,1,13,4),(158,65,0,1,13,4),(158,66,0,1,13,4),(159,61,0,1,13,4),(159,62,0,1,13,4),(159,63,0,1,13,4),(159,64,0,1,13,4),(159,65,0,1,13,4),(159,66,0,1,13,4),(160,41,0,1,13,4),(160,68,0,1,13,4),(160,69,0,1,13,4),(160,70,0,1,13,4),(160,72,0,1,13,4),(160,73,0,1,13,4),(161,68,0,1,13,4),(161,69,0,1,13,4),(161,70,0,1,13,4),(161,71,0,1,13,4),(161,72,0,1,13,4),(162,68,0,1,13,4),(162,69,0,1,13,4),(162,72,0,1,13,4),(164,41,0,1,13,4),(164,70,0,1,13,4),(164,73,0,1,13,4),(166,41,0,1,13,4),(166,70,0,1,13,4),(166,73,0,1,13,4),(167,68,0,1,13,4),(167,69,0,1,13,4),(167,72,0,1,13,4),(168,71,0,1,13,4),(169,70,0,1,13,4),(171,70,0,1,13,4),(172,1,10000,0,13,4),(172,2,10000,0,13,4),(172,3,10000,0,13,4),(172,4,10000,0,13,4),(172,5,10000,0,13,4),(172,6,10000,0,13,4),(172,7,10000,0,13,4),(172,8,10000,0,13,4),(172,9,10000,0,13,4),(172,10,10000,0,13,4),(172,11,10000,0,13,4),(172,12,10000,0,13,4),(172,13,10000,0,13,4),(172,14,10000,0,13,4),(172,15,10000,0,13,4),(172,16,10000,0,13,4),(172,17,10000,0,13,4),(172,18,10000,0,13,4),(172,19,10000,0,13,4),(172,20,10000,0,13,4),(172,21,10000,0,13,4),(172,22,10000,0,13,4),(172,23,10000,0,13,4),(172,24,10000,0,13,4),(172,25,10000,0,13,4),(172,26,10000,0,13,4),(172,27,10000,0,13,4),(172,28,10000,0,13,4),(172,29,10000,0,13,4),(172,30,10000,0,13,4),(173,1,0,1,13,4),(173,2,0,1,13,4),(173,3,0,1,13,4),(173,4,0,1,13,4),(173,5,0,1,13,4),(173,6,0,1,13,4),(173,7,0,1,13,4),(173,8,0,1,13,4),(173,9,0,1,13,4),(173,10,0,1,13,4),(173,11,0,1,13,4),(173,12,0,1,13,4),(173,13,0,1,13,4),(173,14,0,1,13,4),(173,15,0,1,13,4),(173,16,0,1,13,4),(173,17,0,1,13,4),(173,18,0,1,13,4),(173,19,0,1,13,4),(173,20,0,1,13,4),(173,21,0,1,13,4),(173,22,0,1,13,4),(173,23,0,1,13,4),(173,24,0,1,13,4),(173,25,0,1,13,4),(173,26,0,1,13,4),(173,27,0,1,13,4),(173,28,0,1,13,4),(173,29,0,1,13,4),(173,30,0,1,13,4),(174,1,0,1,13,4),(174,2,0,1,13,4),(174,3,0,1,13,4),(174,4,0,1,13,4),(174,5,0,1,13,4),(174,6,0,1,13,4),(174,7,0,1,13,4),(174,8,0,1,13,4),(174,9,0,1,13,4),(174,10,0,1,13,4),(174,11,0,1,13,4),(174,12,0,1,13,4),(174,13,0,1,13,4),(174,14,0,1,13,4),(174,15,0,1,13,4),(174,16,0,1,13,4),(174,17,0,1,13,4),(174,18,0,1,13,4),(174,19,0,1,13,4),(174,20,0,1,13,4),(174,21,0,1,13,4),(174,22,0,1,13,4),(174,23,0,1,13,4),(174,24,0,1,13,4),(174,25,0,1,13,4),(174,26,0,1,13,4),(174,27,0,1,13,4),(174,28,0,1,13,4),(174,29,0,1,13,4),(174,30,0,1,13,4),(175,1,0,1,13,4),(175,2,0,1,13,4),(175,3,0,1,13,4),(175,4,0,1,13,4),(175,5,0,1,13,4),(175,6,0,1,13,4),(175,7,0,1,13,4),(175,8,0,1,13,4),(175,9,0,1,13,4),(175,10,0,1,13,4),(175,11,0,1,13,4),(175,12,0,1,13,4),(175,13,0,1,13,4),(175,14,0,1,13,4),(175,15,0,1,13,4),(175,16,0,1,13,4),(175,17,0,1,13,4),(175,18,0,1,13,4),(175,19,0,1,13,4),(175,20,0,1,13,4),(175,21,0,1,13,4),(175,22,0,1,13,4),(175,23,0,1,13,4),(175,24,0,1,13,4),(175,25,0,1,13,4),(175,26,0,1,13,4),(175,27,0,1,13,4),(175,28,0,1,13,4),(175,29,0,1,13,4),(175,30,0,1,13,4),(176,1,0,1,13,4),(176,2,0,1,13,4),(176,3,0,1,13,4),(176,4,0,1,13,4),(176,5,0,1,13,4),(176,6,0,1,13,4),(176,7,0,1,13,4),(176,8,0,1,13,4),(176,9,0,1,13,4),(176,10,0,1,13,4),(176,11,0,1,13,4),(176,12,0,1,13,4),(176,13,0,1,13,4),(176,14,0,1,13,4),(176,15,0,1,13,4),(176,16,0,1,13,4),(176,17,0,1,13,4),(176,18,0,1,13,4),(176,19,0,1,13,4),(176,20,0,1,13,4),(176,21,0,1,13,4),(176,22,0,1,13,4),(176,23,0,1,13,4),(176,24,0,1,13,4),(176,25,0,1,13,4),(176,26,0,1,13,4),(176,27,0,1,13,4),(176,28,0,1,13,4),(176,29,0,1,13,4),(176,30,0,1,13,4),(177,74,0,1,13,4),(177,75,0,1,13,4),(177,76,0,1,13,4),(177,77,0,1,13,4),(177,78,0,1,13,4),(177,79,0,1,13,4),(177,80,0,1,13,4),(178,74,10000,0,13,4),(178,75,10000,0,13,4),(178,76,10000,0,13,4),(178,77,10000,0,13,4),(178,78,10000,0,13,4),(178,79,10000,0,13,4),(178,80,10000,0,13,4),(178,81,10000,0,13,4),(178,82,10000,0,13,4),(178,83,10000,0,13,4),(178,84,10000,0,13,4),(178,85,10000,0,13,4),(178,86,10000,0,13,4),(178,87,10000,0,13,4),(178,88,10000,0,13,4),(178,113,10000,0,13,4),(178,114,10000,0,13,4),(178,115,10000,0,13,4),(178,116,10000,0,13,4),(178,117,10000,0,13,4),(178,118,10000,0,13,4),(178,119,10000,0,13,4),(178,120,10000,0,13,4),(178,121,10000,0,13,4),(178,122,10000,0,13,4),(178,123,10000,0,13,4),(178,124,10000,0,13,4),(178,125,10000,0,13,4),(178,126,10000,0,13,4),(178,127,10000,0,13,4),(178,128,10000,0,13,4),(178,129,10000,0,13,4),(178,130,10000,0,13,4),(178,131,10000,0,13,4),(178,132,10000,0,13,4),(178,133,10000,0,13,4),(178,134,10000,0,13,4),(178,135,10000,0,13,4),(178,136,10000,0,13,4),(178,137,10000,0,13,4),(178,138,10000,0,13,4),(178,139,10000,0,13,4),(178,140,10000,0,13,4),(178,141,10000,0,13,4),(178,142,10000,0,13,4),(178,143,10000,0,13,4),(178,144,10000,0,13,4),(178,145,10000,0,13,4),(178,146,10000,0,13,4),(178,147,10000,0,13,4),(178,148,10000,0,13,4),(178,149,10000,0,13,4),(178,150,10000,0,13,4),(178,151,10000,0,13,4),(178,152,10000,0,13,4),(178,153,10000,0,13,4),(178,154,10000,0,13,4),(178,155,10000,0,13,4),(178,156,10000,0,13,4),(178,157,10000,0,13,4),(178,158,10000,0,13,4),(178,159,10000,0,13,4),(178,160,10000,0,13,4),(178,161,10000,0,13,4),(178,162,10000,0,13,4),(178,163,10000,0,13,4),(178,164,10000,0,13,4),(178,165,10000,0,13,4),(178,166,10000,0,13,4),(178,167,10000,0,13,4),(178,168,10000,0,13,4),(178,169,10000,0,13,4),(178,170,10000,0,13,4),(178,171,10000,0,13,4),(178,172,10000,0,13,4),(178,173,10000,0,13,4),(178,174,10000,0,13,4),(178,175,10000,0,13,4),(178,176,10000,0,13,4),(178,177,10000,0,13,4),(178,178,10000,0,13,4),(178,179,10000,0,13,4),(178,180,10000,0,13,4),(178,181,10000,0,13,4),(178,182,10000,0,13,4),(178,183,10000,0,13,4),(178,184,10000,0,13,4),(178,185,10000,0,13,4),(178,186,10000,0,13,4),(178,187,10000,0,13,4),(178,188,10000,0,13,4),(178,189,10000,0,13,4),(178,190,10000,0,13,4),(178,191,10000,0,13,4),(178,192,10000,0,13,4),(178,193,10000,0,13,4),(178,194,10000,0,13,4),(178,195,10000,0,13,4),(178,196,10000,0,13,4),(178,197,10000,0,13,4),(178,198,10000,0,13,4),(178,199,10000,0,13,4),(178,200,10000,0,13,4),(178,201,10000,0,13,4),(178,202,10000,0,13,4),(178,203,10000,0,13,4),(178,204,10000,0,13,4),(178,205,10000,0,13,4),(178,206,10000,0,13,4),(178,207,10000,0,13,4),(178,208,10000,0,13,4),(178,209,10000,0,13,4),(178,210,10000,0,13,4),(178,211,10000,0,13,4),(178,212,10000,0,13,4),(178,213,10000,0,13,4),(178,214,10000,0,13,4),(178,215,10000,0,13,4),(178,216,10000,0,13,4),(178,217,10000,0,13,4),(178,218,10000,0,13,4),(178,219,10000,0,13,4),(178,220,10000,0,13,4),(178,221,10000,0,13,4),(178,222,10000,0,13,4),(178,223,10000,0,13,4),(178,224,10000,0,13,4),(178,225,10000,0,13,4),(178,226,10000,0,13,4),(178,227,10000,0,13,4),(178,228,10000,0,13,4),(178,229,10000,0,13,4),(178,230,10000,0,13,4),(178,231,10000,0,13,4),(178,232,10000,0,13,4),(178,233,10000,0,13,4),(178,234,10000,0,13,4),(178,235,10000,0,13,4),(178,236,10000,0,13,4),(178,237,10000,0,13,4),(178,238,10000,0,13,4),(178,239,10000,0,13,4),(178,240,10000,0,13,4),(178,241,10000,0,13,4),(178,244,10000,0,13,4),(178,246,10000,0,13,4),(178,251,10000,0,13,4),(178,255,10000,0,13,4),(178,258,10000,0,13,4),(178,259,10000,0,13,4),(178,260,10000,0,13,4),(178,261,10000,0,13,4),(178,262,10000,0,13,4),(178,263,10000,0,13,4),(179,81,0,1,13,4),(179,82,0,1,13,4),(179,83,0,1,13,4),(179,84,0,1,13,4),(179,85,0,1,13,4),(179,86,0,1,13,4),(179,87,0,1,13,4),(179,88,0,1,13,4),(180,81,0,1,13,4),(181,86,0,1,13,4),(182,82,0,1,13,4),(182,83,0,1,13,4),(182,84,0,1,13,4),(182,85,0,1,13,4),(182,87,0,1,13,4),(182,88,0,1,13,4),(183,82,0,1,13,4),(183,83,0,1,13,4),(183,84,0,1,13,4),(183,85,0,1,13,4),(183,86,0,1,13,4),(183,87,0,1,13,4),(183,88,0,1,13,4),(192,89,0,1,13,4),(192,90,0,1,13,4),(192,91,0,1,13,4),(192,92,0,1,13,4),(192,93,0,1,13,4),(192,94,0,1,13,4),(193,95,0,1,13,4),(193,96,0,1,13,4),(193,97,0,1,13,4),(193,98,0,1,13,4),(193,99,0,1,13,4),(193,100,0,1,13,4),(194,95,0,1,13,4),(194,96,0,1,13,4),(194,97,0,1,13,4),(194,98,0,1,13,4),(194,99,0,1,13,4),(194,100,0,1,13,4),(195,95,0,1,13,4),(195,96,0,1,13,4),(195,97,0,1,13,4),(195,98,0,1,13,4),(195,99,0,1,13,4),(195,100,0,1,13,4),(196,95,0,1,13,4),(196,96,0,1,13,4),(196,97,0,1,13,4),(196,98,0,1,13,4),(196,99,0,1,13,4),(196,100,0,1,13,4),(197,95,0,1,13,4),(197,96,0,1,13,4),(197,97,0,1,13,4),(197,98,0,1,13,4),(197,99,0,1,13,4),(197,100,0,1,13,4),(198,101,0,1,13,4),(198,109,0,1,13,4),(198,111,0,1,13,4),(198,112,0,1,13,4),(199,103,0,1,13,4),(199,110,0,1,13,4),(200,101,0,1,13,4),(200,102,0,1,13,4),(200,108,0,1,13,4),(201,104,0,1,13,4),(201,106,0,1,13,4),(202,101,0,1,13,4),(202,102,0,1,13,4),(202,103,0,1,13,4),(202,105,0,1,13,4),(202,107,0,1,13,4),(202,108,0,1,13,4),(202,110,0,1,13,4),(203,101,0,1,13,4),(203,102,0,1,13,4),(203,103,0,1,13,4),(203,104,0,1,13,4),(203,106,0,1,13,4),(203,108,0,1,13,4),(203,109,0,1,13,4),(204,101,0,1,13,4),(204,102,0,1,13,4),(204,103,0,1,13,4),(204,104,0,1,13,4),(204,105,0,1,13,4),(204,106,0,1,13,4),(204,107,0,1,13,4),(204,108,0,1,13,4),(205,101,0,1,13,4),(205,102,0,1,13,4),(205,103,0,1,13,4),(205,108,0,1,13,4),(205,109,0,1,13,4),(205,110,0,1,13,4),(205,111,0,1,13,4),(205,112,0,1,13,4),(206,113,10000,0,13,4),(206,114,10000,0,13,4),(206,115,10000,0,13,4),(206,116,10000,0,13,4),(206,117,10000,0,13,4),(206,118,10000,0,13,4),(206,119,10000,0,13,4),(207,114,0,1,13,4),(207,119,0,1,13,4),(209,114,0,1,13,4),(212,116,0,1,13,4),(212,118,0,1,13,4),(213,113,0,1,13,4),(218,117,0,1,13,4),(219,119,0,1,13,4),(220,119,0,1,13,4),(221,119,0,1,13,4),(222,114,0,1,13,4),(222,119,0,1,13,4),(223,114,0,1,13,4),(223,119,0,1,13,4),(229,113,0,1,13,4),(230,113,0,1,13,4),(231,113,0,1,13,4),(232,113,0,1,13,4),(233,113,0,1,13,4),(234,116,0,1,13,4),(234,118,0,1,13,4),(235,116,0,1,13,4),(235,118,0,1,13,4),(236,116,0,1,13,4),(236,118,0,1,13,4),(237,116,0,1,13,4),(237,118,0,1,13,4),(238,116,0,1,13,4),(238,118,0,1,13,4),(239,115,0,1,13,4),(241,115,0,1,13,4),(242,115,0,1,13,4),(243,115,0,1,13,4),(250,120,0,1,13,4),(250,121,0,1,13,4),(250,122,0,1,13,4),(250,123,0,1,13,4),(250,124,0,1,13,4),(250,125,0,1,13,4),(250,126,0,1,13,4),(250,127,0,1,13,4),(250,128,0,1,13,4),(250,129,0,1,13,4),(250,130,0,1,13,4),(250,131,0,1,13,4),(251,120,0,1,13,4),(251,121,0,1,13,4),(251,122,0,1,13,4),(251,123,0,1,13,4),(251,124,0,1,13,4),(251,125,0,1,13,4),(251,126,0,1,13,4),(251,127,0,1,13,4),(251,128,0,1,13,4),(251,129,0,1,13,4),(251,130,0,1,13,4),(251,131,0,1,13,4),(252,125,10000,0,13,4),(252,126,10000,0,13,4),(252,127,10000,0,13,4),(252,120,0,1,13,4),(252,121,0,1,13,4),(252,122,0,1,13,4),(252,123,0,1,13,4),(252,124,0,1,13,4),(252,128,0,1,13,4),(252,129,0,1,13,4),(252,131,0,1,13,4),(253,120,0,1,13,4),(253,121,0,1,13,4),(253,122,0,1,13,4),(253,123,0,1,13,4),(253,124,0,1,13,4),(253,125,0,1,13,4),(253,126,0,1,13,4),(253,127,0,1,13,4),(253,128,0,1,13,4),(253,129,0,1,13,4),(253,130,0,1,13,4),(253,131,0,1,13,4),(254,120,0,1,13,4),(254,121,0,1,13,4),(254,122,0,1,13,4),(254,123,0,1,13,4),(254,124,0,1,13,4),(254,125,0,1,13,4),(254,126,0,1,13,4),(254,127,0,1,13,4),(254,128,0,1,13,4),(254,129,0,1,13,4),(254,130,0,1,13,4),(254,131,0,1,13,4),(255,122,0,1,13,4),(255,123,0,1,13,4),(255,124,0,1,13,4),(255,125,0,1,13,4),(255,126,0,1,13,4),(255,129,0,1,13,4),(256,121,0,1,13,4),(256,122,0,1,13,4),(256,123,0,1,13,4),(256,125,0,1,13,4),(256,126,0,1,13,4),(256,127,0,1,13,4),(257,121,0,1,13,4),(257,122,0,1,13,4),(257,123,0,1,13,4),(257,125,0,1,13,4),(257,127,0,1,13,4),(257,129,0,1,13,4),(258,121,0,1,13,4),(258,122,0,1,13,4),(258,125,0,1,13,4),(258,126,0,1,13,4),(258,127,0,1,13,4),(258,129,0,1,13,4),(259,120,0,1,13,4),(259,121,0,1,13,4),(259,123,0,1,13,4),(259,128,0,1,13,4),(259,129,0,1,13,4),(260,120,0,1,13,4),(260,121,0,1,13,4),(260,122,0,1,13,4),(260,123,0,1,13,4),(260,125,0,1,13,4),(260,127,0,1,13,4),(260,128,0,1,13,4),(260,129,0,1,13,4),(261,121,0,1,13,4),(261,122,0,1,13,4),(261,125,0,1,13,4),(261,126,0,1,13,4),(261,127,0,1,13,4),(261,129,0,1,13,4),(262,125,0,1,13,4),(262,126,0,1,13,4),(263,120,0,1,13,4),(263,121,0,1,13,4),(263,122,0,1,13,4),(263,123,0,1,13,4),(263,124,0,1,13,4),(263,128,0,1,13,4),(263,129,0,1,13,4),(263,131,0,1,13,4),(264,120,0,1,13,4),(264,122,0,1,13,4),(264,123,0,1,13,4),(264,125,0,1,13,4),(264,126,0,1,13,4),(264,129,0,1,13,4),(265,121,0,1,13,4),(265,122,0,1,13,4),(265,123,0,1,13,4),(265,127,0,1,13,4),(266,123,0,1,13,4),(266,125,0,1,13,4),(266,126,0,1,13,4),(266,127,0,1,13,4),(266,129,0,1,13,4),(267,121,0,1,13,4),(267,125,0,1,13,4),(267,126,0,1,13,4),(267,127,0,1,13,4),(268,120,0,1,13,4),(268,121,0,1,13,4),(268,122,0,1,13,4),(268,123,0,1,13,4),(268,124,0,1,13,4),(268,127,0,1,13,4),(268,129,0,1,13,4),(269,122,0,1,13,4),(269,125,0,1,13,4),(269,126,0,1,13,4),(269,127,0,1,13,4),(269,129,0,1,13,4),(270,121,0,1,13,4),(270,123,0,1,13,4),(270,125,0,1,13,4),(270,126,0,1,13,4),(270,129,0,1,13,4),(271,120,0,1,13,4),(271,121,0,1,13,4),(271,122,0,1,13,4),(271,125,0,1,13,4),(271,126,0,1,13,4),(271,127,0,1,13,4),(271,129,0,1,13,4),(272,122,0,1,13,4),(272,123,0,1,13,4),(272,124,0,1,13,4),(272,125,0,1,13,4),(272,126,0,1,13,4),(272,127,0,1,13,4),(272,128,0,1,13,4),(272,129,0,1,13,4),(273,120,0,1,13,4),(273,121,0,1,13,4),(273,123,0,1,13,4),(273,126,0,1,13,4),(273,127,0,1,13,4),(274,122,0,1,13,4),(274,123,0,1,13,4),(274,125,0,1,13,4),(274,126,0,1,13,4),(274,129,0,1,13,4),(275,120,0,1,13,4),(275,121,0,1,13,4),(275,122,0,1,13,4),(275,123,0,1,13,4),(275,124,0,1,13,4),(275,125,0,1,13,4),(275,126,0,1,13,4),(275,127,0,1,13,4),(275,128,0,1,13,4),(275,129,0,1,13,4),(275,130,0,1,13,4),(275,131,0,1,13,4),(276,122,0,1,13,4),(276,123,0,1,13,4),(276,127,0,1,13,4),(276,129,0,1,13,4),(277,120,0,1,13,4),(277,121,0,1,13,4),(277,123,0,1,13,4),(277,124,0,1,13,4),(277,125,0,1,13,4),(277,126,0,1,13,4),(277,127,0,1,13,4),(278,120,0,1,13,4),(278,121,0,1,13,4),(278,122,0,1,13,4),(278,123,0,1,13,4),(278,124,0,1,13,4),(278,125,0,1,13,4),(278,127,0,1,13,4),(278,128,0,1,13,4),(278,129,0,1,13,4),(279,120,0,1,13,4),(279,122,0,1,13,4),(279,126,0,1,13,4),(279,127,0,1,13,4),(279,129,0,1,13,4),(280,132,0,1,13,4),(280,133,0,1,13,4),(280,134,0,1,13,4),(280,135,0,1,13,4),(280,136,0,1,13,4),(280,137,0,1,13,4),(280,138,0,1,13,4),(280,139,0,1,13,4),(282,132,0,1,13,4),(282,133,0,1,13,4),(282,134,0,1,13,4),(282,137,0,1,13,4),(282,138,0,1,13,4),(283,135,0,1,13,4),(283,136,0,1,13,4),(283,139,0,1,13,4),(286,140,0,1,13,4),(286,141,0,1,13,4),(286,142,0,1,13,4),(286,143,0,1,13,4),(286,144,0,1,13,4),(286,145,0,1,13,4),(286,146,0,1,13,4),(286,147,0,1,13,4),(286,148,0,1,13,4),(286,149,0,1,13,4),(286,150,0,1,13,4),(286,151,0,1,13,4),(286,152,0,1,13,4),(286,153,0,1,13,4),(286,154,0,1,13,4),(286,155,0,1,13,4),(286,156,0,1,13,4),(286,157,0,1,13,4),(286,158,0,1,13,4),(286,159,0,1,13,4),(286,160,0,1,13,4),(286,161,0,1,13,4),(286,162,0,1,13,4),(286,163,0,1,13,4),(286,164,0,1,13,4),(286,165,0,1,13,4),(286,166,0,1,13,4),(286,167,0,1,13,4),(286,168,0,1,13,4),(286,169,0,1,13,4),(286,170,0,1,13,4),(286,171,0,1,13,4),(286,172,0,1,13,4),(286,173,0,1,13,4),(286,174,0,1,13,4),(286,175,0,1,13,4),(286,176,0,1,13,4),(286,177,0,1,13,4),(286,178,0,1,13,4),(286,179,0,1,13,4),(286,180,0,1,13,4),(286,181,0,1,13,4),(286,182,0,1,13,4),(286,183,0,1,13,4),(286,184,0,1,13,4),(286,185,0,1,13,4),(286,186,0,1,13,4),(286,187,0,1,13,4),(287,188,0,1,13,4),(288,189,0,1,13,4),(288,190,0,1,13,4),(288,191,0,1,13,4),(288,192,0,1,13,4),(288,193,0,1,13,4),(288,194,0,1,13,4),(288,195,0,1,13,4),(288,196,0,1,13,4),(288,197,0,1,13,4),(288,198,0,1,13,4),(288,199,0,1,13,4),(288,200,0,1,13,4),(289,201,10000,0,13,4),(289,202,10000,0,13,4),(289,203,10000,0,13,4),(289,204,10000,0,13,4),(289,205,10000,0,13,4),(289,206,10000,0,13,4),(289,207,10000,0,13,4),(289,208,10000,0,13,4),(289,209,10000,0,13,4),(289,210,10000,0,13,4),(289,211,10000,0,13,4),(289,212,10000,0,13,4),(289,213,10000,0,13,4),(289,214,10000,0,13,4),(289,215,10000,0,13,4),(289,216,10000,0,13,4),(289,217,10000,0,13,4),(289,218,10000,0,13,4),(289,219,10000,0,13,4),(289,220,10000,0,13,4),(289,221,10000,0,13,4),(289,222,10000,0,13,4),(289,223,10000,0,13,4),(289,224,10000,0,13,4),(289,225,10000,0,13,4),(289,226,10000,0,13,4),(289,227,10000,0,13,4),(289,228,10000,0,13,4),(289,229,10000,0,13,4),(289,230,10000,0,13,4),(289,231,10000,0,13,4),(289,232,10000,0,13,4),(289,244,10000,0,13,4),(289,246,10000,0,13,4),(289,251,10000,0,13,4),(289,255,10000,0,13,4),(289,258,10000,0,13,4),(289,259,10000,0,13,4),(289,260,10000,0,13,4),(289,261,10000,0,13,4),(289,262,10000,0,13,4),(289,263,10000,0,13,4),(290,209,0,1,13,4),(290,210,0,1,13,4),(290,211,0,1,13,4),(290,212,0,1,13,4),(290,213,0,1,13,4),(290,214,0,1,13,4),(290,215,0,1,13,4),(290,216,0,1,13,4),(291,201,0,1,13,4),(291,202,0,1,13,4),(291,203,0,1,13,4),(291,204,0,1,13,4),(291,205,0,1,13,4),(291,206,0,1,13,4),(291,207,0,1,13,4),(291,208,0,1,13,4),(292,217,0,1,13,4),(292,218,0,1,13,4),(292,219,0,1,13,4),(292,220,0,1,13,4),(292,221,0,1,13,4),(292,222,0,1,13,4),(292,223,0,1,13,4),(292,224,0,1,13,4),(293,225,0,1,13,4),(293,226,0,1,13,4),(293,227,0,1,13,4),(293,228,0,1,13,4),(293,229,0,1,13,4),(293,230,0,1,13,4),(293,231,0,1,13,4),(293,232,0,1,13,4),(293,255,0,1,13,4),(293,259,0,1,13,4),(293,260,0,1,13,4),(293,261,0,1,13,4),(293,262,0,1,13,4),(293,263,0,1,13,4),(294,233,0,1,13,4),(294,234,0,1,13,4),(294,235,0,1,13,4),(294,236,0,1,13,4),(294,237,0,1,13,4),(294,238,0,1,13,4),(294,239,0,1,13,4),(294,240,0,1,13,4),(294,241,0,1,13,4),(295,244,0,1,13,4),(295,246,0,1,13,4),(295,251,0,1,13,4),(295,255,0,1,13,4),(295,258,0,1,13,4),(296,251,0,1,13,4),(296,255,0,1,13,4),(296,258,0,1,13,4),(297,246,0,1,13,4),(297,255,0,1,13,4),(297,258,0,1,13,4),(298,255,0,1,13,4),(298,258,0,1,13,4),(299,251,0,1,13,4),(299,258,0,1,13,4);
/*!40000 ALTER TABLE `catalog_category_product_index_store13` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index_store13_replica`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store13_replica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store13_replica` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `IDX_8389A453B1D17695872A3F5AB53CED55` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_15E0763074BBF12DA79E845D659BCC7F` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Product Index Store13 Replica';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index_store13_replica`
--

LOCK TABLES `catalog_category_product_index_store13_replica` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index_store13_replica` DISABLE KEYS */;
INSERT INTO `catalog_category_product_index_store13_replica` VALUES (2,1,0,1,13,4),(2,2,0,1,13,4),(2,3,0,1,13,4),(2,4,0,1,13,4),(2,5,0,1,13,4),(2,6,0,1,13,4),(2,7,0,1,13,4),(2,8,0,1,13,4),(2,9,0,1,13,4),(2,10,0,1,13,4),(2,11,0,1,13,4),(2,12,0,1,13,4),(2,13,0,1,13,4),(2,14,0,1,13,4),(2,15,0,1,13,4),(2,16,0,1,13,4),(2,17,0,1,13,4),(2,18,0,1,13,4),(2,19,0,1,13,4),(2,20,0,1,13,4),(2,21,0,1,13,4),(2,22,0,1,13,4),(2,23,0,1,13,4),(2,24,0,1,13,4),(2,25,0,1,13,4),(2,26,0,1,13,4),(2,27,0,1,13,4),(2,28,0,1,13,4),(2,29,0,1,13,4),(2,30,0,1,13,4),(2,31,0,1,13,4),(2,32,0,1,13,4),(2,33,0,1,13,4),(2,34,0,1,13,4),(2,35,0,1,13,4),(2,36,0,1,13,4),(2,37,0,1,13,4),(2,38,0,1,13,4),(2,39,0,1,13,4),(2,40,0,1,13,4),(2,41,0,1,13,4),(2,42,0,1,13,4),(2,43,0,1,13,4),(2,44,0,1,13,4),(2,45,0,1,13,4),(2,46,0,1,13,4),(2,47,0,1,13,4),(2,48,0,1,13,4),(2,49,0,1,13,4),(2,50,0,1,13,4),(2,57,0,1,13,4),(2,58,0,1,13,4),(2,59,0,1,13,4),(2,60,0,1,13,4),(2,61,0,1,13,4),(2,62,0,1,13,4),(2,63,0,1,13,4),(2,64,0,1,13,4),(2,65,0,1,13,4),(2,66,0,1,13,4),(2,68,0,1,13,4),(2,69,0,1,13,4),(2,70,0,1,13,4),(2,71,0,1,13,4),(2,72,0,1,13,4),(2,73,0,1,13,4),(2,74,0,1,13,4),(2,75,0,1,13,4),(2,76,0,1,13,4),(2,77,0,1,13,4),(2,78,0,1,13,4),(2,79,0,1,13,4),(2,80,0,1,13,4),(2,81,0,1,13,4),(2,82,0,1,13,4),(2,83,0,1,13,4),(2,84,0,1,13,4),(2,85,0,1,13,4),(2,86,0,1,13,4),(2,87,0,1,13,4),(2,88,0,1,13,4),(2,89,0,1,13,4),(2,90,0,1,13,4),(2,91,0,1,13,4),(2,92,0,1,13,4),(2,93,0,1,13,4),(2,94,0,1,13,4),(2,95,0,1,13,4),(2,96,0,1,13,4),(2,97,0,1,13,4),(2,98,0,1,13,4),(2,99,0,1,13,4),(2,100,0,1,13,4),(2,101,0,1,13,4),(2,102,0,1,13,4),(2,103,0,1,13,4),(2,104,0,1,13,4),(2,105,0,1,13,4),(2,106,0,1,13,4),(2,107,0,1,13,4),(2,108,0,1,13,4),(2,109,0,1,13,4),(2,110,0,1,13,4),(2,111,0,1,13,4),(2,112,0,1,13,4),(2,113,0,1,13,4),(2,114,0,1,13,4),(2,115,0,1,13,4),(2,116,0,1,13,4),(2,117,0,1,13,4),(2,118,0,1,13,4),(2,119,0,1,13,4),(2,120,0,1,13,4),(2,121,0,1,13,4),(2,122,0,1,13,4),(2,123,0,1,13,4),(2,124,0,1,13,4),(2,125,0,1,13,4),(2,126,0,1,13,4),(2,127,0,1,13,4),(2,128,0,1,13,4),(2,129,0,1,13,4),(2,130,0,1,13,4),(2,131,0,1,13,4),(2,132,0,1,13,4),(2,133,0,1,13,4),(2,134,0,1,13,4),(2,135,0,1,13,4),(2,136,0,1,13,4),(2,137,0,1,13,4),(2,138,0,1,13,4),(2,139,0,1,13,4),(2,140,0,1,13,4),(2,141,0,1,13,4),(2,142,0,1,13,4),(2,143,0,1,13,4),(2,144,0,1,13,4),(2,145,0,1,13,4),(2,146,0,1,13,4),(2,147,0,1,13,4),(2,148,0,1,13,4),(2,149,0,1,13,4),(2,150,0,1,13,4),(2,151,0,1,13,4),(2,152,0,1,13,4),(2,153,0,1,13,4),(2,154,0,1,13,4),(2,155,0,1,13,4),(2,156,0,1,13,4),(2,157,0,1,13,4),(2,158,0,1,13,4),(2,159,0,1,13,4),(2,160,0,1,13,4),(2,161,0,1,13,4),(2,162,0,1,13,4),(2,163,0,1,13,4),(2,164,0,1,13,4),(2,165,0,1,13,4),(2,166,0,1,13,4),(2,167,0,1,13,4),(2,168,0,1,13,4),(2,169,0,1,13,4),(2,170,0,1,13,4),(2,171,0,1,13,4),(2,172,0,1,13,4),(2,173,0,1,13,4),(2,174,0,1,13,4),(2,175,0,1,13,4),(2,176,0,1,13,4),(2,177,0,1,13,4),(2,178,0,1,13,4),(2,179,0,1,13,4),(2,180,0,1,13,4),(2,181,0,1,13,4),(2,182,0,1,13,4),(2,183,0,1,13,4),(2,184,0,1,13,4),(2,185,0,1,13,4),(2,186,0,1,13,4),(2,187,0,1,13,4),(2,188,0,1,13,4),(2,189,0,1,13,4),(2,190,0,1,13,4),(2,191,0,1,13,4),(2,192,0,1,13,4),(2,193,0,1,13,4),(2,194,0,1,13,4),(2,195,0,1,13,4),(2,196,0,1,13,4),(2,197,0,1,13,4),(2,198,0,1,13,4),(2,199,0,1,13,4),(2,200,0,1,13,4),(2,201,0,1,13,4),(2,202,0,1,13,4),(2,203,0,1,13,4),(2,204,0,1,13,4),(2,205,0,1,13,4),(2,206,0,1,13,4),(2,207,0,1,13,4),(2,208,0,1,13,4),(2,209,0,1,13,4),(2,210,0,1,13,4),(2,211,0,1,13,4),(2,212,0,1,13,4),(2,213,0,1,13,4),(2,214,0,1,13,4),(2,215,0,1,13,4),(2,216,0,1,13,4),(2,217,0,1,13,4),(2,218,0,1,13,4),(2,219,0,1,13,4),(2,220,0,1,13,4),(2,221,0,1,13,4),(2,222,0,1,13,4),(2,223,0,1,13,4),(2,224,0,1,13,4),(2,225,0,1,13,4),(2,226,0,1,13,4),(2,227,0,1,13,4),(2,228,0,1,13,4),(2,229,0,1,13,4),(2,230,0,1,13,4),(2,231,0,1,13,4),(2,232,0,1,13,4),(2,233,0,1,13,4),(2,234,0,1,13,4),(2,235,0,1,13,4),(2,236,0,1,13,4),(2,237,0,1,13,4),(2,238,0,1,13,4),(2,239,0,1,13,4),(2,240,0,1,13,4),(2,241,0,1,13,4),(2,244,0,1,13,4),(2,246,0,1,13,4),(2,251,0,1,13,4),(2,255,0,1,13,4),(2,258,0,1,13,4),(2,259,0,1,13,4),(2,260,0,1,13,4),(2,261,0,1,13,4),(2,262,0,1,13,4),(2,263,0,1,13,4),(3,1,0,1,13,4),(3,2,0,1,13,4),(3,3,0,1,13,4),(3,4,0,1,13,4),(3,5,0,1,13,4),(3,6,0,1,13,4),(3,7,0,1,13,4),(3,8,0,1,13,4),(3,10,0,1,13,4),(3,11,0,1,13,4),(4,12,0,1,13,4),(4,13,0,1,13,4),(4,14,0,1,13,4),(4,15,0,1,13,4),(4,16,0,1,13,4),(4,17,0,1,13,4),(4,18,0,1,13,4),(4,19,0,1,13,4),(4,36,0,1,13,4),(4,37,0,1,13,4),(4,38,0,1,13,4),(4,39,0,1,13,4),(4,40,0,1,13,4),(5,95,10000,0,13,4),(5,96,10000,0,13,4),(5,97,10000,0,13,4),(5,98,10000,0,13,4),(5,99,10000,0,13,4),(5,100,10000,0,13,4),(7,101,10000,0,13,4),(7,102,10000,0,13,4),(7,103,10000,0,13,4),(7,104,10000,0,13,4),(7,105,10000,0,13,4),(7,106,10000,0,13,4),(7,107,10000,0,13,4),(7,108,10000,0,13,4),(7,109,10000,0,13,4),(7,110,10000,0,13,4),(7,111,10000,0,13,4),(7,112,10000,0,13,4),(7,21,0,1,13,4),(7,22,0,1,13,4),(7,26,0,1,13,4),(8,61,0,1,13,4),(8,62,0,1,13,4),(8,63,0,1,13,4),(8,64,0,1,13,4),(8,65,0,1,13,4),(8,66,0,1,13,4),(11,4,10000,0,13,4),(11,89,10000,0,13,4),(11,90,10000,0,13,4),(11,91,10000,0,13,4),(11,92,10000,0,13,4),(11,93,10000,0,13,4),(11,94,10000,0,13,4),(11,28,0,1,13,4),(11,29,0,1,13,4),(11,30,0,1,13,4),(11,31,0,1,13,4),(11,32,0,1,13,4),(11,33,0,1,13,4),(11,34,0,1,13,4),(11,35,0,1,13,4),(13,21,0,1,13,4),(13,24,0,1,13,4),(13,25,0,1,13,4),(13,26,0,1,13,4),(13,27,0,1,13,4),(13,41,0,1,13,4),(13,42,0,1,13,4),(13,43,0,1,13,4),(13,44,0,1,13,4),(13,45,0,1,13,4),(13,46,0,1,13,4),(13,47,0,1,13,4),(13,48,0,1,13,4),(13,49,0,1,13,4),(15,22,10000,0,13,4),(15,23,10000,0,13,4),(16,20,0,1,13,4),(16,21,0,1,13,4),(16,22,0,1,13,4),(16,23,0,1,13,4),(16,24,0,1,13,4),(16,25,0,1,13,4),(16,26,0,1,13,4),(16,27,0,1,13,4),(16,41,0,1,13,4),(16,68,0,1,13,4),(16,69,0,1,13,4),(16,70,0,1,13,4),(16,71,0,1,13,4),(16,72,0,1,13,4),(16,73,0,1,13,4),(19,6,0,1,13,4),(19,7,0,1,13,4),(19,8,0,1,13,4),(19,10,0,1,13,4),(19,11,0,1,13,4),(27,11,0,1,13,4),(29,6,0,1,13,4),(29,8,0,1,13,4),(29,10,0,1,13,4),(30,6,0,1,13,4),(30,10,0,1,13,4),(33,7,0,1,13,4),(33,8,0,1,13,4),(33,10,0,1,13,4),(33,11,0,1,13,4),(42,7,0,1,13,4),(42,8,0,1,13,4),(42,11,0,1,13,4),(78,21,0,1,13,4),(78,26,0,1,13,4),(80,21,0,1,13,4),(80,22,0,1,13,4),(80,26,0,1,13,4),(81,26,0,1,13,4),(82,26,0,1,13,4),(83,26,0,1,13,4),(96,26,0,1,13,4),(97,26,0,1,13,4),(98,21,0,1,13,4),(98,22,0,1,13,4),(98,26,0,1,13,4),(99,18,0,1,13,4),(101,14,0,1,13,4),(101,15,0,1,13,4),(101,16,0,1,13,4),(102,12,0,1,13,4),(102,13,0,1,13,4),(102,14,0,1,13,4),(102,15,0,1,13,4),(102,16,0,1,13,4),(102,17,0,1,13,4),(102,19,0,1,13,4),(102,36,0,1,13,4),(102,37,0,1,13,4),(102,38,0,1,13,4),(102,39,0,1,13,4),(102,40,0,1,13,4),(103,18,0,1,13,4),(104,18,0,1,13,4),(105,18,0,1,13,4),(106,18,0,1,13,4),(107,18,0,1,13,4),(134,23,0,1,13,4),(135,22,0,1,13,4),(137,4,0,1,13,4),(137,28,0,1,13,4),(137,31,0,1,13,4),(137,34,0,1,13,4),(137,35,0,1,13,4),(138,28,0,1,13,4),(138,30,0,1,13,4),(138,32,0,1,13,4),(138,33,0,1,13,4),(139,28,0,1,13,4),(139,30,0,1,13,4),(139,32,0,1,13,4),(139,33,0,1,13,4),(140,28,0,1,13,4),(140,30,0,1,13,4),(140,32,0,1,13,4),(140,33,0,1,13,4),(145,1,0,1,13,4),(145,2,0,1,13,4),(145,3,0,1,13,4),(145,4,0,1,13,4),(145,5,0,1,13,4),(145,6,0,1,13,4),(145,7,0,1,13,4),(145,8,0,1,13,4),(145,9,0,1,13,4),(145,10,0,1,13,4),(145,11,0,1,13,4),(145,12,0,1,13,4),(145,13,0,1,13,4),(145,14,0,1,13,4),(145,15,0,1,13,4),(145,16,0,1,13,4),(145,17,0,1,13,4),(145,18,0,1,13,4),(145,19,0,1,13,4),(145,20,0,1,13,4),(145,21,0,1,13,4),(145,22,0,1,13,4),(145,23,0,1,13,4),(145,24,0,1,13,4),(145,25,0,1,13,4),(145,26,0,1,13,4),(145,27,0,1,13,4),(145,28,0,1,13,4),(145,29,0,1,13,4),(145,30,0,1,13,4),(145,31,0,1,13,4),(145,32,0,1,13,4),(145,33,0,1,13,4),(145,34,0,1,13,4),(145,35,0,1,13,4),(145,36,0,1,13,4),(145,37,0,1,13,4),(145,38,0,1,13,4),(145,39,0,1,13,4),(145,40,0,1,13,4),(145,41,0,1,13,4),(145,42,0,1,13,4),(145,43,0,1,13,4),(149,41,0,1,13,4),(150,50,0,1,13,4),(150,57,0,1,13,4),(150,58,0,1,13,4),(150,59,0,1,13,4),(150,60,0,1,13,4),(151,61,0,1,13,4),(151,62,0,1,13,4),(151,63,0,1,13,4),(151,64,0,1,13,4),(151,65,0,1,13,4),(151,66,0,1,13,4),(152,61,0,1,13,4),(152,63,0,1,13,4),(153,61,0,1,13,4),(153,63,0,1,13,4),(153,64,0,1,13,4),(153,65,0,1,13,4),(153,66,0,1,13,4),(154,61,0,1,13,4),(154,62,0,1,13,4),(154,64,0,1,13,4),(154,66,0,1,13,4),(155,61,0,1,13,4),(155,62,0,1,13,4),(155,64,0,1,13,4),(155,65,0,1,13,4),(155,66,0,1,13,4),(156,61,0,1,13,4),(156,62,0,1,13,4),(156,63,0,1,13,4),(156,64,0,1,13,4),(156,65,0,1,13,4),(156,66,0,1,13,4),(157,61,0,1,13,4),(157,62,0,1,13,4),(157,64,0,1,13,4),(157,65,0,1,13,4),(157,66,0,1,13,4),(158,61,0,1,13,4),(158,63,0,1,13,4),(158,64,0,1,13,4),(158,65,0,1,13,4),(158,66,0,1,13,4),(159,61,0,1,13,4),(159,62,0,1,13,4),(159,63,0,1,13,4),(159,64,0,1,13,4),(159,65,0,1,13,4),(159,66,0,1,13,4),(160,41,0,1,13,4),(160,68,0,1,13,4),(160,69,0,1,13,4),(160,70,0,1,13,4),(160,72,0,1,13,4),(160,73,0,1,13,4),(161,68,0,1,13,4),(161,69,0,1,13,4),(161,70,0,1,13,4),(161,71,0,1,13,4),(161,72,0,1,13,4),(162,68,0,1,13,4),(162,69,0,1,13,4),(162,72,0,1,13,4),(164,41,0,1,13,4),(164,70,0,1,13,4),(164,73,0,1,13,4),(166,41,0,1,13,4),(166,70,0,1,13,4),(166,73,0,1,13,4),(167,68,0,1,13,4),(167,69,0,1,13,4),(167,72,0,1,13,4),(168,71,0,1,13,4),(169,70,0,1,13,4),(171,70,0,1,13,4),(172,1,10000,0,13,4),(172,2,10000,0,13,4),(172,3,10000,0,13,4),(172,4,10000,0,13,4),(172,5,10000,0,13,4),(172,6,10000,0,13,4),(172,7,10000,0,13,4),(172,8,10000,0,13,4),(172,9,10000,0,13,4),(172,10,10000,0,13,4),(172,11,10000,0,13,4),(172,12,10000,0,13,4),(172,13,10000,0,13,4),(172,14,10000,0,13,4),(172,15,10000,0,13,4),(172,16,10000,0,13,4),(172,17,10000,0,13,4),(172,18,10000,0,13,4),(172,19,10000,0,13,4),(172,20,10000,0,13,4),(172,21,10000,0,13,4),(172,22,10000,0,13,4),(172,23,10000,0,13,4),(172,24,10000,0,13,4),(172,25,10000,0,13,4),(172,26,10000,0,13,4),(172,27,10000,0,13,4),(172,28,10000,0,13,4),(172,29,10000,0,13,4),(172,30,10000,0,13,4),(173,1,0,1,13,4),(173,2,0,1,13,4),(173,3,0,1,13,4),(173,4,0,1,13,4),(173,5,0,1,13,4),(173,6,0,1,13,4),(173,7,0,1,13,4),(173,8,0,1,13,4),(173,9,0,1,13,4),(173,10,0,1,13,4),(173,11,0,1,13,4),(173,12,0,1,13,4),(173,13,0,1,13,4),(173,14,0,1,13,4),(173,15,0,1,13,4),(173,16,0,1,13,4),(173,17,0,1,13,4),(173,18,0,1,13,4),(173,19,0,1,13,4),(173,20,0,1,13,4),(173,21,0,1,13,4),(173,22,0,1,13,4),(173,23,0,1,13,4),(173,24,0,1,13,4),(173,25,0,1,13,4),(173,26,0,1,13,4),(173,27,0,1,13,4),(173,28,0,1,13,4),(173,29,0,1,13,4),(173,30,0,1,13,4),(174,1,0,1,13,4),(174,2,0,1,13,4),(174,3,0,1,13,4),(174,4,0,1,13,4),(174,5,0,1,13,4),(174,6,0,1,13,4),(174,7,0,1,13,4),(174,8,0,1,13,4),(174,9,0,1,13,4),(174,10,0,1,13,4),(174,11,0,1,13,4),(174,12,0,1,13,4),(174,13,0,1,13,4),(174,14,0,1,13,4),(174,15,0,1,13,4),(174,16,0,1,13,4),(174,17,0,1,13,4),(174,18,0,1,13,4),(174,19,0,1,13,4),(174,20,0,1,13,4),(174,21,0,1,13,4),(174,22,0,1,13,4),(174,23,0,1,13,4),(174,24,0,1,13,4),(174,25,0,1,13,4),(174,26,0,1,13,4),(174,27,0,1,13,4),(174,28,0,1,13,4),(174,29,0,1,13,4),(174,30,0,1,13,4),(175,1,0,1,13,4),(175,2,0,1,13,4),(175,3,0,1,13,4),(175,4,0,1,13,4),(175,5,0,1,13,4),(175,6,0,1,13,4),(175,7,0,1,13,4),(175,8,0,1,13,4),(175,9,0,1,13,4),(175,10,0,1,13,4),(175,11,0,1,13,4),(175,12,0,1,13,4),(175,13,0,1,13,4),(175,14,0,1,13,4),(175,15,0,1,13,4),(175,16,0,1,13,4),(175,17,0,1,13,4),(175,18,0,1,13,4),(175,19,0,1,13,4),(175,20,0,1,13,4),(175,21,0,1,13,4),(175,22,0,1,13,4),(175,23,0,1,13,4),(175,24,0,1,13,4),(175,25,0,1,13,4),(175,26,0,1,13,4),(175,27,0,1,13,4),(175,28,0,1,13,4),(175,29,0,1,13,4),(175,30,0,1,13,4),(176,1,0,1,13,4),(176,2,0,1,13,4),(176,3,0,1,13,4),(176,4,0,1,13,4),(176,5,0,1,13,4),(176,6,0,1,13,4),(176,7,0,1,13,4),(176,8,0,1,13,4),(176,9,0,1,13,4),(176,10,0,1,13,4),(176,11,0,1,13,4),(176,12,0,1,13,4),(176,13,0,1,13,4),(176,14,0,1,13,4),(176,15,0,1,13,4),(176,16,0,1,13,4),(176,17,0,1,13,4),(176,18,0,1,13,4),(176,19,0,1,13,4),(176,20,0,1,13,4),(176,21,0,1,13,4),(176,22,0,1,13,4),(176,23,0,1,13,4),(176,24,0,1,13,4),(176,25,0,1,13,4),(176,26,0,1,13,4),(176,27,0,1,13,4),(176,28,0,1,13,4),(176,29,0,1,13,4),(176,30,0,1,13,4),(177,74,0,1,13,4),(177,75,0,1,13,4),(177,76,0,1,13,4),(177,77,0,1,13,4),(177,78,0,1,13,4),(177,79,0,1,13,4),(177,80,0,1,13,4),(178,74,10000,0,13,4),(178,75,10000,0,13,4),(178,76,10000,0,13,4),(178,77,10000,0,13,4),(178,78,10000,0,13,4),(178,79,10000,0,13,4),(178,80,10000,0,13,4),(178,81,10000,0,13,4),(178,82,10000,0,13,4),(178,83,10000,0,13,4),(178,84,10000,0,13,4),(178,85,10000,0,13,4),(178,86,10000,0,13,4),(178,87,10000,0,13,4),(178,88,10000,0,13,4),(178,113,10000,0,13,4),(178,114,10000,0,13,4),(178,115,10000,0,13,4),(178,116,10000,0,13,4),(178,117,10000,0,13,4),(178,118,10000,0,13,4),(178,119,10000,0,13,4),(178,120,10000,0,13,4),(178,121,10000,0,13,4),(178,122,10000,0,13,4),(178,123,10000,0,13,4),(178,124,10000,0,13,4),(178,125,10000,0,13,4),(178,126,10000,0,13,4),(178,127,10000,0,13,4),(178,128,10000,0,13,4),(178,129,10000,0,13,4),(178,130,10000,0,13,4),(178,131,10000,0,13,4),(178,132,10000,0,13,4),(178,133,10000,0,13,4),(178,134,10000,0,13,4),(178,135,10000,0,13,4),(178,136,10000,0,13,4),(178,137,10000,0,13,4),(178,138,10000,0,13,4),(178,139,10000,0,13,4),(178,140,10000,0,13,4),(178,141,10000,0,13,4),(178,142,10000,0,13,4),(178,143,10000,0,13,4),(178,144,10000,0,13,4),(178,145,10000,0,13,4),(178,146,10000,0,13,4),(178,147,10000,0,13,4),(178,148,10000,0,13,4),(178,149,10000,0,13,4),(178,150,10000,0,13,4),(178,151,10000,0,13,4),(178,152,10000,0,13,4),(178,153,10000,0,13,4),(178,154,10000,0,13,4),(178,155,10000,0,13,4),(178,156,10000,0,13,4),(178,157,10000,0,13,4),(178,158,10000,0,13,4),(178,159,10000,0,13,4),(178,160,10000,0,13,4),(178,161,10000,0,13,4),(178,162,10000,0,13,4),(178,163,10000,0,13,4),(178,164,10000,0,13,4),(178,165,10000,0,13,4),(178,166,10000,0,13,4),(178,167,10000,0,13,4),(178,168,10000,0,13,4),(178,169,10000,0,13,4),(178,170,10000,0,13,4),(178,171,10000,0,13,4),(178,172,10000,0,13,4),(178,173,10000,0,13,4),(178,174,10000,0,13,4),(178,175,10000,0,13,4),(178,176,10000,0,13,4),(178,177,10000,0,13,4),(178,178,10000,0,13,4),(178,179,10000,0,13,4),(178,180,10000,0,13,4),(178,181,10000,0,13,4),(178,182,10000,0,13,4),(178,183,10000,0,13,4),(178,184,10000,0,13,4),(178,185,10000,0,13,4),(178,186,10000,0,13,4),(178,187,10000,0,13,4),(178,188,10000,0,13,4),(178,189,10000,0,13,4),(178,190,10000,0,13,4),(178,191,10000,0,13,4),(178,192,10000,0,13,4),(178,193,10000,0,13,4),(178,194,10000,0,13,4),(178,195,10000,0,13,4),(178,196,10000,0,13,4),(178,197,10000,0,13,4),(178,198,10000,0,13,4),(178,199,10000,0,13,4),(178,200,10000,0,13,4),(178,201,10000,0,13,4),(178,202,10000,0,13,4),(178,203,10000,0,13,4),(178,204,10000,0,13,4),(178,205,10000,0,13,4),(178,206,10000,0,13,4),(178,207,10000,0,13,4),(178,208,10000,0,13,4),(178,209,10000,0,13,4),(178,210,10000,0,13,4),(178,211,10000,0,13,4),(178,212,10000,0,13,4),(178,213,10000,0,13,4),(178,214,10000,0,13,4),(178,215,10000,0,13,4),(178,216,10000,0,13,4),(178,217,10000,0,13,4),(178,218,10000,0,13,4),(178,219,10000,0,13,4),(178,220,10000,0,13,4),(178,221,10000,0,13,4),(178,222,10000,0,13,4),(178,223,10000,0,13,4),(178,224,10000,0,13,4),(178,225,10000,0,13,4),(178,226,10000,0,13,4),(178,227,10000,0,13,4),(178,228,10000,0,13,4),(178,229,10000,0,13,4),(178,230,10000,0,13,4),(178,231,10000,0,13,4),(178,232,10000,0,13,4),(178,233,10000,0,13,4),(178,234,10000,0,13,4),(178,235,10000,0,13,4),(178,236,10000,0,13,4),(178,237,10000,0,13,4),(178,238,10000,0,13,4),(178,239,10000,0,13,4),(178,240,10000,0,13,4),(178,241,10000,0,13,4),(178,244,10000,0,13,4),(178,246,10000,0,13,4),(178,251,10000,0,13,4),(178,255,10000,0,13,4),(178,258,10000,0,13,4),(178,259,10000,0,13,4),(178,260,10000,0,13,4),(178,261,10000,0,13,4),(178,262,10000,0,13,4),(178,263,10000,0,13,4),(179,81,0,1,13,4),(179,82,0,1,13,4),(179,83,0,1,13,4),(179,84,0,1,13,4),(179,85,0,1,13,4),(179,86,0,1,13,4),(179,87,0,1,13,4),(179,88,0,1,13,4),(180,81,0,1,13,4),(181,86,0,1,13,4),(182,82,0,1,13,4),(182,83,0,1,13,4),(182,84,0,1,13,4),(182,85,0,1,13,4),(182,87,0,1,13,4),(182,88,0,1,13,4),(183,82,0,1,13,4),(183,83,0,1,13,4),(183,84,0,1,13,4),(183,85,0,1,13,4),(183,86,0,1,13,4),(183,87,0,1,13,4),(183,88,0,1,13,4),(192,89,0,1,13,4),(192,90,0,1,13,4),(192,91,0,1,13,4),(192,92,0,1,13,4),(192,93,0,1,13,4),(192,94,0,1,13,4),(193,95,0,1,13,4),(193,96,0,1,13,4),(193,97,0,1,13,4),(193,98,0,1,13,4),(193,99,0,1,13,4),(193,100,0,1,13,4),(194,95,0,1,13,4),(194,96,0,1,13,4),(194,97,0,1,13,4),(194,98,0,1,13,4),(194,99,0,1,13,4),(194,100,0,1,13,4),(195,95,0,1,13,4),(195,96,0,1,13,4),(195,97,0,1,13,4),(195,98,0,1,13,4),(195,99,0,1,13,4),(195,100,0,1,13,4),(196,95,0,1,13,4),(196,96,0,1,13,4),(196,97,0,1,13,4),(196,98,0,1,13,4),(196,99,0,1,13,4),(196,100,0,1,13,4),(197,95,0,1,13,4),(197,96,0,1,13,4),(197,97,0,1,13,4),(197,98,0,1,13,4),(197,99,0,1,13,4),(197,100,0,1,13,4),(198,101,0,1,13,4),(198,109,0,1,13,4),(198,111,0,1,13,4),(198,112,0,1,13,4),(199,103,0,1,13,4),(199,110,0,1,13,4),(200,101,0,1,13,4),(200,102,0,1,13,4),(200,108,0,1,13,4),(201,104,0,1,13,4),(201,106,0,1,13,4),(202,101,0,1,13,4),(202,102,0,1,13,4),(202,103,0,1,13,4),(202,105,0,1,13,4),(202,107,0,1,13,4),(202,108,0,1,13,4),(202,110,0,1,13,4),(203,101,0,1,13,4),(203,102,0,1,13,4),(203,103,0,1,13,4),(203,104,0,1,13,4),(203,106,0,1,13,4),(203,108,0,1,13,4),(203,109,0,1,13,4),(204,101,0,1,13,4),(204,102,0,1,13,4),(204,103,0,1,13,4),(204,104,0,1,13,4),(204,105,0,1,13,4),(204,106,0,1,13,4),(204,107,0,1,13,4),(204,108,0,1,13,4),(205,101,0,1,13,4),(205,102,0,1,13,4),(205,103,0,1,13,4),(205,108,0,1,13,4),(205,109,0,1,13,4),(205,110,0,1,13,4),(205,111,0,1,13,4),(205,112,0,1,13,4),(206,113,10000,0,13,4),(206,114,10000,0,13,4),(206,115,10000,0,13,4),(206,116,10000,0,13,4),(206,117,10000,0,13,4),(206,118,10000,0,13,4),(206,119,10000,0,13,4),(207,114,0,1,13,4),(207,119,0,1,13,4),(209,114,0,1,13,4),(212,116,0,1,13,4),(212,118,0,1,13,4),(213,113,0,1,13,4),(218,117,0,1,13,4),(219,119,0,1,13,4),(220,119,0,1,13,4),(221,119,0,1,13,4),(222,114,0,1,13,4),(222,119,0,1,13,4),(223,114,0,1,13,4),(223,119,0,1,13,4),(229,113,0,1,13,4),(230,113,0,1,13,4),(231,113,0,1,13,4),(232,113,0,1,13,4),(233,113,0,1,13,4),(234,116,0,1,13,4),(234,118,0,1,13,4),(235,116,0,1,13,4),(235,118,0,1,13,4),(236,116,0,1,13,4),(236,118,0,1,13,4),(237,116,0,1,13,4),(237,118,0,1,13,4),(238,116,0,1,13,4),(238,118,0,1,13,4),(239,115,0,1,13,4),(241,115,0,1,13,4),(242,115,0,1,13,4),(243,115,0,1,13,4),(250,120,0,1,13,4),(250,121,0,1,13,4),(250,122,0,1,13,4),(250,123,0,1,13,4),(250,124,0,1,13,4),(250,125,0,1,13,4),(250,126,0,1,13,4),(250,127,0,1,13,4),(250,128,0,1,13,4),(250,129,0,1,13,4),(250,130,0,1,13,4),(250,131,0,1,13,4),(251,120,0,1,13,4),(251,121,0,1,13,4),(251,122,0,1,13,4),(251,123,0,1,13,4),(251,124,0,1,13,4),(251,125,0,1,13,4),(251,126,0,1,13,4),(251,127,0,1,13,4),(251,128,0,1,13,4),(251,129,0,1,13,4),(251,130,0,1,13,4),(251,131,0,1,13,4),(252,125,10000,0,13,4),(252,126,10000,0,13,4),(252,127,10000,0,13,4),(252,120,0,1,13,4),(252,121,0,1,13,4),(252,122,0,1,13,4),(252,123,0,1,13,4),(252,124,0,1,13,4),(252,128,0,1,13,4),(252,129,0,1,13,4),(252,131,0,1,13,4),(253,120,0,1,13,4),(253,121,0,1,13,4),(253,122,0,1,13,4),(253,123,0,1,13,4),(253,124,0,1,13,4),(253,125,0,1,13,4),(253,126,0,1,13,4),(253,127,0,1,13,4),(253,128,0,1,13,4),(253,129,0,1,13,4),(253,130,0,1,13,4),(253,131,0,1,13,4),(254,120,0,1,13,4),(254,121,0,1,13,4),(254,122,0,1,13,4),(254,123,0,1,13,4),(254,124,0,1,13,4),(254,125,0,1,13,4),(254,126,0,1,13,4),(254,127,0,1,13,4),(254,128,0,1,13,4),(254,129,0,1,13,4),(254,130,0,1,13,4),(254,131,0,1,13,4),(255,122,0,1,13,4),(255,123,0,1,13,4),(255,124,0,1,13,4),(255,125,0,1,13,4),(255,126,0,1,13,4),(255,129,0,1,13,4),(256,121,0,1,13,4),(256,122,0,1,13,4),(256,123,0,1,13,4),(256,125,0,1,13,4),(256,126,0,1,13,4),(256,127,0,1,13,4),(257,121,0,1,13,4),(257,122,0,1,13,4),(257,123,0,1,13,4),(257,125,0,1,13,4),(257,127,0,1,13,4),(257,129,0,1,13,4),(258,121,0,1,13,4),(258,122,0,1,13,4),(258,125,0,1,13,4),(258,126,0,1,13,4),(258,127,0,1,13,4),(258,129,0,1,13,4),(259,120,0,1,13,4),(259,121,0,1,13,4),(259,123,0,1,13,4),(259,128,0,1,13,4),(259,129,0,1,13,4),(260,120,0,1,13,4),(260,121,0,1,13,4),(260,122,0,1,13,4),(260,123,0,1,13,4),(260,125,0,1,13,4),(260,127,0,1,13,4),(260,128,0,1,13,4),(260,129,0,1,13,4),(261,121,0,1,13,4),(261,122,0,1,13,4),(261,125,0,1,13,4),(261,126,0,1,13,4),(261,127,0,1,13,4),(261,129,0,1,13,4),(262,125,0,1,13,4),(262,126,0,1,13,4),(263,120,0,1,13,4),(263,121,0,1,13,4),(263,122,0,1,13,4),(263,123,0,1,13,4),(263,124,0,1,13,4),(263,128,0,1,13,4),(263,129,0,1,13,4),(263,131,0,1,13,4),(264,120,0,1,13,4),(264,122,0,1,13,4),(264,123,0,1,13,4),(264,125,0,1,13,4),(264,126,0,1,13,4),(264,129,0,1,13,4),(265,121,0,1,13,4),(265,122,0,1,13,4),(265,123,0,1,13,4),(265,127,0,1,13,4),(266,123,0,1,13,4),(266,125,0,1,13,4),(266,126,0,1,13,4),(266,127,0,1,13,4),(266,129,0,1,13,4),(267,121,0,1,13,4),(267,125,0,1,13,4),(267,126,0,1,13,4),(267,127,0,1,13,4),(268,120,0,1,13,4),(268,121,0,1,13,4),(268,122,0,1,13,4),(268,123,0,1,13,4),(268,124,0,1,13,4),(268,127,0,1,13,4),(268,129,0,1,13,4),(269,122,0,1,13,4),(269,125,0,1,13,4),(269,126,0,1,13,4),(269,127,0,1,13,4),(269,129,0,1,13,4),(270,121,0,1,13,4),(270,123,0,1,13,4),(270,125,0,1,13,4),(270,126,0,1,13,4),(270,129,0,1,13,4),(271,120,0,1,13,4),(271,121,0,1,13,4),(271,122,0,1,13,4),(271,125,0,1,13,4),(271,126,0,1,13,4),(271,127,0,1,13,4),(271,129,0,1,13,4),(272,122,0,1,13,4),(272,123,0,1,13,4),(272,124,0,1,13,4),(272,125,0,1,13,4),(272,126,0,1,13,4),(272,127,0,1,13,4),(272,128,0,1,13,4),(272,129,0,1,13,4),(273,120,0,1,13,4),(273,121,0,1,13,4),(273,123,0,1,13,4),(273,126,0,1,13,4),(273,127,0,1,13,4),(274,122,0,1,13,4),(274,123,0,1,13,4),(274,125,0,1,13,4),(274,126,0,1,13,4),(274,129,0,1,13,4),(275,120,0,1,13,4),(275,121,0,1,13,4),(275,122,0,1,13,4),(275,123,0,1,13,4),(275,124,0,1,13,4),(275,125,0,1,13,4),(275,126,0,1,13,4),(275,127,0,1,13,4),(275,128,0,1,13,4),(275,129,0,1,13,4),(275,130,0,1,13,4),(275,131,0,1,13,4),(276,122,0,1,13,4),(276,123,0,1,13,4),(276,127,0,1,13,4),(276,129,0,1,13,4),(277,120,0,1,13,4),(277,121,0,1,13,4),(277,123,0,1,13,4),(277,124,0,1,13,4),(277,125,0,1,13,4),(277,126,0,1,13,4),(277,127,0,1,13,4),(278,120,0,1,13,4),(278,121,0,1,13,4),(278,122,0,1,13,4),(278,123,0,1,13,4),(278,124,0,1,13,4),(278,125,0,1,13,4),(278,127,0,1,13,4),(278,128,0,1,13,4),(278,129,0,1,13,4),(279,120,0,1,13,4),(279,122,0,1,13,4),(279,126,0,1,13,4),(279,127,0,1,13,4),(279,129,0,1,13,4),(280,132,0,1,13,4),(280,133,0,1,13,4),(280,134,0,1,13,4),(280,135,0,1,13,4),(280,136,0,1,13,4),(280,137,0,1,13,4),(280,138,0,1,13,4),(280,139,0,1,13,4),(282,132,0,1,13,4),(282,133,0,1,13,4),(282,134,0,1,13,4),(282,137,0,1,13,4),(282,138,0,1,13,4),(283,135,0,1,13,4),(283,136,0,1,13,4),(283,139,0,1,13,4),(286,140,0,1,13,4),(286,141,0,1,13,4),(286,142,0,1,13,4),(286,143,0,1,13,4),(286,144,0,1,13,4),(286,145,0,1,13,4),(286,146,0,1,13,4),(286,147,0,1,13,4),(286,148,0,1,13,4),(286,149,0,1,13,4),(286,150,0,1,13,4),(286,151,0,1,13,4),(286,152,0,1,13,4),(286,153,0,1,13,4),(286,154,0,1,13,4),(286,155,0,1,13,4),(286,156,0,1,13,4),(286,157,0,1,13,4),(286,158,0,1,13,4),(286,159,0,1,13,4),(286,160,0,1,13,4),(286,161,0,1,13,4),(286,162,0,1,13,4),(286,163,0,1,13,4),(286,164,0,1,13,4),(286,165,0,1,13,4),(286,166,0,1,13,4),(286,167,0,1,13,4),(286,168,0,1,13,4),(286,169,0,1,13,4),(286,170,0,1,13,4),(286,171,0,1,13,4),(286,172,0,1,13,4),(286,173,0,1,13,4),(286,174,0,1,13,4),(286,175,0,1,13,4),(286,176,0,1,13,4),(286,177,0,1,13,4),(286,178,0,1,13,4),(286,179,0,1,13,4),(286,180,0,1,13,4),(286,181,0,1,13,4),(286,182,0,1,13,4),(286,183,0,1,13,4),(286,184,0,1,13,4),(286,185,0,1,13,4),(286,186,0,1,13,4),(286,187,0,1,13,4),(287,188,0,1,13,4),(288,189,0,1,13,4),(288,190,0,1,13,4),(288,191,0,1,13,4),(288,192,0,1,13,4),(288,193,0,1,13,4),(288,194,0,1,13,4),(288,195,0,1,13,4),(288,196,0,1,13,4),(288,197,0,1,13,4),(288,198,0,1,13,4),(288,199,0,1,13,4),(288,200,0,1,13,4),(289,201,10000,0,13,4),(289,202,10000,0,13,4),(289,203,10000,0,13,4),(289,204,10000,0,13,4),(289,205,10000,0,13,4),(289,206,10000,0,13,4),(289,207,10000,0,13,4),(289,208,10000,0,13,4),(289,209,10000,0,13,4),(289,210,10000,0,13,4),(289,211,10000,0,13,4),(289,212,10000,0,13,4),(289,213,10000,0,13,4),(289,214,10000,0,13,4),(289,215,10000,0,13,4),(289,216,10000,0,13,4),(289,217,10000,0,13,4),(289,218,10000,0,13,4),(289,219,10000,0,13,4),(289,220,10000,0,13,4),(289,221,10000,0,13,4),(289,222,10000,0,13,4),(289,223,10000,0,13,4),(289,224,10000,0,13,4),(289,225,10000,0,13,4),(289,226,10000,0,13,4),(289,227,10000,0,13,4),(289,228,10000,0,13,4),(289,229,10000,0,13,4),(289,230,10000,0,13,4),(289,231,10000,0,13,4),(289,232,10000,0,13,4),(289,244,10000,0,13,4),(289,246,10000,0,13,4),(289,251,10000,0,13,4),(289,255,10000,0,13,4),(289,258,10000,0,13,4),(289,259,10000,0,13,4),(289,260,10000,0,13,4),(289,261,10000,0,13,4),(289,262,10000,0,13,4),(289,263,10000,0,13,4),(290,209,0,1,13,4),(290,210,0,1,13,4),(290,211,0,1,13,4),(290,212,0,1,13,4),(290,213,0,1,13,4),(290,214,0,1,13,4),(290,215,0,1,13,4),(290,216,0,1,13,4),(291,201,0,1,13,4),(291,202,0,1,13,4),(291,203,0,1,13,4),(291,204,0,1,13,4),(291,205,0,1,13,4),(291,206,0,1,13,4),(291,207,0,1,13,4),(291,208,0,1,13,4),(292,217,0,1,13,4),(292,218,0,1,13,4),(292,219,0,1,13,4),(292,220,0,1,13,4),(292,221,0,1,13,4),(292,222,0,1,13,4),(292,223,0,1,13,4),(292,224,0,1,13,4),(293,225,0,1,13,4),(293,226,0,1,13,4),(293,227,0,1,13,4),(293,228,0,1,13,4),(293,229,0,1,13,4),(293,230,0,1,13,4),(293,231,0,1,13,4),(293,232,0,1,13,4),(293,255,0,1,13,4),(293,259,0,1,13,4),(293,260,0,1,13,4),(293,261,0,1,13,4),(293,262,0,1,13,4),(293,263,0,1,13,4),(294,233,0,1,13,4),(294,234,0,1,13,4),(294,235,0,1,13,4),(294,236,0,1,13,4),(294,237,0,1,13,4),(294,238,0,1,13,4),(294,239,0,1,13,4),(294,240,0,1,13,4),(294,241,0,1,13,4),(295,244,0,1,13,4),(295,246,0,1,13,4),(295,251,0,1,13,4),(295,255,0,1,13,4),(295,258,0,1,13,4),(296,251,0,1,13,4),(296,255,0,1,13,4),(296,258,0,1,13,4),(297,246,0,1,13,4),(297,255,0,1,13,4),(297,258,0,1,13,4),(298,255,0,1,13,4),(298,258,0,1,13,4),(299,251,0,1,13,4),(299,258,0,1,13,4);
/*!40000 ALTER TABLE `catalog_category_product_index_store13_replica` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index_store14`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store14`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store14` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `IDX_9B9988D49BCDD4DDA85639A10275AF55` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_4397C9A49019C8638DCA278481D2BA08` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Product Index Store14';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index_store14`
--

LOCK TABLES `catalog_category_product_index_store14` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index_store14` DISABLE KEYS */;
INSERT INTO `catalog_category_product_index_store14` VALUES (2,1,0,1,14,4),(2,2,0,1,14,4),(2,3,0,1,14,4),(2,4,0,1,14,4),(2,5,0,1,14,4),(2,6,0,1,14,4),(2,7,0,1,14,4),(2,8,0,1,14,4),(2,9,0,1,14,4),(2,10,0,1,14,4),(2,11,0,1,14,4),(2,12,0,1,14,4),(2,13,0,1,14,4),(2,14,0,1,14,4),(2,15,0,1,14,4),(2,16,0,1,14,4),(2,17,0,1,14,4),(2,18,0,1,14,4),(2,19,0,1,14,4),(2,20,0,1,14,4),(2,21,0,1,14,4),(2,22,0,1,14,4),(2,23,0,1,14,4),(2,24,0,1,14,4),(2,25,0,1,14,4),(2,26,0,1,14,4),(2,27,0,1,14,4),(2,28,0,1,14,4),(2,29,0,1,14,4),(2,30,0,1,14,4),(2,31,0,1,14,4),(2,32,0,1,14,4),(2,33,0,1,14,4),(2,34,0,1,14,4),(2,35,0,1,14,4),(2,36,0,1,14,4),(2,37,0,1,14,4),(2,38,0,1,14,4),(2,39,0,1,14,4),(2,40,0,1,14,4),(2,41,0,1,14,4),(2,42,0,1,14,4),(2,43,0,1,14,4),(2,44,0,1,14,4),(2,45,0,1,14,4),(2,46,0,1,14,4),(2,47,0,1,14,4),(2,48,0,1,14,4),(2,49,0,1,14,4),(2,50,0,1,14,4),(2,57,0,1,14,4),(2,58,0,1,14,4),(2,59,0,1,14,4),(2,60,0,1,14,4),(2,61,0,1,14,4),(2,62,0,1,14,4),(2,63,0,1,14,4),(2,64,0,1,14,4),(2,65,0,1,14,4),(2,66,0,1,14,4),(2,68,0,1,14,4),(2,69,0,1,14,4),(2,70,0,1,14,4),(2,71,0,1,14,4),(2,72,0,1,14,4),(2,73,0,1,14,4),(2,74,0,1,14,4),(2,75,0,1,14,4),(2,76,0,1,14,4),(2,77,0,1,14,4),(2,78,0,1,14,4),(2,79,0,1,14,4),(2,80,0,1,14,4),(2,81,0,1,14,4),(2,82,0,1,14,4),(2,83,0,1,14,4),(2,84,0,1,14,4),(2,85,0,1,14,4),(2,86,0,1,14,4),(2,87,0,1,14,4),(2,88,0,1,14,4),(2,89,0,1,14,4),(2,90,0,1,14,4),(2,91,0,1,14,4),(2,92,0,1,14,4),(2,93,0,1,14,4),(2,94,0,1,14,4),(2,95,0,1,14,4),(2,96,0,1,14,4),(2,97,0,1,14,4),(2,98,0,1,14,4),(2,99,0,1,14,4),(2,100,0,1,14,4),(2,101,0,1,14,4),(2,102,0,1,14,4),(2,103,0,1,14,4),(2,104,0,1,14,4),(2,105,0,1,14,4),(2,106,0,1,14,4),(2,107,0,1,14,4),(2,108,0,1,14,4),(2,109,0,1,14,4),(2,110,0,1,14,4),(2,111,0,1,14,4),(2,112,0,1,14,4),(2,113,0,1,14,4),(2,114,0,1,14,4),(2,115,0,1,14,4),(2,116,0,1,14,4),(2,117,0,1,14,4),(2,118,0,1,14,4),(2,119,0,1,14,4),(2,120,0,1,14,4),(2,121,0,1,14,4),(2,122,0,1,14,4),(2,123,0,1,14,4),(2,124,0,1,14,4),(2,125,0,1,14,4),(2,126,0,1,14,4),(2,127,0,1,14,4),(2,128,0,1,14,4),(2,129,0,1,14,4),(2,130,0,1,14,4),(2,131,0,1,14,4),(2,132,0,1,14,4),(2,133,0,1,14,4),(2,134,0,1,14,4),(2,135,0,1,14,4),(2,136,0,1,14,4),(2,137,0,1,14,4),(2,138,0,1,14,4),(2,139,0,1,14,4),(2,140,0,1,14,4),(2,141,0,1,14,4),(2,142,0,1,14,4),(2,143,0,1,14,4),(2,144,0,1,14,4),(2,145,0,1,14,4),(2,146,0,1,14,4),(2,147,0,1,14,4),(2,148,0,1,14,4),(2,149,0,1,14,4),(2,150,0,1,14,4),(2,151,0,1,14,4),(2,152,0,1,14,4),(2,153,0,1,14,4),(2,154,0,1,14,4),(2,155,0,1,14,4),(2,156,0,1,14,4),(2,157,0,1,14,4),(2,158,0,1,14,4),(2,159,0,1,14,4),(2,160,0,1,14,4),(2,161,0,1,14,4),(2,162,0,1,14,4),(2,163,0,1,14,4),(2,164,0,1,14,4),(2,165,0,1,14,4),(2,166,0,1,14,4),(2,167,0,1,14,4),(2,168,0,1,14,4),(2,169,0,1,14,4),(2,170,0,1,14,4),(2,171,0,1,14,4),(2,172,0,1,14,4),(2,173,0,1,14,4),(2,174,0,1,14,4),(2,175,0,1,14,4),(2,176,0,1,14,4),(2,177,0,1,14,4),(2,178,0,1,14,4),(2,179,0,1,14,4),(2,180,0,1,14,4),(2,181,0,1,14,4),(2,182,0,1,14,4),(2,183,0,1,14,4),(2,184,0,1,14,4),(2,185,0,1,14,4),(2,186,0,1,14,4),(2,187,0,1,14,4),(2,188,0,1,14,4),(2,189,0,1,14,4),(2,190,0,1,14,4),(2,191,0,1,14,4),(2,192,0,1,14,4),(2,193,0,1,14,4),(2,194,0,1,14,4),(2,195,0,1,14,4),(2,196,0,1,14,4),(2,197,0,1,14,4),(2,198,0,1,14,4),(2,199,0,1,14,4),(2,200,0,1,14,4),(2,201,0,1,14,4),(2,202,0,1,14,4),(2,203,0,1,14,4),(2,204,0,1,14,4),(2,205,0,1,14,4),(2,206,0,1,14,4),(2,207,0,1,14,4),(2,208,0,1,14,4),(2,209,0,1,14,4),(2,210,0,1,14,4),(2,211,0,1,14,4),(2,212,0,1,14,4),(2,213,0,1,14,4),(2,214,0,1,14,4),(2,215,0,1,14,4),(2,216,0,1,14,4),(2,217,0,1,14,4),(2,218,0,1,14,4),(2,219,0,1,14,4),(2,220,0,1,14,4),(2,221,0,1,14,4),(2,222,0,1,14,4),(2,223,0,1,14,4),(2,224,0,1,14,4),(2,225,0,1,14,4),(2,226,0,1,14,4),(2,227,0,1,14,4),(2,228,0,1,14,4),(2,229,0,1,14,4),(2,230,0,1,14,4),(2,231,0,1,14,4),(2,232,0,1,14,4),(2,233,0,1,14,4),(2,234,0,1,14,4),(2,235,0,1,14,4),(2,236,0,1,14,4),(2,237,0,1,14,4),(2,238,0,1,14,4),(2,239,0,1,14,4),(2,240,0,1,14,4),(2,241,0,1,14,4),(2,244,0,1,14,4),(2,246,0,1,14,4),(2,251,0,1,14,4),(2,255,0,1,14,4),(2,258,0,1,14,4),(2,259,0,1,14,4),(2,260,0,1,14,4),(2,261,0,1,14,4),(2,262,0,1,14,4),(2,263,0,1,14,4),(3,1,0,1,14,4),(3,2,0,1,14,4),(3,3,0,1,14,4),(3,4,0,1,14,4),(3,5,0,1,14,4),(3,6,0,1,14,4),(3,7,0,1,14,4),(3,8,0,1,14,4),(3,10,0,1,14,4),(3,11,0,1,14,4),(4,12,0,1,14,4),(4,13,0,1,14,4),(4,14,0,1,14,4),(4,15,0,1,14,4),(4,16,0,1,14,4),(4,17,0,1,14,4),(4,18,0,1,14,4),(4,19,0,1,14,4),(4,36,0,1,14,4),(4,37,0,1,14,4),(4,38,0,1,14,4),(4,39,0,1,14,4),(4,40,0,1,14,4),(5,95,10000,0,14,4),(5,96,10000,0,14,4),(5,97,10000,0,14,4),(5,98,10000,0,14,4),(5,99,10000,0,14,4),(5,100,10000,0,14,4),(7,101,10000,0,14,4),(7,102,10000,0,14,4),(7,103,10000,0,14,4),(7,104,10000,0,14,4),(7,105,10000,0,14,4),(7,106,10000,0,14,4),(7,107,10000,0,14,4),(7,108,10000,0,14,4),(7,109,10000,0,14,4),(7,110,10000,0,14,4),(7,111,10000,0,14,4),(7,112,10000,0,14,4),(7,21,0,1,14,4),(7,22,0,1,14,4),(7,26,0,1,14,4),(8,61,0,1,14,4),(8,62,0,1,14,4),(8,63,0,1,14,4),(8,64,0,1,14,4),(8,65,0,1,14,4),(8,66,0,1,14,4),(11,4,10000,0,14,4),(11,89,10000,0,14,4),(11,90,10000,0,14,4),(11,91,10000,0,14,4),(11,92,10000,0,14,4),(11,93,10000,0,14,4),(11,94,10000,0,14,4),(11,28,0,1,14,4),(11,29,0,1,14,4),(11,30,0,1,14,4),(11,31,0,1,14,4),(11,32,0,1,14,4),(11,33,0,1,14,4),(11,34,0,1,14,4),(11,35,0,1,14,4),(13,21,0,1,14,4),(13,24,0,1,14,4),(13,25,0,1,14,4),(13,26,0,1,14,4),(13,27,0,1,14,4),(13,41,0,1,14,4),(13,42,0,1,14,4),(13,43,0,1,14,4),(13,44,0,1,14,4),(13,45,0,1,14,4),(13,46,0,1,14,4),(13,47,0,1,14,4),(13,48,0,1,14,4),(13,49,0,1,14,4),(15,22,10000,0,14,4),(15,23,10000,0,14,4),(16,20,0,1,14,4),(16,21,0,1,14,4),(16,22,0,1,14,4),(16,23,0,1,14,4),(16,24,0,1,14,4),(16,25,0,1,14,4),(16,26,0,1,14,4),(16,27,0,1,14,4),(16,41,0,1,14,4),(16,68,0,1,14,4),(16,69,0,1,14,4),(16,70,0,1,14,4),(16,71,0,1,14,4),(16,72,0,1,14,4),(16,73,0,1,14,4),(19,6,0,1,14,4),(19,7,0,1,14,4),(19,8,0,1,14,4),(19,10,0,1,14,4),(19,11,0,1,14,4),(27,11,0,1,14,4),(29,6,0,1,14,4),(29,8,0,1,14,4),(29,10,0,1,14,4),(30,6,0,1,14,4),(30,10,0,1,14,4),(33,7,0,1,14,4),(33,8,0,1,14,4),(33,10,0,1,14,4),(33,11,0,1,14,4),(42,7,0,1,14,4),(42,8,0,1,14,4),(42,11,0,1,14,4),(78,21,0,1,14,4),(78,26,0,1,14,4),(80,21,0,1,14,4),(80,22,0,1,14,4),(80,26,0,1,14,4),(81,26,0,1,14,4),(82,26,0,1,14,4),(83,26,0,1,14,4),(96,26,0,1,14,4),(97,26,0,1,14,4),(98,21,0,1,14,4),(98,22,0,1,14,4),(98,26,0,1,14,4),(99,18,0,1,14,4),(101,14,0,1,14,4),(101,15,0,1,14,4),(101,16,0,1,14,4),(102,12,0,1,14,4),(102,13,0,1,14,4),(102,14,0,1,14,4),(102,15,0,1,14,4),(102,16,0,1,14,4),(102,17,0,1,14,4),(102,19,0,1,14,4),(102,36,0,1,14,4),(102,37,0,1,14,4),(102,38,0,1,14,4),(102,39,0,1,14,4),(102,40,0,1,14,4),(103,18,0,1,14,4),(104,18,0,1,14,4),(105,18,0,1,14,4),(106,18,0,1,14,4),(107,18,0,1,14,4),(134,23,0,1,14,4),(135,22,0,1,14,4),(137,4,0,1,14,4),(137,28,0,1,14,4),(137,31,0,1,14,4),(137,34,0,1,14,4),(137,35,0,1,14,4),(138,28,0,1,14,4),(138,30,0,1,14,4),(138,32,0,1,14,4),(138,33,0,1,14,4),(139,28,0,1,14,4),(139,30,0,1,14,4),(139,32,0,1,14,4),(139,33,0,1,14,4),(140,28,0,1,14,4),(140,30,0,1,14,4),(140,32,0,1,14,4),(140,33,0,1,14,4),(145,1,0,1,14,4),(145,2,0,1,14,4),(145,3,0,1,14,4),(145,4,0,1,14,4),(145,5,0,1,14,4),(145,6,0,1,14,4),(145,7,0,1,14,4),(145,8,0,1,14,4),(145,9,0,1,14,4),(145,10,0,1,14,4),(145,11,0,1,14,4),(145,12,0,1,14,4),(145,13,0,1,14,4),(145,14,0,1,14,4),(145,15,0,1,14,4),(145,16,0,1,14,4),(145,17,0,1,14,4),(145,18,0,1,14,4),(145,19,0,1,14,4),(145,20,0,1,14,4),(145,21,0,1,14,4),(145,22,0,1,14,4),(145,23,0,1,14,4),(145,24,0,1,14,4),(145,25,0,1,14,4),(145,26,0,1,14,4),(145,27,0,1,14,4),(145,28,0,1,14,4),(145,29,0,1,14,4),(145,30,0,1,14,4),(145,31,0,1,14,4),(145,32,0,1,14,4),(145,33,0,1,14,4),(145,34,0,1,14,4),(145,35,0,1,14,4),(145,36,0,1,14,4),(145,37,0,1,14,4),(145,38,0,1,14,4),(145,39,0,1,14,4),(145,40,0,1,14,4),(145,41,0,1,14,4),(145,42,0,1,14,4),(145,43,0,1,14,4),(149,41,0,1,14,4),(150,50,0,1,14,4),(150,57,0,1,14,4),(150,58,0,1,14,4),(150,59,0,1,14,4),(150,60,0,1,14,4),(151,61,0,1,14,4),(151,62,0,1,14,4),(151,63,0,1,14,4),(151,64,0,1,14,4),(151,65,0,1,14,4),(151,66,0,1,14,4),(152,61,0,1,14,4),(152,63,0,1,14,4),(153,61,0,1,14,4),(153,63,0,1,14,4),(153,64,0,1,14,4),(153,65,0,1,14,4),(153,66,0,1,14,4),(154,61,0,1,14,4),(154,62,0,1,14,4),(154,64,0,1,14,4),(154,66,0,1,14,4),(155,61,0,1,14,4),(155,62,0,1,14,4),(155,64,0,1,14,4),(155,65,0,1,14,4),(155,66,0,1,14,4),(156,61,0,1,14,4),(156,62,0,1,14,4),(156,63,0,1,14,4),(156,64,0,1,14,4),(156,65,0,1,14,4),(156,66,0,1,14,4),(157,61,0,1,14,4),(157,62,0,1,14,4),(157,64,0,1,14,4),(157,65,0,1,14,4),(157,66,0,1,14,4),(158,61,0,1,14,4),(158,63,0,1,14,4),(158,64,0,1,14,4),(158,65,0,1,14,4),(158,66,0,1,14,4),(159,61,0,1,14,4),(159,62,0,1,14,4),(159,63,0,1,14,4),(159,64,0,1,14,4),(159,65,0,1,14,4),(159,66,0,1,14,4),(160,41,0,1,14,4),(160,68,0,1,14,4),(160,69,0,1,14,4),(160,70,0,1,14,4),(160,72,0,1,14,4),(160,73,0,1,14,4),(161,68,0,1,14,4),(161,69,0,1,14,4),(161,70,0,1,14,4),(161,71,0,1,14,4),(161,72,0,1,14,4),(162,68,0,1,14,4),(162,69,0,1,14,4),(162,72,0,1,14,4),(164,41,0,1,14,4),(164,70,0,1,14,4),(164,73,0,1,14,4),(166,41,0,1,14,4),(166,70,0,1,14,4),(166,73,0,1,14,4),(167,68,0,1,14,4),(167,69,0,1,14,4),(167,72,0,1,14,4),(168,71,0,1,14,4),(169,70,0,1,14,4),(171,70,0,1,14,4),(172,1,10000,0,14,4),(172,2,10000,0,14,4),(172,3,10000,0,14,4),(172,4,10000,0,14,4),(172,5,10000,0,14,4),(172,6,10000,0,14,4),(172,7,10000,0,14,4),(172,8,10000,0,14,4),(172,9,10000,0,14,4),(172,10,10000,0,14,4),(172,11,10000,0,14,4),(172,12,10000,0,14,4),(172,13,10000,0,14,4),(172,14,10000,0,14,4),(172,15,10000,0,14,4),(172,16,10000,0,14,4),(172,17,10000,0,14,4),(172,18,10000,0,14,4),(172,19,10000,0,14,4),(172,20,10000,0,14,4),(172,21,10000,0,14,4),(172,22,10000,0,14,4),(172,23,10000,0,14,4),(172,24,10000,0,14,4),(172,25,10000,0,14,4),(172,26,10000,0,14,4),(172,27,10000,0,14,4),(172,28,10000,0,14,4),(172,29,10000,0,14,4),(172,30,10000,0,14,4),(173,1,0,1,14,4),(173,2,0,1,14,4),(173,3,0,1,14,4),(173,4,0,1,14,4),(173,5,0,1,14,4),(173,6,0,1,14,4),(173,7,0,1,14,4),(173,8,0,1,14,4),(173,9,0,1,14,4),(173,10,0,1,14,4),(173,11,0,1,14,4),(173,12,0,1,14,4),(173,13,0,1,14,4),(173,14,0,1,14,4),(173,15,0,1,14,4),(173,16,0,1,14,4),(173,17,0,1,14,4),(173,18,0,1,14,4),(173,19,0,1,14,4),(173,20,0,1,14,4),(173,21,0,1,14,4),(173,22,0,1,14,4),(173,23,0,1,14,4),(173,24,0,1,14,4),(173,25,0,1,14,4),(173,26,0,1,14,4),(173,27,0,1,14,4),(173,28,0,1,14,4),(173,29,0,1,14,4),(173,30,0,1,14,4),(174,1,0,1,14,4),(174,2,0,1,14,4),(174,3,0,1,14,4),(174,4,0,1,14,4),(174,5,0,1,14,4),(174,6,0,1,14,4),(174,7,0,1,14,4),(174,8,0,1,14,4),(174,9,0,1,14,4),(174,10,0,1,14,4),(174,11,0,1,14,4),(174,12,0,1,14,4),(174,13,0,1,14,4),(174,14,0,1,14,4),(174,15,0,1,14,4),(174,16,0,1,14,4),(174,17,0,1,14,4),(174,18,0,1,14,4),(174,19,0,1,14,4),(174,20,0,1,14,4),(174,21,0,1,14,4),(174,22,0,1,14,4),(174,23,0,1,14,4),(174,24,0,1,14,4),(174,25,0,1,14,4),(174,26,0,1,14,4),(174,27,0,1,14,4),(174,28,0,1,14,4),(174,29,0,1,14,4),(174,30,0,1,14,4),(175,1,0,1,14,4),(175,2,0,1,14,4),(175,3,0,1,14,4),(175,4,0,1,14,4),(175,5,0,1,14,4),(175,6,0,1,14,4),(175,7,0,1,14,4),(175,8,0,1,14,4),(175,9,0,1,14,4),(175,10,0,1,14,4),(175,11,0,1,14,4),(175,12,0,1,14,4),(175,13,0,1,14,4),(175,14,0,1,14,4),(175,15,0,1,14,4),(175,16,0,1,14,4),(175,17,0,1,14,4),(175,18,0,1,14,4),(175,19,0,1,14,4),(175,20,0,1,14,4),(175,21,0,1,14,4),(175,22,0,1,14,4),(175,23,0,1,14,4),(175,24,0,1,14,4),(175,25,0,1,14,4),(175,26,0,1,14,4),(175,27,0,1,14,4),(175,28,0,1,14,4),(175,29,0,1,14,4),(175,30,0,1,14,4),(176,1,0,1,14,4),(176,2,0,1,14,4),(176,3,0,1,14,4),(176,4,0,1,14,4),(176,5,0,1,14,4),(176,6,0,1,14,4),(176,7,0,1,14,4),(176,8,0,1,14,4),(176,9,0,1,14,4),(176,10,0,1,14,4),(176,11,0,1,14,4),(176,12,0,1,14,4),(176,13,0,1,14,4),(176,14,0,1,14,4),(176,15,0,1,14,4),(176,16,0,1,14,4),(176,17,0,1,14,4),(176,18,0,1,14,4),(176,19,0,1,14,4),(176,20,0,1,14,4),(176,21,0,1,14,4),(176,22,0,1,14,4),(176,23,0,1,14,4),(176,24,0,1,14,4),(176,25,0,1,14,4),(176,26,0,1,14,4),(176,27,0,1,14,4),(176,28,0,1,14,4),(176,29,0,1,14,4),(176,30,0,1,14,4),(177,74,0,1,14,4),(177,75,0,1,14,4),(177,76,0,1,14,4),(177,77,0,1,14,4),(177,78,0,1,14,4),(177,79,0,1,14,4),(177,80,0,1,14,4),(178,74,10000,0,14,4),(178,75,10000,0,14,4),(178,76,10000,0,14,4),(178,77,10000,0,14,4),(178,78,10000,0,14,4),(178,79,10000,0,14,4),(178,80,10000,0,14,4),(178,81,10000,0,14,4),(178,82,10000,0,14,4),(178,83,10000,0,14,4),(178,84,10000,0,14,4),(178,85,10000,0,14,4),(178,86,10000,0,14,4),(178,87,10000,0,14,4),(178,88,10000,0,14,4),(178,113,10000,0,14,4),(178,114,10000,0,14,4),(178,115,10000,0,14,4),(178,116,10000,0,14,4),(178,117,10000,0,14,4),(178,118,10000,0,14,4),(178,119,10000,0,14,4),(178,120,10000,0,14,4),(178,121,10000,0,14,4),(178,122,10000,0,14,4),(178,123,10000,0,14,4),(178,124,10000,0,14,4),(178,125,10000,0,14,4),(178,126,10000,0,14,4),(178,127,10000,0,14,4),(178,128,10000,0,14,4),(178,129,10000,0,14,4),(178,130,10000,0,14,4),(178,131,10000,0,14,4),(178,132,10000,0,14,4),(178,133,10000,0,14,4),(178,134,10000,0,14,4),(178,135,10000,0,14,4),(178,136,10000,0,14,4),(178,137,10000,0,14,4),(178,138,10000,0,14,4),(178,139,10000,0,14,4),(178,140,10000,0,14,4),(178,141,10000,0,14,4),(178,142,10000,0,14,4),(178,143,10000,0,14,4),(178,144,10000,0,14,4),(178,145,10000,0,14,4),(178,146,10000,0,14,4),(178,147,10000,0,14,4),(178,148,10000,0,14,4),(178,149,10000,0,14,4),(178,150,10000,0,14,4),(178,151,10000,0,14,4),(178,152,10000,0,14,4),(178,153,10000,0,14,4),(178,154,10000,0,14,4),(178,155,10000,0,14,4),(178,156,10000,0,14,4),(178,157,10000,0,14,4),(178,158,10000,0,14,4),(178,159,10000,0,14,4),(178,160,10000,0,14,4),(178,161,10000,0,14,4),(178,162,10000,0,14,4),(178,163,10000,0,14,4),(178,164,10000,0,14,4),(178,165,10000,0,14,4),(178,166,10000,0,14,4),(178,167,10000,0,14,4),(178,168,10000,0,14,4),(178,169,10000,0,14,4),(178,170,10000,0,14,4),(178,171,10000,0,14,4),(178,172,10000,0,14,4),(178,173,10000,0,14,4),(178,174,10000,0,14,4),(178,175,10000,0,14,4),(178,176,10000,0,14,4),(178,177,10000,0,14,4),(178,178,10000,0,14,4),(178,179,10000,0,14,4),(178,180,10000,0,14,4),(178,181,10000,0,14,4),(178,182,10000,0,14,4),(178,183,10000,0,14,4),(178,184,10000,0,14,4),(178,185,10000,0,14,4),(178,186,10000,0,14,4),(178,187,10000,0,14,4),(178,188,10000,0,14,4),(178,189,10000,0,14,4),(178,190,10000,0,14,4),(178,191,10000,0,14,4),(178,192,10000,0,14,4),(178,193,10000,0,14,4),(178,194,10000,0,14,4),(178,195,10000,0,14,4),(178,196,10000,0,14,4),(178,197,10000,0,14,4),(178,198,10000,0,14,4),(178,199,10000,0,14,4),(178,200,10000,0,14,4),(178,201,10000,0,14,4),(178,202,10000,0,14,4),(178,203,10000,0,14,4),(178,204,10000,0,14,4),(178,205,10000,0,14,4),(178,206,10000,0,14,4),(178,207,10000,0,14,4),(178,208,10000,0,14,4),(178,209,10000,0,14,4),(178,210,10000,0,14,4),(178,211,10000,0,14,4),(178,212,10000,0,14,4),(178,213,10000,0,14,4),(178,214,10000,0,14,4),(178,215,10000,0,14,4),(178,216,10000,0,14,4),(178,217,10000,0,14,4),(178,218,10000,0,14,4),(178,219,10000,0,14,4),(178,220,10000,0,14,4),(178,221,10000,0,14,4),(178,222,10000,0,14,4),(178,223,10000,0,14,4),(178,224,10000,0,14,4),(178,225,10000,0,14,4),(178,226,10000,0,14,4),(178,227,10000,0,14,4),(178,228,10000,0,14,4),(178,229,10000,0,14,4),(178,230,10000,0,14,4),(178,231,10000,0,14,4),(178,232,10000,0,14,4),(178,233,10000,0,14,4),(178,234,10000,0,14,4),(178,235,10000,0,14,4),(178,236,10000,0,14,4),(178,237,10000,0,14,4),(178,238,10000,0,14,4),(178,239,10000,0,14,4),(178,240,10000,0,14,4),(178,241,10000,0,14,4),(178,244,10000,0,14,4),(178,246,10000,0,14,4),(178,251,10000,0,14,4),(178,255,10000,0,14,4),(178,258,10000,0,14,4),(178,259,10000,0,14,4),(178,260,10000,0,14,4),(178,261,10000,0,14,4),(178,262,10000,0,14,4),(178,263,10000,0,14,4),(179,81,0,1,14,4),(179,82,0,1,14,4),(179,83,0,1,14,4),(179,84,0,1,14,4),(179,85,0,1,14,4),(179,86,0,1,14,4),(179,87,0,1,14,4),(179,88,0,1,14,4),(180,81,0,1,14,4),(181,86,0,1,14,4),(182,82,0,1,14,4),(182,83,0,1,14,4),(182,84,0,1,14,4),(182,85,0,1,14,4),(182,87,0,1,14,4),(182,88,0,1,14,4),(183,82,0,1,14,4),(183,83,0,1,14,4),(183,84,0,1,14,4),(183,85,0,1,14,4),(183,86,0,1,14,4),(183,87,0,1,14,4),(183,88,0,1,14,4),(192,89,0,1,14,4),(192,90,0,1,14,4),(192,91,0,1,14,4),(192,92,0,1,14,4),(192,93,0,1,14,4),(192,94,0,1,14,4),(193,95,0,1,14,4),(193,96,0,1,14,4),(193,97,0,1,14,4),(193,98,0,1,14,4),(193,99,0,1,14,4),(193,100,0,1,14,4),(194,95,0,1,14,4),(194,96,0,1,14,4),(194,97,0,1,14,4),(194,98,0,1,14,4),(194,99,0,1,14,4),(194,100,0,1,14,4),(195,95,0,1,14,4),(195,96,0,1,14,4),(195,97,0,1,14,4),(195,98,0,1,14,4),(195,99,0,1,14,4),(195,100,0,1,14,4),(196,95,0,1,14,4),(196,96,0,1,14,4),(196,97,0,1,14,4),(196,98,0,1,14,4),(196,99,0,1,14,4),(196,100,0,1,14,4),(197,95,0,1,14,4),(197,96,0,1,14,4),(197,97,0,1,14,4),(197,98,0,1,14,4),(197,99,0,1,14,4),(197,100,0,1,14,4),(198,101,0,1,14,4),(198,109,0,1,14,4),(198,111,0,1,14,4),(198,112,0,1,14,4),(199,103,0,1,14,4),(199,110,0,1,14,4),(200,101,0,1,14,4),(200,102,0,1,14,4),(200,108,0,1,14,4),(201,104,0,1,14,4),(201,106,0,1,14,4),(202,101,0,1,14,4),(202,102,0,1,14,4),(202,103,0,1,14,4),(202,105,0,1,14,4),(202,107,0,1,14,4),(202,108,0,1,14,4),(202,110,0,1,14,4),(203,101,0,1,14,4),(203,102,0,1,14,4),(203,103,0,1,14,4),(203,104,0,1,14,4),(203,106,0,1,14,4),(203,108,0,1,14,4),(203,109,0,1,14,4),(204,101,0,1,14,4),(204,102,0,1,14,4),(204,103,0,1,14,4),(204,104,0,1,14,4),(204,105,0,1,14,4),(204,106,0,1,14,4),(204,107,0,1,14,4),(204,108,0,1,14,4),(205,101,0,1,14,4),(205,102,0,1,14,4),(205,103,0,1,14,4),(205,108,0,1,14,4),(205,109,0,1,14,4),(205,110,0,1,14,4),(205,111,0,1,14,4),(205,112,0,1,14,4),(206,113,10000,0,14,4),(206,114,10000,0,14,4),(206,115,10000,0,14,4),(206,116,10000,0,14,4),(206,117,10000,0,14,4),(206,118,10000,0,14,4),(206,119,10000,0,14,4),(207,114,0,1,14,4),(207,119,0,1,14,4),(209,114,0,1,14,4),(212,116,0,1,14,4),(212,118,0,1,14,4),(213,113,0,1,14,4),(218,117,0,1,14,4),(219,119,0,1,14,4),(220,119,0,1,14,4),(221,119,0,1,14,4),(222,114,0,1,14,4),(222,119,0,1,14,4),(223,114,0,1,14,4),(223,119,0,1,14,4),(229,113,0,1,14,4),(230,113,0,1,14,4),(231,113,0,1,14,4),(232,113,0,1,14,4),(233,113,0,1,14,4),(234,116,0,1,14,4),(234,118,0,1,14,4),(235,116,0,1,14,4),(235,118,0,1,14,4),(236,116,0,1,14,4),(236,118,0,1,14,4),(237,116,0,1,14,4),(237,118,0,1,14,4),(238,116,0,1,14,4),(238,118,0,1,14,4),(239,115,0,1,14,4),(241,115,0,1,14,4),(242,115,0,1,14,4),(243,115,0,1,14,4),(250,120,0,1,14,4),(250,121,0,1,14,4),(250,122,0,1,14,4),(250,123,0,1,14,4),(250,124,0,1,14,4),(250,125,0,1,14,4),(250,126,0,1,14,4),(250,127,0,1,14,4),(250,128,0,1,14,4),(250,129,0,1,14,4),(250,130,0,1,14,4),(250,131,0,1,14,4),(251,120,0,1,14,4),(251,121,0,1,14,4),(251,122,0,1,14,4),(251,123,0,1,14,4),(251,124,0,1,14,4),(251,125,0,1,14,4),(251,126,0,1,14,4),(251,127,0,1,14,4),(251,128,0,1,14,4),(251,129,0,1,14,4),(251,130,0,1,14,4),(251,131,0,1,14,4),(252,125,10000,0,14,4),(252,126,10000,0,14,4),(252,127,10000,0,14,4),(252,120,0,1,14,4),(252,121,0,1,14,4),(252,122,0,1,14,4),(252,123,0,1,14,4),(252,124,0,1,14,4),(252,128,0,1,14,4),(252,129,0,1,14,4),(252,131,0,1,14,4),(253,120,0,1,14,4),(253,121,0,1,14,4),(253,122,0,1,14,4),(253,123,0,1,14,4),(253,124,0,1,14,4),(253,125,0,1,14,4),(253,126,0,1,14,4),(253,127,0,1,14,4),(253,128,0,1,14,4),(253,129,0,1,14,4),(253,130,0,1,14,4),(253,131,0,1,14,4),(254,120,0,1,14,4),(254,121,0,1,14,4),(254,122,0,1,14,4),(254,123,0,1,14,4),(254,124,0,1,14,4),(254,125,0,1,14,4),(254,126,0,1,14,4),(254,127,0,1,14,4),(254,128,0,1,14,4),(254,129,0,1,14,4),(254,130,0,1,14,4),(254,131,0,1,14,4),(255,122,0,1,14,4),(255,123,0,1,14,4),(255,124,0,1,14,4),(255,125,0,1,14,4),(255,126,0,1,14,4),(255,129,0,1,14,4),(256,121,0,1,14,4),(256,122,0,1,14,4),(256,123,0,1,14,4),(256,125,0,1,14,4),(256,126,0,1,14,4),(256,127,0,1,14,4),(257,121,0,1,14,4),(257,122,0,1,14,4),(257,123,0,1,14,4),(257,125,0,1,14,4),(257,127,0,1,14,4),(257,129,0,1,14,4),(258,121,0,1,14,4),(258,122,0,1,14,4),(258,125,0,1,14,4),(258,126,0,1,14,4),(258,127,0,1,14,4),(258,129,0,1,14,4),(259,120,0,1,14,4),(259,121,0,1,14,4),(259,123,0,1,14,4),(259,128,0,1,14,4),(259,129,0,1,14,4),(260,120,0,1,14,4),(260,121,0,1,14,4),(260,122,0,1,14,4),(260,123,0,1,14,4),(260,125,0,1,14,4),(260,127,0,1,14,4),(260,128,0,1,14,4),(260,129,0,1,14,4),(261,121,0,1,14,4),(261,122,0,1,14,4),(261,125,0,1,14,4),(261,126,0,1,14,4),(261,127,0,1,14,4),(261,129,0,1,14,4),(262,125,0,1,14,4),(262,126,0,1,14,4),(263,120,0,1,14,4),(263,121,0,1,14,4),(263,122,0,1,14,4),(263,123,0,1,14,4),(263,124,0,1,14,4),(263,128,0,1,14,4),(263,129,0,1,14,4),(263,131,0,1,14,4),(264,120,0,1,14,4),(264,122,0,1,14,4),(264,123,0,1,14,4),(264,125,0,1,14,4),(264,126,0,1,14,4),(264,129,0,1,14,4),(265,121,0,1,14,4),(265,122,0,1,14,4),(265,123,0,1,14,4),(265,127,0,1,14,4),(266,123,0,1,14,4),(266,125,0,1,14,4),(266,126,0,1,14,4),(266,127,0,1,14,4),(266,129,0,1,14,4),(267,121,0,1,14,4),(267,125,0,1,14,4),(267,126,0,1,14,4),(267,127,0,1,14,4),(268,120,0,1,14,4),(268,121,0,1,14,4),(268,122,0,1,14,4),(268,123,0,1,14,4),(268,124,0,1,14,4),(268,127,0,1,14,4),(268,129,0,1,14,4),(269,122,0,1,14,4),(269,125,0,1,14,4),(269,126,0,1,14,4),(269,127,0,1,14,4),(269,129,0,1,14,4),(270,121,0,1,14,4),(270,123,0,1,14,4),(270,125,0,1,14,4),(270,126,0,1,14,4),(270,129,0,1,14,4),(271,120,0,1,14,4),(271,121,0,1,14,4),(271,122,0,1,14,4),(271,125,0,1,14,4),(271,126,0,1,14,4),(271,127,0,1,14,4),(271,129,0,1,14,4),(272,122,0,1,14,4),(272,123,0,1,14,4),(272,124,0,1,14,4),(272,125,0,1,14,4),(272,126,0,1,14,4),(272,127,0,1,14,4),(272,128,0,1,14,4),(272,129,0,1,14,4),(273,120,0,1,14,4),(273,121,0,1,14,4),(273,123,0,1,14,4),(273,126,0,1,14,4),(273,127,0,1,14,4),(274,122,0,1,14,4),(274,123,0,1,14,4),(274,125,0,1,14,4),(274,126,0,1,14,4),(274,129,0,1,14,4),(275,120,0,1,14,4),(275,121,0,1,14,4),(275,122,0,1,14,4),(275,123,0,1,14,4),(275,124,0,1,14,4),(275,125,0,1,14,4),(275,126,0,1,14,4),(275,127,0,1,14,4),(275,128,0,1,14,4),(275,129,0,1,14,4),(275,130,0,1,14,4),(275,131,0,1,14,4),(276,122,0,1,14,4),(276,123,0,1,14,4),(276,127,0,1,14,4),(276,129,0,1,14,4),(277,120,0,1,14,4),(277,121,0,1,14,4),(277,123,0,1,14,4),(277,124,0,1,14,4),(277,125,0,1,14,4),(277,126,0,1,14,4),(277,127,0,1,14,4),(278,120,0,1,14,4),(278,121,0,1,14,4),(278,122,0,1,14,4),(278,123,0,1,14,4),(278,124,0,1,14,4),(278,125,0,1,14,4),(278,127,0,1,14,4),(278,128,0,1,14,4),(278,129,0,1,14,4),(279,120,0,1,14,4),(279,122,0,1,14,4),(279,126,0,1,14,4),(279,127,0,1,14,4),(279,129,0,1,14,4),(280,132,0,1,14,4),(280,133,0,1,14,4),(280,134,0,1,14,4),(280,135,0,1,14,4),(280,136,0,1,14,4),(280,137,0,1,14,4),(280,138,0,1,14,4),(280,139,0,1,14,4),(282,132,0,1,14,4),(282,133,0,1,14,4),(282,134,0,1,14,4),(282,137,0,1,14,4),(282,138,0,1,14,4),(283,135,0,1,14,4),(283,136,0,1,14,4),(283,139,0,1,14,4),(286,140,0,1,14,4),(286,141,0,1,14,4),(286,142,0,1,14,4),(286,143,0,1,14,4),(286,144,0,1,14,4),(286,145,0,1,14,4),(286,146,0,1,14,4),(286,147,0,1,14,4),(286,148,0,1,14,4),(286,149,0,1,14,4),(286,150,0,1,14,4),(286,151,0,1,14,4),(286,152,0,1,14,4),(286,153,0,1,14,4),(286,154,0,1,14,4),(286,155,0,1,14,4),(286,156,0,1,14,4),(286,157,0,1,14,4),(286,158,0,1,14,4),(286,159,0,1,14,4),(286,160,0,1,14,4),(286,161,0,1,14,4),(286,162,0,1,14,4),(286,163,0,1,14,4),(286,164,0,1,14,4),(286,165,0,1,14,4),(286,166,0,1,14,4),(286,167,0,1,14,4),(286,168,0,1,14,4),(286,169,0,1,14,4),(286,170,0,1,14,4),(286,171,0,1,14,4),(286,172,0,1,14,4),(286,173,0,1,14,4),(286,174,0,1,14,4),(286,175,0,1,14,4),(286,176,0,1,14,4),(286,177,0,1,14,4),(286,178,0,1,14,4),(286,179,0,1,14,4),(286,180,0,1,14,4),(286,181,0,1,14,4),(286,182,0,1,14,4),(286,183,0,1,14,4),(286,184,0,1,14,4),(286,185,0,1,14,4),(286,186,0,1,14,4),(286,187,0,1,14,4),(287,188,0,1,14,4),(288,189,0,1,14,4),(288,190,0,1,14,4),(288,191,0,1,14,4),(288,192,0,1,14,4),(288,193,0,1,14,4),(288,194,0,1,14,4),(288,195,0,1,14,4),(288,196,0,1,14,4),(288,197,0,1,14,4),(288,198,0,1,14,4),(288,199,0,1,14,4),(288,200,0,1,14,4),(289,201,10000,0,14,4),(289,202,10000,0,14,4),(289,203,10000,0,14,4),(289,204,10000,0,14,4),(289,205,10000,0,14,4),(289,206,10000,0,14,4),(289,207,10000,0,14,4),(289,208,10000,0,14,4),(289,209,10000,0,14,4),(289,210,10000,0,14,4),(289,211,10000,0,14,4),(289,212,10000,0,14,4),(289,213,10000,0,14,4),(289,214,10000,0,14,4),(289,215,10000,0,14,4),(289,216,10000,0,14,4),(289,217,10000,0,14,4),(289,218,10000,0,14,4),(289,219,10000,0,14,4),(289,220,10000,0,14,4),(289,221,10000,0,14,4),(289,222,10000,0,14,4),(289,223,10000,0,14,4),(289,224,10000,0,14,4),(289,225,10000,0,14,4),(289,226,10000,0,14,4),(289,227,10000,0,14,4),(289,228,10000,0,14,4),(289,229,10000,0,14,4),(289,230,10000,0,14,4),(289,231,10000,0,14,4),(289,232,10000,0,14,4),(289,244,10000,0,14,4),(289,246,10000,0,14,4),(289,251,10000,0,14,4),(289,255,10000,0,14,4),(289,258,10000,0,14,4),(289,259,10000,0,14,4),(289,260,10000,0,14,4),(289,261,10000,0,14,4),(289,262,10000,0,14,4),(289,263,10000,0,14,4),(290,209,0,1,14,4),(290,210,0,1,14,4),(290,211,0,1,14,4),(290,212,0,1,14,4),(290,213,0,1,14,4),(290,214,0,1,14,4),(290,215,0,1,14,4),(290,216,0,1,14,4),(291,201,0,1,14,4),(291,202,0,1,14,4),(291,203,0,1,14,4),(291,204,0,1,14,4),(291,205,0,1,14,4),(291,206,0,1,14,4),(291,207,0,1,14,4),(291,208,0,1,14,4),(292,217,0,1,14,4),(292,218,0,1,14,4),(292,219,0,1,14,4),(292,220,0,1,14,4),(292,221,0,1,14,4),(292,222,0,1,14,4),(292,223,0,1,14,4),(292,224,0,1,14,4),(293,225,0,1,14,4),(293,226,0,1,14,4),(293,227,0,1,14,4),(293,228,0,1,14,4),(293,229,0,1,14,4),(293,230,0,1,14,4),(293,231,0,1,14,4),(293,232,0,1,14,4),(293,255,0,1,14,4),(293,259,0,1,14,4),(293,260,0,1,14,4),(293,261,0,1,14,4),(293,262,0,1,14,4),(293,263,0,1,14,4),(294,233,0,1,14,4),(294,234,0,1,14,4),(294,235,0,1,14,4),(294,236,0,1,14,4),(294,237,0,1,14,4),(294,238,0,1,14,4),(294,239,0,1,14,4),(294,240,0,1,14,4),(294,241,0,1,14,4),(295,244,0,1,14,4),(295,246,0,1,14,4),(295,251,0,1,14,4),(295,255,0,1,14,4),(295,258,0,1,14,4),(296,251,0,1,14,4),(296,255,0,1,14,4),(296,258,0,1,14,4),(297,246,0,1,14,4),(297,255,0,1,14,4),(297,258,0,1,14,4),(298,255,0,1,14,4),(298,258,0,1,14,4),(299,251,0,1,14,4),(299,258,0,1,14,4);
/*!40000 ALTER TABLE `catalog_category_product_index_store14` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index_store14_replica`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store14_replica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store14_replica` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `CAT_CTGR_PRD_IDX_STORE14_PRD_ID_STORE_ID_CTGR_ID_VISIBILITY` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_0E7866384855D9DF5A459DF1F4331653` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Product Index Store14 Replica';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index_store14_replica`
--

LOCK TABLES `catalog_category_product_index_store14_replica` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index_store14_replica` DISABLE KEYS */;
INSERT INTO `catalog_category_product_index_store14_replica` VALUES (2,1,0,1,14,4),(2,2,0,1,14,4),(2,3,0,1,14,4),(2,4,0,1,14,4),(2,5,0,1,14,4),(2,6,0,1,14,4),(2,7,0,1,14,4),(2,8,0,1,14,4),(2,9,0,1,14,4),(2,10,0,1,14,4),(2,11,0,1,14,4),(2,12,0,1,14,4),(2,13,0,1,14,4),(2,14,0,1,14,4),(2,15,0,1,14,4),(2,16,0,1,14,4),(2,17,0,1,14,4),(2,18,0,1,14,4),(2,19,0,1,14,4),(2,20,0,1,14,4),(2,21,0,1,14,4),(2,22,0,1,14,4),(2,23,0,1,14,4),(2,24,0,1,14,4),(2,25,0,1,14,4),(2,26,0,1,14,4),(2,27,0,1,14,4),(2,28,0,1,14,4),(2,29,0,1,14,4),(2,30,0,1,14,4),(2,31,0,1,14,4),(2,32,0,1,14,4),(2,33,0,1,14,4),(2,34,0,1,14,4),(2,35,0,1,14,4),(2,36,0,1,14,4),(2,37,0,1,14,4),(2,38,0,1,14,4),(2,39,0,1,14,4),(2,40,0,1,14,4),(2,41,0,1,14,4),(2,42,0,1,14,4),(2,43,0,1,14,4),(2,44,0,1,14,4),(2,45,0,1,14,4),(2,46,0,1,14,4),(2,47,0,1,14,4),(2,48,0,1,14,4),(2,49,0,1,14,4),(2,50,0,1,14,4),(2,57,0,1,14,4),(2,58,0,1,14,4),(2,59,0,1,14,4),(2,60,0,1,14,4),(2,61,0,1,14,4),(2,62,0,1,14,4),(2,63,0,1,14,4),(2,64,0,1,14,4),(2,65,0,1,14,4),(2,66,0,1,14,4),(2,68,0,1,14,4),(2,69,0,1,14,4),(2,70,0,1,14,4),(2,71,0,1,14,4),(2,72,0,1,14,4),(2,73,0,1,14,4),(2,74,0,1,14,4),(2,75,0,1,14,4),(2,76,0,1,14,4),(2,77,0,1,14,4),(2,78,0,1,14,4),(2,79,0,1,14,4),(2,80,0,1,14,4),(2,81,0,1,14,4),(2,82,0,1,14,4),(2,83,0,1,14,4),(2,84,0,1,14,4),(2,85,0,1,14,4),(2,86,0,1,14,4),(2,87,0,1,14,4),(2,88,0,1,14,4),(2,89,0,1,14,4),(2,90,0,1,14,4),(2,91,0,1,14,4),(2,92,0,1,14,4),(2,93,0,1,14,4),(2,94,0,1,14,4),(2,95,0,1,14,4),(2,96,0,1,14,4),(2,97,0,1,14,4),(2,98,0,1,14,4),(2,99,0,1,14,4),(2,100,0,1,14,4),(2,101,0,1,14,4),(2,102,0,1,14,4),(2,103,0,1,14,4),(2,104,0,1,14,4),(2,105,0,1,14,4),(2,106,0,1,14,4),(2,107,0,1,14,4),(2,108,0,1,14,4),(2,109,0,1,14,4),(2,110,0,1,14,4),(2,111,0,1,14,4),(2,112,0,1,14,4),(2,113,0,1,14,4),(2,114,0,1,14,4),(2,115,0,1,14,4),(2,116,0,1,14,4),(2,117,0,1,14,4),(2,118,0,1,14,4),(2,119,0,1,14,4),(2,120,0,1,14,4),(2,121,0,1,14,4),(2,122,0,1,14,4),(2,123,0,1,14,4),(2,124,0,1,14,4),(2,125,0,1,14,4),(2,126,0,1,14,4),(2,127,0,1,14,4),(2,128,0,1,14,4),(2,129,0,1,14,4),(2,130,0,1,14,4),(2,131,0,1,14,4),(2,132,0,1,14,4),(2,133,0,1,14,4),(2,134,0,1,14,4),(2,135,0,1,14,4),(2,136,0,1,14,4),(2,137,0,1,14,4),(2,138,0,1,14,4),(2,139,0,1,14,4),(2,140,0,1,14,4),(2,141,0,1,14,4),(2,142,0,1,14,4),(2,143,0,1,14,4),(2,144,0,1,14,4),(2,145,0,1,14,4),(2,146,0,1,14,4),(2,147,0,1,14,4),(2,148,0,1,14,4),(2,149,0,1,14,4),(2,150,0,1,14,4),(2,151,0,1,14,4),(2,152,0,1,14,4),(2,153,0,1,14,4),(2,154,0,1,14,4),(2,155,0,1,14,4),(2,156,0,1,14,4),(2,157,0,1,14,4),(2,158,0,1,14,4),(2,159,0,1,14,4),(2,160,0,1,14,4),(2,161,0,1,14,4),(2,162,0,1,14,4),(2,163,0,1,14,4),(2,164,0,1,14,4),(2,165,0,1,14,4),(2,166,0,1,14,4),(2,167,0,1,14,4),(2,168,0,1,14,4),(2,169,0,1,14,4),(2,170,0,1,14,4),(2,171,0,1,14,4),(2,172,0,1,14,4),(2,173,0,1,14,4),(2,174,0,1,14,4),(2,175,0,1,14,4),(2,176,0,1,14,4),(2,177,0,1,14,4),(2,178,0,1,14,4),(2,179,0,1,14,4),(2,180,0,1,14,4),(2,181,0,1,14,4),(2,182,0,1,14,4),(2,183,0,1,14,4),(2,184,0,1,14,4),(2,185,0,1,14,4),(2,186,0,1,14,4),(2,187,0,1,14,4),(2,188,0,1,14,4),(2,189,0,1,14,4),(2,190,0,1,14,4),(2,191,0,1,14,4),(2,192,0,1,14,4),(2,193,0,1,14,4),(2,194,0,1,14,4),(2,195,0,1,14,4),(2,196,0,1,14,4),(2,197,0,1,14,4),(2,198,0,1,14,4),(2,199,0,1,14,4),(2,200,0,1,14,4),(2,201,0,1,14,4),(2,202,0,1,14,4),(2,203,0,1,14,4),(2,204,0,1,14,4),(2,205,0,1,14,4),(2,206,0,1,14,4),(2,207,0,1,14,4),(2,208,0,1,14,4),(2,209,0,1,14,4),(2,210,0,1,14,4),(2,211,0,1,14,4),(2,212,0,1,14,4),(2,213,0,1,14,4),(2,214,0,1,14,4),(2,215,0,1,14,4),(2,216,0,1,14,4),(2,217,0,1,14,4),(2,218,0,1,14,4),(2,219,0,1,14,4),(2,220,0,1,14,4),(2,221,0,1,14,4),(2,222,0,1,14,4),(2,223,0,1,14,4),(2,224,0,1,14,4),(2,225,0,1,14,4),(2,226,0,1,14,4),(2,227,0,1,14,4),(2,228,0,1,14,4),(2,229,0,1,14,4),(2,230,0,1,14,4),(2,231,0,1,14,4),(2,232,0,1,14,4),(2,233,0,1,14,4),(2,234,0,1,14,4),(2,235,0,1,14,4),(2,236,0,1,14,4),(2,237,0,1,14,4),(2,238,0,1,14,4),(2,239,0,1,14,4),(2,240,0,1,14,4),(2,241,0,1,14,4),(2,244,0,1,14,4),(2,246,0,1,14,4),(2,251,0,1,14,4),(2,255,0,1,14,4),(2,258,0,1,14,4),(2,259,0,1,14,4),(2,260,0,1,14,4),(2,261,0,1,14,4),(2,262,0,1,14,4),(2,263,0,1,14,4),(3,1,0,1,14,4),(3,2,0,1,14,4),(3,3,0,1,14,4),(3,4,0,1,14,4),(3,5,0,1,14,4),(3,6,0,1,14,4),(3,7,0,1,14,4),(3,8,0,1,14,4),(3,10,0,1,14,4),(3,11,0,1,14,4),(4,12,0,1,14,4),(4,13,0,1,14,4),(4,14,0,1,14,4),(4,15,0,1,14,4),(4,16,0,1,14,4),(4,17,0,1,14,4),(4,18,0,1,14,4),(4,19,0,1,14,4),(4,36,0,1,14,4),(4,37,0,1,14,4),(4,38,0,1,14,4),(4,39,0,1,14,4),(4,40,0,1,14,4),(5,95,10000,0,14,4),(5,96,10000,0,14,4),(5,97,10000,0,14,4),(5,98,10000,0,14,4),(5,99,10000,0,14,4),(5,100,10000,0,14,4),(7,101,10000,0,14,4),(7,102,10000,0,14,4),(7,103,10000,0,14,4),(7,104,10000,0,14,4),(7,105,10000,0,14,4),(7,106,10000,0,14,4),(7,107,10000,0,14,4),(7,108,10000,0,14,4),(7,109,10000,0,14,4),(7,110,10000,0,14,4),(7,111,10000,0,14,4),(7,112,10000,0,14,4),(7,21,0,1,14,4),(7,22,0,1,14,4),(7,26,0,1,14,4),(8,61,0,1,14,4),(8,62,0,1,14,4),(8,63,0,1,14,4),(8,64,0,1,14,4),(8,65,0,1,14,4),(8,66,0,1,14,4),(11,4,10000,0,14,4),(11,89,10000,0,14,4),(11,90,10000,0,14,4),(11,91,10000,0,14,4),(11,92,10000,0,14,4),(11,93,10000,0,14,4),(11,94,10000,0,14,4),(11,28,0,1,14,4),(11,29,0,1,14,4),(11,30,0,1,14,4),(11,31,0,1,14,4),(11,32,0,1,14,4),(11,33,0,1,14,4),(11,34,0,1,14,4),(11,35,0,1,14,4),(13,21,0,1,14,4),(13,24,0,1,14,4),(13,25,0,1,14,4),(13,26,0,1,14,4),(13,27,0,1,14,4),(13,41,0,1,14,4),(13,42,0,1,14,4),(13,43,0,1,14,4),(13,44,0,1,14,4),(13,45,0,1,14,4),(13,46,0,1,14,4),(13,47,0,1,14,4),(13,48,0,1,14,4),(13,49,0,1,14,4),(15,22,10000,0,14,4),(15,23,10000,0,14,4),(16,20,0,1,14,4),(16,21,0,1,14,4),(16,22,0,1,14,4),(16,23,0,1,14,4),(16,24,0,1,14,4),(16,25,0,1,14,4),(16,26,0,1,14,4),(16,27,0,1,14,4),(16,41,0,1,14,4),(16,68,0,1,14,4),(16,69,0,1,14,4),(16,70,0,1,14,4),(16,71,0,1,14,4),(16,72,0,1,14,4),(16,73,0,1,14,4),(19,6,0,1,14,4),(19,7,0,1,14,4),(19,8,0,1,14,4),(19,10,0,1,14,4),(19,11,0,1,14,4),(27,11,0,1,14,4),(29,6,0,1,14,4),(29,8,0,1,14,4),(29,10,0,1,14,4),(30,6,0,1,14,4),(30,10,0,1,14,4),(33,7,0,1,14,4),(33,8,0,1,14,4),(33,10,0,1,14,4),(33,11,0,1,14,4),(42,7,0,1,14,4),(42,8,0,1,14,4),(42,11,0,1,14,4),(78,21,0,1,14,4),(78,26,0,1,14,4),(80,21,0,1,14,4),(80,22,0,1,14,4),(80,26,0,1,14,4),(81,26,0,1,14,4),(82,26,0,1,14,4),(83,26,0,1,14,4),(96,26,0,1,14,4),(97,26,0,1,14,4),(98,21,0,1,14,4),(98,22,0,1,14,4),(98,26,0,1,14,4),(99,18,0,1,14,4),(101,14,0,1,14,4),(101,15,0,1,14,4),(101,16,0,1,14,4),(102,12,0,1,14,4),(102,13,0,1,14,4),(102,14,0,1,14,4),(102,15,0,1,14,4),(102,16,0,1,14,4),(102,17,0,1,14,4),(102,19,0,1,14,4),(102,36,0,1,14,4),(102,37,0,1,14,4),(102,38,0,1,14,4),(102,39,0,1,14,4),(102,40,0,1,14,4),(103,18,0,1,14,4),(104,18,0,1,14,4),(105,18,0,1,14,4),(106,18,0,1,14,4),(107,18,0,1,14,4),(134,23,0,1,14,4),(135,22,0,1,14,4),(137,4,0,1,14,4),(137,28,0,1,14,4),(137,31,0,1,14,4),(137,34,0,1,14,4),(137,35,0,1,14,4),(138,28,0,1,14,4),(138,30,0,1,14,4),(138,32,0,1,14,4),(138,33,0,1,14,4),(139,28,0,1,14,4),(139,30,0,1,14,4),(139,32,0,1,14,4),(139,33,0,1,14,4),(140,28,0,1,14,4),(140,30,0,1,14,4),(140,32,0,1,14,4),(140,33,0,1,14,4),(145,1,0,1,14,4),(145,2,0,1,14,4),(145,3,0,1,14,4),(145,4,0,1,14,4),(145,5,0,1,14,4),(145,6,0,1,14,4),(145,7,0,1,14,4),(145,8,0,1,14,4),(145,9,0,1,14,4),(145,10,0,1,14,4),(145,11,0,1,14,4),(145,12,0,1,14,4),(145,13,0,1,14,4),(145,14,0,1,14,4),(145,15,0,1,14,4),(145,16,0,1,14,4),(145,17,0,1,14,4),(145,18,0,1,14,4),(145,19,0,1,14,4),(145,20,0,1,14,4),(145,21,0,1,14,4),(145,22,0,1,14,4),(145,23,0,1,14,4),(145,24,0,1,14,4),(145,25,0,1,14,4),(145,26,0,1,14,4),(145,27,0,1,14,4),(145,28,0,1,14,4),(145,29,0,1,14,4),(145,30,0,1,14,4),(145,31,0,1,14,4),(145,32,0,1,14,4),(145,33,0,1,14,4),(145,34,0,1,14,4),(145,35,0,1,14,4),(145,36,0,1,14,4),(145,37,0,1,14,4),(145,38,0,1,14,4),(145,39,0,1,14,4),(145,40,0,1,14,4),(145,41,0,1,14,4),(145,42,0,1,14,4),(145,43,0,1,14,4),(149,41,0,1,14,4),(150,50,0,1,14,4),(150,57,0,1,14,4),(150,58,0,1,14,4),(150,59,0,1,14,4),(150,60,0,1,14,4),(151,61,0,1,14,4),(151,62,0,1,14,4),(151,63,0,1,14,4),(151,64,0,1,14,4),(151,65,0,1,14,4),(151,66,0,1,14,4),(152,61,0,1,14,4),(152,63,0,1,14,4),(153,61,0,1,14,4),(153,63,0,1,14,4),(153,64,0,1,14,4),(153,65,0,1,14,4),(153,66,0,1,14,4),(154,61,0,1,14,4),(154,62,0,1,14,4),(154,64,0,1,14,4),(154,66,0,1,14,4),(155,61,0,1,14,4),(155,62,0,1,14,4),(155,64,0,1,14,4),(155,65,0,1,14,4),(155,66,0,1,14,4),(156,61,0,1,14,4),(156,62,0,1,14,4),(156,63,0,1,14,4),(156,64,0,1,14,4),(156,65,0,1,14,4),(156,66,0,1,14,4),(157,61,0,1,14,4),(157,62,0,1,14,4),(157,64,0,1,14,4),(157,65,0,1,14,4),(157,66,0,1,14,4),(158,61,0,1,14,4),(158,63,0,1,14,4),(158,64,0,1,14,4),(158,65,0,1,14,4),(158,66,0,1,14,4),(159,61,0,1,14,4),(159,62,0,1,14,4),(159,63,0,1,14,4),(159,64,0,1,14,4),(159,65,0,1,14,4),(159,66,0,1,14,4),(160,41,0,1,14,4),(160,68,0,1,14,4),(160,69,0,1,14,4),(160,70,0,1,14,4),(160,72,0,1,14,4),(160,73,0,1,14,4),(161,68,0,1,14,4),(161,69,0,1,14,4),(161,70,0,1,14,4),(161,71,0,1,14,4),(161,72,0,1,14,4),(162,68,0,1,14,4),(162,69,0,1,14,4),(162,72,0,1,14,4),(164,41,0,1,14,4),(164,70,0,1,14,4),(164,73,0,1,14,4),(166,41,0,1,14,4),(166,70,0,1,14,4),(166,73,0,1,14,4),(167,68,0,1,14,4),(167,69,0,1,14,4),(167,72,0,1,14,4),(168,71,0,1,14,4),(169,70,0,1,14,4),(171,70,0,1,14,4),(172,1,10000,0,14,4),(172,2,10000,0,14,4),(172,3,10000,0,14,4),(172,4,10000,0,14,4),(172,5,10000,0,14,4),(172,6,10000,0,14,4),(172,7,10000,0,14,4),(172,8,10000,0,14,4),(172,9,10000,0,14,4),(172,10,10000,0,14,4),(172,11,10000,0,14,4),(172,12,10000,0,14,4),(172,13,10000,0,14,4),(172,14,10000,0,14,4),(172,15,10000,0,14,4),(172,16,10000,0,14,4),(172,17,10000,0,14,4),(172,18,10000,0,14,4),(172,19,10000,0,14,4),(172,20,10000,0,14,4),(172,21,10000,0,14,4),(172,22,10000,0,14,4),(172,23,10000,0,14,4),(172,24,10000,0,14,4),(172,25,10000,0,14,4),(172,26,10000,0,14,4),(172,27,10000,0,14,4),(172,28,10000,0,14,4),(172,29,10000,0,14,4),(172,30,10000,0,14,4),(173,1,0,1,14,4),(173,2,0,1,14,4),(173,3,0,1,14,4),(173,4,0,1,14,4),(173,5,0,1,14,4),(173,6,0,1,14,4),(173,7,0,1,14,4),(173,8,0,1,14,4),(173,9,0,1,14,4),(173,10,0,1,14,4),(173,11,0,1,14,4),(173,12,0,1,14,4),(173,13,0,1,14,4),(173,14,0,1,14,4),(173,15,0,1,14,4),(173,16,0,1,14,4),(173,17,0,1,14,4),(173,18,0,1,14,4),(173,19,0,1,14,4),(173,20,0,1,14,4),(173,21,0,1,14,4),(173,22,0,1,14,4),(173,23,0,1,14,4),(173,24,0,1,14,4),(173,25,0,1,14,4),(173,26,0,1,14,4),(173,27,0,1,14,4),(173,28,0,1,14,4),(173,29,0,1,14,4),(173,30,0,1,14,4),(174,1,0,1,14,4),(174,2,0,1,14,4),(174,3,0,1,14,4),(174,4,0,1,14,4),(174,5,0,1,14,4),(174,6,0,1,14,4),(174,7,0,1,14,4),(174,8,0,1,14,4),(174,9,0,1,14,4),(174,10,0,1,14,4),(174,11,0,1,14,4),(174,12,0,1,14,4),(174,13,0,1,14,4),(174,14,0,1,14,4),(174,15,0,1,14,4),(174,16,0,1,14,4),(174,17,0,1,14,4),(174,18,0,1,14,4),(174,19,0,1,14,4),(174,20,0,1,14,4),(174,21,0,1,14,4),(174,22,0,1,14,4),(174,23,0,1,14,4),(174,24,0,1,14,4),(174,25,0,1,14,4),(174,26,0,1,14,4),(174,27,0,1,14,4),(174,28,0,1,14,4),(174,29,0,1,14,4),(174,30,0,1,14,4),(175,1,0,1,14,4),(175,2,0,1,14,4),(175,3,0,1,14,4),(175,4,0,1,14,4),(175,5,0,1,14,4),(175,6,0,1,14,4),(175,7,0,1,14,4),(175,8,0,1,14,4),(175,9,0,1,14,4),(175,10,0,1,14,4),(175,11,0,1,14,4),(175,12,0,1,14,4),(175,13,0,1,14,4),(175,14,0,1,14,4),(175,15,0,1,14,4),(175,16,0,1,14,4),(175,17,0,1,14,4),(175,18,0,1,14,4),(175,19,0,1,14,4),(175,20,0,1,14,4),(175,21,0,1,14,4),(175,22,0,1,14,4),(175,23,0,1,14,4),(175,24,0,1,14,4),(175,25,0,1,14,4),(175,26,0,1,14,4),(175,27,0,1,14,4),(175,28,0,1,14,4),(175,29,0,1,14,4),(175,30,0,1,14,4),(176,1,0,1,14,4),(176,2,0,1,14,4),(176,3,0,1,14,4),(176,4,0,1,14,4),(176,5,0,1,14,4),(176,6,0,1,14,4),(176,7,0,1,14,4),(176,8,0,1,14,4),(176,9,0,1,14,4),(176,10,0,1,14,4),(176,11,0,1,14,4),(176,12,0,1,14,4),(176,13,0,1,14,4),(176,14,0,1,14,4),(176,15,0,1,14,4),(176,16,0,1,14,4),(176,17,0,1,14,4),(176,18,0,1,14,4),(176,19,0,1,14,4),(176,20,0,1,14,4),(176,21,0,1,14,4),(176,22,0,1,14,4),(176,23,0,1,14,4),(176,24,0,1,14,4),(176,25,0,1,14,4),(176,26,0,1,14,4),(176,27,0,1,14,4),(176,28,0,1,14,4),(176,29,0,1,14,4),(176,30,0,1,14,4),(177,74,0,1,14,4),(177,75,0,1,14,4),(177,76,0,1,14,4),(177,77,0,1,14,4),(177,78,0,1,14,4),(177,79,0,1,14,4),(177,80,0,1,14,4),(178,74,10000,0,14,4),(178,75,10000,0,14,4),(178,76,10000,0,14,4),(178,77,10000,0,14,4),(178,78,10000,0,14,4),(178,79,10000,0,14,4),(178,80,10000,0,14,4),(178,81,10000,0,14,4),(178,82,10000,0,14,4),(178,83,10000,0,14,4),(178,84,10000,0,14,4),(178,85,10000,0,14,4),(178,86,10000,0,14,4),(178,87,10000,0,14,4),(178,88,10000,0,14,4),(178,113,10000,0,14,4),(178,114,10000,0,14,4),(178,115,10000,0,14,4),(178,116,10000,0,14,4),(178,117,10000,0,14,4),(178,118,10000,0,14,4),(178,119,10000,0,14,4),(178,120,10000,0,14,4),(178,121,10000,0,14,4),(178,122,10000,0,14,4),(178,123,10000,0,14,4),(178,124,10000,0,14,4),(178,125,10000,0,14,4),(178,126,10000,0,14,4),(178,127,10000,0,14,4),(178,128,10000,0,14,4),(178,129,10000,0,14,4),(178,130,10000,0,14,4),(178,131,10000,0,14,4),(178,132,10000,0,14,4),(178,133,10000,0,14,4),(178,134,10000,0,14,4),(178,135,10000,0,14,4),(178,136,10000,0,14,4),(178,137,10000,0,14,4),(178,138,10000,0,14,4),(178,139,10000,0,14,4),(178,140,10000,0,14,4),(178,141,10000,0,14,4),(178,142,10000,0,14,4),(178,143,10000,0,14,4),(178,144,10000,0,14,4),(178,145,10000,0,14,4),(178,146,10000,0,14,4),(178,147,10000,0,14,4),(178,148,10000,0,14,4),(178,149,10000,0,14,4),(178,150,10000,0,14,4),(178,151,10000,0,14,4),(178,152,10000,0,14,4),(178,153,10000,0,14,4),(178,154,10000,0,14,4),(178,155,10000,0,14,4),(178,156,10000,0,14,4),(178,157,10000,0,14,4),(178,158,10000,0,14,4),(178,159,10000,0,14,4),(178,160,10000,0,14,4),(178,161,10000,0,14,4),(178,162,10000,0,14,4),(178,163,10000,0,14,4),(178,164,10000,0,14,4),(178,165,10000,0,14,4),(178,166,10000,0,14,4),(178,167,10000,0,14,4),(178,168,10000,0,14,4),(178,169,10000,0,14,4),(178,170,10000,0,14,4),(178,171,10000,0,14,4),(178,172,10000,0,14,4),(178,173,10000,0,14,4),(178,174,10000,0,14,4),(178,175,10000,0,14,4),(178,176,10000,0,14,4),(178,177,10000,0,14,4),(178,178,10000,0,14,4),(178,179,10000,0,14,4),(178,180,10000,0,14,4),(178,181,10000,0,14,4),(178,182,10000,0,14,4),(178,183,10000,0,14,4),(178,184,10000,0,14,4),(178,185,10000,0,14,4),(178,186,10000,0,14,4),(178,187,10000,0,14,4),(178,188,10000,0,14,4),(178,189,10000,0,14,4),(178,190,10000,0,14,4),(178,191,10000,0,14,4),(178,192,10000,0,14,4),(178,193,10000,0,14,4),(178,194,10000,0,14,4),(178,195,10000,0,14,4),(178,196,10000,0,14,4),(178,197,10000,0,14,4),(178,198,10000,0,14,4),(178,199,10000,0,14,4),(178,200,10000,0,14,4),(178,201,10000,0,14,4),(178,202,10000,0,14,4),(178,203,10000,0,14,4),(178,204,10000,0,14,4),(178,205,10000,0,14,4),(178,206,10000,0,14,4),(178,207,10000,0,14,4),(178,208,10000,0,14,4),(178,209,10000,0,14,4),(178,210,10000,0,14,4),(178,211,10000,0,14,4),(178,212,10000,0,14,4),(178,213,10000,0,14,4),(178,214,10000,0,14,4),(178,215,10000,0,14,4),(178,216,10000,0,14,4),(178,217,10000,0,14,4),(178,218,10000,0,14,4),(178,219,10000,0,14,4),(178,220,10000,0,14,4),(178,221,10000,0,14,4),(178,222,10000,0,14,4),(178,223,10000,0,14,4),(178,224,10000,0,14,4),(178,225,10000,0,14,4),(178,226,10000,0,14,4),(178,227,10000,0,14,4),(178,228,10000,0,14,4),(178,229,10000,0,14,4),(178,230,10000,0,14,4),(178,231,10000,0,14,4),(178,232,10000,0,14,4),(178,233,10000,0,14,4),(178,234,10000,0,14,4),(178,235,10000,0,14,4),(178,236,10000,0,14,4),(178,237,10000,0,14,4),(178,238,10000,0,14,4),(178,239,10000,0,14,4),(178,240,10000,0,14,4),(178,241,10000,0,14,4),(178,244,10000,0,14,4),(178,246,10000,0,14,4),(178,251,10000,0,14,4),(178,255,10000,0,14,4),(178,258,10000,0,14,4),(178,259,10000,0,14,4),(178,260,10000,0,14,4),(178,261,10000,0,14,4),(178,262,10000,0,14,4),(178,263,10000,0,14,4),(179,81,0,1,14,4),(179,82,0,1,14,4),(179,83,0,1,14,4),(179,84,0,1,14,4),(179,85,0,1,14,4),(179,86,0,1,14,4),(179,87,0,1,14,4),(179,88,0,1,14,4),(180,81,0,1,14,4),(181,86,0,1,14,4),(182,82,0,1,14,4),(182,83,0,1,14,4),(182,84,0,1,14,4),(182,85,0,1,14,4),(182,87,0,1,14,4),(182,88,0,1,14,4),(183,82,0,1,14,4),(183,83,0,1,14,4),(183,84,0,1,14,4),(183,85,0,1,14,4),(183,86,0,1,14,4),(183,87,0,1,14,4),(183,88,0,1,14,4),(192,89,0,1,14,4),(192,90,0,1,14,4),(192,91,0,1,14,4),(192,92,0,1,14,4),(192,93,0,1,14,4),(192,94,0,1,14,4),(193,95,0,1,14,4),(193,96,0,1,14,4),(193,97,0,1,14,4),(193,98,0,1,14,4),(193,99,0,1,14,4),(193,100,0,1,14,4),(194,95,0,1,14,4),(194,96,0,1,14,4),(194,97,0,1,14,4),(194,98,0,1,14,4),(194,99,0,1,14,4),(194,100,0,1,14,4),(195,95,0,1,14,4),(195,96,0,1,14,4),(195,97,0,1,14,4),(195,98,0,1,14,4),(195,99,0,1,14,4),(195,100,0,1,14,4),(196,95,0,1,14,4),(196,96,0,1,14,4),(196,97,0,1,14,4),(196,98,0,1,14,4),(196,99,0,1,14,4),(196,100,0,1,14,4),(197,95,0,1,14,4),(197,96,0,1,14,4),(197,97,0,1,14,4),(197,98,0,1,14,4),(197,99,0,1,14,4),(197,100,0,1,14,4),(198,101,0,1,14,4),(198,109,0,1,14,4),(198,111,0,1,14,4),(198,112,0,1,14,4),(199,103,0,1,14,4),(199,110,0,1,14,4),(200,101,0,1,14,4),(200,102,0,1,14,4),(200,108,0,1,14,4),(201,104,0,1,14,4),(201,106,0,1,14,4),(202,101,0,1,14,4),(202,102,0,1,14,4),(202,103,0,1,14,4),(202,105,0,1,14,4),(202,107,0,1,14,4),(202,108,0,1,14,4),(202,110,0,1,14,4),(203,101,0,1,14,4),(203,102,0,1,14,4),(203,103,0,1,14,4),(203,104,0,1,14,4),(203,106,0,1,14,4),(203,108,0,1,14,4),(203,109,0,1,14,4),(204,101,0,1,14,4),(204,102,0,1,14,4),(204,103,0,1,14,4),(204,104,0,1,14,4),(204,105,0,1,14,4),(204,106,0,1,14,4),(204,107,0,1,14,4),(204,108,0,1,14,4),(205,101,0,1,14,4),(205,102,0,1,14,4),(205,103,0,1,14,4),(205,108,0,1,14,4),(205,109,0,1,14,4),(205,110,0,1,14,4),(205,111,0,1,14,4),(205,112,0,1,14,4),(206,113,10000,0,14,4),(206,114,10000,0,14,4),(206,115,10000,0,14,4),(206,116,10000,0,14,4),(206,117,10000,0,14,4),(206,118,10000,0,14,4),(206,119,10000,0,14,4),(207,114,0,1,14,4),(207,119,0,1,14,4),(209,114,0,1,14,4),(212,116,0,1,14,4),(212,118,0,1,14,4),(213,113,0,1,14,4),(218,117,0,1,14,4),(219,119,0,1,14,4),(220,119,0,1,14,4),(221,119,0,1,14,4),(222,114,0,1,14,4),(222,119,0,1,14,4),(223,114,0,1,14,4),(223,119,0,1,14,4),(229,113,0,1,14,4),(230,113,0,1,14,4),(231,113,0,1,14,4),(232,113,0,1,14,4),(233,113,0,1,14,4),(234,116,0,1,14,4),(234,118,0,1,14,4),(235,116,0,1,14,4),(235,118,0,1,14,4),(236,116,0,1,14,4),(236,118,0,1,14,4),(237,116,0,1,14,4),(237,118,0,1,14,4),(238,116,0,1,14,4),(238,118,0,1,14,4),(239,115,0,1,14,4),(241,115,0,1,14,4),(242,115,0,1,14,4),(243,115,0,1,14,4),(250,120,0,1,14,4),(250,121,0,1,14,4),(250,122,0,1,14,4),(250,123,0,1,14,4),(250,124,0,1,14,4),(250,125,0,1,14,4),(250,126,0,1,14,4),(250,127,0,1,14,4),(250,128,0,1,14,4),(250,129,0,1,14,4),(250,130,0,1,14,4),(250,131,0,1,14,4),(251,120,0,1,14,4),(251,121,0,1,14,4),(251,122,0,1,14,4),(251,123,0,1,14,4),(251,124,0,1,14,4),(251,125,0,1,14,4),(251,126,0,1,14,4),(251,127,0,1,14,4),(251,128,0,1,14,4),(251,129,0,1,14,4),(251,130,0,1,14,4),(251,131,0,1,14,4),(252,125,10000,0,14,4),(252,126,10000,0,14,4),(252,127,10000,0,14,4),(252,120,0,1,14,4),(252,121,0,1,14,4),(252,122,0,1,14,4),(252,123,0,1,14,4),(252,124,0,1,14,4),(252,128,0,1,14,4),(252,129,0,1,14,4),(252,131,0,1,14,4),(253,120,0,1,14,4),(253,121,0,1,14,4),(253,122,0,1,14,4),(253,123,0,1,14,4),(253,124,0,1,14,4),(253,125,0,1,14,4),(253,126,0,1,14,4),(253,127,0,1,14,4),(253,128,0,1,14,4),(253,129,0,1,14,4),(253,130,0,1,14,4),(253,131,0,1,14,4),(254,120,0,1,14,4),(254,121,0,1,14,4),(254,122,0,1,14,4),(254,123,0,1,14,4),(254,124,0,1,14,4),(254,125,0,1,14,4),(254,126,0,1,14,4),(254,127,0,1,14,4),(254,128,0,1,14,4),(254,129,0,1,14,4),(254,130,0,1,14,4),(254,131,0,1,14,4),(255,122,0,1,14,4),(255,123,0,1,14,4),(255,124,0,1,14,4),(255,125,0,1,14,4),(255,126,0,1,14,4),(255,129,0,1,14,4),(256,121,0,1,14,4),(256,122,0,1,14,4),(256,123,0,1,14,4),(256,125,0,1,14,4),(256,126,0,1,14,4),(256,127,0,1,14,4),(257,121,0,1,14,4),(257,122,0,1,14,4),(257,123,0,1,14,4),(257,125,0,1,14,4),(257,127,0,1,14,4),(257,129,0,1,14,4),(258,121,0,1,14,4),(258,122,0,1,14,4),(258,125,0,1,14,4),(258,126,0,1,14,4),(258,127,0,1,14,4),(258,129,0,1,14,4),(259,120,0,1,14,4),(259,121,0,1,14,4),(259,123,0,1,14,4),(259,128,0,1,14,4),(259,129,0,1,14,4),(260,120,0,1,14,4),(260,121,0,1,14,4),(260,122,0,1,14,4),(260,123,0,1,14,4),(260,125,0,1,14,4),(260,127,0,1,14,4),(260,128,0,1,14,4),(260,129,0,1,14,4),(261,121,0,1,14,4),(261,122,0,1,14,4),(261,125,0,1,14,4),(261,126,0,1,14,4),(261,127,0,1,14,4),(261,129,0,1,14,4),(262,125,0,1,14,4),(262,126,0,1,14,4),(263,120,0,1,14,4),(263,121,0,1,14,4),(263,122,0,1,14,4),(263,123,0,1,14,4),(263,124,0,1,14,4),(263,128,0,1,14,4),(263,129,0,1,14,4),(263,131,0,1,14,4),(264,120,0,1,14,4),(264,122,0,1,14,4),(264,123,0,1,14,4),(264,125,0,1,14,4),(264,126,0,1,14,4),(264,129,0,1,14,4),(265,121,0,1,14,4),(265,122,0,1,14,4),(265,123,0,1,14,4),(265,127,0,1,14,4),(266,123,0,1,14,4),(266,125,0,1,14,4),(266,126,0,1,14,4),(266,127,0,1,14,4),(266,129,0,1,14,4),(267,121,0,1,14,4),(267,125,0,1,14,4),(267,126,0,1,14,4),(267,127,0,1,14,4),(268,120,0,1,14,4),(268,121,0,1,14,4),(268,122,0,1,14,4),(268,123,0,1,14,4),(268,124,0,1,14,4),(268,127,0,1,14,4),(268,129,0,1,14,4),(269,122,0,1,14,4),(269,125,0,1,14,4),(269,126,0,1,14,4),(269,127,0,1,14,4),(269,129,0,1,14,4),(270,121,0,1,14,4),(270,123,0,1,14,4),(270,125,0,1,14,4),(270,126,0,1,14,4),(270,129,0,1,14,4),(271,120,0,1,14,4),(271,121,0,1,14,4),(271,122,0,1,14,4),(271,125,0,1,14,4),(271,126,0,1,14,4),(271,127,0,1,14,4),(271,129,0,1,14,4),(272,122,0,1,14,4),(272,123,0,1,14,4),(272,124,0,1,14,4),(272,125,0,1,14,4),(272,126,0,1,14,4),(272,127,0,1,14,4),(272,128,0,1,14,4),(272,129,0,1,14,4),(273,120,0,1,14,4),(273,121,0,1,14,4),(273,123,0,1,14,4),(273,126,0,1,14,4),(273,127,0,1,14,4),(274,122,0,1,14,4),(274,123,0,1,14,4),(274,125,0,1,14,4),(274,126,0,1,14,4),(274,129,0,1,14,4),(275,120,0,1,14,4),(275,121,0,1,14,4),(275,122,0,1,14,4),(275,123,0,1,14,4),(275,124,0,1,14,4),(275,125,0,1,14,4),(275,126,0,1,14,4),(275,127,0,1,14,4),(275,128,0,1,14,4),(275,129,0,1,14,4),(275,130,0,1,14,4),(275,131,0,1,14,4),(276,122,0,1,14,4),(276,123,0,1,14,4),(276,127,0,1,14,4),(276,129,0,1,14,4),(277,120,0,1,14,4),(277,121,0,1,14,4),(277,123,0,1,14,4),(277,124,0,1,14,4),(277,125,0,1,14,4),(277,126,0,1,14,4),(277,127,0,1,14,4),(278,120,0,1,14,4),(278,121,0,1,14,4),(278,122,0,1,14,4),(278,123,0,1,14,4),(278,124,0,1,14,4),(278,125,0,1,14,4),(278,127,0,1,14,4),(278,128,0,1,14,4),(278,129,0,1,14,4),(279,120,0,1,14,4),(279,122,0,1,14,4),(279,126,0,1,14,4),(279,127,0,1,14,4),(279,129,0,1,14,4),(280,132,0,1,14,4),(280,133,0,1,14,4),(280,134,0,1,14,4),(280,135,0,1,14,4),(280,136,0,1,14,4),(280,137,0,1,14,4),(280,138,0,1,14,4),(280,139,0,1,14,4),(282,132,0,1,14,4),(282,133,0,1,14,4),(282,134,0,1,14,4),(282,137,0,1,14,4),(282,138,0,1,14,4),(283,135,0,1,14,4),(283,136,0,1,14,4),(283,139,0,1,14,4),(286,140,0,1,14,4),(286,141,0,1,14,4),(286,142,0,1,14,4),(286,143,0,1,14,4),(286,144,0,1,14,4),(286,145,0,1,14,4),(286,146,0,1,14,4),(286,147,0,1,14,4),(286,148,0,1,14,4),(286,149,0,1,14,4),(286,150,0,1,14,4),(286,151,0,1,14,4),(286,152,0,1,14,4),(286,153,0,1,14,4),(286,154,0,1,14,4),(286,155,0,1,14,4),(286,156,0,1,14,4),(286,157,0,1,14,4),(286,158,0,1,14,4),(286,159,0,1,14,4),(286,160,0,1,14,4),(286,161,0,1,14,4),(286,162,0,1,14,4),(286,163,0,1,14,4),(286,164,0,1,14,4),(286,165,0,1,14,4),(286,166,0,1,14,4),(286,167,0,1,14,4),(286,168,0,1,14,4),(286,169,0,1,14,4),(286,170,0,1,14,4),(286,171,0,1,14,4),(286,172,0,1,14,4),(286,173,0,1,14,4),(286,174,0,1,14,4),(286,175,0,1,14,4),(286,176,0,1,14,4),(286,177,0,1,14,4),(286,178,0,1,14,4),(286,179,0,1,14,4),(286,180,0,1,14,4),(286,181,0,1,14,4),(286,182,0,1,14,4),(286,183,0,1,14,4),(286,184,0,1,14,4),(286,185,0,1,14,4),(286,186,0,1,14,4),(286,187,0,1,14,4),(287,188,0,1,14,4),(288,189,0,1,14,4),(288,190,0,1,14,4),(288,191,0,1,14,4),(288,192,0,1,14,4),(288,193,0,1,14,4),(288,194,0,1,14,4),(288,195,0,1,14,4),(288,196,0,1,14,4),(288,197,0,1,14,4),(288,198,0,1,14,4),(288,199,0,1,14,4),(288,200,0,1,14,4),(289,201,10000,0,14,4),(289,202,10000,0,14,4),(289,203,10000,0,14,4),(289,204,10000,0,14,4),(289,205,10000,0,14,4),(289,206,10000,0,14,4),(289,207,10000,0,14,4),(289,208,10000,0,14,4),(289,209,10000,0,14,4),(289,210,10000,0,14,4),(289,211,10000,0,14,4),(289,212,10000,0,14,4),(289,213,10000,0,14,4),(289,214,10000,0,14,4),(289,215,10000,0,14,4),(289,216,10000,0,14,4),(289,217,10000,0,14,4),(289,218,10000,0,14,4),(289,219,10000,0,14,4),(289,220,10000,0,14,4),(289,221,10000,0,14,4),(289,222,10000,0,14,4),(289,223,10000,0,14,4),(289,224,10000,0,14,4),(289,225,10000,0,14,4),(289,226,10000,0,14,4),(289,227,10000,0,14,4),(289,228,10000,0,14,4),(289,229,10000,0,14,4),(289,230,10000,0,14,4),(289,231,10000,0,14,4),(289,232,10000,0,14,4),(289,244,10000,0,14,4),(289,246,10000,0,14,4),(289,251,10000,0,14,4),(289,255,10000,0,14,4),(289,258,10000,0,14,4),(289,259,10000,0,14,4),(289,260,10000,0,14,4),(289,261,10000,0,14,4),(289,262,10000,0,14,4),(289,263,10000,0,14,4),(290,209,0,1,14,4),(290,210,0,1,14,4),(290,211,0,1,14,4),(290,212,0,1,14,4),(290,213,0,1,14,4),(290,214,0,1,14,4),(290,215,0,1,14,4),(290,216,0,1,14,4),(291,201,0,1,14,4),(291,202,0,1,14,4),(291,203,0,1,14,4),(291,204,0,1,14,4),(291,205,0,1,14,4),(291,206,0,1,14,4),(291,207,0,1,14,4),(291,208,0,1,14,4),(292,217,0,1,14,4),(292,218,0,1,14,4),(292,219,0,1,14,4),(292,220,0,1,14,4),(292,221,0,1,14,4),(292,222,0,1,14,4),(292,223,0,1,14,4),(292,224,0,1,14,4),(293,225,0,1,14,4),(293,226,0,1,14,4),(293,227,0,1,14,4),(293,228,0,1,14,4),(293,229,0,1,14,4),(293,230,0,1,14,4),(293,231,0,1,14,4),(293,232,0,1,14,4),(293,255,0,1,14,4),(293,259,0,1,14,4),(293,260,0,1,14,4),(293,261,0,1,14,4),(293,262,0,1,14,4),(293,263,0,1,14,4),(294,233,0,1,14,4),(294,234,0,1,14,4),(294,235,0,1,14,4),(294,236,0,1,14,4),(294,237,0,1,14,4),(294,238,0,1,14,4),(294,239,0,1,14,4),(294,240,0,1,14,4),(294,241,0,1,14,4),(295,244,0,1,14,4),(295,246,0,1,14,4),(295,251,0,1,14,4),(295,255,0,1,14,4),(295,258,0,1,14,4),(296,251,0,1,14,4),(296,255,0,1,14,4),(296,258,0,1,14,4),(297,246,0,1,14,4),(297,255,0,1,14,4),(297,258,0,1,14,4),(298,255,0,1,14,4),(298,258,0,1,14,4),(299,251,0,1,14,4),(299,258,0,1,14,4);
/*!40000 ALTER TABLE `catalog_category_product_index_store14_replica` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index_store15`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store15`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store15` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `CAT_CTGR_PRD_IDX_STORE15_PRD_ID_STORE_ID_CTGR_ID_VISIBILITY` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_30AF691B78F49C797377718B2DE040CF` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Product Index Store15';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index_store15`
--

LOCK TABLES `catalog_category_product_index_store15` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index_store15` DISABLE KEYS */;
INSERT INTO `catalog_category_product_index_store15` VALUES (2,1,0,1,15,4),(2,2,0,1,15,4),(2,3,0,1,15,4),(2,4,0,1,15,4),(2,5,0,1,15,4),(2,6,0,1,15,4),(2,7,0,1,15,4),(2,8,0,1,15,4),(2,9,0,1,15,4),(2,10,0,1,15,4),(2,11,0,1,15,4),(2,12,0,1,15,4),(2,13,0,1,15,4),(2,14,0,1,15,4),(2,15,0,1,15,4),(2,16,0,1,15,4),(2,17,0,1,15,4),(2,18,0,1,15,4),(2,19,0,1,15,4),(2,20,0,1,15,4),(2,21,0,1,15,4),(2,22,0,1,15,4),(2,23,0,1,15,4),(2,24,0,1,15,4),(2,25,0,1,15,4),(2,26,0,1,15,4),(2,27,0,1,15,4),(2,28,0,1,15,4),(2,29,0,1,15,4),(2,30,0,1,15,4),(2,31,0,1,15,4),(2,32,0,1,15,4),(2,33,0,1,15,4),(2,34,0,1,15,4),(2,35,0,1,15,4),(2,36,0,1,15,4),(2,37,0,1,15,4),(2,38,0,1,15,4),(2,39,0,1,15,4),(2,40,0,1,15,4),(2,41,0,1,15,4),(2,42,0,1,15,4),(2,43,0,1,15,4),(2,44,0,1,15,4),(2,45,0,1,15,4),(2,46,0,1,15,4),(2,47,0,1,15,4),(2,48,0,1,15,4),(2,49,0,1,15,4),(2,50,0,1,15,4),(2,57,0,1,15,4),(2,58,0,1,15,4),(2,59,0,1,15,4),(2,60,0,1,15,4),(2,61,0,1,15,4),(2,62,0,1,15,4),(2,63,0,1,15,4),(2,64,0,1,15,4),(2,65,0,1,15,4),(2,66,0,1,15,4),(2,68,0,1,15,4),(2,69,0,1,15,4),(2,70,0,1,15,4),(2,71,0,1,15,4),(2,72,0,1,15,4),(2,73,0,1,15,4),(2,74,0,1,15,4),(2,75,0,1,15,4),(2,76,0,1,15,4),(2,77,0,1,15,4),(2,78,0,1,15,4),(2,79,0,1,15,4),(2,80,0,1,15,4),(2,81,0,1,15,4),(2,82,0,1,15,4),(2,83,0,1,15,4),(2,84,0,1,15,4),(2,85,0,1,15,4),(2,86,0,1,15,4),(2,87,0,1,15,4),(2,88,0,1,15,4),(2,89,0,1,15,4),(2,90,0,1,15,4),(2,91,0,1,15,4),(2,92,0,1,15,4),(2,93,0,1,15,4),(2,94,0,1,15,4),(2,95,0,1,15,4),(2,96,0,1,15,4),(2,97,0,1,15,4),(2,98,0,1,15,4),(2,99,0,1,15,4),(2,100,0,1,15,4),(2,101,0,1,15,4),(2,102,0,1,15,4),(2,103,0,1,15,4),(2,104,0,1,15,4),(2,105,0,1,15,4),(2,106,0,1,15,4),(2,107,0,1,15,4),(2,108,0,1,15,4),(2,109,0,1,15,4),(2,110,0,1,15,4),(2,111,0,1,15,4),(2,112,0,1,15,4),(2,113,0,1,15,4),(2,114,0,1,15,4),(2,115,0,1,15,4),(2,116,0,1,15,4),(2,117,0,1,15,4),(2,118,0,1,15,4),(2,119,0,1,15,4),(2,120,0,1,15,4),(2,121,0,1,15,4),(2,122,0,1,15,4),(2,123,0,1,15,4),(2,124,0,1,15,4),(2,125,0,1,15,4),(2,126,0,1,15,4),(2,127,0,1,15,4),(2,128,0,1,15,4),(2,129,0,1,15,4),(2,130,0,1,15,4),(2,131,0,1,15,4),(2,132,0,1,15,4),(2,133,0,1,15,4),(2,134,0,1,15,4),(2,135,0,1,15,4),(2,136,0,1,15,4),(2,137,0,1,15,4),(2,138,0,1,15,4),(2,139,0,1,15,4),(2,140,0,1,15,4),(2,141,0,1,15,4),(2,142,0,1,15,4),(2,143,0,1,15,4),(2,144,0,1,15,4),(2,145,0,1,15,4),(2,146,0,1,15,4),(2,147,0,1,15,4),(2,148,0,1,15,4),(2,149,0,1,15,4),(2,150,0,1,15,4),(2,151,0,1,15,4),(2,152,0,1,15,4),(2,153,0,1,15,4),(2,154,0,1,15,4),(2,155,0,1,15,4),(2,156,0,1,15,4),(2,157,0,1,15,4),(2,158,0,1,15,4),(2,159,0,1,15,4),(2,160,0,1,15,4),(2,161,0,1,15,4),(2,162,0,1,15,4),(2,163,0,1,15,4),(2,164,0,1,15,4),(2,165,0,1,15,4),(2,166,0,1,15,4),(2,167,0,1,15,4),(2,168,0,1,15,4),(2,169,0,1,15,4),(2,170,0,1,15,4),(2,171,0,1,15,4),(2,172,0,1,15,4),(2,173,0,1,15,4),(2,174,0,1,15,4),(2,175,0,1,15,4),(2,176,0,1,15,4),(2,177,0,1,15,4),(2,178,0,1,15,4),(2,179,0,1,15,4),(2,180,0,1,15,4),(2,181,0,1,15,4),(2,182,0,1,15,4),(2,183,0,1,15,4),(2,184,0,1,15,4),(2,185,0,1,15,4),(2,186,0,1,15,4),(2,187,0,1,15,4),(2,188,0,1,15,4),(2,189,0,1,15,4),(2,190,0,1,15,4),(2,191,0,1,15,4),(2,192,0,1,15,4),(2,193,0,1,15,4),(2,194,0,1,15,4),(2,195,0,1,15,4),(2,196,0,1,15,4),(2,197,0,1,15,4),(2,198,0,1,15,4),(2,199,0,1,15,4),(2,200,0,1,15,4),(2,201,0,1,15,4),(2,202,0,1,15,4),(2,203,0,1,15,4),(2,204,0,1,15,4),(2,205,0,1,15,4),(2,206,0,1,15,4),(2,207,0,1,15,4),(2,208,0,1,15,4),(2,209,0,1,15,4),(2,210,0,1,15,4),(2,211,0,1,15,4),(2,212,0,1,15,4),(2,213,0,1,15,4),(2,214,0,1,15,4),(2,215,0,1,15,4),(2,216,0,1,15,4),(2,217,0,1,15,4),(2,218,0,1,15,4),(2,219,0,1,15,4),(2,220,0,1,15,4),(2,221,0,1,15,4),(2,222,0,1,15,4),(2,223,0,1,15,4),(2,224,0,1,15,4),(2,225,0,1,15,4),(2,226,0,1,15,4),(2,227,0,1,15,4),(2,228,0,1,15,4),(2,229,0,1,15,4),(2,230,0,1,15,4),(2,231,0,1,15,4),(2,232,0,1,15,4),(2,233,0,1,15,4),(2,234,0,1,15,4),(2,235,0,1,15,4),(2,236,0,1,15,4),(2,237,0,1,15,4),(2,238,0,1,15,4),(2,239,0,1,15,4),(2,240,0,1,15,4),(2,241,0,1,15,4),(2,244,0,1,15,4),(2,246,0,1,15,4),(2,251,0,1,15,4),(2,255,0,1,15,4),(2,258,0,1,15,4),(2,259,0,1,15,4),(2,260,0,1,15,4),(2,261,0,1,15,4),(2,262,0,1,15,4),(2,263,0,1,15,4),(3,1,0,1,15,4),(3,2,0,1,15,4),(3,3,0,1,15,4),(3,4,0,1,15,4),(3,5,0,1,15,4),(3,6,0,1,15,4),(3,7,0,1,15,4),(3,8,0,1,15,4),(3,10,0,1,15,4),(3,11,0,1,15,4),(4,12,0,1,15,4),(4,13,0,1,15,4),(4,14,0,1,15,4),(4,15,0,1,15,4),(4,16,0,1,15,4),(4,17,0,1,15,4),(4,18,0,1,15,4),(4,19,0,1,15,4),(4,36,0,1,15,4),(4,37,0,1,15,4),(4,38,0,1,15,4),(4,39,0,1,15,4),(4,40,0,1,15,4),(5,95,10000,0,15,4),(5,96,10000,0,15,4),(5,97,10000,0,15,4),(5,98,10000,0,15,4),(5,99,10000,0,15,4),(5,100,10000,0,15,4),(7,101,10000,0,15,4),(7,102,10000,0,15,4),(7,103,10000,0,15,4),(7,104,10000,0,15,4),(7,105,10000,0,15,4),(7,106,10000,0,15,4),(7,107,10000,0,15,4),(7,108,10000,0,15,4),(7,109,10000,0,15,4),(7,110,10000,0,15,4),(7,111,10000,0,15,4),(7,112,10000,0,15,4),(7,21,0,1,15,4),(7,22,0,1,15,4),(7,26,0,1,15,4),(8,61,0,1,15,4),(8,62,0,1,15,4),(8,63,0,1,15,4),(8,64,0,1,15,4),(8,65,0,1,15,4),(8,66,0,1,15,4),(11,4,10000,0,15,4),(11,89,10000,0,15,4),(11,90,10000,0,15,4),(11,91,10000,0,15,4),(11,92,10000,0,15,4),(11,93,10000,0,15,4),(11,94,10000,0,15,4),(11,28,0,1,15,4),(11,29,0,1,15,4),(11,30,0,1,15,4),(11,31,0,1,15,4),(11,32,0,1,15,4),(11,33,0,1,15,4),(11,34,0,1,15,4),(11,35,0,1,15,4),(13,21,0,1,15,4),(13,24,0,1,15,4),(13,25,0,1,15,4),(13,26,0,1,15,4),(13,27,0,1,15,4),(13,41,0,1,15,4),(13,42,0,1,15,4),(13,43,0,1,15,4),(13,44,0,1,15,4),(13,45,0,1,15,4),(13,46,0,1,15,4),(13,47,0,1,15,4),(13,48,0,1,15,4),(13,49,0,1,15,4),(15,22,10000,0,15,4),(15,23,10000,0,15,4),(16,20,0,1,15,4),(16,21,0,1,15,4),(16,22,0,1,15,4),(16,23,0,1,15,4),(16,24,0,1,15,4),(16,25,0,1,15,4),(16,26,0,1,15,4),(16,27,0,1,15,4),(16,41,0,1,15,4),(16,68,0,1,15,4),(16,69,0,1,15,4),(16,70,0,1,15,4),(16,71,0,1,15,4),(16,72,0,1,15,4),(16,73,0,1,15,4),(19,6,0,1,15,4),(19,7,0,1,15,4),(19,8,0,1,15,4),(19,10,0,1,15,4),(19,11,0,1,15,4),(27,11,0,1,15,4),(29,6,0,1,15,4),(29,8,0,1,15,4),(29,10,0,1,15,4),(30,6,0,1,15,4),(30,10,0,1,15,4),(33,7,0,1,15,4),(33,8,0,1,15,4),(33,10,0,1,15,4),(33,11,0,1,15,4),(42,7,0,1,15,4),(42,8,0,1,15,4),(42,11,0,1,15,4),(78,21,0,1,15,4),(78,26,0,1,15,4),(80,21,0,1,15,4),(80,22,0,1,15,4),(80,26,0,1,15,4),(81,26,0,1,15,4),(82,26,0,1,15,4),(83,26,0,1,15,4),(96,26,0,1,15,4),(97,26,0,1,15,4),(98,21,0,1,15,4),(98,22,0,1,15,4),(98,26,0,1,15,4),(99,18,0,1,15,4),(101,14,0,1,15,4),(101,15,0,1,15,4),(101,16,0,1,15,4),(102,12,0,1,15,4),(102,13,0,1,15,4),(102,14,0,1,15,4),(102,15,0,1,15,4),(102,16,0,1,15,4),(102,17,0,1,15,4),(102,19,0,1,15,4),(102,36,0,1,15,4),(102,37,0,1,15,4),(102,38,0,1,15,4),(102,39,0,1,15,4),(102,40,0,1,15,4),(103,18,0,1,15,4),(104,18,0,1,15,4),(105,18,0,1,15,4),(106,18,0,1,15,4),(107,18,0,1,15,4),(134,23,0,1,15,4),(135,22,0,1,15,4),(137,4,0,1,15,4),(137,28,0,1,15,4),(137,31,0,1,15,4),(137,34,0,1,15,4),(137,35,0,1,15,4),(138,28,0,1,15,4),(138,30,0,1,15,4),(138,32,0,1,15,4),(138,33,0,1,15,4),(139,28,0,1,15,4),(139,30,0,1,15,4),(139,32,0,1,15,4),(139,33,0,1,15,4),(140,28,0,1,15,4),(140,30,0,1,15,4),(140,32,0,1,15,4),(140,33,0,1,15,4),(145,1,0,1,15,4),(145,2,0,1,15,4),(145,3,0,1,15,4),(145,4,0,1,15,4),(145,5,0,1,15,4),(145,6,0,1,15,4),(145,7,0,1,15,4),(145,8,0,1,15,4),(145,9,0,1,15,4),(145,10,0,1,15,4),(145,11,0,1,15,4),(145,12,0,1,15,4),(145,13,0,1,15,4),(145,14,0,1,15,4),(145,15,0,1,15,4),(145,16,0,1,15,4),(145,17,0,1,15,4),(145,18,0,1,15,4),(145,19,0,1,15,4),(145,20,0,1,15,4),(145,21,0,1,15,4),(145,22,0,1,15,4),(145,23,0,1,15,4),(145,24,0,1,15,4),(145,25,0,1,15,4),(145,26,0,1,15,4),(145,27,0,1,15,4),(145,28,0,1,15,4),(145,29,0,1,15,4),(145,30,0,1,15,4),(145,31,0,1,15,4),(145,32,0,1,15,4),(145,33,0,1,15,4),(145,34,0,1,15,4),(145,35,0,1,15,4),(145,36,0,1,15,4),(145,37,0,1,15,4),(145,38,0,1,15,4),(145,39,0,1,15,4),(145,40,0,1,15,4),(145,41,0,1,15,4),(145,42,0,1,15,4),(145,43,0,1,15,4),(149,41,0,1,15,4),(150,50,0,1,15,4),(150,57,0,1,15,4),(150,58,0,1,15,4),(150,59,0,1,15,4),(150,60,0,1,15,4),(151,61,0,1,15,4),(151,62,0,1,15,4),(151,63,0,1,15,4),(151,64,0,1,15,4),(151,65,0,1,15,4),(151,66,0,1,15,4),(152,61,0,1,15,4),(152,63,0,1,15,4),(153,61,0,1,15,4),(153,63,0,1,15,4),(153,64,0,1,15,4),(153,65,0,1,15,4),(153,66,0,1,15,4),(154,61,0,1,15,4),(154,62,0,1,15,4),(154,64,0,1,15,4),(154,66,0,1,15,4),(155,61,0,1,15,4),(155,62,0,1,15,4),(155,64,0,1,15,4),(155,65,0,1,15,4),(155,66,0,1,15,4),(156,61,0,1,15,4),(156,62,0,1,15,4),(156,63,0,1,15,4),(156,64,0,1,15,4),(156,65,0,1,15,4),(156,66,0,1,15,4),(157,61,0,1,15,4),(157,62,0,1,15,4),(157,64,0,1,15,4),(157,65,0,1,15,4),(157,66,0,1,15,4),(158,61,0,1,15,4),(158,63,0,1,15,4),(158,64,0,1,15,4),(158,65,0,1,15,4),(158,66,0,1,15,4),(159,61,0,1,15,4),(159,62,0,1,15,4),(159,63,0,1,15,4),(159,64,0,1,15,4),(159,65,0,1,15,4),(159,66,0,1,15,4),(160,41,0,1,15,4),(160,68,0,1,15,4),(160,69,0,1,15,4),(160,70,0,1,15,4),(160,72,0,1,15,4),(160,73,0,1,15,4),(161,68,0,1,15,4),(161,69,0,1,15,4),(161,70,0,1,15,4),(161,71,0,1,15,4),(161,72,0,1,15,4),(162,68,0,1,15,4),(162,69,0,1,15,4),(162,72,0,1,15,4),(164,41,0,1,15,4),(164,70,0,1,15,4),(164,73,0,1,15,4),(166,41,0,1,15,4),(166,70,0,1,15,4),(166,73,0,1,15,4),(167,68,0,1,15,4),(167,69,0,1,15,4),(167,72,0,1,15,4),(168,71,0,1,15,4),(169,70,0,1,15,4),(171,70,0,1,15,4),(172,1,10000,0,15,4),(172,2,10000,0,15,4),(172,3,10000,0,15,4),(172,4,10000,0,15,4),(172,5,10000,0,15,4),(172,6,10000,0,15,4),(172,7,10000,0,15,4),(172,8,10000,0,15,4),(172,9,10000,0,15,4),(172,10,10000,0,15,4),(172,11,10000,0,15,4),(172,12,10000,0,15,4),(172,13,10000,0,15,4),(172,14,10000,0,15,4),(172,15,10000,0,15,4),(172,16,10000,0,15,4),(172,17,10000,0,15,4),(172,18,10000,0,15,4),(172,19,10000,0,15,4),(172,20,10000,0,15,4),(172,21,10000,0,15,4),(172,22,10000,0,15,4),(172,23,10000,0,15,4),(172,24,10000,0,15,4),(172,25,10000,0,15,4),(172,26,10000,0,15,4),(172,27,10000,0,15,4),(172,28,10000,0,15,4),(172,29,10000,0,15,4),(172,30,10000,0,15,4),(173,1,0,1,15,4),(173,2,0,1,15,4),(173,3,0,1,15,4),(173,4,0,1,15,4),(173,5,0,1,15,4),(173,6,0,1,15,4),(173,7,0,1,15,4),(173,8,0,1,15,4),(173,9,0,1,15,4),(173,10,0,1,15,4),(173,11,0,1,15,4),(173,12,0,1,15,4),(173,13,0,1,15,4),(173,14,0,1,15,4),(173,15,0,1,15,4),(173,16,0,1,15,4),(173,17,0,1,15,4),(173,18,0,1,15,4),(173,19,0,1,15,4),(173,20,0,1,15,4),(173,21,0,1,15,4),(173,22,0,1,15,4),(173,23,0,1,15,4),(173,24,0,1,15,4),(173,25,0,1,15,4),(173,26,0,1,15,4),(173,27,0,1,15,4),(173,28,0,1,15,4),(173,29,0,1,15,4),(173,30,0,1,15,4),(174,1,0,1,15,4),(174,2,0,1,15,4),(174,3,0,1,15,4),(174,4,0,1,15,4),(174,5,0,1,15,4),(174,6,0,1,15,4),(174,7,0,1,15,4),(174,8,0,1,15,4),(174,9,0,1,15,4),(174,10,0,1,15,4),(174,11,0,1,15,4),(174,12,0,1,15,4),(174,13,0,1,15,4),(174,14,0,1,15,4),(174,15,0,1,15,4),(174,16,0,1,15,4),(174,17,0,1,15,4),(174,18,0,1,15,4),(174,19,0,1,15,4),(174,20,0,1,15,4),(174,21,0,1,15,4),(174,22,0,1,15,4),(174,23,0,1,15,4),(174,24,0,1,15,4),(174,25,0,1,15,4),(174,26,0,1,15,4),(174,27,0,1,15,4),(174,28,0,1,15,4),(174,29,0,1,15,4),(174,30,0,1,15,4),(175,1,0,1,15,4),(175,2,0,1,15,4),(175,3,0,1,15,4),(175,4,0,1,15,4),(175,5,0,1,15,4),(175,6,0,1,15,4),(175,7,0,1,15,4),(175,8,0,1,15,4),(175,9,0,1,15,4),(175,10,0,1,15,4),(175,11,0,1,15,4),(175,12,0,1,15,4),(175,13,0,1,15,4),(175,14,0,1,15,4),(175,15,0,1,15,4),(175,16,0,1,15,4),(175,17,0,1,15,4),(175,18,0,1,15,4),(175,19,0,1,15,4),(175,20,0,1,15,4),(175,21,0,1,15,4),(175,22,0,1,15,4),(175,23,0,1,15,4),(175,24,0,1,15,4),(175,25,0,1,15,4),(175,26,0,1,15,4),(175,27,0,1,15,4),(175,28,0,1,15,4),(175,29,0,1,15,4),(175,30,0,1,15,4),(176,1,0,1,15,4),(176,2,0,1,15,4),(176,3,0,1,15,4),(176,4,0,1,15,4),(176,5,0,1,15,4),(176,6,0,1,15,4),(176,7,0,1,15,4),(176,8,0,1,15,4),(176,9,0,1,15,4),(176,10,0,1,15,4),(176,11,0,1,15,4),(176,12,0,1,15,4),(176,13,0,1,15,4),(176,14,0,1,15,4),(176,15,0,1,15,4),(176,16,0,1,15,4),(176,17,0,1,15,4),(176,18,0,1,15,4),(176,19,0,1,15,4),(176,20,0,1,15,4),(176,21,0,1,15,4),(176,22,0,1,15,4),(176,23,0,1,15,4),(176,24,0,1,15,4),(176,25,0,1,15,4),(176,26,0,1,15,4),(176,27,0,1,15,4),(176,28,0,1,15,4),(176,29,0,1,15,4),(176,30,0,1,15,4),(177,74,0,1,15,4),(177,75,0,1,15,4),(177,76,0,1,15,4),(177,77,0,1,15,4),(177,78,0,1,15,4),(177,79,0,1,15,4),(177,80,0,1,15,4),(178,74,10000,0,15,4),(178,75,10000,0,15,4),(178,76,10000,0,15,4),(178,77,10000,0,15,4),(178,78,10000,0,15,4),(178,79,10000,0,15,4),(178,80,10000,0,15,4),(178,81,10000,0,15,4),(178,82,10000,0,15,4),(178,83,10000,0,15,4),(178,84,10000,0,15,4),(178,85,10000,0,15,4),(178,86,10000,0,15,4),(178,87,10000,0,15,4),(178,88,10000,0,15,4),(178,113,10000,0,15,4),(178,114,10000,0,15,4),(178,115,10000,0,15,4),(178,116,10000,0,15,4),(178,117,10000,0,15,4),(178,118,10000,0,15,4),(178,119,10000,0,15,4),(178,120,10000,0,15,4),(178,121,10000,0,15,4),(178,122,10000,0,15,4),(178,123,10000,0,15,4),(178,124,10000,0,15,4),(178,125,10000,0,15,4),(178,126,10000,0,15,4),(178,127,10000,0,15,4),(178,128,10000,0,15,4),(178,129,10000,0,15,4),(178,130,10000,0,15,4),(178,131,10000,0,15,4),(178,132,10000,0,15,4),(178,133,10000,0,15,4),(178,134,10000,0,15,4),(178,135,10000,0,15,4),(178,136,10000,0,15,4),(178,137,10000,0,15,4),(178,138,10000,0,15,4),(178,139,10000,0,15,4),(178,140,10000,0,15,4),(178,141,10000,0,15,4),(178,142,10000,0,15,4),(178,143,10000,0,15,4),(178,144,10000,0,15,4),(178,145,10000,0,15,4),(178,146,10000,0,15,4),(178,147,10000,0,15,4),(178,148,10000,0,15,4),(178,149,10000,0,15,4),(178,150,10000,0,15,4),(178,151,10000,0,15,4),(178,152,10000,0,15,4),(178,153,10000,0,15,4),(178,154,10000,0,15,4),(178,155,10000,0,15,4),(178,156,10000,0,15,4),(178,157,10000,0,15,4),(178,158,10000,0,15,4),(178,159,10000,0,15,4),(178,160,10000,0,15,4),(178,161,10000,0,15,4),(178,162,10000,0,15,4),(178,163,10000,0,15,4),(178,164,10000,0,15,4),(178,165,10000,0,15,4),(178,166,10000,0,15,4),(178,167,10000,0,15,4),(178,168,10000,0,15,4),(178,169,10000,0,15,4),(178,170,10000,0,15,4),(178,171,10000,0,15,4),(178,172,10000,0,15,4),(178,173,10000,0,15,4),(178,174,10000,0,15,4),(178,175,10000,0,15,4),(178,176,10000,0,15,4),(178,177,10000,0,15,4),(178,178,10000,0,15,4),(178,179,10000,0,15,4),(178,180,10000,0,15,4),(178,181,10000,0,15,4),(178,182,10000,0,15,4),(178,183,10000,0,15,4),(178,184,10000,0,15,4),(178,185,10000,0,15,4),(178,186,10000,0,15,4),(178,187,10000,0,15,4),(178,188,10000,0,15,4),(178,189,10000,0,15,4),(178,190,10000,0,15,4),(178,191,10000,0,15,4),(178,192,10000,0,15,4),(178,193,10000,0,15,4),(178,194,10000,0,15,4),(178,195,10000,0,15,4),(178,196,10000,0,15,4),(178,197,10000,0,15,4),(178,198,10000,0,15,4),(178,199,10000,0,15,4),(178,200,10000,0,15,4),(178,201,10000,0,15,4),(178,202,10000,0,15,4),(178,203,10000,0,15,4),(178,204,10000,0,15,4),(178,205,10000,0,15,4),(178,206,10000,0,15,4),(178,207,10000,0,15,4),(178,208,10000,0,15,4),(178,209,10000,0,15,4),(178,210,10000,0,15,4),(178,211,10000,0,15,4),(178,212,10000,0,15,4),(178,213,10000,0,15,4),(178,214,10000,0,15,4),(178,215,10000,0,15,4),(178,216,10000,0,15,4),(178,217,10000,0,15,4),(178,218,10000,0,15,4),(178,219,10000,0,15,4),(178,220,10000,0,15,4),(178,221,10000,0,15,4),(178,222,10000,0,15,4),(178,223,10000,0,15,4),(178,224,10000,0,15,4),(178,225,10000,0,15,4),(178,226,10000,0,15,4),(178,227,10000,0,15,4),(178,228,10000,0,15,4),(178,229,10000,0,15,4),(178,230,10000,0,15,4),(178,231,10000,0,15,4),(178,232,10000,0,15,4),(178,233,10000,0,15,4),(178,234,10000,0,15,4),(178,235,10000,0,15,4),(178,236,10000,0,15,4),(178,237,10000,0,15,4),(178,238,10000,0,15,4),(178,239,10000,0,15,4),(178,240,10000,0,15,4),(178,241,10000,0,15,4),(178,244,10000,0,15,4),(178,246,10000,0,15,4),(178,251,10000,0,15,4),(178,255,10000,0,15,4),(178,258,10000,0,15,4),(178,259,10000,0,15,4),(178,260,10000,0,15,4),(178,261,10000,0,15,4),(178,262,10000,0,15,4),(178,263,10000,0,15,4),(179,81,0,1,15,4),(179,82,0,1,15,4),(179,83,0,1,15,4),(179,84,0,1,15,4),(179,85,0,1,15,4),(179,86,0,1,15,4),(179,87,0,1,15,4),(179,88,0,1,15,4),(180,81,0,1,15,4),(181,86,0,1,15,4),(182,82,0,1,15,4),(182,83,0,1,15,4),(182,84,0,1,15,4),(182,85,0,1,15,4),(182,87,0,1,15,4),(182,88,0,1,15,4),(183,82,0,1,15,4),(183,83,0,1,15,4),(183,84,0,1,15,4),(183,85,0,1,15,4),(183,86,0,1,15,4),(183,87,0,1,15,4),(183,88,0,1,15,4),(192,89,0,1,15,4),(192,90,0,1,15,4),(192,91,0,1,15,4),(192,92,0,1,15,4),(192,93,0,1,15,4),(192,94,0,1,15,4),(193,95,0,1,15,4),(193,96,0,1,15,4),(193,97,0,1,15,4),(193,98,0,1,15,4),(193,99,0,1,15,4),(193,100,0,1,15,4),(194,95,0,1,15,4),(194,96,0,1,15,4),(194,97,0,1,15,4),(194,98,0,1,15,4),(194,99,0,1,15,4),(194,100,0,1,15,4),(195,95,0,1,15,4),(195,96,0,1,15,4),(195,97,0,1,15,4),(195,98,0,1,15,4),(195,99,0,1,15,4),(195,100,0,1,15,4),(196,95,0,1,15,4),(196,96,0,1,15,4),(196,97,0,1,15,4),(196,98,0,1,15,4),(196,99,0,1,15,4),(196,100,0,1,15,4),(197,95,0,1,15,4),(197,96,0,1,15,4),(197,97,0,1,15,4),(197,98,0,1,15,4),(197,99,0,1,15,4),(197,100,0,1,15,4),(198,101,0,1,15,4),(198,109,0,1,15,4),(198,111,0,1,15,4),(198,112,0,1,15,4),(199,103,0,1,15,4),(199,110,0,1,15,4),(200,101,0,1,15,4),(200,102,0,1,15,4),(200,108,0,1,15,4),(201,104,0,1,15,4),(201,106,0,1,15,4),(202,101,0,1,15,4),(202,102,0,1,15,4),(202,103,0,1,15,4),(202,105,0,1,15,4),(202,107,0,1,15,4),(202,108,0,1,15,4),(202,110,0,1,15,4),(203,101,0,1,15,4),(203,102,0,1,15,4),(203,103,0,1,15,4),(203,104,0,1,15,4),(203,106,0,1,15,4),(203,108,0,1,15,4),(203,109,0,1,15,4),(204,101,0,1,15,4),(204,102,0,1,15,4),(204,103,0,1,15,4),(204,104,0,1,15,4),(204,105,0,1,15,4),(204,106,0,1,15,4),(204,107,0,1,15,4),(204,108,0,1,15,4),(205,101,0,1,15,4),(205,102,0,1,15,4),(205,103,0,1,15,4),(205,108,0,1,15,4),(205,109,0,1,15,4),(205,110,0,1,15,4),(205,111,0,1,15,4),(205,112,0,1,15,4),(206,113,10000,0,15,4),(206,114,10000,0,15,4),(206,115,10000,0,15,4),(206,116,10000,0,15,4),(206,117,10000,0,15,4),(206,118,10000,0,15,4),(206,119,10000,0,15,4),(207,114,0,1,15,4),(207,119,0,1,15,4),(209,114,0,1,15,4),(212,116,0,1,15,4),(212,118,0,1,15,4),(213,113,0,1,15,4),(218,117,0,1,15,4),(219,119,0,1,15,4),(220,119,0,1,15,4),(221,119,0,1,15,4),(222,114,0,1,15,4),(222,119,0,1,15,4),(223,114,0,1,15,4),(223,119,0,1,15,4),(229,113,0,1,15,4),(230,113,0,1,15,4),(231,113,0,1,15,4),(232,113,0,1,15,4),(233,113,0,1,15,4),(234,116,0,1,15,4),(234,118,0,1,15,4),(235,116,0,1,15,4),(235,118,0,1,15,4),(236,116,0,1,15,4),(236,118,0,1,15,4),(237,116,0,1,15,4),(237,118,0,1,15,4),(238,116,0,1,15,4),(238,118,0,1,15,4),(239,115,0,1,15,4),(241,115,0,1,15,4),(242,115,0,1,15,4),(243,115,0,1,15,4),(250,120,0,1,15,4),(250,121,0,1,15,4),(250,122,0,1,15,4),(250,123,0,1,15,4),(250,124,0,1,15,4),(250,125,0,1,15,4),(250,126,0,1,15,4),(250,127,0,1,15,4),(250,128,0,1,15,4),(250,129,0,1,15,4),(250,130,0,1,15,4),(250,131,0,1,15,4),(251,120,0,1,15,4),(251,121,0,1,15,4),(251,122,0,1,15,4),(251,123,0,1,15,4),(251,124,0,1,15,4),(251,125,0,1,15,4),(251,126,0,1,15,4),(251,127,0,1,15,4),(251,128,0,1,15,4),(251,129,0,1,15,4),(251,130,0,1,15,4),(251,131,0,1,15,4),(252,125,10000,0,15,4),(252,126,10000,0,15,4),(252,127,10000,0,15,4),(252,120,0,1,15,4),(252,121,0,1,15,4),(252,122,0,1,15,4),(252,123,0,1,15,4),(252,124,0,1,15,4),(252,128,0,1,15,4),(252,129,0,1,15,4),(252,131,0,1,15,4),(253,120,0,1,15,4),(253,121,0,1,15,4),(253,122,0,1,15,4),(253,123,0,1,15,4),(253,124,0,1,15,4),(253,125,0,1,15,4),(253,126,0,1,15,4),(253,127,0,1,15,4),(253,128,0,1,15,4),(253,129,0,1,15,4),(253,130,0,1,15,4),(253,131,0,1,15,4),(254,120,0,1,15,4),(254,121,0,1,15,4),(254,122,0,1,15,4),(254,123,0,1,15,4),(254,124,0,1,15,4),(254,125,0,1,15,4),(254,126,0,1,15,4),(254,127,0,1,15,4),(254,128,0,1,15,4),(254,129,0,1,15,4),(254,130,0,1,15,4),(254,131,0,1,15,4),(255,122,0,1,15,4),(255,123,0,1,15,4),(255,124,0,1,15,4),(255,125,0,1,15,4),(255,126,0,1,15,4),(255,129,0,1,15,4),(256,121,0,1,15,4),(256,122,0,1,15,4),(256,123,0,1,15,4),(256,125,0,1,15,4),(256,126,0,1,15,4),(256,127,0,1,15,4),(257,121,0,1,15,4),(257,122,0,1,15,4),(257,123,0,1,15,4),(257,125,0,1,15,4),(257,127,0,1,15,4),(257,129,0,1,15,4),(258,121,0,1,15,4),(258,122,0,1,15,4),(258,125,0,1,15,4),(258,126,0,1,15,4),(258,127,0,1,15,4),(258,129,0,1,15,4),(259,120,0,1,15,4),(259,121,0,1,15,4),(259,123,0,1,15,4),(259,128,0,1,15,4),(259,129,0,1,15,4),(260,120,0,1,15,4),(260,121,0,1,15,4),(260,122,0,1,15,4),(260,123,0,1,15,4),(260,125,0,1,15,4),(260,127,0,1,15,4),(260,128,0,1,15,4),(260,129,0,1,15,4),(261,121,0,1,15,4),(261,122,0,1,15,4),(261,125,0,1,15,4),(261,126,0,1,15,4),(261,127,0,1,15,4),(261,129,0,1,15,4),(262,125,0,1,15,4),(262,126,0,1,15,4),(263,120,0,1,15,4),(263,121,0,1,15,4),(263,122,0,1,15,4),(263,123,0,1,15,4),(263,124,0,1,15,4),(263,128,0,1,15,4),(263,129,0,1,15,4),(263,131,0,1,15,4),(264,120,0,1,15,4),(264,122,0,1,15,4),(264,123,0,1,15,4),(264,125,0,1,15,4),(264,126,0,1,15,4),(264,129,0,1,15,4),(265,121,0,1,15,4),(265,122,0,1,15,4),(265,123,0,1,15,4),(265,127,0,1,15,4),(266,123,0,1,15,4),(266,125,0,1,15,4),(266,126,0,1,15,4),(266,127,0,1,15,4),(266,129,0,1,15,4),(267,121,0,1,15,4),(267,125,0,1,15,4),(267,126,0,1,15,4),(267,127,0,1,15,4),(268,120,0,1,15,4),(268,121,0,1,15,4),(268,122,0,1,15,4),(268,123,0,1,15,4),(268,124,0,1,15,4),(268,127,0,1,15,4),(268,129,0,1,15,4),(269,122,0,1,15,4),(269,125,0,1,15,4),(269,126,0,1,15,4),(269,127,0,1,15,4),(269,129,0,1,15,4),(270,121,0,1,15,4),(270,123,0,1,15,4),(270,125,0,1,15,4),(270,126,0,1,15,4),(270,129,0,1,15,4),(271,120,0,1,15,4),(271,121,0,1,15,4),(271,122,0,1,15,4),(271,125,0,1,15,4),(271,126,0,1,15,4),(271,127,0,1,15,4),(271,129,0,1,15,4),(272,122,0,1,15,4),(272,123,0,1,15,4),(272,124,0,1,15,4),(272,125,0,1,15,4),(272,126,0,1,15,4),(272,127,0,1,15,4),(272,128,0,1,15,4),(272,129,0,1,15,4),(273,120,0,1,15,4),(273,121,0,1,15,4),(273,123,0,1,15,4),(273,126,0,1,15,4),(273,127,0,1,15,4),(274,122,0,1,15,4),(274,123,0,1,15,4),(274,125,0,1,15,4),(274,126,0,1,15,4),(274,129,0,1,15,4),(275,120,0,1,15,4),(275,121,0,1,15,4),(275,122,0,1,15,4),(275,123,0,1,15,4),(275,124,0,1,15,4),(275,125,0,1,15,4),(275,126,0,1,15,4),(275,127,0,1,15,4),(275,128,0,1,15,4),(275,129,0,1,15,4),(275,130,0,1,15,4),(275,131,0,1,15,4),(276,122,0,1,15,4),(276,123,0,1,15,4),(276,127,0,1,15,4),(276,129,0,1,15,4),(277,120,0,1,15,4),(277,121,0,1,15,4),(277,123,0,1,15,4),(277,124,0,1,15,4),(277,125,0,1,15,4),(277,126,0,1,15,4),(277,127,0,1,15,4),(278,120,0,1,15,4),(278,121,0,1,15,4),(278,122,0,1,15,4),(278,123,0,1,15,4),(278,124,0,1,15,4),(278,125,0,1,15,4),(278,127,0,1,15,4),(278,128,0,1,15,4),(278,129,0,1,15,4),(279,120,0,1,15,4),(279,122,0,1,15,4),(279,126,0,1,15,4),(279,127,0,1,15,4),(279,129,0,1,15,4),(280,132,0,1,15,4),(280,133,0,1,15,4),(280,134,0,1,15,4),(280,135,0,1,15,4),(280,136,0,1,15,4),(280,137,0,1,15,4),(280,138,0,1,15,4),(280,139,0,1,15,4),(282,132,0,1,15,4),(282,133,0,1,15,4),(282,134,0,1,15,4),(282,137,0,1,15,4),(282,138,0,1,15,4),(283,135,0,1,15,4),(283,136,0,1,15,4),(283,139,0,1,15,4),(286,140,0,1,15,4),(286,141,0,1,15,4),(286,142,0,1,15,4),(286,143,0,1,15,4),(286,144,0,1,15,4),(286,145,0,1,15,4),(286,146,0,1,15,4),(286,147,0,1,15,4),(286,148,0,1,15,4),(286,149,0,1,15,4),(286,150,0,1,15,4),(286,151,0,1,15,4),(286,152,0,1,15,4),(286,153,0,1,15,4),(286,154,0,1,15,4),(286,155,0,1,15,4),(286,156,0,1,15,4),(286,157,0,1,15,4),(286,158,0,1,15,4),(286,159,0,1,15,4),(286,160,0,1,15,4),(286,161,0,1,15,4),(286,162,0,1,15,4),(286,163,0,1,15,4),(286,164,0,1,15,4),(286,165,0,1,15,4),(286,166,0,1,15,4),(286,167,0,1,15,4),(286,168,0,1,15,4),(286,169,0,1,15,4),(286,170,0,1,15,4),(286,171,0,1,15,4),(286,172,0,1,15,4),(286,173,0,1,15,4),(286,174,0,1,15,4),(286,175,0,1,15,4),(286,176,0,1,15,4),(286,177,0,1,15,4),(286,178,0,1,15,4),(286,179,0,1,15,4),(286,180,0,1,15,4),(286,181,0,1,15,4),(286,182,0,1,15,4),(286,183,0,1,15,4),(286,184,0,1,15,4),(286,185,0,1,15,4),(286,186,0,1,15,4),(286,187,0,1,15,4),(287,188,0,1,15,4),(288,189,0,1,15,4),(288,190,0,1,15,4),(288,191,0,1,15,4),(288,192,0,1,15,4),(288,193,0,1,15,4),(288,194,0,1,15,4),(288,195,0,1,15,4),(288,196,0,1,15,4),(288,197,0,1,15,4),(288,198,0,1,15,4),(288,199,0,1,15,4),(288,200,0,1,15,4),(289,201,10000,0,15,4),(289,202,10000,0,15,4),(289,203,10000,0,15,4),(289,204,10000,0,15,4),(289,205,10000,0,15,4),(289,206,10000,0,15,4),(289,207,10000,0,15,4),(289,208,10000,0,15,4),(289,209,10000,0,15,4),(289,210,10000,0,15,4),(289,211,10000,0,15,4),(289,212,10000,0,15,4),(289,213,10000,0,15,4),(289,214,10000,0,15,4),(289,215,10000,0,15,4),(289,216,10000,0,15,4),(289,217,10000,0,15,4),(289,218,10000,0,15,4),(289,219,10000,0,15,4),(289,220,10000,0,15,4),(289,221,10000,0,15,4),(289,222,10000,0,15,4),(289,223,10000,0,15,4),(289,224,10000,0,15,4),(289,225,10000,0,15,4),(289,226,10000,0,15,4),(289,227,10000,0,15,4),(289,228,10000,0,15,4),(289,229,10000,0,15,4),(289,230,10000,0,15,4),(289,231,10000,0,15,4),(289,232,10000,0,15,4),(289,244,10000,0,15,4),(289,246,10000,0,15,4),(289,251,10000,0,15,4),(289,255,10000,0,15,4),(289,258,10000,0,15,4),(289,259,10000,0,15,4),(289,260,10000,0,15,4),(289,261,10000,0,15,4),(289,262,10000,0,15,4),(289,263,10000,0,15,4),(290,209,0,1,15,4),(290,210,0,1,15,4),(290,211,0,1,15,4),(290,212,0,1,15,4),(290,213,0,1,15,4),(290,214,0,1,15,4),(290,215,0,1,15,4),(290,216,0,1,15,4),(291,201,0,1,15,4),(291,202,0,1,15,4),(291,203,0,1,15,4),(291,204,0,1,15,4),(291,205,0,1,15,4),(291,206,0,1,15,4),(291,207,0,1,15,4),(291,208,0,1,15,4),(292,217,0,1,15,4),(292,218,0,1,15,4),(292,219,0,1,15,4),(292,220,0,1,15,4),(292,221,0,1,15,4),(292,222,0,1,15,4),(292,223,0,1,15,4),(292,224,0,1,15,4),(293,225,0,1,15,4),(293,226,0,1,15,4),(293,227,0,1,15,4),(293,228,0,1,15,4),(293,229,0,1,15,4),(293,230,0,1,15,4),(293,231,0,1,15,4),(293,232,0,1,15,4),(293,255,0,1,15,4),(293,259,0,1,15,4),(293,260,0,1,15,4),(293,261,0,1,15,4),(293,262,0,1,15,4),(293,263,0,1,15,4),(294,233,0,1,15,4),(294,234,0,1,15,4),(294,235,0,1,15,4),(294,236,0,1,15,4),(294,237,0,1,15,4),(294,238,0,1,15,4),(294,239,0,1,15,4),(294,240,0,1,15,4),(294,241,0,1,15,4),(295,244,0,1,15,4),(295,246,0,1,15,4),(295,251,0,1,15,4),(295,255,0,1,15,4),(295,258,0,1,15,4),(296,251,0,1,15,4),(296,255,0,1,15,4),(296,258,0,1,15,4),(297,246,0,1,15,4),(297,255,0,1,15,4),(297,258,0,1,15,4),(298,255,0,1,15,4),(298,258,0,1,15,4),(299,251,0,1,15,4),(299,258,0,1,15,4);
/*!40000 ALTER TABLE `catalog_category_product_index_store15` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index_store15_replica`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store15_replica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store15_replica` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `IDX_7DD7C99BC8E8114A4D848016820DE2B5` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_8D43B1BEE1CA20FAB1718BAAF180DEA4` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Product Index Store15 Replica';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index_store15_replica`
--

LOCK TABLES `catalog_category_product_index_store15_replica` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index_store15_replica` DISABLE KEYS */;
INSERT INTO `catalog_category_product_index_store15_replica` VALUES (2,1,0,1,15,4),(2,2,0,1,15,4),(2,3,0,1,15,4),(2,4,0,1,15,4),(2,5,0,1,15,4),(2,6,0,1,15,4),(2,7,0,1,15,4),(2,8,0,1,15,4),(2,9,0,1,15,4),(2,10,0,1,15,4),(2,11,0,1,15,4),(2,12,0,1,15,4),(2,13,0,1,15,4),(2,14,0,1,15,4),(2,15,0,1,15,4),(2,16,0,1,15,4),(2,17,0,1,15,4),(2,18,0,1,15,4),(2,19,0,1,15,4),(2,20,0,1,15,4),(2,21,0,1,15,4),(2,22,0,1,15,4),(2,23,0,1,15,4),(2,24,0,1,15,4),(2,25,0,1,15,4),(2,26,0,1,15,4),(2,27,0,1,15,4),(2,28,0,1,15,4),(2,29,0,1,15,4),(2,30,0,1,15,4),(2,31,0,1,15,4),(2,32,0,1,15,4),(2,33,0,1,15,4),(2,34,0,1,15,4),(2,35,0,1,15,4),(2,36,0,1,15,4),(2,37,0,1,15,4),(2,38,0,1,15,4),(2,39,0,1,15,4),(2,40,0,1,15,4),(2,41,0,1,15,4),(2,42,0,1,15,4),(2,43,0,1,15,4),(2,44,0,1,15,4),(2,45,0,1,15,4),(2,46,0,1,15,4),(2,47,0,1,15,4),(2,48,0,1,15,4),(2,49,0,1,15,4),(2,50,0,1,15,4),(2,57,0,1,15,4),(2,58,0,1,15,4),(2,59,0,1,15,4),(2,60,0,1,15,4),(2,61,0,1,15,4),(2,62,0,1,15,4),(2,63,0,1,15,4),(2,64,0,1,15,4),(2,65,0,1,15,4),(2,66,0,1,15,4),(2,68,0,1,15,4),(2,69,0,1,15,4),(2,70,0,1,15,4),(2,71,0,1,15,4),(2,72,0,1,15,4),(2,73,0,1,15,4),(2,74,0,1,15,4),(2,75,0,1,15,4),(2,76,0,1,15,4),(2,77,0,1,15,4),(2,78,0,1,15,4),(2,79,0,1,15,4),(2,80,0,1,15,4),(2,81,0,1,15,4),(2,82,0,1,15,4),(2,83,0,1,15,4),(2,84,0,1,15,4),(2,85,0,1,15,4),(2,86,0,1,15,4),(2,87,0,1,15,4),(2,88,0,1,15,4),(2,89,0,1,15,4),(2,90,0,1,15,4),(2,91,0,1,15,4),(2,92,0,1,15,4),(2,93,0,1,15,4),(2,94,0,1,15,4),(2,95,0,1,15,4),(2,96,0,1,15,4),(2,97,0,1,15,4),(2,98,0,1,15,4),(2,99,0,1,15,4),(2,100,0,1,15,4),(2,101,0,1,15,4),(2,102,0,1,15,4),(2,103,0,1,15,4),(2,104,0,1,15,4),(2,105,0,1,15,4),(2,106,0,1,15,4),(2,107,0,1,15,4),(2,108,0,1,15,4),(2,109,0,1,15,4),(2,110,0,1,15,4),(2,111,0,1,15,4),(2,112,0,1,15,4),(2,113,0,1,15,4),(2,114,0,1,15,4),(2,115,0,1,15,4),(2,116,0,1,15,4),(2,117,0,1,15,4),(2,118,0,1,15,4),(2,119,0,1,15,4),(2,120,0,1,15,4),(2,121,0,1,15,4),(2,122,0,1,15,4),(2,123,0,1,15,4),(2,124,0,1,15,4),(2,125,0,1,15,4),(2,126,0,1,15,4),(2,127,0,1,15,4),(2,128,0,1,15,4),(2,129,0,1,15,4),(2,130,0,1,15,4),(2,131,0,1,15,4),(2,132,0,1,15,4),(2,133,0,1,15,4),(2,134,0,1,15,4),(2,135,0,1,15,4),(2,136,0,1,15,4),(2,137,0,1,15,4),(2,138,0,1,15,4),(2,139,0,1,15,4),(2,140,0,1,15,4),(2,141,0,1,15,4),(2,142,0,1,15,4),(2,143,0,1,15,4),(2,144,0,1,15,4),(2,145,0,1,15,4),(2,146,0,1,15,4),(2,147,0,1,15,4),(2,148,0,1,15,4),(2,149,0,1,15,4),(2,150,0,1,15,4),(2,151,0,1,15,4),(2,152,0,1,15,4),(2,153,0,1,15,4),(2,154,0,1,15,4),(2,155,0,1,15,4),(2,156,0,1,15,4),(2,157,0,1,15,4),(2,158,0,1,15,4),(2,159,0,1,15,4),(2,160,0,1,15,4),(2,161,0,1,15,4),(2,162,0,1,15,4),(2,163,0,1,15,4),(2,164,0,1,15,4),(2,165,0,1,15,4),(2,166,0,1,15,4),(2,167,0,1,15,4),(2,168,0,1,15,4),(2,169,0,1,15,4),(2,170,0,1,15,4),(2,171,0,1,15,4),(2,172,0,1,15,4),(2,173,0,1,15,4),(2,174,0,1,15,4),(2,175,0,1,15,4),(2,176,0,1,15,4),(2,177,0,1,15,4),(2,178,0,1,15,4),(2,179,0,1,15,4),(2,180,0,1,15,4),(2,181,0,1,15,4),(2,182,0,1,15,4),(2,183,0,1,15,4),(2,184,0,1,15,4),(2,185,0,1,15,4),(2,186,0,1,15,4),(2,187,0,1,15,4),(2,188,0,1,15,4),(2,189,0,1,15,4),(2,190,0,1,15,4),(2,191,0,1,15,4),(2,192,0,1,15,4),(2,193,0,1,15,4),(2,194,0,1,15,4),(2,195,0,1,15,4),(2,196,0,1,15,4),(2,197,0,1,15,4),(2,198,0,1,15,4),(2,199,0,1,15,4),(2,200,0,1,15,4),(2,201,0,1,15,4),(2,202,0,1,15,4),(2,203,0,1,15,4),(2,204,0,1,15,4),(2,205,0,1,15,4),(2,206,0,1,15,4),(2,207,0,1,15,4),(2,208,0,1,15,4),(2,209,0,1,15,4),(2,210,0,1,15,4),(2,211,0,1,15,4),(2,212,0,1,15,4),(2,213,0,1,15,4),(2,214,0,1,15,4),(2,215,0,1,15,4),(2,216,0,1,15,4),(2,217,0,1,15,4),(2,218,0,1,15,4),(2,219,0,1,15,4),(2,220,0,1,15,4),(2,221,0,1,15,4),(2,222,0,1,15,4),(2,223,0,1,15,4),(2,224,0,1,15,4),(2,225,0,1,15,4),(2,226,0,1,15,4),(2,227,0,1,15,4),(2,228,0,1,15,4),(2,229,0,1,15,4),(2,230,0,1,15,4),(2,231,0,1,15,4),(2,232,0,1,15,4),(2,233,0,1,15,4),(2,234,0,1,15,4),(2,235,0,1,15,4),(2,236,0,1,15,4),(2,237,0,1,15,4),(2,238,0,1,15,4),(2,239,0,1,15,4),(2,240,0,1,15,4),(2,241,0,1,15,4),(2,244,0,1,15,4),(2,246,0,1,15,4),(2,251,0,1,15,4),(2,255,0,1,15,4),(2,258,0,1,15,4),(2,259,0,1,15,4),(2,260,0,1,15,4),(2,261,0,1,15,4),(2,262,0,1,15,4),(2,263,0,1,15,4),(3,1,0,1,15,4),(3,2,0,1,15,4),(3,3,0,1,15,4),(3,4,0,1,15,4),(3,5,0,1,15,4),(3,6,0,1,15,4),(3,7,0,1,15,4),(3,8,0,1,15,4),(3,10,0,1,15,4),(3,11,0,1,15,4),(4,12,0,1,15,4),(4,13,0,1,15,4),(4,14,0,1,15,4),(4,15,0,1,15,4),(4,16,0,1,15,4),(4,17,0,1,15,4),(4,18,0,1,15,4),(4,19,0,1,15,4),(4,36,0,1,15,4),(4,37,0,1,15,4),(4,38,0,1,15,4),(4,39,0,1,15,4),(4,40,0,1,15,4),(5,95,10000,0,15,4),(5,96,10000,0,15,4),(5,97,10000,0,15,4),(5,98,10000,0,15,4),(5,99,10000,0,15,4),(5,100,10000,0,15,4),(7,101,10000,0,15,4),(7,102,10000,0,15,4),(7,103,10000,0,15,4),(7,104,10000,0,15,4),(7,105,10000,0,15,4),(7,106,10000,0,15,4),(7,107,10000,0,15,4),(7,108,10000,0,15,4),(7,109,10000,0,15,4),(7,110,10000,0,15,4),(7,111,10000,0,15,4),(7,112,10000,0,15,4),(7,21,0,1,15,4),(7,22,0,1,15,4),(7,26,0,1,15,4),(8,61,0,1,15,4),(8,62,0,1,15,4),(8,63,0,1,15,4),(8,64,0,1,15,4),(8,65,0,1,15,4),(8,66,0,1,15,4),(11,4,10000,0,15,4),(11,89,10000,0,15,4),(11,90,10000,0,15,4),(11,91,10000,0,15,4),(11,92,10000,0,15,4),(11,93,10000,0,15,4),(11,94,10000,0,15,4),(11,28,0,1,15,4),(11,29,0,1,15,4),(11,30,0,1,15,4),(11,31,0,1,15,4),(11,32,0,1,15,4),(11,33,0,1,15,4),(11,34,0,1,15,4),(11,35,0,1,15,4),(13,21,0,1,15,4),(13,24,0,1,15,4),(13,25,0,1,15,4),(13,26,0,1,15,4),(13,27,0,1,15,4),(13,41,0,1,15,4),(13,42,0,1,15,4),(13,43,0,1,15,4),(13,44,0,1,15,4),(13,45,0,1,15,4),(13,46,0,1,15,4),(13,47,0,1,15,4),(13,48,0,1,15,4),(13,49,0,1,15,4),(15,22,10000,0,15,4),(15,23,10000,0,15,4),(16,20,0,1,15,4),(16,21,0,1,15,4),(16,22,0,1,15,4),(16,23,0,1,15,4),(16,24,0,1,15,4),(16,25,0,1,15,4),(16,26,0,1,15,4),(16,27,0,1,15,4),(16,41,0,1,15,4),(16,68,0,1,15,4),(16,69,0,1,15,4),(16,70,0,1,15,4),(16,71,0,1,15,4),(16,72,0,1,15,4),(16,73,0,1,15,4),(19,6,0,1,15,4),(19,7,0,1,15,4),(19,8,0,1,15,4),(19,10,0,1,15,4),(19,11,0,1,15,4),(27,11,0,1,15,4),(29,6,0,1,15,4),(29,8,0,1,15,4),(29,10,0,1,15,4),(30,6,0,1,15,4),(30,10,0,1,15,4),(33,7,0,1,15,4),(33,8,0,1,15,4),(33,10,0,1,15,4),(33,11,0,1,15,4),(42,7,0,1,15,4),(42,8,0,1,15,4),(42,11,0,1,15,4),(78,21,0,1,15,4),(78,26,0,1,15,4),(80,21,0,1,15,4),(80,22,0,1,15,4),(80,26,0,1,15,4),(81,26,0,1,15,4),(82,26,0,1,15,4),(83,26,0,1,15,4),(96,26,0,1,15,4),(97,26,0,1,15,4),(98,21,0,1,15,4),(98,22,0,1,15,4),(98,26,0,1,15,4),(99,18,0,1,15,4),(101,14,0,1,15,4),(101,15,0,1,15,4),(101,16,0,1,15,4),(102,12,0,1,15,4),(102,13,0,1,15,4),(102,14,0,1,15,4),(102,15,0,1,15,4),(102,16,0,1,15,4),(102,17,0,1,15,4),(102,19,0,1,15,4),(102,36,0,1,15,4),(102,37,0,1,15,4),(102,38,0,1,15,4),(102,39,0,1,15,4),(102,40,0,1,15,4),(103,18,0,1,15,4),(104,18,0,1,15,4),(105,18,0,1,15,4),(106,18,0,1,15,4),(107,18,0,1,15,4),(134,23,0,1,15,4),(135,22,0,1,15,4),(137,4,0,1,15,4),(137,28,0,1,15,4),(137,31,0,1,15,4),(137,34,0,1,15,4),(137,35,0,1,15,4),(138,28,0,1,15,4),(138,30,0,1,15,4),(138,32,0,1,15,4),(138,33,0,1,15,4),(139,28,0,1,15,4),(139,30,0,1,15,4),(139,32,0,1,15,4),(139,33,0,1,15,4),(140,28,0,1,15,4),(140,30,0,1,15,4),(140,32,0,1,15,4),(140,33,0,1,15,4),(145,1,0,1,15,4),(145,2,0,1,15,4),(145,3,0,1,15,4),(145,4,0,1,15,4),(145,5,0,1,15,4),(145,6,0,1,15,4),(145,7,0,1,15,4),(145,8,0,1,15,4),(145,9,0,1,15,4),(145,10,0,1,15,4),(145,11,0,1,15,4),(145,12,0,1,15,4),(145,13,0,1,15,4),(145,14,0,1,15,4),(145,15,0,1,15,4),(145,16,0,1,15,4),(145,17,0,1,15,4),(145,18,0,1,15,4),(145,19,0,1,15,4),(145,20,0,1,15,4),(145,21,0,1,15,4),(145,22,0,1,15,4),(145,23,0,1,15,4),(145,24,0,1,15,4),(145,25,0,1,15,4),(145,26,0,1,15,4),(145,27,0,1,15,4),(145,28,0,1,15,4),(145,29,0,1,15,4),(145,30,0,1,15,4),(145,31,0,1,15,4),(145,32,0,1,15,4),(145,33,0,1,15,4),(145,34,0,1,15,4),(145,35,0,1,15,4),(145,36,0,1,15,4),(145,37,0,1,15,4),(145,38,0,1,15,4),(145,39,0,1,15,4),(145,40,0,1,15,4),(145,41,0,1,15,4),(145,42,0,1,15,4),(145,43,0,1,15,4),(149,41,0,1,15,4),(150,50,0,1,15,4),(150,57,0,1,15,4),(150,58,0,1,15,4),(150,59,0,1,15,4),(150,60,0,1,15,4),(151,61,0,1,15,4),(151,62,0,1,15,4),(151,63,0,1,15,4),(151,64,0,1,15,4),(151,65,0,1,15,4),(151,66,0,1,15,4),(152,61,0,1,15,4),(152,63,0,1,15,4),(153,61,0,1,15,4),(153,63,0,1,15,4),(153,64,0,1,15,4),(153,65,0,1,15,4),(153,66,0,1,15,4),(154,61,0,1,15,4),(154,62,0,1,15,4),(154,64,0,1,15,4),(154,66,0,1,15,4),(155,61,0,1,15,4),(155,62,0,1,15,4),(155,64,0,1,15,4),(155,65,0,1,15,4),(155,66,0,1,15,4),(156,61,0,1,15,4),(156,62,0,1,15,4),(156,63,0,1,15,4),(156,64,0,1,15,4),(156,65,0,1,15,4),(156,66,0,1,15,4),(157,61,0,1,15,4),(157,62,0,1,15,4),(157,64,0,1,15,4),(157,65,0,1,15,4),(157,66,0,1,15,4),(158,61,0,1,15,4),(158,63,0,1,15,4),(158,64,0,1,15,4),(158,65,0,1,15,4),(158,66,0,1,15,4),(159,61,0,1,15,4),(159,62,0,1,15,4),(159,63,0,1,15,4),(159,64,0,1,15,4),(159,65,0,1,15,4),(159,66,0,1,15,4),(160,41,0,1,15,4),(160,68,0,1,15,4),(160,69,0,1,15,4),(160,70,0,1,15,4),(160,72,0,1,15,4),(160,73,0,1,15,4),(161,68,0,1,15,4),(161,69,0,1,15,4),(161,70,0,1,15,4),(161,71,0,1,15,4),(161,72,0,1,15,4),(162,68,0,1,15,4),(162,69,0,1,15,4),(162,72,0,1,15,4),(164,41,0,1,15,4),(164,70,0,1,15,4),(164,73,0,1,15,4),(166,41,0,1,15,4),(166,70,0,1,15,4),(166,73,0,1,15,4),(167,68,0,1,15,4),(167,69,0,1,15,4),(167,72,0,1,15,4),(168,71,0,1,15,4),(169,70,0,1,15,4),(171,70,0,1,15,4),(172,1,10000,0,15,4),(172,2,10000,0,15,4),(172,3,10000,0,15,4),(172,4,10000,0,15,4),(172,5,10000,0,15,4),(172,6,10000,0,15,4),(172,7,10000,0,15,4),(172,8,10000,0,15,4),(172,9,10000,0,15,4),(172,10,10000,0,15,4),(172,11,10000,0,15,4),(172,12,10000,0,15,4),(172,13,10000,0,15,4),(172,14,10000,0,15,4),(172,15,10000,0,15,4),(172,16,10000,0,15,4),(172,17,10000,0,15,4),(172,18,10000,0,15,4),(172,19,10000,0,15,4),(172,20,10000,0,15,4),(172,21,10000,0,15,4),(172,22,10000,0,15,4),(172,23,10000,0,15,4),(172,24,10000,0,15,4),(172,25,10000,0,15,4),(172,26,10000,0,15,4),(172,27,10000,0,15,4),(172,28,10000,0,15,4),(172,29,10000,0,15,4),(172,30,10000,0,15,4),(173,1,0,1,15,4),(173,2,0,1,15,4),(173,3,0,1,15,4),(173,4,0,1,15,4),(173,5,0,1,15,4),(173,6,0,1,15,4),(173,7,0,1,15,4),(173,8,0,1,15,4),(173,9,0,1,15,4),(173,10,0,1,15,4),(173,11,0,1,15,4),(173,12,0,1,15,4),(173,13,0,1,15,4),(173,14,0,1,15,4),(173,15,0,1,15,4),(173,16,0,1,15,4),(173,17,0,1,15,4),(173,18,0,1,15,4),(173,19,0,1,15,4),(173,20,0,1,15,4),(173,21,0,1,15,4),(173,22,0,1,15,4),(173,23,0,1,15,4),(173,24,0,1,15,4),(173,25,0,1,15,4),(173,26,0,1,15,4),(173,27,0,1,15,4),(173,28,0,1,15,4),(173,29,0,1,15,4),(173,30,0,1,15,4),(174,1,0,1,15,4),(174,2,0,1,15,4),(174,3,0,1,15,4),(174,4,0,1,15,4),(174,5,0,1,15,4),(174,6,0,1,15,4),(174,7,0,1,15,4),(174,8,0,1,15,4),(174,9,0,1,15,4),(174,10,0,1,15,4),(174,11,0,1,15,4),(174,12,0,1,15,4),(174,13,0,1,15,4),(174,14,0,1,15,4),(174,15,0,1,15,4),(174,16,0,1,15,4),(174,17,0,1,15,4),(174,18,0,1,15,4),(174,19,0,1,15,4),(174,20,0,1,15,4),(174,21,0,1,15,4),(174,22,0,1,15,4),(174,23,0,1,15,4),(174,24,0,1,15,4),(174,25,0,1,15,4),(174,26,0,1,15,4),(174,27,0,1,15,4),(174,28,0,1,15,4),(174,29,0,1,15,4),(174,30,0,1,15,4),(175,1,0,1,15,4),(175,2,0,1,15,4),(175,3,0,1,15,4),(175,4,0,1,15,4),(175,5,0,1,15,4),(175,6,0,1,15,4),(175,7,0,1,15,4),(175,8,0,1,15,4),(175,9,0,1,15,4),(175,10,0,1,15,4),(175,11,0,1,15,4),(175,12,0,1,15,4),(175,13,0,1,15,4),(175,14,0,1,15,4),(175,15,0,1,15,4),(175,16,0,1,15,4),(175,17,0,1,15,4),(175,18,0,1,15,4),(175,19,0,1,15,4),(175,20,0,1,15,4),(175,21,0,1,15,4),(175,22,0,1,15,4),(175,23,0,1,15,4),(175,24,0,1,15,4),(175,25,0,1,15,4),(175,26,0,1,15,4),(175,27,0,1,15,4),(175,28,0,1,15,4),(175,29,0,1,15,4),(175,30,0,1,15,4),(176,1,0,1,15,4),(176,2,0,1,15,4),(176,3,0,1,15,4),(176,4,0,1,15,4),(176,5,0,1,15,4),(176,6,0,1,15,4),(176,7,0,1,15,4),(176,8,0,1,15,4),(176,9,0,1,15,4),(176,10,0,1,15,4),(176,11,0,1,15,4),(176,12,0,1,15,4),(176,13,0,1,15,4),(176,14,0,1,15,4),(176,15,0,1,15,4),(176,16,0,1,15,4),(176,17,0,1,15,4),(176,18,0,1,15,4),(176,19,0,1,15,4),(176,20,0,1,15,4),(176,21,0,1,15,4),(176,22,0,1,15,4),(176,23,0,1,15,4),(176,24,0,1,15,4),(176,25,0,1,15,4),(176,26,0,1,15,4),(176,27,0,1,15,4),(176,28,0,1,15,4),(176,29,0,1,15,4),(176,30,0,1,15,4),(177,74,0,1,15,4),(177,75,0,1,15,4),(177,76,0,1,15,4),(177,77,0,1,15,4),(177,78,0,1,15,4),(177,79,0,1,15,4),(177,80,0,1,15,4),(178,74,10000,0,15,4),(178,75,10000,0,15,4),(178,76,10000,0,15,4),(178,77,10000,0,15,4),(178,78,10000,0,15,4),(178,79,10000,0,15,4),(178,80,10000,0,15,4),(178,81,10000,0,15,4),(178,82,10000,0,15,4),(178,83,10000,0,15,4),(178,84,10000,0,15,4),(178,85,10000,0,15,4),(178,86,10000,0,15,4),(178,87,10000,0,15,4),(178,88,10000,0,15,4),(178,113,10000,0,15,4),(178,114,10000,0,15,4),(178,115,10000,0,15,4),(178,116,10000,0,15,4),(178,117,10000,0,15,4),(178,118,10000,0,15,4),(178,119,10000,0,15,4),(178,120,10000,0,15,4),(178,121,10000,0,15,4),(178,122,10000,0,15,4),(178,123,10000,0,15,4),(178,124,10000,0,15,4),(178,125,10000,0,15,4),(178,126,10000,0,15,4),(178,127,10000,0,15,4),(178,128,10000,0,15,4),(178,129,10000,0,15,4),(178,130,10000,0,15,4),(178,131,10000,0,15,4),(178,132,10000,0,15,4),(178,133,10000,0,15,4),(178,134,10000,0,15,4),(178,135,10000,0,15,4),(178,136,10000,0,15,4),(178,137,10000,0,15,4),(178,138,10000,0,15,4),(178,139,10000,0,15,4),(178,140,10000,0,15,4),(178,141,10000,0,15,4),(178,142,10000,0,15,4),(178,143,10000,0,15,4),(178,144,10000,0,15,4),(178,145,10000,0,15,4),(178,146,10000,0,15,4),(178,147,10000,0,15,4),(178,148,10000,0,15,4),(178,149,10000,0,15,4),(178,150,10000,0,15,4),(178,151,10000,0,15,4),(178,152,10000,0,15,4),(178,153,10000,0,15,4),(178,154,10000,0,15,4),(178,155,10000,0,15,4),(178,156,10000,0,15,4),(178,157,10000,0,15,4),(178,158,10000,0,15,4),(178,159,10000,0,15,4),(178,160,10000,0,15,4),(178,161,10000,0,15,4),(178,162,10000,0,15,4),(178,163,10000,0,15,4),(178,164,10000,0,15,4),(178,165,10000,0,15,4),(178,166,10000,0,15,4),(178,167,10000,0,15,4),(178,168,10000,0,15,4),(178,169,10000,0,15,4),(178,170,10000,0,15,4),(178,171,10000,0,15,4),(178,172,10000,0,15,4),(178,173,10000,0,15,4),(178,174,10000,0,15,4),(178,175,10000,0,15,4),(178,176,10000,0,15,4),(178,177,10000,0,15,4),(178,178,10000,0,15,4),(178,179,10000,0,15,4),(178,180,10000,0,15,4),(178,181,10000,0,15,4),(178,182,10000,0,15,4),(178,183,10000,0,15,4),(178,184,10000,0,15,4),(178,185,10000,0,15,4),(178,186,10000,0,15,4),(178,187,10000,0,15,4),(178,188,10000,0,15,4),(178,189,10000,0,15,4),(178,190,10000,0,15,4),(178,191,10000,0,15,4),(178,192,10000,0,15,4),(178,193,10000,0,15,4),(178,194,10000,0,15,4),(178,195,10000,0,15,4),(178,196,10000,0,15,4),(178,197,10000,0,15,4),(178,198,10000,0,15,4),(178,199,10000,0,15,4),(178,200,10000,0,15,4),(178,201,10000,0,15,4),(178,202,10000,0,15,4),(178,203,10000,0,15,4),(178,204,10000,0,15,4),(178,205,10000,0,15,4),(178,206,10000,0,15,4),(178,207,10000,0,15,4),(178,208,10000,0,15,4),(178,209,10000,0,15,4),(178,210,10000,0,15,4),(178,211,10000,0,15,4),(178,212,10000,0,15,4),(178,213,10000,0,15,4),(178,214,10000,0,15,4),(178,215,10000,0,15,4),(178,216,10000,0,15,4),(178,217,10000,0,15,4),(178,218,10000,0,15,4),(178,219,10000,0,15,4),(178,220,10000,0,15,4),(178,221,10000,0,15,4),(178,222,10000,0,15,4),(178,223,10000,0,15,4),(178,224,10000,0,15,4),(178,225,10000,0,15,4),(178,226,10000,0,15,4),(178,227,10000,0,15,4),(178,228,10000,0,15,4),(178,229,10000,0,15,4),(178,230,10000,0,15,4),(178,231,10000,0,15,4),(178,232,10000,0,15,4),(178,233,10000,0,15,4),(178,234,10000,0,15,4),(178,235,10000,0,15,4),(178,236,10000,0,15,4),(178,237,10000,0,15,4),(178,238,10000,0,15,4),(178,239,10000,0,15,4),(178,240,10000,0,15,4),(178,241,10000,0,15,4),(178,244,10000,0,15,4),(178,246,10000,0,15,4),(178,251,10000,0,15,4),(178,255,10000,0,15,4),(178,258,10000,0,15,4),(178,259,10000,0,15,4),(178,260,10000,0,15,4),(178,261,10000,0,15,4),(178,262,10000,0,15,4),(178,263,10000,0,15,4),(179,81,0,1,15,4),(179,82,0,1,15,4),(179,83,0,1,15,4),(179,84,0,1,15,4),(179,85,0,1,15,4),(179,86,0,1,15,4),(179,87,0,1,15,4),(179,88,0,1,15,4),(180,81,0,1,15,4),(181,86,0,1,15,4),(182,82,0,1,15,4),(182,83,0,1,15,4),(182,84,0,1,15,4),(182,85,0,1,15,4),(182,87,0,1,15,4),(182,88,0,1,15,4),(183,82,0,1,15,4),(183,83,0,1,15,4),(183,84,0,1,15,4),(183,85,0,1,15,4),(183,86,0,1,15,4),(183,87,0,1,15,4),(183,88,0,1,15,4),(192,89,0,1,15,4),(192,90,0,1,15,4),(192,91,0,1,15,4),(192,92,0,1,15,4),(192,93,0,1,15,4),(192,94,0,1,15,4),(193,95,0,1,15,4),(193,96,0,1,15,4),(193,97,0,1,15,4),(193,98,0,1,15,4),(193,99,0,1,15,4),(193,100,0,1,15,4),(194,95,0,1,15,4),(194,96,0,1,15,4),(194,97,0,1,15,4),(194,98,0,1,15,4),(194,99,0,1,15,4),(194,100,0,1,15,4),(195,95,0,1,15,4),(195,96,0,1,15,4),(195,97,0,1,15,4),(195,98,0,1,15,4),(195,99,0,1,15,4),(195,100,0,1,15,4),(196,95,0,1,15,4),(196,96,0,1,15,4),(196,97,0,1,15,4),(196,98,0,1,15,4),(196,99,0,1,15,4),(196,100,0,1,15,4),(197,95,0,1,15,4),(197,96,0,1,15,4),(197,97,0,1,15,4),(197,98,0,1,15,4),(197,99,0,1,15,4),(197,100,0,1,15,4),(198,101,0,1,15,4),(198,109,0,1,15,4),(198,111,0,1,15,4),(198,112,0,1,15,4),(199,103,0,1,15,4),(199,110,0,1,15,4),(200,101,0,1,15,4),(200,102,0,1,15,4),(200,108,0,1,15,4),(201,104,0,1,15,4),(201,106,0,1,15,4),(202,101,0,1,15,4),(202,102,0,1,15,4),(202,103,0,1,15,4),(202,105,0,1,15,4),(202,107,0,1,15,4),(202,108,0,1,15,4),(202,110,0,1,15,4),(203,101,0,1,15,4),(203,102,0,1,15,4),(203,103,0,1,15,4),(203,104,0,1,15,4),(203,106,0,1,15,4),(203,108,0,1,15,4),(203,109,0,1,15,4),(204,101,0,1,15,4),(204,102,0,1,15,4),(204,103,0,1,15,4),(204,104,0,1,15,4),(204,105,0,1,15,4),(204,106,0,1,15,4),(204,107,0,1,15,4),(204,108,0,1,15,4),(205,101,0,1,15,4),(205,102,0,1,15,4),(205,103,0,1,15,4),(205,108,0,1,15,4),(205,109,0,1,15,4),(205,110,0,1,15,4),(205,111,0,1,15,4),(205,112,0,1,15,4),(206,113,10000,0,15,4),(206,114,10000,0,15,4),(206,115,10000,0,15,4),(206,116,10000,0,15,4),(206,117,10000,0,15,4),(206,118,10000,0,15,4),(206,119,10000,0,15,4),(207,114,0,1,15,4),(207,119,0,1,15,4),(209,114,0,1,15,4),(212,116,0,1,15,4),(212,118,0,1,15,4),(213,113,0,1,15,4),(218,117,0,1,15,4),(219,119,0,1,15,4),(220,119,0,1,15,4),(221,119,0,1,15,4),(222,114,0,1,15,4),(222,119,0,1,15,4),(223,114,0,1,15,4),(223,119,0,1,15,4),(229,113,0,1,15,4),(230,113,0,1,15,4),(231,113,0,1,15,4),(232,113,0,1,15,4),(233,113,0,1,15,4),(234,116,0,1,15,4),(234,118,0,1,15,4),(235,116,0,1,15,4),(235,118,0,1,15,4),(236,116,0,1,15,4),(236,118,0,1,15,4),(237,116,0,1,15,4),(237,118,0,1,15,4),(238,116,0,1,15,4),(238,118,0,1,15,4),(239,115,0,1,15,4),(241,115,0,1,15,4),(242,115,0,1,15,4),(243,115,0,1,15,4),(250,120,0,1,15,4),(250,121,0,1,15,4),(250,122,0,1,15,4),(250,123,0,1,15,4),(250,124,0,1,15,4),(250,125,0,1,15,4),(250,126,0,1,15,4),(250,127,0,1,15,4),(250,128,0,1,15,4),(250,129,0,1,15,4),(250,130,0,1,15,4),(250,131,0,1,15,4),(251,120,0,1,15,4),(251,121,0,1,15,4),(251,122,0,1,15,4),(251,123,0,1,15,4),(251,124,0,1,15,4),(251,125,0,1,15,4),(251,126,0,1,15,4),(251,127,0,1,15,4),(251,128,0,1,15,4),(251,129,0,1,15,4),(251,130,0,1,15,4),(251,131,0,1,15,4),(252,125,10000,0,15,4),(252,126,10000,0,15,4),(252,127,10000,0,15,4),(252,120,0,1,15,4),(252,121,0,1,15,4),(252,122,0,1,15,4),(252,123,0,1,15,4),(252,124,0,1,15,4),(252,128,0,1,15,4),(252,129,0,1,15,4),(252,131,0,1,15,4),(253,120,0,1,15,4),(253,121,0,1,15,4),(253,122,0,1,15,4),(253,123,0,1,15,4),(253,124,0,1,15,4),(253,125,0,1,15,4),(253,126,0,1,15,4),(253,127,0,1,15,4),(253,128,0,1,15,4),(253,129,0,1,15,4),(253,130,0,1,15,4),(253,131,0,1,15,4),(254,120,0,1,15,4),(254,121,0,1,15,4),(254,122,0,1,15,4),(254,123,0,1,15,4),(254,124,0,1,15,4),(254,125,0,1,15,4),(254,126,0,1,15,4),(254,127,0,1,15,4),(254,128,0,1,15,4),(254,129,0,1,15,4),(254,130,0,1,15,4),(254,131,0,1,15,4),(255,122,0,1,15,4),(255,123,0,1,15,4),(255,124,0,1,15,4),(255,125,0,1,15,4),(255,126,0,1,15,4),(255,129,0,1,15,4),(256,121,0,1,15,4),(256,122,0,1,15,4),(256,123,0,1,15,4),(256,125,0,1,15,4),(256,126,0,1,15,4),(256,127,0,1,15,4),(257,121,0,1,15,4),(257,122,0,1,15,4),(257,123,0,1,15,4),(257,125,0,1,15,4),(257,127,0,1,15,4),(257,129,0,1,15,4),(258,121,0,1,15,4),(258,122,0,1,15,4),(258,125,0,1,15,4),(258,126,0,1,15,4),(258,127,0,1,15,4),(258,129,0,1,15,4),(259,120,0,1,15,4),(259,121,0,1,15,4),(259,123,0,1,15,4),(259,128,0,1,15,4),(259,129,0,1,15,4),(260,120,0,1,15,4),(260,121,0,1,15,4),(260,122,0,1,15,4),(260,123,0,1,15,4),(260,125,0,1,15,4),(260,127,0,1,15,4),(260,128,0,1,15,4),(260,129,0,1,15,4),(261,121,0,1,15,4),(261,122,0,1,15,4),(261,125,0,1,15,4),(261,126,0,1,15,4),(261,127,0,1,15,4),(261,129,0,1,15,4),(262,125,0,1,15,4),(262,126,0,1,15,4),(263,120,0,1,15,4),(263,121,0,1,15,4),(263,122,0,1,15,4),(263,123,0,1,15,4),(263,124,0,1,15,4),(263,128,0,1,15,4),(263,129,0,1,15,4),(263,131,0,1,15,4),(264,120,0,1,15,4),(264,122,0,1,15,4),(264,123,0,1,15,4),(264,125,0,1,15,4),(264,126,0,1,15,4),(264,129,0,1,15,4),(265,121,0,1,15,4),(265,122,0,1,15,4),(265,123,0,1,15,4),(265,127,0,1,15,4),(266,123,0,1,15,4),(266,125,0,1,15,4),(266,126,0,1,15,4),(266,127,0,1,15,4),(266,129,0,1,15,4),(267,121,0,1,15,4),(267,125,0,1,15,4),(267,126,0,1,15,4),(267,127,0,1,15,4),(268,120,0,1,15,4),(268,121,0,1,15,4),(268,122,0,1,15,4),(268,123,0,1,15,4),(268,124,0,1,15,4),(268,127,0,1,15,4),(268,129,0,1,15,4),(269,122,0,1,15,4),(269,125,0,1,15,4),(269,126,0,1,15,4),(269,127,0,1,15,4),(269,129,0,1,15,4),(270,121,0,1,15,4),(270,123,0,1,15,4),(270,125,0,1,15,4),(270,126,0,1,15,4),(270,129,0,1,15,4),(271,120,0,1,15,4),(271,121,0,1,15,4),(271,122,0,1,15,4),(271,125,0,1,15,4),(271,126,0,1,15,4),(271,127,0,1,15,4),(271,129,0,1,15,4),(272,122,0,1,15,4),(272,123,0,1,15,4),(272,124,0,1,15,4),(272,125,0,1,15,4),(272,126,0,1,15,4),(272,127,0,1,15,4),(272,128,0,1,15,4),(272,129,0,1,15,4),(273,120,0,1,15,4),(273,121,0,1,15,4),(273,123,0,1,15,4),(273,126,0,1,15,4),(273,127,0,1,15,4),(274,122,0,1,15,4),(274,123,0,1,15,4),(274,125,0,1,15,4),(274,126,0,1,15,4),(274,129,0,1,15,4),(275,120,0,1,15,4),(275,121,0,1,15,4),(275,122,0,1,15,4),(275,123,0,1,15,4),(275,124,0,1,15,4),(275,125,0,1,15,4),(275,126,0,1,15,4),(275,127,0,1,15,4),(275,128,0,1,15,4),(275,129,0,1,15,4),(275,130,0,1,15,4),(275,131,0,1,15,4),(276,122,0,1,15,4),(276,123,0,1,15,4),(276,127,0,1,15,4),(276,129,0,1,15,4),(277,120,0,1,15,4),(277,121,0,1,15,4),(277,123,0,1,15,4),(277,124,0,1,15,4),(277,125,0,1,15,4),(277,126,0,1,15,4),(277,127,0,1,15,4),(278,120,0,1,15,4),(278,121,0,1,15,4),(278,122,0,1,15,4),(278,123,0,1,15,4),(278,124,0,1,15,4),(278,125,0,1,15,4),(278,127,0,1,15,4),(278,128,0,1,15,4),(278,129,0,1,15,4),(279,120,0,1,15,4),(279,122,0,1,15,4),(279,126,0,1,15,4),(279,127,0,1,15,4),(279,129,0,1,15,4),(280,132,0,1,15,4),(280,133,0,1,15,4),(280,134,0,1,15,4),(280,135,0,1,15,4),(280,136,0,1,15,4),(280,137,0,1,15,4),(280,138,0,1,15,4),(280,139,0,1,15,4),(282,132,0,1,15,4),(282,133,0,1,15,4),(282,134,0,1,15,4),(282,137,0,1,15,4),(282,138,0,1,15,4),(283,135,0,1,15,4),(283,136,0,1,15,4),(283,139,0,1,15,4),(286,140,0,1,15,4),(286,141,0,1,15,4),(286,142,0,1,15,4),(286,143,0,1,15,4),(286,144,0,1,15,4),(286,145,0,1,15,4),(286,146,0,1,15,4),(286,147,0,1,15,4),(286,148,0,1,15,4),(286,149,0,1,15,4),(286,150,0,1,15,4),(286,151,0,1,15,4),(286,152,0,1,15,4),(286,153,0,1,15,4),(286,154,0,1,15,4),(286,155,0,1,15,4),(286,156,0,1,15,4),(286,157,0,1,15,4),(286,158,0,1,15,4),(286,159,0,1,15,4),(286,160,0,1,15,4),(286,161,0,1,15,4),(286,162,0,1,15,4),(286,163,0,1,15,4),(286,164,0,1,15,4),(286,165,0,1,15,4),(286,166,0,1,15,4),(286,167,0,1,15,4),(286,168,0,1,15,4),(286,169,0,1,15,4),(286,170,0,1,15,4),(286,171,0,1,15,4),(286,172,0,1,15,4),(286,173,0,1,15,4),(286,174,0,1,15,4),(286,175,0,1,15,4),(286,176,0,1,15,4),(286,177,0,1,15,4),(286,178,0,1,15,4),(286,179,0,1,15,4),(286,180,0,1,15,4),(286,181,0,1,15,4),(286,182,0,1,15,4),(286,183,0,1,15,4),(286,184,0,1,15,4),(286,185,0,1,15,4),(286,186,0,1,15,4),(286,187,0,1,15,4),(287,188,0,1,15,4),(288,189,0,1,15,4),(288,190,0,1,15,4),(288,191,0,1,15,4),(288,192,0,1,15,4),(288,193,0,1,15,4),(288,194,0,1,15,4),(288,195,0,1,15,4),(288,196,0,1,15,4),(288,197,0,1,15,4),(288,198,0,1,15,4),(288,199,0,1,15,4),(288,200,0,1,15,4),(289,201,10000,0,15,4),(289,202,10000,0,15,4),(289,203,10000,0,15,4),(289,204,10000,0,15,4),(289,205,10000,0,15,4),(289,206,10000,0,15,4),(289,207,10000,0,15,4),(289,208,10000,0,15,4),(289,209,10000,0,15,4),(289,210,10000,0,15,4),(289,211,10000,0,15,4),(289,212,10000,0,15,4),(289,213,10000,0,15,4),(289,214,10000,0,15,4),(289,215,10000,0,15,4),(289,216,10000,0,15,4),(289,217,10000,0,15,4),(289,218,10000,0,15,4),(289,219,10000,0,15,4),(289,220,10000,0,15,4),(289,221,10000,0,15,4),(289,222,10000,0,15,4),(289,223,10000,0,15,4),(289,224,10000,0,15,4),(289,225,10000,0,15,4),(289,226,10000,0,15,4),(289,227,10000,0,15,4),(289,228,10000,0,15,4),(289,229,10000,0,15,4),(289,230,10000,0,15,4),(289,231,10000,0,15,4),(289,232,10000,0,15,4),(289,244,10000,0,15,4),(289,246,10000,0,15,4),(289,251,10000,0,15,4),(289,255,10000,0,15,4),(289,258,10000,0,15,4),(289,259,10000,0,15,4),(289,260,10000,0,15,4),(289,261,10000,0,15,4),(289,262,10000,0,15,4),(289,263,10000,0,15,4),(290,209,0,1,15,4),(290,210,0,1,15,4),(290,211,0,1,15,4),(290,212,0,1,15,4),(290,213,0,1,15,4),(290,214,0,1,15,4),(290,215,0,1,15,4),(290,216,0,1,15,4),(291,201,0,1,15,4),(291,202,0,1,15,4),(291,203,0,1,15,4),(291,204,0,1,15,4),(291,205,0,1,15,4),(291,206,0,1,15,4),(291,207,0,1,15,4),(291,208,0,1,15,4),(292,217,0,1,15,4),(292,218,0,1,15,4),(292,219,0,1,15,4),(292,220,0,1,15,4),(292,221,0,1,15,4),(292,222,0,1,15,4),(292,223,0,1,15,4),(292,224,0,1,15,4),(293,225,0,1,15,4),(293,226,0,1,15,4),(293,227,0,1,15,4),(293,228,0,1,15,4),(293,229,0,1,15,4),(293,230,0,1,15,4),(293,231,0,1,15,4),(293,232,0,1,15,4),(293,255,0,1,15,4),(293,259,0,1,15,4),(293,260,0,1,15,4),(293,261,0,1,15,4),(293,262,0,1,15,4),(293,263,0,1,15,4),(294,233,0,1,15,4),(294,234,0,1,15,4),(294,235,0,1,15,4),(294,236,0,1,15,4),(294,237,0,1,15,4),(294,238,0,1,15,4),(294,239,0,1,15,4),(294,240,0,1,15,4),(294,241,0,1,15,4),(295,244,0,1,15,4),(295,246,0,1,15,4),(295,251,0,1,15,4),(295,255,0,1,15,4),(295,258,0,1,15,4),(296,251,0,1,15,4),(296,255,0,1,15,4),(296,258,0,1,15,4),(297,246,0,1,15,4),(297,255,0,1,15,4),(297,258,0,1,15,4),(298,255,0,1,15,4),(298,258,0,1,15,4),(299,251,0,1,15,4),(299,258,0,1,15,4);
/*!40000 ALTER TABLE `catalog_category_product_index_store15_replica` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index_store16`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store16`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store16` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `IDX_F7BB9FC1254D6AE58303F0E99F29E8D6` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_7EAFABA0BB20986BA68F4336BB04BC06` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Product Index Store16';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index_store16`
--

LOCK TABLES `catalog_category_product_index_store16` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index_store16` DISABLE KEYS */;
INSERT INTO `catalog_category_product_index_store16` VALUES (2,1,0,1,16,4),(2,2,0,1,16,4),(2,3,0,1,16,4),(2,4,0,1,16,4),(2,5,0,1,16,4),(2,6,0,1,16,4),(2,7,0,1,16,4),(2,8,0,1,16,4),(2,9,0,1,16,4),(2,10,0,1,16,4),(2,11,0,1,16,4),(2,12,0,1,16,4),(2,13,0,1,16,4),(2,14,0,1,16,4),(2,15,0,1,16,4),(2,16,0,1,16,4),(2,17,0,1,16,4),(2,18,0,1,16,4),(2,19,0,1,16,4),(2,20,0,1,16,4),(2,21,0,1,16,4),(2,22,0,1,16,4),(2,23,0,1,16,4),(2,24,0,1,16,4),(2,25,0,1,16,4),(2,26,0,1,16,4),(2,27,0,1,16,4),(2,28,0,1,16,4),(2,29,0,1,16,4),(2,30,0,1,16,4),(2,31,0,1,16,4),(2,32,0,1,16,4),(2,33,0,1,16,4),(2,34,0,1,16,4),(2,35,0,1,16,4),(2,36,0,1,16,4),(2,37,0,1,16,4),(2,38,0,1,16,4),(2,39,0,1,16,4),(2,40,0,1,16,4),(2,41,0,1,16,4),(2,42,0,1,16,4),(2,43,0,1,16,4),(2,44,0,1,16,4),(2,45,0,1,16,4),(2,46,0,1,16,4),(2,47,0,1,16,4),(2,48,0,1,16,4),(2,49,0,1,16,4),(2,50,0,1,16,4),(2,57,0,1,16,4),(2,58,0,1,16,4),(2,59,0,1,16,4),(2,60,0,1,16,4),(2,61,0,1,16,4),(2,62,0,1,16,4),(2,63,0,1,16,4),(2,64,0,1,16,4),(2,65,0,1,16,4),(2,66,0,1,16,4),(2,68,0,1,16,4),(2,69,0,1,16,4),(2,70,0,1,16,4),(2,71,0,1,16,4),(2,72,0,1,16,4),(2,73,0,1,16,4),(2,74,0,1,16,4),(2,75,0,1,16,4),(2,76,0,1,16,4),(2,77,0,1,16,4),(2,78,0,1,16,4),(2,79,0,1,16,4),(2,80,0,1,16,4),(2,81,0,1,16,4),(2,82,0,1,16,4),(2,83,0,1,16,4),(2,84,0,1,16,4),(2,85,0,1,16,4),(2,86,0,1,16,4),(2,87,0,1,16,4),(2,88,0,1,16,4),(2,89,0,1,16,4),(2,90,0,1,16,4),(2,91,0,1,16,4),(2,92,0,1,16,4),(2,93,0,1,16,4),(2,94,0,1,16,4),(2,95,0,1,16,4),(2,96,0,1,16,4),(2,97,0,1,16,4),(2,98,0,1,16,4),(2,99,0,1,16,4),(2,100,0,1,16,4),(2,101,0,1,16,4),(2,102,0,1,16,4),(2,103,0,1,16,4),(2,104,0,1,16,4),(2,105,0,1,16,4),(2,106,0,1,16,4),(2,107,0,1,16,4),(2,108,0,1,16,4),(2,109,0,1,16,4),(2,110,0,1,16,4),(2,111,0,1,16,4),(2,112,0,1,16,4),(2,113,0,1,16,4),(2,114,0,1,16,4),(2,115,0,1,16,4),(2,116,0,1,16,4),(2,117,0,1,16,4),(2,118,0,1,16,4),(2,119,0,1,16,4),(2,120,0,1,16,4),(2,121,0,1,16,4),(2,122,0,1,16,4),(2,123,0,1,16,4),(2,124,0,1,16,4),(2,125,0,1,16,4),(2,126,0,1,16,4),(2,127,0,1,16,4),(2,128,0,1,16,4),(2,129,0,1,16,4),(2,130,0,1,16,4),(2,131,0,1,16,4),(2,132,0,1,16,4),(2,133,0,1,16,4),(2,134,0,1,16,4),(2,135,0,1,16,4),(2,136,0,1,16,4),(2,137,0,1,16,4),(2,138,0,1,16,4),(2,139,0,1,16,4),(2,140,0,1,16,4),(2,141,0,1,16,4),(2,142,0,1,16,4),(2,143,0,1,16,4),(2,144,0,1,16,4),(2,145,0,1,16,4),(2,146,0,1,16,4),(2,147,0,1,16,4),(2,148,0,1,16,4),(2,149,0,1,16,4),(2,150,0,1,16,4),(2,151,0,1,16,4),(2,152,0,1,16,4),(2,153,0,1,16,4),(2,154,0,1,16,4),(2,155,0,1,16,4),(2,156,0,1,16,4),(2,157,0,1,16,4),(2,158,0,1,16,4),(2,159,0,1,16,4),(2,160,0,1,16,4),(2,161,0,1,16,4),(2,162,0,1,16,4),(2,163,0,1,16,4),(2,164,0,1,16,4),(2,165,0,1,16,4),(2,166,0,1,16,4),(2,167,0,1,16,4),(2,168,0,1,16,4),(2,169,0,1,16,4),(2,170,0,1,16,4),(2,171,0,1,16,4),(2,172,0,1,16,4),(2,173,0,1,16,4),(2,174,0,1,16,4),(2,175,0,1,16,4),(2,176,0,1,16,4),(2,177,0,1,16,4),(2,178,0,1,16,4),(2,179,0,1,16,4),(2,180,0,1,16,4),(2,181,0,1,16,4),(2,182,0,1,16,4),(2,183,0,1,16,4),(2,184,0,1,16,4),(2,185,0,1,16,4),(2,186,0,1,16,4),(2,187,0,1,16,4),(2,188,0,1,16,4),(2,189,0,1,16,4),(2,190,0,1,16,4),(2,191,0,1,16,4),(2,192,0,1,16,4),(2,193,0,1,16,4),(2,194,0,1,16,4),(2,195,0,1,16,4),(2,196,0,1,16,4),(2,197,0,1,16,4),(2,198,0,1,16,4),(2,199,0,1,16,4),(2,200,0,1,16,4),(2,201,0,1,16,4),(2,202,0,1,16,4),(2,203,0,1,16,4),(2,204,0,1,16,4),(2,205,0,1,16,4),(2,206,0,1,16,4),(2,207,0,1,16,4),(2,208,0,1,16,4),(2,209,0,1,16,4),(2,210,0,1,16,4),(2,211,0,1,16,4),(2,212,0,1,16,4),(2,213,0,1,16,4),(2,214,0,1,16,4),(2,215,0,1,16,4),(2,216,0,1,16,4),(2,217,0,1,16,4),(2,218,0,1,16,4),(2,219,0,1,16,4),(2,220,0,1,16,4),(2,221,0,1,16,4),(2,222,0,1,16,4),(2,223,0,1,16,4),(2,224,0,1,16,4),(2,225,0,1,16,4),(2,226,0,1,16,4),(2,227,0,1,16,4),(2,228,0,1,16,4),(2,229,0,1,16,4),(2,230,0,1,16,4),(2,231,0,1,16,4),(2,232,0,1,16,4),(2,233,0,1,16,4),(2,234,0,1,16,4),(2,235,0,1,16,4),(2,236,0,1,16,4),(2,237,0,1,16,4),(2,238,0,1,16,4),(2,239,0,1,16,4),(2,240,0,1,16,4),(2,241,0,1,16,4),(2,244,0,1,16,4),(2,246,0,1,16,4),(2,251,0,1,16,4),(2,255,0,1,16,4),(2,258,0,1,16,4),(2,259,0,1,16,4),(2,260,0,1,16,4),(2,261,0,1,16,4),(2,262,0,1,16,4),(2,263,0,1,16,4),(3,1,0,1,16,4),(3,2,0,1,16,4),(3,3,0,1,16,4),(3,4,0,1,16,4),(3,5,0,1,16,4),(3,6,0,1,16,4),(3,7,0,1,16,4),(3,8,0,1,16,4),(3,10,0,1,16,4),(3,11,0,1,16,4),(4,12,0,1,16,4),(4,13,0,1,16,4),(4,14,0,1,16,4),(4,15,0,1,16,4),(4,16,0,1,16,4),(4,17,0,1,16,4),(4,18,0,1,16,4),(4,19,0,1,16,4),(4,36,0,1,16,4),(4,37,0,1,16,4),(4,38,0,1,16,4),(4,39,0,1,16,4),(4,40,0,1,16,4),(5,95,10000,0,16,4),(5,96,10000,0,16,4),(5,97,10000,0,16,4),(5,98,10000,0,16,4),(5,99,10000,0,16,4),(5,100,10000,0,16,4),(7,101,10000,0,16,4),(7,102,10000,0,16,4),(7,103,10000,0,16,4),(7,104,10000,0,16,4),(7,105,10000,0,16,4),(7,106,10000,0,16,4),(7,107,10000,0,16,4),(7,108,10000,0,16,4),(7,109,10000,0,16,4),(7,110,10000,0,16,4),(7,111,10000,0,16,4),(7,112,10000,0,16,4),(7,21,0,1,16,4),(7,22,0,1,16,4),(7,26,0,1,16,4),(8,61,0,1,16,4),(8,62,0,1,16,4),(8,63,0,1,16,4),(8,64,0,1,16,4),(8,65,0,1,16,4),(8,66,0,1,16,4),(11,4,10000,0,16,4),(11,89,10000,0,16,4),(11,90,10000,0,16,4),(11,91,10000,0,16,4),(11,92,10000,0,16,4),(11,93,10000,0,16,4),(11,94,10000,0,16,4),(11,28,0,1,16,4),(11,29,0,1,16,4),(11,30,0,1,16,4),(11,31,0,1,16,4),(11,32,0,1,16,4),(11,33,0,1,16,4),(11,34,0,1,16,4),(11,35,0,1,16,4),(13,21,0,1,16,4),(13,24,0,1,16,4),(13,25,0,1,16,4),(13,26,0,1,16,4),(13,27,0,1,16,4),(13,41,0,1,16,4),(13,42,0,1,16,4),(13,43,0,1,16,4),(13,44,0,1,16,4),(13,45,0,1,16,4),(13,46,0,1,16,4),(13,47,0,1,16,4),(13,48,0,1,16,4),(13,49,0,1,16,4),(15,22,10000,0,16,4),(15,23,10000,0,16,4),(16,20,0,1,16,4),(16,21,0,1,16,4),(16,22,0,1,16,4),(16,23,0,1,16,4),(16,24,0,1,16,4),(16,25,0,1,16,4),(16,26,0,1,16,4),(16,27,0,1,16,4),(16,41,0,1,16,4),(16,68,0,1,16,4),(16,69,0,1,16,4),(16,70,0,1,16,4),(16,71,0,1,16,4),(16,72,0,1,16,4),(16,73,0,1,16,4),(19,6,0,1,16,4),(19,7,0,1,16,4),(19,8,0,1,16,4),(19,10,0,1,16,4),(19,11,0,1,16,4),(27,11,0,1,16,4),(29,6,0,1,16,4),(29,8,0,1,16,4),(29,10,0,1,16,4),(30,6,0,1,16,4),(30,10,0,1,16,4),(33,7,0,1,16,4),(33,8,0,1,16,4),(33,10,0,1,16,4),(33,11,0,1,16,4),(42,7,0,1,16,4),(42,8,0,1,16,4),(42,11,0,1,16,4),(78,21,0,1,16,4),(78,26,0,1,16,4),(80,21,0,1,16,4),(80,22,0,1,16,4),(80,26,0,1,16,4),(81,26,0,1,16,4),(82,26,0,1,16,4),(83,26,0,1,16,4),(96,26,0,1,16,4),(97,26,0,1,16,4),(98,21,0,1,16,4),(98,22,0,1,16,4),(98,26,0,1,16,4),(99,18,0,1,16,4),(101,14,0,1,16,4),(101,15,0,1,16,4),(101,16,0,1,16,4),(102,12,0,1,16,4),(102,13,0,1,16,4),(102,14,0,1,16,4),(102,15,0,1,16,4),(102,16,0,1,16,4),(102,17,0,1,16,4),(102,19,0,1,16,4),(102,36,0,1,16,4),(102,37,0,1,16,4),(102,38,0,1,16,4),(102,39,0,1,16,4),(102,40,0,1,16,4),(103,18,0,1,16,4),(104,18,0,1,16,4),(105,18,0,1,16,4),(106,18,0,1,16,4),(107,18,0,1,16,4),(134,23,0,1,16,4),(135,22,0,1,16,4),(137,4,0,1,16,4),(137,28,0,1,16,4),(137,31,0,1,16,4),(137,34,0,1,16,4),(137,35,0,1,16,4),(138,28,0,1,16,4),(138,30,0,1,16,4),(138,32,0,1,16,4),(138,33,0,1,16,4),(139,28,0,1,16,4),(139,30,0,1,16,4),(139,32,0,1,16,4),(139,33,0,1,16,4),(140,28,0,1,16,4),(140,30,0,1,16,4),(140,32,0,1,16,4),(140,33,0,1,16,4),(145,1,0,1,16,4),(145,2,0,1,16,4),(145,3,0,1,16,4),(145,4,0,1,16,4),(145,5,0,1,16,4),(145,6,0,1,16,4),(145,7,0,1,16,4),(145,8,0,1,16,4),(145,9,0,1,16,4),(145,10,0,1,16,4),(145,11,0,1,16,4),(145,12,0,1,16,4),(145,13,0,1,16,4),(145,14,0,1,16,4),(145,15,0,1,16,4),(145,16,0,1,16,4),(145,17,0,1,16,4),(145,18,0,1,16,4),(145,19,0,1,16,4),(145,20,0,1,16,4),(145,21,0,1,16,4),(145,22,0,1,16,4),(145,23,0,1,16,4),(145,24,0,1,16,4),(145,25,0,1,16,4),(145,26,0,1,16,4),(145,27,0,1,16,4),(145,28,0,1,16,4),(145,29,0,1,16,4),(145,30,0,1,16,4),(145,31,0,1,16,4),(145,32,0,1,16,4),(145,33,0,1,16,4),(145,34,0,1,16,4),(145,35,0,1,16,4),(145,36,0,1,16,4),(145,37,0,1,16,4),(145,38,0,1,16,4),(145,39,0,1,16,4),(145,40,0,1,16,4),(145,41,0,1,16,4),(145,42,0,1,16,4),(145,43,0,1,16,4),(149,41,0,1,16,4),(150,50,0,1,16,4),(150,57,0,1,16,4),(150,58,0,1,16,4),(150,59,0,1,16,4),(150,60,0,1,16,4),(151,61,0,1,16,4),(151,62,0,1,16,4),(151,63,0,1,16,4),(151,64,0,1,16,4),(151,65,0,1,16,4),(151,66,0,1,16,4),(152,61,0,1,16,4),(152,63,0,1,16,4),(153,61,0,1,16,4),(153,63,0,1,16,4),(153,64,0,1,16,4),(153,65,0,1,16,4),(153,66,0,1,16,4),(154,61,0,1,16,4),(154,62,0,1,16,4),(154,64,0,1,16,4),(154,66,0,1,16,4),(155,61,0,1,16,4),(155,62,0,1,16,4),(155,64,0,1,16,4),(155,65,0,1,16,4),(155,66,0,1,16,4),(156,61,0,1,16,4),(156,62,0,1,16,4),(156,63,0,1,16,4),(156,64,0,1,16,4),(156,65,0,1,16,4),(156,66,0,1,16,4),(157,61,0,1,16,4),(157,62,0,1,16,4),(157,64,0,1,16,4),(157,65,0,1,16,4),(157,66,0,1,16,4),(158,61,0,1,16,4),(158,63,0,1,16,4),(158,64,0,1,16,4),(158,65,0,1,16,4),(158,66,0,1,16,4),(159,61,0,1,16,4),(159,62,0,1,16,4),(159,63,0,1,16,4),(159,64,0,1,16,4),(159,65,0,1,16,4),(159,66,0,1,16,4),(160,41,0,1,16,4),(160,68,0,1,16,4),(160,69,0,1,16,4),(160,70,0,1,16,4),(160,72,0,1,16,4),(160,73,0,1,16,4),(161,68,0,1,16,4),(161,69,0,1,16,4),(161,70,0,1,16,4),(161,71,0,1,16,4),(161,72,0,1,16,4),(162,68,0,1,16,4),(162,69,0,1,16,4),(162,72,0,1,16,4),(164,41,0,1,16,4),(164,70,0,1,16,4),(164,73,0,1,16,4),(166,41,0,1,16,4),(166,70,0,1,16,4),(166,73,0,1,16,4),(167,68,0,1,16,4),(167,69,0,1,16,4),(167,72,0,1,16,4),(168,71,0,1,16,4),(169,70,0,1,16,4),(171,70,0,1,16,4),(172,1,10000,0,16,4),(172,2,10000,0,16,4),(172,3,10000,0,16,4),(172,4,10000,0,16,4),(172,5,10000,0,16,4),(172,6,10000,0,16,4),(172,7,10000,0,16,4),(172,8,10000,0,16,4),(172,9,10000,0,16,4),(172,10,10000,0,16,4),(172,11,10000,0,16,4),(172,12,10000,0,16,4),(172,13,10000,0,16,4),(172,14,10000,0,16,4),(172,15,10000,0,16,4),(172,16,10000,0,16,4),(172,17,10000,0,16,4),(172,18,10000,0,16,4),(172,19,10000,0,16,4),(172,20,10000,0,16,4),(172,21,10000,0,16,4),(172,22,10000,0,16,4),(172,23,10000,0,16,4),(172,24,10000,0,16,4),(172,25,10000,0,16,4),(172,26,10000,0,16,4),(172,27,10000,0,16,4),(172,28,10000,0,16,4),(172,29,10000,0,16,4),(172,30,10000,0,16,4),(173,1,0,1,16,4),(173,2,0,1,16,4),(173,3,0,1,16,4),(173,4,0,1,16,4),(173,5,0,1,16,4),(173,6,0,1,16,4),(173,7,0,1,16,4),(173,8,0,1,16,4),(173,9,0,1,16,4),(173,10,0,1,16,4),(173,11,0,1,16,4),(173,12,0,1,16,4),(173,13,0,1,16,4),(173,14,0,1,16,4),(173,15,0,1,16,4),(173,16,0,1,16,4),(173,17,0,1,16,4),(173,18,0,1,16,4),(173,19,0,1,16,4),(173,20,0,1,16,4),(173,21,0,1,16,4),(173,22,0,1,16,4),(173,23,0,1,16,4),(173,24,0,1,16,4),(173,25,0,1,16,4),(173,26,0,1,16,4),(173,27,0,1,16,4),(173,28,0,1,16,4),(173,29,0,1,16,4),(173,30,0,1,16,4),(174,1,0,1,16,4),(174,2,0,1,16,4),(174,3,0,1,16,4),(174,4,0,1,16,4),(174,5,0,1,16,4),(174,6,0,1,16,4),(174,7,0,1,16,4),(174,8,0,1,16,4),(174,9,0,1,16,4),(174,10,0,1,16,4),(174,11,0,1,16,4),(174,12,0,1,16,4),(174,13,0,1,16,4),(174,14,0,1,16,4),(174,15,0,1,16,4),(174,16,0,1,16,4),(174,17,0,1,16,4),(174,18,0,1,16,4),(174,19,0,1,16,4),(174,20,0,1,16,4),(174,21,0,1,16,4),(174,22,0,1,16,4),(174,23,0,1,16,4),(174,24,0,1,16,4),(174,25,0,1,16,4),(174,26,0,1,16,4),(174,27,0,1,16,4),(174,28,0,1,16,4),(174,29,0,1,16,4),(174,30,0,1,16,4),(175,1,0,1,16,4),(175,2,0,1,16,4),(175,3,0,1,16,4),(175,4,0,1,16,4),(175,5,0,1,16,4),(175,6,0,1,16,4),(175,7,0,1,16,4),(175,8,0,1,16,4),(175,9,0,1,16,4),(175,10,0,1,16,4),(175,11,0,1,16,4),(175,12,0,1,16,4),(175,13,0,1,16,4),(175,14,0,1,16,4),(175,15,0,1,16,4),(175,16,0,1,16,4),(175,17,0,1,16,4),(175,18,0,1,16,4),(175,19,0,1,16,4),(175,20,0,1,16,4),(175,21,0,1,16,4),(175,22,0,1,16,4),(175,23,0,1,16,4),(175,24,0,1,16,4),(175,25,0,1,16,4),(175,26,0,1,16,4),(175,27,0,1,16,4),(175,28,0,1,16,4),(175,29,0,1,16,4),(175,30,0,1,16,4),(176,1,0,1,16,4),(176,2,0,1,16,4),(176,3,0,1,16,4),(176,4,0,1,16,4),(176,5,0,1,16,4),(176,6,0,1,16,4),(176,7,0,1,16,4),(176,8,0,1,16,4),(176,9,0,1,16,4),(176,10,0,1,16,4),(176,11,0,1,16,4),(176,12,0,1,16,4),(176,13,0,1,16,4),(176,14,0,1,16,4),(176,15,0,1,16,4),(176,16,0,1,16,4),(176,17,0,1,16,4),(176,18,0,1,16,4),(176,19,0,1,16,4),(176,20,0,1,16,4),(176,21,0,1,16,4),(176,22,0,1,16,4),(176,23,0,1,16,4),(176,24,0,1,16,4),(176,25,0,1,16,4),(176,26,0,1,16,4),(176,27,0,1,16,4),(176,28,0,1,16,4),(176,29,0,1,16,4),(176,30,0,1,16,4),(177,74,0,1,16,4),(177,75,0,1,16,4),(177,76,0,1,16,4),(177,77,0,1,16,4),(177,78,0,1,16,4),(177,79,0,1,16,4),(177,80,0,1,16,4),(178,74,10000,0,16,4),(178,75,10000,0,16,4),(178,76,10000,0,16,4),(178,77,10000,0,16,4),(178,78,10000,0,16,4),(178,79,10000,0,16,4),(178,80,10000,0,16,4),(178,81,10000,0,16,4),(178,82,10000,0,16,4),(178,83,10000,0,16,4),(178,84,10000,0,16,4),(178,85,10000,0,16,4),(178,86,10000,0,16,4),(178,87,10000,0,16,4),(178,88,10000,0,16,4),(178,113,10000,0,16,4),(178,114,10000,0,16,4),(178,115,10000,0,16,4),(178,116,10000,0,16,4),(178,117,10000,0,16,4),(178,118,10000,0,16,4),(178,119,10000,0,16,4),(178,120,10000,0,16,4),(178,121,10000,0,16,4),(178,122,10000,0,16,4),(178,123,10000,0,16,4),(178,124,10000,0,16,4),(178,125,10000,0,16,4),(178,126,10000,0,16,4),(178,127,10000,0,16,4),(178,128,10000,0,16,4),(178,129,10000,0,16,4),(178,130,10000,0,16,4),(178,131,10000,0,16,4),(178,132,10000,0,16,4),(178,133,10000,0,16,4),(178,134,10000,0,16,4),(178,135,10000,0,16,4),(178,136,10000,0,16,4),(178,137,10000,0,16,4),(178,138,10000,0,16,4),(178,139,10000,0,16,4),(178,140,10000,0,16,4),(178,141,10000,0,16,4),(178,142,10000,0,16,4),(178,143,10000,0,16,4),(178,144,10000,0,16,4),(178,145,10000,0,16,4),(178,146,10000,0,16,4),(178,147,10000,0,16,4),(178,148,10000,0,16,4),(178,149,10000,0,16,4),(178,150,10000,0,16,4),(178,151,10000,0,16,4),(178,152,10000,0,16,4),(178,153,10000,0,16,4),(178,154,10000,0,16,4),(178,155,10000,0,16,4),(178,156,10000,0,16,4),(178,157,10000,0,16,4),(178,158,10000,0,16,4),(178,159,10000,0,16,4),(178,160,10000,0,16,4),(178,161,10000,0,16,4),(178,162,10000,0,16,4),(178,163,10000,0,16,4),(178,164,10000,0,16,4),(178,165,10000,0,16,4),(178,166,10000,0,16,4),(178,167,10000,0,16,4),(178,168,10000,0,16,4),(178,169,10000,0,16,4),(178,170,10000,0,16,4),(178,171,10000,0,16,4),(178,172,10000,0,16,4),(178,173,10000,0,16,4),(178,174,10000,0,16,4),(178,175,10000,0,16,4),(178,176,10000,0,16,4),(178,177,10000,0,16,4),(178,178,10000,0,16,4),(178,179,10000,0,16,4),(178,180,10000,0,16,4),(178,181,10000,0,16,4),(178,182,10000,0,16,4),(178,183,10000,0,16,4),(178,184,10000,0,16,4),(178,185,10000,0,16,4),(178,186,10000,0,16,4),(178,187,10000,0,16,4),(178,188,10000,0,16,4),(178,189,10000,0,16,4),(178,190,10000,0,16,4),(178,191,10000,0,16,4),(178,192,10000,0,16,4),(178,193,10000,0,16,4),(178,194,10000,0,16,4),(178,195,10000,0,16,4),(178,196,10000,0,16,4),(178,197,10000,0,16,4),(178,198,10000,0,16,4),(178,199,10000,0,16,4),(178,200,10000,0,16,4),(178,201,10000,0,16,4),(178,202,10000,0,16,4),(178,203,10000,0,16,4),(178,204,10000,0,16,4),(178,205,10000,0,16,4),(178,206,10000,0,16,4),(178,207,10000,0,16,4),(178,208,10000,0,16,4),(178,209,10000,0,16,4),(178,210,10000,0,16,4),(178,211,10000,0,16,4),(178,212,10000,0,16,4),(178,213,10000,0,16,4),(178,214,10000,0,16,4),(178,215,10000,0,16,4),(178,216,10000,0,16,4),(178,217,10000,0,16,4),(178,218,10000,0,16,4),(178,219,10000,0,16,4),(178,220,10000,0,16,4),(178,221,10000,0,16,4),(178,222,10000,0,16,4),(178,223,10000,0,16,4),(178,224,10000,0,16,4),(178,225,10000,0,16,4),(178,226,10000,0,16,4),(178,227,10000,0,16,4),(178,228,10000,0,16,4),(178,229,10000,0,16,4),(178,230,10000,0,16,4),(178,231,10000,0,16,4),(178,232,10000,0,16,4),(178,233,10000,0,16,4),(178,234,10000,0,16,4),(178,235,10000,0,16,4),(178,236,10000,0,16,4),(178,237,10000,0,16,4),(178,238,10000,0,16,4),(178,239,10000,0,16,4),(178,240,10000,0,16,4),(178,241,10000,0,16,4),(178,244,10000,0,16,4),(178,246,10000,0,16,4),(178,251,10000,0,16,4),(178,255,10000,0,16,4),(178,258,10000,0,16,4),(178,259,10000,0,16,4),(178,260,10000,0,16,4),(178,261,10000,0,16,4),(178,262,10000,0,16,4),(178,263,10000,0,16,4),(179,81,0,1,16,4),(179,82,0,1,16,4),(179,83,0,1,16,4),(179,84,0,1,16,4),(179,85,0,1,16,4),(179,86,0,1,16,4),(179,87,0,1,16,4),(179,88,0,1,16,4),(180,81,0,1,16,4),(181,86,0,1,16,4),(182,82,0,1,16,4),(182,83,0,1,16,4),(182,84,0,1,16,4),(182,85,0,1,16,4),(182,87,0,1,16,4),(182,88,0,1,16,4),(183,82,0,1,16,4),(183,83,0,1,16,4),(183,84,0,1,16,4),(183,85,0,1,16,4),(183,86,0,1,16,4),(183,87,0,1,16,4),(183,88,0,1,16,4),(192,89,0,1,16,4),(192,90,0,1,16,4),(192,91,0,1,16,4),(192,92,0,1,16,4),(192,93,0,1,16,4),(192,94,0,1,16,4),(193,95,0,1,16,4),(193,96,0,1,16,4),(193,97,0,1,16,4),(193,98,0,1,16,4),(193,99,0,1,16,4),(193,100,0,1,16,4),(194,95,0,1,16,4),(194,96,0,1,16,4),(194,97,0,1,16,4),(194,98,0,1,16,4),(194,99,0,1,16,4),(194,100,0,1,16,4),(195,95,0,1,16,4),(195,96,0,1,16,4),(195,97,0,1,16,4),(195,98,0,1,16,4),(195,99,0,1,16,4),(195,100,0,1,16,4),(196,95,0,1,16,4),(196,96,0,1,16,4),(196,97,0,1,16,4),(196,98,0,1,16,4),(196,99,0,1,16,4),(196,100,0,1,16,4),(197,95,0,1,16,4),(197,96,0,1,16,4),(197,97,0,1,16,4),(197,98,0,1,16,4),(197,99,0,1,16,4),(197,100,0,1,16,4),(198,101,0,1,16,4),(198,109,0,1,16,4),(198,111,0,1,16,4),(198,112,0,1,16,4),(199,103,0,1,16,4),(199,110,0,1,16,4),(200,101,0,1,16,4),(200,102,0,1,16,4),(200,108,0,1,16,4),(201,104,0,1,16,4),(201,106,0,1,16,4),(202,101,0,1,16,4),(202,102,0,1,16,4),(202,103,0,1,16,4),(202,105,0,1,16,4),(202,107,0,1,16,4),(202,108,0,1,16,4),(202,110,0,1,16,4),(203,101,0,1,16,4),(203,102,0,1,16,4),(203,103,0,1,16,4),(203,104,0,1,16,4),(203,106,0,1,16,4),(203,108,0,1,16,4),(203,109,0,1,16,4),(204,101,0,1,16,4),(204,102,0,1,16,4),(204,103,0,1,16,4),(204,104,0,1,16,4),(204,105,0,1,16,4),(204,106,0,1,16,4),(204,107,0,1,16,4),(204,108,0,1,16,4),(205,101,0,1,16,4),(205,102,0,1,16,4),(205,103,0,1,16,4),(205,108,0,1,16,4),(205,109,0,1,16,4),(205,110,0,1,16,4),(205,111,0,1,16,4),(205,112,0,1,16,4),(206,113,10000,0,16,4),(206,114,10000,0,16,4),(206,115,10000,0,16,4),(206,116,10000,0,16,4),(206,117,10000,0,16,4),(206,118,10000,0,16,4),(206,119,10000,0,16,4),(207,114,0,1,16,4),(207,119,0,1,16,4),(209,114,0,1,16,4),(212,116,0,1,16,4),(212,118,0,1,16,4),(213,113,0,1,16,4),(218,117,0,1,16,4),(219,119,0,1,16,4),(220,119,0,1,16,4),(221,119,0,1,16,4),(222,114,0,1,16,4),(222,119,0,1,16,4),(223,114,0,1,16,4),(223,119,0,1,16,4),(229,113,0,1,16,4),(230,113,0,1,16,4),(231,113,0,1,16,4),(232,113,0,1,16,4),(233,113,0,1,16,4),(234,116,0,1,16,4),(234,118,0,1,16,4),(235,116,0,1,16,4),(235,118,0,1,16,4),(236,116,0,1,16,4),(236,118,0,1,16,4),(237,116,0,1,16,4),(237,118,0,1,16,4),(238,116,0,1,16,4),(238,118,0,1,16,4),(239,115,0,1,16,4),(241,115,0,1,16,4),(242,115,0,1,16,4),(243,115,0,1,16,4),(250,120,0,1,16,4),(250,121,0,1,16,4),(250,122,0,1,16,4),(250,123,0,1,16,4),(250,124,0,1,16,4),(250,125,0,1,16,4),(250,126,0,1,16,4),(250,127,0,1,16,4),(250,128,0,1,16,4),(250,129,0,1,16,4),(250,130,0,1,16,4),(250,131,0,1,16,4),(251,120,0,1,16,4),(251,121,0,1,16,4),(251,122,0,1,16,4),(251,123,0,1,16,4),(251,124,0,1,16,4),(251,125,0,1,16,4),(251,126,0,1,16,4),(251,127,0,1,16,4),(251,128,0,1,16,4),(251,129,0,1,16,4),(251,130,0,1,16,4),(251,131,0,1,16,4),(252,125,10000,0,16,4),(252,126,10000,0,16,4),(252,127,10000,0,16,4),(252,120,0,1,16,4),(252,121,0,1,16,4),(252,122,0,1,16,4),(252,123,0,1,16,4),(252,124,0,1,16,4),(252,128,0,1,16,4),(252,129,0,1,16,4),(252,131,0,1,16,4),(253,120,0,1,16,4),(253,121,0,1,16,4),(253,122,0,1,16,4),(253,123,0,1,16,4),(253,124,0,1,16,4),(253,125,0,1,16,4),(253,126,0,1,16,4),(253,127,0,1,16,4),(253,128,0,1,16,4),(253,129,0,1,16,4),(253,130,0,1,16,4),(253,131,0,1,16,4),(254,120,0,1,16,4),(254,121,0,1,16,4),(254,122,0,1,16,4),(254,123,0,1,16,4),(254,124,0,1,16,4),(254,125,0,1,16,4),(254,126,0,1,16,4),(254,127,0,1,16,4),(254,128,0,1,16,4),(254,129,0,1,16,4),(254,130,0,1,16,4),(254,131,0,1,16,4),(255,122,0,1,16,4),(255,123,0,1,16,4),(255,124,0,1,16,4),(255,125,0,1,16,4),(255,126,0,1,16,4),(255,129,0,1,16,4),(256,121,0,1,16,4),(256,122,0,1,16,4),(256,123,0,1,16,4),(256,125,0,1,16,4),(256,126,0,1,16,4),(256,127,0,1,16,4),(257,121,0,1,16,4),(257,122,0,1,16,4),(257,123,0,1,16,4),(257,125,0,1,16,4),(257,127,0,1,16,4),(257,129,0,1,16,4),(258,121,0,1,16,4),(258,122,0,1,16,4),(258,125,0,1,16,4),(258,126,0,1,16,4),(258,127,0,1,16,4),(258,129,0,1,16,4),(259,120,0,1,16,4),(259,121,0,1,16,4),(259,123,0,1,16,4),(259,128,0,1,16,4),(259,129,0,1,16,4),(260,120,0,1,16,4),(260,121,0,1,16,4),(260,122,0,1,16,4),(260,123,0,1,16,4),(260,125,0,1,16,4),(260,127,0,1,16,4),(260,128,0,1,16,4),(260,129,0,1,16,4),(261,121,0,1,16,4),(261,122,0,1,16,4),(261,125,0,1,16,4),(261,126,0,1,16,4),(261,127,0,1,16,4),(261,129,0,1,16,4),(262,125,0,1,16,4),(262,126,0,1,16,4),(263,120,0,1,16,4),(263,121,0,1,16,4),(263,122,0,1,16,4),(263,123,0,1,16,4),(263,124,0,1,16,4),(263,128,0,1,16,4),(263,129,0,1,16,4),(263,131,0,1,16,4),(264,120,0,1,16,4),(264,122,0,1,16,4),(264,123,0,1,16,4),(264,125,0,1,16,4),(264,126,0,1,16,4),(264,129,0,1,16,4),(265,121,0,1,16,4),(265,122,0,1,16,4),(265,123,0,1,16,4),(265,127,0,1,16,4),(266,123,0,1,16,4),(266,125,0,1,16,4),(266,126,0,1,16,4),(266,127,0,1,16,4),(266,129,0,1,16,4),(267,121,0,1,16,4),(267,125,0,1,16,4),(267,126,0,1,16,4),(267,127,0,1,16,4),(268,120,0,1,16,4),(268,121,0,1,16,4),(268,122,0,1,16,4),(268,123,0,1,16,4),(268,124,0,1,16,4),(268,127,0,1,16,4),(268,129,0,1,16,4),(269,122,0,1,16,4),(269,125,0,1,16,4),(269,126,0,1,16,4),(269,127,0,1,16,4),(269,129,0,1,16,4),(270,121,0,1,16,4),(270,123,0,1,16,4),(270,125,0,1,16,4),(270,126,0,1,16,4),(270,129,0,1,16,4),(271,120,0,1,16,4),(271,121,0,1,16,4),(271,122,0,1,16,4),(271,125,0,1,16,4),(271,126,0,1,16,4),(271,127,0,1,16,4),(271,129,0,1,16,4),(272,122,0,1,16,4),(272,123,0,1,16,4),(272,124,0,1,16,4),(272,125,0,1,16,4),(272,126,0,1,16,4),(272,127,0,1,16,4),(272,128,0,1,16,4),(272,129,0,1,16,4),(273,120,0,1,16,4),(273,121,0,1,16,4),(273,123,0,1,16,4),(273,126,0,1,16,4),(273,127,0,1,16,4),(274,122,0,1,16,4),(274,123,0,1,16,4),(274,125,0,1,16,4),(274,126,0,1,16,4),(274,129,0,1,16,4),(275,120,0,1,16,4),(275,121,0,1,16,4),(275,122,0,1,16,4),(275,123,0,1,16,4),(275,124,0,1,16,4),(275,125,0,1,16,4),(275,126,0,1,16,4),(275,127,0,1,16,4),(275,128,0,1,16,4),(275,129,0,1,16,4),(275,130,0,1,16,4),(275,131,0,1,16,4),(276,122,0,1,16,4),(276,123,0,1,16,4),(276,127,0,1,16,4),(276,129,0,1,16,4),(277,120,0,1,16,4),(277,121,0,1,16,4),(277,123,0,1,16,4),(277,124,0,1,16,4),(277,125,0,1,16,4),(277,126,0,1,16,4),(277,127,0,1,16,4),(278,120,0,1,16,4),(278,121,0,1,16,4),(278,122,0,1,16,4),(278,123,0,1,16,4),(278,124,0,1,16,4),(278,125,0,1,16,4),(278,127,0,1,16,4),(278,128,0,1,16,4),(278,129,0,1,16,4),(279,120,0,1,16,4),(279,122,0,1,16,4),(279,126,0,1,16,4),(279,127,0,1,16,4),(279,129,0,1,16,4),(280,132,0,1,16,4),(280,133,0,1,16,4),(280,134,0,1,16,4),(280,135,0,1,16,4),(280,136,0,1,16,4),(280,137,0,1,16,4),(280,138,0,1,16,4),(280,139,0,1,16,4),(282,132,0,1,16,4),(282,133,0,1,16,4),(282,134,0,1,16,4),(282,137,0,1,16,4),(282,138,0,1,16,4),(283,135,0,1,16,4),(283,136,0,1,16,4),(283,139,0,1,16,4),(286,140,0,1,16,4),(286,141,0,1,16,4),(286,142,0,1,16,4),(286,143,0,1,16,4),(286,144,0,1,16,4),(286,145,0,1,16,4),(286,146,0,1,16,4),(286,147,0,1,16,4),(286,148,0,1,16,4),(286,149,0,1,16,4),(286,150,0,1,16,4),(286,151,0,1,16,4),(286,152,0,1,16,4),(286,153,0,1,16,4),(286,154,0,1,16,4),(286,155,0,1,16,4),(286,156,0,1,16,4),(286,157,0,1,16,4),(286,158,0,1,16,4),(286,159,0,1,16,4),(286,160,0,1,16,4),(286,161,0,1,16,4),(286,162,0,1,16,4),(286,163,0,1,16,4),(286,164,0,1,16,4),(286,165,0,1,16,4),(286,166,0,1,16,4),(286,167,0,1,16,4),(286,168,0,1,16,4),(286,169,0,1,16,4),(286,170,0,1,16,4),(286,171,0,1,16,4),(286,172,0,1,16,4),(286,173,0,1,16,4),(286,174,0,1,16,4),(286,175,0,1,16,4),(286,176,0,1,16,4),(286,177,0,1,16,4),(286,178,0,1,16,4),(286,179,0,1,16,4),(286,180,0,1,16,4),(286,181,0,1,16,4),(286,182,0,1,16,4),(286,183,0,1,16,4),(286,184,0,1,16,4),(286,185,0,1,16,4),(286,186,0,1,16,4),(286,187,0,1,16,4),(287,188,0,1,16,4),(288,189,0,1,16,4),(288,190,0,1,16,4),(288,191,0,1,16,4),(288,192,0,1,16,4),(288,193,0,1,16,4),(288,194,0,1,16,4),(288,195,0,1,16,4),(288,196,0,1,16,4),(288,197,0,1,16,4),(288,198,0,1,16,4),(288,199,0,1,16,4),(288,200,0,1,16,4),(289,201,10000,0,16,4),(289,202,10000,0,16,4),(289,203,10000,0,16,4),(289,204,10000,0,16,4),(289,205,10000,0,16,4),(289,206,10000,0,16,4),(289,207,10000,0,16,4),(289,208,10000,0,16,4),(289,209,10000,0,16,4),(289,210,10000,0,16,4),(289,211,10000,0,16,4),(289,212,10000,0,16,4),(289,213,10000,0,16,4),(289,214,10000,0,16,4),(289,215,10000,0,16,4),(289,216,10000,0,16,4),(289,217,10000,0,16,4),(289,218,10000,0,16,4),(289,219,10000,0,16,4),(289,220,10000,0,16,4),(289,221,10000,0,16,4),(289,222,10000,0,16,4),(289,223,10000,0,16,4),(289,224,10000,0,16,4),(289,225,10000,0,16,4),(289,226,10000,0,16,4),(289,227,10000,0,16,4),(289,228,10000,0,16,4),(289,229,10000,0,16,4),(289,230,10000,0,16,4),(289,231,10000,0,16,4),(289,232,10000,0,16,4),(289,244,10000,0,16,4),(289,246,10000,0,16,4),(289,251,10000,0,16,4),(289,255,10000,0,16,4),(289,258,10000,0,16,4),(289,259,10000,0,16,4),(289,260,10000,0,16,4),(289,261,10000,0,16,4),(289,262,10000,0,16,4),(289,263,10000,0,16,4),(290,209,0,1,16,4),(290,210,0,1,16,4),(290,211,0,1,16,4),(290,212,0,1,16,4),(290,213,0,1,16,4),(290,214,0,1,16,4),(290,215,0,1,16,4),(290,216,0,1,16,4),(291,201,0,1,16,4),(291,202,0,1,16,4),(291,203,0,1,16,4),(291,204,0,1,16,4),(291,205,0,1,16,4),(291,206,0,1,16,4),(291,207,0,1,16,4),(291,208,0,1,16,4),(292,217,0,1,16,4),(292,218,0,1,16,4),(292,219,0,1,16,4),(292,220,0,1,16,4),(292,221,0,1,16,4),(292,222,0,1,16,4),(292,223,0,1,16,4),(292,224,0,1,16,4),(293,225,0,1,16,4),(293,226,0,1,16,4),(293,227,0,1,16,4),(293,228,0,1,16,4),(293,229,0,1,16,4),(293,230,0,1,16,4),(293,231,0,1,16,4),(293,232,0,1,16,4),(293,255,0,1,16,4),(293,259,0,1,16,4),(293,260,0,1,16,4),(293,261,0,1,16,4),(293,262,0,1,16,4),(293,263,0,1,16,4),(294,233,0,1,16,4),(294,234,0,1,16,4),(294,235,0,1,16,4),(294,236,0,1,16,4),(294,237,0,1,16,4),(294,238,0,1,16,4),(294,239,0,1,16,4),(294,240,0,1,16,4),(294,241,0,1,16,4),(295,244,0,1,16,4),(295,246,0,1,16,4),(295,251,0,1,16,4),(295,255,0,1,16,4),(295,258,0,1,16,4),(296,251,0,1,16,4),(296,255,0,1,16,4),(296,258,0,1,16,4),(297,246,0,1,16,4),(297,255,0,1,16,4),(297,258,0,1,16,4),(298,255,0,1,16,4),(298,258,0,1,16,4),(299,251,0,1,16,4),(299,258,0,1,16,4);
/*!40000 ALTER TABLE `catalog_category_product_index_store16` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index_store16_replica`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store16_replica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store16_replica` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `CAT_CTGR_PRD_IDX_STORE16_PRD_ID_STORE_ID_CTGR_ID_VISIBILITY` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_3FCA7BB482F2A772620280C9007DB7F4` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Product Index Store16 Replica';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index_store16_replica`
--

LOCK TABLES `catalog_category_product_index_store16_replica` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index_store16_replica` DISABLE KEYS */;
INSERT INTO `catalog_category_product_index_store16_replica` VALUES (2,1,0,1,16,4),(2,2,0,1,16,4),(2,3,0,1,16,4),(2,4,0,1,16,4),(2,5,0,1,16,4),(2,6,0,1,16,4),(2,7,0,1,16,4),(2,8,0,1,16,4),(2,9,0,1,16,4),(2,10,0,1,16,4),(2,11,0,1,16,4),(2,12,0,1,16,4),(2,13,0,1,16,4),(2,14,0,1,16,4),(2,15,0,1,16,4),(2,16,0,1,16,4),(2,17,0,1,16,4),(2,18,0,1,16,4),(2,19,0,1,16,4),(2,20,0,1,16,4),(2,21,0,1,16,4),(2,22,0,1,16,4),(2,23,0,1,16,4),(2,24,0,1,16,4),(2,25,0,1,16,4),(2,26,0,1,16,4),(2,27,0,1,16,4),(2,28,0,1,16,4),(2,29,0,1,16,4),(2,30,0,1,16,4),(2,31,0,1,16,4),(2,32,0,1,16,4),(2,33,0,1,16,4),(2,34,0,1,16,4),(2,35,0,1,16,4),(2,36,0,1,16,4),(2,37,0,1,16,4),(2,38,0,1,16,4),(2,39,0,1,16,4),(2,40,0,1,16,4),(2,41,0,1,16,4),(2,42,0,1,16,4),(2,43,0,1,16,4),(2,44,0,1,16,4),(2,45,0,1,16,4),(2,46,0,1,16,4),(2,47,0,1,16,4),(2,48,0,1,16,4),(2,49,0,1,16,4),(2,50,0,1,16,4),(2,57,0,1,16,4),(2,58,0,1,16,4),(2,59,0,1,16,4),(2,60,0,1,16,4),(2,61,0,1,16,4),(2,62,0,1,16,4),(2,63,0,1,16,4),(2,64,0,1,16,4),(2,65,0,1,16,4),(2,66,0,1,16,4),(2,68,0,1,16,4),(2,69,0,1,16,4),(2,70,0,1,16,4),(2,71,0,1,16,4),(2,72,0,1,16,4),(2,73,0,1,16,4),(2,74,0,1,16,4),(2,75,0,1,16,4),(2,76,0,1,16,4),(2,77,0,1,16,4),(2,78,0,1,16,4),(2,79,0,1,16,4),(2,80,0,1,16,4),(2,81,0,1,16,4),(2,82,0,1,16,4),(2,83,0,1,16,4),(2,84,0,1,16,4),(2,85,0,1,16,4),(2,86,0,1,16,4),(2,87,0,1,16,4),(2,88,0,1,16,4),(2,89,0,1,16,4),(2,90,0,1,16,4),(2,91,0,1,16,4),(2,92,0,1,16,4),(2,93,0,1,16,4),(2,94,0,1,16,4),(2,95,0,1,16,4),(2,96,0,1,16,4),(2,97,0,1,16,4),(2,98,0,1,16,4),(2,99,0,1,16,4),(2,100,0,1,16,4),(2,101,0,1,16,4),(2,102,0,1,16,4),(2,103,0,1,16,4),(2,104,0,1,16,4),(2,105,0,1,16,4),(2,106,0,1,16,4),(2,107,0,1,16,4),(2,108,0,1,16,4),(2,109,0,1,16,4),(2,110,0,1,16,4),(2,111,0,1,16,4),(2,112,0,1,16,4),(2,113,0,1,16,4),(2,114,0,1,16,4),(2,115,0,1,16,4),(2,116,0,1,16,4),(2,117,0,1,16,4),(2,118,0,1,16,4),(2,119,0,1,16,4),(2,120,0,1,16,4),(2,121,0,1,16,4),(2,122,0,1,16,4),(2,123,0,1,16,4),(2,124,0,1,16,4),(2,125,0,1,16,4),(2,126,0,1,16,4),(2,127,0,1,16,4),(2,128,0,1,16,4),(2,129,0,1,16,4),(2,130,0,1,16,4),(2,131,0,1,16,4),(2,132,0,1,16,4),(2,133,0,1,16,4),(2,134,0,1,16,4),(2,135,0,1,16,4),(2,136,0,1,16,4),(2,137,0,1,16,4),(2,138,0,1,16,4),(2,139,0,1,16,4),(2,140,0,1,16,4),(2,141,0,1,16,4),(2,142,0,1,16,4),(2,143,0,1,16,4),(2,144,0,1,16,4),(2,145,0,1,16,4),(2,146,0,1,16,4),(2,147,0,1,16,4),(2,148,0,1,16,4),(2,149,0,1,16,4),(2,150,0,1,16,4),(2,151,0,1,16,4),(2,152,0,1,16,4),(2,153,0,1,16,4),(2,154,0,1,16,4),(2,155,0,1,16,4),(2,156,0,1,16,4),(2,157,0,1,16,4),(2,158,0,1,16,4),(2,159,0,1,16,4),(2,160,0,1,16,4),(2,161,0,1,16,4),(2,162,0,1,16,4),(2,163,0,1,16,4),(2,164,0,1,16,4),(2,165,0,1,16,4),(2,166,0,1,16,4),(2,167,0,1,16,4),(2,168,0,1,16,4),(2,169,0,1,16,4),(2,170,0,1,16,4),(2,171,0,1,16,4),(2,172,0,1,16,4),(2,173,0,1,16,4),(2,174,0,1,16,4),(2,175,0,1,16,4),(2,176,0,1,16,4),(2,177,0,1,16,4),(2,178,0,1,16,4),(2,179,0,1,16,4),(2,180,0,1,16,4),(2,181,0,1,16,4),(2,182,0,1,16,4),(2,183,0,1,16,4),(2,184,0,1,16,4),(2,185,0,1,16,4),(2,186,0,1,16,4),(2,187,0,1,16,4),(2,188,0,1,16,4),(2,189,0,1,16,4),(2,190,0,1,16,4),(2,191,0,1,16,4),(2,192,0,1,16,4),(2,193,0,1,16,4),(2,194,0,1,16,4),(2,195,0,1,16,4),(2,196,0,1,16,4),(2,197,0,1,16,4),(2,198,0,1,16,4),(2,199,0,1,16,4),(2,200,0,1,16,4),(2,201,0,1,16,4),(2,202,0,1,16,4),(2,203,0,1,16,4),(2,204,0,1,16,4),(2,205,0,1,16,4),(2,206,0,1,16,4),(2,207,0,1,16,4),(2,208,0,1,16,4),(2,209,0,1,16,4),(2,210,0,1,16,4),(2,211,0,1,16,4),(2,212,0,1,16,4),(2,213,0,1,16,4),(2,214,0,1,16,4),(2,215,0,1,16,4),(2,216,0,1,16,4),(2,217,0,1,16,4),(2,218,0,1,16,4),(2,219,0,1,16,4),(2,220,0,1,16,4),(2,221,0,1,16,4),(2,222,0,1,16,4),(2,223,0,1,16,4),(2,224,0,1,16,4),(2,225,0,1,16,4),(2,226,0,1,16,4),(2,227,0,1,16,4),(2,228,0,1,16,4),(2,229,0,1,16,4),(2,230,0,1,16,4),(2,231,0,1,16,4),(2,232,0,1,16,4),(2,233,0,1,16,4),(2,234,0,1,16,4),(2,235,0,1,16,4),(2,236,0,1,16,4),(2,237,0,1,16,4),(2,238,0,1,16,4),(2,239,0,1,16,4),(2,240,0,1,16,4),(2,241,0,1,16,4),(2,244,0,1,16,4),(2,246,0,1,16,4),(2,251,0,1,16,4),(2,255,0,1,16,4),(2,258,0,1,16,4),(2,259,0,1,16,4),(2,260,0,1,16,4),(2,261,0,1,16,4),(2,262,0,1,16,4),(2,263,0,1,16,4),(3,1,0,1,16,4),(3,2,0,1,16,4),(3,3,0,1,16,4),(3,4,0,1,16,4),(3,5,0,1,16,4),(3,6,0,1,16,4),(3,7,0,1,16,4),(3,8,0,1,16,4),(3,10,0,1,16,4),(3,11,0,1,16,4),(4,12,0,1,16,4),(4,13,0,1,16,4),(4,14,0,1,16,4),(4,15,0,1,16,4),(4,16,0,1,16,4),(4,17,0,1,16,4),(4,18,0,1,16,4),(4,19,0,1,16,4),(4,36,0,1,16,4),(4,37,0,1,16,4),(4,38,0,1,16,4),(4,39,0,1,16,4),(4,40,0,1,16,4),(5,95,10000,0,16,4),(5,96,10000,0,16,4),(5,97,10000,0,16,4),(5,98,10000,0,16,4),(5,99,10000,0,16,4),(5,100,10000,0,16,4),(7,101,10000,0,16,4),(7,102,10000,0,16,4),(7,103,10000,0,16,4),(7,104,10000,0,16,4),(7,105,10000,0,16,4),(7,106,10000,0,16,4),(7,107,10000,0,16,4),(7,108,10000,0,16,4),(7,109,10000,0,16,4),(7,110,10000,0,16,4),(7,111,10000,0,16,4),(7,112,10000,0,16,4),(7,21,0,1,16,4),(7,22,0,1,16,4),(7,26,0,1,16,4),(8,61,0,1,16,4),(8,62,0,1,16,4),(8,63,0,1,16,4),(8,64,0,1,16,4),(8,65,0,1,16,4),(8,66,0,1,16,4),(11,4,10000,0,16,4),(11,89,10000,0,16,4),(11,90,10000,0,16,4),(11,91,10000,0,16,4),(11,92,10000,0,16,4),(11,93,10000,0,16,4),(11,94,10000,0,16,4),(11,28,0,1,16,4),(11,29,0,1,16,4),(11,30,0,1,16,4),(11,31,0,1,16,4),(11,32,0,1,16,4),(11,33,0,1,16,4),(11,34,0,1,16,4),(11,35,0,1,16,4),(13,21,0,1,16,4),(13,24,0,1,16,4),(13,25,0,1,16,4),(13,26,0,1,16,4),(13,27,0,1,16,4),(13,41,0,1,16,4),(13,42,0,1,16,4),(13,43,0,1,16,4),(13,44,0,1,16,4),(13,45,0,1,16,4),(13,46,0,1,16,4),(13,47,0,1,16,4),(13,48,0,1,16,4),(13,49,0,1,16,4),(15,22,10000,0,16,4),(15,23,10000,0,16,4),(16,20,0,1,16,4),(16,21,0,1,16,4),(16,22,0,1,16,4),(16,23,0,1,16,4),(16,24,0,1,16,4),(16,25,0,1,16,4),(16,26,0,1,16,4),(16,27,0,1,16,4),(16,41,0,1,16,4),(16,68,0,1,16,4),(16,69,0,1,16,4),(16,70,0,1,16,4),(16,71,0,1,16,4),(16,72,0,1,16,4),(16,73,0,1,16,4),(19,6,0,1,16,4),(19,7,0,1,16,4),(19,8,0,1,16,4),(19,10,0,1,16,4),(19,11,0,1,16,4),(27,11,0,1,16,4),(29,6,0,1,16,4),(29,8,0,1,16,4),(29,10,0,1,16,4),(30,6,0,1,16,4),(30,10,0,1,16,4),(33,7,0,1,16,4),(33,8,0,1,16,4),(33,10,0,1,16,4),(33,11,0,1,16,4),(42,7,0,1,16,4),(42,8,0,1,16,4),(42,11,0,1,16,4),(78,21,0,1,16,4),(78,26,0,1,16,4),(80,21,0,1,16,4),(80,22,0,1,16,4),(80,26,0,1,16,4),(81,26,0,1,16,4),(82,26,0,1,16,4),(83,26,0,1,16,4),(96,26,0,1,16,4),(97,26,0,1,16,4),(98,21,0,1,16,4),(98,22,0,1,16,4),(98,26,0,1,16,4),(99,18,0,1,16,4),(101,14,0,1,16,4),(101,15,0,1,16,4),(101,16,0,1,16,4),(102,12,0,1,16,4),(102,13,0,1,16,4),(102,14,0,1,16,4),(102,15,0,1,16,4),(102,16,0,1,16,4),(102,17,0,1,16,4),(102,19,0,1,16,4),(102,36,0,1,16,4),(102,37,0,1,16,4),(102,38,0,1,16,4),(102,39,0,1,16,4),(102,40,0,1,16,4),(103,18,0,1,16,4),(104,18,0,1,16,4),(105,18,0,1,16,4),(106,18,0,1,16,4),(107,18,0,1,16,4),(134,23,0,1,16,4),(135,22,0,1,16,4),(137,4,0,1,16,4),(137,28,0,1,16,4),(137,31,0,1,16,4),(137,34,0,1,16,4),(137,35,0,1,16,4),(138,28,0,1,16,4),(138,30,0,1,16,4),(138,32,0,1,16,4),(138,33,0,1,16,4),(139,28,0,1,16,4),(139,30,0,1,16,4),(139,32,0,1,16,4),(139,33,0,1,16,4),(140,28,0,1,16,4),(140,30,0,1,16,4),(140,32,0,1,16,4),(140,33,0,1,16,4),(145,1,0,1,16,4),(145,2,0,1,16,4),(145,3,0,1,16,4),(145,4,0,1,16,4),(145,5,0,1,16,4),(145,6,0,1,16,4),(145,7,0,1,16,4),(145,8,0,1,16,4),(145,9,0,1,16,4),(145,10,0,1,16,4),(145,11,0,1,16,4),(145,12,0,1,16,4),(145,13,0,1,16,4),(145,14,0,1,16,4),(145,15,0,1,16,4),(145,16,0,1,16,4),(145,17,0,1,16,4),(145,18,0,1,16,4),(145,19,0,1,16,4),(145,20,0,1,16,4),(145,21,0,1,16,4),(145,22,0,1,16,4),(145,23,0,1,16,4),(145,24,0,1,16,4),(145,25,0,1,16,4),(145,26,0,1,16,4),(145,27,0,1,16,4),(145,28,0,1,16,4),(145,29,0,1,16,4),(145,30,0,1,16,4),(145,31,0,1,16,4),(145,32,0,1,16,4),(145,33,0,1,16,4),(145,34,0,1,16,4),(145,35,0,1,16,4),(145,36,0,1,16,4),(145,37,0,1,16,4),(145,38,0,1,16,4),(145,39,0,1,16,4),(145,40,0,1,16,4),(145,41,0,1,16,4),(145,42,0,1,16,4),(145,43,0,1,16,4),(149,41,0,1,16,4),(150,50,0,1,16,4),(150,57,0,1,16,4),(150,58,0,1,16,4),(150,59,0,1,16,4),(150,60,0,1,16,4),(151,61,0,1,16,4),(151,62,0,1,16,4),(151,63,0,1,16,4),(151,64,0,1,16,4),(151,65,0,1,16,4),(151,66,0,1,16,4),(152,61,0,1,16,4),(152,63,0,1,16,4),(153,61,0,1,16,4),(153,63,0,1,16,4),(153,64,0,1,16,4),(153,65,0,1,16,4),(153,66,0,1,16,4),(154,61,0,1,16,4),(154,62,0,1,16,4),(154,64,0,1,16,4),(154,66,0,1,16,4),(155,61,0,1,16,4),(155,62,0,1,16,4),(155,64,0,1,16,4),(155,65,0,1,16,4),(155,66,0,1,16,4),(156,61,0,1,16,4),(156,62,0,1,16,4),(156,63,0,1,16,4),(156,64,0,1,16,4),(156,65,0,1,16,4),(156,66,0,1,16,4),(157,61,0,1,16,4),(157,62,0,1,16,4),(157,64,0,1,16,4),(157,65,0,1,16,4),(157,66,0,1,16,4),(158,61,0,1,16,4),(158,63,0,1,16,4),(158,64,0,1,16,4),(158,65,0,1,16,4),(158,66,0,1,16,4),(159,61,0,1,16,4),(159,62,0,1,16,4),(159,63,0,1,16,4),(159,64,0,1,16,4),(159,65,0,1,16,4),(159,66,0,1,16,4),(160,41,0,1,16,4),(160,68,0,1,16,4),(160,69,0,1,16,4),(160,70,0,1,16,4),(160,72,0,1,16,4),(160,73,0,1,16,4),(161,68,0,1,16,4),(161,69,0,1,16,4),(161,70,0,1,16,4),(161,71,0,1,16,4),(161,72,0,1,16,4),(162,68,0,1,16,4),(162,69,0,1,16,4),(162,72,0,1,16,4),(164,41,0,1,16,4),(164,70,0,1,16,4),(164,73,0,1,16,4),(166,41,0,1,16,4),(166,70,0,1,16,4),(166,73,0,1,16,4),(167,68,0,1,16,4),(167,69,0,1,16,4),(167,72,0,1,16,4),(168,71,0,1,16,4),(169,70,0,1,16,4),(171,70,0,1,16,4),(172,1,10000,0,16,4),(172,2,10000,0,16,4),(172,3,10000,0,16,4),(172,4,10000,0,16,4),(172,5,10000,0,16,4),(172,6,10000,0,16,4),(172,7,10000,0,16,4),(172,8,10000,0,16,4),(172,9,10000,0,16,4),(172,10,10000,0,16,4),(172,11,10000,0,16,4),(172,12,10000,0,16,4),(172,13,10000,0,16,4),(172,14,10000,0,16,4),(172,15,10000,0,16,4),(172,16,10000,0,16,4),(172,17,10000,0,16,4),(172,18,10000,0,16,4),(172,19,10000,0,16,4),(172,20,10000,0,16,4),(172,21,10000,0,16,4),(172,22,10000,0,16,4),(172,23,10000,0,16,4),(172,24,10000,0,16,4),(172,25,10000,0,16,4),(172,26,10000,0,16,4),(172,27,10000,0,16,4),(172,28,10000,0,16,4),(172,29,10000,0,16,4),(172,30,10000,0,16,4),(173,1,0,1,16,4),(173,2,0,1,16,4),(173,3,0,1,16,4),(173,4,0,1,16,4),(173,5,0,1,16,4),(173,6,0,1,16,4),(173,7,0,1,16,4),(173,8,0,1,16,4),(173,9,0,1,16,4),(173,10,0,1,16,4),(173,11,0,1,16,4),(173,12,0,1,16,4),(173,13,0,1,16,4),(173,14,0,1,16,4),(173,15,0,1,16,4),(173,16,0,1,16,4),(173,17,0,1,16,4),(173,18,0,1,16,4),(173,19,0,1,16,4),(173,20,0,1,16,4),(173,21,0,1,16,4),(173,22,0,1,16,4),(173,23,0,1,16,4),(173,24,0,1,16,4),(173,25,0,1,16,4),(173,26,0,1,16,4),(173,27,0,1,16,4),(173,28,0,1,16,4),(173,29,0,1,16,4),(173,30,0,1,16,4),(174,1,0,1,16,4),(174,2,0,1,16,4),(174,3,0,1,16,4),(174,4,0,1,16,4),(174,5,0,1,16,4),(174,6,0,1,16,4),(174,7,0,1,16,4),(174,8,0,1,16,4),(174,9,0,1,16,4),(174,10,0,1,16,4),(174,11,0,1,16,4),(174,12,0,1,16,4),(174,13,0,1,16,4),(174,14,0,1,16,4),(174,15,0,1,16,4),(174,16,0,1,16,4),(174,17,0,1,16,4),(174,18,0,1,16,4),(174,19,0,1,16,4),(174,20,0,1,16,4),(174,21,0,1,16,4),(174,22,0,1,16,4),(174,23,0,1,16,4),(174,24,0,1,16,4),(174,25,0,1,16,4),(174,26,0,1,16,4),(174,27,0,1,16,4),(174,28,0,1,16,4),(174,29,0,1,16,4),(174,30,0,1,16,4),(175,1,0,1,16,4),(175,2,0,1,16,4),(175,3,0,1,16,4),(175,4,0,1,16,4),(175,5,0,1,16,4),(175,6,0,1,16,4),(175,7,0,1,16,4),(175,8,0,1,16,4),(175,9,0,1,16,4),(175,10,0,1,16,4),(175,11,0,1,16,4),(175,12,0,1,16,4),(175,13,0,1,16,4),(175,14,0,1,16,4),(175,15,0,1,16,4),(175,16,0,1,16,4),(175,17,0,1,16,4),(175,18,0,1,16,4),(175,19,0,1,16,4),(175,20,0,1,16,4),(175,21,0,1,16,4),(175,22,0,1,16,4),(175,23,0,1,16,4),(175,24,0,1,16,4),(175,25,0,1,16,4),(175,26,0,1,16,4),(175,27,0,1,16,4),(175,28,0,1,16,4),(175,29,0,1,16,4),(175,30,0,1,16,4),(176,1,0,1,16,4),(176,2,0,1,16,4),(176,3,0,1,16,4),(176,4,0,1,16,4),(176,5,0,1,16,4),(176,6,0,1,16,4),(176,7,0,1,16,4),(176,8,0,1,16,4),(176,9,0,1,16,4),(176,10,0,1,16,4),(176,11,0,1,16,4),(176,12,0,1,16,4),(176,13,0,1,16,4),(176,14,0,1,16,4),(176,15,0,1,16,4),(176,16,0,1,16,4),(176,17,0,1,16,4),(176,18,0,1,16,4),(176,19,0,1,16,4),(176,20,0,1,16,4),(176,21,0,1,16,4),(176,22,0,1,16,4),(176,23,0,1,16,4),(176,24,0,1,16,4),(176,25,0,1,16,4),(176,26,0,1,16,4),(176,27,0,1,16,4),(176,28,0,1,16,4),(176,29,0,1,16,4),(176,30,0,1,16,4),(177,74,0,1,16,4),(177,75,0,1,16,4),(177,76,0,1,16,4),(177,77,0,1,16,4),(177,78,0,1,16,4),(177,79,0,1,16,4),(177,80,0,1,16,4),(178,74,10000,0,16,4),(178,75,10000,0,16,4),(178,76,10000,0,16,4),(178,77,10000,0,16,4),(178,78,10000,0,16,4),(178,79,10000,0,16,4),(178,80,10000,0,16,4),(178,81,10000,0,16,4),(178,82,10000,0,16,4),(178,83,10000,0,16,4),(178,84,10000,0,16,4),(178,85,10000,0,16,4),(178,86,10000,0,16,4),(178,87,10000,0,16,4),(178,88,10000,0,16,4),(178,113,10000,0,16,4),(178,114,10000,0,16,4),(178,115,10000,0,16,4),(178,116,10000,0,16,4),(178,117,10000,0,16,4),(178,118,10000,0,16,4),(178,119,10000,0,16,4),(178,120,10000,0,16,4),(178,121,10000,0,16,4),(178,122,10000,0,16,4),(178,123,10000,0,16,4),(178,124,10000,0,16,4),(178,125,10000,0,16,4),(178,126,10000,0,16,4),(178,127,10000,0,16,4),(178,128,10000,0,16,4),(178,129,10000,0,16,4),(178,130,10000,0,16,4),(178,131,10000,0,16,4),(178,132,10000,0,16,4),(178,133,10000,0,16,4),(178,134,10000,0,16,4),(178,135,10000,0,16,4),(178,136,10000,0,16,4),(178,137,10000,0,16,4),(178,138,10000,0,16,4),(178,139,10000,0,16,4),(178,140,10000,0,16,4),(178,141,10000,0,16,4),(178,142,10000,0,16,4),(178,143,10000,0,16,4),(178,144,10000,0,16,4),(178,145,10000,0,16,4),(178,146,10000,0,16,4),(178,147,10000,0,16,4),(178,148,10000,0,16,4),(178,149,10000,0,16,4),(178,150,10000,0,16,4),(178,151,10000,0,16,4),(178,152,10000,0,16,4),(178,153,10000,0,16,4),(178,154,10000,0,16,4),(178,155,10000,0,16,4),(178,156,10000,0,16,4),(178,157,10000,0,16,4),(178,158,10000,0,16,4),(178,159,10000,0,16,4),(178,160,10000,0,16,4),(178,161,10000,0,16,4),(178,162,10000,0,16,4),(178,163,10000,0,16,4),(178,164,10000,0,16,4),(178,165,10000,0,16,4),(178,166,10000,0,16,4),(178,167,10000,0,16,4),(178,168,10000,0,16,4),(178,169,10000,0,16,4),(178,170,10000,0,16,4),(178,171,10000,0,16,4),(178,172,10000,0,16,4),(178,173,10000,0,16,4),(178,174,10000,0,16,4),(178,175,10000,0,16,4),(178,176,10000,0,16,4),(178,177,10000,0,16,4),(178,178,10000,0,16,4),(178,179,10000,0,16,4),(178,180,10000,0,16,4),(178,181,10000,0,16,4),(178,182,10000,0,16,4),(178,183,10000,0,16,4),(178,184,10000,0,16,4),(178,185,10000,0,16,4),(178,186,10000,0,16,4),(178,187,10000,0,16,4),(178,188,10000,0,16,4),(178,189,10000,0,16,4),(178,190,10000,0,16,4),(178,191,10000,0,16,4),(178,192,10000,0,16,4),(178,193,10000,0,16,4),(178,194,10000,0,16,4),(178,195,10000,0,16,4),(178,196,10000,0,16,4),(178,197,10000,0,16,4),(178,198,10000,0,16,4),(178,199,10000,0,16,4),(178,200,10000,0,16,4),(178,201,10000,0,16,4),(178,202,10000,0,16,4),(178,203,10000,0,16,4),(178,204,10000,0,16,4),(178,205,10000,0,16,4),(178,206,10000,0,16,4),(178,207,10000,0,16,4),(178,208,10000,0,16,4),(178,209,10000,0,16,4),(178,210,10000,0,16,4),(178,211,10000,0,16,4),(178,212,10000,0,16,4),(178,213,10000,0,16,4),(178,214,10000,0,16,4),(178,215,10000,0,16,4),(178,216,10000,0,16,4),(178,217,10000,0,16,4),(178,218,10000,0,16,4),(178,219,10000,0,16,4),(178,220,10000,0,16,4),(178,221,10000,0,16,4),(178,222,10000,0,16,4),(178,223,10000,0,16,4),(178,224,10000,0,16,4),(178,225,10000,0,16,4),(178,226,10000,0,16,4),(178,227,10000,0,16,4),(178,228,10000,0,16,4),(178,229,10000,0,16,4),(178,230,10000,0,16,4),(178,231,10000,0,16,4),(178,232,10000,0,16,4),(178,233,10000,0,16,4),(178,234,10000,0,16,4),(178,235,10000,0,16,4),(178,236,10000,0,16,4),(178,237,10000,0,16,4),(178,238,10000,0,16,4),(178,239,10000,0,16,4),(178,240,10000,0,16,4),(178,241,10000,0,16,4),(178,244,10000,0,16,4),(178,246,10000,0,16,4),(178,251,10000,0,16,4),(178,255,10000,0,16,4),(178,258,10000,0,16,4),(178,259,10000,0,16,4),(178,260,10000,0,16,4),(178,261,10000,0,16,4),(178,262,10000,0,16,4),(178,263,10000,0,16,4),(179,81,0,1,16,4),(179,82,0,1,16,4),(179,83,0,1,16,4),(179,84,0,1,16,4),(179,85,0,1,16,4),(179,86,0,1,16,4),(179,87,0,1,16,4),(179,88,0,1,16,4),(180,81,0,1,16,4),(181,86,0,1,16,4),(182,82,0,1,16,4),(182,83,0,1,16,4),(182,84,0,1,16,4),(182,85,0,1,16,4),(182,87,0,1,16,4),(182,88,0,1,16,4),(183,82,0,1,16,4),(183,83,0,1,16,4),(183,84,0,1,16,4),(183,85,0,1,16,4),(183,86,0,1,16,4),(183,87,0,1,16,4),(183,88,0,1,16,4),(192,89,0,1,16,4),(192,90,0,1,16,4),(192,91,0,1,16,4),(192,92,0,1,16,4),(192,93,0,1,16,4),(192,94,0,1,16,4),(193,95,0,1,16,4),(193,96,0,1,16,4),(193,97,0,1,16,4),(193,98,0,1,16,4),(193,99,0,1,16,4),(193,100,0,1,16,4),(194,95,0,1,16,4),(194,96,0,1,16,4),(194,97,0,1,16,4),(194,98,0,1,16,4),(194,99,0,1,16,4),(194,100,0,1,16,4),(195,95,0,1,16,4),(195,96,0,1,16,4),(195,97,0,1,16,4),(195,98,0,1,16,4),(195,99,0,1,16,4),(195,100,0,1,16,4),(196,95,0,1,16,4),(196,96,0,1,16,4),(196,97,0,1,16,4),(196,98,0,1,16,4),(196,99,0,1,16,4),(196,100,0,1,16,4),(197,95,0,1,16,4),(197,96,0,1,16,4),(197,97,0,1,16,4),(197,98,0,1,16,4),(197,99,0,1,16,4),(197,100,0,1,16,4),(198,101,0,1,16,4),(198,109,0,1,16,4),(198,111,0,1,16,4),(198,112,0,1,16,4),(199,103,0,1,16,4),(199,110,0,1,16,4),(200,101,0,1,16,4),(200,102,0,1,16,4),(200,108,0,1,16,4),(201,104,0,1,16,4),(201,106,0,1,16,4),(202,101,0,1,16,4),(202,102,0,1,16,4),(202,103,0,1,16,4),(202,105,0,1,16,4),(202,107,0,1,16,4),(202,108,0,1,16,4),(202,110,0,1,16,4),(203,101,0,1,16,4),(203,102,0,1,16,4),(203,103,0,1,16,4),(203,104,0,1,16,4),(203,106,0,1,16,4),(203,108,0,1,16,4),(203,109,0,1,16,4),(204,101,0,1,16,4),(204,102,0,1,16,4),(204,103,0,1,16,4),(204,104,0,1,16,4),(204,105,0,1,16,4),(204,106,0,1,16,4),(204,107,0,1,16,4),(204,108,0,1,16,4),(205,101,0,1,16,4),(205,102,0,1,16,4),(205,103,0,1,16,4),(205,108,0,1,16,4),(205,109,0,1,16,4),(205,110,0,1,16,4),(205,111,0,1,16,4),(205,112,0,1,16,4),(206,113,10000,0,16,4),(206,114,10000,0,16,4),(206,115,10000,0,16,4),(206,116,10000,0,16,4),(206,117,10000,0,16,4),(206,118,10000,0,16,4),(206,119,10000,0,16,4),(207,114,0,1,16,4),(207,119,0,1,16,4),(209,114,0,1,16,4),(212,116,0,1,16,4),(212,118,0,1,16,4),(213,113,0,1,16,4),(218,117,0,1,16,4),(219,119,0,1,16,4),(220,119,0,1,16,4),(221,119,0,1,16,4),(222,114,0,1,16,4),(222,119,0,1,16,4),(223,114,0,1,16,4),(223,119,0,1,16,4),(229,113,0,1,16,4),(230,113,0,1,16,4),(231,113,0,1,16,4),(232,113,0,1,16,4),(233,113,0,1,16,4),(234,116,0,1,16,4),(234,118,0,1,16,4),(235,116,0,1,16,4),(235,118,0,1,16,4),(236,116,0,1,16,4),(236,118,0,1,16,4),(237,116,0,1,16,4),(237,118,0,1,16,4),(238,116,0,1,16,4),(238,118,0,1,16,4),(239,115,0,1,16,4),(241,115,0,1,16,4),(242,115,0,1,16,4),(243,115,0,1,16,4),(250,120,0,1,16,4),(250,121,0,1,16,4),(250,122,0,1,16,4),(250,123,0,1,16,4),(250,124,0,1,16,4),(250,125,0,1,16,4),(250,126,0,1,16,4),(250,127,0,1,16,4),(250,128,0,1,16,4),(250,129,0,1,16,4),(250,130,0,1,16,4),(250,131,0,1,16,4),(251,120,0,1,16,4),(251,121,0,1,16,4),(251,122,0,1,16,4),(251,123,0,1,16,4),(251,124,0,1,16,4),(251,125,0,1,16,4),(251,126,0,1,16,4),(251,127,0,1,16,4),(251,128,0,1,16,4),(251,129,0,1,16,4),(251,130,0,1,16,4),(251,131,0,1,16,4),(252,125,10000,0,16,4),(252,126,10000,0,16,4),(252,127,10000,0,16,4),(252,120,0,1,16,4),(252,121,0,1,16,4),(252,122,0,1,16,4),(252,123,0,1,16,4),(252,124,0,1,16,4),(252,128,0,1,16,4),(252,129,0,1,16,4),(252,131,0,1,16,4),(253,120,0,1,16,4),(253,121,0,1,16,4),(253,122,0,1,16,4),(253,123,0,1,16,4),(253,124,0,1,16,4),(253,125,0,1,16,4),(253,126,0,1,16,4),(253,127,0,1,16,4),(253,128,0,1,16,4),(253,129,0,1,16,4),(253,130,0,1,16,4),(253,131,0,1,16,4),(254,120,0,1,16,4),(254,121,0,1,16,4),(254,122,0,1,16,4),(254,123,0,1,16,4),(254,124,0,1,16,4),(254,125,0,1,16,4),(254,126,0,1,16,4),(254,127,0,1,16,4),(254,128,0,1,16,4),(254,129,0,1,16,4),(254,130,0,1,16,4),(254,131,0,1,16,4),(255,122,0,1,16,4),(255,123,0,1,16,4),(255,124,0,1,16,4),(255,125,0,1,16,4),(255,126,0,1,16,4),(255,129,0,1,16,4),(256,121,0,1,16,4),(256,122,0,1,16,4),(256,123,0,1,16,4),(256,125,0,1,16,4),(256,126,0,1,16,4),(256,127,0,1,16,4),(257,121,0,1,16,4),(257,122,0,1,16,4),(257,123,0,1,16,4),(257,125,0,1,16,4),(257,127,0,1,16,4),(257,129,0,1,16,4),(258,121,0,1,16,4),(258,122,0,1,16,4),(258,125,0,1,16,4),(258,126,0,1,16,4),(258,127,0,1,16,4),(258,129,0,1,16,4),(259,120,0,1,16,4),(259,121,0,1,16,4),(259,123,0,1,16,4),(259,128,0,1,16,4),(259,129,0,1,16,4),(260,120,0,1,16,4),(260,121,0,1,16,4),(260,122,0,1,16,4),(260,123,0,1,16,4),(260,125,0,1,16,4),(260,127,0,1,16,4),(260,128,0,1,16,4),(260,129,0,1,16,4),(261,121,0,1,16,4),(261,122,0,1,16,4),(261,125,0,1,16,4),(261,126,0,1,16,4),(261,127,0,1,16,4),(261,129,0,1,16,4),(262,125,0,1,16,4),(262,126,0,1,16,4),(263,120,0,1,16,4),(263,121,0,1,16,4),(263,122,0,1,16,4),(263,123,0,1,16,4),(263,124,0,1,16,4),(263,128,0,1,16,4),(263,129,0,1,16,4),(263,131,0,1,16,4),(264,120,0,1,16,4),(264,122,0,1,16,4),(264,123,0,1,16,4),(264,125,0,1,16,4),(264,126,0,1,16,4),(264,129,0,1,16,4),(265,121,0,1,16,4),(265,122,0,1,16,4),(265,123,0,1,16,4),(265,127,0,1,16,4),(266,123,0,1,16,4),(266,125,0,1,16,4),(266,126,0,1,16,4),(266,127,0,1,16,4),(266,129,0,1,16,4),(267,121,0,1,16,4),(267,125,0,1,16,4),(267,126,0,1,16,4),(267,127,0,1,16,4),(268,120,0,1,16,4),(268,121,0,1,16,4),(268,122,0,1,16,4),(268,123,0,1,16,4),(268,124,0,1,16,4),(268,127,0,1,16,4),(268,129,0,1,16,4),(269,122,0,1,16,4),(269,125,0,1,16,4),(269,126,0,1,16,4),(269,127,0,1,16,4),(269,129,0,1,16,4),(270,121,0,1,16,4),(270,123,0,1,16,4),(270,125,0,1,16,4),(270,126,0,1,16,4),(270,129,0,1,16,4),(271,120,0,1,16,4),(271,121,0,1,16,4),(271,122,0,1,16,4),(271,125,0,1,16,4),(271,126,0,1,16,4),(271,127,0,1,16,4),(271,129,0,1,16,4),(272,122,0,1,16,4),(272,123,0,1,16,4),(272,124,0,1,16,4),(272,125,0,1,16,4),(272,126,0,1,16,4),(272,127,0,1,16,4),(272,128,0,1,16,4),(272,129,0,1,16,4),(273,120,0,1,16,4),(273,121,0,1,16,4),(273,123,0,1,16,4),(273,126,0,1,16,4),(273,127,0,1,16,4),(274,122,0,1,16,4),(274,123,0,1,16,4),(274,125,0,1,16,4),(274,126,0,1,16,4),(274,129,0,1,16,4),(275,120,0,1,16,4),(275,121,0,1,16,4),(275,122,0,1,16,4),(275,123,0,1,16,4),(275,124,0,1,16,4),(275,125,0,1,16,4),(275,126,0,1,16,4),(275,127,0,1,16,4),(275,128,0,1,16,4),(275,129,0,1,16,4),(275,130,0,1,16,4),(275,131,0,1,16,4),(276,122,0,1,16,4),(276,123,0,1,16,4),(276,127,0,1,16,4),(276,129,0,1,16,4),(277,120,0,1,16,4),(277,121,0,1,16,4),(277,123,0,1,16,4),(277,124,0,1,16,4),(277,125,0,1,16,4),(277,126,0,1,16,4),(277,127,0,1,16,4),(278,120,0,1,16,4),(278,121,0,1,16,4),(278,122,0,1,16,4),(278,123,0,1,16,4),(278,124,0,1,16,4),(278,125,0,1,16,4),(278,127,0,1,16,4),(278,128,0,1,16,4),(278,129,0,1,16,4),(279,120,0,1,16,4),(279,122,0,1,16,4),(279,126,0,1,16,4),(279,127,0,1,16,4),(279,129,0,1,16,4),(280,132,0,1,16,4),(280,133,0,1,16,4),(280,134,0,1,16,4),(280,135,0,1,16,4),(280,136,0,1,16,4),(280,137,0,1,16,4),(280,138,0,1,16,4),(280,139,0,1,16,4),(282,132,0,1,16,4),(282,133,0,1,16,4),(282,134,0,1,16,4),(282,137,0,1,16,4),(282,138,0,1,16,4),(283,135,0,1,16,4),(283,136,0,1,16,4),(283,139,0,1,16,4),(286,140,0,1,16,4),(286,141,0,1,16,4),(286,142,0,1,16,4),(286,143,0,1,16,4),(286,144,0,1,16,4),(286,145,0,1,16,4),(286,146,0,1,16,4),(286,147,0,1,16,4),(286,148,0,1,16,4),(286,149,0,1,16,4),(286,150,0,1,16,4),(286,151,0,1,16,4),(286,152,0,1,16,4),(286,153,0,1,16,4),(286,154,0,1,16,4),(286,155,0,1,16,4),(286,156,0,1,16,4),(286,157,0,1,16,4),(286,158,0,1,16,4),(286,159,0,1,16,4),(286,160,0,1,16,4),(286,161,0,1,16,4),(286,162,0,1,16,4),(286,163,0,1,16,4),(286,164,0,1,16,4),(286,165,0,1,16,4),(286,166,0,1,16,4),(286,167,0,1,16,4),(286,168,0,1,16,4),(286,169,0,1,16,4),(286,170,0,1,16,4),(286,171,0,1,16,4),(286,172,0,1,16,4),(286,173,0,1,16,4),(286,174,0,1,16,4),(286,175,0,1,16,4),(286,176,0,1,16,4),(286,177,0,1,16,4),(286,178,0,1,16,4),(286,179,0,1,16,4),(286,180,0,1,16,4),(286,181,0,1,16,4),(286,182,0,1,16,4),(286,183,0,1,16,4),(286,184,0,1,16,4),(286,185,0,1,16,4),(286,186,0,1,16,4),(286,187,0,1,16,4),(287,188,0,1,16,4),(288,189,0,1,16,4),(288,190,0,1,16,4),(288,191,0,1,16,4),(288,192,0,1,16,4),(288,193,0,1,16,4),(288,194,0,1,16,4),(288,195,0,1,16,4),(288,196,0,1,16,4),(288,197,0,1,16,4),(288,198,0,1,16,4),(288,199,0,1,16,4),(288,200,0,1,16,4),(289,201,10000,0,16,4),(289,202,10000,0,16,4),(289,203,10000,0,16,4),(289,204,10000,0,16,4),(289,205,10000,0,16,4),(289,206,10000,0,16,4),(289,207,10000,0,16,4),(289,208,10000,0,16,4),(289,209,10000,0,16,4),(289,210,10000,0,16,4),(289,211,10000,0,16,4),(289,212,10000,0,16,4),(289,213,10000,0,16,4),(289,214,10000,0,16,4),(289,215,10000,0,16,4),(289,216,10000,0,16,4),(289,217,10000,0,16,4),(289,218,10000,0,16,4),(289,219,10000,0,16,4),(289,220,10000,0,16,4),(289,221,10000,0,16,4),(289,222,10000,0,16,4),(289,223,10000,0,16,4),(289,224,10000,0,16,4),(289,225,10000,0,16,4),(289,226,10000,0,16,4),(289,227,10000,0,16,4),(289,228,10000,0,16,4),(289,229,10000,0,16,4),(289,230,10000,0,16,4),(289,231,10000,0,16,4),(289,232,10000,0,16,4),(289,244,10000,0,16,4),(289,246,10000,0,16,4),(289,251,10000,0,16,4),(289,255,10000,0,16,4),(289,258,10000,0,16,4),(289,259,10000,0,16,4),(289,260,10000,0,16,4),(289,261,10000,0,16,4),(289,262,10000,0,16,4),(289,263,10000,0,16,4),(290,209,0,1,16,4),(290,210,0,1,16,4),(290,211,0,1,16,4),(290,212,0,1,16,4),(290,213,0,1,16,4),(290,214,0,1,16,4),(290,215,0,1,16,4),(290,216,0,1,16,4),(291,201,0,1,16,4),(291,202,0,1,16,4),(291,203,0,1,16,4),(291,204,0,1,16,4),(291,205,0,1,16,4),(291,206,0,1,16,4),(291,207,0,1,16,4),(291,208,0,1,16,4),(292,217,0,1,16,4),(292,218,0,1,16,4),(292,219,0,1,16,4),(292,220,0,1,16,4),(292,221,0,1,16,4),(292,222,0,1,16,4),(292,223,0,1,16,4),(292,224,0,1,16,4),(293,225,0,1,16,4),(293,226,0,1,16,4),(293,227,0,1,16,4),(293,228,0,1,16,4),(293,229,0,1,16,4),(293,230,0,1,16,4),(293,231,0,1,16,4),(293,232,0,1,16,4),(293,255,0,1,16,4),(293,259,0,1,16,4),(293,260,0,1,16,4),(293,261,0,1,16,4),(293,262,0,1,16,4),(293,263,0,1,16,4),(294,233,0,1,16,4),(294,234,0,1,16,4),(294,235,0,1,16,4),(294,236,0,1,16,4),(294,237,0,1,16,4),(294,238,0,1,16,4),(294,239,0,1,16,4),(294,240,0,1,16,4),(294,241,0,1,16,4),(295,244,0,1,16,4),(295,246,0,1,16,4),(295,251,0,1,16,4),(295,255,0,1,16,4),(295,258,0,1,16,4),(296,251,0,1,16,4),(296,255,0,1,16,4),(296,258,0,1,16,4),(297,246,0,1,16,4),(297,255,0,1,16,4),(297,258,0,1,16,4),(298,255,0,1,16,4),(298,258,0,1,16,4),(299,251,0,1,16,4),(299,258,0,1,16,4);
/*!40000 ALTER TABLE `catalog_category_product_index_store16_replica` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index_store17`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store17`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store17` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `CAT_CTGR_PRD_IDX_STORE17_PRD_ID_STORE_ID_CTGR_ID_VISIBILITY` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_7DB8B0AEC370845BCF75B550C2A66F47` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Product Index Store17';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index_store17`
--

LOCK TABLES `catalog_category_product_index_store17` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index_store17` DISABLE KEYS */;
INSERT INTO `catalog_category_product_index_store17` VALUES (2,1,0,1,17,4),(2,2,0,1,17,4),(2,3,0,1,17,4),(2,4,0,1,17,4),(2,5,0,1,17,4),(2,6,0,1,17,4),(2,7,0,1,17,4),(2,8,0,1,17,4),(2,9,0,1,17,4),(2,10,0,1,17,4),(2,11,0,1,17,4),(2,12,0,1,17,4),(2,13,0,1,17,4),(2,14,0,1,17,4),(2,15,0,1,17,4),(2,16,0,1,17,4),(2,17,0,1,17,4),(2,18,0,1,17,4),(2,19,0,1,17,4),(2,20,0,1,17,4),(2,21,0,1,17,4),(2,22,0,1,17,4),(2,23,0,1,17,4),(2,24,0,1,17,4),(2,25,0,1,17,4),(2,26,0,1,17,4),(2,27,0,1,17,4),(2,28,0,1,17,4),(2,29,0,1,17,4),(2,30,0,1,17,4),(2,31,0,1,17,4),(2,32,0,1,17,4),(2,33,0,1,17,4),(2,34,0,1,17,4),(2,35,0,1,17,4),(2,36,0,1,17,4),(2,37,0,1,17,4),(2,38,0,1,17,4),(2,39,0,1,17,4),(2,40,0,1,17,4),(2,41,0,1,17,4),(2,42,0,1,17,4),(2,43,0,1,17,4),(2,44,0,1,17,4),(2,45,0,1,17,4),(2,46,0,1,17,4),(2,47,0,1,17,4),(2,48,0,1,17,4),(2,49,0,1,17,4),(2,50,0,1,17,4),(2,57,0,1,17,4),(2,58,0,1,17,4),(2,59,0,1,17,4),(2,60,0,1,17,4),(2,61,0,1,17,4),(2,62,0,1,17,4),(2,63,0,1,17,4),(2,64,0,1,17,4),(2,65,0,1,17,4),(2,66,0,1,17,4),(2,68,0,1,17,4),(2,69,0,1,17,4),(2,70,0,1,17,4),(2,71,0,1,17,4),(2,72,0,1,17,4),(2,73,0,1,17,4),(2,74,0,1,17,4),(2,75,0,1,17,4),(2,76,0,1,17,4),(2,77,0,1,17,4),(2,78,0,1,17,4),(2,79,0,1,17,4),(2,80,0,1,17,4),(2,81,0,1,17,4),(2,82,0,1,17,4),(2,83,0,1,17,4),(2,84,0,1,17,4),(2,85,0,1,17,4),(2,86,0,1,17,4),(2,87,0,1,17,4),(2,88,0,1,17,4),(2,89,0,1,17,4),(2,90,0,1,17,4),(2,91,0,1,17,4),(2,92,0,1,17,4),(2,93,0,1,17,4),(2,94,0,1,17,4),(2,95,0,1,17,4),(2,96,0,1,17,4),(2,97,0,1,17,4),(2,98,0,1,17,4),(2,99,0,1,17,4),(2,100,0,1,17,4),(2,101,0,1,17,4),(2,102,0,1,17,4),(2,103,0,1,17,4),(2,104,0,1,17,4),(2,105,0,1,17,4),(2,106,0,1,17,4),(2,107,0,1,17,4),(2,108,0,1,17,4),(2,109,0,1,17,4),(2,110,0,1,17,4),(2,111,0,1,17,4),(2,112,0,1,17,4),(2,113,0,1,17,4),(2,114,0,1,17,4),(2,115,0,1,17,4),(2,116,0,1,17,4),(2,117,0,1,17,4),(2,118,0,1,17,4),(2,119,0,1,17,4),(2,120,0,1,17,4),(2,121,0,1,17,4),(2,122,0,1,17,4),(2,123,0,1,17,4),(2,124,0,1,17,4),(2,125,0,1,17,4),(2,126,0,1,17,4),(2,127,0,1,17,4),(2,128,0,1,17,4),(2,129,0,1,17,4),(2,130,0,1,17,4),(2,131,0,1,17,4),(2,132,0,1,17,4),(2,133,0,1,17,4),(2,134,0,1,17,4),(2,135,0,1,17,4),(2,136,0,1,17,4),(2,137,0,1,17,4),(2,138,0,1,17,4),(2,139,0,1,17,4),(2,140,0,1,17,4),(2,141,0,1,17,4),(2,142,0,1,17,4),(2,143,0,1,17,4),(2,144,0,1,17,4),(2,145,0,1,17,4),(2,146,0,1,17,4),(2,147,0,1,17,4),(2,148,0,1,17,4),(2,149,0,1,17,4),(2,150,0,1,17,4),(2,151,0,1,17,4),(2,152,0,1,17,4),(2,153,0,1,17,4),(2,154,0,1,17,4),(2,155,0,1,17,4),(2,156,0,1,17,4),(2,157,0,1,17,4),(2,158,0,1,17,4),(2,159,0,1,17,4),(2,160,0,1,17,4),(2,161,0,1,17,4),(2,162,0,1,17,4),(2,163,0,1,17,4),(2,164,0,1,17,4),(2,165,0,1,17,4),(2,166,0,1,17,4),(2,167,0,1,17,4),(2,168,0,1,17,4),(2,169,0,1,17,4),(2,170,0,1,17,4),(2,171,0,1,17,4),(2,172,0,1,17,4),(2,173,0,1,17,4),(2,174,0,1,17,4),(2,175,0,1,17,4),(2,176,0,1,17,4),(2,177,0,1,17,4),(2,178,0,1,17,4),(2,179,0,1,17,4),(2,180,0,1,17,4),(2,181,0,1,17,4),(2,182,0,1,17,4),(2,183,0,1,17,4),(2,184,0,1,17,4),(2,185,0,1,17,4),(2,186,0,1,17,4),(2,187,0,1,17,4),(2,188,0,1,17,4),(2,189,0,1,17,4),(2,190,0,1,17,4),(2,191,0,1,17,4),(2,192,0,1,17,4),(2,193,0,1,17,4),(2,194,0,1,17,4),(2,195,0,1,17,4),(2,196,0,1,17,4),(2,197,0,1,17,4),(2,198,0,1,17,4),(2,199,0,1,17,4),(2,200,0,1,17,4),(2,201,0,1,17,4),(2,202,0,1,17,4),(2,203,0,1,17,4),(2,204,0,1,17,4),(2,205,0,1,17,4),(2,206,0,1,17,4),(2,207,0,1,17,4),(2,208,0,1,17,4),(2,209,0,1,17,4),(2,210,0,1,17,4),(2,211,0,1,17,4),(2,212,0,1,17,4),(2,213,0,1,17,4),(2,214,0,1,17,4),(2,215,0,1,17,4),(2,216,0,1,17,4),(2,217,0,1,17,4),(2,218,0,1,17,4),(2,219,0,1,17,4),(2,220,0,1,17,4),(2,221,0,1,17,4),(2,222,0,1,17,4),(2,223,0,1,17,4),(2,224,0,1,17,4),(2,225,0,1,17,4),(2,226,0,1,17,4),(2,227,0,1,17,4),(2,228,0,1,17,4),(2,229,0,1,17,4),(2,230,0,1,17,4),(2,231,0,1,17,4),(2,232,0,1,17,4),(2,233,0,1,17,4),(2,234,0,1,17,4),(2,235,0,1,17,4),(2,236,0,1,17,4),(2,237,0,1,17,4),(2,238,0,1,17,4),(2,239,0,1,17,4),(2,240,0,1,17,4),(2,241,0,1,17,4),(2,244,0,1,17,4),(2,246,0,1,17,4),(2,251,0,1,17,4),(2,255,0,1,17,4),(2,258,0,1,17,4),(2,259,0,1,17,4),(2,260,0,1,17,4),(2,261,0,1,17,4),(2,262,0,1,17,4),(2,263,0,1,17,4),(3,1,0,1,17,4),(3,2,0,1,17,4),(3,3,0,1,17,4),(3,4,0,1,17,4),(3,5,0,1,17,4),(3,6,0,1,17,4),(3,7,0,1,17,4),(3,8,0,1,17,4),(3,10,0,1,17,4),(3,11,0,1,17,4),(4,12,0,1,17,4),(4,13,0,1,17,4),(4,14,0,1,17,4),(4,15,0,1,17,4),(4,16,0,1,17,4),(4,17,0,1,17,4),(4,18,0,1,17,4),(4,19,0,1,17,4),(4,36,0,1,17,4),(4,37,0,1,17,4),(4,38,0,1,17,4),(4,39,0,1,17,4),(4,40,0,1,17,4),(5,95,10000,0,17,4),(5,96,10000,0,17,4),(5,97,10000,0,17,4),(5,98,10000,0,17,4),(5,99,10000,0,17,4),(5,100,10000,0,17,4),(7,101,10000,0,17,4),(7,102,10000,0,17,4),(7,103,10000,0,17,4),(7,104,10000,0,17,4),(7,105,10000,0,17,4),(7,106,10000,0,17,4),(7,107,10000,0,17,4),(7,108,10000,0,17,4),(7,109,10000,0,17,4),(7,110,10000,0,17,4),(7,111,10000,0,17,4),(7,112,10000,0,17,4),(7,21,0,1,17,4),(7,22,0,1,17,4),(7,26,0,1,17,4),(8,61,0,1,17,4),(8,62,0,1,17,4),(8,63,0,1,17,4),(8,64,0,1,17,4),(8,65,0,1,17,4),(8,66,0,1,17,4),(11,4,10000,0,17,4),(11,89,10000,0,17,4),(11,90,10000,0,17,4),(11,91,10000,0,17,4),(11,92,10000,0,17,4),(11,93,10000,0,17,4),(11,94,10000,0,17,4),(11,28,0,1,17,4),(11,29,0,1,17,4),(11,30,0,1,17,4),(11,31,0,1,17,4),(11,32,0,1,17,4),(11,33,0,1,17,4),(11,34,0,1,17,4),(11,35,0,1,17,4),(13,21,0,1,17,4),(13,24,0,1,17,4),(13,25,0,1,17,4),(13,26,0,1,17,4),(13,27,0,1,17,4),(13,41,0,1,17,4),(13,42,0,1,17,4),(13,43,0,1,17,4),(13,44,0,1,17,4),(13,45,0,1,17,4),(13,46,0,1,17,4),(13,47,0,1,17,4),(13,48,0,1,17,4),(13,49,0,1,17,4),(15,22,10000,0,17,4),(15,23,10000,0,17,4),(16,20,0,1,17,4),(16,21,0,1,17,4),(16,22,0,1,17,4),(16,23,0,1,17,4),(16,24,0,1,17,4),(16,25,0,1,17,4),(16,26,0,1,17,4),(16,27,0,1,17,4),(16,41,0,1,17,4),(16,68,0,1,17,4),(16,69,0,1,17,4),(16,70,0,1,17,4),(16,71,0,1,17,4),(16,72,0,1,17,4),(16,73,0,1,17,4),(19,6,0,1,17,4),(19,7,0,1,17,4),(19,8,0,1,17,4),(19,10,0,1,17,4),(19,11,0,1,17,4),(27,11,0,1,17,4),(29,6,0,1,17,4),(29,8,0,1,17,4),(29,10,0,1,17,4),(30,6,0,1,17,4),(30,10,0,1,17,4),(33,7,0,1,17,4),(33,8,0,1,17,4),(33,10,0,1,17,4),(33,11,0,1,17,4),(42,7,0,1,17,4),(42,8,0,1,17,4),(42,11,0,1,17,4),(78,21,0,1,17,4),(78,26,0,1,17,4),(80,21,0,1,17,4),(80,22,0,1,17,4),(80,26,0,1,17,4),(81,26,0,1,17,4),(82,26,0,1,17,4),(83,26,0,1,17,4),(96,26,0,1,17,4),(97,26,0,1,17,4),(98,21,0,1,17,4),(98,22,0,1,17,4),(98,26,0,1,17,4),(99,18,0,1,17,4),(101,14,0,1,17,4),(101,15,0,1,17,4),(101,16,0,1,17,4),(102,12,0,1,17,4),(102,13,0,1,17,4),(102,14,0,1,17,4),(102,15,0,1,17,4),(102,16,0,1,17,4),(102,17,0,1,17,4),(102,19,0,1,17,4),(102,36,0,1,17,4),(102,37,0,1,17,4),(102,38,0,1,17,4),(102,39,0,1,17,4),(102,40,0,1,17,4),(103,18,0,1,17,4),(104,18,0,1,17,4),(105,18,0,1,17,4),(106,18,0,1,17,4),(107,18,0,1,17,4),(134,23,0,1,17,4),(135,22,0,1,17,4),(137,4,0,1,17,4),(137,28,0,1,17,4),(137,31,0,1,17,4),(137,34,0,1,17,4),(137,35,0,1,17,4),(138,28,0,1,17,4),(138,30,0,1,17,4),(138,32,0,1,17,4),(138,33,0,1,17,4),(139,28,0,1,17,4),(139,30,0,1,17,4),(139,32,0,1,17,4),(139,33,0,1,17,4),(140,28,0,1,17,4),(140,30,0,1,17,4),(140,32,0,1,17,4),(140,33,0,1,17,4),(145,1,0,1,17,4),(145,2,0,1,17,4),(145,3,0,1,17,4),(145,4,0,1,17,4),(145,5,0,1,17,4),(145,6,0,1,17,4),(145,7,0,1,17,4),(145,8,0,1,17,4),(145,9,0,1,17,4),(145,10,0,1,17,4),(145,11,0,1,17,4),(145,12,0,1,17,4),(145,13,0,1,17,4),(145,14,0,1,17,4),(145,15,0,1,17,4),(145,16,0,1,17,4),(145,17,0,1,17,4),(145,18,0,1,17,4),(145,19,0,1,17,4),(145,20,0,1,17,4),(145,21,0,1,17,4),(145,22,0,1,17,4),(145,23,0,1,17,4),(145,24,0,1,17,4),(145,25,0,1,17,4),(145,26,0,1,17,4),(145,27,0,1,17,4),(145,28,0,1,17,4),(145,29,0,1,17,4),(145,30,0,1,17,4),(145,31,0,1,17,4),(145,32,0,1,17,4),(145,33,0,1,17,4),(145,34,0,1,17,4),(145,35,0,1,17,4),(145,36,0,1,17,4),(145,37,0,1,17,4),(145,38,0,1,17,4),(145,39,0,1,17,4),(145,40,0,1,17,4),(145,41,0,1,17,4),(145,42,0,1,17,4),(145,43,0,1,17,4),(149,41,0,1,17,4),(150,50,0,1,17,4),(150,57,0,1,17,4),(150,58,0,1,17,4),(150,59,0,1,17,4),(150,60,0,1,17,4),(151,61,0,1,17,4),(151,62,0,1,17,4),(151,63,0,1,17,4),(151,64,0,1,17,4),(151,65,0,1,17,4),(151,66,0,1,17,4),(152,61,0,1,17,4),(152,63,0,1,17,4),(153,61,0,1,17,4),(153,63,0,1,17,4),(153,64,0,1,17,4),(153,65,0,1,17,4),(153,66,0,1,17,4),(154,61,0,1,17,4),(154,62,0,1,17,4),(154,64,0,1,17,4),(154,66,0,1,17,4),(155,61,0,1,17,4),(155,62,0,1,17,4),(155,64,0,1,17,4),(155,65,0,1,17,4),(155,66,0,1,17,4),(156,61,0,1,17,4),(156,62,0,1,17,4),(156,63,0,1,17,4),(156,64,0,1,17,4),(156,65,0,1,17,4),(156,66,0,1,17,4),(157,61,0,1,17,4),(157,62,0,1,17,4),(157,64,0,1,17,4),(157,65,0,1,17,4),(157,66,0,1,17,4),(158,61,0,1,17,4),(158,63,0,1,17,4),(158,64,0,1,17,4),(158,65,0,1,17,4),(158,66,0,1,17,4),(159,61,0,1,17,4),(159,62,0,1,17,4),(159,63,0,1,17,4),(159,64,0,1,17,4),(159,65,0,1,17,4),(159,66,0,1,17,4),(160,41,0,1,17,4),(160,68,0,1,17,4),(160,69,0,1,17,4),(160,70,0,1,17,4),(160,72,0,1,17,4),(160,73,0,1,17,4),(161,68,0,1,17,4),(161,69,0,1,17,4),(161,70,0,1,17,4),(161,71,0,1,17,4),(161,72,0,1,17,4),(162,68,0,1,17,4),(162,69,0,1,17,4),(162,72,0,1,17,4),(164,41,0,1,17,4),(164,70,0,1,17,4),(164,73,0,1,17,4),(166,41,0,1,17,4),(166,70,0,1,17,4),(166,73,0,1,17,4),(167,68,0,1,17,4),(167,69,0,1,17,4),(167,72,0,1,17,4),(168,71,0,1,17,4),(169,70,0,1,17,4),(171,70,0,1,17,4),(172,1,10000,0,17,4),(172,2,10000,0,17,4),(172,3,10000,0,17,4),(172,4,10000,0,17,4),(172,5,10000,0,17,4),(172,6,10000,0,17,4),(172,7,10000,0,17,4),(172,8,10000,0,17,4),(172,9,10000,0,17,4),(172,10,10000,0,17,4),(172,11,10000,0,17,4),(172,12,10000,0,17,4),(172,13,10000,0,17,4),(172,14,10000,0,17,4),(172,15,10000,0,17,4),(172,16,10000,0,17,4),(172,17,10000,0,17,4),(172,18,10000,0,17,4),(172,19,10000,0,17,4),(172,20,10000,0,17,4),(172,21,10000,0,17,4),(172,22,10000,0,17,4),(172,23,10000,0,17,4),(172,24,10000,0,17,4),(172,25,10000,0,17,4),(172,26,10000,0,17,4),(172,27,10000,0,17,4),(172,28,10000,0,17,4),(172,29,10000,0,17,4),(172,30,10000,0,17,4),(173,1,0,1,17,4),(173,2,0,1,17,4),(173,3,0,1,17,4),(173,4,0,1,17,4),(173,5,0,1,17,4),(173,6,0,1,17,4),(173,7,0,1,17,4),(173,8,0,1,17,4),(173,9,0,1,17,4),(173,10,0,1,17,4),(173,11,0,1,17,4),(173,12,0,1,17,4),(173,13,0,1,17,4),(173,14,0,1,17,4),(173,15,0,1,17,4),(173,16,0,1,17,4),(173,17,0,1,17,4),(173,18,0,1,17,4),(173,19,0,1,17,4),(173,20,0,1,17,4),(173,21,0,1,17,4),(173,22,0,1,17,4),(173,23,0,1,17,4),(173,24,0,1,17,4),(173,25,0,1,17,4),(173,26,0,1,17,4),(173,27,0,1,17,4),(173,28,0,1,17,4),(173,29,0,1,17,4),(173,30,0,1,17,4),(174,1,0,1,17,4),(174,2,0,1,17,4),(174,3,0,1,17,4),(174,4,0,1,17,4),(174,5,0,1,17,4),(174,6,0,1,17,4),(174,7,0,1,17,4),(174,8,0,1,17,4),(174,9,0,1,17,4),(174,10,0,1,17,4),(174,11,0,1,17,4),(174,12,0,1,17,4),(174,13,0,1,17,4),(174,14,0,1,17,4),(174,15,0,1,17,4),(174,16,0,1,17,4),(174,17,0,1,17,4),(174,18,0,1,17,4),(174,19,0,1,17,4),(174,20,0,1,17,4),(174,21,0,1,17,4),(174,22,0,1,17,4),(174,23,0,1,17,4),(174,24,0,1,17,4),(174,25,0,1,17,4),(174,26,0,1,17,4),(174,27,0,1,17,4),(174,28,0,1,17,4),(174,29,0,1,17,4),(174,30,0,1,17,4),(175,1,0,1,17,4),(175,2,0,1,17,4),(175,3,0,1,17,4),(175,4,0,1,17,4),(175,5,0,1,17,4),(175,6,0,1,17,4),(175,7,0,1,17,4),(175,8,0,1,17,4),(175,9,0,1,17,4),(175,10,0,1,17,4),(175,11,0,1,17,4),(175,12,0,1,17,4),(175,13,0,1,17,4),(175,14,0,1,17,4),(175,15,0,1,17,4),(175,16,0,1,17,4),(175,17,0,1,17,4),(175,18,0,1,17,4),(175,19,0,1,17,4),(175,20,0,1,17,4),(175,21,0,1,17,4),(175,22,0,1,17,4),(175,23,0,1,17,4),(175,24,0,1,17,4),(175,25,0,1,17,4),(175,26,0,1,17,4),(175,27,0,1,17,4),(175,28,0,1,17,4),(175,29,0,1,17,4),(175,30,0,1,17,4),(176,1,0,1,17,4),(176,2,0,1,17,4),(176,3,0,1,17,4),(176,4,0,1,17,4),(176,5,0,1,17,4),(176,6,0,1,17,4),(176,7,0,1,17,4),(176,8,0,1,17,4),(176,9,0,1,17,4),(176,10,0,1,17,4),(176,11,0,1,17,4),(176,12,0,1,17,4),(176,13,0,1,17,4),(176,14,0,1,17,4),(176,15,0,1,17,4),(176,16,0,1,17,4),(176,17,0,1,17,4),(176,18,0,1,17,4),(176,19,0,1,17,4),(176,20,0,1,17,4),(176,21,0,1,17,4),(176,22,0,1,17,4),(176,23,0,1,17,4),(176,24,0,1,17,4),(176,25,0,1,17,4),(176,26,0,1,17,4),(176,27,0,1,17,4),(176,28,0,1,17,4),(176,29,0,1,17,4),(176,30,0,1,17,4),(177,74,0,1,17,4),(177,75,0,1,17,4),(177,76,0,1,17,4),(177,77,0,1,17,4),(177,78,0,1,17,4),(177,79,0,1,17,4),(177,80,0,1,17,4),(178,74,10000,0,17,4),(178,75,10000,0,17,4),(178,76,10000,0,17,4),(178,77,10000,0,17,4),(178,78,10000,0,17,4),(178,79,10000,0,17,4),(178,80,10000,0,17,4),(178,81,10000,0,17,4),(178,82,10000,0,17,4),(178,83,10000,0,17,4),(178,84,10000,0,17,4),(178,85,10000,0,17,4),(178,86,10000,0,17,4),(178,87,10000,0,17,4),(178,88,10000,0,17,4),(178,113,10000,0,17,4),(178,114,10000,0,17,4),(178,115,10000,0,17,4),(178,116,10000,0,17,4),(178,117,10000,0,17,4),(178,118,10000,0,17,4),(178,119,10000,0,17,4),(178,120,10000,0,17,4),(178,121,10000,0,17,4),(178,122,10000,0,17,4),(178,123,10000,0,17,4),(178,124,10000,0,17,4),(178,125,10000,0,17,4),(178,126,10000,0,17,4),(178,127,10000,0,17,4),(178,128,10000,0,17,4),(178,129,10000,0,17,4),(178,130,10000,0,17,4),(178,131,10000,0,17,4),(178,132,10000,0,17,4),(178,133,10000,0,17,4),(178,134,10000,0,17,4),(178,135,10000,0,17,4),(178,136,10000,0,17,4),(178,137,10000,0,17,4),(178,138,10000,0,17,4),(178,139,10000,0,17,4),(178,140,10000,0,17,4),(178,141,10000,0,17,4),(178,142,10000,0,17,4),(178,143,10000,0,17,4),(178,144,10000,0,17,4),(178,145,10000,0,17,4),(178,146,10000,0,17,4),(178,147,10000,0,17,4),(178,148,10000,0,17,4),(178,149,10000,0,17,4),(178,150,10000,0,17,4),(178,151,10000,0,17,4),(178,152,10000,0,17,4),(178,153,10000,0,17,4),(178,154,10000,0,17,4),(178,155,10000,0,17,4),(178,156,10000,0,17,4),(178,157,10000,0,17,4),(178,158,10000,0,17,4),(178,159,10000,0,17,4),(178,160,10000,0,17,4),(178,161,10000,0,17,4),(178,162,10000,0,17,4),(178,163,10000,0,17,4),(178,164,10000,0,17,4),(178,165,10000,0,17,4),(178,166,10000,0,17,4),(178,167,10000,0,17,4),(178,168,10000,0,17,4),(178,169,10000,0,17,4),(178,170,10000,0,17,4),(178,171,10000,0,17,4),(178,172,10000,0,17,4),(178,173,10000,0,17,4),(178,174,10000,0,17,4),(178,175,10000,0,17,4),(178,176,10000,0,17,4),(178,177,10000,0,17,4),(178,178,10000,0,17,4),(178,179,10000,0,17,4),(178,180,10000,0,17,4),(178,181,10000,0,17,4),(178,182,10000,0,17,4),(178,183,10000,0,17,4),(178,184,10000,0,17,4),(178,185,10000,0,17,4),(178,186,10000,0,17,4),(178,187,10000,0,17,4),(178,188,10000,0,17,4),(178,189,10000,0,17,4),(178,190,10000,0,17,4),(178,191,10000,0,17,4),(178,192,10000,0,17,4),(178,193,10000,0,17,4),(178,194,10000,0,17,4),(178,195,10000,0,17,4),(178,196,10000,0,17,4),(178,197,10000,0,17,4),(178,198,10000,0,17,4),(178,199,10000,0,17,4),(178,200,10000,0,17,4),(178,201,10000,0,17,4),(178,202,10000,0,17,4),(178,203,10000,0,17,4),(178,204,10000,0,17,4),(178,205,10000,0,17,4),(178,206,10000,0,17,4),(178,207,10000,0,17,4),(178,208,10000,0,17,4),(178,209,10000,0,17,4),(178,210,10000,0,17,4),(178,211,10000,0,17,4),(178,212,10000,0,17,4),(178,213,10000,0,17,4),(178,214,10000,0,17,4),(178,215,10000,0,17,4),(178,216,10000,0,17,4),(178,217,10000,0,17,4),(178,218,10000,0,17,4),(178,219,10000,0,17,4),(178,220,10000,0,17,4),(178,221,10000,0,17,4),(178,222,10000,0,17,4),(178,223,10000,0,17,4),(178,224,10000,0,17,4),(178,225,10000,0,17,4),(178,226,10000,0,17,4),(178,227,10000,0,17,4),(178,228,10000,0,17,4),(178,229,10000,0,17,4),(178,230,10000,0,17,4),(178,231,10000,0,17,4),(178,232,10000,0,17,4),(178,233,10000,0,17,4),(178,234,10000,0,17,4),(178,235,10000,0,17,4),(178,236,10000,0,17,4),(178,237,10000,0,17,4),(178,238,10000,0,17,4),(178,239,10000,0,17,4),(178,240,10000,0,17,4),(178,241,10000,0,17,4),(178,244,10000,0,17,4),(178,246,10000,0,17,4),(178,251,10000,0,17,4),(178,255,10000,0,17,4),(178,258,10000,0,17,4),(178,259,10000,0,17,4),(178,260,10000,0,17,4),(178,261,10000,0,17,4),(178,262,10000,0,17,4),(178,263,10000,0,17,4),(179,81,0,1,17,4),(179,82,0,1,17,4),(179,83,0,1,17,4),(179,84,0,1,17,4),(179,85,0,1,17,4),(179,86,0,1,17,4),(179,87,0,1,17,4),(179,88,0,1,17,4),(180,81,0,1,17,4),(181,86,0,1,17,4),(182,82,0,1,17,4),(182,83,0,1,17,4),(182,84,0,1,17,4),(182,85,0,1,17,4),(182,87,0,1,17,4),(182,88,0,1,17,4),(183,82,0,1,17,4),(183,83,0,1,17,4),(183,84,0,1,17,4),(183,85,0,1,17,4),(183,86,0,1,17,4),(183,87,0,1,17,4),(183,88,0,1,17,4),(192,89,0,1,17,4),(192,90,0,1,17,4),(192,91,0,1,17,4),(192,92,0,1,17,4),(192,93,0,1,17,4),(192,94,0,1,17,4),(193,95,0,1,17,4),(193,96,0,1,17,4),(193,97,0,1,17,4),(193,98,0,1,17,4),(193,99,0,1,17,4),(193,100,0,1,17,4),(194,95,0,1,17,4),(194,96,0,1,17,4),(194,97,0,1,17,4),(194,98,0,1,17,4),(194,99,0,1,17,4),(194,100,0,1,17,4),(195,95,0,1,17,4),(195,96,0,1,17,4),(195,97,0,1,17,4),(195,98,0,1,17,4),(195,99,0,1,17,4),(195,100,0,1,17,4),(196,95,0,1,17,4),(196,96,0,1,17,4),(196,97,0,1,17,4),(196,98,0,1,17,4),(196,99,0,1,17,4),(196,100,0,1,17,4),(197,95,0,1,17,4),(197,96,0,1,17,4),(197,97,0,1,17,4),(197,98,0,1,17,4),(197,99,0,1,17,4),(197,100,0,1,17,4),(198,101,0,1,17,4),(198,109,0,1,17,4),(198,111,0,1,17,4),(198,112,0,1,17,4),(199,103,0,1,17,4),(199,110,0,1,17,4),(200,101,0,1,17,4),(200,102,0,1,17,4),(200,108,0,1,17,4),(201,104,0,1,17,4),(201,106,0,1,17,4),(202,101,0,1,17,4),(202,102,0,1,17,4),(202,103,0,1,17,4),(202,105,0,1,17,4),(202,107,0,1,17,4),(202,108,0,1,17,4),(202,110,0,1,17,4),(203,101,0,1,17,4),(203,102,0,1,17,4),(203,103,0,1,17,4),(203,104,0,1,17,4),(203,106,0,1,17,4),(203,108,0,1,17,4),(203,109,0,1,17,4),(204,101,0,1,17,4),(204,102,0,1,17,4),(204,103,0,1,17,4),(204,104,0,1,17,4),(204,105,0,1,17,4),(204,106,0,1,17,4),(204,107,0,1,17,4),(204,108,0,1,17,4),(205,101,0,1,17,4),(205,102,0,1,17,4),(205,103,0,1,17,4),(205,108,0,1,17,4),(205,109,0,1,17,4),(205,110,0,1,17,4),(205,111,0,1,17,4),(205,112,0,1,17,4),(206,113,10000,0,17,4),(206,114,10000,0,17,4),(206,115,10000,0,17,4),(206,116,10000,0,17,4),(206,117,10000,0,17,4),(206,118,10000,0,17,4),(206,119,10000,0,17,4),(207,114,0,1,17,4),(207,119,0,1,17,4),(209,114,0,1,17,4),(212,116,0,1,17,4),(212,118,0,1,17,4),(213,113,0,1,17,4),(218,117,0,1,17,4),(219,119,0,1,17,4),(220,119,0,1,17,4),(221,119,0,1,17,4),(222,114,0,1,17,4),(222,119,0,1,17,4),(223,114,0,1,17,4),(223,119,0,1,17,4),(229,113,0,1,17,4),(230,113,0,1,17,4),(231,113,0,1,17,4),(232,113,0,1,17,4),(233,113,0,1,17,4),(234,116,0,1,17,4),(234,118,0,1,17,4),(235,116,0,1,17,4),(235,118,0,1,17,4),(236,116,0,1,17,4),(236,118,0,1,17,4),(237,116,0,1,17,4),(237,118,0,1,17,4),(238,116,0,1,17,4),(238,118,0,1,17,4),(239,115,0,1,17,4),(241,115,0,1,17,4),(242,115,0,1,17,4),(243,115,0,1,17,4),(250,120,0,1,17,4),(250,121,0,1,17,4),(250,122,0,1,17,4),(250,123,0,1,17,4),(250,124,0,1,17,4),(250,125,0,1,17,4),(250,126,0,1,17,4),(250,127,0,1,17,4),(250,128,0,1,17,4),(250,129,0,1,17,4),(250,130,0,1,17,4),(250,131,0,1,17,4),(251,120,0,1,17,4),(251,121,0,1,17,4),(251,122,0,1,17,4),(251,123,0,1,17,4),(251,124,0,1,17,4),(251,125,0,1,17,4),(251,126,0,1,17,4),(251,127,0,1,17,4),(251,128,0,1,17,4),(251,129,0,1,17,4),(251,130,0,1,17,4),(251,131,0,1,17,4),(252,125,10000,0,17,4),(252,126,10000,0,17,4),(252,127,10000,0,17,4),(252,120,0,1,17,4),(252,121,0,1,17,4),(252,122,0,1,17,4),(252,123,0,1,17,4),(252,124,0,1,17,4),(252,128,0,1,17,4),(252,129,0,1,17,4),(252,131,0,1,17,4),(253,120,0,1,17,4),(253,121,0,1,17,4),(253,122,0,1,17,4),(253,123,0,1,17,4),(253,124,0,1,17,4),(253,125,0,1,17,4),(253,126,0,1,17,4),(253,127,0,1,17,4),(253,128,0,1,17,4),(253,129,0,1,17,4),(253,130,0,1,17,4),(253,131,0,1,17,4),(254,120,0,1,17,4),(254,121,0,1,17,4),(254,122,0,1,17,4),(254,123,0,1,17,4),(254,124,0,1,17,4),(254,125,0,1,17,4),(254,126,0,1,17,4),(254,127,0,1,17,4),(254,128,0,1,17,4),(254,129,0,1,17,4),(254,130,0,1,17,4),(254,131,0,1,17,4),(255,122,0,1,17,4),(255,123,0,1,17,4),(255,124,0,1,17,4),(255,125,0,1,17,4),(255,126,0,1,17,4),(255,129,0,1,17,4),(256,121,0,1,17,4),(256,122,0,1,17,4),(256,123,0,1,17,4),(256,125,0,1,17,4),(256,126,0,1,17,4),(256,127,0,1,17,4),(257,121,0,1,17,4),(257,122,0,1,17,4),(257,123,0,1,17,4),(257,125,0,1,17,4),(257,127,0,1,17,4),(257,129,0,1,17,4),(258,121,0,1,17,4),(258,122,0,1,17,4),(258,125,0,1,17,4),(258,126,0,1,17,4),(258,127,0,1,17,4),(258,129,0,1,17,4),(259,120,0,1,17,4),(259,121,0,1,17,4),(259,123,0,1,17,4),(259,128,0,1,17,4),(259,129,0,1,17,4),(260,120,0,1,17,4),(260,121,0,1,17,4),(260,122,0,1,17,4),(260,123,0,1,17,4),(260,125,0,1,17,4),(260,127,0,1,17,4),(260,128,0,1,17,4),(260,129,0,1,17,4),(261,121,0,1,17,4),(261,122,0,1,17,4),(261,125,0,1,17,4),(261,126,0,1,17,4),(261,127,0,1,17,4),(261,129,0,1,17,4),(262,125,0,1,17,4),(262,126,0,1,17,4),(263,120,0,1,17,4),(263,121,0,1,17,4),(263,122,0,1,17,4),(263,123,0,1,17,4),(263,124,0,1,17,4),(263,128,0,1,17,4),(263,129,0,1,17,4),(263,131,0,1,17,4),(264,120,0,1,17,4),(264,122,0,1,17,4),(264,123,0,1,17,4),(264,125,0,1,17,4),(264,126,0,1,17,4),(264,129,0,1,17,4),(265,121,0,1,17,4),(265,122,0,1,17,4),(265,123,0,1,17,4),(265,127,0,1,17,4),(266,123,0,1,17,4),(266,125,0,1,17,4),(266,126,0,1,17,4),(266,127,0,1,17,4),(266,129,0,1,17,4),(267,121,0,1,17,4),(267,125,0,1,17,4),(267,126,0,1,17,4),(267,127,0,1,17,4),(268,120,0,1,17,4),(268,121,0,1,17,4),(268,122,0,1,17,4),(268,123,0,1,17,4),(268,124,0,1,17,4),(268,127,0,1,17,4),(268,129,0,1,17,4),(269,122,0,1,17,4),(269,125,0,1,17,4),(269,126,0,1,17,4),(269,127,0,1,17,4),(269,129,0,1,17,4),(270,121,0,1,17,4),(270,123,0,1,17,4),(270,125,0,1,17,4),(270,126,0,1,17,4),(270,129,0,1,17,4),(271,120,0,1,17,4),(271,121,0,1,17,4),(271,122,0,1,17,4),(271,125,0,1,17,4),(271,126,0,1,17,4),(271,127,0,1,17,4),(271,129,0,1,17,4),(272,122,0,1,17,4),(272,123,0,1,17,4),(272,124,0,1,17,4),(272,125,0,1,17,4),(272,126,0,1,17,4),(272,127,0,1,17,4),(272,128,0,1,17,4),(272,129,0,1,17,4),(273,120,0,1,17,4),(273,121,0,1,17,4),(273,123,0,1,17,4),(273,126,0,1,17,4),(273,127,0,1,17,4),(274,122,0,1,17,4),(274,123,0,1,17,4),(274,125,0,1,17,4),(274,126,0,1,17,4),(274,129,0,1,17,4),(275,120,0,1,17,4),(275,121,0,1,17,4),(275,122,0,1,17,4),(275,123,0,1,17,4),(275,124,0,1,17,4),(275,125,0,1,17,4),(275,126,0,1,17,4),(275,127,0,1,17,4),(275,128,0,1,17,4),(275,129,0,1,17,4),(275,130,0,1,17,4),(275,131,0,1,17,4),(276,122,0,1,17,4),(276,123,0,1,17,4),(276,127,0,1,17,4),(276,129,0,1,17,4),(277,120,0,1,17,4),(277,121,0,1,17,4),(277,123,0,1,17,4),(277,124,0,1,17,4),(277,125,0,1,17,4),(277,126,0,1,17,4),(277,127,0,1,17,4),(278,120,0,1,17,4),(278,121,0,1,17,4),(278,122,0,1,17,4),(278,123,0,1,17,4),(278,124,0,1,17,4),(278,125,0,1,17,4),(278,127,0,1,17,4),(278,128,0,1,17,4),(278,129,0,1,17,4),(279,120,0,1,17,4),(279,122,0,1,17,4),(279,126,0,1,17,4),(279,127,0,1,17,4),(279,129,0,1,17,4),(280,132,0,1,17,4),(280,133,0,1,17,4),(280,134,0,1,17,4),(280,135,0,1,17,4),(280,136,0,1,17,4),(280,137,0,1,17,4),(280,138,0,1,17,4),(280,139,0,1,17,4),(282,132,0,1,17,4),(282,133,0,1,17,4),(282,134,0,1,17,4),(282,137,0,1,17,4),(282,138,0,1,17,4),(283,135,0,1,17,4),(283,136,0,1,17,4),(283,139,0,1,17,4),(286,140,0,1,17,4),(286,141,0,1,17,4),(286,142,0,1,17,4),(286,143,0,1,17,4),(286,144,0,1,17,4),(286,145,0,1,17,4),(286,146,0,1,17,4),(286,147,0,1,17,4),(286,148,0,1,17,4),(286,149,0,1,17,4),(286,150,0,1,17,4),(286,151,0,1,17,4),(286,152,0,1,17,4),(286,153,0,1,17,4),(286,154,0,1,17,4),(286,155,0,1,17,4),(286,156,0,1,17,4),(286,157,0,1,17,4),(286,158,0,1,17,4),(286,159,0,1,17,4),(286,160,0,1,17,4),(286,161,0,1,17,4),(286,162,0,1,17,4),(286,163,0,1,17,4),(286,164,0,1,17,4),(286,165,0,1,17,4),(286,166,0,1,17,4),(286,167,0,1,17,4),(286,168,0,1,17,4),(286,169,0,1,17,4),(286,170,0,1,17,4),(286,171,0,1,17,4),(286,172,0,1,17,4),(286,173,0,1,17,4),(286,174,0,1,17,4),(286,175,0,1,17,4),(286,176,0,1,17,4),(286,177,0,1,17,4),(286,178,0,1,17,4),(286,179,0,1,17,4),(286,180,0,1,17,4),(286,181,0,1,17,4),(286,182,0,1,17,4),(286,183,0,1,17,4),(286,184,0,1,17,4),(286,185,0,1,17,4),(286,186,0,1,17,4),(286,187,0,1,17,4),(287,188,0,1,17,4),(288,189,0,1,17,4),(288,190,0,1,17,4),(288,191,0,1,17,4),(288,192,0,1,17,4),(288,193,0,1,17,4),(288,194,0,1,17,4),(288,195,0,1,17,4),(288,196,0,1,17,4),(288,197,0,1,17,4),(288,198,0,1,17,4),(288,199,0,1,17,4),(288,200,0,1,17,4),(289,201,10000,0,17,4),(289,202,10000,0,17,4),(289,203,10000,0,17,4),(289,204,10000,0,17,4),(289,205,10000,0,17,4),(289,206,10000,0,17,4),(289,207,10000,0,17,4),(289,208,10000,0,17,4),(289,209,10000,0,17,4),(289,210,10000,0,17,4),(289,211,10000,0,17,4),(289,212,10000,0,17,4),(289,213,10000,0,17,4),(289,214,10000,0,17,4),(289,215,10000,0,17,4),(289,216,10000,0,17,4),(289,217,10000,0,17,4),(289,218,10000,0,17,4),(289,219,10000,0,17,4),(289,220,10000,0,17,4),(289,221,10000,0,17,4),(289,222,10000,0,17,4),(289,223,10000,0,17,4),(289,224,10000,0,17,4),(289,225,10000,0,17,4),(289,226,10000,0,17,4),(289,227,10000,0,17,4),(289,228,10000,0,17,4),(289,229,10000,0,17,4),(289,230,10000,0,17,4),(289,231,10000,0,17,4),(289,232,10000,0,17,4),(289,244,10000,0,17,4),(289,246,10000,0,17,4),(289,251,10000,0,17,4),(289,255,10000,0,17,4),(289,258,10000,0,17,4),(289,259,10000,0,17,4),(289,260,10000,0,17,4),(289,261,10000,0,17,4),(289,262,10000,0,17,4),(289,263,10000,0,17,4),(290,209,0,1,17,4),(290,210,0,1,17,4),(290,211,0,1,17,4),(290,212,0,1,17,4),(290,213,0,1,17,4),(290,214,0,1,17,4),(290,215,0,1,17,4),(290,216,0,1,17,4),(291,201,0,1,17,4),(291,202,0,1,17,4),(291,203,0,1,17,4),(291,204,0,1,17,4),(291,205,0,1,17,4),(291,206,0,1,17,4),(291,207,0,1,17,4),(291,208,0,1,17,4),(292,217,0,1,17,4),(292,218,0,1,17,4),(292,219,0,1,17,4),(292,220,0,1,17,4),(292,221,0,1,17,4),(292,222,0,1,17,4),(292,223,0,1,17,4),(292,224,0,1,17,4),(293,225,0,1,17,4),(293,226,0,1,17,4),(293,227,0,1,17,4),(293,228,0,1,17,4),(293,229,0,1,17,4),(293,230,0,1,17,4),(293,231,0,1,17,4),(293,232,0,1,17,4),(293,255,0,1,17,4),(293,259,0,1,17,4),(293,260,0,1,17,4),(293,261,0,1,17,4),(293,262,0,1,17,4),(293,263,0,1,17,4),(294,233,0,1,17,4),(294,234,0,1,17,4),(294,235,0,1,17,4),(294,236,0,1,17,4),(294,237,0,1,17,4),(294,238,0,1,17,4),(294,239,0,1,17,4),(294,240,0,1,17,4),(294,241,0,1,17,4),(295,244,0,1,17,4),(295,246,0,1,17,4),(295,251,0,1,17,4),(295,255,0,1,17,4),(295,258,0,1,17,4),(296,251,0,1,17,4),(296,255,0,1,17,4),(296,258,0,1,17,4),(297,246,0,1,17,4),(297,255,0,1,17,4),(297,258,0,1,17,4),(298,255,0,1,17,4),(298,258,0,1,17,4),(299,251,0,1,17,4),(299,258,0,1,17,4);
/*!40000 ALTER TABLE `catalog_category_product_index_store17` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index_store17_replica`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store17_replica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store17_replica` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `IDX_537EBC4692CC4DCF8775BED1A7496D4E` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_E993A2D0EFF6EE785AA874FF5AED05BB` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Product Index Store17 Replica';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index_store17_replica`
--

LOCK TABLES `catalog_category_product_index_store17_replica` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index_store17_replica` DISABLE KEYS */;
INSERT INTO `catalog_category_product_index_store17_replica` VALUES (2,1,0,1,17,4),(2,2,0,1,17,4),(2,3,0,1,17,4),(2,4,0,1,17,4),(2,5,0,1,17,4),(2,6,0,1,17,4),(2,7,0,1,17,4),(2,8,0,1,17,4),(2,9,0,1,17,4),(2,10,0,1,17,4),(2,11,0,1,17,4),(2,12,0,1,17,4),(2,13,0,1,17,4),(2,14,0,1,17,4),(2,15,0,1,17,4),(2,16,0,1,17,4),(2,17,0,1,17,4),(2,18,0,1,17,4),(2,19,0,1,17,4),(2,20,0,1,17,4),(2,21,0,1,17,4),(2,22,0,1,17,4),(2,23,0,1,17,4),(2,24,0,1,17,4),(2,25,0,1,17,4),(2,26,0,1,17,4),(2,27,0,1,17,4),(2,28,0,1,17,4),(2,29,0,1,17,4),(2,30,0,1,17,4),(2,31,0,1,17,4),(2,32,0,1,17,4),(2,33,0,1,17,4),(2,34,0,1,17,4),(2,35,0,1,17,4),(2,36,0,1,17,4),(2,37,0,1,17,4),(2,38,0,1,17,4),(2,39,0,1,17,4),(2,40,0,1,17,4),(2,41,0,1,17,4),(2,42,0,1,17,4),(2,43,0,1,17,4),(2,44,0,1,17,4),(2,45,0,1,17,4),(2,46,0,1,17,4),(2,47,0,1,17,4),(2,48,0,1,17,4),(2,49,0,1,17,4),(2,50,0,1,17,4),(2,57,0,1,17,4),(2,58,0,1,17,4),(2,59,0,1,17,4),(2,60,0,1,17,4),(2,61,0,1,17,4),(2,62,0,1,17,4),(2,63,0,1,17,4),(2,64,0,1,17,4),(2,65,0,1,17,4),(2,66,0,1,17,4),(2,68,0,1,17,4),(2,69,0,1,17,4),(2,70,0,1,17,4),(2,71,0,1,17,4),(2,72,0,1,17,4),(2,73,0,1,17,4),(2,74,0,1,17,4),(2,75,0,1,17,4),(2,76,0,1,17,4),(2,77,0,1,17,4),(2,78,0,1,17,4),(2,79,0,1,17,4),(2,80,0,1,17,4),(2,81,0,1,17,4),(2,82,0,1,17,4),(2,83,0,1,17,4),(2,84,0,1,17,4),(2,85,0,1,17,4),(2,86,0,1,17,4),(2,87,0,1,17,4),(2,88,0,1,17,4),(2,89,0,1,17,4),(2,90,0,1,17,4),(2,91,0,1,17,4),(2,92,0,1,17,4),(2,93,0,1,17,4),(2,94,0,1,17,4),(2,95,0,1,17,4),(2,96,0,1,17,4),(2,97,0,1,17,4),(2,98,0,1,17,4),(2,99,0,1,17,4),(2,100,0,1,17,4),(2,101,0,1,17,4),(2,102,0,1,17,4),(2,103,0,1,17,4),(2,104,0,1,17,4),(2,105,0,1,17,4),(2,106,0,1,17,4),(2,107,0,1,17,4),(2,108,0,1,17,4),(2,109,0,1,17,4),(2,110,0,1,17,4),(2,111,0,1,17,4),(2,112,0,1,17,4),(2,113,0,1,17,4),(2,114,0,1,17,4),(2,115,0,1,17,4),(2,116,0,1,17,4),(2,117,0,1,17,4),(2,118,0,1,17,4),(2,119,0,1,17,4),(2,120,0,1,17,4),(2,121,0,1,17,4),(2,122,0,1,17,4),(2,123,0,1,17,4),(2,124,0,1,17,4),(2,125,0,1,17,4),(2,126,0,1,17,4),(2,127,0,1,17,4),(2,128,0,1,17,4),(2,129,0,1,17,4),(2,130,0,1,17,4),(2,131,0,1,17,4),(2,132,0,1,17,4),(2,133,0,1,17,4),(2,134,0,1,17,4),(2,135,0,1,17,4),(2,136,0,1,17,4),(2,137,0,1,17,4),(2,138,0,1,17,4),(2,139,0,1,17,4),(2,140,0,1,17,4),(2,141,0,1,17,4),(2,142,0,1,17,4),(2,143,0,1,17,4),(2,144,0,1,17,4),(2,145,0,1,17,4),(2,146,0,1,17,4),(2,147,0,1,17,4),(2,148,0,1,17,4),(2,149,0,1,17,4),(2,150,0,1,17,4),(2,151,0,1,17,4),(2,152,0,1,17,4),(2,153,0,1,17,4),(2,154,0,1,17,4),(2,155,0,1,17,4),(2,156,0,1,17,4),(2,157,0,1,17,4),(2,158,0,1,17,4),(2,159,0,1,17,4),(2,160,0,1,17,4),(2,161,0,1,17,4),(2,162,0,1,17,4),(2,163,0,1,17,4),(2,164,0,1,17,4),(2,165,0,1,17,4),(2,166,0,1,17,4),(2,167,0,1,17,4),(2,168,0,1,17,4),(2,169,0,1,17,4),(2,170,0,1,17,4),(2,171,0,1,17,4),(2,172,0,1,17,4),(2,173,0,1,17,4),(2,174,0,1,17,4),(2,175,0,1,17,4),(2,176,0,1,17,4),(2,177,0,1,17,4),(2,178,0,1,17,4),(2,179,0,1,17,4),(2,180,0,1,17,4),(2,181,0,1,17,4),(2,182,0,1,17,4),(2,183,0,1,17,4),(2,184,0,1,17,4),(2,185,0,1,17,4),(2,186,0,1,17,4),(2,187,0,1,17,4),(2,188,0,1,17,4),(2,189,0,1,17,4),(2,190,0,1,17,4),(2,191,0,1,17,4),(2,192,0,1,17,4),(2,193,0,1,17,4),(2,194,0,1,17,4),(2,195,0,1,17,4),(2,196,0,1,17,4),(2,197,0,1,17,4),(2,198,0,1,17,4),(2,199,0,1,17,4),(2,200,0,1,17,4),(2,201,0,1,17,4),(2,202,0,1,17,4),(2,203,0,1,17,4),(2,204,0,1,17,4),(2,205,0,1,17,4),(2,206,0,1,17,4),(2,207,0,1,17,4),(2,208,0,1,17,4),(2,209,0,1,17,4),(2,210,0,1,17,4),(2,211,0,1,17,4),(2,212,0,1,17,4),(2,213,0,1,17,4),(2,214,0,1,17,4),(2,215,0,1,17,4),(2,216,0,1,17,4),(2,217,0,1,17,4),(2,218,0,1,17,4),(2,219,0,1,17,4),(2,220,0,1,17,4),(2,221,0,1,17,4),(2,222,0,1,17,4),(2,223,0,1,17,4),(2,224,0,1,17,4),(2,225,0,1,17,4),(2,226,0,1,17,4),(2,227,0,1,17,4),(2,228,0,1,17,4),(2,229,0,1,17,4),(2,230,0,1,17,4),(2,231,0,1,17,4),(2,232,0,1,17,4),(2,233,0,1,17,4),(2,234,0,1,17,4),(2,235,0,1,17,4),(2,236,0,1,17,4),(2,237,0,1,17,4),(2,238,0,1,17,4),(2,239,0,1,17,4),(2,240,0,1,17,4),(2,241,0,1,17,4),(2,244,0,1,17,4),(2,246,0,1,17,4),(2,251,0,1,17,4),(2,255,0,1,17,4),(2,258,0,1,17,4),(2,259,0,1,17,4),(2,260,0,1,17,4),(2,261,0,1,17,4),(2,262,0,1,17,4),(2,263,0,1,17,4),(3,1,0,1,17,4),(3,2,0,1,17,4),(3,3,0,1,17,4),(3,4,0,1,17,4),(3,5,0,1,17,4),(3,6,0,1,17,4),(3,7,0,1,17,4),(3,8,0,1,17,4),(3,10,0,1,17,4),(3,11,0,1,17,4),(4,12,0,1,17,4),(4,13,0,1,17,4),(4,14,0,1,17,4),(4,15,0,1,17,4),(4,16,0,1,17,4),(4,17,0,1,17,4),(4,18,0,1,17,4),(4,19,0,1,17,4),(4,36,0,1,17,4),(4,37,0,1,17,4),(4,38,0,1,17,4),(4,39,0,1,17,4),(4,40,0,1,17,4),(5,95,10000,0,17,4),(5,96,10000,0,17,4),(5,97,10000,0,17,4),(5,98,10000,0,17,4),(5,99,10000,0,17,4),(5,100,10000,0,17,4),(7,101,10000,0,17,4),(7,102,10000,0,17,4),(7,103,10000,0,17,4),(7,104,10000,0,17,4),(7,105,10000,0,17,4),(7,106,10000,0,17,4),(7,107,10000,0,17,4),(7,108,10000,0,17,4),(7,109,10000,0,17,4),(7,110,10000,0,17,4),(7,111,10000,0,17,4),(7,112,10000,0,17,4),(7,21,0,1,17,4),(7,22,0,1,17,4),(7,26,0,1,17,4),(8,61,0,1,17,4),(8,62,0,1,17,4),(8,63,0,1,17,4),(8,64,0,1,17,4),(8,65,0,1,17,4),(8,66,0,1,17,4),(11,4,10000,0,17,4),(11,89,10000,0,17,4),(11,90,10000,0,17,4),(11,91,10000,0,17,4),(11,92,10000,0,17,4),(11,93,10000,0,17,4),(11,94,10000,0,17,4),(11,28,0,1,17,4),(11,29,0,1,17,4),(11,30,0,1,17,4),(11,31,0,1,17,4),(11,32,0,1,17,4),(11,33,0,1,17,4),(11,34,0,1,17,4),(11,35,0,1,17,4),(13,21,0,1,17,4),(13,24,0,1,17,4),(13,25,0,1,17,4),(13,26,0,1,17,4),(13,27,0,1,17,4),(13,41,0,1,17,4),(13,42,0,1,17,4),(13,43,0,1,17,4),(13,44,0,1,17,4),(13,45,0,1,17,4),(13,46,0,1,17,4),(13,47,0,1,17,4),(13,48,0,1,17,4),(13,49,0,1,17,4),(15,22,10000,0,17,4),(15,23,10000,0,17,4),(16,20,0,1,17,4),(16,21,0,1,17,4),(16,22,0,1,17,4),(16,23,0,1,17,4),(16,24,0,1,17,4),(16,25,0,1,17,4),(16,26,0,1,17,4),(16,27,0,1,17,4),(16,41,0,1,17,4),(16,68,0,1,17,4),(16,69,0,1,17,4),(16,70,0,1,17,4),(16,71,0,1,17,4),(16,72,0,1,17,4),(16,73,0,1,17,4),(19,6,0,1,17,4),(19,7,0,1,17,4),(19,8,0,1,17,4),(19,10,0,1,17,4),(19,11,0,1,17,4),(27,11,0,1,17,4),(29,6,0,1,17,4),(29,8,0,1,17,4),(29,10,0,1,17,4),(30,6,0,1,17,4),(30,10,0,1,17,4),(33,7,0,1,17,4),(33,8,0,1,17,4),(33,10,0,1,17,4),(33,11,0,1,17,4),(42,7,0,1,17,4),(42,8,0,1,17,4),(42,11,0,1,17,4),(78,21,0,1,17,4),(78,26,0,1,17,4),(80,21,0,1,17,4),(80,22,0,1,17,4),(80,26,0,1,17,4),(81,26,0,1,17,4),(82,26,0,1,17,4),(83,26,0,1,17,4),(96,26,0,1,17,4),(97,26,0,1,17,4),(98,21,0,1,17,4),(98,22,0,1,17,4),(98,26,0,1,17,4),(99,18,0,1,17,4),(101,14,0,1,17,4),(101,15,0,1,17,4),(101,16,0,1,17,4),(102,12,0,1,17,4),(102,13,0,1,17,4),(102,14,0,1,17,4),(102,15,0,1,17,4),(102,16,0,1,17,4),(102,17,0,1,17,4),(102,19,0,1,17,4),(102,36,0,1,17,4),(102,37,0,1,17,4),(102,38,0,1,17,4),(102,39,0,1,17,4),(102,40,0,1,17,4),(103,18,0,1,17,4),(104,18,0,1,17,4),(105,18,0,1,17,4),(106,18,0,1,17,4),(107,18,0,1,17,4),(134,23,0,1,17,4),(135,22,0,1,17,4),(137,4,0,1,17,4),(137,28,0,1,17,4),(137,31,0,1,17,4),(137,34,0,1,17,4),(137,35,0,1,17,4),(138,28,0,1,17,4),(138,30,0,1,17,4),(138,32,0,1,17,4),(138,33,0,1,17,4),(139,28,0,1,17,4),(139,30,0,1,17,4),(139,32,0,1,17,4),(139,33,0,1,17,4),(140,28,0,1,17,4),(140,30,0,1,17,4),(140,32,0,1,17,4),(140,33,0,1,17,4),(145,1,0,1,17,4),(145,2,0,1,17,4),(145,3,0,1,17,4),(145,4,0,1,17,4),(145,5,0,1,17,4),(145,6,0,1,17,4),(145,7,0,1,17,4),(145,8,0,1,17,4),(145,9,0,1,17,4),(145,10,0,1,17,4),(145,11,0,1,17,4),(145,12,0,1,17,4),(145,13,0,1,17,4),(145,14,0,1,17,4),(145,15,0,1,17,4),(145,16,0,1,17,4),(145,17,0,1,17,4),(145,18,0,1,17,4),(145,19,0,1,17,4),(145,20,0,1,17,4),(145,21,0,1,17,4),(145,22,0,1,17,4),(145,23,0,1,17,4),(145,24,0,1,17,4),(145,25,0,1,17,4),(145,26,0,1,17,4),(145,27,0,1,17,4),(145,28,0,1,17,4),(145,29,0,1,17,4),(145,30,0,1,17,4),(145,31,0,1,17,4),(145,32,0,1,17,4),(145,33,0,1,17,4),(145,34,0,1,17,4),(145,35,0,1,17,4),(145,36,0,1,17,4),(145,37,0,1,17,4),(145,38,0,1,17,4),(145,39,0,1,17,4),(145,40,0,1,17,4),(145,41,0,1,17,4),(145,42,0,1,17,4),(145,43,0,1,17,4),(149,41,0,1,17,4),(150,50,0,1,17,4),(150,57,0,1,17,4),(150,58,0,1,17,4),(150,59,0,1,17,4),(150,60,0,1,17,4),(151,61,0,1,17,4),(151,62,0,1,17,4),(151,63,0,1,17,4),(151,64,0,1,17,4),(151,65,0,1,17,4),(151,66,0,1,17,4),(152,61,0,1,17,4),(152,63,0,1,17,4),(153,61,0,1,17,4),(153,63,0,1,17,4),(153,64,0,1,17,4),(153,65,0,1,17,4),(153,66,0,1,17,4),(154,61,0,1,17,4),(154,62,0,1,17,4),(154,64,0,1,17,4),(154,66,0,1,17,4),(155,61,0,1,17,4),(155,62,0,1,17,4),(155,64,0,1,17,4),(155,65,0,1,17,4),(155,66,0,1,17,4),(156,61,0,1,17,4),(156,62,0,1,17,4),(156,63,0,1,17,4),(156,64,0,1,17,4),(156,65,0,1,17,4),(156,66,0,1,17,4),(157,61,0,1,17,4),(157,62,0,1,17,4),(157,64,0,1,17,4),(157,65,0,1,17,4),(157,66,0,1,17,4),(158,61,0,1,17,4),(158,63,0,1,17,4),(158,64,0,1,17,4),(158,65,0,1,17,4),(158,66,0,1,17,4),(159,61,0,1,17,4),(159,62,0,1,17,4),(159,63,0,1,17,4),(159,64,0,1,17,4),(159,65,0,1,17,4),(159,66,0,1,17,4),(160,41,0,1,17,4),(160,68,0,1,17,4),(160,69,0,1,17,4),(160,70,0,1,17,4),(160,72,0,1,17,4),(160,73,0,1,17,4),(161,68,0,1,17,4),(161,69,0,1,17,4),(161,70,0,1,17,4),(161,71,0,1,17,4),(161,72,0,1,17,4),(162,68,0,1,17,4),(162,69,0,1,17,4),(162,72,0,1,17,4),(164,41,0,1,17,4),(164,70,0,1,17,4),(164,73,0,1,17,4),(166,41,0,1,17,4),(166,70,0,1,17,4),(166,73,0,1,17,4),(167,68,0,1,17,4),(167,69,0,1,17,4),(167,72,0,1,17,4),(168,71,0,1,17,4),(169,70,0,1,17,4),(171,70,0,1,17,4),(172,1,10000,0,17,4),(172,2,10000,0,17,4),(172,3,10000,0,17,4),(172,4,10000,0,17,4),(172,5,10000,0,17,4),(172,6,10000,0,17,4),(172,7,10000,0,17,4),(172,8,10000,0,17,4),(172,9,10000,0,17,4),(172,10,10000,0,17,4),(172,11,10000,0,17,4),(172,12,10000,0,17,4),(172,13,10000,0,17,4),(172,14,10000,0,17,4),(172,15,10000,0,17,4),(172,16,10000,0,17,4),(172,17,10000,0,17,4),(172,18,10000,0,17,4),(172,19,10000,0,17,4),(172,20,10000,0,17,4),(172,21,10000,0,17,4),(172,22,10000,0,17,4),(172,23,10000,0,17,4),(172,24,10000,0,17,4),(172,25,10000,0,17,4),(172,26,10000,0,17,4),(172,27,10000,0,17,4),(172,28,10000,0,17,4),(172,29,10000,0,17,4),(172,30,10000,0,17,4),(173,1,0,1,17,4),(173,2,0,1,17,4),(173,3,0,1,17,4),(173,4,0,1,17,4),(173,5,0,1,17,4),(173,6,0,1,17,4),(173,7,0,1,17,4),(173,8,0,1,17,4),(173,9,0,1,17,4),(173,10,0,1,17,4),(173,11,0,1,17,4),(173,12,0,1,17,4),(173,13,0,1,17,4),(173,14,0,1,17,4),(173,15,0,1,17,4),(173,16,0,1,17,4),(173,17,0,1,17,4),(173,18,0,1,17,4),(173,19,0,1,17,4),(173,20,0,1,17,4),(173,21,0,1,17,4),(173,22,0,1,17,4),(173,23,0,1,17,4),(173,24,0,1,17,4),(173,25,0,1,17,4),(173,26,0,1,17,4),(173,27,0,1,17,4),(173,28,0,1,17,4),(173,29,0,1,17,4),(173,30,0,1,17,4),(174,1,0,1,17,4),(174,2,0,1,17,4),(174,3,0,1,17,4),(174,4,0,1,17,4),(174,5,0,1,17,4),(174,6,0,1,17,4),(174,7,0,1,17,4),(174,8,0,1,17,4),(174,9,0,1,17,4),(174,10,0,1,17,4),(174,11,0,1,17,4),(174,12,0,1,17,4),(174,13,0,1,17,4),(174,14,0,1,17,4),(174,15,0,1,17,4),(174,16,0,1,17,4),(174,17,0,1,17,4),(174,18,0,1,17,4),(174,19,0,1,17,4),(174,20,0,1,17,4),(174,21,0,1,17,4),(174,22,0,1,17,4),(174,23,0,1,17,4),(174,24,0,1,17,4),(174,25,0,1,17,4),(174,26,0,1,17,4),(174,27,0,1,17,4),(174,28,0,1,17,4),(174,29,0,1,17,4),(174,30,0,1,17,4),(175,1,0,1,17,4),(175,2,0,1,17,4),(175,3,0,1,17,4),(175,4,0,1,17,4),(175,5,0,1,17,4),(175,6,0,1,17,4),(175,7,0,1,17,4),(175,8,0,1,17,4),(175,9,0,1,17,4),(175,10,0,1,17,4),(175,11,0,1,17,4),(175,12,0,1,17,4),(175,13,0,1,17,4),(175,14,0,1,17,4),(175,15,0,1,17,4),(175,16,0,1,17,4),(175,17,0,1,17,4),(175,18,0,1,17,4),(175,19,0,1,17,4),(175,20,0,1,17,4),(175,21,0,1,17,4),(175,22,0,1,17,4),(175,23,0,1,17,4),(175,24,0,1,17,4),(175,25,0,1,17,4),(175,26,0,1,17,4),(175,27,0,1,17,4),(175,28,0,1,17,4),(175,29,0,1,17,4),(175,30,0,1,17,4),(176,1,0,1,17,4),(176,2,0,1,17,4),(176,3,0,1,17,4),(176,4,0,1,17,4),(176,5,0,1,17,4),(176,6,0,1,17,4),(176,7,0,1,17,4),(176,8,0,1,17,4),(176,9,0,1,17,4),(176,10,0,1,17,4),(176,11,0,1,17,4),(176,12,0,1,17,4),(176,13,0,1,17,4),(176,14,0,1,17,4),(176,15,0,1,17,4),(176,16,0,1,17,4),(176,17,0,1,17,4),(176,18,0,1,17,4),(176,19,0,1,17,4),(176,20,0,1,17,4),(176,21,0,1,17,4),(176,22,0,1,17,4),(176,23,0,1,17,4),(176,24,0,1,17,4),(176,25,0,1,17,4),(176,26,0,1,17,4),(176,27,0,1,17,4),(176,28,0,1,17,4),(176,29,0,1,17,4),(176,30,0,1,17,4),(177,74,0,1,17,4),(177,75,0,1,17,4),(177,76,0,1,17,4),(177,77,0,1,17,4),(177,78,0,1,17,4),(177,79,0,1,17,4),(177,80,0,1,17,4),(178,74,10000,0,17,4),(178,75,10000,0,17,4),(178,76,10000,0,17,4),(178,77,10000,0,17,4),(178,78,10000,0,17,4),(178,79,10000,0,17,4),(178,80,10000,0,17,4),(178,81,10000,0,17,4),(178,82,10000,0,17,4),(178,83,10000,0,17,4),(178,84,10000,0,17,4),(178,85,10000,0,17,4),(178,86,10000,0,17,4),(178,87,10000,0,17,4),(178,88,10000,0,17,4),(178,113,10000,0,17,4),(178,114,10000,0,17,4),(178,115,10000,0,17,4),(178,116,10000,0,17,4),(178,117,10000,0,17,4),(178,118,10000,0,17,4),(178,119,10000,0,17,4),(178,120,10000,0,17,4),(178,121,10000,0,17,4),(178,122,10000,0,17,4),(178,123,10000,0,17,4),(178,124,10000,0,17,4),(178,125,10000,0,17,4),(178,126,10000,0,17,4),(178,127,10000,0,17,4),(178,128,10000,0,17,4),(178,129,10000,0,17,4),(178,130,10000,0,17,4),(178,131,10000,0,17,4),(178,132,10000,0,17,4),(178,133,10000,0,17,4),(178,134,10000,0,17,4),(178,135,10000,0,17,4),(178,136,10000,0,17,4),(178,137,10000,0,17,4),(178,138,10000,0,17,4),(178,139,10000,0,17,4),(178,140,10000,0,17,4),(178,141,10000,0,17,4),(178,142,10000,0,17,4),(178,143,10000,0,17,4),(178,144,10000,0,17,4),(178,145,10000,0,17,4),(178,146,10000,0,17,4),(178,147,10000,0,17,4),(178,148,10000,0,17,4),(178,149,10000,0,17,4),(178,150,10000,0,17,4),(178,151,10000,0,17,4),(178,152,10000,0,17,4),(178,153,10000,0,17,4),(178,154,10000,0,17,4),(178,155,10000,0,17,4),(178,156,10000,0,17,4),(178,157,10000,0,17,4),(178,158,10000,0,17,4),(178,159,10000,0,17,4),(178,160,10000,0,17,4),(178,161,10000,0,17,4),(178,162,10000,0,17,4),(178,163,10000,0,17,4),(178,164,10000,0,17,4),(178,165,10000,0,17,4),(178,166,10000,0,17,4),(178,167,10000,0,17,4),(178,168,10000,0,17,4),(178,169,10000,0,17,4),(178,170,10000,0,17,4),(178,171,10000,0,17,4),(178,172,10000,0,17,4),(178,173,10000,0,17,4),(178,174,10000,0,17,4),(178,175,10000,0,17,4),(178,176,10000,0,17,4),(178,177,10000,0,17,4),(178,178,10000,0,17,4),(178,179,10000,0,17,4),(178,180,10000,0,17,4),(178,181,10000,0,17,4),(178,182,10000,0,17,4),(178,183,10000,0,17,4),(178,184,10000,0,17,4),(178,185,10000,0,17,4),(178,186,10000,0,17,4),(178,187,10000,0,17,4),(178,188,10000,0,17,4),(178,189,10000,0,17,4),(178,190,10000,0,17,4),(178,191,10000,0,17,4),(178,192,10000,0,17,4),(178,193,10000,0,17,4),(178,194,10000,0,17,4),(178,195,10000,0,17,4),(178,196,10000,0,17,4),(178,197,10000,0,17,4),(178,198,10000,0,17,4),(178,199,10000,0,17,4),(178,200,10000,0,17,4),(178,201,10000,0,17,4),(178,202,10000,0,17,4),(178,203,10000,0,17,4),(178,204,10000,0,17,4),(178,205,10000,0,17,4),(178,206,10000,0,17,4),(178,207,10000,0,17,4),(178,208,10000,0,17,4),(178,209,10000,0,17,4),(178,210,10000,0,17,4),(178,211,10000,0,17,4),(178,212,10000,0,17,4),(178,213,10000,0,17,4),(178,214,10000,0,17,4),(178,215,10000,0,17,4),(178,216,10000,0,17,4),(178,217,10000,0,17,4),(178,218,10000,0,17,4),(178,219,10000,0,17,4),(178,220,10000,0,17,4),(178,221,10000,0,17,4),(178,222,10000,0,17,4),(178,223,10000,0,17,4),(178,224,10000,0,17,4),(178,225,10000,0,17,4),(178,226,10000,0,17,4),(178,227,10000,0,17,4),(178,228,10000,0,17,4),(178,229,10000,0,17,4),(178,230,10000,0,17,4),(178,231,10000,0,17,4),(178,232,10000,0,17,4),(178,233,10000,0,17,4),(178,234,10000,0,17,4),(178,235,10000,0,17,4),(178,236,10000,0,17,4),(178,237,10000,0,17,4),(178,238,10000,0,17,4),(178,239,10000,0,17,4),(178,240,10000,0,17,4),(178,241,10000,0,17,4),(178,244,10000,0,17,4),(178,246,10000,0,17,4),(178,251,10000,0,17,4),(178,255,10000,0,17,4),(178,258,10000,0,17,4),(178,259,10000,0,17,4),(178,260,10000,0,17,4),(178,261,10000,0,17,4),(178,262,10000,0,17,4),(178,263,10000,0,17,4),(179,81,0,1,17,4),(179,82,0,1,17,4),(179,83,0,1,17,4),(179,84,0,1,17,4),(179,85,0,1,17,4),(179,86,0,1,17,4),(179,87,0,1,17,4),(179,88,0,1,17,4),(180,81,0,1,17,4),(181,86,0,1,17,4),(182,82,0,1,17,4),(182,83,0,1,17,4),(182,84,0,1,17,4),(182,85,0,1,17,4),(182,87,0,1,17,4),(182,88,0,1,17,4),(183,82,0,1,17,4),(183,83,0,1,17,4),(183,84,0,1,17,4),(183,85,0,1,17,4),(183,86,0,1,17,4),(183,87,0,1,17,4),(183,88,0,1,17,4),(192,89,0,1,17,4),(192,90,0,1,17,4),(192,91,0,1,17,4),(192,92,0,1,17,4),(192,93,0,1,17,4),(192,94,0,1,17,4),(193,95,0,1,17,4),(193,96,0,1,17,4),(193,97,0,1,17,4),(193,98,0,1,17,4),(193,99,0,1,17,4),(193,100,0,1,17,4),(194,95,0,1,17,4),(194,96,0,1,17,4),(194,97,0,1,17,4),(194,98,0,1,17,4),(194,99,0,1,17,4),(194,100,0,1,17,4),(195,95,0,1,17,4),(195,96,0,1,17,4),(195,97,0,1,17,4),(195,98,0,1,17,4),(195,99,0,1,17,4),(195,100,0,1,17,4),(196,95,0,1,17,4),(196,96,0,1,17,4),(196,97,0,1,17,4),(196,98,0,1,17,4),(196,99,0,1,17,4),(196,100,0,1,17,4),(197,95,0,1,17,4),(197,96,0,1,17,4),(197,97,0,1,17,4),(197,98,0,1,17,4),(197,99,0,1,17,4),(197,100,0,1,17,4),(198,101,0,1,17,4),(198,109,0,1,17,4),(198,111,0,1,17,4),(198,112,0,1,17,4),(199,103,0,1,17,4),(199,110,0,1,17,4),(200,101,0,1,17,4),(200,102,0,1,17,4),(200,108,0,1,17,4),(201,104,0,1,17,4),(201,106,0,1,17,4),(202,101,0,1,17,4),(202,102,0,1,17,4),(202,103,0,1,17,4),(202,105,0,1,17,4),(202,107,0,1,17,4),(202,108,0,1,17,4),(202,110,0,1,17,4),(203,101,0,1,17,4),(203,102,0,1,17,4),(203,103,0,1,17,4),(203,104,0,1,17,4),(203,106,0,1,17,4),(203,108,0,1,17,4),(203,109,0,1,17,4),(204,101,0,1,17,4),(204,102,0,1,17,4),(204,103,0,1,17,4),(204,104,0,1,17,4),(204,105,0,1,17,4),(204,106,0,1,17,4),(204,107,0,1,17,4),(204,108,0,1,17,4),(205,101,0,1,17,4),(205,102,0,1,17,4),(205,103,0,1,17,4),(205,108,0,1,17,4),(205,109,0,1,17,4),(205,110,0,1,17,4),(205,111,0,1,17,4),(205,112,0,1,17,4),(206,113,10000,0,17,4),(206,114,10000,0,17,4),(206,115,10000,0,17,4),(206,116,10000,0,17,4),(206,117,10000,0,17,4),(206,118,10000,0,17,4),(206,119,10000,0,17,4),(207,114,0,1,17,4),(207,119,0,1,17,4),(209,114,0,1,17,4),(212,116,0,1,17,4),(212,118,0,1,17,4),(213,113,0,1,17,4),(218,117,0,1,17,4),(219,119,0,1,17,4),(220,119,0,1,17,4),(221,119,0,1,17,4),(222,114,0,1,17,4),(222,119,0,1,17,4),(223,114,0,1,17,4),(223,119,0,1,17,4),(229,113,0,1,17,4),(230,113,0,1,17,4),(231,113,0,1,17,4),(232,113,0,1,17,4),(233,113,0,1,17,4),(234,116,0,1,17,4),(234,118,0,1,17,4),(235,116,0,1,17,4),(235,118,0,1,17,4),(236,116,0,1,17,4),(236,118,0,1,17,4),(237,116,0,1,17,4),(237,118,0,1,17,4),(238,116,0,1,17,4),(238,118,0,1,17,4),(239,115,0,1,17,4),(241,115,0,1,17,4),(242,115,0,1,17,4),(243,115,0,1,17,4),(250,120,0,1,17,4),(250,121,0,1,17,4),(250,122,0,1,17,4),(250,123,0,1,17,4),(250,124,0,1,17,4),(250,125,0,1,17,4),(250,126,0,1,17,4),(250,127,0,1,17,4),(250,128,0,1,17,4),(250,129,0,1,17,4),(250,130,0,1,17,4),(250,131,0,1,17,4),(251,120,0,1,17,4),(251,121,0,1,17,4),(251,122,0,1,17,4),(251,123,0,1,17,4),(251,124,0,1,17,4),(251,125,0,1,17,4),(251,126,0,1,17,4),(251,127,0,1,17,4),(251,128,0,1,17,4),(251,129,0,1,17,4),(251,130,0,1,17,4),(251,131,0,1,17,4),(252,125,10000,0,17,4),(252,126,10000,0,17,4),(252,127,10000,0,17,4),(252,120,0,1,17,4),(252,121,0,1,17,4),(252,122,0,1,17,4),(252,123,0,1,17,4),(252,124,0,1,17,4),(252,128,0,1,17,4),(252,129,0,1,17,4),(252,131,0,1,17,4),(253,120,0,1,17,4),(253,121,0,1,17,4),(253,122,0,1,17,4),(253,123,0,1,17,4),(253,124,0,1,17,4),(253,125,0,1,17,4),(253,126,0,1,17,4),(253,127,0,1,17,4),(253,128,0,1,17,4),(253,129,0,1,17,4),(253,130,0,1,17,4),(253,131,0,1,17,4),(254,120,0,1,17,4),(254,121,0,1,17,4),(254,122,0,1,17,4),(254,123,0,1,17,4),(254,124,0,1,17,4),(254,125,0,1,17,4),(254,126,0,1,17,4),(254,127,0,1,17,4),(254,128,0,1,17,4),(254,129,0,1,17,4),(254,130,0,1,17,4),(254,131,0,1,17,4),(255,122,0,1,17,4),(255,123,0,1,17,4),(255,124,0,1,17,4),(255,125,0,1,17,4),(255,126,0,1,17,4),(255,129,0,1,17,4),(256,121,0,1,17,4),(256,122,0,1,17,4),(256,123,0,1,17,4),(256,125,0,1,17,4),(256,126,0,1,17,4),(256,127,0,1,17,4),(257,121,0,1,17,4),(257,122,0,1,17,4),(257,123,0,1,17,4),(257,125,0,1,17,4),(257,127,0,1,17,4),(257,129,0,1,17,4),(258,121,0,1,17,4),(258,122,0,1,17,4),(258,125,0,1,17,4),(258,126,0,1,17,4),(258,127,0,1,17,4),(258,129,0,1,17,4),(259,120,0,1,17,4),(259,121,0,1,17,4),(259,123,0,1,17,4),(259,128,0,1,17,4),(259,129,0,1,17,4),(260,120,0,1,17,4),(260,121,0,1,17,4),(260,122,0,1,17,4),(260,123,0,1,17,4),(260,125,0,1,17,4),(260,127,0,1,17,4),(260,128,0,1,17,4),(260,129,0,1,17,4),(261,121,0,1,17,4),(261,122,0,1,17,4),(261,125,0,1,17,4),(261,126,0,1,17,4),(261,127,0,1,17,4),(261,129,0,1,17,4),(262,125,0,1,17,4),(262,126,0,1,17,4),(263,120,0,1,17,4),(263,121,0,1,17,4),(263,122,0,1,17,4),(263,123,0,1,17,4),(263,124,0,1,17,4),(263,128,0,1,17,4),(263,129,0,1,17,4),(263,131,0,1,17,4),(264,120,0,1,17,4),(264,122,0,1,17,4),(264,123,0,1,17,4),(264,125,0,1,17,4),(264,126,0,1,17,4),(264,129,0,1,17,4),(265,121,0,1,17,4),(265,122,0,1,17,4),(265,123,0,1,17,4),(265,127,0,1,17,4),(266,123,0,1,17,4),(266,125,0,1,17,4),(266,126,0,1,17,4),(266,127,0,1,17,4),(266,129,0,1,17,4),(267,121,0,1,17,4),(267,125,0,1,17,4),(267,126,0,1,17,4),(267,127,0,1,17,4),(268,120,0,1,17,4),(268,121,0,1,17,4),(268,122,0,1,17,4),(268,123,0,1,17,4),(268,124,0,1,17,4),(268,127,0,1,17,4),(268,129,0,1,17,4),(269,122,0,1,17,4),(269,125,0,1,17,4),(269,126,0,1,17,4),(269,127,0,1,17,4),(269,129,0,1,17,4),(270,121,0,1,17,4),(270,123,0,1,17,4),(270,125,0,1,17,4),(270,126,0,1,17,4),(270,129,0,1,17,4),(271,120,0,1,17,4),(271,121,0,1,17,4),(271,122,0,1,17,4),(271,125,0,1,17,4),(271,126,0,1,17,4),(271,127,0,1,17,4),(271,129,0,1,17,4),(272,122,0,1,17,4),(272,123,0,1,17,4),(272,124,0,1,17,4),(272,125,0,1,17,4),(272,126,0,1,17,4),(272,127,0,1,17,4),(272,128,0,1,17,4),(272,129,0,1,17,4),(273,120,0,1,17,4),(273,121,0,1,17,4),(273,123,0,1,17,4),(273,126,0,1,17,4),(273,127,0,1,17,4),(274,122,0,1,17,4),(274,123,0,1,17,4),(274,125,0,1,17,4),(274,126,0,1,17,4),(274,129,0,1,17,4),(275,120,0,1,17,4),(275,121,0,1,17,4),(275,122,0,1,17,4),(275,123,0,1,17,4),(275,124,0,1,17,4),(275,125,0,1,17,4),(275,126,0,1,17,4),(275,127,0,1,17,4),(275,128,0,1,17,4),(275,129,0,1,17,4),(275,130,0,1,17,4),(275,131,0,1,17,4),(276,122,0,1,17,4),(276,123,0,1,17,4),(276,127,0,1,17,4),(276,129,0,1,17,4),(277,120,0,1,17,4),(277,121,0,1,17,4),(277,123,0,1,17,4),(277,124,0,1,17,4),(277,125,0,1,17,4),(277,126,0,1,17,4),(277,127,0,1,17,4),(278,120,0,1,17,4),(278,121,0,1,17,4),(278,122,0,1,17,4),(278,123,0,1,17,4),(278,124,0,1,17,4),(278,125,0,1,17,4),(278,127,0,1,17,4),(278,128,0,1,17,4),(278,129,0,1,17,4),(279,120,0,1,17,4),(279,122,0,1,17,4),(279,126,0,1,17,4),(279,127,0,1,17,4),(279,129,0,1,17,4),(280,132,0,1,17,4),(280,133,0,1,17,4),(280,134,0,1,17,4),(280,135,0,1,17,4),(280,136,0,1,17,4),(280,137,0,1,17,4),(280,138,0,1,17,4),(280,139,0,1,17,4),(282,132,0,1,17,4),(282,133,0,1,17,4),(282,134,0,1,17,4),(282,137,0,1,17,4),(282,138,0,1,17,4),(283,135,0,1,17,4),(283,136,0,1,17,4),(283,139,0,1,17,4),(286,140,0,1,17,4),(286,141,0,1,17,4),(286,142,0,1,17,4),(286,143,0,1,17,4),(286,144,0,1,17,4),(286,145,0,1,17,4),(286,146,0,1,17,4),(286,147,0,1,17,4),(286,148,0,1,17,4),(286,149,0,1,17,4),(286,150,0,1,17,4),(286,151,0,1,17,4),(286,152,0,1,17,4),(286,153,0,1,17,4),(286,154,0,1,17,4),(286,155,0,1,17,4),(286,156,0,1,17,4),(286,157,0,1,17,4),(286,158,0,1,17,4),(286,159,0,1,17,4),(286,160,0,1,17,4),(286,161,0,1,17,4),(286,162,0,1,17,4),(286,163,0,1,17,4),(286,164,0,1,17,4),(286,165,0,1,17,4),(286,166,0,1,17,4),(286,167,0,1,17,4),(286,168,0,1,17,4),(286,169,0,1,17,4),(286,170,0,1,17,4),(286,171,0,1,17,4),(286,172,0,1,17,4),(286,173,0,1,17,4),(286,174,0,1,17,4),(286,175,0,1,17,4),(286,176,0,1,17,4),(286,177,0,1,17,4),(286,178,0,1,17,4),(286,179,0,1,17,4),(286,180,0,1,17,4),(286,181,0,1,17,4),(286,182,0,1,17,4),(286,183,0,1,17,4),(286,184,0,1,17,4),(286,185,0,1,17,4),(286,186,0,1,17,4),(286,187,0,1,17,4),(287,188,0,1,17,4),(288,189,0,1,17,4),(288,190,0,1,17,4),(288,191,0,1,17,4),(288,192,0,1,17,4),(288,193,0,1,17,4),(288,194,0,1,17,4),(288,195,0,1,17,4),(288,196,0,1,17,4),(288,197,0,1,17,4),(288,198,0,1,17,4),(288,199,0,1,17,4),(288,200,0,1,17,4),(289,201,10000,0,17,4),(289,202,10000,0,17,4),(289,203,10000,0,17,4),(289,204,10000,0,17,4),(289,205,10000,0,17,4),(289,206,10000,0,17,4),(289,207,10000,0,17,4),(289,208,10000,0,17,4),(289,209,10000,0,17,4),(289,210,10000,0,17,4),(289,211,10000,0,17,4),(289,212,10000,0,17,4),(289,213,10000,0,17,4),(289,214,10000,0,17,4),(289,215,10000,0,17,4),(289,216,10000,0,17,4),(289,217,10000,0,17,4),(289,218,10000,0,17,4),(289,219,10000,0,17,4),(289,220,10000,0,17,4),(289,221,10000,0,17,4),(289,222,10000,0,17,4),(289,223,10000,0,17,4),(289,224,10000,0,17,4),(289,225,10000,0,17,4),(289,226,10000,0,17,4),(289,227,10000,0,17,4),(289,228,10000,0,17,4),(289,229,10000,0,17,4),(289,230,10000,0,17,4),(289,231,10000,0,17,4),(289,232,10000,0,17,4),(289,244,10000,0,17,4),(289,246,10000,0,17,4),(289,251,10000,0,17,4),(289,255,10000,0,17,4),(289,258,10000,0,17,4),(289,259,10000,0,17,4),(289,260,10000,0,17,4),(289,261,10000,0,17,4),(289,262,10000,0,17,4),(289,263,10000,0,17,4),(290,209,0,1,17,4),(290,210,0,1,17,4),(290,211,0,1,17,4),(290,212,0,1,17,4),(290,213,0,1,17,4),(290,214,0,1,17,4),(290,215,0,1,17,4),(290,216,0,1,17,4),(291,201,0,1,17,4),(291,202,0,1,17,4),(291,203,0,1,17,4),(291,204,0,1,17,4),(291,205,0,1,17,4),(291,206,0,1,17,4),(291,207,0,1,17,4),(291,208,0,1,17,4),(292,217,0,1,17,4),(292,218,0,1,17,4),(292,219,0,1,17,4),(292,220,0,1,17,4),(292,221,0,1,17,4),(292,222,0,1,17,4),(292,223,0,1,17,4),(292,224,0,1,17,4),(293,225,0,1,17,4),(293,226,0,1,17,4),(293,227,0,1,17,4),(293,228,0,1,17,4),(293,229,0,1,17,4),(293,230,0,1,17,4),(293,231,0,1,17,4),(293,232,0,1,17,4),(293,255,0,1,17,4),(293,259,0,1,17,4),(293,260,0,1,17,4),(293,261,0,1,17,4),(293,262,0,1,17,4),(293,263,0,1,17,4),(294,233,0,1,17,4),(294,234,0,1,17,4),(294,235,0,1,17,4),(294,236,0,1,17,4),(294,237,0,1,17,4),(294,238,0,1,17,4),(294,239,0,1,17,4),(294,240,0,1,17,4),(294,241,0,1,17,4),(295,244,0,1,17,4),(295,246,0,1,17,4),(295,251,0,1,17,4),(295,255,0,1,17,4),(295,258,0,1,17,4),(296,251,0,1,17,4),(296,255,0,1,17,4),(296,258,0,1,17,4),(297,246,0,1,17,4),(297,255,0,1,17,4),(297,258,0,1,17,4),(298,255,0,1,17,4),(298,258,0,1,17,4),(299,251,0,1,17,4),(299,258,0,1,17,4);
/*!40000 ALTER TABLE `catalog_category_product_index_store17_replica` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index_store18`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store18`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store18` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `IDX_FE62EE5029D6B6B86BA6422E3BD7D3ED` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_6FD7B35BC5C70623A337127701885011` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Product Index Store18';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index_store18`
--

LOCK TABLES `catalog_category_product_index_store18` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index_store18` DISABLE KEYS */;
INSERT INTO `catalog_category_product_index_store18` VALUES (2,1,0,1,18,4),(2,2,0,1,18,4),(2,3,0,1,18,4),(2,4,0,1,18,4),(2,5,0,1,18,4),(2,6,0,1,18,4),(2,7,0,1,18,4),(2,8,0,1,18,4),(2,9,0,1,18,4),(2,10,0,1,18,4),(2,11,0,1,18,4),(2,12,0,1,18,4),(2,13,0,1,18,4),(2,14,0,1,18,4),(2,15,0,1,18,4),(2,16,0,1,18,4),(2,17,0,1,18,4),(2,18,0,1,18,4),(2,19,0,1,18,4),(2,20,0,1,18,4),(2,21,0,1,18,4),(2,22,0,1,18,4),(2,23,0,1,18,4),(2,24,0,1,18,4),(2,25,0,1,18,4),(2,26,0,1,18,4),(2,27,0,1,18,4),(2,28,0,1,18,4),(2,29,0,1,18,4),(2,30,0,1,18,4),(2,31,0,1,18,4),(2,32,0,1,18,4),(2,33,0,1,18,4),(2,34,0,1,18,4),(2,35,0,1,18,4),(2,36,0,1,18,4),(2,37,0,1,18,4),(2,38,0,1,18,4),(2,39,0,1,18,4),(2,40,0,1,18,4),(2,41,0,1,18,4),(2,42,0,1,18,4),(2,43,0,1,18,4),(2,44,0,1,18,4),(2,45,0,1,18,4),(2,46,0,1,18,4),(2,47,0,1,18,4),(2,48,0,1,18,4),(2,49,0,1,18,4),(2,50,0,1,18,4),(2,57,0,1,18,4),(2,58,0,1,18,4),(2,59,0,1,18,4),(2,60,0,1,18,4),(2,61,0,1,18,4),(2,62,0,1,18,4),(2,63,0,1,18,4),(2,64,0,1,18,4),(2,65,0,1,18,4),(2,66,0,1,18,4),(2,68,0,1,18,4),(2,69,0,1,18,4),(2,70,0,1,18,4),(2,71,0,1,18,4),(2,72,0,1,18,4),(2,73,0,1,18,4),(2,74,0,1,18,4),(2,75,0,1,18,4),(2,76,0,1,18,4),(2,77,0,1,18,4),(2,78,0,1,18,4),(2,79,0,1,18,4),(2,80,0,1,18,4),(2,81,0,1,18,4),(2,82,0,1,18,4),(2,83,0,1,18,4),(2,84,0,1,18,4),(2,85,0,1,18,4),(2,86,0,1,18,4),(2,87,0,1,18,4),(2,88,0,1,18,4),(2,89,0,1,18,4),(2,90,0,1,18,4),(2,91,0,1,18,4),(2,92,0,1,18,4),(2,93,0,1,18,4),(2,94,0,1,18,4),(2,95,0,1,18,4),(2,96,0,1,18,4),(2,97,0,1,18,4),(2,98,0,1,18,4),(2,99,0,1,18,4),(2,100,0,1,18,4),(2,101,0,1,18,4),(2,102,0,1,18,4),(2,103,0,1,18,4),(2,104,0,1,18,4),(2,105,0,1,18,4),(2,106,0,1,18,4),(2,107,0,1,18,4),(2,108,0,1,18,4),(2,109,0,1,18,4),(2,110,0,1,18,4),(2,111,0,1,18,4),(2,112,0,1,18,4),(2,113,0,1,18,4),(2,114,0,1,18,4),(2,115,0,1,18,4),(2,116,0,1,18,4),(2,117,0,1,18,4),(2,118,0,1,18,4),(2,119,0,1,18,4),(2,120,0,1,18,4),(2,121,0,1,18,4),(2,122,0,1,18,4),(2,123,0,1,18,4),(2,124,0,1,18,4),(2,125,0,1,18,4),(2,126,0,1,18,4),(2,127,0,1,18,4),(2,128,0,1,18,4),(2,129,0,1,18,4),(2,130,0,1,18,4),(2,131,0,1,18,4),(2,132,0,1,18,4),(2,133,0,1,18,4),(2,134,0,1,18,4),(2,135,0,1,18,4),(2,136,0,1,18,4),(2,137,0,1,18,4),(2,138,0,1,18,4),(2,139,0,1,18,4),(2,140,0,1,18,4),(2,141,0,1,18,4),(2,142,0,1,18,4),(2,143,0,1,18,4),(2,144,0,1,18,4),(2,145,0,1,18,4),(2,146,0,1,18,4),(2,147,0,1,18,4),(2,148,0,1,18,4),(2,149,0,1,18,4),(2,150,0,1,18,4),(2,151,0,1,18,4),(2,152,0,1,18,4),(2,153,0,1,18,4),(2,154,0,1,18,4),(2,155,0,1,18,4),(2,156,0,1,18,4),(2,157,0,1,18,4),(2,158,0,1,18,4),(2,159,0,1,18,4),(2,160,0,1,18,4),(2,161,0,1,18,4),(2,162,0,1,18,4),(2,163,0,1,18,4),(2,164,0,1,18,4),(2,165,0,1,18,4),(2,166,0,1,18,4),(2,167,0,1,18,4),(2,168,0,1,18,4),(2,169,0,1,18,4),(2,170,0,1,18,4),(2,171,0,1,18,4),(2,172,0,1,18,4),(2,173,0,1,18,4),(2,174,0,1,18,4),(2,175,0,1,18,4),(2,176,0,1,18,4),(2,177,0,1,18,4),(2,178,0,1,18,4),(2,179,0,1,18,4),(2,180,0,1,18,4),(2,181,0,1,18,4),(2,182,0,1,18,4),(2,183,0,1,18,4),(2,184,0,1,18,4),(2,185,0,1,18,4),(2,186,0,1,18,4),(2,187,0,1,18,4),(2,188,0,1,18,4),(2,189,0,1,18,4),(2,190,0,1,18,4),(2,191,0,1,18,4),(2,192,0,1,18,4),(2,193,0,1,18,4),(2,194,0,1,18,4),(2,195,0,1,18,4),(2,196,0,1,18,4),(2,197,0,1,18,4),(2,198,0,1,18,4),(2,199,0,1,18,4),(2,200,0,1,18,4),(2,201,0,1,18,4),(2,202,0,1,18,4),(2,203,0,1,18,4),(2,204,0,1,18,4),(2,205,0,1,18,4),(2,206,0,1,18,4),(2,207,0,1,18,4),(2,208,0,1,18,4),(2,209,0,1,18,4),(2,210,0,1,18,4),(2,211,0,1,18,4),(2,212,0,1,18,4),(2,213,0,1,18,4),(2,214,0,1,18,4),(2,215,0,1,18,4),(2,216,0,1,18,4),(2,217,0,1,18,4),(2,218,0,1,18,4),(2,219,0,1,18,4),(2,220,0,1,18,4),(2,221,0,1,18,4),(2,222,0,1,18,4),(2,223,0,1,18,4),(2,224,0,1,18,4),(2,225,0,1,18,4),(2,226,0,1,18,4),(2,227,0,1,18,4),(2,228,0,1,18,4),(2,229,0,1,18,4),(2,230,0,1,18,4),(2,231,0,1,18,4),(2,232,0,1,18,4),(2,233,0,1,18,4),(2,234,0,1,18,4),(2,235,0,1,18,4),(2,236,0,1,18,4),(2,237,0,1,18,4),(2,238,0,1,18,4),(2,239,0,1,18,4),(2,240,0,1,18,4),(2,241,0,1,18,4),(2,244,0,1,18,4),(2,246,0,1,18,4),(2,251,0,1,18,4),(2,255,0,1,18,4),(2,258,0,1,18,4),(2,259,0,1,18,4),(2,260,0,1,18,4),(2,261,0,1,18,4),(2,262,0,1,18,4),(2,263,0,1,18,4),(3,1,0,1,18,4),(3,2,0,1,18,4),(3,3,0,1,18,4),(3,4,0,1,18,4),(3,5,0,1,18,4),(3,6,0,1,18,4),(3,7,0,1,18,4),(3,8,0,1,18,4),(3,10,0,1,18,4),(3,11,0,1,18,4),(4,12,0,1,18,4),(4,13,0,1,18,4),(4,14,0,1,18,4),(4,15,0,1,18,4),(4,16,0,1,18,4),(4,17,0,1,18,4),(4,18,0,1,18,4),(4,19,0,1,18,4),(4,36,0,1,18,4),(4,37,0,1,18,4),(4,38,0,1,18,4),(4,39,0,1,18,4),(4,40,0,1,18,4),(5,95,10000,0,18,4),(5,96,10000,0,18,4),(5,97,10000,0,18,4),(5,98,10000,0,18,4),(5,99,10000,0,18,4),(5,100,10000,0,18,4),(7,101,10000,0,18,4),(7,102,10000,0,18,4),(7,103,10000,0,18,4),(7,104,10000,0,18,4),(7,105,10000,0,18,4),(7,106,10000,0,18,4),(7,107,10000,0,18,4),(7,108,10000,0,18,4),(7,109,10000,0,18,4),(7,110,10000,0,18,4),(7,111,10000,0,18,4),(7,112,10000,0,18,4),(7,21,0,1,18,4),(7,22,0,1,18,4),(7,26,0,1,18,4),(8,61,0,1,18,4),(8,62,0,1,18,4),(8,63,0,1,18,4),(8,64,0,1,18,4),(8,65,0,1,18,4),(8,66,0,1,18,4),(11,4,10000,0,18,4),(11,89,10000,0,18,4),(11,90,10000,0,18,4),(11,91,10000,0,18,4),(11,92,10000,0,18,4),(11,93,10000,0,18,4),(11,94,10000,0,18,4),(11,28,0,1,18,4),(11,29,0,1,18,4),(11,30,0,1,18,4),(11,31,0,1,18,4),(11,32,0,1,18,4),(11,33,0,1,18,4),(11,34,0,1,18,4),(11,35,0,1,18,4),(13,21,0,1,18,4),(13,24,0,1,18,4),(13,25,0,1,18,4),(13,26,0,1,18,4),(13,27,0,1,18,4),(13,41,0,1,18,4),(13,42,0,1,18,4),(13,43,0,1,18,4),(13,44,0,1,18,4),(13,45,0,1,18,4),(13,46,0,1,18,4),(13,47,0,1,18,4),(13,48,0,1,18,4),(13,49,0,1,18,4),(15,22,10000,0,18,4),(15,23,10000,0,18,4),(16,20,0,1,18,4),(16,21,0,1,18,4),(16,22,0,1,18,4),(16,23,0,1,18,4),(16,24,0,1,18,4),(16,25,0,1,18,4),(16,26,0,1,18,4),(16,27,0,1,18,4),(16,41,0,1,18,4),(16,68,0,1,18,4),(16,69,0,1,18,4),(16,70,0,1,18,4),(16,71,0,1,18,4),(16,72,0,1,18,4),(16,73,0,1,18,4),(19,6,0,1,18,4),(19,7,0,1,18,4),(19,8,0,1,18,4),(19,10,0,1,18,4),(19,11,0,1,18,4),(27,11,0,1,18,4),(29,6,0,1,18,4),(29,8,0,1,18,4),(29,10,0,1,18,4),(30,6,0,1,18,4),(30,10,0,1,18,4),(33,7,0,1,18,4),(33,8,0,1,18,4),(33,10,0,1,18,4),(33,11,0,1,18,4),(42,7,0,1,18,4),(42,8,0,1,18,4),(42,11,0,1,18,4),(78,21,0,1,18,4),(78,26,0,1,18,4),(80,21,0,1,18,4),(80,22,0,1,18,4),(80,26,0,1,18,4),(81,26,0,1,18,4),(82,26,0,1,18,4),(83,26,0,1,18,4),(96,26,0,1,18,4),(97,26,0,1,18,4),(98,21,0,1,18,4),(98,22,0,1,18,4),(98,26,0,1,18,4),(99,18,0,1,18,4),(101,14,0,1,18,4),(101,15,0,1,18,4),(101,16,0,1,18,4),(102,12,0,1,18,4),(102,13,0,1,18,4),(102,14,0,1,18,4),(102,15,0,1,18,4),(102,16,0,1,18,4),(102,17,0,1,18,4),(102,19,0,1,18,4),(102,36,0,1,18,4),(102,37,0,1,18,4),(102,38,0,1,18,4),(102,39,0,1,18,4),(102,40,0,1,18,4),(103,18,0,1,18,4),(104,18,0,1,18,4),(105,18,0,1,18,4),(106,18,0,1,18,4),(107,18,0,1,18,4),(134,23,0,1,18,4),(135,22,0,1,18,4),(137,4,0,1,18,4),(137,28,0,1,18,4),(137,31,0,1,18,4),(137,34,0,1,18,4),(137,35,0,1,18,4),(138,28,0,1,18,4),(138,30,0,1,18,4),(138,32,0,1,18,4),(138,33,0,1,18,4),(139,28,0,1,18,4),(139,30,0,1,18,4),(139,32,0,1,18,4),(139,33,0,1,18,4),(140,28,0,1,18,4),(140,30,0,1,18,4),(140,32,0,1,18,4),(140,33,0,1,18,4),(145,1,0,1,18,4),(145,2,0,1,18,4),(145,3,0,1,18,4),(145,4,0,1,18,4),(145,5,0,1,18,4),(145,6,0,1,18,4),(145,7,0,1,18,4),(145,8,0,1,18,4),(145,9,0,1,18,4),(145,10,0,1,18,4),(145,11,0,1,18,4),(145,12,0,1,18,4),(145,13,0,1,18,4),(145,14,0,1,18,4),(145,15,0,1,18,4),(145,16,0,1,18,4),(145,17,0,1,18,4),(145,18,0,1,18,4),(145,19,0,1,18,4),(145,20,0,1,18,4),(145,21,0,1,18,4),(145,22,0,1,18,4),(145,23,0,1,18,4),(145,24,0,1,18,4),(145,25,0,1,18,4),(145,26,0,1,18,4),(145,27,0,1,18,4),(145,28,0,1,18,4),(145,29,0,1,18,4),(145,30,0,1,18,4),(145,31,0,1,18,4),(145,32,0,1,18,4),(145,33,0,1,18,4),(145,34,0,1,18,4),(145,35,0,1,18,4),(145,36,0,1,18,4),(145,37,0,1,18,4),(145,38,0,1,18,4),(145,39,0,1,18,4),(145,40,0,1,18,4),(145,41,0,1,18,4),(145,42,0,1,18,4),(145,43,0,1,18,4),(149,41,0,1,18,4),(150,50,0,1,18,4),(150,57,0,1,18,4),(150,58,0,1,18,4),(150,59,0,1,18,4),(150,60,0,1,18,4),(151,61,0,1,18,4),(151,62,0,1,18,4),(151,63,0,1,18,4),(151,64,0,1,18,4),(151,65,0,1,18,4),(151,66,0,1,18,4),(152,61,0,1,18,4),(152,63,0,1,18,4),(153,61,0,1,18,4),(153,63,0,1,18,4),(153,64,0,1,18,4),(153,65,0,1,18,4),(153,66,0,1,18,4),(154,61,0,1,18,4),(154,62,0,1,18,4),(154,64,0,1,18,4),(154,66,0,1,18,4),(155,61,0,1,18,4),(155,62,0,1,18,4),(155,64,0,1,18,4),(155,65,0,1,18,4),(155,66,0,1,18,4),(156,61,0,1,18,4),(156,62,0,1,18,4),(156,63,0,1,18,4),(156,64,0,1,18,4),(156,65,0,1,18,4),(156,66,0,1,18,4),(157,61,0,1,18,4),(157,62,0,1,18,4),(157,64,0,1,18,4),(157,65,0,1,18,4),(157,66,0,1,18,4),(158,61,0,1,18,4),(158,63,0,1,18,4),(158,64,0,1,18,4),(158,65,0,1,18,4),(158,66,0,1,18,4),(159,61,0,1,18,4),(159,62,0,1,18,4),(159,63,0,1,18,4),(159,64,0,1,18,4),(159,65,0,1,18,4),(159,66,0,1,18,4),(160,41,0,1,18,4),(160,68,0,1,18,4),(160,69,0,1,18,4),(160,70,0,1,18,4),(160,72,0,1,18,4),(160,73,0,1,18,4),(161,68,0,1,18,4),(161,69,0,1,18,4),(161,70,0,1,18,4),(161,71,0,1,18,4),(161,72,0,1,18,4),(162,68,0,1,18,4),(162,69,0,1,18,4),(162,72,0,1,18,4),(164,41,0,1,18,4),(164,70,0,1,18,4),(164,73,0,1,18,4),(166,41,0,1,18,4),(166,70,0,1,18,4),(166,73,0,1,18,4),(167,68,0,1,18,4),(167,69,0,1,18,4),(167,72,0,1,18,4),(168,71,0,1,18,4),(169,70,0,1,18,4),(171,70,0,1,18,4),(172,1,10000,0,18,4),(172,2,10000,0,18,4),(172,3,10000,0,18,4),(172,4,10000,0,18,4),(172,5,10000,0,18,4),(172,6,10000,0,18,4),(172,7,10000,0,18,4),(172,8,10000,0,18,4),(172,9,10000,0,18,4),(172,10,10000,0,18,4),(172,11,10000,0,18,4),(172,12,10000,0,18,4),(172,13,10000,0,18,4),(172,14,10000,0,18,4),(172,15,10000,0,18,4),(172,16,10000,0,18,4),(172,17,10000,0,18,4),(172,18,10000,0,18,4),(172,19,10000,0,18,4),(172,20,10000,0,18,4),(172,21,10000,0,18,4),(172,22,10000,0,18,4),(172,23,10000,0,18,4),(172,24,10000,0,18,4),(172,25,10000,0,18,4),(172,26,10000,0,18,4),(172,27,10000,0,18,4),(172,28,10000,0,18,4),(172,29,10000,0,18,4),(172,30,10000,0,18,4),(173,1,0,1,18,4),(173,2,0,1,18,4),(173,3,0,1,18,4),(173,4,0,1,18,4),(173,5,0,1,18,4),(173,6,0,1,18,4),(173,7,0,1,18,4),(173,8,0,1,18,4),(173,9,0,1,18,4),(173,10,0,1,18,4),(173,11,0,1,18,4),(173,12,0,1,18,4),(173,13,0,1,18,4),(173,14,0,1,18,4),(173,15,0,1,18,4),(173,16,0,1,18,4),(173,17,0,1,18,4),(173,18,0,1,18,4),(173,19,0,1,18,4),(173,20,0,1,18,4),(173,21,0,1,18,4),(173,22,0,1,18,4),(173,23,0,1,18,4),(173,24,0,1,18,4),(173,25,0,1,18,4),(173,26,0,1,18,4),(173,27,0,1,18,4),(173,28,0,1,18,4),(173,29,0,1,18,4),(173,30,0,1,18,4),(174,1,0,1,18,4),(174,2,0,1,18,4),(174,3,0,1,18,4),(174,4,0,1,18,4),(174,5,0,1,18,4),(174,6,0,1,18,4),(174,7,0,1,18,4),(174,8,0,1,18,4),(174,9,0,1,18,4),(174,10,0,1,18,4),(174,11,0,1,18,4),(174,12,0,1,18,4),(174,13,0,1,18,4),(174,14,0,1,18,4),(174,15,0,1,18,4),(174,16,0,1,18,4),(174,17,0,1,18,4),(174,18,0,1,18,4),(174,19,0,1,18,4),(174,20,0,1,18,4),(174,21,0,1,18,4),(174,22,0,1,18,4),(174,23,0,1,18,4),(174,24,0,1,18,4),(174,25,0,1,18,4),(174,26,0,1,18,4),(174,27,0,1,18,4),(174,28,0,1,18,4),(174,29,0,1,18,4),(174,30,0,1,18,4),(175,1,0,1,18,4),(175,2,0,1,18,4),(175,3,0,1,18,4),(175,4,0,1,18,4),(175,5,0,1,18,4),(175,6,0,1,18,4),(175,7,0,1,18,4),(175,8,0,1,18,4),(175,9,0,1,18,4),(175,10,0,1,18,4),(175,11,0,1,18,4),(175,12,0,1,18,4),(175,13,0,1,18,4),(175,14,0,1,18,4),(175,15,0,1,18,4),(175,16,0,1,18,4),(175,17,0,1,18,4),(175,18,0,1,18,4),(175,19,0,1,18,4),(175,20,0,1,18,4),(175,21,0,1,18,4),(175,22,0,1,18,4),(175,23,0,1,18,4),(175,24,0,1,18,4),(175,25,0,1,18,4),(175,26,0,1,18,4),(175,27,0,1,18,4),(175,28,0,1,18,4),(175,29,0,1,18,4),(175,30,0,1,18,4),(176,1,0,1,18,4),(176,2,0,1,18,4),(176,3,0,1,18,4),(176,4,0,1,18,4),(176,5,0,1,18,4),(176,6,0,1,18,4),(176,7,0,1,18,4),(176,8,0,1,18,4),(176,9,0,1,18,4),(176,10,0,1,18,4),(176,11,0,1,18,4),(176,12,0,1,18,4),(176,13,0,1,18,4),(176,14,0,1,18,4),(176,15,0,1,18,4),(176,16,0,1,18,4),(176,17,0,1,18,4),(176,18,0,1,18,4),(176,19,0,1,18,4),(176,20,0,1,18,4),(176,21,0,1,18,4),(176,22,0,1,18,4),(176,23,0,1,18,4),(176,24,0,1,18,4),(176,25,0,1,18,4),(176,26,0,1,18,4),(176,27,0,1,18,4),(176,28,0,1,18,4),(176,29,0,1,18,4),(176,30,0,1,18,4),(177,74,0,1,18,4),(177,75,0,1,18,4),(177,76,0,1,18,4),(177,77,0,1,18,4),(177,78,0,1,18,4),(177,79,0,1,18,4),(177,80,0,1,18,4),(178,74,10000,0,18,4),(178,75,10000,0,18,4),(178,76,10000,0,18,4),(178,77,10000,0,18,4),(178,78,10000,0,18,4),(178,79,10000,0,18,4),(178,80,10000,0,18,4),(178,81,10000,0,18,4),(178,82,10000,0,18,4),(178,83,10000,0,18,4),(178,84,10000,0,18,4),(178,85,10000,0,18,4),(178,86,10000,0,18,4),(178,87,10000,0,18,4),(178,88,10000,0,18,4),(178,113,10000,0,18,4),(178,114,10000,0,18,4),(178,115,10000,0,18,4),(178,116,10000,0,18,4),(178,117,10000,0,18,4),(178,118,10000,0,18,4),(178,119,10000,0,18,4),(178,120,10000,0,18,4),(178,121,10000,0,18,4),(178,122,10000,0,18,4),(178,123,10000,0,18,4),(178,124,10000,0,18,4),(178,125,10000,0,18,4),(178,126,10000,0,18,4),(178,127,10000,0,18,4),(178,128,10000,0,18,4),(178,129,10000,0,18,4),(178,130,10000,0,18,4),(178,131,10000,0,18,4),(178,132,10000,0,18,4),(178,133,10000,0,18,4),(178,134,10000,0,18,4),(178,135,10000,0,18,4),(178,136,10000,0,18,4),(178,137,10000,0,18,4),(178,138,10000,0,18,4),(178,139,10000,0,18,4),(178,140,10000,0,18,4),(178,141,10000,0,18,4),(178,142,10000,0,18,4),(178,143,10000,0,18,4),(178,144,10000,0,18,4),(178,145,10000,0,18,4),(178,146,10000,0,18,4),(178,147,10000,0,18,4),(178,148,10000,0,18,4),(178,149,10000,0,18,4),(178,150,10000,0,18,4),(178,151,10000,0,18,4),(178,152,10000,0,18,4),(178,153,10000,0,18,4),(178,154,10000,0,18,4),(178,155,10000,0,18,4),(178,156,10000,0,18,4),(178,157,10000,0,18,4),(178,158,10000,0,18,4),(178,159,10000,0,18,4),(178,160,10000,0,18,4),(178,161,10000,0,18,4),(178,162,10000,0,18,4),(178,163,10000,0,18,4),(178,164,10000,0,18,4),(178,165,10000,0,18,4),(178,166,10000,0,18,4),(178,167,10000,0,18,4),(178,168,10000,0,18,4),(178,169,10000,0,18,4),(178,170,10000,0,18,4),(178,171,10000,0,18,4),(178,172,10000,0,18,4),(178,173,10000,0,18,4),(178,174,10000,0,18,4),(178,175,10000,0,18,4),(178,176,10000,0,18,4),(178,177,10000,0,18,4),(178,178,10000,0,18,4),(178,179,10000,0,18,4),(178,180,10000,0,18,4),(178,181,10000,0,18,4),(178,182,10000,0,18,4),(178,183,10000,0,18,4),(178,184,10000,0,18,4),(178,185,10000,0,18,4),(178,186,10000,0,18,4),(178,187,10000,0,18,4),(178,188,10000,0,18,4),(178,189,10000,0,18,4),(178,190,10000,0,18,4),(178,191,10000,0,18,4),(178,192,10000,0,18,4),(178,193,10000,0,18,4),(178,194,10000,0,18,4),(178,195,10000,0,18,4),(178,196,10000,0,18,4),(178,197,10000,0,18,4),(178,198,10000,0,18,4),(178,199,10000,0,18,4),(178,200,10000,0,18,4),(178,201,10000,0,18,4),(178,202,10000,0,18,4),(178,203,10000,0,18,4),(178,204,10000,0,18,4),(178,205,10000,0,18,4),(178,206,10000,0,18,4),(178,207,10000,0,18,4),(178,208,10000,0,18,4),(178,209,10000,0,18,4),(178,210,10000,0,18,4),(178,211,10000,0,18,4),(178,212,10000,0,18,4),(178,213,10000,0,18,4),(178,214,10000,0,18,4),(178,215,10000,0,18,4),(178,216,10000,0,18,4),(178,217,10000,0,18,4),(178,218,10000,0,18,4),(178,219,10000,0,18,4),(178,220,10000,0,18,4),(178,221,10000,0,18,4),(178,222,10000,0,18,4),(178,223,10000,0,18,4),(178,224,10000,0,18,4),(178,225,10000,0,18,4),(178,226,10000,0,18,4),(178,227,10000,0,18,4),(178,228,10000,0,18,4),(178,229,10000,0,18,4),(178,230,10000,0,18,4),(178,231,10000,0,18,4),(178,232,10000,0,18,4),(178,233,10000,0,18,4),(178,234,10000,0,18,4),(178,235,10000,0,18,4),(178,236,10000,0,18,4),(178,237,10000,0,18,4),(178,238,10000,0,18,4),(178,239,10000,0,18,4),(178,240,10000,0,18,4),(178,241,10000,0,18,4),(178,244,10000,0,18,4),(178,246,10000,0,18,4),(178,251,10000,0,18,4),(178,255,10000,0,18,4),(178,258,10000,0,18,4),(178,259,10000,0,18,4),(178,260,10000,0,18,4),(178,261,10000,0,18,4),(178,262,10000,0,18,4),(178,263,10000,0,18,4),(179,81,0,1,18,4),(179,82,0,1,18,4),(179,83,0,1,18,4),(179,84,0,1,18,4),(179,85,0,1,18,4),(179,86,0,1,18,4),(179,87,0,1,18,4),(179,88,0,1,18,4),(180,81,0,1,18,4),(181,86,0,1,18,4),(182,82,0,1,18,4),(182,83,0,1,18,4),(182,84,0,1,18,4),(182,85,0,1,18,4),(182,87,0,1,18,4),(182,88,0,1,18,4),(183,82,0,1,18,4),(183,83,0,1,18,4),(183,84,0,1,18,4),(183,85,0,1,18,4),(183,86,0,1,18,4),(183,87,0,1,18,4),(183,88,0,1,18,4),(192,89,0,1,18,4),(192,90,0,1,18,4),(192,91,0,1,18,4),(192,92,0,1,18,4),(192,93,0,1,18,4),(192,94,0,1,18,4),(193,95,0,1,18,4),(193,96,0,1,18,4),(193,97,0,1,18,4),(193,98,0,1,18,4),(193,99,0,1,18,4),(193,100,0,1,18,4),(194,95,0,1,18,4),(194,96,0,1,18,4),(194,97,0,1,18,4),(194,98,0,1,18,4),(194,99,0,1,18,4),(194,100,0,1,18,4),(195,95,0,1,18,4),(195,96,0,1,18,4),(195,97,0,1,18,4),(195,98,0,1,18,4),(195,99,0,1,18,4),(195,100,0,1,18,4),(196,95,0,1,18,4),(196,96,0,1,18,4),(196,97,0,1,18,4),(196,98,0,1,18,4),(196,99,0,1,18,4),(196,100,0,1,18,4),(197,95,0,1,18,4),(197,96,0,1,18,4),(197,97,0,1,18,4),(197,98,0,1,18,4),(197,99,0,1,18,4),(197,100,0,1,18,4),(198,101,0,1,18,4),(198,109,0,1,18,4),(198,111,0,1,18,4),(198,112,0,1,18,4),(199,103,0,1,18,4),(199,110,0,1,18,4),(200,101,0,1,18,4),(200,102,0,1,18,4),(200,108,0,1,18,4),(201,104,0,1,18,4),(201,106,0,1,18,4),(202,101,0,1,18,4),(202,102,0,1,18,4),(202,103,0,1,18,4),(202,105,0,1,18,4),(202,107,0,1,18,4),(202,108,0,1,18,4),(202,110,0,1,18,4),(203,101,0,1,18,4),(203,102,0,1,18,4),(203,103,0,1,18,4),(203,104,0,1,18,4),(203,106,0,1,18,4),(203,108,0,1,18,4),(203,109,0,1,18,4),(204,101,0,1,18,4),(204,102,0,1,18,4),(204,103,0,1,18,4),(204,104,0,1,18,4),(204,105,0,1,18,4),(204,106,0,1,18,4),(204,107,0,1,18,4),(204,108,0,1,18,4),(205,101,0,1,18,4),(205,102,0,1,18,4),(205,103,0,1,18,4),(205,108,0,1,18,4),(205,109,0,1,18,4),(205,110,0,1,18,4),(205,111,0,1,18,4),(205,112,0,1,18,4),(206,113,10000,0,18,4),(206,114,10000,0,18,4),(206,115,10000,0,18,4),(206,116,10000,0,18,4),(206,117,10000,0,18,4),(206,118,10000,0,18,4),(206,119,10000,0,18,4),(207,114,0,1,18,4),(207,119,0,1,18,4),(209,114,0,1,18,4),(212,116,0,1,18,4),(212,118,0,1,18,4),(213,113,0,1,18,4),(218,117,0,1,18,4),(219,119,0,1,18,4),(220,119,0,1,18,4),(221,119,0,1,18,4),(222,114,0,1,18,4),(222,119,0,1,18,4),(223,114,0,1,18,4),(223,119,0,1,18,4),(229,113,0,1,18,4),(230,113,0,1,18,4),(231,113,0,1,18,4),(232,113,0,1,18,4),(233,113,0,1,18,4),(234,116,0,1,18,4),(234,118,0,1,18,4),(235,116,0,1,18,4),(235,118,0,1,18,4),(236,116,0,1,18,4),(236,118,0,1,18,4),(237,116,0,1,18,4),(237,118,0,1,18,4),(238,116,0,1,18,4),(238,118,0,1,18,4),(239,115,0,1,18,4),(241,115,0,1,18,4),(242,115,0,1,18,4),(243,115,0,1,18,4),(250,120,0,1,18,4),(250,121,0,1,18,4),(250,122,0,1,18,4),(250,123,0,1,18,4),(250,124,0,1,18,4),(250,125,0,1,18,4),(250,126,0,1,18,4),(250,127,0,1,18,4),(250,128,0,1,18,4),(250,129,0,1,18,4),(250,130,0,1,18,4),(250,131,0,1,18,4),(251,120,0,1,18,4),(251,121,0,1,18,4),(251,122,0,1,18,4),(251,123,0,1,18,4),(251,124,0,1,18,4),(251,125,0,1,18,4),(251,126,0,1,18,4),(251,127,0,1,18,4),(251,128,0,1,18,4),(251,129,0,1,18,4),(251,130,0,1,18,4),(251,131,0,1,18,4),(252,125,10000,0,18,4),(252,126,10000,0,18,4),(252,127,10000,0,18,4),(252,120,0,1,18,4),(252,121,0,1,18,4),(252,122,0,1,18,4),(252,123,0,1,18,4),(252,124,0,1,18,4),(252,128,0,1,18,4),(252,129,0,1,18,4),(252,131,0,1,18,4),(253,120,0,1,18,4),(253,121,0,1,18,4),(253,122,0,1,18,4),(253,123,0,1,18,4),(253,124,0,1,18,4),(253,125,0,1,18,4),(253,126,0,1,18,4),(253,127,0,1,18,4),(253,128,0,1,18,4),(253,129,0,1,18,4),(253,130,0,1,18,4),(253,131,0,1,18,4),(254,120,0,1,18,4),(254,121,0,1,18,4),(254,122,0,1,18,4),(254,123,0,1,18,4),(254,124,0,1,18,4),(254,125,0,1,18,4),(254,126,0,1,18,4),(254,127,0,1,18,4),(254,128,0,1,18,4),(254,129,0,1,18,4),(254,130,0,1,18,4),(254,131,0,1,18,4),(255,122,0,1,18,4),(255,123,0,1,18,4),(255,124,0,1,18,4),(255,125,0,1,18,4),(255,126,0,1,18,4),(255,129,0,1,18,4),(256,121,0,1,18,4),(256,122,0,1,18,4),(256,123,0,1,18,4),(256,125,0,1,18,4),(256,126,0,1,18,4),(256,127,0,1,18,4),(257,121,0,1,18,4),(257,122,0,1,18,4),(257,123,0,1,18,4),(257,125,0,1,18,4),(257,127,0,1,18,4),(257,129,0,1,18,4),(258,121,0,1,18,4),(258,122,0,1,18,4),(258,125,0,1,18,4),(258,126,0,1,18,4),(258,127,0,1,18,4),(258,129,0,1,18,4),(259,120,0,1,18,4),(259,121,0,1,18,4),(259,123,0,1,18,4),(259,128,0,1,18,4),(259,129,0,1,18,4),(260,120,0,1,18,4),(260,121,0,1,18,4),(260,122,0,1,18,4),(260,123,0,1,18,4),(260,125,0,1,18,4),(260,127,0,1,18,4),(260,128,0,1,18,4),(260,129,0,1,18,4),(261,121,0,1,18,4),(261,122,0,1,18,4),(261,125,0,1,18,4),(261,126,0,1,18,4),(261,127,0,1,18,4),(261,129,0,1,18,4),(262,125,0,1,18,4),(262,126,0,1,18,4),(263,120,0,1,18,4),(263,121,0,1,18,4),(263,122,0,1,18,4),(263,123,0,1,18,4),(263,124,0,1,18,4),(263,128,0,1,18,4),(263,129,0,1,18,4),(263,131,0,1,18,4),(264,120,0,1,18,4),(264,122,0,1,18,4),(264,123,0,1,18,4),(264,125,0,1,18,4),(264,126,0,1,18,4),(264,129,0,1,18,4),(265,121,0,1,18,4),(265,122,0,1,18,4),(265,123,0,1,18,4),(265,127,0,1,18,4),(266,123,0,1,18,4),(266,125,0,1,18,4),(266,126,0,1,18,4),(266,127,0,1,18,4),(266,129,0,1,18,4),(267,121,0,1,18,4),(267,125,0,1,18,4),(267,126,0,1,18,4),(267,127,0,1,18,4),(268,120,0,1,18,4),(268,121,0,1,18,4),(268,122,0,1,18,4),(268,123,0,1,18,4),(268,124,0,1,18,4),(268,127,0,1,18,4),(268,129,0,1,18,4),(269,122,0,1,18,4),(269,125,0,1,18,4),(269,126,0,1,18,4),(269,127,0,1,18,4),(269,129,0,1,18,4),(270,121,0,1,18,4),(270,123,0,1,18,4),(270,125,0,1,18,4),(270,126,0,1,18,4),(270,129,0,1,18,4),(271,120,0,1,18,4),(271,121,0,1,18,4),(271,122,0,1,18,4),(271,125,0,1,18,4),(271,126,0,1,18,4),(271,127,0,1,18,4),(271,129,0,1,18,4),(272,122,0,1,18,4),(272,123,0,1,18,4),(272,124,0,1,18,4),(272,125,0,1,18,4),(272,126,0,1,18,4),(272,127,0,1,18,4),(272,128,0,1,18,4),(272,129,0,1,18,4),(273,120,0,1,18,4),(273,121,0,1,18,4),(273,123,0,1,18,4),(273,126,0,1,18,4),(273,127,0,1,18,4),(274,122,0,1,18,4),(274,123,0,1,18,4),(274,125,0,1,18,4),(274,126,0,1,18,4),(274,129,0,1,18,4),(275,120,0,1,18,4),(275,121,0,1,18,4),(275,122,0,1,18,4),(275,123,0,1,18,4),(275,124,0,1,18,4),(275,125,0,1,18,4),(275,126,0,1,18,4),(275,127,0,1,18,4),(275,128,0,1,18,4),(275,129,0,1,18,4),(275,130,0,1,18,4),(275,131,0,1,18,4),(276,122,0,1,18,4),(276,123,0,1,18,4),(276,127,0,1,18,4),(276,129,0,1,18,4),(277,120,0,1,18,4),(277,121,0,1,18,4),(277,123,0,1,18,4),(277,124,0,1,18,4),(277,125,0,1,18,4),(277,126,0,1,18,4),(277,127,0,1,18,4),(278,120,0,1,18,4),(278,121,0,1,18,4),(278,122,0,1,18,4),(278,123,0,1,18,4),(278,124,0,1,18,4),(278,125,0,1,18,4),(278,127,0,1,18,4),(278,128,0,1,18,4),(278,129,0,1,18,4),(279,120,0,1,18,4),(279,122,0,1,18,4),(279,126,0,1,18,4),(279,127,0,1,18,4),(279,129,0,1,18,4),(280,132,0,1,18,4),(280,133,0,1,18,4),(280,134,0,1,18,4),(280,135,0,1,18,4),(280,136,0,1,18,4),(280,137,0,1,18,4),(280,138,0,1,18,4),(280,139,0,1,18,4),(282,132,0,1,18,4),(282,133,0,1,18,4),(282,134,0,1,18,4),(282,137,0,1,18,4),(282,138,0,1,18,4),(283,135,0,1,18,4),(283,136,0,1,18,4),(283,139,0,1,18,4),(286,140,0,1,18,4),(286,141,0,1,18,4),(286,142,0,1,18,4),(286,143,0,1,18,4),(286,144,0,1,18,4),(286,145,0,1,18,4),(286,146,0,1,18,4),(286,147,0,1,18,4),(286,148,0,1,18,4),(286,149,0,1,18,4),(286,150,0,1,18,4),(286,151,0,1,18,4),(286,152,0,1,18,4),(286,153,0,1,18,4),(286,154,0,1,18,4),(286,155,0,1,18,4),(286,156,0,1,18,4),(286,157,0,1,18,4),(286,158,0,1,18,4),(286,159,0,1,18,4),(286,160,0,1,18,4),(286,161,0,1,18,4),(286,162,0,1,18,4),(286,163,0,1,18,4),(286,164,0,1,18,4),(286,165,0,1,18,4),(286,166,0,1,18,4),(286,167,0,1,18,4),(286,168,0,1,18,4),(286,169,0,1,18,4),(286,170,0,1,18,4),(286,171,0,1,18,4),(286,172,0,1,18,4),(286,173,0,1,18,4),(286,174,0,1,18,4),(286,175,0,1,18,4),(286,176,0,1,18,4),(286,177,0,1,18,4),(286,178,0,1,18,4),(286,179,0,1,18,4),(286,180,0,1,18,4),(286,181,0,1,18,4),(286,182,0,1,18,4),(286,183,0,1,18,4),(286,184,0,1,18,4),(286,185,0,1,18,4),(286,186,0,1,18,4),(286,187,0,1,18,4),(287,188,0,1,18,4),(288,189,0,1,18,4),(288,190,0,1,18,4),(288,191,0,1,18,4),(288,192,0,1,18,4),(288,193,0,1,18,4),(288,194,0,1,18,4),(288,195,0,1,18,4),(288,196,0,1,18,4),(288,197,0,1,18,4),(288,198,0,1,18,4),(288,199,0,1,18,4),(288,200,0,1,18,4),(289,201,10000,0,18,4),(289,202,10000,0,18,4),(289,203,10000,0,18,4),(289,204,10000,0,18,4),(289,205,10000,0,18,4),(289,206,10000,0,18,4),(289,207,10000,0,18,4),(289,208,10000,0,18,4),(289,209,10000,0,18,4),(289,210,10000,0,18,4),(289,211,10000,0,18,4),(289,212,10000,0,18,4),(289,213,10000,0,18,4),(289,214,10000,0,18,4),(289,215,10000,0,18,4),(289,216,10000,0,18,4),(289,217,10000,0,18,4),(289,218,10000,0,18,4),(289,219,10000,0,18,4),(289,220,10000,0,18,4),(289,221,10000,0,18,4),(289,222,10000,0,18,4),(289,223,10000,0,18,4),(289,224,10000,0,18,4),(289,225,10000,0,18,4),(289,226,10000,0,18,4),(289,227,10000,0,18,4),(289,228,10000,0,18,4),(289,229,10000,0,18,4),(289,230,10000,0,18,4),(289,231,10000,0,18,4),(289,232,10000,0,18,4),(289,244,10000,0,18,4),(289,246,10000,0,18,4),(289,251,10000,0,18,4),(289,255,10000,0,18,4),(289,258,10000,0,18,4),(289,259,10000,0,18,4),(289,260,10000,0,18,4),(289,261,10000,0,18,4),(289,262,10000,0,18,4),(289,263,10000,0,18,4),(290,209,0,1,18,4),(290,210,0,1,18,4),(290,211,0,1,18,4),(290,212,0,1,18,4),(290,213,0,1,18,4),(290,214,0,1,18,4),(290,215,0,1,18,4),(290,216,0,1,18,4),(291,201,0,1,18,4),(291,202,0,1,18,4),(291,203,0,1,18,4),(291,204,0,1,18,4),(291,205,0,1,18,4),(291,206,0,1,18,4),(291,207,0,1,18,4),(291,208,0,1,18,4),(292,217,0,1,18,4),(292,218,0,1,18,4),(292,219,0,1,18,4),(292,220,0,1,18,4),(292,221,0,1,18,4),(292,222,0,1,18,4),(292,223,0,1,18,4),(292,224,0,1,18,4),(293,225,0,1,18,4),(293,226,0,1,18,4),(293,227,0,1,18,4),(293,228,0,1,18,4),(293,229,0,1,18,4),(293,230,0,1,18,4),(293,231,0,1,18,4),(293,232,0,1,18,4),(293,255,0,1,18,4),(293,259,0,1,18,4),(293,260,0,1,18,4),(293,261,0,1,18,4),(293,262,0,1,18,4),(293,263,0,1,18,4),(294,233,0,1,18,4),(294,234,0,1,18,4),(294,235,0,1,18,4),(294,236,0,1,18,4),(294,237,0,1,18,4),(294,238,0,1,18,4),(294,239,0,1,18,4),(294,240,0,1,18,4),(294,241,0,1,18,4),(295,244,0,1,18,4),(295,246,0,1,18,4),(295,251,0,1,18,4),(295,255,0,1,18,4),(295,258,0,1,18,4),(296,251,0,1,18,4),(296,255,0,1,18,4),(296,258,0,1,18,4),(297,246,0,1,18,4),(297,255,0,1,18,4),(297,258,0,1,18,4),(298,255,0,1,18,4),(298,258,0,1,18,4),(299,251,0,1,18,4),(299,258,0,1,18,4);
/*!40000 ALTER TABLE `catalog_category_product_index_store18` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index_store18_replica`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store18_replica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store18_replica` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `CAT_CTGR_PRD_IDX_STORE18_PRD_ID_STORE_ID_CTGR_ID_VISIBILITY` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_3AC23404BB83160D5EE72D270D5C65B0` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Product Index Store18 Replica';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index_store18_replica`
--

LOCK TABLES `catalog_category_product_index_store18_replica` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index_store18_replica` DISABLE KEYS */;
INSERT INTO `catalog_category_product_index_store18_replica` VALUES (2,1,0,1,18,4),(2,2,0,1,18,4),(2,3,0,1,18,4),(2,4,0,1,18,4),(2,5,0,1,18,4),(2,6,0,1,18,4),(2,7,0,1,18,4),(2,8,0,1,18,4),(2,9,0,1,18,4),(2,10,0,1,18,4),(2,11,0,1,18,4),(2,12,0,1,18,4),(2,13,0,1,18,4),(2,14,0,1,18,4),(2,15,0,1,18,4),(2,16,0,1,18,4),(2,17,0,1,18,4),(2,18,0,1,18,4),(2,19,0,1,18,4),(2,20,0,1,18,4),(2,21,0,1,18,4),(2,22,0,1,18,4),(2,23,0,1,18,4),(2,24,0,1,18,4),(2,25,0,1,18,4),(2,26,0,1,18,4),(2,27,0,1,18,4),(2,28,0,1,18,4),(2,29,0,1,18,4),(2,30,0,1,18,4),(2,31,0,1,18,4),(2,32,0,1,18,4),(2,33,0,1,18,4),(2,34,0,1,18,4),(2,35,0,1,18,4),(2,36,0,1,18,4),(2,37,0,1,18,4),(2,38,0,1,18,4),(2,39,0,1,18,4),(2,40,0,1,18,4),(2,41,0,1,18,4),(2,42,0,1,18,4),(2,43,0,1,18,4),(2,44,0,1,18,4),(2,45,0,1,18,4),(2,46,0,1,18,4),(2,47,0,1,18,4),(2,48,0,1,18,4),(2,49,0,1,18,4),(2,50,0,1,18,4),(2,57,0,1,18,4),(2,58,0,1,18,4),(2,59,0,1,18,4),(2,60,0,1,18,4),(2,61,0,1,18,4),(2,62,0,1,18,4),(2,63,0,1,18,4),(2,64,0,1,18,4),(2,65,0,1,18,4),(2,66,0,1,18,4),(2,68,0,1,18,4),(2,69,0,1,18,4),(2,70,0,1,18,4),(2,71,0,1,18,4),(2,72,0,1,18,4),(2,73,0,1,18,4),(2,74,0,1,18,4),(2,75,0,1,18,4),(2,76,0,1,18,4),(2,77,0,1,18,4),(2,78,0,1,18,4),(2,79,0,1,18,4),(2,80,0,1,18,4),(2,81,0,1,18,4),(2,82,0,1,18,4),(2,83,0,1,18,4),(2,84,0,1,18,4),(2,85,0,1,18,4),(2,86,0,1,18,4),(2,87,0,1,18,4),(2,88,0,1,18,4),(2,89,0,1,18,4),(2,90,0,1,18,4),(2,91,0,1,18,4),(2,92,0,1,18,4),(2,93,0,1,18,4),(2,94,0,1,18,4),(2,95,0,1,18,4),(2,96,0,1,18,4),(2,97,0,1,18,4),(2,98,0,1,18,4),(2,99,0,1,18,4),(2,100,0,1,18,4),(2,101,0,1,18,4),(2,102,0,1,18,4),(2,103,0,1,18,4),(2,104,0,1,18,4),(2,105,0,1,18,4),(2,106,0,1,18,4),(2,107,0,1,18,4),(2,108,0,1,18,4),(2,109,0,1,18,4),(2,110,0,1,18,4),(2,111,0,1,18,4),(2,112,0,1,18,4),(2,113,0,1,18,4),(2,114,0,1,18,4),(2,115,0,1,18,4),(2,116,0,1,18,4),(2,117,0,1,18,4),(2,118,0,1,18,4),(2,119,0,1,18,4),(2,120,0,1,18,4),(2,121,0,1,18,4),(2,122,0,1,18,4),(2,123,0,1,18,4),(2,124,0,1,18,4),(2,125,0,1,18,4),(2,126,0,1,18,4),(2,127,0,1,18,4),(2,128,0,1,18,4),(2,129,0,1,18,4),(2,130,0,1,18,4),(2,131,0,1,18,4),(2,132,0,1,18,4),(2,133,0,1,18,4),(2,134,0,1,18,4),(2,135,0,1,18,4),(2,136,0,1,18,4),(2,137,0,1,18,4),(2,138,0,1,18,4),(2,139,0,1,18,4),(2,140,0,1,18,4),(2,141,0,1,18,4),(2,142,0,1,18,4),(2,143,0,1,18,4),(2,144,0,1,18,4),(2,145,0,1,18,4),(2,146,0,1,18,4),(2,147,0,1,18,4),(2,148,0,1,18,4),(2,149,0,1,18,4),(2,150,0,1,18,4),(2,151,0,1,18,4),(2,152,0,1,18,4),(2,153,0,1,18,4),(2,154,0,1,18,4),(2,155,0,1,18,4),(2,156,0,1,18,4),(2,157,0,1,18,4),(2,158,0,1,18,4),(2,159,0,1,18,4),(2,160,0,1,18,4),(2,161,0,1,18,4),(2,162,0,1,18,4),(2,163,0,1,18,4),(2,164,0,1,18,4),(2,165,0,1,18,4),(2,166,0,1,18,4),(2,167,0,1,18,4),(2,168,0,1,18,4),(2,169,0,1,18,4),(2,170,0,1,18,4),(2,171,0,1,18,4),(2,172,0,1,18,4),(2,173,0,1,18,4),(2,174,0,1,18,4),(2,175,0,1,18,4),(2,176,0,1,18,4),(2,177,0,1,18,4),(2,178,0,1,18,4),(2,179,0,1,18,4),(2,180,0,1,18,4),(2,181,0,1,18,4),(2,182,0,1,18,4),(2,183,0,1,18,4),(2,184,0,1,18,4),(2,185,0,1,18,4),(2,186,0,1,18,4),(2,187,0,1,18,4),(2,188,0,1,18,4),(2,189,0,1,18,4),(2,190,0,1,18,4),(2,191,0,1,18,4),(2,192,0,1,18,4),(2,193,0,1,18,4),(2,194,0,1,18,4),(2,195,0,1,18,4),(2,196,0,1,18,4),(2,197,0,1,18,4),(2,198,0,1,18,4),(2,199,0,1,18,4),(2,200,0,1,18,4),(2,201,0,1,18,4),(2,202,0,1,18,4),(2,203,0,1,18,4),(2,204,0,1,18,4),(2,205,0,1,18,4),(2,206,0,1,18,4),(2,207,0,1,18,4),(2,208,0,1,18,4),(2,209,0,1,18,4),(2,210,0,1,18,4),(2,211,0,1,18,4),(2,212,0,1,18,4),(2,213,0,1,18,4),(2,214,0,1,18,4),(2,215,0,1,18,4),(2,216,0,1,18,4),(2,217,0,1,18,4),(2,218,0,1,18,4),(2,219,0,1,18,4),(2,220,0,1,18,4),(2,221,0,1,18,4),(2,222,0,1,18,4),(2,223,0,1,18,4),(2,224,0,1,18,4),(2,225,0,1,18,4),(2,226,0,1,18,4),(2,227,0,1,18,4),(2,228,0,1,18,4),(2,229,0,1,18,4),(2,230,0,1,18,4),(2,231,0,1,18,4),(2,232,0,1,18,4),(2,233,0,1,18,4),(2,234,0,1,18,4),(2,235,0,1,18,4),(2,236,0,1,18,4),(2,237,0,1,18,4),(2,238,0,1,18,4),(2,239,0,1,18,4),(2,240,0,1,18,4),(2,241,0,1,18,4),(2,244,0,1,18,4),(2,246,0,1,18,4),(2,251,0,1,18,4),(2,255,0,1,18,4),(2,258,0,1,18,4),(2,259,0,1,18,4),(2,260,0,1,18,4),(2,261,0,1,18,4),(2,262,0,1,18,4),(2,263,0,1,18,4),(3,1,0,1,18,4),(3,2,0,1,18,4),(3,3,0,1,18,4),(3,4,0,1,18,4),(3,5,0,1,18,4),(3,6,0,1,18,4),(3,7,0,1,18,4),(3,8,0,1,18,4),(3,10,0,1,18,4),(3,11,0,1,18,4),(4,12,0,1,18,4),(4,13,0,1,18,4),(4,14,0,1,18,4),(4,15,0,1,18,4),(4,16,0,1,18,4),(4,17,0,1,18,4),(4,18,0,1,18,4),(4,19,0,1,18,4),(4,36,0,1,18,4),(4,37,0,1,18,4),(4,38,0,1,18,4),(4,39,0,1,18,4),(4,40,0,1,18,4),(5,95,10000,0,18,4),(5,96,10000,0,18,4),(5,97,10000,0,18,4),(5,98,10000,0,18,4),(5,99,10000,0,18,4),(5,100,10000,0,18,4),(7,101,10000,0,18,4),(7,102,10000,0,18,4),(7,103,10000,0,18,4),(7,104,10000,0,18,4),(7,105,10000,0,18,4),(7,106,10000,0,18,4),(7,107,10000,0,18,4),(7,108,10000,0,18,4),(7,109,10000,0,18,4),(7,110,10000,0,18,4),(7,111,10000,0,18,4),(7,112,10000,0,18,4),(7,21,0,1,18,4),(7,22,0,1,18,4),(7,26,0,1,18,4),(8,61,0,1,18,4),(8,62,0,1,18,4),(8,63,0,1,18,4),(8,64,0,1,18,4),(8,65,0,1,18,4),(8,66,0,1,18,4),(11,4,10000,0,18,4),(11,89,10000,0,18,4),(11,90,10000,0,18,4),(11,91,10000,0,18,4),(11,92,10000,0,18,4),(11,93,10000,0,18,4),(11,94,10000,0,18,4),(11,28,0,1,18,4),(11,29,0,1,18,4),(11,30,0,1,18,4),(11,31,0,1,18,4),(11,32,0,1,18,4),(11,33,0,1,18,4),(11,34,0,1,18,4),(11,35,0,1,18,4),(13,21,0,1,18,4),(13,24,0,1,18,4),(13,25,0,1,18,4),(13,26,0,1,18,4),(13,27,0,1,18,4),(13,41,0,1,18,4),(13,42,0,1,18,4),(13,43,0,1,18,4),(13,44,0,1,18,4),(13,45,0,1,18,4),(13,46,0,1,18,4),(13,47,0,1,18,4),(13,48,0,1,18,4),(13,49,0,1,18,4),(15,22,10000,0,18,4),(15,23,10000,0,18,4),(16,20,0,1,18,4),(16,21,0,1,18,4),(16,22,0,1,18,4),(16,23,0,1,18,4),(16,24,0,1,18,4),(16,25,0,1,18,4),(16,26,0,1,18,4),(16,27,0,1,18,4),(16,41,0,1,18,4),(16,68,0,1,18,4),(16,69,0,1,18,4),(16,70,0,1,18,4),(16,71,0,1,18,4),(16,72,0,1,18,4),(16,73,0,1,18,4),(19,6,0,1,18,4),(19,7,0,1,18,4),(19,8,0,1,18,4),(19,10,0,1,18,4),(19,11,0,1,18,4),(27,11,0,1,18,4),(29,6,0,1,18,4),(29,8,0,1,18,4),(29,10,0,1,18,4),(30,6,0,1,18,4),(30,10,0,1,18,4),(33,7,0,1,18,4),(33,8,0,1,18,4),(33,10,0,1,18,4),(33,11,0,1,18,4),(42,7,0,1,18,4),(42,8,0,1,18,4),(42,11,0,1,18,4),(78,21,0,1,18,4),(78,26,0,1,18,4),(80,21,0,1,18,4),(80,22,0,1,18,4),(80,26,0,1,18,4),(81,26,0,1,18,4),(82,26,0,1,18,4),(83,26,0,1,18,4),(96,26,0,1,18,4),(97,26,0,1,18,4),(98,21,0,1,18,4),(98,22,0,1,18,4),(98,26,0,1,18,4),(99,18,0,1,18,4),(101,14,0,1,18,4),(101,15,0,1,18,4),(101,16,0,1,18,4),(102,12,0,1,18,4),(102,13,0,1,18,4),(102,14,0,1,18,4),(102,15,0,1,18,4),(102,16,0,1,18,4),(102,17,0,1,18,4),(102,19,0,1,18,4),(102,36,0,1,18,4),(102,37,0,1,18,4),(102,38,0,1,18,4),(102,39,0,1,18,4),(102,40,0,1,18,4),(103,18,0,1,18,4),(104,18,0,1,18,4),(105,18,0,1,18,4),(106,18,0,1,18,4),(107,18,0,1,18,4),(134,23,0,1,18,4),(135,22,0,1,18,4),(137,4,0,1,18,4),(137,28,0,1,18,4),(137,31,0,1,18,4),(137,34,0,1,18,4),(137,35,0,1,18,4),(138,28,0,1,18,4),(138,30,0,1,18,4),(138,32,0,1,18,4),(138,33,0,1,18,4),(139,28,0,1,18,4),(139,30,0,1,18,4),(139,32,0,1,18,4),(139,33,0,1,18,4),(140,28,0,1,18,4),(140,30,0,1,18,4),(140,32,0,1,18,4),(140,33,0,1,18,4),(145,1,0,1,18,4),(145,2,0,1,18,4),(145,3,0,1,18,4),(145,4,0,1,18,4),(145,5,0,1,18,4),(145,6,0,1,18,4),(145,7,0,1,18,4),(145,8,0,1,18,4),(145,9,0,1,18,4),(145,10,0,1,18,4),(145,11,0,1,18,4),(145,12,0,1,18,4),(145,13,0,1,18,4),(145,14,0,1,18,4),(145,15,0,1,18,4),(145,16,0,1,18,4),(145,17,0,1,18,4),(145,18,0,1,18,4),(145,19,0,1,18,4),(145,20,0,1,18,4),(145,21,0,1,18,4),(145,22,0,1,18,4),(145,23,0,1,18,4),(145,24,0,1,18,4),(145,25,0,1,18,4),(145,26,0,1,18,4),(145,27,0,1,18,4),(145,28,0,1,18,4),(145,29,0,1,18,4),(145,30,0,1,18,4),(145,31,0,1,18,4),(145,32,0,1,18,4),(145,33,0,1,18,4),(145,34,0,1,18,4),(145,35,0,1,18,4),(145,36,0,1,18,4),(145,37,0,1,18,4),(145,38,0,1,18,4),(145,39,0,1,18,4),(145,40,0,1,18,4),(145,41,0,1,18,4),(145,42,0,1,18,4),(145,43,0,1,18,4),(149,41,0,1,18,4),(150,50,0,1,18,4),(150,57,0,1,18,4),(150,58,0,1,18,4),(150,59,0,1,18,4),(150,60,0,1,18,4),(151,61,0,1,18,4),(151,62,0,1,18,4),(151,63,0,1,18,4),(151,64,0,1,18,4),(151,65,0,1,18,4),(151,66,0,1,18,4),(152,61,0,1,18,4),(152,63,0,1,18,4),(153,61,0,1,18,4),(153,63,0,1,18,4),(153,64,0,1,18,4),(153,65,0,1,18,4),(153,66,0,1,18,4),(154,61,0,1,18,4),(154,62,0,1,18,4),(154,64,0,1,18,4),(154,66,0,1,18,4),(155,61,0,1,18,4),(155,62,0,1,18,4),(155,64,0,1,18,4),(155,65,0,1,18,4),(155,66,0,1,18,4),(156,61,0,1,18,4),(156,62,0,1,18,4),(156,63,0,1,18,4),(156,64,0,1,18,4),(156,65,0,1,18,4),(156,66,0,1,18,4),(157,61,0,1,18,4),(157,62,0,1,18,4),(157,64,0,1,18,4),(157,65,0,1,18,4),(157,66,0,1,18,4),(158,61,0,1,18,4),(158,63,0,1,18,4),(158,64,0,1,18,4),(158,65,0,1,18,4),(158,66,0,1,18,4),(159,61,0,1,18,4),(159,62,0,1,18,4),(159,63,0,1,18,4),(159,64,0,1,18,4),(159,65,0,1,18,4),(159,66,0,1,18,4),(160,41,0,1,18,4),(160,68,0,1,18,4),(160,69,0,1,18,4),(160,70,0,1,18,4),(160,72,0,1,18,4),(160,73,0,1,18,4),(161,68,0,1,18,4),(161,69,0,1,18,4),(161,70,0,1,18,4),(161,71,0,1,18,4),(161,72,0,1,18,4),(162,68,0,1,18,4),(162,69,0,1,18,4),(162,72,0,1,18,4),(164,41,0,1,18,4),(164,70,0,1,18,4),(164,73,0,1,18,4),(166,41,0,1,18,4),(166,70,0,1,18,4),(166,73,0,1,18,4),(167,68,0,1,18,4),(167,69,0,1,18,4),(167,72,0,1,18,4),(168,71,0,1,18,4),(169,70,0,1,18,4),(171,70,0,1,18,4),(172,1,10000,0,18,4),(172,2,10000,0,18,4),(172,3,10000,0,18,4),(172,4,10000,0,18,4),(172,5,10000,0,18,4),(172,6,10000,0,18,4),(172,7,10000,0,18,4),(172,8,10000,0,18,4),(172,9,10000,0,18,4),(172,10,10000,0,18,4),(172,11,10000,0,18,4),(172,12,10000,0,18,4),(172,13,10000,0,18,4),(172,14,10000,0,18,4),(172,15,10000,0,18,4),(172,16,10000,0,18,4),(172,17,10000,0,18,4),(172,18,10000,0,18,4),(172,19,10000,0,18,4),(172,20,10000,0,18,4),(172,21,10000,0,18,4),(172,22,10000,0,18,4),(172,23,10000,0,18,4),(172,24,10000,0,18,4),(172,25,10000,0,18,4),(172,26,10000,0,18,4),(172,27,10000,0,18,4),(172,28,10000,0,18,4),(172,29,10000,0,18,4),(172,30,10000,0,18,4),(173,1,0,1,18,4),(173,2,0,1,18,4),(173,3,0,1,18,4),(173,4,0,1,18,4),(173,5,0,1,18,4),(173,6,0,1,18,4),(173,7,0,1,18,4),(173,8,0,1,18,4),(173,9,0,1,18,4),(173,10,0,1,18,4),(173,11,0,1,18,4),(173,12,0,1,18,4),(173,13,0,1,18,4),(173,14,0,1,18,4),(173,15,0,1,18,4),(173,16,0,1,18,4),(173,17,0,1,18,4),(173,18,0,1,18,4),(173,19,0,1,18,4),(173,20,0,1,18,4),(173,21,0,1,18,4),(173,22,0,1,18,4),(173,23,0,1,18,4),(173,24,0,1,18,4),(173,25,0,1,18,4),(173,26,0,1,18,4),(173,27,0,1,18,4),(173,28,0,1,18,4),(173,29,0,1,18,4),(173,30,0,1,18,4),(174,1,0,1,18,4),(174,2,0,1,18,4),(174,3,0,1,18,4),(174,4,0,1,18,4),(174,5,0,1,18,4),(174,6,0,1,18,4),(174,7,0,1,18,4),(174,8,0,1,18,4),(174,9,0,1,18,4),(174,10,0,1,18,4),(174,11,0,1,18,4),(174,12,0,1,18,4),(174,13,0,1,18,4),(174,14,0,1,18,4),(174,15,0,1,18,4),(174,16,0,1,18,4),(174,17,0,1,18,4),(174,18,0,1,18,4),(174,19,0,1,18,4),(174,20,0,1,18,4),(174,21,0,1,18,4),(174,22,0,1,18,4),(174,23,0,1,18,4),(174,24,0,1,18,4),(174,25,0,1,18,4),(174,26,0,1,18,4),(174,27,0,1,18,4),(174,28,0,1,18,4),(174,29,0,1,18,4),(174,30,0,1,18,4),(175,1,0,1,18,4),(175,2,0,1,18,4),(175,3,0,1,18,4),(175,4,0,1,18,4),(175,5,0,1,18,4),(175,6,0,1,18,4),(175,7,0,1,18,4),(175,8,0,1,18,4),(175,9,0,1,18,4),(175,10,0,1,18,4),(175,11,0,1,18,4),(175,12,0,1,18,4),(175,13,0,1,18,4),(175,14,0,1,18,4),(175,15,0,1,18,4),(175,16,0,1,18,4),(175,17,0,1,18,4),(175,18,0,1,18,4),(175,19,0,1,18,4),(175,20,0,1,18,4),(175,21,0,1,18,4),(175,22,0,1,18,4),(175,23,0,1,18,4),(175,24,0,1,18,4),(175,25,0,1,18,4),(175,26,0,1,18,4),(175,27,0,1,18,4),(175,28,0,1,18,4),(175,29,0,1,18,4),(175,30,0,1,18,4),(176,1,0,1,18,4),(176,2,0,1,18,4),(176,3,0,1,18,4),(176,4,0,1,18,4),(176,5,0,1,18,4),(176,6,0,1,18,4),(176,7,0,1,18,4),(176,8,0,1,18,4),(176,9,0,1,18,4),(176,10,0,1,18,4),(176,11,0,1,18,4),(176,12,0,1,18,4),(176,13,0,1,18,4),(176,14,0,1,18,4),(176,15,0,1,18,4),(176,16,0,1,18,4),(176,17,0,1,18,4),(176,18,0,1,18,4),(176,19,0,1,18,4),(176,20,0,1,18,4),(176,21,0,1,18,4),(176,22,0,1,18,4),(176,23,0,1,18,4),(176,24,0,1,18,4),(176,25,0,1,18,4),(176,26,0,1,18,4),(176,27,0,1,18,4),(176,28,0,1,18,4),(176,29,0,1,18,4),(176,30,0,1,18,4),(177,74,0,1,18,4),(177,75,0,1,18,4),(177,76,0,1,18,4),(177,77,0,1,18,4),(177,78,0,1,18,4),(177,79,0,1,18,4),(177,80,0,1,18,4),(178,74,10000,0,18,4),(178,75,10000,0,18,4),(178,76,10000,0,18,4),(178,77,10000,0,18,4),(178,78,10000,0,18,4),(178,79,10000,0,18,4),(178,80,10000,0,18,4),(178,81,10000,0,18,4),(178,82,10000,0,18,4),(178,83,10000,0,18,4),(178,84,10000,0,18,4),(178,85,10000,0,18,4),(178,86,10000,0,18,4),(178,87,10000,0,18,4),(178,88,10000,0,18,4),(178,113,10000,0,18,4),(178,114,10000,0,18,4),(178,115,10000,0,18,4),(178,116,10000,0,18,4),(178,117,10000,0,18,4),(178,118,10000,0,18,4),(178,119,10000,0,18,4),(178,120,10000,0,18,4),(178,121,10000,0,18,4),(178,122,10000,0,18,4),(178,123,10000,0,18,4),(178,124,10000,0,18,4),(178,125,10000,0,18,4),(178,126,10000,0,18,4),(178,127,10000,0,18,4),(178,128,10000,0,18,4),(178,129,10000,0,18,4),(178,130,10000,0,18,4),(178,131,10000,0,18,4),(178,132,10000,0,18,4),(178,133,10000,0,18,4),(178,134,10000,0,18,4),(178,135,10000,0,18,4),(178,136,10000,0,18,4),(178,137,10000,0,18,4),(178,138,10000,0,18,4),(178,139,10000,0,18,4),(178,140,10000,0,18,4),(178,141,10000,0,18,4),(178,142,10000,0,18,4),(178,143,10000,0,18,4),(178,144,10000,0,18,4),(178,145,10000,0,18,4),(178,146,10000,0,18,4),(178,147,10000,0,18,4),(178,148,10000,0,18,4),(178,149,10000,0,18,4),(178,150,10000,0,18,4),(178,151,10000,0,18,4),(178,152,10000,0,18,4),(178,153,10000,0,18,4),(178,154,10000,0,18,4),(178,155,10000,0,18,4),(178,156,10000,0,18,4),(178,157,10000,0,18,4),(178,158,10000,0,18,4),(178,159,10000,0,18,4),(178,160,10000,0,18,4),(178,161,10000,0,18,4),(178,162,10000,0,18,4),(178,163,10000,0,18,4),(178,164,10000,0,18,4),(178,165,10000,0,18,4),(178,166,10000,0,18,4),(178,167,10000,0,18,4),(178,168,10000,0,18,4),(178,169,10000,0,18,4),(178,170,10000,0,18,4),(178,171,10000,0,18,4),(178,172,10000,0,18,4),(178,173,10000,0,18,4),(178,174,10000,0,18,4),(178,175,10000,0,18,4),(178,176,10000,0,18,4),(178,177,10000,0,18,4),(178,178,10000,0,18,4),(178,179,10000,0,18,4),(178,180,10000,0,18,4),(178,181,10000,0,18,4),(178,182,10000,0,18,4),(178,183,10000,0,18,4),(178,184,10000,0,18,4),(178,185,10000,0,18,4),(178,186,10000,0,18,4),(178,187,10000,0,18,4),(178,188,10000,0,18,4),(178,189,10000,0,18,4),(178,190,10000,0,18,4),(178,191,10000,0,18,4),(178,192,10000,0,18,4),(178,193,10000,0,18,4),(178,194,10000,0,18,4),(178,195,10000,0,18,4),(178,196,10000,0,18,4),(178,197,10000,0,18,4),(178,198,10000,0,18,4),(178,199,10000,0,18,4),(178,200,10000,0,18,4),(178,201,10000,0,18,4),(178,202,10000,0,18,4),(178,203,10000,0,18,4),(178,204,10000,0,18,4),(178,205,10000,0,18,4),(178,206,10000,0,18,4),(178,207,10000,0,18,4),(178,208,10000,0,18,4),(178,209,10000,0,18,4),(178,210,10000,0,18,4),(178,211,10000,0,18,4),(178,212,10000,0,18,4),(178,213,10000,0,18,4),(178,214,10000,0,18,4),(178,215,10000,0,18,4),(178,216,10000,0,18,4),(178,217,10000,0,18,4),(178,218,10000,0,18,4),(178,219,10000,0,18,4),(178,220,10000,0,18,4),(178,221,10000,0,18,4),(178,222,10000,0,18,4),(178,223,10000,0,18,4),(178,224,10000,0,18,4),(178,225,10000,0,18,4),(178,226,10000,0,18,4),(178,227,10000,0,18,4),(178,228,10000,0,18,4),(178,229,10000,0,18,4),(178,230,10000,0,18,4),(178,231,10000,0,18,4),(178,232,10000,0,18,4),(178,233,10000,0,18,4),(178,234,10000,0,18,4),(178,235,10000,0,18,4),(178,236,10000,0,18,4),(178,237,10000,0,18,4),(178,238,10000,0,18,4),(178,239,10000,0,18,4),(178,240,10000,0,18,4),(178,241,10000,0,18,4),(178,244,10000,0,18,4),(178,246,10000,0,18,4),(178,251,10000,0,18,4),(178,255,10000,0,18,4),(178,258,10000,0,18,4),(178,259,10000,0,18,4),(178,260,10000,0,18,4),(178,261,10000,0,18,4),(178,262,10000,0,18,4),(178,263,10000,0,18,4),(179,81,0,1,18,4),(179,82,0,1,18,4),(179,83,0,1,18,4),(179,84,0,1,18,4),(179,85,0,1,18,4),(179,86,0,1,18,4),(179,87,0,1,18,4),(179,88,0,1,18,4),(180,81,0,1,18,4),(181,86,0,1,18,4),(182,82,0,1,18,4),(182,83,0,1,18,4),(182,84,0,1,18,4),(182,85,0,1,18,4),(182,87,0,1,18,4),(182,88,0,1,18,4),(183,82,0,1,18,4),(183,83,0,1,18,4),(183,84,0,1,18,4),(183,85,0,1,18,4),(183,86,0,1,18,4),(183,87,0,1,18,4),(183,88,0,1,18,4),(192,89,0,1,18,4),(192,90,0,1,18,4),(192,91,0,1,18,4),(192,92,0,1,18,4),(192,93,0,1,18,4),(192,94,0,1,18,4),(193,95,0,1,18,4),(193,96,0,1,18,4),(193,97,0,1,18,4),(193,98,0,1,18,4),(193,99,0,1,18,4),(193,100,0,1,18,4),(194,95,0,1,18,4),(194,96,0,1,18,4),(194,97,0,1,18,4),(194,98,0,1,18,4),(194,99,0,1,18,4),(194,100,0,1,18,4),(195,95,0,1,18,4),(195,96,0,1,18,4),(195,97,0,1,18,4),(195,98,0,1,18,4),(195,99,0,1,18,4),(195,100,0,1,18,4),(196,95,0,1,18,4),(196,96,0,1,18,4),(196,97,0,1,18,4),(196,98,0,1,18,4),(196,99,0,1,18,4),(196,100,0,1,18,4),(197,95,0,1,18,4),(197,96,0,1,18,4),(197,97,0,1,18,4),(197,98,0,1,18,4),(197,99,0,1,18,4),(197,100,0,1,18,4),(198,101,0,1,18,4),(198,109,0,1,18,4),(198,111,0,1,18,4),(198,112,0,1,18,4),(199,103,0,1,18,4),(199,110,0,1,18,4),(200,101,0,1,18,4),(200,102,0,1,18,4),(200,108,0,1,18,4),(201,104,0,1,18,4),(201,106,0,1,18,4),(202,101,0,1,18,4),(202,102,0,1,18,4),(202,103,0,1,18,4),(202,105,0,1,18,4),(202,107,0,1,18,4),(202,108,0,1,18,4),(202,110,0,1,18,4),(203,101,0,1,18,4),(203,102,0,1,18,4),(203,103,0,1,18,4),(203,104,0,1,18,4),(203,106,0,1,18,4),(203,108,0,1,18,4),(203,109,0,1,18,4),(204,101,0,1,18,4),(204,102,0,1,18,4),(204,103,0,1,18,4),(204,104,0,1,18,4),(204,105,0,1,18,4),(204,106,0,1,18,4),(204,107,0,1,18,4),(204,108,0,1,18,4),(205,101,0,1,18,4),(205,102,0,1,18,4),(205,103,0,1,18,4),(205,108,0,1,18,4),(205,109,0,1,18,4),(205,110,0,1,18,4),(205,111,0,1,18,4),(205,112,0,1,18,4),(206,113,10000,0,18,4),(206,114,10000,0,18,4),(206,115,10000,0,18,4),(206,116,10000,0,18,4),(206,117,10000,0,18,4),(206,118,10000,0,18,4),(206,119,10000,0,18,4),(207,114,0,1,18,4),(207,119,0,1,18,4),(209,114,0,1,18,4),(212,116,0,1,18,4),(212,118,0,1,18,4),(213,113,0,1,18,4),(218,117,0,1,18,4),(219,119,0,1,18,4),(220,119,0,1,18,4),(221,119,0,1,18,4),(222,114,0,1,18,4),(222,119,0,1,18,4),(223,114,0,1,18,4),(223,119,0,1,18,4),(229,113,0,1,18,4),(230,113,0,1,18,4),(231,113,0,1,18,4),(232,113,0,1,18,4),(233,113,0,1,18,4),(234,116,0,1,18,4),(234,118,0,1,18,4),(235,116,0,1,18,4),(235,118,0,1,18,4),(236,116,0,1,18,4),(236,118,0,1,18,4),(237,116,0,1,18,4),(237,118,0,1,18,4),(238,116,0,1,18,4),(238,118,0,1,18,4),(239,115,0,1,18,4),(241,115,0,1,18,4),(242,115,0,1,18,4),(243,115,0,1,18,4),(250,120,0,1,18,4),(250,121,0,1,18,4),(250,122,0,1,18,4),(250,123,0,1,18,4),(250,124,0,1,18,4),(250,125,0,1,18,4),(250,126,0,1,18,4),(250,127,0,1,18,4),(250,128,0,1,18,4),(250,129,0,1,18,4),(250,130,0,1,18,4),(250,131,0,1,18,4),(251,120,0,1,18,4),(251,121,0,1,18,4),(251,122,0,1,18,4),(251,123,0,1,18,4),(251,124,0,1,18,4),(251,125,0,1,18,4),(251,126,0,1,18,4),(251,127,0,1,18,4),(251,128,0,1,18,4),(251,129,0,1,18,4),(251,130,0,1,18,4),(251,131,0,1,18,4),(252,125,10000,0,18,4),(252,126,10000,0,18,4),(252,127,10000,0,18,4),(252,120,0,1,18,4),(252,121,0,1,18,4),(252,122,0,1,18,4),(252,123,0,1,18,4),(252,124,0,1,18,4),(252,128,0,1,18,4),(252,129,0,1,18,4),(252,131,0,1,18,4),(253,120,0,1,18,4),(253,121,0,1,18,4),(253,122,0,1,18,4),(253,123,0,1,18,4),(253,124,0,1,18,4),(253,125,0,1,18,4),(253,126,0,1,18,4),(253,127,0,1,18,4),(253,128,0,1,18,4),(253,129,0,1,18,4),(253,130,0,1,18,4),(253,131,0,1,18,4),(254,120,0,1,18,4),(254,121,0,1,18,4),(254,122,0,1,18,4),(254,123,0,1,18,4),(254,124,0,1,18,4),(254,125,0,1,18,4),(254,126,0,1,18,4),(254,127,0,1,18,4),(254,128,0,1,18,4),(254,129,0,1,18,4),(254,130,0,1,18,4),(254,131,0,1,18,4),(255,122,0,1,18,4),(255,123,0,1,18,4),(255,124,0,1,18,4),(255,125,0,1,18,4),(255,126,0,1,18,4),(255,129,0,1,18,4),(256,121,0,1,18,4),(256,122,0,1,18,4),(256,123,0,1,18,4),(256,125,0,1,18,4),(256,126,0,1,18,4),(256,127,0,1,18,4),(257,121,0,1,18,4),(257,122,0,1,18,4),(257,123,0,1,18,4),(257,125,0,1,18,4),(257,127,0,1,18,4),(257,129,0,1,18,4),(258,121,0,1,18,4),(258,122,0,1,18,4),(258,125,0,1,18,4),(258,126,0,1,18,4),(258,127,0,1,18,4),(258,129,0,1,18,4),(259,120,0,1,18,4),(259,121,0,1,18,4),(259,123,0,1,18,4),(259,128,0,1,18,4),(259,129,0,1,18,4),(260,120,0,1,18,4),(260,121,0,1,18,4),(260,122,0,1,18,4),(260,123,0,1,18,4),(260,125,0,1,18,4),(260,127,0,1,18,4),(260,128,0,1,18,4),(260,129,0,1,18,4),(261,121,0,1,18,4),(261,122,0,1,18,4),(261,125,0,1,18,4),(261,126,0,1,18,4),(261,127,0,1,18,4),(261,129,0,1,18,4),(262,125,0,1,18,4),(262,126,0,1,18,4),(263,120,0,1,18,4),(263,121,0,1,18,4),(263,122,0,1,18,4),(263,123,0,1,18,4),(263,124,0,1,18,4),(263,128,0,1,18,4),(263,129,0,1,18,4),(263,131,0,1,18,4),(264,120,0,1,18,4),(264,122,0,1,18,4),(264,123,0,1,18,4),(264,125,0,1,18,4),(264,126,0,1,18,4),(264,129,0,1,18,4),(265,121,0,1,18,4),(265,122,0,1,18,4),(265,123,0,1,18,4),(265,127,0,1,18,4),(266,123,0,1,18,4),(266,125,0,1,18,4),(266,126,0,1,18,4),(266,127,0,1,18,4),(266,129,0,1,18,4),(267,121,0,1,18,4),(267,125,0,1,18,4),(267,126,0,1,18,4),(267,127,0,1,18,4),(268,120,0,1,18,4),(268,121,0,1,18,4),(268,122,0,1,18,4),(268,123,0,1,18,4),(268,124,0,1,18,4),(268,127,0,1,18,4),(268,129,0,1,18,4),(269,122,0,1,18,4),(269,125,0,1,18,4),(269,126,0,1,18,4),(269,127,0,1,18,4),(269,129,0,1,18,4),(270,121,0,1,18,4),(270,123,0,1,18,4),(270,125,0,1,18,4),(270,126,0,1,18,4),(270,129,0,1,18,4),(271,120,0,1,18,4),(271,121,0,1,18,4),(271,122,0,1,18,4),(271,125,0,1,18,4),(271,126,0,1,18,4),(271,127,0,1,18,4),(271,129,0,1,18,4),(272,122,0,1,18,4),(272,123,0,1,18,4),(272,124,0,1,18,4),(272,125,0,1,18,4),(272,126,0,1,18,4),(272,127,0,1,18,4),(272,128,0,1,18,4),(272,129,0,1,18,4),(273,120,0,1,18,4),(273,121,0,1,18,4),(273,123,0,1,18,4),(273,126,0,1,18,4),(273,127,0,1,18,4),(274,122,0,1,18,4),(274,123,0,1,18,4),(274,125,0,1,18,4),(274,126,0,1,18,4),(274,129,0,1,18,4),(275,120,0,1,18,4),(275,121,0,1,18,4),(275,122,0,1,18,4),(275,123,0,1,18,4),(275,124,0,1,18,4),(275,125,0,1,18,4),(275,126,0,1,18,4),(275,127,0,1,18,4),(275,128,0,1,18,4),(275,129,0,1,18,4),(275,130,0,1,18,4),(275,131,0,1,18,4),(276,122,0,1,18,4),(276,123,0,1,18,4),(276,127,0,1,18,4),(276,129,0,1,18,4),(277,120,0,1,18,4),(277,121,0,1,18,4),(277,123,0,1,18,4),(277,124,0,1,18,4),(277,125,0,1,18,4),(277,126,0,1,18,4),(277,127,0,1,18,4),(278,120,0,1,18,4),(278,121,0,1,18,4),(278,122,0,1,18,4),(278,123,0,1,18,4),(278,124,0,1,18,4),(278,125,0,1,18,4),(278,127,0,1,18,4),(278,128,0,1,18,4),(278,129,0,1,18,4),(279,120,0,1,18,4),(279,122,0,1,18,4),(279,126,0,1,18,4),(279,127,0,1,18,4),(279,129,0,1,18,4),(280,132,0,1,18,4),(280,133,0,1,18,4),(280,134,0,1,18,4),(280,135,0,1,18,4),(280,136,0,1,18,4),(280,137,0,1,18,4),(280,138,0,1,18,4),(280,139,0,1,18,4),(282,132,0,1,18,4),(282,133,0,1,18,4),(282,134,0,1,18,4),(282,137,0,1,18,4),(282,138,0,1,18,4),(283,135,0,1,18,4),(283,136,0,1,18,4),(283,139,0,1,18,4),(286,140,0,1,18,4),(286,141,0,1,18,4),(286,142,0,1,18,4),(286,143,0,1,18,4),(286,144,0,1,18,4),(286,145,0,1,18,4),(286,146,0,1,18,4),(286,147,0,1,18,4),(286,148,0,1,18,4),(286,149,0,1,18,4),(286,150,0,1,18,4),(286,151,0,1,18,4),(286,152,0,1,18,4),(286,153,0,1,18,4),(286,154,0,1,18,4),(286,155,0,1,18,4),(286,156,0,1,18,4),(286,157,0,1,18,4),(286,158,0,1,18,4),(286,159,0,1,18,4),(286,160,0,1,18,4),(286,161,0,1,18,4),(286,162,0,1,18,4),(286,163,0,1,18,4),(286,164,0,1,18,4),(286,165,0,1,18,4),(286,166,0,1,18,4),(286,167,0,1,18,4),(286,168,0,1,18,4),(286,169,0,1,18,4),(286,170,0,1,18,4),(286,171,0,1,18,4),(286,172,0,1,18,4),(286,173,0,1,18,4),(286,174,0,1,18,4),(286,175,0,1,18,4),(286,176,0,1,18,4),(286,177,0,1,18,4),(286,178,0,1,18,4),(286,179,0,1,18,4),(286,180,0,1,18,4),(286,181,0,1,18,4),(286,182,0,1,18,4),(286,183,0,1,18,4),(286,184,0,1,18,4),(286,185,0,1,18,4),(286,186,0,1,18,4),(286,187,0,1,18,4),(287,188,0,1,18,4),(288,189,0,1,18,4),(288,190,0,1,18,4),(288,191,0,1,18,4),(288,192,0,1,18,4),(288,193,0,1,18,4),(288,194,0,1,18,4),(288,195,0,1,18,4),(288,196,0,1,18,4),(288,197,0,1,18,4),(288,198,0,1,18,4),(288,199,0,1,18,4),(288,200,0,1,18,4),(289,201,10000,0,18,4),(289,202,10000,0,18,4),(289,203,10000,0,18,4),(289,204,10000,0,18,4),(289,205,10000,0,18,4),(289,206,10000,0,18,4),(289,207,10000,0,18,4),(289,208,10000,0,18,4),(289,209,10000,0,18,4),(289,210,10000,0,18,4),(289,211,10000,0,18,4),(289,212,10000,0,18,4),(289,213,10000,0,18,4),(289,214,10000,0,18,4),(289,215,10000,0,18,4),(289,216,10000,0,18,4),(289,217,10000,0,18,4),(289,218,10000,0,18,4),(289,219,10000,0,18,4),(289,220,10000,0,18,4),(289,221,10000,0,18,4),(289,222,10000,0,18,4),(289,223,10000,0,18,4),(289,224,10000,0,18,4),(289,225,10000,0,18,4),(289,226,10000,0,18,4),(289,227,10000,0,18,4),(289,228,10000,0,18,4),(289,229,10000,0,18,4),(289,230,10000,0,18,4),(289,231,10000,0,18,4),(289,232,10000,0,18,4),(289,244,10000,0,18,4),(289,246,10000,0,18,4),(289,251,10000,0,18,4),(289,255,10000,0,18,4),(289,258,10000,0,18,4),(289,259,10000,0,18,4),(289,260,10000,0,18,4),(289,261,10000,0,18,4),(289,262,10000,0,18,4),(289,263,10000,0,18,4),(290,209,0,1,18,4),(290,210,0,1,18,4),(290,211,0,1,18,4),(290,212,0,1,18,4),(290,213,0,1,18,4),(290,214,0,1,18,4),(290,215,0,1,18,4),(290,216,0,1,18,4),(291,201,0,1,18,4),(291,202,0,1,18,4),(291,203,0,1,18,4),(291,204,0,1,18,4),(291,205,0,1,18,4),(291,206,0,1,18,4),(291,207,0,1,18,4),(291,208,0,1,18,4),(292,217,0,1,18,4),(292,218,0,1,18,4),(292,219,0,1,18,4),(292,220,0,1,18,4),(292,221,0,1,18,4),(292,222,0,1,18,4),(292,223,0,1,18,4),(292,224,0,1,18,4),(293,225,0,1,18,4),(293,226,0,1,18,4),(293,227,0,1,18,4),(293,228,0,1,18,4),(293,229,0,1,18,4),(293,230,0,1,18,4),(293,231,0,1,18,4),(293,232,0,1,18,4),(293,255,0,1,18,4),(293,259,0,1,18,4),(293,260,0,1,18,4),(293,261,0,1,18,4),(293,262,0,1,18,4),(293,263,0,1,18,4),(294,233,0,1,18,4),(294,234,0,1,18,4),(294,235,0,1,18,4),(294,236,0,1,18,4),(294,237,0,1,18,4),(294,238,0,1,18,4),(294,239,0,1,18,4),(294,240,0,1,18,4),(294,241,0,1,18,4),(295,244,0,1,18,4),(295,246,0,1,18,4),(295,251,0,1,18,4),(295,255,0,1,18,4),(295,258,0,1,18,4),(296,251,0,1,18,4),(296,255,0,1,18,4),(296,258,0,1,18,4),(297,246,0,1,18,4),(297,255,0,1,18,4),(297,258,0,1,18,4),(298,255,0,1,18,4),(298,258,0,1,18,4),(299,251,0,1,18,4),(299,258,0,1,18,4);
/*!40000 ALTER TABLE `catalog_category_product_index_store18_replica` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index_store19`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store19`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store19` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `CAT_CTGR_PRD_IDX_STORE19_PRD_ID_STORE_ID_CTGR_ID_VISIBILITY` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_0C63E18C1913A0D0D1B812327539BCDB` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Product Index Store19';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index_store19`
--

LOCK TABLES `catalog_category_product_index_store19` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index_store19` DISABLE KEYS */;
INSERT INTO `catalog_category_product_index_store19` VALUES (2,1,0,1,19,4),(2,2,0,1,19,4),(2,3,0,1,19,4),(2,4,0,1,19,4),(2,5,0,1,19,4),(2,6,0,1,19,4),(2,7,0,1,19,4),(2,8,0,1,19,4),(2,9,0,1,19,4),(2,10,0,1,19,4),(2,11,0,1,19,4),(2,12,0,1,19,4),(2,13,0,1,19,4),(2,14,0,1,19,4),(2,15,0,1,19,4),(2,16,0,1,19,4),(2,17,0,1,19,4),(2,18,0,1,19,4),(2,19,0,1,19,4),(2,20,0,1,19,4),(2,21,0,1,19,4),(2,22,0,1,19,4),(2,23,0,1,19,4),(2,24,0,1,19,4),(2,25,0,1,19,4),(2,26,0,1,19,4),(2,27,0,1,19,4),(2,28,0,1,19,4),(2,29,0,1,19,4),(2,30,0,1,19,4),(2,31,0,1,19,4),(2,32,0,1,19,4),(2,33,0,1,19,4),(2,34,0,1,19,4),(2,35,0,1,19,4),(2,36,0,1,19,4),(2,37,0,1,19,4),(2,38,0,1,19,4),(2,39,0,1,19,4),(2,40,0,1,19,4),(2,41,0,1,19,4),(2,42,0,1,19,4),(2,43,0,1,19,4),(2,44,0,1,19,4),(2,45,0,1,19,4),(2,46,0,1,19,4),(2,47,0,1,19,4),(2,48,0,1,19,4),(2,49,0,1,19,4),(2,50,0,1,19,4),(2,57,0,1,19,4),(2,58,0,1,19,4),(2,59,0,1,19,4),(2,60,0,1,19,4),(2,61,0,1,19,4),(2,62,0,1,19,4),(2,63,0,1,19,4),(2,64,0,1,19,4),(2,65,0,1,19,4),(2,66,0,1,19,4),(2,68,0,1,19,4),(2,69,0,1,19,4),(2,70,0,1,19,4),(2,71,0,1,19,4),(2,72,0,1,19,4),(2,73,0,1,19,4),(2,74,0,1,19,4),(2,75,0,1,19,4),(2,76,0,1,19,4),(2,77,0,1,19,4),(2,78,0,1,19,4),(2,79,0,1,19,4),(2,80,0,1,19,4),(2,81,0,1,19,4),(2,82,0,1,19,4),(2,83,0,1,19,4),(2,84,0,1,19,4),(2,85,0,1,19,4),(2,86,0,1,19,4),(2,87,0,1,19,4),(2,88,0,1,19,4),(2,89,0,1,19,4),(2,90,0,1,19,4),(2,91,0,1,19,4),(2,92,0,1,19,4),(2,93,0,1,19,4),(2,94,0,1,19,4),(2,95,0,1,19,4),(2,96,0,1,19,4),(2,97,0,1,19,4),(2,98,0,1,19,4),(2,99,0,1,19,4),(2,100,0,1,19,4),(2,101,0,1,19,4),(2,102,0,1,19,4),(2,103,0,1,19,4),(2,104,0,1,19,4),(2,105,0,1,19,4),(2,106,0,1,19,4),(2,107,0,1,19,4),(2,108,0,1,19,4),(2,109,0,1,19,4),(2,110,0,1,19,4),(2,111,0,1,19,4),(2,112,0,1,19,4),(2,113,0,1,19,4),(2,114,0,1,19,4),(2,115,0,1,19,4),(2,116,0,1,19,4),(2,117,0,1,19,4),(2,118,0,1,19,4),(2,119,0,1,19,4),(2,120,0,1,19,4),(2,121,0,1,19,4),(2,122,0,1,19,4),(2,123,0,1,19,4),(2,124,0,1,19,4),(2,125,0,1,19,4),(2,126,0,1,19,4),(2,127,0,1,19,4),(2,128,0,1,19,4),(2,129,0,1,19,4),(2,130,0,1,19,4),(2,131,0,1,19,4),(2,132,0,1,19,4),(2,133,0,1,19,4),(2,134,0,1,19,4),(2,135,0,1,19,4),(2,136,0,1,19,4),(2,137,0,1,19,4),(2,138,0,1,19,4),(2,139,0,1,19,4),(2,140,0,1,19,4),(2,141,0,1,19,4),(2,142,0,1,19,4),(2,143,0,1,19,4),(2,144,0,1,19,4),(2,145,0,1,19,4),(2,146,0,1,19,4),(2,147,0,1,19,4),(2,148,0,1,19,4),(2,149,0,1,19,4),(2,150,0,1,19,4),(2,151,0,1,19,4),(2,152,0,1,19,4),(2,153,0,1,19,4),(2,154,0,1,19,4),(2,155,0,1,19,4),(2,156,0,1,19,4),(2,157,0,1,19,4),(2,158,0,1,19,4),(2,159,0,1,19,4),(2,160,0,1,19,4),(2,161,0,1,19,4),(2,162,0,1,19,4),(2,163,0,1,19,4),(2,164,0,1,19,4),(2,165,0,1,19,4),(2,166,0,1,19,4),(2,167,0,1,19,4),(2,168,0,1,19,4),(2,169,0,1,19,4),(2,170,0,1,19,4),(2,171,0,1,19,4),(2,172,0,1,19,4),(2,173,0,1,19,4),(2,174,0,1,19,4),(2,175,0,1,19,4),(2,176,0,1,19,4),(2,177,0,1,19,4),(2,178,0,1,19,4),(2,179,0,1,19,4),(2,180,0,1,19,4),(2,181,0,1,19,4),(2,182,0,1,19,4),(2,183,0,1,19,4),(2,184,0,1,19,4),(2,185,0,1,19,4),(2,186,0,1,19,4),(2,187,0,1,19,4),(2,188,0,1,19,4),(2,189,0,1,19,4),(2,190,0,1,19,4),(2,191,0,1,19,4),(2,192,0,1,19,4),(2,193,0,1,19,4),(2,194,0,1,19,4),(2,195,0,1,19,4),(2,196,0,1,19,4),(2,197,0,1,19,4),(2,198,0,1,19,4),(2,199,0,1,19,4),(2,200,0,1,19,4),(2,201,0,1,19,4),(2,202,0,1,19,4),(2,203,0,1,19,4),(2,204,0,1,19,4),(2,205,0,1,19,4),(2,206,0,1,19,4),(2,207,0,1,19,4),(2,208,0,1,19,4),(2,209,0,1,19,4),(2,210,0,1,19,4),(2,211,0,1,19,4),(2,212,0,1,19,4),(2,213,0,1,19,4),(2,214,0,1,19,4),(2,215,0,1,19,4),(2,216,0,1,19,4),(2,217,0,1,19,4),(2,218,0,1,19,4),(2,219,0,1,19,4),(2,220,0,1,19,4),(2,221,0,1,19,4),(2,222,0,1,19,4),(2,223,0,1,19,4),(2,224,0,1,19,4),(2,225,0,1,19,4),(2,226,0,1,19,4),(2,227,0,1,19,4),(2,228,0,1,19,4),(2,229,0,1,19,4),(2,230,0,1,19,4),(2,231,0,1,19,4),(2,232,0,1,19,4),(2,233,0,1,19,4),(2,234,0,1,19,4),(2,235,0,1,19,4),(2,236,0,1,19,4),(2,237,0,1,19,4),(2,238,0,1,19,4),(2,239,0,1,19,4),(2,240,0,1,19,4),(2,241,0,1,19,4),(2,244,0,1,19,4),(2,246,0,1,19,4),(2,251,0,1,19,4),(2,255,0,1,19,4),(2,258,0,1,19,4),(2,259,0,1,19,4),(2,260,0,1,19,4),(2,261,0,1,19,4),(2,262,0,1,19,4),(2,263,0,1,19,4),(3,1,0,1,19,4),(3,2,0,1,19,4),(3,3,0,1,19,4),(3,4,0,1,19,4),(3,5,0,1,19,4),(3,6,0,1,19,4),(3,7,0,1,19,4),(3,8,0,1,19,4),(3,10,0,1,19,4),(3,11,0,1,19,4),(4,12,0,1,19,4),(4,13,0,1,19,4),(4,14,0,1,19,4),(4,15,0,1,19,4),(4,16,0,1,19,4),(4,17,0,1,19,4),(4,18,0,1,19,4),(4,19,0,1,19,4),(4,36,0,1,19,4),(4,37,0,1,19,4),(4,38,0,1,19,4),(4,39,0,1,19,4),(4,40,0,1,19,4),(5,95,10000,0,19,4),(5,96,10000,0,19,4),(5,97,10000,0,19,4),(5,98,10000,0,19,4),(5,99,10000,0,19,4),(5,100,10000,0,19,4),(7,101,10000,0,19,4),(7,102,10000,0,19,4),(7,103,10000,0,19,4),(7,104,10000,0,19,4),(7,105,10000,0,19,4),(7,106,10000,0,19,4),(7,107,10000,0,19,4),(7,108,10000,0,19,4),(7,109,10000,0,19,4),(7,110,10000,0,19,4),(7,111,10000,0,19,4),(7,112,10000,0,19,4),(7,21,0,1,19,4),(7,22,0,1,19,4),(7,26,0,1,19,4),(8,61,0,1,19,4),(8,62,0,1,19,4),(8,63,0,1,19,4),(8,64,0,1,19,4),(8,65,0,1,19,4),(8,66,0,1,19,4),(11,4,10000,0,19,4),(11,89,10000,0,19,4),(11,90,10000,0,19,4),(11,91,10000,0,19,4),(11,92,10000,0,19,4),(11,93,10000,0,19,4),(11,94,10000,0,19,4),(11,28,0,1,19,4),(11,29,0,1,19,4),(11,30,0,1,19,4),(11,31,0,1,19,4),(11,32,0,1,19,4),(11,33,0,1,19,4),(11,34,0,1,19,4),(11,35,0,1,19,4),(13,21,0,1,19,4),(13,24,0,1,19,4),(13,25,0,1,19,4),(13,26,0,1,19,4),(13,27,0,1,19,4),(13,41,0,1,19,4),(13,42,0,1,19,4),(13,43,0,1,19,4),(13,44,0,1,19,4),(13,45,0,1,19,4),(13,46,0,1,19,4),(13,47,0,1,19,4),(13,48,0,1,19,4),(13,49,0,1,19,4),(15,22,10000,0,19,4),(15,23,10000,0,19,4),(16,20,0,1,19,4),(16,21,0,1,19,4),(16,22,0,1,19,4),(16,23,0,1,19,4),(16,24,0,1,19,4),(16,25,0,1,19,4),(16,26,0,1,19,4),(16,27,0,1,19,4),(16,41,0,1,19,4),(16,68,0,1,19,4),(16,69,0,1,19,4),(16,70,0,1,19,4),(16,71,0,1,19,4),(16,72,0,1,19,4),(16,73,0,1,19,4),(19,6,0,1,19,4),(19,7,0,1,19,4),(19,8,0,1,19,4),(19,10,0,1,19,4),(19,11,0,1,19,4),(27,11,0,1,19,4),(29,6,0,1,19,4),(29,8,0,1,19,4),(29,10,0,1,19,4),(30,6,0,1,19,4),(30,10,0,1,19,4),(33,7,0,1,19,4),(33,8,0,1,19,4),(33,10,0,1,19,4),(33,11,0,1,19,4),(42,7,0,1,19,4),(42,8,0,1,19,4),(42,11,0,1,19,4),(78,21,0,1,19,4),(78,26,0,1,19,4),(80,21,0,1,19,4),(80,22,0,1,19,4),(80,26,0,1,19,4),(81,26,0,1,19,4),(82,26,0,1,19,4),(83,26,0,1,19,4),(96,26,0,1,19,4),(97,26,0,1,19,4),(98,21,0,1,19,4),(98,22,0,1,19,4),(98,26,0,1,19,4),(99,18,0,1,19,4),(101,14,0,1,19,4),(101,15,0,1,19,4),(101,16,0,1,19,4),(102,12,0,1,19,4),(102,13,0,1,19,4),(102,14,0,1,19,4),(102,15,0,1,19,4),(102,16,0,1,19,4),(102,17,0,1,19,4),(102,19,0,1,19,4),(102,36,0,1,19,4),(102,37,0,1,19,4),(102,38,0,1,19,4),(102,39,0,1,19,4),(102,40,0,1,19,4),(103,18,0,1,19,4),(104,18,0,1,19,4),(105,18,0,1,19,4),(106,18,0,1,19,4),(107,18,0,1,19,4),(134,23,0,1,19,4),(135,22,0,1,19,4),(137,4,0,1,19,4),(137,28,0,1,19,4),(137,31,0,1,19,4),(137,34,0,1,19,4),(137,35,0,1,19,4),(138,28,0,1,19,4),(138,30,0,1,19,4),(138,32,0,1,19,4),(138,33,0,1,19,4),(139,28,0,1,19,4),(139,30,0,1,19,4),(139,32,0,1,19,4),(139,33,0,1,19,4),(140,28,0,1,19,4),(140,30,0,1,19,4),(140,32,0,1,19,4),(140,33,0,1,19,4),(145,1,0,1,19,4),(145,2,0,1,19,4),(145,3,0,1,19,4),(145,4,0,1,19,4),(145,5,0,1,19,4),(145,6,0,1,19,4),(145,7,0,1,19,4),(145,8,0,1,19,4),(145,9,0,1,19,4),(145,10,0,1,19,4),(145,11,0,1,19,4),(145,12,0,1,19,4),(145,13,0,1,19,4),(145,14,0,1,19,4),(145,15,0,1,19,4),(145,16,0,1,19,4),(145,17,0,1,19,4),(145,18,0,1,19,4),(145,19,0,1,19,4),(145,20,0,1,19,4),(145,21,0,1,19,4),(145,22,0,1,19,4),(145,23,0,1,19,4),(145,24,0,1,19,4),(145,25,0,1,19,4),(145,26,0,1,19,4),(145,27,0,1,19,4),(145,28,0,1,19,4),(145,29,0,1,19,4),(145,30,0,1,19,4),(145,31,0,1,19,4),(145,32,0,1,19,4),(145,33,0,1,19,4),(145,34,0,1,19,4),(145,35,0,1,19,4),(145,36,0,1,19,4),(145,37,0,1,19,4),(145,38,0,1,19,4),(145,39,0,1,19,4),(145,40,0,1,19,4),(145,41,0,1,19,4),(145,42,0,1,19,4),(145,43,0,1,19,4),(149,41,0,1,19,4),(150,50,0,1,19,4),(150,57,0,1,19,4),(150,58,0,1,19,4),(150,59,0,1,19,4),(150,60,0,1,19,4),(151,61,0,1,19,4),(151,62,0,1,19,4),(151,63,0,1,19,4),(151,64,0,1,19,4),(151,65,0,1,19,4),(151,66,0,1,19,4),(152,61,0,1,19,4),(152,63,0,1,19,4),(153,61,0,1,19,4),(153,63,0,1,19,4),(153,64,0,1,19,4),(153,65,0,1,19,4),(153,66,0,1,19,4),(154,61,0,1,19,4),(154,62,0,1,19,4),(154,64,0,1,19,4),(154,66,0,1,19,4),(155,61,0,1,19,4),(155,62,0,1,19,4),(155,64,0,1,19,4),(155,65,0,1,19,4),(155,66,0,1,19,4),(156,61,0,1,19,4),(156,62,0,1,19,4),(156,63,0,1,19,4),(156,64,0,1,19,4),(156,65,0,1,19,4),(156,66,0,1,19,4),(157,61,0,1,19,4),(157,62,0,1,19,4),(157,64,0,1,19,4),(157,65,0,1,19,4),(157,66,0,1,19,4),(158,61,0,1,19,4),(158,63,0,1,19,4),(158,64,0,1,19,4),(158,65,0,1,19,4),(158,66,0,1,19,4),(159,61,0,1,19,4),(159,62,0,1,19,4),(159,63,0,1,19,4),(159,64,0,1,19,4),(159,65,0,1,19,4),(159,66,0,1,19,4),(160,41,0,1,19,4),(160,68,0,1,19,4),(160,69,0,1,19,4),(160,70,0,1,19,4),(160,72,0,1,19,4),(160,73,0,1,19,4),(161,68,0,1,19,4),(161,69,0,1,19,4),(161,70,0,1,19,4),(161,71,0,1,19,4),(161,72,0,1,19,4),(162,68,0,1,19,4),(162,69,0,1,19,4),(162,72,0,1,19,4),(164,41,0,1,19,4),(164,70,0,1,19,4),(164,73,0,1,19,4),(166,41,0,1,19,4),(166,70,0,1,19,4),(166,73,0,1,19,4),(167,68,0,1,19,4),(167,69,0,1,19,4),(167,72,0,1,19,4),(168,71,0,1,19,4),(169,70,0,1,19,4),(171,70,0,1,19,4),(172,1,10000,0,19,4),(172,2,10000,0,19,4),(172,3,10000,0,19,4),(172,4,10000,0,19,4),(172,5,10000,0,19,4),(172,6,10000,0,19,4),(172,7,10000,0,19,4),(172,8,10000,0,19,4),(172,9,10000,0,19,4),(172,10,10000,0,19,4),(172,11,10000,0,19,4),(172,12,10000,0,19,4),(172,13,10000,0,19,4),(172,14,10000,0,19,4),(172,15,10000,0,19,4),(172,16,10000,0,19,4),(172,17,10000,0,19,4),(172,18,10000,0,19,4),(172,19,10000,0,19,4),(172,20,10000,0,19,4),(172,21,10000,0,19,4),(172,22,10000,0,19,4),(172,23,10000,0,19,4),(172,24,10000,0,19,4),(172,25,10000,0,19,4),(172,26,10000,0,19,4),(172,27,10000,0,19,4),(172,28,10000,0,19,4),(172,29,10000,0,19,4),(172,30,10000,0,19,4),(173,1,0,1,19,4),(173,2,0,1,19,4),(173,3,0,1,19,4),(173,4,0,1,19,4),(173,5,0,1,19,4),(173,6,0,1,19,4),(173,7,0,1,19,4),(173,8,0,1,19,4),(173,9,0,1,19,4),(173,10,0,1,19,4),(173,11,0,1,19,4),(173,12,0,1,19,4),(173,13,0,1,19,4),(173,14,0,1,19,4),(173,15,0,1,19,4),(173,16,0,1,19,4),(173,17,0,1,19,4),(173,18,0,1,19,4),(173,19,0,1,19,4),(173,20,0,1,19,4),(173,21,0,1,19,4),(173,22,0,1,19,4),(173,23,0,1,19,4),(173,24,0,1,19,4),(173,25,0,1,19,4),(173,26,0,1,19,4),(173,27,0,1,19,4),(173,28,0,1,19,4),(173,29,0,1,19,4),(173,30,0,1,19,4),(174,1,0,1,19,4),(174,2,0,1,19,4),(174,3,0,1,19,4),(174,4,0,1,19,4),(174,5,0,1,19,4),(174,6,0,1,19,4),(174,7,0,1,19,4),(174,8,0,1,19,4),(174,9,0,1,19,4),(174,10,0,1,19,4),(174,11,0,1,19,4),(174,12,0,1,19,4),(174,13,0,1,19,4),(174,14,0,1,19,4),(174,15,0,1,19,4),(174,16,0,1,19,4),(174,17,0,1,19,4),(174,18,0,1,19,4),(174,19,0,1,19,4),(174,20,0,1,19,4),(174,21,0,1,19,4),(174,22,0,1,19,4),(174,23,0,1,19,4),(174,24,0,1,19,4),(174,25,0,1,19,4),(174,26,0,1,19,4),(174,27,0,1,19,4),(174,28,0,1,19,4),(174,29,0,1,19,4),(174,30,0,1,19,4),(175,1,0,1,19,4),(175,2,0,1,19,4),(175,3,0,1,19,4),(175,4,0,1,19,4),(175,5,0,1,19,4),(175,6,0,1,19,4),(175,7,0,1,19,4),(175,8,0,1,19,4),(175,9,0,1,19,4),(175,10,0,1,19,4),(175,11,0,1,19,4),(175,12,0,1,19,4),(175,13,0,1,19,4),(175,14,0,1,19,4),(175,15,0,1,19,4),(175,16,0,1,19,4),(175,17,0,1,19,4),(175,18,0,1,19,4),(175,19,0,1,19,4),(175,20,0,1,19,4),(175,21,0,1,19,4),(175,22,0,1,19,4),(175,23,0,1,19,4),(175,24,0,1,19,4),(175,25,0,1,19,4),(175,26,0,1,19,4),(175,27,0,1,19,4),(175,28,0,1,19,4),(175,29,0,1,19,4),(175,30,0,1,19,4),(176,1,0,1,19,4),(176,2,0,1,19,4),(176,3,0,1,19,4),(176,4,0,1,19,4),(176,5,0,1,19,4),(176,6,0,1,19,4),(176,7,0,1,19,4),(176,8,0,1,19,4),(176,9,0,1,19,4),(176,10,0,1,19,4),(176,11,0,1,19,4),(176,12,0,1,19,4),(176,13,0,1,19,4),(176,14,0,1,19,4),(176,15,0,1,19,4),(176,16,0,1,19,4),(176,17,0,1,19,4),(176,18,0,1,19,4),(176,19,0,1,19,4),(176,20,0,1,19,4),(176,21,0,1,19,4),(176,22,0,1,19,4),(176,23,0,1,19,4),(176,24,0,1,19,4),(176,25,0,1,19,4),(176,26,0,1,19,4),(176,27,0,1,19,4),(176,28,0,1,19,4),(176,29,0,1,19,4),(176,30,0,1,19,4),(177,74,0,1,19,4),(177,75,0,1,19,4),(177,76,0,1,19,4),(177,77,0,1,19,4),(177,78,0,1,19,4),(177,79,0,1,19,4),(177,80,0,1,19,4),(178,74,10000,0,19,4),(178,75,10000,0,19,4),(178,76,10000,0,19,4),(178,77,10000,0,19,4),(178,78,10000,0,19,4),(178,79,10000,0,19,4),(178,80,10000,0,19,4),(178,81,10000,0,19,4),(178,82,10000,0,19,4),(178,83,10000,0,19,4),(178,84,10000,0,19,4),(178,85,10000,0,19,4),(178,86,10000,0,19,4),(178,87,10000,0,19,4),(178,88,10000,0,19,4),(178,113,10000,0,19,4),(178,114,10000,0,19,4),(178,115,10000,0,19,4),(178,116,10000,0,19,4),(178,117,10000,0,19,4),(178,118,10000,0,19,4),(178,119,10000,0,19,4),(178,120,10000,0,19,4),(178,121,10000,0,19,4),(178,122,10000,0,19,4),(178,123,10000,0,19,4),(178,124,10000,0,19,4),(178,125,10000,0,19,4),(178,126,10000,0,19,4),(178,127,10000,0,19,4),(178,128,10000,0,19,4),(178,129,10000,0,19,4),(178,130,10000,0,19,4),(178,131,10000,0,19,4),(178,132,10000,0,19,4),(178,133,10000,0,19,4),(178,134,10000,0,19,4),(178,135,10000,0,19,4),(178,136,10000,0,19,4),(178,137,10000,0,19,4),(178,138,10000,0,19,4),(178,139,10000,0,19,4),(178,140,10000,0,19,4),(178,141,10000,0,19,4),(178,142,10000,0,19,4),(178,143,10000,0,19,4),(178,144,10000,0,19,4),(178,145,10000,0,19,4),(178,146,10000,0,19,4),(178,147,10000,0,19,4),(178,148,10000,0,19,4),(178,149,10000,0,19,4),(178,150,10000,0,19,4),(178,151,10000,0,19,4),(178,152,10000,0,19,4),(178,153,10000,0,19,4),(178,154,10000,0,19,4),(178,155,10000,0,19,4),(178,156,10000,0,19,4),(178,157,10000,0,19,4),(178,158,10000,0,19,4),(178,159,10000,0,19,4),(178,160,10000,0,19,4),(178,161,10000,0,19,4),(178,162,10000,0,19,4),(178,163,10000,0,19,4),(178,164,10000,0,19,4),(178,165,10000,0,19,4),(178,166,10000,0,19,4),(178,167,10000,0,19,4),(178,168,10000,0,19,4),(178,169,10000,0,19,4),(178,170,10000,0,19,4),(178,171,10000,0,19,4),(178,172,10000,0,19,4),(178,173,10000,0,19,4),(178,174,10000,0,19,4),(178,175,10000,0,19,4),(178,176,10000,0,19,4),(178,177,10000,0,19,4),(178,178,10000,0,19,4),(178,179,10000,0,19,4),(178,180,10000,0,19,4),(178,181,10000,0,19,4),(178,182,10000,0,19,4),(178,183,10000,0,19,4),(178,184,10000,0,19,4),(178,185,10000,0,19,4),(178,186,10000,0,19,4),(178,187,10000,0,19,4),(178,188,10000,0,19,4),(178,189,10000,0,19,4),(178,190,10000,0,19,4),(178,191,10000,0,19,4),(178,192,10000,0,19,4),(178,193,10000,0,19,4),(178,194,10000,0,19,4),(178,195,10000,0,19,4),(178,196,10000,0,19,4),(178,197,10000,0,19,4),(178,198,10000,0,19,4),(178,199,10000,0,19,4),(178,200,10000,0,19,4),(178,201,10000,0,19,4),(178,202,10000,0,19,4),(178,203,10000,0,19,4),(178,204,10000,0,19,4),(178,205,10000,0,19,4),(178,206,10000,0,19,4),(178,207,10000,0,19,4),(178,208,10000,0,19,4),(178,209,10000,0,19,4),(178,210,10000,0,19,4),(178,211,10000,0,19,4),(178,212,10000,0,19,4),(178,213,10000,0,19,4),(178,214,10000,0,19,4),(178,215,10000,0,19,4),(178,216,10000,0,19,4),(178,217,10000,0,19,4),(178,218,10000,0,19,4),(178,219,10000,0,19,4),(178,220,10000,0,19,4),(178,221,10000,0,19,4),(178,222,10000,0,19,4),(178,223,10000,0,19,4),(178,224,10000,0,19,4),(178,225,10000,0,19,4),(178,226,10000,0,19,4),(178,227,10000,0,19,4),(178,228,10000,0,19,4),(178,229,10000,0,19,4),(178,230,10000,0,19,4),(178,231,10000,0,19,4),(178,232,10000,0,19,4),(178,233,10000,0,19,4),(178,234,10000,0,19,4),(178,235,10000,0,19,4),(178,236,10000,0,19,4),(178,237,10000,0,19,4),(178,238,10000,0,19,4),(178,239,10000,0,19,4),(178,240,10000,0,19,4),(178,241,10000,0,19,4),(178,244,10000,0,19,4),(178,246,10000,0,19,4),(178,251,10000,0,19,4),(178,255,10000,0,19,4),(178,258,10000,0,19,4),(178,259,10000,0,19,4),(178,260,10000,0,19,4),(178,261,10000,0,19,4),(178,262,10000,0,19,4),(178,263,10000,0,19,4),(179,81,0,1,19,4),(179,82,0,1,19,4),(179,83,0,1,19,4),(179,84,0,1,19,4),(179,85,0,1,19,4),(179,86,0,1,19,4),(179,87,0,1,19,4),(179,88,0,1,19,4),(180,81,0,1,19,4),(181,86,0,1,19,4),(182,82,0,1,19,4),(182,83,0,1,19,4),(182,84,0,1,19,4),(182,85,0,1,19,4),(182,87,0,1,19,4),(182,88,0,1,19,4),(183,82,0,1,19,4),(183,83,0,1,19,4),(183,84,0,1,19,4),(183,85,0,1,19,4),(183,86,0,1,19,4),(183,87,0,1,19,4),(183,88,0,1,19,4),(192,89,0,1,19,4),(192,90,0,1,19,4),(192,91,0,1,19,4),(192,92,0,1,19,4),(192,93,0,1,19,4),(192,94,0,1,19,4),(193,95,0,1,19,4),(193,96,0,1,19,4),(193,97,0,1,19,4),(193,98,0,1,19,4),(193,99,0,1,19,4),(193,100,0,1,19,4),(194,95,0,1,19,4),(194,96,0,1,19,4),(194,97,0,1,19,4),(194,98,0,1,19,4),(194,99,0,1,19,4),(194,100,0,1,19,4),(195,95,0,1,19,4),(195,96,0,1,19,4),(195,97,0,1,19,4),(195,98,0,1,19,4),(195,99,0,1,19,4),(195,100,0,1,19,4),(196,95,0,1,19,4),(196,96,0,1,19,4),(196,97,0,1,19,4),(196,98,0,1,19,4),(196,99,0,1,19,4),(196,100,0,1,19,4),(197,95,0,1,19,4),(197,96,0,1,19,4),(197,97,0,1,19,4),(197,98,0,1,19,4),(197,99,0,1,19,4),(197,100,0,1,19,4),(198,101,0,1,19,4),(198,109,0,1,19,4),(198,111,0,1,19,4),(198,112,0,1,19,4),(199,103,0,1,19,4),(199,110,0,1,19,4),(200,101,0,1,19,4),(200,102,0,1,19,4),(200,108,0,1,19,4),(201,104,0,1,19,4),(201,106,0,1,19,4),(202,101,0,1,19,4),(202,102,0,1,19,4),(202,103,0,1,19,4),(202,105,0,1,19,4),(202,107,0,1,19,4),(202,108,0,1,19,4),(202,110,0,1,19,4),(203,101,0,1,19,4),(203,102,0,1,19,4),(203,103,0,1,19,4),(203,104,0,1,19,4),(203,106,0,1,19,4),(203,108,0,1,19,4),(203,109,0,1,19,4),(204,101,0,1,19,4),(204,102,0,1,19,4),(204,103,0,1,19,4),(204,104,0,1,19,4),(204,105,0,1,19,4),(204,106,0,1,19,4),(204,107,0,1,19,4),(204,108,0,1,19,4),(205,101,0,1,19,4),(205,102,0,1,19,4),(205,103,0,1,19,4),(205,108,0,1,19,4),(205,109,0,1,19,4),(205,110,0,1,19,4),(205,111,0,1,19,4),(205,112,0,1,19,4),(206,113,10000,0,19,4),(206,114,10000,0,19,4),(206,115,10000,0,19,4),(206,116,10000,0,19,4),(206,117,10000,0,19,4),(206,118,10000,0,19,4),(206,119,10000,0,19,4),(207,114,0,1,19,4),(207,119,0,1,19,4),(209,114,0,1,19,4),(212,116,0,1,19,4),(212,118,0,1,19,4),(213,113,0,1,19,4),(218,117,0,1,19,4),(219,119,0,1,19,4),(220,119,0,1,19,4),(221,119,0,1,19,4),(222,114,0,1,19,4),(222,119,0,1,19,4),(223,114,0,1,19,4),(223,119,0,1,19,4),(229,113,0,1,19,4),(230,113,0,1,19,4),(231,113,0,1,19,4),(232,113,0,1,19,4),(233,113,0,1,19,4),(234,116,0,1,19,4),(234,118,0,1,19,4),(235,116,0,1,19,4),(235,118,0,1,19,4),(236,116,0,1,19,4),(236,118,0,1,19,4),(237,116,0,1,19,4),(237,118,0,1,19,4),(238,116,0,1,19,4),(238,118,0,1,19,4),(239,115,0,1,19,4),(241,115,0,1,19,4),(242,115,0,1,19,4),(243,115,0,1,19,4),(250,120,0,1,19,4),(250,121,0,1,19,4),(250,122,0,1,19,4),(250,123,0,1,19,4),(250,124,0,1,19,4),(250,125,0,1,19,4),(250,126,0,1,19,4),(250,127,0,1,19,4),(250,128,0,1,19,4),(250,129,0,1,19,4),(250,130,0,1,19,4),(250,131,0,1,19,4),(251,120,0,1,19,4),(251,121,0,1,19,4),(251,122,0,1,19,4),(251,123,0,1,19,4),(251,124,0,1,19,4),(251,125,0,1,19,4),(251,126,0,1,19,4),(251,127,0,1,19,4),(251,128,0,1,19,4),(251,129,0,1,19,4),(251,130,0,1,19,4),(251,131,0,1,19,4),(252,125,10000,0,19,4),(252,126,10000,0,19,4),(252,127,10000,0,19,4),(252,120,0,1,19,4),(252,121,0,1,19,4),(252,122,0,1,19,4),(252,123,0,1,19,4),(252,124,0,1,19,4),(252,128,0,1,19,4),(252,129,0,1,19,4),(252,131,0,1,19,4),(253,120,0,1,19,4),(253,121,0,1,19,4),(253,122,0,1,19,4),(253,123,0,1,19,4),(253,124,0,1,19,4),(253,125,0,1,19,4),(253,126,0,1,19,4),(253,127,0,1,19,4),(253,128,0,1,19,4),(253,129,0,1,19,4),(253,130,0,1,19,4),(253,131,0,1,19,4),(254,120,0,1,19,4),(254,121,0,1,19,4),(254,122,0,1,19,4),(254,123,0,1,19,4),(254,124,0,1,19,4),(254,125,0,1,19,4),(254,126,0,1,19,4),(254,127,0,1,19,4),(254,128,0,1,19,4),(254,129,0,1,19,4),(254,130,0,1,19,4),(254,131,0,1,19,4),(255,122,0,1,19,4),(255,123,0,1,19,4),(255,124,0,1,19,4),(255,125,0,1,19,4),(255,126,0,1,19,4),(255,129,0,1,19,4),(256,121,0,1,19,4),(256,122,0,1,19,4),(256,123,0,1,19,4),(256,125,0,1,19,4),(256,126,0,1,19,4),(256,127,0,1,19,4),(257,121,0,1,19,4),(257,122,0,1,19,4),(257,123,0,1,19,4),(257,125,0,1,19,4),(257,127,0,1,19,4),(257,129,0,1,19,4),(258,121,0,1,19,4),(258,122,0,1,19,4),(258,125,0,1,19,4),(258,126,0,1,19,4),(258,127,0,1,19,4),(258,129,0,1,19,4),(259,120,0,1,19,4),(259,121,0,1,19,4),(259,123,0,1,19,4),(259,128,0,1,19,4),(259,129,0,1,19,4),(260,120,0,1,19,4),(260,121,0,1,19,4),(260,122,0,1,19,4),(260,123,0,1,19,4),(260,125,0,1,19,4),(260,127,0,1,19,4),(260,128,0,1,19,4),(260,129,0,1,19,4),(261,121,0,1,19,4),(261,122,0,1,19,4),(261,125,0,1,19,4),(261,126,0,1,19,4),(261,127,0,1,19,4),(261,129,0,1,19,4),(262,125,0,1,19,4),(262,126,0,1,19,4),(263,120,0,1,19,4),(263,121,0,1,19,4),(263,122,0,1,19,4),(263,123,0,1,19,4),(263,124,0,1,19,4),(263,128,0,1,19,4),(263,129,0,1,19,4),(263,131,0,1,19,4),(264,120,0,1,19,4),(264,122,0,1,19,4),(264,123,0,1,19,4),(264,125,0,1,19,4),(264,126,0,1,19,4),(264,129,0,1,19,4),(265,121,0,1,19,4),(265,122,0,1,19,4),(265,123,0,1,19,4),(265,127,0,1,19,4),(266,123,0,1,19,4),(266,125,0,1,19,4),(266,126,0,1,19,4),(266,127,0,1,19,4),(266,129,0,1,19,4),(267,121,0,1,19,4),(267,125,0,1,19,4),(267,126,0,1,19,4),(267,127,0,1,19,4),(268,120,0,1,19,4),(268,121,0,1,19,4),(268,122,0,1,19,4),(268,123,0,1,19,4),(268,124,0,1,19,4),(268,127,0,1,19,4),(268,129,0,1,19,4),(269,122,0,1,19,4),(269,125,0,1,19,4),(269,126,0,1,19,4),(269,127,0,1,19,4),(269,129,0,1,19,4),(270,121,0,1,19,4),(270,123,0,1,19,4),(270,125,0,1,19,4),(270,126,0,1,19,4),(270,129,0,1,19,4),(271,120,0,1,19,4),(271,121,0,1,19,4),(271,122,0,1,19,4),(271,125,0,1,19,4),(271,126,0,1,19,4),(271,127,0,1,19,4),(271,129,0,1,19,4),(272,122,0,1,19,4),(272,123,0,1,19,4),(272,124,0,1,19,4),(272,125,0,1,19,4),(272,126,0,1,19,4),(272,127,0,1,19,4),(272,128,0,1,19,4),(272,129,0,1,19,4),(273,120,0,1,19,4),(273,121,0,1,19,4),(273,123,0,1,19,4),(273,126,0,1,19,4),(273,127,0,1,19,4),(274,122,0,1,19,4),(274,123,0,1,19,4),(274,125,0,1,19,4),(274,126,0,1,19,4),(274,129,0,1,19,4),(275,120,0,1,19,4),(275,121,0,1,19,4),(275,122,0,1,19,4),(275,123,0,1,19,4),(275,124,0,1,19,4),(275,125,0,1,19,4),(275,126,0,1,19,4),(275,127,0,1,19,4),(275,128,0,1,19,4),(275,129,0,1,19,4),(275,130,0,1,19,4),(275,131,0,1,19,4),(276,122,0,1,19,4),(276,123,0,1,19,4),(276,127,0,1,19,4),(276,129,0,1,19,4),(277,120,0,1,19,4),(277,121,0,1,19,4),(277,123,0,1,19,4),(277,124,0,1,19,4),(277,125,0,1,19,4),(277,126,0,1,19,4),(277,127,0,1,19,4),(278,120,0,1,19,4),(278,121,0,1,19,4),(278,122,0,1,19,4),(278,123,0,1,19,4),(278,124,0,1,19,4),(278,125,0,1,19,4),(278,127,0,1,19,4),(278,128,0,1,19,4),(278,129,0,1,19,4),(279,120,0,1,19,4),(279,122,0,1,19,4),(279,126,0,1,19,4),(279,127,0,1,19,4),(279,129,0,1,19,4),(280,132,0,1,19,4),(280,133,0,1,19,4),(280,134,0,1,19,4),(280,135,0,1,19,4),(280,136,0,1,19,4),(280,137,0,1,19,4),(280,138,0,1,19,4),(280,139,0,1,19,4),(282,132,0,1,19,4),(282,133,0,1,19,4),(282,134,0,1,19,4),(282,137,0,1,19,4),(282,138,0,1,19,4),(283,135,0,1,19,4),(283,136,0,1,19,4),(283,139,0,1,19,4),(286,140,0,1,19,4),(286,141,0,1,19,4),(286,142,0,1,19,4),(286,143,0,1,19,4),(286,144,0,1,19,4),(286,145,0,1,19,4),(286,146,0,1,19,4),(286,147,0,1,19,4),(286,148,0,1,19,4),(286,149,0,1,19,4),(286,150,0,1,19,4),(286,151,0,1,19,4),(286,152,0,1,19,4),(286,153,0,1,19,4),(286,154,0,1,19,4),(286,155,0,1,19,4),(286,156,0,1,19,4),(286,157,0,1,19,4),(286,158,0,1,19,4),(286,159,0,1,19,4),(286,160,0,1,19,4),(286,161,0,1,19,4),(286,162,0,1,19,4),(286,163,0,1,19,4),(286,164,0,1,19,4),(286,165,0,1,19,4),(286,166,0,1,19,4),(286,167,0,1,19,4),(286,168,0,1,19,4),(286,169,0,1,19,4),(286,170,0,1,19,4),(286,171,0,1,19,4),(286,172,0,1,19,4),(286,173,0,1,19,4),(286,174,0,1,19,4),(286,175,0,1,19,4),(286,176,0,1,19,4),(286,177,0,1,19,4),(286,178,0,1,19,4),(286,179,0,1,19,4),(286,180,0,1,19,4),(286,181,0,1,19,4),(286,182,0,1,19,4),(286,183,0,1,19,4),(286,184,0,1,19,4),(286,185,0,1,19,4),(286,186,0,1,19,4),(286,187,0,1,19,4),(287,188,0,1,19,4),(288,189,0,1,19,4),(288,190,0,1,19,4),(288,191,0,1,19,4),(288,192,0,1,19,4),(288,193,0,1,19,4),(288,194,0,1,19,4),(288,195,0,1,19,4),(288,196,0,1,19,4),(288,197,0,1,19,4),(288,198,0,1,19,4),(288,199,0,1,19,4),(288,200,0,1,19,4),(289,201,10000,0,19,4),(289,202,10000,0,19,4),(289,203,10000,0,19,4),(289,204,10000,0,19,4),(289,205,10000,0,19,4),(289,206,10000,0,19,4),(289,207,10000,0,19,4),(289,208,10000,0,19,4),(289,209,10000,0,19,4),(289,210,10000,0,19,4),(289,211,10000,0,19,4),(289,212,10000,0,19,4),(289,213,10000,0,19,4),(289,214,10000,0,19,4),(289,215,10000,0,19,4),(289,216,10000,0,19,4),(289,217,10000,0,19,4),(289,218,10000,0,19,4),(289,219,10000,0,19,4),(289,220,10000,0,19,4),(289,221,10000,0,19,4),(289,222,10000,0,19,4),(289,223,10000,0,19,4),(289,224,10000,0,19,4),(289,225,10000,0,19,4),(289,226,10000,0,19,4),(289,227,10000,0,19,4),(289,228,10000,0,19,4),(289,229,10000,0,19,4),(289,230,10000,0,19,4),(289,231,10000,0,19,4),(289,232,10000,0,19,4),(289,244,10000,0,19,4),(289,246,10000,0,19,4),(289,251,10000,0,19,4),(289,255,10000,0,19,4),(289,258,10000,0,19,4),(289,259,10000,0,19,4),(289,260,10000,0,19,4),(289,261,10000,0,19,4),(289,262,10000,0,19,4),(289,263,10000,0,19,4),(290,209,0,1,19,4),(290,210,0,1,19,4),(290,211,0,1,19,4),(290,212,0,1,19,4),(290,213,0,1,19,4),(290,214,0,1,19,4),(290,215,0,1,19,4),(290,216,0,1,19,4),(291,201,0,1,19,4),(291,202,0,1,19,4),(291,203,0,1,19,4),(291,204,0,1,19,4),(291,205,0,1,19,4),(291,206,0,1,19,4),(291,207,0,1,19,4),(291,208,0,1,19,4),(292,217,0,1,19,4),(292,218,0,1,19,4),(292,219,0,1,19,4),(292,220,0,1,19,4),(292,221,0,1,19,4),(292,222,0,1,19,4),(292,223,0,1,19,4),(292,224,0,1,19,4),(293,225,0,1,19,4),(293,226,0,1,19,4),(293,227,0,1,19,4),(293,228,0,1,19,4),(293,229,0,1,19,4),(293,230,0,1,19,4),(293,231,0,1,19,4),(293,232,0,1,19,4),(293,255,0,1,19,4),(293,259,0,1,19,4),(293,260,0,1,19,4),(293,261,0,1,19,4),(293,262,0,1,19,4),(293,263,0,1,19,4),(294,233,0,1,19,4),(294,234,0,1,19,4),(294,235,0,1,19,4),(294,236,0,1,19,4),(294,237,0,1,19,4),(294,238,0,1,19,4),(294,239,0,1,19,4),(294,240,0,1,19,4),(294,241,0,1,19,4),(295,244,0,1,19,4),(295,246,0,1,19,4),(295,251,0,1,19,4),(295,255,0,1,19,4),(295,258,0,1,19,4),(296,251,0,1,19,4),(296,255,0,1,19,4),(296,258,0,1,19,4),(297,246,0,1,19,4),(297,255,0,1,19,4),(297,258,0,1,19,4),(298,255,0,1,19,4),(298,258,0,1,19,4),(299,251,0,1,19,4),(299,258,0,1,19,4);
/*!40000 ALTER TABLE `catalog_category_product_index_store19` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index_store19_replica`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store19_replica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store19_replica` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `IDX_2C975693BE61F02BFD1EDBEEC6F221E0` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_82E48DC71A051763241A906442461EBF` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Product Index Store19 Replica';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index_store19_replica`
--

LOCK TABLES `catalog_category_product_index_store19_replica` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index_store19_replica` DISABLE KEYS */;
INSERT INTO `catalog_category_product_index_store19_replica` VALUES (2,1,0,1,19,4),(2,2,0,1,19,4),(2,3,0,1,19,4),(2,4,0,1,19,4),(2,5,0,1,19,4),(2,6,0,1,19,4),(2,7,0,1,19,4),(2,8,0,1,19,4),(2,9,0,1,19,4),(2,10,0,1,19,4),(2,11,0,1,19,4),(2,12,0,1,19,4),(2,13,0,1,19,4),(2,14,0,1,19,4),(2,15,0,1,19,4),(2,16,0,1,19,4),(2,17,0,1,19,4),(2,18,0,1,19,4),(2,19,0,1,19,4),(2,20,0,1,19,4),(2,21,0,1,19,4),(2,22,0,1,19,4),(2,23,0,1,19,4),(2,24,0,1,19,4),(2,25,0,1,19,4),(2,26,0,1,19,4),(2,27,0,1,19,4),(2,28,0,1,19,4),(2,29,0,1,19,4),(2,30,0,1,19,4),(2,31,0,1,19,4),(2,32,0,1,19,4),(2,33,0,1,19,4),(2,34,0,1,19,4),(2,35,0,1,19,4),(2,36,0,1,19,4),(2,37,0,1,19,4),(2,38,0,1,19,4),(2,39,0,1,19,4),(2,40,0,1,19,4),(2,41,0,1,19,4),(2,42,0,1,19,4),(2,43,0,1,19,4),(2,44,0,1,19,4),(2,45,0,1,19,4),(2,46,0,1,19,4),(2,47,0,1,19,4),(2,48,0,1,19,4),(2,49,0,1,19,4),(2,50,0,1,19,4),(2,57,0,1,19,4),(2,58,0,1,19,4),(2,59,0,1,19,4),(2,60,0,1,19,4),(2,61,0,1,19,4),(2,62,0,1,19,4),(2,63,0,1,19,4),(2,64,0,1,19,4),(2,65,0,1,19,4),(2,66,0,1,19,4),(2,68,0,1,19,4),(2,69,0,1,19,4),(2,70,0,1,19,4),(2,71,0,1,19,4),(2,72,0,1,19,4),(2,73,0,1,19,4),(2,74,0,1,19,4),(2,75,0,1,19,4),(2,76,0,1,19,4),(2,77,0,1,19,4),(2,78,0,1,19,4),(2,79,0,1,19,4),(2,80,0,1,19,4),(2,81,0,1,19,4),(2,82,0,1,19,4),(2,83,0,1,19,4),(2,84,0,1,19,4),(2,85,0,1,19,4),(2,86,0,1,19,4),(2,87,0,1,19,4),(2,88,0,1,19,4),(2,89,0,1,19,4),(2,90,0,1,19,4),(2,91,0,1,19,4),(2,92,0,1,19,4),(2,93,0,1,19,4),(2,94,0,1,19,4),(2,95,0,1,19,4),(2,96,0,1,19,4),(2,97,0,1,19,4),(2,98,0,1,19,4),(2,99,0,1,19,4),(2,100,0,1,19,4),(2,101,0,1,19,4),(2,102,0,1,19,4),(2,103,0,1,19,4),(2,104,0,1,19,4),(2,105,0,1,19,4),(2,106,0,1,19,4),(2,107,0,1,19,4),(2,108,0,1,19,4),(2,109,0,1,19,4),(2,110,0,1,19,4),(2,111,0,1,19,4),(2,112,0,1,19,4),(2,113,0,1,19,4),(2,114,0,1,19,4),(2,115,0,1,19,4),(2,116,0,1,19,4),(2,117,0,1,19,4),(2,118,0,1,19,4),(2,119,0,1,19,4),(2,120,0,1,19,4),(2,121,0,1,19,4),(2,122,0,1,19,4),(2,123,0,1,19,4),(2,124,0,1,19,4),(2,125,0,1,19,4),(2,126,0,1,19,4),(2,127,0,1,19,4),(2,128,0,1,19,4),(2,129,0,1,19,4),(2,130,0,1,19,4),(2,131,0,1,19,4),(2,132,0,1,19,4),(2,133,0,1,19,4),(2,134,0,1,19,4),(2,135,0,1,19,4),(2,136,0,1,19,4),(2,137,0,1,19,4),(2,138,0,1,19,4),(2,139,0,1,19,4),(2,140,0,1,19,4),(2,141,0,1,19,4),(2,142,0,1,19,4),(2,143,0,1,19,4),(2,144,0,1,19,4),(2,145,0,1,19,4),(2,146,0,1,19,4),(2,147,0,1,19,4),(2,148,0,1,19,4),(2,149,0,1,19,4),(2,150,0,1,19,4),(2,151,0,1,19,4),(2,152,0,1,19,4),(2,153,0,1,19,4),(2,154,0,1,19,4),(2,155,0,1,19,4),(2,156,0,1,19,4),(2,157,0,1,19,4),(2,158,0,1,19,4),(2,159,0,1,19,4),(2,160,0,1,19,4),(2,161,0,1,19,4),(2,162,0,1,19,4),(2,163,0,1,19,4),(2,164,0,1,19,4),(2,165,0,1,19,4),(2,166,0,1,19,4),(2,167,0,1,19,4),(2,168,0,1,19,4),(2,169,0,1,19,4),(2,170,0,1,19,4),(2,171,0,1,19,4),(2,172,0,1,19,4),(2,173,0,1,19,4),(2,174,0,1,19,4),(2,175,0,1,19,4),(2,176,0,1,19,4),(2,177,0,1,19,4),(2,178,0,1,19,4),(2,179,0,1,19,4),(2,180,0,1,19,4),(2,181,0,1,19,4),(2,182,0,1,19,4),(2,183,0,1,19,4),(2,184,0,1,19,4),(2,185,0,1,19,4),(2,186,0,1,19,4),(2,187,0,1,19,4),(2,188,0,1,19,4),(2,189,0,1,19,4),(2,190,0,1,19,4),(2,191,0,1,19,4),(2,192,0,1,19,4),(2,193,0,1,19,4),(2,194,0,1,19,4),(2,195,0,1,19,4),(2,196,0,1,19,4),(2,197,0,1,19,4),(2,198,0,1,19,4),(2,199,0,1,19,4),(2,200,0,1,19,4),(2,201,0,1,19,4),(2,202,0,1,19,4),(2,203,0,1,19,4),(2,204,0,1,19,4),(2,205,0,1,19,4),(2,206,0,1,19,4),(2,207,0,1,19,4),(2,208,0,1,19,4),(2,209,0,1,19,4),(2,210,0,1,19,4),(2,211,0,1,19,4),(2,212,0,1,19,4),(2,213,0,1,19,4),(2,214,0,1,19,4),(2,215,0,1,19,4),(2,216,0,1,19,4),(2,217,0,1,19,4),(2,218,0,1,19,4),(2,219,0,1,19,4),(2,220,0,1,19,4),(2,221,0,1,19,4),(2,222,0,1,19,4),(2,223,0,1,19,4),(2,224,0,1,19,4),(2,225,0,1,19,4),(2,226,0,1,19,4),(2,227,0,1,19,4),(2,228,0,1,19,4),(2,229,0,1,19,4),(2,230,0,1,19,4),(2,231,0,1,19,4),(2,232,0,1,19,4),(2,233,0,1,19,4),(2,234,0,1,19,4),(2,235,0,1,19,4),(2,236,0,1,19,4),(2,237,0,1,19,4),(2,238,0,1,19,4),(2,239,0,1,19,4),(2,240,0,1,19,4),(2,241,0,1,19,4),(2,244,0,1,19,4),(2,246,0,1,19,4),(2,251,0,1,19,4),(2,255,0,1,19,4),(2,258,0,1,19,4),(2,259,0,1,19,4),(2,260,0,1,19,4),(2,261,0,1,19,4),(2,262,0,1,19,4),(2,263,0,1,19,4),(3,1,0,1,19,4),(3,2,0,1,19,4),(3,3,0,1,19,4),(3,4,0,1,19,4),(3,5,0,1,19,4),(3,6,0,1,19,4),(3,7,0,1,19,4),(3,8,0,1,19,4),(3,10,0,1,19,4),(3,11,0,1,19,4),(4,12,0,1,19,4),(4,13,0,1,19,4),(4,14,0,1,19,4),(4,15,0,1,19,4),(4,16,0,1,19,4),(4,17,0,1,19,4),(4,18,0,1,19,4),(4,19,0,1,19,4),(4,36,0,1,19,4),(4,37,0,1,19,4),(4,38,0,1,19,4),(4,39,0,1,19,4),(4,40,0,1,19,4),(5,95,10000,0,19,4),(5,96,10000,0,19,4),(5,97,10000,0,19,4),(5,98,10000,0,19,4),(5,99,10000,0,19,4),(5,100,10000,0,19,4),(7,101,10000,0,19,4),(7,102,10000,0,19,4),(7,103,10000,0,19,4),(7,104,10000,0,19,4),(7,105,10000,0,19,4),(7,106,10000,0,19,4),(7,107,10000,0,19,4),(7,108,10000,0,19,4),(7,109,10000,0,19,4),(7,110,10000,0,19,4),(7,111,10000,0,19,4),(7,112,10000,0,19,4),(7,21,0,1,19,4),(7,22,0,1,19,4),(7,26,0,1,19,4),(8,61,0,1,19,4),(8,62,0,1,19,4),(8,63,0,1,19,4),(8,64,0,1,19,4),(8,65,0,1,19,4),(8,66,0,1,19,4),(11,4,10000,0,19,4),(11,89,10000,0,19,4),(11,90,10000,0,19,4),(11,91,10000,0,19,4),(11,92,10000,0,19,4),(11,93,10000,0,19,4),(11,94,10000,0,19,4),(11,28,0,1,19,4),(11,29,0,1,19,4),(11,30,0,1,19,4),(11,31,0,1,19,4),(11,32,0,1,19,4),(11,33,0,1,19,4),(11,34,0,1,19,4),(11,35,0,1,19,4),(13,21,0,1,19,4),(13,24,0,1,19,4),(13,25,0,1,19,4),(13,26,0,1,19,4),(13,27,0,1,19,4),(13,41,0,1,19,4),(13,42,0,1,19,4),(13,43,0,1,19,4),(13,44,0,1,19,4),(13,45,0,1,19,4),(13,46,0,1,19,4),(13,47,0,1,19,4),(13,48,0,1,19,4),(13,49,0,1,19,4),(15,22,10000,0,19,4),(15,23,10000,0,19,4),(16,20,0,1,19,4),(16,21,0,1,19,4),(16,22,0,1,19,4),(16,23,0,1,19,4),(16,24,0,1,19,4),(16,25,0,1,19,4),(16,26,0,1,19,4),(16,27,0,1,19,4),(16,41,0,1,19,4),(16,68,0,1,19,4),(16,69,0,1,19,4),(16,70,0,1,19,4),(16,71,0,1,19,4),(16,72,0,1,19,4),(16,73,0,1,19,4),(19,6,0,1,19,4),(19,7,0,1,19,4),(19,8,0,1,19,4),(19,10,0,1,19,4),(19,11,0,1,19,4),(27,11,0,1,19,4),(29,6,0,1,19,4),(29,8,0,1,19,4),(29,10,0,1,19,4),(30,6,0,1,19,4),(30,10,0,1,19,4),(33,7,0,1,19,4),(33,8,0,1,19,4),(33,10,0,1,19,4),(33,11,0,1,19,4),(42,7,0,1,19,4),(42,8,0,1,19,4),(42,11,0,1,19,4),(78,21,0,1,19,4),(78,26,0,1,19,4),(80,21,0,1,19,4),(80,22,0,1,19,4),(80,26,0,1,19,4),(81,26,0,1,19,4),(82,26,0,1,19,4),(83,26,0,1,19,4),(96,26,0,1,19,4),(97,26,0,1,19,4),(98,21,0,1,19,4),(98,22,0,1,19,4),(98,26,0,1,19,4),(99,18,0,1,19,4),(101,14,0,1,19,4),(101,15,0,1,19,4),(101,16,0,1,19,4),(102,12,0,1,19,4),(102,13,0,1,19,4),(102,14,0,1,19,4),(102,15,0,1,19,4),(102,16,0,1,19,4),(102,17,0,1,19,4),(102,19,0,1,19,4),(102,36,0,1,19,4),(102,37,0,1,19,4),(102,38,0,1,19,4),(102,39,0,1,19,4),(102,40,0,1,19,4),(103,18,0,1,19,4),(104,18,0,1,19,4),(105,18,0,1,19,4),(106,18,0,1,19,4),(107,18,0,1,19,4),(134,23,0,1,19,4),(135,22,0,1,19,4),(137,4,0,1,19,4),(137,28,0,1,19,4),(137,31,0,1,19,4),(137,34,0,1,19,4),(137,35,0,1,19,4),(138,28,0,1,19,4),(138,30,0,1,19,4),(138,32,0,1,19,4),(138,33,0,1,19,4),(139,28,0,1,19,4),(139,30,0,1,19,4),(139,32,0,1,19,4),(139,33,0,1,19,4),(140,28,0,1,19,4),(140,30,0,1,19,4),(140,32,0,1,19,4),(140,33,0,1,19,4),(145,1,0,1,19,4),(145,2,0,1,19,4),(145,3,0,1,19,4),(145,4,0,1,19,4),(145,5,0,1,19,4),(145,6,0,1,19,4),(145,7,0,1,19,4),(145,8,0,1,19,4),(145,9,0,1,19,4),(145,10,0,1,19,4),(145,11,0,1,19,4),(145,12,0,1,19,4),(145,13,0,1,19,4),(145,14,0,1,19,4),(145,15,0,1,19,4),(145,16,0,1,19,4),(145,17,0,1,19,4),(145,18,0,1,19,4),(145,19,0,1,19,4),(145,20,0,1,19,4),(145,21,0,1,19,4),(145,22,0,1,19,4),(145,23,0,1,19,4),(145,24,0,1,19,4),(145,25,0,1,19,4),(145,26,0,1,19,4),(145,27,0,1,19,4),(145,28,0,1,19,4),(145,29,0,1,19,4),(145,30,0,1,19,4),(145,31,0,1,19,4),(145,32,0,1,19,4),(145,33,0,1,19,4),(145,34,0,1,19,4),(145,35,0,1,19,4),(145,36,0,1,19,4),(145,37,0,1,19,4),(145,38,0,1,19,4),(145,39,0,1,19,4),(145,40,0,1,19,4),(145,41,0,1,19,4),(145,42,0,1,19,4),(145,43,0,1,19,4),(149,41,0,1,19,4),(150,50,0,1,19,4),(150,57,0,1,19,4),(150,58,0,1,19,4),(150,59,0,1,19,4),(150,60,0,1,19,4),(151,61,0,1,19,4),(151,62,0,1,19,4),(151,63,0,1,19,4),(151,64,0,1,19,4),(151,65,0,1,19,4),(151,66,0,1,19,4),(152,61,0,1,19,4),(152,63,0,1,19,4),(153,61,0,1,19,4),(153,63,0,1,19,4),(153,64,0,1,19,4),(153,65,0,1,19,4),(153,66,0,1,19,4),(154,61,0,1,19,4),(154,62,0,1,19,4),(154,64,0,1,19,4),(154,66,0,1,19,4),(155,61,0,1,19,4),(155,62,0,1,19,4),(155,64,0,1,19,4),(155,65,0,1,19,4),(155,66,0,1,19,4),(156,61,0,1,19,4),(156,62,0,1,19,4),(156,63,0,1,19,4),(156,64,0,1,19,4),(156,65,0,1,19,4),(156,66,0,1,19,4),(157,61,0,1,19,4),(157,62,0,1,19,4),(157,64,0,1,19,4),(157,65,0,1,19,4),(157,66,0,1,19,4),(158,61,0,1,19,4),(158,63,0,1,19,4),(158,64,0,1,19,4),(158,65,0,1,19,4),(158,66,0,1,19,4),(159,61,0,1,19,4),(159,62,0,1,19,4),(159,63,0,1,19,4),(159,64,0,1,19,4),(159,65,0,1,19,4),(159,66,0,1,19,4),(160,41,0,1,19,4),(160,68,0,1,19,4),(160,69,0,1,19,4),(160,70,0,1,19,4),(160,72,0,1,19,4),(160,73,0,1,19,4),(161,68,0,1,19,4),(161,69,0,1,19,4),(161,70,0,1,19,4),(161,71,0,1,19,4),(161,72,0,1,19,4),(162,68,0,1,19,4),(162,69,0,1,19,4),(162,72,0,1,19,4),(164,41,0,1,19,4),(164,70,0,1,19,4),(164,73,0,1,19,4),(166,41,0,1,19,4),(166,70,0,1,19,4),(166,73,0,1,19,4),(167,68,0,1,19,4),(167,69,0,1,19,4),(167,72,0,1,19,4),(168,71,0,1,19,4),(169,70,0,1,19,4),(171,70,0,1,19,4),(172,1,10000,0,19,4),(172,2,10000,0,19,4),(172,3,10000,0,19,4),(172,4,10000,0,19,4),(172,5,10000,0,19,4),(172,6,10000,0,19,4),(172,7,10000,0,19,4),(172,8,10000,0,19,4),(172,9,10000,0,19,4),(172,10,10000,0,19,4),(172,11,10000,0,19,4),(172,12,10000,0,19,4),(172,13,10000,0,19,4),(172,14,10000,0,19,4),(172,15,10000,0,19,4),(172,16,10000,0,19,4),(172,17,10000,0,19,4),(172,18,10000,0,19,4),(172,19,10000,0,19,4),(172,20,10000,0,19,4),(172,21,10000,0,19,4),(172,22,10000,0,19,4),(172,23,10000,0,19,4),(172,24,10000,0,19,4),(172,25,10000,0,19,4),(172,26,10000,0,19,4),(172,27,10000,0,19,4),(172,28,10000,0,19,4),(172,29,10000,0,19,4),(172,30,10000,0,19,4),(173,1,0,1,19,4),(173,2,0,1,19,4),(173,3,0,1,19,4),(173,4,0,1,19,4),(173,5,0,1,19,4),(173,6,0,1,19,4),(173,7,0,1,19,4),(173,8,0,1,19,4),(173,9,0,1,19,4),(173,10,0,1,19,4),(173,11,0,1,19,4),(173,12,0,1,19,4),(173,13,0,1,19,4),(173,14,0,1,19,4),(173,15,0,1,19,4),(173,16,0,1,19,4),(173,17,0,1,19,4),(173,18,0,1,19,4),(173,19,0,1,19,4),(173,20,0,1,19,4),(173,21,0,1,19,4),(173,22,0,1,19,4),(173,23,0,1,19,4),(173,24,0,1,19,4),(173,25,0,1,19,4),(173,26,0,1,19,4),(173,27,0,1,19,4),(173,28,0,1,19,4),(173,29,0,1,19,4),(173,30,0,1,19,4),(174,1,0,1,19,4),(174,2,0,1,19,4),(174,3,0,1,19,4),(174,4,0,1,19,4),(174,5,0,1,19,4),(174,6,0,1,19,4),(174,7,0,1,19,4),(174,8,0,1,19,4),(174,9,0,1,19,4),(174,10,0,1,19,4),(174,11,0,1,19,4),(174,12,0,1,19,4),(174,13,0,1,19,4),(174,14,0,1,19,4),(174,15,0,1,19,4),(174,16,0,1,19,4),(174,17,0,1,19,4),(174,18,0,1,19,4),(174,19,0,1,19,4),(174,20,0,1,19,4),(174,21,0,1,19,4),(174,22,0,1,19,4),(174,23,0,1,19,4),(174,24,0,1,19,4),(174,25,0,1,19,4),(174,26,0,1,19,4),(174,27,0,1,19,4),(174,28,0,1,19,4),(174,29,0,1,19,4),(174,30,0,1,19,4),(175,1,0,1,19,4),(175,2,0,1,19,4),(175,3,0,1,19,4),(175,4,0,1,19,4),(175,5,0,1,19,4),(175,6,0,1,19,4),(175,7,0,1,19,4),(175,8,0,1,19,4),(175,9,0,1,19,4),(175,10,0,1,19,4),(175,11,0,1,19,4),(175,12,0,1,19,4),(175,13,0,1,19,4),(175,14,0,1,19,4),(175,15,0,1,19,4),(175,16,0,1,19,4),(175,17,0,1,19,4),(175,18,0,1,19,4),(175,19,0,1,19,4),(175,20,0,1,19,4),(175,21,0,1,19,4),(175,22,0,1,19,4),(175,23,0,1,19,4),(175,24,0,1,19,4),(175,25,0,1,19,4),(175,26,0,1,19,4),(175,27,0,1,19,4),(175,28,0,1,19,4),(175,29,0,1,19,4),(175,30,0,1,19,4),(176,1,0,1,19,4),(176,2,0,1,19,4),(176,3,0,1,19,4),(176,4,0,1,19,4),(176,5,0,1,19,4),(176,6,0,1,19,4),(176,7,0,1,19,4),(176,8,0,1,19,4),(176,9,0,1,19,4),(176,10,0,1,19,4),(176,11,0,1,19,4),(176,12,0,1,19,4),(176,13,0,1,19,4),(176,14,0,1,19,4),(176,15,0,1,19,4),(176,16,0,1,19,4),(176,17,0,1,19,4),(176,18,0,1,19,4),(176,19,0,1,19,4),(176,20,0,1,19,4),(176,21,0,1,19,4),(176,22,0,1,19,4),(176,23,0,1,19,4),(176,24,0,1,19,4),(176,25,0,1,19,4),(176,26,0,1,19,4),(176,27,0,1,19,4),(176,28,0,1,19,4),(176,29,0,1,19,4),(176,30,0,1,19,4),(177,74,0,1,19,4),(177,75,0,1,19,4),(177,76,0,1,19,4),(177,77,0,1,19,4),(177,78,0,1,19,4),(177,79,0,1,19,4),(177,80,0,1,19,4),(178,74,10000,0,19,4),(178,75,10000,0,19,4),(178,76,10000,0,19,4),(178,77,10000,0,19,4),(178,78,10000,0,19,4),(178,79,10000,0,19,4),(178,80,10000,0,19,4),(178,81,10000,0,19,4),(178,82,10000,0,19,4),(178,83,10000,0,19,4),(178,84,10000,0,19,4),(178,85,10000,0,19,4),(178,86,10000,0,19,4),(178,87,10000,0,19,4),(178,88,10000,0,19,4),(178,113,10000,0,19,4),(178,114,10000,0,19,4),(178,115,10000,0,19,4),(178,116,10000,0,19,4),(178,117,10000,0,19,4),(178,118,10000,0,19,4),(178,119,10000,0,19,4),(178,120,10000,0,19,4),(178,121,10000,0,19,4),(178,122,10000,0,19,4),(178,123,10000,0,19,4),(178,124,10000,0,19,4),(178,125,10000,0,19,4),(178,126,10000,0,19,4),(178,127,10000,0,19,4),(178,128,10000,0,19,4),(178,129,10000,0,19,4),(178,130,10000,0,19,4),(178,131,10000,0,19,4),(178,132,10000,0,19,4),(178,133,10000,0,19,4),(178,134,10000,0,19,4),(178,135,10000,0,19,4),(178,136,10000,0,19,4),(178,137,10000,0,19,4),(178,138,10000,0,19,4),(178,139,10000,0,19,4),(178,140,10000,0,19,4),(178,141,10000,0,19,4),(178,142,10000,0,19,4),(178,143,10000,0,19,4),(178,144,10000,0,19,4),(178,145,10000,0,19,4),(178,146,10000,0,19,4),(178,147,10000,0,19,4),(178,148,10000,0,19,4),(178,149,10000,0,19,4),(178,150,10000,0,19,4),(178,151,10000,0,19,4),(178,152,10000,0,19,4),(178,153,10000,0,19,4),(178,154,10000,0,19,4),(178,155,10000,0,19,4),(178,156,10000,0,19,4),(178,157,10000,0,19,4),(178,158,10000,0,19,4),(178,159,10000,0,19,4),(178,160,10000,0,19,4),(178,161,10000,0,19,4),(178,162,10000,0,19,4),(178,163,10000,0,19,4),(178,164,10000,0,19,4),(178,165,10000,0,19,4),(178,166,10000,0,19,4),(178,167,10000,0,19,4),(178,168,10000,0,19,4),(178,169,10000,0,19,4),(178,170,10000,0,19,4),(178,171,10000,0,19,4),(178,172,10000,0,19,4),(178,173,10000,0,19,4),(178,174,10000,0,19,4),(178,175,10000,0,19,4),(178,176,10000,0,19,4),(178,177,10000,0,19,4),(178,178,10000,0,19,4),(178,179,10000,0,19,4),(178,180,10000,0,19,4),(178,181,10000,0,19,4),(178,182,10000,0,19,4),(178,183,10000,0,19,4),(178,184,10000,0,19,4),(178,185,10000,0,19,4),(178,186,10000,0,19,4),(178,187,10000,0,19,4),(178,188,10000,0,19,4),(178,189,10000,0,19,4),(178,190,10000,0,19,4),(178,191,10000,0,19,4),(178,192,10000,0,19,4),(178,193,10000,0,19,4),(178,194,10000,0,19,4),(178,195,10000,0,19,4),(178,196,10000,0,19,4),(178,197,10000,0,19,4),(178,198,10000,0,19,4),(178,199,10000,0,19,4),(178,200,10000,0,19,4),(178,201,10000,0,19,4),(178,202,10000,0,19,4),(178,203,10000,0,19,4),(178,204,10000,0,19,4),(178,205,10000,0,19,4),(178,206,10000,0,19,4),(178,207,10000,0,19,4),(178,208,10000,0,19,4),(178,209,10000,0,19,4),(178,210,10000,0,19,4),(178,211,10000,0,19,4),(178,212,10000,0,19,4),(178,213,10000,0,19,4),(178,214,10000,0,19,4),(178,215,10000,0,19,4),(178,216,10000,0,19,4),(178,217,10000,0,19,4),(178,218,10000,0,19,4),(178,219,10000,0,19,4),(178,220,10000,0,19,4),(178,221,10000,0,19,4),(178,222,10000,0,19,4),(178,223,10000,0,19,4),(178,224,10000,0,19,4),(178,225,10000,0,19,4),(178,226,10000,0,19,4),(178,227,10000,0,19,4),(178,228,10000,0,19,4),(178,229,10000,0,19,4),(178,230,10000,0,19,4),(178,231,10000,0,19,4),(178,232,10000,0,19,4),(178,233,10000,0,19,4),(178,234,10000,0,19,4),(178,235,10000,0,19,4),(178,236,10000,0,19,4),(178,237,10000,0,19,4),(178,238,10000,0,19,4),(178,239,10000,0,19,4),(178,240,10000,0,19,4),(178,241,10000,0,19,4),(178,244,10000,0,19,4),(178,246,10000,0,19,4),(178,251,10000,0,19,4),(178,255,10000,0,19,4),(178,258,10000,0,19,4),(178,259,10000,0,19,4),(178,260,10000,0,19,4),(178,261,10000,0,19,4),(178,262,10000,0,19,4),(178,263,10000,0,19,4),(179,81,0,1,19,4),(179,82,0,1,19,4),(179,83,0,1,19,4),(179,84,0,1,19,4),(179,85,0,1,19,4),(179,86,0,1,19,4),(179,87,0,1,19,4),(179,88,0,1,19,4),(180,81,0,1,19,4),(181,86,0,1,19,4),(182,82,0,1,19,4),(182,83,0,1,19,4),(182,84,0,1,19,4),(182,85,0,1,19,4),(182,87,0,1,19,4),(182,88,0,1,19,4),(183,82,0,1,19,4),(183,83,0,1,19,4),(183,84,0,1,19,4),(183,85,0,1,19,4),(183,86,0,1,19,4),(183,87,0,1,19,4),(183,88,0,1,19,4),(192,89,0,1,19,4),(192,90,0,1,19,4),(192,91,0,1,19,4),(192,92,0,1,19,4),(192,93,0,1,19,4),(192,94,0,1,19,4),(193,95,0,1,19,4),(193,96,0,1,19,4),(193,97,0,1,19,4),(193,98,0,1,19,4),(193,99,0,1,19,4),(193,100,0,1,19,4),(194,95,0,1,19,4),(194,96,0,1,19,4),(194,97,0,1,19,4),(194,98,0,1,19,4),(194,99,0,1,19,4),(194,100,0,1,19,4),(195,95,0,1,19,4),(195,96,0,1,19,4),(195,97,0,1,19,4),(195,98,0,1,19,4),(195,99,0,1,19,4),(195,100,0,1,19,4),(196,95,0,1,19,4),(196,96,0,1,19,4),(196,97,0,1,19,4),(196,98,0,1,19,4),(196,99,0,1,19,4),(196,100,0,1,19,4),(197,95,0,1,19,4),(197,96,0,1,19,4),(197,97,0,1,19,4),(197,98,0,1,19,4),(197,99,0,1,19,4),(197,100,0,1,19,4),(198,101,0,1,19,4),(198,109,0,1,19,4),(198,111,0,1,19,4),(198,112,0,1,19,4),(199,103,0,1,19,4),(199,110,0,1,19,4),(200,101,0,1,19,4),(200,102,0,1,19,4),(200,108,0,1,19,4),(201,104,0,1,19,4),(201,106,0,1,19,4),(202,101,0,1,19,4),(202,102,0,1,19,4),(202,103,0,1,19,4),(202,105,0,1,19,4),(202,107,0,1,19,4),(202,108,0,1,19,4),(202,110,0,1,19,4),(203,101,0,1,19,4),(203,102,0,1,19,4),(203,103,0,1,19,4),(203,104,0,1,19,4),(203,106,0,1,19,4),(203,108,0,1,19,4),(203,109,0,1,19,4),(204,101,0,1,19,4),(204,102,0,1,19,4),(204,103,0,1,19,4),(204,104,0,1,19,4),(204,105,0,1,19,4),(204,106,0,1,19,4),(204,107,0,1,19,4),(204,108,0,1,19,4),(205,101,0,1,19,4),(205,102,0,1,19,4),(205,103,0,1,19,4),(205,108,0,1,19,4),(205,109,0,1,19,4),(205,110,0,1,19,4),(205,111,0,1,19,4),(205,112,0,1,19,4),(206,113,10000,0,19,4),(206,114,10000,0,19,4),(206,115,10000,0,19,4),(206,116,10000,0,19,4),(206,117,10000,0,19,4),(206,118,10000,0,19,4),(206,119,10000,0,19,4),(207,114,0,1,19,4),(207,119,0,1,19,4),(209,114,0,1,19,4),(212,116,0,1,19,4),(212,118,0,1,19,4),(213,113,0,1,19,4),(218,117,0,1,19,4),(219,119,0,1,19,4),(220,119,0,1,19,4),(221,119,0,1,19,4),(222,114,0,1,19,4),(222,119,0,1,19,4),(223,114,0,1,19,4),(223,119,0,1,19,4),(229,113,0,1,19,4),(230,113,0,1,19,4),(231,113,0,1,19,4),(232,113,0,1,19,4),(233,113,0,1,19,4),(234,116,0,1,19,4),(234,118,0,1,19,4),(235,116,0,1,19,4),(235,118,0,1,19,4),(236,116,0,1,19,4),(236,118,0,1,19,4),(237,116,0,1,19,4),(237,118,0,1,19,4),(238,116,0,1,19,4),(238,118,0,1,19,4),(239,115,0,1,19,4),(241,115,0,1,19,4),(242,115,0,1,19,4),(243,115,0,1,19,4),(250,120,0,1,19,4),(250,121,0,1,19,4),(250,122,0,1,19,4),(250,123,0,1,19,4),(250,124,0,1,19,4),(250,125,0,1,19,4),(250,126,0,1,19,4),(250,127,0,1,19,4),(250,128,0,1,19,4),(250,129,0,1,19,4),(250,130,0,1,19,4),(250,131,0,1,19,4),(251,120,0,1,19,4),(251,121,0,1,19,4),(251,122,0,1,19,4),(251,123,0,1,19,4),(251,124,0,1,19,4),(251,125,0,1,19,4),(251,126,0,1,19,4),(251,127,0,1,19,4),(251,128,0,1,19,4),(251,129,0,1,19,4),(251,130,0,1,19,4),(251,131,0,1,19,4),(252,125,10000,0,19,4),(252,126,10000,0,19,4),(252,127,10000,0,19,4),(252,120,0,1,19,4),(252,121,0,1,19,4),(252,122,0,1,19,4),(252,123,0,1,19,4),(252,124,0,1,19,4),(252,128,0,1,19,4),(252,129,0,1,19,4),(252,131,0,1,19,4),(253,120,0,1,19,4),(253,121,0,1,19,4),(253,122,0,1,19,4),(253,123,0,1,19,4),(253,124,0,1,19,4),(253,125,0,1,19,4),(253,126,0,1,19,4),(253,127,0,1,19,4),(253,128,0,1,19,4),(253,129,0,1,19,4),(253,130,0,1,19,4),(253,131,0,1,19,4),(254,120,0,1,19,4),(254,121,0,1,19,4),(254,122,0,1,19,4),(254,123,0,1,19,4),(254,124,0,1,19,4),(254,125,0,1,19,4),(254,126,0,1,19,4),(254,127,0,1,19,4),(254,128,0,1,19,4),(254,129,0,1,19,4),(254,130,0,1,19,4),(254,131,0,1,19,4),(255,122,0,1,19,4),(255,123,0,1,19,4),(255,124,0,1,19,4),(255,125,0,1,19,4),(255,126,0,1,19,4),(255,129,0,1,19,4),(256,121,0,1,19,4),(256,122,0,1,19,4),(256,123,0,1,19,4),(256,125,0,1,19,4),(256,126,0,1,19,4),(256,127,0,1,19,4),(257,121,0,1,19,4),(257,122,0,1,19,4),(257,123,0,1,19,4),(257,125,0,1,19,4),(257,127,0,1,19,4),(257,129,0,1,19,4),(258,121,0,1,19,4),(258,122,0,1,19,4),(258,125,0,1,19,4),(258,126,0,1,19,4),(258,127,0,1,19,4),(258,129,0,1,19,4),(259,120,0,1,19,4),(259,121,0,1,19,4),(259,123,0,1,19,4),(259,128,0,1,19,4),(259,129,0,1,19,4),(260,120,0,1,19,4),(260,121,0,1,19,4),(260,122,0,1,19,4),(260,123,0,1,19,4),(260,125,0,1,19,4),(260,127,0,1,19,4),(260,128,0,1,19,4),(260,129,0,1,19,4),(261,121,0,1,19,4),(261,122,0,1,19,4),(261,125,0,1,19,4),(261,126,0,1,19,4),(261,127,0,1,19,4),(261,129,0,1,19,4),(262,125,0,1,19,4),(262,126,0,1,19,4),(263,120,0,1,19,4),(263,121,0,1,19,4),(263,122,0,1,19,4),(263,123,0,1,19,4),(263,124,0,1,19,4),(263,128,0,1,19,4),(263,129,0,1,19,4),(263,131,0,1,19,4),(264,120,0,1,19,4),(264,122,0,1,19,4),(264,123,0,1,19,4),(264,125,0,1,19,4),(264,126,0,1,19,4),(264,129,0,1,19,4),(265,121,0,1,19,4),(265,122,0,1,19,4),(265,123,0,1,19,4),(265,127,0,1,19,4),(266,123,0,1,19,4),(266,125,0,1,19,4),(266,126,0,1,19,4),(266,127,0,1,19,4),(266,129,0,1,19,4),(267,121,0,1,19,4),(267,125,0,1,19,4),(267,126,0,1,19,4),(267,127,0,1,19,4),(268,120,0,1,19,4),(268,121,0,1,19,4),(268,122,0,1,19,4),(268,123,0,1,19,4),(268,124,0,1,19,4),(268,127,0,1,19,4),(268,129,0,1,19,4),(269,122,0,1,19,4),(269,125,0,1,19,4),(269,126,0,1,19,4),(269,127,0,1,19,4),(269,129,0,1,19,4),(270,121,0,1,19,4),(270,123,0,1,19,4),(270,125,0,1,19,4),(270,126,0,1,19,4),(270,129,0,1,19,4),(271,120,0,1,19,4),(271,121,0,1,19,4),(271,122,0,1,19,4),(271,125,0,1,19,4),(271,126,0,1,19,4),(271,127,0,1,19,4),(271,129,0,1,19,4),(272,122,0,1,19,4),(272,123,0,1,19,4),(272,124,0,1,19,4),(272,125,0,1,19,4),(272,126,0,1,19,4),(272,127,0,1,19,4),(272,128,0,1,19,4),(272,129,0,1,19,4),(273,120,0,1,19,4),(273,121,0,1,19,4),(273,123,0,1,19,4),(273,126,0,1,19,4),(273,127,0,1,19,4),(274,122,0,1,19,4),(274,123,0,1,19,4),(274,125,0,1,19,4),(274,126,0,1,19,4),(274,129,0,1,19,4),(275,120,0,1,19,4),(275,121,0,1,19,4),(275,122,0,1,19,4),(275,123,0,1,19,4),(275,124,0,1,19,4),(275,125,0,1,19,4),(275,126,0,1,19,4),(275,127,0,1,19,4),(275,128,0,1,19,4),(275,129,0,1,19,4),(275,130,0,1,19,4),(275,131,0,1,19,4),(276,122,0,1,19,4),(276,123,0,1,19,4),(276,127,0,1,19,4),(276,129,0,1,19,4),(277,120,0,1,19,4),(277,121,0,1,19,4),(277,123,0,1,19,4),(277,124,0,1,19,4),(277,125,0,1,19,4),(277,126,0,1,19,4),(277,127,0,1,19,4),(278,120,0,1,19,4),(278,121,0,1,19,4),(278,122,0,1,19,4),(278,123,0,1,19,4),(278,124,0,1,19,4),(278,125,0,1,19,4),(278,127,0,1,19,4),(278,128,0,1,19,4),(278,129,0,1,19,4),(279,120,0,1,19,4),(279,122,0,1,19,4),(279,126,0,1,19,4),(279,127,0,1,19,4),(279,129,0,1,19,4),(280,132,0,1,19,4),(280,133,0,1,19,4),(280,134,0,1,19,4),(280,135,0,1,19,4),(280,136,0,1,19,4),(280,137,0,1,19,4),(280,138,0,1,19,4),(280,139,0,1,19,4),(282,132,0,1,19,4),(282,133,0,1,19,4),(282,134,0,1,19,4),(282,137,0,1,19,4),(282,138,0,1,19,4),(283,135,0,1,19,4),(283,136,0,1,19,4),(283,139,0,1,19,4),(286,140,0,1,19,4),(286,141,0,1,19,4),(286,142,0,1,19,4),(286,143,0,1,19,4),(286,144,0,1,19,4),(286,145,0,1,19,4),(286,146,0,1,19,4),(286,147,0,1,19,4),(286,148,0,1,19,4),(286,149,0,1,19,4),(286,150,0,1,19,4),(286,151,0,1,19,4),(286,152,0,1,19,4),(286,153,0,1,19,4),(286,154,0,1,19,4),(286,155,0,1,19,4),(286,156,0,1,19,4),(286,157,0,1,19,4),(286,158,0,1,19,4),(286,159,0,1,19,4),(286,160,0,1,19,4),(286,161,0,1,19,4),(286,162,0,1,19,4),(286,163,0,1,19,4),(286,164,0,1,19,4),(286,165,0,1,19,4),(286,166,0,1,19,4),(286,167,0,1,19,4),(286,168,0,1,19,4),(286,169,0,1,19,4),(286,170,0,1,19,4),(286,171,0,1,19,4),(286,172,0,1,19,4),(286,173,0,1,19,4),(286,174,0,1,19,4),(286,175,0,1,19,4),(286,176,0,1,19,4),(286,177,0,1,19,4),(286,178,0,1,19,4),(286,179,0,1,19,4),(286,180,0,1,19,4),(286,181,0,1,19,4),(286,182,0,1,19,4),(286,183,0,1,19,4),(286,184,0,1,19,4),(286,185,0,1,19,4),(286,186,0,1,19,4),(286,187,0,1,19,4),(287,188,0,1,19,4),(288,189,0,1,19,4),(288,190,0,1,19,4),(288,191,0,1,19,4),(288,192,0,1,19,4),(288,193,0,1,19,4),(288,194,0,1,19,4),(288,195,0,1,19,4),(288,196,0,1,19,4),(288,197,0,1,19,4),(288,198,0,1,19,4),(288,199,0,1,19,4),(288,200,0,1,19,4),(289,201,10000,0,19,4),(289,202,10000,0,19,4),(289,203,10000,0,19,4),(289,204,10000,0,19,4),(289,205,10000,0,19,4),(289,206,10000,0,19,4),(289,207,10000,0,19,4),(289,208,10000,0,19,4),(289,209,10000,0,19,4),(289,210,10000,0,19,4),(289,211,10000,0,19,4),(289,212,10000,0,19,4),(289,213,10000,0,19,4),(289,214,10000,0,19,4),(289,215,10000,0,19,4),(289,216,10000,0,19,4),(289,217,10000,0,19,4),(289,218,10000,0,19,4),(289,219,10000,0,19,4),(289,220,10000,0,19,4),(289,221,10000,0,19,4),(289,222,10000,0,19,4),(289,223,10000,0,19,4),(289,224,10000,0,19,4),(289,225,10000,0,19,4),(289,226,10000,0,19,4),(289,227,10000,0,19,4),(289,228,10000,0,19,4),(289,229,10000,0,19,4),(289,230,10000,0,19,4),(289,231,10000,0,19,4),(289,232,10000,0,19,4),(289,244,10000,0,19,4),(289,246,10000,0,19,4),(289,251,10000,0,19,4),(289,255,10000,0,19,4),(289,258,10000,0,19,4),(289,259,10000,0,19,4),(289,260,10000,0,19,4),(289,261,10000,0,19,4),(289,262,10000,0,19,4),(289,263,10000,0,19,4),(290,209,0,1,19,4),(290,210,0,1,19,4),(290,211,0,1,19,4),(290,212,0,1,19,4),(290,213,0,1,19,4),(290,214,0,1,19,4),(290,215,0,1,19,4),(290,216,0,1,19,4),(291,201,0,1,19,4),(291,202,0,1,19,4),(291,203,0,1,19,4),(291,204,0,1,19,4),(291,205,0,1,19,4),(291,206,0,1,19,4),(291,207,0,1,19,4),(291,208,0,1,19,4),(292,217,0,1,19,4),(292,218,0,1,19,4),(292,219,0,1,19,4),(292,220,0,1,19,4),(292,221,0,1,19,4),(292,222,0,1,19,4),(292,223,0,1,19,4),(292,224,0,1,19,4),(293,225,0,1,19,4),(293,226,0,1,19,4),(293,227,0,1,19,4),(293,228,0,1,19,4),(293,229,0,1,19,4),(293,230,0,1,19,4),(293,231,0,1,19,4),(293,232,0,1,19,4),(293,255,0,1,19,4),(293,259,0,1,19,4),(293,260,0,1,19,4),(293,261,0,1,19,4),(293,262,0,1,19,4),(293,263,0,1,19,4),(294,233,0,1,19,4),(294,234,0,1,19,4),(294,235,0,1,19,4),(294,236,0,1,19,4),(294,237,0,1,19,4),(294,238,0,1,19,4),(294,239,0,1,19,4),(294,240,0,1,19,4),(294,241,0,1,19,4),(295,244,0,1,19,4),(295,246,0,1,19,4),(295,251,0,1,19,4),(295,255,0,1,19,4),(295,258,0,1,19,4),(296,251,0,1,19,4),(296,255,0,1,19,4),(296,258,0,1,19,4),(297,246,0,1,19,4),(297,255,0,1,19,4),(297,258,0,1,19,4),(298,255,0,1,19,4),(298,258,0,1,19,4),(299,251,0,1,19,4),(299,258,0,1,19,4);
/*!40000 ALTER TABLE `catalog_category_product_index_store19_replica` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index_store1_replica`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store1_replica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store1_replica` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `IDX_4B965DC45C352D6E4C9DC0FF50B1FCF5` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_47AB760CD6A893ACEA69A9C2E0112C60` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Product Index Store1 Replica';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index_store1_replica`
--

LOCK TABLES `catalog_category_product_index_store1_replica` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index_store1_replica` DISABLE KEYS */;
INSERT INTO `catalog_category_product_index_store1_replica` VALUES (2,1,0,1,1,4),(2,2,0,1,1,4),(2,3,0,1,1,4),(2,4,0,1,1,4),(2,5,0,1,1,4),(2,6,0,1,1,4),(2,7,0,1,1,4),(2,8,0,1,1,4),(2,9,0,1,1,4),(2,10,0,1,1,4),(2,11,0,1,1,4),(2,12,0,1,1,4),(2,13,0,1,1,4),(2,14,0,1,1,4),(2,15,0,1,1,4),(2,16,0,1,1,4),(2,17,0,1,1,4),(2,18,0,1,1,4),(2,19,0,1,1,4),(2,20,0,1,1,4),(2,21,0,1,1,4),(2,22,0,1,1,4),(2,23,0,1,1,4),(2,24,0,1,1,4),(2,25,0,1,1,4),(2,26,0,1,1,4),(2,27,0,1,1,4),(2,28,0,1,1,4),(2,29,0,1,1,4),(2,30,0,1,1,4),(2,31,0,1,1,4),(2,32,0,1,1,4),(2,33,0,1,1,4),(2,34,0,1,1,4),(2,35,0,1,1,4),(2,36,0,1,1,4),(2,37,0,1,1,4),(2,38,0,1,1,4),(2,39,0,1,1,4),(2,40,0,1,1,4),(2,41,0,1,1,4),(2,42,0,1,1,4),(2,43,0,1,1,4),(2,44,0,1,1,4),(2,45,0,1,1,4),(2,46,0,1,1,4),(2,47,0,1,1,4),(2,48,0,1,1,4),(2,49,0,1,1,4),(2,50,0,1,1,4),(2,57,0,1,1,4),(2,58,0,1,1,4),(2,59,0,1,1,4),(2,60,0,1,1,4),(2,61,0,1,1,4),(2,62,0,1,1,4),(2,63,0,1,1,4),(2,64,0,1,1,4),(2,65,0,1,1,4),(2,66,0,1,1,4),(2,68,0,1,1,4),(2,69,0,1,1,4),(2,70,0,1,1,4),(2,71,0,1,1,4),(2,72,0,1,1,4),(2,73,0,1,1,4),(2,74,0,1,1,4),(2,75,0,1,1,4),(2,76,0,1,1,4),(2,77,0,1,1,4),(2,78,0,1,1,4),(2,79,0,1,1,4),(2,80,0,1,1,4),(2,81,0,1,1,4),(2,82,0,1,1,4),(2,83,0,1,1,4),(2,84,0,1,1,4),(2,85,0,1,1,4),(2,86,0,1,1,4),(2,87,0,1,1,4),(2,88,0,1,1,4),(2,89,0,1,1,4),(2,90,0,1,1,4),(2,91,0,1,1,4),(2,92,0,1,1,4),(2,93,0,1,1,4),(2,94,0,1,1,4),(2,95,0,1,1,4),(2,96,0,1,1,4),(2,97,0,1,1,4),(2,98,0,1,1,4),(2,99,0,1,1,4),(2,100,0,1,1,4),(2,101,0,1,1,4),(2,102,0,1,1,4),(2,103,0,1,1,4),(2,104,0,1,1,4),(2,105,0,1,1,4),(2,106,0,1,1,4),(2,107,0,1,1,4),(2,108,0,1,1,4),(2,109,0,1,1,4),(2,110,0,1,1,4),(2,111,0,1,1,4),(2,112,0,1,1,4),(2,113,0,1,1,4),(2,114,0,1,1,4),(2,115,0,1,1,4),(2,116,0,1,1,4),(2,117,0,1,1,4),(2,118,0,1,1,4),(2,119,0,1,1,4),(2,120,0,1,1,4),(2,121,0,1,1,4),(2,122,0,1,1,4),(2,123,0,1,1,4),(2,124,0,1,1,4),(2,125,0,1,1,4),(2,126,0,1,1,4),(2,127,0,1,1,4),(2,128,0,1,1,4),(2,129,0,1,1,4),(2,130,0,1,1,4),(2,131,0,1,1,4),(2,132,0,1,1,4),(2,133,0,1,1,4),(2,134,0,1,1,4),(2,135,0,1,1,4),(2,136,0,1,1,4),(2,137,0,1,1,4),(2,138,0,1,1,4),(2,139,0,1,1,4),(2,140,0,1,1,4),(2,141,0,1,1,4),(2,142,0,1,1,4),(2,143,0,1,1,4),(2,144,0,1,1,4),(2,145,0,1,1,4),(2,146,0,1,1,4),(2,147,0,1,1,4),(2,148,0,1,1,4),(2,149,0,1,1,4),(2,150,0,1,1,4),(2,151,0,1,1,4),(2,152,0,1,1,4),(2,153,0,1,1,4),(2,154,0,1,1,4),(2,155,0,1,1,4),(2,156,0,1,1,4),(2,157,0,1,1,4),(2,158,0,1,1,4),(2,159,0,1,1,4),(2,160,0,1,1,4),(2,161,0,1,1,4),(2,162,0,1,1,4),(2,163,0,1,1,4),(2,164,0,1,1,4),(2,165,0,1,1,4),(2,166,0,1,1,4),(2,167,0,1,1,4),(2,168,0,1,1,4),(2,169,0,1,1,4),(2,170,0,1,1,4),(2,171,0,1,1,4),(2,172,0,1,1,4),(2,173,0,1,1,4),(2,174,0,1,1,4),(2,175,0,1,1,4),(2,176,0,1,1,4),(2,177,0,1,1,4),(2,178,0,1,1,4),(2,179,0,1,1,4),(2,180,0,1,1,4),(2,181,0,1,1,4),(2,182,0,1,1,4),(2,183,0,1,1,4),(2,184,0,1,1,4),(2,185,0,1,1,4),(2,186,0,1,1,4),(2,187,0,1,1,4),(2,188,0,1,1,4),(2,189,0,1,1,4),(2,190,0,1,1,4),(2,191,0,1,1,4),(2,192,0,1,1,4),(2,193,0,1,1,4),(2,194,0,1,1,4),(2,195,0,1,1,4),(2,196,0,1,1,4),(2,197,0,1,1,4),(2,198,0,1,1,4),(2,199,0,1,1,4),(2,200,0,1,1,4),(2,201,0,1,1,4),(2,202,0,1,1,4),(2,203,0,1,1,4),(2,204,0,1,1,4),(2,205,0,1,1,4),(2,206,0,1,1,4),(2,207,0,1,1,4),(2,208,0,1,1,4),(2,209,0,1,1,4),(2,210,0,1,1,4),(2,211,0,1,1,4),(2,212,0,1,1,4),(2,213,0,1,1,4),(2,214,0,1,1,4),(2,215,0,1,1,4),(2,216,0,1,1,4),(2,217,0,1,1,4),(2,218,0,1,1,4),(2,219,0,1,1,4),(2,220,0,1,1,4),(2,221,0,1,1,4),(2,222,0,1,1,4),(2,223,0,1,1,4),(2,224,0,1,1,4),(2,225,0,1,1,4),(2,226,0,1,1,4),(2,227,0,1,1,4),(2,228,0,1,1,4),(2,229,0,1,1,4),(2,230,0,1,1,4),(2,231,0,1,1,4),(2,232,0,1,1,4),(2,233,0,1,1,4),(2,234,0,1,1,4),(2,235,0,1,1,4),(2,236,0,1,1,4),(2,237,0,1,1,4),(2,238,0,1,1,4),(2,239,0,1,1,4),(2,240,0,1,1,4),(2,241,0,1,1,4),(2,244,0,1,1,4),(2,246,0,1,1,4),(2,251,0,1,1,4),(2,255,0,1,1,4),(2,258,0,1,1,4),(2,259,0,1,1,4),(2,260,0,1,1,4),(2,261,0,1,1,4),(2,262,0,1,1,4),(2,263,0,1,1,4),(3,1,0,1,1,4),(3,2,0,1,1,4),(3,3,0,1,1,4),(3,4,0,1,1,4),(3,5,0,1,1,4),(3,6,0,1,1,4),(3,7,0,1,1,4),(3,8,0,1,1,4),(3,10,0,1,1,4),(3,11,0,1,1,4),(4,12,0,1,1,4),(4,13,0,1,1,4),(4,14,0,1,1,4),(4,15,0,1,1,4),(4,16,0,1,1,4),(4,17,0,1,1,4),(4,18,0,1,1,4),(4,19,0,1,1,4),(4,36,0,1,1,4),(4,37,0,1,1,4),(4,38,0,1,1,4),(4,39,0,1,1,4),(4,40,0,1,1,4),(5,95,10000,0,1,4),(5,96,10000,0,1,4),(5,97,10000,0,1,4),(5,98,10000,0,1,4),(5,99,10000,0,1,4),(5,100,10000,0,1,4),(7,101,10000,0,1,4),(7,102,10000,0,1,4),(7,103,10000,0,1,4),(7,104,10000,0,1,4),(7,105,10000,0,1,4),(7,106,10000,0,1,4),(7,107,10000,0,1,4),(7,108,10000,0,1,4),(7,109,10000,0,1,4),(7,110,10000,0,1,4),(7,111,10000,0,1,4),(7,112,10000,0,1,4),(7,21,0,1,1,4),(7,22,0,1,1,4),(7,26,0,1,1,4),(8,61,0,1,1,4),(8,62,0,1,1,4),(8,63,0,1,1,4),(8,64,0,1,1,4),(8,65,0,1,1,4),(8,66,0,1,1,4),(11,4,10000,0,1,4),(11,89,10000,0,1,4),(11,90,10000,0,1,4),(11,91,10000,0,1,4),(11,92,10000,0,1,4),(11,93,10000,0,1,4),(11,94,10000,0,1,4),(11,28,0,1,1,4),(11,29,0,1,1,4),(11,30,0,1,1,4),(11,31,0,1,1,4),(11,32,0,1,1,4),(11,33,0,1,1,4),(11,34,0,1,1,4),(11,35,0,1,1,4),(13,21,0,1,1,4),(13,24,0,1,1,4),(13,25,0,1,1,4),(13,26,0,1,1,4),(13,27,0,1,1,4),(13,41,0,1,1,4),(13,42,0,1,1,4),(13,43,0,1,1,4),(13,44,0,1,1,4),(13,45,0,1,1,4),(13,46,0,1,1,4),(13,47,0,1,1,4),(13,48,0,1,1,4),(13,49,0,1,1,4),(15,22,10000,0,1,4),(15,23,10000,0,1,4),(16,20,0,1,1,4),(16,21,0,1,1,4),(16,22,0,1,1,4),(16,23,0,1,1,4),(16,24,0,1,1,4),(16,25,0,1,1,4),(16,26,0,1,1,4),(16,27,0,1,1,4),(16,41,0,1,1,4),(16,68,0,1,1,4),(16,69,0,1,1,4),(16,70,0,1,1,4),(16,71,0,1,1,4),(16,72,0,1,1,4),(16,73,0,1,1,4),(19,6,0,1,1,4),(19,7,0,1,1,4),(19,8,0,1,1,4),(19,10,0,1,1,4),(19,11,0,1,1,4),(27,11,0,1,1,4),(29,6,0,1,1,4),(29,8,0,1,1,4),(29,10,0,1,1,4),(30,6,0,1,1,4),(30,10,0,1,1,4),(33,7,0,1,1,4),(33,8,0,1,1,4),(33,10,0,1,1,4),(33,11,0,1,1,4),(42,7,0,1,1,4),(42,8,0,1,1,4),(42,11,0,1,1,4),(78,21,0,1,1,4),(78,26,0,1,1,4),(80,21,0,1,1,4),(80,22,0,1,1,4),(80,26,0,1,1,4),(81,26,0,1,1,4),(82,26,0,1,1,4),(83,26,0,1,1,4),(96,26,0,1,1,4),(97,26,0,1,1,4),(98,21,0,1,1,4),(98,22,0,1,1,4),(98,26,0,1,1,4),(99,18,0,1,1,4),(101,14,0,1,1,4),(101,15,0,1,1,4),(101,16,0,1,1,4),(102,12,0,1,1,4),(102,13,0,1,1,4),(102,14,0,1,1,4),(102,15,0,1,1,4),(102,16,0,1,1,4),(102,17,0,1,1,4),(102,19,0,1,1,4),(102,36,0,1,1,4),(102,37,0,1,1,4),(102,38,0,1,1,4),(102,39,0,1,1,4),(102,40,0,1,1,4),(103,18,0,1,1,4),(104,18,0,1,1,4),(105,18,0,1,1,4),(106,18,0,1,1,4),(107,18,0,1,1,4),(134,23,0,1,1,4),(135,22,0,1,1,4),(137,4,0,1,1,4),(137,28,0,1,1,4),(137,31,0,1,1,4),(137,34,0,1,1,4),(137,35,0,1,1,4),(138,28,0,1,1,4),(138,30,0,1,1,4),(138,32,0,1,1,4),(138,33,0,1,1,4),(139,28,0,1,1,4),(139,30,0,1,1,4),(139,32,0,1,1,4),(139,33,0,1,1,4),(140,28,0,1,1,4),(140,30,0,1,1,4),(140,32,0,1,1,4),(140,33,0,1,1,4),(145,1,0,1,1,4),(145,2,0,1,1,4),(145,3,0,1,1,4),(145,4,0,1,1,4),(145,5,0,1,1,4),(145,6,0,1,1,4),(145,7,0,1,1,4),(145,8,0,1,1,4),(145,9,0,1,1,4),(145,10,0,1,1,4),(145,11,0,1,1,4),(145,12,0,1,1,4),(145,13,0,1,1,4),(145,14,0,1,1,4),(145,15,0,1,1,4),(145,16,0,1,1,4),(145,17,0,1,1,4),(145,18,0,1,1,4),(145,19,0,1,1,4),(145,20,0,1,1,4),(145,21,0,1,1,4),(145,22,0,1,1,4),(145,23,0,1,1,4),(145,24,0,1,1,4),(145,25,0,1,1,4),(145,26,0,1,1,4),(145,27,0,1,1,4),(145,28,0,1,1,4),(145,29,0,1,1,4),(145,30,0,1,1,4),(145,31,0,1,1,4),(145,32,0,1,1,4),(145,33,0,1,1,4),(145,34,0,1,1,4),(145,35,0,1,1,4),(145,36,0,1,1,4),(145,37,0,1,1,4),(145,38,0,1,1,4),(145,39,0,1,1,4),(145,40,0,1,1,4),(145,41,0,1,1,4),(145,42,0,1,1,4),(145,43,0,1,1,4),(149,41,0,1,1,4),(150,50,0,1,1,4),(150,57,0,1,1,4),(150,58,0,1,1,4),(150,59,0,1,1,4),(150,60,0,1,1,4),(151,61,0,1,1,4),(151,62,0,1,1,4),(151,63,0,1,1,4),(151,64,0,1,1,4),(151,65,0,1,1,4),(151,66,0,1,1,4),(152,61,0,1,1,4),(152,63,0,1,1,4),(153,61,0,1,1,4),(153,63,0,1,1,4),(153,64,0,1,1,4),(153,65,0,1,1,4),(153,66,0,1,1,4),(154,61,0,1,1,4),(154,62,0,1,1,4),(154,64,0,1,1,4),(154,66,0,1,1,4),(155,61,0,1,1,4),(155,62,0,1,1,4),(155,64,0,1,1,4),(155,65,0,1,1,4),(155,66,0,1,1,4),(156,61,0,1,1,4),(156,62,0,1,1,4),(156,63,0,1,1,4),(156,64,0,1,1,4),(156,65,0,1,1,4),(156,66,0,1,1,4),(157,61,0,1,1,4),(157,62,0,1,1,4),(157,64,0,1,1,4),(157,65,0,1,1,4),(157,66,0,1,1,4),(158,61,0,1,1,4),(158,63,0,1,1,4),(158,64,0,1,1,4),(158,65,0,1,1,4),(158,66,0,1,1,4),(159,61,0,1,1,4),(159,62,0,1,1,4),(159,63,0,1,1,4),(159,64,0,1,1,4),(159,65,0,1,1,4),(159,66,0,1,1,4),(160,41,0,1,1,4),(160,68,0,1,1,4),(160,69,0,1,1,4),(160,70,0,1,1,4),(160,72,0,1,1,4),(160,73,0,1,1,4),(161,68,0,1,1,4),(161,69,0,1,1,4),(161,70,0,1,1,4),(161,71,0,1,1,4),(161,72,0,1,1,4),(162,68,0,1,1,4),(162,69,0,1,1,4),(162,72,0,1,1,4),(164,41,0,1,1,4),(164,70,0,1,1,4),(164,73,0,1,1,4),(166,41,0,1,1,4),(166,70,0,1,1,4),(166,73,0,1,1,4),(167,68,0,1,1,4),(167,69,0,1,1,4),(167,72,0,1,1,4),(168,71,0,1,1,4),(169,70,0,1,1,4),(171,70,0,1,1,4),(172,1,10000,0,1,4),(172,2,10000,0,1,4),(172,3,10000,0,1,4),(172,4,10000,0,1,4),(172,5,10000,0,1,4),(172,6,10000,0,1,4),(172,7,10000,0,1,4),(172,8,10000,0,1,4),(172,9,10000,0,1,4),(172,10,10000,0,1,4),(172,11,10000,0,1,4),(172,12,10000,0,1,4),(172,13,10000,0,1,4),(172,14,10000,0,1,4),(172,15,10000,0,1,4),(172,16,10000,0,1,4),(172,17,10000,0,1,4),(172,18,10000,0,1,4),(172,19,10000,0,1,4),(172,20,10000,0,1,4),(172,21,10000,0,1,4),(172,22,10000,0,1,4),(172,23,10000,0,1,4),(172,24,10000,0,1,4),(172,25,10000,0,1,4),(172,26,10000,0,1,4),(172,27,10000,0,1,4),(172,28,10000,0,1,4),(172,29,10000,0,1,4),(172,30,10000,0,1,4),(173,1,0,1,1,4),(173,2,0,1,1,4),(173,3,0,1,1,4),(173,4,0,1,1,4),(173,5,0,1,1,4),(173,6,0,1,1,4),(173,7,0,1,1,4),(173,8,0,1,1,4),(173,9,0,1,1,4),(173,10,0,1,1,4),(173,11,0,1,1,4),(173,12,0,1,1,4),(173,13,0,1,1,4),(173,14,0,1,1,4),(173,15,0,1,1,4),(173,16,0,1,1,4),(173,17,0,1,1,4),(173,18,0,1,1,4),(173,19,0,1,1,4),(173,20,0,1,1,4),(173,21,0,1,1,4),(173,22,0,1,1,4),(173,23,0,1,1,4),(173,24,0,1,1,4),(173,25,0,1,1,4),(173,26,0,1,1,4),(173,27,0,1,1,4),(173,28,0,1,1,4),(173,29,0,1,1,4),(173,30,0,1,1,4),(174,1,0,1,1,4),(174,2,0,1,1,4),(174,3,0,1,1,4),(174,4,0,1,1,4),(174,5,0,1,1,4),(174,6,0,1,1,4),(174,7,0,1,1,4),(174,8,0,1,1,4),(174,9,0,1,1,4),(174,10,0,1,1,4),(174,11,0,1,1,4),(174,12,0,1,1,4),(174,13,0,1,1,4),(174,14,0,1,1,4),(174,15,0,1,1,4),(174,16,0,1,1,4),(174,17,0,1,1,4),(174,18,0,1,1,4),(174,19,0,1,1,4),(174,20,0,1,1,4),(174,21,0,1,1,4),(174,22,0,1,1,4),(174,23,0,1,1,4),(174,24,0,1,1,4),(174,25,0,1,1,4),(174,26,0,1,1,4),(174,27,0,1,1,4),(174,28,0,1,1,4),(174,29,0,1,1,4),(174,30,0,1,1,4),(175,1,0,1,1,4),(175,2,0,1,1,4),(175,3,0,1,1,4),(175,4,0,1,1,4),(175,5,0,1,1,4),(175,6,0,1,1,4),(175,7,0,1,1,4),(175,8,0,1,1,4),(175,9,0,1,1,4),(175,10,0,1,1,4),(175,11,0,1,1,4),(175,12,0,1,1,4),(175,13,0,1,1,4),(175,14,0,1,1,4),(175,15,0,1,1,4),(175,16,0,1,1,4),(175,17,0,1,1,4),(175,18,0,1,1,4),(175,19,0,1,1,4),(175,20,0,1,1,4),(175,21,0,1,1,4),(175,22,0,1,1,4),(175,23,0,1,1,4),(175,24,0,1,1,4),(175,25,0,1,1,4),(175,26,0,1,1,4),(175,27,0,1,1,4),(175,28,0,1,1,4),(175,29,0,1,1,4),(175,30,0,1,1,4),(176,1,0,1,1,4),(176,2,0,1,1,4),(176,3,0,1,1,4),(176,4,0,1,1,4),(176,5,0,1,1,4),(176,6,0,1,1,4),(176,7,0,1,1,4),(176,8,0,1,1,4),(176,9,0,1,1,4),(176,10,0,1,1,4),(176,11,0,1,1,4),(176,12,0,1,1,4),(176,13,0,1,1,4),(176,14,0,1,1,4),(176,15,0,1,1,4),(176,16,0,1,1,4),(176,17,0,1,1,4),(176,18,0,1,1,4),(176,19,0,1,1,4),(176,20,0,1,1,4),(176,21,0,1,1,4),(176,22,0,1,1,4),(176,23,0,1,1,4),(176,24,0,1,1,4),(176,25,0,1,1,4),(176,26,0,1,1,4),(176,27,0,1,1,4),(176,28,0,1,1,4),(176,29,0,1,1,4),(176,30,0,1,1,4),(177,74,0,1,1,4),(177,75,0,1,1,4),(177,76,0,1,1,4),(177,77,0,1,1,4),(177,78,0,1,1,4),(177,79,0,1,1,4),(177,80,0,1,1,4),(178,74,10000,0,1,4),(178,75,10000,0,1,4),(178,76,10000,0,1,4),(178,77,10000,0,1,4),(178,78,10000,0,1,4),(178,79,10000,0,1,4),(178,80,10000,0,1,4),(178,81,10000,0,1,4),(178,82,10000,0,1,4),(178,83,10000,0,1,4),(178,84,10000,0,1,4),(178,85,10000,0,1,4),(178,86,10000,0,1,4),(178,87,10000,0,1,4),(178,88,10000,0,1,4),(178,113,10000,0,1,4),(178,114,10000,0,1,4),(178,115,10000,0,1,4),(178,116,10000,0,1,4),(178,117,10000,0,1,4),(178,118,10000,0,1,4),(178,119,10000,0,1,4),(178,120,10000,0,1,4),(178,121,10000,0,1,4),(178,122,10000,0,1,4),(178,123,10000,0,1,4),(178,124,10000,0,1,4),(178,125,10000,0,1,4),(178,126,10000,0,1,4),(178,127,10000,0,1,4),(178,128,10000,0,1,4),(178,129,10000,0,1,4),(178,130,10000,0,1,4),(178,131,10000,0,1,4),(178,132,10000,0,1,4),(178,133,10000,0,1,4),(178,134,10000,0,1,4),(178,135,10000,0,1,4),(178,136,10000,0,1,4),(178,137,10000,0,1,4),(178,138,10000,0,1,4),(178,139,10000,0,1,4),(178,140,10000,0,1,4),(178,141,10000,0,1,4),(178,142,10000,0,1,4),(178,143,10000,0,1,4),(178,144,10000,0,1,4),(178,145,10000,0,1,4),(178,146,10000,0,1,4),(178,147,10000,0,1,4),(178,148,10000,0,1,4),(178,149,10000,0,1,4),(178,150,10000,0,1,4),(178,151,10000,0,1,4),(178,152,10000,0,1,4),(178,153,10000,0,1,4),(178,154,10000,0,1,4),(178,155,10000,0,1,4),(178,156,10000,0,1,4),(178,157,10000,0,1,4),(178,158,10000,0,1,4),(178,159,10000,0,1,4),(178,160,10000,0,1,4),(178,161,10000,0,1,4),(178,162,10000,0,1,4),(178,163,10000,0,1,4),(178,164,10000,0,1,4),(178,165,10000,0,1,4),(178,166,10000,0,1,4),(178,167,10000,0,1,4),(178,168,10000,0,1,4),(178,169,10000,0,1,4),(178,170,10000,0,1,4),(178,171,10000,0,1,4),(178,172,10000,0,1,4),(178,173,10000,0,1,4),(178,174,10000,0,1,4),(178,175,10000,0,1,4),(178,176,10000,0,1,4),(178,177,10000,0,1,4),(178,178,10000,0,1,4),(178,179,10000,0,1,4),(178,180,10000,0,1,4),(178,181,10000,0,1,4),(178,182,10000,0,1,4),(178,183,10000,0,1,4),(178,184,10000,0,1,4),(178,185,10000,0,1,4),(178,186,10000,0,1,4),(178,187,10000,0,1,4),(178,188,10000,0,1,4),(178,189,10000,0,1,4),(178,190,10000,0,1,4),(178,191,10000,0,1,4),(178,192,10000,0,1,4),(178,193,10000,0,1,4),(178,194,10000,0,1,4),(178,195,10000,0,1,4),(178,196,10000,0,1,4),(178,197,10000,0,1,4),(178,198,10000,0,1,4),(178,199,10000,0,1,4),(178,200,10000,0,1,4),(178,201,10000,0,1,4),(178,202,10000,0,1,4),(178,203,10000,0,1,4),(178,204,10000,0,1,4),(178,205,10000,0,1,4),(178,206,10000,0,1,4),(178,207,10000,0,1,4),(178,208,10000,0,1,4),(178,209,10000,0,1,4),(178,210,10000,0,1,4),(178,211,10000,0,1,4),(178,212,10000,0,1,4),(178,213,10000,0,1,4),(178,214,10000,0,1,4),(178,215,10000,0,1,4),(178,216,10000,0,1,4),(178,217,10000,0,1,4),(178,218,10000,0,1,4),(178,219,10000,0,1,4),(178,220,10000,0,1,4),(178,221,10000,0,1,4),(178,222,10000,0,1,4),(178,223,10000,0,1,4),(178,224,10000,0,1,4),(178,225,10000,0,1,4),(178,226,10000,0,1,4),(178,227,10000,0,1,4),(178,228,10000,0,1,4),(178,229,10000,0,1,4),(178,230,10000,0,1,4),(178,231,10000,0,1,4),(178,232,10000,0,1,4),(178,233,10000,0,1,4),(178,234,10000,0,1,4),(178,235,10000,0,1,4),(178,236,10000,0,1,4),(178,237,10000,0,1,4),(178,238,10000,0,1,4),(178,239,10000,0,1,4),(178,240,10000,0,1,4),(178,241,10000,0,1,4),(178,244,10000,0,1,4),(178,246,10000,0,1,4),(178,251,10000,0,1,4),(178,255,10000,0,1,4),(178,258,10000,0,1,4),(178,259,10000,0,1,4),(178,260,10000,0,1,4),(178,261,10000,0,1,4),(178,262,10000,0,1,4),(178,263,10000,0,1,4),(179,81,0,1,1,4),(179,82,0,1,1,4),(179,83,0,1,1,4),(179,84,0,1,1,4),(179,85,0,1,1,4),(179,86,0,1,1,4),(179,87,0,1,1,4),(179,88,0,1,1,4),(180,81,0,1,1,4),(181,86,0,1,1,4),(182,82,0,1,1,4),(182,83,0,1,1,4),(182,84,0,1,1,4),(182,85,0,1,1,4),(182,87,0,1,1,4),(182,88,0,1,1,4),(183,82,0,1,1,4),(183,83,0,1,1,4),(183,84,0,1,1,4),(183,85,0,1,1,4),(183,86,0,1,1,4),(183,87,0,1,1,4),(183,88,0,1,1,4),(192,89,0,1,1,4),(192,90,0,1,1,4),(192,91,0,1,1,4),(192,92,0,1,1,4),(192,93,0,1,1,4),(192,94,0,1,1,4),(193,95,0,1,1,4),(193,96,0,1,1,4),(193,97,0,1,1,4),(193,98,0,1,1,4),(193,99,0,1,1,4),(193,100,0,1,1,4),(194,95,0,1,1,4),(194,96,0,1,1,4),(194,97,0,1,1,4),(194,98,0,1,1,4),(194,99,0,1,1,4),(194,100,0,1,1,4),(195,95,0,1,1,4),(195,96,0,1,1,4),(195,97,0,1,1,4),(195,98,0,1,1,4),(195,99,0,1,1,4),(195,100,0,1,1,4),(196,95,0,1,1,4),(196,96,0,1,1,4),(196,97,0,1,1,4),(196,98,0,1,1,4),(196,99,0,1,1,4),(196,100,0,1,1,4),(197,95,0,1,1,4),(197,96,0,1,1,4),(197,97,0,1,1,4),(197,98,0,1,1,4),(197,99,0,1,1,4),(197,100,0,1,1,4),(198,101,0,1,1,4),(198,109,0,1,1,4),(198,111,0,1,1,4),(198,112,0,1,1,4),(199,103,0,1,1,4),(199,110,0,1,1,4),(200,101,0,1,1,4),(200,102,0,1,1,4),(200,108,0,1,1,4),(201,104,0,1,1,4),(201,106,0,1,1,4),(202,101,0,1,1,4),(202,102,0,1,1,4),(202,103,0,1,1,4),(202,105,0,1,1,4),(202,107,0,1,1,4),(202,108,0,1,1,4),(202,110,0,1,1,4),(203,101,0,1,1,4),(203,102,0,1,1,4),(203,103,0,1,1,4),(203,104,0,1,1,4),(203,106,0,1,1,4),(203,108,0,1,1,4),(203,109,0,1,1,4),(204,101,0,1,1,4),(204,102,0,1,1,4),(204,103,0,1,1,4),(204,104,0,1,1,4),(204,105,0,1,1,4),(204,106,0,1,1,4),(204,107,0,1,1,4),(204,108,0,1,1,4),(205,101,0,1,1,4),(205,102,0,1,1,4),(205,103,0,1,1,4),(205,108,0,1,1,4),(205,109,0,1,1,4),(205,110,0,1,1,4),(205,111,0,1,1,4),(205,112,0,1,1,4),(206,113,10000,0,1,4),(206,114,10000,0,1,4),(206,115,10000,0,1,4),(206,116,10000,0,1,4),(206,117,10000,0,1,4),(206,118,10000,0,1,4),(206,119,10000,0,1,4),(207,114,0,1,1,4),(207,119,0,1,1,4),(209,114,0,1,1,4),(212,116,0,1,1,4),(212,118,0,1,1,4),(213,113,0,1,1,4),(218,117,0,1,1,4),(219,119,0,1,1,4),(220,119,0,1,1,4),(221,119,0,1,1,4),(222,114,0,1,1,4),(222,119,0,1,1,4),(223,114,0,1,1,4),(223,119,0,1,1,4),(229,113,0,1,1,4),(230,113,0,1,1,4),(231,113,0,1,1,4),(232,113,0,1,1,4),(233,113,0,1,1,4),(234,116,0,1,1,4),(234,118,0,1,1,4),(235,116,0,1,1,4),(235,118,0,1,1,4),(236,116,0,1,1,4),(236,118,0,1,1,4),(237,116,0,1,1,4),(237,118,0,1,1,4),(238,116,0,1,1,4),(238,118,0,1,1,4),(239,115,0,1,1,4),(241,115,0,1,1,4),(242,115,0,1,1,4),(243,115,0,1,1,4),(250,120,0,1,1,4),(250,121,0,1,1,4),(250,122,0,1,1,4),(250,123,0,1,1,4),(250,124,0,1,1,4),(250,125,0,1,1,4),(250,126,0,1,1,4),(250,127,0,1,1,4),(250,128,0,1,1,4),(250,129,0,1,1,4),(250,130,0,1,1,4),(250,131,0,1,1,4),(251,120,0,1,1,4),(251,121,0,1,1,4),(251,122,0,1,1,4),(251,123,0,1,1,4),(251,124,0,1,1,4),(251,125,0,1,1,4),(251,126,0,1,1,4),(251,127,0,1,1,4),(251,128,0,1,1,4),(251,129,0,1,1,4),(251,130,0,1,1,4),(251,131,0,1,1,4),(252,125,10000,0,1,4),(252,126,10000,0,1,4),(252,127,10000,0,1,4),(252,120,0,1,1,4),(252,121,0,1,1,4),(252,122,0,1,1,4),(252,123,0,1,1,4),(252,124,0,1,1,4),(252,128,0,1,1,4),(252,129,0,1,1,4),(252,131,0,1,1,4),(253,120,0,1,1,4),(253,121,0,1,1,4),(253,122,0,1,1,4),(253,123,0,1,1,4),(253,124,0,1,1,4),(253,125,0,1,1,4),(253,126,0,1,1,4),(253,127,0,1,1,4),(253,128,0,1,1,4),(253,129,0,1,1,4),(253,130,0,1,1,4),(253,131,0,1,1,4),(254,120,0,1,1,4),(254,121,0,1,1,4),(254,122,0,1,1,4),(254,123,0,1,1,4),(254,124,0,1,1,4),(254,125,0,1,1,4),(254,126,0,1,1,4),(254,127,0,1,1,4),(254,128,0,1,1,4),(254,129,0,1,1,4),(254,130,0,1,1,4),(254,131,0,1,1,4),(255,122,0,1,1,4),(255,123,0,1,1,4),(255,124,0,1,1,4),(255,125,0,1,1,4),(255,126,0,1,1,4),(255,129,0,1,1,4),(256,121,0,1,1,4),(256,122,0,1,1,4),(256,123,0,1,1,4),(256,125,0,1,1,4),(256,126,0,1,1,4),(256,127,0,1,1,4),(257,121,0,1,1,4),(257,122,0,1,1,4),(257,123,0,1,1,4),(257,125,0,1,1,4),(257,127,0,1,1,4),(257,129,0,1,1,4),(258,121,0,1,1,4),(258,122,0,1,1,4),(258,125,0,1,1,4),(258,126,0,1,1,4),(258,127,0,1,1,4),(258,129,0,1,1,4),(259,120,0,1,1,4),(259,121,0,1,1,4),(259,123,0,1,1,4),(259,128,0,1,1,4),(259,129,0,1,1,4),(260,120,0,1,1,4),(260,121,0,1,1,4),(260,122,0,1,1,4),(260,123,0,1,1,4),(260,125,0,1,1,4),(260,127,0,1,1,4),(260,128,0,1,1,4),(260,129,0,1,1,4),(261,121,0,1,1,4),(261,122,0,1,1,4),(261,125,0,1,1,4),(261,126,0,1,1,4),(261,127,0,1,1,4),(261,129,0,1,1,4),(262,125,0,1,1,4),(262,126,0,1,1,4),(263,120,0,1,1,4),(263,121,0,1,1,4),(263,122,0,1,1,4),(263,123,0,1,1,4),(263,124,0,1,1,4),(263,128,0,1,1,4),(263,129,0,1,1,4),(263,131,0,1,1,4),(264,120,0,1,1,4),(264,122,0,1,1,4),(264,123,0,1,1,4),(264,125,0,1,1,4),(264,126,0,1,1,4),(264,129,0,1,1,4),(265,121,0,1,1,4),(265,122,0,1,1,4),(265,123,0,1,1,4),(265,127,0,1,1,4),(266,123,0,1,1,4),(266,125,0,1,1,4),(266,126,0,1,1,4),(266,127,0,1,1,4),(266,129,0,1,1,4),(267,121,0,1,1,4),(267,125,0,1,1,4),(267,126,0,1,1,4),(267,127,0,1,1,4),(268,120,0,1,1,4),(268,121,0,1,1,4),(268,122,0,1,1,4),(268,123,0,1,1,4),(268,124,0,1,1,4),(268,127,0,1,1,4),(268,129,0,1,1,4),(269,122,0,1,1,4),(269,125,0,1,1,4),(269,126,0,1,1,4),(269,127,0,1,1,4),(269,129,0,1,1,4),(270,121,0,1,1,4),(270,123,0,1,1,4),(270,125,0,1,1,4),(270,126,0,1,1,4),(270,129,0,1,1,4),(271,120,0,1,1,4),(271,121,0,1,1,4),(271,122,0,1,1,4),(271,125,0,1,1,4),(271,126,0,1,1,4),(271,127,0,1,1,4),(271,129,0,1,1,4),(272,122,0,1,1,4),(272,123,0,1,1,4),(272,124,0,1,1,4),(272,125,0,1,1,4),(272,126,0,1,1,4),(272,127,0,1,1,4),(272,128,0,1,1,4),(272,129,0,1,1,4),(273,120,0,1,1,4),(273,121,0,1,1,4),(273,123,0,1,1,4),(273,126,0,1,1,4),(273,127,0,1,1,4),(274,122,0,1,1,4),(274,123,0,1,1,4),(274,125,0,1,1,4),(274,126,0,1,1,4),(274,129,0,1,1,4),(275,120,0,1,1,4),(275,121,0,1,1,4),(275,122,0,1,1,4),(275,123,0,1,1,4),(275,124,0,1,1,4),(275,125,0,1,1,4),(275,126,0,1,1,4),(275,127,0,1,1,4),(275,128,0,1,1,4),(275,129,0,1,1,4),(275,130,0,1,1,4),(275,131,0,1,1,4),(276,122,0,1,1,4),(276,123,0,1,1,4),(276,127,0,1,1,4),(276,129,0,1,1,4),(277,120,0,1,1,4),(277,121,0,1,1,4),(277,123,0,1,1,4),(277,124,0,1,1,4),(277,125,0,1,1,4),(277,126,0,1,1,4),(277,127,0,1,1,4),(278,120,0,1,1,4),(278,121,0,1,1,4),(278,122,0,1,1,4),(278,123,0,1,1,4),(278,124,0,1,1,4),(278,125,0,1,1,4),(278,127,0,1,1,4),(278,128,0,1,1,4),(278,129,0,1,1,4),(279,120,0,1,1,4),(279,122,0,1,1,4),(279,126,0,1,1,4),(279,127,0,1,1,4),(279,129,0,1,1,4),(280,132,0,1,1,4),(280,133,0,1,1,4),(280,134,0,1,1,4),(280,135,0,1,1,4),(280,136,0,1,1,4),(280,137,0,1,1,4),(280,138,0,1,1,4),(280,139,0,1,1,4),(282,132,0,1,1,4),(282,133,0,1,1,4),(282,134,0,1,1,4),(282,137,0,1,1,4),(282,138,0,1,1,4),(283,135,0,1,1,4),(283,136,0,1,1,4),(283,139,0,1,1,4),(286,140,0,1,1,4),(286,141,0,1,1,4),(286,142,0,1,1,4),(286,143,0,1,1,4),(286,144,0,1,1,4),(286,145,0,1,1,4),(286,146,0,1,1,4),(286,147,0,1,1,4),(286,148,0,1,1,4),(286,149,0,1,1,4),(286,150,0,1,1,4),(286,151,0,1,1,4),(286,152,0,1,1,4),(286,153,0,1,1,4),(286,154,0,1,1,4),(286,155,0,1,1,4),(286,156,0,1,1,4),(286,157,0,1,1,4),(286,158,0,1,1,4),(286,159,0,1,1,4),(286,160,0,1,1,4),(286,161,0,1,1,4),(286,162,0,1,1,4),(286,163,0,1,1,4),(286,164,0,1,1,4),(286,165,0,1,1,4),(286,166,0,1,1,4),(286,167,0,1,1,4),(286,168,0,1,1,4),(286,169,0,1,1,4),(286,170,0,1,1,4),(286,171,0,1,1,4),(286,172,0,1,1,4),(286,173,0,1,1,4),(286,174,0,1,1,4),(286,175,0,1,1,4),(286,176,0,1,1,4),(286,177,0,1,1,4),(286,178,0,1,1,4),(286,179,0,1,1,4),(286,180,0,1,1,4),(286,181,0,1,1,4),(286,182,0,1,1,4),(286,183,0,1,1,4),(286,184,0,1,1,4),(286,185,0,1,1,4),(286,186,0,1,1,4),(286,187,0,1,1,4),(287,188,0,1,1,4),(288,189,0,1,1,4),(288,190,0,1,1,4),(288,191,0,1,1,4),(288,192,0,1,1,4),(288,193,0,1,1,4),(288,194,0,1,1,4),(288,195,0,1,1,4),(288,196,0,1,1,4),(288,197,0,1,1,4),(288,198,0,1,1,4),(288,199,0,1,1,4),(288,200,0,1,1,4),(289,201,10000,0,1,4),(289,202,10000,0,1,4),(289,203,10000,0,1,4),(289,204,10000,0,1,4),(289,205,10000,0,1,4),(289,206,10000,0,1,4),(289,207,10000,0,1,4),(289,208,10000,0,1,4),(289,209,10000,0,1,4),(289,210,10000,0,1,4),(289,211,10000,0,1,4),(289,212,10000,0,1,4),(289,213,10000,0,1,4),(289,214,10000,0,1,4),(289,215,10000,0,1,4),(289,216,10000,0,1,4),(289,217,10000,0,1,4),(289,218,10000,0,1,4),(289,219,10000,0,1,4),(289,220,10000,0,1,4),(289,221,10000,0,1,4),(289,222,10000,0,1,4),(289,223,10000,0,1,4),(289,224,10000,0,1,4),(289,225,10000,0,1,4),(289,226,10000,0,1,4),(289,227,10000,0,1,4),(289,228,10000,0,1,4),(289,229,10000,0,1,4),(289,230,10000,0,1,4),(289,231,10000,0,1,4),(289,232,10000,0,1,4),(289,244,10000,0,1,4),(289,246,10000,0,1,4),(289,251,10000,0,1,4),(289,255,10000,0,1,4),(289,258,10000,0,1,4),(289,259,10000,0,1,4),(289,260,10000,0,1,4),(289,261,10000,0,1,4),(289,262,10000,0,1,4),(289,263,10000,0,1,4),(290,209,0,1,1,4),(290,210,0,1,1,4),(290,211,0,1,1,4),(290,212,0,1,1,4),(290,213,0,1,1,4),(290,214,0,1,1,4),(290,215,0,1,1,4),(290,216,0,1,1,4),(291,201,0,1,1,4),(291,202,0,1,1,4),(291,203,0,1,1,4),(291,204,0,1,1,4),(291,205,0,1,1,4),(291,206,0,1,1,4),(291,207,0,1,1,4),(291,208,0,1,1,4),(292,217,0,1,1,4),(292,218,0,1,1,4),(292,219,0,1,1,4),(292,220,0,1,1,4),(292,221,0,1,1,4),(292,222,0,1,1,4),(292,223,0,1,1,4),(292,224,0,1,1,4),(293,225,0,1,1,4),(293,226,0,1,1,4),(293,227,0,1,1,4),(293,228,0,1,1,4),(293,229,0,1,1,4),(293,230,0,1,1,4),(293,231,0,1,1,4),(293,232,0,1,1,4),(293,255,0,1,1,4),(293,259,0,1,1,4),(293,260,0,1,1,4),(293,261,0,1,1,4),(293,262,0,1,1,4),(293,263,0,1,1,4),(294,233,0,1,1,4),(294,234,0,1,1,4),(294,235,0,1,1,4),(294,236,0,1,1,4),(294,237,0,1,1,4),(294,238,0,1,1,4),(294,239,0,1,1,4),(294,240,0,1,1,4),(294,241,0,1,1,4),(295,244,0,1,1,4),(295,246,0,1,1,4),(295,251,0,1,1,4),(295,255,0,1,1,4),(295,258,0,1,1,4),(296,251,0,1,1,4),(296,255,0,1,1,4),(296,258,0,1,1,4),(297,246,0,1,1,4),(297,255,0,1,1,4),(297,258,0,1,1,4),(298,255,0,1,1,4),(298,258,0,1,1,4),(299,251,0,1,1,4),(299,258,0,1,1,4);
/*!40000 ALTER TABLE `catalog_category_product_index_store1_replica` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index_store2`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store2`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store2` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `CAT_CTGR_PRD_IDX_STORE2_PRD_ID_STORE_ID_CTGR_ID_VISIBILITY` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_2AB6FE58F086547FA7E4590837296849` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Product Index Store2';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index_store2`
--

LOCK TABLES `catalog_category_product_index_store2` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index_store2` DISABLE KEYS */;
INSERT INTO `catalog_category_product_index_store2` VALUES (2,1,0,1,2,4),(2,2,0,1,2,4),(2,3,0,1,2,4),(2,4,0,1,2,4),(2,5,0,1,2,4),(2,6,0,1,2,4),(2,7,0,1,2,4),(2,8,0,1,2,4),(2,9,0,1,2,4),(2,10,0,1,2,4),(2,11,0,1,2,4),(2,12,0,1,2,4),(2,13,0,1,2,4),(2,14,0,1,2,4),(2,15,0,1,2,4),(2,16,0,1,2,4),(2,17,0,1,2,4),(2,18,0,1,2,4),(2,19,0,1,2,4),(2,20,0,1,2,4),(2,21,0,1,2,4),(2,22,0,1,2,4),(2,23,0,1,2,4),(2,24,0,1,2,4),(2,25,0,1,2,4),(2,26,0,1,2,4),(2,27,0,1,2,4),(2,28,0,1,2,4),(2,29,0,1,2,4),(2,30,0,1,2,4),(2,31,0,1,2,4),(2,32,0,1,2,4),(2,33,0,1,2,4),(2,34,0,1,2,4),(2,35,0,1,2,4),(2,36,0,1,2,4),(2,37,0,1,2,4),(2,38,0,1,2,4),(2,39,0,1,2,4),(2,40,0,1,2,4),(2,41,0,1,2,4),(2,42,0,1,2,4),(2,43,0,1,2,4),(2,44,0,1,2,4),(2,45,0,1,2,4),(2,46,0,1,2,4),(2,47,0,1,2,4),(2,48,0,1,2,4),(2,49,0,1,2,4),(2,50,0,1,2,4),(2,57,0,1,2,4),(2,58,0,1,2,4),(2,59,0,1,2,4),(2,60,0,1,2,4),(2,61,0,1,2,4),(2,62,0,1,2,4),(2,63,0,1,2,4),(2,64,0,1,2,4),(2,65,0,1,2,4),(2,66,0,1,2,4),(2,68,0,1,2,4),(2,69,0,1,2,4),(2,70,0,1,2,4),(2,71,0,1,2,4),(2,72,0,1,2,4),(2,73,0,1,2,4),(2,74,0,1,2,4),(2,75,0,1,2,4),(2,76,0,1,2,4),(2,77,0,1,2,4),(2,78,0,1,2,4),(2,79,0,1,2,4),(2,80,0,1,2,4),(2,81,0,1,2,4),(2,82,0,1,2,4),(2,83,0,1,2,4),(2,84,0,1,2,4),(2,85,0,1,2,4),(2,86,0,1,2,4),(2,87,0,1,2,4),(2,88,0,1,2,4),(2,89,0,1,2,4),(2,90,0,1,2,4),(2,91,0,1,2,4),(2,92,0,1,2,4),(2,93,0,1,2,4),(2,94,0,1,2,4),(2,95,0,1,2,4),(2,96,0,1,2,4),(2,97,0,1,2,4),(2,98,0,1,2,4),(2,99,0,1,2,4),(2,100,0,1,2,4),(2,101,0,1,2,4),(2,102,0,1,2,4),(2,103,0,1,2,4),(2,104,0,1,2,4),(2,105,0,1,2,4),(2,106,0,1,2,4),(2,107,0,1,2,4),(2,108,0,1,2,4),(2,109,0,1,2,4),(2,110,0,1,2,4),(2,111,0,1,2,4),(2,112,0,1,2,4),(2,113,0,1,2,4),(2,114,0,1,2,4),(2,115,0,1,2,4),(2,116,0,1,2,4),(2,117,0,1,2,4),(2,118,0,1,2,4),(2,119,0,1,2,4),(2,120,0,1,2,4),(2,121,0,1,2,4),(2,122,0,1,2,4),(2,123,0,1,2,4),(2,124,0,1,2,4),(2,125,0,1,2,4),(2,126,0,1,2,4),(2,127,0,1,2,4),(2,128,0,1,2,4),(2,129,0,1,2,4),(2,130,0,1,2,4),(2,131,0,1,2,4),(2,132,0,1,2,4),(2,133,0,1,2,4),(2,134,0,1,2,4),(2,135,0,1,2,4),(2,136,0,1,2,4),(2,137,0,1,2,4),(2,138,0,1,2,4),(2,139,0,1,2,4),(2,140,0,1,2,4),(2,141,0,1,2,4),(2,142,0,1,2,4),(2,143,0,1,2,4),(2,144,0,1,2,4),(2,145,0,1,2,4),(2,146,0,1,2,4),(2,147,0,1,2,4),(2,148,0,1,2,4),(2,149,0,1,2,4),(2,150,0,1,2,4),(2,151,0,1,2,4),(2,152,0,1,2,4),(2,153,0,1,2,4),(2,154,0,1,2,4),(2,155,0,1,2,4),(2,156,0,1,2,4),(2,157,0,1,2,4),(2,158,0,1,2,4),(2,159,0,1,2,4),(2,160,0,1,2,4),(2,161,0,1,2,4),(2,162,0,1,2,4),(2,163,0,1,2,4),(2,164,0,1,2,4),(2,165,0,1,2,4),(2,166,0,1,2,4),(2,167,0,1,2,4),(2,168,0,1,2,4),(2,169,0,1,2,4),(2,170,0,1,2,4),(2,171,0,1,2,4),(2,172,0,1,2,4),(2,173,0,1,2,4),(2,174,0,1,2,4),(2,175,0,1,2,4),(2,176,0,1,2,4),(2,177,0,1,2,4),(2,178,0,1,2,4),(2,179,0,1,2,4),(2,180,0,1,2,4),(2,181,0,1,2,4),(2,182,0,1,2,4),(2,183,0,1,2,4),(2,184,0,1,2,4),(2,185,0,1,2,4),(2,186,0,1,2,4),(2,187,0,1,2,4),(2,188,0,1,2,4),(2,189,0,1,2,4),(2,190,0,1,2,4),(2,191,0,1,2,4),(2,192,0,1,2,4),(2,193,0,1,2,4),(2,194,0,1,2,4),(2,195,0,1,2,4),(2,196,0,1,2,4),(2,197,0,1,2,4),(2,198,0,1,2,4),(2,199,0,1,2,4),(2,200,0,1,2,4),(2,201,0,1,2,4),(2,202,0,1,2,4),(2,203,0,1,2,4),(2,204,0,1,2,4),(2,205,0,1,2,4),(2,206,0,1,2,4),(2,207,0,1,2,4),(2,208,0,1,2,4),(2,209,0,1,2,4),(2,210,0,1,2,4),(2,211,0,1,2,4),(2,212,0,1,2,4),(2,213,0,1,2,4),(2,214,0,1,2,4),(2,215,0,1,2,4),(2,216,0,1,2,4),(2,217,0,1,2,4),(2,218,0,1,2,4),(2,219,0,1,2,4),(2,220,0,1,2,4),(2,221,0,1,2,4),(2,222,0,1,2,4),(2,223,0,1,2,4),(2,224,0,1,2,4),(2,225,0,1,2,4),(2,226,0,1,2,4),(2,227,0,1,2,4),(2,228,0,1,2,4),(2,229,0,1,2,4),(2,230,0,1,2,4),(2,231,0,1,2,4),(2,232,0,1,2,4),(2,233,0,1,2,4),(2,234,0,1,2,4),(2,235,0,1,2,4),(2,236,0,1,2,4),(2,237,0,1,2,4),(2,238,0,1,2,4),(2,239,0,1,2,4),(2,240,0,1,2,4),(2,241,0,1,2,4),(2,244,0,1,2,4),(2,246,0,1,2,4),(2,251,0,1,2,4),(2,255,0,1,2,4),(2,258,0,1,2,4),(2,259,0,1,2,4),(2,260,0,1,2,4),(2,261,0,1,2,4),(2,262,0,1,2,4),(2,263,0,1,2,4),(3,1,0,1,2,4),(3,2,0,1,2,4),(3,3,0,1,2,4),(3,4,0,1,2,4),(3,5,0,1,2,4),(3,6,0,1,2,4),(3,7,0,1,2,4),(3,8,0,1,2,4),(3,10,0,1,2,4),(3,11,0,1,2,4),(4,12,0,1,2,4),(4,13,0,1,2,4),(4,14,0,1,2,4),(4,15,0,1,2,4),(4,16,0,1,2,4),(4,17,0,1,2,4),(4,18,0,1,2,4),(4,19,0,1,2,4),(4,36,0,1,2,4),(4,37,0,1,2,4),(4,38,0,1,2,4),(4,39,0,1,2,4),(4,40,0,1,2,4),(5,95,10000,0,2,4),(5,96,10000,0,2,4),(5,97,10000,0,2,4),(5,98,10000,0,2,4),(5,99,10000,0,2,4),(5,100,10000,0,2,4),(7,101,10000,0,2,4),(7,102,10000,0,2,4),(7,103,10000,0,2,4),(7,104,10000,0,2,4),(7,105,10000,0,2,4),(7,106,10000,0,2,4),(7,107,10000,0,2,4),(7,108,10000,0,2,4),(7,109,10000,0,2,4),(7,110,10000,0,2,4),(7,111,10000,0,2,4),(7,112,10000,0,2,4),(7,21,0,1,2,4),(7,22,0,1,2,4),(7,26,0,1,2,4),(8,61,0,1,2,4),(8,62,0,1,2,4),(8,63,0,1,2,4),(8,64,0,1,2,4),(8,65,0,1,2,4),(8,66,0,1,2,4),(11,4,10000,0,2,4),(11,89,10000,0,2,4),(11,90,10000,0,2,4),(11,91,10000,0,2,4),(11,92,10000,0,2,4),(11,93,10000,0,2,4),(11,94,10000,0,2,4),(11,28,0,1,2,4),(11,29,0,1,2,4),(11,30,0,1,2,4),(11,31,0,1,2,4),(11,32,0,1,2,4),(11,33,0,1,2,4),(11,34,0,1,2,4),(11,35,0,1,2,4),(13,21,0,1,2,4),(13,24,0,1,2,4),(13,25,0,1,2,4),(13,26,0,1,2,4),(13,27,0,1,2,4),(13,41,0,1,2,4),(13,42,0,1,2,4),(13,43,0,1,2,4),(13,44,0,1,2,4),(13,45,0,1,2,4),(13,46,0,1,2,4),(13,47,0,1,2,4),(13,48,0,1,2,4),(13,49,0,1,2,4),(15,22,10000,0,2,4),(15,23,10000,0,2,4),(16,20,0,1,2,4),(16,21,0,1,2,4),(16,22,0,1,2,4),(16,23,0,1,2,4),(16,24,0,1,2,4),(16,25,0,1,2,4),(16,26,0,1,2,4),(16,27,0,1,2,4),(16,41,0,1,2,4),(16,68,0,1,2,4),(16,69,0,1,2,4),(16,70,0,1,2,4),(16,71,0,1,2,4),(16,72,0,1,2,4),(16,73,0,1,2,4),(19,6,0,1,2,4),(19,7,0,1,2,4),(19,8,0,1,2,4),(19,10,0,1,2,4),(19,11,0,1,2,4),(27,11,0,1,2,4),(29,6,0,1,2,4),(29,8,0,1,2,4),(29,10,0,1,2,4),(30,6,0,1,2,4),(30,10,0,1,2,4),(33,7,0,1,2,4),(33,8,0,1,2,4),(33,10,0,1,2,4),(33,11,0,1,2,4),(42,7,0,1,2,4),(42,8,0,1,2,4),(42,11,0,1,2,4),(78,21,0,1,2,4),(78,26,0,1,2,4),(80,21,0,1,2,4),(80,22,0,1,2,4),(80,26,0,1,2,4),(81,26,0,1,2,4),(82,26,0,1,2,4),(83,26,0,1,2,4),(96,26,0,1,2,4),(97,26,0,1,2,4),(98,21,0,1,2,4),(98,22,0,1,2,4),(98,26,0,1,2,4),(99,18,0,1,2,4),(101,14,0,1,2,4),(101,15,0,1,2,4),(101,16,0,1,2,4),(102,12,0,1,2,4),(102,13,0,1,2,4),(102,14,0,1,2,4),(102,15,0,1,2,4),(102,16,0,1,2,4),(102,17,0,1,2,4),(102,19,0,1,2,4),(102,36,0,1,2,4),(102,37,0,1,2,4),(102,38,0,1,2,4),(102,39,0,1,2,4),(102,40,0,1,2,4),(103,18,0,1,2,4),(104,18,0,1,2,4),(105,18,0,1,2,4),(106,18,0,1,2,4),(107,18,0,1,2,4),(134,23,0,1,2,4),(135,22,0,1,2,4),(137,4,0,1,2,4),(137,28,0,1,2,4),(137,31,0,1,2,4),(137,34,0,1,2,4),(137,35,0,1,2,4),(138,28,0,1,2,4),(138,30,0,1,2,4),(138,32,0,1,2,4),(138,33,0,1,2,4),(139,28,0,1,2,4),(139,30,0,1,2,4),(139,32,0,1,2,4),(139,33,0,1,2,4),(140,28,0,1,2,4),(140,30,0,1,2,4),(140,32,0,1,2,4),(140,33,0,1,2,4),(145,1,0,1,2,4),(145,2,0,1,2,4),(145,3,0,1,2,4),(145,4,0,1,2,4),(145,5,0,1,2,4),(145,6,0,1,2,4),(145,7,0,1,2,4),(145,8,0,1,2,4),(145,9,0,1,2,4),(145,10,0,1,2,4),(145,11,0,1,2,4),(145,12,0,1,2,4),(145,13,0,1,2,4),(145,14,0,1,2,4),(145,15,0,1,2,4),(145,16,0,1,2,4),(145,17,0,1,2,4),(145,18,0,1,2,4),(145,19,0,1,2,4),(145,20,0,1,2,4),(145,21,0,1,2,4),(145,22,0,1,2,4),(145,23,0,1,2,4),(145,24,0,1,2,4),(145,25,0,1,2,4),(145,26,0,1,2,4),(145,27,0,1,2,4),(145,28,0,1,2,4),(145,29,0,1,2,4),(145,30,0,1,2,4),(145,31,0,1,2,4),(145,32,0,1,2,4),(145,33,0,1,2,4),(145,34,0,1,2,4),(145,35,0,1,2,4),(145,36,0,1,2,4),(145,37,0,1,2,4),(145,38,0,1,2,4),(145,39,0,1,2,4),(145,40,0,1,2,4),(145,41,0,1,2,4),(145,42,0,1,2,4),(145,43,0,1,2,4),(149,41,0,1,2,4),(150,50,0,1,2,4),(150,57,0,1,2,4),(150,58,0,1,2,4),(150,59,0,1,2,4),(150,60,0,1,2,4),(151,61,0,1,2,4),(151,62,0,1,2,4),(151,63,0,1,2,4),(151,64,0,1,2,4),(151,65,0,1,2,4),(151,66,0,1,2,4),(152,61,0,1,2,4),(152,63,0,1,2,4),(153,61,0,1,2,4),(153,63,0,1,2,4),(153,64,0,1,2,4),(153,65,0,1,2,4),(153,66,0,1,2,4),(154,61,0,1,2,4),(154,62,0,1,2,4),(154,64,0,1,2,4),(154,66,0,1,2,4),(155,61,0,1,2,4),(155,62,0,1,2,4),(155,64,0,1,2,4),(155,65,0,1,2,4),(155,66,0,1,2,4),(156,61,0,1,2,4),(156,62,0,1,2,4),(156,63,0,1,2,4),(156,64,0,1,2,4),(156,65,0,1,2,4),(156,66,0,1,2,4),(157,61,0,1,2,4),(157,62,0,1,2,4),(157,64,0,1,2,4),(157,65,0,1,2,4),(157,66,0,1,2,4),(158,61,0,1,2,4),(158,63,0,1,2,4),(158,64,0,1,2,4),(158,65,0,1,2,4),(158,66,0,1,2,4),(159,61,0,1,2,4),(159,62,0,1,2,4),(159,63,0,1,2,4),(159,64,0,1,2,4),(159,65,0,1,2,4),(159,66,0,1,2,4),(160,41,0,1,2,4),(160,68,0,1,2,4),(160,69,0,1,2,4),(160,70,0,1,2,4),(160,72,0,1,2,4),(160,73,0,1,2,4),(161,68,0,1,2,4),(161,69,0,1,2,4),(161,70,0,1,2,4),(161,71,0,1,2,4),(161,72,0,1,2,4),(162,68,0,1,2,4),(162,69,0,1,2,4),(162,72,0,1,2,4),(164,41,0,1,2,4),(164,70,0,1,2,4),(164,73,0,1,2,4),(166,41,0,1,2,4),(166,70,0,1,2,4),(166,73,0,1,2,4),(167,68,0,1,2,4),(167,69,0,1,2,4),(167,72,0,1,2,4),(168,71,0,1,2,4),(169,70,0,1,2,4),(171,70,0,1,2,4),(172,1,10000,0,2,4),(172,2,10000,0,2,4),(172,3,10000,0,2,4),(172,4,10000,0,2,4),(172,5,10000,0,2,4),(172,6,10000,0,2,4),(172,7,10000,0,2,4),(172,8,10000,0,2,4),(172,9,10000,0,2,4),(172,10,10000,0,2,4),(172,11,10000,0,2,4),(172,12,10000,0,2,4),(172,13,10000,0,2,4),(172,14,10000,0,2,4),(172,15,10000,0,2,4),(172,16,10000,0,2,4),(172,17,10000,0,2,4),(172,18,10000,0,2,4),(172,19,10000,0,2,4),(172,20,10000,0,2,4),(172,21,10000,0,2,4),(172,22,10000,0,2,4),(172,23,10000,0,2,4),(172,24,10000,0,2,4),(172,25,10000,0,2,4),(172,26,10000,0,2,4),(172,27,10000,0,2,4),(172,28,10000,0,2,4),(172,29,10000,0,2,4),(172,30,10000,0,2,4),(173,1,0,1,2,4),(173,2,0,1,2,4),(173,3,0,1,2,4),(173,4,0,1,2,4),(173,5,0,1,2,4),(173,6,0,1,2,4),(173,7,0,1,2,4),(173,8,0,1,2,4),(173,9,0,1,2,4),(173,10,0,1,2,4),(173,11,0,1,2,4),(173,12,0,1,2,4),(173,13,0,1,2,4),(173,14,0,1,2,4),(173,15,0,1,2,4),(173,16,0,1,2,4),(173,17,0,1,2,4),(173,18,0,1,2,4),(173,19,0,1,2,4),(173,20,0,1,2,4),(173,21,0,1,2,4),(173,22,0,1,2,4),(173,23,0,1,2,4),(173,24,0,1,2,4),(173,25,0,1,2,4),(173,26,0,1,2,4),(173,27,0,1,2,4),(173,28,0,1,2,4),(173,29,0,1,2,4),(173,30,0,1,2,4),(174,1,0,1,2,4),(174,2,0,1,2,4),(174,3,0,1,2,4),(174,4,0,1,2,4),(174,5,0,1,2,4),(174,6,0,1,2,4),(174,7,0,1,2,4),(174,8,0,1,2,4),(174,9,0,1,2,4),(174,10,0,1,2,4),(174,11,0,1,2,4),(174,12,0,1,2,4),(174,13,0,1,2,4),(174,14,0,1,2,4),(174,15,0,1,2,4),(174,16,0,1,2,4),(174,17,0,1,2,4),(174,18,0,1,2,4),(174,19,0,1,2,4),(174,20,0,1,2,4),(174,21,0,1,2,4),(174,22,0,1,2,4),(174,23,0,1,2,4),(174,24,0,1,2,4),(174,25,0,1,2,4),(174,26,0,1,2,4),(174,27,0,1,2,4),(174,28,0,1,2,4),(174,29,0,1,2,4),(174,30,0,1,2,4),(175,1,0,1,2,4),(175,2,0,1,2,4),(175,3,0,1,2,4),(175,4,0,1,2,4),(175,5,0,1,2,4),(175,6,0,1,2,4),(175,7,0,1,2,4),(175,8,0,1,2,4),(175,9,0,1,2,4),(175,10,0,1,2,4),(175,11,0,1,2,4),(175,12,0,1,2,4),(175,13,0,1,2,4),(175,14,0,1,2,4),(175,15,0,1,2,4),(175,16,0,1,2,4),(175,17,0,1,2,4),(175,18,0,1,2,4),(175,19,0,1,2,4),(175,20,0,1,2,4),(175,21,0,1,2,4),(175,22,0,1,2,4),(175,23,0,1,2,4),(175,24,0,1,2,4),(175,25,0,1,2,4),(175,26,0,1,2,4),(175,27,0,1,2,4),(175,28,0,1,2,4),(175,29,0,1,2,4),(175,30,0,1,2,4),(176,1,0,1,2,4),(176,2,0,1,2,4),(176,3,0,1,2,4),(176,4,0,1,2,4),(176,5,0,1,2,4),(176,6,0,1,2,4),(176,7,0,1,2,4),(176,8,0,1,2,4),(176,9,0,1,2,4),(176,10,0,1,2,4),(176,11,0,1,2,4),(176,12,0,1,2,4),(176,13,0,1,2,4),(176,14,0,1,2,4),(176,15,0,1,2,4),(176,16,0,1,2,4),(176,17,0,1,2,4),(176,18,0,1,2,4),(176,19,0,1,2,4),(176,20,0,1,2,4),(176,21,0,1,2,4),(176,22,0,1,2,4),(176,23,0,1,2,4),(176,24,0,1,2,4),(176,25,0,1,2,4),(176,26,0,1,2,4),(176,27,0,1,2,4),(176,28,0,1,2,4),(176,29,0,1,2,4),(176,30,0,1,2,4),(177,74,0,1,2,4),(177,75,0,1,2,4),(177,76,0,1,2,4),(177,77,0,1,2,4),(177,78,0,1,2,4),(177,79,0,1,2,4),(177,80,0,1,2,4),(178,74,10000,0,2,4),(178,75,10000,0,2,4),(178,76,10000,0,2,4),(178,77,10000,0,2,4),(178,78,10000,0,2,4),(178,79,10000,0,2,4),(178,80,10000,0,2,4),(178,81,10000,0,2,4),(178,82,10000,0,2,4),(178,83,10000,0,2,4),(178,84,10000,0,2,4),(178,85,10000,0,2,4),(178,86,10000,0,2,4),(178,87,10000,0,2,4),(178,88,10000,0,2,4),(178,113,10000,0,2,4),(178,114,10000,0,2,4),(178,115,10000,0,2,4),(178,116,10000,0,2,4),(178,117,10000,0,2,4),(178,118,10000,0,2,4),(178,119,10000,0,2,4),(178,120,10000,0,2,4),(178,121,10000,0,2,4),(178,122,10000,0,2,4),(178,123,10000,0,2,4),(178,124,10000,0,2,4),(178,125,10000,0,2,4),(178,126,10000,0,2,4),(178,127,10000,0,2,4),(178,128,10000,0,2,4),(178,129,10000,0,2,4),(178,130,10000,0,2,4),(178,131,10000,0,2,4),(178,132,10000,0,2,4),(178,133,10000,0,2,4),(178,134,10000,0,2,4),(178,135,10000,0,2,4),(178,136,10000,0,2,4),(178,137,10000,0,2,4),(178,138,10000,0,2,4),(178,139,10000,0,2,4),(178,140,10000,0,2,4),(178,141,10000,0,2,4),(178,142,10000,0,2,4),(178,143,10000,0,2,4),(178,144,10000,0,2,4),(178,145,10000,0,2,4),(178,146,10000,0,2,4),(178,147,10000,0,2,4),(178,148,10000,0,2,4),(178,149,10000,0,2,4),(178,150,10000,0,2,4),(178,151,10000,0,2,4),(178,152,10000,0,2,4),(178,153,10000,0,2,4),(178,154,10000,0,2,4),(178,155,10000,0,2,4),(178,156,10000,0,2,4),(178,157,10000,0,2,4),(178,158,10000,0,2,4),(178,159,10000,0,2,4),(178,160,10000,0,2,4),(178,161,10000,0,2,4),(178,162,10000,0,2,4),(178,163,10000,0,2,4),(178,164,10000,0,2,4),(178,165,10000,0,2,4),(178,166,10000,0,2,4),(178,167,10000,0,2,4),(178,168,10000,0,2,4),(178,169,10000,0,2,4),(178,170,10000,0,2,4),(178,171,10000,0,2,4),(178,172,10000,0,2,4),(178,173,10000,0,2,4),(178,174,10000,0,2,4),(178,175,10000,0,2,4),(178,176,10000,0,2,4),(178,177,10000,0,2,4),(178,178,10000,0,2,4),(178,179,10000,0,2,4),(178,180,10000,0,2,4),(178,181,10000,0,2,4),(178,182,10000,0,2,4),(178,183,10000,0,2,4),(178,184,10000,0,2,4),(178,185,10000,0,2,4),(178,186,10000,0,2,4),(178,187,10000,0,2,4),(178,188,10000,0,2,4),(178,189,10000,0,2,4),(178,190,10000,0,2,4),(178,191,10000,0,2,4),(178,192,10000,0,2,4),(178,193,10000,0,2,4),(178,194,10000,0,2,4),(178,195,10000,0,2,4),(178,196,10000,0,2,4),(178,197,10000,0,2,4),(178,198,10000,0,2,4),(178,199,10000,0,2,4),(178,200,10000,0,2,4),(178,201,10000,0,2,4),(178,202,10000,0,2,4),(178,203,10000,0,2,4),(178,204,10000,0,2,4),(178,205,10000,0,2,4),(178,206,10000,0,2,4),(178,207,10000,0,2,4),(178,208,10000,0,2,4),(178,209,10000,0,2,4),(178,210,10000,0,2,4),(178,211,10000,0,2,4),(178,212,10000,0,2,4),(178,213,10000,0,2,4),(178,214,10000,0,2,4),(178,215,10000,0,2,4),(178,216,10000,0,2,4),(178,217,10000,0,2,4),(178,218,10000,0,2,4),(178,219,10000,0,2,4),(178,220,10000,0,2,4),(178,221,10000,0,2,4),(178,222,10000,0,2,4),(178,223,10000,0,2,4),(178,224,10000,0,2,4),(178,225,10000,0,2,4),(178,226,10000,0,2,4),(178,227,10000,0,2,4),(178,228,10000,0,2,4),(178,229,10000,0,2,4),(178,230,10000,0,2,4),(178,231,10000,0,2,4),(178,232,10000,0,2,4),(178,233,10000,0,2,4),(178,234,10000,0,2,4),(178,235,10000,0,2,4),(178,236,10000,0,2,4),(178,237,10000,0,2,4),(178,238,10000,0,2,4),(178,239,10000,0,2,4),(178,240,10000,0,2,4),(178,241,10000,0,2,4),(178,244,10000,0,2,4),(178,246,10000,0,2,4),(178,251,10000,0,2,4),(178,255,10000,0,2,4),(178,258,10000,0,2,4),(178,259,10000,0,2,4),(178,260,10000,0,2,4),(178,261,10000,0,2,4),(178,262,10000,0,2,4),(178,263,10000,0,2,4),(179,81,0,1,2,4),(179,82,0,1,2,4),(179,83,0,1,2,4),(179,84,0,1,2,4),(179,85,0,1,2,4),(179,86,0,1,2,4),(179,87,0,1,2,4),(179,88,0,1,2,4),(180,81,0,1,2,4),(181,86,0,1,2,4),(182,82,0,1,2,4),(182,83,0,1,2,4),(182,84,0,1,2,4),(182,85,0,1,2,4),(182,87,0,1,2,4),(182,88,0,1,2,4),(183,82,0,1,2,4),(183,83,0,1,2,4),(183,84,0,1,2,4),(183,85,0,1,2,4),(183,86,0,1,2,4),(183,87,0,1,2,4),(183,88,0,1,2,4),(192,89,0,1,2,4),(192,90,0,1,2,4),(192,91,0,1,2,4),(192,92,0,1,2,4),(192,93,0,1,2,4),(192,94,0,1,2,4),(193,95,0,1,2,4),(193,96,0,1,2,4),(193,97,0,1,2,4),(193,98,0,1,2,4),(193,99,0,1,2,4),(193,100,0,1,2,4),(194,95,0,1,2,4),(194,96,0,1,2,4),(194,97,0,1,2,4),(194,98,0,1,2,4),(194,99,0,1,2,4),(194,100,0,1,2,4),(195,95,0,1,2,4),(195,96,0,1,2,4),(195,97,0,1,2,4),(195,98,0,1,2,4),(195,99,0,1,2,4),(195,100,0,1,2,4),(196,95,0,1,2,4),(196,96,0,1,2,4),(196,97,0,1,2,4),(196,98,0,1,2,4),(196,99,0,1,2,4),(196,100,0,1,2,4),(197,95,0,1,2,4),(197,96,0,1,2,4),(197,97,0,1,2,4),(197,98,0,1,2,4),(197,99,0,1,2,4),(197,100,0,1,2,4),(198,101,0,1,2,4),(198,109,0,1,2,4),(198,111,0,1,2,4),(198,112,0,1,2,4),(199,103,0,1,2,4),(199,110,0,1,2,4),(200,101,0,1,2,4),(200,102,0,1,2,4),(200,108,0,1,2,4),(201,104,0,1,2,4),(201,106,0,1,2,4),(202,101,0,1,2,4),(202,102,0,1,2,4),(202,103,0,1,2,4),(202,105,0,1,2,4),(202,107,0,1,2,4),(202,108,0,1,2,4),(202,110,0,1,2,4),(203,101,0,1,2,4),(203,102,0,1,2,4),(203,103,0,1,2,4),(203,104,0,1,2,4),(203,106,0,1,2,4),(203,108,0,1,2,4),(203,109,0,1,2,4),(204,101,0,1,2,4),(204,102,0,1,2,4),(204,103,0,1,2,4),(204,104,0,1,2,4),(204,105,0,1,2,4),(204,106,0,1,2,4),(204,107,0,1,2,4),(204,108,0,1,2,4),(205,101,0,1,2,4),(205,102,0,1,2,4),(205,103,0,1,2,4),(205,108,0,1,2,4),(205,109,0,1,2,4),(205,110,0,1,2,4),(205,111,0,1,2,4),(205,112,0,1,2,4),(206,113,10000,0,2,4),(206,114,10000,0,2,4),(206,115,10000,0,2,4),(206,116,10000,0,2,4),(206,117,10000,0,2,4),(206,118,10000,0,2,4),(206,119,10000,0,2,4),(207,114,0,1,2,4),(207,119,0,1,2,4),(209,114,0,1,2,4),(212,116,0,1,2,4),(212,118,0,1,2,4),(213,113,0,1,2,4),(218,117,0,1,2,4),(219,119,0,1,2,4),(220,119,0,1,2,4),(221,119,0,1,2,4),(222,114,0,1,2,4),(222,119,0,1,2,4),(223,114,0,1,2,4),(223,119,0,1,2,4),(229,113,0,1,2,4),(230,113,0,1,2,4),(231,113,0,1,2,4),(232,113,0,1,2,4),(233,113,0,1,2,4),(234,116,0,1,2,4),(234,118,0,1,2,4),(235,116,0,1,2,4),(235,118,0,1,2,4),(236,116,0,1,2,4),(236,118,0,1,2,4),(237,116,0,1,2,4),(237,118,0,1,2,4),(238,116,0,1,2,4),(238,118,0,1,2,4),(239,115,0,1,2,4),(241,115,0,1,2,4),(242,115,0,1,2,4),(243,115,0,1,2,4),(250,120,0,1,2,4),(250,121,0,1,2,4),(250,122,0,1,2,4),(250,123,0,1,2,4),(250,124,0,1,2,4),(250,125,0,1,2,4),(250,126,0,1,2,4),(250,127,0,1,2,4),(250,128,0,1,2,4),(250,129,0,1,2,4),(250,130,0,1,2,4),(250,131,0,1,2,4),(251,120,0,1,2,4),(251,121,0,1,2,4),(251,122,0,1,2,4),(251,123,0,1,2,4),(251,124,0,1,2,4),(251,125,0,1,2,4),(251,126,0,1,2,4),(251,127,0,1,2,4),(251,128,0,1,2,4),(251,129,0,1,2,4),(251,130,0,1,2,4),(251,131,0,1,2,4),(252,125,10000,0,2,4),(252,126,10000,0,2,4),(252,127,10000,0,2,4),(252,120,0,1,2,4),(252,121,0,1,2,4),(252,122,0,1,2,4),(252,123,0,1,2,4),(252,124,0,1,2,4),(252,128,0,1,2,4),(252,129,0,1,2,4),(252,131,0,1,2,4),(253,120,0,1,2,4),(253,121,0,1,2,4),(253,122,0,1,2,4),(253,123,0,1,2,4),(253,124,0,1,2,4),(253,125,0,1,2,4),(253,126,0,1,2,4),(253,127,0,1,2,4),(253,128,0,1,2,4),(253,129,0,1,2,4),(253,130,0,1,2,4),(253,131,0,1,2,4),(254,120,0,1,2,4),(254,121,0,1,2,4),(254,122,0,1,2,4),(254,123,0,1,2,4),(254,124,0,1,2,4),(254,125,0,1,2,4),(254,126,0,1,2,4),(254,127,0,1,2,4),(254,128,0,1,2,4),(254,129,0,1,2,4),(254,130,0,1,2,4),(254,131,0,1,2,4),(255,122,0,1,2,4),(255,123,0,1,2,4),(255,124,0,1,2,4),(255,125,0,1,2,4),(255,126,0,1,2,4),(255,129,0,1,2,4),(256,121,0,1,2,4),(256,122,0,1,2,4),(256,123,0,1,2,4),(256,125,0,1,2,4),(256,126,0,1,2,4),(256,127,0,1,2,4),(257,121,0,1,2,4),(257,122,0,1,2,4),(257,123,0,1,2,4),(257,125,0,1,2,4),(257,127,0,1,2,4),(257,129,0,1,2,4),(258,121,0,1,2,4),(258,122,0,1,2,4),(258,125,0,1,2,4),(258,126,0,1,2,4),(258,127,0,1,2,4),(258,129,0,1,2,4),(259,120,0,1,2,4),(259,121,0,1,2,4),(259,123,0,1,2,4),(259,128,0,1,2,4),(259,129,0,1,2,4),(260,120,0,1,2,4),(260,121,0,1,2,4),(260,122,0,1,2,4),(260,123,0,1,2,4),(260,125,0,1,2,4),(260,127,0,1,2,4),(260,128,0,1,2,4),(260,129,0,1,2,4),(261,121,0,1,2,4),(261,122,0,1,2,4),(261,125,0,1,2,4),(261,126,0,1,2,4),(261,127,0,1,2,4),(261,129,0,1,2,4),(262,125,0,1,2,4),(262,126,0,1,2,4),(263,120,0,1,2,4),(263,121,0,1,2,4),(263,122,0,1,2,4),(263,123,0,1,2,4),(263,124,0,1,2,4),(263,128,0,1,2,4),(263,129,0,1,2,4),(263,131,0,1,2,4),(264,120,0,1,2,4),(264,122,0,1,2,4),(264,123,0,1,2,4),(264,125,0,1,2,4),(264,126,0,1,2,4),(264,129,0,1,2,4),(265,121,0,1,2,4),(265,122,0,1,2,4),(265,123,0,1,2,4),(265,127,0,1,2,4),(266,123,0,1,2,4),(266,125,0,1,2,4),(266,126,0,1,2,4),(266,127,0,1,2,4),(266,129,0,1,2,4),(267,121,0,1,2,4),(267,125,0,1,2,4),(267,126,0,1,2,4),(267,127,0,1,2,4),(268,120,0,1,2,4),(268,121,0,1,2,4),(268,122,0,1,2,4),(268,123,0,1,2,4),(268,124,0,1,2,4),(268,127,0,1,2,4),(268,129,0,1,2,4),(269,122,0,1,2,4),(269,125,0,1,2,4),(269,126,0,1,2,4),(269,127,0,1,2,4),(269,129,0,1,2,4),(270,121,0,1,2,4),(270,123,0,1,2,4),(270,125,0,1,2,4),(270,126,0,1,2,4),(270,129,0,1,2,4),(271,120,0,1,2,4),(271,121,0,1,2,4),(271,122,0,1,2,4),(271,125,0,1,2,4),(271,126,0,1,2,4),(271,127,0,1,2,4),(271,129,0,1,2,4),(272,122,0,1,2,4),(272,123,0,1,2,4),(272,124,0,1,2,4),(272,125,0,1,2,4),(272,126,0,1,2,4),(272,127,0,1,2,4),(272,128,0,1,2,4),(272,129,0,1,2,4),(273,120,0,1,2,4),(273,121,0,1,2,4),(273,123,0,1,2,4),(273,126,0,1,2,4),(273,127,0,1,2,4),(274,122,0,1,2,4),(274,123,0,1,2,4),(274,125,0,1,2,4),(274,126,0,1,2,4),(274,129,0,1,2,4),(275,120,0,1,2,4),(275,121,0,1,2,4),(275,122,0,1,2,4),(275,123,0,1,2,4),(275,124,0,1,2,4),(275,125,0,1,2,4),(275,126,0,1,2,4),(275,127,0,1,2,4),(275,128,0,1,2,4),(275,129,0,1,2,4),(275,130,0,1,2,4),(275,131,0,1,2,4),(276,122,0,1,2,4),(276,123,0,1,2,4),(276,127,0,1,2,4),(276,129,0,1,2,4),(277,120,0,1,2,4),(277,121,0,1,2,4),(277,123,0,1,2,4),(277,124,0,1,2,4),(277,125,0,1,2,4),(277,126,0,1,2,4),(277,127,0,1,2,4),(278,120,0,1,2,4),(278,121,0,1,2,4),(278,122,0,1,2,4),(278,123,0,1,2,4),(278,124,0,1,2,4),(278,125,0,1,2,4),(278,127,0,1,2,4),(278,128,0,1,2,4),(278,129,0,1,2,4),(279,120,0,1,2,4),(279,122,0,1,2,4),(279,126,0,1,2,4),(279,127,0,1,2,4),(279,129,0,1,2,4),(280,132,0,1,2,4),(280,133,0,1,2,4),(280,134,0,1,2,4),(280,135,0,1,2,4),(280,136,0,1,2,4),(280,137,0,1,2,4),(280,138,0,1,2,4),(280,139,0,1,2,4),(282,132,0,1,2,4),(282,133,0,1,2,4),(282,134,0,1,2,4),(282,137,0,1,2,4),(282,138,0,1,2,4),(283,135,0,1,2,4),(283,136,0,1,2,4),(283,139,0,1,2,4),(286,140,0,1,2,4),(286,141,0,1,2,4),(286,142,0,1,2,4),(286,143,0,1,2,4),(286,144,0,1,2,4),(286,145,0,1,2,4),(286,146,0,1,2,4),(286,147,0,1,2,4),(286,148,0,1,2,4),(286,149,0,1,2,4),(286,150,0,1,2,4),(286,151,0,1,2,4),(286,152,0,1,2,4),(286,153,0,1,2,4),(286,154,0,1,2,4),(286,155,0,1,2,4),(286,156,0,1,2,4),(286,157,0,1,2,4),(286,158,0,1,2,4),(286,159,0,1,2,4),(286,160,0,1,2,4),(286,161,0,1,2,4),(286,162,0,1,2,4),(286,163,0,1,2,4),(286,164,0,1,2,4),(286,165,0,1,2,4),(286,166,0,1,2,4),(286,167,0,1,2,4),(286,168,0,1,2,4),(286,169,0,1,2,4),(286,170,0,1,2,4),(286,171,0,1,2,4),(286,172,0,1,2,4),(286,173,0,1,2,4),(286,174,0,1,2,4),(286,175,0,1,2,4),(286,176,0,1,2,4),(286,177,0,1,2,4),(286,178,0,1,2,4),(286,179,0,1,2,4),(286,180,0,1,2,4),(286,181,0,1,2,4),(286,182,0,1,2,4),(286,183,0,1,2,4),(286,184,0,1,2,4),(286,185,0,1,2,4),(286,186,0,1,2,4),(286,187,0,1,2,4),(287,188,0,1,2,4),(288,189,0,1,2,4),(288,190,0,1,2,4),(288,191,0,1,2,4),(288,192,0,1,2,4),(288,193,0,1,2,4),(288,194,0,1,2,4),(288,195,0,1,2,4),(288,196,0,1,2,4),(288,197,0,1,2,4),(288,198,0,1,2,4),(288,199,0,1,2,4),(288,200,0,1,2,4),(289,201,10000,0,2,4),(289,202,10000,0,2,4),(289,203,10000,0,2,4),(289,204,10000,0,2,4),(289,205,10000,0,2,4),(289,206,10000,0,2,4),(289,207,10000,0,2,4),(289,208,10000,0,2,4),(289,209,10000,0,2,4),(289,210,10000,0,2,4),(289,211,10000,0,2,4),(289,212,10000,0,2,4),(289,213,10000,0,2,4),(289,214,10000,0,2,4),(289,215,10000,0,2,4),(289,216,10000,0,2,4),(289,217,10000,0,2,4),(289,218,10000,0,2,4),(289,219,10000,0,2,4),(289,220,10000,0,2,4),(289,221,10000,0,2,4),(289,222,10000,0,2,4),(289,223,10000,0,2,4),(289,224,10000,0,2,4),(289,225,10000,0,2,4),(289,226,10000,0,2,4),(289,227,10000,0,2,4),(289,228,10000,0,2,4),(289,229,10000,0,2,4),(289,230,10000,0,2,4),(289,231,10000,0,2,4),(289,232,10000,0,2,4),(289,244,10000,0,2,4),(289,246,10000,0,2,4),(289,251,10000,0,2,4),(289,255,10000,0,2,4),(289,258,10000,0,2,4),(289,259,10000,0,2,4),(289,260,10000,0,2,4),(289,261,10000,0,2,4),(289,262,10000,0,2,4),(289,263,10000,0,2,4),(290,209,0,1,2,4),(290,210,0,1,2,4),(290,211,0,1,2,4),(290,212,0,1,2,4),(290,213,0,1,2,4),(290,214,0,1,2,4),(290,215,0,1,2,4),(290,216,0,1,2,4),(291,201,0,1,2,4),(291,202,0,1,2,4),(291,203,0,1,2,4),(291,204,0,1,2,4),(291,205,0,1,2,4),(291,206,0,1,2,4),(291,207,0,1,2,4),(291,208,0,1,2,4),(292,217,0,1,2,4),(292,218,0,1,2,4),(292,219,0,1,2,4),(292,220,0,1,2,4),(292,221,0,1,2,4),(292,222,0,1,2,4),(292,223,0,1,2,4),(292,224,0,1,2,4),(293,225,0,1,2,4),(293,226,0,1,2,4),(293,227,0,1,2,4),(293,228,0,1,2,4),(293,229,0,1,2,4),(293,230,0,1,2,4),(293,231,0,1,2,4),(293,232,0,1,2,4),(293,255,0,1,2,4),(293,259,0,1,2,4),(293,260,0,1,2,4),(293,261,0,1,2,4),(293,262,0,1,2,4),(293,263,0,1,2,4),(294,233,0,1,2,4),(294,234,0,1,2,4),(294,235,0,1,2,4),(294,236,0,1,2,4),(294,237,0,1,2,4),(294,238,0,1,2,4),(294,239,0,1,2,4),(294,240,0,1,2,4),(294,241,0,1,2,4),(295,244,0,1,2,4),(295,246,0,1,2,4),(295,251,0,1,2,4),(295,255,0,1,2,4),(295,258,0,1,2,4),(296,251,0,1,2,4),(296,255,0,1,2,4),(296,258,0,1,2,4),(297,246,0,1,2,4),(297,255,0,1,2,4),(297,258,0,1,2,4),(298,255,0,1,2,4),(298,258,0,1,2,4),(299,251,0,1,2,4),(299,258,0,1,2,4);
/*!40000 ALTER TABLE `catalog_category_product_index_store2` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index_store20`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store20`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store20` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `CAT_CTGR_PRD_IDX_STORE20_PRD_ID_STORE_ID_CTGR_ID_VISIBILITY` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_A188CA2B301606E2B15DB75055D75EA8` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Product Index Store20';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index_store20`
--

LOCK TABLES `catalog_category_product_index_store20` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index_store20` DISABLE KEYS */;
INSERT INTO `catalog_category_product_index_store20` VALUES (2,1,0,1,20,4),(2,2,0,1,20,4),(2,3,0,1,20,4),(2,4,0,1,20,4),(2,5,0,1,20,4),(2,6,0,1,20,4),(2,7,0,1,20,4),(2,8,0,1,20,4),(2,9,0,1,20,4),(2,10,0,1,20,4),(2,11,0,1,20,4),(2,12,0,1,20,4),(2,13,0,1,20,4),(2,14,0,1,20,4),(2,15,0,1,20,4),(2,16,0,1,20,4),(2,17,0,1,20,4),(2,18,0,1,20,4),(2,19,0,1,20,4),(2,20,0,1,20,4),(2,21,0,1,20,4),(2,22,0,1,20,4),(2,23,0,1,20,4),(2,24,0,1,20,4),(2,25,0,1,20,4),(2,26,0,1,20,4),(2,27,0,1,20,4),(2,28,0,1,20,4),(2,29,0,1,20,4),(2,30,0,1,20,4),(2,31,0,1,20,4),(2,32,0,1,20,4),(2,33,0,1,20,4),(2,34,0,1,20,4),(2,35,0,1,20,4),(2,36,0,1,20,4),(2,37,0,1,20,4),(2,38,0,1,20,4),(2,39,0,1,20,4),(2,40,0,1,20,4),(2,41,0,1,20,4),(2,42,0,1,20,4),(2,43,0,1,20,4),(2,44,0,1,20,4),(2,45,0,1,20,4),(2,46,0,1,20,4),(2,47,0,1,20,4),(2,48,0,1,20,4),(2,49,0,1,20,4),(2,50,0,1,20,4),(2,57,0,1,20,4),(2,58,0,1,20,4),(2,59,0,1,20,4),(2,60,0,1,20,4),(2,61,0,1,20,4),(2,62,0,1,20,4),(2,63,0,1,20,4),(2,64,0,1,20,4),(2,65,0,1,20,4),(2,66,0,1,20,4),(2,68,0,1,20,4),(2,69,0,1,20,4),(2,70,0,1,20,4),(2,71,0,1,20,4),(2,72,0,1,20,4),(2,73,0,1,20,4),(2,74,0,1,20,4),(2,75,0,1,20,4),(2,76,0,1,20,4),(2,77,0,1,20,4),(2,78,0,1,20,4),(2,79,0,1,20,4),(2,80,0,1,20,4),(2,81,0,1,20,4),(2,82,0,1,20,4),(2,83,0,1,20,4),(2,84,0,1,20,4),(2,85,0,1,20,4),(2,86,0,1,20,4),(2,87,0,1,20,4),(2,88,0,1,20,4),(2,89,0,1,20,4),(2,90,0,1,20,4),(2,91,0,1,20,4),(2,92,0,1,20,4),(2,93,0,1,20,4),(2,94,0,1,20,4),(2,95,0,1,20,4),(2,96,0,1,20,4),(2,97,0,1,20,4),(2,98,0,1,20,4),(2,99,0,1,20,4),(2,100,0,1,20,4),(2,101,0,1,20,4),(2,102,0,1,20,4),(2,103,0,1,20,4),(2,104,0,1,20,4),(2,105,0,1,20,4),(2,106,0,1,20,4),(2,107,0,1,20,4),(2,108,0,1,20,4),(2,109,0,1,20,4),(2,110,0,1,20,4),(2,111,0,1,20,4),(2,112,0,1,20,4),(2,113,0,1,20,4),(2,114,0,1,20,4),(2,115,0,1,20,4),(2,116,0,1,20,4),(2,117,0,1,20,4),(2,118,0,1,20,4),(2,119,0,1,20,4),(2,120,0,1,20,4),(2,121,0,1,20,4),(2,122,0,1,20,4),(2,123,0,1,20,4),(2,124,0,1,20,4),(2,125,0,1,20,4),(2,126,0,1,20,4),(2,127,0,1,20,4),(2,128,0,1,20,4),(2,129,0,1,20,4),(2,130,0,1,20,4),(2,131,0,1,20,4),(2,132,0,1,20,4),(2,133,0,1,20,4),(2,134,0,1,20,4),(2,135,0,1,20,4),(2,136,0,1,20,4),(2,137,0,1,20,4),(2,138,0,1,20,4),(2,139,0,1,20,4),(2,140,0,1,20,4),(2,141,0,1,20,4),(2,142,0,1,20,4),(2,143,0,1,20,4),(2,144,0,1,20,4),(2,145,0,1,20,4),(2,146,0,1,20,4),(2,147,0,1,20,4),(2,148,0,1,20,4),(2,149,0,1,20,4),(2,150,0,1,20,4),(2,151,0,1,20,4),(2,152,0,1,20,4),(2,153,0,1,20,4),(2,154,0,1,20,4),(2,155,0,1,20,4),(2,156,0,1,20,4),(2,157,0,1,20,4),(2,158,0,1,20,4),(2,159,0,1,20,4),(2,160,0,1,20,4),(2,161,0,1,20,4),(2,162,0,1,20,4),(2,163,0,1,20,4),(2,164,0,1,20,4),(2,165,0,1,20,4),(2,166,0,1,20,4),(2,167,0,1,20,4),(2,168,0,1,20,4),(2,169,0,1,20,4),(2,170,0,1,20,4),(2,171,0,1,20,4),(2,172,0,1,20,4),(2,173,0,1,20,4),(2,174,0,1,20,4),(2,175,0,1,20,4),(2,176,0,1,20,4),(2,177,0,1,20,4),(2,178,0,1,20,4),(2,179,0,1,20,4),(2,180,0,1,20,4),(2,181,0,1,20,4),(2,182,0,1,20,4),(2,183,0,1,20,4),(2,184,0,1,20,4),(2,185,0,1,20,4),(2,186,0,1,20,4),(2,187,0,1,20,4),(2,188,0,1,20,4),(2,189,0,1,20,4),(2,190,0,1,20,4),(2,191,0,1,20,4),(2,192,0,1,20,4),(2,193,0,1,20,4),(2,194,0,1,20,4),(2,195,0,1,20,4),(2,196,0,1,20,4),(2,197,0,1,20,4),(2,198,0,1,20,4),(2,199,0,1,20,4),(2,200,0,1,20,4),(2,201,0,1,20,4),(2,202,0,1,20,4),(2,203,0,1,20,4),(2,204,0,1,20,4),(2,205,0,1,20,4),(2,206,0,1,20,4),(2,207,0,1,20,4),(2,208,0,1,20,4),(2,209,0,1,20,4),(2,210,0,1,20,4),(2,211,0,1,20,4),(2,212,0,1,20,4),(2,213,0,1,20,4),(2,214,0,1,20,4),(2,215,0,1,20,4),(2,216,0,1,20,4),(2,217,0,1,20,4),(2,218,0,1,20,4),(2,219,0,1,20,4),(2,220,0,1,20,4),(2,221,0,1,20,4),(2,222,0,1,20,4),(2,223,0,1,20,4),(2,224,0,1,20,4),(2,225,0,1,20,4),(2,226,0,1,20,4),(2,227,0,1,20,4),(2,228,0,1,20,4),(2,229,0,1,20,4),(2,230,0,1,20,4),(2,231,0,1,20,4),(2,232,0,1,20,4),(2,233,0,1,20,4),(2,234,0,1,20,4),(2,235,0,1,20,4),(2,236,0,1,20,4),(2,237,0,1,20,4),(2,238,0,1,20,4),(2,239,0,1,20,4),(2,240,0,1,20,4),(2,241,0,1,20,4),(2,244,0,1,20,4),(2,246,0,1,20,4),(2,251,0,1,20,4),(2,255,0,1,20,4),(2,258,0,1,20,4),(2,259,0,1,20,4),(2,260,0,1,20,4),(2,261,0,1,20,4),(2,262,0,1,20,4),(2,263,0,1,20,4),(3,1,0,1,20,4),(3,2,0,1,20,4),(3,3,0,1,20,4),(3,4,0,1,20,4),(3,5,0,1,20,4),(3,6,0,1,20,4),(3,7,0,1,20,4),(3,8,0,1,20,4),(3,10,0,1,20,4),(3,11,0,1,20,4),(4,12,0,1,20,4),(4,13,0,1,20,4),(4,14,0,1,20,4),(4,15,0,1,20,4),(4,16,0,1,20,4),(4,17,0,1,20,4),(4,18,0,1,20,4),(4,19,0,1,20,4),(4,36,0,1,20,4),(4,37,0,1,20,4),(4,38,0,1,20,4),(4,39,0,1,20,4),(4,40,0,1,20,4),(5,95,10000,0,20,4),(5,96,10000,0,20,4),(5,97,10000,0,20,4),(5,98,10000,0,20,4),(5,99,10000,0,20,4),(5,100,10000,0,20,4),(7,101,10000,0,20,4),(7,102,10000,0,20,4),(7,103,10000,0,20,4),(7,104,10000,0,20,4),(7,105,10000,0,20,4),(7,106,10000,0,20,4),(7,107,10000,0,20,4),(7,108,10000,0,20,4),(7,109,10000,0,20,4),(7,110,10000,0,20,4),(7,111,10000,0,20,4),(7,112,10000,0,20,4),(7,21,0,1,20,4),(7,22,0,1,20,4),(7,26,0,1,20,4),(8,61,0,1,20,4),(8,62,0,1,20,4),(8,63,0,1,20,4),(8,64,0,1,20,4),(8,65,0,1,20,4),(8,66,0,1,20,4),(11,4,10000,0,20,4),(11,89,10000,0,20,4),(11,90,10000,0,20,4),(11,91,10000,0,20,4),(11,92,10000,0,20,4),(11,93,10000,0,20,4),(11,94,10000,0,20,4),(11,28,0,1,20,4),(11,29,0,1,20,4),(11,30,0,1,20,4),(11,31,0,1,20,4),(11,32,0,1,20,4),(11,33,0,1,20,4),(11,34,0,1,20,4),(11,35,0,1,20,4),(13,21,0,1,20,4),(13,24,0,1,20,4),(13,25,0,1,20,4),(13,26,0,1,20,4),(13,27,0,1,20,4),(13,41,0,1,20,4),(13,42,0,1,20,4),(13,43,0,1,20,4),(13,44,0,1,20,4),(13,45,0,1,20,4),(13,46,0,1,20,4),(13,47,0,1,20,4),(13,48,0,1,20,4),(13,49,0,1,20,4),(15,22,10000,0,20,4),(15,23,10000,0,20,4),(16,20,0,1,20,4),(16,21,0,1,20,4),(16,22,0,1,20,4),(16,23,0,1,20,4),(16,24,0,1,20,4),(16,25,0,1,20,4),(16,26,0,1,20,4),(16,27,0,1,20,4),(16,41,0,1,20,4),(16,68,0,1,20,4),(16,69,0,1,20,4),(16,70,0,1,20,4),(16,71,0,1,20,4),(16,72,0,1,20,4),(16,73,0,1,20,4),(19,6,0,1,20,4),(19,7,0,1,20,4),(19,8,0,1,20,4),(19,10,0,1,20,4),(19,11,0,1,20,4),(27,11,0,1,20,4),(29,6,0,1,20,4),(29,8,0,1,20,4),(29,10,0,1,20,4),(30,6,0,1,20,4),(30,10,0,1,20,4),(33,7,0,1,20,4),(33,8,0,1,20,4),(33,10,0,1,20,4),(33,11,0,1,20,4),(42,7,0,1,20,4),(42,8,0,1,20,4),(42,11,0,1,20,4),(78,21,0,1,20,4),(78,26,0,1,20,4),(80,21,0,1,20,4),(80,22,0,1,20,4),(80,26,0,1,20,4),(81,26,0,1,20,4),(82,26,0,1,20,4),(83,26,0,1,20,4),(96,26,0,1,20,4),(97,26,0,1,20,4),(98,21,0,1,20,4),(98,22,0,1,20,4),(98,26,0,1,20,4),(99,18,0,1,20,4),(101,14,0,1,20,4),(101,15,0,1,20,4),(101,16,0,1,20,4),(102,12,0,1,20,4),(102,13,0,1,20,4),(102,14,0,1,20,4),(102,15,0,1,20,4),(102,16,0,1,20,4),(102,17,0,1,20,4),(102,19,0,1,20,4),(102,36,0,1,20,4),(102,37,0,1,20,4),(102,38,0,1,20,4),(102,39,0,1,20,4),(102,40,0,1,20,4),(103,18,0,1,20,4),(104,18,0,1,20,4),(105,18,0,1,20,4),(106,18,0,1,20,4),(107,18,0,1,20,4),(134,23,0,1,20,4),(135,22,0,1,20,4),(137,4,0,1,20,4),(137,28,0,1,20,4),(137,31,0,1,20,4),(137,34,0,1,20,4),(137,35,0,1,20,4),(138,28,0,1,20,4),(138,30,0,1,20,4),(138,32,0,1,20,4),(138,33,0,1,20,4),(139,28,0,1,20,4),(139,30,0,1,20,4),(139,32,0,1,20,4),(139,33,0,1,20,4),(140,28,0,1,20,4),(140,30,0,1,20,4),(140,32,0,1,20,4),(140,33,0,1,20,4),(145,1,0,1,20,4),(145,2,0,1,20,4),(145,3,0,1,20,4),(145,4,0,1,20,4),(145,5,0,1,20,4),(145,6,0,1,20,4),(145,7,0,1,20,4),(145,8,0,1,20,4),(145,9,0,1,20,4),(145,10,0,1,20,4),(145,11,0,1,20,4),(145,12,0,1,20,4),(145,13,0,1,20,4),(145,14,0,1,20,4),(145,15,0,1,20,4),(145,16,0,1,20,4),(145,17,0,1,20,4),(145,18,0,1,20,4),(145,19,0,1,20,4),(145,20,0,1,20,4),(145,21,0,1,20,4),(145,22,0,1,20,4),(145,23,0,1,20,4),(145,24,0,1,20,4),(145,25,0,1,20,4),(145,26,0,1,20,4),(145,27,0,1,20,4),(145,28,0,1,20,4),(145,29,0,1,20,4),(145,30,0,1,20,4),(145,31,0,1,20,4),(145,32,0,1,20,4),(145,33,0,1,20,4),(145,34,0,1,20,4),(145,35,0,1,20,4),(145,36,0,1,20,4),(145,37,0,1,20,4),(145,38,0,1,20,4),(145,39,0,1,20,4),(145,40,0,1,20,4),(145,41,0,1,20,4),(145,42,0,1,20,4),(145,43,0,1,20,4),(149,41,0,1,20,4),(150,50,0,1,20,4),(150,57,0,1,20,4),(150,58,0,1,20,4),(150,59,0,1,20,4),(150,60,0,1,20,4),(151,61,0,1,20,4),(151,62,0,1,20,4),(151,63,0,1,20,4),(151,64,0,1,20,4),(151,65,0,1,20,4),(151,66,0,1,20,4),(152,61,0,1,20,4),(152,63,0,1,20,4),(153,61,0,1,20,4),(153,63,0,1,20,4),(153,64,0,1,20,4),(153,65,0,1,20,4),(153,66,0,1,20,4),(154,61,0,1,20,4),(154,62,0,1,20,4),(154,64,0,1,20,4),(154,66,0,1,20,4),(155,61,0,1,20,4),(155,62,0,1,20,4),(155,64,0,1,20,4),(155,65,0,1,20,4),(155,66,0,1,20,4),(156,61,0,1,20,4),(156,62,0,1,20,4),(156,63,0,1,20,4),(156,64,0,1,20,4),(156,65,0,1,20,4),(156,66,0,1,20,4),(157,61,0,1,20,4),(157,62,0,1,20,4),(157,64,0,1,20,4),(157,65,0,1,20,4),(157,66,0,1,20,4),(158,61,0,1,20,4),(158,63,0,1,20,4),(158,64,0,1,20,4),(158,65,0,1,20,4),(158,66,0,1,20,4),(159,61,0,1,20,4),(159,62,0,1,20,4),(159,63,0,1,20,4),(159,64,0,1,20,4),(159,65,0,1,20,4),(159,66,0,1,20,4),(160,41,0,1,20,4),(160,68,0,1,20,4),(160,69,0,1,20,4),(160,70,0,1,20,4),(160,72,0,1,20,4),(160,73,0,1,20,4),(161,68,0,1,20,4),(161,69,0,1,20,4),(161,70,0,1,20,4),(161,71,0,1,20,4),(161,72,0,1,20,4),(162,68,0,1,20,4),(162,69,0,1,20,4),(162,72,0,1,20,4),(164,41,0,1,20,4),(164,70,0,1,20,4),(164,73,0,1,20,4),(166,41,0,1,20,4),(166,70,0,1,20,4),(166,73,0,1,20,4),(167,68,0,1,20,4),(167,69,0,1,20,4),(167,72,0,1,20,4),(168,71,0,1,20,4),(169,70,0,1,20,4),(171,70,0,1,20,4),(172,1,10000,0,20,4),(172,2,10000,0,20,4),(172,3,10000,0,20,4),(172,4,10000,0,20,4),(172,5,10000,0,20,4),(172,6,10000,0,20,4),(172,7,10000,0,20,4),(172,8,10000,0,20,4),(172,9,10000,0,20,4),(172,10,10000,0,20,4),(172,11,10000,0,20,4),(172,12,10000,0,20,4),(172,13,10000,0,20,4),(172,14,10000,0,20,4),(172,15,10000,0,20,4),(172,16,10000,0,20,4),(172,17,10000,0,20,4),(172,18,10000,0,20,4),(172,19,10000,0,20,4),(172,20,10000,0,20,4),(172,21,10000,0,20,4),(172,22,10000,0,20,4),(172,23,10000,0,20,4),(172,24,10000,0,20,4),(172,25,10000,0,20,4),(172,26,10000,0,20,4),(172,27,10000,0,20,4),(172,28,10000,0,20,4),(172,29,10000,0,20,4),(172,30,10000,0,20,4),(173,1,0,1,20,4),(173,2,0,1,20,4),(173,3,0,1,20,4),(173,4,0,1,20,4),(173,5,0,1,20,4),(173,6,0,1,20,4),(173,7,0,1,20,4),(173,8,0,1,20,4),(173,9,0,1,20,4),(173,10,0,1,20,4),(173,11,0,1,20,4),(173,12,0,1,20,4),(173,13,0,1,20,4),(173,14,0,1,20,4),(173,15,0,1,20,4),(173,16,0,1,20,4),(173,17,0,1,20,4),(173,18,0,1,20,4),(173,19,0,1,20,4),(173,20,0,1,20,4),(173,21,0,1,20,4),(173,22,0,1,20,4),(173,23,0,1,20,4),(173,24,0,1,20,4),(173,25,0,1,20,4),(173,26,0,1,20,4),(173,27,0,1,20,4),(173,28,0,1,20,4),(173,29,0,1,20,4),(173,30,0,1,20,4),(174,1,0,1,20,4),(174,2,0,1,20,4),(174,3,0,1,20,4),(174,4,0,1,20,4),(174,5,0,1,20,4),(174,6,0,1,20,4),(174,7,0,1,20,4),(174,8,0,1,20,4),(174,9,0,1,20,4),(174,10,0,1,20,4),(174,11,0,1,20,4),(174,12,0,1,20,4),(174,13,0,1,20,4),(174,14,0,1,20,4),(174,15,0,1,20,4),(174,16,0,1,20,4),(174,17,0,1,20,4),(174,18,0,1,20,4),(174,19,0,1,20,4),(174,20,0,1,20,4),(174,21,0,1,20,4),(174,22,0,1,20,4),(174,23,0,1,20,4),(174,24,0,1,20,4),(174,25,0,1,20,4),(174,26,0,1,20,4),(174,27,0,1,20,4),(174,28,0,1,20,4),(174,29,0,1,20,4),(174,30,0,1,20,4),(175,1,0,1,20,4),(175,2,0,1,20,4),(175,3,0,1,20,4),(175,4,0,1,20,4),(175,5,0,1,20,4),(175,6,0,1,20,4),(175,7,0,1,20,4),(175,8,0,1,20,4),(175,9,0,1,20,4),(175,10,0,1,20,4),(175,11,0,1,20,4),(175,12,0,1,20,4),(175,13,0,1,20,4),(175,14,0,1,20,4),(175,15,0,1,20,4),(175,16,0,1,20,4),(175,17,0,1,20,4),(175,18,0,1,20,4),(175,19,0,1,20,4),(175,20,0,1,20,4),(175,21,0,1,20,4),(175,22,0,1,20,4),(175,23,0,1,20,4),(175,24,0,1,20,4),(175,25,0,1,20,4),(175,26,0,1,20,4),(175,27,0,1,20,4),(175,28,0,1,20,4),(175,29,0,1,20,4),(175,30,0,1,20,4),(176,1,0,1,20,4),(176,2,0,1,20,4),(176,3,0,1,20,4),(176,4,0,1,20,4),(176,5,0,1,20,4),(176,6,0,1,20,4),(176,7,0,1,20,4),(176,8,0,1,20,4),(176,9,0,1,20,4),(176,10,0,1,20,4),(176,11,0,1,20,4),(176,12,0,1,20,4),(176,13,0,1,20,4),(176,14,0,1,20,4),(176,15,0,1,20,4),(176,16,0,1,20,4),(176,17,0,1,20,4),(176,18,0,1,20,4),(176,19,0,1,20,4),(176,20,0,1,20,4),(176,21,0,1,20,4),(176,22,0,1,20,4),(176,23,0,1,20,4),(176,24,0,1,20,4),(176,25,0,1,20,4),(176,26,0,1,20,4),(176,27,0,1,20,4),(176,28,0,1,20,4),(176,29,0,1,20,4),(176,30,0,1,20,4),(177,74,0,1,20,4),(177,75,0,1,20,4),(177,76,0,1,20,4),(177,77,0,1,20,4),(177,78,0,1,20,4),(177,79,0,1,20,4),(177,80,0,1,20,4),(178,74,10000,0,20,4),(178,75,10000,0,20,4),(178,76,10000,0,20,4),(178,77,10000,0,20,4),(178,78,10000,0,20,4),(178,79,10000,0,20,4),(178,80,10000,0,20,4),(178,81,10000,0,20,4),(178,82,10000,0,20,4),(178,83,10000,0,20,4),(178,84,10000,0,20,4),(178,85,10000,0,20,4),(178,86,10000,0,20,4),(178,87,10000,0,20,4),(178,88,10000,0,20,4),(178,113,10000,0,20,4),(178,114,10000,0,20,4),(178,115,10000,0,20,4),(178,116,10000,0,20,4),(178,117,10000,0,20,4),(178,118,10000,0,20,4),(178,119,10000,0,20,4),(178,120,10000,0,20,4),(178,121,10000,0,20,4),(178,122,10000,0,20,4),(178,123,10000,0,20,4),(178,124,10000,0,20,4),(178,125,10000,0,20,4),(178,126,10000,0,20,4),(178,127,10000,0,20,4),(178,128,10000,0,20,4),(178,129,10000,0,20,4),(178,130,10000,0,20,4),(178,131,10000,0,20,4),(178,132,10000,0,20,4),(178,133,10000,0,20,4),(178,134,10000,0,20,4),(178,135,10000,0,20,4),(178,136,10000,0,20,4),(178,137,10000,0,20,4),(178,138,10000,0,20,4),(178,139,10000,0,20,4),(178,140,10000,0,20,4),(178,141,10000,0,20,4),(178,142,10000,0,20,4),(178,143,10000,0,20,4),(178,144,10000,0,20,4),(178,145,10000,0,20,4),(178,146,10000,0,20,4),(178,147,10000,0,20,4),(178,148,10000,0,20,4),(178,149,10000,0,20,4),(178,150,10000,0,20,4),(178,151,10000,0,20,4),(178,152,10000,0,20,4),(178,153,10000,0,20,4),(178,154,10000,0,20,4),(178,155,10000,0,20,4),(178,156,10000,0,20,4),(178,157,10000,0,20,4),(178,158,10000,0,20,4),(178,159,10000,0,20,4),(178,160,10000,0,20,4),(178,161,10000,0,20,4),(178,162,10000,0,20,4),(178,163,10000,0,20,4),(178,164,10000,0,20,4),(178,165,10000,0,20,4),(178,166,10000,0,20,4),(178,167,10000,0,20,4),(178,168,10000,0,20,4),(178,169,10000,0,20,4),(178,170,10000,0,20,4),(178,171,10000,0,20,4),(178,172,10000,0,20,4),(178,173,10000,0,20,4),(178,174,10000,0,20,4),(178,175,10000,0,20,4),(178,176,10000,0,20,4),(178,177,10000,0,20,4),(178,178,10000,0,20,4),(178,179,10000,0,20,4),(178,180,10000,0,20,4),(178,181,10000,0,20,4),(178,182,10000,0,20,4),(178,183,10000,0,20,4),(178,184,10000,0,20,4),(178,185,10000,0,20,4),(178,186,10000,0,20,4),(178,187,10000,0,20,4),(178,188,10000,0,20,4),(178,189,10000,0,20,4),(178,190,10000,0,20,4),(178,191,10000,0,20,4),(178,192,10000,0,20,4),(178,193,10000,0,20,4),(178,194,10000,0,20,4),(178,195,10000,0,20,4),(178,196,10000,0,20,4),(178,197,10000,0,20,4),(178,198,10000,0,20,4),(178,199,10000,0,20,4),(178,200,10000,0,20,4),(178,201,10000,0,20,4),(178,202,10000,0,20,4),(178,203,10000,0,20,4),(178,204,10000,0,20,4),(178,205,10000,0,20,4),(178,206,10000,0,20,4),(178,207,10000,0,20,4),(178,208,10000,0,20,4),(178,209,10000,0,20,4),(178,210,10000,0,20,4),(178,211,10000,0,20,4),(178,212,10000,0,20,4),(178,213,10000,0,20,4),(178,214,10000,0,20,4),(178,215,10000,0,20,4),(178,216,10000,0,20,4),(178,217,10000,0,20,4),(178,218,10000,0,20,4),(178,219,10000,0,20,4),(178,220,10000,0,20,4),(178,221,10000,0,20,4),(178,222,10000,0,20,4),(178,223,10000,0,20,4),(178,224,10000,0,20,4),(178,225,10000,0,20,4),(178,226,10000,0,20,4),(178,227,10000,0,20,4),(178,228,10000,0,20,4),(178,229,10000,0,20,4),(178,230,10000,0,20,4),(178,231,10000,0,20,4),(178,232,10000,0,20,4),(178,233,10000,0,20,4),(178,234,10000,0,20,4),(178,235,10000,0,20,4),(178,236,10000,0,20,4),(178,237,10000,0,20,4),(178,238,10000,0,20,4),(178,239,10000,0,20,4),(178,240,10000,0,20,4),(178,241,10000,0,20,4),(178,244,10000,0,20,4),(178,246,10000,0,20,4),(178,251,10000,0,20,4),(178,255,10000,0,20,4),(178,258,10000,0,20,4),(178,259,10000,0,20,4),(178,260,10000,0,20,4),(178,261,10000,0,20,4),(178,262,10000,0,20,4),(178,263,10000,0,20,4),(179,81,0,1,20,4),(179,82,0,1,20,4),(179,83,0,1,20,4),(179,84,0,1,20,4),(179,85,0,1,20,4),(179,86,0,1,20,4),(179,87,0,1,20,4),(179,88,0,1,20,4),(180,81,0,1,20,4),(181,86,0,1,20,4),(182,82,0,1,20,4),(182,83,0,1,20,4),(182,84,0,1,20,4),(182,85,0,1,20,4),(182,87,0,1,20,4),(182,88,0,1,20,4),(183,82,0,1,20,4),(183,83,0,1,20,4),(183,84,0,1,20,4),(183,85,0,1,20,4),(183,86,0,1,20,4),(183,87,0,1,20,4),(183,88,0,1,20,4),(192,89,0,1,20,4),(192,90,0,1,20,4),(192,91,0,1,20,4),(192,92,0,1,20,4),(192,93,0,1,20,4),(192,94,0,1,20,4),(193,95,0,1,20,4),(193,96,0,1,20,4),(193,97,0,1,20,4),(193,98,0,1,20,4),(193,99,0,1,20,4),(193,100,0,1,20,4),(194,95,0,1,20,4),(194,96,0,1,20,4),(194,97,0,1,20,4),(194,98,0,1,20,4),(194,99,0,1,20,4),(194,100,0,1,20,4),(195,95,0,1,20,4),(195,96,0,1,20,4),(195,97,0,1,20,4),(195,98,0,1,20,4),(195,99,0,1,20,4),(195,100,0,1,20,4),(196,95,0,1,20,4),(196,96,0,1,20,4),(196,97,0,1,20,4),(196,98,0,1,20,4),(196,99,0,1,20,4),(196,100,0,1,20,4),(197,95,0,1,20,4),(197,96,0,1,20,4),(197,97,0,1,20,4),(197,98,0,1,20,4),(197,99,0,1,20,4),(197,100,0,1,20,4),(198,101,0,1,20,4),(198,109,0,1,20,4),(198,111,0,1,20,4),(198,112,0,1,20,4),(199,103,0,1,20,4),(199,110,0,1,20,4),(200,101,0,1,20,4),(200,102,0,1,20,4),(200,108,0,1,20,4),(201,104,0,1,20,4),(201,106,0,1,20,4),(202,101,0,1,20,4),(202,102,0,1,20,4),(202,103,0,1,20,4),(202,105,0,1,20,4),(202,107,0,1,20,4),(202,108,0,1,20,4),(202,110,0,1,20,4),(203,101,0,1,20,4),(203,102,0,1,20,4),(203,103,0,1,20,4),(203,104,0,1,20,4),(203,106,0,1,20,4),(203,108,0,1,20,4),(203,109,0,1,20,4),(204,101,0,1,20,4),(204,102,0,1,20,4),(204,103,0,1,20,4),(204,104,0,1,20,4),(204,105,0,1,20,4),(204,106,0,1,20,4),(204,107,0,1,20,4),(204,108,0,1,20,4),(205,101,0,1,20,4),(205,102,0,1,20,4),(205,103,0,1,20,4),(205,108,0,1,20,4),(205,109,0,1,20,4),(205,110,0,1,20,4),(205,111,0,1,20,4),(205,112,0,1,20,4),(206,113,10000,0,20,4),(206,114,10000,0,20,4),(206,115,10000,0,20,4),(206,116,10000,0,20,4),(206,117,10000,0,20,4),(206,118,10000,0,20,4),(206,119,10000,0,20,4),(207,114,0,1,20,4),(207,119,0,1,20,4),(209,114,0,1,20,4),(212,116,0,1,20,4),(212,118,0,1,20,4),(213,113,0,1,20,4),(218,117,0,1,20,4),(219,119,0,1,20,4),(220,119,0,1,20,4),(221,119,0,1,20,4),(222,114,0,1,20,4),(222,119,0,1,20,4),(223,114,0,1,20,4),(223,119,0,1,20,4),(229,113,0,1,20,4),(230,113,0,1,20,4),(231,113,0,1,20,4),(232,113,0,1,20,4),(233,113,0,1,20,4),(234,116,0,1,20,4),(234,118,0,1,20,4),(235,116,0,1,20,4),(235,118,0,1,20,4),(236,116,0,1,20,4),(236,118,0,1,20,4),(237,116,0,1,20,4),(237,118,0,1,20,4),(238,116,0,1,20,4),(238,118,0,1,20,4),(239,115,0,1,20,4),(241,115,0,1,20,4),(242,115,0,1,20,4),(243,115,0,1,20,4),(250,120,0,1,20,4),(250,121,0,1,20,4),(250,122,0,1,20,4),(250,123,0,1,20,4),(250,124,0,1,20,4),(250,125,0,1,20,4),(250,126,0,1,20,4),(250,127,0,1,20,4),(250,128,0,1,20,4),(250,129,0,1,20,4),(250,130,0,1,20,4),(250,131,0,1,20,4),(251,120,0,1,20,4),(251,121,0,1,20,4),(251,122,0,1,20,4),(251,123,0,1,20,4),(251,124,0,1,20,4),(251,125,0,1,20,4),(251,126,0,1,20,4),(251,127,0,1,20,4),(251,128,0,1,20,4),(251,129,0,1,20,4),(251,130,0,1,20,4),(251,131,0,1,20,4),(252,125,10000,0,20,4),(252,126,10000,0,20,4),(252,127,10000,0,20,4),(252,120,0,1,20,4),(252,121,0,1,20,4),(252,122,0,1,20,4),(252,123,0,1,20,4),(252,124,0,1,20,4),(252,128,0,1,20,4),(252,129,0,1,20,4),(252,131,0,1,20,4),(253,120,0,1,20,4),(253,121,0,1,20,4),(253,122,0,1,20,4),(253,123,0,1,20,4),(253,124,0,1,20,4),(253,125,0,1,20,4),(253,126,0,1,20,4),(253,127,0,1,20,4),(253,128,0,1,20,4),(253,129,0,1,20,4),(253,130,0,1,20,4),(253,131,0,1,20,4),(254,120,0,1,20,4),(254,121,0,1,20,4),(254,122,0,1,20,4),(254,123,0,1,20,4),(254,124,0,1,20,4),(254,125,0,1,20,4),(254,126,0,1,20,4),(254,127,0,1,20,4),(254,128,0,1,20,4),(254,129,0,1,20,4),(254,130,0,1,20,4),(254,131,0,1,20,4),(255,122,0,1,20,4),(255,123,0,1,20,4),(255,124,0,1,20,4),(255,125,0,1,20,4),(255,126,0,1,20,4),(255,129,0,1,20,4),(256,121,0,1,20,4),(256,122,0,1,20,4),(256,123,0,1,20,4),(256,125,0,1,20,4),(256,126,0,1,20,4),(256,127,0,1,20,4),(257,121,0,1,20,4),(257,122,0,1,20,4),(257,123,0,1,20,4),(257,125,0,1,20,4),(257,127,0,1,20,4),(257,129,0,1,20,4),(258,121,0,1,20,4),(258,122,0,1,20,4),(258,125,0,1,20,4),(258,126,0,1,20,4),(258,127,0,1,20,4),(258,129,0,1,20,4),(259,120,0,1,20,4),(259,121,0,1,20,4),(259,123,0,1,20,4),(259,128,0,1,20,4),(259,129,0,1,20,4),(260,120,0,1,20,4),(260,121,0,1,20,4),(260,122,0,1,20,4),(260,123,0,1,20,4),(260,125,0,1,20,4),(260,127,0,1,20,4),(260,128,0,1,20,4),(260,129,0,1,20,4),(261,121,0,1,20,4),(261,122,0,1,20,4),(261,125,0,1,20,4),(261,126,0,1,20,4),(261,127,0,1,20,4),(261,129,0,1,20,4),(262,125,0,1,20,4),(262,126,0,1,20,4),(263,120,0,1,20,4),(263,121,0,1,20,4),(263,122,0,1,20,4),(263,123,0,1,20,4),(263,124,0,1,20,4),(263,128,0,1,20,4),(263,129,0,1,20,4),(263,131,0,1,20,4),(264,120,0,1,20,4),(264,122,0,1,20,4),(264,123,0,1,20,4),(264,125,0,1,20,4),(264,126,0,1,20,4),(264,129,0,1,20,4),(265,121,0,1,20,4),(265,122,0,1,20,4),(265,123,0,1,20,4),(265,127,0,1,20,4),(266,123,0,1,20,4),(266,125,0,1,20,4),(266,126,0,1,20,4),(266,127,0,1,20,4),(266,129,0,1,20,4),(267,121,0,1,20,4),(267,125,0,1,20,4),(267,126,0,1,20,4),(267,127,0,1,20,4),(268,120,0,1,20,4),(268,121,0,1,20,4),(268,122,0,1,20,4),(268,123,0,1,20,4),(268,124,0,1,20,4),(268,127,0,1,20,4),(268,129,0,1,20,4),(269,122,0,1,20,4),(269,125,0,1,20,4),(269,126,0,1,20,4),(269,127,0,1,20,4),(269,129,0,1,20,4),(270,121,0,1,20,4),(270,123,0,1,20,4),(270,125,0,1,20,4),(270,126,0,1,20,4),(270,129,0,1,20,4),(271,120,0,1,20,4),(271,121,0,1,20,4),(271,122,0,1,20,4),(271,125,0,1,20,4),(271,126,0,1,20,4),(271,127,0,1,20,4),(271,129,0,1,20,4),(272,122,0,1,20,4),(272,123,0,1,20,4),(272,124,0,1,20,4),(272,125,0,1,20,4),(272,126,0,1,20,4),(272,127,0,1,20,4),(272,128,0,1,20,4),(272,129,0,1,20,4),(273,120,0,1,20,4),(273,121,0,1,20,4),(273,123,0,1,20,4),(273,126,0,1,20,4),(273,127,0,1,20,4),(274,122,0,1,20,4),(274,123,0,1,20,4),(274,125,0,1,20,4),(274,126,0,1,20,4),(274,129,0,1,20,4),(275,120,0,1,20,4),(275,121,0,1,20,4),(275,122,0,1,20,4),(275,123,0,1,20,4),(275,124,0,1,20,4),(275,125,0,1,20,4),(275,126,0,1,20,4),(275,127,0,1,20,4),(275,128,0,1,20,4),(275,129,0,1,20,4),(275,130,0,1,20,4),(275,131,0,1,20,4),(276,122,0,1,20,4),(276,123,0,1,20,4),(276,127,0,1,20,4),(276,129,0,1,20,4),(277,120,0,1,20,4),(277,121,0,1,20,4),(277,123,0,1,20,4),(277,124,0,1,20,4),(277,125,0,1,20,4),(277,126,0,1,20,4),(277,127,0,1,20,4),(278,120,0,1,20,4),(278,121,0,1,20,4),(278,122,0,1,20,4),(278,123,0,1,20,4),(278,124,0,1,20,4),(278,125,0,1,20,4),(278,127,0,1,20,4),(278,128,0,1,20,4),(278,129,0,1,20,4),(279,120,0,1,20,4),(279,122,0,1,20,4),(279,126,0,1,20,4),(279,127,0,1,20,4),(279,129,0,1,20,4),(280,132,0,1,20,4),(280,133,0,1,20,4),(280,134,0,1,20,4),(280,135,0,1,20,4),(280,136,0,1,20,4),(280,137,0,1,20,4),(280,138,0,1,20,4),(280,139,0,1,20,4),(282,132,0,1,20,4),(282,133,0,1,20,4),(282,134,0,1,20,4),(282,137,0,1,20,4),(282,138,0,1,20,4),(283,135,0,1,20,4),(283,136,0,1,20,4),(283,139,0,1,20,4),(286,140,0,1,20,4),(286,141,0,1,20,4),(286,142,0,1,20,4),(286,143,0,1,20,4),(286,144,0,1,20,4),(286,145,0,1,20,4),(286,146,0,1,20,4),(286,147,0,1,20,4),(286,148,0,1,20,4),(286,149,0,1,20,4),(286,150,0,1,20,4),(286,151,0,1,20,4),(286,152,0,1,20,4),(286,153,0,1,20,4),(286,154,0,1,20,4),(286,155,0,1,20,4),(286,156,0,1,20,4),(286,157,0,1,20,4),(286,158,0,1,20,4),(286,159,0,1,20,4),(286,160,0,1,20,4),(286,161,0,1,20,4),(286,162,0,1,20,4),(286,163,0,1,20,4),(286,164,0,1,20,4),(286,165,0,1,20,4),(286,166,0,1,20,4),(286,167,0,1,20,4),(286,168,0,1,20,4),(286,169,0,1,20,4),(286,170,0,1,20,4),(286,171,0,1,20,4),(286,172,0,1,20,4),(286,173,0,1,20,4),(286,174,0,1,20,4),(286,175,0,1,20,4),(286,176,0,1,20,4),(286,177,0,1,20,4),(286,178,0,1,20,4),(286,179,0,1,20,4),(286,180,0,1,20,4),(286,181,0,1,20,4),(286,182,0,1,20,4),(286,183,0,1,20,4),(286,184,0,1,20,4),(286,185,0,1,20,4),(286,186,0,1,20,4),(286,187,0,1,20,4),(287,188,0,1,20,4),(288,189,0,1,20,4),(288,190,0,1,20,4),(288,191,0,1,20,4),(288,192,0,1,20,4),(288,193,0,1,20,4),(288,194,0,1,20,4),(288,195,0,1,20,4),(288,196,0,1,20,4),(288,197,0,1,20,4),(288,198,0,1,20,4),(288,199,0,1,20,4),(288,200,0,1,20,4),(289,201,10000,0,20,4),(289,202,10000,0,20,4),(289,203,10000,0,20,4),(289,204,10000,0,20,4),(289,205,10000,0,20,4),(289,206,10000,0,20,4),(289,207,10000,0,20,4),(289,208,10000,0,20,4),(289,209,10000,0,20,4),(289,210,10000,0,20,4),(289,211,10000,0,20,4),(289,212,10000,0,20,4),(289,213,10000,0,20,4),(289,214,10000,0,20,4),(289,215,10000,0,20,4),(289,216,10000,0,20,4),(289,217,10000,0,20,4),(289,218,10000,0,20,4),(289,219,10000,0,20,4),(289,220,10000,0,20,4),(289,221,10000,0,20,4),(289,222,10000,0,20,4),(289,223,10000,0,20,4),(289,224,10000,0,20,4),(289,225,10000,0,20,4),(289,226,10000,0,20,4),(289,227,10000,0,20,4),(289,228,10000,0,20,4),(289,229,10000,0,20,4),(289,230,10000,0,20,4),(289,231,10000,0,20,4),(289,232,10000,0,20,4),(289,244,10000,0,20,4),(289,246,10000,0,20,4),(289,251,10000,0,20,4),(289,255,10000,0,20,4),(289,258,10000,0,20,4),(289,259,10000,0,20,4),(289,260,10000,0,20,4),(289,261,10000,0,20,4),(289,262,10000,0,20,4),(289,263,10000,0,20,4),(290,209,0,1,20,4),(290,210,0,1,20,4),(290,211,0,1,20,4),(290,212,0,1,20,4),(290,213,0,1,20,4),(290,214,0,1,20,4),(290,215,0,1,20,4),(290,216,0,1,20,4),(291,201,0,1,20,4),(291,202,0,1,20,4),(291,203,0,1,20,4),(291,204,0,1,20,4),(291,205,0,1,20,4),(291,206,0,1,20,4),(291,207,0,1,20,4),(291,208,0,1,20,4),(292,217,0,1,20,4),(292,218,0,1,20,4),(292,219,0,1,20,4),(292,220,0,1,20,4),(292,221,0,1,20,4),(292,222,0,1,20,4),(292,223,0,1,20,4),(292,224,0,1,20,4),(293,225,0,1,20,4),(293,226,0,1,20,4),(293,227,0,1,20,4),(293,228,0,1,20,4),(293,229,0,1,20,4),(293,230,0,1,20,4),(293,231,0,1,20,4),(293,232,0,1,20,4),(293,255,0,1,20,4),(293,259,0,1,20,4),(293,260,0,1,20,4),(293,261,0,1,20,4),(293,262,0,1,20,4),(293,263,0,1,20,4),(294,233,0,1,20,4),(294,234,0,1,20,4),(294,235,0,1,20,4),(294,236,0,1,20,4),(294,237,0,1,20,4),(294,238,0,1,20,4),(294,239,0,1,20,4),(294,240,0,1,20,4),(294,241,0,1,20,4),(295,244,0,1,20,4),(295,246,0,1,20,4),(295,251,0,1,20,4),(295,255,0,1,20,4),(295,258,0,1,20,4),(296,251,0,1,20,4),(296,255,0,1,20,4),(296,258,0,1,20,4),(297,246,0,1,20,4),(297,255,0,1,20,4),(297,258,0,1,20,4),(298,255,0,1,20,4),(298,258,0,1,20,4),(299,251,0,1,20,4),(299,258,0,1,20,4);
/*!40000 ALTER TABLE `catalog_category_product_index_store20` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index_store20_replica`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store20_replica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store20_replica` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `IDX_92A85414EA8D4FF1B880C684C605BD06` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_F4026BE614ED5AEE87C0195662EC9E1D` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Product Index Store20 Replica';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index_store20_replica`
--

LOCK TABLES `catalog_category_product_index_store20_replica` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index_store20_replica` DISABLE KEYS */;
INSERT INTO `catalog_category_product_index_store20_replica` VALUES (2,1,0,1,20,4),(2,2,0,1,20,4),(2,3,0,1,20,4),(2,4,0,1,20,4),(2,5,0,1,20,4),(2,6,0,1,20,4),(2,7,0,1,20,4),(2,8,0,1,20,4),(2,9,0,1,20,4),(2,10,0,1,20,4),(2,11,0,1,20,4),(2,12,0,1,20,4),(2,13,0,1,20,4),(2,14,0,1,20,4),(2,15,0,1,20,4),(2,16,0,1,20,4),(2,17,0,1,20,4),(2,18,0,1,20,4),(2,19,0,1,20,4),(2,20,0,1,20,4),(2,21,0,1,20,4),(2,22,0,1,20,4),(2,23,0,1,20,4),(2,24,0,1,20,4),(2,25,0,1,20,4),(2,26,0,1,20,4),(2,27,0,1,20,4),(2,28,0,1,20,4),(2,29,0,1,20,4),(2,30,0,1,20,4),(2,31,0,1,20,4),(2,32,0,1,20,4),(2,33,0,1,20,4),(2,34,0,1,20,4),(2,35,0,1,20,4),(2,36,0,1,20,4),(2,37,0,1,20,4),(2,38,0,1,20,4),(2,39,0,1,20,4),(2,40,0,1,20,4),(2,41,0,1,20,4),(2,42,0,1,20,4),(2,43,0,1,20,4),(2,44,0,1,20,4),(2,45,0,1,20,4),(2,46,0,1,20,4),(2,47,0,1,20,4),(2,48,0,1,20,4),(2,49,0,1,20,4),(2,50,0,1,20,4),(2,57,0,1,20,4),(2,58,0,1,20,4),(2,59,0,1,20,4),(2,60,0,1,20,4),(2,61,0,1,20,4),(2,62,0,1,20,4),(2,63,0,1,20,4),(2,64,0,1,20,4),(2,65,0,1,20,4),(2,66,0,1,20,4),(2,68,0,1,20,4),(2,69,0,1,20,4),(2,70,0,1,20,4),(2,71,0,1,20,4),(2,72,0,1,20,4),(2,73,0,1,20,4),(2,74,0,1,20,4),(2,75,0,1,20,4),(2,76,0,1,20,4),(2,77,0,1,20,4),(2,78,0,1,20,4),(2,79,0,1,20,4),(2,80,0,1,20,4),(2,81,0,1,20,4),(2,82,0,1,20,4),(2,83,0,1,20,4),(2,84,0,1,20,4),(2,85,0,1,20,4),(2,86,0,1,20,4),(2,87,0,1,20,4),(2,88,0,1,20,4),(2,89,0,1,20,4),(2,90,0,1,20,4),(2,91,0,1,20,4),(2,92,0,1,20,4),(2,93,0,1,20,4),(2,94,0,1,20,4),(2,95,0,1,20,4),(2,96,0,1,20,4),(2,97,0,1,20,4),(2,98,0,1,20,4),(2,99,0,1,20,4),(2,100,0,1,20,4),(2,101,0,1,20,4),(2,102,0,1,20,4),(2,103,0,1,20,4),(2,104,0,1,20,4),(2,105,0,1,20,4),(2,106,0,1,20,4),(2,107,0,1,20,4),(2,108,0,1,20,4),(2,109,0,1,20,4),(2,110,0,1,20,4),(2,111,0,1,20,4),(2,112,0,1,20,4),(2,113,0,1,20,4),(2,114,0,1,20,4),(2,115,0,1,20,4),(2,116,0,1,20,4),(2,117,0,1,20,4),(2,118,0,1,20,4),(2,119,0,1,20,4),(2,120,0,1,20,4),(2,121,0,1,20,4),(2,122,0,1,20,4),(2,123,0,1,20,4),(2,124,0,1,20,4),(2,125,0,1,20,4),(2,126,0,1,20,4),(2,127,0,1,20,4),(2,128,0,1,20,4),(2,129,0,1,20,4),(2,130,0,1,20,4),(2,131,0,1,20,4),(2,132,0,1,20,4),(2,133,0,1,20,4),(2,134,0,1,20,4),(2,135,0,1,20,4),(2,136,0,1,20,4),(2,137,0,1,20,4),(2,138,0,1,20,4),(2,139,0,1,20,4),(2,140,0,1,20,4),(2,141,0,1,20,4),(2,142,0,1,20,4),(2,143,0,1,20,4),(2,144,0,1,20,4),(2,145,0,1,20,4),(2,146,0,1,20,4),(2,147,0,1,20,4),(2,148,0,1,20,4),(2,149,0,1,20,4),(2,150,0,1,20,4),(2,151,0,1,20,4),(2,152,0,1,20,4),(2,153,0,1,20,4),(2,154,0,1,20,4),(2,155,0,1,20,4),(2,156,0,1,20,4),(2,157,0,1,20,4),(2,158,0,1,20,4),(2,159,0,1,20,4),(2,160,0,1,20,4),(2,161,0,1,20,4),(2,162,0,1,20,4),(2,163,0,1,20,4),(2,164,0,1,20,4),(2,165,0,1,20,4),(2,166,0,1,20,4),(2,167,0,1,20,4),(2,168,0,1,20,4),(2,169,0,1,20,4),(2,170,0,1,20,4),(2,171,0,1,20,4),(2,172,0,1,20,4),(2,173,0,1,20,4),(2,174,0,1,20,4),(2,175,0,1,20,4),(2,176,0,1,20,4),(2,177,0,1,20,4),(2,178,0,1,20,4),(2,179,0,1,20,4),(2,180,0,1,20,4),(2,181,0,1,20,4),(2,182,0,1,20,4),(2,183,0,1,20,4),(2,184,0,1,20,4),(2,185,0,1,20,4),(2,186,0,1,20,4),(2,187,0,1,20,4),(2,188,0,1,20,4),(2,189,0,1,20,4),(2,190,0,1,20,4),(2,191,0,1,20,4),(2,192,0,1,20,4),(2,193,0,1,20,4),(2,194,0,1,20,4),(2,195,0,1,20,4),(2,196,0,1,20,4),(2,197,0,1,20,4),(2,198,0,1,20,4),(2,199,0,1,20,4),(2,200,0,1,20,4),(2,201,0,1,20,4),(2,202,0,1,20,4),(2,203,0,1,20,4),(2,204,0,1,20,4),(2,205,0,1,20,4),(2,206,0,1,20,4),(2,207,0,1,20,4),(2,208,0,1,20,4),(2,209,0,1,20,4),(2,210,0,1,20,4),(2,211,0,1,20,4),(2,212,0,1,20,4),(2,213,0,1,20,4),(2,214,0,1,20,4),(2,215,0,1,20,4),(2,216,0,1,20,4),(2,217,0,1,20,4),(2,218,0,1,20,4),(2,219,0,1,20,4),(2,220,0,1,20,4),(2,221,0,1,20,4),(2,222,0,1,20,4),(2,223,0,1,20,4),(2,224,0,1,20,4),(2,225,0,1,20,4),(2,226,0,1,20,4),(2,227,0,1,20,4),(2,228,0,1,20,4),(2,229,0,1,20,4),(2,230,0,1,20,4),(2,231,0,1,20,4),(2,232,0,1,20,4),(2,233,0,1,20,4),(2,234,0,1,20,4),(2,235,0,1,20,4),(2,236,0,1,20,4),(2,237,0,1,20,4),(2,238,0,1,20,4),(2,239,0,1,20,4),(2,240,0,1,20,4),(2,241,0,1,20,4),(2,244,0,1,20,4),(2,246,0,1,20,4),(2,251,0,1,20,4),(2,255,0,1,20,4),(2,258,0,1,20,4),(2,259,0,1,20,4),(2,260,0,1,20,4),(2,261,0,1,20,4),(2,262,0,1,20,4),(2,263,0,1,20,4),(3,1,0,1,20,4),(3,2,0,1,20,4),(3,3,0,1,20,4),(3,4,0,1,20,4),(3,5,0,1,20,4),(3,6,0,1,20,4),(3,7,0,1,20,4),(3,8,0,1,20,4),(3,10,0,1,20,4),(3,11,0,1,20,4),(4,12,0,1,20,4),(4,13,0,1,20,4),(4,14,0,1,20,4),(4,15,0,1,20,4),(4,16,0,1,20,4),(4,17,0,1,20,4),(4,18,0,1,20,4),(4,19,0,1,20,4),(4,36,0,1,20,4),(4,37,0,1,20,4),(4,38,0,1,20,4),(4,39,0,1,20,4),(4,40,0,1,20,4),(5,95,10000,0,20,4),(5,96,10000,0,20,4),(5,97,10000,0,20,4),(5,98,10000,0,20,4),(5,99,10000,0,20,4),(5,100,10000,0,20,4),(7,101,10000,0,20,4),(7,102,10000,0,20,4),(7,103,10000,0,20,4),(7,104,10000,0,20,4),(7,105,10000,0,20,4),(7,106,10000,0,20,4),(7,107,10000,0,20,4),(7,108,10000,0,20,4),(7,109,10000,0,20,4),(7,110,10000,0,20,4),(7,111,10000,0,20,4),(7,112,10000,0,20,4),(7,21,0,1,20,4),(7,22,0,1,20,4),(7,26,0,1,20,4),(8,61,0,1,20,4),(8,62,0,1,20,4),(8,63,0,1,20,4),(8,64,0,1,20,4),(8,65,0,1,20,4),(8,66,0,1,20,4),(11,4,10000,0,20,4),(11,89,10000,0,20,4),(11,90,10000,0,20,4),(11,91,10000,0,20,4),(11,92,10000,0,20,4),(11,93,10000,0,20,4),(11,94,10000,0,20,4),(11,28,0,1,20,4),(11,29,0,1,20,4),(11,30,0,1,20,4),(11,31,0,1,20,4),(11,32,0,1,20,4),(11,33,0,1,20,4),(11,34,0,1,20,4),(11,35,0,1,20,4),(13,21,0,1,20,4),(13,24,0,1,20,4),(13,25,0,1,20,4),(13,26,0,1,20,4),(13,27,0,1,20,4),(13,41,0,1,20,4),(13,42,0,1,20,4),(13,43,0,1,20,4),(13,44,0,1,20,4),(13,45,0,1,20,4),(13,46,0,1,20,4),(13,47,0,1,20,4),(13,48,0,1,20,4),(13,49,0,1,20,4),(15,22,10000,0,20,4),(15,23,10000,0,20,4),(16,20,0,1,20,4),(16,21,0,1,20,4),(16,22,0,1,20,4),(16,23,0,1,20,4),(16,24,0,1,20,4),(16,25,0,1,20,4),(16,26,0,1,20,4),(16,27,0,1,20,4),(16,41,0,1,20,4),(16,68,0,1,20,4),(16,69,0,1,20,4),(16,70,0,1,20,4),(16,71,0,1,20,4),(16,72,0,1,20,4),(16,73,0,1,20,4),(19,6,0,1,20,4),(19,7,0,1,20,4),(19,8,0,1,20,4),(19,10,0,1,20,4),(19,11,0,1,20,4),(27,11,0,1,20,4),(29,6,0,1,20,4),(29,8,0,1,20,4),(29,10,0,1,20,4),(30,6,0,1,20,4),(30,10,0,1,20,4),(33,7,0,1,20,4),(33,8,0,1,20,4),(33,10,0,1,20,4),(33,11,0,1,20,4),(42,7,0,1,20,4),(42,8,0,1,20,4),(42,11,0,1,20,4),(78,21,0,1,20,4),(78,26,0,1,20,4),(80,21,0,1,20,4),(80,22,0,1,20,4),(80,26,0,1,20,4),(81,26,0,1,20,4),(82,26,0,1,20,4),(83,26,0,1,20,4),(96,26,0,1,20,4),(97,26,0,1,20,4),(98,21,0,1,20,4),(98,22,0,1,20,4),(98,26,0,1,20,4),(99,18,0,1,20,4),(101,14,0,1,20,4),(101,15,0,1,20,4),(101,16,0,1,20,4),(102,12,0,1,20,4),(102,13,0,1,20,4),(102,14,0,1,20,4),(102,15,0,1,20,4),(102,16,0,1,20,4),(102,17,0,1,20,4),(102,19,0,1,20,4),(102,36,0,1,20,4),(102,37,0,1,20,4),(102,38,0,1,20,4),(102,39,0,1,20,4),(102,40,0,1,20,4),(103,18,0,1,20,4),(104,18,0,1,20,4),(105,18,0,1,20,4),(106,18,0,1,20,4),(107,18,0,1,20,4),(134,23,0,1,20,4),(135,22,0,1,20,4),(137,4,0,1,20,4),(137,28,0,1,20,4),(137,31,0,1,20,4),(137,34,0,1,20,4),(137,35,0,1,20,4),(138,28,0,1,20,4),(138,30,0,1,20,4),(138,32,0,1,20,4),(138,33,0,1,20,4),(139,28,0,1,20,4),(139,30,0,1,20,4),(139,32,0,1,20,4),(139,33,0,1,20,4),(140,28,0,1,20,4),(140,30,0,1,20,4),(140,32,0,1,20,4),(140,33,0,1,20,4),(145,1,0,1,20,4),(145,2,0,1,20,4),(145,3,0,1,20,4),(145,4,0,1,20,4),(145,5,0,1,20,4),(145,6,0,1,20,4),(145,7,0,1,20,4),(145,8,0,1,20,4),(145,9,0,1,20,4),(145,10,0,1,20,4),(145,11,0,1,20,4),(145,12,0,1,20,4),(145,13,0,1,20,4),(145,14,0,1,20,4),(145,15,0,1,20,4),(145,16,0,1,20,4),(145,17,0,1,20,4),(145,18,0,1,20,4),(145,19,0,1,20,4),(145,20,0,1,20,4),(145,21,0,1,20,4),(145,22,0,1,20,4),(145,23,0,1,20,4),(145,24,0,1,20,4),(145,25,0,1,20,4),(145,26,0,1,20,4),(145,27,0,1,20,4),(145,28,0,1,20,4),(145,29,0,1,20,4),(145,30,0,1,20,4),(145,31,0,1,20,4),(145,32,0,1,20,4),(145,33,0,1,20,4),(145,34,0,1,20,4),(145,35,0,1,20,4),(145,36,0,1,20,4),(145,37,0,1,20,4),(145,38,0,1,20,4),(145,39,0,1,20,4),(145,40,0,1,20,4),(145,41,0,1,20,4),(145,42,0,1,20,4),(145,43,0,1,20,4),(149,41,0,1,20,4),(150,50,0,1,20,4),(150,57,0,1,20,4),(150,58,0,1,20,4),(150,59,0,1,20,4),(150,60,0,1,20,4),(151,61,0,1,20,4),(151,62,0,1,20,4),(151,63,0,1,20,4),(151,64,0,1,20,4),(151,65,0,1,20,4),(151,66,0,1,20,4),(152,61,0,1,20,4),(152,63,0,1,20,4),(153,61,0,1,20,4),(153,63,0,1,20,4),(153,64,0,1,20,4),(153,65,0,1,20,4),(153,66,0,1,20,4),(154,61,0,1,20,4),(154,62,0,1,20,4),(154,64,0,1,20,4),(154,66,0,1,20,4),(155,61,0,1,20,4),(155,62,0,1,20,4),(155,64,0,1,20,4),(155,65,0,1,20,4),(155,66,0,1,20,4),(156,61,0,1,20,4),(156,62,0,1,20,4),(156,63,0,1,20,4),(156,64,0,1,20,4),(156,65,0,1,20,4),(156,66,0,1,20,4),(157,61,0,1,20,4),(157,62,0,1,20,4),(157,64,0,1,20,4),(157,65,0,1,20,4),(157,66,0,1,20,4),(158,61,0,1,20,4),(158,63,0,1,20,4),(158,64,0,1,20,4),(158,65,0,1,20,4),(158,66,0,1,20,4),(159,61,0,1,20,4),(159,62,0,1,20,4),(159,63,0,1,20,4),(159,64,0,1,20,4),(159,65,0,1,20,4),(159,66,0,1,20,4),(160,41,0,1,20,4),(160,68,0,1,20,4),(160,69,0,1,20,4),(160,70,0,1,20,4),(160,72,0,1,20,4),(160,73,0,1,20,4),(161,68,0,1,20,4),(161,69,0,1,20,4),(161,70,0,1,20,4),(161,71,0,1,20,4),(161,72,0,1,20,4),(162,68,0,1,20,4),(162,69,0,1,20,4),(162,72,0,1,20,4),(164,41,0,1,20,4),(164,70,0,1,20,4),(164,73,0,1,20,4),(166,41,0,1,20,4),(166,70,0,1,20,4),(166,73,0,1,20,4),(167,68,0,1,20,4),(167,69,0,1,20,4),(167,72,0,1,20,4),(168,71,0,1,20,4),(169,70,0,1,20,4),(171,70,0,1,20,4),(172,1,10000,0,20,4),(172,2,10000,0,20,4),(172,3,10000,0,20,4),(172,4,10000,0,20,4),(172,5,10000,0,20,4),(172,6,10000,0,20,4),(172,7,10000,0,20,4),(172,8,10000,0,20,4),(172,9,10000,0,20,4),(172,10,10000,0,20,4),(172,11,10000,0,20,4),(172,12,10000,0,20,4),(172,13,10000,0,20,4),(172,14,10000,0,20,4),(172,15,10000,0,20,4),(172,16,10000,0,20,4),(172,17,10000,0,20,4),(172,18,10000,0,20,4),(172,19,10000,0,20,4),(172,20,10000,0,20,4),(172,21,10000,0,20,4),(172,22,10000,0,20,4),(172,23,10000,0,20,4),(172,24,10000,0,20,4),(172,25,10000,0,20,4),(172,26,10000,0,20,4),(172,27,10000,0,20,4),(172,28,10000,0,20,4),(172,29,10000,0,20,4),(172,30,10000,0,20,4),(173,1,0,1,20,4),(173,2,0,1,20,4),(173,3,0,1,20,4),(173,4,0,1,20,4),(173,5,0,1,20,4),(173,6,0,1,20,4),(173,7,0,1,20,4),(173,8,0,1,20,4),(173,9,0,1,20,4),(173,10,0,1,20,4),(173,11,0,1,20,4),(173,12,0,1,20,4),(173,13,0,1,20,4),(173,14,0,1,20,4),(173,15,0,1,20,4),(173,16,0,1,20,4),(173,17,0,1,20,4),(173,18,0,1,20,4),(173,19,0,1,20,4),(173,20,0,1,20,4),(173,21,0,1,20,4),(173,22,0,1,20,4),(173,23,0,1,20,4),(173,24,0,1,20,4),(173,25,0,1,20,4),(173,26,0,1,20,4),(173,27,0,1,20,4),(173,28,0,1,20,4),(173,29,0,1,20,4),(173,30,0,1,20,4),(174,1,0,1,20,4),(174,2,0,1,20,4),(174,3,0,1,20,4),(174,4,0,1,20,4),(174,5,0,1,20,4),(174,6,0,1,20,4),(174,7,0,1,20,4),(174,8,0,1,20,4),(174,9,0,1,20,4),(174,10,0,1,20,4),(174,11,0,1,20,4),(174,12,0,1,20,4),(174,13,0,1,20,4),(174,14,0,1,20,4),(174,15,0,1,20,4),(174,16,0,1,20,4),(174,17,0,1,20,4),(174,18,0,1,20,4),(174,19,0,1,20,4),(174,20,0,1,20,4),(174,21,0,1,20,4),(174,22,0,1,20,4),(174,23,0,1,20,4),(174,24,0,1,20,4),(174,25,0,1,20,4),(174,26,0,1,20,4),(174,27,0,1,20,4),(174,28,0,1,20,4),(174,29,0,1,20,4),(174,30,0,1,20,4),(175,1,0,1,20,4),(175,2,0,1,20,4),(175,3,0,1,20,4),(175,4,0,1,20,4),(175,5,0,1,20,4),(175,6,0,1,20,4),(175,7,0,1,20,4),(175,8,0,1,20,4),(175,9,0,1,20,4),(175,10,0,1,20,4),(175,11,0,1,20,4),(175,12,0,1,20,4),(175,13,0,1,20,4),(175,14,0,1,20,4),(175,15,0,1,20,4),(175,16,0,1,20,4),(175,17,0,1,20,4),(175,18,0,1,20,4),(175,19,0,1,20,4),(175,20,0,1,20,4),(175,21,0,1,20,4),(175,22,0,1,20,4),(175,23,0,1,20,4),(175,24,0,1,20,4),(175,25,0,1,20,4),(175,26,0,1,20,4),(175,27,0,1,20,4),(175,28,0,1,20,4),(175,29,0,1,20,4),(175,30,0,1,20,4),(176,1,0,1,20,4),(176,2,0,1,20,4),(176,3,0,1,20,4),(176,4,0,1,20,4),(176,5,0,1,20,4),(176,6,0,1,20,4),(176,7,0,1,20,4),(176,8,0,1,20,4),(176,9,0,1,20,4),(176,10,0,1,20,4),(176,11,0,1,20,4),(176,12,0,1,20,4),(176,13,0,1,20,4),(176,14,0,1,20,4),(176,15,0,1,20,4),(176,16,0,1,20,4),(176,17,0,1,20,4),(176,18,0,1,20,4),(176,19,0,1,20,4),(176,20,0,1,20,4),(176,21,0,1,20,4),(176,22,0,1,20,4),(176,23,0,1,20,4),(176,24,0,1,20,4),(176,25,0,1,20,4),(176,26,0,1,20,4),(176,27,0,1,20,4),(176,28,0,1,20,4),(176,29,0,1,20,4),(176,30,0,1,20,4),(177,74,0,1,20,4),(177,75,0,1,20,4),(177,76,0,1,20,4),(177,77,0,1,20,4),(177,78,0,1,20,4),(177,79,0,1,20,4),(177,80,0,1,20,4),(178,74,10000,0,20,4),(178,75,10000,0,20,4),(178,76,10000,0,20,4),(178,77,10000,0,20,4),(178,78,10000,0,20,4),(178,79,10000,0,20,4),(178,80,10000,0,20,4),(178,81,10000,0,20,4),(178,82,10000,0,20,4),(178,83,10000,0,20,4),(178,84,10000,0,20,4),(178,85,10000,0,20,4),(178,86,10000,0,20,4),(178,87,10000,0,20,4),(178,88,10000,0,20,4),(178,113,10000,0,20,4),(178,114,10000,0,20,4),(178,115,10000,0,20,4),(178,116,10000,0,20,4),(178,117,10000,0,20,4),(178,118,10000,0,20,4),(178,119,10000,0,20,4),(178,120,10000,0,20,4),(178,121,10000,0,20,4),(178,122,10000,0,20,4),(178,123,10000,0,20,4),(178,124,10000,0,20,4),(178,125,10000,0,20,4),(178,126,10000,0,20,4),(178,127,10000,0,20,4),(178,128,10000,0,20,4),(178,129,10000,0,20,4),(178,130,10000,0,20,4),(178,131,10000,0,20,4),(178,132,10000,0,20,4),(178,133,10000,0,20,4),(178,134,10000,0,20,4),(178,135,10000,0,20,4),(178,136,10000,0,20,4),(178,137,10000,0,20,4),(178,138,10000,0,20,4),(178,139,10000,0,20,4),(178,140,10000,0,20,4),(178,141,10000,0,20,4),(178,142,10000,0,20,4),(178,143,10000,0,20,4),(178,144,10000,0,20,4),(178,145,10000,0,20,4),(178,146,10000,0,20,4),(178,147,10000,0,20,4),(178,148,10000,0,20,4),(178,149,10000,0,20,4),(178,150,10000,0,20,4),(178,151,10000,0,20,4),(178,152,10000,0,20,4),(178,153,10000,0,20,4),(178,154,10000,0,20,4),(178,155,10000,0,20,4),(178,156,10000,0,20,4),(178,157,10000,0,20,4),(178,158,10000,0,20,4),(178,159,10000,0,20,4),(178,160,10000,0,20,4),(178,161,10000,0,20,4),(178,162,10000,0,20,4),(178,163,10000,0,20,4),(178,164,10000,0,20,4),(178,165,10000,0,20,4),(178,166,10000,0,20,4),(178,167,10000,0,20,4),(178,168,10000,0,20,4),(178,169,10000,0,20,4),(178,170,10000,0,20,4),(178,171,10000,0,20,4),(178,172,10000,0,20,4),(178,173,10000,0,20,4),(178,174,10000,0,20,4),(178,175,10000,0,20,4),(178,176,10000,0,20,4),(178,177,10000,0,20,4),(178,178,10000,0,20,4),(178,179,10000,0,20,4),(178,180,10000,0,20,4),(178,181,10000,0,20,4),(178,182,10000,0,20,4),(178,183,10000,0,20,4),(178,184,10000,0,20,4),(178,185,10000,0,20,4),(178,186,10000,0,20,4),(178,187,10000,0,20,4),(178,188,10000,0,20,4),(178,189,10000,0,20,4),(178,190,10000,0,20,4),(178,191,10000,0,20,4),(178,192,10000,0,20,4),(178,193,10000,0,20,4),(178,194,10000,0,20,4),(178,195,10000,0,20,4),(178,196,10000,0,20,4),(178,197,10000,0,20,4),(178,198,10000,0,20,4),(178,199,10000,0,20,4),(178,200,10000,0,20,4),(178,201,10000,0,20,4),(178,202,10000,0,20,4),(178,203,10000,0,20,4),(178,204,10000,0,20,4),(178,205,10000,0,20,4),(178,206,10000,0,20,4),(178,207,10000,0,20,4),(178,208,10000,0,20,4),(178,209,10000,0,20,4),(178,210,10000,0,20,4),(178,211,10000,0,20,4),(178,212,10000,0,20,4),(178,213,10000,0,20,4),(178,214,10000,0,20,4),(178,215,10000,0,20,4),(178,216,10000,0,20,4),(178,217,10000,0,20,4),(178,218,10000,0,20,4),(178,219,10000,0,20,4),(178,220,10000,0,20,4),(178,221,10000,0,20,4),(178,222,10000,0,20,4),(178,223,10000,0,20,4),(178,224,10000,0,20,4),(178,225,10000,0,20,4),(178,226,10000,0,20,4),(178,227,10000,0,20,4),(178,228,10000,0,20,4),(178,229,10000,0,20,4),(178,230,10000,0,20,4),(178,231,10000,0,20,4),(178,232,10000,0,20,4),(178,233,10000,0,20,4),(178,234,10000,0,20,4),(178,235,10000,0,20,4),(178,236,10000,0,20,4),(178,237,10000,0,20,4),(178,238,10000,0,20,4),(178,239,10000,0,20,4),(178,240,10000,0,20,4),(178,241,10000,0,20,4),(178,244,10000,0,20,4),(178,246,10000,0,20,4),(178,251,10000,0,20,4),(178,255,10000,0,20,4),(178,258,10000,0,20,4),(178,259,10000,0,20,4),(178,260,10000,0,20,4),(178,261,10000,0,20,4),(178,262,10000,0,20,4),(178,263,10000,0,20,4),(179,81,0,1,20,4),(179,82,0,1,20,4),(179,83,0,1,20,4),(179,84,0,1,20,4),(179,85,0,1,20,4),(179,86,0,1,20,4),(179,87,0,1,20,4),(179,88,0,1,20,4),(180,81,0,1,20,4),(181,86,0,1,20,4),(182,82,0,1,20,4),(182,83,0,1,20,4),(182,84,0,1,20,4),(182,85,0,1,20,4),(182,87,0,1,20,4),(182,88,0,1,20,4),(183,82,0,1,20,4),(183,83,0,1,20,4),(183,84,0,1,20,4),(183,85,0,1,20,4),(183,86,0,1,20,4),(183,87,0,1,20,4),(183,88,0,1,20,4),(192,89,0,1,20,4),(192,90,0,1,20,4),(192,91,0,1,20,4),(192,92,0,1,20,4),(192,93,0,1,20,4),(192,94,0,1,20,4),(193,95,0,1,20,4),(193,96,0,1,20,4),(193,97,0,1,20,4),(193,98,0,1,20,4),(193,99,0,1,20,4),(193,100,0,1,20,4),(194,95,0,1,20,4),(194,96,0,1,20,4),(194,97,0,1,20,4),(194,98,0,1,20,4),(194,99,0,1,20,4),(194,100,0,1,20,4),(195,95,0,1,20,4),(195,96,0,1,20,4),(195,97,0,1,20,4),(195,98,0,1,20,4),(195,99,0,1,20,4),(195,100,0,1,20,4),(196,95,0,1,20,4),(196,96,0,1,20,4),(196,97,0,1,20,4),(196,98,0,1,20,4),(196,99,0,1,20,4),(196,100,0,1,20,4),(197,95,0,1,20,4),(197,96,0,1,20,4),(197,97,0,1,20,4),(197,98,0,1,20,4),(197,99,0,1,20,4),(197,100,0,1,20,4),(198,101,0,1,20,4),(198,109,0,1,20,4),(198,111,0,1,20,4),(198,112,0,1,20,4),(199,103,0,1,20,4),(199,110,0,1,20,4),(200,101,0,1,20,4),(200,102,0,1,20,4),(200,108,0,1,20,4),(201,104,0,1,20,4),(201,106,0,1,20,4),(202,101,0,1,20,4),(202,102,0,1,20,4),(202,103,0,1,20,4),(202,105,0,1,20,4),(202,107,0,1,20,4),(202,108,0,1,20,4),(202,110,0,1,20,4),(203,101,0,1,20,4),(203,102,0,1,20,4),(203,103,0,1,20,4),(203,104,0,1,20,4),(203,106,0,1,20,4),(203,108,0,1,20,4),(203,109,0,1,20,4),(204,101,0,1,20,4),(204,102,0,1,20,4),(204,103,0,1,20,4),(204,104,0,1,20,4),(204,105,0,1,20,4),(204,106,0,1,20,4),(204,107,0,1,20,4),(204,108,0,1,20,4),(205,101,0,1,20,4),(205,102,0,1,20,4),(205,103,0,1,20,4),(205,108,0,1,20,4),(205,109,0,1,20,4),(205,110,0,1,20,4),(205,111,0,1,20,4),(205,112,0,1,20,4),(206,113,10000,0,20,4),(206,114,10000,0,20,4),(206,115,10000,0,20,4),(206,116,10000,0,20,4),(206,117,10000,0,20,4),(206,118,10000,0,20,4),(206,119,10000,0,20,4),(207,114,0,1,20,4),(207,119,0,1,20,4),(209,114,0,1,20,4),(212,116,0,1,20,4),(212,118,0,1,20,4),(213,113,0,1,20,4),(218,117,0,1,20,4),(219,119,0,1,20,4),(220,119,0,1,20,4),(221,119,0,1,20,4),(222,114,0,1,20,4),(222,119,0,1,20,4),(223,114,0,1,20,4),(223,119,0,1,20,4),(229,113,0,1,20,4),(230,113,0,1,20,4),(231,113,0,1,20,4),(232,113,0,1,20,4),(233,113,0,1,20,4),(234,116,0,1,20,4),(234,118,0,1,20,4),(235,116,0,1,20,4),(235,118,0,1,20,4),(236,116,0,1,20,4),(236,118,0,1,20,4),(237,116,0,1,20,4),(237,118,0,1,20,4),(238,116,0,1,20,4),(238,118,0,1,20,4),(239,115,0,1,20,4),(241,115,0,1,20,4),(242,115,0,1,20,4),(243,115,0,1,20,4),(250,120,0,1,20,4),(250,121,0,1,20,4),(250,122,0,1,20,4),(250,123,0,1,20,4),(250,124,0,1,20,4),(250,125,0,1,20,4),(250,126,0,1,20,4),(250,127,0,1,20,4),(250,128,0,1,20,4),(250,129,0,1,20,4),(250,130,0,1,20,4),(250,131,0,1,20,4),(251,120,0,1,20,4),(251,121,0,1,20,4),(251,122,0,1,20,4),(251,123,0,1,20,4),(251,124,0,1,20,4),(251,125,0,1,20,4),(251,126,0,1,20,4),(251,127,0,1,20,4),(251,128,0,1,20,4),(251,129,0,1,20,4),(251,130,0,1,20,4),(251,131,0,1,20,4),(252,125,10000,0,20,4),(252,126,10000,0,20,4),(252,127,10000,0,20,4),(252,120,0,1,20,4),(252,121,0,1,20,4),(252,122,0,1,20,4),(252,123,0,1,20,4),(252,124,0,1,20,4),(252,128,0,1,20,4),(252,129,0,1,20,4),(252,131,0,1,20,4),(253,120,0,1,20,4),(253,121,0,1,20,4),(253,122,0,1,20,4),(253,123,0,1,20,4),(253,124,0,1,20,4),(253,125,0,1,20,4),(253,126,0,1,20,4),(253,127,0,1,20,4),(253,128,0,1,20,4),(253,129,0,1,20,4),(253,130,0,1,20,4),(253,131,0,1,20,4),(254,120,0,1,20,4),(254,121,0,1,20,4),(254,122,0,1,20,4),(254,123,0,1,20,4),(254,124,0,1,20,4),(254,125,0,1,20,4),(254,126,0,1,20,4),(254,127,0,1,20,4),(254,128,0,1,20,4),(254,129,0,1,20,4),(254,130,0,1,20,4),(254,131,0,1,20,4),(255,122,0,1,20,4),(255,123,0,1,20,4),(255,124,0,1,20,4),(255,125,0,1,20,4),(255,126,0,1,20,4),(255,129,0,1,20,4),(256,121,0,1,20,4),(256,122,0,1,20,4),(256,123,0,1,20,4),(256,125,0,1,20,4),(256,126,0,1,20,4),(256,127,0,1,20,4),(257,121,0,1,20,4),(257,122,0,1,20,4),(257,123,0,1,20,4),(257,125,0,1,20,4),(257,127,0,1,20,4),(257,129,0,1,20,4),(258,121,0,1,20,4),(258,122,0,1,20,4),(258,125,0,1,20,4),(258,126,0,1,20,4),(258,127,0,1,20,4),(258,129,0,1,20,4),(259,120,0,1,20,4),(259,121,0,1,20,4),(259,123,0,1,20,4),(259,128,0,1,20,4),(259,129,0,1,20,4),(260,120,0,1,20,4),(260,121,0,1,20,4),(260,122,0,1,20,4),(260,123,0,1,20,4),(260,125,0,1,20,4),(260,127,0,1,20,4),(260,128,0,1,20,4),(260,129,0,1,20,4),(261,121,0,1,20,4),(261,122,0,1,20,4),(261,125,0,1,20,4),(261,126,0,1,20,4),(261,127,0,1,20,4),(261,129,0,1,20,4),(262,125,0,1,20,4),(262,126,0,1,20,4),(263,120,0,1,20,4),(263,121,0,1,20,4),(263,122,0,1,20,4),(263,123,0,1,20,4),(263,124,0,1,20,4),(263,128,0,1,20,4),(263,129,0,1,20,4),(263,131,0,1,20,4),(264,120,0,1,20,4),(264,122,0,1,20,4),(264,123,0,1,20,4),(264,125,0,1,20,4),(264,126,0,1,20,4),(264,129,0,1,20,4),(265,121,0,1,20,4),(265,122,0,1,20,4),(265,123,0,1,20,4),(265,127,0,1,20,4),(266,123,0,1,20,4),(266,125,0,1,20,4),(266,126,0,1,20,4),(266,127,0,1,20,4),(266,129,0,1,20,4),(267,121,0,1,20,4),(267,125,0,1,20,4),(267,126,0,1,20,4),(267,127,0,1,20,4),(268,120,0,1,20,4),(268,121,0,1,20,4),(268,122,0,1,20,4),(268,123,0,1,20,4),(268,124,0,1,20,4),(268,127,0,1,20,4),(268,129,0,1,20,4),(269,122,0,1,20,4),(269,125,0,1,20,4),(269,126,0,1,20,4),(269,127,0,1,20,4),(269,129,0,1,20,4),(270,121,0,1,20,4),(270,123,0,1,20,4),(270,125,0,1,20,4),(270,126,0,1,20,4),(270,129,0,1,20,4),(271,120,0,1,20,4),(271,121,0,1,20,4),(271,122,0,1,20,4),(271,125,0,1,20,4),(271,126,0,1,20,4),(271,127,0,1,20,4),(271,129,0,1,20,4),(272,122,0,1,20,4),(272,123,0,1,20,4),(272,124,0,1,20,4),(272,125,0,1,20,4),(272,126,0,1,20,4),(272,127,0,1,20,4),(272,128,0,1,20,4),(272,129,0,1,20,4),(273,120,0,1,20,4),(273,121,0,1,20,4),(273,123,0,1,20,4),(273,126,0,1,20,4),(273,127,0,1,20,4),(274,122,0,1,20,4),(274,123,0,1,20,4),(274,125,0,1,20,4),(274,126,0,1,20,4),(274,129,0,1,20,4),(275,120,0,1,20,4),(275,121,0,1,20,4),(275,122,0,1,20,4),(275,123,0,1,20,4),(275,124,0,1,20,4),(275,125,0,1,20,4),(275,126,0,1,20,4),(275,127,0,1,20,4),(275,128,0,1,20,4),(275,129,0,1,20,4),(275,130,0,1,20,4),(275,131,0,1,20,4),(276,122,0,1,20,4),(276,123,0,1,20,4),(276,127,0,1,20,4),(276,129,0,1,20,4),(277,120,0,1,20,4),(277,121,0,1,20,4),(277,123,0,1,20,4),(277,124,0,1,20,4),(277,125,0,1,20,4),(277,126,0,1,20,4),(277,127,0,1,20,4),(278,120,0,1,20,4),(278,121,0,1,20,4),(278,122,0,1,20,4),(278,123,0,1,20,4),(278,124,0,1,20,4),(278,125,0,1,20,4),(278,127,0,1,20,4),(278,128,0,1,20,4),(278,129,0,1,20,4),(279,120,0,1,20,4),(279,122,0,1,20,4),(279,126,0,1,20,4),(279,127,0,1,20,4),(279,129,0,1,20,4),(280,132,0,1,20,4),(280,133,0,1,20,4),(280,134,0,1,20,4),(280,135,0,1,20,4),(280,136,0,1,20,4),(280,137,0,1,20,4),(280,138,0,1,20,4),(280,139,0,1,20,4),(282,132,0,1,20,4),(282,133,0,1,20,4),(282,134,0,1,20,4),(282,137,0,1,20,4),(282,138,0,1,20,4),(283,135,0,1,20,4),(283,136,0,1,20,4),(283,139,0,1,20,4),(286,140,0,1,20,4),(286,141,0,1,20,4),(286,142,0,1,20,4),(286,143,0,1,20,4),(286,144,0,1,20,4),(286,145,0,1,20,4),(286,146,0,1,20,4),(286,147,0,1,20,4),(286,148,0,1,20,4),(286,149,0,1,20,4),(286,150,0,1,20,4),(286,151,0,1,20,4),(286,152,0,1,20,4),(286,153,0,1,20,4),(286,154,0,1,20,4),(286,155,0,1,20,4),(286,156,0,1,20,4),(286,157,0,1,20,4),(286,158,0,1,20,4),(286,159,0,1,20,4),(286,160,0,1,20,4),(286,161,0,1,20,4),(286,162,0,1,20,4),(286,163,0,1,20,4),(286,164,0,1,20,4),(286,165,0,1,20,4),(286,166,0,1,20,4),(286,167,0,1,20,4),(286,168,0,1,20,4),(286,169,0,1,20,4),(286,170,0,1,20,4),(286,171,0,1,20,4),(286,172,0,1,20,4),(286,173,0,1,20,4),(286,174,0,1,20,4),(286,175,0,1,20,4),(286,176,0,1,20,4),(286,177,0,1,20,4),(286,178,0,1,20,4),(286,179,0,1,20,4),(286,180,0,1,20,4),(286,181,0,1,20,4),(286,182,0,1,20,4),(286,183,0,1,20,4),(286,184,0,1,20,4),(286,185,0,1,20,4),(286,186,0,1,20,4),(286,187,0,1,20,4),(287,188,0,1,20,4),(288,189,0,1,20,4),(288,190,0,1,20,4),(288,191,0,1,20,4),(288,192,0,1,20,4),(288,193,0,1,20,4),(288,194,0,1,20,4),(288,195,0,1,20,4),(288,196,0,1,20,4),(288,197,0,1,20,4),(288,198,0,1,20,4),(288,199,0,1,20,4),(288,200,0,1,20,4),(289,201,10000,0,20,4),(289,202,10000,0,20,4),(289,203,10000,0,20,4),(289,204,10000,0,20,4),(289,205,10000,0,20,4),(289,206,10000,0,20,4),(289,207,10000,0,20,4),(289,208,10000,0,20,4),(289,209,10000,0,20,4),(289,210,10000,0,20,4),(289,211,10000,0,20,4),(289,212,10000,0,20,4),(289,213,10000,0,20,4),(289,214,10000,0,20,4),(289,215,10000,0,20,4),(289,216,10000,0,20,4),(289,217,10000,0,20,4),(289,218,10000,0,20,4),(289,219,10000,0,20,4),(289,220,10000,0,20,4),(289,221,10000,0,20,4),(289,222,10000,0,20,4),(289,223,10000,0,20,4),(289,224,10000,0,20,4),(289,225,10000,0,20,4),(289,226,10000,0,20,4),(289,227,10000,0,20,4),(289,228,10000,0,20,4),(289,229,10000,0,20,4),(289,230,10000,0,20,4),(289,231,10000,0,20,4),(289,232,10000,0,20,4),(289,244,10000,0,20,4),(289,246,10000,0,20,4),(289,251,10000,0,20,4),(289,255,10000,0,20,4),(289,258,10000,0,20,4),(289,259,10000,0,20,4),(289,260,10000,0,20,4),(289,261,10000,0,20,4),(289,262,10000,0,20,4),(289,263,10000,0,20,4),(290,209,0,1,20,4),(290,210,0,1,20,4),(290,211,0,1,20,4),(290,212,0,1,20,4),(290,213,0,1,20,4),(290,214,0,1,20,4),(290,215,0,1,20,4),(290,216,0,1,20,4),(291,201,0,1,20,4),(291,202,0,1,20,4),(291,203,0,1,20,4),(291,204,0,1,20,4),(291,205,0,1,20,4),(291,206,0,1,20,4),(291,207,0,1,20,4),(291,208,0,1,20,4),(292,217,0,1,20,4),(292,218,0,1,20,4),(292,219,0,1,20,4),(292,220,0,1,20,4),(292,221,0,1,20,4),(292,222,0,1,20,4),(292,223,0,1,20,4),(292,224,0,1,20,4),(293,225,0,1,20,4),(293,226,0,1,20,4),(293,227,0,1,20,4),(293,228,0,1,20,4),(293,229,0,1,20,4),(293,230,0,1,20,4),(293,231,0,1,20,4),(293,232,0,1,20,4),(293,255,0,1,20,4),(293,259,0,1,20,4),(293,260,0,1,20,4),(293,261,0,1,20,4),(293,262,0,1,20,4),(293,263,0,1,20,4),(294,233,0,1,20,4),(294,234,0,1,20,4),(294,235,0,1,20,4),(294,236,0,1,20,4),(294,237,0,1,20,4),(294,238,0,1,20,4),(294,239,0,1,20,4),(294,240,0,1,20,4),(294,241,0,1,20,4),(295,244,0,1,20,4),(295,246,0,1,20,4),(295,251,0,1,20,4),(295,255,0,1,20,4),(295,258,0,1,20,4),(296,251,0,1,20,4),(296,255,0,1,20,4),(296,258,0,1,20,4),(297,246,0,1,20,4),(297,255,0,1,20,4),(297,258,0,1,20,4),(298,255,0,1,20,4),(298,258,0,1,20,4),(299,251,0,1,20,4),(299,258,0,1,20,4);
/*!40000 ALTER TABLE `catalog_category_product_index_store20_replica` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index_store21`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store21`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store21` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `CAT_CTGR_PRD_IDX_STORE21_PRD_ID_STORE_ID_CTGR_ID_VISIBILITY` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_64CBFFB96BA3FA6476EE6CE065328279` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Product Index Store21';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index_store21`
--

LOCK TABLES `catalog_category_product_index_store21` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index_store21` DISABLE KEYS */;
INSERT INTO `catalog_category_product_index_store21` VALUES (2,1,0,1,21,4),(2,2,0,1,21,4),(2,3,0,1,21,4),(2,4,0,1,21,4),(2,5,0,1,21,4),(2,6,0,1,21,4),(2,7,0,1,21,4),(2,8,0,1,21,4),(2,9,0,1,21,4),(2,10,0,1,21,4),(2,11,0,1,21,4),(2,12,0,1,21,4),(2,13,0,1,21,4),(2,14,0,1,21,4),(2,15,0,1,21,4),(2,16,0,1,21,4),(2,17,0,1,21,4),(2,18,0,1,21,4),(2,19,0,1,21,4),(2,20,0,1,21,4),(2,21,0,1,21,4),(2,22,0,1,21,4),(2,23,0,1,21,4),(2,24,0,1,21,4),(2,25,0,1,21,4),(2,26,0,1,21,4),(2,27,0,1,21,4),(2,28,0,1,21,4),(2,29,0,1,21,4),(2,30,0,1,21,4),(2,31,0,1,21,4),(2,32,0,1,21,4),(2,33,0,1,21,4),(2,34,0,1,21,4),(2,35,0,1,21,4),(2,36,0,1,21,4),(2,37,0,1,21,4),(2,38,0,1,21,4),(2,39,0,1,21,4),(2,40,0,1,21,4),(2,41,0,1,21,4),(2,42,0,1,21,4),(2,43,0,1,21,4),(2,44,0,1,21,4),(2,45,0,1,21,4),(2,46,0,1,21,4),(2,47,0,1,21,4),(2,48,0,1,21,4),(2,49,0,1,21,4),(2,50,0,1,21,4),(2,57,0,1,21,4),(2,58,0,1,21,4),(2,59,0,1,21,4),(2,60,0,1,21,4),(2,61,0,1,21,4),(2,62,0,1,21,4),(2,63,0,1,21,4),(2,64,0,1,21,4),(2,65,0,1,21,4),(2,66,0,1,21,4),(2,68,0,1,21,4),(2,69,0,1,21,4),(2,70,0,1,21,4),(2,71,0,1,21,4),(2,72,0,1,21,4),(2,73,0,1,21,4),(2,74,0,1,21,4),(2,76,0,1,21,4),(2,77,0,1,21,4),(2,78,0,1,21,4),(2,79,0,1,21,4),(2,81,0,1,21,4),(2,82,0,1,21,4),(2,83,0,1,21,4),(2,84,0,1,21,4),(2,85,0,1,21,4),(2,86,0,1,21,4),(2,87,0,1,21,4),(2,88,0,1,21,4),(2,89,0,1,21,4),(2,90,0,1,21,4),(2,91,0,1,21,4),(2,92,0,1,21,4),(2,93,0,1,21,4),(2,94,0,1,21,4),(2,95,0,1,21,4),(2,96,0,1,21,4),(2,97,0,1,21,4),(2,98,0,1,21,4),(2,99,0,1,21,4),(2,100,0,1,21,4),(2,101,0,1,21,4),(2,102,0,1,21,4),(2,103,0,1,21,4),(2,104,0,1,21,4),(2,105,0,1,21,4),(2,106,0,1,21,4),(2,107,0,1,21,4),(2,108,0,1,21,4),(2,109,0,1,21,4),(2,110,0,1,21,4),(2,111,0,1,21,4),(2,112,0,1,21,4),(2,113,0,1,21,4),(2,114,0,1,21,4),(2,115,0,1,21,4),(2,116,0,1,21,4),(2,117,0,1,21,4),(2,118,0,1,21,4),(2,119,0,1,21,4),(2,120,0,1,21,4),(2,121,0,1,21,4),(2,122,0,1,21,4),(2,123,0,1,21,4),(2,124,0,1,21,4),(2,125,0,1,21,4),(2,126,0,1,21,4),(2,127,0,1,21,4),(2,128,0,1,21,4),(2,129,0,1,21,4),(2,130,0,1,21,4),(2,131,0,1,21,4),(2,132,0,1,21,4),(2,133,0,1,21,4),(2,134,0,1,21,4),(2,135,0,1,21,4),(2,136,0,1,21,4),(2,137,0,1,21,4),(2,138,0,1,21,4),(2,139,0,1,21,4),(2,140,0,1,21,4),(2,141,0,1,21,4),(2,142,0,1,21,4),(2,143,0,1,21,4),(2,144,0,1,21,4),(2,145,0,1,21,4),(2,146,0,1,21,4),(2,147,0,1,21,4),(2,148,0,1,21,4),(2,149,0,1,21,4),(2,150,0,1,21,4),(2,151,0,1,21,4),(2,152,0,1,21,4),(2,153,0,1,21,4),(2,154,0,1,21,4),(2,155,0,1,21,4),(2,156,0,1,21,4),(2,157,0,1,21,4),(2,158,0,1,21,4),(2,159,0,1,21,4),(2,160,0,1,21,4),(2,161,0,1,21,4),(2,162,0,1,21,4),(2,163,0,1,21,4),(2,164,0,1,21,4),(2,165,0,1,21,4),(2,166,0,1,21,4),(2,167,0,1,21,4),(2,168,0,1,21,4),(2,169,0,1,21,4),(2,170,0,1,21,4),(2,171,0,1,21,4),(2,172,0,1,21,4),(2,173,0,1,21,4),(2,174,0,1,21,4),(2,175,0,1,21,4),(2,176,0,1,21,4),(2,177,0,1,21,4),(2,178,0,1,21,4),(2,179,0,1,21,4),(2,180,0,1,21,4),(2,181,0,1,21,4),(2,182,0,1,21,4),(2,183,0,1,21,4),(2,184,0,1,21,4),(2,185,0,1,21,4),(2,186,0,1,21,4),(2,187,0,1,21,4),(2,188,0,1,21,4),(2,189,0,1,21,4),(2,190,0,1,21,4),(2,191,0,1,21,4),(2,192,0,1,21,4),(2,193,0,1,21,4),(2,194,0,1,21,4),(2,195,0,1,21,4),(2,196,0,1,21,4),(2,197,0,1,21,4),(2,198,0,1,21,4),(2,199,0,1,21,4),(2,200,0,1,21,4),(2,201,0,1,21,4),(2,202,0,1,21,4),(2,203,0,1,21,4),(2,204,0,1,21,4),(2,205,0,1,21,4),(2,206,0,1,21,4),(2,207,0,1,21,4),(2,208,0,1,21,4),(2,209,0,1,21,4),(2,210,0,1,21,4),(2,211,0,1,21,4),(2,212,0,1,21,4),(2,213,0,1,21,4),(2,214,0,1,21,4),(2,215,0,1,21,4),(2,216,0,1,21,4),(2,217,0,1,21,4),(2,218,0,1,21,4),(2,219,0,1,21,4),(2,220,0,1,21,4),(2,221,0,1,21,4),(2,222,0,1,21,4),(2,223,0,1,21,4),(2,224,0,1,21,4),(2,225,0,1,21,4),(2,226,0,1,21,4),(2,227,0,1,21,4),(2,228,0,1,21,4),(2,229,0,1,21,4),(2,230,0,1,21,4),(2,231,0,1,21,4),(2,232,0,1,21,4),(2,233,0,1,21,4),(2,234,0,1,21,4),(2,235,0,1,21,4),(2,236,0,1,21,4),(2,237,0,1,21,4),(2,238,0,1,21,4),(2,239,0,1,21,4),(2,240,0,1,21,4),(2,241,0,1,21,4),(2,244,0,1,21,4),(2,246,0,1,21,4),(2,251,0,1,21,4),(2,255,0,1,21,4),(2,258,0,1,21,4),(2,259,0,1,21,4),(2,260,0,1,21,4),(2,261,0,1,21,4),(2,262,0,1,21,4),(2,263,0,1,21,4),(3,1,0,1,21,4),(3,2,0,1,21,4),(3,3,0,1,21,4),(3,4,0,1,21,4),(3,5,0,1,21,4),(3,6,0,1,21,4),(3,7,0,1,21,4),(3,8,0,1,21,4),(3,10,0,1,21,4),(3,11,0,1,21,4),(4,12,0,1,21,4),(4,13,0,1,21,4),(4,14,0,1,21,4),(4,15,0,1,21,4),(4,16,0,1,21,4),(4,17,0,1,21,4),(4,18,0,1,21,4),(4,19,0,1,21,4),(4,36,0,1,21,4),(4,37,0,1,21,4),(4,38,0,1,21,4),(4,39,0,1,21,4),(4,40,0,1,21,4),(5,95,10000,0,21,4),(5,96,10000,0,21,4),(5,97,10000,0,21,4),(5,98,10000,0,21,4),(5,99,10000,0,21,4),(5,100,10000,0,21,4),(7,101,10000,0,21,4),(7,102,10000,0,21,4),(7,103,10000,0,21,4),(7,104,10000,0,21,4),(7,105,10000,0,21,4),(7,106,10000,0,21,4),(7,107,10000,0,21,4),(7,108,10000,0,21,4),(7,109,10000,0,21,4),(7,110,10000,0,21,4),(7,111,10000,0,21,4),(7,112,10000,0,21,4),(7,21,0,1,21,4),(7,22,0,1,21,4),(7,26,0,1,21,4),(8,61,0,1,21,4),(8,62,0,1,21,4),(8,63,0,1,21,4),(8,64,0,1,21,4),(8,65,0,1,21,4),(8,66,0,1,21,4),(11,4,10000,0,21,4),(11,89,10000,0,21,4),(11,90,10000,0,21,4),(11,91,10000,0,21,4),(11,92,10000,0,21,4),(11,93,10000,0,21,4),(11,94,10000,0,21,4),(11,28,0,1,21,4),(11,29,0,1,21,4),(11,30,0,1,21,4),(11,31,0,1,21,4),(11,32,0,1,21,4),(11,33,0,1,21,4),(11,34,0,1,21,4),(11,35,0,1,21,4),(13,21,0,1,21,4),(13,24,0,1,21,4),(13,25,0,1,21,4),(13,26,0,1,21,4),(13,27,0,1,21,4),(13,41,0,1,21,4),(13,42,0,1,21,4),(13,43,0,1,21,4),(13,44,0,1,21,4),(13,45,0,1,21,4),(13,46,0,1,21,4),(13,47,0,1,21,4),(13,48,0,1,21,4),(13,49,0,1,21,4),(15,22,10000,0,21,4),(15,23,10000,0,21,4),(16,20,0,1,21,4),(16,21,0,1,21,4),(16,22,0,1,21,4),(16,23,0,1,21,4),(16,24,0,1,21,4),(16,25,0,1,21,4),(16,26,0,1,21,4),(16,27,0,1,21,4),(16,41,0,1,21,4),(16,68,0,1,21,4),(16,69,0,1,21,4),(16,70,0,1,21,4),(16,71,0,1,21,4),(16,72,0,1,21,4),(16,73,0,1,21,4),(19,6,0,1,21,4),(19,7,0,1,21,4),(19,8,0,1,21,4),(19,10,0,1,21,4),(19,11,0,1,21,4),(27,11,0,1,21,4),(29,6,0,1,21,4),(29,8,0,1,21,4),(29,10,0,1,21,4),(30,6,0,1,21,4),(30,10,0,1,21,4),(33,7,0,1,21,4),(33,8,0,1,21,4),(33,10,0,1,21,4),(33,11,0,1,21,4),(42,7,0,1,21,4),(42,8,0,1,21,4),(42,11,0,1,21,4),(78,21,0,1,21,4),(78,26,0,1,21,4),(80,21,0,1,21,4),(80,22,0,1,21,4),(80,26,0,1,21,4),(81,26,0,1,21,4),(82,26,0,1,21,4),(83,26,0,1,21,4),(96,26,0,1,21,4),(97,26,0,1,21,4),(98,21,0,1,21,4),(98,22,0,1,21,4),(98,26,0,1,21,4),(99,18,0,1,21,4),(101,14,0,1,21,4),(101,15,0,1,21,4),(101,16,0,1,21,4),(102,12,0,1,21,4),(102,13,0,1,21,4),(102,14,0,1,21,4),(102,15,0,1,21,4),(102,16,0,1,21,4),(102,17,0,1,21,4),(102,19,0,1,21,4),(102,36,0,1,21,4),(102,37,0,1,21,4),(102,38,0,1,21,4),(102,39,0,1,21,4),(102,40,0,1,21,4),(103,18,0,1,21,4),(104,18,0,1,21,4),(105,18,0,1,21,4),(106,18,0,1,21,4),(107,18,0,1,21,4),(134,23,0,1,21,4),(135,22,0,1,21,4),(137,4,0,1,21,4),(137,28,0,1,21,4),(137,31,0,1,21,4),(137,34,0,1,21,4),(137,35,0,1,21,4),(138,28,0,1,21,4),(138,30,0,1,21,4),(138,32,0,1,21,4),(138,33,0,1,21,4),(139,28,0,1,21,4),(139,30,0,1,21,4),(139,32,0,1,21,4),(139,33,0,1,21,4),(140,28,0,1,21,4),(140,30,0,1,21,4),(140,32,0,1,21,4),(140,33,0,1,21,4),(145,1,0,1,21,4),(145,2,0,1,21,4),(145,3,0,1,21,4),(145,4,0,1,21,4),(145,5,0,1,21,4),(145,6,0,1,21,4),(145,7,0,1,21,4),(145,8,0,1,21,4),(145,9,0,1,21,4),(145,10,0,1,21,4),(145,11,0,1,21,4),(145,12,0,1,21,4),(145,13,0,1,21,4),(145,14,0,1,21,4),(145,15,0,1,21,4),(145,16,0,1,21,4),(145,17,0,1,21,4),(145,18,0,1,21,4),(145,19,0,1,21,4),(145,20,0,1,21,4),(145,21,0,1,21,4),(145,22,0,1,21,4),(145,23,0,1,21,4),(145,24,0,1,21,4),(145,25,0,1,21,4),(145,26,0,1,21,4),(145,27,0,1,21,4),(145,28,0,1,21,4),(145,29,0,1,21,4),(145,30,0,1,21,4),(145,31,0,1,21,4),(145,32,0,1,21,4),(145,33,0,1,21,4),(145,34,0,1,21,4),(145,35,0,1,21,4),(145,36,0,1,21,4),(145,37,0,1,21,4),(145,38,0,1,21,4),(145,39,0,1,21,4),(145,40,0,1,21,4),(145,41,0,1,21,4),(145,42,0,1,21,4),(145,43,0,1,21,4),(149,41,0,1,21,4),(150,50,0,1,21,4),(150,57,0,1,21,4),(150,58,0,1,21,4),(150,59,0,1,21,4),(150,60,0,1,21,4),(151,61,0,1,21,4),(151,62,0,1,21,4),(151,63,0,1,21,4),(151,64,0,1,21,4),(151,65,0,1,21,4),(151,66,0,1,21,4),(152,61,0,1,21,4),(152,63,0,1,21,4),(153,61,0,1,21,4),(153,63,0,1,21,4),(153,64,0,1,21,4),(153,65,0,1,21,4),(153,66,0,1,21,4),(154,61,0,1,21,4),(154,62,0,1,21,4),(154,64,0,1,21,4),(154,66,0,1,21,4),(155,61,0,1,21,4),(155,62,0,1,21,4),(155,64,0,1,21,4),(155,65,0,1,21,4),(155,66,0,1,21,4),(156,61,0,1,21,4),(156,62,0,1,21,4),(156,63,0,1,21,4),(156,64,0,1,21,4),(156,65,0,1,21,4),(156,66,0,1,21,4),(157,61,0,1,21,4),(157,62,0,1,21,4),(157,64,0,1,21,4),(157,65,0,1,21,4),(157,66,0,1,21,4),(158,61,0,1,21,4),(158,63,0,1,21,4),(158,64,0,1,21,4),(158,65,0,1,21,4),(158,66,0,1,21,4),(159,61,0,1,21,4),(159,62,0,1,21,4),(159,63,0,1,21,4),(159,64,0,1,21,4),(159,65,0,1,21,4),(159,66,0,1,21,4),(160,41,0,1,21,4),(160,68,0,1,21,4),(160,69,0,1,21,4),(160,70,0,1,21,4),(160,72,0,1,21,4),(160,73,0,1,21,4),(161,68,0,1,21,4),(161,69,0,1,21,4),(161,70,0,1,21,4),(161,71,0,1,21,4),(161,72,0,1,21,4),(162,68,0,1,21,4),(162,69,0,1,21,4),(162,72,0,1,21,4),(164,41,0,1,21,4),(164,70,0,1,21,4),(164,73,0,1,21,4),(166,41,0,1,21,4),(166,70,0,1,21,4),(166,73,0,1,21,4),(167,68,0,1,21,4),(167,69,0,1,21,4),(167,72,0,1,21,4),(168,71,0,1,21,4),(169,70,0,1,21,4),(171,70,0,1,21,4),(172,1,10000,0,21,4),(172,2,10000,0,21,4),(172,3,10000,0,21,4),(172,4,10000,0,21,4),(172,5,10000,0,21,4),(172,6,10000,0,21,4),(172,7,10000,0,21,4),(172,8,10000,0,21,4),(172,9,10000,0,21,4),(172,10,10000,0,21,4),(172,11,10000,0,21,4),(172,12,10000,0,21,4),(172,13,10000,0,21,4),(172,14,10000,0,21,4),(172,15,10000,0,21,4),(172,16,10000,0,21,4),(172,17,10000,0,21,4),(172,18,10000,0,21,4),(172,19,10000,0,21,4),(172,20,10000,0,21,4),(172,21,10000,0,21,4),(172,22,10000,0,21,4),(172,23,10000,0,21,4),(172,24,10000,0,21,4),(172,25,10000,0,21,4),(172,26,10000,0,21,4),(172,27,10000,0,21,4),(172,28,10000,0,21,4),(172,29,10000,0,21,4),(172,30,10000,0,21,4),(173,1,0,1,21,4),(173,2,0,1,21,4),(173,3,0,1,21,4),(173,4,0,1,21,4),(173,5,0,1,21,4),(173,6,0,1,21,4),(173,7,0,1,21,4),(173,8,0,1,21,4),(173,9,0,1,21,4),(173,10,0,1,21,4),(173,11,0,1,21,4),(173,12,0,1,21,4),(173,13,0,1,21,4),(173,14,0,1,21,4),(173,15,0,1,21,4),(173,16,0,1,21,4),(173,17,0,1,21,4),(173,18,0,1,21,4),(173,19,0,1,21,4),(173,20,0,1,21,4),(173,21,0,1,21,4),(173,22,0,1,21,4),(173,23,0,1,21,4),(173,24,0,1,21,4),(173,25,0,1,21,4),(173,26,0,1,21,4),(173,27,0,1,21,4),(173,28,0,1,21,4),(173,29,0,1,21,4),(173,30,0,1,21,4),(174,1,0,1,21,4),(174,2,0,1,21,4),(174,3,0,1,21,4),(174,4,0,1,21,4),(174,5,0,1,21,4),(174,6,0,1,21,4),(174,7,0,1,21,4),(174,8,0,1,21,4),(174,9,0,1,21,4),(174,10,0,1,21,4),(174,11,0,1,21,4),(174,12,0,1,21,4),(174,13,0,1,21,4),(174,14,0,1,21,4),(174,15,0,1,21,4),(174,16,0,1,21,4),(174,17,0,1,21,4),(174,18,0,1,21,4),(174,19,0,1,21,4),(174,20,0,1,21,4),(174,21,0,1,21,4),(174,22,0,1,21,4),(174,23,0,1,21,4),(174,24,0,1,21,4),(174,25,0,1,21,4),(174,26,0,1,21,4),(174,27,0,1,21,4),(174,28,0,1,21,4),(174,29,0,1,21,4),(174,30,0,1,21,4),(175,1,0,1,21,4),(175,2,0,1,21,4),(175,3,0,1,21,4),(175,4,0,1,21,4),(175,5,0,1,21,4),(175,6,0,1,21,4),(175,7,0,1,21,4),(175,8,0,1,21,4),(175,9,0,1,21,4),(175,10,0,1,21,4),(175,11,0,1,21,4),(175,12,0,1,21,4),(175,13,0,1,21,4),(175,14,0,1,21,4),(175,15,0,1,21,4),(175,16,0,1,21,4),(175,17,0,1,21,4),(175,18,0,1,21,4),(175,19,0,1,21,4),(175,20,0,1,21,4),(175,21,0,1,21,4),(175,22,0,1,21,4),(175,23,0,1,21,4),(175,24,0,1,21,4),(175,25,0,1,21,4),(175,26,0,1,21,4),(175,27,0,1,21,4),(175,28,0,1,21,4),(175,29,0,1,21,4),(175,30,0,1,21,4),(176,1,0,1,21,4),(176,2,0,1,21,4),(176,3,0,1,21,4),(176,4,0,1,21,4),(176,5,0,1,21,4),(176,6,0,1,21,4),(176,7,0,1,21,4),(176,8,0,1,21,4),(176,9,0,1,21,4),(176,10,0,1,21,4),(176,11,0,1,21,4),(176,12,0,1,21,4),(176,13,0,1,21,4),(176,14,0,1,21,4),(176,15,0,1,21,4),(176,16,0,1,21,4),(176,17,0,1,21,4),(176,18,0,1,21,4),(176,19,0,1,21,4),(176,20,0,1,21,4),(176,21,0,1,21,4),(176,22,0,1,21,4),(176,23,0,1,21,4),(176,24,0,1,21,4),(176,25,0,1,21,4),(176,26,0,1,21,4),(176,27,0,1,21,4),(176,28,0,1,21,4),(176,29,0,1,21,4),(176,30,0,1,21,4),(177,74,0,1,21,4),(177,76,0,1,21,4),(177,77,0,1,21,4),(177,78,0,1,21,4),(177,79,0,1,21,4),(178,74,10000,0,21,4),(178,76,10000,0,21,4),(178,77,10000,0,21,4),(178,78,10000,0,21,4),(178,79,10000,0,21,4),(178,81,10000,0,21,4),(178,82,10000,0,21,4),(178,83,10000,0,21,4),(178,84,10000,0,21,4),(178,85,10000,0,21,4),(178,86,10000,0,21,4),(178,87,10000,0,21,4),(178,88,10000,0,21,4),(178,113,10000,0,21,4),(178,114,10000,0,21,4),(178,115,10000,0,21,4),(178,116,10000,0,21,4),(178,117,10000,0,21,4),(178,118,10000,0,21,4),(178,119,10000,0,21,4),(178,120,10000,0,21,4),(178,121,10000,0,21,4),(178,122,10000,0,21,4),(178,123,10000,0,21,4),(178,124,10000,0,21,4),(178,125,10000,0,21,4),(178,126,10000,0,21,4),(178,127,10000,0,21,4),(178,128,10000,0,21,4),(178,129,10000,0,21,4),(178,130,10000,0,21,4),(178,131,10000,0,21,4),(178,132,10000,0,21,4),(178,133,10000,0,21,4),(178,134,10000,0,21,4),(178,135,10000,0,21,4),(178,136,10000,0,21,4),(178,137,10000,0,21,4),(178,138,10000,0,21,4),(178,139,10000,0,21,4),(178,140,10000,0,21,4),(178,141,10000,0,21,4),(178,142,10000,0,21,4),(178,143,10000,0,21,4),(178,144,10000,0,21,4),(178,145,10000,0,21,4),(178,146,10000,0,21,4),(178,147,10000,0,21,4),(178,148,10000,0,21,4),(178,149,10000,0,21,4),(178,150,10000,0,21,4),(178,151,10000,0,21,4),(178,152,10000,0,21,4),(178,153,10000,0,21,4),(178,154,10000,0,21,4),(178,155,10000,0,21,4),(178,156,10000,0,21,4),(178,157,10000,0,21,4),(178,158,10000,0,21,4),(178,159,10000,0,21,4),(178,160,10000,0,21,4),(178,161,10000,0,21,4),(178,162,10000,0,21,4),(178,163,10000,0,21,4),(178,164,10000,0,21,4),(178,165,10000,0,21,4),(178,166,10000,0,21,4),(178,167,10000,0,21,4),(178,168,10000,0,21,4),(178,169,10000,0,21,4),(178,170,10000,0,21,4),(178,171,10000,0,21,4),(178,172,10000,0,21,4),(178,173,10000,0,21,4),(178,174,10000,0,21,4),(178,175,10000,0,21,4),(178,176,10000,0,21,4),(178,177,10000,0,21,4),(178,178,10000,0,21,4),(178,179,10000,0,21,4),(178,180,10000,0,21,4),(178,181,10000,0,21,4),(178,182,10000,0,21,4),(178,183,10000,0,21,4),(178,184,10000,0,21,4),(178,185,10000,0,21,4),(178,186,10000,0,21,4),(178,187,10000,0,21,4),(178,188,10000,0,21,4),(178,189,10000,0,21,4),(178,190,10000,0,21,4),(178,191,10000,0,21,4),(178,192,10000,0,21,4),(178,193,10000,0,21,4),(178,194,10000,0,21,4),(178,195,10000,0,21,4),(178,196,10000,0,21,4),(178,197,10000,0,21,4),(178,198,10000,0,21,4),(178,199,10000,0,21,4),(178,200,10000,0,21,4),(178,201,10000,0,21,4),(178,202,10000,0,21,4),(178,203,10000,0,21,4),(178,204,10000,0,21,4),(178,205,10000,0,21,4),(178,206,10000,0,21,4),(178,207,10000,0,21,4),(178,208,10000,0,21,4),(178,209,10000,0,21,4),(178,210,10000,0,21,4),(178,211,10000,0,21,4),(178,212,10000,0,21,4),(178,213,10000,0,21,4),(178,214,10000,0,21,4),(178,215,10000,0,21,4),(178,216,10000,0,21,4),(178,217,10000,0,21,4),(178,218,10000,0,21,4),(178,219,10000,0,21,4),(178,220,10000,0,21,4),(178,221,10000,0,21,4),(178,222,10000,0,21,4),(178,223,10000,0,21,4),(178,224,10000,0,21,4),(178,225,10000,0,21,4),(178,226,10000,0,21,4),(178,227,10000,0,21,4),(178,228,10000,0,21,4),(178,229,10000,0,21,4),(178,230,10000,0,21,4),(178,231,10000,0,21,4),(178,232,10000,0,21,4),(178,233,10000,0,21,4),(178,234,10000,0,21,4),(178,235,10000,0,21,4),(178,236,10000,0,21,4),(178,237,10000,0,21,4),(178,238,10000,0,21,4),(178,239,10000,0,21,4),(178,240,10000,0,21,4),(178,241,10000,0,21,4),(178,244,10000,0,21,4),(178,246,10000,0,21,4),(178,251,10000,0,21,4),(178,255,10000,0,21,4),(178,258,10000,0,21,4),(178,259,10000,0,21,4),(178,260,10000,0,21,4),(178,261,10000,0,21,4),(178,262,10000,0,21,4),(178,263,10000,0,21,4),(179,81,0,1,21,4),(179,82,0,1,21,4),(179,83,0,1,21,4),(179,84,0,1,21,4),(179,85,0,1,21,4),(179,86,0,1,21,4),(179,87,0,1,21,4),(179,88,0,1,21,4),(180,81,0,1,21,4),(181,86,0,1,21,4),(182,82,0,1,21,4),(182,83,0,1,21,4),(182,84,0,1,21,4),(182,85,0,1,21,4),(182,87,0,1,21,4),(182,88,0,1,21,4),(183,82,0,1,21,4),(183,83,0,1,21,4),(183,84,0,1,21,4),(183,85,0,1,21,4),(183,86,0,1,21,4),(183,87,0,1,21,4),(183,88,0,1,21,4),(192,89,0,1,21,4),(192,90,0,1,21,4),(192,91,0,1,21,4),(192,92,0,1,21,4),(192,93,0,1,21,4),(192,94,0,1,21,4),(193,95,0,1,21,4),(193,96,0,1,21,4),(193,97,0,1,21,4),(193,98,0,1,21,4),(193,99,0,1,21,4),(193,100,0,1,21,4),(194,95,0,1,21,4),(194,96,0,1,21,4),(194,97,0,1,21,4),(194,98,0,1,21,4),(194,99,0,1,21,4),(194,100,0,1,21,4),(195,95,0,1,21,4),(195,96,0,1,21,4),(195,97,0,1,21,4),(195,98,0,1,21,4),(195,99,0,1,21,4),(195,100,0,1,21,4),(196,95,0,1,21,4),(196,96,0,1,21,4),(196,97,0,1,21,4),(196,98,0,1,21,4),(196,99,0,1,21,4),(196,100,0,1,21,4),(197,95,0,1,21,4),(197,96,0,1,21,4),(197,97,0,1,21,4),(197,98,0,1,21,4),(197,99,0,1,21,4),(197,100,0,1,21,4),(198,101,0,1,21,4),(198,109,0,1,21,4),(198,111,0,1,21,4),(198,112,0,1,21,4),(199,103,0,1,21,4),(199,110,0,1,21,4),(200,101,0,1,21,4),(200,102,0,1,21,4),(200,108,0,1,21,4),(201,104,0,1,21,4),(201,106,0,1,21,4),(202,101,0,1,21,4),(202,102,0,1,21,4),(202,103,0,1,21,4),(202,105,0,1,21,4),(202,107,0,1,21,4),(202,108,0,1,21,4),(202,110,0,1,21,4),(203,101,0,1,21,4),(203,102,0,1,21,4),(203,103,0,1,21,4),(203,104,0,1,21,4),(203,106,0,1,21,4),(203,108,0,1,21,4),(203,109,0,1,21,4),(204,101,0,1,21,4),(204,102,0,1,21,4),(204,103,0,1,21,4),(204,104,0,1,21,4),(204,105,0,1,21,4),(204,106,0,1,21,4),(204,107,0,1,21,4),(204,108,0,1,21,4),(205,101,0,1,21,4),(205,102,0,1,21,4),(205,103,0,1,21,4),(205,108,0,1,21,4),(205,109,0,1,21,4),(205,110,0,1,21,4),(205,111,0,1,21,4),(205,112,0,1,21,4),(206,113,10000,0,21,4),(206,114,10000,0,21,4),(206,115,10000,0,21,4),(206,116,10000,0,21,4),(206,117,10000,0,21,4),(206,118,10000,0,21,4),(206,119,10000,0,21,4),(207,114,0,1,21,4),(207,119,0,1,21,4),(209,114,0,1,21,4),(212,116,0,1,21,4),(212,118,0,1,21,4),(213,113,0,1,21,4),(218,117,0,1,21,4),(219,119,0,1,21,4),(220,119,0,1,21,4),(221,119,0,1,21,4),(222,114,0,1,21,4),(222,119,0,1,21,4),(223,114,0,1,21,4),(223,119,0,1,21,4),(229,113,0,1,21,4),(230,113,0,1,21,4),(231,113,0,1,21,4),(232,113,0,1,21,4),(233,113,0,1,21,4),(234,116,0,1,21,4),(234,118,0,1,21,4),(235,116,0,1,21,4),(235,118,0,1,21,4),(236,116,0,1,21,4),(236,118,0,1,21,4),(237,116,0,1,21,4),(237,118,0,1,21,4),(238,116,0,1,21,4),(238,118,0,1,21,4),(239,115,0,1,21,4),(241,115,0,1,21,4),(242,115,0,1,21,4),(243,115,0,1,21,4),(250,120,0,1,21,4),(250,121,0,1,21,4),(250,122,0,1,21,4),(250,123,0,1,21,4),(250,124,0,1,21,4),(250,125,0,1,21,4),(250,126,0,1,21,4),(250,127,0,1,21,4),(250,128,0,1,21,4),(250,129,0,1,21,4),(250,130,0,1,21,4),(250,131,0,1,21,4),(251,120,0,1,21,4),(251,121,0,1,21,4),(251,122,0,1,21,4),(251,123,0,1,21,4),(251,124,0,1,21,4),(251,125,0,1,21,4),(251,126,0,1,21,4),(251,127,0,1,21,4),(251,128,0,1,21,4),(251,129,0,1,21,4),(251,130,0,1,21,4),(251,131,0,1,21,4),(252,125,10000,0,21,4),(252,126,10000,0,21,4),(252,127,10000,0,21,4),(252,120,0,1,21,4),(252,121,0,1,21,4),(252,122,0,1,21,4),(252,123,0,1,21,4),(252,124,0,1,21,4),(252,128,0,1,21,4),(252,129,0,1,21,4),(252,131,0,1,21,4),(253,120,0,1,21,4),(253,121,0,1,21,4),(253,122,0,1,21,4),(253,123,0,1,21,4),(253,124,0,1,21,4),(253,125,0,1,21,4),(253,126,0,1,21,4),(253,127,0,1,21,4),(253,128,0,1,21,4),(253,129,0,1,21,4),(253,130,0,1,21,4),(253,131,0,1,21,4),(254,120,0,1,21,4),(254,121,0,1,21,4),(254,122,0,1,21,4),(254,123,0,1,21,4),(254,124,0,1,21,4),(254,125,0,1,21,4),(254,126,0,1,21,4),(254,127,0,1,21,4),(254,128,0,1,21,4),(254,129,0,1,21,4),(254,130,0,1,21,4),(254,131,0,1,21,4),(255,122,0,1,21,4),(255,123,0,1,21,4),(255,124,0,1,21,4),(255,125,0,1,21,4),(255,126,0,1,21,4),(255,129,0,1,21,4),(256,121,0,1,21,4),(256,122,0,1,21,4),(256,123,0,1,21,4),(256,125,0,1,21,4),(256,126,0,1,21,4),(256,127,0,1,21,4),(257,121,0,1,21,4),(257,122,0,1,21,4),(257,123,0,1,21,4),(257,125,0,1,21,4),(257,127,0,1,21,4),(257,129,0,1,21,4),(258,121,0,1,21,4),(258,122,0,1,21,4),(258,125,0,1,21,4),(258,126,0,1,21,4),(258,127,0,1,21,4),(258,129,0,1,21,4),(259,120,0,1,21,4),(259,121,0,1,21,4),(259,123,0,1,21,4),(259,128,0,1,21,4),(259,129,0,1,21,4),(260,120,0,1,21,4),(260,121,0,1,21,4),(260,122,0,1,21,4),(260,123,0,1,21,4),(260,125,0,1,21,4),(260,127,0,1,21,4),(260,128,0,1,21,4),(260,129,0,1,21,4),(261,121,0,1,21,4),(261,122,0,1,21,4),(261,125,0,1,21,4),(261,126,0,1,21,4),(261,127,0,1,21,4),(261,129,0,1,21,4),(262,125,0,1,21,4),(262,126,0,1,21,4),(263,120,0,1,21,4),(263,121,0,1,21,4),(263,122,0,1,21,4),(263,123,0,1,21,4),(263,124,0,1,21,4),(263,128,0,1,21,4),(263,129,0,1,21,4),(263,131,0,1,21,4),(264,120,0,1,21,4),(264,122,0,1,21,4),(264,123,0,1,21,4),(264,125,0,1,21,4),(264,126,0,1,21,4),(264,129,0,1,21,4),(265,121,0,1,21,4),(265,122,0,1,21,4),(265,123,0,1,21,4),(265,127,0,1,21,4),(266,123,0,1,21,4),(266,125,0,1,21,4),(266,126,0,1,21,4),(266,127,0,1,21,4),(266,129,0,1,21,4),(267,121,0,1,21,4),(267,125,0,1,21,4),(267,126,0,1,21,4),(267,127,0,1,21,4),(268,120,0,1,21,4),(268,121,0,1,21,4),(268,122,0,1,21,4),(268,123,0,1,21,4),(268,124,0,1,21,4),(268,127,0,1,21,4),(268,129,0,1,21,4),(269,122,0,1,21,4),(269,125,0,1,21,4),(269,126,0,1,21,4),(269,127,0,1,21,4),(269,129,0,1,21,4),(270,121,0,1,21,4),(270,123,0,1,21,4),(270,125,0,1,21,4),(270,126,0,1,21,4),(270,129,0,1,21,4),(271,120,0,1,21,4),(271,121,0,1,21,4),(271,122,0,1,21,4),(271,125,0,1,21,4),(271,126,0,1,21,4),(271,127,0,1,21,4),(271,129,0,1,21,4),(272,122,0,1,21,4),(272,123,0,1,21,4),(272,124,0,1,21,4),(272,125,0,1,21,4),(272,126,0,1,21,4),(272,127,0,1,21,4),(272,128,0,1,21,4),(272,129,0,1,21,4),(273,120,0,1,21,4),(273,121,0,1,21,4),(273,123,0,1,21,4),(273,126,0,1,21,4),(273,127,0,1,21,4),(274,122,0,1,21,4),(274,123,0,1,21,4),(274,125,0,1,21,4),(274,126,0,1,21,4),(274,129,0,1,21,4),(275,120,0,1,21,4),(275,121,0,1,21,4),(275,122,0,1,21,4),(275,123,0,1,21,4),(275,124,0,1,21,4),(275,125,0,1,21,4),(275,126,0,1,21,4),(275,127,0,1,21,4),(275,128,0,1,21,4),(275,129,0,1,21,4),(275,130,0,1,21,4),(275,131,0,1,21,4),(276,122,0,1,21,4),(276,123,0,1,21,4),(276,127,0,1,21,4),(276,129,0,1,21,4),(277,120,0,1,21,4),(277,121,0,1,21,4),(277,123,0,1,21,4),(277,124,0,1,21,4),(277,125,0,1,21,4),(277,126,0,1,21,4),(277,127,0,1,21,4),(278,120,0,1,21,4),(278,121,0,1,21,4),(278,122,0,1,21,4),(278,123,0,1,21,4),(278,124,0,1,21,4),(278,125,0,1,21,4),(278,127,0,1,21,4),(278,128,0,1,21,4),(278,129,0,1,21,4),(279,120,0,1,21,4),(279,122,0,1,21,4),(279,126,0,1,21,4),(279,127,0,1,21,4),(279,129,0,1,21,4),(280,132,0,1,21,4),(280,133,0,1,21,4),(280,134,0,1,21,4),(280,135,0,1,21,4),(280,136,0,1,21,4),(280,137,0,1,21,4),(280,138,0,1,21,4),(280,139,0,1,21,4),(282,132,0,1,21,4),(282,133,0,1,21,4),(282,134,0,1,21,4),(282,137,0,1,21,4),(282,138,0,1,21,4),(283,135,0,1,21,4),(283,136,0,1,21,4),(283,139,0,1,21,4),(286,140,0,1,21,4),(286,141,0,1,21,4),(286,142,0,1,21,4),(286,143,0,1,21,4),(286,144,0,1,21,4),(286,145,0,1,21,4),(286,146,0,1,21,4),(286,147,0,1,21,4),(286,148,0,1,21,4),(286,149,0,1,21,4),(286,150,0,1,21,4),(286,151,0,1,21,4),(286,152,0,1,21,4),(286,153,0,1,21,4),(286,154,0,1,21,4),(286,155,0,1,21,4),(286,156,0,1,21,4),(286,157,0,1,21,4),(286,158,0,1,21,4),(286,159,0,1,21,4),(286,160,0,1,21,4),(286,161,0,1,21,4),(286,162,0,1,21,4),(286,163,0,1,21,4),(286,164,0,1,21,4),(286,165,0,1,21,4),(286,166,0,1,21,4),(286,167,0,1,21,4),(286,168,0,1,21,4),(286,169,0,1,21,4),(286,170,0,1,21,4),(286,171,0,1,21,4),(286,172,0,1,21,4),(286,173,0,1,21,4),(286,174,0,1,21,4),(286,175,0,1,21,4),(286,176,0,1,21,4),(286,177,0,1,21,4),(286,178,0,1,21,4),(286,179,0,1,21,4),(286,180,0,1,21,4),(286,181,0,1,21,4),(286,182,0,1,21,4),(286,183,0,1,21,4),(286,184,0,1,21,4),(286,185,0,1,21,4),(286,186,0,1,21,4),(286,187,0,1,21,4),(287,188,0,1,21,4),(288,189,0,1,21,4),(288,190,0,1,21,4),(288,191,0,1,21,4),(288,192,0,1,21,4),(288,193,0,1,21,4),(288,194,0,1,21,4),(288,195,0,1,21,4),(288,196,0,1,21,4),(288,197,0,1,21,4),(288,198,0,1,21,4),(288,199,0,1,21,4),(288,200,0,1,21,4),(289,201,10000,0,21,4),(289,202,10000,0,21,4),(289,203,10000,0,21,4),(289,204,10000,0,21,4),(289,205,10000,0,21,4),(289,206,10000,0,21,4),(289,207,10000,0,21,4),(289,208,10000,0,21,4),(289,209,10000,0,21,4),(289,210,10000,0,21,4),(289,211,10000,0,21,4),(289,212,10000,0,21,4),(289,213,10000,0,21,4),(289,214,10000,0,21,4),(289,215,10000,0,21,4),(289,216,10000,0,21,4),(289,217,10000,0,21,4),(289,218,10000,0,21,4),(289,219,10000,0,21,4),(289,220,10000,0,21,4),(289,221,10000,0,21,4),(289,222,10000,0,21,4),(289,223,10000,0,21,4),(289,224,10000,0,21,4),(289,225,10000,0,21,4),(289,226,10000,0,21,4),(289,227,10000,0,21,4),(289,228,10000,0,21,4),(289,229,10000,0,21,4),(289,230,10000,0,21,4),(289,231,10000,0,21,4),(289,232,10000,0,21,4),(289,244,10000,0,21,4),(289,246,10000,0,21,4),(289,251,10000,0,21,4),(289,255,10000,0,21,4),(289,258,10000,0,21,4),(289,259,10000,0,21,4),(289,260,10000,0,21,4),(289,261,10000,0,21,4),(289,262,10000,0,21,4),(289,263,10000,0,21,4),(290,209,0,1,21,4),(290,210,0,1,21,4),(290,211,0,1,21,4),(290,212,0,1,21,4),(290,213,0,1,21,4),(290,214,0,1,21,4),(290,215,0,1,21,4),(290,216,0,1,21,4),(291,201,0,1,21,4),(291,202,0,1,21,4),(291,203,0,1,21,4),(291,204,0,1,21,4),(291,205,0,1,21,4),(291,206,0,1,21,4),(291,207,0,1,21,4),(291,208,0,1,21,4),(292,217,0,1,21,4),(292,218,0,1,21,4),(292,219,0,1,21,4),(292,220,0,1,21,4),(292,221,0,1,21,4),(292,222,0,1,21,4),(292,223,0,1,21,4),(292,224,0,1,21,4),(293,225,0,1,21,4),(293,226,0,1,21,4),(293,227,0,1,21,4),(293,228,0,1,21,4),(293,229,0,1,21,4),(293,230,0,1,21,4),(293,231,0,1,21,4),(293,232,0,1,21,4),(293,255,0,1,21,4),(293,259,0,1,21,4),(293,260,0,1,21,4),(293,261,0,1,21,4),(293,262,0,1,21,4),(293,263,0,1,21,4),(294,233,0,1,21,4),(294,234,0,1,21,4),(294,235,0,1,21,4),(294,236,0,1,21,4),(294,237,0,1,21,4),(294,238,0,1,21,4),(294,239,0,1,21,4),(294,240,0,1,21,4),(294,241,0,1,21,4),(295,244,0,1,21,4),(295,246,0,1,21,4),(295,251,0,1,21,4),(295,255,0,1,21,4),(295,258,0,1,21,4),(296,251,0,1,21,4),(296,255,0,1,21,4),(296,258,0,1,21,4),(297,246,0,1,21,4),(297,255,0,1,21,4),(297,258,0,1,21,4),(298,255,0,1,21,4),(298,258,0,1,21,4),(299,251,0,1,21,4),(299,258,0,1,21,4);
/*!40000 ALTER TABLE `catalog_category_product_index_store21` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index_store21_replica`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store21_replica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store21_replica` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `IDX_721C6AB95AB22995AF8E44317207DEF5` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_D3B5128D2707807AE149665B7613AA5C` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Product Index Store21 Replica';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index_store21_replica`
--

LOCK TABLES `catalog_category_product_index_store21_replica` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index_store21_replica` DISABLE KEYS */;
INSERT INTO `catalog_category_product_index_store21_replica` VALUES (2,1,0,1,21,4),(2,2,0,1,21,4),(2,3,0,1,21,4),(2,4,0,1,21,4),(2,5,0,1,21,4),(2,6,0,1,21,4),(2,7,0,1,21,4),(2,8,0,1,21,4),(2,9,0,1,21,4),(2,10,0,1,21,4),(2,11,0,1,21,4),(2,12,0,1,21,4),(2,13,0,1,21,4),(2,14,0,1,21,4),(2,15,0,1,21,4),(2,16,0,1,21,4),(2,17,0,1,21,4),(2,18,0,1,21,4),(2,19,0,1,21,4),(2,20,0,1,21,4),(2,21,0,1,21,4),(2,22,0,1,21,4),(2,23,0,1,21,4),(2,24,0,1,21,4),(2,25,0,1,21,4),(2,26,0,1,21,4),(2,27,0,1,21,4),(2,28,0,1,21,4),(2,29,0,1,21,4),(2,30,0,1,21,4),(2,31,0,1,21,4),(2,32,0,1,21,4),(2,33,0,1,21,4),(2,34,0,1,21,4),(2,35,0,1,21,4),(2,36,0,1,21,4),(2,37,0,1,21,4),(2,38,0,1,21,4),(2,39,0,1,21,4),(2,40,0,1,21,4),(2,41,0,1,21,4),(2,42,0,1,21,4),(2,43,0,1,21,4),(2,44,0,1,21,4),(2,45,0,1,21,4),(2,46,0,1,21,4),(2,47,0,1,21,4),(2,48,0,1,21,4),(2,49,0,1,21,4),(2,50,0,1,21,4),(2,57,0,1,21,4),(2,58,0,1,21,4),(2,59,0,1,21,4),(2,60,0,1,21,4),(2,61,0,1,21,4),(2,62,0,1,21,4),(2,63,0,1,21,4),(2,64,0,1,21,4),(2,65,0,1,21,4),(2,66,0,1,21,4),(2,68,0,1,21,4),(2,69,0,1,21,4),(2,70,0,1,21,4),(2,71,0,1,21,4),(2,72,0,1,21,4),(2,73,0,1,21,4),(2,74,0,1,21,4),(2,76,0,1,21,4),(2,77,0,1,21,4),(2,78,0,1,21,4),(2,79,0,1,21,4),(2,81,0,1,21,4),(2,82,0,1,21,4),(2,83,0,1,21,4),(2,84,0,1,21,4),(2,85,0,1,21,4),(2,86,0,1,21,4),(2,87,0,1,21,4),(2,88,0,1,21,4),(2,89,0,1,21,4),(2,90,0,1,21,4),(2,91,0,1,21,4),(2,92,0,1,21,4),(2,93,0,1,21,4),(2,94,0,1,21,4),(2,95,0,1,21,4),(2,96,0,1,21,4),(2,97,0,1,21,4),(2,98,0,1,21,4),(2,99,0,1,21,4),(2,100,0,1,21,4),(2,101,0,1,21,4),(2,102,0,1,21,4),(2,103,0,1,21,4),(2,104,0,1,21,4),(2,105,0,1,21,4),(2,106,0,1,21,4),(2,107,0,1,21,4),(2,108,0,1,21,4),(2,109,0,1,21,4),(2,110,0,1,21,4),(2,111,0,1,21,4),(2,112,0,1,21,4),(2,113,0,1,21,4),(2,114,0,1,21,4),(2,115,0,1,21,4),(2,116,0,1,21,4),(2,117,0,1,21,4),(2,118,0,1,21,4),(2,119,0,1,21,4),(2,120,0,1,21,4),(2,121,0,1,21,4),(2,122,0,1,21,4),(2,123,0,1,21,4),(2,124,0,1,21,4),(2,125,0,1,21,4),(2,126,0,1,21,4),(2,127,0,1,21,4),(2,128,0,1,21,4),(2,129,0,1,21,4),(2,130,0,1,21,4),(2,131,0,1,21,4),(2,132,0,1,21,4),(2,133,0,1,21,4),(2,134,0,1,21,4),(2,135,0,1,21,4),(2,136,0,1,21,4),(2,137,0,1,21,4),(2,138,0,1,21,4),(2,139,0,1,21,4),(2,140,0,1,21,4),(2,141,0,1,21,4),(2,142,0,1,21,4),(2,143,0,1,21,4),(2,144,0,1,21,4),(2,145,0,1,21,4),(2,146,0,1,21,4),(2,147,0,1,21,4),(2,148,0,1,21,4),(2,149,0,1,21,4),(2,150,0,1,21,4),(2,151,0,1,21,4),(2,152,0,1,21,4),(2,153,0,1,21,4),(2,154,0,1,21,4),(2,155,0,1,21,4),(2,156,0,1,21,4),(2,157,0,1,21,4),(2,158,0,1,21,4),(2,159,0,1,21,4),(2,160,0,1,21,4),(2,161,0,1,21,4),(2,162,0,1,21,4),(2,163,0,1,21,4),(2,164,0,1,21,4),(2,165,0,1,21,4),(2,166,0,1,21,4),(2,167,0,1,21,4),(2,168,0,1,21,4),(2,169,0,1,21,4),(2,170,0,1,21,4),(2,171,0,1,21,4),(2,172,0,1,21,4),(2,173,0,1,21,4),(2,174,0,1,21,4),(2,175,0,1,21,4),(2,176,0,1,21,4),(2,177,0,1,21,4),(2,178,0,1,21,4),(2,179,0,1,21,4),(2,180,0,1,21,4),(2,181,0,1,21,4),(2,182,0,1,21,4),(2,183,0,1,21,4),(2,184,0,1,21,4),(2,185,0,1,21,4),(2,186,0,1,21,4),(2,187,0,1,21,4),(2,188,0,1,21,4),(2,189,0,1,21,4),(2,190,0,1,21,4),(2,191,0,1,21,4),(2,192,0,1,21,4),(2,193,0,1,21,4),(2,194,0,1,21,4),(2,195,0,1,21,4),(2,196,0,1,21,4),(2,197,0,1,21,4),(2,198,0,1,21,4),(2,199,0,1,21,4),(2,200,0,1,21,4),(2,201,0,1,21,4),(2,202,0,1,21,4),(2,203,0,1,21,4),(2,204,0,1,21,4),(2,205,0,1,21,4),(2,206,0,1,21,4),(2,207,0,1,21,4),(2,208,0,1,21,4),(2,209,0,1,21,4),(2,210,0,1,21,4),(2,211,0,1,21,4),(2,212,0,1,21,4),(2,213,0,1,21,4),(2,214,0,1,21,4),(2,215,0,1,21,4),(2,216,0,1,21,4),(2,217,0,1,21,4),(2,218,0,1,21,4),(2,219,0,1,21,4),(2,220,0,1,21,4),(2,221,0,1,21,4),(2,222,0,1,21,4),(2,223,0,1,21,4),(2,224,0,1,21,4),(2,225,0,1,21,4),(2,226,0,1,21,4),(2,227,0,1,21,4),(2,228,0,1,21,4),(2,229,0,1,21,4),(2,230,0,1,21,4),(2,231,0,1,21,4),(2,232,0,1,21,4),(2,233,0,1,21,4),(2,234,0,1,21,4),(2,235,0,1,21,4),(2,236,0,1,21,4),(2,237,0,1,21,4),(2,238,0,1,21,4),(2,239,0,1,21,4),(2,240,0,1,21,4),(2,241,0,1,21,4),(2,244,0,1,21,4),(2,246,0,1,21,4),(2,251,0,1,21,4),(2,255,0,1,21,4),(2,258,0,1,21,4),(2,259,0,1,21,4),(2,260,0,1,21,4),(2,261,0,1,21,4),(2,262,0,1,21,4),(2,263,0,1,21,4),(3,1,0,1,21,4),(3,2,0,1,21,4),(3,3,0,1,21,4),(3,4,0,1,21,4),(3,5,0,1,21,4),(3,6,0,1,21,4),(3,7,0,1,21,4),(3,8,0,1,21,4),(3,10,0,1,21,4),(3,11,0,1,21,4),(4,12,0,1,21,4),(4,13,0,1,21,4),(4,14,0,1,21,4),(4,15,0,1,21,4),(4,16,0,1,21,4),(4,17,0,1,21,4),(4,18,0,1,21,4),(4,19,0,1,21,4),(4,36,0,1,21,4),(4,37,0,1,21,4),(4,38,0,1,21,4),(4,39,0,1,21,4),(4,40,0,1,21,4),(5,95,10000,0,21,4),(5,96,10000,0,21,4),(5,97,10000,0,21,4),(5,98,10000,0,21,4),(5,99,10000,0,21,4),(5,100,10000,0,21,4),(7,101,10000,0,21,4),(7,102,10000,0,21,4),(7,103,10000,0,21,4),(7,104,10000,0,21,4),(7,105,10000,0,21,4),(7,106,10000,0,21,4),(7,107,10000,0,21,4),(7,108,10000,0,21,4),(7,109,10000,0,21,4),(7,110,10000,0,21,4),(7,111,10000,0,21,4),(7,112,10000,0,21,4),(7,21,0,1,21,4),(7,22,0,1,21,4),(7,26,0,1,21,4),(8,61,0,1,21,4),(8,62,0,1,21,4),(8,63,0,1,21,4),(8,64,0,1,21,4),(8,65,0,1,21,4),(8,66,0,1,21,4),(11,4,10000,0,21,4),(11,89,10000,0,21,4),(11,90,10000,0,21,4),(11,91,10000,0,21,4),(11,92,10000,0,21,4),(11,93,10000,0,21,4),(11,94,10000,0,21,4),(11,28,0,1,21,4),(11,29,0,1,21,4),(11,30,0,1,21,4),(11,31,0,1,21,4),(11,32,0,1,21,4),(11,33,0,1,21,4),(11,34,0,1,21,4),(11,35,0,1,21,4),(13,21,0,1,21,4),(13,24,0,1,21,4),(13,25,0,1,21,4),(13,26,0,1,21,4),(13,27,0,1,21,4),(13,41,0,1,21,4),(13,42,0,1,21,4),(13,43,0,1,21,4),(13,44,0,1,21,4),(13,45,0,1,21,4),(13,46,0,1,21,4),(13,47,0,1,21,4),(13,48,0,1,21,4),(13,49,0,1,21,4),(15,22,10000,0,21,4),(15,23,10000,0,21,4),(16,20,0,1,21,4),(16,21,0,1,21,4),(16,22,0,1,21,4),(16,23,0,1,21,4),(16,24,0,1,21,4),(16,25,0,1,21,4),(16,26,0,1,21,4),(16,27,0,1,21,4),(16,41,0,1,21,4),(16,68,0,1,21,4),(16,69,0,1,21,4),(16,70,0,1,21,4),(16,71,0,1,21,4),(16,72,0,1,21,4),(16,73,0,1,21,4),(19,6,0,1,21,4),(19,7,0,1,21,4),(19,8,0,1,21,4),(19,10,0,1,21,4),(19,11,0,1,21,4),(27,11,0,1,21,4),(29,6,0,1,21,4),(29,8,0,1,21,4),(29,10,0,1,21,4),(30,6,0,1,21,4),(30,10,0,1,21,4),(33,7,0,1,21,4),(33,8,0,1,21,4),(33,10,0,1,21,4),(33,11,0,1,21,4),(42,7,0,1,21,4),(42,8,0,1,21,4),(42,11,0,1,21,4),(78,21,0,1,21,4),(78,26,0,1,21,4),(80,21,0,1,21,4),(80,22,0,1,21,4),(80,26,0,1,21,4),(81,26,0,1,21,4),(82,26,0,1,21,4),(83,26,0,1,21,4),(96,26,0,1,21,4),(97,26,0,1,21,4),(98,21,0,1,21,4),(98,22,0,1,21,4),(98,26,0,1,21,4),(99,18,0,1,21,4),(101,14,0,1,21,4),(101,15,0,1,21,4),(101,16,0,1,21,4),(102,12,0,1,21,4),(102,13,0,1,21,4),(102,14,0,1,21,4),(102,15,0,1,21,4),(102,16,0,1,21,4),(102,17,0,1,21,4),(102,19,0,1,21,4),(102,36,0,1,21,4),(102,37,0,1,21,4),(102,38,0,1,21,4),(102,39,0,1,21,4),(102,40,0,1,21,4),(103,18,0,1,21,4),(104,18,0,1,21,4),(105,18,0,1,21,4),(106,18,0,1,21,4),(107,18,0,1,21,4),(134,23,0,1,21,4),(135,22,0,1,21,4),(137,4,0,1,21,4),(137,28,0,1,21,4),(137,31,0,1,21,4),(137,34,0,1,21,4),(137,35,0,1,21,4),(138,28,0,1,21,4),(138,30,0,1,21,4),(138,32,0,1,21,4),(138,33,0,1,21,4),(139,28,0,1,21,4),(139,30,0,1,21,4),(139,32,0,1,21,4),(139,33,0,1,21,4),(140,28,0,1,21,4),(140,30,0,1,21,4),(140,32,0,1,21,4),(140,33,0,1,21,4),(145,1,0,1,21,4),(145,2,0,1,21,4),(145,3,0,1,21,4),(145,4,0,1,21,4),(145,5,0,1,21,4),(145,6,0,1,21,4),(145,7,0,1,21,4),(145,8,0,1,21,4),(145,9,0,1,21,4),(145,10,0,1,21,4),(145,11,0,1,21,4),(145,12,0,1,21,4),(145,13,0,1,21,4),(145,14,0,1,21,4),(145,15,0,1,21,4),(145,16,0,1,21,4),(145,17,0,1,21,4),(145,18,0,1,21,4),(145,19,0,1,21,4),(145,20,0,1,21,4),(145,21,0,1,21,4),(145,22,0,1,21,4),(145,23,0,1,21,4),(145,24,0,1,21,4),(145,25,0,1,21,4),(145,26,0,1,21,4),(145,27,0,1,21,4),(145,28,0,1,21,4),(145,29,0,1,21,4),(145,30,0,1,21,4),(145,31,0,1,21,4),(145,32,0,1,21,4),(145,33,0,1,21,4),(145,34,0,1,21,4),(145,35,0,1,21,4),(145,36,0,1,21,4),(145,37,0,1,21,4),(145,38,0,1,21,4),(145,39,0,1,21,4),(145,40,0,1,21,4),(145,41,0,1,21,4),(145,42,0,1,21,4),(145,43,0,1,21,4),(149,41,0,1,21,4),(150,50,0,1,21,4),(150,57,0,1,21,4),(150,58,0,1,21,4),(150,59,0,1,21,4),(150,60,0,1,21,4),(151,61,0,1,21,4),(151,62,0,1,21,4),(151,63,0,1,21,4),(151,64,0,1,21,4),(151,65,0,1,21,4),(151,66,0,1,21,4),(152,61,0,1,21,4),(152,63,0,1,21,4),(153,61,0,1,21,4),(153,63,0,1,21,4),(153,64,0,1,21,4),(153,65,0,1,21,4),(153,66,0,1,21,4),(154,61,0,1,21,4),(154,62,0,1,21,4),(154,64,0,1,21,4),(154,66,0,1,21,4),(155,61,0,1,21,4),(155,62,0,1,21,4),(155,64,0,1,21,4),(155,65,0,1,21,4),(155,66,0,1,21,4),(156,61,0,1,21,4),(156,62,0,1,21,4),(156,63,0,1,21,4),(156,64,0,1,21,4),(156,65,0,1,21,4),(156,66,0,1,21,4),(157,61,0,1,21,4),(157,62,0,1,21,4),(157,64,0,1,21,4),(157,65,0,1,21,4),(157,66,0,1,21,4),(158,61,0,1,21,4),(158,63,0,1,21,4),(158,64,0,1,21,4),(158,65,0,1,21,4),(158,66,0,1,21,4),(159,61,0,1,21,4),(159,62,0,1,21,4),(159,63,0,1,21,4),(159,64,0,1,21,4),(159,65,0,1,21,4),(159,66,0,1,21,4),(160,41,0,1,21,4),(160,68,0,1,21,4),(160,69,0,1,21,4),(160,70,0,1,21,4),(160,72,0,1,21,4),(160,73,0,1,21,4),(161,68,0,1,21,4),(161,69,0,1,21,4),(161,70,0,1,21,4),(161,71,0,1,21,4),(161,72,0,1,21,4),(162,68,0,1,21,4),(162,69,0,1,21,4),(162,72,0,1,21,4),(164,41,0,1,21,4),(164,70,0,1,21,4),(164,73,0,1,21,4),(166,41,0,1,21,4),(166,70,0,1,21,4),(166,73,0,1,21,4),(167,68,0,1,21,4),(167,69,0,1,21,4),(167,72,0,1,21,4),(168,71,0,1,21,4),(169,70,0,1,21,4),(171,70,0,1,21,4),(172,1,10000,0,21,4),(172,2,10000,0,21,4),(172,3,10000,0,21,4),(172,4,10000,0,21,4),(172,5,10000,0,21,4),(172,6,10000,0,21,4),(172,7,10000,0,21,4),(172,8,10000,0,21,4),(172,9,10000,0,21,4),(172,10,10000,0,21,4),(172,11,10000,0,21,4),(172,12,10000,0,21,4),(172,13,10000,0,21,4),(172,14,10000,0,21,4),(172,15,10000,0,21,4),(172,16,10000,0,21,4),(172,17,10000,0,21,4),(172,18,10000,0,21,4),(172,19,10000,0,21,4),(172,20,10000,0,21,4),(172,21,10000,0,21,4),(172,22,10000,0,21,4),(172,23,10000,0,21,4),(172,24,10000,0,21,4),(172,25,10000,0,21,4),(172,26,10000,0,21,4),(172,27,10000,0,21,4),(172,28,10000,0,21,4),(172,29,10000,0,21,4),(172,30,10000,0,21,4),(173,1,0,1,21,4),(173,2,0,1,21,4),(173,3,0,1,21,4),(173,4,0,1,21,4),(173,5,0,1,21,4),(173,6,0,1,21,4),(173,7,0,1,21,4),(173,8,0,1,21,4),(173,9,0,1,21,4),(173,10,0,1,21,4),(173,11,0,1,21,4),(173,12,0,1,21,4),(173,13,0,1,21,4),(173,14,0,1,21,4),(173,15,0,1,21,4),(173,16,0,1,21,4),(173,17,0,1,21,4),(173,18,0,1,21,4),(173,19,0,1,21,4),(173,20,0,1,21,4),(173,21,0,1,21,4),(173,22,0,1,21,4),(173,23,0,1,21,4),(173,24,0,1,21,4),(173,25,0,1,21,4),(173,26,0,1,21,4),(173,27,0,1,21,4),(173,28,0,1,21,4),(173,29,0,1,21,4),(173,30,0,1,21,4),(174,1,0,1,21,4),(174,2,0,1,21,4),(174,3,0,1,21,4),(174,4,0,1,21,4),(174,5,0,1,21,4),(174,6,0,1,21,4),(174,7,0,1,21,4),(174,8,0,1,21,4),(174,9,0,1,21,4),(174,10,0,1,21,4),(174,11,0,1,21,4),(174,12,0,1,21,4),(174,13,0,1,21,4),(174,14,0,1,21,4),(174,15,0,1,21,4),(174,16,0,1,21,4),(174,17,0,1,21,4),(174,18,0,1,21,4),(174,19,0,1,21,4),(174,20,0,1,21,4),(174,21,0,1,21,4),(174,22,0,1,21,4),(174,23,0,1,21,4),(174,24,0,1,21,4),(174,25,0,1,21,4),(174,26,0,1,21,4),(174,27,0,1,21,4),(174,28,0,1,21,4),(174,29,0,1,21,4),(174,30,0,1,21,4),(175,1,0,1,21,4),(175,2,0,1,21,4),(175,3,0,1,21,4),(175,4,0,1,21,4),(175,5,0,1,21,4),(175,6,0,1,21,4),(175,7,0,1,21,4),(175,8,0,1,21,4),(175,9,0,1,21,4),(175,10,0,1,21,4),(175,11,0,1,21,4),(175,12,0,1,21,4),(175,13,0,1,21,4),(175,14,0,1,21,4),(175,15,0,1,21,4),(175,16,0,1,21,4),(175,17,0,1,21,4),(175,18,0,1,21,4),(175,19,0,1,21,4),(175,20,0,1,21,4),(175,21,0,1,21,4),(175,22,0,1,21,4),(175,23,0,1,21,4),(175,24,0,1,21,4),(175,25,0,1,21,4),(175,26,0,1,21,4),(175,27,0,1,21,4),(175,28,0,1,21,4),(175,29,0,1,21,4),(175,30,0,1,21,4),(176,1,0,1,21,4),(176,2,0,1,21,4),(176,3,0,1,21,4),(176,4,0,1,21,4),(176,5,0,1,21,4),(176,6,0,1,21,4),(176,7,0,1,21,4),(176,8,0,1,21,4),(176,9,0,1,21,4),(176,10,0,1,21,4),(176,11,0,1,21,4),(176,12,0,1,21,4),(176,13,0,1,21,4),(176,14,0,1,21,4),(176,15,0,1,21,4),(176,16,0,1,21,4),(176,17,0,1,21,4),(176,18,0,1,21,4),(176,19,0,1,21,4),(176,20,0,1,21,4),(176,21,0,1,21,4),(176,22,0,1,21,4),(176,23,0,1,21,4),(176,24,0,1,21,4),(176,25,0,1,21,4),(176,26,0,1,21,4),(176,27,0,1,21,4),(176,28,0,1,21,4),(176,29,0,1,21,4),(176,30,0,1,21,4),(177,74,0,1,21,4),(177,76,0,1,21,4),(177,77,0,1,21,4),(177,78,0,1,21,4),(177,79,0,1,21,4),(178,74,10000,0,21,4),(178,76,10000,0,21,4),(178,77,10000,0,21,4),(178,78,10000,0,21,4),(178,79,10000,0,21,4),(178,81,10000,0,21,4),(178,82,10000,0,21,4),(178,83,10000,0,21,4),(178,84,10000,0,21,4),(178,85,10000,0,21,4),(178,86,10000,0,21,4),(178,87,10000,0,21,4),(178,88,10000,0,21,4),(178,113,10000,0,21,4),(178,114,10000,0,21,4),(178,115,10000,0,21,4),(178,116,10000,0,21,4),(178,117,10000,0,21,4),(178,118,10000,0,21,4),(178,119,10000,0,21,4),(178,120,10000,0,21,4),(178,121,10000,0,21,4),(178,122,10000,0,21,4),(178,123,10000,0,21,4),(178,124,10000,0,21,4),(178,125,10000,0,21,4),(178,126,10000,0,21,4),(178,127,10000,0,21,4),(178,128,10000,0,21,4),(178,129,10000,0,21,4),(178,130,10000,0,21,4),(178,131,10000,0,21,4),(178,132,10000,0,21,4),(178,133,10000,0,21,4),(178,134,10000,0,21,4),(178,135,10000,0,21,4),(178,136,10000,0,21,4),(178,137,10000,0,21,4),(178,138,10000,0,21,4),(178,139,10000,0,21,4),(178,140,10000,0,21,4),(178,141,10000,0,21,4),(178,142,10000,0,21,4),(178,143,10000,0,21,4),(178,144,10000,0,21,4),(178,145,10000,0,21,4),(178,146,10000,0,21,4),(178,147,10000,0,21,4),(178,148,10000,0,21,4),(178,149,10000,0,21,4),(178,150,10000,0,21,4),(178,151,10000,0,21,4),(178,152,10000,0,21,4),(178,153,10000,0,21,4),(178,154,10000,0,21,4),(178,155,10000,0,21,4),(178,156,10000,0,21,4),(178,157,10000,0,21,4),(178,158,10000,0,21,4),(178,159,10000,0,21,4),(178,160,10000,0,21,4),(178,161,10000,0,21,4),(178,162,10000,0,21,4),(178,163,10000,0,21,4),(178,164,10000,0,21,4),(178,165,10000,0,21,4),(178,166,10000,0,21,4),(178,167,10000,0,21,4),(178,168,10000,0,21,4),(178,169,10000,0,21,4),(178,170,10000,0,21,4),(178,171,10000,0,21,4),(178,172,10000,0,21,4),(178,173,10000,0,21,4),(178,174,10000,0,21,4),(178,175,10000,0,21,4),(178,176,10000,0,21,4),(178,177,10000,0,21,4),(178,178,10000,0,21,4),(178,179,10000,0,21,4),(178,180,10000,0,21,4),(178,181,10000,0,21,4),(178,182,10000,0,21,4),(178,183,10000,0,21,4),(178,184,10000,0,21,4),(178,185,10000,0,21,4),(178,186,10000,0,21,4),(178,187,10000,0,21,4),(178,188,10000,0,21,4),(178,189,10000,0,21,4),(178,190,10000,0,21,4),(178,191,10000,0,21,4),(178,192,10000,0,21,4),(178,193,10000,0,21,4),(178,194,10000,0,21,4),(178,195,10000,0,21,4),(178,196,10000,0,21,4),(178,197,10000,0,21,4),(178,198,10000,0,21,4),(178,199,10000,0,21,4),(178,200,10000,0,21,4),(178,201,10000,0,21,4),(178,202,10000,0,21,4),(178,203,10000,0,21,4),(178,204,10000,0,21,4),(178,205,10000,0,21,4),(178,206,10000,0,21,4),(178,207,10000,0,21,4),(178,208,10000,0,21,4),(178,209,10000,0,21,4),(178,210,10000,0,21,4),(178,211,10000,0,21,4),(178,212,10000,0,21,4),(178,213,10000,0,21,4),(178,214,10000,0,21,4),(178,215,10000,0,21,4),(178,216,10000,0,21,4),(178,217,10000,0,21,4),(178,218,10000,0,21,4),(178,219,10000,0,21,4),(178,220,10000,0,21,4),(178,221,10000,0,21,4),(178,222,10000,0,21,4),(178,223,10000,0,21,4),(178,224,10000,0,21,4),(178,225,10000,0,21,4),(178,226,10000,0,21,4),(178,227,10000,0,21,4),(178,228,10000,0,21,4),(178,229,10000,0,21,4),(178,230,10000,0,21,4),(178,231,10000,0,21,4),(178,232,10000,0,21,4),(178,233,10000,0,21,4),(178,234,10000,0,21,4),(178,235,10000,0,21,4),(178,236,10000,0,21,4),(178,237,10000,0,21,4),(178,238,10000,0,21,4),(178,239,10000,0,21,4),(178,240,10000,0,21,4),(178,241,10000,0,21,4),(178,244,10000,0,21,4),(178,246,10000,0,21,4),(178,251,10000,0,21,4),(178,255,10000,0,21,4),(178,258,10000,0,21,4),(178,259,10000,0,21,4),(178,260,10000,0,21,4),(178,261,10000,0,21,4),(178,262,10000,0,21,4),(178,263,10000,0,21,4),(179,81,0,1,21,4),(179,82,0,1,21,4),(179,83,0,1,21,4),(179,84,0,1,21,4),(179,85,0,1,21,4),(179,86,0,1,21,4),(179,87,0,1,21,4),(179,88,0,1,21,4),(180,81,0,1,21,4),(181,86,0,1,21,4),(182,82,0,1,21,4),(182,83,0,1,21,4),(182,84,0,1,21,4),(182,85,0,1,21,4),(182,87,0,1,21,4),(182,88,0,1,21,4),(183,82,0,1,21,4),(183,83,0,1,21,4),(183,84,0,1,21,4),(183,85,0,1,21,4),(183,86,0,1,21,4),(183,87,0,1,21,4),(183,88,0,1,21,4),(192,89,0,1,21,4),(192,90,0,1,21,4),(192,91,0,1,21,4),(192,92,0,1,21,4),(192,93,0,1,21,4),(192,94,0,1,21,4),(193,95,0,1,21,4),(193,96,0,1,21,4),(193,97,0,1,21,4),(193,98,0,1,21,4),(193,99,0,1,21,4),(193,100,0,1,21,4),(194,95,0,1,21,4),(194,96,0,1,21,4),(194,97,0,1,21,4),(194,98,0,1,21,4),(194,99,0,1,21,4),(194,100,0,1,21,4),(195,95,0,1,21,4),(195,96,0,1,21,4),(195,97,0,1,21,4),(195,98,0,1,21,4),(195,99,0,1,21,4),(195,100,0,1,21,4),(196,95,0,1,21,4),(196,96,0,1,21,4),(196,97,0,1,21,4),(196,98,0,1,21,4),(196,99,0,1,21,4),(196,100,0,1,21,4),(197,95,0,1,21,4),(197,96,0,1,21,4),(197,97,0,1,21,4),(197,98,0,1,21,4),(197,99,0,1,21,4),(197,100,0,1,21,4),(198,101,0,1,21,4),(198,109,0,1,21,4),(198,111,0,1,21,4),(198,112,0,1,21,4),(199,103,0,1,21,4),(199,110,0,1,21,4),(200,101,0,1,21,4),(200,102,0,1,21,4),(200,108,0,1,21,4),(201,104,0,1,21,4),(201,106,0,1,21,4),(202,101,0,1,21,4),(202,102,0,1,21,4),(202,103,0,1,21,4),(202,105,0,1,21,4),(202,107,0,1,21,4),(202,108,0,1,21,4),(202,110,0,1,21,4),(203,101,0,1,21,4),(203,102,0,1,21,4),(203,103,0,1,21,4),(203,104,0,1,21,4),(203,106,0,1,21,4),(203,108,0,1,21,4),(203,109,0,1,21,4),(204,101,0,1,21,4),(204,102,0,1,21,4),(204,103,0,1,21,4),(204,104,0,1,21,4),(204,105,0,1,21,4),(204,106,0,1,21,4),(204,107,0,1,21,4),(204,108,0,1,21,4),(205,101,0,1,21,4),(205,102,0,1,21,4),(205,103,0,1,21,4),(205,108,0,1,21,4),(205,109,0,1,21,4),(205,110,0,1,21,4),(205,111,0,1,21,4),(205,112,0,1,21,4),(206,113,10000,0,21,4),(206,114,10000,0,21,4),(206,115,10000,0,21,4),(206,116,10000,0,21,4),(206,117,10000,0,21,4),(206,118,10000,0,21,4),(206,119,10000,0,21,4),(207,114,0,1,21,4),(207,119,0,1,21,4),(209,114,0,1,21,4),(212,116,0,1,21,4),(212,118,0,1,21,4),(213,113,0,1,21,4),(218,117,0,1,21,4),(219,119,0,1,21,4),(220,119,0,1,21,4),(221,119,0,1,21,4),(222,114,0,1,21,4),(222,119,0,1,21,4),(223,114,0,1,21,4),(223,119,0,1,21,4),(229,113,0,1,21,4),(230,113,0,1,21,4),(231,113,0,1,21,4),(232,113,0,1,21,4),(233,113,0,1,21,4),(234,116,0,1,21,4),(234,118,0,1,21,4),(235,116,0,1,21,4),(235,118,0,1,21,4),(236,116,0,1,21,4),(236,118,0,1,21,4),(237,116,0,1,21,4),(237,118,0,1,21,4),(238,116,0,1,21,4),(238,118,0,1,21,4),(239,115,0,1,21,4),(241,115,0,1,21,4),(242,115,0,1,21,4),(243,115,0,1,21,4),(250,120,0,1,21,4),(250,121,0,1,21,4),(250,122,0,1,21,4),(250,123,0,1,21,4),(250,124,0,1,21,4),(250,125,0,1,21,4),(250,126,0,1,21,4),(250,127,0,1,21,4),(250,128,0,1,21,4),(250,129,0,1,21,4),(250,130,0,1,21,4),(250,131,0,1,21,4),(251,120,0,1,21,4),(251,121,0,1,21,4),(251,122,0,1,21,4),(251,123,0,1,21,4),(251,124,0,1,21,4),(251,125,0,1,21,4),(251,126,0,1,21,4),(251,127,0,1,21,4),(251,128,0,1,21,4),(251,129,0,1,21,4),(251,130,0,1,21,4),(251,131,0,1,21,4),(252,125,10000,0,21,4),(252,126,10000,0,21,4),(252,127,10000,0,21,4),(252,120,0,1,21,4),(252,121,0,1,21,4),(252,122,0,1,21,4),(252,123,0,1,21,4),(252,124,0,1,21,4),(252,128,0,1,21,4),(252,129,0,1,21,4),(252,131,0,1,21,4),(253,120,0,1,21,4),(253,121,0,1,21,4),(253,122,0,1,21,4),(253,123,0,1,21,4),(253,124,0,1,21,4),(253,125,0,1,21,4),(253,126,0,1,21,4),(253,127,0,1,21,4),(253,128,0,1,21,4),(253,129,0,1,21,4),(253,130,0,1,21,4),(253,131,0,1,21,4),(254,120,0,1,21,4),(254,121,0,1,21,4),(254,122,0,1,21,4),(254,123,0,1,21,4),(254,124,0,1,21,4),(254,125,0,1,21,4),(254,126,0,1,21,4),(254,127,0,1,21,4),(254,128,0,1,21,4),(254,129,0,1,21,4),(254,130,0,1,21,4),(254,131,0,1,21,4),(255,122,0,1,21,4),(255,123,0,1,21,4),(255,124,0,1,21,4),(255,125,0,1,21,4),(255,126,0,1,21,4),(255,129,0,1,21,4),(256,121,0,1,21,4),(256,122,0,1,21,4),(256,123,0,1,21,4),(256,125,0,1,21,4),(256,126,0,1,21,4),(256,127,0,1,21,4),(257,121,0,1,21,4),(257,122,0,1,21,4),(257,123,0,1,21,4),(257,125,0,1,21,4),(257,127,0,1,21,4),(257,129,0,1,21,4),(258,121,0,1,21,4),(258,122,0,1,21,4),(258,125,0,1,21,4),(258,126,0,1,21,4),(258,127,0,1,21,4),(258,129,0,1,21,4),(259,120,0,1,21,4),(259,121,0,1,21,4),(259,123,0,1,21,4),(259,128,0,1,21,4),(259,129,0,1,21,4),(260,120,0,1,21,4),(260,121,0,1,21,4),(260,122,0,1,21,4),(260,123,0,1,21,4),(260,125,0,1,21,4),(260,127,0,1,21,4),(260,128,0,1,21,4),(260,129,0,1,21,4),(261,121,0,1,21,4),(261,122,0,1,21,4),(261,125,0,1,21,4),(261,126,0,1,21,4),(261,127,0,1,21,4),(261,129,0,1,21,4),(262,125,0,1,21,4),(262,126,0,1,21,4),(263,120,0,1,21,4),(263,121,0,1,21,4),(263,122,0,1,21,4),(263,123,0,1,21,4),(263,124,0,1,21,4),(263,128,0,1,21,4),(263,129,0,1,21,4),(263,131,0,1,21,4),(264,120,0,1,21,4),(264,122,0,1,21,4),(264,123,0,1,21,4),(264,125,0,1,21,4),(264,126,0,1,21,4),(264,129,0,1,21,4),(265,121,0,1,21,4),(265,122,0,1,21,4),(265,123,0,1,21,4),(265,127,0,1,21,4),(266,123,0,1,21,4),(266,125,0,1,21,4),(266,126,0,1,21,4),(266,127,0,1,21,4),(266,129,0,1,21,4),(267,121,0,1,21,4),(267,125,0,1,21,4),(267,126,0,1,21,4),(267,127,0,1,21,4),(268,120,0,1,21,4),(268,121,0,1,21,4),(268,122,0,1,21,4),(268,123,0,1,21,4),(268,124,0,1,21,4),(268,127,0,1,21,4),(268,129,0,1,21,4),(269,122,0,1,21,4),(269,125,0,1,21,4),(269,126,0,1,21,4),(269,127,0,1,21,4),(269,129,0,1,21,4),(270,121,0,1,21,4),(270,123,0,1,21,4),(270,125,0,1,21,4),(270,126,0,1,21,4),(270,129,0,1,21,4),(271,120,0,1,21,4),(271,121,0,1,21,4),(271,122,0,1,21,4),(271,125,0,1,21,4),(271,126,0,1,21,4),(271,127,0,1,21,4),(271,129,0,1,21,4),(272,122,0,1,21,4),(272,123,0,1,21,4),(272,124,0,1,21,4),(272,125,0,1,21,4),(272,126,0,1,21,4),(272,127,0,1,21,4),(272,128,0,1,21,4),(272,129,0,1,21,4),(273,120,0,1,21,4),(273,121,0,1,21,4),(273,123,0,1,21,4),(273,126,0,1,21,4),(273,127,0,1,21,4),(274,122,0,1,21,4),(274,123,0,1,21,4),(274,125,0,1,21,4),(274,126,0,1,21,4),(274,129,0,1,21,4),(275,120,0,1,21,4),(275,121,0,1,21,4),(275,122,0,1,21,4),(275,123,0,1,21,4),(275,124,0,1,21,4),(275,125,0,1,21,4),(275,126,0,1,21,4),(275,127,0,1,21,4),(275,128,0,1,21,4),(275,129,0,1,21,4),(275,130,0,1,21,4),(275,131,0,1,21,4),(276,122,0,1,21,4),(276,123,0,1,21,4),(276,127,0,1,21,4),(276,129,0,1,21,4),(277,120,0,1,21,4),(277,121,0,1,21,4),(277,123,0,1,21,4),(277,124,0,1,21,4),(277,125,0,1,21,4),(277,126,0,1,21,4),(277,127,0,1,21,4),(278,120,0,1,21,4),(278,121,0,1,21,4),(278,122,0,1,21,4),(278,123,0,1,21,4),(278,124,0,1,21,4),(278,125,0,1,21,4),(278,127,0,1,21,4),(278,128,0,1,21,4),(278,129,0,1,21,4),(279,120,0,1,21,4),(279,122,0,1,21,4),(279,126,0,1,21,4),(279,127,0,1,21,4),(279,129,0,1,21,4),(280,132,0,1,21,4),(280,133,0,1,21,4),(280,134,0,1,21,4),(280,135,0,1,21,4),(280,136,0,1,21,4),(280,137,0,1,21,4),(280,138,0,1,21,4),(280,139,0,1,21,4),(282,132,0,1,21,4),(282,133,0,1,21,4),(282,134,0,1,21,4),(282,137,0,1,21,4),(282,138,0,1,21,4),(283,135,0,1,21,4),(283,136,0,1,21,4),(283,139,0,1,21,4),(286,140,0,1,21,4),(286,141,0,1,21,4),(286,142,0,1,21,4),(286,143,0,1,21,4),(286,144,0,1,21,4),(286,145,0,1,21,4),(286,146,0,1,21,4),(286,147,0,1,21,4),(286,148,0,1,21,4),(286,149,0,1,21,4),(286,150,0,1,21,4),(286,151,0,1,21,4),(286,152,0,1,21,4),(286,153,0,1,21,4),(286,154,0,1,21,4),(286,155,0,1,21,4),(286,156,0,1,21,4),(286,157,0,1,21,4),(286,158,0,1,21,4),(286,159,0,1,21,4),(286,160,0,1,21,4),(286,161,0,1,21,4),(286,162,0,1,21,4),(286,163,0,1,21,4),(286,164,0,1,21,4),(286,165,0,1,21,4),(286,166,0,1,21,4),(286,167,0,1,21,4),(286,168,0,1,21,4),(286,169,0,1,21,4),(286,170,0,1,21,4),(286,171,0,1,21,4),(286,172,0,1,21,4),(286,173,0,1,21,4),(286,174,0,1,21,4),(286,175,0,1,21,4),(286,176,0,1,21,4),(286,177,0,1,21,4),(286,178,0,1,21,4),(286,179,0,1,21,4),(286,180,0,1,21,4),(286,181,0,1,21,4),(286,182,0,1,21,4),(286,183,0,1,21,4),(286,184,0,1,21,4),(286,185,0,1,21,4),(286,186,0,1,21,4),(286,187,0,1,21,4),(287,188,0,1,21,4),(288,189,0,1,21,4),(288,190,0,1,21,4),(288,191,0,1,21,4),(288,192,0,1,21,4),(288,193,0,1,21,4),(288,194,0,1,21,4),(288,195,0,1,21,4),(288,196,0,1,21,4),(288,197,0,1,21,4),(288,198,0,1,21,4),(288,199,0,1,21,4),(288,200,0,1,21,4),(289,201,10000,0,21,4),(289,202,10000,0,21,4),(289,203,10000,0,21,4),(289,204,10000,0,21,4),(289,205,10000,0,21,4),(289,206,10000,0,21,4),(289,207,10000,0,21,4),(289,208,10000,0,21,4),(289,209,10000,0,21,4),(289,210,10000,0,21,4),(289,211,10000,0,21,4),(289,212,10000,0,21,4),(289,213,10000,0,21,4),(289,214,10000,0,21,4),(289,215,10000,0,21,4),(289,216,10000,0,21,4),(289,217,10000,0,21,4),(289,218,10000,0,21,4),(289,219,10000,0,21,4),(289,220,10000,0,21,4),(289,221,10000,0,21,4),(289,222,10000,0,21,4),(289,223,10000,0,21,4),(289,224,10000,0,21,4),(289,225,10000,0,21,4),(289,226,10000,0,21,4),(289,227,10000,0,21,4),(289,228,10000,0,21,4),(289,229,10000,0,21,4),(289,230,10000,0,21,4),(289,231,10000,0,21,4),(289,232,10000,0,21,4),(289,244,10000,0,21,4),(289,246,10000,0,21,4),(289,251,10000,0,21,4),(289,255,10000,0,21,4),(289,258,10000,0,21,4),(289,259,10000,0,21,4),(289,260,10000,0,21,4),(289,261,10000,0,21,4),(289,262,10000,0,21,4),(289,263,10000,0,21,4),(290,209,0,1,21,4),(290,210,0,1,21,4),(290,211,0,1,21,4),(290,212,0,1,21,4),(290,213,0,1,21,4),(290,214,0,1,21,4),(290,215,0,1,21,4),(290,216,0,1,21,4),(291,201,0,1,21,4),(291,202,0,1,21,4),(291,203,0,1,21,4),(291,204,0,1,21,4),(291,205,0,1,21,4),(291,206,0,1,21,4),(291,207,0,1,21,4),(291,208,0,1,21,4),(292,217,0,1,21,4),(292,218,0,1,21,4),(292,219,0,1,21,4),(292,220,0,1,21,4),(292,221,0,1,21,4),(292,222,0,1,21,4),(292,223,0,1,21,4),(292,224,0,1,21,4),(293,225,0,1,21,4),(293,226,0,1,21,4),(293,227,0,1,21,4),(293,228,0,1,21,4),(293,229,0,1,21,4),(293,230,0,1,21,4),(293,231,0,1,21,4),(293,232,0,1,21,4),(293,255,0,1,21,4),(293,259,0,1,21,4),(293,260,0,1,21,4),(293,261,0,1,21,4),(293,262,0,1,21,4),(293,263,0,1,21,4),(294,233,0,1,21,4),(294,234,0,1,21,4),(294,235,0,1,21,4),(294,236,0,1,21,4),(294,237,0,1,21,4),(294,238,0,1,21,4),(294,239,0,1,21,4),(294,240,0,1,21,4),(294,241,0,1,21,4),(295,244,0,1,21,4),(295,246,0,1,21,4),(295,251,0,1,21,4),(295,255,0,1,21,4),(295,258,0,1,21,4),(296,251,0,1,21,4),(296,255,0,1,21,4),(296,258,0,1,21,4),(297,246,0,1,21,4),(297,255,0,1,21,4),(297,258,0,1,21,4),(298,255,0,1,21,4),(298,258,0,1,21,4),(299,251,0,1,21,4),(299,258,0,1,21,4);
/*!40000 ALTER TABLE `catalog_category_product_index_store21_replica` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index_store22`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store22`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store22` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `IDX_E2F404E14EABD9CFCF04336B7513EBAD` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_3845002CD81D987886AD046A6FEEEBF9` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Product Index Store22';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index_store22`
--

LOCK TABLES `catalog_category_product_index_store22` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index_store22` DISABLE KEYS */;
INSERT INTO `catalog_category_product_index_store22` VALUES (2,1,0,1,22,4),(2,2,0,1,22,4),(2,3,0,1,22,4),(2,4,0,1,22,4),(2,5,0,1,22,4),(2,6,0,1,22,4),(2,7,0,1,22,4),(2,8,0,1,22,4),(2,9,0,1,22,4),(2,10,0,1,22,4),(2,11,0,1,22,4),(2,12,0,1,22,4),(2,13,0,1,22,4),(2,14,0,1,22,4),(2,15,0,1,22,4),(2,16,0,1,22,4),(2,17,0,1,22,4),(2,18,0,1,22,4),(2,19,0,1,22,4),(2,20,0,1,22,4),(2,21,0,1,22,4),(2,22,0,1,22,4),(2,23,0,1,22,4),(2,24,0,1,22,4),(2,25,0,1,22,4),(2,26,0,1,22,4),(2,27,0,1,22,4),(2,28,0,1,22,4),(2,29,0,1,22,4),(2,30,0,1,22,4),(2,31,0,1,22,4),(2,32,0,1,22,4),(2,33,0,1,22,4),(2,34,0,1,22,4),(2,35,0,1,22,4),(2,36,0,1,22,4),(2,37,0,1,22,4),(2,38,0,1,22,4),(2,39,0,1,22,4),(2,40,0,1,22,4),(2,41,0,1,22,4),(2,42,0,1,22,4),(2,43,0,1,22,4),(2,44,0,1,22,4),(2,45,0,1,22,4),(2,46,0,1,22,4),(2,47,0,1,22,4),(2,48,0,1,22,4),(2,49,0,1,22,4),(2,50,0,1,22,4),(2,57,0,1,22,4),(2,58,0,1,22,4),(2,59,0,1,22,4),(2,60,0,1,22,4),(2,61,0,1,22,4),(2,62,0,1,22,4),(2,63,0,1,22,4),(2,64,0,1,22,4),(2,65,0,1,22,4),(2,66,0,1,22,4),(2,68,0,1,22,4),(2,69,0,1,22,4),(2,70,0,1,22,4),(2,71,0,1,22,4),(2,72,0,1,22,4),(2,73,0,1,22,4),(2,74,0,1,22,4),(2,76,0,1,22,4),(2,77,0,1,22,4),(2,78,0,1,22,4),(2,79,0,1,22,4),(2,81,0,1,22,4),(2,82,0,1,22,4),(2,83,0,1,22,4),(2,84,0,1,22,4),(2,85,0,1,22,4),(2,86,0,1,22,4),(2,87,0,1,22,4),(2,88,0,1,22,4),(2,89,0,1,22,4),(2,90,0,1,22,4),(2,91,0,1,22,4),(2,92,0,1,22,4),(2,93,0,1,22,4),(2,94,0,1,22,4),(2,95,0,1,22,4),(2,96,0,1,22,4),(2,97,0,1,22,4),(2,98,0,1,22,4),(2,99,0,1,22,4),(2,100,0,1,22,4),(2,101,0,1,22,4),(2,102,0,1,22,4),(2,103,0,1,22,4),(2,104,0,1,22,4),(2,105,0,1,22,4),(2,106,0,1,22,4),(2,107,0,1,22,4),(2,108,0,1,22,4),(2,109,0,1,22,4),(2,110,0,1,22,4),(2,111,0,1,22,4),(2,112,0,1,22,4),(2,113,0,1,22,4),(2,114,0,1,22,4),(2,115,0,1,22,4),(2,116,0,1,22,4),(2,117,0,1,22,4),(2,118,0,1,22,4),(2,119,0,1,22,4),(2,120,0,1,22,4),(2,121,0,1,22,4),(2,122,0,1,22,4),(2,123,0,1,22,4),(2,124,0,1,22,4),(2,125,0,1,22,4),(2,126,0,1,22,4),(2,127,0,1,22,4),(2,128,0,1,22,4),(2,129,0,1,22,4),(2,130,0,1,22,4),(2,131,0,1,22,4),(2,132,0,1,22,4),(2,133,0,1,22,4),(2,134,0,1,22,4),(2,135,0,1,22,4),(2,136,0,1,22,4),(2,137,0,1,22,4),(2,138,0,1,22,4),(2,139,0,1,22,4),(2,140,0,1,22,4),(2,141,0,1,22,4),(2,142,0,1,22,4),(2,143,0,1,22,4),(2,144,0,1,22,4),(2,145,0,1,22,4),(2,146,0,1,22,4),(2,147,0,1,22,4),(2,148,0,1,22,4),(2,149,0,1,22,4),(2,150,0,1,22,4),(2,151,0,1,22,4),(2,152,0,1,22,4),(2,153,0,1,22,4),(2,154,0,1,22,4),(2,155,0,1,22,4),(2,156,0,1,22,4),(2,157,0,1,22,4),(2,158,0,1,22,4),(2,159,0,1,22,4),(2,160,0,1,22,4),(2,161,0,1,22,4),(2,162,0,1,22,4),(2,163,0,1,22,4),(2,164,0,1,22,4),(2,165,0,1,22,4),(2,166,0,1,22,4),(2,167,0,1,22,4),(2,168,0,1,22,4),(2,169,0,1,22,4),(2,170,0,1,22,4),(2,171,0,1,22,4),(2,172,0,1,22,4),(2,173,0,1,22,4),(2,174,0,1,22,4),(2,175,0,1,22,4),(2,176,0,1,22,4),(2,177,0,1,22,4),(2,178,0,1,22,4),(2,179,0,1,22,4),(2,180,0,1,22,4),(2,181,0,1,22,4),(2,182,0,1,22,4),(2,183,0,1,22,4),(2,184,0,1,22,4),(2,185,0,1,22,4),(2,186,0,1,22,4),(2,187,0,1,22,4),(2,188,0,1,22,4),(2,189,0,1,22,4),(2,190,0,1,22,4),(2,191,0,1,22,4),(2,192,0,1,22,4),(2,193,0,1,22,4),(2,194,0,1,22,4),(2,195,0,1,22,4),(2,196,0,1,22,4),(2,197,0,1,22,4),(2,198,0,1,22,4),(2,199,0,1,22,4),(2,200,0,1,22,4),(2,201,0,1,22,4),(2,202,0,1,22,4),(2,203,0,1,22,4),(2,204,0,1,22,4),(2,205,0,1,22,4),(2,206,0,1,22,4),(2,207,0,1,22,4),(2,208,0,1,22,4),(2,209,0,1,22,4),(2,210,0,1,22,4),(2,211,0,1,22,4),(2,212,0,1,22,4),(2,213,0,1,22,4),(2,214,0,1,22,4),(2,215,0,1,22,4),(2,216,0,1,22,4),(2,217,0,1,22,4),(2,218,0,1,22,4),(2,219,0,1,22,4),(2,220,0,1,22,4),(2,221,0,1,22,4),(2,222,0,1,22,4),(2,223,0,1,22,4),(2,224,0,1,22,4),(2,225,0,1,22,4),(2,226,0,1,22,4),(2,227,0,1,22,4),(2,228,0,1,22,4),(2,229,0,1,22,4),(2,230,0,1,22,4),(2,231,0,1,22,4),(2,232,0,1,22,4),(2,233,0,1,22,4),(2,234,0,1,22,4),(2,235,0,1,22,4),(2,236,0,1,22,4),(2,237,0,1,22,4),(2,238,0,1,22,4),(2,239,0,1,22,4),(2,240,0,1,22,4),(2,241,0,1,22,4),(2,244,0,1,22,4),(2,246,0,1,22,4),(2,251,0,1,22,4),(2,255,0,1,22,4),(2,258,0,1,22,4),(2,259,0,1,22,4),(2,260,0,1,22,4),(2,261,0,1,22,4),(2,262,0,1,22,4),(2,263,0,1,22,4),(3,1,0,1,22,4),(3,2,0,1,22,4),(3,3,0,1,22,4),(3,4,0,1,22,4),(3,5,0,1,22,4),(3,6,0,1,22,4),(3,7,0,1,22,4),(3,8,0,1,22,4),(3,10,0,1,22,4),(3,11,0,1,22,4),(4,12,0,1,22,4),(4,13,0,1,22,4),(4,14,0,1,22,4),(4,15,0,1,22,4),(4,16,0,1,22,4),(4,17,0,1,22,4),(4,18,0,1,22,4),(4,19,0,1,22,4),(4,36,0,1,22,4),(4,37,0,1,22,4),(4,38,0,1,22,4),(4,39,0,1,22,4),(4,40,0,1,22,4),(5,95,10000,0,22,4),(5,96,10000,0,22,4),(5,97,10000,0,22,4),(5,98,10000,0,22,4),(5,99,10000,0,22,4),(5,100,10000,0,22,4),(7,101,10000,0,22,4),(7,102,10000,0,22,4),(7,103,10000,0,22,4),(7,104,10000,0,22,4),(7,105,10000,0,22,4),(7,106,10000,0,22,4),(7,107,10000,0,22,4),(7,108,10000,0,22,4),(7,109,10000,0,22,4),(7,110,10000,0,22,4),(7,111,10000,0,22,4),(7,112,10000,0,22,4),(7,21,0,1,22,4),(7,22,0,1,22,4),(7,26,0,1,22,4),(8,61,0,1,22,4),(8,62,0,1,22,4),(8,63,0,1,22,4),(8,64,0,1,22,4),(8,65,0,1,22,4),(8,66,0,1,22,4),(11,4,10000,0,22,4),(11,89,10000,0,22,4),(11,90,10000,0,22,4),(11,91,10000,0,22,4),(11,92,10000,0,22,4),(11,93,10000,0,22,4),(11,94,10000,0,22,4),(11,28,0,1,22,4),(11,29,0,1,22,4),(11,30,0,1,22,4),(11,31,0,1,22,4),(11,32,0,1,22,4),(11,33,0,1,22,4),(11,34,0,1,22,4),(11,35,0,1,22,4),(13,21,0,1,22,4),(13,24,0,1,22,4),(13,25,0,1,22,4),(13,26,0,1,22,4),(13,27,0,1,22,4),(13,41,0,1,22,4),(13,42,0,1,22,4),(13,43,0,1,22,4),(13,44,0,1,22,4),(13,45,0,1,22,4),(13,46,0,1,22,4),(13,47,0,1,22,4),(13,48,0,1,22,4),(13,49,0,1,22,4),(15,22,10000,0,22,4),(15,23,10000,0,22,4),(16,20,0,1,22,4),(16,21,0,1,22,4),(16,22,0,1,22,4),(16,23,0,1,22,4),(16,24,0,1,22,4),(16,25,0,1,22,4),(16,26,0,1,22,4),(16,27,0,1,22,4),(16,41,0,1,22,4),(16,68,0,1,22,4),(16,69,0,1,22,4),(16,70,0,1,22,4),(16,71,0,1,22,4),(16,72,0,1,22,4),(16,73,0,1,22,4),(19,6,0,1,22,4),(19,7,0,1,22,4),(19,8,0,1,22,4),(19,10,0,1,22,4),(19,11,0,1,22,4),(27,11,0,1,22,4),(29,6,0,1,22,4),(29,8,0,1,22,4),(29,10,0,1,22,4),(30,6,0,1,22,4),(30,10,0,1,22,4),(33,7,0,1,22,4),(33,8,0,1,22,4),(33,10,0,1,22,4),(33,11,0,1,22,4),(42,7,0,1,22,4),(42,8,0,1,22,4),(42,11,0,1,22,4),(78,21,0,1,22,4),(78,26,0,1,22,4),(80,21,0,1,22,4),(80,22,0,1,22,4),(80,26,0,1,22,4),(81,26,0,1,22,4),(82,26,0,1,22,4),(83,26,0,1,22,4),(96,26,0,1,22,4),(97,26,0,1,22,4),(98,21,0,1,22,4),(98,22,0,1,22,4),(98,26,0,1,22,4),(99,18,0,1,22,4),(101,14,0,1,22,4),(101,15,0,1,22,4),(101,16,0,1,22,4),(102,12,0,1,22,4),(102,13,0,1,22,4),(102,14,0,1,22,4),(102,15,0,1,22,4),(102,16,0,1,22,4),(102,17,0,1,22,4),(102,19,0,1,22,4),(102,36,0,1,22,4),(102,37,0,1,22,4),(102,38,0,1,22,4),(102,39,0,1,22,4),(102,40,0,1,22,4),(103,18,0,1,22,4),(104,18,0,1,22,4),(105,18,0,1,22,4),(106,18,0,1,22,4),(107,18,0,1,22,4),(134,23,0,1,22,4),(135,22,0,1,22,4),(137,4,0,1,22,4),(137,28,0,1,22,4),(137,31,0,1,22,4),(137,34,0,1,22,4),(137,35,0,1,22,4),(138,28,0,1,22,4),(138,30,0,1,22,4),(138,32,0,1,22,4),(138,33,0,1,22,4),(139,28,0,1,22,4),(139,30,0,1,22,4),(139,32,0,1,22,4),(139,33,0,1,22,4),(140,28,0,1,22,4),(140,30,0,1,22,4),(140,32,0,1,22,4),(140,33,0,1,22,4),(145,1,0,1,22,4),(145,2,0,1,22,4),(145,3,0,1,22,4),(145,4,0,1,22,4),(145,5,0,1,22,4),(145,6,0,1,22,4),(145,7,0,1,22,4),(145,8,0,1,22,4),(145,9,0,1,22,4),(145,10,0,1,22,4),(145,11,0,1,22,4),(145,12,0,1,22,4),(145,13,0,1,22,4),(145,14,0,1,22,4),(145,15,0,1,22,4),(145,16,0,1,22,4),(145,17,0,1,22,4),(145,18,0,1,22,4),(145,19,0,1,22,4),(145,20,0,1,22,4),(145,21,0,1,22,4),(145,22,0,1,22,4),(145,23,0,1,22,4),(145,24,0,1,22,4),(145,25,0,1,22,4),(145,26,0,1,22,4),(145,27,0,1,22,4),(145,28,0,1,22,4),(145,29,0,1,22,4),(145,30,0,1,22,4),(145,31,0,1,22,4),(145,32,0,1,22,4),(145,33,0,1,22,4),(145,34,0,1,22,4),(145,35,0,1,22,4),(145,36,0,1,22,4),(145,37,0,1,22,4),(145,38,0,1,22,4),(145,39,0,1,22,4),(145,40,0,1,22,4),(145,41,0,1,22,4),(145,42,0,1,22,4),(145,43,0,1,22,4),(149,41,0,1,22,4),(150,50,0,1,22,4),(150,57,0,1,22,4),(150,58,0,1,22,4),(150,59,0,1,22,4),(150,60,0,1,22,4),(151,61,0,1,22,4),(151,62,0,1,22,4),(151,63,0,1,22,4),(151,64,0,1,22,4),(151,65,0,1,22,4),(151,66,0,1,22,4),(152,61,0,1,22,4),(152,63,0,1,22,4),(153,61,0,1,22,4),(153,63,0,1,22,4),(153,64,0,1,22,4),(153,65,0,1,22,4),(153,66,0,1,22,4),(154,61,0,1,22,4),(154,62,0,1,22,4),(154,64,0,1,22,4),(154,66,0,1,22,4),(155,61,0,1,22,4),(155,62,0,1,22,4),(155,64,0,1,22,4),(155,65,0,1,22,4),(155,66,0,1,22,4),(156,61,0,1,22,4),(156,62,0,1,22,4),(156,63,0,1,22,4),(156,64,0,1,22,4),(156,65,0,1,22,4),(156,66,0,1,22,4),(157,61,0,1,22,4),(157,62,0,1,22,4),(157,64,0,1,22,4),(157,65,0,1,22,4),(157,66,0,1,22,4),(158,61,0,1,22,4),(158,63,0,1,22,4),(158,64,0,1,22,4),(158,65,0,1,22,4),(158,66,0,1,22,4),(159,61,0,1,22,4),(159,62,0,1,22,4),(159,63,0,1,22,4),(159,64,0,1,22,4),(159,65,0,1,22,4),(159,66,0,1,22,4),(160,41,0,1,22,4),(160,68,0,1,22,4),(160,69,0,1,22,4),(160,70,0,1,22,4),(160,72,0,1,22,4),(160,73,0,1,22,4),(161,68,0,1,22,4),(161,69,0,1,22,4),(161,70,0,1,22,4),(161,71,0,1,22,4),(161,72,0,1,22,4),(162,68,0,1,22,4),(162,69,0,1,22,4),(162,72,0,1,22,4),(164,41,0,1,22,4),(164,70,0,1,22,4),(164,73,0,1,22,4),(166,41,0,1,22,4),(166,70,0,1,22,4),(166,73,0,1,22,4),(167,68,0,1,22,4),(167,69,0,1,22,4),(167,72,0,1,22,4),(168,71,0,1,22,4),(169,70,0,1,22,4),(171,70,0,1,22,4),(172,1,10000,0,22,4),(172,2,10000,0,22,4),(172,3,10000,0,22,4),(172,4,10000,0,22,4),(172,5,10000,0,22,4),(172,6,10000,0,22,4),(172,7,10000,0,22,4),(172,8,10000,0,22,4),(172,9,10000,0,22,4),(172,10,10000,0,22,4),(172,11,10000,0,22,4),(172,12,10000,0,22,4),(172,13,10000,0,22,4),(172,14,10000,0,22,4),(172,15,10000,0,22,4),(172,16,10000,0,22,4),(172,17,10000,0,22,4),(172,18,10000,0,22,4),(172,19,10000,0,22,4),(172,20,10000,0,22,4),(172,21,10000,0,22,4),(172,22,10000,0,22,4),(172,23,10000,0,22,4),(172,24,10000,0,22,4),(172,25,10000,0,22,4),(172,26,10000,0,22,4),(172,27,10000,0,22,4),(172,28,10000,0,22,4),(172,29,10000,0,22,4),(172,30,10000,0,22,4),(173,1,0,1,22,4),(173,2,0,1,22,4),(173,3,0,1,22,4),(173,4,0,1,22,4),(173,5,0,1,22,4),(173,6,0,1,22,4),(173,7,0,1,22,4),(173,8,0,1,22,4),(173,9,0,1,22,4),(173,10,0,1,22,4),(173,11,0,1,22,4),(173,12,0,1,22,4),(173,13,0,1,22,4),(173,14,0,1,22,4),(173,15,0,1,22,4),(173,16,0,1,22,4),(173,17,0,1,22,4),(173,18,0,1,22,4),(173,19,0,1,22,4),(173,20,0,1,22,4),(173,21,0,1,22,4),(173,22,0,1,22,4),(173,23,0,1,22,4),(173,24,0,1,22,4),(173,25,0,1,22,4),(173,26,0,1,22,4),(173,27,0,1,22,4),(173,28,0,1,22,4),(173,29,0,1,22,4),(173,30,0,1,22,4),(174,1,0,1,22,4),(174,2,0,1,22,4),(174,3,0,1,22,4),(174,4,0,1,22,4),(174,5,0,1,22,4),(174,6,0,1,22,4),(174,7,0,1,22,4),(174,8,0,1,22,4),(174,9,0,1,22,4),(174,10,0,1,22,4),(174,11,0,1,22,4),(174,12,0,1,22,4),(174,13,0,1,22,4),(174,14,0,1,22,4),(174,15,0,1,22,4),(174,16,0,1,22,4),(174,17,0,1,22,4),(174,18,0,1,22,4),(174,19,0,1,22,4),(174,20,0,1,22,4),(174,21,0,1,22,4),(174,22,0,1,22,4),(174,23,0,1,22,4),(174,24,0,1,22,4),(174,25,0,1,22,4),(174,26,0,1,22,4),(174,27,0,1,22,4),(174,28,0,1,22,4),(174,29,0,1,22,4),(174,30,0,1,22,4),(175,1,0,1,22,4),(175,2,0,1,22,4),(175,3,0,1,22,4),(175,4,0,1,22,4),(175,5,0,1,22,4),(175,6,0,1,22,4),(175,7,0,1,22,4),(175,8,0,1,22,4),(175,9,0,1,22,4),(175,10,0,1,22,4),(175,11,0,1,22,4),(175,12,0,1,22,4),(175,13,0,1,22,4),(175,14,0,1,22,4),(175,15,0,1,22,4),(175,16,0,1,22,4),(175,17,0,1,22,4),(175,18,0,1,22,4),(175,19,0,1,22,4),(175,20,0,1,22,4),(175,21,0,1,22,4),(175,22,0,1,22,4),(175,23,0,1,22,4),(175,24,0,1,22,4),(175,25,0,1,22,4),(175,26,0,1,22,4),(175,27,0,1,22,4),(175,28,0,1,22,4),(175,29,0,1,22,4),(175,30,0,1,22,4),(176,1,0,1,22,4),(176,2,0,1,22,4),(176,3,0,1,22,4),(176,4,0,1,22,4),(176,5,0,1,22,4),(176,6,0,1,22,4),(176,7,0,1,22,4),(176,8,0,1,22,4),(176,9,0,1,22,4),(176,10,0,1,22,4),(176,11,0,1,22,4),(176,12,0,1,22,4),(176,13,0,1,22,4),(176,14,0,1,22,4),(176,15,0,1,22,4),(176,16,0,1,22,4),(176,17,0,1,22,4),(176,18,0,1,22,4),(176,19,0,1,22,4),(176,20,0,1,22,4),(176,21,0,1,22,4),(176,22,0,1,22,4),(176,23,0,1,22,4),(176,24,0,1,22,4),(176,25,0,1,22,4),(176,26,0,1,22,4),(176,27,0,1,22,4),(176,28,0,1,22,4),(176,29,0,1,22,4),(176,30,0,1,22,4),(177,74,0,1,22,4),(177,76,0,1,22,4),(177,77,0,1,22,4),(177,78,0,1,22,4),(177,79,0,1,22,4),(178,74,10000,0,22,4),(178,76,10000,0,22,4),(178,77,10000,0,22,4),(178,78,10000,0,22,4),(178,79,10000,0,22,4),(178,81,10000,0,22,4),(178,82,10000,0,22,4),(178,83,10000,0,22,4),(178,84,10000,0,22,4),(178,85,10000,0,22,4),(178,86,10000,0,22,4),(178,87,10000,0,22,4),(178,88,10000,0,22,4),(178,113,10000,0,22,4),(178,114,10000,0,22,4),(178,115,10000,0,22,4),(178,116,10000,0,22,4),(178,117,10000,0,22,4),(178,118,10000,0,22,4),(178,119,10000,0,22,4),(178,120,10000,0,22,4),(178,121,10000,0,22,4),(178,122,10000,0,22,4),(178,123,10000,0,22,4),(178,124,10000,0,22,4),(178,125,10000,0,22,4),(178,126,10000,0,22,4),(178,127,10000,0,22,4),(178,128,10000,0,22,4),(178,129,10000,0,22,4),(178,130,10000,0,22,4),(178,131,10000,0,22,4),(178,132,10000,0,22,4),(178,133,10000,0,22,4),(178,134,10000,0,22,4),(178,135,10000,0,22,4),(178,136,10000,0,22,4),(178,137,10000,0,22,4),(178,138,10000,0,22,4),(178,139,10000,0,22,4),(178,140,10000,0,22,4),(178,141,10000,0,22,4),(178,142,10000,0,22,4),(178,143,10000,0,22,4),(178,144,10000,0,22,4),(178,145,10000,0,22,4),(178,146,10000,0,22,4),(178,147,10000,0,22,4),(178,148,10000,0,22,4),(178,149,10000,0,22,4),(178,150,10000,0,22,4),(178,151,10000,0,22,4),(178,152,10000,0,22,4),(178,153,10000,0,22,4),(178,154,10000,0,22,4),(178,155,10000,0,22,4),(178,156,10000,0,22,4),(178,157,10000,0,22,4),(178,158,10000,0,22,4),(178,159,10000,0,22,4),(178,160,10000,0,22,4),(178,161,10000,0,22,4),(178,162,10000,0,22,4),(178,163,10000,0,22,4),(178,164,10000,0,22,4),(178,165,10000,0,22,4),(178,166,10000,0,22,4),(178,167,10000,0,22,4),(178,168,10000,0,22,4),(178,169,10000,0,22,4),(178,170,10000,0,22,4),(178,171,10000,0,22,4),(178,172,10000,0,22,4),(178,173,10000,0,22,4),(178,174,10000,0,22,4),(178,175,10000,0,22,4),(178,176,10000,0,22,4),(178,177,10000,0,22,4),(178,178,10000,0,22,4),(178,179,10000,0,22,4),(178,180,10000,0,22,4),(178,181,10000,0,22,4),(178,182,10000,0,22,4),(178,183,10000,0,22,4),(178,184,10000,0,22,4),(178,185,10000,0,22,4),(178,186,10000,0,22,4),(178,187,10000,0,22,4),(178,188,10000,0,22,4),(178,189,10000,0,22,4),(178,190,10000,0,22,4),(178,191,10000,0,22,4),(178,192,10000,0,22,4),(178,193,10000,0,22,4),(178,194,10000,0,22,4),(178,195,10000,0,22,4),(178,196,10000,0,22,4),(178,197,10000,0,22,4),(178,198,10000,0,22,4),(178,199,10000,0,22,4),(178,200,10000,0,22,4),(178,201,10000,0,22,4),(178,202,10000,0,22,4),(178,203,10000,0,22,4),(178,204,10000,0,22,4),(178,205,10000,0,22,4),(178,206,10000,0,22,4),(178,207,10000,0,22,4),(178,208,10000,0,22,4),(178,209,10000,0,22,4),(178,210,10000,0,22,4),(178,211,10000,0,22,4),(178,212,10000,0,22,4),(178,213,10000,0,22,4),(178,214,10000,0,22,4),(178,215,10000,0,22,4),(178,216,10000,0,22,4),(178,217,10000,0,22,4),(178,218,10000,0,22,4),(178,219,10000,0,22,4),(178,220,10000,0,22,4),(178,221,10000,0,22,4),(178,222,10000,0,22,4),(178,223,10000,0,22,4),(178,224,10000,0,22,4),(178,225,10000,0,22,4),(178,226,10000,0,22,4),(178,227,10000,0,22,4),(178,228,10000,0,22,4),(178,229,10000,0,22,4),(178,230,10000,0,22,4),(178,231,10000,0,22,4),(178,232,10000,0,22,4),(178,233,10000,0,22,4),(178,234,10000,0,22,4),(178,235,10000,0,22,4),(178,236,10000,0,22,4),(178,237,10000,0,22,4),(178,238,10000,0,22,4),(178,239,10000,0,22,4),(178,240,10000,0,22,4),(178,241,10000,0,22,4),(178,244,10000,0,22,4),(178,246,10000,0,22,4),(178,251,10000,0,22,4),(178,255,10000,0,22,4),(178,258,10000,0,22,4),(178,259,10000,0,22,4),(178,260,10000,0,22,4),(178,261,10000,0,22,4),(178,262,10000,0,22,4),(178,263,10000,0,22,4),(179,81,0,1,22,4),(179,82,0,1,22,4),(179,83,0,1,22,4),(179,84,0,1,22,4),(179,85,0,1,22,4),(179,86,0,1,22,4),(179,87,0,1,22,4),(179,88,0,1,22,4),(180,81,0,1,22,4),(181,86,0,1,22,4),(182,82,0,1,22,4),(182,83,0,1,22,4),(182,84,0,1,22,4),(182,85,0,1,22,4),(182,87,0,1,22,4),(182,88,0,1,22,4),(183,82,0,1,22,4),(183,83,0,1,22,4),(183,84,0,1,22,4),(183,85,0,1,22,4),(183,86,0,1,22,4),(183,87,0,1,22,4),(183,88,0,1,22,4),(192,89,0,1,22,4),(192,90,0,1,22,4),(192,91,0,1,22,4),(192,92,0,1,22,4),(192,93,0,1,22,4),(192,94,0,1,22,4),(193,95,0,1,22,4),(193,96,0,1,22,4),(193,97,0,1,22,4),(193,98,0,1,22,4),(193,99,0,1,22,4),(193,100,0,1,22,4),(194,95,0,1,22,4),(194,96,0,1,22,4),(194,97,0,1,22,4),(194,98,0,1,22,4),(194,99,0,1,22,4),(194,100,0,1,22,4),(195,95,0,1,22,4),(195,96,0,1,22,4),(195,97,0,1,22,4),(195,98,0,1,22,4),(195,99,0,1,22,4),(195,100,0,1,22,4),(196,95,0,1,22,4),(196,96,0,1,22,4),(196,97,0,1,22,4),(196,98,0,1,22,4),(196,99,0,1,22,4),(196,100,0,1,22,4),(197,95,0,1,22,4),(197,96,0,1,22,4),(197,97,0,1,22,4),(197,98,0,1,22,4),(197,99,0,1,22,4),(197,100,0,1,22,4),(198,101,0,1,22,4),(198,109,0,1,22,4),(198,111,0,1,22,4),(198,112,0,1,22,4),(199,103,0,1,22,4),(199,110,0,1,22,4),(200,101,0,1,22,4),(200,102,0,1,22,4),(200,108,0,1,22,4),(201,104,0,1,22,4),(201,106,0,1,22,4),(202,101,0,1,22,4),(202,102,0,1,22,4),(202,103,0,1,22,4),(202,105,0,1,22,4),(202,107,0,1,22,4),(202,108,0,1,22,4),(202,110,0,1,22,4),(203,101,0,1,22,4),(203,102,0,1,22,4),(203,103,0,1,22,4),(203,104,0,1,22,4),(203,106,0,1,22,4),(203,108,0,1,22,4),(203,109,0,1,22,4),(204,101,0,1,22,4),(204,102,0,1,22,4),(204,103,0,1,22,4),(204,104,0,1,22,4),(204,105,0,1,22,4),(204,106,0,1,22,4),(204,107,0,1,22,4),(204,108,0,1,22,4),(205,101,0,1,22,4),(205,102,0,1,22,4),(205,103,0,1,22,4),(205,108,0,1,22,4),(205,109,0,1,22,4),(205,110,0,1,22,4),(205,111,0,1,22,4),(205,112,0,1,22,4),(206,113,10000,0,22,4),(206,114,10000,0,22,4),(206,115,10000,0,22,4),(206,116,10000,0,22,4),(206,117,10000,0,22,4),(206,118,10000,0,22,4),(206,119,10000,0,22,4),(207,114,0,1,22,4),(207,119,0,1,22,4),(209,114,0,1,22,4),(212,116,0,1,22,4),(212,118,0,1,22,4),(213,113,0,1,22,4),(218,117,0,1,22,4),(219,119,0,1,22,4),(220,119,0,1,22,4),(221,119,0,1,22,4),(222,114,0,1,22,4),(222,119,0,1,22,4),(223,114,0,1,22,4),(223,119,0,1,22,4),(229,113,0,1,22,4),(230,113,0,1,22,4),(231,113,0,1,22,4),(232,113,0,1,22,4),(233,113,0,1,22,4),(234,116,0,1,22,4),(234,118,0,1,22,4),(235,116,0,1,22,4),(235,118,0,1,22,4),(236,116,0,1,22,4),(236,118,0,1,22,4),(237,116,0,1,22,4),(237,118,0,1,22,4),(238,116,0,1,22,4),(238,118,0,1,22,4),(239,115,0,1,22,4),(241,115,0,1,22,4),(242,115,0,1,22,4),(243,115,0,1,22,4),(250,120,0,1,22,4),(250,121,0,1,22,4),(250,122,0,1,22,4),(250,123,0,1,22,4),(250,124,0,1,22,4),(250,125,0,1,22,4),(250,126,0,1,22,4),(250,127,0,1,22,4),(250,128,0,1,22,4),(250,129,0,1,22,4),(250,130,0,1,22,4),(250,131,0,1,22,4),(251,120,0,1,22,4),(251,121,0,1,22,4),(251,122,0,1,22,4),(251,123,0,1,22,4),(251,124,0,1,22,4),(251,125,0,1,22,4),(251,126,0,1,22,4),(251,127,0,1,22,4),(251,128,0,1,22,4),(251,129,0,1,22,4),(251,130,0,1,22,4),(251,131,0,1,22,4),(252,125,10000,0,22,4),(252,126,10000,0,22,4),(252,127,10000,0,22,4),(252,120,0,1,22,4),(252,121,0,1,22,4),(252,122,0,1,22,4),(252,123,0,1,22,4),(252,124,0,1,22,4),(252,128,0,1,22,4),(252,129,0,1,22,4),(252,131,0,1,22,4),(253,120,0,1,22,4),(253,121,0,1,22,4),(253,122,0,1,22,4),(253,123,0,1,22,4),(253,124,0,1,22,4),(253,125,0,1,22,4),(253,126,0,1,22,4),(253,127,0,1,22,4),(253,128,0,1,22,4),(253,129,0,1,22,4),(253,130,0,1,22,4),(253,131,0,1,22,4),(254,120,0,1,22,4),(254,121,0,1,22,4),(254,122,0,1,22,4),(254,123,0,1,22,4),(254,124,0,1,22,4),(254,125,0,1,22,4),(254,126,0,1,22,4),(254,127,0,1,22,4),(254,128,0,1,22,4),(254,129,0,1,22,4),(254,130,0,1,22,4),(254,131,0,1,22,4),(255,122,0,1,22,4),(255,123,0,1,22,4),(255,124,0,1,22,4),(255,125,0,1,22,4),(255,126,0,1,22,4),(255,129,0,1,22,4),(256,121,0,1,22,4),(256,122,0,1,22,4),(256,123,0,1,22,4),(256,125,0,1,22,4),(256,126,0,1,22,4),(256,127,0,1,22,4),(257,121,0,1,22,4),(257,122,0,1,22,4),(257,123,0,1,22,4),(257,125,0,1,22,4),(257,127,0,1,22,4),(257,129,0,1,22,4),(258,121,0,1,22,4),(258,122,0,1,22,4),(258,125,0,1,22,4),(258,126,0,1,22,4),(258,127,0,1,22,4),(258,129,0,1,22,4),(259,120,0,1,22,4),(259,121,0,1,22,4),(259,123,0,1,22,4),(259,128,0,1,22,4),(259,129,0,1,22,4),(260,120,0,1,22,4),(260,121,0,1,22,4),(260,122,0,1,22,4),(260,123,0,1,22,4),(260,125,0,1,22,4),(260,127,0,1,22,4),(260,128,0,1,22,4),(260,129,0,1,22,4),(261,121,0,1,22,4),(261,122,0,1,22,4),(261,125,0,1,22,4),(261,126,0,1,22,4),(261,127,0,1,22,4),(261,129,0,1,22,4),(262,125,0,1,22,4),(262,126,0,1,22,4),(263,120,0,1,22,4),(263,121,0,1,22,4),(263,122,0,1,22,4),(263,123,0,1,22,4),(263,124,0,1,22,4),(263,128,0,1,22,4),(263,129,0,1,22,4),(263,131,0,1,22,4),(264,120,0,1,22,4),(264,122,0,1,22,4),(264,123,0,1,22,4),(264,125,0,1,22,4),(264,126,0,1,22,4),(264,129,0,1,22,4),(265,121,0,1,22,4),(265,122,0,1,22,4),(265,123,0,1,22,4),(265,127,0,1,22,4),(266,123,0,1,22,4),(266,125,0,1,22,4),(266,126,0,1,22,4),(266,127,0,1,22,4),(266,129,0,1,22,4),(267,121,0,1,22,4),(267,125,0,1,22,4),(267,126,0,1,22,4),(267,127,0,1,22,4),(268,120,0,1,22,4),(268,121,0,1,22,4),(268,122,0,1,22,4),(268,123,0,1,22,4),(268,124,0,1,22,4),(268,127,0,1,22,4),(268,129,0,1,22,4),(269,122,0,1,22,4),(269,125,0,1,22,4),(269,126,0,1,22,4),(269,127,0,1,22,4),(269,129,0,1,22,4),(270,121,0,1,22,4),(270,123,0,1,22,4),(270,125,0,1,22,4),(270,126,0,1,22,4),(270,129,0,1,22,4),(271,120,0,1,22,4),(271,121,0,1,22,4),(271,122,0,1,22,4),(271,125,0,1,22,4),(271,126,0,1,22,4),(271,127,0,1,22,4),(271,129,0,1,22,4),(272,122,0,1,22,4),(272,123,0,1,22,4),(272,124,0,1,22,4),(272,125,0,1,22,4),(272,126,0,1,22,4),(272,127,0,1,22,4),(272,128,0,1,22,4),(272,129,0,1,22,4),(273,120,0,1,22,4),(273,121,0,1,22,4),(273,123,0,1,22,4),(273,126,0,1,22,4),(273,127,0,1,22,4),(274,122,0,1,22,4),(274,123,0,1,22,4),(274,125,0,1,22,4),(274,126,0,1,22,4),(274,129,0,1,22,4),(275,120,0,1,22,4),(275,121,0,1,22,4),(275,122,0,1,22,4),(275,123,0,1,22,4),(275,124,0,1,22,4),(275,125,0,1,22,4),(275,126,0,1,22,4),(275,127,0,1,22,4),(275,128,0,1,22,4),(275,129,0,1,22,4),(275,130,0,1,22,4),(275,131,0,1,22,4),(276,122,0,1,22,4),(276,123,0,1,22,4),(276,127,0,1,22,4),(276,129,0,1,22,4),(277,120,0,1,22,4),(277,121,0,1,22,4),(277,123,0,1,22,4),(277,124,0,1,22,4),(277,125,0,1,22,4),(277,126,0,1,22,4),(277,127,0,1,22,4),(278,120,0,1,22,4),(278,121,0,1,22,4),(278,122,0,1,22,4),(278,123,0,1,22,4),(278,124,0,1,22,4),(278,125,0,1,22,4),(278,127,0,1,22,4),(278,128,0,1,22,4),(278,129,0,1,22,4),(279,120,0,1,22,4),(279,122,0,1,22,4),(279,126,0,1,22,4),(279,127,0,1,22,4),(279,129,0,1,22,4),(280,132,0,1,22,4),(280,133,0,1,22,4),(280,134,0,1,22,4),(280,135,0,1,22,4),(280,136,0,1,22,4),(280,137,0,1,22,4),(280,138,0,1,22,4),(280,139,0,1,22,4),(282,132,0,1,22,4),(282,133,0,1,22,4),(282,134,0,1,22,4),(282,137,0,1,22,4),(282,138,0,1,22,4),(283,135,0,1,22,4),(283,136,0,1,22,4),(283,139,0,1,22,4),(286,140,0,1,22,4),(286,141,0,1,22,4),(286,142,0,1,22,4),(286,143,0,1,22,4),(286,144,0,1,22,4),(286,145,0,1,22,4),(286,146,0,1,22,4),(286,147,0,1,22,4),(286,148,0,1,22,4),(286,149,0,1,22,4),(286,150,0,1,22,4),(286,151,0,1,22,4),(286,152,0,1,22,4),(286,153,0,1,22,4),(286,154,0,1,22,4),(286,155,0,1,22,4),(286,156,0,1,22,4),(286,157,0,1,22,4),(286,158,0,1,22,4),(286,159,0,1,22,4),(286,160,0,1,22,4),(286,161,0,1,22,4),(286,162,0,1,22,4),(286,163,0,1,22,4),(286,164,0,1,22,4),(286,165,0,1,22,4),(286,166,0,1,22,4),(286,167,0,1,22,4),(286,168,0,1,22,4),(286,169,0,1,22,4),(286,170,0,1,22,4),(286,171,0,1,22,4),(286,172,0,1,22,4),(286,173,0,1,22,4),(286,174,0,1,22,4),(286,175,0,1,22,4),(286,176,0,1,22,4),(286,177,0,1,22,4),(286,178,0,1,22,4),(286,179,0,1,22,4),(286,180,0,1,22,4),(286,181,0,1,22,4),(286,182,0,1,22,4),(286,183,0,1,22,4),(286,184,0,1,22,4),(286,185,0,1,22,4),(286,186,0,1,22,4),(286,187,0,1,22,4),(287,188,0,1,22,4),(288,189,0,1,22,4),(288,190,0,1,22,4),(288,191,0,1,22,4),(288,192,0,1,22,4),(288,193,0,1,22,4),(288,194,0,1,22,4),(288,195,0,1,22,4),(288,196,0,1,22,4),(288,197,0,1,22,4),(288,198,0,1,22,4),(288,199,0,1,22,4),(288,200,0,1,22,4),(289,201,10000,0,22,4),(289,202,10000,0,22,4),(289,203,10000,0,22,4),(289,204,10000,0,22,4),(289,205,10000,0,22,4),(289,206,10000,0,22,4),(289,207,10000,0,22,4),(289,208,10000,0,22,4),(289,209,10000,0,22,4),(289,210,10000,0,22,4),(289,211,10000,0,22,4),(289,212,10000,0,22,4),(289,213,10000,0,22,4),(289,214,10000,0,22,4),(289,215,10000,0,22,4),(289,216,10000,0,22,4),(289,217,10000,0,22,4),(289,218,10000,0,22,4),(289,219,10000,0,22,4),(289,220,10000,0,22,4),(289,221,10000,0,22,4),(289,222,10000,0,22,4),(289,223,10000,0,22,4),(289,224,10000,0,22,4),(289,225,10000,0,22,4),(289,226,10000,0,22,4),(289,227,10000,0,22,4),(289,228,10000,0,22,4),(289,229,10000,0,22,4),(289,230,10000,0,22,4),(289,231,10000,0,22,4),(289,232,10000,0,22,4),(289,244,10000,0,22,4),(289,246,10000,0,22,4),(289,251,10000,0,22,4),(289,255,10000,0,22,4),(289,258,10000,0,22,4),(289,259,10000,0,22,4),(289,260,10000,0,22,4),(289,261,10000,0,22,4),(289,262,10000,0,22,4),(289,263,10000,0,22,4),(290,209,0,1,22,4),(290,210,0,1,22,4),(290,211,0,1,22,4),(290,212,0,1,22,4),(290,213,0,1,22,4),(290,214,0,1,22,4),(290,215,0,1,22,4),(290,216,0,1,22,4),(291,201,0,1,22,4),(291,202,0,1,22,4),(291,203,0,1,22,4),(291,204,0,1,22,4),(291,205,0,1,22,4),(291,206,0,1,22,4),(291,207,0,1,22,4),(291,208,0,1,22,4),(292,217,0,1,22,4),(292,218,0,1,22,4),(292,219,0,1,22,4),(292,220,0,1,22,4),(292,221,0,1,22,4),(292,222,0,1,22,4),(292,223,0,1,22,4),(292,224,0,1,22,4),(293,225,0,1,22,4),(293,226,0,1,22,4),(293,227,0,1,22,4),(293,228,0,1,22,4),(293,229,0,1,22,4),(293,230,0,1,22,4),(293,231,0,1,22,4),(293,232,0,1,22,4),(293,255,0,1,22,4),(293,259,0,1,22,4),(293,260,0,1,22,4),(293,261,0,1,22,4),(293,262,0,1,22,4),(293,263,0,1,22,4),(294,233,0,1,22,4),(294,234,0,1,22,4),(294,235,0,1,22,4),(294,236,0,1,22,4),(294,237,0,1,22,4),(294,238,0,1,22,4),(294,239,0,1,22,4),(294,240,0,1,22,4),(294,241,0,1,22,4),(295,244,0,1,22,4),(295,246,0,1,22,4),(295,251,0,1,22,4),(295,255,0,1,22,4),(295,258,0,1,22,4),(296,251,0,1,22,4),(296,255,0,1,22,4),(296,258,0,1,22,4),(297,246,0,1,22,4),(297,255,0,1,22,4),(297,258,0,1,22,4),(298,255,0,1,22,4),(298,258,0,1,22,4),(299,251,0,1,22,4),(299,258,0,1,22,4);
/*!40000 ALTER TABLE `catalog_category_product_index_store22` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index_store22_replica`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store22_replica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store22_replica` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `CAT_CTGR_PRD_IDX_STORE22_PRD_ID_STORE_ID_CTGR_ID_VISIBILITY` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_2390CABA0542B9FEE737398F3AAEFB83` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Product Index Store22 Replica';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index_store22_replica`
--

LOCK TABLES `catalog_category_product_index_store22_replica` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index_store22_replica` DISABLE KEYS */;
INSERT INTO `catalog_category_product_index_store22_replica` VALUES (2,1,0,1,22,4),(2,2,0,1,22,4),(2,3,0,1,22,4),(2,4,0,1,22,4),(2,5,0,1,22,4),(2,6,0,1,22,4),(2,7,0,1,22,4),(2,8,0,1,22,4),(2,9,0,1,22,4),(2,10,0,1,22,4),(2,11,0,1,22,4),(2,12,0,1,22,4),(2,13,0,1,22,4),(2,14,0,1,22,4),(2,15,0,1,22,4),(2,16,0,1,22,4),(2,17,0,1,22,4),(2,18,0,1,22,4),(2,19,0,1,22,4),(2,20,0,1,22,4),(2,21,0,1,22,4),(2,22,0,1,22,4),(2,23,0,1,22,4),(2,24,0,1,22,4),(2,25,0,1,22,4),(2,26,0,1,22,4),(2,27,0,1,22,4),(2,28,0,1,22,4),(2,29,0,1,22,4),(2,30,0,1,22,4),(2,31,0,1,22,4),(2,32,0,1,22,4),(2,33,0,1,22,4),(2,34,0,1,22,4),(2,35,0,1,22,4),(2,36,0,1,22,4),(2,37,0,1,22,4),(2,38,0,1,22,4),(2,39,0,1,22,4),(2,40,0,1,22,4),(2,41,0,1,22,4),(2,42,0,1,22,4),(2,43,0,1,22,4),(2,44,0,1,22,4),(2,45,0,1,22,4),(2,46,0,1,22,4),(2,47,0,1,22,4),(2,48,0,1,22,4),(2,49,0,1,22,4),(2,50,0,1,22,4),(2,57,0,1,22,4),(2,58,0,1,22,4),(2,59,0,1,22,4),(2,60,0,1,22,4),(2,61,0,1,22,4),(2,62,0,1,22,4),(2,63,0,1,22,4),(2,64,0,1,22,4),(2,65,0,1,22,4),(2,66,0,1,22,4),(2,68,0,1,22,4),(2,69,0,1,22,4),(2,70,0,1,22,4),(2,71,0,1,22,4),(2,72,0,1,22,4),(2,73,0,1,22,4),(2,74,0,1,22,4),(2,76,0,1,22,4),(2,77,0,1,22,4),(2,78,0,1,22,4),(2,79,0,1,22,4),(2,81,0,1,22,4),(2,82,0,1,22,4),(2,83,0,1,22,4),(2,84,0,1,22,4),(2,85,0,1,22,4),(2,86,0,1,22,4),(2,87,0,1,22,4),(2,88,0,1,22,4),(2,89,0,1,22,4),(2,90,0,1,22,4),(2,91,0,1,22,4),(2,92,0,1,22,4),(2,93,0,1,22,4),(2,94,0,1,22,4),(2,95,0,1,22,4),(2,96,0,1,22,4),(2,97,0,1,22,4),(2,98,0,1,22,4),(2,99,0,1,22,4),(2,100,0,1,22,4),(2,101,0,1,22,4),(2,102,0,1,22,4),(2,103,0,1,22,4),(2,104,0,1,22,4),(2,105,0,1,22,4),(2,106,0,1,22,4),(2,107,0,1,22,4),(2,108,0,1,22,4),(2,109,0,1,22,4),(2,110,0,1,22,4),(2,111,0,1,22,4),(2,112,0,1,22,4),(2,113,0,1,22,4),(2,114,0,1,22,4),(2,115,0,1,22,4),(2,116,0,1,22,4),(2,117,0,1,22,4),(2,118,0,1,22,4),(2,119,0,1,22,4),(2,120,0,1,22,4),(2,121,0,1,22,4),(2,122,0,1,22,4),(2,123,0,1,22,4),(2,124,0,1,22,4),(2,125,0,1,22,4),(2,126,0,1,22,4),(2,127,0,1,22,4),(2,128,0,1,22,4),(2,129,0,1,22,4),(2,130,0,1,22,4),(2,131,0,1,22,4),(2,132,0,1,22,4),(2,133,0,1,22,4),(2,134,0,1,22,4),(2,135,0,1,22,4),(2,136,0,1,22,4),(2,137,0,1,22,4),(2,138,0,1,22,4),(2,139,0,1,22,4),(2,140,0,1,22,4),(2,141,0,1,22,4),(2,142,0,1,22,4),(2,143,0,1,22,4),(2,144,0,1,22,4),(2,145,0,1,22,4),(2,146,0,1,22,4),(2,147,0,1,22,4),(2,148,0,1,22,4),(2,149,0,1,22,4),(2,150,0,1,22,4),(2,151,0,1,22,4),(2,152,0,1,22,4),(2,153,0,1,22,4),(2,154,0,1,22,4),(2,155,0,1,22,4),(2,156,0,1,22,4),(2,157,0,1,22,4),(2,158,0,1,22,4),(2,159,0,1,22,4),(2,160,0,1,22,4),(2,161,0,1,22,4),(2,162,0,1,22,4),(2,163,0,1,22,4),(2,164,0,1,22,4),(2,165,0,1,22,4),(2,166,0,1,22,4),(2,167,0,1,22,4),(2,168,0,1,22,4),(2,169,0,1,22,4),(2,170,0,1,22,4),(2,171,0,1,22,4),(2,172,0,1,22,4),(2,173,0,1,22,4),(2,174,0,1,22,4),(2,175,0,1,22,4),(2,176,0,1,22,4),(2,177,0,1,22,4),(2,178,0,1,22,4),(2,179,0,1,22,4),(2,180,0,1,22,4),(2,181,0,1,22,4),(2,182,0,1,22,4),(2,183,0,1,22,4),(2,184,0,1,22,4),(2,185,0,1,22,4),(2,186,0,1,22,4),(2,187,0,1,22,4),(2,188,0,1,22,4),(2,189,0,1,22,4),(2,190,0,1,22,4),(2,191,0,1,22,4),(2,192,0,1,22,4),(2,193,0,1,22,4),(2,194,0,1,22,4),(2,195,0,1,22,4),(2,196,0,1,22,4),(2,197,0,1,22,4),(2,198,0,1,22,4),(2,199,0,1,22,4),(2,200,0,1,22,4),(2,201,0,1,22,4),(2,202,0,1,22,4),(2,203,0,1,22,4),(2,204,0,1,22,4),(2,205,0,1,22,4),(2,206,0,1,22,4),(2,207,0,1,22,4),(2,208,0,1,22,4),(2,209,0,1,22,4),(2,210,0,1,22,4),(2,211,0,1,22,4),(2,212,0,1,22,4),(2,213,0,1,22,4),(2,214,0,1,22,4),(2,215,0,1,22,4),(2,216,0,1,22,4),(2,217,0,1,22,4),(2,218,0,1,22,4),(2,219,0,1,22,4),(2,220,0,1,22,4),(2,221,0,1,22,4),(2,222,0,1,22,4),(2,223,0,1,22,4),(2,224,0,1,22,4),(2,225,0,1,22,4),(2,226,0,1,22,4),(2,227,0,1,22,4),(2,228,0,1,22,4),(2,229,0,1,22,4),(2,230,0,1,22,4),(2,231,0,1,22,4),(2,232,0,1,22,4),(2,233,0,1,22,4),(2,234,0,1,22,4),(2,235,0,1,22,4),(2,236,0,1,22,4),(2,237,0,1,22,4),(2,238,0,1,22,4),(2,239,0,1,22,4),(2,240,0,1,22,4),(2,241,0,1,22,4),(2,244,0,1,22,4),(2,246,0,1,22,4),(2,251,0,1,22,4),(2,255,0,1,22,4),(2,258,0,1,22,4),(2,259,0,1,22,4),(2,260,0,1,22,4),(2,261,0,1,22,4),(2,262,0,1,22,4),(2,263,0,1,22,4),(3,1,0,1,22,4),(3,2,0,1,22,4),(3,3,0,1,22,4),(3,4,0,1,22,4),(3,5,0,1,22,4),(3,6,0,1,22,4),(3,7,0,1,22,4),(3,8,0,1,22,4),(3,10,0,1,22,4),(3,11,0,1,22,4),(4,12,0,1,22,4),(4,13,0,1,22,4),(4,14,0,1,22,4),(4,15,0,1,22,4),(4,16,0,1,22,4),(4,17,0,1,22,4),(4,18,0,1,22,4),(4,19,0,1,22,4),(4,36,0,1,22,4),(4,37,0,1,22,4),(4,38,0,1,22,4),(4,39,0,1,22,4),(4,40,0,1,22,4),(5,95,10000,0,22,4),(5,96,10000,0,22,4),(5,97,10000,0,22,4),(5,98,10000,0,22,4),(5,99,10000,0,22,4),(5,100,10000,0,22,4),(7,101,10000,0,22,4),(7,102,10000,0,22,4),(7,103,10000,0,22,4),(7,104,10000,0,22,4),(7,105,10000,0,22,4),(7,106,10000,0,22,4),(7,107,10000,0,22,4),(7,108,10000,0,22,4),(7,109,10000,0,22,4),(7,110,10000,0,22,4),(7,111,10000,0,22,4),(7,112,10000,0,22,4),(7,21,0,1,22,4),(7,22,0,1,22,4),(7,26,0,1,22,4),(8,61,0,1,22,4),(8,62,0,1,22,4),(8,63,0,1,22,4),(8,64,0,1,22,4),(8,65,0,1,22,4),(8,66,0,1,22,4),(11,4,10000,0,22,4),(11,89,10000,0,22,4),(11,90,10000,0,22,4),(11,91,10000,0,22,4),(11,92,10000,0,22,4),(11,93,10000,0,22,4),(11,94,10000,0,22,4),(11,28,0,1,22,4),(11,29,0,1,22,4),(11,30,0,1,22,4),(11,31,0,1,22,4),(11,32,0,1,22,4),(11,33,0,1,22,4),(11,34,0,1,22,4),(11,35,0,1,22,4),(13,21,0,1,22,4),(13,24,0,1,22,4),(13,25,0,1,22,4),(13,26,0,1,22,4),(13,27,0,1,22,4),(13,41,0,1,22,4),(13,42,0,1,22,4),(13,43,0,1,22,4),(13,44,0,1,22,4),(13,45,0,1,22,4),(13,46,0,1,22,4),(13,47,0,1,22,4),(13,48,0,1,22,4),(13,49,0,1,22,4),(15,22,10000,0,22,4),(15,23,10000,0,22,4),(16,20,0,1,22,4),(16,21,0,1,22,4),(16,22,0,1,22,4),(16,23,0,1,22,4),(16,24,0,1,22,4),(16,25,0,1,22,4),(16,26,0,1,22,4),(16,27,0,1,22,4),(16,41,0,1,22,4),(16,68,0,1,22,4),(16,69,0,1,22,4),(16,70,0,1,22,4),(16,71,0,1,22,4),(16,72,0,1,22,4),(16,73,0,1,22,4),(19,6,0,1,22,4),(19,7,0,1,22,4),(19,8,0,1,22,4),(19,10,0,1,22,4),(19,11,0,1,22,4),(27,11,0,1,22,4),(29,6,0,1,22,4),(29,8,0,1,22,4),(29,10,0,1,22,4),(30,6,0,1,22,4),(30,10,0,1,22,4),(33,7,0,1,22,4),(33,8,0,1,22,4),(33,10,0,1,22,4),(33,11,0,1,22,4),(42,7,0,1,22,4),(42,8,0,1,22,4),(42,11,0,1,22,4),(78,21,0,1,22,4),(78,26,0,1,22,4),(80,21,0,1,22,4),(80,22,0,1,22,4),(80,26,0,1,22,4),(81,26,0,1,22,4),(82,26,0,1,22,4),(83,26,0,1,22,4),(96,26,0,1,22,4),(97,26,0,1,22,4),(98,21,0,1,22,4),(98,22,0,1,22,4),(98,26,0,1,22,4),(99,18,0,1,22,4),(101,14,0,1,22,4),(101,15,0,1,22,4),(101,16,0,1,22,4),(102,12,0,1,22,4),(102,13,0,1,22,4),(102,14,0,1,22,4),(102,15,0,1,22,4),(102,16,0,1,22,4),(102,17,0,1,22,4),(102,19,0,1,22,4),(102,36,0,1,22,4),(102,37,0,1,22,4),(102,38,0,1,22,4),(102,39,0,1,22,4),(102,40,0,1,22,4),(103,18,0,1,22,4),(104,18,0,1,22,4),(105,18,0,1,22,4),(106,18,0,1,22,4),(107,18,0,1,22,4),(134,23,0,1,22,4),(135,22,0,1,22,4),(137,4,0,1,22,4),(137,28,0,1,22,4),(137,31,0,1,22,4),(137,34,0,1,22,4),(137,35,0,1,22,4),(138,28,0,1,22,4),(138,30,0,1,22,4),(138,32,0,1,22,4),(138,33,0,1,22,4),(139,28,0,1,22,4),(139,30,0,1,22,4),(139,32,0,1,22,4),(139,33,0,1,22,4),(140,28,0,1,22,4),(140,30,0,1,22,4),(140,32,0,1,22,4),(140,33,0,1,22,4),(145,1,0,1,22,4),(145,2,0,1,22,4),(145,3,0,1,22,4),(145,4,0,1,22,4),(145,5,0,1,22,4),(145,6,0,1,22,4),(145,7,0,1,22,4),(145,8,0,1,22,4),(145,9,0,1,22,4),(145,10,0,1,22,4),(145,11,0,1,22,4),(145,12,0,1,22,4),(145,13,0,1,22,4),(145,14,0,1,22,4),(145,15,0,1,22,4),(145,16,0,1,22,4),(145,17,0,1,22,4),(145,18,0,1,22,4),(145,19,0,1,22,4),(145,20,0,1,22,4),(145,21,0,1,22,4),(145,22,0,1,22,4),(145,23,0,1,22,4),(145,24,0,1,22,4),(145,25,0,1,22,4),(145,26,0,1,22,4),(145,27,0,1,22,4),(145,28,0,1,22,4),(145,29,0,1,22,4),(145,30,0,1,22,4),(145,31,0,1,22,4),(145,32,0,1,22,4),(145,33,0,1,22,4),(145,34,0,1,22,4),(145,35,0,1,22,4),(145,36,0,1,22,4),(145,37,0,1,22,4),(145,38,0,1,22,4),(145,39,0,1,22,4),(145,40,0,1,22,4),(145,41,0,1,22,4),(145,42,0,1,22,4),(145,43,0,1,22,4),(149,41,0,1,22,4),(150,50,0,1,22,4),(150,57,0,1,22,4),(150,58,0,1,22,4),(150,59,0,1,22,4),(150,60,0,1,22,4),(151,61,0,1,22,4),(151,62,0,1,22,4),(151,63,0,1,22,4),(151,64,0,1,22,4),(151,65,0,1,22,4),(151,66,0,1,22,4),(152,61,0,1,22,4),(152,63,0,1,22,4),(153,61,0,1,22,4),(153,63,0,1,22,4),(153,64,0,1,22,4),(153,65,0,1,22,4),(153,66,0,1,22,4),(154,61,0,1,22,4),(154,62,0,1,22,4),(154,64,0,1,22,4),(154,66,0,1,22,4),(155,61,0,1,22,4),(155,62,0,1,22,4),(155,64,0,1,22,4),(155,65,0,1,22,4),(155,66,0,1,22,4),(156,61,0,1,22,4),(156,62,0,1,22,4),(156,63,0,1,22,4),(156,64,0,1,22,4),(156,65,0,1,22,4),(156,66,0,1,22,4),(157,61,0,1,22,4),(157,62,0,1,22,4),(157,64,0,1,22,4),(157,65,0,1,22,4),(157,66,0,1,22,4),(158,61,0,1,22,4),(158,63,0,1,22,4),(158,64,0,1,22,4),(158,65,0,1,22,4),(158,66,0,1,22,4),(159,61,0,1,22,4),(159,62,0,1,22,4),(159,63,0,1,22,4),(159,64,0,1,22,4),(159,65,0,1,22,4),(159,66,0,1,22,4),(160,41,0,1,22,4),(160,68,0,1,22,4),(160,69,0,1,22,4),(160,70,0,1,22,4),(160,72,0,1,22,4),(160,73,0,1,22,4),(161,68,0,1,22,4),(161,69,0,1,22,4),(161,70,0,1,22,4),(161,71,0,1,22,4),(161,72,0,1,22,4),(162,68,0,1,22,4),(162,69,0,1,22,4),(162,72,0,1,22,4),(164,41,0,1,22,4),(164,70,0,1,22,4),(164,73,0,1,22,4),(166,41,0,1,22,4),(166,70,0,1,22,4),(166,73,0,1,22,4),(167,68,0,1,22,4),(167,69,0,1,22,4),(167,72,0,1,22,4),(168,71,0,1,22,4),(169,70,0,1,22,4),(171,70,0,1,22,4),(172,1,10000,0,22,4),(172,2,10000,0,22,4),(172,3,10000,0,22,4),(172,4,10000,0,22,4),(172,5,10000,0,22,4),(172,6,10000,0,22,4),(172,7,10000,0,22,4),(172,8,10000,0,22,4),(172,9,10000,0,22,4),(172,10,10000,0,22,4),(172,11,10000,0,22,4),(172,12,10000,0,22,4),(172,13,10000,0,22,4),(172,14,10000,0,22,4),(172,15,10000,0,22,4),(172,16,10000,0,22,4),(172,17,10000,0,22,4),(172,18,10000,0,22,4),(172,19,10000,0,22,4),(172,20,10000,0,22,4),(172,21,10000,0,22,4),(172,22,10000,0,22,4),(172,23,10000,0,22,4),(172,24,10000,0,22,4),(172,25,10000,0,22,4),(172,26,10000,0,22,4),(172,27,10000,0,22,4),(172,28,10000,0,22,4),(172,29,10000,0,22,4),(172,30,10000,0,22,4),(173,1,0,1,22,4),(173,2,0,1,22,4),(173,3,0,1,22,4),(173,4,0,1,22,4),(173,5,0,1,22,4),(173,6,0,1,22,4),(173,7,0,1,22,4),(173,8,0,1,22,4),(173,9,0,1,22,4),(173,10,0,1,22,4),(173,11,0,1,22,4),(173,12,0,1,22,4),(173,13,0,1,22,4),(173,14,0,1,22,4),(173,15,0,1,22,4),(173,16,0,1,22,4),(173,17,0,1,22,4),(173,18,0,1,22,4),(173,19,0,1,22,4),(173,20,0,1,22,4),(173,21,0,1,22,4),(173,22,0,1,22,4),(173,23,0,1,22,4),(173,24,0,1,22,4),(173,25,0,1,22,4),(173,26,0,1,22,4),(173,27,0,1,22,4),(173,28,0,1,22,4),(173,29,0,1,22,4),(173,30,0,1,22,4),(174,1,0,1,22,4),(174,2,0,1,22,4),(174,3,0,1,22,4),(174,4,0,1,22,4),(174,5,0,1,22,4),(174,6,0,1,22,4),(174,7,0,1,22,4),(174,8,0,1,22,4),(174,9,0,1,22,4),(174,10,0,1,22,4),(174,11,0,1,22,4),(174,12,0,1,22,4),(174,13,0,1,22,4),(174,14,0,1,22,4),(174,15,0,1,22,4),(174,16,0,1,22,4),(174,17,0,1,22,4),(174,18,0,1,22,4),(174,19,0,1,22,4),(174,20,0,1,22,4),(174,21,0,1,22,4),(174,22,0,1,22,4),(174,23,0,1,22,4),(174,24,0,1,22,4),(174,25,0,1,22,4),(174,26,0,1,22,4),(174,27,0,1,22,4),(174,28,0,1,22,4),(174,29,0,1,22,4),(174,30,0,1,22,4),(175,1,0,1,22,4),(175,2,0,1,22,4),(175,3,0,1,22,4),(175,4,0,1,22,4),(175,5,0,1,22,4),(175,6,0,1,22,4),(175,7,0,1,22,4),(175,8,0,1,22,4),(175,9,0,1,22,4),(175,10,0,1,22,4),(175,11,0,1,22,4),(175,12,0,1,22,4),(175,13,0,1,22,4),(175,14,0,1,22,4),(175,15,0,1,22,4),(175,16,0,1,22,4),(175,17,0,1,22,4),(175,18,0,1,22,4),(175,19,0,1,22,4),(175,20,0,1,22,4),(175,21,0,1,22,4),(175,22,0,1,22,4),(175,23,0,1,22,4),(175,24,0,1,22,4),(175,25,0,1,22,4),(175,26,0,1,22,4),(175,27,0,1,22,4),(175,28,0,1,22,4),(175,29,0,1,22,4),(175,30,0,1,22,4),(176,1,0,1,22,4),(176,2,0,1,22,4),(176,3,0,1,22,4),(176,4,0,1,22,4),(176,5,0,1,22,4),(176,6,0,1,22,4),(176,7,0,1,22,4),(176,8,0,1,22,4),(176,9,0,1,22,4),(176,10,0,1,22,4),(176,11,0,1,22,4),(176,12,0,1,22,4),(176,13,0,1,22,4),(176,14,0,1,22,4),(176,15,0,1,22,4),(176,16,0,1,22,4),(176,17,0,1,22,4),(176,18,0,1,22,4),(176,19,0,1,22,4),(176,20,0,1,22,4),(176,21,0,1,22,4),(176,22,0,1,22,4),(176,23,0,1,22,4),(176,24,0,1,22,4),(176,25,0,1,22,4),(176,26,0,1,22,4),(176,27,0,1,22,4),(176,28,0,1,22,4),(176,29,0,1,22,4),(176,30,0,1,22,4),(177,74,0,1,22,4),(177,76,0,1,22,4),(177,77,0,1,22,4),(177,78,0,1,22,4),(177,79,0,1,22,4),(178,74,10000,0,22,4),(178,76,10000,0,22,4),(178,77,10000,0,22,4),(178,78,10000,0,22,4),(178,79,10000,0,22,4),(178,81,10000,0,22,4),(178,82,10000,0,22,4),(178,83,10000,0,22,4),(178,84,10000,0,22,4),(178,85,10000,0,22,4),(178,86,10000,0,22,4),(178,87,10000,0,22,4),(178,88,10000,0,22,4),(178,113,10000,0,22,4),(178,114,10000,0,22,4),(178,115,10000,0,22,4),(178,116,10000,0,22,4),(178,117,10000,0,22,4),(178,118,10000,0,22,4),(178,119,10000,0,22,4),(178,120,10000,0,22,4),(178,121,10000,0,22,4),(178,122,10000,0,22,4),(178,123,10000,0,22,4),(178,124,10000,0,22,4),(178,125,10000,0,22,4),(178,126,10000,0,22,4),(178,127,10000,0,22,4),(178,128,10000,0,22,4),(178,129,10000,0,22,4),(178,130,10000,0,22,4),(178,131,10000,0,22,4),(178,132,10000,0,22,4),(178,133,10000,0,22,4),(178,134,10000,0,22,4),(178,135,10000,0,22,4),(178,136,10000,0,22,4),(178,137,10000,0,22,4),(178,138,10000,0,22,4),(178,139,10000,0,22,4),(178,140,10000,0,22,4),(178,141,10000,0,22,4),(178,142,10000,0,22,4),(178,143,10000,0,22,4),(178,144,10000,0,22,4),(178,145,10000,0,22,4),(178,146,10000,0,22,4),(178,147,10000,0,22,4),(178,148,10000,0,22,4),(178,149,10000,0,22,4),(178,150,10000,0,22,4),(178,151,10000,0,22,4),(178,152,10000,0,22,4),(178,153,10000,0,22,4),(178,154,10000,0,22,4),(178,155,10000,0,22,4),(178,156,10000,0,22,4),(178,157,10000,0,22,4),(178,158,10000,0,22,4),(178,159,10000,0,22,4),(178,160,10000,0,22,4),(178,161,10000,0,22,4),(178,162,10000,0,22,4),(178,163,10000,0,22,4),(178,164,10000,0,22,4),(178,165,10000,0,22,4),(178,166,10000,0,22,4),(178,167,10000,0,22,4),(178,168,10000,0,22,4),(178,169,10000,0,22,4),(178,170,10000,0,22,4),(178,171,10000,0,22,4),(178,172,10000,0,22,4),(178,173,10000,0,22,4),(178,174,10000,0,22,4),(178,175,10000,0,22,4),(178,176,10000,0,22,4),(178,177,10000,0,22,4),(178,178,10000,0,22,4),(178,179,10000,0,22,4),(178,180,10000,0,22,4),(178,181,10000,0,22,4),(178,182,10000,0,22,4),(178,183,10000,0,22,4),(178,184,10000,0,22,4),(178,185,10000,0,22,4),(178,186,10000,0,22,4),(178,187,10000,0,22,4),(178,188,10000,0,22,4),(178,189,10000,0,22,4),(178,190,10000,0,22,4),(178,191,10000,0,22,4),(178,192,10000,0,22,4),(178,193,10000,0,22,4),(178,194,10000,0,22,4),(178,195,10000,0,22,4),(178,196,10000,0,22,4),(178,197,10000,0,22,4),(178,198,10000,0,22,4),(178,199,10000,0,22,4),(178,200,10000,0,22,4),(178,201,10000,0,22,4),(178,202,10000,0,22,4),(178,203,10000,0,22,4),(178,204,10000,0,22,4),(178,205,10000,0,22,4),(178,206,10000,0,22,4),(178,207,10000,0,22,4),(178,208,10000,0,22,4),(178,209,10000,0,22,4),(178,210,10000,0,22,4),(178,211,10000,0,22,4),(178,212,10000,0,22,4),(178,213,10000,0,22,4),(178,214,10000,0,22,4),(178,215,10000,0,22,4),(178,216,10000,0,22,4),(178,217,10000,0,22,4),(178,218,10000,0,22,4),(178,219,10000,0,22,4),(178,220,10000,0,22,4),(178,221,10000,0,22,4),(178,222,10000,0,22,4),(178,223,10000,0,22,4),(178,224,10000,0,22,4),(178,225,10000,0,22,4),(178,226,10000,0,22,4),(178,227,10000,0,22,4),(178,228,10000,0,22,4),(178,229,10000,0,22,4),(178,230,10000,0,22,4),(178,231,10000,0,22,4),(178,232,10000,0,22,4),(178,233,10000,0,22,4),(178,234,10000,0,22,4),(178,235,10000,0,22,4),(178,236,10000,0,22,4),(178,237,10000,0,22,4),(178,238,10000,0,22,4),(178,239,10000,0,22,4),(178,240,10000,0,22,4),(178,241,10000,0,22,4),(178,244,10000,0,22,4),(178,246,10000,0,22,4),(178,251,10000,0,22,4),(178,255,10000,0,22,4),(178,258,10000,0,22,4),(178,259,10000,0,22,4),(178,260,10000,0,22,4),(178,261,10000,0,22,4),(178,262,10000,0,22,4),(178,263,10000,0,22,4),(179,81,0,1,22,4),(179,82,0,1,22,4),(179,83,0,1,22,4),(179,84,0,1,22,4),(179,85,0,1,22,4),(179,86,0,1,22,4),(179,87,0,1,22,4),(179,88,0,1,22,4),(180,81,0,1,22,4),(181,86,0,1,22,4),(182,82,0,1,22,4),(182,83,0,1,22,4),(182,84,0,1,22,4),(182,85,0,1,22,4),(182,87,0,1,22,4),(182,88,0,1,22,4),(183,82,0,1,22,4),(183,83,0,1,22,4),(183,84,0,1,22,4),(183,85,0,1,22,4),(183,86,0,1,22,4),(183,87,0,1,22,4),(183,88,0,1,22,4),(192,89,0,1,22,4),(192,90,0,1,22,4),(192,91,0,1,22,4),(192,92,0,1,22,4),(192,93,0,1,22,4),(192,94,0,1,22,4),(193,95,0,1,22,4),(193,96,0,1,22,4),(193,97,0,1,22,4),(193,98,0,1,22,4),(193,99,0,1,22,4),(193,100,0,1,22,4),(194,95,0,1,22,4),(194,96,0,1,22,4),(194,97,0,1,22,4),(194,98,0,1,22,4),(194,99,0,1,22,4),(194,100,0,1,22,4),(195,95,0,1,22,4),(195,96,0,1,22,4),(195,97,0,1,22,4),(195,98,0,1,22,4),(195,99,0,1,22,4),(195,100,0,1,22,4),(196,95,0,1,22,4),(196,96,0,1,22,4),(196,97,0,1,22,4),(196,98,0,1,22,4),(196,99,0,1,22,4),(196,100,0,1,22,4),(197,95,0,1,22,4),(197,96,0,1,22,4),(197,97,0,1,22,4),(197,98,0,1,22,4),(197,99,0,1,22,4),(197,100,0,1,22,4),(198,101,0,1,22,4),(198,109,0,1,22,4),(198,111,0,1,22,4),(198,112,0,1,22,4),(199,103,0,1,22,4),(199,110,0,1,22,4),(200,101,0,1,22,4),(200,102,0,1,22,4),(200,108,0,1,22,4),(201,104,0,1,22,4),(201,106,0,1,22,4),(202,101,0,1,22,4),(202,102,0,1,22,4),(202,103,0,1,22,4),(202,105,0,1,22,4),(202,107,0,1,22,4),(202,108,0,1,22,4),(202,110,0,1,22,4),(203,101,0,1,22,4),(203,102,0,1,22,4),(203,103,0,1,22,4),(203,104,0,1,22,4),(203,106,0,1,22,4),(203,108,0,1,22,4),(203,109,0,1,22,4),(204,101,0,1,22,4),(204,102,0,1,22,4),(204,103,0,1,22,4),(204,104,0,1,22,4),(204,105,0,1,22,4),(204,106,0,1,22,4),(204,107,0,1,22,4),(204,108,0,1,22,4),(205,101,0,1,22,4),(205,102,0,1,22,4),(205,103,0,1,22,4),(205,108,0,1,22,4),(205,109,0,1,22,4),(205,110,0,1,22,4),(205,111,0,1,22,4),(205,112,0,1,22,4),(206,113,10000,0,22,4),(206,114,10000,0,22,4),(206,115,10000,0,22,4),(206,116,10000,0,22,4),(206,117,10000,0,22,4),(206,118,10000,0,22,4),(206,119,10000,0,22,4),(207,114,0,1,22,4),(207,119,0,1,22,4),(209,114,0,1,22,4),(212,116,0,1,22,4),(212,118,0,1,22,4),(213,113,0,1,22,4),(218,117,0,1,22,4),(219,119,0,1,22,4),(220,119,0,1,22,4),(221,119,0,1,22,4),(222,114,0,1,22,4),(222,119,0,1,22,4),(223,114,0,1,22,4),(223,119,0,1,22,4),(229,113,0,1,22,4),(230,113,0,1,22,4),(231,113,0,1,22,4),(232,113,0,1,22,4),(233,113,0,1,22,4),(234,116,0,1,22,4),(234,118,0,1,22,4),(235,116,0,1,22,4),(235,118,0,1,22,4),(236,116,0,1,22,4),(236,118,0,1,22,4),(237,116,0,1,22,4),(237,118,0,1,22,4),(238,116,0,1,22,4),(238,118,0,1,22,4),(239,115,0,1,22,4),(241,115,0,1,22,4),(242,115,0,1,22,4),(243,115,0,1,22,4),(250,120,0,1,22,4),(250,121,0,1,22,4),(250,122,0,1,22,4),(250,123,0,1,22,4),(250,124,0,1,22,4),(250,125,0,1,22,4),(250,126,0,1,22,4),(250,127,0,1,22,4),(250,128,0,1,22,4),(250,129,0,1,22,4),(250,130,0,1,22,4),(250,131,0,1,22,4),(251,120,0,1,22,4),(251,121,0,1,22,4),(251,122,0,1,22,4),(251,123,0,1,22,4),(251,124,0,1,22,4),(251,125,0,1,22,4),(251,126,0,1,22,4),(251,127,0,1,22,4),(251,128,0,1,22,4),(251,129,0,1,22,4),(251,130,0,1,22,4),(251,131,0,1,22,4),(252,125,10000,0,22,4),(252,126,10000,0,22,4),(252,127,10000,0,22,4),(252,120,0,1,22,4),(252,121,0,1,22,4),(252,122,0,1,22,4),(252,123,0,1,22,4),(252,124,0,1,22,4),(252,128,0,1,22,4),(252,129,0,1,22,4),(252,131,0,1,22,4),(253,120,0,1,22,4),(253,121,0,1,22,4),(253,122,0,1,22,4),(253,123,0,1,22,4),(253,124,0,1,22,4),(253,125,0,1,22,4),(253,126,0,1,22,4),(253,127,0,1,22,4),(253,128,0,1,22,4),(253,129,0,1,22,4),(253,130,0,1,22,4),(253,131,0,1,22,4),(254,120,0,1,22,4),(254,121,0,1,22,4),(254,122,0,1,22,4),(254,123,0,1,22,4),(254,124,0,1,22,4),(254,125,0,1,22,4),(254,126,0,1,22,4),(254,127,0,1,22,4),(254,128,0,1,22,4),(254,129,0,1,22,4),(254,130,0,1,22,4),(254,131,0,1,22,4),(255,122,0,1,22,4),(255,123,0,1,22,4),(255,124,0,1,22,4),(255,125,0,1,22,4),(255,126,0,1,22,4),(255,129,0,1,22,4),(256,121,0,1,22,4),(256,122,0,1,22,4),(256,123,0,1,22,4),(256,125,0,1,22,4),(256,126,0,1,22,4),(256,127,0,1,22,4),(257,121,0,1,22,4),(257,122,0,1,22,4),(257,123,0,1,22,4),(257,125,0,1,22,4),(257,127,0,1,22,4),(257,129,0,1,22,4),(258,121,0,1,22,4),(258,122,0,1,22,4),(258,125,0,1,22,4),(258,126,0,1,22,4),(258,127,0,1,22,4),(258,129,0,1,22,4),(259,120,0,1,22,4),(259,121,0,1,22,4),(259,123,0,1,22,4),(259,128,0,1,22,4),(259,129,0,1,22,4),(260,120,0,1,22,4),(260,121,0,1,22,4),(260,122,0,1,22,4),(260,123,0,1,22,4),(260,125,0,1,22,4),(260,127,0,1,22,4),(260,128,0,1,22,4),(260,129,0,1,22,4),(261,121,0,1,22,4),(261,122,0,1,22,4),(261,125,0,1,22,4),(261,126,0,1,22,4),(261,127,0,1,22,4),(261,129,0,1,22,4),(262,125,0,1,22,4),(262,126,0,1,22,4),(263,120,0,1,22,4),(263,121,0,1,22,4),(263,122,0,1,22,4),(263,123,0,1,22,4),(263,124,0,1,22,4),(263,128,0,1,22,4),(263,129,0,1,22,4),(263,131,0,1,22,4),(264,120,0,1,22,4),(264,122,0,1,22,4),(264,123,0,1,22,4),(264,125,0,1,22,4),(264,126,0,1,22,4),(264,129,0,1,22,4),(265,121,0,1,22,4),(265,122,0,1,22,4),(265,123,0,1,22,4),(265,127,0,1,22,4),(266,123,0,1,22,4),(266,125,0,1,22,4),(266,126,0,1,22,4),(266,127,0,1,22,4),(266,129,0,1,22,4),(267,121,0,1,22,4),(267,125,0,1,22,4),(267,126,0,1,22,4),(267,127,0,1,22,4),(268,120,0,1,22,4),(268,121,0,1,22,4),(268,122,0,1,22,4),(268,123,0,1,22,4),(268,124,0,1,22,4),(268,127,0,1,22,4),(268,129,0,1,22,4),(269,122,0,1,22,4),(269,125,0,1,22,4),(269,126,0,1,22,4),(269,127,0,1,22,4),(269,129,0,1,22,4),(270,121,0,1,22,4),(270,123,0,1,22,4),(270,125,0,1,22,4),(270,126,0,1,22,4),(270,129,0,1,22,4),(271,120,0,1,22,4),(271,121,0,1,22,4),(271,122,0,1,22,4),(271,125,0,1,22,4),(271,126,0,1,22,4),(271,127,0,1,22,4),(271,129,0,1,22,4),(272,122,0,1,22,4),(272,123,0,1,22,4),(272,124,0,1,22,4),(272,125,0,1,22,4),(272,126,0,1,22,4),(272,127,0,1,22,4),(272,128,0,1,22,4),(272,129,0,1,22,4),(273,120,0,1,22,4),(273,121,0,1,22,4),(273,123,0,1,22,4),(273,126,0,1,22,4),(273,127,0,1,22,4),(274,122,0,1,22,4),(274,123,0,1,22,4),(274,125,0,1,22,4),(274,126,0,1,22,4),(274,129,0,1,22,4),(275,120,0,1,22,4),(275,121,0,1,22,4),(275,122,0,1,22,4),(275,123,0,1,22,4),(275,124,0,1,22,4),(275,125,0,1,22,4),(275,126,0,1,22,4),(275,127,0,1,22,4),(275,128,0,1,22,4),(275,129,0,1,22,4),(275,130,0,1,22,4),(275,131,0,1,22,4),(276,122,0,1,22,4),(276,123,0,1,22,4),(276,127,0,1,22,4),(276,129,0,1,22,4),(277,120,0,1,22,4),(277,121,0,1,22,4),(277,123,0,1,22,4),(277,124,0,1,22,4),(277,125,0,1,22,4),(277,126,0,1,22,4),(277,127,0,1,22,4),(278,120,0,1,22,4),(278,121,0,1,22,4),(278,122,0,1,22,4),(278,123,0,1,22,4),(278,124,0,1,22,4),(278,125,0,1,22,4),(278,127,0,1,22,4),(278,128,0,1,22,4),(278,129,0,1,22,4),(279,120,0,1,22,4),(279,122,0,1,22,4),(279,126,0,1,22,4),(279,127,0,1,22,4),(279,129,0,1,22,4),(280,132,0,1,22,4),(280,133,0,1,22,4),(280,134,0,1,22,4),(280,135,0,1,22,4),(280,136,0,1,22,4),(280,137,0,1,22,4),(280,138,0,1,22,4),(280,139,0,1,22,4),(282,132,0,1,22,4),(282,133,0,1,22,4),(282,134,0,1,22,4),(282,137,0,1,22,4),(282,138,0,1,22,4),(283,135,0,1,22,4),(283,136,0,1,22,4),(283,139,0,1,22,4),(286,140,0,1,22,4),(286,141,0,1,22,4),(286,142,0,1,22,4),(286,143,0,1,22,4),(286,144,0,1,22,4),(286,145,0,1,22,4),(286,146,0,1,22,4),(286,147,0,1,22,4),(286,148,0,1,22,4),(286,149,0,1,22,4),(286,150,0,1,22,4),(286,151,0,1,22,4),(286,152,0,1,22,4),(286,153,0,1,22,4),(286,154,0,1,22,4),(286,155,0,1,22,4),(286,156,0,1,22,4),(286,157,0,1,22,4),(286,158,0,1,22,4),(286,159,0,1,22,4),(286,160,0,1,22,4),(286,161,0,1,22,4),(286,162,0,1,22,4),(286,163,0,1,22,4),(286,164,0,1,22,4),(286,165,0,1,22,4),(286,166,0,1,22,4),(286,167,0,1,22,4),(286,168,0,1,22,4),(286,169,0,1,22,4),(286,170,0,1,22,4),(286,171,0,1,22,4),(286,172,0,1,22,4),(286,173,0,1,22,4),(286,174,0,1,22,4),(286,175,0,1,22,4),(286,176,0,1,22,4),(286,177,0,1,22,4),(286,178,0,1,22,4),(286,179,0,1,22,4),(286,180,0,1,22,4),(286,181,0,1,22,4),(286,182,0,1,22,4),(286,183,0,1,22,4),(286,184,0,1,22,4),(286,185,0,1,22,4),(286,186,0,1,22,4),(286,187,0,1,22,4),(287,188,0,1,22,4),(288,189,0,1,22,4),(288,190,0,1,22,4),(288,191,0,1,22,4),(288,192,0,1,22,4),(288,193,0,1,22,4),(288,194,0,1,22,4),(288,195,0,1,22,4),(288,196,0,1,22,4),(288,197,0,1,22,4),(288,198,0,1,22,4),(288,199,0,1,22,4),(288,200,0,1,22,4),(289,201,10000,0,22,4),(289,202,10000,0,22,4),(289,203,10000,0,22,4),(289,204,10000,0,22,4),(289,205,10000,0,22,4),(289,206,10000,0,22,4),(289,207,10000,0,22,4),(289,208,10000,0,22,4),(289,209,10000,0,22,4),(289,210,10000,0,22,4),(289,211,10000,0,22,4),(289,212,10000,0,22,4),(289,213,10000,0,22,4),(289,214,10000,0,22,4),(289,215,10000,0,22,4),(289,216,10000,0,22,4),(289,217,10000,0,22,4),(289,218,10000,0,22,4),(289,219,10000,0,22,4),(289,220,10000,0,22,4),(289,221,10000,0,22,4),(289,222,10000,0,22,4),(289,223,10000,0,22,4),(289,224,10000,0,22,4),(289,225,10000,0,22,4),(289,226,10000,0,22,4),(289,227,10000,0,22,4),(289,228,10000,0,22,4),(289,229,10000,0,22,4),(289,230,10000,0,22,4),(289,231,10000,0,22,4),(289,232,10000,0,22,4),(289,244,10000,0,22,4),(289,246,10000,0,22,4),(289,251,10000,0,22,4),(289,255,10000,0,22,4),(289,258,10000,0,22,4),(289,259,10000,0,22,4),(289,260,10000,0,22,4),(289,261,10000,0,22,4),(289,262,10000,0,22,4),(289,263,10000,0,22,4),(290,209,0,1,22,4),(290,210,0,1,22,4),(290,211,0,1,22,4),(290,212,0,1,22,4),(290,213,0,1,22,4),(290,214,0,1,22,4),(290,215,0,1,22,4),(290,216,0,1,22,4),(291,201,0,1,22,4),(291,202,0,1,22,4),(291,203,0,1,22,4),(291,204,0,1,22,4),(291,205,0,1,22,4),(291,206,0,1,22,4),(291,207,0,1,22,4),(291,208,0,1,22,4),(292,217,0,1,22,4),(292,218,0,1,22,4),(292,219,0,1,22,4),(292,220,0,1,22,4),(292,221,0,1,22,4),(292,222,0,1,22,4),(292,223,0,1,22,4),(292,224,0,1,22,4),(293,225,0,1,22,4),(293,226,0,1,22,4),(293,227,0,1,22,4),(293,228,0,1,22,4),(293,229,0,1,22,4),(293,230,0,1,22,4),(293,231,0,1,22,4),(293,232,0,1,22,4),(293,255,0,1,22,4),(293,259,0,1,22,4),(293,260,0,1,22,4),(293,261,0,1,22,4),(293,262,0,1,22,4),(293,263,0,1,22,4),(294,233,0,1,22,4),(294,234,0,1,22,4),(294,235,0,1,22,4),(294,236,0,1,22,4),(294,237,0,1,22,4),(294,238,0,1,22,4),(294,239,0,1,22,4),(294,240,0,1,22,4),(294,241,0,1,22,4),(295,244,0,1,22,4),(295,246,0,1,22,4),(295,251,0,1,22,4),(295,255,0,1,22,4),(295,258,0,1,22,4),(296,251,0,1,22,4),(296,255,0,1,22,4),(296,258,0,1,22,4),(297,246,0,1,22,4),(297,255,0,1,22,4),(297,258,0,1,22,4),(298,255,0,1,22,4),(298,258,0,1,22,4),(299,251,0,1,22,4),(299,258,0,1,22,4);
/*!40000 ALTER TABLE `catalog_category_product_index_store22_replica` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index_store23`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store23`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store23` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `IDX_382FE8EC99C38D003662EC35102CE874` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_D83F5A49F76A0611349B5BDDD6DC40F9` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Product Index Store23';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index_store23`
--

LOCK TABLES `catalog_category_product_index_store23` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index_store23` DISABLE KEYS */;
INSERT INTO `catalog_category_product_index_store23` VALUES (2,1,0,1,23,4),(2,2,0,1,23,4),(2,3,0,1,23,4),(2,4,0,1,23,4),(2,5,0,1,23,4),(2,6,0,1,23,4),(2,7,0,1,23,4),(2,8,0,1,23,4),(2,9,0,1,23,4),(2,10,0,1,23,4),(2,11,0,1,23,4),(2,12,0,1,23,4),(2,13,0,1,23,4),(2,14,0,1,23,4),(2,15,0,1,23,4),(2,16,0,1,23,4),(2,17,0,1,23,4),(2,18,0,1,23,4),(2,19,0,1,23,4),(2,20,0,1,23,4),(2,21,0,1,23,4),(2,22,0,1,23,4),(2,23,0,1,23,4),(2,24,0,1,23,4),(2,25,0,1,23,4),(2,26,0,1,23,4),(2,27,0,1,23,4),(2,28,0,1,23,4),(2,29,0,1,23,4),(2,30,0,1,23,4),(2,31,0,1,23,4),(2,32,0,1,23,4),(2,33,0,1,23,4),(2,34,0,1,23,4),(2,35,0,1,23,4),(2,36,0,1,23,4),(2,37,0,1,23,4),(2,38,0,1,23,4),(2,39,0,1,23,4),(2,40,0,1,23,4),(2,41,0,1,23,4),(2,42,0,1,23,4),(2,43,0,1,23,4),(2,44,0,1,23,4),(2,45,0,1,23,4),(2,46,0,1,23,4),(2,47,0,1,23,4),(2,48,0,1,23,4),(2,49,0,1,23,4),(2,50,0,1,23,4),(2,57,0,1,23,4),(2,58,0,1,23,4),(2,59,0,1,23,4),(2,60,0,1,23,4),(2,61,0,1,23,4),(2,62,0,1,23,4),(2,63,0,1,23,4),(2,64,0,1,23,4),(2,65,0,1,23,4),(2,66,0,1,23,4),(2,68,0,1,23,4),(2,69,0,1,23,4),(2,70,0,1,23,4),(2,71,0,1,23,4),(2,72,0,1,23,4),(2,73,0,1,23,4),(2,74,0,1,23,4),(2,76,0,1,23,4),(2,77,0,1,23,4),(2,78,0,1,23,4),(2,79,0,1,23,4),(2,81,0,1,23,4),(2,82,0,1,23,4),(2,83,0,1,23,4),(2,84,0,1,23,4),(2,85,0,1,23,4),(2,86,0,1,23,4),(2,87,0,1,23,4),(2,88,0,1,23,4),(2,89,0,1,23,4),(2,90,0,1,23,4),(2,91,0,1,23,4),(2,92,0,1,23,4),(2,93,0,1,23,4),(2,94,0,1,23,4),(2,95,0,1,23,4),(2,96,0,1,23,4),(2,97,0,1,23,4),(2,98,0,1,23,4),(2,99,0,1,23,4),(2,100,0,1,23,4),(2,101,0,1,23,4),(2,102,0,1,23,4),(2,103,0,1,23,4),(2,104,0,1,23,4),(2,105,0,1,23,4),(2,106,0,1,23,4),(2,107,0,1,23,4),(2,108,0,1,23,4),(2,109,0,1,23,4),(2,110,0,1,23,4),(2,111,0,1,23,4),(2,112,0,1,23,4),(2,113,0,1,23,4),(2,114,0,1,23,4),(2,115,0,1,23,4),(2,116,0,1,23,4),(2,117,0,1,23,4),(2,118,0,1,23,4),(2,119,0,1,23,4),(2,120,0,1,23,4),(2,121,0,1,23,4),(2,122,0,1,23,4),(2,123,0,1,23,4),(2,124,0,1,23,4),(2,125,0,1,23,4),(2,126,0,1,23,4),(2,127,0,1,23,4),(2,128,0,1,23,4),(2,129,0,1,23,4),(2,130,0,1,23,4),(2,131,0,1,23,4),(2,132,0,1,23,4),(2,133,0,1,23,4),(2,134,0,1,23,4),(2,135,0,1,23,4),(2,136,0,1,23,4),(2,137,0,1,23,4),(2,138,0,1,23,4),(2,139,0,1,23,4),(2,140,0,1,23,4),(2,141,0,1,23,4),(2,142,0,1,23,4),(2,143,0,1,23,4),(2,144,0,1,23,4),(2,145,0,1,23,4),(2,146,0,1,23,4),(2,147,0,1,23,4),(2,148,0,1,23,4),(2,149,0,1,23,4),(2,150,0,1,23,4),(2,151,0,1,23,4),(2,152,0,1,23,4),(2,153,0,1,23,4),(2,154,0,1,23,4),(2,155,0,1,23,4),(2,156,0,1,23,4),(2,157,0,1,23,4),(2,158,0,1,23,4),(2,159,0,1,23,4),(2,160,0,1,23,4),(2,161,0,1,23,4),(2,162,0,1,23,4),(2,163,0,1,23,4),(2,164,0,1,23,4),(2,165,0,1,23,4),(2,166,0,1,23,4),(2,167,0,1,23,4),(2,168,0,1,23,4),(2,169,0,1,23,4),(2,170,0,1,23,4),(2,171,0,1,23,4),(2,172,0,1,23,4),(2,173,0,1,23,4),(2,174,0,1,23,4),(2,175,0,1,23,4),(2,176,0,1,23,4),(2,177,0,1,23,4),(2,178,0,1,23,4),(2,179,0,1,23,4),(2,180,0,1,23,4),(2,181,0,1,23,4),(2,182,0,1,23,4),(2,183,0,1,23,4),(2,184,0,1,23,4),(2,185,0,1,23,4),(2,186,0,1,23,4),(2,187,0,1,23,4),(2,188,0,1,23,4),(2,189,0,1,23,4),(2,190,0,1,23,4),(2,191,0,1,23,4),(2,192,0,1,23,4),(2,193,0,1,23,4),(2,194,0,1,23,4),(2,195,0,1,23,4),(2,196,0,1,23,4),(2,197,0,1,23,4),(2,198,0,1,23,4),(2,199,0,1,23,4),(2,200,0,1,23,4),(2,201,0,1,23,4),(2,202,0,1,23,4),(2,203,0,1,23,4),(2,204,0,1,23,4),(2,205,0,1,23,4),(2,206,0,1,23,4),(2,207,0,1,23,4),(2,208,0,1,23,4),(2,209,0,1,23,4),(2,210,0,1,23,4),(2,211,0,1,23,4),(2,212,0,1,23,4),(2,213,0,1,23,4),(2,214,0,1,23,4),(2,215,0,1,23,4),(2,216,0,1,23,4),(2,217,0,1,23,4),(2,218,0,1,23,4),(2,219,0,1,23,4),(2,220,0,1,23,4),(2,221,0,1,23,4),(2,222,0,1,23,4),(2,223,0,1,23,4),(2,224,0,1,23,4),(2,225,0,1,23,4),(2,226,0,1,23,4),(2,227,0,1,23,4),(2,228,0,1,23,4),(2,229,0,1,23,4),(2,230,0,1,23,4),(2,231,0,1,23,4),(2,232,0,1,23,4),(2,233,0,1,23,4),(2,234,0,1,23,4),(2,235,0,1,23,4),(2,236,0,1,23,4),(2,237,0,1,23,4),(2,238,0,1,23,4),(2,239,0,1,23,4),(2,240,0,1,23,4),(2,241,0,1,23,4),(2,244,0,1,23,4),(2,246,0,1,23,4),(2,251,0,1,23,4),(2,255,0,1,23,4),(2,258,0,1,23,4),(2,259,0,1,23,4),(2,260,0,1,23,4),(2,261,0,1,23,4),(2,262,0,1,23,4),(2,263,0,1,23,4),(3,1,0,1,23,4),(3,2,0,1,23,4),(3,3,0,1,23,4),(3,4,0,1,23,4),(3,5,0,1,23,4),(3,6,0,1,23,4),(3,7,0,1,23,4),(3,8,0,1,23,4),(3,10,0,1,23,4),(3,11,0,1,23,4),(4,12,0,1,23,4),(4,13,0,1,23,4),(4,14,0,1,23,4),(4,15,0,1,23,4),(4,16,0,1,23,4),(4,17,0,1,23,4),(4,18,0,1,23,4),(4,19,0,1,23,4),(4,36,0,1,23,4),(4,37,0,1,23,4),(4,38,0,1,23,4),(4,39,0,1,23,4),(4,40,0,1,23,4),(5,95,10000,0,23,4),(5,96,10000,0,23,4),(5,97,10000,0,23,4),(5,98,10000,0,23,4),(5,99,10000,0,23,4),(5,100,10000,0,23,4),(7,101,10000,0,23,4),(7,102,10000,0,23,4),(7,103,10000,0,23,4),(7,104,10000,0,23,4),(7,105,10000,0,23,4),(7,106,10000,0,23,4),(7,107,10000,0,23,4),(7,108,10000,0,23,4),(7,109,10000,0,23,4),(7,110,10000,0,23,4),(7,111,10000,0,23,4),(7,112,10000,0,23,4),(7,21,0,1,23,4),(7,22,0,1,23,4),(7,26,0,1,23,4),(8,61,0,1,23,4),(8,62,0,1,23,4),(8,63,0,1,23,4),(8,64,0,1,23,4),(8,65,0,1,23,4),(8,66,0,1,23,4),(11,4,10000,0,23,4),(11,89,10000,0,23,4),(11,90,10000,0,23,4),(11,91,10000,0,23,4),(11,92,10000,0,23,4),(11,93,10000,0,23,4),(11,94,10000,0,23,4),(11,28,0,1,23,4),(11,29,0,1,23,4),(11,30,0,1,23,4),(11,31,0,1,23,4),(11,32,0,1,23,4),(11,33,0,1,23,4),(11,34,0,1,23,4),(11,35,0,1,23,4),(13,21,0,1,23,4),(13,24,0,1,23,4),(13,25,0,1,23,4),(13,26,0,1,23,4),(13,27,0,1,23,4),(13,41,0,1,23,4),(13,42,0,1,23,4),(13,43,0,1,23,4),(13,44,0,1,23,4),(13,45,0,1,23,4),(13,46,0,1,23,4),(13,47,0,1,23,4),(13,48,0,1,23,4),(13,49,0,1,23,4),(15,22,10000,0,23,4),(15,23,10000,0,23,4),(16,20,0,1,23,4),(16,21,0,1,23,4),(16,22,0,1,23,4),(16,23,0,1,23,4),(16,24,0,1,23,4),(16,25,0,1,23,4),(16,26,0,1,23,4),(16,27,0,1,23,4),(16,41,0,1,23,4),(16,68,0,1,23,4),(16,69,0,1,23,4),(16,70,0,1,23,4),(16,71,0,1,23,4),(16,72,0,1,23,4),(16,73,0,1,23,4),(19,6,0,1,23,4),(19,7,0,1,23,4),(19,8,0,1,23,4),(19,10,0,1,23,4),(19,11,0,1,23,4),(27,11,0,1,23,4),(29,6,0,1,23,4),(29,8,0,1,23,4),(29,10,0,1,23,4),(30,6,0,1,23,4),(30,10,0,1,23,4),(33,7,0,1,23,4),(33,8,0,1,23,4),(33,10,0,1,23,4),(33,11,0,1,23,4),(42,7,0,1,23,4),(42,8,0,1,23,4),(42,11,0,1,23,4),(78,21,0,1,23,4),(78,26,0,1,23,4),(80,21,0,1,23,4),(80,22,0,1,23,4),(80,26,0,1,23,4),(81,26,0,1,23,4),(82,26,0,1,23,4),(83,26,0,1,23,4),(96,26,0,1,23,4),(97,26,0,1,23,4),(98,21,0,1,23,4),(98,22,0,1,23,4),(98,26,0,1,23,4),(99,18,0,1,23,4),(101,14,0,1,23,4),(101,15,0,1,23,4),(101,16,0,1,23,4),(102,12,0,1,23,4),(102,13,0,1,23,4),(102,14,0,1,23,4),(102,15,0,1,23,4),(102,16,0,1,23,4),(102,17,0,1,23,4),(102,19,0,1,23,4),(102,36,0,1,23,4),(102,37,0,1,23,4),(102,38,0,1,23,4),(102,39,0,1,23,4),(102,40,0,1,23,4),(103,18,0,1,23,4),(104,18,0,1,23,4),(105,18,0,1,23,4),(106,18,0,1,23,4),(107,18,0,1,23,4),(134,23,0,1,23,4),(135,22,0,1,23,4),(137,4,0,1,23,4),(137,28,0,1,23,4),(137,31,0,1,23,4),(137,34,0,1,23,4),(137,35,0,1,23,4),(138,28,0,1,23,4),(138,30,0,1,23,4),(138,32,0,1,23,4),(138,33,0,1,23,4),(139,28,0,1,23,4),(139,30,0,1,23,4),(139,32,0,1,23,4),(139,33,0,1,23,4),(140,28,0,1,23,4),(140,30,0,1,23,4),(140,32,0,1,23,4),(140,33,0,1,23,4),(145,1,0,1,23,4),(145,2,0,1,23,4),(145,3,0,1,23,4),(145,4,0,1,23,4),(145,5,0,1,23,4),(145,6,0,1,23,4),(145,7,0,1,23,4),(145,8,0,1,23,4),(145,9,0,1,23,4),(145,10,0,1,23,4),(145,11,0,1,23,4),(145,12,0,1,23,4),(145,13,0,1,23,4),(145,14,0,1,23,4),(145,15,0,1,23,4),(145,16,0,1,23,4),(145,17,0,1,23,4),(145,18,0,1,23,4),(145,19,0,1,23,4),(145,20,0,1,23,4),(145,21,0,1,23,4),(145,22,0,1,23,4),(145,23,0,1,23,4),(145,24,0,1,23,4),(145,25,0,1,23,4),(145,26,0,1,23,4),(145,27,0,1,23,4),(145,28,0,1,23,4),(145,29,0,1,23,4),(145,30,0,1,23,4),(145,31,0,1,23,4),(145,32,0,1,23,4),(145,33,0,1,23,4),(145,34,0,1,23,4),(145,35,0,1,23,4),(145,36,0,1,23,4),(145,37,0,1,23,4),(145,38,0,1,23,4),(145,39,0,1,23,4),(145,40,0,1,23,4),(145,41,0,1,23,4),(145,42,0,1,23,4),(145,43,0,1,23,4),(149,41,0,1,23,4),(150,50,0,1,23,4),(150,57,0,1,23,4),(150,58,0,1,23,4),(150,59,0,1,23,4),(150,60,0,1,23,4),(151,61,0,1,23,4),(151,62,0,1,23,4),(151,63,0,1,23,4),(151,64,0,1,23,4),(151,65,0,1,23,4),(151,66,0,1,23,4),(152,61,0,1,23,4),(152,63,0,1,23,4),(153,61,0,1,23,4),(153,63,0,1,23,4),(153,64,0,1,23,4),(153,65,0,1,23,4),(153,66,0,1,23,4),(154,61,0,1,23,4),(154,62,0,1,23,4),(154,64,0,1,23,4),(154,66,0,1,23,4),(155,61,0,1,23,4),(155,62,0,1,23,4),(155,64,0,1,23,4),(155,65,0,1,23,4),(155,66,0,1,23,4),(156,61,0,1,23,4),(156,62,0,1,23,4),(156,63,0,1,23,4),(156,64,0,1,23,4),(156,65,0,1,23,4),(156,66,0,1,23,4),(157,61,0,1,23,4),(157,62,0,1,23,4),(157,64,0,1,23,4),(157,65,0,1,23,4),(157,66,0,1,23,4),(158,61,0,1,23,4),(158,63,0,1,23,4),(158,64,0,1,23,4),(158,65,0,1,23,4),(158,66,0,1,23,4),(159,61,0,1,23,4),(159,62,0,1,23,4),(159,63,0,1,23,4),(159,64,0,1,23,4),(159,65,0,1,23,4),(159,66,0,1,23,4),(160,41,0,1,23,4),(160,68,0,1,23,4),(160,69,0,1,23,4),(160,70,0,1,23,4),(160,72,0,1,23,4),(160,73,0,1,23,4),(161,68,0,1,23,4),(161,69,0,1,23,4),(161,70,0,1,23,4),(161,71,0,1,23,4),(161,72,0,1,23,4),(162,68,0,1,23,4),(162,69,0,1,23,4),(162,72,0,1,23,4),(164,41,0,1,23,4),(164,70,0,1,23,4),(164,73,0,1,23,4),(166,41,0,1,23,4),(166,70,0,1,23,4),(166,73,0,1,23,4),(167,68,0,1,23,4),(167,69,0,1,23,4),(167,72,0,1,23,4),(168,71,0,1,23,4),(169,70,0,1,23,4),(171,70,0,1,23,4),(172,1,10000,0,23,4),(172,2,10000,0,23,4),(172,3,10000,0,23,4),(172,4,10000,0,23,4),(172,5,10000,0,23,4),(172,6,10000,0,23,4),(172,7,10000,0,23,4),(172,8,10000,0,23,4),(172,9,10000,0,23,4),(172,10,10000,0,23,4),(172,11,10000,0,23,4),(172,12,10000,0,23,4),(172,13,10000,0,23,4),(172,14,10000,0,23,4),(172,15,10000,0,23,4),(172,16,10000,0,23,4),(172,17,10000,0,23,4),(172,18,10000,0,23,4),(172,19,10000,0,23,4),(172,20,10000,0,23,4),