require.config({"config": {
        "jsbuild":{"Magento_PageBuilder/js/content-type/tabs/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jquery\", \"knockout\", \"mage/translate\", \"Magento_PageBuilder/js/events\", \"tabs\", \"underscore\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type-factory\", \"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/content-type-menu/option\", \"Magento_PageBuilder/js/utils/delay-until\", \"Magento_PageBuilder/js/utils/promise-deferred\", \"Magento_PageBuilder/js/content-type/preview-collection\"], function (_jquery, _knockout, _translate, _events, _tabs, _underscore, _config, _contentTypeFactory, _hideShowOption, _option, _delayUntil, _promiseDeferred, _previewCollection) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_previewCollection2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _previewCollection2);\n\n    /**\n     * @param {ContentTypeCollectionInterface} contentType\n     * @param {ContentTypeConfigInterface} config\n     * @param {ObservableUpdater} observableUpdater\n     */\n    function Preview(contentType, config, observableUpdater) {\n      var _this;\n\n      _this = _previewCollection2.call(this, contentType, config, observableUpdater) || this; // Wait for the tabs instance to mount and the container to be ready\n\n      _this.focusedTab = _knockout.observable(null);\n      _this.activeTab = _knockout.observable(0);\n      _this.onContainerRenderDeferred = (0, _promiseDeferred)();\n      _this.mountAfterDeferred = (0, _promiseDeferred)();\n      Promise.all([_this.onContainerRenderDeferred.promise, _this.mountAfterDeferred.promise]).then(function (_ref) {\n        var element = _ref[0],\n            expectedChildren = _ref[1];\n        // We always create 1 tab when dropping tabs into the instance\n        expectedChildren = expectedChildren || 1; // Wait until all children's DOM elements are present before building the tabs instance\n\n        (0, _delayUntil)(function () {\n          _this.element = element;\n\n          _this.buildTabs();\n        }, function () {\n          return (0, _jquery)(element).find(\".pagebuilder-tab-item\").length === expectedChildren;\n        });\n      }); // Resolve our deferred when the tabs item mounts with expect children\n\n      _events.on(\"tabs:mountAfter\", function (args) {\n        if (args.contentType.id === _this.contentType.id && args.expectChildren !== undefined) {\n          _this.mountAfterDeferred.resolve(args.expectChildren);\n        }\n      });\n\n      _events.on(\"tab-item:mountAfter\", function (args) {\n        if (_this.element && args.contentType.parentContentType.id === _this.contentType.id) {\n          _this.refreshTabs();\n        }\n      });\n\n      _events.on(\"tab-item:renderAfter\", function (args) {\n        if (_this.element && args.contentType.parentContentType.id === _this.contentType.id) {\n          _underscore.defer(function () {\n            _this.refreshTabs();\n          });\n        }\n      }); // Set the active tab to the new position of the sorted tab\n\n\n      _events.on(\"tab-item:removeAfter\", function (args) {\n        if (args.parentContentType && args.parentContentType.id === _this.contentType.id) {\n          _this.refreshTabs(); // We need to wait for the tabs to refresh before executing the focus\n\n\n          _underscore.defer(function () {\n            var newPosition = args.index > 0 ? args.index - 1 : 0;\n\n            _this.setFocusedTab(newPosition, true);\n          });\n        }\n      }); // Refresh tab contents and set the focus to the new position of the sorted tab\n\n\n      _events.on(\"childContentType:sortUpdate\", function (args) {\n        if (args.instance.id === _this.contentType.id) {\n          _this.refreshTabs(args.newPosition, true);\n          /**\n           * Update the default active tab if its position was affected by the sorting\n           */\n\n\n          var defaultActiveTab = +_this.activeTab();\n          var newDefaultActiveTab = defaultActiveTab;\n\n          if (args.originalPosition === defaultActiveTab) {\n            newDefaultActiveTab = args.newPosition;\n          } else if (args.originalPosition < defaultActiveTab && args.newPosition >= defaultActiveTab) {\n            // a tab was moved from the left of the default active tab the right of it, changing its index\n            newDefaultActiveTab--;\n          } else if (args.originalPosition > defaultActiveTab && args.newPosition <= defaultActiveTab) {\n            // a tab was moved from the right of the default active tab the left of it, changing its index\n            newDefaultActiveTab++;\n          }\n\n          _this.updateData(\"default_active\", newDefaultActiveTab.toString());\n        }\n      }); // Monitor focus tab to start / stop interaction on the stage, debounce to avoid duplicate calls\n\n\n      _this.focusedTab.subscribe(_underscore.debounce(function (index) {\n        if (index !== null) {\n          _events.trigger(\"stage:interactionStart\");\n\n          (0, _delayUntil)(function () {\n            return (0, _jquery)((0, _jquery)(_this.wrapperElement).find(\".tab-header\")[index]).find(\"[contenteditable]\").focus();\n          }, function () {\n            return (0, _jquery)((0, _jquery)(_this.wrapperElement).find(\".tab-header\")[index]).find(\"[contenteditable]\").length > 0;\n          }, 10);\n        } else {\n          // We have to force the stop as the event firing is inconsistent for certain operations\n          _events.trigger(\"stage:interactionStop\", {\n            force: true\n          });\n        }\n      }, 1));\n\n      return _this;\n    }\n    /**\n     * Remove focused tab\n     */\n\n\n    var _proto = Preview.prototype;\n\n    _proto.destroy = function destroy() {\n      var _this2 = this;\n\n      _previewCollection2.prototype.destroy.call(this);\n\n      _underscore.defer(function () {\n        return _this2.setFocusedTab(null);\n      });\n    }\n    /**\n     * Refresh the tabs instance when new content appears\n     *\n     * @param {number} focusIndex\n     * @param {boolean} forceFocus\n     * @param {number} activeIndex\n     */\n    ;\n\n    _proto.refreshTabs = function refreshTabs(focusIndex, forceFocus, activeIndex) {\n      try {\n        (0, _jquery)(this.element).tabs(\"refresh\");\n\n        if (focusIndex >= 0) {\n          this.setFocusedTab(focusIndex, forceFocus);\n        } else if (activeIndex) {\n          this.setActiveTab(activeIndex);\n        } // update sortability of tabs\n\n\n        var sortableElement = (0, _jquery)(this.element).find(\".tabs-navigation\");\n\n        if (sortableElement.hasClass(\"ui-sortable\")) {\n          if (this.contentType.children().length <= 1) {\n            sortableElement.sortable(\"disable\");\n          } else {\n            sortableElement.sortable(\"enable\");\n          }\n        }\n      } catch (e) {\n        this.buildTabs();\n      }\n    }\n    /**\n     * Set the active tab, we maintain a reference to it in an observable for when we rebuild the tab instance\n     *\n     * @param {number} index\n     */\n    ;\n\n    _proto.setActiveTab = function setActiveTab(index) {\n      var _this3 = this;\n\n      if (index !== null) {\n        // Added to prevent mismatched fragment error caused by not yet rendered tab-item\n        index = parseInt(index.toString(), 10);\n        (0, _delayUntil)(function () {\n          (0, _jquery)(_this3.element).tabs(\"option\", \"active\", index);\n\n          _this3.activeTab(index);\n\n          _events.trigger(\"contentType:redrawAfter\", {\n            id: _this3.contentType.id,\n            contentType: _this3\n          });\n        }, function () {\n          return (0, _jquery)(_this3.element).find(\".pagebuilder-tab-item\").length >= index + 1;\n        });\n      }\n    }\n    /**\n     * Set the focused tab\n     *\n     * @param {number} index\n     * @param {boolean} force\n     */\n    ;\n\n    _proto.setFocusedTab = function setFocusedTab(index, force) {\n      if (force === void 0) {\n        force = false;\n      }\n\n      this.setActiveTab(index);\n\n      if (force) {\n        this.focusedTab(null);\n      }\n\n      this.focusedTab(index);\n    }\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n    ;\n\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _previewCollection2.prototype.retrieveOptions.call(this);\n\n      options.add = new _option({\n        preview: this,\n        icon: \"<i class='icon-pagebuilder-add'></i>\",\n        title: (0, _translate)(\"Add\"),\n        action: this.addTab,\n        classes: [\"add-child\"],\n        sort: 10\n      });\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    }\n    /**\n     * Add a tab\n     */\n    ;\n\n    _proto.addTab = function addTab() {\n      var _this4 = this;\n\n      (0, _contentTypeFactory)(_config.getContentTypeConfig(\"tab-item\"), this.contentType, this.contentType.stageId).then(function (tab) {\n        _events.on(\"tab-item:mountAfter\", function (args) {\n          if (args.id === tab.id) {\n            _this4.setFocusedTab(_this4.contentType.children().length - 1);\n\n            _events.off(\"tab-item:\" + tab.id + \":mountAfter\");\n          }\n        }, \"tab-item:\" + tab.id + \":mountAfter\");\n\n        _this4.contentType.addChild(tab, _this4.contentType.children().length); // Update the default tab title when adding a new tab\n\n\n        tab.dataStore.set(\"tab_name\", (0, _translate)(\"Tab\") + \" \" + (_this4.contentType.children.indexOf(tab) + 1));\n      });\n    }\n    /**\n     * On render init the tabs widget\n     *\n     * @param {Element} element\n     */\n    ;\n\n    _proto.onContainerRender = function onContainerRender(element) {\n      this.element = element;\n      this.onContainerRenderDeferred.resolve(element);\n    }\n    /**\n     * Copy over border styles to the tab headers\n     *\n     * @returns {any}\n     */\n    ;\n\n    _proto.getTabHeaderStyles = function getTabHeaderStyles() {\n      var headerStyles = this.data.headers.style();\n      return _extends({}, headerStyles, {\n        marginBottom: \"-\" + headerStyles.borderWidth,\n        marginLeft: \"-\" + headerStyles.borderWidth\n      });\n    }\n    /**\n     * Get the sortable options for the tab heading sorting\n     *\n     * @returns {JQueryUI.SortableOptions}\n     */\n    ;\n\n    _proto.getSortableOptions = function getSortableOptions() {\n      var self = this;\n      var borderWidth;\n      return {\n        handle: \".tab-drag-handle\",\n        tolerance: \"pointer\",\n        cursor: \"grabbing\",\n        cursorAt: {\n          left: 8,\n          top: 25\n        },\n\n        /**\n         * Provide custom helper element\n         *\n         * @param {Event} event\n         * @param {JQueryUI.Sortable} element\n         * @returns {Element}\n         */\n        helper: function helper(event, element) {\n          var helper = (0, _jquery)(element).clone().css(\"opacity\", \"0.7\");\n          helper[0].querySelector(\".pagebuilder-options\").remove();\n          return helper[0];\n        },\n\n        /**\n         * Add a padding to the navigation UL to resolve issues of negative margins when sorting\n         *\n         * @param {Event} event\n         * @param {JQueryUI.SortableUIParams} ui\n         */\n        start: function start(event, ui) {\n          /**\n           * Due to the way we use negative margins to overlap the borders we need to apply a padding to the\n           * container when we're moving the first item to ensure the tabs remain in the same place.\n           */\n          if (ui.item.index() === 0) {\n            borderWidth = parseInt(ui.item.css(\"borderWidth\"), 10) || 1;\n            (0, _jquery)(this).css(\"paddingLeft\", borderWidth);\n          }\n\n          ui.helper.css(\"width\", \"\");\n\n          _events.trigger(\"stage:interactionStart\");\n\n          self.disableInteracting = true;\n        },\n\n        /**\n         * Remove the padding once the operation is completed\n         *\n         * @param {Event} event\n         * @param {JQueryUI.SortableUIParams} ui\n         */\n        stop: function stop(event, ui) {\n          (0, _jquery)(this).css(\"paddingLeft\", \"\");\n\n          _events.trigger(\"stage:interactionStop\");\n\n          self.disableInteracting = false;\n        },\n        placeholder: {\n          /**\n           * Provide custom placeholder element\n           *\n           * @param {JQuery} item\n           * @returns {JQuery}\n           */\n          element: function element(item) {\n            var placeholder = item.clone().css({\n              display: \"inline-block\",\n              opacity: \"0.3\"\n            }).removeClass(\"focused\").addClass(\"sortable-placeholder\");\n            placeholder[0].querySelector(\".pagebuilder-options\").remove();\n            return placeholder[0];\n          },\n          update: function update() {\n            return;\n          }\n        }\n      };\n    }\n    /**\n     * Bind events\n     */\n    ;\n\n    _proto.bindEvents = function bindEvents() {\n      var _this5 = this;\n\n      _previewCollection2.prototype.bindEvents.call(this); // ContentType being mounted onto container\n\n\n      _events.on(\"tabs:dropAfter\", function (args) {\n        if (args.id === _this5.contentType.id && _this5.contentType.children().length === 0) {\n          _this5.addTab();\n        }\n      }); // ContentType being removed from container\n\n\n      _events.on(\"tab-item:removeAfter\", function (args) {\n        if (args.parentContentType && args.parentContentType.id === _this5.contentType.id) {\n          // Mark the previous tab as active\n          var newIndex = args.index - 1 >= 0 ? args.index - 1 : 0;\n\n          _this5.refreshTabs(newIndex, true);\n        }\n      }); // Capture when a content type is duplicated within the container\n\n\n      var duplicatedTab;\n      var duplicatedTabIndex;\n\n      _events.on(\"tab-item:duplicateAfter\", function (args) {\n        if (_this5.contentType.id === args.duplicateContentType.parentContentType.id && args.direct) {\n          var tabData = args.duplicateContentType.dataStore.getState();\n          args.duplicateContentType.dataStore.set(\"tab_name\", tabData.tab_name.toString() + \" copy\");\n          duplicatedTab = args.duplicateContentType;\n          duplicatedTabIndex = args.index;\n        }\n      });\n\n      _events.on(\"tab-item:mountAfter\", function (args) {\n        if (duplicatedTab && args.id === duplicatedTab.id) {\n          _this5.refreshTabs(duplicatedTabIndex, true);\n\n          duplicatedTab = duplicatedTabIndex = null;\n        }\n\n        if (_this5.contentType.id === args.contentType.parentContentType.id) {\n          _this5.updateTabNamesInDataStore();\n\n          args.contentType.dataStore.subscribe(function () {\n            _this5.updateTabNamesInDataStore();\n          });\n        }\n      });\n\n      this.contentType.dataStore.subscribe(function (data) {\n        _this5.activeTab(data.default_active);\n      });\n    }\n    /**\n     * Update data store with active options\n     */\n    ;\n\n    _proto.updateTabNamesInDataStore = function updateTabNamesInDataStore() {\n      var activeOptions = [];\n      this.contentType.children().forEach(function (tab, index) {\n        var tabData = tab.dataStore.getState();\n        activeOptions.push({\n          label: tabData.tab_name.toString(),\n          labeltitle: tabData.tab_name.toString(),\n          value: index\n        });\n      });\n      this.contentType.dataStore.set(\"_default_active_options\", activeOptions);\n    }\n    /**\n     * Assign a debounce and delay to the init of tabs to ensure the DOM has updated\n     *\n     * @type {(() => void) & _.Cancelable}\n     */\n    ;\n\n    _proto.buildTabs = function buildTabs(activeTabIndex) {\n      var _this6 = this;\n\n      if (activeTabIndex === void 0) {\n        activeTabIndex = this.activeTab() || 0;\n      }\n\n      this.ready = false;\n\n      if (this.element && this.element.children.length > 0) {\n        var focusedTab = this.focusedTab();\n\n        try {\n          (0, _jquery)(this.element).tabs(\"destroy\");\n        } catch (e) {// We aren't concerned if this fails, tabs throws an Exception when we cannot destroy\n        }\n\n        (0, _jquery)(this.element).tabs({\n          create: function create() {\n            _this6.ready = true; // Ensure focus tab is restored after a rebuild cycle\n\n            if (focusedTab !== null) {\n              _this6.setFocusedTab(focusedTab, true);\n            } else {\n              _this6.setFocusedTab(null);\n\n              if (activeTabIndex) {\n                _this6.setActiveTab(activeTabIndex);\n              }\n            }\n          },\n\n          /**\n           * Trigger redraw event since new content is being displayed\n           */\n          activate: function activate() {\n            _events.trigger(\"contentType:redrawAfter\", {\n              element: _this6.element\n            });\n          }\n        });\n      }\n    };\n\n    return Preview;\n  }(_previewCollection); // Resolve issue with jQuery UI tabs content typing events on content editable areas\n\n\n  var originalTabKeyDown = _jquery.ui.tabs.prototype._tabKeydown;\n\n  _jquery.ui.tabs.prototype._tabKeydown = function (event) {\n    // If the target is content editable don't handle any events\n    if ((0, _jquery)(event.target).attr(\"contenteditable\")) {\n      return;\n    }\n\n    originalTabKeyDown.call(this, event);\n  };\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/tabs/appearance/default/widget.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_PageBuilder/js/events',\n    'jquery-ui-modules/tabs'\n], function ($, events) {\n    'use strict';\n\n    return function (config, element) {\n        var $element = $(element);\n\n        // Ignore stage builder preview tabs\n        if ($element.is('.pagebuilder-tabs')) {\n            return;\n        }\n\n        // Disambiguate between the mage/tabs component which is loaded randomly depending on requirejs order.\n        $.ui.tabs({\n            active: $element.data('activeTab') || 0,\n            create:\n\n                /**\n                 * Adjust the margin bottom of the navigation to correctly display the active tab\n                 */\n                function () {\n                    var borderWidth = parseInt($element.find('.tabs-content').css('borderWidth').toString(), 10);\n\n                    $element.find('.tabs-navigation').css('marginBottom', -borderWidth);\n                    $element.find('.tabs-navigation li:not(:first-child)').css('marginLeft', -borderWidth);\n                },\n            activate:\n\n                /**\n                 * Trigger redraw event since new content is being displayed\n                 */\n                function () {\n                    events.trigger('contentType:redrawAfter', {\n                        element: element\n                    });\n                }\n        }, element);\n    };\n});\n","Magento_PageBuilder/js/content-type/tabs/mass-converter/header-alignment.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var HeaderAlignment = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function HeaderAlignment() {}\n\n    var _proto = HeaderAlignment.prototype;\n\n    /**\n     * Process data after it's read and converted by element converters\n     *\n     * @param {ConverterDataInterface} data\n     * @param {ConverterConfigInterface} config\n     * @returns {object}\n     */\n    _proto.fromDom = function fromDom(data, config) {\n      return data;\n    }\n    /**\n     * Add our tab alignment class into the data for the tabs\n     *\n     * @param {ConverterDataInterface} data\n     * @param {ConverterConfigInterface} config\n     * @returns {object}\n     */\n    ;\n\n    _proto.toDom = function toDom(data, config) {\n      data.css_classes += \" tab-align-\" + (0, _object.get)(data, config.navigation_alignment_variable, \"left\");\n      return data;\n    };\n\n    return HeaderAlignment;\n  }();\n\n  return HeaderAlignment;\n});\n//# sourceMappingURL=header-alignment.js.map","Magento_PageBuilder/js/content-type/video/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/content-type/preview\"], function (_hideShowOption, _preview) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_preview2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _preview2);\n\n    function Preview() {\n      return _preview2.apply(this, arguments) || this;\n    }\n\n    var _proto = Preview.prototype;\n\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _preview2.prototype.retrieveOptions.call(this);\n\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    };\n\n    _proto.isHosted = function isHosted(src) {\n      var youtubeRegExp = new RegExp(\"^(?:https?:\\/\\/|\\/\\/)?(?:www\\\\.|m\\\\.)?\" + \"(?:youtu\\\\.be\\/|youtube\\\\.com\\/(?:embed\\/|v\\/|watch\\\\?v=|watch\\\\?.+&v=))([\\\\w-]{11})(?![\\\\w-])\");\n      var vimeoRegExp = new RegExp(\"https?:\\/\\/(?:www\\\\.|player\\\\.)?vimeo.com\\/(?:channels\\/\" + \"(?:\\\\w+\\/)?|groups\\/([^\\/]*)\\/videos\\/|album\\/(\\\\d+)\\/video\\/|video\\/|)(\\\\d+)(?:$|\\/|\\\\?)\");\n      return vimeoRegExp.test(src) || youtubeRegExp.test(src);\n    }\n    /**\n     * After render callback\n     *\n     * @param {HTMLVideoElement} videoElement\n     * @param {Preview} self\n     */\n    ;\n\n    _proto.onAfterRender = function onAfterRender(videoElement, self) {\n      // Assign muted attribute explicitly due to API issues\n      videoElement.muted = self.data.video.attributes().autoplay;\n    };\n\n    return Preview;\n  }(_preview);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/video/master.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"Magento_PageBuilder/js/content-type/master\"], function (_master) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var Master = /*#__PURE__*/function (_master2) {\n    \"use strict\";\n\n    _inheritsLoose(Master, _master2);\n\n    function Master() {\n      return _master2.apply(this, arguments) || this;\n    }\n\n    var _proto = Master.prototype;\n\n    _proto.isHosted = function isHosted(src) {\n      var youtubeRegExp = new RegExp(\"^(?:https?:\\/\\/|\\/\\/)?(?:www\\\\.|m\\\\.)?\" + \"(?:youtu\\\\.be\\/|youtube\\\\.com\\/(?:embed\\/|v\\/|watch\\\\?v=|watch\\\\?.+&v=))([\\\\w-]{11})(?![\\\\w-])\");\n      var vimeoRegExp = new RegExp(\"https?:\\/\\/(?:www\\\\.|player\\\\.)?vimeo.com\\/(?:channels\\/\" + \"(?:\\\\w+\\/)?|groups\\/([^\\/]*)\\/videos\\/|album\\/(\\\\d+)\\/video\\/|video\\/|)(\\\\d+)(?:$|\\/|\\\\?)\");\n      return vimeoRegExp.test(src) || youtubeRegExp.test(src);\n    };\n\n    return Master;\n  }(_master);\n\n  return Master;\n});\n//# sourceMappingURL=master.js.map","Magento_PageBuilder/js/content-type/video/converter/attribute/videosrc.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var VideoSrc = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function VideoSrc() {}\n\n    var _proto = VideoSrc.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      value = value.replace(/\\?autoplay=1&mute=1/g, \"\");\n      value = value.replace(/\\?title=0&byline=0&portrait=0/g, \"\");\n      value = value.replace(/&autoplay=1&autopause=0&muted=1/g, \"\");\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n\n      if (value === undefined) {\n        return \"\";\n      }\n\n      var youtubeRegExp = new RegExp(\"^(?:https?:\\/\\/|\\/\\/)?(?:www\\\\.|m\\\\.)?\" + \"(?:youtu\\\\.be\\/|youtube\\\\.com\\/(?:embed\\/|v\\/|watch\\\\?v=|watch\\\\?.+&v=))([\\\\w-]{11})(?![\\\\w-])\");\n      var vimeoRegExp = new RegExp(\"https?:\\/\\/(?:www\\\\.|player\\\\.)?vimeo.com\\/(?:channels\\/\" + \"(?:\\\\w+\\/)?|groups\\/([^\\/]*)\\/videos\\/|album\\/(\\\\d+)\\/video\\/|video\\/|)(\\\\d+)(?:$|\\/|\\\\?)\");\n\n      if (youtubeRegExp.test(value)) {\n        return \"https://www.youtube.com/embed/\" + youtubeRegExp.exec(value)[1] + (data.autoplay === \"true\" ? \"?autoplay=1&mute=1\" : \"\");\n      } else if (vimeoRegExp.test(value)) {\n        return \"https://player.vimeo.com/video/\" + vimeoRegExp.exec(value)[3] + \"?title=0&byline=0&portrait=0\" + (data.autoplay === \"true\" ? \"&autoplay=1&autopause=0&muted=1\" : \"\");\n      }\n\n      return value;\n    };\n\n    return VideoSrc;\n  }();\n\n  return VideoSrc;\n});\n//# sourceMappingURL=videosrc.js.map","Magento_PageBuilder/js/content-type/video/converter/attribute/autoplay.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var VideoSrc = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function VideoSrc() {}\n\n    var _proto = VideoSrc.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value === \"true\" ? value : \"false\";\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {boolean|string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n      return value === \"true\" ? true : null;\n    };\n\n    return VideoSrc;\n  }();\n\n  return VideoSrc;\n});\n//# sourceMappingURL=autoplay.js.map","Magento_PageBuilder/js/content-type/video/converter/attribute/src.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var Src = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Src() {}\n\n    var _proto = Src.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      var fileRegExp = new RegExp(\"^(webm:|mp4:|ogv:)\");\n\n      if (fileRegExp.test(value)) {\n        return value.substr(fileRegExp.exec(value)[0].length);\n      }\n\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n\n      if (value === undefined) {\n        return \"\";\n      }\n\n      var youtubeRegExp = new RegExp(\"^(?:https?:\\/\\/|\\/\\/)?(?:www\\\\.|m\\\\.)?\" + \"(?:youtu\\\\.be\\/|youtube\\\\.com\\/(?:embed\\/|v\\/|watch\\\\?v=|watch\\\\?.+&v=))([\\\\w-]{11})(?![\\\\w-])\");\n      var vimeoRegExp = new RegExp(\"https?:\\/\\/(?:www\\\\.|player\\\\.)?vimeo.com\\/(?:channels\\/\" + \"(?:\\\\w+\\/)?|groups\\/([^\\/]*)\\/videos\\/|album\\/(\\\\d+)\\/video\\/|video\\/|)(\\\\d+)(?:$|\\/|\\\\?)\");\n      var fileRegExp = new RegExp(\"^(?:https:|http:)?\\\\/\\\\/.*[\\\\\\\\\\\\/].+\\\\.(webm|mp4|ogv)(?!\\w)\");\n\n      if (youtubeRegExp.test(value)) {\n        return \"https://www.youtube.com/embed/\" + youtubeRegExp.exec(value)[1];\n      } else if (vimeoRegExp.test(value)) {\n        return \"https://player.vimeo.com/video/\" + vimeoRegExp.exec(value)[3] + \"?title=0&byline=0&portrait=0\";\n      } else if (fileRegExp.test(value)) {\n        var result = fileRegExp.exec(value);\n        return result[1] + \":\" + value;\n      }\n\n      return value;\n    };\n\n    return Src;\n  }();\n\n  return Src;\n});\n//# sourceMappingURL=src.js.map","Magento_PageBuilder/js/content-type/products/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jquery\", \"knockout\", \"mage/translate\", \"Magento_PageBuilder/js/events\", \"slick\", \"underscore\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/content-type/preview\"], function (_jquery, _knockout, _translate, _events, _slick, _underscore, _config, _hideShowOption, _preview) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_preview2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _preview2);\n\n    /**\n     * Define keys which when changed should not trigger the slider to be rebuilt\n     *\n     * @type {string[]}\n     */\n\n    /**\n     * @inheritdoc\n     */\n    function Preview(contentType, config, observableUpdater) {\n      var _this;\n\n      _this = _preview2.call(this, contentType, config, observableUpdater) || this;\n      _this.displayPreview = _knockout.observable(false);\n      _this.previewElement = _jquery.Deferred();\n      _this.widgetUnsanitizedHtml = _knockout.observable();\n      _this.slidesToShow = 5;\n      _this.productItemSelector = \".product-item\";\n      _this.centerModeClass = \"center-mode\";\n      _this.messages = {\n        EMPTY: (0, _translate)(\"Empty Products\"),\n        NO_RESULTS: (0, _translate)(\"No products were found matching your condition\"),\n        LOADING: (0, _translate)(\"Loading...\"),\n        UNKNOWN_ERROR: (0, _translate)(\"An unknown error occurred. Please try again.\")\n      };\n      _this.ignoredKeysForBuild = [\"margins_and_padding\", \"border\", \"border_color\", \"border_radius\", \"border_width\", \"css_classes\", \"text_align\"];\n      _this.placeholderText = _knockout.observable(_this.messages.EMPTY); // Redraw slider after content type gets redrawn\n\n      _events.on(\"contentType:redrawAfter\", function (args) {\n        if (_this.element && _this.element.children) {\n          var $element = (0, _jquery)(_this.element.children);\n\n          if (args.element && $element.closest(args.element).length) {\n            $element.slick(\"setPosition\");\n          }\n        }\n      });\n\n      _events.on(\"stage:\" + _this.contentType.stageId + \":viewportChangeAfter\", function (args) {\n        var viewports = _config.getConfig(\"viewports\");\n\n        if (_this.element && _this.appearance() === \"carousel\") {\n          _this.slidesToShow = parseFloat(viewports[args.viewport].options.products.default.slidesToShow);\n\n          _this.destroySlider();\n\n          _this.initSlider();\n        }\n      });\n\n      return _this;\n    }\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n\n\n    var _proto = Preview.prototype;\n\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _preview2.prototype.retrieveOptions.call(this);\n\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    }\n    /**\n     * On afterRender callback.\n     *\n     * @param {Element} element\n     */\n    ;\n\n    _proto.onAfterRender = function onAfterRender(element) {\n      this.element = element;\n      this.previewElement.resolve(element);\n      this.initSlider();\n    }\n    /**\n     * @inheritdoc\n     */\n    ;\n\n    _proto.afterObservablesUpdated = function afterObservablesUpdated() {\n      var _this2 = this;\n\n      _preview2.prototype.afterObservablesUpdated.call(this);\n\n      var data = this.contentType.dataStore.getState();\n\n      if (this.hasDataChanged(this.previousData, data)) {\n        this.displayPreview(false);\n\n        if (typeof data.conditions_encoded !== \"string\" || data.conditions_encoded.length === 0) {\n          this.placeholderText(this.messages.EMPTY);\n          return;\n        }\n\n        var url = _config.getConfig(\"preview_url\");\n\n        var requestConfig = {\n          // Prevent caching\n          method: \"POST\",\n          data: {\n            role: this.config.name,\n            directive: this.data.main.html()\n          }\n        };\n        this.placeholderText(this.messages.LOADING);\n\n        _jquery.ajax(url, requestConfig).done(function (response) {\n          if (typeof response.data !== \"object\" || !Boolean(response.data.content)) {\n            _this2.placeholderText(_this2.messages.NO_RESULTS);\n\n            return;\n          }\n\n          if (response.data.error) {\n            _this2.widgetUnsanitizedHtml(response.data.error);\n          } else {\n            _this2.widgetUnsanitizedHtml(response.data.content);\n\n            _this2.displayPreview(true);\n          }\n\n          _this2.previewElement.done(function () {\n            (0, _jquery)(_this2.element).trigger(\"contentUpdated\");\n          });\n        }).fail(function () {\n          _this2.placeholderText(_this2.messages.UNKNOWN_ERROR);\n        });\n      }\n\n      this.previousData = Object.assign({}, data);\n    };\n\n    _proto.initSlider = function initSlider() {\n      if (this.element && this.appearance() === \"carousel\") {\n        (0, _jquery)(this.element.children).slick(this.buildSlickConfig());\n      }\n    };\n\n    _proto.destroySlider = function destroySlider() {\n      (0, _jquery)(this.element.children).slick(\"unslick\");\n    }\n    /**\n     * Build the slick config object\n     *\n     * @returns {{autoplay: boolean; autoplay: number; infinite: boolean; arrows: boolean; dots: boolean;\n     * centerMode: boolean; slidesToScroll: number; slidesToShow: number;}}\n     */\n    ;\n\n    _proto.buildSlickConfig = function buildSlickConfig() {\n      var attributes = this.data.main.attributes();\n      var productCount = (0, _jquery)(this.widgetUnsanitizedHtml()).find(this.productItemSelector).length;\n\n      var viewports = _config.getConfig(\"viewports\");\n\n      var currentViewport = this.viewport();\n      var carouselMode = attributes[\"data-carousel-mode\"];\n      var config = {\n        slidesToShow: this.slidesToShow,\n        slidesToScroll: this.slidesToShow,\n        dots: attributes[\"data-show-dots\"] === \"true\",\n        arrows: attributes[\"data-show-arrows\"] === \"true\",\n        autoplay: attributes[\"data-autoplay\"] === \"true\",\n        autoplaySpeed: parseFloat(attributes[\"data-autoplay-speed\"])\n      };\n      var slidesToShow = viewports[currentViewport].options.products[carouselMode] ? viewports[currentViewport].options.products[carouselMode].slidesToShow : viewports[currentViewport].options.products.default.slidesToShow;\n      config.slidesToShow = parseFloat(slidesToShow);\n\n      if (attributes[\"data-carousel-mode\"] === \"continuous\" && productCount > config.slidesToShow) {\n        config.centerPadding = attributes[\"data-center-padding\"];\n        config.centerMode = true;\n        (0, _jquery)(this.element).addClass(this.centerModeClass);\n      } else {\n        config.infinite = attributes[\"data-infinite-loop\"] === \"true\";\n        (0, _jquery)(this.element).removeClass(this.centerModeClass);\n      }\n\n      return config;\n    }\n    /**\n     * Determine if the data has changed, whilst ignoring certain keys which don't require a rebuild\n     *\n     * @param {DataObject} previousData\n     * @param {DataObject} newData\n     * @returns {boolean}\n     */\n    ;\n\n    _proto.hasDataChanged = function hasDataChanged(previousData, newData) {\n      previousData = _underscore.omit(previousData, this.ignoredKeysForBuild);\n      newData = _underscore.omit(newData, this.ignoredKeysForBuild);\n      return !_underscore.isEqual(previousData, newData);\n    };\n\n    return Preview;\n  }(_preview);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/products/form/provider.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_PageBuilder/js/form/provider',\n    'Magento_PageBuilder/js/form/provider/conditions-data-processor'\n], function (Provider, conditionsDataProcessor) {\n    'use strict';\n\n    return Provider.extend({\n        /** @inheritdoc **/\n        save: function () {\n            var data = this.get('data');\n\n            conditionsDataProcessor(data, data['condition_option'] + '_source');\n\n            return this._super();\n        }\n    });\n});\n","Magento_PageBuilder/js/content-type/products/appearance/carousel/widget.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'matchMedia',\n    'Magento_PageBuilder/js/utils/breakpoints',\n    'Magento_PageBuilder/js/events',\n    'slick'\n], function ($, _, mediaCheck, breakpointsUtils, events) {\n    'use strict';\n\n    /**\n     * Build slick\n     *\n     * @param {jQuery} $carouselElement\n     * @param {Object} config\n     */\n    function buildSlick($carouselElement, config) {\n        /**\n         * Prevent each slick slider from being initialized more than once which could throw an error.\n         */\n        if ($carouselElement.hasClass('slick-initialized')) {\n            $carouselElement.slick('unslick');\n        }\n\n        config.slidesToScroll = config.slidesToShow;\n        $carouselElement.slick(config);\n    }\n\n    /**\n     * Initialize slider.\n     *\n     * @param {jQuery} $element\n     * @param {Object} slickConfig\n     * @param {Object} breakpoint\n     */\n    function initSlider($element, slickConfig, breakpoint) {\n        var productCount = $element.find('.product-item').length,\n            $carouselElement = $($element.children()),\n            centerModeClass = 'center-mode',\n            carouselMode = $element.data('carousel-mode'),\n            slidesToShow = breakpoint.options.products[carouselMode] ?\n                breakpoint.options.products[carouselMode].slidesToShow :\n                breakpoint.options.products.default.slidesToShow;\n\n        slickConfig.slidesToShow = parseFloat(slidesToShow);\n\n        if (carouselMode === 'continuous' && productCount > slickConfig.slidesToShow) {\n            $element.addClass(centerModeClass);\n            slickConfig.centerPadding = $element.data('center-padding');\n            slickConfig.centerMode = true;\n        } else {\n            $element.removeClass(centerModeClass);\n            slickConfig.infinite = $element.data('infinite-loop');\n        }\n\n        buildSlick($carouselElement, slickConfig);\n    }\n\n    return function (config, element) {\n        var $element = $(element),\n            $carouselElement = $($element.children()),\n            currentViewport = config.currentViewport,\n            currentBreakpoint = config.breakpoints[currentViewport],\n            slickConfig = {\n                autoplay: $element.data('autoplay'),\n                autoplaySpeed: $element.data('autoplay-speed') || 0,\n                arrows: $element.data('show-arrows'),\n                dots: $element.data('show-dots')\n            };\n\n        _.each(config.breakpoints, function (breakpoint) {\n            mediaCheck({\n                media: breakpointsUtils.buildMedia(breakpoint.conditions),\n\n                /** @inheritdoc */\n                entry: function () {\n                    initSlider($element, slickConfig, breakpoint);\n                }\n            });\n        });\n\n        //initialize slider when content type is added in mobile viewport\n        if (currentViewport === 'mobile') {\n            initSlider($element, slickConfig, currentBreakpoint);\n        }\n\n        // Redraw slide after content type gets redrawn\n        events.on('contentType:redrawAfter', function (args) {\n            if ($carouselElement.closest(args.element).length) {\n                $carouselElement.slick('setPosition');\n            }\n        });\n\n        events.on('stage:viewportChangeAfter', function (args) {\n            var breakpoint = config.breakpoints[args.viewport];\n\n            initSlider($element, slickConfig, breakpoint);\n        });\n    };\n});\n","Magento_PageBuilder/js/content-type/products/mass-converter/widget-directive.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"Magento_PageBuilder/js/mass-converter/widget-directive-abstract\", \"Magento_PageBuilder/js/utils/object\"], function (_widgetDirectiveAbstract, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var WidgetDirective = /*#__PURE__*/function (_widgetDirectiveAbstr) {\n    \"use strict\";\n\n    _inheritsLoose(WidgetDirective, _widgetDirectiveAbstr);\n\n    function WidgetDirective() {\n      return _widgetDirectiveAbstr.apply(this, arguments) || this;\n    }\n\n    var _proto = WidgetDirective.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param {object} data\n     * @param {object} config\n     * @returns {object}\n     */\n    _proto.fromDom = function fromDom(data, config) {\n      var attributes = _widgetDirectiveAbstr.prototype.fromDom.call(this, data, config);\n\n      data.products_count = attributes.products_count;\n      data.sort_order = attributes.sort_order;\n      data.condition_option = attributes.condition_option || \"condition\";\n      data[data.condition_option] = this.decodeWysiwygCharacters(attributes.condition_option_value || \"\");\n      data.conditions_encoded = this.decodeWysiwygCharacters(attributes.conditions_encoded || \"\");\n      data[data.condition_option + \"_source\"] = data.conditions_encoded;\n      return data;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {object} data\n     * @param {object} config\n     * @returns {object}\n     */\n    ;\n\n    _proto.toDom = function toDom(data, config) {\n      var attributes = {\n        type: \"Magento\\\\CatalogWidget\\\\Block\\\\Product\\\\ProductsList\",\n        template: \"Magento_CatalogWidget::product/widget/content/grid.phtml\",\n        anchor_text: \"\",\n        id_path: \"\",\n        show_pager: 0,\n        products_count: data.products_count,\n        condition_option: data.condition_option,\n        condition_option_value: \"\",\n        type_name: \"Catalog Products List\",\n        conditions_encoded: this.encodeWysiwygCharacters(data.conditions_encoded || \"\")\n      };\n\n      if (data.sort_order) {\n        attributes.sort_order = data.sort_order;\n      }\n\n      if (typeof data[data.condition_option] === \"string\") {\n        attributes.condition_option_value = this.encodeWysiwygCharacters(data[data.condition_option]);\n      }\n\n      if (attributes.conditions_encoded.length === 0) {\n        return data;\n      }\n\n      (0, _object.set)(data, config.html_variable, this.buildDirective(attributes));\n      return data;\n    }\n    /**\n     * @param {string} content\n     * @returns {string}\n     */\n    ;\n\n    _proto.encodeWysiwygCharacters = function encodeWysiwygCharacters(content) {\n      return content.replace(/\\{/g, \"^[\").replace(/\\}/g, \"^]\").replace(/\"/g, \"`\").replace(/\\\\/g, \"|\").replace(/</g, \"&lt;\").replace(/>/g, \"&gt;\");\n    }\n    /**\n     * @param {string} content\n     * @returns {string}\n     */\n    ;\n\n    _proto.decodeWysiwygCharacters = function decodeWysiwygCharacters(content) {\n      return content.replace(/\\^\\[/g, \"{\").replace(/\\^\\]/g, \"}\").replace(/`/g, \"\\\"\").replace(/\\|/g, \"\\\\\").replace(/&lt;/g, \"<\").replace(/&gt;/g, \">\");\n    };\n\n    return WidgetDirective;\n  }(_widgetDirectiveAbstract);\n\n  return WidgetDirective;\n});\n//# sourceMappingURL=widget-directive.js.map","Magento_PageBuilder/js/content-type/products/mass-converter/carousel-widget-directive.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"Magento_PageBuilder/js/mass-converter/widget-directive-abstract\", \"Magento_PageBuilder/js/utils/object\"], function (_widgetDirectiveAbstract, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var WidgetDirective = /*#__PURE__*/function (_widgetDirectiveAbstr) {\n    \"use strict\";\n\n    _inheritsLoose(WidgetDirective, _widgetDirectiveAbstr);\n\n    function WidgetDirective() {\n      return _widgetDirectiveAbstr.apply(this, arguments) || this;\n    }\n\n    var _proto = WidgetDirective.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param {object} data\n     * @param {object} config\n     * @returns {object}\n     */\n    _proto.fromDom = function fromDom(data, config) {\n      var attributes = _widgetDirectiveAbstr.prototype.fromDom.call(this, data, config);\n\n      data.carousel_products_count = attributes.products_count;\n      data.sort_order = attributes.sort_order;\n      data.condition_option = attributes.condition_option || \"condition\";\n      data[data.condition_option] = this.decodeWysiwygCharacters(attributes.condition_option_value || \"\");\n      data.conditions_encoded = this.decodeWysiwygCharacters(attributes.conditions_encoded || \"\");\n      data[data.condition_option + \"_source\"] = data.conditions_encoded;\n      return data;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {object} data\n     * @param {object} config\n     * @returns {object}\n     */\n    ;\n\n    _proto.toDom = function toDom(data, config) {\n      var attributes = {\n        type: \"Magento\\\\CatalogWidget\\\\Block\\\\Product\\\\ProductsList\",\n        template: \"Magento_PageBuilder::catalog/product/widget/content/carousel.phtml\",\n        anchor_text: \"\",\n        id_path: \"\",\n        show_pager: 0,\n        products_count: data.carousel_products_count,\n        condition_option: data.condition_option,\n        condition_option_value: \"\",\n        type_name: \"Catalog Products Carousel\",\n        conditions_encoded: this.encodeWysiwygCharacters(data.conditions_encoded || \"\")\n      };\n\n      if (data.sort_order) {\n        attributes.sort_order = data.sort_order;\n      }\n\n      if (typeof data[data.condition_option] === \"string\") {\n        attributes.condition_option_value = this.encodeWysiwygCharacters(data[data.condition_option]);\n      }\n\n      if (attributes.conditions_encoded.length === 0) {\n        return data;\n      }\n\n      (0, _object.set)(data, config.html_variable, this.buildDirective(attributes));\n      return data;\n    }\n    /**\n     * @param {string} content\n     * @returns {string}\n     */\n    ;\n\n    _proto.encodeWysiwygCharacters = function encodeWysiwygCharacters(content) {\n      return content.replace(/\\{/g, \"^[\").replace(/\\}/g, \"^]\").replace(/\"/g, \"`\").replace(/\\\\/g, \"|\").replace(/</g, \"&lt;\").replace(/>/g, \"&gt;\");\n    }\n    /**\n     * @param {string} content\n     * @returns {string}\n     */\n    ;\n\n    _proto.decodeWysiwygCharacters = function decodeWysiwygCharacters(content) {\n      return content.replace(/\\^\\[/g, \"{\").replace(/\\^\\]/g, \"}\").replace(/`/g, \"\\\"\").replace(/\\|/g, \"\\\\\").replace(/&lt;/g, \"<\").replace(/&gt;/g, \">\");\n    };\n\n    return WidgetDirective;\n  }(_widgetDirectiveAbstract);\n\n  return WidgetDirective;\n});\n//# sourceMappingURL=carousel-widget-directive.js.map","Magento_PageBuilder/js/content-type/slide/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jarallax\", \"jarallaxVideo\", \"jquery\", \"knockout\", \"mage/translate\", \"Magento_PageBuilder/js/events\", \"mageUtils\", \"underscore\", \"vimeoWrapper\", \"Magento_PageBuilder/js/content-type-menu/conditional-remove-option\", \"Magento_PageBuilder/js/uploader\", \"Magento_PageBuilder/js/utils/delay-until\", \"Magento_PageBuilder/js/utils/editor\", \"Magento_PageBuilder/js/utils/nesting-link-dialog\", \"Magento_PageBuilder/js/utils/nesting-widget-dialog\", \"Magento_PageBuilder/js/wysiwyg/factory\", \"Magento_PageBuilder/js/content-type/preview\"], function (_jarallax, _jarallaxVideo, _jquery, _knockout, _translate, _events, _mageUtils, _underscore, _vimeoWrapper, _conditionalRemoveOption, _uploader, _delayUntil, _editor, _nestingLinkDialog, _nestingWidgetDialog, _factory, _preview) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_preview2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _preview2);\n\n    function Preview() {\n      var _this;\n\n      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {\n        args[_key] = arguments[_key];\n      }\n\n      _this = _preview2.call.apply(_preview2, [this].concat(args)) || this;\n      _this.buttonPlaceholder = (0, _translate)(\"Edit Button Text\");\n      _this.slideName = _knockout.observable();\n      _this.wysiwygDeferred = _jquery.Deferred();\n      _this.slideChanged = true;\n      _this.handledDoubleClick = false;\n      _this.videoUpdateProperties = [\"background_type\", \"video_fallback_image\", \"video_lazy_load\", \"video_loop\", \"video_play_only_visible\", \"video_source\"];\n      _this.buildJarallax = _underscore.debounce(function () {\n        // Destroy all instances of the plugin prior\n        try {\n          jarallax(_this.wrapper, \"destroy\");\n        } catch (e) {// Failure of destroying is acceptable\n        }\n\n        if (_this.wrapper && _this.wrapper.dataset.backgroundType === \"video\" && _this.wrapper.dataset.videoSrc.length) {\n          _underscore.defer(function () {\n            // Build Parallax on elements with the correct class\n            var viewportElement = (0, _jquery)(\"<div/>\").addClass(\"jarallax-viewport-element\");\n            (0, _jquery)(_this.wrapper).append((0, _jquery)(\".jarallax-viewport-element\", _this.wrapper).length ? \"\" : viewportElement);\n            jarallax(_this.wrapper, {\n              videoSrc: _this.wrapper.dataset.videoSrc,\n              imgSrc: _this.wrapper.dataset.videoFallbackSrc,\n              videoLoop: _this.contentType.dataStore.get(\"video_loop\") === \"true\",\n              speed: 1,\n              videoPlayOnlyVisible: _this.contentType.dataStore.get(\"video_play_only_visible\") === \"true\",\n              elementInViewport: (0, _jquery)(\".jarallax-viewport-element\", _this.wrapper),\n              videoLazyLoading: _this.contentType.dataStore.get(\"video_lazy_load\") === \"true\"\n            }); // @ts-ignore\n\n            if (_this.wrapper.jarallax && _this.wrapper.jarallax.video) {\n              // @ts-ignore\n              _this.wrapper.jarallax.video.on(\"started\", function () {\n                // @ts-ignore\n                if (_this.wrapper.jarallax && _this.wrapper.jarallax.$video) {\n                  // @ts-ignore\n                  _this.wrapper.jarallax.$video.style.visibility = \"visible\";\n                }\n              });\n            }\n          });\n        }\n      }, 50);\n      return _this;\n    }\n\n    var _proto = Preview.prototype;\n\n    /**\n     * Get background image url base on the viewport.\n     *\n     * @returns {string}\n     */\n    _proto.getBackgroundImage = function getBackgroundImage() {\n      var mobileImage = this.contentType.dataStore.get(\"mobile_image\");\n      var desktopImage = this.contentType.dataStore.get(\"background_image\");\n      var backgroundImage = this.viewport() === \"mobile\" && mobileImage.length ? mobileImage : desktopImage;\n      return backgroundImage.length ? \"url(\\\"\" + backgroundImage[0].url + \"\\\")\" : \"none\";\n    }\n    /**\n     * @param {HTMLElement} element\n     */\n    ;\n\n    _proto.afterRenderWysiwyg = function afterRenderWysiwyg(element) {\n      var _this2 = this;\n\n      this.element = element;\n      element.id = this.contentType.id + \"-editor\"; // Set the innerHTML manually so we don't upset Knockout & TinyMCE\n\n      element.innerHTML = this.data.content.html();\n      this.contentType.dataStore.subscribe(function () {\n        // If we're not focused into TinyMCE inline, update the value when it changes in the data store\n        if (!_this2.wysiwyg || _this2.wysiwyg && _this2.wysiwyg.getAdapter().id !== (0, _editor.getActiveEditor)().id) {\n          element.innerHTML = _this2.data.content.html();\n        }\n      }, \"content\");\n      /**\n       * afterRenderWysiwyg is called whenever Knockout causes a DOM re-render. This occurs frequently within Slider\n       * due to Slick's inability to perform a refresh with Knockout managing the DOM. Due to this the original\n       * WYSIWYG instance will be detached from this slide and we need to re-initialize on click.\n       */\n\n      this.wysiwyg = null;\n    }\n    /**\n     * Set state based on overlay mouseover event for the preview\n     */\n    ;\n\n    _proto.onMouseOverWrapper = function onMouseOverWrapper() {\n      // Triggers the visibility of the overlay content to show\n      if (this.data.main.attributes()[\"data-show-overlay\"] === \"hover\") {\n        this.data.overlay.attributes(Object.assign(this.data.overlay.attributes(), {\n          \"data-background-color-orig\": this.data.overlay.style().backgroundColor\n        }));\n        this.data.overlay.style(Object.assign(this.data.overlay.style(), {\n          backgroundColor: this.data.overlay.attributes()[\"data-overlay-color\"]\n        }));\n      }\n\n      if (this.data.main.attributes()[\"data-show-button\"] === \"hover\") {\n        this.data.button.style(Object.assign(this.data.button.style(), {\n          opacity: 1,\n          visibility: \"visible\"\n        }));\n      }\n    }\n    /**\n     * Set state based on overlay mouseout event for the preview\n     */\n    ;\n\n    _proto.onMouseOutWrapper = function onMouseOutWrapper() {\n      // Triggers the visibility of the overlay content to hide\n      if (this.data.main.attributes()[\"data-show-overlay\"] === \"hover\") {\n        this.data.overlay.style(Object.assign(this.data.overlay.style(), {\n          backgroundColor: this.data.overlay.attributes()[\"data-background-color-orig\"]\n        }));\n      }\n\n      if (this.data.main.attributes()[\"data-show-button\"] === \"hover\") {\n        this.data.button.style(Object.assign(this.data.button.style(), {\n          opacity: 0,\n          visibility: \"hidden\"\n        }));\n      }\n    }\n    /**\n     * Get the options instance\n     *\n     * @returns {OptionsInterface}\n     */\n    ;\n\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _preview2.prototype.retrieveOptions.call(this);\n\n      delete options.move;\n      options.remove = new _conditionalRemoveOption(_extends({}, options.remove.config, {\n        preview: this\n      }));\n      return options;\n    }\n    /**\n     * Get registry callback reference to uploader UI component\n     *\n     * @returns {Uploader}\n     */\n    ;\n\n    _proto.getUploader = function getUploader() {\n      var initialImageValue = this.contentType.dataStore.get(this.config.additional_data.uploaderConfig.dataScope, \"\"); // Create uploader\n\n      return new _uploader(\"imageuploader_\" + this.contentType.id, this.config.additional_data.uploaderConfig, this.contentType.id, this.contentType.dataStore, initialImageValue);\n    }\n    /**\n     * Makes WYSIWYG active\n     *\n     * @param {Preview} preview\n     * @param {JQueryEventObject} event\n     * @returns {Boolean}\n     */\n    ;\n\n    _proto.activateEditor = function activateEditor(preview, event) {\n      var _this3 = this;\n\n      if (this.element && !this.wysiwyg) {\n        var bookmark = (0, _editor.createBookmark)(event);\n        (0, _editor.lockImageSize)(this.element);\n        this.element.removeAttribute(\"contenteditable\");\n\n        _underscore.defer(function () {\n          _this3.initWysiwygFromClick(true).then(function () {\n            return (0, _delayUntil)(function () {\n              // We no longer need to handle double click once it's initialized\n              _this3.handledDoubleClick = true;\n\n              _this3.wysiwygDeferred.resolve();\n\n              (0, _editor.moveToBookmark)(bookmark);\n              (0, _editor.unlockImageSize)(_this3.element);\n            }, function () {\n              return _this3.element.classList.contains(\"mce-edit-focus\");\n            }, 10);\n          }).catch(function (error) {\n            // If there's an error with init of WYSIWYG editor push into the console to aid support\n            console.error(error);\n          });\n        });\n      } else if (this.element && this.wysiwyg) {\n        var element = this.element || this.textarea;\n\n        if (event.currentTarget !== event.target && event.target !== element && !element.contains(event.target)) {\n          return;\n        }\n\n        element.focus();\n      }\n    }\n    /**\n     * If a user double clicks prior to initializing TinyMCE, forward the event\n     *\n     * @param preview\n     * @param event\n     */\n    ;\n\n    _proto.handleDoubleClick = function handleDoubleClick(preview, event) {\n      var _this4 = this;\n\n      if (this.handledDoubleClick) {\n        return;\n      }\n\n      event.preventDefault();\n      var targetIndex = (0, _editor.findNodeIndex)(this.element, event.target.tagName, event.target);\n      this.handledDoubleClick = true;\n      this.wysiwygDeferred.then(function () {\n        var target = document.getElementById(event.target.id);\n\n        if (!target) {\n          target = (0, _editor.getNodeByIndex)(_this4.element, event.target.tagName, targetIndex);\n        }\n\n        if (target) {\n          target.dispatchEvent((0, _editor.createDoubleClickEvent)());\n        }\n      });\n    }\n    /**\n     * Stop event to prevent execution of action when editing textarea.\n     *\n     * @param {Preview} preview\n     * @param {JQueryEventObject} event\n     * @returns {Boolean}\n     */\n    ;\n\n    _proto.stopEvent = function stopEvent(preview, event) {\n      event.stopPropagation();\n      return true;\n    }\n    /**\n     * @returns {Boolean}\n     */\n    ;\n\n    _proto.isWysiwygSupported = function isWysiwygSupported() {\n      return (0, _editor.isWysiwygSupported)();\n    }\n    /**\n     * @param {HTMLTextAreaElement} element\n     */\n    ;\n\n    _proto.initTextarea = function initTextarea(element) {\n      var _this5 = this;\n\n      this.textarea = element; // set initial value of textarea based on data store\n\n      this.textarea.value = this.contentType.dataStore.get(\"content\");\n      this.adjustTextareaHeightBasedOnScrollHeight(); // Update content in our stage preview textarea after its slideout counterpart gets updated\n\n      _events.on(\"form:\" + this.contentType.id + \":saveAfter\", function () {\n        _this5.textarea.value = _this5.contentType.dataStore.get(\"content\");\n\n        _this5.adjustTextareaHeightBasedOnScrollHeight();\n      });\n    }\n    /**\n     * Save current value of textarea in data store\n     */\n    ;\n\n    _proto.onTextareaKeyUp = function onTextareaKeyUp() {\n      this.adjustTextareaHeightBasedOnScrollHeight();\n      this.contentType.dataStore.set(\"content\", this.textarea.value);\n    }\n    /**\n     * Start stage interaction on textarea blur\n     */\n    ;\n\n    _proto.onTextareaFocus = function onTextareaFocus() {\n      (0, _jquery)(this.textarea).closest(\".pagebuilder-content-type\").addClass(\"pagebuilder-toolbar-active\");\n\n      _events.trigger(\"stage:interactionStart\");\n    }\n    /**\n     * Stop stage interaction on textarea blur\n     */\n    ;\n\n    _proto.onTextareaBlur = function onTextareaBlur() {\n      (0, _jquery)(this.textarea).closest(\".pagebuilder-content-type\").removeClass(\"pagebuilder-toolbar-active\");\n\n      _events.trigger(\"stage:interactionStop\");\n    }\n    /**\n     * Init WYSIWYG on load\n     *\n     * @param element\n     * @deprecated please use activateEditor & initWysiwygFromClick\n     */\n    ;\n\n    _proto.initWysiwyg = function initWysiwyg(element) {\n      this.element = element;\n      element.id = this.contentType.id + \"-editor\";\n      this.wysiwyg = null;\n      return this.initWysiwygFromClick(true);\n    }\n    /**\n     * Init the WYSIWYG\n     *\n     * @param {boolean} focus Should wysiwyg focus after initialization?\n     * @returns Promise\n     */\n    ;\n\n    _proto.initWysiwygFromClick = function initWysiwygFromClick(focus) {\n      var _this6 = this;\n\n      if (focus === void 0) {\n        focus = false;\n      }\n\n      if (this.wysiwyg) {\n        return Promise.resolve(this.wysiwyg);\n      }\n\n      var wysiwygConfig = this.config.additional_data.wysiwygConfig.wysiwygConfigData;\n\n      if (focus) {\n        wysiwygConfig.adapter.settings.auto_focus = this.element.id;\n\n        wysiwygConfig.adapter.settings.init_instance_callback = function (editor) {\n          editor.on(\"blur\", function () {\n            (0, _nestingLinkDialog)(_this6.contentType.dataStore, _this6.wysiwyg, \"content\", \"link_url\");\n            (0, _nestingWidgetDialog)(_this6.contentType.dataStore, _this6.wysiwyg, \"content\", \"link_url\");\n          });\n\n          _underscore.defer(function () {\n            _this6.element.blur();\n\n            _this6.element.focus();\n          });\n        };\n      }\n\n      return (0, _factory)(this.contentType.id, this.element.id, this.config.name, wysiwygConfig, this.contentType.dataStore, \"content\", this.contentType.stageId).then(function (wysiwyg) {\n        _this6.wysiwyg = wysiwyg;\n        return wysiwyg;\n      });\n    }\n    /**\n     * Init the parallax element\n     *\n     * @param {HTMLElement} element\n     */\n    ;\n\n    _proto.initParallax = function initParallax(element) {\n      var _this7 = this;\n\n      this.wrapper = element;\n\n      _underscore.defer(function () {\n        _this7.buildJarallax();\n      });\n    }\n    /**\n     * Destroy jarallax instance.\n     */\n    ;\n\n    _proto.destroy = function destroy() {\n      _preview2.prototype.destroy.call(this);\n\n      if (this.wrapper) {\n        jarallax(this.wrapper, \"destroy\");\n      }\n    }\n    /**\n     * @inheritDoc\n     */\n    ;\n\n    _proto.bindEvents = function bindEvents() {\n      var _this8 = this;\n\n      _preview2.prototype.bindEvents.call(this);\n\n      _events.on(\"slide:mountAfter\", function (args) {\n        if (args.id === _this8.contentType.id) {\n          _this8.buildJarallax();\n\n          _this8.isSnapshot.subscribe(function (value) {\n            _this8.changeUploaderControlsVisibility();\n          });\n\n          _this8.changeUploaderControlsVisibility();\n        }\n      });\n\n      _events.on(this.config.name + \":\" + this.contentType.id + \":updateAfter\", function () {\n        var dataStore = _this8.contentType.dataStore.getState();\n\n        var imageObject = dataStore[_this8.config.additional_data.uploaderConfig.dataScope][0] || {};\n\n        _events.trigger(\"image:\" + _this8.contentType.id + \":assignAfter\", imageObject);\n      }); // Remove wysiwyg before assign new instance.\n\n\n      _events.on(\"childContentType:sortUpdate\", function (args) {\n        if (args.instance.id === _this8.contentType.parentContentType.id) {\n          _this8.wysiwyg = null;\n        }\n      });\n\n      _events.on(this.config.name + \":mountAfter\", function (args) {\n        if (args.id === _this8.contentType.id) {\n          // Update the display label for the slide\n          var slider = _this8.contentType.parentContentType;\n\n          _this8.displayLabel((0, _translate)(\"Slide \" + (slider.children().indexOf(_this8.contentType) + 1)));\n\n          slider.children.subscribe(function (children) {\n            var index = children.indexOf(_this8.contentType);\n\n            _this8.displayLabel((0, _translate)(\"Slide \" + (slider.children().indexOf(_this8.contentType) + 1)));\n          });\n        }\n      });\n\n      _events.on(this.config.name + \":renderAfter\", function (args) {\n        if (args.id === _this8.contentType.id) {\n          var slider = _this8.contentType.parentContentType;\n          (0, _jquery)(slider.preview.element).on(\"beforeChange\", function () {\n            _this8.slideChanged = false;\n          });\n          (0, _jquery)(slider.preview.element).on(\"afterChange\", function (event, slick) {\n            (0, _jquery)(slick.$slides).each(function (index, slide) {\n              var videoSlide = slide.querySelector(\".jarallax\");\n\n              if (videoSlide) {\n                jarallax(videoSlide, \"onScroll\");\n              }\n            });\n            _this8.slideChanged = true;\n          });\n        }\n      });\n\n      this.contentType.dataStore.subscribe(function (data) {\n        _this8.slideName(data.slide_name);\n\n        if (_this8.shouldUpdateVideo(data)) {\n          _this8.buildJarallax();\n        }\n      });\n\n      _events.on(\"image:\" + this.contentType.id + \":uploadAfter\", function () {\n        _this8.contentType.dataStore.set(\"background_type\", \"image\");\n      });\n\n      _events.on(\"stage:\" + this.contentType.stageId + \":viewportChangeAfter\", function (args) {\n        if (_this8.contentType.dataStore.get(\"background_type\") === \"video\") {\n          _this8.buildJarallax();\n        }\n      });\n    }\n    /**\n     * Change uploader controls visibility\n     */\n    ;\n\n    _proto.changeUploaderControlsVisibility = function changeUploaderControlsVisibility() {\n      var _this9 = this;\n\n      this.getUploader().getUiComponent()(function (uploader) {\n        uploader.visibleControls = !_this9.isSnapshot();\n      });\n    }\n    /**\n     * Update image data inside data store\n     *\n     * @param {Array} data - list of each files' data\n     */\n    ;\n\n    _proto.onImageUploaded = function onImageUploaded(data) {\n      this.contentType.dataStore.set(this.config.additional_data.uploaderConfig.dataScope, data);\n    }\n    /**\n     * Adjust textarea's height based on scrollHeight\n     */\n    ;\n\n    _proto.adjustTextareaHeightBasedOnScrollHeight = function adjustTextareaHeightBasedOnScrollHeight() {\n      this.textarea.style.height = \"\";\n      var scrollHeight = this.textarea.scrollHeight;\n      var minHeight = parseInt((0, _jquery)(this.textarea).css(\"min-height\"), 10);\n\n      if (scrollHeight === minHeight) {\n        // leave height at 'auto'\n        return;\n      }\n\n      (0, _jquery)(this.textarea).height(scrollHeight);\n    }\n    /**\n     * Check if video options has been updated.\n     *\n     * @return boolean\n     */\n    ;\n\n    _proto.shouldUpdateVideo = function shouldUpdateVideo(state) {\n      var _this10 = this;\n\n      var previousState = this.contentType.dataStore.getPreviousState();\n\n      var diff = _mageUtils.compare(previousState, state).changes;\n\n      if (diff.length > 0) {\n        return _underscore.some(diff, function (element) {\n          if (element.name === \"video_fallback_image\") {\n            return (!_underscore.isEmpty(previousState.video_fallback_image) && previousState.video_fallback_image) !== (!_underscore.isEmpty(state.video_fallback_image) && state.video_fallback_image);\n          }\n\n          return _this10.videoUpdateProperties.indexOf(element.name) !== -1;\n        });\n      }\n    };\n\n    return Preview;\n  }(_preview);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/slide/converter/attribute/overlay-color.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var OverlayColor = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function OverlayColor() {}\n\n    var _proto = OverlayColor.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value === \"transparent\" ? \"\" : value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      if (data.overlay_color) {\n        return data.overlay_color.toString();\n      }\n\n      return \"\";\n    };\n\n    return OverlayColor;\n  }();\n\n  return OverlayColor;\n});\n//# sourceMappingURL=overlay-color.js.map","Magento_PageBuilder/js/content-type/slide/converter/style/overlay-background-color.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var OverlayBackgroundColor = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function OverlayBackgroundColor() {}\n\n    var _proto = OverlayBackgroundColor.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n\n      if (data.show_overlay === \"always\" && value !== \"\" && value !== undefined) {\n        return value;\n      }\n\n      return \"transparent\";\n    };\n\n    return OverlayBackgroundColor;\n  }();\n\n  return OverlayBackgroundColor;\n});\n//# sourceMappingURL=overlay-background-color.js.map","Magento_PageBuilder/js/content-type/slide/converter/style/paddings.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var Paddings = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Paddings() {}\n\n    var _proto = Paddings.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      var result = {};\n\n      if (undefined !== value.padding) {\n        result.padding = {\n          bottom: value.padding.bottom.replace(\"px\", \"\"),\n          left: value.padding.left.replace(\"px\", \"\"),\n          right: value.padding.right.replace(\"px\", \"\"),\n          top: value.padding.top.replace(\"px\", \"\")\n        };\n      }\n\n      if (result.padding.right[0] === \"c\") {\n        result.padding.right = parseInt(result.padding.right.split(\"+\")[1].trim(), 10);\n      }\n\n      if (result.padding.left[0] === \"c\") {\n        result.padding.left = parseInt(result.padding.left.split(\"+\")[1].trim(), 10);\n      }\n\n      return result;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var result = {};\n      var value = (0, _object.get)(data, name);\n\n      if (value && _underscore.isString(value)) {\n        value = JSON.parse(value);\n      }\n\n      if (value && undefined !== value.padding) {\n        result.paddingLeft = value.padding.left ? value.padding.left + \"px\" : \"\";\n        result.paddingTop = value.padding.top ? value.padding.top + \"px\" : \"\";\n        result.paddingRight = value.padding.right ? value.padding.right + \"px\" : \"\";\n        result.paddingBottom = value.padding.bottom ? value.padding.bottom + \"px\" : \"\";\n      }\n\n      return result;\n    };\n\n    return Paddings;\n  }();\n\n  return Paddings;\n});\n//# sourceMappingURL=paddings.js.map","Magento_PageBuilder/js/content-type/slide/converter/style/button-opacity.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var ButtonOpacity = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function ButtonOpacity() {}\n\n    var _proto = ButtonOpacity.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      return data.show_button === \"always\" ? \"1\" : \"0\";\n    };\n\n    return ButtonOpacity;\n  }();\n\n  return ButtonOpacity;\n});\n//# sourceMappingURL=button-opacity.js.map","Magento_PageBuilder/js/content-type/slide/converter/style/button-visibility.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var ButtonVisibility = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function ButtonVisibility() {}\n\n    var _proto = ButtonVisibility.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      return data.show_button === \"always\" ? \"visible\" : \"hidden\";\n    };\n\n    return ButtonVisibility;\n  }();\n\n  return ButtonVisibility;\n});\n//# sourceMappingURL=button-visibility.js.map","Magento_PageBuilder/js/content-type/slide/converter/style/margins.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var Margins = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Margins() {}\n\n    var _proto = Margins.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      if (undefined !== value.margin) {\n        return {\n          margin: {\n            top: value.margin.top.replace(\"px\", \"\"),\n            left: value.margin.left.replace(\"px\", \"\"),\n            right: value.margin.right.replace(\"px\", \"\"),\n            bottom: value.margin.bottom.replace(\"px\", \"\")\n          }\n        };\n      }\n\n      return {};\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var result = {};\n      var value = (0, _object.get)(data, name);\n\n      if (value && _underscore.isString(value)) {\n        value = JSON.parse(value);\n      }\n\n      if (value && undefined !== value.margin) {\n        result.marginLeft = value.margin.left ? value.margin.left + \"px\" : \"\";\n        result.marginTop = value.margin.top ? value.margin.top + \"px\" : \"\";\n        result.marginRight = value.margin.right ? value.margin.right + \"px\" : \"\";\n        result.marginBottom = value.margin.bottom ? value.margin.bottom + \"px\" : \"\";\n      }\n\n      return result;\n    };\n\n    return Margins;\n  }();\n\n  return Margins;\n});\n//# sourceMappingURL=margins.js.map","Magento_PageBuilder/js/content-type/slide/appearance/default/widget.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_PageBuilder/js/widget/show-on-hover',\n    'Magento_PageBuilder/js/widget/video-background'\n], function ($, _, showOnHover, videoBackground) {\n    'use strict';\n\n    return function (config, element) {\n        var videoElement = element[0].querySelector('[data-background-type=video]'),\n            viewportElement = document.createElement('div'),\n            $slider = null;\n\n        showOnHover(config);\n\n        if (videoElement) {\n            $slider = $(element).closest('[data-content-type=slider]');\n            viewportElement.classList.add('jarallax-viewport-element');\n            videoElement.setAttribute('data-element-in-viewport', '.jarallax-viewport-element');\n            videoElement.appendChild(viewportElement);\n            videoBackground(config, videoElement);\n\n            if ($slider.data('afterChangeIsSet')) {\n                return;\n            }\n\n            $slider.on('afterChange init', function () {\n                var videoSlides = $slider[0].querySelectorAll('.jarallax');\n\n                _.each(videoSlides, function (videoSlide) {\n                    videoSlide.jarallax && videoSlide.jarallax.onScroll();\n                });\n            });\n            $slider.data('afterChangeIsSet', true);\n        }\n    };\n});\n","Magento_PageBuilder/js/content-type/slide/wysiwyg/tinymce4/component-initializer.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\", \"mage/adminhtml/wysiwyg/events\", \"Magento_PageBuilder/js/utils/delay-until\"], function (_jquery, _events, _delayUntil) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var ComponentInitializer = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function ComponentInitializer() {\n      this.sliderSelector = \".slick-list\";\n      this.sliderContentSelector = \".slick-track\";\n      this.slideSelector = \".slick-slide\";\n      this.activeSlideSelector = \".slick-current\";\n      this.slideChanging = false;\n    }\n\n    var _proto = ComponentInitializer.prototype;\n\n    /**\n     * Initialize the instance\n     *\n     * @param {Wysiwyg} wysiwyg\n     */\n    _proto.initialize = function initialize(wysiwyg) {\n      var _this = this;\n\n      this.$element = (0, _jquery)(\"#\" + wysiwyg.elementId);\n      this.config = wysiwyg.config;\n      var tinymce = wysiwyg.getAdapter();\n      tinymce.eventBus.attachEventHandler(_events.afterFocus, this.onFocus.bind(this));\n      tinymce.eventBus.attachEventHandler(_events.afterBlur, this.onBlur.bind(this)); // Update our KO pointer to the active slide on change\n\n      (0, _jquery)(this.$element.parents(this.sliderSelector)).parent().on(\"beforeChange\", function () {\n        _this.slideChanging = true;\n      }).on(\"afterChange\", function () {\n        _this.slideChanging = false;\n      });\n    }\n    /**\n     * Event handler for wysiwyg focus\n     * Fixes z-index issues for tabs and column\n     * Fixes slider\n     */\n    ;\n\n    _proto.onFocus = function onFocus() {\n      var _this2 = this;\n\n      var $slider = (0, _jquery)(this.$element.parents(this.sliderSelector));\n      var sliderContent = this.$element.parents(this.sliderContentSelector)[0];\n      var $notActiveSlides = $slider.find(this.slideSelector).not(this.activeSlideSelector); // If there isn't enough room for a left-aligned toolbar, right align it\n\n      if ((0, _jquery)(window).width() < this.$element.offset().left + parseInt(this.config.adapter_config.minToolbarWidth, 10)) {\n        this.$element.addClass(\"_right-aligned-toolbar\");\n      } else {\n        this.$element.removeClass(\"_right-aligned-toolbar\");\n      }\n\n      (0, _delayUntil)(function () {\n        _jquery.each(_this2.config.adapter_config.parentSelectorsToUnderlay, function (i, selector) {\n          _this2.$element.closest(selector).css(\"z-index\", 100);\n        }); // Disable slider keyboard events and fix problem with overflow hidden issue\n\n\n        $slider.parent().slick(\"slickSetOption\", \"accessibility\", false);\n        _this2.autoplay = $slider.parent().slick(\"slickGetOption\", \"autoplay\");\n        _this2.fade = $slider.parent().slick(\"slickGetOption\", \"fade\");\n\n        if (_this2.autoplay) {\n          $slider.parent().slick(\"slickPause\");\n        }\n\n        if (!_this2.fade) {\n          $notActiveSlides.css(\"display\", \"none\");\n        }\n\n        _this2.sliderTransform = sliderContent.style.transform;\n        sliderContent.style.transform = \"\";\n        $slider.css(\"overflow\", \"visible\");\n      }, function () {\n        return !_this2.slideChanging;\n      }, 10);\n    }\n    /**\n     * Event handler for wysiwyg blur\n     * Fixes z-index issues for tabs and column\n     * Fixes slider\n     */\n    ;\n\n    _proto.onBlur = function onBlur() {\n      var _this3 = this;\n\n      var $slider = (0, _jquery)(this.$element.parents(this.sliderSelector));\n      var sliderContent = this.$element.parents(this.sliderContentSelector)[0];\n      var $notActiveSlides = $slider.find(this.slideSelector).not(this.activeSlideSelector);\n\n      _jquery.each(this.config.adapter_config.parentSelectorsToUnderlay, function (i, selector) {\n        _this3.$element.closest(selector).css(\"z-index\", \"\");\n      }); // Enable slider keyboard events and revert changes made in onFocus\n\n\n      $slider.css(\"overflow\", \"hidden\");\n      sliderContent.style.transform = this.sliderTransform;\n      $notActiveSlides.css(\"display\", \"block\");\n      $slider.parent().slick(\"slickSetOption\", \"accessibility\", true);\n\n      if (this.autoplay) {\n        $slider.parent().slick(\"slickPlay\");\n      }\n    };\n\n    return ComponentInitializer;\n  }();\n\n  return ComponentInitializer;\n});\n//# sourceMappingURL=component-initializer.js.map","Magento_PageBuilder/js/content-type/slide/wysiwyg/tinymce4/config-modifier.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var ConfigModifier = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function ConfigModifier() {}\n\n    var _proto = ConfigModifier.prototype;\n\n    /**\n     * Initialize the config\n     *\n     * @param {String} contentTypeId\n     * @param {Object} config\n     */\n    _proto.modify = function modify(contentTypeId, config) {\n      if (config.adapter_config.mode === \"inline\") {\n        config.adapter.settings.fixed_toolbar_container = \"#\" + contentTypeId + \" .wysiwyg-container\";\n      }\n    };\n\n    return ConfigModifier;\n  }();\n\n  return ConfigModifier;\n});\n//# sourceMappingURL=config-modifier.js.map","Magento_PageBuilder/js/content-type/buttons/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jquery\", \"knockout\", \"mage/translate\", \"Magento_PageBuilder/js/events\", \"underscore\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type-factory\", \"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/content-type-menu/option\", \"Magento_PageBuilder/js/utils/delay-until\", \"Magento_PageBuilder/js/content-type/preview-collection\"], function (_jquery, _knockout, _translate, _events, _underscore, _config, _contentTypeFactory, _hideShowOption, _option, _delayUntil, _previewCollection) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_previewCollection2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _previewCollection2);\n\n    /**\n     * @param {ContentTypeCollectionInterface} contentType\n     * @param {ContentTypeConfigInterface} config\n     * @param {ObservableUpdater} observableUpdater\n     */\n    function Preview(contentType, config, observableUpdater) {\n      var _this;\n\n      _this = _previewCollection2.call(this, contentType, config, observableUpdater) || this; // Keeps track of number of button item to disable sortable if there is only 1.\n\n      _this.focusedButton = _knockout.observable();\n      _this.debouncedResizeHandler = _underscore.debounce(function () {\n        _this.resizeChildButtons();\n      }, 350);\n\n      _this.contentType.children.subscribe(function () {\n        var sortableElement = (0, _jquery)(_this.wrapperElement).find(\".buttons-container\");\n\n        if (!sortableElement.data(\"sortable\")) {\n          return;\n        }\n\n        if (_this.contentType.children().length <= 1) {\n          sortableElement.sortable(\"disable\");\n        } else {\n          sortableElement.sortable(\"enable\");\n        }\n      }); // Monitor focus tab to start / stop interaction on the stage, debounce to avoid duplicate calls\n\n\n      _this.focusedButton.subscribe(_underscore.debounce(function (index) {\n        if (index !== null) {\n          _events.trigger(\"stage:interactionStart\");\n\n          var focusedButton = _this.contentType.children()[index];\n\n          (0, _delayUntil)(function () {\n            return (0, _jquery)(focusedButton.preview.wrapperElement).find(\"[contenteditable]\").focus();\n          }, function () {\n            return typeof focusedButton.preview.wrapperElement !== \"undefined\";\n          }, 10);\n        } else {\n          // We have to force the stop as the event firing is inconsistent for certain operations\n          _events.trigger(\"stage:interactionStop\", {\n            force: true\n          });\n        }\n      }, 1));\n\n      return _this;\n    }\n    /**\n     * Bind events\n     */\n\n\n    var _proto = Preview.prototype;\n\n    _proto.bindEvents = function bindEvents() {\n      var _this2 = this;\n\n      _previewCollection2.prototype.bindEvents.call(this);\n\n      _events.on(\"buttons:dropAfter\", function (args) {\n        if (args.id === _this2.contentType.id && _this2.contentType.children().length === 0) {\n          _this2.addButton();\n        }\n      });\n\n      _events.on(\"buttons:renderAfter\", function (args) {\n        if (args.contentType.id === _this2.contentType.id) {\n          _this2.debouncedResizeHandler();\n        }\n      });\n\n      _events.on(\"button-item:renderAfter\", function (args) {\n        if (args.contentType.parentContentType.id === _this2.contentType.id) {\n          _this2.debouncedResizeHandler();\n        }\n      });\n\n      _events.on(\"stage:updateAfter\", function () {\n        _this2.debouncedResizeHandler();\n      });\n\n      _events.on(\"contentType:redrawAfter\", function () {\n        _this2.debouncedResizeHandler();\n      }); // Capture when a content type is duplicated within the container\n\n\n      var duplicatedButton;\n      var duplicatedButtonIndex;\n\n      _events.on(\"button-item:duplicateAfter\", function (args) {\n        if (_this2.contentType.id === args.duplicateContentType.parentContentType.id && args.direct) {\n          duplicatedButton = args.duplicateContentType;\n          duplicatedButtonIndex = args.index;\n        }\n      });\n\n      _events.on(\"button-item:mountAfter\", function (args) {\n        if (duplicatedButton && args.id === duplicatedButton.id) {\n          _this2.focusedButton(duplicatedButtonIndex);\n        }\n      });\n    }\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n    ;\n\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _previewCollection2.prototype.retrieveOptions.call(this);\n\n      options.add = new _option({\n        preview: this,\n        icon: \"<i class='icon-pagebuilder-add'></i>\",\n        title: (0, _translate)(\"Add Button\"),\n        action: this.addButton,\n        classes: [\"add-child\"],\n        sort: 10\n      });\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    }\n    /**\n     * Add button-item to buttons children array\n     */\n    ;\n\n    _proto.addButton = function addButton() {\n      var _this3 = this;\n\n      var createButtonItemPromise = (0, _contentTypeFactory)(_config.getContentTypeConfig(\"button-item\"), this.contentType, this.contentType.stageId, {});\n      createButtonItemPromise.then(function (button) {\n        _this3.contentType.addChild(button);\n\n        var buttonIndex = _this3.contentType.children().indexOf(button);\n\n        _this3.focusedButton(buttonIndex > -1 ? buttonIndex : null);\n\n        return button;\n      }).catch(function (error) {\n        console.error(error);\n      });\n    }\n    /**\n     * Get the sortable options for the buttons sorting\n     *\n     * @param {string} orientation\n     * @param {string} tolerance\n     * @returns {JQueryUI.Sortable}\n     */\n    ;\n\n    _proto.getSortableOptions = function getSortableOptions(orientation, tolerance) {\n      if (orientation === void 0) {\n        orientation = \"width\";\n      }\n\n      if (tolerance === void 0) {\n        tolerance = \"intersect\";\n      }\n\n      return {\n        handle: \".button-item-drag-handle\",\n        items: \".pagebuilder-content-type-wrapper\",\n        cursor: \"grabbing\",\n        containment: \"parent\",\n        tolerance: tolerance,\n        revert: 200,\n        disabled: this.contentType.children().length <= 1,\n\n        /**\n         * Provide custom helper element\n         *\n         * @param {Event} event\n         * @param {JQueryUI.Sortable} element\n         * @returns {Element}\n         */\n        helper: function helper(event, element) {\n          var helper = (0, _jquery)(element).clone().css({\n            opacity: \"0.7\",\n            width: \"auto\"\n          });\n          helper[0].querySelector(\".pagebuilder-options\").remove();\n          return helper[0];\n        },\n        placeholder: {\n          /**\n           * Provide custom placeholder element\n           *\n           * @param {JQuery} item\n           * @returns {JQuery}\n           */\n          element: function element(item) {\n            var placeholder = item.clone().css({\n              display: \"inline-block\",\n              opacity: \"0.3\"\n            }).removeClass(\"focused\").addClass(\"sortable-placeholder\");\n            placeholder[0].querySelector(\".pagebuilder-options\").remove();\n            return placeholder[0];\n          },\n          update: function update() {\n            return;\n          }\n        },\n\n        /**\n         * Trigger interaction start on sort\n         */\n        start: function start() {\n          _events.trigger(\"stage:interactionStart\");\n        },\n\n        /**\n         * Stop stage interaction on stop\n         */\n        stop: function stop() {\n          _events.trigger(\"stage:interactionStop\");\n        }\n      };\n    }\n    /**\n     * Resize width of all child buttons. Dependently make them the same width if configured.\n     */\n    ;\n\n    _proto.resizeChildButtons = function resizeChildButtons() {\n      if (this.wrapperElement) {\n        var buttonItems = (0, _jquery)(this.wrapperElement).find(\".pagebuilder-button-item > a\");\n        var buttonResizeValue = 0;\n\n        if (this.contentType.dataStore.get(\"is_same_width\") === \"true\") {\n          if (buttonItems.length > 0) {\n            var currentLargestButtonWidth = this.findLargestButtonWidth(buttonItems);\n            var parentWrapperWidth = (0, _jquery)(this.wrapperElement).find(\".buttons-container\").width();\n\n            if (currentLargestButtonWidth === 0) {\n              return;\n            }\n\n            buttonResizeValue = Math.min(currentLargestButtonWidth, parentWrapperWidth);\n          }\n        }\n\n        buttonItems.css(\"min-width\", buttonResizeValue);\n      }\n    }\n    /**\n     * Find the largest button width for calculating same size value.\n     *\n     * @param {JQuery} buttonItems\n     * @returns {number}\n     */\n    ;\n\n    _proto.findLargestButtonWidth = function findLargestButtonWidth(buttonItems) {\n      var _this4 = this;\n\n      return _underscore.max(_underscore.map(buttonItems, function (buttonItem) {\n        return _this4.calculateButtonWidth((0, _jquery)(buttonItem));\n      }));\n    }\n    /**\n     * Manually calculate button width using content plus box widths (padding, border)\n     *\n     * @param {JQuery} buttonItem\n     * @returns {number}\n     */\n    ;\n\n    _proto.calculateButtonWidth = function calculateButtonWidth(buttonItem) {\n      if (buttonItem.is(\":visible\") === false) {\n        return 0;\n      }\n\n      var widthProperties = [\"paddingLeft\", \"paddingRight\", \"borderLeftWidth\", \"borderRightWidth\"];\n      var buttonText = buttonItem.find(\"[data-element='link_text']\");\n      var textWidth = buttonText.css(\"display\", \"inline-block\").width();\n      buttonText.css(\"display\", \"\");\n      return widthProperties.reduce(function (accumulatedWidth, widthProperty) {\n        return accumulatedWidth + (parseInt(buttonItem.css(widthProperty), 10) || 0);\n      }, textWidth);\n    };\n\n    return Preview;\n  }(_previewCollection);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/buttons/converter/style/preview/display/flex.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Display = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Display() {}\n\n    var _proto = Display.prototype;\n\n    /**\n     * Ensure the display none property doesn't persist to the preview\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return;\n    }\n    /**\n     * Ensure the display none property doesn't persist to the preview\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      return \"flex\";\n    };\n\n    return Display;\n  }();\n\n  return Display;\n});\n//# sourceMappingURL=flex.js.map","Magento_PageBuilder/js/content-type/buttons/converter/style/display/boolean.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Boolean = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Boolean() {}\n\n    var _proto = Boolean.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return !(value === \"none\");\n    }\n    /**\n     * Convert value to knockout format, if buttons are displayed they should be reset to default\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n\n      if (!_underscore.isUndefined(value) && value === false) {\n        return \"none\";\n      }\n\n      return \"\";\n    };\n\n    return Boolean;\n  }();\n\n  return Boolean;\n});\n//# sourceMappingURL=boolean.js.map","Magento_PageBuilder/js/content-type/buttons/converter/style/display/flex.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Flex = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Flex() {}\n\n    var _proto = Flex.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return !(value === \"none\");\n    }\n    /**\n     * Convert value to knockout format, if buttons are displayed they should be inline block\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n\n      if (!_underscore.isUndefined(value) && value === false) {\n        return \"none\";\n      }\n\n      return \"flex\";\n    };\n\n    return Flex;\n  }();\n\n  return Flex;\n});\n//# sourceMappingURL=flex.js.map","Magento_PageBuilder/js/content-type/buttons/appearance/inline/widget.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_PageBuilder/js/events'\n], function ($, events) {\n    'use strict';\n\n    /**\n     * Equalize the width of a list of button-item components\n     *\n     * @param {JQuery} buttonList\n     */\n    var equalizeButtonWidth = function (buttonList) {\n        var buttonMinWidth = 0;\n\n        buttonList.css('min-width', buttonMinWidth);\n        buttonList.each(function () {\n            var buttonWidth = this.offsetWidth;\n\n            if (buttonWidth > buttonMinWidth) {\n                buttonMinWidth = buttonWidth;\n            }\n        });\n        buttonList.css('min-width', buttonMinWidth);\n    };\n\n    return function (config, element) {\n        var $element = $(element),\n            buttonSelector = '[data-element=\"link\"], [data-element=\"empty_link\"]';\n\n        if ($element.data('sameWidth')) {\n            equalizeButtonWidth($element.find(buttonSelector));\n            $(window).resize(function () {\n                equalizeButtonWidth($element.find(buttonSelector));\n            });\n            events.on('contentType:redrawAfter', function (eventData) {\n                if ($element.closest(eventData.element).length > 0) {\n                    equalizeButtonWidth($element.find(buttonSelector));\n                }\n            });\n        }\n    };\n});\n","Magento_PageBuilder/js/content-type/root-container/content-type-collection.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"Magento_Ui/js/modal/alert\", \"Magento_PageBuilder/js/content-type-collection\"], function (_alert, _contentTypeCollection) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var RootContainer = /*#__PURE__*/function (_contentTypeCollectio) {\n    \"use strict\";\n\n    _inheritsLoose(RootContainer, _contentTypeCollectio);\n\n    function RootContainer() {\n      return _contentTypeCollectio.apply(this, arguments) || this;\n    }\n\n    var _proto = RootContainer.prototype;\n\n    /**\n     * Remove a child from the observable array\n     *\n     * @param child\n     */\n    _proto.removeChild = function removeChild(child) {\n      if (this.getChildren().length === 1) {\n        (0, _alert)({\n          content: $t(\"You are not able to remove the final row from the content.\"),\n          title: $t(\"Unable to Remove\")\n        });\n        return;\n      }\n\n      _contentTypeCollectio.prototype.removeChild.call(this, child);\n    };\n\n    return RootContainer;\n  }(_contentTypeCollection);\n\n  return RootContainer;\n});\n//# sourceMappingURL=content-type-collection.js.map","Magento_PageBuilder/js/content-type/tab-item/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jquery\", \"knockout\", \"Magento_PageBuilder/js/content-type-menu/conditional-remove-option\", \"Magento_PageBuilder/js/content-type/preview-collection\"], function (_jquery, _knockout, _conditionalRemoveOption, _previewCollection) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_previewCollection2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _previewCollection2);\n\n    function Preview() {\n      var _this;\n\n      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {\n        args[_key] = arguments[_key];\n      }\n\n      _this = _previewCollection2.call.apply(_previewCollection2, [this].concat(args)) || this;\n      _this.fieldsToIgnoreOnRemove = [\"tab_name\"];\n      return _this;\n    }\n\n    var _proto = Preview.prototype;\n\n    /**\n     * Get background image url base on the viewport.\n     *\n     * @returns {string}\n     */\n    _proto.getBackgroundImage = function getBackgroundImage() {\n      var mobileImage = this.contentType.dataStore.get(\"mobile_image\");\n      var desktopImage = this.contentType.dataStore.get(\"background_image\");\n      var backgroundImage = this.viewport() === \"mobile\" && mobileImage.length ? mobileImage : desktopImage;\n      return backgroundImage.length ? \"url(\\\"\" + backgroundImage[0].url + \"\\\")\" : \"none\";\n    }\n    /**\n     * Force the focus on the clicked tab header\n     *\n     * @param {number} index\n     * @param {JQueryEventObject} event\n     */\n    ;\n\n    _proto.onClick = function onClick(index, event) {\n      (0, _jquery)(event.currentTarget).find(\"[contenteditable]\").focus();\n      event.stopPropagation();\n    }\n    /**\n     * On focus in set the focused button\n     *\n     * @param {number} index\n     * @param {Event} event\n     */\n    ;\n\n    _proto.onFocusIn = function onFocusIn(index, event) {\n      var parentPreview = this.contentType.parentContentType.preview;\n\n      if (parentPreview.focusedTab() !== index) {\n        parentPreview.setFocusedTab(index, true);\n      }\n    }\n    /**\n     * On focus out set the focused tab to null\n     *\n     * @param {number} index\n     * @param {JQueryEventObject} event\n     */\n    ;\n\n    _proto.onFocusOut = function onFocusOut(index, event) {\n      if (this.contentType && this.contentType.parentContentType) {\n        var parentPreview = this.contentType.parentContentType.preview;\n\n        var unfocus = function unfocus() {\n          window.getSelection().removeAllRanges();\n          parentPreview.focusedTab(null);\n        };\n\n        if (event.relatedTarget && _jquery.contains(parentPreview.wrapperElement, event.relatedTarget)) {\n          // Verify the focus was not onto the options menu\n          if ((0, _jquery)(event.relatedTarget).closest(\".pagebuilder-options\").length > 0) {\n            unfocus();\n          } else {\n            // Have we moved the focus onto another button in the current group?\n            var tabItem = _knockout.dataFor(event.relatedTarget);\n\n            if (tabItem && tabItem.contentType && tabItem.contentType.parentContentType && tabItem.contentType.parentContentType.id === this.contentType.parentContentType.id) {\n              var newIndex = tabItem.contentType.parentContentType.children().indexOf(tabItem.contentType);\n              parentPreview.setFocusedTab(newIndex, true);\n            } else {\n              unfocus();\n            }\n          }\n        } else if (parentPreview.focusedTab() === index) {\n          unfocus();\n        }\n      }\n    }\n    /**\n     * Get the options instance\n     *\n     * @returns {OptionsInterface}\n     */\n    ;\n\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _previewCollection2.prototype.retrieveOptions.call(this);\n\n      delete options.move;\n      delete options.title;\n      options.remove = new _conditionalRemoveOption(_extends({}, options.remove.config, {\n        preview: this\n      }));\n      return options;\n    };\n\n    return Preview;\n  }(_previewCollection);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/heading/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jquery\", \"Magento_PageBuilder/js/events\", \"underscore\", \"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/content-type-toolbar\", \"Magento_PageBuilder/js/utils/promise-deferred\", \"Magento_PageBuilder/js/content-type/preview\"], function (_jquery, _events, _underscore, _hideShowOption, _contentTypeToolbar, _promiseDeferred, _preview) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_preview2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _preview2);\n\n    /**\n     * @param {ContentTypeInterface} contentType\n     * @param {ContentTypeConfigInterface} config\n     * @param {ObservableUpdater} observableUpdater\n     */\n    function Preview(contentType, config, observableUpdater) {\n      var _this;\n\n      _this = _preview2.call(this, contentType, config, observableUpdater) || this;\n      _this.afterRenderDeferred = (0, _promiseDeferred)();\n      _this.toolbar = new _contentTypeToolbar(_assertThisInitialized(_this), _this.getToolbarOptions());\n      return _this;\n    }\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n\n\n    var _proto = Preview.prototype;\n\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _preview2.prototype.retrieveOptions.call(this);\n\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    }\n    /**\n     * On render init the heading\n     *\n     * @param {Element} element\n     */\n    ;\n\n    _proto.afterRender = function afterRender(element) {\n      this.element = element;\n      this.afterRenderDeferred.resolve(element);\n    };\n\n    _proto.bindEvents = function bindEvents() {\n      var _this2 = this;\n\n      _preview2.prototype.bindEvents.call(this); // When a heading is dropped for the first time show heading toolbar\n\n\n      _events.on(\"heading:dropAfter\", function (args) {\n        if (args.id === _this2.contentType.id) {\n          Promise.all([_this2.afterRenderDeferred.promise, _this2.toolbar.afterRenderDeferred.promise]).then(function (_ref) {\n            var element = _ref[0];\n\n            _underscore.defer(function () {\n              (0, _jquery)(element).focus();\n            });\n          });\n        }\n      });\n    }\n    /**\n     * Get option value from observable data.\n     *\n     * @param {string} key\n     * @return {*}\n     */\n    ;\n\n    _proto.getOptionValue = function getOptionValue(key) {\n      if (key === \"heading_type\") {\n        return this.data.main.heading_type();\n      } else if (key === \"text_align\") {\n        return this.data.main.style().textAlign;\n      }\n\n      return;\n    }\n    /**\n     * Build and return the tool bar options for heading\n     *\n     * @returns {OptionInterface[]}\n     */\n    ;\n\n    _proto.getToolbarOptions = function getToolbarOptions() {\n      return [{\n        key: \"heading_type\",\n        type: \"select\",\n        values: [{\n          value: \"h1\",\n          label: \"H1\",\n          icon: \"\"\n        }, {\n          value: \"h2\",\n          label: \"H2\",\n          icon: \"\"\n        }, {\n          value: \"h3\",\n          label: \"H3\",\n          icon: \"\"\n        }, {\n          value: \"h4\",\n          label: \"H4\",\n          icon: \"\"\n        }, {\n          value: \"h5\",\n          label: \"H5\",\n          icon: \"\"\n        }, {\n          value: \"h6\",\n          label: \"H6\",\n          icon: \"\"\n        }]\n      }, {\n        key: \"text_align\",\n        type: \"select\",\n        values: [{\n          value: \"left\",\n          label: \"Left\",\n          icon: \"icon-pagebuilder-align-left\"\n        }, {\n          value: \"center\",\n          label: \"Center\",\n          icon: \"icon-pagebuilder-align-center\"\n        }, {\n          value: \"right\",\n          label: \"Right\",\n          icon: \"icon-pagebuilder-align-right\"\n        }]\n      }];\n    };\n\n    return Preview;\n  }(_preview);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/slider/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jquery\", \"knockout\", \"mage/translate\", \"Magento_PageBuilder/js/events\", \"slick\", \"underscore\", \"Magento_PageBuilder/js/binding/focus\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type-factory\", \"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/content-type-menu/option\", \"Magento_PageBuilder/js/utils/delay-until\", \"Magento_PageBuilder/js/utils/promise-deferred\", \"Magento_PageBuilder/js/content-type/preview-collection\"], function (_jquery, _knockout, _translate, _events, _slick, _underscore, _focus, _config, _contentTypeFactory, _hideShowOption, _option, _delayUntil, _promiseDeferred, _previewCollection) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_previewCollection2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _previewCollection2);\n\n    /**\n     * Define keys which when changed should not trigger the slider to be rebuilt\n     *\n     * @type {string[]}\n     */\n\n    /**\n     * @param {ContentTypeCollectionInterface} contentType\n     * @param {ContentTypeConfigInterface} config\n     * @param {ObservableUpdater} observableUpdater\n     */\n    function Preview(contentType, config, observableUpdater) {\n      var _this;\n\n      _this = _previewCollection2.call(this, contentType, config, observableUpdater) || this; // Wait for the tabs instance to mount and the container to be ready\n\n      _this.focusedSlide = _knockout.observable();\n      _this.activeSlide = _knockout.observable(0);\n      _this.events = {\n        columnWidthChangeAfter: \"onColumnResize\"\n      };\n      _this.ready = false;\n      _this.mountAfterDeferred = (0, _promiseDeferred)();\n      _this.afterChildrenRenderDeferred = (0, _promiseDeferred)();\n      _this.buildSlickDebounce = _underscore.debounce(_this.buildSlick.bind(_assertThisInitialized(_this)), 10);\n      _this.ignoredKeysForBuild = [\"display\", \"margins_and_padding\", \"border\", \"border_color\", \"border_radius\", \"border_width\", \"css_classes\", \"name\", \"text_align\"];\n      Promise.all([_this.afterChildrenRenderDeferred.promise, _this.mountAfterDeferred.promise]).then(function (_ref) {\n        var element = _ref[0],\n            expectedChildren = _ref[1];\n        // We always create 1 tab when dropping tabs into the instance\n        expectedChildren = expectedChildren || 1; // Wait until all children's DOM elements are present before building the tabs instance\n\n        (0, _delayUntil)(function () {\n          _this.element = element;\n          _this.childSubscribe = _this.contentType.children.subscribe(_this.buildSlickDebounce);\n          _this.previousData = _this.contentType.dataStore.getState();\n\n          _this.contentType.dataStore.subscribe(function (data) {\n            if (_this.hasDataChanged(_this.previousData, data)) {\n              _this.buildSlickDebounce();\n            }\n\n            _this.previousData = data;\n          });\n\n          _this.buildSlick(); // Redraw slide after content type gets redrawn\n\n\n          _events.on(\"contentType:redrawAfter\", function (args) {\n            var $element = (0, _jquery)(_this.element);\n\n            if (args.element && _this.element && $element.closest(args.element).length) {\n              $element.slick(\"setPosition\");\n            }\n          }); // Set the stage to interacting when a slide is focused\n\n\n          _this.focusedSlideSubscriber = _this.focusedSlide.subscribe(function (value) {\n            if (value !== null) {\n              _events.trigger(\"stage:interactionStart\");\n            } else {\n              _events.trigger(\"stage:interactionStop\");\n            }\n          });\n\n          _events.on(\"stage:\" + _this.contentType.stageId + \":fullScreenModeChangeAfter\", _this.onColumnResize.bind(_assertThisInitialized(_this), [true]));\n\n          _events.on(\"stage:\" + _this.contentType.stageId + \":viewportChangeAfter\", function () {\n            if (_this.element) {\n              (0, _jquery)(_this.element).slick(\"setPosition\");\n\n              _this.checkWidth();\n            }\n          });\n        }, function () {\n          return (0, _jquery)(element).find(\".pagebuilder-slide\").length === expectedChildren;\n        });\n      });\n      return _this;\n    }\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n\n\n    var _proto = Preview.prototype;\n\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _previewCollection2.prototype.retrieveOptions.call(this);\n\n      options.add = new _option({\n        preview: this,\n        icon: \"<i class='icon-pagebuilder-add'></i>\",\n        title: (0, _translate)(\"Add\"),\n        action: this.addSlide,\n        classes: [\"add-child\"],\n        sort: 10\n      });\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    }\n    /**\n     * Set an active slide for navigation dot\n     *\n     * @param slideIndex\n     */\n    ;\n\n    _proto.setActiveSlide = function setActiveSlide(slideIndex) {\n      this.activeSlide(slideIndex);\n    }\n    /**\n     * Set the focused slide\n     *\n     * @param {number} slideIndex\n     * @param {boolean} force\n     */\n    ;\n\n    _proto.setFocusedSlide = function setFocusedSlide(slideIndex, force) {\n      if (force === void 0) {\n        force = false;\n      }\n\n      if (force) {\n        this.focusedSlide(null);\n      }\n\n      this.focusedSlide(slideIndex);\n    }\n    /**\n     * Unset focused slide on focusout event.\n     *\n     * @param {PreviewCollection} data\n     * @param {JQueryEventObject} event\n     */\n    ;\n\n    _proto.onFocusOut = function onFocusOut(data, event) {\n      var relatedTarget = event.relatedTarget;\n\n      if (!relatedTarget && document.activeElement && !(document.activeElement instanceof HTMLBodyElement)) {\n        relatedTarget = document.activeElement;\n      }\n\n      if (!relatedTarget) {\n        this.setFocusedSlide(null);\n        return;\n      }\n\n      var $relatedTarget = (0, _jquery)(relatedTarget);\n      var isRelatedTargetDescendantOfNavigation = $relatedTarget.closest(this.navigationElement).length;\n      var isFocusedOnAnotherSlideInThisSlider = $relatedTarget.hasClass(\"navigation-dot-anchor\") && isRelatedTargetDescendantOfNavigation;\n\n      if (isFocusedOnAnotherSlideInThisSlider) {\n        _events.trigger(\"stage:interactionStop\");\n      } else if (!isRelatedTargetDescendantOfNavigation) {\n        this.setFocusedSlide(null);\n      }\n    }\n    /**\n     * Set reference to navigation element in template\n     *\n     * @param {HTMLElement} navigationElement\n     */\n    ;\n\n    _proto.afterNavigationRender = function afterNavigationRender(navigationElement) {\n      this.navigationElement = navigationElement;\n    }\n    /**\n     * Navigate to a slide\n     *\n     * @param {number} slideIndex\n     * @param {boolean} dontAnimate\n     * @param {boolean} force\n     */\n    ;\n\n    _proto.navigateToSlide = function navigateToSlide(slideIndex, dontAnimate, force) {\n      if (dontAnimate === void 0) {\n        dontAnimate = false;\n      }\n\n      if (force === void 0) {\n        force = false;\n      }\n\n      if ((0, _jquery)(this.element).hasClass(\"slick-initialized\")) {\n        (0, _jquery)(this.element).slick(\"slickGoTo\", slideIndex, dontAnimate);\n        this.setActiveSlide(slideIndex);\n        this.setFocusedSlide(slideIndex, force);\n      }\n    }\n    /**\n     * After child render record element\n     *\n     * @param {HTMLElement} element\n     */\n    ;\n\n    _proto.afterChildrenRender = function afterChildrenRender(element) {\n      this.element = element; // if slider has been re-rendered previously on this element, re-build\n\n      if (this.ready) {\n        this.buildSlick();\n      }\n\n      _previewCollection2.prototype.afterChildrenRender.call(this, element);\n\n      this.afterChildrenRenderDeferred.resolve(element);\n    }\n    /**\n     * On sort start force the container height, also focus to that slide\n     *\n     * @param {Event} event\n     * @param {JQueryUI.SortableUIParams} params\n     */\n    ;\n\n    _proto.onSortStart = function onSortStart(event, params) {\n      this.forceContainerHeight();\n\n      if (this.activeSlide() !== params.item.index() || this.focusedSlide() !== params.item.index()) {\n        this.navigateToSlide(params.item.index(), false, true); // As we've completed a navigation request we need to ensure we don't remove the forced height\n\n        this.contentTypeHeightReset = true;\n      }\n    }\n    /**\n     * On sort stop ensure the focused slide and the active slide are in sync, as the focus can be lost in this\n     * operation\n     */\n    ;\n\n    _proto.onSortStop = function onSortStop(event, params) {\n      var _this2 = this;\n\n      if (this.activeSlide() !== this.focusedSlide()) {\n        this.setFocusedSlide(this.activeSlide(), true);\n      }\n\n      if (params.item.index() !== -1) {\n        _underscore.defer(this.focusElement.bind(this, event, params.item.index()));\n      }\n\n      _underscore.defer(function () {\n        (0, _jquery)(_this2.element).css({\n          height: \"\",\n          overflow: \"\"\n        });\n      });\n    }\n    /**\n     * Add a slide into the slider\n     */\n    ;\n\n    _proto.addSlide = function addSlide() {\n      var _this3 = this;\n\n      (0, _contentTypeFactory)(_config.getConfig(\"content_types\").slide, this.contentType, this.contentType.stageId).then(function (slide) {\n        _events.on(\"slide:mountAfter\", function (args) {\n          if (args.id === slide.id) {\n            _underscore.defer(function () {\n              // Wait until slick is initialized before trying to navigate\n              (0, _delayUntil)(function () {\n                return _this3.navigateToSlide(_this3.contentType.children().length - 1);\n              }, function () {\n                return (0, _jquery)(_this3.element).hasClass(\"slick-initialized\");\n              }, 10);\n            });\n\n            _events.off(\"slide:\" + slide.id + \":mountAfter\");\n          }\n        }, \"slide:\" + slide.id + \":mountAfter\");\n\n        _this3.contentType.addChild(slide, _this3.contentType.children().length);\n      });\n    }\n    /**\n     * Slider can not receive drops by default\n     *\n     * @returns {boolean}\n     */\n    ;\n\n    _proto.isContainer = function isContainer() {\n      return false;\n    }\n    /**\n     * Slider navigation click handler.\n     *\n     * @param {number} index\n     * @param {Preview} context\n     * @param {Event} event\n     */\n    ;\n\n    _proto.onControlClick = function onControlClick(index, context, event) {\n      (0, _jquery)(event.target).focus();\n      this.navigateToSlide(index);\n      this.setFocusedSlide(index);\n    }\n    /**\n     * @inheritdoc\n     */\n    ;\n\n    _proto.destroy = function destroy() {\n      _previewCollection2.prototype.destroy.call(this);\n\n      if (this.focusedSlideSubscriber) {\n        this.focusedSlideSubscriber.dispose();\n      }\n    }\n    /**\n     * Bind events\n     */\n    ;\n\n    _proto.bindEvents = function bindEvents() {\n      var _this4 = this;\n\n      _previewCollection2.prototype.bindEvents.call(this);\n\n      _events.on(\"slider:mountAfter\", function (args) {\n        if (args.id === _this4.contentType.id) {\n          if (args.expectChildren !== undefined) {\n            _this4.mountAfterDeferred.resolve(args.expectChildren);\n          }\n        }\n      }); // Set the active slide to the new position of the sorted slide\n\n\n      _events.on(\"childContentType:sortUpdate\", function (args) {\n        if (args.instance.id === _this4.contentType.id) {\n          (0, _jquery)(args.ui.item).remove(); // Remove the item as the container's children is controlled by knockout\n\n          _this4.setActiveSlide(args.newPosition);\n\n          _underscore.defer(_this4.focusElement.bind(_this4, args.event, args.newPosition));\n        }\n      }); // When a slide content type is removed\n      // we need to force update the content of the slider due to KO rendering issues\n\n\n      var newItemIndex;\n\n      _events.on(\"slide:removeAfter\", function (args) {\n        if (args.parentContentType && args.parentContentType.id === _this4.contentType.id) {\n          // Mark the previous slide as active\n          newItemIndex = args.index - 1 >= 0 ? args.index - 1 : 0;\n\n          _this4.forceContainerHeight();\n\n          var data = _this4.contentType.children().slice(0);\n\n          _this4.contentType.children([]);\n\n          _this4.contentType.children(data);\n\n          _underscore.defer(function () {\n            _this4.buildSlick();\n          });\n        }\n      });\n\n      _events.on(\"slide:renderAfter\", function (args) {\n        var itemIndex = args.contentType.parentContentType.getChildren()().indexOf(args.contentType);\n\n        if (args.contentType.parentContentType.id === _this4.contentType.id && newItemIndex !== null && newItemIndex === itemIndex) {\n          _underscore.defer(function () {\n            if (newItemIndex !== null) {\n              newItemIndex = null;\n\n              _this4.navigateToSlide(itemIndex, true, true);\n\n              _underscore.defer(function () {\n                _this4.focusedSlide(null);\n\n                _this4.focusedSlide(itemIndex);\n              });\n            }\n          });\n        }\n      }); // On a slide content types creation we need to lock the height of the slider to ensure a smooth transition\n\n\n      _events.on(\"slide:createAfter\", function (args) {\n        if (_this4.element && _this4.ready && args.contentType.parentContentType.id === _this4.contentType.id) {\n          _this4.forceContainerHeight();\n\n          _underscore.defer(function () {\n            (0, _jquery)(_this4.element).css({\n              height: \"\",\n              overflow: \"\"\n            });\n          });\n        }\n      }); // ContentType being mounted onto container\n\n\n      _events.on(\"slider:dropAfter\", function (args) {\n        if (args.id === _this4.contentType.id && _this4.contentType.children().length === 0) {\n          _this4.addSlide();\n        }\n      }); // Capture when a content type is duplicated within the container\n\n\n      var duplicatedSlide;\n      var duplicatedSlideIndex;\n\n      _events.on(\"slide:duplicateAfter\", function (args) {\n        if (args.duplicateContentType.parentContentType.id === _this4.contentType.id && args.direct) {\n          duplicatedSlide = args.duplicateContentType;\n          duplicatedSlideIndex = args.index;\n        }\n      });\n\n      _events.on(\"slide:mountAfter\", function (args) {\n        if (duplicatedSlide && args.id === duplicatedSlide.id) {\n          _underscore.defer(function () {\n            // Mark the new duplicate slide as active\n            _this4.navigateToSlide(duplicatedSlideIndex, true, true);\n\n            duplicatedSlide = duplicatedSlideIndex = null;\n          });\n        }\n      });\n    }\n    /**\n     * Determine if the data has changed, whilst ignoring certain keys which don't require a rebuild\n     *\n     * @param {DataObject} previousData\n     * @param {DataObject} newData\n     * @returns {boolean}\n     */\n    ;\n\n    _proto.hasDataChanged = function hasDataChanged(previousData, newData) {\n      previousData = _underscore.omit(previousData, this.ignoredKeysForBuild);\n      newData = _underscore.omit(newData, this.ignoredKeysForBuild);\n      return !_underscore.isEqual(previousData, newData);\n    }\n    /**\n     * Build our instance of slick\n     */\n    ;\n\n    _proto.buildSlick = function buildSlick() {\n      var _this5 = this;\n\n      if (this.element && this.element.children.length > 0) {\n        try {\n          (0, _jquery)(this.element).slick(\"unslick\");\n        } catch (e) {// We aren't concerned if this fails, slick throws an Exception when we cannot unslick\n        } // Dispose current subscription in order to prevent infinite loop\n\n\n        if (this.childSubscribe) {\n          this.childSubscribe.dispose();\n        } // Force an update on all children, ko tries to intelligently re-render but fails\n\n\n        var data = this.contentType.children().slice(0);\n        this.contentType.children([]);\n        (0, _jquery)(this.element).empty();\n        this.contentType.children(data); // Re-subscribe original event\n\n        this.childSubscribe = this.contentType.children.subscribe(this.buildSlickDebounce); // Bind our init event for slick\n\n        (0, _jquery)(this.element).on(\"init\", function () {\n          _this5.ready = true;\n        }); // Build slick\n\n        (0, _jquery)(this.element).slick(Object.assign({\n          initialSlide: this.activeSlide() || 0\n        }, this.buildSlickConfig())); // Update our KO pointer to the active slide on change\n\n        (0, _jquery)(this.element).on(\"beforeChange\", function (event, slick, currentSlide, nextSlide) {\n          (0, _jquery)(_this5.element).css(\"pointer-events\", \"none\");\n\n          _this5.setActiveSlide(nextSlide);\n        }).on(\"afterChange\", function () {\n          if (!_this5.contentTypeHeightReset) {\n            (0, _jquery)(_this5.element).css({\n              height: \"\",\n              overflow: \"\"\n            });\n            _this5.contentTypeHeightReset = null;\n          }\n\n          (0, _jquery)(_this5.element).css(\"pointer-events\", \"\");\n        });\n      }\n    }\n    /**\n     * Take dropped element on focus.\n     *\n     * @param {JQueryEventObject} event\n     * @param {number} index\n     */\n    ;\n\n    _proto.focusElement = function focusElement(event, index) {\n      var handleClassName = (0, _jquery)(event.target).data(\"sortable\").options.handle;\n      (0, _jquery)((0, _jquery)(event.target).find(handleClassName)[index]).focus();\n    }\n    /**\n     * To ensure smooth animations we need to lock the container height\n     */\n    ;\n\n    _proto.forceContainerHeight = function forceContainerHeight() {\n      (0, _jquery)(this.element).css({\n        height: (0, _jquery)(this.element).outerHeight(),\n        overflow: \"hidden\"\n      });\n    }\n    /**\n     * Build the slick config object\n     *\n     * @returns {{autoplay: boolean; autoplaySpeed: (any | number);\n     * fade: boolean; infinite: boolean; arrows: boolean; dots: boolean}}\n     */\n    ;\n\n    _proto.buildSlickConfig = function buildSlickConfig() {\n      var data = this.contentType.dataStore.getState();\n      return {\n        arrows: data.show_arrows === \"true\",\n        autoplay: data.autoplay === \"true\",\n        autoplaySpeed: data.autoplay_speed,\n        dots: false,\n        // We have our own dots implemented\n        fade: data.fade === \"true\",\n        infinite: data.is_infinite === \"true\",\n        waitForAnimate: false,\n        swipe: false\n      };\n    }\n    /**\n     * Fit slider in column container\n     *\n     * @param params\n     */\n    ;\n\n    _proto.onColumnResize = function onColumnResize(params) {\n      var _this6 = this;\n\n      setTimeout(function () {\n        if (_this6.element) {\n          (0, _jquery)(_this6.element).slick(\"setPosition\");\n\n          _this6.checkWidth();\n        }\n      }, 450);\n    }\n    /**\n     * Check width and add class that marks element as small\n     */\n    ;\n\n    _proto.checkWidth = function checkWidth() {\n      if (this.element.offsetWidth < 410) {\n        this.element.classList.add(\"slider-small-width\");\n      } else {\n        this.element.classList.remove(\"slider-small-width\");\n      }\n    };\n\n    return Preview;\n  }(_previewCollection);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/slider/appearance/default/widget.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_PageBuilder/js/events',\n    'slick'\n], function ($, events) {\n    'use strict';\n\n    return function (config, sliderElement) {\n        var $element = $(sliderElement);\n\n        /**\n         * Prevent each slick slider from being initialized more than once which could throw an error.\n         */\n        if ($element.hasClass('slick-initialized')) {\n            $element.slick('unslick');\n        }\n\n        $element.slick({\n            autoplay: $element.data('autoplay'),\n            autoplaySpeed: $element.data('autoplay-speed') || 0,\n            fade: $element.data('fade'),\n            infinite: $element.data('infinite-loop'),\n            arrows: $element.data('show-arrows'),\n            dots: $element.data('show-dots')\n        });\n\n        // Redraw slide after content type gets redrawn\n        events.on('contentType:redrawAfter', function (args) {\n            if ($element.closest(args.element).length) {\n                $element.slick('setPosition');\n            }\n        });\n        events.on('stage:viewportChangeAfter', $element.slick.bind($element, 'setPosition'));\n    };\n});\n","Magento_PageBuilder/js/content-type/html/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/content-type/preview\"], function (_hideShowOption, _preview) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_preview2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _preview2);\n\n    function Preview() {\n      return _preview2.apply(this, arguments) || this;\n    }\n\n    var _proto = Preview.prototype;\n\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _preview2.prototype.retrieveOptions.call(this);\n\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    };\n\n    return Preview;\n  }(_preview);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/column/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }\n\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jquery\", \"knockout\", \"mage/translate\", \"Magento_PageBuilder/js/events\", \"Magento_Ui/js/modal/alert\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type-factory\", \"Magento_PageBuilder/js/content-type-menu/option\", \"Magento_PageBuilder/js/content-type/column-group/grid-size\", \"Magento_PageBuilder/js/content-type/column-group/preview\", \"Magento_PageBuilder/js/content-type/preview-collection\", \"Magento_PageBuilder/js/content-type/column/resize\"], function (_jquery, _knockout, _translate, _events, _alert, _config, _contentTypeFactory, _option, _gridSize, _preview, _previewCollection, _resize) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_previewCollection2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _previewCollection2);\n\n    /**\n     * Fields that should not be considered when evaluating whether an object has been configured.\n     *\n     * @see {Preview.isConfigured}\n     * @type {[string]}\n     */\n\n    /**\n     * @param {ContentTypeInterface} contentType\n     * @param {ContentTypeConfigInterface} config\n     * @param {ObservableUpdater} observableUpdater\n     */\n    function Preview(contentType, config, observableUpdater) {\n      var _this;\n\n      _this = _previewCollection2.call(this, contentType, config, observableUpdater) || this; // Update the width label for the column\n\n      _this.resizing = _knockout.observable(false);\n      _this.fieldsToIgnoreOnRemove = [\"width\"];\n\n      _this.contentType.dataStore.subscribe(_this.updateColumnWidthClass.bind(_assertThisInitialized(_this)), \"width\");\n\n      _this.contentType.dataStore.subscribe(_this.updateDisplayLabel.bind(_assertThisInitialized(_this)), \"width\");\n\n      _this.contentType.dataStore.subscribe(_this.triggerChildren.bind(_assertThisInitialized(_this)), \"width\");\n\n      _this.contentType.parentContentType.dataStore.subscribe(_this.updateDisplayLabel.bind(_assertThisInitialized(_this)), \"grid_size\"); // Update the column number for the column\n\n\n      _this.contentType.parentContentType.children.subscribe(_this.updateDisplayLabel.bind(_assertThisInitialized(_this)));\n\n      return _this;\n    }\n    /**\n     * Get background image url base on the viewport.\n     *\n     * @returns {string}\n     */\n\n\n    var _proto = Preview.prototype;\n\n    _proto.getBackgroundImage = function getBackgroundImage() {\n      var mobileImage = this.contentType.dataStore.get(\"mobile_image\");\n      var desktopImage = this.contentType.dataStore.get(\"background_image\");\n      var backgroundImage = this.viewport() === \"mobile\" && mobileImage.length ? mobileImage : desktopImage;\n      return backgroundImage.length ? \"url(\\\"\" + backgroundImage[0].url + \"\\\")\" : \"none\";\n    }\n    /**\n     * Bind events\n     */\n    ;\n\n    _proto.bindEvents = function bindEvents() {\n      var _this2 = this;\n\n      _previewCollection2.prototype.bindEvents.call(this);\n\n      _events.on(\"column:moveAfter\", function (args) {\n        if (args.contentType.id === _this2.contentType.id) {\n          _this2.updateDisplayLabel();\n        }\n      });\n\n      if (_config.getContentTypeConfig(\"column-group\")) {\n        _events.on(\"column:dropAfter\", function (args) {\n          if (args.id === _this2.contentType.id) {\n            _this2.createColumnGroup();\n          }\n        });\n      }\n    }\n    /**\n     * Make a reference to the element in the column\n     *\n     * @param element\n     */\n    ;\n\n    _proto.initColumn = function initColumn(element) {\n      this.element = (0, _jquery)(element);\n      this.updateColumnWidthClass();\n\n      _events.trigger(\"column:initializeAfter\", {\n        column: this.contentType,\n        element: (0, _jquery)(element),\n        columnGroup: this.contentType.parentContentType\n      });\n\n      this.updateDisplayLabel();\n    }\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n    ;\n\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _previewCollection2.prototype.retrieveOptions.call(this);\n\n      options.move = new _option({\n        preview: this,\n        icon: \"<i class='icon-admin-pagebuilder-handle'></i>\",\n        title: (0, _translate)(\"Move\"),\n        classes: [\"move-column\"],\n        sort: 10\n      });\n      return options;\n    }\n    /**\n     * Init the resize handle for the resizing functionality\n     *\n     * @param handle\n     */\n    ;\n\n    _proto.bindResizeHandle = function bindResizeHandle(handle) {\n      _events.trigger(\"column:resizeHandleBindAfter\", {\n        column: this.contentType,\n        handle: (0, _jquery)(handle),\n        columnGroup: this.contentType.parentContentType\n      });\n    }\n    /**\n     * Wrap the current column in a group if it not in a column-group\n     *\n     * @returns {Promise<ContentTypeCollectionInterface>}\n     */\n    ;\n\n    _proto.createColumnGroup = function createColumnGroup() {\n      var _this3 = this;\n\n      if (this.contentType.parentContentType.config.name !== \"column-group\") {\n        var index = this.contentType.parentContentType.children().indexOf(this.contentType); // Remove child instantly to stop content jumping around\n\n        this.contentType.parentContentType.removeChild(this.contentType); // Create a new instance of column group to wrap our columns with\n\n        var defaultGridSize = (0, _gridSize.getDefaultGridSize)();\n        return (0, _contentTypeFactory)(_config.getContentTypeConfig(\"column-group\"), this.contentType.parentContentType, this.contentType.stageId, {\n          grid_size: defaultGridSize\n        }).then(function (columnGroup) {\n          var col1Width = (Math.ceil(defaultGridSize / 2) * 100 / defaultGridSize).toFixed(Math.round(100 / defaultGridSize) !== 100 / defaultGridSize ? 8 : 0);\n          return Promise.all([(0, _contentTypeFactory)(_this3.contentType.config, columnGroup, columnGroup.stageId, {\n            width: col1Width + \"%\"\n          }), (0, _contentTypeFactory)(_this3.contentType.config, columnGroup, columnGroup.stageId, {\n            width: 100 - parseFloat(col1Width) + \"%\"\n          })]).then(function (columns) {\n            columnGroup.addChild(columns[0], 0);\n            columnGroup.addChild(columns[1], 1);\n\n            _this3.contentType.parentContentType.addChild(columnGroup, index);\n\n            _this3.fireMountEvent(columnGroup, columns[0], columns[1]);\n\n            return columnGroup;\n          });\n        });\n      }\n    }\n    /**\n     * Duplicate a child of the current instance\n     *\n     * @param {ContentTypeCollectionInterface<Preview>} contentType\n     * @param {boolean} autoAppend\n     * @returns {Promise<ContentTypeCollectionInterface> | void}\n     */\n    ;\n\n    _proto.clone = function clone(contentType, autoAppend) {\n      if (autoAppend === void 0) {\n        autoAppend = true;\n      }\n\n      var resizeUtils = this.contentType.parentContentType.preview.getResizeUtils(); // Are we duplicating from a container content type?\n\n      if (contentType.config.name !== \"column\" || this.contentType.parentContentType.children().length === 0 || this.contentType.parentContentType.children().length > 0 && resizeUtils.getColumnsWidth() < 100) {\n        return _previewCollection2.prototype.clone.call(this, contentType, autoAppend);\n      } // Attempt to split the current column into parts\n\n\n      var splitTimes = Math.round(resizeUtils.getColumnWidth(contentType) / resizeUtils.getSmallestColumnWidth());\n\n      if (splitTimes > 1) {\n        var splitClone = _previewCollection2.prototype.clone.call(this, contentType, autoAppend);\n\n        if (splitClone) {\n          splitClone.then(function (duplicateContentType) {\n            /**\n             * Distribute the width across the original & duplicated columns, if the we have an odd number of\n             * split times apply it to the original.\n             */\n            var originalWidth = (Math.floor(splitTimes / 2) + splitTimes % 2) * resizeUtils.getSmallestColumnWidth();\n            var duplicateWidth = Math.floor(splitTimes / 2) * resizeUtils.getSmallestColumnWidth();\n            (0, _resize.updateColumnWidth)(contentType, resizeUtils.getAcceptedColumnWidth(originalWidth.toString()));\n            (0, _resize.updateColumnWidth)(duplicateContentType, resizeUtils.getAcceptedColumnWidth(duplicateWidth.toString()));\n            return duplicateContentType;\n          });\n        }\n      } else {\n        // Conduct an outward search on the children to locate a suitable shrinkable column\n        var shrinkableColumn = resizeUtils.findShrinkableColumn(contentType);\n\n        if (shrinkableColumn) {\n          var shrinkableClone = _previewCollection2.prototype.clone.call(this, contentType, autoAppend);\n\n          if (shrinkableClone) {\n            shrinkableClone.then(function (duplicateContentType) {\n              (0, _resize.updateColumnWidth)(shrinkableColumn, resizeUtils.getAcceptedColumnWidth((resizeUtils.getColumnWidth(shrinkableColumn) - resizeUtils.getSmallestColumnWidth()).toString()));\n              (0, _resize.updateColumnWidth)(duplicateContentType, resizeUtils.getSmallestColumnWidth());\n              return duplicateContentType;\n            });\n          }\n        } else {\n          // If we aren't able to duplicate inform the user why\n          (0, _alert)({\n            content: (0, _translate)(\"There is no free space within the column group to perform this action.\"),\n            title: (0, _translate)(\"Unable to duplicate column\")\n          });\n        }\n      }\n    }\n    /**\n     * Update the display label for the column\n     */\n    ;\n\n    _proto.updateDisplayLabel = function updateDisplayLabel() {\n      if (this.contentType.parentContentType.preview instanceof _preview) {\n        var newWidth = parseFloat(this.contentType.dataStore.get(\"width\").toString());\n        var gridSize = this.contentType.parentContentType.preview.gridSize();\n        var newLabel = Math.round(newWidth / (100 / gridSize)) + \"/\" + gridSize;\n        var columnIndex = this.contentType.parentContentType.children().indexOf(this.contentType);\n        var columnNumber = columnIndex !== -1 ? columnIndex + 1 + \" \" : \"\";\n        this.displayLabel((0, _translate)(\"Column\") + \" \" + columnNumber + \"(\" + newLabel + \")\");\n      }\n    }\n    /**\n     * Syncs the column-width-* class on the children-wrapper with the current width to the nearest tenth rounded up\n     */\n    ;\n\n    _proto.updateColumnWidthClass = function updateColumnWidthClass() {\n      // Only update once instantiated\n      if (!this.element) {\n        return;\n      }\n\n      var currentClass = this.element.attr(\"class\").match(/(?:^|\\s)(column-width-\\d{1,3})(?:$|\\s)/);\n\n      if (currentClass !== null) {\n        this.element.removeClass(currentClass[1]);\n      }\n\n      var roundedWidth = Math.ceil(parseFloat(this.contentType.dataStore.get(\"width\").toString()) / 10) * 10;\n      this.element.addClass(\"column-width-\" + roundedWidth);\n    }\n    /**\n     * Return selected element styles\n     *\n     * @param element\n     * @param styleProperties\n     */\n    ;\n\n    _proto.getStyle = function getStyle(element, styleProperties) {\n      var stylesObject = element.style();\n      return styleProperties.reduce(function (obj, key) {\n        var _extends2;\n\n        return _extends({}, obj, (_extends2 = {}, _extends2[key] = stylesObject[key], _extends2));\n      }, {});\n    }\n    /**\n     * Return element styles without selected\n     *\n     * @param element\n     * @param styleProperties\n     */\n    ;\n\n    _proto.getStyleWithout = function getStyleWithout(element, styleProperties) {\n      var stylesObject = element.style();\n      return Object.keys(stylesObject).filter(function (key) {\n        return !styleProperties.includes(key);\n      }).reduce(function (obj, key) {\n        var _extends3;\n\n        return _extends({}, obj, (_extends3 = {}, _extends3[key] = stylesObject[key], _extends3));\n      }, {});\n    }\n    /**\n     * Fire the mount event for content types\n     *\n     * @param {ContentTypeInterface[]} contentTypes\n     */\n    ;\n\n    _proto.fireMountEvent = function fireMountEvent() {\n      for (var _len = arguments.length, contentTypes = new Array(_len), _key = 0; _key < _len; _key++) {\n        contentTypes[_key] = arguments[_key];\n      }\n\n      contentTypes.forEach(function (contentType) {\n        _events.trigger(\"contentType:mountAfter\", {\n          id: contentType.id,\n          contentType: contentType\n        });\n\n        _events.trigger(contentType.config.name + \":mountAfter\", {\n          id: contentType.id,\n          contentType: contentType\n        });\n      });\n    }\n    /**\n     * Delegate trigger call on children elements.\n     */\n    ;\n\n    _proto.triggerChildren = function triggerChildren() {\n      if (this.contentType.parentContentType.preview instanceof _preview) {\n        var newWidth = parseFloat(this.contentType.dataStore.get(\"width\").toString());\n        this.delegate(\"trigger\", \"columnWidthChangeAfter\", {\n          width: newWidth\n        });\n      }\n    };\n\n    return Preview;\n  }(_previewCollection);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/column/resize.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/array\"], function (_array) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var Resize = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Resize(columnGroup) {\n      this.columnGroup = columnGroup;\n    }\n    /**\n     * Get the grid size for this columnGroup\n     *\n     * @returns {number}\n     */\n\n\n    var _proto = Resize.prototype;\n\n    _proto.getGridSize = function getGridSize() {\n      return parseInt(this.columnGroup.dataStore.get(\"grid_size\").toString(), 10);\n    }\n    /**\n     * Get the smallest column width possible\n     *\n     * @param {number} gridSize\n     * @returns {number}\n     */\n    ;\n\n    _proto.getSmallestColumnWidth = function getSmallestColumnWidth(gridSize) {\n      gridSize = gridSize || this.getGridSize();\n      return this.getAcceptedColumnWidth(parseFloat((100 / gridSize).toString()).toFixed(Math.round(100 / gridSize) !== 100 / gridSize ? 8 : 0));\n    }\n    /**\n     * Get an accepted column width to resolve rounding issues, e.g. turn 49.995% into 50%\n     *\n     * @param {string} width\n     * @param {number} gridSize\n     * @returns {number}\n     */\n    ;\n\n    _proto.getAcceptedColumnWidth = function getAcceptedColumnWidth(width, gridSize) {\n      gridSize = gridSize || this.getGridSize();\n      var newWidth = 0;\n\n      for (var i = gridSize; i > 0; i--) {\n        var percentage = parseFloat((100 / gridSize * i).toFixed(Math.round(100 / gridSize * i) !== 100 / gridSize * i ? 8 : 0)); // Allow for rounding issues\n\n        if (parseFloat(width) > percentage - 0.1 && parseFloat(width) < percentage + 0.1) {\n          newWidth = percentage;\n          break;\n        }\n      }\n\n      return newWidth;\n    }\n    /**\n     * Return the width of the column\n     *\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n     * @returns {number}\n     */\n    ;\n\n    _proto.getColumnWidth = function getColumnWidth(column) {\n      return this.getAcceptedColumnWidth(column.dataStore.get(\"width\").toString());\n    }\n    /**\n     * Get the total width of all columns in the group\n     *\n     * @returns {number}\n     */\n    ;\n\n    _proto.getColumnsWidth = function getColumnsWidth() {\n      var _this = this;\n\n      return this.getAcceptedColumnWidth(this.columnGroup.children().map(function (column) {\n        return _this.getColumnWidth(column);\n      }).reduce(function (widthA, widthB) {\n        return widthA + (widthB ? widthB : 0);\n      }).toString());\n    }\n    /**\n     * Determine the pixel position of every column that can be created within the group\n     *\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n     * @param {GroupPositionCache} groupPosition\n     * @returns {ColumnWidth[]}\n     */\n    ;\n\n    _proto.determineColumnWidths = function determineColumnWidths(column, groupPosition) {\n      var gridSize = this.getGridSize();\n      var singleColumnWidth = groupPosition.outerWidth / gridSize;\n      var adjacentColumn = getAdjacentColumn(column, \"+1\");\n      var columnWidths = [];\n      var columnLeft = column.preview.element.offset().left - parseInt(column.preview.element.css(\"margin-left\"), 10);\n      var adjacentRightPosition = adjacentColumn.preview.element.offset().left + adjacentColumn.preview.element.outerWidth(true); // Determine the maximum size (in pixels) that this column can be dragged to\n\n      var columnsToRight = column.parentContentType.children().length - (getColumnIndexInGroup(column) + 1);\n      var leftMaxWidthFromChildren = groupPosition.left + groupPosition.outerWidth - columnsToRight * singleColumnWidth + 10;\n      var rightMaxWidthFromChildren = groupPosition.left + (column.parentContentType.children().length - columnsToRight) * singleColumnWidth - 10; // Due to rounding we add a threshold of 10\n      // Iterate through the amount of columns generating the position for both left & right interactions\n\n      for (var i = gridSize; i > 0; i--) {\n        var position = Math.round(columnLeft + singleColumnWidth * i);\n\n        if (position > Math.round(leftMaxWidthFromChildren)) {\n          continue;\n        }\n\n        columnWidths.push({\n          forColumn: \"left\",\n          // These positions are for the left column in the pair\n          name: i + \"/\" + gridSize,\n          position: position,\n          width: getRoundedColumnWidth(100 / gridSize * i)\n        });\n      }\n\n      for (var _i = 1; _i < gridSize; _i++) {\n        var _position = Math.floor(adjacentRightPosition - _i * singleColumnWidth);\n\n        if (_position < Math.floor(rightMaxWidthFromChildren)) {\n          continue;\n        } // The right interaction is only used when we're crushing a column that isn't adjacent\n\n\n        columnWidths.push({\n          forColumn: \"right\",\n          // These positions are for the left column in the pair\n          name: _i + \"/\" + gridSize,\n          position: _position,\n          width: getRoundedColumnWidth(100 / gridSize * _i)\n        });\n      }\n\n      return columnWidths;\n    }\n    /**\n     * Find a column which can be shrunk for the current resize action\n     *\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n     * @param {\"left\" | \"right\"} direction\n     * @returns {ContentTypeCollectionInterface<ColumnPreview>}\n     */\n    ;\n\n    _proto.findShrinkableColumnForResize = function findShrinkableColumnForResize(column, direction) {\n      var _this2 = this;\n\n      var currentIndex = getColumnIndexInGroup(column);\n      var columnItemsArray = column.parentContentType.children();\n      var searchArray;\n\n      switch (direction) {\n        case \"right\":\n          searchArray = columnItemsArray.slice(currentIndex + 1);\n          break;\n\n        case \"left\":\n          searchArray = columnItemsArray.slice(0).reverse().slice(columnItemsArray.length - currentIndex);\n          break;\n      }\n\n      return searchArray.find(function (groupColumn) {\n        return _this2.getColumnWidth(groupColumn) > _this2.getSmallestColumnWidth();\n      });\n    }\n    /**\n     * Find a shrinkable column outwards from the current column\n     *\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n     * @returns {ContentTypeCollectionInterface<ColumnPreview>}\n     */\n    ;\n\n    _proto.findShrinkableColumn = function findShrinkableColumn(column) {\n      var _this3 = this;\n\n      return (0, _array.outwardSearch)(column.parentContentType.children(), getColumnIndexInGroup(column), function (neighbourColumn) {\n        return _this3.getColumnWidth(neighbourColumn) > _this3.getSmallestColumnWidth();\n      });\n    }\n    /**\n     * Calculate the ghost size for the resizing action\n     *\n     * @param {GroupPositionCache} groupPosition\n     * @param {number} currentPos\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n     * @param {string} modifyColumnInPair\n     * @param {MaxGhostWidth} maxGhostWidth\n     * @returns {number}\n     */\n    ;\n\n    _proto.calculateGhostWidth = function calculateGhostWidth(groupPosition, currentPos, column, modifyColumnInPair, maxGhostWidth) {\n      var ghostWidth = currentPos - groupPosition.left;\n\n      switch (modifyColumnInPair) {\n        case \"left\":\n          var singleColumnWidth = column.preview.element.position().left + groupPosition.outerWidth / this.getGridSize(); // Don't allow the ghost widths be less than the smallest column\n\n          if (ghostWidth <= singleColumnWidth) {\n            ghostWidth = singleColumnWidth;\n          }\n\n          if (currentPos >= maxGhostWidth.left) {\n            ghostWidth = maxGhostWidth.left - groupPosition.left;\n          }\n\n          break;\n\n        case \"right\":\n          if (currentPos <= maxGhostWidth.right) {\n            ghostWidth = maxGhostWidth.right - groupPosition.left;\n          }\n\n          break;\n      }\n\n      return ghostWidth;\n    }\n    /**\n     * Determine which column in the group should be adjusted for the current resize action\n     *\n     * @param {number} currentPos\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n     * @param {ResizeHistory} history\n     * @returns {[ContentTypeCollectionInterface<ColumnPreview>, string, string]}\n     */\n    ;\n\n    _proto.determineAdjustedColumn = function determineAdjustedColumn(currentPos, column, history) {\n      var modifyColumnInPair = \"left\";\n      var usedHistory;\n      var resizeColumnLeft = column.preview.element.offset().left - parseInt(column.preview.element.css(\"margin-left\"), 10);\n      var resizeColumnWidth = column.preview.element.outerWidth(true);\n      var resizeHandlePosition = resizeColumnLeft + resizeColumnWidth;\n      var adjustedColumn;\n\n      if (currentPos >= resizeHandlePosition) {\n        // Get the history for the opposite direction of resizing\n        if (history.left.length > 0) {\n          usedHistory = \"left\";\n          adjustedColumn = history.left.reverse()[0].adjustedColumn;\n          modifyColumnInPair = history.left.reverse()[0].modifyColumnInPair;\n        } else {\n          // If we're increasing the width of our column we need to locate a column that can shrink to the\n          // right\n          adjustedColumn = this.findShrinkableColumnForResize(column, \"right\");\n        }\n      } else {\n        if (this.getColumnWidth(column) <= this.getSmallestColumnWidth()) {\n          adjustedColumn = this.findShrinkableColumnForResize(column, \"left\");\n\n          if (adjustedColumn) {\n            modifyColumnInPair = \"right\";\n          }\n        } else if (history.right.length > 0) {\n          usedHistory = \"right\";\n          adjustedColumn = history.right.reverse()[0].adjustedColumn;\n          modifyColumnInPair = history.right.reverse()[0].modifyColumnInPair;\n        } else {\n          // If we're shrinking our column we can just increase the adjacent column\n          adjustedColumn = getAdjacentColumn(column, \"+1\");\n        }\n      }\n\n      return [adjustedColumn, modifyColumnInPair, usedHistory];\n    }\n    /**\n     * Resize a column to a specific width\n     *\n     * @param {ContentTypeCollectionInterface<Preview>} column\n     * @param {number} width\n     * @param {ContentTypeCollectionInterface<Preview>} shrinkableColumn\n     */\n    ;\n\n    _proto.resizeColumn = function resizeColumn(column, width, shrinkableColumn) {\n      var current = this.getColumnWidth(column);\n      var difference = (parseFloat(width.toString()) - current).toFixed(8); // Don't run the update if we've already modified the column\n\n      if (current === parseFloat(width.toString()) || parseFloat(width.toString()) < this.getSmallestColumnWidth()) {\n        return;\n      } // Also shrink the closest shrinkable column\n\n\n      var allowedToShrink = true;\n\n      if (difference && shrinkableColumn) {\n        var currentShrinkable = this.getColumnWidth(shrinkableColumn);\n        var shrinkableSize = this.getAcceptedColumnWidth((currentShrinkable + -difference).toString()); // Ensure the column we're crushing is not becoming the same size, and it's not less than the smallest width\n\n        if (currentShrinkable === parseFloat(shrinkableSize.toString()) || parseFloat(shrinkableSize.toString()) < this.getSmallestColumnWidth()) {\n          allowedToShrink = false;\n        } else {\n          // Ensure we're not creating more columns width than the grid can support\n          if (this.gridSupportsResize(column, width, shrinkableColumn, shrinkableSize)) {\n            updateColumnWidth(shrinkableColumn, shrinkableSize);\n          } else {\n            allowedToShrink = false;\n          }\n        }\n      }\n\n      if (allowedToShrink) {\n        updateColumnWidth(column, width);\n      }\n    }\n    /**\n     * Determine if the grid supports the new proposed grid size\n     *\n     * @param {ContentTypeCollectionInterface<Preview>} column\n     * @param {number} newWidth\n     * @param {ContentTypeCollectionInterface<Preview>} shrinkableColumn\n     * @param {number} shrinkableColumnNewWidth\n     * @returns {boolean}\n     */\n    ;\n\n    _proto.gridSupportsResize = function gridSupportsResize(column, newWidth, shrinkableColumn, shrinkableColumnNewWidth) {\n      var _this4 = this;\n\n      // Determine the total width of all other columns in the grid, excluding the ones we plan to resize\n      var otherColumnsWidth = column.parentContentType.getChildren()().filter(function (gridColumn) {\n        return gridColumn !== column && shrinkableColumn && gridColumn !== shrinkableColumn;\n      }).map(function (otherColumn) {\n        return _this4.getColumnWidth(otherColumn);\n      }).reduce(function (a, b) {\n        return a + b;\n      }, 0); // Determine if the new total grid size will be 100%, with 1 for margin of error with rounding\n\n      return comparator(otherColumnsWidth + newWidth + (shrinkableColumnNewWidth ? shrinkableColumnNewWidth : 0), 100, 0.1);\n    };\n\n    return Resize;\n  }();\n  /**\n   * Retrieve the index of the column within it's group\n   *\n   * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n   * @returns {number}\n   */\n\n\n  function getColumnIndexInGroup(column) {\n    return column.parentContentType.children().indexOf(column);\n  }\n  /**\n   * Retrieve the adjacent column based on a direction of +1 or -1\n   *\n   * @param {ContentTypeCollectionInterface<Preview>} column\n   * @param {\"+1\" | \"-1\"} direction\n   * @returns {ContentTypeCollectionInterface<Preview>}\n   */\n\n\n  function getAdjacentColumn(column, direction) {\n    var currentIndex = getColumnIndexInGroup(column);\n\n    if (typeof column.parentContentType.children()[currentIndex + parseInt(direction, 10)] !== \"undefined\") {\n      return column.parentContentType.children()[currentIndex + parseInt(direction, 10)];\n    }\n\n    return null;\n  }\n  /**\n   * Determine the max ghost width based on the calculated columns\n   *\n   * @param {ColumnWidth[]} columnWidths\n   * @returns {MaxGhostWidth}\n   */\n\n\n  function determineMaxGhostWidth(columnWidths) {\n    var leftColumns = columnWidths.filter(function (width) {\n      return width.forColumn === \"left\";\n    });\n    var rightColumns = columnWidths.filter(function (width) {\n      return width.forColumn === \"right\";\n    });\n    return {\n      left: leftColumns[0].position,\n      right: rightColumns[rightColumns.length - 1].position\n    };\n  }\n  /**\n   * Return the column width to 8 decimal places if it's not a whole number\n   *\n   * @param {number} width\n   * @returns {string}\n   */\n\n\n  function getRoundedColumnWidth(width) {\n    return Number(width.toFixed(Math.round(width) !== width ? 8 : 0));\n  }\n  /**\n   * Compare if two numbers are within a certain threshold of each other\n   *\n   * comparator(10,11,2) => true\n   * comparator(1.1,1.11,0.5) => true\n   *\n   * @param {number} num1\n   * @param {number} num2\n   * @param {number} threshold\n   * @returns {boolean}\n   */\n\n\n  function comparator(num1, num2, threshold) {\n    return num1 > num2 - threshold / 2 && num1 < num2 + threshold / 2;\n  }\n  /**\n   * Update the width of a column\n   *\n   * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n   * @param {number} width\n   */\n\n\n  function updateColumnWidth(column, width) {\n    column.dataStore.set(\"width\", parseFloat(width.toString()) + \"%\");\n  }\n\n  return Object.assign(Resize, {\n    getColumnIndexInGroup: getColumnIndexInGroup,\n    getAdjacentColumn: getAdjacentColumn,\n    determineMaxGhostWidth: determineMaxGhostWidth,\n    getRoundedColumnWidth: getRoundedColumnWidth,\n    comparator: comparator,\n    updateColumnWidth: updateColumnWidth\n  });\n});\n//# sourceMappingURL=resize.js.map","Magento_PageBuilder/js/content-type/column/converter/style/margins.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var Margins = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Margins() {}\n\n    var _proto = Margins.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      if (undefined !== value.margin) {\n        return {\n          margin: {\n            top: value.margin.top.replace(\"px\", \"\"),\n            left: value.margin.left.replace(\"px\", \"\"),\n            right: value.margin.right.replace(\"px\", \"\"),\n            bottom: value.margin.bottom.replace(\"px\", \"\")\n          }\n        };\n      }\n\n      return {};\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var result = {};\n      var value = (0, _object.get)(data, name);\n\n      if (value && _underscore.isString(value)) {\n        value = JSON.parse(value);\n      }\n\n      if (value && undefined !== value.margin) {\n        result.marginLeft = value.margin.left ? value.margin.left + \"px\" : \"\";\n        result.marginTop = value.margin.top ? value.margin.top + \"px\" : \"\";\n        result.marginRight = (value.margin.right && parseInt(value.margin.right, 10) !== 0 ? value.margin.right : 1) + \"px\";\n        result.marginBottom = value.margin.bottom ? value.margin.bottom + \"px\" : \"\";\n      }\n\n      return result;\n    };\n\n    return Margins;\n  }();\n\n  return Margins;\n});\n//# sourceMappingURL=margins.js.map","Magento_PageBuilder/js/content-type/image/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"Magento_PageBuilder/js/events\", \"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/uploader\", \"Magento_PageBuilder/js/content-type/preview\"], function (_events, _hideShowOption, _uploader, _preview) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_preview2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _preview2);\n\n    function Preview() {\n      return _preview2.apply(this, arguments) || this;\n    }\n\n    var _proto = Preview.prototype;\n\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _preview2.prototype.retrieveOptions.call(this);\n\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    }\n    /**\n     * Get registry callback reference to uploader UI component\n     *\n     * @returns {Uploader}\n     */\n    ;\n\n    _proto.getUploader = function getUploader() {\n      var initialImageValue = this.contentType.dataStore.get(this.config.additional_data.uploaderConfig.dataScope, \"\");\n      return new _uploader(\"imageuploader_\" + this.contentType.id, this.config.additional_data.uploaderConfig, this.contentType.id, this.contentType.dataStore, initialImageValue);\n    }\n    /**\n     * Get viewport image data\n     */\n    ;\n\n    _proto.getViewportImageData = function getViewportImageData() {\n      var desktopImageData = this.data.desktop_image;\n      var mobileImageData = this.data.mobile_image;\n      return this.viewport() === \"mobile\" && typeof mobileImageData !== \"undefined\" ? mobileImageData : desktopImageData;\n    }\n    /**\n     * @inheritDoc\n     */\n    ;\n\n    _proto.bindEvents = function bindEvents() {\n      var _this = this;\n\n      _preview2.prototype.bindEvents.call(this);\n\n      _events.on(\"image:mountAfter\", function (args) {\n        if (args.id === _this.contentType.id) {\n          _this.isSnapshot.subscribe(function (value) {\n            _this.changeUploaderControlsVisibility();\n          });\n\n          _this.changeUploaderControlsVisibility();\n        }\n      });\n\n      _events.on(this.config.name + \":\" + this.contentType.id + \":updateAfter\", function () {\n        var files = _this.contentType.dataStore.get(_this.config.additional_data.uploaderConfig.dataScope);\n\n        var imageObject = files ? files[0] : {};\n\n        _events.trigger(\"image:\" + _this.contentType.id + \":assignAfter\", imageObject);\n      });\n    }\n    /**\n     * Change uploader controls visibility\n     */\n    ;\n\n    _proto.changeUploaderControlsVisibility = function changeUploaderControlsVisibility() {\n      var _this2 = this;\n\n      this.getUploader().getUiComponent()(function (uploader) {\n        uploader.visibleControls = !_this2.isSnapshot();\n      });\n    };\n\n    return Preview;\n  }(_preview);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/observable-updater/html.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/utils/directives\", \"Magento_PageBuilder/js/utils/editor\", \"Magento_PageBuilder/js/utils/object\"], function (_config, _directives, _editor, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Generate Knockout compatible bindings for the elements html binding\n   *\n   * @param elementName\n   * @param config\n   * @param data\n   * @param converterResolver\n   * @param converterPool\n   */\n  function generate(elementName, config, data, converterResolver, converterPool) {\n    var value = config.html.var ? (0, _object.get)(data, config.html.var, config.html.placeholder) : config.html.placeholder;\n    var converter = converterResolver(config.html);\n\n    if (converterPool.get(converter)) {\n      value = converterPool.get(converter).toDom(config.html.var, data);\n    } // if value is empty, use placeholder\n\n\n    if (typeof value === \"string\" && !value.length && config.html.placeholder) {\n      value = config.html.placeholder;\n    } // Replacing src attribute with data-tmp-src to prevent img requests in iframe during master format rendering\n\n\n    if (_config.getMode() !== \"Preview\" && typeof value === \"string\" && value.indexOf(\"{{media url=\") !== -1) {\n      value = (0, _directives.replaceWithDataSrc)(value);\n    } // Process all desktop styles that left unprocessed after migrating from inline styles.\n\n\n    if (typeof value === \"string\") {\n      value = (0, _editor.processInlineStyles)(value);\n    }\n\n    return value;\n  }\n\n  return generate;\n});\n//# sourceMappingURL=html.js.map","Magento_PageBuilder/js/content-type/observable-updater/style.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _createForOfIteratorHelperLoose(o, allowArrayLike) { var it = typeof Symbol !== \"undefined\" && o[Symbol.iterator] || o[\"@@iterator\"]; if (it) return (it = it.call(o)).next.bind(it); if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === \"number\") { if (it) o = it; var i = 0; return function () { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }; } throw new TypeError(\"Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\", \"Magento_PageBuilder/js/utils/string\"], function (_underscore, _object, _string) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Generate Knockout compatible bindings for the elements style binding\n   *\n   * @param elementName\n   * @param config\n   * @param data\n   * @param converterResolver\n   * @param converterPool\n   * @param previousData\n   */\n  function generate(elementName, config, data, converterResolver, converterPool, previousData) {\n    var newStyles = {};\n\n    if (config.style) {\n      for (var _iterator = _createForOfIteratorHelperLoose(config.style), _step; !(_step = _iterator()).done;) {\n        var propertyConfig = _step.value;\n\n        if (\"read\" === propertyConfig.persistence_mode) {\n          continue;\n        }\n\n        var value = void 0;\n\n        if (!!propertyConfig.static) {\n          value = propertyConfig.value;\n        } else {\n          value = (0, _object.get)(data, propertyConfig.var);\n          var converter = converterResolver(propertyConfig);\n\n          if (converterPool.get(converter)) {\n            value = converterPool.get(converter).toDom(propertyConfig.var, data);\n          }\n        }\n\n        if (typeof value === \"object\") {\n          _underscore.extend(newStyles, value);\n        } else if (value !== undefined) {\n          newStyles[(0, _string.fromSnakeToCamelCase)(propertyConfig.name)] = value;\n        }\n      }\n    }\n\n    if (previousData) {\n      /**\n       * If so we need to retrieve the previous styles applied to this element and create a new object\n       * which forces all of these styles to be \"false\". Knockout doesn't clean existing styles when\n       * applying new styles to an element. This resolves styles sticking around when they should be\n       * removed.\n       */\n      var removeCurrentStyles = Object.keys(previousData).reduce(function (object, styleName) {\n        var _Object$assign;\n\n        return Object.assign(object, (_Object$assign = {}, _Object$assign[styleName] = \"\", _Object$assign));\n      }, {});\n\n      if (!_underscore.isEmpty(removeCurrentStyles)) {\n        newStyles = _underscore.extend(removeCurrentStyles, newStyles);\n      }\n    }\n\n    return newStyles;\n  }\n\n  return generate;\n});\n//# sourceMappingURL=style.js.map","Magento_PageBuilder/js/content-type/observable-updater/attributes.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _createForOfIteratorHelperLoose(o, allowArrayLike) { var it = typeof Symbol !== \"undefined\" && o[Symbol.iterator] || o[\"@@iterator\"]; if (it) return (it = it.call(o)).next.bind(it); if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === \"number\") { if (it) o = it; var i = 0; return function () { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }; } throw new TypeError(\"Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\ndefine([\"underscore\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _config, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Generate Knockout compatible bindings for the elements attribute binding\n   *\n   * @param elementName\n   * @param config\n   * @param data\n   * @param converterResolver\n   * @param converterPool\n   */\n  function generate(elementName, config, data, converterResolver, converterPool) {\n    var attributeData = {};\n\n    var _loop = function _loop() {\n      var attributeConfig = _step.value;\n\n      if (\"read\" === attributeConfig.persistence_mode) {\n        return \"continue\";\n      } // @ts-ignore\n\n\n      var value = void 0;\n\n      if (!!attributeConfig.static) {\n        value = attributeConfig.value;\n      } else {\n        value = (0, _object.get)(data, attributeConfig.var);\n      }\n\n      var converter = converterResolver(attributeConfig);\n\n      if (converterPool.get(converter)) {\n        value = converterPool.get(converter).toDom(attributeConfig.var, data);\n      } // Replacing src attribute with data-tmp-src to prevent img requests in iframe during master format rendering\n\n\n      if (_config.getMode() !== \"Preview\" && attributeConfig.name === \"src\" && _underscore.isString(value) && !value.indexOf(\"{{media url=\")) {\n        attributeData[\"data-tmp-\" + attributeConfig.name] = value; // @ts-ignore\n\n        Object.defineProperty(attributeData, attributeConfig.name, {\n          get: function get() {\n            return value;\n          }\n        });\n      } else {\n        attributeData[attributeConfig.name] = value;\n      }\n    };\n\n    for (var _iterator = _createForOfIteratorHelperLoose(config.attributes), _step; !(_step = _iterator()).done;) {\n      var _ret = _loop();\n\n      if (_ret === \"continue\") continue;\n    }\n\n    attributeData[\"data-element\"] = elementName;\n    return attributeData;\n  }\n\n  return generate;\n});\n//# sourceMappingURL=attributes.js.map","Magento_PageBuilder/js/content-type/observable-updater/css.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Generate Knockout compatible bindings for the elements css binding\n   *\n   * @param elementName\n   * @param config\n   * @param data\n   * @param converterResolver\n   * @param converterPool\n   * @param previousData\n   */\n  function generate(elementName, config, data, converterResolver, converterPool, previousData) {\n    var css = (0, _object.get)(data, config.css.var);\n    var newClasses = {};\n\n    if (css && css.length > 0) {\n      css.toString().split(\" \").map(function (value) {\n        return newClasses[value] = true;\n      });\n    }\n\n    for (var _i = 0, _Object$keys = Object.keys(previousData); _i < _Object$keys.length; _i++) {\n      var className = _Object$keys[_i];\n\n      if (!(className in newClasses)) {\n        newClasses[className] = false;\n      }\n    }\n\n    return newClasses;\n  }\n\n  return generate;\n});\n//# sourceMappingURL=css.js.map","Magento_PageBuilder/js/content-type/row/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }\n\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jarallax\", \"jarallaxVideo\", \"jquery\", \"knockout\", \"Magento_PageBuilder/js/events\", \"Magento_PageBuilder/js/resource/resize-observer/ResizeObserver\", \"underscore\", \"vimeoWrapper\", \"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/content-type/preview-collection\"], function (_jarallax, _jarallaxVideo, _jquery, _knockout, _events, _ResizeObserver, _underscore, _vimeoWrapper, _hideShowOption, _previewCollection) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_previewCollection2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _previewCollection2);\n\n    /**\n     * Debounce and defer the init of Jarallax\n     *\n     * @type {(() => void) & _.Cancelable}\n     */\n\n    /**\n     * @param {ContentTypeInterface} contentType\n     * @param {ContentTypeConfigInterface} config\n     * @param {ObservableUpdater} observableUpdater\n     */\n    function Preview(contentType, config, observableUpdater) {\n      var _this;\n\n      _this = _previewCollection2.call(this, contentType, config, observableUpdater) || this;\n      _this.wrapClass = _knockout.observable(false);\n      _this.buildJarallax = _underscore.debounce(function () {\n        // Destroy all instances of the plugin prior\n        try {\n          jarallax(_this.element, \"destroy\");\n        } catch (e) {// Failure of destroying is acceptable\n        }\n\n        if (_this.element && (0, _jquery)(_this.element).hasClass(\"jarallax\") && _this.contentType.dataStore.get(\"background_type\") !== \"video\" && _this.contentType.dataStore.get(\"background_image\").length) {\n          _underscore.defer(function () {\n            // Build Parallax on elements with the correct class\n            var parallaxSpeed = Number.parseFloat(_this.contentType.dataStore.get(\"parallax_speed\"));\n            jarallax(_this.element, {\n              imgPosition: _this.contentType.dataStore.get(\"background_position\") || \"50% 50%\",\n              imgRepeat: _this.contentType.dataStore.get(\"background_repeat\") || \"no-repeat\",\n              imgSize: _this.contentType.dataStore.get(\"background_size\") || \"cover\",\n              speed: !isNaN(parallaxSpeed) ? parallaxSpeed : 0.5\n            });\n            jarallax(_this.element, \"onResize\");\n          });\n        }\n\n        if (_this.element && _this.element.dataset.backgroundType === \"video\" && _this.element.dataset.videoSrc.length) {\n          var parallaxSpeed = _this.contentType.dataStore.get(\"enable_parallax\") === \"1\" ? Number.parseFloat(_this.contentType.dataStore.get(\"parallax_speed\")) : 1;\n\n          _underscore.defer(function () {\n            // Build Parallax on elements with the correct class\n            jarallax(_this.element, {\n              videoSrc: _this.element.dataset.videoSrc,\n              imgSrc: _this.element.dataset.videoFallbackSrc,\n              videoLoop: _this.contentType.dataStore.get(\"video_loop\") === \"true\",\n              speed: !isNaN(parallaxSpeed) ? parallaxSpeed : 0.5,\n              videoPlayOnlyVisible: _this.contentType.dataStore.get(\"video_play_only_visible\") === \"true\",\n              videoLazyLoading: _this.contentType.dataStore.get(\"video_lazy_load\") === \"true\"\n            }); // @ts-ignore\n\n            if (_this.element.jarallax && _this.element.jarallax.video) {\n              // @ts-ignore\n              _this.element.jarallax.video.on(\"started\", function () {\n                // @ts-ignore\n                if (_this.element.jarallax.$video) {\n                  // @ts-ignore\n                  _this.element.jarallax.$video.style.visibility = \"visible\";\n                }\n              });\n            }\n          });\n        }\n      }, 50);\n\n      _this.contentType.dataStore.subscribe(_this.buildJarallax);\n\n      _events.on(\"row:mountAfter\", function (args) {\n        if (args.id === _this.contentType.id) {\n          _this.buildJarallax();\n        }\n      });\n\n      _events.on(\"contentType:mountAfter\", function (args) {\n        if (args.contentType.parentContentType && args.contentType.parentContentType.id === _this.contentType.id) {\n          _this.buildJarallax();\n        }\n      });\n\n      _events.on(\"stage:\" + _this.contentType.stageId + \":fullScreenModeChangeAfter\", _this.toggleFullScreen.bind(_assertThisInitialized(_this)));\n\n      _events.on(\"stage:\" + _this.contentType.stageId + \":viewportChangeAfter\", function (args) {\n        _this.buildJarallax();\n      });\n\n      return _this;\n    }\n    /**\n     * Get background image url base on the viewport.\n     *\n     * @returns {string}\n     */\n\n\n    var _proto = Preview.prototype;\n\n    _proto.getBackgroundImage = function getBackgroundImage() {\n      var mobileImage = this.contentType.dataStore.get(\"mobile_image\");\n      var desktopImage = this.contentType.dataStore.get(\"background_image\");\n      var backgroundImage = this.viewport() === \"mobile\" && mobileImage.length ? mobileImage : desktopImage;\n      return backgroundImage.length ? \"url(\\\"\" + backgroundImage[0].url + \"\\\")\" : \"none\";\n    }\n    /**\n     * Toggle fullscreen\n     */\n    ;\n\n    _proto.toggleFullScreen = function toggleFullScreen() {\n      if ((0, _jquery)(this.element).hasClass(\"jarallax\")) {\n        this.buildJarallax();\n      }\n    }\n    /**\n     * Use the conditional remove to disable the option when the content type has a single child\n     *\n     * @returns {OptionsInterface}\n     */\n    ;\n\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _previewCollection2.prototype.retrieveOptions.call(this);\n\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    }\n    /**\n     * Init the parallax element\n     *\n     * @param {HTMLElement} element\n     */\n    ;\n\n    _proto.initParallax = function initParallax(element) {\n      var _this2 = this;\n\n      this.element = element;\n\n      _underscore.defer(function () {\n        _this2.buildJarallax();\n      });\n\n      new _ResizeObserver(function () {\n        // Observe for resizes of the element and force jarallax to display correctly\n        if ((0, _jquery)(_this2.element).hasClass(\"jarallax\") && _this2.contentType.dataStore.get(\"background_image\").length) {\n          jarallax(_this2.element, \"onResize\");\n          jarallax(_this2.element, \"onScroll\");\n        }\n      }).observe(this.element);\n    }\n    /**\n     * Destroy jarallax instance.\n     */\n    ;\n\n    _proto.destroy = function destroy() {\n      _previewCollection2.prototype.destroy.call(this);\n\n      if (this.element) {\n        jarallax(this.element, \"destroy\");\n      }\n    }\n    /**\n     * Return selected element styles\n     *\n     * @param element\n     * @param styleProperties\n     */\n    ;\n\n    _proto.getStyle = function getStyle(element, styleProperties) {\n      var stylesObject = element.style();\n      return styleProperties.reduce(function (obj, key) {\n        var _extends2;\n\n        return _extends({}, obj, (_extends2 = {}, _extends2[key] = stylesObject[key], _extends2));\n      }, {});\n    }\n    /**\n     * Return element styles without selected\n     *\n     * @param element\n     * @param styleProperties\n     */\n    ;\n\n    _proto.getStyleWithout = function getStyleWithout(element, styleProperties) {\n      var stylesObject = element.style();\n      return Object.keys(stylesObject).filter(function (key) {\n        return !styleProperties.includes(key);\n      }).reduce(function (obj, key) {\n        var _extends3;\n\n        return _extends({}, obj, (_extends3 = {}, _extends3[key] = stylesObject[key], _extends3));\n      }, {});\n    };\n\n    return Preview;\n  }(_previewCollection);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/row/converter/style/paddings.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var Paddings = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Paddings() {}\n\n    var _proto = Paddings.prototype;\n\n    /**\n     * @param {string} value\n     * @returns {Object | string}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var result = {};\n      var value = (0, _object.get)(data, name);\n\n      if (value && _underscore.isString(value)) {\n        value = JSON.parse(value);\n      }\n\n      if (value && undefined !== value.padding) {\n        result.paddingLeft = value.padding.left ? value.padding.left + \"px\" : \"\";\n        result.paddingTop = value.padding.top ? value.padding.top + \"px\" : \"\";\n        result.paddingRight = value.padding.right ? value.padding.right + \"px\" : \"\";\n        result.paddingBottom = value.padding.bottom ? value.padding.bottom + \"px\" : \"\";\n      }\n\n      return result;\n    };\n\n    return Paddings;\n  }();\n\n  return Paddings;\n});\n//# sourceMappingURL=paddings.js.map","Magento_PageBuilder/js/content-type/row/converter/style/margins.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var Margins = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Margins() {}\n\n    var _proto = Margins.prototype;\n\n    /**\n     * @param {string} value\n     * @returns {Object | string}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var result = {};\n      var value = (0, _object.get)(data, name);\n\n      if (value && _underscore.isString(value)) {\n        value = JSON.parse(value);\n      }\n\n      if (value && undefined !== value.margin) {\n        result.marginLeft = value.margin.left ? value.margin.left + \"px\" : \"\";\n        result.marginTop = value.margin.top ? value.margin.top + \"px\" : \"\";\n        result.marginRight = value.margin.right ? value.margin.right + \"px\" : \"\";\n        result.marginBottom = (parseInt(value.margin.bottom, 10) > 0 ? value.margin.bottom : 1) + \"px\";\n      }\n\n      return result;\n    };\n\n    return Margins;\n  }();\n\n  return Margins;\n});\n//# sourceMappingURL=margins.js.map","Magento_PageBuilder/js/content-type/row/appearance/default/widget.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_PageBuilder/js/widget/video-background',\n    'jarallax'\n], function ($, videoBackground) {\n    'use strict';\n\n    return function (config, element) {\n        var $element = $(element),\n            parallaxSpeed = null,\n            elementStyle = null;\n\n        if ($element.data('appearance') === 'contained') {\n            $element = $(element).find('[data-element=\"inner\"]');\n        }\n\n        if ($element.data('background-type') === 'video') {\n            videoBackground(config, $element[0]);\n\n            return;\n        }\n\n        if ($element.data('enableParallax') !== 1) {\n            return;\n        }\n\n        $element.addClass('jarallax');\n        $element.attr('data-jarallax', '');\n\n        parallaxSpeed = parseFloat($element.data('parallaxSpeed'));\n        elementStyle = window.getComputedStyle($element[0]);\n\n        window.jarallax($element[0], {\n            imgPosition: elementStyle.backgroundPosition || '50% 50%',\n            imgRepeat: elementStyle.backgroundRepeat || 'no-repeat',\n            imgSize: elementStyle.backgroundSize || 'cover',\n            speed: !isNaN(parallaxSpeed) ? parallaxSpeed : 0.5\n        });\n    };\n});\n","Magento_PageBuilder/js/content-type/row/appearance/default/widget-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(['underscore', 'jquery', 'Magento_PageBuilder/js/events'], function (_, $, events) {\n    'use strict';\n\n    return function (target) {\n        return function (config, element) {\n            var result = target(config, element),\n                stageId = $(element).parents('[data-role=\"pagebuilder-stage\"]').attr('id'),\n                $element = $(element);\n\n            if ($element.data('appearance') === 'contained') {\n                $element = $(element).find('[data-element=\"inner\"]');\n            }\n\n            // If Parallax isn't enabled, let's not attach the event\n            if ($element.data('enableParallax') !== 1) {\n                return result;\n            }\n\n            // Listen for full screen events and destroy and rebuild jarallax\n            events.on('stage:' + stageId + ':fullScreenModeChangeAfter', function () {\n                _.delay(function () {\n                    $element.jarallax('destroy');\n                    target(config, element);\n                }, 350);\n            });\n\n            return result;\n        };\n    };\n});\n","Magento_PageBuilder/js/content-type/column-group/drag-and-drop.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Calculate the drop positions of a column group\n   *\n   * @param {ContentTypeCollectionInterface} group\n   * @returns {any[]}\n   */\n  function calculateDropPositions(group) {\n    var resizeUtils = group.preview.getResizeUtils();\n    var dropPositions = [];\n    group.children().forEach(function (column, index) {\n      var left = column.preview.element.position().left;\n      var width = column.preview.element.outerWidth(true);\n      var canShrink = resizeUtils.getAcceptedColumnWidth(resizeUtils.getColumnWidth(column).toString()) > resizeUtils.getSmallestColumnWidth();\n      dropPositions.push({\n        affectedColumn: column,\n        canShrink: canShrink,\n        insertIndex: index,\n        left: left,\n        placement: \"left\",\n        right: left + width / 2\n      }, {\n        affectedColumn: column,\n        canShrink: canShrink,\n        insertIndex: index + 1,\n        left: left + width / 2,\n        placement: \"right\",\n        right: left + width\n      });\n    });\n    return dropPositions;\n  }\n\n  return {\n    calculateDropPositions: calculateDropPositions\n  };\n});\n//# sourceMappingURL=drag-and-drop.js.map","Magento_PageBuilder/js/content-type/column-group/registry.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var dragColumn;\n  /**\n   * Retrieve the drag column from the registry\n   *\n   * @returns {ContentTypeCollectionInterface}\n   */\n\n  function getDragColumn() {\n    return dragColumn;\n  }\n  /**\n   * Remove the drag column reference\n   */\n\n\n  function removeDragColumn() {\n    dragColumn = null;\n  }\n  /**\n   * Set the drag column in the registry\n   *\n   * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n   */\n\n\n  function setDragColumn(column) {\n    dragColumn = column;\n  }\n\n  return {\n    getDragColumn: getDragColumn,\n    removeDragColumn: removeDragColumn,\n    setDragColumn: setDragColumn\n  };\n});\n//# sourceMappingURL=registry.js.map","Magento_PageBuilder/js/content-type/column-group/factory.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type-factory\"], function (_config, _contentTypeFactory) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Create a column and add it to it's column group\n   *\n   * @param {ContentTypeCollectionInterface} columnGroup\n   * @param {number} width\n   * @param {number} index\n   * @returns {Promise<ContentTypeCollectionInterface>}\n   */\n  function createColumn(columnGroup, width, index) {\n    return (0, _contentTypeFactory)(_config.getContentTypeConfig(\"column\"), columnGroup, columnGroup.stageId, {\n      width: parseFloat(width.toString()) + \"%\"\n    }).then(function (column) {\n      columnGroup.addChild(column, index);\n      return column;\n    }).catch(function (error) {\n      console.error(error);\n      return null;\n    });\n  }\n\n  return {\n    createColumn: createColumn\n  };\n});\n//# sourceMappingURL=factory.js.map","Magento_PageBuilder/js/content-type/column-group/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _createForOfIteratorHelperLoose(o, allowArrayLike) { var it = typeof Symbol !== \"undefined\" && o[Symbol.iterator] || o[\"@@iterator\"]; if (it) return (it = it.call(o)).next.bind(it); if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === \"number\") { if (it) o = it; var i = 0; return function () { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }; } throw new TypeError(\"Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jquery\", \"knockout\", \"mage/translate\", \"Magento_PageBuilder/js/events\", \"underscore\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/drag-drop/move-content-type\", \"Magento_PageBuilder/js/drag-drop/registry\", \"Magento_PageBuilder/js/drag-drop/sortable\", \"Magento_PageBuilder/js/utils/check-stage-full-screen\", \"Magento_PageBuilder/js/utils/create-stylesheet\", \"Magento_PageBuilder/js/utils/pagebuilder-header-height\", \"Magento_PageBuilder/js/content-type/column/resize\", \"Magento_PageBuilder/js/content-type/preview-collection\", \"Magento_PageBuilder/js/content-type/column-group/drag-and-drop\", \"Magento_PageBuilder/js/content-type/column-group/factory\", \"Magento_PageBuilder/js/content-type/column-group/grid-size\", \"Magento_PageBuilder/js/content-type/column-group/registry\"], function (_jquery, _knockout, _translate, _events, _underscore, _config, _moveContentType, _registry, _sortable, _checkStageFullScreen, _createStylesheet, _pagebuilderHeaderHeight, _resize, _previewCollection, _dragAndDrop, _factory, _gridSize, _registry2) {\n  function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== \"function\") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }\n\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_previewCollection2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _previewCollection2);\n\n    /**\n     *\n     * @param {ContentTypeCollection} contentType\n     * @param {ContentTypeConfigInterface} config\n     * @param {ObservableUpdater} observableUpdater\n     */\n    function Preview(contentType, config, observableUpdater) {\n      var _this;\n\n      _this = _previewCollection2.call(this, contentType, config, observableUpdater) || this;\n      _this.resizing = _knockout.observable(false);\n      _this.hasEmptyChild = _knockout.computed(function () {\n        var empty = false;\n\n        _this.contentType.getChildren()().forEach(function (column) {\n          if (column.getChildren()().length === 0) {\n            empty = true;\n          }\n        });\n\n        return empty;\n      });\n      _this.gridSize = _knockout.observable();\n      _this.gridSizeInput = _knockout.observable();\n      _this.gridSizeArray = _knockout.observableArray([]);\n      _this.gridSizeError = _knockout.observable();\n      _this.gridSizeMax = _knockout.observable((0, _gridSize.getMaxGridSize)());\n      _this.gridFormOpen = _knockout.observable(false);\n      _this.gridChange = _knockout.observable(false);\n      _this.gridToolTipOverFlow = _knockout.observable(false);\n      _this.resizeColumnWidths = [];\n      _this.resizeHistory = {\n        left: [],\n        right: []\n      };\n      _this.dropPositions = [];\n      _this.gridSizeHistory = new Map();\n      _this.interactionLevel = 0;\n\n      _this.onDocumentClick = function (event) {\n        // Verify the click event wasn't within our form\n        if (!_jquery.contains((0, _jquery)(_this.wrapperElement).find(\".pagebuilder-grid-size-indicator\")[0], (0, _jquery)(event.target)[0])) {\n          _this.closeGridForm();\n        }\n      };\n\n      _this.resizeUtils = new _resize(_this.contentType); // Keep track of the grid size in an observable\n\n      _this.contentType.dataStore.subscribe(function (state) {\n        var gridSize = parseInt(state.grid_size.toString(), 10);\n\n        _this.gridSize(gridSize);\n\n        _this.gridSizeInput(gridSize);\n\n        if (gridSize) {\n          _this.gridSizeArray(new Array(gridSize));\n        }\n      }, \"grid_size\");\n\n      _events.on(\"contentType:removeAfter\", function (args) {\n        if (args.parentContentType && args.parentContentType.id === _this.contentType.id) {\n          _underscore.defer(function () {\n            _this.spreadWidth(args.index);\n          });\n        }\n      }); // Listen for resizing events from child columns\n\n\n      _events.on(\"column:resizeHandleBindAfter\", function (args) {\n        // Does the events content type match the previews column group?\n        if (args.columnGroup.id === _this.contentType.id) {\n          _this.registerResizeHandle(args.column, args.handle);\n        }\n      });\n\n      _events.on(\"column:initializeAfter\", function (args) {\n        // Does the events parent match the previews column group?\n        if (args.columnGroup.id === _this.contentType.id) {\n          _this.bindDraggable(args.column);\n        }\n      });\n\n      _this.contentType.children.subscribe(_underscore.debounce(_this.removeIfEmpty.bind(_assertThisInitialized(_this)), 50));\n\n      return _this;\n    }\n    /**\n     * Retrieve the resize utils\n     *\n     * @returns {Resize}\n     */\n\n\n    var _proto = Preview.prototype;\n\n    _proto.getResizeUtils = function getResizeUtils() {\n      return this.resizeUtils;\n    }\n    /**\n     * Handle a new column being dropped into the group\n     *\n     * @param {DropPosition} dropPosition\n     */\n    ;\n\n    _proto.onNewColumnDrop = function onNewColumnDrop(dropPosition) {\n      var _this2 = this;\n\n      // Create our new column\n      (0, _factory.createColumn)(this.contentType, this.resizeUtils.getSmallestColumnWidth(), dropPosition.insertIndex).then(function () {\n        var newWidth = _this2.resizeUtils.getAcceptedColumnWidth((_this2.resizeUtils.getColumnWidth(dropPosition.affectedColumn) - _this2.resizeUtils.getSmallestColumnWidth()).toString()); // Reduce the affected columns width by the smallest column width\n\n\n        (0, _resize.updateColumnWidth)(dropPosition.affectedColumn, newWidth);\n      });\n    }\n    /**\n     * Handle an existing column being dropped into a new column group\n     *\n     * @param {DropPosition} movePosition\n     */\n    ;\n\n    _proto.onExistingColumnDrop = function onExistingColumnDrop(movePosition) {\n      var column = (0, _registry2.getDragColumn)();\n      var sourceGroupPreview = column.parentContentType.preview;\n      var modifyOldNeighbour; // Determine which old neighbour we should modify\n\n      var oldWidth = sourceGroupPreview.getResizeUtils().getColumnWidth(column); // Retrieve the adjacent column either +1 or -1\n\n      if ((0, _resize.getAdjacentColumn)(column, \"+1\")) {\n        modifyOldNeighbour = (0, _resize.getAdjacentColumn)(column, \"+1\");\n      } else if ((0, _resize.getAdjacentColumn)(column, \"-1\")) {\n        modifyOldNeighbour = (0, _resize.getAdjacentColumn)(column, \"-1\");\n      } // Set the column to it's smallest column width\n\n\n      (0, _resize.updateColumnWidth)(column, this.resizeUtils.getSmallestColumnWidth()); // Move the content type\n\n      (0, _moveContentType.moveContentType)(column, movePosition.insertIndex, this.contentType); // Modify the old neighbour\n\n      if (modifyOldNeighbour) {\n        var oldNeighbourWidth = sourceGroupPreview.getResizeUtils().getAcceptedColumnWidth((oldWidth + sourceGroupPreview.getResizeUtils().getColumnWidth(modifyOldNeighbour)).toString());\n        (0, _resize.updateColumnWidth)(modifyOldNeighbour, oldNeighbourWidth);\n      } // Modify the columns new neighbour\n\n\n      var newNeighbourWidth = this.resizeUtils.getAcceptedColumnWidth((this.resizeUtils.getColumnWidth(movePosition.affectedColumn) - this.resizeUtils.getSmallestColumnWidth()).toString()); // Reduce the affected columns width by the smallest column width\n\n      (0, _resize.updateColumnWidth)(movePosition.affectedColumn, newNeighbourWidth);\n    }\n    /**\n     * Handle a column being sorted into a new position in the group\n     *\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n     * @param {number} newIndex\n     */\n    ;\n\n    _proto.onColumnSort = function onColumnSort(column, newIndex) {\n      var currentIndex = (0, _resize.getColumnIndexInGroup)(column);\n\n      if (currentIndex !== newIndex) {\n        if (currentIndex < newIndex) {\n          // As we're moving an array item the keys all reduce by 1\n          --newIndex;\n        } // Move the content type\n\n\n        (0, _moveContentType.moveContentType)(column, newIndex);\n      }\n    }\n    /**\n     * Handle a column being resized\n     *\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n     * @param {number} width\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} adjustedColumn\n     */\n    ;\n\n    _proto.onColumnResize = function onColumnResize(column, width, adjustedColumn) {\n      this.resizeUtils.resizeColumn(column, width, adjustedColumn);\n    }\n    /**\n     * Init the droppable & resizing interactions\n     *\n     * @param group\n     */\n    ;\n\n    _proto.bindInteractions = function bindInteractions(group) {\n      this.groupElement = (0, _jquery)(group);\n      this.initDroppable(this.groupElement);\n      this.initMouseMove(this.groupElement); // Handle the mouse leaving the window\n\n      (0, _jquery)(\"body\").mouseleave(this.endAllInteractions.bind(this));\n    }\n    /**\n     * Init the drop placeholder\n     *\n     * @param {Element} element\n     */\n    ;\n\n    _proto.bindDropPlaceholder = function bindDropPlaceholder(element) {\n      this.dropPlaceholder = (0, _jquery)(element);\n    }\n    /**\n     * Init the move placeholder\n     *\n     * @param {Element} element\n     */\n    ;\n\n    _proto.bindMovePlaceholder = function bindMovePlaceholder(element) {\n      this.movePlaceholder = (0, _jquery)(element);\n    }\n    /**\n     * Retrieve the ghost element from the template\n     *\n     * @param {Element} ghost\n     */\n    ;\n\n    _proto.bindGhost = function bindGhost(ghost) {\n      this.resizeGhost = (0, _jquery)(ghost);\n    }\n    /**\n     * Register a resize handle within a child column\n     *\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n     * @param {JQuery} handle\n     */\n    ;\n\n    _proto.registerResizeHandle = function registerResizeHandle(column, handle) {\n      var _this3 = this;\n\n      handle.off(\"mousedown touchstart\");\n      handle.on(\"mousedown touchstart\", function (event) {\n        event.preventDefault();\n\n        var groupPosition = _this3.getGroupPosition(_this3.groupElement);\n\n        _this3.resizing(true);\n\n        _this3.resizeColumnInstance = column;\n        _this3.resizeColumnWidths = _this3.resizeUtils.determineColumnWidths(_this3.resizeColumnInstance, groupPosition);\n        _this3.resizeMaxGhostWidth = (0, _resize.determineMaxGhostWidth)(_this3.resizeColumnWidths); // Force the cursor to resizing\n\n        (0, _jquery)(\"body\").css(\"cursor\", \"col-resize\"); // Reset the resize history\n\n        _this3.resizeHistory = {\n          left: [],\n          right: []\n        };\n        _this3.resizeLastPosition = null;\n        _this3.resizeMouseDown = true;\n        ++_this3.interactionLevel;\n\n        _events.trigger(\"stage:interactionStart\", {\n          stageId: _this3.contentType.stageId\n        });\n      });\n    }\n    /**\n     * Bind draggable instances to the child columns\n     *\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n     */\n    ;\n\n    _proto.bindDraggable = function bindDraggable(column) {\n      var _this4 = this;\n\n      column.preview.element.draggable({\n        appendTo: \"body\",\n        containment: \"body\",\n        cursor: \"-webkit-grabbing\",\n        handle: \".move-column\",\n        revertDuration: 250,\n        helper: function helper() {\n          var helper = (0, _jquery)(this).clone();\n          helper.css({\n            height: (0, _jquery)(this).outerHeight() + \"px\",\n            minHeight: 0,\n            opacity: 0.5,\n            pointerEvents: \"none\",\n            width: (0, _jquery)(this).outerWidth() + \"px\",\n            zIndex: 5000\n          });\n          return helper;\n        },\n        start: function start(event) {\n          var columnInstance = _knockout.dataFor((0, _jquery)(event.target)[0]); // Use the global state as columns can be dragged between groups\n\n\n          (0, _registry2.setDragColumn)(columnInstance.contentType);\n          _this4.dropPositions = (0, _dragAndDrop.calculateDropPositions)(_this4.contentType);\n          _this4.startDragEvent = event;\n\n          _events.trigger(\"column:dragStart\", {\n            column: columnInstance,\n            stageId: _this4.contentType.stageId\n          });\n\n          _events.trigger(\"stage:interactionStart\", {\n            stageId: _this4.contentType.stageId\n          });\n        },\n        stop: function stop() {\n          var draggedColumn = (0, _registry2.getDragColumn)();\n\n          if (_this4.movePosition && draggedColumn) {\n            // Check if we're moving within the same group, even though this function will\n            // only ever run on the group that bound the draggable event\n            if (draggedColumn.parentContentType === _this4.contentType) {\n              _this4.onColumnSort(draggedColumn, _this4.movePosition.insertIndex);\n\n              _this4.movePosition = null;\n            }\n          }\n\n          (0, _registry2.removeDragColumn)();\n\n          _this4.dropPlaceholder.removeClass(\"left right\");\n\n          _this4.movePlaceholder.removeClass(\"active\");\n\n          _this4.startDragEvent = null;\n\n          _events.trigger(\"column:dragStop\", {\n            column: draggedColumn,\n            stageId: _this4.contentType.stageId\n          });\n\n          _events.trigger(\"stage:interactionStop\", {\n            stageId: _this4.contentType.stageId\n          });\n        }\n      });\n    }\n    /**\n     * Update the grid size on enter or blur of the input\n     */\n    ;\n\n    _proto.updateGridSize = function updateGridSize() {\n      var _this5 = this;\n\n      if (!_jquery.isNumeric(this.gridSizeInput())) {\n        this.gridSizeError((0, _translate)(\"Please enter a valid number.\"));\n      }\n\n      var newGridSize = parseInt(this.gridSizeInput().toString(), 10);\n\n      if (newGridSize || newGridSize === 0) {\n        if (newGridSize !== this.resizeUtils.getGridSize()) {\n          try {\n            (0, _gridSize.resizeGrid)(this.contentType, newGridSize, this.gridSizeHistory);\n            this.recordGridResize(newGridSize);\n            this.gridSizeError(null); // Make the grid \"flash\" on successful change\n\n            this.gridChange(true);\n\n            _underscore.delay(function () {\n              _this5.gridChange(false);\n            }, 1000);\n          } catch (e) {\n            if (e instanceof _gridSize.GridSizeError) {\n              this.gridSizeError(e.message);\n            } else {\n              throw e;\n            }\n          }\n        } else {\n          this.gridSizeError(null);\n        }\n      }\n    }\n    /**\n     * On grid input key up, check if the enter key was used and submit\n     *\n     * @param {Preview} context\n     * @param {KeyboardEvent} event\n     */\n    ;\n\n    _proto.onGridInputKeyUp = function onGridInputKeyUp(context, event) {\n      if (event.which === 13 || event.keyCode === 13) {\n        this.updateGridSize();\n      }\n    }\n    /**\n     * On grid input blur, update the grid size\n     */\n    ;\n\n    _proto.onGridInputBlur = function onGridInputBlur() {\n      this.updateGridSize();\n    }\n    /**\n     * Hide grid size panel on focus out\n     */\n    ;\n\n    _proto.closeGridForm = function closeGridForm() {\n      this.updateGridSize();\n\n      if (!this.gridSizeError()) {\n        this.gridFormOpen(false);\n        this.gridToolTipOverFlow(false);\n\n        _events.trigger(\"stage:interactionStop\");\n\n        _events.trigger(\"stage:childFocusStop\");\n\n        (0, _jquery)(document).off(\"click focusin\", this.onDocumentClick);\n      }\n    }\n    /**\n     * Show grid size panel on click and start interaction\n     */\n    ;\n\n    _proto.openGridForm = function openGridForm() {\n      var _this6 = this;\n\n      var tooltip = (0, _jquery)(this.wrapperElement).find(\"[role='tooltip']\");\n\n      if (!this.gridFormOpen()) {\n        this.gridSizeHistory = new Map();\n        this.recordGridResize(this.gridSize()); // inline tooltip out of bounds\n\n        var tooltipClientRectTop = tooltip[0].getBoundingClientRect().top - (0, _pagebuilderHeaderHeight)(this.contentType.stageId);\n\n        if ((0, _checkStageFullScreen)(this.contentType.stageId) && tooltip[0].getBoundingClientRect().height > tooltipClientRectTop) {\n          this.gridToolTipOverFlow(true);\n        }\n\n        this.gridFormOpen(true); // Wait for animation to complete\n\n        _underscore.delay(function () {\n          (0, _jquery)(_this6.wrapperElement).find(\".grid-panel-item-wrapper input\").focus().select();\n        }, 200);\n\n        (0, _jquery)(document).on(\"click focusin\", this.onDocumentClick);\n\n        _events.trigger(\"stage:interactionStart\");\n\n        _events.trigger(\"stage:childFocusStart\");\n      }\n    }\n    /**\n     * Handle a click on the document closing the grid form\n     *\n     * @param {Event} event\n     */\n    ;\n\n    /**\n     * Set columns in the group as resizing\n     *\n     * @param {Array<ContentTypeCollectionInterface<ColumnPreview>>} columns\n     */\n    _proto.setColumnsAsResizing = function setColumnsAsResizing() {\n      for (var _len = arguments.length, columns = new Array(_len), _key = 0; _key < _len; _key++) {\n        columns[_key] = arguments[_key];\n      }\n\n      columns.forEach(function (column) {\n        column.preview.resizing(true);\n        column.preview.element.css({\n          transition: \"width 350ms ease-in-out\"\n        });\n      });\n    }\n    /**\n     * Unset resizing flag on all child columns\n     */\n    ;\n\n    _proto.unsetResizingColumns = function unsetResizingColumns() {\n      this.contentType.children().forEach(function (column) {\n        column.preview.resizing(false);\n\n        if (column.preview.element) {\n          column.preview.element.css({\n            transition: \"\"\n          });\n        }\n      });\n    }\n    /**\n     * End all current interactions\n     */\n    ;\n\n    _proto.endAllInteractions = function endAllInteractions() {\n      if (this.resizing() === true) {\n        for (; this.interactionLevel > 0; this.interactionLevel--) {\n          _events.trigger(\"stage:interactionStop\", {\n            stageId: this.contentType.stageId\n          });\n        }\n      }\n\n      this.resizing(false);\n      this.resizeMouseDown = null;\n      this.resizeLeftLastColumnShrunk = this.resizeRightLastColumnShrunk = null;\n      this.dropPositions = [];\n      this.unsetResizingColumns(); // Change the cursor back\n\n      (0, _jquery)(\"body\").css(\"cursor\", \"\");\n      this.dropPlaceholder.removeClass(\"left right\");\n      this.movePlaceholder.css(\"left\", \"\").removeClass(\"active\");\n      this.resizeGhost.removeClass(\"active\"); // Reset the group positions cache\n\n      this.groupPositionCache = null;\n    }\n    /**\n     * Init the resizing events on the group\n     *\n     * @param {JQuery} group\n     */\n    ;\n\n    _proto.initMouseMove = function initMouseMove(group) {\n      var _this7 = this;\n\n      var intersects = false;\n      (0, _jquery)(document).on(\"mousemove touchmove\", function (event) {\n        if (group.parents(_sortable.hiddenClass).length > 0) {\n          return;\n        }\n\n        var groupPosition = _this7.getGroupPosition(group); // If we're handling a touch event we need to pass through the page X & Y\n\n\n        if (event.type === \"touchmove\") {\n          event.pageX = event.originalEvent.pageX;\n          event.pageY = event.originalEvent.pageY;\n        }\n\n        if (_this7.eventIntersectsGroup(event, groupPosition)) {\n          intersects = true;\n\n          _this7.onResizingMouseMove(event, group, groupPosition);\n\n          _this7.onDraggingMouseMove(event, group, groupPosition);\n\n          _this7.onDroppingMouseMove(event, group, groupPosition);\n        } else {\n          intersects = false;\n          _this7.groupPositionCache = null;\n          _this7.dropPosition = null;\n\n          _this7.dropPlaceholder.removeClass(\"left right\");\n\n          _this7.movePlaceholder.css(\"left\", \"\").removeClass(\"active\");\n        }\n      }).on(\"mouseup touchend\", function () {\n        if (intersects) {\n          _this7.handleMouseUp();\n        }\n\n        intersects = false;\n        _this7.dropPosition = null;\n\n        _this7.endAllInteractions();\n\n        _underscore.defer(function () {\n          // Re-enable any disabled sortable areas\n          group.find(\".ui-sortable\").each(function () {\n            if ((0, _jquery)(this).data(\"sortable\")) {\n              (0, _jquery)(this).sortable(\"option\", \"disabled\", false);\n            }\n          });\n        });\n      });\n    }\n    /**\n     * Handle the mouse up action, either adding a new column or moving an existing\n     */\n    ;\n\n    _proto.handleMouseUp = function handleMouseUp() {\n      if (this.dropOverElement && this.dropPosition) {\n        this.onNewColumnDrop(this.dropPosition);\n        this.dropOverElement = null; // Re-enable the parent disabled sortable instance\n\n        _underscore.defer(function () {\n          (0, _jquery)(\".element-children.ui-sortable-disabled\").each(function () {\n            (0, _jquery)(this).sortable(\"option\", \"disabled\", false);\n          });\n        });\n      }\n\n      var column = (0, _registry2.getDragColumn)();\n\n      if (this.movePosition && column && column.parentContentType !== this.contentType) {\n        this.onExistingColumnDrop(this.movePosition);\n      }\n    }\n    /**\n     * Does the current event intersect with the group?\n     *\n     * @param {JQueryEventObject} event\n     * @param {GroupPositionCache} groupPosition\n     * @returns {boolean}\n     */\n    ;\n\n    _proto.eventIntersectsGroup = function eventIntersectsGroup(event, groupPosition) {\n      return event.pageY > groupPosition.top && event.pageY < groupPosition.top + groupPosition.outerHeight && event.pageX > groupPosition.left && event.pageX < groupPosition.left + groupPosition.outerWidth;\n    }\n    /**\n     * Cache the groups positions\n     *\n     * @param {JQuery} group\n     * @returns {GroupPositionCache}\n     */\n    ;\n\n    _proto.getGroupPosition = function getGroupPosition(group) {\n      if (!this.groupPositionCache) {\n        this.groupPositionCache = {\n          top: group.offset().top,\n          left: group.offset().left,\n          width: group.width(),\n          height: group.height(),\n          outerWidth: group.outerWidth(),\n          outerHeight: group.outerHeight()\n        };\n      }\n\n      return this.groupPositionCache;\n    }\n    /**\n     * Record the resizing history for this action\n     *\n     * @param {string} usedHistory\n     * @param {string} direction\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} adjustedColumn\n     * @param {string} modifyColumnInPair\n     */\n    ;\n\n    _proto.recordResizeHistory = function recordResizeHistory(usedHistory, direction, adjustedColumn, modifyColumnInPair) {\n      if (usedHistory) {\n        this.resizeHistory[usedHistory].pop();\n      }\n\n      this.resizeHistory[direction].push({\n        adjustedColumn: adjustedColumn,\n        modifyColumnInPair: modifyColumnInPair\n      });\n    }\n    /**\n     * Handle the resizing on mouse move, we always resize a pair of columns at once\n     *\n     * @param {JQueryEventObject} event\n     * @param {JQuery} group\n     * @param {GroupPositionCache} groupPosition\n     */\n    ;\n\n    _proto.onResizingMouseMove = function onResizingMouseMove(event, group, groupPosition) {\n      var _this8 = this;\n\n      var newColumnWidth;\n\n      if (this.resizeMouseDown) {\n        event.preventDefault();\n        var currentPos = event.pageX;\n        var resizeColumnLeft = this.resizeColumnInstance.preview.element.offset().left;\n        var resizeColumnWidth = this.resizeColumnInstance.preview.element.outerWidth();\n        var resizeHandlePosition = resizeColumnLeft + resizeColumnWidth;\n        var direction = currentPos >= resizeHandlePosition ? \"right\" : \"left\";\n        var adjustedColumn;\n        var modifyColumnInPair; // We need to know if we're modifying the left or right column in the pair\n\n        var usedHistory; // Was the adjusted column pulled from history?\n        // Determine which column in the group should be adjusted for this action\n\n        var _this$resizeUtils$det = this.resizeUtils.determineAdjustedColumn(currentPos, this.resizeColumnInstance, this.resizeHistory);\n\n        adjustedColumn = _this$resizeUtils$det[0];\n        modifyColumnInPair = _this$resizeUtils$det[1];\n        usedHistory = _this$resizeUtils$det[2];\n        // Calculate the ghost width based on mouse position and bounds of allowed sizes\n        var ghostWidth = this.resizeUtils.calculateGhostWidth(groupPosition, currentPos, this.resizeColumnInstance, modifyColumnInPair, this.resizeMaxGhostWidth);\n        this.resizeGhost.width(ghostWidth - 15 + \"px\").addClass(\"active\");\n\n        if (adjustedColumn && this.resizeColumnWidths) {\n          newColumnWidth = this.resizeColumnWidths.find(function (val) {\n            return (0, _resize.comparator)(currentPos, val.position, 35) && val.forColumn === modifyColumnInPair;\n          });\n\n          if (newColumnWidth) {\n            var mainColumn = this.resizeColumnInstance; // If we're using the left data set, we're actually resizing the right column of the group\n\n            if (modifyColumnInPair === \"right\") {\n              mainColumn = (0, _resize.getAdjacentColumn)(this.resizeColumnInstance, \"+1\");\n            } // Ensure we aren't resizing multiple times, also validate the last resize isn't the same as the\n            // one being performed now. This occurs as we re-calculate the column positions on resize, we have\n            // to use the comparator as the calculation may result in slightly different numbers due to rounding\n\n\n            if (this.resizeUtils.getColumnWidth(mainColumn) !== newColumnWidth.width && !(0, _resize.comparator)(this.resizeLastPosition, newColumnWidth.position, 10)) {\n              // If our previous action was to resize the right column in pair, and we're now dragging back\n              // to the right, but have matched a column for the left we need to fix the columns being\n              // affected\n              if (usedHistory && this.resizeLastColumnInPair === \"right\" && direction === \"right\" && newColumnWidth.forColumn === \"left\") {\n                var originalMainColumn = mainColumn;\n                mainColumn = adjustedColumn;\n                adjustedColumn = (0, _resize.getAdjacentColumn)(originalMainColumn, \"+1\");\n              }\n\n              this.recordResizeHistory(usedHistory, direction, adjustedColumn, modifyColumnInPair);\n              this.resizeLastPosition = newColumnWidth.position;\n              this.resizeLastColumnInPair = modifyColumnInPair; // Ensure the adjusted column is marked as resizing to animate correctly\n\n              this.setColumnsAsResizing(mainColumn, adjustedColumn);\n              this.onColumnResize(mainColumn, newColumnWidth.width, adjustedColumn); // Wait for the render cycle to finish from the above resize before re-calculating\n\n              _underscore.defer(function () {\n                // If we do a resize, re-calculate the column widths\n                _this8.resizeColumnWidths = _this8.resizeUtils.determineColumnWidths(_this8.resizeColumnInstance, groupPosition);\n                _this8.resizeMaxGhostWidth = (0, _resize.determineMaxGhostWidth)(_this8.resizeColumnWidths);\n              });\n            }\n          }\n        }\n      }\n    }\n    /**\n     * Handle a column being dragged around the group\n     *\n     * @param {JQueryEventObject} event\n     * @param {JQuery} group\n     * @param {GroupPositionCache} groupPosition\n     */\n    ;\n\n    _proto.onDraggingMouseMove = function onDraggingMouseMove(event, group, groupPosition) {\n      var dragColumn = (0, _registry2.getDragColumn)();\n\n      if (dragColumn) {\n        // If the drop positions haven't been calculated for this group do so now\n        if (this.dropPositions.length === 0) {\n          this.dropPositions = (0, _dragAndDrop.calculateDropPositions)(this.contentType);\n        }\n\n        var columnInstance = dragColumn;\n        var currentX = event.pageX - groupPosition.left; // Are we within the same column group or have we ended up over another?\n\n        if (columnInstance.parentContentType === this.contentType && this.startDragEvent) {\n          var dragDirection = event.pageX <= this.startDragEvent.pageX ? \"left\" : \"right\";\n          var adjacentLeftColumn = (0, _resize.getAdjacentColumn)(dragColumn, \"-1\"); // Determine the current move position based on the cursors position and direction of drag\n\n          this.movePosition = this.dropPositions.find(function (position) {\n            return currentX > position.left && currentX < position.right && position.placement === dragDirection && position.affectedColumn !== dragColumn;\n          }); // Differences in the element & event positions cause a right movement to activate on the left column\n\n          if (this.movePosition && dragDirection === \"right\" && this.movePosition.affectedColumn === adjacentLeftColumn) {\n            this.movePosition = null;\n          }\n\n          if (this.movePosition) {\n            this.dropPlaceholder.removeClass(\"left right\");\n            this.movePlaceholder.css({\n              left: this.movePosition.placement === \"left\" ? this.movePosition.left : \"\",\n              right: this.movePosition.placement === \"right\" ? groupPosition.width - this.movePosition.right : \"\",\n              width: dragColumn.preview.element.outerWidth() + \"px\"\n            }).addClass(\"active\");\n          } else {\n            this.movePlaceholder.removeClass(\"active\");\n          }\n        } else {\n          // If we're moving to another column group we utilise the existing drop placeholder\n          this.movePosition = this.dropPositions.find(function (position) {\n            return currentX > position.left && currentX <= position.right && position.canShrink;\n          });\n\n          if (this.movePosition) {\n            var classToRemove = this.movePosition.placement === \"left\" ? \"right\" : \"left\";\n            this.movePlaceholder.removeClass(\"active\");\n            this.dropPlaceholder.removeClass(classToRemove).css({\n              left: this.movePosition.placement === \"left\" ? this.movePosition.left : \"\",\n              right: this.movePosition.placement === \"right\" ? groupPosition.width - this.movePosition.right : \"\",\n              width: groupPosition.width / this.resizeUtils.getGridSize() + \"px\"\n            }).addClass(this.movePosition.placement);\n          } else {\n            this.dropPlaceholder.removeClass(\"left right\");\n          }\n        }\n      }\n    }\n    /**\n     * Handle mouse move events on when dropping elements\n     *\n     * @param {JQueryEventObject} event\n     * @param {JQuery} group\n     * @param {GroupPositionCache} groupPosition\n     */\n    ;\n\n    _proto.onDroppingMouseMove = function onDroppingMouseMove(event, group, groupPosition) {\n      var elementChildrenParent = group.parents(\".element-children\"); // Only initiate this process if we're within the group by a buffer to allow for sortable to function correctly\n\n      if (this.dropOverElement && event.pageY > groupPosition.top + 20 && event.pageY < groupPosition.top + groupPosition.outerHeight - 20) {\n        // Disable the column group sortable instance\n        if (elementChildrenParent.data(\"sortable\")) {\n          elementChildrenParent.sortable(\"option\", \"disabled\", true);\n        }\n\n        var currentX = event.pageX - groupPosition.left;\n        this.dropPosition = this.dropPositions.find(function (position) {\n          return currentX > position.left && currentX <= position.right && position.canShrink;\n        });\n\n        if (this.dropPosition) {\n          this.dropPlaceholder.removeClass(\"left right\").css({\n            left: this.dropPosition.placement === \"left\" ? this.dropPosition.left : \"\",\n            right: this.dropPosition.placement === \"right\" ? groupPosition.width - this.dropPosition.right : \"\",\n            width: groupPosition.width / this.resizeUtils.getGridSize() + \"px\"\n          }).addClass(this.dropPosition.placement);\n        }\n      } else if (this.dropOverElement) {\n        // Re-enable the column group sortable instance\n        if (elementChildrenParent.data(\"sortable\")) {\n          elementChildrenParent.sortable(\"option\", \"disabled\", false);\n        }\n\n        this.dropPosition = null;\n        this.dropPlaceholder.removeClass(\"left right\");\n      }\n    }\n    /**\n     * Init the droppable functionality for new columns\n     *\n     * @param {JQuery} group\n     */\n    ;\n\n    _proto.initDroppable = function initDroppable(group) {\n      var self = this;\n      var headStyles;\n      group.droppable({\n        deactivate: function deactivate() {\n          self.dropOverElement = null;\n          self.dropPlaceholder.removeClass(\"left right\");\n\n          _underscore.defer(function () {\n            // Re-enable the column group sortable instance & all children sortable instances\n            group.parents(\".element-children\").each(function () {\n              if ((0, _jquery)(this).data(\"sortable\")) {\n                (0, _jquery)(this).sortable(\"option\", \"disabled\", false);\n              }\n            });\n          });\n        },\n        activate: function activate() {\n          if ((0, _registry.getDraggedContentTypeConfig)() === _config.getContentTypeConfig(\"column\")) {\n            var _ref;\n\n            group.find(\".ui-sortable\").each(function () {\n              if ((0, _jquery)(this).data(\"sortable\")) {\n                (0, _jquery)(this).sortable(\"option\", \"disabled\", true);\n              }\n            });\n            var classes = [\".pagebuilder-content-type.pagebuilder-column .pagebuilder-drop-indicator\", \".pagebuilder-content-type.pagebuilder-column .empty-container .content-type-container:before\"]; // Ensure we don't display any drop indicators inside the column\n\n            headStyles = (0, _createStylesheet.createStyleSheet)((_ref = {}, _ref[classes.join(\", \")] = {\n              display: \"none!important\"\n            }, _ref));\n            document.head.appendChild(headStyles);\n          } else if (headStyles) {\n            headStyles.remove();\n            headStyles = null;\n          }\n        },\n        drop: function drop() {\n          self.dropPositions = [];\n          self.dropPlaceholder.removeClass(\"left right\");\n        },\n        out: function out() {\n          self.dropOverElement = null;\n          self.dropPlaceholder.removeClass(\"left right\");\n        },\n        over: function over() {\n          // Is the element currently being dragged a column?\n          if ((0, _registry.getDraggedContentTypeConfig)() === _config.getContentTypeConfig(\"column\")) {\n            // Always calculate drop positions when an element is dragged over\n            self.dropPositions = (0, _dragAndDrop.calculateDropPositions)(self.contentType);\n            self.dropOverElement = true;\n          } else {\n            self.dropOverElement = null;\n          }\n        }\n      });\n    }\n    /**\n     * Spread any empty space across the other columns when a column is removed\n     *\n     * @param {number} removedIndex\n     */\n    ;\n\n    _proto.spreadWidth = function spreadWidth(removedIndex) {\n      if (this.contentType.children().length === 0) {\n        return;\n      }\n\n      var availableWidth = 100 - this.resizeUtils.getColumnsWidth();\n      var formattedAvailableWidth = (0, _resize.getRoundedColumnWidth)(availableWidth);\n      var totalChildColumns = this.contentType.children().length;\n      var allowedColumnWidths = [];\n      var spreadAcross = 1;\n      var spreadAmount;\n\n      for (var i = this.resizeUtils.getGridSize(); i > 0; i--) {\n        allowedColumnWidths.push((0, _resize.getRoundedColumnWidth)(100 / this.resizeUtils.getGridSize() * i));\n      } // Determine how we can spread the empty space across the columns\n\n\n      for (var _i = totalChildColumns; _i > 0; _i--) {\n        var potentialWidth = Math.floor(formattedAvailableWidth / _i);\n\n        for (var _iterator = _createForOfIteratorHelperLoose(allowedColumnWidths), _step; !(_step = _iterator()).done;) {\n          var width = _step.value;\n\n          if (potentialWidth === Math.floor(width)) {\n            spreadAcross = _i;\n            spreadAmount = formattedAvailableWidth / _i;\n            break;\n          }\n        }\n\n        if (spreadAmount) {\n          break;\n        }\n      } // Let's spread the width across the columns\n\n\n      for (var _i2 = 1; _i2 <= spreadAcross; _i2++) {\n        var columnToModify = void 0; // As the original column has been removed from the array, check the new index for a column\n\n        if (removedIndex <= this.contentType.children().length && typeof this.contentType.children()[removedIndex] !== \"undefined\") {\n          columnToModify = this.contentType.children()[removedIndex];\n        }\n\n        if (!columnToModify && removedIndex - _i2 >= 0 && typeof this.contentType.children()[removedIndex - _i2] !== \"undefined\") {\n          columnToModify = this.contentType.children()[removedIndex - _i2];\n        }\n\n        if (columnToModify) {\n          (0, _resize.updateColumnWidth)(columnToModify, this.resizeUtils.getColumnWidth(columnToModify) + spreadAmount);\n        }\n      }\n    }\n    /**\n     * Remove self if we contain no children\n     */\n    ;\n\n    _proto.removeIfEmpty = function removeIfEmpty() {\n      if (this.contentType.children().length === 0) {\n        this.contentType.parentContentType.removeChild(this.contentType);\n        return;\n      }\n    }\n    /**\n     * Record the grid resize operation into a history for later restoration\n     *\n     * @param {number} newGridSize\n     */\n    ;\n\n    _proto.recordGridResize = function recordGridResize(newGridSize) {\n      var _this9 = this;\n\n      if (!this.gridSizeHistory.has(newGridSize)) {\n        var columnWidths = [];\n        this.contentType.getChildren()().forEach(function (column) {\n          columnWidths.push(_this9.resizeUtils.getColumnWidth(column));\n        });\n        this.gridSizeHistory.set(newGridSize, columnWidths);\n      }\n    };\n\n    return Preview;\n  }(_previewCollection);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/column-group/grid-size.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _wrapNativeSuper(Class) { var _cache = typeof Map === \"function\" ? new Map() : undefined; _wrapNativeSuper = function _wrapNativeSuper(Class) { if (Class === null || !_isNativeFunction(Class)) return Class; if (typeof Class !== \"function\") { throw new TypeError(\"Super expression must either be null or a function\"); } if (typeof _cache !== \"undefined\") { if (_cache.has(Class)) return _cache.get(Class); _cache.set(Class, Wrapper); } function Wrapper() { return _construct(Class, arguments, _getPrototypeOf(this).constructor); } Wrapper.prototype = Object.create(Class.prototype, { constructor: { value: Wrapper, enumerable: false, writable: true, configurable: true } }); return _setPrototypeOf(Wrapper, Class); }; return _wrapNativeSuper(Class); }\n\nfunction _construct(Parent, args, Class) { if (_isNativeReflectConstruct()) { _construct = Reflect.construct; } else { _construct = function _construct(Parent, args, Class) { var a = [null]; a.push.apply(a, args); var Constructor = Function.bind.apply(Parent, a); var instance = new Constructor(); if (Class) _setPrototypeOf(instance, Class.prototype); return instance; }; } return _construct.apply(null, arguments); }\n\nfunction _isNativeReflectConstruct() { if (typeof Reflect === \"undefined\" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === \"function\") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }\n\nfunction _isNativeFunction(fn) { return Function.toString.call(fn).indexOf(\"[native code]\") !== -1; }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\nfunction _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }\n\nfunction _createForOfIteratorHelperLoose(o, allowArrayLike) { var it = typeof Symbol !== \"undefined\" && o[Symbol.iterator] || o[\"@@iterator\"]; if (it) return (it = it.call(o)).next.bind(it); if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === \"number\") { if (it) o = it; var i = 0; return function () { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }; } throw new TypeError(\"Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\ndefine([\"mage/translate\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type/column/resize\"], function (_translate, _config, _resize) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Retrieve default  grid size\n   *\n   * @returns {number}\n   */\n  function getDefaultGridSize() {\n    return parseInt(_config.getConfig(\"column_grid_default\"), 10);\n  }\n  /**\n   * Retrieve the max grid size\n   *\n   * @returns {number}\n   */\n\n\n  function getMaxGridSize() {\n    return parseInt(_config.getConfig(\"column_grid_max\"), 10);\n  }\n  /**\n   * Apply the new grid size, adjusting the existing columns as needed.\n   *\n   * Rules for resizing the grid:\n   *  - The grid size can be increased up to the configured maximum value.\n   *  - The grid size can be decreased only if the number of non-empty columns is less than or equal to the new size.\n   *  - If the new grid size is less than the number of columns currently in the grid, empty columns will be deleted\n   *    to accommodate the new size.\n   *\n   * @param {ContentTypeCollectionInterface<Preview>} columnGroup\n   * @param {number} newGridSize\n   * @param {Map<number, number[]>} gridSizeHistory\n   */\n\n\n  function resizeGrid(columnGroup, newGridSize, gridSizeHistory) {\n    if (newGridSize === columnGroup.preview.getResizeUtils().getGridSize()) {\n      return;\n    }\n\n    validateNewGridSize(columnGroup, newGridSize); // if we have more columns than the new grid size allows, remove empty columns until we are at the correct size\n\n    if (newGridSize < columnGroup.getChildren()().length) {\n      removeEmptyColumnsToFit(columnGroup, newGridSize);\n    }\n\n    columnGroup.preview.gridSize(newGridSize); // update column widths\n\n    redistributeColumnWidths(columnGroup, newGridSize, gridSizeHistory);\n  }\n  /**\n   * Validate that the new grid size is within the configured limits and can be achieved.\n   *\n   * @param {ContentTypeCollectionInterface<Preview>} columnGroup\n   * @param {number} newGridSize\n   */\n\n\n  function validateNewGridSize(columnGroup, newGridSize) {\n    // Validate against the max grid size\n    if (newGridSize > getMaxGridSize()) {\n      throw new GridSizeError((0, _translate)(\"The maximum grid size supported is \" + getMaxGridSize() + \".\"));\n    } else if (newGridSize < 2) {\n      throw new GridSizeError((0, _translate)(\"The minimum grid size supported is 2.\"));\n    } // Validate that the operation will be successful\n\n\n    var numCols = columnGroup.getChildren()().length;\n    var currentGridSize = columnGroup.preview.getResizeUtils().getGridSize();\n\n    if (newGridSize < currentGridSize && numCols > newGridSize) {\n      var numEmptyColumns = 0;\n      columnGroup.getChildren()().forEach(function (column) {\n        if (column.getChildren()().length === 0) {\n          numEmptyColumns++;\n        }\n      });\n\n      if (newGridSize < numCols - numEmptyColumns) {\n        throw new GridSizeError((0, _translate)(\"Grid size cannot be smaller than the current total amount of columns, minus any empty columns.\"));\n      }\n    }\n  }\n  /**\n   * Remove empty columns so we can accommodate the new grid size\n   *\n   * @param {ContentTypeCollectionInterface<Preview>} columnGroup\n   * @param {number} newGridSize\n   */\n\n\n  function removeEmptyColumnsToFit(columnGroup, newGridSize) {\n    var columns = columnGroup.getChildren()();\n    var numColumns = columns.length;\n    var i;\n\n    for (i = numColumns - 1; i >= 0; i--) {\n      var column = columns[i];\n\n      if (newGridSize < numColumns && column.getChildren()().length === 0) {\n        columnGroup.removeChild(column);\n        numColumns--;\n      }\n    }\n  }\n  /**\n   * Adjust columns widths across the new grid size, making sure each column is at least one grid size in width\n   * and the entire grid size is distributed.\n   *\n   * @param {ContentTypeCollectionInterface<Preview>} columnGroup\n   * @param {number} newGridSize\n   * @param {Map<number, number[]>} gridSizeHistory\n   */\n\n\n  function redistributeColumnWidths(columnGroup, newGridSize, gridSizeHistory) {\n    // apply known column widths if we have resized before\n    if (gridSizeHistory.has(newGridSize) && gridSizeHistory.get(newGridSize).length === columnGroup.getChildren()().length) {\n      var columnWidths = gridSizeHistory.get(newGridSize);\n      columnGroup.getChildren()().forEach(function (column, index) {\n        (0, _resize.updateColumnWidth)(column, columnWidths[index]);\n      });\n      columnGroup.dataStore.set(\"grid_size\", newGridSize);\n      return;\n    }\n\n    var resizeUtils = columnGroup.preview.getResizeUtils();\n    var existingGridSize = resizeUtils.getGridSize();\n    var minColWidth = parseFloat((100 / newGridSize).toString()).toFixed(Math.round(100 / newGridSize) !== 100 / newGridSize ? 8 : 0);\n    var totalNewWidths = 0;\n    var numColumns = columnGroup.getChildren()().length;\n    var remainingWidth = 0;\n    columnGroup.getChildren()().forEach(function (column, index) {\n      var existingWidth = resizeUtils.getColumnWidth(column);\n      var fractionColumnWidth = Math.round(existingWidth / (100 / existingGridSize));\n      /**\n       * Determine if the grid & column are directly compatible with the new defined grid size, this will directly\n       * convert fractions to their equivalent of the new grid size.\n       *\n       * For instance changing a 12 column grid with 2 x 6 / 12 columns to a 6 grid is fully compatible.\n       *\n       * Check the existing grid size and new grid size are divisible, verify the amount of columns will fit\n       * in the new grid size and finally check the calculation to convert the existing column width results in a\n       * positive integer.\n       */\n\n      if ((existingGridSize > newGridSize && existingGridSize % newGridSize === 0 || existingGridSize < newGridSize && newGridSize % existingGridSize === 0) && newGridSize % numColumns === 0 && newGridSize / existingGridSize * fractionColumnWidth % 1 === 0) {\n        // We don't need to modify the columns width as it's directly compatible, we will however increment the\n        // width counter as some other columns may not be compatible.\n        totalNewWidths += existingWidth;\n      } else {\n        var newWidth = (100 * Math.floor(existingWidth / 100 * newGridSize) / newGridSize).toFixed(Math.round(100 / newGridSize) !== 100 / newGridSize ? 8 : 0); // make sure the column is at least one grid size wide\n\n        if (parseFloat(newWidth) < parseFloat(minColWidth)) {\n          newWidth = minColWidth;\n        } // make sure we leave enough space for other columns\n\n\n        var maxAvailableWidth = 100 - totalNewWidths - (numColumns - index - 1) * parseFloat(minColWidth);\n\n        if (parseFloat(newWidth) > maxAvailableWidth) {\n          newWidth = maxAvailableWidth.toFixed(Math.round(100 / newGridSize) !== 100 / newGridSize ? 8 : 0);\n        } // Calculate any width lost from the column, if a 5 / 12 is becoming a 2 / 6 then it's lost 1 / 12\n\n\n        remainingWidth += existingWidth - parseFloat(newWidth);\n        /**\n         * Determine if we have enough remaining width, and apply it to the current column, this results in a\n         * subsequent column always receiving any additional width from the previous column\n         */\n\n        if (resizeUtils.getSmallestColumnWidth(newGridSize) === resizeUtils.getAcceptedColumnWidth(remainingWidth.toString(), newGridSize)) {\n          var widthWithRemaining = resizeUtils.getAcceptedColumnWidth((parseFloat(newWidth) + remainingWidth).toString(), newGridSize);\n\n          if (widthWithRemaining > 0) {\n            newWidth = widthWithRemaining.toFixed(Math.round(100 / widthWithRemaining) !== 100 / widthWithRemaining ? 8 : 0);\n            remainingWidth = 0;\n          }\n        }\n\n        totalNewWidths += parseFloat(newWidth);\n        (0, _resize.updateColumnWidth)(column, parseFloat(newWidth));\n      }\n\n      column.preview.updateDisplayLabel();\n    }); // persist new grid size so upcoming calls to get column widths are calculated correctly\n\n    columnGroup.dataStore.set(\"grid_size\", newGridSize); // apply leftover columns if the new grid size did not distribute evenly into existing columns\n\n    if (Math.round(resizeUtils.getColumnsWidth()) < 100) {\n      applyLeftoverColumns(columnGroup, newGridSize);\n    }\n  }\n  /**\n   * Make sure the full grid size is distributed across the columns\n   *\n   * @param {ContentTypeCollectionInterface<Preview>} columnGroup\n   * @param {number} newGridSize\n   */\n\n\n  function applyLeftoverColumns(columnGroup, newGridSize) {\n    var resizeUtils = columnGroup.preview.getResizeUtils();\n    var minColWidth = parseFloat((100 / newGridSize).toString()).toFixed(Math.round(100 / newGridSize) !== 100 / newGridSize ? 8 : 0);\n    var column;\n\n    for (var _iterator = _createForOfIteratorHelperLoose(columnGroup.getChildren()()), _step; !(_step = _iterator()).done;) {\n      column = _step.value;\n\n      if (Math.round(resizeUtils.getColumnsWidth()) < 100) {\n        (0, _resize.updateColumnWidth)(column, parseFloat(resizeUtils.getColumnWidth(column).toString()) + parseFloat(minColWidth));\n      } else {\n        break;\n      }\n    }\n  }\n\n  var GridSizeError = /*#__PURE__*/function (_Error) {\n    \"use strict\";\n\n    _inheritsLoose(GridSizeError, _Error);\n\n    function GridSizeError(m) {\n      var _this;\n\n      _this = _Error.call(this, m) || this;\n      Object.setPrototypeOf(_assertThisInitialized(_this), GridSizeError.prototype);\n      return _this;\n    }\n\n    return GridSizeError;\n  }( /*#__PURE__*/_wrapNativeSuper(Error));\n\n  return {\n    getDefaultGridSize: getDefaultGridSize,\n    getMaxGridSize: getMaxGridSize,\n    resizeGrid: resizeGrid,\n    GridSizeError: GridSizeError\n  };\n});\n//# sourceMappingURL=grid-size.js.map","Magento_PageBuilder/js/content-type/map/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"knockout\", \"Magento_PageBuilder/js/events\", \"Magento_PageBuilder/js/utils/map\", \"module\", \"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/content-type/preview\"], function (_knockout, _events, _map, _module, _hideShowOption, _preview) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_preview2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _preview2);\n\n    function Preview() {\n      var _this;\n\n      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {\n        args[_key] = arguments[_key];\n      }\n\n      _this = _preview2.call.apply(_preview2, [this].concat(args)) || this;\n      _this.apiKeyValid = _knockout.observable(!!_module.config().apiKey);\n      _this.apiKeyErrorMessage = _module.config().apiKeyErrorMessage;\n      return _this;\n    }\n\n    var _proto = Preview.prototype;\n\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _preview2.prototype.retrieveOptions.call(this);\n\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    }\n    /**\n     * Open edit menu on map content type drop with a delay of 300ms\n     */\n    ;\n\n    _proto.bindEvents = function bindEvents() {\n      var _this2 = this;\n\n      _preview2.prototype.bindEvents.call(this); // When the map api key fails, empties out the content type and adds the placeholder\n\n\n      _events.on(\"googleMaps:authFailure\", function () {\n        _this2.apiKeyValid(false);\n      });\n    }\n    /**\n     * Renders the map and subscribe to position for updates\n     *\n     * @param {Element} element\n     * @returns {void}\n     */\n    ;\n\n    _proto.renderMap = function renderMap(element) {\n      var _this3 = this;\n\n      if (!this.apiKeyValid()) {\n        return;\n      }\n\n      this.generateMap(element);\n      this.element = element;\n\n      if (this.mapElement && this.mapElement.map) {\n        this.data.main.attributes.subscribe(function () {\n          _this3.updateMap();\n        });\n      }\n    }\n    /**\n     * Generate maps\n     *\n     * @param {Element} element\n     * @returns {void}\n     */\n    ;\n\n    _proto.generateMap = function generateMap(element) {\n      var currentLocations = this.data.main.attributes()[\"data-locations\"] || \"[]\";\n      var controls = this.data.main.attributes()[\"data-show-controls\"] || \"true\";\n      var locations = [];\n      var options = {\n        disableDefaultUI: controls !== \"true\",\n        mapTypeControl: controls === \"true\"\n      };\n\n      if (currentLocations !== \"[]\") {\n        var mapData = this.getMapData();\n        locations = mapData.locations;\n        options = mapData.options;\n      }\n\n      this.mapElement = new _map(element, locations, options);\n    }\n    /**\n     * Updates map\n     *\n     * @returns {void}\n     */\n    ;\n\n    _proto.updateMap = function updateMap() {\n      var mapData = this.getMapData();\n      this.mapElement.onUpdate(mapData.locations, mapData.options);\n    }\n    /**\n     * Get locations, center coordinates, and zoom from data.position\n     *\n     * @returns {Object}\n     */\n    ;\n\n    _proto.getMapData = function getMapData() {\n      var attributes = this.data.main.attributes();\n      var controls = attributes[\"data-show-controls\"];\n      var options = {\n        disableDefaultUI: controls !== \"true\",\n        mapTypeControl: controls === \"true\"\n      };\n      var locations = attributes[\"data-locations\"];\n\n      if (locations !== \"\" && typeof locations === \"string\") {\n        locations = JSON.parse(locations);\n      }\n\n      locations.forEach(function (location) {\n        location.position.latitude = parseFloat(location.position.latitude);\n        location.position.longitude = parseFloat(location.position.longitude);\n      });\n      return {\n        locations: locations,\n        options: options\n      };\n    };\n\n    return Preview;\n  }(_preview);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/map/converter/attribute/locations.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var Locations = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Locations() {}\n\n    var _proto = Locations.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      if (value && value !== \"\") {\n        return JSON.parse(value);\n      }\n\n      return [];\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var content = (0, _object.get)(data, name);\n\n      if (_underscore.isString(content) && content !== \"\") {\n        content = JSON.parse(content);\n      }\n\n      if (content && Object.keys(content).length) {\n        content.forEach(function (marker) {\n          if (marker.position) {\n            marker.position.latitude = parseFloat(marker.position.latitude);\n            marker.position.longitude = parseFloat(marker.position.longitude);\n          }\n        });\n        return JSON.stringify(content);\n      }\n\n      return JSON.stringify([]);\n    };\n\n    return Locations;\n  }();\n\n  return Locations;\n});\n//# sourceMappingURL=locations.js.map","Magento_PageBuilder/js/content-type/map/appearance/default/widget.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_PageBuilder/js/utils/map'\n], function ($, GoogleMap) {\n    'use strict';\n\n    return function (config, element) {\n        var locations,\n            controls,\n            mapOptions = {};\n\n        element = element[0];\n\n        if (element !== undefined && element.hasAttribute('data-locations')) {\n\n            /**\n             * Set map display to none if no locations\n             */\n            if (element.getAttribute('data-locations') === '[]') {\n                $(element).hide();\n\n                return;\n            }\n            locations = JSON.parse(element.getAttribute('data-locations'));\n            locations.forEach(function (location) {\n                location.position.latitude = parseFloat(location.position.latitude);\n                location.position.longitude = parseFloat(location.position.longitude);\n            });\n            controls = element.getAttribute('data-show-controls');\n            mapOptions.disableDefaultUI = controls !== 'true';\n            mapOptions.mapTypeControl = controls === 'true';\n            new GoogleMap(element, locations, mapOptions);\n        }\n    };\n});\n","Magento_PageBuilder/js/content-type/divider/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/content-type/preview\"], function (_hideShowOption, _preview) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_preview2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _preview2);\n\n    function Preview() {\n      return _preview2.apply(this, arguments) || this;\n    }\n\n    var _proto = Preview.prototype;\n\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _preview2.prototype.retrieveOptions.call(this);\n\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    };\n\n    return Preview;\n  }(_preview);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/button-item/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jquery\", \"knockout\", \"mage/translate\", \"Magento_PageBuilder/js/content-type-menu/conditional-remove-option\", \"Magento_PageBuilder/js/content-type/preview\"], function (_jquery, _knockout, _translate, _conditionalRemoveOption, _preview) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_preview2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _preview2);\n\n    function Preview() {\n      var _this;\n\n      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {\n        args[_key] = arguments[_key];\n      }\n\n      _this = _preview2.call.apply(_preview2, [this].concat(args)) || this;\n      _this.buttonPlaceholder = (0, _translate)(\"Edit Button Text\");\n      return _this;\n    }\n\n    var _proto = Preview.prototype;\n\n    /**\n     * Use the conditional remove to disable the option when the parent has a single child\n     *\n     * @returns {OptionsInterface}\n     */\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _preview2.prototype.retrieveOptions.call(this);\n\n      delete options.title;\n      delete options.move;\n      options.remove = new _conditionalRemoveOption(_extends({}, options.remove.config, {\n        preview: this\n      }));\n      return options;\n    }\n    /**\n     * Force the focus on the clicked button\n     *\n     * @param {number} index\n     * @param {JQueryEventObject} event\n     */\n    ;\n\n    _proto.onClick = function onClick(index, event) {\n      (0, _jquery)(event.currentTarget).find(\"[contenteditable]\").focus();\n      event.stopPropagation();\n    }\n    /**\n     * Handle on focus out events, when the button item is focused out we need to set our focusedButton record on the\n     * buttons preview item to null. If we detect this focus out event is to focus into another button we need to ensure\n     * we update the record appropriately.\n     *\n     * @param {number} index\n     * @param {Event} event\n     */\n    ;\n\n    _proto.onFocusOut = function onFocusOut(index, event) {\n      if (this.contentType && this.contentType.parentContentType) {\n        var parentPreview = this.contentType.parentContentType.preview;\n\n        var unfocus = function unfocus() {\n          window.getSelection().removeAllRanges();\n          parentPreview.focusedButton(null);\n        };\n\n        if (event.relatedTarget && _jquery.contains(parentPreview.wrapperElement, event.relatedTarget)) {\n          // Verify the focus was not onto the options menu\n          if ((0, _jquery)(event.relatedTarget).closest(\".pagebuilder-options\").length > 0) {\n            unfocus();\n          } else {\n            // Have we moved the focus onto another button in the current group?\n            var buttonItem = _knockout.dataFor(event.relatedTarget);\n\n            if (buttonItem && buttonItem.contentType && buttonItem.contentType.parentContentType && buttonItem.contentType.parentContentType.id === this.contentType.parentContentType.id) {\n              var newIndex = buttonItem.contentType.parentContentType.children().indexOf(buttonItem.contentType);\n              parentPreview.focusedButton(newIndex);\n            } else {\n              unfocus();\n            }\n          }\n        } else if (parentPreview.focusedButton() === index) {\n          unfocus();\n        }\n      }\n    }\n    /**\n     * On focus in set the focused button\n     *\n     * @param {number} index\n     * @param {Event} event\n     */\n    ;\n\n    _proto.onFocusIn = function onFocusIn(index, event) {\n      var parentPreview = this.contentType.parentContentType.preview;\n\n      if (parentPreview.focusedButton() !== index) {\n        parentPreview.focusedButton(index);\n      }\n    }\n    /**\n     * If the button is displayed we need to show the options menu on hover\n     *\n     * @param {Preview} context\n     * @param {Event} event\n     */\n    ;\n\n    _proto.onButtonMouseOver = function onButtonMouseOver(context, event) {\n      if (this.display() === false) {\n        this.onMouseOver(context, event);\n      }\n    }\n    /**\n     * If the button is displayed we need to hide the options menu on mouse out\n     *\n     * @param {Preview} context\n     * @param {Event} event\n     */\n    ;\n\n    _proto.onButtonMouseOut = function onButtonMouseOut(context, event) {\n      if (this.display() === false) {\n        this.onMouseOut(context, event);\n      }\n    };\n\n    return Preview;\n  }(_preview);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/button-item/converter/style/display.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Display = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Display() {}\n\n    var _proto = Display.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return !(value === \"none\");\n    }\n    /**\n     * Convert value to knockout format, if buttons are displayed they should be inline block\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n\n      if (!_underscore.isUndefined(value) && value === false) {\n        return \"none\";\n      }\n\n      return \"inline-block\";\n    };\n\n    return Display;\n  }();\n\n  return Display;\n});\n//# sourceMappingURL=display.js.map","Magento_PageBuilder/js/content-type/text/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jquery\", \"Magento_PageBuilder/js/events\", \"underscore\", \"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/utils/delay-until\", \"Magento_PageBuilder/js/utils/editor\", \"Magento_PageBuilder/js/wysiwyg/factory\", \"Magento_PageBuilder/js/content-type/preview\"], function (_jquery, _events, _underscore, _hideShowOption, _delayUntil, _editor, _factory, _preview) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_preview2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _preview2);\n\n    function Preview() {\n      var _this;\n\n      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {\n        args[_key] = arguments[_key];\n      }\n\n      _this = _preview2.call.apply(_preview2, [this].concat(args)) || this;\n      _this.wysiwygDeferred = _jquery.Deferred();\n      _this.afterRenderDeferred = _jquery.Deferred();\n      _this.handledDoubleClick = false;\n      return _this;\n    }\n\n    var _proto = Preview.prototype;\n\n    /**\n     * @returns {Boolean}\n     */\n    _proto.isWysiwygSupported = function isWysiwygSupported() {\n      return (0, _editor.isWysiwygSupported)();\n    }\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n    ;\n\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _preview2.prototype.retrieveOptions.call(this);\n\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    }\n    /**\n     * @param {HTMLElement} element\n     */\n    ;\n\n    _proto.afterRenderWysiwyg = function afterRenderWysiwyg(element) {\n      var _this2 = this;\n\n      this.element = element;\n      element.id = this.contentType.id + \"-editor\"; // Set the innerHTML manually so we don't upset Knockout & TinyMCE\n\n      element.innerHTML = this.data.main.html();\n      this.contentType.dataStore.subscribe(function () {\n        // If we're not focused into TinyMCE inline, update the value when it changes in the data store\n        if (!_this2.wysiwyg || _this2.wysiwyg && _this2.wysiwyg.getAdapter().id !== (0, _editor.getActiveEditor)().id) {\n          element.innerHTML = _this2.data.main.html();\n        }\n      }, \"content\");\n      this.afterRenderDeferred.resolve(element);\n      /**\n       * afterRenderWysiwyg is called whenever Knockout causes a DOM re-render. This occurs frequently within Slider\n       * due to Slick's inability to perform a refresh with Knockout managing the DOM. Due to this the original\n       * WYSIWYG instance will be detached from this slide and we need to re-initialize on click.\n       */\n\n      this.wysiwyg = null;\n    }\n    /**\n     * Stop event to prevent execution of action when editing textarea.\n     *\n     * @param {Preview} preview\n     * @param {JQueryEventObject} event\n     * @returns {Boolean}\n     */\n    ;\n\n    _proto.stopEvent = function stopEvent(preview, event) {\n      event.stopPropagation();\n      return true;\n    }\n    /**\n     * Init WYSIWYG on load\n     *\n     * @param element\n     * @deprecated please use activateEditor & initWysiwygFromClick\n     */\n    ;\n\n    _proto.initWysiwyg = function initWysiwyg(element) {\n      this.element = element;\n      element.id = this.contentType.id + \"-editor\";\n      this.wysiwyg = null;\n      return this.initWysiwygFromClick(true);\n    }\n    /**\n     * Init the WYSIWYG\n     *\n     * @param {boolean} focus Should wysiwyg focus after initialization?\n     * @returns Promise\n     */\n    ;\n\n    _proto.initWysiwygFromClick = function initWysiwygFromClick(focus) {\n      var _this3 = this;\n\n      if (focus === void 0) {\n        focus = false;\n      }\n\n      if (this.wysiwyg) {\n        return Promise.resolve(this.wysiwyg);\n      }\n\n      var wysiwygConfig = this.config.additional_data.wysiwygConfig.wysiwygConfigData;\n      wysiwygConfig.adapter.settings.paste_as_text = true;\n\n      if (focus) {\n        wysiwygConfig.adapter.settings.auto_focus = this.element.id;\n\n        wysiwygConfig.adapter.settings.init_instance_callback = function () {\n          _underscore.defer(function () {\n            _this3.element.blur();\n\n            _this3.element.focus();\n          });\n        };\n      }\n\n      return (0, _factory)(this.contentType.id, this.element.id, this.config.name, wysiwygConfig, this.contentType.dataStore, \"content\", this.contentType.stageId).then(function (wysiwyg) {\n        _this3.wysiwyg = wysiwyg;\n        return wysiwyg;\n      });\n    }\n    /**\n     * Makes WYSIWYG active\n     *\n     * @param {Preview} preview\n     * @param {JQueryEventObject} event\n     * @returns {Boolean}\n     */\n    ;\n\n    _proto.activateEditor = function activateEditor(preview, event) {\n      var _this4 = this;\n\n      if (this.element && !this.wysiwyg) {\n        var bookmark = (0, _editor.createBookmark)(event);\n        (0, _editor.lockImageSize)(this.element);\n        this.element.removeAttribute(\"contenteditable\");\n\n        _underscore.defer(function () {\n          _this4.initWysiwygFromClick(true).then(function () {\n            return (0, _delayUntil)(function () {\n              // We no longer need to handle double click once it's initialized\n              _this4.handledDoubleClick = true;\n\n              _this4.wysiwygDeferred.resolve();\n\n              (0, _editor.moveToBookmark)(bookmark);\n              (0, _editor.unlockImageSize)(_this4.element);\n            }, function () {\n              return _this4.element.classList.contains(\"mce-edit-focus\");\n            }, 10);\n          }).catch(function (error) {\n            // If there's an error with init of WYSIWYG editor push into the console to aid support\n            console.error(error);\n          });\n        });\n      }\n    }\n    /**\n     * If a user double clicks prior to initializing TinyMCE, forward the event\n     *\n     * @param preview\n     * @param event\n     */\n    ;\n\n    _proto.handleDoubleClick = function handleDoubleClick(preview, event) {\n      var _this5 = this;\n\n      if (this.handledDoubleClick) {\n        return;\n      }\n\n      event.preventDefault();\n      var targetIndex = (0, _editor.findNodeIndex)(this.element, event.target.tagName, event.target);\n      this.handledDoubleClick = true;\n      this.wysiwygDeferred.then(function () {\n        var target = document.getElementById(event.target.id);\n\n        if (!target) {\n          target = (0, _editor.getNodeByIndex)(_this5.element, event.target.tagName, targetIndex);\n        }\n\n        if (target) {\n          target.dispatchEvent((0, _editor.createDoubleClickEvent)());\n        }\n      });\n    }\n    /**\n     * @param {HTMLTextAreaElement} element\n     */\n    ;\n\n    _proto.initTextarea = function initTextarea(element) {\n      var _this6 = this;\n\n      this.textarea = element; // set initial value of textarea based on data store\n\n      this.textarea.value = this.contentType.dataStore.get(\"content\");\n      this.adjustTextareaHeightBasedOnScrollHeight(); // Update content in our stage preview textarea after its slideout counterpart gets updated\n\n      _events.on(\"form:\" + this.contentType.id + \":saveAfter\", function () {\n        _this6.textarea.value = _this6.contentType.dataStore.get(\"content\");\n\n        _this6.adjustTextareaHeightBasedOnScrollHeight();\n      });\n    }\n    /**\n     * Save current value of textarea in data store\n     */\n    ;\n\n    _proto.onTextareaKeyUp = function onTextareaKeyUp() {\n      this.adjustTextareaHeightBasedOnScrollHeight();\n      this.contentType.dataStore.set(\"content\", this.textarea.value);\n    }\n    /**\n     * Start stage interaction on textarea blur\n     */\n    ;\n\n    _proto.onTextareaFocus = function onTextareaFocus() {\n      (0, _jquery)(this.textarea).closest(\".pagebuilder-content-type\").addClass(\"pagebuilder-toolbar-active\");\n\n      _events.trigger(\"stage:interactionStart\");\n    }\n    /**\n     * Stop stage interaction on textarea blur\n     */\n    ;\n\n    _proto.onTextareaBlur = function onTextareaBlur() {\n      (0, _jquery)(this.textarea).closest(\".pagebuilder-content-type\").removeClass(\"pagebuilder-toolbar-active\");\n\n      _events.trigger(\"stage:interactionStop\");\n    }\n    /**\n     * Retrieve the margin & padding & alignment styles for the placeholder\n     *\n     * @returns {any}\n     */\n    ;\n\n    _proto.getPlaceholderStyle = function getPlaceholderStyle() {\n      var keys = [\"marginBottom\", \"marginLeft\", \"marginRight\", \"marginTop\", \"paddingBottom\", \"paddingLeft\", \"paddingRight\", \"paddingTop\", \"textAlign\"];\n      return _underscore.pick(this.data.main.style(), function (style, key) {\n        return keys.indexOf(key) !== -1;\n      });\n    }\n    /**\n     * Bind events\n     */\n    ;\n\n    _proto.bindEvents = function bindEvents() {\n      var _this7 = this;\n\n      _preview2.prototype.bindEvents.call(this);\n\n      this.contentType.dataStore.subscribe(function (state) {\n        var sanitizedContent = (0, _editor.replaceDoubleQuoteWithSingleQuoteWithinVariableDirective)((0, _editor.escapeDoubleQuoteWithinWidgetDirective)(state.content));\n\n        if (sanitizedContent !== state.content) {\n          state.content = sanitizedContent;\n        }\n      }); // After drop of new content type open TinyMCE and focus\n\n      _events.on(\"text:dropAfter\", function (args) {\n        if (args.id === _this7.contentType.id) {\n          _this7.afterRenderDeferred.then(function () {\n            if (_this7.isWysiwygSupported()) {\n              _this7.initWysiwygFromClick(true);\n            }\n          });\n        }\n      });\n    }\n    /**\n     * Adjust textarea's height based on scrollHeight\n     */\n    ;\n\n    _proto.adjustTextareaHeightBasedOnScrollHeight = function adjustTextareaHeightBasedOnScrollHeight() {\n      this.textarea.style.height = \"\";\n      var scrollHeight = this.textarea.scrollHeight;\n      var minHeight = parseInt((0, _jquery)(this.textarea).css(\"min-height\"), 10);\n\n      if (scrollHeight === minHeight) {\n        // leave height at 'auto'\n        return;\n      }\n\n      (0, _jquery)(this.textarea).height(scrollHeight);\n    };\n\n    return Preview;\n  }(_preview);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/text/wysiwyg/tinymce4/component-initializer.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\", \"mage/adminhtml/wysiwyg/events\"], function (_jquery, _events) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var ComponentInitializer = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function ComponentInitializer() {}\n\n    var _proto = ComponentInitializer.prototype;\n\n    /**\n     * The editor element\n     */\n\n    /**\n     * The configuration of the wysiwyg content type\n     */\n\n    /**\n     * Initialize the instance\n     *\n     * @param {Wysiwyg} wysiwyg\n     */\n    _proto.initialize = function initialize(wysiwyg) {\n      this.$element = (0, _jquery)(\"#\" + wysiwyg.elementId);\n      this.config = wysiwyg.config;\n      var tinymce = wysiwyg.getAdapter();\n      tinymce.eventBus.attachEventHandler(_events.afterFocus, this.onFocus.bind(this));\n      tinymce.eventBus.attachEventHandler(_events.afterBlur, this.onBlur.bind(this));\n    }\n    /**\n     * Called when tinymce is focused\n     */\n    ;\n\n    _proto.onFocus = function onFocus() {\n      var _this = this;\n\n      // If there isn't enough room for a left-aligned toolbar, right align it\n      if ((0, _jquery)(window).width() < this.$element.offset().left + parseInt(this.config.adapter_config.minToolbarWidth, 10)) {\n        this.$element.addClass(\"_right-aligned-toolbar\");\n      } else {\n        this.$element.removeClass(\"_right-aligned-toolbar\");\n      }\n\n      _jquery.each(this.config.adapter_config.parentSelectorsToUnderlay, function (i, selector) {\n        _this.$element.closest(selector).css(\"z-index\", 100);\n      });\n    }\n    /**\n     * Called when tinymce is blurred\n     */\n    ;\n\n    _proto.onBlur = function onBlur() {\n      var _this2 = this;\n\n      _jquery.each(this.config.adapter_config.parentSelectorsToUnderlay, function (i, selector) {\n        _this2.$element.closest(selector).css(\"z-index\", \"\");\n      });\n    };\n\n    return ComponentInitializer;\n  }();\n\n  return ComponentInitializer;\n});\n//# sourceMappingURL=component-initializer.js.map","Magento_PageBuilder/js/content-type/text/wysiwyg/tinymce4/config-modifier.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var ConfigModifier = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function ConfigModifier() {}\n\n    var _proto = ConfigModifier.prototype;\n\n    /**\n     * Initialize the config\n     *\n     * @param {String} contentTypeId\n     * @param {Object} config\n     */\n    _proto.modify = function modify(contentTypeId, config) {\n      if (config.adapter_config.mode === \"inline\") {\n        config.adapter.settings.fixed_toolbar_container = \"#\" + contentTypeId + \" \" + config.adapter.settings.fixed_toolbar_container;\n      }\n    };\n\n    return ConfigModifier;\n  }();\n\n  return ConfigModifier;\n});\n//# sourceMappingURL=config-modifier.js.map","Magento_PageBuilder/js/content-type/banner/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jarallax\", \"jarallaxVideo\", \"jquery\", \"mage/translate\", \"Magento_PageBuilder/js/events\", \"mageUtils\", \"underscore\", \"vimeoWrapper\", \"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/uploader\", \"Magento_PageBuilder/js/utils/delay-until\", \"Magento_PageBuilder/js/utils/editor\", \"Magento_PageBuilder/js/utils/nesting-link-dialog\", \"Magento_PageBuilder/js/utils/nesting-widget-dialog\", \"Magento_PageBuilder/js/wysiwyg/factory\", \"Magento_PageBuilder/js/content-type/preview\"], function (_jarallax, _jarallaxVideo, _jquery, _translate, _events, _mageUtils, _underscore, _vimeoWrapper, _hideShowOption, _uploader, _delayUntil, _editor, _nestingLinkDialog, _nestingWidgetDialog, _factory, _preview) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_preview2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _preview2);\n\n    function Preview() {\n      var _this;\n\n      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {\n        args[_key] = arguments[_key];\n      }\n\n      _this = _preview2.call.apply(_preview2, [this].concat(args)) || this;\n      _this.buttonPlaceholder = (0, _translate)(\"Edit Button Text\");\n      _this.wysiwygDeferred = _jquery.Deferred();\n      _this.handledDoubleClick = false;\n      _this.videoUpdateProperties = [\"background_type\", \"video_fallback_image\", \"video_lazy_load\", \"video_loop\", \"video_play_only_visible\", \"video_source\"];\n      _this.bannerOverlaySelector = \".pagebuilder-overlay\";\n      _this.defaultOverlayZIndex = 2;\n      _this.activeEditorOverlayZIndex = 3;\n      _this.buildJarallax = _underscore.debounce(function () {\n        // Destroy all instances of the plugin prior\n        try {\n          jarallax(_this.wrapper, \"destroy\");\n        } catch (e) {// Failure of destroying is acceptable\n        }\n\n        if (_this.wrapper && _this.wrapper.dataset.backgroundType === \"video\" && _this.wrapper.dataset.videoSrc.length) {\n          _underscore.defer(function () {\n            // Build Parallax on elements with the correct class\n            jarallax(_this.wrapper, {\n              videoSrc: _this.wrapper.dataset.videoSrc,\n              imgSrc: _this.wrapper.dataset.videoFallbackSrc,\n              videoLoop: _this.contentType.dataStore.get(\"video_loop\") === \"true\",\n              speed: 1,\n              videoPlayOnlyVisible: _this.contentType.dataStore.get(\"video_play_only_visible\") === \"true\",\n              videoLazyLoading: _this.contentType.dataStore.get(\"video_lazy_load\") === \"true\"\n            }); // @ts-ignore\n\n            if (_this.wrapper.jarallax && _this.wrapper.jarallax.video) {\n              // @ts-ignore\n              _this.wrapper.jarallax.video.on(\"started\", function () {\n                // @ts-ignore\n                if (_this.wrapper.jarallax && _this.wrapper.jarallax.$video) {\n                  // @ts-ignore\n                  _this.wrapper.jarallax.$video.style.visibility = \"visible\";\n                }\n              });\n            }\n          });\n        }\n      }, 50);\n      return _this;\n    }\n\n    var _proto = Preview.prototype;\n\n    /**\n     * Get background image url base on the viewport.\n     *\n     * @returns {string}\n     */\n    _proto.getBackgroundImage = function getBackgroundImage() {\n      var mobileImage = this.contentType.dataStore.get(\"mobile_image\");\n      var desktopImage = this.contentType.dataStore.get(\"background_image\");\n      var backgroundImage = this.viewport() === \"mobile\" && mobileImage.length ? mobileImage : desktopImage;\n      return backgroundImage.length ? \"url(\\\"\" + backgroundImage[0].url + \"\\\")\" : \"none\";\n    }\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n    ;\n\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _preview2.prototype.retrieveOptions.call(this);\n\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    }\n    /**\n     * Get registry callback reference to uploader UI component\n     *\n     * @returns {Uploader}\n     */\n    ;\n\n    _proto.getUploader = function getUploader() {\n      var initialImageValue = this.contentType.dataStore.get(this.config.additional_data.uploaderConfig.dataScope, \"\"); // Create uploader\n\n      return new _uploader(\"imageuploader_\" + this.contentType.id, this.config.additional_data.uploaderConfig, this.contentType.id, this.contentType.dataStore, initialImageValue);\n    }\n    /**\n     * @param {HTMLElement} element\n     */\n    ;\n\n    _proto.afterRenderWysiwyg = function afterRenderWysiwyg(element) {\n      var _this2 = this;\n\n      this.element = element;\n      element.id = this.contentType.id + \"-editor\"; // Set the innerHTML manually so we don't upset Knockout & TinyMCE\n\n      element.innerHTML = this.data.content.html();\n      this.contentType.dataStore.subscribe(function () {\n        // If we're not focused into TinyMCE inline, update the value when it changes in the data store\n        if (!_this2.wysiwyg || _this2.wysiwyg && _this2.wysiwyg.getAdapter().id !== (0, _editor.getActiveEditor)().id) {\n          element.innerHTML = _this2.data.content.html();\n        }\n      }, \"message\");\n      /**\n       * afterRenderWysiwyg is called whenever Knockout causes a DOM re-render. This occurs frequently within Slider\n       * due to Slick's inability to perform a refresh with Knockout managing the DOM. Due to this the original\n       * WYSIWYG instance will be detached from this slide and we need to re-initialize on click.\n       */\n\n      this.wysiwyg = null;\n    }\n    /**\n     * Stop event to prevent execution of action when editing textarea.\n     *\n     * @param {Preview} preview\n     * @param {JQueryEventObject} event\n     * @returns {Boolean}\n     */\n    ;\n\n    _proto.stopEvent = function stopEvent(preview, event) {\n      event.stopPropagation();\n      return true;\n    }\n    /**\n     * Init WYSIWYG on load\n     *\n     * @param element\n     * @deprecated please use activateEditor & initWysiwygFromClick\n     */\n    ;\n\n    _proto.initWysiwyg = function initWysiwyg(element) {\n      this.element = element;\n      element.id = this.contentType.id + \"-editor\";\n      this.wysiwyg = null;\n      return this.initWysiwygFromClick(false);\n    }\n    /**\n     * Init the WYSIWYG\n     *\n     * @param {boolean} focus Should wysiwyg focus after initialization?\n     * @returns Promise\n     */\n    ;\n\n    _proto.initWysiwygFromClick = function initWysiwygFromClick(focus) {\n      var _this3 = this;\n\n      if (focus === void 0) {\n        focus = false;\n      }\n\n      if (this.wysiwyg) {\n        return Promise.resolve(this.wysiwyg);\n      }\n\n      var wysiwygConfig = this.config.additional_data.wysiwygConfig.wysiwygConfigData;\n\n      if (focus) {\n        wysiwygConfig.adapter.settings.auto_focus = this.element.id;\n\n        wysiwygConfig.adapter.settings.init_instance_callback = function (editor) {\n          editor.on(\"focus\", function () {\n            (0, _jquery)(_this3.element).parents(_this3.bannerOverlaySelector).zIndex(_this3.activeEditorOverlayZIndex);\n          });\n          editor.on(\"blur\", function () {\n            (0, _jquery)(_this3.element).parents(_this3.bannerOverlaySelector).zIndex(_this3.defaultOverlayZIndex);\n            (0, _nestingLinkDialog)(_this3.contentType.dataStore, _this3.wysiwyg, \"message\", \"link_url\");\n            (0, _nestingWidgetDialog)(_this3.contentType.dataStore, _this3.wysiwyg, \"message\", \"link_url\");\n          });\n\n          _underscore.defer(function () {\n            _this3.element.blur();\n\n            _this3.element.focus();\n          });\n        };\n      }\n\n      wysiwygConfig.adapter.settings.fixed_toolbar_container = \"#\" + this.contentType.id + \" .pagebuilder-banner-text-content\";\n      return (0, _factory)(this.contentType.id, this.element.id, this.config.name, wysiwygConfig, this.contentType.dataStore, \"message\", this.contentType.stageId).then(function (wysiwyg) {\n        _this3.wysiwyg = wysiwyg;\n        return wysiwyg;\n      });\n    }\n    /**\n     * Makes WYSIWYG active\n     *\n     * @param {Preview} preview\n     * @param {JQueryEventObject} event\n     * @returns {Boolean}\n     */\n    ;\n\n    _proto.activateEditor = function activateEditor(preview, event) {\n      var _this4 = this;\n\n      if (this.element && !this.wysiwyg) {\n        var bookmark = (0, _editor.createBookmark)(event);\n        (0, _editor.lockImageSize)(this.element);\n        this.element.removeAttribute(\"contenteditable\");\n\n        _underscore.defer(function () {\n          _this4.initWysiwygFromClick(true).then(function () {\n            return (0, _delayUntil)(function () {\n              // We no longer need to handle double click once it's initialized\n              _this4.handledDoubleClick = true;\n\n              _this4.wysiwygDeferred.resolve();\n\n              (0, _editor.moveToBookmark)(bookmark);\n              (0, _editor.unlockImageSize)(_this4.element);\n            }, function () {\n              return _this4.element.classList.contains(\"mce-edit-focus\");\n            }, 10);\n          }).catch(function (error) {\n            // If there's an error with init of WYSIWYG editor push into the console to aid support\n            console.error(error);\n          });\n        });\n      } else if (this.element && this.wysiwyg) {\n        var element = this.element || this.textarea;\n\n        if (event.currentTarget !== event.target && event.target !== element && !element.contains(event.target)) {\n          return;\n        }\n\n        element.focus();\n      }\n    }\n    /**\n     * If a user double clicks prior to initializing TinyMCE, forward the event\n     *\n     * @param preview\n     * @param event\n     */\n    ;\n\n    _proto.handleDoubleClick = function handleDoubleClick(preview, event) {\n      var _this5 = this;\n\n      if (this.handledDoubleClick) {\n        return;\n      }\n\n      event.preventDefault();\n      var targetIndex = (0, _editor.findNodeIndex)(this.element, event.target.tagName, event.target);\n      this.handledDoubleClick = true;\n      this.wysiwygDeferred.then(function () {\n        var target = document.getElementById(event.target.id);\n\n        if (!target) {\n          target = (0, _editor.getNodeByIndex)(_this5.element, event.target.tagName, targetIndex);\n        }\n\n        if (target) {\n          target.dispatchEvent((0, _editor.createDoubleClickEvent)());\n        }\n      });\n    }\n    /**\n     * Set state based on overlay mouseover event for the preview\n     */\n    ;\n\n    _proto.onMouseOverWrapper = function onMouseOverWrapper() {\n      if (this.data.main.attributes()[\"data-show-overlay\"] === \"hover\") {\n        this.data.overlay.attributes(Object.assign(this.data.overlay.attributes(), {\n          \"data-background-color-orig\": this.data.overlay.style().backgroundColor\n        }));\n        this.data.overlay.style(Object.assign(this.data.overlay.style(), {\n          backgroundColor: this.data.overlay.attributes()[\"data-overlay-color\"]\n        }));\n      }\n\n      if (this.data.main.attributes()[\"data-show-button\"] === \"hover\") {\n        this.data.button.style(Object.assign(this.data.button.style(), {\n          opacity: 1,\n          visibility: \"visible\"\n        }));\n      }\n    }\n    /**\n     * Set state based on overlay mouseout event for the preview\n     */\n    ;\n\n    _proto.onMouseOutWrapper = function onMouseOutWrapper() {\n      if (this.data.main.attributes()[\"data-show-overlay\"] === \"hover\") {\n        this.data.overlay.style(Object.assign(this.data.overlay.style(), {\n          backgroundColor: this.data.overlay.attributes()[\"data-background-color-orig\"]\n        }));\n      }\n\n      if (this.data.main.attributes()[\"data-show-button\"] === \"hover\") {\n        this.data.button.style(Object.assign(this.data.button.style(), {\n          opacity: 0,\n          visibility: \"hidden\"\n        }));\n      }\n    }\n    /**\n     * @returns {Boolean}\n     */\n    ;\n\n    _proto.isWysiwygSupported = function isWysiwygSupported() {\n      return (0, _editor.isWysiwygSupported)();\n    }\n    /**\n     * @param {HTMLTextAreaElement} element\n     */\n    ;\n\n    _proto.initTextarea = function initTextarea(element) {\n      var _this6 = this;\n\n      this.textarea = element; // set initial value of textarea based on data store\n\n      this.textarea.value = this.contentType.dataStore.get(\"message\");\n      this.adjustTextareaHeightBasedOnScrollHeight(); // Update content in our stage preview textarea after its slideout counterpart gets updated\n\n      _events.on(\"form:\" + this.contentType.id + \":saveAfter\", function () {\n        _this6.textarea.value = _this6.contentType.dataStore.get(\"message\");\n\n        _this6.adjustTextareaHeightBasedOnScrollHeight();\n      });\n    }\n    /**\n     * Save current value of textarea in data store\n     */\n    ;\n\n    _proto.onTextareaKeyUp = function onTextareaKeyUp() {\n      this.adjustTextareaHeightBasedOnScrollHeight();\n      this.contentType.dataStore.set(\"message\", this.textarea.value);\n    }\n    /**\n     * Start stage interaction on textarea blur\n     */\n    ;\n\n    _proto.onTextareaFocus = function onTextareaFocus() {\n      (0, _jquery)(this.textarea).closest(\".pagebuilder-banner-text-content\").addClass(\"pagebuilder-toolbar-active\");\n\n      _events.trigger(\"stage:interactionStart\");\n    }\n    /**\n     * Stop stage interaction on textarea blur\n     */\n    ;\n\n    _proto.onTextareaBlur = function onTextareaBlur() {\n      (0, _jquery)(this.textarea).closest(\".pagebuilder-banner-text-content\").removeClass(\"pagebuilder-toolbar-active\");\n\n      _events.trigger(\"stage:interactionStop\");\n    }\n    /**\n     * Init the parallax element\n     *\n     * @param {HTMLElement} element\n     */\n    ;\n\n    _proto.initParallax = function initParallax(element) {\n      var _this7 = this;\n\n      this.wrapper = element;\n\n      _underscore.defer(function () {\n        _this7.buildJarallax();\n      });\n    }\n    /**\n     * Destroy jarallax instance.\n     */\n    ;\n\n    _proto.destroy = function destroy() {\n      _preview2.prototype.destroy.call(this);\n\n      if (this.wrapper) {\n        jarallax(this.wrapper, \"destroy\");\n      }\n    }\n    /**\n     * @inheritDoc\n     */\n    ;\n\n    _proto.bindEvents = function bindEvents() {\n      var _this8 = this;\n\n      _preview2.prototype.bindEvents.call(this);\n\n      _events.on(\"banner:mountAfter\", function (args) {\n        if (args.id === _this8.contentType.id) {\n          _this8.buildJarallax();\n\n          _this8.isSnapshot.subscribe(function (value) {\n            _this8.changeUploaderControlsVisibility();\n          });\n\n          _this8.changeUploaderControlsVisibility();\n        }\n      });\n\n      _events.on(this.config.name + \":\" + this.contentType.id + \":updateAfter\", function () {\n        var dataStore = _this8.contentType.dataStore.getState();\n\n        var imageObject = dataStore[_this8.config.additional_data.uploaderConfig.dataScope][0] || {}; // Resolves issue when tinyMCE injects a non-breaking space on reinitialization and removes placeholder.\n\n        if (dataStore.message === \"<div data-bind=\\\"html: data.content.html\\\">&nbsp;</div>\") {\n          _this8.contentType.dataStore.set(\"message\", \"\");\n        }\n\n        _events.trigger(\"image:\" + _this8.contentType.id + \":assignAfter\", imageObject);\n      });\n\n      this.contentType.dataStore.subscribe(function (data) {\n        if (this.shouldUpdateVideo(data)) {\n          this.buildJarallax();\n        }\n      }.bind(this));\n\n      _events.on(\"image:\" + this.contentType.id + \":uploadAfter\", function () {\n        _this8.contentType.dataStore.set(\"background_type\", \"image\");\n      });\n\n      _events.on(\"stage:\" + this.contentType.stageId + \":viewportChangeAfter\", function (args) {\n        _this8.buildJarallax();\n      });\n    }\n    /**\n     * Change uploader controls visibility\n     */\n    ;\n\n    _proto.changeUploaderControlsVisibility = function changeUploaderControlsVisibility() {\n      var _this9 = this;\n\n      this.getUploader().getUiComponent()(function (uploader) {\n        uploader.visibleControls = !_this9.isSnapshot();\n      });\n    }\n    /**\n     * Adjust textarea's height based on scrollHeight\n     */\n    ;\n\n    _proto.adjustTextareaHeightBasedOnScrollHeight = function adjustTextareaHeightBasedOnScrollHeight() {\n      this.textarea.style.height = \"\";\n      var scrollHeight = this.textarea.scrollHeight;\n      var minHeight = parseInt((0, _jquery)(this.textarea).css(\"min-height\"), 10);\n\n      if (scrollHeight === minHeight) {\n        // leave height at 'auto'\n        return;\n      }\n\n      (0, _jquery)(this.textarea).height(scrollHeight);\n    }\n    /**\n     * Check if video options has been updated.\n     *\n     * @return boolean\n     */\n    ;\n\n    _proto.shouldUpdateVideo = function shouldUpdateVideo(state) {\n      var _this10 = this;\n\n      var previousState = this.contentType.dataStore.getPreviousState();\n\n      var diff = _mageUtils.compare(previousState, state).changes;\n\n      if (diff.length > 0) {\n        return _underscore.some(diff, function (element) {\n          if (element.name === \"video_fallback_image\") {\n            return (!_underscore.isEmpty(previousState.video_fallback_image) && previousState.video_fallback_image) !== (!_underscore.isEmpty(state.video_fallback_image) && state.video_fallback_image);\n          }\n\n          return _this10.videoUpdateProperties.indexOf(element.name) !== -1;\n        });\n      }\n    };\n\n    return Preview;\n  }(_preview);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/banner/converter/attribute/overlay-color.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var OverlayColor = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function OverlayColor() {}\n\n    var _proto = OverlayColor.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value === \"transparent\" ? \"\" : value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      if (data.overlay_color) {\n        return data.overlay_color.toString();\n      }\n\n      return \"\";\n    };\n\n    return OverlayColor;\n  }();\n\n  return OverlayColor;\n});\n//# sourceMappingURL=overlay-color.js.map","Magento_PageBuilder/js/content-type/banner/converter/style/overlay-background-color.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var OverlayBackgroundColor = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function OverlayBackgroundColor() {}\n\n    var _proto = OverlayBackgroundColor.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n\n      if (data.show_overlay === \"always\" && value !== \"\" && value !== undefined) {\n        return value;\n      }\n\n      return \"transparent\";\n    };\n\n    return OverlayBackgroundColor;\n  }();\n\n  return OverlayBackgroundColor;\n});\n//# sourceMappingURL=overlay-background-color.js.map","Magento_PageBuilder/js/content-type/banner/converter/style/button-opacity.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var ButtonOpacity = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function ButtonOpacity() {}\n\n    var _proto = ButtonOpacity.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      return data.show_button === \"always\" ? \"1\" : \"0\";\n    };\n\n    return ButtonOpacity;\n  }();\n\n  return ButtonOpacity;\n});\n//# sourceMappingURL=button-opacity.js.map","Magento_PageBuilder/js/content-type/banner/converter/style/button-visibility.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var ButtonVisibility = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function ButtonVisibility() {}\n\n    var _proto = ButtonVisibility.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      return data.show_button === \"always\" ? \"visible\" : \"hidden\";\n    };\n\n    return ButtonVisibility;\n  }();\n\n  return ButtonVisibility;\n});\n//# sourceMappingURL=button-visibility.js.map","Magento_PageBuilder/js/content-type/banner/appearance/default/widget.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_PageBuilder/js/widget/show-on-hover',\n    'Magento_PageBuilder/js/widget/video-background'\n], function (showOnHover, videoBackground) {\n    'use strict';\n\n    return function (config, element) {\n        var videoElement = element[0].querySelector('[data-background-type=video]');\n\n        showOnHover(config);\n\n        if (videoElement) {\n            videoBackground(config, videoElement);\n        }\n    };\n});\n","Magento_PageBuilder/js/content-type/banner/wysiwyg/tinymce4/component-initializer.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\", \"mage/adminhtml/wysiwyg/events\"], function (_jquery, _events) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var ComponentInitializer = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function ComponentInitializer() {}\n\n    var _proto = ComponentInitializer.prototype;\n\n    /**\n     * The editor element\n     */\n\n    /**\n     * The configuration of the wysiwyg content type\n     */\n\n    /**\n     * Initialize the instance\n     *\n     * @param {Wysiwyg} wysiwyg\n     */\n    _proto.initialize = function initialize(wysiwyg) {\n      this.$element = (0, _jquery)(\"#\" + wysiwyg.elementId);\n      this.config = wysiwyg.config;\n      var tinymce = wysiwyg.getAdapter();\n      tinymce.eventBus.attachEventHandler(_events.afterFocus, this.onFocus.bind(this));\n      tinymce.eventBus.attachEventHandler(_events.afterBlur, this.onBlur.bind(this));\n    }\n    /**\n     * Called when tinymce is focused\n     */\n    ;\n\n    _proto.onFocus = function onFocus() {\n      var _this = this;\n\n      // If there isn't enough room for a left-aligned toolbar, right align it\n      if ((0, _jquery)(window).width() < this.$element.offset().left + parseInt(this.config.adapter_config.minToolbarWidth, 10)) {\n        this.$element.addClass(\"_right-aligned-toolbar\");\n      } else {\n        this.$element.removeClass(\"_right-aligned-toolbar\");\n      }\n\n      _jquery.each(this.config.adapter_config.parentSelectorsToUnderlay, function (i, selector) {\n        _this.$element.closest(selector).css(\"z-index\", 100);\n      });\n    }\n    /**\n     * Called when tinymce is blurred\n     */\n    ;\n\n    _proto.onBlur = function onBlur() {\n      var _this2 = this;\n\n      _jquery.each(this.config.adapter_config.parentSelectorsToUnderlay, function (i, selector) {\n        _this2.$element.closest(selector).css(\"z-index\", \"\");\n      });\n    };\n\n    return ComponentInitializer;\n  }();\n\n  return ComponentInitializer;\n});\n//# sourceMappingURL=component-initializer.js.map","Magento_PageBuilder/js/content-type/block/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jquery\", \"knockout\", \"mage/translate\", \"Magento_PageBuilder/js/widget-initializer\", \"mageUtils\", \"underscore\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/content-type/style-registry\", \"Magento_PageBuilder/js/utils/object\", \"Magento_PageBuilder/js/content-type/preview\"], function (_jquery, _knockout, _translate, _widgetInitializer, _mageUtils, _underscore, _config, _hideShowOption, _styleRegistry, _object, _preview) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_preview2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _preview2);\n\n    /**\n     * @inheritdoc\n     */\n    function Preview(contentType, config, observableUpdater) {\n      var _this;\n\n      _this = _preview2.call(this, contentType, config, observableUpdater) || this;\n      _this.displayingBlockPreview = _knockout.observable(false);\n      _this.loading = _knockout.observable(false);\n      _this.messages = {\n        NOT_SELECTED: (0, _translate)(\"Empty Block\"),\n        UNKNOWN_ERROR: (0, _translate)(\"An unknown error occurred. Please try again.\")\n      };\n      _this.placeholderText = _knockout.observable(_this.messages.NOT_SELECTED);\n      return _this;\n    }\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n\n\n    var _proto = Preview.prototype;\n\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _preview2.prototype.retrieveOptions.call(this);\n\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    }\n    /**\n     * Runs the widget initializer for each configured widget\n     */\n    ;\n\n    _proto.initializeWidgets = function initializeWidgets(element) {\n      if (element) {\n        this.element = element;\n        (0, _widgetInitializer)({\n          config: _config.getConfig(\"widgets\"),\n          breakpoints: _config.getConfig(\"breakpoints\"),\n          currentViewport: _config.getConfig(\"viewport\")\n        }, element);\n      }\n    }\n    /**\n     * Updates the view state using the data provided\n     * @param {DataObject} data\n     */\n    ;\n\n    _proto.processBlockData = function processBlockData(data) {\n      // Only load if something changed\n      this.displayPreviewPlaceholder(data, \"block_id\");\n\n      if (data.block_id && data.template.length !== 0) {\n        this.processRequest(data, \"block_id\", \"title\");\n      }\n    }\n    /**\n     * @inheritdoc\n     */\n    ;\n\n    _proto.afterObservablesUpdated = function afterObservablesUpdated() {\n      _preview2.prototype.afterObservablesUpdated.call(this);\n\n      var data = this.contentType.dataStore.getState(); // Only load if something changed\n\n      this.processBlockData(data);\n    }\n    /**\n     * Display preview placeholder\n     *\n     * @param {DataObject} data\n     * @param {string} identifierName\n     */\n    ;\n\n    _proto.displayPreviewPlaceholder = function displayPreviewPlaceholder(data, identifierName) {\n      var blockId = (0, _object.get)(data, identifierName); // Only load if something changed\n\n      if (this.lastBlockId === blockId && this.lastTemplate === data.template) {\n        // The mass converter will have transformed the HTML property into a directive\n        if (this.lastRenderedHtml) {\n          this.data.main.html(this.lastRenderedHtml);\n          this.showBlockPreview(true);\n          this.initializeWidgets(this.element);\n        }\n      } else {\n        this.showBlockPreview(false);\n        this.placeholderText(\"\");\n      }\n\n      if (!blockId || blockId && blockId.toString().length === 0 || data.template.length === 0) {\n        this.showBlockPreview(false);\n        this.placeholderText(this.messages.NOT_SELECTED);\n        return;\n      }\n    }\n    /**\n     *\n     * @param {DataObject} data\n     * @param {string} identifierName\n     * @param {string} labelKey\n     */\n    ;\n\n    _proto.processRequest = function processRequest(data, identifierName, labelKey) {\n      var _this2 = this;\n\n      var url = _config.getConfig(\"preview_url\");\n\n      var identifier = (0, _object.get)(data, identifierName);\n      var requestConfig = {\n        // Prevent caching\n        method: \"POST\",\n        data: {\n          role: this.config.name,\n          block_id: identifier,\n          directive: this.data.main.html()\n        }\n      };\n      this.loading(true); // Retrieve a state object representing the block from the preview controller and process it on the stage\n\n      _jquery.ajax(url, requestConfig) // The state object will contain the block name and either html or a message why there isn't any.\n      .done(function (response) {\n        // Empty content means something bad happened in the controller that didn't trigger a 5xx\n        if (typeof response.data !== \"object\") {\n          _this2.showBlockPreview(false);\n\n          _this2.placeholderText(_this2.messages.UNKNOWN_ERROR);\n\n          return;\n        } // Update the stage content type label with the real block title if provided\n\n\n        _this2.displayLabel(response.data[labelKey] ? response.data[labelKey] : _this2.config.label);\n\n        var content = \"\";\n\n        if (response.data.content) {\n          _this2.showBlockPreview(true);\n\n          content = _this2.processContent(response.data.content);\n\n          _this2.data.main.html(content);\n\n          _this2.initializeWidgets(_this2.element);\n        } else if (response.data.error) {\n          _this2.showBlockPreview(false);\n\n          _this2.placeholderText(response.data.error);\n        }\n\n        _this2.lastBlockId = parseInt(identifier.toString(), 10);\n        _this2.lastTemplate = data.template.toString();\n        _this2.lastRenderedHtml = content;\n      }).fail(function () {\n        _this2.showBlockPreview(false);\n\n        _this2.placeholderText(_this2.messages.UNKNOWN_ERROR);\n      }).always(function () {\n        _this2.loading(false);\n      });\n    }\n    /**\n     * Toggle display of block preview.  If showing block preview, add hidden mode to PB preview.\n     * @param {boolean} isShow\n     */\n    ;\n\n    _proto.showBlockPreview = function showBlockPreview(isShow) {\n      this.displayingBlockPreview(isShow);\n    }\n    /**\n     * Adapt content to view it on stage.\n     *\n     * @param content\n     */\n    ;\n\n    _proto.processContent = function processContent(content) {\n      var processedContent = this.processBackgroundImages(content);\n      processedContent = this.processBreakpointStyles(processedContent);\n      return processedContent;\n    }\n    /**\n     * Generate styles for background images.\n     *\n     * @param {string} content\n     * @return string\n     */\n    ;\n\n    _proto.processBackgroundImages = function processBackgroundImages(content) {\n      var document = new DOMParser().parseFromString(content, \"text/html\");\n      var elements = document.querySelectorAll(\"[data-background-images]\");\n      var styleBlock = document.createElement(\"style\");\n\n      var viewports = _config.getConfig(\"viewports\");\n\n      elements.forEach(function (element) {\n        var rawAttrValue = element.getAttribute(\"data-background-images\").replace(/\\\\(.)/mg, \"$1\");\n        var attrValue = JSON.parse(rawAttrValue);\n\n        var elementClass = \"background-image-\" + _mageUtils.uniqueid(13);\n\n        var rules = \"\";\n        Object.keys(attrValue).forEach(function (imageName) {\n          var imageUrl = attrValue[imageName];\n          var viewportName = imageName.replace(\"_image\", \"\");\n\n          if (viewports[viewportName].stage && imageUrl) {\n            rules += \".\" + viewportName + \"-viewport .\" + elementClass + \" {\\n                            background-image: url(\\\"\" + imageUrl + \"\\\");\\n                        }\";\n          }\n        });\n\n        if (rules.length) {\n          styleBlock.append(rules);\n          element.classList.add(elementClass);\n        }\n      });\n\n      if (elements.length && styleBlock.innerText.length) {\n        document.body.append(styleBlock);\n        content = document.head.innerHTML + document.body.innerHTML;\n      }\n\n      return content;\n    }\n    /**\n     * Replace media queries with viewport classes.\n     *\n     * @param {string} content\n     * @return string\n     */\n    ;\n\n    _proto.processBreakpointStyles = function processBreakpointStyles(content) {\n      var document = new DOMParser().parseFromString(content, \"text/html\");\n      var styleBlocks = document.querySelectorAll(\"style\");\n      var mediaStyleBlock = document.createElement(\"style\");\n\n      var viewports = _config.getConfig(\"viewports\");\n\n      styleBlocks.forEach(function (styleBlock) {\n        var cssRules = styleBlock.sheet.cssRules;\n        Array.from(cssRules).forEach(function (rule) {\n          var mediaScope = rule instanceof CSSMediaRule && _underscore.findKey(viewports, function (viewport) {\n            return rule.conditionText === viewport.media;\n          });\n\n          if (mediaScope) {\n            Array.from(rule.cssRules).forEach(function (mediaRule, index) {\n              if (mediaRule.selectorText.indexOf(_styleRegistry.pbStyleAttribute) !== -1) {\n                var searchPattern = new RegExp(_config.getConfig(\"bodyId\") + \" \", \"g\");\n                var replaceValue = _config.getConfig(\"bodyId\") + \" .\" + mediaScope + \"-viewport \";\n                var selector = mediaRule.selectorText.replace(searchPattern, replaceValue);\n                mediaStyleBlock.append(selector + \" {\" + mediaRule.style.cssText + \"}\");\n              }\n            });\n          }\n        });\n      });\n\n      if (mediaStyleBlock.innerText.length) {\n        document.body.append(mediaStyleBlock);\n        content = document.head.innerHTML + document.body.innerHTML;\n      }\n\n      return content;\n    };\n\n    return Preview;\n  }(_preview);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/block/mass-converter/widget-directive.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"Magento_PageBuilder/js/mass-converter/widget-directive-abstract\", \"Magento_PageBuilder/js/utils/object\"], function (_widgetDirectiveAbstract, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Enables the settings of the content type to be stored as a widget directive.\n   *\n   * @api\n   */\n  var WidgetDirective = /*#__PURE__*/function (_widgetDirectiveAbstr) {\n    \"use strict\";\n\n    _inheritsLoose(WidgetDirective, _widgetDirectiveAbstr);\n\n    function WidgetDirective() {\n      return _widgetDirectiveAbstr.apply(this, arguments) || this;\n    }\n\n    var _proto = WidgetDirective.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param {object} data\n     * @param {object} config\n     * @returns {object}\n     */\n    _proto.fromDom = function fromDom(data, config) {\n      var attributes = _widgetDirectiveAbstr.prototype.fromDom.call(this, data, config);\n\n      data.template = attributes.template;\n      data.block_id = attributes.block_id;\n      return data;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {object} data\n     * @param {object} config\n     * @returns {object}\n     */\n    ;\n\n    _proto.toDom = function toDom(data, config) {\n      var attributes = {\n        type: \"Magento\\\\Cms\\\\Block\\\\Widget\\\\Block\",\n        template: data.template,\n        block_id: data.block_id,\n        type_name: \"CMS Static Block\"\n      };\n\n      if (!attributes.block_id || !attributes.template) {\n        return data;\n      }\n\n      (0, _object.set)(data, config.html_variable, this.buildDirective(attributes));\n      return data;\n    };\n\n    return WidgetDirective;\n  }(_widgetDirectiveAbstract);\n\n  return WidgetDirective;\n});\n//# sourceMappingURL=widget-directive.js.map","Magento_PageBuilder/js/form/provider.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/provider',\n    'Magento_PageBuilder/js/events'\n], function (Provider, events) {\n    'use strict';\n\n    return Provider.extend({\n        /** @inheritdoc **/\n        initClient: function () {\n            return this;\n        },\n\n        /** @inheritdoc **/\n        save: function () {\n            events.trigger('form:' + this.id + ':saveAfter', this.get('data'));\n\n            return this;\n        }\n    });\n});\n","Magento_PageBuilder/js/form/map-location-provider.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/provider',\n    'Magento_PageBuilder/js/events'\n], function (Provider, events) {\n    'use strict';\n\n    return Provider.extend({\n        /** @inheritdoc **/\n        initClient: function () {\n            return this;\n        },\n\n        /** @inheritdoc **/\n        save: function () {\n            events.trigger('mapLocation:saveAfter', this.get('data'));\n\n            return this;\n        }\n    });\n});\n","Magento_PageBuilder/js/form/form-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'jquery',\n    'Magento_PageBuilder/js/events',\n    'consoleLogger'\n], function (_, $, events, consoleLogger) {\n    'use strict';\n\n    var mixin = {\n        defaults: {\n            pageBuilderInstances: []\n        },\n\n        /**\n         * Record instances of Page Builder initialized in the forms namespace\n         */\n        initialize: function () {\n            var self = this;\n\n            this._super();\n\n            events.on('pagebuilder:register', function (data) {\n                if (data.ns === self.ns) {\n                    self.pageBuilderInstances.push(data.instance);\n                }\n            });\n\n            return this;\n        },\n\n        /**\n         * Intercept save call to ensure any Page Builder rendering is completed before submitting form\n         *\n         * @param {String} redirect\n         * @param {Object} data\n         */\n        save: function (redirect, data) {\n            var submit = this._super.bind(this, redirect, data),\n                timeout,\n                locks;\n\n            if (_.isEmpty(this.pageBuilderInstances)) {\n                submit();\n            } else {\n                timeout = setTimeout(function () {\n                    consoleLogger.error('Page Builder was rendering for 5 seconds without releasing locks.');\n                }, 5000);\n\n                $('body').trigger('processStart');\n\n                // Wait for all rendering locks within Page Builder stages to resolve\n                $.when.apply(\n                    null,\n                    this.pageBuilderInstances.map(function (instance) {\n                        locks = instance.stage.renderingLocks;\n\n                        return locks[locks.length - 1];\n                    })\n                ).then(function () {\n                    $('body').trigger('processStop');\n                    clearTimeout(timeout);\n                    submit();\n                });\n            }\n        }\n    };\n\n    return function (target) {\n        return target.extend(mixin);\n    };\n});\n","Magento_PageBuilder/js/form/element/html.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/html',\n    'jquery',\n    'underscore'\n], function (Html, $, _) {\n    'use strict';\n\n    return Html.extend({\n        defaults: {\n            inputSelector: '[data-form-part=${ $.ns }]',\n            elements: [],\n            value: {}\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            this.initInputListener();\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            return this._super()\n                .observe('value');\n        },\n\n        /**\n         * Listen for value change on each field that has been added.\n         */\n        initInputListener: function () {\n            $.async({\n                component: this,\n                selector: this.inputSelector\n            }, function (el) {\n                this.elements.push(el);\n                $(el).on('change', this.updateValue.bind(this));\n                $(el).nextAll('.rule-param-apply').on('click', function () {\n                    $(el).change();\n                });\n                $(el).closest('li').find('.rule-param-remove').on('click', function () {\n                    $(el).val('').change();\n                });\n                this.updateValue(this);\n            }.bind(this));\n        },\n\n        /**\n         * Collect data and update value.\n         */\n        updateValue: function () {\n            var result = {},\n                name;\n\n            this.elements.forEach(function (item) {\n                switch (item.type) {\n                    case 'checkbox':\n                        result[item.name] = +!!item.checked;\n                        break;\n\n                    case 'radio':\n                        if (item.checked) {\n                            result[item.name] = item.value;\n                        }\n                        break;\n\n                    case 'select-multiple':\n                        name = item.name.substring(0, item.name.length - 2); //remove [] from the name ending\n                        result[name] = _.pluck(item.selectedOptions, 'value');\n                        break;\n\n                    default:\n                        result[item.name] = item.value;\n                }\n            });\n\n            this.value(result);\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/product-totals.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'jquery',\n    'mage/translate',\n    'Magento_PageBuilder/js/form/provider/conditions-data-processor',\n    'Magento_Ui/js/form/element/abstract'\n], function (_, $, $t, conditionsDataProcessor, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            conditionOption: '',\n            conditionValue: '',\n            formData: {},\n            totalProductCount: 0,\n            totalDisabledProducts: 0,\n            totalNotVisibleProducts: 0,\n            previousConditions: false,\n            listens: {\n                conditionOption: 'updateProductTotals',\n                conditionValue: 'updateProductTotals',\n                '${ $.provider }:data.modalClosed': 'abortRunningRequest'\n            },\n            imports: {\n                formData: '${ $.provider }:data'\n            },\n            links: {\n                value: false\n            },\n            url: null,\n            valuePlaceholder: $t('of %1 total'),\n            disabledPlaceholder: $t('%1 disabled'),\n            notVisiblePlaceholder: $t('%1 not visible'),\n            showSpinner: true,\n            loading: false,\n            jqXHR: null\n        },\n\n        /**\n         * Abort running Ajax request\n         */\n        abortRunningRequest: function () {\n            if (this.jqXHR && this.jqXHR.readyState !== 4) {\n                this.jqXHR.abort();\n            }\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            return this._super()\n                .observe('value totalProductCount totalDisabledProducts totalNotVisibleProducts loading');\n        },\n\n        /**\n         * If we haven't aborted the request, continue and display the error\n         *\n         * @param {Object} jqXHR\n         */\n        callSuperError: function (jqXHR) {\n            var superError = $.ajaxSettings.error.bind(window, jqXHR);\n\n            superError();\n        },\n\n        /**\n         * Update product count.\n         */\n        updateProductTotals: _.debounce(function () {\n            var totalText,\n                negativeTotals = [];\n\n            if (!this.conditionOption || _.isEmpty(this.formData)) {\n                return;\n            }\n\n            if (this.conditionOption === 'category_ids' && typeof this.formData['category_ids'] !== 'string') {\n                this.formData['category_ids'] = '';\n            }\n\n            _.extend(this.formData, this.conditionValue);\n            conditionsDataProcessor(this.formData, this.conditionOption + '_source');\n\n            // Store the previous conditions so we don't update the totals when nothing has changed\n            if (this.previousConditions === this.formData['conditions_encoded']) {\n                return;\n            }\n            this.previousConditions = this.formData['conditions_encoded'];\n\n            this.loading(true);\n            this.abortRunningRequest();\n            this.jqXHR = $.ajax({\n                url: this.url,\n                method: 'POST',\n                data: {\n                    conditionValue: this.formData['conditions_encoded']\n                },\n                error: function (jqXHR) {\n                    if (jqXHR.statusText !== 'abort') {\n                        this.callSuperError(jqXHR);\n                    }\n                }.bind(this)\n            }).done(function (response) {\n                this.totalProductCount(parseInt(response.total, 10));\n                this.totalDisabledProducts(parseInt(response.disabled, 10));\n                this.totalNotVisibleProducts(parseInt(response.notVisible, 10));\n                totalText = this.valuePlaceholder\n                    .replace('%1', parseInt(response.total, 10));\n\n                if (parseInt(response.disabled, 10) > 0) {\n                    negativeTotals.push(this.disabledPlaceholder.replace('%1', parseInt(response.disabled, 10)));\n                }\n\n                if (parseInt(response.notVisible, 10) > 0) {\n                    negativeTotals.push(this.notVisiblePlaceholder.replace('%1', parseInt(response.notVisible, 10)));\n                }\n\n                if (negativeTotals.length > 0) {\n                    totalText += ' (' + negativeTotals.join(', ') + ')';\n                }\n\n                this.value(totalText);\n                this.loading(false);\n            }.bind(this)).fail(function () {\n                if (this.jqXHR.statusText !== 'abort') {\n                    this.value($t('An unknown error occurred. Please try again.'));\n                }\n                this.loading(false);\n            }.bind(this));\n        }, 10)\n    });\n});\n","Magento_PageBuilder/js/form/element/condition-options.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_PageBuilder/js/form/element/visual-select'\n], function (Select) {\n    'use strict';\n\n    return Select.extend({\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n\n            this.showRelatedElement(this.value());\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super();\n\n            this.options().forEach(function (option) {\n                this.observe(option.value + 'Visible');\n            }.bind(this));\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        onUpdate: function (value) {\n            this.showRelatedElement(value);\n\n            return this._super();\n        },\n\n        /**\n         * Sets exported property, linked with visibility of the element, defined as option\n         *\n         * @param {String} value\n         * @returns {Object} Chainable\n         */\n        showRelatedElement: function (value) {\n            this[value + 'Visible'](true);\n            this.options().forEach(function (option) {\n                if (value !== option.value) {\n                    this[option.value + 'Visible'](false);\n                }\n            }.bind(this));\n\n            return this;\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/margins-and-padding.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/*eslint-disable vars-on-top, strict */\n\ndefine([\n    'underscore',\n    'ko',\n    'Magento_Ui/js/form/element/abstract'\n], function (_, ko, Abstract) {\n    'use strict';\n\n    var defaultValue = '';\n\n    return Abstract.extend({\n        defaults: {\n            elementTmpl: 'Magento_PageBuilder/form/element/margins-and-padding',\n            marginTop: defaultValue,\n            marginRight: defaultValue,\n            marginBottom: defaultValue,\n            marginLeft: defaultValue,\n            paddingTop: defaultValue,\n            paddingRight: defaultValue,\n            paddingBottom: defaultValue,\n            paddingLeft: defaultValue,\n            listens: {\n                marginTop: 'updateValue',\n                marginRight: 'updateValue',\n                marginBottom: 'updateValue',\n                marginLeft: 'updateValue',\n                paddingTop: 'updateValue',\n                paddingRight: 'updateValue',\n                paddingBottom: 'updateValue',\n                paddingLeft: 'updateValue'\n            }\n        },\n\n        /**\n         * Init observable on our margin & padding properties\n         *\n         * @returns {exports}\n         */\n        initObservable: function () {\n            this._super();\n            this.observe('marginTop marginRight marginBottom marginLeft ' +\n                'paddingTop paddingRight paddingBottom paddingLeft');\n\n            return this;\n        },\n\n        /**\n         * Update the value on individual property changes\n         */\n        updateValue: function () {\n            this.value({\n                margin: {\n                    top: this.marginTop(),\n                    right: this.marginRight(),\n                    bottom: this.marginBottom(),\n                    left: this.marginLeft()\n                },\n                padding: {\n                    top: this.paddingTop(),\n                    right: this.paddingRight(),\n                    bottom: this.paddingBottom(),\n                    left: this.paddingLeft()\n                }\n            });\n        },\n\n        /**\n         * On set of the initial value update our individual observables\n         *\n         * @returns {exports}\n         */\n        setInitialValue: function () {\n            this._super();\n            this._updateObservables(this.initialValue);\n\n            return this;\n        },\n\n        /**\n         * On update of the value property update our individual observables, the data provider can have data\n         * set on it after the initial construction, this ensures we translate our values\n         *\n         * @returns {exports}\n         */\n        onUpdate: function () {\n            this._super();\n            this._updateObservables(this.value());\n\n            return this;\n        },\n\n        /**\n         * Update the observable properties\n         *\n         * @param {Number} value\n         * @private\n         */\n        _updateObservables: function (value) {\n            if (value && _.isString(value)) {\n                value = JSON.parse(value);\n            }\n\n            if (value && _.isObject(value)) {\n                _.each(value, function (attributeData, attributeType) {\n                    _.each(attributeData, function (attributeValue, attributeDirection) {\n                        if (attributeValue !== defaultValue) {\n                            this[attributeType + attributeDirection.capitalize()](attributeValue);\n                        }\n                    }, this);\n                }, this);\n            }\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/select-filtered-options.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Ui/js/form/element/select'\n], function (_, Select) {\n    'use strict';\n\n    return Select.extend({\n\n        defaults: {\n            excludeOptions: []\n        },\n\n        /** @inheritdoc */\n        onUpdate: function () {\n            if (!this.updatedByFilter) {\n                this.transferredValue = null;\n            } else {\n                this.updatedByFilter = false;\n            }\n\n            return this._super();\n        },\n\n        /**\n         * Excluding options according excludeOptions configuration based on the passed value\n         *\n         * @param {String} value\n         */\n        filter: function (value) {\n            var source = this.initialOptions,\n                initialValue = this.value(),\n                result,\n                excludeOptions =  this.excludeOptions[value],\n                excludedOptionsArray = excludeOptions ? excludeOptions.split(',') : [];\n\n            result = _.filter(source, function (item) {\n                return !excludeOptions || excludedOptionsArray.indexOf(item.value) === -1;\n            });\n\n            this.updatedByFilter = true;\n            this.setOptions(result);\n\n            this.value(this.transferredValue ? this.transferredValue : initialValue);\n\n            if (excludedOptionsArray.indexOf(initialValue) !== -1) {\n                this.transferredValue = initialValue;\n            } else {\n                this.transferredValue = null;\n            }\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/dependent-value-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    var setDependentValuesSetting = {\n        defaults: {\n            dependentValues: {}\n        },\n\n        /**\n         * Change value of component if it present in dependentValues\n         */\n        setDependentValues: function (value) {\n            if (this.dependentValues.hasOwnProperty(value)) {\n                this.previousValue = this.value();\n                this.value(this.dependentValues[value]);\n            } else if (this.hasOwnProperty('previousValue')) {\n                this.value(this.previousValue);\n            }\n        }\n    };\n\n    return function (target) {\n        return target.extend(setDependentValuesSetting);\n    };\n});\n","Magento_PageBuilder/js/form/element/conditional-disable-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    var setDisabledSetting = {\n        defaults: {\n            disabledValues: []\n        },\n\n        /**\n         * Set the field as disabled when it's empty or is equal to a value within disabledValues\n         *\n         * @param {Array} value\n         */\n        setDisabled: function (value) {\n            if (_.indexOf(_.values(this.disabledValues), value) !== -1) {\n                this.disable();\n            } else {\n                this.enable();\n            }\n        }\n    };\n\n    return function (target) {\n        return target.extend(setDisabledSetting);\n    };\n});\n","Magento_PageBuilder/js/form/element/dependent-select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/select'\n], function (Select) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            visible: false\n        },\n\n        /**\n         * Dependently display dropdown component if it contains more than one option\n         *\n         * @returns {Object} Chainable\n         */\n        setOptions: function () {\n            this._super();\n\n            if (this.options().length > 1) {\n                this.setVisible(true);\n            }\n\n            return this;\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/html-code.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global MediabrowserUtility, widgetTools, MagentovariablePlugin */\ndefine([\n    'Magento_Ui/js/form/element/textarea',\n    'mage/adminhtml/wysiwyg/widget'\n], function (Textarea) {\n    'use strict';\n\n    var HTML_ID_PLACEHOLDER = 'HTML_ID_PLACEHOLDER';\n\n    return Textarea.extend({\n        defaults: {\n            elementTmpl: 'Magento_PageBuilder/form/element/html-code'\n        },\n\n        /**\n         * Click event for Insert Widget Button\n         */\n        clickInsertWidget: function () {\n            return widgetTools.openDialog(\n                this.widgetUrl.replace(HTML_ID_PLACEHOLDER, this.uid)\n            );\n        },\n\n        /**\n         * Click event for Insert Image Button\n         */\n        clickInsertImage: function () {\n            return MediabrowserUtility.openDialog(\n                this.imageUrl.replace(HTML_ID_PLACEHOLDER, this.uid)\n            );\n        },\n\n        /**\n         * Click event for Insert Variable Button\n         */\n        clickInsertVariable: function () {\n            return MagentovariablePlugin.loadChooser(\n                this.variableUrl,\n                this.uid\n            );\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/wysiwyg.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_Ui/js/form/element/wysiwyg',\n    'mage/translate',\n    'Magento_PageBuilder/js/events',\n    'Magento_Ui/js/lib/view/utils/dom-observer',\n    'Magento_PageBuilder/js/page-builder',\n    'Magento_Ui/js/lib/view/utils/async'\n], function ($, _, Wysiwyg, $t, events, domObserver, PageBuilder) {\n    'use strict';\n\n    /**\n     * Extend the original WYSIWYG with added PageBuilder functionality\n     */\n    return Wysiwyg.extend({\n        defaults: {\n            transition: false,\n            transitionOut: false,\n            elementSelector: '> textarea',\n            stageSelector: '.pagebuilder-stage-wrapper',\n            fieldsetSelector: 'fieldset.admin__fieldset',\n            overlaySelector: '.pagebuilder-wysiwyg-overlay',\n            overlayMouseover: false,\n            pageBuilder: false,\n            visiblePageBuilder: false,\n            isComponentInitialized: false,\n            wysiwygConfigData: {\n                isFullScreen: false\n            },\n            pageBuilderEditButtonText: $t('Edit with Page Builder'),\n            isWithinModal: false,\n            modal: false\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initialize: function () {\n            this._super();\n\n            if (!this.wysiwygConfigData()['pagebuilder_button'] ||\n                this.wysiwygConfigData()['pagebuilder_content_snapshot']) {\n                this.initPageBuilder();\n            }\n\n            return this;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initObservable: function () {\n            this._super()\n                .observe('isComponentInitialized visiblePageBuilder wysiwygConfigData loading transition ' +\n                    'transitionOut overlayMouseover');\n\n            return this;\n        },\n\n        /**\n         * Handle button click, init the Page Builder application\n         */\n        pageBuilderEditButtonClick: function (context, event) {\n            this.determineIfWithinModal(event.currentTarget);\n            this.transition(false);\n\n            if (!this.isComponentInitialized()) {\n                this.disableDomObserver($(event.currentTarget).parent()[0]);\n            }\n\n            this.initPageBuilder();\n            this.toggleFullScreen();\n        },\n\n        /**\n         * Init Page Builder\n         */\n        initPageBuilder: function () {\n            if (!this.isComponentInitialized()) {\n                this.loading(true);\n                this.pageBuilder = new PageBuilder(\n                  this.wysiwygConfigData(),\n                  this.initialValue\n                );\n                events.trigger('pagebuilder:register', {\n                    ns: this.ns,\n                    instance: this.pageBuilder\n                });\n                this.initPageBuilderListeners();\n                this.isComponentInitialized(true);\n\n                // Disable the domObserver for the entire stage\n                $.async({\n                    component: this,\n                    selector: this.stageSelector\n                }, this.disableDomObserver.bind(this));\n\n                if (!this.wysiwygConfigData()['pagebuilder_button'] ||\n                    this.wysiwygConfigData()['pagebuilder_content_snapshot']) {\n                    this.visiblePageBuilder(true);\n                }\n            }\n        },\n\n        /**\n         * Disable the domObserver on the PageBuilder stage to improve performance\n         *\n         * @param {HTMLElement} node\n         */\n        disableDomObserver: function (node) {\n            this.determineIfWithinModal(node);\n            domObserver.disableNode(node);\n            domObserver.disableNode($(node).parents(this.fieldsetSelector)[0]);\n        },\n\n        /**\n         * Changes tabindex and content editable on stage elements\n         */\n        toggleFocusableElements: function () {\n            var pageBuilderSelector = '#' + this.pageBuilder.id,\n                editable = $(pageBuilderSelector).find('[contenteditable]:not(.mceNonEditable)'),\n                focusableSelector = ' :focusable:not(' + this.overlaySelector + ')',\n                mediaSelector = pageBuilderSelector + ' iframe,' + pageBuilderSelector + ' video',\n                tabIndexValue = this.pageBuilder.isFullScreen() ? '0' : '-1',\n                editableValue = this.pageBuilder.isFullScreen();\n\n            editable.attr('contenteditable', editableValue);\n            $(pageBuilderSelector + focusableSelector).attr('tabindex', tabIndexValue);\n            $(mediaSelector).attr('tabindex', tabIndexValue);\n        },\n\n        /**\n         * Determine if the current instance is within a modal\n         *\n         * @param {HTMLElement} element\n         */\n        determineIfWithinModal: function (element) {\n            var modalInnerWrap = $(element).parents('.modal-inner-wrap');\n\n            // Determine if the Page Builder instance is within a modal\n            this.isWithinModal = modalInnerWrap.length === 1;\n\n            if (this.isWithinModal) {\n                this.modal = modalInnerWrap;\n            }\n        },\n\n        /**\n         * Press Enter key on Overlay\n         */\n        onOverlayKeyDown: function (context, event) {\n            if (event.which === 13 || event.keyCode === 13) {\n                this.pageBuilderEditButtonClick(context, event);\n            }\n\n            return true;\n        },\n\n        /**\n         * Toggle Page Builder full screen mode\n         */\n        toggleFullScreen: function () {\n            events.trigger('stage:' + this.pageBuilder.id + ':toggleFullscreen', {\n                animate: !!this.wysiwygConfigData()['pagebuilder_content_snapshot']\n            });\n        },\n\n        /**\n         * Init various listeners on the stage\n         */\n        initPageBuilderListeners: function () {\n            var id = this.pageBuilder.id,\n                renderDeferred = $.Deferred(),\n                fullScreenDeferred = $.Deferred(),\n                rendered = false;\n\n            events.on('stage:' + id + ':readyAfter', function () {\n                this.loading(false);\n            }.bind(this));\n\n            events.on('stage:' + id + ':renderAfter', function () {\n                renderDeferred.resolve();\n                rendered = true;\n            });\n\n            events.on('stage:' + id + ':masterFormatRenderAfter', function (args) {\n                this.value(args.value);\n\n                if (this.wysiwygConfigData()['pagebuilder_content_snapshot']) {\n                    this.toggleFocusableElements();\n                }\n            }.bind(this));\n\n            events.on('stage:' + id + ':fullScreenModeChangeAfter', function (args) {\n                if (!args.fullScreen) {\n                    if (this.isWithinModal && this.modal) {\n                        _.delay(function () {\n                            this.modal.css({\n                                transform: '',\n                                transition: ''\n                            });\n                        }.bind(this), 350);\n                    }\n\n                    if (this.wysiwygConfigData()['pagebuilder_button'] &&\n                        !this.wysiwygConfigData()['pagebuilder_content_snapshot']) {\n                        // Force full screen mode whilst the animation occurs\n                        this.transitionOut(true);\n                        // Trigger animation out\n                        this.transition(false);\n\n                        // Reset the transition out class and hide the stage\n                        _.delay(function () {\n                            this.transitionOut(false);\n                            this.visiblePageBuilder(false);\n                        }.bind(this), 185);\n                    }\n                } else if (args.fullScreen) {\n                    if (this.isWithinModal && this.modal) {\n                        this.modal.css({\n                            transform: 'none',\n                            transition: 'none'\n                        });\n                    }\n\n                    if (this.wysiwygConfigData()['pagebuilder_button'] &&\n                        !this.wysiwygConfigData()['pagebuilder_content_snapshot']) {\n                        this.visiblePageBuilder(true);\n\n                        fullScreenDeferred.resolve();\n\n                        /* eslint-disable max-depth */\n                        // If the stage has already rendered once we don't need to wait until animating the stage in\n                        if (rendered) {\n                            _.defer(function () {\n                                this.transition(true);\n                            }.bind(this));\n                        }\n                        /* eslint-enable max-depth */\n                    }\n                }\n\n                if (this.wysiwygConfigData()['pagebuilder_content_snapshot']) {\n                    this.toggleFocusableElements();\n                }\n            }.bind(this));\n\n            // Wait until the stage is rendered and full screen mode is activated\n            $.when(renderDeferred, fullScreenDeferred).done(function () {\n                _.defer(function () {\n                    this.transition(true);\n                }.bind(this));\n            }.bind(this));\n        },\n\n        /** @inheritdoc */\n        destroy: function () {\n            this.pageBuilder && this.pageBuilder.destroy();\n            this._super();\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/validator-rules-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_Ui/js/lib/validation/utils'\n], function ($, _, utils) {\n    'use strict';\n\n    /**\n     * Validate the number is between the min and max provided\n     *\n     * @param {Number} value\n     * @param {Number} min\n     * @param {Number} max\n     * @return {Boolean}\n     */\n    function validateNumberBetween(value, min, max) {\n        var numValue;\n\n        if ($.mage.isEmptyNoTrim(value)) {\n            return true;\n        }\n\n        numValue = $.mage.parseNumber(value);\n\n        if (isNaN(numValue)) {\n            return false;\n        }\n\n        return $.mage.isBetween(numValue, min, max);\n    }\n\n    /**\n     * Validate that string is url\n     * @param {String} href\n     * @return {Boolean}\n     */\n    function validateIsUrl(href) {\n        return (/^(http|https|ftp):\\/\\/(([A-Z0-9]([A-Z0-9_-]*[A-Z0-9]|))(\\.[A-Z0-9]([A-Z0-9_-]*[A-Z0-9]|))*)(:(\\d+))?(\\/[A-Z0-9~](([A-Z0-9_~-]|\\.)*[A-Z0-9~]|))*\\/?(.*)?$/i).test(href);//eslint-disable-line max-len\n    }\n\n    /**\n     * Validate that string has an anchor tag\n     * @param {String} str\n     * @return {Boolean}\n     */\n    function validateWysiwygHasAnchorTags(str) {\n        return (/<a[\\s]+([^>]+)>|<a>|<\\/a>/igm).test(str);\n    }\n\n    /**\n     * Validate that string has a widget\n     * @param {String} str\n     * @return {Boolean}\n     */\n    function validateWysiwygHasWidget(str) {\n        return (/\\{\\{widget(.*?)\\}\\}/ig).test(str);\n    }\n\n    /**\n     * Validate that string is a proper css-class\n     * @param {String} str\n     * @return {Boolean}\n     */\n    function validateCssClass(str) {\n        return (/^[a-zA-Z _\\-\\d]+$/i).test(str);\n    }\n\n    /**\n     * Validate message field and url field anchor tag is used exclusively by one field\n     * @param {String} message\n     * @param {Object} url\n     * @return {Boolean}\n     */\n    function validateOneAnchorTagField(message, url) {\n        return !(validateWysiwygHasAnchorTags(message) &&\n            ['page', 'product', 'category', 'default'].indexOf(url.type) !== -1 &&\n            url[url.type] &&\n            url[url.type].length > 0);\n    }\n\n    /**\n     * Validate message field and url field html standards, nested widget\n     * @param {String} message\n     * @param {Object} url\n     * @return {Boolean}\n     */\n    function validateNestedWidgetElement(message, url) {\n        return !(validateWysiwygHasWidget(message) &&\n            ['page', 'product', 'category', 'default'].indexOf(url.type) !== -1 &&\n            url[url.type] &&\n            url[url.type].length > 0);\n    }\n\n    /**\n     * Validate a field with an expected data value of type object, like margins_and_padding field\n     * @param {Function} validator\n     * @param {String} ruleName\n     */\n    function validateObjectField(validator, ruleName) {\n        var rule = validator.getRule(ruleName);\n\n        validator.addRule(\n            ruleName,\n            function (value, params) {\n                var allNumbers = true,\n                    handler = rule.handler.bind(this);\n\n                if (typeof value !== 'object') {\n                    return handler(value, params);\n                }\n\n                _.flatten(_.map(value, _.values)).forEach(function (val) {\n                    if (!handler(val, params)) {\n                        allNumbers = false;\n\n                        return allNumbers;\n                    }\n                });\n\n                return allNumbers;\n            },\n            $.mage.__(rule.message)\n        );\n    }\n\n    /**\n     * Validate calc value.\n     *\n     * @param {String} value\n     * @returns {Boolean}\n     */\n    function validateCalc(value) {\n        var el = document.createElement('div'),\n            style = el.style;\n\n        if (!value.trim().length) {\n            return true;\n        }\n\n        style.width = 'calc(' + value + ')';\n\n        return !!style.width.length;\n    }\n\n    return function (validator) {\n        var requiredInputRule = validator.getRule('required-entry');\n\n        validator.addRule(\n            'required-entry-location-name',\n            requiredInputRule.handler,\n            $.mage.__('Please enter the location name.')\n        );\n\n        validator.addRule(\n            'required-entry-latitude',\n            requiredInputRule.handler,\n            $.mage.__('Enter latitude')\n        );\n\n        validator.addRule(\n            'required-entry-longitude',\n            requiredInputRule.handler,\n            $.mage.__('Enter longitude')\n        );\n\n        validator.addRule(\n            'validate-latitude',\n            function (value) {\n                return validateNumberBetween(value, -85, 85);\n            },\n            $.mage.__('Please enter a number between -85 and 85')\n        );\n\n        validator.addRule(\n            'validate-longitude',\n            function (value) {\n                return validateNumberBetween(value, -180, 180);\n            },\n            $.mage.__('Please enter a number between -180 and 180')\n        );\n\n        validator.addRule(\n            'validate-video-url',\n            function (href) {\n                if (utils.isEmptyNoTrim(href)) {\n                    return true;\n                }\n\n                href = (href || '').replace(/^\\s+/, '').replace(/\\s+$/, '');\n\n                return validateIsUrl(href) && (href.match(/youtube\\.com|youtu\\.be/) || href.match(/vimeo\\.com/));\n            },\n            $.mage.__('Please enter a valid video URL.')\n        );\n\n        validator.addRule(\n            'validate-video-source',\n            function (href) {\n                if (utils.isEmptyNoTrim(href)) {\n                    return true;\n                }\n\n                href = (href || '').replace(/^\\s+/, '').replace(/\\s+$/, '');\n\n                return validateIsUrl(href) && (\n                    href.match(/youtube\\.com|youtu\\.be/) ||\n                    href.match(/vimeo\\.com/) ||\n                    href.match(/\\.(mp4|ogv|webm)(?!\\w)/)\n                );\n            },\n            $.mage.__('Please enter a valid video URL. Valid URLs have a video file extension (.mp4, .webm, .ogv) or links to videos on YouTube or Vimeo.')//eslint-disable-line max-len\n        );\n\n        validator.addRule(\n            'validate-css-class',\n            function (value) {\n                if (utils.isEmptyNoTrim(value)) {\n                    return true;\n                }\n\n                return validateCssClass(value);\n            },\n            $.mage.__('Please enter a valid CSS class.')\n        );\n\n        validator.addRule(\n            'required-entry',\n            function (value) {\n                var allFilled;\n\n                // Validation only for margins and paddings\n                if (typeof value === 'object' && !!(value.padding || value.margin)) {\n                    allFilled = true;\n\n                    _.flatten(_.map(value, _.values)).forEach(function (val) {\n                        if (utils.isEmpty(val)) {\n                            allFilled = false;\n\n                            return allFilled;\n                        }\n                    });\n\n                    return allFilled;\n                }\n\n                return requiredInputRule.handler(value);\n            },\n            $.mage.__(requiredInputRule.message)\n        );\n\n        validator.addRule(\n            'validate-message-no-link',\n            function (url, message) {\n                return validateOneAnchorTagField(message, url);\n            },\n            $.mage.__('Adding link in both content and outer element is not allowed.')\n        );\n\n        validator.addRule(\n            'validate-no-url',\n            function (message, url) {\n                return validateOneAnchorTagField(message, url);\n            },\n            $.mage.__('Adding link in both content and outer element is not allowed.')\n        );\n\n        validator.addRule(\n            'validate-message-no-widget',\n            function (url, message) {\n                return validateNestedWidgetElement(message, url);\n            },\n            $.mage.__('Adding link in outer element and widget in content is not allowed.')\n        );\n\n        validator.addRule(\n            'validate-no-widget',\n            function (message, url) {\n                return validateNestedWidgetElement(message, url);\n            },\n            $.mage.__('Adding widget in content and link in outer element is not allowed.')\n        );\n\n        validator.addRule(\n            'validate-calc',\n            function (value) {\n                return validateCalc(value);\n            },\n            $.mage.__('Please enter a valid number or calculation: Valid numbers must have an extension (px, %, pt, vh). Calculations must have white space around the + and - operators and cannot divide by zero.')//eslint-disable-line max-len\n        );\n\n        validateObjectField(validator, 'validate-number');\n        validateObjectField(validator, 'less-than-equals-to');\n        validateObjectField(validator, 'greater-than-equals-to');\n\n        return validator;\n    };\n});\n","Magento_PageBuilder/js/form/element/image-uploader.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'uiRegistry',\n    'Magento_Ui/js/form/element/image-uploader',\n    'Magento_PageBuilder/js/resource/resize-observer/ResizeObserver',\n    'Magento_PageBuilder/js/events',\n    'mage/translate'\n], function ($, _, uiRegistry, Uploader, ResizeObserver, events, $t) {\n    'use strict';\n\n    var initializedOnce = false;\n\n    return Uploader.extend({\n        defaults: {\n            $uploadArea: null,\n            isShowImageUploadInstructions: true,\n            isShowImageUploadOptions: false,\n            visibleControls: true,\n            classes: {\n                dragging: 'dragging',\n                draggingInside: 'dragging-inside',\n                draggingOutside: 'dragging-outside'\n            },\n            // listed in ascending order\n            elementWidthModifierClasses: {\n                '_micro-ui': {\n                    maxWidth: 130\n                },\n                '_compact-ui': {\n                    minWidth: 131,\n                    maxWidth: 440\n                }\n            },\n            translations: {\n                allowedFileTypes: $t('Allowed file types'),\n                dragImageHere: $t('Drag image here'),\n                dropHere: $t('Drop here'),\n                maximumFileSize: $t('Maximum file size'),\n                selectFromGallery: $t('Select from Gallery'),\n                or: $t('or'),\n                uploadImage: $t('Upload Image'),\n                uploadNewImage: $t('Upload New Image')\n            },\n            tracks: {\n                visibleControls: true\n            }\n        },\n\n        /**\n         * Bind drag events to highlight/unhighlight dropzones\n         * {@inheritDoc}\n         */\n        initialize: function () {\n            var $document = $(document);\n\n            this._super();\n\n            events.on('image:' + this.id + ':assignAfter', this.onAssignedFile.bind(this));\n\n            // bind dropzone highlighting using event delegation only once\n            if (!initializedOnce) {\n                // dropzone highlighting\n                $document.on('dragover', this.highlightDropzone.bind(this));\n\n                // dropzone unhighlighting\n                $document.on('dragend dragleave mouseup', this.unhighlightDropzone.bind(this));\n\n                initializedOnce = true;\n            }\n        },\n\n        /**\n         * {@inheritDoc}\n         */\n        initUploader: function (fileInput) {\n            this._super(fileInput);\n            this.$uploadArea = $(this.$fileInput).closest('.pagebuilder-image-empty-preview');\n            new ResizeObserver(this.updateResponsiveClasses.bind(this)).observe(this.$uploadArea.get(0));\n        },\n\n        /**\n         * Checks if provided file is allowed to be uploaded.\n         * {@inheritDoc}\n         */\n        isFileAllowed: function () {\n            var result = this._super(),\n                allowedExtensions = this.getAllowedFileExtensionsInCommaDelimitedFormat();\n\n            if (!result.passed && result.rule === 'validate-file-type') {\n                result.message += ' ' + this.translations.allowedFileTypes + ': ' + allowedExtensions + '.';\n            }\n\n            return result;\n        },\n\n        /**\n         * Remove draggable classes from dropzones\n         * {@inheritDoc}\n         */\n        onBeforeFileUpload: function () {\n            this.removeDraggableClassesFromDropzones();\n            this._super();\n        },\n\n        /**\n         * Add/remove CSS classes to $dropzone element to provide UI feedback\n         *\n         * @param {jQuery.event} e\n         */\n        highlightDropzone: function (e) {\n            var $dropzone = $(e.target).closest(this.dropZone),\n                $otherDropzones = $(this.dropZone).not($dropzone),\n                isInsideDropzone = !!$dropzone.length;\n\n            if (isInsideDropzone) {\n                $dropzone\n                  .removeClass(this.classes.draggingOutside)\n                  .addClass([this.classes.dragging, this.classes.draggingInside].join(' '));\n            }\n\n            $otherDropzones\n              .removeClass(this.classes.draggingInside)\n              .addClass([this.classes.dragging, this.classes.draggingOutside].join(' '));\n        },\n\n        /**\n         * Remove all UI styling from dropzone\n         *\n         * @param {jQuery.event} e\n         */\n        unhighlightDropzone: function (e) {\n            var isMouseReleased = e.type === 'mouseup' || e.type === 'dragend',\n                isActuallyLeavingThePage = e.type === 'dragleave' && (e.clientX === 0 || e.clientY === 0);\n\n            if (!isMouseReleased && !isActuallyLeavingThePage) {\n                return;\n            }\n\n            this.removeDraggableClassesFromDropzones();\n        },\n\n        /**\n         * Remove draggable CSS classes from dropzone elements\n         */\n        removeDraggableClassesFromDropzones: function () {\n            var $dropzones = $(this.dropZone);\n\n            $dropzones\n                .removeClass([\n                    this.classes.dragging,\n                    this.classes.draggingInside,\n                    this.classes.draggingOutside\n                ].join(' '));\n        },\n\n        /**\n         * Trigger image:uploadAfter event to be handled by PageBuilder image component\n         * {@inheritDoc}\n         */\n        addFile: function (file) {\n            this._super();\n\n            events.trigger('image:' + this.id + ':uploadAfter', [file]);\n\n            return this;\n        },\n\n        /**\n         * Trigger image:deleteFileAfter event to be handled by PageBuilder image component\n         * {inheritDoc}\n         */\n        clear: function () {\n            this._super();\n\n            events.trigger('image:' + this.id + ':deleteFileAfter');\n\n            return this;\n        },\n\n        /**\n         * Propagate file changes through all image uploaders sharing the same id\n         *\n         * @param {Object} file\n         */\n        onAssignedFile: function (file) {\n            this.value([file]);\n        },\n\n        /**\n         * Adds the appropriate ui state class to the upload control area based on the current rendered size\n         */\n        updateResponsiveClasses: function () {\n            var classesToAdd = [],\n                classConfig,\n                elementWidth = this.$uploadArea.width(),\n                modifierClass;\n\n            if (!this.$uploadArea.is(':visible')) {\n                return;\n            }\n\n            this.$uploadArea.removeClass(Object.keys(this.elementWidthModifierClasses).join(' '));\n\n            for (modifierClass in this.elementWidthModifierClasses) {\n                if (!this.elementWidthModifierClasses.hasOwnProperty(modifierClass)) {\n                    // jscs:disable disallowKeywords\n                    continue;\n                    // jscs:enable disallowKeywords\n                }\n\n                classConfig = this.elementWidthModifierClasses[modifierClass];\n\n                if (classConfig.minWidth && classConfig.maxWidth &&\n                    (classConfig.minWidth <= elementWidth && elementWidth <= classConfig.maxWidth) ||\n                    classConfig.minWidth && !classConfig.maxWidth && classConfig.minWidth <= elementWidth ||\n                    classConfig.maxWidth && !classConfig.minWidth && elementWidth <= classConfig.maxWidth\n                ) {\n                    classesToAdd.push(modifierClass);\n                }\n            }\n\n            if (classesToAdd.length) {\n                this.$uploadArea.addClass(classesToAdd.join(' '));\n            }\n        },\n\n        /**\n         * {@inheritDoc}\n         */\n        hasData: function () {\n            // Some of the components automatically add an empty object if the value is unset.\n            return this._super() && !$.isEmptyObject(this.value()[0]);\n        },\n\n        /**\n         * Stop event to prevent it from reaching any objects other than the current object.\n         *\n         * @param {Object} uploader\n         * @param {Event} event\n         * @returns {Boolean}\n         */\n        stopEvent: function (uploader, event) {\n            event.stopPropagation();\n\n            return true;\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/dependent-fieldset.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/fieldset'\n], function (Fieldset) {\n    'use strict';\n\n    return Fieldset.extend({\n        defaults: {\n            originalLabelValue: ''\n        },\n\n        /**\n         * Observe label\n         * {@inheritDoc}\n         */\n        initObservable: function () {\n            this._super().observe('label');\n\n            return this;\n        },\n\n        /**\n         * Store original label value\n         * {@inheritDoc}\n         */\n        initConfig: function () {\n            this._super();\n            this.originalLabelValue = this.label;\n        },\n\n        /**\n         * Hide fieldset if number of field options is <= 1 and it is the only element in the group\n         *\n         * @param {Array} options\n         */\n        hideFieldset: function (options) {\n            this.visible(options.length > 1 || this.elems().length > 1);\n        },\n\n        /**\n         * Hide label if number of field options is <= 1\n         *\n         * @param {Array} options\n         */\n        hideLabel: function (options) {\n            this.label(options.length > 1 ? this.originalLabelValue : '');\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/page-ui-select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/ui-select'\n], function (Select) {\n    'use strict';\n\n    return Select.extend({\n\n        /**\n         * Get path to current option\n         *\n         * @param {Object} data - option data\n         * @returns {String} path\n         */\n        getPath: function (data) {\n            var path = '';\n\n            if (this.renderPath) {\n                path = data.identifier || path;\n            }\n\n            return path;\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/dependent-visual-select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_PageBuilder/js/form/element/visual-select'\n], function (_, Select) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            visible: false\n        },\n\n        /**\n         * Dependently display dropdown component if it contains more than one option\n         *\n         * @returns {Object} Chainable\n         */\n        setOptions: function () {\n            this._super();\n\n            if (this.options().length > 1) {\n                this.setVisible(true);\n            }\n\n            return this;\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/conditions-loader.js":"define([\n    'jquery',\n    'Magento_Rule/rules',\n    'uiRegistry',\n    'mage/utils/objects'\n], function ($, RulesForm, uiRegistry, objectUtils) {\n    'use strict';\n\n    return function (config, conditionsFormPlaceholder) {\n        var $conditionsFormPlaceholder = $(conditionsFormPlaceholder),\n            attributeData = uiRegistry.get(config.formNamespace + '.' + config.formNamespace).source.data,\n            conditions = objectUtils.nested(attributeData, config.attribute) || '[]';\n\n        $('body').trigger('processStart');\n\n        $.ajax(config.componentUrl, {\n            method: 'POST',\n            data: {\n                conditions: conditions\n            }\n        })\n        .done(function (response) {\n            $conditionsFormPlaceholder.html(response);\n            window[config.jsObjectName] = new RulesForm(config.jsObjectName, config.childComponentUrl);\n            $('body').trigger('processStop');\n        });\n    };\n});\n","Magento_PageBuilder/js/form/element/visual-select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Ui/js/form/element/select'\n], function (_, Select) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            noticeMessage: '',\n            listens: {\n                value: 'setNoticeMessage'\n            }\n        },\n\n        /**\n         * Initializes observable properties of instance\n         *\n         * @returns {Abstract} Chainable.\n         */\n        initObservable: function () {\n            this._super();\n            this.observe('noticeMessage');\n\n            return this;\n        },\n\n        /**\n         * Parses incoming options, considers options with undefined value property\n         *     as caption\n         *\n         * @param  {Array} nodes\n         * @param {Object} captionValue\n         * @return {Object} captionValue\n         */\n        parseOptions: function (nodes, captionValue) {\n            var caption,\n                value;\n\n            nodes = _.map(nodes, function (node) {\n                value = node.value;\n\n                if ((value === null || value === captionValue) && _.isUndefined(caption)) {\n                    caption = node.label;\n                }\n\n                return node;\n            });\n\n            return {\n                options: _.compact(nodes),\n                caption: _.isString(caption) ? caption : false\n            };\n        },\n\n        /**\n         * Recursively set to object item like value and item.value like key.\n         *\n         * @param {Array} data\n         * @param {Object} result\n         * @returns {Object}\n         */\n        indexOptions: function (data, result) {\n            var value;\n\n            result = result || {};\n\n            data.forEach(function (item) {\n                value = item.value;\n\n                if (Array.isArray(value)) {\n                    this.indexOptions(value, result);\n                } else {\n                    result[value] = item;\n                }\n            });\n\n            return result;\n        },\n\n        /**\n         * Sets 'data' to 'options' observable array, if instance has\n         * 'customEntry' property set to true, calls 'setHidden' method\n         *  passing !options.length as a parameter\n         *\n         * @param {Array} data\n         * @returns {Object} Chainable\n         */\n        setOptions: function (data) {\n            var captionValue = this.captionValue || '',\n                result = this.parseOptions(data, captionValue),\n                isVisible;\n\n            this.indexedOptions = this.indexOptions(result.options);\n\n            this.options(result.options);\n\n            if (!this.caption()) {\n                this.caption(result.caption);\n            }\n\n            if (this.customEntry) {\n                isVisible = !!result.options.length;\n\n                this.setVisible(isVisible);\n                this.toggleInput(!isVisible);\n            }\n\n            return this;\n        },\n\n        /**\n         * Set the notice message on value change\n         *\n         * @param {any} value\n         * @returns {exports}\n         */\n        setNoticeMessage: function (value) {\n            var noticeMessage = '',\n                selectedOption = _.find(this.options(), function (option) {\n                    return option.value === value;\n                });\n\n            if (selectedOption && typeof selectedOption.noticeMessage !== 'undefined') {\n                noticeMessage = selectedOption.noticeMessage;\n            }\n\n            this.noticeMessage(noticeMessage);\n\n            return this;\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/map.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/*eslint-disable vars-on-top, strict */\n\ndefine([\n    'Magento_Ui/js/form/element/abstract',\n    'Magento_PageBuilder/js/utils/map',\n    'module',\n    'Magento_PageBuilder/js/events'\n], function (AbstractField, GoogleMap, module, events) {\n    'use strict';\n\n    var google = window.google || {};\n\n    return AbstractField.extend({\n        defaults: {\n            elementTmpl: 'Magento_PageBuilder/form/element/map',\n            map: false,\n            marker: false,\n            apiKeyValid: !!module.config().apiKey,\n            apiKeyErrorMessage: module.config().apiKeyErrorMessage\n        },\n\n        /**\n         * Initializes observable properties of instance\n         *\n         * @returns {Abstract} Chainable.\n         */\n        initObservable: function () {\n            this._super();\n\n            this.observe('apiKeyValid');\n\n            return this;\n        },\n\n        /**\n         * Render the map into the field\n         *\n         * @param {HTMLElement} element\n         */\n        renderMap: function (element) {\n            // Get the start value and convert the value into an array\n            var startValue = this.value(),\n                mapOptions,\n                latitudeLongitude;\n\n            if (!this.apiKeyValid()) {\n                return;\n            }\n\n            if (typeof startValue === 'string' && startValue !== '') {\n                startValue = JSON.parse(startValue);\n            }\n\n            mapOptions = {\n                navigationControl: true,\n                navigationControlOptions: {\n                    style: google.maps.NavigationControlStyle.DEFAULT\n                }\n            };\n\n            events.on('googleMaps:authFailure', function () {\n                this.apiKeyValid(false);\n            }.bind(this));\n\n            // Create the map\n            this.mapElement = new GoogleMap(element, [], mapOptions);\n\n            if (!this.mapElement || !this.mapElement.map) {\n                return;\n            }\n\n            // Add marker if there is a start value\n            if (startValue.latitude !== '' && startValue.longitude !== '') {\n                latitudeLongitude = new google.maps.LatLng(\n                    parseFloat(startValue.latitude),\n                    parseFloat(startValue.longitude)\n                );\n\n                this.mapElement.map.setCenter(latitudeLongitude);\n                this.addMarker(startValue.latitude, startValue.longitude);\n            }\n\n            // After click, add and update both Latitude and Longitude.\n            google.maps.event.addListener(this.mapElement.map, 'click', this.onClick.bind(this));\n            google.maps.event.addListener(this.mapElement.map, 'dblclick', this.onDblClick.bind(this));\n            google.maps.event.trigger(this.marker, 'click');\n        },\n\n        /**\n         * Adds a map marker\n         *\n         * @param {String} latitude\n         * @param {String} longitude\n         */\n        addMarker: function (latitude, longitude) {\n            this.marker = new google.maps.Marker({\n                draggable: true,\n                map: this.mapElement.map,\n                position: new google.maps.LatLng(latitude, longitude)\n            });\n            google.maps.event.addListener(this.marker, 'dragend', this.onDragEnd.bind(this));\n        },\n\n        /**\n         * Event for drag end to update value\n         */\n        onDragEnd: function () {\n            this.value(this.exportValue());\n        },\n\n        /**\n         * Event for click to update marker, delayed by 300ms in case of double click\n         *\n         * @param {Event} event\n         */\n        onClick: function (event) {\n            this.clickTimer = setTimeout(function () {\n                if (!this.marker) {\n                    this.addMarker(event.latLng.lat(), event.latLng.lng());\n                }\n                this.value(this.exportValue(event.latLng));\n            }.bind(this), 300);\n        },\n\n        /**\n         * Event for double click to prevent call from single click\n         */\n        onDblClick: function () {\n            clearTimeout(this.clickTimer);\n        },\n\n        /**\n         * Callback after an update to map\n         */\n        onUpdate: function () {\n            if (!this.mapElement) {\n                return;\n            }\n\n            this._super();\n            var content = this.value(),\n                latitudeLongitude;\n\n            if (this.marker && content.latitude === '' && content.longitude === '') {\n                this.marker.setMap(null);\n                delete this.marker;\n\n                return;\n            }\n\n            if (!this.validateCoordinate(content) ||\n                this.mapElement &&\n                !this.mapElement.map ||\n                this.value() === '' ||\n                this.value() === this.exportValue()) {\n                return;\n            }\n\n            if (typeof this.value() === 'string' && this.value() !== '') {\n                content = JSON.parse(this.value());\n            }\n            latitudeLongitude = new google.maps.LatLng(parseFloat(content.latitude), parseFloat(content.longitude));\n\n            if (!this.marker) {\n                this.addMarker(latitudeLongitude.lat(), latitudeLongitude.lng());\n            }\n\n            this.marker.setPosition(latitudeLongitude);\n            this.mapElement.map.setCenter(latitudeLongitude);\n        },\n\n        /**\n         * Coordinate validation\n         *\n         * @param {Object} coordinates\n         * @return {Boolean}\n         */\n        validateCoordinate: function (coordinates) {\n            var valid = true;\n\n            if (coordinates.longitude === '' ||\n                coordinates.latitude === '' ||\n                isNaN(coordinates.longitude) ||\n                isNaN(coordinates.latitude) ||\n                parseFloat(coordinates.longitude) < -180 ||\n                parseFloat(coordinates.longitude) > 180 ||\n                parseFloat(coordinates.latitude) < -90 ||\n                parseFloat(coordinates.latitude) > 90\n            ) {\n                valid = false;\n            }\n\n            return valid;\n        },\n\n        /**\n         * Returns current latitude and longitude as an object\n         *\n         * @param {Object} coordinate\n         * @return {Object}\n         */\n        exportValue: function (coordinate) {\n            var position = this.marker ?\n                this.marker.getPosition() :\n                new google.maps.LatLng(this.mapElement.map.center.lat(), this.mapElement.map.center.lng()),\n                currentCoordinate = coordinate ? coordinate : position;\n\n            return {\n                latitude: currentCoordinate.lat(),\n                longitude: currentCoordinate.lng()\n            };\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/block-chooser.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'uiLayout',\n    'uiElement',\n    'Magento_PageBuilder/js/config',\n    'mage/translate',\n    'mage/utils/objects'\n], function ($, layout, Element, Config, $t, objectUtils) {\n    'use strict';\n\n    return Element.extend({\n        id: null,\n        meta: {},\n        errorMessage: null,\n        displayMetadata: true,\n        messages: {\n            UNKOWN_ERROR: $t('Sorry, there was an error getting requested content. ' +\n                'Please contact the store owner.'),\n            UNKNOWN_SELECTION: $t('The currently selected block does not exist.')\n        },\n        defaults: {\n            template: 'Magento_PageBuilder/form/element/block-chooser',\n            requestParameter: null,\n            dataUrlConfigPath: null,\n            modalName: null,\n            buttonComponentConfig: {\n                title: '${ $.buttonTitle }',\n                component: 'Magento_Ui/js/form/components/button',\n                actions: [{\n                    targetName: '${ $.modalName }',\n                    actionName: 'openModal'\n                }]\n            },\n            requestData: {\n                method: 'POST',\n                data: {\n                    'form_key': window.FORM_KEY\n                }\n            },\n            listens: {\n                id: 'updateFromServer'\n            }\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initObservable: function () {\n            return this._super()\n                .observe('id meta errorMessage displayMetadata');\n        },\n\n        /**\n         * Updates the block data from the server\n         *\n         * @returns void\n         */\n        updateFromServer: function () {\n            var requestData = $.extend(true, {}, this.requestData);\n\n            // The component hasn't be configured yet. Nothing to do.\n            if (!this.id().length || !this.requestParameter || !this.dataUrlConfigPath) {\n                this.meta({});\n\n                return;\n            }\n\n            requestData.data[this.requestParameter] = this.id();\n            $('body').trigger('processStart');\n\n            $.ajax(objectUtils.nested(Config.getConfig(), this.dataUrlConfigPath), requestData)\n                .always(function () {\n                    $('body').trigger('processStop');\n                    this.errorMessage(null);\n                }.bind(this))\n                .done(function (response) {\n                    if (typeof response !== 'object' || response.error) {\n                        this.meta({});\n                        this.errorMessage(this.messages.UNKOWN_ERROR);\n\n                        return;\n                    } else if ($.isArray(response)) {\n                        this.meta({});\n                        this.errorMessage(this.messages.UNKNOWN_SELECTION);\n\n                        return;\n                    }\n\n                    this.meta(response);\n                }.bind(this))\n                .fail(function () {\n                    this.meta({});\n                    this.errorMessage(this.messages.UNKOWN_ERROR);\n                }.bind(this));\n        },\n\n        /**\n         * Creates the button component for rendering\n         *\n         * @returns {Object} The button component\n         */\n        getButton: function () {\n            var elementConfig = this.buttonComponentConfig;\n\n            elementConfig.name = this.name + '_button';\n            layout([elementConfig]);\n\n            return this.requestModule(elementConfig.name);\n        },\n\n        /**\n         * Determines the status label for the currently loaded block\n         *\n         * @returns {String}\n         */\n        getStatusLabel: function () {\n            return this.meta()['is_active'] === '1' ? $t('Active') : $t('Inactive');\n        }\n    });\n});\n","Magento_PageBuilder/js/form/provider/conditions-data-processor.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'mage/utils/objects',\n    'Magento_Rule/conditions-data-normalizer'\n], function (_, objectUtils, ConditionsDataNormalizer) {\n    'use strict';\n\n    var serializer = new ConditionsDataNormalizer();\n\n    return function (data, attribute) {\n        var pairs = {},\n            conditions = '';\n\n        /*\n         * The Condition Rule Tree is not a UI component and doesn't provide good data.\n         * The best solution is to implement the tree as a UI component that can provide good data but\n         * that is outside of the scope of the feature for now.\n         */\n        _.each(data, function (element, key) {\n            // parameters is hardcoded in the Magento\\Rule model that creates the HTML forms.\n            if (key.indexOf('parameters[' + attribute + ']') === 0) {\n                // Remove the bad, un-normalized data.\n                delete data[key];\n                pairs[key] = element;\n            }\n        });\n\n        /*\n         * The Combine Condition rule needs to have children,\n         * if does not have, we cannot parse the rule in the backend.\n         */\n        _.each(pairs, function (element, key) {\n            var keyIds = key.match(/[\\d?-]+/g),\n              combineElement = 'Magento\\\\CatalogWidget\\\\Model\\\\Rule\\\\Condition\\\\Combine',\n              nextPairsFirstKey = 'parameters[condition_source][NEXT_ITEM--1][type]',\n              nextPairsSecondKey = 'parameters[condition_source][NEXT_ITEM--2][type]';\n\n            if (keyIds !== null && element === combineElement) {\n                if (pairs[nextPairsFirstKey.replace('NEXT_ITEM', keyIds[0])] === undefined ||\n                    pairs[nextPairsFirstKey.replace('NEXT_ITEM', keyIds[0])] === combineElement &&\n                    pairs[nextPairsSecondKey.replace('NEXT_ITEM', keyIds[0])] === undefined) {\n                    pairs[key] = '';\n                }\n            }\n        });\n\n        /*\n         * Add pairs in case conditions source is not rules configurator\n         */\n        if (data['condition_option'] !== 'condition') {\n            pairs['parameters[' + attribute + '][1--1][operator]'] =\n                data[data['condition_option'] + '-condition_operator'] ?\n                data[data['condition_option'] + '-condition_operator'] :\n                '==';\n            pairs['parameters[' + attribute + '][1--1][type]'] =\n                'Magento\\\\CatalogWidget\\\\Model\\\\Rule\\\\Condition\\\\Product';\n            pairs['parameters[' + attribute + '][1][aggregator]'] = 'all';\n            pairs['parameters[' + attribute + '][1][new_child]'] = '';\n            pairs['parameters[' + attribute + '][1][type]'] = 'Magento\\\\CatalogWidget\\\\Model\\\\Rule\\\\Condition\\\\Combine';\n            pairs['parameters[' + attribute + '][1][value]'] = '1';\n            pairs['parameters[' + attribute + '][1--1][attribute]'] = data['condition_option'];\n            pairs['parameters[' + attribute + '][1--1][value]'] = _.isString(data[data['condition_option']]) ?\n                data[data['condition_option']].trim() :\n                '';\n        }\n\n        if (!_.isEmpty(pairs)) {\n            conditions = JSON.stringify(serializer.normalize(pairs).parameters[attribute]);\n            data['conditions_encoded'] = conditions;\n            objectUtils.nested(data, attribute, conditions);\n        }\n    };\n});\n","Magento_PageBuilder/js/form/components/action-button.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/button'\n], function (Button) {\n    'use strict';\n\n    return Button.extend({\n        defaults: {\n            modules: {\n                parent: '${ $.parentName }',\n                insertForm: '${ $.insertFormProvider }',\n                modal: '${ $.modalProvider }'\n            }\n        },\n\n        /**\n         * Edit form with data assigning.\n         */\n        edit: function () {\n            this.modal().openModal();\n            this.insertForm().edit(this.parent().data());\n        },\n\n        /**\n         * Delete record from dynamic row.\n         */\n        deleteRecord: function () {\n            var record = this.parent(),\n                dynamicRow = record.parentComponent(),\n                prop = dynamicRow.identificationProperty,\n                id = record.data()[prop];\n\n            dynamicRow.deleteRecord(record.index, id);\n        }\n    });\n});\n","Magento_PageBuilder/js/form/components/insert-form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/insert-form',\n    'Magento_PageBuilder/js/events',\n    'jquery'\n], function (Insert, events, $) {\n    'use strict';\n\n    return Insert.extend({\n        defaults: {\n            appearanceIndex: '',\n            configs: {},\n            tracks: {\n                id: true\n            },\n            listens: {\n                appearance: 'onAppearanceChange'\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n\n            events.on('form:renderAfter', function (params) {\n                this.render(params);\n            }.bind(this));\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        render: function (params) {\n            this.availableAppearances = params.appearances;\n            this.title = params.title;\n            this.defaultNamespace = params.defaultNamespace;\n            this.destroyInserted();\n            this.setData(params);\n\n            return this._super({\n                namespace: params.namespace,\n                handle: params.namespace\n            });\n        },\n\n        /**\n         * Set data for new form.\n         *\n         * @param {Object} params\n         */\n        setData: function (params) {\n            var formQuery = 'index=' + params.namespace,\n                dataProviderQuery = 'index=' + params.namespace + '_data_source';\n\n            this.providerData = params.data;\n            this.id = params.id;\n            this.externalForm = this.requestModule(formQuery);\n            this.externalSource = this.requestModule(dataProviderQuery);\n            this.setLinks({\n                appearance: 'ns = ' + params.namespace + ', index = ' + this.appearanceIndex + ':value'\n            }, 'imports');\n            this.setLinks({\n                providerData: dataProviderQuery + ':data',\n                prefix: formQuery + ':selectorPrefix',\n                id: dataProviderQuery + ':id'\n            }, 'exports');\n        },\n\n        /** @inheritdoc **/\n        requestData: function (params) {\n            var deffer = $.Deferred(),\n                formConfig = this.configs[params.namespace];\n\n            if (formConfig) {\n                return deffer.resolve(formConfig);\n            }\n\n            return this._super().done(function (data) {\n                this.configs[params.namespace] = data;\n            }.bind(this));\n        },\n\n        /**\n         * Re-render after appearance change\n         *\n         * @param {String} value\n         */\n        onAppearanceChange: function (value) {\n            var namespace = this.availableAppearances[value] && this.availableAppearances[value].form ||\n                this.defaultNamespace;\n\n            if (namespace !== this.previousParams.namespace) {\n                this.render({\n                    namespace: namespace,\n                    id: this.id,\n                    data: this.externalSource().get('data'),\n                    appearances: this.availableAppearances,\n                    title: this.title,\n                    defaultNamespace: this.defaultNamespace\n                });\n            }\n        }\n    });\n});\n","Magento_PageBuilder/js/form/components/map-location-insert-form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/insert-form'\n], function (Insert) {\n    'use strict';\n\n    return Insert.extend({\n        /**\n         * Clear form content and reinsert data in argument\n         * @param {Object} data\n         */\n        edit: function (data) {\n            this.destroyInserted();\n            this.render();\n            this.setData(data);\n        },\n\n        /**\n         * Set data for new form\n         *\n         * @param {Object} data\n         */\n        setData: function (data) {\n            var formQuery = 'index=' + this.ns,\n                dataProviderQuery = 'index=' + this.ns + '_data_source';\n\n            this.providerData = data;\n            this.externalForm = this.requestModule(formQuery);\n            this.externalSource = this.requestModule(dataProviderQuery);\n            this.setLinks({\n                providerData: dataProviderQuery + ':data'\n            }, 'exports');\n        }\n    });\n});\n","Magento_PageBuilder/js/form/components/map-location-dynamic-rows.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/dynamic-rows/dynamic-rows',\n    'Magento_PageBuilder/js/events',\n    'underscore',\n    'jquery'\n], function (dynamicRows, Events, _, $) {\n    'use strict';\n\n    /**\n     * Returns sortable values\n     *\n     * @param {String | Number | Object | Array} value\n     * @return {String | Number}\n     */\n    var sortValueValidator = function (value) {\n        if (typeof value === 'string') {\n            return value.toLowerCase();\n        }\n\n        if (typeof value === 'number') {\n            return value;\n        }\n\n        return '';\n    };\n\n    return dynamicRows.extend({\n        defaults: {\n            modules: {\n                insertForm: '${ $.insertFormProvider }',\n                modal: '${$.modalProvider}'\n            }\n        },\n\n        /** @inheritdoc */\n        initLinks: function () {\n            this._super();\n            Events.on('mapLocation:saveAfter', function (data) {\n                this.modal().closeModal();\n                this.reInitData(data);\n            }.bind(this), this.name);\n\n            return this;\n        },\n\n        /**\n         * Open the location modal and insert form with the data from selected record\n         *\n         * @param {Object} record\n         */\n        edit: function (record) {\n            this.modal().openModal();\n            this.insertForm().edit(record.data());\n        },\n\n        /**\n         * Reinitializing of dynamic row records.\n         *\n         * @param {Object} data\n         */\n        reInitData: function (data) {\n            var recordData = this.recordData().slice(),\n                prop = this.identificationProperty,\n                isExists = false;\n\n            _.each(recordData, function (elem, index) {\n                if (elem[prop] === data[prop]) {\n                    recordData[index] = data;\n                    isExists = true;\n                }\n            }, this);\n\n            if (!isExists) {\n                recordData.push(data);\n            }\n\n            this.recordData(recordData);\n\n            _.each(this.labels(), function (label) {\n                if (label.columnsHeaderClasses) {\n                    this.sortRecord(label.name, label.columnsHeaderClasses === '_ascend');\n                }\n            }.bind(this));\n\n            this.reload();\n        },\n\n        /**\n         * Logic to toggle ascend and descend sorting for headers\n         *\n         * @param {KnockoutObservableArray} property\n         */\n        sortByHeader: function (property) {\n            var ascend,\n                activeLabel,\n                allLabels,\n                placeholder;\n\n            if (property().name === 'actions') {\n                return;\n            }\n\n            if (property().columnsHeaderClasses) {\n                activeLabel = $.extend({}, property());\n                activeLabel.columnsHeaderClasses =\n                    property().columnsHeaderClasses === '_ascend' ? '_descend' : '_ascend';\n                ascend = activeLabel.columnsHeaderClasses === '_ascend';\n                property(activeLabel);\n            } else {\n                allLabels = this.labels().slice();\n                allLabels.forEach(function (label) {\n\n                    if (label.name === property().name) {\n                        label.columnsHeaderClasses = '_ascend';\n                    } else {\n                        label.columnsHeaderClasses = '';\n                    }\n                });\n                ascend = true;\n                this.labels(allLabels);\n            }\n\n            if (this.recordData().length) {\n                placeholder = this.emptyContentPlaceholder;\n\n                this.emptyContentPlaceholder = false;\n                this.sortRecord(property().name, ascend);\n                this.reload();\n                this.emptyContentPlaceholder = placeholder;\n            }\n        },\n\n        /**\n         * Sorting of dynamic row records.\n         *\n         * @param {String} sortBy\n         * @param {Boolean} ascend\n         */\n        sortRecord: function (sortBy, ascend) {\n            this.recordData.sort(function (left, right) {\n                var record1 = ascend ? left : right,\n                    record2 = ascend ? right : left;\n\n                record1 = sortValueValidator(record1[sortBy]);\n                record2 = sortValueValidator(record2[sortBy]);\n\n                return record1 === record2 ? 0 : record1 < record2 ? -1 : 1;\n            });\n        },\n\n        /** @inheritdoc */\n        destroy: function () {\n            this._super();\n            Events.off(this.name);\n        }\n    });\n});\n","Magento_PageBuilder/js/types/text.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  \"use strict\";\n});\n//# sourceMappingURL=text.js.map","Magento_PageBuilder/js/panel/menu.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"knockout\"], function (_knockout) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var Menu = /*#__PURE__*/function () {\n    \"use strict\";\n\n    /**\n     * Menu constructor\n     *\n     * @param id\n     * @param menu\n     * @param contentTypes\n     * @param stageId\n     */\n    function Menu(id, menu, contentTypes, stageId) {\n      if (contentTypes === void 0) {\n        contentTypes = [];\n      }\n\n      this.hidden = _knockout.observable(false);\n      this.id = _knockout.observable();\n      this.code = _knockout.observable(\"\");\n      this.label = _knockout.observable(\"\");\n      this.icon = _knockout.observable(\"\");\n      this.sort = _knockout.observable();\n      this.contentTypes = _knockout.observableArray([]);\n      this.active = _knockout.observable(false);\n      this.id(id);\n      this.code(menu.code);\n      this.label(menu.label);\n      this.icon(menu.icon);\n      this.sort(menu.sort);\n      this.contentTypes(contentTypes);\n      this.stageId = stageId;\n    }\n    /**\n     * Toggle the menu\n     */\n\n\n    var _proto = Menu.prototype;\n\n    _proto.toggle = function toggle() {\n      this.active(!this.active());\n    };\n\n    return Menu;\n  }();\n\n  return {\n    Menu: Menu\n  };\n});\n//# sourceMappingURL=menu.js.map","Magento_PageBuilder/js/panel/menu/content-type.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"knockout\", \"Magento_PageBuilder/js/drag-drop/matrix\"], function (_knockout, _matrix) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var ContentType = /*#__PURE__*/function () {\n    \"use strict\";\n\n    /**\n     * @param {string} identifier\n     * @param {ContentTypeConfigInterface} config\n     * @param {string} stageId\n     */\n    function ContentType(identifier, config, stageId) {\n      this.droppable = true;\n      this.icon = _knockout.observable(\"\");\n      this.identifier = _knockout.observable(\"\");\n      this.label = _knockout.observable(\"\");\n      this.config = config;\n      this.identifier(identifier);\n      this.label(config.label);\n      this.icon(config.icon);\n      this.stageId = stageId;\n    }\n    /**\n     * Retrieve the config object\n     *\n     * @returns {ContentTypeConfigInterface}\n     */\n\n\n    var _proto = ContentType.prototype;\n\n    _proto.getConfig = function getConfig() {\n      return this.config;\n    }\n    /**\n     * Only connect to container sortable instances that the current content type is accepted into\n     *\n     * @returns {string}\n     */\n    ;\n\n    _proto.getDraggableOptions = function getDraggableOptions() {\n      return {\n        connectToSortable: (0, _matrix.getAllowedContainersClasses)(this.config.name, this.stageId)\n      };\n    };\n\n    return ContentType;\n  }();\n\n  return {\n    ContentType: ContentType\n  };\n});\n//# sourceMappingURL=content-type.js.map","Magento_PageBuilder/js/widget/show-on-hover.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['jquery'], function ($) {\n    'use strict';\n\n    /**\n     * Show the overlay on hover of specific elements\n     *\n     * @param {JQuery<Element>[]} $elements\n     */\n    function showOverlayOnHover($elements) {\n        $elements.each(function (index, element) {\n            var overlayEl = $(element).find('.pagebuilder-overlay'),\n                overlayColor = overlayEl.attr('data-overlay-color');\n\n            $(element).hover(\n                function () {\n                    overlayEl.css('background-color', overlayColor);\n                },\n                function () {\n                    overlayEl.css('background-color', 'transparent');\n                }\n            );\n        });\n    }\n\n    /**\n     * Show button on hover of specific elements\n     *\n     * @param {JQuery<Element>[]} $elements\n     * @param {String} buttonClass\n     */\n    function showButtonOnHover($elements, buttonClass) {\n        $elements.each(function (index, element) {\n            var buttonEl = $(element).find(buttonClass);\n\n            $(element).hover(\n                function () {\n                    buttonEl.css({\n                        'opacity': '1',\n                        'visibility': 'visible'\n                    });\n                }, function () {\n                    buttonEl.css({\n                        'opacity': '0',\n                        'visibility': 'hidden'\n                    });\n                }\n            );\n        });\n    }\n\n    return function (config) {\n\n        var buttonSelector = config.buttonSelector,\n            overlayHoverSelector = 'div[data-content-type=\"%s\"][data-show-overlay=\"%s\"]'\n                .replace('%s', config.dataRole)\n                .replace('%s', config.showOverlay),\n            overlayButtonSelector = 'div[data-content-type=\"%s\"][data-show-button=\"%s\"]'\n                .replace('%s', config.dataRole)\n                .replace('%s', config.showOverlay);\n\n        showOverlayOnHover($(overlayHoverSelector));\n        showButtonOnHover($(overlayButtonSelector), buttonSelector);\n    };\n});\n","Magento_PageBuilder/js/widget/video-background.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'jarallax',\n    'jarallaxVideo',\n    'vimeoWrapper'\n], function ($) {\n    'use strict';\n\n    return function (config, element) {\n        var $element = $(element),\n            parallaxSpeed = $element.data('enableParallax') !== 1 ? 1 : parseFloat($element.data('parallaxSpeed'));\n\n        if ($element.data('background-type') !== 'video') {\n            return;\n        }\n\n        $element.addClass('jarallax');\n        $element.attr('data-jarallax', '');\n\n        window.jarallax($element[0], {\n            imgSrc: $element.data('videoFallbackSrc'),\n            speed: !isNaN(parallaxSpeed) ? parallaxSpeed : 0.5,\n            videoLoop: $element.data('videoLoop'),\n            videoPlayOnlyVisible: $element.data('videoPlayOnlyVisible'),\n            videoLazyLoading: $element.data('videoLazyLoad'),\n            disableVideo: false,\n            elementInViewport: $element.data('elementInViewport') &&\n                $element[0].querySelector($element.data('elementInViewport'))\n        });\n        $element[0].jarallax.video && $element[0].jarallax.video.on('started', function () {\n            if ($element[0].jarallax.$video) {\n                $element[0].jarallax.$video.style.visibility = 'visible';\n            }\n        });\n    };\n});\n","Magento_PageBuilder/js/converter/converter-pool.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var ConverterPool = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function ConverterPool() {\n      this.converters = {};\n    }\n\n    var _proto = ConverterPool.prototype;\n\n    /**\n     * Retrieve a converter from the pool\n     *\n     * @param {string} name\n     * @returns {ConverterInterface}\n     */\n    _proto.get = function get(name) {\n      return this.converters[name] !== undefined ? this.converters[name] : null;\n    }\n    /**\n     * Register a new converter into the pool\n     *\n     * @param {string} name\n     * @param {ConverterInterface} converter\n     */\n    ;\n\n    _proto.register = function register(name, converter) {\n      this.converters[name] = converter;\n    };\n\n    return ConverterPool;\n  }();\n\n  var _default = new ConverterPool();\n\n  return _default;\n});\n//# sourceMappingURL=converter-pool.js.map","Magento_PageBuilder/js/converter/converter-interface.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  \"use strict\";\n});\n//# sourceMappingURL=converter-interface.js.map","Magento_PageBuilder/js/converter/converter-pool-factory.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _createForOfIteratorHelperLoose(o, allowArrayLike) { var it = typeof Symbol !== \"undefined\" && o[Symbol.iterator] || o[\"@@iterator\"]; if (it) return (it = it.call(o)).next.bind(it); if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === \"number\") { if (it) o = it; var i = 0; return function () { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }; } throw new TypeError(\"Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\ndefine([\"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/utils/loader\", \"Magento_PageBuilder/js/converter/converter-pool\"], function (_config, _loader, _converterPool) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Create a new instance of converter pool\n   */\n  function create(contentType) {\n    var config = _config.getContentTypeConfig(contentType);\n\n    var converters = [];\n    var appearanceName;\n\n    for (var _i = 0, _Object$keys = Object.keys(config.appearances); _i < _Object$keys.length; _i++) {\n      appearanceName = _Object$keys[_i];\n      var appearance = config.appearances[appearanceName];\n\n      if (appearance !== undefined && appearance.elements !== undefined) {\n        var elementName = void 0;\n\n        for (var _i2 = 0, _Object$keys2 = Object.keys(appearance.elements); _i2 < _Object$keys2.length; _i2++) {\n          elementName = _Object$keys2[_i2];\n\n          if (appearance.elements[elementName].style !== undefined) {\n            for (var _iterator = _createForOfIteratorHelperLoose(appearance.elements[elementName].style), _step; !(_step = _iterator()).done;) {\n              var propertyConfig = _step.value;\n\n              if (!!propertyConfig.converter && converters.indexOf(propertyConfig.converter) === -1 && !_converterPool.get(propertyConfig.converter)) {\n                converters.push(propertyConfig.converter);\n              }\n\n              if (!!propertyConfig.preview_converter && converters.indexOf(propertyConfig.preview_converter) === -1 && !_converterPool.get(propertyConfig.preview_converter)) {\n                converters.push(propertyConfig.preview_converter);\n              }\n            }\n          }\n\n          if (appearance.elements[elementName].attributes !== undefined) {\n            for (var _iterator2 = _createForOfIteratorHelperLoose(appearance.elements[elementName].attributes), _step2; !(_step2 = _iterator2()).done;) {\n              var attributeConfig = _step2.value;\n\n              if (!!attributeConfig.converter && converters.indexOf(attributeConfig.converter) === -1 && !_converterPool.get(attributeConfig.converter)) {\n                converters.push(attributeConfig.converter);\n              }\n\n              if (!!attributeConfig.preview_converter && converters.indexOf(attributeConfig.preview_converter) === -1 && !_converterPool.get(attributeConfig.preview_converter)) {\n                converters.push(attributeConfig.preview_converter);\n              }\n            }\n          }\n\n          if (appearance.elements[elementName].html !== undefined) {\n            var htmlConfig = appearance.elements[elementName].html;\n\n            if (!!htmlConfig.converter && converters.indexOf(htmlConfig.converter) === -1 && !_converterPool.get(htmlConfig.converter)) {\n              converters.push(htmlConfig.converter);\n            }\n\n            if (!!htmlConfig.preview_converter && converters.indexOf(htmlConfig.preview_converter) === -1 && !_converterPool.get(htmlConfig.preview_converter)) {\n              converters.push(htmlConfig.preview_converter);\n            }\n          }\n        }\n      }\n    }\n\n    return new Promise(function (resolve) {\n      (0, _loader)(converters, function () {\n        for (var _len = arguments.length, loadedConverters = new Array(_len), _key = 0; _key < _len; _key++) {\n          loadedConverters[_key] = arguments[_key];\n        }\n\n        for (var i = 0; i < converters.length; i++) {\n          _converterPool.register(converters[i], new loadedConverters[i]());\n        }\n\n        resolve(_converterPool);\n      });\n    });\n  }\n\n  return create;\n});\n//# sourceMappingURL=converter-pool-factory.js.map","Magento_PageBuilder/js/converter/attribute/link-type.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var CreateValueForLinkType = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function CreateValueForLinkType() {}\n\n    var _proto = CreateValueForLinkType.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n      return value && value.type ? value.type : \"default\";\n    };\n\n    return CreateValueForLinkType;\n  }();\n\n  return CreateValueForLinkType;\n});\n//# sourceMappingURL=link-type.js.map","Magento_PageBuilder/js/converter/attribute/video-overlay-color.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var OverlayColor = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function OverlayColor() {}\n\n    var _proto = OverlayColor.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value === \"transparent\" ? \"\" : value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      if (data.video_overlay_color) {\n        return data.video_overlay_color.toString();\n      }\n\n      return \"\";\n    };\n\n    return OverlayColor;\n  }();\n\n  return OverlayColor;\n});\n//# sourceMappingURL=video-overlay-color.js.map","Magento_PageBuilder/js/converter/attribute/link-href.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var CreateValueForHref = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function CreateValueForHref() {\n      this.widgetParamsByLinkType = {\n        category: {\n          type: \"Magento\\\\Catalog\\\\Block\\\\Category\\\\Widget\\\\Link\",\n          id_path: \"category/:href\",\n          template: \"Magento_PageBuilder::widget/link_href.phtml\",\n          type_name: \"Catalog Category Link\"\n        },\n        product: {\n          type: \"Magento\\\\Catalog\\\\Block\\\\Product\\\\Widget\\\\Link\",\n          id_path: \"product/:href\",\n          template: \"Magento_PageBuilder::widget/link_href.phtml\",\n          type_name: \"Catalog Product Link\"\n        },\n        page: {\n          type: \"Magento\\\\Cms\\\\Block\\\\Widget\\\\Page\\\\Link\",\n          page_id: \":href\",\n          template: \"Magento_PageBuilder::widget/link_href.phtml\",\n          type_name: \"CMS Page Link\"\n        }\n      };\n    }\n\n    var _proto = CreateValueForHref.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var link = (0, _object.get)(data, name);\n      var href = \"\";\n\n      if (!link) {\n        return href;\n      }\n\n      var linkType = link.type;\n      var isHrefId = !isNaN(parseInt(link[linkType], 10));\n\n      if (isHrefId && link) {\n        href = this.convertToWidget(link[linkType], linkType);\n      } else if (typeof link[linkType] === \"string\") {\n        href = link[linkType];\n      }\n\n      return href;\n    }\n    /**\n     * @param {string} href\n     * @param {string} linkType\n     * @returns {string}\n     */\n    ;\n\n    _proto.convertToWidget = function convertToWidget(href, linkType) {\n      if (!href || !this.widgetParamsByLinkType[linkType]) {\n        return href;\n      }\n\n      var attributesString = _underscore.map(this.widgetParamsByLinkType[linkType], function (val, key) {\n        return key + \"='\" + val.replace(\":href\", href) + \"'\";\n      }).join(\" \");\n\n      return \"{{widget \" + attributesString + \" }}\";\n    };\n\n    return CreateValueForHref;\n  }();\n\n  return CreateValueForHref;\n});\n//# sourceMappingURL=link-href.js.map","Magento_PageBuilder/js/converter/attribute/link-target.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var CreateValueForTarget = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function CreateValueForTarget() {}\n\n    var _proto = CreateValueForTarget.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n\n      if (!value) {\n        return \"\";\n      }\n\n      return value.setting ? \"_blank\" : \"\";\n    };\n\n    return CreateValueForTarget;\n  }();\n\n  return CreateValueForTarget;\n});\n//# sourceMappingURL=link-target.js.map","Magento_PageBuilder/js/converter/attribute/src.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/utils/image\", \"Magento_PageBuilder/js/utils/object\", \"Magento_PageBuilder/js/utils/url\"], function (_config, _image, _object, _url) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Src = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Src() {}\n\n    var _proto = Src.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      if (!value) {\n        return \"\";\n      }\n\n      return (0, _image.decodeUrl)(value);\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n\n      if (value[0] === undefined || value[0].url === undefined) {\n        return \"\";\n      }\n\n      var imageUrl = value[0].url;\n      var mediaUrl = (0, _url.convertUrlToPathIfOtherUrlIsOnlyAPath)(_config.getConfig(\"media_url\"), imageUrl);\n      var mediaPath = imageUrl.split(mediaUrl);\n      return \"{{media url=\" + mediaPath[1] + \"}}\";\n    };\n\n    return Src;\n  }();\n\n  return Src;\n});\n//# sourceMappingURL=src.js.map","Magento_PageBuilder/js/converter/attribute/preview/store-id.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\"], function (_jquery) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var StoreId = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function StoreId() {}\n\n    var _proto = StoreId.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      if (typeof data[name] !== \"string\") {\n        return \"\";\n      }\n\n      var storeId = (0, _jquery)('[data-role=\"store-view-id\"]').val() || \"0\";\n      return data[name].replace(/}}$/, \" store_id=\\\"\" + storeId + \"\\\"}}\");\n    };\n\n    return StoreId;\n  }();\n\n  return StoreId;\n});\n//# sourceMappingURL=store-id.js.map","Magento_PageBuilder/js/converter/attribute/preview/src.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Src = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Src() {}\n\n    var _proto = Src.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n\n      if (value && typeof value[0] === \"object\") {\n        return value[0].url;\n      }\n\n      return \"\";\n    };\n\n    return Src;\n  }();\n\n  return Src;\n});\n//# sourceMappingURL=src.js.map","Magento_PageBuilder/js/converter/html/decode.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/directives\", \"Magento_PageBuilder/js/utils/object\"], function (_directives, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Decode = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Decode() {}\n\n    var _proto = Decode.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param {string} value\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      // Convert the encoded string back to HTML without executing\n      var html = new DOMParser().parseFromString(value, \"text/html\");\n      return html.body.textContent;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {Object} data\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      return (0, _directives.removeQuotesInMediaDirectives)((0, _object.get)(data, name));\n    };\n\n    return Decode;\n  }();\n\n  return Decode;\n});\n//# sourceMappingURL=decode.js.map","Magento_PageBuilder/js/converter/html/tag-escaper.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var TagEscaper = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function TagEscaper() {}\n\n    var _proto = TagEscaper.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param {string} value\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      var result = (0, _underscore.unescape)(value); // Have to do a manual &nbsp; replace since underscore un-escape does not un-escape &nbsp;\n\n      return result.replace(/&nbsp;/g, String.fromCharCode(160));\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {Object} data\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      return (0, _underscore.escape)((0, _object.get)(data, name));\n    };\n\n    return TagEscaper;\n  }();\n\n  return TagEscaper;\n});\n//# sourceMappingURL=tag-escaper.js.map","Magento_PageBuilder/js/converter/html/directive.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/directives\", \"Magento_PageBuilder/js/utils/editor\", \"Magento_PageBuilder/js/utils/object\"], function (_directives, _editor, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Directives = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Directives() {}\n\n    var _proto = Directives.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param {string} value\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {Object} data\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      return (0, _editor.encodeContent)((0, _directives.convertMediaDirectivesToUrls)((0, _directives.removeQuotesInMediaDirectives)((0, _object.get)(data, name))));\n    };\n\n    return Directives;\n  }();\n\n  return Directives;\n});\n//# sourceMappingURL=directive.js.map","Magento_PageBuilder/js/converter/style/border-style.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var BorderStyleDefault = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function BorderStyleDefault() {}\n\n    var _proto = BorderStyleDefault.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      if (!value) {\n        return \"_default\";\n      }\n\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n\n      if (value && value !== \"_default\") {\n        return value;\n      }\n    };\n\n    return BorderStyleDefault;\n  }();\n\n  return BorderStyleDefault;\n});\n//# sourceMappingURL=border-style.js.map","Magento_PageBuilder/js/converter/style/display.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Display = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Display() {}\n\n    var _proto = Display.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return !(value === \"none\");\n    }\n    /**\n     * Convert value to knockout format, we only provide a none property if we intend for the content type to be hidden,\n     * otherwise we let the original display property handle the display of the content type.\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n\n      if (!_underscore.isUndefined(value) && value === false) {\n        return \"none\";\n      }\n\n      return;\n    };\n\n    return Display;\n  }();\n\n  return Display;\n});\n//# sourceMappingURL=display.js.map","Magento_PageBuilder/js/converter/style/background-image.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var BackgroundImage = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function BackgroundImage() {}\n\n    var _proto = BackgroundImage.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return null;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      return null;\n    };\n\n    return BackgroundImage;\n  }();\n\n  return BackgroundImage;\n});\n//# sourceMappingURL=background-image.js.map","Magento_PageBuilder/js/converter/style/overlay-border-radius.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Takes difference of border width from border radius to conform snugly to edges of wrapper border\n   *\n   * @api\n   */\n  var OverlayBorderRadius = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function OverlayBorderRadius() {}\n\n    var _proto = OverlayBorderRadius.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var borderRadius = data.border_radius ? parseInt(data.border_radius, 10) : 0;\n      var borderWidth = data.border_width ? parseInt(data.border_width, 10) : 0;\n\n      if (borderRadius <= borderWidth) {\n        return \"0\";\n      }\n\n      return borderRadius - borderWidth + \"px\";\n    };\n\n    return OverlayBorderRadius;\n  }();\n\n  return OverlayBorderRadius;\n});\n//# sourceMappingURL=overlay-border-radius.js.map","Magento_PageBuilder/js/converter/style/paddings.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Paddings = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Paddings() {}\n\n    var _proto = Paddings.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      if (undefined !== value.padding) {\n        return {\n          padding: {\n            top: value.padding.top.replace(\"px\", \"\"),\n            left: value.padding.left.replace(\"px\", \"\"),\n            right: value.padding.right.replace(\"px\", \"\"),\n            bottom: value.padding.bottom.replace(\"px\", \"\")\n          }\n        };\n      }\n\n      return {};\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var result = {};\n      var value = (0, _object.get)(data, name);\n\n      if (value && _underscore.isString(value)) {\n        value = JSON.parse(value);\n      }\n\n      if (value && undefined !== value.padding) {\n        result.paddingLeft = value.padding.left ? value.padding.left + \"px\" : \"\";\n        result.paddingTop = value.padding.top ? value.padding.top + \"px\" : \"\";\n        result.paddingRight = value.padding.right ? value.padding.right + \"px\" : \"\";\n        result.paddingBottom = value.padding.bottom ? value.padding.bottom + \"px\" : \"\";\n      }\n\n      return result;\n    };\n\n    return Paddings;\n  }();\n\n  return Paddings;\n});\n//# sourceMappingURL=paddings.js.map","Magento_PageBuilder/js/converter/style/color.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Color = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Color() {}\n\n    var _proto = Color.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      if (value === \"default\" || value === \"initial\" || value === \"\") {\n        value = \"\";\n      } else {\n        var regexp = /(\\d{0,3}),\\s(\\d{0,3}),\\s(\\d{0,3})/;\n        var matches = regexp.exec(value);\n\n        if (matches) {\n          value = \"#\" + this.fromIntToHex(parseInt(matches[1], 10)) + this.fromIntToHex(parseInt(matches[2], 10)) + this.fromIntToHex(parseInt(matches[3], 10));\n        }\n      }\n\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      return (0, _object.get)(data, name, \"\");\n    }\n    /**\n     * Convert from int to hex\n     *\n     * @param {number} value\n     * @returns {string}\n     */\n    ;\n\n    _proto.fromIntToHex = function fromIntToHex(value) {\n      var hex = value.toString(16);\n      return hex.length === 1 ? \"0\" + hex : hex;\n    };\n\n    return Color;\n  }();\n\n  return Color;\n});\n//# sourceMappingURL=color.js.map","Magento_PageBuilder/js/converter/style/video-overlay-color.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var VideoOverlayColor = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function VideoOverlayColor() {}\n\n    var _proto = VideoOverlayColor.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n\n      if (value !== \"\" && value !== undefined) {\n        return value;\n      }\n\n      return \"transparent\";\n    };\n\n    return VideoOverlayColor;\n  }();\n\n  return VideoOverlayColor;\n});\n//# sourceMappingURL=video-overlay-color.js.map","Magento_PageBuilder/js/converter/style/border-width.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var BorderWidth = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function BorderWidth() {}\n\n    var _proto = BorderWidth.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value === \"initial\" ? \"\" : value.replace(\"px\", \"\");\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n\n      if (value) {\n        return value + \"px\";\n      }\n    };\n\n    return BorderWidth;\n  }();\n\n  return BorderWidth;\n});\n//# sourceMappingURL=border-width.js.map","Magento_PageBuilder/js/converter/style/margins.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Margins = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Margins() {}\n\n    var _proto = Margins.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      if (undefined !== value.margin) {\n        return {\n          margin: {\n            top: value.margin.top.replace(\"px\", \"\"),\n            left: value.margin.left.replace(\"px\", \"\"),\n            right: value.margin.right.replace(\"px\", \"\"),\n            bottom: value.margin.bottom.replace(\"px\", \"\")\n          }\n        };\n      }\n\n      return {};\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var result = {};\n      var value = (0, _object.get)(data, name);\n\n      if (value && _underscore.isString(value)) {\n        value = JSON.parse(value);\n      }\n\n      if (value && undefined !== value.margin) {\n        result.marginLeft = value.margin.left ? value.margin.left + \"px\" : \"\";\n        result.marginTop = value.margin.top ? value.margin.top + \"px\" : \"\";\n        result.marginRight = value.margin.right ? value.margin.right + \"px\" : \"\";\n        result.marginBottom = value.margin.bottom ? value.margin.bottom + \"px\" : \"\";\n      }\n\n      return result;\n    };\n\n    return Margins;\n  }();\n\n  return Margins;\n});\n//# sourceMappingURL=margins.js.map","Magento_PageBuilder/js/converter/style/remove-px.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var RemovePx = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function RemovePx() {}\n\n    var _proto = RemovePx.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value.replace(\"px\", \"\");\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n\n      if (value) {\n        return value + \"px\";\n      }\n    };\n\n    return RemovePx;\n  }();\n\n  return RemovePx;\n});\n//# sourceMappingURL=remove-px.js.map","Magento_PageBuilder/js/converter/style/min-height.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var MinHeight = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function MinHeight() {}\n\n    var _proto = MinHeight.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value.indexOf(\"calc\") !== -1 ? value.substring(5, value.length - 1) : value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n      return value.split(/\\+|\\-|\\*|\\//).length > 1 ? \"calc(\" + (0, _object.get)(data, name) + \")\" : value;\n    };\n\n    return MinHeight;\n  }();\n\n  return MinHeight;\n});\n//# sourceMappingURL=min-height.js.map","Magento_PageBuilder/js/converter/style/width.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Subtract margin from width to ensure adjacent elements do not\n   * move or resize when positive or negative margins are present\n   *\n   * @api\n   */\n  var Width = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Width() {}\n\n    var _proto = Width.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      if (value.indexOf(\"calc\") !== -1) {\n        return value.split(\"%\")[0].split(\"(\")[1] + \"%\";\n      }\n\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      if (data[name] && data[name] !== \"\") {\n        var marginsAndPadding = data.margins_and_padding || {};\n        var margins = marginsAndPadding.margin || \"\";\n        var marginLeft = margins.left ? parseInt(margins.left, 10) : 0;\n        var marginRight = margins.right ? parseInt(margins.right, 10) : 0;\n\n        if (marginLeft === 0 && marginRight === 0) {\n          return data[name].toString();\n        }\n\n        return \"calc(\" + data[name].toString() + \" - \" + (marginLeft + marginRight) + \"px)\";\n      }\n    };\n\n    return Width;\n  }();\n\n  return Width;\n});\n//# sourceMappingURL=width.js.map","Magento_PageBuilder/js/converter/style/preview/display.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Display = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Display() {}\n\n    var _proto = Display.prototype;\n\n    /**\n     * Ensure the display none property doesn't persist to the preview\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return;\n    }\n    /**\n     * Ensure the display none property doesn't persist to the preview\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      return;\n    };\n\n    return Display;\n  }();\n\n  return Display;\n});\n//# sourceMappingURL=display.js.map","Magento_PageBuilder/js/converter/style/preview/background-image.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var BackgroundImage = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function BackgroundImage() {}\n\n    var _proto = BackgroundImage.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n\n      if (value && typeof value[0] === \"object\") {\n        return \"url(\" + value[0].url + \")\";\n      }\n\n      return \"\";\n    };\n\n    return BackgroundImage;\n  }();\n\n  return BackgroundImage;\n});\n//# sourceMappingURL=background-image.js.map","Magento_PageBuilder/js/property/attribute-reader.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var AttributeReader = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function AttributeReader() {}\n\n    var _proto = AttributeReader.prototype;\n\n    /**\n     * Read attribute from element\n     *\n     * @param {HTMLElement} element\n     * @param {string} source\n     * @returns {string | object}\n     */\n    _proto.read = function read(element, source) {\n      return element.getAttribute(source);\n    };\n\n    return AttributeReader;\n  }();\n\n  return AttributeReader;\n});\n//# sourceMappingURL=attribute-reader.js.map","Magento_PageBuilder/js/property/property-reader-pool.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var PropertyReaderPool = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function PropertyReaderPool() {\n      this.propertyReaders = {};\n    }\n\n    var _proto = PropertyReaderPool.prototype;\n\n    /**\n     * Retrieve a property reader from the pool\n     *\n     * @param {string} name\n     * @returns {PropertyReaderInterface}\n     */\n    _proto.get = function get(name) {\n      return this.propertyReaders[name] !== undefined ? this.propertyReaders[name] : null;\n    }\n    /**\n     * Register a new property reader into the pool\n     *\n     * @param {string} name\n     * @param {PropertyReaderInterface} property\n     */\n    ;\n\n    _proto.register = function register(name, property) {\n      this.propertyReaders[name] = property;\n    };\n\n    return PropertyReaderPool;\n  }();\n\n  var _default = new PropertyReaderPool();\n\n  return Object.assign(_default, {\n    PropertyReaderPool: PropertyReaderPool\n  });\n});\n//# sourceMappingURL=property-reader-pool.js.map","Magento_PageBuilder/js/property/link.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Link = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Link() {\n      this.regexpByLinkType = {\n        category: new RegExp(/id_path=['\"]category\\/(\\d+)/),\n        product: new RegExp(/id_path=['\"]product\\/(\\d+)/),\n        page: new RegExp(/page_id=['\"](\\d+)/)\n      };\n    }\n\n    var _proto = Link.prototype;\n\n    /**\n     * Read link from element\n     *\n     * @param {HTMLElement} element\n     * @returns {string | object}\n     */\n    _proto.read = function read(element) {\n      var _ref;\n\n      var href = element.getAttribute(\"href\");\n      var attributeLinkType = element.getAttribute(\"data-link-type\");\n\n      if (typeof href === \"string\" && attributeLinkType !== \"default\") {\n        href = this.getIdFromWidgetSyntax(href, this.regexpByLinkType[attributeLinkType]);\n      }\n\n      return _ref = {}, _ref[attributeLinkType] = href, _ref.setting = element.getAttribute(\"target\") === \"_blank\", _ref.type = attributeLinkType, _ref;\n    }\n    /**\n     * Returns link value from widget string\n     *\n     * @param {string} href\n     * @param {RegExp} regexp\n     * @return {string}\n     */\n    ;\n\n    _proto.getIdFromWidgetSyntax = function getIdFromWidgetSyntax(href, regexp) {\n      var attributeIdMatches = href.match(regexp);\n\n      if (!attributeIdMatches) {\n        return href;\n      }\n\n      return attributeIdMatches[1];\n    };\n\n    return Link;\n  }();\n\n  return Link;\n});\n//# sourceMappingURL=link.js.map","Magento_PageBuilder/js/property/property-reader-interface.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  \"use strict\";\n});\n//# sourceMappingURL=property-reader-interface.js.map","Magento_PageBuilder/js/property/paddings.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Paddings = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Paddings() {}\n\n    var _proto = Paddings.prototype;\n\n    /**\n     * Read paddings from element\n     *\n     * @param {HTMLElement} element\n     * @returns {string | object}\n     */\n    _proto.read = function read(element) {\n      return {\n        padding: {\n          left: element.style.paddingLeft,\n          top: element.style.paddingTop,\n          right: element.style.paddingRight,\n          bottom: element.style.paddingBottom\n        }\n      };\n    };\n\n    return Paddings;\n  }();\n\n  return Paddings;\n});\n//# sourceMappingURL=paddings.js.map","Magento_PageBuilder/js/property/style-property-reader.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/string\"], function (_string) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var StylePropertyReader = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function StylePropertyReader() {}\n\n    var _proto = StylePropertyReader.prototype;\n\n    /**\n     * Read style property from element\n     *\n     * @param {HTMLElement} element\n     * @param {string} source\n     * @returns {string | object}\n     */\n    _proto.read = function read(element, source) {\n      var camelCasedSource = (0, _string.fromSnakeToCamelCase)(source);\n      return element.style[camelCasedSource];\n    };\n\n    return StylePropertyReader;\n  }();\n\n  return StylePropertyReader;\n});\n//# sourceMappingURL=style-property-reader.js.map","Magento_PageBuilder/js/property/margins.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Margins = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Margins() {}\n\n    var _proto = Margins.prototype;\n\n    /**\n     * Read margins from element\n     *\n     * @param {HTMLElement} element\n     * @returns {string | object}\n     */\n    _proto.read = function read(element) {\n      return {\n        margin: {\n          left: element.style.marginLeft,\n          top: element.style.marginTop,\n          right: element.style.marginRight,\n          bottom: element.style.marginBottom\n        }\n      };\n    };\n\n    return Margins;\n  }();\n\n  return Margins;\n});\n//# sourceMappingURL=margins.js.map","Magento_PageBuilder/js/property/property-reader-pool-factory.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _createForOfIteratorHelperLoose(o, allowArrayLike) { var it = typeof Symbol !== \"undefined\" && o[Symbol.iterator] || o[\"@@iterator\"]; if (it) return (it = it.call(o)).next.bind(it); if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === \"number\") { if (it) o = it; var i = 0; return function () { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }; } throw new TypeError(\"Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\ndefine([\"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/utils/loader\", \"Magento_PageBuilder/js/property/property-reader-pool\"], function (_config, _loader, _propertyReaderPool) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Create a new instance of property reader pool\n   */\n  function create(contentType) {\n    var config = _config.getContentTypeConfig(contentType);\n\n    var propertyReaders = [];\n    var appearanceName;\n\n    for (var _i = 0, _Object$keys = Object.keys(config.appearances); _i < _Object$keys.length; _i++) {\n      appearanceName = _Object$keys[_i];\n      var appearance = config.appearances[appearanceName];\n\n      if (appearance !== undefined && appearance.elements !== undefined) {\n        var elementName = void 0;\n\n        for (var _i2 = 0, _Object$keys2 = Object.keys(appearance.elements); _i2 < _Object$keys2.length; _i2++) {\n          elementName = _Object$keys2[_i2];\n          var element = appearance.elements[elementName];\n\n          if (element.style !== undefined) {\n            for (var _iterator = _createForOfIteratorHelperLoose(element.style), _step; !(_step = _iterator()).done;) {\n              var propertyConfig = _step.value;\n\n              if (propertyConfig.reader && propertyReaders.indexOf(propertyConfig.reader) === -1 && !_propertyReaderPool.get(propertyConfig.reader)) {\n                propertyReaders.push(propertyConfig.reader);\n              }\n            }\n          }\n\n          if (element.attributes !== undefined) {\n            for (var _iterator2 = _createForOfIteratorHelperLoose(element.attributes), _step2; !(_step2 = _iterator2()).done;) {\n              var attributeConfig = _step2.value;\n\n              if (attributeConfig.reader && propertyReaders.indexOf(attributeConfig.reader) === -1 && !_propertyReaderPool.get(attributeConfig.reader)) {\n                propertyReaders.push(attributeConfig.reader);\n              }\n            }\n          }\n        }\n      }\n    }\n\n    return new Promise(function (resolve) {\n      (0, _loader)(propertyReaders, function () {\n        for (var _len = arguments.length, loadedPropertyReaders = new Array(_len), _key = 0; _key < _len; _key++) {\n          loadedPropertyReaders[_key] = arguments[_key];\n        }\n\n        for (var i = 0; i < propertyReaders.length; i++) {\n          _propertyReaderPool.register(propertyReaders[i], new loadedPropertyReaders[i]());\n        }\n\n        resolve(_propertyReaderPool);\n      });\n    });\n  }\n\n  return create;\n});\n//# sourceMappingURL=property-reader-pool-factory.js.map","Magento_PageBuilder/js/mass-converter/background-type.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var BackgroundType = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function BackgroundType() {}\n\n    var _proto = BackgroundType.prototype;\n\n    /**\n     * Process data after it's read and converted by element converters\n     *\n     * @param {ConverterDataInterface} data\n     * @param {ConverterConfigInterface} config\n     * @returns {object}\n     */\n    _proto.fromDom = function fromDom(data, config) {\n      return data;\n    }\n    /**\n     * Process data before it's converted by element converters\n     *\n     * @param {ConverterDataInterface} data\n     * @param {ConverterConfigInterface} config\n     * @returns {object}\n     */\n    ;\n\n    _proto.toDom = function toDom(data, config) {\n      var backgroundType = (0, _object.get)(data, config.attribute_name);\n\n      if (backgroundType === \"video\") {\n        (0, _object.set)(data, config.desktop_image_variable, []);\n        (0, _object.set)(data, config.mobile_image_variable, []);\n      } else if (backgroundType === \"image\") {\n        (0, _object.set)(data, config.video_source_variable, null);\n        (0, _object.set)(data, config.video_fallback_image_variable, []);\n        (0, _object.set)(data, config.video_overlay_color_variable, \"\");\n      }\n\n      return data;\n    };\n\n    return BackgroundType;\n  }();\n\n  return BackgroundType;\n});\n//# sourceMappingURL=background-type.js.map","Magento_PageBuilder/js/mass-converter/empty-mobile-image.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var EmptyMobileImage = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function EmptyMobileImage() {}\n\n    var _proto = EmptyMobileImage.prototype;\n\n    /**\n     * Process data after it's read and converted by element converters\n     *\n     * @param {ConverterDataInterface} data\n     * @param {object} config\n     * @returns {object}\n     */\n    _proto.fromDom = function fromDom(data, config) {\n      var desktopImage = (0, _object.get)(data, config.desktop_image_variable);\n      var mobileImage = (0, _object.get)(data, config.mobile_image_variable);\n\n      if (mobileImage && desktopImage && mobileImage[0] !== undefined && desktopImage[0] !== undefined && mobileImage[0].url === desktopImage[0].url) {\n        delete data[config.mobile_image_variable];\n      }\n\n      return data;\n    }\n    /**\n     * Process data before it's converted by element converters\n     *\n     * @param {ConverterDataInterface} data\n     * @param {object} config\n     * @returns {object}\n     */\n    ;\n\n    _proto.toDom = function toDom(data, config) {\n      var mobileImage = (0, _object.get)(data, config.mobile_image_variable);\n\n      if (mobileImage === undefined || mobileImage[0] === undefined) {\n        (0, _object.set)(data, config.mobile_image_variable, (0, _object.get)(data, config.desktop_image_variable));\n      }\n\n      return data;\n    };\n\n    return EmptyMobileImage;\n  }();\n\n  return EmptyMobileImage;\n});\n//# sourceMappingURL=empty-mobile-image.js.map","Magento_PageBuilder/js/mass-converter/converter-pool.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var DataConverterPool = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function DataConverterPool() {\n      this.converters = {};\n    }\n\n    var _proto = DataConverterPool.prototype;\n\n    /**\n     * Retrieve a data converter instance from the pool\n     *\n     * @param {string} name\n     * @returns {ConverterInterface}\n     */\n    _proto.get = function get(name) {\n      return this.converters[name] !== undefined ? this.converters[name] : null;\n    }\n    /**\n     * Register a new data converter into the pool\n     *\n     * @param {string} name\n     * @param {ConverterInterface} converter\n     */\n    ;\n\n    _proto.register = function register(name, converter) {\n      this.converters[name] = converter;\n    };\n\n    return DataConverterPool;\n  }();\n\n  var _default = new DataConverterPool();\n\n  return _default;\n});\n//# sourceMappingURL=converter-pool.js.map","Magento_PageBuilder/js/mass-converter/background-images.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/image\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _image, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var BackgroundImages = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function BackgroundImages() {}\n\n    var _proto = BackgroundImages.prototype;\n\n    /**\n     * Process data after it's read and converted by element converters\n     *\n     * @param {ConverterDataInterface} data\n     * @param {ConverterConfigInterface} config\n     * @returns {object}\n     */\n    _proto.fromDom = function fromDom(data, config) {\n      var directive = (0, _object.get)(data, config.attribute_name);\n\n      if (directive) {\n        var images = JSON.parse(directive.replace(/\\\\(.)/mg, \"$1\")) || {};\n\n        if (!_underscore.isUndefined(images.desktop_image)) {\n          (0, _object.set)(data, config.desktop_image_variable, (0, _image.decodeUrl)(images.desktop_image));\n        }\n\n        if (!_underscore.isUndefined(images.mobile_image)) {\n          (0, _object.set)(data, config.mobile_image_variable, (0, _image.decodeUrl)(images.mobile_image));\n        }\n\n        delete data[config.attribute_name];\n      }\n\n      return data;\n    }\n    /**\n     * Process data before it's converted by element converters\n     *\n     * @param {ConverterDataInterface} data\n     * @param {ConverterConfigInterface} config\n     * @returns {object}\n     */\n    ;\n\n    _proto.toDom = function toDom(data, config) {\n      var desktopImage = (0, _object.get)(data, config.desktop_image_variable);\n      var mobileImage = (0, _object.get)(data, config.mobile_image_variable);\n      var directiveData = {};\n\n      if (!_underscore.isUndefined(desktopImage) && desktopImage && !_underscore.isUndefined(desktopImage[0])) {\n        directiveData.desktop_image = (0, _image.urlToDirective)(desktopImage[0].url);\n      }\n\n      if (!_underscore.isUndefined(mobileImage) && mobileImage && !_underscore.isUndefined(mobileImage[0])) {\n        directiveData.mobile_image = (0, _image.urlToDirective)(mobileImage[0].url);\n      } // Add the directive data, ensuring we escape double quotes\n\n\n      (0, _object.set)(data, config.attribute_name, JSON.stringify(directiveData).replace(/[\\\\\"']/g, \"\\\\$&\").replace(/\\u0000/g, \"\\\\0\"));\n      return data;\n    };\n\n    return BackgroundImages;\n  }();\n\n  return BackgroundImages;\n});\n//# sourceMappingURL=background-images.js.map","Magento_PageBuilder/js/mass-converter/converter-interface.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  \"use strict\";\n});\n//# sourceMappingURL=converter-interface.js.map","Magento_PageBuilder/js/mass-converter/widget-directive-abstract.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var WidgetDirectiveAbstract = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function WidgetDirectiveAbstract() {}\n\n    var _proto = WidgetDirectiveAbstract.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param {ConverterDataInterface} data\n     * @param {ConverterConfigInterface} config\n     * @returns {WidgetDirectiveAttributes}\n     */\n    _proto.fromDom = function fromDom(data, config) {\n      var _this = this;\n\n      var attributes = {};\n      (0, _object.get)(data, config.html_variable).replace(/\\{\\{widget(.*?)\\}\\}/i, function (match, attributeString) {\n        attributes = _this.parseAttributesString(attributeString);\n      }.bind(this));\n      return attributes;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {ConverterDataInterface} data\n     * @param {ConverterConfigInterface} config\n     * @returns {object}\n     */\n    ;\n\n    _proto.toDom = function toDom(data, config) {\n      (0, _object.set)(data, config.html_variable, this.buildDirective(data));\n      return data;\n    }\n    /**\n     * Build the directive string using the supplies attributes\n     *\n     * @param {object} attributes\n     * @returns {string}\n     */\n    ;\n\n    _proto.buildDirective = function buildDirective(attributes) {\n      return \"{{widget \" + this.createAttributesString(attributes) + \"}}\";\n    }\n    /**\n     * @param {string} attributes\n     * @return {Object}\n     */\n    ;\n\n    _proto.parseAttributesString = function parseAttributesString(attributes) {\n      var result = {};\n      attributes.replace(/(\\w+)(?:\\s*=\\s*(?:(?:\"((?:\\\\.|[^\"])*)\")|(?:'((?:\\\\.|[^'])*)')|([^>\\s]+)))?/g, function (match, key, value) {\n        result[key] = value.replace(/&quote;/g, \"\\\"\");\n        return \"\";\n      });\n      return result;\n    }\n    /**\n     * @param {Object} attributes\n     * @return {string}\n     */\n    ;\n\n    _proto.createAttributesString = function createAttributesString(attributes) {\n      var result = \"\";\n\n      _underscore.each(attributes, function (value, name) {\n        result += name + \"=\\\"\" + String(value).replace(/\"/g, \"&quote;\") + \"\\\" \";\n      });\n\n      return result.substr(0, result.length - 1);\n    };\n\n    return WidgetDirectiveAbstract;\n  }();\n\n  return WidgetDirectiveAbstract;\n});\n//# sourceMappingURL=widget-directive-abstract.js.map","Magento_PageBuilder/js/mass-converter/converter-pool-factory.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _createForOfIteratorHelperLoose(o, allowArrayLike) { var it = typeof Symbol !== \"undefined\" && o[Symbol.iterator] || o[\"@@iterator\"]; if (it) return (it = it.call(o)).next.bind(it); if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === \"number\") { if (it) o = it; var i = 0; return function () { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }; } throw new TypeError(\"Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\ndefine([\"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/utils/loader\", \"Magento_PageBuilder/js/mass-converter/converter-pool\"], function (_config, _loader, _converterPool) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Create a new instance of converter pool\n   */\n  function create(contentType) {\n    var config = _config.getContentTypeConfig(contentType);\n\n    var converters = [];\n    var appearanceName;\n\n    for (var _i = 0, _Object$keys = Object.keys(config.appearances); _i < _Object$keys.length; _i++) {\n      appearanceName = _Object$keys[_i];\n      var appearance = config.appearances[appearanceName];\n\n      if (undefined !== appearance && undefined !== appearance.converters) {\n        for (var _iterator = _createForOfIteratorHelperLoose(appearance.converters), _step; !(_step = _iterator()).done;) {\n          var converterConfig = _step.value;\n\n          if (!!converterConfig.component && !_converterPool.get(converterConfig.component)) {\n            converters.push(converterConfig.component);\n          }\n        }\n      }\n    }\n\n    return new Promise(function (resolve) {\n      (0, _loader)(converters, function () {\n        for (var _len = arguments.length, loadedConverters = new Array(_len), _key = 0; _key < _len; _key++) {\n          loadedConverters[_key] = arguments[_key];\n        }\n\n        for (var i = 0; i < converters.length; i++) {\n          _converterPool.register(converters[i], new loadedConverters[i]());\n        }\n\n        resolve(_converterPool);\n      });\n    });\n  }\n\n  return create;\n});\n//# sourceMappingURL=converter-pool-factory.js.map","Magento_PageBuilder/js/wysiwyg/factory.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\", \"Magento_PageBuilder/js/utils/loader\"], function (_jquery, _loader) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @param {String} contentTypeId The ID in the registry of the content type.\n   * @param {String} elementId The ID of the editor element in the DOM.\n   * @param {String} contentTypeName The type of content type this editor will be used in. E.g. \"banner\".\n   * @param {AdditionalDataConfigInterface} config The configuration for the wysiwyg.\n   * @param {DataStore} dataStore The datastore to store the content in.\n   * @param {String} fieldName The key in the provided datastore to set the data.\n   * @param {String} stageId The ID in the registry of the stage containing the content type.\n   * @returns {Wysiwyg}\n   */\n  function create(contentTypeId, elementId, contentTypeName, config, dataStore, fieldName, stageId) {\n    config = _jquery.extend(true, {}, config);\n    return new Promise(function (resolve) {\n      (0, _loader)([config.adapter_config.component], function (WysiwygInstance) {\n        new Promise(function (configResolve) {\n          if (config.adapter_config.config_modifiers && config.adapter_config.config_modifiers[contentTypeName]) {\n            (0, _loader)([config.adapter_config.config_modifiers[contentTypeName]], function (ConfigModifierType) {\n              var modifier = new ConfigModifierType(); // Allow dynamic settings to be set before editor is initialized\n\n              modifier.modify(contentTypeId, config);\n              configResolve();\n            });\n          } else {\n            configResolve();\n          }\n        }).then(function () {\n          // Instantiate the component\n          var wysiwyg = new WysiwygInstance(contentTypeId, elementId, config, dataStore, fieldName, stageId);\n\n          if (config.adapter_config.component_initializers && config.adapter_config.component_initializers[contentTypeName]) {\n            (0, _loader)([config.adapter_config.component_initializers[contentTypeName]], function (InitializerType) {\n              var initializer = new InitializerType(); // Allow dynamic bindings from configuration such as events from the editor\n\n              initializer.initialize(wysiwyg);\n              resolve(wysiwyg);\n            });\n          } else {\n            resolve(wysiwyg);\n          }\n        });\n      });\n    });\n  }\n\n  return create;\n});\n//# sourceMappingURL=factory.js.map","Magento_PageBuilder/js/wysiwyg/config-modifier-interface.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  \"use strict\";\n});\n//# sourceMappingURL=config-modifier-interface.js.map","Magento_PageBuilder/js/wysiwyg/tinymce4.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\", \"mage/adminhtml/wysiwyg/events\", \"mage/adminhtml/wysiwyg/tiny_mce/setup\", \"Magento_PageBuilder/js/events\", \"underscore\", \"Magento_PageBuilder/js/utils/check-stage-full-screen\", \"Magento_PageBuilder/js/utils/pagebuilder-header-height\"], function (_jquery, _events, _setup, _events2, _underscore, _checkStageFullScreen, _pagebuilderHeaderHeight) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Inline editing wysiwyg component\n   *\n   * @api\n   */\n  var Wysiwyg = /*#__PURE__*/function () {\n    \"use strict\";\n\n    /**\n     * The id of the editor element\n     */\n\n    /**\n     * The supplied wysiwyg configuration\n     */\n\n    /**\n     * Id of content type\n     */\n\n    /**\n     * Id of the stage\n     */\n\n    /**\n     * Wysiwyg adapter instance\n     */\n\n    /**\n     * Content type's data store\n     */\n\n    /**\n     * Field name in data store reflecting value held in wysiwyg\n     */\n\n    /**\n     * Create a debounce to save the content into the data store\n     */\n\n    /**\n     * @param {String} contentTypeId The ID in the registry of the content type.\n     * @param {String} elementId The ID of the editor element in the DOM.\n     * @param {AdditionalDataConfigInterface} config The configuration for the wysiwyg.\n     * @param {DataStore} dataStore The datastore to store the content in.\n     * @param {String} fieldName The key in the provided datastore to set the data.\n     * @param {String} stageId The ID in the registry of the stage containing the content type.\n     */\n    function Wysiwyg(contentTypeId, elementId, config, dataStore, fieldName, stageId) {\n      this.saveContentDebounce = _underscore.debounce(this.saveContentFromWysiwygToDataStore.bind(this), 500);\n      this.contentTypeId = contentTypeId;\n      this.elementId = elementId;\n      this.fieldName = fieldName;\n      this.config = config;\n      this.dataStore = dataStore;\n      this.stageId = stageId;\n\n      if (this.config.adapter_config.mode === \"inline\") {\n        /**\n         * Don't include content_css within the inline mode of TinyMCE, if any stylesheets are included here they're\n         * appended to the head of the main page, and thus cause other styles to be modified.\n         *\n         * The styles for typography in the inline editor are scoped within _typography.less\n         */\n        this.config.adapter.tinymce4.content_css = [];\n      }\n\n      var wysiwygSetup = new _setup(this.elementId, this.config.adapter);\n      wysiwygSetup.setup(this.config.adapter_config.mode);\n      this.wysiwygAdapter = wysiwygSetup.wysiwygInstance;\n\n      if (this.config.adapter_config.mode === \"inline\") {\n        this.wysiwygAdapter.eventBus.attachEventHandler(_events.afterFocus, this.onFocus.bind(this));\n        this.wysiwygAdapter.eventBus.attachEventHandler(_events.afterBlur, this.onBlur.bind(this));\n      } // Update content in our data store after our stage preview wysiwyg gets updated\n\n\n      this.wysiwygAdapter.eventBus.attachEventHandler(_events.afterChangeContent, this.onChangeContent.bind(this)); // Update content in our stage preview wysiwyg after its slideout counterpart gets updated\n\n      _events2.on(\"form:\" + this.contentTypeId + \":saveAfter\", this.setContentFromDataStoreToWysiwyg.bind(this));\n\n      _events2.on(\"stage:\" + this.stageId + \":fullScreenModeChangeAfter\", this.toggleFullScreen.bind(this));\n    }\n    /**\n     * Hide TinyMce inline toolbar options after fullscreen exit\n     */\n\n\n    var _proto = Wysiwyg.prototype;\n\n    _proto.toggleFullScreen = function toggleFullScreen() {\n      var _this = this;\n\n      var $editor = (0, _jquery)(\"#\" + this.elementId); // wait for fullscreen to close\n\n      _underscore.defer(function () {\n        if (!(0, _checkStageFullScreen)(_this.stageId) && _this.config.adapter_config.mode === \"inline\" && $editor.hasClass(\"mce-edit-focus\")) {\n          $editor.removeClass(\"mce-edit-focus\");\n\n          _this.onBlur();\n        }\n      });\n    }\n    /**\n     * @returns {WysiwygInstanceInterface}\n     */\n    ;\n\n    _proto.getAdapter = function getAdapter() {\n      return this.wysiwygAdapter;\n    }\n    /**\n     * Called for the onFocus event\n     */\n    ;\n\n    _proto.onFocus = function onFocus() {\n      var _this2 = this;\n\n      this.getFixedToolbarContainer().addClass(\"pagebuilder-toolbar-active\");\n\n      _events2.trigger(\"stage:interactionStart\"); // Wait for everything else to finish\n\n\n      _underscore.defer(function () {\n        _this2.getFixedToolbarContainer().find(\".mce-tinymce-inline\").css(\"min-width\", _this2.config.adapter_config.minToolbarWidth + \"px\");\n\n        _this2.invertInlineEditorToAccommodateOffscreenToolbar();\n      });\n    }\n    /**\n     * Called for the onChangeContent event\n     */\n    ;\n\n    _proto.onChangeContent = function onChangeContent() {\n      this.saveContentDebounce();\n      this.invertInlineEditorToAccommodateOffscreenToolbar();\n    }\n    /**\n     * Called for the onBlur events\n     */\n    ;\n\n    _proto.onBlur = function onBlur() {\n      this.getFixedToolbarContainer().removeClass(\"pagebuilder-toolbar-active\").find(\".mce-tinymce-inline\").css(\"transform\", \"\");\n\n      _events2.trigger(\"stage:interactionStop\");\n    }\n    /**\n     * Update content in our data store after our stage preview wysiwyg gets updated\n     */\n    ;\n\n    _proto.saveContentFromWysiwygToDataStore = function saveContentFromWysiwygToDataStore() {\n      this.dataStore.set(this.fieldName, this.getAdapter().getContent());\n    }\n    /**\n     * Update content in our stage wysiwyg after our data store gets updated\n     */\n    ;\n\n    _proto.setContentFromDataStoreToWysiwyg = function setContentFromDataStoreToWysiwyg() {\n      this.getAdapter().setContent(this.dataStore.get(this.fieldName));\n    }\n    /**\n     * Adjust padding on stage if in fullscreen mode to accommodate inline wysiwyg toolbar overflowing fixed viewport\n     */\n    ;\n\n    _proto.invertInlineEditorToAccommodateOffscreenToolbar = function invertInlineEditorToAccommodateOffscreenToolbar() {\n      if (this.config.adapter_config.mode !== \"inline\") {\n        return;\n      }\n\n      var $inlineToolbar = this.getFixedToolbarContainer().find(\".mce-tinymce-inline\");\n\n      if (!$inlineToolbar.length) {\n        return;\n      }\n\n      var inlineWysiwygClientRectTop = this.getFixedToolbarContainer().get(0).getBoundingClientRect().top - (0, _pagebuilderHeaderHeight)(this.stageId);\n\n      if (!(0, _checkStageFullScreen)(this.stageId) || $inlineToolbar.height() < inlineWysiwygClientRectTop) {\n        $inlineToolbar.css(\"transform\", \"translateY(-100%)\");\n        return;\n      }\n\n      $inlineToolbar.css(\"transform\", \"translateY(\" + this.getFixedToolbarContainer().height() + \"px)\");\n    }\n    /**\n     * Get fixed toolbar container element referenced as selector in wysiwyg adapter settings\n     *\n     * @returns {jQuery}\n     */\n    ;\n\n    _proto.getFixedToolbarContainer = function getFixedToolbarContainer() {\n      return (0, _jquery)(\"#\" + this.elementId).closest(\"\" + this.config.adapter.settings.fixed_toolbar_container);\n    };\n\n    return Wysiwyg;\n  }();\n\n  return Wysiwyg;\n});\n//# sourceMappingURL=tinymce4.js.map","Magento_PageBuilder/js/wysiwyg/wysiwyg-interface.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  \"use strict\";\n});\n//# sourceMappingURL=wysiwyg-interface.js.map","Magento_PageBuilder/js/wysiwyg/component-initializer-interface.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  \"use strict\";\n});\n//# sourceMappingURL=component-initializer-interface.js.map","Magento_PageBuilder/js/utils/create-stylesheet.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Create a stylesheet DOM object from a style block declaration\n   *\n   * @param {StyleBlocks} blocks\n   * @returns {HTMLStyleElement}\n   * @api\n   */\n  function createStyleSheet(blocks) {\n    var style = document.createElement(\"style\");\n    var text = Object.keys(blocks).map(function (selector) {\n      return selector + (\" {\\n\" + processDeclarationBlock(blocks[selector]) + \"\\n}\");\n    }).join(\"\\n\");\n    style.setAttribute(\"type\", \"text/css\");\n    style.appendChild(document.createTextNode(text));\n    return style;\n  }\n  /**\n   * Process a declaration block from the rule set\n   *\n   * @param {StyleBlock} block\n   * @returns {string}\n   */\n\n\n  function processDeclarationBlock(block) {\n    return Object.keys(block).map(function (property) {\n      return processDeclaration(property, block[property]);\n    }).join(\"\\n\");\n  }\n  /**\n   * Process a declaration, creating the property: value syntax\n   *\n   * @param {string} property\n   * @param {string | number} value\n   * @returns {string}\n   */\n\n\n  function processDeclaration(property, value) {\n    return hyphenate(property) + (\": \" + value + \";\");\n  }\n  /**\n   * Hyphenate style property, from textAlign to text-align\n   *\n   * @param {string} property\n   * @returns {string}\n   */\n\n\n  function hyphenate(property) {\n    return property.replace(/[A-Z]/g, function (match) {\n      return \"-\" + match.toLowerCase();\n    });\n  }\n\n  return {\n    createStyleSheet: createStyleSheet\n  };\n});\n//# sourceMappingURL=create-stylesheet.js.map","Magento_PageBuilder/js/utils/pagebuilder-header-height.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\"], function (_jquery) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Checks if PageBuilder has header and returns it's height\n   *\n   * @param {string} stageId\n   * @param {string} stageWrapper\n   * @param {string} pageBuilderHeader\n   * @returns {number}\n   */\n  function pageBuilderHeaderHeight(stageId, stageWrapper, pageBuilderHeader) {\n    if (stageWrapper === void 0) {\n      stageWrapper = \".pagebuilder-stage-wrapper\";\n    }\n\n    if (pageBuilderHeader === void 0) {\n      pageBuilderHeader = \".pagebuilder-header\";\n    }\n\n    var $stageWrapper = (0, _jquery)(\"#\" + stageId).closest(stageWrapper);\n    var $pageBuilderHeader = $stageWrapper.find(pageBuilderHeader);\n    return !!$pageBuilderHeader.length ? $pageBuilderHeader.height() : 0;\n  }\n\n  return pageBuilderHeaderHeight;\n});\n//# sourceMappingURL=pagebuilder-header-height.js.map","Magento_PageBuilder/js/utils/nesting-widget-dialog.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\", \"mage/translate\", \"Magento_PageBuilder/js/modal/dismissible-confirm\"], function (_jquery, _translate, _dismissibleConfirm) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Validate inline editor for having nested widget\n   * Creates a dialog and removes inline editor widget if present\n   *\n   * @param {DataStore} dataStore\n   * @param {WysiwygInterface} wysiwyg\n   * @param {string} inlineMessageField\n   * @param {string} linkUrlField\n   */\n  function nestingWidgetDialog(dataStore, wysiwyg, inlineMessageField, linkUrlField) {\n    var dataStoreContent = dataStore.getState();\n    var inlineMessage = dataStoreContent[inlineMessageField];\n    var linkUrl = dataStoreContent[linkUrlField];\n    var widgetRegex = /\\{\\{widget(.*?)\\}\\}/ig;\n    var widgetPlaceholderRegex = /<span.*(class=)(\\\"|\\').*((magento-placeholder).*(magento-widget)|(magento-widget).*(magento-placeholder)).*<\\/span>/igm;\n\n    if (wysiwyg && inlineMessage.match(widgetRegex) && linkUrl && [\"page\", \"product\", \"category\", \"default\"].indexOf(linkUrl.type) !== -1 && linkUrl[linkUrl.type] && linkUrl[linkUrl.type].length !== 0) {\n      var inlineEditor = (0, _jquery)(\"#\" + wysiwyg.elementId);\n      inlineEditor.blur();\n      (0, _dismissibleConfirm)({\n        actions: {\n          always: function always() {\n            var widgetLessDataStoreMessage = inlineMessage.replace(widgetRegex, \"\");\n            var widgetLessInlineMessage = inlineEditor.html().replace(widgetPlaceholderRegex, \"\");\n            dataStore.set(inlineMessageField, widgetLessDataStoreMessage);\n            inlineEditor.html(widgetLessInlineMessage);\n          }\n        },\n        content: (0, _translate)(\"We are unable to support widget within the content field whilst having a link set on the content type. Please remove the content type link if you'd like to set a widget within the content. We will automatically remove the widget within the content field.\"),\n        // tslint:disable-line:max-line-length\n        title: (0, _translate)(\"Nested widgets are not allowed\"),\n        haveCancelButton: false\n      });\n    }\n  }\n\n  return nestingWidgetDialog;\n});\n//# sourceMappingURL=nesting-widget-dialog.js.map","Magento_PageBuilder/js/utils/nesting-link-dialog.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\", \"mage/translate\", \"Magento_PageBuilder/js/modal/dismissible-confirm\"], function (_jquery, _translate, _dismissibleConfirm) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Validate inline editor for having nested link\n   * Creates a dialog and removes inline editor link if present\n   *\n   * @param {DataStore} dataStore\n   * @param {WysiwygInterface} wysiwyg\n   * @param {string} inlineMessageField\n   * @param {string} linkUrlField\n   */\n  function nestingLinkDialog(dataStore, wysiwyg, inlineMessageField, linkUrlField) {\n    var dataStoreContent = dataStore.getState();\n    var inlineMessage = dataStoreContent[inlineMessageField];\n    var linkUrl = dataStoreContent[linkUrlField];\n    var aLinkRegex = /(<a[\\s]+[^>]+).+(?=<\\/a>)<\\/a>/igm;\n\n    if (wysiwyg && inlineMessage.match(aLinkRegex) && linkUrl && [\"page\", \"product\", \"category\", \"default\"].indexOf(linkUrl.type) !== -1 && linkUrl[linkUrl.type] && linkUrl[linkUrl.type].length !== 0) {\n      var inlineEditor = (0, _jquery)(\"#\" + wysiwyg.elementId);\n      inlineEditor.blur();\n      (0, _dismissibleConfirm)({\n        actions: {\n          always: function always() {\n            var anchorLessDataStoreMessage = inlineMessage.replace(aLinkRegex, \"\");\n            var anchorLessInlineMessage = inlineEditor.html().replace(aLinkRegex, \"\");\n            dataStore.set(inlineMessageField, anchorLessDataStoreMessage);\n            inlineEditor.html(anchorLessInlineMessage);\n          }\n        },\n        content: (0, _translate)(\"We are unable to support links within the content field whilst having a link set on the content type. Please remove the content type link if you'd like to set a link within the content. We will automatically remove the links within the content field.\"),\n        // tslint:disable-line:max-line-length\n        title: (0, _translate)(\"Nested links are not allowed\"),\n        haveCancelButton: false\n      });\n    }\n  }\n\n  return nestingLinkDialog;\n});\n//# sourceMappingURL=nesting-link-dialog.js.map","Magento_PageBuilder/js/utils/object.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"object-path\"], function (_objectPath) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Retrieve a value from an object via a path\n   *\n   * @param {object} object\n   * @param {string} path\n   * @param {TResult} defaultValue\n   * @returns {TResult}\n   */\n  function get(object, path, defaultValue) {\n    return _objectPath.get(object, path, defaultValue);\n  }\n  /**\n   * Set a value within an object via a path\n   *\n   * @param {object} object\n   * @param {string} path\n   * @param {TResult} value\n   * @returns {TResult | undefined}\n   */\n\n\n  function set(object, path, value) {\n    return _objectPath.set(object, path, value);\n  }\n\n  return {\n    get: get,\n    set: set\n  };\n});\n//# sourceMappingURL=object.js.map","Magento_PageBuilder/js/utils/array.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Move an array item within the current array\n   *\n   * @param array\n   * @param fromIndex\n   * @param toIndex\n   * @returns {Array<any>}\n   */\n  function moveArrayItem(array, fromIndex, toIndex) {\n    array.splice(toIndex, 0, array.splice(fromIndex, 1)[0]);\n    return array;\n  }\n  /**\n   * Move an array item from one array into another\n   *\n   * @param item\n   * @param array\n   * @param toIndex\n   * @returns {Array<any>}\n   */\n\n\n  function moveArrayItemIntoArray(item, array, toIndex) {\n    array.splice(toIndex, 0, item);\n    return array;\n  }\n  /**\n   * Remove an array item\n   *\n   * @param array\n   * @param item\n   * @returns {Array<any>}\n   */\n\n\n  function removeArrayItem(array, item) {\n    var index = array.indexOf(item);\n\n    if (index > -1) {\n      array.splice(index, 1);\n    }\n\n    return array;\n  }\n  /**\n   * Search outwards from an array item until a callback matches\n   *\n   * @author https://github.com/thejameskyle/outward-search\n   *\n   * @param {any[]} items\n   * @param {number} start\n   * @param {(item: any, index: number) => boolean} callback\n   * @returns {any}\n   * @api\n   */\n\n\n  function outwardSearch(items, start, callback) {\n    if (!items.length) {\n      return null;\n    }\n\n    if (start < 0 || start > items.length - 1) {\n      throw new TypeError(\"starting index must be within bounds of array\");\n    }\n\n    var max = items.length - 1;\n    var low = start;\n    var high = start + 1;\n\n    while (true) {\n      var hitMin = low < 0;\n      var hitMax = high > max;\n\n      if (hitMin && hitMax) {\n        break;\n      }\n\n      if (!hitMin) {\n        var _item = items[low];\n        var result = callback(_item, low);\n\n        if (!!result) {\n          return _item;\n        }\n\n        low--;\n      }\n\n      if (!hitMax) {\n        var _item2 = items[high];\n\n        var _result = callback(_item2, high);\n\n        if (!!_result) {\n          return _item2;\n        }\n\n        high++;\n      }\n    }\n\n    return null;\n  }\n\n  return {\n    moveArrayItem: moveArrayItem,\n    moveArrayItemIntoArray: moveArrayItemIntoArray,\n    removeArrayItem: removeArrayItem,\n    outwardSearch: outwardSearch\n  };\n});\n//# sourceMappingURL=array.js.map","Magento_PageBuilder/js/utils/editor.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\", \"mage/adminhtml/tools\", \"mage/translate\", \"mageUtils\", \"Magento_PageBuilder/js/config\"], function (_jquery, _tools, _translate, _mageUtils, _config) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Is the inline WYSIWYG supported?\n   */\n  function isWysiwygSupported() {\n    return _config.getConfig(\"can_use_inline_editing_on_stage\");\n  }\n  /**\n   * Encode content for TinyMCE\n   *\n   * @param content\n   */\n\n\n  function encodeContent(content) {\n    if (isWysiwygSupported()) {\n      return convertVariablesToHtmlPreview(convertWidgetsToHtmlPreview(unescapeDoubleQuoteWithinWidgetDirective(removeInvalidPlaceholders(content))));\n    }\n\n    return content;\n  }\n  /**\n   * Prior to parsing the content remove any invalid placeholders within the content\n   *\n   * @param content\n   */\n\n\n  function removeInvalidPlaceholders(content) {\n    if (content.indexOf(\"magento-placeholder\") !== -1) {\n      var html = new DOMParser().parseFromString(content, \"text/html\");\n      var placeholders = html.querySelectorAll(\"span.magento-placeholder\");\n\n      if (placeholders.length > 0) {\n        [].slice.call(placeholders).forEach(function (placeholder) {\n          // If the invalid placeholder contains a directive, let's insert it back where it belongs\n          if (placeholder.innerText.indexOf(\"{{\") !== -1) {\n            placeholder.parentNode.insertBefore(document.createTextNode(placeholder.innerText), placeholder);\n          }\n\n          placeholder.remove();\n        });\n      }\n\n      return html.body.innerHTML;\n    }\n\n    return content;\n  }\n  /**\n   * Convert all variables to their HTML preview counterparts\n   *\n   * Re-implements logic from lib/web/mage/adminhtml/wysiwyg/tiny_mce/plugins/magentovariable/editor_plugin.js to parse\n   * and replace the variables within the content.\n   *\n   * @param content\n   */\n\n\n  function convertVariablesToHtmlPreview(content) {\n    var config = _config.getConfig(\"tinymce\").variables;\n\n    var magentoVariables = JSON.parse(config.placeholders);\n    return content.replace(/{\\{\\s?(?:customVar code=|config path=\\\")([^\\}\\\"]+)[\\\"]?\\s?\\}\\}/ig, function (match, path) {\n      var id = btoa(path).replace(/\\+/g, \":\").replace(/\\//g, \"_\").replace(/=/g, \"-\");\n      var placeholder = (0, _jquery)(\"<span />\").addClass(\"magento-variable\").addClass(\"magento-placeholder\").addClass(\"mceNonEditable\").prop(\"id\", id).prop(\"contentEditable\", \"false\");\n\n      if (magentoVariables[path].variable_type === \"custom\") {\n        placeholder.addClass(\"magento-custom-var\");\n      }\n\n      var variableType = magentoVariables[path].variable_type;\n\n      if (magentoVariables[path] && (variableType === \"default\" || variableType === \"custom\")) {\n        placeholder.text(magentoVariables[path].variable_name);\n      } else {\n        // If we're unable to find the placeholder we need to attach an error class\n        placeholder.addClass(\"magento-placeholder-error\");\n        placeholder.text(variableType === \"custom\" ? path : (0, _translate)(\"Not Found\"));\n      }\n\n      return placeholder[0].outerHTML;\n    });\n  }\n  /**\n   * Convert widgets within content to their HTML counterparts\n   *\n   * @param content\n   */\n\n\n  function convertWidgetsToHtmlPreview(content) {\n    var config = _config.getConfig(\"tinymce\").widgets;\n\n    return content.replace(/\\{\\{widget(.*?)\\}\\}/ig, function (match, widgetBody) {\n      var attributes = parseAttributesString(widgetBody);\n      var imageSrc;\n\n      if (attributes.type) {\n        var placeholder = (0, _jquery)(\"<span />\").addClass(\"magento-placeholder\").addClass(\"magento-widget\").addClass(\"mceNonEditable\").prop(\"id\", _mageUtils.uniqueid()).prop(\"contentEditable\", \"false\");\n        attributes.type = attributes.type.replace(/\\\\\\\\/g, \"\\\\\");\n        imageSrc = config.placeholders[attributes.type];\n\n        if (!imageSrc) {\n          imageSrc = config.error_image_url;\n          placeholder.addClass(\"magento-placeholder-error\");\n        }\n\n        var image = (0, _jquery)(\"<img />\").prop(\"id\", window.Base64.idEncode(match)).prop(\"src\", imageSrc);\n        placeholder.append(image);\n        var widgetType = \"\";\n\n        if (config.types[attributes.type]) {\n          widgetType += config.types[attributes.type];\n        }\n\n        placeholder.append((0, _jquery)(document.createTextNode(widgetType)));\n        return placeholder[0].outerHTML;\n      }\n    });\n  }\n  /**\n   * Parse attributes into a string\n   *\n   * @param attributes\n   */\n\n\n  function parseAttributesString(attributes) {\n    var result = {};\n    attributes.replace(/(\\w+)(?:\\s*=\\s*(?:(?:\"((?:\\\\.|[^\"])*)\")|(?:'((?:\\\\.|[^'])*)')|([^>\\s]+)))?/g, function (match, key, value) {\n      result[key] = value ? value.replace(/&quote;/g, \"\\\"\") : value;\n      return \"\";\n    });\n    return result;\n  }\n  /**\n   * Lock all image sizes before initializing TinyMCE to avoid content jumps\n   *\n   * @param element\n   */\n\n\n  function lockImageSize(element) {\n    [].slice.call(element.querySelectorAll(\"img\")).forEach(function (image) {\n      if (image.style.width.length === 0) {\n        image.style.width = /^\\d+$/.test(image.getAttribute(\"width\")) ? image.getAttribute(\"width\") + \"px\" : image.getAttribute(\"width\");\n        image.setAttribute(\"data-width-locked\", \"true\");\n      }\n\n      if (image.style.height.length === 0) {\n        image.style.height = /^\\d+$/.test(image.getAttribute(\"height\")) ? image.getAttribute(\"height\") + \"px\" : image.getAttribute(\"height\");\n        image.setAttribute(\"data-height-locked\", \"true\");\n      }\n    });\n  }\n  /**\n   * Reverse forced image size after TinyMCE is finished initializing\n   *\n   * @param element\n   */\n\n\n  function unlockImageSize(element) {\n    [].slice.call(element.querySelectorAll(\"img\")).forEach(function (image) {\n      if (image.getAttribute(\"data-width-locked\")) {\n        image.style.width = null;\n        image.removeAttribute(\"data-width-locked\");\n      }\n\n      if (image.getAttribute(\"data-height-locked\")) {\n        image.style.height = null;\n        image.removeAttribute(\"data-height-locked\");\n      }\n    });\n  }\n  /**\n   * Create a bookmark within the content to be restored later\n   */\n\n\n  function createBookmark(event) {\n    var wrapperElement = (0, _jquery)(event.target).parents(\".inline-wysiwyg\");\n    /**\n     * Create an element bookmark\n     *\n     * @param element\n     */\n\n    var createElementBookmark = function createElementBookmark(element) {\n      return {\n        name: element.nodeName,\n        index: findNodeIndex(wrapperElement[0], element.nodeName, element)\n      };\n    }; // Handle direct clicks onto an IMG\n\n\n    if (event.target.nodeName === \"IMG\") {\n      return createElementBookmark(event.target);\n    }\n\n    if (window.getSelection) {\n      var selection = window.getSelection();\n\n      var id = _mageUtils.uniqueid();\n\n      if (selection.getRangeAt && selection.rangeCount) {\n        var range = normalizeTableCellSelection(selection.getRangeAt(0).cloneRange()); // Determine if the current node is an image or span that we want to select instead of text\n\n        var currentNode = range.startContainer;\n\n        if (currentNode.nodeType === Node.ELEMENT_NODE && (currentNode.nodeName === \"IMG\" || currentNode.nodeName === \"SPAN\" && currentNode.classList.contains(\"magento-placeholder\"))) {\n          return createElementBookmark(currentNode);\n        } // Also check if the direct parent is either of these\n\n\n        var parentNode = range.startContainer.parentNode;\n\n        if (parentNode.nodeName === \"IMG\" || parentNode.nodeName === \"SPAN\" && parentNode.classList.contains(\"magento-placeholder\")) {\n          return createElementBookmark(parentNode);\n        }\n\n        if (!range.collapsed) {\n          range.collapse(false);\n          var endBookmarkNode = createBookmarkSpan(id + \"_end\");\n          range.insertNode(endBookmarkNode);\n        }\n\n        var range2 = normalizeTableCellSelection(selection.getRangeAt(0));\n        range2.collapse(true);\n        var startBookmarkNode = createBookmarkSpan(id + \"_start\");\n        range2.insertNode(startBookmarkNode);\n        return {\n          id: id\n        };\n      }\n    }\n\n    return null;\n  }\n  /**\n   * Move the cursor to our new bookmark\n   *\n   * @param bookmark\n   */\n\n\n  function moveToBookmark(bookmark) {\n    window.tinymce.activeEditor.selection.moveToBookmark(bookmark);\n  }\n  /**\n   * Retrieve active editor from TinyMCE\n   */\n\n\n  function getActiveEditor() {\n    return window.tinymce.activeEditor;\n  }\n  /**\n   * Create a bookmark span for the selection\n   *\n   * @param id\n   */\n\n\n  function createBookmarkSpan(id) {\n    var bookmark = document.createElement(\"span\");\n    bookmark.setAttribute(\"data-mce-type\", \"bookmark\");\n    bookmark.id = id;\n    bookmark.style.overflow = \"hidden\";\n    bookmark.style.lineHeight = \"0px\";\n    return bookmark;\n  }\n  /**\n   * Find the index of an element within a wrapper\n   *\n   * @param wrapperElement\n   * @param name\n   * @param element\n   */\n\n\n  function findNodeIndex(wrapperElement, name, element) {\n    var selector = name.toLowerCase() + ':not([data-mce-bogus=\"all\"])'; // If there is no ID on the element add a unique ID so we can efficiently find it\n\n    if (!element.id) {\n      element.id = _mageUtils.uniqueid();\n    }\n\n    return (0, _jquery)(wrapperElement).find(selector).toArray().findIndex(function (node) {\n      return node.id === element.id;\n    });\n  }\n  /**\n   * Get a node by index within a wrapper\n   *\n   * @param wrapperElement\n   * @param name\n   * @param index\n   */\n\n\n  function getNodeByIndex(wrapperElement, name, index) {\n    var selector = name.toLowerCase() + ':not([data-mce-bogus=\"all\"])';\n    return (0, _jquery)(wrapperElement).find(selector).get(index);\n  }\n  /**\n   * Create a double click event that works in all browsers\n   */\n\n\n  function createDoubleClickEvent() {\n    try {\n      return new MouseEvent(\"dblclick\", {\n        view: window,\n        bubbles: true,\n        cancelable: true\n      });\n    } catch (e) {\n      var dblClickEvent = document.createEvent(\"MouseEvent\");\n      dblClickEvent.initMouseEvent(\"dblclick\", true, true, window, 0, 0, 0, 0, 0, false, false, false, false, 0, null);\n      return dblClickEvent;\n    }\n  }\n  /**\n   * Replace all desktop styles that left unprocessed back to style element to prevent data corruption.\n   */\n\n\n  function processInlineStyles(html) {\n    var name = _config.getConfig(\"defaultViewport\");\n\n    var searchPattern = new RegExp(\"data-\" + name + \"-style=\", \"g\");\n    return html.replace(searchPattern, \"style=\");\n  }\n  /**\n   * Move the end point of a range to handle tables\n   *\n   * @param range\n   * @param start\n   */\n\n\n  function moveEndPoint(range, start) {\n    var container;\n    var offset;\n    var childNodes;\n\n    if (start) {\n      container = range.startContainer;\n      offset = range.startOffset;\n    } else {\n      container = range.endContainer;\n      offset = range.endOffset;\n    }\n\n    if (container.nodeType === Node.ELEMENT_NODE && container.nodeName === \"TR\") {\n      childNodes = container.childNodes;\n      container = childNodes[Math.min(start ? offset : offset - 1, childNodes.length - 1)];\n\n      if (container) {\n        offset = start ? 0 : container.childNodes.length;\n\n        if (start) {\n          range.setStart(container, offset);\n        } else {\n          range.setEnd(container, offset);\n        }\n      }\n    }\n  }\n  /**\n   * Normalize the table sell selection within a range to better handle selections being inside of tables\n   *\n   * @param range\n   */\n\n\n  function normalizeTableCellSelection(range) {\n    moveEndPoint(range, true);\n    moveEndPoint(range, false);\n    return range;\n  }\n  /**\n   * Convert HTML encoded double quote to double quote with backslash within widget directives\n   *\n   * @param {string} content\n   * @returns {string}\n   */\n\n\n  function escapeDoubleQuoteWithinWidgetDirective(content) {\n    return content.replace(/\\{\\{widget.*?\\}\\}/ig, function (match) {\n      return match.replace(/&quot;/g, \"\\\\\\\"\");\n    });\n  }\n  /**\n   * Convert double quote with backslash to HTML encoded double quote within widget directives\n   *\n   * @param {string} content\n   * @returns {string}\n   */\n\n\n  function unescapeDoubleQuoteWithinWidgetDirective(content) {\n    return content.replace(/\\{\\{widget.*?\\}\\}/ig, function (match) {\n      return match.replace(/\\\\+\"/g, \"&quot;\");\n    });\n  }\n  /**\n   * Convert double quote to single quote within magento variable directives\n   *\n   * @param {string} content\n   * @returns {string}\n   */\n\n\n  function replaceDoubleQuoteWithSingleQuoteWithinVariableDirective(content) {\n    // Find html elements which attributes contain magento variables directives\n    return content.replace(/<([a-z0-9\\-\\_]+)([^>]+?[a-z0-9\\-\\_]+=\"[^\"]*?\\{\\{.+?\\}\\}.*?\".*?)>/gi, function (match1, tag, attributes) {\n      // Replace double quote with single quote within magento variable directive\n      var sanitizedAttributes = attributes.replace(/\\{\\{[^\\{\\}]+\\}\\}/gi, function (match2) {\n        return match2.replace(/\"/g, \"'\");\n      });\n      return \"<\" + tag + sanitizedAttributes + \">\";\n    });\n  }\n\n  return {\n    isWysiwygSupported: isWysiwygSupported,\n    encodeContent: encodeContent,\n    parseAttributesString: parseAttributesString,\n    lockImageSize: lockImageSize,\n    unlockImageSize: unlockImageSize,\n    createBookmark: createBookmark,\n    moveToBookmark: moveToBookmark,\n    getActiveEditor: getActiveEditor,\n    findNodeIndex: findNodeIndex,\n    getNodeByIndex: getNodeByIndex,\n    createDoubleClickEvent: createDoubleClickEvent,\n    processInlineStyles: processInlineStyles,\n    escapeDoubleQuoteWithinWidgetDirective: escapeDoubleQuoteWithinWidgetDirective,\n    unescapeDoubleQuoteWithinWidgetDirective: unescapeDoubleQuoteWithinWidgetDirective,\n    replaceDoubleQuoteWithSingleQuoteWithinVariableDirective: replaceDoubleQuoteWithSingleQuoteWithinVariableDirective\n  };\n});\n//# sourceMappingURL=editor.js.map","Magento_PageBuilder/js/utils/string.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Convert from snake case to camel case\n   *\n   * @param {string} currentString\n   * @returns {string}\n   * @api\n   */\n  function fromSnakeToCamelCase(currentString) {\n    var parts = currentString.split(/[_-]/);\n    var newString = \"\";\n\n    for (var i = 1; i < parts.length; i++) {\n      newString += parts[i].charAt(0).toUpperCase() + parts[i].slice(1);\n    }\n\n    return parts[0] + newString;\n  }\n  /**\n   * Convert a camel case string to snake case\n   *\n   * @param currentString\n   */\n\n\n  function fromCamelCaseToDash(currentString) {\n    return currentString.replace(/[A-Z]/g, function (m) {\n      return \"-\" + m.toLowerCase();\n    });\n  }\n\n  return {\n    fromSnakeToCamelCase: fromSnakeToCamelCase,\n    fromCamelCaseToDash: fromCamelCaseToDash\n  };\n});\n//# sourceMappingURL=string.js.map","Magento_PageBuilder/js/utils/delay-until.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Delay until a condition is met\n   *\n   * @param {() => void} callback\n   * @param {() => boolean} condition\n   * @param {number} interval\n   */\n  function delayUntil(callback, condition, interval) {\n    if (interval === void 0) {\n      interval = 50;\n    }\n\n    var delayInterval = setInterval(function () {\n      if (condition()) {\n        clearInterval(delayInterval);\n        callback();\n      }\n    }, interval);\n  }\n\n  return delayUntil;\n});\n//# sourceMappingURL=delay-until.js.map","Magento_PageBuilder/js/utils/position-sticky.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Determine if the current browser supports position sticky\n   *\n   * @returns {boolean}\n   */\n  function supportsPositionSticky() {\n    if (!window.getComputedStyle) {\n      return false;\n    }\n\n    var testNode = document.createElement(\"div\");\n    return [\"\", \"-webkit-\", \"-moz-\", \"-ms-\"].some(function (prefix) {\n      try {\n        testNode.style.position = prefix + \"sticky\";\n      } catch (e) {// Fail silently\n      }\n\n      return testNode.style.position !== \"\";\n    });\n  }\n\n  return {\n    supportsPositionSticky: supportsPositionSticky\n  };\n});\n//# sourceMappingURL=position-sticky.js.map","Magento_PageBuilder/js/utils/image.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/utils/directives\", \"Magento_PageBuilder/js/utils/url\"], function (_config, _directives, _url) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Decode image background URL to object\n   *\n   * @param value\n   * @returns {Object}\n   * @api\n   */\n  function decodeUrl(value) {\n    var result = \"\";\n    value = decodeURIComponent(value.replace(window.location.href, \"\"));\n    var regexp = /{{.*\\s*url=\"?(.*\\.([a-z|A-Z]*))\"?\\s*}}/;\n\n    if (regexp.test(value)) {\n      var _regexp$exec = regexp.exec(value),\n          url = _regexp$exec[1],\n          type = _regexp$exec[2];\n\n      var image = {\n        name: url.split(\"/\").pop(),\n        size: 0,\n        type: \"image/\" + type,\n        url: _config.getConfig(\"media_url\") + url\n      };\n      result = [image];\n    }\n\n    return result;\n  }\n  /**\n   * Convert a URL to an image directive\n   *\n   * @param {string} imageUrl\n   * @returns {string}\n   */\n\n\n  function urlToDirective(imageUrl) {\n    var mediaUrl = (0, _url.convertUrlToPathIfOtherUrlIsOnlyAPath)(_config.getConfig(\"media_url\"), imageUrl);\n    var mediaPath = imageUrl.split(mediaUrl);\n    return \"{{media url=\" + mediaPath[1] + \"}}\";\n  }\n  /**\n   * Convert an image URL to a background image data uri\n   *\n   * @param {string} imageUrl\n   * @returns {string}\n   */\n\n\n  function imageToBackgroundImageDataUrl(imageUrl) {\n    return \"url(\\'\" + (0, _directives.toDataUrl)(urlToDirective(imageUrl)) + \"\\')\";\n  }\n\n  return {\n    decodeUrl: decodeUrl,\n    urlToDirective: urlToDirective,\n    imageToBackgroundImageDataUrl: imageToBackgroundImageDataUrl\n  };\n});\n//# sourceMappingURL=image.js.map","Magento_PageBuilder/js/utils/breakpoints.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    return {\n        /**\n         * Build media query.\n         *\n         * @param {Object} conditions\n         * @returns {String}\n         */\n        buildMedia: function (conditions) {\n            var result = _.map(_.pairs(conditions), function (condition) {\n                return '(' + condition.join(': ') + ')';\n            });\n\n            return result.join(' and ');\n        }\n    };\n});\n","Magento_PageBuilder/js/utils/check-stage-full-screen.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\"], function (_jquery) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Check if stage full screen mode is active\n   *\n   * @param {string} stageId\n   * @returns {boolean}\n   */\n  function checkStageFullScreen(stageId) {\n    var $stage = (0, _jquery)(\"#\" + stageId);\n    var $fullScreenStageWrapper = $stage.closest(\".stage-full-screen\");\n    return !!$fullScreenStageWrapper.length;\n  }\n\n  return checkStageFullScreen;\n});\n//# sourceMappingURL=check-stage-full-screen.js.map","Magento_PageBuilder/js/utils/directives.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/config\"], function (_config) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * MIME type to use in place of the image\n   *\n   * @type {string}\n   */\n  var mimeType = \"text/magento-directive\";\n  /**\n   * Determine if a URL is a directive of our type\n   *\n   * @param {string} url\n   * @returns {boolean}\n   * @api\n   */\n\n  function isDirectiveDataUrl(url) {\n    return url.indexOf(\"data:\" + mimeType) === 0;\n  }\n  /**\n   * Convert a directive into our data URI\n   *\n   * @param {string} directive\n   * @returns {string}\n   * @api\n   */\n\n\n  function toDataUrl(directive) {\n    return \"data:\" + mimeType + \",\" + encodeURIComponent(directive);\n  }\n  /**\n   * Convert a URI to it's directive equivalent\n   *\n   * @param {string} url\n   * @returns {string}\n   * @api\n   */\n\n\n  function fromDataUrl(url) {\n    if (!isDirectiveDataUrl(url)) {\n      throw Error(url + \" is not a magento directive data url\");\n    }\n\n    return decodeURIComponent(url.split(mimeType + \",\")[1]);\n  }\n  /**\n   * Decode all data URIs present in a string\n   *\n   * @param {string} str\n   * @returns {string}\n   * @api\n   */\n\n\n  function decodeAllDataUrlsInString(str) {\n    return str.replace(new RegExp(\"url\\\\s*\\\\(\\\\s*(?:&quot;|\\'|\\\")?(data:\" + mimeType + \",.+?)(?:&quot;|\\'|\\\")?\\\\s*\\\\)\", \"g\"), function (match, url) {\n      return \"url(\\'\" + fromDataUrl(url) + \"\\')\";\n    });\n  }\n  /**\n   * Retrieve the image URL with directive\n   *\n   * @param {Array} image\n   * @returns {string}\n   * @api\n   */\n\n\n  function getImageUrl(image) {\n    var imageUrl = image[0].url;\n    var mediaPath = imageUrl.split(_config.getConfig(\"media_url\"));\n    return \"{{media url=\" + mediaPath[1] + \"}}\";\n  }\n  /**\n   * Remove quotes in media directives, {{media url=\"wysiwyg/image.png\"}} convert to {{media url=wysiwyg/image.png}}\n   *\n   * @param {string} html\n   * @returns {string}\n   * @api\n   */\n\n\n  function removeQuotesInMediaDirectives(html) {\n    if (!html) {\n      return \"\";\n    }\n\n    var mediaDirectiveRegExp = /\\{\\{\\s*media\\s+url\\s*=\\s*(.*?)\\s*\\}\\}/g;\n    var urlRegExp = /\\{\\{\\s*media\\s+url\\s*=\\s*(.*)\\s*\\}\\}/;\n    var mediaDirectiveMatches = html.match(mediaDirectiveRegExp);\n\n    if (mediaDirectiveMatches) {\n      mediaDirectiveMatches.forEach(function (mediaDirective) {\n        var urlMatches = mediaDirective.match(urlRegExp);\n\n        if (urlMatches && urlMatches[1] !== undefined) {\n          var directiveWithOutQuotes = \"{{media url=\" + urlMatches[1].replace(/(\"|&quot;|\\s)/g, \"\") + \"}}\";\n          html = html.replace(mediaDirective, directiveWithOutQuotes);\n        }\n      });\n    }\n\n    return html;\n  }\n  /**\n   * Replace media directives with actual media URLs\n   *\n   * @param {string} html\n   * @returns {string}\n   * @api\n   */\n\n\n  function convertMediaDirectivesToUrls(html) {\n    if (!html) {\n      return \"\";\n    }\n\n    var mediaDirectiveRegExp = /\\{\\{\\s*media\\s+url\\s*=\\s*\"?[^\"\\s\\}]+\"?\\s*\\}\\}/g;\n    var mediaDirectiveMatches = html.match(mediaDirectiveRegExp);\n\n    if (mediaDirectiveMatches) {\n      mediaDirectiveMatches.forEach(function (mediaDirective) {\n        var urlRegExp = /\\{\\{\\s*media\\s+url\\s*=\\s*(?:\"|&quot;)?(.+)(?=}})\\s*\\}\\}/;\n        var urlMatches = mediaDirective.match(urlRegExp);\n\n        if (urlMatches && typeof urlMatches[1] !== \"undefined\") {\n          html = html.replace(mediaDirective, _config.getConfig(\"media_url\") + urlMatches[1].replace(/\"$/, \"\").replace(/&quot;$/, \"\"));\n        }\n      });\n    }\n\n    return html;\n  }\n  /**\n   * Replace data-src attribute with src.\n   *\n   * @param {string} html\n   * @returns {string}\n   */\n\n\n  function replaceWithSrc(html) {\n    return html.replace(new RegExp(\"data-tmp-src=\\\"\\{\\{\", \"g\"), \"src=\\\"{{\");\n  }\n  /**\n   * Replace src attribute with data-tmp-src.\n   *\n   * @param {string} html\n   * @returns {string}\n   */\n\n\n  function replaceWithDataSrc(html) {\n    return html.replace(new RegExp(\"src=\\\"\\{\\{\", \"g\"), \"data-tmp-src=\\\"{{\");\n  }\n\n  return Object.assign(decodeAllDataUrlsInString, {\n    toDataUrl: toDataUrl,\n    fromDataUrl: fromDataUrl,\n    getImageUrl: getImageUrl,\n    removeQuotesInMediaDirectives: removeQuotesInMediaDirectives,\n    convertMediaDirectivesToUrls: convertMediaDirectivesToUrls,\n    replaceWithSrc: replaceWithSrc,\n    replaceWithDataSrc: replaceWithDataSrc\n  });\n});\n//# sourceMappingURL=directives.js.map","Magento_PageBuilder/js/utils/url.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Check for whether url string contains only a path\n   *\n   * @param {String} url\n   * @returns {Boolean}\n   */\n  function isPathOnly(url) {\n    return url.indexOf(\"/\") === 0;\n  }\n  /**\n   * Get the path from a URL\n   *\n   * @param {String} url\n   * @returns {String}\n   */\n\n\n  function getPathFromUrl(url) {\n    var a = document.createElement(\"a\");\n    a.href = url;\n    return a.pathname;\n  }\n  /**\n   * Convert url to path if other url is only a path\n   *\n   * @param {string} url\n   * @param {string} otherUrl\n   * @returns {string}\n   * @api\n   */\n\n\n  function convertUrlToPathIfOtherUrlIsOnlyAPath(url, otherUrl) {\n    return isPathOnly(otherUrl) ? getPathFromUrl(url) : url;\n  }\n\n  return {\n    convertUrlToPathIfOtherUrlIsOnlyAPath: convertUrlToPathIfOtherUrlIsOnlyAPath\n  };\n});\n//# sourceMappingURL=url.js.map","Magento_PageBuilder/js/utils/map.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * googleMaps dependency is added within googlemaps.phtml through shim based on API key being set\n *\n * @api\n */\ndefine([\n    'underscore',\n    'module',\n    'Magento_PageBuilder/js/events'\n], function (_, module, events) {\n    'use strict';\n\n    var google = window.google || {},\n\n        /**\n         * Generates a google map usable latitude and longitude object\n         *\n         * @param {Object} position\n         * @return {google.maps.LatLng}\n         */\n        getGoogleLatitudeLongitude = function (position) {\n            return new google.maps.LatLng(position.latitude, position.longitude);\n        },\n        gmAuthFailure = false;\n\n    // jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n    /**\n     * Google's error listener for map loader failures\n     */\n    window.gm_authFailure = function () {\n        events.trigger('googleMaps:authFailure');\n        gmAuthFailure = true;\n    };\n    // jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n\n    return function (element, markers, additionalOptions) {\n        var options,\n            style;\n\n        // If we've previously had an API key error, throw the error even again\n        if (gmAuthFailure) {\n            events.trigger('googleMaps:authFailure');\n\n            return;\n        }\n\n        // If Google Maps isn't loaded don't try init the map, it won't work\n        if (typeof google.maps === 'undefined') {\n            return;\n        }\n\n        /**\n         * Just in case of a bad JSON that bypassed validation\n         */\n        try {\n            style = module.config().style ? JSON.parse(module.config().style) : [];\n        }\n        catch (error) {\n            style = [];\n        }\n        options = _.extend({\n            zoom: 8,\n            center: getGoogleLatitudeLongitude({\n                latitude: 30.2672,\n                longitude: -97.7431\n            }),\n            scrollwheel: false,\n            disableDoubleClickZoom: false,\n            disableDefaultUI: false,\n            mapTypeControl: true,\n            mapTypeControlOptions: {\n                style: google.maps.MapTypeControlStyle.DEFAULT\n            },\n            styles: style\n        }, additionalOptions);\n\n        /* Create the map */\n        this.map = new google.maps.Map(element, options);\n        this.markers = [];\n\n        /**\n         * Callback function on map config update\n         * @param {Array} newMarkers\n         * @param {Object} updateOptions\n         */\n        this.onUpdate = function (newMarkers, updateOptions) {\n            this.map.setOptions(updateOptions);\n            this.setMarkers(newMarkers);\n        };\n\n        /**\n         * Sets the markers to selected map\n         * @param {Object} newMarkers\n         */\n        this.setMarkers = function (newMarkers) {\n            var activeInfoWindow,\n                latitudeLongitudeBounds = new google.maps.LatLngBounds();\n\n            this.markers.forEach(function (marker) {\n                marker.setMap(null);\n            }, this);\n\n            this.markers = [];\n            this.bounds = [];\n\n            /**\n             * Creates and set listener for markers\n             */\n            if (newMarkers && newMarkers.length) {\n                newMarkers.forEach(function (newMarker) {\n                    var location = _.escape(newMarker['location_name']) || '',\n                    comment = newMarker.comment ?\n                        '<p>' + _.escape(newMarker.comment).replace(/(?:\\r\\n|\\r|\\n)/g, '<br/>') + '</p>'\n                        : '',\n                    phone = newMarker.phone ? '<p>Phone: ' + _.escape(newMarker.phone) + '</p>' : '',\n                    address = newMarker.address ? _.escape(newMarker.address) + '<br/>' : '',\n                    city = _.escape(newMarker.city) || '',\n                    country = newMarker.country ? _.escape(newMarker.country) : '',\n                    state = newMarker.state ? _.escape(newMarker.state) + ' ' : '',\n                    zipCode = newMarker.zipcode ? _.escape(newMarker.zipcode) : '',\n                    cityComma = city !== '' && (zipCode !== '' || state !== '') ? ', ' : '',\n                    lineBreak = city !== '' || zipCode !== '' ? '<br/>' : '',\n                    contentString =\n                        '<div>' +\n                        '<h3><b>' + location + '</b></h3>' +\n                        comment +\n                        phone +\n                        '<p><span>' + address +\n                        city + cityComma + state + zipCode + lineBreak +\n                        country + '</span></p>' +\n                        '</div>',\n                    infowindow = new google.maps.InfoWindow({\n                        content: contentString,\n                        maxWidth: 350\n                    }),\n                    newCreatedMarker = new google.maps.Marker({\n                        map: this.map,\n                        position: getGoogleLatitudeLongitude(newMarker.position),\n                        title: location\n                    });\n\n                    if (location) {\n                        newCreatedMarker.addListener('click', function () {\n                            if (activeInfoWindow) {\n                                activeInfoWindow.close();\n                            }\n\n                            infowindow.open(this.map, newCreatedMarker);\n                            activeInfoWindow = infowindow;\n                        }, this);\n                    }\n\n                    this.markers.push(newCreatedMarker);\n                    this.bounds.push(getGoogleLatitudeLongitude(newMarker.position));\n                }, this);\n            }\n\n            /**\n             * This sets the bounds of the map for multiple locations\n             */\n            if (this.bounds.length > 1) {\n                this.bounds.forEach(function (bound) {\n                    latitudeLongitudeBounds.extend(bound);\n                });\n                this.map.fitBounds(latitudeLongitudeBounds);\n            }\n\n            /**\n             * Zoom to 8 if there is only a single location\n             */\n            if (this.bounds.length === 1) {\n                this.map.setCenter(this.bounds[0]);\n                this.map.setZoom(8);\n            }\n        };\n\n        this.setMarkers(markers);\n    };\n});\n","Magento_PageBuilder/js/utils/promise-deferred.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Returns a deferred promise\n   *\n   * @returns {DeferredInterface}\n   * @api\n   */\n  function deferred() {\n    var resolve;\n    var reject;\n    var promise = new Promise(function (promiseResolve, promiseReject) {\n      resolve = promiseResolve;\n      reject = promiseReject;\n    });\n    return {\n      resolve: resolve,\n      reject: reject,\n      promise: promise\n    };\n  }\n\n  return deferred;\n});\n//# sourceMappingURL=promise-deferred.js.map","Magento_PageBuilder/js/utils/text.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  \"use strict\";\n});\n//# sourceMappingURL=text.js.map","Magento_PageBuilder/js/utils/loader.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  function load(dependencies, factory, onError) {\n    require(dependencies, factory, onError);\n  }\n\n  return load;\n});\n//# sourceMappingURL=loader.js.map","Magento_PageBuilder/js/binding/sortable.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\", \"knockout\", \"underscore\"], function (_jquery, _knockout, _underscore) {\n  \"use strict\";\n\n  _jquery = _interopRequireDefault(_jquery);\n  _knockout = _interopRequireDefault(_knockout);\n  _underscore = _interopRequireDefault(_underscore);\n\n  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  // Create a new sortable Knockout binding\n  _knockout.default.bindingHandlers.sortable = {\n    init: function init(element, valueAccessor) {\n      // As we can't conditionally apply bindings we block this operation when options are null\n      if (valueAccessor() === null) {\n        return;\n      }\n\n      _underscore.default.defer(function () {\n        (0, _jquery.default)(element).sortable(valueAccessor());\n      });\n    }\n  };\n});\n//# sourceMappingURL=sortable.js.map","Magento_PageBuilder/js/binding/draggable.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\", \"knockout\"], function (_jquery, _knockout) {\n  \"use strict\";\n\n  _jquery = _interopRequireDefault(_jquery);\n  _knockout = _interopRequireDefault(_knockout);\n\n  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  // Create a new sortable Knockout binding\n  _knockout.default.bindingHandlers.draggable = {\n    init: function init(element, valueAccessor) {\n      (0, _jquery.default)(element).draggable(valueAccessor());\n    }\n  };\n});\n//# sourceMappingURL=draggable.js.map","Magento_PageBuilder/js/binding/master-style.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"knockout\", \"mageUtils\", \"underscore\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type/style-registry\"], function (_knockout, _mageUtils, _underscore, _config, _styleRegistry) {\n  \"use strict\";\n\n  _knockout = _interopRequireDefault(_knockout);\n  _mageUtils = _interopRequireDefault(_mageUtils);\n  _underscore = _interopRequireDefault(_underscore);\n  _config = _interopRequireDefault(_config);\n\n  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var bodyId = _config.default.getConfig(\"bodyId\");\n\n  var getStyles = function getStyles(styleObject) {\n    var styles = {};\n\n    _knockout.default.utils.objectForEach(styleObject, function (styleName, styleValue) {\n      styleValue = _knockout.default.utils.unwrapObservable(styleValue);\n\n      if (styleValue === null || styleValue === undefined || styleValue === false) {\n        // Empty string removes the value, whereas null/undefined have no effect\n        styleValue = \"\";\n      }\n\n      if (styleValue) {\n        styles[styleName] = styleValue;\n      }\n    });\n\n    return styles;\n  };\n\n  _knockout.default.bindingHandlers.style = {\n    update: function update(element, valueAccessor, allBindings, viewModel, bindingContext) {\n      var value = _knockout.default.utils.unwrapObservable(valueAccessor() || {});\n\n      var viewportKeys = _underscore.default.keys(_config.default.getConfig(\"viewports\"));\n\n      var commonStyles = getStyles(_underscore.default.omit(value, viewportKeys));\n      var viewportStyles = {};\n\n      _underscore.default.each(viewportKeys, function (name) {\n        viewportStyles[name] = _underscore.default.extend(getStyles(value[name]), commonStyles);\n      });\n\n      if (_underscore.default.findKey(viewportStyles, function (styles) {\n        return !_underscore.default.isEmpty(styles);\n      })) {\n        var id = _mageUtils.default.uniqueid();\n\n        var selector = \"#\" + bodyId + \" [\" + _styleRegistry.pbStyleAttribute + \"=\\\"\" + id + \"\\\"]\";\n\n        _underscore.default.each(viewportKeys, function (name) {\n          var registry = (0, _styleRegistry.getStyleRegistry)(name + bindingContext.$root.id);\n          registry.setStyles(selector, viewportStyles[name]);\n        });\n\n        element.setAttribute(_styleRegistry.pbStyleAttribute, id);\n      }\n    }\n  };\n});\n//# sourceMappingURL=master-style.js.map","Magento_PageBuilder/js/binding/style.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"knockout\", \"mageUtils\", \"underscore\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type/style-registry\"], function (_knockout, _mageUtils, _underscore, _config, _styleRegistry) {\n  \"use strict\";\n\n  _knockout = _interopRequireDefault(_knockout);\n  _mageUtils = _interopRequireDefault(_mageUtils);\n  _underscore = _interopRequireDefault(_underscore);\n  _config = _interopRequireDefault(_config);\n\n  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var originalStyle = _knockout.default.bindingHandlers.style;\n\n  var bodyId = _config.default.getConfig(\"bodyId\");\n\n  function isPageBuilderContext(context) {\n    return !!(context.stage && context.stage.pageBuilder);\n  }\n\n  _knockout.default.bindingHandlers.style = {\n    init: function init(element, valueAccessor, allBindings, viewModel, bindingContext) {\n      if (isPageBuilderContext(bindingContext)) {\n        element.setAttribute(_styleRegistry.pbStyleAttribute, _mageUtils.default.uniqueid());\n      }\n    },\n    update: function update(element, valueAccessor, allBindings, viewModel, bindingContext) {\n      if (isPageBuilderContext(bindingContext)) {\n        var value = _knockout.default.utils.unwrapObservable(valueAccessor() || {});\n\n        var styles = {};\n        var styleId = element.getAttribute(_styleRegistry.pbStyleAttribute);\n        var existedStyleBlock = document.querySelector(\"style[\" + _styleRegistry.styleDataAttribute + \"=\\\"\" + styleId + \"\\\"]\");\n\n        _knockout.default.utils.objectForEach(value, function (styleName, styleValue) {\n          styleValue = _knockout.default.utils.unwrapObservable(styleValue);\n\n          if (styleValue === null || styleValue === undefined || styleValue === false) {\n            styleValue = \"\";\n          }\n\n          if (styleValue) {\n            styles[styleName] = styleValue;\n          }\n        });\n\n        if (existedStyleBlock) {\n          existedStyleBlock.remove();\n        }\n\n        if (!_underscore.default.isEmpty(styles)) {\n          var styleElement = document.createElement(\"style\");\n          styleElement.setAttribute(_styleRegistry.styleDataAttribute, styleId);\n          styleElement.innerHTML = (0, _styleRegistry.generateCssBlock)(\"#\" + bodyId + \" [\" + _styleRegistry.pbStyleAttribute + \"=\\\"\" + styleId + \"\\\"]\", styles);\n          element.parentElement.append(styleElement);\n        }\n      } else {\n        originalStyle.update(element, valueAccessor, allBindings, viewModel, bindingContext);\n      }\n    }\n  };\n});\n//# sourceMappingURL=style.js.map","Magento_PageBuilder/js/binding/focus.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"knockout\"], function (_knockout) {\n  \"use strict\";\n\n  _knockout = _interopRequireDefault(_knockout);\n\n  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  _knockout.default.bindingHandlers.hasFocusNoScroll = {\n    init: _knockout.default.bindingHandlers.hasFocus.init,\n    update: function update(element, valueAccessor, allBindingsAccessor, viewModel, bindingContext) {\n      var value = !!_knockout.default.utils.unwrapObservable(valueAccessor());\n      value ? element.focus({\n        preventScroll: true\n      }) : element.blur();\n    }\n  };\n});\n//# sourceMappingURL=focus.js.map","Magento_PageBuilder/js/binding/live-edit.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\", \"knockout\", \"Magento_Ui/js/lib/key-codes\", \"underscore\"], function (_jquery, _knockout, _keyCodes, _underscore) {\n  \"use strict\";\n\n  _jquery = _interopRequireDefault(_jquery);\n  _knockout = _interopRequireDefault(_knockout);\n  _keyCodes = _interopRequireDefault(_keyCodes);\n  _underscore = _interopRequireDefault(_underscore);\n\n  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n\n  /**\n   * Strip HTML and return text\n   *\n   * @param {string} html\n   * @returns {string}\n   */\n  function stripHtml(html) {\n    if (html) {\n      var htmlDocument = new DOMParser().parseFromString(html, \"text/html\");\n      return htmlDocument.body ? htmlDocument.body.textContent : \"\";\n    }\n\n    return html;\n  }\n  /**\n   * Add or remove the placeholder-text class from the element based on its content\n   *\n   * @param {Element} element\n   */\n\n\n  function handlePlaceholderClass(element) {\n    if (stripHtml(element.innerHTML).length === 0) {\n      element.innerHTML = \"\";\n      element.classList.add(\"placeholder-text\");\n    } else {\n      element.classList.remove(\"placeholder-text\");\n    }\n  } // Custom Knockout binding for live editing text inputs\n\n\n  _knockout.default.bindingHandlers.liveEdit = {\n    /**\n     * Init the live edit binding on an element\n     *\n     * @param {HTMLElement} element\n     * @param {() => any} valueAccessor\n     * @param {KnockoutAllBindingsAccessor} allBindings\n     * @param {any} viewModel\n     * @param {KnockoutBindingContext} bindingContext\n     */\n    init: function init(element, valueAccessor, allBindings, viewModel, bindingContext) {\n      var _valueAccessor = valueAccessor(),\n          field = _valueAccessor.field,\n          placeholder = _valueAccessor.placeholder,\n          _valueAccessor$select = _valueAccessor.selectAll,\n          selectAll = _valueAccessor$select === void 0 ? false : _valueAccessor$select;\n\n      var focusedValue = element.innerHTML;\n      var previouslyFocused = false;\n      var blurTimeout;\n      var lastUpdateValue;\n      /**\n       * Record the value on focus, only conduct an update when data changes\n       */\n\n      var onFocus = function onFocus() {\n        clearTimeout(blurTimeout);\n        focusedValue = stripHtml(element.innerHTML);\n        lastUpdateValue = focusedValue;\n\n        if (selectAll && element.innerHTML !== \"\" && !previouslyFocused) {\n          _underscore.default.defer(function () {\n            var selection = window.getSelection();\n            var range = document.createRange();\n            range.selectNodeContents(element);\n            selection.removeAllRanges();\n            selection.addRange(range);\n            previouslyFocused = true;\n          });\n        }\n      };\n      /**\n       * On blur change our timeout for previously focused. We require a flag to track whether the input has been\n       * focused and selected previously due to a bug in Firefox which doesn't handle focus events correctly when\n       * contenteditable is placed within an anchor.\n       */\n\n\n      var onBlur = function onBlur() {\n        blurTimeout = setTimeout(function () {\n          previouslyFocused = false;\n        }, 100);\n      };\n      /**\n       * Mousedown event on element\n       *\n       * @param {Event} event\n       */\n\n\n      var onMouseDown = function onMouseDown(event) {\n        event.stopPropagation();\n      };\n      /**\n       * Key down event on element\n       *\n       * Prevent styling such as bold, italic, and underline using keyboard commands, and prevent multi-line entries\n       *\n       * @param {JQueryEventObject} event\n       */\n\n\n      var onKeyDown = function onKeyDown(event) {\n        var key = _keyCodes.default[event.keyCode]; // command or control\n\n        if (event.metaKey || event.ctrlKey) {\n          if (key === \"bKey\" || key === \"iKey\" || key === \"uKey\") {\n            event.preventDefault();\n          }\n        }\n\n        if (key === \"enterKey\") {\n          event.preventDefault();\n        } // prevent slides from sliding\n\n\n        if (key === \"pageLeftKey\" || key === \"pageRightKey\") {\n          event.stopPropagation();\n        }\n      };\n      /**\n       * On key up update the view model to ensure all changes are saved\n       */\n\n\n      var onKeyUp = function onKeyUp() {\n        var strippedValue = stripHtml(element.innerHTML);\n\n        if (focusedValue !== strippedValue) {\n          lastUpdateValue = strippedValue;\n          viewModel.updateData(field, strippedValue);\n        }\n      };\n      /**\n       * Prevent content from being dropped inside of inline edit area\n       *\n       * @param {DragEvent} event\n       */\n\n\n      var onDrop = function onDrop(event) {\n        event.preventDefault();\n      };\n      /**\n       * Prevent content from being dragged\n       *\n       * @param {DragEvent} event\n       */\n\n\n      var onDragStart = function onDragStart(event) {\n        event.preventDefault();\n      };\n      /**\n       * Input event on element\n       */\n\n\n      var onInput = function onInput() {\n        handlePlaceholderClass(element);\n      };\n      /**\n       * On paste strip any HTML\n       */\n\n\n      var onPaste = function onPaste() {\n        // Record the original caret position so we can ensure we restore it at the correct position\n        var selection = window.getSelection();\n        var originalPositionStart = selection.getRangeAt(0).cloneRange().startOffset;\n        var originalPositionEnd = selection.getRangeAt(0).cloneRange().endOffset;\n        var originalContentLength = stripHtml(element.innerHTML).length; // Allow the paste action to update the content\n\n        _underscore.default.defer(function () {\n          var strippedValue = stripHtml(element.innerHTML);\n          lastUpdateValue = strippedValue;\n          element.textContent = strippedValue;\n          /**\n           * Calculate the position the caret should end up at, the difference in string length + the original\n           * end offset position\n           */\n\n          var restoredPosition = Math.abs(strippedValue.length - originalContentLength) + originalPositionStart; // If part of the text was selected adjust the position for the removed text\n\n          if (originalPositionStart !== originalPositionEnd) {\n            restoredPosition += Math.abs(originalPositionEnd - originalPositionStart);\n          }\n\n          var range = document.createRange();\n          range.setStart(element.childNodes[0], restoredPosition);\n          range.setEnd(element.childNodes[0], restoredPosition);\n          selection.removeAllRanges();\n          selection.addRange(range);\n        });\n      };\n\n      element.setAttribute(\"data-placeholder\", placeholder);\n      element.textContent = viewModel.contentType.dataStore.get(field);\n      element.contentEditable = \"true\";\n      element.addEventListener(\"focus\", onFocus);\n      element.addEventListener(\"blur\", onBlur);\n      element.addEventListener(\"mousedown\", onMouseDown);\n      element.addEventListener(\"keydown\", onKeyDown);\n      element.addEventListener(\"keyup\", onKeyUp);\n      element.addEventListener(\"input\", onInput);\n      element.addEventListener(\"drop\", onDrop);\n      element.addEventListener(\"paste\", onPaste);\n      element.addEventListener(\"dragstart\", onDragStart);\n      (0, _jquery.default)(element).parent().css(\"cursor\", \"text\");\n      handlePlaceholderClass(element); // Create a subscription onto the original data to update the internal value\n\n      viewModel.contentType.dataStore.subscribe(function (data) {\n        // Only update the value if it differs from the last value added within live edit\n        if (lastUpdateValue !== data[field]) {\n          lastUpdateValue = data[field];\n          element.textContent = data[field];\n          handlePlaceholderClass(element);\n        }\n      }, field); // Resolve issues of content editable being within an anchor\n\n      if ((0, _jquery.default)(element).parent().is(\"a\")) {\n        (0, _jquery.default)(element).parent().attr(\"draggable\", \"false\");\n      }\n    },\n\n    /**\n     * Update live edit binding on an element\n     *\n     * @param {any} element\n     * @param {() => any} valueAccessor\n     * @param {KnockoutAllBindingsAccessor} allBindings\n     * @param {any} viewModel\n     * @param {KnockoutBindingContext} bindingContext\n     */\n    update: function update(element, valueAccessor, allBindings, viewModel, bindingContext) {\n      var _valueAccessor2 = valueAccessor(),\n          field = _valueAccessor2.field;\n\n      element.textContent = viewModel.contentType.dataStore.get(field);\n      handlePlaceholderClass(element);\n    }\n  };\n});\n//# sourceMappingURL=live-edit.js.map","Magento_PageBuilder/js/binding/sortable-children.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\", \"knockout\", \"Magento_PageBuilder/js/events\", \"Magento_PageBuilder/js/drag-drop/move-content-type\", \"Magento_PageBuilder/js/utils/array\"], function (_jquery, _knockout, _events, _moveContentType, _array) {\n  \"use strict\";\n\n  _jquery = _interopRequireDefault(_jquery);\n  _knockout = _interopRequireDefault(_knockout);\n  _events = _interopRequireDefault(_events);\n\n  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var draggedContentType; // Create a new sortable Knockout binding\n\n  _knockout.default.bindingHandlers.sortableChildren = {\n    /**\n     * Init the draggable binding on an element\n     *\n     * @param element\n     * @param valueAccessor\n     * @param allBindingsAccessor\n     * @param data\n     * @param context\n     */\n    init: function init(element, valueAccessor, allBindingsAccessor, data, context) {\n      var instance = context.$data.contentType;\n\n      var options = _knockout.default.unwrap(valueAccessor());\n\n      var originalPosition;\n      (0, _jquery.default)(element).sortable(options).on(\"sortstart\", function (event, ui) {\n        originalPosition = ui.item.index();\n        draggedContentType = instance.children()[originalPosition];\n\n        _events.default.trigger(\"childContentType:sortStart\", {\n          instance: instance,\n          originalPosition: originalPosition,\n          ui: ui\n        });\n      }).on(\"sortstop\", function (event, ui) {\n        _events.default.trigger(\"childContentType:sortStop\", {\n          instance: instance,\n          ui: ui,\n          originalPosition: originalPosition\n        });\n      }).on(\"sortupdate\", function (event, ui) {\n        if (this === ui.item.parent()[0]) {\n          var index = ui.item.index();\n\n          var targetParent = _knockout.default.dataFor(ui.item.parent()[0]).contentType;\n\n          if (targetParent && (originalPosition !== index || draggedContentType.parentContentType !== targetParent)) {\n            ui.item.remove();\n\n            if (draggedContentType.parentContentType === targetParent) {\n              (0, _array.moveArrayItem)(instance.children, originalPosition, index);\n            } else {\n              (0, _moveContentType.moveContentType)(draggedContentType, index, targetParent);\n            }\n\n            _events.default.trigger(\"childContentType:sortUpdate\", {\n              instance: instance,\n              newPosition: index,\n              originalPosition: originalPosition,\n              ui: ui,\n              event: event\n            });\n          }\n        }\n      });\n    }\n  };\n});\n//# sourceMappingURL=sortable-children.js.map","Magento_PageBuilder/js/system/config/validator-rules-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    return function (target) {\n        $.validator.addMethod(\n            'validate-google-map-style',\n            function (value) {\n                if ($.mage.isEmptyNoTrim(value)) {\n                    return true;\n                }\n\n                try {\n                    JSON.parse(value);\n                } catch (e) {\n                    return false;\n                }\n\n                return true;\n            },\n            $.mage.__('Google Maps Style JSON is invalid. Please paste the valid JSON style.')\n        );\n\n        $.validator.addMethod(\n            'validate-greater-than-one',\n            function (value) {\n                return !(value <= 1);\n            },\n            $.mage.__('Please enter a number 2 or greater in this field.')\n        );\n\n        $.validator.addMethod(\n            'validate-default-grid-size',\n            function (value) {\n                return !(parseInt(value, 10) >\n                    parseInt($('[name=\"groups[pagebuilder][fields][column_grid_max][value]\"]').val(), 10)\n                );\n            },\n            $.mage.__('Default grid size must be less than the maximum grid size.')\n        );\n\n        return target;\n    };\n});\n","Magento_PageBuilder/js/system/config/google-maps-api-key-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['jquery'], function ($) {\n    'use strict';\n\n    /**\n     * Initialize click and input events to handle validation\n     *\n     * @param {Object} config\n     * @param {HTMLElement} el\n     */\n    var GoogleMapsApiKeyValidator = function (config, el) {\n        var sourceElement = $('#' + config.sourceField),\n            initialValue = sourceElement.val(),\n            resultElement = $('#' + config.elementId + ' > .result');\n\n        if (initialValue) {\n            $(el).attr('disabled', false);\n        }\n\n        $(el).click(function () {\n            var resultText = config.invalidLabel,\n                resultIcon = 'icon-admin-pagebuilder-error',\n                resultHtml;\n\n            $.ajax({\n                url: config.validateUrl,\n                showLoader: true,\n                data: {\n                    googleMapsApiKey: sourceElement.val()\n                }\n            }).done(function (data) {\n                if (data.success) {\n                    resultText = config.validLabel;\n                    resultIcon = 'icon-admin-pagebuilder-success';\n                }\n\n                resultHtml = '<i class=\"' + resultIcon + '\"></i> ' + resultText;\n                resultElement.html(resultHtml);\n            });\n        });\n\n        sourceElement.on('keyup', function (event) {\n            var elementValue = event.currentTarget.value,\n                buttonText = config.buttonLabel;\n\n            $(el).attr('disabled', !elementValue);\n            resultElement.html(buttonText);\n        });\n    };\n\n    return GoogleMapsApiKeyValidator;\n});\n","Magento_PageBuilder/js/system/config/switch-attribute-type.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/translate',\n    'Magento_Ui/js/modal/confirm',\n    'domReady!'\n], function ($, $t, confirm) {\n    'use strict';\n\n    return function (config, attributeDropDownEl) {\n\n        var $attributeDropDownEl = $(attributeDropDownEl),\n            previousOption = '';\n\n        $attributeDropDownEl.on('focus', function () {\n            // Store the current value on focus and on change\n            previousOption = this.value;\n        });\n\n        $attributeDropDownEl.on('change', function () {\n\n            if (attributeDropDownEl.options.length > 3 ||\n                this.value === 'pagebuilder' ||\n                previousOption !== 'pagebuilder'\n            ) {\n                return;\n            }\n\n            confirm({\n                title: $t(config.modalTitleText),\n                content: $t(config.modalContentBody),\n                buttons: [{\n                    text: $t('Cancel'),\n                    class: 'action-secondary action-dismiss action-pagebuilder-cancel',\n\n                    /**\n                     * Close modal and trigger 'cancel' action on click\n                     */\n                    click: function (event) {\n                        this.closeModal(event);\n                    }\n                }, {\n                    text: $t('Change Input Type'),\n                    class: 'action-primary action-accept',\n\n                    /**\n                     * Close modal and trigger 'confirm' action on click\n                     */\n                    click: function (event) {\n                        this.closeModal(event, true);\n                    }\n                }],\n                actions: {\n\n                    /**\n                     * Revert back to 'pagebuilder' setting\n                     */\n                    cancel: function () {\n                        $attributeDropDownEl.val('pagebuilder');\n                        $attributeDropDownEl.change();\n                    }\n                }\n            });\n        });\n    };\n});\n","Magento_PageBuilder/js/system/config/enable-field.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/translate',\n    'Magento_Ui/js/modal/confirm',\n    'domReady!'\n], function ($, $t, confirm) {\n    'use strict';\n\n    return function (config, enableSelectEl) {\n\n        var $enableSelectEl = $(enableSelectEl),\n            isEnabledInDatabase = !!parseInt($enableSelectEl.val(), 10);\n\n        $enableSelectEl.on('change', function () {\n            var userIsDisabling = !parseInt($enableSelectEl.val(), 10);\n\n            if (!isEnabledInDatabase || !userIsDisabling) {\n                return;\n            }\n\n            confirm({\n                title: $t(config.modalTitleText),\n                content: $t(config.modalContentBody),\n                buttons: [{\n                    text: $t('Cancel'),\n                    class: 'action-secondary action-dismiss action-pagebuilder-cancel',\n\n                    /**\n                     * Close modal and trigger 'cancel' action on click\n                     */\n                    click: function (event) {\n                        this.closeModal(event);\n                    }\n                }, {\n                    text: $t('Turn Off'),\n                    class: 'action-primary action-accept',\n\n                    /**\n                     * Close modal and trigger 'confirm' action on click\n                     */\n                    click: function (event) {\n                        this.closeModal(event, true);\n                    }\n                }],\n                actions: {\n\n                    /**\n                     * Revert back to original Enabled setting\n                     */\n                    cancel: function () {\n                        $enableSelectEl.val(Number(true));\n                    }\n                }\n            });\n        });\n    };\n});\n","Magento_PageBuilder/js/content-type-menu/edit.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/events\", \"mageUtils\", \"underscore\", \"Magento_PageBuilder/js/config\"], function (_events, _mageUtils, _underscore, _config) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var Edit = /*#__PURE__*/function () {\n    \"use strict\";\n\n    /**\n     * @param {ContentTypeInterface} instance\n     * @param {DataStore} dataStore\n     */\n    function Edit(instance, dataStore) {\n      var _this = this;\n\n      this.instance = instance;\n      this.dataStore = dataStore;\n\n      _events.on(\"form:\" + this.instance.id + \":saveAfter\", function (data) {\n        var viewport = _config.getConfig(\"viewport\");\n\n        var defaultViewport = _config.getConfig(\"defaultViewport\"); // set value to dataStore from default viewport if it is empty\n\n\n        if (defaultViewport !== viewport) {\n          _underscore.each(_this.instance.getViewportFields(viewport, data), function (value, key) {\n            var isEmpty = !_underscore.find(_mageUtils.compare(data[key], _this.instance.dataStores[defaultViewport].get(key)).changes, function (change) {\n              return !_underscore.isEmpty(change.oldValue);\n            });\n\n            if (isEmpty) {\n              _this.instance.dataStores[viewport].set(key, data[key]);\n\n              data[key] = _this.instance.dataStores[defaultViewport].get(key);\n            }\n          });\n        }\n\n        _this.dataStore.setState(_this.filterData(data));\n      });\n    }\n    /**\n     * Open the modal\n     */\n\n\n    var _proto = Edit.prototype;\n\n    _proto.open = function open() {\n      var _this2 = this;\n\n      var contentTypeData = this.dataStore.getState();\n\n      var viewport = _config.getConfig(\"viewport\");\n\n      var defaultViewport = _config.getConfig(\"defaultViewport\"); // set empty value if it the same in default viewport\n\n\n      if (defaultViewport !== viewport) {\n        _underscore.each(this.instance.getViewportFields(viewport, contentTypeData), function (value, key) {\n          if (_mageUtils.compare(contentTypeData[key], _this2.instance.dataStores.desktop.get(key)).equal) {\n            contentTypeData[key] = undefined;\n          }\n        });\n      }\n\n      _events.trigger(\"contentType:editBefore\", {\n        contentType: this.instance\n      });\n\n      _events.trigger(\"form:renderAfter\", {\n        data: contentTypeData,\n        appearances: this.instance.config.appearances,\n        defaultNamespace: this.getDefaultNamespaceForm(),\n        id: this.instance.id,\n        namespace: this.getFormNamespace(contentTypeData),\n        title: this.instance.config.label\n      });\n    }\n    /**\n     * Flip flop to JSON and back again to ensure all data received from the form is serializable. Magento by default\n     * adds functions into some basic types which cannot be serialized when calling PostMessage.\n     *\n     * @param {DataObject} data\n     * @returns {DataObject}\n     */\n    ;\n\n    _proto.filterData = function filterData(data) {\n      return JSON.parse(JSON.stringify(data));\n    }\n    /**\n     * Determine the form namespace based on the currently set appearance\n     *\n     * @param {DataObject} contentTypeData\n     * @returns {string}\n     */\n    ;\n\n    _proto.getFormNamespace = function getFormNamespace(contentTypeData) {\n      var viewport = this.instance.preview.viewport();\n      var currentAppearance = this.dataStore.get(\"appearance\");\n      var appearance = this.instance.config.appearances[currentAppearance];\n      var breakpoints = appearance.breakpoints;\n      var formNamespace = this.getDefaultNamespaceForm(); // Use the default form unless a custom one is defined\n\n      if (breakpoints && breakpoints[viewport] && breakpoints[viewport].form) {\n        formNamespace = breakpoints[viewport].form;\n      } else if (!_underscore.isUndefined(appearance.form)) {\n        formNamespace = appearance.form;\n      }\n\n      return formNamespace;\n    }\n    /**\n     * Determine the form default namespace based on the currently set appearance and breakpoint\n     *\n     * @returns {string}\n     */\n    ;\n\n    _proto.getDefaultNamespaceForm = function getDefaultNamespaceForm() {\n      var viewport = this.instance.preview.viewport();\n      var breakpoints = this.instance.config.breakpoints;\n      var formNamespace = this.instance.config.form;\n\n      if (breakpoints && breakpoints[viewport] && breakpoints[viewport].form) {\n        formNamespace = breakpoints[viewport].form;\n      }\n\n      return formNamespace;\n    };\n\n    return Edit;\n  }();\n\n  return Edit;\n});\n//# sourceMappingURL=edit.js.map","Magento_PageBuilder/js/content-type-menu/conditional-remove-option.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"Magento_PageBuilder/js/content-type-menu/option\"], function (_option) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var ConditionalRemoveOption = /*#__PURE__*/function (_option2) {\n    \"use strict\";\n\n    _inheritsLoose(ConditionalRemoveOption, _option2);\n\n    /**\n     * @param {OptionConfigInterface} config\n     */\n    function ConditionalRemoveOption(config) {\n      var _this;\n\n      _this = _option2.call(this, config) || this;\n      var parentContentType = _this.preview.contentType.parentContentType;\n\n      if (parentContentType.children().length < 2) {\n        _this.isDisabled(true);\n      }\n\n      parentContentType.children.subscribe(function (children) {\n        _this.isDisabled(children.length < 2);\n      });\n      return _this;\n    }\n\n    return ConditionalRemoveOption;\n  }(_option);\n\n  return ConditionalRemoveOption;\n});\n//# sourceMappingURL=conditional-remove-option.js.map","Magento_PageBuilder/js/content-type-menu/option.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }\n\ndefine([\"knockout\"], function (_knockout) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var Option = /*#__PURE__*/function () {\n    \"use strict\";\n\n    /**\n     * @param {OptionConfigInterface} config\n     */\n    function Option(config) {\n      var _this = this;\n\n      this.icon = _knockout.observable(\"\");\n      this.title = _knockout.observable(\"\");\n      this.classes = _knockout.observable({});\n      this.isDisabled = _knockout.observable(false);\n      this.config = config;\n      this.preview = config.preview;\n      this.icon(config.icon);\n      this.title(config.title);\n      this.code = config.code;\n      this.sort = config.sort || 0;\n      this.customTemplate = config.template; // Generate an array of classes for KO to consume\n\n      var koClasses = {};\n\n      if (config.classes && config.classes.length > 0) {\n        config.classes.forEach(function (cssClass) {\n          koClasses[cssClass] = true;\n        });\n      } // Always add a disabled class which tracks whether this option is disabled\n\n\n      koClasses.disabled = this.isDisabled;\n      this.classes(koClasses); // If no action is supplied pass an empty function, this is called within the context of the preview\n\n      var action = config.action ? config.action : function () {\n        return;\n      };\n\n      this.action = function () {\n        if (!_this.isDisabled()) {\n          for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {\n            args[_key] = arguments[_key];\n          }\n\n          action.apply(_this.preview, args);\n        }\n      };\n    }\n\n    _createClass(Option, [{\n      key: \"template\",\n      get: function get() {\n        return this.customTemplate || null;\n      }\n    }]);\n\n    return Option;\n  }();\n\n  return Option;\n});\n//# sourceMappingURL=option.js.map","Magento_PageBuilder/js/content-type-menu/title-option.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"Magento_PageBuilder/js/content-type-menu/option\"], function (_option) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var TitleOption = /*#__PURE__*/function (_option2) {\n    \"use strict\";\n\n    _inheritsLoose(TitleOption, _option2);\n\n    /**\n     * @param {OptionConfigInterface} options\n     */\n    function TitleOption(options) {\n      var _this;\n\n      _this = _option2.call(this, options) || this; // Modify the icon when changes are made to display in the data store\n\n      _this.preview.displayLabel.subscribe(function (label) {\n        _this.title(label);\n      });\n\n      return _this;\n    }\n\n    return TitleOption;\n  }(_option);\n\n  return TitleOption;\n});\n//# sourceMappingURL=title-option.js.map","Magento_PageBuilder/js/content-type-menu/hide-show-option.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"mage/translate\", \"Magento_PageBuilder/js/content-type-menu/option\"], function (_translate, _option) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var HideShowOption = /*#__PURE__*/function (_option2) {\n    \"use strict\";\n\n    _inheritsLoose(HideShowOption, _option2);\n\n    /**\n     * @param {OptionConfigInterface} options\n     */\n    function HideShowOption(options) {\n      var _this;\n\n      _this = _option2.call(this, options) || this; // Modify the icon when changes are made to display in the data store\n\n      _this.preview.contentType.dataStore.subscribe(_this.onDisplayChange.bind(_assertThisInitialized(_this)), \"display\");\n\n      return _this;\n    }\n    /**\n     * On display change update the title and icon\n     *\n     * @param {DataObject} state\n     */\n\n\n    var _proto = HideShowOption.prototype;\n\n    _proto.onDisplayChange = function onDisplayChange(state) {\n      var display = !!state.display;\n\n      if (display) {\n        this.icon(HideShowOption.hideIcon);\n        this.title(HideShowOption.hideText);\n      } else {\n        this.icon(HideShowOption.showIcon);\n        this.title(HideShowOption.showText);\n      }\n    };\n\n    return HideShowOption;\n  }(_option);\n\n  HideShowOption.showText = (0, _translate)(\"Show\");\n  HideShowOption.showIcon = \"<i class='icon-pagebuilder-show'></i>\";\n  HideShowOption.hideText = (0, _translate)(\"Hide\");\n  HideShowOption.hideIcon = \"<i class='icon-pagebuilder-hide'></i>\";\n  return HideShowOption;\n});\n//# sourceMappingURL=hide-show-option.js.map","Magento_PageBuilder/js/master-format/filter-html.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\"], function (_jquery) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Filter the HTML output to only include necessary attributes & nodes\n   *\n   * @param {JQuery} element\n   * @returns {JQuery}\n   */\n  function filterHtml(element) {\n    var isWhiteSpaceOrComment = function isWhiteSpaceOrComment() {\n      return this.nodeType === Node.COMMENT_NODE || this.nodeType === Node.TEXT_NODE && this.data.match(/^\\s+$/);\n    };\n\n    element.find(\"[data-bind]\").each(function (index, value) {\n      (0, _jquery)(value).removeAttr(\"data-bind\");\n    });\n    element.contents().filter(isWhiteSpaceOrComment).remove();\n    element.find(\"*\").filter(function (index, descendentEl) {\n      // filter out elements that are iframes or have .bypass-html-filter ancestor\n      var isIframe = descendentEl.tagName === \"IFRAME\";\n      var isBeingBypassedByThisFilter = !!(0, _jquery)(descendentEl).closest(\".bypass-html-filter\").length;\n      return !isIframe && !isBeingBypassedByThisFilter;\n    }).each(function (index, descendentEl) {\n      (0, _jquery)(descendentEl).contents().filter(isWhiteSpaceOrComment).remove();\n    });\n    element.find(\"[data-wrapper]\").each(function (index, value) {\n      (0, _jquery)(value).parent().append((0, _jquery)(value).children());\n      (0, _jquery)(value).remove();\n    });\n    element.find(\".bypass-html-filter\").each(function (index, value) {\n      (0, _jquery)(value).removeClass(\"bypass-html-filter\").filter('[class=\"\"]').removeAttr(\"class\");\n    });\n    return element;\n  }\n\n  return filterHtml;\n});\n//# sourceMappingURL=filter-html.js.map","Magento_PageBuilder/js/master-format/validator.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/config\"], function (_config) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Validate if content has page builder format by checking for any data-content-type attributes\n   *\n   * @param {string} content\n   * @returns {boolean}\n   */\n  function validate(content) {\n    var stageDocument = new DOMParser().parseFromString(content, \"text/html\");\n    return !!stageDocument.querySelector(\"[\" + _config.getConfig(\"dataContentTypeAttributeName\") + \"]\");\n  }\n\n  return validate;\n});\n//# sourceMappingURL=validator.js.map","Magento_PageBuilder/js/master-format/render.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/master-format/render/serialize\"], function (_jquery, _config, _serialize) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var MasterFormatRenderer = /*#__PURE__*/function () {\n    \"use strict\";\n\n    /**\n     * @param stageId\n     */\n    function MasterFormatRenderer(stageId) {\n      this.ready = false;\n      this.readyDeferred = _jquery.Deferred();\n      this.stageId = stageId;\n    }\n    /**\n     * Render the root container into a string utilising our sandboxed iframe\n     *\n     * @param {ContentTypeCollection} rootContainer\n     * @returns {Promise<string>}\n     */\n\n\n    var _proto = MasterFormatRenderer.prototype;\n\n    _proto.applyBindings = function applyBindings(rootContainer) {\n      var _this = this;\n\n      return new Promise(function (resolve, reject) {\n        if (!_this.getRenderFrame()) {\n          // If the stage exists we should also have a frame\n          if (document.getElementById(_this.stageId)) {\n            return reject(\"No render frame present for Page Builder instance.\");\n          } // Otherwise the instance of Page Builder has been removed from the DOM and this is an old instance.\n\n\n          return reject();\n        }\n\n        if (_this.ready) {\n          _this.channel.port1.postMessage({\n            type: \"render\",\n            message: {\n              stageId: _this.stageId,\n              tree: (0, _serialize.getSerializedTree)(rootContainer)\n            }\n          });\n\n          _this.channel.port1.onmessage = function (event) {\n            if (event.isTrusted) {\n              if (event.data.type === \"render\") {\n                resolve(event.data.message);\n              }\n\n              if (event.data.type === \"template\") {\n                _this.loadTemplate(event.data.message);\n              }\n            } else {\n              reject(\"Render event was not trusted.\");\n            }\n          };\n        } else {\n          _this.readyDeferred.then(function () {\n            _this.applyBindings(rootContainer).then(function (rendered) {\n              resolve(rendered);\n            }).catch(function (error) {\n              reject(error);\n            });\n          });\n        }\n      });\n    }\n    /**\n     * Create a channel to communicate with our sandboxed iframe. Firstly add a listener to the current window and then\n     * set the src of the iframe. Listening for a specific message event with a predefined term and then hand over the\n     * MessageChannel port to allow communication between the main window and iframe.\n     */\n    ;\n\n    _proto.setupChannel = function setupChannel() {\n      var _this2 = this;\n\n      this.channel = new MessageChannel();\n      var frame = this.getRenderFrame();\n      window.addEventListener(\"message\", function (event) {\n        if (!_this2.ready && event.data.name === \"PB_RENDER_READY\" && _this2.stageId === event.data.stageId) {\n          frame.contentWindow.postMessage(\"PB_RENDER_PORT\", \"*\", [_this2.channel.port2]);\n          _this2.ready = true;\n\n          _this2.readyDeferred.resolve();\n        }\n      });\n      frame.src = _config.getConfig(\"render_url\") + \"?stageId=\" + this.stageId;\n    }\n    /**\n     * Use the text! RequireJS plugin to load a template and send it back to the child render iframe\n     *\n     * @param name\n     */\n    ;\n\n    _proto.loadTemplate = function loadTemplate(name) {\n      var _this3 = this;\n\n      require([\"text!\" + name], function (template) {\n        _this3.channel.port1.postMessage({\n          type: \"template\",\n          message: {\n            name: name,\n            template: template\n          }\n        });\n      });\n    }\n    /**\n     * Retrieve the render frame\n     *\n     * @returns {HTMLIFrameElement}\n     */\n    ;\n\n    _proto.getRenderFrame = function getRenderFrame() {\n      return document.getElementById(\"render_frame_\" + this.stageId);\n    };\n\n    return MasterFormatRenderer;\n  }();\n\n  return MasterFormatRenderer;\n});\n//# sourceMappingURL=render.js.map","Magento_PageBuilder/js/master-format/read-interface.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  \"use strict\";\n});\n//# sourceMappingURL=read-interface.js.map","Magento_PageBuilder/js/master-format/read/configurable.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _createForOfIteratorHelperLoose(o, allowArrayLike) { var it = typeof Symbol !== \"undefined\" && o[Symbol.iterator] || o[\"@@iterator\"]; if (it) return (it = it.call(o)).next.bind(it); if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === \"number\") { if (it) o = it; var i = 0; return function () { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }; } throw new TypeError(\"Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\ndefine([\"jquery\", \"mageUtils\", \"underscore\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type/appearance-config\", \"Magento_PageBuilder/js/converter/converter-pool-factory\", \"Magento_PageBuilder/js/mass-converter/converter-pool-factory\", \"Magento_PageBuilder/js/property/property-reader-pool-factory\"], function (_jquery, _mageUtils, _underscore, _config, _appearanceConfig, _converterPoolFactory, _converterPoolFactory2, _propertyReaderPoolFactory) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Configurable = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Configurable() {}\n\n    var _proto = Configurable.prototype;\n\n    /**\n     * Read data from the dom based on configuration\n     *\n     * @param element HTMLElement\n     * @returns {Promise<any>}\n     */\n    _proto.read = function read(element) {\n      var _this = this;\n\n      var role = element.getAttribute(_config.getConfig(\"dataContentTypeAttributeName\"));\n      var config = (0, _appearanceConfig)(role, element.getAttribute(\"data-appearance\"));\n      var componentsPromise = [(0, _propertyReaderPoolFactory)(role), (0, _converterPoolFactory)(role), (0, _converterPoolFactory2)(role)];\n      return new Promise(function (resolve) {\n        Promise.all(componentsPromise).then(function (loadedComponents) {\n          var propertyReaderPool = loadedComponents[0],\n              converterPool = loadedComponents[1],\n              massConverterPool = loadedComponents[2];\n\n          var viewports = _config.getConfig(\"viewports\");\n\n          var data = {};\n\n          _underscore.each(viewports, function (viewport, name) {\n            return data[name] = {};\n          });\n\n          var _loop = function _loop() {\n            var elementName = _Object$keys[_i];\n            var elementConfig = config.elements[elementName];\n\n            var currentElement = _this.findElementByName(element, elementName); // If we cannot locate the current element skip trying to read any attributes from it\n\n\n            if (currentElement === null || currentElement === undefined) {\n              return \"continue\";\n            }\n\n            _underscore.each(viewports, function (viewportObj, viewport) {\n              currentElement.setAttribute(\"style\", currentElement.getAttribute(\"data-\" + viewport + \"-style\"));\n\n              if (elementConfig.style.length) {\n                data[viewport] = _this.readStyle(elementConfig.style, currentElement, data[viewport], propertyReaderPool, converterPool);\n              }\n\n              if (elementConfig.attributes.length) {\n                data[viewport] = _this.readAttributes(elementConfig.attributes, currentElement, data[viewport], propertyReaderPool, converterPool);\n              }\n\n              if (undefined !== elementConfig.html.var) {\n                data[viewport] = _this.readHtml(elementConfig, currentElement, data[viewport], converterPool);\n              }\n\n              if (undefined !== elementConfig.tag.var) {\n                data[viewport] = _this.readHtmlTag(elementConfig, currentElement, data[viewport]);\n              }\n\n              if (undefined !== elementConfig.css.var) {\n                data[viewport] = _this.readCss(elementConfig, currentElement, data[viewport]);\n              }\n            });\n          };\n\n          for (var _i = 0, _Object$keys = Object.keys(config.elements); _i < _Object$keys.length; _i++) {\n            var _ret = _loop();\n\n            if (_ret === \"continue\") continue;\n          }\n\n          _underscore.each(viewports, function (viewportObj, viewport) {\n            data[viewport] = _this.convertData(config, data[viewport], massConverterPool);\n          });\n\n          resolve(data);\n        }).catch(function (error) {\n          console.error(error);\n        });\n      });\n    }\n    /**\n     * Find the element for the current content type by it's name, avoiding searching in other content types by\n     * removing any other element which contains it's own data-content-type.\n     *\n     * @param {HTMLElement} element\n     * @param {string} name\n     * @returns {HTMLElement}\n     */\n    ;\n\n    _proto.findElementByName = function findElementByName(element, name) {\n      // Create a clone of the element to avoid modifying the source\n      var currentElement = (0, _jquery)(element).clone();\n\n      if (currentElement.attr(\"data-element\") === name) {\n        return currentElement[0];\n      } // Attempt to find the element in the children of the data-content-type\n\n\n      var searchInChildren = currentElement.find(\"[data-element=\\\"\" + name + \"\\\"]\"); // Ensure the element is within the current content type\n\n      if (searchInChildren.length > 0 && searchInChildren.closest(\"[data-content-type]\")[0] === currentElement[0]) {\n        return searchInChildren[0];\n      }\n\n      return null;\n    }\n    /**\n     * Read attributes for element\n     *\n     * @param {DataMappingAttributesInterface[]} config\n     * @param {HTMLElement} element\n     * @param {object} data\n     * @param {typeof PropertyReaderPool} propertyReaderPool\n     * @param {typeof ConverterPool} converterPool\n     * @returns {any}\n     */\n    ;\n\n    _proto.readAttributes = function readAttributes(config, element, data, propertyReaderPool, converterPool) {\n      var result = {};\n\n      for (var _iterator = _createForOfIteratorHelperLoose(config), _step; !(_step = _iterator()).done;) {\n        var attributeConfig = _step.value;\n\n        if (\"write\" === attributeConfig.persistence_mode) {\n          continue;\n        }\n\n        var value = !!attributeConfig.static ? attributeConfig.value : propertyReaderPool.get(attributeConfig.reader).read(element, attributeConfig.name);\n\n        if (converterPool.get(attributeConfig.converter)) {\n          value = converterPool.get(attributeConfig.converter).fromDom(value);\n        }\n\n        if (_jquery.type(result[attributeConfig.var]) === \"object\") {\n          var _mageUtils$extend;\n\n          value = _mageUtils.extend((_mageUtils$extend = {}, _mageUtils$extend[attributeConfig.name] = value, _mageUtils$extend), result[attributeConfig.var]);\n        }\n\n        result[attributeConfig.var] = value;\n      }\n\n      return _underscore.extend(data, result);\n    }\n    /**\n     * Read style properties for element\n     *\n     * @param {DataMappingStyleInterface[]} config\n     * @param {HTMLElement} element\n     * @param {object} data\n     * @param {typeof PropertyReaderPool} propertyReaderPool\n     * @param {typeof ConverterPool} converterPool\n     * @returns {{[p: string]: string}}\n     */\n    ;\n\n    _proto.readStyle = function readStyle(config, element, data, propertyReaderPool, converterPool) {\n      var result = _underscore.extend({}, data);\n\n      for (var _iterator2 = _createForOfIteratorHelperLoose(config), _step2; !(_step2 = _iterator2()).done;) {\n        var propertyConfig = _step2.value;\n\n        if (\"write\" === propertyConfig.persistence_mode) {\n          continue;\n        }\n\n        var value = !!propertyConfig.static ? propertyConfig.value : propertyReaderPool.get(propertyConfig.reader).read(element, propertyConfig.name);\n\n        if (converterPool.get(propertyConfig.converter)) {\n          value = converterPool.get(propertyConfig.converter).fromDom(value);\n        }\n\n        if (_jquery.type(result[propertyConfig.var]) === \"object\") {\n          value = _mageUtils.extend(result[propertyConfig.var], value);\n        }\n\n        result[propertyConfig.var] = value;\n      }\n\n      return result;\n    }\n    /**\n     * Read element's tag\n     *\n     * @param {object} config\n     * @param {HTMLElement} element\n     * @param {object} data\n     * @returns {object}\n     */\n    ;\n\n    _proto.readHtmlTag = function readHtmlTag(config, element, data) {\n      var result = {};\n      result[config.tag.var] = element.nodeName.toLowerCase();\n      return _underscore.extend(data, result);\n    }\n    /**\n     * Read element's css\n     *\n     * @param {ContentTypeConfigAppearanceElementInterface} config\n     * @param {HTMLElement} element\n     * @param {object} data\n     * @returns {any}\n     */\n    ;\n\n    _proto.readCss = function readCss(config, element, data) {\n      var result = {};\n      var css = element.getAttribute(\"class\") !== null ? element.getAttribute(\"class\") : \"\";\n\n      if (config.css !== undefined && config.css.filter !== undefined && config.css.filter.length) {\n        for (var _iterator3 = _createForOfIteratorHelperLoose(config.css.filter), _step3; !(_step3 = _iterator3()).done;) {\n          var filterClass = _step3.value;\n          css = css.replace(filterClass, \"\");\n        }\n      }\n\n      result[config.css.var] = css.replace(/\\s{2,}/g, \" \").trim();\n      return _underscore.extend(data, result);\n    }\n    /**\n     * Read element's content\n     *\n     * @param {ContentTypeConfigAppearanceElementInterface} config\n     * @param {HTMLElement} element\n     * @param {object} data\n     * @param {typeof ConverterPool} converterPool\n     * @returns {any}\n     */\n    ;\n\n    _proto.readHtml = function readHtml(config, element, data, converterPool) {\n      var result = {};\n      var value = element.innerHTML;\n\n      if (converterPool.get(config.html.converter)) {\n        value = converterPool.get(config.html.converter).fromDom(value);\n      }\n\n      result[config.html.var] = value;\n      return _underscore.extend(data, result);\n    }\n    /**\n     * Convert data after it's read for all elements\n     *\n     * @param config\n     * @param {object} data\n     * @param {typeof MassConverterPool} massConverterPool\n     * @returns {object}\n     */\n    ;\n\n    _proto.convertData = function convertData(config, data, massConverterPool) {\n      for (var _iterator4 = _createForOfIteratorHelperLoose(config.converters), _step4; !(_step4 = _iterator4()).done;) {\n        var converterConfig = _step4.value;\n\n        if (massConverterPool.get(converterConfig.component)) {\n          data = massConverterPool.get(converterConfig.component).fromDom(data, converterConfig.config);\n        }\n      }\n\n      return data;\n    };\n\n    return Configurable;\n  }();\n\n  return Configurable;\n});\n//# sourceMappingURL=configurable.js.map","Magento_PageBuilder/js/master-format/render/events.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * The frame does not need to create or observe events, however the app will naturally attempt to. So let's stop that!\n   */\n  var _default = {\n    on: function on() {\n      return this;\n    },\n    off: function off() {\n      return this;\n    },\n    trigger: function trigger() {\n      return this;\n    }\n  };\n  return _default;\n});\n//# sourceMappingURL=events.js.map","Magento_PageBuilder/js/master-format/render/serialize.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type-collection\"], function (_config, _contentTypeCollection) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Serialize the tree as a simplified object for rendering\n   *\n   * @param contentType\n   */\n  function buildTree(contentType) {\n    var data = getData(contentType);\n    var viewportsData = getViewportsData(contentType);\n    var tree = {\n      name: contentType.config.name,\n      id: contentType.id,\n      data: data,\n      children: [],\n      viewportsData: viewportsData\n    };\n\n    if (contentType instanceof _contentTypeCollection && contentType.getChildren()().length > 0) {\n      contentType.getChildren()().forEach(function (child) {\n        tree.children.push(buildTree(child));\n      });\n    }\n\n    return tree;\n  }\n  /**\n   * Get a serialized version of the tree\n   *\n   * @param contentType\n   */\n\n\n  function getSerializedTree(contentType) {\n    return buildTree(contentType);\n  }\n  /**\n   * Retrieve the master data from the content types instance\n   *\n   * @param contentType\n   */\n\n\n  function getData(contentType) {\n    /**\n     * Flip flop to JSON and back again to ensure all data is serializable. Magento by default adds functions into\n     * some basic types which cannot be serialized when calling PostMessage.\n     */\n    return JSON.parse(JSON.stringify(contentType.dataStores[_config.getConfig(\"defaultViewport\")].getState())) || {};\n  }\n  /**\n   * Retrieve the master data from the content types instance\n   *\n   * @param contentType\n   */\n\n\n  function getViewportsData(contentType) {\n    /**\n     * Flip flop to JSON and back again to ensure all data is serializable. Magento by default adds functions into\n     * some basic types which cannot be serialized when calling PostMessage.\n     */\n    var result = {};\n    Object.keys(contentType.dataStores).forEach(function (name) {\n      result[name] = JSON.parse(JSON.stringify(contentType.dataStores[name].getState())) || {};\n    });\n    return result;\n  }\n\n  return {\n    buildTree: buildTree,\n    getSerializedTree: getSerializedTree\n  };\n});\n//# sourceMappingURL=serialize.js.map","Magento_PageBuilder/js/master-format/render/frame.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"csso\", \"jquery\", \"knockout\", \"Magento_Ui/js/lib/knockout/template/engine\", \"mageUtils\", \"underscore\", \"Magento_PageBuilder/js/binding/master-style\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type-factory\", \"Magento_PageBuilder/js/content-type/style-registry\", \"Magento_PageBuilder/js/utils/directives\", \"Magento_PageBuilder/js/master-format/filter-html\"], function (_csso, _jquery, _knockout, _engine, _mageUtils, _underscore, _masterStyle, _config, _contentTypeFactory, _styleRegistry, _directives, _filterHtml) {\n  function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== \"function\") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }\n\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var port = null;\n\n  var portDeferred = _jquery.Deferred();\n\n  var deferredTemplates = {};\n  var lastRenderId;\n  /**\n   * Debounce the render call, so we don't render until the final request\n   */\n\n  var debounceRender = _underscore.debounce(function (message, renderId) {\n    render(message, renderId).then(function (output) {\n      // Only post the most recent render back to the parent\n      if (lastRenderId === renderId) {\n        port.postMessage({\n          type: \"render\",\n          message: output\n        });\n      }\n    });\n  }, 50);\n  /**\n   * Listen for requests from the parent window for a render\n   */\n\n\n  function listen(config) {\n    var stageId = window.location.href.split(\"?\")[1].split(\"=\")[1];\n\n    _config.setConfig(config);\n\n    _config.setMode(\"Master\"); // Override assign with extend to prevent deep object overriding.\n\n\n    Object.assign = _mageUtils.extend;\n    /**\n     * Create a listener within our iframe so we can observe messages from the parent, once we receive a port on the\n     * MessageChannel we utilise that for all communication.\n     */\n\n    window.addEventListener(\"message\", function (event) {\n      if (event.ports && event.ports.length) {\n        port = event.ports[0];\n        portDeferred.resolve(port);\n\n        port.onmessage = function (messageEvent) {\n          if (messageEvent.data.type === \"render\") {\n            var renderId = _mageUtils.uniqueid();\n\n            lastRenderId = renderId;\n            debounceRender(messageEvent.data.message, renderId);\n          }\n\n          if (messageEvent.data.type === \"template\") {\n            var message = messageEvent.data.message;\n\n            if (message.name in deferredTemplates) {\n              deferredTemplates[message.name].resolve(message.template);\n              delete deferredTemplates[message.name];\n            }\n          }\n        };\n      }\n    }, false); // Inform the parent iframe that we're ready to receive the port\n\n    window.parent.postMessage({\n      name: \"PB_RENDER_READY\",\n      stageId: stageId\n    }, \"*\");\n  }\n  /**\n   * Use our MessageChannel to load a template from the parent window, this is required as the iframe isn't allowed to\n   * make same origin XHR requests.\n   *\n   * @param name\n   */\n\n\n  function loadTemplate(name) {\n    return new Promise(function (resolve) {\n      if (!(name in deferredTemplates)) {\n        deferredTemplates[name] = _jquery.Deferred();\n      }\n\n      deferredTemplates[name].then(function (template) {\n        resolve(template);\n      });\n\n      if (port) {\n        port.postMessage({\n          type: \"template\",\n          message: name\n        });\n      } else {\n        portDeferred.then(function (messagePort) {\n          messagePort.postMessage({\n            type: \"template\",\n            message: name\n          });\n        });\n      }\n    });\n  }\n  /**\n   * Assert if the render has finished\n   */\n\n\n  var assertRenderFinished = _underscore.debounce(function (element, expectedCount, callback) {\n    if (element.querySelectorAll(\"[data-content-type]\").length === expectedCount) {\n      callback();\n    }\n  }, 50);\n  /**\n   * Iterate over the root container and count all content types\n   *\n   * @param rootContainer\n   * @param count\n   */\n\n\n  function countContentTypes(rootContainer, count) {\n    count = count || 0;\n    rootContainer.getChildren()().forEach(function (child) {\n      ++count;\n\n      if (typeof child.getChildren !== \"undefined\" && child.getChildren()().length > 0) {\n        count = countContentTypes(child, count);\n      }\n    });\n    return count;\n  }\n  /**\n   * Perform a render of the provided data\n   *\n   * @param message\n   * @param renderId\n   */\n\n\n  function render(message, renderId) {\n    var styleRegistries = {};\n\n    _underscore.each(_config.getConfig(\"viewports\"), function (viewport, name) {\n      styleRegistries[name] = new _styleRegistry(name + renderId);\n    });\n\n    return new Promise(function (resolve, reject) {\n      createRenderTree(message.stageId, message.tree).then(function (rootContainer) {\n        var element = document.createElement(\"div\");\n        /**\n         * Setup an event on the element to observe changes and count the expected amount of content types are\n         * present within the content.\n         */\n\n        var renderFinished = _jquery.Deferred();\n\n        var observer = new MutationObserver(function () {\n          assertRenderFinished(element, countContentTypes(rootContainer), renderFinished.resolve);\n        });\n        observer.observe(element, {\n          attributes: true,\n          childList: true,\n          subtree: true\n        }); // Combine this event with our engine waitForRenderFinish to ensure rendering is completed\n\n        _jquery.when(_engine.waitForFinishRender(), renderFinished).then(function () {\n          observer.disconnect();\n\n          _knockout.cleanNode(element);\n\n          var styles = generateMasterCssForViewports(styleRegistries);\n\n          if (styles) {\n            (0, _jquery)(element).append((0, _jquery)(\"<style/>\").html(styles));\n          }\n\n          _underscore.each(styleRegistries, function (value, name) {\n            return (0, _styleRegistry.deleteStyleRegistry)(name + renderId);\n          });\n\n          var filtered = (0, _filterHtml)((0, _jquery)(element));\n          var output = (0, _directives.replaceWithSrc)((0, _directives)(filtered.html()));\n          resolve(output);\n        });\n\n        _knockout.applyBindingsToNode(element, {\n          template: {\n            data: rootContainer.content,\n            name: rootContainer.content.template\n          }\n        }, {\n          id: renderId\n        });\n      }).catch(function (error) {\n        reject(error);\n      });\n    });\n  }\n  /**\n   * Rebuild the content type tree using their original data and configuration\n   *\n   * @param stageId\n   * @param tree\n   * @param parent\n   */\n\n\n  function createRenderTree(stageId, tree, parent) {\n    if (parent === void 0) {\n      parent = null;\n    }\n\n    return new Promise(function (resolve, reject) {\n      (0, _contentTypeFactory)(_config.getContentTypeConfig(tree.name), parent, stageId, tree.data, parent !== null ? tree.children.length : 0, tree.viewportsData).then(function (contentType) {\n        // Ensure  we retain the original tree ID's\n        contentType.id = tree.id;\n\n        if (tree.children.length > 0) {\n          var childPromises = [];\n          tree.children.forEach(function (child) {\n            childPromises.push(createRenderTree(stageId, child, contentType));\n          });\n          Promise.all(childPromises).then(function (children) {\n            children.forEach(function (child) {\n              contentType.addChild(child);\n            });\n            resolve(contentType);\n          });\n        } else {\n          resolve(contentType);\n        }\n      }).catch(function (error) {\n        reject(error);\n      });\n    });\n  }\n  /**\n   * Generate the master format CSS\n   *\n   * @param registry\n   */\n\n\n  function generateMasterCss(registry) {\n    var scopes = Object.keys(registry.getAllStyles()).map(function (selector) {\n      return [selector];\n    });\n    return _csso.minify((0, _styleRegistry.generateCss)(registry.getAllStyles()), {\n      usage: {\n        scopes: scopes\n      }\n    }).css;\n  }\n\n  function generateMasterCssForViewports(registries) {\n    var result = \"\";\n\n    _underscore.each(registries, function (registry, name) {\n      var css = generateMasterCss(registry);\n\n      var media = _config.getConfig(\"viewports\")[name].media;\n\n      if (media && css) {\n        result += \"@media \" + media + \" { \" + css + \" }\";\n      } else {\n        result += css;\n      }\n    });\n\n    return result;\n  }\n\n  return Object.assign(listen, {\n    loadTemplate: loadTemplate\n  });\n});\n//# sourceMappingURL=frame.js.map","Magento_PageBuilder/js/master-format/render/requirejs/text.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"mage/requirejs/text\", \"Magento_PageBuilder/js/master-format/render/frame\"], function (_text, _frame) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Within our render frame we override the RequireJS text! plugin, this is originally implemented within\n   * lib/web/mage/requirejs/text.js. The override uses the MessageChannel to communicate with the parent frame to\n   * retrieve any requested HTML knockout template. We do this due to the sandbox restrictions on the iframe disallow\n   * XHR requests to the same origin domain.\n   */\n\n  /**\n   * Load a template\n   *\n   * @param name\n   * @param req\n   * @param onLoad\n   */\n  function load(name, req, onLoad) {\n    (0, _frame.loadTemplate)(name).then(function (template) {\n      onLoad(template);\n    }).catch(function (error) {\n      onLoad.error(error);\n    });\n  }\n  /**\n   * Retrieve a template\n   *\n   * @param url\n   * @param callback\n   * @param fail\n   * @param headers\n   */\n\n\n  function get(url, callback, fail, headers) {\n    _text.get.apply(_text, arguments);\n  }\n\n  return {\n    load: load,\n    get: get\n  };\n});\n//# sourceMappingURL=text.js.map","Magento_PageBuilder/js/resource/object-path.js":"(function (root, factory){\n    'use strict';\n\n    /*istanbul ignore next:cant test*/\n    if (typeof module === 'object' && typeof module.exports === 'object') {\n        module.exports = factory();\n    } else if (typeof define === 'function' && define.amd) {\n        // AMD. Register as an anonymous module.\n        define([], factory);\n    } else {\n        // Browser globals\n        root.objectPath = factory();\n    }\n})(this, function(){\n    'use strict';\n\n    var toStr = Object.prototype.toString;\n    function hasOwnProperty(obj, prop) {\n        if(obj == null) {\n            return false\n        }\n        //to handle objects with null prototypes (too edge case?)\n        return Object.prototype.hasOwnProperty.call(obj, prop)\n    }\n\n    function isEmpty(value){\n        if (!value) {\n            return true;\n        }\n        if (isArray(value) && value.length === 0) {\n            return true;\n        } else if (typeof value !== 'string') {\n            for (var i in value) {\n                if (hasOwnProperty(value, i)) {\n                    return false;\n                }\n            }\n            return true;\n        }\n        return false;\n    }\n\n    function toString(type){\n        return toStr.call(type);\n    }\n\n    function isObject(obj){\n        return typeof obj === 'object' && toString(obj) === \"[object Object]\";\n    }\n\n    var isArray = Array.isArray || function(obj){\n        /*istanbul ignore next:cant test*/\n        return toStr.call(obj) === '[object Array]';\n    }\n\n    function isBoolean(obj){\n        return typeof obj === 'boolean' || toString(obj) === '[object Boolean]';\n    }\n\n    function getKey(key){\n        var intKey = parseInt(key);\n        if (intKey.toString() === key) {\n            return intKey;\n        }\n        return key;\n    }\n\n    function factory(options) {\n        options = options || {}\n\n        var objectPath = function(obj) {\n            return Object.keys(objectPath).reduce(function(proxy, prop) {\n                if(prop === 'create') {\n                    return proxy;\n                }\n\n                /*istanbul ignore else*/\n                if (typeof objectPath[prop] === 'function') {\n                    proxy[prop] = objectPath[prop].bind(objectPath, obj);\n                }\n\n                return proxy;\n            }, {});\n        };\n\n        var hasShallowProperty\n        if (options.includeInheritedProps) {\n            hasShallowProperty = function () {\n                return true\n            }\n        } else {\n            hasShallowProperty = function (obj, prop) {\n                return (typeof prop === 'number' && Array.isArray(obj)) || hasOwnProperty(obj, prop)\n            }\n        }\n\n        function getShallowProperty(obj, prop) {\n            if (hasShallowProperty(obj, prop)) {\n                return obj[prop];\n            }\n        }\n\n        function set(obj, path, value, doNotReplace){\n            if (typeof path === 'number') {\n                path = [path];\n            }\n            if (!path || path.length === 0) {\n                return obj;\n            }\n            if (typeof path === 'string') {\n                return set(obj, path.split('.').map(getKey), value, doNotReplace);\n            }\n            var currentPath = path[0];\n            var currentValue = getShallowProperty(obj, currentPath);\n            if (options.includeInheritedProps && (currentPath === '__proto__' ||\n                (currentPath === 'constructor' && typeof currentValue === 'function'))) {\n                throw new Error('For security reasons, object\\'s magic properties cannot be set')\n            }\n            if (path.length === 1) {\n                if (currentValue === void 0 || !doNotReplace) {\n                    obj[currentPath] = value;\n                }\n                return currentValue;\n            }\n\n            if (currentValue === void 0) {\n                //check if we assume an array\n                if(typeof path[1] === 'number') {\n                    obj[currentPath] = [];\n                } else {\n                    obj[currentPath] = {};\n                }\n            }\n\n            return set(obj[currentPath], path.slice(1), value, doNotReplace);\n        }\n\n        objectPath.has = function (obj, path) {\n            if (typeof path === 'number') {\n                path = [path];\n            } else if (typeof path === 'string') {\n                path = path.split('.');\n            }\n\n            if (!path || path.length === 0) {\n                return !!obj;\n            }\n\n            for (var i = 0; i < path.length; i++) {\n                var j = getKey(path[i]);\n\n                if((typeof j === 'number' && isArray(obj) && j < obj.length) ||\n                    (options.includeInheritedProps ? (j in Object(obj)) : hasOwnProperty(obj, j))) {\n                    obj = obj[j];\n                } else {\n                    return false;\n                }\n            }\n\n            return true;\n        };\n\n        objectPath.ensureExists = function (obj, path, value){\n            return set(obj, path, value, true);\n        };\n\n        objectPath.set = function (obj, path, value, doNotReplace){\n            return set(obj, path, value, doNotReplace);\n        };\n\n        objectPath.insert = function (obj, path, value, at){\n            var arr = objectPath.get(obj, path);\n            at = ~~at;\n            if (!isArray(arr)) {\n                arr = [];\n                objectPath.set(obj, path, arr);\n            }\n            arr.splice(at, 0, value);\n        };\n\n        objectPath.empty = function(obj, path) {\n            if (isEmpty(path)) {\n                return void 0;\n            }\n            if (obj == null) {\n                return void 0;\n            }\n\n            var value, i;\n            if (!(value = objectPath.get(obj, path))) {\n                return void 0;\n            }\n\n            if (typeof value === 'string') {\n                return objectPath.set(obj, path, '');\n            } else if (isBoolean(value)) {\n                return objectPath.set(obj, path, false);\n            } else if (typeof value === 'number') {\n                return objectPath.set(obj, path, 0);\n            } else if (isArray(value)) {\n                value.length = 0;\n            } else if (isObject(value)) {\n                for (i in value) {\n                    if (hasShallowProperty(value, i)) {\n                        delete value[i];\n                    }\n                }\n            } else {\n                return objectPath.set(obj, path, null);\n            }\n        };\n\n        objectPath.push = function (obj, path /*, values */){\n            var arr = objectPath.get(obj, path);\n            if (!isArray(arr)) {\n                arr = [];\n                objectPath.set(obj, path, arr);\n            }\n\n            arr.push.apply(arr, Array.prototype.slice.call(arguments, 2));\n        };\n\n        objectPath.coalesce = function (obj, paths, defaultValue) {\n            var value;\n\n            for (var i = 0, len = paths.length; i < len; i++) {\n                if ((value = objectPath.get(obj, paths[i])) !== void 0) {\n                    return value;\n                }\n            }\n\n            return defaultValue;\n        };\n\n        objectPath.get = function (obj, path, defaultValue){\n            if (typeof path === 'number') {\n                path = [path];\n            }\n            if (!path || path.length === 0) {\n                return obj;\n            }\n            if (obj == null) {\n                return defaultValue;\n            }\n            if (typeof path === 'string') {\n                return objectPath.get(obj, path.split('.'), defaultValue);\n            }\n\n            var currentPath = getKey(path[0]);\n            var nextObj = getShallowProperty(obj, currentPath)\n            if (nextObj === void 0) {\n                return defaultValue;\n            }\n\n            if (path.length === 1) {\n                return nextObj;\n            }\n\n            return objectPath.get(obj[currentPath], path.slice(1), defaultValue);\n        };\n\n        objectPath.del = function del(obj, path) {\n            if (typeof path === 'number') {\n                path = [path];\n            }\n\n            if (obj == null) {\n                return obj;\n            }\n\n            if (isEmpty(path)) {\n                return obj;\n            }\n            if(typeof path === 'string') {\n                return objectPath.del(obj, path.split('.'));\n            }\n\n            var currentPath = getKey(path[0]);\n            if (!hasShallowProperty(obj, currentPath)) {\n                return obj;\n            }\n\n            if(path.length === 1) {\n                if (isArray(obj)) {\n                    obj.splice(currentPath, 1);\n                } else {\n                    delete obj[currentPath];\n                }\n            } else {\n                return objectPath.del(obj[currentPath], path.slice(1));\n            }\n\n            return obj;\n        }\n\n        return objectPath;\n    }\n\n    var mod = factory();\n    mod.create = factory;\n    mod.withInheritedProps = factory({includeInheritedProps: true})\n    return mod;\n});","Magento_PageBuilder/js/resource/slick/slick.min.js":"/*\n     _ _      _       _\n ___| (_) ___| | __  (_)___\n/ __| | |/ __| |/ /  | / __|\n\\__ \\ | | (__|   < _ | \\__ \\\n|___/_|_|\\___|_|\\_(_)/ |___/\n                   |__/\n\n Version: 1.8.1\n  Author: Ken Wheeler\n Website: http://kenwheeler.github.io\n    Docs: http://kenwheeler.github.io/slick\n    Repo: http://github.com/kenwheeler/slick\n  Issues: http://github.com/kenwheeler/slick/issues\n\n */\n!function(i){\"use strict\";\"function\"==typeof define&&define.amd?define([\"jquery\"],i):\"undefined\"!=typeof exports?module.exports=i(require(\"jquery\")):i(jQuery)}(function(i){\"use strict\";var e=window.Slick||{};(e=function(){var e=0;return function(t,o){var s,n=this;n.defaults={accessibility:!0,adaptiveHeight:!1,appendArrows:i(t),appendDots:i(t),arrows:!0,asNavFor:null,prevArrow:'<button class=\"slick-prev\" aria-label=\"Previous\" type=\"button\">Previous</button>',nextArrow:'<button class=\"slick-next\" aria-label=\"Next\" type=\"button\">Next</button>',autoplay:!1,autoplaySpeed:3e3,centerMode:!1,centerPadding:\"50px\",cssEase:\"ease\",customPaging:function(e,t){return i('<button type=\"button\" />').text(t+1)},dots:!1,dotsClass:\"slick-dots\",draggable:!0,easing:\"linear\",edgeFriction:.35,fade:!1,focusOnSelect:!1,focusOnChange:!1,infinite:!0,initialSlide:0,lazyLoad:\"ondemand\",mobileFirst:!1,pauseOnHover:!0,pauseOnFocus:!0,pauseOnDotsHover:!1,respondTo:\"window\",responsive:null,rows:1,rtl:!1,slide:\"\",slidesPerRow:1,slidesToShow:1,slidesToScroll:1,speed:500,swipe:!0,swipeToSlide:!1,touchMove:!0,touchThreshold:5,useCSS:!0,useTransform:!0,variableWidth:!1,vertical:!1,verticalSwiping:!1,waitForAnimate:!0,zIndex:1e3},n.initials={animating:!1,dragging:!1,autoPlayTimer:null,currentDirection:0,currentLeft:null,currentSlide:0,direction:1,$dots:null,listWidth:null,listHeight:null,loadIndex:0,$nextArrow:null,$prevArrow:null,scrolling:!1,slideCount:null,slideWidth:null,$slideTrack:null,$slides:null,sliding:!1,slideOffset:0,swipeLeft:null,swiping:!1,$list:null,touchObject:{},transformsEnabled:!1,unslicked:!1},i.extend(n,n.initials),n.activeBreakpoint=null,n.animType=null,n.animProp=null,n.breakpoints=[],n.breakpointSettings=[],n.cssTransitions=!1,n.focussed=!1,n.interrupted=!1,n.hidden=\"hidden\",n.paused=!0,n.positionProp=null,n.respondTo=null,n.rowCount=1,n.shouldClick=!0,n.$slider=i(t),n.$slidesCache=null,n.transformType=null,n.transitionType=null,n.visibilityChange=\"visibilitychange\",n.windowWidth=0,n.windowTimer=null,s=i(t).data(\"slick\")||{},n.options=i.extend({},n.defaults,o,s),n.currentSlide=n.options.initialSlide,n.originalSettings=n.options,void 0!==document.mozHidden?(n.hidden=\"mozHidden\",n.visibilityChange=\"mozvisibilitychange\"):void 0!==document.webkitHidden&&(n.hidden=\"webkitHidden\",n.visibilityChange=\"webkitvisibilitychange\"),n.autoPlay=i.proxy(n.autoPlay,n),n.autoPlayClear=i.proxy(n.autoPlayClear,n),n.autoPlayIterator=i.proxy(n.autoPlayIterator,n),n.changeSlide=i.proxy(n.changeSlide,n),n.clickHandler=i.proxy(n.clickHandler,n),n.selectHandler=i.proxy(n.selectHandler,n),n.setPosition=i.proxy(n.setPosition,n),n.swipeHandler=i.proxy(n.swipeHandler,n),n.dragHandler=i.proxy(n.dragHandler,n),n.keyHandler=i.proxy(n.keyHandler,n),n.instanceUid=e++,n.htmlExpr=/^(?:\\s*(<[\\w\\W]+>)[^>]*)$/,n.registerBreakpoints(),n.init(!0)}}()).prototype.activateADA=function(){this.$slideTrack.find(\".slick-active\").attr({\"aria-hidden\":\"false\"}).find(\"a, input, button, select\").attr({tabindex:\"0\"})},e.prototype.addSlide=e.prototype.slickAdd=function(e,t,o){var s=this;if(\"boolean\"==typeof t)o=t,t=null;else if(t<0||t>=s.slideCount)return!1;s.unload(),\"number\"==typeof t?0===t&&0===s.$slides.length?i(e).appendTo(s.$slideTrack):o?i(e).insertBefore(s.$slides.eq(t)):i(e).insertAfter(s.$slides.eq(t)):!0===o?i(e).prependTo(s.$slideTrack):i(e).appendTo(s.$slideTrack),s.$slides=s.$slideTrack.children(this.options.slide),s.$slideTrack.children(this.options.slide).detach(),s.$slideTrack.append(s.$slides),s.$slides.each(function(e,t){i(t).attr(\"data-slick-index\",e)}),s.$slidesCache=s.$slides,s.reinit()},e.prototype.animateHeight=function(){var i=this;if(1===i.options.slidesToShow&&!0===i.options.adaptiveHeight&&!1===i.options.vertical){var e=i.$slides.eq(i.currentSlide).outerHeight(!0);i.$list.animate({height:e},i.options.speed)}},e.prototype.animateSlide=function(e,t){var o={},s=this;s.animateHeight(),!0===s.options.rtl&&!1===s.options.vertical&&(e=-e),!1===s.transformsEnabled?!1===s.options.vertical?s.$slideTrack.animate({left:e},s.options.speed,s.options.easing,t):s.$slideTrack.animate({top:e},s.options.speed,s.options.easing,t):!1===s.cssTransitions?(!0===s.options.rtl&&(s.currentLeft=-s.currentLeft),i({animStart:s.currentLeft}).animate({animStart:e},{duration:s.options.speed,easing:s.options.easing,step:function(i){i=Math.ceil(i),!1===s.options.vertical?(o[s.animType]=\"translate(\"+i+\"px, 0px)\",s.$slideTrack.css(o)):(o[s.animType]=\"translate(0px,\"+i+\"px)\",s.$slideTrack.css(o))},complete:function(){t&&t.call()}})):(s.applyTransition(),e=Math.ceil(e),!1===s.options.vertical?o[s.animType]=\"translate3d(\"+e+\"px, 0px, 0px)\":o[s.animType]=\"translate3d(0px,\"+e+\"px, 0px)\",s.$slideTrack.css(o),t&&setTimeout(function(){s.disableTransition(),t.call()},s.options.speed))},e.prototype.getNavTarget=function(){var e=this.options.asNavFor;return e&&null!==e&&(e=i(e).not(this.$slider)),e},e.prototype.asNavFor=function(e){var t=this.getNavTarget();null!==t&&\"object\"==typeof t&&t.each(function(){var t=i(this).slick(\"getSlick\");t.unslicked||t.slideHandler(e,!0)})},e.prototype.applyTransition=function(i){var e=this,t={};!1===e.options.fade?t[e.transitionType]=e.transformType+\" \"+e.options.speed+\"ms \"+e.options.cssEase:t[e.transitionType]=\"opacity \"+e.options.speed+\"ms \"+e.options.cssEase,!1===e.options.fade?e.$slideTrack.css(t):e.$slides.eq(i).css(t)},e.prototype.autoPlay=function(){var i=this;i.autoPlayClear(),i.slideCount>i.options.slidesToShow&&(i.autoPlayTimer=setInterval(i.autoPlayIterator,i.options.autoplaySpeed))},e.prototype.autoPlayClear=function(){this.autoPlayTimer&&clearInterval(this.autoPlayTimer)},e.prototype.autoPlayIterator=function(){var i=this,e=i.currentSlide+i.options.slidesToScroll;i.paused||i.interrupted||i.focussed||(!1===i.options.infinite&&(1===i.direction&&i.currentSlide+1===i.slideCount-1?i.direction=0:0===i.direction&&(e=i.currentSlide-i.options.slidesToScroll,i.currentSlide-1==0&&(i.direction=1))),i.slideHandler(e))},e.prototype.buildArrows=function(){var e=this;!0===e.options.arrows&&(e.$prevArrow=i(e.options.prevArrow).addClass(\"slick-arrow\"),e.$nextArrow=i(e.options.nextArrow).addClass(\"slick-arrow\"),e.slideCount>e.options.slidesToShow?(e.$prevArrow.removeClass(\"slick-hidden\").removeAttr(\"aria-hidden tabindex\"),e.$nextArrow.removeClass(\"slick-hidden\").removeAttr(\"aria-hidden tabindex\"),e.htmlExpr.test(e.options.prevArrow)&&e.$prevArrow.prependTo(e.options.appendArrows),e.htmlExpr.test(e.options.nextArrow)&&e.$nextArrow.appendTo(e.options.appendArrows),!0!==e.options.infinite&&e.$prevArrow.addClass(\"slick-disabled\").attr(\"aria-disabled\",\"true\")):e.$prevArrow.add(e.$nextArrow).addClass(\"slick-hidden\").attr({\"aria-disabled\":\"true\",tabindex:\"-1\"}))},e.prototype.buildDots=function(){var e,t,o=this;if(!0===o.options.dots&&o.slideCount>o.options.slidesToShow){for(o.$slider.addClass(\"slick-dotted\"),t=i(\"<ul />\").addClass(o.options.dotsClass),e=0;e<=o.getDotCount();e+=1)t.append(i(\"<li />\").append(o.options.customPaging.call(this,o,e)));o.$dots=t.appendTo(o.options.appendDots),o.$dots.find(\"li\").first().addClass(\"slick-active\")}},e.prototype.buildOut=function(){var e=this;e.$slides=e.$slider.children(e.options.slide+\":not(.slick-cloned)\").addClass(\"slick-slide\"),e.slideCount=e.$slides.length,e.$slides.each(function(e,t){i(t).attr(\"data-slick-index\",e).data(\"originalStyling\",i(t).attr(\"style\")||\"\")}),e.$slider.addClass(\"slick-slider\"),e.$slideTrack=0===e.slideCount?i('<div class=\"slick-track\"/>').appendTo(e.$slider):e.$slides.wrapAll('<div class=\"slick-track\"/>').parent(),e.$list=e.$slideTrack.wrap('<div class=\"slick-list\"/>').parent(),e.$slideTrack.css(\"opacity\",0),!0!==e.options.centerMode&&!0!==e.options.swipeToSlide||(e.options.slidesToScroll=1),i(\"img[data-lazy]\",e.$slider).not(\"[src]\").addClass(\"slick-loading\"),e.setupInfinite(),e.buildArrows(),e.buildDots(),e.updateDots(),e.setSlideClasses(\"number\"==typeof e.currentSlide?e.currentSlide:0),!0===e.options.draggable&&e.$list.addClass(\"draggable\")},e.prototype.buildRows=function(){var i,e,t,o,s,n,r,l=this;if(o=document.createDocumentFragment(),n=l.$slider.children(),l.options.rows>0){for(r=l.options.slidesPerRow*l.options.rows,s=Math.ceil(n.length/r),i=0;i<s;i++){var d=document.createElement(\"div\");for(e=0;e<l.options.rows;e++){var a=document.createElement(\"div\");for(t=0;t<l.options.slidesPerRow;t++){var c=i*r+(e*l.options.slidesPerRow+t);n.get(c)&&a.appendChild(n.get(c))}d.appendChild(a)}o.appendChild(d)}l.$slider.empty().append(o),l.$slider.children().children().children().css({width:100/l.options.slidesPerRow+\"%\",display:\"inline-block\"})}},e.prototype.checkResponsive=function(e,t){var o,s,n,r=this,l=!1,d=r.$slider.width(),a=window.innerWidth||i(window).width();if(\"window\"===r.respondTo?n=a:\"slider\"===r.respondTo?n=d:\"min\"===r.respondTo&&(n=Math.min(a,d)),r.options.responsive&&r.options.responsive.length&&null!==r.options.responsive){s=null;for(o in r.breakpoints)r.breakpoints.hasOwnProperty(o)&&(!1===r.originalSettings.mobileFirst?n<r.breakpoints[o]&&(s=r.breakpoints[o]):n>r.breakpoints[o]&&(s=r.breakpoints[o]));null!==s?null!==r.activeBreakpoint?(s!==r.activeBreakpoint||t)&&(r.activeBreakpoint=s,\"unslick\"===r.breakpointSettings[s]?r.unslick(s):(r.options=i.extend({},r.originalSettings,r.breakpointSettings[s]),!0===e&&(r.currentSlide=r.options.initialSlide),r.refresh(e)),l=s):(r.activeBreakpoint=s,\"unslick\"===r.breakpointSettings[s]?r.unslick(s):(r.options=i.extend({},r.originalSettings,r.breakpointSettings[s]),!0===e&&(r.currentSlide=r.options.initialSlide),r.refresh(e)),l=s):null!==r.activeBreakpoint&&(r.activeBreakpoint=null,r.options=r.originalSettings,!0===e&&(r.currentSlide=r.options.initialSlide),r.refresh(e),l=s),e||!1===l||r.$slider.trigger(\"breakpoint\",[r,l])}},e.prototype.changeSlide=function(e,t){var o,s,n=this,r=i(e.currentTarget);switch(r.is(\"a\")&&e.preventDefault(),r.is(\"li\")||(r=r.closest(\"li\")),o=n.slideCount%n.options.slidesToScroll!=0?0:(n.slideCount-n.currentSlide)%n.options.slidesToScroll,e.data.message){case\"previous\":s=0===o?n.options.slidesToScroll:n.options.slidesToShow-o,n.slideCount>n.options.slidesToShow&&n.slideHandler(n.currentSlide-s,!1,t);break;case\"next\":s=0===o?n.options.slidesToScroll:o,n.slideCount>n.options.slidesToShow&&n.slideHandler(n.currentSlide+s,!1,t);break;case\"index\":var l=0===e.data.index?0:e.data.index||r.index()*n.options.slidesToScroll;n.slideHandler(n.checkNavigable(l),!1,t),r.children().trigger(\"focus\");break;default:return}},e.prototype.checkNavigable=function(i){var e,t;if(t=0,i>(e=this.getNavigableIndexes())[e.length-1])i=e[e.length-1];else for(var o in e){if(i<e[o]){i=t;break}t=e[o]}return i},e.prototype.cleanUpEvents=function(){var e=this;e.options.dots&&null!==e.$dots&&(i(\"li\",e.$dots).off(\"click.slick\",e.changeSlide).off(\"mouseenter.slick\",i.proxy(e.interrupt,e,!0)).off(\"mouseleave.slick\",i.proxy(e.interrupt,e,!1)),!0===e.options.accessibility&&e.$dots.off(\"keydown.slick\",e.keyHandler)),e.$slider.off(\"focus.slick blur.slick\"),!0===e.options.arrows&&e.slideCount>e.options.slidesToShow&&(e.$prevArrow&&e.$prevArrow.off(\"click.slick\",e.changeSlide),e.$nextArrow&&e.$nextArrow.off(\"click.slick\",e.changeSlide),!0===e.options.accessibility&&(e.$prevArrow&&e.$prevArrow.off(\"keydown.slick\",e.keyHandler),e.$nextArrow&&e.$nextArrow.off(\"keydown.slick\",e.keyHandler))),e.$list.off(\"touchstart.slick mousedown.slick\",e.swipeHandler),e.$list.off(\"touchmove.slick mousemove.slick\",e.swipeHandler),e.$list.off(\"touchend.slick mouseup.slick\",e.swipeHandler),e.$list.off(\"touchcancel.slick mouseleave.slick\",e.swipeHandler),e.$list.off(\"click.slick\",e.clickHandler),i(document).off(e.visibilityChange,e.visibility),e.cleanUpSlideEvents(),!0===e.options.accessibility&&e.$list.off(\"keydown.slick\",e.keyHandler),!0===e.options.focusOnSelect&&i(e.$slideTrack).children().off(\"click.slick\",e.selectHandler),i(window).off(\"orientationchange.slick.slick-\"+e.instanceUid,e.orientationChange),i(window).off(\"resize.slick.slick-\"+e.instanceUid,e.resize),i(\"[draggable!=true]\",e.$slideTrack).off(\"dragstart\",e.preventDefault),i(window).off(\"load.slick.slick-\"+e.instanceUid,e.setPosition)},e.prototype.cleanUpSlideEvents=function(){var e=this;e.$list.off(\"mouseenter.slick\",i.proxy(e.interrupt,e,!0)),e.$list.off(\"mouseleave.slick\",i.proxy(e.interrupt,e,!1))},e.prototype.cleanUpRows=function(){var i;this.options.rows>0&&((i=this.$slides.children().children()).removeAttr(\"style\"),this.$slider.empty().append(i))},e.prototype.clickHandler=function(i){!1===this.shouldClick&&(i.stopImmediatePropagation(),i.stopPropagation(),i.preventDefault())},e.prototype.destroy=function(e){var t=this;t.autoPlayClear(),t.touchObject={},t.cleanUpEvents(),i(\".slick-cloned\",t.$slider).detach(),t.$dots&&t.$dots.remove(),t.$prevArrow&&t.$prevArrow.length&&(t.$prevArrow.removeClass(\"slick-disabled slick-arrow slick-hidden\").removeAttr(\"aria-hidden aria-disabled tabindex\").css(\"display\",\"\"),t.htmlExpr.test(t.options.prevArrow)&&t.$prevArrow.remove()),t.$nextArrow&&t.$nextArrow.length&&(t.$nextArrow.removeClass(\"slick-disabled slick-arrow slick-hidden\").removeAttr(\"aria-hidden aria-disabled tabindex\").css(\"display\",\"\"),t.htmlExpr.test(t.options.nextArrow)&&t.$nextArrow.remove()),t.$slides&&(t.$slides.removeClass(\"slick-slide slick-active slick-center slick-visible slick-current\").removeAttr(\"aria-hidden\").removeAttr(\"data-slick-index\").each(function(){i(this).attr(\"style\",i(this).data(\"originalStyling\"))}),t.$slideTrack.children(this.options.slide).detach(),t.$slideTrack.detach(),t.$list.detach(),t.$slider.append(t.$slides)),t.cleanUpRows(),t.$slider.removeClass(\"slick-slider\"),t.$slider.removeClass(\"slick-initialized\"),t.$slider.removeClass(\"slick-dotted\"),t.unslicked=!0,e||t.$slider.trigger(\"destroy\",[t])},e.prototype.disableTransition=function(i){var e={};e[this.transitionType]=\"\",!1===this.options.fade?this.$slideTrack.css(e):this.$slides.eq(i).css(e)},e.prototype.fadeSlide=function(i,e){var t=this;!1===t.cssTransitions?(t.$slides.eq(i).css({zIndex:t.options.zIndex}),t.$slides.eq(i).animate({opacity:1},t.options.speed,t.options.easing,e)):(t.applyTransition(i),t.$slides.eq(i).css({opacity:1,zIndex:t.options.zIndex}),e&&setTimeout(function(){t.disableTransition(i),e.call()},t.options.speed))},e.prototype.fadeSlideOut=function(i){var e=this;!1===e.cssTransitions?e.$slides.eq(i).animate({opacity:0,zIndex:e.options.zIndex-2},e.options.speed,e.options.easing):(e.applyTransition(i),e.$slides.eq(i).css({opacity:0,zIndex:e.options.zIndex-2}))},e.prototype.filterSlides=e.prototype.slickFilter=function(i){var e=this;null!==i&&(e.$slidesCache=e.$slides,e.unload(),e.$slideTrack.children(this.options.slide).detach(),e.$slidesCache.filter(i).appendTo(e.$slideTrack),e.reinit())},e.prototype.focusHandler=function(){var e=this;e.$slider.off(\"focus.slick blur.slick\").on(\"focus.slick\",\"*\",function(t){var o=i(this);setTimeout(function(){e.options.pauseOnFocus&&o.is(\":focus\")&&(e.focussed=!0,e.autoPlay())},0)}).on(\"blur.slick\",\"*\",function(t){i(this);e.options.pauseOnFocus&&(e.focussed=!1,e.autoPlay())})},e.prototype.getCurrent=e.prototype.slickCurrentSlide=function(){return this.currentSlide},e.prototype.getDotCount=function(){var i=this,e=0,t=0,o=0;if(!0===i.options.infinite)if(i.slideCount<=i.options.slidesToShow)++o;else for(;e<i.slideCount;)++o,e=t+i.options.slidesToScroll,t+=i.options.slidesToScroll<=i.options.slidesToShow?i.options.slidesToScroll:i.options.slidesToShow;else if(!0===i.options.centerMode)o=i.slideCount;else if(i.options.asNavFor)for(;e<i.slideCount;)++o,e=t+i.options.slidesToScroll,t+=i.options.slidesToScroll<=i.options.slidesToShow?i.options.slidesToScroll:i.options.slidesToShow;else o=1+Math.ceil((i.slideCount-i.options.slidesToShow)/i.options.slidesToScroll);return o-1},e.prototype.getLeft=function(i){var e,t,o,s,n=this,r=0;return n.slideOffset=0,t=n.$slides.first().outerHeight(!0),!0===n.options.infinite?(n.slideCount>n.options.slidesToShow&&(n.slideOffset=n.slideWidth*n.options.slidesToShow*-1,s=-1,!0===n.options.vertical&&!0===n.options.centerMode&&(2===n.options.slidesToShow?s=-1.5:1===n.options.slidesToShow&&(s=-2)),r=t*n.options.slidesToShow*s),n.slideCount%n.options.slidesToScroll!=0&&i+n.options.slidesToScroll>n.slideCount&&n.slideCount>n.options.slidesToShow&&(i>n.slideCount?(n.slideOffset=(n.options.slidesToShow-(i-n.slideCount))*n.slideWidth*-1,r=(n.options.slidesToShow-(i-n.slideCount))*t*-1):(n.slideOffset=n.slideCount%n.options.slidesToScroll*n.slideWidth*-1,r=n.slideCount%n.options.slidesToScroll*t*-1))):i+n.options.slidesToShow>n.slideCount&&(n.slideOffset=(i+n.options.slidesToShow-n.slideCount)*n.slideWidth,r=(i+n.options.slidesToShow-n.slideCount)*t),n.slideCount<=n.options.slidesToShow&&(n.slideOffset=0,r=0),!0===n.options.centerMode&&n.slideCount<=n.options.slidesToShow?n.slideOffset=n.slideWidth*Math.floor(n.options.slidesToShow)/2-n.slideWidth*n.slideCount/2:!0===n.options.centerMode&&!0===n.options.infinite?n.slideOffset+=n.slideWidth*Math.floor(n.options.slidesToShow/2)-n.slideWidth:!0===n.options.centerMode&&(n.slideOffset=0,n.slideOffset+=n.slideWidth*Math.floor(n.options.slidesToShow/2)),e=!1===n.options.vertical?i*n.slideWidth*-1+n.slideOffset:i*t*-1+r,!0===n.options.variableWidth&&(o=n.slideCount<=n.options.slidesToShow||!1===n.options.infinite?n.$slideTrack.children(\".slick-slide\").eq(i):n.$slideTrack.children(\".slick-slide\").eq(i+n.options.slidesToShow),e=!0===n.options.rtl?o[0]?-1*(n.$slideTrack.width()-o[0].offsetLeft-o.width()):0:o[0]?-1*o[0].offsetLeft:0,!0===n.options.centerMode&&(o=n.slideCount<=n.options.slidesToShow||!1===n.options.infinite?n.$slideTrack.children(\".slick-slide\").eq(i):n.$slideTrack.children(\".slick-slide\").eq(i+n.options.slidesToShow+1),e=!0===n.options.rtl?o[0]?-1*(n.$slideTrack.width()-o[0].offsetLeft-o.width()):0:o[0]?-1*o[0].offsetLeft:0,e+=(n.$list.width()-o.outerWidth())/2)),e},e.prototype.getOption=e.prototype.slickGetOption=function(i){return this.options[i]},e.prototype.getNavigableIndexes=function(){var i,e=this,t=0,o=0,s=[];for(!1===e.options.infinite?i=e.slideCount:(t=-1*e.options.slidesToScroll,o=-1*e.options.slidesToScroll,i=2*e.slideCount);t<i;)s.push(t),t=o+e.options.slidesToScroll,o+=e.options.slidesToScroll<=e.options.slidesToShow?e.options.slidesToScroll:e.options.slidesToShow;return s},e.prototype.getSlick=function(){return this},e.prototype.getSlideCount=function(){var e,t,o=this;return t=!0===o.options.centerMode?o.slideWidth*Math.floor(o.options.slidesToShow/2):0,!0===o.options.swipeToSlide?(o.$slideTrack.find(\".slick-slide\").each(function(s,n){if(n.offsetLeft-t+i(n).outerWidth()/2>-1*o.swipeLeft)return e=n,!1}),Math.abs(i(e).attr(\"data-slick-index\")-o.currentSlide)||1):o.options.slidesToScroll},e.prototype.goTo=e.prototype.slickGoTo=function(i,e){this.changeSlide({data:{message:\"index\",index:parseInt(i)}},e)},e.prototype.init=function(e){var t=this;i(t.$slider).hasClass(\"slick-initialized\")||(i(t.$slider).addClass(\"slick-initialized\"),t.buildRows(),t.buildOut(),t.setProps(),t.startLoad(),t.loadSlider(),t.initializeEvents(),t.updateArrows(),t.updateDots(),t.checkResponsive(!0),t.focusHandler()),e&&t.$slider.trigger(\"init\",[t]),!0===t.options.accessibility&&t.initADA(),t.options.autoplay&&(t.paused=!1,t.autoPlay())},e.prototype.initADA=function(){var e=this,t=Math.ceil(e.slideCount/e.options.slidesToShow),o=e.getNavigableIndexes().filter(function(i){return i>=0&&i<e.slideCount});e.$slides.add(e.$slideTrack.find(\".slick-cloned\")).attr({\"aria-hidden\":\"true\",tabindex:\"-1\"}).find(\"a, input, button, select\").attr({tabindex:\"-1\"}),null!==e.$dots&&(e.$slides.not(e.$slideTrack.find(\".slick-cloned\")).each(function(t){var s=o.indexOf(t);if(i(this).attr({role:\"tabpanel\",id:\"slick-slide\"+e.instanceUid+t,tabindex:-1}),-1!==s){var n=\"slick-slide-control\"+e.instanceUid+s;i(\"#\"+n).length&&i(this).attr({\"aria-describedby\":n})}}),e.$dots.attr(\"role\",\"tablist\").find(\"li\").each(function(s){var n=o[s];i(this).attr({role:\"presentation\"}),i(this).find(\"button\").first().attr({role:\"tab\",id:\"slick-slide-control\"+e.instanceUid+s,\"aria-controls\":\"slick-slide\"+e.instanceUid+n,\"aria-label\":s+1+\" of \"+t,\"aria-selected\":null,tabindex:\"-1\"})}).eq(e.currentSlide).find(\"button\").attr({\"aria-selected\":\"true\",tabindex:\"0\"}).end());for(var s=e.currentSlide,n=s+e.options.slidesToShow;s<n;s++)e.options.focusOnChange?e.$slides.eq(s).attr({tabindex:\"0\"}):e.$slides.eq(s).removeAttr(\"tabindex\");e.activateADA()},e.prototype.initArrowEvents=function(){var i=this;!0===i.options.arrows&&i.slideCount>i.options.slidesToShow&&(i.$prevArrow.off(\"click.slick\").on(\"click.slick\",{message:\"previous\"},i.changeSlide),i.$nextArrow.off(\"click.slick\").on(\"click.slick\",{message:\"next\"},i.changeSlide),!0===i.options.accessibility&&(i.$prevArrow.on(\"keydown.slick\",i.keyHandler),i.$nextArrow.on(\"keydown.slick\",i.keyHandler)))},e.prototype.initDotEvents=function(){var e=this;!0===e.options.dots&&e.slideCount>e.options.slidesToShow&&(i(\"li\",e.$dots).on(\"click.slick\",{message:\"index\"},e.changeSlide),!0===e.options.accessibility&&e.$dots.on(\"keydown.slick\",e.keyHandler)),!0===e.options.dots&&!0===e.options.pauseOnDotsHover&&e.slideCount>e.options.slidesToShow&&i(\"li\",e.$dots).on(\"mouseenter.slick\",i.proxy(e.interrupt,e,!0)).on(\"mouseleave.slick\",i.proxy(e.interrupt,e,!1))},e.prototype.initSlideEvents=function(){var e=this;e.options.pauseOnHover&&(e.$list.on(\"mouseenter.slick\",i.proxy(e.interrupt,e,!0)),e.$list.on(\"mouseleave.slick\",i.proxy(e.interrupt,e,!1)))},e.prototype.initializeEvents=function(){var e=this;e.initArrowEvents(),e.initDotEvents(),e.initSlideEvents(),e.$list.on(\"touchstart.slick mousedown.slick\",{action:\"start\"},e.swipeHandler),e.$list.on(\"touchmove.slick mousemove.slick\",{action:\"move\"},e.swipeHandler),e.$list.on(\"touchend.slick mouseup.slick\",{action:\"end\"},e.swipeHandler),e.$list.on(\"touchcancel.slick mouseleave.slick\",{action:\"end\"},e.swipeHandler),e.$list.on(\"click.slick\",e.clickHandler),i(document).on(e.visibilityChange,i.proxy(e.visibility,e)),!0===e.options.accessibility&&e.$list.on(\"keydown.slick\",e.keyHandler),!0===e.options.focusOnSelect&&i(e.$slideTrack).children().on(\"click.slick\",e.selectHandler),i(window).on(\"orientationchange.slick.slick-\"+e.instanceUid,i.proxy(e.orientationChange,e)),i(window).on(\"resize.slick.slick-\"+e.instanceUid,i.proxy(e.resize,e)),i(\"[draggable!=true]\",e.$slideTrack).on(\"dragstart\",e.preventDefault),i(window).on(\"load.slick.slick-\"+e.instanceUid,e.setPosition),i(e.setPosition)},e.prototype.initUI=function(){var i=this;!0===i.options.arrows&&i.slideCount>i.options.slidesToShow&&(i.$prevArrow.show(),i.$nextArrow.show()),!0===i.options.dots&&i.slideCount>i.options.slidesToShow&&i.$dots.show()},e.prototype.keyHandler=function(i){var e=this;i.target.tagName.match(\"TEXTAREA|INPUT|SELECT\")||(37===i.keyCode&&!0===e.options.accessibility?e.changeSlide({data:{message:!0===e.options.rtl?\"next\":\"previous\"}}):39===i.keyCode&&!0===e.options.accessibility&&e.changeSlide({data:{message:!0===e.options.rtl?\"previous\":\"next\"}}))},e.prototype.lazyLoad=function(){var e,t,o,s=this;function n(e){i(\"img[data-lazy]\",e).each(function(){var e=i(this),t=i(this).attr(\"data-lazy\"),o=i(this).attr(\"data-srcset\"),n=i(this).attr(\"data-sizes\")||s.$slider.attr(\"data-sizes\"),r=document.createElement(\"img\");r.onload=function(){e.animate({opacity:0},100,function(){o&&(e.attr(\"srcset\",o),n&&e.attr(\"sizes\",n)),e.attr(\"src\",t).animate({opacity:1},200,function(){e.removeAttr(\"data-lazy data-srcset data-sizes\").removeClass(\"slick-loading\")}),s.$slider.trigger(\"lazyLoaded\",[s,e,t])})},r.onerror=function(){e.removeAttr(\"data-lazy\").removeClass(\"slick-loading\").addClass(\"slick-lazyload-error\"),s.$slider.trigger(\"lazyLoadError\",[s,e,t])},r.src=t})}if(!0===s.options.centerMode?!0===s.options.infinite?o=(t=s.currentSlide+(s.options.slidesToShow/2+1))+s.options.slidesToShow+2:(t=Math.max(0,s.currentSlide-(s.options.slidesToShow/2+1)),o=s.options.slidesToShow/2+1+2+s.currentSlide):(t=s.options.infinite?s.options.slidesToShow+s.currentSlide:s.currentSlide,o=Math.ceil(t+s.options.slidesToShow),!0===s.options.fade&&(t>0&&t--,o<=s.slideCount&&o++)),e=s.$slider.find(\".slick-slide\").slice(t,o),\"anticipated\"===s.options.lazyLoad)for(var r=t-1,l=o,d=s.$slider.find(\".slick-slide\"),a=0;a<s.options.slidesToScroll;a++)r<0&&(r=s.slideCount-1),e=(e=e.add(d.eq(r))).add(d.eq(l)),r--,l++;n(e),s.slideCount<=s.options.slidesToShow?n(s.$slider.find(\".slick-slide\")):s.currentSlide>=s.slideCount-s.options.slidesToShow?n(s.$slider.find(\".slick-cloned\").slice(0,s.options.slidesToShow)):0===s.currentSlide&&n(s.$slider.find(\".slick-cloned\").slice(-1*s.options.slidesToShow))},e.prototype.loadSlider=function(){var i=this;i.setPosition(),i.$slideTrack.css({opacity:1}),i.$slider.removeClass(\"slick-loading\"),i.initUI(),\"progressive\"===i.options.lazyLoad&&i.progressiveLazyLoad()},e.prototype.next=e.prototype.slickNext=function(){this.changeSlide({data:{message:\"next\"}})},e.prototype.orientationChange=function(){this.checkResponsive(),this.setPosition()},e.prototype.pause=e.prototype.slickPause=function(){this.autoPlayClear(),this.paused=!0},e.prototype.play=e.prototype.slickPlay=function(){var i=this;i.autoPlay(),i.options.autoplay=!0,i.paused=!1,i.focussed=!1,i.interrupted=!1},e.prototype.postSlide=function(e){var t=this;t.unslicked||(t.$slider.trigger(\"afterChange\",[t,e]),t.animating=!1,t.slideCount>t.options.slidesToShow&&t.setPosition(),t.swipeLeft=null,t.options.autoplay&&t.autoPlay(),!0===t.options.accessibility&&(t.initADA(),t.options.focusOnChange&&i(t.$slides.get(t.currentSlide)).attr(\"tabindex\",0).focus()))},e.prototype.prev=e.prototype.slickPrev=function(){this.changeSlide({data:{message:\"previous\"}})},e.prototype.preventDefault=function(i){i.preventDefault()},e.prototype.progressiveLazyLoad=function(e){e=e||1;var t,o,s,n,r,l=this,d=i(\"img[data-lazy]\",l.$slider);d.length?(t=d.first(),o=t.attr(\"data-lazy\"),s=t.attr(\"data-srcset\"),n=t.attr(\"data-sizes\")||l.$slider.attr(\"data-sizes\"),(r=document.createElement(\"img\")).onload=function(){s&&(t.attr(\"srcset\",s),n&&t.attr(\"sizes\",n)),t.attr(\"src\",o).removeAttr(\"data-lazy data-srcset data-sizes\").removeClass(\"slick-loading\"),!0===l.options.adaptiveHeight&&l.setPosition(),l.$slider.trigger(\"lazyLoaded\",[l,t,o]),l.progressiveLazyLoad()},r.onerror=function(){e<3?setTimeout(function(){l.progressiveLazyLoad(e+1)},500):(t.removeAttr(\"data-lazy\").removeClass(\"slick-loading\").addClass(\"slick-lazyload-error\"),l.$slider.trigger(\"lazyLoadError\",[l,t,o]),l.progressiveLazyLoad())},r.src=o):l.$slider.trigger(\"allImagesLoaded\",[l])},e.prototype.refresh=function(e){var t,o,s=this;o=s.slideCount-s.options.slidesToShow,!s.options.infinite&&s.currentSlide>o&&(s.currentSlide=o),s.slideCount<=s.options.slidesToShow&&(s.currentSlide=0),t=s.currentSlide,s.destroy(!0),i.extend(s,s.initials,{currentSlide:t}),s.init(),e||s.changeSlide({data:{message:\"index\",index:t}},!1)},e.prototype.registerBreakpoints=function(){var e,t,o,s=this,n=s.options.responsive||null;if(\"array\"===i.type(n)&&n.length){s.respondTo=s.options.respondTo||\"window\";for(e in n)if(o=s.breakpoints.length-1,n.hasOwnProperty(e)){for(t=n[e].breakpoint;o>=0;)s.breakpoints[o]&&s.breakpoints[o]===t&&s.breakpoints.splice(o,1),o--;s.breakpoints.push(t),s.breakpointSettings[t]=n[e].settings}s.breakpoints.sort(function(i,e){return s.options.mobileFirst?i-e:e-i})}},e.prototype.reinit=function(){var e=this;e.$slides=e.$slideTrack.children(e.options.slide).addClass(\"slick-slide\"),e.slideCount=e.$slides.length,e.currentSlide>=e.slideCount&&0!==e.currentSlide&&(e.currentSlide=e.currentSlide-e.options.slidesToScroll),e.slideCount<=e.options.slidesToShow&&(e.currentSlide=0),e.registerBreakpoints(),e.setProps(),e.setupInfinite(),e.buildArrows(),e.updateArrows(),e.initArrowEvents(),e.buildDots(),e.updateDots(),e.initDotEvents(),e.cleanUpSlideEvents(),e.initSlideEvents(),e.checkResponsive(!1,!0),!0===e.options.focusOnSelect&&i(e.$slideTrack).children().on(\"click.slick\",e.selectHandler),e.setSlideClasses(\"number\"==typeof e.currentSlide?e.currentSlide:0),e.setPosition(),e.focusHandler(),e.paused=!e.options.autoplay,e.autoPlay(),e.$slider.trigger(\"reInit\",[e])},e.prototype.resize=function(){var e=this;i(window).width()!==e.windowWidth&&(clearTimeout(e.windowDelay),e.windowDelay=window.setTimeout(function(){e.windowWidth=i(window).width(),e.checkResponsive(),e.unslicked||e.setPosition()},50))},e.prototype.removeSlide=e.prototype.slickRemove=function(i,e,t){var o=this;if(i=\"boolean\"==typeof i?!0===(e=i)?0:o.slideCount-1:!0===e?--i:i,o.slideCount<1||i<0||i>o.slideCount-1)return!1;o.unload(),!0===t?o.$slideTrack.children().remove():o.$slideTrack.children(this.options.slide).eq(i).remove(),o.$slides=o.$slideTrack.children(this.options.slide),o.$slideTrack.children(this.options.slide).detach(),o.$slideTrack.append(o.$slides),o.$slidesCache=o.$slides,o.reinit()},e.prototype.setCSS=function(i){var e,t,o=this,s={};!0===o.options.rtl&&(i=-i),e=\"left\"==o.positionProp?Math.ceil(i)+\"px\":\"0px\",t=\"top\"==o.positionProp?Math.ceil(i)+\"px\":\"0px\",s[o.positionProp]=i,!1===o.transformsEnabled?o.$slideTrack.css(s):(s={},!1===o.cssTransitions?(s[o.animType]=\"translate(\"+e+\", \"+t+\")\",o.$slideTrack.css(s)):(s[o.animType]=\"translate3d(\"+e+\", \"+t+\", 0px)\",o.$slideTrack.css(s)))},e.prototype.setDimensions=function(){var i=this;!1===i.options.vertical?!0===i.options.centerMode&&i.$list.css({padding:\"0px \"+i.options.centerPadding}):(i.$list.height(i.$slides.first().outerHeight(!0)*i.options.slidesToShow),!0===i.options.centerMode&&i.$list.css({padding:i.options.centerPadding+\" 0px\"})),i.listWidth=i.$list.width(),i.listHeight=i.$list.height(),!1===i.options.vertical&&!1===i.options.variableWidth?(i.slideWidth=Math.ceil(i.listWidth/i.options.slidesToShow),i.$slideTrack.width(Math.ceil(i.slideWidth*i.$slideTrack.children(\".slick-slide\").length))):!0===i.options.variableWidth?i.$slideTrack.width(5e3*i.slideCount):(i.slideWidth=Math.ceil(i.listWidth),i.$slideTrack.height(Math.ceil(i.$slides.first().outerHeight(!0)*i.$slideTrack.children(\".slick-slide\").length)));var e=i.$slides.first().outerWidth(!0)-i.$slides.first().width();!1===i.options.variableWidth&&i.$slideTrack.children(\".slick-slide\").width(i.slideWidth-e)},e.prototype.setFade=function(){var e,t=this;t.$slides.each(function(o,s){e=t.slideWidth*o*-1,!0===t.options.rtl?i(s).css({position:\"relative\",right:e,top:0,zIndex:t.options.zIndex-2,opacity:0}):i(s).css({position:\"relative\",left:e,top:0,zIndex:t.options.zIndex-2,opacity:0})}),t.$slides.eq(t.currentSlide).css({zIndex:t.options.zIndex-1,opacity:1})},e.prototype.setHeight=function(){var i=this;if(1===i.options.slidesToShow&&!0===i.options.adaptiveHeight&&!1===i.options.vertical){var e=i.$slides.eq(i.currentSlide).outerHeight(!0);i.$list.css(\"height\",e)}},e.prototype.setOption=e.prototype.slickSetOption=function(){var e,t,o,s,n,r=this,l=!1;if(\"object\"===i.type(arguments[0])?(o=arguments[0],l=arguments[1],n=\"multiple\"):\"string\"===i.type(arguments[0])&&(o=arguments[0],s=arguments[1],l=arguments[2],\"responsive\"===arguments[0]&&\"array\"===i.type(arguments[1])?n=\"responsive\":void 0!==arguments[1]&&(n=\"single\")),\"single\"===n)r.options[o]=s;else if(\"multiple\"===n)i.each(o,function(i,e){r.options[i]=e});else if(\"responsive\"===n)for(t in s)if(\"array\"!==i.type(r.options.responsive))r.options.responsive=[s[t]];else{for(e=r.options.responsive.length-1;e>=0;)r.options.responsive[e].breakpoint===s[t].breakpoint&&r.options.responsive.splice(e,1),e--;r.options.responsive.push(s[t])}l&&(r.unload(),r.reinit())},e.prototype.setPosition=function(){var i=this;i.setDimensions(),i.setHeight(),!1===i.options.fade?i.setCSS(i.getLeft(i.currentSlide)):i.setFade(),i.$slider.trigger(\"setPosition\",[i])},e.prototype.setProps=function(){var i=this,e=document.body.style;i.positionProp=!0===i.options.vertical?\"top\":\"left\",\"top\"===i.positionProp?i.$slider.addClass(\"slick-vertical\"):i.$slider.removeClass(\"slick-vertical\"),void 0===e.WebkitTransition&&void 0===e.MozTransition&&void 0===e.msTransition||!0===i.options.useCSS&&(i.cssTransitions=!0),i.options.fade&&(\"number\"==typeof i.options.zIndex?i.options.zIndex<3&&(i.options.zIndex=3):i.options.zIndex=i.defaults.zIndex),void 0!==e.OTransform&&(i.animType=\"OTransform\",i.transformType=\"-o-transform\",i.transitionType=\"OTransition\",void 0===e.perspectiveProperty&&void 0===e.webkitPerspective&&(i.animType=!1)),void 0!==e.MozTransform&&(i.animType=\"MozTransform\",i.transformType=\"-moz-transform\",i.transitionType=\"MozTransition\",void 0===e.perspectiveProperty&&void 0===e.MozPerspective&&(i.animType=!1)),void 0!==e.webkitTransform&&(i.animType=\"webkitTransform\",i.transformType=\"-webkit-transform\",i.transitionType=\"webkitTransition\",void 0===e.perspectiveProperty&&void 0===e.webkitPerspective&&(i.animType=!1)),void 0!==e.msTransform&&(i.animType=\"msTransform\",i.transformType=\"-ms-transform\",i.transitionType=\"msTransition\",void 0===e.msTransform&&(i.animType=!1)),void 0!==e.transform&&!1!==i.animType&&(i.animType=\"transform\",i.transformType=\"transform\",i.transitionType=\"transition\"),i.transformsEnabled=i.options.useTransform&&null!==i.animType&&!1!==i.animType},e.prototype.setSlideClasses=function(i){var e,t,o,s,n=this;if(t=n.$slider.find(\".slick-slide\").removeClass(\"slick-active slick-center slick-current\").attr(\"aria-hidden\",\"true\"),n.$slides.eq(i).addClass(\"slick-current\"),!0===n.options.centerMode){var r=n.options.slidesToShow%2==0?1:0;e=Math.floor(n.options.slidesToShow/2),!0===n.options.infinite&&(i>=e&&i<=n.slideCount-1-e?n.$slides.slice(i-e+r,i+e+1).addClass(\"slick-active\").attr(\"aria-hidden\",\"false\"):(o=n.options.slidesToShow+i,t.slice(o-e+1+r,o+e+2).addClass(\"slick-active\").attr(\"aria-hidden\",\"false\")),0===i?t.eq(t.length-1-n.options.slidesToShow).addClass(\"slick-center\"):i===n.slideCount-1&&t.eq(n.options.slidesToShow).addClass(\"slick-center\")),n.$slides.eq(i).addClass(\"slick-center\")}else i>=0&&i<=n.slideCount-n.options.slidesToShow?n.$slides.slice(i,i+n.options.slidesToShow).addClass(\"slick-active\").attr(\"aria-hidden\",\"false\"):t.length<=n.options.slidesToShow?t.addClass(\"slick-active\").attr(\"aria-hidden\",\"false\"):(s=n.slideCount%n.options.slidesToShow,o=!0===n.options.infinite?n.options.slidesToShow+i:i,n.options.slidesToShow==n.options.slidesToScroll&&n.slideCount-i<n.options.slidesToShow?t.slice(o-(n.options.slidesToShow-s),o+s).addClass(\"slick-active\").attr(\"aria-hidden\",\"false\"):t.slice(o,o+n.options.slidesToShow).addClass(\"slick-active\").attr(\"aria-hidden\",\"false\"));\"ondemand\"!==n.options.lazyLoad&&\"anticipated\"!==n.options.lazyLoad||n.lazyLoad()},e.prototype.setupInfinite=function(){var e,t,o,s=this;if(!0===s.options.fade&&(s.options.centerMode=!1),!0===s.options.infinite&&!1===s.options.fade&&(t=null,s.slideCount>s.options.slidesToShow)){for(o=!0===s.options.centerMode?s.options.slidesToShow+1:s.options.slidesToShow,e=s.slideCount;e>s.slideCount-o;e-=1)t=e-1,i(s.$slides[t]).clone(!0).attr(\"id\",\"\").attr(\"data-slick-index\",t-s.slideCount).prependTo(s.$slideTrack).addClass(\"slick-cloned\");for(e=0;e<o+s.slideCount;e+=1)t=e,i(s.$slides[t]).clone(!0).attr(\"id\",\"\").attr(\"data-slick-index\",t+s.slideCount).appendTo(s.$slideTrack).addClass(\"slick-cloned\");s.$slideTrack.find(\".slick-cloned\").find(\"[id]\").each(function(){i(this).attr(\"id\",\"\")})}},e.prototype.interrupt=function(i){i||this.autoPlay(),this.interrupted=i},e.prototype.selectHandler=function(e){var t=i(e.target).is(\".slick-slide\")?i(e.target):i(e.target).parents(\".slick-slide\"),o=parseInt(t.attr(\"data-slick-index\"));o||(o=0),this.slideCount<=this.options.slidesToShow?this.slideHandler(o,!1,!0):this.slideHandler(o)},e.prototype.slideHandler=function(i,e,t){var o,s,n,r,l,d,a=this;if(e=e||!1,!(!0===a.animating&&!0===a.options.waitForAnimate||!0===a.options.fade&&a.currentSlide===i))if(!1===e&&a.asNavFor(i),o=i,l=a.getLeft(o),r=a.getLeft(a.currentSlide),a.currentLeft=null===a.swipeLeft?r:a.swipeLeft,!1===a.options.infinite&&!1===a.options.centerMode&&(i<0||i>a.getDotCount()*a.options.slidesToScroll))!1===a.options.fade&&(o=a.currentSlide,!0!==t&&a.slideCount>a.options.slidesToShow?a.animateSlide(r,function(){a.postSlide(o)}):a.postSlide(o));else if(!1===a.options.infinite&&!0===a.options.centerMode&&(i<0||i>a.slideCount-a.options.slidesToScroll))!1===a.options.fade&&(o=a.currentSlide,!0!==t&&a.slideCount>a.options.slidesToShow?a.animateSlide(r,function(){a.postSlide(o)}):a.postSlide(o));else{if(a.options.autoplay&&clearInterval(a.autoPlayTimer),s=o<0?a.slideCount%a.options.slidesToScroll!=0?a.slideCount-a.slideCount%a.options.slidesToScroll:a.slideCount+o:o>=a.slideCount?a.slideCount%a.options.slidesToScroll!=0?0:o-a.slideCount:o,a.animating=!0,a.$slider.trigger(\"beforeChange\",[a,a.currentSlide,s]),n=a.currentSlide,a.currentSlide=s,a.setSlideClasses(a.currentSlide),a.options.asNavFor&&(d=(d=a.getNavTarget()).slick(\"getSlick\")).slideCount<=d.options.slidesToShow&&d.setSlideClasses(a.currentSlide),a.updateDots(),a.updateArrows(),!0===a.options.fade)return!0!==t?(a.fadeSlideOut(n),a.fadeSlide(s,function(){a.postSlide(s)})):a.postSlide(s),void a.animateHeight();!0!==t&&a.slideCount>a.options.slidesToShow?a.animateSlide(l,function(){a.postSlide(s)}):a.postSlide(s)}},e.prototype.startLoad=function(){var i=this;!0===i.options.arrows&&i.slideCount>i.options.slidesToShow&&(i.$prevArrow.hide(),i.$nextArrow.hide()),!0===i.options.dots&&i.slideCount>i.options.slidesToShow&&i.$dots.hide(),i.$slider.addClass(\"slick-loading\")},e.prototype.swipeDirection=function(){var i,e,t,o,s=this;return i=s.touchObject.startX-s.touchObject.curX,e=s.touchObject.startY-s.touchObject.curY,t=Math.atan2(e,i),(o=Math.round(180*t/Math.PI))<0&&(o=360-Math.abs(o)),o<=45&&o>=0?!1===s.options.rtl?\"left\":\"right\":o<=360&&o>=315?!1===s.options.rtl?\"left\":\"right\":o>=135&&o<=225?!1===s.options.rtl?\"right\":\"left\":!0===s.options.verticalSwiping?o>=35&&o<=135?\"down\":\"up\":\"vertical\"},e.prototype.swipeEnd=function(i){var e,t,o=this;if(o.dragging=!1,o.swiping=!1,o.scrolling)return o.scrolling=!1,!1;if(o.interrupted=!1,o.shouldClick=!(o.touchObject.swipeLength>10),void 0===o.touchObject.curX)return!1;if(!0===o.touchObject.edgeHit&&o.$slider.trigger(\"edge\",[o,o.swipeDirection()]),o.touchObject.swipeLength>=o.touchObject.minSwipe){switch(t=o.swipeDirection()){case\"left\":case\"down\":e=o.options.swipeToSlide?o.checkNavigable(o.currentSlide+o.getSlideCount()):o.currentSlide+o.getSlideCount(),o.currentDirection=0;break;case\"right\":case\"up\":e=o.options.swipeToSlide?o.checkNavigable(o.currentSlide-o.getSlideCount()):o.currentSlide-o.getSlideCount(),o.currentDirection=1}\"vertical\"!=t&&(o.slideHandler(e),o.touchObject={},o.$slider.trigger(\"swipe\",[o,t]))}else o.touchObject.startX!==o.touchObject.curX&&(o.slideHandler(o.currentSlide),o.touchObject={})},e.prototype.swipeHandler=function(i){var e=this;if(!(!1===e.options.swipe||\"ontouchend\"in document&&!1===e.options.swipe||!1===e.options.draggable&&-1!==i.type.indexOf(\"mouse\")))switch(e.touchObject.fingerCount=i.originalEvent&&void 0!==i.originalEvent.touches?i.originalEvent.touches.length:1,e.touchObject.minSwipe=e.listWidth/e.options.touchThreshold,!0===e.options.verticalSwiping&&(e.touchObject.minSwipe=e.listHeight/e.options.touchThreshold),i.data.action){case\"start\":e.swipeStart(i);break;case\"move\":e.swipeMove(i);break;case\"end\":e.swipeEnd(i)}},e.prototype.swipeMove=function(i){var e,t,o,s,n,r,l=this;return n=void 0!==i.originalEvent?i.originalEvent.touches:null,!(!l.dragging||l.scrolling||n&&1!==n.length)&&(e=l.getLeft(l.currentSlide),l.touchObject.curX=void 0!==n?n[0].pageX:i.clientX,l.touchObject.curY=void 0!==n?n[0].pageY:i.clientY,l.touchObject.swipeLength=Math.round(Math.sqrt(Math.pow(l.touchObject.curX-l.touchObject.startX,2))),r=Math.round(Math.sqrt(Math.pow(l.touchObject.curY-l.touchObject.startY,2))),!l.options.verticalSwiping&&!l.swiping&&r>4?(l.scrolling=!0,!1):(!0===l.options.verticalSwiping&&(l.touchObject.swipeLength=r),t=l.swipeDirection(),void 0!==i.originalEvent&&l.touchObject.swipeLength>4&&(l.swiping=!0,i.preventDefault()),s=(!1===l.options.rtl?1:-1)*(l.touchObject.curX>l.touchObject.startX?1:-1),!0===l.options.verticalSwiping&&(s=l.touchObject.curY>l.touchObject.startY?1:-1),o=l.touchObject.swipeLength,l.touchObject.edgeHit=!1,!1===l.options.infinite&&(0===l.currentSlide&&\"right\"===t||l.currentSlide>=l.getDotCount()&&\"left\"===t)&&(o=l.touchObject.swipeLength*l.options.edgeFriction,l.touchObject.edgeHit=!0),!1===l.options.vertical?l.swipeLeft=e+o*s:l.swipeLeft=e+o*(l.$list.height()/l.listWidth)*s,!0===l.options.verticalSwiping&&(l.swipeLeft=e+o*s),!0!==l.options.fade&&!1!==l.options.touchMove&&(!0===l.animating?(l.swipeLeft=null,!1):void l.setCSS(l.swipeLeft))))},e.prototype.swipeStart=function(i){var e,t=this;if(t.interrupted=!0,1!==t.touchObject.fingerCount||t.slideCount<=t.options.slidesToShow)return t.touchObject={},!1;void 0!==i.originalEvent&&void 0!==i.originalEvent.touches&&(e=i.originalEvent.touches[0]),t.touchObject.startX=t.touchObject.curX=void 0!==e?e.pageX:i.clientX,t.touchObject.startY=t.touchObject.curY=void 0!==e?e.pageY:i.clientY,t.dragging=!0},e.prototype.unfilterSlides=e.prototype.slickUnfilter=function(){var i=this;null!==i.$slidesCache&&(i.unload(),i.$slideTrack.children(this.options.slide).detach(),i.$slidesCache.appendTo(i.$slideTrack),i.reinit())},e.prototype.unload=function(){var e=this;i(\".slick-cloned\",e.$slider).remove(),e.$dots&&e.$dots.remove(),e.$prevArrow&&e.htmlExpr.test(e.options.prevArrow)&&e.$prevArrow.remove(),e.$nextArrow&&e.htmlExpr.test(e.options.nextArrow)&&e.$nextArrow.remove(),e.$slides.removeClass(\"slick-slide slick-active slick-visible slick-current\").attr(\"aria-hidden\",\"true\").css(\"width\",\"\")},e.prototype.unslick=function(i){this.$slider.trigger(\"unslick\",[this,i]),this.destroy()},e.prototype.updateArrows=function(){var i=this;Math.floor(i.options.slidesToShow/2),!0===i.options.arrows&&i.slideCount>i.options.slidesToShow&&!i.options.infinite&&(i.$prevArrow.removeClass(\"slick-disabled\").attr(\"aria-disabled\",\"false\"),i.$nextArrow.removeClass(\"slick-disabled\").attr(\"aria-disabled\",\"false\"),0===i.currentSlide?(i.$prevArrow.addClass(\"slick-disabled\").attr(\"aria-disabled\",\"true\"),i.$nextArrow.removeClass(\"slick-disabled\").attr(\"aria-disabled\",\"false\")):i.currentSlide>=i.slideCount-i.options.slidesToShow&&!1===i.options.centerMode?(i.$nextArrow.addClass(\"slick-disabled\").attr(\"aria-disabled\",\"true\"),i.$prevArrow.removeClass(\"slick-disabled\").attr(\"aria-disabled\",\"false\")):i.currentSlide>=i.slideCount-1&&!0===i.options.centerMode&&(i.$nextArrow.addClass(\"slick-disabled\").attr(\"aria-disabled\",\"true\"),i.$prevArrow.removeClass(\"slick-disabled\").attr(\"aria-disabled\",\"false\")))},e.prototype.updateDots=function(){var i=this;null!==i.$dots&&(i.$dots.find(\"li\").removeClass(\"slick-active\").end(),i.$dots.find(\"li\").eq(Math.floor(i.currentSlide/i.options.slidesToScroll)).addClass(\"slick-active\"))},e.prototype.visibility=function(){this.options.autoplay&&(document[this.hidden]?this.interrupted=!0:this.interrupted=!1)},i.fn.slick=function(){var i,t,o=this,s=arguments[0],n=Array.prototype.slice.call(arguments,1),r=o.length;for(i=0;i<r;i++)if(\"object\"==typeof s||void 0===s?o[i].slick=new e(o[i],s):t=o[i].slick[s].apply(o[i].slick,n),void 0!==t)return t;return o}});\n","Magento_PageBuilder/js/resource/jarallax/jarallax-video.min.js":"/*!\n * Name    : Video Background Extension for Jarallax\n * Version : 1.0.1\n * Author  : nK <https://nkdev.info>\n * GitHub  : https://github.com/nk-o/jarallax\n */!function(o){var i={};function n(e){if(i[e])return i[e].exports;var t=i[e]={i:e,l:!1,exports:{}};return o[e].call(t.exports,t,t.exports,n),t.l=!0,t.exports}n.m=o,n.c=i,n.d=function(e,t,o){n.o(e,t)||Object.defineProperty(e,t,{enumerable:!0,get:o})},n.r=function(e){\"undefined\"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:\"Module\"}),Object.defineProperty(e,\"__esModule\",{value:!0})},n.t=function(t,e){if(1&e&&(t=n(t)),8&e)return t;if(4&e&&\"object\"==typeof t&&t&&t.__esModule)return t;var o=Object.create(null);if(n.r(o),Object.defineProperty(o,\"default\",{enumerable:!0,value:t}),2&e&&\"string\"!=typeof t)for(var i in t)n.d(o,i,function(e){return t[e]}.bind(null,i));return o},n.n=function(e){var t=e&&e.__esModule?function(){return e.default}:function(){return e};return n.d(t,\"a\",t),t},n.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},n.p=\"\",n(n.s=6)}([,,function(e,t){e.exports=function(e){\"complete\"===document.readyState||\"interactive\"===document.readyState?e.call():document.attachEvent?document.attachEvent(\"onreadystatechange\",function(){\"interactive\"===document.readyState&&e.call()}):document.addEventListener&&document.addEventListener(\"DOMContentLoaded\",e)}},,function(o,e,t){(function(e){var t;t=\"undefined\"!=typeof window?window:void 0!==e?e:\"undefined\"!=typeof self?self:{},o.exports=t}).call(this,t(5))},function(e,t){function o(e){return(o=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&\"function\"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?\"symbol\":typeof e})(e)}var i;i=function(){return this}();try{i=i||new Function(\"return this\")()}catch(e){\"object\"===(\"undefined\"==typeof window?\"undefined\":o(window))&&(i=window)}e.exports=i},function(e,t,o){e.exports=o(7)},function(e,t,o){\"use strict\";o.r(t);var i=o(8),n=o.n(i),a=o(4),r=o.n(a),l=o(2),p=o.n(l),u=o(10);r.a.VideoWorker=r.a.VideoWorker||n.a,Object(u.default)(),p()(function(){\"undefined\"!=typeof jarallax&&jarallax(document.querySelectorAll(\"[data-jarallax-video]\"))})},function(e,t,o){e.exports=o(9)},function(e,t,o){\"use strict\";function n(e){return(n=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&\"function\"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?\"symbol\":typeof e})(e)}function a(e,t){for(var o=0;o<t.length;o++){var i=t[o];i.enumerable=i.enumerable||!1,i.configurable=!0,\"value\"in i&&(i.writable=!0),Object.defineProperty(e,i.key,i)}}function i(){this._done=[],this._fail=[]}o.r(t),o.d(t,\"default\",function(){return c}),i.prototype={execute:function(e,t){var o=e.length;for(t=Array.prototype.slice.call(t);o--;)e[o].apply(null,t)},resolve:function(){this.execute(this._done,arguments)},reject:function(){this.execute(this._fail,arguments)},done:function(e){this._done.push(e)},fail:function(e){this._fail.push(e)}};var r=0,l=0,p=0,u=0,s=0,d=new i,y=new i,c=function(){function i(e,t){!function(e,t){if(!(e instanceof t))throw new TypeError(\"Cannot call a class as a function\")}(this,i);var o=this;o.url=e,o.options_default={autoplay:!1,loop:!1,mute:!1,volume:100,showContols:!0,startTime:0,endTime:0},o.options=o.extend({},o.options_default,t),o.videoID=o.parseURL(e),o.videoID&&(o.ID=r++,o.loadAPI(),o.init())}return function(e,t,o){t&&a(e.prototype,t),o&&a(e,o)}(i,[{key:\"extend\",value:function(o){var i=arguments;return o=o||{},Object.keys(arguments).forEach(function(t){i[t]&&Object.keys(i[t]).forEach(function(e){o[e]=i[t][e]})}),o}},{key:\"parseURL\",value:function(e){var t,o,i,n,a,r=!(!(t=e.match(/.*(?:youtu.be\\/|v\\/|u\\/\\w\\/|embed\\/|watch\\?v=)([^#\\&\\?]*).*/))||11!==t[1].length)&&t[1],l=!(!(o=e.match(/https?:\\/\\/(?:www\\.|player\\.)?vimeo.com\\/(?:channels\\/(?:\\w+\\/)?|groups\\/([^\\/]*)\\/videos\\/|album\\/(\\d+)\\/video\\/|video\\/|)(\\d+)(?:$|\\/|\\?)/))||!o[3])&&o[3],p=(i=e.split(/,(?=mp4\\:|webm\\:|ogv\\:|ogg\\:)/),n={},a=0,i.forEach(function(e){var t=e.match(/^(mp4|webm|ogv|ogg)\\:(.*)/);t&&t[1]&&t[2]&&(n[\"ogv\"===t[1]?\"ogg\":t[1]]=t[2],a=1)}),!!a&&n);return r?(this.type=\"youtube\",r):l?(this.type=\"vimeo\",l):!!p&&(this.type=\"local\",p)}},{key:\"isValid\",value:function(){return!!this.videoID}},{key:\"on\",value:function(e,t){this.userEventsList=this.userEventsList||[],(this.userEventsList[e]||(this.userEventsList[e]=[])).push(t)}},{key:\"off\",value:function(o,i){var n=this;this.userEventsList&&this.userEventsList[o]&&(i?this.userEventsList[o].forEach(function(e,t){e===i&&(n.userEventsList[o][t]=!1)}):delete this.userEventsList[o])}},{key:\"fire\",value:function(e){var t=this,o=[].slice.call(arguments,1);this.userEventsList&&void 0!==this.userEventsList[e]&&this.userEventsList[e].forEach(function(e){e&&e.apply(t,o)})}},{key:\"play\",value:function(e){var t=this;t.player&&(\"youtube\"===t.type&&t.player.playVideo&&(void 0!==e&&t.player.seekTo(e||0),YT.PlayerState.PLAYING!==t.player.getPlayerState()&&t.player.playVideo()),\"vimeo\"===t.type&&(void 0!==e&&t.player.setCurrentTime(e),t.player.getPaused().then(function(e){e&&t.player.play()})),\"local\"===t.type&&(void 0!==e&&(t.player.currentTime=e),t.player.paused&&t.player.play()))}},{key:\"pause\",value:function(){var t=this;t.player&&(\"youtube\"===t.type&&t.player.pauseVideo&&YT.PlayerState.PLAYING===t.player.getPlayerState()&&t.player.pauseVideo(),\"vimeo\"===t.type&&t.player.getPaused().then(function(e){e||t.player.pause()}),\"local\"===t.type&&(t.player.paused||t.player.pause()))}},{key:\"mute\",value:function(){var e=this;e.player&&(\"youtube\"===e.type&&e.player.mute&&e.player.mute(),\"vimeo\"===e.type&&e.player.setVolume&&e.player.setVolume(0),\"local\"===e.type&&(e.$video.muted=!0))}},{key:\"unmute\",value:function(){var e=this;e.player&&(\"youtube\"===e.type&&e.player.mute&&e.player.unMute(),\"vimeo\"===e.type&&e.player.setVolume&&e.player.setVolume(e.options.volume),\"local\"===e.type&&(e.$video.muted=!1))}},{key:\"setVolume\",value:function(e){var t=0<arguments.length&&void 0!==e&&e,o=this;o.player&&t&&(\"youtube\"===o.type&&o.player.setVolume&&o.player.setVolume(t),\"vimeo\"===o.type&&o.player.setVolume&&o.player.setVolume(t),\"local\"===o.type&&(o.$video.volume=t/100))}},{key:\"getVolume\",value:function(t){var e=this;e.player?(\"youtube\"===e.type&&e.player.getVolume&&t(e.player.getVolume()),\"vimeo\"===e.type&&e.player.getVolume&&e.player.getVolume().then(function(e){t(e)}),\"local\"===e.type&&t(100*e.$video.volume)):t(!1)}},{key:\"getMuted\",value:function(t){var e=this;e.player?(\"youtube\"===e.type&&e.player.isMuted&&t(e.player.isMuted()),\"vimeo\"===e.type&&e.player.getVolume&&e.player.getVolume().then(function(e){t(!!e)}),\"local\"===e.type&&t(e.$video.muted)):t(null)}},{key:\"getImageURL\",value:function(t){var o=this;if(o.videoImage)t(o.videoImage);else{if(\"youtube\"===o.type){var e=[\"maxresdefault\",\"sddefault\",\"hqdefault\",\"0\"],i=0,n=new Image;n.onload=function(){120!==(this.naturalWidth||this.width)||i===e.length-1?(o.videoImage=\"https://img.youtube.com/vi/\".concat(o.videoID,\"/\").concat(e[i],\".jpg\"),t(o.videoImage)):(i++,this.src=\"https://img.youtube.com/vi/\".concat(o.videoID,\"/\").concat(e[i],\".jpg\"))},n.src=\"https://img.youtube.com/vi/\".concat(o.videoID,\"/\").concat(e[i],\".jpg\")}if(\"vimeo\"===o.type){var a=new XMLHttpRequest;a.open(\"GET\",\"https://vimeo.com/api/v2/video/\".concat(o.videoID,\".json\"),!0),a.onreadystatechange=function(){if(4===this.readyState&&200<=this.status&&this.status<400){var e=JSON.parse(this.responseText);o.videoImage=e[0].thumbnail_large,t(o.videoImage)}},a.send(),a=null}}}},{key:\"getIframe\",value:function(e){this.getVideo(e)}},{key:\"getVideo\",value:function(p){var u=this;u.$video?p(u.$video):u.onAPIready(function(){var e,t;if(u.$video||((e=document.createElement(\"div\")).style.display=\"none\"),\"youtube\"===u.type){var o,i;u.playerOptions={},u.playerOptions.videoId=u.videoID,u.playerOptions.playerVars={autohide:1,rel:0,autoplay:0,playsinline:1},u.options.showContols||(u.playerOptions.playerVars.iv_load_policy=3,u.playerOptions.playerVars.modestbranding=1,u.playerOptions.playerVars.controls=0,u.playerOptions.playerVars.showinfo=0,u.playerOptions.playerVars.disablekb=1),u.playerOptions.events={onReady:function(t){if(u.options.mute?t.target.mute():u.options.volume&&t.target.setVolume(u.options.volume),u.options.autoplay&&u.play(u.options.startTime),u.fire(\"ready\",t),u.options.loop&&!u.options.endTime){u.options.endTime=u.player.getDuration()-.1}setInterval(function(){u.getVolume(function(e){u.options.volume!==e&&(u.options.volume=e,u.fire(\"volumechange\",t))})},150)},onStateChange:function(e){u.options.loop&&e.data===YT.PlayerState.ENDED&&u.play(u.options.startTime),o||e.data!==YT.PlayerState.PLAYING||(o=1,u.fire(\"started\",e)),e.data===YT.PlayerState.PLAYING&&u.fire(\"play\",e),e.data===YT.PlayerState.PAUSED&&u.fire(\"pause\",e),e.data===YT.PlayerState.ENDED&&u.fire(\"ended\",e),e.data===YT.PlayerState.PLAYING?i=setInterval(function(){u.fire(\"timeupdate\",e),u.options.endTime&&u.player.getCurrentTime()>=u.options.endTime&&(u.options.loop?u.play(u.options.startTime):u.pause())},150):clearInterval(i)}};var n=!u.$video;if(n){var a=document.createElement(\"div\");a.setAttribute(\"id\",u.playerID),e.appendChild(a),document.body.appendChild(e)}u.player=u.player||new window.YT.Player(u.playerID,u.playerOptions),n&&(u.$video=document.getElementById(u.playerID),u.videoWidth=parseInt(u.$video.getAttribute(\"width\"),10)||1280,u.videoHeight=parseInt(u.$video.getAttribute(\"height\"),10)||720)}if(\"vimeo\"===u.type){if(u.playerOptions={id:u.videoID,autopause:0,transparent:0,autoplay:u.options.autoplay?1:0,loop:u.options.loop?1:0,muted:u.options.mute?1:0},u.options.volume&&(u.playerOptions.volume=u.options.volume),u.options.showContols||(u.playerOptions.badge=0,u.playerOptions.byline=0,u.playerOptions.portrait=0,u.playerOptions.title=0,u.playerOptions.background=1),!u.$video){var r=\"\";Object.keys(u.playerOptions).forEach(function(e){\"\"!==r&&(r+=\"&\"),r+=\"\".concat(e,\"=\").concat(encodeURIComponent(u.playerOptions[e]))}),u.$video=document.createElement(\"iframe\"),u.$video.setAttribute(\"id\",u.playerID),u.$video.setAttribute(\"src\",\"https://player.vimeo.com/video/\".concat(u.videoID,\"?\").concat(r)),u.$video.setAttribute(\"frameborder\",\"0\"),u.$video.setAttribute(\"mozallowfullscreen\",\"\"),u.$video.setAttribute(\"allowfullscreen\",\"\"),e.appendChild(u.$video),document.body.appendChild(e)}var l;u.player=u.player||new Vimeo.Player(u.$video,u.playerOptions),u.options.startTime&&u.options.autoplay&&u.player.setCurrentTime(u.options.startTime),u.player.getVideoWidth().then(function(e){u.videoWidth=e||1280}),u.player.getVideoHeight().then(function(e){u.videoHeight=e||720}),u.player.on(\"timeupdate\",function(e){l||(u.fire(\"started\",e),l=1),u.fire(\"timeupdate\",e),u.options.endTime&&u.options.endTime&&e.seconds>=u.options.endTime&&(u.options.loop?u.play(u.options.startTime):u.pause())}),u.player.on(\"play\",function(e){u.fire(\"play\",e),u.options.startTime&&0===e.seconds&&u.play(u.options.startTime)}),u.player.on(\"pause\",function(e){u.fire(\"pause\",e)}),u.player.on(\"ended\",function(e){u.fire(\"ended\",e)}),u.player.on(\"loaded\",function(e){u.fire(\"ready\",e)}),u.player.on(\"volumechange\",function(e){u.fire(\"volumechange\",e)})}\"local\"===u.type&&(u.$video||(u.$video=document.createElement(\"video\"),u.options.showContols&&(u.$video.controls=!0),u.options.mute?u.$video.muted=!0:u.$video.volume&&(u.$video.volume=u.options.volume/100),u.options.loop&&(u.$video.loop=!0),u.$video.setAttribute(\"playsinline\",\"\"),u.$video.setAttribute(\"webkit-playsinline\",\"\"),u.$video.setAttribute(\"id\",u.playerID),e.appendChild(u.$video),document.body.appendChild(e),Object.keys(u.videoID).forEach(function(e){!function(e,t,o){var i=document.createElement(\"source\");i.src=t,i.type=o,e.appendChild(i)}(u.$video,u.videoID[e],\"video/\".concat(e))})),u.player=u.player||u.$video,u.player.addEventListener(\"playing\",function(e){t||u.fire(\"started\",e),t=1}),u.player.addEventListener(\"timeupdate\",function(e){u.fire(\"timeupdate\",e),u.options.endTime&&u.options.endTime&&this.currentTime>=u.options.endTime&&(u.options.loop?u.play(u.options.startTime):u.pause())}),u.player.addEventListener(\"play\",function(e){u.fire(\"play\",e)}),u.player.addEventListener(\"pause\",function(e){u.fire(\"pause\",e)}),u.player.addEventListener(\"ended\",function(e){u.fire(\"ended\",e)}),u.player.addEventListener(\"loadedmetadata\",function(){u.videoWidth=this.videoWidth||1280,u.videoHeight=this.videoHeight||720,u.fire(\"ready\"),u.options.autoplay&&u.play(u.options.startTime)}),u.player.addEventListener(\"volumechange\",function(e){u.getVolume(function(e){u.options.volume=e}),u.fire(\"volumechange\",e)}));p(u.$video)})}},{key:\"init\",value:function(){this.playerID=\"VideoWorker-\".concat(this.ID)}},{key:\"loadAPI\",value:function(){if(!l||!p){var e=\"\";if(\"youtube\"!==this.type||l||(l=1,e=\"https://www.youtube.com/iframe_api\"),\"vimeo\"===this.type&&!p){if(p=1,\"undefined\"!=typeof Vimeo)return;e=\"https://player.vimeo.com/api/player.js\"}if(e){var t=document.createElement(\"script\"),o=document.getElementsByTagName(\"head\")[0];t.src=e,o.appendChild(t),t=o=null}}}},{key:\"onAPIready\",value:function(e){if(\"youtube\"===this.type&&(\"undefined\"!=typeof YT&&0!==YT.loaded||u?\"object\"===(\"undefined\"==typeof YT?\"undefined\":n(YT))&&1===YT.loaded?e():d.done(function(){e()}):(u=1,window.onYouTubeIframeAPIReady=function(){window.onYouTubeIframeAPIReady=null,d.resolve(\"done\"),e()})),\"vimeo\"===this.type)if(\"undefined\"!=typeof Vimeo||s)\"undefined\"!=typeof Vimeo?e():y.done(function(){e()});else{s=1;var t=setInterval(function(){\"undefined\"!=typeof Vimeo&&(clearInterval(t),y.resolve(\"done\"),e())},20)}\"local\"===this.type&&e()}}]),i}()},function(e,t,o){\"use strict\";o.r(t),o.d(t,\"default\",function(){return a});var i=o(8),r=o.n(i),n=o(4),p=o.n(n);function a(){var e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:p.a.jarallax;if(void 0!==e){var t=e.constructor,i=t.prototype.onScroll;t.prototype.onScroll=function(){var o=this;i.apply(o),o.isVideoInserted||!o.video||o.options.videoLazyLoading&&!o.isElementInViewport||o.options.disableVideo()||(o.isVideoInserted=!0,o.video.getVideo(function(e){var t=e.parentNode;o.css(e,{position:o.image.position,top:\"0px\",left:\"0px\",right:\"0px\",bottom:\"0px\",width:\"100%\",height:\"100%\",maxWidth:\"none\",maxHeight:\"none\",margin:0,zIndex:-1}),o.$video=e,o.image.$container.appendChild(e),t.parentNode.removeChild(t)}))};var l=t.prototype.coverImage;t.prototype.coverImage=function(){var e=this,t=l.apply(e),o=!!e.image.$item&&e.image.$item.nodeName;if(t&&e.video&&o&&(\"IFRAME\"===o||\"VIDEO\"===o)){var i=t.image.height,n=i*e.image.width/e.image.height,a=(t.container.width-n)/2,r=t.image.marginTop;t.container.width>n&&(i=(n=t.container.width)*e.image.height/e.image.width,a=0,r+=(t.image.height-i)/2),\"IFRAME\"===o&&(i+=400,r-=200),e.css(e.$video,{width:\"\".concat(n,\"px\"),marginLeft:\"\".concat(a,\"px\"),height:\"\".concat(i,\"px\"),marginTop:\"\".concat(r,\"px\")})}return t};var o=t.prototype.initImg;t.prototype.initImg=function(){var e=this,t=o.apply(e);return e.options.videoSrc||(e.options.videoSrc=e.$item.getAttribute(\"data-jarallax-video\")||null),e.options.videoSrc?(e.defaultInitImgResult=t,!0):t};var n=t.prototype.canInitParallax;t.prototype.canInitParallax=function(){var o=this,e=n.apply(o);if(!o.options.videoSrc)return e;var t=new r.a(o.options.videoSrc,{autoplay:!0,loop:o.options.videoLoop,showContols:!1,startTime:o.options.videoStartTime||0,endTime:o.options.videoEndTime||0,mute:o.options.videoVolume?0:1,volume:o.options.videoVolume||0});if(t.isValid())if(e){if(t.on(\"ready\",function(){if(o.options.videoPlayOnlyVisible){var e=o.onScroll;o.onScroll=function(){e.apply(o),!o.options.videoLoop&&(o.options.videoLoop||o.videoEnded)||(o.isVisible()?t.play():t.pause())}}else t.play()}),t.on(\"started\",function(){o.image.$default_item=o.image.$item,o.image.$item=o.$video,o.image.width=o.video.videoWidth||1280,o.image.height=o.video.videoHeight||720,o.coverImage(),o.clipContainer(),o.onScroll(),o.image.$default_item&&(o.image.$default_item.style.display=\"none\")}),t.on(\"ended\",function(){o.videoEnded=!0,o.options.videoLoop||o.image.$default_item&&(o.image.$item=o.image.$default_item,o.image.$item.style.display=\"block\",o.coverImage(),o.clipContainer(),o.onScroll())}),o.video=t,!o.defaultInitImgResult)return o.image.src=\"data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7\",\"local\"===t.type||(t.getImageURL(function(e){o.image.bgImage='url(\"'.concat(e,'\")'),o.init()}),!1)}else o.defaultInitImgResult||t.getImageURL(function(e){var t=o.$item.getAttribute(\"style\");t&&o.$item.setAttribute(\"data-jarallax-original-styles\",t),o.css(o.$item,{\"background-image\":'url(\"'.concat(e,'\")'),\"background-position\":\"center\",\"background-size\":\"cover\"})});return e};var a=t.prototype.destroy;t.prototype.destroy=function(){var e=this;e.image.$default_item&&(e.image.$item=e.image.$default_item,delete e.image.$default_item),a.apply(e)}}}}]);\n//# sourceMappingURL=jarallax-video.min.js.map\n","Magento_PageBuilder/js/resource/jarallax/jarallax.min.js":"/*!\n * Name    : Just Another Parallax [Jarallax]\n * Version : 1.12.5\n * Author  : nK <https://nkdev.info>\n * GitHub  : https://github.com/nk-o/jarallax\n */!function(n){var o={};function i(e){if(o[e])return o[e].exports;var t=o[e]={i:e,l:!1,exports:{}};return n[e].call(t.exports,t,t.exports,i),t.l=!0,t.exports}i.m=n,i.c=o,i.d=function(e,t,n){i.o(e,t)||Object.defineProperty(e,t,{enumerable:!0,get:n})},i.r=function(e){\"undefined\"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:\"Module\"}),Object.defineProperty(e,\"__esModule\",{value:!0})},i.t=function(t,e){if(1&e&&(t=i(t)),8&e)return t;if(4&e&&\"object\"==typeof t&&t&&t.__esModule)return t;var n=Object.create(null);if(i.r(n),Object.defineProperty(n,\"default\",{enumerable:!0,value:t}),2&e&&\"string\"!=typeof t)for(var o in t)i.d(n,o,function(e){return t[e]}.bind(null,o));return n},i.n=function(e){var t=e&&e.__esModule?function(){return e.default}:function(){return e};return i.d(t,\"a\",t),t},i.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},i.p=\"\",i(i.s=10)}([,,function(e,t){e.exports=function(e){\"complete\"===document.readyState||\"interactive\"===document.readyState?e.call():document.attachEvent?document.attachEvent(\"onreadystatechange\",function(){\"interactive\"===document.readyState&&e.call()}):document.addEventListener&&document.addEventListener(\"DOMContentLoaded\",e)}},function(n,e,t){(function(e){var t=\"undefined\"!=typeof window?window:void 0!==e?e:\"undefined\"!=typeof self?self:{};n.exports=t}).call(this,t(4))},function(e,t){function n(e){return(n=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&\"function\"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?\"symbol\":typeof e})(e)}var o=function(){return this}();try{o=o||new Function(\"return this\")()}catch(e){\"object\"===(\"undefined\"==typeof window?\"undefined\":n(window))&&(o=window)}e.exports=o},,,,,,function(e,t,n){e.exports=n(11)},function(e,t,n){\"use strict\";n.r(t);var o=n(2),i=n.n(o),a=n(3),r=n(12);function l(e){return(l=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&\"function\"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?\"symbol\":typeof e})(e)}var s,c,u=a.window.jarallax;a.window.jarallax=r.default,a.window.jarallax.noConflict=function(){return a.window.jarallax=u,this},void 0!==a.jQuery&&((s=function(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];Array.prototype.unshift.call(t,this);var o=r.default.apply(a.window,t);return\"object\"!==l(o)?o:this}).constructor=r.default.constructor,c=a.jQuery.fn.jarallax,a.jQuery.fn.jarallax=s,a.jQuery.fn.jarallax.noConflict=function(){return a.jQuery.fn.jarallax=c,this}),i()(function(){Object(r.default)(document.querySelectorAll(\"[data-jarallax]\"))})},function(e,t,n){\"use strict\";n.r(t);var o=n(2),i=n.n(o),b=n(3);function c(e,t){return function(e){if(Array.isArray(e))return e}(e)||function(e,t){if(\"undefined\"==typeof Symbol||!(Symbol.iterator in Object(e)))return;var n=[],o=!0,i=!1,a=void 0;try{for(var r,l=e[Symbol.iterator]();!(o=(r=l.next()).done)&&(n.push(r.value),!t||n.length!==t);o=!0);}catch(e){i=!0,a=e}finally{try{o||null==l.return||l.return()}finally{if(i)throw a}}return n}(e,t)||function(e,t){if(!e)return;if(\"string\"==typeof e)return a(e,t);var n=Object.prototype.toString.call(e).slice(8,-1);\"Object\"===n&&e.constructor&&(n=e.constructor.name);if(\"Map\"===n||\"Set\"===n)return Array.from(e);if(\"Arguments\"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return a(e,t)}(e,t)||function(){throw new TypeError(\"Invalid attempt to destructure non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\")}()}function a(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,o=new Array(t);n<t;n++)o[n]=e[n];return o}function u(e){return(u=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&\"function\"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?\"symbol\":typeof e})(e)}function r(e,t){for(var n=0;n<t.length;n++){var o=t[n];o.enumerable=o.enumerable||!1,o.configurable=!0,\"value\"in o&&(o.writable=!0),Object.defineProperty(e,o.key,o)}}var l,h,p=b.window.navigator,d=-1<p.userAgent.indexOf(\"MSIE \")||-1<p.userAgent.indexOf(\"Trident/\")||-1<p.userAgent.indexOf(\"Edge/\"),s=/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(p.userAgent),m=function(){for(var e=\"transform WebkitTransform MozTransform\".split(\" \"),t=document.createElement(\"div\"),n=0;n<e.length;n+=1)if(t&&void 0!==t.style[e[n]])return e[n];return!1}();function f(){h=s?(!l&&document.body&&((l=document.createElement(\"div\")).style.cssText=\"position: fixed; top: -9999px; left: 0; height: 100vh; width: 0;\",document.body.appendChild(l)),(l?l.clientHeight:0)||b.window.innerHeight||document.documentElement.clientHeight):b.window.innerHeight||document.documentElement.clientHeight}f(),b.window.addEventListener(\"resize\",f),b.window.addEventListener(\"orientationchange\",f),b.window.addEventListener(\"load\",f),i()(function(){f()});var g=[];function y(){g.length&&(g.forEach(function(e,t){var n=e.instance,o=e.oldData,i=n.$item.getBoundingClientRect(),a={width:i.width,height:i.height,top:i.top,bottom:i.bottom,wndW:b.window.innerWidth,wndH:h},r=!o||o.wndW!==a.wndW||o.wndH!==a.wndH||o.width!==a.width||o.height!==a.height,l=r||!o||o.top!==a.top||o.bottom!==a.bottom;g[t].oldData=a,r&&n.onResize(),l&&n.onScroll()}),b.window.requestAnimationFrame(y))}function v(e,t){(\"object\"===(\"undefined\"==typeof HTMLElement?\"undefined\":u(HTMLElement))?e instanceof HTMLElement:e&&\"object\"===u(e)&&null!==e&&1===e.nodeType&&\"string\"==typeof e.nodeName)&&(e=[e]);for(var n,o=e.length,i=0,a=arguments.length,r=new Array(2<a?a-2:0),l=2;l<a;l++)r[l-2]=arguments[l];for(;i<o;i+=1)if(\"object\"===u(t)||void 0===t?e[i].jarallax||(e[i].jarallax=new w(e[i],t)):e[i].jarallax&&(n=e[i].jarallax[t].apply(e[i].jarallax,r)),void 0!==n)return n;return e}var x=0,w=function(){function s(e,t){!function(e,t){if(!(e instanceof t))throw new TypeError(\"Cannot call a class as a function\")}(this,s);var n=this;n.instanceID=x,x+=1,n.$item=e,n.defaults={type:\"scroll\",speed:.5,imgSrc:null,imgElement:\".jarallax-img\",imgSize:\"cover\",imgPosition:\"50% 50%\",imgRepeat:\"no-repeat\",keepImg:!1,elementInViewport:null,zIndex:-100,disableParallax:!1,disableVideo:!1,videoSrc:null,videoStartTime:0,videoEndTime:0,videoVolume:0,videoLoop:!0,videoPlayOnlyVisible:!0,videoLazyLoading:!0,onScroll:null,onInit:null,onDestroy:null,onCoverImage:null};var o,i,a=n.$item.dataset||{},r={};Object.keys(a).forEach(function(e){var t=e.substr(0,1).toLowerCase()+e.substr(1);t&&void 0!==n.defaults[t]&&(r[t]=a[e])}),n.options=n.extend({},n.defaults,r,t),n.pureOptions=n.extend({},n.options),Object.keys(n.options).forEach(function(e){\"true\"===n.options[e]?n.options[e]=!0:\"false\"===n.options[e]&&(n.options[e]=!1)}),n.options.speed=Math.min(2,Math.max(-1,parseFloat(n.options.speed))),\"string\"==typeof n.options.disableParallax&&(n.options.disableParallax=new RegExp(n.options.disableParallax)),n.options.disableParallax instanceof RegExp&&(o=n.options.disableParallax,n.options.disableParallax=function(){return o.test(p.userAgent)}),\"function\"!=typeof n.options.disableParallax&&(n.options.disableParallax=function(){return!1}),\"string\"==typeof n.options.disableVideo&&(n.options.disableVideo=new RegExp(n.options.disableVideo)),n.options.disableVideo instanceof RegExp&&(i=n.options.disableVideo,n.options.disableVideo=function(){return i.test(p.userAgent)}),\"function\"!=typeof n.options.disableVideo&&(n.options.disableVideo=function(){return!1});var l=n.options.elementInViewport;l&&\"object\"===u(l)&&void 0!==l.length&&(l=c(l,1)[0]),l instanceof Element||(l=null),n.options.elementInViewport=l,n.image={src:n.options.imgSrc||null,$container:null,useImgTag:!1,position:/iPad|iPhone|iPod|Android/.test(p.userAgent)?\"absolute\":\"fixed\"},n.initImg()&&n.canInitParallax()&&n.init()}var e,t,n;return e=s,(t=[{key:\"css\",value:function(t,n){return\"string\"==typeof n?b.window.getComputedStyle(t).getPropertyValue(n):(n.transform&&m&&(n[m]=n.transform),Object.keys(n).forEach(function(e){t.style[e]=n[e]}),t)}},{key:\"extend\",value:function(n){for(var e=arguments.length,o=new Array(1<e?e-1:0),t=1;t<e;t++)o[t-1]=arguments[t];return n=n||{},Object.keys(o).forEach(function(t){o[t]&&Object.keys(o[t]).forEach(function(e){n[e]=o[t][e]})}),n}},{key:\"getWindowData\",value:function(){return{width:b.window.innerWidth||document.documentElement.clientWidth,height:h,y:document.documentElement.scrollTop}}},{key:\"initImg\",value:function(){var e=this,t=e.options.imgElement;return t&&\"string\"==typeof t&&(t=e.$item.querySelector(t)),t instanceof Element||(e.options.imgSrc?(t=new Image).src=e.options.imgSrc:t=null),t&&(e.options.keepImg?e.image.$item=t.cloneNode(!0):(e.image.$item=t,e.image.$itemParent=t.parentNode),e.image.useImgTag=!0),!!e.image.$item||(null===e.image.src&&(e.image.src=\"data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7\",e.image.bgImage=e.css(e.$item,\"background-image\")),!(!e.image.bgImage||\"none\"===e.image.bgImage))}},{key:\"canInitParallax\",value:function(){return m&&!this.options.disableParallax()}},{key:\"init\",value:function(){var e,t,n,o=this,i={position:\"absolute\",top:0,left:0,width:\"100%\",height:\"100%\",overflow:\"hidden\"},a={pointerEvents:\"none\",transformStyle:\"preserve-3d\",backfaceVisibility:\"hidden\",willChange:\"transform,opacity\"};o.options.keepImg||((e=o.$item.getAttribute(\"style\"))&&o.$item.setAttribute(\"data-jarallax-original-styles\",e),!o.image.useImgTag||(t=o.image.$item.getAttribute(\"style\"))&&o.image.$item.setAttribute(\"data-jarallax-original-styles\",t)),\"static\"===o.css(o.$item,\"position\")&&o.css(o.$item,{position:\"relative\"}),\"auto\"===o.css(o.$item,\"z-index\")&&o.css(o.$item,{zIndex:0}),o.image.$container=document.createElement(\"div\"),o.css(o.image.$container,i),o.css(o.image.$container,{\"z-index\":o.options.zIndex}),d&&o.css(o.image.$container,{opacity:.9999}),o.image.$container.setAttribute(\"id\",\"jarallax-container-\".concat(o.instanceID)),o.$item.appendChild(o.image.$container),o.image.useImgTag?a=o.extend({\"object-fit\":o.options.imgSize,\"object-position\":o.options.imgPosition,\"font-family\":\"object-fit: \".concat(o.options.imgSize,\"; object-position: \").concat(o.options.imgPosition,\";\"),\"max-width\":\"none\"},i,a):(o.image.$item=document.createElement(\"div\"),o.image.src&&(a=o.extend({\"background-position\":o.options.imgPosition,\"background-size\":o.options.imgSize,\"background-repeat\":o.options.imgRepeat,\"background-image\":o.image.bgImage||'url(\"'.concat(o.image.src,'\")')},i,a))),\"opacity\"!==o.options.type&&\"scale\"!==o.options.type&&\"scale-opacity\"!==o.options.type&&1!==o.options.speed||(o.image.position=\"absolute\"),\"fixed\"===o.image.position&&(n=function(e){for(var t=[];null!==e.parentElement;)1===(e=e.parentElement).nodeType&&t.push(e);return t}(o.$item).filter(function(e){var t=b.window.getComputedStyle(e),n=t[\"-webkit-transform\"]||t[\"-moz-transform\"]||t.transform;return n&&\"none\"!==n||/(auto|scroll)/.test(t.overflow+t[\"overflow-y\"]+t[\"overflow-x\"])}),o.image.position=n.length?\"absolute\":\"fixed\"),a.position=o.image.position,o.css(o.image.$item,a),o.image.$container.appendChild(o.image.$item),o.onResize(),o.onScroll(!0),o.options.onInit&&o.options.onInit.call(o),\"none\"!==o.css(o.$item,\"background-image\")&&o.css(o.$item,{\"background-image\":\"none\"}),o.addToParallaxList()}},{key:\"addToParallaxList\",value:function(){g.push({instance:this}),1===g.length&&b.window.requestAnimationFrame(y)}},{key:\"removeFromParallaxList\",value:function(){var n=this;g.forEach(function(e,t){e.instance.instanceID===n.instanceID&&g.splice(t,1)})}},{key:\"destroy\",value:function(){var e=this;e.removeFromParallaxList();var t,n=e.$item.getAttribute(\"data-jarallax-original-styles\");e.$item.removeAttribute(\"data-jarallax-original-styles\"),n?e.$item.setAttribute(\"style\",n):e.$item.removeAttribute(\"style\"),e.image.useImgTag&&(t=e.image.$item.getAttribute(\"data-jarallax-original-styles\"),e.image.$item.removeAttribute(\"data-jarallax-original-styles\"),t?e.image.$item.setAttribute(\"style\",n):e.image.$item.removeAttribute(\"style\"),e.image.$itemParent&&e.image.$itemParent.appendChild(e.image.$item)),e.$clipStyles&&e.$clipStyles.parentNode.removeChild(e.$clipStyles),e.image.$container&&e.image.$container.parentNode.removeChild(e.image.$container),e.options.onDestroy&&e.options.onDestroy.call(e),delete e.$item.jarallax}},{key:\"clipContainer\",value:function(){var e,t,n,o,i;\"fixed\"===this.image.position&&(n=(t=(e=this).image.$container.getBoundingClientRect()).width,o=t.height,e.$clipStyles||(e.$clipStyles=document.createElement(\"style\"),e.$clipStyles.setAttribute(\"type\",\"text/css\"),e.$clipStyles.setAttribute(\"id\",\"jarallax-clip-\".concat(e.instanceID)),(document.head||document.getElementsByTagName(\"head\")[0]).appendChild(e.$clipStyles)),i=\"#jarallax-container-\".concat(e.instanceID,\" {\\n            clip: rect(0 \").concat(n,\"px \").concat(o,\"px 0);\\n            clip: rect(0, \").concat(n,\"px, \").concat(o,\"px, 0);\\n            -webkit-clip-path: polygon(0 0, 100% 0, 100% 100%, 0 100%);\\n            clip-path: polygon(0 0, 100% 0, 100% 100%, 0 100%);\\n        }\"),e.$clipStyles.styleSheet?e.$clipStyles.styleSheet.cssText=i:e.$clipStyles.innerHTML=i)}},{key:\"coverImage\",value:function(){var e=this,t=e.image.$container.getBoundingClientRect(),n=t.height,o=e.options.speed,i=\"scroll\"===e.options.type||\"scroll-opacity\"===e.options.type,a=0,r=n,l=0;return i&&(o<0?(a=o*Math.max(n,h),h<n&&(a-=o*(n-h))):a=o*(n+h),1<o?r=Math.abs(a-h):o<0?r=a/o+Math.abs(a):r+=(h-n)*(1-o),a/=2),e.parallaxScrollDistance=a,l=i?(h-r)/2:(n-r)/2,e.css(e.image.$item,{height:\"\".concat(r,\"px\"),marginTop:\"\".concat(l,\"px\"),left:\"fixed\"===e.image.position?\"\".concat(t.left,\"px\"):\"0\",width:\"\".concat(t.width,\"px\")}),e.options.onCoverImage&&e.options.onCoverImage.call(e),{image:{height:r,marginTop:l},container:t}}},{key:\"isVisible\",value:function(){return this.isElementInViewport||!1}},{key:\"onScroll\",value:function(e){var t,n,o,i,a,r,l,s,c,u,p=this,d=p.$item.getBoundingClientRect(),m=d.top,f=d.height,g={},y=d;p.options.elementInViewport&&(y=p.options.elementInViewport.getBoundingClientRect()),p.isElementInViewport=0<=y.bottom&&0<=y.right&&y.top<=h&&y.left<=b.window.innerWidth,(e||p.isElementInViewport)&&(t=Math.max(0,m),n=Math.max(0,f+m),o=Math.max(0,-m),i=Math.max(0,m+f-h),a=Math.max(0,f-(m+f-h)),r=Math.max(0,-m+h-f),l=1-(h-m)/(h+f)*2,s=1,f<h?s=1-(o||i)/f:n<=h?s=n/h:a<=h&&(s=a/h),\"opacity\"!==p.options.type&&\"scale-opacity\"!==p.options.type&&\"scroll-opacity\"!==p.options.type||(g.transform=\"translate3d(0,0,0)\",g.opacity=s),\"scale\"!==p.options.type&&\"scale-opacity\"!==p.options.type||(c=1,p.options.speed<0?c-=p.options.speed*s:c+=p.options.speed*(1-s),g.transform=\"scale(\".concat(c,\") translate3d(0,0,0)\")),\"scroll\"!==p.options.type&&\"scroll-opacity\"!==p.options.type||(u=p.parallaxScrollDistance*l,\"absolute\"===p.image.position&&(u-=m),g.transform=\"translate3d(0,\".concat(u,\"px,0)\")),p.css(p.image.$item,g),p.options.onScroll&&p.options.onScroll.call(p,{section:d,beforeTop:t,beforeTopEnd:n,afterTop:o,beforeBottom:i,beforeBottomEnd:a,afterBottom:r,visiblePercent:s,fromViewportCenter:l}))}},{key:\"onResize\",value:function(){this.coverImage(),this.clipContainer()}}])&&r(e.prototype,t),n&&r(e,n),s}();v.constructor=w,t.default=v}]);\n//# sourceMappingURL=jarallax.min.js.map\n","Magento_PageBuilder/js/resource/jquery/ui/jquery.ui.touch-punch.js":"/*!\n * jQuery UI Touch Punch 0.2.3\n *\n * Copyright 2011\u20132014, Dave Furfero\n * Dual licensed under the MIT or GPL Version 2 licenses.\n *\n * Depends:\n *  jquery.ui.widget.js\n *  jquery.ui.mouse.js\n */\n(function ($) {\n\n    // Detect touch support\n    $.support.touch = 'ontouchend' in document;\n\n    // Ignore browsers without touch support\n    if (!$.support.touch) {\n        return;\n    }\n\n    var mouseProto = $.ui.mouse.prototype,\n        _mouseInit = mouseProto._mouseInit,\n        _mouseDestroy = mouseProto._mouseDestroy,\n        touchHandled;\n\n    /**\n     * Simulate a mouse event based on a corresponding touch event\n     * @param {Object} event A touch event\n     * @param {String} simulatedType The corresponding mouse event\n     */\n    function simulateMouseEvent (event, simulatedType) {\n\n        // Ignore multi-touch events\n        if (event.originalEvent.touches.length > 1) {\n            return;\n        }\n\n        event.preventDefault();\n\n        var touch = event.originalEvent.changedTouches[0],\n            simulatedEvent = document.createEvent('MouseEvents');\n\n        // Initialize the simulated mouse event using the touch event's coordinates\n        simulatedEvent.initMouseEvent(\n            simulatedType,    // type\n            true,             // bubbles\n            true,             // cancelable\n            window,           // view\n            1,                // detail\n            touch.screenX,    // screenX\n            touch.screenY,    // screenY\n            touch.clientX,    // clientX\n            touch.clientY,    // clientY\n            false,            // ctrlKey\n            false,            // altKey\n            false,            // shiftKey\n            false,            // metaKey\n            0,                // button\n            null              // relatedTarget\n        );\n\n        // Dispatch the simulated event to the target element\n        event.target.dispatchEvent(simulatedEvent);\n    }\n\n    /**\n     * Handle the jQuery UI widget's touchstart events\n     * @param {Object} event The widget element's touchstart event\n     */\n    mouseProto._touchStart = function (event) {\n\n        var self = this;\n\n        // Ignore the event if another widget is already being handled\n        if (touchHandled || !self._mouseCapture(event.originalEvent.changedTouches[0])) {\n            return;\n        }\n\n        // Set the flag to prevent other widgets from inheriting the touch event\n        touchHandled = true;\n\n        // Track movement to determine if interaction was a click\n        self._touchMoved = false;\n\n        // Simulate the mouseover event\n        simulateMouseEvent(event, 'mouseover');\n\n        // Simulate the mousemove event\n        simulateMouseEvent(event, 'mousemove');\n\n        // Simulate the mousedown event\n        simulateMouseEvent(event, 'mousedown');\n    };\n\n    /**\n     * Handle the jQuery UI widget's touchmove events\n     * @param {Object} event The document's touchmove event\n     */\n    mouseProto._touchMove = function (event) {\n\n        // Ignore event if not handled\n        if (!touchHandled) {\n            return;\n        }\n\n        // Interaction was not a click\n        this._touchMoved = true;\n\n        // Simulate the mousemove event\n        simulateMouseEvent(event, 'mousemove');\n    };\n\n    /**\n     * Handle the jQuery UI widget's touchend events\n     * @param {Object} event The document's touchend event\n     */\n    mouseProto._touchEnd = function (event) {\n\n        // Ignore event if not handled\n        if (!touchHandled) {\n            return;\n        }\n\n        // Simulate the mouseup event\n        simulateMouseEvent(event, 'mouseup');\n\n        // Simulate the mouseout event\n        simulateMouseEvent(event, 'mouseout');\n\n        // If the touch interaction did not move, it should trigger a click\n        if (!this._touchMoved) {\n\n            // Simulate the click event\n            simulateMouseEvent(event, 'click');\n        }\n\n        // Unset the flag to allow other widgets to inherit the touch event\n        touchHandled = false;\n    };\n\n    /**\n     * A duck punch of the $.ui.mouse _mouseInit method to support touch events.\n     * This method extends the widget with bound touch event handlers that\n     * translate touch events to mouse events and pass them to the widget's\n     * original mouse event handling methods.\n     */\n    mouseProto._mouseInit = function () {\n\n        var self = this;\n\n        // Delegate the touch handlers to the widget's element\n        self.element.bind({\n            touchstart: $.proxy(self, '_touchStart'),\n            touchmove: $.proxy(self, '_touchMove'),\n            touchend: $.proxy(self, '_touchEnd')\n        });\n\n        // Call the original $.ui.mouse init method\n        _mouseInit.call(self);\n    };\n\n    /**\n     * Remove the touch event handlers\n     */\n    mouseProto._mouseDestroy = function () {\n\n        var self = this;\n\n        // Delegate the touch handlers to the widget's element\n        self.element.unbind({\n            touchstart: $.proxy(self, '_touchStart'),\n            touchmove: $.proxy(self, '_touchMove'),\n            touchend: $.proxy(self, '_touchEnd')\n        });\n\n        // Call the original $.ui.mouse destroy method\n        _mouseDestroy.call(self);\n    };\n\n})(jQuery);","Magento_PageBuilder/js/resource/jquery/ui/jquery.ui.touch-punch.min.js":"/*!\n * jQuery UI Touch Punch 0.2.3\n *\n * Copyright 2011\u20132014, Dave Furfero\n * Dual licensed under the MIT or GPL Version 2 licenses.\n *\n * Depends:\n *  jquery.ui.widget.js\n *  jquery.ui.mouse.js\n */\n!function(a){function f(a,b){if(!(a.originalEvent.touches.length>1)){a.preventDefault();var c=a.originalEvent.changedTouches[0],d=document.createEvent(\"MouseEvents\");d.initMouseEvent(b,!0,!0,window,1,c.screenX,c.screenY,c.clientX,c.clientY,!1,!1,!1,!1,0,null),a.target.dispatchEvent(d)}}if(a.support.touch=\"ontouchend\"in document,a.support.touch){var e,b=a.ui.mouse.prototype,c=b._mouseInit,d=b._mouseDestroy;b._touchStart=function(a){var b=this;!e&&b._mouseCapture(a.originalEvent.changedTouches[0])&&(e=!0,b._touchMoved=!1,f(a,\"mouseover\"),f(a,\"mousemove\"),f(a,\"mousedown\"))},b._touchMove=function(a){e&&(this._touchMoved=!0,f(a,\"mousemove\"))},b._touchEnd=function(a){e&&(f(a,\"mouseup\"),f(a,\"mouseout\"),this._touchMoved||f(a,\"click\"),e=!1)},b._mouseInit=function(){var b=this;b.element.bind({touchstart:a.proxy(b,\"_touchStart\"),touchmove:a.proxy(b,\"_touchMove\"),touchend:a.proxy(b,\"_touchEnd\")}),c.call(b)},b._mouseDestroy=function(){var b=this;b.element.unbind({touchstart:a.proxy(b,\"_touchStart\"),touchmove:a.proxy(b,\"_touchMove\"),touchend:a.proxy(b,\"_touchEnd\")}),d.call(b)}}}(jQuery);\n","Magento_PageBuilder/js/resource/vimeo/player.min.js":"/*! @vimeo/player v2.10.0 | (c) 2019 Vimeo | MIT License | https://github.com/vimeo/player.js */\n!function(e,t){\"object\"==typeof exports&&\"undefined\"!=typeof module?module.exports=t():\"function\"==typeof define&&define.amd?define(t):((e=e||self).Vimeo=e.Vimeo||{},e.Vimeo.Player=t())}(this,function(){\"use strict\";function r(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,\"value\"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}var e=\"undefined\"!=typeof global&&\"[object global]\"==={}.toString.call(global);function i(e,t){return 0===e.indexOf(t.toLowerCase())?e:\"\".concat(t.toLowerCase()).concat(e.substr(0,1).toUpperCase()).concat(e.substr(1))}function s(e){return/^(https?:)?\\/\\/((player|www)\\.)?vimeo\\.com(?=$|\\/)/.test(e)}function l(){var e,t=0<arguments.length&&void 0!==arguments[0]?arguments[0]:{},n=t.id,r=t.url,o=n||r;if(!o)throw new Error(\"An id or url must be passed, either in an options object or as a data-vimeo-id or data-vimeo-url attribute.\");if(e=o,!isNaN(parseFloat(e))&&isFinite(e)&&Math.floor(e)==e)return\"https://vimeo.com/\".concat(o);if(s(o))return o.replace(\"http:\",\"https:\");if(n)throw new TypeError(\"\u201c\".concat(n,\"\u201d is not a valid video id.\"));throw new TypeError(\"\u201c\".concat(o,\"\u201d is not a vimeo.com url.\"))}var t=void 0!==Array.prototype.indexOf,n=\"undefined\"!=typeof window&&void 0!==window.postMessage;if(!(e||t&&n))throw new Error(\"Sorry, the Vimeo Player API is not available in this browser.\");var o=\"undefined\"!=typeof window?window:\"undefined\"!=typeof global?global:\"undefined\"!=typeof self?self:{};!function(e){if(!e.WeakMap){var n=Object.prototype.hasOwnProperty,o=function(e,t,n){Object.defineProperty?Object.defineProperty(e,t,{configurable:!0,writable:!0,value:n}):e[t]=n};e.WeakMap=function(){function e(){if(void 0===this)throw new TypeError(\"Constructor WeakMap requires 'new'\");if(o(this,\"_id\",\"_WeakMap\"+\"_\"+t()+\".\"+t()),0<arguments.length)throw new TypeError(\"WeakMap iterable is not supported\")}function r(e,t){if(!i(e)||!n.call(e,\"_id\"))throw new TypeError(t+\" method called on incompatible receiver \"+typeof e)}function t(){return Math.random().toString().substring(2)}return o(e.prototype,\"delete\",function(e){if(r(this,\"delete\"),!i(e))return!1;var t=e[this._id];return!(!t||t[0]!==e)&&(delete e[this._id],!0)}),o(e.prototype,\"get\",function(e){if(r(this,\"get\"),i(e)){var t=e[this._id];return t&&t[0]===e?t[1]:void 0}}),o(e.prototype,\"has\",function(e){if(r(this,\"has\"),!i(e))return!1;var t=e[this._id];return!(!t||t[0]!==e)}),o(e.prototype,\"set\",function(e,t){if(r(this,\"set\"),!i(e))throw new TypeError(\"Invalid value used as weak map key\");var n=e[this._id];return n&&n[0]===e?n[1]=t:o(e,this._id,[e,t]),this}),o(e,\"_polyfill\",!0),e}()}function i(e){return Object(e)===e}}(\"undefined\"!=typeof self?self:\"undefined\"!=typeof window?window:o);var a,f=(function(e){var t,n,r;r=function(){var t,a,n,e=Object.prototype.toString,r=\"undefined\"!=typeof setImmediate?function(e){return setImmediate(e)}:setTimeout;try{Object.defineProperty({},\"x\",{}),t=function(e,t,n,r){return Object.defineProperty(e,t,{value:n,writable:!0,configurable:!1!==r})}}catch(e){t=function(e,t,n){return e[t]=n,e}}function i(e,t){n.add(e,t),a||(a=r(n.drain))}function u(e){var t,n=typeof e;return null==e||\"object\"!=n&&\"function\"!=n||(t=e.then),\"function\"==typeof t&&t}function c(){for(var e=0;e<this.chain.length;e++)o(this,1===this.state?this.chain[e].success:this.chain[e].failure,this.chain[e]);this.chain.length=0}function o(e,t,n){var r,o;try{!1===t?n.reject(e.msg):(r=!0===t?e.msg:t.call(void 0,e.msg))===n.promise?n.reject(TypeError(\"Promise-chain cycle\")):(o=u(r))?o.call(r,n.resolve,n.reject):n.resolve(r)}catch(e){n.reject(e)}}function s(e){var t=this;t.triggered||(t.triggered=!0,t.def&&(t=t.def),t.msg=e,t.state=2,0<t.chain.length&&i(c,t))}function l(e,n,r,o){for(var t=0;t<n.length;t++)!function(t){e.resolve(n[t]).then(function(e){r(t,e)},o)}(t)}function f(e){this.def=e,this.triggered=!1}function d(e){this.promise=e,this.state=0,this.triggered=!1,this.chain=[],this.msg=void 0}function h(e){if(\"function\"!=typeof e)throw TypeError(\"Not a function\");if(0!==this.__NPO__)throw TypeError(\"Not a promise\");this.__NPO__=1;var r=new d(this);this.then=function(e,t){var n={success:\"function\"!=typeof e||e,failure:\"function\"==typeof t&&t};return n.promise=new this.constructor(function(e,t){if(\"function\"!=typeof e||\"function\"!=typeof t)throw TypeError(\"Not a function\");n.resolve=e,n.reject=t}),r.chain.push(n),0!==r.state&&i(c,r),n.promise},this.catch=function(e){return this.then(void 0,e)};try{e.call(void 0,function(e){(function e(n){var r,o=this;if(!o.triggered){o.triggered=!0,o.def&&(o=o.def);try{(r=u(n))?i(function(){var t=new f(o);try{r.call(n,function(){e.apply(t,arguments)},function(){s.apply(t,arguments)})}catch(e){s.call(t,e)}}):(o.msg=n,o.state=1,0<o.chain.length&&i(c,o))}catch(e){s.call(new f(o),e)}}}).call(r,e)},function(e){s.call(r,e)})}catch(e){s.call(r,e)}}n=function(){var n,r,o;function i(e,t){this.fn=e,this.self=t,this.next=void 0}return{add:function(e,t){o=new i(e,t),r?r.next=o:n=o,r=o,o=void 0},drain:function(){var e=n;for(n=r=a=void 0;e;)e.fn.call(e.self),e=e.next}}}();var v=t({},\"constructor\",h,!1);return t(h.prototype=v,\"__NPO__\",0,!1),t(h,\"resolve\",function(n){return n&&\"object\"==typeof n&&1===n.__NPO__?n:new this(function(e,t){if(\"function\"!=typeof e||\"function\"!=typeof t)throw TypeError(\"Not a function\");e(n)})}),t(h,\"reject\",function(n){return new this(function(e,t){if(\"function\"!=typeof e||\"function\"!=typeof t)throw TypeError(\"Not a function\");t(n)})}),t(h,\"all\",function(t){var a=this;return\"[object Array]\"!=e.call(t)?a.reject(TypeError(\"Not an array\")):0===t.length?a.resolve([]):new a(function(n,e){if(\"function\"!=typeof n||\"function\"!=typeof e)throw TypeError(\"Not a function\");var r=t.length,o=Array(r),i=0;l(a,t,function(e,t){o[e]=t,++i===r&&n(o)},e)})}),t(h,\"race\",function(t){var r=this;return\"[object Array]\"!=e.call(t)?r.reject(TypeError(\"Not an array\")):new r(function(n,e){if(\"function\"!=typeof n||\"function\"!=typeof e)throw TypeError(\"Not a function\");l(r,t,function(e,t){n(t)},e)})}),h},(n=o)[t=\"Promise\"]=n[t]||r(),e.exports&&(e.exports=n[t])}(a={exports:{}},a.exports),a.exports),d=new WeakMap;function u(e,t,n){var r=d.get(e.element)||{};t in r||(r[t]=[]),r[t].push(n),d.set(e.element,r)}function c(e,t){return(d.get(e.element)||{})[t]||[]}function h(e,t,n){var r=d.get(e.element)||{};if(!r[t])return!0;if(!n)return r[t]=[],d.set(e.element,r),!0;var o=r[t].indexOf(n);return-1!==o&&r[t].splice(o,1),d.set(e.element,r),r[t]&&0===r[t].length}var v=[\"autopause\",\"autoplay\",\"background\",\"byline\",\"color\",\"controls\",\"dnt\",\"height\",\"id\",\"loop\",\"maxheight\",\"maxwidth\",\"muted\",\"playsinline\",\"portrait\",\"responsive\",\"speed\",\"texttrack\",\"title\",\"transparent\",\"url\",\"width\"];function p(r){var e=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{};return v.reduce(function(e,t){var n=r.getAttribute(\"data-vimeo-\".concat(t));return(n||\"\"===n)&&(e[t]=\"\"===n?1:n),e},e)}function y(e,t){var n=e.html;if(!t)throw new TypeError(\"An element must be provided\");if(null!==t.getAttribute(\"data-vimeo-initialized\"))return t.querySelector(\"iframe\");var r=document.createElement(\"div\");return r.innerHTML=n,t.appendChild(r.firstChild),t.setAttribute(\"data-vimeo-initialized\",\"true\"),t.querySelector(\"iframe\")}function m(i){var a=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},u=2<arguments.length?arguments[2]:void 0;return new Promise(function(t,n){if(!s(i))throw new TypeError(\"\u201c\".concat(i,\"\u201d is not a vimeo.com url.\"));var e=\"https://vimeo.com/api/oembed.json?url=\".concat(encodeURIComponent(i));for(var r in a)a.hasOwnProperty(r)&&(e+=\"&\".concat(r,\"=\").concat(encodeURIComponent(a[r])));var o=\"XDomainRequest\"in window?new XDomainRequest:new XMLHttpRequest;o.open(\"GET\",e,!0),o.onload=function(){if(404!==o.status)if(403!==o.status)try{var e=JSON.parse(o.responseText);if(403===e.domain_status_code)return y(e,u),void n(new Error(\"\u201c\".concat(i,\"\u201d is not embeddable.\")));t(e)}catch(e){n(e)}else n(new Error(\"\u201c\".concat(i,\"\u201d is not embeddable.\")));else n(new Error(\"\u201c\".concat(i,\"\u201d was not found.\")))},o.onerror=function(){var e=o.status?\" (\".concat(o.status,\")\"):\"\";n(new Error(\"There was an error fetching the embed code from Vimeo\".concat(e,\".\")))},o.send()})}function g(e){if(\"string\"==typeof e)try{e=JSON.parse(e)}catch(e){return console.warn(e),{}}return e}function w(e,t,n){if(e.element.contentWindow&&e.element.contentWindow.postMessage){var r={method:t};void 0!==n&&(r.value=n);var o=parseFloat(navigator.userAgent.toLowerCase().replace(/^.*msie (\\d+).*$/,\"$1\"));8<=o&&o<10&&(r=JSON.stringify(r)),e.element.contentWindow.postMessage(r,e.origin)}}function b(n,r){var t,e=[];if((r=g(r)).event){if(\"error\"===r.event)c(n,r.data.method).forEach(function(e){var t=new Error(r.data.message);t.name=r.data.name,e.reject(t),h(n,r.data.method,e)});e=c(n,\"event:\".concat(r.event)),t=r.data}else if(r.method){var o=function(e,t){var n=c(e,t);if(n.length<1)return!1;var r=n.shift();return h(e,t,r),r}(n,r.method);o&&(e.push(o),t=r.value)}e.forEach(function(e){try{if(\"function\"==typeof e)return void e.call(n,t);e.resolve(t)}catch(e){}})}var k=new WeakMap,E=new WeakMap,Player=function(){function Player(u){var e,c=this,n=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{};if(function(e,t){if(!(e instanceof t))throw new TypeError(\"Cannot call a class as a function\")}(this,Player),window.jQuery&&u instanceof jQuery&&(1<u.length&&window.console&&console.warn&&console.warn(\"A jQuery object with multiple elements was passed, using the first element.\"),u=u[0]),\"undefined\"!=typeof document&&\"string\"==typeof u&&(u=document.getElementById(u)),e=u,!Boolean(e&&1===e.nodeType&&\"nodeName\"in e&&e.ownerDocument&&e.ownerDocument.defaultView))throw new TypeError(\"You must pass either a valid element or a valid id.\");var r=u.ownerDocument.defaultView;if(\"IFRAME\"!==u.nodeName){var t=u.querySelector(\"iframe\");t&&(u=t)}if(\"IFRAME\"===u.nodeName&&!s(u.getAttribute(\"src\")||\"\"))throw new Error(\"The player element passed isn\u2019t a Vimeo embed.\");if(k.has(u))return k.get(u);this.element=u,this.origin=\"*\";var o=new f(function(i,a){var e=function(e){if(s(e.origin)&&c.element.contentWindow===e.source){\"*\"===c.origin&&(c.origin=e.origin);var t=g(e.data);if(t&&\"error\"===t.event&&t.data&&\"ready\"===t.data.method){var n=new Error(t.data.message);return n.name=t.data.name,void a(n)}var r=t&&\"ready\"===t.event,o=t&&\"ping\"===t.method;if(r||o)return c.element.setAttribute(\"data-ready\",\"true\"),void i();b(c,t)}};if(r.addEventListener?r.addEventListener(\"message\",e,!1):r.attachEvent&&r.attachEvent(\"onmessage\",e),\"IFRAME\"!==c.element.nodeName){var t=p(u,n);m(l(t),t,u).then(function(e){var t,n,r,o=y(e,u);return c.element=o,c._originalElement=u,t=u,n=o,r=d.get(t),d.set(n,r),d.delete(t),k.set(c.element,c),e}).catch(a)}});return E.set(this,o),k.set(this.element,this),\"IFRAME\"===this.element.nodeName&&w(this,\"ping\"),this}var e,t,n;return e=Player,(t=[{key:\"callMethod\",value:function(n){var r=this,o=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{};return new f(function(e,t){return r.ready().then(function(){u(r,n,{resolve:e,reject:t}),w(r,n,o)}).catch(t)})}},{key:\"get\",value:function(n){var r=this;return new f(function(e,t){return n=i(n,\"get\"),r.ready().then(function(){u(r,n,{resolve:e,reject:t}),w(r,n)}).catch(t)})}},{key:\"set\",value:function(n,r){var o=this;return new f(function(e,t){if(n=i(n,\"set\"),null==r)throw new TypeError(\"There must be a value to set.\");return o.ready().then(function(){u(o,n,{resolve:e,reject:t}),w(o,n,r)}).catch(t)})}},{key:\"on\",value:function(e,t){if(!e)throw new TypeError(\"You must pass an event name.\");if(!t)throw new TypeError(\"You must pass a callback function.\");if(\"function\"!=typeof t)throw new TypeError(\"The callback must be a function.\");0===c(this,\"event:\".concat(e)).length&&this.callMethod(\"addEventListener\",e).catch(function(){}),u(this,\"event:\".concat(e),t)}},{key:\"off\",value:function(e,t){if(!e)throw new TypeError(\"You must pass an event name.\");if(t&&\"function\"!=typeof t)throw new TypeError(\"The callback must be a function.\");h(this,\"event:\".concat(e),t)&&this.callMethod(\"removeEventListener\",e).catch(function(e){})}},{key:\"loadVideo\",value:function(e){return this.callMethod(\"loadVideo\",e)}},{key:\"ready\",value:function(){var e=E.get(this)||new f(function(e,t){t(new Error(\"Unknown player. Probably unloaded.\"))});return f.resolve(e)}},{key:\"addCuePoint\",value:function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{};return this.callMethod(\"addCuePoint\",{time:e,data:t})}},{key:\"removeCuePoint\",value:function(e){return this.callMethod(\"removeCuePoint\",e)}},{key:\"enableTextTrack\",value:function(e,t){if(!e)throw new TypeError(\"You must pass a language.\");return this.callMethod(\"enableTextTrack\",{language:e,kind:t})}},{key:\"disableTextTrack\",value:function(){return this.callMethod(\"disableTextTrack\")}},{key:\"pause\",value:function(){return this.callMethod(\"pause\")}},{key:\"play\",value:function(){return this.callMethod(\"play\")}},{key:\"unload\",value:function(){return this.callMethod(\"unload\")}},{key:\"destroy\",value:function(){var t=this;return new f(function(e){E.delete(t),k.delete(t.element),t._originalElement&&(k.delete(t._originalElement),t._originalElement.removeAttribute(\"data-vimeo-initialized\")),t.element&&\"IFRAME\"===t.element.nodeName&&t.element.parentNode&&t.element.parentNode.removeChild(t.element),e()})}},{key:\"getAutopause\",value:function(){return this.get(\"autopause\")}},{key:\"setAutopause\",value:function(e){return this.set(\"autopause\",e)}},{key:\"getBuffered\",value:function(){return this.get(\"buffered\")}},{key:\"getColor\",value:function(){return this.get(\"color\")}},{key:\"setColor\",value:function(e){return this.set(\"color\",e)}},{key:\"getCuePoints\",value:function(){return this.get(\"cuePoints\")}},{key:\"getCurrentTime\",value:function(){return this.get(\"currentTime\")}},{key:\"setCurrentTime\",value:function(e){return this.set(\"currentTime\",e)}},{key:\"getDuration\",value:function(){return this.get(\"duration\")}},{key:\"getEnded\",value:function(){return this.get(\"ended\")}},{key:\"getLoop\",value:function(){return this.get(\"loop\")}},{key:\"setLoop\",value:function(e){return this.set(\"loop\",e)}},{key:\"setMuted\",value:function(e){return this.set(\"muted\",e)}},{key:\"getMuted\",value:function(){return this.get(\"muted\")}},{key:\"getPaused\",value:function(){return this.get(\"paused\")}},{key:\"getPlaybackRate\",value:function(){return this.get(\"playbackRate\")}},{key:\"setPlaybackRate\",value:function(e){return this.set(\"playbackRate\",e)}},{key:\"getPlayed\",value:function(){return this.get(\"played\")}},{key:\"getSeekable\",value:function(){return this.get(\"seekable\")}},{key:\"getSeeking\",value:function(){return this.get(\"seeking\")}},{key:\"getTextTracks\",value:function(){return this.get(\"textTracks\")}},{key:\"getVideoEmbedCode\",value:function(){return this.get(\"videoEmbedCode\")}},{key:\"getVideoId\",value:function(){return this.get(\"videoId\")}},{key:\"getVideoTitle\",value:function(){return this.get(\"videoTitle\")}},{key:\"getVideoWidth\",value:function(){return this.get(\"videoWidth\")}},{key:\"getVideoHeight\",value:function(){return this.get(\"videoHeight\")}},{key:\"getVideoUrl\",value:function(){return this.get(\"videoUrl\")}},{key:\"getVolume\",value:function(){return this.get(\"volume\")}},{key:\"setVolume\",value:function(e){return this.set(\"volume\",e)}}])&&r(e.prototype,t),n&&r(e,n),Player}();return e||(function(){var e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:document,t=[].slice.call(e.querySelectorAll(\"[data-vimeo-id], [data-vimeo-url]\")),n=function(e){\"console\"in window&&console.error&&console.error(\"There was an error creating an embed: \".concat(e))};t.forEach(function(t){try{if(null!==t.getAttribute(\"data-vimeo-defer\"))return;var e=p(t);m(l(e),e,t).then(function(e){return y(e,t)}).catch(n)}catch(e){n(e)}})}(),function(){var r=0<arguments.length&&void 0!==arguments[0]?arguments[0]:document;if(!window.VimeoPlayerResizeEmbeds_){window.VimeoPlayerResizeEmbeds_=!0;var e=function(e){if(s(e.origin)&&e.data&&\"spacechange\"===e.data.event)for(var t=r.querySelectorAll(\"iframe\"),n=0;n<t.length;n++)if(t[n].contentWindow===e.source){t[n].parentElement.style.paddingBottom=\"\".concat(e.data.data[0].bottom,\"px\");break}};window.addEventListener?window.addEventListener(\"message\",e,!1):window.attachEvent&&window.attachEvent(\"onmessage\",e)}}()),Player});\n","Magento_PageBuilder/js/resource/vimeo/vimeo-wrapper.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'vimeo'\n], function (Player) {\n    'use strict';\n\n    window.Vimeo = window.Vimeo || {\n        'Player': Player\n    };\n});\n"}
}});
