require.config({"config": {
        "jsbuild":{"Magento_PageBuilder/js/resource/dropzone/dropzone.js":"// Uses AMD or browser globals to create a jQuery plugin.\n(function (factory) {\n    if (typeof define === 'function' && define.amd) {\n        // AMD. Register as an anonymous module.\n        define(['jquery'], factory);\n    } else {\n        // Browser globals\n        factory(jQuery);\n    }\n} (function (jQuery) {\n    var module = { exports: { } }; // Fake component\n\n\n    /*\n     *\n     * More info at [www.dropzonejs.com](http://www.dropzonejs.com)\n     *\n     * Copyright (c) 2012, Matias Meno\n     *\n     * Permission is hereby granted, free of charge, to any person obtaining a copy\n     * of this software and associated documentation files (the \"Software\"), to deal\n     * in the Software without restriction, including without limitation the rights\n     * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell\n     * copies of the Software, and to permit persons to whom the Software is\n     * furnished to do so, subject to the following conditions:\n     *\n     * The above copyright notice and this permission notice shall be included in\n     * all copies or substantial portions of the Software.\n     *\n     * THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n     * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n     * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n     * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n     * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,\n     * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN\n     * THE SOFTWARE.\n     *\n     */\n\n    (function() {\n        var Dropzone, Emitter, camelize, contentLoaded, detectVerticalSquash, drawImageIOSFix, noop, without,\n            __slice = [].slice,\n            __hasProp = {}.hasOwnProperty,\n            __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };\n\n        noop = function() {};\n\n        Emitter = (function() {\n            function Emitter() {}\n\n            Emitter.prototype.addEventListener = Emitter.prototype.on;\n\n            Emitter.prototype.on = function(event, fn) {\n                this._callbacks = this._callbacks || {};\n                if (!this._callbacks[event]) {\n                    this._callbacks[event] = [];\n                }\n                this._callbacks[event].push(fn);\n                return this;\n            };\n\n            Emitter.prototype.emit = function() {\n                var args, callback, callbacks, event, _i, _len;\n                event = arguments[0], args = 2 <= arguments.length ? __slice.call(arguments, 1) : [];\n                this._callbacks = this._callbacks || {};\n                callbacks = this._callbacks[event];\n                if (callbacks) {\n                    for (_i = 0, _len = callbacks.length; _i < _len; _i++) {\n                        callback = callbacks[_i];\n                        callback.apply(this, args);\n                    }\n                }\n                return this;\n            };\n\n            Emitter.prototype.removeListener = Emitter.prototype.off;\n\n            Emitter.prototype.removeAllListeners = Emitter.prototype.off;\n\n            Emitter.prototype.removeEventListener = Emitter.prototype.off;\n\n            Emitter.prototype.off = function(event, fn) {\n                var callback, callbacks, i, _i, _len;\n                if (!this._callbacks || arguments.length === 0) {\n                    this._callbacks = {};\n                    return this;\n                }\n                callbacks = this._callbacks[event];\n                if (!callbacks) {\n                    return this;\n                }\n                if (arguments.length === 1) {\n                    delete this._callbacks[event];\n                    return this;\n                }\n                for (i = _i = 0, _len = callbacks.length; _i < _len; i = ++_i) {\n                    callback = callbacks[i];\n                    if (callback === fn) {\n                        callbacks.splice(i, 1);\n                        break;\n                    }\n                }\n                return this;\n            };\n\n            return Emitter;\n\n        })();\n\n        Dropzone = (function(_super) {\n            var extend, resolveOption;\n\n            __extends(Dropzone, _super);\n\n            Dropzone.prototype.Emitter = Emitter;\n\n\n            /*\n             This is a list of all available events you can register on a dropzone object.\n\n             You can register an event handler like this:\n\n             dropzone.on(\"dragEnter\", function() { });\n             */\n\n            Dropzone.prototype.events = [\"drop\", \"dragstart\", \"dragend\", \"dragenter\", \"dragover\", \"dragleave\", \"addedfile\", \"addedfiles\", \"removedfile\", \"thumbnail\", \"error\", \"errormultiple\", \"processing\", \"processingmultiple\", \"uploadprogress\", \"totaluploadprogress\", \"sending\", \"sendingmultiple\", \"success\", \"successmultiple\", \"canceled\", \"canceledmultiple\", \"complete\", \"completemultiple\", \"reset\", \"maxfilesexceeded\", \"maxfilesreached\", \"queuecomplete\"];\n\n            Dropzone.prototype.defaultOptions = {\n                url: null,\n                method: \"post\",\n                withCredentials: false,\n                parallelUploads: 2,\n                uploadMultiple: false,\n                maxFilesize: 256,\n                paramName: \"file\",\n                createImageThumbnails: true,\n                maxThumbnailFilesize: 10,\n                thumbnailWidth: 120,\n                thumbnailHeight: 120,\n                filesizeBase: 1000,\n                maxFiles: null,\n                params: {},\n                clickable: true,\n                ignoreHiddenFiles: true,\n                acceptedFiles: null,\n                acceptedMimeTypes: null,\n                autoProcessQueue: true,\n                autoQueue: true,\n                addRemoveLinks: false,\n                previewsContainer: null,\n                hiddenInputContainer: \"body\",\n                capture: null,\n                dictDefaultMessage: \"Drop files here to upload\",\n                dictFallbackMessage: \"Your browser does not support drag'n'drop file uploads.\",\n                dictFallbackText: \"Please use the fallback form below to upload your files like in the olden days.\",\n                dictFileTooBig: \"File is too big ({{filesize}}MiB). Max filesize: {{maxFilesize}}MiB.\",\n                dictInvalidFileType: \"You can't upload files of this type.\",\n                dictResponseError: \"Server responded with {{statusCode}} code.\",\n                dictCancelUpload: \"Cancel upload\",\n                dictCancelUploadConfirmation: \"Are you sure you want to cancel this upload?\",\n                dictRemoveFile: \"Remove file\",\n                dictRemoveFileConfirmation: null,\n                dictMaxFilesExceeded: \"You can not upload any more files.\",\n                accept: function(file, done) {\n                    return done();\n                },\n                init: function() {\n                    return noop;\n                },\n                forceFallback: false,\n                fallback: function() {\n                    var child, messageElement, span, _i, _len, _ref;\n                    this.element.className = \"\" + this.element.className + \" dz-browser-not-supported\";\n                    _ref = this.element.getElementsByTagName(\"div\");\n                    for (_i = 0, _len = _ref.length; _i < _len; _i++) {\n                        child = _ref[_i];\n                        if (/(^| )dz-message($| )/.test(child.className)) {\n                            messageElement = child;\n                            child.className = \"dz-message\";\n                            continue;\n                        }\n                    }\n                    if (!messageElement) {\n                        messageElement = Dropzone.createElement(\"<div class=\\\"dz-message\\\"><span></span></div>\");\n                        this.element.appendChild(messageElement);\n                    }\n                    span = messageElement.getElementsByTagName(\"span\")[0];\n                    if (span) {\n                        if (span.textContent != null) {\n                            span.textContent = this.options.dictFallbackMessage;\n                        } else if (span.innerText != null) {\n                            span.innerText = this.options.dictFallbackMessage;\n                        }\n                    }\n                    return this.element.appendChild(this.getFallbackForm());\n                },\n                resize: function(file) {\n                    var info, srcRatio, trgRatio;\n                    info = {\n                        srcX: 0,\n                        srcY: 0,\n                        srcWidth: file.width,\n                        srcHeight: file.height\n                    };\n                    srcRatio = file.width / file.height;\n                    info.optWidth = this.options.thumbnailWidth;\n                    info.optHeight = this.options.thumbnailHeight;\n                    if ((info.optWidth == null) && (info.optHeight == null)) {\n                        info.optWidth = info.srcWidth;\n                        info.optHeight = info.srcHeight;\n                    } else if (info.optWidth == null) {\n                        info.optWidth = srcRatio * info.optHeight;\n                    } else if (info.optHeight == null) {\n                        info.optHeight = (1 / srcRatio) * info.optWidth;\n                    }\n                    trgRatio = info.optWidth / info.optHeight;\n                    if (file.height < info.optHeight || file.width < info.optWidth) {\n                        info.trgHeight = info.srcHeight;\n                        info.trgWidth = info.srcWidth;\n                    } else {\n                        if (srcRatio > trgRatio) {\n                            info.srcHeight = file.height;\n                            info.srcWidth = info.srcHeight * trgRatio;\n                        } else {\n                            info.srcWidth = file.width;\n                            info.srcHeight = info.srcWidth / trgRatio;\n                        }\n                    }\n                    info.srcX = (file.width - info.srcWidth) / 2;\n                    info.srcY = (file.height - info.srcHeight) / 2;\n                    return info;\n                },\n\n                /*\n                 Those functions register themselves to the events on init and handle all\n                 the user interface specific stuff. Overwriting them won't break the upload\n                 but can break the way it's displayed.\n                 You can overwrite them if you don't like the default behavior. If you just\n                 want to add an additional event handler, register it on the dropzone object\n                 and don't overwrite those options.\n                 */\n                drop: function(e) {\n                    return this.element.classList.remove(\"dz-drag-hover\");\n                },\n                dragstart: noop,\n                dragend: function(e) {\n                    return this.element.classList.remove(\"dz-drag-hover\");\n                },\n                dragenter: function(e) {\n                    return this.element.classList.add(\"dz-drag-hover\");\n                },\n                dragover: function(e) {\n                    return this.element.classList.add(\"dz-drag-hover\");\n                },\n                dragleave: function(e) {\n                    return this.element.classList.remove(\"dz-drag-hover\");\n                },\n                paste: noop,\n                reset: function() {\n                    return this.element.classList.remove(\"dz-started\");\n                },\n                addedfile: function(file) {\n                    var node, removeFileEvent, removeLink, _i, _j, _k, _len, _len1, _len2, _ref, _ref1, _ref2, _results;\n                    if (this.element === this.previewsContainer) {\n                        this.element.classList.add(\"dz-started\");\n                    }\n                    if (this.previewsContainer) {\n                        file.previewElement = Dropzone.createElement(this.options.template.trim());\n                        file.template = file.previewElement;\n                        this.previewsContainer.appendChild(file.previewElement);\n                        _ref = file.previewElement.querySelectorAll(\"[data-dz-name]\");\n                        for (_i = 0, _len = _ref.length; _i < _len; _i++) {\n                            node = _ref[_i];\n                            node.textContent = file.name;\n                        }\n                        _ref1 = file.previewElement.querySelectorAll(\"[data-dz-size]\");\n                        for (_j = 0, _len1 = _ref1.length; _j < _len1; _j++) {\n                            node = _ref1[_j];\n                            node.innerHTML = this.filesize(file.size);\n                        }\n                        if (this.options.addRemoveLinks) {\n                            file._removeLink = Dropzone.createElement(\"<a class=\\\"dz-remove\\\" href=\\\"javascript:undefined;\\\" data-dz-remove>\" + this.options.dictRemoveFile + \"</a>\");\n                            file.previewElement.appendChild(file._removeLink);\n                        }\n                        removeFileEvent = (function(_this) {\n                            return function(e) {\n                                e.preventDefault();\n                                e.stopPropagation();\n                                if (file.status === Dropzone.UPLOADING) {\n                                    return Dropzone.confirm(_this.options.dictCancelUploadConfirmation, function() {\n                                        return _this.removeFile(file);\n                                    });\n                                } else {\n                                    if (_this.options.dictRemoveFileConfirmation) {\n                                        return Dropzone.confirm(_this.options.dictRemoveFileConfirmation, function() {\n                                            return _this.removeFile(file);\n                                        });\n                                    } else {\n                                        return _this.removeFile(file);\n                                    }\n                                }\n                            };\n                        })(this);\n                        _ref2 = file.previewElement.querySelectorAll(\"[data-dz-remove]\");\n                        _results = [];\n                        for (_k = 0, _len2 = _ref2.length; _k < _len2; _k++) {\n                            removeLink = _ref2[_k];\n                            _results.push(removeLink.addEventListener(\"click\", removeFileEvent));\n                        }\n                        return _results;\n                    }\n                },\n                removedfile: function(file) {\n                    var _ref;\n                    if (file.previewElement) {\n                        if ((_ref = file.previewElement) != null) {\n                            _ref.parentNode.removeChild(file.previewElement);\n                        }\n                    }\n                    return this._updateMaxFilesReachedClass();\n                },\n                thumbnail: function(file, dataUrl) {\n                    var thumbnailElement, _i, _len, _ref;\n                    if (file.previewElement) {\n                        file.previewElement.classList.remove(\"dz-file-preview\");\n                        _ref = file.previewElement.querySelectorAll(\"[data-dz-thumbnail]\");\n                        for (_i = 0, _len = _ref.length; _i < _len; _i++) {\n                            thumbnailElement = _ref[_i];\n                            thumbnailElement.alt = file.name;\n                            thumbnailElement.src = dataUrl;\n                        }\n                        return setTimeout(((function(_this) {\n                            return function() {\n                                return file.previewElement.classList.add(\"dz-image-preview\");\n                            };\n                        })(this)), 1);\n                    }\n                },\n                error: function(file, message) {\n                    var node, _i, _len, _ref, _results;\n                    if (file.previewElement) {\n                        file.previewElement.classList.add(\"dz-error\");\n                        if (typeof message !== \"String\" && message.error) {\n                            message = message.error;\n                        }\n                        _ref = file.previewElement.querySelectorAll(\"[data-dz-errormessage]\");\n                        _results = [];\n                        for (_i = 0, _len = _ref.length; _i < _len; _i++) {\n                            node = _ref[_i];\n                            _results.push(node.textContent = message);\n                        }\n                        return _results;\n                    }\n                },\n                errormultiple: noop,\n                processing: function(file) {\n                    if (file.previewElement) {\n                        file.previewElement.classList.add(\"dz-processing\");\n                        if (file._removeLink) {\n                            return file._removeLink.textContent = this.options.dictCancelUpload;\n                        }\n                    }\n                },\n                processingmultiple: noop,\n                uploadprogress: function(file, progress, bytesSent) {\n                    var node, _i, _len, _ref, _results;\n                    if (file.previewElement) {\n                        _ref = file.previewElement.querySelectorAll(\"[data-dz-uploadprogress]\");\n                        _results = [];\n                        for (_i = 0, _len = _ref.length; _i < _len; _i++) {\n                            node = _ref[_i];\n                            if (node.nodeName === 'PROGRESS') {\n                                _results.push(node.value = progress);\n                            } else {\n                                _results.push(node.style.width = \"\" + progress + \"%\");\n                            }\n                        }\n                        return _results;\n                    }\n                },\n                totaluploadprogress: noop,\n                sending: noop,\n                sendingmultiple: noop,\n                success: function(file) {\n                    if (file.previewElement) {\n                        return file.previewElement.classList.add(\"dz-success\");\n                    }\n                },\n                successmultiple: noop,\n                canceled: function(file) {\n                    return this.emit(\"error\", file, \"Upload canceled.\");\n                },\n                canceledmultiple: noop,\n                complete: function(file) {\n                    if (file._removeLink) {\n                        file._removeLink.textContent = this.options.dictRemoveFile;\n                    }\n                    if (file.previewElement) {\n                        return file.previewElement.classList.add(\"dz-complete\");\n                    }\n                },\n                completemultiple: noop,\n                maxfilesexceeded: noop,\n                maxfilesreached: noop,\n                queuecomplete: noop,\n                addedfiles: noop,\n                template: \"<div class=\\\"dz-preview dz-file-preview\\\">\\n  <div class=\\\"dz-image\\\"><img data-dz-thumbnail /></div>\\n  <div class=\\\"dz-details\\\">\\n    <div class=\\\"dz-size\\\"><span data-dz-size></span></div>\\n    <div class=\\\"dz-filename\\\"><span data-dz-name></span></div>\\n  </div>\\n  <div class=\\\"dz-progress\\\"><span class=\\\"dz-upload\\\" data-dz-uploadprogress></span></div>\\n  <div class=\\\"dz-error-message\\\"><span data-dz-errormessage></span></div>\\n  <div class=\\\"dz-success-mark\\\">\\n    <svg width=\\\"54px\\\" height=\\\"54px\\\" viewBox=\\\"0 0 54 54\\\" version=\\\"1.1\\\" xmlns=\\\"http://www.w3.org/2000/svg\\\" xmlns:xlink=\\\"http://www.w3.org/1999/xlink\\\" xmlns:sketch=\\\"http://www.bohemiancoding.com/sketch/ns\\\">\\n      <title>Check</title>\\n      <defs></defs>\\n      <g id=\\\"Page-1\\\" stroke=\\\"none\\\" stroke-width=\\\"1\\\" fill=\\\"none\\\" fill-rule=\\\"evenodd\\\" sketch:type=\\\"MSPage\\\">\\n        <path d=\\\"M23.5,31.8431458 L17.5852419,25.9283877 C16.0248253,24.3679711 13.4910294,24.366835 11.9289322,25.9289322 C10.3700136,27.4878508 10.3665912,30.0234455 11.9283877,31.5852419 L20.4147581,40.0716123 C20.5133999,40.1702541 20.6159315,40.2626649 20.7218615,40.3488435 C22.2835669,41.8725651 24.794234,41.8626202 26.3461564,40.3106978 L43.3106978,23.3461564 C44.8771021,21.7797521 44.8758057,19.2483887 43.3137085,17.6862915 C41.7547899,16.1273729 39.2176035,16.1255422 37.6538436,17.6893022 L23.5,31.8431458 Z M27,53 C41.3594035,53 53,41.3594035 53,27 C53,12.6405965 41.3594035,1 27,1 C12.6405965,1 1,12.6405965 1,27 C1,41.3594035 12.6405965,53 27,53 Z\\\" id=\\\"Oval-2\\\" stroke-opacity=\\\"0.198794158\\\" stroke=\\\"#747474\\\" fill-opacity=\\\"0.816519475\\\" fill=\\\"#FFFFFF\\\" sketch:type=\\\"MSShapeGroup\\\"></path>\\n      </g>\\n    </svg>\\n  </div>\\n  <div class=\\\"dz-error-mark\\\">\\n    <svg width=\\\"54px\\\" height=\\\"54px\\\" viewBox=\\\"0 0 54 54\\\" version=\\\"1.1\\\" xmlns=\\\"http://www.w3.org/2000/svg\\\" xmlns:xlink=\\\"http://www.w3.org/1999/xlink\\\" xmlns:sketch=\\\"http://www.bohemiancoding.com/sketch/ns\\\">\\n      <title>Error</title>\\n      <defs></defs>\\n      <g id=\\\"Page-1\\\" stroke=\\\"none\\\" stroke-width=\\\"1\\\" fill=\\\"none\\\" fill-rule=\\\"evenodd\\\" sketch:type=\\\"MSPage\\\">\\n        <g id=\\\"Check-+-Oval-2\\\" sketch:type=\\\"MSLayerGroup\\\" stroke=\\\"#747474\\\" stroke-opacity=\\\"0.198794158\\\" fill=\\\"#FFFFFF\\\" fill-opacity=\\\"0.816519475\\\">\\n          <path d=\\\"M32.6568542,29 L38.3106978,23.3461564 C39.8771021,21.7797521 39.8758057,19.2483887 38.3137085,17.6862915 C36.7547899,16.1273729 34.2176035,16.1255422 32.6538436,17.6893022 L27,23.3431458 L21.3461564,17.6893022 C19.7823965,16.1255422 17.2452101,16.1273729 15.6862915,17.6862915 C14.1241943,19.2483887 14.1228979,21.7797521 15.6893022,23.3461564 L21.3431458,29 L15.6893022,34.6538436 C14.1228979,36.2202479 14.1241943,38.7516113 15.6862915,40.3137085 C17.2452101,41.8726271 19.7823965,41.8744578 21.3461564,40.3106978 L27,34.6568542 L32.6538436,40.3106978 C34.2176035,41.8744578 36.7547899,41.8726271 38.3137085,40.3137085 C39.8758057,38.7516113 39.8771021,36.2202479 38.3106978,34.6538436 L32.6568542,29 Z M27,53 C41.3594035,53 53,41.3594035 53,27 C53,12.6405965 41.3594035,1 27,1 C12.6405965,1 1,12.6405965 1,27 C1,41.3594035 12.6405965,53 27,53 Z\\\" id=\\\"Oval-2\\\" sketch:type=\\\"MSShapeGroup\\\"></path>\\n        </g>\\n      </g>\\n    </svg>\\n  </div>\\n</div>\"\n            };\n\n            extend = function() {\n                var key, object, objects, target, val, _i, _len;\n                target = arguments[0], objects = 2 <= arguments.length ? __slice.call(arguments, 1) : [];\n                for (_i = 0, _len = objects.length; _i < _len; _i++) {\n                    object = objects[_i];\n                    for (key in object) {\n                        val = object[key];\n                        target[key] = val;\n                    }\n                }\n                return target;\n            };\n\n            function Dropzone(element, options) {\n                var elementOptions, fallback, _ref;\n                this.element = element;\n                this.version = Dropzone.version;\n                this.defaultOptions.template = this.defaultOptions.template.replace(/\\n*/g, \"\");\n                this.clickableElements = [];\n                this.listeners = [];\n                this.files = [];\n                if (typeof this.element === \"string\") {\n                    this.element = document.querySelector(this.element);\n                }\n                if (!(this.element && (this.element.nodeType != null))) {\n                    throw new Error(\"Invalid dropzone element.\");\n                }\n                if (this.element.dropzone) {\n                    throw new Error(\"Dropzone already attached.\");\n                }\n                Dropzone.instances.push(this);\n                this.element.dropzone = this;\n                elementOptions = (_ref = Dropzone.optionsForElement(this.element)) != null ? _ref : {};\n                this.options = extend({}, this.defaultOptions, elementOptions, options != null ? options : {});\n                if (this.options.forceFallback || !Dropzone.isBrowserSupported()) {\n                    return this.options.fallback.call(this);\n                }\n                if (this.options.url == null) {\n                    this.options.url = this.element.getAttribute(\"action\");\n                }\n                if (!this.options.url) {\n                    throw new Error(\"No URL provided.\");\n                }\n                if (this.options.acceptedFiles && this.options.acceptedMimeTypes) {\n                    throw new Error(\"You can't provide both 'acceptedFiles' and 'acceptedMimeTypes'. 'acceptedMimeTypes' is deprecated.\");\n                }\n                if (this.options.acceptedMimeTypes) {\n                    this.options.acceptedFiles = this.options.acceptedMimeTypes;\n                    delete this.options.acceptedMimeTypes;\n                }\n                this.options.method = this.options.method.toUpperCase();\n                if ((fallback = this.getExistingFallback()) && fallback.parentNode) {\n                    fallback.parentNode.removeChild(fallback);\n                }\n                if (this.options.previewsContainer !== false) {\n                    if (this.options.previewsContainer) {\n                        this.previewsContainer = Dropzone.getElement(this.options.previewsContainer, \"previewsContainer\");\n                    } else {\n                        this.previewsContainer = this.element;\n                    }\n                }\n                if (this.options.clickable) {\n                    if (this.options.clickable === true) {\n                        this.clickableElements = [this.element];\n                    } else {\n                        this.clickableElements = Dropzone.getElements(this.options.clickable, \"clickable\");\n                    }\n                }\n                this.init();\n            }\n\n            Dropzone.prototype.getAcceptedFiles = function() {\n                var file, _i, _len, _ref, _results;\n                _ref = this.files;\n                _results = [];\n                for (_i = 0, _len = _ref.length; _i < _len; _i++) {\n                    file = _ref[_i];\n                    if (file.accepted) {\n                        _results.push(file);\n                    }\n                }\n                return _results;\n            };\n\n            Dropzone.prototype.getRejectedFiles = function() {\n                var file, _i, _len, _ref, _results;\n                _ref = this.files;\n                _results = [];\n                for (_i = 0, _len = _ref.length; _i < _len; _i++) {\n                    file = _ref[_i];\n                    if (!file.accepted) {\n                        _results.push(file);\n                    }\n                }\n                return _results;\n            };\n\n            Dropzone.prototype.getFilesWithStatus = function(status) {\n                var file, _i, _len, _ref, _results;\n                _ref = this.files;\n                _results = [];\n                for (_i = 0, _len = _ref.length; _i < _len; _i++) {\n                    file = _ref[_i];\n                    if (file.status === status) {\n                        _results.push(file);\n                    }\n                }\n                return _results;\n            };\n\n            Dropzone.prototype.getQueuedFiles = function() {\n                return this.getFilesWithStatus(Dropzone.QUEUED);\n            };\n\n            Dropzone.prototype.getUploadingFiles = function() {\n                return this.getFilesWithStatus(Dropzone.UPLOADING);\n            };\n\n            Dropzone.prototype.getAddedFiles = function() {\n                return this.getFilesWithStatus(Dropzone.ADDED);\n            };\n\n            Dropzone.prototype.getActiveFiles = function() {\n                var file, _i, _len, _ref, _results;\n                _ref = this.files;\n                _results = [];\n                for (_i = 0, _len = _ref.length; _i < _len; _i++) {\n                    file = _ref[_i];\n                    if (file.status === Dropzone.UPLOADING || file.status === Dropzone.QUEUED) {\n                        _results.push(file);\n                    }\n                }\n                return _results;\n            };\n\n            Dropzone.prototype.init = function() {\n                var eventName, noPropagation, setupHiddenFileInput, _i, _len, _ref, _ref1;\n                if (this.element.tagName === \"form\") {\n                    this.element.setAttribute(\"enctype\", \"multipart/form-data\");\n                }\n                if (this.element.classList.contains(\"dropzone\") && !this.element.querySelector(\".dz-message\")) {\n                    this.element.appendChild(Dropzone.createElement(\"<div class=\\\"dz-default dz-message\\\"><span>\" + this.options.dictDefaultMessage + \"</span></div>\"));\n                }\n                if (this.clickableElements.length) {\n                    setupHiddenFileInput = (function(_this) {\n                        return function() {\n                            if (_this.hiddenFileInput) {\n                                _this.hiddenFileInput.parentNode.removeChild(_this.hiddenFileInput);\n                            }\n                            _this.hiddenFileInput = document.createElement(\"input\");\n                            _this.hiddenFileInput.setAttribute(\"type\", \"file\");\n                            if ((_this.options.maxFiles == null) || _this.options.maxFiles > 1) {\n                                _this.hiddenFileInput.setAttribute(\"multiple\", \"multiple\");\n                            }\n                            _this.hiddenFileInput.className = \"dz-hidden-input\";\n                            if (_this.options.acceptedFiles != null) {\n                                _this.hiddenFileInput.setAttribute(\"accept\", _this.options.acceptedFiles);\n                            }\n                            if (_this.options.capture != null) {\n                                _this.hiddenFileInput.setAttribute(\"capture\", _this.options.capture);\n                            }\n                            _this.hiddenFileInput.style.visibility = \"hidden\";\n                            _this.hiddenFileInput.style.position = \"absolute\";\n                            _this.hiddenFileInput.style.top = \"0\";\n                            _this.hiddenFileInput.style.left = \"0\";\n                            _this.hiddenFileInput.style.height = \"0\";\n                            _this.hiddenFileInput.style.width = \"0\";\n                            document.querySelector(_this.options.hiddenInputContainer).appendChild(_this.hiddenFileInput);\n                            return _this.hiddenFileInput.addEventListener(\"change\", function() {\n                                var file, files, _i, _len;\n                                files = _this.hiddenFileInput.files;\n                                if (files.length) {\n                                    for (_i = 0, _len = files.length; _i < _len; _i++) {\n                                        file = files[_i];\n                                        _this.addFile(file);\n                                    }\n                                }\n                                _this.emit(\"addedfiles\", files);\n                                return setupHiddenFileInput();\n                            });\n                        };\n                    })(this);\n                    setupHiddenFileInput();\n                }\n                this.URL = (_ref = window.URL) != null ? _ref : window.webkitURL;\n                _ref1 = this.events;\n                for (_i = 0, _len = _ref1.length; _i < _len; _i++) {\n                    eventName = _ref1[_i];\n                    this.on(eventName, this.options[eventName]);\n                }\n                this.on(\"uploadprogress\", (function(_this) {\n                    return function() {\n                        return _this.updateTotalUploadProgress();\n                    };\n                })(this));\n                this.on(\"removedfile\", (function(_this) {\n                    return function() {\n                        return _this.updateTotalUploadProgress();\n                    };\n                })(this));\n                this.on(\"canceled\", (function(_this) {\n                    return function(file) {\n                        return _this.emit(\"complete\", file);\n                    };\n                })(this));\n                this.on(\"complete\", (function(_this) {\n                    return function(file) {\n                        if (_this.getAddedFiles().length === 0 && _this.getUploadingFiles().length === 0 && _this.getQueuedFiles().length === 0) {\n                            return setTimeout((function() {\n                                return _this.emit(\"queuecomplete\");\n                            }), 0);\n                        }\n                    };\n                })(this));\n                noPropagation = function(e) {\n                    e.stopPropagation();\n                    if (e.preventDefault) {\n                        return e.preventDefault();\n                    } else {\n                        return e.returnValue = false;\n                    }\n                };\n                this.listeners = [\n                    {\n                        element: this.element,\n                        events: {\n                            \"dragstart\": (function(_this) {\n                                return function(e) {\n                                    return _this.emit(\"dragstart\", e);\n                                };\n                            })(this),\n                            \"dragenter\": (function(_this) {\n                                return function(e) {\n                                    noPropagation(e);\n                                    return _this.emit(\"dragenter\", e);\n                                };\n                            })(this),\n                            \"dragover\": (function(_this) {\n                                return function(e) {\n                                    var efct;\n                                    try {\n                                        efct = e.dataTransfer.effectAllowed;\n                                    } catch (_error) {}\n                                    e.dataTransfer.dropEffect = 'move' === efct || 'linkMove' === efct ? 'move' : 'copy';\n                                    noPropagation(e);\n                                    return _this.emit(\"dragover\", e);\n                                };\n                            })(this),\n                            \"dragleave\": (function(_this) {\n                                return function(e) {\n                                    return _this.emit(\"dragleave\", e);\n                                };\n                            })(this),\n                            \"drop\": (function(_this) {\n                                return function(e) {\n                                    noPropagation(e);\n                                    return _this.drop(e);\n                                };\n                            })(this),\n                            \"dragend\": (function(_this) {\n                                return function(e) {\n                                    return _this.emit(\"dragend\", e);\n                                };\n                            })(this)\n                        }\n                    }\n                ];\n                this.clickableElements.forEach((function(_this) {\n                    return function(clickableElement) {\n                        return _this.listeners.push({\n                            element: clickableElement,\n                            events: {\n                                \"click\": function(evt) {\n                                    if ((clickableElement !== _this.element) || (evt.target === _this.element || Dropzone.elementInside(evt.target, _this.element.querySelector(\".dz-message\")))) {\n                                        _this.hiddenFileInput.click();\n                                    }\n                                    return true;\n                                }\n                            }\n                        });\n                    };\n                })(this));\n                this.enable();\n                return this.options.init.call(this);\n            };\n\n            Dropzone.prototype.destroy = function() {\n                var _ref;\n                this.disable();\n                this.removeAllFiles(true);\n                if ((_ref = this.hiddenFileInput) != null ? _ref.parentNode : void 0) {\n                    this.hiddenFileInput.parentNode.removeChild(this.hiddenFileInput);\n                    this.hiddenFileInput = null;\n                }\n                delete this.element.dropzone;\n                return Dropzone.instances.splice(Dropzone.instances.indexOf(this), 1);\n            };\n\n            Dropzone.prototype.updateTotalUploadProgress = function() {\n                var activeFiles, file, totalBytes, totalBytesSent, totalUploadProgress, _i, _len, _ref;\n                totalBytesSent = 0;\n                totalBytes = 0;\n                activeFiles = this.getActiveFiles();\n                if (activeFiles.length) {\n                    _ref = this.getActiveFiles();\n                    for (_i = 0, _len = _ref.length; _i < _len; _i++) {\n                        file = _ref[_i];\n                        totalBytesSent += file.upload.bytesSent;\n                        totalBytes += file.upload.total;\n                    }\n                    totalUploadProgress = 100 * totalBytesSent / totalBytes;\n                } else {\n                    totalUploadProgress = 100;\n                }\n                return this.emit(\"totaluploadprogress\", totalUploadProgress, totalBytes, totalBytesSent);\n            };\n\n            Dropzone.prototype._getParamName = function(n) {\n                if (typeof this.options.paramName === \"function\") {\n                    return this.options.paramName(n);\n                } else {\n                    return \"\" + this.options.paramName + (this.options.uploadMultiple ? \"[\" + n + \"]\" : \"\");\n                }\n            };\n\n            Dropzone.prototype.getFallbackForm = function() {\n                var existingFallback, fields, fieldsString, form;\n                if (existingFallback = this.getExistingFallback()) {\n                    return existingFallback;\n                }\n                fieldsString = \"<div class=\\\"dz-fallback\\\">\";\n                if (this.options.dictFallbackText) {\n                    fieldsString += \"<p>\" + this.options.dictFallbackText + \"</p>\";\n                }\n                fieldsString += \"<input type=\\\"file\\\" name=\\\"\" + (this._getParamName(0)) + \"\\\" \" + (this.options.uploadMultiple ? 'multiple=\"multiple\"' : void 0) + \" /><input type=\\\"submit\\\" value=\\\"Upload!\\\"></div>\";\n                fields = Dropzone.createElement(fieldsString);\n                if (this.element.tagName !== \"FORM\") {\n                    form = Dropzone.createElement(\"<form action=\\\"\" + this.options.url + \"\\\" enctype=\\\"multipart/form-data\\\" method=\\\"\" + this.options.method + \"\\\"></form>\");\n                    form.appendChild(fields);\n                } else {\n                    this.element.setAttribute(\"enctype\", \"multipart/form-data\");\n                    this.element.setAttribute(\"method\", this.options.method);\n                }\n                return form != null ? form : fields;\n            };\n\n            Dropzone.prototype.getExistingFallback = function() {\n                var fallback, getFallback, tagName, _i, _len, _ref;\n                getFallback = function(elements) {\n                    var el, _i, _len;\n                    for (_i = 0, _len = elements.length; _i < _len; _i++) {\n                        el = elements[_i];\n                        if (/(^| )fallback($| )/.test(el.className)) {\n                            return el;\n                        }\n                    }\n                };\n                _ref = [\"div\", \"form\"];\n                for (_i = 0, _len = _ref.length; _i < _len; _i++) {\n                    tagName = _ref[_i];\n                    if (fallback = getFallback(this.element.getElementsByTagName(tagName))) {\n                        return fallback;\n                    }\n                }\n            };\n\n            Dropzone.prototype.setupEventListeners = function() {\n                var elementListeners, event, listener, _i, _len, _ref, _results;\n                _ref = this.listeners;\n                _results = [];\n                for (_i = 0, _len = _ref.length; _i < _len; _i++) {\n                    elementListeners = _ref[_i];\n                    _results.push((function() {\n                        var _ref1, _results1;\n                        _ref1 = elementListeners.events;\n                        _results1 = [];\n                        for (event in _ref1) {\n                            listener = _ref1[event];\n                            _results1.push(elementListeners.element.addEventListener(event, listener, false));\n                        }\n                        return _results1;\n                    })());\n                }\n                return _results;\n            };\n\n            Dropzone.prototype.removeEventListeners = function() {\n                var elementListeners, event, listener, _i, _len, _ref, _results;\n                _ref = this.listeners;\n                _results = [];\n                for (_i = 0, _len = _ref.length; _i < _len; _i++) {\n                    elementListeners = _ref[_i];\n                    _results.push((function() {\n                        var _ref1, _results1;\n                        _ref1 = elementListeners.events;\n                        _results1 = [];\n                        for (event in _ref1) {\n                            listener = _ref1[event];\n                            _results1.push(elementListeners.element.removeEventListener(event, listener, false));\n                        }\n                        return _results1;\n                    })());\n                }\n                return _results;\n            };\n\n            Dropzone.prototype.disable = function() {\n                var file, _i, _len, _ref, _results;\n                this.clickableElements.forEach(function(element) {\n                    return element.classList.remove(\"dz-clickable\");\n                });\n                this.removeEventListeners();\n                _ref = this.files;\n                _results = [];\n                for (_i = 0, _len = _ref.length; _i < _len; _i++) {\n                    file = _ref[_i];\n                    _results.push(this.cancelUpload(file));\n                }\n                return _results;\n            };\n\n            Dropzone.prototype.enable = function() {\n                this.clickableElements.forEach(function(element) {\n                    return element.classList.add(\"dz-clickable\");\n                });\n                return this.setupEventListeners();\n            };\n\n            Dropzone.prototype.filesize = function(size) {\n                var cutoff, i, selectedSize, selectedUnit, unit, units, _i, _len;\n                selectedSize = 0;\n                selectedUnit = \"b\";\n                if (size > 0) {\n                    units = ['TB', 'GB', 'MB', 'KB', 'b'];\n                    for (i = _i = 0, _len = units.length; _i < _len; i = ++_i) {\n                        unit = units[i];\n                        cutoff = Math.pow(this.options.filesizeBase, 4 - i) / 10;\n                        if (size >= cutoff) {\n                            selectedSize = size / Math.pow(this.options.filesizeBase, 4 - i);\n                            selectedUnit = unit;\n                            break;\n                        }\n                    }\n                    selectedSize = Math.round(10 * selectedSize) / 10;\n                }\n                return \"<strong>\" + selectedSize + \"</strong> \" + selectedUnit;\n            };\n\n            Dropzone.prototype._updateMaxFilesReachedClass = function() {\n                if ((this.options.maxFiles != null) && this.getAcceptedFiles().length >= this.options.maxFiles) {\n                    if (this.getAcceptedFiles().length === this.options.maxFiles) {\n                        this.emit('maxfilesreached', this.files);\n                    }\n                    return this.element.classList.add(\"dz-max-files-reached\");\n                } else {\n                    return this.element.classList.remove(\"dz-max-files-reached\");\n                }\n            };\n\n            Dropzone.prototype.drop = function(e) {\n                var files, items;\n                if (!e.dataTransfer) {\n                    return;\n                }\n                this.emit(\"drop\", e);\n                files = e.dataTransfer.files;\n                this.emit(\"addedfiles\", files);\n                if (files.length) {\n                    items = e.dataTransfer.items;\n                    if (items && items.length && (items[0].webkitGetAsEntry != null)) {\n                        this._addFilesFromItems(items);\n                    } else {\n                        this.handleFiles(files);\n                    }\n                }\n            };\n\n            Dropzone.prototype.paste = function(e) {\n                var items, _ref;\n                if ((e != null ? (_ref = e.clipboardData) != null ? _ref.items : void 0 : void 0) == null) {\n                    return;\n                }\n                this.emit(\"paste\", e);\n                items = e.clipboardData.items;\n                if (items.length) {\n                    return this._addFilesFromItems(items);\n                }\n            };\n\n            Dropzone.prototype.handleFiles = function(files) {\n                var file, _i, _len, _results;\n                _results = [];\n                for (_i = 0, _len = files.length; _i < _len; _i++) {\n                    file = files[_i];\n                    _results.push(this.addFile(file));\n                }\n                return _results;\n            };\n\n            Dropzone.prototype._addFilesFromItems = function(items) {\n                var entry, item, _i, _len, _results;\n                _results = [];\n                for (_i = 0, _len = items.length; _i < _len; _i++) {\n                    item = items[_i];\n                    if ((item.webkitGetAsEntry != null) && (entry = item.webkitGetAsEntry())) {\n                        if (entry.isFile) {\n                            _results.push(this.addFile(item.getAsFile()));\n                        } else if (entry.isDirectory) {\n                            _results.push(this._addFilesFromDirectory(entry, entry.name));\n                        } else {\n                            _results.push(void 0);\n                        }\n                    } else if (item.getAsFile != null) {\n                        if ((item.kind == null) || item.kind === \"file\") {\n                            _results.push(this.addFile(item.getAsFile()));\n                        } else {\n                            _results.push(void 0);\n                        }\n                    } else {\n                        _results.push(void 0);\n                    }\n                }\n                return _results;\n            };\n\n            Dropzone.prototype._addFilesFromDirectory = function(directory, path) {\n                var dirReader, entriesReader;\n                dirReader = directory.createReader();\n                entriesReader = (function(_this) {\n                    return function(entries) {\n                        var entry, _i, _len;\n                        for (_i = 0, _len = entries.length; _i < _len; _i++) {\n                            entry = entries[_i];\n                            if (entry.isFile) {\n                                entry.file(function(file) {\n                                    if (_this.options.ignoreHiddenFiles && file.name.substring(0, 1) === '.') {\n                                        return;\n                                    }\n                                    file.fullPath = \"\" + path + \"/\" + file.name;\n                                    return _this.addFile(file);\n                                });\n                            } else if (entry.isDirectory) {\n                                _this._addFilesFromDirectory(entry, \"\" + path + \"/\" + entry.name);\n                            }\n                        }\n                    };\n                })(this);\n                return dirReader.readEntries(entriesReader, function(error) {\n                    return typeof console !== \"undefined\" && console !== null ? typeof console.log === \"function\" ? console.log(error) : void 0 : void 0;\n                });\n            };\n\n            Dropzone.prototype.accept = function(file, done) {\n                if (file.size > this.options.maxFilesize * 1024 * 1024) {\n                    return done(this.options.dictFileTooBig.replace(\"{{filesize}}\", Math.round(file.size / 1024 / 10.24) / 100).replace(\"{{maxFilesize}}\", this.options.maxFilesize));\n                } else if (!Dropzone.isValidFile(file, this.options.acceptedFiles)) {\n                    return done(this.options.dictInvalidFileType);\n                } else if ((this.options.maxFiles != null) && this.getAcceptedFiles().length >= this.options.maxFiles) {\n                    done(this.options.dictMaxFilesExceeded.replace(\"{{maxFiles}}\", this.options.maxFiles));\n                    return this.emit(\"maxfilesexceeded\", file);\n                } else {\n                    return this.options.accept.call(this, file, done);\n                }\n            };\n\n            Dropzone.prototype.addFile = function(file) {\n                file.upload = {\n                    progress: 0,\n                    total: file.size,\n                    bytesSent: 0\n                };\n                this.files.push(file);\n                file.status = Dropzone.ADDED;\n                this.emit(\"addedfile\", file);\n                this._enqueueThumbnail(file);\n                return this.accept(file, (function(_this) {\n                    return function(error) {\n                        if (error) {\n                            file.accepted = false;\n                            _this._errorProcessing([file], error);\n                        } else {\n                            file.accepted = true;\n                            if (_this.options.autoQueue) {\n                                _this.enqueueFile(file);\n                            }\n                        }\n                        return _this._updateMaxFilesReachedClass();\n                    };\n                })(this));\n            };\n\n            Dropzone.prototype.enqueueFiles = function(files) {\n                var file, _i, _len;\n                for (_i = 0, _len = files.length; _i < _len; _i++) {\n                    file = files[_i];\n                    this.enqueueFile(file);\n                }\n                return null;\n            };\n\n            Dropzone.prototype.enqueueFile = function(file) {\n                if (file.status === Dropzone.ADDED && file.accepted === true) {\n                    file.status = Dropzone.QUEUED;\n                    if (this.options.autoProcessQueue) {\n                        return setTimeout(((function(_this) {\n                            return function() {\n                                return _this.processQueue();\n                            };\n                        })(this)), 0);\n                    }\n                } else {\n                    throw new Error(\"This file can't be queued because it has already been processed or was rejected.\");\n                }\n            };\n\n            Dropzone.prototype._thumbnailQueue = [];\n\n            Dropzone.prototype._processingThumbnail = false;\n\n            Dropzone.prototype._enqueueThumbnail = function(file) {\n                if (this.options.createImageThumbnails && file.type.match(/image.*/) && file.size <= this.options.maxThumbnailFilesize * 1024 * 1024) {\n                    this._thumbnailQueue.push(file);\n                    return setTimeout(((function(_this) {\n                        return function() {\n                            return _this._processThumbnailQueue();\n                        };\n                    })(this)), 0);\n                }\n            };\n\n            Dropzone.prototype._processThumbnailQueue = function() {\n                if (this._processingThumbnail || this._thumbnailQueue.length === 0) {\n                    return;\n                }\n                this._processingThumbnail = true;\n                return this.createThumbnail(this._thumbnailQueue.shift(), (function(_this) {\n                    return function() {\n                        _this._processingThumbnail = false;\n                        return _this._processThumbnailQueue();\n                    };\n                })(this));\n            };\n\n            Dropzone.prototype.removeFile = function(file) {\n                if (file.status === Dropzone.UPLOADING) {\n                    this.cancelUpload(file);\n                }\n                this.files = without(this.files, file);\n                this.emit(\"removedfile\", file);\n                if (this.files.length === 0) {\n                    return this.emit(\"reset\");\n                }\n            };\n\n            Dropzone.prototype.removeAllFiles = function(cancelIfNecessary) {\n                var file, _i, _len, _ref;\n                if (cancelIfNecessary == null) {\n                    cancelIfNecessary = false;\n                }\n                _ref = this.files.slice();\n                for (_i = 0, _len = _ref.length; _i < _len; _i++) {\n                    file = _ref[_i];\n                    if (file.status !== Dropzone.UPLOADING || cancelIfNecessary) {\n                        this.removeFile(file);\n                    }\n                }\n                return null;\n            };\n\n            Dropzone.prototype.createThumbnail = function(file, callback) {\n                var fileReader;\n                fileReader = new FileReader;\n                fileReader.onload = (function(_this) {\n                    return function() {\n                        if (file.type === \"image/svg+xml\") {\n                            _this.emit(\"thumbnail\", file, fileReader.result);\n                            if (callback != null) {\n                                callback();\n                            }\n                            return;\n                        }\n                        return _this.createThumbnailFromUrl(file, fileReader.result, callback);\n                    };\n                })(this);\n                return fileReader.readAsDataURL(file);\n            };\n\n            Dropzone.prototype.createThumbnailFromUrl = function(file, imageUrl, callback, crossOrigin) {\n                var img;\n                img = document.createElement(\"img\");\n                if (crossOrigin) {\n                    img.crossOrigin = crossOrigin;\n                }\n                img.onload = (function(_this) {\n                    return function() {\n                        var canvas, ctx, resizeInfo, thumbnail, _ref, _ref1, _ref2, _ref3;\n                        file.width = img.width;\n                        file.height = img.height;\n                        resizeInfo = _this.options.resize.call(_this, file);\n                        if (resizeInfo.trgWidth == null) {\n                            resizeInfo.trgWidth = resizeInfo.optWidth;\n                        }\n                        if (resizeInfo.trgHeight == null) {\n                            resizeInfo.trgHeight = resizeInfo.optHeight;\n                        }\n                        canvas = document.createElement(\"canvas\");\n                        ctx = canvas.getContext(\"2d\");\n                        canvas.width = resizeInfo.trgWidth;\n                        canvas.height = resizeInfo.trgHeight;\n                        drawImageIOSFix(ctx, img, (_ref = resizeInfo.srcX) != null ? _ref : 0, (_ref1 = resizeInfo.srcY) != null ? _ref1 : 0, resizeInfo.srcWidth, resizeInfo.srcHeight, (_ref2 = resizeInfo.trgX) != null ? _ref2 : 0, (_ref3 = resizeInfo.trgY) != null ? _ref3 : 0, resizeInfo.trgWidth, resizeInfo.trgHeight);\n                        thumbnail = canvas.toDataURL(\"image/png\");\n                        _this.emit(\"thumbnail\", file, thumbnail);\n                        if (callback != null) {\n                            return callback();\n                        }\n                    };\n                })(this);\n                if (callback != null) {\n                    img.onerror = callback;\n                }\n                return img.src = imageUrl;\n            };\n\n            Dropzone.prototype.processQueue = function() {\n                var i, parallelUploads, processingLength, queuedFiles;\n                parallelUploads = this.options.parallelUploads;\n                processingLength = this.getUploadingFiles().length;\n                i = processingLength;\n                if (processingLength >= parallelUploads) {\n                    return;\n                }\n                queuedFiles = this.getQueuedFiles();\n                if (!(queuedFiles.length > 0)) {\n                    return;\n                }\n                if (this.options.uploadMultiple) {\n                    return this.processFiles(queuedFiles.slice(0, parallelUploads - processingLength));\n                } else {\n                    while (i < parallelUploads) {\n                        if (!queuedFiles.length) {\n                            return;\n                        }\n                        this.processFile(queuedFiles.shift());\n                        i++;\n                    }\n                }\n            };\n\n            Dropzone.prototype.processFile = function(file) {\n                return this.processFiles([file]);\n            };\n\n            Dropzone.prototype.processFiles = function(files) {\n                var file, _i, _len;\n                for (_i = 0, _len = files.length; _i < _len; _i++) {\n                    file = files[_i];\n                    file.processing = true;\n                    file.status = Dropzone.UPLOADING;\n                    this.emit(\"processing\", file);\n                }\n                if (this.options.uploadMultiple) {\n                    this.emit(\"processingmultiple\", files);\n                }\n                return this.uploadFiles(files);\n            };\n\n            Dropzone.prototype._getFilesWithXhr = function(xhr) {\n                var file, files;\n                return files = (function() {\n                    var _i, _len, _ref, _results;\n                    _ref = this.files;\n                    _results = [];\n                    for (_i = 0, _len = _ref.length; _i < _len; _i++) {\n                        file = _ref[_i];\n                        if (file.xhr === xhr) {\n                            _results.push(file);\n                        }\n                    }\n                    return _results;\n                }).call(this);\n            };\n\n            Dropzone.prototype.cancelUpload = function(file) {\n                var groupedFile, groupedFiles, _i, _j, _len, _len1, _ref;\n                if (file.status === Dropzone.UPLOADING) {\n                    groupedFiles = this._getFilesWithXhr(file.xhr);\n                    for (_i = 0, _len = groupedFiles.length; _i < _len; _i++) {\n                        groupedFile = groupedFiles[_i];\n                        groupedFile.status = Dropzone.CANCELED;\n                    }\n                    file.xhr.abort();\n                    for (_j = 0, _len1 = groupedFiles.length; _j < _len1; _j++) {\n                        groupedFile = groupedFiles[_j];\n                        this.emit(\"canceled\", groupedFile);\n                    }\n                    if (this.options.uploadMultiple) {\n                        this.emit(\"canceledmultiple\", groupedFiles);\n                    }\n                } else if ((_ref = file.status) === Dropzone.ADDED || _ref === Dropzone.QUEUED) {\n                    file.status = Dropzone.CANCELED;\n                    this.emit(\"canceled\", file);\n                    if (this.options.uploadMultiple) {\n                        this.emit(\"canceledmultiple\", [file]);\n                    }\n                }\n                if (this.options.autoProcessQueue) {\n                    return this.processQueue();\n                }\n            };\n\n            resolveOption = function() {\n                var args, option;\n                option = arguments[0], args = 2 <= arguments.length ? __slice.call(arguments, 1) : [];\n                if (typeof option === 'function') {\n                    return option.apply(this, args);\n                }\n                return option;\n            };\n\n            Dropzone.prototype.uploadFile = function(file) {\n                return this.uploadFiles([file]);\n            };\n\n            Dropzone.prototype.uploadFiles = function(files) {\n                var file, formData, handleError, headerName, headerValue, headers, i, input, inputName, inputType, key, method, option, progressObj, response, updateProgress, url, value, xhr, _i, _j, _k, _l, _len, _len1, _len2, _len3, _m, _ref, _ref1, _ref2, _ref3, _ref4, _ref5;\n                xhr = new XMLHttpRequest();\n                for (_i = 0, _len = files.length; _i < _len; _i++) {\n                    file = files[_i];\n                    file.xhr = xhr;\n                }\n                method = resolveOption(this.options.method, files);\n                url = resolveOption(this.options.url, files);\n                xhr.open(method, url, true);\n                xhr.withCredentials = !!this.options.withCredentials;\n                response = null;\n                handleError = (function(_this) {\n                    return function() {\n                        var _j, _len1, _results;\n                        _results = [];\n                        for (_j = 0, _len1 = files.length; _j < _len1; _j++) {\n                            file = files[_j];\n                            _results.push(_this._errorProcessing(files, response || _this.options.dictResponseError.replace(\"{{statusCode}}\", xhr.status), xhr));\n                        }\n                        return _results;\n                    };\n                })(this);\n                updateProgress = (function(_this) {\n                    return function(e) {\n                        var allFilesFinished, progress, _j, _k, _l, _len1, _len2, _len3, _results;\n                        if (e != null) {\n                            progress = 100 * e.loaded / e.total;\n                            for (_j = 0, _len1 = files.length; _j < _len1; _j++) {\n                                file = files[_j];\n                                file.upload = {\n                                    progress: progress,\n                                    total: e.total,\n                                    bytesSent: e.loaded\n                                };\n                            }\n                        } else {\n                            allFilesFinished = true;\n                            progress = 100;\n                            for (_k = 0, _len2 = files.length; _k < _len2; _k++) {\n                                file = files[_k];\n                                if (!(file.upload.progress === 100 && file.upload.bytesSent === file.upload.total)) {\n                                    allFilesFinished = false;\n                                }\n                                file.upload.progress = progress;\n                                file.upload.bytesSent = file.upload.total;\n                            }\n                            if (allFilesFinished) {\n                                return;\n                            }\n                        }\n                        _results = [];\n                        for (_l = 0, _len3 = files.length; _l < _len3; _l++) {\n                            file = files[_l];\n                            _results.push(_this.emit(\"uploadprogress\", file, progress, file.upload.bytesSent));\n                        }\n                        return _results;\n                    };\n                })(this);\n                xhr.onload = (function(_this) {\n                    return function(e) {\n                        var _ref;\n                        if (files[0].status === Dropzone.CANCELED) {\n                            return;\n                        }\n                        if (xhr.readyState !== 4) {\n                            return;\n                        }\n                        response = xhr.responseText;\n                        if (xhr.getResponseHeader(\"content-type\") && ~xhr.getResponseHeader(\"content-type\").indexOf(\"application/json\")) {\n                            try {\n                                response = JSON.parse(response);\n                            } catch (_error) {\n                                e = _error;\n                                response = \"Invalid JSON response from server.\";\n                            }\n                        }\n                        updateProgress();\n                        if (!((200 <= (_ref = xhr.status) && _ref < 300))) {\n                            return handleError();\n                        } else {\n                            return _this._finished(files, response, e);\n                        }\n                    };\n                })(this);\n                xhr.onerror = (function(_this) {\n                    return function() {\n                        if (files[0].status === Dropzone.CANCELED) {\n                            return;\n                        }\n                        return handleError();\n                    };\n                })(this);\n                progressObj = (_ref = xhr.upload) != null ? _ref : xhr;\n                progressObj.onprogress = updateProgress;\n                headers = {\n                    \"Accept\": \"application/json\",\n                    \"Cache-Control\": \"no-cache\",\n                    \"X-Requested-With\": \"XMLHttpRequest\"\n                };\n                if (this.options.headers) {\n                    extend(headers, this.options.headers);\n                }\n                for (headerName in headers) {\n                    headerValue = headers[headerName];\n                    if (headerValue) {\n                        xhr.setRequestHeader(headerName, headerValue);\n                    }\n                }\n                formData = new FormData();\n                if (this.options.params) {\n                    _ref1 = this.options.params;\n                    for (key in _ref1) {\n                        value = _ref1[key];\n                        formData.append(key, value);\n                    }\n                }\n                for (_j = 0, _len1 = files.length; _j < _len1; _j++) {\n                    file = files[_j];\n                    this.emit(\"sending\", file, xhr, formData);\n                }\n                if (this.options.uploadMultiple) {\n                    this.emit(\"sendingmultiple\", files, xhr, formData);\n                }\n                if (this.element.tagName === \"FORM\") {\n                    _ref2 = this.element.querySelectorAll(\"input, textarea, select, button\");\n                    for (_k = 0, _len2 = _ref2.length; _k < _len2; _k++) {\n                        input = _ref2[_k];\n                        inputName = input.getAttribute(\"name\");\n                        inputType = input.getAttribute(\"type\");\n                        if (input.tagName === \"SELECT\" && input.hasAttribute(\"multiple\")) {\n                            _ref3 = input.options;\n                            for (_l = 0, _len3 = _ref3.length; _l < _len3; _l++) {\n                                option = _ref3[_l];\n                                if (option.selected) {\n                                    formData.append(inputName, option.value);\n                                }\n                            }\n                        } else if (!inputType || ((_ref4 = inputType.toLowerCase()) !== \"checkbox\" && _ref4 !== \"radio\") || input.checked) {\n                            formData.append(inputName, input.value);\n                        }\n                    }\n                }\n                for (i = _m = 0, _ref5 = files.length - 1; 0 <= _ref5 ? _m <= _ref5 : _m >= _ref5; i = 0 <= _ref5 ? ++_m : --_m) {\n                    formData.append(this._getParamName(i), files[i], files[i].name);\n                }\n                return this.submitRequest(xhr, formData, files);\n            };\n\n            Dropzone.prototype.submitRequest = function(xhr, formData, files) {\n                return xhr.send(formData);\n            };\n\n            Dropzone.prototype._finished = function(files, responseText, e) {\n                var file, _i, _len;\n                for (_i = 0, _len = files.length; _i < _len; _i++) {\n                    file = files[_i];\n                    file.status = Dropzone.SUCCESS;\n                    this.emit(\"success\", file, responseText, e);\n                    this.emit(\"complete\", file);\n                }\n                if (this.options.uploadMultiple) {\n                    this.emit(\"successmultiple\", files, responseText, e);\n                    this.emit(\"completemultiple\", files);\n                }\n                if (this.options.autoProcessQueue) {\n                    return this.processQueue();\n                }\n            };\n\n            Dropzone.prototype._errorProcessing = function(files, message, xhr) {\n                var file, _i, _len;\n                for (_i = 0, _len = files.length; _i < _len; _i++) {\n                    file = files[_i];\n                    file.status = Dropzone.ERROR;\n                    this.emit(\"error\", file, message, xhr);\n                    this.emit(\"complete\", file);\n                }\n                if (this.options.uploadMultiple) {\n                    this.emit(\"errormultiple\", files, message, xhr);\n                    this.emit(\"completemultiple\", files);\n                }\n                if (this.options.autoProcessQueue) {\n                    return this.processQueue();\n                }\n            };\n\n            return Dropzone;\n\n        })(Emitter);\n\n        Dropzone.version = \"4.2.0\";\n\n        Dropzone.options = {};\n\n        Dropzone.optionsForElement = function(element) {\n            if (element.getAttribute(\"id\")) {\n                return Dropzone.options[camelize(element.getAttribute(\"id\"))];\n            } else {\n                return void 0;\n            }\n        };\n\n        Dropzone.instances = [];\n\n        Dropzone.forElement = function(element) {\n            if (typeof element === \"string\") {\n                element = document.querySelector(element);\n            }\n            if ((element != null ? element.dropzone : void 0) == null) {\n                throw new Error(\"No Dropzone found for given element. This is probably because you're trying to access it before Dropzone had the time to initialize. Use the `init` option to setup any additional observers on your Dropzone.\");\n            }\n            return element.dropzone;\n        };\n\n        Dropzone.autoDiscover = true;\n\n        Dropzone.discover = function() {\n            var checkElements, dropzone, dropzones, _i, _len, _results;\n            if (document.querySelectorAll) {\n                dropzones = document.querySelectorAll(\".dropzone\");\n            } else {\n                dropzones = [];\n                checkElements = function(elements) {\n                    var el, _i, _len, _results;\n                    _results = [];\n                    for (_i = 0, _len = elements.length; _i < _len; _i++) {\n                        el = elements[_i];\n                        if (/(^| )dropzone($| )/.test(el.className)) {\n                            _results.push(dropzones.push(el));\n                        } else {\n                            _results.push(void 0);\n                        }\n                    }\n                    return _results;\n                };\n                checkElements(document.getElementsByTagName(\"div\"));\n                checkElements(document.getElementsByTagName(\"form\"));\n            }\n            _results = [];\n            for (_i = 0, _len = dropzones.length; _i < _len; _i++) {\n                dropzone = dropzones[_i];\n                if (Dropzone.optionsForElement(dropzone) !== false) {\n                    _results.push(new Dropzone(dropzone));\n                } else {\n                    _results.push(void 0);\n                }\n            }\n            return _results;\n        };\n\n        Dropzone.blacklistedBrowsers = [/opera.*Macintosh.*version\\/12/i];\n\n        Dropzone.isBrowserSupported = function() {\n            var capableBrowser, regex, _i, _len, _ref;\n            capableBrowser = true;\n            if (window.File && window.FileReader && window.FileList && window.Blob && window.FormData && document.querySelector) {\n                if (!(\"classList\" in document.createElement(\"a\"))) {\n                    capableBrowser = false;\n                } else {\n                    _ref = Dropzone.blacklistedBrowsers;\n                    for (_i = 0, _len = _ref.length; _i < _len; _i++) {\n                        regex = _ref[_i];\n                        if (regex.test(navigator.userAgent)) {\n                            capableBrowser = false;\n                            continue;\n                        }\n                    }\n                }\n            } else {\n                capableBrowser = false;\n            }\n            return capableBrowser;\n        };\n\n        without = function(list, rejectedItem) {\n            var item, _i, _len, _results;\n            _results = [];\n            for (_i = 0, _len = list.length; _i < _len; _i++) {\n                item = list[_i];\n                if (item !== rejectedItem) {\n                    _results.push(item);\n                }\n            }\n            return _results;\n        };\n\n        camelize = function(str) {\n            return str.replace(/[\\-_](\\w)/g, function(match) {\n                return match.charAt(1).toUpperCase();\n            });\n        };\n\n        Dropzone.createElement = function(string) {\n            var div;\n            div = document.createElement(\"div\");\n            div.innerHTML = string;\n            return div.childNodes[0];\n        };\n\n        Dropzone.elementInside = function(element, container) {\n            if (element === container) {\n                return true;\n            }\n            while (element = element.parentNode) {\n                if (element === container) {\n                    return true;\n                }\n            }\n            return false;\n        };\n\n        Dropzone.getElement = function(el, name) {\n            var element;\n            if (typeof el === \"string\") {\n                element = document.querySelector(el);\n            } else if (el.nodeType != null) {\n                element = el;\n            }\n            if (element == null) {\n                throw new Error(\"Invalid `\" + name + \"` option provided. Please provide a CSS selector or a plain HTML element.\");\n            }\n            return element;\n        };\n\n        Dropzone.getElements = function(els, name) {\n            var e, el, elements, _i, _j, _len, _len1, _ref;\n            if (els instanceof Array) {\n                elements = [];\n                try {\n                    for (_i = 0, _len = els.length; _i < _len; _i++) {\n                        el = els[_i];\n                        elements.push(this.getElement(el, name));\n                    }\n                } catch (_error) {\n                    e = _error;\n                    elements = null;\n                }\n            } else if (typeof els === \"string\") {\n                elements = [];\n                _ref = document.querySelectorAll(els);\n                for (_j = 0, _len1 = _ref.length; _j < _len1; _j++) {\n                    el = _ref[_j];\n                    elements.push(el);\n                }\n            } else if (els.nodeType != null) {\n                elements = [els];\n            }\n            if (!((elements != null) && elements.length)) {\n                throw new Error(\"Invalid `\" + name + \"` option provided. Please provide a CSS selector, a plain HTML element or a list of those.\");\n            }\n            return elements;\n        };\n\n        Dropzone.confirm = function(question, accepted, rejected) {\n            if (window.confirm(question)) {\n                return accepted();\n            } else if (rejected != null) {\n                return rejected();\n            }\n        };\n\n        Dropzone.isValidFile = function(file, acceptedFiles) {\n            var baseMimeType, mimeType, validType, _i, _len;\n            if (!acceptedFiles) {\n                return true;\n            }\n            acceptedFiles = acceptedFiles.split(\",\");\n            mimeType = file.type;\n            baseMimeType = mimeType.replace(/\\/.*$/, \"\");\n            for (_i = 0, _len = acceptedFiles.length; _i < _len; _i++) {\n                validType = acceptedFiles[_i];\n                validType = validType.trim();\n                if (validType.charAt(0) === \".\") {\n                    if (file.name.toLowerCase().indexOf(validType.toLowerCase(), file.name.length - validType.length) !== -1) {\n                        return true;\n                    }\n                } else if (/\\/\\*$/.test(validType)) {\n                    if (baseMimeType === validType.replace(/\\/.*$/, \"\")) {\n                        return true;\n                    }\n                } else {\n                    if (mimeType === validType) {\n                        return true;\n                    }\n                }\n            }\n            return false;\n        };\n\n        if (typeof jQuery !== \"undefined\" && jQuery !== null) {\n            jQuery.fn.dropzone = function(options) {\n                return this.each(function() {\n                    return new Dropzone(this, options);\n                });\n            };\n        }\n\n        if (typeof module !== \"undefined\" && module !== null) {\n            module.exports = Dropzone;\n        } else {\n            window.Dropzone = Dropzone;\n        }\n\n        Dropzone.ADDED = \"added\";\n\n        Dropzone.QUEUED = \"queued\";\n\n        Dropzone.ACCEPTED = Dropzone.QUEUED;\n\n        Dropzone.UPLOADING = \"uploading\";\n\n        Dropzone.PROCESSING = Dropzone.UPLOADING;\n\n        Dropzone.CANCELED = \"canceled\";\n\n        Dropzone.ERROR = \"error\";\n\n        Dropzone.SUCCESS = \"success\";\n\n\n        /*\n\n         Bugfix for iOS 6 and 7\n         Source: http://stackoverflow.com/questions/11929099/html5-canvas-drawimage-ratio-bug-ios\n         based on the work of https://github.com/stomita/ios-imagefile-megapixel\n         */\n\n        detectVerticalSquash = function(img) {\n            var alpha, canvas, ctx, data, ey, ih, iw, py, ratio, sy;\n            iw = img.naturalWidth;\n            ih = img.naturalHeight;\n            canvas = document.createElement(\"canvas\");\n            canvas.width = 1;\n            canvas.height = ih;\n            ctx = canvas.getContext(\"2d\");\n            ctx.drawImage(img, 0, 0);\n            data = ctx.getImageData(0, 0, 1, ih).data;\n            sy = 0;\n            ey = ih;\n            py = ih;\n            while (py > sy) {\n                alpha = data[(py - 1) * 4 + 3];\n                if (alpha === 0) {\n                    ey = py;\n                } else {\n                    sy = py;\n                }\n                py = (ey + sy) >> 1;\n            }\n            ratio = py / ih;\n            if (ratio === 0) {\n                return 1;\n            } else {\n                return ratio;\n            }\n        };\n\n        drawImageIOSFix = function(ctx, img, sx, sy, sw, sh, dx, dy, dw, dh) {\n            var vertSquashRatio;\n            vertSquashRatio = detectVerticalSquash(img);\n            return ctx.drawImage(img, sx, sy, sw, sh, dx, dy, dw, dh / vertSquashRatio);\n        };\n\n\n        /*\n         * contentloaded.js\n         *\n         * Author: Diego Perini (diego.perini at gmail.com)\n         * Summary: cross-browser wrapper for DOMContentLoaded\n         * Updated: 20101020\n         * License: MIT\n         * Version: 1.2\n         *\n         * URL:\n         * http://javascript.nwbox.com/ContentLoaded/\n         * http://javascript.nwbox.com/ContentLoaded/MIT-LICENSE\n         */\n\n        contentLoaded = function(win, fn) {\n            var add, doc, done, init, poll, pre, rem, root, top;\n            done = false;\n            top = true;\n            doc = win.document;\n            root = doc.documentElement;\n            add = (doc.addEventListener ? \"addEventListener\" : \"attachEvent\");\n            rem = (doc.addEventListener ? \"removeEventListener\" : \"detachEvent\");\n            pre = (doc.addEventListener ? \"\" : \"on\");\n            init = function(e) {\n                if (e.type === \"readystatechange\" && doc.readyState !== \"complete\") {\n                    return;\n                }\n                (e.type === \"load\" ? win : doc)[rem](pre + e.type, init, false);\n                if (!done && (done = true)) {\n                    return fn.call(win, e.type || e);\n                }\n            };\n            poll = function() {\n                var e;\n                try {\n                    root.doScroll(\"left\");\n                } catch (_error) {\n                    e = _error;\n                    setTimeout(poll, 50);\n                    return;\n                }\n                return init(\"poll\");\n            };\n            if (doc.readyState !== \"complete\") {\n                if (doc.createEventObject && root.doScroll) {\n                    try {\n                        top = !win.frameElement;\n                    } catch (_error) {}\n                    if (top) {\n                        poll();\n                    }\n                }\n                doc[add](pre + \"DOMContentLoaded\", init, false);\n                doc[add](pre + \"readystatechange\", init, false);\n                return win[add](pre + \"load\", init, false);\n            }\n        };\n\n        Dropzone._autoDiscoverFunction = function() {\n            if (Dropzone.autoDiscover) {\n                return Dropzone.discover();\n            }\n        };\n\n        contentLoaded(window, Dropzone._autoDiscoverFunction);\n\n    }).call(this);\n\n    return module.exports;\n}));","Magento_PageBuilder/js/resource/dropzone/knockout-dropzone.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/*eslint-disable vars-on-top, strict*/\n\n(function (factory) {\n    if (typeof define === 'function' && define.amd) {\n        // AMD anonymous module\n        define(['knockout', 'jquery', 'Magento_PageBuilder/js/resource/dropzone/dropzone', 'mage/translate'], factory);\n    } else if (typeof require === 'function' && typeof exports === 'object' && typeof module === 'object') {\n        // CommonJS module\n        var ko = require('knockout'),\n            jQuery = require('jquery'),\n            Dropzone = require('Magento_PageBuilder/js/resource/dropzone/dropzone'),\n            translate = require('mage/translate');\n\n        factory(ko, jQuery, Dropzone, translate);\n    } else {\n        // No module loader (plain <script> tag) - put directly in global namespace\n        factory(window.ko, window.jQuery, window.Dropzone, window.translate);\n    }\n})(function (ko, jQuery, Dropzone, $t) {\n\n    // Create a new sortable Knockout binding\n    ko.bindingHandlers.dropzone = {\n\n        /**\n         * Init the dropzone element\n         *\n         * @param element\n         * @param valueAccessor\n         */\n        init: function (element, valueAccessor) {\n            var value = ko.unwrap(valueAccessor()),\n                originalSuccess = value.success,\n                options = {\n                    uploadMultiple: false,\n                    createImageThumbnails: false,\n                    addRemoveLinks: false,\n                    dictDefaultMessage: $t('Drop files here, or click to upload'),\n                    init: function () {\n                        // Add the current formKey into the request\n                        this.on('sending', function (file, xhr, formData) {\n                            formData.append('form_key', FORM_KEY);\n                        });\n                    },\n                    success: function (file, response) {\n                        return originalSuccess.call(this, file, response, value.bindKey);\n                    }\n                };\n\n            // Delete the success value\n            delete value.success;\n\n            // Extend the options with the values provided\n            jQuery.extend(options, value);\n\n            jQuery(element).addClass('dropzone');\n            new Dropzone(element, options);\n        }\n\n    };\n});","Magento_PageBuilder/js/resource/resize-observer/ResizeObserver.min.js":"!function(t,e){\"object\"==typeof exports&&\"undefined\"!=typeof module?module.exports=e():\"function\"==typeof define&&define.amd?define(e):t.ResizeObserver=e()}(this,function(){\"use strict\";var i=function(){if(\"undefined\"!=typeof Map)return Map;function i(t,n){var i=-1;return t.some(function(t,e){return t[0]===n&&(i=e,!0)}),i}return function(){function t(){this.__entries__=[]}var e={size:{configurable:!0}};return e.size.get=function(){return this.__entries__.length},t.prototype.get=function(t){var e=i(this.__entries__,t),n=this.__entries__[e];return n&&n[1]},t.prototype.set=function(t,e){var n=i(this.__entries__,t);~n?this.__entries__[n][1]=e:this.__entries__.push([t,e])},t.prototype.delete=function(t){var e=this.__entries__,n=i(e,t);~n&&e.splice(n,1)},t.prototype.has=function(t){return!!~i(this.__entries__,t)},t.prototype.clear=function(){this.__entries__.splice(0)},t.prototype.forEach=function(t,e){void 0===e&&(e=null);for(var n=0,i=this.__entries__;n<i.length;n+=1){var r=i[n];t.call(e,r[1],r[0])}},Object.defineProperties(t.prototype,e),t}()}(),n=\"undefined\"!=typeof window&&\"undefined\"!=typeof document&&window.document===document,e=\"undefined\"!=typeof global&&global.Math===Math?global:\"undefined\"!=typeof self&&self.Math===Math?self:\"undefined\"!=typeof window&&window.Math===Math?window:Function(\"return this\")(),c=\"function\"==typeof requestAnimationFrame?requestAnimationFrame.bind(e):function(t){return setTimeout(function(){return t(Date.now())},1e3/60)},r=[\"top\",\"right\",\"bottom\",\"left\",\"width\",\"height\",\"size\",\"weight\"],t=\"undefined\"!=typeof MutationObserver,o=function(){this.connected_=!1,this.mutationEventsAdded_=!1,this.mutationsObserver_=null,this.observers_=[],this.onTransitionEnd_=this.onTransitionEnd_.bind(this),this.refresh=function(t,e){var n=!1,i=!1,r=0;function o(){n&&(n=!1,t()),i&&a()}function s(){c(o)}function a(){var t=Date.now();if(n){if(t-r<2)return;i=!0}else i=!(n=!0),setTimeout(s,e);r=t}return a}(this.refresh.bind(this),20)};o.prototype.addObserver=function(t){~this.observers_.indexOf(t)||this.observers_.push(t),this.connected_||this.connect_()},o.prototype.removeObserver=function(t){var e=this.observers_,n=e.indexOf(t);~n&&e.splice(n,1),!e.length&&this.connected_&&this.disconnect_()},o.prototype.refresh=function(){this.updateObservers_()&&this.refresh()},o.prototype.updateObservers_=function(){var t=this.observers_.filter(function(t){return t.gatherActive(),t.hasActive()});return t.forEach(function(t){return t.broadcastActive()}),0<t.length},o.prototype.connect_=function(){n&&!this.connected_&&(document.addEventListener(\"transitionend\",this.onTransitionEnd_),window.addEventListener(\"resize\",this.refresh),t?(this.mutationsObserver_=new MutationObserver(this.refresh),this.mutationsObserver_.observe(document,{attributes:!0,childList:!0,characterData:!0,subtree:!0})):(document.addEventListener(\"DOMSubtreeModified\",this.refresh),this.mutationEventsAdded_=!0),this.connected_=!0)},o.prototype.disconnect_=function(){n&&this.connected_&&(document.removeEventListener(\"transitionend\",this.onTransitionEnd_),window.removeEventListener(\"resize\",this.refresh),this.mutationsObserver_&&this.mutationsObserver_.disconnect(),this.mutationEventsAdded_&&document.removeEventListener(\"DOMSubtreeModified\",this.refresh),this.mutationsObserver_=null,this.mutationEventsAdded_=!1,this.connected_=!1)},o.prototype.onTransitionEnd_=function(t){var e=t.propertyName;void 0===e&&(e=\"\"),r.some(function(t){return!!~e.indexOf(t)})&&this.refresh()},o.getInstance=function(){return this.instance_||(this.instance_=new o),this.instance_},o.instance_=null;var u=function(t,e){for(var n=0,i=Object.keys(e);n<i.length;n+=1){var r=i[n];Object.defineProperty(t,r,{value:e[r],enumerable:!1,writable:!1,configurable:!0})}return t},d=function(t){return t&&t.ownerDocument&&t.ownerDocument.defaultView||e},p=_(0,0,0,0);function v(t){return parseFloat(t)||0}function l(n){for(var t=[],e=arguments.length-1;0<e--;)t[e]=arguments[e+1];return t.reduce(function(t,e){return t+v(n[\"border-\"+e+\"-width\"])},0)}function s(t){var e=t.clientWidth,n=t.clientHeight;if(!e&&!n)return p;var i,r=d(t).getComputedStyle(t),o=function(t){for(var e={},n=0,i=[\"top\",\"right\",\"bottom\",\"left\"];n<i.length;n+=1){var r=i[n],o=t[\"padding-\"+r];e[r]=v(o)}return e}(r),s=o.left+o.right,a=o.top+o.bottom,c=v(r.width),h=v(r.height);if(\"border-box\"===r.boxSizing&&(Math.round(c+s)!==e&&(c-=l(r,\"left\",\"right\")+s),Math.round(h+a)!==n&&(h-=l(r,\"top\",\"bottom\")+a)),(i=t)!==d(i).document.documentElement){var u=Math.round(c+s)-e,f=Math.round(h+a)-n;1!==Math.abs(u)&&(c-=u),1!==Math.abs(f)&&(h-=f)}return _(o.left,o.top,c,h)}var a=\"undefined\"!=typeof SVGGraphicsElement?function(t){return t instanceof d(t).SVGGraphicsElement}:function(t){return t instanceof d(t).SVGElement&&\"function\"==typeof t.getBBox};function h(t){return n?a(t)?_(0,0,(e=t.getBBox()).width,e.height):s(t):p;var e}function _(t,e,n,i){return{x:t,y:e,width:n,height:i}}var f=function(t){this.broadcastWidth=0,this.broadcastHeight=0,this.contentRect_=_(0,0,0,0),this.target=t};f.prototype.isActive=function(){var t=h(this.target);return(this.contentRect_=t).width!==this.broadcastWidth||t.height!==this.broadcastHeight},f.prototype.broadcastRect=function(){var t=this.contentRect_;return this.broadcastWidth=t.width,this.broadcastHeight=t.height,t};var b=function(t,e){var n,i,r,o,s,a,c,h=(i=(n=e).x,r=n.y,o=n.width,s=n.height,a=\"undefined\"!=typeof DOMRectReadOnly?DOMRectReadOnly:Object,c=Object.create(a.prototype),u(c,{x:i,y:r,width:o,height:s,top:r,right:i+o,bottom:s+r,left:i}),c);u(this,{target:t,contentRect:h})},m=function(t,e,n){if(this.activeObservations_=[],this.observations_=new i,\"function\"!=typeof t)throw new TypeError(\"The callback provided as parameter 1 is not a function.\");this.callback_=t,this.controller_=e,this.callbackCtx_=n};m.prototype.observe=function(t){if(!arguments.length)throw new TypeError(\"1 argument required, but only 0 present.\");if(\"undefined\"!=typeof Element&&Element instanceof Object){if(!(t instanceof d(t).Element))throw new TypeError('parameter 1 is not of type \"Element\".');var e=this.observations_;e.has(t)||(e.set(t,new f(t)),this.controller_.addObserver(this),this.controller_.refresh())}},m.prototype.unobserve=function(t){if(!arguments.length)throw new TypeError(\"1 argument required, but only 0 present.\");if(\"undefined\"!=typeof Element&&Element instanceof Object){if(!(t instanceof d(t).Element))throw new TypeError('parameter 1 is not of type \"Element\".');var e=this.observations_;e.has(t)&&(e.delete(t),e.size||this.controller_.removeObserver(this))}},m.prototype.disconnect=function(){this.clearActive(),this.observations_.clear(),this.controller_.removeObserver(this)},m.prototype.gatherActive=function(){var e=this;this.clearActive(),this.observations_.forEach(function(t){t.isActive()&&e.activeObservations_.push(t)})},m.prototype.broadcastActive=function(){if(this.hasActive()){var t=this.callbackCtx_,e=this.activeObservations_.map(function(t){return new b(t.target,t.broadcastRect())});this.callback_.call(t,e,t),this.clearActive()}},m.prototype.clearActive=function(){this.activeObservations_.splice(0)},m.prototype.hasActive=function(){return 0<this.activeObservations_.length};var y=\"undefined\"!=typeof WeakMap?new WeakMap:new i,g=function(t){if(!(this instanceof g))throw new TypeError(\"Cannot call a class as a function.\");if(!arguments.length)throw new TypeError(\"1 argument required, but only 0 present.\");var e=o.getInstance(),n=new m(t,e,this);y.set(this,n)};return[\"observe\",\"unobserve\",\"disconnect\"].forEach(function(e){g.prototype[e]=function(){return(t=y.get(this))[e].apply(t,arguments);var t}}),void 0!==e.ResizeObserver?e.ResizeObserver:g});\n","Magento_PageBuilder/js/modal/template-manager-save.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore',\n    'mage/translate',\n    'Magento_Ui/js/modal/prompt'\n], function ($, _, $t) {\n    'use strict';\n\n    $.widget('mage.templateManagerSave', $.mage.prompt, {\n        options: {\n            createdForField: '[data-role=\"createdForField\"]',\n            previewImage: '[data-role=\"preview-image\"]',\n            previewImageSpinner: '[data-role=\"preview-image-spinner\"]',\n            saveButton: '[data-role=\"action\"].action-save',\n            form: 'form',\n            buttons: [{\n                text: $.mage.__('Cancel'),\n                class: 'action-secondary action-dismiss',\n\n                /**\n                 * Click handler.\n                 */\n                click: function () {\n                    this.closeModal();\n                }\n            }, {\n                text: $.mage.__('Save'),\n                class: 'action-primary action-save',\n\n                /**\n                 * Click handler.\n                 */\n                click: function () {\n                    this.submit();\n                }\n            }]\n        },\n\n        /**\n         * Create widget\n         *\n         * @private\n         */\n        _create: function () {\n            this._super();\n\n            this.modal.find(this.options.saveButton).prop('disabled', 'disabled');\n            // Ensure if the form is submitted through hitting enter we handle it correctly\n            this.modal.find(this.options.form).on('submit', function (event) {\n                event.preventDefault();\n                this.submit();\n            }.bind(this));\n        },\n\n        /**\n         * Validate prompt contains a template name\n         *\n         * @returns {Boolean}\n         */\n        validate: function () {\n            return this.modal.find(this.options.promptField) &&\n                !_.isEmpty(this.modal.find(this.options.promptField).val());\n        },\n\n        /**\n         * Save the values within the prompt\n         */\n        submit: function () {\n            var name,\n                createdFor;\n\n            if (this.options.validation && !this.validate()) {\n                return false;\n            }\n\n            $('body').trigger('processStart');\n\n            name = this.modal.find(this.options.promptField).val();\n            createdFor = this.modal.find(this.options.createdForField).val();\n\n            this.options.actions.confirm.call(this, name, createdFor).then(function () {\n                this.closeModal(true);\n                $('body').trigger('processStop');\n            }.bind(this)).catch(function () {\n                $('body').trigger('processStop');\n            });\n        },\n\n        /**\n         * Set the preview image\n         *\n         * @param {String} image\n         */\n        setPreviewImage: function (image) {\n            var previewImage = this.modal.find(this.options.previewImage),\n                previewImageSpinner = this.modal.find(this.options.previewImageSpinner);\n\n            // Update the preview image within the modal\n            previewImageSpinner.hide();\n            previewImage.append(\n                $('<img />').prop('src', image).prop('alt', $t('Template Preview'))\n            ).show();\n\n            // Enable the button so the user can save\n            this.modal.find(this.options.saveButton).removeProp('disabled');\n        },\n\n        /**\n         * Close modal window\n         */\n        closeModal: function (saved) {\n            if (!saved) {\n                this.options.actions.cancel.call(this, saved);\n            }\n\n            this.options.actions.always();\n            this.element.on('promptclosed', _.bind(this._remove, this));\n\n            return this._super();\n        }\n    });\n\n    return function (config) {\n        return $('<div class=\"prompt-message\"></div>').html(config.content).templateManagerSave(config);\n    };\n});\n","Magento_PageBuilder/js/modal/dismissible-confirm.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * Extend the confirmation prompt to allow for an additional checkbox to be displayed. The checkbox enables the user to\n * dismiss subsequent prompts of the same type based on their dismissKey.\n *\n * Once a type is dismissed a cookie is set and all future instances of that prompt are bypassed. This cookie is\n * cleared once the user logs out and back in via an observer.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'text!Magento_PageBuilder/template/modal/dismissible-modal-content.html',\n    'mage/translate',\n    'Magento_Ui/js/modal/prompt',\n    'mage/cookies'\n], function ($, _, promptContentTmpl, $t) {\n    'use strict';\n\n    /**\n     * Create buttons array for modal options\n     *\n     * @param {Boolean} haveCancelButton\n     * @return {Object}\n     */\n    function buttonsConfig(haveCancelButton) {\n        var cancelButton = {\n            text: $.mage.__('Cancel'),\n            class: 'action-secondary action-dismiss',\n\n            /**\n             * Click handler.\n             */\n            click: function () {\n                this.closeModal(false);\n            }\n        },\n            confirmButton = {\n            text: $.mage.__('OK'),\n            class: 'action-primary action-accept',\n\n            /**\n             * Click handler.\n             */\n            click: function () {\n                this.closeModal(true);\n            }\n        },\n            buttons = [];\n\n        if (haveCancelButton !== false) {\n            buttons.push(cancelButton);\n        }\n        buttons.push(confirmButton);\n\n        return buttons;\n    }\n\n    $.widget('mage.dismissibleConfirm', $.mage.prompt, {\n        options: {\n            promptContentTmpl: promptContentTmpl,\n            dismissible: false, // Can the modal be dismissed?\n            dismissKey: 'default', // The key we'll check to see if the modal has already been dismissed\n            dismissMessage: $t('Do not show this again'), // Message to display next to the dismiss checkbox\n            dismissCheckbox: '[name=\"modal-dnsa\"]' // Selector to retrieve dismiss checkbox\n        },\n\n        /**\n         * Open the modal window, if the modal has been dismissed, then run the confirm & always actions and don't\n         * don't open the modal\n         *\n         * @returns {*}\n         */\n        openModal: function () {\n            if ($.mage.cookies.get(this.options.dismissKey) === 'true') {\n                this.options.actions.confirm();\n\n                return this.options.actions.always(); // Always runs after confirm in confirm.js\n            }\n\n            return this._super();\n        },\n\n        /**\n         * Close modal window.\n         *\n         * @param {Boolean} result\n         */\n        closeModal: function (result) {\n            this._super(result);\n\n            if (result && this._isDismissed()) {\n                $.mage.cookies.set(this.options.dismissKey, 'true', {});\n            }\n        },\n\n        /**\n         * Is the dismissed checkbox checked?\n         *\n         * @private\n         */\n        _isDismissed: function () {\n            return this.modal.find(this.options.dismissCheckbox).is(':checked');\n        }\n    });\n\n    return function (config) {\n        config.buttons = buttonsConfig(config.haveCancelButton);\n        delete config.haveCancelButton;\n\n        return $('<div></div>').html(config.content).dismissibleConfirm(config);\n    };\n});\n","Magento_PageBuilder/js/modal/template-manager-modal.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/modal-component',\n    'Magento_PageBuilder/js/events',\n    'underscore',\n    'Magento_PageBuilder/js/stage-builder'\n], function ($, ModalComponent, events, _, stageBuilder) {\n    'use strict';\n\n    return ModalComponent.extend({\n        defaults: {\n            stage: null,\n            modules: {\n                messageContainer: '${ $.messageContainerProvider }',\n                listing: '${ $.listingProvider }'\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            _.bindAll(this, 'closeModal');\n\n            events.on('stage:templateManager:open', function (params) {\n                this.openModal();\n                this.stage = params.stage;\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Apply selected template\n         *\n         * @param {String} template\n         */\n        applySelected: function (template) {\n            if (template) {\n                // Destroy the old content in the stage\n                this.stage.pageBuilder.destroy();\n                $('body').trigger('processStart');\n\n                stageBuilder(this.stage, template).then(function () {\n                    $('body').trigger('processStop');\n                    this.closeModal();\n                }.bind(this));\n            }\n        }\n    });\n});\n","Magento_PageBuilder/js/modal/confirm-alert.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget',\n    'Magento_Ui/js/modal/alert'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.confirmAlert', $.mage.alert, {\n        /**\n         * Fix issue with zIndex when removing the alert from the screen\n         * @private\n         */\n        _unsetActive: function () {\n            this._super();\n\n            if (this.overlay) {\n                this.overlay.zIndex('');\n            }\n        }\n    });\n\n    return function (config) {\n        return $('<div></div>').html(config.content).confirmAlert(config);\n    };\n});\n","Magento_PageBuilder/js/modal/modal.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/modal/modal-component',\n    'Magento_PageBuilder/js/events'\n], function (ModalComponent, events) {\n    'use strict';\n\n    return ModalComponent.extend({\n        defaults: {\n            titlePrefix: '${ $.options.title }',\n            modules: {\n                insertForm: '${ $.insertFormProvider }'\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n\n            events.on('form:renderAfter', function (params) {\n                this.openModal();\n                this.setTitle(this.titlePrefix + ' ' + params.title);\n                this.startListen(params.id);\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Listen for from save.\n         *\n         * @param {String} id\n         */\n        startListen: function (id) {\n            events.on('form:' + id + ':saveAfter', function () {\n                this.closeModal();\n            }.bind(this));\n\n        },\n\n        /**\n         * Trigger modalClosed event on external provider\n         *\n         * @returns {any}\n         */\n        closeModal: function () {\n            this.insertForm() &&\n            this.insertForm().externalSource() &&\n            this.insertForm().externalSource().trigger('data.modalClosed');\n\n            return this._super();\n        }\n    });\n});\n","Magento_PageBuilder/js/drag-drop/sortable.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\", \"knockout\", \"Magento_PageBuilder/js/events\", \"Magento_PageBuilder/js/content-type-factory\", \"Magento_PageBuilder/js/drag-drop/drop-indicators\", \"Magento_PageBuilder/js/drag-drop/matrix\", \"Magento_PageBuilder/js/drag-drop/move-content-type\", \"Magento_PageBuilder/js/drag-drop/registry\"], function (_jquery, _knockout, _events, _contentTypeFactory, _dropIndicators, _matrix, _moveContentType, _registry) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * The class used when hiding a content type\n   * @type {string}\n   */\n  var hiddenClass = \".pagebuilder-content-type-hidden\";\n  /**\n   * Return the sortable options for an instance which requires sorting / dropping functionality\n   *\n   * @param {Preview} preview\n   * @returns {JQueryUI.SortableOptions | any}\n   */\n\n  function getSortableOptions(preview) {\n    return {\n      cursor: \"-webkit-grabbing\",\n      tolerance: \"pointer\",\n      helper: function helper(event, item) {\n        var helper = (0, _jquery)(item).clone();\n        helper.css({\n          pointerEvents: \"none\"\n        });\n        return helper[0];\n      },\n      appendTo: document.body,\n      placeholder: {\n        element: function element() {\n          return (0, _jquery)(\"<div />\").addClass(\"pagebuilder-sortable-placeholder\")[0];\n        },\n        update: function update() {\n          return;\n        }\n      },\n      handle: \".move-structural\",\n      items: \"> .pagebuilder-content-type-wrapper\",\n      start: function start() {\n        onSortStart.apply(this, [preview].concat(Array.prototype.slice.call(arguments)));\n      },\n      sort: function sort() {\n        onSort.apply(this, [preview].concat(Array.prototype.slice.call(arguments)));\n      },\n      receive: function receive() {\n        onSortReceive.apply(this, [preview].concat(Array.prototype.slice.call(arguments)));\n      },\n      update: function update() {\n        onSortUpdate.apply(this, [preview].concat(Array.prototype.slice.call(arguments)));\n      },\n      stop: function stop() {\n        onSortStop.apply(this, [preview].concat(Array.prototype.slice.call(arguments)));\n      }\n    };\n  }\n  /**\n   * Get the stage ID from the preview\n   *\n   * @param {Preview | Stage} preview\n   * @returns {string}\n   */\n\n\n  function getPreviewStageIdProxy(preview) {\n    return preview.contentType.stageId;\n  }\n  /**\n   * Retrieve the contentType from the preview\n   *\n   * @param {Preview | Stage} instance\n   * @returns {any}\n   */\n\n\n  function getcontentTypeProxy(instance) {\n    return instance.contentType;\n  }\n\n  var sortedContentType;\n  /**\n   * On sort start record the item being sorted\n   *\n   * @param {Preview} preview\n   * @param {Event} event\n   * @param {JQueryUI.SortableUIParams} ui\n   */\n\n  function onSortStart(preview, event, ui) {\n    // Verify we're sorting an already created item\n    if (ui.item.hasClass(\"pagebuilder-content-type-wrapper\")) {\n      _events.trigger(\"stage:interactionStart\");\n\n      var contentTypeInstance = _knockout.dataFor(ui.item[0]);\n\n      if (contentTypeInstance) {\n        // Ensure the original item is displayed but with reduced opacity\n        ui.item.css(\"display\", \"block\").addClass(\"pagebuilder-sorting-original\");\n        (0, _jquery)(\".pagebuilder-drop-indicator.hidden-drop-indicator\").css(\"display\", \"block\").removeClass(\"hidden-drop-indicator\"); // If we're the first item in the container we need to hide the first drop indicator\n\n        if (contentTypeInstance.parentContentType.getChildren().indexOf(contentTypeInstance) === 0) {\n          ui.item.prev(\".pagebuilder-drop-indicator\").css(\"display\", \"none\").addClass(\"hidden-drop-indicator\");\n        }\n\n        (0, _dropIndicators.showDropIndicators)(contentTypeInstance.config.name, preview.contentType.stageId);\n        sortedContentType = contentTypeInstance; // Dynamically change the connect with option to restrict content types\n\n        (0, _jquery)(this).sortable(\"option\", \"connectWith\", (0, _matrix.getAllowedContainersClasses)(contentTypeInstance.config.name, preview.contentType.stageId));\n        (0, _jquery)(this).sortable(\"refresh\");\n      }\n    }\n  }\n\n  var placeholderContainer;\n  /**\n   * On a sort action hide the placeholder if disabled\n   *\n   * @param {Preview} preview\n   * @param {Event} event\n   * @param {JQueryUI.SortableUIParams} ui\n   */\n\n  function onSort(preview, event, ui) {\n    if ((0, _jquery)(this).sortable(\"option\", \"disabled\") || ui.placeholder.parents(hiddenClass).length > 0) {\n      ui.placeholder.css(\"display\", \"none\");\n    } else {\n      ui.placeholder.css(\"display\", \"block\");\n    }\n    /**\n     * We record the position of the placeholder on sort so we can ensure we place the content type in the correct place\n     * as jQuery UI's events aren't reliable.\n     */\n\n\n    placeholderContainer = ui.placeholder.parents(\".content-type-container\")[0];\n  }\n  /**\n   * On sort stop hide any indicators\n   */\n\n\n  function onSortStop(preview, event, ui) {\n    ui.item.removeClass(\"pagebuilder-sorting-original\");\n    (0, _dropIndicators.hideDropIndicators)();\n    (0, _registry.setDraggedContentTypeConfig)(null); // Only trigger stop if we triggered start\n\n    if (ui.item.hasClass(\"pagebuilder-content-type-wrapper\")) {\n      _events.trigger(\"stage:interactionStop\");\n    }\n\n    if (ui.item && !sortedContentType) {\n      ui.item.remove();\n    }\n\n    sortedContentType = null;\n  }\n  /**\n   * Handle receiving a content type from the left panel\n   *\n   * @param {Preview} preview\n   * @param {Event} event\n   * @param {JQueryUI.SortableUIParams} ui\n   */\n\n\n  function onSortReceive(preview, event, ui) {\n    var contentTypeConfig = (0, _registry.getDraggedContentTypeConfig)();\n    (0, _registry.setDraggedContentTypeConfig)(null);\n\n    if ((0, _jquery)(event.target)[0] !== this) {\n      return;\n    } // If the container content type can't receive drops we need to cancel the operation\n\n\n    if (!preview.isContainer()) {\n      (0, _jquery)(this).sortable(\"cancel\");\n      return;\n    }\n\n    if (contentTypeConfig) {\n      // If the sortable instance is disabled don't complete this operation\n      if ((0, _jquery)(this).sortable(\"option\", \"disabled\") || (0, _jquery)(this).parents(hiddenClass).length > 0) {\n        return;\n      } // jQuery's index method doesn't work correctly here, so use Array.findIndex instead\n\n\n      var index = (0, _jquery)(event.target).children(\".pagebuilder-content-type-wrapper, .pagebuilder-draggable-content-type\").toArray().findIndex(function (element) {\n        return element.classList.contains(\"pagebuilder-draggable-content-type\");\n      }); // Create the new content type and insert it into the parent\n\n      (0, _contentTypeFactory)(contentTypeConfig, getcontentTypeProxy(preview), getPreviewStageIdProxy(preview)).then(function (contentType) {\n        // Set the content type instance as \"dropped\", as it was dropped from the left panel\n        contentType.dropped = true;\n        getcontentTypeProxy(preview).addChild(contentType, index);\n\n        _events.trigger(\"contentType:dropAfter\", {\n          id: contentType.id,\n          contentType: contentType\n        });\n\n        _events.trigger(contentTypeConfig.name + \":dropAfter\", {\n          id: contentType.id,\n          contentType: contentType\n        });\n\n        return contentType;\n      }); // Remove the DOM element, as this is a drop event we can't just remove the ui.item\n\n      (0, _jquery)(event.target).find(\".pagebuilder-draggable-content-type\").remove();\n    }\n  }\n  /**\n   * On sort update handle sorting the underlying children knockout list\n   *\n   * @param {Preview} preview\n   * @param {Event} event\n   * @param {JQueryUI.SortableUIParams} ui\n   */\n\n\n  function onSortUpdate(preview, event, ui) {\n    // If the sortable instance is disabled don't complete this operation\n    if ((0, _jquery)(this).hasClass(\"ui-sortable\") && (0, _jquery)(this).sortable(\"option\", \"disabled\") || ui.item.parents(hiddenClass).length > 0) {\n      ui.item.remove();\n      (0, _jquery)(this).sortable(\"cancel\"); // jQuery tries to reset the state but kills KO's bindings, so we'll force a re-render on the content type\n\n      if (ui.item.length > 0 && typeof _knockout.dataFor(ui.item[0]) !== \"undefined\") {\n        var data = _knockout.dataFor(ui.item[0]);\n\n        var contentType = data.contentType && data.contentType.getChildren ? data.contentType : data.parentContentType;\n        var children = contentType.getChildren()().splice(0);\n        contentType.getChildren()([]);\n        contentType.getChildren()(children);\n      }\n\n      return;\n    }\n    /**\n     * Validate the event is coming from the exact instance or a child instance, we validate on the child instance\n     * as the event is sometimes annoyingly caught by the parent rather than the child it's dropped into. Combining this\n     * with placeholderContainer logic we can ensure we always do the right operation.\n     */\n\n\n    if (sortedContentType && (this === ui.item.parent()[0] || placeholderContainer && (0, _jquery)(this).find(ui.item.parent()).length > 0)) {\n      var el = ui.item[0];\n\n      var contentTypeInstance = _knockout.dataFor(el);\n\n      var target = _knockout.dataFor(placeholderContainer);\n\n      if (target && contentTypeInstance) {\n        // Calculate the source and target index\n        var sourceParent = contentTypeInstance.parentContentType;\n        var targetParent = getcontentTypeProxy(target);\n        var targetIndex = (0, _jquery)(placeholderContainer).children(\".pagebuilder-content-type-wrapper, .pagebuilder-draggable-content-type\").toArray().findIndex(function (element) {\n          return element === el;\n        });\n\n        if (sourceParent) {\n          (0, _jquery)(sourceParent === targetParent ? this : ui.sender || this).sortable(\"cancel\");\n        } else {\n          (0, _jquery)(el).remove();\n        }\n\n        (0, _moveContentType.moveContentType)(contentTypeInstance, targetIndex, targetParent);\n\n        if (contentTypeInstance.parentContentType !== targetParent) {\n          ui.item.remove();\n        }\n      }\n    }\n  }\n\n  return {\n    getSortableOptions: getSortableOptions,\n    hiddenClass: hiddenClass\n  };\n});\n//# sourceMappingURL=sortable.js.map","Magento_PageBuilder/js/drag-drop/move-content-type.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"knockout\", \"Magento_PageBuilder/js/events\"], function (_knockout, _events) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Move a content type to a new index, with the option to move to a new container\n   *\n   * @param {ContentTypeInterface | ContentTypeCollectionInterface} contentType\n   * @param {number} targetIndex\n   * @param {ContentTypeCollectionInterface} targetParent\n   */\n  function moveContentType(contentType, targetIndex, targetParent) {\n    if (targetParent === void 0) {\n      targetParent = null;\n    }\n\n    var sourceParent = contentType.parentContentType;\n    var sourceIndex = contentType.parentContentType.children().indexOf(contentType);\n    var sourceParentChildren = sourceParent.getChildren(); // Trigger our block move event\n\n    _events.trigger(\"contentType:moveBefore\", {\n      contentType: contentType,\n      sourceParent: sourceParent,\n      targetParent: targetParent,\n      targetIndex: targetIndex,\n      stageId: contentType.stageId\n    });\n\n    _events.trigger(contentType.config.name + \":moveBefore\", {\n      contentType: contentType,\n      sourceParent: sourceParent,\n      targetParent: targetParent,\n      targetIndex: targetIndex,\n      stageId: contentType.stageId\n    });\n\n    if (targetParent && sourceParent !== targetParent) {\n      contentType.parentContentType = targetParent; // Handle dragging between sortable elements\n\n      sourceParentChildren.splice(sourceIndex, 1);\n      targetParent.getChildren().splice(targetIndex, 0, contentType);\n    } else {\n      // Retrieve the children from the source parent\n      var children = _knockout.utils.unwrapObservable(sourceParentChildren); // Inform KO that this value is about to mutate\n\n\n      if (sourceParentChildren.valueWillMutate) {\n        sourceParentChildren.valueWillMutate();\n      } // Perform the mutation\n\n\n      children.splice(sourceIndex, 1);\n      children.splice(targetIndex, 0, contentType); // Inform KO that the mutation is complete\n\n      if (sourceParentChildren.valueHasMutated) {\n        sourceParentChildren.valueHasMutated();\n      }\n    } // Process any deferred bindings\n\n\n    if (_knockout.processAllDeferredBindingUpdates) {\n      _knockout.processAllDeferredBindingUpdates();\n    } // Trigger our content type move event\n\n\n    _events.trigger(\"contentType:moveAfter\", {\n      contentType: contentType,\n      sourceParent: sourceParent,\n      targetParent: targetParent,\n      targetIndex: targetIndex,\n      stageId: contentType.stageId\n    });\n\n    _events.trigger(contentType.config.name + \":moveAfter\", {\n      contentType: contentType,\n      sourceParent: sourceParent,\n      targetParent: targetParent,\n      targetIndex: targetIndex,\n      stageId: contentType.stageId\n    });\n  }\n\n  return {\n    moveContentType: moveContentType\n  };\n});\n//# sourceMappingURL=move-content-type.js.map","Magento_PageBuilder/js/drag-drop/registry.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var draggedContentTypeConfig;\n  /**\n   * Set the current dragged blocks config into the registry\n   *\n   * @param {ContentTypeConfigInterface} config\n   */\n\n  function setDraggedContentTypeConfig(config) {\n    draggedContentTypeConfig = config;\n  }\n  /**\n   * Retrieve the dragged blocks config\n   *\n   * @returns {ContentTypeConfigInterface}\n   */\n\n\n  function getDraggedContentTypeConfig() {\n    return draggedContentTypeConfig;\n  }\n\n  return {\n    setDraggedContentTypeConfig: setDraggedContentTypeConfig,\n    getDraggedContentTypeConfig: getDraggedContentTypeConfig\n  };\n});\n//# sourceMappingURL=registry.js.map","Magento_PageBuilder/js/drag-drop/matrix.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/config\"], function (_underscore, _config) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var allowedParents = {};\n  /**\n   * Build a matrix of which containers each content type can go into, these are determined by the allowed_parents\n   * node within the content types configuration\n   */\n\n  function generateAllowedParents() {\n    _underscore.values(_config.getConfig(\"content_types\")).forEach(function (contentType) {\n      allowedParents[contentType.name] = contentType.allowed_parents.slice();\n    });\n  }\n  /**\n   * Retrieve the containers a specific content type can be contained in\n   *\n   * @param {string} contentType\n   * @returns {any}\n   */\n\n\n  function getContainersFor(contentType) {\n    if (allowedParents[contentType]) {\n      return allowedParents[contentType];\n    }\n\n    return [];\n  }\n  /**\n   * Generate classes of containers the content type is allowed within\n   *\n   * @param {string} contentType\n   * @param {string} stageId\n   * @returns {string}\n   */\n\n\n  function getAllowedContainersClasses(contentType, stageId) {\n    return getContainersFor(contentType).map(function (value) {\n      return \"#\" + stageId + \" .content-type-container.\" + value + \"-container\";\n    }).join(\", \");\n  }\n  /**\n   * @api\n   */\n\n\n  return {\n    generateAllowedParents: generateAllowedParents,\n    getContainersFor: getContainersFor,\n    getAllowedContainersClasses: getAllowedContainersClasses\n  };\n});\n//# sourceMappingURL=matrix.js.map","Magento_PageBuilder/js/drag-drop/drop-indicators.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/create-stylesheet\", \"Magento_PageBuilder/js/drag-drop/matrix\"], function (_createStylesheet, _matrix) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var headDropIndicatorStyles;\n  /**\n   * Show the drop indicators for a specific content type\n   *\n   * We do this by creating a style sheet and injecting it into the head. It's dramatically quicker to allow the browsers\n   * CSS engine to display these for us than manually iterating through the DOM and applying a class to the elements.\n   *\n   * @param {string} contentType\n   * @param {string} stageId\n   * @returns {HTMLStyleElement}\n   */\n\n  function showDropIndicators(contentType, stageId) {\n    var acceptedContainers = (0, _matrix.getContainersFor)(contentType);\n\n    if (acceptedContainers.length > 0) {\n      var _ref;\n\n      var classNames = acceptedContainers.map(function (container) {\n        return \"#\" + stageId + \" .content-type-container.\" + container + \"-container > .pagebuilder-drop-indicator, \" + (\"#\" + stageId + \" .pagebuilder-content-type.type-container.empty-container > .content-type-container.\") + (container + \"-container:before\");\n      });\n      var styles = (0, _createStylesheet.createStyleSheet)((_ref = {}, _ref[classNames.join(\", \")] = {\n        opacity: 1,\n        visibility: \"visible\"\n      }, _ref));\n      document.head.appendChild(styles);\n      headDropIndicatorStyles = styles;\n      return styles;\n    }\n  }\n  /**\n   * Hide the drop indicators\n   */\n\n\n  function hideDropIndicators() {\n    if (headDropIndicatorStyles) {\n      headDropIndicatorStyles.remove();\n      headDropIndicatorStyles = null;\n    }\n  }\n\n  return {\n    showDropIndicators: showDropIndicators,\n    hideDropIndicators: hideDropIndicators\n  };\n});\n//# sourceMappingURL=drop-indicators.js.map","Magento_PageBuilder/js/grid/cells/single-select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/multiselect',\n    'underscore'\n], function (Select, _) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            headerTmpl: 'ui/grid/columns/text',\n            bodyTmpl: 'Magento_PageBuilder/grid/cells/single-select',\n            label: '',\n            extendedSelections: [],\n            lastSelected: null,\n            listens: {\n                selected: 'onSelectedChange setExtendedSelections'\n            }\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super()\n                .observe('extendedSelections lastSelected');\n\n            return this;\n        },\n\n        /**\n         * Getter for extended selections.\n         *\n         * @returns {Array}\n         */\n        getExtendedSelections: function () {\n            return this.extendedSelections();\n        },\n\n        /**\n         * Setter for extended selections.\n         *\n         * @param {Array} selected\n         */\n        setExtendedSelections: function (selected) {\n            var item = {},\n                extended = [];\n\n            _.each(selected, function (id) {\n                item[this.indexField] = id;\n                extended.push(_.findWhere(this.rows(), item));\n            }, this);\n\n            this.set('extendedSelections', extended);\n        },\n\n        /** @inheritdoc */\n        isSelected: function (id, isIndex) {\n            id = this.getId(id, isIndex);\n\n            return this.selected()[0] === id;\n        },\n\n        /** @inheritdoc **/\n        select: function (id) {\n            this._super();\n            this.lastSelected(id);\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        _setSelection: function (id, isIndex, select) {\n            var selected = this.selected;\n\n            id = this.getId(id, isIndex);\n\n            if (!select && this.isSelected(id)) {\n                selected([]);\n            } else if (select) {\n                selected([id]);\n            }\n\n            return this;\n        }\n    });\n});\n","Magento_PageBuilder/js/grid/cells/template-apply.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/multiselect',\n    'Magento_PageBuilder/js/modal/dismissible-confirm',\n    'mage/translate'\n], function (Select, confirm, $t) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            headerTmpl: 'ui/grid/columns/text',\n            bodyTmpl: 'Magento_PageBuilder/grid/cells/template-apply',\n            label: '',\n            lastSelected: null\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super()\n                .observe('lastSelected');\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        isSelected: function () {\n            return false;\n        },\n\n        /** @inheritdoc **/\n        select: function (id) {\n            var self = this,\n                superCall = this._super.bind(this);\n\n            self.lastSelected(null);\n\n            confirm({\n                title: $t('Apply Template'),\n                content: $t('Are you sure you want to apply this template? This will overwrite any existing content.'),\n                dismissKey: 'pagebuilder_template_apply_confirm',\n                dismissible: true,\n                actions: {\n                    /**\n                     * Confirm action\n                     */\n                    confirm: function () {\n                        superCall();\n                        self.lastSelected(id);\n                    }\n                },\n                buttons: [{\n                    text: $t('Cancel'),\n                    class: 'action-secondary action-dismiss action-pagebuilder-cancel',\n\n                    /**\n                     * Close modal and trigger 'cancel' action on click\n                     */\n                    click: function (event) {\n                        this.closeModal(event);\n                    }\n                }, {\n                    text: $t('Apply'),\n                    class: 'action-primary action-accept',\n\n                    /**\n                     * Close modal and trigger 'confirm' action on click\n                     */\n                    click: function (event) {\n                        superCall();\n                        self.lastSelected(id);\n                        this.closeModal(event);\n                    }\n                }]\n            });\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        _setSelection: function () {\n            return this;\n        }\n    });\n});\n","Magento_PageBuilder/js/grid/columns/actions.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/grid/columns/actions'\n], function (Actions) {\n    'use strict';\n\n    return Actions.extend({\n        defaults: {\n        },\n\n        /**\n         * Callback after click on element.\n         *\n         * @public\n         */\n        applyAction: function () {\n            switch (this.type) {\n                case 'edit-user':\n                    $(this).userEdit(this.options)\n                        .trigger('editUser');\n                    break;\n\n                case 'delete-user':\n                    $(this).userDelete(this.options)\n                        .trigger('deleteUser');\n                    break;\n\n                case 'delete-role':\n                    $(this).roleDelete(this.options)\n                        .trigger('deleteRole');\n                    break;\n\n                default:\n                    return true;\n            }\n        }\n    });\n});\n","Magento_PageBuilder/js/grid/columns/preview-image.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'jquery',\n    'mage/template',\n    'text!Magento_PageBuilder/template/grid/cells/preview-image/preview.html',\n    'underscore',\n    'Magento_Ui/js/modal/modal',\n    'mage/translate'\n], function (Column, $, mageTemplate, thumbnailPreviewTemplate, _) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'ui/grid/cells/thumbnail',\n            fieldClass: {\n                'data-grid-preview-image-cell': true\n            }\n        },\n\n        /**\n         * Get image source data per row.\n         *\n         * @param {Object} row\n         * @returns {String}\n         */\n        getSrc: function (row) {\n            return row[this.index + '_src'];\n        },\n\n        /**\n         * Retrieve the original images src to be displayed at full size in the modal\n         *\n         * @param {Object} row\n         * @returns {*}\n         */\n        getOrigSrc: function (row) {\n            return row[this.index + '_orig_src'];\n        },\n\n        /**\n         * Get alternative text data per row.\n         *\n         * @param {Object} row\n         * @returns {String}\n         */\n        getAlt: function (row) {\n            return _.escape(row[this.index + '_alt']);\n        },\n\n        /**\n         * Check if preview available.\n         *\n         * @returns {Boolean}\n         */\n        isPreviewAvailable: function () {\n            return this['has_preview'] || false;\n        },\n\n        /**\n         * Build preview.\n         *\n         * @param {Object} row\n         */\n        preview: function (row) {\n            var modalHtml = mageTemplate(\n                thumbnailPreviewTemplate,\n                {\n                    src: this.getOrigSrc(row),\n                    alt: this.getAlt(row)\n                }\n            ),\n                previewPopup = $('<div/>').html(modalHtml);\n\n            previewPopup.modal({\n                title: this.getAlt(row),\n                innerScroll: true,\n                modalClass: '_image-box',\n                buttons: []\n            }).trigger('openModal');\n        },\n\n        /**\n         * Get field handler per row.\n         *\n         * @param {Object} row\n         * @returns {Function}\n         */\n        getFieldHandler: function (row) {\n            if (this.isPreviewAvailable()) {\n                return this.preview.bind(this, row);\n            }\n        }\n    });\n});\n","Magento_PageBuilder/ts/babel/plugin-amd-to-magento-amd/index.js":"/* jscs:disable */\n/* eslint-disable */\n\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n\"use strict\";\n\nexports.__esModule = true;\nexports.default = _default;\n\nvar _astUtils = require(\"./ast-utils\");\n\nvar t = _interopRequireWildcard(require(\"@babel/types\"));\n\nfunction _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }\n\nvar replaceExportAssignment = function replaceExportAssignment(path, state) {\n    var property = path.get('left.property');\n    var expression = path.get('right');\n    path.remove();\n\n    if ((0, _astUtils.isVoidExpression)(expression)) {\n        return;\n    }\n\n    if (property.isIdentifier({\n        name: 'default'\n    })) {\n        state.defaultExport = expression.node;\n        return;\n    }\n\n    state.exports.push(t.objectProperty(property.node, expression.node));\n};\n\nvar memberExpressionVisitor = {\n    MemberExpression: function MemberExpression(path, state) {\n        var matchedDependencies = state.dependencies.filter(function (item) {\n            return path.get('object').isIdentifier({\n                name: item.name\n            });\n        });\n        var isDefaultDependency = matchedDependencies.length === 1 && path.get('property').isIdentifier({\n            name: 'default'\n        });\n\n        if (isDefaultDependency) {\n            path.replaceWith(matchedDependencies[0]);\n        }\n    }\n};\nvar functionBodyVisitor = {\n    ExpressionStatement: function ExpressionStatement(path, state) {\n        if ((0, _astUtils.isEsModulePropertyDefinition)(path, state.scope)) {\n            path.remove();\n        }\n\n        if ((0, _astUtils.isObjectAssignment)(path, state.scope)) {\n            replaceExportAssignment(path.get('expression'), state);\n        }\n\n        if ((0, _astUtils.isInteropRequireCall)(path)) {\n            path.remove();\n        }\n    },\n    Function: function Function(path, state) {\n        if ((0, _astUtils.isInteropRequireDefinition)(path)) {\n            path.remove();\n        }\n\n        path.traverse(memberExpressionVisitor, state);\n    },\n    ClassMethod: function ClassMethod(path, state) {\n        path.traverse(memberExpressionVisitor, state);\n    },\n    DirectiveLiteral: function DirectiveLiteral(path) {\n        if (path.node.value === 'use strict') {\n            path.parentPath.remove();\n        }\n    },\n    MemberExpression: memberExpressionVisitor.MemberExpression\n};\n\nvar processAmdDefinition = function processAmdDefinition(path) {\n    var _extractDependencyAnd = (0, _astUtils.extractDependencyAndFactory)(path),\n        factory = _extractDependencyAnd.factory;\n\n    var dependencyMap = (0, _astUtils.extractDependencyMap)(path);\n\n    if (dependencyMap.exports) {\n        (0, _astUtils.removeExportsDependency)(path);\n        var state = {\n            scope: dependencyMap.exports,\n            dependencies: Object.values(dependencyMap),\n            exports: []\n        };\n        factory.traverse(functionBodyVisitor, state);\n        var returnStatement = t.objectExpression(state.exports);\n\n        if (state.defaultExport) {\n            returnStatement = state.defaultExport;\n\n            if (state.exports.length > 0) {\n                returnStatement = t.callExpression(t.memberExpression(t.identifier('Object'), t.identifier('assign')), [state.defaultExport, t.objectExpression(state.exports)]);\n            }\n        }\n\n        factory.get('body').pushContainer('body', t.returnStatement(returnStatement));\n    }\n};\n\nvar programVisitor = {\n    ExpressionStatement: function ExpressionStatement(path) {\n        var amdModule = (0, _astUtils.findAmdModule)(path);\n\n        if (amdModule) {\n            processAmdDefinition(amdModule);\n        }\n    }\n};\n\nfunction _default() {\n    return {\n        visitor: {\n            Program: {\n                exit: function exit(path) {\n                    path.traverse(programVisitor);\n                }\n            }\n        }\n    };\n}","Magento_PageBuilder/ts/babel/plugin-amd-to-magento-amd/ast-utils.js":"/* jscs:disable */\n/* eslint-disable */\n\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n\"use strict\";\n\nexports.__esModule = true;\nexports.extractDependencyAndFactory = extractDependencyAndFactory;\nexports.findAmdModule = findAmdModule;\nexports.extractDependencyMap = extractDependencyMap;\nexports.removeExportsDependency = removeExportsDependency;\nexports.isEsModulePropertyDefinition = isEsModulePropertyDefinition;\nexports.isObjectAssignment = isObjectAssignment;\nexports.isVoidExpression = isVoidExpression;\nexports.isInteropRequireCall = isInteropRequireCall;\nexports.isInteropRequireDefinition = isInteropRequireDefinition;\n\nvar t = _interopRequireWildcard(require(\"@babel/types\"));\n\nfunction _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }\n\nvar INTEROP_FUNCTION_NAME = '_interopRequire';\n\nvar findExpression = function findExpression(path) {\n    if (!t.isExpressionStatement(path.node)) {\n        return false;\n    }\n\n    return path.get('expression');\n};\n\nvar isObjectProperty = function isObjectProperty(path, objectName, propertyName) {\n    return t.isMemberExpression(path) && path.get('object').isIdentifier(t.identifier(objectName)) && path.get('property').isIdentifier(t.identifier(propertyName));\n};\n\nfunction extractDependencyAndFactory(path) {\n    var args = path.node.arguments;\n    var dependencies = path.get(\"arguments.\" + (args.length - 2));\n    var factory = path.get(\"arguments.\" + (args.length - 1));\n    return {\n        dependencies: dependencies,\n        factory: factory\n    };\n}\n\nfunction findAmdModule(path) {\n    if (!path.parentPath.isProgram()) {\n        return false;\n    }\n\n    var expression = findExpression(path);\n\n    if (!expression || !t.isCallExpression(expression) || !t.isIdentifier(expression.node.callee, {\n        name: 'define'\n    })) {\n        return false;\n    }\n\n    var _extractDependencyAnd = extractDependencyAndFactory(expression),\n        dependencies = _extractDependencyAnd.dependencies,\n        factory = _extractDependencyAnd.factory;\n\n    if (dependencies && factory) {\n        return expression;\n    }\n\n    return false;\n}\n\nfunction extractDependencyMap(path) {\n    var dependencyMap = {};\n\n    var _extractDependencyAnd2 = extractDependencyAndFactory(path),\n        dependencies = _extractDependencyAnd2.dependencies,\n        factory = _extractDependencyAnd2.factory;\n\n    var dependencyList = dependencies.node.elements;\n    var factoryParams = factory.node.params;\n    dependencyList.forEach(function (dependency, index) {\n        if (factoryParams[index]) {\n            dependencyMap[dependency.value] = factoryParams[index];\n        }\n    });\n    return dependencyMap;\n}\n\nfunction removeExportsDependency(path) {\n    var _extractDependencyAnd3 = extractDependencyAndFactory(path),\n        dependencies = _extractDependencyAnd3.dependencies,\n        factory = _extractDependencyAnd3.factory;\n\n    var dependencyMap = extractDependencyMap(path);\n\n    if (!dependencyMap.exports) {\n        return;\n    }\n\n    dependencies.node.elements = dependencies.node.elements.filter(function (item) {\n        return !t.isStringLiteral(item, {\n            value: 'exports'\n        });\n    });\n    factory.node.params = factory.node.params.filter(function (item) {\n        return !t.isIdentifier(item, dependencyMap.exports);\n    });\n}\n\nfunction isEsModulePropertyDefinition(path, scope) {\n    var callExpression = findExpression(path);\n    var callee = callExpression.get('callee');\n    var callArguments = callExpression.node.arguments;\n    var isObjectDefinePropertyCall = isObjectProperty(callee, 'Object', 'defineProperty');\n\n    if (isObjectDefinePropertyCall) {\n        var isEsModulePropertyInArguments = t.isStringLiteral(callArguments[1], {\n            value: '__esModule'\n        });\n        var isInScope = t.isIdentifier(callArguments[0], scope);\n        return isEsModulePropertyInArguments && isInScope;\n    }\n\n    return false;\n}\n\nfunction isObjectAssignment(path, objectId) {\n    var expression = t.isAssignmentExpression(path) ? path : findExpression(path);\n    var isMemberAssignment = t.isAssignmentExpression(expression) && t.isMemberExpression(expression.get('left'));\n\n    if (isMemberAssignment) {\n        return t.isNodesEquivalent(expression.get('left.object').node, objectId);\n    }\n\n    return false;\n}\n\nfunction isVoidExpression(path) {\n    return t.isUnaryExpression(path) && path.node.operator === 'void';\n}\n\nfunction isInteropRequireCall(path) {\n    var expression = findExpression(path);\n    var isAssignmentCall = t.isAssignmentExpression(expression) && t.isCallExpression(expression.get('right'));\n\n    if (isAssignmentCall) {\n        var callee = expression.get('right.callee');\n        return callee.isIdentifier() && callee.node.name.indexOf(INTEROP_FUNCTION_NAME) === 0;\n    }\n\n    return false;\n}\n\nfunction isInteropRequireDefinition(path) {\n    if (t.isFunction(path) && path.node.id) {\n        return path.node.id.name.indexOf(INTEROP_FUNCTION_NAME) === 0;\n    }\n\n    return false;\n}","Magento_PageBuilder/ts/babel/plugin-resolve-magento-imports/index.js":"/* jscs:disable */\n/* eslint-disable */\n\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar path = require('path');\n\n/**\n * Convert the relative path imports within TypeScript into absolute paths with pre-fixed module name\n *\n * @returns {{visitor: {ImportDeclaration: visitor.ImportDeclaration}}}\n */\nmodule.exports = function () {\n    'use strict';\n\n    return {\n        visitor: {\n            /**\n             * Convert ../../utils/util import into Magento_Module/js/utils/util\n             *\n             * @param {Object} importPath\n             * @param {Object} state\n             * @constructor\n             */\n            ImportDeclaration: function (importPath, state) {\n                var importExpression = importPath.node.source.value;\n\n                if (!state.opts.prefix) {\n                    throw Error('Prefix must be defined');\n                }\n\n                // Is the file being imported from another directory?\n                if (!path.isAbsolute(importExpression) && importExpression.includes('./')) {\n                    importPath.node.source.value = path.resolve(\n                        path.dirname(state.file.opts.filename.replace(\n                            state.opts.path,\n                            \"\"\n                        )),\n                        importExpression\n                    ).replace(\n                        process.cwd(),\n                        state.opts.prefix.replace(/\\/+$/, '')\n                    );\n                }\n            }\n        }\n    };\n};\n","Magento_Checkout/js/model/default-post-code-resolver.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([], function () {\n    'use strict';\n\n    /**\n     * Define necessity of using default post code value\n     */\n    var useDefaultPostCode;\n\n    return {\n        /**\n         * Resolve default post code\n         *\n         * @returns {String|null}\n         */\n        resolve: function () {\n            return useDefaultPostCode ?  window.checkoutConfig.defaultPostcode : null;\n        },\n\n        /**\n         * Set state to useDefaultPostCode variable\n         *\n         * @param {Boolean} shouldUseDefaultPostCode\n         * @returns {underscore}\n         */\n        setUseDefaultPostCode: function (shouldUseDefaultPostCode) {\n            useDefaultPostCode = shouldUseDefaultPostCode;\n\n            return this;\n        }\n    };\n});\n","Magento_Catalog/js/price-options.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'mage/template',\n    'priceUtils',\n    'priceBox',\n    'jquery-ui-modules/widget'\n], function ($, _, mageTemplate, utils) {\n    'use strict';\n\n    var globalOptions = {\n        productId: null,\n        priceHolderSelector: '.price-box', //data-role=\"priceBox\"\n        optionsSelector: '.product-custom-option',\n        optionConfig: {},\n        optionHandlers: {},\n        optionTemplate: '<%= data.label %>' +\n        '<% if (data.finalPrice.value > 0) { %>' +\n        ' +<%- data.finalPrice.formatted %>' +\n        '<% } else if (data.finalPrice.value < 0) { %>' +\n        ' <%- data.finalPrice.formatted %>' +\n        '<% } %>',\n        controlContainer: 'dd'\n    };\n\n    /**\n     * Custom option preprocessor\n     * @param  {jQuery} element\n     * @param  {Object} optionsConfig - part of config\n     * @return {Object}\n     */\n    function defaultGetOptionValue(element, optionsConfig) {\n        var changes = {},\n            optionValue = element.val(),\n            optionId = utils.findOptionId(element[0]),\n            optionName = element.prop('name'),\n            optionType = element.prop('type'),\n            optionConfig = optionsConfig[optionId],\n            optionHash = optionName;\n\n        switch (optionType) {\n            case 'text':\n            case 'textarea':\n                changes[optionHash] = optionValue ? optionConfig.prices : {};\n                break;\n\n            case 'radio':\n                if (element.is(':checked')) {\n                    changes[optionHash] = optionConfig[optionValue] && optionConfig[optionValue].prices || {};\n                }\n                break;\n\n            case 'select-one':\n                changes[optionHash] = optionConfig[optionValue] && optionConfig[optionValue].prices || {};\n                break;\n\n            case 'select-multiple':\n                _.each(optionConfig, function (row, optionValueCode) {\n                    optionHash = optionName + '##' + optionValueCode;\n                    changes[optionHash] = _.contains(optionValue, optionValueCode) ? row.prices : {};\n                });\n                break;\n\n            case 'checkbox':\n                optionHash = optionName + '##' + optionValue;\n                changes[optionHash] = element.is(':checked') ? optionConfig[optionValue].prices : {};\n                break;\n\n            case 'file':\n                // Checking for 'disable' property equal to checking DOMNode with id*=\"change-\"\n                changes[optionHash] = optionValue || element.prop('disabled') ? optionConfig.prices : {};\n                break;\n        }\n\n        return changes;\n    }\n\n    $.widget('mage.priceOptions', {\n        options: globalOptions,\n\n        /**\n         * @private\n         */\n        _init: function initPriceBundle() {\n            $(this.options.optionsSelector, this.element).trigger('change');\n        },\n\n        /**\n         * Widget creating method.\n         * Triggered once.\n         * @private\n         */\n        _create: function createPriceOptions() {\n            var form = this.element,\n                options = $(this.options.optionsSelector, form),\n                priceBox = $(this.options.priceHolderSelector, $(this.options.optionsSelector).element);\n\n            if (priceBox.data('magePriceBox') &&\n                priceBox.priceBox('option') &&\n                priceBox.priceBox('option').priceConfig\n            ) {\n                if (priceBox.priceBox('option').priceConfig.optionTemplate) {\n                    this._setOption('optionTemplate', priceBox.priceBox('option').priceConfig.optionTemplate);\n                }\n                this._setOption('priceFormat', priceBox.priceBox('option').priceConfig.priceFormat);\n            }\n\n            this._applyOptionNodeFix(options);\n\n            options.on('change', this._onOptionChanged.bind(this));\n        },\n\n        /**\n         * Custom option change-event handler\n         * @param {Event} event\n         * @private\n         */\n        _onOptionChanged: function onOptionChanged(event) {\n            var changes,\n                option = $(event.target),\n                handler = this.options.optionHandlers[option.data('role')];\n\n            option.data('optionContainer', option.closest(this.options.controlContainer));\n\n            if (handler && handler instanceof Function) {\n                changes = handler(option, this.options.optionConfig, this);\n            } else {\n                changes = defaultGetOptionValue(option, this.options.optionConfig);\n            }\n            $(this.options.priceHolderSelector).trigger('updatePrice', changes);\n        },\n\n        /**\n         * Helper to fix issue with option nodes:\n         *  - you can't place any html in option ->\n         *    so you can't style it via CSS\n         * @param {jQuery} options\n         * @private\n         */\n        _applyOptionNodeFix: function applyOptionNodeFix(options) {\n            var config = this.options,\n                format = config.priceFormat,\n                template = config.optionTemplate;\n\n            template = mageTemplate(template);\n            options.filter('select').each(function (index, element) {\n                var $element = $(element),\n                    optionId = utils.findOptionId($element),\n                    optionConfig = config.optionConfig && config.optionConfig[optionId];\n\n                $element.find('option').each(function (idx, option) {\n                    var $option,\n                        optionValue,\n                        toTemplate,\n                        prices;\n\n                    $option = $(option);\n                    optionValue = $option.val();\n\n                    if (!optionValue && optionValue !== 0) {\n                        return;\n                    }\n\n                    toTemplate = {\n                        data: {\n                            label: optionConfig[optionValue] && optionConfig[optionValue].name\n                        }\n                    };\n                    prices = optionConfig[optionValue] ? optionConfig[optionValue].prices : null;\n\n                    if (prices) {\n                        _.each(prices, function (price, type) {\n                            var value = +price.amount;\n\n                            value += _.reduce(price.adjustments, function (sum, x) { //eslint-disable-line\n                                return sum + x;\n                            }, 0);\n                            toTemplate.data[type] = {\n                                value: value,\n                                formatted: utils.formatPrice(value, format)\n                            };\n                        });\n\n                        $option.text(template(toTemplate));\n                    }\n                });\n            });\n        },\n\n        /**\n         * Custom behavior on getting options:\n         * now widget able to deep merge accepted configuration with instance options.\n         * @param  {Object}  options\n         * @return {$.Widget}\n         * @private\n         */\n        _setOptions: function setOptions(options) {\n            $.extend(true, this.options, options);\n            this._super(options);\n\n            return this;\n        }\n    });\n\n    return $.mage.priceOptions;\n});\n","Magento_Catalog/js/price-option-file.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.priceOptionFile', {\n        options: {\n            fileName: '',\n            fileNamed: '',\n            fieldNameAction: '',\n            changeFileSelector: '',\n            deleteFileSelector: ''\n        },\n\n        /**\n         * Creates instance of widget\n         * @private\n         */\n        _create: function () {\n            this.fileDeleteFlag = this.fileChangeFlag = false;\n            this.inputField = this.element.find('input[name=' + this.options.fileName + ']')[0];\n            this.inputFieldAction = this.element.find('input[name=' + this.options.fieldNameAction + ']')[0];\n            this.fileNameSpan = this.element.parent('dd').find('.' + this.options.fileNamed);\n\n            $(this.options.changeFileSelector).on('click', $.proxy(function () {\n                this._toggleFileChange();\n            }, this));\n            $(this.options.deleteFileSelector).on('click', $.proxy(function () {\n                this._toggleFileDelete();\n            }, this));\n        },\n\n        /**\n         * Toggles whether the current file is being changed or not. If the file is being deleted\n         * then the option to change the file is disabled.\n         * @private\n         */\n        _toggleFileChange: function () {\n            this.element.toggle();\n            this.fileChangeFlag = !this.fileChangeFlag;\n\n            if (!this.fileDeleteFlag) {\n                $(this.inputFieldAction).attr('value', this.fileChangeFlag ? 'save_new' : 'save_old');\n                this.inputField.disabled = !this.fileChangeFlag;\n            }\n        },\n\n        /**\n         * Toggles whether the file is to be deleted. When the file is being deleted, the name of\n         * the file is decorated with strike-through text and the option to change the file is\n         * disabled.\n         * @private\n         */\n        _toggleFileDelete: function () {\n            this.fileDeleteFlag = $(this.options.deleteFileSelector + ':checked').val();\n            $(this.inputFieldAction).attr('value',\n                this.fileDeleteFlag ? '' : this.fileChangeFlag ? 'save_new' : 'save_old');\n            this.inputField.disabled = this.fileDeleteFlag || !this.fileChangeFlag;\n            this.fileNameSpan.css('text-decoration', this.fileDeleteFlag ? 'line-through' : 'none');\n        }\n    });\n\n    return $.mage.priceOptionFile;\n});\n","Magento_Catalog/js/price-option-date.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'priceUtils',\n    'priceOptions',\n    'jquery-ui-modules/widget'\n], function ($, utils) {\n    'use strict';\n\n    var globalOptions = {\n            fromSelector: 'form',\n            dropdownsSelector: '[data-role=calendar-dropdown]'\n        },\n        optionHandler = {};\n\n    optionHandler.optionHandlers = {};\n\n    /**\n     * Custom handler for Date-with-Dropdowns option type.\n     * @param  {jQuery} siblings\n     * @return {Function} function that return object { optionHash : optionAdditionalPrice }\n     */\n    function onCalendarDropdownChange(siblings) {\n        return function (element, optionConfig) {\n            var changes = {},\n                optionId = utils.findOptionId(element),\n                overhead = optionConfig[optionId].prices,\n                isNeedToUpdate = true,\n                optionHash = 'price-option-calendar-' + optionId;\n\n            siblings.each(function (index, el) {\n                isNeedToUpdate = isNeedToUpdate && !!$(el).val();\n            });\n\n            overhead = isNeedToUpdate ? overhead : {};\n            changes[optionHash] = overhead;\n\n            return changes;\n        };\n    }\n\n    /**\n     * Returns number of days for special month and year\n     * @param  {Number} month\n     * @param  {Number} year\n     * @return {Number}\n     */\n    function getDaysInMonth(month, year) {\n        return new Date(year, month, 0).getDate();\n    }\n\n    /**\n     * Adjusts the number of days in the day option element based on which month or year\n     * is selected (changed). Adjusts the days to 28, 29, 30, or 31 typically.\n     * @param {jQuery} dropdowns\n     */\n    function onDateChange(dropdowns) {\n        var daysNodes,\n            curMonth, curYear, expectedDays,\n            options, needed,\n            month = dropdowns.filter('[data-calendar-role=month]'),\n            year = dropdowns.filter('[data-calendar-role=year]');\n\n        if (month.length && year.length) {\n            daysNodes = dropdowns.filter('[data-calendar-role=day]').find('option');\n\n            curMonth = month.val() || '01';\n            curYear = year.val() || '2000';\n            expectedDays = getDaysInMonth(curMonth, curYear);\n\n            if (daysNodes.length - 1 > expectedDays) { // remove unnecessary option nodes\n                daysNodes.each(function (i, e) {\n                    if (e.value > expectedDays) {\n                        $(e).remove();\n                    }\n                });\n            } else if (daysNodes.length - 1 < expectedDays) { // add missing option nodes\n                options = [];\n                needed = expectedDays - daysNodes.length + 1;\n\n                while (needed--) { //eslint-disable-line max-depth\n                    options.push(\n                        '<option value=\"' + (expectedDays - needed) + '\">' + (expectedDays - needed) + '</option>'\n                    );\n                }\n                $(options.join('')).insertAfter(daysNodes.last());\n            }\n        }\n    }\n\n    $.widget('mage.priceOptionDate', {\n        options: globalOptions,\n\n        /**\n         * Function-initializer of priceOptionDate widget\n         * @private\n         */\n        _create: function initOptionDate() {\n            var field = this.element,\n                form = field.closest(this.options.fromSelector),\n                dropdowns = $(this.options.dropdownsSelector, field),\n                dateOptionId;\n\n            if (dropdowns.length) {\n                dateOptionId = this.options.dropdownsSelector + dropdowns.attr('name');\n\n                optionHandler.optionHandlers[dateOptionId] = onCalendarDropdownChange(dropdowns);\n\n                form.priceOptions(optionHandler);\n\n                dropdowns.data('role', dateOptionId);\n                dropdowns.on('change', onDateChange.bind(this, dropdowns));\n            }\n        }\n    });\n\n    return $.mage.priceOptionDate;\n});\n","Magento_Catalog/js/product-gallery.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore',\n    'mage/template',\n    'uiRegistry',\n    'jquery/ui',\n    'baseImage'\n], function ($, _, mageTemplate, registry) {\n    'use strict';\n\n    /**\n     * Formats incoming bytes value to a readable format.\n     *\n     * @param {Number} bytes\n     * @returns {String}\n     */\n    function bytesToSize(bytes) {\n        var sizes = ['Bytes', 'KB', 'MB', 'GB', 'TB'],\n            i;\n\n        if (bytes === 0) {\n            return '0 Byte';\n        }\n\n        i = window.parseInt(Math.floor(Math.log(bytes) / Math.log(1024)));\n\n        return Math.round(bytes / Math.pow(1024, i), 2) + ' ' + sizes[i];\n    }\n\n    /**\n     * Product gallery widget\n     */\n    $.widget('mage.productGallery', {\n        options: {\n            imageSelector: '[data-role=image]',\n            imageElementSelector: '[data-role=image-element]',\n            template: '[data-template=image]',\n            imageResolutionLabel: '[data-role=resolution]',\n            imgTitleSelector: '[data-role=img-title]',\n            imageSizeLabel: '[data-role=size]',\n            types: null,\n            initialized: false\n        },\n\n        /**\n         * Gallery creation\n         * @protected\n         */\n        _create: function () {\n            this.options.types = this.options.types || this.element.data('types');\n            this.options.images = this.options.images || this.element.data('images');\n            this.options.parentComponent = this.options.parentComponent || this.element.data('parent-component');\n\n            this.imgTmpl = mageTemplate(this.element.find(this.options.template).html().trim());\n\n            this._bind();\n\n            $.each(this.options.images, $.proxy(function (index, imageData) {\n                this.element.trigger('addItem', imageData);\n            }, this));\n\n            this.options.initialized = true;\n        },\n\n        /**\n         * Bind handler to elements\n         * @protected\n         */\n        _bind: function () {\n            this._on({\n                updateImageTitle: '_updateImageTitle',\n                updateVisibility: '_updateVisibility',\n                openDialog: '_onOpenDialog',\n                addItem: '_addItem',\n                removeItem: '_removeItem',\n                setImageType: '_setImageType',\n                setPosition: '_setPosition',\n                resort: '_resort',\n\n                /**\n                 * @param {jQuery.Event} event\n                 */\n                'mouseup [data-role=delete-button]': function (event) {\n                    var $imageContainer;\n\n                    event.preventDefault();\n                    $imageContainer = $(event.currentTarget).closest(this.options.imageSelector);\n                    this.element.find('[data-role=dialog]').trigger('close');\n                    this.element.trigger('removeItem', $imageContainer.data('imageData'));\n                },\n\n                /**\n                 * @param {jQuery.Event} event\n                 */\n                'mouseup [data-role=make-base-button]': function (event) {\n                    var $imageContainer,\n                        imageData;\n\n                    event.preventDefault();\n                    event.stopImmediatePropagation();\n                    $imageContainer = $(event.currentTarget).closest(this.options.imageSelector);\n                    imageData = $imageContainer.data('imageData');\n                    this.setBase(imageData);\n                }\n            });\n\n            this.element.sortable({\n                distance: 8,\n                items: this.options.imageSelector,\n                tolerance: 'pointer',\n                cancel: 'input, button, .uploader',\n                update: $.proxy(function () {\n                    this.element.trigger('resort');\n                }, this)\n            });\n        },\n\n        /**\n         * Set image as main\n         * @param {Object} imageData\n         * @private\n         */\n        setBase: function (imageData) {\n            var baseImage = this.options.types.image,\n                sameImages = $.grep(\n                    $.map(this.options.types, function (el) {\n                        return el;\n                    }),\n                    function (el) {\n                        return el.value === baseImage.value;\n                    }\n                ),\n                isImageOpened = this.findElement(imageData).hasClass('active');\n\n            $.each(sameImages, $.proxy(function (index, image) {\n                this.element.trigger('setImageType', {\n                    type: image.code,\n                    imageData: imageData\n                });\n\n                if (isImageOpened) {\n                    this.element.find('.item').addClass('selected');\n                    this.element.find('[data-role=type-selector]').prop({\n                        'checked': true\n                    });\n                }\n            }, this));\n        },\n\n        /**\n         * Find element by fileName\n         * @param {Object} data\n         * @returns {Element}\n         */\n        findElement: function (data) {\n            return this.element.find(this.options.imageSelector).filter(function () {\n                return $(this).data('imageData').file === data.file;\n            }).first();\n        },\n\n        /**\n         * Mark parent fieldset that content was updated\n         */\n        _contentUpdated: function () {\n            if (this.options.initialized && this.options.parentComponent) {\n                registry.async(this.options.parentComponent)(\n                    function (parentComponent) {\n                        parentComponent.bubble('update', true);\n                    }\n                );\n            }\n        },\n\n        /**\n         * Add image\n         * @param {jQuery.Event} event\n         * @param {Object} imageData\n         * @private\n         */\n        _addItem: function (event, imageData) {\n            var count = this.element.find(this.options.imageSelector).length,\n                element,\n                imgElement,\n                position = count + 1,\n                lastElement = this.element.find(this.options.imageSelector + ':last');\n\n            if (lastElement.length === 1) {\n                position = parseInt(lastElement.data('imageData').position || count, 10) + 1;\n            }\n            imageData = $.extend({\n                'file_id': imageData['value_id'] ? imageData['value_id'] : Math.random().toString(33).substr(2, 18),\n                'disabled': imageData.disabled ? imageData.disabled : 0,\n                'position': position,\n                sizeLabel: bytesToSize(imageData.size)\n            }, imageData);\n\n            element = this.imgTmpl({\n                data: imageData\n            });\n\n            element = $(element).data('imageData', imageData);\n\n            if (count === 0) {\n                element.prependTo(this.element);\n            } else {\n                element.insertAfter(lastElement);\n            }\n\n            if (!this.options.initialized &&\n                this.options.images.length === 0 ||\n                this.options.initialized &&\n                this.element.find(this.options.imageSelector + ':not(.removed)').length === 1\n            ) {\n                this.setBase(imageData);\n            }\n\n            imgElement = element.find(this.options.imageElementSelector);\n\n            imgElement.on('load', this._updateImageDimesions.bind(this, element));\n\n            $.each(this.options.types, $.proxy(function (index, image) {\n                if (imageData.file === image.value) {\n                    this.element.trigger('setImageType', {\n                        type: image.code,\n                        imageData: imageData\n                    });\n                }\n            }, this));\n\n            this._updateImagesRoles();\n            this._contentUpdated();\n        },\n\n        /**\n         * Returns a list of current images.\n         *\n         * @returns {jQueryCollection}\n         */\n        _getImages: function () {\n            return this.element.find(this.options.imageSelector);\n        },\n\n        /**\n         * Returns a list of images roles.\n         *\n         * @return {Object}\n         */\n        _getRoles: function () {\n            return _.mapObject(this.options.types, function (data, key) {\n                var elem = this.element.find('.image-' + key);\n\n                return {\n                    index: key,\n                    value: elem.val(),\n                    elem: elem\n                };\n            }, this);\n        },\n\n        /**\n         * Updates labels with roles information for each image.\n         */\n        _updateImagesRoles: function () {\n            var $images = this._getImages().toArray(),\n                roles = this._getRoles();\n\n            $images.forEach(function (img) {\n                var $img = $(img),\n                    data = $img.data('imageData');\n\n                $img.find('[data-role=roles-labels] li').each(function (index, elem) {\n                    var $elem = $(elem),\n                        roleCode = $elem.data('roleCode'),\n                        role = roles[roleCode];\n\n                    role.value === data.file  ?\n                        $elem.show() :\n                        $elem.hide();\n                });\n\n            });\n        },\n\n        /**\n         * Updates image's dimensions information.\n         *\n         * @param {jQeuryCollection} imgContainer\n         */\n        _updateImageDimesions: function (imgContainer) {\n            var $img = imgContainer.find(this.options.imageElementSelector)[0],\n                $dimens = imgContainer.find('[data-role=image-dimens]');\n\n            $dimens.text($img.naturalWidth + 'x' + $img.naturalHeight + ' px');\n        },\n\n        /**\n         *\n         * @param {jQuery.Event} event\n         * @param {Object} data\n         */\n        _updateImageTitle: function (event, data) {\n            var imageData = data.imageData,\n                $imgContainer = this.findElement(imageData),\n                $title = $imgContainer.find(this.options.imgTitleSelector),\n                value;\n\n            value = imageData['media_type'] === 'external-video' ?\n                imageData['video_title'] :\n                imageData.label;\n\n            $title.text(value);\n\n            this._contentUpdated();\n        },\n\n        /**\n         * Remove Image\n         * @param {jQuery.Event} event\n         * @param {Object} imageData\n         * @private\n         */\n        _removeItem: function (event, imageData) {\n            var $imageContainer = this.findElement(imageData);\n\n            imageData.isRemoved = true;\n            $imageContainer.addClass('removed').hide().find('.is-removed').val(1);\n\n            this._contentUpdated();\n        },\n\n        /**\n         * Set image type\n         * @param {jQuery.Event} event\n         * @param {Obejct} data\n         * @private\n         */\n        _setImageType: function (event, data) {\n            if (data.type === 'image') {\n                this.element.find('.base-image').removeClass('base-image');\n            }\n\n            if (data.imageData) {\n                this.options.types[data.type].value = data.imageData.file;\n\n                if (data.type === 'image') {\n                    this.findElement(data.imageData).addClass('base-image');\n                }\n            } else {\n                this.options.types[data.type].value = 'no_selection';\n            }\n            this.element.find('.image-' + data.type).val(this.options.types[data.type].value || 'no_selection');\n            this._updateImagesRoles();\n            this._contentUpdated();\n        },\n\n        /**\n         * Resort images\n         * @private\n         */\n        _resort: function () {\n            this.element.find('.position').each($.proxy(function (index, element) {\n                var value = $(element).val();\n\n                if (value != index) { //eslint-disable-line eqeqeq\n                    this.element.trigger('moveElement', {\n                        imageData: $(element).closest(this.options.imageSelector).data('imageData'),\n                        position: index\n                    });\n                    $(element).val(index);\n                }\n            }, this));\n\n            this._contentUpdated();\n        },\n\n        /**\n         * Set image position\n         * @param {jQuery.Event} event\n         * @param {Object} data\n         * @private\n         */\n        _setPosition: function (event, data) {\n            var $element = this.findElement(data.imageData),\n                curIndex = this.element.find(this.options.imageSelector).index($element),\n                newPosition = data.position + (curIndex > data.position ? -1 : 0);\n\n            if (data.position != curIndex) { //eslint-disable-line eqeqeq\n                if (data.position === 0) {\n                    this.element.prepend($element);\n                } else {\n                    $element.insertAfter(\n                        this.element.find(this.options.imageSelector).eq(newPosition)\n                    );\n                }\n                this.element.trigger('resort');\n            }\n\n            this._contentUpdated();\n        }\n    });\n\n    // Extension for mage.productGallery - Add advanced settings block\n    $.widget('mage.productGallery', $.mage.productGallery, {\n        options: {\n            dialogTemplate: '[data-role=img-dialog-tmpl]',\n            dialogContainerTmpl: '[data-role=img-dialog-container-tmpl]'\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            var template = this.element.find(this.options.dialogTemplate),\n                containerTmpl = this.element.find(this.options.dialogContainerTmpl);\n\n            this._super();\n            this.modalPopupInit = false;\n\n            if (template.length) {\n                this.dialogTmpl = mageTemplate(template.html().trim());\n            }\n\n            if (containerTmpl.length) {\n                this.dialogContainerTmpl = mageTemplate(containerTmpl.html().trim());\n            } else {\n                this.dialogContainerTmpl = mageTemplate('');\n            }\n\n            this._initDialog();\n        },\n\n        /**\n         * Bind handler to elements\n         * @protected\n         */\n        _bind: function () {\n            var events = {};\n\n            this._super();\n\n            events['click [data-role=close-panel]'] = $.proxy(function () {\n                this.element.find('[data-role=dialog]').trigger('close');\n            }, this);\n\n            /**\n             * @param {jQuery.Event} event\n             */\n            events['click ' + this.options.imageSelector] = function (event) {\n                var imageData, $imageContainer;\n\n                if (!$(event.currentTarget).is('.ui-sortable-helper')) {\n                    $(event.currentTarget).addClass('active');\n                    imageData = $(event.currentTarget).data('imageData');\n                    $imageContainer = this.findElement(imageData);\n\n                    if ($imageContainer.is('.removed')) {\n                        return;\n                    }\n                    this.element.trigger('openDialog', [imageData]);\n                }\n            };\n            this._on(events);\n            this.element.on('sortstart', $.proxy(function () {\n                this.element.find('[data-role=dialog]').trigger('close');\n            }, this));\n        },\n\n        /**\n         * Initializes dialog element.\n         */\n        _initDialog: function () {\n            var $dialog = $(this.dialogContainerTmpl());\n\n            $dialog.modal({\n                'type': 'slide',\n                title: $.mage.__('Image Detail'),\n                buttons: [],\n\n                /** @inheritdoc */\n                opened: function () {\n                    $dialog.trigger('open');\n                },\n\n                /** @inheritdoc */\n                closed: function () {\n                    $dialog.trigger('close');\n                }\n            });\n\n            $dialog.on('open', this.onDialogOpen.bind(this));\n            $dialog.on('close', function () {\n                var $imageContainer = $dialog.data('imageContainer');\n\n                $imageContainer.removeClass('active');\n                $dialog.find('#hide-from-product-page').remove();\n            });\n\n            $dialog.on('change', '[data-role=type-selector]', function () {\n                var parent = $(this).closest('.item'),\n                    selectedClass = 'selected';\n\n                parent.toggleClass(selectedClass, $(this).prop('checked'));\n            });\n\n            $dialog.on('change', '[data-role=type-selector]', $.proxy(this._notifyType, this));\n\n            $dialog.on('change', '[data-role=visibility-trigger]', $.proxy(function (e) {\n                var imageData = $dialog.data('imageData');\n\n                this.element.trigger('updateVisibility', {\n                    disabled: $(e.currentTarget).is(':checked'),\n                    imageData: imageData\n                });\n            }, this));\n\n            $dialog.on('change', '[data-role=\"image-description\"]', function (e) {\n                var target = $(e.target),\n                    targetName = target.attr('name'),\n                    desc = target.val(),\n                    imageData = $dialog.data('imageData');\n\n                this.element.find('input[type=\"hidden\"][name=\"' + targetName + '\"]').val(desc);\n\n                imageData.label = desc;\n                imageData['label_default'] = desc;\n\n                this.element.trigger('updateImageTitle', {\n                    imageData: imageData\n                });\n            }.bind(this));\n\n            this.$dialog = $dialog;\n        },\n\n        /**\n         * @param {Object} imageData\n         * @private\n         */\n        _showDialog: function (imageData) {\n            var $imageContainer = this.findElement(imageData),\n                $template;\n\n            $template = this.dialogTmpl({\n                'data': imageData\n            });\n\n            this.$dialog\n                .html($template)\n                .data('imageData', imageData)\n                .data('imageContainer', $imageContainer)\n                .modal('openModal');\n        },\n\n        /**\n         * Handles dialog open event.\n         *\n         * @param {EventObject} event\n         */\n        onDialogOpen: function (event) {\n            var imageData = this.$dialog.data('imageData'),\n                imageSizeKb = imageData.sizeLabel,\n                image = document.createElement('img'),\n                sizeSpan = this.$dialog.find(this.options.imageSizeLabel)\n                    .find('[data-message]'),\n                resolutionSpan = this.$dialog.find(this.options.imageResolutionLabel)\n                    .find('[data-message]'),\n                sizeText = sizeSpan.attr('data-message').replace('{size}', imageSizeKb),\n                resolutionText;\n\n            image.src = imageData.url;\n\n            resolutionText = resolutionSpan\n                .attr('data-message')\n                .replace('{width}^{height}', image.width + 'x' + image.height);\n\n            sizeSpan.text(sizeText);\n            resolutionSpan.text(resolutionText);\n\n            $(event.target)\n                .find('[data-role=type-selector]')\n                .each($.proxy(function (index, checkbox) {\n                    var $checkbox = $(checkbox),\n                        parent = $checkbox.closest('.item'),\n                        selectedClass = 'selected',\n                        isChecked = this.options.types[$checkbox.val()].value == imageData.file; //eslint-disable-line\n\n                    $checkbox.prop(\n                        'checked',\n                        isChecked\n                    );\n                    parent.toggleClass(selectedClass, isChecked);\n                }, this));\n        },\n\n        /**\n         *\n         * Click by image handler\n         *\n         * @param {jQuery.Event} e\n         * @param {Object} imageData\n         * @private\n         */\n        _onOpenDialog: function (e, imageData) {\n            if (imageData['media_type'] && imageData['media_type'] != 'image') { //eslint-disable-line eqeqeq\n                return;\n            }\n            this._showDialog(imageData);\n        },\n\n        /**\n         * Change visibility\n         *\n         * @param {jQuery.Event} event\n         * * @param {Object} data\n         * @private\n         */\n        _updateVisibility: function (event, data) {\n            var imageData = data.imageData,\n                disabled = +data.disabled,\n                $imageContainer = this.findElement(imageData);\n\n            !!disabled ? //eslint-disable-line no-extra-boolean-cast\n                $imageContainer.addClass('hidden-for-front') :\n                $imageContainer.removeClass('hidden-for-front');\n\n            $imageContainer.find('[name*=\"disabled\"]').val(disabled);\n            imageData.disabled = disabled;\n\n            this._contentUpdated();\n        },\n\n        /**\n         * Set image\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _notifyType: function (event) {\n            var $checkbox = $(event.currentTarget),\n                $imageContainer = $checkbox.closest('[data-role=dialog]').data('imageContainer');\n\n            this.element.trigger('setImageType', {\n                type: $checkbox.val(),\n                imageData: $checkbox.is(':checked') ? $imageContainer.data('imageData') : null\n            });\n\n            this._updateImagesRoles();\n        }\n    });\n\n    return $.mage.productGallery;\n});\n","Magento_Catalog/js/options.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* eslint-disable no-undef */\n// jscs:disable jsDoc\n\ndefine([\n    'jquery',\n    'mage/template',\n    'uiRegistry',\n    'jquery/ui',\n    'prototype',\n    'form',\n    'validation',\n    'mage/translate'\n], function (jQuery, mageTemplate, rg) {\n    'use strict';\n\n    return function (config) {\n        var optionPanel = jQuery('#manage-options-panel'),\n            editForm = jQuery('#edit_form'),\n            attributeOption = {\n                table: $('attribute-options-table'),\n                itemCount: 0,\n                totalItems: 0,\n                rendered: 0,\n                template: mageTemplate('#row-template'),\n                newOptionClass: 'new-option',\n                isReadOnly: config.isReadOnly,\n                add: function (data, render) {\n                    var isNewOption = false,\n                        element;\n\n                    if (typeof data.id == 'undefined') {\n                        data = {\n                            'id': 'option_' + this.itemCount,\n                            'sort_order': this.itemCount + 1,\n                            'rowClasses': this.newOptionClass\n                        };\n                        isNewOption = true;\n                    }\n\n                    if (!data.intype) {\n                        data.intype = this.getOptionInputType();\n                    }\n\n                    element = this.template({\n                        data: data\n                    });\n\n                    if (isNewOption && !this.isReadOnly) {\n                        this.enableNewOptionDeleteButton(data.id);\n                    }\n                    this.itemCount++;\n                    this.totalItems++;\n                    this.elements += element;\n\n                    if (render) {\n                        this.render();\n                        this.updateItemsCountField();\n                    }\n                },\n                remove: function (event) {\n                    var element = $(Event.findElement(event, 'tr')),\n                        elementFlags; // !!! Button already have table parent in safari\n\n                    // Safari workaround\n                    element.ancestors().each(function (parentItem) {\n                        if (parentItem.hasClassName('option-row')) {\n                            element = parentItem;\n                            throw $break;\n                        } else if (parentItem.hasClassName('box')) {\n                            throw $break;\n                        }\n                    });\n\n                    if (element) {\n                        elementFlags = element.getElementsByClassName('delete-flag');\n\n                        if (elementFlags[0]) {\n                            elementFlags[0].value = 1;\n                        }\n\n                        element.addClassName('no-display');\n                        element.addClassName('template');\n                        element.hide();\n                        this.totalItems--;\n                        this.updateItemsCountField();\n                    }\n\n                    if (element.hasClassName(this.newOptionClass)) {\n                        element.remove();\n                    }\n                },\n                updateItemsCountField: function () {\n                    $('option-count-check').value = this.totalItems > 0 ? '1' : '';\n                },\n                enableNewOptionDeleteButton: function (id) {\n                    $$('#delete_button_container_' + id + ' button').each(function (button) {\n                        button.enable();\n                        button.removeClassName('disabled');\n                    });\n                },\n                bindRemoveButtons: function () {\n                    jQuery('#swatch-visual-options-panel').on('click', '.delete-option', this.remove.bind(this));\n                },\n                render: function () {\n                    Element.insert($$('[data-role=options-container]')[0], this.elements);\n                    this.elements = '';\n                },\n                renderWithDelay: function (data, from, step, delay) {\n                    var arrayLength = data.length,\n                        len;\n\n                    for (len = from + step; from < len && from < arrayLength; from++) {\n                        this.add(data[from]);\n                    }\n                    this.render();\n\n                    if (from === arrayLength) {\n                        this.updateItemsCountField();\n                        this.rendered = 1;\n                        jQuery('body').trigger('processStop');\n\n                        return true;\n                    }\n                    setTimeout(this.renderWithDelay.bind(this, data, from, step, delay), delay);\n                },\n                ignoreValidate: function () {\n                    var ignore = '.ignore-validate input, ' +\n                        '.ignore-validate select, ' +\n                        '.ignore-validate textarea';\n\n                    jQuery('#edit_form').data('validator').settings.forceIgnore = ignore;\n                },\n                getOptionInputType: function () {\n                    var optionDefaultInputType = 'radio';\n\n                    if ($('frontend_input') && $('frontend_input').value === 'multiselect') {\n                        optionDefaultInputType = 'checkbox';\n                    }\n\n                    return optionDefaultInputType;\n                }\n            },\n            tableBody = jQuery(),\n            activePanelClass = 'selected-type-options';\n\n        if ($('add_new_option_button')) {\n            Event.observe('add_new_option_button', 'click', attributeOption.add.bind(attributeOption, {}, true));\n        }\n        $('manage-options-panel').on('click', '.delete-option', function (event) {\n            attributeOption.remove(event);\n        });\n\n        optionPanel.on('render', function () {\n            attributeOption.ignoreValidate();\n\n            if (attributeOption.rendered) {\n                return false;\n            }\n            jQuery('body').trigger('processStart');\n            attributeOption.renderWithDelay(config.attributesData, 0, 100, 300);\n            attributeOption.bindRemoveButtons();\n        });\n\n        if (config.isSortable) {\n            jQuery(function ($) {\n                $('[data-role=options-container]').sortable({\n                    distance: 8,\n                    tolerance: 'pointer',\n                    cancel: 'input, button',\n                    axis: 'y',\n                    update: function () {\n                        $('[data-role=options-container] [data-role=order]').each(function (index, element) {\n                            $(element).val(index + 1);\n                        });\n                    }\n                });\n            });\n        }\n        editForm.on('beforeSubmit', function () {\n            var optionContainer = optionPanel.find('table tbody'),\n                optionsValues;\n\n            if (optionPanel.hasClass(activePanelClass)) {\n                optionsValues = jQuery.map(\n                    optionContainer.find('tr'),\n                    function (row) {\n                        return jQuery(row).find('input, select, textarea').serialize();\n                    }\n                );\n                jQuery('<input>')\n                    .attr({\n                        type: 'hidden',\n                        name: 'serialized_options'\n                    })\n                    .val(JSON.stringify(optionsValues))\n                    .prependTo(editForm);\n            }\n            tableBody = optionContainer.detach();\n        });\n        editForm.on('afterValidate.error highlight.validate', function () {\n            if (optionPanel.hasClass(activePanelClass)) {\n                optionPanel.find('table').append(tableBody);\n                jQuery('input[name=\"serialized_options\"]').remove();\n            }\n        });\n        window.attributeOption = attributeOption;\n        window.optionDefaultInputType = attributeOption.getOptionInputType();\n\n        rg.set('manage-options-panel', attributeOption);\n    };\n});\n","Magento_Catalog/js/price-utils.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore'\n], function ($, _) {\n    'use strict';\n\n    var globalPriceFormat = {\n        requiredPrecision: 2,\n        integerRequired: 1,\n        decimalSymbol: ',',\n        groupSymbol: ',',\n        groupLength: ','\n    };\n\n    /**\n     * Repeats {string} {times} times\n     * @param  {String} string\n     * @param  {Number} times\n     * @return {String}\n     */\n    function stringPad(string, times) {\n        return (new Array(times + 1)).join(string);\n    }\n\n    /**\n     * Formatter for price amount\n     * @param  {Number}  amount\n     * @param  {Object}  format\n     * @param  {Boolean} isShowSign\n     * @return {String}              Formatted value\n     */\n    function formatPrice(amount, format, isShowSign) {\n        var s = '',\n            precision, integerRequired, decimalSymbol, groupSymbol, groupLength, pattern, i, pad, j, re, r, am;\n\n        format = _.extend(globalPriceFormat, format);\n\n        // copied from price-option.js | Could be refactored with varien/js.js\n\n        precision = isNaN(format.requiredPrecision = Math.abs(format.requiredPrecision)) ? 2 : format.requiredPrecision;\n        integerRequired = isNaN(format.integerRequired = Math.abs(format.integerRequired)) ? 1 : format.integerRequired;\n        decimalSymbol = format.decimalSymbol === undefined ? ',' : format.decimalSymbol;\n        groupSymbol = format.groupSymbol === undefined ? '.' : format.groupSymbol;\n        groupLength = format.groupLength === undefined ? 3 : format.groupLength;\n        pattern = format.pattern || '%s';\n\n        if (isShowSign === undefined || isShowSign === true) {\n            s = amount < 0 ? '-' : isShowSign ? '+' : '';\n        } else if (isShowSign === false) {\n            s = '';\n        }\n        pattern = pattern.indexOf('{sign}') < 0 ? s + pattern : pattern.replace('{sign}', s);\n\n        // we're avoiding the usage of to fixed, and using round instead with the e representation to address\n        // numbers like 1.005 = 1.01. Using ToFixed to only provide trailing zeroes in case we have a whole number\n        i = parseInt(\n                amount = Number(Math.round(Math.abs(+amount || 0) + 'e+' + precision) + ('e-' + precision)),\n                10\n            ) + '';\n        pad = i.length < integerRequired ? integerRequired - i.length : 0;\n\n        i = stringPad('0', pad) + i;\n\n        j = i.length > groupLength ? i.length % groupLength : 0;\n        re = new RegExp('(\\\\d{' + groupLength + '})(?=\\\\d)', 'g');\n\n        // replace(/-/, 0) is only for fixing Safari bug which appears\n        // when Math.abs(0).toFixed() executed on '0' number.\n        // Result is '0.-0' :(\n\n        am = Number(Math.round(Math.abs(amount - i) + 'e+' + precision) + ('e-' + precision));\n        r = (j ? i.substr(0, j) + groupSymbol : '') +\n            i.substr(j).replace(re, '$1' + groupSymbol) +\n            (precision ? decimalSymbol + am.toFixed(precision).replace(/-/, 0).slice(2) : '');\n\n        return pattern.replace('%s', r).replace(/^\\s\\s*/, '').replace(/\\s\\s*$/, '');\n    }\n\n    /**\n     * Deep clone of Object. Doesn't support functions\n     * @param {Object} obj\n     * @return {Object}\n     */\n    function objectDeepClone(obj) {\n        return JSON.parse(JSON.stringify(obj));\n    }\n\n    /**\n     * Helper to find ID in name attribute\n     * @param   {jQuery} element\n     * @returns {undefined|String}\n     */\n    function findOptionId(element) {\n        var re, id, name;\n\n        if (!element) {\n            return id;\n        }\n        name = $(element).attr('name');\n\n        if (name.indexOf('[') !== -1) {\n            re = /\\[([^\\]]+)?\\]/;\n        } else {\n            re = /_([^\\]]+)?_/; // just to support file-type-option\n        }\n        id = re.exec(name) && re.exec(name)[1];\n\n        if (id) {\n            return id;\n        }\n    }\n\n    return {\n        formatPrice: formatPrice,\n        deepClone: objectDeepClone,\n        strPad: stringPad,\n        findOptionId: findOptionId\n    };\n});\n","Magento_Catalog/js/bundle-proxy-button.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n * @deprecated since version 2.2.0\n */\ndefine([\n    'Magento_Ui/js/form/components/button',\n    'uiRegistry',\n    'underscore'\n], function (Button, registry, _) {\n    'use strict';\n\n    return Button.extend({\n        defaults: {\n            currentRecordNamespace: 'bundle_current_record',\n            listingDataProvider: '',\n            value: [],\n            imports: {\n                currentRecordName: '${ $.provider }:${ $.currentRecordNamespace }',\n                listingData: '${ $.provider }:${ $.listingDataProvider }'\n            },\n            links: {\n                value: '${ $.provider }:${ $.dataScope }'\n            },\n            listens: {\n                listingData: 'setListingData'\n            }\n        },\n\n        /**\n         * Initializes component.\n         *\n         * @returns {Object} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .initSource();\n\n            return this;\n        },\n\n        /**\n         * Calls 'initObservable' of parent\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'value',\n                    'listingData'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Calls 'destroy' of parent and\n         * clear listing provider source\n         *\n         * @returns {Object} Chainable.\n         */\n        destroy: function () {\n            this._super();\n            this.source.set(this.listingDataProvider, []);\n\n            return this;\n        },\n\n        /**\n         * Call parent \"action\" method\n         * and set new data to record and listing.\n         *\n         * @returns {Object} Chainable.\n         */\n\n        action: function () {\n            this._super();\n            this.source.set(this.currentRecordNamespace, this.name);\n            this.source.set(this.listingDataProvider, this.value());\n\n            return this;\n        },\n\n        /**\n         * Init current source.\n         *\n         * @returns {Object} Chainable.\n         */\n        initSource: function () {\n            if (!_.isFunction(this.source)) {\n                this.source = registry.get(this.provider);\n            }\n\n            return this;\n        },\n\n        /**\n         * Set data to listing source.\n         *\n         * @returns {Object} Chainable.\n         */\n        setListingData: function (data) {\n            if (this.name === this.currentRecordName) {\n                this.source.set(this.dataScope, data);\n            }\n\n            return this;\n        }\n    });\n});\n","Magento_Catalog/js/category-tree.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mageUtils',\n    'jquery/ui',\n    'jquery/jstree/jquery.jstree'\n], function ($, utils) {\n    'use strict';\n\n    $.widget('mage.categoryTree', {\n        options: {\n            url: '',\n            data: [],\n            tree: {\n                plugins: ['themes', 'json_data', 'ui', 'hotkeys'],\n                themes: {\n                    theme: 'default',\n                    dots: false,\n                    icons: true\n                }\n            }\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            var options = this.options,\n                treeOptions = $.extend(\n                    true,\n                    {},\n                    options.tree,\n                    {\n                        'json_data': {\n                            ajax: {\n                                url: options.url,\n                                type: 'POST',\n                                success: $.proxy(function (nodes) {\n                                    return this._convertDataNodes(nodes);\n                                }, this),\n\n                                /**\n                                 * @param {HTMLElement} node\n                                 * @return {Object}\n                                 */\n                                data: function (node) {\n                                    return {\n                                        id: $(node).data('id'),\n                                        'form_key': window.FORM_KEY\n                                    };\n                                }\n                            },\n                            data: this._convertData(options.data).children,\n                            'progressive_render': true\n                        }\n                    }\n                );\n\n            this.element.jstree(treeOptions);\n            this.element.on('select_node.jstree', $.proxy(this._selectNode, this));\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @param {Object} data\n         * @private\n         */\n        _selectNode: function (event, data) {\n            var node = data.rslt.obj.data();\n\n            if (!node.disabled) {\n                window.location = window.location + '/' + node.id;\n            } else {\n                event.preventDefault();\n            }\n        },\n\n        /**\n         * @param {Array} nodes\n         * @returns {Array}\n         * @private\n         */\n        _convertDataNodes: function (nodes) {\n            var nodesData = [];\n\n            nodes.forEach(function (node) {\n                nodesData.push(this._convertData(node));\n            }, this);\n\n            return nodesData;\n        },\n\n        /**\n         * @param {Object} node\n         * @return {*}\n         * @private\n         */\n        _convertData: function (node) {\n            var self = this,\n                result;\n\n            if (!node) {\n                return result;\n            }\n            result = {\n                data: {\n                    title: utils.unescape(node.name) + ' (' + node['product_count'] + ')'\n                },\n                attr: {\n                    'class': node.cls + (!!node.disabled ? ' disabled' : '') //eslint-disable-line no-extra-boolean-cast\n                },\n                metadata: {\n                    id: node.id,\n                    disabled: node.disabled\n                }\n            };\n\n            if (node['children_count'] && !node.expanded) {\n                result.state = 'closed';\n            } else {\n                result.state = 'open';\n            }\n\n            if (node.children) {\n                result.children = [];\n                $.each(node.children, function () {\n                    result.children.push(self._convertData(this));\n                });\n            }\n\n            return result;\n        }\n    });\n\n    return $.mage.categoryTree;\n});\n","Magento_Catalog/js/new-category-dialog.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @deprecated since version 2.2.0\n */\n/*global FORM_KEY*/\ndefine([\n    'jquery',\n    'jquery/ui',\n    'Magento_Ui/js/modal/modal',\n    'mage/translate',\n    'mage/backend/tree-suggest',\n    'mage/backend/validation'\n], function ($) {\n    'use strict';\n\n    /** Clear parent category. */\n    var clearParentCategory = function () {\n        $('#new_category_parent').find('option').each(function () {\n            $('#new_category_parent-suggest').treeSuggest('removeOption', null, this);\n        });\n    };\n\n    $.widget('mage.newCategoryDialog', {\n        /** @inheritdoc */\n        _create: function () {\n            var widget = this,\n                newCategoryForm;\n\n            $('#new_category_parent').before($('<input>', {\n                id: 'new_category_parent-suggest',\n                placeholder: $.mage.__('start typing to search category')\n            }));\n\n            $('#new_category_parent-suggest').treeSuggest(this.options.suggestOptions)\n                .on('suggestbeforeselect', function (event) {\n                    clearParentCategory();\n                    $(event.target).treeSuggest('close');\n                });\n\n            $.validator.addMethod('validate-parent-category', function () {\n                return $('#new_category_parent').val() || $('#new_category_parent-suggest').val() === '';\n            }, $.mage.__('Choose existing category.'));\n            newCategoryForm = $('#new_category_form');\n            newCategoryForm.mage('validation', {\n                /**\n                 * @param {jQuery} error\n                 * @param {*} element\n                 */\n                errorPlacement: function (error, element) {\n                    error.insertAfter(element.is('#new_category_parent') ?\n                        $('#new_category_parent-suggest').closest('.mage-suggest') :\n                        element);\n                }\n            }).on('highlight.validate', function (e) {\n                var options = $(this).validation('option');\n\n                if ($(e.target).is('#new_category_parent')) {\n                    options.highlight($('#new_category_parent-suggest').get(0),\n                        options.errorClass, options.validClass || '');\n                }\n            });\n            this.element.modal({\n                type: 'slide',\n                modalClass: 'mage-new-category-dialog form-inline',\n                title: $.mage.__('Create Category'),\n\n                /** @inheritdoc */\n                opened: function () {\n                    var enteredName = $('#category_ids-suggest').val();\n\n                    $('#new_category_name').val(enteredName);\n\n                    if (enteredName === '') {\n                        $('#new_category_name').focus();\n                    }\n                    $('#new_category_messages').html('');\n                },\n\n                /** @inheritdoc */\n                closed: function () {\n                    var validationOptions = newCategoryForm.validation('option');\n\n                    $('#new_category_name, #new_category_parent-suggest').val('');\n                    validationOptions.unhighlight($('#new_category_parent-suggest').get(0),\n                        validationOptions.errorClass, validationOptions.validClass || '');\n                    newCategoryForm.validation('clearError');\n                    $('#category_ids-suggest').focus();\n                },\n                buttons: [{\n                    text: $.mage.__('Create Category'),\n                    class: 'action-primary',\n\n                    /** @inheritdoc */\n                    click: function (e) {\n                        var thisButton;\n\n                        if (!newCategoryForm.valid()) {\n                            return;\n                        }\n                        thisButton = $(e.currentTarget);\n\n                        thisButton.prop('disabled', true);\n                        $.ajax({\n                            type: 'POST',\n                            url: widget.options.saveCategoryUrl,\n                            data: {\n                                name: $('#new_category_name').val(),\n                                parent: $('#new_category_parent').val(),\n                                'is_active': 1,\n                                'include_in_menu': 1,\n                                'use_config': ['available_sort_by', 'default_sort_by'],\n                                'form_key': FORM_KEY,\n                                'return_session_messages_only': 1\n                            },\n                            dataType: 'json',\n                            context: $('body')\n                        }).done(function (data) {\n                            var $suggest;\n\n                            if (!data.error) {\n                                $suggest = $('#category_ids-suggest');\n\n                                $suggest.trigger('selectItem', {\n                                    id: data.category['entity_id'],\n                                    label: data.category.name\n                                });\n                                $('#new_category_name, #new_category_parent-suggest').val('');\n                                $suggest.val('');\n                                clearParentCategory();\n                                $(widget.element).modal('closeModal');\n                            } else {\n                                $('#new_category_messages').html(data.messages);\n                            }\n                        }).always(\n                            function () {\n                                thisButton.prop('disabled', false);\n                            }\n                        );\n                    }\n                }]\n            });\n        }\n    });\n\n    return $.mage.newCategoryDialog;\n});\n","Magento_Catalog/js/custom-options.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/template',\n    'Magento_Ui/js/modal/alert',\n    'jquery/ui',\n    'useDefault',\n    'collapsable',\n    'mage/translate',\n    'mage/backend/validation',\n    'Magento_Ui/js/modal/modal'\n], function ($, mageTemplate, alert) {\n    'use strict';\n\n    $.widget('mage.customOptions', {\n        options: {\n            selectionItemCount: {}\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this.baseTmpl = mageTemplate('#custom-option-base-template');\n            this.rowTmpl = mageTemplate('#custom-option-select-type-row-template');\n\n            this._initOptionBoxes();\n            this._initSortableSelections();\n            this._bindCheckboxHandlers();\n            this._bindReadOnlyMode();\n            this._addValidation();\n        },\n\n        /**\n         * @private\n         */\n        _addValidation: function () {\n            $.validator.addMethod(\n                'required-option-select', function (value) {\n                    return value !== '';\n                }, $.mage.__('Select type of option.'));\n\n            $.validator.addMethod(\n                'required-option-select-type-rows', function (value, element) {\n                    var optionContainerElm = element.up('div[id*=_type_]'),\n                        selectTypesFlag = false,\n                        selectTypeElements = $('#' + optionContainerElm.id + ' .select-type-title');\n\n                    selectTypeElements.each(function () {\n                        if (!$(this).closest('tr').hasClass('ignore-validate')) {\n                            selectTypesFlag = true;\n                        }\n                    });\n\n                    return selectTypesFlag;\n                }, $.mage.__('Please add rows to option.'));\n        },\n\n        /**\n         * @private\n         */\n        _initOptionBoxes: function () {\n            var syncOptionTitle;\n\n            if (!this.options.isReadonly) {\n                this.element.sortable({\n                    axis: 'y',\n                    handle: '[data-role=draggable-handle]',\n                    items: '#product_options_container_top > div',\n                    update: this._updateOptionBoxPositions,\n                    tolerance: 'pointer'\n                });\n            }\n\n            /**\n             * @param {jQuery.Event} event\n             */\n            syncOptionTitle = function (event) {\n                var currentValue = $(event.target).val(),\n                    optionBoxTitle = $(\n                        '.admin__collapsible-title > span',\n                        $(event.target).closest('.fieldset-wrapper')\n                    ),\n                    newOptionTitle = $.mage.__('New Option');\n\n                optionBoxTitle.text(currentValue === '' ? newOptionTitle : currentValue);\n            };\n            this._on({\n                /**\n                 * Reset field value to Default\n                 */\n                'click .use-default-label': function (event) {\n                    $(event.target).closest('label').find('input').prop('checked', true).trigger('change');\n                },\n\n                /**\n                 * Remove custom option or option row for 'select' type of custom option\n                 */\n                'click button[id^=product_option_][id$=_delete]': function (event) {\n                    var element = $(event.target).closest('#product_options_container_top > div.fieldset-wrapper,tr');\n\n                    if (element.length) {\n                        $('#product_' + element.attr('id').replace('product_', '') + '_is_delete').val(1);\n                        element.addClass('ignore-validate').hide();\n                        this.refreshSortableElements();\n                    }\n                },\n\n                /**\n                 * Minimize custom option block\n                 */\n                'click #product_options_container_top [data-target$=-content]': function () {\n                    if (this.options.isReadonly) {\n                        return false;\n                    }\n                },\n\n                /**\n                 * Add new custom option\n                 */\n                'click #add_new_defined_option': function (event) {\n                    this.addOption(event);\n                },\n\n                /**\n                 * Add new option row for 'select' type of custom option\n                 */\n                'click button[id^=product_option_][id$=_add_select_row]': function (event) {\n                    this.addSelection(event);\n                },\n\n                /**\n                 * Import custom options from products\n                 */\n                'click #import_new_defined_option': function () {\n                    var importContainer = $('#import-container'),\n                        widget = this;\n\n                    importContainer.modal({\n                        title: $.mage.__('Select Product'),\n                        type: 'slide',\n\n                        /** @inheritdoc */\n                        opened: function () {\n                            $(document).off().on('click', '#productGrid_massaction-form button', function () {\n                                $('.import-custom-options-apply-button').trigger('click', 'massActionTrigger');\n                            });\n                        },\n                        buttons: [{\n                            text: $.mage.__('Import'),\n                            attr: {\n                                id: 'import-custom-options-apply-button'\n                            },\n                            'class': 'action-primary action-import import-custom-options-apply-button',\n\n                            /** @inheritdoc */\n                            click: function (event, massActionTrigger) {\n                                var request = [];\n\n                                $(this.element).find('input[name=product]:checked').map(function () {\n                                    request.push(this.value);\n                                });\n\n                                if (request.length === 0) {\n                                    if (!massActionTrigger) {\n                                        alert({\n                                            content: $.mage.__('An item needs to be selected. Select and try again.')\n                                        });\n                                    }\n\n                                    return;\n                                }\n\n                                $.post(widget.options.customOptionsUrl, {\n                                    'products[]': request,\n                                    'form_key': widget.options.formKey\n                                }, function ($data) {\n                                    $.parseJSON($data).each(function (el) {\n                                        var i;\n\n                                        el.id = widget.getFreeOptionId(el.id);\n                                        el['option_id'] = el.id;\n\n                                        if (typeof el.optionValues !== 'undefined') {\n                                            for (i = 0; i < el.optionValues.length; i++) {\n                                                el.optionValues[i]['option_id'] = el.id;\n                                            }\n                                        }\n                                        //Adding option\n                                        widget.addOption(el);\n                                        //Will save new option on server side\n                                        $('#product_option_' + el.id + '_option_id').val(0);\n                                        $('#option_' + el.id + ' input[name$=\"option_type_id]\"]').val(-1);\n                                    });\n                                    importContainer.modal('closeModal');\n                                });\n                            }\n                        }]\n                    });\n                    importContainer.load(\n                        this.options.productGridUrl,\n                        {\n                            'form_key': this.options.formKey,\n                            'current_product_id': this.options.currentProductId\n                        },\n                        function () {\n                            importContainer.modal('openModal');\n                        }\n                    );\n                },\n\n                /**\n                 * Change custom option type\n                 */\n                'change select[id^=product_option_][id$=_type]': function (event, data) {\n                    var widget = this,\n                        currentElement = $(event.target),\n                        parentId = '#' + currentElement.closest('.fieldset-alt').attr('id'),\n                        group = currentElement.find('[value=\"' + currentElement.val() + '\"]')\n                            .closest('optgroup').attr('data-optgroup-name'),\n                        previousGroup = $(parentId + '_previous_group').val(),\n                        previousBlock = $(parentId + '_type_' + previousGroup),\n                        tmpl, disabledBlock, priceType;\n\n                    data = data || {};\n\n                    if (typeof group !== 'undefined') {\n                        group = group.toLowerCase();\n                    }\n\n                    if (previousGroup !== group) {\n                        if (previousBlock.length) {\n                            previousBlock.addClass('ignore-validate').hide();\n                        }\n                        $(parentId + '_previous_group').val(group);\n\n                        if (typeof group === 'undefined') {\n                            return;\n                        }\n                        disabledBlock = $(parentId).find(parentId + '_type_' + group);\n\n                        if (disabledBlock.length) {\n                            disabledBlock.removeClass('ignore-validate').show();\n                        } else {\n                            if ($.isEmptyObject(data)) { //eslint-disable-line max-depth\n                                data['option_id'] = $(parentId + '_id').val();\n                                data.price = data.sku = '';\n                            }\n                            data.group = group;\n\n                            tmpl = widget.element.find('#custom-option-' + group + '-type-template').html();\n                            tmpl = mageTemplate(tmpl, {\n                                data: data\n                            });\n\n                            $(tmpl).insertAfter($(parentId));\n\n                            if (data['price_type']) { //eslint-disable-line max-depth\n                                priceType = $('#' + widget.options.fieldId + '_' + data['option_id'] + '_price_type');\n                                priceType.val(data['price_type']).attr('data-store-label', data['price_type']);\n                            }\n                            this._bindUseDefault(widget.options.fieldId + '_' + data['option_id'], data);\n                            //Add selections\n\n                            if (data.optionValues) { //eslint-disable-line max-depth\n                                data.optionValues.each(function (value) {\n                                    widget.addSelection(value);\n                                });\n                            }\n                        }\n                    }\n                },\n                //Sync title\n                'change .field-option-title > .control > input[id$=\"_title\"]': syncOptionTitle,\n                'keyup .field-option-title > .control > input[id$=\"_title\"]': syncOptionTitle,\n                'paste .field-option-title > .control > input[id$=\"_title\"]': syncOptionTitle\n            });\n        },\n\n        /**\n         * @private\n         */\n        _initSortableSelections: function () {\n            if (!this.options.isReadonly) {\n                this.element.find('[id^=product_option_][id$=_type_select] tbody').sortable({\n                    axis: 'y',\n                    handle: '[data-role=draggable-handle]',\n\n                    /** @inheritdoc */\n                    helper: function (event, ui) {\n                        ui.children().each(function () {\n                            $(this).width($(this).width());\n                        });\n\n                        return ui;\n                    },\n                    update: this._updateSelectionsPositions,\n                    tolerance: 'pointer'\n                });\n            }\n        },\n\n        /**\n         * Sync sort order checkbox with hidden dropdown\n         */\n        _bindCheckboxHandlers: function () {\n            this._on({\n                /**\n                 * @param {jQuery.Event} event\n                 */\n                'change [id^=product_option_][id$=_required]': function (event) {\n                    var $this = $(event.target);\n\n                    $this.closest('#product_options_container_top > div')\n                        .find('[name$=\"[is_require]\"]').val($this.is(':checked') ? 1 : 0);\n                }\n            });\n            this.element.find('[id^=product_option_][id$=_required]').each(function () {\n                $(this).prop('checked', $(this).closest('#product_options_container_top > div')\n                        .find('[name$=\"[is_require]\"]').val() > 0);\n            });\n        },\n\n        /**\n         * Update Custom option position\n         */\n        _updateOptionBoxPositions: function () {\n            $(this).find('div[id^=option_]:not(.ignore-validate) .fieldset-alt > [name$=\"[sort_order]\"]').each(\n                function (index) {\n                    $(this).val(index);\n                });\n        },\n\n        /**\n         * Update selections positions for 'select' type of custom option\n         */\n        _updateSelectionsPositions: function () {\n            $(this).find('tr:not(.ignore-validate) [name$=\"[sort_order]\"]').each(function (index) {\n                $(this).val(index);\n            });\n        },\n\n        /**\n         * Disable input data if \"Read Only\"\n         */\n        _bindReadOnlyMode: function () {\n            if (this.options.isReadonly) {\n                $('div.product-custom-options').find('button,input,select,textarea').each(function () {\n                    $(this).prop('disabled', true);\n\n                    if ($(this).is('button')) {\n                        $(this).addClass('disabled');\n                    }\n                });\n            }\n        },\n\n        /**\n         * @param {String} id\n         * @param {Object} data\n         * @private\n         */\n        _bindUseDefault: function (id, data) {\n            var title = $('#' + id + '_title'),\n                price = $('#' + id + '_price'),\n                priceType = $('#' + id + '_price_type');\n\n            //enable 'use default' link for title\n            if (data.checkboxScopeTitle) {\n                title.useDefault({\n                    field: '.field',\n                    useDefault: 'label[for$=_title]',\n                    checkbox: 'input[id$=_title_use_default]',\n                    label: 'span'\n                });\n            }\n            //enable 'use default' link for price and price_type\n            if (data.checkboxScopePrice) {\n                price.useDefault({\n                    field: '.field',\n                    useDefault: 'label[for$=_price]',\n                    checkbox: 'input[id$=_price_use_default]',\n                    label: 'span'\n                });\n                //not work set default value for second field\n                priceType.useDefault({\n                    field: '.field',\n                    useDefault: 'label[for$=_price]',\n                    checkbox: 'input[id$=_price_use_default]',\n                    label: 'span'\n                });\n            }\n        },\n\n        /**\n         * Add selection value for 'select' type of custom option\n         */\n        addSelection: function (event) {\n            var data = {},\n                element = event.target || event.srcElement || event.currentTarget,\n                rowTmpl, priceType;\n\n            if (typeof element !== 'undefined') {\n                data.id = $(element).closest('#product_options_container_top > div')\n                    .find('[name^=\"product[options]\"][name$=\"[id]\"]').val();\n                data['option_type_id'] = -1;\n\n                if (!this.options.selectionItemCount[data.id]) {\n                    this.options.selectionItemCount[data.id] = 1;\n                }\n\n                data['select_id'] = this.options.selectionItemCount[data.id];\n                data.price = data.sku = '';\n            } else {\n                data = event;\n                data.id = data['option_id'];\n                data['select_id'] = data['option_type_id'];\n                this.options.selectionItemCount[data.id] = data['item_count'];\n            }\n\n            rowTmpl = this.rowTmpl({\n                data: data\n            });\n\n            $(rowTmpl).appendTo($('#select_option_type_row_' + data.id));\n\n            //set selected price_type value if set\n            if (data['price_type']) {\n                priceType = $('#' + this.options.fieldId + '_' + data.id + '_select_' + data['select_id'] +\n                    '_price_type');\n                priceType.val(data['price_type']).attr('data-store-label', data['price_type']);\n            }\n\n            this._bindUseDefault(this.options.fieldId + '_' + data.id + '_select_' + data['select_id'], data);\n            this.refreshSortableElements();\n            this.options.selectionItemCount[data.id] = parseInt(this.options.selectionItemCount[data.id], 10) + 1;\n\n            $('#' + this.options.fieldId + '_' + data.id + '_select_' + data['select_id'] + '_title').focus();\n        },\n\n        /**\n         * Add custom option\n         */\n        addOption: function (event) {\n            var data = {},\n                element = event.target || event.srcElement || event.currentTarget,\n                baseTmpl;\n\n            if (typeof element !== 'undefined') {\n                data.id = this.options.itemCount;\n                data.type = '';\n                data['option_id'] = 0;\n            } else {\n                data = event;\n                this.options.itemCount = data['item_count'];\n            }\n\n            baseTmpl = this.baseTmpl({\n                data: data\n            });\n\n            $(baseTmpl)\n                .appendTo(this.element.find('#product_options_container_top'))\n                .find('.collapse').collapsable();\n\n            //set selected type value if set\n            if (data.type) {\n                $('#' + this.options.fieldId + '_' + data.id + '_type').val(data.type).trigger('change', data);\n            }\n\n            //set selected is_require value if set\n            if (data['is_require']) {\n                $('#' + this.options.fieldId + '_' + data.id + '_is_require').val(data['is_require']).trigger('change');\n            }\n\n            this.refreshSortableElements();\n            this._bindCheckboxHandlers();\n            this._bindReadOnlyMode();\n            this.options.itemCount++;\n            $('#' + this.options.fieldId + '_' + data.id + '_title').trigger('change');\n        },\n\n        /**\n         * @return {Object}\n         */\n        refreshSortableElements: function () {\n            if (!this.options.isReadonly) {\n                this.element.sortable('refresh');\n                this._updateOptionBoxPositions.apply(this.element);\n                this._updateSelectionsPositions.apply(this.element);\n                this._initSortableSelections();\n            }\n\n            return this;\n        },\n\n        /**\n         * @param {String} id\n         * @return {*}\n         */\n        getFreeOptionId: function (id) {\n            return $('#' + this.options.fieldId + '_' + id).length ? this.getFreeOptionId(parseInt(id, 10) + 1) : id;\n        }\n    });\n\n});\n","Magento_Catalog/js/price-box.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'Magento_Catalog/js/price-utils',\n    'underscore',\n    'mage/template',\n    'jquery-ui-modules/widget'\n], function ($, utils, _, mageTemplate) {\n    'use strict';\n\n    var globalOptions = {\n        productId: null,\n        priceConfig: null,\n        prices: {},\n        priceTemplate: '<span class=\"price\"><%- data.formatted %></span>'\n    };\n\n    $.widget('mage.priceBox', {\n        options: globalOptions,\n        qtyInfo: '#qty',\n\n        /**\n         * Widget initialisation.\n         * Every time when option changed prices also can be changed. So\n         * changed options.prices -> changed cached prices -> recalculation -> redraw price box\n         */\n        _init: function initPriceBox() {\n            var box = this.element;\n\n            box.trigger('updatePrice');\n            this.cache.displayPrices = utils.deepClone(this.options.prices);\n        },\n\n        /**\n         * Widget creating.\n         */\n        _create: function createPriceBox() {\n            var box = this.element;\n\n            this.cache = {};\n            this._setDefaultsFromPriceConfig();\n            this._setDefaultsFromDataSet();\n\n            box.on('reloadPrice', this.reloadPrice.bind(this));\n            box.on('updatePrice', this.onUpdatePrice.bind(this));\n            $(this.qtyInfo).on('input', this.updateProductTierPrice.bind(this));\n            box.trigger('price-box-initialized');\n        },\n\n        /**\n         * Call on event updatePrice. Proxy to updatePrice method.\n         * @param {Event} event\n         * @param {Object} prices\n         */\n        onUpdatePrice: function onUpdatePrice(event, prices) {\n            return this.updatePrice(prices);\n        },\n\n        /**\n         * Updates price via new (or additional values).\n         * It expects object like this:\n         * -----\n         *   \"option-hash\":\n         *      \"price-code\":\n         *         \"amount\": 999.99999,\n         *         ...\n         * -----\n         * Empty option-hash object or empty price-code object treats as zero amount.\n         * @param {Object} newPrices\n         */\n        updatePrice: function updatePrice(newPrices) {\n            var prices = this.cache.displayPrices,\n                additionalPrice = {},\n                pricesCode = [],\n                priceValue, origin, finalPrice;\n\n            this.cache.additionalPriceObject = this.cache.additionalPriceObject || {};\n\n            if (newPrices) {\n                $.extend(this.cache.additionalPriceObject, newPrices);\n            }\n\n            if (!_.isEmpty(additionalPrice)) {\n                pricesCode = _.keys(additionalPrice);\n            } else if (!_.isEmpty(prices)) {\n                pricesCode = _.keys(prices);\n            }\n\n            _.each(this.cache.additionalPriceObject, function (additional) {\n                if (additional && !_.isEmpty(additional)) {\n                    pricesCode = _.keys(additional);\n                }\n                _.each(pricesCode, function (priceCode) {\n                    priceValue = additional[priceCode] || {};\n                    priceValue.amount = +priceValue.amount || 0;\n                    priceValue.adjustments = priceValue.adjustments || {};\n\n                    additionalPrice[priceCode] = additionalPrice[priceCode] || {\n                        'amount': 0,\n                        'adjustments': {}\n                    };\n                    additionalPrice[priceCode].amount =  0 + (additionalPrice[priceCode].amount || 0) +\n                        priceValue.amount;\n                    _.each(priceValue.adjustments, function (adValue, adCode) {\n                        additionalPrice[priceCode].adjustments[adCode] = 0 +\n                            (additionalPrice[priceCode].adjustments[adCode] || 0) + adValue;\n                    });\n                });\n            });\n\n            if (_.isEmpty(additionalPrice)) {\n                this.cache.displayPrices = utils.deepClone(this.options.prices);\n            } else {\n                _.each(additionalPrice, function (option, priceCode) {\n                    origin = this.options.prices[priceCode] || {};\n                    finalPrice = prices[priceCode] || {};\n                    option.amount = option.amount || 0;\n                    origin.amount = origin.amount || 0;\n                    origin.adjustments = origin.adjustments || {};\n                    finalPrice.adjustments = finalPrice.adjustments || {};\n\n                    finalPrice.amount = 0 + origin.amount + option.amount;\n                    _.each(option.adjustments, function (pa, paCode) {\n                        finalPrice.adjustments[paCode] = 0 + (origin.adjustments[paCode] || 0) + pa;\n                    });\n                }, this);\n            }\n\n            this.element.trigger('priceUpdated', this.cache.displayPrices);\n            this.element.trigger('reloadPrice');\n        },\n\n        /*eslint-disable no-extra-parens*/\n        /**\n         * Render price unit block.\n         */\n        reloadPrice: function reDrawPrices() {\n            var priceFormat = (this.options.priceConfig && this.options.priceConfig.priceFormat) || {},\n                priceTemplate = mageTemplate(this.options.priceTemplate);\n\n            _.each(this.cache.displayPrices, function (price, priceCode) {\n                price.final = _.reduce(price.adjustments, function (memo, amount) {\n                    return memo + amount;\n                }, price.amount);\n\n                price.formatted = utils.formatPrice(price.final, priceFormat);\n\n                $('[data-price-type=\"' + priceCode + '\"]', this.element).html(priceTemplate({\n                    data: price\n                }));\n            }, this);\n        },\n\n        /*eslint-enable no-extra-parens*/\n        /**\n         * Overwrites initial (default) prices object.\n         * @param {Object} prices\n         */\n        setDefault: function setDefaultPrices(prices) {\n            this.cache.displayPrices = utils.deepClone(prices);\n            this.options.prices = utils.deepClone(prices);\n        },\n\n        /**\n         * Custom behavior on getting options:\n         * now widget able to deep merge of accepted configuration.\n         * @param  {Object} options\n         * @return {mage.priceBox}\n         */\n        _setOptions: function setOptions(options) {\n            $.extend(true, this.options, options);\n\n            if ('disabled' in options) {\n                this._setOption('disabled', options.disabled);\n            }\n\n            return this;\n        },\n\n        /**\n         * setDefaultsFromDataSet\n         */\n        _setDefaultsFromDataSet: function _setDefaultsFromDataSet() {\n            var box = this.element,\n                priceHolders = $('[data-price-type]', box),\n                prices = this.options.prices;\n\n            this.options.productId = box.data('productId');\n\n            if (_.isEmpty(prices)) {\n                priceHolders.each(function (index, element) {\n                    var type = $(element).data('priceType'),\n                        amount = parseFloat($(element).data('priceAmount'));\n\n                    if (type && !_.isNaN(amount)) {\n                        prices[type] = {\n                            amount: amount\n                        };\n                    }\n                });\n            }\n        },\n\n        /**\n         * setDefaultsFromPriceConfig\n         */\n        _setDefaultsFromPriceConfig: function _setDefaultsFromPriceConfig() {\n            var config = this.options.priceConfig;\n\n            if (config && config.prices) {\n                this.options.prices = config.prices;\n            }\n        },\n\n        /**\n         * Updates product final price according to tier prices\n         */\n        updateProductTierPrice: function updateProductTierPrice() {\n            var productQty = $(this.qtyInfo).val(),\n                originalPrice = this.options.prices.finalPrice.amount,\n                tierPrice,\n                prices,\n                i;\n\n            for (i = 0; i < this.options.priceConfig.tierPrices.length; i++) {\n                if (productQty >= this.options.priceConfig.tierPrices[i].qty) {\n                    tierPrice = this.options.priceConfig.tierPrices[i].price;\n                }\n            }\n            prices = {\n                'prices': {\n                    'finalPrice': {\n                        'amount': tierPrice - originalPrice\n                    }\n                }\n            };\n            this.updatePrice(prices);\n        }\n    });\n\n    return $.mage.priceBox;\n});\n","Magento_Catalog/js/custom-options-type.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'uiRegistry',\n    'Magento_Ui/js/form/element/ui-select'\n], function ($, _, registry, UiSelect) {\n    'use strict';\n\n    return UiSelect.extend({\n        defaults: {\n            previousGroup: null,\n            groupsConfig: {},\n            valuesMap: {},\n            indexesMap: {},\n            filterPlaceholder: 'ns = ${ $.ns }, parentScope = ${ $.parentScope }'\n        },\n\n        /**\n         * Initialize component.\n         * @returns {Element}\n         */\n        initialize: function () {\n            return this\n                ._super()\n                .initMapping()\n                .updateComponents(this.initialValue, true);\n        },\n\n        /**\n         * Create additional mappings.\n         *\n         * @returns {Element}\n         */\n        initMapping: function () {\n            _.each(this.groupsConfig, function (groupData, group) {\n                _.each(groupData.values, function (value) {\n                    this.valuesMap[value] = group;\n                }, this);\n\n                _.each(groupData.indexes, function (index) {\n                    if (!this.indexesMap[index]) {\n                        this.indexesMap[index] = [];\n                    }\n\n                    this.indexesMap[index].push(group);\n                }, this);\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Callback that fires when 'value' property is updated.\n         *\n         * @param {String} currentValue\n         * @returns {*}\n         */\n        onUpdate: function (currentValue) {\n            this.updateComponents(currentValue);\n\n            return this._super();\n        },\n\n        /**\n         * Show, hide or clear components based on the current type value.\n         *\n         * @param {String} currentValue\n         * @param {Boolean} isInitialization\n         * @returns {Element}\n         */\n        updateComponents: function (currentValue, isInitialization) {\n            var currentGroup = this.valuesMap[currentValue];\n\n            if (currentGroup !== this.previousGroup) {\n                _.each(this.indexesMap, function (groups, index) {\n                    var template = this.filterPlaceholder + ', index = ' + index,\n                        visible = groups.indexOf(currentGroup) !== -1,\n                        component;\n\n                    switch (index) {\n                        case 'container_type_static':\n                        case 'values':\n                            template = 'ns=' + this.ns +\n                                ', dataScope=' + this.parentScope +\n                                ', index=' + index;\n                            break;\n                    }\n\n                    /*eslint-disable max-depth */\n                    if (isInitialization) {\n                        registry.async(template)(\n                            function (currentComponent) {\n                                currentComponent.visible(visible);\n                            }\n                        );\n                    } else {\n                        component = registry.get(template);\n\n                        if (component) {\n                            component.visible(visible);\n                        }\n                    }\n                }, this);\n\n                this.previousGroup = currentGroup;\n            }\n\n            return this;\n        }\n    });\n});\n","Magento_Catalog/js/edit-tree.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* eslint-disable no-undef */\n// jscs:disable jsDoc\n\nrequire([\n    'jquery',\n    'Magento_Ui/js/modal/confirm',\n    'Magento_Ui/js/modal/alert',\n    'loadingPopup',\n    'mage/backend/floating-header'\n], function (jQuery, confirm) {\n    'use strict';\n\n    /**\n     * Delete some category\n     * This routine get categoryId explicitly, so even if currently selected tree node is out of sync\n     * with this form, we surely delete same category in the tree and at backend.\n     *\n     * @deprecated\n     * @see deleteConfirm\n     */\n    function categoryDelete(url) {\n        confirm({\n            content: 'Are you sure you want to delete this category?',\n            actions: {\n                confirm: function () {\n                    location.href = url;\n                }\n            }\n        });\n    }\n\n    function displayLoadingMask() {\n        jQuery('body').loadingPopup();\n    }\n\n    window.categoryDelete = categoryDelete;\n    window.displayLoadingMask = displayLoadingMask;\n});\n","Magento_Catalog/js/category-checkbox-tree.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global Ext, varienWindowOnload, varienElementMethods */\n\ndefine([\n    'jquery',\n    'prototype',\n    'extjs/ext-tree-checkbox',\n    'mage/adminhtml/form'\n], function (jQuery) {\n    'use strict';\n\n    return function (config) {\n        var tree,\n            options = {\n                dataUrl: config.dataUrl,\n                divId: config.divId,\n                rootVisible: config.rootVisible,\n                useAjax: config.useAjax,\n                currentNodeId: config.currentNodeId,\n                jsFormObject: window[config.jsFormObject],\n                name: config.name,\n                checked: config.checked,\n                allowDrop: config.allowDrop,\n                rootId: config.rootId,\n                expanded: config.expanded,\n                categoryId: config.categoryId,\n                treeJson: config.treeJson\n            },\n            data = {},\n            parameters = {},\n            root = {},\n            key = '';\n\n        /**\n         * Fix ext compatibility with prototype 1.6\n         */\n        Ext.lib.Event.getTarget = function (e) {\n            var ee = e.browserEvent || e;\n\n            return ee.target ? Event.element(ee) : null;\n        };\n\n        /**\n         * @param {Object} el\n         * @param {Object} nodeConfig\n         */\n        Ext.tree.TreePanel.Enhanced = function (el, nodeConfig) {\n            Ext.tree.TreePanel.Enhanced.superclass.constructor.call(this, el, nodeConfig);\n        };\n\n        Ext.extend(Ext.tree.TreePanel.Enhanced, Ext.tree.TreePanel, {\n            /**\n             * @param {Object} treeConfig\n             * @param {Boolean} firstLoad\n             */\n            loadTree: function (treeConfig, firstLoad) {\n                parameters = treeConfig.parameters,\n                    data = treeConfig.data,\n                    root = new Ext.tree.TreeNode(parameters);\n\n                if (typeof parameters.rootVisible !== 'undefined') {\n                    this.rootVisible = parameters.rootVisible * 1;\n                }\n\n                this.nodeHash = {};\n                this.setRootNode(root);\n\n                if (firstLoad) {\n                    this.addListener('click', this.categoryClick.createDelegate(this));\n                }\n\n                this.loader.buildCategoryTree(root, data);\n                this.el.dom.innerHTML = '';\n                // render the tree\n                this.render();\n            },\n\n            /**\n             * @param {Object} node\n             */\n            categoryClick: function (node) {\n                node.getUI().check(!node.getUI().checked());\n            }\n        });\n\n        jQuery(function () {\n            var categoryLoader = new Ext.tree.TreeLoader({\n                dataUrl: config.dataUrl\n            });\n\n            /**\n             * @param {Object} response\n             * @param {Object} parent\n             * @param {Function} callback\n             */\n            categoryLoader.processResponse = function (response, parent, callback) {\n                config = JSON.parse(response.responseText);\n\n                this.buildCategoryTree(parent, config);\n\n                if (typeof callback === 'function') {\n                    callback(this, parent);\n                }\n            };\n\n            /**\n             * @param {Object} nodeConfig\n             * @returns {Object}\n             */\n            categoryLoader.createNode = function (nodeConfig) {\n                var node;\n\n                nodeConfig.uiProvider = Ext.tree.CheckboxNodeUI;\n\n                if (nodeConfig.children && !nodeConfig.children.length) {\n                    delete nodeConfig.children;\n                    node = new Ext.tree.AsyncTreeNode(nodeConfig);\n                } else {\n                    node = new Ext.tree.TreeNode(nodeConfig);\n                }\n\n                return node;\n            };\n\n            /**\n             * @param {Object} parent\n             * @param {Object} nodeConfig\n             * @param {Integer} i\n             */\n            categoryLoader.processCategoryTree = function (parent, nodeConfig, i) {\n                var node,\n                    _node = {};\n\n                nodeConfig[i].uiProvider = Ext.tree.CheckboxNodeUI;\n\n                _node = Object.clone(nodeConfig[i]);\n\n                if (_node.children && !_node.children.length) {\n                    delete _node.children;\n                    node = new Ext.tree.AsyncTreeNode(_node);\n                } else {\n                    node = new Ext.tree.TreeNode(nodeConfig[i]);\n                }\n                parent.appendChild(node);\n                node.loader = node.getOwnerTree().loader;\n\n                if (_node.children) {\n                    categoryLoader.buildCategoryTree(node, _node.children);\n                }\n            };\n\n            /**\n             * @param {Object} parent\n             * @param {Object} nodeConfig\n             * @returns {void}\n             */\n            categoryLoader.buildCategoryTree = function (parent, nodeConfig) {\n                var i = 0;\n\n                if (!nodeConfig) {\n                    return null;\n                }\n\n                if (parent && nodeConfig && nodeConfig.length) {\n                    for (i; i < nodeConfig.length; i++) {\n                        categoryLoader.processCategoryTree(parent, nodeConfig, i);\n                    }\n                }\n            };\n\n            /**\n             *\n             * @param {Object} hash\n             * @param {Object} node\n             * @returns {Object}\n             */\n            categoryLoader.buildHashChildren = function (hash, node) {\n                var i = 0,\n                    len;\n\n                if (node.childNodes.length > 0 || node.loaded === false && node.loading === false) {\n                    hash.children = [];\n\n                    for (i, len = node.childNodes.length; i < len; i++) {\n                        hash.children = hash.children ? hash.children : [];\n                        hash.children.push(this.buildHash(node.childNodes[i]));\n                    }\n                }\n\n                return hash;\n            };\n\n            /**\n             * @param {Object} node\n             * @returns {Object}\n             */\n            categoryLoader.buildHash = function (node) {\n                var hash = {};\n\n                hash = this.toArray(node.attributes);\n\n                return categoryLoader.buildHashChildren(hash, node);\n            };\n\n            /**\n             * @param {Object} attributes\n             * @returns {Object}\n             */\n            categoryLoader.toArray = function (attributes) {\n                data = {};\n\n                for (key in attributes) {\n\n                    if (attributes[key]) {\n                        data[key] = attributes[key];\n                    }\n                }\n\n                return data;\n            };\n\n            categoryLoader.on('beforeload', function (treeLoader, node) {\n                treeLoader.baseParams.id = node.attributes.id;\n                treeLoader.baseParams.selected = options.jsFormObject.updateElement.value;\n            });\n\n            categoryLoader.on('load', function () {\n                varienWindowOnload();\n            });\n\n            tree = new Ext.tree.TreePanel.Enhanced(options.divId, {\n                animate: false,\n                loader: categoryLoader,\n                enableDD: false,\n                containerScroll: true,\n                selModel: new Ext.tree.CheckNodeMultiSelectionModel(),\n                rootVisible: options.rootVisible,\n                useAjax: options.useAjax,\n                currentNodeId: options.currentNodeId,\n                addNodeTo: false,\n                rootUIProvider: Ext.tree.CheckboxNodeUI\n            });\n\n            tree.on('check', function (node) {\n                options.jsFormObject.updateElement.value = this.getChecked().join(', ');\n                varienElementMethods.setHasChanges(node.getUI().checkbox);\n            }, tree);\n\n            // set the root node\n            //jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n            parameters = {\n                text: options.name,\n                draggable: false,\n                checked: options.checked,\n                uiProvider: Ext.tree.CheckboxNodeUI,\n                allowDrop: options.allowDrop,\n                id: options.rootId,\n                expanded: options.expanded,\n                category_id: options.categoryId\n            };\n            //jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n\n            tree.loadTree({\n                parameters: parameters, data: options.treeJson\n            }, true);\n        });\n    };\n});\n","Magento_Catalog/js/tier-price/value-type-select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/select',\n    'uiRegistry',\n    'underscore'\n], function (Select, uiRegistry, _) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            prices: {}\n        },\n\n        /**\n         * {@inheritdoc}\n         */\n        initialize: function () {\n            this._super();\n            delete this.prices.__disableTmpl;\n            this.prepareForm();\n        },\n\n        /**\n         * {@inheritdoc}\n         */\n        setInitialValue: function () {\n            this.initialValue = this.getInitialValue();\n\n            if (this.value.peek() !== this.initialValue) {\n                this.value(this.initialValue);\n            }\n\n            this.isUseDefault(this.disabled());\n\n            return this;\n        },\n\n        /**\n         * {@inheritdoc}\n         */\n        prepareForm: function () {\n            var elements = this.getElementsByPrices(),\n                prices = this.prices,\n                currencyType = _.keys(prices)[0],\n                select = this;\n\n            uiRegistry.get(elements, function () {\n                _.each(arguments, function (currentValue) {\n                    if (parseFloat(currentValue.value()) > 0) {\n                        _.each(prices, function (priceValue, priceKey) {\n                            if (priceValue === currentValue.name) {\n                                currencyType = priceKey;\n                            }\n                        });\n                    }\n                });\n                select.value(currencyType);\n                select.on('value', select.onUpdate.bind(select));\n                select.onUpdate();\n            });\n        },\n\n        /**\n         * @returns {Array}\n         */\n        getElementsByPrices: function () {\n            var elements = [];\n\n            _.each(this.prices, function (currentValue) {\n                elements.push(currentValue);\n            });\n\n            return elements;\n        },\n\n        /**\n         * Callback that fires when 'value' property is updated\n         */\n        onUpdate: function () {\n            var value = this.value(),\n                prices = this.prices,\n                select = this,\n                parentDataScopeArr = this.dataScope.split('.'),\n                parentDataScope,\n                elements = this.getElementsByPrices();\n\n            parentDataScopeArr.pop();\n            parentDataScope = parentDataScopeArr.join('.');\n\n            uiRegistry.get(elements, function () {\n                var sourceData = select.source.get(parentDataScope);\n\n                _.each(arguments, function (currentElement) {\n                    var index;\n\n                    _.each(prices, function (priceValue, priceKey) {\n                        if (priceValue === currentElement.name) {\n                            index = priceKey;\n                        }\n                    });\n\n                    if (value === index) {\n                        currentElement.visible(true);\n                        sourceData[currentElement.index] = currentElement.value();\n                    } else {\n                        currentElement.value('');\n                        currentElement.visible(false);\n                        delete sourceData[currentElement.index];\n                    }\n                });\n                select.source.set(parentDataScope, sourceData);\n            });\n        }\n    });\n});\n","Magento_Catalog/js/tier-price/percentage-processor.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiElement',\n    'underscore',\n    'Magento_Ui/js/lib/view/utils/async',\n    'Magento_Catalog/js/utils/percentage-price-calculator'\n], function (Element, _, $, percentagePriceCalculator) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            priceElem: '${ $.parentName }.price',\n            selector: 'input',\n            imports: {\n                priceValue: '${ $.priceElem }:priceValue'\n            },\n            exports: {\n                calculatedVal: '${ $.priceElem }:value'\n            }\n        },\n\n        /**\n         * {@inheritdoc}\n         */\n        initialize: function () {\n            this._super();\n\n            _.bindAll(this, 'initPriceListener', 'onInput');\n\n            $.async({\n                component: this.priceElem,\n                selector: this.selector\n            }, this.initPriceListener);\n\n            return this;\n        },\n\n        /**\n         * {@inheritdoc}\n         */\n        initObservable: function () {\n            return this._super()\n                .observe(['visible']);\n        },\n\n        /**\n         * Handles keyup event on price input.\n         *\n         * {@param} HTMLElement elem\n         */\n        initPriceListener: function (elem) {\n            $(elem).on('keyup.priceCalc', this.onInput);\n        },\n\n        /**\n         * Delegates calculation of the price input value to percentagePriceCalculator.\n         *\n         * {@param} object event\n         */\n        onInput: function (event) {\n            var value = event.currentTarget.value;\n\n            if (value.slice(-1) === '%') {\n                value = percentagePriceCalculator(this.priceValue, value);\n                this.set('calculatedVal', value);\n            }\n        }\n    });\n});\n","Magento_Catalog/js/form/element/checkbox.js":"/**\r\n * Copyright \u00a9 Magento, Inc. All rights reserved.\r\n * See COPYING.txt for license details.\r\n */\r\n\r\ndefine([\r\n    'Magento_Ui/js/form/element/single-checkbox'\r\n], function (Checkbox) {\r\n    'use strict';\r\n\r\n    return Checkbox.extend({\r\n        defaults: {\r\n            inputCheckBoxName: '',\r\n            prefixElementName: '',\r\n            parentDynamicRowName: 'visual_swatch'\r\n        },\r\n\r\n        /**\r\n         * Parses options and merges the result with instance\r\n         *\r\n         * @returns {Object} Chainable.\r\n         */\r\n        initConfig: function () {\r\n            this._super();\r\n            this.configureDataScope();\r\n\r\n            return this;\r\n        },\r\n\r\n        /** @inheritdoc */\r\n        initialize: function () {\r\n            this._super();\r\n\r\n            if (this.rows && this.rows().elems().length === 0) {\r\n                this.checked(true);\r\n            }\r\n\r\n            return this;\r\n        },\r\n\r\n        /**\r\n         * Configure data scope.\r\n         */\r\n        configureDataScope: function () {\r\n            var recordId,\r\n                value;\r\n\r\n            recordId = this.parentName.split('.').last();\r\n            value = this.prefixElementName + recordId;\r\n\r\n            this.dataScope = 'data.' + this.inputCheckBoxName;\r\n            this.inputName = this.dataScopeToHtmlArray(this.inputCheckBoxName);\r\n\r\n            this.initialValue = value;\r\n\r\n            this.links.value = this.provider + ':' + this.dataScope;\r\n        },\r\n\r\n        /**\r\n         * Get HTML array from data scope.\r\n         *\r\n         * @param {String} dataScopeString\r\n         * @returns {String}\r\n         */\r\n        dataScopeToHtmlArray: function (dataScopeString) {\r\n            var dataScopeArray, dataScope, reduceFunction;\r\n\r\n            /**\r\n             * Add new level of nesting.\r\n             *\r\n             * @param {String} prev\r\n             * @param {String} curr\r\n             * @returns {String}\r\n             */\r\n            reduceFunction = function (prev, curr) {\r\n                return prev + '[' + curr + ']';\r\n            };\r\n\r\n            dataScopeArray = dataScopeString.split('.');\r\n\r\n            dataScope = dataScopeArray.shift();\r\n            dataScope += dataScopeArray.reduce(reduceFunction, '');\r\n\r\n            return dataScope;\r\n        }\r\n    });\r\n});\r\n","Magento_Catalog/js/form/element/action-delete.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'Magento_Ui/js/form/element/abstract'\n], function (_, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            prefixName: '',\n            prefixElementName: '',\n            elementName: '',\n            suffixName: ''\n        },\n\n        /**\n         * Parses options and merges the result with instance\n         *\n         * @param  {Object} config\n         * @returns {Object} Chainable.\n         */\n        initConfig: function (config) {\n            this._super(config);\n\n            this.configureDataScope();\n\n            return this;\n        },\n\n        /**\n         * Configure data scope.\n         */\n        configureDataScope: function () {\n            var recordId,\n                prefixName,\n                suffixName;\n\n            // Get recordId\n            recordId = this.parentName.split('.').last();\n\n            prefixName = this.dataScopeToHtmlArray(this.prefixName);\n            this.elementName = this.prefixElementName + recordId;\n\n            suffixName = '';\n\n            if (!_.isEmpty(this.suffixName) || _.isNumber(this.suffixName)) {\n                suffixName = '[' + this.suffixName + ']';\n            }\n            this.inputName = prefixName + '[' + this.elementName + ']' + suffixName;\n\n            suffixName = '';\n\n            if (!_.isEmpty(this.suffixName) || _.isNumber(this.suffixName)) {\n                suffixName = '.' + this.suffixName;\n            }\n            this.dataScope = 'data.' + this.prefixName + '.' + this.elementName + suffixName;\n\n            this.links.value = this.provider + ':' + this.dataScope;\n        },\n\n        /**\n         * Get HTML array from data scope.\n         *\n         * @param {String} dataScopeString\n         * @returns {String}\n         */\n        dataScopeToHtmlArray: function (dataScopeString) {\n            var dataScopeArray, dataScope, reduceFunction;\n\n            /**\n             * Reduce\n             *\n             * @param {String} prev\n             * @param {String} curr\n             * @returns {String}\n             */\n            reduceFunction = function (prev, curr) {\n                return prev + '[' + curr + ']';\n            };\n\n            dataScopeArray = dataScopeString.split('.');\n\n            dataScope = dataScopeArray.shift();\n            dataScope += dataScopeArray.reduce(reduceFunction, '');\n\n            return dataScope;\n        },\n\n        /**\n         * Delete record instance\n         * update data provider dataScope\n         *\n         * @param {Object} parents\n         */\n        deleteRecord: function (parents) {\n            this.value(1);\n            parents[1].deleteRecord(parents[0].index, parents[0].recordId);\n\n            return this;\n        }\n    });\n});\n","Magento_Catalog/js/form/element/input.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'Magento_Ui/js/form/element/abstract'\n], function (_, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            prefixName: '',\n            prefixElementName: '',\n            elementName: '',\n            suffixName: ''\n        },\n\n        /**\n         * Parses options and merges the result with instance\n         *\n         * @returns {Object} Chainable.\n         */\n        initConfig: function () {\n            this._super();\n            this.configureDataScope();\n\n            return this;\n        },\n\n        /**\n         * Configure data scope.\n         */\n        configureDataScope: function () {\n            var recordId,\n                prefixName,\n                suffixName;\n\n            // Get recordId\n            recordId = this.parentName.split('.').last();\n\n            prefixName = this.dataScopeToHtmlArray(this.prefixName);\n            this.elementName = this.prefixElementName + recordId;\n\n            suffixName = '';\n\n            if (!_.isEmpty(this.suffixName) || _.isNumber(this.suffixName)) {\n                suffixName = '[' + this.suffixName + ']';\n            }\n            this.inputName = prefixName + '[' + this.elementName + ']' + suffixName;\n\n            suffixName = '';\n\n            if (!_.isEmpty(this.suffixName) || _.isNumber(this.suffixName)) {\n                suffixName = '.' + this.suffixName;\n            }\n\n            this.exportDataLink = 'data.' + this.prefixName + '.' + this.elementName + suffixName;\n            this.exports.value = this.provider + ':' + this.exportDataLink;\n        },\n\n        /** @inheritdoc */\n        destroy: function () {\n            this._super();\n\n            this.source.remove(this.exportDataLink);\n        },\n\n        /**\n         * Get HTML array from data scope.\n         *\n         * @param {String} dataScopeString\n         * @returns {String}\n         */\n        dataScopeToHtmlArray: function (dataScopeString) {\n            var dataScopeArray, dataScope, reduceFunction;\n\n            /**\n             * Add new level of nesting.\n             *\n             * @param {String} prev\n             * @param {String} curr\n             * @returns {String}\n             */\n            reduceFunction = function (prev, curr) {\n                return prev + '[' + curr + ']';\n            };\n\n            dataScopeArray = dataScopeString.split('.');\n\n            dataScope = dataScopeArray.shift();\n            dataScope += dataScopeArray.reduce(reduceFunction, '');\n\n            return dataScope;\n        }\n    });\n});\n","Magento_Catalog/js/utils/percentage-price-calculator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine(['Magento_Ui/js/lib/validation/utils'], function (utils) {\n    'use strict';\n\n    /**\n     * Calculates the price input value when entered percentage value.\n     *\n     * @param {String} price\n     * @param {String} input\n     *\n     * @returns {String}\n     */\n    return function (price, input) {\n        var result,\n            lastInputSymbol = input.slice(-1),\n            inputPercent = input.slice(0, -1),\n            parsedPercent = utils.parseNumber(inputPercent),\n            parsedPrice = utils.parseNumber(price);\n\n        if (lastInputSymbol !== '%') {\n            result = input;\n        } else if (\n            input === '%' ||\n            isNaN(parsedPrice) ||\n            parsedPercent != inputPercent || /* eslint eqeqeq:0 */\n            isNaN(parsedPercent) ||\n            input === ''\n        ) {\n            result = '';\n        } else if (parsedPercent > 100) {\n            result = '0.00';\n        } else if (lastInputSymbol === '%') {\n            result = parsedPrice - parsedPrice * (inputPercent / 100);\n            result = result.toFixed(2);\n        } else {\n            result = input;\n        }\n\n        return result;\n    };\n});\n","Magento_Catalog/js/product/learn-more.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'Magento_Catalog/js/product/list/column-status-validator'\n], function (Column, columnStatusValidator) {\n    'use strict';\n\n    return Column.extend({\n        /**\n         * Depends on this option, \"Learn More\" link can be shown or hide. Depends on  backend configuration\n         *\n         * @returns {Boolean}\n         */\n        isAllowed: function () {\n            return columnStatusValidator.isValid(this.source(), 'learn_more', 'show_attributes');\n        }\n    });\n});\n","Magento_Catalog/js/product/weight-handler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    return {\n\n        /**\n         * Get weight\n         * @returns {*|jQuery|HTMLElement}\n         */\n        $weight: function () {\n            return $('#weight');\n        },\n\n        /**\n         * Weight Switcher\n         * @returns {*|jQuery|HTMLElement}\n         */\n        $weightSwitcher: function () {\n            return $('[data-role=weight-switcher]');\n        },\n\n        /**\n         * Weight Change Toggle\n         * @returns {*|jQuery|HTMLElement}\n         */\n        $weightChangeToggle: function () {\n            return $('#toggle_weight');\n        },\n\n        /**\n         * Is locked\n         * @returns {*}\n         */\n        isLocked: function () {\n            return this.$weight().is('[data-locked]');\n        },\n\n        /**\n         * Disabled\n         */\n        disabled: function () {\n            this.$weight().addClass('ignore-validate').prop('disabled', true);\n        },\n\n        /**\n         * Enabled\n         */\n        enabled: function () {\n            this.$weight().removeClass('ignore-validate').prop('disabled', false);\n        },\n\n        /**\n         * Disabled Switcher\n         */\n        disabledSwitcher: function () {\n            this.$weightSwitcher().find('input[type=\"radio\"]').addClass('ignore-validate').prop('disabled', true);\n        },\n\n        /**\n         * Enabled Switcher\n         */\n        enabledSwitcher: function () {\n            this.$weightSwitcher().find('input[type=\"radio\"]').removeClass('ignore-validate').prop('disabled', false);\n        },\n\n        /**\n         * Switch Weight\n         * @returns {*}\n         */\n        switchWeight: function () {\n            if (this.hasWeightChangeToggle()) {\n                return;\n            }\n\n            return this.productHasWeightBySwitcher() ? this.enabled() : this.disabled();\n        },\n\n        /**\n         * Toggle Switcher\n         */\n        toggleSwitcher: function () {\n            this.isWeightChanging() ? this.enabledSwitcher() : this.disabledSwitcher();\n        },\n\n        /**\n         * Hide weight switcher\n         */\n        hideWeightSwitcher: function () {\n            this.$weightSwitcher().hide();\n        },\n\n        /**\n         * Has weight switcher\n         * @returns {*}\n         */\n        hasWeightSwitcher: function () {\n            return this.$weightSwitcher().is(':visible');\n        },\n\n        /**\n         * Has weight\n         * @returns {*}\n         */\n        hasWeight: function () {\n            return this.$weight.is(':visible');\n        },\n\n        /**\n         * Has weight change toggle\n         * @returns {*}\n         */\n        hasWeightChangeToggle: function () {\n            return this.$weightChangeToggle().is(':visible');\n        },\n\n        /**\n         * Product has weight\n         * @returns {Bool}\n         */\n        productHasWeightBySwitcher: function () {\n            return $('input:checked', this.$weightSwitcher()).val() === '1';\n        },\n\n        /**\n         * Product weight toggle is checked\n         * @returns {Bool}\n         */\n        isWeightChanging: function () {\n            return this.$weightChangeToggle().is(':checked');\n        },\n\n        /**\n         * Change\n         * @param {String} data\n         */\n        change: function (data) {\n            var value = data !== undefined ? +data : !this.productHasWeightBySwitcher();\n\n            $('input[value=' + value + ']', this.$weightSwitcher()).prop('checked', true);\n            this.switchWeight();\n        },\n\n        /**\n         * Constructor component\n         */\n        'Magento_Catalog/js/product/weight-handler': function () {\n            this.bindAll();\n\n            if (this.hasWeightSwitcher()) {\n                this.switchWeight();\n            }\n\n            if (this.hasWeightChangeToggle()) {\n                this.toggleSwitcher();\n            }\n        },\n\n        /**\n         * Bind all\n         */\n        bindAll: function () {\n            this.$weightSwitcher().find('input').on('change', this.switchWeight.bind(this));\n        }\n    };\n});\n","Magento_Catalog/js/product/addtocompare-button.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'Magento_Catalog/js/product/uenc-processor',\n    'Magento_Catalog/js/product/list/column-status-validator'\n], function (Column, uencProcessor, columnStatusValidator) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            label: ''\n        },\n\n        /**\n         * Prepare Data-Post data that will be used in data-mage-init\n         *\n         * @param {Object} row\n         * @returns {Array}\n         */\n        getDataPost: function (row) {\n            return uencProcessor(row['add_to_compare_button'].url ||\n                    row['add_to_compare_button']['post_data']);\n        },\n\n        /**\n         * Depends on this option, \"Add to compare\" button can be shown or hide. Depends on  backend configuration\n         *\n         * @returns {Boolean}\n         */\n        isAllowed: function () {\n            return columnStatusValidator.isValid(this.source(), 'add_to_compare', 'show_buttons');\n        },\n\n        /**\n         * Get button label.\n         *\n         * @return {String}\n         */\n        getLabel: function () {\n            return this.label;\n        }\n    });\n});\n","Magento_Catalog/js/product/name.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'Magento_Catalog/js/product/list/column-status-validator',\n    'escaper'\n], function (Column, columnStatusValidator, escaper) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            allowedTags: ['div', 'span', 'b', 'strong', 'i', 'em', 'u', 'a']\n        },\n\n        /**\n         * Depends on this option, product name can be shown or hide. Depends on  backend configuration\n         *\n         * @returns {Boolean}\n         */\n        isAllowed: function () {\n            return columnStatusValidator.isValid(this.source(), 'name', 'show_attributes');\n        },\n\n        /**\n         * Name column.\n         *\n         * @param {String} label\n         * @returns {String}\n         */\n        getNameUnsanitizedHtml: function (label) {\n            return escaper.escapeHtml(label, this.allowedTags);\n        }\n    });\n});\n","Magento_Catalog/js/product/addtocart-button.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'Magento_Catalog/js/product/uenc-processor',\n    'Magento_Catalog/js/product/list/column-status-validator'\n], function (Element, uencProcessor, columnStatusValidator) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            label: ''\n        },\n\n        /**\n         * Prepare data, that will be inserted as data-mage-init attribute into button. With help of this attribute\n         * Add To * buttons can understand post data and urls\n         *\n         * @param {Object} row\n         * @returns {String}\n         */\n        getDataMageInit: function (row) {\n            return '{\"redirectUrl\": { \"url\" : \"'  + uencProcessor(row['add_to_cart_button'].url) + '\"}}';\n        },\n\n        /**\n         * Prepare Data-Post data that will be used in data-mage-init\n         *\n         * @param {Object} row\n         * @return {String}\n         */\n        getDataPost: function (row) {\n            return uencProcessor(row['add_to_cart_button']['post_data']);\n        },\n\n        /**\n         * Check if product has required options.\n         *\n         * @param {Object} row\n         * @return {Boolean}\n         */\n        hasRequiredOptions: function (row) {\n            return row['add_to_cart_button']['required_options'];\n        },\n\n        /**\n         * Depends on this option, \"Add to cart\" button can be shown or hide\n         *\n         * @param {Object} row\n         * @returns {Boolean}\n         */\n        isSalable: function (row) {\n            return row['is_salable'];\n        },\n\n        /**\n         * Depends on this option, stock status text can be \"In stock\" or \"Out Of Stock\"\n         *\n         * @param {Object} row\n         * @returns {Boolean}\n         */\n        isAvailable: function (row) {\n            return row['is_available'];\n        },\n\n        /**\n         * Depends on this option, \"Add to cart\" button can be shown or hide. Depends on  backend configuration\n         *\n         * @returns {Boolean}\n         */\n        isAllowed: function () {\n            return columnStatusValidator.isValid(this.source(), 'add_to_cart', 'show_buttons');\n        },\n\n        /**\n         * Get button label.\n         *\n         * @return {String}\n         */\n        getLabel: function () {\n            return this.label;\n        }\n    });\n});\n","Magento_Catalog/js/product/list/column-status-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    return _.extend({\n        /**\n         * Check whether we can show column depends on server settings or not\n         *\n         * @param {Object} source\n         * @param {String} attributeCode\n         * @param {String} type\n         * @returns {Boolean}\n         */\n        isValid: function (source, attributeCode, type) {\n            var attributes;\n\n            if (!source[type]) {\n                return false;\n            }\n\n            attributes = source[type].split(',');\n\n            return _.contains(attributes, attributeCode);\n        }\n    });\n});\n","Magento_Catalog/js/product/list/listing.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'underscore',\n    'Magento_Ui/js/grid/listing'\n], function (ko, _, Listing) {\n    'use strict';\n\n    return Listing.extend({\n        defaults: {\n            additionalClasses: '',\n            filteredRows: {},\n            limit: 5,\n            listens: {\n                elems: 'filterRowsFromCache',\n                '${ $.provider }:data.items': 'filterRowsFromServer'\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            this.filteredRows = ko.observable();\n            this.initProductsLimit();\n            this.hideLoader();\n        },\n\n        /**\n         * Initialize product limit\n         * Product limit can be configured through Ui component.\n         * Product limit are present in widget form\n         *\n         * @returns {exports}\n         */\n        initProductsLimit: function () {\n            if (this.source['page_size']) {\n                this.limit = this.source['page_size'];\n            }\n\n            return this;\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Listing} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track({\n                    rows: []\n                });\n\n            return this;\n        },\n\n        /**\n         * Sort and filter rows, that are already in magento storage cache\n         *\n         * @return void\n         */\n        filterRowsFromCache: function () {\n            this._filterRows(this.rows);\n        },\n\n        /**\n         * Sort and filter rows, that are come from backend\n         *\n         * @param {Object} rows\n         */\n        filterRowsFromServer: function (rows) {\n            this._filterRows(rows);\n        },\n\n        /**\n         * Filter rows by limit and sort them\n         *\n         * @param {Array} rows\n         * @private\n         */\n        _filterRows: function (rows) {\n            this.filteredRows(_.sortBy(rows, 'added_at').reverse().slice(0, this.limit));\n        },\n\n        /**\n         * Can retrieve product url\n         *\n         * @param {Object} row\n         * @returns {String}\n         */\n        getUrl: function (row) {\n            return row.url;\n        },\n\n        /**\n         * Get product attribute by code.\n         *\n         * @param {String} code\n         * @return {Object}\n         */\n        getComponentByCode: function (code) {\n            var elems = this.elems() ? this.elems() : ko.getObservable(this, 'elems'),\n                component;\n\n            component = _.filter(elems, function (elem) {\n                return elem.index === code;\n            }, this).pop();\n\n            return component;\n        }\n    });\n});\n","Magento_Catalog/js/product/list/columns/final-price.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'uiRegistry',\n    'mageUtils',\n    'uiCollection'\n], function (_, registry, utils, Collection) {\n    'use strict';\n\n    return Collection.extend({\n        defaults: {\n            label: false,\n            headerTmpl: 'ui/grid/columns/text',\n            showMinimalPrice: false,\n            showMaximumPrice: false,\n            useLinkForAsLowAs: false,\n            bodyTmpl: 'Magento_Catalog/product/final_price',\n            priceWrapperCssClasses: '',\n            priceWrapperAttr: {}\n        },\n\n        /**\n         * Get product final price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} final price html\n         */\n        getPrice: function (row) {\n            return row['price_info']['formatted_prices']['final_price'];\n        },\n\n        /**\n         * Get product regular price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} regular price html\n         */\n        getRegularPrice: function (row) {\n            return row['price_info']['formatted_prices']['regular_price'];\n        },\n\n        /**\n         * Check if product has a price range.\n         *\n         * @param {Object} row\n         * @return {Boolean}\n         */\n        hasPriceRange: function (row) {\n            return row['price_info']['max_regular_price'] !== row['price_info']['min_regular_price'];\n        },\n\n        /**\n         * Check if product has special price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} special price html\n         */\n        hasSpecialPrice: function (row) {\n            return row['price_info']['regular_price'] > row['price_info']['final_price'];\n        },\n\n        /**\n         * Check if product has minimal price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} minimal price html\n         */\n        isMinimalPrice: function (row) {\n            return row['price_info']['minimal_price'] < row['price_info']['final_price'];\n        },\n\n        /**\n         * Get product minimal price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} minimal price html\n         */\n        getMinimalPrice: function (row) {\n            return row['price_info']['formatted_prices']['minimal_price'];\n        },\n\n        /**\n         * Check if product is salable.\n         *\n         * @param {Object} row\n         * @return {Boolean}\n         */\n        isSalable: function (row) {\n            return row['is_salable'];\n        },\n\n        /**\n         * Get product maximum price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} maximum price html\n         */\n        getMaxPrice: function (row) {\n            return row['price_info']['formatted_prices']['max_price'];\n        },\n\n        /**\n         * Get product maximum regular price in case of price range and special price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} maximum regular price html\n         */\n        getMaxRegularPrice: function (row) {\n            return row['price_info']['formatted_prices']['max_regular_price'];\n        },\n\n        /**\n         * Get product minimal regular price in case of price range and special price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} minimal regular price html\n         */\n        getMinRegularPrice: function (row) {\n            return row['price_info']['formatted_prices']['min_regular_price'];\n        },\n\n        /**\n         * Get adjustments names and return as string.\n         *\n         * @return {String} adjustments classes\n         */\n        getAdjustmentCssClasses: function () {\n            return _.pluck(this.getAdjustments(), 'index').join(' ');\n        },\n\n        /**\n         * Get product minimal price as number.\n         *\n         * @param {Object} row\n         * @return {Number} minimal price amount\n         */\n        getMinimalPriceAmount: function (row) {\n            return row['price_info']['minimal_price'];\n        },\n\n        /**\n         * Get product minimal regular price as number in case of special price.\n         *\n         * @param {Object} row\n         * @return {Number} minimal regular price amount\n         */\n        getMinimalRegularPriceAmount: function (row) {\n            return row['price_info']['min_regular_price'];\n        },\n\n        /**\n         * Get product maximum price as number.\n         *\n         * @param {Object} row\n         * @return {Number} maximum price amount\n         */\n        getMaximumPriceAmount: function (row) {\n            return row['price_info']['max_price'];\n        },\n\n        /**\n         * Get product maximum regular price as number in case of special price.\n         *\n         * @param {Object} row\n         * @return {Number} maximum regular price amount\n         */\n        getMaximumRegularPriceAmount: function (row) {\n            return row['price_info']['max_regular_price'];\n        },\n\n        /**\n         * Check if minimal regular price exist for product.\n         *\n         * @param {Object} row\n         * @return {Boolean}\n         */\n        showMinRegularPrice: function (row) {\n            return this.getMinimalPriceAmount(row) < this.getMinimalRegularPriceAmount(row);\n        },\n\n        /**\n         * Check if maximum regular price exist for product.\n         *\n         * @param {Object} row\n         * @return {Boolean}\n         */\n        showMaxRegularPrice: function (row) {\n            return this.getMaximumPriceAmount(row) < this.getMaximumRegularPriceAmount(row);\n        },\n\n        /**\n         * Get path to the columns' body template.\n         *\n         * @returns {String}\n         */\n        getBody: function () {\n            return this.bodyTmpl;\n        },\n\n        /**\n         * Get all price adjustments.\n         *\n         * @returns {Object}\n         */\n        getAdjustments: function () {\n            var adjustments = this.elems();\n\n            _.each(adjustments, function (adjustment) {\n                adjustment.setPriceType(this.priceType);\n                adjustment.source = this.source;\n            }, this);\n\n            return adjustments;\n        }\n    });\n});\n","Magento_Catalog/js/product/list/columns/image.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Ui/js/grid/columns/column',\n    'Magento_Catalog/js/product/list/column-status-validator'\n], function (_, Element, columnStatusValidator) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            bodyTmpl: 'Magento_Catalog/product/list/columns/image',\n            imageCode: 'default',\n            image: {}\n        },\n\n        /**\n         * Find image by code in scope of images\n         *\n         * @param {Object} images\n         * @returns {*|T}\n         */\n        getImage: function (images) {\n            return _.filter(images, function (image) {\n                return this.imageCode === image.code;\n            }, this).pop();\n        },\n\n        /**\n         * Get image path.\n         *\n         * @param {Object} row\n         * @return {String}\n         */\n        getImageUrl: function (row) {\n            return this.getImage(row.images).url;\n        },\n\n        /**\n         * Get image box width.\n         *\n         * @param {Object} row\n         * @return {Number}\n         */\n        getWidth: function (row) {\n            return this.getImage(row.images).width;\n        },\n\n        /**\n         * Get image box height.\n         *\n         * @param {Object} row\n         * @return {Number}\n         */\n        getHeight: function (row) {\n            return this.getImage(row.images).height;\n        },\n\n        /**\n         * Get resized image width.\n         *\n         * @param {Object} row\n         * @return {Number}\n         */\n        getResizedImageWidth: function (row) {\n            return this.getImage(row.images)['resized_width'];\n        },\n\n        /**\n         * Get resized image height.\n         *\n         * @param {Object} row\n         * @return {Number}\n         */\n        getResizedImageHeight: function (row) {\n            return this.getImage(row.images)['resized_height'];\n        },\n\n        /**\n         * Get image alt text.\n         *\n         * @param {Object} row\n         * @return {String}\n         */\n        getLabel: function (row) {\n            if (!this.imageExists(row)) {\n                return this._super();\n            }\n\n            return this.getImage(row.images).label;\n        },\n\n        /**\n         * Check if image exist.\n         *\n         * @param {Object} row\n         * @return {Boolean}\n         */\n        imageExists: function (row) {\n            return this.getImage(row.images) !== 'undefined';\n        },\n\n        /**\n         * Check if component must be shown.\n         *\n         * @return {Boolean}\n         */\n        isAllowed: function () {\n            return columnStatusValidator.isValid(this.source(), 'image', 'show_attributes');\n        }\n    });\n});\n","Magento_Catalog/js/product/list/columns/price-box.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'underscore',\n    'uiRegistry',\n    'mageUtils',\n    'uiCollection',\n    'Magento_Catalog/js/product/list/column-status-validator',\n    'uiLayout'\n], function (ko, _, registry, utils, Collection, columnStatusValidator, layout) {\n    'use strict';\n\n    return Collection.extend({\n        defaults: {\n            label: '',\n            hasSpecialPrice: false,\n            showMinimalPrice: false,\n            useLinkForAsLowAs: false,\n            visible: true,\n            headerTmpl: 'ui/grid/columns/text',\n            bodyTmpl: 'Magento_Catalog/product/price/price_box',\n            disableAction: false,\n            controlVisibility: true,\n            sortable: false,\n            sorting: false,\n            draggable: true,\n            fieldClass: {},\n            renders: {\n                default: {}\n            },\n            ignoreTmpls: {\n                fieldAction: true\n            },\n            statefull: {\n                visible: true,\n                sorting: true\n            },\n            imports: {\n                exportSorting: 'sorting'\n            },\n            listens: {\n                elems: ''\n            },\n            modules: {\n                source: '${ $.provider }'\n            },\n            pricesInit: {}\n        },\n\n        /**\n         * Sort prices api\n         *\n         * @returns {exports}\n         */\n        sort: function () {\n            return this;\n        },\n\n        /**\n         * Check whether is allowed to render price or not\n         *\n         * @returns {*}\n         */\n        isAllowed: function () {\n            return columnStatusValidator.isValid(this.source(), 'price', 'show_attributes');\n        },\n\n        /**\n         * Retrieve array of prices, that should be rendered for specific product\n         *\n         * @param {Array} row\n         * @return {Array}\n         */\n        getPrices: function (row) {\n            var elems = this.elems() ? this.elems() : ko.getObservable(this, 'elems'),\n                result;\n\n            //we cant take type of product from row\n            this.initPrices(row);\n            result = _.filter(elems, function (elem) {\n                return elem.productType === row.type;\n            });\n\n            return result;\n        },\n\n        /**\n         * Recursive Merging of objects\n         *\n         * @param {Array} target\n         * @param {Array} source\n         * @returns {Array}\n         * @private\n         */\n        _deepObjectExtend: function (target, source) {\n            var _target = utils.copy(target);\n\n            _.each(source, function (value, key) {\n                if (_.keys(value).length && typeof _target[key] !== 'undefined') {\n                    _target[key] = this._deepObjectExtend(_target[key], value);\n                } else {\n                    _target[key] = value;\n                }\n            }, this);\n\n            return _target;\n        },\n\n        /**\n         * Init price type box, in cases when product type has custom component or bodyTmpl\n         *\n         * @param {String} productType\n         * @private\n         */\n        _initPriceWithCustomMetaData: function (productType) {\n            var price = this._deepObjectExtend(\n                this.renders.prices['default'],\n                this.renders.prices[productType]\n            );\n\n            price.name = productType + '.default';\n            price.parent = this.name;\n            price.source = this.source;\n            price.productType = productType;\n            layout([price]);\n        },\n\n        /**\n         * Init Prices by product type and add them to layout\n         *\n         * @param {Array} _priceData\n         * @param {String} productType\n         * @private\n         */\n        _initPricesForProductType: function (_priceData, productType) {\n            var prices = [];\n\n            this._setPriceNamesToPrices(_priceData, productType);\n            _.sortBy(_priceData, this._comparePrices);\n\n            _.each(_priceData, function (priceData) {\n                if (!priceData.component) {\n                    return;\n                }\n\n                priceData.parent = this.name;\n                priceData.provider = this.provider;\n                priceData.productType = productType;\n                priceData = utils.template(priceData, this);\n                prices.push(priceData);\n            }, this);\n\n            layout(prices);\n        },\n\n        /**\n         * Init dynamic price components\n         *\n         * @param {Array} row\n         * @returns {void}\n         */\n        initPrices: function (row) {\n            var _priceData = [],\n                productType = row.type,\n                defaultPrice = this.renders.prices['default'];\n\n            if (this.pricesInit[productType]) {\n                return true;\n            }\n\n            this.pricesInit[productType] = true;\n\n            if (this.renders.prices[productType] && this._needToApplyCustomTemplate(this.renders.prices[productType])) {\n                return this._initPriceWithCustomMetaData(productType);\n            }\n\n            if (this.renders.prices[productType] && this.renders.prices[productType].children) {\n                _priceData = this._deepObjectExtend(defaultPrice.children, this.renders.prices[productType].children);\n            } else {\n                _priceData = defaultPrice.children;\n            }\n\n            return this._initPricesForProductType(_priceData, productType);\n        },\n\n        /**\n         * Set name to all price components\n         *\n         * @param {Array} prices\n         * @param {String} productType\n         * @private\n         */\n        _setPriceNamesToPrices: function (prices, productType) {\n            _.each(prices, function (price, name) {\n                price.priceType = name;\n                price.name = name + '.' + productType;\n            });\n\n            return prices;\n        },\n\n        /**\n         * Sort callback to compare prices by sort order\n         *\n         * @param {Number} firstPrice\n         * @param {Number} secondPrice\n         * @returns {Number}\n         * @private\n         */\n        _comparePrices: function (firstPrice, secondPrice) {\n            if (firstPrice.sortOrder < secondPrice.sortOrder) {\n                return -1;\n            }\n\n            if (firstPrice.sortOrder > secondPrice.sortOrder) {\n                return 1;\n            }\n\n            return 0;\n        },\n\n        /**\n         * Check whether metadata of product type prices was changed, and we should\n         * to apply custom template or custom component\n         *\n         * @param {Array} productData\n         * @returns {*}\n         * @private\n         */\n        _needToApplyCustomTemplate: function (productData) {\n            return productData.bodyTmpl || productData.component;\n        },\n\n        /**\n         * Returns path to the columns' body template.\n         *\n         * @returns {String}\n         */\n        getBody: function () {\n            return this.bodyTmpl;\n        },\n\n        /**\n         * Get price label.\n         *\n         * @returns {String}\n         */\n        getLabel: function () {\n            return this.label;\n        }\n    });\n});\n","Magento_Catalog/js/product/list/columns/pricetype-box.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'underscore',\n    'uiCollection'\n], function (ko, _, Collection) {\n    'use strict';\n\n    return Collection.extend({\n        /**\n         * Find from all price ui components, price with specific code, init source on it and set priceType\n         *\n         * @param {String} code\n         * @returns {*|T}\n         */\n        getPriceByCode: function (code) {\n            var elems = this.elems() ? this.elems() : ko.getObservable(this, 'elems'),\n                price;\n\n            price = _.filter(elems, function (elem) {\n                return elem.index.split('.').shift() === code;\n            }, this).pop();\n\n            price.source = this.source();\n            price.priceType = code;\n\n            return price;\n        },\n\n        /**\n         * Retrieve body template\n         *\n         * @returns {String}\n         */\n        getBody: function () {\n            return this.bodyTmpl;\n        },\n\n        /**\n         * Check whether price has price range, depends on different options, that can be choose\n         *\n         * @param {Object} row\n         * @returns {Boolean}\n         */\n        hasPriceRange: function (row) {\n            return row['price_info']['max_regular_price'] !== row['price_info']['min_regular_price'];\n        }\n    });\n});\n","Magento_Catalog/js/components/website-currency-symbol.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/select'\n], function (Select) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            currenciesForWebsites: {},\n            tracks: {\n                currency: true\n            }\n        },\n\n        /**\n         * Set currency symbol per website\n         *\n         * @param {String} value - currency symbol\n         */\n        setDifferedFromDefault: function (value) {\n            this.currency = this.currenciesForWebsites[value];\n\n            return this._super();\n        }\n    });\n});\n","Magento_Catalog/js/components/custom-options-component.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Ui/js/form/element/abstract'\n], function (_, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        /**\n         * {@inheritdoc}\n         */\n        setInitialValue: function () {\n            this._super();\n\n            this.addBefore(this.addbefore);\n\n            return this;\n        },\n\n        /**\n         * {@inheritdoc}\n         */\n        initObservable: function () {\n            this._super();\n\n            this.observe('addBefore');\n\n            return this;\n        }\n    });\n});\n","Magento_Catalog/js/components/attributes-grid-paging.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/paging/paging',\n    'underscore'\n], function (Paging, _) {\n    'use strict';\n\n    return Paging.extend({\n        defaults: {\n            totalTmpl: 'Magento_Catalog/attributes/grid/paging',\n            modules: {\n                selectionColumn: '${ $.selectProvider }'\n            },\n            listens: {\n                '${ $.selectProvider }:selected': 'changeLabel'\n            },\n            label: '',\n            selectedAttrs: []\n        },\n\n        /**\n         * Change label.\n         *\n         * @param {Array} selected\n         */\n        changeLabel: function (selected) {\n            this.selectedAttrs = [];\n            _.each(this.selectionColumn().rows(), function (row) {\n                if (selected.indexOf(row['attribute_id']) !== -1) {\n                    this.selectedAttrs.push(row['attribute_code']);\n                }\n            }, this);\n\n            this.label(this.selectedAttrs.join(', '));\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super()\n                .observe('label');\n\n            return this;\n        }\n    });\n});\n","Magento_Catalog/js/components/product-status.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @deprecated since version 2.2.0\n */\ndefine([\n    'Magento_Ui/js/form/element/abstract',\n    'underscore'\n], function (Abstract, _) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            'mappingValues': {\n                '1': true,\n                '2': false\n            },\n            'checked': false,\n            'mappedValue': '',\n            'links': {\n                value: false,\n                'mappedValue': '${ $.provider }:${ $.dataScope }'\n            },\n            imports: {\n                checked: 'mappedValue'\n            }\n        },\n\n        /**\n         * @returns {*}\n         */\n        setMappedValue: function () {\n            var newValue;\n\n            _.some(this.mappingValues, function (item, key) {\n                if (item === this.value()) {\n                    newValue = key;\n\n                    return true;\n                }\n            }, this);\n\n            return newValue;\n        },\n\n        /**\n         * @returns {*}\n         */\n        initObservable: function () {\n            return this.observe('mappedValue checked')._super();\n        },\n\n        /**\n         * @returns {*}\n         */\n        setInitialValue: function () {\n            this.value(this.mappedValue());\n            this._super();\n            this.mappedValue(this.initialValue);\n            this.value(this.mappingValues[this.initialValue]);\n            this.initialValue = this.value();\n\n            return this;\n        },\n\n        /**\n         * @returns {*}\n         */\n        onUpdate: function () {\n            this.mappedValue(this.setMappedValue());\n\n            return this._super();\n        }\n    });\n});\n","Magento_Catalog/js/components/select-to-checkbox.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @deprecated since version 2.2.0\n */\ndefine([\n    'Magento_Ui/js/form/element/abstract'\n], function (Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n\n        /**\n         * Converts initial value to integer\n         *\n         * @returns {Abstract}\n         */\n        setInitialValue: function () {\n            this._super();\n            this.value(+this.value());\n\n            return this;\n        },\n\n        /**\n         * Converts new value to integer\n         *\n         * @returns {Boolean}\n         */\n        onUpdate: function () {\n            this._super();\n            this.value(+this.value());\n\n            return this._super();\n        }\n    });\n});\n","Magento_Catalog/js/components/custom-options-price-type.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Ui/js/form/element/select',\n    'uiRegistry'\n], function (_, Select, uiRegistry) {\n    'use strict';\n\n    return Select.extend({\n        /**\n         * {@inheritdoc}\n         */\n        onUpdate: function () {\n            this._super();\n\n            this.updateAddBeforeForPrice();\n        },\n\n        /**\n         * {@inheritdoc}\n         */\n        setInitialValue: function () {\n            this._super();\n\n            this.updateAddBeforeForPrice();\n\n            return this;\n        },\n\n        /**\n         * Update addbefore for price field. Change it to currency or % depends of price_type value.\n         */\n        updateAddBeforeForPrice: function () {\n            var addBefore, currentValue, priceIndex, priceName, uiPrice;\n\n            priceIndex = typeof this.imports.priceIndex == 'undefined' ? 'price' : this.imports.priceIndex;\n            priceName = this.parentName + '.' + priceIndex;\n\n            uiPrice = uiRegistry.get(priceName);\n\n            if (uiPrice && uiPrice.addbeforePool) {\n                currentValue = this.value();\n\n                uiPrice.addbeforePool.forEach(function (item) {\n                    if (item.value === currentValue) {\n                        addBefore = item.label;\n                    }\n                });\n\n                if (typeof addBefore != 'undefined') {\n                    uiPrice.addBefore(addBefore);\n                }\n            }\n        }\n    });\n});\n","Magento_Catalog/js/components/product-ui-select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @deprecated see Magento/Ui/view/base/web/js/grid/filters/elements/ui-select.js\n */\ndefine([\n    'Magento_Ui/js/form/element/ui-select',\n    'jquery',\n    'underscore'\n], function (Select, $, _) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            validationUrl: false,\n            loadedOption: [],\n            validationLoading: true\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n\n            this.validateInitialValue();\n\n            return this;\n        },\n\n        /**\n         * Validate initial value actually exists\n         */\n        validateInitialValue: function () {\n            if (!_.isEmpty(this.value())) {\n                $.ajax({\n                    url: this.validationUrl,\n                    type: 'GET',\n                    dataType: 'json',\n                    context: this,\n                    data: {\n                        productId: this.value()\n                    },\n\n                    /** @param {Object} response */\n                    success: function (response) {\n                        if (!_.isEmpty(response)) {\n                            this.options([response]);\n                            this.loadedOption = response;\n                        }\n                    },\n\n                    /** set empty array if error occurs */\n                    error: function () {\n                        this.options([]);\n                    },\n\n                    /** stop loader */\n                    complete: function () {\n                        this.validationLoading(false);\n                        this.setCaption();\n                    }\n                });\n            } else {\n                this.validationLoading(false);\n            }\n        },\n\n        /** @inheritdoc */\n        getSelected: function () {\n            var options = this._super();\n\n            if (!_.isEmpty(this.loadedOption)) {\n                return this.value() === this.loadedOption.value ? [this.loadedOption] : options;\n            }\n\n            return options;\n        }\n    });\n});\n","Magento_Catalog/js/components/import-handler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/abstract',\n    'underscore',\n    'uiRegistry'\n], function (Abstract, _, registry) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            allowImport: true,\n            autoImportIfEmpty: false,\n            values: {},\n            mask: '',\n            queryTemplate: 'ns = ${ $.ns }, index = '\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n\n            if (this.allowImport) {\n                this.setHandlers();\n            }\n        },\n\n        /**\n         * Split mask placeholder and attach events to placeholder fields.\n         */\n        setHandlers: function () {\n            var str = this.mask || '',\n                placeholders;\n\n            placeholders = str.match(/{{(.*?)}}/g); // Get placeholders\n\n            _.each(placeholders, function (placeholder) {\n                placeholder = placeholder.replace(/[{{}}]/g, ''); // Remove curly braces\n\n                registry.get(this.queryTemplate + placeholder, function (component) {\n                    this.values[placeholder] = component.getPreview();\n                    component.on('value', this.updateValue.bind(this, placeholder, component));\n                    component.valueUpdate = 'keyup';\n                }.bind(this));\n            }, this);\n        },\n\n        /**\n         * Update field with mask value, if it's allowed.\n         *\n         * @param {Object} placeholder\n         * @param {Object} component\n         */\n        updateValue: function (placeholder, component) {\n            var string = this.mask || '',\n                nonEmptyValueFlag = false;\n\n            if (placeholder) {\n                this.values[placeholder] = component.getPreview() || '';\n            }\n\n            if (!this.allowImport) {\n                return;\n            }\n\n            _.each(this.values, function (propertyValue, propertyName) {\n                string = string.replace('{{' + propertyName + '}}', propertyValue);\n                nonEmptyValueFlag = nonEmptyValueFlag || !!propertyValue;\n            });\n\n            if (nonEmptyValueFlag) {\n                string = string.replace(/(<([^>]+)>)/ig, ''); // Remove html tags\n                this.value(string);\n            } else {\n                this.value('');\n            }\n        },\n\n        /**\n         * Disallow import when initial value isn't empty string\n         *\n         * @returns {*}\n         */\n        setInitialValue: function () {\n            this._super();\n\n            if (this.initialValue !== '') {\n                this.allowImport = false;\n            }\n\n            return this;\n        },\n\n        /**\n         *  Callback when value is changed by user,\n         *  and disallow/allow import value\n         */\n        userChanges: function () {\n\n            /**\n             *  As userChanges is called before updateValue,\n             *  we forced to get value from component by reference\n             */\n            var actualValue = arguments[1].currentTarget.value;\n\n            this._super();\n\n            if (actualValue === '') {\n                this.allowImport = true;\n\n                if (this.autoImportIfEmpty) {\n                    this.updateValue(null, null);\n                }\n            } else {\n                this.allowImport = false;\n            }\n        }\n    });\n});\n","Magento_Catalog/js/components/url-key-handle-changes.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Ui/js/form/element/single-checkbox'\n], function (Checkbox) {\n    'use strict';\n\n    return Checkbox.extend({\n        defaults: {\n            imports: {\n                handleUseDefault: '${ $.parentName }.use_default.url_key:checked',\n                urlKey: '${ $.provider }:data.url_key'\n            },\n            listens: {\n                urlKey: 'handleChanges'\n            },\n            modules: {\n                useDefault: '${ $.parentName }.use_default.url_key'\n            }\n        },\n\n        /**\n         * Disable checkbox field, when 'url_key' field without changes or 'use default' field is checked\n         */\n        handleChanges: function (newValue) {\n            this.disabled(newValue === this.valueMap['true'] || this.useDefault.checked);\n        },\n\n        /**\n         * Disable checkbox field, when 'url_key' field without changes or 'use default' field is checked\n         */\n        handleUseDefault: function (checkedUseDefault) {\n            this.disabled(this.urlKey === this.valueMap['true'] || checkedUseDefault);\n        }\n    });\n});\n","Magento_Catalog/js/components/disable-hide-select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/select',\n    'Magento_Catalog/js/components/visible-on-option/strategy',\n    'Magento_Catalog/js/components/disable-on-option/strategy'\n], function (Element, visibleStrategy, disableStrategy) {\n    'use strict';\n\n    return Element.extend(visibleStrategy).extend(disableStrategy);\n});\n","Magento_Catalog/js/components/checkbox.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @deprecated since version 2.2.0\n */\ndefine([\n    'Magento_Ui/js/form/element/abstract',\n    'knockout'\n], function (Abstract, ko) {\n    'use strict';\n\n    return Abstract.extend({\n\n        /**\n         * Initializes observable properties of instance\n         *\n         * @returns {Element} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe('checked');\n\n            this.value = ko.pureComputed({\n\n                /**\n                 * use 'mappedValue' as value if checked\n                 */\n                read: function () {\n                    return this.checked() ? this.mappedValue : '';\n                },\n\n                /**\n                 * any value made checkbox checked\n                 */\n                write: function (val) {\n                    if (val) {\n                        this.checked(true);\n                    }\n                },\n                owner: this\n            });\n\n            return this;\n        }\n    });\n});\n","Magento_Catalog/js/components/multiselect-handle-required.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @deprecated since version 2.2.0\n */\ndefine([\n    'Magento_Ui/js/form/element/multiselect'\n], function (Multiselect) {\n    'use strict';\n\n    return Multiselect.extend({\n\n        /**\n         * Disable required validation, when 'use config option' checked\n         */\n        handleRequired: function (newValue) {\n            this.validation['required-entry'] = !newValue;\n            this.required(!newValue);\n            this.error(false);\n        }\n    });\n});\n","Magento_Catalog/js/components/attribute-set-select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/ui-select'\n], function (Select) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            listens: {\n                'value': 'changeFormSubmitUrl'\n            },\n            modules: {\n                formProvider: '${ $.provider }'\n            }\n        },\n\n        /**\n         * Change set parameter in save and validate urls of form\n         *\n         * @param {String|Number} value\n         */\n        changeFormSubmitUrl: function (value) {\n            var pattern = /(set\\/)(\\d)*?\\//,\n                change = '$1' + value + '/';\n\n            this.formProvider().client.urls.save = this.formProvider().client.urls.save.replace(pattern, change);\n            this.formProvider().client.urls.beforeSave = this.formProvider().client.urls.beforeSave.replace(\n                pattern,\n                change\n            );\n        }\n    });\n});\n","Magento_Catalog/js/components/attributes-insert-listing.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/lib/view/utils/async',\n    'uiRegistry',\n    'underscore',\n    'Magento_Ui/js/form/components/insert-listing'\n], function ($, registry, _, InsertListing) {\n    'use strict';\n\n    return InsertListing.extend({\n        defaults: {\n            addAttributeUrl: '',\n            attributeSetId: '',\n            attributeIds: '',\n            groupCode: '',\n            groupName: '',\n            groupSortOrder: 0,\n            productId: 0,\n            formProvider: '',\n            modules: {\n                form: '${ $.formProvider }',\n                modal: '${ $.parentName }'\n            },\n            productType: ''\n        },\n\n        /**\n         * Render attribute\n         */\n        render: function () {\n            this._super();\n        },\n\n        /**\n         * Save attribute\n         */\n        save: function () {\n            this.addSelectedAttributes();\n            this._super();\n        },\n\n        /**\n         * Add selected attributes\n         */\n        addSelectedAttributes: function () {\n            $.ajax({\n                url: this.addAttributeUrl,\n                type: 'POST',\n                dataType: 'json',\n                data: {\n                    attributeIds: this.selections().getSelections(),\n                    templateId: this.attributeSetId,\n                    groupCode: this.groupCode,\n                    groupName: this.groupName,\n                    groupSortOrder: this.groupSortOrder,\n                    productId: this.productId,\n                    componentJson: 1\n                },\n                success: function () {\n                    this.form().params = {\n                        set: this.attributeSetId,\n                        id: this.productId,\n                        type: this.productType\n                    };\n                    this.form().reload();\n                    this.modal().state(false);\n                    this.reload();\n                }.bind(this)\n            });\n        }\n    });\n});\n","Magento_Catalog/js/components/dynamic-rows-import-custom-options.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/dynamic-rows/dynamic-rows-grid',\n    'underscore',\n    'mageUtils'\n], function (DynamicRows, _, utils) {\n    'use strict';\n\n    return DynamicRows.extend({\n        defaults: {\n            mappingSettings: {\n                enabled: false,\n                distinct: false\n            },\n            update: true,\n            map: {\n                'option_id': 'option_id'\n            },\n            identificationProperty: 'option_id',\n            identificationDRProperty: 'option_id'\n        },\n\n        /** @inheritdoc */\n        processingInsertData: function (data) {\n            var options = [],\n                currentOption,\n                generalContext = this;\n\n            if (!data) {\n                return;\n            }\n            _.each(data, function (item) {\n                if (!item.options) {\n                    return;\n                }\n                _.each(item.options, function (option) {\n                    currentOption = utils.copy(option);\n\n                    if (currentOption.hasOwnProperty('sort_order')) {\n                        delete currentOption['sort_order'];\n                    }\n\n                    if (currentOption.hasOwnProperty('option_id')) {\n                        delete currentOption['option_id'];\n                    }\n\n                    if (currentOption.values.length > 0) {\n                        generalContext.removeOptionsIds(currentOption.values);\n                    }\n                    options.push(currentOption);\n                });\n            });\n\n            if (!options.length) {\n                return;\n            }\n            this.cacheGridData = options;\n            _.each(options, function (opt) {\n                this.mappingValue(opt);\n            }, this);\n\n            this.insertData([]);\n        },\n\n        /**\n         * Removes option_id and option_type_id from every option\n         *\n         * @param {Array} options\n         */\n        removeOptionsIds: function (options) {\n            _.each(options, function (optionValue) {\n                delete optionValue['option_id'];\n                delete optionValue['option_type_id'];\n            });\n        },\n\n        /** @inheritdoc */\n        processingAddChild: function (ctx, index, prop) {\n            if (!ctx) {\n                this.showSpinner(true);\n                this.addChild(ctx, index, prop);\n\n                return;\n            }\n\n            this._super(ctx, index, prop);\n        },\n\n        /**\n         * Set empty array to dataProvider\n         */\n        clearDataProvider: function () {\n            this.source.set(this.dataProvider, []);\n        },\n\n        /**\n         * Mutes parent method\n         */\n        updateInsertData: function () {\n            return false;\n        }\n    });\n});\n","Magento_Catalog/js/components/dynamic-rows-tier-price.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Ui/js/dynamic-rows/dynamic-rows'\n], function (_, DynamicRows) {\n    'use strict';\n\n    /**\n     * @deprecated Parent method contains labels sorting.\n     * @see Magento_Ui/js/dynamic-rows/dynamic-rows\n     */\n    return DynamicRows.extend({\n\n        /**\n         * Init header elements\n         */\n        initHeader: function () {\n            var labels;\n\n            this._super();\n            labels = _.clone(this.labels());\n            labels = _.sortBy(labels, function (label) {\n                return label.sortOrder;\n            });\n\n            this.labels(labels);\n        }\n    });\n});\n","Magento_Catalog/js/components/input-handle-required.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @deprecated since version 2.2.0\n */\ndefine([\n    'Magento_Ui/js/form/element/abstract'\n], function (Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n\n        /**\n         * Disable required validation, when 'use config option' checked\n         */\n        handleRequired: function (newValue) {\n            this.validation['required-entry'] = !newValue;\n            this.required(!newValue);\n            this.error(false);\n        }\n    });\n});\n","Magento_Catalog/js/components/new-attribute-form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/form/form',\n    'Magento_Ui/js/modal/prompt',\n    'Magento_Ui/js/modal/alert'\n], function ($, Form, prompt, alert) {\n    'use strict';\n\n    return Form.extend({\n        defaults: {\n            newSetPromptMessage: '',\n            listens: {\n                responseData: 'processResponseData'\n            },\n            modules: {\n                productForm: 'product_form.product_form'\n            }\n        },\n\n        /**\n         * Process response data\n         *\n         * @param {Object} data\n         */\n        processResponseData: function (data) {\n            if (data.params['new_attribute_set_id']) {\n                this.productForm().params = {\n                    set: data.params['new_attribute_set_id']\n                };\n            }\n        },\n\n        /**\n         * Process Save In New Attribute Set prompt\n         */\n        saveAttributeInNewSet: function () {\n\n            var self = this;\n\n            this.validate();\n\n            if (!this.additionalInvalid && !this.source.get('params.invalid')) {\n                prompt({\n                    content: this.newSetPromptMessage,\n                    actions: {\n\n                        /**\n                         * @param {String} val\n                         * @this {actions}\n                         */\n                        confirm: function (val) {\n                            var rules = ['required-entry', 'validate-no-html-tags'],\n                                editForm = self,\n                                newAttributeSetName = val,\n                                i,\n                                params = {};\n\n                            if (!newAttributeSetName) {\n                                return;\n                            }\n\n                            for (i = 0; i < rules.length; i++) {\n                                if (!$.validator.methods[rules[i]](newAttributeSetName)) {\n                                    alert({\n                                        content: $.validator.messages[rules[i]]\n                                    });\n\n                                    return;\n                                }\n                            }\n\n                            params['new_attribute_set_name'] = newAttributeSetName;\n                            editForm.setAdditionalData(params);\n                            editForm.save();\n                        }\n                    }\n                });\n            } else {\n                this.focusInvalid();\n            }\n        }\n    });\n});\n","Magento_Catalog/js/components/new-attribute-insert-form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/insert-form'\n], function (InsertForm) {\n    'use strict';\n\n    return InsertForm.extend({\n        defaults: {\n            modules: {\n                productForm: 'product_form.product_form'\n            },\n            listens: {\n                responseStatus: 'processResponseStatus'\n            },\n            attributeSetId: 0,\n            productId: 0\n        },\n\n        /**\n         * Process response status.\n         */\n        processResponseStatus: function () {\n            if (this.responseStatus()) {\n\n                if (this.productForm().params === undefined) {\n                    this.productForm().params = {\n                        set: this.attributeSetId\n                    };\n                }\n\n                if (this.productId) {\n                    this.productForm().params.id = this.productId;\n                }\n                this.productForm().params.type = this.productType;\n\n                this.productForm().reload();\n                this.resetForm();\n            }\n        }\n    });\n});\n","Magento_Catalog/js/components/select-handle-required.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @deprecated since version 2.2.0\n */\ndefine([\n    'Magento_Ui/js/form/element/select'\n], function (Select) {\n    'use strict';\n\n    return Select.extend({\n\n        /**\n         * Disable required validation, when 'use config option' checked\n         */\n        handleRequired: function (newValue) {\n            this.validation['required-entry'] = !newValue;\n            this.required(!newValue);\n            this.error(false);\n        }\n    });\n});\n","Magento_Catalog/js/components/messages.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/html'\n], function (Html) {\n    'use strict';\n\n    return Html.extend({\n        defaults: {\n            form: '${ $.namespace }.${ $.namespace }',\n            visible: false,\n            imports: {\n                responseData: '${ $.form }:responseData',\n                visible: 'responseData.error',\n                content: 'responseData.messages'\n            },\n            listens: {\n                '${ $.provider }:data.reset': 'hide'\n            }\n        },\n\n        /**\n         * Show messages.\n         */\n        show: function () {\n            this.visible(true);\n        },\n\n        /**\n         * Hide messages.\n         */\n        hide: function () {\n            this.visible(false);\n        }\n    });\n});\n","Magento_Catalog/js/components/new-category.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/ui-select'\n], function (Select) {\n    'use strict';\n\n    return Select.extend({\n\n        /**\n         * Parse data and set it to options.\n         *\n         * @param {Object} data - Response data object.\n         * @returns {Object}\n         */\n        setParsed: function (data) {\n            var option = this.parseData(data);\n\n            if (data.error) {\n                return this;\n            }\n\n            this.options([]);\n            this.setOption(option);\n            this.set('newOption', option);\n        },\n\n        /**\n         * Normalize option object.\n         *\n         * @param {Object} data - Option object.\n         * @returns {Object}\n         */\n        parseData: function (data) {\n            return {\n                'is_active': data.category['is_active'],\n                level: data.category.level,\n                value: data.category['entity_id'],\n                label: data.category.name,\n                parent: data.category.parent\n            };\n        }\n    });\n});\n","Magento_Catalog/js/components/attributes-fieldset.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/fieldset',\n    'Magento_Ui/js/core/app'\n], function (Fieldset, app) {\n    'use strict';\n\n    return Fieldset.extend({\n        defaults: {\n            listens: {\n                '${ $.provider }:additionalAttributes': 'onAttributeAdd'\n            }\n        },\n\n        /**\n         * On attribute add trigger\n         *\n         * @param {Object} listOfNewAttributes\n         */\n        onAttributeAdd: function (listOfNewAttributes) {\n            app(listOfNewAttributes, true);\n        }\n    });\n});\n","Magento_Catalog/js/components/visible-on-option/strategy.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(function () {\n    'use strict';\n\n    return {\n        defaults: {\n            valuesForOptions: [],\n            imports: {\n                toggleVisibility:\n                    'product_attribute_add_form.product_attribute_add_form.base_fieldset.frontend_input:value'\n            },\n            isShown: false,\n            inverseVisibility: false\n        },\n\n        /**\n         * Toggle visibility state.\n         *\n         * @param {Number} selected\n         */\n        toggleVisibility: function (selected) {\n            this.isShown = selected in this.valuesForOptions;\n            this.visible(this.inverseVisibility ? !this.isShown : this.isShown);\n        }\n    };\n});\n","Magento_Catalog/js/components/visible-on-option/textarea.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/textarea',\n    'Magento_Catalog/js/components/visible-on-option/strategy'\n], function (Element, strategy) {\n    'use strict';\n\n    return Element.extend(strategy);\n});\n","Magento_Catalog/js/components/visible-on-option/fieldset.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/components/fieldset',\n    'Magento_Catalog/js/components/visible-on-option/strategy'\n], function (Fieldset, strategy) {\n    'use strict';\n\n    return Fieldset.extend(strategy).extend(\n        {\n            defaults: {\n                openOnShow: true\n            },\n\n            /**\n             * Toggle visibility state.\n             */\n            toggleVisibility: function () {\n                this._super();\n\n                if (this.openOnShow) {\n                    this.opened(this.inverseVisibility ? !this.isShown : this.isShown);\n                }\n            }\n        }\n    );\n});\n","Magento_Catalog/js/components/visible-on-option/select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/select',\n    'Magento_Catalog/js/components/visible-on-option/strategy'\n], function (Element, strategy) {\n    'use strict';\n\n    return Element.extend(strategy);\n});\n","Magento_Catalog/js/components/visible-on-option/date.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/date',\n    'Magento_Catalog/js/components/visible-on-option/strategy'\n], function (Element, strategy) {\n    'use strict';\n\n    return Element.extend(strategy);\n});\n","Magento_Catalog/js/components/visible-on-option/input.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/abstract',\n    'Magento_Catalog/js/components/visible-on-option/strategy'\n], function (Element, strategy) {\n    'use strict';\n\n    return Element.extend(strategy);\n});\n","Magento_Catalog/js/components/visible-on-option/yesno.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/single-checkbox',\n    'Magento_Catalog/js/components/visible-on-option/strategy'\n], function (Element, strategy) {\n    'use strict';\n\n    return Element.extend(strategy);\n});\n","Magento_Catalog/js/components/disable-on-option/strategy.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(function () {\n    'use strict';\n\n    return {\n        defaults: {\n            valuesForEnable: [],\n            disabled: true,\n            imports: {\n                toggleDisable:\n                    'product_attribute_add_form.product_attribute_add_form.base_fieldset.frontend_input:value'\n            }\n        },\n\n        /**\n         * Toggle disabled state.\n         *\n         * @param {Number} selected\n         */\n        toggleDisable: function (selected) {\n            this.disabled(!(selected in this.valuesForEnable));\n        }\n    };\n});\n","Magento_Catalog/js/components/disable-on-option/select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/select',\n    'Magento_Catalog/js/components/disable-on-option/strategy'\n], function (Element, strategy) {\n    'use strict';\n\n    return Element.extend(strategy);\n});\n","Magento_Catalog/js/components/disable-on-option/input.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/abstract',\n    'Magento_Catalog/js/components/disable-on-option/strategy'\n], function (Element, strategy) {\n    'use strict';\n\n    return Element.extend(strategy);\n});\n","Magento_Catalog/js/components/disable-on-option/yesno.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/single-checkbox',\n    'Magento_Catalog/js/components/disable-on-option/strategy'\n], function (Element, strategy) {\n    'use strict';\n\n    var comp = Element.extend(strategy).extend({\n\n        defaults: {\n            listens: {\n                disabled: 'updateValueForDisabledField',\n                visible: 'updateValueForDisabledField'\n            }\n        },\n\n        /**\n         * {@inheritdoc}\n         */\n        initialize: function () {\n            this._super();\n            this.updateValueForDisabledField();\n\n            return this;\n        },\n\n        /**\n         * Set element value to O(No) if element is invisible and disabled\n         * Set element value to initialValue if element becomes visible and enable\n         */\n        updateValueForDisabledField: function () {\n            if (!this.disabled() && this.visible()) {\n                this.set('value', this.initialValue);\n            } else {\n                this.set('value', 0);\n            }\n        }\n    });\n\n    return comp.extend(strategy);\n});\n","Magento_Catalog/js/components/use-parent-settings/toggle-disabled-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    var mixin = {\n        defaults: {\n            imports: {\n                toggleDisabled: '${ $.parentName }.custom_use_parent_settings:checked'\n            },\n            useParent: false,\n            useDefaults: false\n        },\n\n        /**\n         * Disable form input if settings for parent section is used\n         * or default value is applied.\n         *\n         * @param {Boolean} isUseParent\n         */\n        toggleDisabled: function (isUseParent) {\n            var disabled = this.useParent = isUseParent;\n\n            if (!disabled && !_.isUndefined(this.service)) {\n                disabled = !!this.isUseDefault();\n            }\n\n            this.saveUseDefaults();\n            this.disabled(disabled);\n        },\n\n        /**\n         * Stores original state of the field.\n         */\n        saveUseDefaults: function () {\n            this.useDefaults = this.disabled();\n        },\n\n        /** @inheritdoc */\n        setInitialValue: function () {\n            this._super();\n            this.isUseDefault(this.useDefaults);\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        toggleUseDefault: function (state) {\n            this._super();\n            this.disabled(state || this.useParent);\n        }\n    };\n\n    return function (target) {\n        return target.extend(mixin);\n    };\n});\n","Magento_Catalog/js/components/use-parent-settings/textarea.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Ui/js/form/element/textarea'\n], function (Component) {\n    'use strict';\n\n    return Component;\n});\n","Magento_Catalog/js/components/use-parent-settings/select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Ui/js/form/element/select'\n], function (Component) {\n    'use strict';\n\n    return Component;\n});\n","Magento_Catalog/js/components/use-parent-settings/single-checkbox.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Ui/js/form/element/single-checkbox'\n], function (Component) {\n    'use strict';\n\n    return Component;\n});\n","Magento_Catalog/catalog/base-image-uploader.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/*global alert:true*/\ndefine([\n    'jquery',\n    'mage/template',\n    'Magento_Ui/js/modal/alert',\n    'jquery/ui',\n    'jquery/file-uploader',\n    'mage/translate',\n    'mage/backend/notification'\n], function ($, mageTemplate, alert) {\n    'use strict';\n\n    $.widget('mage.baseImage', {\n        /**\n         * Button creation\n         * @protected\n         */\n        options: {\n            maxImageUploadCount: 10\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            var $container = this.element,\n                imageTmpl = mageTemplate(this.element.find('[data-template=image]').html()),\n                $dropPlaceholder = this.element.find('.image-placeholder'),\n                $galleryContainer = $('#media_gallery_content'),\n                mainClass = 'base-image',\n                maximumImageCount = 5,\n                $fieldCheckBox = $container.closest('[data-attribute-code=image]').find(':checkbox'),\n                isDefaultChecked = $fieldCheckBox.is(':checked'),\n                findElement, updateVisibility;\n\n            if (isDefaultChecked) {\n                $fieldCheckBox.trigger('click');\n            }\n\n            /**\n             * @param {Object} data\n             * @return {HTMLElement}\n             */\n            findElement = function (data) {\n                return $container.find('.image:not(.image-placeholder)').filter(function () {\n                    if (!$(this).data('image')) {\n                        return false;\n                    }\n\n                    return $(this).data('image').file === data.file;\n                }).first();\n            };\n\n            /** Update image visibility. */\n            updateVisibility = function () {\n                var elementsList = $container.find('.image:not(.removed-item)');\n\n                elementsList.each(function (index) {\n                    $(this)[index < maximumImageCount ? 'show' : 'hide']();\n                });\n                $dropPlaceholder[elementsList.length > maximumImageCount ? 'hide' : 'show']();\n            };\n\n            $galleryContainer.on('setImageType', function (event, data) {\n                if (data.type === 'image') {\n                    $container.find('.' + mainClass).removeClass(mainClass);\n\n                    if (data.imageData) {\n                        findElement(data.imageData).addClass(mainClass);\n                    }\n                }\n            });\n\n            $galleryContainer.on('addItem', function (event, data) {\n                var tmpl = imageTmpl({\n                    data: data\n                });\n\n                $(tmpl).data('image', data).insertBefore($dropPlaceholder);\n\n                updateVisibility();\n            });\n\n            $galleryContainer.on('removeItem', function (event, image) {\n                findElement(image).addClass('removed-item').hide();\n                updateVisibility();\n            });\n\n            $galleryContainer.on('moveElement', function (event, data) {\n                var $element = findElement(data.imageData),\n                    $after;\n\n                if (data.position === 0) {\n                    $container.prepend($element);\n                } else {\n                    $after = $container.find('.image').eq(data.position);\n\n                    if (!$element.is($after)) {\n                        $element.insertAfter($after);\n                    }\n                }\n                updateVisibility();\n            });\n\n            $container.on('click', '[data-role=make-base-button]', function (event) {\n                var data;\n\n                event.preventDefault();\n                data = $(event.target).closest('.image').data('image');\n                $galleryContainer.productGallery('setBase', data);\n            });\n\n            $container.on('click', '[data-role=delete-button]', function (event) {\n                event.preventDefault();\n                $galleryContainer.trigger('removeItem', $(event.target).closest('.image').data('image'));\n            });\n\n            $container.sortable({\n                axis: 'x',\n                items: '.image:not(.image-placeholder)',\n                distance: 8,\n                tolerance: 'pointer',\n\n                /**\n                 * @param {jQuery.Event} event\n                 * @param {Object} data\n                 */\n                stop: function (event, data) {\n                    $galleryContainer.trigger('setPosition', {\n                        imageData: data.item.data('image'),\n                        position: $container.find('.image').index(data.item)\n                    });\n                    $galleryContainer.trigger('resort');\n                }\n            }).disableSelection();\n\n            this.element.find('input[type=\"file\"]').fileupload({\n                dataType: 'json',\n                dropZone: $dropPlaceholder.closest('[data-attribute-code]'),\n                acceptFileTypes: /(\\.|\\/)(gif|jpe?g|png)$/i,\n                maxFileSize: this.element.data('maxFileSize'),\n\n                /**\n                 * @param {jQuery.Event} event\n                 * @param {Object} data\n                 */\n                done: function (event, data) {\n                    $dropPlaceholder.find('.progress-bar').text('').removeClass('in-progress');\n\n                    if (!data.result) {\n                        return;\n                    }\n\n                    if (!data.result.error) {\n                        $galleryContainer.trigger('addItem', data.result);\n                    } else {\n                        alert({\n                            content: $.mage.__('We don\\'t recognize or support this file extension type.')\n                        });\n                    }\n                },\n\n                /**\n                 * @param {jQuery.Event} e\n                 * @param {Object} data\n                 */\n                change: function (e, data) {\n                    if (data.files.length > this.options.maxImageUploadCount) {\n                        $('body').notification('clear').notification('add', {\n                            error: true,\n                            message: $.mage.__('You can\\'t upload more than ' + this.options.maxImageUploadCount +\n                                ' images in one time'),\n\n                            /**\n                             * @param {*} message\n                             */\n                            insertMethod: function (message) {\n                                $('.page-main-actions').after(message);\n                            }\n                        });\n\n                        return false;\n                    }\n                }.bind(this),\n\n                /**\n                 * @param {jQuery.Event} event\n                 * @param {*} data\n                 */\n                add: function (event, data) {\n                    $(this).fileupload('process', data).done(function () {\n                        data.submit();\n                    });\n                },\n\n                /**\n                 * @param {jQuery.Event} e\n                 * @param {Object} data\n                 */\n                progress: function (e, data) {\n                    var progress = parseInt(data.loaded / data.total * 100, 10);\n\n                    $dropPlaceholder.find('.progress-bar').addClass('in-progress').text(progress + '%');\n                },\n\n                /**\n                 * @param {jQuery.Event} event\n                 */\n                start: function (event) {\n                    var uploaderContainer = $(event.target).closest('.image-placeholder');\n\n                    uploaderContainer.addClass('loading');\n                },\n\n                /**\n                 * @param {jQuery.Event} event\n                 */\n                stop: function (event) {\n                    var uploaderContainer = $(event.target).closest('.image-placeholder');\n\n                    uploaderContainer.removeClass('loading');\n                }\n            });\n        }\n    });\n\n    return $.mage.baseImage;\n});\n","Magento_Catalog/catalog/type-events.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    return {\n        $type: $('#product_type_id'),\n\n        /**\n         * Init\n         */\n        init: function () {\n            this.type = {\n                init: this.$type.val(),\n                current: this.$type.val()\n            };\n\n            this.bindAll();\n        },\n\n        /**\n         * Bind all\n         */\n        bindAll: function () {\n            $(document).on('setTypeProduct', function (event, type) {\n                this.setType(type);\n            }.bind(this));\n\n            //direct change type input\n            this.$type.on('change', function () {\n                this.type.current = this.$type.val();\n                this._notifyType();\n            }.bind(this));\n        },\n\n        /**\n         * Set type\n         * @param {String} type - type product (downloadable, simple, virtual ...)\n         * @returns {*}\n         */\n        setType: function (type) {\n            return this.$type.val(type || this.type.init).trigger('change');\n        },\n\n        /**\n         * Notify type\n         * @private\n         */\n        _notifyType: function () {\n            $(document).trigger('changeTypeProduct', this.type);\n        }\n    };\n});\n","Magento_Catalog/catalog/product-attributes.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'uiRegistry',\n    'jquery/ui',\n    'mage/translate'\n], function ($, _, registry) {\n    'use strict';\n\n    $.widget('mage.productAttributes', {\n        /** @inheritdoc */\n        _create: function () {\n            this._on({\n                'click': '_showPopup'\n            });\n        },\n\n        /**\n         * @private\n         */\n        _initModal: function () {\n            var self = this;\n\n            this.modal = $('<div id=\"create_new_attribute\"/>').modal({\n                title: $.mage.__('New Attribute'),\n                type: 'slide',\n                buttons: [],\n\n                /** @inheritdoc */\n                opened: function () {\n                    $(this).parent().addClass('modal-content-new-attribute');\n                    self.iframe = $('<iframe id=\"create_new_attribute_container\">').attr({\n                        src: self._prepareUrl(),\n                        frameborder: 0\n                    });\n                    self.modal.append(self.iframe);\n                    self._changeIframeSize();\n                    $(window).off().on('resize.modal', _.debounce(self._changeIframeSize.bind(self), 400));\n                },\n\n                /** @inheritdoc */\n                closed: function () {\n                    var doc = self.iframe.get(0).document;\n\n                    if (doc && $.isFunction(doc.execCommand)) {\n                        //IE9 break script loading but not execution on iframe removing\n                        doc.execCommand('stop');\n                        self.iframe.remove();\n                    }\n                    self.modal.data('modal').modal.remove();\n                    $(window).off('resize.modal');\n                }\n            });\n        },\n\n        /**\n         * @return {Number}\n         * @private\n         */\n        _getHeight: function () {\n            var modal = this.modal.data('modal').modal,\n                modalHead = modal.find('header'),\n                modalHeadHeight = modalHead.outerHeight(),\n                modalHeight = modal.outerHeight(),\n                modalContentPadding = this.modal.parent().outerHeight() - this.modal.parent().height();\n\n            return modalHeight - modalHeadHeight - modalContentPadding;\n        },\n\n        /**\n         * @return {Number}\n         * @private\n         */\n        _getWidth: function () {\n            return this.modal.width();\n        },\n\n        /**\n         * @private\n         */\n        _changeIframeSize: function () {\n            this.modal.parent().outerHeight(this._getHeight());\n            this.iframe.outerHeight(this._getHeight());\n            this.iframe.outerWidth(this._getWidth());\n\n        },\n\n        /**\n         * @return {String}\n         * @private\n         */\n        _prepareUrl: function () {\n            var productSource,\n                attributeSetId = '';\n\n            if (this.options.dataProvider) {\n                try {\n                    productSource = registry.get(this.options.dataProvider);\n                    attributeSetId = productSource.data.product['attribute_set_id'];\n                } catch (e) {}\n            }\n\n            return this.options.url +\n                (/\\?/.test(this.options.url) ? '&' : '?') +\n                'set=' + attributeSetId;\n        },\n\n        /**\n         * @private\n         */\n        _showPopup: function () {\n            this._initModal();\n            this.modal.modal('openModal');\n        }\n    });\n\n    return $.mage.productAttributes;\n});\n","Magento_Catalog/catalog/product.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nrequire([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    window.Product = {};\n\n    /**\n     * @param {String} id\n     * @return {*|jQuery|HTMLElement}\n     */\n    function byId(id) {\n        return $('#' + id);\n    }\n\n    /**\n     * @param {String} fieldId\n     */\n    function disableFieldEditMode(fieldId) {\n        var field = byId(fieldId);\n\n        field.prop('disabled', true);\n\n        if (field.next().hasClass('addafter')) {\n            field.parent().addClass('_update-attributes-disabled');\n        }\n\n        if (byId(fieldId + '_hidden').length) {\n            byId(fieldId + '_hidden').prop('disabled', true);\n        }\n    }\n\n    /**\n     * @param {String} fieldId\n     */\n    function enableFieldEditMode(fieldId) {\n        var field = byId(fieldId);\n\n        field.prop('disabled', false);\n\n        if (field.parent().hasClass('_update-attributes-disabled')) {\n            field.parent().removeClass('_update-attributes-disabled');\n        }\n\n        if (byId(fieldId + '_hidden').length) {\n            byId(fieldId + '_hidden').prop('disabled', false);\n        }\n    }\n\n    /**\n     * @param {String} toogleIdentifier\n     * @param {String} fieldId\n     */\n    function toogleFieldEditMode(toogleIdentifier, fieldId) {\n        if ($(toogleIdentifier).is(':checked')) {\n            enableFieldEditMode(fieldId);\n        } else {\n            disableFieldEditMode(fieldId);\n        }\n    }\n\n    /**\n     * On complete disable.\n     */\n    function onCompleteDisableInited() {\n        var item;\n\n        $.each($('[data-disable]'), function () {\n            item = $(this).data('disable');\n            disableFieldEditMode(item);\n        });\n    }\n\n    /**\n     * @param {String} urlKey\n     */\n    function onUrlkeyChanged(urlKey) {\n        var hidden, chbx, oldValue;\n\n        urlKey = byId(urlKey);\n        hidden = urlKey.siblings('input[type=hidden]');\n        chbx = urlKey.siblings('input[type=checkbox]');\n        oldValue = chbx.val();\n\n        chbx.prop('disabled', oldValue === urlKey.val());\n        hidden.prop('disabled', chbx.prop('disabled'));\n    }\n\n    /**\n     * @param {HTMLElement} element\n     */\n    function onCustomUseParentChanged(element) {\n        var useParent, parent;\n\n        element = $(element);\n        useParent = element.val() == 1; //eslint-disable-line eqeqeq\n        parent = element.offsetParent().parent();\n\n        parent.find('input, select, textarea').each(function (i, el) {\n            el = $(el);\n\n            if (element.prop('id') !== el.prop('id')) {\n                el.prop('disabled', useParent);\n            }\n        });\n\n        parent.find('img').each(function (i, el) {\n            if (useParent) {\n                $(el).hide();\n            } else {\n                $(el).show();\n            }\n        });\n    }\n\n    window.onCustomUseParentChanged = onCustomUseParentChanged;\n    window.onUrlkeyChanged = onUrlkeyChanged;\n    window.toogleFieldEditMode = toogleFieldEditMode;\n\n    $(onCompleteDisableInited);\n});\n","Magento_Catalog/catalog/apply-to-type-switcher.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_Catalog/catalog/type-events'\n], function ($, productType) {\n    'use strict';\n\n    return {\n\n        /**\n         * Bind event\n         */\n        bindAll: function () {\n            $('[data-form=edit-product] [data-role=tabs]').on(\n                'contentUpdated',\n                this._switchToTypeByApplyAttr.bind(this)\n            );\n\n            $('#product_info_tabs').on(\n                'beforePanelsMove tabscreate tabsactivate',\n                this._switchToTypeByApplyAttr.bind(this)\n            );\n\n            $(document).on('changeTypeProduct', this._switchToTypeByApplyAttr.bind(this));\n        },\n\n        /**\n         * Constructor component\n         */\n        'Magento_Catalog/catalog/apply-to-type-switcher': function () {\n            this.bindAll();\n            this._switchToTypeByApplyAttr();\n        },\n\n        /**\n         * Show/hide elements based on type\n         *\n         * @private\n         */\n        _switchToTypeByApplyAttr: function () {\n            $('[data-apply-to]:not(.removed)').each(function (index, element) {\n                var attrContainer = $(element),\n                    applyTo = attrContainer.data('applyTo') || [],\n                    $inputs = attrContainer.find('select, input, textarea');\n\n                if (applyTo.length === 0 || $.inArray(productType.type.current, applyTo) !== -1) {\n                    attrContainer.removeClass('not-applicable-attribute');\n                    $inputs.removeClass('ignore-validate');\n                } else {\n                    attrContainer.addClass('not-applicable-attribute');\n                    $inputs.addClass('ignore-validate');\n                }\n            });\n        }\n    };\n});\n","Magento_Catalog/catalog/category/edit.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * Create/edit some category\n * @deprecated since version 2.2.0\n */\n\n/* global tree */\ndefine([\n    'jquery',\n    'prototype'\n], function (jQuery) {\n    'use strict';\n\n    /** Category submit. */\n    var categorySubmit = function () {\n        var activeTab = $('active_tab_id'),\n            params = {},\n            fields, i,categoryId, isCreating, path, parentId, currentNode, oldClass, newClass;\n\n        if (activeTab) {\n            if (activeTab.tabsJsObject && activeTab.tabsJsObject.tabs('activeAnchor')) {\n                activeTab.value = activeTab.tabsJsObject.tabs('activeAnchor').prop('id');\n            }\n        }\n\n        fields = $('category_edit_form').getElementsBySelector('input', 'select');\n\n        for (i = 0; i < fields.length; i++) {\n            if (!fields[i].name) {\n                continue;//jscs:ignore\n            }\n            params[fields[i].name] = fields[i].getValue();\n        }\n\n        // Get info about what we're submitting - to properly update tree nodes\n        categoryId = params['general[id]'] ? params['general[id]'] : 0;\n        isCreating = categoryId == 0; // eslint-disable-line eqeqeq\n        path = params['general[path]'].split('/');\n        parentId = path.pop();\n\n        if (parentId == categoryId) { // eslint-disable-line eqeqeq\n            parentId = path.pop();\n        }\n\n        // Make operations with category tree\n        if (isCreating) {\n            /* Some specific tasks for creating category */\n            if (!tree.currentNodeId) {\n                // First submit of form - select some node to be current\n                tree.currentNodeId = parentId;\n            }\n            tree.addNodeTo = parentId;\n        } else {\n            /* Some specific tasks for editing category */\n            // Maybe change category enabled/disabled style\n            if (tree && tree.storeId == 0) {// eslint-disable-line eqeqeq, no-lonely-if\n                currentNode = tree.getNodeById(categoryId);\n\n                if (currentNode) {//eslint-disable-line max-depth\n                    if (parseInt(params['general[is_active]'])) {//eslint-disable-line radix, max-depth\n                        oldClass = 'no-active-category';\n                        newClass = 'active-category';\n                    } else {\n                        oldClass = 'active-category';\n                        newClass = 'no-active-category';\n                    }\n\n                    Element.removeClassName(currentNode.ui.wrap.firstChild, oldClass);\n                    Element.addClassName(currentNode.ui.wrap.firstChild, newClass);\n                }\n            }\n        }\n\n        // Submit form\n        jQuery('#category_edit_form').trigger('submit');\n    };\n\n    return function (config, element) {\n        config = config || {};\n        jQuery(element).on('click', function () {\n            categorySubmit();\n        });\n    };\n});\n","Magento_Catalog/catalog/category/assign-products.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global $, $H */\n\ndefine([\n    'mage/adminhtml/grid'\n], function () {\n    'use strict';\n\n    return function (config) {\n        var selectedProducts = config.selectedProducts,\n            categoryProducts = $H(selectedProducts),\n            gridJsObject = window[config.gridJsObjectName],\n            tabIndex = 1000;\n\n        $('in_category_products').value = Object.toJSON(categoryProducts);\n\n        /**\n         * Register Category Product\n         *\n         * @param {Object} grid\n         * @param {Object} element\n         * @param {Boolean} checked\n         */\n        function registerCategoryProduct(grid, element, checked) {\n            if (checked) {\n                if (element.positionElement) {\n                    element.positionElement.disabled = false;\n                    categoryProducts.set(element.value, element.positionElement.value);\n                }\n            } else {\n                if (element.positionElement) {\n                    element.positionElement.disabled = true;\n                }\n                categoryProducts.unset(element.value);\n            }\n            $('in_category_products').value = Object.toJSON(categoryProducts);\n            grid.reloadParams = {\n                'selected_products[]': categoryProducts.keys()\n            };\n        }\n\n        /**\n         * Click on product row\n         *\n         * @param {Object} grid\n         * @param {String} event\n         */\n        function categoryProductRowClick(grid, event) {\n            var trElement = Event.findElement(event, 'tr'),\n                eventElement = Event.element(event),\n                isInputCheckbox = eventElement.tagName === 'INPUT' && eventElement.type === 'checkbox',\n                isInputPosition = grid.targetElement &&\n                    grid.targetElement.tagName === 'INPUT' &&\n                    grid.targetElement.name === 'position',\n                checked = false,\n                checkbox = null;\n\n            if (eventElement.tagName === 'LABEL' &&\n                trElement.querySelector('#' + eventElement.htmlFor) &&\n                trElement.querySelector('#' + eventElement.htmlFor).type === 'checkbox'\n            ) {\n                event.stopPropagation();\n                trElement.querySelector('#' + eventElement.htmlFor).trigger('click');\n\n                return;\n            }\n\n            if (trElement && !isInputPosition) {\n                checkbox = Element.getElementsBySelector(trElement, 'input');\n\n                if (checkbox[0]) {\n                    checked = isInputCheckbox ? checkbox[0].checked : !checkbox[0].checked;\n                    gridJsObject.setCheckboxChecked(checkbox[0], checked);\n                }\n            }\n        }\n\n        /**\n         * Change product position\n         *\n         * @param {String} event\n         */\n        function positionChange(event) {\n            var element = Event.element(event);\n\n            if (element && element.checkboxElement && element.checkboxElement.checked) {\n                categoryProducts.set(element.checkboxElement.value, element.value);\n                $('in_category_products').value = Object.toJSON(categoryProducts);\n            }\n        }\n\n        /**\n         * Initialize category product row\n         *\n         * @param {Object} grid\n         * @param {String} row\n         */\n        function categoryProductRowInit(grid, row) {\n            var checkbox = $(row).getElementsByClassName('checkbox')[0],\n                position = $(row).getElementsByClassName('input-text')[0];\n\n            if (checkbox && position) {\n                checkbox.positionElement = position;\n                position.checkboxElement = checkbox;\n                position.disabled = !checkbox.checked;\n                position.tabIndex = tabIndex++;\n                Event.observe(position, 'keyup', positionChange);\n            }\n        }\n\n        gridJsObject.rowClickCallback = categoryProductRowClick;\n        gridJsObject.initRowCallback = categoryProductRowInit;\n        gridJsObject.checkboxCheckCallback = registerCategoryProduct;\n\n        if (gridJsObject.rows) {\n            gridJsObject.rows.each(function (row) {\n                categoryProductRowInit(gridJsObject, row);\n            });\n        }\n    };\n});\n","Magento_Catalog/catalog/category/form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/alert'\n], function ($, alert) {\n    'use strict';\n\n    return function (config) {\n        var categoryForm = {\n            options: {\n                categoryIdSelector: 'input[name=\"id\"]',\n                categoryPathSelector: 'input[name=\"path\"]',\n                categoryParentSelector: 'input[name=\"parent\"]',\n                categoryLevelSelector: 'input[name=\"level\"]',\n                refreshUrl: config.refreshUrl\n            },\n\n            /**\n             * Sending ajax to server to refresh field 'path'\n             * @protected\n             */\n            refreshPath: function () {\n                if (!$(this.options.categoryIdSelector)) {\n                    return false;\n                }\n                $.ajax({\n                    url: this.options.refreshUrl,\n                    method: 'GET',\n                    showLoader: true\n                }).done(this._refreshPathSuccess.bind(this));\n            },\n\n            /**\n             * Refresh field 'path' on ajax success\n             * @param {Object} data\n             * @private\n             */\n            _refreshPathSuccess: function (data) {\n                if (data.error) {\n                    alert({\n                        content: data.message\n                    });\n                } else {\n                    $(this.options.categoryIdSelector).val(data.id).change();\n                    $(this.options.categoryPathSelector).val(data.path).change();\n                    $(this.options.categoryParentSelector).val(data.parentId).change();\n                    $(this.options.categoryLevelSelector).val(data.level).change();\n                }\n            }\n        };\n\n        $('body').on('categoryMove.tree', $.proxy(categoryForm.refreshPath.bind(categoryForm), this));\n    };\n});\n","Magento_Catalog/catalog/product/attribute/unique-validate.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/backend/validation'\n], function (jQuery) {\n    'use strict';\n\n    return function (config) {\n        var msg = '',\n            _config = jQuery.extend({\n                element: null,\n                message: '',\n                uniqueClass: 'required-unique'\n            }, config),\n\n            /** @inheritdoc */\n            messager = function () {\n                return msg;\n            };\n\n        if (typeof _config.element === 'string') {\n            jQuery.validator.addMethod(\n                _config.element,\n\n                function (value, element) {\n                    var inputs = jQuery(element)\n                            .closest('table')\n                            .find('.' + _config.uniqueClass + ':visible'),\n                        valuesHash = {},\n                        isValid = true,\n                        duplicates = [];\n\n                    inputs.each(function (el) {\n                        var inputValue = inputs[el].value;\n\n                        if (typeof valuesHash[inputValue] !== 'undefined') {\n                            isValid = false;\n                            duplicates.push(inputValue);\n                        }\n                        valuesHash[inputValue] = el;\n                    });\n\n                    if (!isValid) {\n                        msg = _config.message + ' (' + duplicates.join(', ') + ')';\n                    }\n\n                    return isValid;\n                },\n\n                messager\n            );\n        }\n    };\n});\n","Magento_Catalog/catalog/product/composite/configure.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'Magento_Ui/js/lib/view/utils/async',\n    'jquery/ui',\n    'mage/translate',\n    'prototype',\n    'Magento_Ui/js/modal/modal'\n], function (jQuery) {\n\n    window.ProductConfigure = Class.create();\n\n    ProductConfigure.prototype = {\n\n        listTypes:                  $H({}),\n        current:                    $H({}),\n        itemsFilter:                $H({}),\n        blockWindow:                null,\n        blockForm:                  null,\n        blockFormFields:            null,\n        blockFormAdd:               null,\n        blockFormConfirmed:         null,\n        blockConfirmed:             null,\n        blockIFrame:                null,\n        blockCancelBtn:             null,\n        blockMask:                  null,\n        blockMsg:                   null,\n        blockMsgError:              null,\n        windowHeight:               null,\n        confirmedCurrentId:         null,\n        confirmCallback:            {},\n        cancelCallback:             {},\n        onLoadIFrameCallback:       {},\n        showWindowCallback:         {},\n        beforeSubmitCallback:       {},\n        iFrameJSVarname:            null,\n        _listTypeId:                1,\n\n        /**\n         * Initialize object\n         */\n        initialize: function () {\n            var self = this,\n                popupDialog = jQuery('#product_composite_configure');\n\n            this._initWindowElements();\n            jQuery.async('#product_composite_configure', function (el) {\n                if (el !== popupDialog[0]) {\n                    el = popupDialog[0];\n                }\n                self.dialog = jQuery(el).modal({\n                    title: jQuery.mage.__('Configure Product'),\n                    type: 'slide',\n                    buttons: [{\n                        text: jQuery.mage.__('OK'),\n                        'class': 'action-primary',\n                        click: function () {\n                            self.onConfirmBtn();\n                        }\n                    }],\n                    closed: function () {\n                        self.clean('window');\n                    },\n                });\n            });\n        },\n\n        /**\n         * Initialize window elements\n         */\n        _initWindowElements: function () {\n            this.blockWindow                = $('product_composite_configure');\n            this.blockForm                  = $('product_composite_configure_form');\n            this.blockFormFields            = $('product_composite_configure_form_fields');\n            this.blockFormAdd               = $('product_composite_configure_form_additional');\n            this.blockFormConfirmed         = $('product_composite_configure_form_confirmed');\n            this.blockConfirmed             = $('product_composite_configure_confirmed');\n            this.blockIFrame                = $('product_composite_configure_iframe');\n            this.blockCancelBtn             = $('product_composite_configure_form_cancel');\n            this.blockMsg                   = $('product_composite_configure_messages');\n            this.blockMsgError              = this.blockMsg.select('.message.error div')[0];\n            this.iFrameJSVarname            = this.blockForm.select('input[name=\"as_js_varname\"]')[0].value;\n        },\n\n        /**\n         * Returns next unique list type id\n         */\n        _generateListTypeId: function () {\n            return '_internal_lt_' + this._listTypeId++;\n        },\n\n        /**\n         * Add product list types as scope and their urls\n         * example: addListType('product_to_add', {urlFetch: 'http://magento...'})\n         * example: addListType('wishlist', {urlSubmit: 'http://magento...'})\n         *\n         * @param type types as scope\n         * @param urls obj can be\n         *             - {urlFetch: 'http://magento...'} for fetching configuration fields through ajax\n         *             - {urlConfirm: 'http://magento...'} for submit configured data through iFrame when clicked confirm button\n         *             - {urlSubmit: 'http://magento...'} for submit configured data through iFrame\n         */\n        addListType: function (type, urls) {\n            if ('undefined' == typeof this.listTypes[type]) {\n                this.listTypes[type] = {};\n            }\n            Object.extend(this.listTypes[type], urls);\n\n            return this;\n        },\n\n        /**\n         * Adds complex list type - that is used to submit several list types at once\n         * Only urlSubmit is possible for this list type\n         * example: addComplexListType(['wishlist', 'product_list'], 'http://magento...')\n         *\n         * @param type types as scope\n         * @param urls obj can be\n         *             - {urlSubmit: 'http://magento...'} for submit configured data through iFrame\n         * @return type string\n         */\n        addComplexListType: function (types, urlSubmit) {\n            var type = this._generateListTypeId();\n\n            this.listTypes[type] = {};\n            this.listTypes[type].complexTypes = types;\n            this.listTypes[type].urlSubmit = urlSubmit;\n\n            return type;\n        },\n\n        /**\n         * Add filter of items\n         *\n         * @param listType scope name\n         * @param itemsFilter\n         */\n        addItemsFilter: function (listType, itemsFilter) {\n            if (!listType || !itemsFilter) {\n                return false;\n            }\n\n            if ('undefined' == typeof this.itemsFilter[listType]) {\n                this.itemsFilter[listType] = [];\n            }\n            this.itemsFilter[listType] = this.itemsFilter[listType].concat(itemsFilter);\n\n            return this;\n        },\n\n        /**\n         * Returns id of block where configuration for an item is stored\n         *\n         * @param listType scope name\n         * @param itemId\n         * @return string\n         */\n        _getConfirmedBlockId: function (listType, itemId) {\n            return this.blockConfirmed.id + '[' + listType + '][' + itemId + ']';\n        },\n\n        /**\n         * Checks whether item has some configuration fields\n         *\n         * @param listType scope name\n         * @param itemId\n         * @return bool\n         */\n        itemConfigured: function (listType, itemId) {\n            var confirmedBlockId = this._getConfirmedBlockId(listType, itemId);\n            var itemBlock = $(confirmedBlockId);\n\n            return !!(itemBlock && itemBlock.innerHTML);\n        },\n\n        /**\n         * Show configuration fields of item, if it not found then get it through ajax\n         *\n         * @param listType scope name\n         * @param itemId\n         */\n        showItemConfiguration: function (listType, itemId) {\n            if (!listType || !itemId) {\n                return false;\n            }\n\n            this.initialize();\n            this.current.listType = listType;\n            this.current.itemId = itemId;\n            this.confirmedCurrentId = this._getConfirmedBlockId(listType, itemId);\n\n            if (!this.itemConfigured(listType, itemId)) {\n                this._requestItemConfiguration(listType, itemId);\n            } else {\n                this._processFieldsData('item_restore');\n                this._showWindow();\n            }\n        },\n\n        /**\n         * Get configuration fields of product through ajax and show them\n         *\n         * @param listType scope name\n         * @param itemId\n         */\n        _requestItemConfiguration: function (listType, itemId) {\n            if (!this.listTypes[listType].urlFetch) {\n                return false;\n            }\n            var url = this.listTypes[listType].urlFetch;\n\n            if (url) {\n                new Ajax.Request(url, {\n                    parameters: {\n                        id: itemId\n                    },\n                    onSuccess: function (transport) {\n                        var response = transport.responseText;\n\n                        if (response.isJSON()) {\n                            response = response.evalJSON();\n\n                            if (response.error) {\n                                this.blockMsg.show();\n                                this.blockMsgError.innerHTML = response.message;\n                                this.blockCancelBtn.hide();\n                                this.setConfirmCallback(listType, null);\n                                this._showWindow();\n                            }\n                        } else if (response) {\n                            response += '';\n                            this.blockFormFields.update(response);\n\n                            // Add special div to hold mage data, e.g. scripts to execute on every popup show\n                            var mageData = {};\n                            var scripts = response.extractScripts();\n\n                            mageData.scripts = scripts;\n\n                            var scriptHolder = new Element('div', {\n                                'style': 'display:none'\n                            });\n\n                            scriptHolder.mageData = mageData;\n                            this.blockFormFields.insert(scriptHolder);\n\n                            // Show window\n                            this._showWindow();\n                        }\n                    }.bind(this)\n                });\n            }\n        },\n\n        /**\n         * Triggered on confirm button click\n         * Do submit configured data through iFrame if needed\n         */\n        onConfirmBtn: function () {\n            if (jQuery(this.blockForm).valid()) {\n                if (this.listTypes[this.current.listType].urlConfirm) {\n                    this.submit();\n                } else {\n                    this._processFieldsData('item_confirm');\n                    this._closeWindow();\n\n                    if (Object.isFunction(this.confirmCallback[this.current.listType])) {\n                        this.confirmCallback[this.current.listType]();\n                    }\n                }\n            }\n\n            return this;\n        },\n\n        /**\n         * Triggered on cancel button click\n         */\n        onCancelBtn: function () {\n            this._closeWindow();\n\n            if (Object.isFunction(this.cancelCallback[this.current.listType])) {\n                this.cancelCallback[this.current.listType]();\n            }\n\n            return this;\n        },\n\n        /**\n         * Submit configured data through iFrame\n         *\n         * @param listType scope name\n         */\n        submit: function (listType) {\n            // prepare data\n            if (listType) {\n                this.current.listType = listType;\n                this.current.itemId = null;\n            }\n            var urlConfirm = this.listTypes[this.current.listType].urlConfirm;\n            var urlSubmit = this.listTypes[this.current.listType].urlSubmit;\n\n            if (!urlConfirm && !urlSubmit) {\n                return false;\n            }\n\n            if (urlConfirm) {\n                this.blockForm.action = urlConfirm;\n                this.addFields([new Element('input', {\n                    type: 'hidden', name: 'id', value: this.current.itemId\n                })]);\n            } else {\n                this.blockForm.action = urlSubmit;\n\n                var complexTypes = this.listTypes[this.current.listType].complexTypes;\n\n                if (complexTypes) {\n                    this.addFields([new Element('input', {\n                        type: 'hidden', name: 'configure_complex_list_types', value: complexTypes.join(',')\n                    })]);\n                }\n\n                this._processFieldsData('current_confirmed_to_form');\n\n                // Disable item controls that duplicate added fields (e.g. sometimes qty controls can intersect)\n                // so they won't be submitted\n                var tagNames = ['input', 'select', 'textarea'];\n\n                var names = {}; // Map of added field names\n\n                for (var i = 0, len = tagNames.length; i < len; i++) {\n                    var tagName = tagNames[i];\n                    var elements = this.blockFormAdd.getElementsByTagName(tagName);\n\n                    for (var index = 0, elLen = elements.length; index < elLen; index++) {\n                        names[elements[index].name] = true;\n                    }\n                }\n\n                for (var i = 0, len = tagNames.length; i < len; i++) {\n                    var tagName = tagNames[i];\n                    var elements = this.blockFormConfirmed.getElementsByTagName(tagName);\n\n                    for (var index = 0, elLen = elements.length; index < elLen; index++) {\n                        var element = elements[index];\n\n                        if (names[element.name]) {\n                            element.setAttribute('configure_disabled', 1);\n                            element.setAttribute('configure_prev_disabled', element.disabled ? 1 : 0);\n                            element.disabled = true;\n                        } else {\n                            element.setAttribute('configure_disabled', 0);\n                        }\n                    }\n                }\n            }\n            // do submit\n            if (Object.isFunction(this.beforeSubmitCallback[this.current.listType])) {\n                this.beforeSubmitCallback[this.current.listType]();\n            }\n            this.blockForm.submit();\n\n            // Show loader\n            jQuery(this.blockForm).trigger('processStart');\n\n            return this;\n        },\n\n        /**\n         * Add dynamically additional fields for form\n         *\n         * @param fields\n         */\n        addFields: function (fields) {\n            fields.each(function (elm) {\n                this.blockFormAdd.insert(elm);\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Triggered when form was submitted and iFrame was loaded. Get response from iFrame and handle it\n         */\n        onLoadIFrame: function () {\n            this.blockFormConfirmed.select('[configure_disabled=1]').each(function (element) {\n                element.disabled = element.getAttribute('configure_prev_disabled') == '1';\n            });\n\n            this._processFieldsData('form_confirmed_to_confirmed');\n\n            var response = this.blockIFrame.contentWindow[this.iFrameJSVarname];\n\n            if (response && 'object' == typeof response) {\n                if (this.listTypes[this.current.listType].urlConfirm) {\n                    if (response.ok) {\n                        this._closeWindow();\n                        this.clean('current');\n                    } else if (response.error) {\n                        this.showItemConfiguration(this.current.listType, this.current.itemId);\n                        this.blockMsg.show();\n                        this.blockMsgError.innerHTML = response.message;\n                        this._showWindow();\n\n                        jQuery(this.blockForm).trigger('processStop');\n                        return false;\n                    }\n                }\n\n                if (Object.isFunction(this.onLoadIFrameCallback[this.current.listType])) {\n                    this.onLoadIFrameCallback[this.current.listType](response);\n                }\n                document.fire(this.current.listType + ':afterIFrameLoaded');\n            }\n            // Hide loader\n            jQuery(this.blockForm).trigger('processStop');\n\n            this.clean('current');\n            this.initialize();\n        },\n\n        /**\n         * Helper for fetching content from iFrame\n         */\n        _getIFrameContent: function () {\n            var content = this.blockIFrame.contentWindow || this.blockIFrame.contentDocument;\n\n            if (content.document) {\n                content = content.document;\n            }\n\n            return content;\n        },\n\n        /**\n         * Helper to find qty of currently confirmed item\n         */\n        getCurrentConfirmedQtyElement: function () {\n            var elms = $(this.confirmedCurrentId).getElementsByTagName('input');\n\n            for (var i = 0; i < elms.length; i++) {\n                if (elms[i].name == 'qty') {\n                    return elms[i];\n                }\n            }\n        },\n\n        /**\n         * Helper to find select element of currently confirmed item\n         */\n        getCurrentConfirmedSelectElement: function () {\n            return $(this.confirmedCurrentId).getElementsByTagName('select');\n        },\n\n        /**\n         * Helper to find qty of active form\n         */\n        getCurrentFormQtyElement: function () {\n            var elms = this.blockFormFields.getElementsByTagName('input');\n\n            for (var i = 0; i < elms.length; i++) {\n                if (elms[i].name == 'qty') {\n                    return elms[i];\n                }\n            }\n        },\n\n        /**\n         * Show configuration window\n         */\n        _showWindow: function () {\n            this.dialog.modal('openModal');\n            //this._toggleSelectsExceptBlock(false);\n\n            if (Object.isFunction(this.showWindowCallback[this.current.listType])) {\n                this.showWindowCallback[this.current.listType]();\n            }\n        },\n\n        /**\n         * Close configuration window\n         */\n        _closeWindow: function () {\n            this.dialog.modal('closeModal');\n            //this.blockWindow.style.display = 'none';\n            //this.clean('window');\n        },\n\n        /**\n         * Attach callback function triggered when confirm button was clicked\n         *\n         * @param confirmCallback\n         */\n        setConfirmCallback: function (listType, confirmCallback) {\n            this.confirmCallback[listType] = confirmCallback;\n\n            return this;\n        },\n\n        /**\n         * Attach callback function triggered when cancel button was clicked\n         *\n         * @param cancelCallback\n         */\n        setCancelCallback: function (listType, cancelCallback) {\n            this.cancelCallback[listType] = cancelCallback;\n\n            return this;\n        },\n\n        /**\n         * Attach callback function triggered when iFrame was loaded\n         *\n         * @param onLoadIFrameCallback\n         */\n        setOnLoadIFrameCallback: function (listType, onLoadIFrameCallback) {\n            this.onLoadIFrameCallback[listType] = onLoadIFrameCallback;\n\n            return this;\n        },\n\n        /**\n         * Attach callback function triggered when iFrame was loaded\n         *\n         * @param showWindowCallback\n         */\n        setShowWindowCallback: function (listType, showWindowCallback) {\n            this.showWindowCallback[listType] = showWindowCallback;\n\n            return this;\n        },\n\n        /**\n         * Attach callback function triggered before submitting form\n         *\n         * @param beforeSubmitCallback\n         */\n        setBeforeSubmitCallback: function (listType, beforeSubmitCallback) {\n            this.beforeSubmitCallback[listType] = beforeSubmitCallback;\n\n            return this;\n        },\n\n        /**\n         * Clean object data\n         *\n         * @param method can be 'all' or 'current'\n         */\n        clean: function (method) {\n            var listInfo = null;\n            var listTypes = null;\n            var removeConfirmed = function (listTypes) {\n                this.blockConfirmed.childElements().each(function (elm) {\n                    for (var i = 0, len = listTypes.length; i < len; i++) {\n                        var pattern = this.blockConfirmed.id + '[' + listTypes[i] + ']';\n\n                        if (elm.id.indexOf(pattern) == 0) {\n                            elm.remove();\n                            break;\n                        }\n                    }\n                }.bind(this));\n            }.bind(this);\n\n            switch (method) {\n                case 'current':\n                    listInfo = this.listTypes[this.current.listType];\n                    listTypes = [this.current.listType];\n\n                    if (listInfo && listInfo.complexTypes) {\n                        listTypes = listTypes.concat(listInfo.complexTypes);\n                    }\n                    removeConfirmed(listTypes);\n                    break;\n\n                case 'window':\n                    this.blockFormFields.update();\n                    this.blockMsg.hide();\n                    this.blockMsgError.update();\n                    this.blockCancelBtn.show();\n                    break;\n                default:\n                    // search in list types for its cleaning\n                    if (this.listTypes[method]) {\n                        listInfo = this.listTypes[method];\n                        listTypes = [method];\n\n                        if (listInfo.complexTypes) {\n                            listTypes = listTypes.concat(listInfo.complexTypes);\n                        }\n                        removeConfirmed(listTypes);\n                        // clean all\n                    } else if (!method) {\n                        this.current = $H({});\n                        this.blockConfirmed.update();\n                        this.blockFormFields.update();\n                        this.blockMsg.hide();\n                        this.blockMsgError.update();\n                        this.blockCancelBtn.show();\n                    }\n                    break;\n            }\n            this._getIFrameContent().body.innerHTML = '';\n            this.blockIFrame.contentWindow[this.iFrameJSVarname] = {};\n            this.blockFormAdd.update();\n            this.blockFormConfirmed.update();\n            this.blockForm.action = '';\n\n            return this;\n        },\n\n        /**\n         * Process fields data: save, restore, move saved to form and back\n         *\n         * @param method can be 'item_confirm', 'item_restore', 'current_confirmed_to_form', 'form_confirmed_to_confirmed'\n         */\n        _processFieldsData: function (method) {\n            var self = this;\n\n            /**\n             * Internal function for rename fields names of some list type\n             * if listType is not specified, then it won't be added as prefix to all names\n             *\n             * @param method can be 'current_confirmed_to_form', 'form_confirmed_to_confirmed'\n             * @param blockItem\n             */\n            var _renameFields = function (method, blockItem, listType) {\n                var pattern           = null;\n                var patternFlat       = null;\n                var patternPrefix     = RegExp('\\\\s', 'g');\n                var replacement       = null;\n                var replacementFlat   = null;\n                var replacementPrefix = '_';\n                var scopeArr          = blockItem.id.match(/.*\\[\\w+\\]\\[([^\\]]+)\\]$/);\n                var itemId            = scopeArr[1];\n\n                if (method == 'current_confirmed_to_form') {\n                    pattern         = RegExp('(\\\\w+)(\\\\[?)');\n                    patternFlat     = RegExp('(\\\\w+)');\n                    replacement     = 'item[' + itemId + '][$1]$2';\n                    replacementFlat = 'item_' + itemId + '_$1';\n\n                    if (listType) {\n                        replacement = 'list[' + listType + '][item][' + itemId + '][$1]$2';\n                        replacementFlat = 'list_' + listType + '_' + replacementFlat;\n                    }\n                } else if (method == 'form_confirmed_to_confirmed') {\n                    var stPattern = 'item\\\\[' + itemId + '\\\\]\\\\[(\\\\w+)\\\\](.*)';\n                    var stPatternFlat = 'item_' + itemId + '_(\\\\w+)';\n\n                    if (listType) {\n                        stPattern = 'list\\\\[' + listType + '\\\\]\\\\[item\\\\]\\\\[' + itemId + '\\\\]\\\\[(\\\\w+)\\\\](.*)';\n                        stPatternFlat = 'list_' + listType + '_' + stPatternFlat;\n                    }\n                    pattern         = new RegExp(stPattern);\n                    patternFlat     = new RegExp(stPatternFlat);\n                    replacement     = '$1$2';\n                    replacementFlat = '$1';\n                } else {\n                    return false;\n                }\n                var rename = function (elms) {\n                    for (var i = 0; i < elms.length; i++) {\n                        if (elms[i].name && elms[i].type == 'file') {\n                            var prefixName = 'options[files_prefix]',\n                                prefixValue = 'item_' + itemId + '_';\n\n                            self.blockFormFields.insert(new Element('input', {\n                                type: 'hidden',\n                                name: prefixName.replace(pattern, replacement),\n                                value: prefixValue.replace(patternPrefix, replacementPrefix)\n                            }));\n                            elms[i].name = elms[i].name.replace(patternFlat, replacementFlat);\n                        } else if (elms[i].name) {\n                            elms[i].name = elms[i].name.replace(pattern, replacement);\n                        }\n                    }\n                };\n\n                rename(blockItem.getElementsByTagName('input'));\n                rename(blockItem.getElementsByTagName('select'));\n                rename(blockItem.getElementsByTagName('textarea'));\n            };\n\n            switch (method) {\n                case 'item_confirm':\n                    if (!$(this.confirmedCurrentId)) {\n                        this.blockConfirmed.insert(new Element('div', {\n                            id: this.confirmedCurrentId\n                        }));\n                    } else {\n                        $(this.confirmedCurrentId).update();\n                    }\n                    this.blockFormFields.childElements().each(function (elm) {\n                        $(this.confirmedCurrentId).insert(elm);\n                    }.bind(this));\n                    break;\n\n                case 'item_restore':\n                    this.blockFormFields.update();\n\n                    // clone confirmed to form\n                    var mageData = null;\n\n                    $(this.confirmedCurrentId).childElements().each(function (elm) {\n                        var cloned = elm.cloneNode(true);\n\n                        if (elm.mageData) {\n                            cloned.mageData = elm.mageData;\n                            mageData = elm.mageData;\n                        }\n                        this.blockFormFields.insert(cloned);\n                    }.bind(this));\n\n                    // get confirmed values\n                    var fieldsValue = {};\n                    var getConfirmedValues = function (elms) {\n                        for (var i = 0; i < elms.length; i++) {\n                            if (elms[i].name) {\n                                if ('undefined' == typeof fieldsValue[elms[i].name]) {\n                                    fieldsValue[elms[i].name] = {};\n                                }\n\n                                if (elms[i].type == 'checkbox') {\n                                    fieldsValue[elms[i].name][elms[i].value] = elms[i].checked;\n                                } else if (elms[i].type == 'radio') {\n                                    if (elms[i].checked) {\n                                        fieldsValue[elms[i].name] = elms[i].value;\n                                    }\n                                } else {\n                                    fieldsValue[elms[i].name] = Form.Element.getValue(elms[i]);\n                                }\n                            }\n                        }\n                    };\n\n                    getConfirmedValues($(this.confirmedCurrentId).getElementsByTagName('input'));\n                    getConfirmedValues($(this.confirmedCurrentId).getElementsByTagName('select'));\n                    getConfirmedValues($(this.confirmedCurrentId).getElementsByTagName('textarea'));\n\n                    // restore confirmed values\n                    var restoreConfirmedValues = function (elms) {\n                        for (var i = 0; i < elms.length; i++) {\n                            if ('undefined' != typeof fieldsValue[elms[i].name]) {\n                                if (elms[i].type != 'file') {\n                                    if (elms[i].type == 'checkbox') {\n                                        elms[i].checked = fieldsValue[elms[i].name][elms[i].value];\n                                    } else if (elms[i].type == 'radio') {\n                                        if (elms[i].value == fieldsValue[elms[i].name]) {\n                                            elms[i].checked = true;\n                                        }\n                                    } else {\n                                        elms[i].setValue(fieldsValue[elms[i].name]);\n                                    }\n                                }\n                            }\n                        }\n                    };\n\n                    restoreConfirmedValues(this.blockFormFields.getElementsByTagName('input'));\n                    restoreConfirmedValues(this.blockFormFields.getElementsByTagName('select'));\n                    restoreConfirmedValues(this.blockFormFields.getElementsByTagName('textarea'));\n\n                    // Execute scripts\n                    if (mageData && mageData.scripts) {\n                        this.restorePhase = true;\n\n                        try {\n                            mageData.scripts.map(function (script) {\n                                return eval(script);\n                            });\n                        } catch (e) {\n\n                        }\n                        this.restorePhase = false;\n                    }\n                    break;\n\n                case 'current_confirmed_to_form':\n                    var allowedListTypes = {};\n\n                    allowedListTypes[this.current.listType] = true;\n                    var listInfo = this.listTypes[this.current.listType];\n\n                    if (listInfo.complexTypes) {\n                        for (var i = 0, len = listInfo.complexTypes.length; i < len; i++) {\n                            allowedListTypes[listInfo.complexTypes[i]] = true;\n                        }\n                    }\n\n                    this.blockFormConfirmed.update();\n                    this.blockConfirmed.childElements().each(function (blockItem) {\n                        var scopeArr    = blockItem.id.match(/.*\\[(\\w+)\\]\\[([^\\]]+)\\]$/);\n                        var listType    = scopeArr[1];\n                        var itemId    = scopeArr[2];\n\n                        if (allowedListTypes[listType] && (!this.itemsFilter[listType] ||\n                            this.itemsFilter[listType].indexOf(itemId) != -1)) {\n                            _renameFields(method, blockItem, listInfo.complexTypes ? listType : null);\n                            this.blockFormConfirmed.insert(blockItem);\n                        }\n                    }.bind(this));\n                    break;\n\n                case 'form_confirmed_to_confirmed':\n                    var listInfo = this.listTypes[this.current.listType];\n\n                    this.blockFormConfirmed.childElements().each(function (blockItem) {\n                        var scopeArr = blockItem.id.match(/.*\\[(\\w+)\\]\\[([^\\]]+)\\]$/);\n                        var listType = scopeArr[1];\n\n                        _renameFields(method, blockItem, listInfo.complexTypes ? listType : null);\n                        this.blockConfirmed.insert(blockItem);\n                    }.bind(this));\n                    break;\n            }\n        },\n\n        /**\n         * Check if qty selected correctly\n         *\n         * @param object element\n         * @param object event\n         */\n        changeOptionQty: function (element, event) {\n            var checkQty = true;\n\n            if ('undefined' != typeof event) {\n                if (event.keyCode == 8 || event.keyCode == 46) {\n                    checkQty = false;\n                }\n            }\n\n            if (checkQty && (Number(element.value) <= 0 || isNaN(Number(element.value)))) {\n                element.value = 1;\n            }\n        }\n    };\n\n    productConfigure = new ProductConfigure();\n    jQuery(document).trigger('productConfigure:inited');\n    jQuery(document).data('productConfigureInited', true);\n});\n","Magento_Catalog/catalog/product/edit/attribute.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/mage',\n    'validation'\n], function ($) {\n    'use strict';\n\n    return function (config, element) {\n        $(element).mage('form').validation({\n            validationUrl: config.validationUrl\n        });\n    };\n});\n","Magento_Catalog/component/select-type-grid.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/dynamic-rows/dynamic-rows'\n], function ($, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n\n        /**\n         * Checks is relevant value\n         *\n         * @param {String} value\n         * @returns {Boolean}\n         */\n        isRelevant: function (value) {\n            if ($.inArray(value, ['drop_down', 'radio', 'checkbox', 'multiple']) !== -1) {\n                this.disabled(false);\n                this.visible(true);\n\n                return true;\n            }\n\n            this.reset();\n            this.disabled(true);\n            this.visible(false);\n\n            return false;\n        }\n    });\n});\n","Magento_Catalog/component/image-size-field.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/lib/validation/utils',\n    'Magento_Ui/js/form/element/abstract',\n    'Magento_Ui/js/lib/validation/validator',\n    'mage/translate'\n], function ($, utils, Abstract, validator) {\n    'use strict';\n\n    validator.addRule(\n        'validate-image-size-range',\n        function (value) {\n            var dataAttrRange = /^(\\d+)x(\\d+)$/,\n                m;\n\n            if (utils.isEmptyNoTrim(value)) {\n                return true;\n            }\n\n            m = dataAttrRange.exec(value);\n\n            return !!(m &&  m[1] > 0 && m[2] > 0);\n        },\n        $.mage.__('This value does not follow the specified format (for example, 200X300).')\n    );\n\n    return Abstract.extend({\n\n        /**\n         * Checks for relevant value\n         *\n         * @returns {Boolean}\n         */\n        isRangeCorrect: function () {\n            return validator('validate-image-size-range', this.value()).passed;\n        }\n    });\n});\n","Magento_Catalog/component/file-type-field.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/abstract'\n], function (Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n\n        /**\n         * Checks is relevant value\n         *\n         * @param {String} value\n         * @returns {Boolean}\n         */\n        isRelevant: function (value) {\n            if (value === 'file') {\n                this.disabled(false);\n                this.visible(true);\n\n                return true;\n            }\n\n            this.reset();\n            this.disabled(true);\n            this.visible(false);\n\n            return false;\n        }\n    });\n});\n","Magento_Catalog/component/text-type-field.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/form/element/abstract'\n], function ($, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n\n        /**\n         * Checks for relevant value\n         *\n         * @param {*} value\n         * @returns {Boolean}\n         */\n        isRelevant: function (value) {\n            if ($.inArray(value, ['field', 'area']) !== -1) {\n                this.disabled(false);\n                this.visible(true);\n\n                return true;\n            }\n\n            this.reset();\n            this.disabled(true);\n            this.visible(false);\n\n            return false;\n        }\n    });\n});\n","Magento_Catalog/component/static-type-container.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/form/components/group'\n], function ($, Group) {\n    'use strict';\n\n    return Group.extend({\n\n        /**\n         * Checks is relevant value\n         *\n         * @param {String} value\n         * @returns {Boolean}\n         */\n        isRelevant: function (value) {\n            if ($.inArray(value, ['field', 'area', 'file', 'date', 'date_time', 'time']) !== -1) {\n                this.visible(true);\n\n                return true;\n            }\n\n            this.visible(false);\n\n            return false;\n        }\n    });\n});\n","Magento_Catalog/component/static-type-input.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiRegistry',\n    'Magento_Ui/js/form/element/abstract'\n], function (registry, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            parentOption: null\n        },\n\n        /**\n         * Initialize component.\n         *\n         * @returns {Element}\n         */\n        initialize: function () {\n            return this\n                ._super()\n                .initLinkToParent();\n        },\n\n        /**\n         * Cache link to parent component - option holder.\n         *\n         * @returns {Element}\n         */\n        initLinkToParent: function () {\n            var pathToParent = this.parentName.replace(/(\\.[^.]*){2}$/, '');\n\n            this.parentOption = registry.async(pathToParent);\n            this.value() && this.parentOption('label', this.value());\n\n            return this;\n        },\n\n        /**\n         * On value change handler.\n         *\n         * @param {String} value\n         */\n        onUpdate: function (value) {\n            this.parentOption(function (component) {\n                component.set('label', value ? value : component.get('headerLabel'));\n            });\n\n            return this._super();\n        }\n    });\n});\n","Magento_Catalog/component/static-type-select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/form/element/select'\n], function ($, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n\n        /**\n         * Checks is relevant value\n         *\n         * @param {String} value\n         * @returns {Boolean}\n         */\n        isRelevant: function (value) {\n            if (!value || $.inArray(value, ['drop_down', 'radio', 'checkbox', 'multiple']) !== -1) {\n                this.reset();\n                this.disabled(true);\n\n                return false;\n            }\n\n            this.disabled(false);\n\n            return true;\n        }\n    });\n});\n","Magento_InventoryCatalogAdminUi/js/product/form/source-items.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/fieldset',\n    'uiRegistry',\n    'underscore'\n], function (Fieldset, registry, _) {\n    'use strict';\n\n    return Fieldset.extend({\n        defaults: {\n            advancedInventoryButtonIndex: '',\n            imports: {\n                onStockChange: '${ $.provider }:data.product.stock_data.manage_stock'\n            }\n        },\n\n        /**\n         * \"Advanced Inventory\" button should stay active in any case.\n         *\n         * @param {Integer} canManageStock\n         */\n        onStockChange: function (canManageStock) {\n            var advancedInventoryButton = registry.get('index = ' + this.advancedInventoryButtonIndex);\n\n            if (canManageStock === 0) {\n                if (!_.isUndefined(advancedInventoryButton)) {\n                    advancedInventoryButton.disabled(false);\n                }\n            }\n        }\n    });\n});\n","Magento_InventoryCatalogAdminUi/js/product/form/stock-status.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/select'\n], function (Select) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            links: {\n                linkedValue: false\n            }\n        },\n\n        /** @inheritdoc */\n        getInitialValue: function () {\n            var values = [this.source.get(this.dataScope), this.default],\n                value;\n\n            values.some(function (v) {\n                if (v !== null && v !== undefined) {\n                    value = v;\n\n                    return true;\n                }\n\n                return false;\n            });\n\n            return this.normalizeData(value);\n        },\n\n        /** @inheritdoc */\n        setDifferedFromDefault: function () {\n            this._super();\n\n            if (parseFloat(this.initialValue) !== parseFloat(this.value())) {\n                this.source.set(this.dataScope, this.value());\n            } else {\n                this.source.remove(this.dataScope);\n            }\n        }\n    });\n});\n","Magento_InventoryCatalogAdminUi/js/product/form/qty.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_CatalogInventory/js/components/qty-validator-changer'\n], function (Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            links: {\n                value: false\n            }\n        },\n\n        /** @inheritdoc */\n        getInitialValue: function () {\n            var values = [this.source.get(this.dataScope), this.default],\n                value;\n\n            values.some(function (v) {\n                if (v !== null && v !== undefined) {\n                    value = v;\n\n                    return true;\n                }\n\n                return false;\n            });\n\n            return this.normalizeData(value);\n        },\n\n        /** @inheritdoc */\n        setDifferedFromDefault: function () {\n            var initialValue;\n\n            this._super();\n            initialValue = this.source.data.product['current_product_id'] !== null ? this.initialValue : 0;\n\n            if (this.value() &&\n                parseFloat(initialValue) !== parseFloat(this.value())\n            ) {\n                this.source.set(this.dataScope, this.value());\n            } else {\n                this.source.remove(this.dataScope);\n            }\n        }\n    });\n});\n","Magento_InventoryCatalogAdminUi/js/product/form/sources/qty.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_CatalogInventory/js/components/qty-validator-changer'\n], function (Validator) {\n    'use strict';\n\n    return Validator.extend({\n\n        /**\n         * Set default value for source quantity, depends on 'Use Decimal\" value.\n         *\n         * @param {Integer} isDecimal\n         * @returns void\n         */\n        setDefaultValue: function (isDecimal) {\n            if (!this.value()) {\n                isDecimal ? this.value('0.0') : this.value('0');\n            }\n        }\n    });\n});\n","Magento_InventoryCatalogAdminUi/js/product/attribute/edit/inventory/toggle/toggle-editability-all.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    $('[data-role=toggle-editability-all]').on('change', function () {\n        var toggler = $(this),\n            field = toggler.parents('.field'),\n            someEditable = $('input[type!=\"checkbox\"], select, textarea', field),\n            someEditableCheckboxes = $('input[type=\"checkbox\"]', field).not(toggler);\n\n        if (someEditableCheckboxes.length) {\n            someEditable.prop('disabled', !toggler.prop('checked') || someEditableCheckboxes.prop('checked'));\n            someEditableCheckboxes.prop('disabled', !toggler.prop('checked'));\n        } else {\n            someEditable.prop('disabled', !toggler.prop('checked'));\n        }\n    });\n});\n","Magento_InventoryCatalogAdminUi/js/product/attribute/edit/inventory/toggle/toggle-editability.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    $('[data-role=toggle-editability]').on('change', function () {\n        var useConfigSettings = $(this),\n            field = useConfigSettings.parents('.field'),\n            someEditable = $('input[type!=\"checkbox\"], select, textarea', field);\n\n        someEditable.prop('disabled', useConfigSettings.prop('checked'));\n    });\n});\n","Magento_InventoryCatalogAdminUi/js/product/grid/cell/quantity-per-source.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column'\n], function (Column) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'Magento_InventoryCatalogAdminUi/product/grid/cell/source-items.html',\n            itemsToDisplay: 5\n        },\n\n        /**\n         * Get source items data (source name and qty)\n         *\n         * @param {Object} record - Record object\n         * @returns {Array} Result array\n         */\n        getSourceItemsData: function (record) {\n            return record[this.index] ? record[this.index] : [];\n        },\n\n        /**\n         * @param {Object} record - Record object\n         * @returns {Array} Result array\n         */\n        getSourceItemsDataCut: function (record) {\n            return this.getSourceItemsData(record).slice(0, this.itemsToDisplay);\n        }\n    });\n});\n","Magento_Shipping/order/packaging.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['prototype'], function () {\n\n    window.Packaging = Class.create();\n    Packaging.prototype = {\n        /**\n         * Initialize object\n         */\n        initialize: function (params) {\n            this.packageIncrement = 0;\n            this.packages = [];\n            this.itemsAll = [];\n            this.createLabelUrl = params.createLabelUrl ? params.createLabelUrl : null;\n            this.itemsGridUrl = params.itemsGridUrl ? params.itemsGridUrl : null;\n            this.errorQtyOverLimit = params.errorQtyOverLimit;\n            this.titleDisabledSaveBtn = params.titleDisabledSaveBtn;\n            this.window = $('packaging_window');\n            this.messages = this.window.select('.message-warning')[0];\n            this.packagesContent = $('packages_content');\n            this.template = $('package_template');\n            this.paramsCreateLabelRequest = {};\n            this.validationErrorMsg = params.validationErrorMsg;\n\n            this.defaultItemsQty            = params.shipmentItemsQty ? params.shipmentItemsQty : null;\n            this.defaultItemsPrice          = params.shipmentItemsPrice ? params.shipmentItemsPrice : null;\n            this.defaultItemsName           = params.shipmentItemsName ? params.shipmentItemsName : null;\n            this.defaultItemsWeight         = params.shipmentItemsWeight ? params.shipmentItemsWeight : null;\n            this.defaultItemsProductId      = params.shipmentItemsProductId ? params.shipmentItemsProductId : null;\n            this.defaultItemsOrderItemId    = params.shipmentItemsOrderItemId ? params.shipmentItemsOrderItemId : null;\n\n            this.shippingInformation = params.shippingInformation ? params.shippingInformation : null;\n            this.thisPage           = params.thisPage ? params.thisPage : null;\n            this.customizableContainers = params.customizable ? params.customizable : [];\n\n            this.eps = 0.000001;\n        },\n\n        /**\n         * Get Package Id\n         */\n        getPackageId: function (packageBlock) {\n            return packageBlock.id.match(/\\d{0,}$/)[0];\n        },\n\n        //******************** Setters **********************************//\n        setLabelCreatedCallback: function (callback) {\n            this.labelCreatedCallback = callback;\n        },\n        setCancelCallback: function (callback) {\n            this.cancelCallback = callback;\n        },\n        setConfirmPackagingCallback: function (callback) {\n            this.confirmPackagingCallback = callback;\n        },\n        setItemQtyCallback: function (callback) {\n            this.itemQtyCallback = callback;\n        },\n        setCreateLabelUrl: function (url) {\n            this.createLabelUrl = url;\n        },\n        setParamsCreateLabelRequest: function (params) {\n            Object.extend(this.paramsCreateLabelRequest, params);\n        },\n        //******************** End Setters *******************************//\n\n        showWindow: function () {\n            if (this.packagesContent.childElements().length == 0) {\n                this.newPackage();\n            }\n            jQuery(this.window).modal('openModal');\n        },\n\n        cancelPackaging: function () {\n            if (Object.isFunction(this.cancelCallback)) {\n                this.cancelCallback();\n            }\n        },\n\n        confirmPackaging: function (params) {\n            if (Object.isFunction(this.confirmPackagingCallback)) {\n                this.confirmPackagingCallback();\n            }\n        },\n\n        checkAllItems: function (headCheckbox) {\n            $(headCheckbox).up('table').select('tbody input[type=\"checkbox\"]').each(function (checkbox) {\n                checkbox.checked = headCheckbox.checked;\n                this._observeQty.call(checkbox);\n            }.bind(this));\n        },\n\n        cleanPackages: function () {\n            this.packagesContent.update();\n            this.packages = [];\n            this.itemsAll = [];\n            this.packageIncrement = 0;\n            this._setAllItemsPackedState();\n            this.messages.hide().update();\n        },\n\n        sendCreateLabelRequest: function () {\n            var self = this;\n\n            if (!this.validate()) {\n                this.messages.show().update(this.validationErrorMsg);\n\n                return;\n            }\n            this.messages.hide().update();\n\n            if (this.createLabelUrl) {\n                var weight, length, width, height = null;\n                var packagesParams = [];\n\n                this.packagesContent.childElements().each(function (pack) {\n                    var packageId = this.getPackageId(pack);\n\n                    weight = parseFloat(pack.select('input[name=\"container_weight\"]')[0].value);\n                    length = parseFloat(pack.select('input[name=\"container_length\"]')[0].value);\n                    width = parseFloat(pack.select('input[name=\"container_width\"]')[0].value);\n                    height = parseFloat(pack.select('input[name=\"container_height\"]')[0].value);\n                    packagesParams[packageId] = {\n                        container:                  pack.select('select[name=\"package_container\"]')[0].value,\n                        customs_value:              parseFloat(pack.select('input[name=\"package_customs_value\"]')[0].value, 10),\n                        weight:                     isNaN(weight) ? '' : weight,\n                        length:                     isNaN(length) ? '' : length,\n                        width:                      isNaN(width) ? '' : width,\n                        height:                     isNaN(height) ? '' : height,\n                        weight_units:               pack.select('select[name=\"container_weight_units\"]')[0].value,\n                        dimension_units:            pack.select('select[name=\"container_dimension_units\"]')[0].value\n                    };\n\n                    if (isNaN(packagesParams[packageId]['customs_value'])) {\n                        packagesParams[packageId]['customs_value'] = 0;\n                    }\n\n                    if ('undefined' != typeof pack.select('select[name=\"package_size\"]')[0]) {\n                        if ('' != pack.select('select[name=\"package_size\"]')[0].value) {\n                            packagesParams[packageId]['size'] = pack.select('select[name=\"package_size\"]')[0].value;\n                        }\n                    }\n\n                    if ('undefined' != typeof pack.select('input[name=\"container_girth\"]')[0]) {\n                        if ('' != pack.select('input[name=\"container_girth\"]')[0].value) {\n                            packagesParams[packageId]['girth'] = pack.select('input[name=\"container_girth\"]')[0].value;\n                            packagesParams[packageId]['girth_dimension_units'] = pack.select('select[name=\"container_girth_dimension_units\"]')[0].value;\n                        }\n                    }\n\n                    if ('undefined' != typeof pack.select('select[name=\"content_type\"]')[0] && 'undefined' != typeof pack.select('input[name=\"content_type_other\"]')[0]) {\n                        packagesParams[packageId]['content_type'] = pack.select('select[name=\"content_type\"]')[0].value;\n                        packagesParams[packageId]['content_type_other'] = pack.select('input[name=\"content_type_other\"]')[0].value;\n                    } else {\n                        packagesParams[packageId]['content_type'] = '';\n                        packagesParams[packageId]['content_type_other'] = '';\n                    }\n                    var deliveryConfirmation = pack.select('select[name=\"delivery_confirmation_types\"]');\n\n                    if (deliveryConfirmation.length) {\n                        packagesParams[packageId]['delivery_confirmation'] =  deliveryConfirmation[0].value;\n                    }\n                }.bind(this));\n\n                for (var packageId in this.packages) {\n                    if (!isNaN(packageId)) {\n                        this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[container]']              = packagesParams[packageId]['container'];\n                        this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[weight]']                 = packagesParams[packageId]['weight'];\n                        this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[customs_value]']          = packagesParams[packageId]['customs_value'];\n                        this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[length]']                 = packagesParams[packageId]['length'];\n                        this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[width]']                  = packagesParams[packageId]['width'];\n                        this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[height]']                 = packagesParams[packageId]['height'];\n                        this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[weight_units]']           = packagesParams[packageId]['weight_units'];\n                        this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[dimension_units]']        = packagesParams[packageId]['dimension_units'];\n                        this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[content_type]']           = packagesParams[packageId]['content_type'];\n                        this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[content_type_other]']     = packagesParams[packageId]['content_type_other'];\n\n                        if ('undefined' != typeof packagesParams[packageId]['size']) {\n                            this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[size]'] = packagesParams[packageId]['size'];\n                        }\n\n                        if ('undefined' != typeof packagesParams[packageId]['girth']) {\n                            this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[girth]'] = packagesParams[packageId]['girth'];\n                            this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[girth_dimension_units]'] = packagesParams[packageId]['girth_dimension_units'];\n                        }\n\n                        if ('undefined' != typeof packagesParams[packageId]['delivery_confirmation']) {\n                            this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[delivery_confirmation]']  = packagesParams[packageId]['delivery_confirmation'];\n                        }\n\n                        for (var packedItemId in this.packages[packageId]['items']) {\n                            if (!isNaN(packedItemId)) {\n                                this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[items]' + '[' + packedItemId + '][qty]']           = this.packages[packageId]['items'][packedItemId]['qty'];\n                                this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[items]' + '[' + packedItemId + '][customs_value]'] = this.packages[packageId]['items'][packedItemId]['customs_value'];\n                                this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[items]' + '[' + packedItemId + '][price]']         = self.defaultItemsPrice[packedItemId];\n                                this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[items]' + '[' + packedItemId + '][name]']          = self.defaultItemsName[packedItemId];\n                                this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[items]' + '[' + packedItemId + '][weight]']        = self.defaultItemsWeight[packedItemId];\n                                this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[items]' + '[' + packedItemId + '][product_id]']    = self.defaultItemsProductId[packedItemId];\n                                this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[items]' + '[' + packedItemId + '][order_item_id]'] = self.defaultItemsOrderItemId[packedItemId];\n                            }\n                        }\n                    }\n                }\n\n                new Ajax.Request(this.createLabelUrl, {\n                    parameters: this.paramsCreateLabelRequest,\n                    onSuccess: function (transport) {\n                        var response = transport.responseText;\n\n                        if (response.isJSON()) {\n                            response = response.evalJSON();\n\n                            if (response.error) {\n                                this.messages.show().innerHTML = response.message;\n                            } else if (response.ok && Object.isFunction(this.labelCreatedCallback)) {\n                                this.labelCreatedCallback(response);\n                            }\n                        }\n                    }.bind(this)\n                });\n\n                if (this.paramsCreateLabelRequest['code'] &&\n                    this.paramsCreateLabelRequest['carrier_title'] &&\n                    this.paramsCreateLabelRequest['method_title'] &&\n                    this.paramsCreateLabelRequest['price']\n                ) {\n                    var a = this.paramsCreateLabelRequest['code'];\n                    var b = this.paramsCreateLabelRequest['carrier_title'];\n                    var c = this.paramsCreateLabelRequest['method_title'];\n                    var d = this.paramsCreateLabelRequest['price'];\n\n                    this.paramsCreateLabelRequest = {};\n                    this.paramsCreateLabelRequest['code']           = a;\n                    this.paramsCreateLabelRequest['carrier_title']  = b;\n                    this.paramsCreateLabelRequest['method_title']   = c;\n                    this.paramsCreateLabelRequest['price']          = d;\n                } else {\n                    this.paramsCreateLabelRequest = {};\n                }\n            }\n        },\n\n        validate: function () {\n            var dimensionElements = $('packaging_window').select(\n                'input[name=container_length],input[name=container_width],input[name=container_height],input[name=container_girth]:not(\"._disabled\")'\n            );\n            var callback = null;\n\n            if (dimensionElements.any(function (element) {\n                return !!element.value;\n            })) {\n                callback = function (element) {\n                    $(element).addClassName('required-entry');\n                };\n            } else {\n                callback = function (element) {\n                    $(element).removeClassName('required-entry');\n                };\n            }\n            dimensionElements.each(callback);\n\n            return result = $$('[id^=\"package_block_\"] input').collect(function (element) {\n                return this.validateElement(element);\n            }, this).all();\n        },\n\n        validateElement: function (elm) {\n            var cn = $w(elm.className);\n\n            return result = cn.all(function (value) {\n                var v = Validation.get(value);\n\n                if (Validation.isVisible(elm) && !v.test($F(elm), elm)) {\n                    $(elm).addClassName('validation-failed');\n\n                    return false;\n                }\n                $(elm).removeClassName('validation-failed');\n\n                return true;\n\n            });\n        },\n\n        validateCustomsValue: function () {\n            var items = [];\n            var isValid = true;\n            var itemsPrepare = [];\n            var itemsPacked = [];\n\n            this.packagesContent.childElements().each(function (pack) {\n                itemsPrepare = pack.select('[data-role=\"package-items\"]')[0];\n\n                if (itemsPrepare) {\n                    items = items.concat(itemsPrepare.select('.grid tbody tr'));\n                }\n                itemsPacked = pack.select('.package_items')[0];\n\n                if (itemsPacked) {\n                    items = items.concat(itemsPacked.select('.grid tbody tr'));\n                }\n            });\n\n            items.each(function (item) {\n                var itemCustomsValue = item.select('[name=\"customs_value\"]')[0];\n\n                if (!this.validateElement(itemCustomsValue)) {\n                    isValid = false;\n                }\n            }.bind(this));\n\n            if (isValid) {\n                this.messages.hide().update();\n            } else {\n                this.messages.show().update(this.validationErrorMsg);\n            }\n\n            return isValid;\n        },\n\n        newPackage: function () {\n            var pack = this.template.cloneNode(true);\n\n            pack.id = 'package_block_' + ++this.packageIncrement;\n            pack.addClassName('package-block');\n            pack.select('[data-role=package-number]')[0].update(this.packageIncrement);\n            this.packagesContent.insert({\n                top: pack\n            });\n            pack.select('[data-action=package-save-items]')[0].hide();\n            pack.show();\n        },\n\n        deletePackage: function (obj) {\n            var pack = $(obj).up('[id^=\"package_block\"]');\n\n            var packItems = pack.select('.package_items')[0];\n            var packageId = this.getPackageId(pack);\n\n            delete this.packages[packageId];\n            pack.remove();\n            this.messages.hide().update();\n            this._setAllItemsPackedState();\n        },\n\n        deleteItem: function (obj) {\n            var item = $(obj).up('tr');\n            var itemId = item.select('[type=\"checkbox\"]')[0].value;\n            var pack = $(obj).up('[id^=\"package_block\"]');\n            var packItems = pack.select('.package_items')[0];\n            var packageId = this.getPackageId(pack);\n\n            delete this.packages[packageId]['items'][itemId];\n\n            if (item.offsetParent.rows.length <= 2) { /* head + this last row */\n                $(packItems).hide();\n            }\n            item.remove();\n            this.messages.hide().update();\n            this._recalcContainerWeightAndCustomsValue(packItems);\n            this._setAllItemsPackedState();\n        },\n\n        recalcContainerWeightAndCustomsValue: function (obj) {\n            var pack = $(obj).up('[id^=\"package_block\"]');\n            var packItems = pack.select('.package_items')[0];\n\n            if (packItems) {\n                if (!this.validateCustomsValue()) {\n                    return;\n                }\n                this._recalcContainerWeightAndCustomsValue(packItems);\n            }\n        },\n\n        getItemsForPack: function (obj) {\n            if (this.itemsGridUrl) {\n                var parameters = $H({\n                    'shipment_id': this.shipmentId\n                });\n                var packageBlock = $(obj).up('[id^=\"package_block\"]');\n                var packagePrapare = packageBlock.select('[data-role=package-items]')[0];\n                var packagePrapareGrid = packagePrapare.select('.grid_prepare')[0];\n\n                new Ajax.Request(this.itemsGridUrl, {\n                    parameters: parameters,\n                    onSuccess: function (transport) {\n                        var response = transport.responseText;\n\n                        if (response) {\n                            packagePrapareGrid.update(response);\n                            this.processPackagePrepare(packagePrapareGrid);\n\n                            if (packagePrapareGrid.select('.grid tbody tr').length) {\n                                packageBlock.select('[data-action=package-add-items]')[0].hide();\n                                packageBlock.select('[data-action=package-save-items]')[0].show();\n                                packagePrapare.show();\n                            } else {\n                                packagePrapareGrid.update();\n                            }\n                        }\n                    }.bind(this)\n                });\n            }\n        },\n\n        getPackedItemsQty: function () {\n            var items = [];\n\n            for (var packageId in this.packages) {\n                if (!isNaN(packageId)) {\n                    for (var packedItemId in this.packages[packageId]['items']) {\n                        if (!isNaN(packedItemId)) {\n                            if (items[packedItemId]) {\n                                items[packedItemId] += this.packages[packageId]['items'][packedItemId]['qty'];\n                            } else {\n                                items[packedItemId] = this.packages[packageId]['items'][packedItemId]['qty'];\n                            }\n                        }\n                    }\n                }\n            }\n\n            return items;\n        },\n\n        _parseQty: function (obj) {\n            var qty = $(obj).hasClassName('qty-decimal') ? parseFloat(obj.value) : parseInt(obj.value);\n\n            if (isNaN(qty) || qty <= 0) {\n                qty = 1;\n            }\n\n            return qty;\n        },\n\n        packItems: function (obj) {\n            var anySelected = false;\n            var packageBlock = $(obj).up('[id^=\"package_block\"]');\n            var packageId = this.getPackageId(packageBlock);\n            var packagePrepare = packageBlock.select('[data-role=package-items]')[0];\n            var packagePrepareGrid = packagePrepare.select('.grid_prepare')[0];\n\n            // check for exceeds the total shipped quantity\n            var checkExceedsQty = false;\n\n            this.messages.hide().update();\n            packagePrepareGrid.select('.grid tbody tr').each(function (item) {\n                var checkbox = item.select('[type=\"checkbox\"]')[0];\n                var itemId = checkbox.value;\n                var qtyValue  = this._parseQty(item.select('[name=\"qty\"]')[0]);\n\n                item.select('[name=\"qty\"]')[0].value = qtyValue;\n\n                if (checkbox.checked && this._checkExceedsQty(itemId, qtyValue)) {\n                    this.messages.show().update(this.errorQtyOverLimit);\n                    checkExceedsQty = true;\n                }\n            }.bind(this));\n\n            if (checkExceedsQty) {\n                return;\n            }\n\n            if (!this.validateCustomsValue()) {\n                return;\n            }\n\n            // prepare items for packing\n            packagePrepareGrid.select('.grid tbody tr').each(function (item) {\n                var checkbox = item.select('[type=\"checkbox\"]')[0];\n\n                if (checkbox.checked) {\n                    var qty  = item.select('[name=\"qty\"]')[0];\n                    var qtyValue  = this._parseQty(qty);\n\n                    item.select('[name=\"qty\"]')[0].value = qtyValue;\n                    anySelected = true;\n                    qty.disabled = 'disabled';\n                    checkbox.disabled = 'disabled';\n                    packagePrepareGrid.select('.grid th [type=\"checkbox\"]')[0].up('th label').hide();\n                    item.select('[data-action=package-delete-item]')[0].show();\n                } else {\n                    item.remove();\n                }\n            }.bind(this));\n\n            // packing items\n            if (anySelected) {\n                var packItems = packageBlock.select('.package_items')[0];\n\n                if (!packItems) {\n                    packagePrepare.insert(new Element('div').addClassName('grid_prepare'));\n                    packagePrepare.insert({\n                        after: packagePrepareGrid\n                    });\n                    packItems = packagePrepareGrid.removeClassName('grid_prepare').addClassName('package_items');\n                    packItems.select('.grid tbody tr').each(function (item) {\n                        var itemId = item.select('[type=\"checkbox\"]')[0].value;\n                        var qtyValue  = parseFloat(item.select('[name=\"qty\"]')[0].value);\n\n                        qtyValue = qtyValue <= 0 ? 1 : qtyValue;\n\n                        if ('undefined' == typeof this.packages[packageId]) {\n                            this.packages[packageId] = {\n                                'items': [], 'params': {}\n                            };\n                        }\n\n                        if ('undefined' == typeof this.packages[packageId]['items'][itemId]) {\n                            this.packages[packageId]['items'][itemId] = {};\n                            this.packages[packageId]['items'][itemId]['qty'] = qtyValue;\n                        } else {\n                            this.packages[packageId]['items'][itemId]['qty'] += qtyValue;\n                        }\n                    }.bind(this));\n                } else {\n                    packagePrepareGrid.select('.grid tbody tr').each(function (item) {\n                        var itemId = item.select('[type=\"checkbox\"]')[0].value;\n                        var qtyValue  = parseFloat(item.select('[name=\"qty\"]')[0].value);\n\n                        qtyValue = qtyValue <= 0 ? 1 : qtyValue;\n\n                        if ('undefined' == typeof this.packages[packageId]['items'][itemId]) {\n                            this.packages[packageId]['items'][itemId] = {};\n                            this.packages[packageId]['items'][itemId]['qty'] = qtyValue;\n                            packItems.select('.grid tbody')[0].insert(item);\n                        } else {\n                            this.packages[packageId]['items'][itemId]['qty'] += qtyValue;\n                            var packItem = packItems.select('[type=\"checkbox\"][value=\"' + itemId + '\"]')[0].up('tr').select('[name=\"qty\"]')[0];\n\n                            packItem.value = this.packages[packageId]['items'][itemId]['qty'];\n                        }\n                    }.bind(this));\n                    packagePrepareGrid.update();\n                }\n                $(packItems).show();\n                this._recalcContainerWeightAndCustomsValue(packItems);\n            } else {\n                packagePrepareGrid.update();\n            }\n\n            // show/hide disable/enable\n            packagePrepare.hide();\n            packageBlock.select('[data-action=package-save-items]')[0].hide();\n            packageBlock.select('[data-action=package-add-items]')[0].show();\n            this._setAllItemsPackedState();\n        },\n\n        validateItemQty: function (itemId, qty) {\n            return this.defaultItemsQty[itemId] < qty ? this.defaultItemsQty[itemId] : qty;\n        },\n\n        changeMeasures: function (obj) {\n            var incr = 0;\n            var incrSelected = 0;\n\n            obj.childElements().each(function (option) {\n                if (option.selected) {\n                    incrSelected = incr;\n                }\n                incr++;\n            });\n\n            var packageBlock = $(obj).up('[id^=\"package_block\"]');\n\n            packageBlock.select('.measures').each(function (item) {\n                if (item.name != obj.name) {\n                    var incr = 0;\n\n                    item.select('option').each(function (option) {\n                        if (incr == incrSelected) {\n                            item.value = option.value;\n                            //option.selected = true\n                        }\n                        incr++;\n                    });\n                }\n            });\n\n        },\n\n        checkSizeAndGirthParameter: function (obj, enabled) {\n            if (enabled == 0) {\n                return;\n            }\n            var currentNode = obj;\n\n            while (currentNode.nodeName != 'TBODY') {\n                currentNode = currentNode.parentNode;\n            }\n\n            if (!currentNode) {\n                return;\n            }\n\n            var packageSize = currentNode.select('select[name=package_size]');\n            var packageContainer = currentNode.select('select[name=package_container]');\n            var packageGirth = currentNode.select('input[name=container_girth]');\n            var packageGirthDimensionUnits = currentNode.select('select[name=container_girth_dimension_units]');\n\n            if (packageSize.length <= 0) {\n                return;\n            }\n\n            var girthEnabled = packageContainer[0].value == 'NONRECTANGULAR' || packageContainer[0].value == 'VARIABLE';\n\n            if (!girthEnabled) {\n                packageGirth[0].value = '';\n                packageGirth[0].disable();\n                packageGirth[0].addClassName('_disabled');\n                packageGirthDimensionUnits[0].disable();\n                packageGirthDimensionUnits[0].addClassName('_disabled');\n            } else {\n                packageGirth[0].enable();\n                packageGirth[0].removeClassName('_disabled');\n                packageGirthDimensionUnits[0].enable();\n                packageGirthDimensionUnits[0].removeClassName('_disabled');\n            }\n\n            var sizeEnabled = packageContainer[0].value == 'NONRECTANGULAR' || packageContainer[0].value == 'RECTANGULAR' ||\n                packageContainer[0].value == 'VARIABLE';\n\n            if (!sizeEnabled) {\n                option = document.createElement('OPTION');\n                option.value = '';\n                option.text = '';\n                packageSize[0].options.add(option);\n                packageSize[0].value = '';\n                packageSize[0].disable();\n                packageSize[0].addClassName('_disabled');\n            } else {\n                for (i = 0; i < packageSize[0].length; i++) {\n                    if (packageSize[0].options[i].value == '') {\n                        packageSize[0].removeChild(packageSize[0].options[i]);\n                    }\n                }\n                packageSize[0].enable();\n                packageSize[0].removeClassName('_disabled');\n            }\n        },\n\n        changeContainerType: function (obj) {\n            if (this.customizableContainers.length <= 0) {\n                return;\n            }\n\n            var disable = true;\n\n            for (var i in this.customizableContainers) {\n                if (this.customizableContainers[i] == obj.value) {\n                    disable = false;\n                    break;\n                }\n            }\n\n            var currentNode = obj;\n\n            while (currentNode.nodeName != 'TBODY') {\n                currentNode = currentNode.parentNode;\n            }\n\n            if (!currentNode) {\n                return;\n            }\n\n            $(currentNode).select(\n                'input[name=container_length],input[name=container_width],input[name=container_height],select[name=container_dimension_units]'\n            ).each(function (inputElement) {\n                if (disable) {\n                    Form.Element.disable(inputElement);\n                    inputElement.addClassName('_disabled');\n\n                    if (inputElement.nodeName == 'INPUT') {\n                        $(inputElement).value = '';\n                    }\n                } else {\n                    Form.Element.enable(inputElement);\n                    inputElement.removeClassName('_disabled');\n                }\n            });\n        },\n\n        changeContentTypes: function (obj) {\n            var packageBlock = $(obj).up('[id^=\"package_block\"]');\n            var contentType = packageBlock.select('[name=content_type]')[0];\n            var contentTypeOther = packageBlock.select('[name=content_type_other]')[0];\n\n            if (contentType.value == 'OTHER') {\n                Form.Element.enable(contentTypeOther);\n                contentTypeOther.removeClassName('_disabled');\n            } else {\n                Form.Element.disable(contentTypeOther);\n                contentTypeOther.addClassName('_disabled');\n            }\n\n        },\n\n        //******************** Private functions **********************************//\n        _getItemsCount: function (items) {\n            var count = 0;\n\n            items.each(function (itemCount) {\n                if (!isNaN(itemCount)) {\n                    count += parseFloat(itemCount);\n                }\n            });\n\n            return count;\n        },\n\n        /**\n         * Show/hide disable/enable buttons in case of all items packed state\n         */\n        _setAllItemsPackedState: function () {\n            var addPackageBtn = $$('[data-action=add-packages]')[0];\n            var savePackagesBtn = $$('[data-action=save-packages]')[0];\n\n            if (this._getItemsCount(this.itemsAll) > 0 &&\n                    this._checkExceedsQtyFinal(this._getItemsCount(this.getPackedItemsQty()), this._getItemsCount(this.itemsAll))\n            ) {\n                this.packagesContent.select('[data-action=package-add-items]').each(function (button) {\n                    button.disabled = 'disabled';\n                    button.addClassName('_disabled');\n                });\n                addPackageBtn.addClassName('_disabled');\n                Form.Element.disable(addPackageBtn);\n                savePackagesBtn.removeClassName('_disabled');\n                Form.Element.enable(savePackagesBtn);\n                savePackagesBtn.title = '';\n\n                // package number recalculation\n                var packagesRecalc = [];\n\n                this.packagesContent.childElements().each(function (pack) {\n                    if (!pack.select('.package_items .grid tbody tr').length) {\n                        pack.remove();\n                    }\n                });\n                var packagesCount = this.packagesContent.childElements().length;\n\n                this.packageIncrement = packagesCount;\n                this.packagesContent.childElements().each(function (pack) {\n                    var packageId = this.getPackageId(pack);\n\n                    pack.id = 'package_block_' + packagesCount;\n                    pack.select('[data-role=package-number]')[0].update(packagesCount);\n                    packagesRecalc[packagesCount] = this.packages[packageId];\n                    --packagesCount;\n                }.bind(this));\n                this.packages = packagesRecalc;\n\n            } else {\n                this.packagesContent.select('[data-action=package-add-items]').each(function (button) {\n                    button.removeClassName('_disabled');\n                    Form.Element.enable(button);\n                });\n                addPackageBtn.removeClassName('_disabled');\n                Form.Element.enable(addPackageBtn);\n                savePackagesBtn.addClassName('_disabled');\n                Form.Element.disable(savePackagesBtn);\n                savePackagesBtn.title = this.titleDisabledSaveBtn;\n            }\n        },\n\n        processPackagePrepare: function (packagePrepare) {\n            var itemsAll = [],\n                qty,\n                itemId,\n                qtyValue = 0,\n                value = 1;\n\n            packagePrepare.select('.grid tbody tr').each(function (item) {\n                qty = item.select('[name=\"qty\"]')[0],\n                    itemId = item.select('[type=\"checkbox\"]')[0].value,\n                    qtyValue = parseFloat(qty.value);\n\n                if (Object.isFunction(this.itemQtyCallback)) {\n                    value = this.itemQtyCallback(itemId);\n\n                    if (typeof value !== 'undefined') {\n                        qtyValue = parseFloat(value);\n                        qtyValue = this.validateItemQty(itemId, qtyValue);\n                        qty.value = qtyValue;\n                    }\n                } else {\n                    value = item.select('[name=\"qty\"]')[0].value;\n                    qtyValue = typeof value == 'string' && value.length == 0 ? 0 : parseFloat(value);\n\n                    if (isNaN(qtyValue) || qtyValue < 0) {\n                        qtyValue = 1;\n                    }\n                }\n\n                if (qtyValue == 0) {\n                    item.remove();\n\n                    return;\n                }\n                var packedItems = this.getPackedItemsQty();\n\n                itemsAll[itemId] = qtyValue;\n\n                for (var packedItemId in packedItems) {\n                    if (!isNaN(packedItemId)) {\n                        var packedQty = packedItems[packedItemId];\n\n                        if (itemId == packedItemId) {\n                            if (qtyValue == packedQty || qtyValue <= packedQty) {\n                                item.remove();\n                            } else if (qtyValue > packedQty) {\n                                /* fix float number precision */\n                                qty.value = Number(Number(Math.round(qtyValue - packedQty + 'e+4') + 'e-4').toFixed(4));\n                            }\n                        }\n                    }\n                }\n            }.bind(this));\n\n            if (!this.itemsAll.length) {\n                this.itemsAll = itemsAll;\n            }\n\n            packagePrepare.select('tbody input[type=\"checkbox\"]').each(function (item) {\n                $(item).observe('change', this._observeQty);\n                this._observeQty.call(item);\n            }.bind(this));\n        },\n\n        _observeQty: function () {\n            /** this = input[type=\"checkbox\"] */\n            var tr  = jQuery(this).closest('tr')[0],\n                qty = $(tr.cells[tr.cells.length - 1]).select('input[name=\"qty\"]')[0];\n\n            if (qty.disabled = !this.checked) {\n                $(qty).addClassName('_disabled');\n            } else {\n                $(qty).removeClassName('_disabled');\n            }\n        },\n\n        _checkExceedsQty: function (itemId, qty) {\n            var packedItemQty = this.getPackedItemsQty()[itemId] ? this.getPackedItemsQty()[itemId] : 0;\n            var allItemQty = this.itemsAll[itemId];\n\n            return qty * (1 - this.eps) > allItemQty *  (1 + this.eps)  - packedItemQty * (1 - this.eps);\n        },\n\n        _checkExceedsQtyFinal: function (checkOne, defQty) {\n            return checkOne * (1 + this.eps) >= defQty * (1 - this.eps);\n        },\n\n        _recalcContainerWeightAndCustomsValue: function (container) {\n            var packageBlock = container.up('[id^=\"package_block\"]');\n            var packageId = this.getPackageId(packageBlock);\n            var containerWeight = packageBlock.select('[name=\"container_weight\"]')[0];\n            var containerCustomsValue = packageBlock.select('[name=\"package_customs_value\"]')[0];\n\n            containerWeight.value = 0;\n            containerCustomsValue.value = 0;\n            container.select('.grid tbody tr').each(function (item) {\n                var itemId = item.select('[type=\"checkbox\"]')[0].value;\n                var qtyValue  = parseFloat(item.select('[name=\"qty\"]')[0].value);\n\n                if (isNaN(qtyValue) || qtyValue <= 0) {\n                    qtyValue = 1;\n                    item.select('[name=\"qty\"]')[0].value = qtyValue;\n                }\n                var itemWeight = parseFloat(this._getElementText(item.select('[data-role=item-weight]')[0]));\n\n                containerWeight.value = parseFloat(containerWeight.value) + itemWeight * qtyValue;\n                var itemCustomsValue = parseFloat(item.select('[name=\"customs_value\"]')[0].value) || 0;\n\n                containerCustomsValue.value = parseFloat(containerCustomsValue.value) + itemCustomsValue * qtyValue;\n                this.packages[packageId]['items'][itemId]['customs_value'] = itemCustomsValue;\n            }.bind(this));\n            containerWeight.value = parseFloat(parseFloat(Math.round(containerWeight.value + 'e+4') + 'e-4').toFixed(4));\n            containerCustomsValue.value = parseFloat(Math.round(containerCustomsValue.value + 'e+2') + 'e-2').toFixed(2);\n\n            if (containerCustomsValue.value == 0) {\n                containerCustomsValue.value = '';\n            }\n        },\n\n        _getElementText: function (el) {\n            if ('string' == typeof el.textContent) {\n                return el.textContent;\n            }\n\n            if ('string' == typeof el.innerText) {\n                return el.innerText;\n            }\n\n            return el.innerHTML.replace(/<[^>]*>/g, '');\n        }\n        //******************** End Private functions ******************************//\n    };\n\n});\n","Magento_Shipping/js/packages.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/modal',\n    'mage/translate'\n], function ($, modal, $t) {\n    'use strict';\n\n    return function (config, element) {\n        config.buttons = [\n            {\n                text: $t('Print'),\n                'class': 'action action-primary',\n\n                /**\n                 * Click handler\n                 */\n                click: function () {\n                    window.location.href = this.options.url;\n                }\n            }, {\n                text: $t('Cancel'),\n                'class': 'action action-secondary',\n\n                /**\n                 * Click handler\n                 */\n                click: function () {\n                    this.closeModal();\n                }\n            }\n        ];\n        modal(config, element);\n    };\n});\n","Magento_AdminAnalytics/js/release-notification/modal/component-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['jquery', 'analyticsPopupConfig'], function ($, analyticsPopupConfig) {\n    'use strict';\n\n    var deferred = $.Deferred(),\n\n        mixin = {\n        /**\n         * Initializes content only if its visible\n         */\n        initializeContent: function () {\n            var initializeContent = this._super.bind(this);\n\n            if (!analyticsPopupConfig.analyticsVisible) {\n                initializeContent();\n            } else {\n                deferred.then(function () {\n                    initializeContent();\n                });\n            }\n        },\n\n        /**\n         * Initializes release notification content after admin analytics\n         */\n        initializeContentAfterAnalytics: function () {\n            deferred.resolve();\n        }\n    };\n\n    return function (target) {\n        return target.extend(mixin);\n    };\n});\n\n","Magento_AdminAnalytics/js/modal/component.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'jquery',\n    'Magento_Ui/js/modal/modal-component',\n    'uiRegistry',\n    'analyticsPopupConfig'\n],\n    function (_, $, Modal, registry, analyticsPopupConfig) {\n        'use strict';\n\n        return Modal.extend(\n            {\n                defaults: {\n                    imports: {\n                        enableLogAction: '${ $.provider }:data.enableLogAction',\n                        disableLogAction: '${ $.provider }:data.disableLogAction'\n                    },\n                    options: {},\n                    notificationWindow: null\n                },\n\n                /**\n                 * Initializes modal on opened function\n                 */\n                initModal: function () {\n                    this.options.opened = this.onOpened.bind(this);\n                    this._super();\n                },\n\n                /**\n                 * Configure ESC and TAB so user can't leave modal\n                 * without selecting an option\n                 *\n                 * @returns {Object} Chainable.\n                 */\n                initModalEvents: function () {\n                    this._super();\n                    //Don't allow ESC key to close modal\n                    this.options.keyEventHandlers.escapeKey = this.handleEscKey.bind(this);\n                    //Restrict tab action to the modal\n                    this.options.keyEventHandlers.tabKey = this.handleTabKey.bind(this);\n\n                    return this;\n                },\n\n                /**\n                 * Once the modal is opened it hides the X\n                 */\n                onOpened: function () {\n                    $('.modal-header button.action-close').attr('disabled', true).hide();\n\n                    this.focusableElements = $(this.rootSelector).find('a[href], button:enabled');\n                    this.firstFocusableElement = this.focusableElements[0];\n                    this.lastFocusableElement = this.focusableElements[this.focusableElements.length - 1];\n                    this.firstFocusableElement.focus();\n                },\n\n                /**\n                 * Changes admin usage setting to yes\n                 */\n                enableAdminUsage: function () {\n                    var data = {\n                        'form_key': window.FORM_KEY\n                    };\n\n                    $.ajax(\n                        {\n                            type: 'POST',\n                            url: this.enableLogAction,\n                            data: data,\n                            showLoader: true\n                        }\n                    ).done(\n                        function (xhr) {\n                            if (xhr.error) {\n                                self.onError(xhr);\n                            }\n                        }\n                    ).fail(this.onError);\n                    this.openReleasePopup();\n                    this.closeModal();\n                },\n\n                /**\n                 * Changes admin usage setting to no\n                 */\n                disableAdminUsage: function () {\n                    var data = {\n                        'form_key': window.FORM_KEY\n                    };\n\n                    $.ajax(\n                        {\n                            type: 'POST',\n                            url: this.disableLogAction,\n                            data: data,\n                            showLoader: true\n                        }\n                    ).done(\n                        function (xhr) {\n                            if (xhr.error) {\n                                self.onError(xhr);\n                            }\n                        }\n                    ).fail(this.onError);\n                    this.openReleasePopup();\n                    this.closeModal();\n                },\n\n                /**\n                 * Allows admin usage popup to be shown first and then new release notification\n                 */\n                openReleasePopup: function () {\n                    var notificationModalSelector = 'release_notification.release_notification.notification_modal_1';\n\n                    if (analyticsPopupConfig.releaseVisible) {\n                        registry.get(notificationModalSelector).initializeContentAfterAnalytics();\n                    }\n                },\n\n                /**\n                 * Handle Tab and Shift+Tab key event\n                 *\n                 * Keep the tab actions restricted to the popup modal\n                 * so the user must select an option to dismiss the modal\n                 */\n                handleTabKey: function (event) {\n                    var modal = this,\n                        KEY_TAB = 9;\n\n                    /**\n                     * Handle Shift+Tab to tab backwards\n                     */\n                    function handleBackwardTab() {\n                        if (document.activeElement === modal.firstFocusableElement ||\n                            document.activeElement === $(modal.rootSelector)[0]\n                        ) {\n                            event.preventDefault();\n                            modal.lastFocusableElement.focus();\n                        }\n                    }\n\n                    /**\n                     * Handle Tab forward\n                     */\n                    function handleForwardTab() {\n                        if (document.activeElement === modal.lastFocusableElement) {\n                            event.preventDefault();\n                            modal.firstFocusableElement.focus();\n                        }\n                    }\n\n                    switch (event.keyCode) {\n                        case KEY_TAB:\n                            if (modal.focusableElements.length === 1) {\n                                event.preventDefault();\n                                break;\n                            }\n\n                            if (event.shiftKey) {\n                                handleBackwardTab();\n                                break;\n                            }\n                            handleForwardTab();\n                            break;\n                        default:\n                            break;\n                    }\n                },\n\n                /**\n                 * Handle Esc key\n                 *\n                 * Esc key should not close modal\n                 */\n                handleEscKey: function (event) {\n                    event.preventDefault();\n                }\n            }\n        );\n    }\n);\n","knockoutjs/knockout.js":"/*!\n * Knockout JavaScript library v3.5.1\n * (c) The Knockout.js team - http://knockoutjs.com/\n * License: MIT (http://www.opensource.org/licenses/mit-license.php)\n */\n\n(function(){\n    var DEBUG=true;\n    (function(undefined){\n        // (0, eval)('this') is a robust way of getting a reference to the global object\n        // For details, see http://stackoverflow.com/questions/14119988/return-this-0-evalthis/14120023#14120023\n        var window = this || (0, eval)('this'),\n            document = window['document'],\n            navigator = window['navigator'],\n            jQueryInstance = window[\"jQuery\"],\n            JSON = window[\"JSON\"];\n\n        if (!jQueryInstance && typeof jQuery !== \"undefined\") {\n            jQueryInstance = jQuery;\n        }\n        (function(factory) {\n            // Support three module loading scenarios\n            if (typeof define === 'function' && define['amd']) {\n                // [1] AMD anonymous module\n                define(['exports', 'require'], factory);\n            } else if (typeof exports === 'object' && typeof module === 'object') {\n                // [2] CommonJS/Node.js\n                factory(module['exports'] || exports);  // module.exports is for Node.js\n            } else {\n                // [3] No module loader (plain <script> tag) - put directly in global namespace\n                factory(window['ko'] = {});\n            }\n        }(function(koExports, amdRequire){\n// Internally, all KO objects are attached to koExports (even the non-exported ones whose names will be minified by the closure compiler).\n// In the future, the following \"ko\" variable may be made distinct from \"koExports\" so that private objects are not externally reachable.\n            var ko = typeof koExports !== 'undefined' ? koExports : {};\n// Google Closure Compiler helpers (used only to make the minified file smaller)\n            ko.exportSymbol = function(koPath, object) {\n                var tokens = koPath.split(\".\");\n\n                // In the future, \"ko\" may become distinct from \"koExports\" (so that non-exported objects are not reachable)\n                // At that point, \"target\" would be set to: (typeof koExports !== \"undefined\" ? koExports : ko)\n                var target = ko;\n\n                for (var i = 0; i < tokens.length - 1; i++)\n                    target = target[tokens[i]];\n                target[tokens[tokens.length - 1]] = object;\n            };\n            ko.exportProperty = function(owner, publicName, object) {\n                owner[publicName] = object;\n            };\n            ko.version = \"3.5.1\";\n\n            ko.exportSymbol('version', ko.version);\n// For any options that may affect various areas of Knockout and aren't directly associated with data binding.\n            ko.options = {\n                'deferUpdates': false,\n                'useOnlyNativeEvents': false,\n                'foreachHidesDestroyed': false\n            };\n\n//ko.exportSymbol('options', ko.options);   // 'options' isn't minified\n            ko.utils = (function () {\n                var hasOwnProperty = Object.prototype.hasOwnProperty;\n\n                function objectForEach(obj, action) {\n                    for (var prop in obj) {\n                        if (hasOwnProperty.call(obj, prop)) {\n                            action(prop, obj[prop]);\n                        }\n                    }\n                }\n\n                function extend(target, source) {\n                    if (source) {\n                        for(var prop in source) {\n                            if(hasOwnProperty.call(source, prop)) {\n                                target[prop] = source[prop];\n                            }\n                        }\n                    }\n                    return target;\n                }\n\n                function setPrototypeOf(obj, proto) {\n                    obj.__proto__ = proto;\n                    return obj;\n                }\n\n                var canSetPrototype = ({ __proto__: [] } instanceof Array);\n                var canUseSymbols = !DEBUG && typeof Symbol === 'function';\n\n                // Represent the known event types in a compact way, then at runtime transform it into a hash with event name as key (for fast lookup)\n                var knownEvents = {}, knownEventTypesByEventName = {};\n                var keyEventTypeName = (navigator && /Firefox\\/2/i.test(navigator.userAgent)) ? 'KeyboardEvent' : 'UIEvents';\n                knownEvents[keyEventTypeName] = ['keyup', 'keydown', 'keypress'];\n                knownEvents['MouseEvents'] = ['click', 'dblclick', 'mousedown', 'mouseup', 'mousemove', 'mouseover', 'mouseout', 'mouseenter', 'mouseleave'];\n                objectForEach(knownEvents, function(eventType, knownEventsForType) {\n                    if (knownEventsForType.length) {\n                        for (var i = 0, j = knownEventsForType.length; i < j; i++)\n                            knownEventTypesByEventName[knownEventsForType[i]] = eventType;\n                    }\n                });\n                var eventsThatMustBeRegisteredUsingAttachEvent = { 'propertychange': true }; // Workaround for an IE9 issue - https://github.com/SteveSanderson/knockout/issues/406\n\n                // Detect IE versions for bug workarounds (uses IE conditionals, not UA string, for robustness)\n                // Note that, since IE 10 does not support conditional comments, the following logic only detects IE < 10.\n                // Currently this is by design, since IE 10+ behaves correctly when treated as a standard browser.\n                // If there is a future need to detect specific versions of IE10+, we will amend this.\n                var ieVersion = document && (function() {\n                    var version = 3, div = document.createElement('div'), iElems = div.getElementsByTagName('i');\n\n                    // Keep constructing conditional HTML blocks until we hit one that resolves to an empty fragment\n                    while (\n                        div.innerHTML = '<!--[if gt IE ' + (++version) + ']><i></i><![endif]-->',\n                            iElems[0]\n                        ) {}\n                    return version > 4 ? version : undefined;\n                }());\n                var isIe6 = ieVersion === 6,\n                    isIe7 = ieVersion === 7;\n\n                function isClickOnCheckableElement(element, eventType) {\n                    if ((ko.utils.tagNameLower(element) !== \"input\") || !element.type) return false;\n                    if (eventType.toLowerCase() != \"click\") return false;\n                    var inputType = element.type;\n                    return (inputType == \"checkbox\") || (inputType == \"radio\");\n                }\n\n                // For details on the pattern for changing node classes\n                // see: https://github.com/knockout/knockout/issues/1597\n                var cssClassNameRegex = /\\S+/g;\n\n                var jQueryEventAttachName;\n\n                function toggleDomNodeCssClass(node, classNames, shouldHaveClass) {\n                    var addOrRemoveFn;\n                    if (classNames) {\n                        if (typeof node.classList === 'object') {\n                            addOrRemoveFn = node.classList[shouldHaveClass ? 'add' : 'remove'];\n                            ko.utils.arrayForEach(classNames.match(cssClassNameRegex), function(className) {\n                                addOrRemoveFn.call(node.classList, className);\n                            });\n                        } else if (typeof node.className['baseVal'] === 'string') {\n                            // SVG tag .classNames is an SVGAnimatedString instance\n                            toggleObjectClassPropertyString(node.className, 'baseVal', classNames, shouldHaveClass);\n                        } else {\n                            // node.className ought to be a string.\n                            toggleObjectClassPropertyString(node, 'className', classNames, shouldHaveClass);\n                        }\n                    }\n                }\n\n                function toggleObjectClassPropertyString(obj, prop, classNames, shouldHaveClass) {\n                    // obj/prop is either a node/'className' or a SVGAnimatedString/'baseVal'.\n                    var currentClassNames = obj[prop].match(cssClassNameRegex) || [];\n                    ko.utils.arrayForEach(classNames.match(cssClassNameRegex), function(className) {\n                        ko.utils.addOrRemoveItem(currentClassNames, className, shouldHaveClass);\n                    });\n                    obj[prop] = currentClassNames.join(\" \");\n                }\n\n                return {\n                    fieldsIncludedWithJsonPost: ['authenticity_token', /^__RequestVerificationToken(_.*)?$/],\n\n                    arrayForEach: function (array, action, actionOwner) {\n                        for (var i = 0, j = array.length; i < j; i++) {\n                            action.call(actionOwner, array[i], i, array);\n                        }\n                    },\n\n                    arrayIndexOf: typeof Array.prototype.indexOf == \"function\"\n                        ? function (array, item) {\n                            return Array.prototype.indexOf.call(array, item);\n                        }\n                        : function (array, item) {\n                            for (var i = 0, j = array.length; i < j; i++) {\n                                if (array[i] === item)\n                                    return i;\n                            }\n                            return -1;\n                        },\n\n                    arrayFirst: function (array, predicate, predicateOwner) {\n                        for (var i = 0, j = array.length; i < j; i++) {\n                            if (predicate.call(predicateOwner, array[i], i, array))\n                                return array[i];\n                        }\n                        return undefined;\n                    },\n\n                    arrayRemoveItem: function (array, itemToRemove) {\n                        var index = ko.utils.arrayIndexOf(array, itemToRemove);\n                        if (index > 0) {\n                            array.splice(index, 1);\n                        }\n                        else if (index === 0) {\n                            array.shift();\n                        }\n                    },\n\n                    arrayGetDistinctValues: function (array) {\n                        var result = [];\n                        if (array) {\n                            ko.utils.arrayForEach(array, function(item) {\n                                if (ko.utils.arrayIndexOf(result, item) < 0)\n                                    result.push(item);\n                            });\n                        }\n                        return result;\n                    },\n\n                    arrayMap: function (array, mapping, mappingOwner) {\n                        var result = [];\n                        if (array) {\n                            for (var i = 0, j = array.length; i < j; i++)\n                                result.push(mapping.call(mappingOwner, array[i], i));\n                        }\n                        return result;\n                    },\n\n                    arrayFilter: function (array, predicate, predicateOwner) {\n                        var result = [];\n                        if (array) {\n                            for (var i = 0, j = array.length; i < j; i++)\n                                if (predicate.call(predicateOwner, array[i], i))\n                                    result.push(array[i]);\n                        }\n                        return result;\n                    },\n\n                    arrayPushAll: function (array, valuesToPush) {\n                        if (valuesToPush instanceof Array)\n                            array.push.apply(array, valuesToPush);\n                        else\n                            for (var i = 0, j = valuesToPush.length; i < j; i++)\n                                array.push(valuesToPush[i]);\n                        return array;\n                    },\n\n                    addOrRemoveItem: function(array, value, included) {\n                        var existingEntryIndex = ko.utils.arrayIndexOf(ko.utils.peekObservable(array), value);\n                        if (existingEntryIndex < 0) {\n                            if (included)\n                                array.push(value);\n                        } else {\n                            if (!included)\n                                array.splice(existingEntryIndex, 1);\n                        }\n                    },\n\n                    canSetPrototype: canSetPrototype,\n\n                    extend: extend,\n\n                    setPrototypeOf: setPrototypeOf,\n\n                    setPrototypeOfOrExtend: canSetPrototype ? setPrototypeOf : extend,\n\n                    objectForEach: objectForEach,\n\n                    objectMap: function(source, mapping, mappingOwner) {\n                        if (!source)\n                            return source;\n                        var target = {};\n                        for (var prop in source) {\n                            if (hasOwnProperty.call(source, prop)) {\n                                target[prop] = mapping.call(mappingOwner, source[prop], prop, source);\n                            }\n                        }\n                        return target;\n                    },\n\n                    emptyDomNode: function (domNode) {\n                        while (domNode.firstChild) {\n                            ko.removeNode(domNode.firstChild);\n                        }\n                    },\n\n                    moveCleanedNodesToContainerElement: function(nodes) {\n                        // Ensure it's a real array, as we're about to reparent the nodes and\n                        // we don't want the underlying collection to change while we're doing that.\n                        var nodesArray = ko.utils.makeArray(nodes);\n                        var templateDocument = (nodesArray[0] && nodesArray[0].ownerDocument) || document;\n\n                        var container = templateDocument.createElement('div');\n                        for (var i = 0, j = nodesArray.length; i < j; i++) {\n                            container.appendChild(ko.cleanNode(nodesArray[i]));\n                        }\n                        return container;\n                    },\n\n                    cloneNodes: function (nodesArray, shouldCleanNodes) {\n                        for (var i = 0, j = nodesArray.length, newNodesArray = []; i < j; i++) {\n                            var clonedNode = nodesArray[i].cloneNode(true);\n                            newNodesArray.push(shouldCleanNodes ? ko.cleanNode(clonedNode) : clonedNode);\n                        }\n                        return newNodesArray;\n                    },\n\n                    setDomNodeChildren: function (domNode, childNodes) {\n                        ko.utils.emptyDomNode(domNode);\n                        if (childNodes) {\n                            for (var i = 0, j = childNodes.length; i < j; i++)\n                                domNode.appendChild(childNodes[i]);\n                        }\n                    },\n\n                    replaceDomNodes: function (nodeToReplaceOrNodeArray, newNodesArray) {\n                        var nodesToReplaceArray = nodeToReplaceOrNodeArray.nodeType ? [nodeToReplaceOrNodeArray] : nodeToReplaceOrNodeArray;\n                        if (nodesToReplaceArray.length > 0) {\n                            var insertionPoint = nodesToReplaceArray[0];\n                            var parent = insertionPoint.parentNode;\n                            for (var i = 0, j = newNodesArray.length; i < j; i++)\n                                parent.insertBefore(newNodesArray[i], insertionPoint);\n                            for (var i = 0, j = nodesToReplaceArray.length; i < j; i++) {\n                                ko.removeNode(nodesToReplaceArray[i]);\n                            }\n                        }\n                    },\n\n                    fixUpContinuousNodeArray: function(continuousNodeArray, parentNode) {\n                        // Before acting on a set of nodes that were previously outputted by a template function, we have to reconcile\n                        // them against what is in the DOM right now. It may be that some of the nodes have already been removed, or that\n                        // new nodes might have been inserted in the middle, for example by a binding. Also, there may previously have been\n                        // leading comment nodes (created by rewritten string-based templates) that have since been removed during binding.\n                        // So, this function translates the old \"map\" output array into its best guess of the set of current DOM nodes.\n                        //\n                        // Rules:\n                        //   [A] Any leading nodes that have been removed should be ignored\n                        //       These most likely correspond to memoization nodes that were already removed during binding\n                        //       See https://github.com/knockout/knockout/pull/440\n                        //   [B] Any trailing nodes that have been remove should be ignored\n                        //       This prevents the code here from adding unrelated nodes to the array while processing rule [C]\n                        //       See https://github.com/knockout/knockout/pull/1903\n                        //   [C] We want to output a continuous series of nodes. So, ignore any nodes that have already been removed,\n                        //       and include any nodes that have been inserted among the previous collection\n\n                        if (continuousNodeArray.length) {\n                            // The parent node can be a virtual element; so get the real parent node\n                            parentNode = (parentNode.nodeType === 8 && parentNode.parentNode) || parentNode;\n\n                            // Rule [A]\n                            while (continuousNodeArray.length && continuousNodeArray[0].parentNode !== parentNode)\n                                continuousNodeArray.splice(0, 1);\n\n                            // Rule [B]\n                            while (continuousNodeArray.length > 1 && continuousNodeArray[continuousNodeArray.length - 1].parentNode !== parentNode)\n                                continuousNodeArray.length--;\n\n                            // Rule [C]\n                            if (continuousNodeArray.length > 1) {\n                                var current = continuousNodeArray[0], last = continuousNodeArray[continuousNodeArray.length - 1];\n                                // Replace with the actual new continuous node set\n                                continuousNodeArray.length = 0;\n                                while (current !== last) {\n                                    continuousNodeArray.push(current);\n                                    current = current.nextSibling;\n                                }\n                                continuousNodeArray.push(last);\n                            }\n                        }\n                        return continuousNodeArray;\n                    },\n\n                    setOptionNodeSelectionState: function (optionNode, isSelected) {\n                        // IE6 sometimes throws \"unknown error\" if you try to write to .selected directly, whereas Firefox struggles with setAttribute. Pick one based on browser.\n                        if (ieVersion < 7)\n                            optionNode.setAttribute(\"selected\", isSelected);\n                        else\n                            optionNode.selected = isSelected;\n                    },\n\n                    stringTrim: function (string) {\n                        return string === null || string === undefined ? '' :\n                            string.trim ?\n                                string.trim() :\n                                string.toString().replace(/^[\\s\\xa0]+|[\\s\\xa0]+$/g, '');\n                    },\n\n                    stringStartsWith: function (string, startsWith) {\n                        string = string || \"\";\n                        if (startsWith.length > string.length)\n                            return false;\n                        return string.substring(0, startsWith.length) === startsWith;\n                    },\n\n                    domNodeIsContainedBy: function (node, containedByNode) {\n                        if (node === containedByNode)\n                            return true;\n                        if (node.nodeType === 11)\n                            return false; // Fixes issue #1162 - can't use node.contains for document fragments on IE8\n                        if (containedByNode.contains)\n                            return containedByNode.contains(node.nodeType !== 1 ? node.parentNode : node);\n                        if (containedByNode.compareDocumentPosition)\n                            return (containedByNode.compareDocumentPosition(node) & 16) == 16;\n                        while (node && node != containedByNode) {\n                            node = node.parentNode;\n                        }\n                        return !!node;\n                    },\n\n                    domNodeIsAttachedToDocument: function (node) {\n                        return ko.utils.domNodeIsContainedBy(node, node.ownerDocument.documentElement);\n                    },\n\n                    anyDomNodeIsAttachedToDocument: function(nodes) {\n                        return !!ko.utils.arrayFirst(nodes, ko.utils.domNodeIsAttachedToDocument);\n                    },\n\n                    tagNameLower: function(element) {\n                        // For HTML elements, tagName will always be upper case; for XHTML elements, it'll be lower case.\n                        // Possible future optimization: If we know it's an element from an XHTML document (not HTML),\n                        // we don't need to do the .toLowerCase() as it will always be lower case anyway.\n                        return element && element.tagName && element.tagName.toLowerCase();\n                    },\n\n                    catchFunctionErrors: function (delegate) {\n                        return ko['onError'] ? function () {\n                            try {\n                                return delegate.apply(this, arguments);\n                            } catch (e) {\n                                ko['onError'] && ko['onError'](e);\n                                throw e;\n                            }\n                        } : delegate;\n                    },\n\n                    setTimeout: function (handler, timeout) {\n                        return setTimeout(ko.utils.catchFunctionErrors(handler), timeout);\n                    },\n\n                    deferError: function (error) {\n                        setTimeout(function () {\n                            ko['onError'] && ko['onError'](error);\n                            throw error;\n                        }, 0);\n                    },\n\n                    registerEventHandler: function (element, eventType, handler) {\n                        var wrappedHandler = ko.utils.catchFunctionErrors(handler);\n\n                        var mustUseAttachEvent = eventsThatMustBeRegisteredUsingAttachEvent[eventType];\n                        if (!ko.options['useOnlyNativeEvents'] && !mustUseAttachEvent && jQueryInstance) {\n                            if (!jQueryEventAttachName) {\n                                jQueryEventAttachName = (typeof jQueryInstance(element)['on'] == 'function') ? 'on' : 'bind';\n                            }\n                            jQueryInstance(element)[jQueryEventAttachName](eventType, wrappedHandler);\n                        } else if (!mustUseAttachEvent && typeof element.addEventListener == \"function\")\n                            element.addEventListener(eventType, wrappedHandler, false);\n                        else if (typeof element.attachEvent != \"undefined\") {\n                            var attachEventHandler = function (event) { wrappedHandler.call(element, event); },\n                                attachEventName = \"on\" + eventType;\n                            element.attachEvent(attachEventName, attachEventHandler);\n\n                            // IE does not dispose attachEvent handlers automatically (unlike with addEventListener)\n                            // so to avoid leaks, we have to remove them manually. See bug #856\n                            ko.utils.domNodeDisposal.addDisposeCallback(element, function() {\n                                element.detachEvent(attachEventName, attachEventHandler);\n                            });\n                        } else\n                            throw new Error(\"Browser doesn't support addEventListener or attachEvent\");\n                    },\n\n                    triggerEvent: function (element, eventType) {\n                        if (!(element && element.nodeType))\n                            throw new Error(\"element must be a DOM node when calling triggerEvent\");\n\n                        // For click events on checkboxes and radio buttons, jQuery toggles the element checked state *after* the\n                        // event handler runs instead of *before*. (This was fixed in 1.9 for checkboxes but not for radio buttons.)\n                        // IE doesn't change the checked state when you trigger the click event using \"fireEvent\".\n                        // In both cases, we'll use the click method instead.\n                        var useClickWorkaround = isClickOnCheckableElement(element, eventType);\n\n                        if (!ko.options['useOnlyNativeEvents'] && jQueryInstance && !useClickWorkaround) {\n                            jQueryInstance(element)['trigger'](eventType);\n                        } else if (typeof document.createEvent == \"function\") {\n                            if (typeof element.dispatchEvent == \"function\") {\n                                var eventCategory = knownEventTypesByEventName[eventType] || \"HTMLEvents\";\n                                var event = document.createEvent(eventCategory);\n                                event.initEvent(eventType, true, true, window, 0, 0, 0, 0, 0, false, false, false, false, 0, element);\n                                element.dispatchEvent(event);\n                            }\n                            else\n                                throw new Error(\"The supplied element doesn't support dispatchEvent\");\n                        } else if (useClickWorkaround && element.click) {\n                            element.click();\n                        } else if (typeof element.fireEvent != \"undefined\") {\n                            element.fireEvent(\"on\" + eventType);\n                        } else {\n                            throw new Error(\"Browser doesn't support triggering events\");\n                        }\n                    },\n\n                    unwrapObservable: function (value) {\n                        return ko.isObservable(value) ? value() : value;\n                    },\n\n                    peekObservable: function (value) {\n                        return ko.isObservable(value) ? value.peek() : value;\n                    },\n\n                    toggleDomNodeCssClass: toggleDomNodeCssClass,\n\n                    setTextContent: function(element, textContent) {\n                        var value = ko.utils.unwrapObservable(textContent);\n                        if ((value === null) || (value === undefined))\n                            value = \"\";\n\n                        // We need there to be exactly one child: a text node.\n                        // If there are no children, more than one, or if it's not a text node,\n                        // we'll clear everything and create a single text node.\n                        var innerTextNode = ko.virtualElements.firstChild(element);\n                        if (!innerTextNode || innerTextNode.nodeType != 3 || ko.virtualElements.nextSibling(innerTextNode)) {\n                            ko.virtualElements.setDomNodeChildren(element, [element.ownerDocument.createTextNode(value)]);\n                        } else {\n                            innerTextNode.data = value;\n                        }\n\n                        ko.utils.forceRefresh(element);\n                    },\n\n                    setElementName: function(element, name) {\n                        element.name = name;\n\n                        // Workaround IE 6/7 issue\n                        // - https://github.com/SteveSanderson/knockout/issues/197\n                        // - http://www.matts411.com/post/setting_the_name_attribute_in_ie_dom/\n                        if (ieVersion <= 7) {\n                            try {\n                                var escapedName = element.name.replace(/[&<>'\"]/g, function(r){ return \"&#\" + r.charCodeAt(0) + \";\"; });\n                                element.mergeAttributes(document.createElement(\"<input name='\" + escapedName + \"'/>\"), false);\n                            }\n                            catch(e) {} // For IE9 with doc mode \"IE9 Standards\" and browser mode \"IE9 Compatibility View\"\n                        }\n                    },\n\n                    forceRefresh: function(node) {\n                        // Workaround for an IE9 rendering bug - https://github.com/SteveSanderson/knockout/issues/209\n                        if (ieVersion >= 9) {\n                            // For text nodes and comment nodes (most likely virtual elements), we will have to refresh the container\n                            var elem = node.nodeType == 1 ? node : node.parentNode;\n                            if (elem.style)\n                                elem.style.zoom = elem.style.zoom;\n                        }\n                    },\n\n                    ensureSelectElementIsRenderedCorrectly: function(selectElement) {\n                        // Workaround for IE9 rendering bug - it doesn't reliably display all the text in dynamically-added select boxes unless you force it to re-render by updating the width.\n                        // (See https://github.com/SteveSanderson/knockout/issues/312, http://stackoverflow.com/questions/5908494/select-only-shows-first-char-of-selected-option)\n                        // Also fixes IE7 and IE8 bug that causes selects to be zero width if enclosed by 'if' or 'with'. (See issue #839)\n                        if (ieVersion) {\n                            var originalWidth = selectElement.style.width;\n                            selectElement.style.width = 0;\n                            selectElement.style.width = originalWidth;\n                        }\n                    },\n\n                    range: function (min, max) {\n                        min = ko.utils.unwrapObservable(min);\n                        max = ko.utils.unwrapObservable(max);\n                        var result = [];\n                        for (var i = min; i <= max; i++)\n                            result.push(i);\n                        return result;\n                    },\n\n                    makeArray: function(arrayLikeObject) {\n                        var result = [];\n                        for (var i = 0, j = arrayLikeObject.length; i < j; i++) {\n                            result.push(arrayLikeObject[i]);\n                        };\n                        return result;\n                    },\n\n                    createSymbolOrString: function(identifier) {\n                        return canUseSymbols ? Symbol(identifier) : identifier;\n                    },\n\n                    isIe6 : isIe6,\n                    isIe7 : isIe7,\n                    ieVersion : ieVersion,\n\n                    getFormFields: function(form, fieldName) {\n                        var fields = ko.utils.makeArray(form.getElementsByTagName(\"input\")).concat(ko.utils.makeArray(form.getElementsByTagName(\"textarea\")));\n                        var isMatchingField = (typeof fieldName == 'string')\n                            ? function(field) { return field.name === fieldName }\n                            : function(field) { return fieldName.test(field.name) }; // Treat fieldName as regex or object containing predicate\n                        var matches = [];\n                        for (var i = fields.length - 1; i >= 0; i--) {\n                            if (isMatchingField(fields[i]))\n                                matches.push(fields[i]);\n                        };\n                        return matches;\n                    },\n\n                    parseJson: function (jsonString) {\n                        if (typeof jsonString == \"string\") {\n                            jsonString = ko.utils.stringTrim(jsonString);\n                            if (jsonString) {\n                                if (JSON && JSON.parse) // Use native parsing where available\n                                    return JSON.parse(jsonString);\n                                return (new Function(\"return \" + jsonString))(); // Fallback on less safe parsing for older browsers\n                            }\n                        }\n                        return null;\n                    },\n\n                    stringifyJson: function (data, replacer, space) {   // replacer and space are optional\n                        if (!JSON || !JSON.stringify)\n                            throw new Error(\"Cannot find JSON.stringify(). Some browsers (e.g., IE < 8) don't support it natively, but you can overcome this by adding a script reference to json2.js, downloadable from http://www.json.org/json2.js\");\n                        return JSON.stringify(ko.utils.unwrapObservable(data), replacer, space);\n                    },\n\n                    postJson: function (urlOrForm, data, options) {\n                        options = options || {};\n                        var params = options['params'] || {};\n                        var includeFields = options['includeFields'] || this.fieldsIncludedWithJsonPost;\n                        var url = urlOrForm;\n\n                        // If we were given a form, use its 'action' URL and pick out any requested field values\n                        if((typeof urlOrForm == 'object') && (ko.utils.tagNameLower(urlOrForm) === \"form\")) {\n                            var originalForm = urlOrForm;\n                            url = originalForm.action;\n                            for (var i = includeFields.length - 1; i >= 0; i--) {\n                                var fields = ko.utils.getFormFields(originalForm, includeFields[i]);\n                                for (var j = fields.length - 1; j >= 0; j--)\n                                    params[fields[j].name] = fields[j].value;\n                            }\n                        }\n\n                        data = ko.utils.unwrapObservable(data);\n                        var form = document.createElement(\"form\");\n                        form.style.display = \"none\";\n                        form.action = url;\n                        form.method = \"post\";\n                        for (var key in data) {\n                            // Since 'data' this is a model object, we include all properties including those inherited from its prototype\n                            var input = document.createElement(\"input\");\n                            input.type = \"hidden\";\n                            input.name = key;\n                            input.value = ko.utils.stringifyJson(ko.utils.unwrapObservable(data[key]));\n                            form.appendChild(input);\n                        }\n                        objectForEach(params, function(key, value) {\n                            var input = document.createElement(\"input\");\n                            input.type = \"hidden\";\n                            input.name = key;\n                            input.value = value;\n                            form.appendChild(input);\n                        });\n                        document.body.appendChild(form);\n                        options['submitter'] ? options['submitter'](form) : form.submit();\n                        setTimeout(function () { form.parentNode.removeChild(form); }, 0);\n                    }\n                }\n            }());\n\n            ko.exportSymbol('utils', ko.utils);\n            ko.exportSymbol('utils.arrayForEach', ko.utils.arrayForEach);\n            ko.exportSymbol('utils.arrayFirst', ko.utils.arrayFirst);\n            ko.exportSymbol('utils.arrayFilter', ko.utils.arrayFilter);\n            ko.exportSymbol('utils.arrayGetDistinctValues', ko.utils.arrayGetDistinctValues);\n            ko.exportSymbol('utils.arrayIndexOf', ko.utils.arrayIndexOf);\n            ko.exportSymbol('utils.arrayMap', ko.utils.arrayMap);\n            ko.exportSymbol('utils.arrayPushAll', ko.utils.arrayPushAll);\n            ko.exportSymbol('utils.arrayRemoveItem', ko.utils.arrayRemoveItem);\n            ko.exportSymbol('utils.cloneNodes', ko.utils.cloneNodes);\n            ko.exportSymbol('utils.createSymbolOrString', ko.utils.createSymbolOrString);\n            ko.exportSymbol('utils.extend', ko.utils.extend);\n            ko.exportSymbol('utils.fieldsIncludedWithJsonPost', ko.utils.fieldsIncludedWithJsonPost);\n            ko.exportSymbol('utils.getFormFields', ko.utils.getFormFields);\n            ko.exportSymbol('utils.objectMap', ko.utils.objectMap);\n            ko.exportSymbol('utils.peekObservable', ko.utils.peekObservable);\n            ko.exportSymbol('utils.postJson', ko.utils.postJson);\n            ko.exportSymbol('utils.parseJson', ko.utils.parseJson);\n            ko.exportSymbol('utils.registerEventHandler', ko.utils.registerEventHandler);\n            ko.exportSymbol('utils.stringifyJson', ko.utils.stringifyJson);\n            ko.exportSymbol('utils.range', ko.utils.range);\n            ko.exportSymbol('utils.toggleDomNodeCssClass', ko.utils.toggleDomNodeCssClass);\n            ko.exportSymbol('utils.triggerEvent', ko.utils.triggerEvent);\n            ko.exportSymbol('utils.unwrapObservable', ko.utils.unwrapObservable);\n            ko.exportSymbol('utils.objectForEach', ko.utils.objectForEach);\n            ko.exportSymbol('utils.addOrRemoveItem', ko.utils.addOrRemoveItem);\n            ko.exportSymbol('utils.setTextContent', ko.utils.setTextContent);\n            ko.exportSymbol('unwrap', ko.utils.unwrapObservable); // Convenient shorthand, because this is used so commonly\n\n            if (!Function.prototype['bind']) {\n                // Function.prototype.bind is a standard part of ECMAScript 5th Edition (December 2009, http://www.ecma-international.org/publications/files/ECMA-ST/ECMA-262.pdf)\n                // In case the browser doesn't implement it natively, provide a JavaScript implementation. This implementation is based on the one in prototype.js\n                Function.prototype['bind'] = function (object) {\n                    var originalFunction = this;\n                    if (arguments.length === 1) {\n                        return function () {\n                            return originalFunction.apply(object, arguments);\n                        };\n                    } else {\n                        var partialArgs = Array.prototype.slice.call(arguments, 1);\n                        return function () {\n                            var args = partialArgs.slice(0);\n                            args.push.apply(args, arguments);\n                            return originalFunction.apply(object, args);\n                        };\n                    }\n                };\n            }\n\n            ko.utils.domData = new (function () {\n                var uniqueId = 0;\n                var dataStoreKeyExpandoPropertyName = \"__ko__\" + (new Date).getTime();\n                var dataStore = {};\n\n                var getDataForNode, clear;\n                if (!ko.utils.ieVersion) {\n                    // We considered using WeakMap, but it has a problem in IE 11 and Edge that prevents using\n                    // it cross-window, so instead we just store the data directly on the node.\n                    // See https://github.com/knockout/knockout/issues/2141\n                    getDataForNode = function (node, createIfNotFound) {\n                        var dataForNode = node[dataStoreKeyExpandoPropertyName];\n                        if (!dataForNode && createIfNotFound) {\n                            dataForNode = node[dataStoreKeyExpandoPropertyName] = {};\n                        }\n                        return dataForNode;\n                    };\n                    clear = function (node) {\n                        if (node[dataStoreKeyExpandoPropertyName]) {\n                            delete node[dataStoreKeyExpandoPropertyName];\n                            return true; // Exposing \"did clean\" flag purely so specs can infer whether things have been cleaned up as intended\n                        }\n                        return false;\n                    };\n                } else {\n                    // Old IE versions have memory issues if you store objects on the node, so we use a\n                    // separate data storage and link to it from the node using a string key.\n                    getDataForNode = function (node, createIfNotFound) {\n                        var dataStoreKey = node[dataStoreKeyExpandoPropertyName];\n                        var hasExistingDataStore = dataStoreKey && (dataStoreKey !== \"null\") && dataStore[dataStoreKey];\n                        if (!hasExistingDataStore) {\n                            if (!createIfNotFound)\n                                return undefined;\n                            dataStoreKey = node[dataStoreKeyExpandoPropertyName] = \"ko\" + uniqueId++;\n                            dataStore[dataStoreKey] = {};\n                        }\n                        return dataStore[dataStoreKey];\n                    };\n                    clear = function (node) {\n                        var dataStoreKey = node[dataStoreKeyExpandoPropertyName];\n                        if (dataStoreKey) {\n                            delete dataStore[dataStoreKey];\n                            node[dataStoreKeyExpandoPropertyName] = null;\n                            return true; // Exposing \"did clean\" flag purely so specs can infer whether things have been cleaned up as intended\n                        }\n                        return false;\n                    };\n                }\n\n                return {\n                    get: function (node, key) {\n                        var dataForNode = getDataForNode(node, false);\n                        return dataForNode && dataForNode[key];\n                    },\n                    set: function (node, key, value) {\n                        // Make sure we don't actually create a new domData key if we are actually deleting a value\n                        var dataForNode = getDataForNode(node, value !== undefined /* createIfNotFound */);\n                        dataForNode && (dataForNode[key] = value);\n                    },\n                    getOrSet: function (node, key, value) {\n                        var dataForNode = getDataForNode(node, true /* createIfNotFound */);\n                        return dataForNode[key] || (dataForNode[key] = value);\n                    },\n                    clear: clear,\n\n                    nextKey: function () {\n                        return (uniqueId++) + dataStoreKeyExpandoPropertyName;\n                    }\n                };\n            })();\n\n            ko.exportSymbol('utils.domData', ko.utils.domData);\n            ko.exportSymbol('utils.domData.clear', ko.utils.domData.clear); // Exporting only so specs can clear up after themselves fully\n\n            ko.utils.domNodeDisposal = new (function () {\n                var domDataKey = ko.utils.domData.nextKey();\n                var cleanableNodeTypes = { 1: true, 8: true, 9: true };       // Element, Comment, Document\n                var cleanableNodeTypesWithDescendants = { 1: true, 9: true }; // Element, Document\n\n                function getDisposeCallbacksCollection(node, createIfNotFound) {\n                    var allDisposeCallbacks = ko.utils.domData.get(node, domDataKey);\n                    if ((allDisposeCallbacks === undefined) && createIfNotFound) {\n                        allDisposeCallbacks = [];\n                        ko.utils.domData.set(node, domDataKey, allDisposeCallbacks);\n                    }\n                    return allDisposeCallbacks;\n                }\n                function destroyCallbacksCollection(node) {\n                    ko.utils.domData.set(node, domDataKey, undefined);\n                }\n\n                function cleanSingleNode(node) {\n                    // Run all the dispose callbacks\n                    var callbacks = getDisposeCallbacksCollection(node, false);\n                    if (callbacks) {\n                        callbacks = callbacks.slice(0); // Clone, as the array may be modified during iteration (typically, callbacks will remove themselves)\n                        for (var i = 0; i < callbacks.length; i++)\n                            callbacks[i](node);\n                    }\n\n                    // Erase the DOM data\n                    ko.utils.domData.clear(node);\n\n                    // Perform cleanup needed by external libraries (currently only jQuery, but can be extended)\n                    ko.utils.domNodeDisposal[\"cleanExternalData\"](node);\n\n                    // Clear any immediate-child comment nodes, as these wouldn't have been found by\n                    // node.getElementsByTagName(\"*\") in cleanNode() (comment nodes aren't elements)\n                    if (cleanableNodeTypesWithDescendants[node.nodeType]) {\n                        cleanNodesInList(node.childNodes, true/*onlyComments*/);\n                    }\n                }\n\n                function cleanNodesInList(nodeList, onlyComments) {\n                    var cleanedNodes = [], lastCleanedNode;\n                    for (var i = 0; i < nodeList.length; i++) {\n                        if (!onlyComments || nodeList[i].nodeType === 8) {\n                            cleanSingleNode(cleanedNodes[cleanedNodes.length] = lastCleanedNode = nodeList[i]);\n                            if (nodeList[i] !== lastCleanedNode) {\n                                while (i-- && ko.utils.arrayIndexOf(cleanedNodes, nodeList[i]) == -1) {}\n                            }\n                        }\n                    }\n                }\n\n                return {\n                    addDisposeCallback : function(node, callback) {\n                        if (typeof callback != \"function\")\n                            throw new Error(\"Callback must be a function\");\n                        getDisposeCallbacksCollection(node, true).push(callback);\n                    },\n\n                    removeDisposeCallback : function(node, callback) {\n                        var callbacksCollection = getDisposeCallbacksCollection(node, false);\n                        if (callbacksCollection) {\n                            ko.utils.arrayRemoveItem(callbacksCollection, callback);\n                            if (callbacksCollection.length == 0)\n                                destroyCallbacksCollection(node);\n                        }\n                    },\n\n                    cleanNode : function(node) {\n                        ko.dependencyDetection.ignore(function () {\n                            // First clean this node, where applicable\n                            if (cleanableNodeTypes[node.nodeType]) {\n                                cleanSingleNode(node);\n\n                                // ... then its descendants, where applicable\n                                if (cleanableNodeTypesWithDescendants[node.nodeType]) {\n                                    cleanNodesInList(node.getElementsByTagName(\"*\"));\n                                }\n                            }\n                        });\n\n                        return node;\n                    },\n\n                    removeNode : function(node) {\n                        ko.cleanNode(node);\n                        if (node.parentNode)\n                            node.parentNode.removeChild(node);\n                    },\n\n                    \"cleanExternalData\" : function (node) {\n                        // Special support for jQuery here because it's so commonly used.\n                        // Many jQuery plugins (including jquery.tmpl) store data using jQuery's equivalent of domData\n                        // so notify it to tear down any resources associated with the node & descendants here.\n                        if (jQueryInstance && (typeof jQueryInstance['cleanData'] == \"function\"))\n                            jQueryInstance['cleanData']([node]);\n                    }\n                };\n            })();\n            ko.cleanNode = ko.utils.domNodeDisposal.cleanNode; // Shorthand name for convenience\n            ko.removeNode = ko.utils.domNodeDisposal.removeNode; // Shorthand name for convenience\n            ko.exportSymbol('cleanNode', ko.cleanNode);\n            ko.exportSymbol('removeNode', ko.removeNode);\n            ko.exportSymbol('utils.domNodeDisposal', ko.utils.domNodeDisposal);\n            ko.exportSymbol('utils.domNodeDisposal.addDisposeCallback', ko.utils.domNodeDisposal.addDisposeCallback);\n            ko.exportSymbol('utils.domNodeDisposal.removeDisposeCallback', ko.utils.domNodeDisposal.removeDisposeCallback);\n            (function () {\n                var none = [0, \"\", \"\"],\n                    table = [1, \"<table>\", \"</table>\"],\n                    tbody = [2, \"<table><tbody>\", \"</tbody></table>\"],\n                    tr = [3, \"<table><tbody><tr>\", \"</tr></tbody></table>\"],\n                    select = [1, \"<select multiple='multiple'>\", \"</select>\"],\n                    lookup = {\n                        'thead': table,\n                        'tbody': table,\n                        'tfoot': table,\n                        'tr': tbody,\n                        'td': tr,\n                        'th': tr,\n                        'option': select,\n                        'optgroup': select\n                    },\n\n                    // This is needed for old IE if you're *not* using either jQuery or innerShiv. Doesn't affect other cases.\n                    mayRequireCreateElementHack = ko.utils.ieVersion <= 8;\n\n                function getWrap(tags) {\n                    var m = tags.match(/^(?:<!--.*?-->\\s*?)*?<([a-z]+)[\\s>]/);\n                    return (m && lookup[m[1]]) || none;\n                }\n\n                function simpleHtmlParse(html, documentContext) {\n                    documentContext || (documentContext = document);\n                    var windowContext = documentContext['parentWindow'] || documentContext['defaultView'] || window;\n\n                    // Based on jQuery's \"clean\" function, but only accounting for table-related elements.\n                    // If you have referenced jQuery, this won't be used anyway - KO will use jQuery's \"clean\" function directly\n\n                    // Note that there's still an issue in IE < 9 whereby it will discard comment nodes that are the first child of\n                    // a descendant node. For example: \"<div><!-- mycomment -->abc</div>\" will get parsed as \"<div>abc</div>\"\n                    // This won't affect anyone who has referenced jQuery, and there's always the workaround of inserting a dummy node\n                    // (possibly a text node) in front of the comment. So, KO does not attempt to workaround this IE issue automatically at present.\n\n                    // Trim whitespace, otherwise indexOf won't work as expected\n                    var tags = ko.utils.stringTrim(html).toLowerCase(), div = documentContext.createElement(\"div\"),\n                        wrap = getWrap(tags),\n                        depth = wrap[0];\n\n                    // Go to html and back, then peel off extra wrappers\n                    // Note that we always prefix with some dummy text, because otherwise, IE<9 will strip out leading comment nodes in descendants. Total madness.\n                    var markup = \"ignored<div>\" + wrap[1] + html + wrap[2] + \"</div>\";\n                    if (typeof windowContext['innerShiv'] == \"function\") {\n                        // Note that innerShiv is deprecated in favour of html5shiv. We should consider adding\n                        // support for html5shiv (except if no explicit support is needed, e.g., if html5shiv\n                        // somehow shims the native APIs so it just works anyway)\n                        div.appendChild(windowContext['innerShiv'](markup));\n                    } else {\n                        if (mayRequireCreateElementHack) {\n                            // The document.createElement('my-element') trick to enable custom elements in IE6-8\n                            // only works if we assign innerHTML on an element associated with that document.\n                            documentContext.body.appendChild(div);\n                        }\n\n                        div.innerHTML = markup;\n\n                        if (mayRequireCreateElementHack) {\n                            div.parentNode.removeChild(div);\n                        }\n                    }\n\n                    // Move to the right depth\n                    while (depth--)\n                        div = div.lastChild;\n\n                    return ko.utils.makeArray(div.lastChild.childNodes);\n                }\n\n                function jQueryHtmlParse(html, documentContext) {\n                    // jQuery's \"parseHTML\" function was introduced in jQuery 1.8.0 and is a documented public API.\n                    if (jQueryInstance['parseHTML']) {\n                        return jQueryInstance['parseHTML'](html, documentContext) || []; // Ensure we always return an array and never null\n                    } else {\n                        // For jQuery < 1.8.0, we fall back on the undocumented internal \"clean\" function.\n                        var elems = jQueryInstance['clean']([html], documentContext);\n\n                        // As of jQuery 1.7.1, jQuery parses the HTML by appending it to some dummy parent nodes held in an in-memory document fragment.\n                        // Unfortunately, it never clears the dummy parent nodes from the document fragment, so it leaks memory over time.\n                        // Fix this by finding the top-most dummy parent element, and detaching it from its owner fragment.\n                        if (elems && elems[0]) {\n                            // Find the top-most parent element that's a direct child of a document fragment\n                            var elem = elems[0];\n                            while (elem.parentNode && elem.parentNode.nodeType !== 11 /* i.e., DocumentFragment */)\n                                elem = elem.parentNode;\n                            // ... then detach it\n                            if (elem.parentNode)\n                                elem.parentNode.removeChild(elem);\n                        }\n\n                        return elems;\n                    }\n                }\n\n                ko.utils.parseHtmlFragment = function(html, documentContext) {\n                    return jQueryInstance ?\n                        jQueryHtmlParse(html, documentContext) :   // As below, benefit from jQuery's optimisations where possible\n                        simpleHtmlParse(html, documentContext);  // ... otherwise, this simple logic will do in most common cases.\n                };\n\n                ko.utils.parseHtmlForTemplateNodes = function(html, documentContext) {\n                    var nodes = ko.utils.parseHtmlFragment(html, documentContext);\n                    return (nodes.length && nodes[0].parentElement) || ko.utils.moveCleanedNodesToContainerElement(nodes);\n                };\n\n                ko.utils.setHtml = function(node, html) {\n                    ko.utils.emptyDomNode(node);\n\n                    // There's no legitimate reason to display a stringified observable without unwrapping it, so we'll unwrap it\n                    html = ko.utils.unwrapObservable(html);\n\n                    if ((html !== null) && (html !== undefined)) {\n                        if (typeof html != 'string')\n                            html = html.toString();\n\n                        // jQuery contains a lot of sophisticated code to parse arbitrary HTML fragments,\n                        // for example <tr> elements which are not normally allowed to exist on their own.\n                        // If you've referenced jQuery we'll use that rather than duplicating its code.\n                        if (jQueryInstance) {\n                            jQueryInstance(node)['html'](html);\n                        } else {\n                            // ... otherwise, use KO's own parsing logic.\n                            var parsedNodes = ko.utils.parseHtmlFragment(html, node.ownerDocument);\n                            for (var i = 0; i < parsedNodes.length; i++)\n                                node.appendChild(parsedNodes[i]);\n                        }\n                    }\n                };\n            })();\n\n            ko.exportSymbol('utils.parseHtmlFragment', ko.utils.parseHtmlFragment);\n            ko.exportSymbol('utils.setHtml', ko.utils.setHtml);\n\n            ko.memoization = (function () {\n                var memos = {};\n\n                function randomMax8HexChars() {\n                    return (((1 + Math.random()) * 0x100000000) | 0).toString(16).substring(1);\n                }\n                function generateRandomId() {\n                    return randomMax8HexChars() + randomMax8HexChars();\n                }\n                function findMemoNodes(rootNode, appendToArray) {\n                    if (!rootNode)\n                        return;\n                    if (rootNode.nodeType == 8) {\n                        var memoId = ko.memoization.parseMemoText(rootNode.nodeValue);\n                        if (memoId != null)\n                            appendToArray.push({ domNode: rootNode, memoId: memoId });\n                    } else if (rootNode.nodeType == 1) {\n                        for (var i = 0, childNodes = rootNode.childNodes, j = childNodes.length; i < j; i++)\n                            findMemoNodes(childNodes[i], appendToArray);\n                    }\n                }\n\n                return {\n                    memoize: function (callback) {\n                        if (typeof callback != \"function\")\n                            throw new Error(\"You can only pass a function to ko.memoization.memoize()\");\n                        var memoId = generateRandomId();\n                        memos[memoId] = callback;\n                        return \"<!--[ko_memo:\" + memoId + \"]-->\";\n                    },\n\n                    unmemoize: function (memoId, callbackParams) {\n                        var callback = memos[memoId];\n                        if (callback === undefined)\n                            throw new Error(\"Couldn't find any memo with ID \" + memoId + \". Perhaps it's already been unmemoized.\");\n                        try {\n                            callback.apply(null, callbackParams || []);\n                            return true;\n                        }\n                        finally { delete memos[memoId]; }\n                    },\n\n                    unmemoizeDomNodeAndDescendants: function (domNode, extraCallbackParamsArray) {\n                        var memos = [];\n                        findMemoNodes(domNode, memos);\n                        for (var i = 0, j = memos.length; i < j; i++) {\n                            var node = memos[i].domNode;\n                            var combinedParams = [node];\n                            if (extraCallbackParamsArray)\n                                ko.utils.arrayPushAll(combinedParams, extraCallbackParamsArray);\n                            ko.memoization.unmemoize(memos[i].memoId, combinedParams);\n                            node.nodeValue = \"\"; // Neuter this node so we don't try to unmemoize it again\n                            if (node.parentNode)\n                                node.parentNode.removeChild(node); // If possible, erase it totally (not always possible - someone else might just hold a reference to it then call unmemoizeDomNodeAndDescendants again)\n                        }\n                    },\n\n                    parseMemoText: function (memoText) {\n                        var match = memoText.match(/^\\[ko_memo\\:(.*?)\\]$/);\n                        return match ? match[1] : null;\n                    }\n                };\n            })();\n\n            ko.exportSymbol('memoization', ko.memoization);\n            ko.exportSymbol('memoization.memoize', ko.memoization.memoize);\n            ko.exportSymbol('memoization.unmemoize', ko.memoization.unmemoize);\n            ko.exportSymbol('memoization.parseMemoText', ko.memoization.parseMemoText);\n            ko.exportSymbol('memoization.unmemoizeDomNodeAndDescendants', ko.memoization.unmemoizeDomNodeAndDescendants);\n            ko.tasks = (function () {\n                var scheduler,\n                    taskQueue = [],\n                    taskQueueLength = 0,\n                    nextHandle = 1,\n                    nextIndexToProcess = 0;\n\n                if (window['MutationObserver']) {\n                    // Chrome 27+, Firefox 14+, IE 11+, Opera 15+, Safari 6.1+\n                    // From https://github.com/petkaantonov/bluebird * Copyright (c) 2014 Petka Antonov * License: MIT\n                    scheduler = (function (callback) {\n                        var div = document.createElement(\"div\");\n                        new MutationObserver(callback).observe(div, {attributes: true});\n                        return function () { div.classList.toggle(\"foo\"); };\n                    })(scheduledProcess);\n                } else if (document && \"onreadystatechange\" in document.createElement(\"script\")) {\n                    // IE 6-10\n                    // From https://github.com/YuzuJS/setImmediate * Copyright (c) 2012 Barnesandnoble.com, llc, Donavon West, and Domenic Denicola * License: MIT\n                    scheduler = function (callback) {\n                        var script = document.createElement(\"script\");\n                        script.onreadystatechange = function () {\n                            script.onreadystatechange = null;\n                            document.documentElement.removeChild(script);\n                            script = null;\n                            callback();\n                        };\n                        document.documentElement.appendChild(script);\n                    };\n                } else {\n                    scheduler = function (callback) {\n                        setTimeout(callback, 0);\n                    };\n                }\n\n                function processTasks() {\n                    if (taskQueueLength) {\n                        // Each mark represents the end of a logical group of tasks and the number of these groups is\n                        // limited to prevent unchecked recursion.\n                        var mark = taskQueueLength, countMarks = 0;\n\n                        // nextIndexToProcess keeps track of where we are in the queue; processTasks can be called recursively without issue\n                        for (var task; nextIndexToProcess < taskQueueLength; ) {\n                            if (task = taskQueue[nextIndexToProcess++]) {\n                                if (nextIndexToProcess > mark) {\n                                    if (++countMarks >= 5000) {\n                                        nextIndexToProcess = taskQueueLength;   // skip all tasks remaining in the queue since any of them could be causing the recursion\n                                        ko.utils.deferError(Error(\"'Too much recursion' after processing \" + countMarks + \" task groups.\"));\n                                        break;\n                                    }\n                                    mark = taskQueueLength;\n                                }\n                                try {\n                                    task();\n                                } catch (ex) {\n                                    ko.utils.deferError(ex);\n                                }\n                            }\n                        }\n                    }\n                }\n\n                function scheduledProcess() {\n                    processTasks();\n\n                    // Reset the queue\n                    nextIndexToProcess = taskQueueLength = taskQueue.length = 0;\n                }\n\n                function scheduleTaskProcessing() {\n                    ko.tasks['scheduler'](scheduledProcess);\n                }\n\n                var tasks = {\n                    'scheduler': scheduler,     // Allow overriding the scheduler\n\n                    schedule: function (func) {\n                        if (!taskQueueLength) {\n                            scheduleTaskProcessing();\n                        }\n\n                        taskQueue[taskQueueLength++] = func;\n                        return nextHandle++;\n                    },\n\n                    cancel: function (handle) {\n                        var index = handle - (nextHandle - taskQueueLength);\n                        if (index >= nextIndexToProcess && index < taskQueueLength) {\n                            taskQueue[index] = null;\n                        }\n                    },\n\n                    // For testing only: reset the queue and return the previous queue length\n                    'resetForTesting': function () {\n                        var length = taskQueueLength - nextIndexToProcess;\n                        nextIndexToProcess = taskQueueLength = taskQueue.length = 0;\n                        return length;\n                    },\n\n                    runEarly: processTasks\n                };\n\n                return tasks;\n            })();\n\n            ko.exportSymbol('tasks', ko.tasks);\n            ko.exportSymbol('tasks.schedule', ko.tasks.schedule);\n//ko.exportSymbol('tasks.cancel', ko.tasks.cancel);  \"cancel\" isn't minified\n            ko.exportSymbol('tasks.runEarly', ko.tasks.runEarly);\n            ko.extenders = {\n                'throttle': function(target, timeout) {\n                    // Throttling means two things:\n\n                    // (1) For dependent observables, we throttle *evaluations* so that, no matter how fast its dependencies\n                    //     notify updates, the target doesn't re-evaluate (and hence doesn't notify) faster than a certain rate\n                    target['throttleEvaluation'] = timeout;\n\n                    // (2) For writable targets (observables, or writable dependent observables), we throttle *writes*\n                    //     so the target cannot change value synchronously or faster than a certain rate\n                    var writeTimeoutInstance = null;\n                    return ko.dependentObservable({\n                        'read': target,\n                        'write': function(value) {\n                            clearTimeout(writeTimeoutInstance);\n                            writeTimeoutInstance = ko.utils.setTimeout(function() {\n                                target(value);\n                            }, timeout);\n                        }\n                    });\n                },\n\n                'rateLimit': function(target, options) {\n                    var timeout, method, limitFunction;\n\n                    if (typeof options == 'number') {\n                        timeout = options;\n                    } else {\n                        timeout = options['timeout'];\n                        method = options['method'];\n                    }\n\n                    // rateLimit supersedes deferred updates\n                    target._deferUpdates = false;\n\n                    limitFunction = typeof method == 'function' ? method : method == 'notifyWhenChangesStop' ?  debounce : throttle;\n                    target.limit(function(callback) {\n                        return limitFunction(callback, timeout, options);\n                    });\n                },\n\n                'deferred': function(target, options) {\n                    if (options !== true) {\n                        throw new Error('The \\'deferred\\' extender only accepts the value \\'true\\', because it is not supported to turn deferral off once enabled.')\n                    }\n\n                    if (!target._deferUpdates) {\n                        target._deferUpdates = true;\n                        target.limit(function (callback) {\n                            var handle,\n                                ignoreUpdates = false;\n                            return function () {\n                                if (!ignoreUpdates) {\n                                    ko.tasks.cancel(handle);\n                                    handle = ko.tasks.schedule(callback);\n\n                                    try {\n                                        ignoreUpdates = true;\n                                        target['notifySubscribers'](undefined, 'dirty');\n                                    } finally {\n                                        ignoreUpdates = false;\n                                    }\n                                }\n                            };\n                        });\n                    }\n                },\n\n                'notify': function(target, notifyWhen) {\n                    target[\"equalityComparer\"] = notifyWhen == \"always\" ?\n                        null :  // null equalityComparer means to always notify\n                        valuesArePrimitiveAndEqual;\n                }\n            };\n\n            var primitiveTypes = { 'undefined':1, 'boolean':1, 'number':1, 'string':1 };\n            function valuesArePrimitiveAndEqual(a, b) {\n                var oldValueIsPrimitive = (a === null) || (typeof(a) in primitiveTypes);\n                return oldValueIsPrimitive ? (a === b) : false;\n            }\n\n            function throttle(callback, timeout) {\n                var timeoutInstance;\n                return function () {\n                    if (!timeoutInstance) {\n                        timeoutInstance = ko.utils.setTimeout(function () {\n                            timeoutInstance = undefined;\n                            callback();\n                        }, timeout);\n                    }\n                };\n            }\n\n            function debounce(callback, timeout) {\n                var timeoutInstance;\n                return function () {\n                    clearTimeout(timeoutInstance);\n                    timeoutInstance = ko.utils.setTimeout(callback, timeout);\n                };\n            }\n\n            function applyExtenders(requestedExtenders) {\n                var target = this;\n                if (requestedExtenders) {\n                    ko.utils.objectForEach(requestedExtenders, function(key, value) {\n                        var extenderHandler = ko.extenders[key];\n                        if (typeof extenderHandler == 'function') {\n                            target = extenderHandler(target, value) || target;\n                        }\n                    });\n                }\n                return target;\n            }\n\n            ko.exportSymbol('extenders', ko.extenders);\n\n            ko.subscription = function (target, callback, disposeCallback) {\n                this._target = target;\n                this._callback = callback;\n                this._disposeCallback = disposeCallback;\n                this._isDisposed = false;\n                this._node = null;\n                this._domNodeDisposalCallback = null;\n                ko.exportProperty(this, 'dispose', this.dispose);\n                ko.exportProperty(this, 'disposeWhenNodeIsRemoved', this.disposeWhenNodeIsRemoved);\n            };\n            ko.subscription.prototype.dispose = function () {\n                var self = this;\n                if (!self._isDisposed) {\n                    if (self._domNodeDisposalCallback) {\n                        ko.utils.domNodeDisposal.removeDisposeCallback(self._node, self._domNodeDisposalCallback);\n                    }\n                    self._isDisposed = true;\n                    self._disposeCallback();\n\n                    self._target = self._callback = self._disposeCallback = self._node = self._domNodeDisposalCallback = null;\n                }\n            };\n            ko.subscription.prototype.disposeWhenNodeIsRemoved = function (node) {\n                this._node = node;\n                ko.utils.domNodeDisposal.addDisposeCallback(node, this._domNodeDisposalCallback = this.dispose.bind(this));\n            };\n\n            ko.subscribable = function () {\n                ko.utils.setPrototypeOfOrExtend(this, ko_subscribable_fn);\n                ko_subscribable_fn.init(this);\n            }\n\n            var defaultEvent = \"change\";\n\n// Moved out of \"limit\" to avoid the extra closure\n            function limitNotifySubscribers(value, event) {\n                if (!event || event === defaultEvent) {\n                    this._limitChange(value);\n                } else if (event === 'beforeChange') {\n                    this._limitBeforeChange(value);\n                } else {\n                    this._origNotifySubscribers(value, event);\n                }\n            }\n\n            var ko_subscribable_fn = {\n                init: function(instance) {\n                    instance._subscriptions = { \"change\": [] };\n                    instance._versionNumber = 1;\n                },\n\n                subscribe: function (callback, callbackTarget, event) {\n                    var self = this;\n\n                    event = event || defaultEvent;\n                    var boundCallback = callbackTarget ? callback.bind(callbackTarget) : callback;\n\n                    var subscription = new ko.subscription(self, boundCallback, function () {\n                        ko.utils.arrayRemoveItem(self._subscriptions[event], subscription);\n                        if (self.afterSubscriptionRemove)\n                            self.afterSubscriptionRemove(event);\n                    });\n\n                    if (self.beforeSubscriptionAdd)\n                        self.beforeSubscriptionAdd(event);\n\n                    if (!self._subscriptions[event])\n                        self._subscriptions[event] = [];\n                    self._subscriptions[event].push(subscription);\n\n                    return subscription;\n                },\n\n                \"notifySubscribers\": function (valueToNotify, event) {\n                    event = event || defaultEvent;\n                    if (event === defaultEvent) {\n                        this.updateVersion();\n                    }\n                    if (this.hasSubscriptionsForEvent(event)) {\n                        var subs = event === defaultEvent && this._changeSubscriptions || this._subscriptions[event].slice(0);\n                        try {\n                            ko.dependencyDetection.begin(); // Begin suppressing dependency detection (by setting the top frame to undefined)\n                            for (var i = 0, subscription; subscription = subs[i]; ++i) {\n                                // In case a subscription was disposed during the arrayForEach cycle, check\n                                // for isDisposed on each subscription before invoking its callback\n                                if (!subscription._isDisposed)\n                                    subscription._callback(valueToNotify);\n                            }\n                        } finally {\n                            ko.dependencyDetection.end(); // End suppressing dependency detection\n                        }\n                    }\n                },\n\n                getVersion: function () {\n                    return this._versionNumber;\n                },\n\n                hasChanged: function (versionToCheck) {\n                    return this.getVersion() !== versionToCheck;\n                },\n\n                updateVersion: function () {\n                    ++this._versionNumber;\n                },\n\n                limit: function(limitFunction) {\n                    var self = this, selfIsObservable = ko.isObservable(self),\n                        ignoreBeforeChange, notifyNextChange, previousValue, pendingValue, didUpdate,\n                        beforeChange = 'beforeChange';\n\n                    if (!self._origNotifySubscribers) {\n                        self._origNotifySubscribers = self[\"notifySubscribers\"];\n                        self[\"notifySubscribers\"] = limitNotifySubscribers;\n                    }\n\n                    var finish = limitFunction(function() {\n                        self._notificationIsPending = false;\n\n                        // If an observable provided a reference to itself, access it to get the latest value.\n                        // This allows computed observables to delay calculating their value until needed.\n                        if (selfIsObservable && pendingValue === self) {\n                            pendingValue = self._evalIfChanged ? self._evalIfChanged() : self();\n                        }\n                        var shouldNotify = notifyNextChange || (didUpdate && self.isDifferent(previousValue, pendingValue));\n\n                        didUpdate = notifyNextChange = ignoreBeforeChange = false;\n\n                        if (shouldNotify) {\n                            self._origNotifySubscribers(previousValue = pendingValue);\n                        }\n                    });\n\n                    self._limitChange = function(value, isDirty) {\n                        if (!isDirty || !self._notificationIsPending) {\n                            didUpdate = !isDirty;\n                        }\n                        self._changeSubscriptions = self._subscriptions[defaultEvent].slice(0);\n                        self._notificationIsPending = ignoreBeforeChange = true;\n                        pendingValue = value;\n                        finish();\n                    };\n                    self._limitBeforeChange = function(value) {\n                        if (!ignoreBeforeChange) {\n                            previousValue = value;\n                            self._origNotifySubscribers(value, beforeChange);\n                        }\n                    };\n                    self._recordUpdate = function() {\n                        didUpdate = true;\n                    };\n                    self._notifyNextChangeIfValueIsDifferent = function() {\n                        if (self.isDifferent(previousValue, self.peek(true /*evaluate*/))) {\n                            notifyNextChange = true;\n                        }\n                    };\n                },\n\n                hasSubscriptionsForEvent: function(event) {\n                    return this._subscriptions[event] && this._subscriptions[event].length;\n                },\n\n                getSubscriptionsCount: function (event) {\n                    if (event) {\n                        return this._subscriptions[event] && this._subscriptions[event].length || 0;\n                    } else {\n                        var total = 0;\n                        ko.utils.objectForEach(this._subscriptions, function(eventName, subscriptions) {\n                            if (eventName !== 'dirty')\n                                total += subscriptions.length;\n                        });\n                        return total;\n                    }\n                },\n\n                isDifferent: function(oldValue, newValue) {\n                    return !this['equalityComparer'] || !this['equalityComparer'](oldValue, newValue);\n                },\n\n                toString: function() {\n                    return '[object Object]'\n                },\n\n                extend: applyExtenders\n            };\n\n            ko.exportProperty(ko_subscribable_fn, 'init', ko_subscribable_fn.init);\n            ko.exportProperty(ko_subscribable_fn, 'subscribe', ko_subscribable_fn.subscribe);\n            ko.exportProperty(ko_subscribable_fn, 'extend', ko_subscribable_fn.extend);\n            ko.exportProperty(ko_subscribable_fn, 'getSubscriptionsCount', ko_subscribable_fn.getSubscriptionsCount);\n\n// For browsers that support proto assignment, we overwrite the prototype of each\n// observable instance. Since observables are functions, we need Function.prototype\n// to still be in the prototype chain.\n            if (ko.utils.canSetPrototype) {\n                ko.utils.setPrototypeOf(ko_subscribable_fn, Function.prototype);\n            }\n\n            ko.subscribable['fn'] = ko_subscribable_fn;\n\n\n            ko.isSubscribable = function (instance) {\n                return instance != null && typeof instance.subscribe == \"function\" && typeof instance[\"notifySubscribers\"] == \"function\";\n            };\n\n            ko.exportSymbol('subscribable', ko.subscribable);\n            ko.exportSymbol('isSubscribable', ko.isSubscribable);\n\n            ko.computedContext = ko.dependencyDetection = (function () {\n                var outerFrames = [],\n                    currentFrame,\n                    lastId = 0;\n\n                // Return a unique ID that can be assigned to an observable for dependency tracking.\n                // Theoretically, you could eventually overflow the number storage size, resulting\n                // in duplicate IDs. But in JavaScript, the largest exact integral value is 2^53\n                // or 9,007,199,254,740,992. If you created 1,000,000 IDs per second, it would\n                // take over 285 years to reach that number.\n                // Reference http://blog.vjeux.com/2010/javascript/javascript-max_int-number-limits.html\n                function getId() {\n                    return ++lastId;\n                }\n\n                function begin(options) {\n                    outerFrames.push(currentFrame);\n                    currentFrame = options;\n                }\n\n                function end() {\n                    currentFrame = outerFrames.pop();\n                }\n\n                return {\n                    begin: begin,\n\n                    end: end,\n\n                    registerDependency: function (subscribable) {\n                        if (currentFrame) {\n                            if (!ko.isSubscribable(subscribable))\n                                throw new Error(\"Only subscribable things can act as dependencies\");\n                            currentFrame.callback.call(currentFrame.callbackTarget, subscribable, subscribable._id || (subscribable._id = getId()));\n                        }\n                    },\n\n                    ignore: function (callback, callbackTarget, callbackArgs) {\n                        try {\n                            begin();\n                            return callback.apply(callbackTarget, callbackArgs || []);\n                        } finally {\n                            end();\n                        }\n                    },\n\n                    getDependenciesCount: function () {\n                        if (currentFrame)\n                            return currentFrame.computed.getDependenciesCount();\n                    },\n\n                    getDependencies: function () {\n                        if (currentFrame)\n                            return currentFrame.computed.getDependencies();\n                    },\n\n                    isInitial: function() {\n                        if (currentFrame)\n                            return currentFrame.isInitial;\n                    },\n\n                    computed: function() {\n                        if (currentFrame)\n                            return currentFrame.computed;\n                    }\n                };\n            })();\n\n            ko.exportSymbol('computedContext', ko.computedContext);\n            ko.exportSymbol('computedContext.getDependenciesCount', ko.computedContext.getDependenciesCount);\n            ko.exportSymbol('computedContext.getDependencies', ko.computedContext.getDependencies);\n            ko.exportSymbol('computedContext.isInitial', ko.computedContext.isInitial);\n            ko.exportSymbol('computedContext.registerDependency', ko.computedContext.registerDependency);\n\n            ko.exportSymbol('ignoreDependencies', ko.ignoreDependencies = ko.dependencyDetection.ignore);\n            var observableLatestValue = ko.utils.createSymbolOrString('_latestValue');\n\n            ko.observable = function (initialValue) {\n                function observable() {\n                    if (arguments.length > 0) {\n                        // Write\n\n                        // Ignore writes if the value hasn't changed\n                        if (observable.isDifferent(observable[observableLatestValue], arguments[0])) {\n                            observable.valueWillMutate();\n                            observable[observableLatestValue] = arguments[0];\n                            observable.valueHasMutated();\n                        }\n                        return this; // Permits chained assignments\n                    }\n                    else {\n                        // Read\n                        ko.dependencyDetection.registerDependency(observable); // The caller only needs to be notified of changes if they did a \"read\" operation\n                        return observable[observableLatestValue];\n                    }\n                }\n\n                observable[observableLatestValue] = initialValue;\n\n                // Inherit from 'subscribable'\n                if (!ko.utils.canSetPrototype) {\n                    // 'subscribable' won't be on the prototype chain unless we put it there directly\n                    ko.utils.extend(observable, ko.subscribable['fn']);\n                }\n                ko.subscribable['fn'].init(observable);\n\n                // Inherit from 'observable'\n                ko.utils.setPrototypeOfOrExtend(observable, observableFn);\n\n                if (ko.options['deferUpdates']) {\n                    ko.extenders['deferred'](observable, true);\n                }\n\n                return observable;\n            }\n\n// Define prototype for observables\n            var observableFn = {\n                'equalityComparer': valuesArePrimitiveAndEqual,\n                peek: function() { return this[observableLatestValue]; },\n                valueHasMutated: function () {\n                    this['notifySubscribers'](this[observableLatestValue], 'spectate');\n                    this['notifySubscribers'](this[observableLatestValue]);\n                },\n                valueWillMutate: function () { this['notifySubscribers'](this[observableLatestValue], 'beforeChange'); }\n            };\n\n// Note that for browsers that don't support proto assignment, the\n// inheritance chain is created manually in the ko.observable constructor\n            if (ko.utils.canSetPrototype) {\n                ko.utils.setPrototypeOf(observableFn, ko.subscribable['fn']);\n            }\n\n            var protoProperty = ko.observable.protoProperty = '__ko_proto__';\n            observableFn[protoProperty] = ko.observable;\n\n            ko.isObservable = function (instance) {\n                var proto = typeof instance == 'function' && instance[protoProperty];\n                if (proto && proto !== observableFn[protoProperty] && proto !== ko.computed['fn'][protoProperty]) {\n                    throw Error(\"Invalid object that looks like an observable; possibly from another Knockout instance\");\n                }\n                return !!proto;\n            };\n\n            ko.isWriteableObservable = function (instance) {\n                return (typeof instance == 'function' && (\n                    (instance[protoProperty] === observableFn[protoProperty]) ||  // Observable\n                    (instance[protoProperty] === ko.computed['fn'][protoProperty] && instance.hasWriteFunction)));   // Writable computed observable\n            };\n\n            ko.exportSymbol('observable', ko.observable);\n            ko.exportSymbol('isObservable', ko.isObservable);\n            ko.exportSymbol('isWriteableObservable', ko.isWriteableObservable);\n            ko.exportSymbol('isWritableObservable', ko.isWriteableObservable);\n            ko.exportSymbol('observable.fn', observableFn);\n            ko.exportProperty(observableFn, 'peek', observableFn.peek);\n            ko.exportProperty(observableFn, 'valueHasMutated', observableFn.valueHasMutated);\n            ko.exportProperty(observableFn, 'valueWillMutate', observableFn.valueWillMutate);\n            ko.observableArray = function (initialValues) {\n                initialValues = initialValues || [];\n\n                if (typeof initialValues != 'object' || !('length' in initialValues))\n                    throw new Error(\"The argument passed when initializing an observable array must be an array, or null, or undefined.\");\n\n                var result = ko.observable(initialValues);\n                ko.utils.setPrototypeOfOrExtend(result, ko.observableArray['fn']);\n                return result.extend({'trackArrayChanges':true});\n            };\n\n            ko.observableArray['fn'] = {\n                'remove': function (valueOrPredicate) {\n                    var underlyingArray = this.peek();\n                    var removedValues = [];\n                    var predicate = typeof valueOrPredicate == \"function\" && !ko.isObservable(valueOrPredicate) ? valueOrPredicate : function (value) { return value === valueOrPredicate; };\n                    for (var i = 0; i < underlyingArray.length; i++) {\n                        var value = underlyingArray[i];\n                        if (predicate(value)) {\n                            if (removedValues.length === 0) {\n                                this.valueWillMutate();\n                            }\n                            if (underlyingArray[i] !== value) {\n                                throw Error(\"Array modified during remove; cannot remove item\");\n                            }\n                            removedValues.push(value);\n                            underlyingArray.splice(i, 1);\n                            i--;\n                        }\n                    }\n                    if (removedValues.length) {\n                        this.valueHasMutated();\n                    }\n                    return removedValues;\n                },\n\n                'removeAll': function (arrayOfValues) {\n                    // If you passed zero args, we remove everything\n                    if (arrayOfValues === undefined) {\n                        var underlyingArray = this.peek();\n                        var allValues = underlyingArray.slice(0);\n                        this.valueWillMutate();\n                        underlyingArray.splice(0, underlyingArray.length);\n                        this.valueHasMutated();\n                        return allValues;\n                    }\n                    // If you passed an arg, we interpret it as an array of entries to remove\n                    if (!arrayOfValues)\n                        return [];\n                    return this['remove'](function (value) {\n                        return ko.utils.arrayIndexOf(arrayOfValues, value) >= 0;\n                    });\n                },\n\n                'destroy': function (valueOrPredicate) {\n                    var underlyingArray = this.peek();\n                    var predicate = typeof valueOrPredicate == \"function\" && !ko.isObservable(valueOrPredicate) ? valueOrPredicate : function (value) { return value === valueOrPredicate; };\n                    this.valueWillMutate();\n                    for (var i = underlyingArray.length - 1; i >= 0; i--) {\n                        var value = underlyingArray[i];\n                        if (predicate(value))\n                            value[\"_destroy\"] = true;\n                    }\n                    this.valueHasMutated();\n                },\n\n                'destroyAll': function (arrayOfValues) {\n                    // If you passed zero args, we destroy everything\n                    if (arrayOfValues === undefined)\n                        return this['destroy'](function() { return true });\n\n                    // If you passed an arg, we interpret it as an array of entries to destroy\n                    if (!arrayOfValues)\n                        return [];\n                    return this['destroy'](function (value) {\n                        return ko.utils.arrayIndexOf(arrayOfValues, value) >= 0;\n                    });\n                },\n\n                'indexOf': function (item) {\n                    var underlyingArray = this();\n                    return ko.utils.arrayIndexOf(underlyingArray, item);\n                },\n\n                'replace': function(oldItem, newItem) {\n                    var index = this['indexOf'](oldItem);\n                    if (index >= 0) {\n                        this.valueWillMutate();\n                        this.peek()[index] = newItem;\n                        this.valueHasMutated();\n                    }\n                },\n\n                'sorted': function (compareFunction) {\n                    var arrayCopy = this().slice(0);\n                    return compareFunction ? arrayCopy.sort(compareFunction) : arrayCopy.sort();\n                },\n\n                'reversed': function () {\n                    return this().slice(0).reverse();\n                }\n            };\n\n// Note that for browsers that don't support proto assignment, the\n// inheritance chain is created manually in the ko.observableArray constructor\n            if (ko.utils.canSetPrototype) {\n                ko.utils.setPrototypeOf(ko.observableArray['fn'], ko.observable['fn']);\n            }\n\n// Populate ko.observableArray.fn with read/write functions from native arrays\n// Important: Do not add any additional functions here that may reasonably be used to *read* data from the array\n// because we'll eval them without causing subscriptions, so ko.computed output could end up getting stale\n            ko.utils.arrayForEach([\"pop\", \"push\", \"reverse\", \"shift\", \"sort\", \"splice\", \"unshift\"], function (methodName) {\n                ko.observableArray['fn'][methodName] = function () {\n                    // Use \"peek\" to avoid creating a subscription in any computed that we're executing in the context of\n                    // (for consistency with mutating regular observables)\n                    var underlyingArray = this.peek();\n                    this.valueWillMutate();\n                    this.cacheDiffForKnownOperation(underlyingArray, methodName, arguments);\n                    var methodCallResult = underlyingArray[methodName].apply(underlyingArray, arguments);\n                    this.valueHasMutated();\n                    // The native sort and reverse methods return a reference to the array, but it makes more sense to return the observable array instead.\n                    return methodCallResult === underlyingArray ? this : methodCallResult;\n                };\n            });\n\n// Populate ko.observableArray.fn with read-only functions from native arrays\n            ko.utils.arrayForEach([\"slice\"], function (methodName) {\n                ko.observableArray['fn'][methodName] = function () {\n                    var underlyingArray = this();\n                    return underlyingArray[methodName].apply(underlyingArray, arguments);\n                };\n            });\n\n            ko.isObservableArray = function (instance) {\n                return ko.isObservable(instance)\n                    && typeof instance[\"remove\"] == \"function\"\n                    && typeof instance[\"push\"] == \"function\";\n            };\n\n            ko.exportSymbol('observableArray', ko.observableArray);\n            ko.exportSymbol('isObservableArray', ko.isObservableArray);\n            var arrayChangeEventName = 'arrayChange';\n            ko.extenders['trackArrayChanges'] = function(target, options) {\n                // Use the provided options--each call to trackArrayChanges overwrites the previously set options\n                target.compareArrayOptions = {};\n                if (options && typeof options == \"object\") {\n                    ko.utils.extend(target.compareArrayOptions, options);\n                }\n                target.compareArrayOptions['sparse'] = true;\n\n                // Only modify the target observable once\n                if (target.cacheDiffForKnownOperation) {\n                    return;\n                }\n                var trackingChanges = false,\n                    cachedDiff = null,\n                    changeSubscription,\n                    spectateSubscription,\n                    pendingChanges = 0,\n                    previousContents,\n                    underlyingBeforeSubscriptionAddFunction = target.beforeSubscriptionAdd,\n                    underlyingAfterSubscriptionRemoveFunction = target.afterSubscriptionRemove;\n\n                // Watch \"subscribe\" calls, and for array change events, ensure change tracking is enabled\n                target.beforeSubscriptionAdd = function (event) {\n                    if (underlyingBeforeSubscriptionAddFunction) {\n                        underlyingBeforeSubscriptionAddFunction.call(target, event);\n                    }\n                    if (event === arrayChangeEventName) {\n                        trackChanges();\n                    }\n                };\n                // Watch \"dispose\" calls, and for array change events, ensure change tracking is disabled when all are disposed\n                target.afterSubscriptionRemove = function (event) {\n                    if (underlyingAfterSubscriptionRemoveFunction) {\n                        underlyingAfterSubscriptionRemoveFunction.call(target, event);\n                    }\n                    if (event === arrayChangeEventName && !target.hasSubscriptionsForEvent(arrayChangeEventName)) {\n                        if (changeSubscription) {\n                            changeSubscription.dispose();\n                        }\n                        if (spectateSubscription) {\n                            spectateSubscription.dispose();\n                        }\n                        spectateSubscription = changeSubscription = null;\n                        trackingChanges = false;\n                        previousContents = undefined;\n                    }\n                };\n\n                function trackChanges() {\n                    if (trackingChanges) {\n                        // Whenever there's a new subscription and there are pending notifications, make sure all previous\n                        // subscriptions are notified of the change so that all subscriptions are in sync.\n                        notifyChanges();\n                        return;\n                    }\n\n                    trackingChanges = true;\n\n                    // Track how many times the array actually changed value\n                    spectateSubscription = target.subscribe(function () {\n                        ++pendingChanges;\n                    }, null, \"spectate\");\n\n                    // Each time the array changes value, capture a clone so that on the next\n                    // change it's possible to produce a diff\n                    previousContents = [].concat(target.peek() || []);\n                    cachedDiff = null;\n                    changeSubscription = target.subscribe(notifyChanges);\n\n                    function notifyChanges() {\n                        if (pendingChanges) {\n                            // Make a copy of the current contents and ensure it's an array\n                            var currentContents = [].concat(target.peek() || []), changes;\n\n                            // Compute the diff and issue notifications, but only if someone is listening\n                            if (target.hasSubscriptionsForEvent(arrayChangeEventName)) {\n                                changes = getChanges(previousContents, currentContents);\n                            }\n\n                            // Eliminate references to the old, removed items, so they can be GCed\n                            previousContents = currentContents;\n                            cachedDiff = null;\n                            pendingChanges = 0;\n\n                            if (changes && changes.length) {\n                                target['notifySubscribers'](changes, arrayChangeEventName);\n                            }\n                        }\n                    }\n                }\n\n                function getChanges(previousContents, currentContents) {\n                    // We try to re-use cached diffs.\n                    // The scenarios where pendingChanges > 1 are when using rate limiting or deferred updates,\n                    // which without this check would not be compatible with arrayChange notifications. Normally,\n                    // notifications are issued immediately so we wouldn't be queueing up more than one.\n                    if (!cachedDiff || pendingChanges > 1) {\n                        cachedDiff = ko.utils.compareArrays(previousContents, currentContents, target.compareArrayOptions);\n                    }\n\n                    return cachedDiff;\n                }\n\n                target.cacheDiffForKnownOperation = function(rawArray, operationName, args) {\n                    // Only run if we're currently tracking changes for this observable array\n                    // and there aren't any pending deferred notifications.\n                    if (!trackingChanges || pendingChanges) {\n                        return;\n                    }\n                    var diff = [],\n                        arrayLength = rawArray.length,\n                        argsLength = args.length,\n                        offset = 0;\n\n                    function pushDiff(status, value, index) {\n                        return diff[diff.length] = { 'status': status, 'value': value, 'index': index };\n                    }\n                    switch (operationName) {\n                        case 'push':\n                            offset = arrayLength;\n                        case 'unshift':\n                            for (var index = 0; index < argsLength; index++) {\n                                pushDiff('added', args[index], offset + index);\n                            }\n                            break;\n\n                        case 'pop':\n                            offset = arrayLength - 1;\n                        case 'shift':\n                            if (arrayLength) {\n                                pushDiff('deleted', rawArray[offset], offset);\n                            }\n                            break;\n\n                        case 'splice':\n                            // Negative start index means 'from end of array'. After that we clamp to [0...arrayLength].\n                            // See https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/splice\n                            var startIndex = Math.min(Math.max(0, args[0] < 0 ? arrayLength + args[0] : args[0]), arrayLength),\n                                endDeleteIndex = argsLength === 1 ? arrayLength : Math.min(startIndex + (args[1] || 0), arrayLength),\n                                endAddIndex = startIndex + argsLength - 2,\n                                endIndex = Math.max(endDeleteIndex, endAddIndex),\n                                additions = [], deletions = [];\n                            for (var index = startIndex, argsIndex = 2; index < endIndex; ++index, ++argsIndex) {\n                                if (index < endDeleteIndex)\n                                    deletions.push(pushDiff('deleted', rawArray[index], index));\n                                if (index < endAddIndex)\n                                    additions.push(pushDiff('added', args[argsIndex], index));\n                            }\n                            ko.utils.findMovesInArrayComparison(deletions, additions);\n                            break;\n\n                        default:\n                            return;\n                    }\n                    cachedDiff = diff;\n                };\n            };\n            var computedState = ko.utils.createSymbolOrString('_state');\n\n            ko.computed = ko.dependentObservable = function (evaluatorFunctionOrOptions, evaluatorFunctionTarget, options) {\n                if (typeof evaluatorFunctionOrOptions === \"object\") {\n                    // Single-parameter syntax - everything is on this \"options\" param\n                    options = evaluatorFunctionOrOptions;\n                } else {\n                    // Multi-parameter syntax - construct the options according to the params passed\n                    options = options || {};\n                    if (evaluatorFunctionOrOptions) {\n                        options[\"read\"] = evaluatorFunctionOrOptions;\n                    }\n                }\n                if (typeof options[\"read\"] != \"function\")\n                    throw Error(\"Pass a function that returns the value of the ko.computed\");\n\n                var writeFunction = options[\"write\"];\n                var state = {\n                    latestValue: undefined,\n                    isStale: true,\n                    isDirty: true,\n                    isBeingEvaluated: false,\n                    suppressDisposalUntilDisposeWhenReturnsFalse: false,\n                    isDisposed: false,\n                    pure: false,\n                    isSleeping: false,\n                    readFunction: options[\"read\"],\n                    evaluatorFunctionTarget: evaluatorFunctionTarget || options[\"owner\"],\n                    disposeWhenNodeIsRemoved: options[\"disposeWhenNodeIsRemoved\"] || options.disposeWhenNodeIsRemoved || null,\n                    disposeWhen: options[\"disposeWhen\"] || options.disposeWhen,\n                    domNodeDisposalCallback: null,\n                    dependencyTracking: {},\n                    dependenciesCount: 0,\n                    evaluationTimeoutInstance: null\n                };\n\n                function computedObservable() {\n                    if (arguments.length > 0) {\n                        if (typeof writeFunction === \"function\") {\n                            // Writing a value\n                            writeFunction.apply(state.evaluatorFunctionTarget, arguments);\n                        } else {\n                            throw new Error(\"Cannot write a value to a ko.computed unless you specify a 'write' option. If you wish to read the current value, don't pass any parameters.\");\n                        }\n                        return this; // Permits chained assignments\n                    } else {\n                        // Reading the value\n                        if (!state.isDisposed) {\n                            ko.dependencyDetection.registerDependency(computedObservable);\n                        }\n                        if (state.isDirty || (state.isSleeping && computedObservable.haveDependenciesChanged())) {\n                            computedObservable.evaluateImmediate();\n                        }\n                        return state.latestValue;\n                    }\n                }\n\n                computedObservable[computedState] = state;\n                computedObservable.hasWriteFunction = typeof writeFunction === \"function\";\n\n                // Inherit from 'subscribable'\n                if (!ko.utils.canSetPrototype) {\n                    // 'subscribable' won't be on the prototype chain unless we put it there directly\n                    ko.utils.extend(computedObservable, ko.subscribable['fn']);\n                }\n                ko.subscribable['fn'].init(computedObservable);\n\n                // Inherit from 'computed'\n                ko.utils.setPrototypeOfOrExtend(computedObservable, computedFn);\n\n                if (options['pure']) {\n                    state.pure = true;\n                    state.isSleeping = true;     // Starts off sleeping; will awake on the first subscription\n                    ko.utils.extend(computedObservable, pureComputedOverrides);\n                } else if (options['deferEvaluation']) {\n                    ko.utils.extend(computedObservable, deferEvaluationOverrides);\n                }\n\n                if (ko.options['deferUpdates']) {\n                    ko.extenders['deferred'](computedObservable, true);\n                }\n\n                if (DEBUG) {\n                    // #1731 - Aid debugging by exposing the computed's options\n                    computedObservable[\"_options\"] = options;\n                }\n\n                if (state.disposeWhenNodeIsRemoved) {\n                    // Since this computed is associated with a DOM node, and we don't want to dispose the computed\n                    // until the DOM node is *removed* from the document (as opposed to never having been in the document),\n                    // we'll prevent disposal until \"disposeWhen\" first returns false.\n                    state.suppressDisposalUntilDisposeWhenReturnsFalse = true;\n\n                    // disposeWhenNodeIsRemoved: true can be used to opt into the \"only dispose after first false result\"\n                    // behaviour even if there's no specific node to watch. In that case, clear the option so we don't try\n                    // to watch for a non-node's disposal. This technique is intended for KO's internal use only and shouldn't\n                    // be documented or used by application code, as it's likely to change in a future version of KO.\n                    if (!state.disposeWhenNodeIsRemoved.nodeType) {\n                        state.disposeWhenNodeIsRemoved = null;\n                    }\n                }\n\n                // Evaluate, unless sleeping or deferEvaluation is true\n                if (!state.isSleeping && !options['deferEvaluation']) {\n                    computedObservable.evaluateImmediate();\n                }\n\n                // Attach a DOM node disposal callback so that the computed will be proactively disposed as soon as the node is\n                // removed using ko.removeNode. But skip if isActive is false (there will never be any dependencies to dispose).\n                if (state.disposeWhenNodeIsRemoved && computedObservable.isActive()) {\n                    ko.utils.domNodeDisposal.addDisposeCallback(state.disposeWhenNodeIsRemoved, state.domNodeDisposalCallback = function () {\n                        computedObservable.dispose();\n                    });\n                }\n\n                return computedObservable;\n            };\n\n// Utility function that disposes a given dependencyTracking entry\n            function computedDisposeDependencyCallback(id, entryToDispose) {\n                if (entryToDispose !== null && entryToDispose.dispose) {\n                    entryToDispose.dispose();\n                }\n            }\n\n// This function gets called each time a dependency is detected while evaluating a computed.\n// It's factored out as a shared function to avoid creating unnecessary function instances during evaluation.\n            function computedBeginDependencyDetectionCallback(subscribable, id) {\n                var computedObservable = this.computedObservable,\n                    state = computedObservable[computedState];\n                if (!state.isDisposed) {\n                    if (this.disposalCount && this.disposalCandidates[id]) {\n                        // Don't want to dispose this subscription, as it's still being used\n                        computedObservable.addDependencyTracking(id, subscribable, this.disposalCandidates[id]);\n                        this.disposalCandidates[id] = null; // No need to actually delete the property - disposalCandidates is a transient object anyway\n                        --this.disposalCount;\n                    } else if (!state.dependencyTracking[id]) {\n                        // Brand new subscription - add it\n                        computedObservable.addDependencyTracking(id, subscribable, state.isSleeping ? { _target: subscribable } : computedObservable.subscribeToDependency(subscribable));\n                    }\n                    // If the observable we've accessed has a pending notification, ensure we get notified of the actual final value (bypass equality checks)\n                    if (subscribable._notificationIsPending) {\n                        subscribable._notifyNextChangeIfValueIsDifferent();\n                    }\n                }\n            }\n\n            var computedFn = {\n                \"equalityComparer\": valuesArePrimitiveAndEqual,\n                getDependenciesCount: function () {\n                    return this[computedState].dependenciesCount;\n                },\n                getDependencies: function () {\n                    var dependencyTracking = this[computedState].dependencyTracking, dependentObservables = [];\n\n                    ko.utils.objectForEach(dependencyTracking, function (id, dependency) {\n                        dependentObservables[dependency._order] = dependency._target;\n                    });\n\n                    return dependentObservables;\n                },\n                hasAncestorDependency: function (obs) {\n                    if (!this[computedState].dependenciesCount) {\n                        return false;\n                    }\n                    var dependencies = this.getDependencies();\n                    if (ko.utils.arrayIndexOf(dependencies, obs) !== -1) {\n                        return true;\n                    }\n                    return !!ko.utils.arrayFirst(dependencies, function (dep) {\n                        return dep.hasAncestorDependency && dep.hasAncestorDependency(obs);\n                    });\n                },\n                addDependencyTracking: function (id, target, trackingObj) {\n                    if (this[computedState].pure && target === this) {\n                        throw Error(\"A 'pure' computed must not be called recursively\");\n                    }\n\n                    this[computedState].dependencyTracking[id] = trackingObj;\n                    trackingObj._order = this[computedState].dependenciesCount++;\n                    trackingObj._version = target.getVersion();\n                },\n                haveDependenciesChanged: function () {\n                    var id, dependency, dependencyTracking = this[computedState].dependencyTracking;\n                    for (id in dependencyTracking) {\n                        if (Object.prototype.hasOwnProperty.call(dependencyTracking, id)) {\n                            dependency = dependencyTracking[id];\n                            if ((this._evalDelayed && dependency._target._notificationIsPending) || dependency._target.hasChanged(dependency._version)) {\n                                return true;\n                            }\n                        }\n                    }\n                },\n                markDirty: function () {\n                    // Process \"dirty\" events if we can handle delayed notifications\n                    if (this._evalDelayed && !this[computedState].isBeingEvaluated) {\n                        this._evalDelayed(false /*isChange*/);\n                    }\n                },\n                isActive: function () {\n                    var state = this[computedState];\n                    return state.isDirty || state.dependenciesCount > 0;\n                },\n                respondToChange: function () {\n                    // Ignore \"change\" events if we've already scheduled a delayed notification\n                    if (!this._notificationIsPending) {\n                        this.evaluatePossiblyAsync();\n                    } else if (this[computedState].isDirty) {\n                        this[computedState].isStale = true;\n                    }\n                },\n                subscribeToDependency: function (target) {\n                    if (target._deferUpdates) {\n                        var dirtySub = target.subscribe(this.markDirty, this, 'dirty'),\n                            changeSub = target.subscribe(this.respondToChange, this);\n                        return {\n                            _target: target,\n                            dispose: function () {\n                                dirtySub.dispose();\n                                changeSub.dispose();\n                            }\n                        };\n                    } else {\n                        return target.subscribe(this.evaluatePossiblyAsync, this);\n                    }\n                },\n                evaluatePossiblyAsync: function () {\n                    var computedObservable = this,\n                        throttleEvaluationTimeout = computedObservable['throttleEvaluation'];\n                    if (throttleEvaluationTimeout && throttleEvaluationTimeout >= 0) {\n                        clearTimeout(this[computedState].evaluationTimeoutInstance);\n                        this[computedState].evaluationTimeoutInstance = ko.utils.setTimeout(function () {\n                            computedObservable.evaluateImmediate(true /*notifyChange*/);\n                        }, throttleEvaluationTimeout);\n                    } else if (computedObservable._evalDelayed) {\n                        computedObservable._evalDelayed(true /*isChange*/);\n                    } else {\n                        computedObservable.evaluateImmediate(true /*notifyChange*/);\n                    }\n                },\n                evaluateImmediate: function (notifyChange) {\n                    var computedObservable = this,\n                        state = computedObservable[computedState],\n                        disposeWhen = state.disposeWhen,\n                        changed = false;\n\n                    if (state.isBeingEvaluated) {\n                        // If the evaluation of a ko.computed causes side effects, it's possible that it will trigger its own re-evaluation.\n                        // This is not desirable (it's hard for a developer to realise a chain of dependencies might cause this, and they almost\n                        // certainly didn't intend infinite re-evaluations). So, for predictability, we simply prevent ko.computeds from causing\n                        // their own re-evaluation. Further discussion at https://github.com/SteveSanderson/knockout/pull/387\n                        return;\n                    }\n\n                    // Do not evaluate (and possibly capture new dependencies) if disposed\n                    if (state.isDisposed) {\n                        return;\n                    }\n\n                    if (state.disposeWhenNodeIsRemoved && !ko.utils.domNodeIsAttachedToDocument(state.disposeWhenNodeIsRemoved) || disposeWhen && disposeWhen()) {\n                        // See comment above about suppressDisposalUntilDisposeWhenReturnsFalse\n                        if (!state.suppressDisposalUntilDisposeWhenReturnsFalse) {\n                            computedObservable.dispose();\n                            return;\n                        }\n                    } else {\n                        // It just did return false, so we can stop suppressing now\n                        state.suppressDisposalUntilDisposeWhenReturnsFalse = false;\n                    }\n\n                    state.isBeingEvaluated = true;\n                    try {\n                        changed = this.evaluateImmediate_CallReadWithDependencyDetection(notifyChange);\n                    } finally {\n                        state.isBeingEvaluated = false;\n                    }\n\n                    return changed;\n                },\n                evaluateImmediate_CallReadWithDependencyDetection: function (notifyChange) {\n                    // This function is really just part of the evaluateImmediate logic. You would never call it from anywhere else.\n                    // Factoring it out into a separate function means it can be independent of the try/catch block in evaluateImmediate,\n                    // which contributes to saving about 40% off the CPU overhead of computed evaluation (on V8 at least).\n\n                    var computedObservable = this,\n                        state = computedObservable[computedState],\n                        changed = false;\n\n                    // Initially, we assume that none of the subscriptions are still being used (i.e., all are candidates for disposal).\n                    // Then, during evaluation, we cross off any that are in fact still being used.\n                    var isInitial = state.pure ? undefined : !state.dependenciesCount,   // If we're evaluating when there are no previous dependencies, it must be the first time\n                        dependencyDetectionContext = {\n                            computedObservable: computedObservable,\n                            disposalCandidates: state.dependencyTracking,\n                            disposalCount: state.dependenciesCount\n                        };\n\n                    ko.dependencyDetection.begin({\n                        callbackTarget: dependencyDetectionContext,\n                        callback: computedBeginDependencyDetectionCallback,\n                        computed: computedObservable,\n                        isInitial: isInitial\n                    });\n\n                    state.dependencyTracking = {};\n                    state.dependenciesCount = 0;\n\n                    var newValue = this.evaluateImmediate_CallReadThenEndDependencyDetection(state, dependencyDetectionContext);\n\n                    if (!state.dependenciesCount) {\n                        computedObservable.dispose();\n                        changed = true; // When evaluation causes a disposal, make sure all dependent computeds get notified so they'll see the new state\n                    } else {\n                        changed = computedObservable.isDifferent(state.latestValue, newValue);\n                    }\n\n                    if (changed) {\n                        if (!state.isSleeping) {\n                            computedObservable[\"notifySubscribers\"](state.latestValue, \"beforeChange\");\n                        } else {\n                            computedObservable.updateVersion();\n                        }\n\n                        state.latestValue = newValue;\n                        if (DEBUG) computedObservable._latestValue = newValue;\n\n                        computedObservable[\"notifySubscribers\"](state.latestValue, \"spectate\");\n\n                        if (!state.isSleeping && notifyChange) {\n                            computedObservable[\"notifySubscribers\"](state.latestValue);\n                        }\n                        if (computedObservable._recordUpdate) {\n                            computedObservable._recordUpdate();\n                        }\n                    }\n\n                    if (isInitial) {\n                        computedObservable[\"notifySubscribers\"](state.latestValue, \"awake\");\n                    }\n\n                    return changed;\n                },\n                evaluateImmediate_CallReadThenEndDependencyDetection: function (state, dependencyDetectionContext) {\n                    // This function is really part of the evaluateImmediate_CallReadWithDependencyDetection logic.\n                    // You'd never call it from anywhere else. Factoring it out means that evaluateImmediate_CallReadWithDependencyDetection\n                    // can be independent of try/finally blocks, which contributes to saving about 40% off the CPU\n                    // overhead of computed evaluation (on V8 at least).\n\n                    try {\n                        var readFunction = state.readFunction;\n                        return state.evaluatorFunctionTarget ? readFunction.call(state.evaluatorFunctionTarget) : readFunction();\n                    } finally {\n                        ko.dependencyDetection.end();\n\n                        // For each subscription no longer being used, remove it from the active subscriptions list and dispose it\n                        if (dependencyDetectionContext.disposalCount && !state.isSleeping) {\n                            ko.utils.objectForEach(dependencyDetectionContext.disposalCandidates, computedDisposeDependencyCallback);\n                        }\n\n                        state.isStale = state.isDirty = false;\n                    }\n                },\n                peek: function (evaluate) {\n                    // By default, peek won't re-evaluate, except while the computed is sleeping or to get the initial value when \"deferEvaluation\" is set.\n                    // Pass in true to evaluate if needed.\n                    var state = this[computedState];\n                    if ((state.isDirty && (evaluate || !state.dependenciesCount)) || (state.isSleeping && this.haveDependenciesChanged())) {\n                        this.evaluateImmediate();\n                    }\n                    return state.latestValue;\n                },\n                limit: function (limitFunction) {\n                    // Override the limit function with one that delays evaluation as well\n                    ko.subscribable['fn'].limit.call(this, limitFunction);\n                    this._evalIfChanged = function () {\n                        if (!this[computedState].isSleeping) {\n                            if (this[computedState].isStale) {\n                                this.evaluateImmediate();\n                            } else {\n                                this[computedState].isDirty = false;\n                            }\n                        }\n                        return this[computedState].latestValue;\n                    };\n                    this._evalDelayed = function (isChange) {\n                        this._limitBeforeChange(this[computedState].latestValue);\n\n                        // Mark as dirty\n                        this[computedState].isDirty = true;\n                        if (isChange) {\n                            this[computedState].isStale = true;\n                        }\n\n                        // Pass the observable to the \"limit\" code, which will evaluate it when\n                        // it's time to do the notification.\n                        this._limitChange(this, !isChange /* isDirty */);\n                    };\n                },\n                dispose: function () {\n                    var state = this[computedState];\n                    if (!state.isSleeping && state.dependencyTracking) {\n                        ko.utils.objectForEach(state.dependencyTracking, function (id, dependency) {\n                            if (dependency.dispose)\n                                dependency.dispose();\n                        });\n                    }\n                    if (state.disposeWhenNodeIsRemoved && state.domNodeDisposalCallback) {\n                        ko.utils.domNodeDisposal.removeDisposeCallback(state.disposeWhenNodeIsRemoved, state.domNodeDisposalCallback);\n                    }\n                    state.dependencyTracking = undefined;\n                    state.dependenciesCount = 0;\n                    state.isDisposed = true;\n                    state.isStale = false;\n                    state.isDirty = false;\n                    state.isSleeping = false;\n                    state.disposeWhenNodeIsRemoved = undefined;\n                    state.disposeWhen = undefined;\n                    state.readFunction = undefined;\n                    if (!this.hasWriteFunction) {\n                        state.evaluatorFunctionTarget = undefined;\n                    }\n                }\n            };\n\n            var pureComputedOverrides = {\n                beforeSubscriptionAdd: function (event) {\n                    // If asleep, wake up the computed by subscribing to any dependencies.\n                    var computedObservable = this,\n                        state = computedObservable[computedState];\n                    if (!state.isDisposed && state.isSleeping && event == 'change') {\n                        state.isSleeping = false;\n                        if (state.isStale || computedObservable.haveDependenciesChanged()) {\n                            state.dependencyTracking = null;\n                            state.dependenciesCount = 0;\n                            if (computedObservable.evaluateImmediate()) {\n                                computedObservable.updateVersion();\n                            }\n                        } else {\n                            // First put the dependencies in order\n                            var dependenciesOrder = [];\n                            ko.utils.objectForEach(state.dependencyTracking, function (id, dependency) {\n                                dependenciesOrder[dependency._order] = id;\n                            });\n                            // Next, subscribe to each one\n                            ko.utils.arrayForEach(dependenciesOrder, function (id, order) {\n                                var dependency = state.dependencyTracking[id],\n                                    subscription = computedObservable.subscribeToDependency(dependency._target);\n                                subscription._order = order;\n                                subscription._version = dependency._version;\n                                state.dependencyTracking[id] = subscription;\n                            });\n                            // Waking dependencies may have triggered effects\n                            if (computedObservable.haveDependenciesChanged()) {\n                                if (computedObservable.evaluateImmediate()) {\n                                    computedObservable.updateVersion();\n                                }\n                            }\n                        }\n\n                        if (!state.isDisposed) {     // test since evaluating could trigger disposal\n                            computedObservable[\"notifySubscribers\"](state.latestValue, \"awake\");\n                        }\n                    }\n                },\n                afterSubscriptionRemove: function (event) {\n                    var state = this[computedState];\n                    if (!state.isDisposed && event == 'change' && !this.hasSubscriptionsForEvent('change')) {\n                        ko.utils.objectForEach(state.dependencyTracking, function (id, dependency) {\n                            if (dependency.dispose) {\n                                state.dependencyTracking[id] = {\n                                    _target: dependency._target,\n                                    _order: dependency._order,\n                                    _version: dependency._version\n                                };\n                                dependency.dispose();\n                            }\n                        });\n                        state.isSleeping = true;\n                        this[\"notifySubscribers\"](undefined, \"asleep\");\n                    }\n                },\n                getVersion: function () {\n                    // Because a pure computed is not automatically updated while it is sleeping, we can't\n                    // simply return the version number. Instead, we check if any of the dependencies have\n                    // changed and conditionally re-evaluate the computed observable.\n                    var state = this[computedState];\n                    if (state.isSleeping && (state.isStale || this.haveDependenciesChanged())) {\n                        this.evaluateImmediate();\n                    }\n                    return ko.subscribable['fn'].getVersion.call(this);\n                }\n            };\n\n            var deferEvaluationOverrides = {\n                beforeSubscriptionAdd: function (event) {\n                    // This will force a computed with deferEvaluation to evaluate when the first subscription is registered.\n                    if (event == 'change' || event == 'beforeChange') {\n                        this.peek();\n                    }\n                }\n            };\n\n// Note that for browsers that don't support proto assignment, the\n// inheritance chain is created manually in the ko.computed constructor\n            if (ko.utils.canSetPrototype) {\n                ko.utils.setPrototypeOf(computedFn, ko.subscribable['fn']);\n            }\n\n// Set the proto values for ko.computed\n            var protoProp = ko.observable.protoProperty; // == \"__ko_proto__\"\n            computedFn[protoProp] = ko.computed;\n\n            ko.isComputed = function (instance) {\n                return (typeof instance == 'function' && instance[protoProp] === computedFn[protoProp]);\n            };\n\n            ko.isPureComputed = function (instance) {\n                return ko.isComputed(instance) && instance[computedState] && instance[computedState].pure;\n            };\n\n            ko.exportSymbol('computed', ko.computed);\n            ko.exportSymbol('dependentObservable', ko.computed);    // export ko.dependentObservable for backwards compatibility (1.x)\n            ko.exportSymbol('isComputed', ko.isComputed);\n            ko.exportSymbol('isPureComputed', ko.isPureComputed);\n            ko.exportSymbol('computed.fn', computedFn);\n            ko.exportProperty(computedFn, 'peek', computedFn.peek);\n            ko.exportProperty(computedFn, 'dispose', computedFn.dispose);\n            ko.exportProperty(computedFn, 'isActive', computedFn.isActive);\n            ko.exportProperty(computedFn, 'getDependenciesCount', computedFn.getDependenciesCount);\n            ko.exportProperty(computedFn, 'getDependencies', computedFn.getDependencies);\n\n            ko.pureComputed = function (evaluatorFunctionOrOptions, evaluatorFunctionTarget) {\n                if (typeof evaluatorFunctionOrOptions === 'function') {\n                    return ko.computed(evaluatorFunctionOrOptions, evaluatorFunctionTarget, {'pure':true});\n                } else {\n                    evaluatorFunctionOrOptions = ko.utils.extend({}, evaluatorFunctionOrOptions);   // make a copy of the parameter object\n                    evaluatorFunctionOrOptions['pure'] = true;\n                    return ko.computed(evaluatorFunctionOrOptions, evaluatorFunctionTarget);\n                }\n            }\n            ko.exportSymbol('pureComputed', ko.pureComputed);\n\n            (function() {\n                var maxNestedObservableDepth = 10; // Escape the (unlikely) pathological case where an observable's current value is itself (or similar reference cycle)\n\n                ko.toJS = function(rootObject) {\n                    if (arguments.length == 0)\n                        throw new Error(\"When calling ko.toJS, pass the object you want to convert.\");\n\n                    // We just unwrap everything at every level in the object graph\n                    return mapJsObjectGraph(rootObject, function(valueToMap) {\n                        // Loop because an observable's value might in turn be another observable wrapper\n                        for (var i = 0; ko.isObservable(valueToMap) && (i < maxNestedObservableDepth); i++)\n                            valueToMap = valueToMap();\n                        return valueToMap;\n                    });\n                };\n\n                ko.toJSON = function(rootObject, replacer, space) {     // replacer and space are optional\n                    var plainJavaScriptObject = ko.toJS(rootObject);\n                    return ko.utils.stringifyJson(plainJavaScriptObject, replacer, space);\n                };\n\n                function mapJsObjectGraph(rootObject, mapInputCallback, visitedObjects) {\n                    visitedObjects = visitedObjects || new objectLookup();\n\n                    rootObject = mapInputCallback(rootObject);\n                    var canHaveProperties = (typeof rootObject == \"object\") && (rootObject !== null) && (rootObject !== undefined) && (!(rootObject instanceof RegExp)) && (!(rootObject instanceof Date)) && (!(rootObject instanceof String)) && (!(rootObject instanceof Number)) && (!(rootObject instanceof Boolean));\n                    if (!canHaveProperties)\n                        return rootObject;\n\n                    var outputProperties = rootObject instanceof Array ? [] : {};\n                    visitedObjects.save(rootObject, outputProperties);\n\n                    visitPropertiesOrArrayEntries(rootObject, function(indexer) {\n                        var propertyValue = mapInputCallback(rootObject[indexer]);\n\n                        switch (typeof propertyValue) {\n                            case \"boolean\":\n                            case \"number\":\n                            case \"string\":\n                            case \"function\":\n                                outputProperties[indexer] = propertyValue;\n                                break;\n                            case \"object\":\n                            case \"undefined\":\n                                var previouslyMappedValue = visitedObjects.get(propertyValue);\n                                outputProperties[indexer] = (previouslyMappedValue !== undefined)\n                                    ? previouslyMappedValue\n                                    : mapJsObjectGraph(propertyValue, mapInputCallback, visitedObjects);\n                                break;\n                        }\n                    });\n\n                    return outputProperties;\n                }\n\n                function visitPropertiesOrArrayEntries(rootObject, visitorCallback) {\n                    if (rootObject instanceof Array) {\n                        for (var i = 0; i < rootObject.length; i++)\n                            visitorCallback(i);\n\n                        // For arrays, also respect toJSON property for custom mappings (fixes #278)\n                        if (typeof rootObject['toJSON'] == 'function')\n                            visitorCallback('toJSON');\n                    } else {\n                        for (var propertyName in rootObject) {\n                            visitorCallback(propertyName);\n                        }\n                    }\n                };\n\n                function objectLookup() {\n                    this.keys = [];\n                    this.values = [];\n                };\n\n                objectLookup.prototype = {\n                    constructor: objectLookup,\n                    save: function(key, value) {\n                        var existingIndex = ko.utils.arrayIndexOf(this.keys, key);\n                        if (existingIndex >= 0)\n                            this.values[existingIndex] = value;\n                        else {\n                            this.keys.push(key);\n                            this.values.push(value);\n                        }\n                    },\n                    get: function(key) {\n                        var existingIndex = ko.utils.arrayIndexOf(this.keys, key);\n                        return (existingIndex >= 0) ? this.values[existingIndex] : undefined;\n                    }\n                };\n            })();\n\n            ko.exportSymbol('toJS', ko.toJS);\n            ko.exportSymbol('toJSON', ko.toJSON);\n            ko.when = function(predicate, callback, context) {\n                function kowhen (resolve) {\n                    var observable = ko.pureComputed(predicate, context).extend({notify:'always'});\n                    var subscription = observable.subscribe(function(value) {\n                        if (value) {\n                            subscription.dispose();\n                            resolve(value);\n                        }\n                    });\n                    // In case the initial value is true, process it right away\n                    observable['notifySubscribers'](observable.peek());\n\n                    return subscription;\n                }\n                if (typeof Promise === \"function\" && !callback) {\n                    return new Promise(kowhen);\n                } else {\n                    return kowhen(callback.bind(context));\n                }\n            };\n\n            ko.exportSymbol('when', ko.when);\n            (function () {\n                var hasDomDataExpandoProperty = '__ko__hasDomDataOptionValue__';\n\n                // Normally, SELECT elements and their OPTIONs can only take value of type 'string' (because the values\n                // are stored on DOM attributes). ko.selectExtensions provides a way for SELECTs/OPTIONs to have values\n                // that are arbitrary objects. This is very convenient when implementing things like cascading dropdowns.\n                ko.selectExtensions = {\n                    readValue : function(element) {\n                        switch (ko.utils.tagNameLower(element)) {\n                            case 'option':\n                                if (element[hasDomDataExpandoProperty] === true)\n                                    return ko.utils.domData.get(element, ko.bindingHandlers.options.optionValueDomDataKey);\n                                return ko.utils.ieVersion <= 7\n                                    ? (element.getAttributeNode('value') && element.getAttributeNode('value').specified ? element.value : element.text)\n                                    : element.value;\n                            case 'select':\n                                return element.selectedIndex >= 0 ? ko.selectExtensions.readValue(element.options[element.selectedIndex]) : undefined;\n                            default:\n                                return element.value;\n                        }\n                    },\n\n                    writeValue: function(element, value, allowUnset) {\n                        switch (ko.utils.tagNameLower(element)) {\n                            case 'option':\n                                if (typeof value === \"string\") {\n                                    ko.utils.domData.set(element, ko.bindingHandlers.options.optionValueDomDataKey, undefined);\n                                    if (hasDomDataExpandoProperty in element) { // IE <= 8 throws errors if you delete non-existent properties from a DOM node\n                                        delete element[hasDomDataExpandoProperty];\n                                    }\n                                    element.value = value;\n                                }\n                                else {\n                                    // Store arbitrary object using DomData\n                                    ko.utils.domData.set(element, ko.bindingHandlers.options.optionValueDomDataKey, value);\n                                    element[hasDomDataExpandoProperty] = true;\n\n                                    // Special treatment of numbers is just for backward compatibility. KO 1.2.1 wrote numerical values to element.value.\n                                    element.value = typeof value === \"number\" ? value : \"\";\n                                }\n                                break;\n                            case 'select':\n                                if (value === \"\" || value === null)       // A blank string or null value will select the caption\n                                    value = undefined;\n                                var selection = -1;\n                                for (var i = 0, n = element.options.length, optionValue; i < n; ++i) {\n                                    optionValue = ko.selectExtensions.readValue(element.options[i]);\n                                    // Include special check to handle selecting a caption with a blank string value\n                                    if (optionValue == value || (optionValue === \"\" && value === undefined)) {\n                                        selection = i;\n                                        break;\n                                    }\n                                }\n                                if (allowUnset || selection >= 0 || (value === undefined && element.size > 1)) {\n                                    element.selectedIndex = selection;\n                                    if (ko.utils.ieVersion === 6) {\n                                        // Workaround for IE6 bug: It won't reliably apply values to SELECT nodes during the same execution thread\n                                        // right after you've changed the set of OPTION nodes on it. So for that node type, we'll schedule a second thread\n                                        // to apply the value as well.\n                                        ko.utils.setTimeout(function () {\n                                            element.selectedIndex = selection;\n                                        }, 0);\n                                    }\n                                }\n                                break;\n                            default:\n                                if ((value === null) || (value === undefined))\n                                    value = \"\";\n                                element.value = value;\n                                break;\n                        }\n                    }\n                };\n            })();\n\n            ko.exportSymbol('selectExtensions', ko.selectExtensions);\n            ko.exportSymbol('selectExtensions.readValue', ko.selectExtensions.readValue);\n            ko.exportSymbol('selectExtensions.writeValue', ko.selectExtensions.writeValue);\n            ko.expressionRewriting = (function () {\n                var javaScriptReservedWords = [\"true\", \"false\", \"null\", \"undefined\"];\n\n                // Matches something that can be assigned to--either an isolated identifier or something ending with a property accessor\n                // This is designed to be simple and avoid false negatives, but could produce false positives (e.g., a+b.c).\n                // This also will not properly handle nested brackets (e.g., obj1[obj2['prop']]; see #911).\n                var javaScriptAssignmentTarget = /^(?:[$_a-z][$\\w]*|(.+)(\\.\\s*[$_a-z][$\\w]*|\\[.+\\]))$/i;\n\n                function getWriteableValue(expression) {\n                    if (ko.utils.arrayIndexOf(javaScriptReservedWords, expression) >= 0)\n                        return false;\n                    var match = expression.match(javaScriptAssignmentTarget);\n                    return match === null ? false : match[1] ? ('Object(' + match[1] + ')' + match[2]) : expression;\n                }\n\n                // The following regular expressions will be used to split an object-literal string into tokens\n\n                var specials = ',\"\\'`{}()/:[\\\\]',    // These characters have special meaning to the parser and must not appear in the middle of a token, except as part of a string.\n                    // Create the actual regular expression by or-ing the following regex strings. The order is important.\n                    bindingToken = RegExp([\n                        // These match strings, either with double quotes, single quotes, or backticks\n                        '\"(?:\\\\\\\\.|[^\"])*\"',\n                        \"'(?:\\\\\\\\.|[^'])*'\",\n                        \"`(?:\\\\\\\\.|[^`])*`\",\n                        // Match C style comments\n                        \"/\\\\*(?:[^*]|\\\\*+[^*/])*\\\\*+/\",\n                        // Match C++ style comments\n                        \"//.*\\n\",\n                        // Match a regular expression (text enclosed by slashes), but will also match sets of divisions\n                        // as a regular expression (this is handled by the parsing loop below).\n                        '/(?:\\\\\\\\.|[^/])+/\\w*',\n                        // Match text (at least two characters) that does not contain any of the above special characters,\n                        // although some of the special characters are allowed to start it (all but the colon and comma).\n                        // The text can contain spaces, but leading or trailing spaces are skipped.\n                        '[^\\\\s:,/][^' + specials + ']*[^\\\\s' + specials + ']',\n                        // Match any non-space character not matched already. This will match colons and commas, since they're\n                        // not matched by \"everyThingElse\", but will also match any other single character that wasn't already\n                        // matched (for example: in \"a: 1, b: 2\", each of the non-space characters will be matched by oneNotSpace).\n                        '[^\\\\s]'\n                    ].join('|'), 'g'),\n\n                    // Match end of previous token to determine whether a slash is a division or regex.\n                    divisionLookBehind = /[\\])\"'A-Za-z0-9_$]+$/,\n                    keywordRegexLookBehind = {'in':1,'return':1,'typeof':1};\n\n                function parseObjectLiteral(objectLiteralString) {\n                    // Trim leading and trailing spaces from the string\n                    var str = ko.utils.stringTrim(objectLiteralString);\n\n                    // Trim braces '{' surrounding the whole object literal\n                    if (str.charCodeAt(0) === 123) str = str.slice(1, -1);\n\n                    // Add a newline to correctly match a C++ style comment at the end of the string and\n                    // add a comma so that we don't need a separate code block to deal with the last item\n                    str += \"\\n,\";\n\n                    // Split into tokens\n                    var result = [], toks = str.match(bindingToken), key, values = [], depth = 0;\n\n                    if (toks.length > 1) {\n                        for (var i = 0, tok; tok = toks[i]; ++i) {\n                            var c = tok.charCodeAt(0);\n                            // A comma signals the end of a key/value pair if depth is zero\n                            if (c === 44) { // \",\"\n                                if (depth <= 0) {\n                                    result.push((key && values.length) ? {key: key, value: values.join('')} : {'unknown': key || values.join('')});\n                                    key = depth = 0;\n                                    values = [];\n                                    continue;\n                                }\n                                // Simply skip the colon that separates the name and value\n                            } else if (c === 58) { // \":\"\n                                if (!depth && !key && values.length === 1) {\n                                    key = values.pop();\n                                    continue;\n                                }\n                                // Comments: skip them\n                            } else if (c === 47 && tok.length > 1 && (tok.charCodeAt(1) === 47 || tok.charCodeAt(1) === 42)) {  // \"//\" or \"/*\"\n                                continue;\n                                // A set of slashes is initially matched as a regular expression, but could be division\n                            } else if (c === 47 && i && tok.length > 1) {  // \"/\"\n                                // Look at the end of the previous token to determine if the slash is actually division\n                                var match = toks[i-1].match(divisionLookBehind);\n                                if (match && !keywordRegexLookBehind[match[0]]) {\n                                    // The slash is actually a division punctuator; re-parse the remainder of the string (not including the slash)\n                                    str = str.substr(str.indexOf(tok) + 1);\n                                    toks = str.match(bindingToken);\n                                    i = -1;\n                                    // Continue with just the slash\n                                    tok = '/';\n                                }\n                                // Increment depth for parentheses, braces, and brackets so that interior commas are ignored\n                            } else if (c === 40 || c === 123 || c === 91) { // '(', '{', '['\n                                ++depth;\n                            } else if (c === 41 || c === 125 || c === 93) { // ')', '}', ']'\n                                --depth;\n                                // The key will be the first token; if it's a string, trim the quotes\n                            } else if (!key && !values.length && (c === 34 || c === 39)) { // '\"', \"'\"\n                                tok = tok.slice(1, -1);\n                            }\n                            values.push(tok);\n                        }\n                        if (depth > 0) {\n                            throw Error(\"Unbalanced parentheses, braces, or brackets\");\n                        }\n                    }\n                    return result;\n                }\n\n                // Two-way bindings include a write function that allow the handler to update the value even if it's not an observable.\n                var twoWayBindings = {};\n\n                function preProcessBindings(bindingsStringOrKeyValueArray, bindingOptions) {\n                    bindingOptions = bindingOptions || {};\n\n                    function processKeyValue(key, val) {\n                        var writableVal;\n                        function callPreprocessHook(obj) {\n                            return (obj && obj['preprocess']) ? (val = obj['preprocess'](val, key, processKeyValue)) : true;\n                        }\n                        if (!bindingParams) {\n                            if (!callPreprocessHook(ko['getBindingHandler'](key)))\n                                return;\n\n                            if (twoWayBindings[key] && (writableVal = getWriteableValue(val))) {\n                                // For two-way bindings, provide a write method in case the value\n                                // isn't a writable observable.\n                                var writeKey = typeof twoWayBindings[key] == 'string' ? twoWayBindings[key] : key;\n                                propertyAccessorResultStrings.push(\"'\" + writeKey + \"':function(_z){\" + writableVal + \"=_z}\");\n                            }\n                        }\n                        // Values are wrapped in a function so that each value can be accessed independently\n                        if (makeValueAccessors) {\n                            val = 'function(){return ' + val + ' }';\n                        }\n                        resultStrings.push(\"'\" + key + \"':\" + val);\n                    }\n\n                    var resultStrings = [],\n                        propertyAccessorResultStrings = [],\n                        makeValueAccessors = bindingOptions['valueAccessors'],\n                        bindingParams = bindingOptions['bindingParams'],\n                        keyValueArray = typeof bindingsStringOrKeyValueArray === \"string\" ?\n                            parseObjectLiteral(bindingsStringOrKeyValueArray) : bindingsStringOrKeyValueArray;\n\n                    ko.utils.arrayForEach(keyValueArray, function(keyValue) {\n                        processKeyValue(keyValue.key || keyValue['unknown'], keyValue.value);\n                    });\n\n                    if (propertyAccessorResultStrings.length)\n                        processKeyValue('_ko_property_writers', \"{\" + propertyAccessorResultStrings.join(\",\") + \" }\");\n\n                    return resultStrings.join(\",\");\n                }\n\n                return {\n                    bindingRewriteValidators: [],\n\n                    twoWayBindings: twoWayBindings,\n\n                    parseObjectLiteral: parseObjectLiteral,\n\n                    preProcessBindings: preProcessBindings,\n\n                    keyValueArrayContainsKey: function(keyValueArray, key) {\n                        for (var i = 0; i < keyValueArray.length; i++)\n                            if (keyValueArray[i]['key'] == key)\n                                return true;\n                        return false;\n                    },\n\n                    // Internal, private KO utility for updating model properties from within bindings\n                    // property:            If the property being updated is (or might be) an observable, pass it here\n                    //                      If it turns out to be a writable observable, it will be written to directly\n                    // allBindings:         An object with a get method to retrieve bindings in the current execution context.\n                    //                      This will be searched for a '_ko_property_writers' property in case you're writing to a non-observable\n                    // key:                 The key identifying the property to be written. Example: for { hasFocus: myValue }, write to 'myValue' by specifying the key 'hasFocus'\n                    // value:               The value to be written\n                    // checkIfDifferent:    If true, and if the property being written is a writable observable, the value will only be written if\n                    //                      it is !== existing value on that writable observable\n                    writeValueToProperty: function(property, allBindings, key, value, checkIfDifferent) {\n                        if (!property || !ko.isObservable(property)) {\n                            var propWriters = allBindings.get('_ko_property_writers');\n                            if (propWriters && propWriters[key])\n                                propWriters[key](value);\n                        } else if (ko.isWriteableObservable(property) && (!checkIfDifferent || property.peek() !== value)) {\n                            property(value);\n                        }\n                    }\n                };\n            })();\n\n            ko.exportSymbol('expressionRewriting', ko.expressionRewriting);\n            ko.exportSymbol('expressionRewriting.bindingRewriteValidators', ko.expressionRewriting.bindingRewriteValidators);\n            ko.exportSymbol('expressionRewriting.parseObjectLiteral', ko.expressionRewriting.parseObjectLiteral);\n            ko.exportSymbol('expressionRewriting.preProcessBindings', ko.expressionRewriting.preProcessBindings);\n\n// Making bindings explicitly declare themselves as \"two way\" isn't ideal in the long term (it would be better if\n// all bindings could use an official 'property writer' API without needing to declare that they might). However,\n// since this is not, and has never been, a public API (_ko_property_writers was never documented), it's acceptable\n// as an internal implementation detail in the short term.\n// For those developers who rely on _ko_property_writers in their custom bindings, we expose _twoWayBindings as an\n// undocumented feature that makes it relatively easy to upgrade to KO 3.0. However, this is still not an official\n// public API, and we reserve the right to remove it at any time if we create a real public property writers API.\n            ko.exportSymbol('expressionRewriting._twoWayBindings', ko.expressionRewriting.twoWayBindings);\n\n// For backward compatibility, define the following aliases. (Previously, these function names were misleading because\n// they referred to JSON specifically, even though they actually work with arbitrary JavaScript object literal expressions.)\n            ko.exportSymbol('jsonExpressionRewriting', ko.expressionRewriting);\n            ko.exportSymbol('jsonExpressionRewriting.insertPropertyAccessorsIntoJson', ko.expressionRewriting.preProcessBindings);\n            (function() {\n                // \"Virtual elements\" is an abstraction on top of the usual DOM API which understands the notion that comment nodes\n                // may be used to represent hierarchy (in addition to the DOM's natural hierarchy).\n                // If you call the DOM-manipulating functions on ko.virtualElements, you will be able to read and write the state\n                // of that virtual hierarchy\n                //\n                // The point of all this is to support containerless templates (e.g., <!-- ko foreach:someCollection -->blah<!-- /ko -->)\n                // without having to scatter special cases all over the binding and templating code.\n\n                // IE 9 cannot reliably read the \"nodeValue\" property of a comment node (see https://github.com/SteveSanderson/knockout/issues/186)\n                // but it does give them a nonstandard alternative property called \"text\" that it can read reliably. Other browsers don't have that property.\n                // So, use node.text where available, and node.nodeValue elsewhere\n                var commentNodesHaveTextProperty = document && document.createComment(\"test\").text === \"<!--test-->\";\n\n                var startCommentRegex = commentNodesHaveTextProperty ? /^<!--\\s*ko(?:\\s+([\\s\\S]+))?\\s*-->$/ : /^\\s*ko(?:\\s+([\\s\\S]+))?\\s*$/;\n                var endCommentRegex =   commentNodesHaveTextProperty ? /^<!--\\s*\\/ko\\s*-->$/ : /^\\s*\\/ko\\s*$/;\n                var htmlTagsWithOptionallyClosingChildren = { 'ul': true, 'ol': true };\n\n                function isStartComment(node) {\n                    return (node.nodeType == 8) && startCommentRegex.test(commentNodesHaveTextProperty ? node.text : node.nodeValue);\n                }\n\n                function isEndComment(node) {\n                    return (node.nodeType == 8) && endCommentRegex.test(commentNodesHaveTextProperty ? node.text : node.nodeValue);\n                }\n\n                function isUnmatchedEndComment(node) {\n                    return isEndComment(node) && !(ko.utils.domData.get(node, matchedEndCommentDataKey));\n                }\n\n                var matchedEndCommentDataKey = \"__ko_matchedEndComment__\"\n\n                function getVirtualChildren(startComment, allowUnbalanced) {\n                    var currentNode = startComment;\n                    var depth = 1;\n                    var children = [];\n                    while (currentNode = currentNode.nextSibling) {\n                        if (isEndComment(currentNode)) {\n                            ko.utils.domData.set(currentNode, matchedEndCommentDataKey, true);\n                            depth--;\n                            if (depth === 0)\n                                return children;\n                        }\n\n                        children.push(currentNode);\n\n                        if (isStartComment(currentNode))\n                            depth++;\n                    }\n                    if (!allowUnbalanced)\n                        throw new Error(\"Cannot find closing comment tag to match: \" + startComment.nodeValue);\n                    return null;\n                }\n\n                function getMatchingEndComment(startComment, allowUnbalanced) {\n                    var allVirtualChildren = getVirtualChildren(startComment, allowUnbalanced);\n                    if (allVirtualChildren) {\n                        if (allVirtualChildren.length > 0)\n                            return allVirtualChildren[allVirtualChildren.length - 1].nextSibling;\n                        return startComment.nextSibling;\n                    } else\n                        return null; // Must have no matching end comment, and allowUnbalanced is true\n                }\n\n                function getUnbalancedChildTags(node) {\n                    // e.g., from <div>OK</div><!-- ko blah --><span>Another</span>, returns: <!-- ko blah --><span>Another</span>\n                    //       from <div>OK</div><!-- /ko --><!-- /ko -->,             returns: <!-- /ko --><!-- /ko -->\n                    var childNode = node.firstChild, captureRemaining = null;\n                    if (childNode) {\n                        do {\n                            if (captureRemaining)                   // We already hit an unbalanced node and are now just scooping up all subsequent nodes\n                                captureRemaining.push(childNode);\n                            else if (isStartComment(childNode)) {\n                                var matchingEndComment = getMatchingEndComment(childNode, /* allowUnbalanced: */ true);\n                                if (matchingEndComment)             // It's a balanced tag, so skip immediately to the end of this virtual set\n                                    childNode = matchingEndComment;\n                                else\n                                    captureRemaining = [childNode]; // It's unbalanced, so start capturing from this point\n                            } else if (isEndComment(childNode)) {\n                                captureRemaining = [childNode];     // It's unbalanced (if it wasn't, we'd have skipped over it already), so start capturing\n                            }\n                        } while (childNode = childNode.nextSibling);\n                    }\n                    return captureRemaining;\n                }\n\n                ko.virtualElements = {\n                    allowedBindings: {},\n\n                    childNodes: function(node) {\n                        return isStartComment(node) ? getVirtualChildren(node) : node.childNodes;\n                    },\n\n                    emptyNode: function(node) {\n                        if (!isStartComment(node))\n                            ko.utils.emptyDomNode(node);\n                        else {\n                            var virtualChildren = ko.virtualElements.childNodes(node);\n                            for (var i = 0, j = virtualChildren.length; i < j; i++)\n                                ko.removeNode(virtualChildren[i]);\n                        }\n                    },\n\n                    setDomNodeChildren: function(node, childNodes) {\n                        if (!isStartComment(node))\n                            ko.utils.setDomNodeChildren(node, childNodes);\n                        else {\n                            ko.virtualElements.emptyNode(node);\n                            var endCommentNode = node.nextSibling; // Must be the next sibling, as we just emptied the children\n                            for (var i = 0, j = childNodes.length; i < j; i++)\n                                endCommentNode.parentNode.insertBefore(childNodes[i], endCommentNode);\n                        }\n                    },\n\n                    prepend: function(containerNode, nodeToPrepend) {\n                        var insertBeforeNode;\n\n                        if (isStartComment(containerNode)) {\n                            // Start comments must always have a parent and at least one following sibling (the end comment)\n                            insertBeforeNode = containerNode.nextSibling;\n                            containerNode = containerNode.parentNode;\n                        } else {\n                            insertBeforeNode = containerNode.firstChild;\n                        }\n\n                        if (!insertBeforeNode) {\n                            containerNode.appendChild(nodeToPrepend);\n                        } else if (nodeToPrepend !== insertBeforeNode) {       // IE will sometimes crash if you try to insert a node before itself\n                            containerNode.insertBefore(nodeToPrepend, insertBeforeNode);\n                        }\n                    },\n\n                    insertAfter: function(containerNode, nodeToInsert, insertAfterNode) {\n                        if (!insertAfterNode) {\n                            ko.virtualElements.prepend(containerNode, nodeToInsert);\n                        } else {\n                            // Children of start comments must always have a parent and at least one following sibling (the end comment)\n                            var insertBeforeNode = insertAfterNode.nextSibling;\n\n                            if (isStartComment(containerNode)) {\n                                containerNode = containerNode.parentNode;\n                            }\n\n                            if (!insertBeforeNode) {\n                                containerNode.appendChild(nodeToInsert);\n                            } else if (nodeToInsert !== insertBeforeNode) {       // IE will sometimes crash if you try to insert a node before itself\n                                containerNode.insertBefore(nodeToInsert, insertBeforeNode);\n                            }\n                        }\n                    },\n\n                    firstChild: function(node) {\n                        if (!isStartComment(node)) {\n                            if (node.firstChild && isEndComment(node.firstChild)) {\n                                throw new Error(\"Found invalid end comment, as the first child of \" + node);\n                            }\n                            return node.firstChild;\n                        } else if (!node.nextSibling || isEndComment(node.nextSibling)) {\n                            return null;\n                        } else {\n                            return node.nextSibling;\n                        }\n                    },\n\n                    nextSibling: function(node) {\n                        if (isStartComment(node)) {\n                            node = getMatchingEndComment(node);\n                        }\n\n                        if (node.nextSibling && isEndComment(node.nextSibling)) {\n                            if (isUnmatchedEndComment(node.nextSibling)) {\n                                throw Error(\"Found end comment without a matching opening comment, as child of \" + node);\n                            } else {\n                                return null;\n                            }\n                        } else {\n                            return node.nextSibling;\n                        }\n                    },\n\n                    hasBindingValue: isStartComment,\n\n                    virtualNodeBindingValue: function(node) {\n                        var regexMatch = (commentNodesHaveTextProperty ? node.text : node.nodeValue).match(startCommentRegex);\n                        return regexMatch ? regexMatch[1] : null;\n                    },\n\n                    normaliseVirtualElementDomStructure: function(elementVerified) {\n                        // Workaround for https://github.com/SteveSanderson/knockout/issues/155\n                        // (IE <= 8 or IE 9 quirks mode parses your HTML weirdly, treating closing </li> tags as if they don't exist, thereby moving comment nodes\n                        // that are direct descendants of <ul> into the preceding <li>)\n                        if (!htmlTagsWithOptionallyClosingChildren[ko.utils.tagNameLower(elementVerified)])\n                            return;\n\n                        // Scan immediate children to see if they contain unbalanced comment tags. If they do, those comment tags\n                        // must be intended to appear *after* that child, so move them there.\n                        var childNode = elementVerified.firstChild;\n                        if (childNode) {\n                            do {\n                                if (childNode.nodeType === 1) {\n                                    var unbalancedTags = getUnbalancedChildTags(childNode);\n                                    if (unbalancedTags) {\n                                        // Fix up the DOM by moving the unbalanced tags to where they most likely were intended to be placed - *after* the child\n                                        var nodeToInsertBefore = childNode.nextSibling;\n                                        for (var i = 0; i < unbalancedTags.length; i++) {\n                                            if (nodeToInsertBefore)\n                                                elementVerified.insertBefore(unbalancedTags[i], nodeToInsertBefore);\n                                            else\n                                                elementVerified.appendChild(unbalancedTags[i]);\n                                        }\n                                    }\n                                }\n                            } while (childNode = childNode.nextSibling);\n                        }\n                    }\n                };\n            })();\n            ko.exportSymbol('virtualElements', ko.virtualElements);\n            ko.exportSymbol('virtualElements.allowedBindings', ko.virtualElements.allowedBindings);\n            ko.exportSymbol('virtualElements.emptyNode', ko.virtualElements.emptyNode);\n//ko.exportSymbol('virtualElements.firstChild', ko.virtualElements.firstChild);     // firstChild is not minified\n            ko.exportSymbol('virtualElements.insertAfter', ko.virtualElements.insertAfter);\n//ko.exportSymbol('virtualElements.nextSibling', ko.virtualElements.nextSibling);   // nextSibling is not minified\n            ko.exportSymbol('virtualElements.prepend', ko.virtualElements.prepend);\n            ko.exportSymbol('virtualElements.setDomNodeChildren', ko.virtualElements.setDomNodeChildren);\n            (function() {\n                var defaultBindingAttributeName = \"data-bind\";\n\n                ko.bindingProvider = function() {\n                    this.bindingCache = {};\n                };\n\n                ko.utils.extend(ko.bindingProvider.prototype, {\n                    'nodeHasBindings': function(node) {\n                        switch (node.nodeType) {\n                            case 1: // Element\n                                return node.getAttribute(defaultBindingAttributeName) != null\n                                    || ko.components['getComponentNameForNode'](node);\n                            case 8: // Comment node\n                                return ko.virtualElements.hasBindingValue(node);\n                            default: return false;\n                        }\n                    },\n\n                    'getBindings': function(node, bindingContext) {\n                        var bindingsString = this['getBindingsString'](node, bindingContext),\n                            parsedBindings = bindingsString ? this['parseBindingsString'](bindingsString, bindingContext, node) : null;\n                        return ko.components.addBindingsForCustomElement(parsedBindings, node, bindingContext, /* valueAccessors */ false);\n                    },\n\n                    'getBindingAccessors': function(node, bindingContext) {\n                        var bindingsString = this['getBindingsString'](node, bindingContext),\n                            parsedBindings = bindingsString ? this['parseBindingsString'](bindingsString, bindingContext, node, { 'valueAccessors': true }) : null;\n                        return ko.components.addBindingsForCustomElement(parsedBindings, node, bindingContext, /* valueAccessors */ true);\n                    },\n\n                    // The following function is only used internally by this default provider.\n                    // It's not part of the interface definition for a general binding provider.\n                    'getBindingsString': function(node, bindingContext) {\n                        switch (node.nodeType) {\n                            case 1: return node.getAttribute(defaultBindingAttributeName);   // Element\n                            case 8: return ko.virtualElements.virtualNodeBindingValue(node); // Comment node\n                            default: return null;\n                        }\n                    },\n\n                    // The following function is only used internally by this default provider.\n                    // It's not part of the interface definition for a general binding provider.\n                    'parseBindingsString': function(bindingsString, bindingContext, node, options) {\n                        try {\n                            var bindingFunction = createBindingsStringEvaluatorViaCache(bindingsString, this.bindingCache, options);\n                            return bindingFunction(bindingContext, node);\n                        } catch (ex) {\n                            ex.message = \"Unable to parse bindings.\\nBindings value: \" + bindingsString + \"\\nMessage: \" + ex.message;\n                            throw ex;\n                        }\n                    }\n                });\n\n                ko.bindingProvider['instance'] = new ko.bindingProvider();\n\n                function createBindingsStringEvaluatorViaCache(bindingsString, cache, options) {\n                    var cacheKey = bindingsString + (options && options['valueAccessors'] || '');\n                    return cache[cacheKey]\n                        || (cache[cacheKey] = createBindingsStringEvaluator(bindingsString, options));\n                }\n\n                function createBindingsStringEvaluator(bindingsString, options) {\n                    // Build the source for a function that evaluates \"expression\"\n                    // For each scope variable, add an extra level of \"with\" nesting\n                    // Example result: with(sc1) { with(sc0) { return (expression) } }\n                    var rewrittenBindings = ko.expressionRewriting.preProcessBindings(bindingsString, options),\n                        functionBody = \"with($context){with($data||{}){return{\" + rewrittenBindings + \"}}}\";\n                    return new Function(\"$context\", \"$element\", functionBody);\n                }\n            })();\n\n            ko.exportSymbol('bindingProvider', ko.bindingProvider);\n            (function () {\n                // Hide or don't minify context properties, see https://github.com/knockout/knockout/issues/2294\n                var contextSubscribable = ko.utils.createSymbolOrString('_subscribable');\n                var contextAncestorBindingInfo = ko.utils.createSymbolOrString('_ancestorBindingInfo');\n                var contextDataDependency = ko.utils.createSymbolOrString('_dataDependency');\n\n                ko.bindingHandlers = {};\n\n                // The following element types will not be recursed into during binding.\n                var bindingDoesNotRecurseIntoElementTypes = {\n                    // Don't want bindings that operate on text nodes to mutate <script> and <textarea> contents,\n                    // because it's unexpected and a potential XSS issue.\n                    // Also bindings should not operate on <template> elements since this breaks in Internet Explorer\n                    // and because such elements' contents are always intended to be bound in a different context\n                    // from where they appear in the document.\n                    'script': true,\n                    'textarea': true,\n                    'template': true\n                };\n\n                // Use an overridable method for retrieving binding handlers so that plugins may support dynamically created handlers\n                ko['getBindingHandler'] = function(bindingKey) {\n                    return ko.bindingHandlers[bindingKey];\n                };\n\n                var inheritParentVm = {};\n\n                // The ko.bindingContext constructor is only called directly to create the root context. For child\n                // contexts, use bindingContext.createChildContext or bindingContext.extend.\n                ko.bindingContext = function(dataItemOrAccessor, parentContext, dataItemAlias, extendCallback, options) {\n\n                    // The binding context object includes static properties for the current, parent, and root view models.\n                    // If a view model is actually stored in an observable, the corresponding binding context object, and\n                    // any child contexts, must be updated when the view model is changed.\n                    function updateContext() {\n                        // Most of the time, the context will directly get a view model object, but if a function is given,\n                        // we call the function to retrieve the view model. If the function accesses any observables or returns\n                        // an observable, the dependency is tracked, and those observables can later cause the binding\n                        // context to be updated.\n                        var dataItemOrObservable = isFunc ? realDataItemOrAccessor() : realDataItemOrAccessor,\n                            dataItem = ko.utils.unwrapObservable(dataItemOrObservable);\n\n                        if (parentContext) {\n                            // Copy $root and any custom properties from the parent context\n                            ko.utils.extend(self, parentContext);\n\n                            // Copy Symbol properties\n                            if (contextAncestorBindingInfo in parentContext) {\n                                self[contextAncestorBindingInfo] = parentContext[contextAncestorBindingInfo];\n                            }\n                        } else {\n                            self['$parents'] = [];\n                            self['$root'] = dataItem;\n\n                            // Export 'ko' in the binding context so it will be available in bindings and templates\n                            // even if 'ko' isn't exported as a global, such as when using an AMD loader.\n                            // See https://github.com/SteveSanderson/knockout/issues/490\n                            self['ko'] = ko;\n                        }\n\n                        self[contextSubscribable] = subscribable;\n\n                        if (shouldInheritData) {\n                            dataItem = self['$data'];\n                        } else {\n                            self['$rawData'] = dataItemOrObservable;\n                            self['$data'] = dataItem;\n                        }\n\n                        if (dataItemAlias)\n                            self[dataItemAlias] = dataItem;\n\n                        // The extendCallback function is provided when creating a child context or extending a context.\n                        // It handles the specific actions needed to finish setting up the binding context. Actions in this\n                        // function could also add dependencies to this binding context.\n                        if (extendCallback)\n                            extendCallback(self, parentContext, dataItem);\n\n                        // When a \"parent\" context is given and we don't already have a dependency on its context, register a dependency on it.\n                        // Thus whenever the parent context is updated, this context will also be updated.\n                        if (parentContext && parentContext[contextSubscribable] && !ko.computedContext.computed().hasAncestorDependency(parentContext[contextSubscribable])) {\n                            parentContext[contextSubscribable]();\n                        }\n\n                        if (dataDependency) {\n                            self[contextDataDependency] = dataDependency;\n                        }\n\n                        return self['$data'];\n                    }\n\n                    var self = this,\n                        shouldInheritData = dataItemOrAccessor === inheritParentVm,\n                        realDataItemOrAccessor = shouldInheritData ? undefined : dataItemOrAccessor,\n                        isFunc = typeof(realDataItemOrAccessor) == \"function\" && !ko.isObservable(realDataItemOrAccessor),\n                        nodes,\n                        subscribable,\n                        dataDependency = options && options['dataDependency'];\n\n                    if (options && options['exportDependencies']) {\n                        // The \"exportDependencies\" option means that the calling code will track any dependencies and re-create\n                        // the binding context when they change.\n                        updateContext();\n                    } else {\n                        subscribable = ko.pureComputed(updateContext);\n                        subscribable.peek();\n\n                        // At this point, the binding context has been initialized, and the \"subscribable\" computed observable is\n                        // subscribed to any observables that were accessed in the process. If there is nothing to track, the\n                        // computed will be inactive, and we can safely throw it away. If it's active, the computed is stored in\n                        // the context object.\n                        if (subscribable.isActive()) {\n                            // Always notify because even if the model ($data) hasn't changed, other context properties might have changed\n                            subscribable['equalityComparer'] = null;\n                        } else {\n                            self[contextSubscribable] = undefined;\n                        }\n                    }\n                }\n\n                // Extend the binding context hierarchy with a new view model object. If the parent context is watching\n                // any observables, the new child context will automatically get a dependency on the parent context.\n                // But this does not mean that the $data value of the child context will also get updated. If the child\n                // view model also depends on the parent view model, you must provide a function that returns the correct\n                // view model on each update.\n                ko.bindingContext.prototype['createChildContext'] = function (dataItemOrAccessor, dataItemAlias, extendCallback, options) {\n                    if (!options && dataItemAlias && typeof dataItemAlias == \"object\") {\n                        options = dataItemAlias;\n                        dataItemAlias = options['as'];\n                        extendCallback = options['extend'];\n                    }\n\n                    if (dataItemAlias && options && options['noChildContext']) {\n                        var isFunc = typeof(dataItemOrAccessor) == \"function\" && !ko.isObservable(dataItemOrAccessor);\n                        return new ko.bindingContext(inheritParentVm, this, null, function (self) {\n                            if (extendCallback)\n                                extendCallback(self);\n                            self[dataItemAlias] = isFunc ? dataItemOrAccessor() : dataItemOrAccessor;\n                        }, options);\n                    }\n\n                    return new ko.bindingContext(dataItemOrAccessor, this, dataItemAlias, function (self, parentContext) {\n                        // Extend the context hierarchy by setting the appropriate pointers\n                        self['$parentContext'] = parentContext;\n                        self['$parent'] = parentContext['$data'];\n                        self['$parents'] = (parentContext['$parents'] || []).slice(0);\n                        self['$parents'].unshift(self['$parent']);\n                        if (extendCallback)\n                            extendCallback(self);\n                    }, options);\n                };\n\n                // Extend the binding context with new custom properties. This doesn't change the context hierarchy.\n                // Similarly to \"child\" contexts, provide a function here to make sure that the correct values are set\n                // when an observable view model is updated.\n                ko.bindingContext.prototype['extend'] = function(properties, options) {\n                    return new ko.bindingContext(inheritParentVm, this, null, function(self, parentContext) {\n                        ko.utils.extend(self, typeof(properties) == \"function\" ? properties(self) : properties);\n                    }, options);\n                };\n\n                var boundElementDomDataKey = ko.utils.domData.nextKey();\n\n                function asyncContextDispose(node) {\n                    var bindingInfo = ko.utils.domData.get(node, boundElementDomDataKey),\n                        asyncContext = bindingInfo && bindingInfo.asyncContext;\n                    if (asyncContext) {\n                        bindingInfo.asyncContext = null;\n                        asyncContext.notifyAncestor();\n                    }\n                }\n                function AsyncCompleteContext(node, bindingInfo, ancestorBindingInfo) {\n                    this.node = node;\n                    this.bindingInfo = bindingInfo;\n                    this.asyncDescendants = [];\n                    this.childrenComplete = false;\n\n                    if (!bindingInfo.asyncContext) {\n                        ko.utils.domNodeDisposal.addDisposeCallback(node, asyncContextDispose);\n                    }\n\n                    if (ancestorBindingInfo && ancestorBindingInfo.asyncContext) {\n                        ancestorBindingInfo.asyncContext.asyncDescendants.push(node);\n                        this.ancestorBindingInfo = ancestorBindingInfo;\n                    }\n                }\n                AsyncCompleteContext.prototype.notifyAncestor = function () {\n                    if (this.ancestorBindingInfo && this.ancestorBindingInfo.asyncContext) {\n                        this.ancestorBindingInfo.asyncContext.descendantComplete(this.node);\n                    }\n                };\n                AsyncCompleteContext.prototype.descendantComplete = function (node) {\n                    ko.utils.arrayRemoveItem(this.asyncDescendants, node);\n                    if (!this.asyncDescendants.length && this.childrenComplete) {\n                        this.completeChildren();\n                    }\n                };\n                AsyncCompleteContext.prototype.completeChildren = function () {\n                    this.childrenComplete = true;\n                    if (this.bindingInfo.asyncContext && !this.asyncDescendants.length) {\n                        this.bindingInfo.asyncContext = null;\n                        ko.utils.domNodeDisposal.removeDisposeCallback(this.node, asyncContextDispose);\n                        ko.bindingEvent.notify(this.node, ko.bindingEvent.descendantsComplete);\n                        this.notifyAncestor();\n                    }\n                };\n\n                ko.bindingEvent = {\n                    childrenComplete: \"childrenComplete\",\n                    descendantsComplete : \"descendantsComplete\",\n\n                    subscribe: function (node, event, callback, context, options) {\n                        var bindingInfo = ko.utils.domData.getOrSet(node, boundElementDomDataKey, {});\n                        if (!bindingInfo.eventSubscribable) {\n                            bindingInfo.eventSubscribable = new ko.subscribable;\n                        }\n                        if (options && options['notifyImmediately'] && bindingInfo.notifiedEvents[event]) {\n                            ko.dependencyDetection.ignore(callback, context, [node]);\n                        }\n                        return bindingInfo.eventSubscribable.subscribe(callback, context, event);\n                    },\n\n                    notify: function (node, event) {\n                        var bindingInfo = ko.utils.domData.get(node, boundElementDomDataKey);\n                        if (bindingInfo) {\n                            bindingInfo.notifiedEvents[event] = true;\n                            if (bindingInfo.eventSubscribable) {\n                                bindingInfo.eventSubscribable['notifySubscribers'](node, event);\n                            }\n                            if (event == ko.bindingEvent.childrenComplete) {\n                                if (bindingInfo.asyncContext) {\n                                    bindingInfo.asyncContext.completeChildren();\n                                } else if (bindingInfo.asyncContext === undefined && bindingInfo.eventSubscribable && bindingInfo.eventSubscribable.hasSubscriptionsForEvent(ko.bindingEvent.descendantsComplete)) {\n                                    // It's currently an error to register a descendantsComplete handler for a node that was never registered as completing asynchronously.\n                                    // That's because without the asyncContext, we don't have a way to know that all descendants have completed.\n                                    throw new Error(\"descendantsComplete event not supported for bindings on this node\");\n                                }\n                            }\n                        }\n                    },\n\n                    startPossiblyAsyncContentBinding: function (node, bindingContext) {\n                        var bindingInfo = ko.utils.domData.getOrSet(node, boundElementDomDataKey, {});\n\n                        if (!bindingInfo.asyncContext) {\n                            bindingInfo.asyncContext = new AsyncCompleteContext(node, bindingInfo, bindingContext[contextAncestorBindingInfo]);\n                        }\n\n                        // If the provided context was already extended with this node's binding info, just return the extended context\n                        if (bindingContext[contextAncestorBindingInfo] == bindingInfo) {\n                            return bindingContext;\n                        }\n\n                        return bindingContext['extend'](function (ctx) {\n                            ctx[contextAncestorBindingInfo] = bindingInfo;\n                        });\n                    }\n                };\n\n                // Returns the valueAccessor function for a binding value\n                function makeValueAccessor(value) {\n                    return function() {\n                        return value;\n                    };\n                }\n\n                // Returns the value of a valueAccessor function\n                function evaluateValueAccessor(valueAccessor) {\n                    return valueAccessor();\n                }\n\n                // Given a function that returns bindings, create and return a new object that contains\n                // binding value-accessors functions. Each accessor function calls the original function\n                // so that it always gets the latest value and all dependencies are captured. This is used\n                // by ko.applyBindingsToNode and getBindingsAndMakeAccessors.\n                function makeAccessorsFromFunction(callback) {\n                    return ko.utils.objectMap(ko.dependencyDetection.ignore(callback), function(value, key) {\n                        return function() {\n                            return callback()[key];\n                        };\n                    });\n                }\n\n                // Given a bindings function or object, create and return a new object that contains\n                // binding value-accessors functions. This is used by ko.applyBindingsToNode.\n                function makeBindingAccessors(bindings, context, node) {\n                    if (typeof bindings === 'function') {\n                        return makeAccessorsFromFunction(bindings.bind(null, context, node));\n                    } else {\n                        return ko.utils.objectMap(bindings, makeValueAccessor);\n                    }\n                }\n\n                // This function is used if the binding provider doesn't include a getBindingAccessors function.\n                // It must be called with 'this' set to the provider instance.\n                function getBindingsAndMakeAccessors(node, context) {\n                    return makeAccessorsFromFunction(this['getBindings'].bind(this, node, context));\n                }\n\n                function validateThatBindingIsAllowedForVirtualElements(bindingName) {\n                    var validator = ko.virtualElements.allowedBindings[bindingName];\n                    if (!validator)\n                        throw new Error(\"The binding '\" + bindingName + \"' cannot be used with virtual elements\")\n                }\n\n                function applyBindingsToDescendantsInternal(bindingContext, elementOrVirtualElement) {\n                    var nextInQueue = ko.virtualElements.firstChild(elementOrVirtualElement);\n\n                    if (nextInQueue) {\n                        var currentChild,\n                            provider = ko.bindingProvider['instance'],\n                            preprocessNode = provider['preprocessNode'];\n\n                        // Preprocessing allows a binding provider to mutate a node before bindings are applied to it. For example it's\n                        // possible to insert new siblings after it, and/or replace the node with a different one. This can be used to\n                        // implement custom binding syntaxes, such as {{ value }} for string interpolation, or custom element types that\n                        // trigger insertion of <template> contents at that point in the document.\n                        if (preprocessNode) {\n                            while (currentChild = nextInQueue) {\n                                nextInQueue = ko.virtualElements.nextSibling(currentChild);\n                                preprocessNode.call(provider, currentChild);\n                            }\n                            // Reset nextInQueue for the next loop\n                            nextInQueue = ko.virtualElements.firstChild(elementOrVirtualElement);\n                        }\n\n                        while (currentChild = nextInQueue) {\n                            // Keep a record of the next child *before* applying bindings, in case the binding removes the current child from its position\n                            nextInQueue = ko.virtualElements.nextSibling(currentChild);\n                            applyBindingsToNodeAndDescendantsInternal(bindingContext, currentChild);\n                        }\n                    }\n                    ko.bindingEvent.notify(elementOrVirtualElement, ko.bindingEvent.childrenComplete);\n                }\n\n                function applyBindingsToNodeAndDescendantsInternal(bindingContext, nodeVerified) {\n                    var bindingContextForDescendants = bindingContext;\n\n                    var isElement = (nodeVerified.nodeType === 1);\n                    if (isElement) // Workaround IE <= 8 HTML parsing weirdness\n                        ko.virtualElements.normaliseVirtualElementDomStructure(nodeVerified);\n\n                    // Perf optimisation: Apply bindings only if...\n                    // (1) We need to store the binding info for the node (all element nodes)\n                    // (2) It might have bindings (e.g., it has a data-bind attribute, or it's a marker for a containerless template)\n                    var shouldApplyBindings = isElement || ko.bindingProvider['instance']['nodeHasBindings'](nodeVerified);\n                    if (shouldApplyBindings)\n                        bindingContextForDescendants = applyBindingsToNodeInternal(nodeVerified, null, bindingContext)['bindingContextForDescendants'];\n\n                    if (bindingContextForDescendants && !bindingDoesNotRecurseIntoElementTypes[ko.utils.tagNameLower(nodeVerified)]) {\n                        applyBindingsToDescendantsInternal(bindingContextForDescendants, nodeVerified);\n                    }\n                }\n\n                function topologicalSortBindings(bindings) {\n                    // Depth-first sort\n                    var result = [],                // The list of key/handler pairs that we will return\n                        bindingsConsidered = {},    // A temporary record of which bindings are already in 'result'\n                        cyclicDependencyStack = []; // Keeps track of a depth-search so that, if there's a cycle, we know which bindings caused it\n                    ko.utils.objectForEach(bindings, function pushBinding(bindingKey) {\n                        if (!bindingsConsidered[bindingKey]) {\n                            var binding = ko['getBindingHandler'](bindingKey);\n                            if (binding) {\n                                // First add dependencies (if any) of the current binding\n                                if (binding['after']) {\n                                    cyclicDependencyStack.push(bindingKey);\n                                    ko.utils.arrayForEach(binding['after'], function(bindingDependencyKey) {\n                                        if (bindings[bindingDependencyKey]) {\n                                            if (ko.utils.arrayIndexOf(cyclicDependencyStack, bindingDependencyKey) !== -1) {\n                                                throw Error(\"Cannot combine the following bindings, because they have a cyclic dependency: \" + cyclicDependencyStack.join(\", \"));\n                                            } else {\n                                                pushBinding(bindingDependencyKey);\n                                            }\n                                        }\n                                    });\n                                    cyclicDependencyStack.length--;\n                                }\n                                // Next add the current binding\n                                result.push({ key: bindingKey, handler: binding });\n                            }\n                            bindingsConsidered[bindingKey] = true;\n                        }\n                    });\n\n                    return result;\n                }\n\n                function applyBindingsToNodeInternal(node, sourceBindings, bindingContext) {\n                    var bindingInfo = ko.utils.domData.getOrSet(node, boundElementDomDataKey, {});\n\n                    // Prevent multiple applyBindings calls for the same node, except when a binding value is specified\n                    var alreadyBound = bindingInfo.alreadyBound;\n                    if (!sourceBindings) {\n                        if (alreadyBound) {\n                            throw Error(\"You cannot apply bindings multiple times to the same element.\");\n                        }\n                        bindingInfo.alreadyBound = true;\n                    }\n                    if (!alreadyBound) {\n                        bindingInfo.context = bindingContext;\n                    }\n                    if (!bindingInfo.notifiedEvents) {\n                        bindingInfo.notifiedEvents = {};\n                    }\n\n                    // Use bindings if given, otherwise fall back on asking the bindings provider to give us some bindings\n                    var bindings;\n                    if (sourceBindings && typeof sourceBindings !== 'function') {\n                        bindings = sourceBindings;\n                    } else {\n                        var provider = ko.bindingProvider['instance'],\n                            getBindings = provider['getBindingAccessors'] || getBindingsAndMakeAccessors;\n\n                        // Get the binding from the provider within a computed observable so that we can update the bindings whenever\n                        // the binding context is updated or if the binding provider accesses observables.\n                        var bindingsUpdater = ko.dependentObservable(\n                            function() {\n                                bindings = sourceBindings ? sourceBindings(bindingContext, node) : getBindings.call(provider, node, bindingContext);\n                                // Register a dependency on the binding context to support observable view models.\n                                if (bindings) {\n                                    if (bindingContext[contextSubscribable]) {\n                                        bindingContext[contextSubscribable]();\n                                    }\n                                    if (bindingContext[contextDataDependency]) {\n                                        bindingContext[contextDataDependency]();\n                                    }\n                                }\n                                return bindings;\n                            },\n                            null, { disposeWhenNodeIsRemoved: node }\n                        );\n\n                        if (!bindings || !bindingsUpdater.isActive())\n                            bindingsUpdater = null;\n                    }\n\n                    var contextToExtend = bindingContext;\n                    var bindingHandlerThatControlsDescendantBindings;\n                    if (bindings) {\n                        // Return the value accessor for a given binding. When bindings are static (won't be updated because of a binding\n                        // context update), just return the value accessor from the binding. Otherwise, return a function that always gets\n                        // the latest binding value and registers a dependency on the binding updater.\n                        var getValueAccessor = bindingsUpdater\n                            ? function(bindingKey) {\n                                return function() {\n                                    return evaluateValueAccessor(bindingsUpdater()[bindingKey]);\n                                };\n                            } : function(bindingKey) {\n                                return bindings[bindingKey];\n                            };\n\n                        // Use of allBindings as a function is maintained for backwards compatibility, but its use is deprecated\n                        function allBindings() {\n                            return ko.utils.objectMap(bindingsUpdater ? bindingsUpdater() : bindings, evaluateValueAccessor);\n                        }\n                        // The following is the 3.x allBindings API\n                        allBindings['get'] = function(key) {\n                            return bindings[key] && evaluateValueAccessor(getValueAccessor(key));\n                        };\n                        allBindings['has'] = function(key) {\n                            return key in bindings;\n                        };\n\n                        if (ko.bindingEvent.childrenComplete in bindings) {\n                            ko.bindingEvent.subscribe(node, ko.bindingEvent.childrenComplete, function () {\n                                var callback = evaluateValueAccessor(bindings[ko.bindingEvent.childrenComplete]);\n                                if (callback) {\n                                    var nodes = ko.virtualElements.childNodes(node);\n                                    if (nodes.length) {\n                                        callback(nodes, ko.dataFor(nodes[0]));\n                                    }\n                                }\n                            });\n                        }\n\n                        if (ko.bindingEvent.descendantsComplete in bindings) {\n                            contextToExtend = ko.bindingEvent.startPossiblyAsyncContentBinding(node, bindingContext);\n                            ko.bindingEvent.subscribe(node, ko.bindingEvent.descendantsComplete, function () {\n                                var callback = evaluateValueAccessor(bindings[ko.bindingEvent.descendantsComplete]);\n                                if (callback && ko.virtualElements.firstChild(node)) {\n                                    callback(node);\n                                }\n                            });\n                        }\n\n                        // First put the bindings into the right order\n                        var orderedBindings = topologicalSortBindings(bindings);\n\n                        // Go through the sorted bindings, calling init and update for each\n                        ko.utils.arrayForEach(orderedBindings, function(bindingKeyAndHandler) {\n                            // Note that topologicalSortBindings has already filtered out any nonexistent binding handlers,\n                            // so bindingKeyAndHandler.handler will always be nonnull.\n                            var handlerInitFn = bindingKeyAndHandler.handler[\"init\"],\n                                handlerUpdateFn = bindingKeyAndHandler.handler[\"update\"],\n                                bindingKey = bindingKeyAndHandler.key;\n\n                            if (node.nodeType === 8) {\n                                validateThatBindingIsAllowedForVirtualElements(bindingKey);\n                            }\n\n                            try {\n                                // Run init, ignoring any dependencies\n                                if (typeof handlerInitFn == \"function\") {\n                                    ko.dependencyDetection.ignore(function() {\n                                        var initResult = handlerInitFn(node, getValueAccessor(bindingKey), allBindings, contextToExtend['$data'], contextToExtend);\n\n                                        // If this binding handler claims to control descendant bindings, make a note of this\n                                        if (initResult && initResult['controlsDescendantBindings']) {\n                                            if (bindingHandlerThatControlsDescendantBindings !== undefined)\n                                                throw new Error(\"Multiple bindings (\" + bindingHandlerThatControlsDescendantBindings + \" and \" + bindingKey + \") are trying to control descendant bindings of the same element. You cannot use these bindings together on the same element.\");\n                                            bindingHandlerThatControlsDescendantBindings = bindingKey;\n                                        }\n                                    });\n                                }\n\n                                // Run update in its own computed wrapper\n                                if (typeof handlerUpdateFn == \"function\") {\n                                    ko.dependentObservable(\n                                        function() {\n                                            handlerUpdateFn(node, getValueAccessor(bindingKey), allBindings, contextToExtend['$data'], contextToExtend);\n                                        },\n                                        null,\n                                        { disposeWhenNodeIsRemoved: node }\n                                    );\n                                }\n                            } catch (ex) {\n                                ex.message = \"Unable to process binding \\\"\" + bindingKey + \": \" + bindings[bindingKey] + \"\\\"\\nMessage: \" + ex.message;\n                                throw ex;\n                            }\n                        });\n                    }\n\n                    var shouldBindDescendants = bindingHandlerThatControlsDescendantBindings === undefined;\n                    return {\n                        'shouldBindDescendants': shouldBindDescendants,\n                        'bindingContextForDescendants': shouldBindDescendants && contextToExtend\n                    };\n                };\n\n                ko.storedBindingContextForNode = function (node) {\n                    var bindingInfo = ko.utils.domData.get(node, boundElementDomDataKey);\n                    return bindingInfo && bindingInfo.context;\n                }\n\n                function getBindingContext(viewModelOrBindingContext, extendContextCallback) {\n                    return viewModelOrBindingContext && (viewModelOrBindingContext instanceof ko.bindingContext)\n                        ? viewModelOrBindingContext\n                        : new ko.bindingContext(viewModelOrBindingContext, undefined, undefined, extendContextCallback);\n                }\n\n                ko.applyBindingAccessorsToNode = function (node, bindings, viewModelOrBindingContext) {\n                    if (node.nodeType === 1) // If it's an element, workaround IE <= 8 HTML parsing weirdness\n                        ko.virtualElements.normaliseVirtualElementDomStructure(node);\n                    return applyBindingsToNodeInternal(node, bindings, getBindingContext(viewModelOrBindingContext));\n                };\n\n                ko.applyBindingsToNode = function (node, bindings, viewModelOrBindingContext) {\n                    var context = getBindingContext(viewModelOrBindingContext);\n                    return ko.applyBindingAccessorsToNode(node, makeBindingAccessors(bindings, context, node), context);\n                };\n\n                ko.applyBindingsToDescendants = function(viewModelOrBindingContext, rootNode) {\n                    if (rootNode.nodeType === 1 || rootNode.nodeType === 8)\n                        applyBindingsToDescendantsInternal(getBindingContext(viewModelOrBindingContext), rootNode);\n                };\n\n                ko.applyBindings = function (viewModelOrBindingContext, rootNode, extendContextCallback) {\n                    // If jQuery is loaded after Knockout, we won't initially have access to it. So save it here.\n                    if (!jQueryInstance && window['jQuery']) {\n                        jQueryInstance = window['jQuery'];\n                    }\n\n                    if (arguments.length < 2) {\n                        rootNode = document.body;\n                        if (!rootNode) {\n                            throw Error(\"ko.applyBindings: could not find document.body; has the document been loaded?\");\n                        }\n                    } else if (!rootNode || (rootNode.nodeType !== 1 && rootNode.nodeType !== 8)) {\n                        throw Error(\"ko.applyBindings: first parameter should be your view model; second parameter should be a DOM node\");\n                    }\n\n                    applyBindingsToNodeAndDescendantsInternal(getBindingContext(viewModelOrBindingContext, extendContextCallback), rootNode);\n                };\n\n                // Retrieving binding context from arbitrary nodes\n                ko.contextFor = function(node) {\n                    // We can only do something meaningful for elements and comment nodes (in particular, not text nodes, as IE can't store domdata for them)\n                    if (node && (node.nodeType === 1 || node.nodeType === 8)) {\n                        return ko.storedBindingContextForNode(node);\n                    }\n                    return undefined;\n                };\n                ko.dataFor = function(node) {\n                    var context = ko.contextFor(node);\n                    return context ? context['$data'] : undefined;\n                };\n\n                ko.exportSymbol('bindingHandlers', ko.bindingHandlers);\n                ko.exportSymbol('bindingEvent', ko.bindingEvent);\n                ko.exportSymbol('bindingEvent.subscribe', ko.bindingEvent.subscribe);\n                ko.exportSymbol('bindingEvent.startPossiblyAsyncContentBinding', ko.bindingEvent.startPossiblyAsyncContentBinding);\n                ko.exportSymbol('applyBindings', ko.applyBindings);\n                ko.exportSymbol('applyBindingsToDescendants', ko.applyBindingsToDescendants);\n                ko.exportSymbol('applyBindingAccessorsToNode', ko.applyBindingAccessorsToNode);\n                ko.exportSymbol('applyBindingsToNode', ko.applyBindingsToNode);\n                ko.exportSymbol('contextFor', ko.contextFor);\n                ko.exportSymbol('dataFor', ko.dataFor);\n            })();\n            (function(undefined) {\n                var loadingSubscribablesCache = {}, // Tracks component loads that are currently in flight\n                    loadedDefinitionsCache = {};    // Tracks component loads that have already completed\n\n                ko.components = {\n                    get: function(componentName, callback) {\n                        var cachedDefinition = getObjectOwnProperty(loadedDefinitionsCache, componentName);\n                        if (cachedDefinition) {\n                            // It's already loaded and cached. Reuse the same definition object.\n                            // Note that for API consistency, even cache hits complete asynchronously by default.\n                            // You can bypass this by putting synchronous:true on your component config.\n                            if (cachedDefinition.isSynchronousComponent) {\n                                ko.dependencyDetection.ignore(function() { // See comment in loaderRegistryBehaviors.js for reasoning\n                                    callback(cachedDefinition.definition);\n                                });\n                            } else {\n                                ko.tasks.schedule(function() { callback(cachedDefinition.definition); });\n                            }\n                        } else {\n                            // Join the loading process that is already underway, or start a new one.\n                            loadComponentAndNotify(componentName, callback);\n                        }\n                    },\n\n                    clearCachedDefinition: function(componentName) {\n                        delete loadedDefinitionsCache[componentName];\n                    },\n\n                    _getFirstResultFromLoaders: getFirstResultFromLoaders\n                };\n\n                function getObjectOwnProperty(obj, propName) {\n                    return Object.prototype.hasOwnProperty.call(obj, propName) ? obj[propName] : undefined;\n                }\n\n                function loadComponentAndNotify(componentName, callback) {\n                    var subscribable = getObjectOwnProperty(loadingSubscribablesCache, componentName),\n                        completedAsync;\n                    if (!subscribable) {\n                        // It's not started loading yet. Start loading, and when it's done, move it to loadedDefinitionsCache.\n                        subscribable = loadingSubscribablesCache[componentName] = new ko.subscribable();\n                        subscribable.subscribe(callback);\n\n                        beginLoadingComponent(componentName, function(definition, config) {\n                            var isSynchronousComponent = !!(config && config['synchronous']);\n                            loadedDefinitionsCache[componentName] = { definition: definition, isSynchronousComponent: isSynchronousComponent };\n                            delete loadingSubscribablesCache[componentName];\n\n                            // For API consistency, all loads complete asynchronously. However we want to avoid\n                            // adding an extra task schedule if it's unnecessary (i.e., the completion is already\n                            // async).\n                            //\n                            // You can bypass the 'always asynchronous' feature by putting the synchronous:true\n                            // flag on your component configuration when you register it.\n                            if (completedAsync || isSynchronousComponent) {\n                                // Note that notifySubscribers ignores any dependencies read within the callback.\n                                // See comment in loaderRegistryBehaviors.js for reasoning\n                                subscribable['notifySubscribers'](definition);\n                            } else {\n                                ko.tasks.schedule(function() {\n                                    subscribable['notifySubscribers'](definition);\n                                });\n                            }\n                        });\n                        completedAsync = true;\n                    } else {\n                        subscribable.subscribe(callback);\n                    }\n                }\n\n                function beginLoadingComponent(componentName, callback) {\n                    getFirstResultFromLoaders('getConfig', [componentName], function(config) {\n                        if (config) {\n                            // We have a config, so now load its definition\n                            getFirstResultFromLoaders('loadComponent', [componentName, config], function(definition) {\n                                callback(definition, config);\n                            });\n                        } else {\n                            // The component has no config - it's unknown to all the loaders.\n                            // Note that this is not an error (e.g., a module loading error) - that would abort the\n                            // process and this callback would not run. For this callback to run, all loaders must\n                            // have confirmed they don't know about this component.\n                            callback(null, null);\n                        }\n                    });\n                }\n\n                function getFirstResultFromLoaders(methodName, argsExceptCallback, callback, candidateLoaders) {\n                    // On the first call in the stack, start with the full set of loaders\n                    if (!candidateLoaders) {\n                        candidateLoaders = ko.components['loaders'].slice(0); // Use a copy, because we'll be mutating this array\n                    }\n\n                    // Try the next candidate\n                    var currentCandidateLoader = candidateLoaders.shift();\n                    if (currentCandidateLoader) {\n                        var methodInstance = currentCandidateLoader[methodName];\n                        if (methodInstance) {\n                            var wasAborted = false,\n                                synchronousReturnValue = methodInstance.apply(currentCandidateLoader, argsExceptCallback.concat(function(result) {\n                                    if (wasAborted) {\n                                        callback(null);\n                                    } else if (result !== null) {\n                                        // This candidate returned a value. Use it.\n                                        callback(result);\n                                    } else {\n                                        // Try the next candidate\n                                        getFirstResultFromLoaders(methodName, argsExceptCallback, callback, candidateLoaders);\n                                    }\n                                }));\n\n                            // Currently, loaders may not return anything synchronously. This leaves open the possibility\n                            // that we'll extend the API to support synchronous return values in the future. It won't be\n                            // a breaking change, because currently no loader is allowed to return anything except undefined.\n                            if (synchronousReturnValue !== undefined) {\n                                wasAborted = true;\n\n                                // Method to suppress exceptions will remain undocumented. This is only to keep\n                                // KO's specs running tidily, since we can observe the loading got aborted without\n                                // having exceptions cluttering up the console too.\n                                if (!currentCandidateLoader['suppressLoaderExceptions']) {\n                                    throw new Error('Component loaders must supply values by invoking the callback, not by returning values synchronously.');\n                                }\n                            }\n                        } else {\n                            // This candidate doesn't have the relevant handler. Synchronously move on to the next one.\n                            getFirstResultFromLoaders(methodName, argsExceptCallback, callback, candidateLoaders);\n                        }\n                    } else {\n                        // No candidates returned a value\n                        callback(null);\n                    }\n                }\n\n                // Reference the loaders via string name so it's possible for developers\n                // to replace the whole array by assigning to ko.components.loaders\n                ko.components['loaders'] = [];\n\n                ko.exportSymbol('components', ko.components);\n                ko.exportSymbol('components.get', ko.components.get);\n                ko.exportSymbol('components.clearCachedDefinition', ko.components.clearCachedDefinition);\n            })();\n            (function(undefined) {\n\n                // The default loader is responsible for two things:\n                // 1. Maintaining the default in-memory registry of component configuration objects\n                //    (i.e., the thing you're writing to when you call ko.components.register(someName, ...))\n                // 2. Answering requests for components by fetching configuration objects\n                //    from that default in-memory registry and resolving them into standard\n                //    component definition objects (of the form { createViewModel: ..., template: ... })\n                // Custom loaders may override either of these facilities, i.e.,\n                // 1. To supply configuration objects from some other source (e.g., conventions)\n                // 2. Or, to resolve configuration objects by loading viewmodels/templates via arbitrary logic.\n\n                var defaultConfigRegistry = {};\n\n                ko.components.register = function(componentName, config) {\n                    if (!config) {\n                        throw new Error('Invalid configuration for ' + componentName);\n                    }\n\n                    if (ko.components.isRegistered(componentName)) {\n                        throw new Error('Component ' + componentName + ' is already registered');\n                    }\n\n                    defaultConfigRegistry[componentName] = config;\n                };\n\n                ko.components.isRegistered = function(componentName) {\n                    return Object.prototype.hasOwnProperty.call(defaultConfigRegistry, componentName);\n                };\n\n                ko.components.unregister = function(componentName) {\n                    delete defaultConfigRegistry[componentName];\n                    ko.components.clearCachedDefinition(componentName);\n                };\n\n                ko.components.defaultLoader = {\n                    'getConfig': function(componentName, callback) {\n                        var result = ko.components.isRegistered(componentName)\n                            ? defaultConfigRegistry[componentName]\n                            : null;\n                        callback(result);\n                    },\n\n                    'loadComponent': function(componentName, config, callback) {\n                        var errorCallback = makeErrorCallback(componentName);\n                        possiblyGetConfigFromAmd(errorCallback, config, function(loadedConfig) {\n                            resolveConfig(componentName, errorCallback, loadedConfig, callback);\n                        });\n                    },\n\n                    'loadTemplate': function(componentName, templateConfig, callback) {\n                        resolveTemplate(makeErrorCallback(componentName), templateConfig, callback);\n                    },\n\n                    'loadViewModel': function(componentName, viewModelConfig, callback) {\n                        resolveViewModel(makeErrorCallback(componentName), viewModelConfig, callback);\n                    }\n                };\n\n                var createViewModelKey = 'createViewModel';\n\n                // Takes a config object of the form { template: ..., viewModel: ... }, and asynchronously convert it\n                // into the standard component definition format:\n                //    { template: <ArrayOfDomNodes>, createViewModel: function(params, componentInfo) { ... } }.\n                // Since both template and viewModel may need to be resolved asynchronously, both tasks are performed\n                // in parallel, and the results joined when both are ready. We don't depend on any promises infrastructure,\n                // so this is implemented manually below.\n                function resolveConfig(componentName, errorCallback, config, callback) {\n                    var result = {},\n                        makeCallBackWhenZero = 2,\n                        tryIssueCallback = function() {\n                            if (--makeCallBackWhenZero === 0) {\n                                callback(result);\n                            }\n                        },\n                        templateConfig = config['template'],\n                        viewModelConfig = config['viewModel'];\n\n                    if (templateConfig) {\n                        possiblyGetConfigFromAmd(errorCallback, templateConfig, function(loadedConfig) {\n                            ko.components._getFirstResultFromLoaders('loadTemplate', [componentName, loadedConfig], function(resolvedTemplate) {\n                                result['template'] = resolvedTemplate;\n                                tryIssueCallback();\n                            });\n                        });\n                    } else {\n                        tryIssueCallback();\n                    }\n\n                    if (viewModelConfig) {\n                        possiblyGetConfigFromAmd(errorCallback, viewModelConfig, function(loadedConfig) {\n                            ko.components._getFirstResultFromLoaders('loadViewModel', [componentName, loadedConfig], function(resolvedViewModel) {\n                                result[createViewModelKey] = resolvedViewModel;\n                                tryIssueCallback();\n                            });\n                        });\n                    } else {\n                        tryIssueCallback();\n                    }\n                }\n\n                function resolveTemplate(errorCallback, templateConfig, callback) {\n                    if (typeof templateConfig === 'string') {\n                        // Markup - parse it\n                        callback(ko.utils.parseHtmlFragment(templateConfig));\n                    } else if (templateConfig instanceof Array) {\n                        // Assume already an array of DOM nodes - pass through unchanged\n                        callback(templateConfig);\n                    } else if (isDocumentFragment(templateConfig)) {\n                        // Document fragment - use its child nodes\n                        callback(ko.utils.makeArray(templateConfig.childNodes));\n                    } else if (templateConfig['element']) {\n                        var element = templateConfig['element'];\n                        if (isDomElement(element)) {\n                            // Element instance - copy its child nodes\n                            callback(cloneNodesFromTemplateSourceElement(element));\n                        } else if (typeof element === 'string') {\n                            // Element ID - find it, then copy its child nodes\n                            var elemInstance = document.getElementById(element);\n                            if (elemInstance) {\n                                callback(cloneNodesFromTemplateSourceElement(elemInstance));\n                            } else {\n                                errorCallback('Cannot find element with ID ' + element);\n                            }\n                        } else {\n                            errorCallback('Unknown element type: ' + element);\n                        }\n                    } else {\n                        errorCallback('Unknown template value: ' + templateConfig);\n                    }\n                }\n\n                function resolveViewModel(errorCallback, viewModelConfig, callback) {\n                    if (typeof viewModelConfig === 'function') {\n                        // Constructor - convert to standard factory function format\n                        // By design, this does *not* supply componentInfo to the constructor, as the intent is that\n                        // componentInfo contains non-viewmodel data (e.g., the component's element) that should only\n                        // be used in factory functions, not viewmodel constructors.\n                        callback(function (params /*, componentInfo */) {\n                            return new viewModelConfig(params);\n                        });\n                    } else if (typeof viewModelConfig[createViewModelKey] === 'function') {\n                        // Already a factory function - use it as-is\n                        callback(viewModelConfig[createViewModelKey]);\n                    } else if ('instance' in viewModelConfig) {\n                        // Fixed object instance - promote to createViewModel format for API consistency\n                        var fixedInstance = viewModelConfig['instance'];\n                        callback(function (params, componentInfo) {\n                            return fixedInstance;\n                        });\n                    } else if ('viewModel' in viewModelConfig) {\n                        // Resolved AMD module whose value is of the form { viewModel: ... }\n                        resolveViewModel(errorCallback, viewModelConfig['viewModel'], callback);\n                    } else {\n                        errorCallback('Unknown viewModel value: ' + viewModelConfig);\n                    }\n                }\n\n                function cloneNodesFromTemplateSourceElement(elemInstance) {\n                    switch (ko.utils.tagNameLower(elemInstance)) {\n                        case 'script':\n                            return ko.utils.parseHtmlFragment(elemInstance.text);\n                        case 'textarea':\n                            return ko.utils.parseHtmlFragment(elemInstance.value);\n                        case 'template':\n                            // For browsers with proper <template> element support (i.e., where the .content property\n                            // gives a document fragment), use that document fragment.\n                            if (isDocumentFragment(elemInstance.content)) {\n                                return ko.utils.cloneNodes(elemInstance.content.childNodes);\n                            }\n                    }\n\n                    // Regular elements such as <div>, and <template> elements on old browsers that don't really\n                    // understand <template> and just treat it as a regular container\n                    return ko.utils.cloneNodes(elemInstance.childNodes);\n                }\n\n                function isDomElement(obj) {\n                    if (window['HTMLElement']) {\n                        return obj instanceof HTMLElement;\n                    } else {\n                        return obj && obj.tagName && obj.nodeType === 1;\n                    }\n                }\n\n                function isDocumentFragment(obj) {\n                    if (window['DocumentFragment']) {\n                        return obj instanceof DocumentFragment;\n                    } else {\n                        return obj && obj.nodeType === 11;\n                    }\n                }\n\n                function possiblyGetConfigFromAmd(errorCallback, config, callback) {\n                    if (typeof config['require'] === 'string') {\n                        // The config is the value of an AMD module\n                        if (amdRequire || window['require']) {\n                            (amdRequire || window['require'])([config['require']], function (module) {\n                                if (module && typeof module === 'object' && module.__esModule && module.default) {\n                                    module = module.default;\n                                }\n                                callback(module);\n                            });\n                        } else {\n                            errorCallback('Uses require, but no AMD loader is present');\n                        }\n                    } else {\n                        callback(config);\n                    }\n                }\n\n                function makeErrorCallback(componentName) {\n                    return function (message) {\n                        throw new Error('Component \\'' + componentName + '\\': ' + message);\n                    };\n                }\n\n                ko.exportSymbol('components.register', ko.components.register);\n                ko.exportSymbol('components.isRegistered', ko.components.isRegistered);\n                ko.exportSymbol('components.unregister', ko.components.unregister);\n\n                // Expose the default loader so that developers can directly ask it for configuration\n                // or to resolve configuration\n                ko.exportSymbol('components.defaultLoader', ko.components.defaultLoader);\n\n                // By default, the default loader is the only registered component loader\n                ko.components['loaders'].push(ko.components.defaultLoader);\n\n                // Privately expose the underlying config registry for use in old-IE shim\n                ko.components._allRegisteredComponents = defaultConfigRegistry;\n            })();\n            (function (undefined) {\n                // Overridable API for determining which component name applies to a given node. By overriding this,\n                // you can for example map specific tagNames to components that are not preregistered.\n                ko.components['getComponentNameForNode'] = function(node) {\n                    var tagNameLower = ko.utils.tagNameLower(node);\n                    if (ko.components.isRegistered(tagNameLower)) {\n                        // Try to determine that this node can be considered a *custom* element; see https://github.com/knockout/knockout/issues/1603\n                        if (tagNameLower.indexOf('-') != -1 || ('' + node) == \"[object HTMLUnknownElement]\" || (ko.utils.ieVersion <= 8 && node.tagName === tagNameLower)) {\n                            return tagNameLower;\n                        }\n                    }\n                };\n\n                ko.components.addBindingsForCustomElement = function(allBindings, node, bindingContext, valueAccessors) {\n                    // Determine if it's really a custom element matching a component\n                    if (node.nodeType === 1) {\n                        var componentName = ko.components['getComponentNameForNode'](node);\n                        if (componentName) {\n                            // It does represent a component, so add a component binding for it\n                            allBindings = allBindings || {};\n\n                            if (allBindings['component']) {\n                                // Avoid silently overwriting some other 'component' binding that may already be on the element\n                                throw new Error('Cannot use the \"component\" binding on a custom element matching a component');\n                            }\n\n                            var componentBindingValue = { 'name': componentName, 'params': getComponentParamsFromCustomElement(node, bindingContext) };\n\n                            allBindings['component'] = valueAccessors\n                                ? function() { return componentBindingValue; }\n                                : componentBindingValue;\n                        }\n                    }\n\n                    return allBindings;\n                }\n\n                var nativeBindingProviderInstance = new ko.bindingProvider();\n\n                function getComponentParamsFromCustomElement(elem, bindingContext) {\n                    var paramsAttribute = elem.getAttribute('params');\n\n                    if (paramsAttribute) {\n                        var params = nativeBindingProviderInstance['parseBindingsString'](paramsAttribute, bindingContext, elem, { 'valueAccessors': true, 'bindingParams': true }),\n                            rawParamComputedValues = ko.utils.objectMap(params, function(paramValue, paramName) {\n                                return ko.computed(paramValue, null, { disposeWhenNodeIsRemoved: elem });\n                            }),\n                            result = ko.utils.objectMap(rawParamComputedValues, function(paramValueComputed, paramName) {\n                                var paramValue = paramValueComputed.peek();\n                                // Does the evaluation of the parameter value unwrap any observables?\n                                if (!paramValueComputed.isActive()) {\n                                    // No it doesn't, so there's no need for any computed wrapper. Just pass through the supplied value directly.\n                                    // Example: \"someVal: firstName, age: 123\" (whether or not firstName is an observable/computed)\n                                    return paramValue;\n                                } else {\n                                    // Yes it does. Supply a computed property that unwraps both the outer (binding expression)\n                                    // level of observability, and any inner (resulting model value) level of observability.\n                                    // This means the component doesn't have to worry about multiple unwrapping. If the value is a\n                                    // writable observable, the computed will also be writable and pass the value on to the observable.\n                                    return ko.computed({\n                                        'read': function() {\n                                            return ko.utils.unwrapObservable(paramValueComputed());\n                                        },\n                                        'write': ko.isWriteableObservable(paramValue) && function(value) {\n                                            paramValueComputed()(value);\n                                        },\n                                        disposeWhenNodeIsRemoved: elem\n                                    });\n                                }\n                            });\n\n                        // Give access to the raw computeds, as long as that wouldn't overwrite any custom param also called '$raw'\n                        // This is in case the developer wants to react to outer (binding) observability separately from inner\n                        // (model value) observability, or in case the model value observable has subobservables.\n                        if (!Object.prototype.hasOwnProperty.call(result, '$raw')) {\n                            result['$raw'] = rawParamComputedValues;\n                        }\n\n                        return result;\n                    } else {\n                        // For consistency, absence of a \"params\" attribute is treated the same as the presence of\n                        // any empty one. Otherwise component viewmodels need special code to check whether or not\n                        // 'params' or 'params.$raw' is null/undefined before reading subproperties, which is annoying.\n                        return { '$raw': {} };\n                    }\n                }\n\n                // --------------------------------------------------------------------------------\n                // Compatibility code for older (pre-HTML5) IE browsers\n\n                if (ko.utils.ieVersion < 9) {\n                    // Whenever you preregister a component, enable it as a custom element in the current document\n                    ko.components['register'] = (function(originalFunction) {\n                        return function(componentName) {\n                            document.createElement(componentName); // Allows IE<9 to parse markup containing the custom element\n                            return originalFunction.apply(this, arguments);\n                        }\n                    })(ko.components['register']);\n\n                    // Whenever you create a document fragment, enable all preregistered component names as custom elements\n                    // This is needed to make innerShiv/jQuery HTML parsing correctly handle the custom elements\n                    document.createDocumentFragment = (function(originalFunction) {\n                        return function() {\n                            var newDocFrag = originalFunction(),\n                                allComponents = ko.components._allRegisteredComponents;\n                            for (var componentName in allComponents) {\n                                if (Object.prototype.hasOwnProperty.call(allComponents, componentName)) {\n                                    newDocFrag.createElement(componentName);\n                                }\n                            }\n                            return newDocFrag;\n                        };\n                    })(document.createDocumentFragment);\n                }\n            })();(function(undefined) {\n                var componentLoadingOperationUniqueId = 0;\n\n                ko.bindingHandlers['component'] = {\n                    'init': function(element, valueAccessor, ignored1, ignored2, bindingContext) {\n                        var currentViewModel,\n                            currentLoadingOperationId,\n                            afterRenderSub,\n                            disposeAssociatedComponentViewModel = function () {\n                                var currentViewModelDispose = currentViewModel && currentViewModel['dispose'];\n                                if (typeof currentViewModelDispose === 'function') {\n                                    currentViewModelDispose.call(currentViewModel);\n                                }\n                                if (afterRenderSub) {\n                                    afterRenderSub.dispose();\n                                }\n                                afterRenderSub = null;\n                                currentViewModel = null;\n                                // Any in-flight loading operation is no longer relevant, so make sure we ignore its completion\n                                currentLoadingOperationId = null;\n                            },\n                            originalChildNodes = ko.utils.makeArray(ko.virtualElements.childNodes(element));\n\n                        ko.virtualElements.emptyNode(element);\n                        ko.utils.domNodeDisposal.addDisposeCallback(element, disposeAssociatedComponentViewModel);\n\n                        ko.computed(function () {\n                            var value = ko.utils.unwrapObservable(valueAccessor()),\n                                componentName, componentParams;\n\n                            if (typeof value === 'string') {\n                                componentName = value;\n                            } else {\n                                componentName = ko.utils.unwrapObservable(value['name']);\n                                componentParams = ko.utils.unwrapObservable(value['params']);\n                            }\n\n                            if (!componentName) {\n                                throw new Error('No component name specified');\n                            }\n\n                            var asyncContext = ko.bindingEvent.startPossiblyAsyncContentBinding(element, bindingContext);\n\n                            var loadingOperationId = currentLoadingOperationId = ++componentLoadingOperationUniqueId;\n                            ko.components.get(componentName, function(componentDefinition) {\n                                // If this is not the current load operation for this element, ignore it.\n                                if (currentLoadingOperationId !== loadingOperationId) {\n                                    return;\n                                }\n\n                                // Clean up previous state\n                                disposeAssociatedComponentViewModel();\n\n                                // Instantiate and bind new component. Implicitly this cleans any old DOM nodes.\n                                if (!componentDefinition) {\n                                    throw new Error('Unknown component \\'' + componentName + '\\'');\n                                }\n                                cloneTemplateIntoElement(componentName, componentDefinition, element);\n\n                                var componentInfo = {\n                                    'element': element,\n                                    'templateNodes': originalChildNodes\n                                };\n\n                                var componentViewModel = createViewModel(componentDefinition, componentParams, componentInfo),\n                                    childBindingContext = asyncContext['createChildContext'](componentViewModel, {\n                                        'extend': function(ctx) {\n                                            ctx['$component'] = componentViewModel;\n                                            ctx['$componentTemplateNodes'] = originalChildNodes;\n                                        }\n                                    });\n\n                                if (componentViewModel && componentViewModel['koDescendantsComplete']) {\n                                    afterRenderSub = ko.bindingEvent.subscribe(element, ko.bindingEvent.descendantsComplete, componentViewModel['koDescendantsComplete'], componentViewModel);\n                                }\n\n                                currentViewModel = componentViewModel;\n                                ko.applyBindingsToDescendants(childBindingContext, element);\n                            });\n                        }, null, { disposeWhenNodeIsRemoved: element });\n\n                        return { 'controlsDescendantBindings': true };\n                    }\n                };\n\n                ko.virtualElements.allowedBindings['component'] = true;\n\n                function cloneTemplateIntoElement(componentName, componentDefinition, element) {\n                    var template = componentDefinition['template'];\n                    if (!template) {\n                        throw new Error('Component \\'' + componentName + '\\' has no template');\n                    }\n\n                    var clonedNodesArray = ko.utils.cloneNodes(template);\n                    ko.virtualElements.setDomNodeChildren(element, clonedNodesArray);\n                }\n\n                function createViewModel(componentDefinition, componentParams, componentInfo) {\n                    var componentViewModelFactory = componentDefinition['createViewModel'];\n                    return componentViewModelFactory\n                        ? componentViewModelFactory.call(componentDefinition, componentParams, componentInfo)\n                        : componentParams; // Template-only component\n                }\n\n            })();\n            var attrHtmlToJavaScriptMap = { 'class': 'className', 'for': 'htmlFor' };\n            ko.bindingHandlers['attr'] = {\n                'update': function(element, valueAccessor, allBindings) {\n                    var value = ko.utils.unwrapObservable(valueAccessor()) || {};\n                    ko.utils.objectForEach(value, function(attrName, attrValue) {\n                        attrValue = ko.utils.unwrapObservable(attrValue);\n\n                        // Find the namespace of this attribute, if any.\n                        var prefixLen = attrName.indexOf(':');\n                        var namespace = \"lookupNamespaceURI\" in element && prefixLen > 0 && element.lookupNamespaceURI(attrName.substr(0, prefixLen));\n\n                        // To cover cases like \"attr: { checked:someProp }\", we want to remove the attribute entirely\n                        // when someProp is a \"no value\"-like value (strictly null, false, or undefined)\n                        // (because the absence of the \"checked\" attr is how to mark an element as not checked, etc.)\n                        var toRemove = (attrValue === false) || (attrValue === null) || (attrValue === undefined);\n                        if (toRemove) {\n                            namespace ? element.removeAttributeNS(namespace, attrName) : element.removeAttribute(attrName);\n                        } else {\n                            attrValue = attrValue.toString();\n                        }\n\n                        // In IE <= 7 and IE8 Quirks Mode, you have to use the JavaScript property name instead of the\n                        // HTML attribute name for certain attributes. IE8 Standards Mode supports the correct behavior,\n                        // but instead of figuring out the mode, we'll just set the attribute through the JavaScript\n                        // property for IE <= 8.\n                        if (ko.utils.ieVersion <= 8 && attrName in attrHtmlToJavaScriptMap) {\n                            attrName = attrHtmlToJavaScriptMap[attrName];\n                            if (toRemove)\n                                element.removeAttribute(attrName);\n                            else\n                                element[attrName] = attrValue;\n                        } else if (!toRemove) {\n                            namespace ? element.setAttributeNS(namespace, attrName, attrValue) : element.setAttribute(attrName, attrValue);\n                        }\n\n                        // Treat \"name\" specially - although you can think of it as an attribute, it also needs\n                        // special handling on older versions of IE (https://github.com/SteveSanderson/knockout/pull/333)\n                        // Deliberately being case-sensitive here because XHTML would regard \"Name\" as a different thing\n                        // entirely, and there's no strong reason to allow for such casing in HTML.\n                        if (attrName === \"name\") {\n                            ko.utils.setElementName(element, toRemove ? \"\" : attrValue);\n                        }\n                    });\n                }\n            };\n            (function() {\n\n                ko.bindingHandlers['checked'] = {\n                    'after': ['value', 'attr'],\n                    'init': function (element, valueAccessor, allBindings) {\n                        var checkedValue = ko.pureComputed(function() {\n                            // Treat \"value\" like \"checkedValue\" when it is included with \"checked\" binding\n                            if (allBindings['has']('checkedValue')) {\n                                return ko.utils.unwrapObservable(allBindings.get('checkedValue'));\n                            } else if (useElementValue) {\n                                if (allBindings['has']('value')) {\n                                    return ko.utils.unwrapObservable(allBindings.get('value'));\n                                } else {\n                                    return element.value;\n                                }\n                            }\n                        });\n\n                        function updateModel() {\n                            // This updates the model value from the view value.\n                            // It runs in response to DOM events (click) and changes in checkedValue.\n                            var isChecked = element.checked,\n                                elemValue = checkedValue();\n\n                            // When we're first setting up this computed, don't change any model state.\n                            if (ko.computedContext.isInitial()) {\n                                return;\n                            }\n\n                            // We can ignore unchecked radio buttons, because some other radio\n                            // button will be checked, and that one can take care of updating state.\n                            // Also ignore value changes to an already unchecked checkbox.\n                            if (!isChecked && (isRadio || ko.computedContext.getDependenciesCount())) {\n                                return;\n                            }\n\n                            var modelValue = ko.dependencyDetection.ignore(valueAccessor);\n                            if (valueIsArray) {\n                                var writableValue = rawValueIsNonArrayObservable ? modelValue.peek() : modelValue,\n                                    saveOldValue = oldElemValue;\n                                oldElemValue = elemValue;\n\n                                if (saveOldValue !== elemValue) {\n                                    // When we're responding to the checkedValue changing, and the element is\n                                    // currently checked, replace the old elem value with the new elem value\n                                    // in the model array.\n                                    if (isChecked) {\n                                        ko.utils.addOrRemoveItem(writableValue, elemValue, true);\n                                        ko.utils.addOrRemoveItem(writableValue, saveOldValue, false);\n                                    }\n                                } else {\n                                    // When we're responding to the user having checked/unchecked a checkbox,\n                                    // add/remove the element value to the model array.\n                                    ko.utils.addOrRemoveItem(writableValue, elemValue, isChecked);\n                                }\n\n                                if (rawValueIsNonArrayObservable && ko.isWriteableObservable(modelValue)) {\n                                    modelValue(writableValue);\n                                }\n                            } else {\n                                if (isCheckbox) {\n                                    if (elemValue === undefined) {\n                                        elemValue = isChecked;\n                                    } else if (!isChecked) {\n                                        elemValue = undefined;\n                                    }\n                                }\n                                ko.expressionRewriting.writeValueToProperty(modelValue, allBindings, 'checked', elemValue, true);\n                            }\n                        };\n\n                        function updateView() {\n                            // This updates the view value from the model value.\n                            // It runs in response to changes in the bound (checked) value.\n                            var modelValue = ko.utils.unwrapObservable(valueAccessor()),\n                                elemValue = checkedValue();\n\n                            if (valueIsArray) {\n                                // When a checkbox is bound to an array, being checked represents its value being present in that array\n                                element.checked = ko.utils.arrayIndexOf(modelValue, elemValue) >= 0;\n                                oldElemValue = elemValue;\n                            } else if (isCheckbox && elemValue === undefined) {\n                                // When a checkbox is bound to any other value (not an array) and \"checkedValue\" is not defined,\n                                // being checked represents the value being trueish\n                                element.checked = !!modelValue;\n                            } else {\n                                // Otherwise, being checked means that the checkbox or radio button's value corresponds to the model value\n                                element.checked = (checkedValue() === modelValue);\n                            }\n                        };\n\n                        var isCheckbox = element.type == \"checkbox\",\n                            isRadio = element.type == \"radio\";\n\n                        // Only bind to check boxes and radio buttons\n                        if (!isCheckbox && !isRadio) {\n                            return;\n                        }\n\n                        var rawValue = valueAccessor(),\n                            valueIsArray = isCheckbox && (ko.utils.unwrapObservable(rawValue) instanceof Array),\n                            rawValueIsNonArrayObservable = !(valueIsArray && rawValue.push && rawValue.splice),\n                            useElementValue = isRadio || valueIsArray,\n                            oldElemValue = valueIsArray ? checkedValue() : undefined;\n\n                        // IE 6 won't allow radio buttons to be selected unless they have a name\n                        if (isRadio && !element.name)\n                            ko.bindingHandlers['uniqueName']['init'](element, function() { return true });\n\n                        // Set up two computeds to update the binding:\n\n                        // The first responds to changes in the checkedValue value and to element clicks\n                        ko.computed(updateModel, null, { disposeWhenNodeIsRemoved: element });\n                        ko.utils.registerEventHandler(element, \"click\", updateModel);\n\n                        // The second responds to changes in the model value (the one associated with the checked binding)\n                        ko.computed(updateView, null, { disposeWhenNodeIsRemoved: element });\n\n                        rawValue = undefined;\n                    }\n                };\n                ko.expressionRewriting.twoWayBindings['checked'] = true;\n\n                ko.bindingHandlers['checkedValue'] = {\n                    'update': function (element, valueAccessor) {\n                        element.value = ko.utils.unwrapObservable(valueAccessor());\n                    }\n                };\n\n            })();var classesWrittenByBindingKey = '__ko__cssValue';\n            ko.bindingHandlers['class'] = {\n                'update': function (element, valueAccessor) {\n                    var value = ko.utils.stringTrim(ko.utils.unwrapObservable(valueAccessor()));\n                    ko.utils.toggleDomNodeCssClass(element, element[classesWrittenByBindingKey], false);\n                    element[classesWrittenByBindingKey] = value;\n                    ko.utils.toggleDomNodeCssClass(element, value, true);\n                }\n            };\n\n            ko.bindingHandlers['css'] = {\n                'update': function (element, valueAccessor) {\n                    var value = ko.utils.unwrapObservable(valueAccessor());\n                    if (value !== null && typeof value == \"object\") {\n                        ko.utils.objectForEach(value, function(className, shouldHaveClass) {\n                            shouldHaveClass = ko.utils.unwrapObservable(shouldHaveClass);\n                            ko.utils.toggleDomNodeCssClass(element, className, shouldHaveClass);\n                        });\n                    } else {\n                        ko.bindingHandlers['class']['update'](element, valueAccessor);\n                    }\n                }\n            };\n            ko.bindingHandlers['enable'] = {\n                'update': function (element, valueAccessor) {\n                    var value = ko.utils.unwrapObservable(valueAccessor());\n                    if (value && element.disabled)\n                        element.removeAttribute(\"disabled\");\n                    else if ((!value) && (!element.disabled))\n                        element.disabled = true;\n                }\n            };\n\n            ko.bindingHandlers['disable'] = {\n                'update': function (element, valueAccessor) {\n                    ko.bindingHandlers['enable']['update'](element, function() { return !ko.utils.unwrapObservable(valueAccessor()) });\n                }\n            };\n// For certain common events (currently just 'click'), allow a simplified data-binding syntax\n// e.g. click:handler instead of the usual full-length event:{click:handler}\n            function makeEventHandlerShortcut(eventName) {\n                ko.bindingHandlers[eventName] = {\n                    'init': function(element, valueAccessor, allBindings, viewModel, bindingContext) {\n                        var newValueAccessor = function () {\n                            var result = {};\n                            result[eventName] = valueAccessor();\n                            return result;\n                        };\n                        return ko.bindingHandlers['event']['init'].call(this, element, newValueAccessor, allBindings, viewModel, bindingContext);\n                    }\n                }\n            }\n\n            ko.bindingHandlers['event'] = {\n                'init' : function (element, valueAccessor, allBindings, viewModel, bindingContext) {\n                    var eventsToHandle = valueAccessor() || {};\n                    ko.utils.objectForEach(eventsToHandle, function(eventName) {\n                        if (typeof eventName == \"string\") {\n                            ko.utils.registerEventHandler(element, eventName, function (event) {\n                                var handlerReturnValue;\n                                var handlerFunction = valueAccessor()[eventName];\n                                if (!handlerFunction)\n                                    return;\n\n                                try {\n                                    // Take all the event args, and prefix with the viewmodel\n                                    var argsForHandler = ko.utils.makeArray(arguments);\n                                    viewModel = bindingContext['$data'];\n                                    argsForHandler.unshift(viewModel);\n                                    handlerReturnValue = handlerFunction.apply(viewModel, argsForHandler);\n                                } finally {\n                                    if (handlerReturnValue !== true) { // Normally we want to prevent default action. Developer can override this be explicitly returning true.\n                                        if (event.preventDefault)\n                                            event.preventDefault();\n                                        else\n                                            event.returnValue = false;\n                                    }\n                                }\n\n                                var bubble = allBindings.get(eventName + 'Bubble') !== false;\n                                if (!bubble) {\n                                    event.cancelBubble = true;\n                                    if (event.stopPropagation)\n                                        event.stopPropagation();\n                                }\n                            });\n                        }\n                    });\n                }\n            };\n// \"foreach: someExpression\" is equivalent to \"template: { foreach: someExpression }\"\n// \"foreach: { data: someExpression, afterAdd: myfn }\" is equivalent to \"template: { foreach: someExpression, afterAdd: myfn }\"\n            ko.bindingHandlers['foreach'] = {\n                makeTemplateValueAccessor: function(valueAccessor) {\n                    return function() {\n                        var modelValue = valueAccessor(),\n                            unwrappedValue = ko.utils.peekObservable(modelValue);    // Unwrap without setting a dependency here\n\n                        // If unwrappedValue is the array, pass in the wrapped value on its own\n                        // The value will be unwrapped and tracked within the template binding\n                        // (See https://github.com/SteveSanderson/knockout/issues/523)\n                        if ((!unwrappedValue) || typeof unwrappedValue.length == \"number\")\n                            return { 'foreach': modelValue, 'templateEngine': ko.nativeTemplateEngine.instance };\n\n                        // If unwrappedValue.data is the array, preserve all relevant options and unwrap again value so we get updates\n                        ko.utils.unwrapObservable(modelValue);\n                        return {\n                            'foreach': unwrappedValue['data'],\n                            'as': unwrappedValue['as'],\n                            'noChildContext': unwrappedValue['noChildContext'],\n                            'includeDestroyed': unwrappedValue['includeDestroyed'],\n                            'afterAdd': unwrappedValue['afterAdd'],\n                            'beforeRemove': unwrappedValue['beforeRemove'],\n                            'afterRender': unwrappedValue['afterRender'],\n                            'beforeMove': unwrappedValue['beforeMove'],\n                            'afterMove': unwrappedValue['afterMove'],\n                            'templateEngine': ko.nativeTemplateEngine.instance\n                        };\n                    };\n                },\n                'init': function(element, valueAccessor, allBindings, viewModel, bindingContext) {\n                    return ko.bindingHandlers['template']['init'](element, ko.bindingHandlers['foreach'].makeTemplateValueAccessor(valueAccessor));\n                },\n                'update': function(element, valueAccessor, allBindings, viewModel, bindingContext) {\n                    return ko.bindingHandlers['template']['update'](element, ko.bindingHandlers['foreach'].makeTemplateValueAccessor(valueAccessor), allBindings, viewModel, bindingContext);\n                }\n            };\n            ko.expressionRewriting.bindingRewriteValidators['foreach'] = false; // Can't rewrite control flow bindings\n            ko.virtualElements.allowedBindings['foreach'] = true;\n            var hasfocusUpdatingProperty = '__ko_hasfocusUpdating';\n            var hasfocusLastValue = '__ko_hasfocusLastValue';\n            ko.bindingHandlers['hasfocus'] = {\n                'init': function(element, valueAccessor, allBindings) {\n                    var handleElementFocusChange = function(isFocused) {\n                        // Where possible, ignore which event was raised and determine focus state using activeElement,\n                        // as this avoids phantom focus/blur events raised when changing tabs in modern browsers.\n                        // However, not all KO-targeted browsers (Firefox 2) support activeElement. For those browsers,\n                        // prevent a loss of focus when changing tabs/windows by setting a flag that prevents hasfocus\n                        // from calling 'blur()' on the element when it loses focus.\n                        // Discussion at https://github.com/SteveSanderson/knockout/pull/352\n                        element[hasfocusUpdatingProperty] = true;\n                        var ownerDoc = element.ownerDocument;\n                        if (\"activeElement\" in ownerDoc) {\n                            var active;\n                            try {\n                                active = ownerDoc.activeElement;\n                            } catch(e) {\n                                // IE9 throws if you access activeElement during page load (see issue #703)\n                                active = ownerDoc.body;\n                            }\n                            isFocused = (active === element);\n                        }\n                        var modelValue = valueAccessor();\n                        ko.expressionRewriting.writeValueToProperty(modelValue, allBindings, 'hasfocus', isFocused, true);\n\n                        //cache the latest value, so we can avoid unnecessarily calling focus/blur in the update function\n                        element[hasfocusLastValue] = isFocused;\n                        element[hasfocusUpdatingProperty] = false;\n                    };\n                    var handleElementFocusIn = handleElementFocusChange.bind(null, true);\n                    var handleElementFocusOut = handleElementFocusChange.bind(null, false);\n\n                    ko.utils.registerEventHandler(element, \"focus\", handleElementFocusIn);\n                    ko.utils.registerEventHandler(element, \"focusin\", handleElementFocusIn); // For IE\n                    ko.utils.registerEventHandler(element, \"blur\",  handleElementFocusOut);\n                    ko.utils.registerEventHandler(element, \"focusout\",  handleElementFocusOut); // For IE\n\n                    // Assume element is not focused (prevents \"blur\" being called initially)\n                    element[hasfocusLastValue] = false;\n                },\n                'update': function(element, valueAccessor) {\n                    var value = !!ko.utils.unwrapObservable(valueAccessor());\n\n                    if (!element[hasfocusUpdatingProperty] && element[hasfocusLastValue] !== value) {\n                        value ? element.focus() : element.blur();\n\n                        // In IE, the blur method doesn't always cause the element to lose focus (for example, if the window is not in focus).\n                        // Setting focus to the body element does seem to be reliable in IE, but should only be used if we know that the current\n                        // element was focused already.\n                        if (!value && element[hasfocusLastValue]) {\n                            element.ownerDocument.body.focus();\n                        }\n\n                        // For IE, which doesn't reliably fire \"focus\" or \"blur\" events synchronously\n                        ko.dependencyDetection.ignore(ko.utils.triggerEvent, null, [element, value ? \"focusin\" : \"focusout\"]);\n                    }\n                }\n            };\n            ko.expressionRewriting.twoWayBindings['hasfocus'] = true;\n\n            ko.bindingHandlers['hasFocus'] = ko.bindingHandlers['hasfocus']; // Make \"hasFocus\" an alias\n            ko.expressionRewriting.twoWayBindings['hasFocus'] = 'hasfocus';\n            ko.bindingHandlers['html'] = {\n                'init': function() {\n                    // Prevent binding on the dynamically-injected HTML (as developers are unlikely to expect that, and it has security implications)\n                    return { 'controlsDescendantBindings': true };\n                },\n                'update': function (element, valueAccessor) {\n                    // setHtml will unwrap the value if needed\n                    ko.utils.setHtml(element, valueAccessor());\n                }\n            };\n            (function () {\n\n// Makes a binding like with or if\n                function makeWithIfBinding(bindingKey, isWith, isNot) {\n                    ko.bindingHandlers[bindingKey] = {\n                        'init': function(element, valueAccessor, allBindings, viewModel, bindingContext) {\n                            var didDisplayOnLastUpdate, savedNodes, contextOptions = {}, completeOnRender, needAsyncContext, renderOnEveryChange;\n\n                            if (isWith) {\n                                var as = allBindings.get('as'), noChildContext = allBindings.get('noChildContext');\n                                renderOnEveryChange = !(as && noChildContext);\n                                contextOptions = { 'as': as, 'noChildContext': noChildContext, 'exportDependencies': renderOnEveryChange };\n                            }\n\n                            completeOnRender = allBindings.get(\"completeOn\") == \"render\";\n                            needAsyncContext = completeOnRender || allBindings['has'](ko.bindingEvent.descendantsComplete);\n\n                            ko.computed(function() {\n                                var value = ko.utils.unwrapObservable(valueAccessor()),\n                                    shouldDisplay = !isNot !== !value, // equivalent to isNot ? !value : !!value,\n                                    isInitial = !savedNodes,\n                                    childContext;\n\n                                if (!renderOnEveryChange && shouldDisplay === didDisplayOnLastUpdate) {\n                                    return;\n                                }\n\n                                if (needAsyncContext) {\n                                    bindingContext = ko.bindingEvent.startPossiblyAsyncContentBinding(element, bindingContext);\n                                }\n\n                                if (shouldDisplay) {\n                                    if (!isWith || renderOnEveryChange) {\n                                        contextOptions['dataDependency'] = ko.computedContext.computed();\n                                    }\n\n                                    if (isWith) {\n                                        childContext = bindingContext['createChildContext'](typeof value == \"function\" ? value : valueAccessor, contextOptions);\n                                    } else if (ko.computedContext.getDependenciesCount()) {\n                                        childContext = bindingContext['extend'](null, contextOptions);\n                                    } else {\n                                        childContext = bindingContext;\n                                    }\n                                }\n\n                                // Save a copy of the inner nodes on the initial update, but only if we have dependencies.\n                                if (isInitial && ko.computedContext.getDependenciesCount()) {\n                                    savedNodes = ko.utils.cloneNodes(ko.virtualElements.childNodes(element), true /* shouldCleanNodes */);\n                                }\n\n                                if (shouldDisplay) {\n                                    if (!isInitial) {\n                                        ko.virtualElements.setDomNodeChildren(element, ko.utils.cloneNodes(savedNodes));\n                                    }\n\n                                    ko.applyBindingsToDescendants(childContext, element);\n                                } else {\n                                    ko.virtualElements.emptyNode(element);\n\n                                    if (!completeOnRender) {\n                                        ko.bindingEvent.notify(element, ko.bindingEvent.childrenComplete);\n                                    }\n                                }\n\n                                didDisplayOnLastUpdate = shouldDisplay;\n\n                            }, null, { disposeWhenNodeIsRemoved: element });\n\n                            return { 'controlsDescendantBindings': true };\n                        }\n                    };\n                    ko.expressionRewriting.bindingRewriteValidators[bindingKey] = false; // Can't rewrite control flow bindings\n                    ko.virtualElements.allowedBindings[bindingKey] = true;\n                }\n\n// Construct the actual binding handlers\n                makeWithIfBinding('if');\n                makeWithIfBinding('ifnot', false /* isWith */, true /* isNot */);\n                makeWithIfBinding('with', true /* isWith */);\n\n            })();ko.bindingHandlers['let'] = {\n                'init': function(element, valueAccessor, allBindings, viewModel, bindingContext) {\n                    // Make a modified binding context, with extra properties, and apply it to descendant elements\n                    var innerContext = bindingContext['extend'](valueAccessor);\n                    ko.applyBindingsToDescendants(innerContext, element);\n\n                    return { 'controlsDescendantBindings': true };\n                }\n            };\n            ko.virtualElements.allowedBindings['let'] = true;\n            var captionPlaceholder = {};\n            ko.bindingHandlers['options'] = {\n                'init': function(element) {\n                    if (ko.utils.tagNameLower(element) !== \"select\")\n                        throw new Error(\"options binding applies only to SELECT elements\");\n\n                    // Remove all existing <option>s.\n                    while (element.length > 0) {\n                        element.remove(0);\n                    }\n\n                    // Ensures that the binding processor doesn't try to bind the options\n                    return { 'controlsDescendantBindings': true };\n                },\n                'update': function (element, valueAccessor, allBindings) {\n                    function selectedOptions() {\n                        return ko.utils.arrayFilter(element.options, function (node) { return node.selected; });\n                    }\n\n                    var selectWasPreviouslyEmpty = element.length == 0,\n                        multiple = element.multiple,\n                        previousScrollTop = (!selectWasPreviouslyEmpty && multiple) ? element.scrollTop : null,\n                        unwrappedArray = ko.utils.unwrapObservable(valueAccessor()),\n                        valueAllowUnset = allBindings.get('valueAllowUnset') && allBindings['has']('value'),\n                        includeDestroyed = allBindings.get('optionsIncludeDestroyed'),\n                        arrayToDomNodeChildrenOptions = {},\n                        captionValue,\n                        filteredArray,\n                        previousSelectedValues = [];\n\n                    if (!valueAllowUnset) {\n                        if (multiple) {\n                            previousSelectedValues = ko.utils.arrayMap(selectedOptions(), ko.selectExtensions.readValue);\n                        } else if (element.selectedIndex >= 0) {\n                            previousSelectedValues.push(ko.selectExtensions.readValue(element.options[element.selectedIndex]));\n                        }\n                    }\n\n                    if (unwrappedArray) {\n                        if (typeof unwrappedArray.length == \"undefined\") // Coerce single value into array\n                            unwrappedArray = [unwrappedArray];\n\n                        // Filter out any entries marked as destroyed\n                        filteredArray = ko.utils.arrayFilter(unwrappedArray, function(item) {\n                            return includeDestroyed || item === undefined || item === null || !ko.utils.unwrapObservable(item['_destroy']);\n                        });\n\n                        // If caption is included, add it to the array\n                        if (allBindings['has']('optionsCaption')) {\n                            captionValue = ko.utils.unwrapObservable(allBindings.get('optionsCaption'));\n                            // If caption value is null or undefined, don't show a caption\n                            if (captionValue !== null && captionValue !== undefined) {\n                                filteredArray.unshift(captionPlaceholder);\n                            }\n                        }\n                    } else {\n                        // If a falsy value is provided (e.g. null), we'll simply empty the select element\n                    }\n\n                    function applyToObject(object, predicate, defaultValue) {\n                        var predicateType = typeof predicate;\n                        if (predicateType == \"function\")    // Given a function; run it against the data value\n                            return predicate(object);\n                        else if (predicateType == \"string\") // Given a string; treat it as a property name on the data value\n                            return object[predicate];\n                        else                                // Given no optionsText arg; use the data value itself\n                            return defaultValue;\n                    }\n\n                    // The following functions can run at two different times:\n                    // The first is when the whole array is being updated directly from this binding handler.\n                    // The second is when an observable value for a specific array entry is updated.\n                    // oldOptions will be empty in the first case, but will be filled with the previously generated option in the second.\n                    var itemUpdate = false;\n                    function optionForArrayItem(arrayEntry, index, oldOptions) {\n                        if (oldOptions.length) {\n                            previousSelectedValues = !valueAllowUnset && oldOptions[0].selected ? [ ko.selectExtensions.readValue(oldOptions[0]) ] : [];\n                            itemUpdate = true;\n                        }\n                        var option = element.ownerDocument.createElement(\"option\");\n                        if (arrayEntry === captionPlaceholder) {\n                            ko.utils.setTextContent(option, allBindings.get('optionsCaption'));\n                            ko.selectExtensions.writeValue(option, undefined);\n                        } else {\n                            // Apply a value to the option element\n                            var optionValue = applyToObject(arrayEntry, allBindings.get('optionsValue'), arrayEntry);\n                            ko.selectExtensions.writeValue(option, ko.utils.unwrapObservable(optionValue));\n\n                            // Apply some text to the option element\n                            var optionText = applyToObject(arrayEntry, allBindings.get('optionsText'), optionValue);\n                            ko.utils.setTextContent(option, optionText);\n                        }\n                        return [option];\n                    }\n\n                    // By using a beforeRemove callback, we delay the removal until after new items are added. This fixes a selection\n                    // problem in IE<=8 and Firefox. See https://github.com/knockout/knockout/issues/1208\n                    arrayToDomNodeChildrenOptions['beforeRemove'] =\n                        function (option) {\n                            element.removeChild(option);\n                        };\n\n                    function setSelectionCallback(arrayEntry, newOptions) {\n                        if (itemUpdate && valueAllowUnset) {\n                            // The model value is authoritative, so make sure its value is the one selected\n                            ko.bindingEvent.notify(element, ko.bindingEvent.childrenComplete);\n                        } else if (previousSelectedValues.length) {\n                            // IE6 doesn't like us to assign selection to OPTION nodes before they're added to the document.\n                            // That's why we first added them without selection. Now it's time to set the selection.\n                            var isSelected = ko.utils.arrayIndexOf(previousSelectedValues, ko.selectExtensions.readValue(newOptions[0])) >= 0;\n                            ko.utils.setOptionNodeSelectionState(newOptions[0], isSelected);\n\n                            // If this option was changed from being selected during a single-item update, notify the change\n                            if (itemUpdate && !isSelected) {\n                                ko.dependencyDetection.ignore(ko.utils.triggerEvent, null, [element, \"change\"]);\n                            }\n                        }\n                    }\n\n                    var callback = setSelectionCallback;\n                    if (allBindings['has']('optionsAfterRender') && typeof allBindings.get('optionsAfterRender') == \"function\") {\n                        callback = function(arrayEntry, newOptions) {\n                            setSelectionCallback(arrayEntry, newOptions);\n                            ko.dependencyDetection.ignore(allBindings.get('optionsAfterRender'), null, [newOptions[0], arrayEntry !== captionPlaceholder ? arrayEntry : undefined]);\n                        }\n                    }\n\n                    ko.utils.setDomNodeChildrenFromArrayMapping(element, filteredArray, optionForArrayItem, arrayToDomNodeChildrenOptions, callback);\n\n                    if (!valueAllowUnset) {\n                        // Determine if the selection has changed as a result of updating the options list\n                        var selectionChanged;\n                        if (multiple) {\n                            // For a multiple-select box, compare the new selection count to the previous one\n                            // But if nothing was selected before, the selection can't have changed\n                            selectionChanged = previousSelectedValues.length && selectedOptions().length < previousSelectedValues.length;\n                        } else {\n                            // For a single-select box, compare the current value to the previous value\n                            // But if nothing was selected before or nothing is selected now, just look for a change in selection\n                            selectionChanged = (previousSelectedValues.length && element.selectedIndex >= 0)\n                                ? (ko.selectExtensions.readValue(element.options[element.selectedIndex]) !== previousSelectedValues[0])\n                                : (previousSelectedValues.length || element.selectedIndex >= 0);\n                        }\n\n                        // Ensure consistency between model value and selected option.\n                        // If the dropdown was changed so that selection is no longer the same,\n                        // notify the value or selectedOptions binding.\n                        if (selectionChanged) {\n                            ko.dependencyDetection.ignore(ko.utils.triggerEvent, null, [element, \"change\"]);\n                        }\n                    }\n\n                    if (valueAllowUnset || ko.computedContext.isInitial()) {\n                        ko.bindingEvent.notify(element, ko.bindingEvent.childrenComplete);\n                    }\n\n                    // Workaround for IE bug\n                    ko.utils.ensureSelectElementIsRenderedCorrectly(element);\n\n                    if (previousScrollTop && Math.abs(previousScrollTop - element.scrollTop) > 20)\n                        element.scrollTop = previousScrollTop;\n                }\n            };\n            ko.bindingHandlers['options'].optionValueDomDataKey = ko.utils.domData.nextKey();\n            ko.bindingHandlers['selectedOptions'] = {\n                'init': function (element, valueAccessor, allBindings) {\n                    function updateFromView() {\n                        var value = valueAccessor(), valueToWrite = [];\n                        ko.utils.arrayForEach(element.getElementsByTagName(\"option\"), function(node) {\n                            if (node.selected)\n                                valueToWrite.push(ko.selectExtensions.readValue(node));\n                        });\n                        ko.expressionRewriting.writeValueToProperty(value, allBindings, 'selectedOptions', valueToWrite);\n                    }\n\n                    function updateFromModel() {\n                        var newValue = ko.utils.unwrapObservable(valueAccessor()),\n                            previousScrollTop = element.scrollTop;\n\n                        if (newValue && typeof newValue.length == \"number\") {\n                            ko.utils.arrayForEach(element.getElementsByTagName(\"option\"), function(node) {\n                                var isSelected = ko.utils.arrayIndexOf(newValue, ko.selectExtensions.readValue(node)) >= 0;\n                                if (node.selected != isSelected) {      // This check prevents flashing of the select element in IE\n                                    ko.utils.setOptionNodeSelectionState(node, isSelected);\n                                }\n                            });\n                        }\n\n                        element.scrollTop = previousScrollTop;\n                    }\n\n                    if (ko.utils.tagNameLower(element) != \"select\") {\n                        throw new Error(\"selectedOptions binding applies only to SELECT elements\");\n                    }\n\n                    var updateFromModelComputed;\n                    ko.bindingEvent.subscribe(element, ko.bindingEvent.childrenComplete, function () {\n                        if (!updateFromModelComputed) {\n                            ko.utils.registerEventHandler(element, \"change\", updateFromView);\n                            updateFromModelComputed = ko.computed(updateFromModel, null, { disposeWhenNodeIsRemoved: element });\n                        } else {\n                            updateFromView();\n                        }\n                    }, null, { 'notifyImmediately': true });\n                },\n                'update': function() {} // Keep for backwards compatibility with code that may have wrapped binding\n            };\n            ko.expressionRewriting.twoWayBindings['selectedOptions'] = true;\n            ko.bindingHandlers['style'] = {\n                'update': function (element, valueAccessor) {\n                    var value = ko.utils.unwrapObservable(valueAccessor() || {});\n                    ko.utils.objectForEach(value, function(styleName, styleValue) {\n                        styleValue = ko.utils.unwrapObservable(styleValue);\n\n                        if (styleValue === null || styleValue === undefined || styleValue === false) {\n                            // Empty string removes the value, whereas null/undefined have no effect\n                            styleValue = \"\";\n                        }\n\n                        if (jQueryInstance) {\n                            jQueryInstance(element)['css'](styleName, styleValue);\n                        } else if (/^--/.test(styleName)) {\n                            // Is styleName a custom CSS property?\n                            element.style.setProperty(styleName, styleValue);\n                        } else {\n                            styleName = styleName.replace(/-(\\w)/g, function (all, letter) {\n                                return letter.toUpperCase();\n                            });\n\n                            var previousStyle = element.style[styleName];\n                            element.style[styleName] = styleValue;\n\n                            if (styleValue !== previousStyle && element.style[styleName] == previousStyle && !isNaN(styleValue)) {\n                                element.style[styleName] = styleValue + \"px\";\n                            }\n                        }\n                    });\n                }\n            };\n            ko.bindingHandlers['submit'] = {\n                'init': function (element, valueAccessor, allBindings, viewModel, bindingContext) {\n                    if (typeof valueAccessor() != \"function\")\n                        throw new Error(\"The value for a submit binding must be a function\");\n                    ko.utils.registerEventHandler(element, \"submit\", function (event) {\n                        var handlerReturnValue;\n                        var value = valueAccessor();\n                        try { handlerReturnValue = value.call(bindingContext['$data'], element); }\n                        finally {\n                            if (handlerReturnValue !== true) { // Normally we want to prevent default action. Developer can override this be explicitly returning true.\n                                if (event.preventDefault)\n                                    event.preventDefault();\n                                else\n                                    event.returnValue = false;\n                            }\n                        }\n                    });\n                }\n            };\n            ko.bindingHandlers['text'] = {\n                'init': function() {\n                    // Prevent binding on the dynamically-injected text node (as developers are unlikely to expect that, and it has security implications).\n                    // It should also make things faster, as we no longer have to consider whether the text node might be bindable.\n                    return { 'controlsDescendantBindings': true };\n                },\n                'update': function (element, valueAccessor) {\n                    ko.utils.setTextContent(element, valueAccessor());\n                }\n            };\n            ko.virtualElements.allowedBindings['text'] = true;\n            (function () {\n\n                if (window && window.navigator) {\n                    var parseVersion = function (matches) {\n                        if (matches) {\n                            return parseFloat(matches[1]);\n                        }\n                    };\n\n                    // Detect various browser versions because some old versions don't fully support the 'input' event\n                    var userAgent = window.navigator.userAgent,\n                        operaVersion, chromeVersion, safariVersion, firefoxVersion, ieVersion, edgeVersion;\n\n                    (operaVersion = window.opera && window.opera.version && parseInt(window.opera.version()))\n                    || (edgeVersion = parseVersion(userAgent.match(/Edge\\/([^ ]+)$/)))\n                    || (chromeVersion = parseVersion(userAgent.match(/Chrome\\/([^ ]+)/)))\n                    || (safariVersion = parseVersion(userAgent.match(/Version\\/([^ ]+) Safari/)))\n                    || (firefoxVersion = parseVersion(userAgent.match(/Firefox\\/([^ ]+)/)))\n                    || (ieVersion = ko.utils.ieVersion || parseVersion(userAgent.match(/MSIE ([^ ]+)/)))      // Detects up to IE 10\n                    || (ieVersion = parseVersion(userAgent.match(/rv:([^ )]+)/)));      // Detects IE 11\n                }\n\n// IE 8 and 9 have bugs that prevent the normal events from firing when the value changes.\n// But it does fire the 'selectionchange' event on many of those, presumably because the\n// cursor is moving and that counts as the selection changing. The 'selectionchange' event is\n// fired at the document level only and doesn't directly indicate which element changed. We\n// set up just one event handler for the document and use 'activeElement' to determine which\n// element was changed.\n                if (ieVersion >= 8 && ieVersion < 10) {\n                    var selectionChangeRegisteredName = ko.utils.domData.nextKey(),\n                        selectionChangeHandlerName = ko.utils.domData.nextKey();\n                    var selectionChangeHandler = function(event) {\n                        var target = this.activeElement,\n                            handler = target && ko.utils.domData.get(target, selectionChangeHandlerName);\n                        if (handler) {\n                            handler(event);\n                        }\n                    };\n                    var registerForSelectionChangeEvent = function (element, handler) {\n                        var ownerDoc = element.ownerDocument;\n                        if (!ko.utils.domData.get(ownerDoc, selectionChangeRegisteredName)) {\n                            ko.utils.domData.set(ownerDoc, selectionChangeRegisteredName, true);\n                            ko.utils.registerEventHandler(ownerDoc, 'selectionchange', selectionChangeHandler);\n                        }\n                        ko.utils.domData.set(element, selectionChangeHandlerName, handler);\n                    };\n                }\n\n                ko.bindingHandlers['textInput'] = {\n                    'init': function (element, valueAccessor, allBindings) {\n\n                        var previousElementValue = element.value,\n                            timeoutHandle,\n                            elementValueBeforeEvent;\n\n                        var updateModel = function (event) {\n                            clearTimeout(timeoutHandle);\n                            elementValueBeforeEvent = timeoutHandle = undefined;\n\n                            var elementValue = element.value;\n                            if (previousElementValue !== elementValue) {\n                                // Provide a way for tests to know exactly which event was processed\n                                if (DEBUG && event) element['_ko_textInputProcessedEvent'] = event.type;\n                                previousElementValue = elementValue;\n                                ko.expressionRewriting.writeValueToProperty(valueAccessor(), allBindings, 'textInput', elementValue);\n                            }\n                        };\n\n                        var deferUpdateModel = function (event) {\n                            if (!timeoutHandle) {\n                                // The elementValueBeforeEvent variable is set *only* during the brief gap between an\n                                // event firing and the updateModel function running. This allows us to ignore model\n                                // updates that are from the previous state of the element, usually due to techniques\n                                // such as rateLimit. Such updates, if not ignored, can cause keystrokes to be lost.\n                                elementValueBeforeEvent = element.value;\n                                var handler = DEBUG ? updateModel.bind(element, {type: event.type}) : updateModel;\n                                timeoutHandle = ko.utils.setTimeout(handler, 4);\n                            }\n                        };\n\n                        // IE9 will mess up the DOM if you handle events synchronously which results in DOM changes (such as other bindings);\n                        // so we'll make sure all updates are asynchronous\n                        var ieUpdateModel = ko.utils.ieVersion == 9 ? deferUpdateModel : updateModel,\n                            ourUpdate = false;\n\n                        var updateView = function () {\n                            var modelValue = ko.utils.unwrapObservable(valueAccessor());\n\n                            if (modelValue === null || modelValue === undefined) {\n                                modelValue = '';\n                            }\n\n                            if (elementValueBeforeEvent !== undefined && modelValue === elementValueBeforeEvent) {\n                                ko.utils.setTimeout(updateView, 4);\n                                return;\n                            }\n\n                            // Update the element only if the element and model are different. On some browsers, updating the value\n                            // will move the cursor to the end of the input, which would be bad while the user is typing.\n                            if (element.value !== modelValue) {\n                                ourUpdate = true;  // Make sure we ignore events (propertychange) that result from updating the value\n                                element.value = modelValue;\n                                ourUpdate = false;\n                                previousElementValue = element.value; // In case the browser changes the value (see #2281)\n                            }\n                        };\n\n                        var onEvent = function (event, handler) {\n                            ko.utils.registerEventHandler(element, event, handler);\n                        };\n\n                        if (DEBUG && ko.bindingHandlers['textInput']['_forceUpdateOn']) {\n                            // Provide a way for tests to specify exactly which events are bound\n                            ko.utils.arrayForEach(ko.bindingHandlers['textInput']['_forceUpdateOn'], function(eventName) {\n                                if (eventName.slice(0,5) == 'after') {\n                                    onEvent(eventName.slice(5), deferUpdateModel);\n                                } else {\n                                    onEvent(eventName, updateModel);\n                                }\n                            });\n                        } else {\n                            if (ieVersion) {\n                                // All versions (including 11) of Internet Explorer have a bug that they don't generate an input or propertychange event when ESC is pressed\n                                onEvent('keypress', updateModel);\n                            }\n                            if (ieVersion < 11) {\n                                // Internet Explorer <= 8 doesn't support the 'input' event, but does include 'propertychange' that fires whenever\n                                // any property of an element changes. Unlike 'input', it also fires if a property is changed from JavaScript code,\n                                // but that's an acceptable compromise for this binding. IE 9 and 10 support 'input', but since they don't always\n                                // fire it when using autocomplete, we'll use 'propertychange' for them also.\n                                onEvent('propertychange', function(event) {\n                                    if (!ourUpdate && event.propertyName === 'value') {\n                                        ieUpdateModel(event);\n                                    }\n                                });\n                            }\n                            if (ieVersion == 8) {\n                                // IE 8 has a bug where it fails to fire 'propertychange' on the first update following a value change from\n                                // JavaScript code. It also doesn't fire if you clear the entire value. To fix this, we bind to the following\n                                // events too.\n                                onEvent('keyup', updateModel);      // A single keystoke\n                                onEvent('keydown', updateModel);    // The first character when a key is held down\n                            }\n                            if (registerForSelectionChangeEvent) {\n                                // Internet Explorer 9 doesn't fire the 'input' event when deleting text, including using\n                                // the backspace, delete, or ctrl-x keys, clicking the 'x' to clear the input, dragging text\n                                // out of the field, and cutting or deleting text using the context menu. 'selectionchange'\n                                // can detect all of those except dragging text out of the field, for which we use 'dragend'.\n                                // These are also needed in IE8 because of the bug described above.\n                                registerForSelectionChangeEvent(element, ieUpdateModel);  // 'selectionchange' covers cut, paste, drop, delete, etc.\n                                onEvent('dragend', deferUpdateModel);\n                            }\n\n                            if (!ieVersion || ieVersion >= 9) {\n                                // All other supported browsers support the 'input' event, which fires whenever the content of the element is changed\n                                // through the user interface.\n                                onEvent('input', ieUpdateModel);\n                            }\n\n                            if (safariVersion < 5 && ko.utils.tagNameLower(element) === \"textarea\") {\n                                // Safari <5 doesn't fire the 'input' event for <textarea> elements (it does fire 'textInput'\n                                // but only when typing). So we'll just catch as much as we can with keydown, cut, and paste.\n                                onEvent('keydown', deferUpdateModel);\n                                onEvent('paste', deferUpdateModel);\n                                onEvent('cut', deferUpdateModel);\n                            } else if (operaVersion < 11) {\n                                // Opera 10 doesn't always fire the 'input' event for cut, paste, undo & drop operations.\n                                // We can try to catch some of those using 'keydown'.\n                                onEvent('keydown', deferUpdateModel);\n                            } else if (firefoxVersion < 4.0) {\n                                // Firefox <= 3.6 doesn't fire the 'input' event when text is filled in through autocomplete\n                                onEvent('DOMAutoComplete', updateModel);\n\n                                // Firefox <=3.5 doesn't fire the 'input' event when text is dropped into the input.\n                                onEvent('dragdrop', updateModel);       // <3.5\n                                onEvent('drop', updateModel);           // 3.5\n                            } else if (edgeVersion && element.type === \"number\") {\n                                // Microsoft Edge doesn't fire 'input' or 'change' events for number inputs when\n                                // the value is changed via the up / down arrow keys\n                                onEvent('keydown', deferUpdateModel);\n                            }\n                        }\n\n                        // Bind to the change event so that we can catch programmatic updates of the value that fire this event.\n                        onEvent('change', updateModel);\n\n                        // To deal with browsers that don't notify any kind of event for some changes (IE, Safari, etc.)\n                        onEvent('blur', updateModel);\n\n                        ko.computed(updateView, null, { disposeWhenNodeIsRemoved: element });\n                    }\n                };\n                ko.expressionRewriting.twoWayBindings['textInput'] = true;\n\n// textinput is an alias for textInput\n                ko.bindingHandlers['textinput'] = {\n                    // preprocess is the only way to set up a full alias\n                    'preprocess': function (value, name, addBinding) {\n                        addBinding('textInput', value);\n                    }\n                };\n\n            })();ko.bindingHandlers['uniqueName'] = {\n                'init': function (element, valueAccessor) {\n                    if (valueAccessor()) {\n                        var name = \"ko_unique_\" + (++ko.bindingHandlers['uniqueName'].currentIndex);\n                        ko.utils.setElementName(element, name);\n                    }\n                }\n            };\n            ko.bindingHandlers['uniqueName'].currentIndex = 0;\n            ko.bindingHandlers['using'] = {\n                'init': function(element, valueAccessor, allBindings, viewModel, bindingContext) {\n                    var options;\n\n                    if (allBindings['has']('as')) {\n                        options = { 'as': allBindings.get('as'), 'noChildContext': allBindings.get('noChildContext') };\n                    }\n\n                    var innerContext = bindingContext['createChildContext'](valueAccessor, options);\n                    ko.applyBindingsToDescendants(innerContext, element);\n\n                    return { 'controlsDescendantBindings': true };\n                }\n            };\n            ko.virtualElements.allowedBindings['using'] = true;\n            ko.bindingHandlers['value'] = {\n                'init': function (element, valueAccessor, allBindings) {\n                    var tagName = ko.utils.tagNameLower(element),\n                        isInputElement = tagName == \"input\";\n\n                    // If the value binding is placed on a radio/checkbox, then just pass through to checkedValue and quit\n                    if (isInputElement && (element.type == \"checkbox\" || element.type == \"radio\")) {\n                        ko.applyBindingAccessorsToNode(element, { 'checkedValue': valueAccessor });\n                        return;\n                    }\n\n                    var eventsToCatch = [];\n                    var requestedEventsToCatch = allBindings.get(\"valueUpdate\");\n                    var propertyChangedFired = false;\n                    var elementValueBeforeEvent = null;\n\n                    if (requestedEventsToCatch) {\n                        // Allow both individual event names, and arrays of event names\n                        if (typeof requestedEventsToCatch == \"string\") {\n                            eventsToCatch = [requestedEventsToCatch];\n                        } else {\n                            eventsToCatch = ko.utils.arrayGetDistinctValues(requestedEventsToCatch);\n                        }\n                        ko.utils.arrayRemoveItem(eventsToCatch, \"change\");  // We'll subscribe to \"change\" events later\n                    }\n\n                    var valueUpdateHandler = function() {\n                        elementValueBeforeEvent = null;\n                        propertyChangedFired = false;\n                        var modelValue = valueAccessor();\n                        var elementValue = ko.selectExtensions.readValue(element);\n                        ko.expressionRewriting.writeValueToProperty(modelValue, allBindings, 'value', elementValue);\n                    }\n\n                    // Workaround for https://github.com/SteveSanderson/knockout/issues/122\n                    // IE doesn't fire \"change\" events on textboxes if the user selects a value from its autocomplete list\n                    var ieAutoCompleteHackNeeded = ko.utils.ieVersion && isInputElement && element.type == \"text\"\n                        && element.autocomplete != \"off\" && (!element.form || element.form.autocomplete != \"off\");\n                    if (ieAutoCompleteHackNeeded && ko.utils.arrayIndexOf(eventsToCatch, \"propertychange\") == -1) {\n                        ko.utils.registerEventHandler(element, \"propertychange\", function () { propertyChangedFired = true });\n                        ko.utils.registerEventHandler(element, \"focus\", function () { propertyChangedFired = false });\n                        ko.utils.registerEventHandler(element, \"blur\", function() {\n                            if (propertyChangedFired) {\n                                valueUpdateHandler();\n                            }\n                        });\n                    }\n\n                    ko.utils.arrayForEach(eventsToCatch, function(eventName) {\n                        // The syntax \"after<eventname>\" means \"run the handler asynchronously after the event\"\n                        // This is useful, for example, to catch \"keydown\" events after the browser has updated the control\n                        // (otherwise, ko.selectExtensions.readValue(this) will receive the control's value *before* the key event)\n                        var handler = valueUpdateHandler;\n                        if (ko.utils.stringStartsWith(eventName, \"after\")) {\n                            handler = function() {\n                                // The elementValueBeforeEvent variable is non-null *only* during the brief gap between\n                                // a keyX event firing and the valueUpdateHandler running, which is scheduled to happen\n                                // at the earliest asynchronous opportunity. We store this temporary information so that\n                                // if, between keyX and valueUpdateHandler, the underlying model value changes separately,\n                                // we can overwrite that model value change with the value the user just typed. Otherwise,\n                                // techniques like rateLimit can trigger model changes at critical moments that will\n                                // override the user's inputs, causing keystrokes to be lost.\n                                elementValueBeforeEvent = ko.selectExtensions.readValue(element);\n                                ko.utils.setTimeout(valueUpdateHandler, 0);\n                            };\n                            eventName = eventName.substring(\"after\".length);\n                        }\n                        ko.utils.registerEventHandler(element, eventName, handler);\n                    });\n\n                    var updateFromModel;\n\n                    if (isInputElement && element.type == \"file\") {\n                        // For file input elements, can only write the empty string\n                        updateFromModel = function () {\n                            var newValue = ko.utils.unwrapObservable(valueAccessor());\n                            if (newValue === null || newValue === undefined || newValue === \"\") {\n                                element.value = \"\";\n                            } else {\n                                ko.dependencyDetection.ignore(valueUpdateHandler);  // reset the model to match the element\n                            }\n                        }\n                    } else {\n                        updateFromModel = function () {\n                            var newValue = ko.utils.unwrapObservable(valueAccessor());\n                            var elementValue = ko.selectExtensions.readValue(element);\n\n                            if (elementValueBeforeEvent !== null && newValue === elementValueBeforeEvent) {\n                                ko.utils.setTimeout(updateFromModel, 0);\n                                return;\n                            }\n\n                            var valueHasChanged = newValue !== elementValue;\n\n                            if (valueHasChanged || elementValue === undefined) {\n                                if (tagName === \"select\") {\n                                    var allowUnset = allBindings.get('valueAllowUnset');\n                                    ko.selectExtensions.writeValue(element, newValue, allowUnset);\n                                    if (!allowUnset && newValue !== ko.selectExtensions.readValue(element)) {\n                                        // If you try to set a model value that can't be represented in an already-populated dropdown, reject that change,\n                                        // because you're not allowed to have a model value that disagrees with a visible UI selection.\n                                        ko.dependencyDetection.ignore(valueUpdateHandler);\n                                    }\n                                } else {\n                                    ko.selectExtensions.writeValue(element, newValue);\n                                }\n                            }\n                        };\n                    }\n\n                    if (tagName === \"select\") {\n                        var updateFromModelComputed;\n                        ko.bindingEvent.subscribe(element, ko.bindingEvent.childrenComplete, function () {\n                            if (!updateFromModelComputed) {\n                                ko.utils.registerEventHandler(element, \"change\", valueUpdateHandler);\n                                updateFromModelComputed = ko.computed(updateFromModel, null, { disposeWhenNodeIsRemoved: element });\n                            } else if (allBindings.get('valueAllowUnset')) {\n                                updateFromModel();\n                            } else {\n                                valueUpdateHandler();\n                            }\n                        }, null, { 'notifyImmediately': true });\n                    } else {\n                        ko.utils.registerEventHandler(element, \"change\", valueUpdateHandler);\n                        ko.computed(updateFromModel, null, { disposeWhenNodeIsRemoved: element });\n                    }\n                },\n                'update': function() {} // Keep for backwards compatibility with code that may have wrapped value binding\n            };\n            ko.expressionRewriting.twoWayBindings['value'] = true;\n            ko.bindingHandlers['visible'] = {\n                'update': function (element, valueAccessor) {\n                    var value = ko.utils.unwrapObservable(valueAccessor());\n                    var isCurrentlyVisible = !(element.style.display == \"none\");\n                    if (value && !isCurrentlyVisible)\n                        element.style.display = \"\";\n                    else if ((!value) && isCurrentlyVisible)\n                        element.style.display = \"none\";\n                }\n            };\n\n            ko.bindingHandlers['hidden'] = {\n                'update': function (element, valueAccessor) {\n                    ko.bindingHandlers['visible']['update'](element, function() { return !ko.utils.unwrapObservable(valueAccessor()) });\n                }\n            };\n// 'click' is just a shorthand for the usual full-length event:{click:handler}\n            makeEventHandlerShortcut('click');\n// If you want to make a custom template engine,\n//\n// [1] Inherit from this class (like ko.nativeTemplateEngine does)\n// [2] Override 'renderTemplateSource', supplying a function with this signature:\n//\n//        function (templateSource, bindingContext, options) {\n//            // - templateSource.text() is the text of the template you should render\n//            // - bindingContext.$data is the data you should pass into the template\n//            //   - you might also want to make bindingContext.$parent, bindingContext.$parents,\n//            //     and bindingContext.$root available in the template too\n//            // - options gives you access to any other properties set on \"data-bind: { template: options }\"\n//            // - templateDocument is the document object of the template\n//            //\n//            // Return value: an array of DOM nodes\n//        }\n//\n// [3] Override 'createJavaScriptEvaluatorBlock', supplying a function with this signature:\n//\n//        function (script) {\n//            // Return value: Whatever syntax means \"Evaluate the JavaScript statement 'script' and output the result\"\n//            //               For example, the jquery.tmpl template engine converts 'someScript' to '${ someScript }'\n//        }\n//\n//     This is only necessary if you want to allow data-bind attributes to reference arbitrary template variables.\n//     If you don't want to allow that, you can set the property 'allowTemplateRewriting' to false (like ko.nativeTemplateEngine does)\n//     and then you don't need to override 'createJavaScriptEvaluatorBlock'.\n\n            ko.templateEngine = function () { };\n\n            ko.templateEngine.prototype['renderTemplateSource'] = function (templateSource, bindingContext, options, templateDocument) {\n                throw new Error(\"Override renderTemplateSource\");\n            };\n\n            ko.templateEngine.prototype['createJavaScriptEvaluatorBlock'] = function (script) {\n                throw new Error(\"Override createJavaScriptEvaluatorBlock\");\n            };\n\n            ko.templateEngine.prototype['makeTemplateSource'] = function(template, templateDocument) {\n                // Named template\n                if (typeof template == \"string\") {\n                    templateDocument = templateDocument || document;\n                    var elem = templateDocument.getElementById(template);\n                    if (!elem)\n                        throw new Error(\"Cannot find template with ID \" + template);\n                    return new ko.templateSources.domElement(elem);\n                } else if ((template.nodeType == 1) || (template.nodeType == 8)) {\n                    // Anonymous template\n                    return new ko.templateSources.anonymousTemplate(template);\n                } else\n                    throw new Error(\"Unknown template type: \" + template);\n            };\n\n            ko.templateEngine.prototype['renderTemplate'] = function (template, bindingContext, options, templateDocument) {\n                var templateSource = this['makeTemplateSource'](template, templateDocument);\n                return this['renderTemplateSource'](templateSource, bindingContext, options, templateDocument);\n            };\n\n            ko.templateEngine.prototype['isTemplateRewritten'] = function (template, templateDocument) {\n                // Skip rewriting if requested\n                if (this['allowTemplateRewriting'] === false)\n                    return true;\n                return this['makeTemplateSource'](template, templateDocument)['data'](\"isRewritten\");\n            };\n\n            ko.templateEngine.prototype['rewriteTemplate'] = function (template, rewriterCallback, templateDocument) {\n                var templateSource = this['makeTemplateSource'](template, templateDocument);\n                var rewritten = rewriterCallback(templateSource['text']());\n                templateSource['text'](rewritten);\n                templateSource['data'](\"isRewritten\", true);\n            };\n\n            ko.exportSymbol('templateEngine', ko.templateEngine);\n\n            ko.templateRewriting = (function () {\n                var memoizeDataBindingAttributeSyntaxRegex = /(<([a-z]+\\d*)(?:\\s+(?!data-bind\\s*=\\s*)[a-z0-9\\-]+(?:=(?:\\\"[^\\\"]*\\\"|\\'[^\\']*\\'|[^>]*))?)*\\s+)data-bind\\s*=\\s*([\"'])([\\s\\S]*?)\\3/gi;\n                var memoizeVirtualContainerBindingSyntaxRegex = /<!--\\s*ko\\b\\s*([\\s\\S]*?)\\s*-->/g;\n\n                function validateDataBindValuesForRewriting(keyValueArray) {\n                    var allValidators = ko.expressionRewriting.bindingRewriteValidators;\n                    for (var i = 0; i < keyValueArray.length; i++) {\n                        var key = keyValueArray[i]['key'];\n                        if (Object.prototype.hasOwnProperty.call(allValidators, key)) {\n                            var validator = allValidators[key];\n\n                            if (typeof validator === \"function\") {\n                                var possibleErrorMessage = validator(keyValueArray[i]['value']);\n                                if (possibleErrorMessage)\n                                    throw new Error(possibleErrorMessage);\n                            } else if (!validator) {\n                                throw new Error(\"This template engine does not support the '\" + key + \"' binding within its templates\");\n                            }\n                        }\n                    }\n                }\n\n                function constructMemoizedTagReplacement(dataBindAttributeValue, tagToRetain, nodeName, templateEngine) {\n                    var dataBindKeyValueArray = ko.expressionRewriting.parseObjectLiteral(dataBindAttributeValue);\n                    validateDataBindValuesForRewriting(dataBindKeyValueArray);\n                    var rewrittenDataBindAttributeValue = ko.expressionRewriting.preProcessBindings(dataBindKeyValueArray, {'valueAccessors':true});\n\n                    // For no obvious reason, Opera fails to evaluate rewrittenDataBindAttributeValue unless it's wrapped in an additional\n                    // anonymous function, even though Opera's built-in debugger can evaluate it anyway. No other browser requires this\n                    // extra indirection.\n                    var applyBindingsToNextSiblingScript =\n                        \"ko.__tr_ambtns(function($context,$element){return(function(){return{ \" + rewrittenDataBindAttributeValue + \" } })()},'\" + nodeName.toLowerCase() + \"')\";\n                    return templateEngine['createJavaScriptEvaluatorBlock'](applyBindingsToNextSiblingScript) + tagToRetain;\n                }\n\n                return {\n                    ensureTemplateIsRewritten: function (template, templateEngine, templateDocument) {\n                        if (!templateEngine['isTemplateRewritten'](template, templateDocument))\n                            templateEngine['rewriteTemplate'](template, function (htmlString) {\n                                return ko.templateRewriting.memoizeBindingAttributeSyntax(htmlString, templateEngine);\n                            }, templateDocument);\n                    },\n\n                    memoizeBindingAttributeSyntax: function (htmlString, templateEngine) {\n                        return htmlString.replace(memoizeDataBindingAttributeSyntaxRegex, function () {\n                            return constructMemoizedTagReplacement(/* dataBindAttributeValue: */ arguments[4], /* tagToRetain: */ arguments[1], /* nodeName: */ arguments[2], templateEngine);\n                        }).replace(memoizeVirtualContainerBindingSyntaxRegex, function() {\n                            return constructMemoizedTagReplacement(/* dataBindAttributeValue: */ arguments[1], /* tagToRetain: */ \"<!-- ko -->\", /* nodeName: */ \"#comment\", templateEngine);\n                        });\n                    },\n\n                    applyMemoizedBindingsToNextSibling: function (bindings, nodeName) {\n                        return ko.memoization.memoize(function (domNode, bindingContext) {\n                            var nodeToBind = domNode.nextSibling;\n                            if (nodeToBind && nodeToBind.nodeName.toLowerCase() === nodeName) {\n                                ko.applyBindingAccessorsToNode(nodeToBind, bindings, bindingContext);\n                            }\n                        });\n                    }\n                }\n            })();\n\n\n// Exported only because it has to be referenced by string lookup from within rewritten template\n            ko.exportSymbol('__tr_ambtns', ko.templateRewriting.applyMemoizedBindingsToNextSibling);\n            (function() {\n                // A template source represents a read/write way of accessing a template. This is to eliminate the need for template loading/saving\n                // logic to be duplicated in every template engine (and means they can all work with anonymous templates, etc.)\n                //\n                // Two are provided by default:\n                //  1. ko.templateSources.domElement       - reads/writes the text content of an arbitrary DOM element\n                //  2. ko.templateSources.anonymousElement - uses ko.utils.domData to read/write text *associated* with the DOM element, but\n                //                                           without reading/writing the actual element text content, since it will be overwritten\n                //                                           with the rendered template output.\n                // You can implement your own template source if you want to fetch/store templates somewhere other than in DOM elements.\n                // Template sources need to have the following functions:\n                //   text() \t\t\t- returns the template text from your storage location\n                //   text(value)\t\t- writes the supplied template text to your storage location\n                //   data(key)\t\t\t- reads values stored using data(key, value) - see below\n                //   data(key, value)\t- associates \"value\" with this template and the key \"key\". Is used to store information like \"isRewritten\".\n                //\n                // Optionally, template sources can also have the following functions:\n                //   nodes()            - returns a DOM element containing the nodes of this template, where available\n                //   nodes(value)       - writes the given DOM element to your storage location\n                // If a DOM element is available for a given template source, template engines are encouraged to use it in preference over text()\n                // for improved speed. However, all templateSources must supply text() even if they don't supply nodes().\n                //\n                // Once you've implemented a templateSource, make your template engine use it by subclassing whatever template engine you were\n                // using and overriding \"makeTemplateSource\" to return an instance of your custom template source.\n\n                ko.templateSources = {};\n\n                // ---- ko.templateSources.domElement -----\n\n                // template types\n                var templateScript = 1,\n                    templateTextArea = 2,\n                    templateTemplate = 3,\n                    templateElement = 4;\n\n                ko.templateSources.domElement = function(element) {\n                    this.domElement = element;\n\n                    if (element) {\n                        var tagNameLower = ko.utils.tagNameLower(element);\n                        this.templateType =\n                            tagNameLower === \"script\" ? templateScript :\n                                tagNameLower === \"textarea\" ? templateTextArea :\n                                    // For browsers with proper <template> element support, where the .content property gives a document fragment\n                                    tagNameLower == \"template\" && element.content && element.content.nodeType === 11 ? templateTemplate :\n                                        templateElement;\n                    }\n                }\n\n                ko.templateSources.domElement.prototype['text'] = function(/* valueToWrite */) {\n                    var elemContentsProperty = this.templateType === templateScript ? \"text\"\n                        : this.templateType === templateTextArea ? \"value\"\n                            : \"innerHTML\";\n\n                    if (arguments.length == 0) {\n                        return this.domElement[elemContentsProperty];\n                    } else {\n                        var valueToWrite = arguments[0];\n                        if (elemContentsProperty === \"innerHTML\")\n                            ko.utils.setHtml(this.domElement, valueToWrite);\n                        else\n                            this.domElement[elemContentsProperty] = valueToWrite;\n                    }\n                };\n\n                var dataDomDataPrefix = ko.utils.domData.nextKey() + \"_\";\n                ko.templateSources.domElement.prototype['data'] = function(key /*, valueToWrite */) {\n                    if (arguments.length === 1) {\n                        return ko.utils.domData.get(this.domElement, dataDomDataPrefix + key);\n                    } else {\n                        ko.utils.domData.set(this.domElement, dataDomDataPrefix + key, arguments[1]);\n                    }\n                };\n\n                var templatesDomDataKey = ko.utils.domData.nextKey();\n                function getTemplateDomData(element) {\n                    return ko.utils.domData.get(element, templatesDomDataKey) || {};\n                }\n                function setTemplateDomData(element, data) {\n                    ko.utils.domData.set(element, templatesDomDataKey, data);\n                }\n\n                ko.templateSources.domElement.prototype['nodes'] = function(/* valueToWrite */) {\n                    var element = this.domElement;\n                    if (arguments.length == 0) {\n                        var templateData = getTemplateDomData(element),\n                            nodes = templateData.containerData || (\n                                this.templateType === templateTemplate ? element.content :\n                                    this.templateType === templateElement ? element :\n                                        undefined);\n                        if (!nodes || templateData.alwaysCheckText) {\n                            // If the template is associated with an element that stores the template as text,\n                            // parse and cache the nodes whenever there's new text content available. This allows\n                            // the user to update the template content by updating the text of template node.\n                            var text = this['text']();\n                            if (text && text !== templateData.textData) {\n                                nodes = ko.utils.parseHtmlForTemplateNodes(text, element.ownerDocument);\n                                setTemplateDomData(element, {containerData: nodes, textData: text, alwaysCheckText: true});\n                            }\n                        }\n                        return nodes;\n                    } else {\n                        var valueToWrite = arguments[0];\n                        if (this.templateType !== undefined) {\n                            this['text'](\"\");   // clear the text from the node\n                        }\n                        setTemplateDomData(element, {containerData: valueToWrite});\n                    }\n                };\n\n                // ---- ko.templateSources.anonymousTemplate -----\n                // Anonymous templates are normally saved/retrieved as DOM nodes through \"nodes\".\n                // For compatibility, you can also read \"text\"; it will be serialized from the nodes on demand.\n                // Writing to \"text\" is still supported, but then the template data will not be available as DOM nodes.\n\n                ko.templateSources.anonymousTemplate = function(element) {\n                    this.domElement = element;\n                }\n                ko.templateSources.anonymousTemplate.prototype = new ko.templateSources.domElement();\n                ko.templateSources.anonymousTemplate.prototype.constructor = ko.templateSources.anonymousTemplate;\n                ko.templateSources.anonymousTemplate.prototype['text'] = function(/* valueToWrite */) {\n                    if (arguments.length == 0) {\n                        var templateData = getTemplateDomData(this.domElement);\n                        if (templateData.textData === undefined && templateData.containerData)\n                            templateData.textData = templateData.containerData.innerHTML;\n                        return templateData.textData;\n                    } else {\n                        var valueToWrite = arguments[0];\n                        setTemplateDomData(this.domElement, {textData: valueToWrite});\n                    }\n                };\n\n                ko.exportSymbol('templateSources', ko.templateSources);\n                ko.exportSymbol('templateSources.domElement', ko.templateSources.domElement);\n                ko.exportSymbol('templateSources.anonymousTemplate', ko.templateSources.anonymousTemplate);\n            })();\n            (function () {\n                var _templateEngine;\n                ko.setTemplateEngine = function (templateEngine) {\n                    if ((templateEngine != undefined) && !(templateEngine instanceof ko.templateEngine))\n                        throw new Error(\"templateEngine must inherit from ko.templateEngine\");\n                    _templateEngine = templateEngine;\n                }\n\n                function invokeForEachNodeInContinuousRange(firstNode, lastNode, action) {\n                    var node, nextInQueue = firstNode, firstOutOfRangeNode = ko.virtualElements.nextSibling(lastNode);\n                    while (nextInQueue && ((node = nextInQueue) !== firstOutOfRangeNode)) {\n                        nextInQueue = ko.virtualElements.nextSibling(node);\n                        action(node, nextInQueue);\n                    }\n                }\n\n                function activateBindingsOnContinuousNodeArray(continuousNodeArray, bindingContext) {\n                    // To be used on any nodes that have been rendered by a template and have been inserted into some parent element\n                    // Walks through continuousNodeArray (which *must* be continuous, i.e., an uninterrupted sequence of sibling nodes, because\n                    // the algorithm for walking them relies on this), and for each top-level item in the virtual-element sense,\n                    // (1) Does a regular \"applyBindings\" to associate bindingContext with this node and to activate any non-memoized bindings\n                    // (2) Unmemoizes any memos in the DOM subtree (e.g., to activate bindings that had been memoized during template rewriting)\n\n                    if (continuousNodeArray.length) {\n                        var firstNode = continuousNodeArray[0],\n                            lastNode = continuousNodeArray[continuousNodeArray.length - 1],\n                            parentNode = firstNode.parentNode,\n                            provider = ko.bindingProvider['instance'],\n                            preprocessNode = provider['preprocessNode'];\n\n                        if (preprocessNode) {\n                            invokeForEachNodeInContinuousRange(firstNode, lastNode, function(node, nextNodeInRange) {\n                                var nodePreviousSibling = node.previousSibling;\n                                var newNodes = preprocessNode.call(provider, node);\n                                if (newNodes) {\n                                    if (node === firstNode)\n                                        firstNode = newNodes[0] || nextNodeInRange;\n                                    if (node === lastNode)\n                                        lastNode = newNodes[newNodes.length - 1] || nodePreviousSibling;\n                                }\n                            });\n\n                            // Because preprocessNode can change the nodes, including the first and last nodes, update continuousNodeArray to match.\n                            // We need the full set, including inner nodes, because the unmemoize step might remove the first node (and so the real\n                            // first node needs to be in the array).\n                            continuousNodeArray.length = 0;\n                            if (!firstNode) { // preprocessNode might have removed all the nodes, in which case there's nothing left to do\n                                return;\n                            }\n                            if (firstNode === lastNode) {\n                                continuousNodeArray.push(firstNode);\n                            } else {\n                                continuousNodeArray.push(firstNode, lastNode);\n                                ko.utils.fixUpContinuousNodeArray(continuousNodeArray, parentNode);\n                            }\n                        }\n\n                        // Need to applyBindings *before* unmemoziation, because unmemoization might introduce extra nodes (that we don't want to re-bind)\n                        // whereas a regular applyBindings won't introduce new memoized nodes\n                        invokeForEachNodeInContinuousRange(firstNode, lastNode, function(node) {\n                            if (node.nodeType === 1 || node.nodeType === 8)\n                                ko.applyBindings(bindingContext, node);\n                        });\n                        invokeForEachNodeInContinuousRange(firstNode, lastNode, function(node) {\n                            if (node.nodeType === 1 || node.nodeType === 8)\n                                ko.memoization.unmemoizeDomNodeAndDescendants(node, [bindingContext]);\n                        });\n\n                        // Make sure any changes done by applyBindings or unmemoize are reflected in the array\n                        ko.utils.fixUpContinuousNodeArray(continuousNodeArray, parentNode);\n                    }\n                }\n\n                function getFirstNodeFromPossibleArray(nodeOrNodeArray) {\n                    return nodeOrNodeArray.nodeType ? nodeOrNodeArray\n                        : nodeOrNodeArray.length > 0 ? nodeOrNodeArray[0]\n                            : null;\n                }\n\n                function executeTemplate(targetNodeOrNodeArray, renderMode, template, bindingContext, options) {\n                    options = options || {};\n                    var firstTargetNode = targetNodeOrNodeArray && getFirstNodeFromPossibleArray(targetNodeOrNodeArray);\n                    var templateDocument = (firstTargetNode || template || {}).ownerDocument;\n                    var templateEngineToUse = (options['templateEngine'] || _templateEngine);\n                    ko.templateRewriting.ensureTemplateIsRewritten(template, templateEngineToUse, templateDocument);\n                    var renderedNodesArray = templateEngineToUse['renderTemplate'](template, bindingContext, options, templateDocument);\n\n                    // Loosely check result is an array of DOM nodes\n                    if ((typeof renderedNodesArray.length != \"number\") || (renderedNodesArray.length > 0 && typeof renderedNodesArray[0].nodeType != \"number\"))\n                        throw new Error(\"Template engine must return an array of DOM nodes\");\n\n                    var haveAddedNodesToParent = false;\n                    switch (renderMode) {\n                        case \"replaceChildren\":\n                            ko.virtualElements.setDomNodeChildren(targetNodeOrNodeArray, renderedNodesArray);\n                            haveAddedNodesToParent = true;\n                            break;\n                        case \"replaceNode\":\n                            ko.utils.replaceDomNodes(targetNodeOrNodeArray, renderedNodesArray);\n                            haveAddedNodesToParent = true;\n                            break;\n                        case \"ignoreTargetNode\": break;\n                        default:\n                            throw new Error(\"Unknown renderMode: \" + renderMode);\n                    }\n\n                    if (haveAddedNodesToParent) {\n                        activateBindingsOnContinuousNodeArray(renderedNodesArray, bindingContext);\n                        if (options['afterRender']) {\n                            ko.dependencyDetection.ignore(options['afterRender'], null, [renderedNodesArray, bindingContext[options['as'] || '$data']]);\n                        }\n                        if (renderMode == \"replaceChildren\") {\n                            ko.bindingEvent.notify(targetNodeOrNodeArray, ko.bindingEvent.childrenComplete);\n                        }\n                    }\n\n                    return renderedNodesArray;\n                }\n\n                function resolveTemplateName(template, data, context) {\n                    // The template can be specified as:\n                    if (ko.isObservable(template)) {\n                        // 1. An observable, with string value\n                        return template();\n                    } else if (typeof template === 'function') {\n                        // 2. A function of (data, context) returning a string\n                        return template(data, context);\n                    } else {\n                        // 3. A string\n                        return template;\n                    }\n                }\n\n                ko.renderTemplate = function (template, dataOrBindingContext, options, targetNodeOrNodeArray, renderMode) {\n                    options = options || {};\n                    if ((options['templateEngine'] || _templateEngine) == undefined)\n                        throw new Error(\"Set a template engine before calling renderTemplate\");\n                    renderMode = renderMode || \"replaceChildren\";\n\n                    if (targetNodeOrNodeArray) {\n                        var firstTargetNode = getFirstNodeFromPossibleArray(targetNodeOrNodeArray);\n\n                        var whenToDispose = function () { return (!firstTargetNode) || !ko.utils.domNodeIsAttachedToDocument(firstTargetNode); }; // Passive disposal (on next evaluation)\n                        var activelyDisposeWhenNodeIsRemoved = (firstTargetNode && renderMode == \"replaceNode\") ? firstTargetNode.parentNode : firstTargetNode;\n\n                        return ko.dependentObservable( // So the DOM is automatically updated when any dependency changes\n                            function () {\n                                // Ensure we've got a proper binding context to work with\n                                var bindingContext = (dataOrBindingContext && (dataOrBindingContext instanceof ko.bindingContext))\n                                    ? dataOrBindingContext\n                                    : new ko.bindingContext(dataOrBindingContext, null, null, null, { \"exportDependencies\": true });\n\n                                var templateName = resolveTemplateName(template, bindingContext['$data'], bindingContext),\n                                    renderedNodesArray = executeTemplate(targetNodeOrNodeArray, renderMode, templateName, bindingContext, options);\n\n                                if (renderMode == \"replaceNode\") {\n                                    targetNodeOrNodeArray = renderedNodesArray;\n                                    firstTargetNode = getFirstNodeFromPossibleArray(targetNodeOrNodeArray);\n                                }\n                            },\n                            null,\n                            { disposeWhen: whenToDispose, disposeWhenNodeIsRemoved: activelyDisposeWhenNodeIsRemoved }\n                        );\n                    } else {\n                        // We don't yet have a DOM node to evaluate, so use a memo and render the template later when there is a DOM node\n                        return ko.memoization.memoize(function (domNode) {\n                            ko.renderTemplate(template, dataOrBindingContext, options, domNode, \"replaceNode\");\n                        });\n                    }\n                };\n\n                ko.renderTemplateForEach = function (template, arrayOrObservableArray, options, targetNode, parentBindingContext) {\n                    // Since setDomNodeChildrenFromArrayMapping always calls executeTemplateForArrayItem and then\n                    // activateBindingsCallback for added items, we can store the binding context in the former to use in the latter.\n                    var arrayItemContext, asName = options['as'];\n\n                    // This will be called by setDomNodeChildrenFromArrayMapping to get the nodes to add to targetNode\n                    var executeTemplateForArrayItem = function (arrayValue, index) {\n                        // Support selecting template as a function of the data being rendered\n                        arrayItemContext = parentBindingContext['createChildContext'](arrayValue, {\n                            'as': asName,\n                            'noChildContext': options['noChildContext'],\n                            'extend': function(context) {\n                                context['$index'] = index;\n                                if (asName) {\n                                    context[asName + \"Index\"] = index;\n                                }\n                            }\n                        });\n\n                        var templateName = resolveTemplateName(template, arrayValue, arrayItemContext);\n                        return executeTemplate(targetNode, \"ignoreTargetNode\", templateName, arrayItemContext, options);\n                    };\n\n                    // This will be called whenever setDomNodeChildrenFromArrayMapping has added nodes to targetNode\n                    var activateBindingsCallback = function(arrayValue, addedNodesArray, index) {\n                        activateBindingsOnContinuousNodeArray(addedNodesArray, arrayItemContext);\n                        if (options['afterRender'])\n                            options['afterRender'](addedNodesArray, arrayValue);\n\n                        // release the \"cache\" variable, so that it can be collected by\n                        // the GC when its value isn't used from within the bindings anymore.\n                        arrayItemContext = null;\n                    };\n\n                    var setDomNodeChildrenFromArrayMapping = function (newArray, changeList) {\n                        // Call setDomNodeChildrenFromArrayMapping, ignoring any observables unwrapped within (most likely from a callback function).\n                        // If the array items are observables, though, they will be unwrapped in executeTemplateForArrayItem and managed within setDomNodeChildrenFromArrayMapping.\n                        ko.dependencyDetection.ignore(ko.utils.setDomNodeChildrenFromArrayMapping, null, [targetNode, newArray, executeTemplateForArrayItem, options, activateBindingsCallback, changeList]);\n                        ko.bindingEvent.notify(targetNode, ko.bindingEvent.childrenComplete);\n                    };\n\n                    var shouldHideDestroyed = (options['includeDestroyed'] === false) || (ko.options['foreachHidesDestroyed'] && !options['includeDestroyed']);\n\n                    if (!shouldHideDestroyed && !options['beforeRemove'] && ko.isObservableArray(arrayOrObservableArray)) {\n                        setDomNodeChildrenFromArrayMapping(arrayOrObservableArray.peek());\n\n                        var subscription = arrayOrObservableArray.subscribe(function (changeList) {\n                            setDomNodeChildrenFromArrayMapping(arrayOrObservableArray(), changeList);\n                        }, null, \"arrayChange\");\n                        subscription.disposeWhenNodeIsRemoved(targetNode);\n\n                        return subscription;\n                    } else {\n                        return ko.dependentObservable(function () {\n                            var unwrappedArray = ko.utils.unwrapObservable(arrayOrObservableArray) || [];\n                            if (typeof unwrappedArray.length == \"undefined\") // Coerce single value into array\n                                unwrappedArray = [unwrappedArray];\n\n                            if (shouldHideDestroyed) {\n                                // Filter out any entries marked as destroyed\n                                unwrappedArray = ko.utils.arrayFilter(unwrappedArray, function(item) {\n                                    return item === undefined || item === null || !ko.utils.unwrapObservable(item['_destroy']);\n                                });\n                            }\n                            setDomNodeChildrenFromArrayMapping(unwrappedArray);\n\n                        }, null, { disposeWhenNodeIsRemoved: targetNode });\n                    }\n                };\n\n                var templateComputedDomDataKey = ko.utils.domData.nextKey();\n                function disposeOldComputedAndStoreNewOne(element, newComputed) {\n                    var oldComputed = ko.utils.domData.get(element, templateComputedDomDataKey);\n                    if (oldComputed && (typeof(oldComputed.dispose) == 'function'))\n                        oldComputed.dispose();\n                    ko.utils.domData.set(element, templateComputedDomDataKey, (newComputed && (!newComputed.isActive || newComputed.isActive())) ? newComputed : undefined);\n                }\n\n                var cleanContainerDomDataKey = ko.utils.domData.nextKey();\n                ko.bindingHandlers['template'] = {\n                    'init': function(element, valueAccessor) {\n                        // Support anonymous templates\n                        var bindingValue = ko.utils.unwrapObservable(valueAccessor());\n                        if (typeof bindingValue == \"string\" || 'name' in bindingValue) {\n                            // It's a named template - clear the element\n                            ko.virtualElements.emptyNode(element);\n                        } else if ('nodes' in bindingValue) {\n                            // We've been given an array of DOM nodes. Save them as the template source.\n                            // There is no known use case for the node array being an observable array (if the output\n                            // varies, put that behavior *into* your template - that's what templates are for), and\n                            // the implementation would be a mess, so assert that it's not observable.\n                            var nodes = bindingValue['nodes'] || [];\n                            if (ko.isObservable(nodes)) {\n                                throw new Error('The \"nodes\" option must be a plain, non-observable array.');\n                            }\n\n                            // If the nodes are already attached to a KO-generated container, we reuse that container without moving the\n                            // elements to a new one (we check only the first node, as the nodes are always moved together)\n                            var container = nodes[0] && nodes[0].parentNode;\n                            if (!container || !ko.utils.domData.get(container, cleanContainerDomDataKey)) {\n                                container = ko.utils.moveCleanedNodesToContainerElement(nodes);\n                                ko.utils.domData.set(container, cleanContainerDomDataKey, true);\n                            }\n\n                            new ko.templateSources.anonymousTemplate(element)['nodes'](container);\n                        } else {\n                            // It's an anonymous template - store the element contents, then clear the element\n                            var templateNodes = ko.virtualElements.childNodes(element);\n                            if (templateNodes.length > 0) {\n                                var container = ko.utils.moveCleanedNodesToContainerElement(templateNodes); // This also removes the nodes from their current parent\n                                new ko.templateSources.anonymousTemplate(element)['nodes'](container);\n                            } else {\n                                throw new Error(\"Anonymous template defined, but no template content was provided\");\n                            }\n                        }\n                        return { 'controlsDescendantBindings': true };\n                    },\n                    'update': function (element, valueAccessor, allBindings, viewModel, bindingContext) {\n                        var value = valueAccessor(),\n                            options = ko.utils.unwrapObservable(value),\n                            shouldDisplay = true,\n                            templateComputed = null,\n                            template;\n\n                        if (typeof options == \"string\") {\n                            template = value;\n                            options = {};\n                        } else {\n                            template = 'name' in options ? options['name'] : element;\n\n                            // Support \"if\"/\"ifnot\" conditions\n                            if ('if' in options)\n                                shouldDisplay = ko.utils.unwrapObservable(options['if']);\n                            if (shouldDisplay && 'ifnot' in options)\n                                shouldDisplay = !ko.utils.unwrapObservable(options['ifnot']);\n\n                            // Don't show anything if an empty name is given (see #2446)\n                            if (shouldDisplay && !template) {\n                                shouldDisplay = false;\n                            }\n                        }\n\n                        if ('foreach' in options) {\n                            // Render once for each data point (treating data set as empty if shouldDisplay==false)\n                            var dataArray = (shouldDisplay && options['foreach']) || [];\n                            templateComputed = ko.renderTemplateForEach(template, dataArray, options, element, bindingContext);\n                        } else if (!shouldDisplay) {\n                            ko.virtualElements.emptyNode(element);\n                        } else {\n                            // Render once for this single data point (or use the viewModel if no data was provided)\n                            var innerBindingContext = bindingContext;\n                            if ('data' in options) {\n                                innerBindingContext = bindingContext['createChildContext'](options['data'], {\n                                    'as': options['as'],\n                                    'noChildContext': options['noChildContext'],\n                                    'exportDependencies': true\n                                });\n                            }\n                            templateComputed = ko.renderTemplate(template, innerBindingContext, options, element);\n                        }\n\n                        // It only makes sense to have a single template computed per element (otherwise which one should have its output displayed?)\n                        disposeOldComputedAndStoreNewOne(element, templateComputed);\n                    }\n                };\n\n                // Anonymous templates can't be rewritten. Give a nice error message if you try to do it.\n                ko.expressionRewriting.bindingRewriteValidators['template'] = function(bindingValue) {\n                    var parsedBindingValue = ko.expressionRewriting.parseObjectLiteral(bindingValue);\n\n                    if ((parsedBindingValue.length == 1) && parsedBindingValue[0]['unknown'])\n                        return null; // It looks like a string literal, not an object literal, so treat it as a named template (which is allowed for rewriting)\n\n                    if (ko.expressionRewriting.keyValueArrayContainsKey(parsedBindingValue, \"name\"))\n                        return null; // Named templates can be rewritten, so return \"no error\"\n                    return \"This template engine does not support anonymous templates nested within its templates\";\n                };\n\n                ko.virtualElements.allowedBindings['template'] = true;\n            })();\n\n            ko.exportSymbol('setTemplateEngine', ko.setTemplateEngine);\n            ko.exportSymbol('renderTemplate', ko.renderTemplate);\n// Go through the items that have been added and deleted and try to find matches between them.\n            ko.utils.findMovesInArrayComparison = function (left, right, limitFailedCompares) {\n                if (left.length && right.length) {\n                    var failedCompares, l, r, leftItem, rightItem;\n                    for (failedCompares = l = 0; (!limitFailedCompares || failedCompares < limitFailedCompares) && (leftItem = left[l]); ++l) {\n                        for (r = 0; rightItem = right[r]; ++r) {\n                            if (leftItem['value'] === rightItem['value']) {\n                                leftItem['moved'] = rightItem['index'];\n                                rightItem['moved'] = leftItem['index'];\n                                right.splice(r, 1);         // This item is marked as moved; so remove it from right list\n                                failedCompares = r = 0;     // Reset failed compares count because we're checking for consecutive failures\n                                break;\n                            }\n                        }\n                        failedCompares += r;\n                    }\n                }\n            };\n\n            ko.utils.compareArrays = (function () {\n                var statusNotInOld = 'added', statusNotInNew = 'deleted';\n\n                // Simple calculation based on Levenshtein distance.\n                function compareArrays(oldArray, newArray, options) {\n                    // For backward compatibility, if the third arg is actually a bool, interpret\n                    // it as the old parameter 'dontLimitMoves'. Newer code should use { dontLimitMoves: true }.\n                    options = (typeof options === 'boolean') ? { 'dontLimitMoves': options } : (options || {});\n                    oldArray = oldArray || [];\n                    newArray = newArray || [];\n\n                    if (oldArray.length < newArray.length)\n                        return compareSmallArrayToBigArray(oldArray, newArray, statusNotInOld, statusNotInNew, options);\n                    else\n                        return compareSmallArrayToBigArray(newArray, oldArray, statusNotInNew, statusNotInOld, options);\n                }\n\n                function compareSmallArrayToBigArray(smlArray, bigArray, statusNotInSml, statusNotInBig, options) {\n                    var myMin = Math.min,\n                        myMax = Math.max,\n                        editDistanceMatrix = [],\n                        smlIndex, smlIndexMax = smlArray.length,\n                        bigIndex, bigIndexMax = bigArray.length,\n                        compareRange = (bigIndexMax - smlIndexMax) || 1,\n                        maxDistance = smlIndexMax + bigIndexMax + 1,\n                        thisRow, lastRow,\n                        bigIndexMaxForRow, bigIndexMinForRow;\n\n                    for (smlIndex = 0; smlIndex <= smlIndexMax; smlIndex++) {\n                        lastRow = thisRow;\n                        editDistanceMatrix.push(thisRow = []);\n                        bigIndexMaxForRow = myMin(bigIndexMax, smlIndex + compareRange);\n                        bigIndexMinForRow = myMax(0, smlIndex - 1);\n                        for (bigIndex = bigIndexMinForRow; bigIndex <= bigIndexMaxForRow; bigIndex++) {\n                            if (!bigIndex)\n                                thisRow[bigIndex] = smlIndex + 1;\n                            else if (!smlIndex)  // Top row - transform empty array into new array via additions\n                                thisRow[bigIndex] = bigIndex + 1;\n                            else if (smlArray[smlIndex - 1] === bigArray[bigIndex - 1])\n                                thisRow[bigIndex] = lastRow[bigIndex - 1];                  // copy value (no edit)\n                            else {\n                                var northDistance = lastRow[bigIndex] || maxDistance;       // not in big (deletion)\n                                var westDistance = thisRow[bigIndex - 1] || maxDistance;    // not in small (addition)\n                                thisRow[bigIndex] = myMin(northDistance, westDistance) + 1;\n                            }\n                        }\n                    }\n\n                    var editScript = [], meMinusOne, notInSml = [], notInBig = [];\n                    for (smlIndex = smlIndexMax, bigIndex = bigIndexMax; smlIndex || bigIndex;) {\n                        meMinusOne = editDistanceMatrix[smlIndex][bigIndex] - 1;\n                        if (bigIndex && meMinusOne === editDistanceMatrix[smlIndex][bigIndex-1]) {\n                            notInSml.push(editScript[editScript.length] = {     // added\n                                'status': statusNotInSml,\n                                'value': bigArray[--bigIndex],\n                                'index': bigIndex });\n                        } else if (smlIndex && meMinusOne === editDistanceMatrix[smlIndex - 1][bigIndex]) {\n                            notInBig.push(editScript[editScript.length] = {     // deleted\n                                'status': statusNotInBig,\n                                'value': smlArray[--smlIndex],\n                                'index': smlIndex });\n                        } else {\n                            --bigIndex;\n                            --smlIndex;\n                            if (!options['sparse']) {\n                                editScript.push({\n                                    'status': \"retained\",\n                                    'value': bigArray[bigIndex] });\n                            }\n                        }\n                    }\n\n                    // Set a limit on the number of consecutive non-matching comparisons; having it a multiple of\n                    // smlIndexMax keeps the time complexity of this algorithm linear.\n                    ko.utils.findMovesInArrayComparison(notInBig, notInSml, !options['dontLimitMoves'] && smlIndexMax * 10);\n\n                    return editScript.reverse();\n                }\n\n                return compareArrays;\n            })();\n\n            ko.exportSymbol('utils.compareArrays', ko.utils.compareArrays);\n            (function () {\n                // Objective:\n                // * Given an input array, a container DOM node, and a function from array elements to arrays of DOM nodes,\n                //   map the array elements to arrays of DOM nodes, concatenate together all these arrays, and use them to populate the container DOM node\n                // * Next time we're given the same combination of things (with the array possibly having mutated), update the container DOM node\n                //   so that its children is again the concatenation of the mappings of the array elements, but don't re-map any array elements that we\n                //   previously mapped - retain those nodes, and just insert/delete other ones\n\n                // \"callbackAfterAddingNodes\" will be invoked after any \"mapping\"-generated nodes are inserted into the container node\n                // You can use this, for example, to activate bindings on those nodes.\n\n                function mapNodeAndRefreshWhenChanged(containerNode, mapping, valueToMap, callbackAfterAddingNodes, index) {\n                    // Map this array value inside a dependentObservable so we re-map when any dependency changes\n                    var mappedNodes = [];\n                    var dependentObservable = ko.dependentObservable(function() {\n                        var newMappedNodes = mapping(valueToMap, index, ko.utils.fixUpContinuousNodeArray(mappedNodes, containerNode)) || [];\n\n                        // On subsequent evaluations, just replace the previously-inserted DOM nodes\n                        if (mappedNodes.length > 0) {\n                            ko.utils.replaceDomNodes(mappedNodes, newMappedNodes);\n                            if (callbackAfterAddingNodes)\n                                ko.dependencyDetection.ignore(callbackAfterAddingNodes, null, [valueToMap, newMappedNodes, index]);\n                        }\n\n                        // Replace the contents of the mappedNodes array, thereby updating the record\n                        // of which nodes would be deleted if valueToMap was itself later removed\n                        mappedNodes.length = 0;\n                        ko.utils.arrayPushAll(mappedNodes, newMappedNodes);\n                    }, null, { disposeWhenNodeIsRemoved: containerNode, disposeWhen: function() { return !ko.utils.anyDomNodeIsAttachedToDocument(mappedNodes); } });\n                    return { mappedNodes : mappedNodes, dependentObservable : (dependentObservable.isActive() ? dependentObservable : undefined) };\n                }\n\n                var lastMappingResultDomDataKey = ko.utils.domData.nextKey(),\n                    deletedItemDummyValue = ko.utils.domData.nextKey();\n\n                ko.utils.setDomNodeChildrenFromArrayMapping = function (domNode, array, mapping, options, callbackAfterAddingNodes, editScript) {\n                    array = array || [];\n                    if (typeof array.length == \"undefined\") // Coerce single value into array\n                        array = [array];\n\n                    options = options || {};\n                    var lastMappingResult = ko.utils.domData.get(domNode, lastMappingResultDomDataKey);\n                    var isFirstExecution = !lastMappingResult;\n\n                    // Build the new mapping result\n                    var newMappingResult = [];\n                    var lastMappingResultIndex = 0;\n                    var currentArrayIndex = 0;\n\n                    var nodesToDelete = [];\n                    var itemsToMoveFirstIndexes = [];\n                    var itemsForBeforeRemoveCallbacks = [];\n                    var itemsForMoveCallbacks = [];\n                    var itemsForAfterAddCallbacks = [];\n                    var mapData;\n                    var countWaitingForRemove = 0;\n\n                    function itemAdded(value) {\n                        mapData = { arrayEntry: value, indexObservable: ko.observable(currentArrayIndex++) };\n                        newMappingResult.push(mapData);\n                        if (!isFirstExecution) {\n                            itemsForAfterAddCallbacks.push(mapData);\n                        }\n                    }\n\n                    function itemMovedOrRetained(oldPosition) {\n                        mapData = lastMappingResult[oldPosition];\n                        if (currentArrayIndex !== mapData.indexObservable.peek())\n                            itemsForMoveCallbacks.push(mapData);\n                        // Since updating the index might change the nodes, do so before calling fixUpContinuousNodeArray\n                        mapData.indexObservable(currentArrayIndex++);\n                        ko.utils.fixUpContinuousNodeArray(mapData.mappedNodes, domNode);\n                        newMappingResult.push(mapData);\n                    }\n\n                    function callCallback(callback, items) {\n                        if (callback) {\n                            for (var i = 0, n = items.length; i < n; i++) {\n                                ko.utils.arrayForEach(items[i].mappedNodes, function(node) {\n                                    callback(node, i, items[i].arrayEntry);\n                                });\n                            }\n                        }\n                    }\n\n                    if (isFirstExecution) {\n                        ko.utils.arrayForEach(array, itemAdded);\n                    } else {\n                        if (!editScript || (lastMappingResult && lastMappingResult['_countWaitingForRemove'])) {\n                            // Compare the provided array against the previous one\n                            var lastArray = ko.utils.arrayMap(lastMappingResult, function (x) { return x.arrayEntry; }),\n                                compareOptions = {\n                                    'dontLimitMoves': options['dontLimitMoves'],\n                                    'sparse': true\n                                };\n                            editScript = ko.utils.compareArrays(lastArray, array, compareOptions);\n                        }\n\n                        for (var i = 0, editScriptItem, movedIndex, itemIndex; editScriptItem = editScript[i]; i++) {\n                            movedIndex = editScriptItem['moved'];\n                            itemIndex = editScriptItem['index'];\n                            switch (editScriptItem['status']) {\n                                case \"deleted\":\n                                    while (lastMappingResultIndex < itemIndex) {\n                                        itemMovedOrRetained(lastMappingResultIndex++);\n                                    }\n                                    if (movedIndex === undefined) {\n                                        mapData = lastMappingResult[lastMappingResultIndex];\n\n                                        // Stop tracking changes to the mapping for these nodes\n                                        if (mapData.dependentObservable) {\n                                            mapData.dependentObservable.dispose();\n                                            mapData.dependentObservable = undefined;\n                                        }\n\n                                        // Queue these nodes for later removal\n                                        if (ko.utils.fixUpContinuousNodeArray(mapData.mappedNodes, domNode).length) {\n                                            if (options['beforeRemove']) {\n                                                newMappingResult.push(mapData);\n                                                countWaitingForRemove++;\n                                                if (mapData.arrayEntry === deletedItemDummyValue) {\n                                                    mapData = null;\n                                                } else {\n                                                    itemsForBeforeRemoveCallbacks.push(mapData);\n                                                }\n                                            }\n                                            if (mapData) {\n                                                nodesToDelete.push.apply(nodesToDelete, mapData.mappedNodes);\n                                            }\n                                        }\n                                    }\n                                    lastMappingResultIndex++;\n                                    break;\n\n                                case \"added\":\n                                    while (currentArrayIndex < itemIndex) {\n                                        itemMovedOrRetained(lastMappingResultIndex++);\n                                    }\n                                    if (movedIndex !== undefined) {\n                                        itemsToMoveFirstIndexes.push(newMappingResult.length);\n                                        itemMovedOrRetained(movedIndex);\n                                    } else {\n                                        itemAdded(editScriptItem['value']);\n                                    }\n                                    break;\n                            }\n                        }\n\n                        while (currentArrayIndex < array.length) {\n                            itemMovedOrRetained(lastMappingResultIndex++);\n                        }\n\n                        // Record that the current view may still contain deleted items\n                        // because it means we won't be able to use a provided editScript.\n                        newMappingResult['_countWaitingForRemove'] = countWaitingForRemove;\n                    }\n\n                    // Store a copy of the array items we just considered so we can difference it next time\n                    ko.utils.domData.set(domNode, lastMappingResultDomDataKey, newMappingResult);\n\n                    // Call beforeMove first before any changes have been made to the DOM\n                    callCallback(options['beforeMove'], itemsForMoveCallbacks);\n\n                    // Next remove nodes for deleted items (or just clean if there's a beforeRemove callback)\n                    ko.utils.arrayForEach(nodesToDelete, options['beforeRemove'] ? ko.cleanNode : ko.removeNode);\n\n                    var i, j, lastNode, nodeToInsert, mappedNodes, activeElement;\n\n                    // Since most browsers remove the focus from an element when it's moved to another location,\n                    // save the focused element and try to restore it later.\n                    try {\n                        activeElement = domNode.ownerDocument.activeElement;\n                    } catch(e) {\n                        // IE9 throws if you access activeElement during page load (see issue #703)\n                    }\n\n                    // Try to reduce overall moved nodes by first moving the ones that were marked as moved by the edit script\n                    if (itemsToMoveFirstIndexes.length) {\n                        while ((i = itemsToMoveFirstIndexes.shift()) != undefined) {\n                            mapData = newMappingResult[i];\n                            for (lastNode = undefined; i; ) {\n                                if ((mappedNodes = newMappingResult[--i].mappedNodes) && mappedNodes.length) {\n                                    lastNode = mappedNodes[mappedNodes.length-1];\n                                    break;\n                                }\n                            }\n                            for (j = 0; nodeToInsert = mapData.mappedNodes[j]; lastNode = nodeToInsert, j++) {\n                                ko.virtualElements.insertAfter(domNode, nodeToInsert, lastNode);\n                            }\n                        }\n                    }\n\n                    // Next add/reorder the remaining items (will include deleted items if there's a beforeRemove callback)\n                    for (i = 0; mapData = newMappingResult[i]; i++) {\n                        // Get nodes for newly added items\n                        if (!mapData.mappedNodes)\n                            ko.utils.extend(mapData, mapNodeAndRefreshWhenChanged(domNode, mapping, mapData.arrayEntry, callbackAfterAddingNodes, mapData.indexObservable));\n\n                        // Put nodes in the right place if they aren't there already\n                        for (j = 0; nodeToInsert = mapData.mappedNodes[j]; lastNode = nodeToInsert, j++) {\n                            ko.virtualElements.insertAfter(domNode, nodeToInsert, lastNode);\n                        }\n\n                        // Run the callbacks for newly added nodes (for example, to apply bindings, etc.)\n                        if (!mapData.initialized && callbackAfterAddingNodes) {\n                            callbackAfterAddingNodes(mapData.arrayEntry, mapData.mappedNodes, mapData.indexObservable);\n                            mapData.initialized = true;\n                            lastNode = mapData.mappedNodes[mapData.mappedNodes.length - 1];     // get the last node again since it may have been changed by a preprocessor\n                        }\n                    }\n\n                    // Restore the focused element if it had lost focus\n                    if (activeElement && domNode.ownerDocument.activeElement != activeElement) {\n                        activeElement.focus();\n                    }\n\n                    // If there's a beforeRemove callback, call it after reordering.\n                    // Note that we assume that the beforeRemove callback will usually be used to remove the nodes using\n                    // some sort of animation, which is why we first reorder the nodes that will be removed. If the\n                    // callback instead removes the nodes right away, it would be more efficient to skip reordering them.\n                    // Perhaps we'll make that change in the future if this scenario becomes more common.\n                    callCallback(options['beforeRemove'], itemsForBeforeRemoveCallbacks);\n\n                    // Replace the stored values of deleted items with a dummy value. This provides two benefits: it marks this item\n                    // as already \"removed\" so we won't call beforeRemove for it again, and it ensures that the item won't match up\n                    // with an actual item in the array and appear as \"retained\" or \"moved\".\n                    for (i = 0; i < itemsForBeforeRemoveCallbacks.length; ++i) {\n                        itemsForBeforeRemoveCallbacks[i].arrayEntry = deletedItemDummyValue;\n                    }\n\n                    // Finally call afterMove and afterAdd callbacks\n                    callCallback(options['afterMove'], itemsForMoveCallbacks);\n                    callCallback(options['afterAdd'], itemsForAfterAddCallbacks);\n                }\n            })();\n\n            ko.exportSymbol('utils.setDomNodeChildrenFromArrayMapping', ko.utils.setDomNodeChildrenFromArrayMapping);\n            ko.nativeTemplateEngine = function () {\n                this['allowTemplateRewriting'] = false;\n            }\n\n            ko.nativeTemplateEngine.prototype = new ko.templateEngine();\n            ko.nativeTemplateEngine.prototype.constructor = ko.nativeTemplateEngine;\n            ko.nativeTemplateEngine.prototype['renderTemplateSource'] = function (templateSource, bindingContext, options, templateDocument) {\n                var useNodesIfAvailable = !(ko.utils.ieVersion < 9), // IE<9 cloneNode doesn't work properly\n                    templateNodesFunc = useNodesIfAvailable ? templateSource['nodes'] : null,\n                    templateNodes = templateNodesFunc ? templateSource['nodes']() : null;\n\n                if (templateNodes) {\n                    return ko.utils.makeArray(templateNodes.cloneNode(true).childNodes);\n                } else {\n                    var templateText = templateSource['text']();\n                    return ko.utils.parseHtmlFragment(templateText, templateDocument);\n                }\n            };\n\n            ko.nativeTemplateEngine.instance = new ko.nativeTemplateEngine();\n            ko.setTemplateEngine(ko.nativeTemplateEngine.instance);\n\n            ko.exportSymbol('nativeTemplateEngine', ko.nativeTemplateEngine);\n            (function() {\n                ko.jqueryTmplTemplateEngine = function () {\n                    // Detect which version of jquery-tmpl you're using. Unfortunately jquery-tmpl\n                    // doesn't expose a version number, so we have to infer it.\n                    // Note that as of Knockout 1.3, we only support jQuery.tmpl 1.0.0pre and later,\n                    // which KO internally refers to as version \"2\", so older versions are no longer detected.\n                    var jQueryTmplVersion = this.jQueryTmplVersion = (function() {\n                        if (!jQueryInstance || !(jQueryInstance['tmpl']))\n                            return 0;\n                        // Since it exposes no official version number, we use our own numbering system. To be updated as jquery-tmpl evolves.\n                        try {\n                            if (jQueryInstance['tmpl']['tag']['tmpl']['open'].toString().indexOf('__') >= 0) {\n                                // Since 1.0.0pre, custom tags should append markup to an array called \"__\"\n                                return 2; // Final version of jquery.tmpl\n                            }\n                        } catch(ex) { /* Apparently not the version we were looking for */ }\n\n                        return 1; // Any older version that we don't support\n                    })();\n\n                    function ensureHasReferencedJQueryTemplates() {\n                        if (jQueryTmplVersion < 2)\n                            throw new Error(\"Your version of jQuery.tmpl is too old. Please upgrade to jQuery.tmpl 1.0.0pre or later.\");\n                    }\n\n                    function executeTemplate(compiledTemplate, data, jQueryTemplateOptions) {\n                        return jQueryInstance['tmpl'](compiledTemplate, data, jQueryTemplateOptions);\n                    }\n\n                    this['renderTemplateSource'] = function(templateSource, bindingContext, options, templateDocument) {\n                        templateDocument = templateDocument || document;\n                        options = options || {};\n                        ensureHasReferencedJQueryTemplates();\n\n                        // Ensure we have stored a precompiled version of this template (don't want to reparse on every render)\n                        var precompiled = templateSource['data']('precompiled');\n                        if (!precompiled) {\n                            var templateText = templateSource['text']() || \"\";\n                            // Wrap in \"with($whatever.koBindingContext) { ... }\"\n                            templateText = \"{{ko_with $item.koBindingContext}}\" + templateText + \"{{/ko_with}}\";\n\n                            precompiled = jQueryInstance['template'](null, templateText);\n                            templateSource['data']('precompiled', precompiled);\n                        }\n\n                        var data = [bindingContext['$data']]; // Prewrap the data in an array to stop jquery.tmpl from trying to unwrap any arrays\n                        var jQueryTemplateOptions = jQueryInstance['extend']({ 'koBindingContext': bindingContext }, options['templateOptions']);\n\n                        var resultNodes = executeTemplate(precompiled, data, jQueryTemplateOptions);\n                        resultNodes['appendTo'](templateDocument.createElement(\"div\")); // Using \"appendTo\" forces jQuery/jQuery.tmpl to perform necessary cleanup work\n\n                        jQueryInstance['fragments'] = {}; // Clear jQuery's fragment cache to avoid a memory leak after a large number of template renders\n                        return resultNodes;\n                    };\n\n                    this['createJavaScriptEvaluatorBlock'] = function(script) {\n                        return \"{{ko_code ((function() { return \" + script + \" })()) }}\";\n                    };\n\n                    this['addTemplate'] = function(templateName, templateMarkup) {\n                        document.write(\"<script type='text/html' id='\" + templateName + \"'>\" + templateMarkup + \"<\" + \"/script>\");\n                    };\n\n                    if (jQueryTmplVersion > 0) {\n                        jQueryInstance['tmpl']['tag']['ko_code'] = {\n                            open: \"__.push($1 || '');\"\n                        };\n                        jQueryInstance['tmpl']['tag']['ko_with'] = {\n                            open: \"with($1) {\",\n                            close: \"} \"\n                        };\n                    }\n                };\n\n                ko.jqueryTmplTemplateEngine.prototype = new ko.templateEngine();\n                ko.jqueryTmplTemplateEngine.prototype.constructor = ko.jqueryTmplTemplateEngine;\n\n                // Use this one by default *only if jquery.tmpl is referenced*\n                var jqueryTmplTemplateEngineInstance = new ko.jqueryTmplTemplateEngine();\n                if (jqueryTmplTemplateEngineInstance.jQueryTmplVersion > 0)\n                    ko.setTemplateEngine(jqueryTmplTemplateEngineInstance);\n\n                ko.exportSymbol('jqueryTmplTemplateEngine', ko.jqueryTmplTemplateEngine);\n            })();\n        }));\n    }());\n})();\n","knockoutjs/knockout-fast-foreach.js":"/*!\n  Knockout Fast Foreach v0.4.1 (2015-07-17T14:06:15.974Z)\n  By: Brian M Hunt (C) 2015\n  License: MIT\n\n  Adds `fastForEach` to `ko.bindingHandlers`.\n*/\n(function (root, factory) {\n  if (typeof define === 'function' && define.amd) {\n    define(['knockout'], factory);\n  } else if (typeof exports === 'object') {\n    module.exports = factory(require('knockout'));\n  } else {\n    root.KnockoutFastForeach = factory(root.ko);\n  }\n}(this, function (ko) {\n  \"use strict\";\n// index.js\n// --------\n// Fast For Each\n//\n// Employing sound techniques to make a faster Knockout foreach binding.\n// --------\n\n//      Utilities\n\n// from https://github.com/jonschlinkert/is-plain-object\nfunction isPlainObject(o) {\n  return !!o && typeof o === 'object' && o.constructor === Object;\n}\n\n// From knockout/src/virtualElements.js\nvar commentNodesHaveTextProperty = document && document.createComment(\"test\").text === \"<!--test-->\";\nvar startCommentRegex = commentNodesHaveTextProperty ? /^<!--\\s*ko(?:\\s+([\\s\\S]+))?\\s*-->$/ : /^\\s*ko(?:\\s+([\\s\\S]+))?\\s*$/;\nvar supportsDocumentFragment = document && typeof document.createDocumentFragment === \"function\";\nfunction isVirtualNode(node) {\n  return (node.nodeType === 8) && startCommentRegex.test(commentNodesHaveTextProperty ? node.text : node.nodeValue);\n}\n\n\n// Get a copy of the (possibly virtual) child nodes of the given element,\n// put them into a container, then empty the given node.\nfunction makeTemplateNode(sourceNode) {\n  var container = document.createElement(\"div\");\n  var parentNode;\n  if (sourceNode.content) {\n    // For e.g. <template> tags\n    parentNode = sourceNode.content;\n  } else if (sourceNode.tagName === 'SCRIPT') {\n    parentNode = document.createElement(\"div\");\n    parentNode.innerHTML = sourceNode.text;\n  } else {\n    // Anything else e.g. <div>\n    parentNode = sourceNode;\n  }\n  ko.utils.arrayForEach(ko.virtualElements.childNodes(parentNode), function (child) {\n    // FIXME - This cloneNode could be expensive; we may prefer to iterate over the\n    // parentNode children in reverse (so as not to foul the indexes as childNodes are\n    // removed from parentNode when inserted into the container)\n    if (child) {\n      container.insertBefore(child.cloneNode(true), null);\n    }\n  });\n  return container;\n}\n\nfunction insertAllAfter(containerNode, nodeOrNodeArrayToInsert, insertAfterNode) {\n  var frag, len, i;\n  // poor man's node and array check, should be enough for this\n  if (typeof nodeOrNodeArrayToInsert.nodeType !== \"undefined\" && typeof nodeOrNodeArrayToInsert.length === \"undefined\") {\n    throw new Error(\"Expected a single node or a node array\");\n  }\n\n  if (typeof nodeOrNodeArrayToInsert.nodeType !== \"undefined\") {\n    ko.virtualElements.insertAfter(containerNode, nodeOrNodeArrayToInsert, insertAfterNode);\n    return;\n  }\n\n  if (nodeOrNodeArrayToInsert.length === 1) {\n    ko.virtualElements.insertAfter(containerNode, nodeOrNodeArrayToInsert[0], insertAfterNode);\n    return;\n  }\n\n  if (supportsDocumentFragment) {\n    frag = document.createDocumentFragment();\n\n    for (i = 0, len = nodeOrNodeArrayToInsert.length; i !== len; ++i) {\n      frag.appendChild(nodeOrNodeArrayToInsert[i]);\n    }\n    ko.virtualElements.insertAfter(containerNode, frag, insertAfterNode);\n  } else {\n    // Nodes are inserted in reverse order - pushed down immediately after\n    // the last node for the previous item or as the first node of element.\n    for (i = nodeOrNodeArrayToInsert.length - 1; i >= 0; --i) {\n      var child = nodeOrNodeArrayToInsert[i];\n      if (!child) {\n        return;\n      }\n      ko.virtualElements.insertAfter(containerNode, child, insertAfterNode);\n    }\n  }\n}\n\n// Mimic a KO change item 'add'\nfunction valueToChangeAddItem(value, index) {\n  return {\n    status: 'added',\n    value: value,\n    index: index\n  };\n}\n\nfunction isAdditionAdjacentToLast(changeIndex, arrayChanges) {\n  return changeIndex > 0 &&\n    changeIndex < arrayChanges.length &&\n    arrayChanges[changeIndex].status === \"added\" &&\n    arrayChanges[changeIndex - 1].status === \"added\" &&\n    arrayChanges[changeIndex - 1].index === arrayChanges[changeIndex].index - 1;\n}\n\nfunction FastForEach(spec) {\n  this.element = spec.element;\n  this.container = isVirtualNode(this.element) ?\n                   this.element.parentNode : this.element;\n  this.$context = spec.$context;\n  this.data = spec.data;\n  this.as = spec.as;\n  this.noContext = spec.noContext;\n  this.templateNode = makeTemplateNode(\n    spec.name ? document.getElementById(spec.name).cloneNode(true) : spec.element\n  );\n  this.afterQueueFlush = spec.afterQueueFlush;\n  this.beforeQueueFlush = spec.beforeQueueFlush;\n  this.changeQueue = [];\n  this.lastNodesList = [];\n  this.indexesToDelete = [];\n  this.rendering_queued = false;\n\n  // Remove existing content.\n  ko.virtualElements.emptyNode(this.element);\n\n  // Prime content\n  var primeData = ko.unwrap(this.data);\n  if (primeData.map) {\n    this.onArrayChange(primeData.map(valueToChangeAddItem));\n  }\n\n  // Watch for changes\n  if (ko.isObservable(this.data)) {\n    if (!this.data.indexOf) {\n      // Make sure the observable is trackable.\n      this.data = this.data.extend({trackArrayChanges: true});\n    }\n    this.changeSubs = this.data.subscribe(this.onArrayChange, this, 'arrayChange');\n  }\n}\n\n\nFastForEach.animateFrame = window.requestAnimationFrame || window.webkitRequestAnimationFrame ||\n  window.mozRequestAnimationFrame || window.msRequestAnimationFrame ||\n  function(cb) { return window.setTimeout(cb, 1000 / 60); };\n\n\nFastForEach.prototype.dispose = function () {\n  if (this.changeSubs) {\n    this.changeSubs.dispose();\n  }\n};\n\n\n// If the array changes we register the change.\nFastForEach.prototype.onArrayChange = function (changeSet) {\n  var self = this;\n  var changeMap = {\n    added: [],\n    deleted: []\n  };\n  for (var i = 0, len = changeSet.length; i < len; i++) {\n    // the change is appended to a last change info object when both are 'added' and have indexes next to each other\n    // here I presume that ko is sending changes in monotonic order (in index variable) which happens to be true, tested with push and splice with multiple pushed values\n    if (isAdditionAdjacentToLast(i, changeSet)) {\n      var batchValues = changeMap.added[changeMap.added.length - 1].values;\n      if (!batchValues) {\n        // transform the last addition into a batch addition object\n        var lastAddition = changeMap.added.pop();\n        var batchAddition = {\n          isBatch: true,\n          status: 'added',\n          index: lastAddition.index,\n          values: [lastAddition.value]\n        };\n        batchValues = batchAddition.values;\n        changeMap.added.push(batchAddition);\n      }\n      batchValues.push(changeSet[i].value);\n    } else {\n      changeMap[changeSet[i].status].push(changeSet[i]);\n    }\n  }\n  if (changeMap.deleted.length > 0) {\n    this.changeQueue.push.apply(this.changeQueue, changeMap.deleted);\n    this.changeQueue.push({status: 'clearDeletedIndexes'});\n  }\n  this.changeQueue.push.apply(this.changeQueue, changeMap.added);\n  // Once a change is registered, the ticking count-down starts for the processQueue.\n  if (this.changeQueue.length > 0 && !this.rendering_queued) {\n    this.rendering_queued = true;\n    FastForEach.animateFrame.call(window, function () { self.processQueue(); });\n  }\n};\n\n\n// Reflect all the changes in the queue in the DOM, then wipe the queue.\nFastForEach.prototype.processQueue = function () {\n  var self = this;\n\n  // Callback so folks can do things before the queue flush.\n  if (typeof this.beforeQueueFlush === 'function') {\n    this.beforeQueueFlush(this.changeQueue);\n  }\n\n  ko.utils.arrayForEach(this.changeQueue, function (changeItem) {\n    // console.log(self.data(), \"CI\", JSON.stringify(changeItem, null, 2), JSON.stringify($(self.element).text()))\n    self[changeItem.status](changeItem);\n    // console.log(\"  ==> \", JSON.stringify($(self.element).text()))\n  });\n  this.rendering_queued = false;\n  // Callback so folks can do things.\n  if (typeof this.afterQueueFlush === 'function') {\n    this.afterQueueFlush(this.changeQueue);\n  }\n  this.changeQueue = [];\n};\n\n\n// Process a changeItem with {status: 'added', ...}\nFastForEach.prototype.added = function (changeItem) {\n  var index = changeItem.index;\n  var valuesToAdd = changeItem.isBatch ? changeItem.values : [changeItem.value];\n  var referenceElement = this.lastNodesList[index - 1] || null;\n  // gather all childnodes for a possible batch insertion\n  var allChildNodes = [];\n\n  for (var i = 0, len = valuesToAdd.length; i < len; ++i) {\n    var templateClone = this.templateNode.cloneNode(true);\n    var childContext;\n\n    if (this.noContext) {\n      childContext = this.$context.extend({\n        '$item': valuesToAdd[i]\n      });\n    } else {\n      childContext = this.$context.createChildContext(valuesToAdd[i], this.as || null);\n    }\n\n    // apply bindings first, and then process child nodes, because bindings can add childnodes\n    ko.applyBindingsToDescendants(childContext, templateClone);\n\n    var childNodes = ko.virtualElements.childNodes(templateClone);\n    // Note discussion at https://github.com/angular/angular.js/issues/7851\n    allChildNodes.push.apply(allChildNodes, Array.prototype.slice.call(childNodes));\n    this.lastNodesList.splice(index + i, 0, childNodes[childNodes.length - 1]);\n  }\n\n  insertAllAfter(this.element, allChildNodes, referenceElement);\n};\n\n\n// Process a changeItem with {status: 'deleted', ...}\nFastForEach.prototype.deleted = function (changeItem) {\n  var index = changeItem.index;\n  var ptr = this.lastNodesList[index],\n      // We use this.element because that will be the last previous node\n      // for virtual element lists.\n      lastNode = this.lastNodesList[index - 1] || this.element;\n  do {\n    ptr = ptr.previousSibling;\n    ko.removeNode((ptr && ptr.nextSibling) || ko.virtualElements.firstChild(this.element));\n  } while (ptr && ptr !== lastNode);\n  // The \"last node\" in the DOM from which we begin our delets of the next adjacent node is\n  // now the sibling that preceded the first node of this item.\n  this.lastNodesList[index] = this.lastNodesList[index - 1];\n  this.indexesToDelete.push(index);\n};\n\n\n// We batch our deletion of item indexes in our parallel array.\n// See brianmhunt/knockout-fast-foreach#6/#8\nFastForEach.prototype.clearDeletedIndexes = function () {\n  // We iterate in reverse on the presumption (following the unit tests) that KO's diff engine\n  // processes diffs (esp. deletes) monotonically ascending i.e. from index 0 -> N.\n  for (var i = this.indexesToDelete.length - 1; i >= 0; --i) {\n    this.lastNodesList.splice(this.indexesToDelete[i], 1);\n  }\n  this.indexesToDelete = [];\n};\n\n\nko.bindingHandlers.fastForEach = {\n  // Valid valueAccessors:\n  //    []\n  //    ko.observable([])\n  //    ko.observableArray([])\n  //    ko.computed\n  //    {data: array, name: string, as: string}\n  init: function init(element, valueAccessor, bindings, vm, context) {\n    var value = valueAccessor(),\n        ffe;\n    if (isPlainObject(value)) {\n      value.element = value.element || element;\n      value.$context = context;\n      ffe = new FastForEach(value);\n    } else {\n      ffe = new FastForEach({\n        element: element,\n        data: ko.unwrap(context.$rawData) === value ? context.$rawData : value,\n        $context: context\n      });\n    }\n    ko.utils.domNodeDisposal.addDisposeCallback(element, function () {\n      ffe.dispose();\n    });\n    return {controlsDescendantBindings: true};\n  },\n\n  // Export for testing, debugging, and overloading.\n  FastForEach: FastForEach\n};\n\nko.virtualElements.allowedBindings.fastForEach = true;\n}));","knockoutjs/knockout-repeat.js":"// REPEAT binding for Knockout http://knockoutjs.com/\n// (c) Michael Best\n// License: MIT (http://www.opensource.org/licenses/mit-license.php)\n// Version 2.1.0\n\n(function(factory) {\n    if (typeof define === 'function' && define.amd) {\n        // [1] AMD anonymous module\n        define(['knockout'], factory);\n    } else if (typeof exports === 'object') {\n        // [2] commonJS\n        factory(require('knockout'));\n    } else {\n        // [3] No module loader (plain <script> tag) - put directly in global namespace\n        factory(window.ko);\n    }\n})(function(ko) {\n\nif (!ko.virtualElements)\n    throw Error('Repeat requires at least Knockout 2.1');\n\nvar ko_bindingFlags = ko.bindingFlags || {};\nvar ko_unwrap = ko.utils.unwrapObservable;\n\nvar koProtoName = '__ko_proto__';\n\nif (ko.version >= \"3.0.0\") {\n    // In Knockout 3.0.0, use the node preprocessor to replace a node with a repeat binding with a virtual element\n    var provider = ko.bindingProvider.instance, previousPreprocessFn = provider.preprocessNode;\n    provider.preprocessNode = function(node) {\n        var newNodes, nodeBinding;\n        if (!previousPreprocessFn || !(newNodes = previousPreprocessFn.call(this, node))) {\n            if (node.nodeType === 1 && (nodeBinding = node.getAttribute('data-bind'))) {\n                if (/^\\s*repeat\\s*:/.test(nodeBinding)) {\n                    var leadingComment = node.ownerDocument.createComment('ko ' + nodeBinding),\n                        trailingComment = node.ownerDocument.createComment('/ko');\n                    node.parentNode.insertBefore(leadingComment, node);\n                    node.parentNode.insertBefore(trailingComment, node.nextSibling);\n                    node.removeAttribute('data-bind');\n                    newNodes = [leadingComment, node, trailingComment];\n                }\n            }\n        }\n        return newNodes;\n    };\n}\n\nko.virtualElements.allowedBindings.repeat = true;\nko.bindingHandlers.repeat = {\n    flags: ko_bindingFlags.contentBind | ko_bindingFlags.canUseVirtual,\n    init: function(element, valueAccessor, allBindingsAccessor, xxx, bindingContext) {\n\n        // Read and set fixed options--these options cannot be changed\n        var repeatParam = ko_unwrap(valueAccessor());\n        if (repeatParam && typeof repeatParam == 'object' && !('length' in repeatParam)) {\n            var repeatIndex = repeatParam.index,\n                repeatData = repeatParam.item,\n                repeatStep = repeatParam.step,\n                repeatReversed = repeatParam.reverse,\n                repeatBind = repeatParam.bind,\n                repeatInit = repeatParam.init,\n                repeatUpdate = repeatParam.update;\n        }\n        // Set default values for options that need it\n        repeatIndex = repeatIndex || '$index';\n        repeatData = repeatData || ko.bindingHandlers.repeat.itemName || '$item';\n        repeatStep = repeatStep || 1;\n        repeatReversed = repeatReversed || false;\n\n        var parent = element.parentNode, placeholder;\n        if (element.nodeType == 8) {    // virtual element\n            // Extract the \"children\" and find the single element node\n            var childNodes = ko.utils.arrayFilter(ko.virtualElements.childNodes(element), function(node) { return node.nodeType == 1;});\n            if (childNodes.length !== 1) {\n                throw Error(\"Repeat binding requires a single element to repeat\");\n            }\n            ko.virtualElements.emptyNode(element);\n\n            // The placeholder is the closing comment normally, or the opening comment if reversed\n            placeholder = repeatReversed ? element : element.nextSibling;\n            // The element to repeat is the contained element\n            element = childNodes[0];\n        } else {    // regular element\n            // First clean the element node and remove node's binding\n            var origBindString = element.getAttribute('data-bind');\n            ko.cleanNode(element);\n            element.removeAttribute('data-bind');\n\n            // Original element is no longer needed: delete it and create a placeholder comment\n            placeholder = element.ownerDocument.createComment('ko_repeatplaceholder ' + origBindString);\n            parent.replaceChild(placeholder, element);\n        }\n\n        // extract and remove a data-repeat-bind attribute, if present\n        if (!repeatBind) {\n            repeatBind = element.getAttribute('data-repeat-bind');\n            if (repeatBind) {\n                element.removeAttribute('data-repeat-bind');\n            }\n        }\n\n        // Make a copy of the element node to be copied for each repetition\n        var cleanNode = element.cloneNode(true);\n        if (typeof repeatBind == \"string\") {\n            cleanNode.setAttribute('data-bind', repeatBind);\n            repeatBind = null;\n        }\n\n        // Set up persistent data\n        var lastRepeatCount = 0,\n            notificationObservable = ko.observable(),\n            repeatArray, arrayObservable;\n\n        if (repeatInit) {\n            repeatInit(parent);\n        }\n\n        var subscribable = ko.computed(function() {\n            function makeArrayItemAccessor(index) {\n                var f = function(newValue) {\n                    var item = repeatArray[index];\n                    // Reading the value of the item\n                    if (!arguments.length) {\n                        notificationObservable();   // for dependency tracking\n                        return ko_unwrap(item);\n                    }\n                    // Writing a value to the item\n                    if (ko.isObservable(item)) {\n                        item(newValue);\n                    } else if (arrayObservable && arrayObservable.splice) {\n                        arrayObservable.splice(index, 1, newValue);\n                    } else {\n                        repeatArray[index] = newValue;\n                    }\n                    return this;\n                };\n                // Pretend that our accessor function is an observable\n                f[koProtoName] = ko.observable;\n                return f;\n            }\n\n            function makeBinding(item, index, context) {\n                return repeatArray\n                    ? function() { return repeatBind.call(bindingContext.$data, item, index, context); }\n                    : function() { return repeatBind.call(bindingContext.$data, index, context); }\n            }\n\n            // Read and set up variable options--these options can change and will update the binding\n            var paramObservable = valueAccessor(), repeatParam = ko_unwrap(paramObservable), repeatCount = 0;\n            if (repeatParam && typeof repeatParam == 'object') {\n                if ('length' in repeatParam) {\n                    repeatArray = repeatParam;\n                    repeatCount = repeatArray.length;\n                } else {\n                    if ('foreach' in repeatParam) {\n                        repeatArray = ko_unwrap(paramObservable = repeatParam.foreach);\n                        if (repeatArray && typeof repeatArray == 'object' && 'length' in repeatArray) {\n                            repeatCount = repeatArray.length || 0;\n                        } else {\n                            repeatCount = repeatArray || 0;\n                            repeatArray = null;\n                        }\n                    }\n                    // If a count value is provided (>0), always output that number of items\n                    if ('count' in repeatParam)\n                        repeatCount = ko_unwrap(repeatParam.count) || repeatCount;\n                    // If a limit is provided, don't output more than the limit\n                    if ('limit' in repeatParam)\n                        repeatCount = Math.min(repeatCount, ko_unwrap(repeatParam.limit)) || repeatCount;\n                }\n                arrayObservable = repeatArray && ko.isObservable(paramObservable) ? paramObservable : null;\n            } else {\n                repeatCount = repeatParam || 0;\n            }\n\n            // Remove nodes from end if array is shorter\n            for (; lastRepeatCount > repeatCount; lastRepeatCount-=repeatStep) {\n                ko.removeNode(repeatReversed ? placeholder.nextSibling : placeholder.previousSibling);\n            }\n\n            // Notify existing nodes of change\n            notificationObservable.notifySubscribers();\n\n            // Add nodes to end if array is longer (also initially populates nodes)\n            for (; lastRepeatCount < repeatCount; lastRepeatCount+=repeatStep) {\n                // Clone node and add to document\n                var newNode = cleanNode.cloneNode(true);\n                parent.insertBefore(newNode, repeatReversed ? placeholder.nextSibling : placeholder);\n                newNode.setAttribute('data-repeat-index', lastRepeatCount);\n\n                // Apply bindings to inserted node\n                if (repeatArray && repeatData == '$data') {\n                    var newContext = bindingContext.createChildContext(makeArrayItemAccessor(lastRepeatCount));\n                } else {\n                    var newContext = bindingContext.extend();\n                    if (repeatArray)\n                        newContext[repeatData] = makeArrayItemAccessor(lastRepeatCount);\n                }\n                newContext[repeatIndex] = lastRepeatCount;\n                if (repeatBind) {\n                    var result = ko.applyBindingsToNode(newNode, makeBinding(newContext[repeatData], lastRepeatCount, newContext), newContext, true),\n                        shouldBindDescendants = result && result.shouldBindDescendants;\n                }\n                if (!repeatBind || (result && shouldBindDescendants !== false)) {\n                    ko.applyBindings(newContext, newNode);\n                }\n            }\n            if (repeatUpdate) {\n                repeatUpdate(parent);\n            }\n        }, null, {disposeWhenNodeIsRemoved: placeholder});\n\n        return { controlsDescendantBindings: true, subscribable: subscribable };\n    }\n};\n});","knockoutjs/knockout-es5.js":"/*!\n * Knockout ES5 plugin - https://github.com/SteveSanderson/knockout-es5\n * Copyright (c) Steve Sanderson\n * MIT license\n */\n\n(function(global, undefined) {\n  'use strict';\n\n  var ko;\n\n  // Model tracking\n  // --------------\n  //\n  // This is the central feature of Knockout-ES5. We augment model objects by converting properties\n  // into ES5 getter/setter pairs that read/write an underlying Knockout observable. This means you can\n  // use plain JavaScript syntax to read/write the property while still getting the full benefits of\n  // Knockout's automatic dependency detection and notification triggering.\n  //\n  // For comparison, here's Knockout ES3-compatible syntax:\n  //\n  //     var firstNameLength = myModel.user().firstName().length; // Read\n  //     myModel.user().firstName('Bert'); // Write\n  //\n  // ... versus Knockout-ES5 syntax:\n  //\n  //     var firstNameLength = myModel.user.firstName.length; // Read\n  //     myModel.user.firstName = 'Bert'; // Write\n\n  // `ko.track(model)` converts each property on the given model object into a getter/setter pair that\n  // wraps a Knockout observable. Optionally specify an array of property names to wrap; otherwise we\n  // wrap all properties. If any of the properties are already observables, we replace them with\n  // ES5 getter/setter pairs that wrap your original observable instances. In the case of readonly\n  // ko.computed properties, we simply do not define a setter (so attempted writes will be ignored,\n  // which is how ES5 readonly properties normally behave).\n  //\n  // By design, this does *not* recursively walk child object properties, because making literally\n  // everything everywhere independently observable is usually unhelpful. When you do want to track\n  // child object properties independently, define your own class for those child objects and put\n  // a separate ko.track call into its constructor --- this gives you far more control.\n  /**\n   * @param {object} obj\n   * @param {object|array.<string>} propertyNamesOrSettings\n   * @param {boolean} propertyNamesOrSettings.deep Use deep track.\n   * @param {array.<string>} propertyNamesOrSettings.fields Array of property names to wrap.\n   * todo: @param {array.<string>} propertyNamesOrSettings.exclude Array of exclude property names to wrap.\n   * todo: @param {function(string, *):boolean} propertyNamesOrSettings.filter Function to filter property \n   *   names to wrap. A function that takes ... params\n   * @return {object}\n   */\n  function track(obj, propertyNamesOrSettings) {\n    if (!obj || typeof obj !== 'object') {\n      throw new Error('When calling ko.track, you must pass an object as the first parameter.');\n    }\n\n    var propertyNames;\n\n    if ( isPlainObject(propertyNamesOrSettings) ) {\n      // defaults\n      propertyNamesOrSettings.deep = propertyNamesOrSettings.deep || false;\n      propertyNamesOrSettings.fields = propertyNamesOrSettings.fields || Object.getOwnPropertyNames(obj);\n      propertyNamesOrSettings.lazy = propertyNamesOrSettings.lazy || false;\n\n      wrap(obj, propertyNamesOrSettings.fields, propertyNamesOrSettings);\n    } else {\n      propertyNames = propertyNamesOrSettings || Object.getOwnPropertyNames(obj);\n      wrap(obj, propertyNames, {});\n    }\n\n    return obj;\n  }\n\n  // fix for ie\n  var rFunctionName = /^function\\s*([^\\s(]+)/;\n  function getFunctionName( ctor ){\n    if (ctor.name) {\n      return ctor.name;\n    }\n    return (ctor.toString().trim().match( rFunctionName ) || [])[1];\n  }\n\n  function canTrack(obj) {\n    return obj && typeof obj === 'object' && getFunctionName(obj.constructor) === 'Object';\n  }\n\n  function createPropertyDescriptor(originalValue, prop, map) {\n    var isObservable = ko.isObservable(originalValue);\n    var isArray = !isObservable && Array.isArray(originalValue);\n    var observable = isObservable ? originalValue\n        : isArray ? ko.observableArray(originalValue)\n        : ko.observable(originalValue);\n\n    map[prop] = function () { return observable; };\n\n    // add check in case the object is already an observable array\n    if (isArray || (isObservable && 'push' in observable)) {\n      notifyWhenPresentOrFutureArrayValuesMutate(ko, observable);\n    }\n\n    return {\n      configurable: true,\n      enumerable: true,\n      get: observable,\n      set: ko.isWriteableObservable(observable) ? observable : undefined\n    };\n  }\n\n  function createLazyPropertyDescriptor(originalValue, prop, map) {\n    if (ko.isObservable(originalValue)) {\n      // no need to be lazy if we already have an observable\n      return createPropertyDescriptor(originalValue, prop, map);\n    }\n\n    var observable;\n\n    function getOrCreateObservable(value, writing) {\n      if (observable) {\n        return writing ? observable(value) : observable;\n      }\n\n      if (Array.isArray(value)) {\n        observable = ko.observableArray(value);\n        notifyWhenPresentOrFutureArrayValuesMutate(ko, observable);\n        return observable;\n      }\n\n      return (observable = ko.observable(value));\n    }\n\n    map[prop] = function () { return getOrCreateObservable(originalValue); };\n    return {\n      configurable: true,\n      enumerable: true,\n      get: function () { return getOrCreateObservable(originalValue)(); },\n      set: function (value) { getOrCreateObservable(value, true); }\n    };\n  }\n\n  function wrap(obj, props, options) {\n    if (!props.length) {\n      return;\n    }\n\n    var allObservablesForObject = getAllObservablesForObject(obj, true);\n    var descriptors = {};\n\n    props.forEach(function (prop) {\n      // Skip properties that are already tracked\n      if (prop in allObservablesForObject) {\n        return;\n      }\n\n      // Skip properties where descriptor can't be redefined\n      if (Object.getOwnPropertyDescriptor(obj, prop).configurable === false){\n        return;\n      }\n\n      var originalValue = obj[prop];\n      descriptors[prop] = (options.lazy ? createLazyPropertyDescriptor : createPropertyDescriptor)\n        (originalValue, prop, allObservablesForObject);\n\n      if (options.deep && canTrack(originalValue)) {\n        wrap(originalValue, Object.keys(originalValue), options);\n      }\n    });\n\n    Object.defineProperties(obj, descriptors);\n  }\n\n  function isPlainObject( obj ){\n    return !!obj && typeof obj === 'object' && obj.constructor === Object;\n  }\n\n  // Lazily created by `getAllObservablesForObject` below. Has to be created lazily because the\n  // WeakMap factory isn't available until the module has finished loading (may be async).\n  var objectToObservableMap;\n\n  // Gets or creates the hidden internal key-value collection of observables corresponding to\n  // properties on the model object.\n  function getAllObservablesForObject(obj, createIfNotDefined) {\n    if (!objectToObservableMap) {\n      objectToObservableMap = weakMapFactory();\n    }\n\n    var result = objectToObservableMap.get(obj);\n    if (!result && createIfNotDefined) {\n      result = {};\n      objectToObservableMap.set(obj, result);\n    }\n    return result;\n  }\n\n  // Removes the internal references to observables mapped to the specified properties\n  // or the entire object reference if no properties are passed in. This allows the\n  // observables to be replaced and tracked again.\n  function untrack(obj, propertyNames) {\n    if (!objectToObservableMap) {\n      return;\n    }\n\n    if (arguments.length === 1) {\n      objectToObservableMap['delete'](obj);\n    } else {\n      var allObservablesForObject = getAllObservablesForObject(obj, false);\n      if (allObservablesForObject) {\n        propertyNames.forEach(function(propertyName) {\n          delete allObservablesForObject[propertyName];\n        });\n      }\n    }\n  }\n\n  // Computed properties\n  // -------------------\n  //\n  // The preceding code is already sufficient to upgrade ko.computed model properties to ES5\n  // getter/setter pairs (or in the case of readonly ko.computed properties, just a getter).\n  // These then behave like a regular property with a getter function, except they are smarter:\n  // your evaluator is only invoked when one of its dependencies changes. The result is cached\n  // and used for all evaluations until the next time a dependency changes).\n  //\n  // However, instead of forcing developers to declare a ko.computed property explicitly, it's\n  // nice to offer a utility function that declares a computed getter directly.\n\n  // Implements `ko.defineProperty`\n  function defineComputedProperty(obj, propertyName, evaluatorOrOptions) {\n    var ko = this,\n      computedOptions = { owner: obj, deferEvaluation: true };\n\n    if (typeof evaluatorOrOptions === 'function') {\n      computedOptions.read = evaluatorOrOptions;\n    } else {\n      if ('value' in evaluatorOrOptions) {\n        throw new Error('For ko.defineProperty, you must not specify a \"value\" for the property. ' +\n                        'You must provide a \"get\" function.');\n      }\n\n      if (typeof evaluatorOrOptions.get !== 'function') {\n        throw new Error('For ko.defineProperty, the third parameter must be either an evaluator function, ' +\n                        'or an options object containing a function called \"get\".');\n      }\n\n      computedOptions.read = evaluatorOrOptions.get;\n      computedOptions.write = evaluatorOrOptions.set;\n    }\n\n    obj[propertyName] = ko.computed(computedOptions);\n    track.call(ko, obj, [propertyName]);\n    return obj;\n  }\n\n  // Array handling\n  // --------------\n  //\n  // Arrays are special, because unlike other property types, they have standard mutator functions\n  // (`push`/`pop`/`splice`/etc.) and it's desirable to trigger a change notification whenever one of\n  // those mutator functions is invoked.\n  //\n  // Traditionally, Knockout handles this by putting special versions of `push`/`pop`/etc. on observable\n  // arrays that mutate the underlying array and then trigger a notification. That approach doesn't\n  // work for Knockout-ES5 because properties now return the underlying arrays, so the mutator runs\n  // in the context of the underlying array, not any particular observable:\n  //\n  //     // Operates on the underlying array value\n  //     myModel.someCollection.push('New value');\n  //\n  // To solve this, Knockout-ES5 detects array values, and modifies them as follows:\n  //  1. Associates a hidden subscribable with each array instance that it encounters\n  //  2. Intercepts standard mutators (`push`/`pop`/etc.) and makes them trigger the subscribable\n  // Then, for model properties whose values are arrays, the property's underlying observable\n  // subscribes to the array subscribable, so it can trigger a change notification after mutation.\n\n  // Given an observable that underlies a model property, watch for any array value that might\n  // be assigned as the property value, and hook into its change events\n  function notifyWhenPresentOrFutureArrayValuesMutate(ko, observable) {\n    var watchingArraySubscription = null;\n    ko.computed(function () {\n      // Unsubscribe to any earlier array instance\n      if (watchingArraySubscription) {\n        watchingArraySubscription.dispose();\n        watchingArraySubscription = null;\n      }\n\n      // Subscribe to the new array instance\n      var newArrayInstance = observable();\n      if (newArrayInstance instanceof Array) {\n        watchingArraySubscription = startWatchingArrayInstance(ko, observable, newArrayInstance);\n      }\n    });\n  }\n\n  // Listens for array mutations, and when they happen, cause the observable to fire notifications.\n  // This is used to make model properties of type array fire notifications when the array changes.\n  // Returns a subscribable that can later be disposed.\n  function startWatchingArrayInstance(ko, observable, arrayInstance) {\n    var subscribable = getSubscribableForArray(ko, arrayInstance);\n    return subscribable.subscribe(observable);\n  }\n\n  // Lazily created by `getSubscribableForArray` below. Has to be created lazily because the\n  // WeakMap factory isn't available until the module has finished loading (may be async).\n  var arraySubscribablesMap;\n\n  // Gets or creates a subscribable that fires after each array mutation\n  function getSubscribableForArray(ko, arrayInstance) {\n    if (!arraySubscribablesMap) {\n      arraySubscribablesMap = weakMapFactory();\n    }\n\n    var subscribable = arraySubscribablesMap.get(arrayInstance);\n    if (!subscribable) {\n      subscribable = new ko.subscribable();\n      arraySubscribablesMap.set(arrayInstance, subscribable);\n\n      var notificationPauseSignal = {};\n      wrapStandardArrayMutators(arrayInstance, subscribable, notificationPauseSignal);\n      addKnockoutArrayMutators(ko, arrayInstance, subscribable, notificationPauseSignal);\n    }\n\n    return subscribable;\n  }\n\n  // After each array mutation, fires a notification on the given subscribable\n  function wrapStandardArrayMutators(arrayInstance, subscribable, notificationPauseSignal) {\n    ['pop', 'push', 'reverse', 'shift', 'sort', 'splice', 'unshift'].forEach(function(fnName) {\n      var origMutator = arrayInstance[fnName];\n      arrayInstance[fnName] = function() {\n        var result = origMutator.apply(this, arguments);\n        if (notificationPauseSignal.pause !== true) {\n          subscribable.notifySubscribers(this);\n        }\n        return result;\n      };\n    });\n  }\n\n  // Adds Knockout's additional array mutation functions to the array\n  function addKnockoutArrayMutators(ko, arrayInstance, subscribable, notificationPauseSignal) {\n    ['remove', 'removeAll', 'destroy', 'destroyAll', 'replace'].forEach(function(fnName) {\n      // Make it a non-enumerable property for consistency with standard Array functions\n      Object.defineProperty(arrayInstance, fnName, {\n        enumerable: false,\n        value: function() {\n          var result;\n\n          // These additional array mutators are built using the underlying push/pop/etc.\n          // mutators, which are wrapped to trigger notifications. But we don't want to\n          // trigger multiple notifications, so pause the push/pop/etc. wrappers and\n          // delivery only one notification at the end of the process.\n          notificationPauseSignal.pause = true;\n          try {\n            // Creates a temporary observableArray that can perform the operation.\n            result = ko.observableArray.fn[fnName].apply(ko.observableArray(arrayInstance), arguments);\n          }\n          finally {\n            notificationPauseSignal.pause = false;\n          }\n          subscribable.notifySubscribers(arrayInstance);\n          return result;\n        }\n      });\n    });\n  }\n\n  // Static utility functions\n  // ------------------------\n  //\n  // Since Knockout-ES5 sets up properties that return values, not observables, you can't\n  // trivially subscribe to the underlying observables (e.g., `someProperty.subscribe(...)`),\n  // or tell them that object values have mutated, etc. To handle this, we set up some\n  // extra utility functions that can return or work with the underlying observables.\n\n  // Returns the underlying observable associated with a model property (or `null` if the\n  // model or property doesn't exist, or isn't associated with an observable). This means\n  // you can subscribe to the property, e.g.:\n  //\n  //     ko.getObservable(model, 'propertyName')\n  //       .subscribe(function(newValue) { ... });\n  function getObservable(obj, propertyName) {\n    if (!obj || typeof obj !== 'object') {\n      return null;\n    }\n\n    var allObservablesForObject = getAllObservablesForObject(obj, false);\n    if (allObservablesForObject && propertyName in allObservablesForObject) {\n      return allObservablesForObject[propertyName]();\n    }\n\n    return null;\n  }\n  \n  // Returns a boolean indicating whether the property on the object has an underlying\n  // observables. This does the check in a way not to create an observable if the\n  // object was created with lazily created observables\n  function isTracked(obj, propertyName) {\n    if (!obj || typeof obj !== 'object') {\n      return false;\n    }\n    \n    var allObservablesForObject = getAllObservablesForObject(obj, false);\n    return !!allObservablesForObject && propertyName in allObservablesForObject;\n  }\n\n  // Causes a property's associated observable to fire a change notification. Useful when\n  // the property value is a complex object and you've modified a child property.\n  function valueHasMutated(obj, propertyName) {\n    var observable = getObservable(obj, propertyName);\n\n    if (observable) {\n      observable.valueHasMutated();\n    }\n  }\n\n  // Module initialisation\n  // ---------------------\n  //\n  // When this script is first evaluated, it works out what kind of module loading scenario\n  // it is in (Node.js or a browser `<script>` tag), stashes a reference to its dependencies\n  // (currently that's just the WeakMap shim), and then finally attaches itself to whichever\n  // instance of Knockout.js it can find.\n\n  // A function that returns a new ES6-compatible WeakMap instance (using ES5 shim if needed).\n  // Instantiated by prepareExports, accounting for which module loader is being used.\n  var weakMapFactory;\n\n  // Extends a Knockout instance with Knockout-ES5 functionality\n  function attachToKo(ko) {\n    ko.track = track;\n    ko.untrack = untrack;\n    ko.getObservable = getObservable;\n    ko.valueHasMutated = valueHasMutated;\n    ko.defineProperty = defineComputedProperty;\n\n    // todo: test it, maybe added it to ko. directly\n    ko.es5 = {\n      getAllObservablesForObject: getAllObservablesForObject,\n      notifyWhenPresentOrFutureArrayValuesMutate: notifyWhenPresentOrFutureArrayValuesMutate,\n      isTracked: isTracked\n    };\n  }\n\n  // Determines which module loading scenario we're in, grabs dependencies, and attaches to KO\n  function prepareExports() {\n    if (typeof exports === 'object' && typeof module === 'object') {\n      // Node.js case - load KO and WeakMap modules synchronously\n      ko = require('knockout');\n      var WM = require('../lib/weakmap');\n      attachToKo(ko);\n      weakMapFactory = function() { return new WM(); };\n      module.exports = ko;\n    } else if (typeof define === 'function' && define.amd) {\n      define(['knockout'], function(koModule) {\n        ko = koModule;\n        attachToKo(koModule);\n        weakMapFactory = function() { return new global.WeakMap(); };\n        return koModule;\n      });\n    } else if ('ko' in global) {\n      // Non-module case - attach to the global instance, and assume a global WeakMap constructor\n      ko = global.ko;\n      attachToKo(global.ko);\n      weakMapFactory = function() { return new global.WeakMap(); };\n    }\n  }\n\n  prepareExports();\n\n})(this);","Magento_Tax/js/bootstrap.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nrequire([\n    'mage/backend/editablemultiselect'\n]);\n","Magento_Tax/js/price/adjustment.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'mage/translate'\n], function (Element, $t) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            bodyTmpl: 'Magento_Tax/price/adjustment',\n            taxPriceType: 'final_price',\n            taxPriceCssClass: 'price-including-tax',\n            bothPrices: 3,\n            inclTax: 2,\n            exclTax: 1,\n            modules: {\n                price: '${ $.parentName }'\n            },\n            listens: {\n                price: 'initializePriceAttributes'\n            }\n        },\n\n        /**\n         * {@inheritdoc}\n         */\n        initialize: function () {\n            this._super()\n                .initializePriceAttributes();\n\n            return this;\n        },\n\n        /**\n         * Update parent price.\n         *\n         * @returns {Object} Chainable.\n         */\n        initializePriceAttributes: function () {\n            if (this.displayBothPrices && this.price()) {\n                this.price().priceWrapperCssClasses = this.taxPriceCssClass;\n                this.price().priceWrapperAttr = {\n                    'data-label': $t('Incl. Tax')\n                };\n            }\n\n            return this;\n        },\n\n        /**\n         * Get price tax adjustment.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} tax html\n         */\n        getTax: function (row) {\n            return row['price_info']['extension_attributes']['tax_adjustments']['formatted_prices'][this.taxPriceType];\n        },\n\n        /**\n         * Set price tax type.\n         *\n         * @param {String} priceType\n         * @return {Object}\n         */\n        setPriceType: function (priceType) {\n            this.taxPriceType = priceType;\n\n            return this;\n        },\n\n        /**\n         * Return whether display setting is to display\n         * both price including tax and price excluding tax.\n         *\n         * @return {Boolean}\n         */\n        displayBothPrices: function () {\n            return +this.source.data.displayTaxes === this.bothPrices;\n        },\n\n        /**\n         * Return whether display setting is to display price including tax.\n         *\n         * @return {Boolean}\n         */\n        displayPriceIncludeTax: function () {\n            return +this.source.data.displayTaxes === this.inclTax;\n        },\n\n        /**\n         * Return whether display setting is to display price excluding tax.\n         *\n         * @return {Boolean}\n         */\n        displayPriceExclTax: function () {\n            return +this.source.data.displayTaxes === this.exclTax;\n        }\n    });\n});\n","Mageplaza_Reports/js/dashboard/initGridStack.js":"/**\r\n * Mageplaza\r\n *\r\n * NOTICE OF LICENSE\r\n *\r\n * This source file is subject to the Mageplaza.com license that is\r\n * available through the world-wide-web at this URL:\r\n * https://www.mageplaza.com/LICENSE.txt\r\n *\r\n * DISCLAIMER\r\n *\r\n * Do not edit or add to this file if you wish to upgrade this extension to newer\r\n * version in the future.\r\n *\r\n * @category    Mageplaza\r\n * @package     Mageplaza_Reports\r\n * @copyright   Copyright (c) Mageplaza (https://www.mageplaza.com/)\r\n * @license     https://www.mageplaza.com/LICENSE.txt\r\n */\r\n\r\ndefine([\r\n    'jquery',\r\n    'underscore',\r\n    'Magento_Ui/js/modal/alert',\r\n    'gridstack',\r\n    'gridstackJqueryUi',\r\n    'touchPunch'\r\n], function ($, _, uiAlert) {\r\n    'use strict';\r\n\r\n    $.widget('mageplaza.initGridStack', {\r\n        options: {\r\n            url: '',\r\n            loadCardUrl: '',\r\n            gridWidget: []\r\n        },\r\n        _create: function () {\r\n            this.initGrid();\r\n            this.changeCardPositionObs();\r\n            this.toggleCardTable();\r\n            this.toggleCardVisible();\r\n            this.element.trigger('mpCardLoaded');\r\n        },\r\n        toggleCardTable: function () {\r\n            var cardsTableEl = $('.mp-ar-card.admin__action-dropdown-wrap.admin__data-grid-action-columns');\r\n\r\n            $('button#mp-ar-card').on('click', function () {\r\n                if (cardsTableEl.hasClass('_active')) {\r\n                    cardsTableEl.removeClass('_active');\r\n                } else {\r\n                    cardsTableEl.addClass('_active');\r\n                }\r\n            });\r\n            $('body').on('click', function (e) {\r\n                if (!$(e.target).parents().hasClass('mp-ar-card')) {\r\n                    cardsTableEl.removeClass('_active');\r\n                }\r\n            });\r\n        },\r\n        changeCardPositionObs: function () {\r\n            var self = this;\r\n            var gridStackEl = $('.grid-stack');\r\n\r\n            gridStackEl.on('change', function (event, items) {\r\n                var data = {};\r\n\r\n                if (items === undefined) {\r\n                    return;\r\n                }\r\n                _.each(items, function (item) {\r\n                    data[item.id] = {\r\n                        'x': item.x,\r\n                        'y': item.y,\r\n                        'width': item.width,\r\n                        'height': item.height\r\n                    };\r\n                });\r\n\r\n                self.saveCardPosition(data);\r\n            });\r\n        },\r\n        toggleCardVisible: function () {\r\n            var self = this;\r\n\r\n            $('.admin__action-dropdown-menu-content .admin__control-checkbox').each(function () {\r\n                $(this).change(function () {\r\n                    var cardId = $(this).attr('data-card-id'),\r\n                        cardEl = $('#' + cardId),\r\n                        card, dateRange,\r\n                        dateRangeEl = $('.ar_dashboard #daterange'),\r\n                        compareDateRangEl = $('.ar_dashboard #compare-daterange');\r\n\r\n                    if (cardEl.length < 1) {\r\n                        card = this;\r\n                        dateRange = [\r\n                            dateRangeEl.data('startDate').format('Y-MM-DD'),\r\n                            dateRangeEl.data('endDate').format('Y-MM-DD'),\r\n                        ];\r\n                        if (compareDateRangEl.length) {\r\n                            dateRange[2] = compareDateRangEl.data('startDate').format('Y-MM-DD');\r\n                            dateRange[3] = compareDateRangEl.data('endDate').format('Y-MM-DD');\r\n                        } else {\r\n                            dateRange[2] = dateRange[3] = null;\r\n                        }\r\n                        $.ajax({\r\n                            url: self.options.loadCardUrl,\r\n                            data: {card_id: cardId, dateRange: dateRange},\r\n                            showLoader: true,\r\n                            success: function (result) {\r\n                                if (cardEl.length < 1) {\r\n                                    if (result.html) {\r\n                                        $('.grid-stack').append(result.html);\r\n                                    } else {\r\n                                        uiAlert({\r\n                                            content: result.message\r\n                                        });\r\n                                        return;\r\n                                    }\r\n                                }\r\n                                self.changeCard(card, cardId);\r\n                                $('#' + cardId).trigger('contentUpdated');\r\n                            }\r\n                        });\r\n                    } else {\r\n                        self.changeCard(this, cardId);\r\n                    }\r\n                });\r\n            });\r\n        },\r\n        changeCard: function (card, cardId) {\r\n            var cardEl = $('#' + cardId),\r\n                data = {};\r\n\r\n            if (card.checked) {\r\n                cardEl.removeClass('hide');\r\n                this.options.grid.addWidget(cardEl);\r\n            } else {\r\n                this.options.grid.removeWidget(cardEl, 0);\r\n                cardEl.attr('data-gs-y', 100).attr('data-gs-x', 0);\r\n                cardEl.addClass('hide');\r\n            }\r\n            data[cardId] = {\r\n                'visible': card.checked ? 1 : 0,\r\n                'x': cardEl.attr('data-gs-x'),\r\n                'y': cardEl.attr('data-gs-y'),\r\n                'width': cardEl.attr('data-gs-width'),\r\n                'height': cardEl.attr('data-gs-height')\r\n            };\r\n            // save card position when show/hide card\r\n            this.saveCardPosition(data);\r\n        },\r\n        saveCardPosition: function (data) {\r\n            $.ajax({\r\n                url: this.options.url,\r\n                data: {items: data},\r\n                type: 'POST'\r\n            });\r\n        },\r\n        initGrid: function () {\r\n            var gridStackEl = $('.grid-stack');\r\n            var options = {\r\n                alwaysShowResizeHandle:\r\n                    /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent),\r\n                cellHeight: 30,\r\n                verticalMargin: 10,\r\n                draggable: {handle: '.draggable', scroll: true, appendTo: 'body'},\r\n            };\r\n\r\n            gridStackEl.gridstack(options);\r\n            this.options.grid = gridStackEl.data('gridstack');\r\n        }\r\n    });\r\n\r\n    return $.mageplaza.initGridStack;\r\n});\r\n","Mageplaza_Reports/js/dashboard/initChart.js":"/**\n * Mageplaza\n *\n * NOTICE OF LICENSE\n *\n * This source file is subject to the Mageplaza.com license that is\n * available through the world-wide-web at this URL:\n * https://www.mageplaza.com/LICENSE.txt\n *\n * DISCLAIMER\n *\n * Do not edit or add to this file if you wish to upgrade this extension to newer\n * version in the future.\n *\n * @category    Mageplaza\n * @package     Mageplaza_Reports\n * @copyright   Copyright (c) Mageplaza (https://www.mageplaza.com/)\n * @license     https://www.mageplaza.com/LICENSE.txt\n */\n\ndefine([\n    'jquery',\n    'Magento_Catalog/js/price-utils',\n    'chartBundle'\n], function ($, priceUtils) {\n    'use strict';\n    $.widget('mageplaza.initChart', {\n        options: {\n            chartData: {\n                yUnit: ''\n            }\n        },\n        _create: function () {\n            var ctx  = $('#' + this.options.chartData.name + '-chart'),\n                data = {\n                    type: 'line',\n                    data: this.getData(),\n                    options: this.getOptions()\n                };\n\n            new window.Chart(ctx, data);\n        },\n        getOptions: function () {\n            var self = this;\n\n            return {\n                fillColor: 'rgba(220,220,220,0.9)',\n                legend: {\n                    display: true,\n\n                    position: 'bottom',\n                    labels: {\n                        usePointStyle: true,\n                        fontColor: '#333'\n                    }\n                },\n                tooltips: {\n                    mode: 'index',\n                    intersect: true,\n                    callbacks: {\n                        label: function (tooltipItem, data) {\n                            var dataset = data.datasets[tooltipItem.datasetIndex],\n                                index   = tooltipItem.index;\n\n                            return dataset.labels[index] + ': ' +\n                                (data.yUnit\n                                    ? priceUtils.formatPrice(dataset.data[index], data.yUnit)\n                                    : dataset.data[index]);\n                        },\n                        title: function (tooltipItems, data) {\n                            if (data.index === 'repeatCustomerRate') {\n                                return tooltipItems[0].xLabel;\n                            }\n                            return '';\n                        }\n                    }\n                },\n                scales: {\n                    xAxes: [{\n                        display: true,\n                        labelString: 'Time',\n                        type: 'time',\n                        // distribution: 'series',\n                        time: {\n                            stepSize: this.options.chartData.stepSize,\n                            unit: 'day',\n                            displayFormats: {\n                                day: 'Y-M-D'\n                            }\n                        },\n                        ticks: {\n                            callback: function (label) {\n                                return label;\n                            }\n                        }\n                    }],\n                    yAxes: [{\n                        scaleStartValue: 0,\n                        scaleLabel: {\n                            display: true,\n                            labelUnit: this.options.chartData.yUnit,\n                            labelString: this.options.chartData.yLabel,\n                            scaleStepWidth: 1\n                        },\n                        ticks: {\n                            min: 0,\n                            // Include a currency sign in the ticks\n                            callback: function (value) {\n                                if (Math.floor(value) === value) {\n                                    return self.options.chartData.yUnit\n                                        ? priceUtils.formatPrice(value, self.options.chartData.yUnit)\n                                        : value;\n                                }\n                            }\n                        }\n                    }]\n                }\n            };\n        },\n        getData: function () {\n            var data           = {\n                index: this.options.chartData.name,\n                labels: this.options.chartData['labels'],\n                yUnit: this.options.chartData['yUnit'],\n                datasets: [\n                    {\n                        labels: this.options.chartData['data']['labels'],\n                        label: this.options.chartData['label'][0],\n                        data: this.options.chartData['data']['data'],\n                        backgroundColor: '#977bca',\n                        borderColor: '#6f42c1',\n                        borderWidth: 1,\n                        lineTension: 0.5, //cong\n                        pointBorderWidth: 1,\n                        pointBorderColor: 'transparent',\n                        fill: this.options.chartData.isFill\n                    }\n                ]\n            };\n            var compareDataset = this.getCompareDataSet();\n\n            if (this.options.chartData.isCompare === '1' || this.options.chartData.name === 'repeatCustomerRate') {\n                data.datasets.push(compareDataset);\n            }\n\n            return data;\n        },\n        getCompareDataSet: function () {\n            return {\n                labels: this.options.chartData['compareData']['labels'],\n                label: this.options.chartData['label'][1],\n                data: this.options.chartData['compareData']['data'],\n                backgroundColor: '#59a7b3',\n                borderColor: '#17a2b8',\n                borderWidth: 1,\n                lineTension: 0.5,\n                pointBorderColor: 'transparent',\n                // pointBackgroundColor: 'transparent',\n                // pointHoverBackgroundColor: 'blue',\n                fill: this.options.chartData.isFill\n            };\n        }\n    });\n\n    return $.mageplaza.initChart;\n});\n","Mageplaza_Reports/js/dashboard/initDateRange.js":"/**\r\n * Mageplaza\r\n *\r\n * NOTICE OF LICENSE\r\n *\r\n * This source file is subject to the Mageplaza.com license that is\r\n * available through the world-wide-web at this URL:\r\n * https://www.mageplaza.com/LICENSE.txt\r\n *\r\n * DISCLAIMER\r\n *\r\n * Do not edit or add to this file if you wish to upgrade this extension to newer\r\n * version in the future.\r\n *\r\n * @category    Mageplaza\r\n * @package     Mageplaza_Reports\r\n * @copyright   Copyright (c) Mageplaza (https://www.mageplaza.com/)\r\n * @license     https://www.mageplaza.com/LICENSE.txt\r\n */\r\n\r\ndefine([\r\n    'jquery',\r\n    'moment',\r\n    'daterangepicker'\r\n], function ($, moment) {\r\n    'use strict';\r\n\r\n    var dateRangeEl = $('#daterange'),\r\n        compareDateRangeEl = $('#compare-daterange'),\r\n        dashboardContainer = $('.dashboard-container');\r\n\r\n    $.widget('mageplaza.initDateRange', {\r\n        options: {\r\n            url: '',\r\n            isCompare: ''\r\n        },\r\n\r\n        _create: function () {\r\n            this.initNowDateRange();\r\n            if (this.options.isCompare) {\r\n                this.initCompareDateRange();\r\n                this.initNowDateRangeHideObserver();\r\n            }\r\n            this.initNowDateRangeObserver();\r\n        },\r\n\r\n        initDateRange: function (el, start, end, data) {\r\n            function cb(cbStart, cbEnd) {\r\n                el.find('span').html(cbStart.format('MMM DD, YYYY') + ' - ' + cbEnd.format('MMM DD, YYYY'));\r\n            }\r\n\r\n            el.daterangepicker(data, cb);\r\n            cb(start, end);\r\n        },\r\n\r\n        initNowDateRange: function () {\r\n            var start = moment(this.options.date[0]),\r\n                end = moment(this.options.date[1]),\r\n                dateRangeData = {\r\n                    startDate: start,\r\n                    endDate: end,\r\n                    ranges: {\r\n                        'Today': [moment(), moment()],\r\n                        'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],\r\n                        'Last 7 Days': [moment().subtract(6, 'days'), moment()],\r\n                        'Last 30 Days': [moment().subtract(29, 'days'), moment()],\r\n                        'This Month': [moment().startOf('month'), moment().endOf('month')],\r\n                        'Last Month': [\r\n                            moment().subtract(1, 'month').startOf('month'),\r\n                            moment().subtract(1, 'month').endOf('month')\r\n                        ],\r\n                        'YTD': [moment().subtract(1, 'year'), moment()],\r\n                        '2YTD': [moment().subtract(2, 'year'), moment()]\r\n                    }\r\n                };\r\n\r\n            this.initDateRange(dateRangeEl, start, end, dateRangeData);\r\n        },\r\n\r\n        initCompareDateRange: function (initStartDate, initEndDate) {\r\n            var self = this,\r\n                startDate = initStartDate || dateRangeEl.data().startDate,\r\n                endDate = initEndDate || dateRangeEl.data().endDate,\r\n                days = endDate.diff(startDate, 'days'),\r\n                compareEndDate = moment(startDate.format('Y-MM-DD')).subtract(1, 'days'),\r\n                compareStartDate = moment(compareEndDate.format('Y-MM-DD')).subtract(days, 'days').endOf('days'),\r\n                compareDateRangeData = {\r\n                    startDate: compareStartDate,\r\n                    endDate: compareEndDate,\r\n                    ranges: {\r\n                        'Previous period': [compareStartDate, compareEndDate],\r\n                        'Previous year': [\r\n                            moment(startDate.format('Y-MM-DD')).subtract(1, 'year'),\r\n                            moment(endDate.format('Y-MM-DD')).subtract(1, 'year')\r\n                        ]\r\n                    }\r\n                };\r\n\r\n            this.initDateRange(compareDateRangeEl, compareStartDate, compareEndDate, compareDateRangeData);\r\n\r\n            compareDateRangeEl.on('apply.daterangepicker', function (ev, picker) {\r\n                compareDateRangeEl.data().startDate = picker.startDate;\r\n                compareDateRangeEl.data().endDate = picker.endDate;\r\n                var data = {\r\n                    dateRange: {\r\n                        0: dateRangeEl.data().startDate.format('Y-MM-DD H:m:s'),\r\n                        1: dateRangeEl.data().endDate.format('Y-MM-DD H:m:s'),\r\n                        2: picker.startDate.format('Y-MM-DD H:m:s'),\r\n                        3: picker.endDate.format('Y-MM-DD H:m:s')\r\n                    }\r\n                };\r\n\r\n                self.ajaxSubmit(data);\r\n            });\r\n        },\r\n\r\n        ajaxSubmit: function (data) {\r\n            $.ajax({\r\n                url: this.options.url,\r\n                data: data,\r\n                type: 'POST',\r\n                showLoader: true,\r\n                success: function (res) {\r\n                    var dashboard = $('<div>' + res.dashboard + '</div>').find('.dashboard-container');\r\n\r\n                    dashboardContainer.html(dashboard.html());\r\n                    dashboardContainer.trigger('contentUpdated');\r\n                },\r\n            });\r\n        },\r\n\r\n        initNowDateRangeObserver: function () {\r\n            var self = this;\r\n\r\n            dateRangeEl.on('apply.daterangepicker', function (ev, picker) {\r\n                var data;\r\n\r\n                dateRangeEl.data().startDate = picker.startDate;\r\n                dateRangeEl.data().endDate = picker.endDate;\r\n                data = {\r\n                    dateRange: {\r\n                        0: picker.startDate.format('Y-MM-DD H:m:s'),\r\n                        1: picker.endDate.format('Y-MM-DD H:m:s'),\r\n                        2: self.options.isCompare ? compareDateRangeEl.data().startDate.format('Y-MM-DD H:m:s') : null,\r\n                        3: self.options.isCompare ? compareDateRangeEl.data().endDate.format('Y-MM-DD H:m:s') : null\r\n                    }\r\n                };\r\n\r\n                self.ajaxSubmit(data);\r\n            });\r\n        },\r\n\r\n        initNowDateRangeHideObserver: function () {\r\n            var self = this;\r\n\r\n            dateRangeEl.on('hide.daterangepicker', function (ev, picker) {\r\n                self.initCompareDateRange(picker.startDate, picker.endDate);\r\n            });\r\n        }\r\n    });\r\n\r\n    return $.mageplaza.initDateRange;\r\n});\r\n","Mageplaza_Reports/js/detail/menu.js":"/**\n * Mageplaza\n *\n * NOTICE OF LICENSE\n *\n * This source file is subject to the Mageplaza.com license that is\n * available through the world-wide-web at this URL:\n * https://www.mageplaza.com/LICENSE.txt\n *\n * DISCLAIMER\n *\n * Do not edit or add to this file if you wish to upgrade this extension to newer\n * version in the future.\n *\n * @category    Mageplaza\n * @package     Mageplaza_Reports\n * @copyright   Copyright (c) Mageplaza (https://www.mageplaza.com/)\n * @license     https://www.mageplaza.com/LICENSE.txt\n */\n\ndefine([\n    'jquery',\n    'moment',\n    'uiRegistry',\n    'daterangepicker'\n], function ($, moment, uiRegistry) {\n    'use strict';\n    var dateRangeEl = $('#daterange');\n    var storeSwitcherEl = $('.mp-rp-store-switcher');\n\n    $.widget('mageplaza.menu', {\n        _create: function () {\n            this.initNowDateRange(moment(this.options.date[0]), moment(this.options.date[1]));\n            this.initDateRangeApply();\n            this.initStoreSwitcher();\n            this.initCustomerGroupSelect();\n            this.initPeriodSelect();\n            this.initOrderStatusSelect();\n            this.initDateUsedSelect();\n            this.initColumnsSelect();\n        },\n        initDateRange: function (el, start, end, data) {\n            function cb(cbStart, cbEnd) {\n                el.find('span').html(cbStart.format('MMM DD, YYYY') + ' - ' + cbEnd.format('MMM DD, YYYY'));\n            }\n\n            el.daterangepicker(data, cb);\n            cb(start, end);\n        },\n        initNowDateRange: function (start, end) {\n            var dateRangeData = {\n                startDate: start,\n                endDate: end,\n                ranges: {\n                    'Today': [moment(), moment()],\n                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],\n                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],\n                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],\n                    'This Month': [moment().startOf('month'), moment().endOf('month')],\n                    'Last Month': [\n                        moment().subtract(1, 'month').startOf('month'),\n                        moment().subtract(1, 'month').endOf('month')\n                    ],\n                    'YTD': [moment().subtract(1, 'year'), moment()],\n                    '2YTD': [moment().subtract(2, 'year'), moment()]\n                }\n            };\n\n            this.initDateRange(dateRangeEl, start, end, dateRangeData);\n        },\n        initDateRangeApply: function () {\n            var self = this;\n\n            dateRangeEl.on('apply.daterangepicker', function (ev, picker) {\n                var grid, params;\n\n                self.initNowDateRange(picker.startDate, picker.endDate);\n                self.initDateRangeApply();\n                grid = uiRegistry.get(self.options.gridName);\n                params = grid.get('params');\n                if (typeof params.mpFilter === 'undefined') {\n                    params.mpFilter = {};\n                }\n\n                params.mpFilter.startDate = picker.startDate.format('Y-MM-DD');\n                params.mpFilter.endDate = picker.endDate.format('Y-MM-DD');\n                params.dateRange = [params.mpFilter.startDate, params.mpFilter.endDate, null, null];\n                grid.reload();\n\n            });\n        },\n        initStoreSwitcher: function () {\n            var self = this;\n\n            $('[data-role=\"stores-list\"] a').on(\"click\", function (e) {\n                var grid = uiRegistry.get(self.options.gridName);\n                var params = grid.get('params');\n                var data;\n\n                if (typeof params.mpFilter === 'undefined') {\n                    params.mpFilter = {};\n                }\n                params.mpFilter.store = $(this).attr('data-value');\n                grid.reload();\n\n                data = {\n                    store: $(this).attr('data-value')\n                };\n                $.ajax({\n                    method: 'POST',\n                    url: self.options.storeUrl,\n                    data: data,\n                    success: function (res) {\n                        storeSwitcherEl.html(res.store);\n                        storeSwitcherEl.trigger('contentUpdated');\n                        self.initStoreSwitcher();\n                    }\n                });\n                e.stopPropagation();\n                e.preventDefault();\n            });\n        },\n        initCustomerGroupSelect: function () {\n            var self = this;\n\n            $('.customer-group select').change(function () {\n                var grid = uiRegistry.get(self.options.gridName);\n                var params = grid.get('params');\n\n                if (typeof params.mpFilter === 'undefined') {\n                    params.mpFilter = {};\n                }\n                params.mpFilter['customer_group_id'] = $(this).val();\n                grid.reload();\n            });\n        },\n        initPeriodSelect: function () {\n            var self = this;\n\n            $('.period select').change(function () {\n                var grid = uiRegistry.get(self.options.gridName);\n                var params = grid.get('params');\n\n                if (typeof params.mpFilter === 'undefined') {\n                    params.mpFilter = {};\n                }\n                params.mpFilter.period = $(this).val();\n                grid.reload();\n            });\n        },\n        initDateUsedSelect: function () {\n            var self = this;\n\n            $('.date_used select').change(function () {\n                var grid = uiRegistry.get(self.options.gridName);\n                var params = grid.get('params');\n\n                if (typeof params.mpFilter === 'undefined') {\n                    params.mpFilter = {};\n                }\n                params.mpFilter.dateUsed = $(this).val();\n                grid.reload();\n            });\n        },\n        initOrderStatusSelect: function () {\n            var self = this;\n            var cardsTableEl = $('.mp-rp-order-status.admin__action-dropdown-wrap.admin__data-grid-action-columns');\n\n            $('button#mp-rp-order-status').on('click',function () {\n                if (cardsTableEl.hasClass('_active')) {\n                    cardsTableEl.removeClass('_active');\n                } else {\n                    cardsTableEl.addClass('_active');\n                }\n            });\n            $('.order_status input').on('click',function () {\n                var grid = uiRegistry.get(self.options.gridName);\n                var params = grid.get('params');\n\n                if (typeof params.mpFilter === 'undefined') {\n                    params.mpFilter = {};\n                }\n                params.mpFilter.orderStatus = $('#order_status :input').serializeArray();\n                grid.reload();\n            });\n            $('body').on('click',function (e) {\n                if (!$(e.target).parents().hasClass('mp-rp-order-status')) {\n                    $('.mp-rp-order-status').removeClass('_active');\n                    if ($('.daterangepicker').is(':visible')) {\n                        $('.drp-calendar.left').show();\n                        $('.drp-calendar.right').show();\n                    }\n                }\n            });\n        },\n        initColumnsSelect: function () {\n            $('body').on('click',function (e) {\n                var parent;\n\n                if ($(e.target).is('input')\n                    && $(e.target).hasClass('admin__control-checkbox')\n                    && $(e.target).parents().hasClass('admin__data-grid-action-columns-menu')\n                ) {\n                    $('#mp-grid-tfoot th').hide();\n                    parent = $(e.target).parent().parent();\n                    parent.find('input:checked').each(function () {\n                        var id = $(this).parent().attr('data-repeat-index');\n\n                        $('#mp-grid-tfoot th[id=\"' + id + '\"]').show();\n                    });\n                }\n            });\n        }\n    });\n    return $.mageplaza.menu;\n});\n","Mageplaza_Reports/js/lib/gridstack.jQueryUI.js":"/**\r\n * gridstack.js 1.0.0-dev\r\n * http://troolee.github.io/gridstack.js/\r\n * (c) 2014-2017 Pavel Reznikov, Dylan Weiss\r\n * gridstack.js may be freely distributed under the MIT license.\r\n * @preserve\r\n */\r\n(function(factory) {\r\n    if (typeof define === 'function' && define.amd) {\r\n        define(['jquery', 'lodash', 'gridstack', 'jquery/ui'], factory);\r\n    } else if (typeof exports !== 'undefined') {\r\n        try { jQuery = require('jquery'); } catch (e) {}\r\n        try { _ = require('lodash'); } catch (e) {}\r\n        try { GridStackUI = require('gridstack'); } catch (e) {}\r\n        factory(jQuery, _, GridStackUI);\r\n    } else {\r\n        factory(jQuery, _, GridStackUI);\r\n    }\r\n})(function($, _, GridStackUI) {\r\n\r\n    var scope = window;\r\n\r\n    /**\r\n     * @class JQueryUIGridStackDragDropPlugin\r\n     * jQuery UI implementation of drag'n'drop gridstack plugin.\r\n     */\r\n    function JQueryUIGridStackDragDropPlugin(grid) {\r\n        GridStackUI.GridStackDragDropPlugin.call(this, grid);\r\n    }\r\n\r\n    GridStackUI.GridStackDragDropPlugin.registerPlugin(JQueryUIGridStackDragDropPlugin);\r\n\r\n    JQueryUIGridStackDragDropPlugin.prototype = Object.create(GridStackUI.GridStackDragDropPlugin.prototype);\r\n    JQueryUIGridStackDragDropPlugin.prototype.constructor = JQueryUIGridStackDragDropPlugin;\r\n\r\n    JQueryUIGridStackDragDropPlugin.prototype.resizable = function(el, opts) {\r\n        el = $(el);\r\n        if (opts === 'disable' || opts === 'enable') {\r\n            el.resizable(opts);\r\n        } else if (opts === 'option') {\r\n            var key = arguments[2];\r\n            var value = arguments[3];\r\n            el.resizable(opts, key, value);\r\n        } else {\r\n            var handles = el.data('gs-resize-handles') ? el.data('gs-resize-handles') :\r\n                this.grid.opts.resizable.handles;\r\n            el.resizable(_.extend({}, this.grid.opts.resizable, {\r\n                handles: handles\r\n            }, {\r\n                start: opts.start || function() {},\r\n                stop: opts.stop || function() {},\r\n                resize: opts.resize || function() {}\r\n            }));\r\n        }\r\n        return this;\r\n    };\r\n\r\n    JQueryUIGridStackDragDropPlugin.prototype.draggable = function(el, opts) {\r\n        el = $(el);\r\n        if (opts === 'disable' || opts === 'enable') {\r\n            el.draggable(opts);\r\n        } else {\r\n            el.draggable(_.extend({}, this.grid.opts.draggable, {\r\n                containment: this.grid.opts.isNested ? this.grid.container.parent() : null,\r\n                start: opts.start || function() {},\r\n                stop: opts.stop || function() {},\r\n                drag: opts.drag || function() {}\r\n            }));\r\n        }\r\n        return this;\r\n    };\r\n\r\n    JQueryUIGridStackDragDropPlugin.prototype.droppable = function(el, opts) {\r\n        el = $(el);\r\n        el.droppable(opts);\r\n        return this;\r\n    };\r\n\r\n    JQueryUIGridStackDragDropPlugin.prototype.isDroppable = function(el, opts) {\r\n        el = $(el);\r\n        return Boolean(el.data('droppable'));\r\n    };\r\n\r\n    JQueryUIGridStackDragDropPlugin.prototype.on = function(el, eventName, callback) {\r\n        $(el).on(eventName, callback);\r\n        return this;\r\n    };\r\n\r\n    return JQueryUIGridStackDragDropPlugin;\r\n});"}
}});
