require.config({"config": {
        "jsbuild":{"magnifier/magnifier.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n(function ($) {\n    $.fn.magnify = function (options) {\n        'use strict';\n\n        var magnify = new Magnify($(this), options);\n\n        /* events must be tracked here */\n\n        /**\n         * Return that from _init function\n         *\n         */\n        return magnify;\n    };\n\n    function Magnify(element, options) {\n        var customUserOptions = options || {},\n            $box = $(element),\n            $thumb,\n            that = this,\n            largeWrapper = options.largeWrapper || '.magnifier-preview',\n            $magnifierPreview = $(largeWrapper);\n\n        curThumb = null,\n        magnifierOptions = {\n            x: 0,\n            y: 0,\n            w: 0,\n            h: 0,\n            lensW: 0,\n            lensH: 0,\n            lensBgX: 0,\n            lensBgY: 0,\n            largeW: 0,\n            largeH: 0,\n            largeL: 0,\n            largeT: 0,\n            zoom: 2,\n            zoomMin: 1.1,\n            zoomMax: 5,\n            mode: 'outside',\n            eventType: 'click',\n            status: 0,\n            zoomAttached: false,\n            zoomable: customUserOptions.zoomable !== undefined ?\n                customUserOptions.zoomable\n                : false,\n            onthumbenter: customUserOptions.onthumbenter !== undefined ?\n                customUserOptions.onthumbenter\n                : null,\n            onthumbmove: customUserOptions.onthumbmove !== undefined ?\n                customUserOptions.onthumbmove\n                : null,\n            onthumbleave: customUserOptions.onthumbleave !== undefined ?\n                customUserOptions.onthumbleave\n                : null,\n            onzoom: customUserOptions.onzoom !== undefined ?\n                customUserOptions.onzoom\n                : null\n        },\n        pos = {\n            t: 0,\n            l: 0,\n            x: 0,\n            y: 0\n        },\n        gId = 0,\n        status = 0,\n        curIdx = '',\n        curLens = null,\n        curLarge = null,\n        lensbg = customUserOptions.bg !== undefined ?\n            customUserOptions.lensbg\n            : true,\n        gZoom = customUserOptions.zoom !== undefined ?\n            customUserOptions.zoom\n            : magnifierOptions.zoom,\n        gZoomMin = customUserOptions.zoomMin !== undefined ?\n            customUserOptions.zoomMin\n            : magnifierOptions.zoomMin,\n        gZoomMax = customUserOptions.zoomMax !== undefined ?\n            customUserOptions.zoomMax\n            : magnifierOptions.zoomMax,\n        gMode = customUserOptions.mode || magnifierOptions.mode,\n        gEventType = customUserOptions.eventType || magnifierOptions.eventType,\n        data = {},\n        inBounds = false,\n        isOverThumb = false,\n        rate = 1,\n        paddingX = 0,\n        paddingY = 0,\n        enabled = true,\n        showWrapper = true;\n\n        var MagnifyCls = {\n            magnifyHidden: 'magnify-hidden',\n            magnifyOpaque: 'magnify-opaque',\n            magnifyFull: 'magnify-fullimage'\n        };\n\n        /**\n         * Update Lens positon on.\n         *\n         */\n        that.update = function () {\n            updateLensOnLoad();\n        };\n\n        /**\n         * Init new Magnifier\n         *\n         */\n        that.init = function () {\n            _init($box, options);\n        };\n\n        function _toBoolean(str) {\n            if (typeof str === 'string') {\n                if (str === 'true') {\n                    return true;\n                } else if (str === 'false' || '') {\n                    return false;\n                }\n                console.warn('Wrong type: can\\'t be transformed to Boolean');\n\n            } else if (typeof str === 'boolean') {\n                return str;\n            }\n        }\n\n        function createLens(thumb) {\n            if ($(thumb).siblings('.magnify-lens').length) {\n                return false;\n            }\n            var lens = $('<div class=\"magnify-lens magnify-hidden\" data-gallery-role=\"magnifier-zoom\"></div>');\n\n            $(thumb).parent().append(lens);\n        }\n\n        function updateLensOnLoad(idSelectorMainImg, thumb, largeImgInMagnifyLens, largeWrapper) {\n            var magnifyLensElement= $box.find('.magnify-lens'),\n                textWrapper;\n\n            if (data[idSelectorMainImg].status === 1) {\n                textWrapper = $('<div class=\"magnifier-loader-text\"></div>');\n                magnifyLensElement.className = 'magnifier-loader magnify-hidden';\n                textWrapper.html('Loading...');\n                magnifyLensElement.html('').append(textWrapper);\n            } else if (data[idSelectorMainImg].status === 2) {\n                magnifyLensElement.addClass(MagnifyCls.magnifyHidden);\n                magnifyLensElement.html('');\n\n                largeImgInMagnifyLens.id = idSelectorMainImg + '-large';\n                largeImgInMagnifyLens.style.width = data[idSelectorMainImg].largeImgInMagnifyLensWidth + 'px';\n                largeImgInMagnifyLens.style.height = data[idSelectorMainImg].largeImgInMagnifyLensHeight + 'px';\n                largeImgInMagnifyLens.className = 'magnifier-large magnify-hidden';\n\n                if (data[idSelectorMainImg].mode === 'inside') {\n                    magnifyLensElement.append(largeImgInMagnifyLens);\n                } else {\n                    largeWrapper.html('').append(largeImgInMagnifyLens);\n                }\n            }\n\n            data[idSelectorMainImg].lensH = data[idSelectorMainImg].lensH > $thumb.height() ? $thumb.height() : data[idSelectorMainImg].lensH;\n\n            if (Math.round(data[idSelectorMainImg].lensW) === 0) {\n                magnifyLensElement.css('display', 'none');\n            } else {\n                magnifyLensElement.css({\n                    width: Math.round(data[idSelectorMainImg].lensW) + 'px',\n                    height: Math.round(data[idSelectorMainImg].lensH) + 'px',\n                    display: ''\n                });\n            }\n        }\n\n        function getMousePos() {\n            var xPos = pos.x - magnifierOptions.x,\n                yPos = pos.y - magnifierOptions.y,\n                t,\n                l;\n\n            inBounds =  xPos < 0 || yPos < 0 || xPos > magnifierOptions.w || yPos > magnifierOptions.h  ? false : true;\n\n            l = xPos - magnifierOptions.lensW / 2;\n            t = yPos - magnifierOptions.lensH / 2;\n\n            if (xPos < magnifierOptions.lensW / 2) {\n                l = 0;\n            }\n\n            if (yPos < magnifierOptions.lensH / 2) {\n                t = 0;\n            }\n\n            if (xPos - magnifierOptions.w + Math.ceil(magnifierOptions.lensW / 2) > 0) {\n                l = magnifierOptions.w - Math.ceil(magnifierOptions.lensW + 2);\n            }\n\n            if (yPos - magnifierOptions.h + Math.ceil(magnifierOptions.lensH / 2) > 0) {\n                t = magnifierOptions.h - Math.ceil(magnifierOptions.lensH);\n            }\n\n            pos.l = l;\n            pos.t = t;\n\n            magnifierOptions.lensBgX = pos.l;\n            magnifierOptions.lensBgY = pos.t;\n\n            if (magnifierOptions.mode === 'inside') {\n                magnifierOptions.largeL = Math.round(xPos * (magnifierOptions.zoom - magnifierOptions.lensW / magnifierOptions.w));\n                magnifierOptions.largeT = Math.round(yPos * (magnifierOptions.zoom - magnifierOptions.lensH / magnifierOptions.h));\n            } else {\n                magnifierOptions.largeL = Math.round(magnifierOptions.lensBgX * magnifierOptions.zoom * (magnifierOptions.largeWrapperW / magnifierOptions.w));\n                magnifierOptions.largeT = Math.round(magnifierOptions.lensBgY * magnifierOptions.zoom * (magnifierOptions.largeWrapperH / magnifierOptions.h));\n            }\n        }\n\n        function onThumbEnter() {\n            if (_toBoolean(enabled)) {\n                magnifierOptions = data[curIdx];\n                curLens = $box.find('.magnify-lens');\n\n                if (magnifierOptions.status === 2) {\n                    curLens.removeClass(MagnifyCls.magnifyOpaque);\n                    curLarge = $('#' + curIdx + '-large');\n                    curLarge.removeClass(MagnifyCls.magnifyHidden);\n                } else if (magnifierOptions.status === 1) {\n                    curLens.className = 'magnifier-loader';\n                }\n            }\n        }\n\n        function onThumbLeave() {\n            if (magnifierOptions.status > 0) {\n                var handler = magnifierOptions.onthumbleave;\n\n                if (handler !== null) {\n                    handler({\n                        thumb: curThumb,\n                        lens: curLens,\n                        large: curLarge,\n                        x: pos.x,\n                        y: pos.y\n                    });\n                }\n\n                if (!curLens.hasClass(MagnifyCls.magnifyHidden)) {\n                    curLens.addClass(MagnifyCls.magnifyHidden);\n\n                    //$curThumb.removeClass(MagnifyCls.magnifyOpaque);\n                    if (curLarge !== null) {\n                        curLarge.addClass(MagnifyCls.magnifyHidden);\n                    }\n                }\n            }\n        }\n\n        function move() {\n            if (_toBoolean(enabled)) {\n                if (status !== magnifierOptions.status) {\n                    onThumbEnter();\n                }\n\n                if (magnifierOptions.status > 0) {\n                    curThumb.className = magnifierOptions.thumbCssClass + ' magnify-opaque';\n\n                    if (magnifierOptions.status === 1) {\n                        curLens.className = 'magnifier-loader';\n                    } else if (magnifierOptions.status === 2) {\n                        curLens.removeClass(MagnifyCls.magnifyHidden);\n                        curLarge.removeClass(MagnifyCls.magnifyHidden);\n                        curLarge.css({\n                            left: '-' + magnifierOptions.largeL + 'px',\n                            top: '-' + magnifierOptions.largeT + 'px'\n                        });\n                    }\n\n                    var borderOffset = 2; // Offset for magnify-lens border\n                    pos.t = pos.t <= 0 ? 0 : pos.t - borderOffset;\n\n                    curLens.css({\n                        left: pos.l + paddingX + 'px',\n                        top: pos.t + paddingY + 'px'\n                    });\n\n                    if (lensbg) {\n                        curLens.css({\n                            'background-color': 'rgba(f,f,f,.5)'\n                        });\n                    } else {\n                        curLens.get(0).style.backgroundPosition = '-' +\n                        magnifierOptions.lensBgX + 'px -' +\n                        magnifierOptions.lensBgY + 'px';\n                    }\n                    var handler = magnifierOptions.onthumbmove;\n\n                    if (handler !== null) {\n                        handler({\n                            thumb: curThumb,\n                            lens: curLens,\n                            large: curLarge,\n                            x: pos.x,\n                            y: pos.y\n                        });\n                    }\n                }\n\n                status = magnifierOptions.status;\n            }\n        }\n\n        function setThumbData(mainImage, mainImageData) {\n            var thumbBounds = mainImage.getBoundingClientRect(),\n                w = 0,\n                h = 0;\n\n            mainImageData.x = Math.round(thumbBounds.left);\n            mainImageData.y = Math.round(thumbBounds.top);\n            mainImageData.w = Math.round(thumbBounds.right - mainImageData.x);\n            mainImageData.h = Math.round(thumbBounds.bottom - mainImageData.y);\n\n            if (mainImageData.mode === 'inside') {\n                w = mainImageData.w;\n                h = mainImageData.h;\n            } else {\n                w = mainImageData.largeWrapperW;\n                h = mainImageData.largeWrapperH;\n            }\n\n            mainImageData.largeImgInMagnifyLensWidth = Math.round(mainImageData.zoom * w);\n            mainImageData.largeImgInMagnifyLensHeight = Math.round(mainImageData.zoom * h);\n\n            mainImageData.lensW = Math.round(mainImageData.w / mainImageData.zoom);\n            mainImageData.lensH = Math.round(mainImageData.h / mainImageData.zoom);\n        }\n\n        function _init($box, options) {\n            var opts = {};\n\n            if (options.thumb === undefined) {\n                return false;\n            }\n\n            $thumb = $box.find(options.thumb);\n\n            if ($thumb.length) {\n                for (var key in options) {\n                    opts[key] = options[key];\n                }\n\n                opts.thumb = $thumb;\n                enabled = opts.enabled;\n\n                if (_toBoolean(enabled)) {\n\n                    $magnifierPreview.show().css('display', '');\n                    $magnifierPreview.addClass(MagnifyCls.magnifyHidden);\n                    set(opts);\n                } else {\n                    $magnifierPreview.empty().hide();\n                }\n            }\n\n            return that;\n        }\n\n        function hoverEvents(thumb) {\n            $(thumb).on('mouseover', function (e) {\n\n                if (showWrapper) {\n\n                    if (magnifierOptions.status !== 0) {\n                        onThumbLeave();\n                    }\n                    handleEvents(e);\n                    isOverThumb = inBounds;\n                }\n            }).trigger('mouseover');\n        }\n\n        function clickEvents(thumb) {\n            $(thumb).on('click', function (e) {\n\n                if (showWrapper) {\n                    if (!isOverThumb) {\n                        if (magnifierOptions.status !== 0) {\n                            onThumbLeave();\n                        }\n                        handleEvents(e);\n                        isOverThumb = true;\n                    }\n                }\n            });\n        }\n\n        function bindEvents(eType, thumb) {\n            var eventFlag = 'hasBoundEvent_' + eType;\n            if (thumb[eventFlag]) {\n                // Events are already bound, no need to bind in duplicate\n                return;\n            }\n            thumb[eventFlag] = true;\n\n            switch (eType) {\n                case 'hover':\n                    hoverEvents(thumb);\n                    break;\n\n                case 'click':\n                    clickEvents(thumb);\n                    break;\n            }\n        }\n\n        function handleEvents(e) {\n            var src = e.target;\n\n            curIdx = src.id;\n            curThumb = src;\n\n            onThumbEnter(src);\n\n            setThumbData(curThumb, magnifierOptions);\n\n            pos.x = e.clientX;\n            pos.y = e.clientY;\n\n            getMousePos();\n            move();\n\n            var handler = magnifierOptions.onthumbenter;\n\n            if (handler !== null) {\n                handler({\n                    thumb: curThumb,\n                    lens: curLens,\n                    large: curLarge,\n                    x: pos.x,\n                    y: pos.y\n                });\n            }\n        }\n\n        function set(options) {\n            if (data[options.thumb.id] !== undefined) {\n                curThumb = options.thumb;\n\n                return false;\n            }\n\n            var thumbObj = new Image(),\n                largeObj = new Image(),\n                $thumb = options.thumb,\n                thumb = $thumb.get(0),\n                idx = thumb.id,\n                largeUrl,\n                largeWrapper = $(options.largeWrapper),\n                zoom = options.zoom || thumb.getAttribute('data-zoom') || gZoom,\n                zoomMin = options.zoomMin || gZoomMin,\n                zoomMax = options.zoomMax || gZoomMax,\n                mode = options.mode || thumb.getAttribute('data-mode') || gMode,\n                eventType = options.eventType || thumb.getAttribute('data-eventType') || gEventType,\n                onthumbenter = options.onthumbenter !== undefined ?\n                    options.onthumbenter\n                    : magnifierOptions.onthumbenter,\n                onthumbleave = options.onthumbleave !== undefined ?\n                    options.onthumbleave\n                    : magnifierOptions.onthumbleave,\n                onthumbmove = options.onthumbmove !== undefined ?\n                    options.onthumbmove\n                    : magnifierOptions.onthumbmove;\n\n            largeUrl = $thumb.data('original') || customUserOptions.full || $thumb.attr('src');\n\n            if (thumb.id === '') {\n                idx = thumb.id = 'magnifier-item-' + gId;\n                gId += 1;\n            }\n\n            createLens(thumb, idx);\n\n            if (options.width) {\n                largeWrapper.width(options.width);\n            }\n\n            if (options.height) {\n                largeWrapper.height(options.height);\n            }\n\n            if (options.top) {\n                if (typeof options.top == 'function') {\n                    var top = options.top() + 'px';\n                } else {\n                    var top = options.top + 'px';\n                }\n\n                if (largeWrapper.length) {\n                    largeWrapper[0].style.top = top.replace('%px', '%');\n                }\n            }\n\n            if (options.left) {\n                if (typeof options.left == 'function') {\n                    var left = options.left() + 'px';\n                } else {\n                    var left = options.left + 'px';\n                }\n\n                if (largeWrapper.length) {\n                    largeWrapper[0].style.left = left.replace('%px', '%');\n                }\n            }\n\n            data[idx] = {\n                zoom: zoom,\n                zoomMin: zoomMin,\n                zoomMax: zoomMax,\n                mode: mode,\n                eventType: eventType,\n                thumbCssClass: thumb.className,\n                zoomAttached: false,\n                status: 0,\n                largeUrl: largeUrl,\n                largeWrapperId: mode === 'outside' ? largeWrapper.attr('id') : null,\n                largeWrapperW: mode === 'outside' ? largeWrapper.width() : null,\n                largeWrapperH: mode === 'outside' ? largeWrapper.height() : null,\n                onthumbenter: onthumbenter,\n                onthumbleave: onthumbleave,\n                onthumbmove: onthumbmove\n            };\n\n            paddingX = ($thumb.parent().width() - $thumb.width()) / 2;\n            paddingY = ($thumb.parent().height() - $thumb.height()) / 2;\n\n            showWrapper = false;\n            $(thumbObj).on('load', function () {\n                data[idx].status = 1;\n\n                $(largeObj).on('load', function () {\n\n                    if (largeObj.width > largeWrapper.width() || largeObj.height > largeWrapper.height()) {\n                        showWrapper = true;\n                        bindEvents(eventType, thumb);\n                        data[idx].status = 2;\n                        if (largeObj.width > largeObj.height) {\n                            data[idx].zoom = largeObj.width / largeWrapper.width();\n                        } else {\n                            data[idx].zoom = largeObj.height / largeWrapper.height();\n                        }\n                        setThumbData(thumb, data[idx]);\n                        updateLensOnLoad(idx, thumb, largeObj, largeWrapper);\n                    }\n                });\n\n                largeObj.src = data[idx].largeUrl;\n            });\n\n            thumbObj.src = thumb.src;\n        }\n\n        /**\n         * Hide magnifier when mouse exceeds image bounds.\n         */\n        function onMouseLeave() {\n            onThumbLeave();\n            isOverThumb = false;\n            $magnifierPreview.addClass(MagnifyCls.magnifyHidden);\n        }\n\n        function onMousemove(e) {\n            pos.x = e.clientX;\n            pos.y = e.clientY;\n\n            getMousePos();\n\n            if (gEventType === 'hover') {\n                isOverThumb = inBounds;\n            }\n\n            if (inBounds && isOverThumb) {\n                if (gMode === 'outside') {\n                    $magnifierPreview.removeClass(MagnifyCls.magnifyHidden);\n                }\n                move();\n            }\n        }\n\n        function onScroll() {\n            if (curThumb !== null) {\n                setThumbData(curThumb, magnifierOptions);\n            }\n        }\n\n        $(window).on('scroll', onScroll);\n        $(window).resize(function () {\n            _init($box, customUserOptions);\n        });\n\n        $box.on('mousemove', onMousemove);\n        $box.on('mouseleave', onMouseLeave);\n\n        _init($box, customUserOptions);\n    }\n}(jQuery));\n","Magento_PaypalCaptcha/js/model/skipRefreshCaptcha.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['ko'], function (ko) {\n    'use strict';\n\n    return {\n        skip: ko.observable(false)\n    };\n});\n","Magento_PaypalCaptcha/js/view/payment/list-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Captcha/js/model/captchaList'\n], function ($, captchaList) {\n    'use strict';\n\n    var mixin = {\n\n        formId: 'co-payment-form',\n\n        /**\n         * Sets custom template for Payflow Pro\n         *\n         * @param {Object} payment\n         * @returns {Object}\n         */\n        createComponent: function (payment) {\n\n            var component = this._super(payment);\n\n            if (component.component === 'Magento_Paypal/js/view/payment/method-renderer/payflowpro-method') {\n                component.template = 'Magento_PaypalCaptcha/payment/payflowpro-form';\n                $(window).off('clearTimeout')\n                    .on('clearTimeout', this.clearTimeout.bind(this));\n            }\n\n            return component;\n        },\n\n        /**\n         * Overrides default window.clearTimeout() to catch errors from iframe and reload Captcha.\n         *\n         * @param {Number} timeoutID\n         */\n        clearTimeout: function (timeoutID) {\n            var captcha = captchaList.getCaptchaByFormId(this.formId);\n\n            if (captcha !== null) {\n                captcha.refresh();\n            }\n            clearTimeout(timeoutID);\n        }\n    };\n\n    /**\n     * Overrides `Magento_Checkout/js/view/payment/list::createComponent`\n     */\n    return function (target) {\n        return target.extend(mixin);\n    };\n});\n","Magento_PaypalCaptcha/js/view/payment/method-renderer/payflowpro-method-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_PaypalCaptcha/js/model/skipRefreshCaptcha'\n], function (skipRefreshCaptcha) {\n    'use strict';\n\n    var payflowProMethodMixin = {\n        /**\n         * @override\n         */\n        placeOrder: function () {\n            skipRefreshCaptcha.skip(true);\n            this._super();\n        }\n    };\n\n    return function (payflowProMethod) {\n        return payflowProMethod.extend(payflowProMethodMixin);\n    };\n});\n","Magento_PaypalCaptcha/js/view/checkout/paymentCaptcha.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Captcha/js/view/checkout/defaultCaptcha',\n    'Magento_Captcha/js/model/captchaList',\n    'Magento_Captcha/js/model/captcha'\n],\nfunction ($, defaultCaptcha, captchaList, Captcha) {\n    'use strict';\n\n    return defaultCaptcha.extend({\n\n        /** @inheritdoc */\n        initialize: function () {\n            var captchaConfigPayment,\n                currentCaptcha;\n\n            this._super();\n\n            if (window[this.configSource] && window[this.configSource].captchaPayments) {\n                captchaConfigPayment = window[this.configSource].captchaPayments;\n\n                $.each(captchaConfigPayment, function (formId, captchaData) {\n                    var captcha;\n\n                    captchaData.formId = formId;\n                    captcha = Captcha(captchaData);\n                    captchaList.add(captcha);\n                });\n            }\n\n            currentCaptcha = captchaList.getCaptchaByFormId(this.formId);\n\n            if (currentCaptcha != null) {\n                currentCaptcha.setIsVisible(true);\n                this.setCurrentCaptcha(currentCaptcha);\n            }\n        }\n    });\n});\n","Magento_PaypalCaptcha/js/view/checkout/defaultCaptcha-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_PaypalCaptcha/js/model/skipRefreshCaptcha'\n], function (skipRefreshCaptcha) {\n    'use strict';\n\n    var defaultCaptchaMixin = {\n        /**\n         * @override\n         */\n        refresh: function () {\n            if (!skipRefreshCaptcha.skip()) {\n                this._super();\n            } else {\n                skipRefreshCaptcha.skip(false);\n            }\n        }\n    };\n\n    return function (defaultCaptcha) {\n        return defaultCaptcha.extend(defaultCaptchaMixin);\n    };\n});\n","PayPal_Braintree/js/validator.js":"/**\n * Copyright \u00a9 2013-2017 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    return {\n        config: {},\n\n        /**\n         * Set configuration\n         * @param {Object} config\n         */\n        setConfig: function (config) {\n            this.config = config;\n        },\n\n        /**\n         * Get List of available card types\n         * @returns {*|exports.defaults.availableCardTypes|{}}\n         */\n        getAvailableCardTypes: function () {\n            return this.config.availableCardTypes;\n        },\n\n        /**\n         * Get list of card types\n         * @returns {Object}\n         */\n        getCcTypesMapper: function () {\n            return this.config.ccTypesMapper;\n        },\n\n        /**\n         * Find mage card type by Braintree type\n         * @param {String} type\n         * @param {Object} availableTypes\n         * @returns {*}\n         */\n        getMageCardType: function (type, availableTypes) {\n            var storedCardType = null,\n                mapper = this.getCcTypesMapper();\n\n            if (type && typeof mapper[type] !== 'undefined') {\n                storedCardType = mapper[type];\n\n                if (_.indexOf(availableTypes, storedCardType) !== -1) {\n                    return storedCardType;\n                }\n            }\n\n            return null;\n        },\n\n        /**\n         * Filter list of available card types\n         * @param {Object} availableTypes\n         * @param {Object} countrySpecificCardTypes\n         * @returns {Object}\n         */\n        collectTypes: function (availableTypes, countrySpecificCardTypes) {\n            var key,\n                filteredTypes = [];\n\n            for (key in availableTypes) {\n                if (_.indexOf(countrySpecificCardTypes, availableTypes[key]) !== -1) {\n                    filteredTypes.push(availableTypes[key]);\n                }\n            }\n\n            return filteredTypes;\n        },\n\n        /**\n         * Get list of card types for country\n         * @param {String} countryId\n         * @returns {*}\n         */\n        getCountrySpecificCardTypes: function (countryId) {\n            if (typeof this.config.countrySpecificCardTypes[countryId] !== 'undefined') {\n                return this.config.countrySpecificCardTypes[countryId];\n            }\n\n            return false;\n        }\n    };\n});\n","PayPal_Braintree/js/form-builder.js":"/**\n * Copyright \u00a9 2013-2017 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'jquery',\n        'underscore',\n        'mage/template'\n    ],\n    function ($, _, mageTemplate) {\n        'use strict';\n\n        return {\n\n            /**\n             * @param {Object} formData\n             * @returns {*|jQuery}\n             */\n            build: function (formData) {\n                var formTmpl = mageTemplate('<form action=\"<%= data.action %>\"' +\n                    ' method=\"POST\" hidden enctype=\"application/x-www-form-urlencoded\">' +\n                        '<% _.each(data.fields, function(val, key){ %>' +\n                            '<input value=\\'<%= val %>\\' name=\"<%= key %>\" type=\"hidden\">' +\n                        '<% }); %>' +\n                    '</form>');\n\n                return $(formTmpl({\n                    data: {\n                        action: formData.action,\n                        fields: formData.fields\n                    }\n                })).appendTo($('[data-container=\"body\"]'));\n            }\n        };\n    }\n);\n","PayPal_Braintree/js/googlepay/button.js":"/**\n * Braintree Google Pay button\n **/\ndefine(\n    [\n        'uiComponent',\n        \"knockout\",\n        \"jquery\",\n        'braintree',\n        'braintreeGooglePay',\n        'mage/translate',\n        'googlePayLibrary'\n        ],\n    function (\n        Component,\n        ko,\n        jQuery,\n        braintree,\n        googlePay,\n        $t\n    ) {\n        'use strict';\n\n        return {\n            init: function (element, context) {\n                // No element or context\n                if (!element || !context || !this.deviceSupported()) {\n                    return;\n                }\n\n                // Context must implement these methods\n                if (typeof context.getClientToken !== 'function') {\n                    console.error(\"Braintree GooglePay Context passed does not provide a getClientToken method\", context);\n                    return;\n                }\n                if (typeof context.getPaymentRequest !== 'function') {\n                    console.error(\"Braintree GooglePay Context passed does not provide a getPaymentRequest method\", context);\n                    return;\n                }\n                if (typeof context.startPlaceOrder !== 'function') {\n                    console.error(\"Braintree GooglePay Context passed does not provide a startPlaceOrder method\", context);\n                    return;\n                }\n\n                // init google pay object\n                var paymentsClient = new google.payments.api.PaymentsClient({\n                    environment: context.getEnvironment()\n                });\n\n                // Create a button within the KO element, as google pay can only be instantiated through\n                // a valid on click event (ko onclick bind interferes with this).\n                var button = document.createElement('button');\n                button.className = \"braintree-googlepay-button long \" + (context.getBtnColor() == 1 ? 'black' : 'white');\n                button.title = $t(\"Buy with Google Pay\");\n\n                // init braintree api\n                braintree.create({\n                    authorization: context.getClientToken()\n                }, function (clientErr, clientInstance) {\n                    if (clientErr) {\n                        console.error('Error creating client:', clientErr);\n                        return;\n                    }\n\n                    googlePay.create({\n                        client: clientInstance\n                    }, function (googlePayErr, googlePaymentInstance) {\n                        // No instance\n                        if (googlePayErr) {\n                            console.error('Braintree GooglePay Error creating googlePayInstance:', googlePayErr);\n                            return;\n                        }\n\n                        paymentsClient.isReadyToPay({\n                            allowedPaymentMethods: googlePaymentInstance.createPaymentDataRequest().allowedPaymentMethods\n                        }).then(function(response) {\n                            if (response.result) {\n                                button.addEventListener('click', function (event) {\n                                    event.preventDefault();\n                                    jQuery(\"body\").loader('show');\n                                    var responseData;\n\n                                    var paymentDataRequest = googlePaymentInstance.createPaymentDataRequest(context.getPaymentRequest());\n                                    paymentsClient.loadPaymentData(paymentDataRequest).then(function (paymentData) {\n                                        // Persist the paymentData (shipping address etc)\n                                        responseData = paymentData;\n                                        // Return the braintree nonce promise\n                                        return googlePaymentInstance.parseResponse(paymentData);\n                                    }).then(function (result) {\n                                        context.startPlaceOrder(result.nonce, responseData);\n                                    }).catch(function (err) {\n                                        // Handle errors\n                                        // err = {statusCode: \"CANCELED\"}\n                                        console.error(err);\n                                        jQuery(\"body\").loader('hide');\n                                    });\n                                });\n\n                                element.appendChild(button);\n                            }\n                        }).catch(function (err) {\n                            console.error(err);\n                            jQuery(\"body\").loader('hide');\n                        });\n                    });\n                });\n            },\n\n            deviceSupported: function() {\n                return !!(window.PaymentRequest);\n            }\n        };\n    }\n);","PayPal_Braintree/js/googlepay/api.js":"/**\n * Braintree Google Pay button api\n **/\ndefine([\n    'uiComponent',\n    'mage/translate',\n    'mage/storage',\n    'jquery',\n    'PayPal_Braintree/js/form-builder'\n], function (Component, $t, storage, jQuery, formBuilder) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            clientToken: null,\n            merchantId: null,\n            currencyCode: null,\n            actionSuccess: null,\n            amount: null,\n            cardTypes: [],\n            btnColor: 0\n        },\n\n        /**\n         * Set & get environment\n         * \"PRODUCTION\" or \"TEST\"\n         */\n        setEnvironment: function (value) {\n            this.environment = value;\n        },\n        getEnvironment: function () {\n            return this.environment;\n        },\n\n        /**\n         * Set & get api token\n         */\n        setClientToken: function (value) {\n            this.clientToken = value;\n        },\n        getClientToken: function () {\n            return this.clientToken;\n        },\n\n        /**\n         * Set and get display name\n         */\n        setMerchantId: function (value) {\n            this.merchantId = value;\n        },\n        getMerchantId: function () {\n            return this.merchantId;\n        },\n\n        /**\n         * Set and get currency code\n         */\n        setAmount: function (value) {\n            this.amount = parseFloat(value).toFixed(2);\n        },\n        getAmount: function () {\n            return this.amount;\n        },\n\n        /**\n         * Set and get currency code\n         */\n        setCurrencyCode: function (value) {\n            this.currencyCode = value;\n        },\n        getCurrencyCode: function () {\n            return this.currencyCode;\n        },\n\n        /**\n         * Set and get success redirection url\n         */\n        setActionSuccess: function (value) {\n            this.actionSuccess = value;\n        },\n        getActionSuccess: function () {\n            return this.actionSuccess;\n        },\n\n        /**\n         * Set and get success redirection url\n         */\n        setCardTypes: function (value) {\n            this.cardTypes = value;\n        },\n        getCardTypes: function () {\n            return this.cardTypes;\n        },\n\n        /**\n         * BTN Color\n         */\n        setBtnColor: function (value) {\n            this.btnColor = value;\n        },\n        getBtnColor: function () {\n            return this.btnColor;\n        },\n\n        /**\n         * Payment request info\n         */\n        getPaymentRequest: function () {\n            var result = {\n                transactionInfo: {\n                    totalPriceStatus: 'ESTIMATED',\n                    totalPrice: this.getAmount(),\n                    currencyCode: this.getCurrencyCode()\n                },\n                allowedPaymentMethods: ['CARD'],\n                phoneNumberRequired: true,\n                emailRequired: true,\n                shippingAddressRequired: true,\n                cardRequirements: {\n                    billingAddressRequired: true,\n                    billingAddressFormat: 'FULL',\n                    allowedCardNetworks: this.getCardTypes()\n                }\n            };\n\n            if (this.getEnvironment() !== \"TEST\") {\n                result['merchantId'] = this.getMerchantId();\n            }\n\n            return result;\n        },\n\n        /**\n         * Place the order\n         */\n        startPlaceOrder: function (nonce, paymentData) {\n            var payload = {\n                details: {\n                    shippingAddress: {\n                        streetAddress: paymentData.shippingAddress.address1 + \"\\n\"\n                        + paymentData.shippingAddress.address2,\n                        locality: paymentData.shippingAddress.locality,\n                        postalCode: paymentData.shippingAddress.postalCode,\n                        countryCodeAlpha2: paymentData.shippingAddress.countryCode,\n                        email: paymentData.email,\n                        name: paymentData.shippingAddress.name,\n                        telephone: typeof paymentData.shippingAddress.phoneNumber !== 'undefined' ? paymentData.shippingAddress.phoneNumber : '',\n                        region: typeof paymentData.shippingAddress.administrativeArea !== 'undefined' ? paymentData.shippingAddress.administrativeArea : ''\n                    },\n                    billingAddress: {\n                        streetAddress: paymentData.cardInfo.billingAddress.address1 + \"\\n\"\n                        + paymentData.cardInfo.billingAddress.address2,\n                        locality: paymentData.cardInfo.billingAddress.locality,\n                        postalCode: paymentData.cardInfo.billingAddress.postalCode,\n                        countryCodeAlpha2: paymentData.cardInfo.billingAddress.countryCode,\n                        email: paymentData.email,\n                        name: paymentData.cardInfo.billingAddress.name,\n                        telephone: typeof paymentData.cardInfo.billingAddress.phoneNumber !== 'undefined' ? paymentData.cardInfo.billingAddress.phoneNumber : '',\n                        region: typeof paymentData.cardInfo.billingAddress.administrativeArea !== 'undefined' ? paymentData.cardInfo.billingAddress.administrativeArea : ''\n                    }\n                },\n                nonce: nonce\n            };\n\n            formBuilder.build({\n                action: this.getActionSuccess(),\n                fields: {\n                    result: JSON.stringify(payload)\n                }\n            }).submit();\n        }\n    });\n});","PayPal_Braintree/js/googlepay/implementations/shortcut.js":"/**\n * Braintree Google Pay mini cart payment method integration.\n **/\ndefine(\n    [\n        'uiComponent',\n        'PayPal_Braintree/js/googlepay/button',\n        'PayPal_Braintree/js/googlepay/api',\n        'mage/translate',\n        'domReady!'\n    ],\n    function (\n        Component,\n        button,\n        buttonApi,\n        $t\n    ) {\n        'use strict';\n\n        return Component.extend({\n\n            defaults: {\n                id: null,\n                clientToken: null,\n                merchantId: null,\n                currencyCode: null,\n                actionSuccess: null,\n                amount: null,\n                environment: \"TEST\",\n                cardType: [],\n                btnColor: 0\n            },\n\n            /**\n             * @returns {Object}\n             */\n            initialize: function () {\n                this._super();\n\n                var api = new buttonApi();\n                api.setEnvironment(this.environment);\n                api.setCurrencyCode(this.currencyCode);\n                api.setClientToken(this.clientToken);\n                api.setMerchantId(this.merchantId);\n                api.setActionSuccess(this.actionSuccess);\n                api.setAmount(this.amount);\n                api.setCardTypes(this.cardTypes)\n                api.setBtnColor(this.btnColor);\n\n                // Attach the button\n                button.init(\n                    document.getElementById(this.id),\n                    api\n                );\n\n                return this;\n            }\n        });\n    }\n);\n","PayPal_Braintree/js/googlepay/implementations/core-checkout/method-googlepay.js":"define(\n    ['uiComponent', 'Magento_Checkout/js/model/payment/renderer-list'],\n    function (Component, rendererList) {\n        'use strict';\n\n        rendererList.push(\n            {\n                type: 'braintree_googlepay',\n                component: 'PayPal_Braintree/js/googlepay/implementations/core-checkout/method-renderer/googlepay'\n            }\n        );\n\n        return Component.extend({});\n    }\n);","PayPal_Braintree/js/googlepay/implementations/core-checkout/method-renderer/googlepay.js":"/**\n * Braintree Google Pay payment method integration.\n **/\ndefine([\n    'Magento_Checkout/js/view/payment/default',\n    'Magento_Checkout/js/model/quote',\n    'PayPal_Braintree/js/googlepay/button'\n], function (\n    Component,\n    quote,\n    button\n) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'PayPal_Braintree/googlepay/core-checkout',\n            paymentMethodNonce: null,\n            deviceSupported: button.deviceSupported(),\n            grandTotalAmount: 0\n        },\n\n        /**\n         * Inject the google pay button into the target element\n         */\n        getGooglePayBtn: function (id) {\n            button.init(\n                document.getElementById(id),\n                this\n            );\n        },\n\n        /**\n         * Subscribe to grand totals\n         */\n        initObservable: function () {\n            this._super();\n            this.grandTotalAmount = parseFloat(quote.totals()['base_grand_total']).toFixed(2);\n            this.currencyCode = quote.totals()['base_currency_code'];\n\n            quote.totals.subscribe(function () {\n                if (this.grandTotalAmount !== quote.totals()['base_grand_total']) {\n                    this.grandTotalAmount = parseFloat(quote.totals()['base_grand_total']).toFixed(2);\n                }\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Google pay place order method\n         */\n        startPlaceOrder: function (nonce, paymentData) {\n            this.setPaymentMethodNonce(nonce);\n            this.placeOrder();\n        },\n\n        /**\n         * Save nonce\n         */\n        setPaymentMethodNonce: function (nonce) {\n            this.paymentMethodNonce = nonce;\n        },\n\n        /**\n         * Retrieve the client token\n         * @returns null|string\n         */\n        getClientToken: function () {\n            return window.checkoutConfig.payment[this.getCode()].clientToken;\n        },\n\n        /**\n         * Payment request info\n         */\n        getPaymentRequest: function () {\n           var result = {\n                transactionInfo: {\n                    totalPriceStatus: 'FINAL',\n                    totalPrice: this.grandTotalAmount,\n                    currencyCode: this.currencyCode\n                },\n                allowedPaymentMethods: ['CARD'],\n                phoneNumberRequired: false,\n                emailRequired: false,\n                shippingAddressRequired: false,\n                cardRequirements: {\n                    billingAddressRequired: false,\n                    allowedCardNetworks: this.getCardTypes()\n                }\n            };\n\n           if (this.getEnvironment() !== \"TEST\") {\n               result['merchantId'] = this.getMerchantId();\n           }\n\n           return result;\n        },\n\n        /**\n         * Merchant display name\n         */\n        getMerchantId: function () {\n            return window.checkoutConfig.payment[this.getCode()].merchantId;\n        },\n\n        /**\n         * Environment\n         */\n        getEnvironment: function () {\n            return window.checkoutConfig.payment[this.getCode()].environment;\n        },\n\n        /**\n         * Card Types\n         */\n        getCardTypes: function () {\n            return window.checkoutConfig.payment[this.getCode()].cardTypes;\n        },\n\n        /**\n         * BTN Color\n         */\n        getBtnColor: function () {\n            return window.checkoutConfig.payment[this.getCode()].btnColor;\n        },\n\n        /**\n         * Get data\n         * @returns {Object}\n         */\n        getData: function () {\n            return {\n                'method': this.getCode(),\n                'additional_data': {\n                    'payment_method_nonce': this.paymentMethodNonce\n                }\n            };\n        },\n\n        /**\n         * Return image url for the google pay mark\n         */\n        getPaymentMarkSrc: function () {\n            return window.checkoutConfig.payment[this.getCode()].paymentMarkSrc;\n        }\n    });\n});","PayPal_Braintree/js/reCaptcha/braintree-cc-method-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_Checkout/js/model/payment/additional-validators'\n], function ($, additionalValidators) {\n    'use strict';\n\n    return function (originalComponent) {\n        return originalComponent.extend({\n            /**\n             * Initializes reCaptcha\n             */\n            placeOrder: function () {\n                var original = this._super.bind(this),\n                    // jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n                    isEnabled = window.checkoutConfig.recaptcha_braintree,\n                    // jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n                    paymentFormSelector = $('#co-payment-form'),\n                    startEvent = 'captcha:startExecute',\n                    endEvent = 'captcha:endExecute';\n\n                if (!additionalValidators.validate() || !isEnabled) {\n                    return original();\n                }\n\n                paymentFormSelector.off(endEvent).on(endEvent, function () {\n                        original();\n                        paymentFormSelector.off(endEvent);\n                    }\n                );\n\n                paymentFormSelector.trigger(startEvent);\n            }\n        });\n    };\n});\n","PayPal_Braintree/js/reCaptcha/reCaptcha.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(\n    [\n        'Magento_ReCaptchaFrontendUi/js/reCaptcha',\n        'jquery'\n    ],\n    function (Component, $) {\n        'use strict';\n\n        return Component.extend({\n\n            /**\n             * Recaptcha callback\n             * @param {String} token\n             */\n            reCaptchaCallback: function (token) {\n                this.tokenField.value = token;\n                this.$parentForm.trigger('captcha:endExecute');\n            },\n\n            /**\n             * Initialize parent form.\n             *\n             * @param {Object} parentForm\n             * @param {String} widgetId\n             */\n            initParentForm: function (parentForm, widgetId) {\n                var me = this;\n\n                parentForm.on('captcha:startExecute', function (event) {\n                    if (!me.tokenField.value && me.getIsInvisibleRecaptcha()) {\n                        // eslint-disable-next-line no-undef\n                        grecaptcha.execute(widgetId);\n                        event.preventDefault(event);\n                        event.stopImmediatePropagation();\n                    } else {\n                        me.$parentForm.trigger('captcha:endExecute');\n                    }\n                });\n                // Create a virtual token field\n                this.tokenField = $('<input type=\"text\" id=\"token-grecaptcha-braintree\" name=\"token-grecaptcha-braintree\" style=\"display: none\" />')[0];\n                this.$parentForm = parentForm;\n                parentForm.append(this.tokenField);\n            }\n        });\n    }\n);\n","PayPal_Braintree/js/paypal/form-builder.js":"/**\n * Copyright \u00a9 2013-2017 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'jquery',\n        'underscore',\n        'mage/template'\n    ],\n    function ($, _, mageTemplate) {\n        'use strict';\n\n        return {\n\n            /**\n             * @param {Object} formData\n             * @returns {*|jQuery}\n             */\n            build: function (formData) {\n                var formTmpl = mageTemplate('<form action=\"<%= data.action %>\"' +\n                    ' method=\"POST\" hidden enctype=\"application/x-www-form-urlencoded\">' +\n                        '<% _.each(data.fields, function(val, key){ %>' +\n                            '<input value=\\'<%= val %>\\' name=\"<%= key %>\" type=\"hidden\">' +\n                        '<% }); %>' +\n                    '</form>');\n\n                return $(formTmpl({\n                    data: {\n                        action: formData.action,\n                        fields: formData.fields\n                    }\n                })).appendTo($('[data-container=\"body\"]'));\n            }\n        };\n    }\n);\n","PayPal_Braintree/js/paypal/button.js":"/**\n * Copyright \u00a9 2013-2017 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'rjsResolver',\n        'uiRegistry',\n        'uiComponent',\n        'underscore',\n        'jquery',\n        'Magento_Customer/js/customer-data',\n        'mage/translate',\n        'braintree',\n        'braintreeDataCollector',\n        'braintreePayPalCheckout',\n        'PayPal_Braintree/js/form-builder',\n        'domReady!'\n    ],\n    function (\n        resolver,\n        registry,\n        Component,\n        _,\n        $,\n        customerData,\n        $t,\n        braintree,\n        dataCollector,\n        paypalCheckout,\n        formBuilder\n    ) {\n        'use strict';\n        let buttonIds = [];\n\n\n        return {\n            events: {\n                onClick: null,\n                onCancel: null,\n                onError: null\n            },\n\n            init: function (token, currency) {\n                if($('.action-braintree-paypal-message').length) {\n                    $('.product-add-form form').on('keyup change paste', 'input, select, textarea', function(){\n                        var currentPrice, currencySymbol;\n                        currentPrice = $(\".product-info-main span\").find(\"[data-price-type='finalPrice']\").text();\n                        currencySymbol = $('.action-braintree-paypal-message[data-pp-type=\"product\"]').data('currency-symbol');\n                        $('.action-braintree-paypal-message[data-pp-type=\"product\"]').attr('data-pp-amount', currentPrice.replace(currencySymbol,''));\n                    });\n                }\n\n                buttonIds = [];\n                $('.action-braintree-paypal-logo').each(function () {\n                    if(!$(this).hasClass( \"button-loaded\" )) {\n                        $(this).addClass('button-loaded');\n                        buttonIds.push($(this).attr('id'));\n                    }\n                });\n\n                if(buttonIds.length > 0){\n                    this.loadSDK(token, currency);\n                }\n            },\n\n            loadSDK: function (token, currency) {\n                braintree.create({\n                    authorization: token\n                }, function (clientErr, clientInstance) {\n                    if (clientErr) {\n                        console.error('paypalCheckout error', clientErr);\n                        return this.showError(\"PayPal Checkout could not be initialized. Please contact the store owner.\");\n                    }\n                    dataCollector.create({\n                        client: clientInstance,\n                        paypal: true\n                    }, function (err, dataCollectorInstance) {\n                        if (err) {\n                            return console.log(err);\n                        }\n                    });\n                    paypalCheckout.create({\n                        client: clientInstance\n                    }, function (err, paypalCheckoutInstance) {\n                        if (typeof paypal !== 'undefined' ) {\n                            this.renderpayPalButtons(buttonIds, paypalCheckoutInstance);\n                            this.renderpayPalMessages();\n                        } else {\n                            paypalCheckoutInstance.loadPayPalSDK({\n                                components: 'buttons,messages,funding-eligibility',\n                                \"enable-funding\":\"paylater\",\n                                currency: currency,\n                            }, function () {\n                                this.renderpayPalButtons(buttonIds, paypalCheckoutInstance);\n                                this.renderpayPalMessages();\n                            }.bind(this));\n                        }\n\n\n                    }.bind(this));\n                }.bind(this));\n            },\n            renderpayPalButtons: function(ids, paypalCheckoutInstance) {\n                _.each(ids,function(id) {\n                    this.payPalButton(id, paypalCheckoutInstance);\n\n                }.bind(this));\n            },\n\n            renderpayPalMessages: function() {\n                $('.action-braintree-paypal-message').each(function () {\n                    paypal.Messages({\n                        amount: $(this).data('pp-amount'),\n                        pageType: $(this).data('pp-type'),\n                        style: {\n                            layout: 'text',\n                        }\n                    }).render('#' + $(this).attr('id'));\n\n\n                });\n            },\n\n            payPalButton: function(id, paypalCheckoutInstance) {\n\n                let data = $('#' + id);\n                let style = {\n                    color: data.data('color'),\n                    shape: data.data('shape'),\n                    size: data.data('size'),\n                };\n\n                if (data.data('fundingicons')) {\n                    style.fundingicons = data.data('fundingicons');\n                }\n\n                // Render\n                var paypalActions;\n                var button = paypal.Buttons({\n                    fundingSource: data.data('funding'),\n                    style: style,\n                    createOrder: function () {\n                        return paypalCheckoutInstance.createPayment(\n                            {\n                                amount: data.data('amount'),\n                                locale: data.data('locale'),\n                                currency: data.data('currency'),\n                                flow: 'checkout',\n                                enableShippingAddress: true,\n                                displayName: data.data('displayname')\n                            });\n                    },\n                    validate: function(actions) {\n                        var cart = customerData.get('cart'),\n                            customer = customerData.get('customer'),\n                            declinePayment = false,\n                            isGuestCheckoutAllowed;\n                        isGuestCheckoutAllowed = cart().isGuestCheckoutAllowed;\n                        declinePayment = !customer().firstname && !isGuestCheckoutAllowed;\n                        if (declinePayment) {\n                            actions.disable();\n                        }\n                        paypalActions = actions;\n                    },\n\n                    onCancel: function (data) {\n                        jQuery(\"#maincontent\").trigger('processStop');\n\n                        /*if (typeof events.onCancel === 'function') {\n                            events.onCancel();\n                        }*/\n                    },\n\n                    onError: function (err) {\n                        console.error('paypalCheckout button render error', err);\n                        jQuery(\"#maincontent\").trigger('processStop');\n\n\n                        /*if (typeof events.onError === 'function') {\n                            events.onError(err);\n                        }*/\n                    },\n\n                    onClick: function(data) {\n\n                        var cart = customerData.get('cart'),\n                            customer = customerData.get('customer'),\n                            declinePayment = false,\n                            isGuestCheckoutAllowed;\n                        isGuestCheckoutAllowed = cart().isGuestCheckoutAllowed;\n                        declinePayment = !customer().firstname && !isGuestCheckoutAllowed && (typeof isGuestCheckoutAllowed !== 'undefined');\n                        if (declinePayment) {\n                            alert($t('To check out, please sign in with your email address.'));\n                        }\n\n                        /*if (typeof events.onClick === 'function') {\n                            events.onClick(data);\n                        }*/\n                    },\n\n                    onApprove: function (data1)  {\n                        return paypalCheckoutInstance.tokenizePayment(data1, function (err, payload) {\n                            jQuery(\"#maincontent\").trigger('processStart');\n\n                            // Map the shipping address correctly\n                            var address = payload.details.shippingAddress;\n                            var recipientName = address.recipientName.split(\" \");\n                            payload.details.shippingAddress = {\n                                streetAddress: typeof address.line2 !== 'undefined' ? address.line1.replace(/'/g, \"&apos;\") + \" \" + address.line2.replace(/'/g, \"&apos;\") : address.line1.replace(/'/g, \"&apos;\"),\n                                locality: address.city.replace(/'/g, \"&apos;\"),\n                                postalCode: address.postalCode,\n                                countryCodeAlpha2: address.countryCode,\n                                email: payload.details.email.replace(/'/g, \"&apos;\"),\n                                firstname: recipientName[0].replace(/'/g, \"&apos;\"),\n                                lastname: recipientName[1].replace(/'/g, \"&apos;\"),\n                                telephone: typeof payload.details.phone !== 'undefined' ? payload.details.phone : '',\n                                region: typeof address.state !== 'undefined' ? address.state.replace(/'/g, \"&apos;\") : ''\n                            };\n\n                            payload.details.email = payload.details.email.replace(/'/g, \"&apos;\");\n                            payload.details.firstName = payload.details.firstName.replace(/'/g, \"&apos;\");\n                            payload.details.lastName = payload.details.lastName.replace(/'/g, \"&apos;\");\n                            if (typeof payload.details.businessName !== 'undefined') {\n                                payload.details.businessName = payload.details.businessName.replace(/'/g, \"&apos;\");\n                            }\n\n                            // Map the billing address correctly\n                            let isRequiredBillingAddress = data.data('requiredbillingaddress');\n                            if ((isRequiredBillingAddress === 1) && (typeof payload.details.billingAddress !== 'undefined')) {\n                                var billingAddress = payload.details.billingAddress;\n                                payload.details.billingAddress = {\n                                    streetAddress: typeof billingAddress.line2 !== 'undefined' ? billingAddress.line1.replace(/'/g, \"&apos;\") + \" \" + billingAddress.line2.replace(/'/g, \"&apos;\") : billingAddress.line1.replace(/'/g, \"&apos;\"),\n                                    locality: billingAddress.city.replace(/'/g, \"&apos;\"),\n                                    postalCode: billingAddress.postalCode,\n                                    countryCodeAlpha2: billingAddress.countryCode,\n                                    telephone: typeof payload.details.phone !== 'undefined' ? payload.details.phone : '',\n                                    region: typeof billingAddress.state !== 'undefined' ? billingAddress.state.replace(/'/g, \"&apos;\") : ''\n                                };\n                            }\n\n                            if(data.data('location') == 'productpage') {\n                                var form = $(\"#product_addtocart_form\");\n                                if (!(form.validation() && form.validation('isValid'))) {\n                                    return false;\n                                }\n                                payload.additionalData = form.serialize();\n                            }\n\n                            var actionSuccess = data.data('actionsuccess');\n                            formBuilder.build(\n                                {\n                                    action: actionSuccess,\n                                    fields: {\n                                        result: JSON.stringify(payload)\n                                    }\n                                }\n                            ).submit();\n                        });\n                    }\n                });\n                if (!button.isEligible()) {\n                    console.log('PayPal button is not elligible')\n                    data.parent().remove();\n                    return;\n                }\n                button.render('#' + data.attr('id'));\n            },\n        }\n    }\n);","PayPal_Braintree/js/paypal/product-page.js":"define(\n    ['PayPal_Braintree/js/paypal/button', 'jquery'],\n    function (button, $) {\n        'use strict';\n\n        return button.extend({\n\n            defaults: {\n                label: 'buynow',\n                branding: true,\n            },\n\n            /**\n             * The validation on the add-to-cart form is done after the PayPal window has opened.\n             * This is because the validate method exposed by the PP Button requires an event to disable/enable the button.\n             * We can't fire an event due to the way the mage.validation widget works and we can't do something gross like\n             * an interval because the validation() method shows the error messages and focuses the user's input on the\n             * first erroring input field.\n             * @param payload\n             * @returns {*}\n             */\n            beforeSubmit: function (payload) {\n                var form = $(\"#product_addtocart_form\");\n\n                if (!(form.validation() && form.validation('isValid'))) {\n                    return false;\n                }\n\n                payload.additionalData = form.serialize();\n\n                return payload;\n            }\n        });\n    }\n);","PayPal_Braintree/js/paypal/credit/calculator.js":"define([\n    'underscore',\n    'uiComponent',\n    'jquery'\n], function (_, Component, $) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: \"PayPal_Braintree/credit/calculator\",\n            displaySummary: true, // \"From X per month\"\n            displayInterestDetails: false, // Display the more in-depth summary of interest rates\n            instalmentsFrom: 0,\n            currentInstalment: {\n                term: 0,\n                monthlyPayment: 0,\n                apr: 0,\n                cost: 0,\n                costIncInterest: 0\n            },\n            endpoint: null,\n            instalments: [],\n            visible: false,\n            merchantName: ''\n        },\n\n        initObservable: function () {\n            this._super();\n            if (this.instalments.length > 0) {\n                this.currentInstalment = this.instalments[0];\n                this.instalmentsFrom = this.instalments[this.instalments.length-1].monthlyPayment;\n                this.visible = true;\n            } else {\n                this.loadInstalments();\n            }\n\n            this.observe(['instalments', 'currentInstalment', 'instalmentsFrom', 'visible']);\n            return this;\n        },\n\n        isCurrentInstalment: function (term) {\n            return (this.currentInstalment().term === term);\n        },\n\n        setCurrentInstalment: function (instalment) {\n            this.currentInstalment(instalment);\n        },\n\n        loadInstalments: function () {\n            if (!this.endpoint) {\n                return false;\n            }\n\n            var self = this;\n            require(['Magento_Checkout/js/model/quote', 'jquery'], function (quote, $) {\n                if (typeof quote.totals().base_grand_total === 'undefined') {\n                    return false;\n                }\n\n                $.getJSON(self.endpoint, {amount: quote.totals().base_grand_total}, function (response) {\n                    self.instalments(response);\n                    self.setCurrentInstalment(response[0]);\n                    self.visible(true);\n                });\n            });\n        }\n    });\n});\n","PayPal_Braintree/js/model/step-navigator-mixin.js":"define([\n    'mage/utils/wrapper',\n    'jquery'\n], function (wrapper, $) {\n    'use strict';\n\n    let mixin = {\n        handleHash: function (originalFn) {\n            var hashString = window.location.hash.replace('#', '');\n            if (hashString.indexOf('venmo') > -1) {\n                return false;\n            }\n\n            return originalFn();\n        }\n    };\n\n    return function (target) {\n        return wrapper.extend(target, mixin);\n    };\n});\n","PayPal_Braintree/js/view/product-page.js":"define(\n    ['uiComponent'],\n    function (Component) {\n        'use strict';\n\n        return Component.extend({\n\n        });\n    }\n);","PayPal_Braintree/js/view/payment/adapter.js":"/**\n * Copyright 2013-2017 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine([\n    'jquery',\n    'braintree',\n    'braintreeDataCollector',\n    'braintreeHostedFields',\n    'Magento_Checkout/js/model/full-screen-loader',\n    'Magento_Ui/js/model/messageList',\n    'mage/translate'\n], function ($, client, dataCollector, hostedFields, fullScreenLoader, globalMessageList, $t) {\n    'use strict';\n\n    return {\n        apiClient: null,\n        config: {},\n        checkout: null,\n        deviceData: null,\n        clientInstance: null,\n        hostedFieldsInstance: null,\n        paypalInstance: null,\n        code: 'braintree',\n\n        /**\n         * {Object}\n         */\n        events: {\n            onClick: null,\n            onCancel: null,\n            onError: null\n        },\n\n        /**\n         * Get Braintree api client\n         * @returns {Object}\n         */\n        getApiClient: function () {\n            return this.clientInstance;\n        },\n\n        /**\n         * Set configuration\n         * @param {Object} config\n         */\n        setConfig: function (config) {\n            this.config = config;\n        },\n\n        /**\n         * Get payment name\n         * @returns {String}\n         */\n        getCode: function () {\n            return this.code;\n        },\n\n        /**\n         * Get client token\n         * @returns {String|*}\n         */\n        getClientToken: function () {\n            return window.checkoutConfig.payment[this.getCode()].clientToken;\n        },\n\n        /**\n         * @returns {String}\n         */\n        getEnvironment: function () {\n            return window.checkoutConfig.payment[this.getCode()].environment;\n        },\n\n        /**\n         * @returns {String}\n         */\n        getColor: function () {\n            return window.checkoutConfig.payment[this.getCode()].style.color;\n        },\n\n        /**\n         * @returns {String}\n         */\n        getShape: function () {\n            return window.checkoutConfig.payment[this.getCode()].style.shape;\n        },\n\n        /**\n         * @returns {String}\n         */\n        getLayout: function () {\n            return window.checkoutConfig.payment[this.getCode()].style.layout;\n        },\n\n        /**\n         * @returns {String}\n         */\n        getSize: function () {\n            return window.checkoutConfig.payment[this.getCode()].style.size;\n        },\n\n        /**\n         * @returns {String}\n         */\n        getLabel: function () {\n            return null;\n        },\n\n        /**\n         * @returns {String}\n         */\n        getBranding: function () {\n            return null;\n        },\n\n        /**\n         * @returns {String}\n         */\n        getFundingIcons: function () {\n            return null;\n        },\n\n        /**\n         * @returns {String}\n         */\n        getDisabledFunding: function () {\n            return window.checkoutConfig.payment[this.getCode()].disabledFunding;\n        },\n\n        /**\n         * Show error message\n         *\n         * @param {String} errorMessage\n         */\n        showError: function (errorMessage) {\n            globalMessageList.addErrorMessage({\n                message: errorMessage\n            });\n            fullScreenLoader.stopLoader(true);\n        },\n\n        /**\n         * Disable submit button\n         */\n        disableButton: function () {\n            // stop any previous shown loaders\n            fullScreenLoader.stopLoader(true);\n            fullScreenLoader.startLoader();\n            $('[data-button=\"place\"]').attr('disabled', 'disabled');\n        },\n\n        /**\n         * Enable submit button\n         */\n        enableButton: function () {\n            $('[data-button=\"place\"]').removeAttr('disabled');\n            fullScreenLoader.stopLoader();\n        },\n\n        /**\n         * Has PayPal been init'd already\n         */\n        getPayPalInstance: function() {\n            if (typeof this.config.paypalInstance !== 'undefined' && this.config.paypalInstance) {\n                return this.config.paypalInstance;\n            }\n\n            return null;\n        },\n\n        setPayPalInstance: function(val) {\n            this.config.paypalInstance = val;\n        },\n\n        /**\n         * Setup Braintree SDK\n         */\n        setup: function (callback) {\n            if (!this.getClientToken()) {\n                this.showError($t('Sorry, but something went wrong.'));\n                return;\n            }\n\n            if (this.clientInstance) {\n                if (typeof this.config.onReady === 'function') {\n                    this.config.onReady(this);\n                }\n\n                if (typeof callback === \"function\") {\n                    callback(this.clientInstance);\n                }\n                return;\n            }\n\n            client.create({\n                authorization: this.getClientToken()\n            }, function (clientErr, clientInstance) {\n                if (clientErr) {\n                    console.error('Braintree Setup Error', clientErr);\n                    return this.showError(\"Sorry, but something went wrong. Please contact the store owner.\");\n                }\n\n                var options = {\n                    client: clientInstance\n                };\n\n                if (typeof this.config.dataCollector === 'object' && typeof this.config.dataCollector.paypal === 'boolean') {\n                    options.paypal = true;\n                } else {\n                    options.kount = true;\n                }\n\n                dataCollector.create(options, function (err, dataCollectorInstance) {\n                    if (err) {\n                        return console.log(err);\n                    }\n\n                    this.deviceData = dataCollectorInstance.deviceData;\n                    this.config.onDeviceDataRecieved(this.deviceData);\n                }.bind(this));\n\n                this.clientInstance = clientInstance;\n\n                if (typeof this.config.onReady === 'function') {\n                    this.config.onReady(this);\n                }\n\n                if (typeof callback === \"function\") {\n                    callback(this.clientInstance);\n                }\n            }.bind(this));\n        },\n\n        /**\n         * Setup hosted fields instance\n         */\n        setupHostedFields: function () {\n            var self = this;\n\n            if (this.hostedFieldsInstance) {\n                this.hostedFieldsInstance.teardown(function () {\n                    this.hostedFieldsInstance = null;\n                    this.setupHostedFields();\n                }.bind(this));\n                return;\n            }\n\n            hostedFields.create({\n                client: this.clientInstance,\n                fields: this.config.hostedFields,\n                styles: {\n                    \"input\": {\n                        \"font-size\": \"14pt\",\n                        \"color\": \"#3A3A3A\"\n                    },\n                    \":focus\": {\n                        \"color\": \"black\"\n                    },\n                    \".valid\": {\n                        \"color\": \"green\"\n                    },\n                    \".invalid\": {\n                        \"color\": \"red\"\n                    }\n                }\n            }, function (createErr, hostedFieldsInstance) {\n                if (createErr) {\n                    self.showError($t(\"Braintree hosted fields could not be initialized. Please contact the store owner.\"));\n                    console.error('Braintree hosted fields error', createErr);\n                    return;\n                }\n\n                this.config.onInstanceReady(hostedFieldsInstance);\n                this.hostedFieldsInstance = hostedFieldsInstance;\n            }.bind(this));\n        },\n\n        tokenizeHostedFields: function () {\n            this.hostedFieldsInstance.tokenize({}, function (tokenizeErr, payload) {\n                if (tokenizeErr) {\n                    switch (tokenizeErr.code) {\n                        case 'HOSTED_FIELDS_FIELDS_EMPTY':\n                            // occurs when none of the fields are filled in\n                            console.error('All fields are empty! Please fill out the form.');\n                            break;\n                        case 'HOSTED_FIELDS_FIELDS_INVALID':\n                            // occurs when certain fields do not pass client side validation\n                            console.error('Some fields are invalid:', tokenizeErr.details.invalidFieldKeys);\n                            break;\n                        case 'HOSTED_FIELDS_TOKENIZATION_FAIL_ON_DUPLICATE':\n                            // occurs when:\n                            //   * the client token used for client authorization was generated\n                            //     with a customer ID and the fail on duplicate payment method\n                            //     option is set to true\n                            //   * the card being tokenized has previously been vaulted (with any customer)\n                            // See: https://developers.braintreepayments.com/reference/request/client-token/generate/#options.fail_on_duplicate_payment_method\n                            console.error('This payment method already exists in your vault.');\n                            break;\n                        case 'HOSTED_FIELDS_TOKENIZATION_CVV_VERIFICATION_FAILED':\n                            // occurs when:\n                            //   * the client token used for client authorization was generated\n                            //     with a customer ID and the verify card option is set to true\n                            //     and you have credit card verification turned on in the Braintree\n                            //     control panel\n                            //   * the cvv does not pass verfication (https://developers.braintreepayments.com/reference/general/testing/#avs-and-cvv/cid-responses)\n                            // See: https://developers.braintreepayments.com/reference/request/client-token/generate/#options.verify_card\n                            console.error('CVV did not pass verification');\n                            break;\n                        case 'HOSTED_FIELDS_FAILED_TOKENIZATION':\n                            // occurs for any other tokenization error on the server\n                            console.error('Tokenization failed server side. Is the card valid?');\n                            break;\n                        case 'HOSTED_FIELDS_TOKENIZATION_NETWORK_ERROR':\n                            // occurs when the Braintree gateway cannot be contacted\n                            console.error('Network error occurred when tokenizing.');\n                            break;\n                        default:\n                            console.error('Something bad happened!', tokenizeErr);\n                    }\n                } else {\n                    this.config.onPaymentMethodReceived(payload);\n                }\n            }.bind(this));\n        }\n    };\n});\n\n","PayPal_Braintree/js/view/payment/3d-secure.js":"/**\n * Copyright \u00a9 2013-2017 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\n\ndefine([\n    'jquery',\n    'PayPal_Braintree/js/view/payment/adapter',\n    'Magento_Checkout/js/model/quote',\n    'mage/translate',\n    'braintreeThreeDSecure',\n    'Magento_Checkout/js/model/full-screen-loader'\n], function ($, braintree, quote, $t, threeDSecure, fullScreenLoader) {\n    'use strict';\n\n    return {\n        config: null,\n\n        /**\n         * Set 3d secure config\n         * @param {Object} config\n         */\n        setConfig: function (config) {\n            this.config = config;\n            this.config.thresholdAmount = parseFloat(config.thresholdAmount);\n        },\n\n        /**\n         * Get code\n         * @returns {String}\n         */\n        getCode: function () {\n            return 'three_d_secure';\n        },\n\n        /**\n         * convert Non-ASCII characters into unicode\n         * @param str\n         * @returns {string}\n         */\n        escapeNonAsciiCharacters: function (str) {\n            return str.split(\"\").map(function (c) { return /^[\\x00-\\x7F]$/.test(c) ? c : c.split(\"\").map(function (a) { return \"\\\\u00\" + a.charCodeAt().toString(16)}).join(\"\")}).join(\"\");\n        },\n\n        /**\n         * Validate Braintree payment nonce\n         * @param {Object} context\n         * @returns {Object}\n         */\n        validate: function (context) {\n            var clientInstance = braintree.getApiClient(),\n                state = $.Deferred(),\n                totalAmount = parseFloat(quote.totals()['base_grand_total']).toFixed(2),\n                billingAddress = quote.billingAddress();\n\n            if (billingAddress.regionCode !== undefined && billingAddress.regionCode.length > 2) {\n                billingAddress.regionCode = undefined;\n            }\n\n            // No 3d secure if using CVV verification on vaulted cards\n            if (quote.paymentMethod().method.indexOf('braintree_cc_vault_') !== -1) {\n                if (this.config.useCvvVault === true) {\n                    state.resolve();\n                    return state.promise();\n                }\n            }\n\n            if (!this.isAmountAvailable(totalAmount) || !this.isCountryAvailable(billingAddress.countryId)) {\n                state.resolve();\n                return state.promise();\n            }\n\n            var firstName = this.escapeNonAsciiCharacters(billingAddress.firstname);\n            var lastName = this.escapeNonAsciiCharacters(billingAddress.lastname);\n\n            fullScreenLoader.startLoader();\n\n            var setup3d = function(clientInstance) {\n                threeDSecure.create({\n                    version: 2,\n                    client: clientInstance\n                }, function (threeDSecureErr, threeDSecureInstance) {\n                    if (threeDSecureErr) {\n                        fullScreenLoader.stopLoader();\n                        return state.reject($t('Please try again with another form of payment.'));\n                    }\n\n                    var threeDSContainer = document.createElement('div'),\n                        tdmask = document.createElement('div'),\n                        tdframe = document.createElement('div'),\n                        tdbody = document.createElement('div');\n\n                    threeDSContainer.id = 'braintree-three-d-modal';\n                    tdmask.className =\"bt-mask\";\n                    tdframe.className =\"bt-modal-frame\";\n                    tdbody.className =\"bt-modal-body\";\n\n                    tdframe.appendChild(tdbody);\n                    threeDSContainer.appendChild(tdmask);\n                    threeDSContainer.appendChild(tdframe);\n\n                    threeDSecureInstance.verifyCard({\n                        amount: totalAmount,\n                        nonce: context.paymentMethodNonce,\n                        billingAddress: {\n                            givenName: firstName,\n                            surname: lastName,\n                            phoneNumber: billingAddress.telephone,\n                            streetAddress: billingAddress.street[0],\n                            extendedAddress: billingAddress.street[1],\n                            locality: billingAddress.city,\n                            region: billingAddress.regionCode,\n                            postalCode: billingAddress.postcode,\n                            countryCodeAlpha2: billingAddress.countryId\n                        },\n                        onLookupComplete: function (data, next) {\n                            next();\n                        },\n                        addFrame: function (err, iframe) {\n                            fullScreenLoader.stopLoader();\n\n                            if (err) {\n                                console.log(\"Unable to verify card over 3D Secure\", err);\n                                return state.reject($t('Please try again with another form of payment.'));\n                            }\n\n                            tdbody.appendChild(iframe);\n                            document.body.appendChild(threeDSContainer);\n                        },\n                        removeFrame: function () {\n                            fullScreenLoader.startLoader();\n                            document.body.removeChild(threeDSContainer);\n                        }\n                    }, function (err, response) {\n                        fullScreenLoader.stopLoader();\n\n                        if (err) {\n                            console.error(\"3dsecure validation failed\", err);\n                            return state.reject($t('Please try again with another form of payment.'));\n                        }\n\n                        var liability = {\n                            shifted: response.liabilityShifted,\n                            shiftPossible: response.liabilityShiftPossible\n                        };\n\n                        if (liability.shifted || !liability.shifted && !liability.shiftPossible) {\n                            context.paymentMethodNonce = response.nonce;\n                            state.resolve();\n                        } else {\n                            state.reject($t('Please try again with another form of payment.'));\n                        }\n                    });\n                });\n            };\n\n            if (!clientInstance) {\n                require(['PayPal_Braintree/js/view/payment/method-renderer/cc-form'], function(c) {\n                    var config = c.extend({\n                        defaults: {\n                            clientConfig: {\n                                onReady: function() {}\n                            }\n                        }\n                    });\n                    braintree.setConfig(config.defaults.clientConfig);\n                    braintree.setup(setup3d);\n                });\n            } else {\n                setup3d(clientInstance);\n            }\n\n            return state.promise();\n        },\n\n        /**\n         * Check minimal amount for 3d secure activation\n         * @param {Number} amount\n         * @returns {Boolean}\n         */\n        isAmountAvailable: function (amount) {\n            amount = parseFloat(amount);\n\n            return amount >= this.config.thresholdAmount;\n        },\n\n        /**\n         * Check if current country is available for 3d secure\n         * @param {String} countryId\n         * @returns {Boolean}\n         */\n        isCountryAvailable: function (countryId) {\n            var key,\n                specificCountries = this.config.specificCountries;\n\n            // all countries are available\n            if (!specificCountries.length) {\n                return true;\n            }\n\n            for (key in specificCountries) {\n                if (countryId === specificCountries[key]) {\n                    return true;\n                }\n            }\n\n            return false;\n        }\n    };\n});\n","PayPal_Braintree/js/view/payment/braintree.js":"/**\n * Copyright \u00a9 2013-2017 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'uiComponent',\n        'Magento_Checkout/js/model/payment/renderer-list'\n    ],\n    function (\n        Component,\n        rendererList\n    ) {\n        'use strict';\n\n        let config = window.checkoutConfig.payment,\n            braintreeType = 'braintree',\n            payPalType = 'braintree_paypal',\n            braintreeAchDirectDebit = 'braintree_ach_direct_debit';\n\n        if (config[braintreeType].isActive) {\n            rendererList.push(\n                {\n                    type: braintreeType,\n                    component: 'PayPal_Braintree/js/view/payment/method-renderer/hosted-fields'\n                }\n            );\n        }\n\n        if (config[payPalType].isActive) {\n            rendererList.push(\n                {\n                    type: payPalType,\n                    component: 'PayPal_Braintree/js/view/payment/method-renderer/paypal'\n                }\n            );\n        }\n\n        rendererList.push(\n            {\n                type: 'braintree_venmo',\n                component: 'PayPal_Braintree/js/view/payment/method-renderer/venmo'\n            }\n        );\n\n        rendererList.push(\n            {\n                type: braintreeAchDirectDebit,\n                component: 'PayPal_Braintree/js/view/payment/method-renderer/ach'\n            }\n        );\n\n        rendererList.push(\n            {\n                type: 'braintree_local_payment',\n                component: 'PayPal_Braintree/js/view/payment/method-renderer/lpm'\n            }\n        );\n\n        /** Add view logic here if needed */\n        return Component.extend({});\n    }\n);\n","PayPal_Braintree/js/view/payment/venmo.js":"define(\n    [\n        'uiComponent',\n        'Magento_Checkout/js/model/payment/renderer-list'\n    ],\n    function (\n        Component,\n        rendererList\n    ) {\n        'use strict';\n\n        rendererList.push(\n            {\n                type: 'braintree_venmo',\n                component: 'PayPal_Braintree/js/view/payment/method-renderer/venmo'\n            }\n        );\n\n        return Component.extend({});\n    }\n);\n","PayPal_Braintree/js/view/payment/ach.js":"define(\n    [\n        'uiComponent',\n        'Magento_Checkout/js/model/payment/renderer-list'\n    ],\n    function (\n        Component,\n        rendererList\n    ) {\n        'use strict';\n\n        rendererList.push(\n            {\n                type: 'braintree_ach_direct_debit',\n                component: 'PayPal_Braintree/js/view/payment/method-renderer/ach'\n            }\n        );\n\n        return Component.extend({});\n    }\n);\n","PayPal_Braintree/js/view/payment/lpm.js":"define(\n    [\n        'uiComponent',\n        'Magento_Checkout/js/model/payment/renderer-list'\n    ],\n    function (\n        Component,\n        rendererList\n    ) {\n        'use strict';\n\n        rendererList.push(\n            {\n                type: 'braintree_local_payment',\n                component: 'PayPal_Braintree/js/view/payment/method-renderer/lpm'\n            }\n        );\n\n        return Component.extend({});\n    }\n);\n","PayPal_Braintree/js/view/payment/validator-handler.js":"/**\n * Copyright 2013-2017 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/model/messageList',\n    'PayPal_Braintree/js/view/payment/3d-secure',\n    'Magento_Checkout/js/model/full-screen-loader'\n], function ($, globalMessageList, verify3DSecure, fullScreenLoader) {\n    'use strict';\n\n    return {\n        validators: [],\n\n        /**\n         * Get payment config\n         * @returns {Object}\n         */\n        getConfig: function () {\n            return window.checkoutConfig.payment;\n        },\n\n        /**\n         * Init list of validators\n         */\n        initialize: function () {\n            var config = this.getConfig();\n\n            if (config[verify3DSecure.getCode()].enabled) {\n                verify3DSecure.setConfig(config[verify3DSecure.getCode()]);\n                this.add(verify3DSecure);\n            }\n        },\n\n        /**\n         * Add new validator\n         * @param {Object} validator\n         */\n        add: function (validator) {\n            this.validators.push(validator);\n        },\n\n        /**\n         * Run pull of validators\n         * @param {Object} context\n         * @param {Function} callback\n         */\n        validate: function (context, callback, errorCallback) {\n            var self = this,\n                deferred;\n\n            // no available validators\n            if (!self.validators.length) {\n                callback();\n\n                return;\n            }\n\n            // get list of deferred validators\n            deferred = $.map(self.validators, function (current) {\n                return current.validate(context);\n            });\n\n            $.when.apply($, deferred)\n                .done(function () {\n                    callback();\n                }).fail(function (error) {\n                    errorCallback();\n                    self.showError(error);\n                });\n        },\n\n        /**\n         * Show error message\n         * @param {String} errorMessage\n         */\n        showError: function (errorMessage) {\n            globalMessageList.addErrorMessage({\n                message: errorMessage\n            });\n            fullScreenLoader.stopLoader(true);\n        }\n    };\n});\n","PayPal_Braintree/js/view/payment/method-renderer/paypal-vault.js":"/**\n * Copyright \u00a9 2013-2017 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_Vault/js/view/payment/method-renderer/vault',\n    'Magento_Ui/js/model/messageList',\n    'Magento_Checkout/js/model/full-screen-loader'\n], function ($, _, VaultComponent, globalMessageList, fullScreenLoader) {\n    'use strict';\n\n    return VaultComponent.extend({\n        defaults: {\n            template: 'PayPal_Braintree/payment/paypal/vault',\n            additionalData: {}\n        },\n\n        /**\n         * Get PayPal payer email\n         * @returns {String}\n         */\n        getPayerEmail: function () {\n            return this.details.payerEmail;\n        },\n\n        /**\n         * Get type of payment\n         * @returns {String}\n         */\n        getPaymentIcon: function () {\n            return window.checkoutConfig.payment['braintree_paypal'].paymentIcon;\n        },\n\n        /**\n         * Place order\n         */\n        beforePlaceOrder: function () {\n            this.getPaymentMethodNonce();\n        },\n\n        /**\n         * Send request to get payment method nonce\n         */\n        getPaymentMethodNonce: function () {\n            var self = this;\n\n            fullScreenLoader.startLoader();\n            $.getJSON(self.nonceUrl, {\n                'public_hash': self.publicHash\n            })\n                .done(function (response) {\n                    fullScreenLoader.stopLoader();\n                    self.additionalData['payment_method_nonce'] = response.paymentMethodNonce;\n                    self.placeOrder();\n                })\n                .fail(function (response) {\n                    var error = JSON.parse(response.responseText);\n\n                    fullScreenLoader.stopLoader();\n                    globalMessageList.addErrorMessage({\n                        message: error.message\n                    });\n                });\n        },\n\n        /**\n         * Get payment method data\n         * @returns {Object}\n         */\n        getData: function () {\n            var data = {\n                'method': this.code,\n                'additional_data': {\n                    'public_hash': this.publicHash\n                }\n            };\n\n            data['additional_data'] = _.extend(data['additional_data'], this.additionalData);\n\n            return data;\n        }\n    });\n});\n","PayPal_Braintree/js/view/payment/method-renderer/paypal.js":"/**\n * Copyright \u00a9 2013-2017 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_Checkout/js/view/payment/default',\n    'braintree',\n    'braintreeCheckoutPayPalAdapter',\n    'braintreePayPalCheckout',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/full-screen-loader',\n    'Magento_Checkout/js/model/payment/additional-validators',\n    'Magento_Checkout/js/model/step-navigator',\n    'Magento_Vault/js/view/payment/vault-enabler',\n    'Magento_Checkout/js/action/create-billing-address',\n    'Magento_Checkout/js/action/select-billing-address',\n    'mage/translate'\n], function (\n    $,\n    _,\n    Component,\n    braintree,\n    Braintree,\n    paypalCheckout,\n    quote,\n    fullScreenLoader,\n    additionalValidators,\n    stepNavigator,\n    VaultEnabler,\n    createBillingAddress,\n    selectBillingAddress,\n    $t\n) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'PayPal_Braintree/payment/paypal',\n            code: 'braintree_paypal',\n            active: false,\n            paypalInstance: null,\n            paymentMethodNonce: null,\n            grandTotalAmount: null,\n            isReviewRequired: false,\n            customerEmail: null,\n\n            /**\n             * Additional payment data\n             *\n             * {Object}\n             */\n            additionalData: {},\n\n            /**\n             * PayPal client configuration\n             * {Object}\n             */\n            clientConfig: {\n                offerCredit: false,\n                offerCreditOnly: false,\n                dataCollector: {\n                    paypal: true\n                },\n\n                buttonPayPalId: 'braintree_paypal_placeholder',\n                buttonCreditId: 'braintree_paypal_credit_placeholder',\n                buttonPaylaterId: 'braintree_paypal_paylater_placeholder',\n\n                onDeviceDataRecieved: function (deviceData) {\n                    this.additionalData['device_data'] = deviceData;\n                },\n\n                /**\n                 * Triggers when widget is loaded\n                 * @param {Object} context\n                 */\n                onReady: function (context) {\n                    this.setupPayPal();\n                },\n\n                /**\n                 * Triggers on payment nonce receive\n                 * @param {Object} response\n                 */\n                onPaymentMethodReceived: function (response) {\n                    this.beforePlaceOrder(response);\n                }\n            },\n            imports: {\n                onActiveChange: 'active'\n            }\n        },\n\n        /**\n         * Set list of observable attributes\n         * @returns {exports.initObservable}\n         */\n        initObservable: function () {\n            var self = this;\n\n            this._super()\n                .observe(['active', 'isReviewRequired', 'customerEmail']);\n\n            window.addEventListener('hashchange', function (e) {\n                var methodCode = quote.paymentMethod();\n\n                if (methodCode === 'braintree_paypal' || methodCode === 'braintree_paypal_vault') {\n                    if (e.newURL.indexOf('payment') > 0 && self.grandTotalAmount !== null) {\n                        self.reInitPayPal();\n                    }\n                }\n            });\n\n            quote.paymentMethod.subscribe(function (value) {\n                var methodCode = value;\n\n                if (methodCode === 'braintree_paypal' || methodCode === 'braintree_paypal_vault') {\n                    self.reInitPayPal();\n                }\n            });\n\n            this.vaultEnabler = new VaultEnabler();\n            this.vaultEnabler.setPaymentCode(this.getVaultCode());\n            this.vaultEnabler.isActivePaymentTokenEnabler.subscribe(function () {\n                self.onVaultPaymentTokenEnablerChange();\n            });\n\n            this.grandTotalAmount = quote.totals()['base_grand_total'];\n\n            quote.totals.subscribe(function () {\n                if (self.grandTotalAmount !== quote.totals()['base_grand_total']) {\n                    self.grandTotalAmount = quote.totals()['base_grand_total'];\n                    var methodCode = quote.paymentMethod();\n\n                    if (methodCode === 'braintree_paypal' || methodCode === 'braintree_paypal_vault') {\n                        self.reInitPayPal();\n                    }\n                }\n            });\n\n            // for each component initialization need update property\n            this.isReviewRequired(false);\n            this.initClientConfig();\n\n            return this;\n        },\n\n        /**\n         * Get payment name\n         *\n         * @returns {String}\n         */\n        getCode: function () {\n            return this.code;\n        },\n\n        /**\n         * Get payment title\n         *\n         * @returns {String}\n         */\n        getTitle: function () {\n            return window.checkoutConfig.payment[this.getCode()].title;\n        },\n\n        /**\n         * Check if payment is active\n         *\n         * @returns {Boolean}\n         */\n        isActive: function () {\n            var active = this.getCode() === this.isChecked();\n\n            this.active(active);\n\n            return active;\n        },\n\n        /**\n         * Triggers when payment method change\n         * @param {Boolean} isActive\n         */\n        onActiveChange: function (isActive) {\n            if (!isActive) {\n                return;\n            }\n\n            // need always re-init Braintree with PayPal configuration\n            this.reInitPayPal();\n        },\n\n        /**\n         * Init config\n         */\n        initClientConfig: function () {\n            this.clientConfig = _.extend(this.clientConfig, this.getPayPalConfig());\n\n            _.each(this.clientConfig, function (fn, name) {\n                if (typeof fn === 'function') {\n                    this.clientConfig[name] = fn.bind(this);\n                }\n            }, this);\n        },\n\n        /**\n         * Set payment nonce\n         * @param {String} paymentMethodNonce\n         */\n        setPaymentMethodNonce: function (paymentMethodNonce) {\n            this.paymentMethodNonce = paymentMethodNonce;\n        },\n\n        /**\n         * Update quote billing address\n         * @param {Object}customer\n         * @param {Object}address\n         */\n        setBillingAddress: function (customer, address) {\n            var billingAddress = {\n                street: [address.line1],\n                city: address.city,\n                postcode: address.postalCode,\n                countryId: address.countryCode,\n                email: customer.email,\n                firstname: customer.firstName,\n                lastname: customer.lastName,\n                telephone: typeof customer.phone !== 'undefined' ? customer.phone : '00000000000'\n            };\n\n            billingAddress['region_code'] = typeof address.state === 'string' ? address.state : '';\n            billingAddress = createBillingAddress(billingAddress);\n            quote.billingAddress(billingAddress);\n        },\n\n        /**\n         * Prepare data to place order\n         * @param {Object} data\n         */\n        beforePlaceOrder: function (data) {\n            this.setPaymentMethodNonce(data.nonce);\n            this.customerEmail(data.details.email);\n            if (quote.isVirtual()) {\n                this.isReviewRequired(true);\n            } else {\n                if (quote.shippingAddress() === quote.billingAddress()) {\n                    selectBillingAddress(quote.shippingAddress());\n                } else {\n                    selectBillingAddress(quote.billingAddress());\n                }\n\n                this.placeOrder();\n            }\n        },\n\n        /**\n         * Re-init PayPal Auth Flow\n         */\n        reInitPayPal: function () {\n            this.disableButton();\n            this.clientConfig.paypal.amount = parseFloat(this.grandTotalAmount).toFixed(2);\n\n            if (!quote.isVirtual()) {\n                this.clientConfig.paypal.enableShippingAddress = true;\n                this.clientConfig.paypal.shippingAddressEditable = false;\n                this.clientConfig.paypal.shippingAddressOverride = this.getShippingAddress();\n            }\n\n            Braintree.setConfig(this.clientConfig);\n\n            if (Braintree.getPayPalInstance()) {\n                Braintree.getPayPalInstance().teardown(function () {\n                    Braintree.setup();\n                }.bind(this));\n                Braintree.setPayPalInstance(null);\n            } else {\n                Braintree.setup();\n                this.enableButton();\n            }\n        },\n\n        /**\n         * Setup PayPal instance\n         */\n        setupPayPal: function () {\n            var self = this;\n\n            if (Braintree.config.paypalInstance) {\n                fullScreenLoader.stopLoader(true);\n                return;\n            }\n\n            paypalCheckout.create({\n                client: Braintree.clientInstance\n            }, function (createErr, paypalCheckoutInstance) {\n                if (createErr) {\n                    Braintree.showError($t(\"PayPal Checkout could not be initialized. Please contact the store owner.\"));\n                    console.error('paypalCheckout error', createErr);\n                    return;\n                }\n                let quoteObj = quote.totals();\n\n                paypalCheckoutInstance.loadPayPalSDK({\n                    components: 'buttons,messages,funding-eligibility',\n                    currency: quoteObj['base_currency_code'],\n                }, function () {\n                    this.loadPayPalButton(paypalCheckoutInstance, 'paypal');\n                    if(this.isCreditEnabled()) {\n                        this.loadPayPalButton(paypalCheckoutInstance, 'credit');\n                    }\n                    if(this.isPaylaterEnabled()) {\n                        this.loadPayPalButton(paypalCheckoutInstance, 'paylater');\n                    }\n\n                }.bind(this));\n            }.bind(this));\n        },\n\n        loadPayPalButton: function (paypalCheckoutInstance, funding) {\n            var paypalPayment = Braintree.config.paypal,\n                onPaymentMethodReceived = Braintree.config.onPaymentMethodReceived,\n                style = {\n                    color: Braintree.getColor(),\n                    shape: Braintree.getShape(),\n                    layout: Braintree.getLayout(),\n                    size: Braintree.getSize()\n                };\n\n            if (Braintree.getBranding()) {\n                style.branding = Braintree.getBranding();\n            }\n            if (Braintree.getFundingIcons()) {\n                style.fundingicons = Braintree.getFundingIcons();\n            }\n\n            if (funding == 'credit') {\n                style.layout = \"horizontal\";\n                style.color = \"darkblue\";\n                Braintree.config.buttonId = this.clientConfig.buttonCreditId;\n            } else if (funding == 'paylater') {\n                style.layout = \"horizontal\";\n                style.color = \"white\";\n                Braintree.config.buttonId = this.clientConfig.buttonPaylaterId;\n            } else {\n                Braintree.config.buttonId = this.clientConfig.buttonPayPalId;\n            }\n            // Render\n            Braintree.config.paypalInstance = paypalCheckoutInstance;\n            var events = Braintree.events;\n            $('#' + Braintree.config.buttonId).html('');\n\n            var button = paypal.Buttons({\n                fundingSource: funding,\n                env: Braintree.getEnvironment(),\n                style: style,\n                commit: true,\n                locale: Braintree.config.paypal.locale,\n\n                createOrder: function () {\n                    return paypalCheckoutInstance.createPayment(paypalPayment);\n                },\n\n                onCancel: function (data) {\n                    console.log('checkout.js payment cancelled', JSON.stringify(data, 0, 2));\n\n                    if (typeof events.onCancel === 'function') {\n                        events.onCancel();\n                    }\n                },\n\n                onError: function (err) {\n                    Braintree.showError($t(\"PayPal Checkout could not be initialized. Please contact the store owner.\"));\n                    Braintree.config.paypalInstance = null;\n                    console.error('Paypal checkout.js error', err);\n\n                    if (typeof events.onError === 'function') {\n                        events.onError(err);\n                    }\n                }.bind(this),\n\n                onClick: function(data) {\n                    if (typeof events.onClick === 'function') {\n                        events.onClick(data);\n                    }\n                },\n\n                onApprove: function (data, actions) {\n                    return paypalCheckoutInstance.tokenizePayment(data)\n                        .then(function (payload) {\n                            onPaymentMethodReceived(payload);\n                        });\n                }\n\n            });\n            if (button.isEligible()) {\n                button.render('#' + Braintree.config.buttonId).then(function () {\n                    Braintree.enableButton();\n                    if (typeof Braintree.config.onPaymentMethodError === 'function') {\n                        Braintree.config.onPaymentMethodError();\n                    }\n                }.bind(this)).then(function (data) {\n                    if (typeof events.onRender === 'function') {\n                        events.onRender(data);\n                    }\n                });\n            }\n        },\n\n        /**\n         * Get locale\n         * @returns {String}\n         */\n        getLocale: function () {\n            return window.checkoutConfig.payment[this.getCode()].locale;\n        },\n\n        /**\n         * Get configuration for PayPal\n         * @returns {Object}\n         */\n        getPayPalConfig: function () {\n            var totals = quote.totals(),\n                config = {},\n                isActiveVaultEnabler = this.isActiveVault();\n\n            config.paypal = {\n                flow: 'checkout',\n                amount: parseFloat(this.grandTotalAmount).toFixed(2),\n                currency: totals['base_currency_code'],\n                locale: this.getLocale(),\n\n                /**\n                 * Triggers on any Braintree error\n                 */\n                onError: function () {\n                    this.paymentMethodNonce = null;\n                },\n\n                /**\n                 * Triggers if browser doesn't support PayPal Checkout\n                 */\n                onUnsupported: function () {\n                    this.paymentMethodNonce = null;\n                }\n            };\n\n            if (isActiveVaultEnabler) {\n                config.paypal.requestBillingAgreement = true;\n            }\n\n            if (!quote.isVirtual()) {\n                config.paypal.enableShippingAddress = true;\n                config.paypal.shippingAddressEditable = false;\n                config.paypal.shippingAddressOverride = this.getShippingAddress();\n            }\n\n            if (this.getMerchantName()) {\n                config.paypal.displayName = this.getMerchantName();\n            }\n\n            return config;\n        },\n\n        /**\n         * Get shipping address\n         * @returns {Object}\n         */\n        getShippingAddress: function () {\n            var address = quote.shippingAddress();\n\n            return {\n                recipientName: address.firstname + ' ' + address.lastname,\n                line1: address.street[0],\n                line2: typeof address.street[2] === 'undefined' ? address.street[1] : address.street[1] + ' ' + address.street[2],\n                city: address.city,\n                countryCode: address.countryId,\n                postalCode: address.postcode,\n                state: address.region\n            };\n        },\n\n        /**\n         * Get merchant name\n         * @returns {String}\n         */\n        getMerchantName: function () {\n            return window.checkoutConfig.payment[this.getCode()].merchantName;\n        },\n\n        /**\n         * Get data\n         * @returns {Object}\n         */\n        getData: function () {\n            var data = {\n                'method': this.getCode(),\n                'additional_data': {\n                    'payment_method_nonce': this.paymentMethodNonce\n                }\n            };\n\n            data['additional_data'] = _.extend(data['additional_data'], this.additionalData);\n\n            this.vaultEnabler.visitAdditionalData(data);\n\n            return data;\n        },\n\n        /**\n         * Returns payment acceptance mark image path\n         * @returns {String}\n         */\n        getPaymentAcceptanceMarkSrc: function () {\n\n            return window.checkoutConfig.payment[this.getCode()].paymentAcceptanceMarkSrc;\n        },\n\n        /**\n         * @returns {String}\n         */\n        getVaultCode: function () {\n            return window.checkoutConfig.payment[this.getCode()].vaultCode;\n        },\n\n        /**\n         * Check if need to skip order review\n         * @returns {Boolean}\n         */\n        isSkipOrderReview: function () {\n            return window.checkoutConfig.payment[this.getCode()].skipOrderReview;\n        },\n\n        /**\n         * Checks if vault is active\n         * @returns {Boolean}\n         */\n        isActiveVault: function () {\n            return this.vaultEnabler.isVaultEnabled() && this.vaultEnabler.isActivePaymentTokenEnabler();\n        },\n\n        /**\n         * Re-init PayPal Auth flow to use Vault\n         */\n        onVaultPaymentTokenEnablerChange: function () {\n            this.clientConfig.paypal.singleUse = !this.isActiveVault();\n            this.reInitPayPal();\n        },\n\n        /**\n         * Disable submit button\n         */\n        disableButton: function () {\n            // stop any previous shown loaders\n            fullScreenLoader.stopLoader(true);\n            fullScreenLoader.startLoader();\n            $('[data-button=\"place\"]').attr('disabled', 'disabled');\n        },\n\n        /**\n         * Enable submit button\n         */\n        enableButton: function () {\n            $('[data-button=\"place\"]').removeAttr('disabled');\n            fullScreenLoader.stopLoader(true);\n        },\n\n        /**\n         * Triggers when customer click \"Continue to PayPal\" button\n         */\n        payWithPayPal: function () {\n            if (additionalValidators.validate()) {\n                Braintree.checkout.paypal.initAuthFlow();\n            }\n        },\n\n        /**\n         * Get button id\n         * @returns {String}\n         */\n        getPayPalButtonId: function () {\n            return this.clientConfig.buttonPayPalId;\n        },\n\n        /**\n         * Get button id\n         * @returns {String}\n         */\n        getCreditButtonId: function () {\n            return this.clientConfig.buttonCreditId;\n        },\n\n        /**\n         * Get button id\n         * @returns {String}\n         */\n        getPaylaterButtonId: function () {\n            return this.clientConfig.buttonPaylaterId;\n        },\n\n        isPaylaterEnabled: function () {\n            return window.checkoutConfig.payment['braintree_paypal_paylater']['isActive'];\n        },\n\n        isPaylaterMessageEnabled: function () {\n            return window.checkoutConfig.payment['braintree_paypal_paylater']['isMessageActive'];\n        },\n\n        getGrandTotalAmount: function() {\n            return parseFloat(this.grandTotalAmount).toFixed(2);\n        },\n\n        isCreditEnabled: function () {\n            return window.checkoutConfig.payment['braintree_paypal_credit']['isActive'];\n        },\n\n    });\n});\n\n","PayPal_Braintree/js/view/payment/method-renderer/hosted-fields.js":"/**\n * Copyright 2013-2017 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\n\ndefine([\n    'jquery',\n    'PayPal_Braintree/js/view/payment/method-renderer/cc-form',\n    'PayPal_Braintree/js/validator',\n    'Magento_Vault/js/view/payment/vault-enabler',\n    'Magento_Checkout/js/model/payment/additional-validators',\n    'mage/translate'\n], function ($, Component, validator, VaultEnabler, additionalValidators, $t) {\n    'use strict';\n\n    return Component.extend({\n\n        defaults: {\n            template: 'PayPal_Braintree/payment/form',\n            clientConfig: {\n\n                /**\n                 * {String}\n                 */\n                id: 'co-transparent-form-braintree'\n            },\n            isValidCardNumber: false,\n            isValidExpirationDate: false,\n            isValidCvvNumber: false,\n\n            onInstanceReady: function (instance) {\n                instance.on('validityChange', this.onValidityChange.bind(this));\n                instance.on('cardTypeChange', this.onCardTypeChange.bind(this));\n            }\n        },\n\n        /**\n         * @returns {exports.initialize}\n         */\n        initialize: function () {\n            this._super();\n            this.vaultEnabler = new VaultEnabler();\n            this.vaultEnabler.setPaymentCode(this.getVaultCode());\n\n            return this;\n        },\n\n        /**\n         * Init config\n         */\n        initClientConfig: function () {\n            this._super();\n\n            this.clientConfig.hostedFields = this.getHostedFields();\n            this.clientConfig.onInstanceReady = this.onInstanceReady.bind(this);\n        },\n\n        /**\n         * @returns {Object}\n         */\n        getData: function () {\n            var data = this._super();\n\n            this.vaultEnabler.visitAdditionalData(data);\n\n            return data;\n        },\n\n        /**\n         * @returns {Bool}\n         */\n        isVaultEnabled: function () {\n            return this.vaultEnabler.isVaultEnabled();\n        },\n\n        /**\n         * Get Braintree Hosted Fields\n         * @returns {Object}\n         */\n        getHostedFields: function () {\n            var self = this,\n                fields = {\n                    number: {\n                        selector: self.getSelector('cc_number'),\n                        placeholder: $t('4111 1111 1111 1111')\n                    },\n                    expirationDate: {\n                        selector: self.getSelector('expirationDate'),\n                        placeholder: $t('MM/YYYY')\n                    }\n                };\n\n            if (self.hasVerification()) {\n                fields.cvv = {\n                    selector: self.getSelector('cc_cid'),\n                    placeholder: $t('123')\n                };\n            }\n\n            return fields;\n        },\n\n        /**\n         * Triggers on Hosted Field changes\n         * @param {Object} event\n         * @returns {Boolean}\n         */\n        onValidityChange: function (event) {\n            // Handle a change in validation or card type\n            if (event.emittedBy === 'number') {\n                this.selectedCardType(null);\n\n                if (event.cards.length === 1) {\n                    this.isValidCardNumber = event.fields.number.isValid;\n                    this.selectedCardType(\n                        validator.getMageCardType(event.cards[0].type, this.getCcAvailableTypes())\n                    );\n                    this.validateCardType();\n                } else {\n                    this.isValidCardNumber = event.fields.number.isValid;\n                    this.validateCardType();\n                }\n            }\n\n            // Other field validations\n            if (event.emittedBy === 'expirationDate') {\n                this.isValidExpirationDate = event.fields.expirationDate.isValid;\n            }\n            if (event.emittedBy === 'cvv') {\n                this.isValidCvvNumber = event.fields.cvv.isValid;\n            }\n        },\n\n        /**\n         * Triggers on Hosted Field card type changes\n         * @param {Object} event\n         * @returns {Boolean}\n         */\n        onCardTypeChange: function (event) {\n            if (event.cards.length === 1) {\n                this.selectedCardType(\n                    validator.getMageCardType(event.cards[0].type, this.getCcAvailableTypes())\n                );\n            } else {\n                this.selectedCardType(null);\n            }\n        },\n\n        /**\n         * Toggle invalid class on selector\n         * @param selector\n         * @param state\n         * @returns {boolean}\n         */\n        validateField: function (selector, state) {\n            var $selector = $(this.getSelector(selector)),\n                invalidClass = 'braintree-hosted-fields-invalid';\n\n            if (state === true) {\n                $selector.removeClass(invalidClass);\n                return true;\n            }\n\n            $selector.addClass(invalidClass);\n            return false;\n        },\n\n        /**\n         * Validate current credit card type\n         * @returns {Boolean}\n         */\n        validateCardType: function () {\n            return this.validateField(\n                'cc_number',\n                (this.isValidCardNumber)\n            );\n        },\n\n        /**\n         * Validate current expiry date\n         * @returns {boolean}\n         */\n        validateExpirationDate: function () {\n            return this.validateField(\n                'expirationDate',\n                (this.isValidExpirationDate === true)\n            );\n        },\n\n        /**\n         * Validate current CVV field\n         * @returns {boolean}\n         */\n        validateCvvNumber: function () {\n            var self = this;\n            \n            if (self.hasVerification() === false) {\n                return true;\n            }\n            \n            return this.validateField(\n                'cc_cid',\n                (this.isValidCvvNumber === true)\n            );\n        },\n\n        /**\n         * Validate all fields\n         * @returns {boolean}\n         */\n        validateFormFields: function () {\n            return (this.validateCardType() && this.validateExpirationDate() && this.validateCvvNumber()) === true;\n        },\n\n        /**\n         * Trigger order placing\n         */\n        placeOrderClick: function () {\n            if (this.validateFormFields() && additionalValidators.validate()) {\n                this.placeOrder();\n            }\n        },\n        /**\n         * @returns {String}\n         */\n        getVaultCode: function () {\n            return window.checkoutConfig.payment[this.getCode()].ccVaultCode;\n        }\n    });\n});\n","PayPal_Braintree/js/view/payment/method-renderer/vault.js":"/**\n * Copyright \u00a9 2013-2017 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine([\n    'ko',\n    'jquery',\n    'Magento_Vault/js/view/payment/method-renderer/vault',\n    'PayPal_Braintree/js/view/payment/adapter',\n    'Magento_Ui/js/model/messageList',\n    'PayPal_Braintree/js/view/payment/validator-handler',\n    'Magento_Checkout/js/model/payment/additional-validators',\n    'Magento_Checkout/js/model/full-screen-loader',\n    'braintree',\n    'braintreeHostedFields',\n    'mage/url'\n], function (\n    ko,\n    $,\n    VaultComponent,\n    Braintree,\n    globalMessageList,\n    validatorManager,\n    additionalValidators,\n    fullScreenLoader,\n    client,\n    hostedFields,\n    url\n) {\n    'use strict';\n\n    return VaultComponent.extend({\n        defaults: {\n            active: false,\n            hostedFieldsInstance: null,\n            imports: {\n                onActiveChange: 'active'\n            },\n            modules: {\n                hostedFields: '${ $.parentName }.braintree'\n            },\n            template: 'PayPal_Braintree/payment/cc/vault',\n            updatePaymentUrl: url.build('braintree/payment/updatepaymentmethod'),\n            vaultedCVV: ko.observable(\"\"),\n            validatorManager: validatorManager,\n            isValidCvv: false,\n            onInstanceReady: function (instance) {\n                instance.on('validityChange', this.onValidityChange.bind(this));\n            }\n        },\n\n        /**\n         * Event fired by Braintree SDK whenever input value length matches the validation length.\n         * In the case of a CVV, this is 3, or 4 for AMEX.\n         * @param event\n         */\n        onValidityChange: function (event) {\n            if (event.emittedBy === 'cvv') {\n                this.isValidCvv = event.fields.cvv.isValid;\n            }\n        },\n\n        /**\n         * @returns {exports}\n         */\n        initObservable: function () {\n            this._super().observe(['active']);\n            this.validatorManager.initialize();\n            return this;\n        },\n\n        /**\n         * Is payment option active?\n         * @returns {boolean}\n         */\n        isActive: function () {\n            var active = this.getId() === this.isChecked();\n            this.active(active);\n            return active;\n        },\n\n        /**\n         * Fired whenever a payment option is changed.\n         * @param isActive\n         */\n        onActiveChange: function (isActive) {\n            var self = this;\n\n            if (!isActive) {\n                return;\n            }\n\n            if (self.showCvvVerify()) {\n                if (self.hostedFieldsInstance) {\n                    self.hostedFieldsInstance.teardown(function (teardownError) {\n                        if (teardownError) {\n                            globalMessageList.addErrorMessage({\n                                message: teardownError.message\n                            });\n                        }\n                        self.hostedFieldsInstance = null;\n                        self.initHostedCvvField();\n                    });\n                    return;\n                }\n                self.initHostedCvvField();\n            }\n        },\n\n        /**\n         * Initialize the CVV input field with the Braintree Hosted Fields SDK.\n         */\n        initHostedCvvField: function () {\n            var self = this;\n            client.create({\n                authorization: Braintree.getClientToken()\n            }, function (clientError, clientInstance) {\n                if (clientError) {\n                    globalMessageList.addErrorMessage({\n                        message: clientError.message\n                    });\n                }\n                hostedFields.create({\n                    client: clientInstance,\n                    fields: {\n                        cvv: {\n                            selector: '#' + self.getId() + '_cid',\n                            placeholder: '123'\n                        }\n                    }\n                }, function (hostedError, hostedFieldsInstance) {\n                    if (hostedError) {\n                        globalMessageList.addErrorMessage({\n                            message: hostedError.message\n                        });\n                        return;\n                    }\n\n                    self.hostedFieldsInstance = hostedFieldsInstance;\n                    self.onInstanceReady(self.hostedFieldsInstance);\n                });\n            });\n        },\n\n        /**\n         * Return the payment method code.\n         * @returns {string}\n         */\n        getCode: function () {\n            return 'braintree_cc_vault';\n        },\n\n        /**\n         * Get last 4 digits of card\n         * @returns {String}\n         */\n        getMaskedCard: function () {\n            return this.details.maskedCC;\n        },\n\n        /**\n         * Get expiration date\n         * @returns {String}\n         */\n        getExpirationDate: function () {\n            return this.details.expirationDate;\n        },\n\n        /**\n         * Get card type\n         * @returns {String}\n         */\n        getCardType: function () {\n            return this.details.type;\n        },\n\n        /**\n         * Get show CVV Field\n         * @returns {Boolean}\n         */\n        showCvvVerify: function () {\n            return window.checkoutConfig.payment[this.code].cvvVerify;\n        },\n\n        /**\n         * Show or hide the error message.\n         * @param selector\n         * @param state\n         * @returns {boolean}\n         */\n        validateCvv: function (selector, state) {\n            var $selector = $(selector),\n                invalidClass = 'braintree-hosted-fields-invalid';\n\n            if (state === true) {\n                $selector.removeClass(invalidClass);\n                return true;\n            }\n\n            $selector.addClass(invalidClass);\n            return false;\n        },\n\n        /**\n         * Place order\n         */\n        placeOrder: function () {\n            var self = this;\n\n            if (self.showCvvVerify()) {\n                if (!self.validateCvv('#' + self.getId() + '_cid', self.isValidCvv) || !additionalValidators.validate()) {\n                    return;\n                }\n            } else {\n                if (!additionalValidators.validate()) {\n                    return;\n                }\n            }\n\n            fullScreenLoader.startLoader();\n\n            if (self.showCvvVerify() && typeof self.hostedFieldsInstance !== 'undefined') {\n                self.hostedFieldsInstance.tokenize({}, function (error, payload) {\n                    if (error) {\n                        fullScreenLoader.stopLoader();\n                        globalMessageList.addErrorMessage({\n                            message: error.message\n                        });\n                        return;\n                    }\n                    $.getJSON(\n                        self.updatePaymentUrl,\n                        {\n                            'nonce': payload.nonce,\n                            'public_hash': self.publicHash\n                        }\n                    ).done(function (response) {\n                        if (response.success === false) {\n                            fullScreenLoader.stopLoader();\n                            globalMessageList.addErrorMessage({\n                                message: 'CVV verification failed.'\n                            });\n                            return;\n                        }\n                        self.getPaymentMethodNonce();\n                    })\n                });\n            } else {\n                self.getPaymentMethodNonce();\n            }\n        },\n\n        /**\n         * Send request to get payment method nonce\n         */\n        getPaymentMethodNonce: function () {\n            var self = this;\n\n            fullScreenLoader.startLoader();\n            $.getJSON(self.nonceUrl, {\n                'public_hash': self.publicHash,\n                'cvv': self.vaultedCVV()\n            }).done(function (response) {\n                fullScreenLoader.stopLoader();\n                self.hostedFields(function (formComponent) {\n                    formComponent.setPaymentMethodNonce(response.paymentMethodNonce);\n                    formComponent.additionalData['public_hash'] = self.publicHash;\n                    formComponent.code = self.code;\n                    if (self.vaultedCVV()) {\n                        formComponent.additionalData['cvv'] = self.vaultedCVV();\n                    }\n\n                    self.validatorManager.validate(formComponent, function () {\n                        fullScreenLoader.stopLoader();\n                        return formComponent.placeOrder('parent');\n                    }, function() {\n                        // No teardown actions required.\n                        fullScreenLoader.stopLoader();\n                        formComponent.setPaymentMethodNonce(null);\n                    });\n\n                });\n            }).fail(function (response) {\n                var error = JSON.parse(response.responseText);\n\n                fullScreenLoader.stopLoader();\n                globalMessageList.addErrorMessage({\n                    message: error.message\n                });\n            });\n        }\n    });\n});\n","PayPal_Braintree/js/view/payment/method-renderer/venmo.js":"define(\n    [\n        'Magento_Checkout/js/view/payment/default',\n        'braintree',\n        'braintreeDataCollector',\n        'braintreeVenmo',\n        'PayPal_Braintree/js/form-builder',\n        'Magento_Ui/js/model/messageList',\n        'Magento_Checkout/js/model/full-screen-loader',\n        'mage/translate'\n    ],\n    function (\n        Component,\n        braintree,\n        dataCollector,\n        venmo,\n        formBuilder,\n        messageList,\n        fullScreenLoader,\n        $t\n    ) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                deviceData: null,\n                paymentMethodNonce: null,\n                template: 'PayPal_Braintree/payment/venmo',\n                venmoInstance: null\n            },\n\n            clickVenmoBtn: function () {\n                var self = this;\n\n                if (!this.venmoInstance) {\n                    this.setErrorMsg($t('Venmo not initialized, please try reloading.'));\n                    return;\n                }\n\n                this.venmoInstance.tokenize(function (tokenizeErr, payload) {\n                    if (tokenizeErr) {\n                        if (tokenizeErr.code === 'VENMO_CANCELED') {\n                            self.setErrorMsg($t('Venmo app is not available or the payment flow was cancelled.'));\n                        } else if (tokenizeErr.code === 'VENMO_APP_CANCELED') {\n                            self.setErrorMsg($t('Venmo payment flow cancelled.'));\n                        } else {\n                            self.setErrorMsg(tokenizeErr.message);\n                        }\n                    } else {\n                        self.handleVenmoSuccess(payload);\n                    }\n                });\n            },\n\n            collectDeviceData: function (clientInstance, callback) {\n                var self = this;\n                dataCollector.create({\n                    client: clientInstance,\n                    paypal: true\n                }, function (dataCollectorErr, dataCollectorInstance) {\n                    if (dataCollectorErr) {\n                        return;\n                    }\n                    self.deviceData = dataCollectorInstance.deviceData;\n                    callback();\n                });\n            },\n\n            getClientToken: function () {\n                return window.checkoutConfig.payment[this.getCode()].clientToken;\n            },\n\n            getCode: function() {\n                return 'braintree_venmo';\n            },\n\n            getData: function () {\n                let data = {\n                    'method': this.getCode(),\n                    'additional_data': {\n                        'payment_method_nonce': this.paymentMethodNonce,\n                        'device_data': this.deviceData\n                    }\n                };\n\n                data['additional_data'] = _.extend(data['additional_data'], this.additionalData);\n\n                return data;\n            },\n\n            getPaymentMarkSrc: function () {\n                return window.checkoutConfig.payment[this.getCode()].paymentMarkSrc;\n            },\n\n            getTitle: function() {\n                return 'Venmo';\n            },\n\n            handleVenmoSuccess: function (payload) {\n                this.setPaymentMethodNonce(payload.nonce);\n                this.placeOrder();\n            },\n\n            initialize: function () {\n                this._super();\n\n                var self = this;\n\n                braintree.create({\n                    authorization: self.getClientToken()\n                }, function (clientError, clientInstance) {\n                    if (clientError) {\n                        this.setErrorMsg($t('Unable to initialize Braintree Client.'));\n                        return;\n                    }\n\n                    // Collect device data\n                    self.collectDeviceData(clientInstance, function () {\n                        // callback from collectDeviceData\n                        venmo.create({\n                            client: clientInstance,\n                            allowNewBrowserTab: false\n                        }, function (venmoErr, venmoInstance) {\n                            if (!venmoInstance.isBrowserSupported()) {\n                                return;\n                            }\n\n                            if (venmoErr) {\n                                self.setErrorMsg($t('Error initializing Venmo: %1').replace('%1', venmoErr));\n                                return;\n                            }\n\n                            self.setVenmoInstance(venmoInstance);\n                        });\n                    });\n                });\n\n                return this;\n            },\n\n            isAllowed: function () {\n                return window.checkoutConfig.payment[this.getCode()].isAllowed;\n            },\n\n            isBrowserSupported: function () {\n                return venmo.isBrowserSupported();\n            },\n\n            setErrorMsg: function (message) {\n                messageList.addErrorMessage({\n                    message: message\n                });\n            },\n\n            setPaymentMethodNonce: function (nonce) {\n                this.paymentMethodNonce = nonce;\n            },\n\n            setVenmoInstance: function (instance) {\n                this.venmoInstance = instance;\n            }\n        });\n    }\n);\n","PayPal_Braintree/js/view/payment/method-renderer/ach.js":"define(\n    [\n        'Magento_Checkout/js/view/payment/default',\n        'ko',\n        'jquery',\n        'braintree',\n        'braintreeDataCollector',\n        'braintreeAch',\n        'PayPal_Braintree/js/form-builder',\n        'Magento_Ui/js/model/messageList',\n        'Magento_Checkout/js/action/select-billing-address',\n        'Magento_Checkout/js/model/full-screen-loader',\n        'Magento_Checkout/js/model/quote',\n        'mage/translate'\n    ],\n    function (\n        Component,\n        ko,\n        $,\n        braintree,\n        dataCollector,\n        ach,\n        formBuilder,\n        messageList,\n        selectBillingAddress,\n        fullScreenLoader,\n        quote,\n        $t\n    ) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                deviceData: null,\n                paymentMethodNonce: null,\n                template: 'PayPal_Braintree/payment/ach',\n                achInstance: null,\n                routingNumber: ko.observable(\"\"),\n                accountNumber: ko.observable(\"\"),\n                accountType: ko.observable(\"checking\"),\n                ownershipType: ko.observable(\"personal\"),\n                firstName: ko.observable(\"\"),\n                lastName: ko.observable(\"\"),\n                businessName: ko.observable(\"\"),\n                hasAuthorization: ko.observable(false),\n                business: ko.observable(false), // for ownership type\n                personal: ko.observable(true) // for ownership type\n            },\n\n            clickAchBtn: function () {\n                if (!this.validateForm('#' + this.getCode() + '-form')) {\n                    return;\n                }\n\n                fullScreenLoader.startLoader();\n\n                var self = this;\n\n                var billingAddress = quote.billingAddress();\n\n                let regionCode;\n\n                let bankDetails = {\n                    routingNumber: self.routingNumber(),\n                    accountNumber: self.accountNumber(),\n                    accountType: self.accountType(),\n                    ownershipType: self.ownershipType(),\n                    billingAddress: {\n                        streetAddress: billingAddress.street[0],\n                        extendedAddress: billingAddress.street[1],\n                        locality: billingAddress.city,\n                        region: billingAddress.regionCode,\n                        postalCode: billingAddress.postcode,\n                    }\n                };\n\n                if (bankDetails.ownershipType === 'personal') {\n                    bankDetails.firstName = self.firstName();\n                    bankDetails.lastName = self.lastName();\n                } else {\n                    bankDetails.businessName = self.businessName();\n                }\n\n                var mandateText = document.getElementById('braintree-ach-mandate').textContent;\n\n                // if no region code is available, lets find one!\n                if (typeof billingAddress.regionCode === 'undefined') {\n                    $.get('/rest/V1/directory/countries/' + billingAddress.countryId).done(function (data) {\n                        if (typeof data.available_regions !== 'undefined') {\n                            for (var i = 0; i < data.available_regions.length; ++i) {\n                                if (data.available_regions[i].id === billingAddress.regionId) {\n                                    regionCode = data.available_regions[i].code;\n                                    bankDetails.billingAddress.region = regionCode;\n                                    self.tokenizeAch(bankDetails, mandateText);\n                                }\n                            }\n                        }\n                    }).fail(function() {\n                        fullScreenLoader.stopLoader();\n                    });\n                } else {\n                    self.tokenizeAch(bankDetails, mandateText);\n                }\n            },\n\n            tokenizeAch: function (bankDetails, mandateText) {\n                var self = this;\n                this.achInstance.tokenize({\n                    bankDetails: bankDetails,\n                    mandateText: mandateText\n                }, function (tokenizeErr, tokenizedPayload) {\n                    if (tokenizeErr) {\n                        self.setErrorMsg($t('There was an error with the provided bank details. Please check and try again.'));\n                        self.hasAuthorization(false);\n                    } else {\n                        fullScreenLoader.stopLoader();\n                        self.handleAchSuccess(tokenizedPayload);\n                    }\n                });\n            },\n\n            getClientToken: function () {\n                return window.checkoutConfig.payment[this.getCode()].clientToken;\n            },\n\n            getCode: function () {\n                return 'braintree_ach_direct_debit';\n            },\n\n            getStoreName: function () {\n                return window.checkoutConfig.payment[this.getCode()].storeName;\n            },\n\n            getData: function () {\n                let data = {\n                    'method': this.getCode(),\n                    'additional_data': {\n                        'payment_method_nonce': this.paymentMethodNonce,\n                    }\n                };\n\n                data['additional_data'] = _.extend(data['additional_data'], this.additionalData);\n\n                return data;\n            },\n\n            getTitle: function() {\n                return 'ACH Direct Debit';\n            },\n\n            handleAchSuccess: function (payload) {\n                this.setPaymentMethodNonce(payload.nonce);\n                this.placeOrder();\n            },\n\n            initialize: function () {\n                this._super();\n\n                var self = this;\n\n                braintree.create({\n                    authorization: self.getClientToken()\n                }, function (clientError, clientInstance) {\n                    if (clientError) {\n                        this.setErrorMsg($t('Unable to initialize Braintree Client.'));\n                        return;\n                    }\n\n                    ach.create({\n                        client: clientInstance\n                    }, function (achErr, achInstance) {\n                        if (achErr) {\n                            self.setErrorMsg($t('Error initializing ACH: %1').replace('%1', achErr));\n                            return;\n                        }\n\n                        self.setAchInstance(achInstance);\n                    });\n                });\n\n                return this;\n            },\n\n            isAllowed: function () {\n                return window.checkoutConfig.payment[this.getCode()].isAllowed;\n            },\n\n            changeOwnershipType: function (data, event) {\n                var self = this;\n                if (event.currentTarget.value === 'business') {\n                    self.business(true);\n                    self.personal(false);\n                } else {\n                    self.business(false);\n                    self.personal(true);\n                }\n            },\n\n            isBusiness: function () {\n                return this.business;\n            },\n\n            isPersonal: function () {\n                return this.personal;\n            },\n\n            setErrorMsg: function (message) {\n                messageList.addErrorMessage({\n                    message: message\n                });\n            },\n\n            setPaymentMethodNonce: function (nonce) {\n                this.paymentMethodNonce = nonce;\n            },\n\n            setAchInstance: function (instance) {\n                this.achInstance = instance;\n            },\n\n            validateForm: function (form) {\n                return $(form).validation() && $(form).validation('isValid');\n            }\n        });\n    }\n);\n","PayPal_Braintree/js/view/payment/method-renderer/lpm.js":"define(\n    [\n        'Magento_Checkout/js/view/payment/default',\n        'ko',\n        'jquery',\n        'braintree',\n        'braintreeLpm',\n        'PayPal_Braintree/js/form-builder',\n        'Magento_Ui/js/model/messageList',\n        'Magento_Checkout/js/action/select-billing-address',\n        'Magento_Checkout/js/model/full-screen-loader',\n        'Magento_Checkout/js/model/quote',\n        'Magento_Checkout/js/model/payment/additional-validators',\n        'mage/url',\n        'mage/translate'\n    ],\n    function (\n        Component,\n        ko,\n        $,\n        braintree,\n        lpm,\n        formBuilder,\n        messageList,\n        selectBillingAddress,\n        fullScreenLoader,\n        quote,\n        additionalValidators,\n        url,\n        $t\n    ) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                code: 'braintree_local_payment',\n                paymentMethodsAvailable: ko.observable(false),\n                paymentMethodNonce: null,\n                template: 'PayPal_Braintree/payment/lpm'\n            },\n\n            clickPaymentBtn: function (method) {\n                var self = this;\n\n                if (additionalValidators.validate()) {\n                    fullScreenLoader.startLoader();\n\n                    braintree.create({\n                        authorization: self.getClientToken()\n                    }, function (clientError, clientInstance) {\n                        if (clientError) {\n                            self.setErrorMsg($t('Unable to initialize Braintree Client.'));\n                            fullScreenLoader.stopLoader();\n                            return;\n                        }\n\n                        lpm.create({\n                            client: clientInstance\n                        }, function (lpmError, lpmInstance) {\n                            if (lpmError) {\n                                self.setErrorMsg(lpmError);\n                                fullScreenLoader.stopLoader();\n                                return;\n                            }\n\n                            lpmInstance.startPayment({\n                                amount: self.getAmount(),\n                                currencyCode: self.getCurrencyCode(),\n                                email: self.getCustomerDetails().email,\n                                phone: self.getCustomerDetails().phone,\n                                givenName: self.getCustomerDetails().firstName,\n                                surname: self.getCustomerDetails().lastName,\n                                shippingAddressRequired: !quote.isVirtual(),\n                                address: self.getAddress(),\n                                paymentType: method,\n                                onPaymentStart: function (data, start) {\n                                    start();\n                                },\n                                // This is a required option, however it will apparently never be used in the current payment flow.\n                                // Therefore, both values are set to allow the payment flow to continute, rather than erroring out.\n                                fallback: {\n                                    url: 'N/A',\n                                    buttonText: 'N/A'\n                                }\n                            }, function (startPaymentError, payload) {\n                                fullScreenLoader.stopLoader();\n                                if (startPaymentError) {\n                                    switch (startPaymentError.code) {\n                                        case 'LOCAL_PAYMENT_POPUP_CLOSED':\n                                            self.setErrorMsg($t('Local Payment popup was closed unexpectedly.'));\n                                            break;\n                                        case 'LOCAL_PAYMENT_WINDOW_OPEN_FAILED':\n                                            self.setErrorMsg($t('Local Payment popup failed to open.'));\n                                            break;\n                                        case 'LOCAL_PAYMENT_WINDOW_CLOSED':\n                                            self.setErrorMsg($t('Local Payment popup was closed. Payment cancelled.'));\n                                            break;\n                                        default:\n                                            self.setErrorMsg('Error! ' + startPaymentError);\n                                            break;\n                                    }\n                                } else {\n                                    // Send the nonce to your server to create a transaction\n                                    self.setPaymentMethodNonce(payload.nonce);\n                                    self.placeOrder();\n                                }\n                            });\n                        });\n                    });\n                }\n            },\n\n            getAddress: function () {\n                var shippingAddress = quote.shippingAddress();\n\n                if (quote.isVirtual()) {\n                    return {\n                        countryCode: shippingAddress.countryId\n                    }\n                }\n\n                return {\n                    streetAddress: shippingAddress.street[0],\n                    extendedAddress: shippingAddress.street[1],\n                    locality: shippingAddress.city,\n                    postalCode: shippingAddress.postcode,\n                    region: shippingAddress.region,\n                    countryCode: shippingAddress.countryId\n                }\n            },\n\n            getAmount: function () {\n                return quote.totals()['base_grand_total'].toString();\n            },\n\n            getBillingAddress: function () {\n                return quote.billingAddress();\n            },\n\n            getClientToken: function () {\n                return window.checkoutConfig.payment[this.getCode()].clientToken;\n            },\n\n            getCode: function () {\n                return this.code;\n            },\n\n            getCurrencyCode: function () {\n                return quote.totals()['base_currency_code'];\n            },\n\n            getCustomerDetails: function() {\n                var billingAddress = quote.billingAddress();\n                return {\n                    firstName: billingAddress.firstname,\n                    lastName: billingAddress.lastname,\n                    phone: billingAddress.telephone,\n                    email: typeof quote.guestEmail === 'string' ? quote.guestEmail : billingAddress.email\n                }\n            },\n\n            getData: function () {\n                let data = {\n                    'method': this.getCode(),\n                    'additional_data': {\n                        'payment_method_nonce': this.paymentMethodNonce,\n                    }\n                };\n\n                data['additional_data'] = _.extend(data['additional_data'], this.additionalData);\n\n                return data;\n            },\n\n            getMerchantId: function () {\n                return window.checkoutConfig.payment[this.getCode()].merchantId;\n            },\n\n            getPaymentMethod: function(method) {\n                var methods = this.getPaymentMethods();\n\n                for (var i = 0; i < methods.length; i++) {\n                    if (methods[i].method === method) {\n                        return methods[i]\n                    }\n                }\n            },\n\n            getPaymentMethods: function() {\n                return window.checkoutConfig.payment[this.getCode()].allowedMethods;\n            },\n\n            getPaymentMarkSrc: function () {\n                return window.checkoutConfig.payment[this.getCode()].paymentIcons;\n            },\n\n            getTitle: function() {\n                return window.checkoutConfig.payment[this.getCode()].title;\n            },\n\n            initialize: function () {\n                this._super();\n                return this;\n            },\n\n            isActive: function() {\n                var address = quote.billingAddress() || quote.shippingAddress();\n                var methods = this.getPaymentMethods();\n\n                for (var i = 0; i < methods.length; i++) {\n                    if (methods[i].countries.includes(address.countryId)) {\n                        return true;\n                    }\n                }\n\n                return false;\n            },\n\n            isValidCountryAndCurrency: function (method) {\n                var address = quote.billingAddress();\n\n                if (!address) {\n                    this.paymentMethodsAvailable(false);\n                    return false;\n                }\n\n                var countryId = address.countryId;\n                var quoteCurrency = quote.totals()['base_currency_code'];\n                var paymentMethodDetails = this.getPaymentMethod(method);\n\n                if (paymentMethodDetails.countries.includes(countryId) && quoteCurrency === 'EUR') {\n                    this.paymentMethodsAvailable(true);\n                    return true;\n                }\n\n                return false;\n            },\n\n            setErrorMsg: function (message) {\n                messageList.addErrorMessage({\n                    message: message\n                });\n            },\n\n            setPaymentMethodNonce: function (nonce) {\n                this.paymentMethodNonce = nonce;\n            },\n\n            validateForm: function (form) {\n                return $(form).validation() && $(form).validation('isValid');\n            }\n        });\n    }\n);\n","PayPal_Braintree/js/view/payment/method-renderer/cc-form.js":"/**\n * Copyright 2013-2017 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'underscore',\n        'jquery',\n        'Magento_Payment/js/view/payment/cc-form',\n        'Magento_Checkout/js/model/quote',\n        'PayPal_Braintree/js/view/payment/adapter',\n        'mage/translate',\n        'PayPal_Braintree/js/validator',\n        'PayPal_Braintree/js/view/payment/validator-handler',\n        'Magento_Checkout/js/model/full-screen-loader'\n    ],\n    function (\n        _,\n        $,\n        Component,\n        quote,\n        braintree,\n        $t,\n        validator,\n        validatorManager,\n        fullScreenLoader\n    ) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                active: false,\n                braintreeClient: null,\n                braintreeDeviceData: null,\n                paymentMethodNonce: null,\n                lastBillingAddress: null,\n                validatorManager: validatorManager,\n                code: 'braintree',\n                isProcessing: false,\n\n                /**\n                 * Additional payment data\n                 *\n                 * {Object}\n                 */\n                additionalData: {},\n\n                /**\n                 * Braintree client configuration\n                 *\n                 * {Object}\n                 */\n                clientConfig: {\n                    dataCollector: {\n                        kount: true\n                    },\n\n                    onReady: function (context) {\n                        context.setupHostedFields();\n                    },\n\n                    /**\n                     * Triggers on payment nonce receive\n                     * @param {Object} response\n                     */\n                    onPaymentMethodReceived: function (response) {\n                        this.handleNonce(response);\n                        this.isProcessing = false;\n                    },\n\n                    /**\n                     * Allow a new nonce to be generated\n                     */\n                    onPaymentMethodError: function() {\n                        this.isProcessing = false;\n                    },\n\n                    /**\n                     * Device data initialization\n                     * @param {String} deviceData\n                     */\n                    onDeviceDataRecieved: function (deviceData) {\n                        this.additionalData['device_data'] = deviceData;\n                    },\n\n                    /**\n                     * After Braintree instance initialization\n                     */\n                    onInstanceReady: function () {},\n\n                    /**\n                     * Triggers on any Braintree error\n                     * @param {Object} response\n                     */\n                    onError: function (response) {\n                        this.isProcessing = false;\n                        braintree.showError($t('Payment ' + this.getTitle() + ' can\\'t be initialized'));\n                        throw response.message;\n                    },\n\n                    /**\n                     * Triggers when customer click \"Cancel\"\n                     */\n                    onCancelled: function () {\n                        this.paymentMethodNonce = null;\n                        this.isProcessing = false;\n                    }\n                },\n                imports: {\n                    onActiveChange: 'active'\n                }\n            },\n\n            /**\n             * Set list of observable attributes\n             *\n             * @returns {exports.initObservable}\n             */\n            initObservable: function () {\n                validator.setConfig(window.checkoutConfig.payment[this.getCode()]);\n                this._super()\n                    .observe(['active']);\n                this.validatorManager.initialize();\n                this.initClientConfig();\n\n                return this;\n            },\n\n            /**\n             * Get payment name\n             *\n             * @returns {String}\n             */\n            getCode: function () {\n                return this.code;\n            },\n\n            /**\n             * Check if payment is active\n             *\n             * @returns {Boolean}\n             */\n            isActive: function () {\n                var active = this.getCode() === this.isChecked();\n\n                this.active(active);\n\n                return active;\n            },\n\n            /**\n             * Triggers when payment method change\n             * @param {Boolean} isActive\n             */\n            onActiveChange: function (isActive) {\n                if (!isActive) {\n                    return;\n                }\n\n                this.initBraintree();\n            },\n\n            /**\n             * Init config\n             */\n            initClientConfig: function () {\n                // Advanced fraud tools settings\n                if (this.hasFraudProtection()) {\n                    this.clientConfig = _.extend(this.clientConfig, this.kountConfig());\n                }\n\n                _.each(this.clientConfig, function (fn, name) {\n                    if (typeof fn === 'function') {\n                        this.clientConfig[name] = fn.bind(this);\n                    }\n                }, this);\n            },\n\n            /**\n             * Init Braintree configuration\n             */\n            initBraintree: function () {\n                var intervalId = setInterval(function () {\n                    // stop loader when frame will be loaded\n                    if ($('#braintree-hosted-field-number').length) {\n                        clearInterval(intervalId);\n                        fullScreenLoader.stopLoader(true);\n                    }\n                }, 500);\n\n                if (braintree.checkout) {\n                    braintree.checkout.teardown(function () {\n                        braintree.checkout = null;\n                    });\n                }\n\n                fullScreenLoader.startLoader();\n                braintree.setConfig(this.clientConfig);\n                braintree.setup();\n            },\n\n            /**\n             * @returns {Object}\n             */\n            kountConfig: function () {\n                var config = {\n                    dataCollector: {\n                        kount: {\n                            environment: this.getEnvironment()\n                        }\n                    },\n\n                    /**\n                     * Device data initialization\n                     *\n                     * @param {Object} checkout\n                     */\n                    onReady: function (context) {\n                        this.additionalData['device_data'] = context.deviceData;\n                        context.setupHostedFields();\n                    }\n                };\n\n                if (this.getKountMerchantId()) {\n                    config.dataCollector.kount.merchantId = this.getKountMerchantId();\n                }\n\n                return config;\n            },\n\n            /**\n             * Get full selector name\n             *\n             * @param {String} field\n             * @returns {String}\n             */\n            getSelector: function (field) {\n                return '#' + this.getCode() + '_' + field;\n            },\n\n            /**\n             * Get list of available CC types\n             *\n             * @returns {Object}\n             */\n            getCcAvailableTypes: function () {\n                var availableTypes = validator.getAvailableCardTypes(),\n                    billingAddress = quote.billingAddress(),\n                    billingCountryId;\n\n                this.lastBillingAddress = quote.shippingAddress();\n\n                if (!billingAddress) {\n                    billingAddress = this.lastBillingAddress;\n                }\n\n                billingCountryId = billingAddress.countryId;\n\n                if (billingCountryId && validator.getCountrySpecificCardTypes(billingCountryId)) {\n                    return validator.collectTypes(\n                        availableTypes,\n                        validator.getCountrySpecificCardTypes(billingCountryId)\n                    );\n                }\n\n                return availableTypes;\n            },\n\n            /**\n             * @returns {Boolean}\n             */\n            hasFraudProtection: function () {\n                return window.checkoutConfig.payment[this.getCode()].hasFraudProtection;\n            },\n\n            /**\n             * @returns {String}\n             */\n            getEnvironment: function () {\n                return window.checkoutConfig.payment[this.getCode()].environment;\n            },\n\n            /**\n             * @returns {String}\n             */\n            getKountMerchantId: function () {\n                return window.checkoutConfig.payment[this.getCode()].kountMerchantId;\n            },\n\n            /**\n             * Get data\n             *\n             * @returns {Object}\n             */\n            getData: function () {\n                var data = {\n                    'method': this.getCode(),\n                    'additional_data': {\n                        'payment_method_nonce': this.paymentMethodNonce,\n                        'g-recaptcha-response' : $(\"#token-grecaptcha-braintree\").val()\n                    }\n                };\n\n                data['additional_data'] = _.extend(data['additional_data'], this.additionalData);\n\n                return data;\n            },\n\n            /**\n             * Set payment nonce\n             * @param {String} paymentMethodNonce\n             */\n            setPaymentMethodNonce: function (paymentMethodNonce) {\n                this.paymentMethodNonce = paymentMethodNonce;\n            },\n\n            /**\n             * Prepare data to place order\n             * @param {Object} data\n             */\n            handleNonce: function (data) {\n                var self = this;\n\n                this.setPaymentMethodNonce(data.nonce);\n\n                // place order on success validation\n                self.validatorManager.validate(self, function () {\n                    return self.placeOrder('parent');\n                }, function() {\n                    self.isProcessing = false;\n                    self.paymentMethodNonce = null;\n                });\n            },\n\n            /**\n             * Action to place order\n             * @param {String} key\n             */\n            placeOrder: function (key) {\n                if (key) {\n                    return this._super();\n                }\n\n                if (this.isProcessing) {\n                    return false;\n                } else {\n                    this.isProcessing = true;\n                }\n\n                braintree.tokenizeHostedFields();\n                return false;\n            },\n\n            /**\n             * Get payment icons\n             * @param {String} type\n             * @returns {Boolean}\n             */\n            getIcons: function (type) {\n                return window.checkoutConfig.payment.braintree.icons.hasOwnProperty(type) ?\n                    window.checkoutConfig.payment.braintree.icons[type]\n                    : false;\n            },\n        });\n    }\n);\n","PayPal_Braintree/js/view/payment/method-renderer/multishipping/paypal.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine([\n    'jquery',\n    'underscore',\n    'braintreeCheckoutPayPalAdapter',\n    'Magento_Checkout/js/model/quote',\n    'PayPal_Braintree/js/view/payment/method-renderer/paypal',\n    'Magento_Checkout/js/action/set-payment-information',\n    'Magento_Checkout/js/model/payment/additional-validators',\n    'Magento_Checkout/js/model/full-screen-loader',\n    'mage/translate'\n], function (\n    $,\n    _,\n    Braintree,\n    quote,\n    Component,\n    setPaymentInformationAction,\n    additionalValidators,\n    fullScreenLoader,\n    $t\n) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'PayPal_Braintree/payment/multishipping/paypal',\n            submitButtonSelector: '[id=\"parent-payment-continue\"]',\n            reviewButtonHtml: ''\n        },\n\n        /**\n         * @override\n         */\n        initObservable: function () {\n            this.reviewButtonHtml = $(this.submitButtonSelector).html();\n            return this._super();\n        },\n\n        initClientConfig: function () {\n            this.clientConfig = _.extend(this.clientConfig, this.getPayPalConfig());\n            this.clientConfig.paypal.enableShippingAddress = false;\n\n            _.each(this.clientConfig, function (fn, name) {\n                if (typeof fn === 'function') {\n                    this.clientConfig[name] = fn.bind(this);\n                }\n            }, this);\n            this.clientConfig.buttonPayPalId = 'parent-payment-continue';\n\n        },\n\n        /**\n         * @override\n         */\n        onActiveChange: function (isActive) {\n            this.updateSubmitButtonHtml(isActive);\n            this._super(isActive);\n        },\n\n        /**\n         * @override\n         */\n        beforePlaceOrder: function (data) {\n            this._super(data);\n        },\n\n        /**\n         * Re-init PayPal Auth Flow\n         */\n        reInitPayPal: function () {\n            this.disableButton();\n            this.clientConfig.paypal.amount = parseFloat(this.grandTotalAmount).toFixed(2);\n\n            if (!quote.isVirtual()) {\n                this.clientConfig.paypal.enableShippingAddress = false;\n                this.clientConfig.paypal.shippingAddressEditable = false;\n            }\n\n            Braintree.setConfig(this.clientConfig);\n\n            if (Braintree.getPayPalInstance()) {\n                Braintree.getPayPalInstance().teardown(function () {\n                    Braintree.setup();\n                }.bind(this));\n                Braintree.setPayPalInstance(null);\n            } else {\n                Braintree.setup();\n                this.enableButton();\n            }\n        },\n\n        /**\n         * Get configuration for PayPal\n         * @returns {Object}\n         */\n        getPayPalConfig: function () {\n            var totals = quote.totals(),\n                config = {},\n                isActiveVaultEnabler = this.isActiveVault();\n\n            config.paypal = {\n                flow: 'checkout',\n                amount: parseFloat(this.grandTotalAmount).toFixed(2),\n                currency: totals['base_currency_code'],\n                locale: this.getLocale(),\n                requestBillingAgreement: true,\n                /**\n                 * Triggers on any Braintree error\n                 */\n                onError: function () {\n                    this.paymentMethodNonce = null;\n                },\n\n                /**\n                 * Triggers if browser doesn't support PayPal Checkout\n                 */\n                onUnsupported: function () {\n                    this.paymentMethodNonce = null;\n                }\n            };\n\n            if (!quote.isVirtual()) {\n                config.paypal.enableShippingAddress = false;\n                config.paypal.shippingAddressEditable = false;\n            }\n\n            if (this.getMerchantName()) {\n                config.paypal.displayName = this.getMerchantName();\n            }\n\n            return config;\n        },\n\n        /**\n         * @override\n         */\n        getData: function () {\n            var data = this._super();\n\n            data['additional_data']['is_active_payment_token_enabler'] = true;\n\n            return data;\n        },\n\n        /**\n         * @override\n         */\n        isActiveVault: function () {\n            return true;\n        },\n\n        /**\n         * Skipping order review step on checkout with multiple addresses is not allowed.\n         *\n         * @returns {Boolean}\n         */\n        isSkipOrderReview: function () {\n            return false;\n        },\n\n        /**\n         * Checks if payment method nonce is already received.\n         *\n         * @returns {Boolean}\n         */\n        isPaymentMethodNonceReceived: function () {\n            return this.paymentMethodNonce !== null;\n        },\n\n        /**\n         * Update submit button on multi-addresses checkout billing form.\n         *\n         * @param {Boolean} isActive\n         */\n        updateSubmitButtonHtml: function (isActive) {\n            $(this.submitButtonSelector).removeClass(\"primary\");\n            if (this.isPaymentMethodNonceReceived() || !isActive) {\n                $(this.submitButtonSelector).addClass(\"primary\");\n                $(this.submitButtonSelector).html(this.reviewButtonHtml);\n            }\n        },\n\n        /**\n         * @override\n         */\n        placeOrder: function () {\n            if (!this.isPaymentMethodNonceReceived()) {\n                this.payWithPayPal();\n            } else {\n                fullScreenLoader.startLoader();\n\n                $.when(\n                    setPaymentInformationAction(\n                        this.messageContainer,\n                        this.getData()\n                    )\n                ).done(this.done.bind(this))\n                    .fail(this.fail.bind(this));\n            }\n        },\n\n        /**\n         * {Function}\n         */\n        fail: function () {\n            fullScreenLoader.stopLoader();\n\n            return this;\n        },\n\n        /**\n         * {Function}\n         */\n        done: function () {\n            fullScreenLoader.stopLoader();\n            $('#multishipping-billing-form').submit();\n\n            return this;\n        }\n    });\n});","PayPal_Braintree/js/view/payment/method-renderer/multishipping/hosted-fields.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\n\ndefine([\n    'jquery',\n    'PayPal_Braintree/js/view/payment/method-renderer/hosted-fields',\n    'PayPal_Braintree/js/validator',\n    'Magento_Ui/js/model/messageList',\n    'mage/translate',\n    'Magento_Checkout/js/model/full-screen-loader',\n    'Magento_Checkout/js/action/set-payment-information',\n    'Magento_Checkout/js/model/payment/additional-validators',\n    'PayPal_Braintree/js/view/payment/adapter'\n], function (\n    $,\n    Component,\n    validator,\n    messageList,\n    $t,\n    fullScreenLoader,\n    setPaymentInformationAction,\n    additionalValidators,\n    braintree\n) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'PayPal_Braintree/payment/multishipping/form'\n        },\n\n        /**\n         * Get list of available CC types\n         *\n         * @returns {Object}\n         */\n        getCcAvailableTypes: function () {\n            var availableTypes = validator.getAvailableCardTypes(),\n                billingCountryId;\n\n            billingCountryId = $('#multishipping_billing_country_id').val();\n\n            if (billingCountryId && validator.getCountrySpecificCardTypes(billingCountryId)) {\n                return validator.collectTypes(\n                    availableTypes, validator.getCountrySpecificCardTypes(billingCountryId)\n                );\n            }\n\n            return availableTypes;\n        },\n\n        /**\n         * @override\n         */\n        handleNonce: function (data) {\n            var self = this;\n            this.setPaymentMethodNonce(data.nonce);\n\n            // place order on success validation\n            self.validatorManager.validate(self, function () {\n                return self.setPaymentInformation();\n            }, function() {\n                self.isProcessing = false;\n                self.paymentMethodNonce = null;\n            });\n        },\n\n        /**\n         * @override\n         */\n        placeOrder: function () {\n            var self = this;\n\n            if (this.isProcessing) {\n                return false;\n            } else {\n                this.isProcessing = true;\n            }\n\n            braintree.tokenizeHostedFields();\n            return false;\n        },\n\n        /**\n         * @override\n         */\n        setPaymentInformation: function () {\n            if (additionalValidators.validate()) {\n                fullScreenLoader.startLoader();\n                $.when(\n                    setPaymentInformationAction(\n                        this.messageContainer,\n                        this.getData()\n                    )\n                ).done(this.done.bind(this))\n                    .fail(this.fail.bind(this));\n            }\n        },\n\n        /**\n         * {Function}\n         */\n        fail: function () {\n            fullScreenLoader.stopLoader();\n\n            return this;\n        },\n\n        /**\n         * {Function}\n         */\n        done: function () {\n            fullScreenLoader.stopLoader();\n            $('#multishipping-billing-form').submit();\n\n            return this;\n        }\n    });\n});\n","PayPal_Braintree/js/applepay/button.js":"/**\n * Braintree Apple Pay button\n **/\ndefine(\n    [\n        'uiComponent',\n        \"knockout\",\n        \"jquery\",\n        'braintree',\n        'braintreeApplePay',\n        'mage/translate'\n        ],\n    function (\n        Component,\n        ko,\n        jQuery,\n        braintree,\n        applePay,\n        $t\n    ) {\n        'use strict';\n\n        var that;\n\n        return {\n            init: function (element, context) {\n                // No element or context\n                if (!element || !context) {\n                    return;\n                }\n\n                // Context must implement these methods\n                if (typeof context.getClientToken !== 'function') {\n                    console.error(\"Braintree ApplePay Context passed does not provide a getClientToken method\", context);\n                    return;\n                }\n                if (typeof context.getPaymentRequest !== 'function') {\n                    console.error(\"Braintree ApplePay Context passed does not provide a getPaymentRequest method\", context);\n                    return;\n                }\n                if (typeof context.startPlaceOrder !== 'function') {\n                    console.error(\"Braintree ApplePay Context passed does not provide a startPlaceOrder method\", context);\n                    return;\n                }\n\n                if (this.deviceSupported() === false) {\n                    return;\n                }\n\n                // init braintree api\n                braintree.create({\n                    authorization: context.getClientToken()\n                }, function (clientErr, clientInstance) {\n                    if (clientErr) {\n                        console.error('Error creating client:', clientErr);\n                        return;\n                    }\n\n                    applePay.create({\n                        client: clientInstance\n                    }, function (applePayErr, applePayInstance) {\n                        // No instance\n                        if (applePayErr) {\n                            console.error('Braintree ApplePay Error creating applePayInstance:', applePayErr);\n                            return;\n                        }\n\n                        // Create a button within the KO element, as apple pay can only be instantiated through\n                        // a valid on click event (ko onclick bind interferes with this).\n                        var el = document.createElement('div');\n                        el.className = \"braintree-apple-pay-button\";\n                        el.title = $t(\"Pay with Apple Pay\");\n                        el.alt = $t(\"Pay with Apple Pay\");\n                        el.addEventListener('click', function (e) {\n                            e.preventDefault();\n\n                            // Payment request object\n                            var paymentRequest = applePayInstance.createPaymentRequest(context.getPaymentRequest());\n                            if (!paymentRequest) {\n                                alert($t(\"We're unable to take payments through Apple Pay at the moment. Please try an alternative payment method.\"));\n                                console.error('Braintree ApplePay Unable to create paymentRequest', paymentRequest);\n                                return;\n                            }\n\n                            // Show the loader\n                            jQuery(\"body\").loader('show');\n\n                            // Init apple pay session\n                            try {\n                                var session = new ApplePaySession(1, paymentRequest);\n                            } catch (err) {\n                                jQuery(\"body\").loader('hide');\n                                console.error('Braintree ApplePay Unable to create ApplePaySession', err);\n                                alert($t(\"We're unable to take payments through Apple Pay at the moment. Please try an alternative payment method.\"));\n                                return false;\n                            }\n\n                            // Handle invalid merchant\n                            session.onvalidatemerchant = function (event) {\n                                applePayInstance.performValidation({\n                                    validationURL: event.validationURL,\n                                    displayName: context.getDisplayName()\n                                }, function (validationErr, merchantSession) {\n                                    if (validationErr) {\n                                        session.abort();\n                                        console.error('Braintree ApplePay Error validating merchant:', validationErr);\n                                        alert($t(\"We're unable to take payments through Apple Pay at the moment. Please try an alternative payment method.\"));\n                                        return;\n                                    }\n\n                                    session.completeMerchantValidation(merchantSession);\n                                });\n                            };\n\n                            // Attach payment auth event\n                            session.onpaymentauthorized = function (event) {\n                                applePayInstance.tokenize({\n                                    token: event.payment.token\n                                }, function (tokenizeErr, payload) {\n                                    if (tokenizeErr) {\n                                        console.error('Error tokenizing Apple Pay:', tokenizeErr);\n                                        session.completePayment(ApplePaySession.STATUS_FAILURE);\n                                        return;\n                                    }\n\n                                    // Pass the nonce back to the payment method\n                                    context.startPlaceOrder(payload.nonce, event, session);\n                                });\n                            };\n\n                            // Attach onShippingContactSelect method\n                            if (typeof context.onShippingContactSelect === 'function') {\n                                session.onshippingcontactselected = function (event) {\n                                    return context.onShippingContactSelect(event, session);\n                                };\n                            }\n\n                            // Attach onShippingMethodSelect method\n                            if (typeof context.onShippingMethodSelect === 'function') {\n                                session.onshippingmethodselected = function (event) {\n                                    return context.onShippingMethodSelect(event, session);\n                                };\n                            }\n\n                            // Hook\n                            if (typeof context.onButtonClick === 'function') {\n                                context.onButtonClick(session, this, e);\n                            } else {\n                                jQuery(\"body\").loader('hide');\n                                session.begin();\n                            }\n                        });\n                        element.appendChild(el);\n                    });\n                });\n            },\n\n            /**\n             * Check the site is using HTTPS & apple pay is supported on this device.\n             * @return boolean\n             */\n            deviceSupported: function () {\n                if (location.protocol != 'https:') {\n                    console.warn(\"Braintree Apple Pay requires your checkout be served over HTTPS\");\n                    return false;\n                }\n\n                if ((window.ApplePaySession && ApplePaySession.canMakePayments()) !== true) {\n                    console.warn(\"Braintree Apple Pay is not supported on this device/browser\");\n                    return false;\n                }\n\n                return true;\n            }\n        };\n    }\n);","PayPal_Braintree/js/applepay/api.js":"/**\n * Braintree Apple Pay button API\n *\n **/\ndefine(\n    [\n        'jquery',\n        'underscore',\n        'uiComponent',\n        'mage/translate',\n        'mage/storage',\n        'Magento_Customer/js/customer-data'\n    ],\n    function (\n        $,\n        _,\n        Component,\n        $t,\n        storage,\n        customerData\n    ) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                clientToken: null,\n                quoteId: 0,\n                displayName: null,\n                actionSuccess: null,\n                grandTotalAmount: 0,\n                isLoggedIn: false,\n                storeCode: \"default\",\n                shippingAddress: {},\n                countryDirectory: null,\n                shippingMethods: {}\n            },\n\n            initialize: function () {\n                this._super();\n                if (!this.countryDirectory) {\n                    storage.get(\"rest/V1/directory/countries\").done(function (result) {\n                        this.countryDirectory = {};\n                        let i, data, x, region;\n                        for (i = 0; i < result.length; ++i) {\n                            data = result[i];\n                            this.countryDirectory[data.two_letter_abbreviation] = {};\n                            if (typeof data.available_regions !== 'undefined') {\n                                for (x = 0; x < data.available_regions.length; ++x) {\n                                    region = data.available_regions[x];\n                                    this.countryDirectory[data.two_letter_abbreviation][region.name.toLowerCase().replace(/[^A-Z0-9]/ig, '')] = region.id;\n                                }\n                            }\n                        }\n                    }.bind(this));\n                }\n            },\n\n            /**\n             * Get region ID\n             */\n            getRegionId: function (countryCode, regionName) {\n                if (typeof regionName !== 'string') {\n                    return null;\n                }\n\n                regionName = regionName.toLowerCase().replace(/[^A-Z0-9]/ig, '');\n\n                if (typeof this.countryDirectory[countryCode] !== 'undefined' && typeof this.countryDirectory[countryCode][regionName] !== 'undefined') {\n                    return this.countryDirectory[countryCode][regionName];\n                }\n\n                return 0;\n            },\n\n            /**\n             * Set & get api token\n             */\n            setClientToken: function (value) {\n                this.clientToken = value;\n            },\n            getClientToken: function () {\n                return this.clientToken;\n            },\n\n            /**\n             * Set and get quote id\n             */\n            setQuoteId: function (value) {\n                this.quoteId = value;\n            },\n            getQuoteId: function () {\n                return this.quoteId;\n            },\n\n            /**\n             * Set and get display name\n             */\n            setDisplayName: function (value) {\n                this.displayName = value;\n            },\n            getDisplayName: function () {\n                return this.displayName;\n            },\n\n            /**\n             * Set and get success redirection url\n             */\n            setActionSuccess: function (value) {\n                this.actionSuccess = value;\n            },\n            getActionSuccess: function () {\n                return this.actionSuccess;\n            },\n\n            /**\n             * Set and get grand total\n             */\n            setGrandTotalAmount: function (value) {\n                this.grandTotalAmount = parseFloat(value).toFixed(2);\n            },\n            getGrandTotalAmount: function () {\n                return parseFloat(this.grandTotalAmount);\n            },\n\n            /**\n             * Set and get is logged in\n             */\n            setIsLoggedIn: function (value) {\n                this.isLoggedIn = value;\n            },\n            getIsLoggedIn: function () {\n                return this.isLoggedIn;\n            },\n\n            /**\n             * Set and get store code\n             */\n            setStoreCode: function (value) {\n                this.storeCode = value;\n            },\n            getStoreCode: function () {\n                return this.storeCode;\n            },\n\n            /**\n             * API Urls for logged in / guest\n             */\n            getApiUrl: function (uri) {\n                if (this.getIsLoggedIn() === true) {\n                    return \"rest/\" + this.getStoreCode() + \"/V1/carts/mine/\" + uri;\n                } else {\n                    return \"rest/\" + this.getStoreCode() + \"/V1/guest-carts/\" + this.getQuoteId() + \"/\" + uri;\n                }\n            },\n\n            /**\n             * Payment request info\n             */\n            getPaymentRequest: function () {\n                return {\n                    total: {\n                        label: this.getDisplayName(),\n                        amount: this.getGrandTotalAmount()\n                    },\n                    requiredShippingContactFields: ['postalAddress', 'name', 'email', 'phone'],\n                    requiredBillingContactFields: ['postalAddress', 'name']\n                };\n            },\n\n            /**\n             * Retrieve shipping methods based on address\n             */\n            onShippingContactSelect: function (event, session) {\n                // Get the address.\n                let address = event.shippingContact;\n\n                // Create a payload.\n                let payload = {\n                    address: {\n                        city: address.locality,\n                        region: address.administrativeArea,\n                        country_id: address.countryCode.toUpperCase(),\n                        postcode: address.postalCode,\n                        save_in_address_book: 0\n                    }\n                };\n\n                this.shippingAddress = payload.address;\n\n                // POST to endpoint for shipping methods.\n                storage.post(\n                    this.getApiUrl(\"estimate-shipping-methods\"),\n                    JSON.stringify(payload)\n                ).done(function (result) {\n                    // Stop if no shipping methods.\n                    if (result.length === 0) {\n                        let virtualFlag = false,\n                            productItems = customerData.get('cart')().items;\n                        _.each(productItems,\n                            function (item) {\n                                if(item.product_type == 'virtual') {\n                                    virtualFlag = true;\n                                } else {\n                                    virtualFlag = false;\n                                }\n                            }\n                        )\n                        if(virtualFlag) {\n                            session.completeShippingContactSelection(\n                                ApplePaySession.STATUS_SUCCESS,\n                                [],\n                                {\n                                    label: this.getDisplayName(),\n                                    amount: this.getGrandTotalAmount()\n                                },\n                                [{\n                                    type: 'final',\n                                    label: $t('Shipping'),\n                                    amount: 0\n                                }]\n                            );\n                        } else {\n                            session.abort();\n                            alert($t(\"There are no shipping methods available for you right now. Please try again or use an alternative payment method.\"));\n                            return false;\n                        }\n\n                    }\n\n                    let shippingMethods = [];\n                    this.shippingMethods = {};\n\n                    // Format shipping methods array.\n                    for (let i = 0; i < result.length; i++) {\n                        if (typeof result[i].method_code !== 'string') {\n                            continue;\n                        }\n\n                        let method = {\n                            identifier: result[i].method_code,\n                            label: result[i].method_title,\n                            detail: result[i].carrier_title ? result[i].carrier_title : \"\",\n                            amount: parseFloat(result[i].amount).toFixed(2)\n                        };\n\n                        // Add method object to array.\n                        shippingMethods.push(method);\n\n                        this.shippingMethods[result[i].method_code] = result[i];\n\n                        if (!this.shippingMethod) {\n                            this.shippingMethod = result[i].method_code;\n                        }\n                    }\n\n                    // Create payload to get totals\n                    let totalsPayload = {\n                        \"addressInformation\": {\n                            \"address\": {\n                                \"countryId\": this.shippingAddress.country_id,\n                                \"region\": this.shippingAddress.region,\n                                \"regionId\": this.getRegionId(this.shippingAddress.country_id, this.shippingAddress.region),\n                                \"postcode\": this.shippingAddress.postcode\n                            },\n                            \"shipping_method_code\": this.shippingMethods[shippingMethods[0].identifier].method_code,\n                            \"shipping_carrier_code\": this.shippingMethods[shippingMethods[0].identifier].carrier_code\n                        }\n                    };\n\n                    // POST to endpoint to get totals, using 1st shipping method\n                    storage.post(\n                        this.getApiUrl(\"totals-information\"),\n                        JSON.stringify(totalsPayload)\n                    ).done(function (result) {\n                        // Set total\n                        this.setGrandTotalAmount(result.base_grand_total);\n\n                        // Pass shipping methods back\n                        session.completeShippingContactSelection(\n                            ApplePaySession.STATUS_SUCCESS,\n                            shippingMethods,\n                            {\n                                label: this.getDisplayName(),\n                                amount: this.getGrandTotalAmount()\n                            },\n                            [{\n                                type: 'final',\n                                label: $t('Shipping'),\n                                amount: shippingMethods[0].amount\n                            }]\n                        );\n                    }.bind(this)).fail(function (result) {\n                        session.abort();\n                        alert($t(\"We're unable to fetch the cart totals for you. Please try an alternative payment method.\"));\n                        console.error(\"Braintree ApplePay: Unable to get totals\", result);\n                        return false;\n                    });\n\n                }.bind(this)).fail(function (result) {\n                    session.abort();\n                    alert($t(\"We're unable to find any shipping methods for you. Please try an alternative payment method.\"));\n                    console.error(\"Braintree ApplePay: Unable to find shipping methods for estimate-shipping-methods\", result);\n                    return false;\n                });\n            },\n\n            /**\n             * Record which shipping method has been selected & Updated totals\n             */\n            onShippingMethodSelect: function (event, session) {\n                let shippingMethod = event.shippingMethod;\n                this.shippingMethod = shippingMethod.identifier;\n\n                let payload = {\n                    \"addressInformation\": {\n                        \"address\": {\n                            \"countryId\": this.shippingAddress.country_id,\n                            \"region\": this.shippingAddress.region,\n                            \"regionId\": this.getRegionId(this.shippingAddress.country_id, this.shippingAddress.region),\n                            \"postcode\": this.shippingAddress.postcode\n                        },\n                        \"shipping_method_code\": this.shippingMethods[this.shippingMethod].method_code,\n                        \"shipping_carrier_code\": this.shippingMethods[this.shippingMethod].carrier_code\n                    }\n                };\n\n                storage.post(\n                    this.getApiUrl(\"totals-information\"),\n                    JSON.stringify(payload)\n                ).done(function (r) {\n                    this.setGrandTotalAmount(r.base_grand_total);\n\n                    session.completeShippingMethodSelection(\n                        ApplePaySession.STATUS_SUCCESS,\n                        {\n                            label: this.getDisplayName(),\n                            amount: this.getGrandTotalAmount()\n                        },\n                        [{\n                            type: 'final',\n                            label: $t('Shipping'),\n                            amount: shippingMethod.amount\n                        }]\n                    );\n                }.bind(this));\n            },\n\n            /**\n             * Place the order\n             */\n            startPlaceOrder: function (nonce, event, session) {\n                let shippingContact = event.payment.shippingContact,\n                    billingContact = event.payment.billingContact,\n                    payload = {\n                        \"addressInformation\": {\n                            \"shipping_address\": {\n                                \"email\": shippingContact.emailAddress,\n                                \"telephone\": shippingContact.phoneNumber,\n                                \"firstname\": shippingContact.givenName,\n                                \"lastname\": shippingContact.familyName,\n                                \"street\": shippingContact.addressLines,\n                                \"city\": shippingContact.locality,\n                                \"region\": shippingContact.administrativeArea,\n                                \"region_id\": this.getRegionId(shippingContact.countryCode.toUpperCase(), shippingContact.administrativeArea),\n                                \"region_code\": null,\n                                \"country_id\": shippingContact.countryCode.toUpperCase(),\n                                \"postcode\": shippingContact.postalCode,\n                                \"same_as_billing\": 0,\n                                \"customer_address_id\": 0,\n                                \"save_in_address_book\": 0\n                            },\n                            \"billing_address\": {\n                                \"email\": shippingContact.emailAddress,\n                                \"telephone\": '0000000000',\n                                \"firstname\": billingContact.givenName,\n                                \"lastname\": billingContact.familyName,\n                                \"street\": billingContact.addressLines,\n                                \"city\": billingContact.locality,\n                                \"region\": billingContact.administrativeArea,\n                                \"region_id\": this.getRegionId(billingContact.countryCode.toUpperCase(), billingContact.administrativeArea),\n                                \"region_code\": null,\n                                \"country_id\": billingContact.countryCode.toUpperCase(),\n                                \"postcode\": billingContact.postalCode,\n                                \"same_as_billing\": 0,\n                                \"customer_address_id\": 0,\n                                \"save_in_address_book\": 0\n                            },\n                            \"shipping_method_code\": this.shippingMethod ? this.shippingMethods[this.shippingMethod].method_code : '' ,\n                            \"shipping_carrier_code\": this.shippingMethod ? this.shippingMethods[this.shippingMethod].carrier_code : ''\n                        }\n                    };\n\n                // Set addresses\n                storage.post(\n                    this.getApiUrl(\"shipping-information\"),\n                    JSON.stringify(payload)\n                ).done(function () {\n                    // Submit payment information\n                    storage.post(\n                        this.getApiUrl(\"payment-information\"),\n                        JSON.stringify(\n                            {\n                                \"email\": shippingContact.emailAddress,\n                                \"paymentMethod\": {\n                                    \"method\": \"braintree_applepay\",\n                                    \"additional_data\": {\n                                        \"payment_method_nonce\": nonce\n                                    },\n                                    \"extension_attributes\": {\n                                        \"agreement_ids\": [1]\n                                    }\n                                }\n                            }\n                        )\n                    ).done(function (r) {\n                        document.location = this.getActionSuccess();\n                        session.completePayment(ApplePaySession.STATUS_SUCCESS);\n                    }.bind(this)).fail(function (r) {\n                        session.completePayment(ApplePaySession.STATUS_FAILURE);\n                        session.abort();\n                        alert($t(\"We're unable to take your payment through Apple Pay. Please try an again or use an alternative payment method.\"));\n                        console.error(\"Braintree ApplePay Unable to take payment\", r);\n                        return false;\n                    });\n\n                }.bind(this)).fail(function (r) {\n                    console.error(\"Braintree ApplePay Unable to set shipping information\", r);\n                    session.completePayment(ApplePaySession.STATUS_INVALID_BILLING_POSTAL_ADDRESS);\n                });\n            }\n        });\n    });\n","PayPal_Braintree/js/applepay/implementations/shortcut.js":"/**\n * Braintree Apple Pay mini cart payment method integration.\n **/\ndefine(\n    [\n        'uiComponent',\n        'PayPal_Braintree/js/applepay/button',\n        'PayPal_Braintree/js/applepay/api',\n        'mage/translate',\n        'domReady!'\n    ],\n    function (\n        Component,\n        button,\n        buttonApi,\n        $t\n    ) {\n        'use strict';\n\n        return Component.extend({\n\n            defaults: {\n                id: null,\n                clientToken: null,\n                quoteId: 0,\n                displayName: null,\n                actionSuccess: null,\n                grandTotalAmount: 0,\n                isLoggedIn: false,\n                storeCode: \"default\"\n            },\n\n            /**\n             * @returns {Object}\n             */\n            initialize: function () {\n                this._super();\n                if (!this.displayName) {\n                    this.displayName = $t('Store');\n                }\n\n                var api = new buttonApi();\n                api.setGrandTotalAmount(parseFloat(this.grandTotalAmount).toFixed(2));\n                api.setClientToken(this.clientToken);\n                api.setDisplayName(this.displayName);\n                api.setQuoteId(this.quoteId);\n                api.setActionSuccess(this.actionSuccess);\n                api.setIsLoggedIn(this.isLoggedIn);\n                api.setStoreCode(this.storeCode);\n\n                // Attach the button\n                button.init(\n                    document.getElementById(this.id),\n                    api\n                );\n\n                return this;\n            }\n        });\n    }\n);\n","PayPal_Braintree/js/applepay/implementations/core-checkout/method-applepay.js":"define(\n    ['uiComponent', 'Magento_Checkout/js/model/payment/renderer-list'],\n    function (Component, rendererList) {\n        'use strict';\n\n        rendererList.push(\n            {\n                type: 'braintree_applepay',\n                component: 'PayPal_Braintree/js/applepay/implementations/core-checkout/method-renderer/applepay'\n            }\n        );\n\n        return Component.extend({});\n    }\n);","PayPal_Braintree/js/applepay/implementations/core-checkout/method-renderer/applepay.js":"/**\n * Braintree Apple Pay payment method integration.\n **/\ndefine([\n    'Magento_Checkout/js/view/payment/default',\n    'Magento_Checkout/js/model/quote',\n    'PayPal_Braintree/js/applepay/button'\n], function (\n    Component,\n    quote,\n    button\n) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'PayPal_Braintree/applepay/core-checkout',\n            paymentMethodNonce: null,\n            grandTotalAmount: 0,\n            deviceSupported: button.deviceSupported()\n        },\n\n        /**\n         * Inject the apple pay button into the target element\n         */\n        getApplePayBtn: function (id) {\n            button.init(\n                document.getElementById(id),\n                this\n            );\n        },\n\n        /**\n         * Subscribe to grand totals\n         */\n        initObservable: function () {\n            this._super();\n            this.grandTotalAmount = parseFloat(quote.totals()['base_grand_total']).toFixed(2);\n\n            quote.totals.subscribe(function () {\n                if (this.grandTotalAmount !== quote.totals()['base_grand_total']) {\n                    this.grandTotalAmount = parseFloat(quote.totals()['base_grand_total']).toFixed(2);\n                }\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Apple pay place order method\n         */\n        startPlaceOrder: function (nonce, event, session) {\n            this.setPaymentMethodNonce(nonce);\n            this.placeOrder();\n\n            session.completePayment(ApplePaySession.STATUS_SUCCESS);\n        },\n\n        /**\n         * Save nonce\n         */\n        setPaymentMethodNonce: function (nonce) {\n            this.paymentMethodNonce = nonce;\n        },\n\n        /**\n         * Retrieve the client token\n         * @returns null|string\n         */\n        getClientToken: function () {\n            return window.checkoutConfig.payment[this.getCode()].clientToken;\n        },\n\n        /**\n         * Payment request data\n         */\n        getPaymentRequest: function () {\n            return {\n                total: {\n                    label: this.getDisplayName(),\n                    amount: this.grandTotalAmount\n                }\n            };\n        },\n\n        /**\n         * Merchant display name\n         */\n        getDisplayName: function () {\n            return window.checkoutConfig.payment[this.getCode()].merchantName;\n        },\n\n        /**\n         * Get data\n         * @returns {Object}\n         */\n        getData: function () {\n            var data = {\n                'method': this.getCode(),\n                'additional_data': {\n                    'payment_method_nonce': this.paymentMethodNonce\n                }\n            };\n            return data;\n        },\n\n        /**\n         * Return image url for the apple pay mark\n         */\n        getPaymentMarkSrc: function () {\n            return window.checkoutConfig.payment[this.getCode()].paymentMarkSrc;\n        }\n    });\n});","Magento_Multishipping/js/multi-shipping.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Customer/js/customer-data',\n    'jquery-ui-modules/widget'\n], function ($, customerData) {\n    'use strict';\n\n    $.widget('mage.multiShipping', {\n        options: {\n            itemsQty: 0,\n            addNewAddressBtn: 'button[data-role=\"add-new-address\"]', // Add a new multishipping address.\n            addNewAddressFlag: '#add_new_address_flag', // Hidden input field with value 0 or 1.\n            canContinueBtn: 'button[data-role=\"can-continue\"]', // Continue (update quantity or go to shipping).\n            canContinueFlag: '#can_continue_flag' // Hidden input field with value 0 or 1.\n        },\n\n        /**\n         * Bind event handlers to click events for corresponding buttons.\n         * @private\n         */\n        _create: function () {\n            this._prepareCartData();\n            $(this.options.addNewAddressBtn).on('click', $.proxy(this._addNewAddress, this));\n            $(this.options.canContinueBtn).on('click', $.proxy(this._canContinue, this));\n        },\n\n        /**\n         * Takes cart items qty from current cart data and compare it with current items qty\n         * Reloads cart data if cart items qty is wrong\n         * @private\n         */\n        _prepareCartData: function () {\n            var cartData = customerData.get('cart');\n\n            if (cartData()['summary_count'] !== this.options.itemsQty) {\n                customerData.reload(['cart'], false);\n            }\n        },\n\n        /**\n         * Add a new address. Set the hidden input field and submit the form. Then enter a new shipping address.\n         * @private\n         */\n        _addNewAddress: function () {\n            $(this.options.addNewAddressFlag).val(1);\n            this.element.submit();\n        },\n\n        /**\n         * Can the user continue to the next step? The data-flag attribute holds either 0 (no) or 1 (yes).\n         * @private\n         * @param {Event} event - Click event on the corresponding button.\n         */\n        _canContinue: function (event) {\n            $(this.options.canContinueFlag).val(parseInt($(event.currentTarget).data('flag'), 10));\n        }\n    });\n\n    return $.mage.multiShipping;\n});\n","Magento_Multishipping/js/payment.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/template',\n    'Magento_Ui/js/modal/alert',\n    'jquery-ui-modules/widget',\n    'mage/translate'\n], function ($, mageTemplate, alert) {\n    'use strict';\n\n    $.widget('mage.payment', {\n        options: {\n            continueSelector: '#payment-continue',\n            methodsContainer: '#payment-methods',\n            minBalance: 0,\n            tmpl: '<input id=\"hidden-free\" type=\"hidden\" name=\"payment[method]\" value=\"free\">'\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this.element.find('dd [name^=\"payment[\"]').prop('disabled', true).end()\n                .on('click', this.options.continueSelector, $.proxy(this._submitHandler, this))\n                .on('updateCheckoutPrice', $.proxy(function (event, data) {\n                    //updating the checkoutPrice\n                    if (data.price) {\n                        this.options.checkoutPrice += data.price;\n                    }\n\n                    //updating total price\n                    if (data.totalPrice) {\n                        data.totalPrice = this.options.checkoutPrice;\n                    }\n\n                    if (this.options.checkoutPrice <= this.options.minBalance) {\n                        // Add free input field, hide and disable unchecked\n                        // checkbox payment method and all radio button payment methods\n                        this._disablePaymentMethods();\n                    } else {\n                        // Remove free input field, show all payment method\n                        this._enablePaymentMethods();\n                    }\n                }, this))\n                .on('click', 'dt input:radio', $.proxy(this._paymentMethodHandler, this));\n\n            if (this.options.checkoutPrice < this.options.minBalance) {\n                this._disablePaymentMethods();\n            } else {\n                this._enablePaymentMethods();\n            }\n        },\n\n        /**\n         * Display payment details when payment method radio button is checked\n         * @private\n         * @param {EventObject} e\n         */\n        _paymentMethodHandler: function (e) {\n            var element = $(e.target),\n                parentsDl = element.closest('dl');\n\n            parentsDl.find('dt input:radio').prop('checked', false);\n            parentsDl.find('dd').addClass('no-display').end()\n                .find('.items').hide()\n                .find('[name^=\"payment[\"]').prop('disabled', true);\n            element.prop('checked', true).parent()\n                .next('dd').removeClass('no-display')\n                .find('.items').show().find('[name^=\"payment[\"]').prop('disabled', false);\n        },\n\n        /**\n         * make sure one payment method is selected\n         * @private\n         * @return {Boolean}\n         */\n        _validatePaymentMethod: function () {\n            var methods = this.element.find('[name^=\"payment[\"]'),\n                isValid = false;\n\n            if (methods.length === 0) {\n                alert({\n                    content: $.mage.__('We can\\'t complete your order because you don\\'t have a payment method set up.')\n                });\n            } else if (this.options.checkoutPrice <= this.options.minBalance) {\n                isValid = true;\n            } else if (methods.filter('input:radio:checked').length) {\n                isValid = true;\n            } else {\n                alert({\n                    content: $.mage.__('Please choose a payment method.')\n                });\n            }\n\n            return isValid;\n        },\n\n        /**\n         * Disable and enable payment methods\n         * @private\n         */\n        _disablePaymentMethods: function () {\n            var tmpl = mageTemplate(this.options.tmpl, {\n                data: {}\n            });\n\n            this.element.find('input[name=\"payment[method]\"]').prop('disabled', true).end()\n                .find('input[id^=\"use\"][name^=\"payment[use\"]:not(:checked)').prop('disabled', true).parent().hide();\n            this.element.find('[name=\"payment[method]\"][value=\"free\"]').parent('dt').remove();\n            this.element.find(this.options.methodsContainer).hide().find('[name^=\"payment[\"]').prop('disabled', true);\n\n            $(tmpl).appendTo(this.element);\n        },\n\n        /**\n         * Enable and enable payment methods\n         * @private\n         */\n        _enablePaymentMethods: function () {\n            this.element.find('input[name=\"payment[method]\"]').prop('disabled', false).end()\n                .find('dt input:radio:checked').trigger('click').end()\n                .find('input[id^=\"use\"][name^=\"payment[use\"]:not(:checked)').prop('disabled', false).parent().show();\n            this.element.find(this.options.methodsContainer).show();\n        },\n\n        /**\n         * Returns checked payment method.\n         *\n         * @private\n         */\n        _getSelectedPaymentMethod: function () {\n            return this.element.find('input[name=\\'payment[method]\\']:checked');\n        },\n\n        /**\n         * Validate  before form submit\n         * @private\n         * @param {EventObject} e\n         */\n        _submitHandler: function (e) {\n            var currentMethod,\n                submitButton;\n\n            e.preventDefault();\n\n            if (this._validatePaymentMethod()) {\n                currentMethod = this._getSelectedPaymentMethod();\n                submitButton = currentMethod.parent().next('dd').find('button[type=submit]');\n\n                if (submitButton.length) {\n                    submitButton.first().trigger('click');\n                } else {\n                    this.element.trigger('submit');\n                }\n            }\n        }\n    });\n\n    return $.mage.payment;\n});\n","Magento_Multishipping/js/overview.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget',\n    'mage/translate'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.orderOverview', {\n        options: {\n            opacity: 0.5, // CSS opacity for the 'Place Order' button when it's clicked and then disabled.\n            pleaseWaitLoader: 'span.please-wait', // 'Submitting order information...' Ajax loader.\n            placeOrderSubmit: 'button[type=\"submit\"]', // The 'Place Order' button.\n            agreements: '.checkout-agreements' // Container for all of the checkout agreements and terms/conditions\n        },\n\n        /**\n         * Bind a submit handler to the form.\n         * @private\n         */\n        _create: function () {\n            this.element.on('submit', $.proxy(this._showLoader, this));\n        },\n\n        /**\n         * Verify that all agreements and terms/conditions are checked. Show the Ajax loader. Disable\n         * the submit button (i.e. Place Order).\n         * @return {Boolean}\n         * @private\n         */\n        _showLoader: function () {\n            if ($(this.options.agreements).find('input[type=\"checkbox\"]:not(:checked)').length > 0) {\n                return false;\n            }\n            this.element.find(this.options.pleaseWaitLoader).show().end()\n                .find(this.options.placeOrderSubmit).prop('disabled', true).css('opacity', this.options.opacity);\n\n            return true;\n        }\n    });\n\n    return $.mage.orderOverview;\n});\n","Magento_Multishipping/js/multi-shipping-balance.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/dataPost',\n    'jquery-ui-modules/widget'\n], function ($, dataPost) {\n    'use strict';\n\n    $.widget('mage.multiShippingBalance', {\n        options: {\n            changeUrl: ''\n        },\n\n        /**\n         * Initialize balance checkbox events.\n         *\n         * @private\n         */\n        _create: function () {\n            this.element.on('change', $.proxy(function (event) {\n                dataPost().postData({\n                    action: this.options.changeUrl,\n                    data: {\n                        useBalance: +$(event.target).is(':checked')\n                    }\n                });\n            }, this));\n        }\n    });\n\n    return $.mage.multiShippingBalance;\n});\n","Magento_GroupedProduct/js/product-ids-resolver.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_Catalog/js/product/view/product-ids',\n    'Magento_Catalog/js/product/view/product-info'\n], function ($, productIds, productInfo) {\n    'use strict';\n\n    /**\n     * Returns id's of products in form.\n     *\n     * @param {Object} config\n     * @param {HTMLElement} element\n     * @return {Array}\n     */\n    return function (config, element) {\n        $(element).find('div[data-product-id]').each(function () {\n            productIds.push($(this).data('productId').toString());\n            productInfo.push(\n                {\n                    'id': $(this).data('productId').toString()\n                }\n            );\n        });\n\n        return productIds();\n    };\n});\n","Magento_Payment/js/transparent.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\ndefine([\n    'jquery',\n    'mage/template',\n    'Magento_Ui/js/modal/alert',\n    'jquery-ui-modules/widget',\n    'Magento_Payment/js/model/credit-card-validation/validator',\n    'Magento_Checkout/js/model/full-screen-loader'\n], function ($, mageTemplate, alert, ui, validator, fullScreenLoader) {\n    'use strict';\n\n    $.widget('mage.transparent', {\n        options: {\n            context: null,\n            placeOrderSelector: '[data-role=\"review-save\"]',\n            paymentFormSelector: '#co-payment-form',\n            updateSelectorPrefix: '#checkout-',\n            updateSelectorSuffix: '-load',\n            hiddenFormTmpl:\n                '<form target=\"<%= data.target %>\" action=\"<%= data.action %>\" method=\"POST\" ' +\n                'hidden enctype=\"application/x-www-form-urlencoded\" class=\"no-display\">' +\n                    '<% _.each(data.inputs, function(val, key){ %>' +\n                    '<input value=\"<%= val %>\" name=\"<%= key %>\" type=\"hidden\">' +\n                    '<% }); %>' +\n                '</form>',\n            reviewAgreementForm: '#checkout-agreements',\n            cgiUrl: null,\n            orderSaveUrl: null,\n            controller: null,\n            gateway: null,\n            dateDelim: null,\n            cardFieldsMap: null,\n            expireYearLength: 2\n        },\n\n        /**\n         * {Function}\n         * @private\n         */\n        _create: function () {\n            this.hiddenFormTmpl = mageTemplate(this.options.hiddenFormTmpl);\n\n            if (this.options.context) {\n                this.options.context.setPlaceOrderHandler($.proxy(this._orderSave, this));\n                this.options.context.setValidateHandler($.proxy(this._validateHandler, this));\n            } else {\n                $(this.options.placeOrderSelector)\n                    .off('click')\n                    .on('click', $.proxy(this._placeOrderHandler, this));\n            }\n\n            this.element.validation();\n            $('[data-container=\"' + this.options.gateway + '-cc-number\"]').on('focusout', function () {\n                $(this).valid();\n            });\n        },\n\n        /**\n         * handler for credit card validation\n         * @return {Boolean}\n         * @private\n         */\n        _validateHandler: function () {\n            return this.element.validation && this.element.validation('isValid');\n        },\n\n        /**\n         * handler for Place Order button to call gateway for credit card validation\n         * @return {Boolean}\n         * @private\n         */\n        _placeOrderHandler: function () {\n            if (this._validateHandler()) {\n                this._orderSave();\n            }\n\n            return false;\n        },\n\n        /**\n         * Save order and generate post data for gateway call\n         * @private\n         */\n        _orderSave: function () {\n            var postData = $(this.options.paymentFormSelector).serialize();\n\n            if ($(this.options.reviewAgreementForm).length) {\n                postData += '&' + $(this.options.reviewAgreementForm).serialize();\n            }\n            postData += '&controller=' + this.options.controller;\n            postData += '&cc_type=' + this.element.find(\n                '[data-container=\"' + this.options.gateway + '-cc-type\"]'\n            ).val();\n\n            return $.ajax({\n                url: this.options.orderSaveUrl,\n                type: 'post',\n                context: this,\n                data: postData,\n                dataType: 'json',\n\n                /**\n                 * {Function}\n                 */\n                beforeSend: function () {\n                    fullScreenLoader.startLoader();\n                },\n\n                /**\n                 * {Function}\n                 */\n                success: function (response) {\n                    var preparedData,\n                        msg,\n\n                        /**\n                         * {Function}\n                         */\n                        alertActionHandler = function () {\n                            // default action\n                        };\n\n                    if (response.success && response[this.options.gateway]) {\n                        preparedData = this._preparePaymentData(\n                            response[this.options.gateway].fields,\n                            this.options.cardFieldsMap\n                        );\n                        this._postPaymentToGateway(preparedData);\n                    } else {\n                        fullScreenLoader.stopLoader(true);\n\n                        msg = response['error_messages'];\n\n                        if (this.options.context) {\n                            this.options.context.clearTimeout().fail();\n                            alertActionHandler = this.options.context.alertActionHandler;\n                        }\n\n                        if (typeof msg === 'object') {\n                            msg = msg.join('\\n');\n                        }\n\n                        if (msg) {\n                            alert(\n                                {\n                                    content: msg,\n                                    actions: {\n\n                                        /**\n                                         * {Function}\n                                         */\n                                        always: alertActionHandler\n                                    }\n                                }\n                            );\n                        }\n                    }\n                }.bind(this)\n            });\n        },\n\n        /**\n         * Post data to gateway for credit card validation\n         * @param {Object} data\n         * @private\n         */\n        _postPaymentToGateway: function (data) {\n            var tmpl,\n                iframeSelector = '[data-container=\"' + this.options.gateway + '-transparent-iframe\"]';\n\n            tmpl = this.hiddenFormTmpl({\n                data: {\n                    target: $(iframeSelector).attr('name'),\n                    action: this.options.cgiUrl,\n                    inputs: data\n                }\n            });\n            $(tmpl).appendTo($(iframeSelector)).trigger('submit');\n        },\n\n        /**\n         * Add credit card fields to post data for gateway\n         * @param {Object} data\n         * @param {Object} ccfields\n         * @private\n         */\n        _preparePaymentData: function (data, ccfields) {\n            var preparedata;\n\n            if (this.element.find('[data-container=\"' + this.options.gateway + '-cc-cvv\"]').length) {\n                data[ccfields.cccvv] = this.element.find(\n                    '[data-container=\"' + this.options.gateway + '-cc-cvv\"]'\n                ).val();\n            }\n            preparedata = this._prepareExpDate();\n            data[ccfields.ccexpdate] = preparedata.month + this.options.dateDelim + preparedata.year;\n            data[ccfields.ccnum] = this.element.find(\n                '[data-container=\"' + this.options.gateway + '-cc-number\"]'\n            ).val();\n\n            return data;\n        },\n\n        /**\n         * Grab Month and Year into one\n         * @returns {Object}\n         * @private\n         */\n        _prepareExpDate: function () {\n            var year = this.element.find('[data-container=\"' + this.options.gateway + '-cc-year\"]').val(),\n                month = parseInt(\n                    this.element.find('[data-container=\"' + this.options.gateway + '-cc-month\"]').val(),\n                    10\n                );\n\n            if (year.length > this.options.expireYearLength) {\n                year = year.substring(year.length - this.options.expireYearLength);\n            }\n\n            if (month < 10) {\n                month = '0' + month;\n            }\n\n            return {\n                month: month, year: year\n            };\n        }\n    });\n\n    return $.mage.transparent;\n});\n","Magento_Payment/js/cc-type.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.creditCardType', {\n        options: {\n            typeCodes: ['SS', 'SM', 'SO'] // Type codes for Switch/Maestro/Solo credit cards.\n        },\n\n        /**\n         * Bind change handler to select element and trigger the event to show/hide\n         * the Switch/Maestro or Solo credit card type container for those credit card types.\n         * @private\n         */\n        _create: function () {\n            this.element.on('change', $.proxy(this._toggleCardType, this)).trigger('change');\n        },\n\n        /**\n         * Toggle the Switch/Maestro and Solo credit card type container depending on which\n         * credit card type is selected.\n         * @private\n         */\n        _toggleCardType: function () {\n            $(this.options.creditCardTypeContainer)\n                .toggle($.inArray(this.element.val(), this.options.typeCodes) !== -1);\n        }\n    });\n\n    return $.mage.creditCardType;\n});\n","Magento_Payment/js/model/credit-card-validation/cvv-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\ndefine([], function () {\n    'use strict';\n\n    /**\n     * @param {*} isValid\n     * @param {*} isPotentiallyValid\n     * @return {Object}\n     */\n    function resultWrapper(isValid, isPotentiallyValid) {\n        return {\n            isValid: isValid,\n            isPotentiallyValid: isPotentiallyValid\n        };\n    }\n\n    /**\n     * CVV number validation.\n     * Validate digit count for CVV code.\n     *\n     * @param {*} value\n     * @param {Number} maxLength\n     * @return {Object}\n     */\n    return function (value, maxLength) {\n        var DEFAULT_LENGTH = 3;\n\n        maxLength = maxLength || DEFAULT_LENGTH;\n\n        if (!/^\\d*$/.test(value)) {\n            return resultWrapper(false, false);\n        }\n\n        if (value.length === maxLength) {\n            return resultWrapper(true, true);\n        }\n\n        if (value.length < maxLength) {\n            return resultWrapper(false, true);\n        }\n\n        if (value.length > maxLength) {\n            return resultWrapper(false, false);\n        }\n    };\n});\n","Magento_Payment/js/model/credit-card-validation/expiration-date-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\ndefine([\n    'mageUtils',\n    'Magento_Payment/js/model/credit-card-validation/expiration-date-validator/parse-date',\n    'Magento_Payment/js/model/credit-card-validation/expiration-date-validator/expiration-month-validator',\n    'Magento_Payment/js/model/credit-card-validation/expiration-date-validator/expiration-year-validator'\n], function (utils, parseDate, expirationMonth, expirationYear) {\n    'use strict';\n\n    /**\n     * @param {*} isValid\n     * @param {*} isPotentiallyValid\n     * @param {*} month\n     * @param {*} year\n     * @return {Object}\n     */\n    function resultWrapper(isValid, isPotentiallyValid, month, year) {\n        return {\n            isValid: isValid,\n            isPotentiallyValid: isPotentiallyValid,\n            month: month,\n            year: year\n        };\n    }\n\n    return function (value) {\n        var date,\n            monthValid,\n            yearValid;\n\n        if (utils.isEmpty(value)) {\n            return resultWrapper(false, false, null, null);\n        }\n\n        value = value.replace(/^(\\d\\d) (\\d\\d(\\d\\d)?)$/, '$1/$2');\n        date = parseDate(value);\n        monthValid = expirationMonth(date.month);\n        yearValid = expirationYear(date.year);\n\n        if (monthValid.isValid && yearValid.isValid) {\n            return resultWrapper(true, true, date.month, date.year);\n        }\n\n        if (monthValid.isPotentiallyValid && yearValid.isPotentiallyValid) {\n            return resultWrapper(false, true, null, null);\n        }\n\n        return resultWrapper(false, false, null, null);\n    };\n});\n","Magento_Payment/js/model/credit-card-validation/credit-card-number-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\ndefine([\n    'mageUtils',\n    'Magento_Payment/js/model/credit-card-validation/credit-card-number-validator/luhn10-validator',\n    'Magento_Payment/js/model/credit-card-validation/credit-card-number-validator/credit-card-type'\n], function (utils, luhn10, creditCardTypes) {\n    'use strict';\n\n    /**\n     * @param {*} card\n     * @param {*} isPotentiallyValid\n     * @param {*} isValid\n     * @return {Object}\n     */\n    function resultWrapper(card, isPotentiallyValid, isValid) {\n        return {\n            card: card,\n            isValid: isValid,\n            isPotentiallyValid: isPotentiallyValid\n        };\n    }\n\n    return function (value) {\n        var potentialTypes,\n            cardType,\n            valid,\n            i,\n            maxLength;\n\n        if (utils.isEmpty(value)) {\n            return resultWrapper(null, false, false);\n        }\n\n        value = value.replace(/\\s+/g, '');\n\n        if (!/^\\d*$/.test(value)) {\n            return resultWrapper(null, false, false);\n        }\n\n        potentialTypes = creditCardTypes.getCardTypes(value);\n\n        if (potentialTypes.length === 0) {\n            return resultWrapper(null, false, false);\n        } else if (potentialTypes.length !== 1) {\n            return resultWrapper(null, true, false);\n        }\n\n        cardType = potentialTypes[0];\n\n        if (cardType.type === 'unionpay') {  // UnionPay is not Luhn 10 compliant\n            valid = true;\n        } else {\n            valid = luhn10(value);\n        }\n\n        for (i = 0; i < cardType.lengths.length; i++) {\n            if (cardType.lengths[i] === value.length) {\n                return resultWrapper(cardType, valid, valid);\n            }\n        }\n\n        maxLength = Math.max.apply(null, cardType.lengths);\n\n        if (value.length < maxLength) {\n            return resultWrapper(cardType, true, false);\n        }\n\n        return resultWrapper(cardType, false, false);\n    };\n});\n","Magento_Payment/js/model/credit-card-validation/validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\ndefine([\n    'jquery',\n    'Magento_Payment/js/model/credit-card-validation/cvv-validator',\n    'Magento_Payment/js/model/credit-card-validation/credit-card-number-validator',\n    'Magento_Payment/js/model/credit-card-validation/expiration-date-validator/expiration-year-validator',\n    'Magento_Payment/js/model/credit-card-validation/expiration-date-validator/expiration-month-validator',\n    'Magento_Payment/js/model/credit-card-validation/credit-card-data',\n    'mage/translate'\n], function ($, cvvValidator, creditCardNumberValidator, yearValidator, monthValidator, creditCardData) {\n    'use strict';\n\n    $('.payment-method-content input[type=\"number\"]').on('keyup', function () {\n        if ($(this).val() < 0) {\n            $(this).val($(this).val().replace(/^-/, ''));\n        }\n    });\n\n    $.each({\n        'validate-card-type': [\n            function (number, item, allowedTypes) {\n                var cardInfo,\n                    i,\n                    l;\n\n                if (!creditCardNumberValidator(number).isValid) {\n                    return false;\n                }\n\n                cardInfo = creditCardNumberValidator(number).card;\n\n                for (i = 0, l = allowedTypes.length; i < l; i++) {\n                    if (cardInfo.title == allowedTypes[i].type) { //eslint-disable-line eqeqeq\n                        return true;\n                    }\n                }\n\n                return false;\n            },\n            $.mage.__('Please enter a valid credit card type number.')\n        ],\n        'validate-card-number': [\n\n            /**\n             * Validate credit card number based on mod 10\n             *\n             * @param {*} number - credit card number\n             * @return {Boolean}\n             */\n            function (number) {\n                return creditCardNumberValidator(number).isValid;\n            },\n            $.mage.__('Please enter a valid credit card number.')\n        ],\n        'validate-card-date': [\n\n            /**\n             * Validate credit card expiration month\n             *\n             * @param {String} date - month\n             * @return {Boolean}\n             */\n            function (date) {\n                return monthValidator(date).isValid;\n            },\n            $.mage.__('Incorrect credit card expiration month.')\n        ],\n        'validate-card-cvv': [\n\n            /**\n             * Validate cvv\n             *\n             * @param {String} cvv - card verification value\n             * @return {Boolean}\n             */\n            function (cvv) {\n                var maxLength = creditCardData.creditCard ? creditCardData.creditCard.code.size : 3;\n\n                return cvvValidator(cvv, maxLength).isValid;\n            },\n            $.mage.__('Please enter a valid credit card verification number.')\n        ],\n        'validate-card-year': [\n\n            /**\n             * Validate credit card expiration year\n             *\n             * @param {String} date - year\n             * @return {Boolean}\n             */\n            function (date) {\n                return yearValidator(date).isValid;\n            },\n            $.mage.__('Incorrect credit card expiration year.')\n        ]\n\n    }, function (i, rule) {\n        rule.unshift(i);\n        $.validator.addMethod.apply($.validator, rule);\n    });\n});\n","Magento_Payment/js/model/credit-card-validation/credit-card-data.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\ndefine([], function () {\n    'use strict';\n\n    return {\n        creditCard: null,\n        creditCardNumber: null,\n        expirationMonth: null,\n        expirationYear: null,\n        cvvCode: null\n    };\n});\n","Magento_Payment/js/model/credit-card-validation/expiration-date-validator/expiration-month-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    /**\n     * @param {*} isValid\n     * @param {*} isPotentiallyValid\n     * @return {Object}\n     */\n    function resultWrapper(isValid, isPotentiallyValid) {\n        return {\n            isValid: isValid,\n            isPotentiallyValid: isPotentiallyValid\n        };\n    }\n\n    return function (value) {\n        var month,\n            monthValid;\n\n        if (value.replace(/\\s/g, '') === '' || value === '0') {\n            return resultWrapper(false, true);\n        }\n\n        if (!/^\\d*$/.test(value)) {\n            return resultWrapper(false, false);\n        }\n\n        if (isNaN(value)) {\n            return resultWrapper(false, false);\n        }\n\n        month = parseInt(value, 10);\n        monthValid = month > 0 && month < 13;\n\n        return resultWrapper(monthValid, monthValid);\n    };\n});\n","Magento_Payment/js/model/credit-card-validation/expiration-date-validator/parse-date.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return function (value) {\n        var month, len;\n\n        if (value.match('/')) {\n            value = value.split(/\\s*\\/\\s*/g);\n\n            return {\n                month: value[0],\n                year: value.slice(1).join()\n            };\n        }\n\n        len = value[0] === '0' || value.length > 5 || value.length === 4 || value.length === 3 ? 2 : 1;\n        month = value.substr(0, len);\n\n        return {\n            month: month,\n            year: value.substr(month.length, 4)\n        };\n    };\n});\n","Magento_Payment/js/model/credit-card-validation/expiration-date-validator/expiration-year-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    /**\n     * @param {*} isValid\n     * @param {*} isPotentiallyValid\n     * @return {Object}\n     */\n    function resultWrapper(isValid, isPotentiallyValid) {\n        return {\n            isValid: isValid,\n            isPotentiallyValid: isPotentiallyValid\n        };\n    }\n\n    return function (value) {\n        var currentYear = new Date().getFullYear(),\n            len = value.length,\n            valid,\n            expMaxLifetime = 19;\n\n        if (value.replace(/\\s/g, '') === '') {\n            return resultWrapper(false, true);\n        }\n\n        if (!/^\\d*$/.test(value)) {\n            return resultWrapper(false, false);\n        }\n\n        if (len !== 4) {\n            return resultWrapper(false, true);\n        }\n\n        value = parseInt(value, 10);\n        valid = value >= currentYear && value <= currentYear + expMaxLifetime;\n\n        return resultWrapper(valid, valid);\n    };\n});\n","Magento_Payment/js/model/credit-card-validation/credit-card-number-validator/luhn10-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    /**\n     * Luhn algorithm verification\n     */\n    return function (a, b, c, d, e) {\n        for (d = +a[b = a.length - 1], e = 0; b--;) {\n            c = +a[b];\n            d += ++e % 2 ? 2 * c % 10 + (c > 4) : c;\n        }\n\n        return !(d % 10);\n    };\n});\n","Magento_Payment/js/model/credit-card-validation/credit-card-number-validator/credit-card-type.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\ndefine([\n    'jquery',\n    'mageUtils'\n], function ($, utils) {\n    'use strict';\n\n    var types = [\n        {\n            title: 'Visa',\n            type: 'VI',\n            pattern: '^4\\\\d*$',\n            gaps: [4, 8, 12],\n            lengths: [16],\n            code: {\n                name: 'CVV',\n                size: 3\n            }\n        },\n        {\n            title: 'MasterCard',\n            type: 'MC',\n            pattern: '^(?:5[1-5][0-9]{2}|222[1-9]|22[3-9][0-9]|2[3-6][0-9]{2}|27[01][0-9]|2720)[0-9]{12}$',\n            gaps: [4, 8, 12],\n            lengths: [16],\n            code: {\n                name: 'CVC',\n                size: 3\n            }\n        },\n        {\n            title: 'American Express',\n            type: 'AE',\n            pattern: '^3([47]\\\\d*)?$',\n            isAmex: true,\n            gaps: [4, 10],\n            lengths: [15],\n            code: {\n                name: 'CID',\n                size: 4\n            }\n        },\n        {\n            title: 'Diners',\n            type: 'DN',\n            pattern: '^(3(0[0-5]|095|6|[8-9]))\\\\d*$',\n            gaps: [4, 10],\n            lengths: [14, 16, 17, 18, 19],\n            code: {\n                name: 'CVV',\n                size: 3\n            }\n        },\n        {\n            title: 'Discover',\n            type: 'DI',\n            pattern: '^(6011(0|[2-4]|74|7[7-9]|8[6-9]|9)|6(4[4-9]|5))\\\\d*$',\n            gaps: [4, 8, 12],\n            lengths: [16, 17, 18, 19],\n            code: {\n                name: 'CID',\n                size: 3\n            }\n        },\n        {\n            title: 'JCB',\n            type: 'JCB',\n            pattern: '^35(2[8-9]|[3-8])\\\\d*$',\n            gaps: [4, 8, 12],\n            lengths: [16, 17, 18, 19],\n            code: {\n                name: 'CVV',\n                size: 3\n            }\n        },\n        {\n            title: 'UnionPay',\n            type: 'UN',\n            pattern: '^(622(1(2[6-9]|[3-9])|[3-8]|9([[0-1]|2[0-5]))|62[4-6]|628([2-8]))\\\\d*?$',\n            gaps: [4, 8, 12],\n            lengths: [16, 17, 18, 19],\n            code: {\n                name: 'CVN',\n                size: 3\n            }\n        },\n        {\n            title: 'Maestro International',\n            type: 'MI',\n            pattern: '^(5(0|[6-9])|63|67(?!59|6770|6774))\\\\d*$',\n            gaps: [4, 8, 12],\n            lengths: [12, 13, 14, 15, 16, 17, 18, 19],\n            code: {\n                name: 'CVC',\n                size: 3\n            }\n        },\n        {\n            title: 'Maestro Domestic',\n            type: 'MD',\n            pattern: '^6759(?!24|38|40|6[3-9]|70|76)|676770|676774\\\\d*$',\n            gaps: [4, 8, 12],\n            lengths: [12, 13, 14, 15, 16, 17, 18, 19],\n            code: {\n                name: 'CVC',\n                size: 3\n            }\n        },\n        {\n            title: 'Hipercard',\n            type: 'HC',\n            pattern: '^((606282)|(637095)|(637568)|(637599)|(637609)|(637612))\\\\d*$',\n            gaps: [4, 8, 12],\n            lengths: [13, 16],\n            code: {\n                name: 'CVC',\n                size: 3\n            }\n        },\n        {\n            title: 'Elo',\n            type: 'ELO',\n            pattern: '^((509091)|(636368)|(636297)|(504175)|(438935)|(40117[8-9])|(45763[1-2])|' +\n                '(457393)|(431274)|(50990[0-2])|(5099[7-9][0-9])|(50996[4-9])|(509[1-8][0-9][0-9])|' +\n                '(5090(0[0-2]|0[4-9]|1[2-9]|[24589][0-9]|3[1-9]|6[0-46-9]|7[0-24-9]))|' +\n                '(5067(0[0-24-8]|1[0-24-9]|2[014-9]|3[0-379]|4[0-9]|5[0-3]|6[0-5]|7[0-8]))|' +\n                '(6504(0[5-9]|1[0-9]|2[0-9]|3[0-9]))|' +\n                '(6504(8[5-9]|9[0-9])|6505(0[0-9]|1[0-9]|2[0-9]|3[0-8]))|' +\n                '(6505(4[1-9]|5[0-9]|6[0-9]|7[0-9]|8[0-9]|9[0-8]))|' +\n                '(6507(0[0-9]|1[0-8]))|(65072[0-7])|(6509(0[1-9]|1[0-9]|20))|' +\n                '(6516(5[2-9]|6[0-9]|7[0-9]))|(6550(0[0-9]|1[0-9]))|' +\n                '(6550(2[1-9]|3[0-9]|4[0-9]|5[0-8])))\\\\d*$',\n            gaps: [4, 8, 12],\n            lengths: [16],\n            code: {\n                name: 'CVC',\n                size: 3\n            }\n        },\n        {\n            title: 'Aura',\n            type: 'AU',\n            pattern: '^5078\\\\d*$',\n            gaps: [4, 8, 12],\n            lengths: [19],\n            code: {\n                name: 'CVC',\n                size: 3\n            }\n        }\n    ];\n\n    return {\n        /**\n         * @param {*} cardNumber\n         * @return {Array}\n         */\n        getCardTypes: function (cardNumber) {\n            var i, value,\n                result = [];\n\n            if (utils.isEmpty(cardNumber)) {\n                return result;\n            }\n\n            if (cardNumber === '') {\n                return $.extend(true, {}, types);\n            }\n\n            for (i = 0; i < types.length; i++) {\n                value = types[i];\n\n                if (new RegExp(value.pattern).test(cardNumber)) {\n                    result.push($.extend(true, {}, value));\n                }\n            }\n\n            return result;\n        }\n    };\n});\n","Magento_Payment/js/view/payment/iframe.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\ndefine([\n    'jquery',\n    'Magento_Payment/js/view/payment/cc-form',\n    'Magento_Ui/js/model/messageList',\n    'mage/translate',\n    'Magento_Checkout/js/model/full-screen-loader',\n    'Magento_Checkout/js/action/set-payment-information',\n    'Magento_Checkout/js/model/payment/additional-validators',\n    'Magento_Ui/js/modal/alert'\n], function (\n    $,\n    Component,\n    messageList,\n    $t,\n    fullScreenLoader,\n    setPaymentInformationAction,\n    additionalValidators,\n    alert\n) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Payment/payment/iframe',\n            timeoutId: null,\n            timeoutMessage: 'Sorry, but something went wrong.'\n        },\n\n        /**\n         * @returns {String}\n         */\n        getSource: function () {\n            return window.checkoutConfig.payment.iframe.source[this.getCode()];\n        },\n\n        /**\n         * @returns {String}\n         */\n        getControllerName: function () {\n            return window.checkoutConfig.payment.iframe.controllerName[this.getCode()];\n        },\n\n        /**\n         * @returns {String}\n         */\n        getPlaceOrderUrl: function () {\n            return window.checkoutConfig.payment.iframe.placeOrderUrl[this.getCode()];\n        },\n\n        /**\n         * @returns {String}\n         */\n        getCgiUrl: function () {\n            return window.checkoutConfig.payment.iframe.cgiUrl[this.getCode()];\n        },\n\n        /**\n         * @returns {String}\n         */\n        getSaveOrderUrl: function () {\n            return window.checkoutConfig.payment.iframe.saveOrderUrl[this.getCode()];\n        },\n\n        /**\n         * @returns {String}\n         */\n        getDateDelim: function () {\n            return window.checkoutConfig.payment.iframe.dateDelim[this.getCode()];\n        },\n\n        /**\n         * @returns {String}\n         */\n        getCardFieldsMap: function () {\n            return window.checkoutConfig.payment.iframe.cardFieldsMap[this.getCode()];\n        },\n\n        /**\n         * @returns {String}\n         */\n        getExpireYearLength: function () {\n            return window.checkoutConfig.payment.iframe.expireYearLength[this.getCode()];\n        },\n\n        /**\n         * @param {Object} parent\n         * @returns {Function}\n         */\n        originalPlaceOrder: function (parent) {\n            return parent.placeOrder.bind(parent);\n        },\n\n        /**\n         * @returns {Number}\n         */\n        getTimeoutTime: function () {\n            return window.checkoutConfig.payment.iframe.timeoutTime[this.getCode()];\n        },\n\n        /**\n         * @returns {String}\n         */\n        getTimeoutMessage: function () {\n            return $t(this.timeoutMessage);\n        },\n\n        /**\n         * @override\n         */\n        placeOrder: function () {\n            var self = this;\n\n            if (this.validateHandler() &&\n                additionalValidators.validate() &&\n                this.isPlaceOrderActionAllowed() === true\n            ) {\n                fullScreenLoader.startLoader();\n\n                this.isPlaceOrderActionAllowed(false);\n\n                $.when(\n                    this.setPaymentInformation()\n                ).done(\n                    this.done.bind(this)\n                ).fail(\n                    this.fail.bind(this)\n                ).always(\n                    function () {\n                        self.isPlaceOrderActionAllowed(true);\n                    }\n                );\n\n                this.initTimeoutHandler();\n            }\n        },\n\n        /**\n         * {Function}\n         */\n        setPaymentInformation: function () {\n            return setPaymentInformationAction(\n                this.messageContainer,\n                {\n                    method: this.getCode()\n                }\n            );\n        },\n\n        /**\n         * {Function}\n         */\n        initTimeoutHandler: function () {\n            this.timeoutId = setTimeout(\n                this.timeoutHandler.bind(this),\n                this.getTimeoutTime()\n            );\n\n            $(window).off('clearTimeout')\n                .on('clearTimeout', this.clearTimeout.bind(this));\n        },\n\n        /**\n         * {Function}\n         */\n        clearTimeout: function () {\n            clearTimeout(this.timeoutId);\n            this.fail();\n\n            return this;\n        },\n\n        /**\n         * {Function}\n         */\n        timeoutHandler: function () {\n            this.clearTimeout();\n\n            alert(\n                {\n                    content: this.getTimeoutMessage(),\n                    actions: {\n\n                        /**\n                         * {Function}\n                         */\n                        always: this.alertActionHandler.bind(this)\n                    }\n                }\n            );\n\n            this.fail();\n        },\n\n        /**\n         * {Function}\n         */\n        alertActionHandler: function () {\n            fullScreenLoader.startLoader();\n            window.location.reload();\n        },\n\n        /**\n         * {Function}\n         */\n        fail: function () {\n            fullScreenLoader.stopLoader();\n\n            return this;\n        },\n\n        /**\n         * {Function}\n         */\n        done: function () {\n            this.placeOrderHandler().fail(function () {\n                fullScreenLoader.stopLoader();\n            });\n\n            return this;\n        }\n    });\n});\n","Magento_Payment/js/view/payment/payments.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\ndefine([\n    'uiComponent',\n    'Magento_Checkout/js/model/payment/renderer-list'\n], function (Component, rendererList) {\n    'use strict';\n\n    rendererList.push(\n        {\n            type: 'free',\n            component: 'Magento_Payment/js/view/payment/method-renderer/free-method'\n        }\n    );\n\n    /** Add view logic here if needed */\n    return Component.extend({});\n});\n","Magento_Payment/js/view/payment/cc-form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\ndefine([\n    'underscore',\n    'Magento_Checkout/js/view/payment/default',\n    'Magento_Payment/js/model/credit-card-validation/credit-card-data',\n    'Magento_Payment/js/model/credit-card-validation/credit-card-number-validator',\n    'mage/translate'\n], function (_, Component, creditCardData, cardNumberValidator, $t) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            creditCardType: '',\n            creditCardExpYear: '',\n            creditCardExpMonth: '',\n            creditCardNumber: '',\n            creditCardSsStartMonth: '',\n            creditCardSsStartYear: '',\n            creditCardSsIssue: '',\n            creditCardVerificationNumber: '',\n            selectedCardType: null\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'creditCardType',\n                    'creditCardExpYear',\n                    'creditCardExpMonth',\n                    'creditCardNumber',\n                    'creditCardVerificationNumber',\n                    'creditCardSsStartMonth',\n                    'creditCardSsStartYear',\n                    'creditCardSsIssue',\n                    'selectedCardType'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Init component\n         */\n        initialize: function () {\n            var self = this;\n\n            this._super();\n\n            //Set credit card number to credit card data object\n            this.creditCardNumber.subscribe(function (value) {\n                var result;\n\n                self.selectedCardType(null);\n\n                if (value === '' || value === null) {\n                    return false;\n                }\n                result = cardNumberValidator(value);\n\n                if (!result.isPotentiallyValid && !result.isValid) {\n                    return false;\n                }\n\n                if (result.card !== null) {\n                    self.selectedCardType(result.card.type);\n                    creditCardData.creditCard = result.card;\n                }\n\n                if (result.isValid) {\n                    creditCardData.creditCardNumber = value;\n                    self.creditCardType(result.card.type);\n                }\n            });\n\n            //Set expiration year to credit card data object\n            this.creditCardExpYear.subscribe(function (value) {\n                creditCardData.expirationYear = value;\n            });\n\n            //Set expiration month to credit card data object\n            this.creditCardExpMonth.subscribe(function (value) {\n                creditCardData.expirationMonth = value;\n            });\n\n            //Set cvv code to credit card data object\n            this.creditCardVerificationNumber.subscribe(function (value) {\n                creditCardData.cvvCode = value;\n            });\n        },\n\n        /**\n         * Get code\n         * @returns {String}\n         */\n        getCode: function () {\n            return 'cc';\n        },\n\n        /**\n         * Get data\n         * @returns {Object}\n         */\n        getData: function () {\n            return {\n                'method': this.item.method,\n                'additional_data': {\n                    'cc_cid': this.creditCardVerificationNumber(),\n                    'cc_ss_start_month': this.creditCardSsStartMonth(),\n                    'cc_ss_start_year': this.creditCardSsStartYear(),\n                    'cc_ss_issue': this.creditCardSsIssue(),\n                    'cc_type': this.creditCardType(),\n                    'cc_exp_year': this.creditCardExpYear(),\n                    'cc_exp_month': this.creditCardExpMonth(),\n                    'cc_number': this.creditCardNumber()\n                }\n            };\n        },\n\n        /**\n         * Get list of available credit card types\n         * @returns {Object}\n         */\n        getCcAvailableTypes: function () {\n            return window.checkoutConfig.payment.ccform.availableTypes[this.getCode()];\n        },\n\n        /**\n         * Get payment icons\n         * @param {String} type\n         * @returns {Boolean}\n         */\n        getIcons: function (type) {\n            return window.checkoutConfig.payment.ccform.icons.hasOwnProperty(type) ?\n                window.checkoutConfig.payment.ccform.icons[type]\n                : false;\n        },\n\n        /**\n         * Get list of months\n         * @returns {Object}\n         */\n        getCcMonths: function () {\n            return window.checkoutConfig.payment.ccform.months[this.getCode()];\n        },\n\n        /**\n         * Get list of years\n         * @returns {Object}\n         */\n        getCcYears: function () {\n            return window.checkoutConfig.payment.ccform.years[this.getCode()];\n        },\n\n        /**\n         * Check if current payment has verification\n         * @returns {Boolean}\n         */\n        hasVerification: function () {\n            return window.checkoutConfig.payment.ccform.hasVerification[this.getCode()];\n        },\n\n        /**\n         * @deprecated\n         * @returns {Boolean}\n         */\n        hasSsCardType: function () {\n            return window.checkoutConfig.payment.ccform.hasSsCardType[this.getCode()];\n        },\n\n        /**\n         * Get image url for CVV\n         * @returns {String}\n         */\n        getCvvImageUrl: function () {\n            return window.checkoutConfig.payment.ccform.cvvImageUrl[this.getCode()];\n        },\n\n        /**\n         * Get image for CVV\n         * @returns {String}\n         */\n        getCvvImageHtml: function () {\n            return '<img src=\"' + this.getCvvImageUrl() +\n                '\" alt=\"' + $t('Card Verification Number Visual Reference') +\n                '\" title=\"' + $t('Card Verification Number Visual Reference') +\n                '\" />';\n        },\n\n        /**\n         * Get unsanitized html for image for CVV\n         * @returns {String}\n         */\n        getCvvImageUnsanitizedHtml: function () {\n            return this.getCvvImageHtml();\n        },\n\n        /**\n         * @deprecated\n         * @returns {Object}\n         */\n        getSsStartYears: function () {\n            return window.checkoutConfig.payment.ccform.ssStartYears[this.getCode()];\n        },\n\n        /**\n         * Get list of available credit card types values\n         * @returns {Object}\n         */\n        getCcAvailableTypesValues: function () {\n            return _.map(this.getCcAvailableTypes(), function (value, key) {\n                return {\n                    'value': key,\n                    'type': value\n                };\n            });\n        },\n\n        /**\n         * Get list of available month values\n         * @returns {Object}\n         */\n        getCcMonthsValues: function () {\n            return _.map(this.getCcMonths(), function (value, key) {\n                return {\n                    'value': key,\n                    'month': value\n                };\n            });\n        },\n\n        /**\n         * Get list of available year values\n         * @returns {Object}\n         */\n        getCcYearsValues: function () {\n            return _.map(this.getCcYears(), function (value, key) {\n                return {\n                    'value': key,\n                    'year': value\n                };\n            });\n        },\n\n        /**\n         * @deprecated\n         * @returns {Object}\n         */\n        getSsStartYearsValues: function () {\n            return _.map(this.getSsStartYears(), function (value, key) {\n                return {\n                    'value': key,\n                    'year': value\n                };\n            });\n        },\n\n        /**\n         * Is legend available to display\n         * @returns {Boolean}\n         */\n        isShowLegend: function () {\n            return false;\n        },\n\n        /**\n         * Get available credit card type by code\n         * @param {String} code\n         * @returns {String}\n         */\n        getCcTypeTitleByCode: function (code) {\n            var title = '',\n                keyValue = 'value',\n                keyType = 'type';\n\n            _.each(this.getCcAvailableTypesValues(), function (value) {\n                if (value[keyValue] === code) {\n                    title = value[keyType];\n                }\n            });\n\n            return title;\n        },\n\n        /**\n         * Prepare credit card number to output\n         * @param {String} number\n         * @returns {String}\n         */\n        formatDisplayCcNumber: function (number) {\n            return 'xxxx-' + number.substr(-4);\n        },\n\n        /**\n         * Get credit card details\n         * @returns {Array}\n         */\n        getInfo: function () {\n            return [\n                {\n                    'name': 'Credit Card Type', value: this.getCcTypeTitleByCode(this.creditCardType())\n                },\n                {\n                    'name': 'Credit Card Number', value: this.formatDisplayCcNumber(this.creditCardNumber())\n                }\n            ];\n        }\n    });\n});\n","Magento_Payment/js/view/payment/method-renderer/free-method.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\ndefine([\n    'Magento_Checkout/js/view/payment/default',\n    'Magento_Checkout/js/model/quote'\n], function (Component, quote) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Payment/payment/free'\n        },\n\n        /** Returns is method available */\n        isAvailable: function () {\n            return quote.totals()['grand_total'] <= 0;\n        }\n    });\n});\n","Magento_InstantPurchase/js/view/instant-purchase.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'jquery',\n    'underscore',\n    'uiComponent',\n    'Magento_Ui/js/modal/confirm',\n    'Magento_Customer/js/customer-data',\n    'mage/url',\n    'mage/template',\n    'mage/translate',\n    'text!Magento_InstantPurchase/template/confirmation.html',\n    'mage/validation'\n], function (ko, $, _, Component, confirm, customerData, urlBuilder, mageTemplate, $t, confirmationTemplate) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_InstantPurchase/instant-purchase',\n            buttonText: $t('Instant Purchase'),\n            purchaseUrl: urlBuilder.build('instantpurchase/button/placeOrder'),\n            showButton: false,\n            paymentToken: null,\n            shippingAddress: null,\n            billingAddress: null,\n            shippingMethod: null,\n            productFormSelector: '#product_addtocart_form',\n            confirmationTitle: $t('Instant Purchase Confirmation'),\n            confirmationData: {\n                message: $t('Are you sure you want to place order and pay?'),\n                shippingAddressTitle: $t('Shipping Address'),\n                billingAddressTitle: $t('Billing Address'),\n                paymentMethodTitle: $t('Payment Method'),\n                shippingMethodTitle: $t('Shipping Method')\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            var instantPurchase = customerData.get('instant-purchase');\n\n            this._super();\n\n            this.setPurchaseData(instantPurchase());\n            instantPurchase.subscribe(this.setPurchaseData, this);\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super()\n                .observe('showButton paymentToken shippingAddress billingAddress shippingMethod');\n\n            return this;\n        },\n\n        /**\n         * Set data from customerData.\n         *\n         * @param {Object} data\n         */\n        setPurchaseData: function (data) {\n            this.showButton(data.available);\n            this.paymentToken(data.paymentToken);\n            this.shippingAddress(data.shippingAddress);\n            this.billingAddress(data.billingAddress);\n            this.shippingMethod(data.shippingMethod);\n        },\n\n        /**\n         * Confirmation method\n         */\n        instantPurchase: function () {\n            var form = $(this.productFormSelector),\n                confirmTemplate = mageTemplate(confirmationTemplate),\n                confirmData = _.extend({}, this.confirmationData, {\n                    paymentToken: this.paymentToken().summary,\n                    shippingAddress: this.shippingAddress().summary,\n                    billingAddress: this.billingAddress().summary,\n                    shippingMethod: this.shippingMethod().summary\n                });\n\n            if (!(form.validation() && form.validation('isValid'))) {\n                return;\n            }\n\n            confirm({\n                title: this.confirmationTitle,\n                content: confirmTemplate({\n                    data: confirmData\n                }),\n                actions: {\n                    /** @inheritdoc */\n                    confirm: function () {\n                        $.ajax({\n                            url: this.purchaseUrl,\n                            data: form.serialize(),\n                            type: 'post',\n                            dataType: 'json',\n\n                            /** Show loader before send */\n                            beforeSend: function () {\n                                $('body').trigger('processStart');\n                            }\n                        }).always(function () {\n                            $('body').trigger('processStop');\n                        });\n                    }.bind(this)\n                }\n            });\n        }\n    });\n});\n","Magento_SalesRule/js/form/element/manage-coupon-codes.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'uiRegistry',\n    'Magento_Ui/js/form/components/fieldset',\n    'Magento_Ui/js/lib/view/utils/async'\n], function (_, uiRegistry, fieldset, async) {\n    'use strict';\n\n    return fieldset.extend({\n\n        /*eslint-disable no-unused-vars*/\n        /**\n         * Initialize element\n         *\n         * @returns {Abstract} Chainable\n         */\n        initialize: function (elems, position) {\n            var obj = this;\n\n            this._super();\n\n            async.async('#sales-rule-form-tab-coupons', document.getElementById('container'), function (node) {\n                var useAutoGeneration = uiRegistry.get(\n                    'sales_rule_form.sales_rule_form.rule_information.use_auto_generation'\n                );\n\n                useAutoGeneration.on('checked', function () {\n                    obj.enableDisableFields();\n                });\n                obj.enableDisableFields();\n            });\n\n            return this;\n        },\n\n        /*eslint-enable no-unused-vars*/\n        /*eslint-disable lines-around-comment*/\n\n        /**\n         * Enable/disable fields on Coupons tab\n         */\n        enableDisableFields: function () {\n            var selector,\n                isUseAutoGenerationChecked,\n                couponType,\n                disableAuto;\n\n            selector = '[id=sales-rule-form-tab-coupons] input, [id=sales-rule-form-tab-coupons] select, ' +\n                    '[id=sales-rule-form-tab-coupons] button';\n            isUseAutoGenerationChecked = uiRegistry\n                    .get('sales_rule_form.sales_rule_form.rule_information.use_auto_generation')\n                    .checked();\n            couponType = uiRegistry\n                .get('sales_rule_form.sales_rule_form.rule_information.coupon_type')\n                .value();\n            /**\n             * \\Magento\\Rule\\Model\\AbstractModel::COUPON_TYPE_AUTO\n             */\n            disableAuto = couponType === 3 || isUseAutoGenerationChecked;\n            _.each(\n                document.querySelectorAll(selector),\n                function (element) {\n                    element.disabled = !disableAuto;\n                }\n            );\n        }\n    });\n});\n","Magento_SalesRule/js/form/element/coupon-type.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'uiRegistry',\n    'Magento_Ui/js/form/element/select'\n], function (_, uiRegistry, select) {\n    'use strict';\n\n    return select.extend({\n\n        /**\n         * Hide fields on coupon tab\n         */\n        onUpdate: function () {\n\n            /* eslint-disable eqeqeq */\n            if (this.value() != this.displayOnlyForCouponType) {\n                uiRegistry.get('sales_rule_form.sales_rule_form.rule_information.use_auto_generation').checked(false);\n            }\n\n            this.enableDisableFields();\n        },\n\n        /**\n         * Enable/disable fields on Coupons tab\n         */\n        enableDisableFields: function () {\n            var selector,\n                isUseAutoGenerationChecked,\n                couponType,\n                disableAuto;\n\n            selector = '[id=sales-rule-form-tab-coupons] input, [id=sales-rule-form-tab-coupons] select, ' +\n                    '[id=sales-rule-form-tab-coupons] button';\n            isUseAutoGenerationChecked = uiRegistry\n                    .get('sales_rule_form.sales_rule_form.rule_information.use_auto_generation')\n                    .checked();\n            couponType = uiRegistry\n                .get('sales_rule_form.sales_rule_form.rule_information.coupon_type')\n                .value();\n            disableAuto = couponType === 3 || isUseAutoGenerationChecked;\n            _.each(\n                document.querySelectorAll(selector),\n                function (element) {\n                    element.disabled = !disableAuto;\n                }\n            );\n        }\n    });\n});\n","Magento_SalesRule/js/action/cancel-coupon.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * Customer store credit(balance) application\n */\ndefine([\n    'jquery',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/resource-url-manager',\n    'Magento_Checkout/js/model/error-processor',\n    'Magento_SalesRule/js/model/payment/discount-messages',\n    'mage/storage',\n    'Magento_Checkout/js/action/get-payment-information',\n    'Magento_Checkout/js/model/totals',\n    'mage/translate',\n    'Magento_Checkout/js/model/full-screen-loader',\n    'Magento_Checkout/js/action/recollect-shipping-rates'\n], function ($, quote, urlManager, errorProcessor, messageContainer, storage, getPaymentInformationAction, totals, $t,\n  fullScreenLoader, recollectShippingRates\n) {\n    'use strict';\n\n    var successCallbacks = [],\n        action,\n        callSuccessCallbacks;\n\n    /**\n     * Execute callbacks when a coupon is successfully canceled.\n     */\n    callSuccessCallbacks = function () {\n        successCallbacks.forEach(function (callback) {\n            callback();\n        });\n    };\n\n    /**\n     * Cancel applied coupon.\n     *\n     * @param {Boolean} isApplied\n     * @returns {Deferred}\n     */\n    action =  function (isApplied) {\n        var quoteId = quote.getQuoteId(),\n            url = urlManager.getCancelCouponUrl(quoteId),\n            message = $t('Your coupon was successfully removed.');\n\n        messageContainer.clear();\n        fullScreenLoader.startLoader();\n\n        return storage.delete(\n            url,\n            false\n        ).done(function () {\n            var deferred = $.Deferred();\n\n            totals.isLoading(true);\n            recollectShippingRates();\n            getPaymentInformationAction(deferred);\n            $.when(deferred).done(function () {\n                isApplied(false);\n                totals.isLoading(false);\n                fullScreenLoader.stopLoader();\n                //Allowing to tap into coupon-cancel process.\n                callSuccessCallbacks();\n            });\n            messageContainer.addSuccessMessage({\n                'message': message\n            });\n        }).fail(function (response) {\n            totals.isLoading(false);\n            fullScreenLoader.stopLoader();\n            errorProcessor.process(response, messageContainer);\n        });\n    };\n\n    /**\n     * Callback for when the cancel-coupon process is finished.\n     *\n     * @param {Function} callback\n     */\n    action.registerSuccessCallback = function (callback) {\n        successCallbacks.push(callback);\n    };\n\n    return action;\n});\n","Magento_SalesRule/js/action/select-payment-method-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'mage/utils/wrapper',\n    'Magento_Checkout/js/model/quote',\n    'Magento_SalesRule/js/model/payment/discount-messages',\n    'Magento_Checkout/js/action/set-payment-information-extended',\n    'Magento_Checkout/js/action/get-totals',\n    'Magento_SalesRule/js/model/coupon'\n], function ($, wrapper, quote, messageContainer, setPaymentInformationExtended, getTotalsAction, coupon) {\n    'use strict';\n\n    return function (selectPaymentMethodAction) {\n\n        return wrapper.wrap(selectPaymentMethodAction, function (originalSelectPaymentMethodAction, paymentMethod) {\n\n            originalSelectPaymentMethodAction(paymentMethod);\n\n            if (paymentMethod === null) {\n                return;\n            }\n\n            $.when(\n                setPaymentInformationExtended(\n                    messageContainer,\n                    {\n                        method: paymentMethod.method\n                    },\n                    true\n                )\n            ).done(\n                function () {\n                    var deferred = $.Deferred(),\n\n                        /**\n                         * Update coupon form.\n                         */\n                        updateCouponCallback = function () {\n                            if (quote.totals() && !quote.totals()['coupon_code']) {\n                                coupon.setCouponCode('');\n                                coupon.setIsApplied(false);\n                            }\n                        };\n\n                    getTotalsAction([], deferred);\n                    $.when(deferred).done(updateCouponCallback);\n                }\n            );\n        });\n    };\n\n});\n","Magento_SalesRule/js/action/set-coupon-code.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * Customer store credit(balance) application\n */\ndefine([\n    'ko',\n    'jquery',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/resource-url-manager',\n    'Magento_Checkout/js/model/error-processor',\n    'Magento_SalesRule/js/model/payment/discount-messages',\n    'mage/storage',\n    'mage/translate',\n    'Magento_Checkout/js/action/get-payment-information',\n    'Magento_Checkout/js/model/totals',\n    'Magento_Checkout/js/model/full-screen-loader',\n    'Magento_Checkout/js/action/recollect-shipping-rates'\n], function (ko, $, quote, urlManager, errorProcessor, messageContainer, storage, $t, getPaymentInformationAction,\n    totals, fullScreenLoader, recollectShippingRates\n) {\n    'use strict';\n\n    var dataModifiers = [],\n        successCallbacks = [],\n        failCallbacks = [],\n        action;\n\n    /**\n     * Apply provided coupon.\n     *\n     * @param {String} couponCode\n     * @param {Boolean}isApplied\n     * @returns {Deferred}\n     */\n    action = function (couponCode, isApplied) {\n        var quoteId = quote.getQuoteId(),\n            url = urlManager.getApplyCouponUrl(couponCode, quoteId),\n            message = $t('Your coupon was successfully applied.'),\n            data = {},\n            headers = {};\n\n        //Allowing to modify coupon-apply request\n        dataModifiers.forEach(function (modifier) {\n            modifier(headers, data);\n        });\n        fullScreenLoader.startLoader();\n\n        return storage.put(\n            url,\n            data,\n            false,\n            null,\n            headers\n        ).done(function (response) {\n            var deferred;\n\n            if (response) {\n                deferred = $.Deferred();\n\n                isApplied(true);\n                totals.isLoading(true);\n                recollectShippingRates();\n                getPaymentInformationAction(deferred);\n                $.when(deferred).done(function () {\n                    fullScreenLoader.stopLoader();\n                    totals.isLoading(false);\n                });\n                messageContainer.addSuccessMessage({\n                    'message': message\n                });\n                //Allowing to tap into apply-coupon process.\n                successCallbacks.forEach(function (callback) {\n                    callback(response);\n                });\n            }\n        }).fail(function (response) {\n            fullScreenLoader.stopLoader();\n            totals.isLoading(false);\n            errorProcessor.process(response, messageContainer);\n            //Allowing to tap into apply-coupon process.\n            failCallbacks.forEach(function (callback) {\n                callback(response);\n            });\n        });\n    };\n\n    /**\n     * Modifying data to be sent.\n     *\n     * @param {Function} modifier\n     */\n    action.registerDataModifier = function (modifier) {\n        dataModifiers.push(modifier);\n    };\n\n    /**\n     * When successfully added a coupon.\n     *\n     * @param {Function} callback\n     */\n    action.registerSuccessCallback = function (callback) {\n        successCallbacks.push(callback);\n    };\n\n    /**\n     * When failed to add a coupon.\n     *\n     * @param {Function} callback\n     */\n    action.registerFailCallback = function (callback) {\n        failCallbacks.push(callback);\n    };\n\n    return action;\n});\n","Magento_SalesRule/js/model/coupon.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/**\n * Coupon model.\n */\ndefine([\n    'ko',\n    'domReady!'\n], function (ko) {\n    'use strict';\n\n    var couponCode = ko.observable(null),\n        isApplied = ko.observable(null);\n\n    return {\n        couponCode: couponCode,\n        isApplied: isApplied,\n\n        /**\n         * @return {*}\n         */\n        getCouponCode: function () {\n            return couponCode;\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        getIsApplied: function () {\n            return isApplied;\n        },\n\n        /**\n         * @param {*} couponCodeValue\n         */\n        setCouponCode: function (couponCodeValue) {\n            couponCode(couponCodeValue);\n        },\n\n        /**\n         * @param {Boolean} isAppliedValue\n         */\n        setIsApplied: function (isAppliedValue) {\n            isApplied(isAppliedValue);\n        }\n    };\n});\n","Magento_SalesRule/js/model/place-order-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'mage/utils/wrapper',\n    'Magento_Checkout/js/model/quote',\n    'Magento_SalesRule/js/model/coupon',\n    'Magento_Checkout/js/action/get-totals'\n], function ($, wrapper, quote, coupon, getTotalsAction) {\n    'use strict';\n\n    return function (placeOrderAction) {\n        return wrapper.wrap(placeOrderAction, function (originalAction, paymentData, messageContainer) {\n            var result;\n\n            $.when(\n                result = originalAction(paymentData, messageContainer)\n            ).fail(\n                function () {\n                    var deferred = $.Deferred(),\n\n                        /**\n                         * Update coupon form\n                         */\n                        updateCouponCallback = function () {\n                            if (quote.totals() && !quote.totals()['coupon_code']) {\n                                coupon.setCouponCode('');\n                                coupon.setIsApplied(false);\n                            }\n                        };\n\n                    getTotalsAction([], deferred);\n                    $.when(deferred).done(updateCouponCallback);\n                }\n            );\n\n            return result;\n        });\n    };\n});\n","Magento_SalesRule/js/model/shipping-save-processor-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'mage/utils/wrapper',\n    'Magento_Checkout/js/model/quote',\n    'Magento_SalesRule/js/model/coupon'\n], function (wrapper, quote, coupon) {\n    'use strict';\n\n    return function (shippingSaveProcessor) {\n        shippingSaveProcessor.saveShippingInformation = wrapper.wrapSuper(\n            shippingSaveProcessor.saveShippingInformation,\n            function (type) {\n                var updateCouponCallback;\n\n                /**\n                 * Update coupon form\n                 */\n                updateCouponCallback = function () {\n                    if (quote.totals() && !quote.totals()['coupon_code']) {\n                        coupon.setCouponCode('');\n                        coupon.setIsApplied(false);\n                    }\n                };\n\n                return this._super(type).done(updateCouponCallback);\n            }\n        );\n\n        return shippingSaveProcessor;\n    };\n});\n","Magento_SalesRule/js/model/payment/discount-messages.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/model/messages'\n], function (Messages) {\n    'use strict';\n\n    return new Messages();\n});\n","Magento_SalesRule/js/view/payment/discount-messages.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/view/messages',\n    '../../model/payment/discount-messages'\n], function (Component, messageContainer) {\n    'use strict';\n\n    return Component.extend({\n        /** @inheritdoc */\n        initialize: function (config) {\n            return this._super(config, messageContainer);\n        }\n    });\n});\n","Magento_SalesRule/js/view/payment/captcha.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n        'Magento_Captcha/js/view/checkout/defaultCaptcha',\n        'Magento_Captcha/js/model/captchaList',\n        'Magento_SalesRule/js/action/set-coupon-code',\n        'Magento_SalesRule/js/action/cancel-coupon',\n        'Magento_Checkout/js/model/quote',\n        'ko'\n    ],\n    function (defaultCaptcha, captchaList, setCouponCodeAction, cancelCouponAction, quote, ko) {\n        'use strict';\n\n        var totals = quote.getTotals(),\n            couponCode = ko.observable(null),\n            isApplied;\n\n        if (totals()) {\n            couponCode(totals()['coupon_code']);\n        }\n        //Captcha can only be required for adding a coupon so we need to know if one was added already.\n        isApplied = ko.observable(couponCode() != null);\n\n        return defaultCaptcha.extend({\n            /** @inheritdoc */\n            initialize: function () {\n                var self = this,\n                    currentCaptcha;\n\n                this._super();\n                //Getting coupon captcha model.\n                currentCaptcha = captchaList.getCaptchaByFormId(this.formId);\n\n                if (currentCaptcha != null) {\n                    if (!isApplied()) {\n                        //Show captcha if we don't have a coupon applied.\n                        currentCaptcha.setIsVisible(true);\n                    }\n                    this.setCurrentCaptcha(currentCaptcha);\n                    //Add captcha code to coupon-apply request.\n                    setCouponCodeAction.registerDataModifier(function (headers) {\n                        if (self.isRequired()) {\n                            headers['X-Captcha'] = self.captchaValue()();\n                        }\n                    });\n                    //Refresh captcha after failed request.\n                    setCouponCodeAction.registerFailCallback(function () {\n                        if (self.isRequired()) {\n                            self.refresh();\n                        }\n                    });\n                    //Hide captcha when a coupon has been applied.\n                    setCouponCodeAction.registerSuccessCallback(function () {\n                        self.setIsVisible(false);\n                    });\n                    //Show captcha again if it was canceled.\n                    cancelCouponAction.registerSuccessCallback(function () {\n                        if (self.isRequired()) {\n                            self.setIsVisible(true);\n                        }\n                    });\n                }\n            }\n        });\n    });\n","Magento_SalesRule/js/view/payment/discount.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'ko',\n    'uiComponent',\n    'Magento_Checkout/js/model/quote',\n    'Magento_SalesRule/js/action/set-coupon-code',\n    'Magento_SalesRule/js/action/cancel-coupon',\n    'Magento_SalesRule/js/model/coupon'\n], function ($, ko, Component, quote, setCouponCodeAction, cancelCouponAction, coupon) {\n    'use strict';\n\n    var totals = quote.getTotals(),\n        couponCode = coupon.getCouponCode(),\n        isApplied = coupon.getIsApplied();\n\n    if (totals()) {\n        couponCode(totals()['coupon_code']);\n    }\n    isApplied(couponCode() != null);\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_SalesRule/payment/discount'\n        },\n        couponCode: couponCode,\n\n        /**\n         * Applied flag\n         */\n        isApplied: isApplied,\n\n        /**\n         * Coupon code application procedure\n         */\n        apply: function () {\n            if (this.validate()) {\n                setCouponCodeAction(couponCode(), isApplied);\n            }\n        },\n\n        /**\n         * Cancel using coupon\n         */\n        cancel: function () {\n            if (this.validate()) {\n                couponCode('');\n                cancelCouponAction(isApplied);\n            }\n        },\n\n        /**\n         * Coupon form validation\n         *\n         * @returns {Boolean}\n         */\n        validate: function () {\n            var form = '#discount-form';\n\n            return $(form).validation() && $(form).validation('isValid');\n        }\n    });\n});\n","Magento_SalesRule/js/view/cart/totals/discount.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_SalesRule/js/view/summary/discount'\n], function (Component) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_SalesRule/cart/totals/discount'\n        },\n\n        /**\n         * @override\n         *\n         * @returns {Boolean}\n         */\n        isDisplayed: function () {\n            return this.getPureValue() != 0; //eslint-disable-line eqeqeq\n        }\n    });\n});\n","Magento_SalesRule/js/view/summary/discount.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Checkout/js/view/summary/abstract-total',\n    'Magento_Checkout/js/model/quote'\n], function (Component, quote) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_SalesRule/summary/discount'\n        },\n        totals: quote.getTotals(),\n\n        /**\n         * @return {*|Boolean}\n         */\n        isDisplayed: function () {\n            return this.isFullMode() && this.getPureValue() != 0; //eslint-disable-line eqeqeq\n        },\n\n        /**\n         * @return {*}\n         */\n        getCouponCode: function () {\n            if (!this.totals()) {\n                return null;\n            }\n\n            return this.totals()['coupon_code'];\n        },\n\n        /**\n         * @return {*}\n         */\n        getCouponLabel: function () {\n            if (!this.totals()) {\n                return null;\n            }\n\n            return this.totals()['coupon_label'];\n        },\n\n        /**\n         * Get discount title\n         *\n         * @returns {null|String}\n         */\n        getTitle: function () {\n            var discountSegments;\n\n            if (!this.totals()) {\n                return null;\n            }\n\n            discountSegments = this.totals()['total_segments'].filter(function (segment) {\n                return segment.code.indexOf('discount') !== -1;\n            });\n\n            return discountSegments.length ? discountSegments[0].title : null;\n        },\n\n        /**\n         * @return {Number}\n         */\n        getPureValue: function () {\n            var price = 0;\n\n            if (this.totals() && this.totals()['discount_amount']) {\n                price = parseFloat(this.totals()['discount_amount']);\n            }\n\n            return price;\n        },\n\n        /**\n         * @return {*|String}\n         */\n        getValue: function () {\n            return this.getFormattedPrice(this.getPureValue());\n        }\n    });\n});\n","Solwin_Cpanel/js/home-slider.js":"require(['jquery', 'cpowlcarousel'], function ($) {\n    $(document).ready(function () {\n        $(\".hb-slider\").owlCarousel({\n            items: 1,\n            itemsDesktop: [1080, 1],\n            itemsDesktopSmall: [860, 1],\n            itemsTablet: [768, 1],\n            itemsTabletSmall: [639, 1],\n            itemsMobile: [360, 1],\n            pagination: true,\n            navigationText: [\"<i class='fa fa-angle-left'></i>\", \"<i class='fa fa-angle-right'>\"],\n            navigation: false,\n        });\n\n        $(\".hpb-slider\").owlCarousel({\n            items: 3,\n            itemsDesktop: [1080, 3],\n            itemsDesktopSmall: [860, 3],\n            itemsTablet: [768, 2],\n            itemsTabletSmall: [639, 2],\n            itemsMobile: [479, 1],\n            pagination: false,\n            navigationText: ['<div class=\"lft-btn\"><i class=\"fa fa-angle-left\"></i></div>', '<div class=\"rgt-btn\"><i class=\"fa fa-angle-right\"></div>'],\n            navigation: true,\n        });\n        $(\".htb-slider\").owlCarousel({\n            items: 1,\n            itemsDesktop: [1080, 1],\n            itemsDesktopSmall: [860, 1],\n            itemsTablet: [768, 1],\n            itemsTabletSmall: [639, 1],\n            itemsMobile: [479, 1],\n            pagination: false,\n            navigationText: ['<div class=\"lft-btn\"><i class=\"fa fa-angle-left\"></i></div>', '<div class=\"rgt-btn\"><i class=\"fa fa-angle-right\"></div>'],\n            navigation: true,\n        });\n        $(\".hbr-slider\").owlCarousel({\n            items: 5,\n            itemsDesktop: [1080, 4],\n            itemsDesktopSmall: [860, 3],\n            itemsTablet: [768, 3],\n            itemsTabletSmall: [639, 3],\n            itemsMobile: [479, 2],\n            pagination: false,\n            navigationText: ['<div class=\"lft-btn\"><i class=\"fa fa-angle-left\"></i></div>', '<div class=\"rgt-btn\"><i class=\"fa fa-angle-right\"></div>'],\n            navigation: true,\n        });\n    });\n});","Solwin_Cpanel/js/owl.carousel.js":"/*\n *  jQuery OwlCarousel v1.3.3\n *\n *  Copyright (c) 2013 Bartosz Wojciechowski\n *  http://www.owlgraphic.com/owlcarousel/\n *\n *  Licensed under MIT\n *\n */\n\n/*JS Lint helpers: */\n/*global dragMove: false, dragEnd: false, $, jQuery, alert, window, document */\n/*jslint nomen: true, continue:true */\ndefine([\n    'jquery'\n], function () {\n    if (typeof Object.create !== \"function\") {\n        Object.create = function (obj) {\n            function F() {\n            }\n            F.prototype = obj;\n            return new F();\n        };\n    }\n    (function ($, window, document) {\n\n        var Carousel = {\n            init: function (options, el) {\n                var base = this;\n\n                base.$elem = $(el);\n                base.options = $.extend({}, $.fn.owlCarousel.options, base.$elem.data(), options);\n\n                base.userOptions = options;\n                base.loadContent();\n            },\n            loadContent: function () {\n                var base = this, url;\n\n                function getData(data) {\n                    var i, content = \"\";\n                    if (typeof base.options.jsonSuccess === \"function\") {\n                        base.options.jsonSuccess.apply(this, [data]);\n                    } else {\n                        for (i in data.owl) {\n                            if (data.owl.hasOwnProperty(i)) {\n                                content += data.owl[i].item;\n                            }\n                        }\n                        base.$elem.html(content);\n                    }\n                    base.logIn();\n                }\n\n                if (typeof base.options.beforeInit === \"function\") {\n                    base.options.beforeInit.apply(this, [base.$elem]);\n                }\n\n                if (typeof base.options.jsonPath === \"string\") {\n                    url = base.options.jsonPath;\n                    $.getJSON(url, getData);\n                } else {\n                    base.logIn();\n                }\n            },\n            logIn: function () {\n                var base = this;\n\n                base.$elem.data(\"owl-originalStyles\", base.$elem.attr(\"style\"));\n                base.$elem.data(\"owl-originalClasses\", base.$elem.attr(\"class\"));\n\n                base.$elem.css({opacity: 0});\n                base.orignalItems = base.options.items;\n                base.checkBrowser();\n                base.wrapperWidth = 0;\n                base.checkVisible = null;\n                base.setVars();\n            },\n            setVars: function () {\n                var base = this;\n                if (base.$elem.children().length === 0) {\n                    return false;\n                }\n                base.baseClass();\n                base.eventTypes();\n                base.$userItems = base.$elem.children();\n                base.itemsAmount = base.$userItems.length;\n                base.wrapItems();\n                base.$owlItems = base.$elem.find(\".owl-item\");\n                base.$owlWrapper = base.$elem.find(\".owl-wrapper\");\n                base.playDirection = \"next\";\n                base.prevItem = 0;\n                base.prevArr = [0];\n                base.currentItem = 0;\n                base.customEvents();\n                base.onStartup();\n            },\n            onStartup: function () {\n                var base = this;\n                base.updateItems();\n                base.calculateAll();\n                base.buildControls();\n                base.updateControls();\n                base.response();\n                base.moveEvents();\n                base.stopOnHover();\n                base.owlStatus();\n\n                if (base.options.transitionStyle !== false) {\n                    base.transitionTypes(base.options.transitionStyle);\n                }\n                if (base.options.autoPlay === true) {\n                    base.options.autoPlay = 5000;\n                }\n                base.play();\n\n                base.$elem.find(\".owl-wrapper\").css(\"display\", \"block\");\n\n                if (!base.$elem.is(\":visible\")) {\n                    base.watchVisibility();\n                } else {\n                    base.$elem.css(\"opacity\", 1);\n                }\n                base.onstartup = false;\n                base.eachMoveUpdate();\n                if (typeof base.options.afterInit === \"function\") {\n                    base.options.afterInit.apply(this, [base.$elem]);\n                }\n            },\n            eachMoveUpdate: function () {\n                var base = this;\n\n                if (base.options.lazyLoad === true) {\n                    base.lazyLoad();\n                }\n                if (base.options.autoHeight === true) {\n                    base.autoHeight();\n                }\n                base.onVisibleItems();\n\n                if (typeof base.options.afterAction === \"function\") {\n                    base.options.afterAction.apply(this, [base.$elem]);\n                }\n            },\n            updateVars: function () {\n                var base = this;\n                if (typeof base.options.beforeUpdate === \"function\") {\n                    base.options.beforeUpdate.apply(this, [base.$elem]);\n                }\n                base.watchVisibility();\n                base.updateItems();\n                base.calculateAll();\n                base.updatePosition();\n                base.updateControls();\n                base.eachMoveUpdate();\n                if (typeof base.options.afterUpdate === \"function\") {\n                    base.options.afterUpdate.apply(this, [base.$elem]);\n                }\n            },\n            reload: function () {\n                var base = this;\n                window.setTimeout(function () {\n                    base.updateVars();\n                }, 0);\n            },\n            watchVisibility: function () {\n                var base = this;\n\n                if (base.$elem.is(\":visible\") === false) {\n                    base.$elem.css({opacity: 0});\n                    window.clearInterval(base.autoPlayInterval);\n                    window.clearInterval(base.checkVisible);\n                } else {\n                    return false;\n                }\n                base.checkVisible = window.setInterval(function () {\n                    if (base.$elem.is(\":visible\")) {\n                        base.reload();\n                        base.$elem.animate({opacity: 1}, 200);\n                        window.clearInterval(base.checkVisible);\n                    }\n                }, 500);\n            },\n            wrapItems: function () {\n                var base = this;\n                base.$userItems.wrapAll(\"<div class=\\\"owl-wrapper\\\">\").wrap(\"<div class=\\\"owl-item\\\"></div>\");\n                base.$elem.find(\".owl-wrapper\").wrap(\"<div class=\\\"owl-wrapper-outer\\\">\");\n                base.wrapperOuter = base.$elem.find(\".owl-wrapper-outer\");\n                base.$elem.css(\"display\", \"block\");\n            },\n            baseClass: function () {\n                var base = this,\n                        hasBaseClass = base.$elem.hasClass(base.options.baseClass),\n                        hasThemeClass = base.$elem.hasClass(base.options.theme);\n\n                if (!hasBaseClass) {\n                    base.$elem.addClass(base.options.baseClass);\n                }\n\n                if (!hasThemeClass) {\n                    base.$elem.addClass(base.options.theme);\n                }\n            },\n            updateItems: function () {\n                var base = this, width, i;\n\n                if (base.options.responsive === false) {\n                    return false;\n                }\n                if (base.options.singleItem === true) {\n                    base.options.items = base.orignalItems = 1;\n                    base.options.itemsCustom = false;\n                    base.options.itemsDesktop = false;\n                    base.options.itemsDesktopSmall = false;\n                    base.options.itemsTablet = false;\n                    base.options.itemsTabletSmall = false;\n                    base.options.itemsMobile = false;\n                    return false;\n                }\n\n                width = $(base.options.responsiveBaseWidth).width();\n\n                if (width > (base.options.itemsDesktop[0] || base.orignalItems)) {\n                    base.options.items = base.orignalItems;\n                }\n                if (base.options.itemsCustom !== false) {\n                    //Reorder array by screen size\n                    base.options.itemsCustom.sort(function (a, b) {\n                        return a[0] - b[0];\n                    });\n\n                    for (i = 0; i < base.options.itemsCustom.length; i += 1) {\n                        if (base.options.itemsCustom[i][0] <= width) {\n                            base.options.items = base.options.itemsCustom[i][1];\n                        }\n                    }\n\n                } else {\n\n                    if (width <= base.options.itemsDesktop[0] && base.options.itemsDesktop !== false) {\n                        base.options.items = base.options.itemsDesktop[1];\n                    }\n\n                    if (width <= base.options.itemsDesktopSmall[0] && base.options.itemsDesktopSmall !== false) {\n                        base.options.items = base.options.itemsDesktopSmall[1];\n                    }\n\n                    if (width <= base.options.itemsTablet[0] && base.options.itemsTablet !== false) {\n                        base.options.items = base.options.itemsTablet[1];\n                    }\n\n                    if (width <= base.options.itemsTabletSmall[0] && base.options.itemsTabletSmall !== false) {\n                        base.options.items = base.options.itemsTabletSmall[1];\n                    }\n\n                    if (width <= base.options.itemsMobile[0] && base.options.itemsMobile !== false) {\n                        base.options.items = base.options.itemsMobile[1];\n                    }\n                }\n\n                //if number of items is less than declared\n                if (base.options.items > base.itemsAmount && base.options.itemsScaleUp === true) {\n                    base.options.items = base.itemsAmount;\n                }\n            },\n            response: function () {\n                var base = this,\n                        smallDelay,\n                        lastWindowWidth;\n\n                if (base.options.responsive !== true) {\n                    return false;\n                }\n                lastWindowWidth = $(window).width();\n\n                base.resizer = function () {\n                    if ($(window).width() !== lastWindowWidth) {\n                        if (base.options.autoPlay !== false) {\n                            window.clearInterval(base.autoPlayInterval);\n                        }\n                        window.clearTimeout(smallDelay);\n                        smallDelay = window.setTimeout(function () {\n                            lastWindowWidth = $(window).width();\n                            base.updateVars();\n                        }, base.options.responsiveRefreshRate);\n                    }\n                };\n                $(window).resize(base.resizer);\n            },\n            updatePosition: function () {\n                var base = this;\n                base.jumpTo(base.currentItem);\n                if (base.options.autoPlay !== false) {\n                    base.checkAp();\n                }\n            },\n            appendItemsSizes: function () {\n                var base = this,\n                        roundPages = 0,\n                        lastItem = base.itemsAmount - base.options.items;\n\n                base.$owlItems.each(function (index) {\n                    var $this = $(this);\n                    $this\n                            .css({\"width\": base.itemWidth})\n                            .data(\"owl-item\", Number(index));\n\n                    if (index % base.options.items === 0 || index === lastItem) {\n                        if (!(index > lastItem)) {\n                            roundPages += 1;\n                        }\n                    }\n                    $this.data(\"owl-roundPages\", roundPages);\n                });\n            },\n            appendWrapperSizes: function () {\n                var base = this,\n                        width = base.$owlItems.length * base.itemWidth;\n\n                base.$owlWrapper.css({\n                    \"width\": width * 2,\n                    \"left\": 0\n                });\n                base.appendItemsSizes();\n            },\n            calculateAll: function () {\n                var base = this;\n                base.calculateWidth();\n                base.appendWrapperSizes();\n                base.loops();\n                base.max();\n            },\n            calculateWidth: function () {\n                var base = this;\n                base.itemWidth = Math.round(base.$elem.width() / base.options.items);\n            },\n            max: function () {\n                var base = this,\n                        maximum = ((base.itemsAmount * base.itemWidth) - base.options.items * base.itemWidth) * -1;\n                if (base.options.items > base.itemsAmount) {\n                    base.maximumItem = 0;\n                    maximum = 0;\n                    base.maximumPixels = 0;\n                } else {\n                    base.maximumItem = base.itemsAmount - base.options.items;\n                    base.maximumPixels = maximum;\n                }\n                return maximum;\n            },\n            min: function () {\n                return 0;\n            },\n            loops: function () {\n                var base = this,\n                        prev = 0,\n                        elWidth = 0,\n                        i,\n                        item,\n                        roundPageNum;\n\n                base.positionsInArray = [0];\n                base.pagesInArray = [];\n\n                for (i = 0; i < base.itemsAmount; i += 1) {\n                    elWidth += base.itemWidth;\n                    base.positionsInArray.push(-elWidth);\n\n                    if (base.options.scrollPerPage === true) {\n                        item = $(base.$owlItems[i]);\n                        roundPageNum = item.data(\"owl-roundPages\");\n                        if (roundPageNum !== prev) {\n                            base.pagesInArray[prev] = base.positionsInArray[i];\n                            prev = roundPageNum;\n                        }\n                    }\n                }\n            },\n            buildControls: function () {\n                var base = this;\n                if (base.options.navigation === true || base.options.pagination === true) {\n                    base.owlControls = $(\"<div class=\\\"owl-controls\\\"/>\").toggleClass(\"clickable\", !base.browser.isTouch).appendTo(base.$elem);\n                }\n                if (base.options.pagination === true) {\n                    base.buildPagination();\n                }\n                if (base.options.navigation === true) {\n                    base.buildButtons();\n                }\n            },\n            buildButtons: function () {\n                var base = this,\n                        buttonsWrapper = $(\"<div class=\\\"owl-buttons\\\"/>\");\n                base.owlControls.append(buttonsWrapper);\n\n                base.buttonPrev = $(\"<div/>\", {\n                    \"class\": \"owl-prev\",\n                    \"html\": base.options.navigationText[0] || \"\"\n                });\n\n                base.buttonNext = $(\"<div/>\", {\n                    \"class\": \"owl-next\",\n                    \"html\": base.options.navigationText[1] || \"\"\n                });\n\n                buttonsWrapper\n                        .append(base.buttonPrev)\n                        .append(base.buttonNext);\n\n                buttonsWrapper.on(\"touchstart.owlControls mousedown.owlControls\", \"div[class^=\\\"owl\\\"]\", function (event) {\n                    event.preventDefault();\n                });\n\n                buttonsWrapper.on(\"touchend.owlControls mouseup.owlControls\", \"div[class^=\\\"owl\\\"]\", function (event) {\n                    event.preventDefault();\n                    if ($(this).hasClass(\"owl-next\")) {\n                        base.next();\n                    } else {\n                        base.prev();\n                    }\n                });\n            },\n            buildPagination: function () {\n                var base = this;\n\n                base.paginationWrapper = $(\"<div class=\\\"owl-pagination\\\"/>\");\n                base.owlControls.append(base.paginationWrapper);\n\n                base.paginationWrapper.on(\"touchend.owlControls mouseup.owlControls\", \".owl-page\", function (event) {\n                    event.preventDefault();\n                    if (Number($(this).data(\"owl-page\")) !== base.currentItem) {\n                        base.goTo(Number($(this).data(\"owl-page\")), true);\n                    }\n                });\n            },\n            updatePagination: function () {\n                var base = this,\n                        counter,\n                        lastPage,\n                        lastItem,\n                        i,\n                        paginationButton,\n                        paginationButtonInner;\n\n                if (base.options.pagination === false) {\n                    return false;\n                }\n\n                base.paginationWrapper.html(\"\");\n\n                counter = 0;\n                lastPage = base.itemsAmount - base.itemsAmount % base.options.items;\n\n                for (i = 0; i < base.itemsAmount; i += 1) {\n                    if (i % base.options.items === 0) {\n                        counter += 1;\n                        if (lastPage === i) {\n                            lastItem = base.itemsAmount - base.options.items;\n                        }\n                        paginationButton = $(\"<div/>\", {\n                            \"class\": \"owl-page\"\n                        });\n                        paginationButtonInner = $(\"<span></span>\", {\n                            \"text\": base.options.paginationNumbers === true ? counter : \"\",\n                            \"class\": base.options.paginationNumbers === true ? \"owl-numbers\" : \"\"\n                        });\n                        paginationButton.append(paginationButtonInner);\n\n                        paginationButton.data(\"owl-page\", lastPage === i ? lastItem : i);\n                        paginationButton.data(\"owl-roundPages\", counter);\n\n                        base.paginationWrapper.append(paginationButton);\n                    }\n                }\n                base.checkPagination();\n            },\n            checkPagination: function () {\n                var base = this;\n                if (base.options.pagination === false) {\n                    return false;\n                }\n                base.paginationWrapper.find(\".owl-page\").each(function () {\n                    if ($(this).data(\"owl-roundPages\") === $(base.$owlItems[base.currentItem]).data(\"owl-roundPages\")) {\n                        base.paginationWrapper\n                                .find(\".owl-page\")\n                                .removeClass(\"active\");\n                        $(this).addClass(\"active\");\n                    }\n                });\n            },\n            checkNavigation: function () {\n                var base = this;\n\n                if (base.options.navigation === false) {\n                    return false;\n                }\n                if (base.options.rewindNav === false) {\n                    if (base.currentItem === 0 && base.maximumItem === 0) {\n                        base.buttonPrev.addClass(\"disabled\");\n                        base.buttonNext.addClass(\"disabled\");\n                    } else if (base.currentItem === 0 && base.maximumItem !== 0) {\n                        base.buttonPrev.addClass(\"disabled\");\n                        base.buttonNext.removeClass(\"disabled\");\n                    } else if (base.currentItem === base.maximumItem) {\n                        base.buttonPrev.removeClass(\"disabled\");\n                        base.buttonNext.addClass(\"disabled\");\n                    } else if (base.currentItem !== 0 && base.currentItem !== base.maximumItem) {\n                        base.buttonPrev.removeClass(\"disabled\");\n                        base.buttonNext.removeClass(\"disabled\");\n                    }\n                }\n            },\n            updateControls: function () {\n                var base = this;\n                base.updatePagination();\n                base.checkNavigation();\n                if (base.owlControls) {\n                    if (base.options.items >= base.itemsAmount) {\n                        base.owlControls.hide();\n                    } else {\n                        base.owlControls.show();\n                    }\n                }\n            },\n            destroyControls: function () {\n                var base = this;\n                if (base.owlControls) {\n                    base.owlControls.remove();\n                }\n            },\n            next: function (speed) {\n                var base = this;\n\n                if (base.isTransition) {\n                    return false;\n                }\n\n                base.currentItem += base.options.scrollPerPage === true ? base.options.items : 1;\n                if (base.currentItem > base.maximumItem + (base.options.scrollPerPage === true ? (base.options.items - 1) : 0)) {\n                    if (base.options.rewindNav === true) {\n                        base.currentItem = 0;\n                        speed = \"rewind\";\n                    } else {\n                        base.currentItem = base.maximumItem;\n                        return false;\n                    }\n                }\n                base.goTo(base.currentItem, speed);\n            },\n            prev: function (speed) {\n                var base = this;\n\n                if (base.isTransition) {\n                    return false;\n                }\n\n                if (base.options.scrollPerPage === true && base.currentItem > 0 && base.currentItem < base.options.items) {\n                    base.currentItem = 0;\n                } else {\n                    base.currentItem -= base.options.scrollPerPage === true ? base.options.items : 1;\n                }\n                if (base.currentItem < 0) {\n                    if (base.options.rewindNav === true) {\n                        base.currentItem = base.maximumItem;\n                        speed = \"rewind\";\n                    } else {\n                        base.currentItem = 0;\n                        return false;\n                    }\n                }\n                base.goTo(base.currentItem, speed);\n            },\n            goTo: function (position, speed, drag) {\n                var base = this,\n                        goToPixel;\n\n                if (base.isTransition) {\n                    return false;\n                }\n                if (typeof base.options.beforeMove === \"function\") {\n                    base.options.beforeMove.apply(this, [base.$elem]);\n                }\n                if (position >= base.maximumItem) {\n                    position = base.maximumItem;\n                } else if (position <= 0) {\n                    position = 0;\n                }\n\n                base.currentItem = base.owl.currentItem = position;\n                if (base.options.transitionStyle !== false && drag !== \"drag\" && base.options.items === 1 && base.browser.support3d === true) {\n                    base.swapSpeed(0);\n                    if (base.browser.support3d === true) {\n                        base.transition3d(base.positionsInArray[position]);\n                    } else {\n                        base.css2slide(base.positionsInArray[position], 1);\n                    }\n                    base.afterGo();\n                    base.singleItemTransition();\n                    return false;\n                }\n                goToPixel = base.positionsInArray[position];\n\n                if (base.browser.support3d === true) {\n                    base.isCss3Finish = false;\n\n                    if (speed === true) {\n                        base.swapSpeed(\"paginationSpeed\");\n                        window.setTimeout(function () {\n                            base.isCss3Finish = true;\n                        }, base.options.paginationSpeed);\n\n                    } else if (speed === \"rewind\") {\n                        base.swapSpeed(base.options.rewindSpeed);\n                        window.setTimeout(function () {\n                            base.isCss3Finish = true;\n                        }, base.options.rewindSpeed);\n\n                    } else {\n                        base.swapSpeed(\"slideSpeed\");\n                        window.setTimeout(function () {\n                            base.isCss3Finish = true;\n                        }, base.options.slideSpeed);\n                    }\n                    base.transition3d(goToPixel);\n                } else {\n                    if (speed === true) {\n                        base.css2slide(goToPixel, base.options.paginationSpeed);\n                    } else if (speed === \"rewind\") {\n                        base.css2slide(goToPixel, base.options.rewindSpeed);\n                    } else {\n                        base.css2slide(goToPixel, base.options.slideSpeed);\n                    }\n                }\n                base.afterGo();\n            },\n            jumpTo: function (position) {\n                var base = this;\n                if (typeof base.options.beforeMove === \"function\") {\n                    base.options.beforeMove.apply(this, [base.$elem]);\n                }\n                if (position >= base.maximumItem || position === -1) {\n                    position = base.maximumItem;\n                } else if (position <= 0) {\n                    position = 0;\n                }\n                base.swapSpeed(0);\n                if (base.browser.support3d === true) {\n                    base.transition3d(base.positionsInArray[position]);\n                } else {\n                    base.css2slide(base.positionsInArray[position], 1);\n                }\n                base.currentItem = base.owl.currentItem = position;\n                base.afterGo();\n            },\n            afterGo: function () {\n                var base = this;\n\n                base.prevArr.push(base.currentItem);\n                base.prevItem = base.owl.prevItem = base.prevArr[base.prevArr.length - 2];\n                base.prevArr.shift(0);\n\n                if (base.prevItem !== base.currentItem) {\n                    base.checkPagination();\n                    base.checkNavigation();\n                    base.eachMoveUpdate();\n\n                    if (base.options.autoPlay !== false) {\n                        base.checkAp();\n                    }\n                }\n                if (typeof base.options.afterMove === \"function\" && base.prevItem !== base.currentItem) {\n                    base.options.afterMove.apply(this, [base.$elem]);\n                }\n            },\n            stop: function () {\n                var base = this;\n                base.apStatus = \"stop\";\n                window.clearInterval(base.autoPlayInterval);\n            },\n            checkAp: function () {\n                var base = this;\n                if (base.apStatus !== \"stop\") {\n                    base.play();\n                }\n            },\n            play: function () {\n                var base = this;\n                base.apStatus = \"play\";\n                if (base.options.autoPlay === false) {\n                    return false;\n                }\n                window.clearInterval(base.autoPlayInterval);\n                base.autoPlayInterval = window.setInterval(function () {\n                    base.next(true);\n                }, base.options.autoPlay);\n            },\n            swapSpeed: function (action) {\n                var base = this;\n                if (action === \"slideSpeed\") {\n                    base.$owlWrapper.css(base.addCssSpeed(base.options.slideSpeed));\n                } else if (action === \"paginationSpeed\") {\n                    base.$owlWrapper.css(base.addCssSpeed(base.options.paginationSpeed));\n                } else if (typeof action !== \"string\") {\n                    base.$owlWrapper.css(base.addCssSpeed(action));\n                }\n            },\n            addCssSpeed: function (speed) {\n                return {\n                    \"-webkit-transition\": \"all \" + speed + \"ms ease\",\n                    \"-moz-transition\": \"all \" + speed + \"ms ease\",\n                    \"-o-transition\": \"all \" + speed + \"ms ease\",\n                    \"transition\": \"all \" + speed + \"ms ease\"\n                };\n            },\n            removeTransition: function () {\n                return {\n                    \"-webkit-transition\": \"\",\n                    \"-moz-transition\": \"\",\n                    \"-o-transition\": \"\",\n                    \"transition\": \"\"\n                };\n            },\n            doTranslate: function (pixels) {\n                return {\n                    \"-webkit-transform\": \"translate3d(\" + pixels + \"px, 0px, 0px)\",\n                    \"-moz-transform\": \"translate3d(\" + pixels + \"px, 0px, 0px)\",\n                    \"-o-transform\": \"translate3d(\" + pixels + \"px, 0px, 0px)\",\n                    \"-ms-transform\": \"translate3d(\" + pixels + \"px, 0px, 0px)\",\n                    \"transform\": \"translate3d(\" + pixels + \"px, 0px,0px)\"\n                };\n            },\n            transition3d: function (value) {\n                var base = this;\n                base.$owlWrapper.css(base.doTranslate(value));\n            },\n            css2move: function (value) {\n                var base = this;\n                base.$owlWrapper.css({\"left\": value});\n            },\n            css2slide: function (value, speed) {\n                var base = this;\n\n                base.isCssFinish = false;\n                base.$owlWrapper.stop(true, true).animate({\n                    \"left\": value\n                }, {\n                    duration: speed || base.options.slideSpeed,\n                    complete: function () {\n                        base.isCssFinish = true;\n                    }\n                });\n            },\n            checkBrowser: function () {\n                var base = this,\n                        translate3D = \"translate3d(0px, 0px, 0px)\",\n                        tempElem = document.createElement(\"div\"),\n                        regex,\n                        asSupport,\n                        support3d,\n                        isTouch;\n\n                tempElem.style.cssText = \"  -moz-transform:\" + translate3D +\n                        \"; -ms-transform:\" + translate3D +\n                        \"; -o-transform:\" + translate3D +\n                        \"; -webkit-transform:\" + translate3D +\n                        \"; transform:\" + translate3D;\n                regex = /translate3d\\(0px, 0px, 0px\\)/g;\n                asSupport = tempElem.style.cssText.match(regex);\n                support3d = (asSupport !== null && asSupport.length === 1);\n\n                isTouch = \"ontouchstart\" in window || window.navigator.msMaxTouchPoints;\n\n                base.browser = {\n                    \"support3d\": support3d,\n                    \"isTouch\": isTouch\n                };\n            },\n            moveEvents: function () {\n                var base = this;\n                if (base.options.mouseDrag !== false || base.options.touchDrag !== false) {\n                    base.gestures();\n                    base.disabledEvents();\n                }\n            },\n            eventTypes: function () {\n                var base = this,\n                        types = [\"s\", \"e\", \"x\"];\n\n                base.ev_types = {};\n\n                if (base.options.mouseDrag === true && base.options.touchDrag === true) {\n                    types = [\n                        \"touchstart.owl mousedown.owl\",\n                        \"touchmove.owl mousemove.owl\",\n                        \"touchend.owl touchcancel.owl mouseup.owl\"\n                    ];\n                } else if (base.options.mouseDrag === false && base.options.touchDrag === true) {\n                    types = [\n                        \"touchstart.owl\",\n                        \"touchmove.owl\",\n                        \"touchend.owl touchcancel.owl\"\n                    ];\n                } else if (base.options.mouseDrag === true && base.options.touchDrag === false) {\n                    types = [\n                        \"mousedown.owl\",\n                        \"mousemove.owl\",\n                        \"mouseup.owl\"\n                    ];\n                }\n\n                base.ev_types.start = types[0];\n                base.ev_types.move = types[1];\n                base.ev_types.end = types[2];\n            },\n            disabledEvents: function () {\n                var base = this;\n                base.$elem.on(\"dragstart.owl\", function (event) {\n                    event.preventDefault();\n                });\n                base.$elem.on(\"mousedown.disableTextSelect\", function (e) {\n                    return $(e.target).is('input, textarea, select, option');\n                });\n            },\n            gestures: function () {\n                /*jslint unparam: true*/\n                var base = this,\n                        locals = {\n                            offsetX: 0,\n                            offsetY: 0,\n                            baseElWidth: 0,\n                            relativePos: 0,\n                            position: null,\n                            minSwipe: null,\n                            maxSwipe: null,\n                            sliding: null,\n                            dargging: null,\n                            targetElement: null\n                        };\n\n                base.isCssFinish = true;\n\n                function getTouches(event) {\n                    if (event.touches !== undefined) {\n                        return {\n                            x: event.touches[0].pageX,\n                            y: event.touches[0].pageY\n                        };\n                    }\n\n                    if (event.touches === undefined) {\n                        if (event.pageX !== undefined) {\n                            return {\n                                x: event.pageX,\n                                y: event.pageY\n                            };\n                        }\n                        if (event.pageX === undefined) {\n                            return {\n                                x: event.clientX,\n                                y: event.clientY\n                            };\n                        }\n                    }\n                }\n\n                function swapEvents(type) {\n                    if (type === \"on\") {\n                        $(document).on(base.ev_types.move, dragMove);\n                        $(document).on(base.ev_types.end, dragEnd);\n                    } else if (type === \"off\") {\n                        $(document).off(base.ev_types.move);\n                        $(document).off(base.ev_types.end);\n                    }\n                }\n\n                function dragStart(event) {\n                    var ev = event.originalEvent || event || window.event,\n                            position;\n\n                    if (ev.which === 3) {\n                        return false;\n                    }\n                    if (base.itemsAmount <= base.options.items) {\n                        return;\n                    }\n                    if (base.isCssFinish === false && !base.options.dragBeforeAnimFinish) {\n                        return false;\n                    }\n                    if (base.isCss3Finish === false && !base.options.dragBeforeAnimFinish) {\n                        return false;\n                    }\n\n                    if (base.options.autoPlay !== false) {\n                        window.clearInterval(base.autoPlayInterval);\n                    }\n\n                    if (base.browser.isTouch !== true && !base.$owlWrapper.hasClass(\"grabbing\")) {\n                        base.$owlWrapper.addClass(\"grabbing\");\n                    }\n\n                    base.newPosX = 0;\n                    base.newRelativeX = 0;\n\n                    $(this).css(base.removeTransition());\n\n                    position = $(this).position();\n                    locals.relativePos = position.left;\n\n                    locals.offsetX = getTouches(ev).x - position.left;\n                    locals.offsetY = getTouches(ev).y - position.top;\n\n                    swapEvents(\"on\");\n\n                    locals.sliding = false;\n                    locals.targetElement = ev.target || ev.srcElement;\n                }\n\n                function dragMove(event) {\n                    var ev = event.originalEvent || event || window.event,\n                            minSwipe,\n                            maxSwipe;\n\n                    base.newPosX = getTouches(ev).x - locals.offsetX;\n                    base.newPosY = getTouches(ev).y - locals.offsetY;\n                    base.newRelativeX = base.newPosX - locals.relativePos;\n\n                    if (typeof base.options.startDragging === \"function\" && locals.dragging !== true && base.newRelativeX !== 0) {\n                        locals.dragging = true;\n                        base.options.startDragging.apply(base, [base.$elem]);\n                    }\n\n                    if ((base.newRelativeX > 8 || base.newRelativeX < -8) && (base.browser.isTouch === true)) {\n                        if (ev.preventDefault !== undefined) {\n                            ev.preventDefault();\n                        } else {\n                            ev.returnValue = false;\n                        }\n                        locals.sliding = true;\n                    }\n\n                    if ((base.newPosY > 10 || base.newPosY < -10) && locals.sliding === false) {\n                        $(document).off(\"touchmove.owl\");\n                    }\n\n                    minSwipe = function () {\n                        return base.newRelativeX / 5;\n                    };\n\n                    maxSwipe = function () {\n                        return base.maximumPixels + base.newRelativeX / 5;\n                    };\n\n                    base.newPosX = Math.max(Math.min(base.newPosX, minSwipe()), maxSwipe());\n                    if (base.browser.support3d === true) {\n                        base.transition3d(base.newPosX);\n                    } else {\n                        base.css2move(base.newPosX);\n                    }\n                }\n\n                function dragEnd(event) {\n                    var ev = event.originalEvent || event || window.event,\n                            newPosition,\n                            handlers,\n                            owlStopEvent;\n\n                    ev.target = ev.target || ev.srcElement;\n\n                    locals.dragging = false;\n\n                    if (base.browser.isTouch !== true) {\n                        base.$owlWrapper.removeClass(\"grabbing\");\n                    }\n\n                    if (base.newRelativeX < 0) {\n                        base.dragDirection = base.owl.dragDirection = \"left\";\n                    } else {\n                        base.dragDirection = base.owl.dragDirection = \"right\";\n                    }\n\n                    if (base.newRelativeX !== 0) {\n                        newPosition = base.getNewPosition();\n                        base.goTo(newPosition, false, \"drag\");\n                        if (locals.targetElement === ev.target && base.browser.isTouch !== true) {\n                            $(ev.target).on(\"click.disable\", function (ev) {\n                                ev.stopImmediatePropagation();\n                                ev.stopPropagation();\n                                ev.preventDefault();\n                                $(ev.target).off(\"click.disable\");\n                            });\n                            handlers = $._data(ev.target, \"events\").click;\n                            owlStopEvent = handlers.pop();\n                            handlers.splice(0, 0, owlStopEvent);\n                        }\n                    }\n                    swapEvents(\"off\");\n                }\n                base.$elem.on(base.ev_types.start, \".owl-wrapper\", dragStart);\n            },\n            getNewPosition: function () {\n                var base = this,\n                        newPosition = base.closestItem();\n\n                if (newPosition > base.maximumItem) {\n                    base.currentItem = base.maximumItem;\n                    newPosition = base.maximumItem;\n                } else if (base.newPosX >= 0) {\n                    newPosition = 0;\n                    base.currentItem = 0;\n                }\n                return newPosition;\n            },\n            closestItem: function () {\n                var base = this,\n                        array = base.options.scrollPerPage === true ? base.pagesInArray : base.positionsInArray,\n                        goal = base.newPosX,\n                        closest = null;\n\n                $.each(array, function (i, v) {\n                    if (goal - (base.itemWidth / 20) > array[i + 1] && goal - (base.itemWidth / 20) < v && base.moveDirection() === \"left\") {\n                        closest = v;\n                        if (base.options.scrollPerPage === true) {\n                            base.currentItem = $.inArray(closest, base.positionsInArray);\n                        } else {\n                            base.currentItem = i;\n                        }\n                    } else if (goal + (base.itemWidth / 20) < v && goal + (base.itemWidth / 20) > (array[i + 1] || array[i] - base.itemWidth) && base.moveDirection() === \"right\") {\n                        if (base.options.scrollPerPage === true) {\n                            closest = array[i + 1] || array[array.length - 1];\n                            base.currentItem = $.inArray(closest, base.positionsInArray);\n                        } else {\n                            closest = array[i + 1];\n                            base.currentItem = i + 1;\n                        }\n                    }\n                });\n                return base.currentItem;\n            },\n            moveDirection: function () {\n                var base = this,\n                        direction;\n                if (base.newRelativeX < 0) {\n                    direction = \"right\";\n                    base.playDirection = \"next\";\n                } else {\n                    direction = \"left\";\n                    base.playDirection = \"prev\";\n                }\n                return direction;\n            },\n            customEvents: function () {\n                /*jslint unparam: true*/\n                var base = this;\n                base.$elem.on(\"owl.next\", function () {\n                    base.next();\n                });\n                base.$elem.on(\"owl.prev\", function () {\n                    base.prev();\n                });\n                base.$elem.on(\"owl.play\", function (event, speed) {\n                    base.options.autoPlay = speed;\n                    base.play();\n                    base.hoverStatus = \"play\";\n                });\n                base.$elem.on(\"owl.stop\", function () {\n                    base.stop();\n                    base.hoverStatus = \"stop\";\n                });\n                base.$elem.on(\"owl.goTo\", function (event, item) {\n                    base.goTo(item);\n                });\n                base.$elem.on(\"owl.jumpTo\", function (event, item) {\n                    base.jumpTo(item);\n                });\n            },\n            stopOnHover: function () {\n                var base = this;\n                if (base.options.stopOnHover === true && base.browser.isTouch !== true && base.options.autoPlay !== false) {\n                    base.$elem.on(\"mouseover\", function () {\n                        base.stop();\n                    });\n                    base.$elem.on(\"mouseout\", function () {\n                        if (base.hoverStatus !== \"stop\") {\n                            base.play();\n                        }\n                    });\n                }\n            },\n            lazyLoad: function () {\n                var base = this,\n                        i,\n                        $item,\n                        itemNumber,\n                        $lazyImg,\n                        follow;\n\n                if (base.options.lazyLoad === false) {\n                    return false;\n                }\n                for (i = 0; i < base.itemsAmount; i += 1) {\n                    $item = $(base.$owlItems[i]);\n\n                    if ($item.data(\"owl-loaded\") === \"loaded\") {\n                        continue;\n                    }\n\n                    itemNumber = $item.data(\"owl-item\");\n                    $lazyImg = $item.find(\".lazyOwl\");\n\n                    if (typeof $lazyImg.data(\"src\") !== \"string\") {\n                        $item.data(\"owl-loaded\", \"loaded\");\n                        continue;\n                    }\n                    if ($item.data(\"owl-loaded\") === undefined) {\n                        $lazyImg.hide();\n                        $item.addClass(\"loading\").data(\"owl-loaded\", \"checked\");\n                    }\n                    if (base.options.lazyFollow === true) {\n                        follow = itemNumber >= base.currentItem;\n                    } else {\n                        follow = true;\n                    }\n                    if (follow && itemNumber < base.currentItem + base.options.items && $lazyImg.length) {\n                        base.lazyPreload($item, $lazyImg);\n                    }\n                }\n            },\n            lazyPreload: function ($item, $lazyImg) {\n                var base = this,\n                        iterations = 0,\n                        isBackgroundImg;\n\n                if ($lazyImg.prop(\"tagName\") === \"DIV\") {\n                    $lazyImg.css(\"background-image\", \"url(\" + $lazyImg.data(\"src\") + \")\");\n                    isBackgroundImg = true;\n                } else {\n                    $lazyImg[0].src = $lazyImg.data(\"src\");\n                }\n\n                function showImage() {\n                    $item.data(\"owl-loaded\", \"loaded\").removeClass(\"loading\");\n                    $lazyImg.removeAttr(\"data-src\");\n                    if (base.options.lazyEffect === \"fade\") {\n                        $lazyImg.fadeIn(400);\n                    } else {\n                        $lazyImg.show();\n                    }\n                    if (typeof base.options.afterLazyLoad === \"function\") {\n                        base.options.afterLazyLoad.apply(this, [base.$elem]);\n                    }\n                }\n\n                function checkLazyImage() {\n                    iterations += 1;\n                    if (base.completeImg($lazyImg.get(0)) || isBackgroundImg === true) {\n                        showImage();\n                    } else if (iterations <= 100) {//if image loads in less than 10 seconds \n                        window.setTimeout(checkLazyImage, 100);\n                    } else {\n                        showImage();\n                    }\n                }\n\n                checkLazyImage();\n            },\n            autoHeight: function () {\n                var base = this,\n                        $currentimg = $(base.$owlItems[base.currentItem]).find(\"img\"),\n                        iterations;\n\n                function addHeight() {\n                    var $currentItem = $(base.$owlItems[base.currentItem]).height();\n                    base.wrapperOuter.css(\"height\", $currentItem + \"px\");\n                    if (!base.wrapperOuter.hasClass(\"autoHeight\")) {\n                        window.setTimeout(function () {\n                            base.wrapperOuter.addClass(\"autoHeight\");\n                        }, 0);\n                    }\n                }\n\n                function checkImage() {\n                    iterations += 1;\n                    if (base.completeImg($currentimg.get(0))) {\n                        addHeight();\n                    } else if (iterations <= 100) { //if image loads in less than 10 seconds \n                        window.setTimeout(checkImage, 100);\n                    } else {\n                        base.wrapperOuter.css(\"height\", \"\"); //Else remove height attribute\n                    }\n                }\n\n                if ($currentimg.get(0) !== undefined) {\n                    iterations = 0;\n                    checkImage();\n                } else {\n                    addHeight();\n                }\n            },\n            completeImg: function (img) {\n                var naturalWidthType;\n\n                if (!img.complete) {\n                    return false;\n                }\n                naturalWidthType = typeof img.naturalWidth;\n                if (naturalWidthType !== \"undefined\" && img.naturalWidth === 0) {\n                    return false;\n                }\n                return true;\n            },\n            onVisibleItems: function () {\n                var base = this,\n                        i;\n\n                if (base.options.addClassActive === true) {\n                    base.$owlItems.removeClass(\"active\");\n                }\n                base.visibleItems = [];\n                for (i = base.currentItem; i < base.currentItem + base.options.items; i += 1) {\n                    base.visibleItems.push(i);\n\n                    if (base.options.addClassActive === true) {\n                        $(base.$owlItems[i]).addClass(\"active\");\n                    }\n                }\n                base.owl.visibleItems = base.visibleItems;\n            },\n            transitionTypes: function (className) {\n                var base = this;\n                //Currently available: \"fade\", \"backSlide\", \"goDown\", \"fadeUp\"\n                base.outClass = \"owl-\" + className + \"-out\";\n                base.inClass = \"owl-\" + className + \"-in\";\n            },\n            singleItemTransition: function () {\n                var base = this,\n                        outClass = base.outClass,\n                        inClass = base.inClass,\n                        $currentItem = base.$owlItems.eq(base.currentItem),\n                        $prevItem = base.$owlItems.eq(base.prevItem),\n                        prevPos = Math.abs(base.positionsInArray[base.currentItem]) + base.positionsInArray[base.prevItem],\n                        origin = Math.abs(base.positionsInArray[base.currentItem]) + base.itemWidth / 2,\n                        animEnd = 'webkitAnimationEnd oAnimationEnd MSAnimationEnd animationend';\n\n                base.isTransition = true;\n\n                base.$owlWrapper\n                        .addClass('owl-origin')\n                        .css({\n                            \"-webkit-transform-origin\": origin + \"px\",\n                            \"-moz-perspective-origin\": origin + \"px\",\n                            \"perspective-origin\": origin + \"px\"\n                        });\n                function transStyles(prevPos) {\n                    return {\n                        \"position\": \"relative\",\n                        \"left\": prevPos + \"px\"\n                    };\n                }\n\n                $prevItem\n                        .css(transStyles(prevPos, 10))\n                        .addClass(outClass)\n                        .on(animEnd, function () {\n                            base.endPrev = true;\n                            $prevItem.off(animEnd);\n                            base.clearTransStyle($prevItem, outClass);\n                        });\n\n                $currentItem\n                        .addClass(inClass)\n                        .on(animEnd, function () {\n                            base.endCurrent = true;\n                            $currentItem.off(animEnd);\n                            base.clearTransStyle($currentItem, inClass);\n                        });\n            },\n            clearTransStyle: function (item, classToRemove) {\n                var base = this;\n                item.css({\n                    \"position\": \"\",\n                    \"left\": \"\"\n                }).removeClass(classToRemove);\n\n                if (base.endPrev && base.endCurrent) {\n                    base.$owlWrapper.removeClass('owl-origin');\n                    base.endPrev = false;\n                    base.endCurrent = false;\n                    base.isTransition = false;\n                }\n            },\n            owlStatus: function () {\n                var base = this;\n                base.owl = {\n                    \"userOptions\": base.userOptions,\n                    \"baseElement\": base.$elem,\n                    \"userItems\": base.$userItems,\n                    \"owlItems\": base.$owlItems,\n                    \"currentItem\": base.currentItem,\n                    \"prevItem\": base.prevItem,\n                    \"visibleItems\": base.visibleItems,\n                    \"isTouch\": base.browser.isTouch,\n                    \"browser\": base.browser,\n                    \"dragDirection\": base.dragDirection\n                };\n            },\n            clearEvents: function () {\n                var base = this;\n                base.$elem.off(\".owl owl mousedown.disableTextSelect\");\n                $(document).off(\".owl owl\");\n                $(window).off(\"resize\", base.resizer);\n            },\n            unWrap: function () {\n                var base = this;\n                if (base.$elem.children().length !== 0) {\n                    base.$owlWrapper.unwrap();\n                    base.$userItems.unwrap().unwrap();\n                    if (base.owlControls) {\n                        base.owlControls.remove();\n                    }\n                }\n                base.clearEvents();\n                base.$elem\n                        .attr(\"style\", base.$elem.data(\"owl-originalStyles\") || \"\")\n                        .attr(\"class\", base.$elem.data(\"owl-originalClasses\"));\n            },\n            destroy: function () {\n                var base = this;\n                base.stop();\n                window.clearInterval(base.checkVisible);\n                base.unWrap();\n                base.$elem.removeData();\n            },\n            reinit: function (newOptions) {\n                var base = this,\n                        options = $.extend({}, base.userOptions, newOptions);\n                base.unWrap();\n                base.init(options, base.$elem);\n            },\n            addItem: function (htmlString, targetPosition) {\n                var base = this,\n                        position;\n\n                if (!htmlString) {\n                    return false;\n                }\n\n                if (base.$elem.children().length === 0) {\n                    base.$elem.append(htmlString);\n                    base.setVars();\n                    return false;\n                }\n                base.unWrap();\n                if (targetPosition === undefined || targetPosition === -1) {\n                    position = -1;\n                } else {\n                    position = targetPosition;\n                }\n                if (position >= base.$userItems.length || position === -1) {\n                    base.$userItems.eq(-1).after(htmlString);\n                } else {\n                    base.$userItems.eq(position).before(htmlString);\n                }\n\n                base.setVars();\n            },\n            removeItem: function (targetPosition) {\n                var base = this,\n                        position;\n\n                if (base.$elem.children().length === 0) {\n                    return false;\n                }\n                if (targetPosition === undefined || targetPosition === -1) {\n                    position = -1;\n                } else {\n                    position = targetPosition;\n                }\n\n                base.unWrap();\n                base.$userItems.eq(position).remove();\n                base.setVars();\n            }\n\n        };\n\n        $.fn.owlCarousel = function (options) {\n            return this.each(function () {\n                if ($(this).data(\"owl-init\") === true) {\n                    return false;\n                }\n                $(this).data(\"owl-init\", true);\n                var carousel = Object.create(Carousel);\n                carousel.init(options, this);\n                $.data(this, \"owlCarousel\", carousel);\n            });\n        };\n\n        $.fn.owlCarousel.options = {\n            items: 5,\n            itemsCustom: false,\n            itemsDesktop: [1199, 4],\n            itemsDesktopSmall: [979, 3],\n            itemsTablet: [768, 2],\n            itemsTabletSmall: false,\n            itemsMobile: [479, 1],\n            singleItem: false,\n            itemsScaleUp: false,\n            slideSpeed: 200,\n            paginationSpeed: 800,\n            rewindSpeed: 1000,\n            autoPlay: false,\n            stopOnHover: false,\n            navigation: false,\n            navigationText: [\"prev\", \"next\"],\n            rewindNav: true,\n            scrollPerPage: false,\n            pagination: true,\n            paginationNumbers: false,\n            responsive: true,\n            responsiveRefreshRate: 200,\n            responsiveBaseWidth: window,\n            baseClass: \"owl-carousel\",\n            theme: \"owl-theme\",\n            lazyLoad: false,\n            lazyFollow: true,\n            lazyEffect: \"fade\",\n            autoHeight: false,\n            jsonPath: false,\n            jsonSuccess: false,\n            dragBeforeAnimFinish: true,\n            mouseDrag: true,\n            touchDrag: true,\n            addClassActive: false,\n            transitionStyle: false,\n            beforeUpdate: false,\n            afterUpdate: false,\n            beforeInit: false,\n            afterInit: false,\n            beforeMove: false,\n            afterMove: false,\n            afterAction: false,\n            startDragging: false,\n            afterLazyLoad: false\n        };\n    }(jQuery, window, document));\n});","Magento_Usps/js/model/shipping-rates-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mageUtils',\n    './shipping-rates-validation-rules',\n    'mage/translate'\n], function ($, utils, validationRules, $t) {\n    'use strict';\n\n    var checkoutConfig = window.checkoutConfig;\n\n    return {\n        validationErrors: [],\n\n        /**\n         * @param {Object} address\n         * @return {Boolean}\n         */\n        validate: function (address) {\n            var rules = validationRules.getRules(),\n                self = this;\n\n            $.each(rules, function (field, rule) {\n                var message;\n\n                if (rule.required && utils.isEmpty(address[field])) {\n                    message = $t('Field ') + field + $t(' is required.');\n                    self.validationErrors.push(message);\n                }\n            });\n\n            if (!this.validationErrors.length) {\n                if (address['country_id'] == checkoutConfig.originCountryCode) { //eslint-disable-line eqeqeq\n                    return !utils.isEmpty(address.postcode);\n                }\n\n                return true;\n            }\n\n            return false;\n        }\n    };\n});\n","Magento_Usps/js/model/shipping-rates-validation-rules.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return {\n        /**\n         * @return {Object}\n         */\n        getRules: function () {\n            return {\n                'country_id': {\n                    'required': true\n                },\n                'postcode': {\n                    'required': false\n                }\n            };\n        }\n    };\n});\n","Magento_Usps/js/view/shipping-rates-validation.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Checkout/js/model/shipping-rates-validator',\n    'Magento_Checkout/js/model/shipping-rates-validation-rules',\n    '../model/shipping-rates-validator',\n    '../model/shipping-rates-validation-rules'\n], function (\n    Component,\n    defaultShippingRatesValidator,\n    defaultShippingRatesValidationRules,\n    uspsShippingRatesValidator,\n    uspsShippingRatesValidationRules\n) {\n    'use strict';\n\n    defaultShippingRatesValidator.registerValidator('usps', uspsShippingRatesValidator);\n    defaultShippingRatesValidationRules.registerRules('usps', uspsShippingRatesValidationRules);\n\n    return Component;\n});\n","Magento_OfflineShipping/js/model/shipping-rates-validator/freeshipping.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mageUtils',\n    '../shipping-rates-validation-rules/freeshipping',\n    'mage/translate'\n], function ($, utils, validationRules, $t) {\n    'use strict';\n\n    return {\n        validationErrors: [],\n\n        /**\n         * @param {Object} address\n         * @return {Boolean}\n         */\n        validate: function (address) {\n            var self = this;\n\n            this.validationErrors = [];\n            $.each(validationRules.getRules(), function (field, rule) {\n                var message;\n\n                if (rule.required && utils.isEmpty(address[field])) {\n                    message = $t('Field ') + field + $t(' is required.');\n                    self.validationErrors.push(message);\n                }\n            });\n\n            return !this.validationErrors.length;\n        }\n    };\n});\n","Magento_OfflineShipping/js/model/shipping-rates-validator/flatrate.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mageUtils',\n    '../shipping-rates-validation-rules/flatrate',\n    'mage/translate'\n], function ($, utils, validationRules, $t) {\n    'use strict';\n\n    return {\n        validationErrors: [],\n\n        /**\n         * @param {Object} address\n         * @return {Boolean}\n         */\n        validate: function (address) {\n            var self = this;\n\n            this.validationErrors = [];\n            $.each(validationRules.getRules(), function (field, rule) {\n                var message;\n\n                if (rule.required && utils.isEmpty(address[field])) {\n                    message = $t('Field ') + field + $t(' is required.');\n                    self.validationErrors.push(message);\n                }\n            });\n\n            return !this.validationErrors.length;\n        }\n    };\n});\n","Magento_OfflineShipping/js/model/shipping-rates-validator/tablerate.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mageUtils',\n    '../shipping-rates-validation-rules/tablerate',\n    'mage/translate'\n], function ($, utils, validationRules, $t) {\n    'use strict';\n\n    return {\n        validationErrors: [],\n\n        /**\n         * @param {Object} address\n         * @return {Boolean}\n         */\n        validate: function (address) {\n            var self = this;\n\n            this.validationErrors = [];\n            $.each(validationRules.getRules(), function (field, rule) {\n                var message, regionFields;\n\n                if (rule.required && utils.isEmpty(address[field])) {\n                    message = $t('Field ') + field + $t(' is required.');\n                    regionFields = ['region', 'region_id', 'region_id_input'];\n\n                    if (\n                        $.inArray(field, regionFields) === -1 ||\n                        utils.isEmpty(address.region) && utils.isEmpty(address['region_id'])\n                    ) {\n                        self.validationErrors.push(message);\n                    }\n                }\n            });\n\n            return !this.validationErrors.length;\n        }\n    };\n});\n","Magento_OfflineShipping/js/model/shipping-rates-validation-rules/freeshipping.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return {\n        /**\n         * @return {Object}\n         */\n        getRules: function () {\n            return {\n                'country_id': {\n                    'required': true\n                }\n            };\n        }\n    };\n});\n","Magento_OfflineShipping/js/model/shipping-rates-validation-rules/flatrate.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return {\n        /**\n         * @return {Object}\n         */\n        getRules: function () {\n            return {\n                'country_id': {\n                    'required': true\n                }\n            };\n        }\n    };\n});\n","Magento_OfflineShipping/js/model/shipping-rates-validation-rules/tablerate.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return {\n        /**\n         * @return {Object}\n         */\n        getRules: function () {\n            return {\n                'postcode': {\n                    'required': true\n                },\n                'country_id': {\n                    'required': true\n                },\n                'region_id': {\n                    'required': true\n                },\n                'region_id_input': {\n                    'required': true\n                }\n            };\n        }\n    };\n});\n","Magento_OfflineShipping/js/view/shipping-rates-validation/freeshipping.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Checkout/js/model/shipping-rates-validator',\n    'Magento_Checkout/js/model/shipping-rates-validation-rules',\n    '../../model/shipping-rates-validator/freeshipping',\n    '../../model/shipping-rates-validation-rules/freeshipping'\n], function (\n    Component,\n    defaultShippingRatesValidator,\n    defaultShippingRatesValidationRules,\n    freeshippingShippingRatesValidator,\n    freeshippingShippingRatesValidationRules\n) {\n    'use strict';\n\n    defaultShippingRatesValidator.registerValidator('freeshipping', freeshippingShippingRatesValidator);\n    defaultShippingRatesValidationRules.registerRules('freeshipping', freeshippingShippingRatesValidationRules);\n\n    return Component;\n});\n","Magento_OfflineShipping/js/view/shipping-rates-validation/flatrate.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Checkout/js/model/shipping-rates-validator',\n    'Magento_Checkout/js/model/shipping-rates-validation-rules',\n    '../../model/shipping-rates-validator/flatrate',\n    '../../model/shipping-rates-validation-rules/flatrate'\n], function (\n    Component,\n    defaultShippingRatesValidator,\n    defaultShippingRatesValidationRules,\n    flatrateShippingRatesValidator,\n    flatrateShippingRatesValidationRules\n) {\n    'use strict';\n\n    defaultShippingRatesValidator.registerValidator('flatrate', flatrateShippingRatesValidator);\n    defaultShippingRatesValidationRules.registerRules('flatrate', flatrateShippingRatesValidationRules);\n\n    return Component;\n});\n","Magento_OfflineShipping/js/view/shipping-rates-validation/tablerate.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Checkout/js/model/shipping-rates-validator',\n    'Magento_Checkout/js/model/shipping-rates-validation-rules',\n    '../../model/shipping-rates-validator/tablerate',\n    '../../model/shipping-rates-validation-rules/tablerate'\n], function (\n    Component,\n    defaultShippingRatesValidator,\n    defaultShippingRatesValidationRules,\n    tablerateShippingRatesValidator,\n    tablerateShippingRatesValidationRules\n) {\n    'use strict';\n\n    defaultShippingRatesValidator.registerValidator('tablerate', tablerateShippingRatesValidator);\n    defaultShippingRatesValidationRules.registerRules('tablerate', tablerateShippingRatesValidationRules);\n\n    return Component;\n});\n","Vertex_Tax/js/form/depend-field-checker.js":"/**\n * @copyright  Vertex. All rights reserved.  https://www.vertexinc.com/\n * @author     Mediotype                     https://www.mediotype.com/\n */\n\ndefine([\n    'jquery',\n], function ($) {\n    'use strict';\n\n    return {\n        /**\n         * Makes sure a value is set if its depending field is also set.\n         *\n         * @param dependField\n         * @param valueCheck\n         * @returns {boolean}\n         */\n        validateValues : function (dependField, valueCheck) {\n            if ($(dependField).length) {\n                let dependValue = $(dependField).val();\n\n                return !(dependValue && !valueCheck);\n            }\n\n            return true;\n        }\n    };\n});\n","Vertex_Tax/js/form/element/custom-option-flex-field-select.js":"/*\n * @copyright  Vertex. All rights reserved.  https://www.vertexinc.com/\n * @author     Mediotype                     https://www.mediotype.com/\n */\n\ndefine(['underscore', 'Magento_Ui/js/form/element/select'], function (_, Select) {\n    'use strict';\n\n    return Select.extend({\n        /**\n         * Overwrites the parent's filter to allow for checking if a value is\n         * in an array and for allowing the value of \"unmapped\" through all\n         * filters\n         *\n         * @param {String} value\n         * @param {String} field\n         */\n        filter: function (value, field) {\n            var source = this.initialOptions,\n                result;\n\n            field = field || this.filterBy.field;\n\n            result = _.filter(source, function (item) {\n                return Array.isArray(item[field]) && item[field].includes(value) ||\n                    item[field] === value ||\n                    item.value === '' ||\n                    item.value === 'unmapped';\n            });\n\n            this.setOptions(result);\n        }\n    });\n});\n","Vertex_Tax/js/model/customer-country-validation.js":"/**\n * @copyright  Vertex. All rights reserved.  https://www.vertexinc.com/\n * @author     Mediotype                     https://www.mediotype.com/\n */\n\ndefine([\n    'jquery',\n    'Vertex_Tax/js/form/depend-field-checker',\n    'jquery/validate',\n    'mage/translate'\n], function ($, dependFieldChecker) {\n    'use strict';\n\n    /**\n     * Validates if customer added a VAT number, then selecting a Country is required.\n     */\n    return function (config) {\n        $.validator.addMethod(\n            \"vertex-customer-country\",\n            function (value, element, dependField) {\n                return dependFieldChecker.validateValues(dependField, value);\n            },\n            $.mage.__(\"Please select a Country.\")\n        );\n    }\n});\n","Vertex_Tax/js/model/set-checkout-messages.js":"/**\n * @copyright  Vertex. All rights reserved.  https://www.vertexinc.com/\n * @author     Mediotype                     https://www.mediotype.com/\n */\n\ndefine(\n    [\n        'underscore',\n        'Magento_Customer/js/customer-data',\n        'Magento_Ui/js/model/messageList'\n    ],\n    function (_, customerData, messageContainer) {\n        'use strict';\n\n        /**\n         * A utility for observing message updates in session storage. It is designed to subscribe to\n         * customer data updates and forward messages to the appropriate messageList model.\n         */\n        return function () {\n            var typeMap = {\n                    'success': 'addSuccessMessage',\n                    'warning': 'addErrorMessage',\n                    'error': 'addErrorMessage'\n                },\n\n                /**\n                 * Observe message section data changes and forward to the error processor.\n                 * @param {Object} data - The observable payload.\n                 * @return void\n                 */\n                messageSubscriptionCallback = function (data) {\n                    if ('messages' in data) {\n                        _.each(data.messages, function (message) {\n                            if (message.type in typeMap) {\n                                messageContainer[typeMap[message.type]]({\n                                    'message': message.text\n                                });\n                            }\n                        });\n                    }\n                };\n\n            customerData.get('messages').subscribe(messageSubscriptionCallback);\n        };\n    }\n);\n","Vertex_Tax/js/view/checkout/summary/tax-messages.js":"/**\n * @copyright  Vertex. All rights reserved.  https://www.vertexinc.com/\n * @author     Mediotype                     https://www.mediotype.com/\n */\n\ndefine([\n    'underscore',\n    'ko',\n    'uiComponent',\n    'Magento_Checkout/js/model/totals'\n], function (_, ko, Component, totals) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            messages: []\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            this.subscribeTotals();\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super().observe('messages');\n            this.getMessages();\n\n            return this;\n        },\n\n        /**\n         * Retrieve messages\n         */\n        getMessages: function () {\n            var taxSegment = totals.getSegment('tax');\n\n            this.messages([]);\n\n            if (taxSegment && taxSegment['extension_attributes']) {\n                this.messages(taxSegment['extension_attributes']['vertex_tax_calculation_messages']);\n            }\n        },\n\n        /**\n         * Subscribe totals observer\n         */\n        subscribeTotals: function () {\n            var self = this;\n\n            totals.totals.subscribe(\n                function () {\n                    self.getMessages();\n                },\n                null,\n                'change'\n            );\n        }\n    });\n});\n","Magento_ProductVideo/js/fotorama-add-video-events.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget',\n    'catalogGallery',\n    'loadPlayer'\n], function ($) {\n    'use strict';\n\n    /**\n     * @private\n     */\n    var allowBase = true; //global var is needed because fotorama always fully reloads events in case of fullscreen\n\n    /**\n     * @private\n     */\n    function parseHref(href) {\n        var a = document.createElement('a');\n\n        a.href = href;\n\n        return a;\n    }\n\n    /**\n     * @private\n     */\n    function parseURL(href, forceVideo) {\n        var id,\n            type,\n            ampersandPosition,\n            vimeoRegex,\n            useYoutubeNocookie = false;\n\n        /**\n         * Get youtube ID\n         * @param {String} srcid\n         * @returns {{}}\n         */\n        function _getYoutubeId(srcid) {\n            if (srcid) {\n                ampersandPosition = srcid.indexOf('&');\n\n                if (ampersandPosition === -1) {\n                    return srcid;\n                }\n\n                srcid = srcid.substring(0, ampersandPosition);\n            }\n\n            return srcid;\n        }\n\n        if (typeof href !== 'string') {\n            return href;\n        }\n\n        href = parseHref(href);\n\n        if (href.host.match(/youtube\\.com/) && href.search) {\n            id = href.search.split('v=')[1];\n\n            if (id) {\n                id = _getYoutubeId(id);\n                type = 'youtube';\n            }\n        } else if (href.host.match(/youtube\\.com|youtu\\.be|youtube-nocookie.com/)) {\n            id = href.pathname.replace(/^\\/(embed\\/|v\\/)?/, '').replace(/\\/.*/, '');\n            type = 'youtube';\n\n            if (href.host.match(/youtube-nocookie.com/)) {\n                useYoutubeNocookie = true;\n            }\n        } else if (href.host.match(/vimeo\\.com/)) {\n            type = 'vimeo';\n            vimeoRegex = new RegExp(['https?:\\\\/\\\\/(?:www\\\\.|player\\\\.)?vimeo.com\\\\/(?:channels\\\\/(?:\\\\w+\\\\/)',\n                '?|groups\\\\/([^\\\\/]*)\\\\/videos\\\\/|album\\\\/(\\\\d+)\\\\/video\\\\/|video\\\\/|)(\\\\d+)(?:$|\\\\/|\\\\?)'\n            ].join(''));\n            id = href.href.match(vimeoRegex)[3];\n        }\n\n        if ((!id || !type) && forceVideo) {\n            id = href.href;\n            type = 'custom';\n        }\n\n        return id ? {\n            id: id, type: type, s: href.search.replace(/^\\?/, ''), useYoutubeNocookie: useYoutubeNocookie\n        } : false;\n    }\n\n    //create AddFotoramaVideoEvents widget\n    $.widget('mage.AddFotoramaVideoEvents', {\n        options: {\n            videoData: '',\n            videoSettings: '',\n            optionsVideoData: '',\n            dataMergeStrategy: 'replace',\n            vimeoJSFrameworkLoaded: false\n        },\n\n        /**\n         * @private\n         */\n        onVimeoJSFramework: function () {},\n        defaultVideoData: [],\n        PV: 'product-video', // [CONST]\n        VU: 'video-unplayed',\n        PVLOADED: 'fotorama__product-video--loaded', // [CONST]\n        PVLOADING: 'fotorama__product-video--loading', // [CONST]\n        VID: 'video', // [CONST]\n        VI: 'vimeo', // [CONST]\n        FTVC: 'fotorama__video-close',\n        FTAR: 'fotorama__arr',\n        fotoramaSpinner: 'fotorama__spinner',\n        fotoramaSpinnerShow: 'fotorama__spinner--show',\n        TI: 'video-thumb-icon',\n        isFullscreen: false,\n        FTCF: '[data-gallery-role=\"fotorama__fullscreen-icon\"]',\n        Base: 0, //on check for video is base this setting become true if there is any video with base role\n        MobileMaxWidth: 767,\n        GP: 'gallery-placeholder', //gallery placeholder class is needed to find and erase <script> tag\n        videoData: null,\n        videoDataPlaceholder: [{\n            id: '',\n            isBase: true,\n            mediaType: 'image',\n            provider: ''\n        }],\n\n        /**\n         * Creates widget\n         * @private\n         */\n        _create: function () {\n            $(this.element).data('gallery') ?\n                this._onGalleryLoaded() :\n                $(this.element).on('gallery:loaded', this._onGalleryLoaded.bind(this));\n        },\n\n        /**\n         *\n         * @private\n         */\n        _initialize: function () {\n            if (!this.defaultVideoData.length) {\n                this.defaultVideoData = this.options.videoData;\n            }\n\n            // If product does not have images, no video data generated,\n            // but for configurable product we still need a video data, in case of 'prepend' gallery strategy.\n            if (!this.defaultVideoData.length && !this.options.videoData.length) {\n                this.defaultVideoData = this.options.videoData = this.videoDataPlaceholder;\n            }\n\n            this.clearEvents();\n\n            if (this._checkForVideoExist()) {\n                this._checkFullscreen();\n                this._listenForFullscreen();\n                this._checkForVimeo();\n                this._isVideoBase();\n                this._initFotoramaVideo();\n                this._attachFotoramaEvents();\n            }\n        },\n\n        /**\n         * Callback which fired after gallery gets initialized.\n         */\n        _onGalleryLoaded: function () {\n            this.fotoramaItem = $(this.element).find('.fotorama-item');\n            this._initialize();\n        },\n\n        /**\n         * Clear gallery events to prevent duplicated calls.\n         *\n         * @private\n         */\n        clearEvents: function () {\n            if (this.fotoramaItem !== undefined) {\n                this.fotoramaItem.off(\n                    'fotorama:show.' + this.PV +\n                    ' fotorama:showend.' + this.PV +\n                    ' fotorama:fullscreenenter.' + this.PV +\n                    ' fotorama:fullscreenexit.' + this.PV\n                );\n            }\n        },\n\n        /**\n         *\n         * @param {Object} options\n         * @private\n         */\n        _setOptions: function (options) {\n            if (options.videoData && options.videoData.length) {\n                this.options.videoData = options.videoData;\n            }\n\n            this._loadVideoData(options);\n            this._initialize();\n        },\n\n        /**\n         * Set video data for configurable product.\n         *\n         * @param {Object} options\n         * @private\n         */\n        _loadVideoData: function (options) {\n            if (options.selectedOption) {\n                if (options.dataMergeStrategy === 'prepend') {\n                    this.options.videoData = [].concat(\n                        this.options.optionsVideoData[options.selectedOption],\n                        this.defaultVideoData\n                    );\n                } else {\n                    this.options.videoData = this.options.optionsVideoData[options.selectedOption];\n                }\n            } else {\n                this.options.videoData = this.defaultVideoData;\n            }\n        },\n\n        /**\n         *\n         * @private\n         */\n        _checkFullscreen: function () {\n            if (this.fotoramaItem.data('fotorama').fullScreen || false) {\n                this.isFullscreen = true;\n            }\n        },\n\n        /**\n         *\n         * @private\n         */\n        _listenForFullscreen: function () {\n            this.fotoramaItem.on('fotorama:fullscreenenter.' + this.PV, $.proxy(function () {\n                this.isFullscreen = true;\n            }, this));\n\n            this.fotoramaItem.on('fotorama:fullscreenexit.' + this.PV, $.proxy(function () {\n                this.isFullscreen = false;\n                this._hideVideoArrows();\n            }, this));\n        },\n\n        /**\n         *\n         * @param {Object} inputData\n         * @param {bool} isJSON\n         * @returns {{}}\n         * @private\n         */\n        _createVideoData: function (inputData, isJSON) {\n            var videoData = [],\n                dataUrl,\n                tmpVideoData,\n                tmpInputData,\n                i;\n\n            if (isJSON) {\n                inputData = $.parseJSON(inputData);\n            }\n\n            for (i = 0; i < inputData.length; i++) {\n                tmpInputData = inputData[i];\n                dataUrl = '';\n                tmpVideoData = {\n                    mediaType: '',\n                    isBase: '',\n                    id: '',\n                    provider: ''\n                };\n                tmpVideoData.mediaType = this.VID;\n\n                if (tmpInputData.mediaType !== 'external-video') {\n                    tmpVideoData.mediaType = tmpInputData.mediaType;\n                }\n\n                tmpVideoData.isBase = tmpInputData.isBase;\n\n                if (tmpInputData.videoUrl && tmpInputData.videoUrl !== null) {\n                    dataUrl = tmpInputData.videoUrl;\n                    dataUrl = parseURL(dataUrl);\n                    tmpVideoData.id = dataUrl.id;\n                    tmpVideoData.provider = dataUrl.type;\n                    tmpVideoData.videoUrl = tmpInputData.videoUrl;\n                    tmpVideoData.useYoutubeNocookie = dataUrl.useYoutubeNocookie;\n                }\n\n                videoData.push(tmpVideoData);\n            }\n\n            return videoData;\n        },\n\n        /**\n         *\n         * @param {Object} fotorama\n         * @param {bool} isBase\n         * @private\n         */\n        _createCloseVideo: function (fotorama, isBase) {\n            var closeVideo;\n\n            this.fotoramaItem.find('.' + this.FTVC).remove();\n            this.fotoramaItem.append('<div class=\"' + this.FTVC + '\"></div>');\n            this.fotoramaItem.css('position', 'relative');\n            closeVideo = this.fotoramaItem.find('.' + this.FTVC);\n            this._closeVideoSetEvents(closeVideo, fotorama);\n\n            if (\n                isBase &&\n                this.options.videoData[fotorama.activeIndex].isBase &&\n                $(window).width() > this.MobileMaxWidth) {\n                this._showCloseVideo();\n            }\n        },\n\n        /**\n         *\n         * @private\n         */\n        _hideCloseVideo: function () {\n            this.fotoramaItem\n                .find('.' + this.FTVC)\n                .removeClass('fotorama-show-control');\n        },\n\n        /**\n         *\n         * @private\n         */\n        _showCloseVideo: function () {\n            this.fotoramaItem\n                .find('.' + this.FTVC)\n                .addClass('fotorama-show-control');\n        },\n\n        /**\n         *\n         * @param {jQuery} $closeVideo\n         * @param {jQuery} fotorama\n         * @private\n         */\n        _closeVideoSetEvents: function ($closeVideo, fotorama) {\n            $closeVideo.on('click', $.proxy(function () {\n                this._unloadVideoPlayer(fotorama.activeFrame.$stageFrame.parent(), fotorama, true);\n                this._hideCloseVideo();\n            }, this));\n        },\n\n        /**\n         *\n         * @returns {Boolean}\n         * @private\n         */\n        _checkForVideoExist: function () {\n            var key, result, checker, videoSettings;\n\n            if (!this.options.videoData) {\n                return false;\n            }\n\n            if (!this.options.videoSettings) {\n                return false;\n            }\n\n            result = this._createVideoData(this.options.videoData, false);\n            checker = false;\n            videoSettings = this.options.videoSettings[0];\n            videoSettings.playIfBase = parseInt(videoSettings.playIfBase, 10);\n            videoSettings.showRelated = parseInt(videoSettings.showRelated, 10);\n            videoSettings.videoAutoRestart = parseInt(videoSettings.videoAutoRestart, 10);\n\n            for (key in result) {\n                if (result[key].mediaType === this.VID) {\n                    checker = true;\n                }\n            }\n\n            if (checker) {\n                this.options.videoData = result;\n            }\n\n            return checker;\n        },\n\n        /**\n         *\n         * @private\n         */\n        _checkForVimeo: function () {\n            var allVideoData = this.options.videoData,\n                videoItem;\n\n            if (window.Froogaloop) { // prevent duplicated initialization\n                return;\n            }\n\n            for (videoItem in allVideoData) {\n                if (allVideoData[videoItem].provider === this.VI) {\n                    this._loadVimeoJSFramework();\n\n                    return;\n                }\n            }\n        },\n\n        /**\n         *\n         * @private\n         */\n        _isVideoBase: function () {\n            var allVideoData = this.options.videoData,\n                videoItem,\n                allVideoDataKeys,\n                key,\n                i;\n\n            allVideoDataKeys = Object.keys(allVideoData);\n\n            for (i = 0; i < allVideoDataKeys.length; i++) {\n                key = allVideoDataKeys[i];\n                videoItem = allVideoData[key];\n\n                if (\n                    videoItem.mediaType === this.VID && videoItem.isBase &&\n                    this.options.videoSettings[0].playIfBase && allowBase\n                ) {\n                    this.Base = true;\n                    allowBase = false;\n                }\n            }\n\n            if (!this.isFullscreen) {\n                this._createCloseVideo(this.fotoramaItem.data('fotorama'), this.Base);\n            }\n        },\n\n        /**\n         *\n         * @private\n         */\n        _loadVimeoJSFramework: function () {\n            var element = document.createElement('script'),\n                scriptTag = document.getElementsByTagName('script')[0];\n\n            element.async = true;\n            element.src = 'https://f.vimeocdn.com/js/froogaloop2.min.js';\n\n            /**\n             * Vimeo js framework on load callback.\n             */\n            element.onload = function () {\n                this.onVimeoJSFramework();\n                this.vimeoJSFrameworkLoaded = true;\n            }.bind(this);\n            scriptTag.parentNode.insertBefore(element, scriptTag);\n        },\n\n        /**\n         *\n         * @param {Event} e\n         * @private\n         */\n        _initFotoramaVideo: function (e) {\n            var fotorama = this.fotoramaItem.data('fotorama'),\n                thumbsParent,\n                thumbs,\n                t;\n\n            if (!fotorama.activeFrame.$navThumbFrame) {\n                this.fotoramaItem.on('fotorama:showend.' + this.PV, $.proxy(function (evt, fotoramaData) {\n                    $(fotoramaData.activeFrame.$stageFrame).removeAttr('href');\n                }, this));\n\n                this._startPrepareForPlayer(e, fotorama);\n\n                return null;\n            }\n\n            fotorama.data.map($.proxy(this._setItemType, this));\n            thumbsParent = fotorama.activeFrame.$navThumbFrame.parent();\n            thumbs = thumbsParent.find('.fotorama__nav__frame:visible');\n\n            for (t = 0; t < thumbs.length; t++) {\n                this._setThumbsIcon(thumbs.eq(t), t);\n                this._checkForVideo(e, fotorama, t + 1);\n            }\n\n            this.fotoramaItem.on('fotorama:showend.' + this.PV, $.proxy(function (evt, fotoramaData) {\n                $(fotoramaData.activeFrame.$stageFrame).removeAttr('href');\n            }, this));\n        },\n\n        /**\n         *\n         * @param {Object} elem\n         * @param {Number} i\n         * @private\n         */\n        _setThumbsIcon: function (elem, i) {\n            var fotorama = this.fotoramaItem.data('fotorama');\n\n            if (fotorama.options.nav === 'dots' && elem.hasClass(this.TI)) {\n                elem.removeClass(this.TI);\n            }\n\n            if (this.options.videoData[i].mediaType === this.VID &&\n                fotorama.data[i].type ===  this.VID &&\n                fotorama.options.nav === 'thumbs') {\n                elem.addClass(this.TI);\n            }\n        },\n\n        /**\n         * Temporary solution with adding types for configurable product items\n         *\n         * @param {Object} item\n         * @param {Number} i\n         * @private\n         */\n        _setItemType: function (item, i) {\n            !item.type && (item.type = this.options.videoData[i].mediaType);\n        },\n\n        /**\n         * Attach\n         *\n         * @private\n         */\n        _attachFotoramaEvents: function () {\n            this.fotoramaItem.on('fotorama:showend.' + this.PV, $.proxy(function (e, fotorama) {\n                this._startPrepareForPlayer(e, fotorama);\n            }, this));\n\n            this.fotoramaItem.on('fotorama:show.' + this.PV, $.proxy(function (e, fotorama) {\n                this._unloadVideoPlayer(fotorama.activeFrame.$stageFrame.parent(), fotorama, true);\n            }, this));\n\n            this.fotoramaItem.on('fotorama:fullscreenexit.' + this.PV, $.proxy(function (e, fotorama) {\n                fotorama.activeFrame.$stageFrame.find('.' + this.PV).remove();\n                this._startPrepareForPlayer(e, fotorama);\n            }, this));\n        },\n\n        /**\n         * Start prepare for player\n         *\n         * @param {Event} e\n         * @param {jQuery} fotorama\n         * @private\n         */\n        _startPrepareForPlayer: function (e, fotorama) {\n            this._unloadVideoPlayer(fotorama.activeFrame.$stageFrame.parent(), fotorama, false);\n            this._checkForVideo(e, fotorama, fotorama.activeFrame.i);\n            this._checkForVideo(e, fotorama, fotorama.activeFrame.i - 1);\n            this._checkForVideo(e, fotorama, fotorama.activeFrame.i + 1);\n        },\n\n        /**\n         * Check for video\n         *\n         * @param {Event} e\n         * @param {jQuery} fotorama\n         * @param {Number} number\n         * @private\n         */\n        _checkForVideo: function (e, fotorama, number) {\n            var videoData = this.options.videoData[number - 1],\n                $image = fotorama.data[number - 1];\n\n            if ($image) {\n                !$image.type && this._setItemType($image, number - 1);\n\n                if ($image.type === 'image') {\n                    $image.$navThumbFrame && $image.$navThumbFrame.removeClass(this.TI);\n                    this._hideCloseVideo();\n\n                    return;\n                } else if ($image.$navThumbFrame && $image.type === 'video') {\n                    !$image.$navThumbFrame.hasClass(this.TI) && $image.$navThumbFrame.addClass(this.TI);\n                }\n\n                $image = $image.$stageFrame;\n            }\n\n            if ($image && videoData && videoData.mediaType === this.VID) {\n                $(fotorama.activeFrame.$stageFrame).removeAttr('href');\n                this._prepareForVideoContainer($image, videoData, fotorama, number);\n            }\n\n            if (this.isFullscreen && this.fotoramaItem.data('fotorama').activeFrame.i === number) {\n                this.fotoramaItem.data('fotorama').activeFrame.$stageFrame[0].click();\n            }\n        },\n\n        /**\n         * Prepare for video container\n         *\n         * @param {jQuery} $image\n         * @param {Object} videoData\n         * @param {Object} fotorama\n         * @param {Number} number\n         * @private\n         */\n        _prepareForVideoContainer: function ($image, videoData, fotorama, number) {\n            $image.addClass('fotorama-video-container').addClass(this.VU);\n            this._createVideoContainer(videoData, $image);\n            this._setVideoEvent($image, this.PV, fotorama, number);\n        },\n\n        /**\n         * Create video container\n         *\n         * @param {Object} videoData\n         * @param {jQuery} $image\n         * @private\n         */\n        _createVideoContainer: function (videoData, $image) {\n            var videoSettings;\n\n            videoSettings = this.options.videoSettings[0];\n            $image.find('.' + this.PV).remove();\n            $image.append(\n                '<div class=\"' +\n                this.PV +\n                '\" data-related=\"' +\n                videoSettings.showRelated +\n                '\" data-loop=\"' +\n                videoSettings.videoAutoRestart +\n                '\" data-type=\"' +\n                videoData.provider +\n                '\" data-code=\"' +\n                videoData.id +\n                '\"  data-youtubenocookie=\"' +\n                videoData.useYoutubeNocookie +\n                '\" data-width=\"100%\" data-height=\"100%\"></div>'\n            );\n        },\n\n        /**\n         *\n         * @param {Object} $image\n         * @param {Object} PV\n         * @param {Object} fotorama\n         * @param {Number} number\n         * @private\n         */\n        _setVideoEvent: function ($image, PV, fotorama, number) {\n            $image.find('.magnify-lens').remove();\n            $image\n                .off('click tap', $.proxy(this._clickHandler, this))\n                .on('click tap', $.proxy(this._clickHandler, this));\n            this._handleBaseVideo(fotorama, number); //check for video is it base and handle it if it's base\n        },\n\n        /**\n         * Hides preview arrows above video player.\n         * @private\n         */\n        _hideVideoArrows: function () {\n            var arrows = $('.' + this.FTAR);\n\n            arrows.removeClass('fotorama__arr--shown');\n            arrows.removeClass('fotorama__arr--hidden');\n        },\n\n        /**\n         * @private\n         */\n        _showLoader: function () {\n            var spinner = this.fotoramaItem.find('.' + this.fotoramaSpinner);\n\n            spinner.addClass(this.fotoramaSpinnerShow);\n            this.fotoramaItem.data('fotorama').activeFrame.$stageFrame.addClass(this.PVLOADING);\n        },\n\n        /**\n         * @private\n         */\n        _hideLoader: function () {\n            var spinner = this.fotoramaItem.find('.' + this.fotoramaSpinner);\n\n            spinner.removeClass(this.fotoramaSpinnerShow);\n            this.fotoramaItem.data('fotorama').activeFrame.$stageFrame.removeClass(this.PVLOADING);\n        },\n\n        /**\n         * @param {Event} event\n         * @private\n         */\n        _clickHandler: function (event) {\n            var type;\n\n            if ($(event.target).hasClass(this.VU) && $(event.target).find('iframe').length === 0) {\n                $(event.target).removeClass(this.VU);\n                type = $(event.target).find('.' + this.PV).data('type');\n\n                if (this.vimeoJSFrameworkLoaded && type === this.VI) {\n                    $(event.target).find('.' + this.PV).productVideoLoader();\n                } else if (type === this.VI) {\n                    this._showLoader();\n                    this.onVimeoJSFramework = function () {\n                        $(event.target).find('.' + this.PV).productVideoLoader();\n                        this._hideLoader();\n                    }.bind(this);\n                } else {\n                    $(event.target).find('.' + this.PV).productVideoLoader();\n                }\n\n                $('.' + this.FTAR).addClass(this.isFullscreen ? 'fotorama__arr--shown' : 'fotorama__arr--hidden');\n                $('.' + this.FTVC).addClass('fotorama-show-control');\n            }\n        },\n\n        /**\n         * Handle base video\n         * @param {Object} fotorama\n         * @param {Number} srcNumber\n         * @private\n         */\n        _handleBaseVideo: function (fotorama, srcNumber) {\n            var waitForFroogaloop,\n                videoData = this.options.videoData,\n                activeIndex = fotorama.activeIndex,\n                number = parseInt(srcNumber, 10),\n                activeIndexIsBase = videoData[activeIndex];\n\n            if (!this.Base) {\n                return;\n            }\n\n            if (activeIndexIsBase && number === 1 && $(window).width() > this.MobileMaxWidth) {\n                if (this.options.videoData[fotorama.activeIndex].provider === this.VI) {\n                    waitForFroogaloop = setInterval($.proxy(function () {\n                        if (window.Froogaloop) {\n                            clearInterval(waitForFroogaloop);\n                            fotorama.requestFullScreen();\n                            this.fotoramaItem.data('fotorama').activeFrame.$stageFrame[0].click();\n                            this.Base = false;\n                        }\n                    }, this), 50);\n                } else { //if not a vimeo - play it immediately with a little lag in case for fotorama fullscreen\n                    setTimeout($.proxy(function () {\n                        fotorama.requestFullScreen();\n                        this.fotoramaItem.data('fotorama').activeFrame.$stageFrame[0].click();\n                        this.Base = false;\n                    }, this), 50);\n                }\n            }\n        },\n\n        /**\n         * Destroy video player\n         * @param {jQuery} $wrapper\n         * @param {jQuery} current\n         * @param {bool} close\n         * @private\n         */\n        _unloadVideoPlayer: function ($wrapper, current, close) {\n            var self = this;\n\n            if (!$wrapper) {\n                return;\n            }\n\n            $wrapper.find('.' + this.PVLOADED).removeClass(this.PVLOADED);\n            this._hideLoader();\n\n            $wrapper.find('.' + this.PV).each(function () {\n                var $item = $(this).parent(),\n                    cloneVideoDiv,\n                    iframeElement = $(this).find('iframe'),\n                    currentIndex,\n                    itemIndex;\n\n                if (iframeElement.length === 0) {\n                    return;\n                }\n\n                currentIndex = current.activeFrame.$stageFrame.index();\n                itemIndex = $item.index();\n\n                if (currentIndex === itemIndex && !close) {\n                    return;\n                }\n\n                if (currentIndex !== itemIndex && close) {\n                    return;\n                }\n\n                iframeElement.remove();\n                cloneVideoDiv = $(this).clone();\n                $(this).remove();\n                $item.append(cloneVideoDiv);\n                $item.addClass(self.VU);\n\n                self._hideCloseVideo();\n                self._hideVideoArrows();\n\n                if (self.isFullscreen && !self.fotoramaItem.data('fotorama').options.fullscreen.arrows) {\n                    if ($('.' + self.FTAR + '--prev').is(':focus') || $('.' + self.FTAR + '--next').is(':focus')) {\n                        $(self.FTCF).focus();\n                    }\n                }\n            });\n        }\n    });\n\n    return $.mage.AddFotoramaVideoEvents;\n});\n","Magento_ProductVideo/js/load-player.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n @version 0.0.1\n @requires jQuery & jQuery UI\n */\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    var videoRegister = {\n        _register: {},\n\n        /**\n         * Checks, if api is already registered\n         *\n         * @param {String} api\n         * @returns {bool}\n         */\n        isRegistered: function (api) {\n            return this._register[api] !== undefined;\n        },\n\n        /**\n         * Checks, if api is loaded\n         *\n         * @param {String} api\n         * @returns {bool}\n         */\n        isLoaded: function (api) {\n            return this._register[api] !== undefined && this._register[api] === true;\n        },\n\n        /**\n         * Register new video api\n         * @param {String} api\n         * @param {bool} loaded\n         */\n        register: function (api, loaded) {\n            loaded = loaded || false;\n            this._register[api] = loaded;\n        }\n    };\n\n    $.widget('mage.productVideoLoader', {\n\n        /**\n         * @private\n         */\n        _create: function () {\n            switch (this.element.data('type')) {\n                case 'youtube':\n                    this.element.videoYoutube();\n                    this._player = this.element.data('mageVideoYoutube');\n                    break;\n\n                case 'vimeo':\n                    this.element.videoVimeo();\n                    this._player = this.element.data('mageVideoVimeo');\n                    break;\n                default:\n                    throw {\n                        name: 'Video Error',\n                        message: 'Unknown video type',\n\n                        /**\n                         * join name with message\n                         */\n                        toString: function () {\n                            return this.name + ': ' + this.message;\n                        }\n                    };\n            }\n        },\n\n        /**\n         * Initializes variables\n         * @private\n         */\n        _initialize: function () {\n            this._params = this.element.data('params') || {};\n            this._code = this.element.data('code');\n            this._width = this.element.data('width');\n            this._height = this.element.data('height');\n            this._autoplay = !!this.element.data('autoplay');\n            this._playing = this._autoplay || false;\n            this._loop = this.element.data('loop');\n            this._rel = this.element.data('related');\n            this.useYoutubeNocookie = this.element.data('youtubenocookie') || false;\n\n            this._responsive = this.element.data('responsive') !== false;\n\n            if (this._responsive === true) {\n                this.element.addClass('responsive');\n            }\n\n            this._calculateRatio();\n        },\n\n        /**\n         * Abstract play command\n         */\n        play: function () {\n            this._player.play();\n        },\n\n        /**\n         * Abstract pause command\n         */\n        pause: function () {\n            this._player.pause();\n        },\n\n        /**\n         * Abstract stop command\n         */\n        stop: function () {\n            this._player.stop();\n        },\n\n        /**\n         * Abstract playing command\n         */\n        playing: function () {\n            return this._player.playing();\n        },\n\n        /**\n         * Destroyer\n         */\n        destroy: function () {\n            this._player.destroy();\n        },\n\n        /**\n         * Calculates ratio for responsive videos\n         * @private\n         */\n        _calculateRatio: function () {\n            if (!this._responsive) {\n                return;\n            }\n            this.element.css('paddingBottom', this._height / this._width * 100 + '%');\n        }\n    });\n\n    $.widget('mage.videoYoutube', $.mage.productVideoLoader, {\n\n        /**\n         * Initialization of the Youtube widget\n         * @private\n         */\n        _create: function () {\n            var self = this;\n\n            this._initialize();\n\n            this.element.append('<div/>');\n\n            this._on(window, {\n\n                /**\n                 * Handle event\n                 */\n                'youtubeapiready': function () {\n                    var host = 'https://www.youtube.com';\n\n                    if (self.useYoutubeNocookie) {\n                        host = 'https://www.youtube-nocookie.com';\n                    }\n\n                    if (self._player !== undefined) {\n                        return;\n                    }\n                    self._autoplay = true;\n\n                    if (self._autoplay) {\n                        self._params.autoplay = 1;\n                    }\n\n                    if (!self._rel) {\n                        self._params.rel = 0;\n                    }\n\n                    self._player = new window.YT.Player(self.element.children(':first')[0], {\n                        height: self._height,\n                        width: self._width,\n                        videoId: self._code,\n                        playerVars: self._params,\n                        host: host,\n                        events: {\n\n                            /**\n                             * Get duration\n                             */\n                            'onReady': function onPlayerReady() {\n                                self._player.getDuration();\n                                self.element.closest('.fotorama__stage__frame')\n                                    .addClass('fotorama__product-video--loaded');\n                            },\n\n                            /**\n                             * Event observer\n                             */\n                            onStateChange: function (data) {\n                                switch (window.parseInt(data.data, 10)) {\n                                    case 1:\n                                        self._playing = true;\n                                        break;\n                                    default:\n                                        self._playing = false;\n                                        break;\n                                }\n\n                                self._trigger('statechange', {}, data);\n\n                                if (data.data === window.YT.PlayerState.ENDED && self._loop) {\n                                    self._player.playVideo();\n                                }\n                            }\n                        }\n\n                    });\n                }\n            });\n\n            this._loadApi();\n        },\n\n        /**\n         * Loads Youtube API and triggers event, when loaded\n         * @private\n         */\n        _loadApi: function () {\n            var element,\n                scriptTag;\n\n            if (videoRegister.isRegistered('youtube')) {\n                if (videoRegister.isLoaded('youtube')) {\n                    $(window).trigger('youtubeapiready');\n                }\n\n                return;\n            }\n            videoRegister.register('youtube');\n\n            element = document.createElement('script');\n            scriptTag = document.getElementsByTagName('script')[0];\n\n            element.async = true;\n            element.src = 'https://www.youtube.com/iframe_api';\n            scriptTag.parentNode.insertBefore(element, scriptTag);\n\n            /**\n             * Event observe and handle\n             */\n            window.onYouTubeIframeAPIReady = function () {\n                $(window).trigger('youtubeapiready');\n                videoRegister.register('youtube', true);\n            };\n        },\n\n        /**\n         * Play command for Youtube\n         */\n        play: function () {\n            this._player.playVideo();\n            this._playing = true;\n        },\n\n        /**\n         * Pause command for Youtube\n         */\n        pause: function () {\n            this._player.pauseVideo();\n            this._playing = false;\n        },\n\n        /**\n         * Stop command for Youtube\n         */\n        stop: function () {\n            this._player.stopVideo();\n            this._playing = false;\n        },\n\n        /**\n         * Playing command for Youtube\n         */\n        playing: function () {\n            return this._playing;\n        },\n\n        /**\n         * stops and unloads player\n         * @private\n         */\n        destroy: function () {\n            this.stop();\n            this._player.destroy();\n        }\n    });\n\n    $.widget('mage.videoVimeo', $.mage.productVideoLoader, {\n\n        /**\n         * Initialize the Vimeo widget\n         * @private\n         */\n        _create: function () {\n            var timestamp,\n                additionalParams = '',\n                src;\n\n            this._initialize();\n            timestamp = new Date().getTime();\n            this._autoplay = true;\n\n            if (this._autoplay) {\n                additionalParams += '&autoplay=1';\n            }\n\n            if (this._loop) {\n                additionalParams += '&loop=1';\n            }\n            src = 'https://player.vimeo.com/video/' +\n                this._code + '?api=1&player_id=vimeo' +\n                this._code +\n                timestamp +\n                additionalParams;\n            this.element.append(\n                $('<iframe/>')\n                    .attr('frameborder', 0)\n                    .attr('id', 'vimeo' + this._code + timestamp)\n                    .attr('width', this._width)\n                    .attr('height', this._height)\n                    .attr('src', src)\n                    .attr('webkitallowfullscreen', '')\n                    .attr('mozallowfullscreen', '')\n                    .attr('allowfullscreen', '')\n                    .attr('referrerPolicy', 'origin')\n                    .attr('allow', 'autoplay')\n            );\n            this._player = window.$f(this.element.children(':first')[0]);\n\n            // Froogaloop throws error without a registered ready event\n            this._player.addEvent('ready', function (id) {\n                $('#' + id).closest('.fotorama__stage__frame').addClass('fotorama__product-video--loaded');\n            });\n        },\n\n        /**\n         * Play command for Vimeo\n         */\n        play: function () {\n            this._player.api('play');\n            this._playing = true;\n        },\n\n        /**\n         * Pause command for Vimeo\n         */\n        pause: function () {\n            this._player.api('pause');\n            this._playing = false;\n        },\n\n        /**\n         * Stop command for Vimeo\n         */\n        stop: function () {\n            this._player.api('unload');\n            this._playing = false;\n        },\n\n        /**\n         * Playing command for Vimeo\n         */\n        playing: function () {\n            return this._playing;\n        }\n    });\n});\n","Magento_PageBuilder/js/events.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['uiEvents'], function (uiEvents) {\n    'use strict';\n\n    return {\n\n        /**\n         * Calls callback when name event is triggered\n         *\n         * @param {String} events\n         * @param {Function} callback\n         * @param {Function} ns\n         * @return {Object}\n         */\n        on: function (events, callback, ns) {\n            uiEvents.on('pagebuilder:' + events, callback, 'pagebuilder:' + ns);\n\n            return this;\n        },\n\n        /**\n         * Removed callback from listening to target event\n         *\n         * @param {String} ns\n         * @return {Object}\n         */\n        off: function (ns) {\n            uiEvents.off('pagebuilder:' + ns);\n\n            return this;\n        },\n\n        /**\n         * Triggers event and executes all attached callbacks\n         *\n         * @param {String} name\n         * @param {any} args\n         * @returns {Boolean}\n         */\n        trigger: function (name, args) {\n            return uiEvents.trigger('pagebuilder:' + name, args);\n        }\n    };\n});\n","Magento_PageBuilder/js/widget-initializer.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'jquery',\n    'mage/apply/main',\n    'Magento_Ui/js/lib/view/utils/dom-observer'\n], function (_, $, mage, domObserver) {\n    'use strict';\n\n    /**\n     * Initializes components assigned to HTML elements.\n     *\n     *\n     * @param {HTMLElement} el\n     * @param {Array} data\n     * @param {Object} breakpoints\n     * @param {Object} currentViewport\n     */\n    function initializeWidget(el, data, breakpoints, currentViewport) {\n        _.each(data, function (config, component) {\n            config = config || {};\n            config.breakpoints = breakpoints;\n            config.currentViewport = currentViewport;\n            mage.applyFor(el, config, component);\n        });\n    }\n\n    return function (data, contextElement) {\n        _.each(data.config, function (componentConfiguration, elementPath) {\n            domObserver.get(\n                elementPath,\n                function (element) {\n                    var $element = $(element);\n\n                    if (contextElement) {\n                        $element = $(contextElement).find(element);\n                    }\n\n                    if ($element.length) {\n                        initializeWidget($element, componentConfiguration, data.breakpoints, data.currentViewport);\n                    }\n                }\n            );\n        });\n    };\n});\n","Magento_PageBuilder/js/content-type/tabs/appearance/default/widget.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_PageBuilder/js/events',\n    'jquery-ui-modules/tabs'\n], function ($, events) {\n    'use strict';\n\n    return function (config, element) {\n        var $element = $(element);\n\n        // Ignore stage builder preview tabs\n        if ($element.is('.pagebuilder-tabs')) {\n            return;\n        }\n\n        // Disambiguate between the mage/tabs component which is loaded randomly depending on requirejs order.\n        $.ui.tabs({\n            active: $element.data('activeTab') || 0,\n            create:\n\n                /**\n                 * Adjust the margin bottom of the navigation to correctly display the active tab\n                 */\n                function () {\n                    var borderWidth = parseInt($element.find('.tabs-content').css('borderWidth').toString(), 10);\n\n                    $element.find('.tabs-navigation').css('marginBottom', -borderWidth);\n                    $element.find('.tabs-navigation li:not(:first-child)').css('marginLeft', -borderWidth);\n                },\n            activate:\n\n                /**\n                 * Trigger redraw event since new content is being displayed\n                 */\n                function () {\n                    events.trigger('contentType:redrawAfter', {\n                        element: element\n                    });\n                }\n        }, element);\n    };\n});\n","Magento_PageBuilder/js/content-type/products/appearance/carousel/widget.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'matchMedia',\n    'Magento_PageBuilder/js/utils/breakpoints',\n    'Magento_PageBuilder/js/events',\n    'slick'\n], function ($, _, mediaCheck, breakpointsUtils, events) {\n    'use strict';\n\n    /**\n     * Build slick\n     *\n     * @param {jQuery} $carouselElement\n     * @param {Object} config\n     */\n    function buildSlick($carouselElement, config) {\n        /**\n         * Prevent each slick slider from being initialized more than once which could throw an error.\n         */\n        if ($carouselElement.hasClass('slick-initialized')) {\n            $carouselElement.slick('unslick');\n        }\n\n        config.slidesToScroll = config.slidesToShow;\n        $carouselElement.slick(config);\n    }\n\n    /**\n     * Initialize slider.\n     *\n     * @param {jQuery} $element\n     * @param {Object} slickConfig\n     * @param {Object} breakpoint\n     */\n    function initSlider($element, slickConfig, breakpoint) {\n        var productCount = $element.find('.product-item').length,\n            $carouselElement = $($element.children()),\n            centerModeClass = 'center-mode',\n            carouselMode = $element.data('carousel-mode'),\n            slidesToShow = breakpoint.options.products[carouselMode] ?\n                breakpoint.options.products[carouselMode].slidesToShow :\n                breakpoint.options.products.default.slidesToShow;\n\n        slickConfig.slidesToShow = parseFloat(slidesToShow);\n\n        if (carouselMode === 'continuous' && productCount > slickConfig.slidesToShow) {\n            $element.addClass(centerModeClass);\n            slickConfig.centerPadding = $element.data('center-padding');\n            slickConfig.centerMode = true;\n        } else {\n            $element.removeClass(centerModeClass);\n            slickConfig.infinite = $element.data('infinite-loop');\n        }\n\n        buildSlick($carouselElement, slickConfig);\n    }\n\n    return function (config, element) {\n        var $element = $(element),\n            $carouselElement = $($element.children()),\n            currentViewport = config.currentViewport,\n            currentBreakpoint = config.breakpoints[currentViewport],\n            slickConfig = {\n                autoplay: $element.data('autoplay'),\n                autoplaySpeed: $element.data('autoplay-speed') || 0,\n                arrows: $element.data('show-arrows'),\n                dots: $element.data('show-dots')\n            };\n\n        _.each(config.breakpoints, function (breakpoint) {\n            mediaCheck({\n                media: breakpointsUtils.buildMedia(breakpoint.conditions),\n\n                /** @inheritdoc */\n                entry: function () {\n                    initSlider($element, slickConfig, breakpoint);\n                }\n            });\n        });\n\n        //initialize slider when content type is added in mobile viewport\n        if (currentViewport === 'mobile') {\n            initSlider($element, slickConfig, currentBreakpoint);\n        }\n\n        // Redraw slide after content type gets redrawn\n        events.on('contentType:redrawAfter', function (args) {\n            if ($carouselElement.closest(args.element).length) {\n                $carouselElement.slick('setPosition');\n            }\n        });\n\n        events.on('stage:viewportChangeAfter', function (args) {\n            var breakpoint = config.breakpoints[args.viewport];\n\n            initSlider($element, slickConfig, breakpoint);\n        });\n    };\n});\n","Magento_PageBuilder/js/content-type/slide/appearance/default/widget.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_PageBuilder/js/widget/show-on-hover',\n    'Magento_PageBuilder/js/widget/video-background'\n], function ($, _, showOnHover, videoBackground) {\n    'use strict';\n\n    return function (config, element) {\n        var videoElement = element[0].querySelector('[data-background-type=video]'),\n            viewportElement = document.createElement('div'),\n            $slider = null;\n\n        showOnHover(config);\n\n        if (videoElement) {\n            $slider = $(element).closest('[data-content-type=slider]');\n            viewportElement.classList.add('jarallax-viewport-element');\n            videoElement.setAttribute('data-element-in-viewport', '.jarallax-viewport-element');\n            videoElement.appendChild(viewportElement);\n            videoBackground(config, videoElement);\n\n            if ($slider.data('afterChangeIsSet')) {\n                return;\n            }\n\n            $slider.on('afterChange init', function () {\n                var videoSlides = $slider[0].querySelectorAll('.jarallax');\n\n                _.each(videoSlides, function (videoSlide) {\n                    videoSlide.jarallax && videoSlide.jarallax.onScroll();\n                });\n            });\n            $slider.data('afterChangeIsSet', true);\n        }\n    };\n});\n","Magento_PageBuilder/js/content-type/buttons/appearance/inline/widget.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_PageBuilder/js/events'\n], function ($, events) {\n    'use strict';\n\n    /**\n     * Equalize the width of a list of button-item components\n     *\n     * @param {JQuery} buttonList\n     */\n    var equalizeButtonWidth = function (buttonList) {\n        var buttonMinWidth = 0;\n\n        buttonList.css('min-width', buttonMinWidth);\n        buttonList.each(function () {\n            var buttonWidth = this.offsetWidth;\n\n            if (buttonWidth > buttonMinWidth) {\n                buttonMinWidth = buttonWidth;\n            }\n        });\n        buttonList.css('min-width', buttonMinWidth);\n    };\n\n    return function (config, element) {\n        var $element = $(element),\n            buttonSelector = '[data-element=\"link\"], [data-element=\"empty_link\"]';\n\n        if ($element.data('sameWidth')) {\n            equalizeButtonWidth($element.find(buttonSelector));\n            $(window).resize(function () {\n                equalizeButtonWidth($element.find(buttonSelector));\n            });\n            events.on('contentType:redrawAfter', function (eventData) {\n                if ($element.closest(eventData.element).length > 0) {\n                    equalizeButtonWidth($element.find(buttonSelector));\n                }\n            });\n        }\n    };\n});\n","Magento_PageBuilder/js/content-type/slider/appearance/default/widget.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_PageBuilder/js/events',\n    'slick'\n], function ($, events) {\n    'use strict';\n\n    return function (config, sliderElement) {\n        var $element = $(sliderElement);\n\n        /**\n         * Prevent each slick slider from being initialized more than once which could throw an error.\n         */\n        if ($element.hasClass('slick-initialized')) {\n            $element.slick('unslick');\n        }\n\n        $element.slick({\n            autoplay: $element.data('autoplay'),\n            autoplaySpeed: $element.data('autoplay-speed') || 0,\n            fade: $element.data('fade'),\n            infinite: $element.data('infinite-loop'),\n            arrows: $element.data('show-arrows'),\n            dots: $element.data('show-dots')\n        });\n\n        // Redraw slide after content type gets redrawn\n        events.on('contentType:redrawAfter', function (args) {\n            if ($element.closest(args.element).length) {\n                $element.slick('setPosition');\n            }\n        });\n        events.on('stage:viewportChangeAfter', $element.slick.bind($element, 'setPosition'));\n    };\n});\n","Magento_PageBuilder/js/content-type/row/appearance/default/widget.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_PageBuilder/js/widget/video-background',\n    'jarallax'\n], function ($, videoBackground) {\n    'use strict';\n\n    return function (config, element) {\n        var $element = $(element),\n            parallaxSpeed = null,\n            elementStyle = null;\n\n        if ($element.data('appearance') === 'contained') {\n            $element = $(element).find('[data-element=\"inner\"]');\n        }\n\n        if ($element.data('background-type') === 'video') {\n            videoBackground(config, $element[0]);\n\n            return;\n        }\n\n        if ($element.data('enableParallax') !== 1) {\n            return;\n        }\n\n        $element.addClass('jarallax');\n        $element.attr('data-jarallax', '');\n\n        parallaxSpeed = parseFloat($element.data('parallaxSpeed'));\n        elementStyle = window.getComputedStyle($element[0]);\n\n        window.jarallax($element[0], {\n            imgPosition: elementStyle.backgroundPosition || '50% 50%',\n            imgRepeat: elementStyle.backgroundRepeat || 'no-repeat',\n            imgSize: elementStyle.backgroundSize || 'cover',\n            speed: !isNaN(parallaxSpeed) ? parallaxSpeed : 0.5\n        });\n    };\n});\n","Magento_PageBuilder/js/content-type/map/appearance/default/widget.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_PageBuilder/js/utils/map'\n], function ($, GoogleMap) {\n    'use strict';\n\n    return function (config, element) {\n        var locations,\n            controls,\n            mapOptions = {};\n\n        element = element[0];\n\n        if (element !== undefined && element.hasAttribute('data-locations')) {\n\n            /**\n             * Set map display to none if no locations\n             */\n            if (element.getAttribute('data-locations') === '[]') {\n                $(element).hide();\n\n                return;\n            }\n            locations = JSON.parse(element.getAttribute('data-locations'));\n            locations.forEach(function (location) {\n                location.position.latitude = parseFloat(location.position.latitude);\n                location.position.longitude = parseFloat(location.position.longitude);\n            });\n            controls = element.getAttribute('data-show-controls');\n            mapOptions.disableDefaultUI = controls !== 'true';\n            mapOptions.mapTypeControl = controls === 'true';\n            new GoogleMap(element, locations, mapOptions);\n        }\n    };\n});\n","Magento_PageBuilder/js/content-type/banner/appearance/default/widget.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_PageBuilder/js/widget/show-on-hover',\n    'Magento_PageBuilder/js/widget/video-background'\n], function (showOnHover, videoBackground) {\n    'use strict';\n\n    return function (config, element) {\n        var videoElement = element[0].querySelector('[data-background-type=video]');\n\n        showOnHover(config);\n\n        if (videoElement) {\n            videoBackground(config, videoElement);\n        }\n    };\n});\n","Magento_PageBuilder/js/widget/show-on-hover.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['jquery'], function ($) {\n    'use strict';\n\n    /**\n     * Show the overlay on hover of specific elements\n     *\n     * @param {JQuery<Element>[]} $elements\n     */\n    function showOverlayOnHover($elements) {\n        $elements.each(function (index, element) {\n            var overlayEl = $(element).find('.pagebuilder-overlay'),\n                overlayColor = overlayEl.attr('data-overlay-color');\n\n            $(element).hover(\n                function () {\n                    overlayEl.css('background-color', overlayColor);\n                },\n                function () {\n                    overlayEl.css('background-color', 'transparent');\n                }\n            );\n        });\n    }\n\n    /**\n     * Show button on hover of specific elements\n     *\n     * @param {JQuery<Element>[]} $elements\n     * @param {String} buttonClass\n     */\n    function showButtonOnHover($elements, buttonClass) {\n        $elements.each(function (index, element) {\n            var buttonEl = $(element).find(buttonClass);\n\n            $(element).hover(\n                function () {\n                    buttonEl.css({\n                        'opacity': '1',\n                        'visibility': 'visible'\n                    });\n                }, function () {\n                    buttonEl.css({\n                        'opacity': '0',\n                        'visibility': 'hidden'\n                    });\n                }\n            );\n        });\n    }\n\n    return function (config) {\n\n        var buttonSelector = config.buttonSelector,\n            overlayHoverSelector = 'div[data-content-type=\"%s\"][data-show-overlay=\"%s\"]'\n                .replace('%s', config.dataRole)\n                .replace('%s', config.showOverlay),\n            overlayButtonSelector = 'div[data-content-type=\"%s\"][data-show-button=\"%s\"]'\n                .replace('%s', config.dataRole)\n                .replace('%s', config.showOverlay);\n\n        showOverlayOnHover($(overlayHoverSelector));\n        showButtonOnHover($(overlayButtonSelector), buttonSelector);\n    };\n});\n","Magento_PageBuilder/js/widget/video-background.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'jarallax',\n    'jarallaxVideo',\n    'vimeoWrapper'\n], function ($) {\n    'use strict';\n\n    return function (config, element) {\n        var $element = $(element),\n            parallaxSpeed = $element.data('enableParallax') !== 1 ? 1 : parseFloat($element.data('parallaxSpeed'));\n\n        if ($element.data('background-type') !== 'video') {\n            return;\n        }\n\n        $element.addClass('jarallax');\n        $element.attr('data-jarallax', '');\n\n        window.jarallax($element[0], {\n            imgSrc: $element.data('videoFallbackSrc'),\n            speed: !isNaN(parallaxSpeed) ? parallaxSpeed : 0.5,\n            videoLoop: $element.data('videoLoop'),\n            videoPlayOnlyVisible: $element.data('videoPlayOnlyVisible'),\n            videoLazyLoading: $element.data('videoLazyLoad'),\n            disableVideo: false,\n            elementInViewport: $element.data('elementInViewport') &&\n                $element[0].querySelector($element.data('elementInViewport'))\n        });\n        $element[0].jarallax.video && $element[0].jarallax.video.on('started', function () {\n            if ($element[0].jarallax.$video) {\n                $element[0].jarallax.$video.style.visibility = 'visible';\n            }\n        });\n    };\n});\n","Magento_PageBuilder/js/utils/breakpoints.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    return {\n        /**\n         * Build media query.\n         *\n         * @param {Object} conditions\n         * @returns {String}\n         */\n        buildMedia: function (conditions) {\n            var result = _.map(_.pairs(conditions), function (condition) {\n                return '(' + condition.join(': ') + ')';\n            });\n\n            return result.join(' and ');\n        }\n    };\n});\n","Magento_PageBuilder/js/utils/map.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * googleMaps dependency is added within googlemaps.phtml through shim based on API key being set\n *\n * @api\n */\ndefine([\n    'underscore',\n    'module',\n    'Magento_PageBuilder/js/events'\n], function (_, module, events) {\n    'use strict';\n\n    var google = window.google || {},\n\n        /**\n         * Generates a google map usable latitude and longitude object\n         *\n         * @param {Object} position\n         * @return {google.maps.LatLng}\n         */\n        getGoogleLatitudeLongitude = function (position) {\n            return new google.maps.LatLng(position.latitude, position.longitude);\n        },\n        gmAuthFailure = false;\n\n    // jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n    /**\n     * Google's error listener for map loader failures\n     */\n    window.gm_authFailure = function () {\n        events.trigger('googleMaps:authFailure');\n        gmAuthFailure = true;\n    };\n    // jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n\n    return function (element, markers, additionalOptions) {\n        var options,\n            style;\n\n        // If we've previously had an API key error, throw the error even again\n        if (gmAuthFailure) {\n            events.trigger('googleMaps:authFailure');\n\n            return;\n        }\n\n        // If Google Maps isn't loaded don't try init the map, it won't work\n        if (typeof google.maps === 'undefined') {\n            return;\n        }\n\n        /**\n         * Just in case of a bad JSON that bypassed validation\n         */\n        try {\n            style = module.config().style ? JSON.parse(module.config().style) : [];\n        }\n        catch (error) {\n            style = [];\n        }\n        options = _.extend({\n            zoom: 8,\n            center: getGoogleLatitudeLongitude({\n                latitude: 30.2672,\n                longitude: -97.7431\n            }),\n            scrollwheel: false,\n            disableDoubleClickZoom: false,\n            disableDefaultUI: false,\n            mapTypeControl: true,\n            mapTypeControlOptions: {\n                style: google.maps.MapTypeControlStyle.DEFAULT\n            },\n            styles: style\n        }, additionalOptions);\n\n        /* Create the map */\n        this.map = new google.maps.Map(element, options);\n        this.markers = [];\n\n        /**\n         * Callback function on map config update\n         * @param {Array} newMarkers\n         * @param {Object} updateOptions\n         */\n        this.onUpdate = function (newMarkers, updateOptions) {\n            this.map.setOptions(updateOptions);\n            this.setMarkers(newMarkers);\n        };\n\n        /**\n         * Sets the markers to selected map\n         * @param {Object} newMarkers\n         */\n        this.setMarkers = function (newMarkers) {\n            var activeInfoWindow,\n                latitudeLongitudeBounds = new google.maps.LatLngBounds();\n\n            this.markers.forEach(function (marker) {\n                marker.setMap(null);\n            }, this);\n\n            this.markers = [];\n            this.bounds = [];\n\n            /**\n             * Creates and set listener for markers\n             */\n            if (newMarkers && newMarkers.length) {\n                newMarkers.forEach(function (newMarker) {\n                    var location = _.escape(newMarker['location_name']) || '',\n                    comment = newMarker.comment ?\n                        '<p>' + _.escape(newMarker.comment).replace(/(?:\\r\\n|\\r|\\n)/g, '<br/>') + '</p>'\n                        : '',\n                    phone = newMarker.phone ? '<p>Phone: ' + _.escape(newMarker.phone) + '</p>' : '',\n                    address = newMarker.address ? _.escape(newMarker.address) + '<br/>' : '',\n                    city = _.escape(newMarker.city) || '',\n                    country = newMarker.country ? _.escape(newMarker.country) : '',\n                    state = newMarker.state ? _.escape(newMarker.state) + ' ' : '',\n                    zipCode = newMarker.zipcode ? _.escape(newMarker.zipcode) : '',\n                    cityComma = city !== '' && (zipCode !== '' || state !== '') ? ', ' : '',\n                    lineBreak = city !== '' || zipCode !== '' ? '<br/>' : '',\n                    contentString =\n                        '<div>' +\n                        '<h3><b>' + location + '</b></h3>' +\n                        comment +\n                        phone +\n                        '<p><span>' + address +\n                        city + cityComma + state + zipCode + lineBreak +\n                        country + '</span></p>' +\n                        '</div>',\n                    infowindow = new google.maps.InfoWindow({\n                        content: contentString,\n                        maxWidth: 350\n                    }),\n                    newCreatedMarker = new google.maps.Marker({\n                        map: this.map,\n                        position: getGoogleLatitudeLongitude(newMarker.position),\n                        title: location\n                    });\n\n                    if (location) {\n                        newCreatedMarker.addListener('click', function () {\n                            if (activeInfoWindow) {\n                                activeInfoWindow.close();\n                            }\n\n                            infowindow.open(this.map, newCreatedMarker);\n                            activeInfoWindow = infowindow;\n                        }, this);\n                    }\n\n                    this.markers.push(newCreatedMarker);\n                    this.bounds.push(getGoogleLatitudeLongitude(newMarker.position));\n                }, this);\n            }\n\n            /**\n             * This sets the bounds of the map for multiple locations\n             */\n            if (this.bounds.length > 1) {\n                this.bounds.forEach(function (bound) {\n                    latitudeLongitudeBounds.extend(bound);\n                });\n                this.map.fitBounds(latitudeLongitudeBounds);\n            }\n\n            /**\n             * Zoom to 8 if there is only a single location\n             */\n            if (this.bounds.length === 1) {\n                this.map.setCenter(this.bounds[0]);\n                this.map.setZoom(8);\n            }\n        };\n\n        this.setMarkers(markers);\n    };\n});\n","Magento_PageBuilder/js/resource/slick/slick.js":"/*\n     _ _      _       _\n ___| (_) ___| | __  (_)___\n/ __| | |/ __| |/ /  | / __|\n\\__ \\ | | (__|   < _ | \\__ \\\n|___/_|_|\\___|_|\\_(_)/ |___/\n                   |__/\n\n Version: 1.8.1\n  Author: Ken Wheeler\n Website: http://kenwheeler.github.io\n    Docs: http://kenwheeler.github.io/slick\n    Repo: http://github.com/kenwheeler/slick\n  Issues: http://github.com/kenwheeler/slick/issues\n\n */\n/* global window, document, define, jQuery, setInterval, clearInterval */\n;(function(factory) {\n    'use strict';\n    if (typeof define === 'function' && define.amd) {\n        define(['jquery'], factory);\n    } else if (typeof exports !== 'undefined') {\n        module.exports = factory(require('jquery'));\n    } else {\n        factory(jQuery);\n    }\n\n}(function($) {\n    'use strict';\n    var Slick = window.Slick || {};\n\n    Slick = (function() {\n\n        var instanceUid = 0;\n\n        function Slick(element, settings) {\n\n            var _ = this, dataSettings;\n\n            _.defaults = {\n                accessibility: true,\n                adaptiveHeight: false,\n                appendArrows: $(element),\n                appendDots: $(element),\n                arrows: true,\n                asNavFor: null,\n                prevArrow: '<button class=\"slick-prev\" aria-label=\"Previous\" type=\"button\">Previous</button>',\n                nextArrow: '<button class=\"slick-next\" aria-label=\"Next\" type=\"button\">Next</button>',\n                autoplay: false,\n                autoplaySpeed: 3000,\n                centerMode: false,\n                centerPadding: '50px',\n                cssEase: 'ease',\n                customPaging: function(slider, i) {\n                    return $('<button type=\"button\" />').text(i + 1);\n                },\n                dots: false,\n                dotsClass: 'slick-dots',\n                draggable: true,\n                easing: 'linear',\n                edgeFriction: 0.35,\n                fade: false,\n                focusOnSelect: false,\n                focusOnChange: false,\n                infinite: true,\n                initialSlide: 0,\n                lazyLoad: 'ondemand',\n                mobileFirst: false,\n                pauseOnHover: true,\n                pauseOnFocus: true,\n                pauseOnDotsHover: false,\n                respondTo: 'window',\n                responsive: null,\n                rows: 1,\n                rtl: false,\n                slide: '',\n                slidesPerRow: 1,\n                slidesToShow: 1,\n                slidesToScroll: 1,\n                speed: 500,\n                swipe: true,\n                swipeToSlide: false,\n                touchMove: true,\n                touchThreshold: 5,\n                useCSS: true,\n                useTransform: true,\n                variableWidth: false,\n                vertical: false,\n                verticalSwiping: false,\n                waitForAnimate: true,\n                zIndex: 1000\n            };\n\n            _.initials = {\n                animating: false,\n                dragging: false,\n                autoPlayTimer: null,\n                currentDirection: 0,\n                currentLeft: null,\n                currentSlide: 0,\n                direction: 1,\n                $dots: null,\n                listWidth: null,\n                listHeight: null,\n                loadIndex: 0,\n                $nextArrow: null,\n                $prevArrow: null,\n                scrolling: false,\n                slideCount: null,\n                slideWidth: null,\n                $slideTrack: null,\n                $slides: null,\n                sliding: false,\n                slideOffset: 0,\n                swipeLeft: null,\n                swiping: false,\n                $list: null,\n                touchObject: {},\n                transformsEnabled: false,\n                unslicked: false\n            };\n\n            $.extend(_, _.initials);\n\n            _.activeBreakpoint = null;\n            _.animType = null;\n            _.animProp = null;\n            _.breakpoints = [];\n            _.breakpointSettings = [];\n            _.cssTransitions = false;\n            _.focussed = false;\n            _.interrupted = false;\n            _.hidden = 'hidden';\n            _.paused = true;\n            _.positionProp = null;\n            _.respondTo = null;\n            _.rowCount = 1;\n            _.shouldClick = true;\n            _.$slider = $(element);\n            _.$slidesCache = null;\n            _.transformType = null;\n            _.transitionType = null;\n            _.visibilityChange = 'visibilitychange';\n            _.windowWidth = 0;\n            _.windowTimer = null;\n\n            dataSettings = $(element).data('slick') || {};\n\n            _.options = $.extend({}, _.defaults, settings, dataSettings);\n\n            _.currentSlide = _.options.initialSlide;\n\n            _.originalSettings = _.options;\n\n            if (typeof document.mozHidden !== 'undefined') {\n                _.hidden = 'mozHidden';\n                _.visibilityChange = 'mozvisibilitychange';\n            } else if (typeof document.webkitHidden !== 'undefined') {\n                _.hidden = 'webkitHidden';\n                _.visibilityChange = 'webkitvisibilitychange';\n            }\n\n            _.autoPlay = $.proxy(_.autoPlay, _);\n            _.autoPlayClear = $.proxy(_.autoPlayClear, _);\n            _.autoPlayIterator = $.proxy(_.autoPlayIterator, _);\n            _.changeSlide = $.proxy(_.changeSlide, _);\n            _.clickHandler = $.proxy(_.clickHandler, _);\n            _.selectHandler = $.proxy(_.selectHandler, _);\n            _.setPosition = $.proxy(_.setPosition, _);\n            _.swipeHandler = $.proxy(_.swipeHandler, _);\n            _.dragHandler = $.proxy(_.dragHandler, _);\n            _.keyHandler = $.proxy(_.keyHandler, _);\n\n            _.instanceUid = instanceUid++;\n\n            // A simple way to check for HTML strings\n            // Strict HTML recognition (must start with <)\n            // Extracted from jQuery v1.11 source\n            _.htmlExpr = /^(?:\\s*(<[\\w\\W]+>)[^>]*)$/;\n\n\n            _.registerBreakpoints();\n            _.init(true);\n\n        }\n\n        return Slick;\n\n    }());\n\n    Slick.prototype.activateADA = function() {\n        var _ = this;\n\n        _.$slideTrack.find('.slick-active').attr({\n            'aria-hidden': 'false'\n        }).find('a, input, button, select').attr({\n            'tabindex': '0'\n        });\n\n    };\n\n    Slick.prototype.addSlide = Slick.prototype.slickAdd = function(markup, index, addBefore) {\n\n        var _ = this;\n\n        if (typeof(index) === 'boolean') {\n            addBefore = index;\n            index = null;\n        } else if (index < 0 || (index >= _.slideCount)) {\n            return false;\n        }\n\n        _.unload();\n\n        if (typeof(index) === 'number') {\n            if (index === 0 && _.$slides.length === 0) {\n                $(markup).appendTo(_.$slideTrack);\n            } else if (addBefore) {\n                $(markup).insertBefore(_.$slides.eq(index));\n            } else {\n                $(markup).insertAfter(_.$slides.eq(index));\n            }\n        } else {\n            if (addBefore === true) {\n                $(markup).prependTo(_.$slideTrack);\n            } else {\n                $(markup).appendTo(_.$slideTrack);\n            }\n        }\n\n        _.$slides = _.$slideTrack.children(this.options.slide);\n\n        _.$slideTrack.children(this.options.slide).detach();\n\n        _.$slideTrack.append(_.$slides);\n\n        _.$slides.each(function(index, element) {\n            $(element).attr('data-slick-index', index);\n        });\n\n        _.$slidesCache = _.$slides;\n\n        _.reinit();\n\n    };\n\n    Slick.prototype.animateHeight = function() {\n        var _ = this;\n        if (_.options.slidesToShow === 1 && _.options.adaptiveHeight === true && _.options.vertical === false) {\n            var targetHeight = _.$slides.eq(_.currentSlide).outerHeight(true);\n            _.$list.animate({\n                height: targetHeight\n            }, _.options.speed);\n        }\n    };\n\n    Slick.prototype.animateSlide = function(targetLeft, callback) {\n\n        var animProps = {},\n            _ = this;\n\n        _.animateHeight();\n\n        if (_.options.rtl === true && _.options.vertical === false) {\n            targetLeft = -targetLeft;\n        }\n        if (_.transformsEnabled === false) {\n            if (_.options.vertical === false) {\n                _.$slideTrack.animate({\n                    left: targetLeft\n                }, _.options.speed, _.options.easing, callback);\n            } else {\n                _.$slideTrack.animate({\n                    top: targetLeft\n                }, _.options.speed, _.options.easing, callback);\n            }\n\n        } else {\n\n            if (_.cssTransitions === false) {\n                if (_.options.rtl === true) {\n                    _.currentLeft = -(_.currentLeft);\n                }\n                $({\n                    animStart: _.currentLeft\n                }).animate({\n                    animStart: targetLeft\n                }, {\n                    duration: _.options.speed,\n                    easing: _.options.easing,\n                    step: function(now) {\n                        now = Math.ceil(now);\n                        if (_.options.vertical === false) {\n                            animProps[_.animType] = 'translate(' +\n                                now + 'px, 0px)';\n                            _.$slideTrack.css(animProps);\n                        } else {\n                            animProps[_.animType] = 'translate(0px,' +\n                                now + 'px)';\n                            _.$slideTrack.css(animProps);\n                        }\n                    },\n                    complete: function() {\n                        if (callback) {\n                            callback.call();\n                        }\n                    }\n                });\n\n            } else {\n\n                _.applyTransition();\n                targetLeft = Math.ceil(targetLeft);\n\n                if (_.options.vertical === false) {\n                    animProps[_.animType] = 'translate3d(' + targetLeft + 'px, 0px, 0px)';\n                } else {\n                    animProps[_.animType] = 'translate3d(0px,' + targetLeft + 'px, 0px)';\n                }\n                _.$slideTrack.css(animProps);\n\n                if (callback) {\n                    setTimeout(function() {\n\n                        _.disableTransition();\n\n                        callback.call();\n                    }, _.options.speed);\n                }\n\n            }\n\n        }\n\n    };\n\n    Slick.prototype.getNavTarget = function() {\n\n        var _ = this,\n            asNavFor = _.options.asNavFor;\n\n        if ( asNavFor && asNavFor !== null ) {\n            asNavFor = $(asNavFor).not(_.$slider);\n        }\n\n        return asNavFor;\n\n    };\n\n    Slick.prototype.asNavFor = function(index) {\n\n        var _ = this,\n            asNavFor = _.getNavTarget();\n\n        if ( asNavFor !== null && typeof asNavFor === 'object' ) {\n            asNavFor.each(function() {\n                var target = $(this).slick('getSlick');\n                if(!target.unslicked) {\n                    target.slideHandler(index, true);\n                }\n            });\n        }\n\n    };\n\n    Slick.prototype.applyTransition = function(slide) {\n\n        var _ = this,\n            transition = {};\n\n        if (_.options.fade === false) {\n            transition[_.transitionType] = _.transformType + ' ' + _.options.speed + 'ms ' + _.options.cssEase;\n        } else {\n            transition[_.transitionType] = 'opacity ' + _.options.speed + 'ms ' + _.options.cssEase;\n        }\n\n        if (_.options.fade === false) {\n            _.$slideTrack.css(transition);\n        } else {\n            _.$slides.eq(slide).css(transition);\n        }\n\n    };\n\n    Slick.prototype.autoPlay = function() {\n\n        var _ = this;\n\n        _.autoPlayClear();\n\n        if ( _.slideCount > _.options.slidesToShow ) {\n            _.autoPlayTimer = setInterval( _.autoPlayIterator, _.options.autoplaySpeed );\n        }\n\n    };\n\n    Slick.prototype.autoPlayClear = function() {\n\n        var _ = this;\n\n        if (_.autoPlayTimer) {\n            clearInterval(_.autoPlayTimer);\n        }\n\n    };\n\n    Slick.prototype.autoPlayIterator = function() {\n\n        var _ = this,\n            slideTo = _.currentSlide + _.options.slidesToScroll;\n\n        if ( !_.paused && !_.interrupted && !_.focussed ) {\n\n            if ( _.options.infinite === false ) {\n\n                if ( _.direction === 1 && ( _.currentSlide + 1 ) === ( _.slideCount - 1 )) {\n                    _.direction = 0;\n                }\n\n                else if ( _.direction === 0 ) {\n\n                    slideTo = _.currentSlide - _.options.slidesToScroll;\n\n                    if ( _.currentSlide - 1 === 0 ) {\n                        _.direction = 1;\n                    }\n\n                }\n\n            }\n\n            _.slideHandler( slideTo );\n\n        }\n\n    };\n\n    Slick.prototype.buildArrows = function() {\n\n        var _ = this;\n\n        if (_.options.arrows === true ) {\n\n            _.$prevArrow = $(_.options.prevArrow).addClass('slick-arrow');\n            _.$nextArrow = $(_.options.nextArrow).addClass('slick-arrow');\n\n            if( _.slideCount > _.options.slidesToShow ) {\n\n                _.$prevArrow.removeClass('slick-hidden').removeAttr('aria-hidden tabindex');\n                _.$nextArrow.removeClass('slick-hidden').removeAttr('aria-hidden tabindex');\n\n                if (_.htmlExpr.test(_.options.prevArrow)) {\n                    _.$prevArrow.prependTo(_.options.appendArrows);\n                }\n\n                if (_.htmlExpr.test(_.options.nextArrow)) {\n                    _.$nextArrow.appendTo(_.options.appendArrows);\n                }\n\n                if (_.options.infinite !== true) {\n                    _.$prevArrow\n                        .addClass('slick-disabled')\n                        .attr('aria-disabled', 'true');\n                }\n\n            } else {\n\n                _.$prevArrow.add( _.$nextArrow )\n\n                    .addClass('slick-hidden')\n                    .attr({\n                        'aria-disabled': 'true',\n                        'tabindex': '-1'\n                    });\n\n            }\n\n        }\n\n    };\n\n    Slick.prototype.buildDots = function() {\n\n        var _ = this,\n            i, dot;\n\n        if (_.options.dots === true && _.slideCount > _.options.slidesToShow) {\n\n            _.$slider.addClass('slick-dotted');\n\n            dot = $('<ul />').addClass(_.options.dotsClass);\n\n            for (i = 0; i <= _.getDotCount(); i += 1) {\n                dot.append($('<li />').append(_.options.customPaging.call(this, _, i)));\n            }\n\n            _.$dots = dot.appendTo(_.options.appendDots);\n\n            _.$dots.find('li').first().addClass('slick-active');\n\n        }\n\n    };\n\n    Slick.prototype.buildOut = function() {\n\n        var _ = this;\n\n        _.$slides =\n            _.$slider\n                .children( _.options.slide + ':not(.slick-cloned)')\n                .addClass('slick-slide');\n\n        _.slideCount = _.$slides.length;\n\n        _.$slides.each(function(index, element) {\n            $(element)\n                .attr('data-slick-index', index)\n                .data('originalStyling', $(element).attr('style') || '');\n        });\n\n        _.$slider.addClass('slick-slider');\n\n        _.$slideTrack = (_.slideCount === 0) ?\n            $('<div class=\"slick-track\"/>').appendTo(_.$slider) :\n            _.$slides.wrapAll('<div class=\"slick-track\"/>').parent();\n\n        _.$list = _.$slideTrack.wrap(\n            '<div class=\"slick-list\"/>').parent();\n        _.$slideTrack.css('opacity', 0);\n\n        if (_.options.centerMode === true || _.options.swipeToSlide === true) {\n            _.options.slidesToScroll = 1;\n        }\n\n        $('img[data-lazy]', _.$slider).not('[src]').addClass('slick-loading');\n\n        _.setupInfinite();\n\n        _.buildArrows();\n\n        _.buildDots();\n\n        _.updateDots();\n\n\n        _.setSlideClasses(typeof _.currentSlide === 'number' ? _.currentSlide : 0);\n\n        if (_.options.draggable === true) {\n            _.$list.addClass('draggable');\n        }\n\n    };\n\n    Slick.prototype.buildRows = function() {\n\n        var _ = this, a, b, c, newSlides, numOfSlides, originalSlides,slidesPerSection;\n\n        newSlides = document.createDocumentFragment();\n        originalSlides = _.$slider.children();\n\n        if(_.options.rows > 0) {\n\n            slidesPerSection = _.options.slidesPerRow * _.options.rows;\n            numOfSlides = Math.ceil(\n                originalSlides.length / slidesPerSection\n            );\n\n            for(a = 0; a < numOfSlides; a++){\n                var slide = document.createElement('div');\n                for(b = 0; b < _.options.rows; b++) {\n                    var row = document.createElement('div');\n                    for(c = 0; c < _.options.slidesPerRow; c++) {\n                        var target = (a * slidesPerSection + ((b * _.options.slidesPerRow) + c));\n                        if (originalSlides.get(target)) {\n                            row.appendChild(originalSlides.get(target));\n                        }\n                    }\n                    slide.appendChild(row);\n                }\n                newSlides.appendChild(slide);\n            }\n\n            _.$slider.empty().append(newSlides);\n            _.$slider.children().children().children()\n                .css({\n                    'width':(100 / _.options.slidesPerRow) + '%',\n                    'display': 'inline-block'\n                });\n\n        }\n\n    };\n\n    Slick.prototype.checkResponsive = function(initial, forceUpdate) {\n\n        var _ = this,\n            breakpoint, targetBreakpoint, respondToWidth, triggerBreakpoint = false;\n        var sliderWidth = _.$slider.width();\n        var windowWidth = window.innerWidth || $(window).width();\n\n        if (_.respondTo === 'window') {\n            respondToWidth = windowWidth;\n        } else if (_.respondTo === 'slider') {\n            respondToWidth = sliderWidth;\n        } else if (_.respondTo === 'min') {\n            respondToWidth = Math.min(windowWidth, sliderWidth);\n        }\n\n        if ( _.options.responsive &&\n            _.options.responsive.length &&\n            _.options.responsive !== null) {\n\n            targetBreakpoint = null;\n\n            for (breakpoint in _.breakpoints) {\n                if (_.breakpoints.hasOwnProperty(breakpoint)) {\n                    if (_.originalSettings.mobileFirst === false) {\n                        if (respondToWidth < _.breakpoints[breakpoint]) {\n                            targetBreakpoint = _.breakpoints[breakpoint];\n                        }\n                    } else {\n                        if (respondToWidth > _.breakpoints[breakpoint]) {\n                            targetBreakpoint = _.breakpoints[breakpoint];\n                        }\n                    }\n                }\n            }\n\n            if (targetBreakpoint !== null) {\n                if (_.activeBreakpoint !== null) {\n                    if (targetBreakpoint !== _.activeBreakpoint || forceUpdate) {\n                        _.activeBreakpoint =\n                            targetBreakpoint;\n                        if (_.breakpointSettings[targetBreakpoint] === 'unslick') {\n                            _.unslick(targetBreakpoint);\n                        } else {\n                            _.options = $.extend({}, _.originalSettings,\n                                _.breakpointSettings[\n                                    targetBreakpoint]);\n                            if (initial === true) {\n                                _.currentSlide = _.options.initialSlide;\n                            }\n                            _.refresh(initial);\n                        }\n                        triggerBreakpoint = targetBreakpoint;\n                    }\n                } else {\n                    _.activeBreakpoint = targetBreakpoint;\n                    if (_.breakpointSettings[targetBreakpoint] === 'unslick') {\n                        _.unslick(targetBreakpoint);\n                    } else {\n                        _.options = $.extend({}, _.originalSettings,\n                            _.breakpointSettings[\n                                targetBreakpoint]);\n                        if (initial === true) {\n                            _.currentSlide = _.options.initialSlide;\n                        }\n                        _.refresh(initial);\n                    }\n                    triggerBreakpoint = targetBreakpoint;\n                }\n            } else {\n                if (_.activeBreakpoint !== null) {\n                    _.activeBreakpoint = null;\n                    _.options = _.originalSettings;\n                    if (initial === true) {\n                        _.currentSlide = _.options.initialSlide;\n                    }\n                    _.refresh(initial);\n                    triggerBreakpoint = targetBreakpoint;\n                }\n            }\n\n            // only trigger breakpoints during an actual break. not on initialize.\n            if( !initial && triggerBreakpoint !== false ) {\n                _.$slider.trigger('breakpoint', [_, triggerBreakpoint]);\n            }\n        }\n\n    };\n\n    Slick.prototype.changeSlide = function(event, dontAnimate) {\n\n        var _ = this,\n            $target = $(event.currentTarget),\n            indexOffset, slideOffset, unevenOffset;\n\n        // If target is a link, prevent default action.\n        if($target.is('a')) {\n            event.preventDefault();\n        }\n\n        // If target is not the <li> element (ie: a child), find the <li>.\n        if(!$target.is('li')) {\n            $target = $target.closest('li');\n        }\n\n        unevenOffset = (_.slideCount % _.options.slidesToScroll !== 0);\n        indexOffset = unevenOffset ? 0 : (_.slideCount - _.currentSlide) % _.options.slidesToScroll;\n\n        switch (event.data.message) {\n\n            case 'previous':\n                slideOffset = indexOffset === 0 ? _.options.slidesToScroll : _.options.slidesToShow - indexOffset;\n                if (_.slideCount > _.options.slidesToShow) {\n                    _.slideHandler(_.currentSlide - slideOffset, false, dontAnimate);\n                }\n                break;\n\n            case 'next':\n                slideOffset = indexOffset === 0 ? _.options.slidesToScroll : indexOffset;\n                if (_.slideCount > _.options.slidesToShow) {\n                    _.slideHandler(_.currentSlide + slideOffset, false, dontAnimate);\n                }\n                break;\n\n            case 'index':\n                var index = event.data.index === 0 ? 0 :\n                    event.data.index || $target.index() * _.options.slidesToScroll;\n\n                _.slideHandler(_.checkNavigable(index), false, dontAnimate);\n                $target.children().trigger('focus');\n                break;\n\n            default:\n                return;\n        }\n\n    };\n\n    Slick.prototype.checkNavigable = function(index) {\n\n        var _ = this,\n            navigables, prevNavigable;\n\n        navigables = _.getNavigableIndexes();\n        prevNavigable = 0;\n        if (index > navigables[navigables.length - 1]) {\n            index = navigables[navigables.length - 1];\n        } else {\n            for (var n in navigables) {\n                if (index < navigables[n]) {\n                    index = prevNavigable;\n                    break;\n                }\n                prevNavigable = navigables[n];\n            }\n        }\n\n        return index;\n    };\n\n    Slick.prototype.cleanUpEvents = function() {\n\n        var _ = this;\n\n        if (_.options.dots && _.$dots !== null) {\n\n            $('li', _.$dots)\n                .off('click.slick', _.changeSlide)\n                .off('mouseenter.slick', $.proxy(_.interrupt, _, true))\n                .off('mouseleave.slick', $.proxy(_.interrupt, _, false));\n\n            if (_.options.accessibility === true) {\n                _.$dots.off('keydown.slick', _.keyHandler);\n            }\n        }\n\n        _.$slider.off('focus.slick blur.slick');\n\n        if (_.options.arrows === true && _.slideCount > _.options.slidesToShow) {\n            _.$prevArrow && _.$prevArrow.off('click.slick', _.changeSlide);\n            _.$nextArrow && _.$nextArrow.off('click.slick', _.changeSlide);\n\n            if (_.options.accessibility === true) {\n                _.$prevArrow && _.$prevArrow.off('keydown.slick', _.keyHandler);\n                _.$nextArrow && _.$nextArrow.off('keydown.slick', _.keyHandler);\n            }\n        }\n\n        _.$list.off('touchstart.slick mousedown.slick', _.swipeHandler);\n        _.$list.off('touchmove.slick mousemove.slick', _.swipeHandler);\n        _.$list.off('touchend.slick mouseup.slick', _.swipeHandler);\n        _.$list.off('touchcancel.slick mouseleave.slick', _.swipeHandler);\n\n        _.$list.off('click.slick', _.clickHandler);\n\n        $(document).off(_.visibilityChange, _.visibility);\n\n        _.cleanUpSlideEvents();\n\n        if (_.options.accessibility === true) {\n            _.$list.off('keydown.slick', _.keyHandler);\n        }\n\n        if (_.options.focusOnSelect === true) {\n            $(_.$slideTrack).children().off('click.slick', _.selectHandler);\n        }\n\n        $(window).off('orientationchange.slick.slick-' + _.instanceUid, _.orientationChange);\n\n        $(window).off('resize.slick.slick-' + _.instanceUid, _.resize);\n\n        $('[draggable!=true]', _.$slideTrack).off('dragstart', _.preventDefault);\n\n        $(window).off('load.slick.slick-' + _.instanceUid, _.setPosition);\n\n    };\n\n    Slick.prototype.cleanUpSlideEvents = function() {\n\n        var _ = this;\n\n        _.$list.off('mouseenter.slick', $.proxy(_.interrupt, _, true));\n        _.$list.off('mouseleave.slick', $.proxy(_.interrupt, _, false));\n\n    };\n\n    Slick.prototype.cleanUpRows = function() {\n\n        var _ = this, originalSlides;\n\n        if(_.options.rows > 0) {\n            originalSlides = _.$slides.children().children();\n            originalSlides.removeAttr('style');\n            _.$slider.empty().append(originalSlides);\n        }\n\n    };\n\n    Slick.prototype.clickHandler = function(event) {\n\n        var _ = this;\n\n        if (_.shouldClick === false) {\n            event.stopImmediatePropagation();\n            event.stopPropagation();\n            event.preventDefault();\n        }\n\n    };\n\n    Slick.prototype.destroy = function(refresh) {\n\n        var _ = this;\n\n        _.autoPlayClear();\n\n        _.touchObject = {};\n\n        _.cleanUpEvents();\n\n        $('.slick-cloned', _.$slider).detach();\n\n        if (_.$dots) {\n            _.$dots.remove();\n        }\n\n        if ( _.$prevArrow && _.$prevArrow.length ) {\n\n            _.$prevArrow\n                .removeClass('slick-disabled slick-arrow slick-hidden')\n                .removeAttr('aria-hidden aria-disabled tabindex')\n                .css('display','');\n\n            if ( _.htmlExpr.test( _.options.prevArrow )) {\n                _.$prevArrow.remove();\n            }\n        }\n\n        if ( _.$nextArrow && _.$nextArrow.length ) {\n\n            _.$nextArrow\n                .removeClass('slick-disabled slick-arrow slick-hidden')\n                .removeAttr('aria-hidden aria-disabled tabindex')\n                .css('display','');\n\n            if ( _.htmlExpr.test( _.options.nextArrow )) {\n                _.$nextArrow.remove();\n            }\n        }\n\n\n        if (_.$slides) {\n\n            _.$slides\n                .removeClass('slick-slide slick-active slick-center slick-visible slick-current')\n                .removeAttr('aria-hidden')\n                .removeAttr('data-slick-index')\n                .each(function(){\n                    $(this).attr('style', $(this).data('originalStyling'));\n                });\n\n            _.$slideTrack.children(this.options.slide).detach();\n\n            _.$slideTrack.detach();\n\n            _.$list.detach();\n\n            _.$slider.append(_.$slides);\n        }\n\n        _.cleanUpRows();\n\n        _.$slider.removeClass('slick-slider');\n        _.$slider.removeClass('slick-initialized');\n        _.$slider.removeClass('slick-dotted');\n\n        _.unslicked = true;\n\n        if(!refresh) {\n            _.$slider.trigger('destroy', [_]);\n        }\n\n    };\n\n    Slick.prototype.disableTransition = function(slide) {\n\n        var _ = this,\n            transition = {};\n\n        transition[_.transitionType] = '';\n\n        if (_.options.fade === false) {\n            _.$slideTrack.css(transition);\n        } else {\n            _.$slides.eq(slide).css(transition);\n        }\n\n    };\n\n    Slick.prototype.fadeSlide = function(slideIndex, callback) {\n\n        var _ = this;\n\n        if (_.cssTransitions === false) {\n\n            _.$slides.eq(slideIndex).css({\n                zIndex: _.options.zIndex\n            });\n\n            _.$slides.eq(slideIndex).animate({\n                opacity: 1\n            }, _.options.speed, _.options.easing, callback);\n\n        } else {\n\n            _.applyTransition(slideIndex);\n\n            _.$slides.eq(slideIndex).css({\n                opacity: 1,\n                zIndex: _.options.zIndex\n            });\n\n            if (callback) {\n                setTimeout(function() {\n\n                    _.disableTransition(slideIndex);\n\n                    callback.call();\n                }, _.options.speed);\n            }\n\n        }\n\n    };\n\n    Slick.prototype.fadeSlideOut = function(slideIndex) {\n\n        var _ = this;\n\n        if (_.cssTransitions === false) {\n\n            _.$slides.eq(slideIndex).animate({\n                opacity: 0,\n                zIndex: _.options.zIndex - 2\n            }, _.options.speed, _.options.easing);\n\n        } else {\n\n            _.applyTransition(slideIndex);\n\n            _.$slides.eq(slideIndex).css({\n                opacity: 0,\n                zIndex: _.options.zIndex - 2\n            });\n\n        }\n\n    };\n\n    Slick.prototype.filterSlides = Slick.prototype.slickFilter = function(filter) {\n\n        var _ = this;\n\n        if (filter !== null) {\n\n            _.$slidesCache = _.$slides;\n\n            _.unload();\n\n            _.$slideTrack.children(this.options.slide).detach();\n\n            _.$slidesCache.filter(filter).appendTo(_.$slideTrack);\n\n            _.reinit();\n\n        }\n\n    };\n\n    Slick.prototype.focusHandler = function() {\n\n        var _ = this;\n\n        // If any child element receives focus within the slider we need to pause the autoplay\n        _.$slider\n            .off('focus.slick blur.slick')\n            .on(\n                'focus.slick',\n                '*',\n                function(event) {\n                    var $sf = $(this);\n\n                    setTimeout(function() {\n                        if( _.options.pauseOnFocus ) {\n                            if ($sf.is(':focus')) {\n                                _.focussed = true;\n                                _.autoPlay();\n                            }\n                        }\n                    }, 0);\n                }\n            ).on(\n            'blur.slick',\n            '*',\n            function(event) {\n                var $sf = $(this);\n\n                // When a blur occurs on any elements within the slider we become unfocused\n                if( _.options.pauseOnFocus ) {\n                    _.focussed = false;\n                    _.autoPlay();\n                }\n            }\n        );\n    };\n\n    Slick.prototype.getCurrent = Slick.prototype.slickCurrentSlide = function() {\n\n        var _ = this;\n        return _.currentSlide;\n\n    };\n\n    Slick.prototype.getDotCount = function() {\n\n        var _ = this;\n\n        var breakPoint = 0;\n        var counter = 0;\n        var pagerQty = 0;\n\n        if (_.options.infinite === true) {\n            if (_.slideCount <= _.options.slidesToShow) {\n                ++pagerQty;\n            } else {\n                while (breakPoint < _.slideCount) {\n                    ++pagerQty;\n                    breakPoint = counter + _.options.slidesToScroll;\n                    counter += _.options.slidesToScroll <= _.options.slidesToShow ? _.options.slidesToScroll : _.options.slidesToShow;\n                }\n            }\n        } else if (_.options.centerMode === true) {\n            pagerQty = _.slideCount;\n        } else if(!_.options.asNavFor) {\n            pagerQty = 1 + Math.ceil((_.slideCount - _.options.slidesToShow) / _.options.slidesToScroll);\n        }else {\n            while (breakPoint < _.slideCount) {\n                ++pagerQty;\n                breakPoint = counter + _.options.slidesToScroll;\n                counter += _.options.slidesToScroll <= _.options.slidesToShow ? _.options.slidesToScroll : _.options.slidesToShow;\n            }\n        }\n\n        return pagerQty - 1;\n\n    };\n\n    Slick.prototype.getLeft = function(slideIndex) {\n\n        var _ = this,\n            targetLeft,\n            verticalHeight,\n            verticalOffset = 0,\n            targetSlide,\n            coef;\n\n        _.slideOffset = 0;\n        verticalHeight = _.$slides.first().outerHeight(true);\n\n        if (_.options.infinite === true) {\n            if (_.slideCount > _.options.slidesToShow) {\n                _.slideOffset = (_.slideWidth * _.options.slidesToShow) * -1;\n                coef = -1\n\n                if (_.options.vertical === true && _.options.centerMode === true) {\n                    if (_.options.slidesToShow === 2) {\n                        coef = -1.5;\n                    } else if (_.options.slidesToShow === 1) {\n                        coef = -2\n                    }\n                }\n                verticalOffset = (verticalHeight * _.options.slidesToShow) * coef;\n            }\n            if (_.slideCount % _.options.slidesToScroll !== 0) {\n                if (slideIndex + _.options.slidesToScroll > _.slideCount && _.slideCount > _.options.slidesToShow) {\n                    if (slideIndex > _.slideCount) {\n                        _.slideOffset = ((_.options.slidesToShow - (slideIndex - _.slideCount)) * _.slideWidth) * -1;\n                        verticalOffset = ((_.options.slidesToShow - (slideIndex - _.slideCount)) * verticalHeight) * -1;\n                    } else {\n                        _.slideOffset = ((_.slideCount % _.options.slidesToScroll) * _.slideWidth) * -1;\n                        verticalOffset = ((_.slideCount % _.options.slidesToScroll) * verticalHeight) * -1;\n                    }\n                }\n            }\n        } else {\n            if (slideIndex + _.options.slidesToShow > _.slideCount) {\n                _.slideOffset = ((slideIndex + _.options.slidesToShow) - _.slideCount) * _.slideWidth;\n                verticalOffset = ((slideIndex + _.options.slidesToShow) - _.slideCount) * verticalHeight;\n            }\n        }\n\n        if (_.slideCount <= _.options.slidesToShow) {\n            _.slideOffset = 0;\n            verticalOffset = 0;\n        }\n\n        if (_.options.centerMode === true && _.slideCount <= _.options.slidesToShow) {\n            _.slideOffset = ((_.slideWidth * Math.floor(_.options.slidesToShow)) / 2) - ((_.slideWidth * _.slideCount) / 2);\n        } else if (_.options.centerMode === true && _.options.infinite === true) {\n            _.slideOffset += _.slideWidth * Math.floor(_.options.slidesToShow / 2) - _.slideWidth;\n        } else if (_.options.centerMode === true) {\n            _.slideOffset = 0;\n            _.slideOffset += _.slideWidth * Math.floor(_.options.slidesToShow / 2);\n        }\n\n        if (_.options.vertical === false) {\n            targetLeft = ((slideIndex * _.slideWidth) * -1) + _.slideOffset;\n        } else {\n            targetLeft = ((slideIndex * verticalHeight) * -1) + verticalOffset;\n        }\n\n        if (_.options.variableWidth === true) {\n\n            if (_.slideCount <= _.options.slidesToShow || _.options.infinite === false) {\n                targetSlide = _.$slideTrack.children('.slick-slide').eq(slideIndex);\n            } else {\n                targetSlide = _.$slideTrack.children('.slick-slide').eq(slideIndex + _.options.slidesToShow);\n            }\n\n            if (_.options.rtl === true) {\n                if (targetSlide[0]) {\n                    targetLeft = (_.$slideTrack.width() - targetSlide[0].offsetLeft - targetSlide.width()) * -1;\n                } else {\n                    targetLeft =  0;\n                }\n            } else {\n                targetLeft = targetSlide[0] ? targetSlide[0].offsetLeft * -1 : 0;\n            }\n\n            if (_.options.centerMode === true) {\n                if (_.slideCount <= _.options.slidesToShow || _.options.infinite === false) {\n                    targetSlide = _.$slideTrack.children('.slick-slide').eq(slideIndex);\n                } else {\n                    targetSlide = _.$slideTrack.children('.slick-slide').eq(slideIndex + _.options.slidesToShow + 1);\n                }\n\n                if (_.options.rtl === true) {\n                    if (targetSlide[0]) {\n                        targetLeft = (_.$slideTrack.width() - targetSlide[0].offsetLeft - targetSlide.width()) * -1;\n                    } else {\n                        targetLeft =  0;\n                    }\n                } else {\n                    targetLeft = targetSlide[0] ? targetSlide[0].offsetLeft * -1 : 0;\n                }\n\n                targetLeft += (_.$list.width() - targetSlide.outerWidth()) / 2;\n            }\n        }\n\n        return targetLeft;\n\n    };\n\n    Slick.prototype.getOption = Slick.prototype.slickGetOption = function(option) {\n\n        var _ = this;\n\n        return _.options[option];\n\n    };\n\n    Slick.prototype.getNavigableIndexes = function() {\n\n        var _ = this,\n            breakPoint = 0,\n            counter = 0,\n            indexes = [],\n            max;\n\n        if (_.options.infinite === false) {\n            max = _.slideCount;\n        } else {\n            breakPoint = _.options.slidesToScroll * -1;\n            counter = _.options.slidesToScroll * -1;\n            max = _.slideCount * 2;\n        }\n\n        while (breakPoint < max) {\n            indexes.push(breakPoint);\n            breakPoint = counter + _.options.slidesToScroll;\n            counter += _.options.slidesToScroll <= _.options.slidesToShow ? _.options.slidesToScroll : _.options.slidesToShow;\n        }\n\n        return indexes;\n\n    };\n\n    Slick.prototype.getSlick = function() {\n\n        return this;\n\n    };\n\n    Slick.prototype.getSlideCount = function() {\n\n        var _ = this,\n            slidesTraversed, swipedSlide, centerOffset;\n\n        centerOffset = _.options.centerMode === true ? _.slideWidth * Math.floor(_.options.slidesToShow / 2) : 0;\n\n        if (_.options.swipeToSlide === true) {\n            _.$slideTrack.find('.slick-slide').each(function(index, slide) {\n                if (slide.offsetLeft - centerOffset + ($(slide).outerWidth() / 2) > (_.swipeLeft * -1)) {\n                    swipedSlide = slide;\n                    return false;\n                }\n            });\n\n            slidesTraversed = Math.abs($(swipedSlide).attr('data-slick-index') - _.currentSlide) || 1;\n\n            return slidesTraversed;\n\n        } else {\n            return _.options.slidesToScroll;\n        }\n\n    };\n\n    Slick.prototype.goTo = Slick.prototype.slickGoTo = function(slide, dontAnimate) {\n\n        var _ = this;\n\n        _.changeSlide({\n            data: {\n                message: 'index',\n                index: parseInt(slide)\n            }\n        }, dontAnimate);\n\n    };\n\n    Slick.prototype.init = function(creation) {\n\n        var _ = this;\n\n        if (!$(_.$slider).hasClass('slick-initialized')) {\n\n            $(_.$slider).addClass('slick-initialized');\n\n            _.buildRows();\n            _.buildOut();\n            _.setProps();\n            _.startLoad();\n            _.loadSlider();\n            _.initializeEvents();\n            _.updateArrows();\n            _.updateDots();\n            _.checkResponsive(true);\n            _.focusHandler();\n\n        }\n\n        if (creation) {\n            _.$slider.trigger('init', [_]);\n        }\n\n        if (_.options.accessibility === true) {\n            _.initADA();\n        }\n\n        if ( _.options.autoplay ) {\n\n            _.paused = false;\n            _.autoPlay();\n\n        }\n\n    };\n\n    Slick.prototype.initADA = function() {\n        var _ = this,\n            numDotGroups = Math.ceil(_.slideCount / _.options.slidesToShow),\n            tabControlIndexes = _.getNavigableIndexes().filter(function(val) {\n                return (val >= 0) && (val < _.slideCount);\n            });\n\n        _.$slides.add(_.$slideTrack.find('.slick-cloned')).attr({\n            'aria-hidden': 'true',\n            'tabindex': '-1'\n        }).find('a, input, button, select').attr({\n            'tabindex': '-1'\n        });\n\n        if (_.$dots !== null) {\n            _.$slides.not(_.$slideTrack.find('.slick-cloned')).each(function(i) {\n                var slideControlIndex = tabControlIndexes.indexOf(i);\n\n                $(this).attr({\n                    'role': 'tabpanel',\n                    'id': 'slick-slide' + _.instanceUid + i,\n                    'tabindex': -1\n                });\n\n                if (slideControlIndex !== -1) {\n                    var ariaButtonControl = 'slick-slide-control' + _.instanceUid + slideControlIndex\n                    if ($('#' + ariaButtonControl).length) {\n                        $(this).attr({\n                            'aria-describedby': ariaButtonControl\n                        });\n                    }\n                }\n            });\n\n            _.$dots.attr('role', 'tablist').find('li').each(function(i) {\n                var mappedSlideIndex = tabControlIndexes[i];\n\n                $(this).attr({\n                    'role': 'presentation'\n                });\n\n                $(this).find('button').first().attr({\n                    'role': 'tab',\n                    'id': 'slick-slide-control' + _.instanceUid + i,\n                    'aria-controls': 'slick-slide' + _.instanceUid + mappedSlideIndex,\n                    'aria-label': (i + 1) + ' of ' + numDotGroups,\n                    'aria-selected': null,\n                    'tabindex': '-1'\n                });\n\n            }).eq(_.currentSlide).find('button').attr({\n                'aria-selected': 'true',\n                'tabindex': '0'\n            }).end();\n        }\n\n        for (var i=_.currentSlide, max=i+_.options.slidesToShow; i < max; i++) {\n            if (_.options.focusOnChange) {\n                _.$slides.eq(i).attr({'tabindex': '0'});\n            } else {\n                _.$slides.eq(i).removeAttr('tabindex');\n            }\n        }\n\n        _.activateADA();\n\n    };\n\n    Slick.prototype.initArrowEvents = function() {\n\n        var _ = this;\n\n        if (_.options.arrows === true && _.slideCount > _.options.slidesToShow) {\n            _.$prevArrow\n                .off('click.slick')\n                .on('click.slick', {\n                    message: 'previous'\n                }, _.changeSlide);\n            _.$nextArrow\n                .off('click.slick')\n                .on('click.slick', {\n                    message: 'next'\n                }, _.changeSlide);\n\n            if (_.options.accessibility === true) {\n                _.$prevArrow.on('keydown.slick', _.keyHandler);\n                _.$nextArrow.on('keydown.slick', _.keyHandler);\n            }\n        }\n\n    };\n\n    Slick.prototype.initDotEvents = function() {\n\n        var _ = this;\n\n        if (_.options.dots === true && _.slideCount > _.options.slidesToShow) {\n            $('li', _.$dots).on('click.slick', {\n                message: 'index'\n            }, _.changeSlide);\n\n            if (_.options.accessibility === true) {\n                _.$dots.on('keydown.slick', _.keyHandler);\n            }\n        }\n\n        if (_.options.dots === true && _.options.pauseOnDotsHover === true && _.slideCount > _.options.slidesToShow) {\n\n            $('li', _.$dots)\n                .on('mouseenter.slick', $.proxy(_.interrupt, _, true))\n                .on('mouseleave.slick', $.proxy(_.interrupt, _, false));\n\n        }\n\n    };\n\n    Slick.prototype.initSlideEvents = function() {\n\n        var _ = this;\n\n        if ( _.options.pauseOnHover ) {\n\n            _.$list.on('mouseenter.slick', $.proxy(_.interrupt, _, true));\n            _.$list.on('mouseleave.slick', $.proxy(_.interrupt, _, false));\n\n        }\n\n    };\n\n    Slick.prototype.initializeEvents = function() {\n\n        var _ = this;\n\n        _.initArrowEvents();\n\n        _.initDotEvents();\n        _.initSlideEvents();\n\n        _.$list.on('touchstart.slick mousedown.slick', {\n            action: 'start'\n        }, _.swipeHandler);\n        _.$list.on('touchmove.slick mousemove.slick', {\n            action: 'move'\n        }, _.swipeHandler);\n        _.$list.on('touchend.slick mouseup.slick', {\n            action: 'end'\n        }, _.swipeHandler);\n        _.$list.on('touchcancel.slick mouseleave.slick', {\n            action: 'end'\n        }, _.swipeHandler);\n\n        _.$list.on('click.slick', _.clickHandler);\n\n        $(document).on(_.visibilityChange, $.proxy(_.visibility, _));\n\n        if (_.options.accessibility === true) {\n            _.$list.on('keydown.slick', _.keyHandler);\n        }\n\n        if (_.options.focusOnSelect === true) {\n            $(_.$slideTrack).children().on('click.slick', _.selectHandler);\n        }\n\n        $(window).on('orientationchange.slick.slick-' + _.instanceUid, $.proxy(_.orientationChange, _));\n\n        $(window).on('resize.slick.slick-' + _.instanceUid, $.proxy(_.resize, _));\n\n        $('[draggable!=true]', _.$slideTrack).on('dragstart', _.preventDefault);\n\n        $(window).on('load.slick.slick-' + _.instanceUid, _.setPosition);\n        $(_.setPosition);\n\n    };\n\n    Slick.prototype.initUI = function() {\n\n        var _ = this;\n\n        if (_.options.arrows === true && _.slideCount > _.options.slidesToShow) {\n\n            _.$prevArrow.show();\n            _.$nextArrow.show();\n\n        }\n\n        if (_.options.dots === true && _.slideCount > _.options.slidesToShow) {\n\n            _.$dots.show();\n\n        }\n\n    };\n\n    Slick.prototype.keyHandler = function(event) {\n\n        var _ = this;\n        //Dont slide if the cursor is inside the form fields and arrow keys are pressed\n        if(!event.target.tagName.match('TEXTAREA|INPUT|SELECT')) {\n            if (event.keyCode === 37 && _.options.accessibility === true) {\n                _.changeSlide({\n                    data: {\n                        message: _.options.rtl === true ? 'next' :  'previous'\n                    }\n                });\n            } else if (event.keyCode === 39 && _.options.accessibility === true) {\n                _.changeSlide({\n                    data: {\n                        message: _.options.rtl === true ? 'previous' : 'next'\n                    }\n                });\n            }\n        }\n\n    };\n\n    Slick.prototype.lazyLoad = function() {\n\n        var _ = this,\n            loadRange, cloneRange, rangeStart, rangeEnd;\n\n        function loadImages(imagesScope) {\n\n            $('img[data-lazy]', imagesScope).each(function() {\n\n                var image = $(this),\n                    imageSource = $(this).attr('data-lazy'),\n                    imageSrcSet = $(this).attr('data-srcset'),\n                    imageSizes  = $(this).attr('data-sizes') || _.$slider.attr('data-sizes'),\n                    imageToLoad = document.createElement('img');\n\n                imageToLoad.onload = function() {\n\n                    image\n                        .animate({ opacity: 0 }, 100, function() {\n\n                            if (imageSrcSet) {\n                                image\n                                    .attr('srcset', imageSrcSet );\n\n                                if (imageSizes) {\n                                    image\n                                        .attr('sizes', imageSizes );\n                                }\n                            }\n\n                            image\n                                .attr('src', imageSource)\n                                .animate({ opacity: 1 }, 200, function() {\n                                    image\n                                        .removeAttr('data-lazy data-srcset data-sizes')\n                                        .removeClass('slick-loading');\n                                });\n                            _.$slider.trigger('lazyLoaded', [_, image, imageSource]);\n                        });\n\n                };\n\n                imageToLoad.onerror = function() {\n\n                    image\n                        .removeAttr( 'data-lazy' )\n                        .removeClass( 'slick-loading' )\n                        .addClass( 'slick-lazyload-error' );\n\n                    _.$slider.trigger('lazyLoadError', [ _, image, imageSource ]);\n\n                };\n\n                imageToLoad.src = imageSource;\n\n            });\n\n        }\n\n        if (_.options.centerMode === true) {\n            if (_.options.infinite === true) {\n                rangeStart = _.currentSlide + (_.options.slidesToShow / 2 + 1);\n                rangeEnd = rangeStart + _.options.slidesToShow + 2;\n            } else {\n                rangeStart = Math.max(0, _.currentSlide - (_.options.slidesToShow / 2 + 1));\n                rangeEnd = 2 + (_.options.slidesToShow / 2 + 1) + _.currentSlide;\n            }\n        } else {\n            rangeStart = _.options.infinite ? _.options.slidesToShow + _.currentSlide : _.currentSlide;\n            rangeEnd = Math.ceil(rangeStart + _.options.slidesToShow);\n            if (_.options.fade === true) {\n                if (rangeStart > 0) rangeStart--;\n                if (rangeEnd <= _.slideCount) rangeEnd++;\n            }\n        }\n\n        loadRange = _.$slider.find('.slick-slide').slice(rangeStart, rangeEnd);\n\n        if (_.options.lazyLoad === 'anticipated') {\n            var prevSlide = rangeStart - 1,\n                nextSlide = rangeEnd,\n                $slides = _.$slider.find('.slick-slide');\n\n            for (var i = 0; i < _.options.slidesToScroll; i++) {\n                if (prevSlide < 0) prevSlide = _.slideCount - 1;\n                loadRange = loadRange.add($slides.eq(prevSlide));\n                loadRange = loadRange.add($slides.eq(nextSlide));\n                prevSlide--;\n                nextSlide++;\n            }\n        }\n\n        loadImages(loadRange);\n\n        if (_.slideCount <= _.options.slidesToShow) {\n            cloneRange = _.$slider.find('.slick-slide');\n            loadImages(cloneRange);\n        } else\n        if (_.currentSlide >= _.slideCount - _.options.slidesToShow) {\n            cloneRange = _.$slider.find('.slick-cloned').slice(0, _.options.slidesToShow);\n            loadImages(cloneRange);\n        } else if (_.currentSlide === 0) {\n            cloneRange = _.$slider.find('.slick-cloned').slice(_.options.slidesToShow * -1);\n            loadImages(cloneRange);\n        }\n\n    };\n\n    Slick.prototype.loadSlider = function() {\n\n        var _ = this;\n\n        _.setPosition();\n\n        _.$slideTrack.css({\n            opacity: 1\n        });\n\n        _.$slider.removeClass('slick-loading');\n\n        _.initUI();\n\n        if (_.options.lazyLoad === 'progressive') {\n            _.progressiveLazyLoad();\n        }\n\n    };\n\n    Slick.prototype.next = Slick.prototype.slickNext = function() {\n\n        var _ = this;\n\n        _.changeSlide({\n            data: {\n                message: 'next'\n            }\n        });\n\n    };\n\n    Slick.prototype.orientationChange = function() {\n\n        var _ = this;\n\n        _.checkResponsive();\n        _.setPosition();\n\n    };\n\n    Slick.prototype.pause = Slick.prototype.slickPause = function() {\n\n        var _ = this;\n\n        _.autoPlayClear();\n        _.paused = true;\n\n    };\n\n    Slick.prototype.play = Slick.prototype.slickPlay = function() {\n\n        var _ = this;\n\n        _.autoPlay();\n        _.options.autoplay = true;\n        _.paused = false;\n        _.focussed = false;\n        _.interrupted = false;\n\n    };\n\n    Slick.prototype.postSlide = function(index) {\n\n        var _ = this;\n\n        if( !_.unslicked ) {\n\n            _.$slider.trigger('afterChange', [_, index]);\n\n            _.animating = false;\n\n            if (_.slideCount > _.options.slidesToShow) {\n                _.setPosition();\n            }\n\n            _.swipeLeft = null;\n\n            if ( _.options.autoplay ) {\n                _.autoPlay();\n            }\n\n            if (_.options.accessibility === true) {\n                _.initADA();\n\n                if (_.options.focusOnChange) {\n                    var $currentSlide = $(_.$slides.get(_.currentSlide));\n                    $currentSlide.attr('tabindex', 0).focus();\n                }\n            }\n\n        }\n\n    };\n\n    Slick.prototype.prev = Slick.prototype.slickPrev = function() {\n\n        var _ = this;\n\n        _.changeSlide({\n            data: {\n                message: 'previous'\n            }\n        });\n\n    };\n\n    Slick.prototype.preventDefault = function(event) {\n\n        event.preventDefault();\n\n    };\n\n    Slick.prototype.progressiveLazyLoad = function( tryCount ) {\n\n        tryCount = tryCount || 1;\n\n        var _ = this,\n            $imgsToLoad = $( 'img[data-lazy]', _.$slider ),\n            image,\n            imageSource,\n            imageSrcSet,\n            imageSizes,\n            imageToLoad;\n\n        if ( $imgsToLoad.length ) {\n\n            image = $imgsToLoad.first();\n            imageSource = image.attr('data-lazy');\n            imageSrcSet = image.attr('data-srcset');\n            imageSizes  = image.attr('data-sizes') || _.$slider.attr('data-sizes');\n            imageToLoad = document.createElement('img');\n\n            imageToLoad.onload = function() {\n\n                if (imageSrcSet) {\n                    image\n                        .attr('srcset', imageSrcSet );\n\n                    if (imageSizes) {\n                        image\n                            .attr('sizes', imageSizes );\n                    }\n                }\n\n                image\n                    .attr( 'src', imageSource )\n                    .removeAttr('data-lazy data-srcset data-sizes')\n                    .removeClass('slick-loading');\n\n                if ( _.options.adaptiveHeight === true ) {\n                    _.setPosition();\n                }\n\n                _.$slider.trigger('lazyLoaded', [ _, image, imageSource ]);\n                _.progressiveLazyLoad();\n\n            };\n\n            imageToLoad.onerror = function() {\n\n                if ( tryCount < 3 ) {\n\n                    /**\n                     * try to load the image 3 times,\n                     * leave a slight delay so we don't get\n                     * servers blocking the request.\n                     */\n                    setTimeout( function() {\n                        _.progressiveLazyLoad( tryCount + 1 );\n                    }, 500 );\n\n                } else {\n\n                    image\n                        .removeAttr( 'data-lazy' )\n                        .removeClass( 'slick-loading' )\n                        .addClass( 'slick-lazyload-error' );\n\n                    _.$slider.trigger('lazyLoadError', [ _, image, imageSource ]);\n\n                    _.progressiveLazyLoad();\n\n                }\n\n            };\n\n            imageToLoad.src = imageSource;\n\n        } else {\n\n            _.$slider.trigger('allImagesLoaded', [ _ ]);\n\n        }\n\n    };\n\n    Slick.prototype.refresh = function( initializing ) {\n\n        var _ = this, currentSlide, lastVisibleIndex;\n\n        lastVisibleIndex = _.slideCount - _.options.slidesToShow;\n\n        // in non-infinite sliders, we don't want to go past the\n        // last visible index.\n        if( !_.options.infinite && ( _.currentSlide > lastVisibleIndex )) {\n            _.currentSlide = lastVisibleIndex;\n        }\n\n        // if less slides than to show, go to start.\n        if ( _.slideCount <= _.options.slidesToShow ) {\n            _.currentSlide = 0;\n\n        }\n\n        currentSlide = _.currentSlide;\n\n        _.destroy(true);\n\n        $.extend(_, _.initials, { currentSlide: currentSlide });\n\n        _.init();\n\n        if( !initializing ) {\n\n            _.changeSlide({\n                data: {\n                    message: 'index',\n                    index: currentSlide\n                }\n            }, false);\n\n        }\n\n    };\n\n    Slick.prototype.registerBreakpoints = function() {\n\n        var _ = this, breakpoint, currentBreakpoint, l,\n            responsiveSettings = _.options.responsive || null;\n\n        if ( $.type(responsiveSettings) === 'array' && responsiveSettings.length ) {\n\n            _.respondTo = _.options.respondTo || 'window';\n\n            for ( breakpoint in responsiveSettings ) {\n\n                l = _.breakpoints.length-1;\n\n                if (responsiveSettings.hasOwnProperty(breakpoint)) {\n                    currentBreakpoint = responsiveSettings[breakpoint].breakpoint;\n\n                    // loop through the breakpoints and cut out any existing\n                    // ones with the same breakpoint number, we don't want dupes.\n                    while( l >= 0 ) {\n                        if( _.breakpoints[l] && _.breakpoints[l] === currentBreakpoint ) {\n                            _.breakpoints.splice(l,1);\n                        }\n                        l--;\n                    }\n\n                    _.breakpoints.push(currentBreakpoint);\n                    _.breakpointSettings[currentBreakpoint] = responsiveSettings[breakpoint].settings;\n\n                }\n\n            }\n\n            _.breakpoints.sort(function(a, b) {\n                return ( _.options.mobileFirst ) ? a-b : b-a;\n            });\n\n        }\n\n    };\n\n    Slick.prototype.reinit = function() {\n\n        var _ = this;\n\n        _.$slides =\n            _.$slideTrack\n                .children(_.options.slide)\n                .addClass('slick-slide');\n\n        _.slideCount = _.$slides.length;\n\n        if (_.currentSlide >= _.slideCount && _.currentSlide !== 0) {\n            _.currentSlide = _.currentSlide - _.options.slidesToScroll;\n        }\n\n        if (_.slideCount <= _.options.slidesToShow) {\n            _.currentSlide = 0;\n        }\n\n        _.registerBreakpoints();\n\n        _.setProps();\n        _.setupInfinite();\n        _.buildArrows();\n        _.updateArrows();\n        _.initArrowEvents();\n        _.buildDots();\n        _.updateDots();\n        _.initDotEvents();\n        _.cleanUpSlideEvents();\n        _.initSlideEvents();\n\n        _.checkResponsive(false, true);\n\n        if (_.options.focusOnSelect === true) {\n            $(_.$slideTrack).children().on('click.slick', _.selectHandler);\n        }\n\n        _.setSlideClasses(typeof _.currentSlide === 'number' ? _.currentSlide : 0);\n\n        _.setPosition();\n        _.focusHandler();\n\n        _.paused = !_.options.autoplay;\n        _.autoPlay();\n\n        _.$slider.trigger('reInit', [_]);\n\n    };\n\n    Slick.prototype.resize = function() {\n\n        var _ = this;\n\n        if ($(window).width() !== _.windowWidth) {\n            clearTimeout(_.windowDelay);\n            _.windowDelay = window.setTimeout(function() {\n                _.windowWidth = $(window).width();\n                _.checkResponsive();\n                if( !_.unslicked ) { _.setPosition(); }\n            }, 50);\n        }\n    };\n\n    Slick.prototype.removeSlide = Slick.prototype.slickRemove = function(index, removeBefore, removeAll) {\n\n        var _ = this;\n\n        if (typeof(index) === 'boolean') {\n            removeBefore = index;\n            index = removeBefore === true ? 0 : _.slideCount - 1;\n        } else {\n            index = removeBefore === true ? --index : index;\n        }\n\n        if (_.slideCount < 1 || index < 0 || index > _.slideCount - 1) {\n            return false;\n        }\n\n        _.unload();\n\n        if (removeAll === true) {\n            _.$slideTrack.children().remove();\n        } else {\n            _.$slideTrack.children(this.options.slide).eq(index).remove();\n        }\n\n        _.$slides = _.$slideTrack.children(this.options.slide);\n\n        _.$slideTrack.children(this.options.slide).detach();\n\n        _.$slideTrack.append(_.$slides);\n\n        _.$slidesCache = _.$slides;\n\n        _.reinit();\n\n    };\n\n    Slick.prototype.setCSS = function(position) {\n\n        var _ = this,\n            positionProps = {},\n            x, y;\n\n        if (_.options.rtl === true) {\n            position = -position;\n        }\n        x = _.positionProp == 'left' ? Math.ceil(position) + 'px' : '0px';\n        y = _.positionProp == 'top' ? Math.ceil(position) + 'px' : '0px';\n\n        positionProps[_.positionProp] = position;\n\n        if (_.transformsEnabled === false) {\n            _.$slideTrack.css(positionProps);\n        } else {\n            positionProps = {};\n            if (_.cssTransitions === false) {\n                positionProps[_.animType] = 'translate(' + x + ', ' + y + ')';\n                _.$slideTrack.css(positionProps);\n            } else {\n                positionProps[_.animType] = 'translate3d(' + x + ', ' + y + ', 0px)';\n                _.$slideTrack.css(positionProps);\n            }\n        }\n\n    };\n\n    Slick.prototype.setDimensions = function() {\n\n        var _ = this;\n\n        if (_.options.vertical === false) {\n            if (_.options.centerMode === true) {\n                _.$list.css({\n                    padding: ('0px ' + _.options.centerPadding)\n                });\n            }\n        } else {\n            _.$list.height(_.$slides.first().outerHeight(true) * _.options.slidesToShow);\n            if (_.options.centerMode === true) {\n                _.$list.css({\n                    padding: (_.options.centerPadding + ' 0px')\n                });\n            }\n        }\n\n        _.listWidth = _.$list.width();\n        _.listHeight = _.$list.height();\n\n\n        if (_.options.vertical === false && _.options.variableWidth === false) {\n            _.slideWidth = Math.ceil(_.listWidth / _.options.slidesToShow);\n            _.$slideTrack.width(Math.ceil((_.slideWidth * _.$slideTrack.children('.slick-slide').length)));\n\n        } else if (_.options.variableWidth === true) {\n            _.$slideTrack.width(5000 * _.slideCount);\n        } else {\n            _.slideWidth = Math.ceil(_.listWidth);\n            _.$slideTrack.height(Math.ceil((_.$slides.first().outerHeight(true) * _.$slideTrack.children('.slick-slide').length)));\n        }\n\n        var offset = _.$slides.first().outerWidth(true) - _.$slides.first().width();\n        if (_.options.variableWidth === false) _.$slideTrack.children('.slick-slide').width(_.slideWidth - offset);\n\n    };\n\n    Slick.prototype.setFade = function() {\n\n        var _ = this,\n            targetLeft;\n\n        _.$slides.each(function(index, element) {\n            targetLeft = (_.slideWidth * index) * -1;\n            if (_.options.rtl === true) {\n                $(element).css({\n                    position: 'relative',\n                    right: targetLeft,\n                    top: 0,\n                    zIndex: _.options.zIndex - 2,\n                    opacity: 0\n                });\n            } else {\n                $(element).css({\n                    position: 'relative',\n                    left: targetLeft,\n                    top: 0,\n                    zIndex: _.options.zIndex - 2,\n                    opacity: 0\n                });\n            }\n        });\n\n        _.$slides.eq(_.currentSlide).css({\n            zIndex: _.options.zIndex - 1,\n            opacity: 1\n        });\n\n    };\n\n    Slick.prototype.setHeight = function() {\n\n        var _ = this;\n\n        if (_.options.slidesToShow === 1 && _.options.adaptiveHeight === true && _.options.vertical === false) {\n            var targetHeight = _.$slides.eq(_.currentSlide).outerHeight(true);\n            _.$list.css('height', targetHeight);\n        }\n\n    };\n\n    Slick.prototype.setOption =\n        Slick.prototype.slickSetOption = function() {\n\n            /**\n             * accepts arguments in format of:\n             *\n             *  - for changing a single option's value:\n             *     .slick(\"setOption\", option, value, refresh )\n             *\n             *  - for changing a set of responsive options:\n             *     .slick(\"setOption\", 'responsive', [{}, ...], refresh )\n             *\n             *  - for updating multiple values at once (not responsive)\n             *     .slick(\"setOption\", { 'option': value, ... }, refresh )\n             */\n\n            var _ = this, l, item, option, value, refresh = false, type;\n\n            if( $.type( arguments[0] ) === 'object' ) {\n\n                option =  arguments[0];\n                refresh = arguments[1];\n                type = 'multiple';\n\n            } else if ( $.type( arguments[0] ) === 'string' ) {\n\n                option =  arguments[0];\n                value = arguments[1];\n                refresh = arguments[2];\n\n                if ( arguments[0] === 'responsive' && $.type( arguments[1] ) === 'array' ) {\n\n                    type = 'responsive';\n\n                } else if ( typeof arguments[1] !== 'undefined' ) {\n\n                    type = 'single';\n\n                }\n\n            }\n\n            if ( type === 'single' ) {\n\n                _.options[option] = value;\n\n\n            } else if ( type === 'multiple' ) {\n\n                $.each( option , function( opt, val ) {\n\n                    _.options[opt] = val;\n\n                });\n\n\n            } else if ( type === 'responsive' ) {\n\n                for ( item in value ) {\n\n                    if( $.type( _.options.responsive ) !== 'array' ) {\n\n                        _.options.responsive = [ value[item] ];\n\n                    } else {\n\n                        l = _.options.responsive.length-1;\n\n                        // loop through the responsive object and splice out duplicates.\n                        while( l >= 0 ) {\n\n                            if( _.options.responsive[l].breakpoint === value[item].breakpoint ) {\n\n                                _.options.responsive.splice(l,1);\n\n                            }\n\n                            l--;\n\n                        }\n\n                        _.options.responsive.push( value[item] );\n\n                    }\n\n                }\n\n            }\n\n            if ( refresh ) {\n\n                _.unload();\n                _.reinit();\n\n            }\n\n        };\n\n    Slick.prototype.setPosition = function() {\n\n        var _ = this;\n\n        _.setDimensions();\n\n        _.setHeight();\n\n        if (_.options.fade === false) {\n            _.setCSS(_.getLeft(_.currentSlide));\n        } else {\n            _.setFade();\n        }\n\n        _.$slider.trigger('setPosition', [_]);\n\n    };\n\n    Slick.prototype.setProps = function() {\n\n        var _ = this,\n            bodyStyle = document.body.style;\n\n        _.positionProp = _.options.vertical === true ? 'top' : 'left';\n\n        if (_.positionProp === 'top') {\n            _.$slider.addClass('slick-vertical');\n        } else {\n            _.$slider.removeClass('slick-vertical');\n        }\n\n        if (bodyStyle.WebkitTransition !== undefined ||\n            bodyStyle.MozTransition !== undefined ||\n            bodyStyle.msTransition !== undefined) {\n            if (_.options.useCSS === true) {\n                _.cssTransitions = true;\n            }\n        }\n\n        if ( _.options.fade ) {\n            if ( typeof _.options.zIndex === 'number' ) {\n                if( _.options.zIndex < 3 ) {\n                    _.options.zIndex = 3;\n                }\n            } else {\n                _.options.zIndex = _.defaults.zIndex;\n            }\n        }\n\n        if (bodyStyle.OTransform !== undefined) {\n            _.animType = 'OTransform';\n            _.transformType = '-o-transform';\n            _.transitionType = 'OTransition';\n            if (bodyStyle.perspectiveProperty === undefined && bodyStyle.webkitPerspective === undefined) _.animType = false;\n        }\n        if (bodyStyle.MozTransform !== undefined) {\n            _.animType = 'MozTransform';\n            _.transformType = '-moz-transform';\n            _.transitionType = 'MozTransition';\n            if (bodyStyle.perspectiveProperty === undefined && bodyStyle.MozPerspective === undefined) _.animType = false;\n        }\n        if (bodyStyle.webkitTransform !== undefined) {\n            _.animType = 'webkitTransform';\n            _.transformType = '-webkit-transform';\n            _.transitionType = 'webkitTransition';\n            if (bodyStyle.perspectiveProperty === undefined && bodyStyle.webkitPerspective === undefined) _.animType = false;\n        }\n        if (bodyStyle.msTransform !== undefined) {\n            _.animType = 'msTransform';\n            _.transformType = '-ms-transform';\n            _.transitionType = 'msTransition';\n            if (bodyStyle.msTransform === undefined) _.animType = false;\n        }\n        if (bodyStyle.transform !== undefined && _.animType !== false) {\n            _.animType = 'transform';\n            _.transformType = 'transform';\n            _.transitionType = 'transition';\n        }\n        _.transformsEnabled = _.options.useTransform && (_.animType !== null && _.animType !== false);\n    };\n\n\n    Slick.prototype.setSlideClasses = function(index) {\n\n        var _ = this,\n            centerOffset, allSlides, indexOffset, remainder;\n\n        allSlides = _.$slider\n            .find('.slick-slide')\n            .removeClass('slick-active slick-center slick-current')\n            .attr('aria-hidden', 'true');\n\n        _.$slides\n            .eq(index)\n            .addClass('slick-current');\n\n        if (_.options.centerMode === true) {\n\n            var evenCoef = _.options.slidesToShow % 2 === 0 ? 1 : 0;\n\n            centerOffset = Math.floor(_.options.slidesToShow / 2);\n\n            if (_.options.infinite === true) {\n\n                if (index >= centerOffset && index <= (_.slideCount - 1) - centerOffset) {\n                    _.$slides\n                        .slice(index - centerOffset + evenCoef, index + centerOffset + 1)\n                        .addClass('slick-active')\n                        .attr('aria-hidden', 'false');\n\n                } else {\n\n                    indexOffset = _.options.slidesToShow + index;\n                    allSlides\n                        .slice(indexOffset - centerOffset + 1 + evenCoef, indexOffset + centerOffset + 2)\n                        .addClass('slick-active')\n                        .attr('aria-hidden', 'false');\n\n                }\n\n                if (index === 0) {\n\n                    allSlides\n                        .eq(allSlides.length - 1 - _.options.slidesToShow)\n                        .addClass('slick-center');\n\n                } else if (index === _.slideCount - 1) {\n\n                    allSlides\n                        .eq(_.options.slidesToShow)\n                        .addClass('slick-center');\n\n                }\n\n            }\n\n            _.$slides\n                .eq(index)\n                .addClass('slick-center');\n\n        } else {\n\n            if (index >= 0 && index <= (_.slideCount - _.options.slidesToShow)) {\n\n                _.$slides\n                    .slice(index, index + _.options.slidesToShow)\n                    .addClass('slick-active')\n                    .attr('aria-hidden', 'false');\n\n            } else if (allSlides.length <= _.options.slidesToShow) {\n\n                allSlides\n                    .addClass('slick-active')\n                    .attr('aria-hidden', 'false');\n\n            } else {\n\n                remainder = _.slideCount % _.options.slidesToShow;\n                indexOffset = _.options.infinite === true ? _.options.slidesToShow + index : index;\n\n                if (_.options.slidesToShow == _.options.slidesToScroll && (_.slideCount - index) < _.options.slidesToShow) {\n\n                    allSlides\n                        .slice(indexOffset - (_.options.slidesToShow - remainder), indexOffset + remainder)\n                        .addClass('slick-active')\n                        .attr('aria-hidden', 'false');\n\n                } else {\n\n                    allSlides\n                        .slice(indexOffset, indexOffset + _.options.slidesToShow)\n                        .addClass('slick-active')\n                        .attr('aria-hidden', 'false');\n\n                }\n\n            }\n\n        }\n\n        if (_.options.lazyLoad === 'ondemand' || _.options.lazyLoad === 'anticipated') {\n            _.lazyLoad();\n        }\n    };\n\n    Slick.prototype.setupInfinite = function() {\n\n        var _ = this,\n            i, slideIndex, infiniteCount;\n\n        if (_.options.fade === true) {\n            _.options.centerMode = false;\n        }\n\n        if (_.options.infinite === true && _.options.fade === false) {\n\n            slideIndex = null;\n\n            if (_.slideCount > _.options.slidesToShow) {\n\n                if (_.options.centerMode === true) {\n                    infiniteCount = _.options.slidesToShow + 1;\n                } else {\n                    infiniteCount = _.options.slidesToShow;\n                }\n\n                for (i = _.slideCount; i > (_.slideCount -\n                    infiniteCount); i -= 1) {\n                    slideIndex = i - 1;\n                    $(_.$slides[slideIndex]).clone(true).attr('id', '')\n                        .attr('data-slick-index', slideIndex - _.slideCount)\n                        .prependTo(_.$slideTrack).addClass('slick-cloned');\n                }\n                for (i = 0; i < infiniteCount  + _.slideCount; i += 1) {\n                    slideIndex = i;\n                    $(_.$slides[slideIndex]).clone(true).attr('id', '')\n                        .attr('data-slick-index', slideIndex + _.slideCount)\n                        .appendTo(_.$slideTrack).addClass('slick-cloned');\n                }\n                _.$slideTrack.find('.slick-cloned').find('[id]').each(function() {\n                    $(this).attr('id', '');\n                });\n\n            }\n\n        }\n\n    };\n\n    Slick.prototype.interrupt = function( toggle ) {\n\n        var _ = this;\n\n        if( !toggle ) {\n            _.autoPlay();\n        }\n        _.interrupted = toggle;\n\n    };\n\n    Slick.prototype.selectHandler = function(event) {\n\n        var _ = this;\n\n        var targetElement =\n            $(event.target).is('.slick-slide') ?\n                $(event.target) :\n                $(event.target).parents('.slick-slide');\n\n        var index = parseInt(targetElement.attr('data-slick-index'));\n\n        if (!index) index = 0;\n\n        if (_.slideCount <= _.options.slidesToShow) {\n\n            _.slideHandler(index, false, true);\n            return;\n\n        }\n\n        _.slideHandler(index);\n\n    };\n\n    Slick.prototype.slideHandler = function(index, sync, dontAnimate) {\n\n        var targetSlide, animSlide, oldSlide, slideLeft, targetLeft = null,\n            _ = this, navTarget;\n\n        sync = sync || false;\n\n        if (_.animating === true && _.options.waitForAnimate === true) {\n            return;\n        }\n\n        if (_.options.fade === true && _.currentSlide === index) {\n            return;\n        }\n\n        if (sync === false) {\n            _.asNavFor(index);\n        }\n\n        targetSlide = index;\n        targetLeft = _.getLeft(targetSlide);\n        slideLeft = _.getLeft(_.currentSlide);\n\n        _.currentLeft = _.swipeLeft === null ? slideLeft : _.swipeLeft;\n\n        if (_.options.infinite === false && _.options.centerMode === false && (index < 0 || index > _.getDotCount() * _.options.slidesToScroll)) {\n            if (_.options.fade === false) {\n                targetSlide = _.currentSlide;\n                if (dontAnimate !== true && _.slideCount > _.options.slidesToShow) {\n                    _.animateSlide(slideLeft, function() {\n                        _.postSlide(targetSlide);\n                    });\n                } else {\n                    _.postSlide(targetSlide);\n                }\n            }\n            return;\n        } else if (_.options.infinite === false && _.options.centerMode === true && (index < 0 || index > (_.slideCount - _.options.slidesToScroll))) {\n            if (_.options.fade === false) {\n                targetSlide = _.currentSlide;\n                if (dontAnimate !== true && _.slideCount > _.options.slidesToShow) {\n                    _.animateSlide(slideLeft, function() {\n                        _.postSlide(targetSlide);\n                    });\n                } else {\n                    _.postSlide(targetSlide);\n                }\n            }\n            return;\n        }\n\n        if ( _.options.autoplay ) {\n            clearInterval(_.autoPlayTimer);\n        }\n\n        if (targetSlide < 0) {\n            if (_.slideCount % _.options.slidesToScroll !== 0) {\n                animSlide = _.slideCount - (_.slideCount % _.options.slidesToScroll);\n            } else {\n                animSlide = _.slideCount + targetSlide;\n            }\n        } else if (targetSlide >= _.slideCount) {\n            if (_.slideCount % _.options.slidesToScroll !== 0) {\n                animSlide = 0;\n            } else {\n                animSlide = targetSlide - _.slideCount;\n            }\n        } else {\n            animSlide = targetSlide;\n        }\n\n        _.animating = true;\n\n        _.$slider.trigger('beforeChange', [_, _.currentSlide, animSlide]);\n\n        oldSlide = _.currentSlide;\n        _.currentSlide = animSlide;\n\n        _.setSlideClasses(_.currentSlide);\n\n        if ( _.options.asNavFor ) {\n\n            navTarget = _.getNavTarget();\n            navTarget = navTarget.slick('getSlick');\n\n            if ( navTarget.slideCount <= navTarget.options.slidesToShow ) {\n                navTarget.setSlideClasses(_.currentSlide);\n            }\n\n        }\n\n        _.updateDots();\n        _.updateArrows();\n\n        if (_.options.fade === true) {\n            if (dontAnimate !== true) {\n\n                _.fadeSlideOut(oldSlide);\n\n                _.fadeSlide(animSlide, function() {\n                    _.postSlide(animSlide);\n                });\n\n            } else {\n                _.postSlide(animSlide);\n            }\n            _.animateHeight();\n            return;\n        }\n\n        if (dontAnimate !== true && _.slideCount > _.options.slidesToShow) {\n            _.animateSlide(targetLeft, function() {\n                _.postSlide(animSlide);\n            });\n        } else {\n            _.postSlide(animSlide);\n        }\n\n    };\n\n    Slick.prototype.startLoad = function() {\n\n        var _ = this;\n\n        if (_.options.arrows === true && _.slideCount > _.options.slidesToShow) {\n\n            _.$prevArrow.hide();\n            _.$nextArrow.hide();\n\n        }\n\n        if (_.options.dots === true && _.slideCount > _.options.slidesToShow) {\n\n            _.$dots.hide();\n\n        }\n\n        _.$slider.addClass('slick-loading');\n\n    };\n\n    Slick.prototype.swipeDirection = function() {\n\n        var xDist, yDist, r, swipeAngle, _ = this;\n\n        xDist = _.touchObject.startX - _.touchObject.curX;\n        yDist = _.touchObject.startY - _.touchObject.curY;\n        r = Math.atan2(yDist, xDist);\n\n        swipeAngle = Math.round(r * 180 / Math.PI);\n        if (swipeAngle < 0) {\n            swipeAngle = 360 - Math.abs(swipeAngle);\n        }\n\n        if ((swipeAngle <= 45) && (swipeAngle >= 0)) {\n            return (_.options.rtl === false ? 'left' : 'right');\n        }\n        if ((swipeAngle <= 360) && (swipeAngle >= 315)) {\n            return (_.options.rtl === false ? 'left' : 'right');\n        }\n        if ((swipeAngle >= 135) && (swipeAngle <= 225)) {\n            return (_.options.rtl === false ? 'right' : 'left');\n        }\n        if (_.options.verticalSwiping === true) {\n            if ((swipeAngle >= 35) && (swipeAngle <= 135)) {\n                return 'down';\n            } else {\n                return 'up';\n            }\n        }\n\n        return 'vertical';\n\n    };\n\n    Slick.prototype.swipeEnd = function(event) {\n\n        var _ = this,\n            slideCount,\n            direction;\n\n        _.dragging = false;\n        _.swiping = false;\n\n        if (_.scrolling) {\n            _.scrolling = false;\n            return false;\n        }\n\n        _.interrupted = false;\n        _.shouldClick = ( _.touchObject.swipeLength > 10 ) ? false : true;\n\n        if ( _.touchObject.curX === undefined ) {\n            return false;\n        }\n\n        if ( _.touchObject.edgeHit === true ) {\n            _.$slider.trigger('edge', [_, _.swipeDirection() ]);\n        }\n\n        if ( _.touchObject.swipeLength >= _.touchObject.minSwipe ) {\n\n            direction = _.swipeDirection();\n\n            switch ( direction ) {\n\n                case 'left':\n                case 'down':\n\n                    slideCount =\n                        _.options.swipeToSlide ?\n                            _.checkNavigable( _.currentSlide + _.getSlideCount() ) :\n                            _.currentSlide + _.getSlideCount();\n\n                    _.currentDirection = 0;\n\n                    break;\n\n                case 'right':\n                case 'up':\n\n                    slideCount =\n                        _.options.swipeToSlide ?\n                            _.checkNavigable( _.currentSlide - _.getSlideCount() ) :\n                            _.currentSlide - _.getSlideCount();\n\n                    _.currentDirection = 1;\n\n                    break;\n\n                default:\n\n\n            }\n\n            if( direction != 'vertical' ) {\n\n                _.slideHandler( slideCount );\n                _.touchObject = {};\n                _.$slider.trigger('swipe', [_, direction ]);\n\n            }\n\n        } else {\n\n            if ( _.touchObject.startX !== _.touchObject.curX ) {\n\n                _.slideHandler( _.currentSlide );\n                _.touchObject = {};\n\n            }\n\n        }\n\n    };\n\n    Slick.prototype.swipeHandler = function(event) {\n\n        var _ = this;\n\n        if ((_.options.swipe === false) || ('ontouchend' in document && _.options.swipe === false)) {\n            return;\n        } else if (_.options.draggable === false && event.type.indexOf('mouse') !== -1) {\n            return;\n        }\n\n        _.touchObject.fingerCount = event.originalEvent && event.originalEvent.touches !== undefined ?\n            event.originalEvent.touches.length : 1;\n\n        _.touchObject.minSwipe = _.listWidth / _.options\n            .touchThreshold;\n\n        if (_.options.verticalSwiping === true) {\n            _.touchObject.minSwipe = _.listHeight / _.options\n                .touchThreshold;\n        }\n\n        switch (event.data.action) {\n\n            case 'start':\n                _.swipeStart(event);\n                break;\n\n            case 'move':\n                _.swipeMove(event);\n                break;\n\n            case 'end':\n                _.swipeEnd(event);\n                break;\n\n        }\n\n    };\n\n    Slick.prototype.swipeMove = function(event) {\n\n        var _ = this,\n            edgeWasHit = false,\n            curLeft, swipeDirection, swipeLength, positionOffset, touches, verticalSwipeLength;\n\n        touches = event.originalEvent !== undefined ? event.originalEvent.touches : null;\n\n        if (!_.dragging || _.scrolling || touches && touches.length !== 1) {\n            return false;\n        }\n\n        curLeft = _.getLeft(_.currentSlide);\n\n        _.touchObject.curX = touches !== undefined ? touches[0].pageX : event.clientX;\n        _.touchObject.curY = touches !== undefined ? touches[0].pageY : event.clientY;\n\n        _.touchObject.swipeLength = Math.round(Math.sqrt(\n            Math.pow(_.touchObject.curX - _.touchObject.startX, 2)));\n\n        verticalSwipeLength = Math.round(Math.sqrt(\n            Math.pow(_.touchObject.curY - _.touchObject.startY, 2)));\n\n        if (!_.options.verticalSwiping && !_.swiping && verticalSwipeLength > 4) {\n            _.scrolling = true;\n            return false;\n        }\n\n        if (_.options.verticalSwiping === true) {\n            _.touchObject.swipeLength = verticalSwipeLength;\n        }\n\n        swipeDirection = _.swipeDirection();\n\n        if (event.originalEvent !== undefined && _.touchObject.swipeLength > 4) {\n            _.swiping = true;\n            event.preventDefault();\n        }\n\n        positionOffset = (_.options.rtl === false ? 1 : -1) * (_.touchObject.curX > _.touchObject.startX ? 1 : -1);\n        if (_.options.verticalSwiping === true) {\n            positionOffset = _.touchObject.curY > _.touchObject.startY ? 1 : -1;\n        }\n\n\n        swipeLength = _.touchObject.swipeLength;\n\n        _.touchObject.edgeHit = false;\n\n        if (_.options.infinite === false) {\n            if ((_.currentSlide === 0 && swipeDirection === 'right') || (_.currentSlide >= _.getDotCount() && swipeDirection === 'left')) {\n                swipeLength = _.touchObject.swipeLength * _.options.edgeFriction;\n                _.touchObject.edgeHit = true;\n            }\n        }\n\n        if (_.options.vertical === false) {\n            _.swipeLeft = curLeft + swipeLength * positionOffset;\n        } else {\n            _.swipeLeft = curLeft + (swipeLength * (_.$list.height() / _.listWidth)) * positionOffset;\n        }\n        if (_.options.verticalSwiping === true) {\n            _.swipeLeft = curLeft + swipeLength * positionOffset;\n        }\n\n        if (_.options.fade === true || _.options.touchMove === false) {\n            return false;\n        }\n\n        if (_.animating === true) {\n            _.swipeLeft = null;\n            return false;\n        }\n\n        _.setCSS(_.swipeLeft);\n\n    };\n\n    Slick.prototype.swipeStart = function(event) {\n\n        var _ = this,\n            touches;\n\n        _.interrupted = true;\n\n        if (_.touchObject.fingerCount !== 1 || _.slideCount <= _.options.slidesToShow) {\n            _.touchObject = {};\n            return false;\n        }\n\n        if (event.originalEvent !== undefined && event.originalEvent.touches !== undefined) {\n            touches = event.originalEvent.touches[0];\n        }\n\n        _.touchObject.startX = _.touchObject.curX = touches !== undefined ? touches.pageX : event.clientX;\n        _.touchObject.startY = _.touchObject.curY = touches !== undefined ? touches.pageY : event.clientY;\n\n        _.dragging = true;\n\n    };\n\n    Slick.prototype.unfilterSlides = Slick.prototype.slickUnfilter = function() {\n\n        var _ = this;\n\n        if (_.$slidesCache !== null) {\n\n            _.unload();\n\n            _.$slideTrack.children(this.options.slide).detach();\n\n            _.$slidesCache.appendTo(_.$slideTrack);\n\n            _.reinit();\n\n        }\n\n    };\n\n    Slick.prototype.unload = function() {\n\n        var _ = this;\n\n        $('.slick-cloned', _.$slider).remove();\n\n        if (_.$dots) {\n            _.$dots.remove();\n        }\n\n        if (_.$prevArrow && _.htmlExpr.test(_.options.prevArrow)) {\n            _.$prevArrow.remove();\n        }\n\n        if (_.$nextArrow && _.htmlExpr.test(_.options.nextArrow)) {\n            _.$nextArrow.remove();\n        }\n\n        _.$slides\n            .removeClass('slick-slide slick-active slick-visible slick-current')\n            .attr('aria-hidden', 'true')\n            .css('width', '');\n\n    };\n\n    Slick.prototype.unslick = function(fromBreakpoint) {\n\n        var _ = this;\n        _.$slider.trigger('unslick', [_, fromBreakpoint]);\n        _.destroy();\n\n    };\n\n    Slick.prototype.updateArrows = function() {\n\n        var _ = this,\n            centerOffset;\n\n        centerOffset = Math.floor(_.options.slidesToShow / 2);\n\n        if ( _.options.arrows === true &&\n            _.slideCount > _.options.slidesToShow &&\n            !_.options.infinite ) {\n\n            _.$prevArrow.removeClass('slick-disabled').attr('aria-disabled', 'false');\n            _.$nextArrow.removeClass('slick-disabled').attr('aria-disabled', 'false');\n\n            if (_.currentSlide === 0) {\n\n                _.$prevArrow.addClass('slick-disabled').attr('aria-disabled', 'true');\n                _.$nextArrow.removeClass('slick-disabled').attr('aria-disabled', 'false');\n\n            } else if (_.currentSlide >= _.slideCount - _.options.slidesToShow && _.options.centerMode === false) {\n\n                _.$nextArrow.addClass('slick-disabled').attr('aria-disabled', 'true');\n                _.$prevArrow.removeClass('slick-disabled').attr('aria-disabled', 'false');\n\n            } else if (_.currentSlide >= _.slideCount - 1 && _.options.centerMode === true) {\n\n                _.$nextArrow.addClass('slick-disabled').attr('aria-disabled', 'true');\n                _.$prevArrow.removeClass('slick-disabled').attr('aria-disabled', 'false');\n\n            }\n\n        }\n\n    };\n\n    Slick.prototype.updateDots = function() {\n\n        var _ = this;\n\n        if (_.$dots !== null) {\n\n            _.$dots\n                .find('li')\n                .removeClass('slick-active')\n                .end();\n\n            _.$dots\n                .find('li')\n                .eq(Math.floor(_.currentSlide / _.options.slidesToScroll))\n                .addClass('slick-active');\n\n        }\n\n    };\n\n    Slick.prototype.visibility = function() {\n\n        var _ = this;\n\n        if ( _.options.autoplay ) {\n\n            if ( document[_.hidden] ) {\n\n                _.interrupted = true;\n\n            } else {\n\n                _.interrupted = false;\n\n            }\n\n        }\n\n    };\n\n    $.fn.slick = function() {\n        var _ = this,\n            opt = arguments[0],\n            args = Array.prototype.slice.call(arguments, 1),\n            l = _.length,\n            i,\n            ret;\n        for (i = 0; i < l; i++) {\n            if (typeof opt == 'object' || typeof opt == 'undefined')\n                _[i].slick = new Slick(_[i], opt);\n            else\n                ret = _[i].slick[opt].apply(_[i].slick, args);\n            if (typeof ret != 'undefined') return ret;\n        }\n        return _;\n    };\n\n}));\n","Magento_PageBuilder/js/resource/slick/slick.min.js":"/*\n     _ _      _       _\n ___| (_) ___| | __  (_)___\n/ __| | |/ __| |/ /  | / __|\n\\__ \\ | | (__|   < _ | \\__ \\\n|___/_|_|\\___|_|\\_(_)/ |___/\n                   |__/\n\n Version: 1.8.1\n  Author: Ken Wheeler\n Website: http://kenwheeler.github.io\n    Docs: http://kenwheeler.github.io/slick\n    Repo: http://github.com/kenwheeler/slick\n  Issues: http://github.com/kenwheeler/slick/issues\n\n */\n!function(i){\"use strict\";\"function\"==typeof define&&define.amd?define([\"jquery\"],i):\"undefined\"!=typeof exports?module.exports=i(require(\"jquery\")):i(jQuery)}(function(i){\"use strict\";var e=window.Slick||{};(e=function(){var e=0;return function(t,o){var s,n=this;n.defaults={accessibility:!0,adaptiveHeight:!1,appendArrows:i(t),appendDots:i(t),arrows:!0,asNavFor:null,prevArrow:'<button class=\"slick-prev\" aria-label=\"Previous\" type=\"button\">Previous</button>',nextArrow:'<button class=\"slick-next\" aria-label=\"Next\" type=\"button\">Next</button>',autoplay:!1,autoplaySpeed:3e3,centerMode:!1,centerPadding:\"50px\",cssEase:\"ease\",customPaging:function(e,t){return i('<button type=\"button\" />').text(t+1)},dots:!1,dotsClass:\"slick-dots\",draggable:!0,easing:\"linear\",edgeFriction:.35,fade:!1,focusOnSelect:!1,focusOnChange:!1,infinite:!0,initialSlide:0,lazyLoad:\"ondemand\",mobileFirst:!1,pauseOnHover:!0,pauseOnFocus:!0,pauseOnDotsHover:!1,respondTo:\"window\",responsive:null,rows:1,rtl:!1,slide:\"\",slidesPerRow:1,slidesToShow:1,slidesToScroll:1,speed:500,swipe:!0,swipeToSlide:!1,touchMove:!0,touchThreshold:5,useCSS:!0,useTransform:!0,variableWidth:!1,vertical:!1,verticalSwiping:!1,waitForAnimate:!0,zIndex:1e3},n.initials={animating:!1,dragging:!1,autoPlayTimer:null,currentDirection:0,currentLeft:null,currentSlide:0,direction:1,$dots:null,listWidth:null,listHeight:null,loadIndex:0,$nextArrow:null,$prevArrow:null,scrolling:!1,slideCount:null,slideWidth:null,$slideTrack:null,$slides:null,sliding:!1,slideOffset:0,swipeLeft:null,swiping:!1,$list:null,touchObject:{},transformsEnabled:!1,unslicked:!1},i.extend(n,n.initials),n.activeBreakpoint=null,n.animType=null,n.animProp=null,n.breakpoints=[],n.breakpointSettings=[],n.cssTransitions=!1,n.focussed=!1,n.interrupted=!1,n.hidden=\"hidden\",n.paused=!0,n.positionProp=null,n.respondTo=null,n.rowCount=1,n.shouldClick=!0,n.$slider=i(t),n.$slidesCache=null,n.transformType=null,n.transitionType=null,n.visibilityChange=\"visibilitychange\",n.windowWidth=0,n.windowTimer=null,s=i(t).data(\"slick\")||{},n.options=i.extend({},n.defaults,o,s),n.currentSlide=n.options.initialSlide,n.originalSettings=n.options,void 0!==document.mozHidden?(n.hidden=\"mozHidden\",n.visibilityChange=\"mozvisibilitychange\"):void 0!==document.webkitHidden&&(n.hidden=\"webkitHidden\",n.visibilityChange=\"webkitvisibilitychange\"),n.autoPlay=i.proxy(n.autoPlay,n),n.autoPlayClear=i.proxy(n.autoPlayClear,n),n.autoPlayIterator=i.proxy(n.autoPlayIterator,n),n.changeSlide=i.proxy(n.changeSlide,n),n.clickHandler=i.proxy(n.clickHandler,n),n.selectHandler=i.proxy(n.selectHandler,n),n.setPosition=i.proxy(n.setPosition,n),n.swipeHandler=i.proxy(n.swipeHandler,n),n.dragHandler=i.proxy(n.dragHandler,n),n.keyHandler=i.proxy(n.keyHandler,n),n.instanceUid=e++,n.htmlExpr=/^(?:\\s*(<[\\w\\W]+>)[^>]*)$/,n.registerBreakpoints(),n.init(!0)}}()).prototype.activateADA=function(){this.$slideTrack.find(\".slick-active\").attr({\"aria-hidden\":\"false\"}).find(\"a, input, button, select\").attr({tabindex:\"0\"})},e.prototype.addSlide=e.prototype.slickAdd=function(e,t,o){var s=this;if(\"boolean\"==typeof t)o=t,t=null;else if(t<0||t>=s.slideCount)return!1;s.unload(),\"number\"==typeof t?0===t&&0===s.$slides.length?i(e).appendTo(s.$slideTrack):o?i(e).insertBefore(s.$slides.eq(t)):i(e).insertAfter(s.$slides.eq(t)):!0===o?i(e).prependTo(s.$slideTrack):i(e).appendTo(s.$slideTrack),s.$slides=s.$slideTrack.children(this.options.slide),s.$slideTrack.children(this.options.slide).detach(),s.$slideTrack.append(s.$slides),s.$slides.each(function(e,t){i(t).attr(\"data-slick-index\",e)}),s.$slidesCache=s.$slides,s.reinit()},e.prototype.animateHeight=function(){var i=this;if(1===i.options.slidesToShow&&!0===i.options.adaptiveHeight&&!1===i.options.vertical){var e=i.$slides.eq(i.currentSlide).outerHeight(!0);i.$list.animate({height:e},i.options.speed)}},e.prototype.animateSlide=function(e,t){var o={},s=this;s.animateHeight(),!0===s.options.rtl&&!1===s.options.vertical&&(e=-e),!1===s.transformsEnabled?!1===s.options.vertical?s.$slideTrack.animate({left:e},s.options.speed,s.options.easing,t):s.$slideTrack.animate({top:e},s.options.speed,s.options.easing,t):!1===s.cssTransitions?(!0===s.options.rtl&&(s.currentLeft=-s.currentLeft),i({animStart:s.currentLeft}).animate({animStart:e},{duration:s.options.speed,easing:s.options.easing,step:function(i){i=Math.ceil(i),!1===s.options.vertical?(o[s.animType]=\"translate(\"+i+\"px, 0px)\",s.$slideTrack.css(o)):(o[s.animType]=\"translate(0px,\"+i+\"px)\",s.$slideTrack.css(o))},complete:function(){t&&t.call()}})):(s.applyTransition(),e=Math.ceil(e),!1===s.options.vertical?o[s.animType]=\"translate3d(\"+e+\"px, 0px, 0px)\":o[s.animType]=\"translate3d(0px,\"+e+\"px, 0px)\",s.$slideTrack.css(o),t&&setTimeout(function(){s.disableTransition(),t.call()},s.options.speed))},e.prototype.getNavTarget=function(){var e=this.options.asNavFor;return e&&null!==e&&(e=i(e).not(this.$slider)),e},e.prototype.asNavFor=function(e){var t=this.getNavTarget();null!==t&&\"object\"==typeof t&&t.each(function(){var t=i(this).slick(\"getSlick\");t.unslicked||t.slideHandler(e,!0)})},e.prototype.applyTransition=function(i){var e=this,t={};!1===e.options.fade?t[e.transitionType]=e.transformType+\" \"+e.options.speed+\"ms \"+e.options.cssEase:t[e.transitionType]=\"opacity \"+e.options.speed+\"ms \"+e.options.cssEase,!1===e.options.fade?e.$slideTrack.css(t):e.$slides.eq(i).css(t)},e.prototype.autoPlay=function(){var i=this;i.autoPlayClear(),i.slideCount>i.options.slidesToShow&&(i.autoPlayTimer=setInterval(i.autoPlayIterator,i.options.autoplaySpeed))},e.prototype.autoPlayClear=function(){this.autoPlayTimer&&clearInterval(this.autoPlayTimer)},e.prototype.autoPlayIterator=function(){var i=this,e=i.currentSlide+i.options.slidesToScroll;i.paused||i.interrupted||i.focussed||(!1===i.options.infinite&&(1===i.direction&&i.currentSlide+1===i.slideCount-1?i.direction=0:0===i.direction&&(e=i.currentSlide-i.options.slidesToScroll,i.currentSlide-1==0&&(i.direction=1))),i.slideHandler(e))},e.prototype.buildArrows=function(){var e=this;!0===e.options.arrows&&(e.$prevArrow=i(e.options.prevArrow).addClass(\"slick-arrow\"),e.$nextArrow=i(e.options.nextArrow).addClass(\"slick-arrow\"),e.slideCount>e.options.slidesToShow?(e.$prevArrow.removeClass(\"slick-hidden\").removeAttr(\"aria-hidden tabindex\"),e.$nextArrow.removeClass(\"slick-hidden\").removeAttr(\"aria-hidden tabindex\"),e.htmlExpr.test(e.options.prevArrow)&&e.$prevArrow.prependTo(e.options.appendArrows),e.htmlExpr.test(e.options.nextArrow)&&e.$nextArrow.appendTo(e.options.appendArrows),!0!==e.options.infinite&&e.$prevArrow.addClass(\"slick-disabled\").attr(\"aria-disabled\",\"true\")):e.$prevArrow.add(e.$nextArrow).addClass(\"slick-hidden\").attr({\"aria-disabled\":\"true\",tabindex:\"-1\"}))},e.prototype.buildDots=function(){var e,t,o=this;if(!0===o.options.dots&&o.slideCount>o.options.slidesToShow){for(o.$slider.addClass(\"slick-dotted\"),t=i(\"<ul />\").addClass(o.options.dotsClass),e=0;e<=o.getDotCount();e+=1)t.append(i(\"<li />\").append(o.options.customPaging.call(this,o,e)));o.$dots=t.appendTo(o.options.appendDots),o.$dots.find(\"li\").first().addClass(\"slick-active\")}},e.prototype.buildOut=function(){var e=this;e.$slides=e.$slider.children(e.options.slide+\":not(.slick-cloned)\").addClass(\"slick-slide\"),e.slideCount=e.$slides.length,e.$slides.each(function(e,t){i(t).attr(\"data-slick-index\",e).data(\"originalStyling\",i(t).attr(\"style\")||\"\")}),e.$slider.addClass(\"slick-slider\"),e.$slideTrack=0===e.slideCount?i('<div class=\"slick-track\"/>').appendTo(e.$slider):e.$slides.wrapAll('<div class=\"slick-track\"/>').parent(),e.$list=e.$slideTrack.wrap('<div class=\"slick-list\"/>').parent(),e.$slideTrack.css(\"opacity\",0),!0!==e.options.centerMode&&!0!==e.options.swipeToSlide||(e.options.slidesToScroll=1),i(\"img[data-lazy]\",e.$slider).not(\"[src]\").addClass(\"slick-loading\"),e.setupInfinite(),e.buildArrows(),e.buildDots(),e.updateDots(),e.setSlideClasses(\"number\"==typeof e.currentSlide?e.currentSlide:0),!0===e.options.draggable&&e.$list.addClass(\"draggable\")},e.prototype.buildRows=function(){var i,e,t,o,s,n,r,l=this;if(o=document.createDocumentFragment(),n=l.$slider.children(),l.options.rows>0){for(r=l.options.slidesPerRow*l.options.rows,s=Math.ceil(n.length/r),i=0;i<s;i++){var d=document.createElement(\"div\");for(e=0;e<l.options.rows;e++){var a=document.createElement(\"div\");for(t=0;t<l.options.slidesPerRow;t++){var c=i*r+(e*l.options.slidesPerRow+t);n.get(c)&&a.appendChild(n.get(c))}d.appendChild(a)}o.appendChild(d)}l.$slider.empty().append(o),l.$slider.children().children().children().css({width:100/l.options.slidesPerRow+\"%\",display:\"inline-block\"})}},e.prototype.checkResponsive=function(e,t){var o,s,n,r=this,l=!1,d=r.$slider.width(),a=window.innerWidth||i(window).width();if(\"window\"===r.respondTo?n=a:\"slider\"===r.respondTo?n=d:\"min\"===r.respondTo&&(n=Math.min(a,d)),r.options.responsive&&r.options.responsive.length&&null!==r.options.responsive){s=null;for(o in r.breakpoints)r.breakpoints.hasOwnProperty(o)&&(!1===r.originalSettings.mobileFirst?n<r.breakpoints[o]&&(s=r.breakpoints[o]):n>r.breakpoints[o]&&(s=r.breakpoints[o]));null!==s?null!==r.activeBreakpoint?(s!==r.activeBreakpoint||t)&&(r.activeBreakpoint=s,\"unslick\"===r.breakpointSettings[s]?r.unslick(s):(r.options=i.extend({},r.originalSettings,r.breakpointSettings[s]),!0===e&&(r.currentSlide=r.options.initialSlide),r.refresh(e)),l=s):(r.activeBreakpoint=s,\"unslick\"===r.breakpointSettings[s]?r.unslick(s):(r.options=i.extend({},r.originalSettings,r.breakpointSettings[s]),!0===e&&(r.currentSlide=r.options.initialSlide),r.refresh(e)),l=s):null!==r.activeBreakpoint&&(r.activeBreakpoint=null,r.options=r.originalSettings,!0===e&&(r.currentSlide=r.options.initialSlide),r.refresh(e),l=s),e||!1===l||r.$slider.trigger(\"breakpoint\",[r,l])}},e.prototype.changeSlide=function(e,t){var o,s,n=this,r=i(e.currentTarget);switch(r.is(\"a\")&&e.preventDefault(),r.is(\"li\")||(r=r.closest(\"li\")),o=n.slideCount%n.options.slidesToScroll!=0?0:(n.slideCount-n.currentSlide)%n.options.slidesToScroll,e.data.message){case\"previous\":s=0===o?n.options.slidesToScroll:n.options.slidesToShow-o,n.slideCount>n.options.slidesToShow&&n.slideHandler(n.currentSlide-s,!1,t);break;case\"next\":s=0===o?n.options.slidesToScroll:o,n.slideCount>n.options.slidesToShow&&n.slideHandler(n.currentSlide+s,!1,t);break;case\"index\":var l=0===e.data.index?0:e.data.index||r.index()*n.options.slidesToScroll;n.slideHandler(n.checkNavigable(l),!1,t),r.children().trigger(\"focus\");break;default:return}},e.prototype.checkNavigable=function(i){var e,t;if(t=0,i>(e=this.getNavigableIndexes())[e.length-1])i=e[e.length-1];else for(var o in e){if(i<e[o]){i=t;break}t=e[o]}return i},e.prototype.cleanUpEvents=function(){var e=this;e.options.dots&&null!==e.$dots&&(i(\"li\",e.$dots).off(\"click.slick\",e.changeSlide).off(\"mouseenter.slick\",i.proxy(e.interrupt,e,!0)).off(\"mouseleave.slick\",i.proxy(e.interrupt,e,!1)),!0===e.options.accessibility&&e.$dots.off(\"keydown.slick\",e.keyHandler)),e.$slider.off(\"focus.slick blur.slick\"),!0===e.options.arrows&&e.slideCount>e.options.slidesToShow&&(e.$prevArrow&&e.$prevArrow.off(\"click.slick\",e.changeSlide),e.$nextArrow&&e.$nextArrow.off(\"click.slick\",e.changeSlide),!0===e.options.accessibility&&(e.$prevArrow&&e.$prevArrow.off(\"keydown.slick\",e.keyHandler),e.$nextArrow&&e.$nextArrow.off(\"keydown.slick\",e.keyHandler))),e.$list.off(\"touchstart.slick mousedown.slick\",e.swipeHandler),e.$list.off(\"touchmove.slick mousemove.slick\",e.swipeHandler),e.$list.off(\"touchend.slick mouseup.slick\",e.swipeHandler),e.$list.off(\"touchcancel.slick mouseleave.slick\",e.swipeHandler),e.$list.off(\"click.slick\",e.clickHandler),i(document).off(e.visibilityChange,e.visibility),e.cleanUpSlideEvents(),!0===e.options.accessibility&&e.$list.off(\"keydown.slick\",e.keyHandler),!0===e.options.focusOnSelect&&i(e.$slideTrack).children().off(\"click.slick\",e.selectHandler),i(window).off(\"orientationchange.slick.slick-\"+e.instanceUid,e.orientationChange),i(window).off(\"resize.slick.slick-\"+e.instanceUid,e.resize),i(\"[draggable!=true]\",e.$slideTrack).off(\"dragstart\",e.preventDefault),i(window).off(\"load.slick.slick-\"+e.instanceUid,e.setPosition)},e.prototype.cleanUpSlideEvents=function(){var e=this;e.$list.off(\"mouseenter.slick\",i.proxy(e.interrupt,e,!0)),e.$list.off(\"mouseleave.slick\",i.proxy(e.interrupt,e,!1))},e.prototype.cleanUpRows=function(){var i;this.options.rows>0&&((i=this.$slides.children().children()).removeAttr(\"style\"),this.$slider.empty().append(i))},e.prototype.clickHandler=function(i){!1===this.shouldClick&&(i.stopImmediatePropagation(),i.stopPropagation(),i.preventDefault())},e.prototype.destroy=function(e){var t=this;t.autoPlayClear(),t.touchObject={},t.cleanUpEvents(),i(\".slick-cloned\",t.$slider).detach(),t.$dots&&t.$dots.remove(),t.$prevArrow&&t.$prevArrow.length&&(t.$prevArrow.removeClass(\"slick-disabled slick-arrow slick-hidden\").removeAttr(\"aria-hidden aria-disabled tabindex\").css(\"display\",\"\"),t.htmlExpr.test(t.options.prevArrow)&&t.$prevArrow.remove()),t.$nextArrow&&t.$nextArrow.length&&(t.$nextArrow.removeClass(\"slick-disabled slick-arrow slick-hidden\").removeAttr(\"aria-hidden aria-disabled tabindex\").css(\"display\",\"\"),t.htmlExpr.test(t.options.nextArrow)&&t.$nextArrow.remove()),t.$slides&&(t.$slides.removeClass(\"slick-slide slick-active slick-center slick-visible slick-current\").removeAttr(\"aria-hidden\").removeAttr(\"data-slick-index\").each(function(){i(this).attr(\"style\",i(this).data(\"originalStyling\"))}),t.$slideTrack.children(this.options.slide).detach(),t.$slideTrack.detach(),t.$list.detach(),t.$slider.append(t.$slides)),t.cleanUpRows(),t.$slider.removeClass(\"slick-slider\"),t.$slider.removeClass(\"slick-initialized\"),t.$slider.removeClass(\"slick-dotted\"),t.unslicked=!0,e||t.$slider.trigger(\"destroy\",[t])},e.prototype.disableTransition=function(i){var e={};e[this.transitionType]=\"\",!1===this.options.fade?this.$slideTrack.css(e):this.$slides.eq(i).css(e)},e.prototype.fadeSlide=function(i,e){var t=this;!1===t.cssTransitions?(t.$slides.eq(i).css({zIndex:t.options.zIndex}),t.$slides.eq(i).animate({opacity:1},t.options.speed,t.options.easing,e)):(t.applyTransition(i),t.$slides.eq(i).css({opacity:1,zIndex:t.options.zIndex}),e&&setTimeout(function(){t.disableTransition(i),e.call()},t.options.speed))},e.prototype.fadeSlideOut=function(i){var e=this;!1===e.cssTransitions?e.$slides.eq(i).animate({opacity:0,zIndex:e.options.zIndex-2},e.options.speed,e.options.easing):(e.applyTransition(i),e.$slides.eq(i).css({opacity:0,zIndex:e.options.zIndex-2}))},e.prototype.filterSlides=e.prototype.slickFilter=function(i){var e=this;null!==i&&(e.$slidesCache=e.$slides,e.unload(),e.$slideTrack.children(this.options.slide).detach(),e.$slidesCache.filter(i).appendTo(e.$slideTrack),e.reinit())},e.prototype.focusHandler=function(){var e=this;e.$slider.off(\"focus.slick blur.slick\").on(\"focus.slick\",\"*\",function(t){var o=i(this);setTimeout(function(){e.options.pauseOnFocus&&o.is(\":focus\")&&(e.focussed=!0,e.autoPlay())},0)}).on(\"blur.slick\",\"*\",function(t){i(this);e.options.pauseOnFocus&&(e.focussed=!1,e.autoPlay())})},e.prototype.getCurrent=e.prototype.slickCurrentSlide=function(){return this.currentSlide},e.prototype.getDotCount=function(){var i=this,e=0,t=0,o=0;if(!0===i.options.infinite)if(i.slideCount<=i.options.slidesToShow)++o;else for(;e<i.slideCount;)++o,e=t+i.options.slidesToScroll,t+=i.options.slidesToScroll<=i.options.slidesToShow?i.options.slidesToScroll:i.options.slidesToShow;else if(!0===i.options.centerMode)o=i.slideCount;else if(i.options.asNavFor)for(;e<i.slideCount;)++o,e=t+i.options.slidesToScroll,t+=i.options.slidesToScroll<=i.options.slidesToShow?i.options.slidesToScroll:i.options.slidesToShow;else o=1+Math.ceil((i.slideCount-i.options.slidesToShow)/i.options.slidesToScroll);return o-1},e.prototype.getLeft=function(i){var e,t,o,s,n=this,r=0;return n.slideOffset=0,t=n.$slides.first().outerHeight(!0),!0===n.options.infinite?(n.slideCount>n.options.slidesToShow&&(n.slideOffset=n.slideWidth*n.options.slidesToShow*-1,s=-1,!0===n.options.vertical&&!0===n.options.centerMode&&(2===n.options.slidesToShow?s=-1.5:1===n.options.slidesToShow&&(s=-2)),r=t*n.options.slidesToShow*s),n.slideCount%n.options.slidesToScroll!=0&&i+n.options.slidesToScroll>n.slideCount&&n.slideCount>n.options.slidesToShow&&(i>n.slideCount?(n.slideOffset=(n.options.slidesToShow-(i-n.slideCount))*n.slideWidth*-1,r=(n.options.slidesToShow-(i-n.slideCount))*t*-1):(n.slideOffset=n.slideCount%n.options.slidesToScroll*n.slideWidth*-1,r=n.slideCount%n.options.slidesToScroll*t*-1))):i+n.options.slidesToShow>n.slideCount&&(n.slideOffset=(i+n.options.slidesToShow-n.slideCount)*n.slideWidth,r=(i+n.options.slidesToShow-n.slideCount)*t),n.slideCount<=n.options.slidesToShow&&(n.slideOffset=0,r=0),!0===n.options.centerMode&&n.slideCount<=n.options.slidesToShow?n.slideOffset=n.slideWidth*Math.floor(n.options.slidesToShow)/2-n.slideWidth*n.slideCount/2:!0===n.options.centerMode&&!0===n.options.infinite?n.slideOffset+=n.slideWidth*Math.floor(n.options.slidesToShow/2)-n.slideWidth:!0===n.options.centerMode&&(n.slideOffset=0,n.slideOffset+=n.slideWidth*Math.floor(n.options.slidesToShow/2)),e=!1===n.options.vertical?i*n.slideWidth*-1+n.slideOffset:i*t*-1+r,!0===n.options.variableWidth&&(o=n.slideCount<=n.options.slidesToShow||!1===n.options.infinite?n.$slideTrack.children(\".slick-slide\").eq(i):n.$slideTrack.children(\".slick-slide\").eq(i+n.options.slidesToShow),e=!0===n.options.rtl?o[0]?-1*(n.$slideTrack.width()-o[0].offsetLeft-o.width()):0:o[0]?-1*o[0].offsetLeft:0,!0===n.options.centerMode&&(o=n.slideCount<=n.options.slidesToShow||!1===n.options.infinite?n.$slideTrack.children(\".slick-slide\").eq(i):n.$slideTrack.children(\".slick-slide\").eq(i+n.options.slidesToShow+1),e=!0===n.options.rtl?o[0]?-1*(n.$slideTrack.width()-o[0].offsetLeft-o.width()):0:o[0]?-1*o[0].offsetLeft:0,e+=(n.$list.width()-o.outerWidth())/2)),e},e.prototype.getOption=e.prototype.slickGetOption=function(i){return this.options[i]},e.prototype.getNavigableIndexes=function(){var i,e=this,t=0,o=0,s=[];for(!1===e.options.infinite?i=e.slideCount:(t=-1*e.options.slidesToScroll,o=-1*e.options.slidesToScroll,i=2*e.slideCount);t<i;)s.push(t),t=o+e.options.slidesToScroll,o+=e.options.slidesToScroll<=e.options.slidesToShow?e.options.slidesToScroll:e.options.slidesToShow;return s},e.prototype.getSlick=function(){return this},e.prototype.getSlideCount=function(){var e,t,o=this;return t=!0===o.options.centerMode?o.slideWidth*Math.floor(o.options.slidesToShow/2):0,!0===o.options.swipeToSlide?(o.$slideTrack.find(\".slick-slide\").each(function(s,n){if(n.offsetLeft-t+i(n).outerWidth()/2>-1*o.swipeLeft)return e=n,!1}),Math.abs(i(e).attr(\"data-slick-index\")-o.currentSlide)||1):o.options.slidesToScroll},e.prototype.goTo=e.prototype.slickGoTo=function(i,e){this.changeSlide({data:{message:\"index\",index:parseInt(i)}},e)},e.prototype.init=function(e){var t=this;i(t.$slider).hasClass(\"slick-initialized\")||(i(t.$slider).addClass(\"slick-initialized\"),t.buildRows(),t.buildOut(),t.setProps(),t.startLoad(),t.loadSlider(),t.initializeEvents(),t.updateArrows(),t.updateDots(),t.checkResponsive(!0),t.focusHandler()),e&&t.$slider.trigger(\"init\",[t]),!0===t.options.accessibility&&t.initADA(),t.options.autoplay&&(t.paused=!1,t.autoPlay())},e.prototype.initADA=function(){var e=this,t=Math.ceil(e.slideCount/e.options.slidesToShow),o=e.getNavigableIndexes().filter(function(i){return i>=0&&i<e.slideCount});e.$slides.add(e.$slideTrack.find(\".slick-cloned\")).attr({\"aria-hidden\":\"true\",tabindex:\"-1\"}).find(\"a, input, button, select\").attr({tabindex:\"-1\"}),null!==e.$dots&&(e.$slides.not(e.$slideTrack.find(\".slick-cloned\")).each(function(t){var s=o.indexOf(t);if(i(this).attr({role:\"tabpanel\",id:\"slick-slide\"+e.instanceUid+t,tabindex:-1}),-1!==s){var n=\"slick-slide-control\"+e.instanceUid+s;i(\"#\"+n).length&&i(this).attr({\"aria-describedby\":n})}}),e.$dots.attr(\"role\",\"tablist\").find(\"li\").each(function(s){var n=o[s];i(this).attr({role:\"presentation\"}),i(this).find(\"button\").first().attr({role:\"tab\",id:\"slick-slide-control\"+e.instanceUid+s,\"aria-controls\":\"slick-slide\"+e.instanceUid+n,\"aria-label\":s+1+\" of \"+t,\"aria-selected\":null,tabindex:\"-1\"})}).eq(e.currentSlide).find(\"button\").attr({\"aria-selected\":\"true\",tabindex:\"0\"}).end());for(var s=e.currentSlide,n=s+e.options.slidesToShow;s<n;s++)e.options.focusOnChange?e.$slides.eq(s).attr({tabindex:\"0\"}):e.$slides.eq(s).removeAttr(\"tabindex\");e.activateADA()},e.prototype.initArrowEvents=function(){var i=this;!0===i.options.arrows&&i.slideCount>i.options.slidesToShow&&(i.$prevArrow.off(\"click.slick\").on(\"click.slick\",{message:\"previous\"},i.changeSlide),i.$nextArrow.off(\"click.slick\").on(\"click.slick\",{message:\"next\"},i.changeSlide),!0===i.options.accessibility&&(i.$prevArrow.on(\"keydown.slick\",i.keyHandler),i.$nextArrow.on(\"keydown.slick\",i.keyHandler)))},e.prototype.initDotEvents=function(){var e=this;!0===e.options.dots&&e.slideCount>e.options.slidesToShow&&(i(\"li\",e.$dots).on(\"click.slick\",{message:\"index\"},e.changeSlide),!0===e.options.accessibility&&e.$dots.on(\"keydown.slick\",e.keyHandler)),!0===e.options.dots&&!0===e.options.pauseOnDotsHover&&e.slideCount>e.options.slidesToShow&&i(\"li\",e.$dots).on(\"mouseenter.slick\",i.proxy(e.interrupt,e,!0)).on(\"mouseleave.slick\",i.proxy(e.interrupt,e,!1))},e.prototype.initSlideEvents=function(){var e=this;e.options.pauseOnHover&&(e.$list.on(\"mouseenter.slick\",i.proxy(e.interrupt,e,!0)),e.$list.on(\"mouseleave.slick\",i.proxy(e.interrupt,e,!1)))},e.prototype.initializeEvents=function(){var e=this;e.initArrowEvents(),e.initDotEvents(),e.initSlideEvents(),e.$list.on(\"touchstart.slick mousedown.slick\",{action:\"start\"},e.swipeHandler),e.$list.on(\"touchmove.slick mousemove.slick\",{action:\"move\"},e.swipeHandler),e.$list.on(\"touchend.slick mouseup.slick\",{action:\"end\"},e.swipeHandler),e.$list.on(\"touchcancel.slick mouseleave.slick\",{action:\"end\"},e.swipeHandler),e.$list.on(\"click.slick\",e.clickHandler),i(document).on(e.visibilityChange,i.proxy(e.visibility,e)),!0===e.options.accessibility&&e.$list.on(\"keydown.slick\",e.keyHandler),!0===e.options.focusOnSelect&&i(e.$slideTrack).children().on(\"click.slick\",e.selectHandler),i(window).on(\"orientationchange.slick.slick-\"+e.instanceUid,i.proxy(e.orientationChange,e)),i(window).on(\"resize.slick.slick-\"+e.instanceUid,i.proxy(e.resize,e)),i(\"[draggable!=true]\",e.$slideTrack).on(\"dragstart\",e.preventDefault),i(window).on(\"load.slick.slick-\"+e.instanceUid,e.setPosition),i(e.setPosition)},e.prototype.initUI=function(){var i=this;!0===i.options.arrows&&i.slideCount>i.options.slidesToShow&&(i.$prevArrow.show(),i.$nextArrow.show()),!0===i.options.dots&&i.slideCount>i.options.slidesToShow&&i.$dots.show()},e.prototype.keyHandler=function(i){var e=this;i.target.tagName.match(\"TEXTAREA|INPUT|SELECT\")||(37===i.keyCode&&!0===e.options.accessibility?e.changeSlide({data:{message:!0===e.options.rtl?\"next\":\"previous\"}}):39===i.keyCode&&!0===e.options.accessibility&&e.changeSlide({data:{message:!0===e.options.rtl?\"previous\":\"next\"}}))},e.prototype.lazyLoad=function(){var e,t,o,s=this;function n(e){i(\"img[data-lazy]\",e).each(function(){var e=i(this),t=i(this).attr(\"data-lazy\"),o=i(this).attr(\"data-srcset\"),n=i(this).attr(\"data-sizes\")||s.$slider.attr(\"data-sizes\"),r=document.createElement(\"img\");r.onload=function(){e.animate({opacity:0},100,function(){o&&(e.attr(\"srcset\",o),n&&e.attr(\"sizes\",n)),e.attr(\"src\",t).animate({opacity:1},200,function(){e.removeAttr(\"data-lazy data-srcset data-sizes\").removeClass(\"slick-loading\")}),s.$slider.trigger(\"lazyLoaded\",[s,e,t])})},r.onerror=function(){e.removeAttr(\"data-lazy\").removeClass(\"slick-loading\").addClass(\"slick-lazyload-error\"),s.$slider.trigger(\"lazyLoadError\",[s,e,t])},r.src=t})}if(!0===s.options.centerMode?!0===s.options.infinite?o=(t=s.currentSlide+(s.options.slidesToShow/2+1))+s.options.slidesToShow+2:(t=Math.max(0,s.currentSlide-(s.options.slidesToShow/2+1)),o=s.options.slidesToShow/2+1+2+s.currentSlide):(t=s.options.infinite?s.options.slidesToShow+s.currentSlide:s.currentSlide,o=Math.ceil(t+s.options.slidesToShow),!0===s.options.fade&&(t>0&&t--,o<=s.slideCount&&o++)),e=s.$slider.find(\".slick-slide\").slice(t,o),\"anticipated\"===s.options.lazyLoad)for(var r=t-1,l=o,d=s.$slider.find(\".slick-slide\"),a=0;a<s.options.slidesToScroll;a++)r<0&&(r=s.slideCount-1),e=(e=e.add(d.eq(r))).add(d.eq(l)),r--,l++;n(e),s.slideCount<=s.options.slidesToShow?n(s.$slider.find(\".slick-slide\")):s.currentSlide>=s.slideCount-s.options.slidesToShow?n(s.$slider.find(\".slick-cloned\").slice(0,s.options.slidesToShow)):0===s.currentSlide&&n(s.$slider.find(\".slick-cloned\").slice(-1*s.options.slidesToShow))},e.prototype.loadSlider=function(){var i=this;i.setPosition(),i.$slideTrack.css({opacity:1}),i.$slider.removeClass(\"slick-loading\"),i.initUI(),\"progressive\"===i.options.lazyLoad&&i.progressiveLazyLoad()},e.prototype.next=e.prototype.slickNext=function(){this.changeSlide({data:{message:\"next\"}})},e.prototype.orientationChange=function(){this.checkResponsive(),this.setPosition()},e.prototype.pause=e.prototype.slickPause=function(){this.autoPlayClear(),this.paused=!0},e.prototype.play=e.prototype.slickPlay=function(){var i=this;i.autoPlay(),i.options.autoplay=!0,i.paused=!1,i.focussed=!1,i.interrupted=!1},e.prototype.postSlide=function(e){var t=this;t.unslicked||(t.$slider.trigger(\"afterChange\",[t,e]),t.animating=!1,t.slideCount>t.options.slidesToShow&&t.setPosition(),t.swipeLeft=null,t.options.autoplay&&t.autoPlay(),!0===t.options.accessibility&&(t.initADA(),t.options.focusOnChange&&i(t.$slides.get(t.currentSlide)).attr(\"tabindex\",0).focus()))},e.prototype.prev=e.prototype.slickPrev=function(){this.changeSlide({data:{message:\"previous\"}})},e.prototype.preventDefault=function(i){i.preventDefault()},e.prototype.progressiveLazyLoad=function(e){e=e||1;var t,o,s,n,r,l=this,d=i(\"img[data-lazy]\",l.$slider);d.length?(t=d.first(),o=t.attr(\"data-lazy\"),s=t.attr(\"data-srcset\"),n=t.attr(\"data-sizes\")||l.$slider.attr(\"data-sizes\"),(r=document.createElement(\"img\")).onload=function(){s&&(t.attr(\"srcset\",s),n&&t.attr(\"sizes\",n)),t.attr(\"src\",o).removeAttr(\"data-lazy data-srcset data-sizes\").removeClass(\"slick-loading\"),!0===l.options.adaptiveHeight&&l.setPosition(),l.$slider.trigger(\"lazyLoaded\",[l,t,o]),l.progressiveLazyLoad()},r.onerror=function(){e<3?setTimeout(function(){l.progressiveLazyLoad(e+1)},500):(t.removeAttr(\"data-lazy\").removeClass(\"slick-loading\").addClass(\"slick-lazyload-error\"),l.$slider.trigger(\"lazyLoadError\",[l,t,o]),l.progressiveLazyLoad())},r.src=o):l.$slider.trigger(\"allImagesLoaded\",[l])},e.prototype.refresh=function(e){var t,o,s=this;o=s.slideCount-s.options.slidesToShow,!s.options.infinite&&s.currentSlide>o&&(s.currentSlide=o),s.slideCount<=s.options.slidesToShow&&(s.currentSlide=0),t=s.currentSlide,s.destroy(!0),i.extend(s,s.initials,{currentSlide:t}),s.init(),e||s.changeSlide({data:{message:\"index\",index:t}},!1)},e.prototype.registerBreakpoints=function(){var e,t,o,s=this,n=s.options.responsive||null;if(\"array\"===i.type(n)&&n.length){s.respondTo=s.options.respondTo||\"window\";for(e in n)if(o=s.breakpoints.length-1,n.hasOwnProperty(e)){for(t=n[e].breakpoint;o>=0;)s.breakpoints[o]&&s.breakpoints[o]===t&&s.breakpoints.splice(o,1),o--;s.breakpoints.push(t),s.breakpointSettings[t]=n[e].settings}s.breakpoints.sort(function(i,e){return s.options.mobileFirst?i-e:e-i})}},e.prototype.reinit=function(){var e=this;e.$slides=e.$slideTrack.children(e.options.slide).addClass(\"slick-slide\"),e.slideCount=e.$slides.length,e.currentSlide>=e.slideCount&&0!==e.currentSlide&&(e.currentSlide=e.currentSlide-e.options.slidesToScroll),e.slideCount<=e.options.slidesToShow&&(e.currentSlide=0),e.registerBreakpoints(),e.setProps(),e.setupInfinite(),e.buildArrows(),e.updateArrows(),e.initArrowEvents(),e.buildDots(),e.updateDots(),e.initDotEvents(),e.cleanUpSlideEvents(),e.initSlideEvents(),e.checkResponsive(!1,!0),!0===e.options.focusOnSelect&&i(e.$slideTrack).children().on(\"click.slick\",e.selectHandler),e.setSlideClasses(\"number\"==typeof e.currentSlide?e.currentSlide:0),e.setPosition(),e.focusHandler(),e.paused=!e.options.autoplay,e.autoPlay(),e.$slider.trigger(\"reInit\",[e])},e.prototype.resize=function(){var e=this;i(window).width()!==e.windowWidth&&(clearTimeout(e.windowDelay),e.windowDelay=window.setTimeout(function(){e.windowWidth=i(window).width(),e.checkResponsive(),e.unslicked||e.setPosition()},50))},e.prototype.removeSlide=e.prototype.slickRemove=function(i,e,t){var o=this;if(i=\"boolean\"==typeof i?!0===(e=i)?0:o.slideCount-1:!0===e?--i:i,o.slideCount<1||i<0||i>o.slideCount-1)return!1;o.unload(),!0===t?o.$slideTrack.children().remove():o.$slideTrack.children(this.options.slide).eq(i).remove(),o.$slides=o.$slideTrack.children(this.options.slide),o.$slideTrack.children(this.options.slide).detach(),o.$slideTrack.append(o.$slides),o.$slidesCache=o.$slides,o.reinit()},e.prototype.setCSS=function(i){var e,t,o=this,s={};!0===o.options.rtl&&(i=-i),e=\"left\"==o.positionProp?Math.ceil(i)+\"px\":\"0px\",t=\"top\"==o.positionProp?Math.ceil(i)+\"px\":\"0px\",s[o.positionProp]=i,!1===o.transformsEnabled?o.$slideTrack.css(s):(s={},!1===o.cssTransitions?(s[o.animType]=\"translate(\"+e+\", \"+t+\")\",o.$slideTrack.css(s)):(s[o.animType]=\"translate3d(\"+e+\", \"+t+\", 0px)\",o.$slideTrack.css(s)))},e.prototype.setDimensions=function(){var i=this;!1===i.options.vertical?!0===i.options.centerMode&&i.$list.css({padding:\"0px \"+i.options.centerPadding}):(i.$list.height(i.$slides.first().outerHeight(!0)*i.options.slidesToShow),!0===i.options.centerMode&&i.$list.css({padding:i.options.centerPadding+\" 0px\"})),i.listWidth=i.$list.width(),i.listHeight=i.$list.height(),!1===i.options.vertical&&!1===i.options.variableWidth?(i.slideWidth=Math.ceil(i.listWidth/i.options.slidesToShow),i.$slideTrack.width(Math.ceil(i.slideWidth*i.$slideTrack.children(\".slick-slide\").length))):!0===i.options.variableWidth?i.$slideTrack.width(5e3*i.slideCount):(i.slideWidth=Math.ceil(i.listWidth),i.$slideTrack.height(Math.ceil(i.$slides.first().outerHeight(!0)*i.$slideTrack.children(\".slick-slide\").length)));var e=i.$slides.first().outerWidth(!0)-i.$slides.first().width();!1===i.options.variableWidth&&i.$slideTrack.children(\".slick-slide\").width(i.slideWidth-e)},e.prototype.setFade=function(){var e,t=this;t.$slides.each(function(o,s){e=t.slideWidth*o*-1,!0===t.options.rtl?i(s).css({position:\"relative\",right:e,top:0,zIndex:t.options.zIndex-2,opacity:0}):i(s).css({position:\"relative\",left:e,top:0,zIndex:t.options.zIndex-2,opacity:0})}),t.$slides.eq(t.currentSlide).css({zIndex:t.options.zIndex-1,opacity:1})},e.prototype.setHeight=function(){var i=this;if(1===i.options.slidesToShow&&!0===i.options.adaptiveHeight&&!1===i.options.vertical){var e=i.$slides.eq(i.currentSlide).outerHeight(!0);i.$list.css(\"height\",e)}},e.prototype.setOption=e.prototype.slickSetOption=function(){var e,t,o,s,n,r=this,l=!1;if(\"object\"===i.type(arguments[0])?(o=arguments[0],l=arguments[1],n=\"multiple\"):\"string\"===i.type(arguments[0])&&(o=arguments[0],s=arguments[1],l=arguments[2],\"responsive\"===arguments[0]&&\"array\"===i.type(arguments[1])?n=\"responsive\":void 0!==arguments[1]&&(n=\"single\")),\"single\"===n)r.options[o]=s;else if(\"multiple\"===n)i.each(o,function(i,e){r.options[i]=e});else if(\"responsive\"===n)for(t in s)if(\"array\"!==i.type(r.options.responsive))r.options.responsive=[s[t]];else{for(e=r.options.responsive.length-1;e>=0;)r.options.responsive[e].breakpoint===s[t].breakpoint&&r.options.responsive.splice(e,1),e--;r.options.responsive.push(s[t])}l&&(r.unload(),r.reinit())},e.prototype.setPosition=function(){var i=this;i.setDimensions(),i.setHeight(),!1===i.options.fade?i.setCSS(i.getLeft(i.currentSlide)):i.setFade(),i.$slider.trigger(\"setPosition\",[i])},e.prototype.setProps=function(){var i=this,e=document.body.style;i.positionProp=!0===i.options.vertical?\"top\":\"left\",\"top\"===i.positionProp?i.$slider.addClass(\"slick-vertical\"):i.$slider.removeClass(\"slick-vertical\"),void 0===e.WebkitTransition&&void 0===e.MozTransition&&void 0===e.msTransition||!0===i.options.useCSS&&(i.cssTransitions=!0),i.options.fade&&(\"number\"==typeof i.options.zIndex?i.options.zIndex<3&&(i.options.zIndex=3):i.options.zIndex=i.defaults.zIndex),void 0!==e.OTransform&&(i.animType=\"OTransform\",i.transformType=\"-o-transform\",i.transitionType=\"OTransition\",void 0===e.perspectiveProperty&&void 0===e.webkitPerspective&&(i.animType=!1)),void 0!==e.MozTransform&&(i.animType=\"MozTransform\",i.transformType=\"-moz-transform\",i.transitionType=\"MozTransition\",void 0===e.perspectiveProperty&&void 0===e.MozPerspective&&(i.animType=!1)),void 0!==e.webkitTransform&&(i.animType=\"webkitTransform\",i.transformType=\"-webkit-transform\",i.transitionType=\"webkitTransition\",void 0===e.perspectiveProperty&&void 0===e.webkitPerspective&&(i.animType=!1)),void 0!==e.msTransform&&(i.animType=\"msTransform\",i.transformType=\"-ms-transform\",i.transitionType=\"msTransition\",void 0===e.msTransform&&(i.animType=!1)),void 0!==e.transform&&!1!==i.animType&&(i.animType=\"transform\",i.transformType=\"transform\",i.transitionType=\"transition\"),i.transformsEnabled=i.options.useTransform&&null!==i.animType&&!1!==i.animType},e.prototype.setSlideClasses=function(i){var e,t,o,s,n=this;if(t=n.$slider.find(\".slick-slide\").removeClass(\"slick-active slick-center slick-current\").attr(\"aria-hidden\",\"true\"),n.$slides.eq(i).addClass(\"slick-current\"),!0===n.options.centerMode){var r=n.options.slidesToShow%2==0?1:0;e=Math.floor(n.options.slidesToShow/2),!0===n.options.infinite&&(i>=e&&i<=n.slideCount-1-e?n.$slides.slice(i-e+r,i+e+1).addClass(\"slick-active\").attr(\"aria-hidden\",\"false\"):(o=n.options.slidesToShow+i,t.slice(o-e+1+r,o+e+2).addClass(\"slick-active\").attr(\"aria-hidden\",\"false\")),0===i?t.eq(t.length-1-n.options.slidesToShow).addClass(\"slick-center\"):i===n.slideCount-1&&t.eq(n.options.slidesToShow).addClass(\"slick-center\")),n.$slides.eq(i).addClass(\"slick-center\")}else i>=0&&i<=n.slideCount-n.options.slidesToShow?n.$slides.slice(i,i+n.options.slidesToShow).addClass(\"slick-active\").attr(\"aria-hidden\",\"false\"):t.length<=n.options.slidesToShow?t.addClass(\"slick-active\").attr(\"aria-hidden\",\"false\"):(s=n.slideCount%n.options.slidesToShow,o=!0===n.options.infinite?n.options.slidesToShow+i:i,n.options.slidesToShow==n.options.slidesToScroll&&n.slideCount-i<n.options.slidesToShow?t.slice(o-(n.options.slidesToShow-s),o+s).addClass(\"slick-active\").attr(\"aria-hidden\",\"false\"):t.slice(o,o+n.options.slidesToShow).addClass(\"slick-active\").attr(\"aria-hidden\",\"false\"));\"ondemand\"!==n.options.lazyLoad&&\"anticipated\"!==n.options.lazyLoad||n.lazyLoad()},e.prototype.setupInfinite=function(){var e,t,o,s=this;if(!0===s.options.fade&&(s.options.centerMode=!1),!0===s.options.infinite&&!1===s.options.fade&&(t=null,s.slideCount>s.options.slidesToShow)){for(o=!0===s.options.centerMode?s.options.slidesToShow+1:s.options.slidesToShow,e=s.slideCount;e>s.slideCount-o;e-=1)t=e-1,i(s.$slides[t]).clone(!0).attr(\"id\",\"\").attr(\"data-slick-index\",t-s.slideCount).prependTo(s.$slideTrack).addClass(\"slick-cloned\");for(e=0;e<o+s.slideCount;e+=1)t=e,i(s.$slides[t]).clone(!0).attr(\"id\",\"\").attr(\"data-slick-index\",t+s.slideCount).appendTo(s.$slideTrack).addClass(\"slick-cloned\");s.$slideTrack.find(\".slick-cloned\").find(\"[id]\").each(function(){i(this).attr(\"id\",\"\")})}},e.prototype.interrupt=function(i){i||this.autoPlay(),this.interrupted=i},e.prototype.selectHandler=function(e){var t=i(e.target).is(\".slick-slide\")?i(e.target):i(e.target).parents(\".slick-slide\"),o=parseInt(t.attr(\"data-slick-index\"));o||(o=0),this.slideCount<=this.options.slidesToShow?this.slideHandler(o,!1,!0):this.slideHandler(o)},e.prototype.slideHandler=function(i,e,t){var o,s,n,r,l,d,a=this;if(e=e||!1,!(!0===a.animating&&!0===a.options.waitForAnimate||!0===a.options.fade&&a.currentSlide===i))if(!1===e&&a.asNavFor(i),o=i,l=a.getLeft(o),r=a.getLeft(a.currentSlide),a.currentLeft=null===a.swipeLeft?r:a.swipeLeft,!1===a.options.infinite&&!1===a.options.centerMode&&(i<0||i>a.getDotCount()*a.options.slidesToScroll))!1===a.options.fade&&(o=a.currentSlide,!0!==t&&a.slideCount>a.options.slidesToShow?a.animateSlide(r,function(){a.postSlide(o)}):a.postSlide(o));else if(!1===a.options.infinite&&!0===a.options.centerMode&&(i<0||i>a.slideCount-a.options.slidesToScroll))!1===a.options.fade&&(o=a.currentSlide,!0!==t&&a.slideCount>a.options.slidesToShow?a.animateSlide(r,function(){a.postSlide(o)}):a.postSlide(o));else{if(a.options.autoplay&&clearInterval(a.autoPlayTimer),s=o<0?a.slideCount%a.options.slidesToScroll!=0?a.slideCount-a.slideCount%a.options.slidesToScroll:a.slideCount+o:o>=a.slideCount?a.slideCount%a.options.slidesToScroll!=0?0:o-a.slideCount:o,a.animating=!0,a.$slider.trigger(\"beforeChange\",[a,a.currentSlide,s]),n=a.currentSlide,a.currentSlide=s,a.setSlideClasses(a.currentSlide),a.options.asNavFor&&(d=(d=a.getNavTarget()).slick(\"getSlick\")).slideCount<=d.options.slidesToShow&&d.setSlideClasses(a.currentSlide),a.updateDots(),a.updateArrows(),!0===a.options.fade)return!0!==t?(a.fadeSlideOut(n),a.fadeSlide(s,function(){a.postSlide(s)})):a.postSlide(s),void a.animateHeight();!0!==t&&a.slideCount>a.options.slidesToShow?a.animateSlide(l,function(){a.postSlide(s)}):a.postSlide(s)}},e.prototype.startLoad=function(){var i=this;!0===i.options.arrows&&i.slideCount>i.options.slidesToShow&&(i.$prevArrow.hide(),i.$nextArrow.hide()),!0===i.options.dots&&i.slideCount>i.options.slidesToShow&&i.$dots.hide(),i.$slider.addClass(\"slick-loading\")},e.prototype.swipeDirection=function(){var i,e,t,o,s=this;return i=s.touchObject.startX-s.touchObject.curX,e=s.touchObject.startY-s.touchObject.curY,t=Math.atan2(e,i),(o=Math.round(180*t/Math.PI))<0&&(o=360-Math.abs(o)),o<=45&&o>=0?!1===s.options.rtl?\"left\":\"right\":o<=360&&o>=315?!1===s.options.rtl?\"left\":\"right\":o>=135&&o<=225?!1===s.options.rtl?\"right\":\"left\":!0===s.options.verticalSwiping?o>=35&&o<=135?\"down\":\"up\":\"vertical\"},e.prototype.swipeEnd=function(i){var e,t,o=this;if(o.dragging=!1,o.swiping=!1,o.scrolling)return o.scrolling=!1,!1;if(o.interrupted=!1,o.shouldClick=!(o.touchObject.swipeLength>10),void 0===o.touchObject.curX)return!1;if(!0===o.touchObject.edgeHit&&o.$slider.trigger(\"edge\",[o,o.swipeDirection()]),o.touchObject.swipeLength>=o.touchObject.minSwipe){switch(t=o.swipeDirection()){case\"left\":case\"down\":e=o.options.swipeToSlide?o.checkNavigable(o.currentSlide+o.getSlideCount()):o.currentSlide+o.getSlideCount(),o.currentDirection=0;break;case\"right\":case\"up\":e=o.options.swipeToSlide?o.checkNavigable(o.currentSlide-o.getSlideCount()):o.currentSlide-o.getSlideCount(),o.currentDirection=1}\"vertical\"!=t&&(o.slideHandler(e),o.touchObject={},o.$slider.trigger(\"swipe\",[o,t]))}else o.touchObject.startX!==o.touchObject.curX&&(o.slideHandler(o.currentSlide),o.touchObject={})},e.prototype.swipeHandler=function(i){var e=this;if(!(!1===e.options.swipe||\"ontouchend\"in document&&!1===e.options.swipe||!1===e.options.draggable&&-1!==i.type.indexOf(\"mouse\")))switch(e.touchObject.fingerCount=i.originalEvent&&void 0!==i.originalEvent.touches?i.originalEvent.touches.length:1,e.touchObject.minSwipe=e.listWidth/e.options.touchThreshold,!0===e.options.verticalSwiping&&(e.touchObject.minSwipe=e.listHeight/e.options.touchThreshold),i.data.action){case\"start\":e.swipeStart(i);break;case\"move\":e.swipeMove(i);break;case\"end\":e.swipeEnd(i)}},e.prototype.swipeMove=function(i){var e,t,o,s,n,r,l=this;return n=void 0!==i.originalEvent?i.originalEvent.touches:null,!(!l.dragging||l.scrolling||n&&1!==n.length)&&(e=l.getLeft(l.currentSlide),l.touchObject.curX=void 0!==n?n[0].pageX:i.clientX,l.touchObject.curY=void 0!==n?n[0].pageY:i.clientY,l.touchObject.swipeLength=Math.round(Math.sqrt(Math.pow(l.touchObject.curX-l.touchObject.startX,2))),r=Math.round(Math.sqrt(Math.pow(l.touchObject.curY-l.touchObject.startY,2))),!l.options.verticalSwiping&&!l.swiping&&r>4?(l.scrolling=!0,!1):(!0===l.options.verticalSwiping&&(l.touchObject.swipeLength=r),t=l.swipeDirection(),void 0!==i.originalEvent&&l.touchObject.swipeLength>4&&(l.swiping=!0,i.preventDefault()),s=(!1===l.options.rtl?1:-1)*(l.touchObject.curX>l.touchObject.startX?1:-1),!0===l.options.verticalSwiping&&(s=l.touchObject.curY>l.touchObject.startY?1:-1),o=l.touchObject.swipeLength,l.touchObject.edgeHit=!1,!1===l.options.infinite&&(0===l.currentSlide&&\"right\"===t||l.currentSlide>=l.getDotCount()&&\"left\"===t)&&(o=l.touchObject.swipeLength*l.options.edgeFriction,l.touchObject.edgeHit=!0),!1===l.options.vertical?l.swipeLeft=e+o*s:l.swipeLeft=e+o*(l.$list.height()/l.listWidth)*s,!0===l.options.verticalSwiping&&(l.swipeLeft=e+o*s),!0!==l.options.fade&&!1!==l.options.touchMove&&(!0===l.animating?(l.swipeLeft=null,!1):void l.setCSS(l.swipeLeft))))},e.prototype.swipeStart=function(i){var e,t=this;if(t.interrupted=!0,1!==t.touchObject.fingerCount||t.slideCount<=t.options.slidesToShow)return t.touchObject={},!1;void 0!==i.originalEvent&&void 0!==i.originalEvent.touches&&(e=i.originalEvent.touches[0]),t.touchObject.startX=t.touchObject.curX=void 0!==e?e.pageX:i.clientX,t.touchObject.startY=t.touchObject.curY=void 0!==e?e.pageY:i.clientY,t.dragging=!0},e.prototype.unfilterSlides=e.prototype.slickUnfilter=function(){var i=this;null!==i.$slidesCache&&(i.unload(),i.$slideTrack.children(this.options.slide).detach(),i.$slidesCache.appendTo(i.$slideTrack),i.reinit())},e.prototype.unload=function(){var e=this;i(\".slick-cloned\",e.$slider).remove(),e.$dots&&e.$dots.remove(),e.$prevArrow&&e.htmlExpr.test(e.options.prevArrow)&&e.$prevArrow.remove(),e.$nextArrow&&e.htmlExpr.test(e.options.nextArrow)&&e.$nextArrow.remove(),e.$slides.removeClass(\"slick-slide slick-active slick-visible slick-current\").attr(\"aria-hidden\",\"true\").css(\"width\",\"\")},e.prototype.unslick=function(i){this.$slider.trigger(\"unslick\",[this,i]),this.destroy()},e.prototype.updateArrows=function(){var i=this;Math.floor(i.options.slidesToShow/2),!0===i.options.arrows&&i.slideCount>i.options.slidesToShow&&!i.options.infinite&&(i.$prevArrow.removeClass(\"slick-disabled\").attr(\"aria-disabled\",\"false\"),i.$nextArrow.removeClass(\"slick-disabled\").attr(\"aria-disabled\",\"false\"),0===i.currentSlide?(i.$prevArrow.addClass(\"slick-disabled\").attr(\"aria-disabled\",\"true\"),i.$nextArrow.removeClass(\"slick-disabled\").attr(\"aria-disabled\",\"false\")):i.currentSlide>=i.slideCount-i.options.slidesToShow&&!1===i.options.centerMode?(i.$nextArrow.addClass(\"slick-disabled\").attr(\"aria-disabled\",\"true\"),i.$prevArrow.removeClass(\"slick-disabled\").attr(\"aria-disabled\",\"false\")):i.currentSlide>=i.slideCount-1&&!0===i.options.centerMode&&(i.$nextArrow.addClass(\"slick-disabled\").attr(\"aria-disabled\",\"true\"),i.$prevArrow.removeClass(\"slick-disabled\").attr(\"aria-disabled\",\"false\")))},e.prototype.updateDots=function(){var i=this;null!==i.$dots&&(i.$dots.find(\"li\").removeClass(\"slick-active\").end(),i.$dots.find(\"li\").eq(Math.floor(i.currentSlide/i.options.slidesToScroll)).addClass(\"slick-active\"))},e.prototype.visibility=function(){this.options.autoplay&&(document[this.hidden]?this.interrupted=!0:this.interrupted=!1)},i.fn.slick=function(){var i,t,o=this,s=arguments[0],n=Array.prototype.slice.call(arguments,1),r=o.length;for(i=0;i<r;i++)if(\"object\"==typeof s||void 0===s?o[i].slick=new e(o[i],s):t=o[i].slick[s].apply(o[i].slick,n),void 0!==t)return t;return o}});\n","Magento_PageBuilder/js/resource/jarallax/jarallax-video.min.js":"/*!\n * Name    : Video Background Extension for Jarallax\n * Version : 1.0.1\n * Author  : nK <https://nkdev.info>\n * GitHub  : https://github.com/nk-o/jarallax\n */!function(o){var i={};function n(e){if(i[e])return i[e].exports;var t=i[e]={i:e,l:!1,exports:{}};return o[e].call(t.exports,t,t.exports,n),t.l=!0,t.exports}n.m=o,n.c=i,n.d=function(e,t,o){n.o(e,t)||Object.defineProperty(e,t,{enumerable:!0,get:o})},n.r=function(e){\"undefined\"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:\"Module\"}),Object.defineProperty(e,\"__esModule\",{value:!0})},n.t=function(t,e){if(1&e&&(t=n(t)),8&e)return t;if(4&e&&\"object\"==typeof t&&t&&t.__esModule)return t;var o=Object.create(null);if(n.r(o),Object.defineProperty(o,\"default\",{enumerable:!0,value:t}),2&e&&\"string\"!=typeof t)for(var i in t)n.d(o,i,function(e){return t[e]}.bind(null,i));return o},n.n=function(e){var t=e&&e.__esModule?function(){return e.default}:function(){return e};return n.d(t,\"a\",t),t},n.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},n.p=\"\",n(n.s=6)}([,,function(e,t){e.exports=function(e){\"complete\"===document.readyState||\"interactive\"===document.readyState?e.call():document.attachEvent?document.attachEvent(\"onreadystatechange\",function(){\"interactive\"===document.readyState&&e.call()}):document.addEventListener&&document.addEventListener(\"DOMContentLoaded\",e)}},,function(o,e,t){(function(e){var t;t=\"undefined\"!=typeof window?window:void 0!==e?e:\"undefined\"!=typeof self?self:{},o.exports=t}).call(this,t(5))},function(e,t){function o(e){return(o=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&\"function\"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?\"symbol\":typeof e})(e)}var i;i=function(){return this}();try{i=i||new Function(\"return this\")()}catch(e){\"object\"===(\"undefined\"==typeof window?\"undefined\":o(window))&&(i=window)}e.exports=i},function(e,t,o){e.exports=o(7)},function(e,t,o){\"use strict\";o.r(t);var i=o(8),n=o.n(i),a=o(4),r=o.n(a),l=o(2),p=o.n(l),u=o(10);r.a.VideoWorker=r.a.VideoWorker||n.a,Object(u.default)(),p()(function(){\"undefined\"!=typeof jarallax&&jarallax(document.querySelectorAll(\"[data-jarallax-video]\"))})},function(e,t,o){e.exports=o(9)},function(e,t,o){\"use strict\";function n(e){return(n=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&\"function\"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?\"symbol\":typeof e})(e)}function a(e,t){for(var o=0;o<t.length;o++){var i=t[o];i.enumerable=i.enumerable||!1,i.configurable=!0,\"value\"in i&&(i.writable=!0),Object.defineProperty(e,i.key,i)}}function i(){this._done=[],this._fail=[]}o.r(t),o.d(t,\"default\",function(){return c}),i.prototype={execute:function(e,t){var o=e.length;for(t=Array.prototype.slice.call(t);o--;)e[o].apply(null,t)},resolve:function(){this.execute(this._done,arguments)},reject:function(){this.execute(this._fail,arguments)},done:function(e){this._done.push(e)},fail:function(e){this._fail.push(e)}};var r=0,l=0,p=0,u=0,s=0,d=new i,y=new i,c=function(){function i(e,t){!function(e,t){if(!(e instanceof t))throw new TypeError(\"Cannot call a class as a function\")}(this,i);var o=this;o.url=e,o.options_default={autoplay:!1,loop:!1,mute:!1,volume:100,showContols:!0,startTime:0,endTime:0},o.options=o.extend({},o.options_default,t),o.videoID=o.parseURL(e),o.videoID&&(o.ID=r++,o.loadAPI(),o.init())}return function(e,t,o){t&&a(e.prototype,t),o&&a(e,o)}(i,[{key:\"extend\",value:function(o){var i=arguments;return o=o||{},Object.keys(arguments).forEach(function(t){i[t]&&Object.keys(i[t]).forEach(function(e){o[e]=i[t][e]})}),o}},{key:\"parseURL\",value:function(e){var t,o,i,n,a,r=!(!(t=e.match(/.*(?:youtu.be\\/|v\\/|u\\/\\w\\/|embed\\/|watch\\?v=)([^#\\&\\?]*).*/))||11!==t[1].length)&&t[1],l=!(!(o=e.match(/https?:\\/\\/(?:www\\.|player\\.)?vimeo.com\\/(?:channels\\/(?:\\w+\\/)?|groups\\/([^\\/]*)\\/videos\\/|album\\/(\\d+)\\/video\\/|video\\/|)(\\d+)(?:$|\\/|\\?)/))||!o[3])&&o[3],p=(i=e.split(/,(?=mp4\\:|webm\\:|ogv\\:|ogg\\:)/),n={},a=0,i.forEach(function(e){var t=e.match(/^(mp4|webm|ogv|ogg)\\:(.*)/);t&&t[1]&&t[2]&&(n[\"ogv\"===t[1]?\"ogg\":t[1]]=t[2],a=1)}),!!a&&n);return r?(this.type=\"youtube\",r):l?(this.type=\"vimeo\",l):!!p&&(this.type=\"local\",p)}},{key:\"isValid\",value:function(){return!!this.videoID}},{key:\"on\",value:function(e,t){this.userEventsList=this.userEventsList||[],(this.userEventsList[e]||(this.userEventsList[e]=[])).push(t)}},{key:\"off\",value:function(o,i){var n=this;this.userEventsList&&this.userEventsList[o]&&(i?this.userEventsList[o].forEach(function(e,t){e===i&&(n.userEventsList[o][t]=!1)}):delete this.userEventsList[o])}},{key:\"fire\",value:function(e){var t=this,o=[].slice.call(arguments,1);this.userEventsList&&void 0!==this.userEventsList[e]&&this.userEventsList[e].forEach(function(e){e&&e.apply(t,o)})}},{key:\"play\",value:function(e){var t=this;t.player&&(\"youtube\"===t.type&&t.player.playVideo&&(void 0!==e&&t.player.seekTo(e||0),YT.PlayerState.PLAYING!==t.player.getPlayerState()&&t.player.playVideo()),\"vimeo\"===t.type&&(void 0!==e&&t.player.setCurrentTime(e),t.player.getPaused().then(function(e){e&&t.player.play()})),\"local\"===t.type&&(void 0!==e&&(t.player.currentTime=e),t.player.paused&&t.player.play()))}},{key:\"pause\",value:function(){var t=this;t.player&&(\"youtube\"===t.type&&t.player.pauseVideo&&YT.PlayerState.PLAYING===t.player.getPlayerState()&&t.player.pauseVideo(),\"vimeo\"===t.type&&t.player.getPaused().then(function(e){e||t.player.pause()}),\"local\"===t.type&&(t.player.paused||t.player.pause()))}},{key:\"mute\",value:function(){var e=this;e.player&&(\"youtube\"===e.type&&e.player.mute&&e.player.mute(),\"vimeo\"===e.type&&e.player.setVolume&&e.player.setVolume(0),\"local\"===e.type&&(e.$video.muted=!0))}},{key:\"unmute\",value:function(){var e=this;e.player&&(\"youtube\"===e.type&&e.player.mute&&e.player.unMute(),\"vimeo\"===e.type&&e.player.setVolume&&e.player.setVolume(e.options.volume),\"local\"===e.type&&(e.$video.muted=!1))}},{key:\"setVolume\",value:function(e){var t=0<arguments.length&&void 0!==e&&e,o=this;o.player&&t&&(\"youtube\"===o.type&&o.player.setVolume&&o.player.setVolume(t),\"vimeo\"===o.type&&o.player.setVolume&&o.player.setVolume(t),\"local\"===o.type&&(o.$video.volume=t/100))}},{key:\"getVolume\",value:function(t){var e=this;e.player?(\"youtube\"===e.type&&e.player.getVolume&&t(e.player.getVolume()),\"vimeo\"===e.type&&e.player.getVolume&&e.player.getVolume().then(function(e){t(e)}),\"local\"===e.type&&t(100*e.$video.volume)):t(!1)}},{key:\"getMuted\",value:function(t){var e=this;e.player?(\"youtube\"===e.type&&e.player.isMuted&&t(e.player.isMuted()),\"vimeo\"===e.type&&e.player.getVolume&&e.player.getVolume().then(function(e){t(!!e)}),\"local\"===e.type&&t(e.$video.muted)):t(null)}},{key:\"getImageURL\",value:function(t){var o=this;if(o.videoImage)t(o.videoImage);else{if(\"youtube\"===o.type){var e=[\"maxresdefault\",\"sddefault\",\"hqdefault\",\"0\"],i=0,n=new Image;n.onload=function(){120!==(this.naturalWidth||this.width)||i===e.length-1?(o.videoImage=\"https://img.youtube.com/vi/\".concat(o.videoID,\"/\").concat(e[i],\".jpg\"),t(o.videoImage)):(i++,this.src=\"https://img.youtube.com/vi/\".concat(o.videoID,\"/\").concat(e[i],\".jpg\"))},n.src=\"https://img.youtube.com/vi/\".concat(o.videoID,\"/\").concat(e[i],\".jpg\")}if(\"vimeo\"===o.type){var a=new XMLHttpRequest;a.open(\"GET\",\"https://vimeo.com/api/v2/video/\".concat(o.videoID,\".json\"),!0),a.onreadystatechange=function(){if(4===this.readyState&&200<=this.status&&this.status<400){var e=JSON.parse(this.responseText);o.videoImage=e[0].thumbnail_large,t(o.videoImage)}},a.send(),a=null}}}},{key:\"getIframe\",value:function(e){this.getVideo(e)}},{key:\"getVideo\",value:function(p){var u=this;u.$video?p(u.$video):u.onAPIready(function(){var e,t;if(u.$video||((e=document.createElement(\"div\")).style.display=\"none\"),\"youtube\"===u.type){var o,i;u.playerOptions={},u.playerOptions.videoId=u.videoID,u.playerOptions.playerVars={autohide:1,rel:0,autoplay:0,playsinline:1},u.options.showContols||(u.playerOptions.playerVars.iv_load_policy=3,u.playerOptions.playerVars.modestbranding=1,u.playerOptions.playerVars.controls=0,u.playerOptions.playerVars.showinfo=0,u.playerOptions.playerVars.disablekb=1),u.playerOptions.events={onReady:function(t){if(u.options.mute?t.target.mute():u.options.volume&&t.target.setVolume(u.options.volume),u.options.autoplay&&u.play(u.options.startTime),u.fire(\"ready\",t),u.options.loop&&!u.options.endTime){u.options.endTime=u.player.getDuration()-.1}setInterval(function(){u.getVolume(function(e){u.options.volume!==e&&(u.options.volume=e,u.fire(\"volumechange\",t))})},150)},onStateChange:function(e){u.options.loop&&e.data===YT.PlayerState.ENDED&&u.play(u.options.startTime),o||e.data!==YT.PlayerState.PLAYING||(o=1,u.fire(\"started\",e)),e.data===YT.PlayerState.PLAYING&&u.fire(\"play\",e),e.data===YT.PlayerState.PAUSED&&u.fire(\"pause\",e),e.data===YT.PlayerState.ENDED&&u.fire(\"ended\",e),e.data===YT.PlayerState.PLAYING?i=setInterval(function(){u.fire(\"timeupdate\",e),u.options.endTime&&u.player.getCurrentTime()>=u.options.endTime&&(u.options.loop?u.play(u.options.startTime):u.pause())},150):clearInterval(i)}};var n=!u.$video;if(n){var a=document.createElement(\"div\");a.setAttribute(\"id\",u.playerID),e.appendChild(a),document.body.appendChild(e)}u.player=u.player||new window.YT.Player(u.playerID,u.playerOptions),n&&(u.$video=document.getElementById(u.playerID),u.videoWidth=parseInt(u.$video.getAttribute(\"width\"),10)||1280,u.videoHeight=parseInt(u.$video.getAttribute(\"height\"),10)||720)}if(\"vimeo\"===u.type){if(u.playerOptions={id:u.videoID,autopause:0,transparent:0,autoplay:u.options.autoplay?1:0,loop:u.options.loop?1:0,muted:u.options.mute?1:0},u.options.volume&&(u.playerOptions.volume=u.options.volume),u.options.showContols||(u.playerOptions.badge=0,u.playerOptions.byline=0,u.playerOptions.portrait=0,u.playerOptions.title=0,u.playerOptions.background=1),!u.$video){var r=\"\";Object.keys(u.playerOptions).forEach(function(e){\"\"!==r&&(r+=\"&\"),r+=\"\".concat(e,\"=\").concat(encodeURIComponent(u.playerOptions[e]))}),u.$video=document.createElement(\"iframe\"),u.$video.setAttribute(\"id\",u.playerID),u.$video.setAttribute(\"src\",\"https://player.vimeo.com/video/\".concat(u.videoID,\"?\").concat(r)),u.$video.setAttribute(\"frameborder\",\"0\"),u.$video.setAttribute(\"mozallowfullscreen\",\"\"),u.$video.setAttribute(\"allowfullscreen\",\"\"),e.appendChild(u.$video),document.body.appendChild(e)}var l;u.player=u.player||new Vimeo.Player(u.$video,u.playerOptions),u.options.startTime&&u.options.autoplay&&u.player.setCurrentTime(u.options.startTime),u.player.getVideoWidth().then(function(e){u.videoWidth=e||1280}),u.player.getVideoHeight().then(function(e){u.videoHeight=e||720}),u.player.on(\"timeupdate\",function(e){l||(u.fire(\"started\",e),l=1),u.fire(\"timeupdate\",e),u.options.endTime&&u.options.endTime&&e.seconds>=u.options.endTime&&(u.options.loop?u.play(u.options.startTime):u.pause())}),u.player.on(\"play\",function(e){u.fire(\"play\",e),u.options.startTime&&0===e.seconds&&u.play(u.options.startTime)}),u.player.on(\"pause\",function(e){u.fire(\"pause\",e)}),u.player.on(\"ended\",function(e){u.fire(\"ended\",e)}),u.player.on(\"loaded\",function(e){u.fire(\"ready\",e)}),u.player.on(\"volumechange\",function(e){u.fire(\"volumechange\",e)})}\"local\"===u.type&&(u.$video||(u.$video=document.createElement(\"video\"),u.options.showContols&&(u.$video.controls=!0),u.options.mute?u.$video.muted=!0:u.$video.volume&&(u.$video.volume=u.options.volume/100),u.options.loop&&(u.$video.loop=!0),u.$video.setAttribute(\"playsinline\",\"\"),u.$video.setAttribute(\"webkit-playsinline\",\"\"),u.$video.setAttribute(\"id\",u.playerID),e.appendChild(u.$video),document.body.appendChild(e),Object.keys(u.videoID).forEach(function(e){!function(e,t,o){var i=document.createElement(\"source\");i.src=t,i.type=o,e.appendChild(i)}(u.$video,u.videoID[e],\"video/\".concat(e))})),u.player=u.player||u.$video,u.player.addEventListener(\"playing\",function(e){t||u.fire(\"started\",e),t=1}),u.player.addEventListener(\"timeupdate\",function(e){u.fire(\"timeupdate\",e),u.options.endTime&&u.options.endTime&&this.currentTime>=u.options.endTime&&(u.options.loop?u.play(u.options.startTime):u.pause())}),u.player.addEventListener(\"play\",function(e){u.fire(\"play\",e)}),u.player.addEventListener(\"pause\",function(e){u.fire(\"pause\",e)}),u.player.addEventListener(\"ended\",function(e){u.fire(\"ended\",e)}),u.player.addEventListener(\"loadedmetadata\",function(){u.videoWidth=this.videoWidth||1280,u.videoHeight=this.videoHeight||720,u.fire(\"ready\"),u.options.autoplay&&u.play(u.options.startTime)}),u.player.addEventListener(\"volumechange\",function(e){u.getVolume(function(e){u.options.volume=e}),u.fire(\"volumechange\",e)}));p(u.$video)})}},{key:\"init\",value:function(){this.playerID=\"VideoWorker-\".concat(this.ID)}},{key:\"loadAPI\",value:function(){if(!l||!p){var e=\"\";if(\"youtube\"!==this.type||l||(l=1,e=\"https://www.youtube.com/iframe_api\"),\"vimeo\"===this.type&&!p){if(p=1,\"undefined\"!=typeof Vimeo)return;e=\"https://player.vimeo.com/api/player.js\"}if(e){var t=document.createElement(\"script\"),o=document.getElementsByTagName(\"head\")[0];t.src=e,o.appendChild(t),t=o=null}}}},{key:\"onAPIready\",value:function(e){if(\"youtube\"===this.type&&(\"undefined\"!=typeof YT&&0!==YT.loaded||u?\"object\"===(\"undefined\"==typeof YT?\"undefined\":n(YT))&&1===YT.loaded?e():d.done(function(){e()}):(u=1,window.onYouTubeIframeAPIReady=function(){window.onYouTubeIframeAPIReady=null,d.resolve(\"done\"),e()})),\"vimeo\"===this.type)if(\"undefined\"!=typeof Vimeo||s)\"undefined\"!=typeof Vimeo?e():y.done(function(){e()});else{s=1;var t=setInterval(function(){\"undefined\"!=typeof Vimeo&&(clearInterval(t),y.resolve(\"done\"),e())},20)}\"local\"===this.type&&e()}}]),i}()},function(e,t,o){\"use strict\";o.r(t),o.d(t,\"default\",function(){return a});var i=o(8),r=o.n(i),n=o(4),p=o.n(n);function a(){var e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:p.a.jarallax;if(void 0!==e){var t=e.constructor,i=t.prototype.onScroll;t.prototype.onScroll=function(){var o=this;i.apply(o),o.isVideoInserted||!o.video||o.options.videoLazyLoading&&!o.isElementInViewport||o.options.disableVideo()||(o.isVideoInserted=!0,o.video.getVideo(function(e){var t=e.parentNode;o.css(e,{position:o.image.position,top:\"0px\",left:\"0px\",right:\"0px\",bottom:\"0px\",width:\"100%\",height:\"100%\",maxWidth:\"none\",maxHeight:\"none\",margin:0,zIndex:-1}),o.$video=e,o.image.$container.appendChild(e),t.parentNode.removeChild(t)}))};var l=t.prototype.coverImage;t.prototype.coverImage=function(){var e=this,t=l.apply(e),o=!!e.image.$item&&e.image.$item.nodeName;if(t&&e.video&&o&&(\"IFRAME\"===o||\"VIDEO\"===o)){var i=t.image.height,n=i*e.image.width/e.image.height,a=(t.container.width-n)/2,r=t.image.marginTop;t.container.width>n&&(i=(n=t.container.width)*e.image.height/e.image.width,a=0,r+=(t.image.height-i)/2),\"IFRAME\"===o&&(i+=400,r-=200),e.css(e.$video,{width:\"\".concat(n,\"px\"),marginLeft:\"\".concat(a,\"px\"),height:\"\".concat(i,\"px\"),marginTop:\"\".concat(r,\"px\")})}return t};var o=t.prototype.initImg;t.prototype.initImg=function(){var e=this,t=o.apply(e);return e.options.videoSrc||(e.options.videoSrc=e.$item.getAttribute(\"data-jarallax-video\")||null),e.options.videoSrc?(e.defaultInitImgResult=t,!0):t};var n=t.prototype.canInitParallax;t.prototype.canInitParallax=function(){var o=this,e=n.apply(o);if(!o.options.videoSrc)return e;var t=new r.a(o.options.videoSrc,{autoplay:!0,loop:o.options.videoLoop,showContols:!1,startTime:o.options.videoStartTime||0,endTime:o.options.videoEndTime||0,mute:o.options.videoVolume?0:1,volume:o.options.videoVolume||0});if(t.isValid())if(e){if(t.on(\"ready\",function(){if(o.options.videoPlayOnlyVisible){var e=o.onScroll;o.onScroll=function(){e.apply(o),!o.options.videoLoop&&(o.options.videoLoop||o.videoEnded)||(o.isVisible()?t.play():t.pause())}}else t.play()}),t.on(\"started\",function(){o.image.$default_item=o.image.$item,o.image.$item=o.$video,o.image.width=o.video.videoWidth||1280,o.image.height=o.video.videoHeight||720,o.coverImage(),o.clipContainer(),o.onScroll(),o.image.$default_item&&(o.image.$default_item.style.display=\"none\")}),t.on(\"ended\",function(){o.videoEnded=!0,o.options.videoLoop||o.image.$default_item&&(o.image.$item=o.image.$default_item,o.image.$item.style.display=\"block\",o.coverImage(),o.clipContainer(),o.onScroll())}),o.video=t,!o.defaultInitImgResult)return o.image.src=\"data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7\",\"local\"===t.type||(t.getImageURL(function(e){o.image.bgImage='url(\"'.concat(e,'\")'),o.init()}),!1)}else o.defaultInitImgResult||t.getImageURL(function(e){var t=o.$item.getAttribute(\"style\");t&&o.$item.setAttribute(\"data-jarallax-original-styles\",t),o.css(o.$item,{\"background-image\":'url(\"'.concat(e,'\")'),\"background-position\":\"center\",\"background-size\":\"cover\"})});return e};var a=t.prototype.destroy;t.prototype.destroy=function(){var e=this;e.image.$default_item&&(e.image.$item=e.image.$default_item,delete e.image.$default_item),a.apply(e)}}}}]);\n//# sourceMappingURL=jarallax-video.min.js.map\n","Magento_PageBuilder/js/resource/jarallax/jarallax.min.js":"/*!\n * Name    : Just Another Parallax [Jarallax]\n * Version : 1.12.5\n * Author  : nK <https://nkdev.info>\n * GitHub  : https://github.com/nk-o/jarallax\n */!function(n){var o={};function i(e){if(o[e])return o[e].exports;var t=o[e]={i:e,l:!1,exports:{}};return n[e].call(t.exports,t,t.exports,i),t.l=!0,t.exports}i.m=n,i.c=o,i.d=function(e,t,n){i.o(e,t)||Object.defineProperty(e,t,{enumerable:!0,get:n})},i.r=function(e){\"undefined\"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:\"Module\"}),Object.defineProperty(e,\"__esModule\",{value:!0})},i.t=function(t,e){if(1&e&&(t=i(t)),8&e)return t;if(4&e&&\"object\"==typeof t&&t&&t.__esModule)return t;var n=Object.create(null);if(i.r(n),Object.defineProperty(n,\"default\",{enumerable:!0,value:t}),2&e&&\"string\"!=typeof t)for(var o in t)i.d(n,o,function(e){return t[e]}.bind(null,o));return n},i.n=function(e){var t=e&&e.__esModule?function(){return e.default}:function(){return e};return i.d(t,\"a\",t),t},i.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},i.p=\"\",i(i.s=10)}([,,function(e,t){e.exports=function(e){\"complete\"===document.readyState||\"interactive\"===document.readyState?e.call():document.attachEvent?document.attachEvent(\"onreadystatechange\",function(){\"interactive\"===document.readyState&&e.call()}):document.addEventListener&&document.addEventListener(\"DOMContentLoaded\",e)}},function(n,e,t){(function(e){var t=\"undefined\"!=typeof window?window:void 0!==e?e:\"undefined\"!=typeof self?self:{};n.exports=t}).call(this,t(4))},function(e,t){function n(e){return(n=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&\"function\"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?\"symbol\":typeof e})(e)}var o=function(){return this}();try{o=o||new Function(\"return this\")()}catch(e){\"object\"===(\"undefined\"==typeof window?\"undefined\":n(window))&&(o=window)}e.exports=o},,,,,,function(e,t,n){e.exports=n(11)},function(e,t,n){\"use strict\";n.r(t);var o=n(2),i=n.n(o),a=n(3),r=n(12);function l(e){return(l=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&\"function\"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?\"symbol\":typeof e})(e)}var s,c,u=a.window.jarallax;a.window.jarallax=r.default,a.window.jarallax.noConflict=function(){return a.window.jarallax=u,this},void 0!==a.jQuery&&((s=function(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];Array.prototype.unshift.call(t,this);var o=r.default.apply(a.window,t);return\"object\"!==l(o)?o:this}).constructor=r.default.constructor,c=a.jQuery.fn.jarallax,a.jQuery.fn.jarallax=s,a.jQuery.fn.jarallax.noConflict=function(){return a.jQuery.fn.jarallax=c,this}),i()(function(){Object(r.default)(document.querySelectorAll(\"[data-jarallax]\"))})},function(e,t,n){\"use strict\";n.r(t);var o=n(2),i=n.n(o),b=n(3);function c(e,t){return function(e){if(Array.isArray(e))return e}(e)||function(e,t){if(\"undefined\"==typeof Symbol||!(Symbol.iterator in Object(e)))return;var n=[],o=!0,i=!1,a=void 0;try{for(var r,l=e[Symbol.iterator]();!(o=(r=l.next()).done)&&(n.push(r.value),!t||n.length!==t);o=!0);}catch(e){i=!0,a=e}finally{try{o||null==l.return||l.return()}finally{if(i)throw a}}return n}(e,t)||function(e,t){if(!e)return;if(\"string\"==typeof e)return a(e,t);var n=Object.prototype.toString.call(e).slice(8,-1);\"Object\"===n&&e.constructor&&(n=e.constructor.name);if(\"Map\"===n||\"Set\"===n)return Array.from(e);if(\"Arguments\"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return a(e,t)}(e,t)||function(){throw new TypeError(\"Invalid attempt to destructure non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\")}()}function a(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,o=new Array(t);n<t;n++)o[n]=e[n];return o}function u(e){return(u=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&\"function\"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?\"symbol\":typeof e})(e)}function r(e,t){for(var n=0;n<t.length;n++){var o=t[n];o.enumerable=o.enumerable||!1,o.configurable=!0,\"value\"in o&&(o.writable=!0),Object.defineProperty(e,o.key,o)}}var l,h,p=b.window.navigator,d=-1<p.userAgent.indexOf(\"MSIE \")||-1<p.userAgent.indexOf(\"Trident/\")||-1<p.userAgent.indexOf(\"Edge/\"),s=/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(p.userAgent),m=function(){for(var e=\"transform WebkitTransform MozTransform\".split(\" \"),t=document.createElement(\"div\"),n=0;n<e.length;n+=1)if(t&&void 0!==t.style[e[n]])return e[n];return!1}();function f(){h=s?(!l&&document.body&&((l=document.createElement(\"div\")).style.cssText=\"position: fixed; top: -9999px; left: 0; height: 100vh; width: 0;\",document.body.appendChild(l)),(l?l.clientHeight:0)||b.window.innerHeight||document.documentElement.clientHeight):b.window.innerHeight||document.documentElement.clientHeight}f(),b.window.addEventListener(\"resize\",f),b.window.addEventListener(\"orientationchange\",f),b.window.addEventListener(\"load\",f),i()(function(){f()});var g=[];function y(){g.length&&(g.forEach(function(e,t){var n=e.instance,o=e.oldData,i=n.$item.getBoundingClientRect(),a={width:i.width,height:i.height,top:i.top,bottom:i.bottom,wndW:b.window.innerWidth,wndH:h},r=!o||o.wndW!==a.wndW||o.wndH!==a.wndH||o.width!==a.width||o.height!==a.height,l=r||!o||o.top!==a.top||o.bottom!==a.bottom;g[t].oldData=a,r&&n.onResize(),l&&n.onScroll()}),b.window.requestAnimationFrame(y))}function v(e,t){(\"object\"===(\"undefined\"==typeof HTMLElement?\"undefined\":u(HTMLElement))?e instanceof HTMLElement:e&&\"object\"===u(e)&&null!==e&&1===e.nodeType&&\"string\"==typeof e.nodeName)&&(e=[e]);for(var n,o=e.length,i=0,a=arguments.length,r=new Array(2<a?a-2:0),l=2;l<a;l++)r[l-2]=arguments[l];for(;i<o;i+=1)if(\"object\"===u(t)||void 0===t?e[i].jarallax||(e[i].jarallax=new w(e[i],t)):e[i].jarallax&&(n=e[i].jarallax[t].apply(e[i].jarallax,r)),void 0!==n)return n;return e}var x=0,w=function(){function s(e,t){!function(e,t){if(!(e instanceof t))throw new TypeError(\"Cannot call a class as a function\")}(this,s);var n=this;n.instanceID=x,x+=1,n.$item=e,n.defaults={type:\"scroll\",speed:.5,imgSrc:null,imgElement:\".jarallax-img\",imgSize:\"cover\",imgPosition:\"50% 50%\",imgRepeat:\"no-repeat\",keepImg:!1,elementInViewport:null,zIndex:-100,disableParallax:!1,disableVideo:!1,videoSrc:null,videoStartTime:0,videoEndTime:0,videoVolume:0,videoLoop:!0,videoPlayOnlyVisible:!0,videoLazyLoading:!0,onScroll:null,onInit:null,onDestroy:null,onCoverImage:null};var o,i,a=n.$item.dataset||{},r={};Object.keys(a).forEach(function(e){var t=e.substr(0,1).toLowerCase()+e.substr(1);t&&void 0!==n.defaults[t]&&(r[t]=a[e])}),n.options=n.extend({},n.defaults,r,t),n.pureOptions=n.extend({},n.options),Object.keys(n.options).forEach(function(e){\"true\"===n.options[e]?n.options[e]=!0:\"false\"===n.options[e]&&(n.options[e]=!1)}),n.options.speed=Math.min(2,Math.max(-1,parseFloat(n.options.speed))),\"string\"==typeof n.options.disableParallax&&(n.options.disableParallax=new RegExp(n.options.disableParallax)),n.options.disableParallax instanceof RegExp&&(o=n.options.disableParallax,n.options.disableParallax=function(){return o.test(p.userAgent)}),\"function\"!=typeof n.options.disableParallax&&(n.options.disableParallax=function(){return!1}),\"string\"==typeof n.options.disableVideo&&(n.options.disableVideo=new RegExp(n.options.disableVideo)),n.options.disableVideo instanceof RegExp&&(i=n.options.disableVideo,n.options.disableVideo=function(){return i.test(p.userAgent)}),\"function\"!=typeof n.options.disableVideo&&(n.options.disableVideo=function(){return!1});var l=n.options.elementInViewport;l&&\"object\"===u(l)&&void 0!==l.length&&(l=c(l,1)[0]),l instanceof Element||(l=null),n.options.elementInViewport=l,n.image={src:n.options.imgSrc||null,$container:null,useImgTag:!1,position:/iPad|iPhone|iPod|Android/.test(p.userAgent)?\"absolute\":\"fixed\"},n.initImg()&&n.canInitParallax()&&n.init()}var e,t,n;return e=s,(t=[{key:\"css\",value:function(t,n){return\"string\"==typeof n?b.window.getComputedStyle(t).getPropertyValue(n):(n.transform&&m&&(n[m]=n.transform),Object.keys(n).forEach(function(e){t.style[e]=n[e]}),t)}},{key:\"extend\",value:function(n){for(var e=arguments.length,o=new Array(1<e?e-1:0),t=1;t<e;t++)o[t-1]=arguments[t];return n=n||{},Object.keys(o).forEach(function(t){o[t]&&Object.keys(o[t]).forEach(function(e){n[e]=o[t][e]})}),n}},{key:\"getWindowData\",value:function(){return{width:b.window.innerWidth||document.documentElement.clientWidth,height:h,y:document.documentElement.scrollTop}}},{key:\"initImg\",value:function(){var e=this,t=e.options.imgElement;return t&&\"string\"==typeof t&&(t=e.$item.querySelector(t)),t instanceof Element||(e.options.imgSrc?(t=new Image).src=e.options.imgSrc:t=null),t&&(e.options.keepImg?e.image.$item=t.cloneNode(!0):(e.image.$item=t,e.image.$itemParent=t.parentNode),e.image.useImgTag=!0),!!e.image.$item||(null===e.image.src&&(e.image.src=\"data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7\",e.image.bgImage=e.css(e.$item,\"background-image\")),!(!e.image.bgImage||\"none\"===e.image.bgImage))}},{key:\"canInitParallax\",value:function(){return m&&!this.options.disableParallax()}},{key:\"init\",value:function(){var e,t,n,o=this,i={position:\"absolute\",top:0,left:0,width:\"100%\",height:\"100%\",overflow:\"hidden\"},a={pointerEvents:\"none\",transformStyle:\"preserve-3d\",backfaceVisibility:\"hidden\",willChange:\"transform,opacity\"};o.options.keepImg||((e=o.$item.getAttribute(\"style\"))&&o.$item.setAttribute(\"data-jarallax-original-styles\",e),!o.image.useImgTag||(t=o.image.$item.getAttribute(\"style\"))&&o.image.$item.setAttribute(\"data-jarallax-original-styles\",t)),\"static\"===o.css(o.$item,\"position\")&&o.css(o.$item,{position:\"relative\"}),\"auto\"===o.css(o.$item,\"z-index\")&&o.css(o.$item,{zIndex:0}),o.image.$container=document.createElement(\"div\"),o.css(o.image.$container,i),o.css(o.image.$container,{\"z-index\":o.options.zIndex}),d&&o.css(o.image.$container,{opacity:.9999}),o.image.$container.setAttribute(\"id\",\"jarallax-container-\".concat(o.instanceID)),o.$item.appendChild(o.image.$container),o.image.useImgTag?a=o.extend({\"object-fit\":o.options.imgSize,\"object-position\":o.options.imgPosition,\"font-family\":\"object-fit: \".concat(o.options.imgSize,\"; object-position: \").concat(o.options.imgPosition,\";\"),\"max-width\":\"none\"},i,a):(o.image.$item=document.createElement(\"div\"),o.image.src&&(a=o.extend({\"background-position\":o.options.imgPosition,\"background-size\":o.options.imgSize,\"background-repeat\":o.options.imgRepeat,\"background-image\":o.image.bgImage||'url(\"'.concat(o.image.src,'\")')},i,a))),\"opacity\"!==o.options.type&&\"scale\"!==o.options.type&&\"scale-opacity\"!==o.options.type&&1!==o.options.speed||(o.image.position=\"absolute\"),\"fixed\"===o.image.position&&(n=function(e){for(var t=[];null!==e.parentElement;)1===(e=e.parentElement).nodeType&&t.push(e);return t}(o.$item).filter(function(e){var t=b.window.getComputedStyle(e),n=t[\"-webkit-transform\"]||t[\"-moz-transform\"]||t.transform;return n&&\"none\"!==n||/(auto|scroll)/.test(t.overflow+t[\"overflow-y\"]+t[\"overflow-x\"])}),o.image.position=n.length?\"absolute\":\"fixed\"),a.position=o.image.position,o.css(o.image.$item,a),o.image.$container.appendChild(o.image.$item),o.onResize(),o.onScroll(!0),o.options.onInit&&o.options.onInit.call(o),\"none\"!==o.css(o.$item,\"background-image\")&&o.css(o.$item,{\"background-image\":\"none\"}),o.addToParallaxList()}},{key:\"addToParallaxList\",value:function(){g.push({instance:this}),1===g.length&&b.window.requestAnimationFrame(y)}},{key:\"removeFromParallaxList\",value:function(){var n=this;g.forEach(function(e,t){e.instance.instanceID===n.instanceID&&g.splice(t,1)})}},{key:\"destroy\",value:function(){var e=this;e.removeFromParallaxList();var t,n=e.$item.getAttribute(\"data-jarallax-original-styles\");e.$item.removeAttribute(\"data-jarallax-original-styles\"),n?e.$item.setAttribute(\"style\",n):e.$item.removeAttribute(\"style\"),e.image.useImgTag&&(t=e.image.$item.getAttribute(\"data-jarallax-original-styles\"),e.image.$item.removeAttribute(\"data-jarallax-original-styles\"),t?e.image.$item.setAttribute(\"style\",n):e.image.$item.removeAttribute(\"style\"),e.image.$itemParent&&e.image.$itemParent.appendChild(e.image.$item)),e.$clipStyles&&e.$clipStyles.parentNode.removeChild(e.$clipStyles),e.image.$container&&e.image.$container.parentNode.removeChild(e.image.$container),e.options.onDestroy&&e.options.onDestroy.call(e),delete e.$item.jarallax}},{key:\"clipContainer\",value:function(){var e,t,n,o,i;\"fixed\"===this.image.position&&(n=(t=(e=this).image.$container.getBoundingClientRect()).width,o=t.height,e.$clipStyles||(e.$clipStyles=document.createElement(\"style\"),e.$clipStyles.setAttribute(\"type\",\"text/css\"),e.$clipStyles.setAttribute(\"id\",\"jarallax-clip-\".concat(e.instanceID)),(document.head||document.getElementsByTagName(\"head\")[0]).appendChild(e.$clipStyles)),i=\"#jarallax-container-\".concat(e.instanceID,\" {\\n            clip: rect(0 \").concat(n,\"px \").concat(o,\"px 0);\\n            clip: rect(0, \").concat(n,\"px, \").concat(o,\"px, 0);\\n            -webkit-clip-path: polygon(0 0, 100% 0, 100% 100%, 0 100%);\\n            clip-path: polygon(0 0, 100% 0, 100% 100%, 0 100%);\\n        }\"),e.$clipStyles.styleSheet?e.$clipStyles.styleSheet.cssText=i:e.$clipStyles.innerHTML=i)}},{key:\"coverImage\",value:function(){var e=this,t=e.image.$container.getBoundingClientRect(),n=t.height,o=e.options.speed,i=\"scroll\"===e.options.type||\"scroll-opacity\"===e.options.type,a=0,r=n,l=0;return i&&(o<0?(a=o*Math.max(n,h),h<n&&(a-=o*(n-h))):a=o*(n+h),1<o?r=Math.abs(a-h):o<0?r=a/o+Math.abs(a):r+=(h-n)*(1-o),a/=2),e.parallaxScrollDistance=a,l=i?(h-r)/2:(n-r)/2,e.css(e.image.$item,{height:\"\".concat(r,\"px\"),marginTop:\"\".concat(l,\"px\"),left:\"fixed\"===e.image.position?\"\".concat(t.left,\"px\"):\"0\",width:\"\".concat(t.width,\"px\")}),e.options.onCoverImage&&e.options.onCoverImage.call(e),{image:{height:r,marginTop:l},container:t}}},{key:\"isVisible\",value:function(){return this.isElementInViewport||!1}},{key:\"onScroll\",value:function(e){var t,n,o,i,a,r,l,s,c,u,p=this,d=p.$item.getBoundingClientRect(),m=d.top,f=d.height,g={},y=d;p.options.elementInViewport&&(y=p.options.elementInViewport.getBoundingClientRect()),p.isElementInViewport=0<=y.bottom&&0<=y.right&&y.top<=h&&y.left<=b.window.innerWidth,(e||p.isElementInViewport)&&(t=Math.max(0,m),n=Math.max(0,f+m),o=Math.max(0,-m),i=Math.max(0,m+f-h),a=Math.max(0,f-(m+f-h)),r=Math.max(0,-m+h-f),l=1-(h-m)/(h+f)*2,s=1,f<h?s=1-(o||i)/f:n<=h?s=n/h:a<=h&&(s=a/h),\"opacity\"!==p.options.type&&\"scale-opacity\"!==p.options.type&&\"scroll-opacity\"!==p.options.type||(g.transform=\"translate3d(0,0,0)\",g.opacity=s),\"scale\"!==p.options.type&&\"scale-opacity\"!==p.options.type||(c=1,p.options.speed<0?c-=p.options.speed*s:c+=p.options.speed*(1-s),g.transform=\"scale(\".concat(c,\") translate3d(0,0,0)\")),\"scroll\"!==p.options.type&&\"scroll-opacity\"!==p.options.type||(u=p.parallaxScrollDistance*l,\"absolute\"===p.image.position&&(u-=m),g.transform=\"translate3d(0,\".concat(u,\"px,0)\")),p.css(p.image.$item,g),p.options.onScroll&&p.options.onScroll.call(p,{section:d,beforeTop:t,beforeTopEnd:n,afterTop:o,beforeBottom:i,beforeBottomEnd:a,afterBottom:r,visiblePercent:s,fromViewportCenter:l}))}},{key:\"onResize\",value:function(){this.coverImage(),this.clipContainer()}}])&&r(e.prototype,t),n&&r(e,n),s}();v.constructor=w,t.default=v}]);\n//# sourceMappingURL=jarallax.min.js.map\n","Magento_PageBuilder/js/resource/vimeo/player.min.js":"/*! @vimeo/player v2.10.0 | (c) 2019 Vimeo | MIT License | https://github.com/vimeo/player.js */\n!function(e,t){\"object\"==typeof exports&&\"undefined\"!=typeof module?module.exports=t():\"function\"==typeof define&&define.amd?define(t):((e=e||self).Vimeo=e.Vimeo||{},e.Vimeo.Player=t())}(this,function(){\"use strict\";function r(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,\"value\"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}var e=\"undefined\"!=typeof global&&\"[object global]\"==={}.toString.call(global);function i(e,t){return 0===e.indexOf(t.toLowerCase())?e:\"\".concat(t.toLowerCase()).concat(e.substr(0,1).toUpperCase()).concat(e.substr(1))}function s(e){return/^(https?:)?\\/\\/((player|www)\\.)?vimeo\\.com(?=$|\\/)/.test(e)}function l(){var e,t=0<arguments.length&&void 0!==arguments[0]?arguments[0]:{},n=t.id,r=t.url,o=n||r;if(!o)throw new Error(\"An id or url must be passed, either in an options object or as a data-vimeo-id or data-vimeo-url attribute.\");if(e=o,!isNaN(parseFloat(e))&&isFinite(e)&&Math.floor(e)==e)return\"https://vimeo.com/\".concat(o);if(s(o))return o.replace(\"http:\",\"https:\");if(n)throw new TypeError(\"\u201c\".concat(n,\"\u201d is not a valid video id.\"));throw new TypeError(\"\u201c\".concat(o,\"\u201d is not a vimeo.com url.\"))}var t=void 0!==Array.prototype.indexOf,n=\"undefined\"!=typeof window&&void 0!==window.postMessage;if(!(e||t&&n))throw new Error(\"Sorry, the Vimeo Player API is not available in this browser.\");var o=\"undefined\"!=typeof window?window:\"undefined\"!=typeof global?global:\"undefined\"!=typeof self?self:{};!function(e){if(!e.WeakMap){var n=Object.prototype.hasOwnProperty,o=function(e,t,n){Object.defineProperty?Object.defineProperty(e,t,{configurable:!0,writable:!0,value:n}):e[t]=n};e.WeakMap=function(){function e(){if(void 0===this)throw new TypeError(\"Constructor WeakMap requires 'new'\");if(o(this,\"_id\",\"_WeakMap\"+\"_\"+t()+\".\"+t()),0<arguments.length)throw new TypeError(\"WeakMap iterable is not supported\")}function r(e,t){if(!i(e)||!n.call(e,\"_id\"))throw new TypeError(t+\" method called on incompatible receiver \"+typeof e)}function t(){return Math.random().toString().substring(2)}return o(e.prototype,\"delete\",function(e){if(r(this,\"delete\"),!i(e))return!1;var t=e[this._id];return!(!t||t[0]!==e)&&(delete e[this._id],!0)}),o(e.prototype,\"get\",function(e){if(r(this,\"get\"),i(e)){var t=e[this._id];return t&&t[0]===e?t[1]:void 0}}),o(e.prototype,\"has\",function(e){if(r(this,\"has\"),!i(e))return!1;var t=e[this._id];return!(!t||t[0]!==e)}),o(e.prototype,\"set\",function(e,t){if(r(this,\"set\"),!i(e))throw new TypeError(\"Invalid value used as weak map key\");var n=e[this._id];return n&&n[0]===e?n[1]=t:o(e,this._id,[e,t]),this}),o(e,\"_polyfill\",!0),e}()}function i(e){return Object(e)===e}}(\"undefined\"!=typeof self?self:\"undefined\"!=typeof window?window:o);var a,f=(function(e){var t,n,r;r=function(){var t,a,n,e=Object.prototype.toString,r=\"undefined\"!=typeof setImmediate?function(e){return setImmediate(e)}:setTimeout;try{Object.defineProperty({},\"x\",{}),t=function(e,t,n,r){return Object.defineProperty(e,t,{value:n,writable:!0,configurable:!1!==r})}}catch(e){t=function(e,t,n){return e[t]=n,e}}function i(e,t){n.add(e,t),a||(a=r(n.drain))}function u(e){var t,n=typeof e;return null==e||\"object\"!=n&&\"function\"!=n||(t=e.then),\"function\"==typeof t&&t}function c(){for(var e=0;e<this.chain.length;e++)o(this,1===this.state?this.chain[e].success:this.chain[e].failure,this.chain[e]);this.chain.length=0}function o(e,t,n){var r,o;try{!1===t?n.reject(e.msg):(r=!0===t?e.msg:t.call(void 0,e.msg))===n.promise?n.reject(TypeError(\"Promise-chain cycle\")):(o=u(r))?o.call(r,n.resolve,n.reject):n.resolve(r)}catch(e){n.reject(e)}}function s(e){var t=this;t.triggered||(t.triggered=!0,t.def&&(t=t.def),t.msg=e,t.state=2,0<t.chain.length&&i(c,t))}function l(e,n,r,o){for(var t=0;t<n.length;t++)!function(t){e.resolve(n[t]).then(function(e){r(t,e)},o)}(t)}function f(e){this.def=e,this.triggered=!1}function d(e){this.promise=e,this.state=0,this.triggered=!1,this.chain=[],this.msg=void 0}function h(e){if(\"function\"!=typeof e)throw TypeError(\"Not a function\");if(0!==this.__NPO__)throw TypeError(\"Not a promise\");this.__NPO__=1;var r=new d(this);this.then=function(e,t){var n={success:\"function\"!=typeof e||e,failure:\"function\"==typeof t&&t};return n.promise=new this.constructor(function(e,t){if(\"function\"!=typeof e||\"function\"!=typeof t)throw TypeError(\"Not a function\");n.resolve=e,n.reject=t}),r.chain.push(n),0!==r.state&&i(c,r),n.promise},this.catch=function(e){return this.then(void 0,e)};try{e.call(void 0,function(e){(function e(n){var r,o=this;if(!o.triggered){o.triggered=!0,o.def&&(o=o.def);try{(r=u(n))?i(function(){var t=new f(o);try{r.call(n,function(){e.apply(t,arguments)},function(){s.apply(t,arguments)})}catch(e){s.call(t,e)}}):(o.msg=n,o.state=1,0<o.chain.length&&i(c,o))}catch(e){s.call(new f(o),e)}}}).call(r,e)},function(e){s.call(r,e)})}catch(e){s.call(r,e)}}n=function(){var n,r,o;function i(e,t){this.fn=e,this.self=t,this.next=void 0}return{add:function(e,t){o=new i(e,t),r?r.next=o:n=o,r=o,o=void 0},drain:function(){var e=n;for(n=r=a=void 0;e;)e.fn.call(e.self),e=e.next}}}();var v=t({},\"constructor\",h,!1);return t(h.prototype=v,\"__NPO__\",0,!1),t(h,\"resolve\",function(n){return n&&\"object\"==typeof n&&1===n.__NPO__?n:new this(function(e,t){if(\"function\"!=typeof e||\"function\"!=typeof t)throw TypeError(\"Not a function\");e(n)})}),t(h,\"reject\",function(n){return new this(function(e,t){if(\"function\"!=typeof e||\"function\"!=typeof t)throw TypeError(\"Not a function\");t(n)})}),t(h,\"all\",function(t){var a=this;return\"[object Array]\"!=e.call(t)?a.reject(TypeError(\"Not an array\")):0===t.length?a.resolve([]):new a(function(n,e){if(\"function\"!=typeof n||\"function\"!=typeof e)throw TypeError(\"Not a function\");var r=t.length,o=Array(r),i=0;l(a,t,function(e,t){o[e]=t,++i===r&&n(o)},e)})}),t(h,\"race\",function(t){var r=this;return\"[object Array]\"!=e.call(t)?r.reject(TypeError(\"Not an array\")):new r(function(n,e){if(\"function\"!=typeof n||\"function\"!=typeof e)throw TypeError(\"Not a function\");l(r,t,function(e,t){n(t)},e)})}),h},(n=o)[t=\"Promise\"]=n[t]||r(),e.exports&&(e.exports=n[t])}(a={exports:{}},a.exports),a.exports),d=new WeakMap;function u(e,t,n){var r=d.get(e.element)||{};t in r||(r[t]=[]),r[t].push(n),d.set(e.element,r)}function c(e,t){return(d.get(e.element)||{})[t]||[]}function h(e,t,n){var r=d.get(e.element)||{};if(!r[t])return!0;if(!n)return r[t]=[],d.set(e.element,r),!0;var o=r[t].indexOf(n);return-1!==o&&r[t].splice(o,1),d.set(e.element,r),r[t]&&0===r[t].length}var v=[\"autopause\",\"autoplay\",\"background\",\"byline\",\"color\",\"controls\",\"dnt\",\"height\",\"id\",\"loop\",\"maxheight\",\"maxwidth\",\"muted\",\"playsinline\",\"portrait\",\"responsive\",\"speed\",\"texttrack\",\"title\",\"transparent\",\"url\",\"width\"];function p(r){var e=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{};return v.reduce(function(e,t){var n=r.getAttribute(\"data-vimeo-\".concat(t));return(n||\"\"===n)&&(e[t]=\"\"===n?1:n),e},e)}function y(e,t){var n=e.html;if(!t)throw new TypeError(\"An element must be provided\");if(null!==t.getAttribute(\"data-vimeo-initialized\"))return t.querySelector(\"iframe\");var r=document.createElement(\"div\");return r.innerHTML=n,t.appendChild(r.firstChild),t.setAttribute(\"data-vimeo-initialized\",\"true\"),t.querySelector(\"iframe\")}function m(i){var a=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},u=2<arguments.length?arguments[2]:void 0;return new Promise(function(t,n){if(!s(i))throw new TypeError(\"\u201c\".concat(i,\"\u201d is not a vimeo.com url.\"));var e=\"https://vimeo.com/api/oembed.json?url=\".concat(encodeURIComponent(i));for(var r in a)a.hasOwnProperty(r)&&(e+=\"&\".concat(r,\"=\").concat(encodeURIComponent(a[r])));var o=\"XDomainRequest\"in window?new XDomainRequest:new XMLHttpRequest;o.open(\"GET\",e,!0),o.onload=function(){if(404!==o.status)if(403!==o.status)try{var e=JSON.parse(o.responseText);if(403===e.domain_status_code)return y(e,u),void n(new Error(\"\u201c\".concat(i,\"\u201d is not embeddable.\")));t(e)}catch(e){n(e)}else n(new Error(\"\u201c\".concat(i,\"\u201d is not embeddable.\")));else n(new Error(\"\u201c\".concat(i,\"\u201d was not found.\")))},o.onerror=function(){var e=o.status?\" (\".concat(o.status,\")\"):\"\";n(new Error(\"There was an error fetching the embed code from Vimeo\".concat(e,\".\")))},o.send()})}function g(e){if(\"string\"==typeof e)try{e=JSON.parse(e)}catch(e){return console.warn(e),{}}return e}function w(e,t,n){if(e.element.contentWindow&&e.element.contentWindow.postMessage){var r={method:t};void 0!==n&&(r.value=n);var o=parseFloat(navigator.userAgent.toLowerCase().replace(/^.*msie (\\d+).*$/,\"$1\"));8<=o&&o<10&&(r=JSON.stringify(r)),e.element.contentWindow.postMessage(r,e.origin)}}function b(n,r){var t,e=[];if((r=g(r)).event){if(\"error\"===r.event)c(n,r.data.method).forEach(function(e){var t=new Error(r.data.message);t.name=r.data.name,e.reject(t),h(n,r.data.method,e)});e=c(n,\"event:\".concat(r.event)),t=r.data}else if(r.method){var o=function(e,t){var n=c(e,t);if(n.length<1)return!1;var r=n.shift();return h(e,t,r),r}(n,r.method);o&&(e.push(o),t=r.value)}e.forEach(function(e){try{if(\"function\"==typeof e)return void e.call(n,t);e.resolve(t)}catch(e){}})}var k=new WeakMap,E=new WeakMap,Player=function(){function Player(u){var e,c=this,n=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{};if(function(e,t){if(!(e instanceof t))throw new TypeError(\"Cannot call a class as a function\")}(this,Player),window.jQuery&&u instanceof jQuery&&(1<u.length&&window.console&&console.warn&&console.warn(\"A jQuery object with multiple elements was passed, using the first element.\"),u=u[0]),\"undefined\"!=typeof document&&\"string\"==typeof u&&(u=document.getElementById(u)),e=u,!Boolean(e&&1===e.nodeType&&\"nodeName\"in e&&e.ownerDocument&&e.ownerDocument.defaultView))throw new TypeError(\"You must pass either a valid element or a valid id.\");var r=u.ownerDocument.defaultView;if(\"IFRAME\"!==u.nodeName){var t=u.querySelector(\"iframe\");t&&(u=t)}if(\"IFRAME\"===u.nodeName&&!s(u.getAttribute(\"src\")||\"\"))throw new Error(\"The player element passed isn\u2019t a Vimeo embed.\");if(k.has(u))return k.get(u);this.element=u,this.origin=\"*\";var o=new f(function(i,a){var e=function(e){if(s(e.origin)&&c.element.contentWindow===e.source){\"*\"===c.origin&&(c.origin=e.origin);var t=g(e.data);if(t&&\"error\"===t.event&&t.data&&\"ready\"===t.data.method){var n=new Error(t.data.message);return n.name=t.data.name,void a(n)}var r=t&&\"ready\"===t.event,o=t&&\"ping\"===t.method;if(r||o)return c.element.setAttribute(\"data-ready\",\"true\"),void i();b(c,t)}};if(r.addEventListener?r.addEventListener(\"message\",e,!1):r.attachEvent&&r.attachEvent(\"onmessage\",e),\"IFRAME\"!==c.element.nodeName){var t=p(u,n);m(l(t),t,u).then(function(e){var t,n,r,o=y(e,u);return c.element=o,c._originalElement=u,t=u,n=o,r=d.get(t),d.set(n,r),d.delete(t),k.set(c.element,c),e}).catch(a)}});return E.set(this,o),k.set(this.element,this),\"IFRAME\"===this.element.nodeName&&w(this,\"ping\"),this}var e,t,n;return e=Player,(t=[{key:\"callMethod\",value:function(n){var r=this,o=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{};return new f(function(e,t){return r.ready().then(function(){u(r,n,{resolve:e,reject:t}),w(r,n,o)}).catch(t)})}},{key:\"get\",value:function(n){var r=this;return new f(function(e,t){return n=i(n,\"get\"),r.ready().then(function(){u(r,n,{resolve:e,reject:t}),w(r,n)}).catch(t)})}},{key:\"set\",value:function(n,r){var o=this;return new f(function(e,t){if(n=i(n,\"set\"),null==r)throw new TypeError(\"There must be a value to set.\");return o.ready().then(function(){u(o,n,{resolve:e,reject:t}),w(o,n,r)}).catch(t)})}},{key:\"on\",value:function(e,t){if(!e)throw new TypeError(\"You must pass an event name.\");if(!t)throw new TypeError(\"You must pass a callback function.\");if(\"function\"!=typeof t)throw new TypeError(\"The callback must be a function.\");0===c(this,\"event:\".concat(e)).length&&this.callMethod(\"addEventListener\",e).catch(function(){}),u(this,\"event:\".concat(e),t)}},{key:\"off\",value:function(e,t){if(!e)throw new TypeError(\"You must pass an event name.\");if(t&&\"function\"!=typeof t)throw new TypeError(\"The callback must be a function.\");h(this,\"event:\".concat(e),t)&&this.callMethod(\"removeEventListener\",e).catch(function(e){})}},{key:\"loadVideo\",value:function(e){return this.callMethod(\"loadVideo\",e)}},{key:\"ready\",value:function(){var e=E.get(this)||new f(function(e,t){t(new Error(\"Unknown player. Probably unloaded.\"))});return f.resolve(e)}},{key:\"addCuePoint\",value:function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{};return this.callMethod(\"addCuePoint\",{time:e,data:t})}},{key:\"removeCuePoint\",value:function(e){return this.callMethod(\"removeCuePoint\",e)}},{key:\"enableTextTrack\",value:function(e,t){if(!e)throw new TypeError(\"You must pass a language.\");return this.callMethod(\"enableTextTrack\",{language:e,kind:t})}},{key:\"disableTextTrack\",value:function(){return this.callMethod(\"disableTextTrack\")}},{key:\"pause\",value:function(){return this.callMethod(\"pause\")}},{key:\"play\",value:function(){return this.callMethod(\"play\")}},{key:\"unload\",value:function(){return this.callMethod(\"unload\")}},{key:\"destroy\",value:function(){var t=this;return new f(function(e){E.delete(t),k.delete(t.element),t._originalElement&&(k.delete(t._originalElement),t._originalElement.removeAttribute(\"data-vimeo-initialized\")),t.element&&\"IFRAME\"===t.element.nodeName&&t.element.parentNode&&t.element.parentNode.removeChild(t.element),e()})}},{key:\"getAutopause\",value:function(){return this.get(\"autopause\")}},{key:\"setAutopause\",value:function(e){return this.set(\"autopause\",e)}},{key:\"getBuffered\",value:function(){return this.get(\"buffered\")}},{key:\"getColor\",value:function(){return this.get(\"color\")}},{key:\"setColor\",value:function(e){return this.set(\"color\",e)}},{key:\"getCuePoints\",value:function(){return this.get(\"cuePoints\")}},{key:\"getCurrentTime\",value:function(){return this.get(\"currentTime\")}},{key:\"setCurrentTime\",value:function(e){return this.set(\"currentTime\",e)}},{key:\"getDuration\",value:function(){return this.get(\"duration\")}},{key:\"getEnded\",value:function(){return this.get(\"ended\")}},{key:\"getLoop\",value:function(){return this.get(\"loop\")}},{key:\"setLoop\",value:function(e){return this.set(\"loop\",e)}},{key:\"setMuted\",value:function(e){return this.set(\"muted\",e)}},{key:\"getMuted\",value:function(){return this.get(\"muted\")}},{key:\"getPaused\",value:function(){return this.get(\"paused\")}},{key:\"getPlaybackRate\",value:function(){return this.get(\"playbackRate\")}},{key:\"setPlaybackRate\",value:function(e){return this.set(\"playbackRate\",e)}},{key:\"getPlayed\",value:function(){return this.get(\"played\")}},{key:\"getSeekable\",value:function(){return this.get(\"seekable\")}},{key:\"getSeeking\",value:function(){return this.get(\"seeking\")}},{key:\"getTextTracks\",value:function(){return this.get(\"textTracks\")}},{key:\"getVideoEmbedCode\",value:function(){return this.get(\"videoEmbedCode\")}},{key:\"getVideoId\",value:function(){return this.get(\"videoId\")}},{key:\"getVideoTitle\",value:function(){return this.get(\"videoTitle\")}},{key:\"getVideoWidth\",value:function(){return this.get(\"videoWidth\")}},{key:\"getVideoHeight\",value:function(){return this.get(\"videoHeight\")}},{key:\"getVideoUrl\",value:function(){return this.get(\"videoUrl\")}},{key:\"getVolume\",value:function(){return this.get(\"volume\")}},{key:\"setVolume\",value:function(e){return this.set(\"volume\",e)}}])&&r(e.prototype,t),n&&r(e,n),Player}();return e||(function(){var e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:document,t=[].slice.call(e.querySelectorAll(\"[data-vimeo-id], [data-vimeo-url]\")),n=function(e){\"console\"in window&&console.error&&console.error(\"There was an error creating an embed: \".concat(e))};t.forEach(function(t){try{if(null!==t.getAttribute(\"data-vimeo-defer\"))return;var e=p(t);m(l(e),e,t).then(function(e){return y(e,t)}).catch(n)}catch(e){n(e)}})}(),function(){var r=0<arguments.length&&void 0!==arguments[0]?arguments[0]:document;if(!window.VimeoPlayerResizeEmbeds_){window.VimeoPlayerResizeEmbeds_=!0;var e=function(e){if(s(e.origin)&&e.data&&\"spacechange\"===e.data.event)for(var t=r.querySelectorAll(\"iframe\"),n=0;n<t.length;n++)if(t[n].contentWindow===e.source){t[n].parentElement.style.paddingBottom=\"\".concat(e.data.data[0].bottom,\"px\");break}};window.addEventListener?window.addEventListener(\"message\",e,!1):window.attachEvent&&window.attachEvent(\"onmessage\",e)}}()),Player});\n","Magento_PageBuilder/js/resource/vimeo/vimeo-wrapper.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'vimeo'\n], function (Player) {\n    'use strict';\n\n    window.Vimeo = window.Vimeo || {\n        'Player': Player\n    };\n});\n","Magento_Checkout/js/checkout-loader.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'rjsResolver'\n], function (resolver) {\n    'use strict';\n\n    /**\n     * Removes provided loader element from DOM.\n     *\n     * @param {HTMLElement} $loader - Loader DOM element.\n     */\n    function hideLoader($loader) {\n        $loader.parentNode.removeChild($loader);\n    }\n\n    /**\n     * Initializes assets loading process listener.\n     *\n     * @param {Object} config - Optional configuration\n     * @param {HTMLElement} $loader - Loader DOM element.\n     */\n    function init(config, $loader) {\n        resolver(hideLoader.bind(null, $loader));\n    }\n\n    return init;\n});\n","Magento_Checkout/js/region-updater.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/template',\n    'underscore',\n    'jquery-ui-modules/widget',\n    'mage/validation'\n], function ($, mageTemplate, _) {\n    'use strict';\n\n    $.widget('mage.regionUpdater', {\n        options: {\n            regionTemplate:\n                '<option value=\"<%- data.value %>\" <% if (data.isSelected) { %>selected=\"selected\"<% } %>>' +\n                    '<%- data.title %>' +\n                '</option>',\n            isRegionRequired: true,\n            isZipRequired: true,\n            isCountryRequired: true,\n            currentRegion: null,\n            isMultipleCountriesAllowed: true\n        },\n\n        /**\n         *\n         * @private\n         */\n        _create: function () {\n            this._initCountryElement();\n\n            this.currentRegionOption = this.options.currentRegion;\n            this.regionTmpl = mageTemplate(this.options.regionTemplate);\n\n            this._updateRegion(this.element.find('option:selected').val());\n\n            $(this.options.regionListId).on('change', $.proxy(function (e) {\n                this.setOption = false;\n                this.currentRegionOption = $(e.target).val();\n            }, this));\n\n            $(this.options.regionInputId).on('focusout', $.proxy(function () {\n                this.setOption = true;\n            }, this));\n        },\n\n        /**\n         *\n         * @private\n         */\n        _initCountryElement: function () {\n\n            if (this.options.isMultipleCountriesAllowed) {\n                this.element.parents('div.field').show();\n                this.element.on('change', $.proxy(function (e) {\n                    // clear region inputs on country change\n                    $(this.options.regionListId).val('');\n                    $(this.options.regionInputId).val('');\n                    this._updateRegion($(e.target).val());\n                }, this));\n\n                if (this.options.isCountryRequired) {\n                    this.element.addClass('required-entry');\n                    this.element.parents('div.field').addClass('required');\n                }\n            } else {\n                this.element.parents('div.field').hide();\n            }\n        },\n\n        /**\n         * Remove options from dropdown list\n         *\n         * @param {Object} selectElement - jQuery object for dropdown list\n         * @private\n         */\n        _removeSelectOptions: function (selectElement) {\n            selectElement.find('option').each(function (index) {\n                if (index) {\n                    $(this).remove();\n                }\n            });\n        },\n\n        /**\n         * Render dropdown list\n         * @param {Object} selectElement - jQuery object for dropdown list\n         * @param {String} key - region code\n         * @param {Object} value - region object\n         * @private\n         */\n        _renderSelectOption: function (selectElement, key, value) {\n            selectElement.append($.proxy(function () {\n                var name = value.name.replace(/[!\"#$%&'()*+,.\\/:;<=>?@[\\\\\\]^`{|}~]/g, '\\\\$&'),\n                    tmplData,\n                    tmpl;\n\n                if (value.code && $(name).is('span')) {\n                    key = value.code;\n                    value.name = $(name).text();\n                }\n\n                tmplData = {\n                    value: key,\n                    title: value.name,\n                    isSelected: false\n                };\n\n                if (this.options.defaultRegion === key) {\n                    tmplData.isSelected = true;\n                }\n\n                tmpl = this.regionTmpl({\n                    data: tmplData\n                });\n\n                return $(tmpl);\n            }, this));\n        },\n\n        /**\n         * Takes clearError callback function as first option\n         * If no form is passed as option, look up the closest form and call clearError method.\n         * @private\n         */\n        _clearError: function () {\n            var args = ['clearError', this.options.regionListId, this.options.regionInputId, this.options.postcodeId];\n\n            if (this.options.clearError && typeof this.options.clearError === 'function') {\n                this.options.clearError.call(this);\n            } else {\n                if (!this.options.form) {\n                    this.options.form = this.element.closest('form').length ? $(this.element.closest('form')[0]) : null;\n                }\n\n                this.options.form = $(this.options.form);\n\n                this.options.form && this.options.form.data('validator') &&\n                    this.options.form.validation.apply(this.options.form, _.compact(args));\n\n                // Clean up errors on region & zip fix\n                $(this.options.regionInputId).removeClass('mage-error').parent().find('[generated]').remove();\n                $(this.options.regionListId).removeClass('mage-error').parent().find('[generated]').remove();\n                $(this.options.postcodeId).removeClass('mage-error').parent().find('[generated]').remove();\n            }\n        },\n\n        /**\n         * Update dropdown list based on the country selected\n         *\n         * @param {String} country - 2 uppercase letter for country code\n         * @private\n         */\n        _updateRegion: function (country) {\n            // Clear validation error messages\n            var regionList = $(this.options.regionListId),\n                regionInput = $(this.options.regionInputId),\n                postcode = $(this.options.postcodeId),\n                label = regionList.parent().siblings('label'),\n                container = regionList.parents('div.field'),\n                regionsEntries,\n                regionId,\n                regionData;\n\n            this._clearError();\n            this._checkRegionRequired(country);\n\n            // Populate state/province dropdown list if available or use input box\n            if (this.options.regionJson[country]) {\n                this._removeSelectOptions(regionList);\n                regionsEntries = _.pairs(this.options.regionJson[country]);\n                regionsEntries.sort(function (a, b) {\n                    return a[1].name > b[1].name ? 1 : -1;\n                });\n                $.each(regionsEntries, $.proxy(function (key, value) {\n                    regionId = value[0];\n                    regionData = value[1];\n                    this._renderSelectOption(regionList, regionId, regionData);\n                }, this));\n\n                if (this.currentRegionOption) {\n                    regionList.val(this.currentRegionOption);\n                }\n\n                if (this.setOption) {\n                    regionList.find('option').filter(function () {\n                        return this.text === regionInput.val();\n                    }).attr('selected', true);\n                }\n\n                if (this.options.isRegionRequired) {\n                    regionList.addClass('required-entry').removeAttr('disabled');\n                    container.addClass('required').show();\n                } else {\n                    regionList.removeClass('required-entry validate-select').removeAttr('data-validate');\n                    container.removeClass('required');\n\n                    if (!this.options.optionalRegionAllowed) { //eslint-disable-line max-depth\n                        regionList.hide();\n                        container.hide();\n                    } else {\n                        regionList.removeAttr('disabled').show();\n                    }\n                }\n\n                regionList.show();\n                regionInput.hide();\n                label.attr('for', regionList.attr('id'));\n            } else {\n                this._removeSelectOptions(regionList);\n\n                if (this.options.isRegionRequired) {\n                    regionInput.addClass('required-entry').removeAttr('disabled');\n                    container.addClass('required').show();\n                } else {\n                    if (!this.options.optionalRegionAllowed) { //eslint-disable-line max-depth\n                        regionInput.attr('disabled', 'disabled');\n                        container.hide();\n                    }\n                    container.removeClass('required');\n                    regionInput.removeClass('required-entry');\n                }\n\n                regionList.removeClass('required-entry').prop('disabled', 'disabled').hide();\n                regionInput.show();\n                label.attr('for', regionInput.attr('id'));\n            }\n\n            // If country is in optionalzip list, make postcode input not required\n            if (this.options.isZipRequired) {\n                $.inArray(country, this.options.countriesWithOptionalZip) >= 0 ?\n                    postcode.removeClass('required-entry').closest('.field').removeClass('required') :\n                    postcode.addClass('required-entry').closest('.field').addClass('required');\n            }\n\n            // Add defaultvalue attribute to state/province select element\n            regionList.attr('defaultvalue', this.options.defaultRegion);\n            this.options.form.find('[type=\"submit\"]').removeAttr('disabled').show();\n        },\n\n        /**\n         * Check if the selected country has a mandatory region selection\n         *\n         * @param {String} country - Code of the country - 2 uppercase letter for country code\n         * @private\n         */\n        _checkRegionRequired: function (country) {\n            var self = this;\n\n            this.options.isRegionRequired = false;\n            $.each(this.options.regionJson.config['regions_required'], function (index, elem) {\n                if (elem === country) {\n                    self.options.isRegionRequired = true;\n                }\n            });\n        }\n    });\n\n    return $.mage.regionUpdater;\n});\n","Magento_Checkout/js/empty-cart.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['Magento_Customer/js/customer-data'], function (customerData) {\n    'use strict';\n\n    return function () {\n        var cartData = customerData.get('cart');\n\n        customerData.getInitCustomerData().done(function () {\n            if (cartData().items && cartData().items.length !== 0) {\n                customerData.reload(['cart'], false);\n            }\n        });\n    };\n});\n","Magento_Checkout/js/discount-codes.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.discountCode', {\n        options: {\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this.couponCode = $(this.options.couponCodeSelector);\n            this.removeCoupon = $(this.options.removeCouponSelector);\n\n            $(this.options.applyButton).on('click', $.proxy(function () {\n                this.couponCode.attr('data-validate', '{required:true}');\n                this.removeCoupon.attr('value', '0');\n                $(this.element).validation().trigger('submit');\n            }, this));\n\n            $(this.options.cancelButton).on('click', $.proxy(function () {\n                this.couponCode.removeAttr('data-validate');\n                this.removeCoupon.attr('value', '1');\n                this.element.trigger('submit');\n            }, this));\n        }\n    });\n\n    return $.mage.discountCode;\n});\n","Magento_Checkout/js/sidebar.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Customer/js/model/authentication-popup',\n    'Magento_Customer/js/customer-data',\n    'Magento_Ui/js/modal/alert',\n    'Magento_Ui/js/modal/confirm',\n    'underscore',\n    'jquery-ui-modules/widget',\n    'mage/decorate',\n    'mage/collapsible',\n    'mage/cookies',\n    'jquery-ui-modules/effect-fade'\n], function ($, authenticationPopup, customerData, alert, confirm, _) {\n    'use strict';\n\n    $.widget('mage.sidebar', {\n        options: {\n            isRecursive: true,\n            minicart: {\n                maxItemsVisible: 3\n            }\n        },\n        scrollHeight: 0,\n        shoppingCartUrl: window.checkout.shoppingCartUrl,\n\n        /**\n         * Create sidebar.\n         * @private\n         */\n        _create: function () {\n            this._initContent();\n        },\n\n        /**\n         * Update sidebar block.\n         */\n        update: function () {\n            $(this.options.targetElement).trigger('contentUpdated');\n            this._calcHeight();\n        },\n\n        /**\n         * @private\n         */\n        _initContent: function () {\n            var self = this,\n                events = {};\n\n            this.element.decorate('list', this.options.isRecursive);\n\n            /**\n             * @param {jQuery.Event} event\n             */\n            events['click ' + this.options.button.close] = function (event) {\n                event.stopPropagation();\n                $(self.options.targetElement).dropdownDialog('close');\n            };\n            events['click ' + this.options.button.checkout] = $.proxy(function () {\n                var cart = customerData.get('cart'),\n                    customer = customerData.get('customer'),\n                    element = $(this.options.button.checkout);\n\n                if (!customer().firstname && cart().isGuestCheckoutAllowed === false) {\n                    // set URL for redirect on successful login/registration. It's postprocessed on backend.\n                    $.cookie('login_redirect', this.options.url.checkout);\n\n                    if (this.options.url.isRedirectRequired) {\n                        element.prop('disabled', true);\n                        location.href = this.options.url.loginUrl;\n                    } else {\n                        authenticationPopup.showModal();\n                    }\n\n                    return false;\n                }\n                element.prop('disabled', true);\n                location.href = this.options.url.checkout;\n            }, this);\n\n            /**\n             * @param {jQuery.Event} event\n             */\n            events['click ' + this.options.button.remove] =  function (event) {\n                event.stopPropagation();\n                confirm({\n                    content: self.options.confirmMessage,\n                    actions: {\n                        /** @inheritdoc */\n                        confirm: function () {\n                            self._removeItem($(event.currentTarget));\n                        },\n\n                        /** @inheritdoc */\n                        always: function (e) {\n                            e.stopImmediatePropagation();\n                        }\n                    }\n                });\n            };\n\n            /**\n             * @param {jQuery.Event} event\n             */\n            events['keyup ' + this.options.item.qty] = function (event) {\n                self._showItemButton($(event.target));\n            };\n\n            /**\n             * @param {jQuery.Event} event\n             */\n            events['change ' + this.options.item.qty] = function (event) {\n                self._showItemButton($(event.target));\n            };\n\n            /**\n             * @param {jQuery.Event} event\n             */\n            events['click ' + this.options.item.button] = function (event) {\n                event.stopPropagation();\n                self._updateItemQty($(event.currentTarget));\n            };\n\n            /**\n             * @param {jQuery.Event} event\n             */\n            events['focusout ' + this.options.item.qty] = function (event) {\n                self._validateQty($(event.currentTarget));\n            };\n\n            this._on(this.element, events);\n            this._calcHeight();\n        },\n\n        /**\n         * @param {HTMLElement} elem\n         * @private\n         */\n        _showItemButton: function (elem) {\n            var itemId = elem.data('cart-item'),\n                itemQty = elem.data('item-qty');\n\n            if (this._isValidQty(itemQty, elem.val())) {\n                $('#update-cart-item-' + itemId).show('fade', 300);\n            } else if (elem.val() == 0) { //eslint-disable-line eqeqeq\n                this._hideItemButton(elem);\n            } else {\n                this._hideItemButton(elem);\n            }\n        },\n\n        /**\n         * @param {*} origin - origin qty. 'data-item-qty' attribute.\n         * @param {*} changed - new qty.\n         * @returns {Boolean}\n         * @private\n         */\n        _isValidQty: function (origin, changed) {\n            return origin != changed && //eslint-disable-line eqeqeq\n                changed.length > 0 &&\n                changed - 0 == changed && //eslint-disable-line eqeqeq\n                changed - 0 > 0;\n        },\n\n        /**\n         * @param {Object} elem\n         * @private\n         */\n        _validateQty: function (elem) {\n            var itemQty = elem.data('item-qty');\n\n            if (!this._isValidQty(itemQty, elem.val())) {\n                elem.val(itemQty);\n            }\n        },\n\n        /**\n         * @param {HTMLElement} elem\n         * @private\n         */\n        _hideItemButton: function (elem) {\n            var itemId = elem.data('cart-item');\n\n            $('#update-cart-item-' + itemId).hide('fade', 300);\n        },\n\n        /**\n         * @param {HTMLElement} elem\n         * @private\n         */\n        _updateItemQty: function (elem) {\n            var itemId = elem.data('cart-item');\n\n            this._ajax(this.options.url.update, {\n                'item_id': itemId,\n                'item_qty': $('#cart-item-' + itemId + '-qty').val()\n            }, elem, this._updateItemQtyAfter);\n        },\n\n        /**\n         * Update content after update qty\n         *\n         * @param {HTMLElement} elem\n         */\n        _updateItemQtyAfter: function (elem) {\n            var productData = this._getProductById(Number(elem.data('cart-item')));\n\n            if (!_.isUndefined(productData)) {\n                $(document).trigger('ajax:updateCartItemQty');\n\n                if (window.location.href === this.shoppingCartUrl) {\n                    window.location.reload(false);\n                }\n            }\n            this._hideItemButton(elem);\n        },\n\n        /**\n         * @param {HTMLElement} elem\n         * @private\n         */\n        _removeItem: function (elem) {\n            var itemId = elem.data('cart-item');\n\n            this._ajax(this.options.url.remove, {\n                'item_id': itemId\n            }, elem, this._removeItemAfter);\n        },\n\n        /**\n         * Update content after item remove\n         *\n         * @param {Object} elem\n         * @private\n         */\n        _removeItemAfter: function (elem) {\n            var productData = this._getProductById(Number(elem.data('cart-item')));\n\n            if (!_.isUndefined(productData)) {\n                $(document).trigger('ajax:removeFromCart', {\n                    productIds: [productData['product_id']],\n                    productInfo: [\n                        {\n                            'id': productData['product_id']\n                        }\n                    ]\n                });\n\n                if (window.location.href.indexOf(this.shoppingCartUrl) === 0) {\n                    window.location.reload();\n                }\n            }\n        },\n\n        /**\n         * Retrieves product data by Id.\n         *\n         * @param {Number} productId - product Id\n         * @returns {Object|undefined}\n         * @private\n         */\n        _getProductById: function (productId) {\n            return _.find(customerData.get('cart')().items, function (item) {\n                return productId === Number(item['item_id']);\n            });\n        },\n\n        /**\n         * @param {String} url - ajax url\n         * @param {Object} data - post data for ajax call\n         * @param {Object} elem - element that initiated the event\n         * @param {Function} callback - callback method to execute after AJAX success\n         */\n        _ajax: function (url, data, elem, callback) {\n            $.extend(data, {\n                'form_key': $.mage.cookies.get('form_key')\n            });\n\n            $.ajax({\n                url: url,\n                data: data,\n                type: 'post',\n                dataType: 'json',\n                context: this,\n\n                /** @inheritdoc */\n                beforeSend: function () {\n                    elem.attr('disabled', 'disabled');\n                },\n\n                /** @inheritdoc */\n                complete: function () {\n                    elem.attr('disabled', null);\n                }\n            })\n                .done(function (response) {\n                    var msg;\n\n                    if (response.success) {\n                        callback.call(this, elem, response);\n                    } else {\n                        msg = response['error_message'];\n\n                        if (msg) {\n                            alert({\n                                content: msg\n                            });\n                        }\n                    }\n                })\n                .fail(function (error) {\n                    console.log(JSON.stringify(error));\n                });\n        },\n\n        /**\n         * Calculate height of minicart list\n         *\n         * @private\n         */\n        _calcHeight: function () {\n            var self = this,\n                height = 0,\n                counter = this.options.minicart.maxItemsVisible,\n                target = $(this.options.minicart.list),\n                outerHeight;\n\n            self.scrollHeight = 0;\n            target.children().each(function () {\n\n                if ($(this).find('.options').length > 0) {\n                    $(this).collapsible();\n                }\n                outerHeight = $(this).outerHeight(true);\n\n                if (counter-- > 0) {\n                    height += outerHeight;\n                }\n                self.scrollHeight += outerHeight;\n            });\n\n            target.parent().height(height);\n        }\n    });\n\n    return $.mage.sidebar;\n});\n","Magento_Checkout/js/shopping-cart.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/confirm',\n    'jquery-ui-modules/widget',\n    'mage/translate'\n], function ($, confirm) {\n    'use strict';\n\n    $.widget('mage.shoppingCart', {\n        /** @inheritdoc */\n        _create: function () {\n            var items, i, reload;\n\n            $(this.options.emptyCartButton).on('click', $.proxy(function () {\n                this._confirmClearCart();\n            }, this));\n            items = $.find('[data-role=\"cart-item-qty\"]');\n\n            for (i = 0; i < items.length; i++) {\n                $(items[i]).on('keypress', $.proxy(function (event) { //eslint-disable-line no-loop-func\n                    var keyCode = event.keyCode ? event.keyCode : event.which;\n\n                    if (keyCode == 13) { //eslint-disable-line eqeqeq\n                        $(this.options.emptyCartButton).attr('name', 'update_cart_action_temp');\n                        $(this.options.updateCartActionContainer)\n                            .attr('name', 'update_cart_action').attr('value', 'update_qty');\n\n                    }\n                }, this));\n            }\n            $(this.options.continueShoppingButton).on('click', $.proxy(function () {\n                location.href = this.options.continueShoppingUrl;\n            }, this));\n\n            $(document).on('ajax:removeFromCart', $.proxy(function () {\n                reload = true;\n                $('div.block.block-minicart').on('dropdowndialogclose', $.proxy(function () {\n                    if (reload === true) {\n                        location.reload();\n                        reload = false;\n                    }\n                    $('div.block.block-minicart').off('dropdowndialogclose');\n                }));\n            }, this));\n            $(document).on('ajax:updateItemQty', $.proxy(function () {\n                reload = true;\n                $('div.block.block-minicart').on('dropdowndialogclose', $.proxy(function () {\n                    if (reload === true) {\n                        location.reload();\n                        reload = false;\n                    }\n                    $('div.block.block-minicart').off('dropdowndialogclose');\n                }));\n            }, this));\n        },\n\n        /**\n         * Display confirmation modal for clearing the cart\n         * @private\n         */\n        _confirmClearCart: function () {\n            var self = this;\n\n            confirm({\n                content: $.mage.__('Are you sure you want to remove all items from your shopping cart?'),\n                actions: {\n                    /**\n                     * Confirmation modal handler to execute clear cart action\n                     */\n                    confirm: function () {\n                        self.clearCart();\n                    }\n                }\n            });\n        },\n\n        /**\n         * Prepares the form and submit to clear the cart\n         * @public\n         */\n        clearCart: function () {\n            $(this.options.emptyCartButton).attr('name', 'update_cart_action_temp');\n            $(this.options.updateCartActionContainer)\n                .attr('name', 'update_cart_action').attr('value', 'empty_cart');\n\n            if ($(this.options.emptyCartButton).parents('form').length > 0) {\n                $(this.options.emptyCartButton).parents('form').trigger('submit');\n            }\n        }\n    });\n\n    return $.mage.shoppingCart;\n});\n","Magento_Checkout/js/proceed-to-checkout.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Customer/js/model/authentication-popup',\n    'Magento_Customer/js/customer-data'\n], function ($, authenticationPopup, customerData) {\n    'use strict';\n\n    return function (config, element) {\n        $(element).click(function (event) {\n            var cart = customerData.get('cart'),\n                customer = customerData.get('customer');\n\n            event.preventDefault();\n\n            if (!customer().firstname && cart().isGuestCheckoutAllowed === false) {\n                authenticationPopup.showModal();\n\n                return false;\n            }\n            $(element).attr('disabled', true);\n            location.href = config.checkoutUrl;\n        });\n\n    };\n});\n","Magento_Checkout/js/checkout-data.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * Checkout adapter for customer data storage\n *\n * @api\n */\ndefine([\n    'jquery',\n    'Magento_Customer/js/customer-data',\n    'mageUtils',\n    'jquery/jquery-storageapi'\n], function ($, storage, utils) {\n    'use strict';\n\n    var cacheKey = 'checkout-data',\n\n        /**\n         * @param {Object} data\n         */\n        saveData = function (data) {\n            storage.set(cacheKey, data);\n        },\n\n        /**\n         * @return {*}\n         */\n        initData = function () {\n            return {\n                'selectedShippingAddress': null, //Selected shipping address pulled from persistence storage\n                'shippingAddressFromData': null, //Shipping address pulled from persistence storage\n                'newCustomerShippingAddress': null, //Shipping address pulled from persistence storage for customer\n                'selectedShippingRate': null, //Shipping rate pulled from persistence storage\n                'selectedPaymentMethod': null, //Payment method pulled from persistence storage\n                'selectedBillingAddress': null, //Selected billing address pulled from persistence storage\n                'billingAddressFromData': null, //Billing address pulled from persistence storage\n                'newCustomerBillingAddress': null //Billing address pulled from persistence storage for new customer\n            };\n        },\n\n        /**\n         * @return {*}\n         */\n        getData = function () {\n            var data = storage.get(cacheKey)();\n\n            if ($.isEmptyObject(data)) {\n                data = $.initNamespaceStorage('mage-cache-storage').localStorage.get(cacheKey);\n\n                if ($.isEmptyObject(data)) {\n                    data = initData();\n                    saveData(data);\n                }\n            }\n\n            return data;\n        };\n\n    return {\n        /**\n         * Setting the selected shipping address pulled from persistence storage\n         *\n         * @param {Object} data\n         */\n        setSelectedShippingAddress: function (data) {\n            var obj = getData();\n\n            obj.selectedShippingAddress = data;\n            saveData(obj);\n        },\n\n        /**\n         * Pulling the selected shipping address from persistence storage\n         *\n         * @return {*}\n         */\n        getSelectedShippingAddress: function () {\n            return getData().selectedShippingAddress;\n        },\n\n        /**\n         * Setting the shipping address pulled from persistence storage\n         *\n         * @param {Object} data\n         */\n        setShippingAddressFromData: function (data) {\n            var obj = getData();\n\n            obj.shippingAddressFromData = utils.filterFormData(data);\n            saveData(obj);\n        },\n\n        /**\n         * Pulling the shipping address from persistence storage\n         *\n         * @return {*}\n         */\n        getShippingAddressFromData: function () {\n            return getData().shippingAddressFromData;\n        },\n\n        /**\n         * Setting the shipping address pulled from persistence storage for new customer\n         *\n         * @param {Object} data\n         */\n        setNewCustomerShippingAddress: function (data) {\n            var obj = getData();\n\n            obj.newCustomerShippingAddress = data;\n            saveData(obj);\n        },\n\n        /**\n         * Pulling the shipping address from persistence storage for new customer\n         *\n         * @return {*}\n         */\n        getNewCustomerShippingAddress: function () {\n            return getData().newCustomerShippingAddress;\n        },\n\n        /**\n         * Setting the selected shipping rate pulled from persistence storage\n         *\n         * @param {Object} data\n         */\n        setSelectedShippingRate: function (data) {\n            var obj = getData();\n\n            obj.selectedShippingRate = data;\n            saveData(obj);\n        },\n\n        /**\n         * Pulling the selected shipping rate from local storage\n         *\n         * @return {*}\n         */\n        getSelectedShippingRate: function () {\n            return getData().selectedShippingRate;\n        },\n\n        /**\n         * Setting the selected payment method pulled from persistence storage\n         *\n         * @param {Object} data\n         */\n        setSelectedPaymentMethod: function (data) {\n            var obj = getData();\n\n            obj.selectedPaymentMethod = data;\n            saveData(obj);\n        },\n\n        /**\n         * Pulling the payment method from persistence storage\n         *\n         * @return {*}\n         */\n        getSelectedPaymentMethod: function () {\n            return getData().selectedPaymentMethod;\n        },\n\n        /**\n         * Setting the selected billing address pulled from persistence storage\n         *\n         * @param {Object} data\n         */\n        setSelectedBillingAddress: function (data) {\n            var obj = getData();\n\n            obj.selectedBillingAddress = data;\n            saveData(obj);\n        },\n\n        /**\n         * Pulling the selected billing address from persistence storage\n         *\n         * @return {*}\n         */\n        getSelectedBillingAddress: function () {\n            return getData().selectedBillingAddress;\n        },\n\n        /**\n         * Setting the billing address pulled from persistence storage\n         *\n         * @param {Object} data\n         */\n        setBillingAddressFromData: function (data) {\n            var obj = getData();\n\n            obj.billingAddressFromData = utils.filterFormData(data);\n            saveData(obj);\n        },\n\n        /**\n         * Pulling the billing address from persistence storage\n         *\n         * @return {*}\n         */\n        getBillingAddressFromData: function () {\n            return getData().billingAddressFromData;\n        },\n\n        /**\n         * Setting the billing address pulled from persistence storage for new customer\n         *\n         * @param {Object} data\n         */\n        setNewCustomerBillingAddress: function (data) {\n            var obj = getData();\n\n            obj.newCustomerBillingAddress = data;\n            saveData(obj);\n        },\n\n        /**\n         * Pulling the billing address from persistence storage for new customer\n         *\n         * @return {*}\n         */\n        getNewCustomerBillingAddress: function () {\n            return getData().newCustomerBillingAddress;\n        },\n\n        /**\n         * Pulling the email address from persistence storage\n         *\n         * @return {*}\n         */\n        getValidatedEmailValue: function () {\n            var obj = getData();\n\n            return obj.validatedEmailValue ? obj.validatedEmailValue : '';\n        },\n\n        /**\n         * Setting the email address pulled from persistence storage\n         *\n         * @param {String} email\n         */\n        setValidatedEmailValue: function (email) {\n            var obj = getData();\n\n            obj.validatedEmailValue = email;\n            saveData(obj);\n        },\n\n        /**\n         * Pulling the email input field value from persistence storage\n         *\n         * @return {*}\n         */\n        getInputFieldEmailValue: function () {\n            var obj = getData();\n\n            return obj.inputFieldEmailValue ? obj.inputFieldEmailValue : '';\n        },\n\n        /**\n         * Setting the email input field value pulled from persistence storage\n         *\n         * @param {String} email\n         */\n        setInputFieldEmailValue: function (email) {\n            var obj = getData();\n\n            obj.inputFieldEmailValue = email;\n            saveData(obj);\n        },\n\n        /**\n         * Pulling the checked email value from persistence storage\n         *\n         * @return {*}\n         */\n        getCheckedEmailValue: function () {\n            var obj = getData();\n\n            return obj.checkedEmailValue ? obj.checkedEmailValue : '';\n        },\n\n        /**\n         * Setting the checked email value pulled from persistence storage\n         *\n         * @param {String} email\n         */\n        setCheckedEmailValue: function (email) {\n            var obj = getData();\n\n            obj.checkedEmailValue = email;\n            saveData(obj);\n        }\n    };\n});\n","Magento_Checkout/js/action/set-billing-address.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine(\n    [\n        'jquery',\n        'Magento_Checkout/js/model/quote',\n        'Magento_Checkout/js/model/url-builder',\n        'mage/storage',\n        'Magento_Checkout/js/model/error-processor',\n        'Magento_Customer/js/model/customer',\n        'Magento_Checkout/js/model/full-screen-loader',\n        'Magento_Checkout/js/action/get-payment-information'\n    ],\n    function ($,\n              quote,\n              urlBuilder,\n              storage,\n              errorProcessor,\n              customer,\n              fullScreenLoader,\n              getPaymentInformationAction\n    ) {\n        'use strict';\n\n        return function (messageContainer) {\n            var serviceUrl,\n                payload;\n\n            /**\n             * Checkout for guest and registered customer.\n             */\n            if (!customer.isLoggedIn()) {\n                serviceUrl = urlBuilder.createUrl('/guest-carts/:cartId/billing-address', {\n                    cartId: quote.getQuoteId()\n                });\n                payload = {\n                    cartId: quote.getQuoteId(),\n                    address: quote.billingAddress()\n                };\n            } else {\n                serviceUrl = urlBuilder.createUrl('/carts/mine/billing-address', {});\n                payload = {\n                    cartId: quote.getQuoteId(),\n                    address: quote.billingAddress()\n                };\n            }\n\n            fullScreenLoader.startLoader();\n\n            return storage.post(\n                serviceUrl, JSON.stringify(payload)\n            ).done(\n                function () {\n                    var deferred = $.Deferred();\n\n                    getPaymentInformationAction(deferred);\n                    $.when(deferred).done(function () {\n                        fullScreenLoader.stopLoader();\n                    });\n                }\n            ).fail(\n                function (response) {\n                    errorProcessor.process(response, messageContainer);\n                    fullScreenLoader.stopLoader();\n                }\n            );\n        };\n    }\n);\n","Magento_Checkout/js/action/set-payment-information-extended.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/url-builder',\n    'mage/storage',\n    'Magento_Checkout/js/model/error-processor',\n    'Magento_Customer/js/model/customer',\n    'Magento_Checkout/js/action/get-totals',\n    'Magento_Checkout/js/model/full-screen-loader',\n    'underscore',\n    'Magento_Checkout/js/model/payment/place-order-hooks'\n], function (quote, urlBuilder, storage, errorProcessor, customer, getTotalsAction, fullScreenLoader, _, hooks) {\n    'use strict';\n\n    /**\n     * Filter template data.\n     *\n     * @param {Object|Array} data\n     */\n    var filterTemplateData = function (data) {\n        return _.each(data, function (value, key, list) {\n            if (_.isArray(value) || _.isObject(value)) {\n                list[key] = filterTemplateData(value);\n            }\n\n            if (key === '__disableTmpl' || key === 'title') {\n                delete list[key];\n            }\n        });\n    };\n\n    return function (messageContainer, paymentData, skipBilling) {\n        var serviceUrl,\n            payload,\n            headers = {};\n\n        paymentData = filterTemplateData(paymentData);\n        skipBilling = skipBilling || false;\n        payload = {\n            cartId: quote.getQuoteId(),\n            paymentMethod: paymentData\n        };\n\n        /**\n         * Checkout for guest and registered customer.\n         */\n        if (!customer.isLoggedIn()) {\n            serviceUrl = urlBuilder.createUrl('/guest-carts/:cartId/set-payment-information', {\n                cartId: quote.getQuoteId()\n            });\n            payload.email = quote.guestEmail;\n        } else {\n            serviceUrl = urlBuilder.createUrl('/carts/mine/set-payment-information', {});\n        }\n\n        if (skipBilling === false) {\n            payload.billingAddress = quote.billingAddress();\n        }\n\n        fullScreenLoader.startLoader();\n\n        _.each(hooks.requestModifiers, function (modifier) {\n            modifier(headers, payload);\n        });\n\n        return storage.post(\n            serviceUrl, JSON.stringify(payload), true, 'application/json', headers\n        ).fail(\n            function (response) {\n                errorProcessor.process(response, messageContainer);\n            }\n        ).always(\n            function () {\n                fullScreenLoader.stopLoader();\n                _.each(hooks.afterRequestListeners, function (listener) {\n                    listener();\n                });\n            }\n        );\n    };\n});\n","Magento_Checkout/js/action/place-order.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/url-builder',\n    'Magento_Customer/js/model/customer',\n    'Magento_Checkout/js/model/place-order'\n], function (quote, urlBuilder, customer, placeOrderService) {\n    'use strict';\n\n    return function (paymentData, messageContainer) {\n        var serviceUrl, payload;\n\n        payload = {\n            cartId: quote.getQuoteId(),\n            billingAddress: quote.billingAddress(),\n            paymentMethod: paymentData\n        };\n\n        if (customer.isLoggedIn()) {\n            serviceUrl = urlBuilder.createUrl('/carts/mine/payment-information', {});\n        } else {\n            serviceUrl = urlBuilder.createUrl('/guest-carts/:quoteId/payment-information', {\n                quoteId: quote.getQuoteId()\n            });\n            payload.email = quote.guestEmail;\n        }\n\n        return placeOrderService(serviceUrl, payload, messageContainer);\n    };\n});\n","Magento_Checkout/js/action/get-totals.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    '../model/quote',\n    'Magento_Checkout/js/model/resource-url-manager',\n    'Magento_Checkout/js/model/error-processor',\n    'mage/storage',\n    'Magento_Checkout/js/model/totals'\n], function ($, quote, resourceUrlManager, errorProcessor, storage, totals) {\n    'use strict';\n\n    return function (callbacks, deferred) {\n        deferred = deferred || $.Deferred();\n        totals.isLoading(true);\n\n        return storage.get(\n            resourceUrlManager.getUrlForCartTotals(quote),\n            false\n        ).done(function (response) {\n            var proceed = true;\n\n            totals.isLoading(false);\n\n            if (callbacks.length > 0) {\n                $.each(callbacks, function (index, callback) {\n                    proceed = proceed && callback();\n                });\n            }\n\n            if (proceed) {\n                quote.setTotals(response);\n                deferred.resolve();\n            }\n        }).fail(function (response) {\n            totals.isLoading(false);\n            deferred.reject();\n            errorProcessor.process(response);\n        }).always(function () {\n            totals.isLoading(false);\n        });\n    };\n});\n","Magento_Checkout/js/action/get-payment-information.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/url-builder',\n    'mage/storage',\n    'Magento_Checkout/js/model/error-processor',\n    'Magento_Customer/js/model/customer',\n    'Magento_Checkout/js/model/payment/method-converter',\n    'Magento_Checkout/js/model/payment-service'\n], function ($, quote, urlBuilder, storage, errorProcessor, customer, methodConverter, paymentService) {\n    'use strict';\n\n    return function (deferred, messageContainer) {\n        var serviceUrl;\n\n        deferred = deferred || $.Deferred();\n\n        /**\n         * Checkout for guest and registered customer.\n         */\n        if (!customer.isLoggedIn()) {\n            serviceUrl = urlBuilder.createUrl('/guest-carts/:cartId/payment-information', {\n                cartId: quote.getQuoteId()\n            });\n        } else {\n            serviceUrl = urlBuilder.createUrl('/carts/mine/payment-information', {});\n        }\n\n        return storage.get(\n            serviceUrl, false\n        ).done(function (response) {\n            quote.setTotals(response.totals);\n            paymentService.setPaymentMethods(methodConverter(response['payment_methods']));\n            deferred.resolve();\n        }).fail(function (response) {\n            errorProcessor.process(response, messageContainer);\n            deferred.reject();\n        });\n    };\n});\n","Magento_Checkout/js/action/update-shopping-cart.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/modal/alert',\n    'jquery',\n    'jquery-ui-modules/widget',\n    'mage/validation'\n], function (alert, $) {\n    'use strict';\n\n    $.widget('mage.updateShoppingCart', {\n        options: {\n            validationURL: '',\n            eventName: 'updateCartItemQty',\n            updateCartActionContainer: ''\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this._on(this.element, {\n                'submit': this.onSubmit\n            });\n        },\n\n        /**\n         * Prevents default submit action and calls form validator.\n         *\n         * @param {Event} event\n         * @return {Boolean}\n         */\n        onSubmit: function (event) {\n            var action = this.element.find(this.options.updateCartActionContainer).val();\n\n            if (!this.options.validationURL || action === 'empty_cart') {\n                return true;\n            }\n\n            if (this.isValid()) {\n                event.preventDefault();\n                this.validateItems(this.options.validationURL, this.element.serialize());\n            }\n\n            return false;\n        },\n\n        /**\n         * Validates requested form.\n         *\n         * @return {Boolean}\n         */\n        isValid: function () {\n            return this.element.validation() && this.element.validation('isValid');\n        },\n\n        /**\n         * Validates updated shopping cart data.\n         *\n         * @param {String} url - request url\n         * @param {Object} data - post data for ajax call\n         */\n        validateItems: function (url, data) {\n            $.extend(data, {\n                'form_key': $.mage.cookies.get('form_key')\n            });\n\n            $.ajax({\n                url: url,\n                data: data,\n                type: 'post',\n                dataType: 'json',\n                context: this,\n\n                /** @inheritdoc */\n                beforeSend: function () {\n                    $(document.body).trigger('processStart');\n                },\n\n                /** @inheritdoc */\n                complete: function () {\n                    $(document.body).trigger('processStop');\n                }\n            })\n            .done(function (response) {\n                if (response.success) {\n                    this.onSuccess();\n                } else {\n                    this.onError(response);\n                }\n            })\n            .fail(function () {\n                this.submitForm();\n            });\n        },\n\n        /**\n         * Form validation succeed.\n         */\n        onSuccess: function () {\n            $(document).trigger('ajax:' + this.options.eventName);\n            this.submitForm();\n        },\n\n        /**\n         * Form validation failed.\n         */\n        onError: function (response) {\n            if (response['error_message']) {\n                alert({\n                    content: response['error_message']\n                });\n            } else {\n                this.submitForm();\n            }\n        },\n\n        /**\n         * Real submit of validated form.\n         */\n        submitForm: function () {\n            this.element\n                .off('submit', this.onSubmit)\n                .on('submit', function () {\n                    $(document.body).trigger('processStart');\n                })\n                .trigger('submit');\n        }\n    });\n\n    return $.mage.updateShoppingCart;\n});\n","Magento_Checkout/js/action/select-billing-address.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    '../model/quote'\n], function ($, quote) {\n    'use strict';\n\n    return function (billingAddress) {\n        var address = null;\n\n        if (quote.shippingAddress() && billingAddress.getCacheKey() == //eslint-disable-line eqeqeq\n            quote.shippingAddress().getCacheKey()\n        ) {\n            address = $.extend(true, {}, billingAddress);\n            address.saveInAddressBook = null;\n        } else {\n            address = billingAddress;\n        }\n        quote.billingAddress(address);\n    };\n});\n","Magento_Checkout/js/action/recollect-shipping-rates.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/action/select-shipping-address',\n    'Magento_Checkout/js/model/shipping-rate-registry'\n], function (quote, selectShippingAddress, rateRegistry) {\n    'use strict';\n\n    return function () {\n        var shippingAddress = null;\n\n        if (!quote.isVirtual()) {\n            shippingAddress = quote.shippingAddress();\n\n            rateRegistry.set(shippingAddress.getCacheKey(), null);\n            selectShippingAddress(shippingAddress);\n        }\n    };\n});\n","Magento_Checkout/js/action/set-payment-information.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Checkout/js/action/set-payment-information-extended'\n\n], function (setPaymentInformationExtended) {\n    'use strict';\n\n    return function (messageContainer, paymentData) {\n\n        return setPaymentInformationExtended(messageContainer, paymentData, false);\n    };\n});\n","Magento_Checkout/js/action/select-payment-method.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Checkout/js/model/quote'\n], function (quote) {\n    'use strict';\n\n    return function (paymentMethod) {\n        if (paymentMethod) {\n            paymentMethod.__disableTmpl = {\n                title: true\n            };\n        }\n        quote.paymentMethod(paymentMethod);\n    };\n});\n","Magento_Checkout/js/action/select-shipping-address.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Checkout/js/model/quote'\n], function (quote) {\n    'use strict';\n\n    return function (shippingAddress) {\n        quote.shippingAddress(shippingAddress);\n    };\n});\n","Magento_Checkout/js/action/select-shipping-method.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    '../model/quote'\n], function (quote) {\n    'use strict';\n\n    return function (shippingMethod) {\n        quote.shippingMethod(shippingMethod);\n    };\n});\n","Magento_Checkout/js/action/create-billing-address.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Checkout/js/model/address-converter'\n], function (addressConverter) {\n    'use strict';\n\n    return function (addressData) {\n        var address = addressConverter.formAddressDataToQuoteAddress(addressData);\n\n        /**\n         * Returns new customer billing address type.\n         *\n         * @returns {String}\n         */\n        address.getType = function () {\n            return 'new-customer-billing-address';\n        };\n\n        return address;\n    };\n});\n","Magento_Checkout/js/action/redirect-on-success.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine(\n    [\n        'mage/url',\n        'Magento_Checkout/js/model/full-screen-loader'\n    ],\n    function (url, fullScreenLoader) {\n        'use strict';\n\n        return {\n            redirectUrl: window.checkoutConfig.defaultSuccessPageUrl,\n\n            /**\n             * Provide redirect to page\n             */\n            execute: function () {\n                fullScreenLoader.startLoader();\n                window.location.replace(url.build(this.redirectUrl));\n            }\n        };\n    }\n);\n","Magento_Checkout/js/action/create-shipping-address.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Customer/js/model/address-list',\n    'Magento_Checkout/js/model/address-converter'\n], function (addressList, addressConverter) {\n    'use strict';\n\n    return function (addressData) {\n        var address = addressConverter.formAddressDataToQuoteAddress(addressData),\n            isAddressUpdated = addressList().some(function (currentAddress, index, addresses) {\n                if (currentAddress.getKey() == address.getKey()) { //eslint-disable-line eqeqeq\n                    addresses[index] = address;\n\n                    return true;\n                }\n\n                return false;\n            });\n\n        if (!isAddressUpdated) {\n            addressList.push(address);\n        } else {\n            addressList.valueHasMutated();\n        }\n\n        return address;\n    };\n});\n","Magento_Checkout/js/action/set-shipping-information.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    '../model/quote',\n    'Magento_Checkout/js/model/shipping-save-processor'\n], function (quote, shippingSaveProcessor) {\n    'use strict';\n\n    return function () {\n        return shippingSaveProcessor.saveShippingInformation(quote.shippingAddress().getType());\n    };\n});\n","Magento_Checkout/js/model/payment-service.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/payment/method-list',\n    'Magento_Checkout/js/action/select-payment-method'\n], function (_, quote, methodList, selectPaymentMethod) {\n    'use strict';\n\n    /**\n    * Free method filter\n    * @param {Object} paymentMethod\n    * @return {Boolean}\n    */\n    var isFreePaymentMethod = function (paymentMethod) {\n            return paymentMethod.method === 'free';\n        },\n\n        /**\n         * Grabs the grand total from quote\n         * @return {Number}\n         */\n        getGrandTotal = function () {\n            return quote.totals()['grand_total'];\n        };\n\n    return {\n        isFreeAvailable: false,\n\n        /**\n         * Populate the list of payment methods\n         * @param {Array} methods\n         */\n        setPaymentMethods: function (methods) {\n            var freeMethod,\n                filteredMethods,\n                methodIsAvailable,\n                methodNames;\n\n            freeMethod = _.find(methods, isFreePaymentMethod);\n            this.isFreeAvailable = !!freeMethod;\n\n            if (freeMethod && getGrandTotal() <= 0) {\n                methods.splice(0, methods.length, freeMethod);\n                selectPaymentMethod(freeMethod);\n            }\n\n            filteredMethods = _.without(methods, freeMethod);\n\n            if (filteredMethods.length === 1) {\n                selectPaymentMethod(filteredMethods[0]);\n            } else if (quote.paymentMethod()) {\n                methodIsAvailable = methods.some(function (item) {\n                    return item.method === quote.paymentMethod().method;\n                });\n                //Unset selected payment method if not available\n                if (!methodIsAvailable) {\n                    selectPaymentMethod(null);\n                }\n            }\n\n            /**\n             * Overwrite methods with existing methods to preserve ko array references.\n             * This prevent ko from re-rendering those methods.\n             */\n            methodNames = _.pluck(methods, 'method');\n            _.map(methodList(), function (existingMethod) {\n                var existingMethodIndex = methodNames.indexOf(existingMethod.method);\n\n                if (existingMethodIndex !== -1) {\n                    methods[existingMethodIndex] = existingMethod;\n                }\n            });\n\n            methodList(methods);\n        },\n\n        /**\n         * Get the list of available payment methods.\n         * @return {Array}\n         */\n        getAvailablePaymentMethods: function () {\n            var allMethods = methodList().slice(),\n                grandTotalOverZero = getGrandTotal() > 0;\n\n            if (!this.isFreeAvailable) {\n                return allMethods;\n            }\n\n            if (grandTotalOverZero) {\n                return _.reject(allMethods, isFreePaymentMethod);\n            }\n\n            return _.filter(allMethods, isFreePaymentMethod);\n        }\n    };\n});\n","Magento_Checkout/js/model/shipping-service.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'Magento_Checkout/js/model/checkout-data-resolver'\n], function (ko, checkoutDataResolver) {\n    'use strict';\n\n    var shippingRates = ko.observableArray([]);\n\n    return {\n        isLoading: ko.observable(false),\n\n        /**\n         * Set shipping rates\n         *\n         * @param {*} ratesData\n         */\n        setShippingRates: function (ratesData) {\n            shippingRates(ratesData);\n            shippingRates.valueHasMutated();\n            checkoutDataResolver.resolveShippingRates(ratesData);\n        },\n\n        /**\n         * Get shipping rates\n         *\n         * @returns {*}\n         */\n        getShippingRates: function () {\n            return shippingRates;\n        }\n    };\n});\n","Magento_Checkout/js/model/checkout-data-resolver.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * Checkout adapter for customer data storage\n */\ndefine([\n    'Magento_Customer/js/model/address-list',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/checkout-data',\n    'Magento_Checkout/js/action/create-shipping-address',\n    'Magento_Checkout/js/action/select-shipping-address',\n    'Magento_Checkout/js/action/select-shipping-method',\n    'Magento_Checkout/js/model/payment-service',\n    'Magento_Checkout/js/action/select-payment-method',\n    'Magento_Checkout/js/model/address-converter',\n    'Magento_Checkout/js/action/select-billing-address',\n    'Magento_Checkout/js/action/create-billing-address',\n    'underscore'\n], function (\n    addressList,\n    quote,\n    checkoutData,\n    createShippingAddress,\n    selectShippingAddress,\n    selectShippingMethodAction,\n    paymentService,\n    selectPaymentMethodAction,\n    addressConverter,\n    selectBillingAddress,\n    createBillingAddress,\n    _\n) {\n    'use strict';\n\n    var isBillingAddressResolvedFromBackend = false;\n\n    return {\n\n        /**\n         * Resolve estimation address. Used local storage\n         */\n        resolveEstimationAddress: function () {\n            var address;\n\n            if (checkoutData.getShippingAddressFromData()) {\n                address = addressConverter.formAddressDataToQuoteAddress(checkoutData.getShippingAddressFromData());\n                selectShippingAddress(address);\n            } else {\n                this.resolveShippingAddress();\n            }\n\n            if (quote.isVirtual()) {\n                if (checkoutData.getBillingAddressFromData()) {\n                    address = addressConverter.formAddressDataToQuoteAddress(\n                        checkoutData.getBillingAddressFromData()\n                    );\n                    selectBillingAddress(address);\n                } else {\n                    this.resolveBillingAddress();\n                }\n            }\n        },\n\n        /**\n         * Resolve shipping address. Used local storage\n         */\n        resolveShippingAddress: function () {\n            var newCustomerShippingAddress;\n\n            if (!checkoutData.getShippingAddressFromData() &&\n                window.checkoutConfig.shippingAddressFromData\n            ) {\n                checkoutData.setShippingAddressFromData(window.checkoutConfig.shippingAddressFromData);\n            }\n\n            newCustomerShippingAddress = checkoutData.getNewCustomerShippingAddress();\n\n            if (newCustomerShippingAddress) {\n                createShippingAddress(newCustomerShippingAddress);\n            }\n            this.applyShippingAddress();\n        },\n\n        /**\n         * Apply resolved estimated address to quote\n         *\n         * @param {Object} isEstimatedAddress\n         */\n        applyShippingAddress: function (isEstimatedAddress) {\n            var address,\n                shippingAddress,\n                isConvertAddress;\n\n            if (addressList().length === 0) {\n                address = addressConverter.formAddressDataToQuoteAddress(\n                    checkoutData.getShippingAddressFromData()\n                );\n                selectShippingAddress(address);\n            }\n            shippingAddress = quote.shippingAddress();\n            isConvertAddress = isEstimatedAddress || false;\n\n            if (!shippingAddress) {\n                shippingAddress = this.getShippingAddressFromCustomerAddressList();\n\n                if (shippingAddress) {\n                    selectShippingAddress(\n                        isConvertAddress ?\n                            addressConverter.addressToEstimationAddress(shippingAddress)\n                            : shippingAddress\n                    );\n                }\n            }\n        },\n\n        /**\n         * @param {Object} ratesData\n         */\n        resolveShippingRates: function (ratesData) {\n            var selectedShippingRate = checkoutData.getSelectedShippingRate(),\n                availableRate = false;\n\n            if (ratesData.length === 1 && !quote.shippingMethod()) {\n                //set shipping rate if we have only one available shipping rate\n                selectShippingMethodAction(ratesData[0]);\n\n                return;\n            }\n\n            if (quote.shippingMethod()) {\n                availableRate = _.find(ratesData, function (rate) {\n                    return rate['carrier_code'] == quote.shippingMethod()['carrier_code'] && //eslint-disable-line\n                        rate['method_code'] == quote.shippingMethod()['method_code']; //eslint-disable-line eqeqeq\n                });\n            }\n\n            if (!availableRate && selectedShippingRate) {\n                availableRate = _.find(ratesData, function (rate) {\n                    return rate['carrier_code'] + '_' + rate['method_code'] === selectedShippingRate;\n                });\n            }\n\n            if (!availableRate && window.checkoutConfig.selectedShippingMethod) {\n                availableRate = _.find(ratesData, function (rate) {\n                    var selectedShippingMethod = window.checkoutConfig.selectedShippingMethod;\n\n                    return rate['carrier_code'] == selectedShippingMethod['carrier_code'] && //eslint-disable-line\n                        rate['method_code'] == selectedShippingMethod['method_code']; //eslint-disable-line eqeqeq\n                });\n            }\n\n            //Unset selected shipping method if not available\n            if (!availableRate) {\n                selectShippingMethodAction(null);\n            } else {\n                selectShippingMethodAction(availableRate);\n            }\n        },\n\n        /**\n         * Resolve payment method. Used local storage\n         */\n        resolvePaymentMethod: function () {\n            var availablePaymentMethods = paymentService.getAvailablePaymentMethods(),\n                selectedPaymentMethod = checkoutData.getSelectedPaymentMethod();\n\n            if (selectedPaymentMethod) {\n                availablePaymentMethods.some(function (payment) {\n                    if (payment.method == selectedPaymentMethod) { //eslint-disable-line eqeqeq\n                        selectPaymentMethodAction(payment);\n                    }\n                });\n            }\n        },\n\n        /**\n         * Resolve billing address. Used local storage\n         */\n        resolveBillingAddress: function () {\n            var selectedBillingAddress,\n                newCustomerBillingAddressData;\n\n            selectedBillingAddress = checkoutData.getSelectedBillingAddress();\n            newCustomerBillingAddressData = checkoutData.getNewCustomerBillingAddress();\n\n            if (selectedBillingAddress) {\n                if (selectedBillingAddress === 'new-customer-billing-address' && newCustomerBillingAddressData) {\n                    selectBillingAddress(createBillingAddress(newCustomerBillingAddressData));\n                } else {\n                    addressList.some(function (address) {\n                        if (selectedBillingAddress === address.getKey()) {\n                            selectBillingAddress(address);\n                        }\n                    });\n                }\n            } else {\n                this.applyBillingAddress();\n            }\n\n            if (!isBillingAddressResolvedFromBackend &&\n                !checkoutData.getBillingAddressFromData() &&\n                !_.isEmpty(window.checkoutConfig.billingAddressFromData) &&\n                !quote.billingAddress()\n            ) {\n                if (window.checkoutConfig.isBillingAddressFromDataValid === true) {\n                    selectBillingAddress(createBillingAddress(window.checkoutConfig.billingAddressFromData));\n                } else {\n                    checkoutData.setBillingAddressFromData(window.checkoutConfig.billingAddressFromData);\n                }\n                isBillingAddressResolvedFromBackend = true;\n            }\n        },\n\n        /**\n         * Apply resolved billing address to quote\n         */\n        applyBillingAddress: function () {\n            var shippingAddress,\n                isBillingAddressInitialized;\n\n            if (quote.billingAddress()) {\n                selectBillingAddress(quote.billingAddress());\n\n                return;\n            }\n\n            if (quote.isVirtual() || !quote.billingAddress()) {\n                isBillingAddressInitialized = addressList.some(function (addrs) {\n                    if (addrs.isDefaultBilling()) {\n                        selectBillingAddress(addrs);\n\n                        return true;\n                    }\n\n                    return false;\n                });\n            }\n\n            shippingAddress = quote.shippingAddress();\n\n            if (!isBillingAddressInitialized &&\n                shippingAddress &&\n                shippingAddress.canUseForBilling() &&\n                (shippingAddress.isDefaultShipping() || !quote.isVirtual())\n            ) {\n                //set billing address same as shipping by default if it is not empty\n                selectBillingAddress(quote.shippingAddress());\n            }\n        },\n\n        /**\n         * Get shipping address from address list\n         *\n         * @return {Object|null}\n         */\n        getShippingAddressFromCustomerAddressList: function () {\n            var shippingAddress = _.find(\n                    addressList(),\n                    function (address) {\n                        return checkoutData.getSelectedShippingAddress() == address.getKey() //eslint-disable-line\n                    }\n                );\n\n            if (!shippingAddress) {\n                shippingAddress = _.find(\n                    addressList(),\n                    function (address) {\n                        return address.isDefaultShipping();\n                    }\n                );\n            }\n\n            if (!shippingAddress && addressList().length === 1) {\n                shippingAddress = addressList()[0];\n            }\n\n            return shippingAddress;\n        }\n    };\n});\n","Magento_Checkout/js/model/quote.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/**\n * @api\n */\ndefine([\n    'ko',\n    'underscore',\n    'domReady!'\n], function (ko, _) {\n    'use strict';\n\n    /**\n     * Get totals data from the extension attributes.\n     * @param {*} data\n     * @returns {*}\n     */\n    var proceedTotalsData = function (data) {\n            if (_.isObject(data) && _.isObject(data['extension_attributes'])) {\n                _.each(data['extension_attributes'], function (element, index) {\n                    data[index] = element;\n                });\n            }\n\n            return data;\n        },\n        billingAddress = ko.observable(null),\n        shippingAddress = ko.observable(null),\n        shippingMethod = ko.observable(null),\n        paymentMethod = ko.observable(null),\n        quoteData = window.checkoutConfig.quoteData,\n        basePriceFormat = window.checkoutConfig.basePriceFormat,\n        priceFormat = window.checkoutConfig.priceFormat,\n        storeCode = window.checkoutConfig.storeCode,\n        totalsData = proceedTotalsData(window.checkoutConfig.totalsData),\n        totals = ko.observable(totalsData),\n        collectedTotals = ko.observable({});\n\n    return {\n        totals: totals,\n        shippingAddress: shippingAddress,\n        shippingMethod: shippingMethod,\n        billingAddress: billingAddress,\n        paymentMethod: paymentMethod,\n        guestEmail: null,\n\n        /**\n         * @return {*}\n         */\n        getQuoteId: function () {\n            return quoteData['entity_id'];\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isVirtual: function () {\n            return !!Number(quoteData['is_virtual']);\n        },\n\n        /**\n         * @return {*}\n         */\n        getPriceFormat: function () {\n            return priceFormat;\n        },\n\n        /**\n         * @return {*}\n         */\n        getBasePriceFormat: function () {\n            return basePriceFormat;\n        },\n\n        /**\n         * @return {*}\n         */\n        getItems: function () {\n            return window.checkoutConfig.quoteItemData;\n        },\n\n        /**\n         *\n         * @return {*}\n         */\n        getTotals: function () {\n            return totals;\n        },\n\n        /**\n         * @param {Object} data\n         */\n        setTotals: function (data) {\n            data = proceedTotalsData(data);\n            totals(data);\n            this.setCollectedTotals('subtotal_with_discount', parseFloat(data['subtotal_with_discount']));\n        },\n\n        /**\n         * @param {*} paymentMethodCode\n         */\n        setPaymentMethod: function (paymentMethodCode) {\n            paymentMethod(paymentMethodCode);\n        },\n\n        /**\n         * @return {*}\n         */\n        getPaymentMethod: function () {\n            return paymentMethod;\n        },\n\n        /**\n         * @return {*}\n         */\n        getStoreCode: function () {\n            return storeCode;\n        },\n\n        /**\n         * @param {String} code\n         * @param {*} value\n         */\n        setCollectedTotals: function (code, value) {\n            var colTotals = collectedTotals();\n\n            colTotals[code] = value;\n            collectedTotals(colTotals);\n        },\n\n        /**\n         * @return {Number}\n         */\n        getCalculatedTotal: function () {\n            var total = 0.; //eslint-disable-line no-floating-decimal\n\n            _.each(collectedTotals(), function (value) {\n                total += value;\n            });\n\n            return total;\n        }\n    };\n});\n","Magento_Checkout/js/model/shipping-rate-service.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/shipping-rate-processor/new-address',\n    'Magento_Checkout/js/model/shipping-rate-processor/customer-address'\n], function (quote, defaultProcessor, customerAddressProcessor) {\n    'use strict';\n\n    var processors = {};\n\n    processors.default =  defaultProcessor;\n    processors['customer-address'] = customerAddressProcessor;\n\n    quote.shippingAddress.subscribe(function () {\n        var type = quote.shippingAddress().getType();\n\n        if (processors[type]) {\n            processors[type].getRates(quote.shippingAddress());\n        } else {\n            processors.default.getRates(quote.shippingAddress());\n        }\n    });\n\n    return {\n        /**\n         * @param {String} type\n         * @param {*} processor\n         */\n        registerProcessor: function (type, processor) {\n            processors[type] = processor;\n        }\n    };\n});\n","Magento_Checkout/js/model/customer-email-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Customer/js/model/customer',\n    'mage/validation'\n], function ($, customer) {\n    'use strict';\n\n    return {\n        /**\n         * Validate checkout agreements\n         *\n         * @returns {Boolean}\n         */\n        validate: function () {\n            var emailValidationResult = customer.isLoggedIn(),\n                loginFormSelector = 'form[data-role=email-with-possible-login]';\n\n            if (!customer.isLoggedIn()) {\n                $(loginFormSelector).validation();\n                emailValidationResult = Boolean($(loginFormSelector + ' input[name=username]').valid());\n            }\n\n            return emailValidationResult;\n        }\n    };\n});\n","Magento_Checkout/js/model/place-order.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/**\n * @api\n */\ndefine(\n    [\n        'mage/storage',\n        'Magento_Checkout/js/model/error-processor',\n        'Magento_Checkout/js/model/full-screen-loader',\n        'Magento_Customer/js/customer-data',\n        'Magento_Checkout/js/model/payment/place-order-hooks',\n        'underscore'\n    ],\n    function (storage, errorProcessor, fullScreenLoader, customerData, hooks, _) {\n        'use strict';\n\n        return function (serviceUrl, payload, messageContainer) {\n            var headers = {};\n\n            fullScreenLoader.startLoader();\n            _.each(hooks.requestModifiers, function (modifier) {\n                modifier(headers, payload);\n            });\n\n            return storage.post(\n                serviceUrl, JSON.stringify(payload), true, 'application/json', headers\n            ).fail(\n                function (response) {\n                    errorProcessor.process(response, messageContainer);\n                }\n            ).done(\n                function (response) {\n                    var clearData = {\n                        'selectedShippingAddress': null,\n                        'shippingAddressFromData': null,\n                        'newCustomerShippingAddress': null,\n                        'selectedShippingRate': null,\n                        'selectedPaymentMethod': null,\n                        'selectedBillingAddress': null,\n                        'billingAddressFromData': null,\n                        'newCustomerBillingAddress': null\n                    };\n\n                    if (response.responseType !== 'error') {\n                        customerData.set('checkout-data', clearData);\n                    }\n                }\n            ).always(\n                function () {\n                    fullScreenLoader.stopLoader();\n                    _.each(hooks.afterRequestListeners, function (listener) {\n                        listener();\n                    });\n                }\n            );\n        };\n    }\n);\n","Magento_Checkout/js/model/error-processor.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'mage/url',\n    'Magento_Ui/js/model/messageList',\n    'mage/translate'\n], function (url, globalMessageList, $t) {\n    'use strict';\n\n    return {\n        /**\n         * @param {Object} response\n         * @param {Object} messageContainer\n         */\n        process: function (response, messageContainer) {\n            var error;\n\n            messageContainer = messageContainer || globalMessageList;\n\n            if (response.status == 401) { //eslint-disable-line eqeqeq\n                window.location.replace(url.build('customer/account/login/'));\n            } else {\n                try {\n                    error = JSON.parse(response.responseText);\n                } catch (exception) {\n                    error = {\n                        message: $t('Something went wrong with your request. Please try again later.')\n                    };\n                }\n                messageContainer.addErrorMessage(error);\n            }\n        }\n    };\n});\n","Magento_Checkout/js/model/address-converter.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'Magento_Checkout/js/model/new-customer-address',\n    'Magento_Customer/js/customer-data',\n    'mage/utils/objects',\n    'underscore'\n], function ($, address, customerData, mageUtils, _) {\n    'use strict';\n\n    var countryData = customerData.get('directory-data');\n\n    return {\n        /**\n         * Convert address form data to Address object\n         *\n         * @param {Object} formData\n         * @returns {Object}\n         */\n        formAddressDataToQuoteAddress: function (formData) {\n            // clone address form data to new object\n            var addressData = $.extend(true, {}, formData),\n                region,\n                regionName = addressData.region,\n                customAttributes;\n\n            if (mageUtils.isObject(addressData.street)) {\n                addressData.street = this.objectToArray(addressData.street);\n            }\n\n            addressData.region = {\n                'region_id': addressData['region_id'],\n                'region_code': addressData['region_code'],\n                region: regionName\n            };\n\n            if (addressData['region_id'] &&\n                countryData()[addressData['country_id']] &&\n                countryData()[addressData['country_id']].regions\n            ) {\n                region = countryData()[addressData['country_id']].regions[addressData['region_id']];\n\n                if (region) {\n                    addressData.region['region_id'] = addressData['region_id'];\n                    addressData.region['region_code'] = region.code;\n                    addressData.region.region = region.name;\n                }\n            } else if (\n                !addressData['region_id'] &&\n                countryData()[addressData['country_id']] &&\n                countryData()[addressData['country_id']].regions\n            ) {\n                addressData.region['region_code'] = '';\n                addressData.region.region = '';\n            }\n            delete addressData['region_id'];\n\n            if (addressData['custom_attributes']) {\n                addressData['custom_attributes'] = _.map(\n                    addressData['custom_attributes'],\n                    function (value, key) {\n                        customAttributes = {\n                            'attribute_code': key,\n                            'value': value\n                        };\n\n                        if (typeof value === 'boolean') {\n                            customAttributes = {\n                                'attribute_code': key,\n                                'value': value,\n                                'label': value === true ? 'Yes' : 'No'\n                            };\n                        }\n\n                        return customAttributes;\n                    }\n                );\n            }\n\n            return address(addressData);\n        },\n\n        /**\n         * Convert Address object to address form data.\n         *\n         * @param {Object} addrs\n         * @returns {Object}\n         */\n        quoteAddressToFormAddressData: function (addrs) {\n            var self = this,\n                output = {},\n                streetObject,\n                customAttributesObject;\n\n            $.each(addrs, function (key) {\n                if (addrs.hasOwnProperty(key) && !$.isFunction(addrs[key])) {\n                    output[self.toUnderscore(key)] = addrs[key];\n                }\n            });\n\n            if ($.isArray(addrs.street)) {\n                streetObject = {};\n                addrs.street.forEach(function (value, index) {\n                    streetObject[index] = value;\n                });\n                output.street = streetObject;\n            }\n\n            //jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n            if ($.isArray(addrs.customAttributes)) {\n                customAttributesObject = {};\n                addrs.customAttributes.forEach(function (value) {\n                    customAttributesObject[value.attribute_code] = value.value;\n                });\n                output.custom_attributes = customAttributesObject;\n            }\n            //jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n\n            return output;\n        },\n\n        /**\n         * @param {String} string\n         */\n        toUnderscore: function (string) {\n            return string.replace(/([A-Z])/g, function ($1) {\n                return '_' + $1.toLowerCase();\n            });\n        },\n\n        /**\n         * @param {Object} formProviderData\n         * @param {String} formIndex\n         * @return {Object}\n         */\n        formDataProviderToFlatData: function (formProviderData, formIndex) {\n            var addressData = {};\n\n            $.each(formProviderData, function (path, value) {\n                var pathComponents = path.split('.'),\n                    dataObject = {};\n\n                pathComponents.splice(pathComponents.indexOf(formIndex), 1);\n                pathComponents.reverse();\n                $.each(pathComponents, function (index, pathPart) {\n                    var parent = {};\n\n                    if (index == 0) { //eslint-disable-line eqeqeq\n                        dataObject[pathPart] = value;\n                    } else {\n                        parent[pathPart] = dataObject;\n                        dataObject = parent;\n                    }\n                });\n                $.extend(true, addressData, dataObject);\n            });\n\n            return addressData;\n        },\n\n        /**\n         * Convert object to array\n         * @param {Object} object\n         * @returns {Array}\n         */\n        objectToArray: function (object) {\n            var convertedArray = [];\n\n            $.each(object, function (key) {\n                return typeof object[key] === 'string' ? convertedArray.push(object[key]) : false;\n            });\n\n            return convertedArray.slice(0);\n        },\n\n        /**\n         * @param {Object} addrs\n         * @return {*|Object}\n         */\n        addressToEstimationAddress: function (addrs) {\n            var self = this,\n                estimatedAddressData = {};\n\n            $.each(addrs, function (key) {\n                estimatedAddressData[self.toUnderscore(key)] = addrs[key];\n            });\n\n            return this.formAddressDataToQuoteAddress(estimatedAddressData);\n        }\n    };\n});\n","Magento_Checkout/js/model/sidebar.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return {\n        popUp: false,\n\n        /**\n         * @param {Object} popUp\n         */\n        setPopup: function (popUp) {\n            this.popUp = popUp;\n        },\n\n        /**\n         * Show popup.\n         */\n        show: function () {\n            if (this.popUp) {\n                this.popUp.modal('openModal');\n            }\n        },\n\n        /**\n         * Hide popup.\n         */\n        hide: function () {\n            if (this.popUp) {\n                this.popUp.modal('closeModal');\n            }\n        }\n    };\n});\n","Magento_Checkout/js/model/shipping-rate-registry.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    var cache = [];\n\n    return {\n        /**\n         * @param {String} addressKey\n         * @return {*}\n         */\n        get: function (addressKey) {\n            if (cache[addressKey]) {\n                return cache[addressKey];\n            }\n\n            return false;\n        },\n\n        /**\n         * @param {String} addressKey\n         * @param {*} data\n         */\n        set: function (addressKey, data) {\n            cache[addressKey] = data;\n        }\n    };\n});\n","Magento_Checkout/js/model/authentication-messages.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'Magento_Ui/js/model/messages'\n], function (ko, Messages) {\n    'use strict';\n\n    return new Messages();\n});\n","Magento_Checkout/js/model/default-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mageUtils',\n    './default-validation-rules',\n    'mage/translate'\n], function ($, utils, validationRules, $t) {\n    'use strict';\n\n    return {\n        validationErrors: [],\n\n        /**\n         * @param {Object} address\n         * @return {Boolean}\n         */\n        validate: function (address) {\n            var self = this;\n\n            this.validationErrors = [];\n            $.each(validationRules.getRules(), function (field, rule) {\n                var message;\n\n                if (rule.required && utils.isEmpty(address[field])) {\n                    message = $t('Field ') + field + $t(' is required.');\n\n                    self.validationErrors.push(message);\n                }\n            });\n\n            return !this.validationErrors.length;\n        }\n    };\n});\n","Magento_Checkout/js/model/default-post-code-resolver.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([], function () {\n    'use strict';\n\n    /**\n     * Define necessity of using default post code value\n     */\n    var useDefaultPostCode;\n\n    return {\n        /**\n         * Resolve default post code\n         *\n         * @returns {String|null}\n         */\n        resolve: function () {\n            return useDefaultPostCode ?  window.checkoutConfig.defaultPostcode : null;\n        },\n\n        /**\n         * Set state to useDefaultPostCode variable\n         *\n         * @param {Boolean} shouldUseDefaultPostCode\n         * @returns {underscore}\n         */\n        setUseDefaultPostCode: function (shouldUseDefaultPostCode) {\n            useDefaultPostCode = shouldUseDefaultPostCode;\n\n            return this;\n        }\n    };\n});\n","Magento_Checkout/js/model/default-validation-rules.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return {\n        /**\n         * @return {Object}\n         */\n        getRules: function () {\n            return {\n                'country_id': {\n                    'required': true\n                }\n            };\n        }\n    };\n});\n","Magento_Checkout/js/model/shipping-rates-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'ko',\n    './shipping-rates-validation-rules',\n    '../model/address-converter',\n    '../action/select-shipping-address',\n    './postcode-validator',\n    './default-validator',\n    'mage/translate',\n    'uiRegistry',\n    'Magento_Checkout/js/model/shipping-address/form-popup-state',\n    'Magento_Checkout/js/model/quote'\n], function (\n    $,\n    ko,\n    shippingRatesValidationRules,\n    addressConverter,\n    selectShippingAddress,\n    postcodeValidator,\n    defaultValidator,\n    $t,\n    uiRegistry,\n    formPopUpState\n) {\n    'use strict';\n\n    var checkoutConfig = window.checkoutConfig,\n        validators = [],\n        observedElements = [],\n        postcodeElements = [],\n        postcodeElementName = 'postcode';\n\n    validators.push(defaultValidator);\n\n    return {\n        validateAddressTimeout: 0,\n        validateZipCodeTimeout: 0,\n        validateDelay: 2000,\n\n        /**\n         * @param {String} carrier\n         * @param {Object} validator\n         */\n        registerValidator: function (carrier, validator) {\n            if (checkoutConfig.activeCarriers.indexOf(carrier) !== -1) {\n                validators.push(validator);\n            }\n        },\n\n        /**\n         * @param {Object} address\n         * @return {Boolean}\n         */\n        validateAddressData: function (address) {\n            return validators.some(function (validator) {\n                return validator.validate(address);\n            });\n        },\n\n        /**\n         * Perform postponed binding for fieldset elements\n         *\n         * @param {String} formPath\n         */\n        initFields: function (formPath) {\n            var self = this,\n                elements = shippingRatesValidationRules.getObservableFields();\n\n            if ($.inArray(postcodeElementName, elements) === -1) {\n                // Add postcode field to observables if not exist for zip code validation support\n                elements.push(postcodeElementName);\n            }\n\n            $.each(elements, function (index, field) {\n                uiRegistry.async(formPath + '.' + field)(self.doElementBinding.bind(self));\n            });\n        },\n\n        /**\n         * Bind shipping rates request to form element\n         *\n         * @param {Object} element\n         * @param {Boolean} force\n         * @param {Number} delay\n         */\n        doElementBinding: function (element, force, delay) {\n            var observableFields = shippingRatesValidationRules.getObservableFields();\n\n            if (element && (observableFields.indexOf(element.index) !== -1 || force)) {\n                if (element.index !== postcodeElementName) {\n                    this.bindHandler(element, delay);\n                }\n            }\n\n            if (element.index === postcodeElementName) {\n                this.bindHandler(element, delay);\n                postcodeElements.push(element);\n            }\n        },\n\n        /**\n         * @param {*} elements\n         * @param {Boolean} force\n         * @param {Number} delay\n         */\n        bindChangeHandlers: function (elements, force, delay) {\n            var self = this;\n\n            $.each(elements, function (index, elem) {\n                self.doElementBinding(elem, force, delay);\n            });\n        },\n\n        /**\n         * @param {Object} element\n         * @param {Number} delay\n         */\n        bindHandler: function (element, delay) {\n            var self = this;\n\n            delay = typeof delay === 'undefined' ? self.validateDelay : delay;\n\n            if (element.component.indexOf('/group') !== -1) {\n                $.each(element.elems(), function (index, elem) {\n                    self.bindHandler(elem);\n                });\n            } else {\n                element.on('value', function () {\n                    clearTimeout(self.validateZipCodeTimeout);\n                    self.validateZipCodeTimeout = setTimeout(function () {\n                        if (element.index === postcodeElementName) {\n                            self.postcodeValidation(element);\n                        } else {\n                            $.each(postcodeElements, function (index, elem) {\n                                self.postcodeValidation(elem);\n                            });\n                        }\n                    }, delay);\n\n                    if (!formPopUpState.isVisible()) {\n                        clearTimeout(self.validateAddressTimeout);\n                        self.validateAddressTimeout = setTimeout(function () {\n                            self.validateFields();\n                        }, delay);\n                    }\n                });\n                observedElements.push(element);\n            }\n        },\n\n        /**\n         * @return {*}\n         */\n        postcodeValidation: function (postcodeElement) {\n            var countryId = $('select[name=\"country_id\"]:visible').val(),\n                validationResult,\n                warnMessage;\n\n            if (postcodeElement == null || postcodeElement.value() == null) {\n                return true;\n            }\n\n            postcodeElement.warn(null);\n            validationResult = postcodeValidator.validate(postcodeElement.value(), countryId);\n\n            if (!validationResult) {\n                warnMessage = $t('Provided Zip/Postal Code seems to be invalid.');\n\n                if (postcodeValidator.validatedPostCodeExample.length) {\n                    warnMessage += $t(' Example: ') + postcodeValidator.validatedPostCodeExample.join('; ') + '. ';\n                }\n                warnMessage += $t('If you believe it is the right one you can ignore this notice.');\n                postcodeElement.warn(warnMessage);\n            }\n\n            return validationResult;\n        },\n\n        /**\n         * Convert form data to quote address and validate fields for shipping rates\n         */\n        validateFields: function () {\n            var addressFlat = addressConverter.formDataProviderToFlatData(\n                this.collectObservedData(),\n                'shippingAddress'\n                ),\n                address;\n\n            if (this.validateAddressData(addressFlat)) {\n                addressFlat = uiRegistry.get('checkoutProvider').shippingAddress;\n                address = addressConverter.formAddressDataToQuoteAddress(addressFlat);\n                selectShippingAddress(address);\n            }\n        },\n\n        /**\n         * Collect observed fields data to object\n         *\n         * @returns {*}\n         */\n        collectObservedData: function () {\n            var observedValues = {};\n\n            $.each(observedElements, function (index, field) {\n                observedValues[field.dataScope] = field.value();\n            });\n\n            return observedValues;\n        }\n    };\n});\n","Magento_Checkout/js/model/url-builder.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['jquery'], function ($) {\n    'use strict';\n\n    return {\n        method: 'rest',\n        storeCode: window.checkoutConfig.storeCode,\n        version: 'V1',\n        serviceUrl: ':method/:storeCode/:version',\n\n        /**\n         * @param {String} url\n         * @param {Object} params\n         * @return {*}\n         */\n        createUrl: function (url, params) {\n            var completeUrl = this.serviceUrl + url;\n\n            return this.bindParams(completeUrl, params);\n        },\n\n        /**\n         * @param {String} url\n         * @param {Object} params\n         * @return {*}\n         */\n        bindParams: function (url, params) {\n            var urlParts;\n\n            params.method = this.method;\n            params.storeCode = this.storeCode;\n            params.version = this.version;\n\n            urlParts = url.split('/');\n            urlParts = urlParts.filter(Boolean);\n\n            $.each(urlParts, function (key, part) {\n                part = part.replace(':', '');\n\n                if (params[part] != undefined) { //eslint-disable-line eqeqeq\n                    urlParts[key] = params[part];\n                }\n            });\n\n            return urlParts.join('/');\n        }\n    };\n});\n","Magento_Checkout/js/model/resource-url-manager.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Customer/js/model/customer',\n    'Magento_Checkout/js/model/url-builder',\n    'mageUtils'\n], function (customer, urlBuilder, utils) {\n        'use strict';\n\n        return {\n            /**\n             * @param {Object} quote\n             * @return {*}\n             */\n            getUrlForTotalsEstimationForNewAddress: function (quote) {\n                var params = this.getCheckoutMethod() == 'guest' ? //eslint-disable-line eqeqeq\n                        {\n                            cartId: quote.getQuoteId()\n                        } : {},\n                    urls = {\n                        'guest': '/guest-carts/:cartId/totals-information',\n                        'customer': '/carts/mine/totals-information'\n                    };\n\n                return this.getUrl(urls, params);\n            },\n\n            /**\n             * @param {Object} quote\n             * @return {*}\n             */\n            getUrlForEstimationShippingMethodsForNewAddress: function (quote) {\n                var params = this.getCheckoutMethod() == 'guest' ? //eslint-disable-line eqeqeq\n                        {\n                            quoteId: quote.getQuoteId()\n                        } : {},\n                    urls = {\n                        'guest': '/guest-carts/:quoteId/estimate-shipping-methods',\n                        'customer': '/carts/mine/estimate-shipping-methods'\n                    };\n\n                return this.getUrl(urls, params);\n            },\n\n            /**\n             * @param {Object} quote\n             * @return {*}\n             */\n            getUrlForEstimationShippingMethodsByAddressId: function (quote) {\n                var params = this.getCheckoutMethod() == 'guest' ? //eslint-disable-line eqeqeq\n                        {\n                            quoteId: quote.getQuoteId()\n                        } : {},\n                    urls = {\n                        'default': '/carts/mine/estimate-shipping-methods-by-address-id'\n                    };\n\n                return this.getUrl(urls, params);\n            },\n\n            /**\n             * @param {String} couponCode\n             * @param {String} quoteId\n             * @return {*}\n             */\n            getApplyCouponUrl: function (couponCode, quoteId) {\n                var params = this.getCheckoutMethod() == 'guest' ? //eslint-disable-line eqeqeq\n                        {\n                            quoteId: quoteId\n                        } : {},\n                    urls = {\n                        'guest': '/guest-carts/' + quoteId + '/coupons/' + encodeURIComponent(couponCode),\n                        'customer': '/carts/mine/coupons/' + encodeURIComponent(couponCode)\n                    };\n\n                return this.getUrl(urls, params);\n            },\n\n            /**\n             * @param {String} quoteId\n             * @return {*}\n             */\n            getCancelCouponUrl: function (quoteId) {\n                var params = this.getCheckoutMethod() == 'guest' ? //eslint-disable-line eqeqeq\n                        {\n                            quoteId: quoteId\n                        } : {},\n                    urls = {\n                        'guest': '/guest-carts/' + quoteId + '/coupons/',\n                        'customer': '/carts/mine/coupons/'\n                    };\n\n                return this.getUrl(urls, params);\n            },\n\n            /**\n             * @param {Object} quote\n             * @return {*}\n             */\n            getUrlForCartTotals: function (quote) {\n                var params = this.getCheckoutMethod() == 'guest' ? //eslint-disable-line eqeqeq\n                        {\n                            quoteId: quote.getQuoteId()\n                        } : {},\n                    urls = {\n                        'guest': '/guest-carts/:quoteId/totals',\n                        'customer': '/carts/mine/totals'\n                    };\n\n                return this.getUrl(urls, params);\n            },\n\n            /**\n             * @param {Object} quote\n             * @return {*}\n             */\n            getUrlForSetShippingInformation: function (quote) {\n                var params = this.getCheckoutMethod() == 'guest' ? //eslint-disable-line eqeqeq\n                        {\n                            cartId: quote.getQuoteId()\n                        } : {},\n                    urls = {\n                        'guest': '/guest-carts/:cartId/shipping-information',\n                        'customer': '/carts/mine/shipping-information'\n                    };\n\n                return this.getUrl(urls, params);\n            },\n\n            /**\n             * Get url for service.\n             *\n             * @param {*} urls\n             * @param {*} urlParams\n             * @return {String|*}\n             */\n            getUrl: function (urls, urlParams) {\n                var url;\n\n                if (utils.isEmpty(urls)) {\n                    return 'Provided service call does not exist.';\n                }\n\n                if (!utils.isEmpty(urls['default'])) {\n                    url = urls['default'];\n                } else {\n                    url = urls[this.getCheckoutMethod()];\n                }\n\n                return urlBuilder.createUrl(url, urlParams);\n            },\n\n            /**\n             * @return {String}\n             */\n            getCheckoutMethod: function () {\n                return customer.isLoggedIn() ? 'customer' : 'guest';\n            }\n        };\n    }\n);\n","Magento_Checkout/js/model/totals.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'ko',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Customer/js/customer-data'\n], function (ko, quote, customerData) {\n    'use strict';\n\n    var quoteItems = ko.observable(quote.totals().items),\n        cartData = customerData.get('cart'),\n        quoteSubtotal = parseFloat(quote.totals().subtotal),\n        subtotalAmount = parseFloat(cartData().subtotalAmount);\n\n    quote.totals.subscribe(function (newValue) {\n        quoteItems(newValue.items);\n    });\n\n    if (!isNaN(subtotalAmount) && quoteSubtotal !== subtotalAmount) {\n        customerData.reload(['cart'], false);\n    }\n\n    return {\n        totals: quote.totals,\n        isLoading: ko.observable(false),\n\n        /**\n         * @return {Function}\n         */\n        getItems: function () {\n            return quoteItems;\n        },\n\n        /**\n         * @param {*} code\n         * @return {*}\n         */\n        getSegment: function (code) {\n            var i, total;\n\n            if (!this.totals()) {\n                return null;\n            }\n\n            for (i in this.totals()['total_segments']) { //eslint-disable-line guard-for-in\n                total = this.totals()['total_segments'][i];\n\n                if (total.code == code) { //eslint-disable-line eqeqeq\n                    return total;\n                }\n            }\n\n            return null;\n        }\n    };\n});\n","Magento_Checkout/js/model/postcode-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'mageUtils'\n], function (utils) {\n    'use strict';\n\n    return {\n        validatedPostCodeExample: [],\n\n        /**\n         * @param {*} postCode\n         * @param {*} countryId\n         * @param {Array} postCodesPatterns\n         * @return {Boolean}\n         */\n        validate: function (postCode, countryId, postCodesPatterns) {\n            var pattern, regex,\n                patterns = postCodesPatterns ? postCodesPatterns[countryId] :\n                    window.checkoutConfig.postCodes[countryId];\n\n            this.validatedPostCodeExample = [];\n\n            if (!utils.isEmpty(postCode) && !utils.isEmpty(patterns)) {\n                for (pattern in patterns) {\n                    if (patterns.hasOwnProperty(pattern)) { //eslint-disable-line max-depth\n                        this.validatedPostCodeExample.push(patterns[pattern].example);\n                        regex = new RegExp(patterns[pattern].pattern);\n\n                        if (regex.test(postCode)) { //eslint-disable-line max-depth\n                            return true;\n                        }\n                    }\n                }\n\n                return false;\n            }\n\n            return true;\n        }\n    };\n});\n","Magento_Checkout/js/model/shipping-save-processor.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Checkout/js/model/shipping-save-processor/default'\n], function (defaultProcessor) {\n    'use strict';\n\n    var processors = {};\n\n    processors['default'] =  defaultProcessor;\n\n    return {\n        /**\n         * @param {String} type\n         * @param {*} processor\n         */\n        registerProcessor: function (type, processor) {\n            processors[type] = processor;\n        },\n\n        /**\n         * @param {String} type\n         * @return {Array}\n         */\n        saveShippingInformation: function (type) {\n            var rates = [];\n\n            if (processors[type]) {\n                rates = processors[type].saveShippingInformation();\n            } else {\n                rates = processors['default'].saveShippingInformation();\n            }\n\n            return rates;\n        }\n    };\n});\n","Magento_Checkout/js/model/new-customer-address.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'Magento_Checkout/js/model/default-post-code-resolver'\n], function (_, DefaultPostCodeResolver) {\n    'use strict';\n\n    /**\n     * @param {Object} addressData\n     * Returns new address object\n     */\n    return function (addressData) {\n        var identifier = Date.now(),\n            countryId = addressData['country_id'] || addressData.countryId || window.checkoutConfig.defaultCountryId,\n            regionId;\n\n        if (addressData.region && addressData.region['region_id']) {\n            regionId = addressData.region['region_id'];\n        } else if (!addressData['region_id']) {\n            regionId = undefined;\n        } else if (\n            /* eslint-disable */\n            addressData['country_id'] && addressData['country_id'] == window.checkoutConfig.defaultCountryId ||\n            !addressData['country_id'] && countryId == window.checkoutConfig.defaultCountryId\n            /* eslint-enable */\n        ) {\n            regionId = window.checkoutConfig.defaultRegionId || undefined;\n        }\n\n        return {\n            email: addressData.email,\n            countryId: countryId,\n            regionId: regionId || addressData.regionId,\n            regionCode: addressData.region ? addressData.region['region_code'] : null,\n            region: addressData.region ? addressData.region.region : null,\n            customerId: addressData['customer_id'] || addressData.customerId,\n            street: addressData.street ? _.compact(addressData.street) : addressData.street,\n            company: addressData.company,\n            telephone: addressData.telephone,\n            fax: addressData.fax,\n            postcode: addressData.postcode ? addressData.postcode : DefaultPostCodeResolver.resolve(),\n            city: addressData.city,\n            firstname: addressData.firstname,\n            lastname: addressData.lastname,\n            middlename: addressData.middlename,\n            prefix: addressData.prefix,\n            suffix: addressData.suffix,\n            vatId: addressData['vat_id'],\n            saveInAddressBook: addressData['save_in_address_book'],\n            customAttributes: addressData['custom_attributes'],\n            extensionAttributes: addressData['extension_attributes'],\n\n            /**\n             * @return {*}\n             */\n            isDefaultShipping: function () {\n                return addressData['default_shipping'];\n            },\n\n            /**\n             * @return {*}\n             */\n            isDefaultBilling: function () {\n                return addressData['default_billing'];\n            },\n\n            /**\n             * @return {String}\n             */\n            getType: function () {\n                return 'new-customer-address';\n            },\n\n            /**\n             * @return {String}\n             */\n            getKey: function () {\n                return this.getType();\n            },\n\n            /**\n             * @return {String}\n             */\n            getCacheKey: function () {\n                return this.getType() + identifier;\n            },\n\n            /**\n             * @return {Boolean}\n             */\n            isEditable: function () {\n                return true;\n            },\n\n            /**\n             * @return {Boolean}\n             */\n            canUseForBilling: function () {\n                return true;\n            }\n        };\n    };\n});\n","Magento_Checkout/js/model/billing-address-postcode-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n           'jquery',\n           'Magento_Checkout/js/model/postcode-validator',\n           'mage/translate',\n           'uiRegistry'\n       ], function (\n    $,\n    postcodeValidator,\n    $t,\n    uiRegistry\n) {\n    'use strict';\n\n    var postcodeElementName = 'postcode';\n\n    return {\n        validateZipCodeTimeout: 0,\n        validateDelay: 2000,\n\n        /**\n         * Perform postponed binding for fieldset elements\n         *\n         * @param {String} formPath\n         */\n        initFields: function (formPath) {\n            var self = this;\n\n            uiRegistry.async(formPath + '.' + postcodeElementName)(self.bindHandler.bind(self));\n        },\n\n        /**\n         * @param {Object} element\n         * @param {Number} delay\n         */\n        bindHandler: function (element, delay) {\n            var self = this;\n\n            delay = typeof delay === 'undefined' ? self.validateDelay : delay;\n\n            element.on('value', function () {\n                clearTimeout(self.validateZipCodeTimeout);\n                self.validateZipCodeTimeout = setTimeout(function () {\n                    self.postcodeValidation(element);\n                }, delay);\n            });\n        },\n\n        /**\n         * @param {Object} postcodeElement\n         * @return {*}\n         */\n        postcodeValidation: function (postcodeElement) {\n            var countryId = $('select[name=\"country_id\"]:visible').val(),\n                validationResult,\n                warnMessage;\n\n            if (postcodeElement == null || postcodeElement.value() == null) {\n                return true;\n            }\n\n            postcodeElement.warn(null);\n            validationResult = postcodeValidator.validate(postcodeElement.value(), countryId);\n\n            if (!validationResult) {\n                warnMessage = $t('Provided Zip/Postal Code seems to be invalid.');\n\n                if (postcodeValidator.validatedPostCodeExample.length) {\n                    warnMessage += $t(' Example: ') + postcodeValidator.validatedPostCodeExample.join('; ') + '. ';\n                }\n                warnMessage += $t('If you believe it is the right one you can ignore this notice.');\n                postcodeElement.warn(warnMessage);\n            }\n\n            return validationResult;\n        }\n    };\n});\n","Magento_Checkout/js/model/full-screen-loader.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'rjsResolver'\n], function ($, resolver) {\n    'use strict';\n\n    var containerId = '#checkout';\n\n    return {\n\n        /**\n         * Start full page loader action\n         */\n        startLoader: function () {\n            $(containerId).trigger('processStart');\n        },\n\n        /**\n         * Stop full page loader action\n         *\n         * @param {Boolean} [forceStop]\n         */\n        stopLoader: function (forceStop) {\n            var $elem = $(containerId),\n                stop = $elem.trigger.bind($elem, 'processStop');\n\n            forceStop ? stop() : resolver(stop);\n        }\n    };\n});\n","Magento_Checkout/js/model/shipping-rates-validation-rules.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine(['jquery'], function ($) {\n    'use strict';\n\n    var ratesRules = {},\n        checkoutConfig = window.checkoutConfig;\n\n    return {\n        /**\n         * @param {String} carrier\n         * @param {Object} rules\n         */\n        registerRules: function (carrier, rules) {\n            if (checkoutConfig.activeCarriers.indexOf(carrier) !== -1) {\n                ratesRules[carrier] = rules.getRules();\n            }\n        },\n\n        /**\n         * @return {Object}\n         */\n        getRules: function () {\n            return ratesRules;\n        },\n\n        /**\n         * @return {Array}\n         */\n        getObservableFields: function () {\n            var self = this,\n                observableFields = [];\n\n            $.each(self.getRules(), function (carrier, fields) {\n                $.each(fields, function (field) {\n                    if (observableFields.indexOf(field) === -1) {\n                        observableFields.push(field);\n                    }\n                });\n            });\n\n            return observableFields;\n        }\n    };\n});\n","Magento_Checkout/js/model/step-navigator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'ko'\n], function ($, ko) {\n    'use strict';\n\n    var steps = ko.observableArray();\n\n    return {\n        steps: steps,\n        stepCodes: [],\n        validCodes: [],\n\n        /**\n         * @return {Boolean}\n         */\n        handleHash: function () {\n            var hashString = window.location.hash.replace('#', ''),\n                isRequestedStepVisible;\n\n            if (hashString === '') {\n                return false;\n            }\n\n            if ($.inArray(hashString, this.validCodes) === -1) {\n                window.location.href = window.checkoutConfig.pageNotFoundUrl;\n\n                return false;\n            }\n\n            isRequestedStepVisible = steps.sort(this.sortItems).some(function (element) {\n                return (element.code == hashString || element.alias == hashString) && element.isVisible(); //eslint-disable-line\n            });\n\n            //if requested step is visible, then we don't need to load step data from server\n            if (isRequestedStepVisible) {\n                return false;\n            }\n\n            steps().sort(this.sortItems).forEach(function (element) {\n                if (element.code == hashString || element.alias == hashString) { //eslint-disable-line eqeqeq\n                    element.navigate(element);\n                } else {\n                    element.isVisible(false);\n                }\n\n            });\n\n            return false;\n        },\n\n        /**\n         * @param {String} code\n         * @param {*} alias\n         * @param {*} title\n         * @param {Function} isVisible\n         * @param {*} navigate\n         * @param {*} sortOrder\n         */\n        registerStep: function (code, alias, title, isVisible, navigate, sortOrder) {\n            var hash, active;\n\n            if ($.inArray(code, this.validCodes) !== -1) {\n                throw new DOMException('Step code [' + code + '] already registered in step navigator');\n            }\n\n            if (alias != null) {\n                if ($.inArray(alias, this.validCodes) !== -1) {\n                    throw new DOMException('Step code [' + alias + '] already registered in step navigator');\n                }\n                this.validCodes.push(alias);\n            }\n            this.validCodes.push(code);\n            steps.push({\n                code: code,\n                alias: alias != null ? alias : code,\n                title: title,\n                isVisible: isVisible,\n                navigate: navigate,\n                sortOrder: sortOrder\n            });\n            active = this.getActiveItemIndex();\n            steps.each(function (elem, index) {\n                if (active !== index) {\n                    elem.isVisible(false);\n                }\n            });\n            this.stepCodes.push(code);\n            hash = window.location.hash.replace('#', '');\n\n            if (hash != '' && hash != code) { //eslint-disable-line eqeqeq\n                //Force hiding of not active step\n                isVisible(false);\n            }\n        },\n\n        /**\n         * @param {Object} itemOne\n         * @param {Object} itemTwo\n         * @return {Number}\n         */\n        sortItems: function (itemOne, itemTwo) {\n            return itemOne.sortOrder > itemTwo.sortOrder ? 1 : -1;\n        },\n\n        /**\n         * @return {Number}\n         */\n        getActiveItemIndex: function () {\n            var activeIndex = 0;\n\n            steps().sort(this.sortItems).some(function (element, index) {\n                if (element.isVisible()) {\n                    activeIndex = index;\n\n                    return true;\n                }\n\n                return false;\n            });\n\n            return activeIndex;\n        },\n\n        /**\n         * @param {*} code\n         * @return {Boolean}\n         */\n        isProcessed: function (code) {\n            var activeItemIndex = this.getActiveItemIndex(),\n                sortedItems = steps().sort(this.sortItems),\n                requestedItemIndex = -1;\n\n            sortedItems.forEach(function (element, index) {\n                if (element.code == code) { //eslint-disable-line eqeqeq\n                    requestedItemIndex = index;\n                }\n            });\n\n            return activeItemIndex > requestedItemIndex;\n        },\n\n        /**\n         * @param {*} code\n         * @param {*} scrollToElementId\n         */\n        navigateTo: function (code, scrollToElementId) {\n            var sortedItems = steps().sort(this.sortItems),\n                bodyElem = $('body');\n\n            scrollToElementId = scrollToElementId || null;\n\n            if (!this.isProcessed(code)) {\n                return;\n            }\n            sortedItems.forEach(function (element) {\n                if (element.code == code) { //eslint-disable-line eqeqeq\n                    element.isVisible(true);\n                    bodyElem.animate({\n                        scrollTop: $('#' + code).offset().top\n                    }, 0, function () {\n                        window.location = window.checkoutConfig.checkoutUrl + '#' + code;\n                    });\n\n                    if (scrollToElementId && $('#' + scrollToElementId).length) {\n                        bodyElem.animate({\n                            scrollTop: $('#' + scrollToElementId).offset().top\n                        }, 0);\n                    }\n                } else {\n                    element.isVisible(false);\n                }\n\n            });\n        },\n\n        /**\n         * Sets window location hash.\n         *\n         * @param {String} hash\n         */\n        setHash: function (hash) {\n            window.location.hash = hash;\n        },\n\n        /**\n         * Next step.\n         */\n        next: function () {\n            var activeIndex = 0,\n                code;\n\n            steps().sort(this.sortItems).forEach(function (element, index) {\n                if (element.isVisible()) {\n                    element.isVisible(false);\n                    activeIndex = index;\n                }\n            });\n\n            if (steps().length > activeIndex + 1) {\n                code = steps()[activeIndex + 1].code;\n                steps()[activeIndex + 1].isVisible(true);\n                this.setHash(code);\n                document.body.scrollTop = document.documentElement.scrollTop = 0;\n            }\n        }\n    };\n});\n","Magento_Checkout/js/model/shipping-save-processor/payload-extender.js":"define([], function () {\n    'use strict';\n\n    return function (payload) {\n        payload.addressInformation['extension_attributes'] = {};\n\n        return payload;\n    };\n});\n","Magento_Checkout/js/model/shipping-save-processor/default.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/resource-url-manager',\n    'mage/storage',\n    'Magento_Checkout/js/model/payment-service',\n    'Magento_Checkout/js/model/payment/method-converter',\n    'Magento_Checkout/js/model/error-processor',\n    'Magento_Checkout/js/model/full-screen-loader',\n    'Magento_Checkout/js/action/select-billing-address',\n    'Magento_Checkout/js/model/shipping-save-processor/payload-extender'\n], function (\n    ko,\n    quote,\n    resourceUrlManager,\n    storage,\n    paymentService,\n    methodConverter,\n    errorProcessor,\n    fullScreenLoader,\n    selectBillingAddressAction,\n    payloadExtender\n) {\n    'use strict';\n\n    return {\n        /**\n         * @return {jQuery.Deferred}\n         */\n        saveShippingInformation: function () {\n            var payload;\n\n            if (!quote.billingAddress() && quote.shippingAddress().canUseForBilling()) {\n                selectBillingAddressAction(quote.shippingAddress());\n            }\n\n            payload = {\n                addressInformation: {\n                    'shipping_address': quote.shippingAddress(),\n                    'billing_address': quote.billingAddress(),\n                    'shipping_method_code': quote.shippingMethod()['method_code'],\n                    'shipping_carrier_code': quote.shippingMethod()['carrier_code']\n                }\n            };\n\n            payloadExtender(payload);\n\n            fullScreenLoader.startLoader();\n\n            return storage.post(\n                resourceUrlManager.getUrlForSetShippingInformation(quote),\n                JSON.stringify(payload)\n            ).done(\n                function (response) {\n                    quote.setTotals(response.totals);\n                    paymentService.setPaymentMethods(methodConverter(response['payment_methods']));\n                    fullScreenLoader.stopLoader();\n                }\n            ).fail(\n                function (response) {\n                    errorProcessor.process(response);\n                    fullScreenLoader.stopLoader();\n                }\n            );\n        }\n    };\n});\n","Magento_Checkout/js/model/shipping-address/form-popup-state.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko'\n], function (ko) {\n    'use strict';\n\n    return {\n        isVisible: ko.observable(false)\n    };\n});\n","Magento_Checkout/js/model/payment/method-list.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko'\n], function (ko) {\n    'use strict';\n\n    return ko.observableArray([]);\n});\n","Magento_Checkout/js/model/payment/additional-validators.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([], function () {\n    'use strict';\n\n    var validators = [];\n\n    return {\n        /**\n         * Register unique validator\n         *\n         * @param {*} validator\n         */\n        registerValidator: function (validator) {\n            validators.push(validator);\n        },\n\n        /**\n         * Returns array of registered validators\n         *\n         * @returns {Array}\n         */\n        getValidators: function () {\n            return validators;\n        },\n\n        /**\n         * Process validators\n         *\n         * @returns {Boolean}\n         */\n        validate: function (hideError) {\n            var validationResult = true;\n\n            hideError = hideError || false;\n\n            if (validators.length <= 0) {\n                return validationResult;\n            }\n\n            validators.forEach(function (item) {\n                if (item.validate(hideError) == false) { //eslint-disable-line eqeqeq\n                    validationResult = false;\n\n                    return false;\n                }\n            });\n\n            return validationResult;\n        }\n    };\n});\n","Magento_Checkout/js/model/payment/renderer-list.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko'\n], function (ko) {\n    'use strict';\n\n    return ko.observableArray([]);\n});\n","Magento_Checkout/js/model/payment/method-group.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n        'uiElement',\n        'mage/translate'\n], function (Element, $t) {\n    'use strict';\n\n    var DEFAULT_GROUP_ALIAS = 'default';\n\n    return Element.extend({\n        defaults: {\n            alias: DEFAULT_GROUP_ALIAS,\n            title: $t('Payment Method'),\n            sortOrder: 100,\n            displayArea: 'payment-methods-items-${ $.alias }'\n        },\n\n        /**\n         * Checks if group instance is default\n         *\n         * @returns {Boolean}\n         */\n        isDefault: function () {\n            return this.alias === DEFAULT_GROUP_ALIAS;\n        }\n    });\n});\n","Magento_Checkout/js/model/payment/method-converter.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    return function (methods) {\n        _.each(methods, function (method) {\n            if (method.hasOwnProperty('code')) {\n                method.method = method.code;\n                delete method.code;\n            }\n        });\n\n        return methods;\n    };\n});\n","Magento_Checkout/js/model/payment/place-order-hooks.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return {\n        requestModifiers: [],\n        afterRequestListeners: []\n    };\n});\n","Magento_Checkout/js/model/shipping-rate-processor/new-address.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Checkout/js/model/resource-url-manager',\n    'Magento_Checkout/js/model/quote',\n    'mage/storage',\n    'Magento_Checkout/js/model/shipping-service',\n    'Magento_Checkout/js/model/shipping-rate-registry',\n    'Magento_Checkout/js/model/error-processor'\n], function (resourceUrlManager, quote, storage, shippingService, rateRegistry, errorProcessor) {\n    'use strict';\n\n    return {\n        /**\n         * Get shipping rates for specified address.\n         * @param {Object} address\n         */\n        getRates: function (address) {\n            var cache, serviceUrl, payload;\n\n            shippingService.isLoading(true);\n            cache = rateRegistry.get(address.getCacheKey());\n            serviceUrl = resourceUrlManager.getUrlForEstimationShippingMethodsForNewAddress(quote);\n            payload = JSON.stringify({\n                    address: {\n                        'street': address.street,\n                        'city': address.city,\n                        'region_id': address.regionId,\n                        'region': address.region,\n                        'country_id': address.countryId,\n                        'postcode': address.postcode,\n                        'email': address.email,\n                        'customer_id': address.customerId,\n                        'firstname': address.firstname,\n                        'lastname': address.lastname,\n                        'middlename': address.middlename,\n                        'prefix': address.prefix,\n                        'suffix': address.suffix,\n                        'vat_id': address.vatId,\n                        'company': address.company,\n                        'telephone': address.telephone,\n                        'fax': address.fax,\n                        'custom_attributes': address.customAttributes,\n                        'save_in_address_book': address.saveInAddressBook\n                    }\n                }\n            );\n\n            if (cache) {\n                shippingService.setShippingRates(cache);\n                shippingService.isLoading(false);\n            } else {\n                storage.post(\n                    serviceUrl, payload, false\n                ).done(function (result) {\n                    rateRegistry.set(address.getCacheKey(), result);\n                    shippingService.setShippingRates(result);\n                }).fail(function (response) {\n                    shippingService.setShippingRates([]);\n                    errorProcessor.process(response);\n                }).always(function () {\n                    shippingService.isLoading(false);\n                });\n            }\n        }\n    };\n});\n","Magento_Checkout/js/model/shipping-rate-processor/customer-address.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Checkout/js/model/resource-url-manager',\n    'Magento_Checkout/js/model/quote',\n    'mage/storage',\n    'Magento_Checkout/js/model/shipping-service',\n    'Magento_Checkout/js/model/shipping-rate-registry',\n    'Magento_Checkout/js/model/error-processor'\n], function (resourceUrlManager, quote, storage, shippingService, rateRegistry, errorProcessor) {\n    'use strict';\n\n    return {\n        /**\n         * @param {Object} address\n         */\n        getRates: function (address) {\n            var cache;\n\n            shippingService.isLoading(true);\n            cache = rateRegistry.get(address.getKey());\n\n            if (cache) {\n                shippingService.setShippingRates(cache);\n                shippingService.isLoading(false);\n            } else {\n                storage.post(\n                    resourceUrlManager.getUrlForEstimationShippingMethodsByAddressId(),\n                    JSON.stringify({\n                        addressId: address.customerAddressId\n                    }),\n                    false\n                ).done(function (result) {\n                    rateRegistry.set(address.getKey(), result);\n                    shippingService.setShippingRates(result);\n                }).fail(function (response) {\n                    shippingService.setShippingRates([]);\n                    errorProcessor.process(response);\n                }).always(function () {\n                    shippingService.isLoading(false);\n                }\n                );\n            }\n        }\n    };\n});\n","Magento_Checkout/js/model/cart/estimate-service.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/shipping-rate-processor/new-address',\n    'Magento_Checkout/js/model/cart/totals-processor/default',\n    'Magento_Checkout/js/model/shipping-service',\n    'Magento_Checkout/js/model/cart/cache',\n    'Magento_Customer/js/customer-data'\n], function (quote, defaultProcessor, totalsDefaultProvider, shippingService, cartCache, customerData) {\n    'use strict';\n\n    var rateProcessors = {},\n        totalsProcessors = {},\n\n        /**\n         * Estimate totals for shipping address and update shipping rates.\n         */\n        estimateTotalsAndUpdateRates = function () {\n            var type = quote.shippingAddress().getType();\n\n            if (\n                quote.isVirtual() ||\n                window.checkoutConfig.activeCarriers && window.checkoutConfig.activeCarriers.length === 0\n            ) {\n                // update totals block when estimated address was set\n                totalsProcessors['default'] = totalsDefaultProvider;\n                totalsProcessors[type] ?\n                    totalsProcessors[type].estimateTotals(quote.shippingAddress()) :\n                    totalsProcessors['default'].estimateTotals(quote.shippingAddress());\n            } else {\n                // check if user data not changed -> load rates from cache\n                if (!cartCache.isChanged('address', quote.shippingAddress()) &&\n                    !cartCache.isChanged('cartVersion', customerData.get('cart')()['data_id']) &&\n                    cartCache.get('rates')\n                ) {\n                    shippingService.setShippingRates(cartCache.get('rates'));\n\n                    return;\n                }\n\n                // update rates list when estimated address was set\n                rateProcessors['default'] = defaultProcessor;\n                rateProcessors[type] ?\n                    rateProcessors[type].getRates(quote.shippingAddress()) :\n                    rateProcessors['default'].getRates(quote.shippingAddress());\n\n                // save rates to cache after load\n                shippingService.getShippingRates().subscribe(function (rates) {\n                    cartCache.set('rates', rates);\n                });\n            }\n        },\n\n        /**\n         * Estimate totals for shipping address.\n         */\n        estimateTotalsShipping = function () {\n            totalsDefaultProvider.estimateTotals(quote.shippingAddress());\n        },\n\n        /**\n         * Estimate totals for billing address.\n         */\n        estimateTotalsBilling = function () {\n            var type = quote.billingAddress().getType();\n\n            if (quote.isVirtual()) {\n                // update totals block when estimated address was set\n                totalsProcessors['default'] = totalsDefaultProvider;\n                totalsProcessors[type] ?\n                    totalsProcessors[type].estimateTotals(quote.billingAddress()) :\n                    totalsProcessors['default'].estimateTotals(quote.billingAddress());\n            }\n        };\n\n    quote.shippingAddress.subscribe(estimateTotalsAndUpdateRates);\n    quote.shippingMethod.subscribe(estimateTotalsShipping);\n    quote.billingAddress.subscribe(estimateTotalsBilling);\n});\n","Magento_Checkout/js/model/cart/cache.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * Cart adapter for customer data storage.\n * It stores cart data in customer data(localStorage) without saving on server.\n * Adapter is created for shipping rates and totals data caching. It eliminates unneeded calculations requests.\n */\ndefine([\n    'underscore',\n    'Magento_Customer/js/customer-data',\n    'mageUtils'\n], function (_, storage, utils) {\n    'use strict';\n\n    var cacheKey = 'cart-data',\n        cartData = {\n            totals: null,\n            address: null,\n            cartVersion: null,\n            shippingMethodCode: null,\n            shippingCarrierCode: null,\n            rates: null\n        },\n\n        /**\n         * Set data to local storage.\n         *\n         * @param {Object} checkoutData\n         */\n        setData = function (checkoutData) {\n            storage.set(cacheKey, checkoutData);\n        },\n\n        /**\n         * Get data from local storage.\n         *\n         * @param {String} [key]\n         * @returns {*}\n         */\n        getData = function (key) {\n            var data = key ? storage.get(cacheKey)()[key] : storage.get(cacheKey)();\n\n            if (_.isEmpty(storage.get(cacheKey)())) {\n                setData(utils.copy(cartData));\n            }\n\n            return data;\n        },\n\n        /**\n         * Build method name base on name, prefix and suffix.\n         *\n         * @param {String} name\n         * @param {String} prefix\n         * @param {String} suffix\n         * @return {String}\n         */\n        getMethodName = function (name, prefix, suffix) {\n            prefix = prefix || '';\n            suffix = suffix || '';\n\n            return prefix + name.charAt(0).toUpperCase() + name.slice(1) + suffix;\n        };\n\n    /**\n     * Provides get/set/isChanged/clear methods for work with cart data.\n     * Can be customized via mixin functionality.\n     */\n    return {\n        cartData: cartData,\n\n        /**\n         * Array of required address fields\n         */\n        requiredFields: ['countryId', 'region', 'regionId', 'postcode'],\n\n        /**\n         * Get data from customer data.\n         * Concatenate provided key with method name and call method if it exist or makes get by key.\n         *\n         * @param {String} key\n         * @return {*}\n         */\n        get: function (key) {\n            var methodName = getMethodName(key, '_get');\n\n            if (key === cacheKey) {\n                return getData();\n            }\n\n            if (this[methodName]) {\n                return this[methodName]();\n            }\n\n            return getData(key);\n        },\n\n        /**\n         * Set data to customer data.\n         * Concatenate provided key with method name and call method if it exist or makes set by key.\n         * @example _setCustomAddress method will be called, if it exists.\n         *  set('address', customAddressValue)\n         * @example Will set value by provided key.\n         *  set('rates', ratesToCompare)\n         *\n         * @param {String} key\n         * @param {*} value\n         */\n        set: function (key, value) {\n            var methodName = getMethodName(key, '_set'),\n                obj;\n\n            if (key === cacheKey) {\n                _.each(value, function (val, k) {\n                    this.set(k, val);\n                }, this);\n\n                return;\n            }\n\n            if (this[methodName]) {\n                this[methodName](value);\n            } else {\n                obj = getData();\n                obj[key] = value;\n                setData(obj);\n            }\n        },\n\n        /**\n         * Clear data in cache.\n         * Concatenate provided key with method name and call method if it exist or clear by key.\n         * @example _clearCustomAddress method will be called, if it exist.\n         *  clear('customAddress')\n         * @example Will clear data by provided key.\n         *  clear('rates')\n         *\n         * @param {String} key\n         */\n        clear: function (key) {\n            var methodName = getMethodName(key, '_clear');\n\n            if (key === cacheKey) {\n                setData(this.cartData);\n\n                return;\n            }\n\n            if (this[methodName]) {\n                this[methodName]();\n            } else {\n                this.set(key, null);\n            }\n        },\n\n        /**\n         * Check if provided data has difference with cached data.\n         * Concatenate provided key with method name and call method if it exist or makes strict equality.\n         * @example Will call existing _isAddressChanged.\n         *  isChanged('address', addressToCompare)\n         * @example Will get data by provided key and make strict equality with provided value.\n         *  isChanged('rates', ratesToCompare)\n         *\n         * @param {String} key\n         * @param {*} value\n         * @return {Boolean}\n         */\n        isChanged: function (key, value) {\n            var methodName = getMethodName(key, '_is', 'Changed');\n\n            if (this[methodName]) {\n                return this[methodName](value);\n            }\n\n            return this.get(key) !== value;\n        },\n\n        /**\n         * Compare cached address with provided.\n         * Custom method for check object equality.\n         *\n         * @param {Object} address\n         * @returns {Boolean}\n         */\n        _isAddressChanged: function (address) {\n            return JSON.stringify(_.pick(this.get('address'), this.requiredFields)) !==\n                JSON.stringify(_.pick(address, this.requiredFields));\n        },\n\n        /**\n         * Compare cached subtotal with provided.\n         * Custom method for check object equality.\n         *\n         * @param {float} subtotal\n         * @returns {Boolean}\n         */\n        _isSubtotalChanged: function (subtotal) {\n            var cached = parseFloat(this.get('totals').subtotal);\n\n            return subtotal !== cached;\n        }\n    };\n});\n","Magento_Checkout/js/model/cart/totals-processor/default.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Checkout/js/model/resource-url-manager',\n    'Magento_Checkout/js/model/quote',\n    'mage/storage',\n    'Magento_Checkout/js/model/totals',\n    'Magento_Checkout/js/model/error-processor',\n    'Magento_Checkout/js/model/cart/cache',\n    'Magento_Customer/js/customer-data'\n], function (_, resourceUrlManager, quote, storage, totalsService, errorProcessor, cartCache, customerData) {\n    'use strict';\n\n    /**\n     * Load data from server.\n     *\n     * @param {Object} address\n     */\n    var loadFromServer = function (address) {\n        var serviceUrl,\n            payload;\n\n        // Start loader for totals block\n        totalsService.isLoading(true);\n        serviceUrl = resourceUrlManager.getUrlForTotalsEstimationForNewAddress(quote);\n        payload = {\n            addressInformation: {\n                address: _.pick(address, cartCache.requiredFields)\n            }\n        };\n\n        if (quote.shippingMethod() && quote.shippingMethod()['method_code']) {\n            payload.addressInformation['shipping_method_code'] = quote.shippingMethod()['method_code'];\n            payload.addressInformation['shipping_carrier_code'] = quote.shippingMethod()['carrier_code'];\n        }\n\n        return storage.post(\n            serviceUrl, JSON.stringify(payload), false\n        ).done(function (result) {\n            var data = {\n                totals: result,\n                address: address,\n                cartVersion: customerData.get('cart')()['data_id'],\n                shippingMethodCode: null,\n                shippingCarrierCode: null\n            };\n\n            if (quote.shippingMethod() && quote.shippingMethod()['method_code']) {\n                data.shippingMethodCode = quote.shippingMethod()['method_code'];\n                data.shippingCarrierCode = quote.shippingMethod()['carrier_code'];\n            }\n\n            quote.setTotals(result);\n            cartCache.set('cart-data', data);\n        }).fail(function (response) {\n            errorProcessor.process(response);\n        }).always(function () {\n            // Stop loader for totals block\n            totalsService.isLoading(false);\n        });\n    };\n\n    return {\n        /**\n         * Array of required address fields.\n         * @property {Array.String} requiredFields\n         * @deprecated Use cart cache.\n         */\n        requiredFields: cartCache.requiredFields,\n\n        /**\n         * Get shipping rates for specified address.\n         * @param {Object} address\n         */\n        estimateTotals: function (address) {\n            var data = {\n                shippingMethodCode: null,\n                shippingCarrierCode: null\n            };\n\n            if (quote.shippingMethod() && quote.shippingMethod()['method_code']) {\n                data.shippingMethodCode = quote.shippingMethod()['method_code'];\n                data.shippingCarrierCode = quote.shippingMethod()['carrier_code'];\n            }\n\n            return loadFromServer(address);\n        }\n    };\n});\n","Magento_Checkout/js/view/progress-bar.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'ko',\n    'uiComponent',\n    'Magento_Checkout/js/model/step-navigator',\n    'Magento_Checkout/js/view/billing-address'\n], function ($, _, ko, Component, stepNavigator, billingAddress) {\n    'use strict';\n\n    var steps = stepNavigator.steps;\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/progress-bar',\n            visible: true\n        },\n        steps: steps,\n\n        /** @inheritdoc */\n        initialize: function () {\n            var stepsValue;\n\n            this._super();\n            window.addEventListener('hashchange', _.bind(stepNavigator.handleHash, stepNavigator));\n\n            if (!window.location.hash) {\n                stepsValue = stepNavigator.steps();\n\n                if (stepsValue.length) {\n                    stepNavigator.setHash(stepsValue.sort(stepNavigator.sortItems)[0].code);\n                }\n            }\n\n            stepNavigator.handleHash();\n        },\n\n        /**\n         * @param {*} itemOne\n         * @param {*} itemTwo\n         * @return {*|Number}\n         */\n        sortItems: function (itemOne, itemTwo) {\n            return stepNavigator.sortItems(itemOne, itemTwo);\n        },\n\n        /**\n         * @param {Object} step\n         */\n        navigateTo: function (step) {\n            if (step.code === 'shipping') {\n                billingAddress().needCancelBillingAddressChanges();\n            }\n            stepNavigator.navigateTo(step.code);\n        },\n\n        /**\n         * @param {Object} item\n         * @return {*|Boolean}\n         */\n        isProcessed: function (item) {\n            return stepNavigator.isProcessed(item.code);\n        }\n    });\n});\n","Magento_Checkout/js/view/estimation.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Catalog/js/price-utils',\n    'Magento_Checkout/js/model/totals',\n    'Magento_Checkout/js/model/sidebar'\n], function (Component, quote, priceUtils, totals, sidebarModel) {\n    'use strict';\n\n    return Component.extend({\n        isLoading: totals.isLoading,\n\n        /**\n         * @return {Number}\n         */\n        getQuantity: function () {\n            if (totals.totals()) {\n                return parseFloat(totals.totals()['items_qty']);\n            }\n\n            return 0;\n        },\n\n        /**\n         * @return {Number}\n         */\n        getPureValue: function () {\n            if (totals.totals()) {\n                return parseFloat(totals.getSegment('grand_total').value);\n            }\n\n            return 0;\n        },\n\n        /**\n         * Show sidebar.\n         */\n        showSidebar: function () {\n            sidebarModel.show();\n        },\n\n        /**\n         * @param {*} price\n         * @return {*|String}\n         */\n        getFormattedPrice: function (price) {\n            return priceUtils.formatPrice(price, quote.getPriceFormat());\n        },\n\n        /**\n         * @return {*|String}\n         */\n        getValue: function () {\n            return this.getFormattedPrice(this.getPureValue());\n        }\n    });\n});\n","Magento_Checkout/js/view/minicart.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Customer/js/customer-data',\n    'jquery',\n    'ko',\n    'underscore',\n    'sidebar',\n    'mage/translate',\n    'mage/dropdown'\n], function (Component, customerData, $, ko, _) {\n    'use strict';\n\n    var sidebarInitialized = false,\n        addToCartCalls = 0,\n        miniCart;\n\n    miniCart = $('[data-block=\\'minicart\\']');\n\n    /**\n     * @return {Boolean}\n     */\n    function initSidebar() {\n        if (miniCart.data('mageSidebar')) {\n            miniCart.sidebar('update');\n        }\n\n        if (!$('[data-role=product-item]').length) {\n            return false;\n        }\n        miniCart.trigger('contentUpdated');\n\n        if (sidebarInitialized) {\n            return false;\n        }\n        sidebarInitialized = true;\n        miniCart.sidebar({\n            'targetElement': 'div.block.block-minicart',\n            'url': {\n                'checkout': window.checkout.checkoutUrl,\n                'update': window.checkout.updateItemQtyUrl,\n                'remove': window.checkout.removeItemUrl,\n                'loginUrl': window.checkout.customerLoginUrl,\n                'isRedirectRequired': window.checkout.isRedirectRequired\n            },\n            'button': {\n                'checkout': '#top-cart-btn-checkout',\n                'remove': '#mini-cart a.action.delete',\n                'close': '#btn-minicart-close'\n            },\n            'showcart': {\n                'parent': 'span.counter',\n                'qty': 'span.counter-number',\n                'label': 'span.counter-label'\n            },\n            'minicart': {\n                'list': '#mini-cart',\n                'content': '#minicart-content-wrapper',\n                'qty': 'div.items-total',\n                'subtotal': 'div.subtotal span.price',\n                'maxItemsVisible': window.checkout.minicartMaxItemsVisible\n            },\n            'item': {\n                'qty': ':input.cart-item-qty',\n                'button': ':button.update-cart-item'\n            },\n            'confirmMessage': $.mage.__('Are you sure you would like to remove this item from the shopping cart?')\n        });\n    }\n\n    miniCart.on('dropdowndialogopen', function () {\n        initSidebar();\n    });\n\n    return Component.extend({\n        shoppingCartUrl: window.checkout.shoppingCartUrl,\n        maxItemsToDisplay: window.checkout.maxItemsToDisplay,\n        cart: {},\n\n        // jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n        /**\n         * @override\n         */\n        initialize: function () {\n            var self = this,\n                cartData = customerData.get('cart');\n\n            this.update(cartData());\n            cartData.subscribe(function (updatedCart) {\n                addToCartCalls--;\n                this.isLoading(addToCartCalls > 0);\n                sidebarInitialized = false;\n                this.update(updatedCart);\n                initSidebar();\n            }, this);\n            $('[data-block=\"minicart\"]').on('contentLoading', function () {\n                addToCartCalls++;\n                self.isLoading(true);\n            });\n\n            if (\n                cartData().website_id !== window.checkout.websiteId && cartData().website_id !== undefined ||\n                cartData().storeId !== window.checkout.storeId && cartData().storeId !== undefined\n            ) {\n                customerData.reload(['cart'], false);\n            }\n\n            return this._super();\n        },\n        //jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n\n        isLoading: ko.observable(false),\n        initSidebar: initSidebar,\n\n        /**\n         * Close mini shopping cart.\n         */\n        closeMinicart: function () {\n            $('[data-block=\"minicart\"]').find('[data-role=\"dropdownDialog\"]').dropdownDialog('close');\n        },\n\n        /**\n         * @param {String} productType\n         * @return {*|String}\n         */\n        getItemRenderer: function (productType) {\n            return this.itemRenderer[productType] || 'defaultRenderer';\n        },\n\n        /**\n         * Update mini shopping cart content.\n         *\n         * @param {Object} updatedCart\n         * @returns void\n         */\n        update: function (updatedCart) {\n            _.each(updatedCart, function (value, key) {\n                if (!this.cart.hasOwnProperty(key)) {\n                    this.cart[key] = ko.observable();\n                }\n                this.cart[key](value);\n            }, this);\n        },\n\n        /**\n         * Get cart param by name.\n         *\n         * @param {String} name\n         * @returns {*}\n         */\n        getCartParamUnsanitizedHtml: function (name) {\n            if (!_.isUndefined(name)) {\n                if (!this.cart.hasOwnProperty(name)) {\n                    this.cart[name] = ko.observable();\n                }\n            }\n\n            return this.cart[name]();\n        },\n\n        /**\n         * @deprecated please use getCartParamUnsanitizedHtml.\n         * @param {String} name\n         * @returns {*}\n         */\n        getCartParam: function (name) {\n            return this.getCartParamUnsanitizedHtml(name);\n        },\n\n        /**\n         * Returns array of cart items, limited by 'maxItemsToDisplay' setting\n         * @returns []\n         */\n        getCartItems: function () {\n            var items = this.getCartParamUnsanitizedHtml('items') || [];\n\n            items = items.slice(parseInt(-this.maxItemsToDisplay, 10));\n\n            return items;\n        },\n\n        /**\n         * Returns count of cart line items\n         * @returns {Number}\n         */\n        getCartLineItemsCount: function () {\n            var items = this.getCartParamUnsanitizedHtml('items') || [];\n\n            return parseInt(items.length, 10);\n        }\n    });\n});\n","Magento_Checkout/js/view/cart-item-renderer.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent'\n], function (Component) {\n    'use strict';\n\n    return Component.extend({\n        /**\n         * Prepare the product name value to be rendered as HTML\n         *\n         * @param {String} productName\n         * @return {String}\n         */\n        getProductNameUnsanitizedHtml: function (productName) {\n            // product name has already escaped on backend\n            return productName;\n        },\n\n        /**\n         * Prepare the given option value to be rendered as HTML\n         *\n         * @param {String} optionValue\n         * @return {String}\n         */\n        getOptionValueUnsanitizedHtml: function (optionValue) {\n            // option value has already escaped on backend\n            return optionValue;\n        }\n    });\n});\n","Magento_Checkout/js/view/sidebar.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'ko',\n    'jquery',\n    'Magento_Checkout/js/model/sidebar'\n], function (Component, ko, $, sidebarModel) {\n    'use strict';\n\n    return Component.extend({\n        /**\n         * @param {HTMLElement} element\n         */\n        setModalElement: function (element) {\n            sidebarModel.setPopup($(element));\n        }\n    });\n});\n","Magento_Checkout/js/view/registration.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'uiComponent',\n    'Magento_Ui/js/model/messageList'\n], function ($, Component, messageList) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/registration',\n            accountCreated: false,\n            creationStarted: false,\n            isFormVisible: true\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initObservable: function () {\n            this._super()\n                .observe('accountCreated')\n                .observe('isFormVisible')\n                .observe('creationStarted');\n\n            return this;\n        },\n\n        /**\n         * @return {*}\n         */\n        getEmailAddress: function () {\n            return this.email;\n        },\n\n        /**\n         * @return String\n         */\n        getUrl: function () {\n            return this.registrationUrl;\n        },\n\n        /**\n         * Create new user account.\n         *\n         * @deprecated\n         */\n        createAccount: function () {\n            this.creationStarted(true);\n            $.post(\n                this.registrationUrl\n            ).done(\n                function (response) {\n\n                    if (response.errors == false) { //eslint-disable-line eqeqeq\n                        this.accountCreated(true);\n                    } else {\n                        messageList.addErrorMessage(response);\n                    }\n                    this.isFormVisible(false);\n                }.bind(this)\n            ).fail(\n                function (response) {\n                    this.accountCreated(false);\n                    this.isFormVisible(false);\n                    messageList.addErrorMessage(response);\n                }.bind(this)\n            );\n        }\n    });\n});\n","Magento_Checkout/js/view/authentication-messages.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/view/messages',\n    'Magento_Checkout/js/model/authentication-messages'\n], function (Component, messageContainer) {\n    'use strict';\n\n    return Component.extend({\n        /** @inheritdoc */\n        initialize: function (config) {\n            return this._super(config, messageContainer);\n        }\n    });\n});\n","Magento_Checkout/js/view/payment.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'uiComponent',\n    'ko',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/step-navigator',\n    'Magento_Checkout/js/model/payment-service',\n    'Magento_Checkout/js/model/payment/method-converter',\n    'Magento_Checkout/js/action/get-payment-information',\n    'Magento_Checkout/js/model/checkout-data-resolver',\n    'mage/translate'\n], function (\n    $,\n    _,\n    Component,\n    ko,\n    quote,\n    stepNavigator,\n    paymentService,\n    methodConverter,\n    getPaymentInformation,\n    checkoutDataResolver,\n    $t\n) {\n    'use strict';\n\n    /** Set payment methods to collection */\n    paymentService.setPaymentMethods(methodConverter(window.checkoutConfig.paymentMethods));\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/payment',\n            activeMethod: ''\n        },\n        isVisible: ko.observable(quote.isVirtual()),\n        quoteIsVirtual: quote.isVirtual(),\n        isPaymentMethodsAvailable: ko.computed(function () {\n            return paymentService.getAvailablePaymentMethods().length > 0;\n        }),\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            checkoutDataResolver.resolvePaymentMethod();\n            stepNavigator.registerStep(\n                'payment',\n                null,\n                $t('Review & Payments'),\n                this.isVisible,\n                _.bind(this.navigate, this),\n                this.sortOrder\n            );\n\n            return this;\n        },\n\n        /**\n         * Navigate method.\n         */\n        navigate: function () {\n            var self = this;\n\n            if (!self.hasShippingMethod()) {\n                this.isVisible(false);\n                stepNavigator.setHash('shipping');\n            } else {\n                getPaymentInformation().done(function () {\n                    self.isVisible(true);\n                });\n            }\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        hasShippingMethod: function () {\n            return window.checkoutConfig.selectedShippingMethod !== null;\n        },\n\n        /**\n         * @return {*}\n         */\n        getFormKey: function () {\n            return window.checkoutConfig.formKey;\n        }\n    });\n});\n","Magento_Checkout/js/view/shipping-information.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'uiComponent',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/step-navigator',\n    'Magento_Checkout/js/model/sidebar'\n], function ($, Component, quote, stepNavigator, sidebarModel) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/shipping-information'\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isVisible: function () {\n            return !quote.isVirtual() && stepNavigator.isProcessed('shipping');\n        },\n\n        /**\n         * @return {String}\n         */\n        getShippingMethodTitle: function () {\n            var shippingMethod = quote.shippingMethod(),\n                shippingMethodTitle = '';\n\n            if (!shippingMethod) {\n                return '';\n            }\n\n            shippingMethodTitle = shippingMethod['carrier_title'];\n\n            if (typeof shippingMethod['method_title'] !== 'undefined') {\n                shippingMethodTitle += ' - ' + shippingMethod['method_title'];\n            }\n\n            return shippingMethodTitle;\n        },\n\n        /**\n         * Back step.\n         */\n        back: function () {\n            sidebarModel.hide();\n            stepNavigator.navigateTo('shipping');\n        },\n\n        /**\n         * Back to shipping method.\n         */\n        backToShippingMethod: function () {\n            sidebarModel.hide();\n            stepNavigator.navigateTo('shipping', 'opc-shipping_method');\n        }\n    });\n});\n","Magento_Checkout/js/view/summary.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Checkout/js/model/totals'\n], function (Component, totals) {\n    'use strict';\n\n    return Component.extend({\n        isLoading: totals.isLoading\n    });\n});\n","Magento_Checkout/js/view/beforePlaceOrder.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @deprecated since version 2.2.0\n */\ndefine(['uiComponent'], function (Component) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            displayArea: 'beforePlaceOrder'\n        }\n    });\n});\n","Magento_Checkout/js/view/shipping.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_Ui/js/form/form',\n    'ko',\n    'Magento_Customer/js/model/customer',\n    'Magento_Customer/js/model/address-list',\n    'Magento_Checkout/js/model/address-converter',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/action/create-shipping-address',\n    'Magento_Checkout/js/action/select-shipping-address',\n    'Magento_Checkout/js/model/shipping-rates-validator',\n    'Magento_Checkout/js/model/shipping-address/form-popup-state',\n    'Magento_Checkout/js/model/shipping-service',\n    'Magento_Checkout/js/action/select-shipping-method',\n    'Magento_Checkout/js/model/shipping-rate-registry',\n    'Magento_Checkout/js/action/set-shipping-information',\n    'Magento_Checkout/js/model/step-navigator',\n    'Magento_Ui/js/modal/modal',\n    'Magento_Checkout/js/model/checkout-data-resolver',\n    'Magento_Checkout/js/checkout-data',\n    'uiRegistry',\n    'mage/translate',\n    'Magento_Checkout/js/model/shipping-rate-service'\n], function (\n    $,\n    _,\n    Component,\n    ko,\n    customer,\n    addressList,\n    addressConverter,\n    quote,\n    createShippingAddress,\n    selectShippingAddress,\n    shippingRatesValidator,\n    formPopUpState,\n    shippingService,\n    selectShippingMethodAction,\n    rateRegistry,\n    setShippingInformationAction,\n    stepNavigator,\n    modal,\n    checkoutDataResolver,\n    checkoutData,\n    registry,\n    $t\n) {\n    'use strict';\n\n    var popUp = null;\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/shipping',\n            shippingFormTemplate: 'Magento_Checkout/shipping-address/form',\n            shippingMethodListTemplate: 'Magento_Checkout/shipping-address/shipping-method-list',\n            shippingMethodItemTemplate: 'Magento_Checkout/shipping-address/shipping-method-item',\n            imports: {\n                countryOptions: '${ $.parentName }.shippingAddress.shipping-address-fieldset.country_id:indexedOptions'\n            }\n        },\n        visible: ko.observable(!quote.isVirtual()),\n        errorValidationMessage: ko.observable(false),\n        isCustomerLoggedIn: customer.isLoggedIn,\n        isFormPopUpVisible: formPopUpState.isVisible,\n        isFormInline: addressList().length === 0,\n        isNewAddressAdded: ko.observable(false),\n        saveInAddressBook: 1,\n        quoteIsVirtual: quote.isVirtual(),\n\n        /**\n         * @return {exports}\n         */\n        initialize: function () {\n            var self = this,\n                hasNewAddress,\n                fieldsetName = 'checkout.steps.shipping-step.shippingAddress.shipping-address-fieldset';\n\n            this._super();\n\n            if (!quote.isVirtual()) {\n                stepNavigator.registerStep(\n                    'shipping',\n                    '',\n                    $t('Shipping'),\n                    this.visible, _.bind(this.navigate, this),\n                    this.sortOrder\n                );\n            }\n            checkoutDataResolver.resolveShippingAddress();\n\n            hasNewAddress = addressList.some(function (address) {\n                return address.getType() == 'new-customer-address'; //eslint-disable-line eqeqeq\n            });\n\n            this.isNewAddressAdded(hasNewAddress);\n\n            this.isFormPopUpVisible.subscribe(function (value) {\n                if (value) {\n                    self.getPopUp().openModal();\n                }\n            });\n\n            quote.shippingMethod.subscribe(function () {\n                self.errorValidationMessage(false);\n            });\n\n            registry.async('checkoutProvider')(function (checkoutProvider) {\n                var shippingAddressData = checkoutData.getShippingAddressFromData();\n\n                if (shippingAddressData) {\n                    checkoutProvider.set(\n                        'shippingAddress',\n                        $.extend(true, {}, checkoutProvider.get('shippingAddress'), shippingAddressData)\n                    );\n                }\n                checkoutProvider.on('shippingAddress', function (shippingAddrsData) {\n                    if (shippingAddrsData.street && !_.isEmpty(shippingAddrsData.street[0])) {\n                        checkoutData.setShippingAddressFromData(shippingAddrsData);\n                    }\n                });\n                shippingRatesValidator.initFields(fieldsetName);\n            });\n\n            return this;\n        },\n\n        /**\n         * Navigator change hash handler.\n         *\n         * @param {Object} step - navigation step\n         */\n        navigate: function (step) {\n            step && step.isVisible(true);\n        },\n\n        /**\n         * @return {*}\n         */\n        getPopUp: function () {\n            var self = this,\n                buttons;\n\n            if (!popUp) {\n                buttons = this.popUpForm.options.buttons;\n                this.popUpForm.options.buttons = [\n                    {\n                        text: buttons.save.text ? buttons.save.text : $t('Save Address'),\n                        class: buttons.save.class ? buttons.save.class : 'action primary action-save-address',\n                        click: self.saveNewAddress.bind(self)\n                    },\n                    {\n                        text: buttons.cancel.text ? buttons.cancel.text : $t('Cancel'),\n                        class: buttons.cancel.class ? buttons.cancel.class : 'action secondary action-hide-popup',\n\n                        /** @inheritdoc */\n                        click: this.onClosePopUp.bind(this)\n                    }\n                ];\n\n                /** @inheritdoc */\n                this.popUpForm.options.closed = function () {\n                    self.isFormPopUpVisible(false);\n                };\n\n                this.popUpForm.options.modalCloseBtnHandler = this.onClosePopUp.bind(this);\n                this.popUpForm.options.keyEventHandlers = {\n                    escapeKey: this.onClosePopUp.bind(this)\n                };\n\n                /** @inheritdoc */\n                this.popUpForm.options.opened = function () {\n                    // Store temporary address for revert action in case when user click cancel action\n                    self.temporaryAddress = $.extend(true, {}, checkoutData.getShippingAddressFromData());\n                };\n                popUp = modal(this.popUpForm.options, $(this.popUpForm.element));\n            }\n\n            return popUp;\n        },\n\n        /**\n         * Revert address and close modal.\n         */\n        onClosePopUp: function () {\n            checkoutData.setShippingAddressFromData($.extend(true, {}, this.temporaryAddress));\n            this.getPopUp().closeModal();\n        },\n\n        /**\n         * Show address form popup\n         */\n        showFormPopUp: function () {\n            this.isFormPopUpVisible(true);\n        },\n\n        /**\n         * Save new shipping address\n         */\n        saveNewAddress: function () {\n            var addressData,\n                newShippingAddress;\n\n            this.source.set('params.invalid', false);\n            this.triggerShippingDataValidateEvent();\n\n            if (!this.source.get('params.invalid')) {\n                addressData = this.source.get('shippingAddress');\n                // if user clicked the checkbox, its value is true or false. Need to convert.\n                addressData['save_in_address_book'] = this.saveInAddressBook ? 1 : 0;\n\n                // New address must be selected as a shipping address\n                newShippingAddress = createShippingAddress(addressData);\n                selectShippingAddress(newShippingAddress);\n                checkoutData.setSelectedShippingAddress(newShippingAddress.getKey());\n                checkoutData.setNewCustomerShippingAddress($.extend(true, {}, addressData));\n                this.getPopUp().closeModal();\n                this.isNewAddressAdded(true);\n            }\n        },\n\n        /**\n         * Shipping Method View\n         */\n        rates: shippingService.getShippingRates(),\n        isLoading: shippingService.isLoading,\n        isSelected: ko.computed(function () {\n            return quote.shippingMethod() ?\n                quote.shippingMethod()['carrier_code'] + '_' + quote.shippingMethod()['method_code'] :\n                null;\n        }),\n\n        /**\n         * @param {Object} shippingMethod\n         * @return {Boolean}\n         */\n        selectShippingMethod: function (shippingMethod) {\n            selectShippingMethodAction(shippingMethod);\n            checkoutData.setSelectedShippingRate(shippingMethod['carrier_code'] + '_' + shippingMethod['method_code']);\n\n            return true;\n        },\n\n        /**\n         * Set shipping information handler\n         */\n        setShippingInformation: function () {\n            if (this.validateShippingInformation()) {\n                quote.billingAddress(null);\n                checkoutDataResolver.resolveBillingAddress();\n                registry.async('checkoutProvider')(function (checkoutProvider) {\n                    var shippingAddressData = checkoutData.getShippingAddressFromData();\n\n                    if (shippingAddressData) {\n                        checkoutProvider.set(\n                            'shippingAddress',\n                            $.extend(true, {}, checkoutProvider.get('shippingAddress'), shippingAddressData)\n                        );\n                    }\n                });\n                setShippingInformationAction().done(\n                    function () {\n                        stepNavigator.next();\n                    }\n                );\n            }\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        validateShippingInformation: function () {\n            var shippingAddress,\n                addressData,\n                loginFormSelector = 'form[data-role=email-with-possible-login]',\n                emailValidationResult = customer.isLoggedIn(),\n                field,\n                option = _.isObject(this.countryOptions) && this.countryOptions[quote.shippingAddress().countryId],\n                messageContainer = registry.get('checkout.errors').messageContainer;\n\n            if (!quote.shippingMethod()) {\n                this.errorValidationMessage(\n                    $t('The shipping method is missing. Select the shipping method and try again.')\n                );\n\n                return false;\n            }\n\n            if (!customer.isLoggedIn()) {\n                $(loginFormSelector).validation();\n                emailValidationResult = Boolean($(loginFormSelector + ' input[name=username]').valid());\n            }\n\n            if (this.isFormInline) {\n                this.source.set('params.invalid', false);\n                this.triggerShippingDataValidateEvent();\n\n                if (!quote.shippingMethod()['method_code']) {\n                    this.errorValidationMessage(\n                        $t('The shipping method is missing. Select the shipping method and try again.')\n                    );\n                }\n\n                if (emailValidationResult &&\n                    this.source.get('params.invalid') ||\n                    !quote.shippingMethod()['method_code'] ||\n                    !quote.shippingMethod()['carrier_code']\n                ) {\n                    this.focusInvalid();\n\n                    return false;\n                }\n\n                shippingAddress = quote.shippingAddress();\n                addressData = addressConverter.formAddressDataToQuoteAddress(\n                    this.source.get('shippingAddress')\n                );\n\n                //Copy form data to quote shipping address object\n                for (field in addressData) {\n                    if (addressData.hasOwnProperty(field) &&  //eslint-disable-line max-depth\n                        shippingAddress.hasOwnProperty(field) &&\n                        typeof addressData[field] != 'function' &&\n                        _.isEqual(shippingAddress[field], addressData[field])\n                    ) {\n                        shippingAddress[field] = addressData[field];\n                    } else if (typeof addressData[field] != 'function' &&\n                        !_.isEqual(shippingAddress[field], addressData[field])) {\n                        shippingAddress = addressData;\n                        break;\n                    }\n                }\n\n                if (customer.isLoggedIn()) {\n                    shippingAddress['save_in_address_book'] = 1;\n                }\n                selectShippingAddress(shippingAddress);\n            } else if (customer.isLoggedIn() &&\n                option &&\n                option['is_region_required'] &&\n                !quote.shippingAddress().region\n            ) {\n                messageContainer.addErrorMessage({\n                    message: $t('Please specify a regionId in shipping address.')\n                });\n\n                return false;\n            }\n\n            if (!emailValidationResult) {\n                $(loginFormSelector + ' input[name=username]').focus();\n\n                return false;\n            }\n\n            return true;\n        },\n\n        /**\n         * Trigger Shipping data Validate Event.\n         */\n        triggerShippingDataValidateEvent: function () {\n            this.source.trigger('shippingAddress.data.validate');\n\n            if (this.source.get('shippingAddress.custom_attributes')) {\n                this.source.trigger('shippingAddress.custom_attributes.data.validate');\n            }\n        }\n    });\n});\n","Magento_Checkout/js/view/authentication.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/form/form',\n    'Magento_Customer/js/action/login',\n    'Magento_Customer/js/model/customer',\n    'mage/validation',\n    'Magento_Checkout/js/model/authentication-messages',\n    'Magento_Checkout/js/model/full-screen-loader'\n], function ($, Component, loginAction, customer, validation, messageContainer, fullScreenLoader) {\n    'use strict';\n\n    var checkoutConfig = window.checkoutConfig;\n\n    return Component.extend({\n        isGuestCheckoutAllowed: checkoutConfig.isGuestCheckoutAllowed,\n        isCustomerLoginRequired: checkoutConfig.isCustomerLoginRequired,\n        registerUrl: checkoutConfig.registerUrl,\n        forgotPasswordUrl: checkoutConfig.forgotPasswordUrl,\n        autocomplete: checkoutConfig.autocomplete,\n        defaults: {\n            template: 'Magento_Checkout/authentication'\n        },\n\n        /**\n         * Is login form enabled for current customer.\n         *\n         * @return {Boolean}\n         */\n        isActive: function () {\n            return !customer.isLoggedIn();\n        },\n\n        /**\n         * Provide login action.\n         *\n         * @param {HTMLElement} loginForm\n         */\n        login: function (loginForm) {\n            var loginData = {},\n                formDataArray = $(loginForm).serializeArray();\n\n            formDataArray.forEach(function (entry) {\n                loginData[entry.name] = entry.value;\n            });\n\n            if ($(loginForm).validation() &&\n                $(loginForm).validation('isValid')\n            ) {\n                fullScreenLoader.startLoader();\n                loginAction(loginData, checkoutConfig.checkoutUrl, undefined, messageContainer).always(function () {\n                    fullScreenLoader.stopLoader();\n                });\n            }\n        }\n    });\n});\n","Magento_Checkout/js/view/billing-address.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'underscore',\n    'Magento_Ui/js/form/form',\n    'Magento_Customer/js/model/customer',\n    'Magento_Customer/js/model/address-list',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/action/create-billing-address',\n    'Magento_Checkout/js/action/select-billing-address',\n    'Magento_Checkout/js/checkout-data',\n    'Magento_Checkout/js/model/checkout-data-resolver',\n    'Magento_Customer/js/customer-data',\n    'Magento_Checkout/js/action/set-billing-address',\n    'Magento_Ui/js/model/messageList',\n    'mage/translate',\n    'Magento_Checkout/js/model/billing-address-postcode-validator',\n    'Magento_Checkout/js/model/address-converter'\n],\nfunction (\n    ko,\n    _,\n    Component,\n    customer,\n    addressList,\n    quote,\n    createBillingAddress,\n    selectBillingAddress,\n    checkoutData,\n    checkoutDataResolver,\n    customerData,\n    setBillingAddressAction,\n    globalMessageList,\n    $t,\n    billingAddressPostcodeValidator,\n    addressConverter\n) {\n    'use strict';\n\n    var lastSelectedBillingAddress = null,\n        addressUpadated = false,\n        addressEdited = false,\n        countryData = customerData.get('directory-data'),\n        addressOptions = addressList().filter(function (address) {\n            return address.getType() === 'customer-address';\n        });\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/billing-address',\n            actionsTemplate: 'Magento_Checkout/billing-address/actions',\n            formTemplate: 'Magento_Checkout/billing-address/form',\n            detailsTemplate: 'Magento_Checkout/billing-address/details',\n            links: {\n                isAddressFormVisible: '${$.billingAddressListProvider}:isNewAddressSelected'\n            }\n        },\n        currentBillingAddress: quote.billingAddress,\n        customerHasAddresses: addressOptions.length > 0,\n\n        /**\n         * Init component\n         */\n        initialize: function () {\n            this._super();\n            quote.paymentMethod.subscribe(function () {\n                checkoutDataResolver.resolveBillingAddress();\n            }, this);\n            billingAddressPostcodeValidator.initFields(this.get('name') + '.form-fields');\n        },\n\n        /**\n         * @return {exports.initObservable}\n         */\n        initObservable: function () {\n            this._super()\n                .observe({\n                    selectedAddress: null,\n                    isAddressDetailsVisible: quote.billingAddress() != null,\n                    isAddressFormVisible: !customer.isLoggedIn() || !addressOptions.length,\n                    isAddressSameAsShipping: false,\n                    saveInAddressBook: 1\n                });\n\n            quote.billingAddress.subscribe(function (newAddress) {\n                if (quote.isVirtual()) {\n                    this.isAddressSameAsShipping(false);\n                } else {\n                    this.isAddressSameAsShipping(\n                        newAddress != null &&\n                        newAddress.getCacheKey() == quote.shippingAddress().getCacheKey() //eslint-disable-line eqeqeq\n                    );\n                }\n\n                if (newAddress != null && newAddress.saveInAddressBook !== undefined) {\n                    this.saveInAddressBook(newAddress.saveInAddressBook);\n                } else {\n                    this.saveInAddressBook(1);\n                }\n                this.isAddressDetailsVisible(true);\n            }, this);\n\n            return this;\n        },\n\n        canUseShippingAddress: ko.computed(function () {\n            return !quote.isVirtual() && quote.shippingAddress() && quote.shippingAddress().canUseForBilling();\n        }),\n\n        /**\n         * @param {Object} address\n         * @return {*}\n         */\n        addressOptionsText: function (address) {\n            return address.getAddressInline();\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        useShippingAddress: function () {\n            if (this.isAddressSameAsShipping()) {\n                selectBillingAddress(quote.shippingAddress());\n\n                this.updateAddresses();\n                this.isAddressDetailsVisible(true);\n            } else {\n                lastSelectedBillingAddress = quote.billingAddress();\n                quote.billingAddress(null);\n                this.isAddressDetailsVisible(false);\n            }\n            checkoutData.setSelectedBillingAddress(null);\n\n            return true;\n        },\n\n        /**\n         * Update address action\n         */\n        updateAddress: function () {\n            var addressData, newBillingAddress;\n\n            addressUpadated = true;\n\n            if (this.selectedAddress() && !this.isAddressFormVisible()) {\n                selectBillingAddress(this.selectedAddress());\n                checkoutData.setSelectedBillingAddress(this.selectedAddress().getKey());\n            } else {\n                this.source.set('params.invalid', false);\n                this.source.trigger(this.dataScopePrefix + '.data.validate');\n\n                if (this.source.get(this.dataScopePrefix + '.custom_attributes')) {\n                    this.source.trigger(this.dataScopePrefix + '.custom_attributes.data.validate');\n                }\n\n                if (!this.source.get('params.invalid')) {\n                    addressData = this.source.get(this.dataScopePrefix);\n\n                    if (customer.isLoggedIn() && !this.customerHasAddresses) { //eslint-disable-line max-depth\n                        this.saveInAddressBook(1);\n                    }\n                    addressData['save_in_address_book'] = this.saveInAddressBook() ? 1 : 0;\n                    newBillingAddress = createBillingAddress(addressData);\n                    // New address must be selected as a billing address\n                    selectBillingAddress(newBillingAddress);\n                    checkoutData.setSelectedBillingAddress(newBillingAddress.getKey());\n                    checkoutData.setNewCustomerBillingAddress(addressData);\n                }\n            }\n            setBillingAddressAction(globalMessageList);\n            this.updateAddresses();\n        },\n\n        /**\n         * Edit address action\n         */\n        editAddress: function () {\n            addressUpadated = false;\n            addressEdited = true;\n            lastSelectedBillingAddress = quote.billingAddress();\n            quote.billingAddress(null);\n            this.isAddressDetailsVisible(false);\n        },\n\n        /**\n         * Cancel address edit action\n         */\n        cancelAddressEdit: function () {\n            addressUpadated = true;\n            this.restoreBillingAddress();\n\n            if (quote.billingAddress()) {\n                // restore 'Same As Shipping' checkbox state\n                this.isAddressSameAsShipping(\n                    quote.billingAddress() != null &&\n                        quote.billingAddress().getCacheKey() == quote.shippingAddress().getCacheKey() && //eslint-disable-line\n                        !quote.isVirtual()\n                );\n                this.isAddressDetailsVisible(true);\n            }\n        },\n\n        /**\n         * Manage cancel button visibility\n         */\n        canUseCancelBillingAddress: ko.computed(function () {\n            return quote.billingAddress() || lastSelectedBillingAddress;\n        }),\n\n        /**\n         * Check if Billing Address Changes should be canceled\n         */\n        needCancelBillingAddressChanges: function () {\n            if (addressEdited && !addressUpadated) {\n                this.cancelAddressEdit();\n            }\n        },\n\n        /**\n         * Restore billing address\n         */\n        restoreBillingAddress: function () {\n            var lastBillingAddress;\n\n            if (lastSelectedBillingAddress != null) {\n                selectBillingAddress(lastSelectedBillingAddress);\n                lastBillingAddress = addressConverter.quoteAddressToFormAddressData(lastSelectedBillingAddress);\n\n                checkoutData.setNewCustomerBillingAddress(lastBillingAddress);\n            }\n        },\n\n        /**\n         * @param {Number} countryId\n         * @return {*}\n         */\n        getCountryName: function (countryId) {\n            return countryData()[countryId] != undefined ? countryData()[countryId].name : ''; //eslint-disable-line\n        },\n\n        /**\n         * Trigger action to update shipping and billing addresses\n         */\n        updateAddresses: function () {\n            if (window.checkoutConfig.reloadOnBillingAddress ||\n                !window.checkoutConfig.displayBillingOnPaymentMethod\n            ) {\n                setBillingAddressAction(globalMessageList);\n            }\n        },\n\n        /**\n         * Get code\n         * @param {Object} parent\n         * @returns {String}\n         */\n        getCode: function (parent) {\n            return _.isFunction(parent.getCode) ? parent.getCode() : 'shared';\n        },\n\n        /**\n         * Get customer attribute label\n         *\n         * @param {*} attribute\n         * @returns {*}\n         */\n        getCustomAttributeLabel: function (attribute) {\n            var label;\n\n            if (typeof attribute === 'string') {\n                return attribute;\n            }\n\n            if (attribute.label) {\n                return attribute.label;\n            }\n\n            if (_.isArray(attribute.value)) {\n                label = _.map(attribute.value, function (value) {\n                    return this.getCustomAttributeOptionLabel(attribute['attribute_code'], value) || value;\n                }, this).join(', ');\n            } else {\n                label = this.getCustomAttributeOptionLabel(attribute['attribute_code'], attribute.value);\n            }\n\n            return label || attribute.value;\n        },\n\n        /**\n         * Get option label for given attribute code and option ID\n         *\n         * @param {String} attributeCode\n         * @param {String} value\n         * @returns {String|null}\n         */\n        getCustomAttributeOptionLabel: function (attributeCode, value) {\n            var option,\n                label,\n                options = this.source.get('customAttributes') || {};\n\n            if (options[attributeCode]) {\n                option = _.findWhere(options[attributeCode], {\n                    value: value\n                });\n\n                if (option) {\n                    label = option.label;\n                }\n            }\n\n            return label;\n        }\n    });\n});\n","Magento_Checkout/js/view/form/element/email.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'uiComponent',\n    'ko',\n    'Magento_Customer/js/model/customer',\n    'Magento_Customer/js/action/check-email-availability',\n    'Magento_Customer/js/action/login',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/checkout-data',\n    'Magento_Checkout/js/model/full-screen-loader',\n    'mage/validation'\n], function ($, Component, ko, customer, checkEmailAvailability, loginAction, quote, checkoutData, fullScreenLoader) {\n    'use strict';\n\n    var validatedEmail;\n\n    if (!checkoutData.getValidatedEmailValue() &&\n        window.checkoutConfig.validatedEmailValue\n    ) {\n        checkoutData.setInputFieldEmailValue(window.checkoutConfig.validatedEmailValue);\n        checkoutData.setValidatedEmailValue(window.checkoutConfig.validatedEmailValue);\n    }\n\n    validatedEmail = checkoutData.getValidatedEmailValue();\n\n    if (validatedEmail && !customer.isLoggedIn()) {\n        quote.guestEmail = validatedEmail;\n    }\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/form/element/email',\n            email: checkoutData.getInputFieldEmailValue(),\n            emailFocused: false,\n            isLoading: false,\n            isPasswordVisible: false,\n            listens: {\n                email: 'emailHasChanged',\n                emailFocused: 'validateEmail'\n            },\n            ignoreTmpls: {\n                email: true\n            }\n        },\n        checkDelay: 2000,\n        checkRequest: null,\n        isEmailCheckComplete: null,\n        isCustomerLoggedIn: customer.isLoggedIn,\n        forgotPasswordUrl: window.checkoutConfig.forgotPasswordUrl,\n        emailCheckTimeout: 0,\n\n        /**\n         * Initializes regular properties of instance.\n         *\n         * @returns {Object} Chainable.\n         */\n        initConfig: function () {\n            this._super();\n\n            this.isPasswordVisible = this.resolveInitialPasswordVisibility();\n\n            return this;\n        },\n\n        /**\n         * Initializes observable properties of instance\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe(['email', 'emailFocused', 'isLoading', 'isPasswordVisible']);\n\n            return this;\n        },\n\n        /**\n         * Callback on changing email property\n         */\n        emailHasChanged: function () {\n            var self = this;\n\n            clearTimeout(this.emailCheckTimeout);\n\n            if (self.validateEmail()) {\n                quote.guestEmail = self.email();\n                checkoutData.setValidatedEmailValue(self.email());\n            }\n            this.emailCheckTimeout = setTimeout(function () {\n                if (self.validateEmail()) {\n                    self.checkEmailAvailability();\n                } else {\n                    self.isPasswordVisible(false);\n                }\n            }, self.checkDelay);\n\n            checkoutData.setInputFieldEmailValue(self.email());\n        },\n\n        /**\n         * Check email existing.\n         */\n        checkEmailAvailability: function () {\n            this.validateRequest();\n            this.isEmailCheckComplete = $.Deferred();\n            this.isLoading(true);\n            this.checkRequest = checkEmailAvailability(this.isEmailCheckComplete, this.email());\n\n            $.when(this.isEmailCheckComplete).done(function () {\n                this.isPasswordVisible(false);\n                checkoutData.setCheckedEmailValue('');\n            }.bind(this)).fail(function () {\n                this.isPasswordVisible(true);\n                checkoutData.setCheckedEmailValue(this.email());\n            }.bind(this)).always(function () {\n                this.isLoading(false);\n            }.bind(this));\n        },\n\n        /**\n         * If request has been sent -> abort it.\n         * ReadyStates for request aborting:\n         * 1 - The request has been set up\n         * 2 - The request has been sent\n         * 3 - The request is in process\n         */\n        validateRequest: function () {\n            if (this.checkRequest != null && $.inArray(this.checkRequest.readyState, [1, 2, 3])) {\n                this.checkRequest.abort();\n                this.checkRequest = null;\n            }\n        },\n\n        /**\n         * Local email validation.\n         *\n         * @param {Boolean} focused - input focus.\n         * @returns {Boolean} - validation result.\n         */\n        validateEmail: function (focused) {\n            var loginFormSelector = 'form[data-role=email-with-possible-login]',\n                usernameSelector = loginFormSelector + ' input[name=username]',\n                loginForm = $(loginFormSelector),\n                validator,\n                valid;\n\n            loginForm.validation();\n\n            if (focused === false && !!this.email()) {\n                valid = !!$(usernameSelector).valid();\n\n                if (valid) {\n                    $(usernameSelector).removeAttr('aria-invalid aria-describedby');\n                }\n\n                return valid;\n            }\n\n            if (loginForm.is(':visible')) {\n                validator = loginForm.validate();\n\n                return validator.check(usernameSelector);\n            }\n\n            return true;\n        },\n\n        /**\n         * Log in form submitting callback.\n         *\n         * @param {HTMLElement} loginForm - form element.\n         */\n        login: function (loginForm) {\n            var loginData = {},\n                formDataArray = $(loginForm).serializeArray();\n\n            formDataArray.forEach(function (entry) {\n                loginData[entry.name] = entry.value;\n            });\n\n            if (this.isPasswordVisible() && $(loginForm).validation() && $(loginForm).validation('isValid')) {\n                fullScreenLoader.startLoader();\n                loginAction(loginData).always(function () {\n                    fullScreenLoader.stopLoader();\n                });\n            }\n        },\n\n        /**\n         * Resolves an initial state of a login form.\n         *\n         * @returns {Boolean} - initial visibility state.\n         */\n        resolveInitialPasswordVisibility: function () {\n            if (checkoutData.getInputFieldEmailValue() !== '' && checkoutData.getCheckedEmailValue() !== '') {\n                return true;\n            }\n\n            if (checkoutData.getInputFieldEmailValue() !== '') {\n                return checkoutData.getInputFieldEmailValue() === checkoutData.getCheckedEmailValue();\n            }\n\n            return false;\n        }\n    });\n});\n","Magento_Checkout/js/view/configure/product-customer-data.js":"require([\n    'jquery',\n    'Magento_Customer/js/customer-data',\n    'underscore',\n    'domReady!'\n], function ($, customerData, _) {\n    'use strict';\n\n    var selectors = {\n        qtySelector: '#product_addtocart_form [name=\"qty\"]',\n        productIdSelector: '#product_addtocart_form [name=\"product\"]',\n        itemIdSelector: '#product_addtocart_form [name=\"item\"]'\n    },\n    cartData = customerData.get('cart'),\n    productId = $(selectors.productIdSelector).val(),\n    itemId = $(selectors.itemIdSelector).val(),\n    productQty,\n    productQtyInput,\n\n    /**\n    * Updates product's qty input value according to actual data\n    */\n    updateQty = function () {\n\n        if (productQty || productQty === 0) {\n            productQtyInput = productQtyInput || $(selectors.qtySelector);\n\n            if (productQtyInput && productQty.toString() !== productQtyInput.val()) {\n                productQtyInput.val(productQty);\n            }\n        }\n    },\n\n    /**\n    * Sets productQty according to cart data from customer-data\n    *\n    * @param {Object} data - cart data from customer-data\n    */\n    setProductQty = function (data) {\n        var product;\n\n        if (!(data && data.items && data.items.length && productId)) {\n            return;\n        }\n        product = _.find(data.items, function (item) {\n            if (item['item_id'] === itemId) {\n                return item['product_id'] === productId ||\n                    item['item_id'] === productId;\n            }\n        });\n\n        if (!product) {\n            return;\n        }\n        productQty = product.qty;\n    };\n\n    cartData.subscribe(function (updateCartData) {\n        setProductQty(updateCartData);\n        updateQty();\n    });\n\n    setProductQty(cartData());\n    updateQty();\n});\n","Magento_Checkout/js/view/shipping-address/list.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'ko',\n    'mageUtils',\n    'uiComponent',\n    'uiLayout',\n    'Magento_Customer/js/model/address-list'\n], function (_, ko, utils, Component, layout, addressList) {\n    'use strict';\n\n    var defaultRendererTemplate = {\n        parent: '${ $.$data.parentName }',\n        name: '${ $.$data.name }',\n        component: 'Magento_Checkout/js/view/shipping-address/address-renderer/default',\n        provider: 'checkoutProvider'\n    };\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/shipping-address/list',\n            visible: addressList().length > 0,\n            rendererTemplates: []\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super()\n                .initChildren();\n\n            addressList.subscribe(function (changes) {\n                    var self = this;\n\n                    changes.forEach(function (change) {\n                        if (change.status === 'added') {\n                            self.createRendererComponent(change.value, change.index);\n                        }\n                    });\n                },\n                this,\n                'arrayChange'\n            );\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        initConfig: function () {\n            this._super();\n            // the list of child components that are responsible for address rendering\n            this.rendererComponents = [];\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        initChildren: function () {\n            _.each(addressList(), this.createRendererComponent, this);\n\n            return this;\n        },\n\n        /**\n         * Create new component that will render given address in the address list\n         *\n         * @param {Object} address\n         * @param {*} index\n         */\n        createRendererComponent: function (address, index) {\n            var rendererTemplate, templateData, rendererComponent;\n\n            if (index in this.rendererComponents) {\n                this.rendererComponents[index].address(address);\n            } else {\n                // rendererTemplates are provided via layout\n                rendererTemplate = address.getType() != undefined && this.rendererTemplates[address.getType()] != undefined ? //eslint-disable-line\n                    utils.extend({}, defaultRendererTemplate, this.rendererTemplates[address.getType()]) :\n                    defaultRendererTemplate;\n                templateData = {\n                    parentName: this.name,\n                    name: index\n                };\n                rendererComponent = utils.template(rendererTemplate, templateData);\n                utils.extend(rendererComponent, {\n                    address: ko.observable(address)\n                });\n                layout([rendererComponent]);\n                this.rendererComponents[index] = rendererComponent;\n            }\n        }\n    });\n});\n","Magento_Checkout/js/view/shipping-address/address-renderer/default.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'ko',\n    'uiComponent',\n    'underscore',\n    'Magento_Checkout/js/action/select-shipping-address',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/shipping-address/form-popup-state',\n    'Magento_Checkout/js/checkout-data',\n    'Magento_Customer/js/customer-data'\n], function ($, ko, Component, _, selectShippingAddressAction, quote, formPopUpState, checkoutData, customerData) {\n    'use strict';\n\n    var countryData = customerData.get('directory-data');\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/shipping-address/address-renderer/default'\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super();\n            this.isSelected = ko.computed(function () {\n                var isSelected = false,\n                    shippingAddress = quote.shippingAddress();\n\n                if (shippingAddress) {\n                    isSelected = shippingAddress.getKey() == this.address().getKey(); //eslint-disable-line eqeqeq\n                }\n\n                return isSelected;\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * @param {String} countryId\n         * @return {String}\n         */\n        getCountryName: function (countryId) {\n            return countryData()[countryId] != undefined ? countryData()[countryId].name : ''; //eslint-disable-line\n        },\n\n        /**\n         * Get customer attribute label\n         *\n         * @param {*} attribute\n         * @returns {*}\n         */\n        getCustomAttributeLabel: function (attribute) {\n            var label;\n\n            if (typeof attribute === 'string') {\n                return attribute;\n            }\n\n            if (attribute.label) {\n                return attribute.label;\n            }\n\n            if (_.isArray(attribute.value)) {\n                label = _.map(attribute.value, function (value) {\n                    return this.getCustomAttributeOptionLabel(attribute['attribute_code'], value) || value;\n                }, this).join(', ');\n            } else {\n                label = this.getCustomAttributeOptionLabel(attribute['attribute_code'], attribute.value);\n            }\n\n            return label || attribute.value;\n        },\n\n        /**\n         * Get option label for given attribute code and option ID\n         *\n         * @param {String} attributeCode\n         * @param {String} value\n         * @returns {String|null}\n         */\n        getCustomAttributeOptionLabel: function (attributeCode, value) {\n            var option,\n                label,\n                options = this.source.get('customAttributes') || {};\n\n            if (options[attributeCode]) {\n                option = _.findWhere(options[attributeCode], {\n                    value: value\n                });\n\n                if (option) {\n                    label = option.label;\n                }\n            }\n\n            return label;\n        },\n\n        /** Set selected customer shipping address  */\n        selectAddress: function () {\n            selectShippingAddressAction(this.address());\n            checkoutData.setSelectedShippingAddress(this.address().getKey());\n        },\n\n        /**\n         * Edit address.\n         */\n        editAddress: function () {\n            formPopUpState.isVisible(true);\n            this.showPopup();\n\n        },\n\n        /**\n         * Show popup.\n         */\n        showPopup: function () {\n            $('[data-open-modal=\"opc-new-shipping-address\"]').trigger('click');\n        }\n    });\n});\n","Magento_Checkout/js/view/payment/list.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'ko',\n    'mageUtils',\n    'uiComponent',\n    'Magento_Checkout/js/model/payment/method-list',\n    'Magento_Checkout/js/model/payment/renderer-list',\n    'uiLayout',\n    'Magento_Checkout/js/model/checkout-data-resolver',\n    'mage/translate',\n    'uiRegistry'\n], function (_, ko, utils, Component, paymentMethods, rendererList, layout, checkoutDataResolver, $t, registry) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/payment-methods/list',\n            visible: paymentMethods().length > 0,\n            configDefaultGroup: {\n                name: 'methodGroup',\n                component: 'Magento_Checkout/js/model/payment/method-group'\n            },\n            paymentGroupsList: [],\n            defaultGroupTitle: $t('Select a new payment method')\n        },\n\n        /**\n         * Initialize view.\n         *\n         * @returns {Component} Chainable.\n         */\n        initialize: function () {\n            this._super().initDefaulGroup().initChildren();\n            paymentMethods.subscribe(\n                function (changes) {\n                    checkoutDataResolver.resolvePaymentMethod();\n                    //remove renderer for \"deleted\" payment methods\n                    _.each(changes, function (change) {\n                        if (change.status === 'deleted') {\n                            this.removeRenderer(change.value.method);\n                        }\n                    }, this);\n                    //add renderer for \"added\" payment methods\n                    _.each(changes, function (change) {\n                        if (change.status === 'added') {\n                            this.createRenderer(change.value);\n                        }\n                    }, this);\n                }, this, 'arrayChange');\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super().\n                observe(['paymentGroupsList']);\n\n            return this;\n        },\n\n        /**\n         * Creates default group\n         *\n         * @returns {Component} Chainable.\n         */\n        initDefaulGroup: function () {\n            layout([\n                this.configDefaultGroup\n            ]);\n\n            return this;\n        },\n\n        /**\n         * Create renders for child payment methods.\n         *\n         * @returns {Component} Chainable.\n         */\n        initChildren: function () {\n            var self = this;\n\n            _.each(paymentMethods(), function (paymentMethodData) {\n                self.createRenderer(paymentMethodData);\n            });\n\n            return this;\n        },\n\n        /**\n         * @returns\n         */\n        createComponent: function (payment) {\n            var rendererTemplate,\n                rendererComponent,\n                templateData;\n\n            templateData = {\n                parentName: this.name,\n                name: payment.name\n            };\n            rendererTemplate = {\n                parent: '${ $.$data.parentName }',\n                name: '${ $.$data.name }',\n                displayArea: payment.displayArea,\n                component: payment.component\n            };\n            rendererComponent = utils.template(rendererTemplate, templateData);\n            utils.extend(rendererComponent, {\n                item: payment.item,\n                config: payment.config\n            });\n\n            return rendererComponent;\n        },\n\n        /**\n         * Create renderer.\n         *\n         * @param {Object} paymentMethodData\n         */\n        createRenderer: function (paymentMethodData) {\n            var isRendererForMethod = false,\n                currentGroup;\n\n            registry.get(this.configDefaultGroup.name, function (defaultGroup) {\n                _.each(rendererList(), function (renderer) {\n\n                    if (renderer.hasOwnProperty('typeComparatorCallback') &&\n                        typeof renderer.typeComparatorCallback == 'function'\n                    ) {\n                        isRendererForMethod = renderer.typeComparatorCallback(renderer.type, paymentMethodData.method);\n                    } else {\n                        isRendererForMethod = renderer.type === paymentMethodData.method;\n                    }\n\n                    if (isRendererForMethod) {\n                        currentGroup = renderer.group ? renderer.group : defaultGroup;\n\n                        this.collectPaymentGroups(currentGroup);\n\n                        layout([\n                            this.createComponent(\n                                {\n                                    config: renderer.config,\n                                    component: renderer.component,\n                                    name: renderer.type,\n                                    method: paymentMethodData.method,\n                                    item: paymentMethodData,\n                                    displayArea: currentGroup.displayArea\n                                }\n                            )]);\n                    }\n                }.bind(this));\n            }.bind(this));\n        },\n\n        /**\n         * Collects unique groups of available payment methods\n         *\n         * @param {Object} group\n         */\n        collectPaymentGroups: function (group) {\n            var groupsList = this.paymentGroupsList(),\n                isGroupExists = _.some(groupsList, function (existsGroup) {\n                    return existsGroup.alias === group.alias;\n                });\n\n            if (!isGroupExists) {\n                groupsList.push(group);\n                groupsList = _.sortBy(groupsList, function (existsGroup) {\n                    return existsGroup.sortOrder;\n                });\n                this.paymentGroupsList(groupsList);\n            }\n        },\n\n        /**\n         * Returns payment group title\n         *\n         * @param {Object} group\n         * @returns {String}\n         */\n        getGroupTitle: function (group) {\n            var title = group().title;\n\n            if (group().isDefault() && this.paymentGroupsList().length > 1) {\n                title = this.defaultGroupTitle;\n            }\n\n            return title;\n        },\n\n        /**\n         * Checks if at least one payment method available\n         *\n         * @returns {String}\n         */\n        isPaymentMethodsAvailable: function () {\n            return _.some(this.paymentGroupsList(), function (group) {\n                return this.regionHasElements(group.displayArea);\n            }, this);\n        },\n\n        /**\n         * Remove view renderer.\n         *\n         * @param {String} paymentMethodCode\n         */\n        removeRenderer: function (paymentMethodCode) {\n            var items;\n\n            _.each(this.paymentGroupsList(), function (group) {\n                items = this.getRegion(group.displayArea);\n\n                _.find(items(), function (value) {\n                    if (value.item.method.indexOf(paymentMethodCode) === 0) {\n                        value.disposeSubscriptions();\n                        value.destroy();\n                    }\n                });\n            }, this);\n        }\n    });\n});\n","Magento_Checkout/js/view/payment/email-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'uiComponent',\n        'Magento_Checkout/js/model/payment/additional-validators',\n        'Magento_Checkout/js/model/customer-email-validator'\n    ],\n    function (Component, additionalValidators, agreementValidator) {\n        'use strict';\n\n        additionalValidators.registerValidator(agreementValidator);\n\n        return Component.extend({});\n    }\n);\n","Magento_Checkout/js/view/payment/default.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'jquery',\n    'uiComponent',\n    'Magento_Checkout/js/action/place-order',\n    'Magento_Checkout/js/action/select-payment-method',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Customer/js/model/customer',\n    'Magento_Checkout/js/model/payment-service',\n    'Magento_Checkout/js/checkout-data',\n    'Magento_Checkout/js/model/checkout-data-resolver',\n    'uiRegistry',\n    'Magento_Checkout/js/model/payment/additional-validators',\n    'Magento_Ui/js/model/messages',\n    'uiLayout',\n    'Magento_Checkout/js/action/redirect-on-success'\n], function (\n    ko,\n    $,\n    Component,\n    placeOrderAction,\n    selectPaymentMethodAction,\n    quote,\n    customer,\n    paymentService,\n    checkoutData,\n    checkoutDataResolver,\n    registry,\n    additionalValidators,\n    Messages,\n    layout,\n    redirectOnSuccessAction\n) {\n    'use strict';\n\n    return Component.extend({\n        redirectAfterPlaceOrder: true,\n        isPlaceOrderActionAllowed: ko.observable(quote.billingAddress() != null),\n\n        /**\n         * After place order callback\n         */\n        afterPlaceOrder: function () {\n            // Override this function and put after place order logic here\n        },\n\n        /**\n         * Initialize view.\n         *\n         * @return {exports}\n         */\n        initialize: function () {\n            var billingAddressCode,\n                billingAddressData,\n                defaultAddressData;\n\n            this._super().initChildren();\n            quote.billingAddress.subscribe(function (address) {\n                this.isPlaceOrderActionAllowed(address !== null);\n            }, this);\n            checkoutDataResolver.resolveBillingAddress();\n\n            billingAddressCode = 'billingAddress' + this.getCode();\n            registry.async('checkoutProvider')(function (checkoutProvider) {\n                defaultAddressData = checkoutProvider.get(billingAddressCode);\n\n                if (defaultAddressData === undefined) {\n                    // Skip if payment does not have a billing address form\n                    return;\n                }\n                billingAddressData = checkoutData.getBillingAddressFromData();\n\n                if (billingAddressData) {\n                    checkoutProvider.set(\n                        billingAddressCode,\n                        $.extend(true, {}, defaultAddressData, billingAddressData)\n                    );\n                }\n                checkoutProvider.on(billingAddressCode, function (providerBillingAddressData) {\n                    checkoutData.setBillingAddressFromData(providerBillingAddressData);\n                }, billingAddressCode);\n            });\n\n            return this;\n        },\n\n        /**\n         * Initialize child elements\n         *\n         * @returns {Component} Chainable.\n         */\n        initChildren: function () {\n            this.messageContainer = new Messages();\n            this.createMessagesComponent();\n\n            return this;\n        },\n\n        /**\n         * Create child message renderer component\n         *\n         * @returns {Component} Chainable.\n         */\n        createMessagesComponent: function () {\n\n            var messagesComponent = {\n                parent: this.name,\n                name: this.name + '.messages',\n                displayArea: 'messages',\n                component: 'Magento_Ui/js/view/messages',\n                config: {\n                    messageContainer: this.messageContainer\n                }\n            };\n\n            layout([messagesComponent]);\n\n            return this;\n        },\n\n        /**\n         * Place order.\n         */\n        placeOrder: function (data, event) {\n            var self = this;\n\n            if (event) {\n                event.preventDefault();\n            }\n\n            if (this.validate() &&\n                additionalValidators.validate() &&\n                this.isPlaceOrderActionAllowed() === true\n            ) {\n                this.isPlaceOrderActionAllowed(false);\n\n                this.getPlaceOrderDeferredObject()\n                    .done(\n                        function () {\n                            self.afterPlaceOrder();\n\n                            if (self.redirectAfterPlaceOrder) {\n                                redirectOnSuccessAction.execute();\n                            }\n                        }\n                    ).always(\n                        function () {\n                            self.isPlaceOrderActionAllowed(true);\n                        }\n                    );\n\n                return true;\n            }\n\n            return false;\n        },\n\n        /**\n         * @return {*}\n         */\n        getPlaceOrderDeferredObject: function () {\n            return $.when(\n                placeOrderAction(this.getData(), this.messageContainer)\n            );\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        selectPaymentMethod: function () {\n            selectPaymentMethodAction(this.getData());\n            checkoutData.setSelectedPaymentMethod(this.item.method);\n\n            return true;\n        },\n\n        isChecked: ko.computed(function () {\n            return quote.paymentMethod() ? quote.paymentMethod().method : null;\n        }),\n\n        isRadioButtonVisible: ko.computed(function () {\n            return paymentService.getAvailablePaymentMethods().length !== 1;\n        }),\n\n        /**\n         * Get payment method data\n         */\n        getData: function () {\n            return {\n                'method': this.item.method,\n                'po_number': null,\n                'additional_data': null\n            };\n        },\n\n        /**\n         * Get payment method type.\n         */\n        getTitle: function () {\n            return this.item.title;\n        },\n\n        /**\n         * Get payment method code.\n         */\n        getCode: function () {\n            return this.item.method;\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        validate: function () {\n            return true;\n        },\n\n        /**\n         * @return {String}\n         */\n        getBillingAddressFormName: function () {\n            return 'billing-address-form-' + this.item.method;\n        },\n\n        /**\n         * Dispose billing address subscriptions\n         */\n        disposeSubscriptions: function () {\n            // dispose all active subscriptions\n            var billingAddressCode = 'billingAddress' + this.getCode();\n\n            registry.async('checkoutProvider')(function (checkoutProvider) {\n                checkoutProvider.off(billingAddressCode);\n            });\n        }\n    });\n});\n","Magento_Checkout/js/view/shipping-information/list.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'ko',\n    'mageUtils',\n    'uiComponent',\n    'uiLayout',\n    'Magento_Checkout/js/model/quote'\n], function ($, ko, utils, Component, layout, quote) {\n    'use strict';\n\n    var defaultRendererTemplate = {\n        parent: '${ $.$data.parentName }',\n        name: '${ $.$data.name }',\n        component: 'Magento_Checkout/js/view/shipping-information/address-renderer/default',\n        provider: 'checkoutProvider'\n    };\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/shipping-information/list',\n            rendererTemplates: {}\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            var self = this;\n\n            this._super()\n                .initChildren();\n\n            quote.shippingAddress.subscribe(function (address) {\n                self.createRendererComponent(address);\n            });\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        initConfig: function () {\n            this._super();\n            // the list of child components that are responsible for address rendering\n            this.rendererComponents = {};\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        initChildren: function () {\n            return this;\n        },\n\n        /**\n         * Create new component that will render given address in the address list\n         *\n         * @param {Object} address\n         */\n        createRendererComponent: function (address) {\n            var rendererTemplate, templateData, rendererComponent;\n\n            $.each(this.rendererComponents, function (index, component) {\n                component.visible(false);\n            });\n\n            if (this.rendererComponents[address.getType()]) {\n                this.rendererComponents[address.getType()].address(address);\n                this.rendererComponents[address.getType()].visible(true);\n            } else {\n                // rendererTemplates are provided via layout\n                rendererTemplate = address.getType() != undefined && this.rendererTemplates[address.getType()] != undefined ? //eslint-disable-line\n                    utils.extend({}, defaultRendererTemplate, this.rendererTemplates[address.getType()]) :\n                    defaultRendererTemplate;\n                templateData = {\n                    parentName: this.name,\n                    name: address.getType()\n                };\n\n                rendererComponent = utils.template(rendererTemplate, templateData);\n                utils.extend(\n                    rendererComponent,\n                    {\n                        address: ko.observable(address),\n                        visible: ko.observable(true)\n                    }\n                );\n                layout([rendererComponent]);\n                this.rendererComponents[address.getType()] = rendererComponent;\n            }\n        }\n    });\n});\n","Magento_Checkout/js/view/shipping-information/address-renderer/default.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'underscore',\n    'Magento_Customer/js/customer-data'\n], function (Component, _, customerData) {\n    'use strict';\n\n    var countryData = customerData.get('directory-data');\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/shipping-information/address-renderer/default'\n        },\n\n        /**\n         * @param {*} countryId\n         * @return {String}\n         */\n        getCountryName: function (countryId) {\n            return countryData()[countryId] != undefined ? countryData()[countryId].name : ''; //eslint-disable-line\n        },\n\n        /**\n         * Get customer attribute label\n         *\n         * @param {*} attribute\n         * @returns {*}\n         */\n        getCustomAttributeLabel: function (attribute) {\n            var label;\n\n            if (typeof attribute === 'string') {\n                return attribute;\n            }\n\n            if (attribute.label) {\n                return attribute.label;\n            }\n\n            if (_.isArray(attribute.value)) {\n                label = _.map(attribute.value, function (value) {\n                    return this.getCustomAttributeOptionLabel(attribute['attribute_code'], value) || value;\n                }, this).join(', ');\n            } else {\n                label = this.getCustomAttributeOptionLabel(attribute['attribute_code'], attribute.value);\n            }\n\n            return label || attribute.value;\n        },\n\n        /**\n         * Get option label for given attribute code and option ID\n         *\n         * @param {String} attributeCode\n         * @param {String} value\n         * @returns {String|null}\n         */\n        getCustomAttributeOptionLabel: function (attributeCode, value) {\n            var option,\n                label,\n                options = this.source.get('customAttributes') || {};\n\n            if (options[attributeCode]) {\n                option = _.findWhere(options[attributeCode], {\n                    value: value\n                });\n\n                if (option) {\n                    label = option.label;\n                }\n            }\n\n            return label;\n        }\n    });\n});\n","Magento_Checkout/js/view/checkout/placeOrderCaptcha.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Captcha/js/view/checkout/defaultCaptcha',\n    'Magento_Captcha/js/model/captchaList',\n    'underscore',\n    'Magento_Checkout/js/model/payment/place-order-hooks'\n],\nfunction (defaultCaptcha, captchaList, _, placeOrderHooks) {\n    'use strict';\n\n    return defaultCaptcha.extend({\n        /** @inheritdoc */\n        initialize: function () {\n            var self = this,\n                currentCaptcha;\n\n            this._super();\n            currentCaptcha = captchaList.getCaptchaByFormId(this.formId);\n\n            if (currentCaptcha != null) {\n                currentCaptcha.setIsVisible(true);\n                this.setCurrentCaptcha(currentCaptcha);\n                placeOrderHooks.requestModifiers.push(function (headers) {\n                    if (self.isRequired()) {\n                        headers['X-Captcha'] = self.captchaValue()();\n                    }\n                });\n                placeOrderHooks.afterRequestListeners.push(function () {\n                    self.refresh();\n                });\n            }\n        }\n    });\n});\n","Magento_Checkout/js/view/checkout/minicart/subtotal/totals.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'uiComponent',\n    'Magento_Customer/js/customer-data'\n], function (ko, Component, customerData) {\n    'use strict';\n\n    return Component.extend({\n        displaySubtotal: ko.observable(true),\n\n        /**\n         * @override\n         */\n        initialize: function () {\n            this._super();\n            this.cart = customerData.get('cart');\n        }\n    });\n});\n","Magento_Checkout/js/view/review/actions.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @deprecated since version 2.2.0\n */\ndefine([\n    'uiComponent',\n    'Magento_Checkout/js/model/quote',\n    'underscore'\n], function (Component, quote, _) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/review/actions',\n            displayArea: 'actions'\n        },\n\n        /**\n         * @return {*}\n         */\n        getActiveView: function () {\n            var view = this.getViewByCode(quote.paymentMethod());\n\n            return view ? view : this.getDefaultView();\n        },\n\n        /**\n         * @param {*} code\n         * @return {Object}\n         */\n        getViewByCode: function (code) {\n            return _.find(this.elems(), function (elem) {\n                return elem.index == code && !elem.isDefault; //eslint-disable-line eqeqeq\n            });\n        },\n\n        /**\n         * Get default view.\n         *\n         * @return {Object}\n         */\n        getDefaultView: function () {\n            return _.find(this.elems(), function (elem) {\n                return elem.isDefault;\n            });\n        }\n    });\n});\n","Magento_Checkout/js/view/review/actions/default.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @deprecated since version 2.2.0\n */\ndefine([\n    'uiComponent'\n], function (Component) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/review/actions/default'\n        },\n\n        /**\n         * @param {Object} parent\n         * @return {Function}\n         */\n        placeOrder: function (parent) {\n            return parent.placeOrder.bind(parent);\n        }\n    });\n});\n","Magento_Checkout/js/view/billing-address/list.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Customer/js/model/address-list',\n    'mage/translate',\n    'Magento_Customer/js/model/customer'\n], function (Component, addressList, $t, customer) {\n    'use strict';\n\n    var newAddressOption = {\n            /**\n             * Get new address label\n             * @returns {String}\n             */\n            getAddressInline: function () {\n                return $t('New Address');\n            },\n            customerAddressId: null\n        },\n        addressOptions = addressList().filter(function (address) {\n            return address.getType() === 'customer-address';\n        }),\n        addressDefaultIndex = addressOptions.findIndex(function (address) {\n            return address.isDefaultBilling();\n        });\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/billing-address',\n            selectedAddress: null,\n            isNewAddressSelected: false,\n            addressOptions: addressOptions,\n            exports: {\n                selectedAddress: '${ $.parentName }:selectedAddress'\n            }\n        },\n\n        /**\n         * @returns {Object} Chainable.\n         */\n        initConfig: function () {\n            this._super();\n            this.addressOptions.push(newAddressOption);\n\n            return this;\n        },\n\n        /**\n         * @return {exports.initObservable}\n         */\n        initObservable: function () {\n            this._super()\n                .observe('selectedAddress isNewAddressSelected')\n                .observe({\n                    isNewAddressSelected: !customer.isLoggedIn() || !addressOptions.length,\n                    selectedAddress: this.addressOptions[addressDefaultIndex]\n                });\n\n            return this;\n        },\n\n        /**\n         * @param {Object} address\n         * @return {*}\n         */\n        addressOptionsText: function (address) {\n            return address.getAddressInline();\n        },\n\n        /**\n         * @param {Object} address\n         */\n        onAddressChange: function (address) {\n            this.isNewAddressSelected(address === newAddressOption);\n        }\n    });\n});\n","Magento_Checkout/js/view/cart/shipping-estimation.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'jquery',\n        'Magento_Ui/js/form/form',\n        'Magento_Checkout/js/action/select-shipping-address',\n        'Magento_Checkout/js/model/address-converter',\n        'Magento_Checkout/js/model/cart/estimate-service',\n        'Magento_Checkout/js/checkout-data',\n        'Magento_Checkout/js/model/shipping-rates-validator',\n        'uiRegistry',\n        'Magento_Checkout/js/model/quote',\n        'Magento_Checkout/js/model/checkout-data-resolver',\n        'Magento_Checkout/js/model/shipping-service',\n        'mage/validation'\n    ],\n    function (\n        $,\n        Component,\n        selectShippingAddress,\n        addressConverter,\n        estimateService,\n        checkoutData,\n        shippingRatesValidator,\n        registry,\n        quote,\n        checkoutDataResolver,\n        shippingService\n    ) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Checkout/cart/shipping-estimation'\n            },\n            isVirtual: quote.isVirtual(),\n\n            /**\n             * @override\n             */\n            initialize: function () {\n                this._super();\n\n                // Prevent shipping methods showing none available whilst we resolve\n                shippingService.isLoading(true);\n\n                registry.async('checkoutProvider')(function (checkoutProvider) {\n                    var address, estimatedAddress;\n\n                    shippingService.isLoading(false);\n\n                    checkoutDataResolver.resolveEstimationAddress();\n                    address = quote.isVirtual() ? quote.billingAddress() : quote.shippingAddress();\n\n                    if (!address && quote.isVirtual()) {\n                        address = addressConverter.formAddressDataToQuoteAddress(\n                            checkoutData.getSelectedBillingAddress()\n                        );\n                    }\n\n                    if (address) {\n                        estimatedAddress = address.isEditable() ?\n                            addressConverter.quoteAddressToFormAddressData(address) :\n                            {\n                                // only the following fields must be used by estimation form data provider\n                                'country_id': address.countryId,\n                                region: address.region,\n                                'region_id': address.regionId,\n                                postcode: address.postcode\n                            };\n                        checkoutProvider.set(\n                            'shippingAddress',\n                            $.extend({}, checkoutProvider.get('shippingAddress'), estimatedAddress)\n                        );\n                    }\n\n                    if (!quote.isVirtual()) {\n                        checkoutProvider.on('shippingAddress', function (shippingAddressData) {\n                            //jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n                            if (quote.shippingAddress().countryId !== shippingAddressData.country_id ||\n                                (shippingAddressData.postcode || shippingAddressData.region_id)\n                            ) {\n                                checkoutData.setShippingAddressFromData(shippingAddressData);\n                            }\n                            //jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n                        });\n                    } else {\n                        checkoutProvider.on('shippingAddress', function (shippingAddressData) {\n                            checkoutData.setBillingAddressFromData(shippingAddressData);\n                        });\n                    }\n                });\n\n                return this;\n            },\n\n            /**\n             * @override\n             */\n            initElement: function (element) {\n                this._super();\n\n                if (element.index === 'address-fieldsets') {\n                    shippingRatesValidator.bindChangeHandlers(element.elems(), true, 500);\n                    element.elems.subscribe(function (elems) {\n                        shippingRatesValidator.doElementBinding(elems[elems.length - 1], true, 500);\n                    });\n                }\n\n                return this;\n            },\n\n            /**\n             * Returns shipping rates for address\n             * @returns void\n             */\n            getEstimationInfo: function () {\n                var addressData = null;\n\n                this.source.set('params.invalid', false);\n                this.source.trigger('shippingAddress.data.validate');\n\n                if (!this.source.get('params.invalid')) {\n                    addressData = this.source.get('shippingAddress');\n                    selectShippingAddress(addressConverter.formAddressDataToQuoteAddress(addressData));\n                }\n            }\n        });\n    }\n);\n","Magento_Checkout/js/view/cart/totals.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'uiComponent',\n    'Magento_Checkout/js/model/totals',\n    'Magento_Checkout/js/model/shipping-service'\n], function ($, Component, totalsService, shippingService) {\n    'use strict';\n\n    return Component.extend({\n        isLoading: totalsService.isLoading,\n\n        /**\n         * @override\n         */\n        initialize: function () {\n            this._super();\n            totalsService.totals.subscribe(function () {\n                $(window).trigger('resize');\n            });\n            shippingService.getShippingRates().subscribe(function () {\n                $(window).trigger('resize');\n            });\n        }\n    });\n});\n","Magento_Checkout/js/view/cart/shipping-rates.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'underscore',\n    'uiComponent',\n    'Magento_Checkout/js/model/shipping-service',\n    'Magento_Catalog/js/price-utils',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/action/select-shipping-method',\n    'Magento_Checkout/js/checkout-data'\n], function (ko, _, Component, shippingService, priceUtils, quote, selectShippingMethodAction, checkoutData) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/cart/shipping-rates'\n        },\n        isVisible: ko.observable(!quote.isVirtual()),\n        isLoading: shippingService.isLoading,\n        shippingRates: shippingService.getShippingRates(),\n        shippingRateGroups: ko.observableArray([]),\n        selectedShippingMethod: ko.computed(function () {\n            return quote.shippingMethod() ?\n                quote.shippingMethod()['carrier_code'] + '_' + quote.shippingMethod()['method_code'] :\n                null;\n        }),\n\n        /**\n         * @override\n         */\n        initObservable: function () {\n            var self = this;\n\n            this._super();\n\n            this.shippingRates.subscribe(function (rates) {\n                self.shippingRateGroups([]);\n                _.each(rates, function (rate) {\n                    var carrierTitle = rate['carrier_title'];\n\n                    if (self.shippingRateGroups.indexOf(carrierTitle) === -1) {\n                        self.shippingRateGroups.push(carrierTitle);\n                    }\n                });\n            });\n\n            return this;\n        },\n\n        /**\n         * Get shipping rates for specific group based on title.\n         * @returns Array\n         */\n        getRatesForGroup: function (shippingRateGroupTitle) {\n            return _.filter(this.shippingRates(), function (rate) {\n                return shippingRateGroupTitle === rate['carrier_title'];\n            });\n        },\n\n        /**\n         * Format shipping price.\n         * @returns {String}\n         */\n        getFormattedPrice: function (price) {\n            return priceUtils.formatPrice(price, quote.getPriceFormat());\n        },\n\n        /**\n         * Set shipping method.\n         * @param {String} methodData\n         * @returns bool\n         */\n        selectShippingMethod: function (methodData) {\n            selectShippingMethodAction(methodData);\n            checkoutData.setSelectedShippingRate(methodData['carrier_code'] + '_' + methodData['method_code']);\n\n            return true;\n        }\n    });\n});\n","Magento_Checkout/js/view/cart/totals/shipping.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Checkout/js/view/summary/shipping',\n    'Magento_Checkout/js/model/quote'\n], function (Component, quote) {\n    'use strict';\n\n    return Component.extend({\n\n        /**\n         * @override\n         */\n        isCalculated: function () {\n            return !!quote.shippingMethod();\n        }\n    });\n});\n","Magento_Checkout/js/view/summary/abstract-total.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Catalog/js/price-utils',\n    'Magento_Checkout/js/model/totals',\n    'Magento_Checkout/js/model/step-navigator'\n], function (Component, quote, priceUtils, totals, stepNavigator) {\n    'use strict';\n\n    return Component.extend({\n        /**\n         * @param {*} price\n         * @return {*|String}\n         */\n        getFormattedPrice: function (price) {\n            return priceUtils.formatPrice(price, quote.getPriceFormat());\n        },\n\n        /**\n         * @return {*}\n         */\n        getTotals: function () {\n            return totals.totals();\n        },\n\n        /**\n         * @return {*}\n         */\n        isFullMode: function () {\n            if (!this.getTotals()) {\n                return false;\n            }\n\n            return stepNavigator.isProcessed('shipping');\n        }\n    });\n});\n","Magento_Checkout/js/view/summary/subtotal.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Checkout/js/view/summary/abstract-total',\n    'Magento_Checkout/js/model/quote'\n], function (Component, quote) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/summary/subtotal'\n        },\n\n        /**\n         * Get pure value.\n         *\n         * @return {*}\n         */\n        getPureValue: function () {\n            var totals = quote.getTotals()();\n\n            if (totals) {\n                return totals.subtotal;\n            }\n\n            return quote.subtotal;\n        },\n\n        /**\n         * @return {*|String}\n         */\n        getValue: function () {\n            return this.getFormattedPrice(this.getPureValue());\n        }\n\n    });\n});\n","Magento_Checkout/js/view/summary/totals.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Checkout/js/view/summary/abstract-total'\n], function (Component) {\n    'use strict';\n\n    return Component.extend({\n        /**\n         * @return {*}\n         */\n        isDisplayed: function () {\n            return this.isFullMode();\n        }\n    });\n});\n","Magento_Checkout/js/view/summary/grand-total.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Checkout/js/view/summary/abstract-total',\n    'Magento_Checkout/js/model/quote'\n], function (Component, quote) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/summary/grand-total'\n        },\n\n        /**\n         * @return {*}\n         */\n        isDisplayed: function () {\n            return this.isFullMode();\n        },\n\n        /**\n         * Get pure value.\n         */\n        getPureValue: function () {\n            var totals = quote.getTotals()();\n\n            if (totals) {\n                return totals['grand_total'];\n            }\n\n            return quote['grand_total'];\n        },\n\n        /**\n         * @return {*|String}\n         */\n        getValue: function () {\n            return this.getFormattedPrice(this.getPureValue());\n        }\n    });\n});\n","Magento_Checkout/js/view/summary/cart-items.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'Magento_Checkout/js/model/totals',\n    'uiComponent',\n    'Magento_Checkout/js/model/step-navigator',\n    'Magento_Checkout/js/model/quote'\n], function (ko, totals, Component, stepNavigator, quote) {\n    'use strict';\n\n    var useQty = window.checkoutConfig.useQty;\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/summary/cart-items'\n        },\n        totals: totals.totals(),\n        items: ko.observable([]),\n        maxCartItemsToDisplay: window.checkoutConfig.maxCartItemsToDisplay,\n        cartUrl: window.checkoutConfig.cartUrl,\n\n        /**\n         * @deprecated Please use observable property (this.items())\n         */\n        getItems: totals.getItems(),\n\n        /**\n         * Returns cart items qty\n         *\n         * @returns {Number}\n         */\n        getItemsQty: function () {\n            return parseFloat(this.totals['items_qty']);\n        },\n\n        /**\n         * Returns count of cart line items\n         *\n         * @returns {Number}\n         */\n        getCartLineItemsCount: function () {\n            return parseInt(totals.getItems()().length, 10);\n        },\n\n        /**\n         * Returns shopping cart items summary (includes config settings)\n         *\n         * @returns {Number}\n         */\n        getCartSummaryItemsCount: function () {\n            return useQty ? this.getItemsQty() : this.getCartLineItemsCount();\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initialize: function () {\n            this._super();\n            // Set initial items to observable field\n            this.setItems(totals.getItems()());\n            // Subscribe for items data changes and refresh items in view\n            totals.getItems().subscribe(function (items) {\n                this.setItems(items);\n            }.bind(this));\n        },\n\n        /**\n         * Set items to observable field\n         *\n         * @param {Object} items\n         */\n        setItems: function (items) {\n            if (items && items.length > 0) {\n                items = items.slice(parseInt(-this.maxCartItemsToDisplay, 10));\n            }\n            this.items(items);\n        },\n\n        /**\n         * Returns bool value for items block state (expanded or not)\n         *\n         * @returns {*|Boolean}\n         */\n        isItemsBlockExpanded: function () {\n            return quote.isVirtual() || stepNavigator.isProcessed('shipping');\n        }\n    });\n});\n","Magento_Checkout/js/view/summary/shipping.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_Checkout/js/view/summary/abstract-total',\n    'Magento_Checkout/js/model/quote',\n    'Magento_SalesRule/js/view/summary/discount'\n], function ($, _, Component, quote, discountView) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/summary/shipping'\n        },\n        quoteIsVirtual: quote.isVirtual(),\n        totals: quote.getTotals(),\n\n        /**\n         * @return {*}\n         */\n        getShippingMethodTitle: function () {\n            var shippingMethod,\n                shippingMethodTitle = '';\n\n            if (!this.isCalculated()) {\n                return '';\n            }\n            shippingMethod = quote.shippingMethod();\n\n            if (!_.isArray(shippingMethod) && !_.isObject(shippingMethod)) {\n                return '';\n            }\n\n            if (typeof shippingMethod['method_title'] !== 'undefined') {\n                shippingMethodTitle = ' - ' + shippingMethod['method_title'];\n            }\n\n            return shippingMethodTitle ?\n                shippingMethod['carrier_title'] + shippingMethodTitle :\n                shippingMethod['carrier_title'];\n        },\n\n        /**\n         * @return {*|Boolean}\n         */\n        isCalculated: function () {\n            return this.totals() && this.isFullMode() && quote.shippingMethod() != null; //eslint-disable-line eqeqeq\n        },\n\n        /**\n         * @return {*}\n         */\n        getValue: function () {\n            var price;\n\n            if (!this.isCalculated()) {\n                return this.notCalculatedMessage;\n            }\n            price =  this.totals()['shipping_amount'];\n\n            return this.getFormattedPrice(price);\n        },\n\n        /**\n         * If is set coupon code, but there wasn't displayed discount view.\n         *\n         * @return {Boolean}\n         */\n        haveToShowCoupon: function () {\n            var couponCode = this.totals()['coupon_code'];\n\n            if (typeof couponCode === 'undefined') {\n                couponCode = false;\n            }\n\n            return couponCode && !discountView().isDisplayed();\n        },\n\n        /**\n         * Returns coupon code description.\n         *\n         * @return {String}\n         */\n        getCouponDescription: function () {\n            if (!this.haveToShowCoupon()) {\n                return '';\n            }\n\n            return '(' + this.totals()['coupon_code'] + ')';\n        }\n    });\n});\n","Magento_Checkout/js/view/summary/item/details.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'escaper'\n], function (Component, escaper) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/summary/item/details',\n            allowedTags: ['b', 'strong', 'i', 'em', 'u']\n        },\n\n        /**\n         * @param {Object} quoteItem\n         * @return {String}\n         */\n        getNameUnsanitizedHtml: function (quoteItem) {\n            var txt = document.createElement('textarea');\n\n            txt.innerHTML = quoteItem.name;\n\n            return escaper.escapeHtml(txt.value, this.allowedTags);\n        },\n\n        /**\n         * @param {Object} quoteItem\n         * @return {String}Magento_Checkout/js/region-updater\n         */\n        getValue: function (quoteItem) {\n            return quoteItem.name;\n        }\n    });\n});\n","Magento_Checkout/js/view/summary/item/details/message.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['uiComponent'], function (Component) {\n    'use strict';\n\n    var quoteMessages = window.checkoutConfig.quoteMessages;\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/summary/item/details/message'\n        },\n        displayArea: 'item_message',\n        quoteMessages: quoteMessages,\n\n        /**\n         * @param {Object} item\n         * @return {null}\n         */\n        getMessage: function (item) {\n            if (this.quoteMessages[item['item_id']]) {\n                return this.quoteMessages[item['item_id']];\n            }\n\n            return null;\n        }\n    });\n});\n","Magento_Checkout/js/view/summary/item/details/thumbnail.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['uiComponent'], function (Component) {\n    'use strict';\n\n    var imageData = window.checkoutConfig.imageData;\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/summary/item/details/thumbnail'\n        },\n        displayArea: 'before_details',\n        imageData: imageData,\n\n        /**\n         * @param {Object} item\n         * @return {Array}\n         */\n        getImageItem: function (item) {\n            if (this.imageData[item['item_id']]) {\n                return this.imageData[item['item_id']];\n            }\n\n            return [];\n        },\n\n        /**\n         * @param {Object} item\n         * @return {null}\n         */\n        getSrc: function (item) {\n            if (this.imageData[item['item_id']]) {\n                return this.imageData[item['item_id']].src;\n            }\n\n            return null;\n        },\n\n        /**\n         * @param {Object} item\n         * @return {null}\n         */\n        getWidth: function (item) {\n            if (this.imageData[item['item_id']]) {\n                return this.imageData[item['item_id']].width;\n            }\n\n            return null;\n        },\n\n        /**\n         * @param {Object} item\n         * @return {null}\n         */\n        getHeight: function (item) {\n            if (this.imageData[item['item_id']]) {\n                return this.imageData[item['item_id']].height;\n            }\n\n            return null;\n        },\n\n        /**\n         * @param {Object} item\n         * @return {null}\n         */\n        getAlt: function (item) {\n            if (this.imageData[item['item_id']]) {\n                return this.imageData[item['item_id']].alt;\n            }\n\n            return null;\n        }\n    });\n});\n","Magento_Checkout/js/view/summary/item/details/subtotal.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Checkout/js/view/summary/abstract-total'\n], function (viewModel) {\n    'use strict';\n\n    return viewModel.extend({\n        defaults: {\n            displayArea: 'after_details',\n            template: 'Magento_Checkout/summary/item/details/subtotal'\n        },\n\n        /**\n         * @param {Object} quoteItem\n         * @return {*|String}\n         */\n        getValue: function (quoteItem) {\n            return this.getFormattedPrice(quoteItem['row_total']);\n        }\n    });\n});\n","Magento_ReCaptchaPaypal/js/reCaptchaPaypal.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(\n    [\n        'Magento_ReCaptchaFrontendUi/js/reCaptcha',\n        'jquery'\n    ],\n    function (Component, $) {\n        'use strict';\n\n        return Component.extend({\n\n            /**\n             * Recaptcha callback\n             * @param {String} token\n             */\n            reCaptchaCallback: function (token) {\n                this.tokenField.value = token;\n                this.$parentForm.trigger('captcha:endExecute');\n            },\n\n            /**\n             * Initialize parent form.\n             *\n             * @param {Object} parentForm\n             * @param {String} widgetId\n             */\n            initParentForm: function (parentForm, widgetId) {\n                var me = this;\n\n                parentForm.on('captcha:startExecute', function (event) {\n                    if (!me.tokenField.value && me.getIsInvisibleRecaptcha()) {\n                        // eslint-disable-next-line no-undef\n                        grecaptcha.execute(widgetId);\n                        event.preventDefault(event);\n                        event.stopImmediatePropagation();\n                    } else {\n                        me.$parentForm.trigger('captcha:endExecute');\n                    }\n                });\n\n                // Create a virtual token field\n                this.tokenField = $('<input type=\"text\" name=\"token\" style=\"display: none\" />')[0];\n                this.$parentForm = parentForm;\n                parentForm.append(this.tokenField);\n            }\n        });\n    }\n);\n","Magento_ReCaptchaPaypal/js/payflowpro-method-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_Checkout/js/model/payment/additional-validators'\n], function ($, additionalValidators) {\n    'use strict';\n\n    return function (originalComponent) {\n        return originalComponent.extend({\n            /**\n             * Initializes reCaptcha\n             */\n            placeOrder: function () {\n                var original = this._super.bind(this),\n                    // jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n                    isEnabledForPaypal = window.checkoutConfig.recaptcha_paypal,\n                    // jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n                    paymentFormSelector = $('#co-payment-form'),\n                    startEvent = 'captcha:startExecute',\n                    endEvent = 'captcha:endExecute';\n\n                if (!this.validateHandler() || !additionalValidators.validate() || !isEnabledForPaypal) {\n                    return original();\n                }\n\n                paymentFormSelector.off(endEvent).on(endEvent, function () {\n                    original();\n                    paymentFormSelector.off(endEvent);\n                });\n\n                paymentFormSelector.trigger(startEvent);\n            }\n        });\n    };\n});\n","Magento_Catalog/js/price-options.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'mage/template',\n    'priceUtils',\n    'priceBox',\n    'jquery-ui-modules/widget'\n], function ($, _, mageTemplate, utils) {\n    'use strict';\n\n    var globalOptions = {\n        productId: null,\n        priceHolderSelector: '.price-box', //data-role=\"priceBox\"\n        optionsSelector: '.product-custom-option',\n        optionConfig: {},\n        optionHandlers: {},\n        optionTemplate: '<%= data.label %>' +\n        '<% if (data.finalPrice.value > 0) { %>' +\n        ' +<%- data.finalPrice.formatted %>' +\n        '<% } else if (data.finalPrice.value < 0) { %>' +\n        ' <%- data.finalPrice.formatted %>' +\n        '<% } %>',\n        controlContainer: 'dd'\n    };\n\n    /**\n     * Custom option preprocessor\n     * @param  {jQuery} element\n     * @param  {Object} optionsConfig - part of config\n     * @return {Object}\n     */\n    function defaultGetOptionValue(element, optionsConfig) {\n        var changes = {},\n            optionValue = element.val(),\n            optionId = utils.findOptionId(element[0]),\n            optionName = element.prop('name'),\n            optionType = element.prop('type'),\n            optionConfig = optionsConfig[optionId],\n            optionHash = optionName;\n\n        switch (optionType) {\n            case 'text':\n            case 'textarea':\n                changes[optionHash] = optionValue ? optionConfig.prices : {};\n                break;\n\n            case 'radio':\n                if (element.is(':checked')) {\n                    changes[optionHash] = optionConfig[optionValue] && optionConfig[optionValue].prices || {};\n                }\n                break;\n\n            case 'select-one':\n                changes[optionHash] = optionConfig[optionValue] && optionConfig[optionValue].prices || {};\n                break;\n\n            case 'select-multiple':\n                _.each(optionConfig, function (row, optionValueCode) {\n                    optionHash = optionName + '##' + optionValueCode;\n                    changes[optionHash] = _.contains(optionValue, optionValueCode) ? row.prices : {};\n                });\n                break;\n\n            case 'checkbox':\n                optionHash = optionName + '##' + optionValue;\n                changes[optionHash] = element.is(':checked') ? optionConfig[optionValue].prices : {};\n                break;\n\n            case 'file':\n                // Checking for 'disable' property equal to checking DOMNode with id*=\"change-\"\n                changes[optionHash] = optionValue || element.prop('disabled') ? optionConfig.prices : {};\n                break;\n        }\n\n        return changes;\n    }\n\n    $.widget('mage.priceOptions', {\n        options: globalOptions,\n\n        /**\n         * @private\n         */\n        _init: function initPriceBundle() {\n            $(this.options.optionsSelector, this.element).trigger('change');\n        },\n\n        /**\n         * Widget creating method.\n         * Triggered once.\n         * @private\n         */\n        _create: function createPriceOptions() {\n            var form = this.element,\n                options = $(this.options.optionsSelector, form),\n                priceBox = $(this.options.priceHolderSelector, $(this.options.optionsSelector).element);\n\n            if (priceBox.data('magePriceBox') &&\n                priceBox.priceBox('option') &&\n                priceBox.priceBox('option').priceConfig\n            ) {\n                if (priceBox.priceBox('option').priceConfig.optionTemplate) {\n                    this._setOption('optionTemplate', priceBox.priceBox('option').priceConfig.optionTemplate);\n                }\n                this._setOption('priceFormat', priceBox.priceBox('option').priceConfig.priceFormat);\n            }\n\n            this._applyOptionNodeFix(options);\n\n            options.on('change', this._onOptionChanged.bind(this));\n        },\n\n        /**\n         * Custom option change-event handler\n         * @param {Event} event\n         * @private\n         */\n        _onOptionChanged: function onOptionChanged(event) {\n            var changes,\n                option = $(event.target),\n                handler = this.options.optionHandlers[option.data('role')];\n\n            option.data('optionContainer', option.closest(this.options.controlContainer));\n\n            if (handler && handler instanceof Function) {\n                changes = handler(option, this.options.optionConfig, this);\n            } else {\n                changes = defaultGetOptionValue(option, this.options.optionConfig);\n            }\n            $(this.options.priceHolderSelector).trigger('updatePrice', changes);\n        },\n\n        /**\n         * Helper to fix issue with option nodes:\n         *  - you can't place any html in option ->\n         *    so you can't style it via CSS\n         * @param {jQuery} options\n         * @private\n         */\n        _applyOptionNodeFix: function applyOptionNodeFix(options) {\n            var config = this.options,\n                format = config.priceFormat,\n                template = config.optionTemplate;\n\n            template = mageTemplate(template);\n            options.filter('select').each(function (index, element) {\n                var $element = $(element),\n                    optionId = utils.findOptionId($element),\n                    optionConfig = config.optionConfig && config.optionConfig[optionId];\n\n                $element.find('option').each(function (idx, option) {\n                    var $option,\n                        optionValue,\n                        toTemplate,\n                        prices;\n\n                    $option = $(option);\n                    optionValue = $option.val();\n\n                    if (!optionValue && optionValue !== 0) {\n                        return;\n                    }\n\n                    toTemplate = {\n                        data: {\n                            label: optionConfig[optionValue] && optionConfig[optionValue].name\n                        }\n                    };\n                    prices = optionConfig[optionValue] ? optionConfig[optionValue].prices : null;\n\n                    if (prices) {\n                        _.each(prices, function (price, type) {\n                            var value = +price.amount;\n\n                            value += _.reduce(price.adjustments, function (sum, x) { //eslint-disable-line\n                                return sum + x;\n                            }, 0);\n                            toTemplate.data[type] = {\n                                value: value,\n                                formatted: utils.formatPrice(value, format)\n                            };\n                        });\n\n                        $option.text(template(toTemplate));\n                    }\n                });\n            });\n        },\n\n        /**\n         * Custom behavior on getting options:\n         * now widget able to deep merge accepted configuration with instance options.\n         * @param  {Object}  options\n         * @return {$.Widget}\n         * @private\n         */\n        _setOptions: function setOptions(options) {\n            $.extend(true, this.options, options);\n            this._super(options);\n\n            return this;\n        }\n    });\n\n    return $.mage.priceOptions;\n});\n","Magento_Catalog/js/price-option-file.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.priceOptionFile', {\n        options: {\n            fileName: '',\n            fileNamed: '',\n            fieldNameAction: '',\n            changeFileSelector: '',\n            deleteFileSelector: ''\n        },\n\n        /**\n         * Creates instance of widget\n         * @private\n         */\n        _create: function () {\n            this.fileDeleteFlag = this.fileChangeFlag = false;\n            this.inputField = this.element.find('input[name=' + this.options.fileName + ']')[0];\n            this.inputFieldAction = this.element.find('input[name=' + this.options.fieldNameAction + ']')[0];\n            this.fileNameSpan = this.element.parent('dd').find('.' + this.options.fileNamed);\n\n            $(this.options.changeFileSelector).on('click', $.proxy(function () {\n                this._toggleFileChange();\n            }, this));\n            $(this.options.deleteFileSelector).on('click', $.proxy(function () {\n                this._toggleFileDelete();\n            }, this));\n        },\n\n        /**\n         * Toggles whether the current file is being changed or not. If the file is being deleted\n         * then the option to change the file is disabled.\n         * @private\n         */\n        _toggleFileChange: function () {\n            this.element.toggle();\n            this.fileChangeFlag = !this.fileChangeFlag;\n\n            if (!this.fileDeleteFlag) {\n                $(this.inputFieldAction).attr('value', this.fileChangeFlag ? 'save_new' : 'save_old');\n                this.inputField.disabled = !this.fileChangeFlag;\n            }\n        },\n\n        /**\n         * Toggles whether the file is to be deleted. When the file is being deleted, the name of\n         * the file is decorated with strike-through text and the option to change the file is\n         * disabled.\n         * @private\n         */\n        _toggleFileDelete: function () {\n            this.fileDeleteFlag = $(this.options.deleteFileSelector + ':checked').val();\n            $(this.inputFieldAction).attr('value',\n                this.fileDeleteFlag ? '' : this.fileChangeFlag ? 'save_new' : 'save_old');\n            this.inputField.disabled = this.fileDeleteFlag || !this.fileChangeFlag;\n            this.fileNameSpan.css('text-decoration', this.fileDeleteFlag ? 'line-through' : 'none');\n        }\n    });\n\n    return $.mage.priceOptionFile;\n});\n","Magento_Catalog/js/storage-manager.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'uiElement',\n    'mageUtils',\n    'Magento_Catalog/js/product/storage/storage-service',\n    'Magento_Customer/js/section-config',\n    'jquery'\n], function (_, Element, utils, storage, sectionConfig, $) {\n    'use strict';\n\n    /**\n     * Flush events, that are clones of the same customer data sections\n     * Events listener\n     */\n    $(document).on('submit', function (event) {\n        var sections;\n\n        if (event.target.method.match(/post|put|delete/i)) {\n            sections = sectionConfig.getAffectedSections(event.target.action);\n\n            if (sections && window.localStorage) {\n                _.each(sections, function (section) {\n                    window.localStorage.removeItem(section);\n                });\n            }\n        }\n    });\n\n    return Element.extend({\n        defaults: {\n            defaultNamespace: {\n                lifetime: 1000\n            },\n            storagesConfiguration: {\n                'recently_viewed_product': {\n                    namespace: 'recently_viewed_product',\n                    className: 'IdsStorage',\n                    lifetime: '${ $.defaultNamespace.lifetime }',\n                    requestConfig: {\n                        typeId: '${ $.storagesConfiguration.recently_viewed_product.namespace }'\n                    },\n                    savePrevious: {\n                        namespace: '${ $.storagesConfiguration.recently_viewed_product.namespace }' + '_previous',\n                        className: '${ $.storagesConfiguration.recently_viewed_product.className }'\n                    },\n                    allowToSendRequest: 0\n                },\n                'recently_compared_product': {\n                    namespace: 'recently_compared_product',\n                    className: 'IdsStorageCompare',\n                    provider: 'compare-products',\n                    lifetime: '${ $.defaultNamespace.lifetime }',\n                    requestConfig: {\n                        typeId: '${ $.storagesConfiguration.recently_compared_product.namespace }'\n                    },\n                    savePrevious: {\n                        namespace: '${ $.storagesConfiguration.recently_compared_product.namespace }' + '_previous',\n                        className: '${ $.storagesConfiguration.recently_compared_product.className }'\n                    },\n                    allowToSendRequest: 0\n                },\n                'product_data_storage': {\n                    namespace: 'product_data_storage',\n                    className: 'DataStorage',\n                    allowToSendRequest: 0,\n                    updateRequestConfig: {\n                        url: '',\n                        method: 'GET',\n                        dataType: 'json'\n                    }\n                }\n            },\n            requestConfig: {\n                method: 'POST',\n                dataType: 'json',\n                ajaxSaveType: 'default',\n                ignoreProcessEvents: true\n            },\n            requestSent: 0\n        },\n\n        /**\n         * Initializes provider component.\n         *\n         * @returns {Object} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .prepareStoragesConfig()\n                .initStorages()\n                .initStartData()\n                .initUpdateStorageDataListener();\n\n            return this;\n        },\n\n        /**\n         * Initializes storages.\n         *\n         * @returns {Object} Chainable.\n         */\n        initStorages: function () {\n            _.each(this.storagesNamespace, function (name) {\n                this[name] = storage.createStorage(this.storagesConfiguration[name]);\n\n                if (this.storagesConfiguration[name].savePrevious) {\n                    this[name].previous = storage.createStorage(this.storagesConfiguration[name].savePrevious);\n                }\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Initializes start data.\n         *\n         * @returns {Object} Chainable.\n         */\n        initStartData: function () {\n            _.each(this.storagesNamespace, function (name) {\n                this.updateDataHandler(name, this[name].get());\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Prepare storages congfig.\n         *\n         * @returns {Object} Chainable.\n         */\n        prepareStoragesConfig: function () {\n            this.storagesNamespace = _.keys(this.storagesConfiguration);\n\n            _.each(this.storagesNamespace, function (name) {\n                this.storagesConfiguration[name].requestConfig = _.extend(\n                    utils.copy(this.requestConfig),\n                    this.storagesConfiguration[name].requestConfig\n                );\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Prepare date in UTC format (in GMT), and calculate unix timestamp based in seconds\n         *\n         * @returns {Number}\n         * @private\n         */\n        getUtcTime: function () {\n            return new Date().getTime() / 1000;\n        },\n\n        /**\n         * Initializes listeners to storages \"data\" property.\n         */\n        initUpdateStorageDataListener: function () {\n            _.each(this.storagesNamespace, function (name) {\n                if (this[name].data) {\n                    this[name].data.subscribe(this.updateDataHandler.bind(this, name));\n                }\n            }.bind(this));\n        },\n\n        /**\n         * Handlers for storages \"data\" property\n         */\n        updateDataHandler: function (name, data) {\n            var previousData = this[name].previous ? this[name].previous.get() : false;\n\n            if (!_.isEmpty(previousData) &&\n                !_.isEmpty(data) &&\n                !utils.compare(data, previousData).equal) {\n                this[name].set(data);\n                this[name].previous.set(data);\n                this.sendRequest(name, data);\n            } else if (\n                _.isEmpty(previousData) &&\n                !_.isEmpty(data)\n            ) {\n                this[name].set(data);\n                this.sendRequest(name, data);\n            }\n        },\n\n        /**\n         * Gets last updated time\n         *\n         * @param {String} name - storage name\n         */\n        getLastUpdate: function (name) {\n            return window.localStorage.getItem(this[name].namespace + '_last_update');\n        },\n\n        /**\n         * Sets last updated time\n         *\n         * @param {String} name - storage name\n         */\n        setLastUpdate: function (name) {\n            window.localStorage.setItem(this[name].namespace + '_last_update', this.getUtcTime());\n        },\n\n        /**\n         * Request handler\n         *\n         * @param {String} name - storage name\n         */\n        requestHandler: function (name) {\n            this.setLastUpdate(name);\n            this.requestSent = 1;\n        },\n\n        /**\n         * Sends request to server to gets data\n         *\n         * @param {String} name - storage name\n         * @param {Object} data - ids\n         */\n        sendRequest: function (name, data) {\n            var params  = utils.copy(this.storagesConfiguration[name].requestConfig),\n                url = params.syncUrl,\n                typeId = params.typeId;\n\n            if (this.requestSent || !~~this.storagesConfiguration[name].allowToSendRequest) {\n                return;\n            }\n\n            delete params.typeId;\n            delete params.url;\n\n            return utils.ajaxSubmit({\n                url: url,\n                data: {\n                    ids: data,\n                    'type_id': typeId\n                }\n            }, params).done(this.requestHandler.bind(this, name));\n        }\n    });\n});\n","Magento_Catalog/js/price-option-date.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'priceUtils',\n    'priceOptions',\n    'jquery-ui-modules/widget'\n], function ($, utils) {\n    'use strict';\n\n    var globalOptions = {\n            fromSelector: 'form',\n            dropdownsSelector: '[data-role=calendar-dropdown]'\n        },\n        optionHandler = {};\n\n    optionHandler.optionHandlers = {};\n\n    /**\n     * Custom handler for Date-with-Dropdowns option type.\n     * @param  {jQuery} siblings\n     * @return {Function} function that return object { optionHash : optionAdditionalPrice }\n     */\n    function onCalendarDropdownChange(siblings) {\n        return function (element, optionConfig) {\n            var changes = {},\n                optionId = utils.findOptionId(element),\n                overhead = optionConfig[optionId].prices,\n                isNeedToUpdate = true,\n                optionHash = 'price-option-calendar-' + optionId;\n\n            siblings.each(function (index, el) {\n                isNeedToUpdate = isNeedToUpdate && !!$(el).val();\n            });\n\n            overhead = isNeedToUpdate ? overhead : {};\n            changes[optionHash] = overhead;\n\n            return changes;\n        };\n    }\n\n    /**\n     * Returns number of days for special month and year\n     * @param  {Number} month\n     * @param  {Number} year\n     * @return {Number}\n     */\n    function getDaysInMonth(month, year) {\n        return new Date(year, month, 0).getDate();\n    }\n\n    /**\n     * Adjusts the number of days in the day option element based on which month or year\n     * is selected (changed). Adjusts the days to 28, 29, 30, or 31 typically.\n     * @param {jQuery} dropdowns\n     */\n    function onDateChange(dropdowns) {\n        var daysNodes,\n            curMonth, curYear, expectedDays,\n            options, needed,\n            month = dropdowns.filter('[data-calendar-role=month]'),\n            year = dropdowns.filter('[data-calendar-role=year]');\n\n        if (month.length && year.length) {\n            daysNodes = dropdowns.filter('[data-calendar-role=day]').find('option');\n\n            curMonth = month.val() || '01';\n            curYear = year.val() || '2000';\n            expectedDays = getDaysInMonth(curMonth, curYear);\n\n            if (daysNodes.length - 1 > expectedDays) { // remove unnecessary option nodes\n                daysNodes.each(function (i, e) {\n                    if (e.value > expectedDays) {\n                        $(e).remove();\n                    }\n                });\n            } else if (daysNodes.length - 1 < expectedDays) { // add missing option nodes\n                options = [];\n                needed = expectedDays - daysNodes.length + 1;\n\n                while (needed--) { //eslint-disable-line max-depth\n                    options.push(\n                        '<option value=\"' + (expectedDays - needed) + '\">' + (expectedDays - needed) + '</option>'\n                    );\n                }\n                $(options.join('')).insertAfter(daysNodes.last());\n            }\n        }\n    }\n\n    $.widget('mage.priceOptionDate', {\n        options: globalOptions,\n\n        /**\n         * Function-initializer of priceOptionDate widget\n         * @private\n         */\n        _create: function initOptionDate() {\n            var field = this.element,\n                form = field.closest(this.options.fromSelector),\n                dropdowns = $(this.options.dropdownsSelector, field),\n                dateOptionId;\n\n            if (dropdowns.length) {\n                dateOptionId = this.options.dropdownsSelector + dropdowns.attr('name');\n\n                optionHandler.optionHandlers[dateOptionId] = onCalendarDropdownChange(dropdowns);\n\n                form.priceOptions(optionHandler);\n\n                dropdowns.data('role', dateOptionId);\n                dropdowns.on('change', onDateChange.bind(this, dropdowns));\n            }\n        }\n    });\n\n    return $.mage.priceOptionDate;\n});\n","Magento_Catalog/js/upsell-products.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.upsellProducts', {\n        options: {\n            elementsSelector: '.item.product'\n        },\n\n        /**\n         * Bind events to the appropriate handlers.\n         * @private\n         */\n        _create: function () {\n            if (this.element.data('shuffle')) {\n                this._shuffle(this.element.find(this.options.elementsSelector));\n            }\n            this._showUpsellProducts(\n                this.element.find(this.options.elementsSelector),\n                this.element.data('limit'),\n                this.element.data('shuffle-weighted')\n            );\n        },\n\n        /* jscs:disable */\n        /* eslint-disable */\n        /**\n         * Show upsell products according to limit. Shuffle if needed.\n         * @param {*} elements\n         * @param {Number} limit\n         * @param {Boolean} weightedRandom\n         * @private\n         */\n        _showUpsellProducts: function (elements, limit, weightedRandom) {\n            var index, weights = [], random = [], weight = 2, shown = 0, $element, currentGroup, prevGroup;\n\n            if (limit === 0) {\n                limit = elements.length;\n            }\n\n            if (weightedRandom && limit > 0 && limit < elements.length) {\n                for (index = 0; index < limit; index++) {\n                    $element = $(elements[index]);\n                    if ($element.data('shuffle-group') !== '') {\n                        break;\n                    }\n                    $element.show();\n                    shown++;\n                }\n                limit -= shown;\n                for (index = elements.length - 1; index >= 0; index--) {\n                    $element = $(elements[index]);\n                    currentGroup = $element.data('shuffle-group');\n                    if (currentGroup !== '') {\n                        weights.push([index, Math.log(weight)]);\n                        if (typeof prevGroup !== 'undefined' && prevGroup !== currentGroup) {\n                            weight += 2;\n                        }\n                        prevGroup = currentGroup;\n                    }\n                }\n\n                if (weights.length === 0) {\n                    return;\n                }\n\n                for (index = 0; index < weights.length; index++) {\n                    random.push([weights[index][0], Math.pow(Math.random(), 1 / weights[index][1])]);\n                }\n\n                random.sort(function(a, b) {\n                    a = a[1];\n                    b = b[1];\n                    return a < b ? 1 : (a > b ? -1 : 0);\n                });\n                index = 0;\n                while (limit) {\n                    $(elements[random[index][0]]).show();\n                    limit--;\n                    index++\n                }\n                return;\n            }\n\n            for (index = 0; index < limit; index++) {\n                $(elements[index]).show();\n            }\n        },\n\n        /* jscs:disable */\n        /* eslint-disable */\n        /**\n         * Shuffle an array\n         * @param elements\n         * @returns {*}\n         */\n        _shuffle: function shuffle(elements){ //v1.0\n            var parent, child, lastSibling;\n            if (elements.length) {\n                parent = $(elements[0]).parent();\n            }\n            while (elements.length) {\n                child = elements.splice(Math.floor(Math.random() *  elements.length), 1)[0];\n                lastSibling = parent.find('[data-shuffle-group=\"' + $(child).data('shuffle-group') + '\"]').last();\n                lastSibling.after(child);\n            }\n        }\n\n        /* jscs:disable */\n        /* eslint:disable */\n    });\n\n    return $.mage.upsellProducts;\n});\n","Magento_Catalog/js/catalog-add-to-cart.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/translate',\n    'underscore',\n    'Magento_Catalog/js/product/view/product-ids-resolver',\n    'Magento_Catalog/js/product/view/product-info-resolver',\n    'jquery-ui-modules/widget'\n], function ($, $t, _, idsResolver, productInfoResolver) {\n    'use strict';\n\n    $.widget('mage.catalogAddToCart', {\n        options: {\n            processStart: null,\n            processStop: null,\n            bindSubmit: true,\n            minicartSelector: '[data-block=\"minicart\"]',\n            messagesSelector: '[data-placeholder=\"messages\"]',\n            productStatusSelector: '.stock.available',\n            addToCartButtonSelector: '.action.tocart',\n            addToCartButtonDisabledClass: 'disabled',\n            addToCartButtonTextWhileAdding: '',\n            addToCartButtonTextAdded: '',\n            addToCartButtonTextDefault: '',\n            productInfoResolver: productInfoResolver\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            if (this.options.bindSubmit) {\n                this._bindSubmit();\n            }\n            $(this.options.addToCartButtonSelector).attr('disabled', false);\n        },\n\n        /**\n         * @private\n         */\n        _bindSubmit: function () {\n            var self = this;\n\n            if (this.element.data('catalog-addtocart-initialized')) {\n                return;\n            }\n\n            this.element.data('catalog-addtocart-initialized', 1);\n            this.element.on('submit', function (e) {\n                e.preventDefault();\n                self.submitForm($(this));\n            });\n        },\n\n        /**\n         * @private\n         */\n        _redirect: function (url) {\n            var urlParts, locationParts, forceReload;\n\n            urlParts = url.split('#');\n            locationParts = window.location.href.split('#');\n            forceReload = urlParts[0] === locationParts[0];\n\n            window.location.assign(url);\n\n            if (forceReload) {\n                window.location.reload();\n            }\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isLoaderEnabled: function () {\n            return this.options.processStart && this.options.processStop;\n        },\n\n        /**\n         * Handler for the form 'submit' event\n         *\n         * @param {jQuery} form\n         */\n        submitForm: function (form) {\n            this.ajaxSubmit(form);\n        },\n\n        /**\n         * @param {jQuery} form\n         */\n        ajaxSubmit: function (form) {\n            var self = this,\n                productIds = idsResolver(form),\n                productInfo = self.options.productInfoResolver(form),\n                formData;\n\n            $(self.options.minicartSelector).trigger('contentLoading');\n            self.disableAddToCartButton(form);\n            formData = new FormData(form[0]);\n\n            $.ajax({\n                url: form.attr('action'),\n                data: formData,\n                type: 'post',\n                dataType: 'json',\n                cache: false,\n                contentType: false,\n                processData: false,\n\n                /** @inheritdoc */\n                beforeSend: function () {\n                    if (self.isLoaderEnabled()) {\n                        $('body').trigger(self.options.processStart);\n                    }\n                },\n\n                /** @inheritdoc */\n                success: function (res) {\n                    var eventData, parameters;\n\n                    $(document).trigger('ajax:addToCart', {\n                        'sku': form.data().productSku,\n                        'productIds': productIds,\n                        'productInfo': productInfo,\n                        'form': form,\n                        'response': res\n                    });\n\n                    if (self.isLoaderEnabled()) {\n                        $('body').trigger(self.options.processStop);\n                    }\n\n                    if (res.backUrl) {\n                        eventData = {\n                            'form': form,\n                            'redirectParameters': []\n                        };\n                        // trigger global event, so other modules will be able add parameters to redirect url\n                        $('body').trigger('catalogCategoryAddToCartRedirect', eventData);\n\n                        if (eventData.redirectParameters.length > 0 &&\n                            window.location.href.split(/[?#]/)[0] === res.backUrl\n                        ) {\n                            parameters = res.backUrl.split('#');\n                            parameters.push(eventData.redirectParameters.join('&'));\n                            res.backUrl = parameters.join('#');\n                        }\n\n                        self._redirect(res.backUrl);\n\n                        return;\n                    }\n\n                    if (res.messages) {\n                        $(self.options.messagesSelector).html(res.messages);\n                    }\n\n                    if (res.minicart) {\n                        $(self.options.minicartSelector).replaceWith(res.minicart);\n                        $(self.options.minicartSelector).trigger('contentUpdated');\n                    }\n\n                    if (res.product && res.product.statusText) {\n                        $(self.options.productStatusSelector)\n                            .removeClass('available')\n                            .addClass('unavailable')\n                            .find('span')\n                            .html(res.product.statusText);\n                    }\n                    self.enableAddToCartButton(form);\n                },\n\n                /** @inheritdoc */\n                error: function (res) {\n                    $(document).trigger('ajax:addToCart:error', {\n                        'sku': form.data().productSku,\n                        'productIds': productIds,\n                        'productInfo': productInfo,\n                        'form': form,\n                        'response': res\n                    });\n                },\n\n                /** @inheritdoc */\n                complete: function (res) {\n                    if (res.state() === 'rejected') {\n                        location.reload();\n                    }\n                }\n            });\n        },\n\n        /**\n         * @param {String} form\n         */\n        disableAddToCartButton: function (form) {\n            var addToCartButtonTextWhileAdding = this.options.addToCartButtonTextWhileAdding || $t('Adding...'),\n                addToCartButton = $(form).find(this.options.addToCartButtonSelector);\n\n            addToCartButton.addClass(this.options.addToCartButtonDisabledClass);\n            addToCartButton.find('span').text(addToCartButtonTextWhileAdding);\n            addToCartButton.attr('title', addToCartButtonTextWhileAdding);\n        },\n\n        /**\n         * @param {String} form\n         */\n        enableAddToCartButton: function (form) {\n            var addToCartButtonTextAdded = this.options.addToCartButtonTextAdded || $t('Added'),\n                self = this,\n                addToCartButton = $(form).find(this.options.addToCartButtonSelector);\n\n            addToCartButton.find('span').text(addToCartButtonTextAdded);\n            addToCartButton.attr('title', addToCartButtonTextAdded);\n\n            setTimeout(function () {\n                var addToCartButtonTextDefault = self.options.addToCartButtonTextDefault || $t('Add to Cart');\n\n                addToCartButton.removeClass(self.options.addToCartButtonDisabledClass);\n                addToCartButton.find('span').text(addToCartButtonTextDefault);\n                addToCartButton.attr('title', addToCartButtonTextDefault);\n            }, 1000);\n        }\n    });\n\n    return $.mage.catalogAddToCart;\n});\n","Magento_Catalog/js/validate-product.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'mage/mage',\n    'Magento_Catalog/product/view/validation',\n    'catalogAddToCart'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.productValidate', {\n        options: {\n            bindSubmit: false,\n            radioCheckboxClosest: '.nested',\n            addToCartButtonSelector: '.action.tocart'\n        },\n\n        /**\n         * Uses Magento's validation widget for the form object.\n         * @private\n         */\n        _create: function () {\n            var bindSubmit = this.options.bindSubmit;\n\n            this.element.validation({\n                radioCheckboxClosest: this.options.radioCheckboxClosest,\n\n                /**\n                 * Uses catalogAddToCart widget as submit handler.\n                 * @param {Object} form\n                 * @returns {Boolean}\n                 */\n                submitHandler: function (form) {\n                    var jqForm = $(form).catalogAddToCart({\n                        bindSubmit: bindSubmit\n                    });\n\n                    jqForm.catalogAddToCart('submitForm', jqForm);\n\n                    return false;\n                }\n            });\n            $(this.options.addToCartButtonSelector).attr('disabled', false);\n        }\n    });\n\n    return $.mage.productValidate;\n});\n","Magento_Catalog/js/price-utils.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore'\n], function ($, _) {\n    'use strict';\n\n    var globalPriceFormat = {\n        requiredPrecision: 2,\n        integerRequired: 1,\n        decimalSymbol: ',',\n        groupSymbol: ',',\n        groupLength: ','\n    };\n\n    /**\n     * Repeats {string} {times} times\n     * @param  {String} string\n     * @param  {Number} times\n     * @return {String}\n     */\n    function stringPad(string, times) {\n        return (new Array(times + 1)).join(string);\n    }\n\n    /**\n     * Formatter for price amount\n     * @param  {Number}  amount\n     * @param  {Object}  format\n     * @param  {Boolean} isShowSign\n     * @return {String}              Formatted value\n     */\n    function formatPrice(amount, format, isShowSign) {\n        var s = '',\n            precision, integerRequired, decimalSymbol, groupSymbol, groupLength, pattern, i, pad, j, re, r, am;\n\n        format = _.extend(globalPriceFormat, format);\n\n        // copied from price-option.js | Could be refactored with varien/js.js\n\n        precision = isNaN(format.requiredPrecision = Math.abs(format.requiredPrecision)) ? 2 : format.requiredPrecision;\n        integerRequired = isNaN(format.integerRequired = Math.abs(format.integerRequired)) ? 1 : format.integerRequired;\n        decimalSymbol = format.decimalSymbol === undefined ? ',' : format.decimalSymbol;\n        groupSymbol = format.groupSymbol === undefined ? '.' : format.groupSymbol;\n        groupLength = format.groupLength === undefined ? 3 : format.groupLength;\n        pattern = format.pattern || '%s';\n\n        if (isShowSign === undefined || isShowSign === true) {\n            s = amount < 0 ? '-' : isShowSign ? '+' : '';\n        } else if (isShowSign === false) {\n            s = '';\n        }\n        pattern = pattern.indexOf('{sign}') < 0 ? s + pattern : pattern.replace('{sign}', s);\n\n        // we're avoiding the usage of to fixed, and using round instead with the e representation to address\n        // numbers like 1.005 = 1.01. Using ToFixed to only provide trailing zeroes in case we have a whole number\n        i = parseInt(\n                amount = Number(Math.round(Math.abs(+amount || 0) + 'e+' + precision) + ('e-' + precision)),\n                10\n            ) + '';\n        pad = i.length < integerRequired ? integerRequired - i.length : 0;\n\n        i = stringPad('0', pad) + i;\n\n        j = i.length > groupLength ? i.length % groupLength : 0;\n        re = new RegExp('(\\\\d{' + groupLength + '})(?=\\\\d)', 'g');\n\n        // replace(/-/, 0) is only for fixing Safari bug which appears\n        // when Math.abs(0).toFixed() executed on '0' number.\n        // Result is '0.-0' :(\n\n        am = Number(Math.round(Math.abs(amount - i) + 'e+' + precision) + ('e-' + precision));\n        r = (j ? i.substr(0, j) + groupSymbol : '') +\n            i.substr(j).replace(re, '$1' + groupSymbol) +\n            (precision ? decimalSymbol + am.toFixed(precision).replace(/-/, 0).slice(2) : '');\n\n        return pattern.replace('%s', r).replace(/^\\s\\s*/, '').replace(/\\s\\s*$/, '');\n    }\n\n    /**\n     * Deep clone of Object. Doesn't support functions\n     * @param {Object} obj\n     * @return {Object}\n     */\n    function objectDeepClone(obj) {\n        return JSON.parse(JSON.stringify(obj));\n    }\n\n    /**\n     * Helper to find ID in name attribute\n     * @param   {jQuery} element\n     * @returns {undefined|String}\n     */\n    function findOptionId(element) {\n        var re, id, name;\n\n        if (!element) {\n            return id;\n        }\n        name = $(element).attr('name');\n\n        if (name.indexOf('[') !== -1) {\n            re = /\\[([^\\]]+)?\\]/;\n        } else {\n            re = /_([^\\]]+)?_/; // just to support file-type-option\n        }\n        id = re.exec(name) && re.exec(name)[1];\n\n        if (id) {\n            return id;\n        }\n    }\n\n    return {\n        formatPrice: formatPrice,\n        deepClone: objectDeepClone,\n        strPad: stringPad,\n        findOptionId: findOptionId\n    };\n});\n","Magento_Catalog/js/list.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.compareList', {\n\n        /** @inheritdoc */\n        _create: function () {\n            var elem = this.element,\n                products = $('thead td', elem),\n                headings;\n\n            if (products.length > this.options.productsInRow) {\n                headings = $('<table/>')\n                    .addClass('comparison headings data table')\n                    .insertBefore(elem.closest('.container'));\n\n                elem.addClass('scroll');\n\n                $('th', elem).each(function () {\n                    var th = $(this),\n                        thCopy = th.clone();\n\n                    th.animate({\n                        top: '+=0'\n                    }, 50, function () {\n                        var height = th.height();\n\n                        thCopy.css('height', height)\n                            .appendTo(headings)\n                            .wrap('<tr />');\n                    });\n                });\n            }\n\n            $(this.options.windowPrintSelector).on('click', function (e) {\n                e.preventDefault();\n                window.print();\n            });\n        }\n    });\n\n    return $.mage.compareList;\n});\n","Magento_Catalog/js/gallery.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.gallery', {\n        options: {\n            minWidth: 300, // Minimum width of the gallery image.\n            widthOffset: 90, // Offset added to the width of the gallery image.\n            heightOffset: 210, // Offset added to the height of the gallery image.\n            closeWindow: 'div.buttons-set a[role=\"close-window\"]' // Selector for closing the gallery popup window.\n        },\n\n        /**\n         * Bind click handler for closing the popup window and resize the popup based on the image size.\n         * @private\n         */\n        _create: function () {\n            $(this.options.closeWindow).on('click', function () {\n                window.close();\n            });\n            this._resizeWindow();\n        },\n\n        /**\n         * Resize the gallery image popup window based on the image's dimensions.\n         * @private\n         */\n        _resizeWindow: function () {\n            var img = this.element,\n                width = img.width() < this.options.minWidth ? this.options.minWidth : img.width();\n\n            window.resizeTo(width + this.options.widthOffset, img.height() + this.options.heightOffset);\n        }\n    });\n\n    return $.mage.gallery;\n});\n","Magento_Catalog/js/price-box.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'Magento_Catalog/js/price-utils',\n    'underscore',\n    'mage/template',\n    'jquery-ui-modules/widget'\n], function ($, utils, _, mageTemplate) {\n    'use strict';\n\n    var globalOptions = {\n        productId: null,\n        priceConfig: null,\n        prices: {},\n        priceTemplate: '<span class=\"price\"><%- data.formatted %></span>'\n    };\n\n    $.widget('mage.priceBox', {\n        options: globalOptions,\n        qtyInfo: '#qty',\n\n        /**\n         * Widget initialisation.\n         * Every time when option changed prices also can be changed. So\n         * changed options.prices -> changed cached prices -> recalculation -> redraw price box\n         */\n        _init: function initPriceBox() {\n            var box = this.element;\n\n            box.trigger('updatePrice');\n            this.cache.displayPrices = utils.deepClone(this.options.prices);\n        },\n\n        /**\n         * Widget creating.\n         */\n        _create: function createPriceBox() {\n            var box = this.element;\n\n            this.cache = {};\n            this._setDefaultsFromPriceConfig();\n            this._setDefaultsFromDataSet();\n\n            box.on('reloadPrice', this.reloadPrice.bind(this));\n            box.on('updatePrice', this.onUpdatePrice.bind(this));\n            $(this.qtyInfo).on('input', this.updateProductTierPrice.bind(this));\n            box.trigger('price-box-initialized');\n        },\n\n        /**\n         * Call on event updatePrice. Proxy to updatePrice method.\n         * @param {Event} event\n         * @param {Object} prices\n         */\n        onUpdatePrice: function onUpdatePrice(event, prices) {\n            return this.updatePrice(prices);\n        },\n\n        /**\n         * Updates price via new (or additional values).\n         * It expects object like this:\n         * -----\n         *   \"option-hash\":\n         *      \"price-code\":\n         *         \"amount\": 999.99999,\n         *         ...\n         * -----\n         * Empty option-hash object or empty price-code object treats as zero amount.\n         * @param {Object} newPrices\n         */\n        updatePrice: function updatePrice(newPrices) {\n            var prices = this.cache.displayPrices,\n                additionalPrice = {},\n                pricesCode = [],\n                priceValue, origin, finalPrice;\n\n            this.cache.additionalPriceObject = this.cache.additionalPriceObject || {};\n\n            if (newPrices) {\n                $.extend(this.cache.additionalPriceObject, newPrices);\n            }\n\n            if (!_.isEmpty(additionalPrice)) {\n                pricesCode = _.keys(additionalPrice);\n            } else if (!_.isEmpty(prices)) {\n                pricesCode = _.keys(prices);\n            }\n\n            _.each(this.cache.additionalPriceObject, function (additional) {\n                if (additional && !_.isEmpty(additional)) {\n                    pricesCode = _.keys(additional);\n                }\n                _.each(pricesCode, function (priceCode) {\n                    priceValue = additional[priceCode] || {};\n                    priceValue.amount = +priceValue.amount || 0;\n                    priceValue.adjustments = priceValue.adjustments || {};\n\n                    additionalPrice[priceCode] = additionalPrice[priceCode] || {\n                        'amount': 0,\n                        'adjustments': {}\n                    };\n                    additionalPrice[priceCode].amount =  0 + (additionalPrice[priceCode].amount || 0) +\n                        priceValue.amount;\n                    _.each(priceValue.adjustments, function (adValue, adCode) {\n                        additionalPrice[priceCode].adjustments[adCode] = 0 +\n                            (additionalPrice[priceCode].adjustments[adCode] || 0) + adValue;\n                    });\n                });\n            });\n\n            if (_.isEmpty(additionalPrice)) {\n                this.cache.displayPrices = utils.deepClone(this.options.prices);\n            } else {\n                _.each(additionalPrice, function (option, priceCode) {\n                    origin = this.options.prices[priceCode] || {};\n                    finalPrice = prices[priceCode] || {};\n                    option.amount = option.amount || 0;\n                    origin.amount = origin.amount || 0;\n                    origin.adjustments = origin.adjustments || {};\n                    finalPrice.adjustments = finalPrice.adjustments || {};\n\n                    finalPrice.amount = 0 + origin.amount + option.amount;\n                    _.each(option.adjustments, function (pa, paCode) {\n                        finalPrice.adjustments[paCode] = 0 + (origin.adjustments[paCode] || 0) + pa;\n                    });\n                }, this);\n            }\n\n            this.element.trigger('priceUpdated', this.cache.displayPrices);\n            this.element.trigger('reloadPrice');\n        },\n\n        /*eslint-disable no-extra-parens*/\n        /**\n         * Render price unit block.\n         */\n        reloadPrice: function reDrawPrices() {\n            var priceFormat = (this.options.priceConfig && this.options.priceConfig.priceFormat) || {},\n                priceTemplate = mageTemplate(this.options.priceTemplate);\n\n            _.each(this.cache.displayPrices, function (price, priceCode) {\n                price.final = _.reduce(price.adjustments, function (memo, amount) {\n                    return memo + amount;\n                }, price.amount);\n\n                price.formatted = utils.formatPrice(price.final, priceFormat);\n\n                $('[data-price-type=\"' + priceCode + '\"]', this.element).html(priceTemplate({\n                    data: price\n                }));\n            }, this);\n        },\n\n        /*eslint-enable no-extra-parens*/\n        /**\n         * Overwrites initial (default) prices object.\n         * @param {Object} prices\n         */\n        setDefault: function setDefaultPrices(prices) {\n            this.cache.displayPrices = utils.deepClone(prices);\n            this.options.prices = utils.deepClone(prices);\n        },\n\n        /**\n         * Custom behavior on getting options:\n         * now widget able to deep merge of accepted configuration.\n         * @param  {Object} options\n         * @return {mage.priceBox}\n         */\n        _setOptions: function setOptions(options) {\n            $.extend(true, this.options, options);\n\n            if ('disabled' in options) {\n                this._setOption('disabled', options.disabled);\n            }\n\n            return this;\n        },\n\n        /**\n         * setDefaultsFromDataSet\n         */\n        _setDefaultsFromDataSet: function _setDefaultsFromDataSet() {\n            var box = this.element,\n                priceHolders = $('[data-price-type]', box),\n                prices = this.options.prices;\n\n            this.options.productId = box.data('productId');\n\n            if (_.isEmpty(prices)) {\n                priceHolders.each(function (index, element) {\n                    var type = $(element).data('priceType'),\n                        amount = parseFloat($(element).data('priceAmount'));\n\n                    if (type && !_.isNaN(amount)) {\n                        prices[type] = {\n                            amount: amount\n                        };\n                    }\n                });\n            }\n        },\n\n        /**\n         * setDefaultsFromPriceConfig\n         */\n        _setDefaultsFromPriceConfig: function _setDefaultsFromPriceConfig() {\n            var config = this.options.priceConfig;\n\n            if (config && config.prices) {\n                this.options.prices = config.prices;\n            }\n        },\n\n        /**\n         * Updates product final price according to tier prices\n         */\n        updateProductTierPrice: function updateProductTierPrice() {\n            var productQty = $(this.qtyInfo).val(),\n                originalPrice = this.options.prices.finalPrice.amount,\n                tierPrice,\n                prices,\n                i;\n\n            for (i = 0; i < this.options.priceConfig.tierPrices.length; i++) {\n                if (productQty >= this.options.priceConfig.tierPrices[i].qty) {\n                    tierPrice = this.options.priceConfig.tierPrices[i].price;\n                }\n            }\n            prices = {\n                'prices': {\n                    'finalPrice': {\n                        'amount': tierPrice - originalPrice\n                    }\n                }\n            };\n            this.updatePrice(prices);\n        }\n    });\n\n    return $.mage.priceBox;\n});\n","Magento_Catalog/js/related-products.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget',\n    'mage/translate'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.relatedProducts', {\n        options: {\n            relatedCheckbox: '.related-checkbox', // Class name for a related product's input checkbox.\n            relatedProductsCheckFlag: false, // Related products checkboxes are initially unchecked.\n            relatedProductsField: '#related-products-field', // Hidden input field that stores related products.\n            selectAllMessage: $.mage.__('select all'),\n            unselectAllMessage: $.mage.__('unselect all'),\n            selectAllLink: '[data-role=\"select-all\"]',\n            elementsSelector: '.item.product'\n        },\n\n        /**\n         * Bind events to the appropriate handlers.\n         * @private\n         */\n        _create: function () {\n            $(this.options.selectAllLink, this.element).on('click', $.proxy(this._selectAllRelated, this));\n            $(this.options.relatedCheckbox, this.element).on('click', $.proxy(this._addRelatedToProduct, this));\n\n            if (this.element.data('shuffle')) {\n                this._shuffle(this.element.find(this.options.elementsSelector));\n            }\n            this._showRelatedProducts(\n                this.element.find(this.options.elementsSelector),\n                this.element.data('limit'),\n                this.element.data('shuffle-weighted')\n            );\n        },\n\n        /**\n         * This method either checks all checkboxes for a product's set of related products (select all)\n         * or unchecks them (unselect all).\n         * @private\n         * @param {jQuery.Event} e - Click event on either the \"select all\" link or the \"unselect all\" link.\n         * @return {Boolean} - Prevent default event action and event propagation.\n         */\n        _selectAllRelated: function (e) {\n            var innerHTML = this.options.relatedProductsCheckFlag ?\n                this.options.selectAllMessage : this.options.unselectAllMessage;\n\n            $(e.target).html(innerHTML);\n            $(this.options.relatedCheckbox).attr(\n                'checked',\n                this.options.relatedProductsCheckFlag = !this.options.relatedProductsCheckFlag\n            );\n            this._addRelatedToProduct();\n\n            return false;\n        },\n\n        /**\n         * This method iterates through each checkbox for all related products and collects only those products\n         * whose checkbox has been checked. The selected related products are stored in a hidden input field.\n         * @private\n         */\n        _addRelatedToProduct: function () {\n            $(this.options.relatedProductsField).val(\n                $(this.options.relatedCheckbox + ':checked').map(function () {\n                    return this.value;\n                }).get().join(',')\n            );\n        },\n\n        /* jscs:disable */\n        /* eslint-disable */\n        /**\n         * Show related products according to limit. Shuffle if needed.\n         * @param {*} elements\n         * @param {*} limit\n         * @param weightedRandom\n         * @private\n         */\n        _showRelatedProducts: function (elements, limit, weightedRandom) {\n            var index, weights = [], random = [], weight = 2, shown = 0, $element, currentGroup, prevGroup;\n\n            if (limit === 0) {\n                limit = elements.length;\n            }\n\n            if (weightedRandom && limit > 0 && limit < elements.length) {\n                for (index = 0; index < limit; index++) {\n                    $element = $(elements[index]);\n                    if ($element.data('shuffle-group') !== '') {\n                        break;\n                    }\n                    $element.show();\n                    shown++;\n                }\n                limit -= shown;\n                for (index = elements.length - 1; index >= 0; index--) {\n                    $element = $(elements[index]);\n                    currentGroup = $element.data('shuffle-group');\n                    if (currentGroup !== '') {\n                        weights.push([index, Math.log(weight)]);\n                        if (typeof prevGroup !== 'undefined' && prevGroup !== currentGroup) {\n                            weight += 2;\n                        }\n                        prevGroup = currentGroup;\n                    }\n                }\n\n                if (weights.length === 0) {\n                    return;\n                }\n\n                for (index = 0; index < weights.length; index++) {\n                    random.push([weights[index][0], Math.pow(Math.random(), 1 / weights[index][1])]);\n                }\n\n                random.sort(function(a, b) {\n                    a = a[1];\n                    b = b[1];\n                    return a < b ? 1 : (a > b ? -1 : 0);\n                });\n                index = 0;\n                while (limit) {\n                    $(elements[random[index][0]]).show();\n                    limit--;\n                    index++\n                }\n                return;\n            }\n\n            for (index = 0; index < limit; index++) {\n                $(elements[index]).show();\n            }\n        },\n\n        /* jscs:disable */\n        /* eslint-disable */\n        /**\n         * Shuffle an array\n         * @param {Array} elements\n         * @returns {*}\n         */\n        _shuffle: function shuffle(elements) {\n            var parent, child, lastSibling;\n            if (elements.length) {\n                parent = $(elements[0]).parent();\n            }\n            while (elements.length) {\n                child = elements.splice(Math.floor(Math.random() *  elements.length), 1)[0];\n                lastSibling = parent.find('[data-shuffle-group=\"' + $(child).data('shuffle-group') + '\"]').last();\n                lastSibling.after(child);\n            }\n        }\n\n        /* jscs:disable */\n        /* eslint:disable */\n    });\n\n    return $.mage.relatedProducts;\n});\n","Magento_Catalog/js/product/learn-more.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'Magento_Catalog/js/product/list/column-status-validator'\n], function (Column, columnStatusValidator) {\n    'use strict';\n\n    return Column.extend({\n        /**\n         * Depends on this option, \"Learn More\" link can be shown or hide. Depends on  backend configuration\n         *\n         * @returns {Boolean}\n         */\n        isAllowed: function () {\n            return columnStatusValidator.isValid(this.source(), 'learn_more', 'show_attributes');\n        }\n    });\n});\n","Magento_Catalog/js/product/uenc-processor.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([], function () {\n        'use strict';\n\n        /**\n         * Check data to JSON.\n         *\n         * @returns {Boolean}\n         */\n        function _isJSON(data) {\n            try {\n                JSON.parse(data);\n            } catch (e) {\n                return false;\n            }\n\n            return true;\n        }\n\n        /**\n         * Processes data.\n         *\n         * @param {Object} data\n         * @param {String} placeholder\n         * @param {String} uenc\n         *\n         * @returns {String}\n         */\n        function _stringProcessor(data, placeholder, uenc) {\n            if (data && ~data.indexOf(placeholder)) {\n                return data.replace(placeholder, uenc);\n            }\n\n            return data;\n        }\n\n        /**\n         * Processes data.\n         *\n         * @param {Object} data\n         * @param {String} placeholder\n         * @param {String} uenc\n         *\n         * @returns {String}\n         */\n        function _objectProcessor(data, placeholder, uenc) {\n            data = JSON.parse(data);\n\n            if (data.hasOwnProperty('action')) {\n                data.action = _stringProcessor(data.action, placeholder, uenc);\n            }\n\n            if (data.hasOwnProperty('data') && data.data.hasOwnProperty('uenc')) {\n                data.data.uenc = uenc;\n            }\n\n            return JSON.stringify(data);\n        }\n\n        /**\n         * Processes data.\n         *\n         * @param {Object} data\n         * @param {String} placeholder\n         *\n         * @returns {String}\n         */\n        return function (data, placeholder) {\n            var uenc = btoa(window.location.href).replace('+/=', '-_,');\n\n            placeholder = placeholder || encodeURI('%uenc%');\n\n            return _isJSON(data) ?\n                _objectProcessor(data, placeholder, uenc) :\n                _stringProcessor(data, placeholder, uenc);\n\n        };\n    }\n);\n","Magento_Catalog/js/product/addtocompare-button.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'Magento_Catalog/js/product/uenc-processor',\n    'Magento_Catalog/js/product/list/column-status-validator'\n], function (Column, uencProcessor, columnStatusValidator) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            label: ''\n        },\n\n        /**\n         * Prepare Data-Post data that will be used in data-mage-init\n         *\n         * @param {Object} row\n         * @returns {Array}\n         */\n        getDataPost: function (row) {\n            return uencProcessor(row['add_to_compare_button'].url ||\n                    row['add_to_compare_button']['post_data']);\n        },\n\n        /**\n         * Depends on this option, \"Add to compare\" button can be shown or hide. Depends on  backend configuration\n         *\n         * @returns {Boolean}\n         */\n        isAllowed: function () {\n            return columnStatusValidator.isValid(this.source(), 'add_to_compare', 'show_buttons');\n        },\n\n        /**\n         * Get button label.\n         *\n         * @return {String}\n         */\n        getLabel: function () {\n            return this.label;\n        }\n    });\n});\n","Magento_Catalog/js/product/provider.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'jquery',\n    'mageUtils',\n    'uiElement',\n    'Magento_Catalog/js/product/storage/storage-service',\n    'Magento_Customer/js/customer-data',\n    'Magento_Catalog/js/product/view/product-ids-resolver'\n], function (_, $, utils, Element, storage, customerData, productResolver) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            identifiersConfig: {\n                namespace: ''\n            },\n            productStorageConfig: {\n                namespace: 'product_data_storage',\n                customerDataProvider: 'product_data_storage',\n                updateRequestConfig: {\n                    url: '',\n                    method: 'GET',\n                    dataType: 'json'\n                },\n                className: 'DataStorage'\n            },\n            ids: {},\n            listens: {\n                ids: 'idsHandler'\n            }\n        },\n\n        /**\n         * Initializes provider component.\n         *\n         * @returns {Provider} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .initIdsStorage();\n\n            return this;\n        },\n\n        /**\n         * Calls 'initObservable' of parent\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super();\n            this.observe('ids');\n\n            return this;\n        },\n\n        /**\n         * Initializes ids storage.\n         *\n         * @returns {Provider} Chainable.\n         */\n        initIdsStorage: function () {\n            storage.onStorageInit(this.identifiersConfig.namespace, this.idsStorageHandler.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Initializes ids storage handler.\n         *\n         * @param {Object} idsStorage\n         */\n        idsStorageHandler: function (idsStorage) {\n            this.idsStorage = idsStorage;\n            this.productStorage = storage.createStorage(this.productStorageConfig);\n            this.productStorage.data.subscribe(this.dataCollectionHandler.bind(this));\n\n            if (~~this.idsStorage.allowToSendRequest) {\n                customerData.reload([idsStorage.namespace]).done(this._resolveDataByIds.bind(this));\n            } else {\n                this._resolveDataByIds();\n            }\n        },\n\n        /**\n         * Callback, which load by ids from ids-storage product data\n         *\n         * @private\n         */\n        _resolveDataByIds: function () {\n            this.initIdsListener();\n            this.idsMerger(\n                this.idsStorage.get(),\n                this.prepareDataFromCustomerData(customerData.get(this.identifiersConfig.namespace)())\n            );\n\n            if (!_.isEmpty(this.productStorage.data())) {\n                this.dataCollectionHandler(this.productStorage.data());\n            } else {\n                this.productStorage.setIds(this.data.currency, this.data.store, this.ids());\n            }\n        },\n\n        /**\n         * Init ids storage listener.\n         */\n        initIdsListener: function () {\n            customerData.get(this.identifiersConfig.namespace).subscribe(function (data) {\n                this.idsMerger(this.prepareDataFromCustomerData(data));\n            }.bind(this));\n            this.idsStorage.data.subscribe(this.idsMerger.bind(this));\n        },\n\n        /**\n         * Prepare data from customerData.\n         *\n         * @param {Object} data\n         *\n         * @returns {Object}\n         */\n        prepareDataFromCustomerData: function (data) {\n            data = data.items ? data.items : data;\n\n            return data;\n        },\n\n        /**\n         * Filter ids by their lifetime in order to show only hot ids :)\n         *\n         * @param {Object} ids\n         * @returns {Array}\n         */\n        filterIds: function (ids) {\n            var _ids = {},\n                currentTime = new Date().getTime() / 1000,\n                currentProductIds = productResolver($('#product_addtocart_form')),\n                productCurrentScope = this.data.productCurrentScope,\n                scopeId = productCurrentScope === 'store' ? window.checkout.storeId :\n                productCurrentScope === 'group' ? window.checkout.storeGroupId :\n                    window.checkout.websiteId;\n\n            _.each(ids, function (id, key) {\n                if (\n                    currentTime - ids[key]['added_at'] < ~~this.idsStorage.lifetime &&\n                    !_.contains(currentProductIds, ids[key]['product_id']) &&\n                    (!id.hasOwnProperty('scope_id') || ids[key]['scope_id'] === scopeId)\n                ) {\n                    _ids[id['product_id']] = id;\n\n                }\n            }, this);\n\n            return _ids;\n        },\n\n        /**\n         * Merges id from storage and customer data\n         *\n         * @param {Object} data\n         * @param {Object} optionalData\n         */\n        idsMerger: function (data, optionalData) {\n            if (data && optionalData) {\n                data = _.extend(data, optionalData);\n            }\n\n            if (!_.isEmpty(data)) {\n                this.ids(\n                    this.filterIds(_.extend(this.ids(), data))\n                );\n            }\n        },\n\n        /**\n         * Ids update handler\n         *\n         * @param {Object} data\n         */\n        idsHandler: function (data) {\n            this.productStorage.setIds(this.data.currency, this.data.store, data);\n        },\n\n        /**\n         * Process data\n         *\n         * @param {Object} data\n         */\n        processData: function (data) {\n            var curData = utils.copy(this.data),\n                ids = this.ids();\n\n            delete data['data_id'];\n            data = _.values(data);\n\n            _.each(data, function (record, index) {\n                record._rowIndex = index;\n                record['added_at'] = ids[record.id]['added_at'];\n            }, this);\n\n            curData.items = data;\n            this.set('data', curData);\n        },\n\n        /**\n         * Product storage data handler\n         *\n         * @param {Object} data\n         */\n        dataCollectionHandler: function (data) {\n            data = this.filterData(data);\n            this.processData(data);\n        },\n\n        /**\n         * Filters data from product storage by ids\n         *\n         * @param {Object} data\n         *\n         * @returns {Object}\n         */\n        filterData: function (data) {\n            var result = {},\n                i = 0,\n                ids = _.keys(this.ids()),\n                length = ids.length;\n\n            for (i; i < length; i++) {\n                if (ids[i] && data[ids[i]]) {\n                    result[ids[i]] = data[ids[i]];\n                }\n            }\n\n            return result;\n        }\n    });\n});\n","Magento_Catalog/js/product/query-builder.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n        'underscore'\n    ], function (_) {\n        'use strict';\n\n        return {\n\n            /**\n             * Build query to get id\n             *\n             * @param {Object} data\n             */\n            buildQuery: function (data) {\n                var filters = [];\n\n                _.each(data, function (value, key) {\n                    filters.push({\n                        field: key,\n                        value: value,\n                        'condition_type': 'in'\n                    });\n                });\n\n                return {\n                    searchCriteria: {\n                        filterGroups: [\n                            {\n                                filters: filters\n                            }\n                        ]\n                    }\n                };\n            }\n        };\n    }\n);\n","Magento_Catalog/js/product/name.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'Magento_Catalog/js/product/list/column-status-validator',\n    'escaper'\n], function (Column, columnStatusValidator, escaper) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            allowedTags: ['div', 'span', 'b', 'strong', 'i', 'em', 'u', 'a']\n        },\n\n        /**\n         * Depends on this option, product name can be shown or hide. Depends on  backend configuration\n         *\n         * @returns {Boolean}\n         */\n        isAllowed: function () {\n            return columnStatusValidator.isValid(this.source(), 'name', 'show_attributes');\n        },\n\n        /**\n         * Name column.\n         *\n         * @param {String} label\n         * @returns {String}\n         */\n        getNameUnsanitizedHtml: function (label) {\n            return escaper.escapeHtml(label, this.allowedTags);\n        }\n    });\n});\n","Magento_Catalog/js/product/breadcrumbs.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Theme/js/model/breadcrumb-list'\n], function ($, breadcrumbList) {\n    'use strict';\n\n    return function (widget) {\n\n        $.widget('mage.breadcrumbs', widget, {\n            options: {\n                categoryUrlSuffix: '',\n                useCategoryPathInUrl: false,\n                product: '',\n                categoryItemSelector: '.category-item',\n                menuContainer: '[data-action=\"navigation\"] > ul'\n            },\n\n            /** @inheritdoc */\n            _render: function () {\n                this._appendCatalogCrumbs();\n                this._super();\n            },\n\n            /**\n             * Append category and product crumbs.\n             *\n             * @private\n             */\n            _appendCatalogCrumbs: function () {\n                var categoryCrumbs = this._resolveCategoryCrumbs();\n\n                categoryCrumbs.forEach(function (crumbInfo) {\n                    breadcrumbList.push(crumbInfo);\n                });\n\n                if (this.options.product) {\n                    breadcrumbList.push(this._getProductCrumb());\n                }\n            },\n\n            /**\n             * Resolve categories crumbs.\n             *\n             * @return Array\n             * @private\n             */\n            _resolveCategoryCrumbs: function () {\n                var menuItem = this._resolveCategoryMenuItem(),\n                    categoryCrumbs = [];\n\n                if (menuItem !== null && menuItem.length) {\n                    categoryCrumbs.unshift(this._getCategoryCrumb(menuItem));\n\n                    while ((menuItem = this._getParentMenuItem(menuItem)) !== null) {\n                        categoryCrumbs.unshift(this._getCategoryCrumb(menuItem));\n                    }\n                }\n\n                return categoryCrumbs;\n            },\n\n            /**\n             * Returns crumb data.\n             *\n             * @param {Object} menuItem\n             * @return {Object}\n             * @private\n             */\n            _getCategoryCrumb: function (menuItem) {\n                return {\n                    'name': 'category',\n                    'label': menuItem.text(),\n                    'link': menuItem.attr('href'),\n                    'title': ''\n                };\n            },\n\n            /**\n             * Returns product crumb.\n             *\n             * @return {Object}\n             * @private\n             */\n            _getProductCrumb: function () {\n                return {\n                    'name': 'product',\n                    'label': this.options.product,\n                    'link': '',\n                    'title': ''\n                };\n            },\n\n            /**\n             * Find parent menu item for current.\n             *\n             * @param {Object} menuItem\n             * @return {Object|null}\n             * @private\n             */\n            _getParentMenuItem: function (menuItem) {\n                var classes,\n                    classNav,\n                    parentClass,\n                    parentMenuItem = null;\n\n                if (!menuItem) {\n                    return null;\n                }\n\n                classes = menuItem.parent().attr('class');\n                classNav = classes.match(/(nav\\-)[0-9]+(\\-[0-9]+)+/gi);\n\n                if (classNav) {\n                    classNav = classNav[0];\n                    parentClass = classNav.substr(0, classNav.lastIndexOf('-'));\n\n                    if (parentClass.lastIndexOf('-') !== -1) {\n                        parentMenuItem = $(this.options.menuContainer).find('.' + parentClass + ' > a');\n                        parentMenuItem = parentMenuItem.length ? parentMenuItem : null;\n                    }\n                }\n\n                return parentMenuItem;\n            },\n\n            /**\n             * Returns category menu item.\n             *\n             * Tries to resolve category from url or from referrer as fallback and\n             * find menu item from navigation menu by category url.\n             *\n             * @return {Object|null}\n             * @private\n             */\n            _resolveCategoryMenuItem: function () {\n                var categoryUrl = this._resolveCategoryUrl(),\n                    menu = $(this.options.menuContainer),\n                    categoryMenuItem = null;\n\n                if (categoryUrl && menu.length) {\n                    categoryMenuItem = menu.find(\n                        this.options.categoryItemSelector +\n                        ' > a[href=\"' + categoryUrl + '\"]'\n                    );\n                }\n\n                return categoryMenuItem;\n            },\n\n            /**\n             * Returns category url.\n             *\n             * @return {String}\n             * @private\n             */\n            _resolveCategoryUrl: function () {\n                var categoryUrl;\n\n                if (this.options.useCategoryPathInUrl) {\n                    // In case category path is used in product url - resolve category url from current url.\n                    categoryUrl = window.location.href.split('?')[0];\n                    categoryUrl = categoryUrl.substring(0, categoryUrl.lastIndexOf('/')) +\n                        this.options.categoryUrlSuffix;\n                } else {\n                    // In other case - try to resolve it from referrer (without parameters).\n                    categoryUrl = document.referrer;\n\n                    if (categoryUrl.indexOf('?') > 0) {\n                        categoryUrl = categoryUrl.substr(0, categoryUrl.indexOf('?'));\n                    }\n                }\n\n                return categoryUrl;\n            }\n        });\n\n        return $.mage.breadcrumbs;\n    };\n});\n","Magento_Catalog/js/product/addtocart-button.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'Magento_Catalog/js/product/uenc-processor',\n    'Magento_Catalog/js/product/list/column-status-validator'\n], function (Element, uencProcessor, columnStatusValidator) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            label: ''\n        },\n\n        /**\n         * Prepare data, that will be inserted as data-mage-init attribute into button. With help of this attribute\n         * Add To * buttons can understand post data and urls\n         *\n         * @param {Object} row\n         * @returns {String}\n         */\n        getDataMageInit: function (row) {\n            return '{\"redirectUrl\": { \"url\" : \"'  + uencProcessor(row['add_to_cart_button'].url) + '\"}}';\n        },\n\n        /**\n         * Prepare Data-Post data that will be used in data-mage-init\n         *\n         * @param {Object} row\n         * @return {String}\n         */\n        getDataPost: function (row) {\n            return uencProcessor(row['add_to_cart_button']['post_data']);\n        },\n\n        /**\n         * Check if product has required options.\n         *\n         * @param {Object} row\n         * @return {Boolean}\n         */\n        hasRequiredOptions: function (row) {\n            return row['add_to_cart_button']['required_options'];\n        },\n\n        /**\n         * Depends on this option, \"Add to cart\" button can be shown or hide\n         *\n         * @param {Object} row\n         * @returns {Boolean}\n         */\n        isSalable: function (row) {\n            return row['is_salable'];\n        },\n\n        /**\n         * Depends on this option, stock status text can be \"In stock\" or \"Out Of Stock\"\n         *\n         * @param {Object} row\n         * @returns {Boolean}\n         */\n        isAvailable: function (row) {\n            return row['is_available'];\n        },\n\n        /**\n         * Depends on this option, \"Add to cart\" button can be shown or hide. Depends on  backend configuration\n         *\n         * @returns {Boolean}\n         */\n        isAllowed: function () {\n            return columnStatusValidator.isValid(this.source(), 'add_to_cart', 'show_buttons');\n        },\n\n        /**\n         * Get button label.\n         *\n         * @return {String}\n         */\n        getLabel: function () {\n            return this.label;\n        }\n    });\n});\n","Magento_Catalog/js/product/provider-compared.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    './provider',\n    'Magento_Catalog/js/product/storage/storage-service',\n    'Magento_Customer/js/customer-data'\n], function (_, Provider, storage, customerData) {\n    'use strict';\n\n    return Provider.extend({\n\n        /**\n         * Ids update handler\n         *\n         * @param {Object} data\n         */\n        idsHandler: function (data) {\n            this.productStorage.setIds(this.data.currency, this.data.store, this.dataFilter(data));\n        },\n\n        /**\n         * Filters data by provider\n         *\n         * @param {Object} data\n         *\n         * @returns {Object}\n         */\n        dataFilter: function (data) {\n            var providerData = this.idsStorage.prepareData(customerData.get(this.identifiersConfig.provider)().items),\n                result = {},\n                productCurrentScope,\n                scopeId;\n\n            if (typeof this.data.productCurrentScope !== 'undefined') {\n                productCurrentScope = this.data.productCurrentScope;\n                scopeId = productCurrentScope === 'store' ? window.checkout.storeId :\n                    productCurrentScope === 'group' ? window.checkout.storeGroupId :\n                        window.checkout.websiteId;\n                _.each(data, function (value, key) {\n                    if (!providerData[productCurrentScope + '-' + scopeId + '-' + key]) {\n                        result[key] = value;\n                    }\n                });\n            } else {\n                _.each(data, function (value, key) {\n                    if (!providerData[key]) {\n                        result[key] = value;\n                    }\n                });\n            }\n\n            return result;\n        },\n\n        /**\n         * Filters data from product storage by ids\n         *\n         * @param {Object} data\n         *\n         * @returns {Object}\n         */\n        filterData: function (data) {\n            var result = {},\n                i = 0,\n                ids = _.keys(this.dataFilter(this.ids())),\n                length = ids.length;\n\n            for (i; i < length; i++) {\n                if (ids[i] && data[ids[i]]) {\n                    result[ids[i]] = data[ids[i]];\n                }\n            }\n\n            return result;\n        }\n    });\n});\n","Magento_Catalog/js/product/remaining-characters.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/translate',\n    'jquery-ui-modules/widget'\n], function ($, $t) {\n    'use strict';\n\n    $.widget('mage.remainingCharacters', {\n        options: {\n            remainingText: $t('remaining'),\n            tooManyText: $t('too many'),\n            errorClass: 'mage-error',\n            noDisplayClass: 'no-display'\n        },\n\n        /**\n         * Initializes custom option component\n         *\n         * @private\n         */\n        _create: function () {\n            this.note = $(this.options.noteSelector);\n            this.counter = $(this.options.counterSelector);\n\n            this.updateCharacterCount();\n            this.element.on('change keyup paste', this.updateCharacterCount.bind(this));\n        },\n\n        /**\n         * Updates counter message\n         */\n        updateCharacterCount: function () {\n            var length = this.element.val().length,\n                diff = this.options.maxLength - length;\n\n            this.counter.text(this._formatMessage(diff));\n            this.counter.toggleClass(this.options.noDisplayClass, length === 0);\n            this.note.toggleClass(this.options.errorClass, diff < 0);\n        },\n\n        /**\n         * Format remaining characters message\n         *\n         * @param {int} diff\n         * @returns {String}\n         * @private\n         */\n        _formatMessage: function (diff) {\n            var count = Math.abs(diff),\n                qualifier = diff < 0 ? this.options.tooManyText : this.options.remainingText;\n\n            return '(' + count + ' ' + qualifier + ')';\n        }\n    });\n\n    return $.mage.remainingCharacters;\n});\n","Magento_Catalog/js/product/storage/ids-storage.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'ko',\n    'mageUtils',\n    'jquery/jquery-storageapi'\n], function ($, _, ko, utils) {\n    'use strict';\n\n    /**\n     * Set data to localStorage with support check.\n     *\n     * @param {String} namespace\n     * @param {Object} data\n     */\n    function setLocalStorageItem(namespace, data) {\n        try {\n            window.localStorage.setItem(namespace, JSON.stringify(data));\n        } catch (e) {\n            console.warn('localStorage is unavailable - skipping local caching of product data');\n            console.error(e);\n        }\n    }\n\n    return {\n\n        /**\n         * Class name\n         */\n        name: 'IdsStorage',\n\n        /**\n         * Initializes class\n         *\n         * @return Chainable.\n         */\n        initialize: function () {\n            if (!this.data) {\n                this.data = ko.observable({});\n            }\n\n            this.initCustomerDataReloadListener()\n                .initLocalStorage()\n                .cachesDataFromLocalStorage()\n                .initDataListener();\n\n            return this;\n        },\n\n        /**\n         * Gets data from local storage by current namespace\n         *\n         * @return {Object}.\n         */\n        getDataFromLocalStorage: function () {\n            return this.localStorage.get();\n        },\n\n        /**\n         * Caches data from local storage to local scope\n         *\n         * @return Chainable.\n         */\n        cachesDataFromLocalStorage: function () {\n            this.data(this.getDataFromLocalStorage());\n\n            return this;\n        },\n\n        /**\n         * Initialize localStorage\n         *\n         * @return Chainable.\n         */\n        initLocalStorage: function () {\n            this.localStorage = $.initNamespaceStorage(this.namespace).localStorage;\n\n            return this;\n        },\n\n        /**\n         * Initializes listener to \"data\" property\n         */\n        initDataListener: function () {\n            this.data.subscribe(this.internalDataHandler.bind(this));\n        },\n\n        /**\n         * Initialize listener to customer data reload\n         *\n         * @return Chainable.\n         */\n        initCustomerDataReloadListener: function () {\n            $(document).on('customer-data-reload', function (event, sections) {\n                if ((_.isEmpty(sections) || _.contains(sections, this.namespace)) && ~~this.allowToSendRequest) {\n                    this.localStorage.removeAll();\n                    this.data();\n                }\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Initializes handler to \"data\" property update\n         */\n        internalDataHandler: function (data) {\n            setLocalStorageItem(this.namespace, data);\n        },\n\n        /**\n         * Initializes handler to storage update\n         */\n        externalDataHandler: function (data) {\n            data = data.items ? data.items : data;\n\n            this.set(_.extend(utils.copy(this.data()), data));\n        }\n    };\n});\n\n","Magento_Catalog/js/product/storage/ids-storage-compare.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'ko',\n    'mageUtils',\n    'Magento_Customer/js/customer-data',\n    'Magento_Catalog/js/product/storage/ids-storage'\n], function (_, ko, utils, customerData, idsStorage) {\n    'use strict';\n\n    return _.extend(utils.copy(idsStorage), {\n\n        /**\n         * Class name\n         */\n        name: 'IdsStorageCompare',\n\n        /**\n         * Initializes class\n         *\n         * @return Chainable.\n         */\n        initialize: function () {\n            if (!this.data) {\n                this.data = ko.observable({});\n            }\n\n            if (this.provider) {\n                this.providerDataHandler(customerData.get(this.provider)());\n                this.initProviderListener();\n            }\n\n            this.initLocalStorage()\n                .cachesDataFromLocalStorage()\n                .initDataListener();\n\n            return this;\n        },\n\n        /**\n         * Initializes listener for external data provider\n         */\n        initProviderListener: function () {\n            customerData.get(this.provider).subscribe(this.providerDataHandler.bind(this));\n        },\n\n        /**\n         * Initializes handler for external data provider update\n         *\n         * @param {Object} data\n         */\n        providerDataHandler: function (data) {\n            data = data.items || data;\n            data = this.prepareData(data);\n\n            this.add(data);\n        },\n\n        /**\n         * Prepares data to correct interface\n         *\n         * @param {Object} data\n         *\n         * @returns {Object} data\n         */\n        prepareData: function (data) {\n            var result = {},\n                scopeId;\n\n            _.each(data, function (item) {\n                if (typeof item.productScope !== 'undefined') {\n                    scopeId = item.productScope === 'store' ? window.checkout.storeId :\n                        item.productScope === 'group' ? window.checkout.storeGroupId :\n                            window.checkout.websiteId;\n\n                    result[item.productScope + '-' + scopeId + '-' + item.id] = {\n                        'added_at': new Date().getTime() / 1000,\n                        'product_id': item.id,\n                        'scope_id': scopeId\n                    };\n                } else {\n                    result[item.id] = {\n                        'added_at': new Date().getTime() / 1000,\n                        'product_id': item.id\n                    };\n                }\n            });\n\n            return result;\n        }\n    });\n});\n","Magento_Catalog/js/product/storage/storage-service.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'mageUtils',\n    'mage/translate',\n    'Magento_Catalog/js/product/storage/ids-storage',\n    'Magento_Catalog/js/product/storage/data-storage',\n    'Magento_Catalog/js/product/storage/ids-storage-compare'\n], function ($, _, utils, $t, IdsStorage, DataStore, IdsStorageCompare) {\n    'use strict';\n\n    return (function () {\n\n        var /**\n             * {Object} storages - list of storages\n             */\n            storages = {},\n\n            /**\n             * {Object} classes - list of classes\n             */\n            classes = {},\n\n            /**\n             * {Object} prototype - methods that will be added to all storage classes to prototype property.\n             */\n            prototype = {\n\n                /**\n                 * Sets data to storage\n                 *\n                 * @param {*} data\n                 */\n                set: function (data) {\n                    if (!utils.compare(data, this.data()).equal) {\n                        this.data(data);\n                    }\n                },\n\n                /**\n                 * Adds some data to current storage data\n                 *\n                 * @param {*} data\n                 */\n                add: function (data) {\n                    if (!_.isEmpty(data)) {\n                        this.data(_.extend(utils.copy(this.data()), data));\n                    }\n                },\n\n                /**\n                 * Gets current storage data\n                 *\n                 * @returns {*} data\n                 */\n                get: function () {\n                    return this.data();\n                }\n            },\n\n            /**\n             * Required properties to storage\n             */\n            storagesInterface =  {\n                data: 'function',\n                initialize: 'function',\n                namespace: 'string'\n            },\n\n            /**\n             * Private service methods\n             */\n            _private = {\n\n                /**\n                 * Overrides class method and add ability use _super to call parent method\n                 *\n                 * @param {Object} extensionMethods\n                 * @param {Object} originInstance\n                 */\n                overrideClassMethods: function (extensionMethods, originInstance) {\n                    var methodsName = _.keys(extensionMethods),\n                        i = 0,\n                        length = methodsName.length;\n\n                    for (i; i < length; i++) {\n                        if (_.isFunction(originInstance[methodsName[i]])) {\n                            originInstance[methodsName[i]] = extensionMethods[methodsName[i]];\n                        }\n                    }\n\n                    return originInstance;\n                },\n\n                /**\n                 * Checks is storage implement interface\n                 *\n                 * @param {Object} classInstance\n                 *\n                 * @returns {Boolean}\n                 */\n                isImplementInterface: function (classInstance) {\n                    _.each(storagesInterface, function (key, value) {\n                        if (typeof classInstance[key] !== value) {\n                            return false;\n                        }\n                    });\n\n                    return true;\n                }\n            },\n\n            /**\n             * Subscribers list\n             */\n            subsctibers = {};\n\n        (function () {\n            /**\n             * @param {Object} config\n             * @return void\n             */\n            classes[IdsStorage.name] = function (config) {\n                _.extend(this, IdsStorage, config);\n            };\n\n            /**\n             * @param {Object} config\n             * @return void\n             */\n            classes[IdsStorageCompare.name] = function (config) {\n                _.extend(this, IdsStorageCompare, config);\n            };\n\n            /**\n             * @param {Object} config\n             * @return void\n             */\n            classes[DataStore.name] = function (config) {\n                _.extend(this, DataStore, config);\n            };\n\n            _.each(classes, function (classItem) {\n                classItem.prototype = prototype;\n            });\n        })();\n\n        return {\n\n            /**\n             * Creates new storage or returns if storage with declared namespace exist\n             *\n             * @param {Object} config - storage config\n             * @throws {Error}\n             * @returns {Object} storage instance\n             */\n            createStorage: function (config) {\n                var instance,\n                    initialized;\n\n                if (storages[config.namespace]) {\n                    return storages[config.namespace];\n                }\n\n                instance = new classes[config.className](config);\n\n                if (_private.isImplementInterface(instance)) {\n                    initialized = storages[config.namespace] = instance.initialize();\n                    this.processSubscribers(initialized, config);\n\n                    return initialized;\n                }\n\n                throw new Error('Class ' + config.className + $t('does not implement Storage Interface'));\n            },\n\n            /**\n             * Process subscribers\n             *\n             * Differentiate subscribers by their namespaces: recently_viewed or recently_compared\n             * and process callbacks. Callbacks can be add through onStorageInit function\n             *\n             * @param {Object} initialized\n             * @param {Object} config\n             * @return void\n             */\n            processSubscribers: function (initialized, config) {\n                if (subsctibers[config.namespace]) {\n                    _.each(subsctibers[config.namespace], function (callback) {\n                        callback(initialized);\n                    });\n\n                    delete subsctibers[config.namespace];\n                }\n            },\n\n            /**\n             * Listens storage creating by namespace\n             *\n             * @param {String} namespace\n             * @param {Function} callback\n             * @return void\n             */\n            onStorageInit: function (namespace, callback) {\n                if (storages[namespace]) {\n                    callback(storages[namespace]);\n                } else {\n                    subsctibers[namespace] ?\n                        subsctibers[namespace].push(callback) :\n                        subsctibers[namespace] = [callback];\n                }\n            },\n\n            /**\n             * Gets storage by namespace\n             *\n             * @param {String} namespace\n             *\n             * @returns {Object} storage insance\n             */\n            getStorage: function (namespace) {\n                return storages[namespace];\n            }\n        };\n    })();\n});\n\n","Magento_Catalog/js/product/storage/data-storage.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'ko',\n    'mageUtils',\n    'Magento_Catalog/js/product/query-builder',\n    'Magento_Customer/js/customer-data',\n    'jquery/jquery-storageapi'\n], function ($, _, ko, utils, queryBuilder, customerData) {\n    'use strict';\n\n    /**\n     * Process data from API request\n     *\n     * @param {Object} data\n     * @returns {Object}\n     */\n    function getParsedDataFromServer(data) {\n        var result = {};\n\n        _.each(data.items, function (item) {\n                if (item.id) {\n                    result[item.id] = item;\n                }\n            }\n        );\n\n        return {\n            items: result\n        };\n    }\n\n    /**\n     * Set data to localStorage with support check.\n     *\n     * @param {String} namespace\n     * @param {Object} data\n     */\n    function setLocalStorageItem(namespace, data) {\n        try {\n            window.localStorage.setItem(namespace, JSON.stringify(data));\n        } catch (e) {\n            console.warn('localStorage is unavailable - skipping local caching of product data');\n            console.error(e);\n        }\n    }\n\n    return {\n\n        /**\n         * Class name\n         */\n        name: 'DataStorage',\n        request: {},\n        customerDataProvider: 'product_data_storage',\n\n        /**\n         * Initialize class\n         *\n         * @return Chainable.\n         */\n        initialize: function () {\n            if (!this.data) {\n                this.data = ko.observable({});\n            }\n\n            this.initLocalStorage()\n                .initCustomerDataReloadListener()\n                .cachesDataFromLocalStorage()\n                .initDataListener()\n                .initProvideStorage()\n                .initProviderListener();\n\n            return this;\n        },\n\n        /**\n         * Initialize listener to customer data reload\n         *\n         * @return Chainable.\n         */\n        initCustomerDataReloadListener: function () {\n            $(document).on('customer-data-invalidate', this._flushProductStorage.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Flush product storage\n         *\n         * @private\n         * @return void\n         */\n        _flushProductStorage: function (event, sections) {\n            if (_.isEmpty(sections) || _.contains(sections, 'product_data_storage')) {\n                this.localStorage.removeAll();\n            }\n        },\n\n        /**\n         * Initialize listener to data property\n         *\n         * @return Chainable.\n         */\n        initDataListener: function () {\n            this.data.subscribe(this.dataHandler.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Initialize provider storage\n         *\n         * @return Chainable.\n         */\n        initProvideStorage: function () {\n            this.providerHandler(customerData.get(this.customerDataProvider)());\n\n            return this;\n        },\n\n        /**\n         * Handler to update \"data\" property.\n         * Sets data to localStorage\n         *\n         * @param {Object} data\n         */\n        dataHandler: function (data) {\n            if (_.isEmpty(data)) {\n                this.localStorage.removeAll();\n            } else {\n                setLocalStorageItem(this.namespace, data);\n            }\n        },\n\n        /**\n         * Handler to update data in provider.\n         *\n         * @param {Object} data\n         */\n        providerHandler: function (data) {\n            var currentData = utils.copy(this.data()),\n                ids = _.keys(data.items);\n\n            if (data.items && ids.length) {\n                //we can extend only items\n                data = data.items;\n                this.data(_.extend(data, currentData));\n            }\n        },\n\n        /**\n         * Sets data ids\n         *\n         * @param {String} currency\n         * @param {String} store\n         * @param {Object} ids\n         */\n        setIds: function (currency, store, ids) {\n            if (!this.hasInCache(currency, store, ids)) {\n                this.loadDataFromServer(currency, store, ids);\n            } else {\n                this.data.valueHasMutated();\n            }\n        },\n\n        /**\n         * Gets data from \"data\" property by identifiers\n         *\n         * @param {String} currency\n         * @param {String} store\n         * @param {Object} productIdentifiers\n         *\n         * @return {Object} data.\n         */\n        getDataByIdentifiers: function (currency, store, productIdentifiers) {\n            var data = {},\n                dataCollection = this.data(),\n                id;\n\n            for (id in productIdentifiers) {\n                if (productIdentifiers.hasOwnProperty(id)) {\n                    data[id] = dataCollection[id];\n                }\n            }\n\n            return data;\n        },\n\n        /**\n         * Checks has cached data or not\n         *\n         * @param {String} currency\n         * @param {String} store\n         * @param {Object} ids\n         *\n         * @return {Boolean}\n         */\n     