require.config({"config": {
        "jsbuild":{"underscore.js":"//     Underscore.js 1.8.2\n//     http://underscorejs.org\n//     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors\n//     Underscore may be freely distributed under the MIT license.\n\n(function() {\n\n  // Baseline setup\n  // --------------\n\n  // Establish the root object, `window` in the browser, or `exports` on the server.\n  var root = this;\n\n  // Save the previous value of the `_` variable.\n  var previousUnderscore = root._;\n\n  // Save bytes in the minified (but not gzipped) version:\n  var ArrayProto = Array.prototype, ObjProto = Object.prototype, FuncProto = Function.prototype;\n\n  // Create quick reference variables for speed access to core prototypes.\n  var\n    push             = ArrayProto.push,\n    slice            = ArrayProto.slice,\n    toString         = ObjProto.toString,\n    hasOwnProperty   = ObjProto.hasOwnProperty;\n\n  // All **ECMAScript 5** native function implementations that we hope to use\n  // are declared here.\n  var\n    nativeIsArray      = Array.isArray,\n    nativeKeys         = Object.keys,\n    nativeBind         = FuncProto.bind,\n    nativeCreate       = Object.create;\n\n  // Naked function reference for surrogate-prototype-swapping.\n  var Ctor = function(){};\n\n  // Create a safe reference to the Underscore object for use below.\n  var _ = function(obj) {\n    if (obj instanceof _) return obj;\n    if (!(this instanceof _)) return new _(obj);\n    this._wrapped = obj;\n  };\n\n  // Export the Underscore object for **Node.js**, with\n  // backwards-compatibility for the old `require()` API. If we're in\n  // the browser, add `_` as a global object.\n  if (typeof exports !== 'undefined') {\n    if (typeof module !== 'undefined' && module.exports) {\n      exports = module.exports = _;\n    }\n    exports._ = _;\n  } else {\n    root._ = _;\n  }\n\n  // Current version.\n  _.VERSION = '1.8.2';\n\n  // Internal function that returns an efficient (for current engines) version\n  // of the passed-in callback, to be repeatedly applied in other Underscore\n  // functions.\n  var optimizeCb = function(func, context, argCount) {\n    if (context === void 0) return func;\n    switch (argCount == null ? 3 : argCount) {\n      case 1: return function(value) {\n        return func.call(context, value);\n      };\n      case 2: return function(value, other) {\n        return func.call(context, value, other);\n      };\n      case 3: return function(value, index, collection) {\n        return func.call(context, value, index, collection);\n      };\n      case 4: return function(accumulator, value, index, collection) {\n        return func.call(context, accumulator, value, index, collection);\n      };\n    }\n    return function() {\n      return func.apply(context, arguments);\n    };\n  };\n\n  // A mostly-internal function to generate callbacks that can be applied\n  // to each element in a collection, returning the desired result \u2014 either\n  // identity, an arbitrary callback, a property matcher, or a property accessor.\n  var cb = function(value, context, argCount) {\n    if (value == null) return _.identity;\n    if (_.isFunction(value)) return optimizeCb(value, context, argCount);\n    if (_.isObject(value)) return _.matcher(value);\n    return _.property(value);\n  };\n  _.iteratee = function(value, context) {\n    return cb(value, context, Infinity);\n  };\n\n  // An internal function for creating assigner functions.\n  var createAssigner = function(keysFunc, undefinedOnly) {\n    return function(obj) {\n      var length = arguments.length;\n      if (length < 2 || obj == null) return obj;\n      for (var index = 1; index < length; index++) {\n        var source = arguments[index],\n            keys = keysFunc(source),\n            l = keys.length;\n        for (var i = 0; i < l; i++) {\n          var key = keys[i];\n          if (!undefinedOnly || obj[key] === void 0) obj[key] = source[key];\n        }\n      }\n      return obj;\n    };\n  };\n\n  // An internal function for creating a new object that inherits from another.\n  var baseCreate = function(prototype) {\n    if (!_.isObject(prototype)) return {};\n    if (nativeCreate) return nativeCreate(prototype);\n    Ctor.prototype = prototype;\n    var result = new Ctor;\n    Ctor.prototype = null;\n    return result;\n  };\n\n  // Helper for collection methods to determine whether a collection\n  // should be iterated as an array or as an object\n  // Related: http://people.mozilla.org/~jorendorff/es6-draft.html#sec-tolength\n  var MAX_ARRAY_INDEX = Math.pow(2, 53) - 1;\n  var isArrayLike = function(collection) {\n    var length = collection && collection.length;\n    return typeof length == 'number' && length >= 0 && length <= MAX_ARRAY_INDEX;\n  };\n\n  // Collection Functions\n  // --------------------\n\n  // The cornerstone, an `each` implementation, aka `forEach`.\n  // Handles raw objects in addition to array-likes. Treats all\n  // sparse array-likes as if they were dense.\n  _.each = _.forEach = function(obj, iteratee, context) {\n    iteratee = optimizeCb(iteratee, context);\n    var i, length;\n    if (isArrayLike(obj)) {\n      for (i = 0, length = obj.length; i < length; i++) {\n        iteratee(obj[i], i, obj);\n      }\n    } else {\n      var keys = _.keys(obj);\n      for (i = 0, length = keys.length; i < length; i++) {\n        iteratee(obj[keys[i]], keys[i], obj);\n      }\n    }\n    return obj;\n  };\n\n  // Return the results of applying the iteratee to each element.\n  _.map = _.collect = function(obj, iteratee, context) {\n    iteratee = cb(iteratee, context);\n    var keys = !isArrayLike(obj) && _.keys(obj),\n        length = (keys || obj).length,\n        results = Array(length);\n    for (var index = 0; index < length; index++) {\n      var currentKey = keys ? keys[index] : index;\n      results[index] = iteratee(obj[currentKey], currentKey, obj);\n    }\n    return results;\n  };\n\n  // Create a reducing function iterating left or right.\n  function createReduce(dir) {\n    // Optimized iterator function as using arguments.length\n    // in the main function will deoptimize the, see #1991.\n    function iterator(obj, iteratee, memo, keys, index, length) {\n      for (; index >= 0 && index < length; index += dir) {\n        var currentKey = keys ? keys[index] : index;\n        memo = iteratee(memo, obj[currentKey], currentKey, obj);\n      }\n      return memo;\n    }\n\n    return function(obj, iteratee, memo, context) {\n      iteratee = optimizeCb(iteratee, context, 4);\n      var keys = !isArrayLike(obj) && _.keys(obj),\n          length = (keys || obj).length,\n          index = dir > 0 ? 0 : length - 1;\n      // Determine the initial value if none is provided.\n      if (arguments.length < 3) {\n        memo = obj[keys ? keys[index] : index];\n        index += dir;\n      }\n      return iterator(obj, iteratee, memo, keys, index, length);\n    };\n  }\n\n  // **Reduce** builds up a single result from a list of values, aka `inject`,\n  // or `foldl`.\n  _.reduce = _.foldl = _.inject = createReduce(1);\n\n  // The right-associative version of reduce, also known as `foldr`.\n  _.reduceRight = _.foldr = createReduce(-1);\n\n  // Return the first value which passes a truth test. Aliased as `detect`.\n  _.find = _.detect = function(obj, predicate, context) {\n    var key;\n    if (isArrayLike(obj)) {\n      key = _.findIndex(obj, predicate, context);\n    } else {\n      key = _.findKey(obj, predicate, context);\n    }\n    if (key !== void 0 && key !== -1) return obj[key];\n  };\n\n  // Return all the elements that pass a truth test.\n  // Aliased as `select`.\n  _.filter = _.select = function(obj, predicate, context) {\n    var results = [];\n    predicate = cb(predicate, context);\n    _.each(obj, function(value, index, list) {\n      if (predicate(value, index, list)) results.push(value);\n    });\n    return results;\n  };\n\n  // Return all the elements for which a truth test fails.\n  _.reject = function(obj, predicate, context) {\n    return _.filter(obj, _.negate(cb(predicate)), context);\n  };\n\n  // Determine whether all of the elements match a truth test.\n  // Aliased as `all`.\n  _.every = _.all = function(obj, predicate, context) {\n    predicate = cb(predicate, context);\n    var keys = !isArrayLike(obj) && _.keys(obj),\n        length = (keys || obj).length;\n    for (var index = 0; index < length; index++) {\n      var currentKey = keys ? keys[index] : index;\n      if (!predicate(obj[currentKey], currentKey, obj)) return false;\n    }\n    return true;\n  };\n\n  // Determine if at least one element in the object matches a truth test.\n  // Aliased as `any`.\n  _.some = _.any = function(obj, predicate, context) {\n    predicate = cb(predicate, context);\n    var keys = !isArrayLike(obj) && _.keys(obj),\n        length = (keys || obj).length;\n    for (var index = 0; index < length; index++) {\n      var currentKey = keys ? keys[index] : index;\n      if (predicate(obj[currentKey], currentKey, obj)) return true;\n    }\n    return false;\n  };\n\n  // Determine if the array or object contains a given value (using `===`).\n  // Aliased as `includes` and `include`.\n  _.contains = _.includes = _.include = function(obj, target, fromIndex) {\n    if (!isArrayLike(obj)) obj = _.values(obj);\n    return _.indexOf(obj, target, typeof fromIndex == 'number' && fromIndex) >= 0;\n  };\n\n  // Invoke a method (with arguments) on every item in a collection.\n  _.invoke = function(obj, method) {\n    var args = slice.call(arguments, 2);\n    var isFunc = _.isFunction(method);\n    return _.map(obj, function(value) {\n      var func = isFunc ? method : value[method];\n      return func == null ? func : func.apply(value, args);\n    });\n  };\n\n  // Convenience version of a common use case of `map`: fetching a property.\n  _.pluck = function(obj, key) {\n    return _.map(obj, _.property(key));\n  };\n\n  // Convenience version of a common use case of `filter`: selecting only objects\n  // containing specific `key:value` pairs.\n  _.where = function(obj, attrs) {\n    return _.filter(obj, _.matcher(attrs));\n  };\n\n  // Convenience version of a common use case of `find`: getting the first object\n  // containing specific `key:value` pairs.\n  _.findWhere = function(obj, attrs) {\n    return _.find(obj, _.matcher(attrs));\n  };\n\n  // Return the maximum element (or element-based computation).\n  _.max = function(obj, iteratee, context) {\n    var result = -Infinity, lastComputed = -Infinity,\n        value, computed;\n    if (iteratee == null && obj != null) {\n      obj = isArrayLike(obj) ? obj : _.values(obj);\n      for (var i = 0, length = obj.length; i < length; i++) {\n        value = obj[i];\n        if (value > result) {\n          result = value;\n        }\n      }\n    } else {\n      iteratee = cb(iteratee, context);\n      _.each(obj, function(value, index, list) {\n        computed = iteratee(value, index, list);\n        if (computed > lastComputed || computed === -Infinity && result === -Infinity) {\n          result = value;\n          lastComputed = computed;\n        }\n      });\n    }\n    return result;\n  };\n\n  // Return the minimum element (or element-based computation).\n  _.min = function(obj, iteratee, context) {\n    var result = Infinity, lastComputed = Infinity,\n        value, computed;\n    if (iteratee == null && obj != null) {\n      obj = isArrayLike(obj) ? obj : _.values(obj);\n      for (var i = 0, length = obj.length; i < length; i++) {\n        value = obj[i];\n        if (value < result) {\n          result = value;\n        }\n      }\n    } else {\n      iteratee = cb(iteratee, context);\n      _.each(obj, function(value, index, list) {\n        computed = iteratee(value, index, list);\n        if (computed < lastComputed || computed === Infinity && result === Infinity) {\n          result = value;\n          lastComputed = computed;\n        }\n      });\n    }\n    return result;\n  };\n\n  // Shuffle a collection, using the modern version of the\n  // [Fisher-Yates shuffle](http://en.wikipedia.org/wiki/Fisher\u2013Yates_shuffle).\n  _.shuffle = function(obj) {\n    var set = isArrayLike(obj) ? obj : _.values(obj);\n    var length = set.length;\n    var shuffled = Array(length);\n    for (var index = 0, rand; index < length; index++) {\n      rand = _.random(0, index);\n      if (rand !== index) shuffled[index] = shuffled[rand];\n      shuffled[rand] = set[index];\n    }\n    return shuffled;\n  };\n\n  // Sample **n** random values from a collection.\n  // If **n** is not specified, returns a single random element.\n  // The internal `guard` argument allows it to work with `map`.\n  _.sample = function(obj, n, guard) {\n    if (n == null || guard) {\n      if (!isArrayLike(obj)) obj = _.values(obj);\n      return obj[_.random(obj.length - 1)];\n    }\n    return _.shuffle(obj).slice(0, Math.max(0, n));\n  };\n\n  // Sort the object's values by a criterion produced by an iteratee.\n  _.sortBy = function(obj, iteratee, context) {\n    iteratee = cb(iteratee, context);\n    return _.pluck(_.map(obj, function(value, index, list) {\n      return {\n        value: value,\n        index: index,\n        criteria: iteratee(value, index, list)\n      };\n    }).sort(function(left, right) {\n      var a = left.criteria;\n      var b = right.criteria;\n      if (a !== b) {\n        if (a > b || a === void 0) return 1;\n        if (a < b || b === void 0) return -1;\n      }\n      return left.index - right.index;\n    }), 'value');\n  };\n\n  // An internal function used for aggregate \"group by\" operations.\n  var group = function(behavior) {\n    return function(obj, iteratee, context) {\n      var result = {};\n      iteratee = cb(iteratee, context);\n      _.each(obj, function(value, index) {\n        var key = iteratee(value, index, obj);\n        behavior(result, value, key);\n      });\n      return result;\n    };\n  };\n\n  // Groups the object's values by a criterion. Pass either a string attribute\n  // to group by, or a function that returns the criterion.\n  _.groupBy = group(function(result, value, key) {\n    if (_.has(result, key)) result[key].push(value); else result[key] = [value];\n  });\n\n  // Indexes the object's values by a criterion, similar to `groupBy`, but for\n  // when you know that your index values will be unique.\n  _.indexBy = group(function(result, value, key) {\n    result[key] = value;\n  });\n\n  // Counts instances of an object that group by a certain criterion. Pass\n  // either a string attribute to count by, or a function that returns the\n  // criterion.\n  _.countBy = group(function(result, value, key) {\n    if (_.has(result, key)) result[key]++; else result[key] = 1;\n  });\n\n  // Safely create a real, live array from anything iterable.\n  _.toArray = function(obj) {\n    if (!obj) return [];\n    if (_.isArray(obj)) return slice.call(obj);\n    if (isArrayLike(obj)) return _.map(obj, _.identity);\n    return _.values(obj);\n  };\n\n  // Return the number of elements in an object.\n  _.size = function(obj) {\n    if (obj == null) return 0;\n    return isArrayLike(obj) ? obj.length : _.keys(obj).length;\n  };\n\n  // Split a collection into two arrays: one whose elements all satisfy the given\n  // predicate, and one whose elements all do not satisfy the predicate.\n  _.partition = function(obj, predicate, context) {\n    predicate = cb(predicate, context);\n    var pass = [], fail = [];\n    _.each(obj, function(value, key, obj) {\n      (predicate(value, key, obj) ? pass : fail).push(value);\n    });\n    return [pass, fail];\n  };\n\n  // Array Functions\n  // ---------------\n\n  // Get the first element of an array. Passing **n** will return the first N\n  // values in the array. Aliased as `head` and `take`. The **guard** check\n  // allows it to work with `_.map`.\n  _.first = _.head = _.take = function(array, n, guard) {\n    if (array == null) return void 0;\n    if (n == null || guard) return array[0];\n    return _.initial(array, array.length - n);\n  };\n\n  // Returns everything but the last entry of the array. Especially useful on\n  // the arguments object. Passing **n** will return all the values in\n  // the array, excluding the last N.\n  _.initial = function(array, n, guard) {\n    return slice.call(array, 0, Math.max(0, array.length - (n == null || guard ? 1 : n)));\n  };\n\n  // Get the last element of an array. Passing **n** will return the last N\n  // values in the array.\n  _.last = function(array, n, guard) {\n    if (array == null) return void 0;\n    if (n == null || guard) return array[array.length - 1];\n    return _.rest(array, Math.max(0, array.length - n));\n  };\n\n  // Returns everything but the first entry of the array. Aliased as `tail` and `drop`.\n  // Especially useful on the arguments object. Passing an **n** will return\n  // the rest N values in the array.\n  _.rest = _.tail = _.drop = function(array, n, guard) {\n    return slice.call(array, n == null || guard ? 1 : n);\n  };\n\n  // Trim out all falsy values from an array.\n  _.compact = function(array) {\n    return _.filter(array, _.identity);\n  };\n\n  // Internal implementation of a recursive `flatten` function.\n  var flatten = function(input, shallow, strict, startIndex) {\n    var output = [], idx = 0;\n    for (var i = startIndex || 0, length = input && input.length; i < length; i++) {\n      var value = input[i];\n      if (isArrayLike(value) && (_.isArray(value) || _.isArguments(value))) {\n        //flatten current level of array or arguments object\n        if (!shallow) value = flatten(value, shallow, strict);\n        var j = 0, len = value.length;\n        output.length += len;\n        while (j < len) {\n          output[idx++] = value[j++];\n        }\n      } else if (!strict) {\n        output[idx++] = value;\n      }\n    }\n    return output;\n  };\n\n  // Flatten out an array, either recursively (by default), or just one level.\n  _.flatten = function(array, shallow) {\n    return flatten(array, shallow, false);\n  };\n\n  // Return a version of the array that does not contain the specified value(s).\n  _.without = function(array) {\n    return _.difference(array, slice.call(arguments, 1));\n  };\n\n  // Produce a duplicate-free version of the array. If the array has already\n  // been sorted, you have the option of using a faster algorithm.\n  // Aliased as `unique`.\n  _.uniq = _.unique = function(array, isSorted, iteratee, context) {\n    if (array == null) return [];\n    if (!_.isBoolean(isSorted)) {\n      context = iteratee;\n      iteratee = isSorted;\n      isSorted = false;\n    }\n    if (iteratee != null) iteratee = cb(iteratee, context);\n    var result = [];\n    var seen = [];\n    for (var i = 0, length = array.length; i < length; i++) {\n      var value = array[i],\n          computed = iteratee ? iteratee(value, i, array) : value;\n      if (isSorted) {\n        if (!i || seen !== computed) result.push(value);\n        seen = computed;\n      } else if (iteratee) {\n        if (!_.contains(seen, computed)) {\n          seen.push(computed);\n          result.push(value);\n        }\n      } else if (!_.contains(result, value)) {\n        result.push(value);\n      }\n    }\n    return result;\n  };\n\n  // Produce an array that contains the union: each distinct element from all of\n  // the passed-in arrays.\n  _.union = function() {\n    return _.uniq(flatten(arguments, true, true));\n  };\n\n  // Produce an array that contains every item shared between all the\n  // passed-in arrays.\n  _.intersection = function(array) {\n    if (array == null) return [];\n    var result = [];\n    var argsLength = arguments.length;\n    for (var i = 0, length = array.length; i < length; i++) {\n      var item = array[i];\n      if (_.contains(result, item)) continue;\n      for (var j = 1; j < argsLength; j++) {\n        if (!_.contains(arguments[j], item)) break;\n      }\n      if (j === argsLength) result.push(item);\n    }\n    return result;\n  };\n\n  // Take the difference between one array and a number of other arrays.\n  // Only the elements present in just the first array will remain.\n  _.difference = function(array) {\n    var rest = flatten(arguments, true, true, 1);\n    return _.filter(array, function(value){\n      return !_.contains(rest, value);\n    });\n  };\n\n  // Zip together multiple lists into a single array -- elements that share\n  // an index go together.\n  _.zip = function() {\n    return _.unzip(arguments);\n  };\n\n  // Complement of _.zip. Unzip accepts an array of arrays and groups\n  // each array's elements on shared indices\n  _.unzip = function(array) {\n    var length = array && _.max(array, 'length').length || 0;\n    var result = Array(length);\n\n    for (var index = 0; index < length; index++) {\n      result[index] = _.pluck(array, index);\n    }\n    return result;\n  };\n\n  // Converts lists into objects. Pass either a single array of `[key, value]`\n  // pairs, or two parallel arrays of the same length -- one of keys, and one of\n  // the corresponding values.\n  _.object = function(list, values) {\n    var result = {};\n    for (var i = 0, length = list && list.length; i < length; i++) {\n      if (values) {\n        result[list[i]] = values[i];\n      } else {\n        result[list[i][0]] = list[i][1];\n      }\n    }\n    return result;\n  };\n\n  // Return the position of the first occurrence of an item in an array,\n  // or -1 if the item is not included in the array.\n  // If the array is large and already in sort order, pass `true`\n  // for **isSorted** to use binary search.\n  _.indexOf = function(array, item, isSorted) {\n    var i = 0, length = array && array.length;\n    if (typeof isSorted == 'number') {\n      i = isSorted < 0 ? Math.max(0, length + isSorted) : isSorted;\n    } else if (isSorted && length) {\n      i = _.sortedIndex(array, item);\n      return array[i] === item ? i : -1;\n    }\n    if (item !== item) {\n      return _.findIndex(slice.call(array, i), _.isNaN);\n    }\n    for (; i < length; i++) if (array[i] === item) return i;\n    return -1;\n  };\n\n  _.lastIndexOf = function(array, item, from) {\n    var idx = array ? array.length : 0;\n    if (typeof from == 'number') {\n      idx = from < 0 ? idx + from + 1 : Math.min(idx, from + 1);\n    }\n    if (item !== item) {\n      return _.findLastIndex(slice.call(array, 0, idx), _.isNaN);\n    }\n    while (--idx >= 0) if (array[idx] === item) return idx;\n    return -1;\n  };\n\n  // Generator function to create the findIndex and findLastIndex functions\n  function createIndexFinder(dir) {\n    return function(array, predicate, context) {\n      predicate = cb(predicate, context);\n      var length = array != null && array.length;\n      var index = dir > 0 ? 0 : length - 1;\n      for (; index >= 0 && index < length; index += dir) {\n        if (predicate(array[index], index, array)) return index;\n      }\n      return -1;\n    };\n  }\n\n  // Returns the first index on an array-like that passes a predicate test\n  _.findIndex = createIndexFinder(1);\n\n  _.findLastIndex = createIndexFinder(-1);\n\n  // Use a comparator function to figure out the smallest index at which\n  // an object should be inserted so as to maintain order. Uses binary search.\n  _.sortedIndex = function(array, obj, iteratee, context) {\n    iteratee = cb(iteratee, context, 1);\n    var value = iteratee(obj);\n    var low = 0, high = array.length;\n    while (low < high) {\n      var mid = Math.floor((low + high) / 2);\n      if (iteratee(array[mid]) < value) low = mid + 1; else high = mid;\n    }\n    return low;\n  };\n\n  // Generate an integer Array containing an arithmetic progression. A port of\n  // the native Python `range()` function. See\n  // [the Python documentation](http://docs.python.org/library/functions.html#range).\n  _.range = function(start, stop, step) {\n    if (arguments.length <= 1) {\n      stop = start || 0;\n      start = 0;\n    }\n    step = step || 1;\n\n    var length = Math.max(Math.ceil((stop - start) / step), 0);\n    var range = Array(length);\n\n    for (var idx = 0; idx < length; idx++, start += step) {\n      range[idx] = start;\n    }\n\n    return range;\n  };\n\n  // Function (ahem) Functions\n  // ------------------\n\n  // Determines whether to execute a function as a constructor\n  // or a normal function with the provided arguments\n  var executeBound = function(sourceFunc, boundFunc, context, callingContext, args) {\n    if (!(callingContext instanceof boundFunc)) return sourceFunc.apply(context, args);\n    var self = baseCreate(sourceFunc.prototype);\n    var result = sourceFunc.apply(self, args);\n    if (_.isObject(result)) return result;\n    return self;\n  };\n\n  // Create a function bound to a given object (assigning `this`, and arguments,\n  // optionally). Delegates to **ECMAScript 5**'s native `Function.bind` if\n  // available.\n  _.bind = function(func, context) {\n    if (nativeBind && func.bind === nativeBind) return nativeBind.apply(func, slice.call(arguments, 1));\n    if (!_.isFunction(func)) throw new TypeError('Bind must be called on a function');\n    var args = slice.call(arguments, 2);\n    var bound = function() {\n      return executeBound(func, bound, context, this, args.concat(slice.call(arguments)));\n    };\n    return bound;\n  };\n\n  // Partially apply a function by creating a version that has had some of its\n  // arguments pre-filled, without changing its dynamic `this` context. _ acts\n  // as a placeholder, allowing any combination of arguments to be pre-filled.\n  _.partial = function(func) {\n    var boundArgs = slice.call(arguments, 1);\n    var bound = function() {\n      var position = 0, length = boundArgs.length;\n      var args = Array(length);\n      for (var i = 0; i < length; i++) {\n        args[i] = boundArgs[i] === _ ? arguments[position++] : boundArgs[i];\n      }\n      while (position < arguments.length) args.push(arguments[position++]);\n      return executeBound(func, bound, this, this, args);\n    };\n    return bound;\n  };\n\n  // Bind a number of an object's methods to that object. Remaining arguments\n  // are the method names to be bound. Useful for ensuring that all callbacks\n  // defined on an object belong to it.\n  _.bindAll = function(obj) {\n    var i, length = arguments.length, key;\n    if (length <= 1) throw new Error('bindAll must be passed function names');\n    for (i = 1; i < length; i++) {\n      key = arguments[i];\n      obj[key] = _.bind(obj[key], obj);\n    }\n    return obj;\n  };\n\n  // Memoize an expensive function by storing its results.\n  _.memoize = function(func, hasher) {\n    var memoize = function(key) {\n      var cache = memoize.cache;\n      var address = '' + (hasher ? hasher.apply(this, arguments) : key);\n      if (!_.has(cache, address)) cache[address] = func.apply(this, arguments);\n      return cache[address];\n    };\n    memoize.cache = {};\n    return memoize;\n  };\n\n  // Delays a function for the given number of milliseconds, and then calls\n  // it with the arguments supplied.\n  _.delay = function(func, wait) {\n    var args = slice.call(arguments, 2);\n    return setTimeout(function(){\n      return func.apply(null, args);\n    }, wait);\n  };\n\n  // Defers a function, scheduling it to run after the current call stack has\n  // cleared.\n  _.defer = _.partial(_.delay, _, 1);\n\n  // Returns a function, that, when invoked, will only be triggered at most once\n  // during a given window of time. Normally, the throttled function will run\n  // as much as it can, without ever going more than once per `wait` duration;\n  // but if you'd like to disable the execution on the leading edge, pass\n  // `{leading: false}`. To disable execution on the trailing edge, ditto.\n  _.throttle = function(func, wait, options) {\n    var context, args, result;\n    var timeout = null;\n    var previous = 0;\n    if (!options) options = {};\n    var later = function() {\n      previous = options.leading === false ? 0 : _.now();\n      timeout = null;\n      result = func.apply(context, args);\n      if (!timeout) context = args = null;\n    };\n    return function() {\n      var now = _.now();\n      if (!previous && options.leading === false) previous = now;\n      var remaining = wait - (now - previous);\n      context = this;\n      args = arguments;\n      if (remaining <= 0 || remaining > wait) {\n        if (timeout) {\n          clearTimeout(timeout);\n          timeout = null;\n        }\n        previous = now;\n        result = func.apply(context, args);\n        if (!timeout) context = args = null;\n      } else if (!timeout && options.trailing !== false) {\n        timeout = setTimeout(later, remaining);\n      }\n      return result;\n    };\n  };\n\n  // Returns a function, that, as long as it continues to be invoked, will not\n  // be triggered. The function will be called after it stops being called for\n  // N milliseconds. If `immediate` is passed, trigger the function on the\n  // leading edge, instead of the trailing.\n  _.debounce = function(func, wait, immediate) {\n    var timeout, args, context, timestamp, result;\n\n    var later = function() {\n      var last = _.now() - timestamp;\n\n      if (last < wait && last >= 0) {\n        timeout = setTimeout(later, wait - last);\n      } else {\n        timeout = null;\n        if (!immediate) {\n          result = func.apply(context, args);\n          if (!timeout) context = args = null;\n        }\n      }\n    };\n\n    return function() {\n      context = this;\n      args = arguments;\n      timestamp = _.now();\n      var callNow = immediate && !timeout;\n      if (!timeout) timeout = setTimeout(later, wait);\n      if (callNow) {\n        result = func.apply(context, args);\n        context = args = null;\n      }\n\n      return result;\n    };\n  };\n\n  // Returns the first function passed as an argument to the second,\n  // allowing you to adjust arguments, run code before and after, and\n  // conditionally execute the original function.\n  _.wrap = function(func, wrapper) {\n    return _.partial(wrapper, func);\n  };\n\n  // Returns a negated version of the passed-in predicate.\n  _.negate = function(predicate) {\n    return function() {\n      return !predicate.apply(this, arguments);\n    };\n  };\n\n  // Returns a function that is the composition of a list of functions, each\n  // consuming the return value of the function that follows.\n  _.compose = function() {\n    var args = arguments;\n    var start = args.length - 1;\n    return function() {\n      var i = start;\n      var result = args[start].apply(this, arguments);\n      while (i--) result = args[i].call(this, result);\n      return result;\n    };\n  };\n\n  // Returns a function that will only be executed on and after the Nth call.\n  _.after = function(times, func) {\n    return function() {\n      if (--times < 1) {\n        return func.apply(this, arguments);\n      }\n    };\n  };\n\n  // Returns a function that will only be executed up to (but not including) the Nth call.\n  _.before = function(times, func) {\n    var memo;\n    return function() {\n      if (--times > 0) {\n        memo = func.apply(this, arguments);\n      }\n      if (times <= 1) func = null;\n      return memo;\n    };\n  };\n\n  // Returns a function that will be executed at most one time, no matter how\n  // often you call it. Useful for lazy initialization.\n  _.once = _.partial(_.before, 2);\n\n  // Object Functions\n  // ----------------\n\n  // Keys in IE < 9 that won't be iterated by `for key in ...` and thus missed.\n  var hasEnumBug = !{toString: null}.propertyIsEnumerable('toString');\n  var nonEnumerableProps = ['valueOf', 'isPrototypeOf', 'toString',\n                      'propertyIsEnumerable', 'hasOwnProperty', 'toLocaleString'];\n\n  function collectNonEnumProps(obj, keys) {\n    var nonEnumIdx = nonEnumerableProps.length;\n    var constructor = obj.constructor;\n    var proto = (_.isFunction(constructor) && constructor.prototype) || ObjProto;\n\n    // Constructor is a special case.\n    var prop = 'constructor';\n    if (_.has(obj, prop) && !_.contains(keys, prop)) keys.push(prop);\n\n    while (nonEnumIdx--) {\n      prop = nonEnumerableProps[nonEnumIdx];\n      if (prop in obj && obj[prop] !== proto[prop] && !_.contains(keys, prop)) {\n        keys.push(prop);\n      }\n    }\n  }\n\n  // Retrieve the names of an object's own properties.\n  // Delegates to **ECMAScript 5**'s native `Object.keys`\n  _.keys = function(obj) {\n    if (!_.isObject(obj)) return [];\n    if (nativeKeys) return nativeKeys(obj);\n    var keys = [];\n    for (var key in obj) if (_.has(obj, key)) keys.push(key);\n    // Ahem, IE < 9.\n    if (hasEnumBug) collectNonEnumProps(obj, keys);\n    return keys;\n  };\n\n  // Retrieve all the property names of an object.\n  _.allKeys = function(obj) {\n    if (!_.isObject(obj)) return [];\n    var keys = [];\n    for (var key in obj) keys.push(key);\n    // Ahem, IE < 9.\n    if (hasEnumBug) collectNonEnumProps(obj, keys);\n    return keys;\n  };\n\n  // Retrieve the values of an object's properties.\n  _.values = function(obj) {\n    var keys = _.keys(obj);\n    var length = keys.length;\n    var values = Array(length);\n    for (var i = 0; i < length; i++) {\n      values[i] = obj[keys[i]];\n    }\n    return values;\n  };\n\n  // Returns the results of applying the iteratee to each element of the object\n  // In contrast to _.map it returns an object\n  _.mapObject = function(obj, iteratee, context) {\n    iteratee = cb(iteratee, context);\n    var keys =  _.keys(obj),\n          length = keys.length,\n          results = {},\n          currentKey;\n      for (var index = 0; index < length; index++) {\n        currentKey = keys[index];\n        results[currentKey] = iteratee(obj[currentKey], currentKey, obj);\n      }\n      return results;\n  };\n\n  // Convert an object into a list of `[key, value]` pairs.\n  _.pairs = function(obj) {\n    var keys = _.keys(obj);\n    var length = keys.length;\n    var pairs = Array(length);\n    for (var i = 0; i < length; i++) {\n      pairs[i] = [keys[i], obj[keys[i]]];\n    }\n    return pairs;\n  };\n\n  // Invert the keys and values of an object. The values must be serializable.\n  _.invert = function(obj) {\n    var result = {};\n    var keys = _.keys(obj);\n    for (var i = 0, length = keys.length; i < length; i++) {\n      result[obj[keys[i]]] = keys[i];\n    }\n    return result;\n  };\n\n  // Return a sorted list of the function names available on the object.\n  // Aliased as `methods`\n  _.functions = _.methods = function(obj) {\n    var names = [];\n    for (var key in obj) {\n      if (_.isFunction(obj[key])) names.push(key);\n    }\n    return names.sort();\n  };\n\n  // Extend a given object with all the properties in passed-in object(s).\n  _.extend = createAssigner(_.allKeys);\n\n  // Assigns a given object with all the own properties in the passed-in object(s)\n  // (https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object/assign)\n  _.extendOwn = _.assign = createAssigner(_.keys);\n\n  // Returns the first key on an object that passes a predicate test\n  _.findKey = function(obj, predicate, context) {\n    predicate = cb(predicate, context);\n    var keys = _.keys(obj), key;\n    for (var i = 0, length = keys.length; i < length; i++) {\n      key = keys[i];\n      if (predicate(obj[key], key, obj)) return key;\n    }\n  };\n\n  // Return a copy of the object only containing the whitelisted properties.\n  _.pick = function(object, oiteratee, context) {\n    var result = {}, obj = object, iteratee, keys;\n    if (obj == null) return result;\n    if (_.isFunction(oiteratee)) {\n      keys = _.allKeys(obj);\n      iteratee = optimizeCb(oiteratee, context);\n    } else {\n      keys = flatten(arguments, false, false, 1);\n      iteratee = function(value, key, obj) { return key in obj; };\n      obj = Object(obj);\n    }\n    for (var i = 0, length = keys.length; i < length; i++) {\n      var key = keys[i];\n      var value = obj[key];\n      if (iteratee(value, key, obj)) result[key] = value;\n    }\n    return result;\n  };\n\n   // Return a copy of the object without the blacklisted properties.\n  _.omit = function(obj, iteratee, context) {\n    if (_.isFunction(iteratee)) {\n      iteratee = _.negate(iteratee);\n    } else {\n      var keys = _.map(flatten(arguments, false, false, 1), String);\n      iteratee = function(value, key) {\n        return !_.contains(keys, key);\n      };\n    }\n    return _.pick(obj, iteratee, context);\n  };\n\n  // Fill in a given object with default properties.\n  _.defaults = createAssigner(_.allKeys, true);\n\n  // Create a (shallow-cloned) duplicate of an object.\n  _.clone = function(obj) {\n    if (!_.isObject(obj)) return obj;\n    return _.isArray(obj) ? obj.slice() : _.extend({}, obj);\n  };\n\n  // Invokes interceptor with the obj, and then returns obj.\n  // The primary purpose of this method is to \"tap into\" a method chain, in\n  // order to perform operations on intermediate results within the chain.\n  _.tap = function(obj, interceptor) {\n    interceptor(obj);\n    return obj;\n  };\n\n  // Returns whether an object has a given set of `key:value` pairs.\n  _.isMatch = function(object, attrs) {\n    var keys = _.keys(attrs), length = keys.length;\n    if (object == null) return !length;\n    var obj = Object(object);\n    for (var i = 0; i < length; i++) {\n      var key = keys[i];\n      if (attrs[key] !== obj[key] || !(key in obj)) return false;\n    }\n    return true;\n  };\n\n\n  // Internal recursive comparison function for `isEqual`.\n  var eq = function(a, b, aStack, bStack) {\n    // Identical objects are equal. `0 === -0`, but they aren't identical.\n    // See the [Harmony `egal` proposal](http://wiki.ecmascript.org/doku.php?id=harmony:egal).\n    if (a === b) return a !== 0 || 1 / a === 1 / b;\n    // A strict comparison is necessary because `null == undefined`.\n    if (a == null || b == null) return a === b;\n    // Unwrap any wrapped objects.\n    if (a instanceof _) a = a._wrapped;\n    if (b instanceof _) b = b._wrapped;\n    // Compare `[[Class]]` names.\n    var className = toString.call(a);\n    if (className !== toString.call(b)) return false;\n    switch (className) {\n      // Strings, numbers, regular expressions, dates, and booleans are compared by value.\n      case '[object RegExp]':\n      // RegExps are coerced to strings for comparison (Note: '' + /a/i === '/a/i')\n      case '[object String]':\n        // Primitives and their corresponding object wrappers are equivalent; thus, `\"5\"` is\n        // equivalent to `new String(\"5\")`.\n        return '' + a === '' + b;\n      case '[object Number]':\n        // `NaN`s are equivalent, but non-reflexive.\n        // Object(NaN) is equivalent to NaN\n        if (+a !== +a) return +b !== +b;\n        // An `egal` comparison is performed for other numeric values.\n        return +a === 0 ? 1 / +a === 1 / b : +a === +b;\n      case '[object Date]':\n      case '[object Boolean]':\n        // Coerce dates and booleans to numeric primitive values. Dates are compared by their\n        // millisecond representations. Note that invalid dates with millisecond representations\n        // of `NaN` are not equivalent.\n        return +a === +b;\n    }\n\n    var areArrays = className === '[object Array]';\n    if (!areArrays) {\n      if (typeof a != 'object' || typeof b != 'object') return false;\n\n      // Objects with different constructors are not equivalent, but `Object`s or `Array`s\n      // from different frames are.\n      var aCtor = a.constructor, bCtor = b.constructor;\n      if (aCtor !== bCtor && !(_.isFunction(aCtor) && aCtor instanceof aCtor &&\n                               _.isFunction(bCtor) && bCtor instanceof bCtor)\n                          && ('constructor' in a && 'constructor' in b)) {\n        return false;\n      }\n    }\n    // Assume equality for cyclic structures. The algorithm for detecting cyclic\n    // structures is adapted from ES 5.1 section 15.12.3, abstract operation `JO`.\n    \n    // Initializing stack of traversed objects.\n    // It's done here since we only need them for objects and arrays comparison.\n    aStack = aStack || [];\n    bStack = bStack || [];\n    var length = aStack.length;\n    while (length--) {\n      // Linear search. Performance is inversely proportional to the number of\n      // unique nested structures.\n      if (aStack[length] === a) return bStack[length] === b;\n    }\n\n    // Add the first object to the stack of traversed objects.\n    aStack.push(a);\n    bStack.push(b);\n\n    // Recursively compare objects and arrays.\n    if (areArrays) {\n      // Compare array lengths to determine if a deep comparison is necessary.\n      length = a.length;\n      if (length !== b.length) return false;\n      // Deep compare the contents, ignoring non-numeric properties.\n      while (length--) {\n        if (!eq(a[length], b[length], aStack, bStack)) return false;\n      }\n    } else {\n      // Deep compare objects.\n      var keys = _.keys(a), key;\n      length = keys.length;\n      // Ensure that both objects contain the same number of properties before comparing deep equality.\n      if (_.keys(b).length !== length) return false;\n      while (length--) {\n        // Deep compare each member\n        key = keys[length];\n        if (!(_.has(b, key) && eq(a[key], b[key], aStack, bStack))) return false;\n      }\n    }\n    // Remove the first object from the stack of traversed objects.\n    aStack.pop();\n    bStack.pop();\n    return true;\n  };\n\n  // Perform a deep comparison to check if two objects are equal.\n  _.isEqual = function(a, b) {\n    return eq(a, b);\n  };\n\n  // Is a given array, string, or object empty?\n  // An \"empty\" object has no enumerable own-properties.\n  _.isEmpty = function(obj) {\n    if (obj == null) return true;\n    if (isArrayLike(obj) && (_.isArray(obj) || _.isString(obj) || _.isArguments(obj))) return obj.length === 0;\n    return _.keys(obj).length === 0;\n  };\n\n  // Is a given value a DOM element?\n  _.isElement = function(obj) {\n    return !!(obj && obj.nodeType === 1);\n  };\n\n  // Is a given value an array?\n  // Delegates to ECMA5's native Array.isArray\n  _.isArray = nativeIsArray || function(obj) {\n    return toString.call(obj) === '[object Array]';\n  };\n\n  // Is a given variable an object?\n  _.isObject = function(obj) {\n    var type = typeof obj;\n    return type === 'function' || type === 'object' && !!obj;\n  };\n\n  // Add some isType methods: isArguments, isFunction, isString, isNumber, isDate, isRegExp, isError.\n  _.each(['Arguments', 'Function', 'String', 'Number', 'Date', 'RegExp', 'Error'], function(name) {\n    _['is' + name] = function(obj) {\n      return toString.call(obj) === '[object ' + name + ']';\n    };\n  });\n\n  // Define a fallback version of the method in browsers (ahem, IE < 9), where\n  // there isn't any inspectable \"Arguments\" type.\n  if (!_.isArguments(arguments)) {\n    _.isArguments = function(obj) {\n      return _.has(obj, 'callee');\n    };\n  }\n\n  // Optimize `isFunction` if appropriate. Work around some typeof bugs in old v8,\n  // IE 11 (#1621), and in Safari 8 (#1929).\n  if (typeof /./ != 'function' && typeof Int8Array != 'object') {\n    _.isFunction = function(obj) {\n      return typeof obj == 'function' || false;\n    };\n  }\n\n  // Is a given object a finite number?\n  _.isFinite = function(obj) {\n    return isFinite(obj) && !isNaN(parseFloat(obj));\n  };\n\n  // Is the given value `NaN`? (NaN is the only number which does not equal itself).\n  _.isNaN = function(obj) {\n    return _.isNumber(obj) && obj !== +obj;\n  };\n\n  // Is a given value a boolean?\n  _.isBoolean = function(obj) {\n    return obj === true || obj === false || toString.call(obj) === '[object Boolean]';\n  };\n\n  // Is a given value equal to null?\n  _.isNull = function(obj) {\n    return obj === null;\n  };\n\n  // Is a given variable undefined?\n  _.isUndefined = function(obj) {\n    return obj === void 0;\n  };\n\n  // Shortcut function for checking if an object has a given property directly\n  // on itself (in other words, not on a prototype).\n  _.has = function(obj, key) {\n    return obj != null && hasOwnProperty.call(obj, key);\n  };\n\n  // Utility Functions\n  // -----------------\n\n  // Run Underscore.js in *noConflict* mode, returning the `_` variable to its\n  // previous owner. Returns a reference to the Underscore object.\n  _.noConflict = function() {\n    root._ = previousUnderscore;\n    return this;\n  };\n\n  // Keep the identity function around for default iteratees.\n  _.identity = function(value) {\n    return value;\n  };\n\n  // Predicate-generating functions. Often useful outside of Underscore.\n  _.constant = function(value) {\n    return function() {\n      return value;\n    };\n  };\n\n  _.noop = function(){};\n\n  _.property = function(key) {\n    return function(obj) {\n      return obj == null ? void 0 : obj[key];\n    };\n  };\n\n  // Generates a function for a given object that returns a given property.\n  _.propertyOf = function(obj) {\n    return obj == null ? function(){} : function(key) {\n      return obj[key];\n    };\n  };\n\n  // Returns a predicate for checking whether an object has a given set of \n  // `key:value` pairs.\n  _.matcher = _.matches = function(attrs) {\n    attrs = _.extendOwn({}, attrs);\n    return function(obj) {\n      return _.isMatch(obj, attrs);\n    };\n  };\n\n  // Run a function **n** times.\n  _.times = function(n, iteratee, context) {\n    var accum = Array(Math.max(0, n));\n    iteratee = optimizeCb(iteratee, context, 1);\n    for (var i = 0; i < n; i++) accum[i] = iteratee(i);\n    return accum;\n  };\n\n  // Return a random integer between min and max (inclusive).\n  _.random = function(min, max) {\n    if (max == null) {\n      max = min;\n      min = 0;\n    }\n    return min + Math.floor(Math.random() * (max - min + 1));\n  };\n\n  // A (possibly faster) way to get the current timestamp as an integer.\n  _.now = Date.now || function() {\n    return new Date().getTime();\n  };\n\n   // List of HTML entities for escaping.\n  var escapeMap = {\n    '&': '&amp;',\n    '<': '&lt;',\n    '>': '&gt;',\n    '\"': '&quot;',\n    \"'\": '&#x27;',\n    '`': '&#x60;',\n    \"'\": '&#039;',\n  };\n  var unescapeMap = _.invert(escapeMap);\n\n  // Functions for escaping and unescaping strings to/from HTML interpolation.\n  var createEscaper = function(map) {\n    var escaper = function(match) {\n      return map[match];\n    };\n    // Regexes for identifying a key that needs to be escaped\n    var source = '(?:' + _.keys(map).join('|') + ')';\n    var testRegexp = RegExp(source);\n    var replaceRegexp = RegExp(source, 'g');\n    return function(string) {\n      string = string == null ? '' : '' + string;\n      return testRegexp.test(string) ? string.replace(replaceRegexp, escaper) : string;\n    };\n  };\n  _.escape = createEscaper(escapeMap);\n  _.unescape = createEscaper(unescapeMap);\n\n  // If the value of the named `property` is a function then invoke it with the\n  // `object` as context; otherwise, return it.\n  _.result = function(object, property, fallback) {\n    var value = object == null ? void 0 : object[property];\n    if (value === void 0) {\n      value = fallback;\n    }\n    return _.isFunction(value) ? value.call(object) : value;\n  };\n\n  // Generate a unique integer id (unique within the entire client session).\n  // Useful for temporary DOM ids.\n  var idCounter = 0;\n  _.uniqueId = function(prefix) {\n    var id = ++idCounter + '';\n    return prefix ? prefix + id : id;\n  };\n\n  // By default, Underscore uses ERB-style template delimiters, change the\n  // following template settings to use alternative delimiters.\n  _.templateSettings = {\n    evaluate    : /<%([\\s\\S]+?)%>/g,\n    interpolate : /<%=([\\s\\S]+?)%>/g,\n    escape      : /<%-([\\s\\S]+?)%>/g\n  };\n\n  // When customizing `templateSettings`, if you don't want to define an\n  // interpolation, evaluation or escaping regex, we need one that is\n  // guaranteed not to match.\n  var noMatch = /(.)^/;\n\n  // Certain characters need to be escaped so that they can be put into a\n  // string literal.\n  var escapes = {\n    \"'\":      \"'\",\n    '\\\\':     '\\\\',\n    '\\r':     'r',\n    '\\n':     'n',\n    '\\u2028': 'u2028',\n    '\\u2029': 'u2029'\n  };\n\n  var escaper = /\\\\|'|\\r|\\n|\\u2028|\\u2029/g;\n\n  var escapeChar = function(match) {\n    return '\\\\' + escapes[match];\n  };\n\n  // JavaScript micro-templating, similar to John Resig's implementation.\n  // Underscore templating handles arbitrary delimiters, preserves whitespace,\n  // and correctly escapes quotes within interpolated code.\n  // NB: `oldSettings` only exists for backwards compatibility.\n  _.template = function(text, settings, oldSettings) {\n    if (!settings && oldSettings) settings = oldSettings;\n    settings = _.defaults({}, settings, _.templateSettings);\n\n    // Combine delimiters into one regular expression via alternation.\n    var matcher = RegExp([\n      (settings.escape || noMatch).source,\n      (settings.interpolate || noMatch).source,\n      (settings.evaluate || noMatch).source\n    ].join('|') + '|$', 'g');\n\n    // Compile the template source, escaping string literals appropriately.\n    var index = 0;\n    var source = \"__p+='\";\n    text.replace(matcher, function(match, escape, interpolate, evaluate, offset) {\n      source += text.slice(index, offset).replace(escaper, escapeChar);\n      index = offset + match.length;\n\n      if (escape) {\n        source += \"'+\\n((__t=(\" + escape + \"))==null?'':_.escape(__t))+\\n'\";\n      } else if (interpolate) {\n        source += \"'+\\n((__t=(\" + interpolate + \"))==null?'':__t)+\\n'\";\n      } else if (evaluate) {\n        source += \"';\\n\" + evaluate + \"\\n__p+='\";\n      }\n\n      // Adobe VMs need the match returned to produce the correct offest.\n      return match;\n    });\n    source += \"';\\n\";\n\n    // If a variable is not specified, place data values in local scope.\n    if (!settings.variable) source = 'with(obj||{}){\\n' + source + '}\\n';\n\n    source = \"var __t,__p='',__j=Array.prototype.join,\" +\n      \"print=function(){__p+=__j.call(arguments,'');};\\n\" +\n      source + 'return __p;\\n';\n\n    try {\n      var render = new Function(settings.variable || 'obj', '_', source);\n    } catch (e) {\n      e.source = source;\n      throw e;\n    }\n\n    var template = function(data) {\n      return render.call(this, data, _);\n    };\n\n    // Provide the compiled source as a convenience for precompilation.\n    var argument = settings.variable || 'obj';\n    template.source = 'function(' + argument + '){\\n' + source + '}';\n\n    return template;\n  };\n\n  // Add a \"chain\" function. Start chaining a wrapped Underscore object.\n  _.chain = function(obj) {\n    var instance = _(obj);\n    instance._chain = true;\n    return instance;\n  };\n\n  // OOP\n  // ---------------\n  // If Underscore is called as a function, it returns a wrapped object that\n  // can be used OO-style. This wrapper holds altered versions of all the\n  // underscore functions. Wrapped objects may be chained.\n\n  // Helper function to continue chaining intermediate results.\n  var result = function(instance, obj) {\n    return instance._chain ? _(obj).chain() : obj;\n  };\n\n  // Add your own custom functions to the Underscore object.\n  _.mixin = function(obj) {\n    _.each(_.functions(obj), function(name) {\n      var func = _[name] = obj[name];\n      _.prototype[name] = function() {\n        var args = [this._wrapped];\n        push.apply(args, arguments);\n        return result(this, func.apply(_, args));\n      };\n    });\n  };\n\n  // Add all of the Underscore functions to the wrapper object.\n  _.mixin(_);\n\n  // Add all mutator Array functions to the wrapper.\n  _.each(['pop', 'push', 'reverse', 'shift', 'sort', 'splice', 'unshift'], function(name) {\n    var method = ArrayProto[name];\n    _.prototype[name] = function() {\n      var obj = this._wrapped;\n      method.apply(obj, arguments);\n      if ((name === 'shift' || name === 'splice') && obj.length === 0) delete obj[0];\n      return result(this, obj);\n    };\n  });\n\n  // Add all accessor Array functions to the wrapper.\n  _.each(['concat', 'join', 'slice'], function(name) {\n    var method = ArrayProto[name];\n    _.prototype[name] = function() {\n      return result(this, method.apply(this._wrapped, arguments));\n    };\n  });\n\n  // Extracts the result from a wrapped and chained object.\n  _.prototype.value = function() {\n    return this._wrapped;\n  };\n\n  // Provide unwrapping proxy for some methods used in engine operations\n  // such as arithmetic and JSON stringification.\n  _.prototype.valueOf = _.prototype.toJSON = _.prototype.value;\n  \n  _.prototype.toString = function() {\n    return '' + this._wrapped;\n  };\n\n  // AMD registration happens at the end for compatibility with AMD loaders\n  // that may not enforce next-turn semantics on modules. Even though general\n  // practice for AMD registration is to be anonymous, underscore registers\n  // as a named module because, like jQuery, it is a base library that is\n  // popular enough to be bundled in a third party lib, but not be part of\n  // an AMD load request. Those cases could generate an error when an\n  // anonymous define() is called outside of a loader request.\n  if (typeof define === 'function' && define.amd) {\n    define('underscore', [], function() {\n      return _;\n    });\n  }\n}.call(this));","MutationObserver.js":"/**\n * @license\n * Copyright (c) 2014 The Polymer Project Authors. All rights reserved.\n * This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt\n * The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt\n * The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt\n * Code distributed by Google as part of the polymer project is also\n * subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt\n */\n\n(function(global) {\n\n  var registrationsTable = new WeakMap();\n\n  var setImmediate;\n\n  // As much as we would like to use the native implementation, IE\n  // (all versions) suffers a rather annoying bug where it will drop or defer\n  // callbacks when heavy DOM operations are being performed concurrently.\n  //\n  // For a thorough discussion on this, see:\n  // http://codeforhire.com/2013/09/21/setimmediate-and-messagechannel-broken-on-internet-explorer-10/\n  if (/Trident|Edge/.test(navigator.userAgent)) {\n    // Sadly, this bug also affects postMessage and MessageQueues.\n    //\n    // We would like to use the onreadystatechange hack for IE <= 10, but it is\n    // dangerous in the polyfilled environment due to requiring that the\n    // observed script element be in the document.\n    setImmediate = setTimeout;\n\n  // If some other browser ever implements it, let's prefer their native\n  // implementation:\n  } else if (window.setImmediate) {\n    setImmediate = window.setImmediate;\n\n  // Otherwise, we fall back to postMessage as a means of emulating the next\n  // task semantics of setImmediate.\n  } else {\n    var setImmediateQueue = [];\n    var sentinel = String(Math.random());\n    window.addEventListener('message', function(e) {\n      if (e.data === sentinel) {\n        var queue = setImmediateQueue;\n        setImmediateQueue = [];\n        queue.forEach(function(func) {\n          func();\n        });\n      }\n    });\n    setImmediate = function(func) {\n      setImmediateQueue.push(func);\n      window.postMessage(sentinel, '*');\n    };\n  }\n\n  // This is used to ensure that we never schedule 2 callas to setImmediate\n  var isScheduled = false;\n\n  // Keep track of observers that needs to be notified next time.\n  var scheduledObservers = [];\n\n  /**\n   * Schedules |dispatchCallback| to be called in the future.\n   * @param {MutationObserver} observer\n   */\n  function scheduleCallback(observer) {\n    scheduledObservers.push(observer);\n    if (!isScheduled) {\n      isScheduled = true;\n      setImmediate(dispatchCallbacks);\n    }\n  }\n\n  function wrapIfNeeded(node) {\n    return window.ShadowDOMPolyfill &&\n        window.ShadowDOMPolyfill.wrapIfNeeded(node) ||\n        node;\n  }\n\n  function dispatchCallbacks() {\n    // http://dom.spec.whatwg.org/#mutation-observers\n\n    isScheduled = false; // Used to allow a new setImmediate call above.\n\n    var observers = scheduledObservers;\n    scheduledObservers = [];\n    // Sort observers based on their creation UID (incremental).\n    observers.sort(function(o1, o2) {\n      return o1.uid_ - o2.uid_;\n    });\n\n    var anyNonEmpty = false;\n    observers.forEach(function(observer) {\n\n      // 2.1, 2.2\n      var queue = observer.takeRecords();\n      // 2.3. Remove all transient registered observers whose observer is mo.\n      removeTransientObserversFor(observer);\n\n      // 2.4\n      if (queue.length) {\n        observer.callback_(queue, observer);\n        anyNonEmpty = true;\n      }\n    });\n\n    // 3.\n    if (anyNonEmpty)\n      dispatchCallbacks();\n  }\n\n  function removeTransientObserversFor(observer) {\n    observer.nodes_.forEach(function(node) {\n      var registrations = registrationsTable.get(node);\n      if (!registrations)\n        return;\n      registrations.forEach(function(registration) {\n        if (registration.observer === observer)\n          registration.removeTransientObservers();\n      });\n    });\n  }\n\n  /**\n   * This function is used for the \"For each registered observer observer (with\n   * observer's options as options) in target's list of registered observers,\n   * run these substeps:\" and the \"For each ancestor ancestor of target, and for\n   * each registered observer observer (with options options) in ancestor's list\n   * of registered observers, run these substeps:\" part of the algorithms. The\n   * |options.subtree| is checked to ensure that the callback is called\n   * correctly.\n   *\n   * @param {Node} target\n   * @param {function(MutationObserverInit):MutationRecord} callback\n   */\n  function forEachAncestorAndObserverEnqueueRecord(target, callback) {\n    for (var node = target; node; node = node.parentNode) {\n      var registrations = registrationsTable.get(node);\n\n      if (registrations) {\n        for (var j = 0; j < registrations.length; j++) {\n          var registration = registrations[j];\n          var options = registration.options;\n\n          // Only target ignores subtree.\n          if (node !== target && !options.subtree)\n            continue;\n\n          var record = callback(options);\n          if (record)\n            registration.enqueue(record);\n        }\n      }\n    }\n  }\n\n  var uidCounter = 0;\n\n  /**\n   * The class that maps to the DOM MutationObserver interface.\n   * @param {Function} callback.\n   * @constructor\n   */\n  function JsMutationObserver(callback) {\n    this.callback_ = callback;\n    this.nodes_ = [];\n    this.records_ = [];\n    this.uid_ = ++uidCounter;\n  }\n\n  JsMutationObserver.prototype = {\n    observe: function(target, options) {\n      target = wrapIfNeeded(target);\n\n      // 1.1\n      if (!options.childList && !options.attributes && !options.characterData ||\n\n          // 1.2\n          options.attributeOldValue && !options.attributes ||\n\n          // 1.3\n          options.attributeFilter && options.attributeFilter.length &&\n              !options.attributes ||\n\n          // 1.4\n          options.characterDataOldValue && !options.characterData) {\n\n        throw new SyntaxError();\n      }\n\n      var registrations = registrationsTable.get(target);\n      if (!registrations)\n        registrationsTable.set(target, registrations = []);\n\n      // 2\n      // If target's list of registered observers already includes a registered\n      // observer associated with the context object, replace that registered\n      // observer's options with options.\n      var registration;\n      for (var i = 0; i < registrations.length; i++) {\n        if (registrations[i].observer === this) {\n          registration = registrations[i];\n          registration.removeListeners();\n          registration.options = options;\n          break;\n        }\n      }\n\n      // 3.\n      // Otherwise, add a new registered observer to target's list of registered\n      // observers with the context object as the observer and options as the\n      // options, and add target to context object's list of nodes on which it\n      // is registered.\n      if (!registration) {\n        registration = new Registration(this, target, options);\n        registrations.push(registration);\n        this.nodes_.push(target);\n      }\n\n      registration.addListeners();\n    },\n\n    disconnect: function() {\n      this.nodes_.forEach(function(node) {\n        var registrations = registrationsTable.get(node);\n        for (var i = 0; i < registrations.length; i++) {\n          var registration = registrations[i];\n          if (registration.observer === this) {\n            registration.removeListeners();\n            registrations.splice(i, 1);\n            // Each node can only have one registered observer associated with\n            // this observer.\n            break;\n          }\n        }\n      }, this);\n      this.records_ = [];\n    },\n\n    takeRecords: function() {\n      var copyOfRecords = this.records_;\n      this.records_ = [];\n      return copyOfRecords;\n    }\n  };\n\n  /**\n   * @param {string} type\n   * @param {Node} target\n   * @constructor\n   */\n  function MutationRecord(type, target) {\n    this.type = type;\n    this.target = target;\n    this.addedNodes = [];\n    this.removedNodes = [];\n    this.previousSibling = null;\n    this.nextSibling = null;\n    this.attributeName = null;\n    this.attributeNamespace = null;\n    this.oldValue = null;\n  }\n\n  function copyMutationRecord(original) {\n    var record = new MutationRecord(original.type, original.target);\n    record.addedNodes = original.addedNodes.slice();\n    record.removedNodes = original.removedNodes.slice();\n    record.previousSibling = original.previousSibling;\n    record.nextSibling = original.nextSibling;\n    record.attributeName = original.attributeName;\n    record.attributeNamespace = original.attributeNamespace;\n    record.oldValue = original.oldValue;\n    return record;\n  };\n\n  // We keep track of the two (possibly one) records used in a single mutation.\n  var currentRecord, recordWithOldValue;\n\n  /**\n   * Creates a record without |oldValue| and caches it as |currentRecord| for\n   * later use.\n   * @param {string} oldValue\n   * @return {MutationRecord}\n   */\n  function getRecord(type, target) {\n    return currentRecord = new MutationRecord(type, target);\n  }\n\n  /**\n   * Gets or creates a record with |oldValue| based in the |currentRecord|\n   * @param {string} oldValue\n   * @return {MutationRecord}\n   */\n  function getRecordWithOldValue(oldValue) {\n    if (recordWithOldValue)\n      return recordWithOldValue;\n    recordWithOldValue = copyMutationRecord(currentRecord);\n    recordWithOldValue.oldValue = oldValue;\n    return recordWithOldValue;\n  }\n\n  function clearRecords() {\n    currentRecord = recordWithOldValue = undefined;\n  }\n\n  /**\n   * @param {MutationRecord} record\n   * @return {boolean} Whether the record represents a record from the current\n   * mutation event.\n   */\n  function recordRepresentsCurrentMutation(record) {\n    return record === recordWithOldValue || record === currentRecord;\n  }\n\n  /**\n   * Selects which record, if any, to replace the last record in the queue.\n   * This returns |null| if no record should be replaced.\n   *\n   * @param {MutationRecord} lastRecord\n   * @param {MutationRecord} newRecord\n   * @param {MutationRecord}\n   */\n  function selectRecord(lastRecord, newRecord) {\n    if (lastRecord === newRecord)\n      return lastRecord;\n\n    // Check if the record we are adding represents the same record. If\n    // so, we keep the one with the oldValue in it.\n    if (recordWithOldValue && recordRepresentsCurrentMutation(lastRecord))\n      return recordWithOldValue;\n\n    return null;\n  }\n\n  /**\n   * Class used to represent a registered observer.\n   * @param {MutationObserver} observer\n   * @param {Node} target\n   * @param {MutationObserverInit} options\n   * @constructor\n   */\n  function Registration(observer, target, options) {\n    this.observer = observer;\n    this.target = target;\n    this.options = options;\n    this.transientObservedNodes = [];\n  }\n\n  Registration.prototype = {\n    enqueue: function(record) {\n      var records = this.observer.records_;\n      var length = records.length;\n\n      // There are cases where we replace the last record with the new record.\n      // For example if the record represents the same mutation we need to use\n      // the one with the oldValue. If we get same record (this can happen as we\n      // walk up the tree) we ignore the new record.\n      if (records.length > 0) {\n        var lastRecord = records[length - 1];\n        var recordToReplaceLast = selectRecord(lastRecord, record);\n        if (recordToReplaceLast) {\n          records[length - 1] = recordToReplaceLast;\n          return;\n        }\n      } else {\n        scheduleCallback(this.observer);\n      }\n\n      records[length] = record;\n    },\n\n    addListeners: function() {\n      this.addListeners_(this.target);\n    },\n\n    addListeners_: function(node) {\n      var options = this.options;\n      if (options.attributes)\n        node.addEventListener('DOMAttrModified', this, true);\n\n      if (options.characterData)\n        node.addEventListener('DOMCharacterDataModified', this, true);\n\n      if (options.childList)\n        node.addEventListener('DOMNodeInserted', this, true);\n\n      if (options.childList || options.subtree)\n        node.addEventListener('DOMNodeRemoved', this, true);\n    },\n\n    removeListeners: function() {\n      this.removeListeners_(this.target);\n    },\n\n    removeListeners_: function(node) {\n      var options = this.options;\n      if (options.attributes)\n        node.removeEventListener('DOMAttrModified', this, true);\n\n      if (options.characterData)\n        node.removeEventListener('DOMCharacterDataModified', this, true);\n\n      if (options.childList)\n        node.removeEventListener('DOMNodeInserted', this, true);\n\n      if (options.childList || options.subtree)\n        node.removeEventListener('DOMNodeRemoved', this, true);\n    },\n\n    /**\n     * Adds a transient observer on node. The transient observer gets removed\n     * next time we deliver the change records.\n     * @param {Node} node\n     */\n    addTransientObserver: function(node) {\n      // Don't add transient observers on the target itself. We already have all\n      // the required listeners set up on the target.\n      if (node === this.target)\n        return;\n\n      this.addListeners_(node);\n      this.transientObservedNodes.push(node);\n      var registrations = registrationsTable.get(node);\n      if (!registrations)\n        registrationsTable.set(node, registrations = []);\n\n      // We know that registrations does not contain this because we already\n      // checked if node === this.target.\n      registrations.push(this);\n    },\n\n    removeTransientObservers: function() {\n      var transientObservedNodes = this.transientObservedNodes;\n      this.transientObservedNodes = [];\n\n      transientObservedNodes.forEach(function(node) {\n        // Transient observers are never added to the target.\n        this.removeListeners_(node);\n\n        var registrations = registrationsTable.get(node);\n        for (var i = 0; i < registrations.length; i++) {\n          if (registrations[i] === this) {\n            registrations.splice(i, 1);\n            // Each node can only have one registered observer associated with\n            // this observer.\n            break;\n          }\n        }\n      }, this);\n    },\n\n    handleEvent: function(e) {\n      // Stop propagation since we are managing the propagation manually.\n      // This means that other mutation events on the page will not work\n      // correctly but that is by design.\n      e.stopImmediatePropagation();\n\n      switch (e.type) {\n        case 'DOMAttrModified':\n          // http://dom.spec.whatwg.org/#concept-mo-queue-attributes\n\n          var name = e.attrName;\n          var namespace = e.relatedNode.namespaceURI;\n          var target = e.target;\n\n          // 1.\n          var record = new getRecord('attributes', target);\n          record.attributeName = name;\n          record.attributeNamespace = namespace;\n\n          // 2.\n          var oldValue =\n              e.attrChange === MutationEvent.ADDITION ? null : e.prevValue;\n\n          forEachAncestorAndObserverEnqueueRecord(target, function(options) {\n            // 3.1, 4.2\n            if (!options.attributes)\n              return;\n\n            // 3.2, 4.3\n            if (options.attributeFilter && options.attributeFilter.length &&\n                options.attributeFilter.indexOf(name) === -1 &&\n                options.attributeFilter.indexOf(namespace) === -1) {\n              return;\n            }\n            // 3.3, 4.4\n            if (options.attributeOldValue)\n              return getRecordWithOldValue(oldValue);\n\n            // 3.4, 4.5\n            return record;\n          });\n\n          break;\n\n        case 'DOMCharacterDataModified':\n          // http://dom.spec.whatwg.org/#concept-mo-queue-characterdata\n          var target = e.target;\n\n          // 1.\n          var record = getRecord('characterData', target);\n\n          // 2.\n          var oldValue = e.prevValue;\n\n\n          forEachAncestorAndObserverEnqueueRecord(target, function(options) {\n            // 3.1, 4.2\n            if (!options.characterData)\n              return;\n\n            // 3.2, 4.3\n            if (options.characterDataOldValue)\n              return getRecordWithOldValue(oldValue);\n\n            // 3.3, 4.4\n            return record;\n          });\n\n          break;\n\n        case 'DOMNodeRemoved':\n          this.addTransientObserver(e.target);\n          // Fall through.\n        case 'DOMNodeInserted':\n          // http://dom.spec.whatwg.org/#concept-mo-queue-childlist\n          var changedNode = e.target;\n          var addedNodes, removedNodes;\n          if (e.type === 'DOMNodeInserted') {\n            addedNodes = [changedNode];\n            removedNodes = [];\n          } else {\n\n            addedNodes = [];\n            removedNodes = [changedNode];\n          }\n          var previousSibling = changedNode.previousSibling;\n          var nextSibling = changedNode.nextSibling;\n\n          // 1.\n          var record = getRecord('childList', e.target.parentNode);\n          record.addedNodes = addedNodes;\n          record.removedNodes = removedNodes;\n          record.previousSibling = previousSibling;\n          record.nextSibling = nextSibling;\n\n          forEachAncestorAndObserverEnqueueRecord(e.relatedNode, function(options) {\n            // 2.1, 3.2\n            if (!options.childList)\n              return;\n\n            // 2.2, 3.3\n            return record;\n          });\n\n      }\n\n      clearRecords();\n    }\n  };\n\n  global.JsMutationObserver = JsMutationObserver;\n\n  if (!global.MutationObserver)\n    global.MutationObserver = JsMutationObserver;\n\n\n})(this);","moment-timezone-with-data.js":"//! moment-timezone.js\n//! version : 0.5.5\n//! author : Tim Wood\n//! license : MIT\n//! github.com/moment/moment-timezone\n!function(a,b){\"use strict\";\"function\"==typeof define&&define.amd?define([\"moment\"],b):\"object\"==typeof module&&module.exports?module.exports=b(require(\"moment\")):b(a.moment)}(this,function(a){\"use strict\";function b(a){return a>96?a-87:a>64?a-29:a-48}function c(a){var c,d=0,e=a.split(\".\"),f=e[0],g=e[1]||\"\",h=1,i=0,j=1;for(45===a.charCodeAt(0)&&(d=1,j=-1),d;d<f.length;d++)c=b(f.charCodeAt(d)),i=60*i+c;for(d=0;d<g.length;d++)h/=60,c=b(g.charCodeAt(d)),i+=c*h;return i*j}function d(a){for(var b=0;b<a.length;b++)a[b]=c(a[b])}function e(a,b){for(var c=0;c<b;c++)a[c]=Math.round((a[c-1]||0)+6e4*a[c]);a[b-1]=1/0}function f(a,b){var c,d=[];for(c=0;c<b.length;c++)d[c]=a[b[c]];return d}function g(a){var b=a.split(\"|\"),c=b[2].split(\" \"),g=b[3].split(\"\"),h=b[4].split(\" \");return d(c),d(g),d(h),e(h,g.length),{name:b[0],abbrs:f(b[1].split(\" \"),g),offsets:f(c,g),untils:h,population:0|b[5]}}function h(a){a&&this._set(g(a))}function i(a){var b=a.toTimeString(),c=b.match(/\\([a-z ]+\\)/i);c&&c[0]?(c=c[0].match(/[A-Z]/g),c=c?c.join(\"\"):void 0):(c=b.match(/[A-Z]{3,5}/g),c=c?c[0]:void 0),\"GMT\"===c&&(c=void 0),this.at=+a,this.abbr=c,this.offset=a.getTimezoneOffset()}function j(a){this.zone=a,this.offsetScore=0,this.abbrScore=0}function k(a,b){for(var c,d;d=6e4*((b.at-a.at)/12e4|0);)c=new i(new Date(a.at+d)),c.offset===a.offset?a=c:b=c;return a}function l(){var a,b,c,d=(new Date).getFullYear()-2,e=new i(new Date(d,0,1)),f=[e];for(c=1;c<48;c++)b=new i(new Date(d,c,1)),b.offset!==e.offset&&(a=k(e,b),f.push(a),f.push(new i(new Date(a.at+6e4)))),e=b;for(c=0;c<4;c++)f.push(new i(new Date(d+c,0,1))),f.push(new i(new Date(d+c,6,1)));return f}function m(a,b){return a.offsetScore!==b.offsetScore?a.offsetScore-b.offsetScore:a.abbrScore!==b.abbrScore?a.abbrScore-b.abbrScore:b.zone.population-a.zone.population}function n(a,b){var c,e;for(d(b),c=0;c<b.length;c++)e=b[c],I[e]=I[e]||{},I[e][a]=!0}function o(a){var b,c,d,e=a.length,f={},g=[];for(b=0;b<e;b++){d=I[a[b].offset]||{};for(c in d)d.hasOwnProperty(c)&&(f[c]=!0)}for(b in f)f.hasOwnProperty(b)&&g.push(H[b]);return g}function p(){try{var a=Intl.DateTimeFormat().resolvedOptions().timeZone;if(a){var b=H[r(a)];if(b)return b;z(\"Moment Timezone found \"+a+\" from the Intl api, but did not have that data loaded.\")}}catch(c){}var d,e,f,g=l(),h=g.length,i=o(g),k=[];for(e=0;e<i.length;e++){for(d=new j(t(i[e]),h),f=0;f<h;f++)d.scoreOffsetAt(g[f]);k.push(d)}return k.sort(m),k.length>0?k[0].zone.name:void 0}function q(a){return D&&!a||(D=p()),D}function r(a){return(a||\"\").toLowerCase().replace(/\\//g,\"_\")}function s(a){var b,c,d,e;for(\"string\"==typeof a&&(a=[a]),b=0;b<a.length;b++)d=a[b].split(\"|\"),c=d[0],e=r(c),F[e]=a[b],H[e]=c,d[5]&&n(e,d[2].split(\" \"))}function t(a,b){a=r(a);var c,d=F[a];return d instanceof h?d:\"string\"==typeof d?(d=new h(d),F[a]=d,d):G[a]&&b!==t&&(c=t(G[a],t))?(d=F[a]=new h,d._set(c),d.name=H[a],d):null}function u(){var a,b=[];for(a in H)H.hasOwnProperty(a)&&(F[a]||F[G[a]])&&H[a]&&b.push(H[a]);return b.sort()}function v(a){var b,c,d,e;for(\"string\"==typeof a&&(a=[a]),b=0;b<a.length;b++)c=a[b].split(\"|\"),d=r(c[0]),e=r(c[1]),G[d]=e,H[d]=c[0],G[e]=d,H[e]=c[1]}function w(a){s(a.zones),v(a.links),A.dataVersion=a.version}function x(a){return x.didShowError||(x.didShowError=!0,z(\"moment.tz.zoneExists('\"+a+\"') has been deprecated in favor of !moment.tz.zone('\"+a+\"')\")),!!t(a)}function y(a){return!(!a._a||void 0!==a._tzm)}function z(a){\"undefined\"!=typeof console&&\"function\"==typeof console.error&&console.error(a)}function A(b){var c=Array.prototype.slice.call(arguments,0,-1),d=arguments[arguments.length-1],e=t(d),f=a.utc.apply(null,c);return e&&!a.isMoment(b)&&y(f)&&f.add(e.parse(f),\"minutes\"),f.tz(d),f}function B(a){return function(){return this._z?this._z.abbr(this):a.call(this)}}function C(a){return function(){return this._z=null,a.apply(this,arguments)}}if(void 0!==a.tz)return z(\"Moment Timezone \"+a.tz.version+\" was already loaded \"+(a.tz.dataVersion?\"with data from \":\"without any data\")+a.tz.dataVersion),a;var D,E=\"0.5.5\",F={},G={},H={},I={},J=a.version.split(\".\"),K=+J[0],L=+J[1];(K<2||2===K&&L<6)&&z(\"Moment Timezone requires Moment.js >= 2.6.0. You are using Moment.js \"+a.version+\". See momentjs.com\"),h.prototype={_set:function(a){this.name=a.name,this.abbrs=a.abbrs,this.untils=a.untils,this.offsets=a.offsets,this.population=a.population},_index:function(a){var b,c=+a,d=this.untils;for(b=0;b<d.length;b++)if(c<d[b])return b},parse:function(a){var b,c,d,e,f=+a,g=this.offsets,h=this.untils,i=h.length-1;for(e=0;e<i;e++)if(b=g[e],c=g[e+1],d=g[e?e-1:e],b<c&&A.moveAmbiguousForward?b=c:b>d&&A.moveInvalidForward&&(b=d),f<h[e]-6e4*b)return g[e];return g[i]},abbr:function(a){return this.abbrs[this._index(a)]},offset:function(a){return this.offsets[this._index(a)]}},j.prototype.scoreOffsetAt=function(a){this.offsetScore+=Math.abs(this.zone.offset(a.at)-a.offset),this.zone.abbr(a.at).replace(/[^A-Z]/g,\"\")!==a.abbr&&this.abbrScore++},A.version=E,A.dataVersion=\"\",A._zones=F,A._links=G,A._names=H,A.add=s,A.link=v,A.load=w,A.zone=t,A.zoneExists=x,A.guess=q,A.names=u,A.Zone=h,A.unpack=g,A.unpackBase60=c,A.needsOffset=y,A.moveInvalidForward=!0,A.moveAmbiguousForward=!1;var M=a.fn;a.tz=A,a.defaultZone=null,a.updateOffset=function(b,c){var d,e=a.defaultZone;void 0===b._z&&(e&&y(b)&&!b._isUTC&&(b._d=a.utc(b._a)._d,b.utc().add(e.parse(b),\"minutes\")),b._z=e),b._z&&(d=b._z.offset(b),Math.abs(d)<16&&(d/=60),void 0!==b.utcOffset?b.utcOffset(-d,c):b.zone(d,c))},M.tz=function(b){return b?(this._z=t(b),this._z?a.updateOffset(this):z(\"Moment Timezone has no data for \"+b+\". See http://momentjs.com/timezone/docs/#/data-loading/.\"),this):this._z?this._z.name:void 0},M.zoneName=B(M.zoneName),M.zoneAbbr=B(M.zoneAbbr),M.utc=C(M.utc),a.tz.setDefault=function(b){return(K<2||2===K&&L<9)&&z(\"Moment Timezone setDefault() requires Moment.js >= 2.9.0. You are using Moment.js \"+a.version+\".\"),a.defaultZone=b?t(b):null,a};var N=a.momentProperties;return\"[object Array]\"===Object.prototype.toString.call(N)?(N.push(\"_z\"),N.push(\"_a\")):N&&(N._z=null),w({version:\"2016f\",zones:[\"Africa/Abidjan|LMT GMT|g.8 0|01|-2ldXH.Q|48e5\",\"Africa/Accra|LMT GMT GHST|.Q 0 -k|012121212121212121212121212121212121212121212121|-26BbX.8 6tzX.8 MnE 1BAk MnE 1BAk MnE 1BAk MnE 1C0k MnE 1BAk MnE 1BAk MnE 1BAk MnE 1C0k MnE 1BAk MnE 1BAk MnE 1BAk MnE 1C0k MnE 1BAk MnE 1BAk MnE 1BAk MnE 1C0k MnE 1BAk MnE 1BAk MnE 1BAk MnE 1C0k MnE 1BAk MnE 1BAk MnE|41e5\",\"Africa/Nairobi|LMT EAT BEAT BEAUT|-2r.g -30 -2u -2J|01231|-1F3Cr.g 3Dzr.g okMu MFXJ|47e5\",\"Africa/Algiers|PMT WET WEST CET CEST|-9.l 0 -10 -10 -20|0121212121212121343431312123431213|-2nco9.l cNb9.l HA0 19A0 1iM0 11c0 1oo0 Wo0 1rc0 QM0 1EM0 UM0 DA0 Imo0 rd0 De0 9Xz0 1fb0 1ap0 16K0 2yo0 mEp0 hwL0 jxA0 11A0 dDd0 17b0 11B0 1cN0 2Dy0 1cN0 1fB0 1cL0|26e5\",\"Africa/Lagos|LMT WAT|-d.A -10|01|-22y0d.A|17e6\",\"Africa/Bissau|LMT WAT GMT|12.k 10 0|012|-2ldWV.E 2xonV.E|39e4\",\"Africa/Maputo|LMT CAT|-2a.k -20|01|-2GJea.k|26e5\",\"Africa/Cairo|EET EEST|-20 -30|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-1bIO0 vb0 1ip0 11z0 1iN0 1nz0 12p0 1pz0 10N0 1pz0 16p0 1jz0 s3d0 Vz0 1oN0 11b0 1oO0 10N0 1pz0 10N0 1pb0 10N0 1pb0 10N0 1pb0 10N0 1pz0 10N0 1pb0 10N0 1pb0 11d0 1oL0 11d0 1pb0 11d0 1oL0 11d0 1oL0 11d0 1oL0 11d0 1pb0 11d0 1oL0 11d0 1oL0 11d0 1oL0 11d0 1pb0 11d0 1oL0 11d0 1oL0 11d0 1oL0 11d0 1pb0 11d0 1oL0 11d0 1WL0 rd0 1Rz0 wp0 1pb0 11d0 1oL0 11d0 1oL0 11d0 1oL0 11d0 1pb0 11d0 1qL0 Xd0 1oL0 11d0 1oL0 11d0 1pb0 11d0 1oL0 11d0 1oL0 11d0 1ny0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 11z0 1o10 11z0 1o10 WL0 1qN0 Rb0 1wp0 On0 1zd0 Lz0 1EN0 Fb0 c10 8n0 8Nd0 gL0 e10 mn0|15e6\",\"Africa/Casablanca|LMT WET WEST CET|u.k 0 -10 -10|0121212121212121213121212121212121212121212121212121212121212121212121212121212121212121212121212121|-2gMnt.E 130Lt.E rb0 Dd0 dVb0 b6p0 TX0 EoB0 LL0 gnd0 rz0 43d0 AL0 1Nd0 XX0 1Cp0 pz0 dEp0 4mn0 SyN0 AL0 1Nd0 wn0 1FB0 Db0 1zd0 Lz0 1Nf0 wM0 co0 go0 1o00 s00 dA0 vc0 11A0 A00 e00 y00 11A0 uM0 e00 Dc0 11A0 s00 e00 IM0 WM0 mo0 gM0 LA0 WM0 jA0 e00 Rc0 11A0 e00 e00 U00 11A0 8o0 e00 11A0 11A0 5A0 e00 17c0 1fA0 1a00 1a00 1fA0 17c0 1io0 14o0 1lc0 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1lc0 14o0 1fA0|32e5\",\"Africa/Ceuta|WET WEST CET CEST|0 -10 -10 -20|010101010101010101010232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232|-25KN0 11z0 drd0 18o0 3I00 17c0 1fA0 1a00 1io0 1a00 1y7p0 LL0 gnd0 rz0 43d0 AL0 1Nd0 XX0 1Cp0 pz0 dEp0 4VB0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|85e3\",\"Africa/El_Aaiun|LMT WAT WET WEST|Q.M 10 0 -10|01232323232323232323232323232323232323232323232323232323232323232323232323232323232323232|-1rDz7.c 1GVA7.c 6L0 AL0 1Nd0 XX0 1Cp0 pz0 1cBB0 AL0 1Nd0 wn0 1FB0 Db0 1zd0 Lz0 1Nf0 wM0 co0 go0 1o00 s00 dA0 vc0 11A0 A00 e00 y00 11A0 uM0 e00 Dc0 11A0 s00 e00 IM0 WM0 mo0 gM0 LA0 WM0 jA0 e00 Rc0 11A0 e00 e00 U00 11A0 8o0 e00 11A0 11A0 5A0 e00 17c0 1fA0 1a00 1a00 1fA0 17c0 1io0 14o0 1lc0 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1lc0 14o0 1fA0|20e4\",\"Africa/Johannesburg|SAST SAST SAST|-1u -20 -30|012121|-2GJdu 1Ajdu 1cL0 1cN0 1cL0|84e5\",\"Africa/Khartoum|LMT CAT CAST EAT|-2a.8 -20 -30 -30|01212121212121212121212121212121213|-1yW2a.8 1zK0a.8 16L0 1iN0 17b0 1jd0 17b0 1ip0 17z0 1i10 17X0 1hB0 18n0 1hd0 19b0 1gp0 19z0 1iN0 17b0 1ip0 17z0 1i10 18n0 1hd0 18L0 1gN0 19b0 1gp0 19z0 1iN0 17z0 1i10 17X0 yGd0|51e5\",\"Africa/Monrovia|MMT LRT GMT|H.8 I.u 0|012|-23Lzg.Q 29s01.m|11e5\",\"Africa/Ndjamena|LMT WAT WAST|-10.c -10 -20|0121|-2le10.c 2J3c0.c Wn0|13e5\",\"Africa/Tripoli|LMT CET CEST EET|-Q.I -10 -20 -20|012121213121212121212121213123123|-21JcQ.I 1hnBQ.I vx0 4iP0 xx0 4eN0 Bb0 7ip0 U0n0 A10 1db0 1cN0 1db0 1dd0 1db0 1eN0 1bb0 1e10 1cL0 1c10 1db0 1dd0 1db0 1cN0 1db0 1q10 fAn0 1ep0 1db0 AKq0 TA0 1o00|11e5\",\"Africa/Tunis|PMT CET CEST|-9.l -10 -20|0121212121212121212121212121212121|-2nco9.l 18pa9.l 1qM0 DA0 3Tc0 11B0 1ze0 WM0 7z0 3d0 14L0 1cN0 1f90 1ar0 16J0 1gXB0 WM0 1rA0 11c0 nwo0 Ko0 1cM0 1cM0 1rA0 10M0 zuM0 10N0 1aN0 1qM0 WM0 1qM0 11A0 1o00|20e5\",\"Africa/Windhoek|SWAT SAST SAST CAT WAT WAST|-1u -20 -30 -20 -10 -20|012134545454545454545454545454545454545454545454545454545454545454545454545454545454545454545|-2GJdu 1Ajdu 1cL0 1SqL0 9NA0 11D0 1nX0 11B0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 11B0 1nX0 11B0|32e4\",\"America/Adak|NST NWT NPT BST BDT AHST HST HDT|b0 a0 a0 b0 a0 a0 a0 90|012034343434343434343434343434343456767676767676767676767676767676767676767676767676767676767676767676767676767676767676767676767676767676767676|-17SX0 8wW0 iB0 Qlb0 52O0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 cm0 10q0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|326\",\"America/Anchorage|CAT CAWT CAPT AHST AHDT YST AKST AKDT|a0 90 90 a0 90 90 90 80|012034343434343434343434343434343456767676767676767676767676767676767676767676767676767676767676767676767676767676767676767676767676767676767676|-17T00 8wX0 iA0 Qlb0 52O0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 cm0 10q0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|30e4\",\"America/Port_of_Spain|LMT AST|46.4 40|01|-2kNvR.U|43e3\",\"America/Araguaina|LMT BRT BRST|3c.M 30 20|0121212121212121212121212121212121212121212121212121|-2glwL.c HdKL.c 1cc0 1e10 1bX0 Ezd0 So0 1vA0 Mn0 1BB0 ML0 1BB0 zX0 qe10 xb0 2ep0 nz0 1C10 zX0 1C10 LX0 1C10 Mn0 H210 Rb0 1tB0 IL0 1Fd0 FX0 1EN0 FX0 1HB0 Lz0 dMN0 Lz0 1zd0 Rb0 1wN0 Wn0 1tB0 Rb0 1tB0 WL0 1tB0 Rb0 1zd0 On0 1HB0 FX0 ny10 Lz0|14e4\",\"America/Argentina/Buenos_Aires|CMT ART ARST ART ARST|4g.M 40 30 30 20|0121212121212121212121212121212121212121213434343434343234343|-20UHH.c pKnH.c Mn0 1iN0 Tb0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 MN0 2jz0 MN0 4lX0 u10 5Lb0 1pB0 Fnz0 u10 uL0 1vd0 SL0 1vd0 SL0 1vd0 17z0 1cN0 1fz0 1cN0 1cL0 1cN0 asn0 Db0 zvd0 Bz0 1tB0 TX0 1wp0 Rb0 1wp0 Rb0 1wp0 TX0 g0p0 10M0 j3c0 uL0 1qN0 WL0\",\"America/Argentina/Catamarca|CMT ART ARST ART ARST WART|4g.M 40 30 30 20 40|0121212121212121212121212121212121212121213434343454343235343|-20UHH.c pKnH.c Mn0 1iN0 Tb0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 MN0 2jz0 MN0 4lX0 u10 5Lb0 1pB0 Fnz0 u10 uL0 1vd0 SL0 1vd0 SL0 1vd0 17z0 1cN0 1fz0 1cN0 1cL0 1cN0 asn0 Db0 zvd0 Bz0 1tB0 TX0 1wp0 Rb0 1wq0 Ra0 1wp0 TX0 g0p0 10M0 ako0 7B0 8zb0 uL0\",\"America/Argentina/Cordoba|CMT ART ARST ART ARST WART|4g.M 40 30 30 20 40|0121212121212121212121212121212121212121213434343454343234343|-20UHH.c pKnH.c Mn0 1iN0 Tb0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 MN0 2jz0 MN0 4lX0 u10 5Lb0 1pB0 Fnz0 u10 uL0 1vd0 SL0 1vd0 SL0 1vd0 17z0 1cN0 1fz0 1cN0 1cL0 1cN0 asn0 Db0 zvd0 Bz0 1tB0 TX0 1wp0 Rb0 1wq0 Ra0 1wp0 TX0 g0p0 10M0 j3c0 uL0 1qN0 WL0\",\"America/Argentina/Jujuy|CMT ART ARST ART ARST WART WARST|4g.M 40 30 30 20 40 30|01212121212121212121212121212121212121212134343456543432343|-20UHH.c pKnH.c Mn0 1iN0 Tb0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 MN0 2jz0 MN0 4lX0 u10 5Lb0 1pB0 Fnz0 u10 uL0 1vd0 SL0 1vd0 SL0 1vd0 17z0 1cN0 1fz0 1cN0 1cL0 1cN0 asn0 Db0 zvd0 Bz0 1tB0 TX0 1ze0 TX0 1ld0 WK0 1wp0 TX0 g0p0 10M0 j3c0 uL0\",\"America/Argentina/La_Rioja|CMT ART ARST ART ARST WART|4g.M 40 30 30 20 40|01212121212121212121212121212121212121212134343434534343235343|-20UHH.c pKnH.c Mn0 1iN0 Tb0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 MN0 2jz0 MN0 4lX0 u10 5Lb0 1pB0 Fnz0 u10 uL0 1vd0 SL0 1vd0 SL0 1vd0 17z0 1cN0 1fz0 1cN0 1cL0 1cN0 asn0 Db0 zvd0 Bz0 1tB0 TX0 1wp0 Qn0 qO0 16n0 Rb0 1wp0 TX0 g0p0 10M0 ako0 7B0 8zb0 uL0\",\"America/Argentina/Mendoza|CMT ART ARST ART ARST WART WARST|4g.M 40 30 30 20 40 30|0121212121212121212121212121212121212121213434345656543235343|-20UHH.c pKnH.c Mn0 1iN0 Tb0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 MN0 2jz0 MN0 4lX0 u10 5Lb0 1pB0 Fnz0 u10 uL0 1vd0 SL0 1vd0 SL0 1vd0 17z0 1cN0 1fz0 1cN0 1cL0 1cN0 asn0 Db0 zvd0 Bz0 1tB0 TX0 1u20 SL0 1vd0 Tb0 1wp0 TW0 g0p0 10M0 agM0 Op0 7TX0 uL0\",\"America/Argentina/Rio_Gallegos|CMT ART ARST ART ARST WART|4g.M 40 30 30 20 40|0121212121212121212121212121212121212121213434343434343235343|-20UHH.c pKnH.c Mn0 1iN0 Tb0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 MN0 2jz0 MN0 4lX0 u10 5Lb0 1pB0 Fnz0 u10 uL0 1vd0 SL0 1vd0 SL0 1vd0 17z0 1cN0 1fz0 1cN0 1cL0 1cN0 asn0 Db0 zvd0 Bz0 1tB0 TX0 1wp0 Rb0 1wp0 Rb0 1wp0 TX0 g0p0 10M0 ako0 7B0 8zb0 uL0\",\"America/Argentina/Salta|CMT ART ARST ART ARST WART|4g.M 40 30 30 20 40|01212121212121212121212121212121212121212134343434543432343|-20UHH.c pKnH.c Mn0 1iN0 Tb0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 MN0 2jz0 MN0 4lX0 u10 5Lb0 1pB0 Fnz0 u10 uL0 1vd0 SL0 1vd0 SL0 1vd0 17z0 1cN0 1fz0 1cN0 1cL0 1cN0 asn0 Db0 zvd0 Bz0 1tB0 TX0 1wp0 Rb0 1wq0 Ra0 1wp0 TX0 g0p0 10M0 j3c0 uL0\",\"America/Argentina/San_Juan|CMT ART ARST ART ARST WART|4g.M 40 30 30 20 40|01212121212121212121212121212121212121212134343434534343235343|-20UHH.c pKnH.c Mn0 1iN0 Tb0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 MN0 2jz0 MN0 4lX0 u10 5Lb0 1pB0 Fnz0 u10 uL0 1vd0 SL0 1vd0 SL0 1vd0 17z0 1cN0 1fz0 1cN0 1cL0 1cN0 asn0 Db0 zvd0 Bz0 1tB0 TX0 1wp0 Qn0 qO0 16n0 Rb0 1wp0 TX0 g0p0 10M0 ak00 m10 8lb0 uL0\",\"America/Argentina/San_Luis|CMT ART ARST ART ARST WART WARST|4g.M 40 30 30 20 40 30|01212121212121212121212121212121212121212134343456536353465653|-20UHH.c pKnH.c Mn0 1iN0 Tb0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 MN0 2jz0 MN0 4lX0 u10 5Lb0 1pB0 Fnz0 u10 uL0 1vd0 SL0 1vd0 SL0 1vd0 17z0 1cN0 1fz0 1cN0 1cL0 1cN0 asn0 Db0 zvd0 Bz0 1tB0 XX0 1q20 SL0 AN0 kin0 10M0 ak00 m10 8lb0 8L0 jd0 1qN0 WL0 1qN0\",\"America/Argentina/Tucuman|CMT ART ARST ART ARST WART|4g.M 40 30 30 20 40|012121212121212121212121212121212121212121343434345434323534343|-20UHH.c pKnH.c Mn0 1iN0 Tb0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 MN0 2jz0 MN0 4lX0 u10 5Lb0 1pB0 Fnz0 u10 uL0 1vd0 SL0 1vd0 SL0 1vd0 17z0 1cN0 1fz0 1cN0 1cL0 1cN0 asn0 Db0 zvd0 Bz0 1tB0 TX0 1wp0 Rb0 1wq0 Ra0 1wp0 TX0 g0p0 10M0 ako0 4N0 8BX0 uL0 1qN0 WL0\",\"America/Argentina/Ushuaia|CMT ART ARST ART ARST WART|4g.M 40 30 30 20 40|0121212121212121212121212121212121212121213434343434343235343|-20UHH.c pKnH.c Mn0 1iN0 Tb0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 MN0 2jz0 MN0 4lX0 u10 5Lb0 1pB0 Fnz0 u10 uL0 1vd0 SL0 1vd0 SL0 1vd0 17z0 1cN0 1fz0 1cN0 1cL0 1cN0 asn0 Db0 zvd0 Bz0 1tB0 TX0 1wp0 Rb0 1wp0 Rb0 1wp0 TX0 g0p0 10M0 ajA0 8p0 8zb0 uL0\",\"America/Curacao|LMT ANT AST|4z.L 4u 40|012|-2kV7o.d 28KLS.d|15e4\",\"America/Asuncion|AMT PYT PYT PYST|3O.E 40 30 30|012131313131313131313131313131313131313131313131313131313131313131313131313131313131313131313131313131313131313131313131313131313|-1x589.k 1DKM9.k 3CL0 3Dd0 10L0 1pB0 10n0 1pB0 10n0 1pB0 1cL0 1dd0 1db0 1dd0 1cL0 1dd0 1cL0 1dd0 1cL0 1dd0 1db0 1dd0 1cL0 1dd0 1cL0 1dd0 1cL0 1dd0 1db0 1dd0 1cL0 1lB0 14n0 1dd0 1cL0 1fd0 WL0 1rd0 1aL0 1dB0 Xz0 1qp0 Xb0 1qN0 10L0 1rB0 TX0 1tB0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1qN0 1cL0 WN0 1qL0 11B0 1nX0 1ip0 WL0 1qN0 WL0 1qN0 WL0 1tB0 TX0 1tB0 TX0 1tB0 19X0 1a10 1fz0 1a10 1fz0 1cN0 17b0 1ip0 17b0 1ip0 17b0 1ip0 19X0 1fB0 19X0 1fB0 19X0 1ip0 17b0 1ip0 17b0 1ip0 19X0 1fB0 19X0 1fB0 19X0 1fB0 19X0 1ip0 17b0 1ip0 17b0 1ip0 19X0 1fB0 19X0 1fB0 19X0 1ip0 17b0 1ip0 17b0 1ip0 19X0 1fB0 19X0 1fB0 19X0 1fB0 19X0 1ip0 17b0 1ip0 17b0 1ip0|28e5\",\"America/Atikokan|CST CDT CWT CPT EST|60 50 50 50 50|0101234|-25TQ0 1in0 Rnb0 3je0 8x30 iw0|28e2\",\"America/Bahia|LMT BRT BRST|2y.4 30 20|01212121212121212121212121212121212121212121212121212121212121|-2glxp.U HdLp.U 1cc0 1e10 1bX0 Ezd0 So0 1vA0 Mn0 1BB0 ML0 1BB0 zX0 qe10 xb0 2ep0 nz0 1C10 zX0 1C10 LX0 1C10 Mn0 H210 Rb0 1tB0 IL0 1Fd0 FX0 1EN0 FX0 1HB0 Lz0 1EN0 Lz0 1C10 IL0 1HB0 Db0 1HB0 On0 1zd0 On0 1zd0 Lz0 1zd0 Rb0 1wN0 Wn0 1tB0 Rb0 1tB0 WL0 1tB0 Rb0 1zd0 On0 1HB0 FX0 l5B0 Rb0|27e5\",\"America/Bahia_Banderas|LMT MST CST PST MDT CDT|71 70 60 80 60 50|0121212131414141414141414141414141414152525252525252525252525252525252525252525252525252525252|-1UQF0 deL0 8lc0 17c0 10M0 1dd0 otX0 gmN0 P2N0 13Vd0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 1fB0 WL0 1fB0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nW0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0|84e3\",\"America/Barbados|LMT BMT AST ADT|3W.t 3W.t 40 30|01232323232|-1Q0I1.v jsM0 1ODC1.v IL0 1ip0 17b0 1ip0 17b0 1ld0 13b0|28e4\",\"America/Belem|LMT BRT BRST|3d.U 30 20|012121212121212121212121212121|-2glwK.4 HdKK.4 1cc0 1e10 1bX0 Ezd0 So0 1vA0 Mn0 1BB0 ML0 1BB0 zX0 qe10 xb0 2ep0 nz0 1C10 zX0 1C10 LX0 1C10 Mn0 H210 Rb0 1tB0 IL0 1Fd0 FX0|20e5\",\"America/Belize|LMT CST CHDT CDT|5Q.M 60 5u 50|01212121212121212121212121212121212121212121212121213131|-2kBu7.c fPA7.c Onu 1zcu Rbu 1wou Rbu 1wou Rbu 1zcu Onu 1zcu Onu 1zcu Rbu 1wou Rbu 1wou Rbu 1wou Rbu 1zcu Onu 1zcu Onu 1zcu Rbu 1wou Rbu 1wou Rbu 1zcu Onu 1zcu Onu 1zcu Onu 1zcu Rbu 1wou Rbu 1wou Rbu 1zcu Onu 1zcu Onu 1zcu Rbu 1wou Rbu 1f0Mu qn0 lxB0 mn0|57e3\",\"America/Blanc-Sablon|AST ADT AWT APT|40 30 30 30|010230|-25TS0 1in0 UGp0 8x50 iu0|11e2\",\"America/Boa_Vista|LMT AMT AMST|42.E 40 30|0121212121212121212121212121212121|-2glvV.k HdKV.k 1cc0 1e10 1bX0 Ezd0 So0 1vA0 Mn0 1BB0 ML0 1BB0 zX0 qe10 xb0 2ep0 nz0 1C10 zX0 1C10 LX0 1C10 Mn0 H210 Rb0 1tB0 IL0 1Fd0 FX0 smp0 WL0 1tB0 2L0|62e2\",\"America/Bogota|BMT COT COST|4U.g 50 40|0121|-2eb73.I 38yo3.I 2en0|90e5\",\"America/Boise|PST PDT MST MWT MPT MDT|80 70 70 60 60 60|0101023425252525252525252525252525252525252525252525252525252525252525252525252525252525252525252525252525252525252525252525252525252525252525252525252|-261q0 1nX0 11B0 1nX0 8C10 JCL0 8x20 ix0 QwN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 Dd0 1Kn0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|21e4\",\"America/Cambridge_Bay|-00 MST MWT MPT MDDT MDT CST CDT EST|0 70 60 60 50 60 60 50 50|0123141515151515151515151515151515151515151515678651515151515151515151515151515151515151515151515151515151515151515151515151|-21Jc0 RO90 8x20 ix0 LCL0 1fA0 zgO0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11A0 1nX0 2K0 WQ0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|15e2\",\"America/Campo_Grande|LMT AMT AMST|3C.s 40 30|012121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212|-2glwl.w HdLl.w 1cc0 1e10 1bX0 Ezd0 So0 1vA0 Mn0 1BB0 ML0 1BB0 zX0 qe10 xb0 2ep0 nz0 1C10 zX0 1C10 LX0 1C10 Mn0 H210 Rb0 1tB0 IL0 1Fd0 FX0 1EN0 FX0 1HB0 Lz0 1EN0 Lz0 1C10 IL0 1HB0 Db0 1HB0 On0 1zd0 On0 1zd0 Lz0 1zd0 Rb0 1wN0 Wn0 1tB0 Rb0 1tB0 WL0 1tB0 Rb0 1zd0 On0 1HB0 FX0 1C10 Lz0 1Ip0 HX0 1zd0 On0 1HB0 IL0 1wp0 On0 1C10 Lz0 1C10 On0 1zd0 On0 1zd0 Rb0 1zd0 Lz0 1C10 Lz0 1C10 On0 1zd0 On0 1zd0 On0 1zd0 On0 1C10 Lz0 1C10 Lz0 1C10 On0 1zd0 On0 1zd0 Rb0 1wp0 On0 1C10 Lz0 1C10 On0 1zd0 On0 1zd0 On0 1zd0 On0 1C10 Lz0 1C10 Lz0 1C10 Lz0 1C10 On0 1zd0 Rb0 1wp0 On0 1C10 Lz0 1C10 On0 1zd0|77e4\",\"America/Cancun|LMT CST EST EDT CDT|5L.4 60 50 40 50|0123232341414141414141414141414141414141412|-1UQG0 2q2o0 yLB0 1lb0 14p0 1lb0 14p0 Lz0 xB0 14p0 1nX0 11B0 1nX0 1fB0 WL0 1fB0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 Dd0|63e4\",\"America/Caracas|CMT VET VET|4r.E 4u 40|01212|-2kV7w.k 28KM2.k 1IwOu kqo0|29e5\",\"America/Cayenne|LMT GFT GFT|3t.k 40 30|012|-2mrwu.E 2gWou.E|58e3\",\"America/Panama|CMT EST|5j.A 50|01|-2uduE.o|15e5\",\"America/Chicago|CST CDT EST CWT CPT|60 50 50 50 50|01010101010101010101010101010101010102010101010103401010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-261s0 1nX0 11B0 1nX0 1wp0 TX0 WN0 1qL0 1cN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 11z0 1o10 11z0 11B0 1Hz0 14p0 11z0 1o10 11z0 1qN0 WL0 1qN0 11z0 1o10 11z0 RB0 8x30 iw0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|92e5\",\"America/Chihuahua|LMT MST CST CDT MDT|74.k 70 60 50 60|0121212323241414141414141414141414141414141414141414141414141414141414141414141414141414141|-1UQF0 deL0 8lc0 17c0 10M0 1dd0 2zQN0 1lb0 14p0 1lb0 14q0 1lb0 14p0 1nX0 11B0 1nX0 1fB0 WL0 1fB0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0|81e4\",\"America/Costa_Rica|SJMT CST CDT|5A.d 60 50|0121212121|-1Xd6n.L 2lu0n.L Db0 1Kp0 Db0 pRB0 15b0 1kp0 mL0|12e5\",\"America/Creston|MST PST|70 80|010|-29DR0 43B0|53e2\",\"America/Cuiaba|LMT AMT AMST|3I.k 40 30|0121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212|-2glwf.E HdLf.E 1cc0 1e10 1bX0 Ezd0 So0 1vA0 Mn0 1BB0 ML0 1BB0 zX0 qe10 xb0 2ep0 nz0 1C10 zX0 1C10 LX0 1C10 Mn0 H210 Rb0 1tB0 IL0 1Fd0 FX0 1EN0 FX0 1HB0 Lz0 1EN0 Lz0 1C10 IL0 1HB0 Db0 1HB0 On0 1zd0 On0 1zd0 Lz0 1zd0 Rb0 1wN0 Wn0 1tB0 Rb0 1tB0 WL0 1tB0 Rb0 1zd0 On0 1HB0 FX0 4a10 HX0 1zd0 On0 1HB0 IL0 1wp0 On0 1C10 Lz0 1C10 On0 1zd0 On0 1zd0 Rb0 1zd0 Lz0 1C10 Lz0 1C10 On0 1zd0 On0 1zd0 On0 1zd0 On0 1C10 Lz0 1C10 Lz0 1C10 On0 1zd0 On0 1zd0 Rb0 1wp0 On0 1C10 Lz0 1C10 On0 1zd0 On0 1zd0 On0 1zd0 On0 1C10 Lz0 1C10 Lz0 1C10 Lz0 1C10 On0 1zd0 Rb0 1wp0 On0 1C10 Lz0 1C10 On0 1zd0|54e4\",\"America/Danmarkshavn|LMT WGT WGST GMT|1e.E 30 20 0|01212121212121212121212121212121213|-2a5WJ.k 2z5fJ.k 19U0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 DC0|8\",\"America/Dawson|YST YDT YWT YPT YDDT PST PDT|90 80 80 80 70 80 70|0101023040565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565|-25TN0 1in0 1o10 13V0 Ser0 8x00 iz0 LCL0 1fA0 jrA0 fNd0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|13e2\",\"America/Dawson_Creek|PST PDT PWT PPT MST|80 70 70 70 70|0102301010101010101010101010101010101010101010101010101014|-25TO0 1in0 UGp0 8x10 iy0 3NB0 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 ML0|12e3\",\"America/Denver|MST MDT MWT MPT|70 60 60 60|01010101023010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-261r0 1nX0 11B0 1nX0 11B0 1qL0 WN0 mn0 Ord0 8x20 ix0 LCN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|26e5\",\"America/Detroit|LMT CST EST EWT EPT EDT|5w.b 60 50 40 40 40|01234252525252525252525252525252525252525252525252525252525252525252525252525252525252525252525252525252525252525252525252525252525252525252|-2Cgir.N peqr.N 156L0 8x40 iv0 6fd0 11z0 Jy10 SL0 dnB0 1cL0 s10 1Vz0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|37e5\",\"America/Edmonton|LMT MST MDT MWT MPT|7x.Q 70 60 60 60|01212121212121341212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-2yd4q.8 shdq.8 1in0 17d0 hz0 2dB0 1fz0 1a10 11z0 1qN0 WL0 1qN0 11z0 IGN0 8x20 ix0 3NB0 11z0 LFB0 1cL0 3Cp0 1cL0 66N0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|10e5\",\"America/Eirunepe|LMT ACT ACST AMT|4D.s 50 40 40|0121212121212121212121212121212131|-2glvk.w HdLk.w 1cc0 1e10 1bX0 Ezd0 So0 1vA0 Mn0 1BB0 ML0 1BB0 zX0 qe10 xb0 2ep0 nz0 1C10 zX0 1C10 LX0 1C10 Mn0 H210 Rb0 1tB0 IL0 1Fd0 FX0 dPB0 On0 yTd0 d5X0|31e3\",\"America/El_Salvador|LMT CST CDT|5U.M 60 50|012121|-1XiG3.c 2Fvc3.c WL0 1qN0 WL0|11e5\",\"America/Tijuana|LMT MST PST PDT PWT PPT|7M.4 70 80 70 70 70|012123245232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232|-1UQE0 4PX0 8mM0 8lc0 SN0 1cL0 pHB0 83r0 zI0 5O10 1Rz0 cOP0 11z0 1o10 11z0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 BUp0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 U10 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|20e5\",\"America/Fort_Nelson|PST PDT PWT PPT MST|80 70 70 70 70|01023010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010104|-25TO0 1in0 UGp0 8x10 iy0 3NB0 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0|39e2\",\"America/Fort_Wayne|CST CDT CWT CPT EST EDT|60 50 50 50 50 40|010101023010101010101010101040454545454545454545454545454545454545454545454545454545454545454545454|-261s0 1nX0 11B0 1nX0 QI10 Db0 RB0 8x30 iw0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 5Tz0 1o10 qLb0 1cL0 1cN0 1cL0 1qhd0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0\",\"America/Fortaleza|LMT BRT BRST|2y 30 20|0121212121212121212121212121212121212121|-2glxq HdLq 1cc0 1e10 1bX0 Ezd0 So0 1vA0 Mn0 1BB0 ML0 1BB0 zX0 qe10 xb0 2ep0 nz0 1C10 zX0 1C10 LX0 1C10 Mn0 H210 Rb0 1tB0 IL0 1Fd0 FX0 1EN0 FX0 1HB0 Lz0 nsp0 WL0 1tB0 5z0 2mN0 On0|34e5\",\"America/Glace_Bay|LMT AST ADT AWT APT|3X.M 40 30 30 30|012134121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-2IsI0.c CwO0.c 1in0 UGp0 8x50 iu0 iq10 11z0 Jg10 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|19e3\",\"America/Godthab|LMT WGT WGST|3q.U 30 20|0121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-2a5Ux.4 2z5dx.4 19U0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|17e3\",\"America/Goose_Bay|NST NDT NST NDT NWT NPT AST ADT ADDT|3u.Q 2u.Q 3u 2u 2u 2u 40 30 20|010232323232323245232323232323232323232323232323232323232326767676767676767676767676767676767676767676768676767676767676767676767676767676767676767676767676767676767676767676767676767676767676767676767676|-25TSt.8 1in0 DXb0 2HbX.8 WL0 1qN0 WL0 1qN0 WL0 1tB0 TX0 1tB0 WL0 1qN0 WL0 1qN0 7UHu itu 1tB0 WL0 1qN0 WL0 1qN0 WL0 1qN0 WL0 1tB0 WL0 1ld0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 S10 g0u 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14n1 1lb0 14p0 1nW0 11C0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zcX Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|76e2\",\"America/Grand_Turk|KMT EST EDT AST|57.b 50 40 40|0121212121212121212121212121212121212121212121212121212121212121212121212123|-2l1uQ.N 2HHBQ.N 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|37e2\",\"America/Guatemala|LMT CST CDT|62.4 60 50|0121212121|-24KhV.U 2efXV.U An0 mtd0 Nz0 ifB0 17b0 zDB0 11z0|13e5\",\"America/Guayaquil|QMT ECT|5e 50|01|-1yVSK|27e5\",\"America/Guyana|LMT GBGT GYT GYT GYT|3Q.E 3J 3J 30 40|01234|-2dvU7.k 24JzQ.k mlc0 Bxbf|80e4\",\"America/Halifax|LMT AST ADT AWT APT|4e.o 40 30 30 30|0121212121212121212121212121212121212121212121212134121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-2IsHJ.A xzzJ.A 1db0 3I30 1in0 3HX0 IL0 1E10 ML0 1yN0 Pb0 1Bd0 Mn0 1Bd0 Rz0 1w10 Xb0 1w10 LX0 1w10 Xb0 1w10 Lz0 1C10 Jz0 1E10 OL0 1yN0 Un0 1qp0 Xb0 1qp0 11X0 1w10 Lz0 1HB0 LX0 1C10 FX0 1w10 Xb0 1qp0 Xb0 1BB0 LX0 1td0 Xb0 1qp0 Xb0 Rf0 8x50 iu0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 3Qp0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 3Qp0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 6i10 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|39e4\",\"America/Havana|HMT CST CDT|5t.A 50 40|012121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-1Meuu.o 72zu.o ML0 sld0 An0 1Nd0 Db0 1Nd0 An0 6Ep0 An0 1Nd0 An0 JDd0 Mn0 1Ap0 On0 1fd0 11X0 1qN0 WL0 1wp0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 14n0 1ld0 14L0 1kN0 15b0 1kp0 1cL0 1cN0 1fz0 1a10 1fz0 1fB0 11z0 14p0 1nX0 11B0 1nX0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 14n0 1ld0 14n0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 1a10 1in0 1a10 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1cM0 1cM0 1fA0 17c0 1o00 11A0 1qM0 11A0 1o00 11A0 1o00 14o0 1lc0 14o0 1lc0 11A0 6i00 Rc0 1wo0 U00 1tA0 Rc0 1wo0 U00 1wo0 U00 1zc0 U00 1qM0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0|21e5\",\"America/Hermosillo|LMT MST CST PST MDT|7n.Q 70 60 80 60|0121212131414141|-1UQF0 deL0 8lc0 17c0 10M0 1dd0 otX0 gmN0 P2N0 13Vd0 1lb0 14p0 1lb0 14p0 1lb0|64e4\",\"America/Indiana/Knox|CST CDT CWT CPT EST|60 50 50 50 50|0101023010101010101010101010101010101040101010101010101010101010101010101010101010101010141010101010101010101010101010101010101010101010101010101010101010|-261s0 1nX0 11B0 1nX0 SgN0 8x30 iw0 3NB0 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 1fz0 1cN0 1cL0 1cN0 11z0 1o10 11z0 1o10 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 3Cn0 8wp0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 z8o0 1o00 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0\",\"America/Indiana/Marengo|CST CDT CWT CPT EST EDT|60 50 50 50 50 40|0101023010101010101010104545454545414545454545454545454545454545454545454545454545454545454545454545454|-261s0 1nX0 11B0 1nX0 SgN0 8x30 iw0 dyN0 11z0 6fd0 11z0 1o10 11z0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 jrz0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1VA0 LA0 1BX0 1e6p0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0\",\"America/Indiana/Petersburg|CST CDT CWT CPT EST EDT|60 50 50 50 50 40|01010230101010101010101010104010101010101010101010141014545454545454545454545454545454545454545454545454545454545454|-261s0 1nX0 11B0 1nX0 SgN0 8x30 iw0 njX0 WN0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 3Fb0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 19co0 1o00 Rd0 1zb0 Oo0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0\",\"America/Indiana/Tell_City|CST CDT CWT CPT EST EDT|60 50 50 50 50 40|01010230101010101010101010101010454541010101010101010101010101010101010101010101010101010101010101010|-261s0 1nX0 11B0 1nX0 SgN0 8x30 iw0 1o10 11z0 g0p0 11z0 1o10 11z0 1qL0 WN0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 1fz0 1cN0 WL0 1qN0 1cL0 1cN0 1cL0 1cN0 caL0 1cL0 1cN0 1cL0 1qhd0 1o00 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0\",\"America/Indiana/Vevay|CST CDT CWT CPT EST EDT|60 50 50 50 50 40|010102304545454545454545454545454545454545454545454545454545454545454545454545454|-261s0 1nX0 11B0 1nX0 SgN0 8x30 iw0 kPB0 Awn0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1lnd0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0\",\"America/Indiana/Vincennes|CST CDT CWT CPT EST EDT|60 50 50 50 50 40|01010230101010101010101010101010454541014545454545454545454545454545454545454545454545454545454545454|-261s0 1nX0 11B0 1nX0 SgN0 8x30 iw0 1o10 11z0 g0p0 11z0 1o10 11z0 1qL0 WN0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 1fz0 1cN0 WL0 1qN0 1cL0 1cN0 1cL0 1cN0 caL0 1cL0 1cN0 1cL0 1qhd0 1o00 Rd0 1zb0 Oo0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0\",\"America/Indiana/Winamac|CST CDT CWT CPT EST EDT|60 50 50 50 50 40|01010230101010101010101010101010101010454541054545454545454545454545454545454545454545454545454545454545454|-261s0 1nX0 11B0 1nX0 SgN0 8x30 iw0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 1fz0 1cN0 1cL0 1cN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 jrz0 1cL0 1cN0 1cL0 1qhd0 1o00 Rd0 1za0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0\",\"America/Inuvik|-00 PST PDDT MST MDT|0 80 60 70 60|0121343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343|-FnA0 tWU0 1fA0 wPe0 2pz0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|35e2\",\"America/Iqaluit|-00 EWT EPT EST EDDT EDT CST CDT|0 40 40 50 30 40 60 50|01234353535353535353535353535353535353535353567353535353535353535353535353535353535353535353535353535353535353535353535353|-16K00 7nX0 iv0 LCL0 1fA0 zgO0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11C0 1nX0 11A0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|67e2\",\"America/Jamaica|KMT EST EDT|57.b 50 40|0121212121212121212121|-2l1uQ.N 2uM1Q.N 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0|94e4\",\"America/Juneau|PST PWT PPT PDT YDT YST AKST AKDT|80 70 70 70 80 90 90 80|01203030303030303030303030403030356767676767676767676767676767676767676767676767676767676767676767676767676767676767676767676767676767676767676|-17T20 8x10 iy0 Vo10 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cM0 1cM0 1cL0 1cN0 1fz0 1a10 1fz0 co0 10q0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|33e3\",\"America/Kentucky/Louisville|CST CDT CWT CPT EST EDT|60 50 50 50 50 40|0101010102301010101010101010101010101454545454545414545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454|-261s0 1nX0 11B0 1nX0 3Fd0 Nb0 LPd0 11z0 RB0 8x30 iw0 Bb0 10N0 2bB0 8in0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 xz0 gso0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1VA0 LA0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0\",\"America/Kentucky/Monticello|CST CDT CWT CPT EST EDT|60 50 50 50 50 40|0101023010101010101010101010101010101010101010101010101010101010101010101454545454545454545454545454545454545454545454545454545454545454545454545454|-261s0 1nX0 11B0 1nX0 SgN0 8x30 iw0 SWp0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11A0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0\",\"America/La_Paz|CMT BOST BOT|4w.A 3w.A 40|012|-1x37r.o 13b0|19e5\",\"America/Lima|LMT PET PEST|58.A 50 40|0121212121212121|-2tyGP.o 1bDzP.o zX0 1aN0 1cL0 1cN0 1cL0 1PrB0 zX0 1O10 zX0 6Gp0 zX0 98p0 zX0|11e6\",\"America/Los_Angeles|PST PDT PWT PPT|80 70 70 70|010102301010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-261q0 1nX0 11B0 1nX0 SgN0 8x10 iy0 5Wp0 1Vb0 3dB0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|15e6\",\"America/Maceio|LMT BRT BRST|2m.Q 30 20|012121212121212121212121212121212121212121|-2glxB.8 HdLB.8 1cc0 1e10 1bX0 Ezd0 So0 1vA0 Mn0 1BB0 ML0 1BB0 zX0 qe10 xb0 2ep0 nz0 1C10 zX0 1C10 LX0 1C10 Mn0 H210 Rb0 1tB0 IL0 1Fd0 FX0 1EN0 FX0 1HB0 Lz0 dMN0 Lz0 8Q10 WL0 1tB0 5z0 2mN0 On0|93e4\",\"America/Managua|MMT CST EST CDT|5J.c 60 50 50|0121313121213131|-1quie.M 1yAMe.M 4mn0 9Up0 Dz0 1K10 Dz0 s3F0 1KH0 DB0 9In0 k8p0 19X0 1o30 11y0|22e5\",\"America/Manaus|LMT AMT AMST|40.4 40 30|01212121212121212121212121212121|-2glvX.U HdKX.U 1cc0 1e10 1bX0 Ezd0 So0 1vA0 Mn0 1BB0 ML0 1BB0 zX0 qe10 xb0 2ep0 nz0 1C10 zX0 1C10 LX0 1C10 Mn0 H210 Rb0 1tB0 IL0 1Fd0 FX0 dPB0 On0|19e5\",\"America/Martinique|FFMT AST ADT|44.k 40 30|0121|-2mPTT.E 2LPbT.E 19X0|39e4\",\"America/Matamoros|LMT CST CDT|6E 60 50|0121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-1UQG0 2FjC0 1nX0 i6p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 1fB0 WL0 1fB0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 U10 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|45e4\",\"America/Mazatlan|LMT MST CST PST MDT|75.E 70 60 80 60|0121212131414141414141414141414141414141414141414141414141414141414141414141414141414141414141|-1UQF0 deL0 8lc0 17c0 10M0 1dd0 otX0 gmN0 P2N0 13Vd0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 1fB0 WL0 1fB0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0|44e4\",\"America/Menominee|CST CDT CWT CPT EST|60 50 50 50 50|01010230101041010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-261s0 1nX0 11B0 1nX0 SgN0 8x30 iw0 1o10 11z0 LCN0 1fz0 6410 9Jb0 1cM0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|85e2\",\"America/Merida|LMT CST EST CDT|5W.s 60 50 50|0121313131313131313131313131313131313131313131313131313131313131313131313131313131313131|-1UQG0 2q2o0 2hz0 wu30 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 1fB0 WL0 1fB0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0|11e5\",\"America/Metlakatla|PST PWT PPT PDT AKST AKDT|80 70 70 70 90 80|0120303030303030303030303030303030454545454545454545454545454545454545454545454|-17T20 8x10 iy0 Vo10 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1hU10 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|14e2\",\"America/Mexico_City|LMT MST CST CDT CWT|6A.A 70 60 50 50|012121232324232323232323232323232323232323232323232323232323232323232323232323232323232323232323232|-1UQF0 deL0 8lc0 17c0 10M0 1dd0 gEn0 TX0 3xd0 Jb0 6zB0 SL0 e5d0 17b0 1Pff0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 1fB0 WL0 1fB0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0|20e6\",\"America/Miquelon|LMT AST PMST PMDT|3I.E 40 30 20|012323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232|-2mKkf.k 2LTAf.k gQ10 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|61e2\",\"America/Moncton|EST AST ADT AWT APT|50 40 30 30 30|012121212121212121212134121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-2IsH0 CwN0 1in0 zAo0 An0 1Nd0 An0 1Nd0 An0 1Nd0 An0 1Nd0 An0 1Nd0 An0 1K10 Lz0 1zB0 NX0 1u10 Wn0 S20 8x50 iu0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 11z0 1o10 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 3Cp0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14n1 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 ReX 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|64e3\",\"America/Monterrey|LMT CST CDT|6F.g 60 50|0121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-1UQG0 2FjC0 1nX0 i6p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 1fB0 WL0 1fB0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0|41e5\",\"America/Montevideo|MMT UYT UYHST UYST UYT UYHST|3I.I 3u 30 20 30 2u|012121212121212121212121213434343434345454543453434343434343434343434343434343434343434|-20UIf.g 8jzJ.g 1cLu 1dcu 1cLu 1dcu 1cLu ircu 11zu 1o0u 11zu 1o0u 11zu 1qMu WLu 1qMu WLu 1qMu WLu 1qMu 11zu 1o0u 11zu NAu 11bu 2iMu zWu Dq10 19X0 pd0 jz0 cm10 19X0 1fB0 1on0 11d0 1oL0 1nB0 1fzu 1aou 1fzu 1aou 1fzu 3nAu Jb0 3MN0 1SLu 4jzu 2PB0 Lb0 3Dd0 1pb0 ixd0 An0 1MN0 An0 1wp0 On0 1wp0 Rb0 1zd0 On0 1wp0 Rb0 s8p0 1fB0 1ip0 11z0 1ld0 14n0 1o10 11z0 1o10 11z0 1o10 14n0 1ld0 14n0 1ld0 14n0 1o10 11z0 1o10 11z0 1o10 11z0|17e5\",\"America/Toronto|EST EDT EWT EPT|50 40 40 40|01010101010101010101010101010101010101010101012301010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-25TR0 1in0 11Wu 1nzu 1fD0 WJ0 1wr0 Nb0 1Ap0 On0 1zd0 On0 1wp0 TX0 1tB0 TX0 1tB0 TX0 1tB0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 4kM0 8x40 iv0 1o10 11z0 1nX0 11z0 1o10 11z0 1o10 1qL0 11D0 1nX0 11B0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 11z0 1o10 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|65e5\",\"America/Nassau|LMT EST EDT|59.u 50 40|012121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-2kNuO.u 26XdO.u 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|24e4\",\"America/New_York|EST EDT EWT EPT|50 40 40 40|01010101010101010101010101010101010101010101010102301010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-261t0 1nX0 11B0 1nX0 11B0 1qL0 1a10 11z0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 11z0 1o10 11z0 RB0 8x40 iv0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|21e6\",\"America/Nipigon|EST EDT EWT EPT|50 40 40 40|010123010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-25TR0 1in0 Rnb0 3je0 8x40 iv0 19yN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|16e2\",\"America/Nome|NST NWT NPT BST BDT YST AKST AKDT|b0 a0 a0 b0 a0 90 90 80|012034343434343434343434343434343456767676767676767676767676767676767676767676767676767676767676767676767676767676767676767676767676767676767676|-17SX0 8wW0 iB0 Qlb0 52O0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 cl0 10q0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|38e2\",\"America/Noronha|LMT FNT FNST|29.E 20 10|0121212121212121212121212121212121212121|-2glxO.k HdKO.k 1cc0 1e10 1bX0 Ezd0 So0 1vA0 Mn0 1BB0 ML0 1BB0 zX0 qe10 xb0 2ep0 nz0 1C10 zX0 1C10 LX0 1C10 Mn0 H210 Rb0 1tB0 IL0 1Fd0 FX0 1EN0 FX0 1HB0 Lz0 nsp0 WL0 1tB0 2L0 2pB0 On0|30e2\",\"America/North_Dakota/Beulah|MST MDT MWT MPT CST CDT|70 60 60 60 60 50|010102301010101010101010101010101010101010101010101010101010101010101010101010101010101010101014545454545454545454545454545454545454545454545454545454|-261r0 1nX0 11B0 1nX0 SgN0 8x20 ix0 QwN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Oo0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0\",\"America/North_Dakota/Center|MST MDT MWT MPT CST CDT|70 60 60 60 60 50|010102301010101010101010101010101010101010101010101010101014545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454|-261r0 1nX0 11B0 1nX0 SgN0 8x20 ix0 QwN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14o0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0\",\"America/North_Dakota/New_Salem|MST MDT MWT MPT CST CDT|70 60 60 60 60 50|010102301010101010101010101010101010101010101010101010101010101010101010101010101454545454545454545454545454545454545454545454545454545454545454545454|-261r0 1nX0 11B0 1nX0 SgN0 8x20 ix0 QwN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14o0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0\",\"America/Ojinaga|LMT MST CST CDT MDT|6V.E 70 60 50 60|0121212323241414141414141414141414141414141414141414141414141414141414141414141414141414141|-1UQF0 deL0 8lc0 17c0 10M0 1dd0 2zQN0 1lb0 14p0 1lb0 14q0 1lb0 14p0 1nX0 11B0 1nX0 1fB0 WL0 1fB0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 U10 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|23e3\",\"America/Pangnirtung|-00 AST AWT APT ADDT ADT EDT EST CST CDT|0 40 30 30 20 30 40 50 60 50|012314151515151515151515151515151515167676767689767676767676767676767676767676767676767676767676767676767676767676767676767|-1XiM0 PnG0 8x50 iu0 LCL0 1fA0 zgO0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1o00 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11C0 1nX0 11A0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|14e2\",\"America/Paramaribo|LMT PMT PMT NEGT SRT SRT|3E.E 3E.Q 3E.A 3u 3u 30|012345|-2nDUj.k Wqo0.c qanX.I 1dmLN.o lzc0|24e4\",\"America/Phoenix|MST MDT MWT|70 60 60|01010202010|-261r0 1nX0 11B0 1nX0 SgN0 4Al1 Ap0 1db0 SWqX 1cL0|42e5\",\"America/Port-au-Prince|PPMT EST EDT|4N 50 40|01212121212121212121212121212121212121212121|-28RHb 2FnMb 19X0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14q0 1o00 11A0 1o00 11A0 1o00 14o0 1lc0 14o0 1lc0 14o0 1o00 11A0 1o00 11A0 1o00 14o0 1lc0 14o0 1lc0 i6n0 1nX0 11B0 1nX0 d430 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|23e5\",\"America/Rio_Branco|LMT ACT ACST AMT|4v.c 50 40 40|01212121212121212121212121212131|-2glvs.M HdLs.M 1cc0 1e10 1bX0 Ezd0 So0 1vA0 Mn0 1BB0 ML0 1BB0 zX0 qe10 xb0 2ep0 nz0 1C10 zX0 1C10 LX0 1C10 Mn0 H210 Rb0 1tB0 IL0 1Fd0 FX0 NBd0 d5X0|31e4\",\"America/Porto_Velho|LMT AMT AMST|4f.A 40 30|012121212121212121212121212121|-2glvI.o HdKI.o 1cc0 1e10 1bX0 Ezd0 So0 1vA0 Mn0 1BB0 ML0 1BB0 zX0 qe10 xb0 2ep0 nz0 1C10 zX0 1C10 LX0 1C10 Mn0 H210 Rb0 1tB0 IL0 1Fd0 FX0|37e4\",\"America/Puerto_Rico|AST AWT APT|40 30 30|0120|-17lU0 7XT0 iu0|24e5\",\"America/Rainy_River|CST CDT CWT CPT|60 50 50 50|010123010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-25TQ0 1in0 Rnb0 3je0 8x30 iw0 19yN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|842\",\"America/Rankin_Inlet|-00 CST CDDT CDT EST|0 60 40 50 50|012131313131313131313131313131313131313131313431313131313131313131313131313131313131313131313131313131313131313131313131|-vDc0 keu0 1fA0 zgO0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|26e2\",\"America/Recife|LMT BRT BRST|2j.A 30 20|0121212121212121212121212121212121212121|-2glxE.o HdLE.o 1cc0 1e10 1bX0 Ezd0 So0 1vA0 Mn0 1BB0 ML0 1BB0 zX0 qe10 xb0 2ep0 nz0 1C10 zX0 1C10 LX0 1C10 Mn0 H210 Rb0 1tB0 IL0 1Fd0 FX0 1EN0 FX0 1HB0 Lz0 nsp0 WL0 1tB0 2L0 2pB0 On0|33e5\",\"America/Regina|LMT MST MDT MWT MPT CST|6W.A 70 60 60 60 60|012121212121212121212121341212121212121212121212121215|-2AD51.o uHe1.o 1in0 s2L0 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 11z0 66N0 1cL0 1cN0 19X0 1fB0 1cL0 1fB0 1cL0 1cN0 1cL0 M30 8x20 ix0 1ip0 1cL0 1ip0 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 11z0 1o10 11z0 3NB0 1cL0 1cN0|19e4\",\"America/Resolute|-00 CST CDDT CDT EST|0 60 40 50 50|012131313131313131313131313131313131313131313431313131313431313131313131313131313131313131313131313131313131313131313131|-SnA0 GWS0 1fA0 zgO0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|229\",\"America/Santarem|LMT AMT AMST BRT|3C.M 40 30 30|0121212121212121212121212121213|-2glwl.c HdLl.c 1cc0 1e10 1bX0 Ezd0 So0 1vA0 Mn0 1BB0 ML0 1BB0 zX0 qe10 xb0 2ep0 nz0 1C10 zX0 1C10 LX0 1C10 Mn0 H210 Rb0 1tB0 IL0 1Fd0 FX0 NBd0|21e4\",\"America/Santiago|SMT CLT CLT CLST CLST|4G.K 50 40 40 30|010203131313131212421242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424|-2q2jh.e fJAh.e 5knG.K 1Vzh.e jRAG.K 1pbh.e 11d0 1oL0 11d0 1oL0 11d0 1oL0 11d0 1pb0 11d0 nHX0 op0 9Bz0 jb0 1oN0 ko0 Qeo0 WL0 1zd0 On0 1ip0 11z0 1o10 11z0 1qN0 WL0 1ld0 14n0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 WL0 1qN0 1cL0 1cN0 11z0 1o10 11z0 1qN0 WL0 1fB0 19X0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 17b0 1ip0 11z0 1ip0 1fz0 1fB0 11z0 1qN0 WL0 1qN0 WL0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 17b0 1ip0 11z0 1o10 19X0 1fB0 1nX0 G10 1EL0 Op0 1zb0 Rd0 1wn0 Rd0 46n0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Dd0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Dd0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Dd0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0|62e5\",\"America/Santo_Domingo|SDMT EST EDT EHDT AST|4E 50 40 4u 40|01213131313131414|-1ttjk 1lJMk Mn0 6sp0 Lbu 1Cou yLu 1RAu wLu 1QMu xzu 1Q0u xXu 1PAu 13jB0 e00|29e5\",\"America/Sao_Paulo|LMT BRT BRST|36.s 30 20|012121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212|-2glwR.w HdKR.w 1cc0 1e10 1bX0 Ezd0 So0 1vA0 Mn0 1BB0 ML0 1BB0 zX0 pTd0 PX0 2ep0 nz0 1C10 zX0 1C10 LX0 1C10 Mn0 H210 Rb0 1tB0 IL0 1Fd0 FX0 1EN0 FX0 1HB0 Lz0 1EN0 Lz0 1C10 IL0 1HB0 Db0 1HB0 On0 1zd0 On0 1zd0 Lz0 1zd0 Rb0 1wN0 Wn0 1tB0 Rb0 1tB0 WL0 1tB0 Rb0 1zd0 On0 1HB0 FX0 1C10 Lz0 1Ip0 HX0 1zd0 On0 1HB0 IL0 1wp0 On0 1C10 Lz0 1C10 On0 1zd0 On0 1zd0 Rb0 1zd0 Lz0 1C10 Lz0 1C10 On0 1zd0 On0 1zd0 On0 1zd0 On0 1C10 Lz0 1C10 Lz0 1C10 On0 1zd0 On0 1zd0 Rb0 1wp0 On0 1C10 Lz0 1C10 On0 1zd0 On0 1zd0 On0 1zd0 On0 1C10 Lz0 1C10 Lz0 1C10 Lz0 1C10 On0 1zd0 Rb0 1wp0 On0 1C10 Lz0 1C10 On0 1zd0|20e6\",\"America/Scoresbysund|LMT CGT CGST EGST EGT|1r.Q 20 10 0 10|0121343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434|-2a5Ww.8 2z5ew.8 1a00 1cK0 1cL0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|452\",\"America/Sitka|PST PWT PPT PDT YST AKST AKDT|80 70 70 70 90 90 80|01203030303030303030303030303030345656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565|-17T20 8x10 iy0 Vo10 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 co0 10q0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|90e2\",\"America/St_Johns|NST NDT NST NDT NWT NPT NDDT|3u.Q 2u.Q 3u 2u 2u 2u 1u|01010101010101010101010101010101010102323232323232324523232323232323232323232323232323232323232323232323232323232323232323232323232323232326232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232|-28oit.8 14L0 1nB0 1in0 1gm0 Dz0 1JB0 1cL0 1cN0 1cL0 1fB0 19X0 1fB0 19X0 1fB0 19X0 1fB0 19X0 1fB0 1cL0 1cN0 1cL0 1fB0 19X0 1fB0 19X0 1fB0 19X0 1fB0 19X0 1fB0 1cL0 1fB0 19X0 1fB0 19X0 10O0 eKX.8 19X0 1iq0 WL0 1qN0 WL0 1qN0 WL0 1tB0 TX0 1tB0 WL0 1qN0 WL0 1qN0 7UHu itu 1tB0 WL0 1qN0 WL0 1qN0 WL0 1qN0 WL0 1tB0 WL0 1ld0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14n1 1lb0 14p0 1nW0 11C0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zcX Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|11e4\",\"America/Swift_Current|LMT MST MDT MWT MPT CST|7b.k 70 60 60 60 60|012134121212121212121215|-2AD4M.E uHdM.E 1in0 UGp0 8x20 ix0 1o10 17b0 1ip0 11z0 1o10 11z0 1o10 11z0 isN0 1cL0 3Cp0 1cL0 1cN0 11z0 1qN0 WL0 pMp0|16e3\",\"America/Tegucigalpa|LMT CST CDT|5M.Q 60 50|01212121|-1WGGb.8 2ETcb.8 WL0 1qN0 WL0 GRd0 AL0|11e5\",\"America/Thule|LMT AST ADT|4z.8 40 30|012121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-2a5To.Q 31NBo.Q 1cL0 1cN0 1cL0 1fB0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|656\",\"America/Thunder_Bay|CST EST EWT EPT EDT|60 50 40 40 40|0123141414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141|-2q5S0 1iaN0 8x40 iv0 XNB0 1cL0 1cN0 1fz0 1cN0 1cL0 3Cp0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|11e4\",\"America/Vancouver|PST PDT PWT PPT|80 70 70 70|0102301010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-25TO0 1in0 UGp0 8x10 iy0 1o10 17b0 1ip0 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|23e5\",\"America/Whitehorse|YST YDT YWT YPT YDDT PST PDT|90 80 80 80 70 80 70|0101023040565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565|-25TN0 1in0 1o10 13V0 Ser0 8x00 iz0 LCL0 1fA0 3NA0 vrd0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|23e3\",\"America/Winnipeg|CST CDT CWT CPT|60 50 50 50|010101023010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-2aIi0 WL0 3ND0 1in0 Jap0 Rb0 aCN0 8x30 iw0 1tB0 11z0 1ip0 11z0 1o10 11z0 1o10 11z0 1rd0 10L0 1op0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 1cL0 1cN0 11z0 6i10 WL0 6i10 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1a00 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1a00 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 14o0 1lc0 14o0 1o00 11A0 1o00 11A0 1o00 14o0 1lc0 14o0 1lc0 14o0 1o00 11A0 1o00 11A0 1o00 14o0 1lc0 14o0 1lc0 14o0 1lc0 14o0 1o00 11A0 1o00 11A0 1o00 14o0 1lc0 14o0 1lc0 14o0 1o00 11A0 1o00 11A0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|66e4\",\"America/Yakutat|YST YWT YPT YDT AKST AKDT|90 80 80 80 90 80|01203030303030303030303030303030304545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454|-17T10 8x00 iz0 Vo10 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 cn0 10q0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|642\",\"America/Yellowknife|-00 MST MWT MPT MDDT MDT|0 70 60 60 50 60|012314151515151515151515151515151515151515151515151515151515151515151515151515151515151515151515151515151515151515151515151|-1pdA0 hix0 8x20 ix0 LCL0 1fA0 zgO0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|19e3\",\"Antarctica/Casey|-00 AWST CAST|0 -80 -b0|012121|-2q00 1DjS0 T90 40P0 KL0|10\",\"Antarctica/Davis|-00 DAVT DAVT|0 -70 -50|01012121|-vyo0 iXt0 alj0 1D7v0 VB0 3Wn0 KN0|70\",\"Antarctica/DumontDUrville|-00 PMT DDUT|0 -a0 -a0|0102|-U0o0 cfq0 bFm0|80\",\"Antarctica/Macquarie|AEST AEDT -00 MIST|-a0 -b0 0 -b0|0102010101010101010101010101010101010101010101010101010101010101010101010101010101010101013|-29E80 19X0 4SL0 1ayy0 Lvs0 1cM0 1o00 Rc0 1wo0 Rc0 1wo0 U00 1wo0 LA0 1C00 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 11A0 1qM0 WM0 1qM0 Oo0 1zc0 Oo0 1zc0 Oo0 1wo0 WM0 1tA0 WM0 1tA0 U00 1tA0 U00 1tA0 11A0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 11A0 1o00 1io0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1cM0 1a00 1io0 1cM0 1cM0 1cM0 1cM0 1cM0|1\",\"Antarctica/Mawson|-00 MAWT MAWT|0 -60 -50|012|-CEo0 2fyk0|60\",\"Pacific/Auckland|NZMT NZST NZST NZDT|-bu -cu -c0 -d0|01020202020202020202020202023232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323|-1GCVu Lz0 1tB0 11zu 1o0u 11zu 1o0u 11zu 1o0u 14nu 1lcu 14nu 1lcu 1lbu 11Au 1nXu 11Au 1nXu 11Au 1nXu 11Au 1nXu 11Au 1qLu WMu 1qLu 11Au 1n1bu IM0 1C00 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1qM0 14o0 1lc0 14o0 1lc0 14o0 1lc0 17c0 1io0 17c0 1io0 17c0 1io0 17c0 1lc0 14o0 1lc0 14o0 1lc0 17c0 1io0 17c0 1io0 17c0 1lc0 14o0 1lc0 14o0 1lc0 17c0 1io0 17c0 1io0 17c0 1io0 17c0 1io0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1io0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00|14e5\",\"Antarctica/Palmer|-00 ARST ART ART ARST CLT CLST|0 30 40 30 20 40 30|0121212121234356565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656|-cao0 nD0 1vd0 SL0 1vd0 17z0 1cN0 1fz0 1cN0 1cL0 1cN0 asn0 Db0 jsN0 14N0 11z0 1o10 11z0 1qN0 WL0 1qN0 WL0 1qN0 1cL0 1cN0 11z0 1o10 11z0 1qN0 WL0 1fB0 19X0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 17b0 1ip0 11z0 1ip0 1fz0 1fB0 11z0 1qN0 WL0 1qN0 WL0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 17b0 1ip0 11z0 1o10 19X0 1fB0 1nX0 G10 1EL0 Op0 1zb0 Rd0 1wn0 Rd0 46n0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Dd0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Dd0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Dd0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0|40\",\"Antarctica/Rothera|-00 ROTT|0 30|01|gOo0|130\",\"Antarctica/Syowa|-00 SYOT|0 -30|01|-vs00|20\",\"Antarctica/Troll|-00 UTC CEST|0 0 -20|01212121212121212121212121212121212121212121212121212121212121212121|1puo0 hd0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|40\",\"Antarctica/Vostok|-00 VOST|0 -60|01|-tjA0|25\",\"Europe/Oslo|CET CEST|-10 -20|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-2awM0 Qm0 W6o0 5pf0 WM0 1fA0 1cM0 1cM0 1cM0 1cM0 wJc0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1qM0 WM0 zpc0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|62e4\",\"Asia/Riyadh|LMT AST|-36.Q -30|01|-TvD6.Q|57e5\",\"Asia/Almaty|LMT +05 +06 +07|-57.M -50 -60 -70|012323232323232323232321232323232323232323232323232|-1Pc57.M eUo7.M 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0|15e5\",\"Asia/Amman|LMT EET EEST|-2n.I -20 -30|0121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-1yW2n.I 1HiMn.I KL0 1oN0 11b0 1oN0 11b0 1pd0 1dz0 1cp0 11b0 1op0 11b0 fO10 1db0 1e10 1cL0 1cN0 1cL0 1cN0 1fz0 1pd0 10n0 1ld0 14n0 1hB0 15b0 1ip0 19X0 1cN0 1cL0 1cN0 17b0 1ld0 14o0 1lc0 17c0 1io0 17c0 1io0 17c0 1So0 y00 1fc0 1dc0 1co0 1dc0 1cM0 1cM0 1cM0 1o00 11A0 1lc0 17c0 1cM0 1cM0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 4bX0 Dd0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0|25e5\",\"Asia/Anadyr|LMT ANAT ANAT ANAST ANAST ANAST ANAT|-bN.U -c0 -d0 -e0 -d0 -c0 -b0|01232414141414141414141561414141414141414141414141414141414141561|-1PcbN.U eUnN.U 23CL0 1db0 1cN0 1dc0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cN0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qN0 WM0|13e3\",\"Asia/Aqtau|LMT +04 +05 +06|-3l.4 -40 -50 -60|012323232323232323232123232312121212121212121212|-1Pc3l.4 eUnl.4 24PX0 2pX0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cN0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0|15e4\",\"Asia/Aqtobe|LMT +04 +05 +06|-3M.E -40 -50 -60|0123232323232323232321232323232323232323232323232|-1Pc3M.E eUnM.E 23CL0 3Db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0|27e4\",\"Asia/Ashgabat|LMT ASHT ASHT ASHST ASHST TMT TMT|-3R.w -40 -50 -60 -50 -40 -50|012323232323232323232324156|-1Pc3R.w eUnR.w 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cN0 ba0 xC0|41e4\",\"Asia/Baghdad|BMT AST ADT|-2V.A -30 -40|012121212121212121212121212121212121212121212121212121|-26BeV.A 2ACnV.A 11b0 1cp0 1dz0 1dd0 1db0 1cN0 1cp0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1de0 1dc0 1dc0 1dc0 1cM0 1dc0 1cM0 1dc0 1cM0 1dc0 1dc0 1dc0 1cM0 1dc0 1cM0 1dc0 1cM0 1dc0 1dc0 1dc0 1cM0 1dc0 1cM0 1dc0 1cM0 1dc0 1dc0 1dc0 1cM0 1dc0 1cM0 1dc0 1cM0 1dc0|66e5\",\"Asia/Qatar|LMT GST AST|-3q.8 -40 -30|012|-21Jfq.8 27BXq.8|96e4\",\"Asia/Baku|LMT BAKT BAKT BAKST BAKST AZST AZT AZT AZST|-3j.o -30 -40 -50 -40 -40 -30 -40 -50|01232323232323232323232456578787878787878787878787878787878787878787|-1Pc3j.o 1jUoj.o WCL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 10K0 c30 1cM0 1cM0 8wq0 1o00 11z0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00|27e5\",\"Asia/Bangkok|BMT ICT|-6G.4 -70|01|-218SG.4|15e6\",\"Asia/Barnaul|LMT +06 +07 +08|-5z -60 -70 -80|0123232323232323232323212323232321212121212121212121212121212121212|-21S5z pCnz 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 p90 LE0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0 3rd0\",\"Asia/Beirut|EET EEST|-20 -30|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-21aq0 1on0 1410 1db0 19B0 1in0 1ip0 WL0 1lQp0 11b0 1oN0 11b0 1oN0 11b0 1pd0 11b0 1oN0 11b0 q6N0 En0 1oN0 11b0 1oN0 11b0 1oN0 11b0 1pd0 11b0 1oN0 11b0 1op0 11b0 dA10 17b0 1iN0 17b0 1iN0 17b0 1iN0 17b0 1vB0 SL0 1mp0 13z0 1iN0 17b0 1iN0 17b0 1jd0 12n0 1a10 1cL0 1cN0 1cL0 1cN0 1cL0 1fB0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0|22e5\",\"Asia/Bishkek|LMT FRUT FRUT FRUST FRUST KGT KGST KGT|-4W.o -50 -60 -70 -60 -50 -60 -60|01232323232323232323232456565656565656565656565656567|-1Pc4W.o eUnW.o 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 11c0 1tX0 17b0 1ip0 17b0 1ip0 17b0 1ip0 17b0 1ip0 19X0 1cPu 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 T8u|87e4\",\"Asia/Brunei|LMT BNT BNT|-7D.E -7u -80|012|-1KITD.E gDc9.E|42e4\",\"Asia/Kolkata|HMT BURT IST IST|-5R.k -6u -5u -6u|01232|-18LFR.k 1unn.k HB0 7zX0|15e6\",\"Asia/Chita|LMT YAKT YAKT YAKST YAKST YAKT IRKT|-7x.Q -80 -90 -a0 -90 -a0 -80|0123232323232323232323241232323232323232323232323232323232323232562|-21Q7x.Q pAnx.Q 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cN0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0 3re0|33e4\",\"Asia/Choibalsan|LMT ULAT ULAT CHOST CHOT CHOT CHOST|-7C -70 -80 -a0 -90 -80 -90|0123434343434343434343434343434343434343434343456565656565656565656565656565656565656565656565|-2APHC 2UkoC cKn0 1da0 1dd0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1fB0 1cL0 1cN0 1cL0 1cN0 1cL0 6hD0 11z0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 3Db0 h1f0 1cJ0 1cP0 1cJ0 1cP0 1fx0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1fx0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1fx0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1fx0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0|38e3\",\"Asia/Shanghai|CST CDT|-80 -90|01010101010101010|-1c1I0 LX0 16p0 1jz0 1Myp0 Rb0 1o10 11z0 1o10 11z0 1qN0 11z0 1o10 11z0 1o10 11z0|23e6\",\"Asia/Colombo|MMT IST IHST IST LKT LKT|-5j.w -5u -60 -6u -6u -60|01231451|-2zOtj.w 1rFbN.w 1zzu 7Apu 23dz0 11zu n3cu|22e5\",\"Asia/Dhaka|HMT BURT IST DACT BDT BDST|-5R.k -6u -5u -60 -60 -70|01213454|-18LFR.k 1unn.k HB0 m6n0 LqMu 1x6n0 1i00|16e6\",\"Asia/Damascus|LMT EET EEST|-2p.c -20 -30|01212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-21Jep.c Hep.c 17b0 1ip0 17b0 1ip0 17b0 1ip0 19X0 1xRB0 11X0 1oN0 10L0 1pB0 11b0 1oN0 10L0 1mp0 13X0 1oN0 11b0 1pd0 11b0 1oN0 11b0 1oN0 11b0 1oN0 11b0 1pd0 11b0 1oN0 11b0 1oN0 11b0 1oN0 11b0 1pd0 11b0 1oN0 Nb0 1AN0 Nb0 bcp0 19X0 1gp0 19X0 3ld0 1xX0 Vd0 1Bz0 Sp0 1vX0 10p0 1dz0 1cN0 1cL0 1db0 1db0 1g10 1an0 1ap0 1db0 1fd0 1db0 1cN0 1db0 1dd0 1db0 1cp0 1dz0 1c10 1dX0 1cN0 1db0 1dd0 1db0 1cN0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1db0 1cN0 1db0 1cN0 19z0 1fB0 1qL0 11B0 1on0 Wp0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0|26e5\",\"Asia/Dili|LMT TLT JST TLT WITA|-8m.k -80 -90 -90 -80|012343|-2le8m.k 1dnXm.k 8HA0 1ew00 Xld0|19e4\",\"Asia/Dubai|LMT GST|-3F.c -40|01|-21JfF.c|39e5\",\"Asia/Dushanbe|LMT DUST DUST DUSST DUSST TJT|-4z.c -50 -60 -70 -60 -50|0123232323232323232323245|-1Pc4z.c eUnz.c 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 14N0|76e4\",\"Asia/Gaza|EET EET EEST IST IDT|-20 -30 -30 -20 -30|010101010102020202020202020202023434343434343434343434343430202020202020202020202020202020202020202020202020202020202020202020202020202020202020|-1c2q0 5Rb0 10r0 1px0 10N0 1pz0 16p0 1jB0 16p0 1jx0 pBd0 Vz0 1oN0 11b0 1oO0 10N0 1pz0 10N0 1pb0 10N0 1pb0 10N0 1pb0 10N0 1pz0 10N0 1pb0 10N0 1pb0 11d0 1oL0 dW0 hfB0 Db0 1fB0 Rb0 npB0 11z0 1C10 IL0 1s10 10n0 1o10 WL0 1zd0 On0 1ld0 11z0 1o10 14n0 1o10 14n0 1nd0 12n0 1nd0 Xz0 1q10 12n0 M10 C00 17c0 1io0 17c0 1io0 17c0 1o00 1cL0 1fB0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 17c0 1io0 18N0 1bz0 19z0 1gp0 1610 1iL0 11z0 1o10 14o0 1lA1 SKX 1xd1 MKX 1AN0 1a00 1fA0 1cL0 1cN0 1nX0 1210 1nz0 1220 1ny0 1220 1qm0 1220 1ny0 1220 1ny0 1220 1ny0 1220 1ny0 1220 1ny0 1220 1qm0 1220 1ny0 1220 1ny0 1220 1ny0 1220 1ny0 1220 1qm0 1220 1ny0 1220 1ny0 1220 1ny0 1220 1ny0 1220 1ny0 1220 1qm0 1220 1ny0 1220 1ny0 1220 1ny0|18e5\",\"Asia/Hebron|EET EET EEST IST IDT|-20 -30 -30 -20 -30|01010101010202020202020202020202343434343434343434343434343020202020202020202020202020202020202020202020202020202020202020202020202020202020202020|-1c2q0 5Rb0 10r0 1px0 10N0 1pz0 16p0 1jB0 16p0 1jx0 pBd0 Vz0 1oN0 11b0 1oO0 10N0 1pz0 10N0 1pb0 10N0 1pb0 10N0 1pb0 10N0 1pz0 10N0 1pb0 10N0 1pb0 11d0 1oL0 dW0 hfB0 Db0 1fB0 Rb0 npB0 11z0 1C10 IL0 1s10 10n0 1o10 WL0 1zd0 On0 1ld0 11z0 1o10 14n0 1o10 14n0 1nd0 12n0 1nd0 Xz0 1q10 12n0 M10 C00 17c0 1io0 17c0 1io0 17c0 1o00 1cL0 1fB0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 17c0 1io0 18N0 1bz0 19z0 1gp0 1610 1iL0 12L0 1mN0 14o0 1lc0 Tb0 1xd1 MKX bB0 cn0 1cN0 1a00 1fA0 1cL0 1cN0 1nX0 1210 1nz0 1220 1ny0 1220 1qm0 1220 1ny0 1220 1ny0 1220 1ny0 1220 1ny0 1220 1ny0 1220 1qm0 1220 1ny0 1220 1ny0 1220 1ny0 1220 1ny0 1220 1qm0 1220 1ny0 1220 1ny0 1220 1ny0 1220 1ny0 1220 1ny0 1220 1qm0 1220 1ny0 1220 1ny0 1220 1ny0|25e4\",\"Asia/Ho_Chi_Minh|LMT PLMT ICT IDT JST|-76.E -76.u -70 -80 -90|0123423232|-2yC76.E bK00.a 1h7b6.u 5lz0 18o0 3Oq0 k5b0 aW00 BAM0|90e5\",\"Asia/Hong_Kong|LMT HKT HKST JST|-7A.G -80 -90 -90|0121312121212121212121212121212121212121212121212121212121212121212121|-2CFHA.G 1sEP6.G 1cL0 ylu 93X0 1qQu 1tX0 Rd0 1In0 NB0 1cL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1kL0 14N0 1nX0 U10 1tz0 U10 1wn0 Rd0 1wn0 U10 1tz0 U10 1tz0 U10 1tz0 U10 1wn0 Rd0 1wn0 Rd0 1wn0 U10 1tz0 U10 1tz0 17d0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 s10 1Vz0 1cN0 1cL0 1cN0 1cL0 6fd0 14n0|73e5\",\"Asia/Hovd|LMT HOVT HOVT HOVST|-66.A -60 -70 -80|012323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232|-2APG6.A 2Uko6.A cKn0 1db0 1dd0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1fB0 1cL0 1cN0 1cL0 1cN0 1cL0 6hD0 11z0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 kEp0 1cJ0 1cP0 1cJ0 1cP0 1fx0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1fx0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1fx0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1fx0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0|81e3\",\"Asia/Irkutsk|IMT IRKT IRKT IRKST IRKST IRKT|-6V.5 -70 -80 -90 -80 -90|012323232323232323232324123232323232323232323232323232323232323252|-21zGV.5 pjXV.5 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cN0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0|60e4\",\"Europe/Istanbul|IMT EET EEST TRST TRT|-1U.U -20 -30 -40 -30|012121212121212121212121212121212121212121212121212121234343434342121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-2ogNU.U dzzU.U 11b0 8tB0 1on0 1410 1db0 19B0 1in0 3Rd0 Un0 1oN0 11b0 zSp0 CL0 mN0 1Vz0 1gN0 1pz0 5Rd0 1fz0 1yp0 ML0 1kp0 17b0 1ip0 17b0 1fB0 19X0 1jB0 18L0 1ip0 17z0 qdd0 xX0 3S10 Tz0 dA10 11z0 1o10 11z0 1qN0 11z0 1ze0 11B0 WM0 1qO0 WI0 1nX0 1rB0 10L0 11B0 1in0 17d0 1in0 2pX0 19E0 1fU0 16Q0 1iI0 16Q0 1iI0 1Vd0 pb0 3Kp0 14o0 1df0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cL0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WO0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 Xc0 1qo0 WM0 1qM0 11A0 1o00 1200 1nA0 11A0 1tA0 U00 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|13e6\",\"Asia/Jakarta|BMT JAVT WIB JST WIB WIB|-77.c -7k -7u -90 -80 -70|01232425|-1Q0Tk luM0 mPzO 8vWu 6kpu 4PXu xhcu|31e6\",\"Asia/Jayapura|LMT WIT ACST|-9m.M -90 -9u|0121|-1uu9m.M sMMm.M L4nu|26e4\",\"Asia/Jerusalem|JMT IST IDT IDDT|-2k.E -20 -30 -40|01212121212132121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-26Bek.E SyMk.E 5Rb0 10r0 1px0 10N0 1pz0 16p0 1jB0 16p0 1jx0 3LB0 Em0 or0 1cn0 1dB0 16n0 10O0 1ja0 1tC0 14o0 1cM0 1a00 11A0 1Na0 An0 1MP0 AJ0 1Kp0 LC0 1oo0 Wl0 EQN0 Db0 1fB0 Rb0 npB0 11z0 1C10 IL0 1s10 10n0 1o10 WL0 1zd0 On0 1ld0 11z0 1o10 14n0 1o10 14n0 1nd0 12n0 1nd0 Xz0 1q10 12n0 1hB0 1dX0 1ep0 1aL0 1eN0 17X0 1nf0 11z0 1tB0 19W0 1e10 17b0 1ep0 1gL0 18N0 1fz0 1eN0 17b0 1gq0 1gn0 19d0 1dz0 1c10 17X0 1hB0 1gn0 19d0 1dz0 1c10 17X0 1kp0 1dz0 1c10 1aL0 1eN0 1oL0 10N0 1oL0 10N0 1oL0 10N0 1rz0 W10 1rz0 W10 1rz0 10N0 1oL0 10N0 1oL0 10N0 1rz0 W10 1rz0 W10 1rz0 10N0 1oL0 10N0 1oL0 10N0 1oL0 10N0 1rz0 W10 1rz0 W10 1rz0 10N0 1oL0 10N0 1oL0 10N0 1rz0 W10 1rz0 W10 1rz0 W10 1rz0 10N0 1oL0 10N0 1oL0|81e4\",\"Asia/Kabul|AFT AFT|-40 -4u|01|-10Qs0|46e5\",\"Asia/Kamchatka|LMT PETT PETT PETST PETST|-ay.A -b0 -c0 -d0 -c0|01232323232323232323232412323232323232323232323232323232323232412|-1SLKy.A ivXy.A 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cN0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qN0 WM0|18e4\",\"Asia/Karachi|LMT IST IST KART PKT PKST|-4s.c -5u -6u -50 -50 -60|012134545454|-2xoss.c 1qOKW.c 7zX0 eup0 LqMu 1fy00 1cL0 dK10 11b0 1610 1jX0|24e6\",\"Asia/Urumqi|LMT XJT|-5O.k -60|01|-1GgtO.k|32e5\",\"Asia/Kathmandu|LMT IST NPT|-5F.g -5u -5J|012|-21JhF.g 2EGMb.g|12e5\",\"Asia/Khandyga|LMT YAKT YAKT YAKST YAKST VLAT VLAST VLAT YAKT|-92.d -80 -90 -a0 -90 -a0 -b0 -b0 -a0|01232323232323232323232412323232323232323232323232565656565656565782|-21Q92.d pAp2.d 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cN0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 qK0 yN0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 17V0 7zD0|66e2\",\"Asia/Krasnoyarsk|LMT KRAT KRAT KRAST KRAST KRAT|-6b.q -60 -70 -80 -70 -80|012323232323232323232324123232323232323232323232323232323232323252|-21Hib.q prAb.q 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cN0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0|10e5\",\"Asia/Kuala_Lumpur|SMT MALT MALST MALT MALT JST MYT|-6T.p -70 -7k -7k -7u -90 -80|01234546|-2Bg6T.p 17anT.p 7hXE dM00 17bO 8Fyu 1so1u|71e5\",\"Asia/Kuching|LMT BORT BORT BORTST JST MYT|-7l.k -7u -80 -8k -90 -80|01232323232323232425|-1KITl.k gDbP.k 6ynu AnE 1O0k AnE 1NAk AnE 1NAk AnE 1NAk AnE 1O0k AnE 1NAk AnE pAk 8Fz0 1so10|13e4\",\"Asia/Macau|LMT MOT MOST CST|-7y.k -80 -90 -80|0121212121212121212121212121212121212121213|-2le7y.k 1XO34.k 1wn0 Rd0 1wn0 R9u 1wqu U10 1tz0 TVu 1tz0 17gu 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cJu 1cL0 1cN0 1fz0 1cN0 1cOu 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cJu 1cL0 1cN0 1fz0 1cN0 1cL0 KEp0|57e4\",\"Asia/Magadan|LMT MAGT MAGT MAGST MAGST MAGT|-a3.c -a0 -b0 -c0 -b0 -c0|0123232323232323232323241232323232323232323232323232323232323232512|-1Pca3.c eUo3.c 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cN0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0 3Cq0|95e3\",\"Asia/Makassar|LMT MMT WITA JST|-7V.A -7V.A -80 -90|01232|-21JjV.A vfc0 myLV.A 8ML0|15e5\",\"Asia/Manila|PHT PHST JST|-80 -90 -90|010201010|-1kJI0 AL0 cK10 65X0 mXB0 vX0 VK10 1db0|24e6\",\"Asia/Nicosia|LMT EET EEST|-2d.s -20 -30|01212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-1Vc2d.s 2a3cd.s 1cL0 1qp0 Xz0 19B0 19X0 1fB0 1db0 1cp0 1cL0 1fB0 19X0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1fB0 1cL0 1cN0 1cL0 1cN0 1o30 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|32e4\",\"Asia/Novokuznetsk|LMT +06 +07 +08|-5M.M -60 -70 -80|012323232323232323232321232323232323232323232323232323232323212|-1PctM.M eULM.M 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 2sp0 WM0|55e4\",\"Asia/Novosibirsk|LMT +06 +07 +08|-5v.E -60 -70 -80|0123232323232323232323212323212121212121212121212121212121212121212|-21Qnv.E pAFv.E 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 ml0 Os0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0 4eN0|15e5\",\"Asia/Omsk|LMT OMST OMST OMSST OMSST OMST|-4R.u -50 -60 -70 -60 -70|012323232323232323232324123232323232323232323232323232323232323252|-224sR.u pMLR.u 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cN0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0|12e5\",\"Asia/Oral|LMT +04 +05 +06|-3p.o -40 -50 -60|01232323232323232121212121212121212121212121212|-1Pc3p.o eUnp.o 23CL0 3Db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 2pB0 1cM0 1fA0 1cM0 1cM0 IM0 1EM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0|27e4\",\"Asia/Pontianak|LMT PMT WIB JST WIB WITA WIB|-7h.k -7h.k -7u -90 -80 -80 -70|012324256|-2ua7h.k XE00 munL.k 8Rau 6kpu 4PXu xhcu Wqnu|23e4\",\"Asia/Pyongyang|LMT KST JCST JST KST|-8n -8u -90 -90 -90|012341|-2um8n 97XR 12FXu jdA0 2Onc0|29e5\",\"Asia/Qyzylorda|LMT +04 +05 +06|-4l.Q -40 -50 -60|0123232323232323232323232323232323232323232323|-1Pc4l.Q eUol.Q 23CL0 3Db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 3ao0 1EM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0|73e4\",\"Asia/Rangoon|RMT BURT JST MMT|-6o.E -6u -90 -6u|0123|-21Jio.E SmnS.E 7j9u|48e5\",\"Asia/Sakhalin|LMT JCST JST SAKT SAKST SAKST SAKT|-9u.M -90 -90 -b0 -c0 -b0 -a0|01234343434343434343434356343434343435656565656565656565656565656363|-2AGVu.M 1iaMu.M je00 1qFa0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cN0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o10 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0 3rd0|58e4\",\"Asia/Samarkand|LMT SAMT SAMT SAMST TAST UZST UZT|-4r.R -40 -50 -60 -60 -60 -50|01234323232323232323232356|-1Pc4r.R eUor.R 23CL0 1db0 1cM0 1dc0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 11x0 bf0|36e4\",\"Asia/Seoul|LMT KST JCST JST KST KDT KDT|-8r.Q -8u -90 -90 -90 -9u -a0|01234151515151515146464|-2um8r.Q 97XV.Q 12FXu jjA0 kKo0 2I0u OL0 1FB0 Rb0 1qN0 TX0 1tB0 TX0 1tB0 TX0 1tB0 TX0 2ap0 12FBu 11A0 1o00 11A0|23e6\",\"Asia/Singapore|SMT MALT MALST MALT MALT JST SGT SGT|-6T.p -70 -7k -7k -7u -90 -7u -80|012345467|-2Bg6T.p 17anT.p 7hXE dM00 17bO 8Fyu Mspu DTA0|56e5\",\"Asia/Srednekolymsk|LMT MAGT MAGT MAGST MAGST MAGT SRET|-ae.Q -a0 -b0 -c0 -b0 -c0 -b0|012323232323232323232324123232323232323232323232323232323232323256|-1Pcae.Q eUoe.Q 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cN0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0|35e2\",\"Asia/Taipei|JWST JST CST CDT|-80 -90 -80 -90|01232323232323232323232323232323232323232|-1iw80 joM0 1yo0 Tz0 1ip0 1jX0 1cN0 11b0 1oN0 11b0 1oN0 11b0 1oN0 11b0 10N0 1BX0 10p0 1pz0 10p0 1pz0 10p0 1db0 1dd0 1db0 1cN0 1db0 1cN0 1db0 1cN0 1db0 1BB0 ML0 1Bd0 ML0 uq10 1db0 1cN0 1db0 97B0 AL0|74e5\",\"Asia/Tashkent|LMT TAST TAST TASST TASST UZST UZT|-4B.b -50 -60 -70 -60 -60 -50|01232323232323232323232456|-1Pc4B.b eUnB.b 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 11y0 bf0|23e5\",\"Asia/Tbilisi|TBMT TBIT TBIT TBIST TBIST GEST GET GET GEST|-2X.b -30 -40 -50 -40 -40 -30 -40 -50|0123232323232323232323245656565787878787878787878567|-1Pc2X.b 1jUnX.b WCL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 3y0 19f0 1cK0 1cL0 1cN0 1cL0 1cN0 1cL0 1cM0 1cL0 1fB0 3Nz0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 An0 Os0 WM0|11e5\",\"Asia/Tehran|LMT TMT IRST IRST IRDT IRDT|-3p.I -3p.I -3u -40 -50 -4u|01234325252525252525252525252525252525252525252525252525252525252525252525252525252525252525252525252|-2btDp.I 1d3c0 1huLT.I TXu 1pz0 sN0 vAu 1cL0 1dB0 1en0 pNB0 UL0 1cN0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0 1cN0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0 1cN0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0 1cN0 1dz0 64p0 1dz0 1cN0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0 1cN0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0 1cN0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0 1cN0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0 1cN0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0 1cN0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0 1cN0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0|14e6\",\"Asia/Thimphu|LMT IST BTT|-5W.A -5u -60|012|-Su5W.A 1BGMs.A|79e3\",\"Asia/Tokyo|JCST JST JDT|-90 -90 -a0|0121212121|-1iw90 pKq0 QL0 1lB0 13X0 1zB0 NX0 1zB0 NX0|38e6\",\"Asia/Tomsk|LMT +06 +07 +08|-5D.P -60 -70 -80|0123232323232323232323212323232323232323232323212121212121212121212|-21NhD.P pxzD.P 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 co0 1bB0 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0 3Qp0|10e5\",\"Asia/Ulaanbaatar|LMT ULAT ULAT ULAST|-77.w -70 -80 -90|012323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232|-2APH7.w 2Uko7.w cKn0 1db0 1dd0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1fB0 1cL0 1cN0 1cL0 1cN0 1cL0 6hD0 11z0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 kEp0 1cJ0 1cP0 1cJ0 1cP0 1fx0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1fx0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1fx0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1fx0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0|12e5\",\"Asia/Ust-Nera|LMT YAKT YAKT MAGST MAGT MAGST MAGT MAGT VLAT VLAT|-9w.S -80 -90 -c0 -b0 -b0 -a0 -c0 -b0 -a0|0123434343434343434343456434343434343434343434343434343434343434789|-21Q9w.S pApw.S 23CL0 1d90 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cN0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 17V0 7zD0|65e2\",\"Asia/Vladivostok|LMT VLAT VLAT VLAST VLAST VLAT|-8L.v -90 -a0 -b0 -a0 -b0|012323232323232323232324123232323232323232323232323232323232323252|-1SJIL.v itXL.v 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cN0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0|60e4\",\"Asia/Yakutsk|LMT YAKT YAKT YAKST YAKST YAKT|-8C.W -80 -90 -a0 -90 -a0|012323232323232323232324123232323232323232323232323232323232323252|-21Q8C.W pAoC.W 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cN0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0|28e4\",\"Asia/Yekaterinburg|LMT PMT SVET SVET SVEST SVEST YEKT YEKST YEKT|-42.x -3J.5 -40 -50 -60 -50 -50 -60 -60|0123434343434343434343435267676767676767676767676767676767676767686|-2ag42.x 7mQh.s qBvJ.5 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cN0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0|14e5\",\"Asia/Yerevan|LMT YERT YERT YERST YERST AMST AMT AMT AMST|-2W -30 -40 -50 -40 -40 -30 -40 -50|0123232323232323232323245656565657878787878787878787878787878787|-1Pc2W 1jUnW WCL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1am0 2r0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 3Fb0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0|13e5\",\"Atlantic/Azores|HMT AZOT AZOST AZOMT AZOT AZOST WET|1S.w 20 10 0 10 0 0|01212121212121212121212121212121212121212121232123212321232121212121212121212121212121212121212121454545454545454545454545454545456545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454|-2ldW5.s aPX5.s Sp0 LX0 1vc0 Tc0 1uM0 SM0 1vc0 Tc0 1vc0 SM0 1vc0 6600 1co0 3E00 17c0 1fA0 1a00 1io0 1a00 1io0 17c0 3I00 17c0 1cM0 1cM0 3Fc0 1cM0 1a00 1fA0 1io0 17c0 1cM0 1cM0 1a00 1fA0 1io0 1qM0 Dc0 1tA0 1cM0 1dc0 1400 gL0 IM0 s10 U00 dX0 Rc0 pd0 Rc0 gL0 Oo0 pd0 Rc0 gL0 Oo0 pd0 14o0 1cM0 1cP0 1cM0 1cM0 1cM0 1cM0 1cM0 3Co0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 qIl0 1cM0 1fA0 1cM0 1cM0 1cN0 1cL0 1cN0 1cM0 1cM0 1cM0 1cM0 1cN0 1cL0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cL0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|25e4\",\"Atlantic/Bermuda|LMT AST ADT|4j.i 40 30|0121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-1BnRE.G 1LTbE.G 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|65e3\",\"Atlantic/Canary|LMT CANT WET WEST|11.A 10 0 -10|01232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232|-1UtaW.o XPAW.o 1lAK0 1a10 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|54e4\",\"Atlantic/Cape_Verde|LMT CVT CVST CVT|1y.4 20 10 10|01213|-2xomp.U 1qOMp.U 7zX0 1djf0|50e4\",\"Atlantic/Faroe|LMT WET WEST|r.4 0 -10|01212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-2uSnw.U 2Wgow.U 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|49e3\",\"Atlantic/Madeira|FMT MADT MADST MADMT WET WEST|17.A 10 0 -10 0 -10|01212121212121212121212121212121212121212121232123212321232121212121212121212121212121212121212121454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454|-2ldWQ.o aPWQ.o Sp0 LX0 1vc0 Tc0 1uM0 SM0 1vc0 Tc0 1vc0 SM0 1vc0 6600 1co0 3E00 17c0 1fA0 1a00 1io0 1a00 1io0 17c0 3I00 17c0 1cM0 1cM0 3Fc0 1cM0 1a00 1fA0 1io0 17c0 1cM0 1cM0 1a00 1fA0 1io0 1qM0 Dc0 1tA0 1cM0 1dc0 1400 gL0 IM0 s10 U00 dX0 Rc0 pd0 Rc0 gL0 Oo0 pd0 Rc0 gL0 Oo0 pd0 14o0 1cM0 1cP0 1cM0 1cM0 1cM0 1cM0 1cM0 3Co0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 qIl0 1cM0 1fA0 1cM0 1cM0 1cN0 1cL0 1cN0 1cM0 1cM0 1cM0 1cM0 1cN0 1cL0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|27e4\",\"Atlantic/Reykjavik|LMT IST ISST GMT|1s 10 0 0|012121212121212121212121212121212121212121212121212121212121212121213|-2uWmw mfaw 1Bd0 ML0 1LB0 Cn0 1LB0 3fX0 C10 HrX0 1cO0 LB0 1EL0 LA0 1C00 Oo0 1wo0 Rc0 1wo0 Rc0 1wo0 Rc0 1zc0 Oo0 1zc0 14o0 1lc0 14o0 1lc0 14o0 1o00 11A0 1lc0 14o0 1o00 14o0 1lc0 14o0 1lc0 14o0 1lc0 14o0 1lc0 14o0 1o00 14o0 1lc0 14o0 1lc0 14o0 1lc0 14o0 1lc0 14o0 1lc0 14o0 1o00 14o0 1lc0 14o0 1lc0 14o0 1lc0 14o0 1lc0 14o0 1o00 14o0|12e4\",\"Atlantic/South_Georgia|GST|20|0||30\",\"Atlantic/Stanley|SMT FKT FKST FKT FKST|3P.o 40 30 30 20|0121212121212134343212121212121212121212121212121212121212121212121212|-2kJw8.A 12bA8.A 19X0 1fB0 19X0 1ip0 19X0 1fB0 19X0 1fB0 19X0 1fB0 Cn0 1Cc10 WL0 1qL0 U10 1tz0 U10 1qM0 WN0 1qL0 WN0 1qL0 WN0 1qL0 WN0 1tz0 U10 1tz0 WN0 1qL0 WN0 1qL0 WN0 1qL0 WN0 1qL0 WN0 1tz0 WN0 1qL0 WN0 1qL0 WN0 1qL0 WN0 1qL0 WN0 1qN0 U10 1wn0 Rd0 1wn0 U10 1tz0 U10 1tz0 U10 1tz0 U10 1tz0 U10 1wn0 U10 1tz0 U10 1tz0 U10|21e2\",\"Australia/Sydney|AEST AEDT|-a0 -b0|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101|-293lX xcX 10jd0 yL0 1cN0 1cL0 1fB0 19X0 17c10 LA0 1C00 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 14o0 1o00 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 U00 1qM0 WM0 1tA0 WM0 1tA0 U00 1tA0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 11A0 1o00 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 11A0 1o00 WM0 1qM0 14o0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0|40e5\",\"Australia/Adelaide|ACST ACDT|-9u -au|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101|-293lt xcX 10jd0 yL0 1cN0 1cL0 1fB0 19X0 17c10 LA0 1C00 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 U00 1qM0 WM0 1tA0 WM0 1tA0 U00 1tA0 U00 1tA0 Oo0 1zc0 WM0 1qM0 Rc0 1zc0 U00 1tA0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 11A0 1o00 WM0 1qM0 14o0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0|11e5\",\"Australia/Brisbane|AEST AEDT|-a0 -b0|01010101010101010|-293lX xcX 10jd0 yL0 1cN0 1cL0 1fB0 19X0 17c10 LA0 H1A0 Oo0 1zc0 Oo0 1zc0 Oo0|20e5\",\"Australia/Broken_Hill|ACST ACDT|-9u -au|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101|-293lt xcX 10jd0 yL0 1cN0 1cL0 1fB0 19X0 17c10 LA0 1C00 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 14o0 1o00 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 U00 1qM0 WM0 1tA0 WM0 1tA0 U00 1tA0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 11A0 1o00 WM0 1qM0 14o0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0|18e3\",\"Australia/Currie|AEST AEDT|-a0 -b0|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101|-29E80 19X0 10jd0 yL0 1cN0 1cL0 1fB0 19X0 17c10 LA0 1C00 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 11A0 1qM0 WM0 1qM0 Oo0 1zc0 Oo0 1zc0 Oo0 1wo0 WM0 1tA0 WM0 1tA0 U00 1tA0 U00 1tA0 11A0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 11A0 1o00 1io0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1cM0 1a00 1io0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0|746\",\"Australia/Darwin|ACST ACDT|-9u -au|010101010|-293lt xcX 10jd0 yL0 1cN0 1cL0 1fB0 19X0|12e4\",\"Australia/Eucla|ACWST ACWDT|-8J -9J|0101010101010101010|-293kI xcX 10jd0 yL0 1cN0 1cL0 1gSp0 Oo0 l5A0 Oo0 iJA0 G00 zU00 IM0 1qM0 11A0 1o00 11A0|368\",\"Australia/Hobart|AEST AEDT|-a0 -b0|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101|-29E80 19X0 10jd0 yL0 1cN0 1cL0 1fB0 19X0 VfB0 1cM0 1o00 Rc0 1wo0 Rc0 1wo0 U00 1wo0 LA0 1C00 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 11A0 1qM0 WM0 1qM0 Oo0 1zc0 Oo0 1zc0 Oo0 1wo0 WM0 1tA0 WM0 1tA0 U00 1tA0 U00 1tA0 11A0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 11A0 1o00 1io0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1cM0 1a00 1io0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0|21e4\",\"Australia/Lord_Howe|AEST LHST LHDT LHDT|-a0 -au -bu -b0|0121212121313131313131313131313131313131313131313131313131313131313131313131313131313131313131313131313131313131313|raC0 1zdu Rb0 1zd0 On0 1zd0 On0 1zd0 On0 1zd0 TXu 1qMu WLu 1tAu WLu 1tAu TXu 1tAu Onu 1zcu Onu 1zcu Onu 1zcu Rbu 1zcu Onu 1zcu Onu 1zcu 11zu 1o0u 11zu 1o0u 11zu 1o0u 11zu 1qMu WLu 11Au 1nXu 1qMu 11zu 1o0u 11zu 1o0u 11zu 1qMu WLu 1qMu 11zu 1o0u WLu 1qMu 14nu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1fAu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1fAu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1fzu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1fAu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1fAu 1cLu 1cMu 1cLu 1cMu|347\",\"Australia/Lindeman|AEST AEDT|-a0 -b0|010101010101010101010|-293lX xcX 10jd0 yL0 1cN0 1cL0 1fB0 19X0 17c10 LA0 H1A0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0|10\",\"Australia/Melbourne|AEST AEDT|-a0 -b0|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101|-293lX xcX 10jd0 yL0 1cN0 1cL0 1fB0 19X0 17c10 LA0 1C00 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 U00 1qM0 WM0 1qM0 11A0 1tA0 U00 1tA0 U00 1tA0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 11A0 1o00 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 11A0 1o00 WM0 1qM0 14o0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0|39e5\",\"Australia/Perth|AWST AWDT|-80 -90|0101010101010101010|-293jX xcX 10jd0 yL0 1cN0 1cL0 1gSp0 Oo0 l5A0 Oo0 iJA0 G00 zU00 IM0 1qM0 11A0 1o00 11A0|18e5\",\"CET|CET CEST|-10 -20|01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-2aFe0 11d0 1iO0 11A0 1o00 11A0 Qrc0 6i00 WM0 1fA0 1cM0 1cM0 1cM0 16M0 1gMM0 1a00 1fA0 1cM0 1cM0 1cM0 1fA0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00\",\"CST6CDT|CST CDT CWT CPT|60 50 50 50|010102301010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-261s0 1nX0 11B0 1nX0 SgN0 8x30 iw0 QwN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0\",\"Pacific/Easter|EMT EAST EASST EAST EASST|7h.s 70 60 60 50|0121212121212121212121212121234343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434|-1uSgG.w 1s4IG.w WL0 1zd0 On0 1ip0 11z0 1o10 11z0 1qN0 WL0 1ld0 14n0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 WL0 1qN0 1cL0 1cN0 11z0 1o10 11z0 1qN0 WL0 1fB0 19X0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 17b0 1ip0 11z0 1ip0 1fz0 1fB0 11z0 1qN0 WL0 1qN0 WL0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 17b0 1ip0 11z0 1o10 19X0 1fB0 1nX0 G10 1EL0 Op0 1zb0 Rd0 1wn0 Rd0 46n0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Dd0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Dd0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Dd0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0|30e2\",\"EET|EET EEST|-20 -30|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|hDB0 1a00 1fA0 1cM0 1cM0 1cM0 1fA0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00\",\"EST|EST|50|0|\",\"EST5EDT|EST EDT EWT EPT|50 40 40 40|010102301010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-261t0 1nX0 11B0 1nX0 SgN0 8x40 iv0 QwN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0\",\"Europe/Dublin|DMT IST GMT BST IST|p.l -y.D 0 -10 -10|01232323232324242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242|-2ax9y.D Rc0 1fzy.D 14M0 1fc0 1g00 1co0 1dc0 1co0 1oo0 1400 1dc0 19A0 1io0 1io0 WM0 1o00 14o0 1o00 17c0 1io0 17c0 1fA0 1a00 1lc0 17c0 1io0 17c0 1fA0 1a00 1io0 17c0 1io0 17c0 1fA0 1cM0 1io0 17c0 1fA0 1a00 1io0 17c0 1io0 17c0 1fA0 1a00 1io0 1qM0 Dc0 g5X0 14p0 1wn0 17d0 1io0 11A0 1o00 17c0 1fA0 1a00 1fA0 1cM0 1fA0 1a00 17c0 1fA0 1a00 1io0 17c0 1lc0 17c0 1fA0 1a00 1io0 17c0 1io0 17c0 1fA0 1a00 1a00 1qM0 WM0 1qM0 11A0 1o00 WM0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1tA0 IM0 90o0 U00 1tA0 U00 1tA0 U00 1tA0 U00 1tA0 WM0 1qM0 WM0 1qM0 WM0 1tA0 U00 1tA0 U00 1tA0 11z0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1o00 14o0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|12e5\",\"Etc/GMT+0|GMT|0|0|\",\"Etc/GMT+1|GMT+1|10|0|\",\"Etc/GMT+10|GMT+10|a0|0|\",\"Etc/GMT+11|GMT+11|b0|0|\",\"Etc/GMT+12|GMT+12|c0|0|\",\"Etc/GMT+2|GMT+2|20|0|\",\"Etc/GMT+3|GMT+3|30|0|\",\"Etc/GMT+4|GMT+4|40|0|\",\"Etc/GMT+5|GMT+5|50|0|\",\"Etc/GMT+6|GMT+6|60|0|\",\"Etc/GMT+7|GMT+7|70|0|\",\"Etc/GMT+8|GMT+8|80|0|\",\"Etc/GMT+9|GMT+9|90|0|\",\"Etc/GMT-1|GMT-1|-10|0|\",\"Etc/GMT-10|GMT-10|-a0|0|\",\"Etc/GMT-11|GMT-11|-b0|0|\",\"Etc/GMT-12|GMT-12|-c0|0|\",\"Etc/GMT-13|GMT-13|-d0|0|\",\"Etc/GMT-14|GMT-14|-e0|0|\",\"Etc/GMT-2|GMT-2|-20|0|\",\"Etc/GMT-3|GMT-3|-30|0|\",\"Etc/GMT-4|GMT-4|-40|0|\",\"Etc/GMT-5|GMT-5|-50|0|\",\"Etc/GMT-6|GMT-6|-60|0|\",\"Etc/GMT-7|GMT-7|-70|0|\",\"Etc/GMT-8|GMT-8|-80|0|\",\"Etc/GMT-9|GMT-9|-90|0|\",\"Etc/UCT|UCT|0|0|\",\"Etc/UTC|UTC|0|0|\",\"Europe/Amsterdam|AMT NST NEST NET CEST CET|-j.w -1j.w -1k -k -20 -10|010101010101010101010101010101010101010101012323234545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545|-2aFcj.w 11b0 1iP0 11A0 1io0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1co0 1io0 1yo0 Pc0 1a00 1fA0 1Bc0 Mo0 1tc0 Uo0 1tA0 U00 1uo0 W00 1s00 VA0 1so0 Vc0 1sM0 UM0 1wo0 Rc0 1u00 Wo0 1rA0 W00 1s00 VA0 1sM0 UM0 1w00 fV0 BCX.w 1tA0 U00 1u00 Wo0 1sm0 601k WM0 1fA0 1cM0 1cM0 1cM0 16M0 1gMM0 1a00 1fA0 1cM0 1cM0 1cM0 1fA0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|16e5\",\"Europe/Andorra|WET CET CEST|0 -10 -20|012121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-UBA0 1xIN0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|79e3\",\"Europe/Astrakhan|LMT +03 +04 +05|-3c.c -30 -40 -50|012323232323232323212121212121212121212121212121212121212121212|-1Pcrc.c eUMc.c 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 2pB0 1cM0 1fA0 1cM0 3Co0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0 3rd0\",\"Europe/Athens|AMT EET EEST CEST CET|-1y.Q -20 -30 -20 -10|012123434121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-2a61x.Q CNbx.Q mn0 kU10 9b0 3Es0 Xa0 1fb0 1dd0 k3X0 Nz0 SCp0 1vc0 SO0 1cM0 1a00 1ao0 1fc0 1a10 1fG0 1cg0 1dX0 1bX0 1cQ0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|35e5\",\"Europe/London|GMT BST BDST|0 -10 -20|0101010101010101010101010101010101010101010101010121212121210101210101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-2axa0 Rc0 1fA0 14M0 1fc0 1g00 1co0 1dc0 1co0 1oo0 1400 1dc0 19A0 1io0 1io0 WM0 1o00 14o0 1o00 17c0 1io0 17c0 1fA0 1a00 1lc0 17c0 1io0 17c0 1fA0 1a00 1io0 17c0 1io0 17c0 1fA0 1cM0 1io0 17c0 1fA0 1a00 1io0 17c0 1io0 17c0 1fA0 1a00 1io0 1qM0 Dc0 2Rz0 Dc0 1zc0 Oo0 1zc0 Rc0 1wo0 17c0 1iM0 FA0 xB0 1fA0 1a00 14o0 bb0 LA0 xB0 Rc0 1wo0 11A0 1o00 17c0 1fA0 1a00 1fA0 1cM0 1fA0 1a00 17c0 1fA0 1a00 1io0 17c0 1lc0 17c0 1fA0 1a00 1io0 17c0 1io0 17c0 1fA0 1a00 1a00 1qM0 WM0 1qM0 11A0 1o00 WM0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1tA0 IM0 90o0 U00 1tA0 U00 1tA0 U00 1tA0 U00 1tA0 WM0 1qM0 WM0 1qM0 WM0 1tA0 U00 1tA0 U00 1tA0 11z0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1o00 14o0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|10e6\",\"Europe/Belgrade|CET CEST|-10 -20|01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-19RC0 3IP0 WM0 1fA0 1cM0 1cM0 1rc0 Qo0 1vmo0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|12e5\",\"Europe/Berlin|CET CEST CEMT|-10 -20 -30|01010101010101210101210101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-2aFe0 11d0 1iO0 11A0 1o00 11A0 Qrc0 6i00 WM0 1fA0 1cM0 1cM0 1cM0 kL0 Nc0 m10 WM0 1ao0 1cp0 dX0 jz0 Dd0 1io0 17c0 1fA0 1a00 1ehA0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|41e5\",\"Europe/Prague|CET CEST|-10 -20|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-2aFe0 11d0 1iO0 11A0 1o00 11A0 Qrc0 6i00 WM0 1fA0 1cM0 16M0 1lc0 1tA0 17A0 11c0 1io0 17c0 1io0 17c0 1fc0 1ao0 1bNc0 1cM0 1fA0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|13e5\",\"Europe/Brussels|WET CET CEST WEST|0 -10 -20 -10|0121212103030303030303030303030303030303030303030303212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-2ehc0 3zX0 11c0 1iO0 11A0 1o00 11A0 my0 Ic0 1qM0 Rc0 1EM0 UM0 1u00 10o0 1io0 1io0 17c0 1a00 1fA0 1cM0 1cM0 1io0 17c0 1fA0 1a00 1io0 1a30 1io0 17c0 1fA0 1a00 1io0 17c0 1cM0 1cM0 1a00 1io0 1cM0 1cM0 1a00 1fA0 1io0 17c0 1cM0 1cM0 1a00 1fA0 1io0 1qM0 Dc0 y00 5Wn0 WM0 1fA0 1cM0 16M0 1iM0 16M0 1C00 Uo0 1eeo0 1a00 1fA0 1cM0 1cM0 1cM0 1fA0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|21e5\",\"Europe/Bucharest|BMT EET EEST|-1I.o -20 -30|0121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-1xApI.o 20LI.o RA0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1Axc0 On0 1fA0 1a10 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cK0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cL0 1cN0 1cL0 1fB0 1nX0 11E0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|19e5\",\"Europe/Budapest|CET CEST|-10 -20|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-2aFe0 11d0 1iO0 11A0 1ip0 17b0 1op0 1tb0 Q2m0 3Ne0 WM0 1fA0 1cM0 1cM0 1oJ0 1dc0 1030 1fA0 1cM0 1cM0 1cM0 1cM0 1fA0 1a00 1iM0 1fA0 8Ha0 Rb0 1wN0 Rb0 1BB0 Lz0 1C20 LB0 SNX0 1a10 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|17e5\",\"Europe/Zurich|CET CEST|-10 -20|01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-19Lc0 11A0 1o00 11A0 1xG10 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|38e4\",\"Europe/Chisinau|CMT BMT EET EEST CEST CET MSK MSD|-1T -1I.o -20 -30 -20 -10 -30 -40|012323232323232323234545467676767676767676767323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232|-26jdT wGMa.A 20LI.o RA0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 27A0 2en0 39g0 WM0 1fA0 1cM0 V90 1t7z0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 gL0 WO0 1cM0 1cM0 1cK0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1fB0 1nX0 11D0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|67e4\",\"Europe/Copenhagen|CET CEST|-10 -20|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-2azC0 Tz0 VuO0 60q0 WM0 1fA0 1cM0 1cM0 1cM0 S00 1HA0 Nc0 1C00 Dc0 1Nc0 Ao0 1h5A0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|12e5\",\"Europe/Gibraltar|GMT BST BDST CET CEST|0 -10 -20 -10 -20|010101010101010101010101010101010101010101010101012121212121010121010101010101010101034343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343|-2axa0 Rc0 1fA0 14M0 1fc0 1g00 1co0 1dc0 1co0 1oo0 1400 1dc0 19A0 1io0 1io0 WM0 1o00 14o0 1o00 17c0 1io0 17c0 1fA0 1a00 1lc0 17c0 1io0 17c0 1fA0 1a00 1io0 17c0 1io0 17c0 1fA0 1cM0 1io0 17c0 1fA0 1a00 1io0 17c0 1io0 17c0 1fA0 1a00 1io0 1qM0 Dc0 2Rz0 Dc0 1zc0 Oo0 1zc0 Rc0 1wo0 17c0 1iM0 FA0 xB0 1fA0 1a00 14o0 bb0 LA0 xB0 Rc0 1wo0 11A0 1o00 17c0 1fA0 1a00 1fA0 1cM0 1fA0 1a00 17c0 1fA0 1a00 1io0 17c0 1lc0 17c0 1fA0 10Jz0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|30e3\",\"Europe/Helsinki|HMT EET EEST|-1D.N -20 -30|0121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-1WuND.N OULD.N 1dA0 1xGq0 1cM0 1cM0 1cM0 1cN0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|12e5\",\"Europe/Kaliningrad|CET CEST CET CEST MSK MSD EEST EET FET|-10 -20 -20 -30 -30 -40 -30 -20 -30|0101010101010232454545454545454546767676767676767676767676767676767676767676787|-2aFe0 11d0 1iO0 11A0 1o00 11A0 Qrc0 6i00 WM0 1fA0 1cM0 1cM0 Am0 Lb0 1en0 op0 1pNz0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cN0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0|44e4\",\"Europe/Kiev|KMT EET MSK CEST CET MSD EEST|-22.4 -20 -30 -20 -10 -40 -30|0123434252525252525252525256161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161|-1Pc22.4 eUo2.4 rnz0 2Hg0 WM0 1fA0 da0 1v4m0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 Db0 3220 1cK0 1cL0 1cN0 1cL0 1cN0 1cL0 1cQ0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|34e5\",\"Europe/Kirov|LMT +03 +04 +05|-3i.M -30 -40 -50|01232323232323232321212121212121212121212121212121212121212121|-22WNi.M qHai.M 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 2pB0 1cM0 1fA0 1cM0 3Co0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0|48e4\",\"Europe/Lisbon|LMT WET WEST WEMT CET CEST|A.J 0 -10 -20 -10 -20|012121212121212121212121212121212121212121212321232123212321212121212121212121212121212121212121214121212121212121212121212121212124545454212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-2ldXn.f aPWn.f Sp0 LX0 1vc0 Tc0 1uM0 SM0 1vc0 Tc0 1vc0 SM0 1vc0 6600 1co0 3E00 17c0 1fA0 1a00 1io0 1a00 1io0 17c0 3I00 17c0 1cM0 1cM0 3Fc0 1cM0 1a00 1fA0 1io0 17c0 1cM0 1cM0 1a00 1fA0 1io0 1qM0 Dc0 1tA0 1cM0 1dc0 1400 gL0 IM0 s10 U00 dX0 Rc0 pd0 Rc0 gL0 Oo0 pd0 Rc0 gL0 Oo0 pd0 14o0 1cM0 1cP0 1cM0 1cM0 1cM0 1cM0 1cM0 3Co0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 pvy0 1cM0 1cM0 1fA0 1cM0 1cM0 1cN0 1cL0 1cN0 1cM0 1cM0 1cM0 1cM0 1cN0 1cL0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|27e5\",\"Europe/Luxembourg|LMT CET CEST WET WEST WEST WET|-o.A -10 -20 0 -10 -20 -10|0121212134343434343434343434343434343434343434343434565651212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-2DG0o.A t6mo.A TB0 1nX0 Up0 1o20 11A0 rW0 CM0 1qP0 R90 1EO0 UK0 1u20 10m0 1ip0 1in0 17e0 19W0 1fB0 1db0 1cp0 1in0 17d0 1fz0 1a10 1in0 1a10 1in0 17f0 1fA0 1a00 1io0 17c0 1cM0 1cM0 1a00 1io0 1cM0 1cM0 1a00 1fA0 1io0 17c0 1cM0 1cM0 1a00 1fA0 1io0 1qM0 Dc0 vA0 60L0 WM0 1fA0 1cM0 17c0 1io0 16M0 1C00 Uo0 1eeo0 1a00 1fA0 1cM0 1cM0 1cM0 1fA0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|54e4\",\"Europe/Madrid|WET WEST WEMT CET CEST|0 -10 -20 -10 -20|01010101010101010101010121212121234343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343|-28dd0 11A0 1go0 19A0 1co0 1dA0 b1A0 18o0 3I00 17c0 1fA0 1a00 1io0 1a00 1io0 17c0 iyo0 Rc0 18o0 1hc0 1io0 1a00 14o0 5aL0 MM0 1vc0 17A0 1i00 1bc0 1eo0 17d0 1in0 17A0 6hA0 10N0 XIL0 1a10 1in0 17d0 19X0 1cN0 1fz0 1a10 1fX0 1cp0 1cO0 1cM0 1fA0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|62e5\",\"Europe/Malta|CET CEST|-10 -20|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-2as10 M00 1cM0 1cM0 14o0 1o00 WM0 1qM0 17c0 1cM0 M3A0 5M20 WM0 1fA0 1cM0 1cM0 1cM0 16m0 1de0 1lc0 14m0 1lc0 WO0 1qM0 GTW0 On0 1C10 Lz0 1C10 Lz0 1EN0 Lz0 1C10 Lz0 1zd0 Oo0 1C00 On0 1cp0 1cM0 1lA0 Xc0 1qq0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1iN0 19z0 1fB0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|42e4\",\"Europe/Minsk|MMT EET MSK CEST CET MSD EEST FET|-1O -20 -30 -20 -10 -40 -30 -30|012343432525252525252525252616161616161616161616161616161616161616172|-1Pc1O eUnO qNX0 3gQ0 WM0 1fA0 1cM0 Al0 1tsn0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 3Fc0 1cN0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hy0|19e5\",\"Europe/Monaco|PMT WET WEST WEMT CET CEST|-9.l 0 -10 -20 -10 -20|01212121212121212121212121212121212121212121212121232323232345454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454|-2nco9.l cNb9.l HA0 19A0 1iM0 11c0 1oo0 Wo0 1rc0 QM0 1EM0 UM0 1u00 10o0 1io0 1wo0 Rc0 1a00 1fA0 1cM0 1cM0 1io0 17c0 1fA0 1a00 1io0 1a00 1io0 17c0 1fA0 1a00 1io0 17c0 1cM0 1cM0 1a00 1io0 1cM0 1cM0 1a00 1fA0 1io0 17c0 1cM0 1cM0 1a00 1fA0 1io0 1qM0 Df0 2RV0 11z0 11B0 1ze0 WM0 1fA0 1cM0 1fa0 1aq0 16M0 1ekn0 1cL0 1fC0 1a00 1fA0 1cM0 1cM0 1cM0 1fA0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|38e3\",\"Europe/Moscow|MMT MMT MST MDST MSD MSK MSM EET EEST MSK|-2u.h -2v.j -3v.j -4v.j -40 -30 -50 -20 -30 -40|012132345464575454545454545454545458754545454545454545454545454545454545454595|-2ag2u.h 2pyW.W 1bA0 11X0 GN0 1Hb0 c20 imv.j 3DA0 dz0 15A0 c10 2q10 iM10 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cN0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0|16e6\",\"Europe/Paris|PMT WET WEST CEST CET WEMT|-9.l 0 -10 -20 -10 -20|0121212121212121212121212121212121212121212121212123434352543434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434|-2nco8.l cNb8.l HA0 19A0 1iM0 11c0 1oo0 Wo0 1rc0 QM0 1EM0 UM0 1u00 10o0 1io0 1wo0 Rc0 1a00 1fA0 1cM0 1cM0 1io0 17c0 1fA0 1a00 1io0 1a00 1io0 17c0 1fA0 1a00 1io0 17c0 1cM0 1cM0 1a00 1io0 1cM0 1cM0 1a00 1fA0 1io0 17c0 1cM0 1cM0 1a00 1fA0 1io0 1qM0 Df0 Ik0 5M30 WM0 1fA0 1cM0 Vx0 hB0 1aq0 16M0 1ekn0 1cL0 1fC0 1a00 1fA0 1cM0 1cM0 1cM0 1fA0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|11e6\",\"Europe/Riga|RMT LST EET MSK CEST CET MSD EEST|-1A.y -2A.y -20 -30 -20 -10 -40 -30|010102345454536363636363636363727272727272727272727272727272727272727272727272727272727272727272727272727272727272727272727272|-25TzA.y 11A0 1iM0 ko0 gWm0 yDXA.y 2bX0 3fE0 WM0 1fA0 1cM0 1cM0 4m0 1sLy0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cN0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cN0 1o00 11A0 1o00 11A0 1qM0 3oo0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|64e4\",\"Europe/Rome|CET CEST|-10 -20|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-2as10 M00 1cM0 1cM0 14o0 1o00 WM0 1qM0 17c0 1cM0 M3A0 5M20 WM0 1fA0 1cM0 16K0 1iO0 16m0 1de0 1lc0 14m0 1lc0 WO0 1qM0 GTW0 On0 1C10 Lz0 1C10 Lz0 1EN0 Lz0 1C10 Lz0 1zd0 Oo0 1C00 On0 1C10 Lz0 1zd0 On0 1C10 LA0 1C00 LA0 1zc0 Oo0 1C00 Oo0 1zc0 Oo0 1fC0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|39e5\",\"Europe/Samara|LMT SAMT SAMT KUYT KUYST MSD MSK EEST SAMST SAMST|-3k.k -30 -40 -40 -50 -40 -30 -30 -50 -40|012343434343434343435656712828282828282828282828282828282828282912|-22WNk.k qHak.k bcn0 1Qqo0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cN0 1cM0 1fA0 1cM0 1cN0 8o0 14m0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qN0 WM0|12e5\",\"Europe/Simferopol|SMT EET MSK CEST CET MSD EEST MSK|-2g -20 -30 -20 -10 -40 -30 -40|012343432525252525252525252161616525252616161616161616161616161616161616172|-1Pc2g eUog rEn0 2qs0 WM0 1fA0 1cM0 3V0 1u0L0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1Q00 4eL0 1cL0 1cN0 1cL0 1cN0 dX0 WL0 1cN0 1cL0 1fB0 1o30 11B0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11z0 1nW0|33e4\",\"Europe/Sofia|EET CET CEST EEST|-20 -10 -20 -30|01212103030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030|-168L0 WM0 1fA0 1cM0 1cM0 1cN0 1mKH0 1dd0 1fb0 1ap0 1fb0 1a20 1fy0 1a30 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cK0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1fB0 1nX0 11E0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|12e5\",\"Europe/Stockholm|CET CEST|-10 -20|01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-2azC0 TB0 2yDe0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|15e5\",\"Europe/Tallinn|TMT CET CEST EET MSK MSD EEST|-1D -10 -20 -20 -30 -40 -30|012103421212454545454545454546363636363636363636363636363636363636363636363636363636363636363636363636363636363636363636363|-26oND teD 11A0 1Ta0 4rXl KSLD 2FX0 2Jg0 WM0 1fA0 1cM0 18J0 1sTX0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cN0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o10 11A0 1qM0 5QM0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|41e4\",\"Europe/Tirane|LMT CET CEST|-1j.k -10 -20|01212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-2glBj.k 14pcj.k 5LC0 WM0 4M0 1fCK0 10n0 1op0 11z0 1pd0 11z0 1qN0 WL0 1qp0 Xb0 1qp0 Xb0 1qp0 11z0 1lB0 11z0 1qN0 11z0 1iN0 16n0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|42e4\",\"Europe/Ulyanovsk|LMT +03 +04 +05 +02|-3d.A -30 -40 -50 -20|01232323232323232321214121212121212121212121212121212121212121212|-22WNd.A qHad.A 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 2pB0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0 3rd0\",\"Europe/Uzhgorod|CET CEST MSK MSD EET EEST|-10 -20 -30 -40 -20 -30|010101023232323232323232320454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454|-1cqL0 6i00 WM0 1fA0 1cM0 1ml0 1Cp0 1r3W0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1Q00 1Nf0 2pw0 1cL0 1cN0 1cL0 1cN0 1cL0 1cQ0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|11e4\",\"Europe/Vienna|CET CEST|-10 -20|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-2aFe0 11d0 1iO0 11A0 1o00 11A0 3KM0 14o0 LA00 6i00 WM0 1fA0 1cM0 1cM0 1cM0 400 2qM0 1a00 1cM0 1cM0 1io0 17c0 1gHa0 19X0 1cP0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|18e5\",\"Europe/Vilnius|WMT KMT CET EET MSK CEST MSD EEST|-1o -1z.A -10 -20 -30 -20 -40 -30|012324525254646464646464646473737373737373737352537373737373737373737373737373737373737373737373737373737373737373737373|-293do 6ILM.o 1Ooz.A zz0 Mfd0 29W0 3is0 WM0 1fA0 1cM0 LV0 1tgL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cN0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11B0 1o00 11A0 1qM0 8io0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|54e4\",\"Europe/Volgograd|LMT TSAT STAT STAT VOLT VOLST VOLST VOLT MSD MSK MSK|-2V.E -30 -30 -40 -40 -50 -40 -30 -40 -30 -40|0123454545454545454676767489898989898989898989898989898989898989a9|-21IqV.E cLXV.E cEM0 1gqn0 Lco0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cN0 1cM0 1cM0 1cM0 1fA0 1cM0 2pz0 1cN0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0|10e5\",\"Europe/Warsaw|WMT CET CEST EET EEST|-1o -10 -20 -20 -30|012121234312121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-2ctdo 1LXo 11d0 1iO0 11A0 1o00 11A0 1on0 11A0 6zy0 HWP0 5IM0 WM0 1fA0 1cM0 1dz0 1mL0 1en0 15B0 1aq0 1nA0 11A0 1io0 17c0 1fA0 1a00 iDX0 LA0 1cM0 1cM0 1C00 Oo0 1cM0 1cM0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1C00 LA0 uso0 1a00 1fA0 1cM0 1cM0 1cM0 1fA0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cN0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|17e5\",\"Europe/Zaporozhye|CUT EET MSK CEST CET MSD EEST|-2k -20 -30 -20 -10 -40 -30|01234342525252525252525252526161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161|-1Pc2k eUok rdb0 2RE0 WM0 1fA0 8m0 1v9a0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cK0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cQ0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|77e4\",\"HST|HST|a0|0|\",\"Indian/Chagos|LMT IOT IOT|-4N.E -50 -60|012|-2xosN.E 3AGLN.E|30e2\",\"Indian/Christmas|CXT|-70|0||21e2\",\"Indian/Cocos|CCT|-6u|0||596\",\"Indian/Kerguelen|-00 TFT|0 -50|01|-MG00|130\",\"Indian/Mahe|LMT SCT|-3F.M -40|01|-2yO3F.M|79e3\",\"Indian/Maldives|MMT MVT|-4S -50|01|-olgS|35e4\",\"Indian/Mauritius|LMT MUT MUST|-3O -40 -50|012121|-2xorO 34unO 14L0 12kr0 11z0|15e4\",\"Indian/Reunion|LMT RET|-3F.Q -40|01|-2mDDF.Q|84e4\",\"Pacific/Kwajalein|MHT KWAT MHT|-b0 c0 -c0|012|-AX0 W9X0|14e3\",\"MET|MET MEST|-10 -20|01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-2aFe0 11d0 1iO0 11A0 1o00 11A0 Qrc0 6i00 WM0 1fA0 1cM0 1cM0 1cM0 16M0 1gMM0 1a00 1fA0 1cM0 1cM0 1cM0 1fA0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00\",\"MST|MST|70|0|\",\"MST7MDT|MST MDT MWT MPT|70 60 60 60|010102301010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-261r0 1nX0 11B0 1nX0 SgN0 8x20 ix0 QwN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0\",\"Pacific/Chatham|CHAST CHAST CHADT|-cf -cJ -dJ|012121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212|-WqAf 1adef IM0 1C00 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1qM0 14o0 1lc0 14o0 1lc0 14o0 1lc0 17c0 1io0 17c0 1io0 17c0 1io0 17c0 1lc0 14o0 1lc0 14o0 1lc0 17c0 1io0 17c0 1io0 17c0 1lc0 14o0 1lc0 14o0 1lc0 17c0 1io0 17c0 1io0 17c0 1io0 17c0 1io0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1io0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00|600\",\"PST8PDT|PST PDT PWT PPT|80 70 70 70|010102301010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-261q0 1nX0 11B0 1nX0 SgN0 8x10 iy0 QwN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0\",\"Pacific/Apia|LMT WSST SST SDT WSDT WSST|bq.U bu b0 a0 -e0 -d0|01232345454545454545454545454545454545454545454545454545454|-2nDMx.4 1yW03.4 2rRbu 1ff0 1a00 CI0 AQ0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1io0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00|37e3\",\"Pacific/Bougainville|PGT JST BST|-a0 -90 -b0|0102|-16Wy0 7CN0 2MQp0|18e4\",\"Pacific/Chuuk|CHUT|-a0|0||49e3\",\"Pacific/Efate|LMT VUT VUST|-bd.g -b0 -c0|0121212121212121212121|-2l9nd.g 2Szcd.g 1cL0 1oN0 10L0 1fB0 19X0 1fB0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1fB0 Lz0 1Nd0 An0|66e3\",\"Pacific/Enderbury|PHOT PHOT PHOT|c0 b0 -d0|012|nIc0 B8n0|1\",\"Pacific/Fakaofo|TKT TKT|b0 -d0|01|1Gfn0|483\",\"Pacific/Fiji|LMT FJT FJST|-bT.I -c0 -d0|0121212121212121212121212121212121212121212121212121212121212121|-2bUzT.I 3m8NT.I LA0 1EM0 IM0 nJc0 LA0 1o00 Rc0 1wo0 Ao0 1Nc0 Ao0 1Q00 xz0 1SN0 uM0 1SM0 uM0 1VA0 s00 1VA0 uM0 1SM0 uM0 1SM0 uM0 1SM0 uM0 1VA0 s00 1VA0 s00 1VA0 uM0 1SM0 uM0 1SM0 uM0 1SM0 uM0 1VA0 s00 1VA0 uM0 1SM0 uM0 1SM0 uM0 1SM0 uM0 1VA0 s00 1VA0 s00 1VA0 uM0 1SM0 uM0 1SM0 uM0 1SM0 uM0|88e4\",\"Pacific/Funafuti|TVT|-c0|0||45e2\",\"Pacific/Galapagos|LMT ECT GALT|5W.o 50 60|012|-1yVS1.A 2dTz1.A|25e3\",\"Pacific/Gambier|LMT GAMT|8X.M 90|01|-2jof0.c|125\",\"Pacific/Guadalcanal|LMT SBT|-aD.M -b0|01|-2joyD.M|11e4\",\"Pacific/Guam|GST ChST|-a0 -a0|01|1fpq0|17e4\",\"Pacific/Honolulu|HST HDT HST|au 9u a0|010102|-1thLu 8x0 lef0 8Pz0 46p0|37e4\",\"Pacific/Kiritimati|LINT LINT LINT|aE a0 -e0|012|nIaE B8nk|51e2\",\"Pacific/Kosrae|KOST KOST|-b0 -c0|010|-AX0 1bdz0|66e2\",\"Pacific/Majuro|MHT MHT|-b0 -c0|01|-AX0|28e3\",\"Pacific/Marquesas|LMT MART|9i 9u|01|-2joeG|86e2\",\"Pacific/Pago_Pago|LMT NST BST SST|bm.M b0 b0 b0|0123|-2nDMB.c 2gVzB.c EyM0|37e2\",\"Pacific/Nauru|LMT NRT JST NRT|-b7.E -bu -90 -c0|01213|-1Xdn7.E PvzB.E 5RCu 1ouJu|10e3\",\"Pacific/Niue|NUT NUT NUT|bk bu b0|012|-KfME 17y0a|12e2\",\"Pacific/Norfolk|NMT NFT NFST NFT|-bc -bu -cu -b0|01213|-Kgbc W01G On0 1COp0|25e4\",\"Pacific/Noumea|LMT NCT NCST|-b5.M -b0 -c0|01212121|-2l9n5.M 2EqM5.M xX0 1PB0 yn0 HeP0 Ao0|98e3\",\"Pacific/Palau|PWT|-90|0||21e3\",\"Pacific/Pitcairn|PNT PST|8u 80|01|18Vku|56\",\"Pacific/Pohnpei|PONT|-b0|0||34e3\",\"Pacific/Port_Moresby|PGT|-a0|0||25e4\",\"Pacific/Rarotonga|CKT CKHST CKT|au 9u a0|012121212121212121212121212|lyWu IL0 1zcu Onu 1zcu Onu 1zcu Rbu 1zcu Onu 1zcu Onu 1zcu Onu 1zcu Onu 1zcu Onu 1zcu Rbu 1zcu Onu 1zcu Onu 1zcu Onu|13e3\",\"Pacific/Tahiti|LMT TAHT|9W.g a0|01|-2joe1.I|18e4\",\"Pacific/Tarawa|GILT|-c0|0||29e3\",\"Pacific/Tongatapu|TOT TOT TOST|-ck -d0 -e0|01212121|-1aB0k 2n5dk 15A0 1wo0 xz0 1Q10 xz0|75e3\",\"Pacific/Wake|WAKT|-c0|0||16e3\",\"Pacific/Wallis|WFT|-c0|0||94\",\"WET|WET WEST|0 -10|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|hDB0 1a00 1fA0 1cM0 1cM0 1cM0 1fA0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00\"],\n    links:[\"Africa/Abidjan|Africa/Bamako\",\"Africa/Abidjan|Africa/Banjul\",\"Africa/Abidjan|Africa/Conakry\",\"Africa/Abidjan|Africa/Dakar\",\"Africa/Abidjan|Africa/Freetown\",\"Africa/Abidjan|Africa/Lome\",\"Africa/Abidjan|Africa/Nouakchott\",\"Africa/Abidjan|Africa/Ouagadougou\",\"Africa/Abidjan|Africa/Sao_Tome\",\"Africa/Abidjan|Africa/Timbuktu\",\"Africa/Abidjan|Atlantic/St_Helena\",\"Africa/Cairo|Egypt\",\"Africa/Johannesburg|Africa/Maseru\",\"Africa/Johannesburg|Africa/Mbabane\",\"Africa/Khartoum|Africa/Juba\",\"Africa/Lagos|Africa/Bangui\",\"Africa/Lagos|Africa/Brazzaville\",\"Africa/Lagos|Africa/Douala\",\"Africa/Lagos|Africa/Kinshasa\",\"Africa/Lagos|Africa/Libreville\",\"Africa/Lagos|Africa/Luanda\",\"Africa/Lagos|Africa/Malabo\",\"Africa/Lagos|Africa/Niamey\",\"Africa/Lagos|Africa/Porto-Novo\",\"Africa/Maputo|Africa/Blantyre\",\"Africa/Maputo|Africa/Bujumbura\",\"Africa/Maputo|Africa/Gaborone\",\"Africa/Maputo|Africa/Harare\",\"Africa/Maputo|Africa/Kigali\",\"Africa/Maputo|Africa/Lubumbashi\",\"Africa/Maputo|Africa/Lusaka\",\"Africa/Nairobi|Africa/Addis_Ababa\",\"Africa/Nairobi|Africa/Asmara\",\"Africa/Nairobi|Africa/Asmera\",\"Africa/Nairobi|Africa/Dar_es_Salaam\",\"Africa/Nairobi|Africa/Djibouti\",\"Africa/Nairobi|Africa/Kampala\",\"Africa/Nairobi|Africa/Mogadishu\",\"Africa/Nairobi|Indian/Antananarivo\",\"Africa/Nairobi|Indian/Comoro\",\"Africa/Nairobi|Indian/Mayotte\",\"Africa/Tripoli|Libya\",\"America/Adak|America/Atka\",\"America/Adak|US/Aleutian\",\"America/Anchorage|US/Alaska\",\"America/Argentina/Buenos_Aires|America/Buenos_Aires\",\"America/Argentina/Catamarca|America/Argentina/ComodRivadavia\",\"America/Argentina/Catamarca|America/Catamarca\",\"America/Argentina/Cordoba|America/Cordoba\",\"America/Argentina/Cordoba|America/Rosario\",\"America/Argentina/Jujuy|America/Jujuy\",\"America/Argentina/Mendoza|America/Mendoza\",\"America/Atikokan|America/Coral_Harbour\",\"America/Chicago|US/Central\",\"America/Curacao|America/Aruba\",\"America/Curacao|America/Kralendijk\",\"America/Curacao|America/Lower_Princes\",\"America/Denver|America/Shiprock\",\"America/Denver|Navajo\",\"America/Denver|US/Mountain\",\"America/Detroit|US/Michigan\",\"America/Edmonton|Canada/Mountain\",\"America/Fort_Wayne|America/Indiana/Indianapolis\",\"America/Fort_Wayne|America/Indianapolis\",\"America/Fort_Wayne|US/East-Indiana\",\"America/Halifax|Canada/Atlantic\",\"America/Havana|Cuba\",\"America/Indiana/Knox|America/Knox_IN\",\"America/Indiana/Knox|US/Indiana-Starke\",\"America/Jamaica|Jamaica\",\"America/Kentucky/Louisville|America/Louisville\",\"America/Los_Angeles|US/Pacific\",\"America/Los_Angeles|US/Pacific-New\",\"America/Manaus|Brazil/West\",\"America/Mazatlan|Mexico/BajaSur\",\"America/Mexico_City|Mexico/General\",\"America/New_York|US/Eastern\",\"America/Noronha|Brazil/DeNoronha\",\"America/Panama|America/Cayman\",\"America/Phoenix|US/Arizona\",\"America/Port_of_Spain|America/Anguilla\",\"America/Port_of_Spain|America/Antigua\",\"America/Port_of_Spain|America/Dominica\",\"America/Port_of_Spain|America/Grenada\",\"America/Port_of_Spain|America/Guadeloupe\",\"America/Port_of_Spain|America/Marigot\",\"America/Port_of_Spain|America/Montserrat\",\"America/Port_of_Spain|America/St_Barthelemy\",\"America/Port_of_Spain|America/St_Kitts\",\"America/Port_of_Spain|America/St_Lucia\",\"America/Port_of_Spain|America/St_Thomas\",\"America/Port_of_Spain|America/St_Vincent\",\"America/Port_of_Spain|America/Tortola\",\"America/Port_of_Spain|America/Virgin\",\"America/Regina|Canada/East-Saskatchewan\",\"America/Regina|Canada/Saskatchewan\",\"America/Rio_Branco|America/Porto_Acre\",\"America/Rio_Branco|Brazil/Acre\",\"America/Santiago|Chile/Continental\",\"America/Sao_Paulo|Brazil/East\",\"America/St_Johns|Canada/Newfoundland\",\"America/Tijuana|America/Ensenada\",\"America/Tijuana|America/Santa_Isabel\",\"America/Tijuana|Mexico/BajaNorte\",\"America/Toronto|America/Montreal\",\"America/Toronto|Canada/Eastern\",\"America/Vancouver|Canada/Pacific\",\"America/Whitehorse|Canada/Yukon\",\"America/Winnipeg|Canada/Central\",\"Asia/Ashgabat|Asia/Ashkhabad\",\"Asia/Bangkok|Asia/Phnom_Penh\",\"Asia/Bangkok|Asia/Vientiane\",\"Asia/Dhaka|Asia/Dacca\",\"Asia/Dubai|Asia/Muscat\",\"Asia/Ho_Chi_Minh|Asia/Saigon\",\"Asia/Hong_Kong|Hongkong\",\"Asia/Jerusalem|Asia/Tel_Aviv\",\"Asia/Jerusalem|Israel\",\"Asia/Kathmandu|Asia/Katmandu\",\"Asia/Kolkata|Asia/Calcutta\",\"Asia/Macau|Asia/Macao\",\"Asia/Makassar|Asia/Ujung_Pandang\",\"Asia/Nicosia|Europe/Nicosia\",\"Asia/Qatar|Asia/Bahrain\",\"Asia/Riyadh|Asia/Aden\",\"Asia/Riyadh|Asia/Kuwait\",\"Asia/Seoul|ROK\",\"Asia/Shanghai|Asia/Chongqing\",\"Asia/Shanghai|Asia/Chungking\",\"Asia/Shanghai|Asia/Harbin\",\"Asia/Shanghai|PRC\",\"Asia/Singapore|Singapore\",\"Asia/Taipei|ROC\",\"Asia/Tehran|Iran\",\"Asia/Thimphu|Asia/Thimbu\",\"Asia/Tokyo|Japan\",\"Asia/Ulaanbaatar|Asia/Ulan_Bator\",\"Asia/Urumqi|Asia/Kashgar\",\"Atlantic/Faroe|Atlantic/Faeroe\",\"Atlantic/Reykjavik|Iceland\",\"Australia/Adelaide|Australia/South\",\"Australia/Brisbane|Australia/Queensland\",\"Australia/Broken_Hill|Australia/Yancowinna\",\"Australia/Darwin|Australia/North\",\"Australia/Hobart|Australia/Tasmania\",\"Australia/Lord_Howe|Australia/LHI\",\"Australia/Melbourne|Australia/Victoria\",\"Australia/Perth|Australia/West\",\"Australia/Sydney|Australia/ACT\",\"Australia/Sydney|Australia/Canberra\",\"Australia/Sydney|Australia/NSW\",\"Etc/GMT+0|Etc/GMT\",\"Etc/GMT+0|Etc/GMT-0\",\"Etc/GMT+0|Etc/GMT0\",\"Etc/GMT+0|Etc/Greenwich\",\"Etc/GMT+0|GMT\",\"Etc/GMT+0|GMT+0\",\"Etc/GMT+0|GMT-0\",\"Etc/GMT+0|GMT0\",\"Etc/GMT+0|Greenwich\",\"Etc/UCT|UCT\",\"Etc/UTC|Etc/Universal\",\"Etc/UTC|Etc/Zulu\",\"Etc/UTC|UTC\",\"Etc/UTC|Universal\",\"Etc/UTC|Zulu\",\"Europe/Belgrade|Europe/Ljubljana\",\"Europe/Belgrade|Europe/Podgorica\",\"Europe/Belgrade|Europe/Sarajevo\",\"Europe/Belgrade|Europe/Skopje\",\"Europe/Belgrade|Europe/Zagreb\",\"Europe/Chisinau|Europe/Tiraspol\",\"Europe/Dublin|Eire\",\"Europe/Helsinki|Europe/Mariehamn\",\"Europe/Istanbul|Asia/Istanbul\",\"Europe/Istanbul|Turkey\",\"Europe/Lisbon|Portugal\",\"Europe/London|Europe/Belfast\",\"Europe/London|Europe/Guernsey\",\"Europe/London|Europe/Isle_of_Man\",\"Europe/London|Europe/Jersey\",\"Europe/London|GB\",\"Europe/London|GB-Eire\",\"Europe/Moscow|W-SU\",\"Europe/Oslo|Arctic/Longyearbyen\",\"Europe/Oslo|Atlantic/Jan_Mayen\",\"Europe/Prague|Europe/Bratislava\",\"Europe/Rome|Europe/San_Marino\",\"Europe/Rome|Europe/Vatican\",\"Europe/Warsaw|Poland\",\"Europe/Zurich|Europe/Busingen\",\"Europe/Zurich|Europe/Vaduz\",\"Pacific/Auckland|Antarctica/McMurdo\",\"Pacific/Auckland|Antarctica/South_Pole\",\"Pacific/Auckland|NZ\",\"Pacific/Chatham|NZ-CHAT\",\"Pacific/Chuuk|Pacific/Truk\",\"Pacific/Chuuk|Pacific/Yap\",\"Pacific/Easter|Chile/EasterIsland\",\"Pacific/Guam|Pacific/Saipan\",\"Pacific/Honolulu|Pacific/Johnston\",\"Pacific/Honolulu|US/Hawaii\",\"Pacific/Kwajalein|Kwajalein\",\"Pacific/Pago_Pago|Pacific/Midway\",\"Pacific/Pago_Pago|Pacific/Samoa\",\"Pacific/Pago_Pago|US/Samoa\",\"Pacific/Pohnpei|Pacific/Ponape\"]}),a});\n","es6-collections.js":"(function (exports) {'use strict';\n  //shared pointer\n  var i;\n  //shortcuts\n  var defineProperty = Object.defineProperty, is = function(a,b) { return isNaN(a)? isNaN(b): a === b; };\n\n\n  //Polyfill global objects\n  if (typeof WeakMap == 'undefined') {\n    exports.WeakMap = createCollection({\n      // WeakMap#delete(key:void*):boolean\n      'delete': sharedDelete,\n      // WeakMap#clear():\n      clear: sharedClear,\n      // WeakMap#get(key:void*):void*\n      get: sharedGet,\n      // WeakMap#has(key:void*):boolean\n      has: mapHas,\n      // WeakMap#set(key:void*, value:void*):void\n      set: sharedSet\n    }, true);\n  }\n\n  if (typeof Map == 'undefined' || typeof ((new Map).values) !== 'function' || !(new Map).values().next) {\n    exports.Map = createCollection({\n      // WeakMap#delete(key:void*):boolean\n      'delete': sharedDelete,\n      //:was Map#get(key:void*[, d3fault:void*]):void*\n      // Map#has(key:void*):boolean\n      has: mapHas,\n      // Map#get(key:void*):boolean\n      get: sharedGet,\n      // Map#set(key:void*, value:void*):void\n      set: sharedSet,\n      // Map#keys(void):Iterator\n      keys: sharedKeys,\n      // Map#values(void):Iterator\n      values: sharedValues,\n      // Map#entries(void):Iterator\n      entries: mapEntries,\n      // Map#forEach(callback:Function, context:void*):void ==> callback.call(context, key, value, mapObject) === not in specs`\n      forEach: sharedForEach,\n      // Map#clear():\n      clear: sharedClear\n    });\n  }\n\n  if (typeof Set == 'undefined' || typeof ((new Set).values) !== 'function' || !(new Set).values().next) {\n    exports.Set = createCollection({\n      // Set#has(value:void*):boolean\n      has: setHas,\n      // Set#add(value:void*):boolean\n      add: sharedAdd,\n      // Set#delete(key:void*):boolean\n      'delete': sharedDelete,\n      // Set#clear():\n      clear: sharedClear,\n      // Set#keys(void):Iterator\n      keys: sharedValues, // specs actually say \"the same function object as the initial value of the values property\"\n      // Set#values(void):Iterator\n      values: sharedValues,\n      // Set#entries(void):Iterator\n      entries: setEntries,\n      // Set#forEach(callback:Function, context:void*):void ==> callback.call(context, value, index) === not in specs\n      forEach: sharedForEach\n    });\n  }\n\n  if (typeof WeakSet == 'undefined') {\n    exports.WeakSet = createCollection({\n      // WeakSet#delete(key:void*):boolean\n      'delete': sharedDelete,\n      // WeakSet#add(value:void*):boolean\n      add: sharedAdd,\n      // WeakSet#clear():\n      clear: sharedClear,\n      // WeakSet#has(value:void*):boolean\n      has: setHas\n    }, true);\n  }\n\n\n  /**\n   * ES6 collection constructor\n   * @return {Function} a collection class\n   */\n  function createCollection(proto, objectOnly){\n    function Collection(a){\n      if (!this || this.constructor !== Collection) return new Collection(a);\n      this._keys = [];\n      this._values = [];\n      this._itp = []; // iteration pointers\n      this.objectOnly = objectOnly;\n\n      //parse initial iterable argument passed\n      if (a) init.call(this, a);\n    }\n\n    //define size for non object-only collections\n    if (!objectOnly) {\n      defineProperty(proto, 'size', {\n        get: sharedSize\n      });\n    }\n\n    //set prototype\n    proto.constructor = Collection;\n    Collection.prototype = proto;\n\n    return Collection;\n  }\n\n\n  /** parse initial iterable argument passed */\n  function init(a){\n    var i;\n    //init Set argument, like `[1,2,3,{}]`\n    if (this.add)\n      a.forEach(this.add, this);\n    //init Map argument like `[[1,2], [{}, 4]]`\n    else\n      a.forEach(function(a){this.set(a[0],a[1])}, this);\n  }\n\n\n  /** delete */\n  function sharedDelete(key) {\n    if (this.has(key)) {\n      this._keys.splice(i, 1);\n      this._values.splice(i, 1);\n      // update iteration pointers\n      this._itp.forEach(function(p) { if (i < p[0]) p[0]--; });\n    }\n    // Aurora here does it while Canary doesn't\n    return -1 < i;\n  };\n\n  function sharedGet(key) {\n    return this.has(key) ? this._values[i] : undefined;\n  }\n\n  function has(list, key) {\n    if (this.objectOnly && key !== Object(key))\n      throw new TypeError(\"Invalid value used as weak collection key\");\n    //NaN or 0 passed\n    if (key != key || key === 0) for (i = list.length; i-- && !is(list[i], key);){}\n    else i = list.indexOf(key);\n    return -1 < i;\n  }\n\n  function setHas(value) {\n    return has.call(this, this._values, value);\n  }\n\n  function mapHas(value) {\n    return has.call(this, this._keys, value);\n  }\n\n  /** @chainable */\n  function sharedSet(key, value) {\n    this.has(key) ?\n      this._values[i] = value\n      :\n      this._values[this._keys.push(key) - 1] = value\n    ;\n    return this;\n  }\n\n  /** @chainable */\n  function sharedAdd(value) {\n    if (!this.has(value)) this._values.push(value);\n    return this;\n  }\n\n  function sharedClear() {\n    this._values.length = 0;\n  }\n\n  /** keys, values, and iterate related methods */\n  function sharedKeys() {\n    return sharedIterator(this._itp, this._keys);\n  }\n\n  function sharedValues() {\n    return sharedIterator(this._itp, this._values);\n  }\n\n  function mapEntries() {\n    return sharedIterator(this._itp, this._keys, this._values);\n  }\n\n  function setEntries() {\n    return sharedIterator(this._itp, this._values, this._values);\n  }\n\n  function sharedIterator(itp, array, array2) {\n    var p = [0], done = false;\n    itp.push(p);\n    return {\n      next: function() {\n        var v, k = p[0];\n        if (!done && k < array.length) {\n          v = array2 ? [array[k], array2[k]]: array[k];\n          p[0]++;\n        } else {\n          done = true;\n          itp.splice(itp.indexOf(p), 1);\n        }\n        return { done: done, value: v };\n      }\n    };\n  }\n\n  function sharedSize() {\n    return this._values.length;\n  }\n\n  function sharedForEach(callback, context) {\n    var it = this.entries();\n    for (;;) {\n      var r = it.next();\n      if (r.done) break;\n      callback.call(context, r.value[1], r.value[0], this);\n    }\n  }\n\n})(typeof exports != 'undefined' && typeof global != 'undefined' ? global : window );","matchMedia.js":"/*! matchMedia() polyfill - Test a CSS media type/query in JS. Authors & copyright (c) 2012: Scott Jehl, Paul Irish, Nicholas Zakas, David Knight. Dual MIT/BSD license */\n\nwindow.matchMedia || (window.matchMedia = function() {\n    \"use strict\";\n\n    // For browsers that support matchMedium api such as IE 9 and webkit\n    var styleMedia = (window.styleMedia || window.media);\n\n    // For those that don't support matchMedium\n    if (!styleMedia) {\n        var style = document.createElement('style'),\n            script = document.getElementsByTagName('script')[0],\n            info = null;\n\n        style.type = 'text/css';\n        style.id = 'matchmediajs-test';\n\n        script.parentNode.insertBefore(style, script);\n\n        // 'style.currentStyle' is used by IE <= 8 and 'window.getComputedStyle' for all other browsers\n        info = ('getComputedStyle' in window) && window.getComputedStyle(style, null) || style.currentStyle;\n\n        styleMedia = {\n            matchMedium: function(media) {\n                var text = '@media ' + media + '{ #matchmediajs-test { width: 1px; } }';\n\n                // 'style.styleSheet' is used by IE <= 8 and 'style.textContent' for all other browsers\n                if (style.styleSheet) {\n                    style.styleSheet.cssText = text;\n                } else {\n                    style.textContent = text;\n                }\n\n                // Test if media query is true or false\n                return info.width === '1px';\n            }\n        };\n    }\n\n    return function(media) {\n        return {\n            matches: styleMedia.matchMedium(media || 'all'),\n            media: media || 'all'\n        };\n    };\n}());\n\n/*! matchMedia() polyfill addListener/removeListener extension. Author & copyright (c) 2012: Scott Jehl. Dual MIT/BSD license */\n(function() {\n    // Bail out for browsers that have addListener support\n    if (window.matchMedia && window.matchMedia('all').addListener) {\n        return false;\n    }\n\n    var localMatchMedia = window.matchMedia,\n        hasMediaQueries = localMatchMedia('only all').matches,\n        isListening = false,\n        timeoutID = 0, // setTimeout for debouncing 'handleChange'\n        queries = [], // Contains each 'mql' and associated 'listeners' if 'addListener' is used\n        handleChange = function(evt) {\n            // Debounce\n            clearTimeout(timeoutID);\n\n            timeoutID = setTimeout(function() {\n                for (var i = 0, il = queries.length; i < il; i++) {\n                    var mql = queries[i].mql,\n                        listeners = queries[i].listeners || [],\n                        matches = localMatchMedia(mql.media).matches;\n\n                    // Update mql.matches value and call listeners\n                    // Fire listeners only if transitioning to or from matched state\n                    if (matches !== mql.matches) {\n                        mql.matches = matches;\n\n                        for (var j = 0, jl = listeners.length; j < jl; j++) {\n                            listeners[j].call(window, mql);\n                        }\n                    }\n                }\n            }, 30);\n        };\n\n    window.matchMedia = function(media) {\n        var mql = localMatchMedia(media),\n            listeners = [],\n            index = 0;\n\n        mql.addListener = function(listener) {\n            // Changes would not occur to css media type so return now (Affects IE <= 8)\n            if (!hasMediaQueries) {\n                return;\n            }\n\n            // Set up 'resize' listener for browsers that support CSS3 media queries (Not for IE <= 8)\n            // There should only ever be 1 resize listener running for performance\n            if (!isListening) {\n                isListening = true;\n                window.addEventListener('resize', handleChange, true);\n            }\n\n            // Push object only if it has not been pushed already\n            if (index === 0) {\n                index = queries.push({\n                    mql: mql,\n                    listeners: listeners\n                });\n            }\n\n            listeners.push(listener);\n        };\n\n        mql.removeListener = function(listener) {\n            for (var i = 0, il = listeners.length; i < il; i++) {\n                if (listeners[i] === listener) {\n                    listeners.splice(i, 1);\n                }\n            }\n        };\n\n        return mql;\n    };\n}());\n\nwindow.mediaCheck = function(options) {\n    var mq;\n\n    function mqChange(mq, options) {\n        if (mq.matches) {\n            if (typeof options.entry === \"function\") {\n                options.entry();\n            }\n        } else if (typeof options.exit === \"function\") {\n            options.exit();\n        }\n    };\n\n    mq = window.matchMedia(options.media);\n\n    mq.addListener(function() {\n        mqChange(mq, options);\n    });\n\n    mqChange(mq, options);\n};","requirejs-min-resolver.js":"    (function () {\n        var ctx = require.s.contexts._,\n            origNameToUrl = ctx.nameToUrl,\n            baseUrl = ctx.config.baseUrl;\n\n        ctx.nameToUrl = function() {\n            var url = origNameToUrl.apply(ctx, arguments);\n            if (url.indexOf(baseUrl)===0&&!url.match(/\\/tiny_mce\\//)&&!url.match(/\\/v1\\/songbird/)&&!url.match(/\\/pay.google.com\\//)) {\n                url = url.replace(/(\\.min)?\\.js$/, '.min.js');\n            }\n            return url;\n        };\n    })();","requirejs-config.js":"(function(require){\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    waitSeconds: 0,\n    map: {\n        '*': {\n            'ko': 'knockoutjs/knockout',\n            'knockout': 'knockoutjs/knockout',\n            'mageUtils': 'mage/utils/main',\n            'rjsResolver': 'mage/requirejs/resolver'\n        }\n    },\n    shim: {\n        'jquery/jquery-migrate': ['jquery'],\n        'jquery/jstree/jquery.hotkeys': ['jquery'],\n        'jquery/hover-intent': ['jquery'],\n        'mage/adminhtml/backup': ['prototype'],\n        'mage/captcha': ['prototype'],\n        'mage/new-gallery': ['jquery'],\n        'mage/webapi': ['jquery'],\n        'jquery/ui': ['jquery'],\n        'MutationObserver': ['es6-collections'],\n        'matchMedia': {\n            'exports': 'mediaCheck'\n        },\n        'magnifier/magnifier': ['jquery']\n    },\n    paths: {\n        'jquery/validate': 'jquery/jquery.validate',\n        'jquery/hover-intent': 'jquery/jquery.hoverIntent',\n        'jquery/file-uploader': 'jquery/fileUploader/jquery.fileuploader',\n        'prototype': 'legacy-build.min',\n        'jquery/jquery-storageapi': 'jquery/jquery.storageapi.min',\n        'text': 'mage/requirejs/text',\n        'domReady': 'requirejs/domReady',\n        'spectrum': 'jquery/spectrum/spectrum',\n        'tinycolor': 'jquery/spectrum/tinycolor',\n        'jquery-ui-modules': 'jquery/ui-modules'\n    },\n    deps: [\n        'jquery/jquery-migrate'\n    ],\n    config: {\n        mixins: {\n            'jquery/jstree/jquery.jstree': {\n                'mage/backend/jstree-mixin': true\n            },\n            'jquery': {\n                'jquery/patches/jquery': true\n            }\n        },\n        text: {\n            'headers': {\n                'X-Requested-With': 'XMLHttpRequest'\n            }\n        }\n    }\n};\n\nrequire(['jquery'], function ($) {\n    'use strict';\n\n    $.noConflict();\n});\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            'rowBuilder':             'Magento_Theme/js/row-builder',\n            'toggleAdvanced':         'mage/toggle',\n            'translateInline':        'mage/translate-inline',\n            'sticky':                 'mage/sticky',\n            'tabs':                   'mage/tabs',\n            'zoom':                   'mage/zoom',\n            'collapsible':            'mage/collapsible',\n            'dropdownDialog':         'mage/dropdown',\n            'dropdown':               'mage/dropdowns',\n            'accordion':              'mage/accordion',\n            'loader':                 'mage/loader',\n            'tooltip':                'mage/tooltip',\n            'deletableItem':          'mage/deletable-item',\n            'itemTable':              'mage/item-table',\n            'fieldsetControls':       'mage/fieldset-controls',\n            'fieldsetResetControl':   'mage/fieldset-controls',\n            'redirectUrl':            'mage/redirect-url',\n            'loaderAjax':             'mage/loader',\n            'menu':                   'mage/menu',\n            'popupWindow':            'mage/popup-window',\n            'validation':             'mage/validation/validation',\n            'breadcrumbs':            'Magento_Theme/js/view/breadcrumbs',\n            'jquery/ui':              'jquery/compat',\n            'cookieStatus':           'Magento_Theme/js/cookie-status'\n        }\n    },\n    deps: [\n        'jquery/jquery.mobile.custom',\n        'mage/common',\n        'mage/dataPost',\n        'mage/bootstrap'\n    ],\n    config: {\n        mixins: {\n            'Magento_Theme/js/view/breadcrumbs': {\n                'Magento_Theme/js/view/add-home-breadcrumb': true\n            },\n            'jquery/ui-modules/dialog': {\n                'jquery/patches/jquery-ui': true\n            }\n        }\n    }\n};\n\n/* eslint-disable max-depth */\n/**\n * Adds polyfills only for browser contexts which prevents bundlers from including them.\n */\nif (typeof window !== 'undefined' && window.document) {\n    /**\n     * Polyfill localStorage and sessionStorage for browsers that do not support them.\n     */\n    try {\n        if (!window.localStorage || !window.sessionStorage) {\n            throw new Error();\n        }\n\n        localStorage.setItem('storage_test', 1);\n        localStorage.removeItem('storage_test');\n    } catch (e) {\n        config.deps.push('mage/polyfill');\n    }\n}\n/* eslint-enable max-depth */\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            quickSearch: 'Magento_Search/js/form-mini',\n            'Magento_Search/form-mini': 'Magento_Search/js/form-mini'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            checkoutBalance:    'Magento_Customer/js/checkout-balance',\n            address:            'Magento_Customer/js/address',\n            changeEmailPassword: 'Magento_Customer/js/change-email-password',\n            passwordStrengthIndicator: 'Magento_Customer/js/password-strength-indicator',\n            zxcvbn: 'Magento_Customer/js/zxcvbn',\n            addressValidation: 'Magento_Customer/js/addressValidation',\n            showPassword: 'Magento_Customer/js/show-password',\n            'Magento_Customer/address': 'Magento_Customer/js/address',\n            'Magento_Customer/change-email-password': 'Magento_Customer/js/change-email-password'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            escaper: 'Magento_Security/js/escaper'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            priceBox:             'Magento_Catalog/js/price-box',\n            priceOptionDate:      'Magento_Catalog/js/price-option-date',\n            priceOptionFile:      'Magento_Catalog/js/price-option-file',\n            priceOptions:         'Magento_Catalog/js/price-options',\n            priceUtils:           'Magento_Catalog/js/price-utils'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            compareList:            'Magento_Catalog/js/list',\n            relatedProducts:        'Magento_Catalog/js/related-products',\n            upsellProducts:         'Magento_Catalog/js/upsell-products',\n            productListToolbarForm: 'Magento_Catalog/js/product/list/toolbar',\n            catalogGallery:         'Magento_Catalog/js/gallery',\n            catalogAddToCart:       'Magento_Catalog/js/catalog-add-to-cart'\n        }\n    },\n    config: {\n        mixins: {\n            'Magento_Theme/js/view/breadcrumbs': {\n                'Magento_Catalog/js/product/breadcrumbs': true\n            }\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            addToCart: 'Magento_Msrp/js/msrp'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            catalogSearch: 'Magento_CatalogSearch/form-mini'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            creditCardType: 'Magento_Payment/js/cc-type',\n            'Magento_Payment/cc-type': 'Magento_Payment/js/cc-type'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            giftMessage:    'Magento_Sales/js/gift-message',\n            ordersReturns:  'Magento_Sales/js/orders-returns',\n            'Magento_Sales/gift-message':    'Magento_Sales/js/gift-message',\n            'Magento_Sales/orders-returns':  'Magento_Sales/js/orders-returns'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            discountCode:           'Magento_Checkout/js/discount-codes',\n            shoppingCart:           'Magento_Checkout/js/shopping-cart',\n            regionUpdater:          'Magento_Checkout/js/region-updater',\n            sidebar:                'Magento_Checkout/js/sidebar',\n            checkoutLoader:         'Magento_Checkout/js/checkout-loader',\n            checkoutData:           'Magento_Checkout/js/checkout-data',\n            proceedToCheckout:      'Magento_Checkout/js/proceed-to-checkout',\n            catalogAddToCart:       'Magento_Catalog/js/catalog-add-to-cart'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            requireCookie: 'Magento_Cookie/js/require-cookie',\n            cookieNotices: 'Magento_Cookie/js/notices'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    paths: {\n        'jquery/jquery-storageapi': 'Magento_Cookie/js/jquery.storageapi.extended'\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            downloadable: 'Magento_Downloadable/js/downloadable',\n            'Magento_Downloadable/downloadable': 'Magento_Downloadable/js/downloadable'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            bundleOption:   'Magento_Bundle/bundle',\n            priceBundle:    'Magento_Bundle/js/price-bundle',\n            slide:          'Magento_Bundle/js/slide',\n            productSummary: 'Magento_Bundle/js/product-summary'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            giftOptions:    'Magento_GiftMessage/js/gift-options',\n            extraOptions:   'Magento_GiftMessage/js/extra-options',\n            'Magento_GiftMessage/gift-options':    'Magento_GiftMessage/js/gift-options',\n            'Magento_GiftMessage/extra-options':   'Magento_GiftMessage/js/extra-options'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    deps: [],\n    shim: {\n        'chartjs/Chart.min': ['moment'],\n        'tiny_mce_4/tinymce.min': {\n            exports: 'tinyMCE'\n        }\n    },\n    paths: {\n        'ui/template': 'Magento_Ui/templates'\n    },\n    map: {\n        '*': {\n            uiElement:      'Magento_Ui/js/lib/core/element/element',\n            uiCollection:   'Magento_Ui/js/lib/core/collection',\n            uiComponent:    'Magento_Ui/js/lib/core/collection',\n            uiClass:        'Magento_Ui/js/lib/core/class',\n            uiEvents:       'Magento_Ui/js/lib/core/events',\n            uiRegistry:     'Magento_Ui/js/lib/registry/registry',\n            consoleLogger:  'Magento_Ui/js/lib/logger/console-logger',\n            uiLayout:       'Magento_Ui/js/core/renderer/layout',\n            buttonAdapter:  'Magento_Ui/js/form/button-adapter',\n            chartJs:        'chartjs/Chart.min',\n            tinymce4:       'tiny_mce_4/tinymce.min',\n            wysiwygAdapter: 'mage/adminhtml/wysiwyg/tiny_mce/tinymce4Adapter'\n        }\n    }\n};\n\n/**\n * Adds polyfills only for browser contexts which prevents bundlers from including them.\n */\nif (typeof window !== 'undefined' && window.document) {\n    /**\n     * Polyfill Map and WeakMap for older browsers that do not support them.\n     */\n    if (typeof Map === 'undefined' || typeof WeakMap === 'undefined') {\n        config.deps.push('es6-collections');\n    }\n\n    /**\n     * Polyfill MutationObserver only for the browsers that do not support it.\n     */\n    if (typeof MutationObserver === 'undefined') {\n        config.deps.push('MutationObserver');\n    }\n\n    /**\n     * Polyfill FormData object for old browsers that don't have full support for it.\n     */\n    if (typeof FormData === 'undefined' || typeof FormData.prototype.get === 'undefined') {\n        config.deps.push('FormData');\n    }\n}\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            pageCache:  'Magento_PageCache/js/page-cache'\n        }\n    },\n    deps: ['Magento_PageCache/js/form-key-provider']\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            captcha: 'Magento_Captcha/js/captcha',\n            'Magento_Captcha/captcha': 'Magento_Captcha/js/captcha'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            configurable: 'Magento_ConfigurableProduct/js/configurable'\n        }\n    },\n    config: {\n        mixins: {\n            'Magento_Catalog/js/catalog-add-to-cart': {\n                'Magento_ConfigurableProduct/js/catalog-add-to-cart-mixin': true\n            }\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            multiShipping: 'Magento_Multishipping/js/multi-shipping',\n            orderOverview: 'Magento_Multishipping/js/overview',\n            payment: 'Magento_Multishipping/js/payment',\n            billingLoader: 'Magento_Checkout/js/checkout-loader',\n            cartUpdate: 'Magento_Checkout/js/action/update-shopping-cart',\n            multiShippingBalance: 'Magento_Multishipping/js/multi-shipping-balance'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            recentlyViewedProducts: 'Magento_Reports/js/recently-viewed'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\nvar config = {\n    config: {\n        mixins: {\n            'Magento_Checkout/js/model/quote': {\n                'Magento_InventoryInStorePickupFrontend/js/model/quote-ext': true\n            },\n            'Magento_Checkout/js/view/shipping-information': {\n                'Magento_InventoryInStorePickupFrontend/js/view/shipping-information-ext': true\n            },\n            'Magento_Checkout/js/model/checkout-data-resolver': {\n                'Magento_InventoryInStorePickupFrontend/js/model/checkout-data-resolver-ext': true\n            },\n            'Magento_Checkout/js/checkout-data': {\n                'Magento_InventoryInStorePickupFrontend/js/checkout-data-ext': true\n            }\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    config: {\n        mixins: {\n            'Magento_Swatches/js/swatch-renderer': {\n                'Magento_InventorySwatchesFrontendUi/js/swatch-renderer': true\n            }\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            subscriptionStatusResolver: 'Magento_Newsletter/js/subscription-status-resolver',\n            newsletterSignUp:  'Magento_Newsletter/js/newsletter-sign-up'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    config: {\n        mixins: {\n            'Magento_Checkout/js/action/select-payment-method': {\n                'Magento_SalesRule/js/action/select-payment-method-mixin': true\n            },\n            'Magento_Checkout/js/model/shipping-save-processor': {\n                'Magento_SalesRule/js/model/shipping-save-processor-mixin': true\n            },\n            'Magento_Checkout/js/action/place-order': {\n                'Magento_SalesRule/js/model/place-order-mixin': true\n            }\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            'slick': 'Magento_PageBuilder/js/resource/slick/slick',\n            'jarallax': 'Magento_PageBuilder/js/resource/jarallax/jarallax',\n            'jarallaxVideo': 'Magento_PageBuilder/js/resource/jarallax/jarallax-video',\n            'vimeo': 'Magento_PageBuilder/js/resource/vimeo/player',\n            'vimeoWrapper': 'Magento_PageBuilder/js/resource/vimeo/vimeo-wrapper'\n        }\n    },\n    shim: {\n        'Magento_PageBuilder/js/resource/slick/slick': {\n            deps: ['jquery']\n        },\n        'Magento_PageBuilder/js/resource/jarallax/jarallax-video': {\n            deps: ['jarallax', 'vimeoWrapper']\n        },\n        'Magento_PageBuilder/js/resource/vimeo/player': {\n            exports: ['Player']\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    shim: {\n        cardinaljs: {\n            exports: 'Cardinal'\n        },\n        cardinaljsSandbox: {\n            exports: 'Cardinal'\n        }\n    },\n    paths: {\n        cardinaljsSandbox: 'https://includestest.ccdc02.com/cardinalcruise/v1/songbird',\n        cardinaljs: 'https://songbird.cardinalcommerce.com/edge/v1/songbird'\n    }\n};\n\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            transparent: 'Magento_Payment/js/transparent',\n            'Magento_Payment/transparent': 'Magento_Payment/js/transparent'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            orderReview: 'Magento_Paypal/js/order-review',\n            'Magento_Paypal/order-review': 'Magento_Paypal/js/order-review',\n            paypalCheckout: 'Magento_Paypal/js/paypal-checkout'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    config: {\n        mixins: {\n            'Magento_Customer/js/customer-data': {\n                'Magento_Persistent/js/view/customer-data-mixin': true\n            }\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            loadPlayer: 'Magento_ProductVideo/js/load-player',\n            fotoramaVideoEvents: 'Magento_ProductVideo/js/fotorama-add-video-events'\n        }\n    },\n    shim: {\n        vimeoAPI: {}\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    config: {\n        mixins: {\n            'Magento_Checkout/js/action/place-order': {\n                'Magento_CheckoutAgreements/js/model/place-order-mixin': true\n            },\n            'Magento_Checkout/js/action/set-payment-information': {\n                'Magento_CheckoutAgreements/js/model/set-payment-information-mixin': true\n            }\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n// eslint-disable-next-line no-unused-vars\nvar config = {\n    config: {\n        mixins: {\n            'Magento_Checkout/js/model/place-order': {\n                'Magento_ReCaptchaCheckout/js/model/place-order-mixin': true\n            }\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/*eslint strict: [\"error\", \"global\"]*/\n\n'use strict';\n\nvar config = {\n    config: {\n        mixins: {\n            'Magento_Ui/js/view/messages': {\n                'Magento_ReCaptchaFrontendUi/js/ui-messages-mixin': true\n            }\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n// eslint-disable-next-line no-unused-vars\nvar config = {\n    config: {\n        mixins: {\n            'Magento_Paypal/js/view/payment/method-renderer/payflowpro-method': {\n                'Magento_ReCaptchaPaypal/js/payflowpro-method-mixin': true\n            }\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n// eslint-disable-next-line no-unused-vars\nvar config = {\n    config: {\n        mixins: {\n            'jquery': {\n                'Magento_ReCaptchaWebapiUi/js/jquery-mixin': true\n            }\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            editTrigger: 'mage/edit-trigger',\n            addClass: 'Magento_Translation/js/add-class',\n            'Magento_Translation/add-class': 'Magento_Translation/js/add-class'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            mageTranslationDictionary: 'Magento_Translation/js/mage-translation-dictionary'\n        }\n    },\n    deps: [\n        'mageTranslationDictionary'\n    ]\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            configurableVariationQty: 'Magento_InventoryConfigurableProductFrontendUi/js/configurable-variation-qty'\n        }\n    },\n    config: {\n        mixins: {\n            'Magento_ConfigurableProduct/js/configurable': {\n                'Magento_InventoryConfigurableProductFrontendUi/js/configurable': true\n            }\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    config: {\n        mixins: {\n            'Magento_Checkout/js/view/payment/list': {\n                'Magento_PaypalCaptcha/js/view/payment/list-mixin': true\n            },\n            'Magento_Paypal/js/view/payment/method-renderer/payflowpro-method': {\n                'Magento_PaypalCaptcha/js/view/payment/method-renderer/payflowpro-method-mixin': true\n            },\n            'Magento_Captcha/js/view/checkout/defaultCaptcha': {\n                'Magento_PaypalCaptcha/js/view/checkout/defaultCaptcha-mixin': true\n            }\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            'taxToggle': 'Magento_Weee/js/tax-toggle',\n            'Magento_Weee/tax-toggle': 'Magento_Weee/js/tax-toggle'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            wishlist:       'Magento_Wishlist/js/wishlist',\n            addToWishlist:  'Magento_Wishlist/js/add-to-wishlist',\n            wishlistSearch: 'Magento_Wishlist/js/search'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright 2016 Amazon.com, Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\").\n * You may not use this file except in compliance with the License.\n * A copy of the License is located at\n *\n *  http://aws.amazon.com/apache2.0\n *\n * or in the \"license\" file accompanying this file. This file is distributed\n * on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either\n * express or implied. See the License for the specific language governing\n * permissions and limitations under the License.\n */\n\nvar config = {\n    map: {\n        '*': {\n            amazonLogout: 'Amazon_Login/js/amazon-logout',\n            amazonOAuthRedirect: 'Amazon_Login/js/amazon-redirect',\n            amazonCsrf: 'Amazon_Login/js/amazon-csrf'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright 2016 Amazon.com, Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\").\n * You may not use this file except in compliance with the License.\n * A copy of the License is located at\n *\n *  http://aws.amazon.com/apache2.0\n *\n * or in the \"license\" file accompanying this file. This file is distributed\n * on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either\n * express or implied. See the License for the specific language governing\n * permissions and limitations under the License.\n */\nvar config = {\n    map: {\n        '*': {\n            amazonCore: 'Amazon_Payment/js/amazon-core',\n            amazonWidgetsLoader: 'Amazon_Payment/js/amazon-widgets-loader',\n            amazonButton: 'Amazon_Payment/js/amazon-button',\n            amazonProductAdd: 'Amazon_Payment/js/amazon-product-add',\n            amazonPaymentConfig: 'Amazon_Payment/js/model/amazonPaymentConfig',\n            sjcl: 'Amazon_Payment/js/lib/sjcl.min'\n        }\n    },\n    config: {\n        mixins: {\n            'Amazon_Payment/js/action/place-order': {\n                'Amazon_Payment/js/model/place-order-mixin': true\n            },\n            'Magento_Tax/js/view/checkout/summary/grand-total': {\n                'Amazon_Payment/js/view/checkout/summary/grand-total-mixin': true\n            }\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\nvar config = {\n    paths: {\n        'intlTelInput': 'Dotdigitalgroup_Sms/js/intlTelInput',\n        'intlTelInputUtils': 'Dotdigitalgroup_Sms/js/utils',\n        'internationalTelephoneInput': 'Dotdigitalgroup_Sms/js/internationalTelephoneInput'\n    },\n\n    shim: {\n        'intlTelInput': {\n            'deps': ['jquery', 'knockout']\n        },\n        'internationalTelephoneInput': {\n            'deps': ['jquery', 'intlTelInput']\n        }\n    },\n\n    config: {\n        mixins: {\n            'mage/validation': {\n                'Dotdigitalgroup_Sms/js/telephoneValidatorAddress': true\n            },\n            'Magento_Ui/js/form/element/abstract': {\n                'Dotdigitalgroup_Sms/js/setAdditionalParams': true\n            },\n            'Magento_Ui/js/lib/validation/validator': {\n                'Dotdigitalgroup_Sms/js/telephoneValidatorCheckout': true\n            }\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\nvar config = {\n    map: {\n        '*': {\n            baseowlcarousel: 'ET_Base/js/owl.carousel.min',\n            basecountdowntimer: 'ET_Base/js/countdown-timer.min'\n        }\n    }\n};\nrequire.config(config);\n})();\n(function() {\n/**\n * This file is part of the Klarna KP module\n *\n * (c) Klarna Bank AB (publ)\n *\n * For the full copyright and license information, please view the NOTICE\n * and LICENSE files that were distributed with this source code.\n */\nvar config = {\n    config: {\n        mixins: {\n            'Magento_Checkout/js/action/get-payment-information': {\n                'Klarna_Kp/js/action/override': true\n            }\n        }\n    },\n    map: {\n        '*': {\n            klarnapi: 'https://x.klarnacdn.net/kp/lib/v1/api.js'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * This file is part of the Klarna Onsitemessaging module\n *\n * (c) Klarna Bank AB (publ)\n *\n * For the full copyright and license information, please view the NOTICE\n * and LICENSE files that were distributed with this source code.\n */\nvar config = {\n    config: {\n        mixins: {\n            'Magento_Catalog/js/price-box': {\n                'Klarna_Onsitemessaging/js/pricebox-widget-mixin': true\n            }\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\r\n * Mageplaza\r\n *\r\n * NOTICE OF LICENSE\r\n *\r\n * This source file is subject to the mageplaza.com license that is\r\n * available through the world-wide-web at this URL:\r\n * https://www.mageplaza.com/LICENSE.txt\r\n *\r\n * DISCLAIMER\r\n *\r\n * Do not edit or add to this file if you wish to upgrade this extension to newer\r\n * version in the future.\r\n *\r\n * @category    Mageplaza\r\n * @package     Mageplaza_Core\r\n * @copyright   Copyright (c) Mageplaza (https://www.mageplaza.com/)\r\n * @license     https://www.mageplaza.com/LICENSE.txt\r\n */\r\n\r\nvar config = {\r\n    paths: {\r\n        'mageplaza/core/jquery/popup': 'Mageplaza_Core/js/jquery.magnific-popup.min',\r\n        'mageplaza/core/owl.carousel': 'Mageplaza_Core/js/owl.carousel.min',\r\n        'mageplaza/core/bootstrap': 'Mageplaza_Core/js/bootstrap.min',\r\n        mpIonRangeSlider: 'Mageplaza_Core/js/ion.rangeSlider.min',\r\n        touchPunch: 'Mageplaza_Core/js/jquery.ui.touch-punch.min',\r\n        mpDevbridgeAutocomplete: 'Mageplaza_Core/js/jquery.autocomplete.min'\r\n    },\r\n    shim: {\r\n        \"mageplaza/core/jquery/popup\": [\"jquery\"],\r\n        \"mageplaza/core/owl.carousel\": [\"jquery\"],\r\n        \"mageplaza/core/bootstrap\": [\"jquery\"],\r\n        mpIonRangeSlider: [\"jquery\"],\r\n        mpDevbridgeAutocomplete: [\"jquery\"],\r\n        touchPunch: ['jquery', 'jquery/ui']\r\n    }\r\n};\r\n\nrequire.config(config);\n})();\n(function() {\n/**\r\n * Mageplaza\r\n *\r\n * NOTICE OF LICENSE\r\n *\r\n * This source file is subject to the Mageplaza.com license that is\r\n * available through the world-wide-web at this URL:\r\n * https://www.mageplaza.com/LICENSE.txt\r\n *\r\n * DISCLAIMER\r\n *\r\n * Do not edit or add to this file if you wish to upgrade this extension to newer\r\n * version in the future.\r\n *\r\n * @category    Mageplaza\r\n * @package     Mageplaza_Reports\r\n * @copyright   Copyright (c) Mageplaza (https://www.mageplaza.com/)\r\n * @license     https://www.mageplaza.com/LICENSE.txt\r\n */\r\n\r\nvar config = {\r\n    paths: {\r\n        gridstack: 'Mageplaza_Reports/js/lib/gridstack',\r\n        gridstackJqueryUi: 'Mageplaza_Reports/js/lib/gridstack.jQueryUI',\r\n        daterangepicker: 'Mageplaza_Reports/js/lib/daterangepicker.min',\r\n        chartBundle: 'Mageplaza_Reports/js/lib/Chart.bundle.min',\r\n        initDateRange: 'Mageplaza_Reports/js/dashboard/initDateRange',\r\n        initGridStack: 'Mageplaza_Reports/js/dashboard/initGridStack',\r\n        initChart: 'Mageplaza_Reports/js/dashboard/initChart',\r\n    },\r\n    map: {\r\n        gridstack: {\r\n            'lodash': 'underscore'\r\n        },\r\n        gridstackJqueryUi: {\r\n            'lodash': 'underscore'\r\n        },\r\n        '*': {\r\n            moment: 'Mageplaza_Reports/js/lib/moment.min'\r\n        }\r\n    }\r\n};\r\n\nrequire.config(config);\n})();\n(function() {\nvar config = {\n    config: {\n        mixins: {\n            'Magento_Checkout/js/model/step-navigator': {\n                'PayPal_Braintree/js/model/step-navigator-mixin': true\n            },\n            'PayPal_Braintree/js/view/payment/method-renderer/cc-form': {\n                'PayPal_Braintree/js/reCaptcha/braintree-cc-method-mixin': true\n            }\n        }\n    },\n    map: {\n        '*': {\n            braintreeCheckoutPayPalAdapter: 'PayPal_Braintree/js/view/payment/adapter'\n        }\n    },\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Config to pull in all the relevant Braintree JS SDKs\n * @type {{paths: {braintreePayPalInContextCheckout: string, braintreePayPalCheckout: string, braintreeVenmo: string, braintreeHostedFields: string, braintreeDataCollector: string, braintreeThreeDSecure: string, braintreeGooglePay: string, braintreeApplePay: string, braintreeAch: string, braintreeLpm: string, googlePayLibrary: string}, map: {\"*\": {braintree: string}}}}\n */\nvar config = {\n    map: {\n        '*': {\n            braintree: 'https://js.braintreegateway.com/web/3.67.0/js/client.min.js',\n        }\n    },\n\n    paths: {\n        \"braintreePayPalCheckout\": \"https://js.braintreegateway.com/web/3.67.0/js/paypal-checkout.min\",\n        \"braintreeHostedFields\": \"https://js.braintreegateway.com/web/3.67.0/js/hosted-fields.min\",\n        \"braintreeDataCollector\": \"https://js.braintreegateway.com/web/3.67.0/js/data-collector.min\",\n        \"braintreeThreeDSecure\": \"https://js.braintreegateway.com/web/3.67.0/js/three-d-secure.min\",\n        \"braintreeApplePay\": 'https://js.braintreegateway.com/web/3.67.0/js/apple-pay.min',\n        \"braintreeGooglePay\": 'https://js.braintreegateway.com/web/3.67.0/js/google-payment.min',\n        \"braintreeVenmo\": 'https://js.braintreegateway.com/web/3.67.0/js/venmo.min',\n        \"braintreeAch\": \"https://js.braintreegateway.com/web/3.67.0/js/us-bank-account.min\",\n        \"braintreeLpm\": \"https://js.braintreegateway.com/web/3.67.0/js/local-payment.min\",\n        \"googlePayLibrary\": \"https://pay.google.com/gp/p/js/pay\",\n        \"braintreePayPalInContextCheckout\": \"https://www.paypalobjects.com/api/checkout\"\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\nvar config = {\n    map: {\n        '*': {\n            'plumrocket/utils': 'Plumrocket_Base/js/utils'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\nvar config = {\n    map: {\n        '*': {\n            'prProductFilter': 'Plumrocket_LayeredNavigationLite/js/init',\n            'prProductFilterSlider': 'Plumrocket_LayeredNavigationLite/js/view/price/slider',\n            'jquery/ui-touch-punch': 'Plumrocket_LayeredNavigationLite/js/jquery/jquery.ui.touch-punch.min',\n            'plumrocket/product-filter/action': 'Plumrocket_LayeredNavigationLite/js/model/filter-action',\n            'plumrocket/noUiSlider': 'Plumrocket_LayeredNavigationLite/js/lib/nouislider.min',\n        }\n    }\n};\nrequire.config(config);\n})();\n(function() {\n\r\nvar config = {\r\n    map: {\r\n        '*': {\r\n            punchout: 'Punchout2go_Punchout/js/punchout_script',\r\n        }\r\n    }\r\n};\r\n\nrequire.config(config);\n})();\n(function() {\nvar config = {\n    config: {\n        mixins: {\n            'Magento_Checkout/js/view/minicart': {\n                'Rahi_Customization/js/view/minicart-mixin': true\n            }\n        }\n    }\n};\nrequire.config(config);\n})();\n(function() {\nvar config = {\n    map: {\n        '*': {\n            cpowlcarousel: 'Solwin_Cpanel/js/owl.carousel',\n        }\n    }\n};\nrequire.config(config);\n})();\n(function() {\n/**\n * @copyright  Vertex. All rights reserved.  https://www.vertexinc.com/\n * @author     Mediotype                     https://www.mediotype.com/\n */\n\nvar config = {\n    map: {\n        '*': {\n            'set-checkout-messages': 'Vertex_Tax/js/model/set-checkout-messages'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * @copyright  Vertex. All rights reserved.  https://www.vertexinc.com/\n * @author     Mediotype                     https://www.mediotype.com/\n */\n\nvar config = {\n    config: {\n        mixins: {\n            'Magento_Checkout/js/view/billing-address': {\n                'Vertex_AddressValidation/js/billing-validation-mixin': true\n            },\n            'Magento_Checkout/js/view/shipping': {\n                'Vertex_AddressValidation/js/shipping-validation-mixin': true\n            },\n            'Magento_Checkout/js/checkout-data': {\n                'Vertex_AddressValidation/js/shipping-invalidate-mixin': true\n            },\n            'Magento_Customer/js/addressValidation': {\n                'Vertex_AddressValidation/js/customer-validation-mixin': true\n            }\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    deps: [\n        'Magento_Theme/js/theme'\n    ]\n};\n\nrequire.config(config);\n})();\n\n\n\n})(require);","FormData.js":"/*\n * FormData for XMLHttpRequest 2  -  Polyfill for Web Worker\n * (c) 2014 Rob Wu <rob@robwu.nl>\n * License: MIT\n * - append(name, value[, filename])\n * - XMLHttpRequest.prototype.send(object FormData)\n * \n * Specification: http://www.w3.org/TR/XMLHttpRequest/#formdata\n *                http://www.w3.org/TR/XMLHttpRequest/#the-send-method\n * The .append() implementation also accepts Uint8Array and ArrayBuffer objects\n * Web Workers do not natively support FormData:\n *                http://dev.w3.org/html5/workers/#apis-available-to-workers\n * Originally released in 2012 as a part of http://stackoverflow.com/a/10002486.\n * Updates since initial release:\n * - Forward-compatibility by testing whether FormData exists before defining it.\n * - Increased robustness of .append.\n * - Allow any typed array in .append.\n * - Remove use of String.prototype.toString to work around a Firefox bug.\n * - Use typed array in xhr.send instead of arraybuffer to get rid of deprecation\n *   warnings.\n **/\n(function(exports) {\n    if (exports.FormData) {\n        // Don't replace FormData if it already exists\n        return;\n    }\n    // Export variable to the global scope\n    exports.FormData = FormData;\n\n    var ___send$rw = XMLHttpRequest.prototype.send;\n    XMLHttpRequest.prototype.send = function(data) {\n        if (data instanceof FormData) {\n            if (!data.__endedMultipart) data.__append('--' + data.boundary + '--\\r\\n');\n            data.__endedMultipart = true;\n            this.setRequestHeader('Content-Type', 'multipart/form-data; boundary=' + data.boundary);\n            data = new Uint8Array(data.data);\n        }\n        // Invoke original XHR.send\n        return ___send$rw.call(this, data);\n    };\n\n    function FormData() {\n        // Force a Constructor\n        if (!(this instanceof FormData)) return new FormData();\n        // Generate a random boundary - This must be unique with respect to the form's contents.\n        this.boundary = '------RWWorkerFormDataBoundary' + Math.random().toString(36);\n        var internal_data = this.data = [];\n        /**\n         * Internal method.\n         * @param inp String | ArrayBuffer | Uint8Array  Input\n         */\n        this.__append = function(inp) {\n            var i = 0, len;\n            if (typeof inp == 'string') {\n                for (len = inp.length; i < len; ++i)\n                    internal_data.push(inp.charCodeAt(i) & 0xff);\n            } else if (inp && inp.byteLength) {/*If ArrayBuffer or typed array */\n                if (!('byteOffset' in inp))   /* If ArrayBuffer, wrap in view */\n                    inp = new Uint8Array(inp);\n                for (len = inp.byteLength; i < len; ++i)\n                    internal_data.push(inp[i] & 0xff);\n            }\n        };\n    }\n    /**\n     * @param name     String                                   Key name\n     * @param value    String|Blob|File|typed array|ArrayBuffer Value\n     * @param filename String                                   Optional File name (when value is not a string).\n     **/\n    FormData.prototype.append = function(name, value, filename) {\n        if (this.__endedMultipart) {\n            // Truncate the closing boundary\n            this.data.length -= this.boundary.length + 6;\n            this.__endedMultipart = false;\n        }\n        if (arguments.length < 2) {\n            throw new SyntaxError('Not enough arguments');\n        }\n        var part = '--' + this.boundary + '\\r\\n' +\n            'Content-Disposition: form-data; name=\"' + name + '\"';\n\n        if (value instanceof File || value instanceof Blob) {\n            return this.append(name,\n                new Uint8Array(new FileReaderSync().readAsArrayBuffer(value)),\n                filename || value.name);\n        } else if (typeof value.byteLength == 'number') {\n            // Duck-typed typed array or array buffer\n            part += '; filename=\"'+ (filename || 'blob').replace(/\"/g,'%22') +'\"\\r\\n';\n            part += 'Content-Type: application/octet-stream\\r\\n\\r\\n';\n            this.__append(part);\n            this.__append(value);\n            part = '\\r\\n';\n        } else {\n            part += '\\r\\n\\r\\n' + value + '\\r\\n';\n        }\n        this.__append(part);\n    };\n})(this || self);\n","jquery.js":"/*!\n * jQuery JavaScript Library v1.12.4\n * http://jquery.com/\n *\n * Includes Sizzle.js\n * http://sizzlejs.com/\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license\n * http://jquery.org/license\n *\n * Date: 2016-05-20T17:17Z\n */\n\n/*\n * includes patch for CVE-2019-11358\n * prototype pollution vulnerability in jQuery before 3.4.0\n */\n\n(function( global, factory ) {\n\n\tif ( typeof module === \"object\" && typeof module.exports === \"object\" ) {\n\t\t// For CommonJS and CommonJS-like environments where a proper `window`\n\t\t// is present, execute the factory and get jQuery.\n\t\t// For environments that do not have a `window` with a `document`\n\t\t// (such as Node.js), expose a factory as module.exports.\n\t\t// This accentuates the need for the creation of a real `window`.\n\t\t// e.g. var jQuery = require(\"jquery\")(window);\n\t\t// See ticket #14549 for more info.\n\t\tmodule.exports = global.document ?\n\t\t\tfactory( global, true ) :\n\t\t\tfunction( w ) {\n\t\t\t\tif ( !w.document ) {\n\t\t\t\t\tthrow new Error( \"jQuery requires a window with a document\" );\n\t\t\t\t}\n\t\t\t\treturn factory( w );\n\t\t\t};\n\t} else {\n\t\tfactory( global );\n\t}\n\n// Pass this if window is not defined yet\n}(typeof window !== \"undefined\" ? window : this, function( window, noGlobal ) {\n\n// Support: Firefox 18+\n// Can't be in strict mode, several libs including ASP.NET trace\n// the stack via arguments.caller.callee and Firefox dies if\n// you try to trace through \"use strict\" call chains. (#13335)\n//\"use strict\";\n\tvar deletedIds = [];\n\n\tvar document = window.document;\n\n\tvar slice = deletedIds.slice;\n\n\tvar concat = deletedIds.concat;\n\n\tvar push = deletedIds.push;\n\n\tvar indexOf = deletedIds.indexOf;\n\n\tvar class2type = {};\n\n\tvar toString = class2type.toString;\n\n\tvar hasOwn = class2type.hasOwnProperty;\n\n\tvar support = {};\n\n\n\n\tvar\n\t\tversion = \"1.12.4\",\n\n\t\t// Define a local copy of jQuery\n\t\tjQuery = function( selector, context ) {\n\n\t\t\t// The jQuery object is actually just the init constructor 'enhanced'\n\t\t\t// Need init if jQuery is called (just allow error to be thrown if not included)\n\t\t\treturn new jQuery.fn.init( selector, context );\n\t\t},\n\n\t\t// Support: Android<4.1, IE<9\n\t\t// Make sure we trim BOM and NBSP\n\t\trtrim = /^[\\s\\uFEFF\\xA0]+|[\\s\\uFEFF\\xA0]+$/g,\n\n\t\t// Matches dashed string for camelizing\n\t\trmsPrefix = /^-ms-/,\n\t\trdashAlpha = /-([\\da-z])/gi,\n\n\t\t// Used by jQuery.camelCase as callback to replace()\n\t\tfcamelCase = function( all, letter ) {\n\t\t\treturn letter.toUpperCase();\n\t\t};\n\n\tjQuery.fn = jQuery.prototype = {\n\n\t\t// The current version of jQuery being used\n\t\tjquery: version,\n\n\t\tconstructor: jQuery,\n\n\t\t// Start with an empty selector\n\t\tselector: \"\",\n\n\t\t// The default length of a jQuery object is 0\n\t\tlength: 0,\n\n\t\ttoArray: function() {\n\t\t\treturn slice.call( this );\n\t\t},\n\n\t\t// Get the Nth element in the matched element set OR\n\t\t// Get the whole matched element set as a clean array\n\t\tget: function( num ) {\n\t\t\treturn num != null ?\n\n\t\t\t\t// Return just the one element from the set\n\t\t\t\t( num < 0 ? this[ num + this.length ] : this[ num ] ) :\n\n\t\t\t\t// Return all the elements in a clean array\n\t\t\t\tslice.call( this );\n\t\t},\n\n\t\t// Take an array of elements and push it onto the stack\n\t\t// (returning the new matched element set)\n\t\tpushStack: function( elems ) {\n\n\t\t\t// Build a new jQuery matched element set\n\t\t\tvar ret = jQuery.merge( this.constructor(), elems );\n\n\t\t\t// Add the old object onto the stack (as a reference)\n\t\t\tret.prevObject = this;\n\t\t\tret.context = this.context;\n\n\t\t\t// Return the newly-formed element set\n\t\t\treturn ret;\n\t\t},\n\n\t\t// Execute a callback for every element in the matched set.\n\t\teach: function( callback ) {\n\t\t\treturn jQuery.each( this, callback );\n\t\t},\n\n\t\tmap: function( callback ) {\n\t\t\treturn this.pushStack( jQuery.map( this, function( elem, i ) {\n\t\t\t\treturn callback.call( elem, i, elem );\n\t\t\t} ) );\n\t\t},\n\n\t\tslice: function() {\n\t\t\treturn this.pushStack( slice.apply( this, arguments ) );\n\t\t},\n\n\t\tfirst: function() {\n\t\t\treturn this.eq( 0 );\n\t\t},\n\n\t\tlast: function() {\n\t\t\treturn this.eq( -1 );\n\t\t},\n\n\t\teq: function( i ) {\n\t\t\tvar len = this.length,\n\t\t\t\tj = +i + ( i < 0 ? len : 0 );\n\t\t\treturn this.pushStack( j >= 0 && j < len ? [ this[ j ] ] : [] );\n\t\t},\n\n\t\tend: function() {\n\t\t\treturn this.prevObject || this.constructor();\n\t\t},\n\n\t\t// For internal use only.\n\t\t// Behaves like an Array's method, not like a jQuery method.\n\t\tpush: push,\n\t\tsort: deletedIds.sort,\n\t\tsplice: deletedIds.splice\n\t};\n\n\tjQuery.extend = jQuery.fn.extend = function() {\n\t\tvar src, copyIsArray, copy, name, options, clone,\n\t\t\ttarget = arguments[ 0 ] || {},\n\t\t\ti = 1,\n\t\t\tlength = arguments.length,\n\t\t\tdeep = false;\n\n\t\t// Handle a deep copy situation\n\t\tif ( typeof target === \"boolean\" ) {\n\t\t\tdeep = target;\n\n\t\t\t// skip the boolean and the target\n\t\t\ttarget = arguments[ i ] || {};\n\t\t\ti++;\n\t\t}\n\n\t\t// Handle case when target is a string or something (possible in deep copy)\n\t\tif ( typeof target !== \"object\" && !jQuery.isFunction( target ) ) {\n\t\t\ttarget = {};\n\t\t}\n\n\t\t// extend jQuery itself if only one argument is passed\n\t\tif ( i === length ) {\n\t\t\ttarget = this;\n\t\t\ti--;\n\t\t}\n\n\t\tfor ( ; i < length; i++ ) {\n\n\t\t\t// Only deal with non-null/undefined values\n\t\t\tif ( ( options = arguments[ i ] ) != null ) {\n\n\t\t\t\t// Extend the base object\n\t\t\t\tfor ( name in options ) {\n\t\t\t\t\tsrc = target[ name ];\n\t\t\t\t\tcopy = options[ name ];\n\n\t\t\t\t\t// Prevent Object.prototype pollution\n\t\t\t\t\t// Prevent never-ending loop\n\t\t\t\t\tif ( name === \"__proto__\" || target === copy ) {\n\t\t\t\t\t\tcontinue;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Recurse if we're merging plain objects or arrays\n\t\t\t\t\tif ( deep && copy && ( jQuery.isPlainObject( copy ) ||\n\t\t\t\t\t\t( copyIsArray = jQuery.isArray( copy ) ) ) ) {\n\n\t\t\t\t\t\tif ( copyIsArray ) {\n\t\t\t\t\t\t\tcopyIsArray = false;\n\t\t\t\t\t\t\tclone = src && jQuery.isArray( src ) ? src : [];\n\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tclone = src && jQuery.isPlainObject( src ) ? src : {};\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Never move original objects, clone them\n\t\t\t\t\t\ttarget[ name ] = jQuery.extend( deep, clone, copy );\n\n\t\t\t\t\t\t// Don't bring in undefined values\n\t\t\t\t\t} else if ( copy !== undefined ) {\n\t\t\t\t\t\ttarget[ name ] = copy;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\t// Return the modified object\n\t\treturn target;\n\t};\n\n\tjQuery.extend( {\n\n\t\t// Unique for each copy of jQuery on the page\n\t\texpando: \"jQuery\" + ( version + Math.random() ).replace( /\\D/g, \"\" ),\n\n\t\t// Assume jQuery is ready without the ready module\n\t\tisReady: true,\n\n\t\terror: function( msg ) {\n\t\t\tthrow new Error( msg );\n\t\t},\n\n\t\tnoop: function() {},\n\n\t\t// See test/unit/core.js for details concerning isFunction.\n\t\t// Since version 1.3, DOM methods and functions like alert\n\t\t// aren't supported. They return false on IE (#2968).\n\t\tisFunction: function( obj ) {\n\t\t\treturn jQuery.type( obj ) === \"function\";\n\t\t},\n\n\t\tisArray: Array.isArray || function( obj ) {\n\t\t\treturn jQuery.type( obj ) === \"array\";\n\t\t},\n\n\t\tisWindow: function( obj ) {\n\t\t\t/* jshint eqeqeq: false */\n\t\t\treturn obj != null && obj == obj.window;\n\t\t},\n\n\t\tisNumeric: function( obj ) {\n\n\t\t\t// parseFloat NaNs numeric-cast false positives (null|true|false|\"\")\n\t\t\t// ...but misinterprets leading-number strings, particularly hex literals (\"0x...\")\n\t\t\t// subtraction forces infinities to NaN\n\t\t\t// adding 1 corrects loss of precision from parseFloat (#15100)\n\t\t\tvar realStringObj = obj && obj.toString();\n\t\t\treturn !jQuery.isArray( obj ) && ( realStringObj - parseFloat( realStringObj ) + 1 ) >= 0;\n\t\t},\n\n\t\tisEmptyObject: function( obj ) {\n\t\t\tvar name;\n\t\t\tfor ( name in obj ) {\n\t\t\t\treturn false;\n\t\t\t}\n\t\t\treturn true;\n\t\t},\n\n\t\tisPlainObject: function( obj ) {\n\t\t\tvar key;\n\n\t\t\t// Must be an Object.\n\t\t\t// Because of IE, we also have to check the presence of the constructor property.\n\t\t\t// Make sure that DOM nodes and window objects don't pass through, as well\n\t\t\tif ( !obj || jQuery.type( obj ) !== \"object\" || obj.nodeType || jQuery.isWindow( obj ) ) {\n\t\t\t\treturn false;\n\t\t\t}\n\n\t\t\ttry {\n\n\t\t\t\t// Not own constructor property must be Object\n\t\t\t\tif ( obj.constructor &&\n\t\t\t\t\t!hasOwn.call( obj, \"constructor\" ) &&\n\t\t\t\t\t!hasOwn.call( obj.constructor.prototype, \"isPrototypeOf\" ) ) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t} catch ( e ) {\n\n\t\t\t\t// IE8,9 Will throw exceptions on certain host objects #9897\n\t\t\t\treturn false;\n\t\t\t}\n\n\t\t\t// Support: IE<9\n\t\t\t// Handle iteration over inherited properties before own properties.\n\t\t\tif ( !support.ownFirst ) {\n\t\t\t\tfor ( key in obj ) {\n\t\t\t\t\treturn hasOwn.call( obj, key );\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Own properties are enumerated firstly, so to speed up,\n\t\t\t// if last one is own, then all properties are own.\n\t\t\tfor ( key in obj ) {}\n\n\t\t\treturn key === undefined || hasOwn.call( obj, key );\n\t\t},\n\n\t\ttype: function( obj ) {\n\t\t\tif ( obj == null ) {\n\t\t\t\treturn obj + \"\";\n\t\t\t}\n\t\t\treturn typeof obj === \"object\" || typeof obj === \"function\" ?\n\t\t\tclass2type[ toString.call( obj ) ] || \"object\" :\n\t\t\t\ttypeof obj;\n\t\t},\n\n\t\t// Workarounds based on findings by Jim Driscoll\n\t\t// http://weblogs.java.net/blog/driscoll/archive/2009/09/08/eval-javascript-global-context\n\t\tglobalEval: function( data ) {\n\t\t\tif ( data && jQuery.trim( data ) ) {\n\n\t\t\t\t// We use execScript on Internet Explorer\n\t\t\t\t// We use an anonymous function so that context is window\n\t\t\t\t// rather than jQuery in Firefox\n\t\t\t\t( window.execScript || function( data ) {\n\t\t\t\t\twindow[ \"eval\" ].call( window, data ); // jscs:ignore requireDotNotation\n\t\t\t\t} )( data );\n\t\t\t}\n\t\t},\n\n\t\t// Convert dashed to camelCase; used by the css and data modules\n\t\t// Microsoft forgot to hump their vendor prefix (#9572)\n\t\tcamelCase: function( string ) {\n\t\t\treturn string.replace( rmsPrefix, \"ms-\" ).replace( rdashAlpha, fcamelCase );\n\t\t},\n\n\t\tnodeName: function( elem, name ) {\n\t\t\treturn elem.nodeName && elem.nodeName.toLowerCase() === name.toLowerCase();\n\t\t},\n\n\t\teach: function( obj, callback ) {\n\t\t\tvar length, i = 0;\n\n\t\t\tif ( isArrayLike( obj ) ) {\n\t\t\t\tlength = obj.length;\n\t\t\t\tfor ( ; i < length; i++ ) {\n\t\t\t\t\tif ( callback.call( obj[ i ], i, obj[ i ] ) === false ) {\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\tfor ( i in obj ) {\n\t\t\t\t\tif ( callback.call( obj[ i ], i, obj[ i ] ) === false ) {\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn obj;\n\t\t},\n\n\t\t// Support: Android<4.1, IE<9\n\t\ttrim: function( text ) {\n\t\t\treturn text == null ?\n\t\t\t\t\"\" :\n\t\t\t\t( text + \"\" ).replace( rtrim, \"\" );\n\t\t},\n\n\t\t// results is for internal usage only\n\t\tmakeArray: function( arr, results ) {\n\t\t\tvar ret = results || [];\n\n\t\t\tif ( arr != null ) {\n\t\t\t\tif ( isArrayLike( Object( arr ) ) ) {\n\t\t\t\t\tjQuery.merge( ret,\n\t\t\t\t\t\ttypeof arr === \"string\" ?\n\t\t\t\t\t\t\t[ arr ] : arr\n\t\t\t\t\t);\n\t\t\t\t} else {\n\t\t\t\t\tpush.call( ret, arr );\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn ret;\n\t\t},\n\n\t\tinArray: function( elem, arr, i ) {\n\t\t\tvar len;\n\n\t\t\tif ( arr ) {\n\t\t\t\tif ( indexOf ) {\n\t\t\t\t\treturn indexOf.call( arr, elem, i );\n\t\t\t\t}\n\n\t\t\t\tlen = arr.length;\n\t\t\t\ti = i ? i < 0 ? Math.max( 0, len + i ) : i : 0;\n\n\t\t\t\tfor ( ; i < len; i++ ) {\n\n\t\t\t\t\t// Skip accessing in sparse arrays\n\t\t\t\t\tif ( i in arr && arr[ i ] === elem ) {\n\t\t\t\t\t\treturn i;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn -1;\n\t\t},\n\n\t\tmerge: function( first, second ) {\n\t\t\tvar len = +second.length,\n\t\t\t\tj = 0,\n\t\t\t\ti = first.length;\n\n\t\t\twhile ( j < len ) {\n\t\t\t\tfirst[ i++ ] = second[ j++ ];\n\t\t\t}\n\n\t\t\t// Support: IE<9\n\t\t\t// Workaround casting of .length to NaN on otherwise arraylike objects (e.g., NodeLists)\n\t\t\tif ( len !== len ) {\n\t\t\t\twhile ( second[ j ] !== undefined ) {\n\t\t\t\t\tfirst[ i++ ] = second[ j++ ];\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tfirst.length = i;\n\n\t\t\treturn first;\n\t\t},\n\n\t\tgrep: function( elems, callback, invert ) {\n\t\t\tvar callbackInverse,\n\t\t\t\tmatches = [],\n\t\t\t\ti = 0,\n\t\t\t\tlength = elems.length,\n\t\t\t\tcallbackExpect = !invert;\n\n\t\t\t// Go through the array, only saving the items\n\t\t\t// that pass the validator function\n\t\t\tfor ( ; i < length; i++ ) {\n\t\t\t\tcallbackInverse = !callback( elems[ i ], i );\n\t\t\t\tif ( callbackInverse !== callbackExpect ) {\n\t\t\t\t\tmatches.push( elems[ i ] );\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn matches;\n\t\t},\n\n\t\t// arg is for internal usage only\n\t\tmap: function( elems, callback, arg ) {\n\t\t\tvar length, value,\n\t\t\t\ti = 0,\n\t\t\t\tret = [];\n\n\t\t\t// Go through the array, translating each of the items to their new values\n\t\t\tif ( isArrayLike( elems ) ) {\n\t\t\t\tlength = elems.length;\n\t\t\t\tfor ( ; i < length; i++ ) {\n\t\t\t\t\tvalue = callback( elems[ i ], i, arg );\n\n\t\t\t\t\tif ( value != null ) {\n\t\t\t\t\t\tret.push( value );\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Go through every key on the object,\n\t\t\t} else {\n\t\t\t\tfor ( i in elems ) {\n\t\t\t\t\tvalue = callback( elems[ i ], i, arg );\n\n\t\t\t\t\tif ( value != null ) {\n\t\t\t\t\t\tret.push( value );\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Flatten any nested arrays\n\t\t\treturn concat.apply( [], ret );\n\t\t},\n\n\t\t// A global GUID counter for objects\n\t\tguid: 1,\n\n\t\t// Bind a function to a context, optionally partially applying any\n\t\t// arguments.\n\t\tproxy: function( fn, context ) {\n\t\t\tvar args, proxy, tmp;\n\n\t\t\tif ( typeof context === \"string\" ) {\n\t\t\t\ttmp = fn[ context ];\n\t\t\t\tcontext = fn;\n\t\t\t\tfn = tmp;\n\t\t\t}\n\n\t\t\t// Quick check to determine if target is callable, in the spec\n\t\t\t// this throws a TypeError, but we will just return undefined.\n\t\t\tif ( !jQuery.isFunction( fn ) ) {\n\t\t\t\treturn undefined;\n\t\t\t}\n\n\t\t\t// Simulated bind\n\t\t\targs = slice.call( arguments, 2 );\n\t\t\tproxy = function() {\n\t\t\t\treturn fn.apply( context || this, args.concat( slice.call( arguments ) ) );\n\t\t\t};\n\n\t\t\t// Set the guid of unique handler to the same of original handler, so it can be removed\n\t\t\tproxy.guid = fn.guid = fn.guid || jQuery.guid++;\n\n\t\t\treturn proxy;\n\t\t},\n\n\t\tnow: function() {\n\t\t\treturn +( new Date() );\n\t\t},\n\n\t\t// jQuery.support is not used in Core but other projects attach their\n\t\t// properties to it so it needs to exist.\n\t\tsupport: support\n\t} );\n\n// JSHint would error on this code due to the Symbol not being defined in ES5.\n// Defining this global in .jshintrc would create a danger of using the global\n// unguarded in another place, it seems safer to just disable JSHint for these\n// three lines.\n\t/* jshint ignore: start */\n\tif ( typeof Symbol === \"function\" ) {\n\t\tjQuery.fn[ Symbol.iterator ] = deletedIds[ Symbol.iterator ];\n\t}\n\t/* jshint ignore: end */\n\n// Populate the class2type map\n\tjQuery.each( \"Boolean Number String Function Array Date RegExp Object Error Symbol\".split( \" \" ),\n\t\tfunction( i, name ) {\n\t\t\tclass2type[ \"[object \" + name + \"]\" ] = name.toLowerCase();\n\t\t} );\n\n\tfunction isArrayLike( obj ) {\n\n\t\t// Support: iOS 8.2 (not reproducible in simulator)\n\t\t// `in` check used to prevent JIT error (gh-2145)\n\t\t// hasOwn isn't used here due to false negatives\n\t\t// regarding Nodelist length in IE\n\t\tvar length = !!obj && \"length\" in obj && obj.length,\n\t\t\ttype = jQuery.type( obj );\n\n\t\tif ( type === \"function\" || jQuery.isWindow( obj ) ) {\n\t\t\treturn false;\n\t\t}\n\n\t\treturn type === \"array\" || length === 0 ||\n\t\t\ttypeof length === \"number\" && length > 0 && ( length - 1 ) in obj;\n\t}\n\tvar Sizzle =\n\t\t/*!\n\t\t * Sizzle CSS Selector Engine v2.2.1\n\t\t * http://sizzlejs.com/\n\t\t *\n\t\t * Copyright jQuery Foundation and other contributors\n\t\t * Released under the MIT license\n\t\t * http://jquery.org/license\n\t\t *\n\t\t * Date: 2015-10-17\n\t\t */\n\t\t(function( window ) {\n\n\t\t\tvar i,\n\t\t\t\tsupport,\n\t\t\t\tExpr,\n\t\t\t\tgetText,\n\t\t\t\tisXML,\n\t\t\t\ttokenize,\n\t\t\t\tcompile,\n\t\t\t\tselect,\n\t\t\t\toutermostContext,\n\t\t\t\tsortInput,\n\t\t\t\thasDuplicate,\n\n\t\t\t\t// Local document vars\n\t\t\t\tsetDocument,\n\t\t\t\tdocument,\n\t\t\t\tdocElem,\n\t\t\t\tdocumentIsHTML,\n\t\t\t\trbuggyQSA,\n\t\t\t\trbuggyMatches,\n\t\t\t\tmatches,\n\t\t\t\tcontains,\n\n\t\t\t\t// Instance-specific data\n\t\t\t\texpando = \"sizzle\" + 1 * new Date(),\n\t\t\t\tpreferredDoc = window.document,\n\t\t\t\tdirruns = 0,\n\t\t\t\tdone = 0,\n\t\t\t\tclassCache = createCache(),\n\t\t\t\ttokenCache = createCache(),\n\t\t\t\tcompilerCache = createCache(),\n\t\t\t\tsortOrder = function( a, b ) {\n\t\t\t\t\tif ( a === b ) {\n\t\t\t\t\t\thasDuplicate = true;\n\t\t\t\t\t}\n\t\t\t\t\treturn 0;\n\t\t\t\t},\n\n\t\t\t\t// General-purpose constants\n\t\t\t\tMAX_NEGATIVE = 1 << 31,\n\n\t\t\t\t// Instance methods\n\t\t\t\thasOwn = ({}).hasOwnProperty,\n\t\t\t\tarr = [],\n\t\t\t\tpop = arr.pop,\n\t\t\t\tpush_native = arr.push,\n\t\t\t\tpush = arr.push,\n\t\t\t\tslice = arr.slice,\n\t\t\t\t// Use a stripped-down indexOf as it's faster than native\n\t\t\t\t// http://jsperf.com/thor-indexof-vs-for/5\n\t\t\t\tindexOf = function( list, elem ) {\n\t\t\t\t\tvar i = 0,\n\t\t\t\t\t\tlen = list.length;\n\t\t\t\t\tfor ( ; i < len; i++ ) {\n\t\t\t\t\t\tif ( list[i] === elem ) {\n\t\t\t\t\t\t\treturn i;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\treturn -1;\n\t\t\t\t},\n\n\t\t\t\tbooleans = \"checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|ismap|loop|multiple|open|readonly|required|scoped\",\n\n\t\t\t\t// Regular expressions\n\n\t\t\t\t// http://www.w3.org/TR/css3-selectors/#whitespace\n\t\t\t\twhitespace = \"[\\\\x20\\\\t\\\\r\\\\n\\\\f]\",\n\n\t\t\t\t// http://www.w3.org/TR/CSS21/syndata.html#value-def-identifier\n\t\t\t\tidentifier = \"(?:\\\\\\\\.|[\\\\w-]|[^\\\\x00-\\\\xa0])+\",\n\n\t\t\t\t// Attribute selectors: http://www.w3.org/TR/selectors/#attribute-selectors\n\t\t\t\tattributes = \"\\\\[\" + whitespace + \"*(\" + identifier + \")(?:\" + whitespace +\n\t\t\t\t\t// Operator (capture 2)\n\t\t\t\t\t\"*([*^$|!~]?=)\" + whitespace +\n\t\t\t\t\t// \"Attribute values must be CSS identifiers [capture 5] or strings [capture 3 or capture 4]\"\n\t\t\t\t\t\"*(?:'((?:\\\\\\\\.|[^\\\\\\\\'])*)'|\\\"((?:\\\\\\\\.|[^\\\\\\\\\\\"])*)\\\"|(\" + identifier + \"))|)\" + whitespace +\n\t\t\t\t\t\"*\\\\]\",\n\n\t\t\t\tpseudos = \":(\" + identifier + \")(?:\\\\((\" +\n\t\t\t\t\t// To reduce the number of selectors needing tokenize in the preFilter, prefer arguments:\n\t\t\t\t\t// 1. quoted (capture 3; capture 4 or capture 5)\n\t\t\t\t\t\"('((?:\\\\\\\\.|[^\\\\\\\\'])*)'|\\\"((?:\\\\\\\\.|[^\\\\\\\\\\\"])*)\\\")|\" +\n\t\t\t\t\t// 2. simple (capture 6)\n\t\t\t\t\t\"((?:\\\\\\\\.|[^\\\\\\\\()[\\\\]]|\" + attributes + \")*)|\" +\n\t\t\t\t\t// 3. anything else (capture 2)\n\t\t\t\t\t\".*\" +\n\t\t\t\t\t\")\\\\)|)\",\n\n\t\t\t\t// Leading and non-escaped trailing whitespace, capturing some non-whitespace characters preceding the latter\n\t\t\t\trwhitespace = new RegExp( whitespace + \"+\", \"g\" ),\n\t\t\t\trtrim = new RegExp( \"^\" + whitespace + \"+|((?:^|[^\\\\\\\\])(?:\\\\\\\\.)*)\" + whitespace + \"+$\", \"g\" ),\n\n\t\t\t\trcomma = new RegExp( \"^\" + whitespace + \"*,\" + whitespace + \"*\" ),\n\t\t\t\trcombinators = new RegExp( \"^\" + whitespace + \"*([>+~]|\" + whitespace + \")\" + whitespace + \"*\" ),\n\n\t\t\t\trattributeQuotes = new RegExp( \"=\" + whitespace + \"*([^\\\\]'\\\"]*?)\" + whitespace + \"*\\\\]\", \"g\" ),\n\n\t\t\t\trpseudo = new RegExp( pseudos ),\n\t\t\t\tridentifier = new RegExp( \"^\" + identifier + \"$\" ),\n\n\t\t\t\tmatchExpr = {\n\t\t\t\t\t\"ID\": new RegExp( \"^#(\" + identifier + \")\" ),\n\t\t\t\t\t\"CLASS\": new RegExp( \"^\\\\.(\" + identifier + \")\" ),\n\t\t\t\t\t\"TAG\": new RegExp( \"^(\" + identifier + \"|[*])\" ),\n\t\t\t\t\t\"ATTR\": new RegExp( \"^\" + attributes ),\n\t\t\t\t\t\"PSEUDO\": new RegExp( \"^\" + pseudos ),\n\t\t\t\t\t\"CHILD\": new RegExp( \"^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\\\(\" + whitespace +\n\t\t\t\t\t\t\"*(even|odd|(([+-]|)(\\\\d*)n|)\" + whitespace + \"*(?:([+-]|)\" + whitespace +\n\t\t\t\t\t\t\"*(\\\\d+)|))\" + whitespace + \"*\\\\)|)\", \"i\" ),\n\t\t\t\t\t\"bool\": new RegExp( \"^(?:\" + booleans + \")$\", \"i\" ),\n\t\t\t\t\t// For use in libraries implementing .is()\n\t\t\t\t\t// We use this for POS matching in `select`\n\t\t\t\t\t\"needsContext\": new RegExp( \"^\" + whitespace + \"*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\\\(\" +\n\t\t\t\t\t\twhitespace + \"*((?:-\\\\d)?\\\\d*)\" + whitespace + \"*\\\\)|)(?=[^-]|$)\", \"i\" )\n\t\t\t\t},\n\n\t\t\t\trinputs = /^(?:input|select|textarea|button)$/i,\n\t\t\t\trheader = /^h\\d$/i,\n\n\t\t\t\trnative = /^[^{]+\\{\\s*\\[native \\w/,\n\n\t\t\t\t// Easily-parseable/retrievable ID or TAG or CLASS selectors\n\t\t\t\trquickExpr = /^(?:#([\\w-]+)|(\\w+)|\\.([\\w-]+))$/,\n\n\t\t\t\trsibling = /[+~]/,\n\t\t\t\trescape = /'|\\\\/g,\n\n\t\t\t\t// CSS escapes http://www.w3.org/TR/CSS21/syndata.html#escaped-characters\n\t\t\t\trunescape = new RegExp( \"\\\\\\\\([\\\\da-f]{1,6}\" + whitespace + \"?|(\" + whitespace + \")|.)\", \"ig\" ),\n\t\t\t\tfunescape = function( _, escaped, escapedWhitespace ) {\n\t\t\t\t\tvar high = \"0x\" + escaped - 0x10000;\n\t\t\t\t\t// NaN means non-codepoint\n\t\t\t\t\t// Support: Firefox<24\n\t\t\t\t\t// Workaround erroneous numeric interpretation of +\"0x\"\n\t\t\t\t\treturn high !== high || escapedWhitespace ?\n\t\t\t\t\t\tescaped :\n\t\t\t\t\t\thigh < 0 ?\n\t\t\t\t\t\t\t// BMP codepoint\n\t\t\t\t\t\t\tString.fromCharCode( high + 0x10000 ) :\n\t\t\t\t\t\t\t// Supplemental Plane codepoint (surrogate pair)\n\t\t\t\t\t\t\tString.fromCharCode( high >> 10 | 0xD800, high & 0x3FF | 0xDC00 );\n\t\t\t\t},\n\n\t\t\t\t// Used for iframes\n\t\t\t\t// See setDocument()\n\t\t\t\t// Removing the function wrapper causes a \"Permission Denied\"\n\t\t\t\t// error in IE\n\t\t\t\tunloadHandler = function() {\n\t\t\t\t\tsetDocument();\n\t\t\t\t};\n\n// Optimize for push.apply( _, NodeList )\n\t\t\ttry {\n\t\t\t\tpush.apply(\n\t\t\t\t\t(arr = slice.call( preferredDoc.childNodes )),\n\t\t\t\t\tpreferredDoc.childNodes\n\t\t\t\t);\n\t\t\t\t// Support: Android<4.0\n\t\t\t\t// Detect silently failing push.apply\n\t\t\t\tarr[ preferredDoc.childNodes.length ].nodeType;\n\t\t\t} catch ( e ) {\n\t\t\t\tpush = { apply: arr.length ?\n\n\t\t\t\t\t// Leverage slice if possible\n\t\t\t\t\tfunction( target, els ) {\n\t\t\t\t\t\tpush_native.apply( target, slice.call(els) );\n\t\t\t\t\t} :\n\n\t\t\t\t\t// Support: IE<9\n\t\t\t\t\t// Otherwise append directly\n\t\t\t\t\tfunction( target, els ) {\n\t\t\t\t\t\tvar j = target.length,\n\t\t\t\t\t\t\ti = 0;\n\t\t\t\t\t\t// Can't trust NodeList.length\n\t\t\t\t\t\twhile ( (target[j++] = els[i++]) ) {}\n\t\t\t\t\t\ttarget.length = j - 1;\n\t\t\t\t\t}\n\t\t\t\t};\n\t\t\t}\n\n\t\t\tfunction Sizzle( selector, context, results, seed ) {\n\t\t\t\tvar m, i, elem, nid, nidselect, match, groups, newSelector,\n\t\t\t\t\tnewContext = context && context.ownerDocument,\n\n\t\t\t\t\t// nodeType defaults to 9, since context defaults to document\n\t\t\t\t\tnodeType = context ? context.nodeType : 9;\n\n\t\t\t\tresults = results || [];\n\n\t\t\t\t// Return early from calls with invalid selector or context\n\t\t\t\tif ( typeof selector !== \"string\" || !selector ||\n\t\t\t\t\tnodeType !== 1 && nodeType !== 9 && nodeType !== 11 ) {\n\n\t\t\t\t\treturn results;\n\t\t\t\t}\n\n\t\t\t\t// Try to shortcut find operations (as opposed to filters) in HTML documents\n\t\t\t\tif ( !seed ) {\n\n\t\t\t\t\tif ( ( context ? context.ownerDocument || context : preferredDoc ) !== document ) {\n\t\t\t\t\t\tsetDocument( context );\n\t\t\t\t\t}\n\t\t\t\t\tcontext = context || document;\n\n\t\t\t\t\tif ( documentIsHTML ) {\n\n\t\t\t\t\t\t// If the selector is sufficiently simple, try using a \"get*By*\" DOM method\n\t\t\t\t\t\t// (excepting DocumentFragment context, where the methods don't exist)\n\t\t\t\t\t\tif ( nodeType !== 11 && (match = rquickExpr.exec( selector )) ) {\n\n\t\t\t\t\t\t\t// ID selector\n\t\t\t\t\t\t\tif ( (m = match[1]) ) {\n\n\t\t\t\t\t\t\t\t// Document context\n\t\t\t\t\t\t\t\tif ( nodeType === 9 ) {\n\t\t\t\t\t\t\t\t\tif ( (elem = context.getElementById( m )) ) {\n\n\t\t\t\t\t\t\t\t\t\t// Support: IE, Opera, Webkit\n\t\t\t\t\t\t\t\t\t\t// TODO: identify versions\n\t\t\t\t\t\t\t\t\t\t// getElementById can match elements by name instead of ID\n\t\t\t\t\t\t\t\t\t\tif ( elem.id === m ) {\n\t\t\t\t\t\t\t\t\t\t\tresults.push( elem );\n\t\t\t\t\t\t\t\t\t\t\treturn results;\n\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\t\treturn results;\n\t\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t\t// Element context\n\t\t\t\t\t\t\t\t} else {\n\n\t\t\t\t\t\t\t\t\t// Support: IE, Opera, Webkit\n\t\t\t\t\t\t\t\t\t// TODO: identify versions\n\t\t\t\t\t\t\t\t\t// getElementById can match elements by name instead of ID\n\t\t\t\t\t\t\t\t\tif ( newContext && (elem = newContext.getElementById( m )) &&\n\t\t\t\t\t\t\t\t\t\tcontains( context, elem ) &&\n\t\t\t\t\t\t\t\t\t\telem.id === m ) {\n\n\t\t\t\t\t\t\t\t\t\tresults.push( elem );\n\t\t\t\t\t\t\t\t\t\treturn results;\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t// Type selector\n\t\t\t\t\t\t\t} else if ( match[2] ) {\n\t\t\t\t\t\t\t\tpush.apply( results, context.getElementsByTagName( selector ) );\n\t\t\t\t\t\t\t\treturn results;\n\n\t\t\t\t\t\t\t\t// Class selector\n\t\t\t\t\t\t\t} else if ( (m = match[3]) && support.getElementsByClassName &&\n\t\t\t\t\t\t\t\tcontext.getElementsByClassName ) {\n\n\t\t\t\t\t\t\t\tpush.apply( results, context.getElementsByClassName( m ) );\n\t\t\t\t\t\t\t\treturn results;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Take advantage of querySelectorAll\n\t\t\t\t\t\tif ( support.qsa &&\n\t\t\t\t\t\t\t!compilerCache[ selector + \" \" ] &&\n\t\t\t\t\t\t\t(!rbuggyQSA || !rbuggyQSA.test( selector )) ) {\n\n\t\t\t\t\t\t\tif ( nodeType !== 1 ) {\n\t\t\t\t\t\t\t\tnewContext = context;\n\t\t\t\t\t\t\t\tnewSelector = selector;\n\n\t\t\t\t\t\t\t\t// qSA looks outside Element context, which is not what we want\n\t\t\t\t\t\t\t\t// Thanks to Andrew Dupont for this workaround technique\n\t\t\t\t\t\t\t\t// Support: IE <=8\n\t\t\t\t\t\t\t\t// Exclude object elements\n\t\t\t\t\t\t\t} else if ( context.nodeName.toLowerCase() !== \"object\" ) {\n\n\t\t\t\t\t\t\t\t// Capture the context ID, setting it first if necessary\n\t\t\t\t\t\t\t\tif ( (nid = context.getAttribute( \"id\" )) ) {\n\t\t\t\t\t\t\t\t\tnid = nid.replace( rescape, \"\\\\$&\" );\n\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\tcontext.setAttribute( \"id\", (nid = expando) );\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t// Prefix every selector in the list\n\t\t\t\t\t\t\t\tgroups = tokenize( selector );\n\t\t\t\t\t\t\t\ti = groups.length;\n\t\t\t\t\t\t\t\tnidselect = ridentifier.test( nid ) ? \"#\" + nid : \"[id='\" + nid + \"']\";\n\t\t\t\t\t\t\t\twhile ( i-- ) {\n\t\t\t\t\t\t\t\t\tgroups[i] = nidselect + \" \" + toSelector( groups[i] );\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\tnewSelector = groups.join( \",\" );\n\n\t\t\t\t\t\t\t\t// Expand context for sibling selectors\n\t\t\t\t\t\t\t\tnewContext = rsibling.test( selector ) && testContext( context.parentNode ) ||\n\t\t\t\t\t\t\t\t\tcontext;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tif ( newSelector ) {\n\t\t\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\t\t\tpush.apply( results,\n\t\t\t\t\t\t\t\t\t\tnewContext.querySelectorAll( newSelector )\n\t\t\t\t\t\t\t\t\t);\n\t\t\t\t\t\t\t\t\treturn results;\n\t\t\t\t\t\t\t\t} catch ( qsaError ) {\n\t\t\t\t\t\t\t\t} finally {\n\t\t\t\t\t\t\t\t\tif ( nid === expando ) {\n\t\t\t\t\t\t\t\t\t\tcontext.removeAttribute( \"id\" );\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// All others\n\t\t\t\treturn select( selector.replace( rtrim, \"$1\" ), context, results, seed );\n\t\t\t}\n\n\t\t\t/**\n\t\t\t * Create key-value caches of limited size\n\t\t\t * @returns {function(string, object)} Returns the Object data after storing it on itself with\n\t\t\t *\tproperty name the (space-suffixed) string and (if the cache is larger than Expr.cacheLength)\n\t\t\t *\tdeleting the oldest entry\n\t\t\t */\n\t\t\tfunction createCache() {\n\t\t\t\tvar keys = [];\n\n\t\t\t\tfunction cache( key, value ) {\n\t\t\t\t\t// Use (key + \" \") to avoid collision with native prototype properties (see Issue #157)\n\t\t\t\t\tif ( keys.push( key + \" \" ) > Expr.cacheLength ) {\n\t\t\t\t\t\t// Only keep the most recent entries\n\t\t\t\t\t\tdelete cache[ keys.shift() ];\n\t\t\t\t\t}\n\t\t\t\t\treturn (cache[ key + \" \" ] = value);\n\t\t\t\t}\n\t\t\t\treturn cache;\n\t\t\t}\n\n\t\t\t/**\n\t\t\t * Mark a function for special use by Sizzle\n\t\t\t * @param {Function} fn The function to mark\n\t\t\t */\n\t\t\tfunction markFunction( fn ) {\n\t\t\t\tfn[ expando ] = true;\n\t\t\t\treturn fn;\n\t\t\t}\n\n\t\t\t/**\n\t\t\t * Support testing using an element\n\t\t\t * @param {Function} fn Passed the created div and expects a boolean result\n\t\t\t */\n\t\t\tfunction assert( fn ) {\n\t\t\t\tvar div = document.createElement(\"div\");\n\n\t\t\t\ttry {\n\t\t\t\t\treturn !!fn( div );\n\t\t\t\t} catch (e) {\n\t\t\t\t\treturn false;\n\t\t\t\t} finally {\n\t\t\t\t\t// Remove from its parent by default\n\t\t\t\t\tif ( div.parentNode ) {\n\t\t\t\t\t\tdiv.parentNode.removeChild( div );\n\t\t\t\t\t}\n\t\t\t\t\t// release memory in IE\n\t\t\t\t\tdiv = null;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t/**\n\t\t\t * Adds the same handler for all of the specified attrs\n\t\t\t * @param {String} attrs Pipe-separated list of attributes\n\t\t\t * @param {Function} handler The method that will be applied\n\t\t\t */\n\t\t\tfunction addHandle( attrs, handler ) {\n\t\t\t\tvar arr = attrs.split(\"|\"),\n\t\t\t\t\ti = arr.length;\n\n\t\t\t\twhile ( i-- ) {\n\t\t\t\t\tExpr.attrHandle[ arr[i] ] = handler;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t/**\n\t\t\t * Checks document order of two siblings\n\t\t\t * @param {Element} a\n\t\t\t * @param {Element} b\n\t\t\t * @returns {Number} Returns less than 0 if a precedes b, greater than 0 if a follows b\n\t\t\t */\n\t\t\tfunction siblingCheck( a, b ) {\n\t\t\t\tvar cur = b && a,\n\t\t\t\t\tdiff = cur && a.nodeType === 1 && b.nodeType === 1 &&\n\t\t\t\t\t\t( ~b.sourceIndex || MAX_NEGATIVE ) -\n\t\t\t\t\t\t( ~a.sourceIndex || MAX_NEGATIVE );\n\n\t\t\t\t// Use IE sourceIndex if available on both nodes\n\t\t\t\tif ( diff ) {\n\t\t\t\t\treturn diff;\n\t\t\t\t}\n\n\t\t\t\t// Check if b follows a\n\t\t\t\tif ( cur ) {\n\t\t\t\t\twhile ( (cur = cur.nextSibling) ) {\n\t\t\t\t\t\tif ( cur === b ) {\n\t\t\t\t\t\t\treturn -1;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\treturn a ? 1 : -1;\n\t\t\t}\n\n\t\t\t/**\n\t\t\t * Returns a function to use in pseudos for input types\n\t\t\t * @param {String} type\n\t\t\t */\n\t\t\tfunction createInputPseudo( type ) {\n\t\t\t\treturn function( elem ) {\n\t\t\t\t\tvar name = elem.nodeName.toLowerCase();\n\t\t\t\t\treturn name === \"input\" && elem.type === type;\n\t\t\t\t};\n\t\t\t}\n\n\t\t\t/**\n\t\t\t * Returns a function to use in pseudos for buttons\n\t\t\t * @param {String} type\n\t\t\t */\n\t\t\tfunction createButtonPseudo( type ) {\n\t\t\t\treturn function( elem ) {\n\t\t\t\t\tvar name = elem.nodeName.toLowerCase();\n\t\t\t\t\treturn (name === \"input\" || name === \"button\") && elem.type === type;\n\t\t\t\t};\n\t\t\t}\n\n\t\t\t/**\n\t\t\t * Returns a function to use in pseudos for positionals\n\t\t\t * @param {Function} fn\n\t\t\t */\n\t\t\tfunction createPositionalPseudo( fn ) {\n\t\t\t\treturn markFunction(function( argument ) {\n\t\t\t\t\targument = +argument;\n\t\t\t\t\treturn markFunction(function( seed, matches ) {\n\t\t\t\t\t\tvar j,\n\t\t\t\t\t\t\tmatchIndexes = fn( [], seed.length, argument ),\n\t\t\t\t\t\t\ti = matchIndexes.length;\n\n\t\t\t\t\t\t// Match elements found at the specified indexes\n\t\t\t\t\t\twhile ( i-- ) {\n\t\t\t\t\t\t\tif ( seed[ (j = matchIndexes[i]) ] ) {\n\t\t\t\t\t\t\t\tseed[j] = !(matches[j] = seed[j]);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t});\n\t\t\t}\n\n\t\t\t/**\n\t\t\t * Checks a node for validity as a Sizzle context\n\t\t\t * @param {Element|Object=} context\n\t\t\t * @returns {Element|Object|Boolean} The input node if acceptable, otherwise a falsy value\n\t\t\t */\n\t\t\tfunction testContext( context ) {\n\t\t\t\treturn context && typeof context.getElementsByTagName !== \"undefined\" && context;\n\t\t\t}\n\n// Expose support vars for convenience\n\t\t\tsupport = Sizzle.support = {};\n\n\t\t\t/**\n\t\t\t * Detects XML nodes\n\t\t\t * @param {Element|Object} elem An element or a document\n\t\t\t * @returns {Boolean} True iff elem is a non-HTML XML node\n\t\t\t */\n\t\t\tisXML = Sizzle.isXML = function( elem ) {\n\t\t\t\t// documentElement is verified for cases where it doesn't yet exist\n\t\t\t\t// (such as loading iframes in IE - #4833)\n\t\t\t\tvar documentElement = elem && (elem.ownerDocument || elem).documentElement;\n\t\t\t\treturn documentElement ? documentElement.nodeName !== \"HTML\" : false;\n\t\t\t};\n\n\t\t\t/**\n\t\t\t * Sets document-related variables once based on the current document\n\t\t\t * @param {Element|Object} [doc] An element or document object to use to set the document\n\t\t\t * @returns {Object} Returns the current document\n\t\t\t */\n\t\t\tsetDocument = Sizzle.setDocument = function( node ) {\n\t\t\t\tvar hasCompare, parent,\n\t\t\t\t\tdoc = node ? node.ownerDocument || node : preferredDoc;\n\n\t\t\t\t// Return early if doc is invalid or already selected\n\t\t\t\tif ( doc === document || doc.nodeType !== 9 || !doc.documentElement ) {\n\t\t\t\t\treturn document;\n\t\t\t\t}\n\n\t\t\t\t// Update global variables\n\t\t\t\tdocument = doc;\n\t\t\t\tdocElem = document.documentElement;\n\t\t\t\tdocumentIsHTML = !isXML( document );\n\n\t\t\t\t// Support: IE 9-11, Edge\n\t\t\t\t// Accessing iframe documents after unload throws \"permission denied\" errors (jQuery #13936)\n\t\t\t\tif ( (parent = document.defaultView) && parent.top !== parent ) {\n\t\t\t\t\t// Support: IE 11\n\t\t\t\t\tif ( parent.addEventListener ) {\n\t\t\t\t\t\tparent.addEventListener( \"unload\", unloadHandler, false );\n\n\t\t\t\t\t\t// Support: IE 9 - 10 only\n\t\t\t\t\t} else if ( parent.attachEvent ) {\n\t\t\t\t\t\tparent.attachEvent( \"onunload\", unloadHandler );\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t/* Attributes\n\t\t\t\t ---------------------------------------------------------------------- */\n\n\t\t\t\t// Support: IE<8\n\t\t\t\t// Verify that getAttribute really returns attributes and not properties\n\t\t\t\t// (excepting IE8 booleans)\n\t\t\t\tsupport.attributes = assert(function( div ) {\n\t\t\t\t\tdiv.className = \"i\";\n\t\t\t\t\treturn !div.getAttribute(\"className\");\n\t\t\t\t});\n\n\t\t\t\t/* getElement(s)By*\n\t\t\t\t ---------------------------------------------------------------------- */\n\n\t\t\t\t// Check if getElementsByTagName(\"*\") returns only elements\n\t\t\t\tsupport.getElementsByTagName = assert(function( div ) {\n\t\t\t\t\tdiv.appendChild( document.createComment(\"\") );\n\t\t\t\t\treturn !div.getElementsByTagName(\"*\").length;\n\t\t\t\t});\n\n\t\t\t\t// Support: IE<9\n\t\t\t\tsupport.getElementsByClassName = rnative.test( document.getElementsByClassName );\n\n\t\t\t\t// Support: IE<10\n\t\t\t\t// Check if getElementById returns elements by name\n\t\t\t\t// The broken getElementById methods don't pick up programatically-set names,\n\t\t\t\t// so use a roundabout getElementsByName test\n\t\t\t\tsupport.getById = assert(function( div ) {\n\t\t\t\t\tdocElem.appendChild( div ).id = expando;\n\t\t\t\t\treturn !document.getElementsByName || !document.getElementsByName( expando ).length;\n\t\t\t\t});\n\n\t\t\t\t// ID find and filter\n\t\t\t\tif ( support.getById ) {\n\t\t\t\t\tExpr.find[\"ID\"] = function( id, context ) {\n\t\t\t\t\t\tif ( typeof context.getElementById !== \"undefined\" && documentIsHTML ) {\n\t\t\t\t\t\t\tvar m = context.getElementById( id );\n\t\t\t\t\t\t\treturn m ? [ m ] : [];\n\t\t\t\t\t\t}\n\t\t\t\t\t};\n\t\t\t\t\tExpr.filter[\"ID\"] = function( id ) {\n\t\t\t\t\t\tvar attrId = id.replace( runescape, funescape );\n\t\t\t\t\t\treturn function( elem ) {\n\t\t\t\t\t\t\treturn elem.getAttribute(\"id\") === attrId;\n\t\t\t\t\t\t};\n\t\t\t\t\t};\n\t\t\t\t} else {\n\t\t\t\t\t// Support: IE6/7\n\t\t\t\t\t// getElementById is not reliable as a find shortcut\n\t\t\t\t\tdelete Expr.find[\"ID\"];\n\n\t\t\t\t\tExpr.filter[\"ID\"] =  function( id ) {\n\t\t\t\t\t\tvar attrId = id.replace( runescape, funescape );\n\t\t\t\t\t\treturn function( elem ) {\n\t\t\t\t\t\t\tvar node = typeof elem.getAttributeNode !== \"undefined\" &&\n\t\t\t\t\t\t\t\telem.getAttributeNode(\"id\");\n\t\t\t\t\t\t\treturn node && node.value === attrId;\n\t\t\t\t\t\t};\n\t\t\t\t\t};\n\t\t\t\t}\n\n\t\t\t\t// Tag\n\t\t\t\tExpr.find[\"TAG\"] = support.getElementsByTagName ?\n\t\t\t\t\tfunction( tag, context ) {\n\t\t\t\t\t\tif ( typeof context.getElementsByTagName !== \"undefined\" ) {\n\t\t\t\t\t\t\treturn context.getElementsByTagName( tag );\n\n\t\t\t\t\t\t\t// DocumentFragment nodes don't have gEBTN\n\t\t\t\t\t\t} else if ( support.qsa ) {\n\t\t\t\t\t\t\treturn context.querySelectorAll( tag );\n\t\t\t\t\t\t}\n\t\t\t\t\t} :\n\n\t\t\t\t\tfunction( tag, context ) {\n\t\t\t\t\t\tvar elem,\n\t\t\t\t\t\t\ttmp = [],\n\t\t\t\t\t\t\ti = 0,\n\t\t\t\t\t\t\t// By happy coincidence, a (broken) gEBTN appears on DocumentFragment nodes too\n\t\t\t\t\t\t\tresults = context.getElementsByTagName( tag );\n\n\t\t\t\t\t\t// Filter out possible comments\n\t\t\t\t\t\tif ( tag === \"*\" ) {\n\t\t\t\t\t\t\twhile ( (elem = results[i++]) ) {\n\t\t\t\t\t\t\t\tif ( elem.nodeType === 1 ) {\n\t\t\t\t\t\t\t\t\ttmp.push( elem );\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\treturn tmp;\n\t\t\t\t\t\t}\n\t\t\t\t\t\treturn results;\n\t\t\t\t\t};\n\n\t\t\t\t// Class\n\t\t\t\tExpr.find[\"CLASS\"] = support.getElementsByClassName && function( className, context ) {\n\t\t\t\t\t\tif ( typeof context.getElementsByClassName !== \"undefined\" && documentIsHTML ) {\n\t\t\t\t\t\t\treturn context.getElementsByClassName( className );\n\t\t\t\t\t\t}\n\t\t\t\t\t};\n\n\t\t\t\t/* QSA/matchesSelector\n\t\t\t\t ---------------------------------------------------------------------- */\n\n\t\t\t\t// QSA and matchesSelector support\n\n\t\t\t\t// matchesSelector(:active) reports false when true (IE9/Opera 11.5)\n\t\t\t\trbuggyMatches = [];\n\n\t\t\t\t// qSa(:focus) reports false when true (Chrome 21)\n\t\t\t\t// We allow this because of a bug in IE8/9 that throws an error\n\t\t\t\t// whenever `document.activeElement` is accessed on an iframe\n\t\t\t\t// So, we allow :focus to pass through QSA all the time to avoid the IE error\n\t\t\t\t// See http://bugs.jquery.com/ticket/13378\n\t\t\t\trbuggyQSA = [];\n\n\t\t\t\tif ( (support.qsa = rnative.test( document.querySelectorAll )) ) {\n\t\t\t\t\t// Build QSA regex\n\t\t\t\t\t// Regex strategy adopted from Diego Perini\n\t\t\t\t\tassert(function( div ) {\n\t\t\t\t\t\t// Select is set to empty string on purpose\n\t\t\t\t\t\t// This is to test IE's treatment of not explicitly\n\t\t\t\t\t\t// setting a boolean content attribute,\n\t\t\t\t\t\t// since its presence should be enough\n\t\t\t\t\t\t// http://bugs.jquery.com/ticket/12359\n\t\t\t\t\t\tdocElem.appendChild( div ).innerHTML = \"<a id='\" + expando + \"'></a>\" +\n\t\t\t\t\t\t\t\"<select id='\" + expando + \"-\\r\\\\' msallowcapture=''>\" +\n\t\t\t\t\t\t\t\"<option selected=''></option></select>\";\n\n\t\t\t\t\t\t// Support: IE8, Opera 11-12.16\n\t\t\t\t\t\t// Nothing should be selected when empty strings follow ^= or $= or *=\n\t\t\t\t\t\t// The test attribute must be unknown in Opera but \"safe\" for WinRT\n\t\t\t\t\t\t// http://msdn.microsoft.com/en-us/library/ie/hh465388.aspx#attribute_section\n\t\t\t\t\t\tif ( div.querySelectorAll(\"[msallowcapture^='']\").length ) {\n\t\t\t\t\t\t\trbuggyQSA.push( \"[*^$]=\" + whitespace + \"*(?:''|\\\"\\\")\" );\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Support: IE8\n\t\t\t\t\t\t// Boolean attributes and \"value\" are not treated correctly\n\t\t\t\t\t\tif ( !div.querySelectorAll(\"[selected]\").length ) {\n\t\t\t\t\t\t\trbuggyQSA.push( \"\\\\[\" + whitespace + \"*(?:value|\" + booleans + \")\" );\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Support: Chrome<29, Android<4.4, Safari<7.0+, iOS<7.0+, PhantomJS<1.9.8+\n\t\t\t\t\t\tif ( !div.querySelectorAll( \"[id~=\" + expando + \"-]\" ).length ) {\n\t\t\t\t\t\t\trbuggyQSA.push(\"~=\");\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Webkit/Opera - :checked should return selected option elements\n\t\t\t\t\t\t// http://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked\n\t\t\t\t\t\t// IE8 throws error here and will not see later tests\n\t\t\t\t\t\tif ( !div.querySelectorAll(\":checked\").length ) {\n\t\t\t\t\t\t\trbuggyQSA.push(\":checked\");\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Support: Safari 8+, iOS 8+\n\t\t\t\t\t\t// https://bugs.webkit.org/show_bug.cgi?id=136851\n\t\t\t\t\t\t// In-page `selector#id sibing-combinator selector` fails\n\t\t\t\t\t\tif ( !div.querySelectorAll( \"a#\" + expando + \"+*\" ).length ) {\n\t\t\t\t\t\t\trbuggyQSA.push(\".#.+[+~]\");\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\n\t\t\t\t\tassert(function( div ) {\n\t\t\t\t\t\t// Support: Windows 8 Native Apps\n\t\t\t\t\t\t// The type and name attributes are restricted during .innerHTML assignment\n\t\t\t\t\t\tvar input = document.createElement(\"input\");\n\t\t\t\t\t\tinput.setAttribute( \"type\", \"hidden\" );\n\t\t\t\t\t\tdiv.appendChild( input ).setAttribute( \"name\", \"D\" );\n\n\t\t\t\t\t\t// Support: IE8\n\t\t\t\t\t\t// Enforce case-sensitivity of name attribute\n\t\t\t\t\t\tif ( div.querySelectorAll(\"[name=d]\").length ) {\n\t\t\t\t\t\t\trbuggyQSA.push( \"name\" + whitespace + \"*[*^$|!~]?=\" );\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// FF 3.5 - :enabled/:disabled and hidden elements (hidden elements are still enabled)\n\t\t\t\t\t\t// IE8 throws error here and will not see later tests\n\t\t\t\t\t\tif ( !div.querySelectorAll(\":enabled\").length ) {\n\t\t\t\t\t\t\trbuggyQSA.push( \":enabled\", \":disabled\" );\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Opera 10-11 does not throw on post-comma invalid pseudos\n\t\t\t\t\t\tdiv.querySelectorAll(\"*,:x\");\n\t\t\t\t\t\trbuggyQSA.push(\",.*:\");\n\t\t\t\t\t});\n\t\t\t\t}\n\n\t\t\t\tif ( (support.matchesSelector = rnative.test( (matches = docElem.matches ||\n\t\t\t\t\t\tdocElem.webkitMatchesSelector ||\n\t\t\t\t\t\tdocElem.mozMatchesSelector ||\n\t\t\t\t\t\tdocElem.oMatchesSelector ||\n\t\t\t\t\t\tdocElem.msMatchesSelector) )) ) {\n\n\t\t\t\t\tassert(function( div ) {\n\t\t\t\t\t\t// Check to see if it's possible to do matchesSelector\n\t\t\t\t\t\t// on a disconnected node (IE 9)\n\t\t\t\t\t\tsupport.disconnectedMatch = matches.call( div, \"div\" );\n\n\t\t\t\t\t\t// This should fail with an exception\n\t\t\t\t\t\t// Gecko does not error, returns false instead\n\t\t\t\t\t\tmatches.call( div, \"[s!='']:x\" );\n\t\t\t\t\t\trbuggyMatches.push( \"!=\", pseudos );\n\t\t\t\t\t});\n\t\t\t\t}\n\n\t\t\t\trbuggyQSA = rbuggyQSA.length && new RegExp( rbuggyQSA.join(\"|\") );\n\t\t\t\trbuggyMatches = rbuggyMatches.length && new RegExp( rbuggyMatches.join(\"|\") );\n\n\t\t\t\t/* Contains\n\t\t\t\t ---------------------------------------------------------------------- */\n\t\t\t\thasCompare = rnative.test( docElem.compareDocumentPosition );\n\n\t\t\t\t// Element contains another\n\t\t\t\t// Purposefully self-exclusive\n\t\t\t\t// As in, an element does not contain itself\n\t\t\t\tcontains = hasCompare || rnative.test( docElem.contains ) ?\n\t\t\t\t\tfunction( a, b ) {\n\t\t\t\t\t\tvar adown = a.nodeType === 9 ? a.documentElement : a,\n\t\t\t\t\t\t\tbup = b && b.parentNode;\n\t\t\t\t\t\treturn a === bup || !!( bup && bup.nodeType === 1 && (\n\t\t\t\t\t\t\t\tadown.contains ?\n\t\t\t\t\t\t\t\t\tadown.contains( bup ) :\n\t\t\t\t\t\t\t\ta.compareDocumentPosition && a.compareDocumentPosition( bup ) & 16\n\t\t\t\t\t\t\t));\n\t\t\t\t\t} :\n\t\t\t\t\tfunction( a, b ) {\n\t\t\t\t\t\tif ( b ) {\n\t\t\t\t\t\t\twhile ( (b = b.parentNode) ) {\n\t\t\t\t\t\t\t\tif ( b === a ) {\n\t\t\t\t\t\t\t\t\treturn true;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t};\n\n\t\t\t\t/* Sorting\n\t\t\t\t ---------------------------------------------------------------------- */\n\n\t\t\t\t// Document order sorting\n\t\t\t\tsortOrder = hasCompare ?\n\t\t\t\t\tfunction( a, b ) {\n\n\t\t\t\t\t\t// Flag for duplicate removal\n\t\t\t\t\t\tif ( a === b ) {\n\t\t\t\t\t\t\thasDuplicate = true;\n\t\t\t\t\t\t\treturn 0;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Sort on method existence if only one input has compareDocumentPosition\n\t\t\t\t\t\tvar compare = !a.compareDocumentPosition - !b.compareDocumentPosition;\n\t\t\t\t\t\tif ( compare ) {\n\t\t\t\t\t\t\treturn compare;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Calculate position if both inputs belong to the same document\n\t\t\t\t\t\tcompare = ( a.ownerDocument || a ) === ( b.ownerDocument || b ) ?\n\t\t\t\t\t\t\ta.compareDocumentPosition( b ) :\n\n\t\t\t\t\t\t\t// Otherwise we know they are disconnected\n\t\t\t\t\t\t\t1;\n\n\t\t\t\t\t\t// Disconnected nodes\n\t\t\t\t\t\tif ( compare & 1 ||\n\t\t\t\t\t\t\t(!support.sortDetached && b.compareDocumentPosition( a ) === compare) ) {\n\n\t\t\t\t\t\t\t// Choose the first element that is related to our preferred document\n\t\t\t\t\t\t\tif ( a === document || a.ownerDocument === preferredDoc && contains(preferredDoc, a) ) {\n\t\t\t\t\t\t\t\treturn -1;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tif ( b === document || b.ownerDocument === preferredDoc && contains(preferredDoc, b) ) {\n\t\t\t\t\t\t\t\treturn 1;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// Maintain original order\n\t\t\t\t\t\t\treturn sortInput ?\n\t\t\t\t\t\t\t\t( indexOf( sortInput, a ) - indexOf( sortInput, b ) ) :\n\t\t\t\t\t\t\t\t0;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn compare & 4 ? -1 : 1;\n\t\t\t\t\t} :\n\t\t\t\t\tfunction( a, b ) {\n\t\t\t\t\t\t// Exit early if the nodes are identical\n\t\t\t\t\t\tif ( a === b ) {\n\t\t\t\t\t\t\thasDuplicate = true;\n\t\t\t\t\t\t\treturn 0;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tvar cur,\n\t\t\t\t\t\t\ti = 0,\n\t\t\t\t\t\t\taup = a.parentNode,\n\t\t\t\t\t\t\tbup = b.parentNode,\n\t\t\t\t\t\t\tap = [ a ],\n\t\t\t\t\t\t\tbp = [ b ];\n\n\t\t\t\t\t\t// Parentless nodes are either documents or disconnected\n\t\t\t\t\t\tif ( !aup || !bup ) {\n\t\t\t\t\t\t\treturn a === document ? -1 :\n\t\t\t\t\t\t\t\tb === document ? 1 :\n\t\t\t\t\t\t\t\t\taup ? -1 :\n\t\t\t\t\t\t\t\t\t\tbup ? 1 :\n\t\t\t\t\t\t\t\t\t\t\tsortInput ?\n\t\t\t\t\t\t\t\t\t\t\t\t( indexOf( sortInput, a ) - indexOf( sortInput, b ) ) :\n\t\t\t\t\t\t\t\t\t\t\t\t0;\n\n\t\t\t\t\t\t\t// If the nodes are siblings, we can do a quick check\n\t\t\t\t\t\t} else if ( aup === bup ) {\n\t\t\t\t\t\t\treturn siblingCheck( a, b );\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Otherwise we need full lists of their ancestors for comparison\n\t\t\t\t\t\tcur = a;\n\t\t\t\t\t\twhile ( (cur = cur.parentNode) ) {\n\t\t\t\t\t\t\tap.unshift( cur );\n\t\t\t\t\t\t}\n\t\t\t\t\t\tcur = b;\n\t\t\t\t\t\twhile ( (cur = cur.parentNode) ) {\n\t\t\t\t\t\t\tbp.unshift( cur );\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Walk down the tree looking for a discrepancy\n\t\t\t\t\t\twhile ( ap[i] === bp[i] ) {\n\t\t\t\t\t\t\ti++;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn i ?\n\t\t\t\t\t\t\t// Do a sibling check if the nodes have a common ancestor\n\t\t\t\t\t\t\tsiblingCheck( ap[i], bp[i] ) :\n\n\t\t\t\t\t\t\t// Otherwise nodes in our document sort first\n\t\t\t\t\t\t\tap[i] === preferredDoc ? -1 :\n\t\t\t\t\t\t\t\tbp[i] === preferredDoc ? 1 :\n\t\t\t\t\t\t\t\t\t0;\n\t\t\t\t\t};\n\n\t\t\t\treturn document;\n\t\t\t};\n\n\t\t\tSizzle.matches = function( expr, elements ) {\n\t\t\t\treturn Sizzle( expr, null, null, elements );\n\t\t\t};\n\n\t\t\tSizzle.matchesSelector = function( elem, expr ) {\n\t\t\t\t// Set document vars if needed\n\t\t\t\tif ( ( elem.ownerDocument || elem ) !== document ) {\n\t\t\t\t\tsetDocument( elem );\n\t\t\t\t}\n\n\t\t\t\t// Make sure that attribute selectors are quoted\n\t\t\t\texpr = expr.replace( rattributeQuotes, \"='$1']\" );\n\n\t\t\t\tif ( support.matchesSelector && documentIsHTML &&\n\t\t\t\t\t!compilerCache[ expr + \" \" ] &&\n\t\t\t\t\t( !rbuggyMatches || !rbuggyMatches.test( expr ) ) &&\n\t\t\t\t\t( !rbuggyQSA     || !rbuggyQSA.test( expr ) ) ) {\n\n\t\t\t\t\ttry {\n\t\t\t\t\t\tvar ret = matches.call( elem, expr );\n\n\t\t\t\t\t\t// IE 9's matchesSelector returns false on disconnected nodes\n\t\t\t\t\t\tif ( ret || support.disconnectedMatch ||\n\t\t\t\t\t\t\t// As well, disconnected nodes are said to be in a document\n\t\t\t\t\t\t\t// fragment in IE 9\n\t\t\t\t\t\t\telem.document && elem.document.nodeType !== 11 ) {\n\t\t\t\t\t\t\treturn ret;\n\t\t\t\t\t\t}\n\t\t\t\t\t} catch (e) {}\n\t\t\t\t}\n\n\t\t\t\treturn Sizzle( expr, document, null, [ elem ] ).length > 0;\n\t\t\t};\n\n\t\t\tSizzle.contains = function( context, elem ) {\n\t\t\t\t// Set document vars if needed\n\t\t\t\tif ( ( context.ownerDocument || context ) !== document ) {\n\t\t\t\t\tsetDocument( context );\n\t\t\t\t}\n\t\t\t\treturn contains( context, elem );\n\t\t\t};\n\n\t\t\tSizzle.attr = function( elem, name ) {\n\t\t\t\t// Set document vars if needed\n\t\t\t\tif ( ( elem.ownerDocument || elem ) !== document ) {\n\t\t\t\t\tsetDocument( elem );\n\t\t\t\t}\n\n\t\t\t\tvar fn = Expr.attrHandle[ name.toLowerCase() ],\n\t\t\t\t\t// Don't get fooled by Object.prototype properties (jQuery #13807)\n\t\t\t\t\tval = fn && hasOwn.call( Expr.attrHandle, name.toLowerCase() ) ?\n\t\t\t\t\t\tfn( elem, name, !documentIsHTML ) :\n\t\t\t\t\t\tundefined;\n\n\t\t\t\treturn val !== undefined ?\n\t\t\t\t\tval :\n\t\t\t\t\tsupport.attributes || !documentIsHTML ?\n\t\t\t\t\t\telem.getAttribute( name ) :\n\t\t\t\t\t\t(val = elem.getAttributeNode(name)) && val.specified ?\n\t\t\t\t\t\t\tval.value :\n\t\t\t\t\t\t\tnull;\n\t\t\t};\n\n\t\t\tSizzle.error = function( msg ) {\n\t\t\t\tthrow new Error( \"Syntax error, unrecognized expression: \" + msg );\n\t\t\t};\n\n\t\t\t/**\n\t\t\t * Document sorting and removing duplicates\n\t\t\t * @param {ArrayLike} results\n\t\t\t */\n\t\t\tSizzle.uniqueSort = function( results ) {\n\t\t\t\tvar elem,\n\t\t\t\t\tduplicates = [],\n\t\t\t\t\tj = 0,\n\t\t\t\t\ti = 0;\n\n\t\t\t\t// Unless we *know* we can detect duplicates, assume their presence\n\t\t\t\thasDuplicate = !support.detectDuplicates;\n\t\t\t\tsortInput = !support.sortStable && results.slice( 0 );\n\t\t\t\tresults.sort( sortOrder );\n\n\t\t\t\tif ( hasDuplicate ) {\n\t\t\t\t\twhile ( (elem = results[i++]) ) {\n\t\t\t\t\t\tif ( elem === results[ i ] ) {\n\t\t\t\t\t\t\tj = duplicates.push( i );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\twhile ( j-- ) {\n\t\t\t\t\t\tresults.splice( duplicates[ j ], 1 );\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Clear input after sorting to release objects\n\t\t\t\t// See https://github.com/jquery/sizzle/pull/225\n\t\t\t\tsortInput = null;\n\n\t\t\t\treturn results;\n\t\t\t};\n\n\t\t\t/**\n\t\t\t * Utility function for retrieving the text value of an array of DOM nodes\n\t\t\t * @param {Array|Element} elem\n\t\t\t */\n\t\t\tgetText = Sizzle.getText = function( elem ) {\n\t\t\t\tvar node,\n\t\t\t\t\tret = \"\",\n\t\t\t\t\ti = 0,\n\t\t\t\t\tnodeType = elem.nodeType;\n\n\t\t\t\tif ( !nodeType ) {\n\t\t\t\t\t// If no nodeType, this is expected to be an array\n\t\t\t\t\twhile ( (node = elem[i++]) ) {\n\t\t\t\t\t\t// Do not traverse comment nodes\n\t\t\t\t\t\tret += getText( node );\n\t\t\t\t\t}\n\t\t\t\t} else if ( nodeType === 1 || nodeType === 9 || nodeType === 11 ) {\n\t\t\t\t\t// Use textContent for elements\n\t\t\t\t\t// innerText usage removed for consistency of new lines (jQuery #11153)\n\t\t\t\t\tif ( typeof elem.textContent === \"string\" ) {\n\t\t\t\t\t\treturn elem.textContent;\n\t\t\t\t\t} else {\n\t\t\t\t\t\t// Traverse its children\n\t\t\t\t\t\tfor ( elem = elem.firstChild; elem; elem = elem.nextSibling ) {\n\t\t\t\t\t\t\tret += getText( elem );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t} else if ( nodeType === 3 || nodeType === 4 ) {\n\t\t\t\t\treturn elem.nodeValue;\n\t\t\t\t}\n\t\t\t\t// Do not include comment or processing instruction nodes\n\n\t\t\t\treturn ret;\n\t\t\t};\n\n\t\t\tExpr = Sizzle.selectors = {\n\n\t\t\t\t// Can be adjusted by the user\n\t\t\t\tcacheLength: 50,\n\n\t\t\t\tcreatePseudo: markFunction,\n\n\t\t\t\tmatch: matchExpr,\n\n\t\t\t\tattrHandle: {},\n\n\t\t\t\tfind: {},\n\n\t\t\t\trelative: {\n\t\t\t\t\t\">\": { dir: \"parentNode\", first: true },\n\t\t\t\t\t\" \": { dir: \"parentNode\" },\n\t\t\t\t\t\"+\": { dir: \"previousSibling\", first: true },\n\t\t\t\t\t\"~\": { dir: \"previousSibling\" }\n\t\t\t\t},\n\n\t\t\t\tpreFilter: {\n\t\t\t\t\t\"ATTR\": function( match ) {\n\t\t\t\t\t\tmatch[1] = match[1].replace( runescape, funescape );\n\n\t\t\t\t\t\t// Move the given value to match[3] whether quoted or unquoted\n\t\t\t\t\t\tmatch[3] = ( match[3] || match[4] || match[5] || \"\" ).replace( runescape, funescape );\n\n\t\t\t\t\t\tif ( match[2] === \"~=\" ) {\n\t\t\t\t\t\t\tmatch[3] = \" \" + match[3] + \" \";\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn match.slice( 0, 4 );\n\t\t\t\t\t},\n\n\t\t\t\t\t\"CHILD\": function( match ) {\n\t\t\t\t\t\t/* matches from matchExpr[\"CHILD\"]\n\t\t\t\t\t\t 1 type (only|nth|...)\n\t\t\t\t\t\t 2 what (child|of-type)\n\t\t\t\t\t\t 3 argument (even|odd|\\d*|\\d*n([+-]\\d+)?|...)\n\t\t\t\t\t\t 4 xn-component of xn+y argument ([+-]?\\d*n|)\n\t\t\t\t\t\t 5 sign of xn-component\n\t\t\t\t\t\t 6 x of xn-component\n\t\t\t\t\t\t 7 sign of y-component\n\t\t\t\t\t\t 8 y of y-component\n\t\t\t\t\t\t */\n\t\t\t\t\t\tmatch[1] = match[1].toLowerCase();\n\n\t\t\t\t\t\tif ( match[1].slice( 0, 3 ) === \"nth\" ) {\n\t\t\t\t\t\t\t// nth-* requires argument\n\t\t\t\t\t\t\tif ( !match[3] ) {\n\t\t\t\t\t\t\t\tSizzle.error( match[0] );\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// numeric x and y parameters for Expr.filter.CHILD\n\t\t\t\t\t\t\t// remember that false/true cast respectively to 0/1\n\t\t\t\t\t\t\tmatch[4] = +( match[4] ? match[5] + (match[6] || 1) : 2 * ( match[3] === \"even\" || match[3] === \"odd\" ) );\n\t\t\t\t\t\t\tmatch[5] = +( ( match[7] + match[8] ) || match[3] === \"odd\" );\n\n\t\t\t\t\t\t\t// other types prohibit arguments\n\t\t\t\t\t\t} else if ( match[3] ) {\n\t\t\t\t\t\t\tSizzle.error( match[0] );\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn match;\n\t\t\t\t\t},\n\n\t\t\t\t\t\"PSEUDO\": function( match ) {\n\t\t\t\t\t\tvar excess,\n\t\t\t\t\t\t\tunquoted = !match[6] && match[2];\n\n\t\t\t\t\t\tif ( matchExpr[\"CHILD\"].test( match[0] ) ) {\n\t\t\t\t\t\t\treturn null;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Accept quoted arguments as-is\n\t\t\t\t\t\tif ( match[3] ) {\n\t\t\t\t\t\t\tmatch[2] = match[4] || match[5] || \"\";\n\n\t\t\t\t\t\t\t// Strip excess characters from unquoted arguments\n\t\t\t\t\t\t} else if ( unquoted && rpseudo.test( unquoted ) &&\n\t\t\t\t\t\t\t// Get excess from tokenize (recursively)\n\t\t\t\t\t\t\t(excess = tokenize( unquoted, true )) &&\n\t\t\t\t\t\t\t// advance to the next closing parenthesis\n\t\t\t\t\t\t\t(excess = unquoted.indexOf( \")\", unquoted.length - excess ) - unquoted.length) ) {\n\n\t\t\t\t\t\t\t// excess is a negative index\n\t\t\t\t\t\t\tmatch[0] = match[0].slice( 0, excess );\n\t\t\t\t\t\t\tmatch[2] = unquoted.slice( 0, excess );\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Return only captures needed by the pseudo filter method (type and argument)\n\t\t\t\t\t\treturn match.slice( 0, 3 );\n\t\t\t\t\t}\n\t\t\t\t},\n\n\t\t\t\tfilter: {\n\n\t\t\t\t\t\"TAG\": function( nodeNameSelector ) {\n\t\t\t\t\t\tvar nodeName = nodeNameSelector.replace( runescape, funescape ).toLowerCase();\n\t\t\t\t\t\treturn nodeNameSelector === \"*\" ?\n\t\t\t\t\t\t\tfunction() { return true; } :\n\t\t\t\t\t\t\tfunction( elem ) {\n\t\t\t\t\t\t\t\treturn elem.nodeName && elem.nodeName.toLowerCase() === nodeName;\n\t\t\t\t\t\t\t};\n\t\t\t\t\t},\n\n\t\t\t\t\t\"CLASS\": function( className ) {\n\t\t\t\t\t\tvar pattern = classCache[ className + \" \" ];\n\n\t\t\t\t\t\treturn pattern ||\n\t\t\t\t\t\t\t(pattern = new RegExp( \"(^|\" + whitespace + \")\" + className + \"(\" + whitespace + \"|$)\" )) &&\n\t\t\t\t\t\t\tclassCache( className, function( elem ) {\n\t\t\t\t\t\t\t\treturn pattern.test( typeof elem.className === \"string\" && elem.className || typeof elem.getAttribute !== \"undefined\" && elem.getAttribute(\"class\") || \"\" );\n\t\t\t\t\t\t\t});\n\t\t\t\t\t},\n\n\t\t\t\t\t\"ATTR\": function( name, operator, check ) {\n\t\t\t\t\t\treturn function( elem ) {\n\t\t\t\t\t\t\tvar result = Sizzle.attr( elem, name );\n\n\t\t\t\t\t\t\tif ( result == null ) {\n\t\t\t\t\t\t\t\treturn operator === \"!=\";\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tif ( !operator ) {\n\t\t\t\t\t\t\t\treturn true;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tresult += \"\";\n\n\t\t\t\t\t\t\treturn operator === \"=\" ? result === check :\n\t\t\t\t\t\t\t\toperator === \"!=\" ? result !== check :\n\t\t\t\t\t\t\t\t\toperator === \"^=\" ? check && result.indexOf( check ) === 0 :\n\t\t\t\t\t\t\t\t\t\toperator === \"*=\" ? check && result.indexOf( check ) > -1 :\n\t\t\t\t\t\t\t\t\t\t\toperator === \"$=\" ? check && result.slice( -check.length ) === check :\n\t\t\t\t\t\t\t\t\t\t\t\toperator === \"~=\" ? ( \" \" + result.replace( rwhitespace, \" \" ) + \" \" ).indexOf( check ) > -1 :\n\t\t\t\t\t\t\t\t\t\t\t\t\toperator === \"|=\" ? result === check || result.slice( 0, check.length + 1 ) === check + \"-\" :\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tfalse;\n\t\t\t\t\t\t};\n\t\t\t\t\t},\n\n\t\t\t\t\t\"CHILD\": function( type, what, argument, first, last ) {\n\t\t\t\t\t\tvar simple = type.slice( 0, 3 ) !== \"nth\",\n\t\t\t\t\t\t\tforward = type.slice( -4 ) !== \"last\",\n\t\t\t\t\t\t\tofType = what === \"of-type\";\n\n\t\t\t\t\t\treturn first === 1 && last === 0 ?\n\n\t\t\t\t\t\t\t// Shortcut for :nth-*(n)\n\t\t\t\t\t\t\tfunction( elem ) {\n\t\t\t\t\t\t\t\treturn !!elem.parentNode;\n\t\t\t\t\t\t\t} :\n\n\t\t\t\t\t\t\tfunction( elem, context, xml ) {\n\t\t\t\t\t\t\t\tvar cache, uniqueCache, outerCache, node, nodeIndex, start,\n\t\t\t\t\t\t\t\t\tdir = simple !== forward ? \"nextSibling\" : \"previousSibling\",\n\t\t\t\t\t\t\t\t\tparent = elem.parentNode,\n\t\t\t\t\t\t\t\t\tname = ofType && elem.nodeName.toLowerCase(),\n\t\t\t\t\t\t\t\t\tuseCache = !xml && !ofType,\n\t\t\t\t\t\t\t\t\tdiff = false;\n\n\t\t\t\t\t\t\t\tif ( parent ) {\n\n\t\t\t\t\t\t\t\t\t// :(first|last|only)-(child|of-type)\n\t\t\t\t\t\t\t\t\tif ( simple ) {\n\t\t\t\t\t\t\t\t\t\twhile ( dir ) {\n\t\t\t\t\t\t\t\t\t\t\tnode = elem;\n\t\t\t\t\t\t\t\t\t\t\twhile ( (node = node[ dir ]) ) {\n\t\t\t\t\t\t\t\t\t\t\t\tif ( ofType ?\n\t\t\t\t\t\t\t\t\t\t\t\t\tnode.nodeName.toLowerCase() === name :\n\t\t\t\t\t\t\t\t\t\t\t\t\tnode.nodeType === 1 ) {\n\n\t\t\t\t\t\t\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t\t// Reverse direction for :only-* (if we haven't yet done so)\n\t\t\t\t\t\t\t\t\t\t\tstart = dir = type === \"only\" && !start && \"nextSibling\";\n\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\treturn true;\n\t\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t\tstart = [ forward ? parent.firstChild : parent.lastChild ];\n\n\t\t\t\t\t\t\t\t\t// non-xml :nth-child(...) stores cache data on `parent`\n\t\t\t\t\t\t\t\t\tif ( forward && useCache ) {\n\n\t\t\t\t\t\t\t\t\t\t// Seek `elem` from a previously-cached index\n\n\t\t\t\t\t\t\t\t\t\t// ...in a gzip-friendly way\n\t\t\t\t\t\t\t\t\t\tnode = parent;\n\t\t\t\t\t\t\t\t\t\touterCache = node[ expando ] || (node[ expando ] = {});\n\n\t\t\t\t\t\t\t\t\t\t// Support: IE <9 only\n\t\t\t\t\t\t\t\t\t\t// Defend against cloned attroperties (jQuery gh-1709)\n\t\t\t\t\t\t\t\t\t\tuniqueCache = outerCache[ node.uniqueID ] ||\n\t\t\t\t\t\t\t\t\t\t\t(outerCache[ node.uniqueID ] = {});\n\n\t\t\t\t\t\t\t\t\t\tcache = uniqueCache[ type ] || [];\n\t\t\t\t\t\t\t\t\t\tnodeIndex = cache[ 0 ] === dirruns && cache[ 1 ];\n\t\t\t\t\t\t\t\t\t\tdiff = nodeIndex && cache[ 2 ];\n\t\t\t\t\t\t\t\t\t\tnode = nodeIndex && parent.childNodes[ nodeIndex ];\n\n\t\t\t\t\t\t\t\t\t\twhile ( (node = ++nodeIndex && node && node[ dir ] ||\n\n\t\t\t\t\t\t\t\t\t\t\t// Fallback to seeking `elem` from the start\n\t\t\t\t\t\t\t\t\t\t\t(diff = nodeIndex = 0) || start.pop()) ) {\n\n\t\t\t\t\t\t\t\t\t\t\t// When found, cache indexes on `parent` and break\n\t\t\t\t\t\t\t\t\t\t\tif ( node.nodeType === 1 && ++diff && node === elem ) {\n\t\t\t\t\t\t\t\t\t\t\t\tuniqueCache[ type ] = [ dirruns, nodeIndex, diff ];\n\t\t\t\t\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\t\t// Use previously-cached element index if available\n\t\t\t\t\t\t\t\t\t\tif ( useCache ) {\n\t\t\t\t\t\t\t\t\t\t\t// ...in a gzip-friendly way\n\t\t\t\t\t\t\t\t\t\t\tnode = elem;\n\t\t\t\t\t\t\t\t\t\t\touterCache = node[ expando ] || (node[ expando ] = {});\n\n\t\t\t\t\t\t\t\t\t\t\t// Support: IE <9 only\n\t\t\t\t\t\t\t\t\t\t\t// Defend against cloned attroperties (jQuery gh-1709)\n\t\t\t\t\t\t\t\t\t\t\tuniqueCache = outerCache[ node.uniqueID ] ||\n\t\t\t\t\t\t\t\t\t\t\t\t(outerCache[ node.uniqueID ] = {});\n\n\t\t\t\t\t\t\t\t\t\t\tcache = uniqueCache[ type ] || [];\n\t\t\t\t\t\t\t\t\t\t\tnodeIndex = cache[ 0 ] === dirruns && cache[ 1 ];\n\t\t\t\t\t\t\t\t\t\t\tdiff = nodeIndex;\n\t\t\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t\t\t// xml :nth-child(...)\n\t\t\t\t\t\t\t\t\t\t// or :nth-last-child(...) or :nth(-last)?-of-type(...)\n\t\t\t\t\t\t\t\t\t\tif ( diff === false ) {\n\t\t\t\t\t\t\t\t\t\t\t// Use the same loop as above to seek `elem` from the start\n\t\t\t\t\t\t\t\t\t\t\twhile ( (node = ++nodeIndex && node && node[ dir ] ||\n\t\t\t\t\t\t\t\t\t\t\t\t(diff = nodeIndex = 0) || start.pop()) ) {\n\n\t\t\t\t\t\t\t\t\t\t\t\tif ( ( ofType ?\n\t\t\t\t\t\t\t\t\t\t\t\t\tnode.nodeName.toLowerCase() === name :\n\t\t\t\t\t\t\t\t\t\t\t\t\tnode.nodeType === 1 ) &&\n\t\t\t\t\t\t\t\t\t\t\t\t\t++diff ) {\n\n\t\t\t\t\t\t\t\t\t\t\t\t\t// Cache the index of each encountered element\n\t\t\t\t\t\t\t\t\t\t\t\t\tif ( useCache ) {\n\t\t\t\t\t\t\t\t\t\t\t\t\t\touterCache = node[ expando ] || (node[ expando ] = {});\n\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t// Support: IE <9 only\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t// Defend against cloned attroperties (jQuery gh-1709)\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tuniqueCache = outerCache[ node.uniqueID ] ||\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t(outerCache[ node.uniqueID ] = {});\n\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tuniqueCache[ type ] = [ dirruns, diff ];\n\t\t\t\t\t\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t\t\t\t\t\tif ( node === elem ) {\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t\t// Incorporate the offset, then check against cycle size\n\t\t\t\t\t\t\t\t\tdiff -= last;\n\t\t\t\t\t\t\t\t\treturn diff === first || ( diff % first === 0 && diff / first >= 0 );\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t};\n\t\t\t\t\t},\n\n\t\t\t\t\t\"PSEUDO\": function( pseudo, argument ) {\n\t\t\t\t\t\t// pseudo-class names are case-insensitive\n\t\t\t\t\t\t// http://www.w3.org/TR/selectors/#pseudo-classes\n\t\t\t\t\t\t// Prioritize by case sensitivity in case custom pseudos are added with uppercase letters\n\t\t\t\t\t\t// Remember that setFilters inherits from pseudos\n\t\t\t\t\t\tvar args,\n\t\t\t\t\t\t\tfn = Expr.pseudos[ pseudo ] || Expr.setFilters[ pseudo.toLowerCase() ] ||\n\t\t\t\t\t\t\t\tSizzle.error( \"unsupported pseudo: \" + pseudo );\n\n\t\t\t\t\t\t// The user may use createPseudo to indicate that\n\t\t\t\t\t\t// arguments are needed to create the filter function\n\t\t\t\t\t\t// just as Sizzle does\n\t\t\t\t\t\tif ( fn[ expando ] ) {\n\t\t\t\t\t\t\treturn fn( argument );\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// But maintain support for old signatures\n\t\t\t\t\t\tif ( fn.length > 1 ) {\n\t\t\t\t\t\t\targs = [ pseudo, pseudo, \"\", argument ];\n\t\t\t\t\t\t\treturn Expr.setFilters.hasOwnProperty( pseudo.toLowerCase() ) ?\n\t\t\t\t\t\t\t\tmarkFunction(function( seed, matches ) {\n\t\t\t\t\t\t\t\t\tvar idx,\n\t\t\t\t\t\t\t\t\t\tmatched = fn( seed, argument ),\n\t\t\t\t\t\t\t\t\t\ti = matched.length;\n\t\t\t\t\t\t\t\t\twhile ( i-- ) {\n\t\t\t\t\t\t\t\t\t\tidx = indexOf( seed, matched[i] );\n\t\t\t\t\t\t\t\t\t\tseed[ idx ] = !( matches[ idx ] = matched[i] );\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}) :\n\t\t\t\t\t\t\t\tfunction( elem ) {\n\t\t\t\t\t\t\t\t\treturn fn( elem, 0, args );\n\t\t\t\t\t\t\t\t};\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn fn;\n\t\t\t\t\t}\n\t\t\t\t},\n\n\t\t\t\tpseudos: {\n\t\t\t\t\t// Potentially complex pseudos\n\t\t\t\t\t\"not\": markFunction(function( selector ) {\n\t\t\t\t\t\t// Trim the selector passed to compile\n\t\t\t\t\t\t// to avoid treating leading and trailing\n\t\t\t\t\t\t// spaces as combinators\n\t\t\t\t\t\tvar input = [],\n\t\t\t\t\t\t\tresults = [],\n\t\t\t\t\t\t\tmatcher = compile( selector.replace( rtrim, \"$1\" ) );\n\n\t\t\t\t\t\treturn matcher[ expando ] ?\n\t\t\t\t\t\t\tmarkFunction(function( seed, matches, context, xml ) {\n\t\t\t\t\t\t\t\tvar elem,\n\t\t\t\t\t\t\t\t\tunmatched = matcher( seed, null, xml, [] ),\n\t\t\t\t\t\t\t\t\ti = seed.length;\n\n\t\t\t\t\t\t\t\t// Match elements unmatched by `matcher`\n\t\t\t\t\t\t\t\twhile ( i-- ) {\n\t\t\t\t\t\t\t\t\tif ( (elem = unmatched[i]) ) {\n\t\t\t\t\t\t\t\t\t\tseed[i] = !(matches[i] = elem);\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}) :\n\t\t\t\t\t\t\tfunction( elem, context, xml ) {\n\t\t\t\t\t\t\t\tinput[0] = elem;\n\t\t\t\t\t\t\t\tmatcher( input, null, xml, results );\n\t\t\t\t\t\t\t\t// Don't keep the element (issue #299)\n\t\t\t\t\t\t\t\tinput[0] = null;\n\t\t\t\t\t\t\t\treturn !results.pop();\n\t\t\t\t\t\t\t};\n\t\t\t\t\t}),\n\n\t\t\t\t\t\"has\": markFunction(function( selector ) {\n\t\t\t\t\t\treturn function( elem ) {\n\t\t\t\t\t\t\treturn Sizzle( selector, elem ).length > 0;\n\t\t\t\t\t\t};\n\t\t\t\t\t}),\n\n\t\t\t\t\t\"contains\": markFunction(function( text ) {\n\t\t\t\t\t\ttext = text.replace( runescape, funescape );\n\t\t\t\t\t\treturn function( elem ) {\n\t\t\t\t\t\t\treturn ( elem.textContent || elem.innerText || getText( elem ) ).indexOf( text ) > -1;\n\t\t\t\t\t\t};\n\t\t\t\t\t}),\n\n\t\t\t\t\t// \"Whether an element is represented by a :lang() selector\n\t\t\t\t\t// is based solely on the element's language value\n\t\t\t\t\t// being equal to the identifier C,\n\t\t\t\t\t// or beginning with the identifier C immediately followed by \"-\".\n\t\t\t\t\t// The matching of C against the element's language value is performed case-insensitively.\n\t\t\t\t\t// The identifier C does not have to be a valid language name.\"\n\t\t\t\t\t// http://www.w3.org/TR/selectors/#lang-pseudo\n\t\t\t\t\t\"lang\": markFunction( function( lang ) {\n\t\t\t\t\t\t// lang value must be a valid identifier\n\t\t\t\t\t\tif ( !ridentifier.test(lang || \"\") ) {\n\t\t\t\t\t\t\tSizzle.error( \"unsupported lang: \" + lang );\n\t\t\t\t\t\t}\n\t\t\t\t\t\tlang = lang.replace( runescape, funescape ).toLowerCase();\n\t\t\t\t\t\treturn function( elem ) {\n\t\t\t\t\t\t\tvar elemLang;\n\t\t\t\t\t\t\tdo {\n\t\t\t\t\t\t\t\tif ( (elemLang = documentIsHTML ?\n\t\t\t\t\t\t\t\t\t\telem.lang :\n\t\t\t\t\t\t\t\t\telem.getAttribute(\"xml:lang\") || elem.getAttribute(\"lang\")) ) {\n\n\t\t\t\t\t\t\t\t\telemLang = elemLang.toLowerCase();\n\t\t\t\t\t\t\t\t\treturn elemLang === lang || elemLang.indexOf( lang + \"-\" ) === 0;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t} while ( (elem = elem.parentNode) && elem.nodeType === 1 );\n\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t};\n\t\t\t\t\t}),\n\n\t\t\t\t\t// Miscellaneous\n\t\t\t\t\t\"target\": function( elem ) {\n\t\t\t\t\t\tvar hash = window.location && window.location.hash;\n\t\t\t\t\t\treturn hash && hash.slice( 1 ) === elem.id;\n\t\t\t\t\t},\n\n\t\t\t\t\t\"root\": function( elem ) {\n\t\t\t\t\t\treturn elem === docElem;\n\t\t\t\t\t},\n\n\t\t\t\t\t\"focus\": function( elem ) {\n\t\t\t\t\t\treturn elem === document.activeElement && (!document.hasFocus || document.hasFocus()) && !!(elem.type || elem.href || ~elem.tabIndex);\n\t\t\t\t\t},\n\n\t\t\t\t\t// Boolean properties\n\t\t\t\t\t\"enabled\": function( elem ) {\n\t\t\t\t\t\treturn elem.disabled === false;\n\t\t\t\t\t},\n\n\t\t\t\t\t\"disabled\": function( elem ) {\n\t\t\t\t\t\treturn elem.disabled === true;\n\t\t\t\t\t},\n\n\t\t\t\t\t\"checked\": function( elem ) {\n\t\t\t\t\t\t// In CSS3, :checked should return both checked and selected elements\n\t\t\t\t\t\t// http://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked\n\t\t\t\t\t\tvar nodeName = elem.nodeName.toLowerCase();\n\t\t\t\t\t\treturn (nodeName === \"input\" && !!elem.checked) || (nodeName === \"option\" && !!elem.selected);\n\t\t\t\t\t},\n\n\t\t\t\t\t\"selected\": function( elem ) {\n\t\t\t\t\t\t// Accessing this property makes selected-by-default\n\t\t\t\t\t\t// options in Safari work properly\n\t\t\t\t\t\tif ( elem.parentNode ) {\n\t\t\t\t\t\t\telem.parentNode.selectedIndex;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn elem.selected === true;\n\t\t\t\t\t},\n\n\t\t\t\t\t// Contents\n\t\t\t\t\t\"empty\": function( elem ) {\n\t\t\t\t\t\t// http://www.w3.org/TR/selectors/#empty-pseudo\n\t\t\t\t\t\t// :empty is negated by element (1) or content nodes (text: 3; cdata: 4; entity ref: 5),\n\t\t\t\t\t\t//   but not by others (comment: 8; processing instruction: 7; etc.)\n\t\t\t\t\t\t// nodeType < 6 works because attributes (2) do not appear as children\n\t\t\t\t\t\tfor ( elem = elem.firstChild; elem; elem = elem.nextSibling ) {\n\t\t\t\t\t\t\tif ( elem.nodeType < 6 ) {\n\t\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\treturn true;\n\t\t\t\t\t},\n\n\t\t\t\t\t\"parent\": function( elem ) {\n\t\t\t\t\t\treturn !Expr.pseudos[\"empty\"]( elem );\n\t\t\t\t\t},\n\n\t\t\t\t\t// Element/input types\n\t\t\t\t\t\"header\": function( elem ) {\n\t\t\t\t\t\treturn rheader.test( elem.nodeName );\n\t\t\t\t\t},\n\n\t\t\t\t\t\"input\": function( elem ) {\n\t\t\t\t\t\treturn rinputs.test( elem.nodeName );\n\t\t\t\t\t},\n\n\t\t\t\t\t\"button\": function( elem ) {\n\t\t\t\t\t\tvar name = elem.nodeName.toLowerCase();\n\t\t\t\t\t\treturn name === \"input\" && elem.type === \"button\" || name === \"button\";\n\t\t\t\t\t},\n\n\t\t\t\t\t\"text\": function( elem ) {\n\t\t\t\t\t\tvar attr;\n\t\t\t\t\t\treturn elem.nodeName.toLowerCase() === \"input\" &&\n\t\t\t\t\t\t\telem.type === \"text\" &&\n\n\t\t\t\t\t\t\t// Support: IE<8\n\t\t\t\t\t\t\t// New HTML5 attribute values (e.g., \"search\") appear with elem.type === \"text\"\n\t\t\t\t\t\t\t( (attr = elem.getAttribute(\"type\")) == null || attr.toLowerCase() === \"text\" );\n\t\t\t\t\t},\n\n\t\t\t\t\t// Position-in-collection\n\t\t\t\t\t\"first\": createPositionalPseudo(function() {\n\t\t\t\t\t\treturn [ 0 ];\n\t\t\t\t\t}),\n\n\t\t\t\t\t\"last\": createPositionalPseudo(function( matchIndexes, length ) {\n\t\t\t\t\t\treturn [ length - 1 ];\n\t\t\t\t\t}),\n\n\t\t\t\t\t\"eq\": createPositionalPseudo(function( matchIndexes, length, argument ) {\n\t\t\t\t\t\treturn [ argument < 0 ? argument + length : argument ];\n\t\t\t\t\t}),\n\n\t\t\t\t\t\"even\": createPositionalPseudo(function( matchIndexes, length ) {\n\t\t\t\t\t\tvar i = 0;\n\t\t\t\t\t\tfor ( ; i < length; i += 2 ) {\n\t\t\t\t\t\t\tmatchIndexes.push( i );\n\t\t\t\t\t\t}\n\t\t\t\t\t\treturn matchIndexes;\n\t\t\t\t\t}),\n\n\t\t\t\t\t\"odd\": createPositionalPseudo(function( matchIndexes, length ) {\n\t\t\t\t\t\tvar i = 1;\n\t\t\t\t\t\tfor ( ; i < length; i += 2 ) {\n\t\t\t\t\t\t\tmatchIndexes.push( i );\n\t\t\t\t\t\t}\n\t\t\t\t\t\treturn matchIndexes;\n\t\t\t\t\t}),\n\n\t\t\t\t\t\"lt\": createPositionalPseudo(function( matchIndexes, length, argument ) {\n\t\t\t\t\t\tvar i = argument < 0 ? argument + length : argument;\n\t\t\t\t\t\tfor ( ; --i >= 0; ) {\n\t\t\t\t\t\t\tmatchIndexes.push( i );\n\t\t\t\t\t\t}\n\t\t\t\t\t\treturn matchIndexes;\n\t\t\t\t\t}),\n\n\t\t\t\t\t\"gt\": createPositionalPseudo(function( matchIndexes, length, argument ) {\n\t\t\t\t\t\tvar i = argument < 0 ? argument + length : argument;\n\t\t\t\t\t\tfor ( ; ++i < length; ) {\n\t\t\t\t\t\t\tmatchIndexes.push( i );\n\t\t\t\t\t\t}\n\t\t\t\t\t\treturn matchIndexes;\n\t\t\t\t\t})\n\t\t\t\t}\n\t\t\t};\n\n\t\t\tExpr.pseudos[\"nth\"] = Expr.pseudos[\"eq\"];\n\n// Add button/input type pseudos\n\t\t\tfor ( i in { radio: true, checkbox: true, file: true, password: true, image: true } ) {\n\t\t\t\tExpr.pseudos[ i ] = createInputPseudo( i );\n\t\t\t}\n\t\t\tfor ( i in { submit: true, reset: true } ) {\n\t\t\t\tExpr.pseudos[ i ] = createButtonPseudo( i );\n\t\t\t}\n\n// Easy API for creating new setFilters\n\t\t\tfunction setFilters() {}\n\t\t\tsetFilters.prototype = Expr.filters = Expr.pseudos;\n\t\t\tExpr.setFilters = new setFilters();\n\n\t\t\ttokenize = Sizzle.tokenize = function( selector, parseOnly ) {\n\t\t\t\tvar matched, match, tokens, type,\n\t\t\t\t\tsoFar, groups, preFilters,\n\t\t\t\t\tcached = tokenCache[ selector + \" \" ];\n\n\t\t\t\tif ( cached ) {\n\t\t\t\t\treturn parseOnly ? 0 : cached.slice( 0 );\n\t\t\t\t}\n\n\t\t\t\tsoFar = selector;\n\t\t\t\tgroups = [];\n\t\t\t\tpreFilters = Expr.preFilter;\n\n\t\t\t\twhile ( soFar ) {\n\n\t\t\t\t\t// Comma and first run\n\t\t\t\t\tif ( !matched || (match = rcomma.exec( soFar )) ) {\n\t\t\t\t\t\tif ( match ) {\n\t\t\t\t\t\t\t// Don't consume trailing commas as valid\n\t\t\t\t\t\t\tsoFar = soFar.slice( match[0].length ) || soFar;\n\t\t\t\t\t\t}\n\t\t\t\t\t\tgroups.push( (tokens = []) );\n\t\t\t\t\t}\n\n\t\t\t\t\tmatched = false;\n\n\t\t\t\t\t// Combinators\n\t\t\t\t\tif ( (match = rcombinators.exec( soFar )) ) {\n\t\t\t\t\t\tmatched = match.shift();\n\t\t\t\t\t\ttokens.push({\n\t\t\t\t\t\t\tvalue: matched,\n\t\t\t\t\t\t\t// Cast descendant combinators to space\n\t\t\t\t\t\t\ttype: match[0].replace( rtrim, \" \" )\n\t\t\t\t\t\t});\n\t\t\t\t\t\tsoFar = soFar.slice( matched.length );\n\t\t\t\t\t}\n\n\t\t\t\t\t// Filters\n\t\t\t\t\tfor ( type in Expr.filter ) {\n\t\t\t\t\t\tif ( (match = matchExpr[ type ].exec( soFar )) && (!preFilters[ type ] ||\n\t\t\t\t\t\t\t(match = preFilters[ type ]( match ))) ) {\n\t\t\t\t\t\t\tmatched = match.shift();\n\t\t\t\t\t\t\ttokens.push({\n\t\t\t\t\t\t\t\tvalue: matched,\n\t\t\t\t\t\t\t\ttype: type,\n\t\t\t\t\t\t\t\tmatches: match\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\tsoFar = soFar.slice( matched.length );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\tif ( !matched ) {\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Return the length of the invalid excess\n\t\t\t\t// if we're just parsing\n\t\t\t\t// Otherwise, throw an error or return tokens\n\t\t\t\treturn parseOnly ?\n\t\t\t\t\tsoFar.length :\n\t\t\t\t\tsoFar ?\n\t\t\t\t\t\tSizzle.error( selector ) :\n\t\t\t\t\t\t// Cache the tokens\n\t\t\t\t\t\ttokenCache( selector, groups ).slice( 0 );\n\t\t\t};\n\n\t\t\tfunction toSelector( tokens ) {\n\t\t\t\tvar i = 0,\n\t\t\t\t\tlen = tokens.length,\n\t\t\t\t\tselector = \"\";\n\t\t\t\tfor ( ; i < len; i++ ) {\n\t\t\t\t\tselector += tokens[i].value;\n\t\t\t\t}\n\t\t\t\treturn selector;\n\t\t\t}\n\n\t\t\tfunction addCombinator( matcher, combinator, base ) {\n\t\t\t\tvar dir = combinator.dir,\n\t\t\t\t\tcheckNonElements = base && dir === \"parentNode\",\n\t\t\t\t\tdoneName = done++;\n\n\t\t\t\treturn combinator.first ?\n\t\t\t\t\t// Check against closest ancestor/preceding element\n\t\t\t\t\tfunction( elem, context, xml ) {\n\t\t\t\t\t\twhile ( (elem = elem[ dir ]) ) {\n\t\t\t\t\t\t\tif ( elem.nodeType === 1 || checkNonElements ) {\n\t\t\t\t\t\t\t\treturn matcher( elem, context, xml );\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t} :\n\n\t\t\t\t\t// Check against all ancestor/preceding elements\n\t\t\t\t\tfunction( elem, context, xml ) {\n\t\t\t\t\t\tvar oldCache, uniqueCache, outerCache,\n\t\t\t\t\t\t\tnewCache = [ dirruns, doneName ];\n\n\t\t\t\t\t\t// We can't set arbitrary data on XML nodes, so they don't benefit from combinator caching\n\t\t\t\t\t\tif ( xml ) {\n\t\t\t\t\t\t\twhile ( (elem = elem[ dir ]) ) {\n\t\t\t\t\t\t\t\tif ( elem.nodeType === 1 || checkNonElements ) {\n\t\t\t\t\t\t\t\t\tif ( matcher( elem, context, xml ) ) {\n\t\t\t\t\t\t\t\t\t\treturn true;\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\twhile ( (elem = elem[ dir ]) ) {\n\t\t\t\t\t\t\t\tif ( elem.nodeType === 1 || checkNonElements ) {\n\t\t\t\t\t\t\t\t\touterCache = elem[ expando ] || (elem[ expando ] = {});\n\n\t\t\t\t\t\t\t\t\t// Support: IE <9 only\n\t\t\t\t\t\t\t\t\t// Defend against cloned attroperties (jQuery gh-1709)\n\t\t\t\t\t\t\t\t\tuniqueCache = outerCache[ elem.uniqueID ] || (outerCache[ elem.uniqueID ] = {});\n\n\t\t\t\t\t\t\t\t\tif ( (oldCache = uniqueCache[ dir ]) &&\n\t\t\t\t\t\t\t\t\t\toldCache[ 0 ] === dirruns && oldCache[ 1 ] === doneName ) {\n\n\t\t\t\t\t\t\t\t\t\t// Assign to newCache so results back-propagate to previous elements\n\t\t\t\t\t\t\t\t\t\treturn (newCache[ 2 ] = oldCache[ 2 ]);\n\t\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\t\t// Reuse newcache so results back-propagate to previous elements\n\t\t\t\t\t\t\t\t\t\tuniqueCache[ dir ] = newCache;\n\n\t\t\t\t\t\t\t\t\t\t// A match means we're done; a fail means we have to keep checking\n\t\t\t\t\t\t\t\t\t\tif ( (newCache[ 2 ] = matcher( elem, context, xml )) ) {\n\t\t\t\t\t\t\t\t\t\t\treturn true;\n\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t};\n\t\t\t}\n\n\t\t\tfunction elementMatcher( matchers ) {\n\t\t\t\treturn matchers.length > 1 ?\n\t\t\t\t\tfunction( elem, context, xml ) {\n\t\t\t\t\t\tvar i = matchers.length;\n\t\t\t\t\t\twhile ( i-- ) {\n\t\t\t\t\t\t\tif ( !matchers[i]( elem, context, xml ) ) {\n\t\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\treturn true;\n\t\t\t\t\t} :\n\t\t\t\t\tmatchers[0];\n\t\t\t}\n\n\t\t\tfunction multipleContexts( selector, contexts, results ) {\n\t\t\t\tvar i = 0,\n\t\t\t\t\tlen = contexts.length;\n\t\t\t\tfor ( ; i < len; i++ ) {\n\t\t\t\t\tSizzle( selector, contexts[i], results );\n\t\t\t\t}\n\t\t\t\treturn results;\n\t\t\t}\n\n\t\t\tfunction condense( unmatched, map, filter, context, xml ) {\n\t\t\t\tvar elem,\n\t\t\t\t\tnewUnmatched = [],\n\t\t\t\t\ti = 0,\n\t\t\t\t\tlen = unmatched.length,\n\t\t\t\t\tmapped = map != null;\n\n\t\t\t\tfor ( ; i < len; i++ ) {\n\t\t\t\t\tif ( (elem = unmatched[i]) ) {\n\t\t\t\t\t\tif ( !filter || filter( elem, context, xml ) ) {\n\t\t\t\t\t\t\tnewUnmatched.push( elem );\n\t\t\t\t\t\t\tif ( mapped ) {\n\t\t\t\t\t\t\t\tmap.push( i );\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\treturn newUnmatched;\n\t\t\t}\n\n\t\t\tfunction setMatcher( preFilter, selector, matcher, postFilter, postFinder, postSelector ) {\n\t\t\t\tif ( postFilter && !postFilter[ expando ] ) {\n\t\t\t\t\tpostFilter = setMatcher( postFilter );\n\t\t\t\t}\n\t\t\t\tif ( postFinder && !postFinder[ expando ] ) {\n\t\t\t\t\tpostFinder = setMatcher( postFinder, postSelector );\n\t\t\t\t}\n\t\t\t\treturn markFunction(function( seed, results, context, xml ) {\n\t\t\t\t\tvar temp, i, elem,\n\t\t\t\t\t\tpreMap = [],\n\t\t\t\t\t\tpostMap = [],\n\t\t\t\t\t\tpreexisting = results.length,\n\n\t\t\t\t\t\t// Get initial elements from seed or context\n\t\t\t\t\t\telems = seed || multipleContexts( selector || \"*\", context.nodeType ? [ context ] : context, [] ),\n\n\t\t\t\t\t\t// Prefilter to get matcher input, preserving a map for seed-results synchronization\n\t\t\t\t\t\tmatcherIn = preFilter && ( seed || !selector ) ?\n\t\t\t\t\t\t\tcondense( elems, preMap, preFilter, context, xml ) :\n\t\t\t\t\t\t\telems,\n\n\t\t\t\t\t\tmatcherOut = matcher ?\n\t\t\t\t\t\t\t// If we have a postFinder, or filtered seed, or non-seed postFilter or preexisting results,\n\t\t\t\t\t\t\tpostFinder || ( seed ? preFilter : preexisting || postFilter ) ?\n\n\t\t\t\t\t\t\t\t// ...intermediate processing is necessary\n\t\t\t\t\t\t\t\t[] :\n\n\t\t\t\t\t\t\t\t// ...otherwise use results directly\n\t\t\t\t\t\t\t\tresults :\n\t\t\t\t\t\t\tmatcherIn;\n\n\t\t\t\t\t// Find primary matches\n\t\t\t\t\tif ( matcher ) {\n\t\t\t\t\t\tmatcher( matcherIn, matcherOut, context, xml );\n\t\t\t\t\t}\n\n\t\t\t\t\t// Apply postFilter\n\t\t\t\t\tif ( postFilter ) {\n\t\t\t\t\t\ttemp = condense( matcherOut, postMap );\n\t\t\t\t\t\tpostFilter( temp, [], context, xml );\n\n\t\t\t\t\t\t// Un-match failing elements by moving them back to matcherIn\n\t\t\t\t\t\ti = temp.length;\n\t\t\t\t\t\twhile ( i-- ) {\n\t\t\t\t\t\t\tif ( (elem = temp[i]) ) {\n\t\t\t\t\t\t\t\tmatcherOut[ postMap[i] ] = !(matcherIn[ postMap[i] ] = elem);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\tif ( seed ) {\n\t\t\t\t\t\tif ( postFinder || preFilter ) {\n\t\t\t\t\t\t\tif ( postFinder ) {\n\t\t\t\t\t\t\t\t// Get the final matcherOut by condensing this intermediate into postFinder contexts\n\t\t\t\t\t\t\t\ttemp = [];\n\t\t\t\t\t\t\t\ti = matcherOut.length;\n\t\t\t\t\t\t\t\twhile ( i-- ) {\n\t\t\t\t\t\t\t\t\tif ( (elem = matcherOut[i]) ) {\n\t\t\t\t\t\t\t\t\t\t// Restore matcherIn since elem is not yet a final match\n\t\t\t\t\t\t\t\t\t\ttemp.push( (matcherIn[i] = elem) );\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\tpostFinder( null, (matcherOut = []), temp, xml );\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// Move matched elements from seed to results to keep them synchronized\n\t\t\t\t\t\t\ti = matcherOut.length;\n\t\t\t\t\t\t\twhile ( i-- ) {\n\t\t\t\t\t\t\t\tif ( (elem = matcherOut[i]) &&\n\t\t\t\t\t\t\t\t\t(temp = postFinder ? indexOf( seed, elem ) : preMap[i]) > -1 ) {\n\n\t\t\t\t\t\t\t\t\tseed[temp] = !(results[temp] = elem);\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Add elements to results, through postFinder if defined\n\t\t\t\t\t} else {\n\t\t\t\t\t\tmatcherOut = condense(\n\t\t\t\t\t\t\tmatcherOut === results ?\n\t\t\t\t\t\t\t\tmatcherOut.splice( preexisting, matcherOut.length ) :\n\t\t\t\t\t\t\t\tmatcherOut\n\t\t\t\t\t\t);\n\t\t\t\t\t\tif ( postFinder ) {\n\t\t\t\t\t\t\tpostFinder( null, results, matcherOut, xml );\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tpush.apply( results, matcherOut );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tfunction matcherFromTokens( tokens ) {\n\t\t\t\tvar checkContext, matcher, j,\n\t\t\t\t\tlen = tokens.length,\n\t\t\t\t\tleadingRelative = Expr.relative[ tokens[0].type ],\n\t\t\t\t\timplicitRelative = leadingRelative || Expr.relative[\" \"],\n\t\t\t\t\ti = leadingRelative ? 1 : 0,\n\n\t\t\t\t\t// The foundational matcher ensures that elements are reachable from top-level context(s)\n\t\t\t\t\tmatchContext = addCombinator( function( elem ) {\n\t\t\t\t\t\treturn elem === checkContext;\n\t\t\t\t\t}, implicitRelative, true ),\n\t\t\t\t\tmatchAnyContext = addCombinator( function( elem ) {\n\t\t\t\t\t\treturn indexOf( checkContext, elem ) > -1;\n\t\t\t\t\t}, implicitRelative, true ),\n\t\t\t\t\tmatchers = [ function( elem, context, xml ) {\n\t\t\t\t\t\tvar ret = ( !leadingRelative && ( xml || context !== outermostContext ) ) || (\n\t\t\t\t\t\t\t\t(checkContext = context).nodeType ?\n\t\t\t\t\t\t\t\t\tmatchContext( elem, context, xml ) :\n\t\t\t\t\t\t\t\t\tmatchAnyContext( elem, context, xml ) );\n\t\t\t\t\t\t// Avoid hanging onto element (issue #299)\n\t\t\t\t\t\tcheckContext = null;\n\t\t\t\t\t\treturn ret;\n\t\t\t\t\t} ];\n\n\t\t\t\tfor ( ; i < len; i++ ) {\n\t\t\t\t\tif ( (matcher = Expr.relative[ tokens[i].type ]) ) {\n\t\t\t\t\t\tmatchers = [ addCombinator(elementMatcher( matchers ), matcher) ];\n\t\t\t\t\t} else {\n\t\t\t\t\t\tmatcher = Expr.filter[ tokens[i].type ].apply( null, tokens[i].matches );\n\n\t\t\t\t\t\t// Return special upon seeing a positional matcher\n\t\t\t\t\t\tif ( matcher[ expando ] ) {\n\t\t\t\t\t\t\t// Find the next relative operator (if any) for proper handling\n\t\t\t\t\t\t\tj = ++i;\n\t\t\t\t\t\t\tfor ( ; j < len; j++ ) {\n\t\t\t\t\t\t\t\tif ( Expr.relative[ tokens[j].type ] ) {\n\t\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\treturn setMatcher(\n\t\t\t\t\t\t\t\ti > 1 && elementMatcher( matchers ),\n\t\t\t\t\t\t\t\ti > 1 && toSelector(\n\t\t\t\t\t\t\t\t\t// If the preceding token was a descendant combinator, insert an implicit any-element `*`\n\t\t\t\t\t\t\t\t\ttokens.slice( 0, i - 1 ).concat({ value: tokens[ i - 2 ].type === \" \" ? \"*\" : \"\" })\n\t\t\t\t\t\t\t\t).replace( rtrim, \"$1\" ),\n\t\t\t\t\t\t\t\tmatcher,\n\t\t\t\t\t\t\t\ti < j && matcherFromTokens( tokens.slice( i, j ) ),\n\t\t\t\t\t\t\t\tj < len && matcherFromTokens( (tokens = tokens.slice( j )) ),\n\t\t\t\t\t\t\t\tj < len && toSelector( tokens )\n\t\t\t\t\t\t\t);\n\t\t\t\t\t\t}\n\t\t\t\t\t\tmatchers.push( matcher );\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\treturn elementMatcher( matchers );\n\t\t\t}\n\n\t\t\tfunction matcherFromGroupMatchers( elementMatchers, setMatchers ) {\n\t\t\t\tvar bySet = setMatchers.length > 0,\n\t\t\t\t\tbyElement = elementMatchers.length > 0,\n\t\t\t\t\tsuperMatcher = function( seed, context, xml, results, outermost ) {\n\t\t\t\t\t\tvar elem, j, matcher,\n\t\t\t\t\t\t\tmatchedCount = 0,\n\t\t\t\t\t\t\ti = \"0\",\n\t\t\t\t\t\t\tunmatched = seed && [],\n\t\t\t\t\t\t\tsetMatched = [],\n\t\t\t\t\t\t\tcontextBackup = outermostContext,\n\t\t\t\t\t\t\t// We must always have either seed elements or outermost context\n\t\t\t\t\t\t\telems = seed || byElement && Expr.find[\"TAG\"]( \"*\", outermost ),\n\t\t\t\t\t\t\t// Use integer dirruns iff this is the outermost matcher\n\t\t\t\t\t\t\tdirrunsUnique = (dirruns += contextBackup == null ? 1 : Math.random() || 0.1),\n\t\t\t\t\t\t\tlen = elems.length;\n\n\t\t\t\t\t\tif ( outermost ) {\n\t\t\t\t\t\t\toutermostContext = context === document || context || outermost;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Add elements passing elementMatchers directly to results\n\t\t\t\t\t\t// Support: IE<9, Safari\n\t\t\t\t\t\t// Tolerate NodeList properties (IE: \"length\"; Safari: <number>) matching elements by id\n\t\t\t\t\t\tfor ( ; i !== len && (elem = elems[i]) != null; i++ ) {\n\t\t\t\t\t\t\tif ( byElement && elem ) {\n\t\t\t\t\t\t\t\tj = 0;\n\t\t\t\t\t\t\t\tif ( !context && elem.ownerDocument !== document ) {\n\t\t\t\t\t\t\t\t\tsetDocument( elem );\n\t\t\t\t\t\t\t\t\txml = !documentIsHTML;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\twhile ( (matcher = elementMatchers[j++]) ) {\n\t\t\t\t\t\t\t\t\tif ( matcher( elem, context || document, xml) ) {\n\t\t\t\t\t\t\t\t\t\tresults.push( elem );\n\t\t\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\tif ( outermost ) {\n\t\t\t\t\t\t\t\t\tdirruns = dirrunsUnique;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// Track unmatched elements for set filters\n\t\t\t\t\t\t\tif ( bySet ) {\n\t\t\t\t\t\t\t\t// They will have gone through all possible matchers\n\t\t\t\t\t\t\t\tif ( (elem = !matcher && elem) ) {\n\t\t\t\t\t\t\t\t\tmatchedCount--;\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t// Lengthen the array for every element, matched or not\n\t\t\t\t\t\t\t\tif ( seed ) {\n\t\t\t\t\t\t\t\t\tunmatched.push( elem );\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// `i` is now the count of elements visited above, and adding it to `matchedCount`\n\t\t\t\t\t\t// makes the latter nonnegative.\n\t\t\t\t\t\tmatchedCount += i;\n\n\t\t\t\t\t\t// Apply set filters to unmatched elements\n\t\t\t\t\t\t// NOTE: This can be skipped if there are no unmatched elements (i.e., `matchedCount`\n\t\t\t\t\t\t// equals `i`), unless we didn't visit _any_ elements in the above loop because we have\n\t\t\t\t\t\t// no element matchers and no seed.\n\t\t\t\t\t\t// Incrementing an initially-string \"0\" `i` allows `i` to remain a string only in that\n\t\t\t\t\t\t// case, which will result in a \"00\" `matchedCount` that differs from `i` but is also\n\t\t\t\t\t\t// numerically zero.\n\t\t\t\t\t\tif ( bySet && i !== matchedCount ) {\n\t\t\t\t\t\t\tj = 0;\n\t\t\t\t\t\t\twhile ( (matcher = setMatchers[j++]) ) {\n\t\t\t\t\t\t\t\tmatcher( unmatched, setMatched, context, xml );\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tif ( seed ) {\n\t\t\t\t\t\t\t\t// Reintegrate element matches to eliminate the need for sorting\n\t\t\t\t\t\t\t\tif ( matchedCount > 0 ) {\n\t\t\t\t\t\t\t\t\twhile ( i-- ) {\n\t\t\t\t\t\t\t\t\t\tif ( !(unmatched[i] || setMatched[i]) ) {\n\t\t\t\t\t\t\t\t\t\t\tsetMatched[i] = pop.call( results );\n\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t// Discard index placeholder values to get only actual matches\n\t\t\t\t\t\t\t\tsetMatched = condense( setMatched );\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// Add matches to results\n\t\t\t\t\t\t\tpush.apply( results, setMatched );\n\n\t\t\t\t\t\t\t// Seedless set matches succeeding multiple successful matchers stipulate sorting\n\t\t\t\t\t\t\tif ( outermost && !seed && setMatched.length > 0 &&\n\t\t\t\t\t\t\t\t( matchedCount + setMatchers.length ) > 1 ) {\n\n\t\t\t\t\t\t\t\tSizzle.uniqueSort( results );\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Override manipulation of globals by nested matchers\n\t\t\t\t\t\tif ( outermost ) {\n\t\t\t\t\t\t\tdirruns = dirrunsUnique;\n\t\t\t\t\t\t\toutermostContext = contextBackup;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn unmatched;\n\t\t\t\t\t};\n\n\t\t\t\treturn bySet ?\n\t\t\t\t\tmarkFunction( superMatcher ) :\n\t\t\t\t\tsuperMatcher;\n\t\t\t}\n\n\t\t\tcompile = Sizzle.compile = function( selector, match /* Internal Use Only */ ) {\n\t\t\t\tvar i,\n\t\t\t\t\tsetMatchers = [],\n\t\t\t\t\telementMatchers = [],\n\t\t\t\t\tcached = compilerCache[ selector + \" \" ];\n\n\t\t\t\tif ( !cached ) {\n\t\t\t\t\t// Generate a function of recursive functions that can be used to check each element\n\t\t\t\t\tif ( !match ) {\n\t\t\t\t\t\tmatch = tokenize( selector );\n\t\t\t\t\t}\n\t\t\t\t\ti = match.length;\n\t\t\t\t\twhile ( i-- ) {\n\t\t\t\t\t\tcached = matcherFromTokens( match[i] );\n\t\t\t\t\t\tif ( cached[ expando ] ) {\n\t\t\t\t\t\t\tsetMatchers.push( cached );\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\telementMatchers.push( cached );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// Cache the compiled function\n\t\t\t\t\tcached = compilerCache( selector, matcherFromGroupMatchers( elementMatchers, setMatchers ) );\n\n\t\t\t\t\t// Save selector and tokenization\n\t\t\t\t\tcached.selector = selector;\n\t\t\t\t}\n\t\t\t\treturn cached;\n\t\t\t};\n\n\t\t\t/**\n\t\t\t * A low-level selection function that works with Sizzle's compiled\n\t\t\t *  selector functions\n\t\t\t * @param {String|Function} selector A selector or a pre-compiled\n\t\t\t *  selector function built with Sizzle.compile\n\t\t\t * @param {Element} context\n\t\t\t * @param {Array} [results]\n\t\t\t * @param {Array} [seed] A set of elements to match against\n\t\t\t */\n\t\t\tselect = Sizzle.select = function( selector, context, results, seed ) {\n\t\t\t\tvar i, tokens, token, type, find,\n\t\t\t\t\tcompiled = typeof selector === \"function\" && selector,\n\t\t\t\t\tmatch = !seed && tokenize( (selector = compiled.selector || selector) );\n\n\t\t\t\tresults = results || [];\n\n\t\t\t\t// Try to minimize operations if there is only one selector in the list and no seed\n\t\t\t\t// (the latter of which guarantees us context)\n\t\t\t\tif ( match.length === 1 ) {\n\n\t\t\t\t\t// Reduce context if the leading compound selector is an ID\n\t\t\t\t\ttokens = match[0] = match[0].slice( 0 );\n\t\t\t\t\tif ( tokens.length > 2 && (token = tokens[0]).type === \"ID\" &&\n\t\t\t\t\t\tsupport.getById && context.nodeType === 9 && documentIsHTML &&\n\t\t\t\t\t\tExpr.relative[ tokens[1].type ] ) {\n\n\t\t\t\t\t\tcontext = ( Expr.find[\"ID\"]( token.matches[0].replace(runescape, funescape), context ) || [] )[0];\n\t\t\t\t\t\tif ( !context ) {\n\t\t\t\t\t\t\treturn results;\n\n\t\t\t\t\t\t\t// Precompiled matchers will still verify ancestry, so step up a level\n\t\t\t\t\t\t} else if ( compiled ) {\n\t\t\t\t\t\t\tcontext = context.parentNode;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tselector = selector.slice( tokens.shift().value.length );\n\t\t\t\t\t}\n\n\t\t\t\t\t// Fetch a seed set for right-to-left matching\n\t\t\t\t\ti = matchExpr[\"needsContext\"].test( selector ) ? 0 : tokens.length;\n\t\t\t\t\twhile ( i-- ) {\n\t\t\t\t\t\ttoken = tokens[i];\n\n\t\t\t\t\t\t// Abort if we hit a combinator\n\t\t\t\t\t\tif ( Expr.relative[ (type = token.type) ] ) {\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif ( (find = Expr.find[ type ]) ) {\n\t\t\t\t\t\t\t// Search, expanding context for leading sibling combinators\n\t\t\t\t\t\t\tif ( (seed = find(\n\t\t\t\t\t\t\t\t\ttoken.matches[0].replace( runescape, funescape ),\n\t\t\t\t\t\t\t\t\trsibling.test( tokens[0].type ) && testContext( context.parentNode ) || context\n\t\t\t\t\t\t\t\t)) ) {\n\n\t\t\t\t\t\t\t\t// If seed is empty or no tokens remain, we can return early\n\t\t\t\t\t\t\t\ttokens.splice( i, 1 );\n\t\t\t\t\t\t\t\tselector = seed.length && toSelector( tokens );\n\t\t\t\t\t\t\t\tif ( !selector ) {\n\t\t\t\t\t\t\t\t\tpush.apply( results, seed );\n\t\t\t\t\t\t\t\t\treturn results;\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Compile and execute a filtering function if one is not provided\n\t\t\t\t// Provide `match` to avoid retokenization if we modified the selector above\n\t\t\t\t( compiled || compile( selector, match ) )(\n\t\t\t\t\tseed,\n\t\t\t\t\tcontext,\n\t\t\t\t\t!documentIsHTML,\n\t\t\t\t\tresults,\n\t\t\t\t\t!context || rsibling.test( selector ) && testContext( context.parentNode ) || context\n\t\t\t\t);\n\t\t\t\treturn results;\n\t\t\t};\n\n// One-time assignments\n\n// Sort stability\n\t\t\tsupport.sortStable = expando.split(\"\").sort( sortOrder ).join(\"\") === expando;\n\n// Support: Chrome 14-35+\n// Always assume duplicates if they aren't passed to the comparison function\n\t\t\tsupport.detectDuplicates = !!hasDuplicate;\n\n// Initialize against the default document\n\t\t\tsetDocument();\n\n// Support: Webkit<537.32 - Safari 6.0.3/Chrome 25 (fixed in Chrome 27)\n// Detached nodes confoundingly follow *each other*\n\t\t\tsupport.sortDetached = assert(function( div1 ) {\n\t\t\t\t// Should return 1, but returns 4 (following)\n\t\t\t\treturn div1.compareDocumentPosition( document.createElement(\"div\") ) & 1;\n\t\t\t});\n\n// Support: IE<8\n// Prevent attribute/property \"interpolation\"\n// http://msdn.microsoft.com/en-us/library/ms536429%28VS.85%29.aspx\n\t\t\tif ( !assert(function( div ) {\n\t\t\t\t\tdiv.innerHTML = \"<a href='#'></a>\";\n\t\t\t\t\treturn div.firstChild.getAttribute(\"href\") === \"#\" ;\n\t\t\t\t}) ) {\n\t\t\t\taddHandle( \"type|href|height|width\", function( elem, name, isXML ) {\n\t\t\t\t\tif ( !isXML ) {\n\t\t\t\t\t\treturn elem.getAttribute( name, name.toLowerCase() === \"type\" ? 1 : 2 );\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n// Support: IE<9\n// Use defaultValue in place of getAttribute(\"value\")\n\t\t\tif ( !support.attributes || !assert(function( div ) {\n\t\t\t\t\tdiv.innerHTML = \"<input/>\";\n\t\t\t\t\tdiv.firstChild.setAttribute( \"value\", \"\" );\n\t\t\t\t\treturn div.firstChild.getAttribute( \"value\" ) === \"\";\n\t\t\t\t}) ) {\n\t\t\t\taddHandle( \"value\", function( elem, name, isXML ) {\n\t\t\t\t\tif ( !isXML && elem.nodeName.toLowerCase() === \"input\" ) {\n\t\t\t\t\t\treturn elem.defaultValue;\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n// Support: IE<9\n// Use getAttributeNode to fetch booleans when getAttribute lies\n\t\t\tif ( !assert(function( div ) {\n\t\t\t\t\treturn div.getAttribute(\"disabled\") == null;\n\t\t\t\t}) ) {\n\t\t\t\taddHandle( booleans, function( elem, name, isXML ) {\n\t\t\t\t\tvar val;\n\t\t\t\t\tif ( !isXML ) {\n\t\t\t\t\t\treturn elem[ name ] === true ? name.toLowerCase() :\n\t\t\t\t\t\t\t(val = elem.getAttributeNode( name )) && val.specified ?\n\t\t\t\t\t\t\t\tval.value :\n\t\t\t\t\t\t\t\tnull;\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n\t\t\treturn Sizzle;\n\n\t\t})( window );\n\n\n\n\tjQuery.find = Sizzle;\n\tjQuery.expr = Sizzle.selectors;\n\tjQuery.expr[ \":\" ] = jQuery.expr.pseudos;\n\tjQuery.uniqueSort = jQuery.unique = Sizzle.uniqueSort;\n\tjQuery.text = Sizzle.getText;\n\tjQuery.isXMLDoc = Sizzle.isXML;\n\tjQuery.contains = Sizzle.contains;\n\n\n\n\tvar dir = function( elem, dir, until ) {\n\t\tvar matched = [],\n\t\t\ttruncate = until !== undefined;\n\n\t\twhile ( ( elem = elem[ dir ] ) && elem.nodeType !== 9 ) {\n\t\t\tif ( elem.nodeType === 1 ) {\n\t\t\t\tif ( truncate && jQuery( elem ).is( until ) ) {\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t\tmatched.push( elem );\n\t\t\t}\n\t\t}\n\t\treturn matched;\n\t};\n\n\n\tvar siblings = function( n, elem ) {\n\t\tvar matched = [];\n\n\t\tfor ( ; n; n = n.nextSibling ) {\n\t\t\tif ( n.nodeType === 1 && n !== elem ) {\n\t\t\t\tmatched.push( n );\n\t\t\t}\n\t\t}\n\n\t\treturn matched;\n\t};\n\n\n\tvar rneedsContext = jQuery.expr.match.needsContext;\n\n\tvar rsingleTag = ( /^<([\\w-]+)\\s*\\/?>(?:<\\/\\1>|)$/ );\n\n\n\n\tvar risSimple = /^.[^:#\\[\\.,]*$/;\n\n// Implement the identical functionality for filter and not\n\tfunction winnow( elements, qualifier, not ) {\n\t\tif ( jQuery.isFunction( qualifier ) ) {\n\t\t\treturn jQuery.grep( elements, function( elem, i ) {\n\t\t\t\t/* jshint -W018 */\n\t\t\t\treturn !!qualifier.call( elem, i, elem ) !== not;\n\t\t\t} );\n\n\t\t}\n\n\t\tif ( qualifier.nodeType ) {\n\t\t\treturn jQuery.grep( elements, function( elem ) {\n\t\t\t\treturn ( elem === qualifier ) !== not;\n\t\t\t} );\n\n\t\t}\n\n\t\tif ( typeof qualifier === \"string\" ) {\n\t\t\tif ( risSimple.test( qualifier ) ) {\n\t\t\t\treturn jQuery.filter( qualifier, elements, not );\n\t\t\t}\n\n\t\t\tqualifier = jQuery.filter( qualifier, elements );\n\t\t}\n\n\t\treturn jQuery.grep( elements, function( elem ) {\n\t\t\treturn ( jQuery.inArray( elem, qualifier ) > -1 ) !== not;\n\t\t} );\n\t}\n\n\tjQuery.filter = function( expr, elems, not ) {\n\t\tvar elem = elems[ 0 ];\n\n\t\tif ( not ) {\n\t\t\texpr = \":not(\" + expr + \")\";\n\t\t}\n\n\t\treturn elems.length === 1 && elem.nodeType === 1 ?\n\t\t\tjQuery.find.matchesSelector( elem, expr ) ? [ elem ] : [] :\n\t\t\tjQuery.find.matches( expr, jQuery.grep( elems, function( elem ) {\n\t\t\t\treturn elem.nodeType === 1;\n\t\t\t} ) );\n\t};\n\n\tjQuery.fn.extend( {\n\t\tfind: function( selector ) {\n\t\t\tvar i,\n\t\t\t\tret = [],\n\t\t\t\tself = this,\n\t\t\t\tlen = self.length;\n\n\t\t\tif ( typeof selector !== \"string\" ) {\n\t\t\t\treturn this.pushStack( jQuery( selector ).filter( function() {\n\t\t\t\t\tfor ( i = 0; i < len; i++ ) {\n\t\t\t\t\t\tif ( jQuery.contains( self[ i ], this ) ) {\n\t\t\t\t\t\t\treturn true;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t} ) );\n\t\t\t}\n\n\t\t\tfor ( i = 0; i < len; i++ ) {\n\t\t\t\tjQuery.find( selector, self[ i ], ret );\n\t\t\t}\n\n\t\t\t// Needed because $( selector, context ) becomes $( context ).find( selector )\n\t\t\tret = this.pushStack( len > 1 ? jQuery.unique( ret ) : ret );\n\t\t\tret.selector = this.selector ? this.selector + \" \" + selector : selector;\n\t\t\treturn ret;\n\t\t},\n\t\tfilter: function( selector ) {\n\t\t\treturn this.pushStack( winnow( this, selector || [], false ) );\n\t\t},\n\t\tnot: function( selector ) {\n\t\t\treturn this.pushStack( winnow( this, selector || [], true ) );\n\t\t},\n\t\tis: function( selector ) {\n\t\t\treturn !!winnow(\n\t\t\t\tthis,\n\n\t\t\t\t// If this is a positional/relative selector, check membership in the returned set\n\t\t\t\t// so $(\"p:first\").is(\"p:last\") won't return true for a doc with two \"p\".\n\t\t\t\ttypeof selector === \"string\" && rneedsContext.test( selector ) ?\n\t\t\t\t\tjQuery( selector ) :\n\t\t\t\tselector || [],\n\t\t\t\tfalse\n\t\t\t).length;\n\t\t}\n\t} );\n\n\n// Initialize a jQuery object\n\n\n// A central reference to the root jQuery(document)\n\tvar rootjQuery,\n\n\t\t// A simple way to check for HTML strings\n\t\t// Prioritize #id over <tag> to avoid XSS via location.hash (#9521)\n\t\t// Strict HTML recognition (#11290: must start with <)\n\t\trquickExpr = /^(?:\\s*(<[\\w\\W]+>)[^>]*|#([\\w-]*))$/,\n\n\t\tinit = jQuery.fn.init = function( selector, context, root ) {\n\t\t\tvar match, elem;\n\n\t\t\t// HANDLE: $(\"\"), $(null), $(undefined), $(false)\n\t\t\tif ( !selector ) {\n\t\t\t\treturn this;\n\t\t\t}\n\n\t\t\t// init accepts an alternate rootjQuery\n\t\t\t// so migrate can support jQuery.sub (gh-2101)\n\t\t\troot = root || rootjQuery;\n\n\t\t\t// Handle HTML strings\n\t\t\tif ( typeof selector === \"string\" ) {\n\t\t\t\tif ( selector.charAt( 0 ) === \"<\" &&\n\t\t\t\t\tselector.charAt( selector.length - 1 ) === \">\" &&\n\t\t\t\t\tselector.length >= 3 ) {\n\n\t\t\t\t\t// Assume that strings that start and end with <> are HTML and skip the regex check\n\t\t\t\t\tmatch = [ null, selector, null ];\n\n\t\t\t\t} else {\n\t\t\t\t\tmatch = rquickExpr.exec( selector );\n\t\t\t\t}\n\n\t\t\t\t// Match html or make sure no context is specified for #id\n\t\t\t\tif ( match && ( match[ 1 ] || !context ) ) {\n\n\t\t\t\t\t// HANDLE: $(html) -> $(array)\n\t\t\t\t\tif ( match[ 1 ] ) {\n\t\t\t\t\t\tcontext = context instanceof jQuery ? context[ 0 ] : context;\n\n\t\t\t\t\t\t// scripts is true for back-compat\n\t\t\t\t\t\t// Intentionally let the error be thrown if parseHTML is not present\n\t\t\t\t\t\tjQuery.merge( this, jQuery.parseHTML(\n\t\t\t\t\t\t\tmatch[ 1 ],\n\t\t\t\t\t\t\tcontext && context.nodeType ? context.ownerDocument || context : document,\n\t\t\t\t\t\t\ttrue\n\t\t\t\t\t\t) );\n\n\t\t\t\t\t\t// HANDLE: $(html, props)\n\t\t\t\t\t\tif ( rsingleTag.test( match[ 1 ] ) && jQuery.isPlainObject( context ) ) {\n\t\t\t\t\t\t\tfor ( match in context ) {\n\n\t\t\t\t\t\t\t\t// Properties of context are called as methods if possible\n\t\t\t\t\t\t\t\tif ( jQuery.isFunction( this[ match ] ) ) {\n\t\t\t\t\t\t\t\t\tthis[ match ]( context[ match ] );\n\n\t\t\t\t\t\t\t\t\t// ...and otherwise set as attributes\n\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\tthis.attr( match, context[ match ] );\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn this;\n\n\t\t\t\t\t\t// HANDLE: $(#id)\n\t\t\t\t\t} else {\n\t\t\t\t\t\telem = document.getElementById( match[ 2 ] );\n\n\t\t\t\t\t\t// Check parentNode to catch when Blackberry 4.6 returns\n\t\t\t\t\t\t// nodes that are no longer in the document #6963\n\t\t\t\t\t\tif ( elem && elem.parentNode ) {\n\n\t\t\t\t\t\t\t// Handle the case where IE and Opera return items\n\t\t\t\t\t\t\t// by name instead of ID\n\t\t\t\t\t\t\tif ( elem.id !== match[ 2 ] ) {\n\t\t\t\t\t\t\t\treturn rootjQuery.find( selector );\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// Otherwise, we inject the element directly into the jQuery object\n\t\t\t\t\t\t\tthis.length = 1;\n\t\t\t\t\t\t\tthis[ 0 ] = elem;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tthis.context = document;\n\t\t\t\t\t\tthis.selector = selector;\n\t\t\t\t\t\treturn this;\n\t\t\t\t\t}\n\n\t\t\t\t\t// HANDLE: $(expr, $(...))\n\t\t\t\t} else if ( !context || context.jquery ) {\n\t\t\t\t\treturn ( context || root ).find( selector );\n\n\t\t\t\t\t// HANDLE: $(expr, context)\n\t\t\t\t\t// (which is just equivalent to: $(context).find(expr)\n\t\t\t\t} else {\n\t\t\t\t\treturn this.constructor( context ).find( selector );\n\t\t\t\t}\n\n\t\t\t\t// HANDLE: $(DOMElement)\n\t\t\t} else if ( selector.nodeType ) {\n\t\t\t\tthis.context = this[ 0 ] = selector;\n\t\t\t\tthis.length = 1;\n\t\t\t\treturn this;\n\n\t\t\t\t// HANDLE: $(function)\n\t\t\t\t// Shortcut for document ready\n\t\t\t} else if ( jQuery.isFunction( selector ) ) {\n\t\t\t\treturn typeof root.ready !== \"undefined\" ?\n\t\t\t\t\troot.ready( selector ) :\n\n\t\t\t\t\t// Execute immediately if ready is not present\n\t\t\t\t\tselector( jQuery );\n\t\t\t}\n\n\t\t\tif ( selector.selector !== undefined ) {\n\t\t\t\tthis.selector = selector.selector;\n\t\t\t\tthis.context = selector.context;\n\t\t\t}\n\n\t\t\treturn jQuery.makeArray( selector, this );\n\t\t};\n\n// Give the init function the jQuery prototype for later instantiation\n\tinit.prototype = jQuery.fn;\n\n// Initialize central reference\n\trootjQuery = jQuery( document );\n\n\n\tvar rparentsprev = /^(?:parents|prev(?:Until|All))/,\n\n\t\t// methods guaranteed to produce a unique set when starting from a unique set\n\t\tguaranteedUnique = {\n\t\t\tchildren: true,\n\t\t\tcontents: true,\n\t\t\tnext: true,\n\t\t\tprev: true\n\t\t};\n\n\tjQuery.fn.extend( {\n\t\thas: function( target ) {\n\t\t\tvar i,\n\t\t\t\ttargets = jQuery( target, this ),\n\t\t\t\tlen = targets.length;\n\n\t\t\treturn this.filter( function() {\n\t\t\t\tfor ( i = 0; i < len; i++ ) {\n\t\t\t\t\tif ( jQuery.contains( this, targets[ i ] ) ) {\n\t\t\t\t\t\treturn true;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t} );\n\t\t},\n\n\t\tclosest: function( selectors, context ) {\n\t\t\tvar cur,\n\t\t\t\ti = 0,\n\t\t\t\tl = this.length,\n\t\t\t\tmatched = [],\n\t\t\t\tpos = rneedsContext.test( selectors ) || typeof selectors !== \"string\" ?\n\t\t\t\t\tjQuery( selectors, context || this.context ) :\n\t\t\t\t\t0;\n\n\t\t\tfor ( ; i < l; i++ ) {\n\t\t\t\tfor ( cur = this[ i ]; cur && cur !== context; cur = cur.parentNode ) {\n\n\t\t\t\t\t// Always skip document fragments\n\t\t\t\t\tif ( cur.nodeType < 11 && ( pos ?\n\t\t\t\t\t\tpos.index( cur ) > -1 :\n\n\t\t\t\t\t\t\t// Don't pass non-elements to Sizzle\n\t\t\t\t\t\tcur.nodeType === 1 &&\n\t\t\t\t\t\tjQuery.find.matchesSelector( cur, selectors ) ) ) {\n\n\t\t\t\t\t\tmatched.push( cur );\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn this.pushStack( matched.length > 1 ? jQuery.uniqueSort( matched ) : matched );\n\t\t},\n\n\t\t// Determine the position of an element within\n\t\t// the matched set of elements\n\t\tindex: function( elem ) {\n\n\t\t\t// No argument, return index in parent\n\t\t\tif ( !elem ) {\n\t\t\t\treturn ( this[ 0 ] && this[ 0 ].parentNode ) ? this.first().prevAll().length : -1;\n\t\t\t}\n\n\t\t\t// index in selector\n\t\t\tif ( typeof elem === \"string\" ) {\n\t\t\t\treturn jQuery.inArray( this[ 0 ], jQuery( elem ) );\n\t\t\t}\n\n\t\t\t// Locate the position of the desired element\n\t\t\treturn jQuery.inArray(\n\n\t\t\t\t// If it receives a jQuery object, the first element is used\n\t\t\t\telem.jquery ? elem[ 0 ] : elem, this );\n\t\t},\n\n\t\tadd: function( selector, context ) {\n\t\t\treturn this.pushStack(\n\t\t\t\tjQuery.uniqueSort(\n\t\t\t\t\tjQuery.merge( this.get(), jQuery( selector, context ) )\n\t\t\t\t)\n\t\t\t);\n\t\t},\n\n\t\taddBack: function( selector ) {\n\t\t\treturn this.add( selector == null ?\n\t\t\t\tthis.prevObject : this.prevObject.filter( selector )\n\t\t\t);\n\t\t}\n\t} );\n\n\tfunction sibling( cur, dir ) {\n\t\tdo {\n\t\t\tcur = cur[ dir ];\n\t\t} while ( cur && cur.nodeType !== 1 );\n\n\t\treturn cur;\n\t}\n\n\tjQuery.each( {\n\t\tparent: function( elem ) {\n\t\t\tvar parent = elem.parentNode;\n\t\t\treturn parent && parent.nodeType !== 11 ? parent : null;\n\t\t},\n\t\tparents: function( elem ) {\n\t\t\treturn dir( elem, \"parentNode\" );\n\t\t},\n\t\tparentsUntil: function( elem, i, until ) {\n\t\t\treturn dir( elem, \"parentNode\", until );\n\t\t},\n\t\tnext: function( elem ) {\n\t\t\treturn sibling( elem, \"nextSibling\" );\n\t\t},\n\t\tprev: function( elem ) {\n\t\t\treturn sibling( elem, \"previousSibling\" );\n\t\t},\n\t\tnextAll: function( elem ) {\n\t\t\treturn dir( elem, \"nextSibling\" );\n\t\t},\n\t\tprevAll: function( elem ) {\n\t\t\treturn dir( elem, \"previousSibling\" );\n\t\t},\n\t\tnextUntil: function( elem, i, until ) {\n\t\t\treturn dir( elem, \"nextSibling\", until );\n\t\t},\n\t\tprevUntil: function( elem, i, until ) {\n\t\t\treturn dir( elem, \"previousSibling\", until );\n\t\t},\n\t\tsiblings: function( elem ) {\n\t\t\treturn siblings( ( elem.parentNode || {} ).firstChild, elem );\n\t\t},\n\t\tchildren: function( elem ) {\n\t\t\treturn siblings( elem.firstChild );\n\t\t},\n\t\tcontents: function( elem ) {\n\t\t\treturn jQuery.nodeName( elem, \"iframe\" ) ?\n\t\t\telem.contentDocument || elem.contentWindow.document :\n\t\t\t\tjQuery.merge( [], elem.childNodes );\n\t\t}\n\t}, function( name, fn ) {\n\t\tjQuery.fn[ name ] = function( until, selector ) {\n\t\t\tvar ret = jQuery.map( this, fn, until );\n\n\t\t\tif ( name.slice( -5 ) !== \"Until\" ) {\n\t\t\t\tselector = until;\n\t\t\t}\n\n\t\t\tif ( selector && typeof selector === \"string\" ) {\n\t\t\t\tret = jQuery.filter( selector, ret );\n\t\t\t}\n\n\t\t\tif ( this.length > 1 ) {\n\n\t\t\t\t// Remove duplicates\n\t\t\t\tif ( !guaranteedUnique[ name ] ) {\n\t\t\t\t\tret = jQuery.uniqueSort( ret );\n\t\t\t\t}\n\n\t\t\t\t// Reverse order for parents* and prev-derivatives\n\t\t\t\tif ( rparentsprev.test( name ) ) {\n\t\t\t\t\tret = ret.reverse();\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn this.pushStack( ret );\n\t\t};\n\t} );\n\tvar rnotwhite = ( /\\S+/g );\n\n\n\n// Convert String-formatted options into Object-formatted ones\n\tfunction createOptions( options ) {\n\t\tvar object = {};\n\t\tjQuery.each( options.match( rnotwhite ) || [], function( _, flag ) {\n\t\t\tobject[ flag ] = true;\n\t\t} );\n\t\treturn object;\n\t}\n\n\t/*\n\t * Create a callback list using the following parameters:\n\t *\n\t *\toptions: an optional list of space-separated options that will change how\n\t *\t\t\tthe callback list behaves or a more traditional option object\n\t *\n\t * By default a callback list will act like an event callback list and can be\n\t * \"fired\" multiple times.\n\t *\n\t * Possible options:\n\t *\n\t *\tonce:\t\t\twill ensure the callback list can only be fired once (like a Deferred)\n\t *\n\t *\tmemory:\t\t\twill keep track of previous values and will call any callback added\n\t *\t\t\t\t\tafter the list has been fired right away with the latest \"memorized\"\n\t *\t\t\t\t\tvalues (like a Deferred)\n\t *\n\t *\tunique:\t\t\twill ensure a callback can only be added once (no duplicate in the list)\n\t *\n\t *\tstopOnFalse:\tinterrupt callings when a callback returns false\n\t *\n\t */\n\tjQuery.Callbacks = function( options ) {\n\n\t\t// Convert options from String-formatted to Object-formatted if needed\n\t\t// (we check in cache first)\n\t\toptions = typeof options === \"string\" ?\n\t\t\tcreateOptions( options ) :\n\t\t\tjQuery.extend( {}, options );\n\n\t\tvar // Flag to know if list is currently firing\n\t\t\tfiring,\n\n\t\t\t// Last fire value for non-forgettable lists\n\t\t\tmemory,\n\n\t\t\t// Flag to know if list was already fired\n\t\t\tfired,\n\n\t\t\t// Flag to prevent firing\n\t\t\tlocked,\n\n\t\t\t// Actual callback list\n\t\t\tlist = [],\n\n\t\t\t// Queue of execution data for repeatable lists\n\t\t\tqueue = [],\n\n\t\t\t// Index of currently firing callback (modified by add/remove as needed)\n\t\t\tfiringIndex = -1,\n\n\t\t\t// Fire callbacks\n\t\t\tfire = function() {\n\n\t\t\t\t// Enforce single-firing\n\t\t\t\tlocked = options.once;\n\n\t\t\t\t// Execute callbacks for all pending executions,\n\t\t\t\t// respecting firingIndex overrides and runtime changes\n\t\t\t\tfired = firing = true;\n\t\t\t\tfor ( ; queue.length; firingIndex = -1 ) {\n\t\t\t\t\tmemory = queue.shift();\n\t\t\t\t\twhile ( ++firingIndex < list.length ) {\n\n\t\t\t\t\t\t// Run callback and check for early termination\n\t\t\t\t\t\tif ( list[ firingIndex ].apply( memory[ 0 ], memory[ 1 ] ) === false &&\n\t\t\t\t\t\t\toptions.stopOnFalse ) {\n\n\t\t\t\t\t\t\t// Jump to end and forget the data so .add doesn't re-fire\n\t\t\t\t\t\t\tfiringIndex = list.length;\n\t\t\t\t\t\t\tmemory = false;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Forget the data if we're done with it\n\t\t\t\tif ( !options.memory ) {\n\t\t\t\t\tmemory = false;\n\t\t\t\t}\n\n\t\t\t\tfiring = false;\n\n\t\t\t\t// Clean up if we're done firing for good\n\t\t\t\tif ( locked ) {\n\n\t\t\t\t\t// Keep an empty list if we have data for future add calls\n\t\t\t\t\tif ( memory ) {\n\t\t\t\t\t\tlist = [];\n\n\t\t\t\t\t\t// Otherwise, this object is spent\n\t\t\t\t\t} else {\n\t\t\t\t\t\tlist = \"\";\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t},\n\n\t\t\t// Actual Callbacks object\n\t\t\tself = {\n\n\t\t\t\t// Add a callback or a collection of callbacks to the list\n\t\t\t\tadd: function() {\n\t\t\t\t\tif ( list ) {\n\n\t\t\t\t\t\t// If we have memory from a past run, we should fire after adding\n\t\t\t\t\t\tif ( memory && !firing ) {\n\t\t\t\t\t\t\tfiringIndex = list.length - 1;\n\t\t\t\t\t\t\tqueue.push( memory );\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t( function add( args ) {\n\t\t\t\t\t\t\tjQuery.each( args, function( _, arg ) {\n\t\t\t\t\t\t\t\tif ( jQuery.isFunction( arg ) ) {\n\t\t\t\t\t\t\t\t\tif ( !options.unique || !self.has( arg ) ) {\n\t\t\t\t\t\t\t\t\t\tlist.push( arg );\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t} else if ( arg && arg.length && jQuery.type( arg ) !== \"string\" ) {\n\n\t\t\t\t\t\t\t\t\t// Inspect recursively\n\t\t\t\t\t\t\t\t\tadd( arg );\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t} );\n\t\t\t\t\t\t} )( arguments );\n\n\t\t\t\t\t\tif ( memory && !firing ) {\n\t\t\t\t\t\t\tfire();\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\treturn this;\n\t\t\t\t},\n\n\t\t\t\t// Remove a callback from the list\n\t\t\t\tremove: function() {\n\t\t\t\t\tjQuery.each( arguments, function( _, arg ) {\n\t\t\t\t\t\tvar index;\n\t\t\t\t\t\twhile ( ( index = jQuery.inArray( arg, list, index ) ) > -1 ) {\n\t\t\t\t\t\t\tlist.splice( index, 1 );\n\n\t\t\t\t\t\t\t// Handle firing indexes\n\t\t\t\t\t\t\tif ( index <= firingIndex ) {\n\t\t\t\t\t\t\t\tfiringIndex--;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t} );\n\t\t\t\t\treturn this;\n\t\t\t\t},\n\n\t\t\t\t// Check if a given callback is in the list.\n\t\t\t\t// If no argument is given, return whether or not list has callbacks attached.\n\t\t\t\thas: function( fn ) {\n\t\t\t\t\treturn fn ?\n\t\t\t\t\tjQuery.inArray( fn, list ) > -1 :\n\t\t\t\t\tlist.length > 0;\n\t\t\t\t},\n\n\t\t\t\t// Remove all callbacks from the list\n\t\t\t\tempty: function() {\n\t\t\t\t\tif ( list ) {\n\t\t\t\t\t\tlist = [];\n\t\t\t\t\t}\n\t\t\t\t\treturn this;\n\t\t\t\t},\n\n\t\t\t\t// Disable .fire and .add\n\t\t\t\t// Abort any current/pending executions\n\t\t\t\t// Clear all callbacks and values\n\t\t\t\tdisable: function() {\n\t\t\t\t\tlocked = queue = [];\n\t\t\t\t\tlist = memory = \"\";\n\t\t\t\t\treturn this;\n\t\t\t\t},\n\t\t\t\tdisabled: function() {\n\t\t\t\t\treturn !list;\n\t\t\t\t},\n\n\t\t\t\t// Disable .fire\n\t\t\t\t// Also disable .add unless we have memory (since it would have no effect)\n\t\t\t\t// Abort any pending executions\n\t\t\t\tlock: function() {\n\t\t\t\t\tlocked = true;\n\t\t\t\t\tif ( !memory ) {\n\t\t\t\t\t\tself.disable();\n\t\t\t\t\t}\n\t\t\t\t\treturn this;\n\t\t\t\t},\n\t\t\t\tlocked: function() {\n\t\t\t\t\treturn !!locked;\n\t\t\t\t},\n\n\t\t\t\t// Call all callbacks with the given context and arguments\n\t\t\t\tfireWith: function( context, args ) {\n\t\t\t\t\tif ( !locked ) {\n\t\t\t\t\t\targs = args || [];\n\t\t\t\t\t\targs = [ context, args.slice ? args.slice() : args ];\n\t\t\t\t\t\tqueue.push( args );\n\t\t\t\t\t\tif ( !firing ) {\n\t\t\t\t\t\t\tfire();\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\treturn this;\n\t\t\t\t},\n\n\t\t\t\t// Call all the callbacks with the given arguments\n\t\t\t\tfire: function() {\n\t\t\t\t\tself.fireWith( this, arguments );\n\t\t\t\t\treturn this;\n\t\t\t\t},\n\n\t\t\t\t// To know if the callbacks have already been called at least once\n\t\t\t\tfired: function() {\n\t\t\t\t\treturn !!fired;\n\t\t\t\t}\n\t\t\t};\n\n\t\treturn self;\n\t};\n\n\n\tjQuery.extend( {\n\n\t\tDeferred: function( func ) {\n\t\t\tvar tuples = [\n\n\t\t\t\t\t// action, add listener, listener list, final state\n\t\t\t\t\t[ \"resolve\", \"done\", jQuery.Callbacks( \"once memory\" ), \"resolved\" ],\n\t\t\t\t\t[ \"reject\", \"fail\", jQuery.Callbacks( \"once memory\" ), \"rejected\" ],\n\t\t\t\t\t[ \"notify\", \"progress\", jQuery.Callbacks( \"memory\" ) ]\n\t\t\t\t],\n\t\t\t\tstate = \"pending\",\n\t\t\t\tpromise = {\n\t\t\t\t\tstate: function() {\n\t\t\t\t\t\treturn state;\n\t\t\t\t\t},\n\t\t\t\t\talways: function() {\n\t\t\t\t\t\tdeferred.done( arguments ).fail( arguments );\n\t\t\t\t\t\treturn this;\n\t\t\t\t\t},\n\t\t\t\t\tthen: function( /* fnDone, fnFail, fnProgress */ ) {\n\t\t\t\t\t\tvar fns = arguments;\n\t\t\t\t\t\treturn jQuery.Deferred( function( newDefer ) {\n\t\t\t\t\t\t\tjQuery.each( tuples, function( i, tuple ) {\n\t\t\t\t\t\t\t\tvar fn = jQuery.isFunction( fns[ i ] ) && fns[ i ];\n\n\t\t\t\t\t\t\t\t// deferred[ done | fail | progress ] for forwarding actions to newDefer\n\t\t\t\t\t\t\t\tdeferred[ tuple[ 1 ] ]( function() {\n\t\t\t\t\t\t\t\t\tvar returned = fn && fn.apply( this, arguments );\n\t\t\t\t\t\t\t\t\tif ( returned && jQuery.isFunction( returned.promise ) ) {\n\t\t\t\t\t\t\t\t\t\treturned.promise()\n\t\t\t\t\t\t\t\t\t\t\t.progress( newDefer.notify )\n\t\t\t\t\t\t\t\t\t\t\t.done( newDefer.resolve )\n\t\t\t\t\t\t\t\t\t\t\t.fail( newDefer.reject );\n\t\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\t\tnewDefer[ tuple[ 0 ] + \"With\" ](\n\t\t\t\t\t\t\t\t\t\t\tthis === promise ? newDefer.promise() : this,\n\t\t\t\t\t\t\t\t\t\t\tfn ? [ returned ] : arguments\n\t\t\t\t\t\t\t\t\t\t);\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t} );\n\t\t\t\t\t\t\t} );\n\t\t\t\t\t\t\tfns = null;\n\t\t\t\t\t\t} ).promise();\n\t\t\t\t\t},\n\n\t\t\t\t\t// Get a promise for this deferred\n\t\t\t\t\t// If obj is provided, the promise aspect is added to the object\n\t\t\t\t\tpromise: function( obj ) {\n\t\t\t\t\t\treturn obj != null ? jQuery.extend( obj, promise ) : promise;\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\tdeferred = {};\n\n\t\t\t// Keep pipe for back-compat\n\t\t\tpromise.pipe = promise.then;\n\n\t\t\t// Add list-specific methods\n\t\t\tjQuery.each( tuples, function( i, tuple ) {\n\t\t\t\tvar list = tuple[ 2 ],\n\t\t\t\t\tstateString = tuple[ 3 ];\n\n\t\t\t\t// promise[ done | fail | progress ] = list.add\n\t\t\t\tpromise[ tuple[ 1 ] ] = list.add;\n\n\t\t\t\t// Handle state\n\t\t\t\tif ( stateString ) {\n\t\t\t\t\tlist.add( function() {\n\n\t\t\t\t\t\t// state = [ resolved | rejected ]\n\t\t\t\t\t\tstate = stateString;\n\n\t\t\t\t\t\t// [ reject_list | resolve_list ].disable; progress_list.lock\n\t\t\t\t\t}, tuples[ i ^ 1 ][ 2 ].disable, tuples[ 2 ][ 2 ].lock );\n\t\t\t\t}\n\n\t\t\t\t// deferred[ resolve | reject | notify ]\n\t\t\t\tdeferred[ tuple[ 0 ] ] = function() {\n\t\t\t\t\tdeferred[ tuple[ 0 ] + \"With\" ]( this === deferred ? promise : this, arguments );\n\t\t\t\t\treturn this;\n\t\t\t\t};\n\t\t\t\tdeferred[ tuple[ 0 ] + \"With\" ] = list.fireWith;\n\t\t\t} );\n\n\t\t\t// Make the deferred a promise\n\t\t\tpromise.promise( deferred );\n\n\t\t\t// Call given func if any\n\t\t\tif ( func ) {\n\t\t\t\tfunc.call( deferred, deferred );\n\t\t\t}\n\n\t\t\t// All done!\n\t\t\treturn deferred;\n\t\t},\n\n\t\t// Deferred helper\n\t\twhen: function( subordinate /* , ..., subordinateN */ ) {\n\t\t\tvar i = 0,\n\t\t\t\tresolveValues = slice.call( arguments ),\n\t\t\t\tlength = resolveValues.length,\n\n\t\t\t\t// the count of uncompleted subordinates\n\t\t\t\tremaining = length !== 1 ||\n\t\t\t\t( subordinate && jQuery.isFunction( subordinate.promise ) ) ? length : 0,\n\n\t\t\t\t// the master Deferred.\n\t\t\t\t// If resolveValues consist of only a single Deferred, just use that.\n\t\t\t\tdeferred = remaining === 1 ? subordinate : jQuery.Deferred(),\n\n\t\t\t\t// Update function for both resolve and progress values\n\t\t\t\tupdateFunc = function( i, contexts, values ) {\n\t\t\t\t\treturn function( value ) {\n\t\t\t\t\t\tcontexts[ i ] = this;\n\t\t\t\t\t\tvalues[ i ] = arguments.length > 1 ? slice.call( arguments ) : value;\n\t\t\t\t\t\tif ( values === progressValues ) {\n\t\t\t\t\t\t\tdeferred.notifyWith( contexts, values );\n\n\t\t\t\t\t\t} else if ( !( --remaining ) ) {\n\t\t\t\t\t\t\tdeferred.resolveWith( contexts, values );\n\t\t\t\t\t\t}\n\t\t\t\t\t};\n\t\t\t\t},\n\n\t\t\t\tprogressValues, progressContexts, resolveContexts;\n\n\t\t\t// add listeners to Deferred subordinates; treat others as resolved\n\t\t\tif ( length > 1 ) {\n\t\t\t\tprogressValues = new Array( length );\n\t\t\t\tprogressContexts = new Array( length );\n\t\t\t\tresolveContexts = new Array( length );\n\t\t\t\tfor ( ; i < length; i++ ) {\n\t\t\t\t\tif ( resolveValues[ i ] && jQuery.isFunction( resolveValues[ i ].promise ) ) {\n\t\t\t\t\t\tresolveValues[ i ].promise()\n\t\t\t\t\t\t\t.progress( updateFunc( i, progressContexts, progressValues ) )\n\t\t\t\t\t\t\t.done( updateFunc( i, resolveContexts, resolveValues ) )\n\t\t\t\t\t\t\t.fail( deferred.reject );\n\t\t\t\t\t} else {\n\t\t\t\t\t\t--remaining;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// if we're not waiting on anything, resolve the master\n\t\t\tif ( !remaining ) {\n\t\t\t\tdeferred.resolveWith( resolveContexts, resolveValues );\n\t\t\t}\n\n\t\t\treturn deferred.promise();\n\t\t}\n\t} );\n\n\n// The deferred used on DOM ready\n\tvar readyList;\n\n\tjQuery.fn.ready = function( fn ) {\n\n\t\t// Add the callback\n\t\tjQuery.ready.promise().done( fn );\n\n\t\treturn this;\n\t};\n\n\tjQuery.extend( {\n\n\t\t// Is the DOM ready to be used? Set to true once it occurs.\n\t\tisReady: false,\n\n\t\t// A counter to track how many items to wait for before\n\t\t// the ready event fires. See #6781\n\t\treadyWait: 1,\n\n\t\t// Hold (or release) the ready event\n\t\tholdReady: function( hold ) {\n\t\t\tif ( hold ) {\n\t\t\t\tjQuery.readyWait++;\n\t\t\t} else {\n\t\t\t\tjQuery.ready( true );\n\t\t\t}\n\t\t},\n\n\t\t// Handle when the DOM is ready\n\t\tready: function( wait ) {\n\n\t\t\t// Abort if there are pending holds or we're already ready\n\t\t\tif ( wait === true ? --jQuery.readyWait : jQuery.isReady ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Remember that the DOM is ready\n\t\t\tjQuery.isReady = true;\n\n\t\t\t// If a normal DOM Ready event fired, decrement, and wait if need be\n\t\t\tif ( wait !== true && --jQuery.readyWait > 0 ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// If there are functions bound, to execute\n\t\t\treadyList.resolveWith( document, [ jQuery ] );\n\n\t\t\t// Trigger any bound ready events\n\t\t\tif ( jQuery.fn.triggerHandler ) {\n\t\t\t\tjQuery( document ).triggerHandler( \"ready\" );\n\t\t\t\tjQuery( document ).off( \"ready\" );\n\t\t\t}\n\t\t}\n\t} );\n\n\t/**\n\t * Clean-up method for dom ready events\n\t */\n\tfunction detach() {\n\t\tif ( document.addEventListener ) {\n\t\t\tdocument.removeEventListener( \"DOMContentLoaded\", completed );\n\t\t\twindow.removeEventListener( \"load\", completed );\n\n\t\t} else {\n\t\t\tdocument.detachEvent( \"onreadystatechange\", completed );\n\t\t\twindow.detachEvent( \"onload\", completed );\n\t\t}\n\t}\n\n\t/**\n\t * The ready event handler and self cleanup method\n\t */\n\tfunction completed() {\n\n\t\t// readyState === \"complete\" is good enough for us to call the dom ready in oldIE\n\t\tif ( document.addEventListener ||\n\t\t\twindow.event.type === \"load\" ||\n\t\t\tdocument.readyState === \"complete\" ) {\n\n\t\t\tdetach();\n\t\t\tjQuery.ready();\n\t\t}\n\t}\n\n\tjQuery.ready.promise = function( obj ) {\n\t\tif ( !readyList ) {\n\n\t\t\treadyList = jQuery.Deferred();\n\n\t\t\t// Catch cases where $(document).ready() is called\n\t\t\t// after the browser event has already occurred.\n\t\t\t// Support: IE6-10\n\t\t\t// Older IE sometimes signals \"interactive\" too soon\n\t\t\tif ( document.readyState === \"complete\" ||\n\t\t\t\t( document.readyState !== \"loading\" && !document.documentElement.doScroll ) ) {\n\n\t\t\t\t// Handle it asynchronously to allow scripts the opportunity to delay ready\n\t\t\t\twindow.setTimeout( jQuery.ready );\n\n\t\t\t\t// Standards-based browsers support DOMContentLoaded\n\t\t\t} else if ( document.addEventListener ) {\n\n\t\t\t\t// Use the handy event callback\n\t\t\t\tdocument.addEventListener( \"DOMContentLoaded\", completed );\n\n\t\t\t\t// A fallback to window.onload, that will always work\n\t\t\t\twindow.addEventListener( \"load\", completed );\n\n\t\t\t\t// If IE event model is used\n\t\t\t} else {\n\n\t\t\t\t// Ensure firing before onload, maybe late but safe also for iframes\n\t\t\t\tdocument.attachEvent( \"onreadystatechange\", completed );\n\n\t\t\t\t// A fallback to window.onload, that will always work\n\t\t\t\twindow.attachEvent( \"onload\", completed );\n\n\t\t\t\t// If IE and not a frame\n\t\t\t\t// continually check to see if the document is ready\n\t\t\t\tvar top = false;\n\n\t\t\t\ttry {\n\t\t\t\t\ttop = window.frameElement == null && document.documentElement;\n\t\t\t\t} catch ( e ) {}\n\n\t\t\t\tif ( top && top.doScroll ) {\n\t\t\t\t\t( function doScrollCheck() {\n\t\t\t\t\t\tif ( !jQuery.isReady ) {\n\n\t\t\t\t\t\t\ttry {\n\n\t\t\t\t\t\t\t\t// Use the trick by Diego Perini\n\t\t\t\t\t\t\t\t// http://javascript.nwbox.com/IEContentLoaded/\n\t\t\t\t\t\t\t\ttop.doScroll( \"left\" );\n\t\t\t\t\t\t\t} catch ( e ) {\n\t\t\t\t\t\t\t\treturn window.setTimeout( doScrollCheck, 50 );\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// detach all dom ready events\n\t\t\t\t\t\t\tdetach();\n\n\t\t\t\t\t\t\t// and execute any waiting functions\n\t\t\t\t\t\t\tjQuery.ready();\n\t\t\t\t\t\t}\n\t\t\t\t\t} )();\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t\treturn readyList.promise( obj );\n\t};\n\n// Kick off the DOM ready check even if the user does not\n\tjQuery.ready.promise();\n\n\n\n\n// Support: IE<9\n// Iteration over object's inherited properties before its own\n\tvar i;\n\tfor ( i in jQuery( support ) ) {\n\t\tbreak;\n\t}\n\tsupport.ownFirst = i === \"0\";\n\n// Note: most support tests are defined in their respective modules.\n// false until the test is run\n\tsupport.inlineBlockNeedsLayout = false;\n\n// Execute ASAP in case we need to set body.style.zoom\n\tjQuery( function() {\n\n\t\t// Minified: var a,b,c,d\n\t\tvar val, div, body, container;\n\n\t\tbody = document.getElementsByTagName( \"body\" )[ 0 ];\n\t\tif ( !body || !body.style ) {\n\n\t\t\t// Return for frameset docs that don't have a body\n\t\t\treturn;\n\t\t}\n\n\t\t// Setup\n\t\tdiv = document.createElement( \"div\" );\n\t\tcontainer = document.createElement( \"div\" );\n\t\tcontainer.style.cssText = \"position:absolute;border:0;width:0;height:0;top:0;left:-9999px\";\n\t\tbody.appendChild( container ).appendChild( div );\n\n\t\tif ( typeof div.style.zoom !== \"undefined\" ) {\n\n\t\t\t// Support: IE<8\n\t\t\t// Check if natively block-level elements act like inline-block\n\t\t\t// elements when setting their display to 'inline' and giving\n\t\t\t// them layout\n\t\t\tdiv.style.cssText = \"display:inline;margin:0;border:0;padding:1px;width:1px;zoom:1\";\n\n\t\t\tsupport.inlineBlockNeedsLayout = val = div.offsetWidth === 3;\n\t\t\tif ( val ) {\n\n\t\t\t\t// Prevent IE 6 from affecting layout for positioned elements #11048\n\t\t\t\t// Prevent IE from shrinking the body in IE 7 mode #12869\n\t\t\t\t// Support: IE<8\n\t\t\t\tbody.style.zoom = 1;\n\t\t\t}\n\t\t}\n\n\t\tbody.removeChild( container );\n\t} );\n\n\n\t( function() {\n\t\tvar div = document.createElement( \"div\" );\n\n\t\t// Support: IE<9\n\t\tsupport.deleteExpando = true;\n\t\ttry {\n\t\t\tdelete div.test;\n\t\t} catch ( e ) {\n\t\t\tsupport.deleteExpando = false;\n\t\t}\n\n\t\t// Null elements to avoid leaks in IE.\n\t\tdiv = null;\n\t} )();\n\tvar acceptData = function( elem ) {\n\t\tvar noData = jQuery.noData[ ( elem.nodeName + \" \" ).toLowerCase() ],\n\t\t\tnodeType = +elem.nodeType || 1;\n\n\t\t// Do not set data on non-element DOM nodes because it will not be cleared (#8335).\n\t\treturn nodeType !== 1 && nodeType !== 9 ?\n\t\t\tfalse :\n\n\t\t\t// Nodes accept data unless otherwise specified; rejection can be conditional\n\t\t!noData || noData !== true && elem.getAttribute( \"classid\" ) === noData;\n\t};\n\n\n\n\n\tvar rbrace = /^(?:\\{[\\w\\W]*\\}|\\[[\\w\\W]*\\])$/,\n\t\trmultiDash = /([A-Z])/g;\n\n\tfunction dataAttr( elem, key, data ) {\n\n\t\t// If nothing was found internally, try to fetch any\n\t\t// data from the HTML5 data-* attribute\n\t\tif ( data === undefined && elem.nodeType === 1 ) {\n\n\t\t\tvar name = \"data-\" + key.replace( rmultiDash, \"-$1\" ).toLowerCase();\n\n\t\t\tdata = elem.getAttribute( name );\n\n\t\t\tif ( typeof data === \"string\" ) {\n\t\t\t\ttry {\n\t\t\t\t\tdata = data === \"true\" ? true :\n\t\t\t\t\t\tdata === \"false\" ? false :\n\t\t\t\t\t\t\tdata === \"null\" ? null :\n\n\t\t\t\t\t\t\t\t// Only convert to a number if it doesn't change the string\n\t\t\t\t\t\t\t\t+data + \"\" === data ? +data :\n\t\t\t\t\t\t\t\t\trbrace.test( data ) ? jQuery.parseJSON( data ) :\n\t\t\t\t\t\t\t\t\t\tdata;\n\t\t\t\t} catch ( e ) {}\n\n\t\t\t\t// Make sure we set the data so it isn't changed later\n\t\t\t\tjQuery.data( elem, key, data );\n\n\t\t\t} else {\n\t\t\t\tdata = undefined;\n\t\t\t}\n\t\t}\n\n\t\treturn data;\n\t}\n\n// checks a cache object for emptiness\n\tfunction isEmptyDataObject( obj ) {\n\t\tvar name;\n\t\tfor ( name in obj ) {\n\n\t\t\t// if the public data object is empty, the private is still empty\n\t\t\tif ( name === \"data\" && jQuery.isEmptyObject( obj[ name ] ) ) {\n\t\t\t\tcontinue;\n\t\t\t}\n\t\t\tif ( name !== \"toJSON\" ) {\n\t\t\t\treturn false;\n\t\t\t}\n\t\t}\n\n\t\treturn true;\n\t}\n\n\tfunction internalData( elem, name, data, pvt /* Internal Use Only */ ) {\n\t\tif ( !acceptData( elem ) ) {\n\t\t\treturn;\n\t\t}\n\n\t\tvar ret, thisCache,\n\t\t\tinternalKey = jQuery.expando,\n\n\t\t\t// We have to handle DOM nodes and JS objects differently because IE6-7\n\t\t\t// can't GC object references properly across the DOM-JS boundary\n\t\t\tisNode = elem.nodeType,\n\n\t\t\t// Only DOM nodes need the global jQuery cache; JS object data is\n\t\t\t// attached directly to the object so GC can occur automatically\n\t\t\tcache = isNode ? jQuery.cache : elem,\n\n\t\t\t// Only defining an ID for JS objects if its cache already exists allows\n\t\t\t// the code to shortcut on the same path as a DOM node with no cache\n\t\t\tid = isNode ? elem[ internalKey ] : elem[ internalKey ] && internalKey;\n\n\t\t// Avoid doing any more work than we need to when trying to get data on an\n\t\t// object that has no data at all\n\t\tif ( ( !id || !cache[ id ] || ( !pvt && !cache[ id ].data ) ) &&\n\t\t\tdata === undefined && typeof name === \"string\" ) {\n\t\t\treturn;\n\t\t}\n\n\t\tif ( !id ) {\n\n\t\t\t// Only DOM nodes need a new unique ID for each element since their data\n\t\t\t// ends up in the global cache\n\t\t\tif ( isNode ) {\n\t\t\t\tid = elem[ internalKey ] = deletedIds.pop() || jQuery.guid++;\n\t\t\t} else {\n\t\t\t\tid = internalKey;\n\t\t\t}\n\t\t}\n\n\t\tif ( !cache[ id ] ) {\n\n\t\t\t// Avoid exposing jQuery metadata on plain JS objects when the object\n\t\t\t// is serialized using JSON.stringify\n\t\t\tcache[ id ] = isNode ? {} : { toJSON: jQuery.noop };\n\t\t}\n\n\t\t// An object can be passed to jQuery.data instead of a key/value pair; this gets\n\t\t// shallow copied over onto the existing cache\n\t\tif ( typeof name === \"object\" || typeof name === \"function\" ) {\n\t\t\tif ( pvt ) {\n\t\t\t\tcache[ id ] = jQuery.extend( cache[ id ], name );\n\t\t\t} else {\n\t\t\t\tcache[ id ].data = jQuery.extend( cache[ id ].data, name );\n\t\t\t}\n\t\t}\n\n\t\tthisCache = cache[ id ];\n\n\t\t// jQuery data() is stored in a separate object inside the object's internal data\n\t\t// cache in order to avoid key collisions between internal data and user-defined\n\t\t// data.\n\t\tif ( !pvt ) {\n\t\t\tif ( !thisCache.data ) {\n\t\t\t\tthisCache.data = {};\n\t\t\t}\n\n\t\t\tthisCache = thisCache.data;\n\t\t}\n\n\t\tif ( data !== undefined ) {\n\t\t\tthisCache[ jQuery.camelCase( name ) ] = data;\n\t\t}\n\n\t\t// Check for both converted-to-camel and non-converted data property names\n\t\t// If a data property was specified\n\t\tif ( typeof name === \"string\" ) {\n\n\t\t\t// First Try to find as-is property data\n\t\t\tret = thisCache[ name ];\n\n\t\t\t// Test for null|undefined property data\n\t\t\tif ( ret == null ) {\n\n\t\t\t\t// Try to find the camelCased property\n\t\t\t\tret = thisCache[ jQuery.camelCase( name ) ];\n\t\t\t}\n\t\t} else {\n\t\t\tret = thisCache;\n\t\t}\n\n\t\treturn ret;\n\t}\n\n\tfunction internalRemoveData( elem, name, pvt ) {\n\t\tif ( !acceptData( elem ) ) {\n\t\t\treturn;\n\t\t}\n\n\t\tvar thisCache, i,\n\t\t\tisNode = elem.nodeType,\n\n\t\t\t// See jQuery.data for more information\n\t\t\tcache = isNode ? jQuery.cache : elem,\n\t\t\tid = isNode ? elem[ jQuery.expando ] : jQuery.expando;\n\n\t\t// If there is already no cache entry for this object, there is no\n\t\t// purpose in continuing\n\t\tif ( !cache[ id ] ) {\n\t\t\treturn;\n\t\t}\n\n\t\tif ( name ) {\n\n\t\t\tthisCache = pvt ? cache[ id ] : cache[ id ].data;\n\n\t\t\tif ( thisCache ) {\n\n\t\t\t\t// Support array or space separated string names for data keys\n\t\t\t\tif ( !jQuery.isArray( name ) ) {\n\n\t\t\t\t\t// try the string as a key before any manipulation\n\t\t\t\t\tif ( name in thisCache ) {\n\t\t\t\t\t\tname = [ name ];\n\t\t\t\t\t} else {\n\n\t\t\t\t\t\t// split the camel cased version by spaces unless a key with the spaces exists\n\t\t\t\t\t\tname = jQuery.camelCase( name );\n\t\t\t\t\t\tif ( name in thisCache ) {\n\t\t\t\t\t\t\tname = [ name ];\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tname = name.split( \" \" );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t} else {\n\n\t\t\t\t\t// If \"name\" is an array of keys...\n\t\t\t\t\t// When data is initially created, via (\"key\", \"val\") signature,\n\t\t\t\t\t// keys will be converted to camelCase.\n\t\t\t\t\t// Since there is no way to tell _how_ a key was added, remove\n\t\t\t\t\t// both plain key and camelCase key. #12786\n\t\t\t\t\t// This will only penalize the array argument path.\n\t\t\t\t\tname = name.concat( jQuery.map( name, jQuery.camelCase ) );\n\t\t\t\t}\n\n\t\t\t\ti = name.length;\n\t\t\t\twhile ( i-- ) {\n\t\t\t\t\tdelete thisCache[ name[ i ] ];\n\t\t\t\t}\n\n\t\t\t\t// If there is no data left in the cache, we want to continue\n\t\t\t\t// and let the cache object itself get destroyed\n\t\t\t\tif ( pvt ? !isEmptyDataObject( thisCache ) : !jQuery.isEmptyObject( thisCache ) ) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\t// See jQuery.data for more information\n\t\tif ( !pvt ) {\n\t\t\tdelete cache[ id ].data;\n\n\t\t\t// Don't destroy the parent cache unless the internal data object\n\t\t\t// had been the only thing left in it\n\t\t\tif ( !isEmptyDataObject( cache[ id ] ) ) {\n\t\t\t\treturn;\n\t\t\t}\n\t\t}\n\n\t\t// Destroy the cache\n\t\tif ( isNode ) {\n\t\t\tjQuery.cleanData( [ elem ], true );\n\n\t\t\t// Use delete when supported for expandos or `cache` is not a window per isWindow (#10080)\n\t\t\t/* jshint eqeqeq: false */\n\t\t} else if ( support.deleteExpando || cache != cache.window ) {\n\t\t\t/* jshint eqeqeq: true */\n\t\t\tdelete cache[ id ];\n\n\t\t\t// When all else fails, undefined\n\t\t} else {\n\t\t\tcache[ id ] = undefined;\n\t\t}\n\t}\n\n\tjQuery.extend( {\n\t\tcache: {},\n\n\t\t// The following elements (space-suffixed to avoid Object.prototype collisions)\n\t\t// throw uncatchable exceptions if you attempt to set expando properties\n\t\tnoData: {\n\t\t\t\"applet \": true,\n\t\t\t\"embed \": true,\n\n\t\t\t// ...but Flash objects (which have this classid) *can* handle expandos\n\t\t\t\"object \": \"clsid:D27CDB6E-AE6D-11cf-96B8-444553540000\"\n\t\t},\n\n\t\thasData: function( elem ) {\n\t\t\telem = elem.nodeType ? jQuery.cache[ elem[ jQuery.expando ] ] : elem[ jQuery.expando ];\n\t\t\treturn !!elem && !isEmptyDataObject( elem );\n\t\t},\n\n\t\tdata: function( elem, name, data ) {\n\t\t\treturn internalData( elem, name, data );\n\t\t},\n\n\t\tremoveData: function( elem, name ) {\n\t\t\treturn internalRemoveData( elem, name );\n\t\t},\n\n\t\t// For internal use only.\n\t\t_data: function( elem, name, data ) {\n\t\t\treturn internalData( elem, name, data, true );\n\t\t},\n\n\t\t_removeData: function( elem, name ) {\n\t\t\treturn internalRemoveData( elem, name, true );\n\t\t}\n\t} );\n\n\tjQuery.fn.extend( {\n\t\tdata: function( key, value ) {\n\t\t\tvar i, name, data,\n\t\t\t\telem = this[ 0 ],\n\t\t\t\tattrs = elem && elem.attributes;\n\n\t\t\t// Special expections of .data basically thwart jQuery.access,\n\t\t\t// so implement the relevant behavior ourselves\n\n\t\t\t// Gets all values\n\t\t\tif ( key === undefined ) {\n\t\t\t\tif ( this.length ) {\n\t\t\t\t\tdata = jQuery.data( elem );\n\n\t\t\t\t\tif ( elem.nodeType === 1 && !jQuery._data( elem, \"parsedAttrs\" ) ) {\n\t\t\t\t\t\ti = attrs.length;\n\t\t\t\t\t\twhile ( i-- ) {\n\n\t\t\t\t\t\t\t// Support: IE11+\n\t\t\t\t\t\t\t// The attrs elements can be null (#14894)\n\t\t\t\t\t\t\tif ( attrs[ i ] ) {\n\t\t\t\t\t\t\t\tname = attrs[ i ].name;\n\t\t\t\t\t\t\t\tif ( name.indexOf( \"data-\" ) === 0 ) {\n\t\t\t\t\t\t\t\t\tname = jQuery.camelCase( name.slice( 5 ) );\n\t\t\t\t\t\t\t\t\tdataAttr( elem, name, data[ name ] );\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\tjQuery._data( elem, \"parsedAttrs\", true );\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\treturn data;\n\t\t\t}\n\n\t\t\t// Sets multiple values\n\t\t\tif ( typeof key === \"object\" ) {\n\t\t\t\treturn this.each( function() {\n\t\t\t\t\tjQuery.data( this, key );\n\t\t\t\t} );\n\t\t\t}\n\n\t\t\treturn arguments.length > 1 ?\n\n\t\t\t\t// Sets one value\n\t\t\t\tthis.each( function() {\n\t\t\t\t\tjQuery.data( this, key, value );\n\t\t\t\t} ) :\n\n\t\t\t\t// Gets one value\n\t\t\t\t// Try to fetch any internally stored data first\n\t\t\t\telem ? dataAttr( elem, key, jQuery.data( elem, key ) ) : undefined;\n\t\t},\n\n\t\tremoveData: function( key ) {\n\t\t\treturn this.each( function() {\n\t\t\t\tjQuery.removeData( this, key );\n\t\t\t} );\n\t\t}\n\t} );\n\n\n\tjQuery.extend( {\n\t\tqueue: function( elem, type, data ) {\n\t\t\tvar queue;\n\n\t\t\tif ( elem ) {\n\t\t\t\ttype = ( type || \"fx\" ) + \"queue\";\n\t\t\t\tqueue = jQuery._data( elem, type );\n\n\t\t\t\t// Speed up dequeue by getting out quickly if this is just a lookup\n\t\t\t\tif ( data ) {\n\t\t\t\t\tif ( !queue || jQuery.isArray( data ) ) {\n\t\t\t\t\t\tqueue = jQuery._data( elem, type, jQuery.makeArray( data ) );\n\t\t\t\t\t} else {\n\t\t\t\t\t\tqueue.push( data );\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\treturn queue || [];\n\t\t\t}\n\t\t},\n\n\t\tdequeue: function( elem, type ) {\n\t\t\ttype = type || \"fx\";\n\n\t\t\tvar queue = jQuery.queue( elem, type ),\n\t\t\t\tstartLength = queue.length,\n\t\t\t\tfn = queue.shift(),\n\t\t\t\thooks = jQuery._queueHooks( elem, type ),\n\t\t\t\tnext = function() {\n\t\t\t\t\tjQuery.dequeue( elem, type );\n\t\t\t\t};\n\n\t\t\t// If the fx queue is dequeued, always remove the progress sentinel\n\t\t\tif ( fn === \"inprogress\" ) {\n\t\t\t\tfn = queue.shift();\n\t\t\t\tstartLength--;\n\t\t\t}\n\n\t\t\tif ( fn ) {\n\n\t\t\t\t// Add a progress sentinel to prevent the fx queue from being\n\t\t\t\t// automatically dequeued\n\t\t\t\tif ( type === \"fx\" ) {\n\t\t\t\t\tqueue.unshift( \"inprogress\" );\n\t\t\t\t}\n\n\t\t\t\t// clear up the last queue stop function\n\t\t\t\tdelete hooks.stop;\n\t\t\t\tfn.call( elem, next, hooks );\n\t\t\t}\n\n\t\t\tif ( !startLength && hooks ) {\n\t\t\t\thooks.empty.fire();\n\t\t\t}\n\t\t},\n\n\t\t// not intended for public consumption - generates a queueHooks object,\n\t\t// or returns the current one\n\t\t_queueHooks: function( elem, type ) {\n\t\t\tvar key = type + \"queueHooks\";\n\t\t\treturn jQuery._data( elem, key ) || jQuery._data( elem, key, {\n\t\t\t\t\tempty: jQuery.Callbacks( \"once memory\" ).add( function() {\n\t\t\t\t\t\tjQuery._removeData( elem, type + \"queue\" );\n\t\t\t\t\t\tjQuery._removeData( elem, key );\n\t\t\t\t\t} )\n\t\t\t\t} );\n\t\t}\n\t} );\n\n\tjQuery.fn.extend( {\n\t\tqueue: function( type, data ) {\n\t\t\tvar setter = 2;\n\n\t\t\tif ( typeof type !== \"string\" ) {\n\t\t\t\tdata = type;\n\t\t\t\ttype = \"fx\";\n\t\t\t\tsetter--;\n\t\t\t}\n\n\t\t\tif ( arguments.length < setter ) {\n\t\t\t\treturn jQuery.queue( this[ 0 ], type );\n\t\t\t}\n\n\t\t\treturn data === undefined ?\n\t\t\t\tthis :\n\t\t\t\tthis.each( function() {\n\t\t\t\t\tvar queue = jQuery.queue( this, type, data );\n\n\t\t\t\t\t// ensure a hooks for this queue\n\t\t\t\t\tjQuery._queueHooks( this, type );\n\n\t\t\t\t\tif ( type === \"fx\" && queue[ 0 ] !== \"inprogress\" ) {\n\t\t\t\t\t\tjQuery.dequeue( this, type );\n\t\t\t\t\t}\n\t\t\t\t} );\n\t\t},\n\t\tdequeue: function( type ) {\n\t\t\treturn this.each( function() {\n\t\t\t\tjQuery.dequeue( this, type );\n\t\t\t} );\n\t\t},\n\t\tclearQueue: function( type ) {\n\t\t\treturn this.queue( type || \"fx\", [] );\n\t\t},\n\n\t\t// Get a promise resolved when queues of a certain type\n\t\t// are emptied (fx is the type by default)\n\t\tpromise: function( type, obj ) {\n\t\t\tvar tmp,\n\t\t\t\tcount = 1,\n\t\t\t\tdefer = jQuery.Deferred(),\n\t\t\t\telements = this,\n\t\t\t\ti = this.length,\n\t\t\t\tresolve = function() {\n\t\t\t\t\tif ( !( --count ) ) {\n\t\t\t\t\t\tdefer.resolveWith( elements, [ elements ] );\n\t\t\t\t\t}\n\t\t\t\t};\n\n\t\t\tif ( typeof type !== \"string\" ) {\n\t\t\t\tobj = type;\n\t\t\t\ttype = undefined;\n\t\t\t}\n\t\t\ttype = type || \"fx\";\n\n\t\t\twhile ( i-- ) {\n\t\t\t\ttmp = jQuery._data( elements[ i ], type + \"queueHooks\" );\n\t\t\t\tif ( tmp && tmp.empty ) {\n\t\t\t\t\tcount++;\n\t\t\t\t\ttmp.empty.add( resolve );\n\t\t\t\t}\n\t\t\t}\n\t\t\tresolve();\n\t\t\treturn defer.promise( obj );\n\t\t}\n\t} );\n\n\n\t( function() {\n\t\tvar shrinkWrapBlocksVal;\n\n\t\tsupport.shrinkWrapBlocks = function() {\n\t\t\tif ( shrinkWrapBlocksVal != null ) {\n\t\t\t\treturn shrinkWrapBlocksVal;\n\t\t\t}\n\n\t\t\t// Will be changed later if needed.\n\t\t\tshrinkWrapBlocksVal = false;\n\n\t\t\t// Minified: var b,c,d\n\t\t\tvar div, body, container;\n\n\t\t\tbody = document.getElementsByTagName( \"body\" )[ 0 ];\n\t\t\tif ( !body || !body.style ) {\n\n\t\t\t\t// Test fired too early or in an unsupported environment, exit.\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Setup\n\t\t\tdiv = document.createElement( \"div\" );\n\t\t\tcontainer = document.createElement( \"div\" );\n\t\t\tcontainer.style.cssText = \"position:absolute;border:0;width:0;height:0;top:0;left:-9999px\";\n\t\t\tbody.appendChild( container ).appendChild( div );\n\n\t\t\t// Support: IE6\n\t\t\t// Check if elements with layout shrink-wrap their children\n\t\t\tif ( typeof div.style.zoom !== \"undefined\" ) {\n\n\t\t\t\t// Reset CSS: box-sizing; display; margin; border\n\t\t\t\tdiv.style.cssText =\n\n\t\t\t\t\t// Support: Firefox<29, Android 2.3\n\t\t\t\t\t// Vendor-prefix box-sizing\n\t\t\t\t\t\"-webkit-box-sizing:content-box;-moz-box-sizing:content-box;\" +\n\t\t\t\t\t\"box-sizing:content-box;display:block;margin:0;border:0;\" +\n\t\t\t\t\t\"padding:1px;width:1px;zoom:1\";\n\t\t\t\tdiv.appendChild( document.createElement( \"div\" ) ).style.width = \"5px\";\n\t\t\t\tshrinkWrapBlocksVal = div.offsetWidth !== 3;\n\t\t\t}\n\n\t\t\tbody.removeChild( container );\n\n\t\t\treturn shrinkWrapBlocksVal;\n\t\t};\n\n\t} )();\n\tvar pnum = ( /[+-]?(?:\\d*\\.|)\\d+(?:[eE][+-]?\\d+|)/ ).source;\n\n\tvar rcssNum = new RegExp( \"^(?:([+-])=|)(\" + pnum + \")([a-z%]*)$\", \"i\" );\n\n\n\tvar cssExpand = [ \"Top\", \"Right\", \"Bottom\", \"Left\" ];\n\n\tvar isHidden = function( elem, el ) {\n\n\t\t// isHidden might be called from jQuery#filter function;\n\t\t// in that case, element will be second argument\n\t\telem = el || elem;\n\t\treturn jQuery.css( elem, \"display\" ) === \"none\" ||\n\t\t\t!jQuery.contains( elem.ownerDocument, elem );\n\t};\n\n\n\n\tfunction adjustCSS( elem, prop, valueParts, tween ) {\n\t\tvar adjusted,\n\t\t\tscale = 1,\n\t\t\tmaxIterations = 20,\n\t\t\tcurrentValue = tween ?\n\t\t\t\tfunction() { return tween.cur(); } :\n\t\t\t\tfunction() { return jQuery.css( elem, prop, \"\" ); },\n\t\t\tinitial = currentValue(),\n\t\t\tunit = valueParts && valueParts[ 3 ] || ( jQuery.cssNumber[ prop ] ? \"\" : \"px\" ),\n\n\t\t\t// Starting value computation is required for potential unit mismatches\n\t\t\tinitialInUnit = ( jQuery.cssNumber[ prop ] || unit !== \"px\" && +initial ) &&\n\t\t\t\trcssNum.exec( jQuery.css( elem, prop ) );\n\n\t\tif ( initialInUnit && initialInUnit[ 3 ] !== unit ) {\n\n\t\t\t// Trust units reported by jQuery.css\n\t\t\tunit = unit || initialInUnit[ 3 ];\n\n\t\t\t// Make sure we update the tween properties later on\n\t\t\tvalueParts = valueParts || [];\n\n\t\t\t// Iteratively approximate from a nonzero starting point\n\t\t\tinitialInUnit = +initial || 1;\n\n\t\t\tdo {\n\n\t\t\t\t// If previous iteration zeroed out, double until we get *something*.\n\t\t\t\t// Use string for doubling so we don't accidentally see scale as unchanged below\n\t\t\t\tscale = scale || \".5\";\n\n\t\t\t\t// Adjust and apply\n\t\t\t\tinitialInUnit = initialInUnit / scale;\n\t\t\t\tjQuery.style( elem, prop, initialInUnit + unit );\n\n\t\t\t\t// Update scale, tolerating zero or NaN from tween.cur()\n\t\t\t\t// Break the loop if scale is unchanged or perfect, or if we've just had enough.\n\t\t\t} while (\n\t\t\tscale !== ( scale = currentValue() / initial ) && scale !== 1 && --maxIterations\n\t\t\t\t);\n\t\t}\n\n\t\tif ( valueParts ) {\n\t\t\tinitialInUnit = +initialInUnit || +initial || 0;\n\n\t\t\t// Apply relative offset (+=/-=) if specified\n\t\t\tadjusted = valueParts[ 1 ] ?\n\t\t\tinitialInUnit + ( valueParts[ 1 ] + 1 ) * valueParts[ 2 ] :\n\t\t\t\t+valueParts[ 2 ];\n\t\t\tif ( tween ) {\n\t\t\t\ttween.unit = unit;\n\t\t\t\ttween.start = initialInUnit;\n\t\t\t\ttween.end = adjusted;\n\t\t\t}\n\t\t}\n\t\treturn adjusted;\n\t}\n\n\n// Multifunctional method to get and set values of a collection\n// The value/s can optionally be executed if it's a function\n\tvar access = function( elems, fn, key, value, chainable, emptyGet, raw ) {\n\t\tvar i = 0,\n\t\t\tlength = elems.length,\n\t\t\tbulk = key == null;\n\n\t\t// Sets many values\n\t\tif ( jQuery.type( key ) === \"object\" ) {\n\t\t\tchainable = true;\n\t\t\tfor ( i in key ) {\n\t\t\t\taccess( elems, fn, i, key[ i ], true, emptyGet, raw );\n\t\t\t}\n\n\t\t\t// Sets one value\n\t\t} else if ( value !== undefined ) {\n\t\t\tchainable = true;\n\n\t\t\tif ( !jQuery.isFunction( value ) ) {\n\t\t\t\traw = true;\n\t\t\t}\n\n\t\t\tif ( bulk ) {\n\n\t\t\t\t// Bulk operations run against the entire set\n\t\t\t\tif ( raw ) {\n\t\t\t\t\tfn.call( elems, value );\n\t\t\t\t\tfn = null;\n\n\t\t\t\t\t// ...except when executing function values\n\t\t\t\t} else {\n\t\t\t\t\tbulk = fn;\n\t\t\t\t\tfn = function( elem, key, value ) {\n\t\t\t\t\t\treturn bulk.call( jQuery( elem ), value );\n\t\t\t\t\t};\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif ( fn ) {\n\t\t\t\tfor ( ; i < length; i++ ) {\n\t\t\t\t\tfn(\n\t\t\t\t\t\telems[ i ],\n\t\t\t\t\t\tkey,\n\t\t\t\t\t\traw ? value : value.call( elems[ i ], i, fn( elems[ i ], key ) )\n\t\t\t\t\t);\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\treturn chainable ?\n\t\t\telems :\n\n\t\t\t// Gets\n\t\t\tbulk ?\n\t\t\t\tfn.call( elems ) :\n\t\t\t\tlength ? fn( elems[ 0 ], key ) : emptyGet;\n\t};\n\tvar rcheckableType = ( /^(?:checkbox|radio)$/i );\n\n\tvar rtagName = ( /<([\\w:-]+)/ );\n\n\tvar rscriptType = ( /^$|\\/(?:java|ecma)script/i );\n\n\tvar rleadingWhitespace = ( /^\\s+/ );\n\n\tvar nodeNames = \"abbr|article|aside|audio|bdi|canvas|data|datalist|\" +\n\t\t\"details|dialog|figcaption|figure|footer|header|hgroup|main|\" +\n\t\t\"mark|meter|nav|output|picture|progress|section|summary|template|time|video\";\n\n\n\n\tfunction createSafeFragment( document ) {\n\t\tvar list = nodeNames.split( \"|\" ),\n\t\t\tsafeFrag = document.createDocumentFragment();\n\n\t\tif ( safeFrag.createElement ) {\n\t\t\twhile ( list.length ) {\n\t\t\t\tsafeFrag.createElement(\n\t\t\t\t\tlist.pop()\n\t\t\t\t);\n\t\t\t}\n\t\t}\n\t\treturn safeFrag;\n\t}\n\n\n\t( function() {\n\t\tvar div = document.createElement( \"div\" ),\n\t\t\tfragment = document.createDocumentFragment(),\n\t\t\tinput = document.createElement( \"input\" );\n\n\t\t// Setup\n\t\tdiv.innerHTML = \"  <link/><table></table><a href='/a'>a</a><input type='checkbox'/>\";\n\n\t\t// IE strips leading whitespace when .innerHTML is used\n\t\tsupport.leadingWhitespace = div.firstChild.nodeType === 3;\n\n\t\t// Make sure that tbody elements aren't automatically inserted\n\t\t// IE will insert them into empty tables\n\t\tsupport.tbody = !div.getElementsByTagName( \"tbody\" ).length;\n\n\t\t// Make sure that link elements get serialized correctly by innerHTML\n\t\t// This requires a wrapper element in IE\n\t\tsupport.htmlSerialize = !!div.getElementsByTagName( \"link\" ).length;\n\n\t\t// Makes sure cloning an html5 element does not cause problems\n\t\t// Where outerHTML is undefined, this still works\n\t\tsupport.html5Clone =\n\t\t\tdocument.createElement( \"nav\" ).cloneNode( true ).outerHTML !== \"<:nav></:nav>\";\n\n\t\t// Check if a disconnected checkbox will retain its checked\n\t\t// value of true after appended to the DOM (IE6/7)\n\t\tinput.type = \"checkbox\";\n\t\tinput.checked = true;\n\t\tfragment.appendChild( input );\n\t\tsupport.appendChecked = input.checked;\n\n\t\t// Make sure textarea (and checkbox) defaultValue is properly cloned\n\t\t// Support: IE6-IE11+\n\t\tdiv.innerHTML = \"<textarea>x</textarea>\";\n\t\tsupport.noCloneChecked = !!div.cloneNode( true ).lastChild.defaultValue;\n\n\t\t// #11217 - WebKit loses check when the name is after the checked attribute\n\t\tfragment.appendChild( div );\n\n\t\t// Support: Windows Web Apps (WWA)\n\t\t// `name` and `type` must use .setAttribute for WWA (#14901)\n\t\tinput = document.createElement( \"input\" );\n\t\tinput.setAttribute( \"type\", \"radio\" );\n\t\tinput.setAttribute( \"checked\", \"checked\" );\n\t\tinput.setAttribute( \"name\", \"t\" );\n\n\t\tdiv.appendChild( input );\n\n\t\t// Support: Safari 5.1, iOS 5.1, Android 4.x, Android 2.3\n\t\t// old WebKit doesn't clone checked state correctly in fragments\n\t\tsupport.checkClone = div.cloneNode( true ).cloneNode( true ).lastChild.checked;\n\n\t\t// Support: IE<9\n\t\t// Cloned elements keep attachEvent handlers, we use addEventListener on IE9+\n\t\tsupport.noCloneEvent = !!div.addEventListener;\n\n\t\t// Support: IE<9\n\t\t// Since attributes and properties are the same in IE,\n\t\t// cleanData must set properties to undefined rather than use removeAttribute\n\t\tdiv[ jQuery.expando ] = 1;\n\t\tsupport.attributes = !div.getAttribute( jQuery.expando );\n\t} )();\n\n\n// We have to close these tags to support XHTML (#13200)\n\tvar wrapMap = {\n\t\toption: [ 1, \"<select multiple='multiple'>\", \"</select>\" ],\n\t\tlegend: [ 1, \"<fieldset>\", \"</fieldset>\" ],\n\t\tarea: [ 1, \"<map>\", \"</map>\" ],\n\n\t\t// Support: IE8\n\t\tparam: [ 1, \"<object>\", \"</object>\" ],\n\t\tthead: [ 1, \"<table>\", \"</table>\" ],\n\t\ttr: [ 2, \"<table><tbody>\", \"</tbody></table>\" ],\n\t\tcol: [ 2, \"<table><tbody></tbody><colgroup>\", \"</colgroup></table>\" ],\n\t\ttd: [ 3, \"<table><tbody><tr>\", \"</tr></tbody></table>\" ],\n\n\t\t// IE6-8 can't serialize link, script, style, or any html5 (NoScope) tags,\n\t\t// unless wrapped in a div with non-breaking characters in front of it.\n\t\t_default: support.htmlSerialize ? [ 0, \"\", \"\" ] : [ 1, \"X<div>\", \"</div>\" ]\n\t};\n\n// Support: IE8-IE9\n\twrapMap.optgroup = wrapMap.option;\n\n\twrapMap.tbody = wrapMap.tfoot = wrapMap.colgroup = wrapMap.caption = wrapMap.thead;\n\twrapMap.th = wrapMap.td;\n\n\n\tfunction getAll( context, tag ) {\n\t\tvar elems, elem,\n\t\t\ti = 0,\n\t\t\tfound = typeof context.getElementsByTagName !== \"undefined\" ?\n\t\t\t\tcontext.getElementsByTagName( tag || \"*\" ) :\n\t\t\t\ttypeof context.querySelectorAll !== \"undefined\" ?\n\t\t\t\t\tcontext.querySelectorAll( tag || \"*\" ) :\n\t\t\t\t\tundefined;\n\n\t\tif ( !found ) {\n\t\t\tfor ( found = [], elems = context.childNodes || context;\n\t\t\t\t  ( elem = elems[ i ] ) != null;\n\t\t\t\t  i++\n\t\t\t) {\n\t\t\t\tif ( !tag || jQuery.nodeName( elem, tag ) ) {\n\t\t\t\t\tfound.push( elem );\n\t\t\t\t} else {\n\t\t\t\t\tjQuery.merge( found, getAll( elem, tag ) );\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\treturn tag === undefined || tag && jQuery.nodeName( context, tag ) ?\n\t\t\tjQuery.merge( [ context ], found ) :\n\t\t\tfound;\n\t}\n\n\n// Mark scripts as having already been evaluated\n\tfunction setGlobalEval( elems, refElements ) {\n\t\tvar elem,\n\t\t\ti = 0;\n\t\tfor ( ; ( elem = elems[ i ] ) != null; i++ ) {\n\t\t\tjQuery._data(\n\t\t\t\telem,\n\t\t\t\t\"globalEval\",\n\t\t\t\t!refElements || jQuery._data( refElements[ i ], \"globalEval\" )\n\t\t\t);\n\t\t}\n\t}\n\n\n\tvar rhtml = /<|&#?\\w+;/,\n\t\trtbody = /<tbody/i;\n\n\tfunction fixDefaultChecked( elem ) {\n\t\tif ( rcheckableType.test( elem.type ) ) {\n\t\t\telem.defaultChecked = elem.checked;\n\t\t}\n\t}\n\n\tfunction buildFragment( elems, context, scripts, selection, ignored ) {\n\t\tvar j, elem, contains,\n\t\t\ttmp, tag, tbody, wrap,\n\t\t\tl = elems.length,\n\n\t\t\t// Ensure a safe fragment\n\t\t\tsafe = createSafeFragment( context ),\n\n\t\t\tnodes = [],\n\t\t\ti = 0;\n\n\t\tfor ( ; i < l; i++ ) {\n\t\t\telem = elems[ i ];\n\n\t\t\tif ( elem || elem === 0 ) {\n\n\t\t\t\t// Add nodes directly\n\t\t\t\tif ( jQuery.type( elem ) === \"object\" ) {\n\t\t\t\t\tjQuery.merge( nodes, elem.nodeType ? [ elem ] : elem );\n\n\t\t\t\t\t// Convert non-html into a text node\n\t\t\t\t} else if ( !rhtml.test( elem ) ) {\n\t\t\t\t\tnodes.push( context.createTextNode( elem ) );\n\n\t\t\t\t\t// Convert html into DOM nodes\n\t\t\t\t} else {\n\t\t\t\t\ttmp = tmp || safe.appendChild( context.createElement( \"div\" ) );\n\n\t\t\t\t\t// Deserialize a standard representation\n\t\t\t\t\ttag = ( rtagName.exec( elem ) || [ \"\", \"\" ] )[ 1 ].toLowerCase();\n\t\t\t\t\twrap = wrapMap[ tag ] || wrapMap._default;\n\n\t\t\t\t\ttmp.innerHTML = wrap[ 1 ] + jQuery.htmlPrefilter( elem ) + wrap[ 2 ];\n\n\t\t\t\t\t// Descend through wrappers to the right content\n\t\t\t\t\tj = wrap[ 0 ];\n\t\t\t\t\twhile ( j-- ) {\n\t\t\t\t\t\ttmp = tmp.lastChild;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Manually add leading whitespace removed by IE\n\t\t\t\t\tif ( !support.leadingWhitespace && rleadingWhitespace.test( elem ) ) {\n\t\t\t\t\t\tnodes.push( context.createTextNode( rleadingWhitespace.exec( elem )[ 0 ] ) );\n\t\t\t\t\t}\n\n\t\t\t\t\t// Remove IE's autoinserted <tbody> from table fragments\n\t\t\t\t\tif ( !support.tbody ) {\n\n\t\t\t\t\t\t// String was a <table>, *may* have spurious <tbody>\n\t\t\t\t\t\telem = tag === \"table\" && !rtbody.test( elem ) ?\n\t\t\t\t\t\t\ttmp.firstChild :\n\n\t\t\t\t\t\t\t// String was a bare <thead> or <tfoot>\n\t\t\t\t\t\t\twrap[ 1 ] === \"<table>\" && !rtbody.test( elem ) ?\n\t\t\t\t\t\t\t\ttmp :\n\t\t\t\t\t\t\t\t0;\n\n\t\t\t\t\t\tj = elem && elem.childNodes.length;\n\t\t\t\t\t\twhile ( j-- ) {\n\t\t\t\t\t\t\tif ( jQuery.nodeName( ( tbody = elem.childNodes[ j ] ), \"tbody\" ) &&\n\t\t\t\t\t\t\t\t!tbody.childNodes.length ) {\n\n\t\t\t\t\t\t\t\telem.removeChild( tbody );\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\tjQuery.merge( nodes, tmp.childNodes );\n\n\t\t\t\t\t// Fix #12392 for WebKit and IE > 9\n\t\t\t\t\ttmp.textContent = \"\";\n\n\t\t\t\t\t// Fix #12392 for oldIE\n\t\t\t\t\twhile ( tmp.firstChild ) {\n\t\t\t\t\t\ttmp.removeChild( tmp.firstChild );\n\t\t\t\t\t}\n\n\t\t\t\t\t// Remember the top-level container for proper cleanup\n\t\t\t\t\ttmp = safe.lastChild;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\t// Fix #11356: Clear elements from fragment\n\t\tif ( tmp ) {\n\t\t\tsafe.removeChild( tmp );\n\t\t}\n\n\t\t// Reset defaultChecked for any radios and checkboxes\n\t\t// about to be appended to the DOM in IE 6/7 (#8060)\n\t\tif ( !support.appendChecked ) {\n\t\t\tjQuery.grep( getAll( nodes, \"input\" ), fixDefaultChecked );\n\t\t}\n\n\t\ti = 0;\n\t\twhile ( ( elem = nodes[ i++ ] ) ) {\n\n\t\t\t// Skip elements already in the context collection (trac-4087)\n\t\t\tif ( selection && jQuery.inArray( elem, selection ) > -1 ) {\n\t\t\t\tif ( ignored ) {\n\t\t\t\t\tignored.push( elem );\n\t\t\t\t}\n\n\t\t\t\tcontinue;\n\t\t\t}\n\n\t\t\tcontains = jQuery.contains( elem.ownerDocument, elem );\n\n\t\t\t// Append to fragment\n\t\t\ttmp = getAll( safe.appendChild( elem ), \"script\" );\n\n\t\t\t// Preserve script evaluation history\n\t\t\tif ( contains ) {\n\t\t\t\tsetGlobalEval( tmp );\n\t\t\t}\n\n\t\t\t// Capture executables\n\t\t\tif ( scripts ) {\n\t\t\t\tj = 0;\n\t\t\t\twhile ( ( elem = tmp[ j++ ] ) ) {\n\t\t\t\t\tif ( rscriptType.test( elem.type || \"\" ) ) {\n\t\t\t\t\t\tscripts.push( elem );\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\ttmp = null;\n\n\t\treturn safe;\n\t}\n\n\n\t( function() {\n\t\tvar i, eventName,\n\t\t\tdiv = document.createElement( \"div\" );\n\n\t\t// Support: IE<9 (lack submit/change bubble), Firefox (lack focus(in | out) events)\n\t\tfor ( i in { submit: true, change: true, focusin: true } ) {\n\t\t\teventName = \"on\" + i;\n\n\t\t\tif ( !( support[ i ] = eventName in window ) ) {\n\n\t\t\t\t// Beware of CSP restrictions (https://developer.mozilla.org/en/Security/CSP)\n\t\t\t\tdiv.setAttribute( eventName, \"t\" );\n\t\t\t\tsupport[ i ] = div.attributes[ eventName ].expando === false;\n\t\t\t}\n\t\t}\n\n\t\t// Null elements to avoid leaks in IE.\n\t\tdiv = null;\n\t} )();\n\n\n\tvar rformElems = /^(?:input|select|textarea)$/i,\n\t\trkeyEvent = /^key/,\n\t\trmouseEvent = /^(?:mouse|pointer|contextmenu|drag|drop)|click/,\n\t\trfocusMorph = /^(?:focusinfocus|focusoutblur)$/,\n\t\trtypenamespace = /^([^.]*)(?:\\.(.+)|)/;\n\n\tfunction returnTrue() {\n\t\treturn true;\n\t}\n\n\tfunction returnFalse() {\n\t\treturn false;\n\t}\n\n// Support: IE9\n// See #13393 for more info\n\tfunction safeActiveElement() {\n\t\ttry {\n\t\t\treturn document.activeElement;\n\t\t} catch ( err ) { }\n\t}\n\n\tfunction on( elem, types, selector, data, fn, one ) {\n\t\tvar origFn, type;\n\n\t\t// Types can be a map of types/handlers\n\t\tif ( typeof types === \"object\" ) {\n\n\t\t\t// ( types-Object, selector, data )\n\t\t\tif ( typeof selector !== \"string\" ) {\n\n\t\t\t\t// ( types-Object, data )\n\t\t\t\tdata = data || selector;\n\t\t\t\tselector = undefined;\n\t\t\t}\n\t\t\tfor ( type in types ) {\n\t\t\t\ton( elem, type, selector, data, types[ type ], one );\n\t\t\t}\n\t\t\treturn elem;\n\t\t}\n\n\t\tif ( data == null && fn == null ) {\n\n\t\t\t// ( types, fn )\n\t\t\tfn = selector;\n\t\t\tdata = selector = undefined;\n\t\t} else if ( fn == null ) {\n\t\t\tif ( typeof selector === \"string\" ) {\n\n\t\t\t\t// ( types, selector, fn )\n\t\t\t\tfn = data;\n\t\t\t\tdata = undefined;\n\t\t\t} else {\n\n\t\t\t\t// ( types, data, fn )\n\t\t\t\tfn = data;\n\t\t\t\tdata = selector;\n\t\t\t\tselector = undefined;\n\t\t\t}\n\t\t}\n\t\tif ( fn === false ) {\n\t\t\tfn = returnFalse;\n\t\t} else if ( !fn ) {\n\t\t\treturn elem;\n\t\t}\n\n\t\tif ( one === 1 ) {\n\t\t\torigFn = fn;\n\t\t\tfn = function( event ) {\n\n\t\t\t\t// Can use an empty set, since event contains the info\n\t\t\t\tjQuery().off( event );\n\t\t\t\treturn origFn.apply( this, arguments );\n\t\t\t};\n\n\t\t\t// Use same guid so caller can remove using origFn\n\t\t\tfn.guid = origFn.guid || ( origFn.guid = jQuery.guid++ );\n\t\t}\n\t\treturn elem.each( function() {\n\t\t\tjQuery.event.add( this, types, fn, data, selector );\n\t\t} );\n\t}\n\n\t/*\n\t * Helper functions for managing events -- not part of the public interface.\n\t * Props to Dean Edwards' addEvent library for many of the ideas.\n\t */\n\tjQuery.event = {\n\n\t\tglobal: {},\n\n\t\tadd: function( elem, types, handler, data, selector ) {\n\t\t\tvar tmp, events, t, handleObjIn,\n\t\t\t\tspecial, eventHandle, handleObj,\n\t\t\t\thandlers, type, namespaces, origType,\n\t\t\t\telemData = jQuery._data( elem );\n\n\t\t\t// Don't attach events to noData or text/comment nodes (but allow plain objects)\n\t\t\tif ( !elemData ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Caller can pass in an object of custom data in lieu of the handler\n\t\t\tif ( handler.handler ) {\n\t\t\t\thandleObjIn = handler;\n\t\t\t\thandler = handleObjIn.handler;\n\t\t\t\tselector = handleObjIn.selector;\n\t\t\t}\n\n\t\t\t// Make sure that the handler has a unique ID, used to find/remove it later\n\t\t\tif ( !handler.guid ) {\n\t\t\t\thandler.guid = jQuery.guid++;\n\t\t\t}\n\n\t\t\t// Init the element's event structure and main handler, if this is the first\n\t\t\tif ( !( events = elemData.events ) ) {\n\t\t\t\tevents = elemData.events = {};\n\t\t\t}\n\t\t\tif ( !( eventHandle = elemData.handle ) ) {\n\t\t\t\teventHandle = elemData.handle = function( e ) {\n\n\t\t\t\t\t// Discard the second event of a jQuery.event.trigger() and\n\t\t\t\t\t// when an event is called after a page has unloaded\n\t\t\t\t\treturn typeof jQuery !== \"undefined\" &&\n\t\t\t\t\t( !e || jQuery.event.triggered !== e.type ) ?\n\t\t\t\t\t\tjQuery.event.dispatch.apply( eventHandle.elem, arguments ) :\n\t\t\t\t\t\tundefined;\n\t\t\t\t};\n\n\t\t\t\t// Add elem as a property of the handle fn to prevent a memory leak\n\t\t\t\t// with IE non-native events\n\t\t\t\teventHandle.elem = elem;\n\t\t\t}\n\n\t\t\t// Handle multiple events separated by a space\n\t\t\ttypes = ( types || \"\" ).match( rnotwhite ) || [ \"\" ];\n\t\t\tt = types.length;\n\t\t\twhile ( t-- ) {\n\t\t\t\ttmp = rtypenamespace.exec( types[ t ] ) || [];\n\t\t\t\ttype = origType = tmp[ 1 ];\n\t\t\t\tnamespaces = ( tmp[ 2 ] || \"\" ).split( \".\" ).sort();\n\n\t\t\t\t// There *must* be a type, no attaching namespace-only handlers\n\t\t\t\tif ( !type ) {\n\t\t\t\t\tcontinue;\n\t\t\t\t}\n\n\t\t\t\t// If event changes its type, use the special event handlers for the changed type\n\t\t\t\tspecial = jQuery.event.special[ type ] || {};\n\n\t\t\t\t// If selector defined, determine special event api type, otherwise given type\n\t\t\t\ttype = ( selector ? special.delegateType : special.bindType ) || type;\n\n\t\t\t\t// Update special based on newly reset type\n\t\t\t\tspecial = jQuery.event.special[ type ] || {};\n\n\t\t\t\t// handleObj is passed to all event handlers\n\t\t\t\thandleObj = jQuery.extend( {\n\t\t\t\t\ttype: type,\n\t\t\t\t\torigType: origType,\n\t\t\t\t\tdata: data,\n\t\t\t\t\thandler: handler,\n\t\t\t\t\tguid: handler.guid,\n\t\t\t\t\tselector: selector,\n\t\t\t\t\tneedsContext: selector && jQuery.expr.match.needsContext.test( selector ),\n\t\t\t\t\tnamespace: namespaces.join( \".\" )\n\t\t\t\t}, handleObjIn );\n\n\t\t\t\t// Init the event handler queue if we're the first\n\t\t\t\tif ( !( handlers = events[ type ] ) ) {\n\t\t\t\t\thandlers = events[ type ] = [];\n\t\t\t\t\thandlers.delegateCount = 0;\n\n\t\t\t\t\t// Only use addEventListener/attachEvent if the special events handler returns false\n\t\t\t\t\tif ( !special.setup ||\n\t\t\t\t\t\tspecial.setup.call( elem, data, namespaces, eventHandle ) === false ) {\n\n\t\t\t\t\t\t// Bind the global event handler to the element\n\t\t\t\t\t\tif ( elem.addEventListener ) {\n\t\t\t\t\t\t\telem.addEventListener( type, eventHandle, false );\n\n\t\t\t\t\t\t} else if ( elem.attachEvent ) {\n\t\t\t\t\t\t\telem.attachEvent( \"on\" + type, eventHandle );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tif ( special.add ) {\n\t\t\t\t\tspecial.add.call( elem, handleObj );\n\n\t\t\t\t\tif ( !handleObj.handler.guid ) {\n\t\t\t\t\t\thandleObj.handler.guid = handler.guid;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Add to the element's handler list, delegates in front\n\t\t\t\tif ( selector ) {\n\t\t\t\t\thandlers.splice( handlers.delegateCount++, 0, handleObj );\n\t\t\t\t} else {\n\t\t\t\t\thandlers.push( handleObj );\n\t\t\t\t}\n\n\t\t\t\t// Keep track of which events have ever been used, for event optimization\n\t\t\t\tjQuery.event.global[ type ] = true;\n\t\t\t}\n\n\t\t\t// Nullify elem to prevent memory leaks in IE\n\t\t\telem = null;\n\t\t},\n\n\t\t// Detach an event or set of events from an element\n\t\tremove: function( elem, types, handler, selector, mappedTypes ) {\n\t\t\tvar j, handleObj, tmp,\n\t\t\t\torigCount, t, events,\n\t\t\t\tspecial, handlers, type,\n\t\t\t\tnamespaces, origType,\n\t\t\t\telemData = jQuery.hasData( elem ) && jQuery._data( elem );\n\n\t\t\tif ( !elemData || !( events = elemData.events ) ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Once for each type.namespace in types; type may be omitted\n\t\t\ttypes = ( types || \"\" ).match( rnotwhite ) || [ \"\" ];\n\t\t\tt = types.length;\n\t\t\twhile ( t-- ) {\n\t\t\t\ttmp = rtypenamespace.exec( types[ t ] ) || [];\n\t\t\t\ttype = origType = tmp[ 1 ];\n\t\t\t\tnamespaces = ( tmp[ 2 ] || \"\" ).split( \".\" ).sort();\n\n\t\t\t\t// Unbind all events (on this namespace, if provided) for the element\n\t\t\t\tif ( !type ) {\n\t\t\t\t\tfor ( type in events ) {\n\t\t\t\t\t\tjQuery.event.remove( elem, type + types[ t ], handler, selector, true );\n\t\t\t\t\t}\n\t\t\t\t\tcontinue;\n\t\t\t\t}\n\n\t\t\t\tspecial = jQuery.event.special[ type ] || {};\n\t\t\t\ttype = ( selector ? special.delegateType : special.bindType ) || type;\n\t\t\t\thandlers = events[ type ] || [];\n\t\t\t\ttmp = tmp[ 2 ] &&\n\t\t\t\t\tnew RegExp( \"(^|\\\\.)\" + namespaces.join( \"\\\\.(?:.*\\\\.|)\" ) + \"(\\\\.|$)\" );\n\n\t\t\t\t// Remove matching events\n\t\t\t\torigCount = j = handlers.length;\n\t\t\t\twhile ( j-- ) {\n\t\t\t\t\thandleObj = handlers[ j ];\n\n\t\t\t\t\tif ( ( mappedTypes || origType === handleObj.origType ) &&\n\t\t\t\t\t\t( !handler || handler.guid === handleObj.guid ) &&\n\t\t\t\t\t\t( !tmp || tmp.test( handleObj.namespace ) ) &&\n\t\t\t\t\t\t( !selector || selector === handleObj.selector ||\n\t\t\t\t\t\tselector === \"**\" && handleObj.selector ) ) {\n\t\t\t\t\t\thandlers.splice( j, 1 );\n\n\t\t\t\t\t\tif ( handleObj.selector ) {\n\t\t\t\t\t\t\thandlers.delegateCount--;\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif ( special.remove ) {\n\t\t\t\t\t\t\tspecial.remove.call( elem, handleObj );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Remove generic event handler if we removed something and no more handlers exist\n\t\t\t\t// (avoids potential for endless recursion during removal of special event handlers)\n\t\t\t\tif ( origCount && !handlers.length ) {\n\t\t\t\t\tif ( !special.teardown ||\n\t\t\t\t\t\tspecial.teardown.call( elem, namespaces, elemData.handle ) === false ) {\n\n\t\t\t\t\t\tjQuery.removeEvent( elem, type, elemData.handle );\n\t\t\t\t\t}\n\n\t\t\t\t\tdelete events[ type ];\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Remove the expando if it's no longer used\n\t\t\tif ( jQuery.isEmptyObject( events ) ) {\n\t\t\t\tdelete elemData.handle;\n\n\t\t\t\t// removeData also checks for emptiness and clears the expando if empty\n\t\t\t\t// so use it instead of delete\n\t\t\t\tjQuery._removeData( elem, \"events\" );\n\t\t\t}\n\t\t},\n\n\t\ttrigger: function( event, data, elem, onlyHandlers ) {\n\t\t\tvar handle, ontype, cur,\n\t\t\t\tbubbleType, special, tmp, i,\n\t\t\t\teventPath = [ elem || document ],\n\t\t\t\ttype = hasOwn.call( event, \"type\" ) ? event.type : event,\n\t\t\t\tnamespaces = hasOwn.call( event, \"namespace\" ) ? event.namespace.split( \".\" ) : [];\n\n\t\t\tcur = tmp = elem = elem || document;\n\n\t\t\t// Don't do events on text and comment nodes\n\t\t\tif ( elem.nodeType === 3 || elem.nodeType === 8 ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// focus/blur morphs to focusin/out; ensure we're not firing them right now\n\t\t\tif ( rfocusMorph.test( type + jQuery.event.triggered ) ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tif ( type.indexOf( \".\" ) > -1 ) {\n\n\t\t\t\t// Namespaced trigger; create a regexp to match event type in handle()\n\t\t\t\tnamespaces = type.split( \".\" );\n\t\t\t\ttype = namespaces.shift();\n\t\t\t\tnamespaces.sort();\n\t\t\t}\n\t\t\tontype = type.indexOf( \":\" ) < 0 && \"on\" + type;\n\n\t\t\t// Caller can pass in a jQuery.Event object, Object, or just an event type string\n\t\t\tevent = event[ jQuery.expando ] ?\n\t\t\t\tevent :\n\t\t\t\tnew jQuery.Event( type, typeof event === \"object\" && event );\n\n\t\t\t// Trigger bitmask: & 1 for native handlers; & 2 for jQuery (always true)\n\t\t\tevent.isTrigger = onlyHandlers ? 2 : 3;\n\t\t\tevent.namespace = namespaces.join( \".\" );\n\t\t\tevent.rnamespace = event.namespace ?\n\t\t\t\tnew RegExp( \"(^|\\\\.)\" + namespaces.join( \"\\\\.(?:.*\\\\.|)\" ) + \"(\\\\.|$)\" ) :\n\t\t\t\tnull;\n\n\t\t\t// Clean up the event in case it is being reused\n\t\t\tevent.result = undefined;\n\t\t\tif ( !event.target ) {\n\t\t\t\tevent.target = elem;\n\t\t\t}\n\n\t\t\t// Clone any incoming data and prepend the event, creating the handler arg list\n\t\t\tdata = data == null ?\n\t\t\t\t[ event ] :\n\t\t\t\tjQuery.makeArray( data, [ event ] );\n\n\t\t\t// Allow special events to draw outside the lines\n\t\t\tspecial = jQuery.event.special[ type ] || {};\n\t\t\tif ( !onlyHandlers && special.trigger && special.trigger.apply( elem, data ) === false ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Determine event propagation path in advance, per W3C events spec (#9951)\n\t\t\t// Bubble up to document, then to window; watch for a global ownerDocument var (#9724)\n\t\t\tif ( !onlyHandlers && !special.noBubble && !jQuery.isWindow( elem ) ) {\n\n\t\t\t\tbubbleType = special.delegateType || type;\n\t\t\t\tif ( !rfocusMorph.test( bubbleType + type ) ) {\n\t\t\t\t\tcur = cur.parentNode;\n\t\t\t\t}\n\t\t\t\tfor ( ; cur; cur = cur.parentNode ) {\n\t\t\t\t\teventPath.push( cur );\n\t\t\t\t\ttmp = cur;\n\t\t\t\t}\n\n\t\t\t\t// Only add window if we got to document (e.g., not plain obj or detached DOM)\n\t\t\t\tif ( tmp === ( elem.ownerDocument || document ) ) {\n\t\t\t\t\teventPath.push( tmp.defaultView || tmp.parentWindow || window );\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Fire handlers on the event path\n\t\t\ti = 0;\n\t\t\twhile ( ( cur = eventPath[ i++ ] ) && !event.isPropagationStopped() ) {\n\n\t\t\t\tevent.type = i > 1 ?\n\t\t\t\t\tbubbleType :\n\t\t\t\tspecial.bindType || type;\n\n\t\t\t\t// jQuery handler\n\t\t\t\thandle = ( jQuery._data( cur, \"events\" ) || {} )[ event.type ] &&\n\t\t\t\t\tjQuery._data( cur, \"handle\" );\n\n\t\t\t\tif ( handle ) {\n\t\t\t\t\thandle.apply( cur, data );\n\t\t\t\t}\n\n\t\t\t\t// Native handler\n\t\t\t\thandle = ontype && cur[ ontype ];\n\t\t\t\tif ( handle && handle.apply && acceptData( cur ) ) {\n\t\t\t\t\tevent.result = handle.apply( cur, data );\n\t\t\t\t\tif ( event.result === false ) {\n\t\t\t\t\t\tevent.preventDefault();\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t\tevent.type = type;\n\n\t\t\t// If nobody prevented the default action, do it now\n\t\t\tif ( !onlyHandlers && !event.isDefaultPrevented() ) {\n\n\t\t\t\tif (\n\t\t\t\t\t( !special._default ||\n\t\t\t\t\t\tspecial._default.apply( eventPath.pop(), data ) === false\n\t\t\t\t\t) && acceptData( elem )\n\t\t\t\t) {\n\n\t\t\t\t\t// Call a native DOM method on the target with the same name name as the event.\n\t\t\t\t\t// Can't use an .isFunction() check here because IE6/7 fails that test.\n\t\t\t\t\t// Don't do default actions on window, that's where global variables be (#6170)\n\t\t\t\t\tif ( ontype && elem[ type ] && !jQuery.isWindow( elem ) ) {\n\n\t\t\t\t\t\t// Don't re-trigger an onFOO event when we call its FOO() method\n\t\t\t\t\t\ttmp = elem[ ontype ];\n\n\t\t\t\t\t\tif ( tmp ) {\n\t\t\t\t\t\t\telem[ ontype ] = null;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Prevent re-triggering of the same event, since we already bubbled it above\n\t\t\t\t\t\tjQuery.event.triggered = type;\n\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\telem[ type ]();\n\t\t\t\t\t\t} catch ( e ) {\n\n\t\t\t\t\t\t\t// IE<9 dies on focus/blur to hidden element (#1486,#12518)\n\t\t\t\t\t\t\t// only reproducible on winXP IE8 native, not IE9 in IE8 mode\n\t\t\t\t\t\t}\n\t\t\t\t\t\tjQuery.event.triggered = undefined;\n\n\t\t\t\t\t\tif ( tmp ) {\n\t\t\t\t\t\t\telem[ ontype ] = tmp;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn event.result;\n\t\t},\n\n\t\tdispatch: function( event ) {\n\n\t\t\t// Make a writable jQuery.Event from the native event object\n\t\t\tevent = jQuery.event.fix( event );\n\n\t\t\tvar i, j, ret, matched, handleObj,\n\t\t\t\thandlerQueue = [],\n\t\t\t\targs = slice.call( arguments ),\n\t\t\t\thandlers = ( jQuery._data( this, \"events\" ) || {} )[ event.type ] || [],\n\t\t\t\tspecial = jQuery.event.special[ event.type ] || {};\n\n\t\t\t// Use the fix-ed jQuery.Event rather than the (read-only) native event\n\t\t\targs[ 0 ] = event;\n\t\t\tevent.delegateTarget = this;\n\n\t\t\t// Call the preDispatch hook for the mapped type, and let it bail if desired\n\t\t\tif ( special.preDispatch && special.preDispatch.call( this, event ) === false ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Determine handlers\n\t\t\thandlerQueue = jQuery.event.handlers.call( this, event, handlers );\n\n\t\t\t// Run delegates first; they may want to stop propagation beneath us\n\t\t\ti = 0;\n\t\t\twhile ( ( matched = handlerQueue[ i++ ] ) && !event.isPropagationStopped() ) {\n\t\t\t\tevent.currentTarget = matched.elem;\n\n\t\t\t\tj = 0;\n\t\t\t\twhile ( ( handleObj = matched.handlers[ j++ ] ) &&\n\t\t\t\t!event.isImmediatePropagationStopped() ) {\n\n\t\t\t\t\t// Triggered event must either 1) have no namespace, or 2) have namespace(s)\n\t\t\t\t\t// a subset or equal to those in the bound event (both can have no namespace).\n\t\t\t\t\tif ( !event.rnamespace || event.rnamespace.test( handleObj.namespace ) ) {\n\n\t\t\t\t\t\tevent.handleObj = handleObj;\n\t\t\t\t\t\tevent.data = handleObj.data;\n\n\t\t\t\t\t\tret = ( ( jQuery.event.special[ handleObj.origType ] || {} ).handle ||\n\t\t\t\t\t\thandleObj.handler ).apply( matched.elem, args );\n\n\t\t\t\t\t\tif ( ret !== undefined ) {\n\t\t\t\t\t\t\tif ( ( event.result = ret ) === false ) {\n\t\t\t\t\t\t\t\tevent.preventDefault();\n\t\t\t\t\t\t\t\tevent.stopPropagation();\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Call the postDispatch hook for the mapped type\n\t\t\tif ( special.postDispatch ) {\n\t\t\t\tspecial.postDispatch.call( this, event );\n\t\t\t}\n\n\t\t\treturn event.result;\n\t\t},\n\n\t\thandlers: function( event, handlers ) {\n\t\t\tvar i, matches, sel, handleObj,\n\t\t\t\thandlerQueue = [],\n\t\t\t\tdelegateCount = handlers.delegateCount,\n\t\t\t\tcur = event.target;\n\n\t\t\t// Support (at least): Chrome, IE9\n\t\t\t// Find delegate handlers\n\t\t\t// Black-hole SVG <use> instance trees (#13180)\n\t\t\t//\n\t\t\t// Support: Firefox<=42+\n\t\t\t// Avoid non-left-click in FF but don't block IE radio events (#3861, gh-2343)\n\t\t\tif ( delegateCount && cur.nodeType &&\n\t\t\t\t( event.type !== \"click\" || isNaN( event.button ) || event.button < 1 ) ) {\n\n\t\t\t\t/* jshint eqeqeq: false */\n\t\t\t\tfor ( ; cur != this; cur = cur.parentNode || this ) {\n\t\t\t\t\t/* jshint eqeqeq: true */\n\n\t\t\t\t\t// Don't check non-elements (#13208)\n\t\t\t\t\t// Don't process clicks on disabled elements (#6911, #8165, #11382, #11764)\n\t\t\t\t\tif ( cur.nodeType === 1 && ( cur.disabled !== true || event.type !== \"click\" ) ) {\n\t\t\t\t\t\tmatches = [];\n\t\t\t\t\t\tfor ( i = 0; i < delegateCount; i++ ) {\n\t\t\t\t\t\t\thandleObj = handlers[ i ];\n\n\t\t\t\t\t\t\t// Don't conflict with Object.prototype properties (#13203)\n\t\t\t\t\t\t\tsel = handleObj.selector + \" \";\n\n\t\t\t\t\t\t\tif ( matches[ sel ] === undefined ) {\n\t\t\t\t\t\t\t\tmatches[ sel ] = handleObj.needsContext ?\n\t\t\t\t\t\t\t\tjQuery( sel, this ).index( cur ) > -1 :\n\t\t\t\t\t\t\t\t\tjQuery.find( sel, this, null, [ cur ] ).length;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tif ( matches[ sel ] ) {\n\t\t\t\t\t\t\t\tmatches.push( handleObj );\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif ( matches.length ) {\n\t\t\t\t\t\t\thandlerQueue.push( { elem: cur, handlers: matches } );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Add the remaining (directly-bound) handlers\n\t\t\tif ( delegateCount < handlers.length ) {\n\t\t\t\thandlerQueue.push( { elem: this, handlers: handlers.slice( delegateCount ) } );\n\t\t\t}\n\n\t\t\treturn handlerQueue;\n\t\t},\n\n\t\tfix: function( event ) {\n\t\t\tif ( event[ jQuery.expando ] ) {\n\t\t\t\treturn event;\n\t\t\t}\n\n\t\t\t// Create a writable copy of the event object and normalize some properties\n\t\t\tvar i, prop, copy,\n\t\t\t\ttype = event.type,\n\t\t\t\toriginalEvent = event,\n\t\t\t\tfixHook = this.fixHooks[ type ];\n\n\t\t\tif ( !fixHook ) {\n\t\t\t\tthis.fixHooks[ type ] = fixHook =\n\t\t\t\t\trmouseEvent.test( type ) ? this.mouseHooks :\n\t\t\t\t\t\trkeyEvent.test( type ) ? this.keyHooks :\n\t\t\t\t\t\t{};\n\t\t\t}\n\t\t\tcopy = fixHook.props ? this.props.concat( fixHook.props ) : this.props;\n\n\t\t\tevent = new jQuery.Event( originalEvent );\n\n\t\t\ti = copy.length;\n\t\t\twhile ( i-- ) {\n\t\t\t\tprop = copy[ i ];\n\t\t\t\tevent[ prop ] = originalEvent[ prop ];\n\t\t\t}\n\n\t\t\t// Support: IE<9\n\t\t\t// Fix target property (#1925)\n\t\t\tif ( !event.target ) {\n\t\t\t\tevent.target = originalEvent.srcElement || document;\n\t\t\t}\n\n\t\t\t// Support: Safari 6-8+\n\t\t\t// Target should not be a text node (#504, #13143)\n\t\t\tif ( event.target.nodeType === 3 ) {\n\t\t\t\tevent.target = event.target.parentNode;\n\t\t\t}\n\n\t\t\t// Support: IE<9\n\t\t\t// For mouse/key events, metaKey==false if it's undefined (#3368, #11328)\n\t\t\tevent.metaKey = !!event.metaKey;\n\n\t\t\treturn fixHook.filter ? fixHook.filter( event, originalEvent ) : event;\n\t\t},\n\n\t\t// Includes some event props shared by KeyEvent and MouseEvent\n\t\tprops: ( \"altKey bubbles cancelable ctrlKey currentTarget detail eventPhase \" +\n\t\t\"metaKey relatedTarget shiftKey target timeStamp view which\" ).split( \" \" ),\n\n\t\tfixHooks: {},\n\n\t\tkeyHooks: {\n\t\t\tprops: \"char charCode key keyCode\".split( \" \" ),\n\t\t\tfilter: function( event, original ) {\n\n\t\t\t\t// Add which for key events\n\t\t\t\tif ( event.which == null ) {\n\t\t\t\t\tevent.which = original.charCode != null ? original.charCode : original.keyCode;\n\t\t\t\t}\n\n\t\t\t\treturn event;\n\t\t\t}\n\t\t},\n\n\t\tmouseHooks: {\n\t\t\tprops: ( \"button buttons clientX clientY fromElement offsetX offsetY \" +\n\t\t\t\"pageX pageY screenX screenY toElement\" ).split( \" \" ),\n\t\t\tfilter: function( event, original ) {\n\t\t\t\tvar body, eventDoc, doc,\n\t\t\t\t\tbutton = original.button,\n\t\t\t\t\tfromElement = original.fromElement;\n\n\t\t\t\t// Calculate pageX/Y if missing and clientX/Y available\n\t\t\t\tif ( event.pageX == null && original.clientX != null ) {\n\t\t\t\t\teventDoc = event.target.ownerDocument || document;\n\t\t\t\t\tdoc = eventDoc.documentElement;\n\t\t\t\t\tbody = eventDoc.body;\n\n\t\t\t\t\tevent.pageX = original.clientX +\n\t\t\t\t\t\t( doc && doc.scrollLeft || body && body.scrollLeft || 0 ) -\n\t\t\t\t\t\t( doc && doc.clientLeft || body && body.clientLeft || 0 );\n\t\t\t\t\tevent.pageY = original.clientY +\n\t\t\t\t\t\t( doc && doc.scrollTop  || body && body.scrollTop  || 0 ) -\n\t\t\t\t\t\t( doc && doc.clientTop  || body && body.clientTop  || 0 );\n\t\t\t\t}\n\n\t\t\t\t// Add relatedTarget, if necessary\n\t\t\t\tif ( !event.relatedTarget && fromElement ) {\n\t\t\t\t\tevent.relatedTarget = fromElement === event.target ?\n\t\t\t\t\t\toriginal.toElement :\n\t\t\t\t\t\tfromElement;\n\t\t\t\t}\n\n\t\t\t\t// Add which for click: 1 === left; 2 === middle; 3 === right\n\t\t\t\t// Note: button is not normalized, so don't use it\n\t\t\t\tif ( !event.which && button !== undefined ) {\n\t\t\t\t\tevent.which = ( button & 1 ? 1 : ( button & 2 ? 3 : ( button & 4 ? 2 : 0 ) ) );\n\t\t\t\t}\n\n\t\t\t\treturn event;\n\t\t\t}\n\t\t},\n\n\t\tspecial: {\n\t\t\tload: {\n\n\t\t\t\t// Prevent triggered image.load events from bubbling to window.load\n\t\t\t\tnoBubble: true\n\t\t\t},\n\t\t\tfocus: {\n\n\t\t\t\t// Fire native event if possible so blur/focus sequence is correct\n\t\t\t\ttrigger: function() {\n\t\t\t\t\tif ( this !== safeActiveElement() && this.focus ) {\n\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\tthis.focus();\n\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t} catch ( e ) {\n\n\t\t\t\t\t\t\t// Support: IE<9\n\t\t\t\t\t\t\t// If we error on focus to hidden element (#1486, #12518),\n\t\t\t\t\t\t\t// let .trigger() run the handlers\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\tdelegateType: \"focusin\"\n\t\t\t},\n\t\t\tblur: {\n\t\t\t\ttrigger: function() {\n\t\t\t\t\tif ( this === safeActiveElement() && this.blur ) {\n\t\t\t\t\t\tthis.blur();\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\tdelegateType: \"focusout\"\n\t\t\t},\n\t\t\tclick: {\n\n\t\t\t\t// For checkbox, fire native event so checked state will be right\n\t\t\t\ttrigger: function() {\n\t\t\t\t\tif ( jQuery.nodeName( this, \"input\" ) && this.type === \"checkbox\" && this.click ) {\n\t\t\t\t\t\tthis.click();\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t},\n\n\t\t\t\t// For cross-browser consistency, don't fire native .click() on links\n\t\t\t\t_default: function( event ) {\n\t\t\t\t\treturn jQuery.nodeName( event.target, \"a\" );\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tbeforeunload: {\n\t\t\t\tpostDispatch: function( event ) {\n\n\t\t\t\t\t// Support: Firefox 20+\n\t\t\t\t\t// Firefox doesn't alert if the returnValue field is not set.\n\t\t\t\t\tif ( event.result !== undefined && event.originalEvent ) {\n\t\t\t\t\t\tevent.originalEvent.returnValue = event.result;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\t// Piggyback on a donor event to simulate a different one\n\t\tsimulate: function( type, elem, event ) {\n\t\t\tvar e = jQuery.extend(\n\t\t\t\tnew jQuery.Event(),\n\t\t\t\tevent,\n\t\t\t\t{\n\t\t\t\t\ttype: type,\n\t\t\t\t\tisSimulated: true\n\n\t\t\t\t\t// Previously, `originalEvent: {}` was set here, so stopPropagation call\n\t\t\t\t\t// would not be triggered on donor event, since in our own\n\t\t\t\t\t// jQuery.event.stopPropagation function we had a check for existence of\n\t\t\t\t\t// originalEvent.stopPropagation method, so, consequently it would be a noop.\n\t\t\t\t\t//\n\t\t\t\t\t// Guard for simulated events was moved to jQuery.event.stopPropagation function\n\t\t\t\t\t// since `originalEvent` should point to the original event for the\n\t\t\t\t\t// constancy with other events and for more focused logic\n\t\t\t\t}\n\t\t\t);\n\n\t\t\tjQuery.event.trigger( e, null, elem );\n\n\t\t\tif ( e.isDefaultPrevented() ) {\n\t\t\t\tevent.preventDefault();\n\t\t\t}\n\t\t}\n\t};\n\n\tjQuery.removeEvent = document.removeEventListener ?\n\t\tfunction( elem, type, handle ) {\n\n\t\t\t// This \"if\" is needed for plain objects\n\t\t\tif ( elem.removeEventListener ) {\n\t\t\t\telem.removeEventListener( type, handle );\n\t\t\t}\n\t\t} :\n\t\tfunction( elem, type, handle ) {\n\t\t\tvar name = \"on\" + type;\n\n\t\t\tif ( elem.detachEvent ) {\n\n\t\t\t\t// #8545, #7054, preventing memory leaks for custom events in IE6-8\n\t\t\t\t// detachEvent needed property on element, by name of that event,\n\t\t\t\t// to properly expose it to GC\n\t\t\t\tif ( typeof elem[ name ] === \"undefined\" ) {\n\t\t\t\t\telem[ name ] = null;\n\t\t\t\t}\n\n\t\t\t\telem.detachEvent( name, handle );\n\t\t\t}\n\t\t};\n\n\tjQuery.Event = function( src, props ) {\n\n\t\t// Allow instantiation without the 'new' keyword\n\t\tif ( !( this instanceof jQuery.Event ) ) {\n\t\t\treturn new jQuery.Event( src, props );\n\t\t}\n\n\t\t// Event object\n\t\tif ( src && src.type ) {\n\t\t\tthis.originalEvent = src;\n\t\t\tthis.type = src.type;\n\n\t\t\t// Events bubbling up the document may have been marked as prevented\n\t\t\t// by a handler lower down the tree; reflect the correct value.\n\t\t\tthis.isDefaultPrevented = src.defaultPrevented ||\n\t\t\tsrc.defaultPrevented === undefined &&\n\n\t\t\t// Support: IE < 9, Android < 4.0\n\t\t\tsrc.returnValue === false ?\n\t\t\t\treturnTrue :\n\t\t\t\treturnFalse;\n\n\t\t\t// Event type\n\t\t} else {\n\t\t\tthis.type = src;\n\t\t}\n\n\t\t// Put explicitly provided properties onto the event object\n\t\tif ( props ) {\n\t\t\tjQuery.extend( this, props );\n\t\t}\n\n\t\t// Create a timestamp if incoming event doesn't have one\n\t\tthis.timeStamp = src && src.timeStamp || jQuery.now();\n\n\t\t// Mark it as fixed\n\t\tthis[ jQuery.expando ] = true;\n\t};\n\n// jQuery.Event is based on DOM3 Events as specified by the ECMAScript Language Binding\n// http://www.w3.org/TR/2003/WD-DOM-Level-3-Events-20030331/ecma-script-binding.html\n\tjQuery.Event.prototype = {\n\t\tconstructor: jQuery.Event,\n\t\tisDefaultPrevented: returnFalse,\n\t\tisPropagationStopped: returnFalse,\n\t\tisImmediatePropagationStopped: returnFalse,\n\n\t\tpreventDefault: function() {\n\t\t\tvar e = this.originalEvent;\n\n\t\t\tthis.isDefaultPrevented = returnTrue;\n\t\t\tif ( !e ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// If preventDefault exists, run it on the original event\n\t\t\tif ( e.preventDefault ) {\n\t\t\t\te.preventDefault();\n\n\t\t\t\t// Support: IE\n\t\t\t\t// Otherwise set the returnValue property of the original event to false\n\t\t\t} else {\n\t\t\t\te.returnValue = false;\n\t\t\t}\n\t\t},\n\t\tstopPropagation: function() {\n\t\t\tvar e = this.originalEvent;\n\n\t\t\tthis.isPropagationStopped = returnTrue;\n\n\t\t\tif ( !e || this.isSimulated ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// If stopPropagation exists, run it on the original event\n\t\t\tif ( e.stopPropagation ) {\n\t\t\t\te.stopPropagation();\n\t\t\t}\n\n\t\t\t// Support: IE\n\t\t\t// Set the cancelBubble property of the original event to true\n\t\t\te.cancelBubble = true;\n\t\t},\n\t\tstopImmediatePropagation: function() {\n\t\t\tvar e = this.originalEvent;\n\n\t\t\tthis.isImmediatePropagationStopped = returnTrue;\n\n\t\t\tif ( e && e.stopImmediatePropagation ) {\n\t\t\t\te.stopImmediatePropagation();\n\t\t\t}\n\n\t\t\tthis.stopPropagation();\n\t\t}\n\t};\n\n// Create mouseenter/leave events using mouseover/out and event-time checks\n// so that event delegation works in jQuery.\n// Do the same for pointerenter/pointerleave and pointerover/pointerout\n//\n// Support: Safari 7 only\n// Safari sends mouseenter too often; see:\n// https://code.google.com/p/chromium/issues/detail?id=470258\n// for the description of the bug (it existed in older Chrome versions as well).\n\tjQuery.each( {\n\t\tmouseenter: \"mouseover\",\n\t\tmouseleave: \"mouseout\",\n\t\tpointerenter: \"pointerover\",\n\t\tpointerleave: \"pointerout\"\n\t}, function( orig, fix ) {\n\t\tjQuery.event.special[ orig ] = {\n\t\t\tdelegateType: fix,\n\t\t\tbindType: fix,\n\n\t\t\thandle: function( event ) {\n\t\t\t\tvar ret,\n\t\t\t\t\ttarget = this,\n\t\t\t\t\trelated = event.relatedTarget,\n\t\t\t\t\thandleObj = event.handleObj;\n\n\t\t\t\t// For mouseenter/leave call the handler if related is outside the target.\n\t\t\t\t// NB: No relatedTarget if the mouse left/entered the browser window\n\t\t\t\tif ( !related || ( related !== target && !jQuery.contains( target, related ) ) ) {\n\t\t\t\t\tevent.type = handleObj.origType;\n\t\t\t\t\tret = handleObj.handler.apply( this, arguments );\n\t\t\t\t\tevent.type = fix;\n\t\t\t\t}\n\t\t\t\treturn ret;\n\t\t\t}\n\t\t};\n\t} );\n\n// IE submit delegation\n\tif ( !support.submit ) {\n\n\t\tjQuery.event.special.submit = {\n\t\t\tsetup: function() {\n\n\t\t\t\t// Only need this for delegated form submit events\n\t\t\t\tif ( jQuery.nodeName( this, \"form\" ) ) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\n\t\t\t\t// Lazy-add a submit handler when a descendant form may potentially be submitted\n\t\t\t\tjQuery.event.add( this, \"click._submit keypress._submit\", function( e ) {\n\n\t\t\t\t\t// Node name check avoids a VML-related crash in IE (#9807)\n\t\t\t\t\tvar elem = e.target,\n\t\t\t\t\t\tform = jQuery.nodeName( elem, \"input\" ) || jQuery.nodeName( elem, \"button\" ) ?\n\n\t\t\t\t\t\t\t// Support: IE <=8\n\t\t\t\t\t\t\t// We use jQuery.prop instead of elem.form\n\t\t\t\t\t\t\t// to allow fixing the IE8 delegated submit issue (gh-2332)\n\t\t\t\t\t\t\t// by 3rd party polyfills/workarounds.\n\t\t\t\t\t\t\tjQuery.prop( elem, \"form\" ) :\n\t\t\t\t\t\t\tundefined;\n\n\t\t\t\t\tif ( form && !jQuery._data( form, \"submit\" ) ) {\n\t\t\t\t\t\tjQuery.event.add( form, \"submit._submit\", function( event ) {\n\t\t\t\t\t\t\tevent._submitBubble = true;\n\t\t\t\t\t\t} );\n\t\t\t\t\t\tjQuery._data( form, \"submit\", true );\n\t\t\t\t\t}\n\t\t\t\t} );\n\n\t\t\t\t// return undefined since we don't need an event listener\n\t\t\t},\n\n\t\t\tpostDispatch: function( event ) {\n\n\t\t\t\t// If form was submitted by the user, bubble the event up the tree\n\t\t\t\tif ( event._submitBubble ) {\n\t\t\t\t\tdelete event._submitBubble;\n\t\t\t\t\tif ( this.parentNode && !event.isTrigger ) {\n\t\t\t\t\t\tjQuery.event.simulate( \"submit\", this.parentNode, event );\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tteardown: function() {\n\n\t\t\t\t// Only need this for delegated form submit events\n\t\t\t\tif ( jQuery.nodeName( this, \"form\" ) ) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\n\t\t\t\t// Remove delegated handlers; cleanData eventually reaps submit handlers attached above\n\t\t\t\tjQuery.event.remove( this, \"._submit\" );\n\t\t\t}\n\t\t};\n\t}\n\n// IE change delegation and checkbox/radio fix\n\tif ( !support.change ) {\n\n\t\tjQuery.event.special.change = {\n\n\t\t\tsetup: function() {\n\n\t\t\t\tif ( rformElems.test( this.nodeName ) ) {\n\n\t\t\t\t\t// IE doesn't fire change on a check/radio until blur; trigger it on click\n\t\t\t\t\t// after a propertychange. Eat the blur-change in special.change.handle.\n\t\t\t\t\t// This still fires onchange a second time for check/radio after blur.\n\t\t\t\t\tif ( this.type === \"checkbox\" || this.type === \"radio\" ) {\n\t\t\t\t\t\tjQuery.event.add( this, \"propertychange._change\", function( event ) {\n\t\t\t\t\t\t\tif ( event.originalEvent.propertyName === \"checked\" ) {\n\t\t\t\t\t\t\t\tthis._justChanged = true;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t} );\n\t\t\t\t\t\tjQuery.event.add( this, \"click._change\", function( event ) {\n\t\t\t\t\t\t\tif ( this._justChanged && !event.isTrigger ) {\n\t\t\t\t\t\t\t\tthis._justChanged = false;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// Allow triggered, simulated change events (#11500)\n\t\t\t\t\t\t\tjQuery.event.simulate( \"change\", this, event );\n\t\t\t\t\t\t} );\n\t\t\t\t\t}\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\n\t\t\t\t// Delegated event; lazy-add a change handler on descendant inputs\n\t\t\t\tjQuery.event.add( this, \"beforeactivate._change\", function( e ) {\n\t\t\t\t\tvar elem = e.target;\n\n\t\t\t\t\tif ( rformElems.test( elem.nodeName ) && !jQuery._data( elem, \"change\" ) ) {\n\t\t\t\t\t\tjQuery.event.add( elem, \"change._change\", function( event ) {\n\t\t\t\t\t\t\tif ( this.parentNode && !event.isSimulated && !event.isTrigger ) {\n\t\t\t\t\t\t\t\tjQuery.event.simulate( \"change\", this.parentNode, event );\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t} );\n\t\t\t\t\t\tjQuery._data( elem, \"change\", true );\n\t\t\t\t\t}\n\t\t\t\t} );\n\t\t\t},\n\n\t\t\thandle: function( event ) {\n\t\t\t\tvar elem = event.target;\n\n\t\t\t\t// Swallow native change events from checkbox/radio, we already triggered them above\n\t\t\t\tif ( this !== elem || event.isSimulated || event.isTrigger ||\n\t\t\t\t\t( elem.type !== \"radio\" && elem.type !== \"checkbox\" ) ) {\n\n\t\t\t\t\treturn event.handleObj.handler.apply( this, arguments );\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tteardown: function() {\n\t\t\t\tjQuery.event.remove( this, \"._change\" );\n\n\t\t\t\treturn !rformElems.test( this.nodeName );\n\t\t\t}\n\t\t};\n\t}\n\n// Support: Firefox\n// Firefox doesn't have focus(in | out) events\n// Related ticket - https://bugzilla.mozilla.org/show_bug.cgi?id=687787\n//\n// Support: Chrome, Safari\n// focus(in | out) events fire after focus & blur events,\n// which is spec violation - http://www.w3.org/TR/DOM-Level-3-Events/#events-focusevent-event-order\n// Related ticket - https://code.google.com/p/chromium/issues/detail?id=449857\n\tif ( !support.focusin ) {\n\t\tjQuery.each( { focus: \"focusin\", blur: \"focusout\" }, function( orig, fix ) {\n\n\t\t\t// Attach a single capturing handler on the document while someone wants focusin/focusout\n\t\t\tvar handler = function( event ) {\n\t\t\t\tjQuery.event.simulate( fix, event.target, jQuery.event.fix( event ) );\n\t\t\t};\n\n\t\t\tjQuery.event.special[ fix ] = {\n\t\t\t\tsetup: function() {\n\t\t\t\t\tvar doc = this.ownerDocument || this,\n\t\t\t\t\t\tattaches = jQuery._data( doc, fix );\n\n\t\t\t\t\tif ( !attaches ) {\n\t\t\t\t\t\tdoc.addEventListener( orig, handler, true );\n\t\t\t\t\t}\n\t\t\t\t\tjQuery._data( doc, fix, ( attaches || 0 ) + 1 );\n\t\t\t\t},\n\t\t\t\tteardown: function() {\n\t\t\t\t\tvar doc = this.ownerDocument || this,\n\t\t\t\t\t\tattaches = jQuery._data( doc, fix ) - 1;\n\n\t\t\t\t\tif ( !attaches ) {\n\t\t\t\t\t\tdoc.removeEventListener( orig, handler, true );\n\t\t\t\t\t\tjQuery._removeData( doc, fix );\n\t\t\t\t\t} else {\n\t\t\t\t\t\tjQuery._data( doc, fix, attaches );\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t};\n\t\t} );\n\t}\n\n\tjQuery.fn.extend( {\n\n\t\ton: function( types, selector, data, fn ) {\n\t\t\treturn on( this, types, selector, data, fn );\n\t\t},\n\t\tone: function( types, selector, data, fn ) {\n\t\t\treturn on( this, types, selector, data, fn, 1 );\n\t\t},\n\t\toff: function( types, selector, fn ) {\n\t\t\tvar handleObj, type;\n\t\t\tif ( types && types.preventDefault && types.handleObj ) {\n\n\t\t\t\t// ( event )  dispatched jQuery.Event\n\t\t\t\thandleObj = types.handleObj;\n\t\t\t\tjQuery( types.delegateTarget ).off(\n\t\t\t\t\thandleObj.namespace ?\n\t\t\t\t\thandleObj.origType + \".\" + handleObj.namespace :\n\t\t\t\t\t\thandleObj.origType,\n\t\t\t\t\thandleObj.selector,\n\t\t\t\t\thandleObj.handler\n\t\t\t\t);\n\t\t\t\treturn this;\n\t\t\t}\n\t\t\tif ( typeof types === \"object\" ) {\n\n\t\t\t\t// ( types-object [, selector] )\n\t\t\t\tfor ( type in types ) {\n\t\t\t\t\tthis.off( type, selector, types[ type ] );\n\t\t\t\t}\n\t\t\t\treturn this;\n\t\t\t}\n\t\t\tif ( selector === false || typeof selector === \"function\" ) {\n\n\t\t\t\t// ( types [, fn] )\n\t\t\t\tfn = selector;\n\t\t\t\tselector = undefined;\n\t\t\t}\n\t\t\tif ( fn === false ) {\n\t\t\t\tfn = returnFalse;\n\t\t\t}\n\t\t\treturn this.each( function() {\n\t\t\t\tjQuery.event.remove( this, types, fn, selector );\n\t\t\t} );\n\t\t},\n\n\t\ttrigger: function( type, data ) {\n\t\t\treturn this.each( function() {\n\t\t\t\tjQuery.event.trigger( type, data, this );\n\t\t\t} );\n\t\t},\n\t\ttriggerHandler: function( type, data ) {\n\t\t\tvar elem = this[ 0 ];\n\t\t\tif ( elem ) {\n\t\t\t\treturn jQuery.event.trigger( type, data, elem, true );\n\t\t\t}\n\t\t}\n\t} );\n\n\n\tvar rinlinejQuery = / jQuery\\d+=\"(?:null|\\d+)\"/g,\n\t\trnoshimcache = new RegExp( \"<(?:\" + nodeNames + \")[\\\\s/>]\", \"i\" ),\n\t\trxhtmlTag = /<(?!area|br|col|embed|hr|img|input|link|meta|param)(([\\w:-]+)[^>]*)\\/>/gi,\n\n\t\t// Support: IE 10-11, Edge 10240+\n\t\t// In IE/Edge using regex groups here causes severe slowdowns.\n\t\t// See https://connect.microsoft.com/IE/feedback/details/1736512/\n\t\trnoInnerhtml = /<script|<style|<link/i,\n\n\t\t// checked=\"checked\" or checked\n\t\trchecked = /checked\\s*(?:[^=]|=\\s*.checked.)/i,\n\t\trscriptTypeMasked = /^true\\/(.*)/,\n\t\trcleanScript = /^\\s*<!(?:\\[CDATA\\[|--)|(?:\\]\\]|--)>\\s*$/g,\n\t\tsafeFragment = createSafeFragment( document ),\n\t\tfragmentDiv = safeFragment.appendChild( document.createElement( \"div\" ) );\n\n// Support: IE<8\n// Manipulating tables requires a tbody\n\tfunction manipulationTarget( elem, content ) {\n\t\treturn jQuery.nodeName( elem, \"table\" ) &&\n\t\tjQuery.nodeName( content.nodeType !== 11 ? content : content.firstChild, \"tr\" ) ?\n\n\t\telem.getElementsByTagName( \"tbody\" )[ 0 ] ||\n\t\telem.appendChild( elem.ownerDocument.createElement( \"tbody\" ) ) :\n\t\t\telem;\n\t}\n\n// Replace/restore the type attribute of script elements for safe DOM manipulation\n\tfunction disableScript( elem ) {\n\t\telem.type = ( jQuery.find.attr( elem, \"type\" ) !== null ) + \"/\" + elem.type;\n\t\treturn elem;\n\t}\n\tfunction restoreScript( elem ) {\n\t\tvar match = rscriptTypeMasked.exec( elem.type );\n\t\tif ( match ) {\n\t\t\telem.type = match[ 1 ];\n\t\t} else {\n\t\t\telem.removeAttribute( \"type\" );\n\t\t}\n\t\treturn elem;\n\t}\n\n\tfunction cloneCopyEvent( src, dest ) {\n\t\tif ( dest.nodeType !== 1 || !jQuery.hasData( src ) ) {\n\t\t\treturn;\n\t\t}\n\n\t\tvar type, i, l,\n\t\t\toldData = jQuery._data( src ),\n\t\t\tcurData = jQuery._data( dest, oldData ),\n\t\t\tevents = oldData.events;\n\n\t\tif ( events ) {\n\t\t\tdelete curData.handle;\n\t\t\tcurData.events = {};\n\n\t\t\tfor ( type in events ) {\n\t\t\t\tfor ( i = 0, l = events[ type ].length; i < l; i++ ) {\n\t\t\t\t\tjQuery.event.add( dest, type, events[ type ][ i ] );\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\t// make the cloned public data object a copy from the original\n\t\tif ( curData.data ) {\n\t\t\tcurData.data = jQuery.extend( {}, curData.data );\n\t\t}\n\t}\n\n\tfunction fixCloneNodeIssues( src, dest ) {\n\t\tvar nodeName, e, data;\n\n\t\t// We do not need to do anything for non-Elements\n\t\tif ( dest.nodeType !== 1 ) {\n\t\t\treturn;\n\t\t}\n\n\t\tnodeName = dest.nodeName.toLowerCase();\n\n\t\t// IE6-8 copies events bound via attachEvent when using cloneNode.\n\t\tif ( !support.noCloneEvent && dest[ jQuery.expando ] ) {\n\t\t\tdata = jQuery._data( dest );\n\n\t\t\tfor ( e in data.events ) {\n\t\t\t\tjQuery.removeEvent( dest, e, data.handle );\n\t\t\t}\n\n\t\t\t// Event data gets referenced instead of copied if the expando gets copied too\n\t\t\tdest.removeAttribute( jQuery.expando );\n\t\t}\n\n\t\t// IE blanks contents when cloning scripts, and tries to evaluate newly-set text\n\t\tif ( nodeName === \"script\" && dest.text !== src.text ) {\n\t\t\tdisableScript( dest ).text = src.text;\n\t\t\trestoreScript( dest );\n\n\t\t\t// IE6-10 improperly clones children of object elements using classid.\n\t\t\t// IE10 throws NoModificationAllowedError if parent is null, #12132.\n\t\t} else if ( nodeName === \"object\" ) {\n\t\t\tif ( dest.parentNode ) {\n\t\t\t\tdest.outerHTML = src.outerHTML;\n\t\t\t}\n\n\t\t\t// This path appears unavoidable for IE9. When cloning an object\n\t\t\t// element in IE9, the outerHTML strategy above is not sufficient.\n\t\t\t// If the src has innerHTML and the destination does not,\n\t\t\t// copy the src.innerHTML into the dest.innerHTML. #10324\n\t\t\tif ( support.html5Clone && ( src.innerHTML && !jQuery.trim( dest.innerHTML ) ) ) {\n\t\t\t\tdest.innerHTML = src.innerHTML;\n\t\t\t}\n\n\t\t} else if ( nodeName === \"input\" && rcheckableType.test( src.type ) ) {\n\n\t\t\t// IE6-8 fails to persist the checked state of a cloned checkbox\n\t\t\t// or radio button. Worse, IE6-7 fail to give the cloned element\n\t\t\t// a checked appearance if the defaultChecked value isn't also set\n\n\t\t\tdest.defaultChecked = dest.checked = src.checked;\n\n\t\t\t// IE6-7 get confused and end up setting the value of a cloned\n\t\t\t// checkbox/radio button to an empty string instead of \"on\"\n\t\t\tif ( dest.value !== src.value ) {\n\t\t\t\tdest.value = src.value;\n\t\t\t}\n\n\t\t\t// IE6-8 fails to return the selected option to the default selected\n\t\t\t// state when cloning options\n\t\t} else if ( nodeName === \"option\" ) {\n\t\t\tdest.defaultSelected = dest.selected = src.defaultSelected;\n\n\t\t\t// IE6-8 fails to set the defaultValue to the correct value when\n\t\t\t// cloning other types of input fields\n\t\t} else if ( nodeName === \"input\" || nodeName === \"textarea\" ) {\n\t\t\tdest.defaultValue = src.defaultValue;\n\t\t}\n\t}\n\n\tfunction domManip( collection, args, callback, ignored ) {\n\n\t\t// Flatten any nested arrays\n\t\targs = concat.apply( [], args );\n\n\t\tvar first, node, hasScripts,\n\t\t\tscripts, doc, fragment,\n\t\t\ti = 0,\n\t\t\tl = collection.length,\n\t\t\tiNoClone = l - 1,\n\t\t\tvalue = args[ 0 ],\n\t\t\tisFunction = jQuery.isFunction( value );\n\n\t\t// We can't cloneNode fragments that contain checked, in WebKit\n\t\tif ( isFunction ||\n\t\t\t( l > 1 && typeof value === \"string\" &&\n\t\t\t!support.checkClone && rchecked.test( value ) ) ) {\n\t\t\treturn collection.each( function( index ) {\n\t\t\t\tvar self = collection.eq( index );\n\t\t\t\tif ( isFunction ) {\n\t\t\t\t\targs[ 0 ] = value.call( this, index, self.html() );\n\t\t\t\t}\n\t\t\t\tdomManip( self, args, callback, ignored );\n\t\t\t} );\n\t\t}\n\n\t\tif ( l ) {\n\t\t\tfragment = buildFragment( args, collection[ 0 ].ownerDocument, false, collection, ignored );\n\t\t\tfirst = fragment.firstChild;\n\n\t\t\tif ( fragment.childNodes.length === 1 ) {\n\t\t\t\tfragment = first;\n\t\t\t}\n\n\t\t\t// Require either new content or an interest in ignored elements to invoke the callback\n\t\t\tif ( first || ignored ) {\n\t\t\t\tscripts = jQuery.map( getAll( fragment, \"script\" ), disableScript );\n\t\t\t\thasScripts = scripts.length;\n\n\t\t\t\t// Use the original fragment for the last item\n\t\t\t\t// instead of the first because it can end up\n\t\t\t\t// being emptied incorrectly in certain situations (#8070).\n\t\t\t\tfor ( ; i < l; i++ ) {\n\t\t\t\t\tnode = fragment;\n\n\t\t\t\t\tif ( i !== iNoClone ) {\n\t\t\t\t\t\tnode = jQuery.clone( node, true, true );\n\n\t\t\t\t\t\t// Keep references to cloned scripts for later restoration\n\t\t\t\t\t\tif ( hasScripts ) {\n\n\t\t\t\t\t\t\t// Support: Android<4.1, PhantomJS<2\n\t\t\t\t\t\t\t// push.apply(_, arraylike) throws on ancient WebKit\n\t\t\t\t\t\t\tjQuery.merge( scripts, getAll( node, \"script\" ) );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\tcallback.call( collection[ i ], node, i );\n\t\t\t\t}\n\n\t\t\t\tif ( hasScripts ) {\n\t\t\t\t\tdoc = scripts[ scripts.length - 1 ].ownerDocument;\n\n\t\t\t\t\t// Reenable scripts\n\t\t\t\t\tjQuery.map( scripts, restoreScript );\n\n\t\t\t\t\t// Evaluate executable scripts on first document insertion\n\t\t\t\t\tfor ( i = 0; i < hasScripts; i++ ) {\n\t\t\t\t\t\tnode = scripts[ i ];\n\t\t\t\t\t\tif ( rscriptType.test( node.type || \"\" ) &&\n\t\t\t\t\t\t\t!jQuery._data( node, \"globalEval\" ) &&\n\t\t\t\t\t\t\tjQuery.contains( doc, node ) ) {\n\n\t\t\t\t\t\t\tif ( node.src ) {\n\n\t\t\t\t\t\t\t\t// Optional AJAX dependency, but won't run scripts if not present\n\t\t\t\t\t\t\t\tif ( jQuery._evalUrl ) {\n\t\t\t\t\t\t\t\t\tjQuery._evalUrl( node.src );\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\tjQuery.globalEval(\n\t\t\t\t\t\t\t\t\t( node.text || node.textContent || node.innerHTML || \"\" )\n\t\t\t\t\t\t\t\t\t\t.replace( rcleanScript, \"\" )\n\t\t\t\t\t\t\t\t);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Fix #11809: Avoid leaking memory\n\t\t\t\tfragment = first = null;\n\t\t\t}\n\t\t}\n\n\t\treturn collection;\n\t}\n\n\tfunction remove( elem, selector, keepData ) {\n\t\tvar node,\n\t\t\telems = selector ? jQuery.filter( selector, elem ) : elem,\n\t\t\ti = 0;\n\n\t\tfor ( ; ( node = elems[ i ] ) != null; i++ ) {\n\n\t\t\tif ( !keepData && node.nodeType === 1 ) {\n\t\t\t\tjQuery.cleanData( getAll( node ) );\n\t\t\t}\n\n\t\t\tif ( node.parentNode ) {\n\t\t\t\tif ( keepData && jQuery.contains( node.ownerDocument, node ) ) {\n\t\t\t\t\tsetGlobalEval( getAll( node, \"script\" ) );\n\t\t\t\t}\n\t\t\t\tnode.parentNode.removeChild( node );\n\t\t\t}\n\t\t}\n\n\t\treturn elem;\n\t}\n\n\tjQuery.extend( {\n\t\thtmlPrefilter: function( html ) {\n\t\t\treturn html.replace( rxhtmlTag, \"<$1></$2>\" );\n\t\t},\n\n\t\tclone: function( elem, dataAndEvents, deepDataAndEvents ) {\n\t\t\tvar destElements, node, clone, i, srcElements,\n\t\t\t\tinPage = jQuery.contains( elem.ownerDocument, elem );\n\n\t\t\tif ( support.html5Clone || jQuery.isXMLDoc( elem ) ||\n\t\t\t\t!rnoshimcache.test( \"<\" + elem.nodeName + \">\" ) ) {\n\n\t\t\t\tclone = elem.cloneNode( true );\n\n\t\t\t\t// IE<=8 does not properly clone detached, unknown element nodes\n\t\t\t} else {\n\t\t\t\tfragmentDiv.innerHTML = elem.outerHTML;\n\t\t\t\tfragmentDiv.removeChild( clone = fragmentDiv.firstChild );\n\t\t\t}\n\n\t\t\tif ( ( !support.noCloneEvent || !support.noCloneChecked ) &&\n\t\t\t\t( elem.nodeType === 1 || elem.nodeType === 11 ) && !jQuery.isXMLDoc( elem ) ) {\n\n\t\t\t\t// We eschew Sizzle here for performance reasons: http://jsperf.com/getall-vs-sizzle/2\n\t\t\t\tdestElements = getAll( clone );\n\t\t\t\tsrcElements = getAll( elem );\n\n\t\t\t\t// Fix all IE cloning issues\n\t\t\t\tfor ( i = 0; ( node = srcElements[ i ] ) != null; ++i ) {\n\n\t\t\t\t\t// Ensure that the destination node is not null; Fixes #9587\n\t\t\t\t\tif ( destElements[ i ] ) {\n\t\t\t\t\t\tfixCloneNodeIssues( node, destElements[ i ] );\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Copy the events from the original to the clone\n\t\t\tif ( dataAndEvents ) {\n\t\t\t\tif ( deepDataAndEvents ) {\n\t\t\t\t\tsrcElements = srcElements || getAll( elem );\n\t\t\t\t\tdestElements = destElements || getAll( clone );\n\n\t\t\t\t\tfor ( i = 0; ( node = srcElements[ i ] ) != null; i++ ) {\n\t\t\t\t\t\tcloneCopyEvent( node, destElements[ i ] );\n\t\t\t\t\t}\n\t\t\t\t} else {\n\t\t\t\t\tcloneCopyEvent( elem, clone );\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Preserve script evaluation history\n\t\t\tdestElements = getAll( clone, \"script\" );\n\t\t\tif ( destElements.length > 0 ) {\n\t\t\t\tsetGlobalEval( destElements, !inPage && getAll( elem, \"script\" ) );\n\t\t\t}\n\n\t\t\tdestElements = srcElements = node = null;\n\n\t\t\t// Return the cloned set\n\t\t\treturn clone;\n\t\t},\n\n\t\tcleanData: function( elems, /* internal */ forceAcceptData ) {\n\t\t\tvar elem, type, id, data,\n\t\t\t\ti = 0,\n\t\t\t\tinternalKey = jQuery.expando,\n\t\t\t\tcache = jQuery.cache,\n\t\t\t\tattributes = support.attributes,\n\t\t\t\tspecial = jQuery.event.special;\n\n\t\t\tfor ( ; ( elem = elems[ i ] ) != null; i++ ) {\n\t\t\t\tif ( forceAcceptData || acceptData( elem ) ) {\n\n\t\t\t\t\tid = elem[ internalKey ];\n\t\t\t\t\tdata = id && cache[ id ];\n\n\t\t\t\t\tif ( data ) {\n\t\t\t\t\t\tif ( data.events ) {\n\t\t\t\t\t\t\tfor ( type in data.events ) {\n\t\t\t\t\t\t\t\tif ( special[ type ] ) {\n\t\t\t\t\t\t\t\t\tjQuery.event.remove( elem, type );\n\n\t\t\t\t\t\t\t\t\t// This is a shortcut to avoid jQuery.event.remove's overhead\n\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\tjQuery.removeEvent( elem, type, data.handle );\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Remove cache only if it was not already removed by jQuery.event.remove\n\t\t\t\t\t\tif ( cache[ id ] ) {\n\n\t\t\t\t\t\t\tdelete cache[ id ];\n\n\t\t\t\t\t\t\t// Support: IE<9\n\t\t\t\t\t\t\t// IE does not allow us to delete expando properties from nodes\n\t\t\t\t\t\t\t// IE creates expando attributes along with the property\n\t\t\t\t\t\t\t// IE does not have a removeAttribute function on Document nodes\n\t\t\t\t\t\t\tif ( !attributes && typeof elem.removeAttribute !== \"undefined\" ) {\n\t\t\t\t\t\t\t\telem.removeAttribute( internalKey );\n\n\t\t\t\t\t\t\t\t// Webkit & Blink performance suffers when deleting properties\n\t\t\t\t\t\t\t\t// from DOM nodes, so set to undefined instead\n\t\t\t\t\t\t\t\t// https://code.google.com/p/chromium/issues/detail?id=378607\n\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\telem[ internalKey ] = undefined;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tdeletedIds.push( id );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t} );\n\n\tjQuery.fn.extend( {\n\n\t\t// Keep domManip exposed until 3.0 (gh-2225)\n\t\tdomManip: domManip,\n\n\t\tdetach: function( selector ) {\n\t\t\treturn remove( this, selector, true );\n\t\t},\n\n\t\tremove: function( selector ) {\n\t\t\treturn remove( this, selector );\n\t\t},\n\n\t\ttext: function( value ) {\n\t\t\treturn access( this, function( value ) {\n\t\t\t\treturn value === undefined ?\n\t\t\t\t\tjQuery.text( this ) :\n\t\t\t\t\tthis.empty().append(\n\t\t\t\t\t\t( this[ 0 ] && this[ 0 ].ownerDocument || document ).createTextNode( value )\n\t\t\t\t\t);\n\t\t\t}, null, value, arguments.length );\n\t\t},\n\n\t\tappend: function() {\n\t\t\treturn domManip( this, arguments, function( elem ) {\n\t\t\t\tif ( this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9 ) {\n\t\t\t\t\tvar target = manipulationTarget( this, elem );\n\t\t\t\t\ttarget.appendChild( elem );\n\t\t\t\t}\n\t\t\t} );\n\t\t},\n\n\t\tprepend: function() {\n\t\t\treturn domManip( this, arguments, function( elem ) {\n\t\t\t\tif ( this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9 ) {\n\t\t\t\t\tvar target = manipulationTarget( this, elem );\n\t\t\t\t\ttarget.insertBefore( elem, target.firstChild );\n\t\t\t\t}\n\t\t\t} );\n\t\t},\n\n\t\tbefore: function() {\n\t\t\treturn domManip( this, arguments, function( elem ) {\n\t\t\t\tif ( this.parentNode ) {\n\t\t\t\t\tthis.parentNode.insertBefore( elem, this );\n\t\t\t\t}\n\t\t\t} );\n\t\t},\n\n\t\tafter: function() {\n\t\t\treturn domManip( this, arguments, function( elem ) {\n\t\t\t\tif ( this.parentNode ) {\n\t\t\t\t\tthis.parentNode.insertBefore( elem, this.nextSibling );\n\t\t\t\t}\n\t\t\t} );\n\t\t},\n\n\t\tempty: function() {\n\t\t\tvar elem,\n\t\t\t\ti = 0;\n\n\t\t\tfor ( ; ( elem = this[ i ] ) != null; i++ ) {\n\n\t\t\t\t// Remove element nodes and prevent memory leaks\n\t\t\t\tif ( elem.nodeType === 1 ) {\n\t\t\t\t\tjQuery.cleanData( getAll( elem, false ) );\n\t\t\t\t}\n\n\t\t\t\t// Remove any remaining nodes\n\t\t\t\twhile ( elem.firstChild ) {\n\t\t\t\t\telem.removeChild( elem.firstChild );\n\t\t\t\t}\n\n\t\t\t\t// If this is a select, ensure that it displays empty (#12336)\n\t\t\t\t// Support: IE<9\n\t\t\t\tif ( elem.options && jQuery.nodeName( elem, \"select\" ) ) {\n\t\t\t\t\telem.options.length = 0;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn this;\n\t\t},\n\n\t\tclone: function( dataAndEvents, deepDataAndEvents ) {\n\t\t\tdataAndEvents = dataAndEvents == null ? false : dataAndEvents;\n\t\t\tdeepDataAndEvents = deepDataAndEvents == null ? dataAndEvents : deepDataAndEvents;\n\n\t\t\treturn this.map( function() {\n\t\t\t\treturn jQuery.clone( this, dataAndEvents, deepDataAndEvents );\n\t\t\t} );\n\t\t},\n\n\t\thtml: function( value ) {\n\t\t\treturn access( this, function( value ) {\n\t\t\t\tvar elem = this[ 0 ] || {},\n\t\t\t\t\ti = 0,\n\t\t\t\t\tl = this.length;\n\n\t\t\t\tif ( value === undefined ) {\n\t\t\t\t\treturn elem.nodeType === 1 ?\n\t\t\t\t\t\telem.innerHTML.replace( rinlinejQuery, \"\" ) :\n\t\t\t\t\t\tundefined;\n\t\t\t\t}\n\n\t\t\t\t// See if we can take a shortcut and just use innerHTML\n\t\t\t\tif ( typeof value === \"string\" && !rnoInnerhtml.test( value ) &&\n\t\t\t\t\t( support.htmlSerialize || !rnoshimcache.test( value )  ) &&\n\t\t\t\t\t( support.leadingWhitespace || !rleadingWhitespace.test( value ) ) &&\n\t\t\t\t\t!wrapMap[ ( rtagName.exec( value ) || [ \"\", \"\" ] )[ 1 ].toLowerCase() ] ) {\n\n\t\t\t\t\tvalue = jQuery.htmlPrefilter( value );\n\n\t\t\t\t\ttry {\n\t\t\t\t\t\tfor ( ; i < l; i++ ) {\n\n\t\t\t\t\t\t\t// Remove element nodes and prevent memory leaks\n\t\t\t\t\t\t\telem = this[ i ] || {};\n\t\t\t\t\t\t\tif ( elem.nodeType === 1 ) {\n\t\t\t\t\t\t\t\tjQuery.cleanData( getAll( elem, false ) );\n\t\t\t\t\t\t\t\telem.innerHTML = value;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\telem = 0;\n\n\t\t\t\t\t\t// If using innerHTML throws an exception, use the fallback method\n\t\t\t\t\t} catch ( e ) {}\n\t\t\t\t}\n\n\t\t\t\tif ( elem ) {\n\t\t\t\t\tthis.empty().append( value );\n\t\t\t\t}\n\t\t\t}, null, value, arguments.length );\n\t\t},\n\n\t\treplaceWith: function() {\n\t\t\tvar ignored = [];\n\n\t\t\t// Make the changes, replacing each non-ignored context element with the new content\n\t\t\treturn domManip( this, arguments, function( elem ) {\n\t\t\t\tvar parent = this.parentNode;\n\n\t\t\t\tif ( jQuery.inArray( this, ignored ) < 0 ) {\n\t\t\t\t\tjQuery.cleanData( getAll( this ) );\n\t\t\t\t\tif ( parent ) {\n\t\t\t\t\t\tparent.replaceChild( elem, this );\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Force callback invocation\n\t\t\t}, ignored );\n\t\t}\n\t} );\n\n\tjQuery.each( {\n\t\tappendTo: \"append\",\n\t\tprependTo: \"prepend\",\n\t\tinsertBefore: \"before\",\n\t\tinsertAfter: \"after\",\n\t\treplaceAll: \"replaceWith\"\n\t}, function( name, original ) {\n\t\tjQuery.fn[ name ] = function( selector ) {\n\t\t\tvar elems,\n\t\t\t\ti = 0,\n\t\t\t\tret = [],\n\t\t\t\tinsert = jQuery( selector ),\n\t\t\t\tlast = insert.length - 1;\n\n\t\t\tfor ( ; i <= last; i++ ) {\n\t\t\t\telems = i === last ? this : this.clone( true );\n\t\t\t\tjQuery( insert[ i ] )[ original ]( elems );\n\n\t\t\t\t// Modern browsers can apply jQuery collections as arrays, but oldIE needs a .get()\n\t\t\t\tpush.apply( ret, elems.get() );\n\t\t\t}\n\n\t\t\treturn this.pushStack( ret );\n\t\t};\n\t} );\n\n\n\tvar iframe,\n\t\telemdisplay = {\n\n\t\t\t// Support: Firefox\n\t\t\t// We have to pre-define these values for FF (#10227)\n\t\t\tHTML: \"block\",\n\t\t\tBODY: \"block\"\n\t\t};\n\n\t/**\n\t * Retrieve the actual display of a element\n\t * @param {String} name nodeName of the element\n\t * @param {Object} doc Document object\n\t */\n\n// Called only from within defaultDisplay\n\tfunction actualDisplay( name, doc ) {\n\t\tvar elem = jQuery( doc.createElement( name ) ).appendTo( doc.body ),\n\n\t\t\tdisplay = jQuery.css( elem[ 0 ], \"display\" );\n\n\t\t// We don't have any data stored on the element,\n\t\t// so use \"detach\" method as fast way to get rid of the element\n\t\telem.detach();\n\n\t\treturn display;\n\t}\n\n\t/**\n\t * Try to determine the default display value of an element\n\t * @param {String} nodeName\n\t */\n\tfunction defaultDisplay( nodeName ) {\n\t\tvar doc = document,\n\t\t\tdisplay = elemdisplay[ nodeName ];\n\n\t\tif ( !display ) {\n\t\t\tdisplay = actualDisplay( nodeName, doc );\n\n\t\t\t// If the simple way fails, read from inside an iframe\n\t\t\tif ( display === \"none\" || !display ) {\n\n\t\t\t\t// Use the already-created iframe if possible\n\t\t\t\tiframe = ( iframe || jQuery( \"<iframe frameborder='0' width='0' height='0'/>\" ) )\n\t\t\t\t\t.appendTo( doc.documentElement );\n\n\t\t\t\t// Always write a new HTML skeleton so Webkit and Firefox don't choke on reuse\n\t\t\t\tdoc = ( iframe[ 0 ].contentWindow || iframe[ 0 ].contentDocument ).document;\n\n\t\t\t\t// Support: IE\n\t\t\t\tdoc.write();\n\t\t\t\tdoc.close();\n\n\t\t\t\tdisplay = actualDisplay( nodeName, doc );\n\t\t\t\tiframe.detach();\n\t\t\t}\n\n\t\t\t// Store the correct default display\n\t\t\telemdisplay[ nodeName ] = display;\n\t\t}\n\n\t\treturn display;\n\t}\n\tvar rmargin = ( /^margin/ );\n\n\tvar rnumnonpx = new RegExp( \"^(\" + pnum + \")(?!px)[a-z%]+$\", \"i\" );\n\n\tvar swap = function( elem, options, callback, args ) {\n\t\tvar ret, name,\n\t\t\told = {};\n\n\t\t// Remember the old values, and insert the new ones\n\t\tfor ( name in options ) {\n\t\t\told[ name ] = elem.style[ name ];\n\t\t\telem.style[ name ] = options[ name ];\n\t\t}\n\n\t\tret = callback.apply( elem, args || [] );\n\n\t\t// Revert the old values\n\t\tfor ( name in options ) {\n\t\t\telem.style[ name ] = old[ name ];\n\t\t}\n\n\t\treturn ret;\n\t};\n\n\n\tvar documentElement = document.documentElement;\n\n\n\n\t( function() {\n\t\tvar pixelPositionVal, pixelMarginRightVal, boxSizingReliableVal,\n\t\t\treliableHiddenOffsetsVal, reliableMarginRightVal, reliableMarginLeftVal,\n\t\t\tcontainer = document.createElement( \"div\" ),\n\t\t\tdiv = document.createElement( \"div\" );\n\n\t\t// Finish early in limited (non-browser) environments\n\t\tif ( !div.style ) {\n\t\t\treturn;\n\t\t}\n\n\t\tdiv.style.cssText = \"float:left;opacity:.5\";\n\n\t\t// Support: IE<9\n\t\t// Make sure that element opacity exists (as opposed to filter)\n\t\tsupport.opacity = div.style.opacity === \"0.5\";\n\n\t\t// Verify style float existence\n\t\t// (IE uses styleFloat instead of cssFloat)\n\t\tsupport.cssFloat = !!div.style.cssFloat;\n\n\t\tdiv.style.backgroundClip = \"content-box\";\n\t\tdiv.cloneNode( true ).style.backgroundClip = \"\";\n\t\tsupport.clearCloneStyle = div.style.backgroundClip === \"content-box\";\n\n\t\tcontainer = document.createElement( \"div\" );\n\t\tcontainer.style.cssText = \"border:0;width:8px;height:0;top:0;left:-9999px;\" +\n\t\t\t\"padding:0;margin-top:1px;position:absolute\";\n\t\tdiv.innerHTML = \"\";\n\t\tcontainer.appendChild( div );\n\n\t\t// Support: Firefox<29, Android 2.3\n\t\t// Vendor-prefix box-sizing\n\t\tsupport.boxSizing = div.style.boxSizing === \"\" || div.style.MozBoxSizing === \"\" ||\n\t\t\tdiv.style.WebkitBoxSizing === \"\";\n\n\t\tjQuery.extend( support, {\n\t\t\treliableHiddenOffsets: function() {\n\t\t\t\tif ( pixelPositionVal == null ) {\n\t\t\t\t\tcomputeStyleTests();\n\t\t\t\t}\n\t\t\t\treturn reliableHiddenOffsetsVal;\n\t\t\t},\n\n\t\t\tboxSizingReliable: function() {\n\n\t\t\t\t// We're checking for pixelPositionVal here instead of boxSizingReliableVal\n\t\t\t\t// since that compresses better and they're computed together anyway.\n\t\t\t\tif ( pixelPositionVal == null ) {\n\t\t\t\t\tcomputeStyleTests();\n\t\t\t\t}\n\t\t\t\treturn boxSizingReliableVal;\n\t\t\t},\n\n\t\t\tpixelMarginRight: function() {\n\n\t\t\t\t// Support: Android 4.0-4.3\n\t\t\t\tif ( pixelPositionVal == null ) {\n\t\t\t\t\tcomputeStyleTests();\n\t\t\t\t}\n\t\t\t\treturn pixelMarginRightVal;\n\t\t\t},\n\n\t\t\tpixelPosition: function() {\n\t\t\t\tif ( pixelPositionVal == null ) {\n\t\t\t\t\tcomputeStyleTests();\n\t\t\t\t}\n\t\t\t\treturn pixelPositionVal;\n\t\t\t},\n\n\t\t\treliableMarginRight: function() {\n\n\t\t\t\t// Support: Android 2.3\n\t\t\t\tif ( pixelPositionVal == null ) {\n\t\t\t\t\tcomputeStyleTests();\n\t\t\t\t}\n\t\t\t\treturn reliableMarginRightVal;\n\t\t\t},\n\n\t\t\treliableMarginLeft: function() {\n\n\t\t\t\t// Support: IE <=8 only, Android 4.0 - 4.3 only, Firefox <=3 - 37\n\t\t\t\tif ( pixelPositionVal == null ) {\n\t\t\t\t\tcomputeStyleTests();\n\t\t\t\t}\n\t\t\t\treturn reliableMarginLeftVal;\n\t\t\t}\n\t\t} );\n\n\t\tfunction computeStyleTests() {\n\t\t\tvar contents, divStyle,\n\t\t\t\tdocumentElement = document.documentElement;\n\n\t\t\t// Setup\n\t\t\tdocumentElement.appendChild( container );\n\n\t\t\tdiv.style.cssText =\n\n\t\t\t\t// Support: Android 2.3\n\t\t\t\t// Vendor-prefix box-sizing\n\t\t\t\t\"-webkit-box-sizing:border-box;box-sizing:border-box;\" +\n\t\t\t\t\"position:relative;display:block;\" +\n\t\t\t\t\"margin:auto;border:1px;padding:1px;\" +\n\t\t\t\t\"top:1%;width:50%\";\n\n\t\t\t// Support: IE<9\n\t\t\t// Assume reasonable values in the absence of getComputedStyle\n\t\t\tpixelPositionVal = boxSizingReliableVal = reliableMarginLeftVal = false;\n\t\t\tpixelMarginRightVal = reliableMarginRightVal = true;\n\n\t\t\t// Check for getComputedStyle so that this code is not run in IE<9.\n\t\t\tif ( window.getComputedStyle ) {\n\t\t\t\tdivStyle = window.getComputedStyle( div );\n\t\t\t\tpixelPositionVal = ( divStyle || {} ).top !== \"1%\";\n\t\t\t\treliableMarginLeftVal = ( divStyle || {} ).marginLeft === \"2px\";\n\t\t\t\tboxSizingReliableVal = ( divStyle || { width: \"4px\" } ).width === \"4px\";\n\n\t\t\t\t// Support: Android 4.0 - 4.3 only\n\t\t\t\t// Some styles come back with percentage values, even though they shouldn't\n\t\t\t\tdiv.style.marginRight = \"50%\";\n\t\t\t\tpixelMarginRightVal = ( divStyle || { marginRight: \"4px\" } ).marginRight === \"4px\";\n\n\t\t\t\t// Support: Android 2.3 only\n\t\t\t\t// Div with explicit width and no margin-right incorrectly\n\t\t\t\t// gets computed margin-right based on width of container (#3333)\n\t\t\t\t// WebKit Bug 13343 - getComputedStyle returns wrong value for margin-right\n\t\t\t\tcontents = div.appendChild( document.createElement( \"div\" ) );\n\n\t\t\t\t// Reset CSS: box-sizing; display; margin; border; padding\n\t\t\t\tcontents.style.cssText = div.style.cssText =\n\n\t\t\t\t\t// Support: Android 2.3\n\t\t\t\t\t// Vendor-prefix box-sizing\n\t\t\t\t\t\"-webkit-box-sizing:content-box;-moz-box-sizing:content-box;\" +\n\t\t\t\t\t\"box-sizing:content-box;display:block;margin:0;border:0;padding:0\";\n\t\t\t\tcontents.style.marginRight = contents.style.width = \"0\";\n\t\t\t\tdiv.style.width = \"1px\";\n\n\t\t\t\treliableMarginRightVal =\n\t\t\t\t\t!parseFloat( ( window.getComputedStyle( contents ) || {} ).marginRight );\n\n\t\t\t\tdiv.removeChild( contents );\n\t\t\t}\n\n\t\t\t// Support: IE6-8\n\t\t\t// First check that getClientRects works as expected\n\t\t\t// Check if table cells still have offsetWidth/Height when they are set\n\t\t\t// to display:none and there are still other visible table cells in a\n\t\t\t// table row; if so, offsetWidth/Height are not reliable for use when\n\t\t\t// determining if an element has been hidden directly using\n\t\t\t// display:none (it is still safe to use offsets if a parent element is\n\t\t\t// hidden; don safety goggles and see bug #4512 for more information).\n\t\t\tdiv.style.display = \"none\";\n\t\t\treliableHiddenOffsetsVal = div.getClientRects().length === 0;\n\t\t\tif ( reliableHiddenOffsetsVal ) {\n\t\t\t\tdiv.style.display = \"\";\n\t\t\t\tdiv.innerHTML = \"<table><tr><td></td><td>t</td></tr></table>\";\n\t\t\t\tdiv.childNodes[ 0 ].style.borderCollapse = \"separate\";\n\t\t\t\tcontents = div.getElementsByTagName( \"td\" );\n\t\t\t\tcontents[ 0 ].style.cssText = \"margin:0;border:0;padding:0;display:none\";\n\t\t\t\treliableHiddenOffsetsVal = contents[ 0 ].offsetHeight === 0;\n\t\t\t\tif ( reliableHiddenOffsetsVal ) {\n\t\t\t\t\tcontents[ 0 ].style.display = \"\";\n\t\t\t\t\tcontents[ 1 ].style.display = \"none\";\n\t\t\t\t\treliableHiddenOffsetsVal = contents[ 0 ].offsetHeight === 0;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Teardown\n\t\t\tdocumentElement.removeChild( container );\n\t\t}\n\n\t} )();\n\n\n\tvar getStyles, curCSS,\n\t\trposition = /^(top|right|bottom|left)$/;\n\n\tif ( window.getComputedStyle ) {\n\t\tgetStyles = function( elem ) {\n\n\t\t\t// Support: IE<=11+, Firefox<=30+ (#15098, #14150)\n\t\t\t// IE throws on elements created in popups\n\t\t\t// FF meanwhile throws on frame elements through \"defaultView.getComputedStyle\"\n\t\t\tvar view = elem.ownerDocument.defaultView;\n\n\t\t\tif ( !view || !view.opener ) {\n\t\t\t\tview = window;\n\t\t\t}\n\n\t\t\treturn view.getComputedStyle( elem );\n\t\t};\n\n\t\tcurCSS = function( elem, name, computed ) {\n\t\t\tvar width, minWidth, maxWidth, ret,\n\t\t\t\tstyle = elem.style;\n\n\t\t\tcomputed = computed || getStyles( elem );\n\n\t\t\t// getPropertyValue is only needed for .css('filter') in IE9, see #12537\n\t\t\tret = computed ? computed.getPropertyValue( name ) || computed[ name ] : undefined;\n\n\t\t\t// Support: Opera 12.1x only\n\t\t\t// Fall back to style even without computed\n\t\t\t// computed is undefined for elems on document fragments\n\t\t\tif ( ( ret === \"\" || ret === undefined ) && !jQuery.contains( elem.ownerDocument, elem ) ) {\n\t\t\t\tret = jQuery.style( elem, name );\n\t\t\t}\n\n\t\t\tif ( computed ) {\n\n\t\t\t\t// A tribute to the \"awesome hack by Dean Edwards\"\n\t\t\t\t// Chrome < 17 and Safari 5.0 uses \"computed value\"\n\t\t\t\t// instead of \"used value\" for margin-right\n\t\t\t\t// Safari 5.1.7 (at least) returns percentage for a larger set of values,\n\t\t\t\t// but width seems to be reliably pixels\n\t\t\t\t// this is against the CSSOM draft spec:\n\t\t\t\t// http://dev.w3.org/csswg/cssom/#resolved-values\n\t\t\t\tif ( !support.pixelMarginRight() && rnumnonpx.test( ret ) && rmargin.test( name ) ) {\n\n\t\t\t\t\t// Remember the original values\n\t\t\t\t\twidth = style.width;\n\t\t\t\t\tminWidth = style.minWidth;\n\t\t\t\t\tmaxWidth = style.maxWidth;\n\n\t\t\t\t\t// Put in the new values to get a computed value out\n\t\t\t\t\tstyle.minWidth = style.maxWidth = style.width = ret;\n\t\t\t\t\tret = computed.width;\n\n\t\t\t\t\t// Revert the changed values\n\t\t\t\t\tstyle.width = width;\n\t\t\t\t\tstyle.minWidth = minWidth;\n\t\t\t\t\tstyle.maxWidth = maxWidth;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Support: IE\n\t\t\t// IE returns zIndex value as an integer.\n\t\t\treturn ret === undefined ?\n\t\t\t\tret :\n\t\t\tret + \"\";\n\t\t};\n\t} else if ( documentElement.currentStyle ) {\n\t\tgetStyles = function( elem ) {\n\t\t\treturn elem.currentStyle;\n\t\t};\n\n\t\tcurCSS = function( elem, name, computed ) {\n\t\t\tvar left, rs, rsLeft, ret,\n\t\t\t\tstyle = elem.style;\n\n\t\t\tcomputed = computed || getStyles( elem );\n\t\t\tret = computed ? computed[ name ] : undefined;\n\n\t\t\t// Avoid setting ret to empty string here\n\t\t\t// so we don't default to auto\n\t\t\tif ( ret == null && style && style[ name ] ) {\n\t\t\t\tret = style[ name ];\n\t\t\t}\n\n\t\t\t// From the awesome hack by Dean Edwards\n\t\t\t// http://erik.eae.net/archives/2007/07/27/18.54.15/#comment-102291\n\n\t\t\t// If we're not dealing with a regular pixel number\n\t\t\t// but a number that has a weird ending, we need to convert it to pixels\n\t\t\t// but not position css attributes, as those are\n\t\t\t// proportional to the parent element instead\n\t\t\t// and we can't measure the parent instead because it\n\t\t\t// might trigger a \"stacking dolls\" problem\n\t\t\tif ( rnumnonpx.test( ret ) && !rposition.test( name ) ) {\n\n\t\t\t\t// Remember the original values\n\t\t\t\tleft = style.left;\n\t\t\t\trs = elem.runtimeStyle;\n\t\t\t\trsLeft = rs && rs.left;\n\n\t\t\t\t// Put in the new values to get a computed value out\n\t\t\t\tif ( rsLeft ) {\n\t\t\t\t\trs.left = elem.currentStyle.left;\n\t\t\t\t}\n\t\t\t\tstyle.left = name === \"fontSize\" ? \"1em\" : ret;\n\t\t\t\tret = style.pixelLeft + \"px\";\n\n\t\t\t\t// Revert the changed values\n\t\t\t\tstyle.left = left;\n\t\t\t\tif ( rsLeft ) {\n\t\t\t\t\trs.left = rsLeft;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Support: IE\n\t\t\t// IE returns zIndex value as an integer.\n\t\t\treturn ret === undefined ?\n\t\t\t\tret :\n\t\t\tret + \"\" || \"auto\";\n\t\t};\n\t}\n\n\n\n\n\tfunction addGetHookIf( conditionFn, hookFn ) {\n\n\t\t// Define the hook, we'll check on the first run if it's really needed.\n\t\treturn {\n\t\t\tget: function() {\n\t\t\t\tif ( conditionFn() ) {\n\n\t\t\t\t\t// Hook not needed (or it's not possible to use it due\n\t\t\t\t\t// to missing dependency), remove it.\n\t\t\t\t\tdelete this.get;\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\t// Hook needed; redefine it so that the support test is not executed again.\n\t\t\t\treturn ( this.get = hookFn ).apply( this, arguments );\n\t\t\t}\n\t\t};\n\t}\n\n\n\tvar\n\n\t\tralpha = /alpha\\([^)]*\\)/i,\n\t\tropacity = /opacity\\s*=\\s*([^)]*)/i,\n\n\t\t// swappable if display is none or starts with table except\n\t\t// \"table\", \"table-cell\", or \"table-caption\"\n\t\t// see here for display values:\n\t\t// https://developer.mozilla.org/en-US/docs/CSS/display\n\t\trdisplayswap = /^(none|table(?!-c[ea]).+)/,\n\t\trnumsplit = new RegExp( \"^(\" + pnum + \")(.*)$\", \"i\" ),\n\n\t\tcssShow = { position: \"absolute\", visibility: \"hidden\", display: \"block\" },\n\t\tcssNormalTransform = {\n\t\t\tletterSpacing: \"0\",\n\t\t\tfontWeight: \"400\"\n\t\t},\n\n\t\tcssPrefixes = [ \"Webkit\", \"O\", \"Moz\", \"ms\" ],\n\t\temptyStyle = document.createElement( \"div\" ).style;\n\n\n// return a css property mapped to a potentially vendor prefixed property\n\tfunction vendorPropName( name ) {\n\n\t\t// shortcut for names that are not vendor prefixed\n\t\tif ( name in emptyStyle ) {\n\t\t\treturn name;\n\t\t}\n\n\t\t// check for vendor prefixed names\n\t\tvar capName = name.charAt( 0 ).toUpperCase() + name.slice( 1 ),\n\t\t\ti = cssPrefixes.length;\n\n\t\twhile ( i-- ) {\n\t\t\tname = cssPrefixes[ i ] + capName;\n\t\t\tif ( name in emptyStyle ) {\n\t\t\t\treturn name;\n\t\t\t}\n\t\t}\n\t}\n\n\tfunction showHide( elements, show ) {\n\t\tvar display, elem, hidden,\n\t\t\tvalues = [],\n\t\t\tindex = 0,\n\t\t\tlength = elements.length;\n\n\t\tfor ( ; index < length; index++ ) {\n\t\t\telem = elements[ index ];\n\t\t\tif ( !elem.style ) {\n\t\t\t\tcontinue;\n\t\t\t}\n\n\t\t\tvalues[ index ] = jQuery._data( elem, \"olddisplay\" );\n\t\t\tdisplay = elem.style.display;\n\t\t\tif ( show ) {\n\n\t\t\t\t// Reset the inline display of this element to learn if it is\n\t\t\t\t// being hidden by cascaded rules or not\n\t\t\t\tif ( !values[ index ] && display === \"none\" ) {\n\t\t\t\t\telem.style.display = \"\";\n\t\t\t\t}\n\n\t\t\t\t// Set elements which have been overridden with display: none\n\t\t\t\t// in a stylesheet to whatever the default browser style is\n\t\t\t\t// for such an element\n\t\t\t\tif ( elem.style.display === \"\" && isHidden( elem ) ) {\n\t\t\t\t\tvalues[ index ] =\n\t\t\t\t\t\tjQuery._data( elem, \"olddisplay\", defaultDisplay( elem.nodeName ) );\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\thidden = isHidden( elem );\n\n\t\t\t\tif ( display && display !== \"none\" || !hidden ) {\n\t\t\t\t\tjQuery._data(\n\t\t\t\t\t\telem,\n\t\t\t\t\t\t\"olddisplay\",\n\t\t\t\t\t\thidden ? display : jQuery.css( elem, \"display\" )\n\t\t\t\t\t);\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\t// Set the display of most of the elements in a second loop\n\t\t// to avoid the constant reflow\n\t\tfor ( index = 0; index < length; index++ ) {\n\t\t\telem = elements[ index ];\n\t\t\tif ( !elem.style ) {\n\t\t\t\tcontinue;\n\t\t\t}\n\t\t\tif ( !show || elem.style.display === \"none\" || elem.style.display === \"\" ) {\n\t\t\t\telem.style.display = show ? values[ index ] || \"\" : \"none\";\n\t\t\t}\n\t\t}\n\n\t\treturn elements;\n\t}\n\n\tfunction setPositiveNumber( elem, value, subtract ) {\n\t\tvar matches = rnumsplit.exec( value );\n\t\treturn matches ?\n\n\t\t\t// Guard against undefined \"subtract\", e.g., when used as in cssHooks\n\t\tMath.max( 0, matches[ 1 ] - ( subtract || 0 ) ) + ( matches[ 2 ] || \"px\" ) :\n\t\t\tvalue;\n\t}\n\n\tfunction augmentWidthOrHeight( elem, name, extra, isBorderBox, styles ) {\n\t\tvar i = extra === ( isBorderBox ? \"border\" : \"content\" ) ?\n\n\t\t\t\t// If we already have the right measurement, avoid augmentation\n\t\t\t\t4 :\n\n\t\t\t\t// Otherwise initialize for horizontal or vertical properties\n\t\t\t\tname === \"width\" ? 1 : 0,\n\n\t\t\tval = 0;\n\n\t\tfor ( ; i < 4; i += 2 ) {\n\n\t\t\t// both box models exclude margin, so add it if we want it\n\t\t\tif ( extra === \"margin\" ) {\n\t\t\t\tval += jQuery.css( elem, extra + cssExpand[ i ], true, styles );\n\t\t\t}\n\n\t\t\tif ( isBorderBox ) {\n\n\t\t\t\t// border-box includes padding, so remove it if we want content\n\t\t\t\tif ( extra === \"content\" ) {\n\t\t\t\t\tval -= jQuery.css( elem, \"padding\" + cssExpand[ i ], true, styles );\n\t\t\t\t}\n\n\t\t\t\t// at this point, extra isn't border nor margin, so remove border\n\t\t\t\tif ( extra !== \"margin\" ) {\n\t\t\t\t\tval -= jQuery.css( elem, \"border\" + cssExpand[ i ] + \"Width\", true, styles );\n\t\t\t\t}\n\t\t\t} else {\n\n\t\t\t\t// at this point, extra isn't content, so add padding\n\t\t\t\tval += jQuery.css( elem, \"padding\" + cssExpand[ i ], true, styles );\n\n\t\t\t\t// at this point, extra isn't content nor padding, so add border\n\t\t\t\tif ( extra !== \"padding\" ) {\n\t\t\t\t\tval += jQuery.css( elem, \"border\" + cssExpand[ i ] + \"Width\", true, styles );\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\treturn val;\n\t}\n\n\tfunction getWidthOrHeight( elem, name, extra ) {\n\n\t\t// Start with offset property, which is equivalent to the border-box value\n\t\tvar valueIsBorderBox = true,\n\t\t\tval = name === \"width\" ? elem.offsetWidth : elem.offsetHeight,\n\t\t\tstyles = getStyles( elem ),\n\t\t\tisBorderBox = support.boxSizing &&\n\t\t\t\tjQuery.css( elem, \"boxSizing\", false, styles ) === \"border-box\";\n\n\t\t// some non-html elements return undefined for offsetWidth, so check for null/undefined\n\t\t// svg - https://bugzilla.mozilla.org/show_bug.cgi?id=649285\n\t\t// MathML - https://bugzilla.mozilla.org/show_bug.cgi?id=491668\n\t\tif ( val <= 0 || val == null ) {\n\n\t\t\t// Fall back to computed then uncomputed css if necessary\n\t\t\tval = curCSS( elem, name, styles );\n\t\t\tif ( val < 0 || val == null ) {\n\t\t\t\tval = elem.style[ name ];\n\t\t\t}\n\n\t\t\t// Computed unit is not pixels. Stop here and return.\n\t\t\tif ( rnumnonpx.test( val ) ) {\n\t\t\t\treturn val;\n\t\t\t}\n\n\t\t\t// we need the check for style in case a browser which returns unreliable values\n\t\t\t// for getComputedStyle silently falls back to the reliable elem.style\n\t\t\tvalueIsBorderBox = isBorderBox &&\n\t\t\t\t( support.boxSizingReliable() || val === elem.style[ name ] );\n\n\t\t\t// Normalize \"\", auto, and prepare for extra\n\t\t\tval = parseFloat( val ) || 0;\n\t\t}\n\n\t\t// use the active box-sizing model to add/subtract irrelevant styles\n\t\treturn ( val +\n\t\t\t\taugmentWidthOrHeight(\n\t\t\t\t\telem,\n\t\t\t\t\tname,\n\t\t\t\t\textra || ( isBorderBox ? \"border\" : \"content\" ),\n\t\t\t\t\tvalueIsBorderBox,\n\t\t\t\t\tstyles\n\t\t\t\t)\n\t\t\t) + \"px\";\n\t}\n\n\tjQuery.extend( {\n\n\t\t// Add in style property hooks for overriding the default\n\t\t// behavior of getting and setting a style property\n\t\tcssHooks: {\n\t\t\topacity: {\n\t\t\t\tget: function( elem, computed ) {\n\t\t\t\t\tif ( computed ) {\n\n\t\t\t\t\t\t// We should always get a number back from opacity\n\t\t\t\t\t\tvar ret = curCSS( elem, \"opacity\" );\n\t\t\t\t\t\treturn ret === \"\" ? \"1\" : ret;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\t// Don't automatically add \"px\" to these possibly-unitless properties\n\t\tcssNumber: {\n\t\t\t\"animationIterationCount\": true,\n\t\t\t\"columnCount\": true,\n\t\t\t\"fillOpacity\": true,\n\t\t\t\"flexGrow\": true,\n\t\t\t\"flexShrink\": true,\n\t\t\t\"fontWeight\": true,\n\t\t\t\"lineHeight\": true,\n\t\t\t\"opacity\": true,\n\t\t\t\"order\": true,\n\t\t\t\"orphans\": true,\n\t\t\t\"widows\": true,\n\t\t\t\"zIndex\": true,\n\t\t\t\"zoom\": true\n\t\t},\n\n\t\t// Add in properties whose names you wish to fix before\n\t\t// setting or getting the value\n\t\tcssProps: {\n\n\t\t\t// normalize float css property\n\t\t\t\"float\": support.cssFloat ? \"cssFloat\" : \"styleFloat\"\n\t\t},\n\n\t\t// Get and set the style property on a DOM Node\n\t\tstyle: function( elem, name, value, extra ) {\n\n\t\t\t// Don't set styles on text and comment nodes\n\t\t\tif ( !elem || elem.nodeType === 3 || elem.nodeType === 8 || !elem.style ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Make sure that we're working with the right name\n\t\t\tvar ret, type, hooks,\n\t\t\t\torigName = jQuery.camelCase( name ),\n\t\t\t\tstyle = elem.style;\n\n\t\t\tname = jQuery.cssProps[ origName ] ||\n\t\t\t\t( jQuery.cssProps[ origName ] = vendorPropName( origName ) || origName );\n\n\t\t\t// gets hook for the prefixed version\n\t\t\t// followed by the unprefixed version\n\t\t\thooks = jQuery.cssHooks[ name ] || jQuery.cssHooks[ origName ];\n\n\t\t\t// Check if we're setting a value\n\t\t\tif ( value !== undefined ) {\n\t\t\t\ttype = typeof value;\n\n\t\t\t\t// Convert \"+=\" or \"-=\" to relative numbers (#7345)\n\t\t\t\tif ( type === \"string\" && ( ret = rcssNum.exec( value ) ) && ret[ 1 ] ) {\n\t\t\t\t\tvalue = adjustCSS( elem, name, ret );\n\n\t\t\t\t\t// Fixes bug #9237\n\t\t\t\t\ttype = \"number\";\n\t\t\t\t}\n\n\t\t\t\t// Make sure that null and NaN values aren't set. See: #7116\n\t\t\t\tif ( value == null || value !== value ) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\t// If a number was passed in, add the unit (except for certain CSS properties)\n\t\t\t\tif ( type === \"number\" ) {\n\t\t\t\t\tvalue += ret && ret[ 3 ] || ( jQuery.cssNumber[ origName ] ? \"\" : \"px\" );\n\t\t\t\t}\n\n\t\t\t\t// Fixes #8908, it can be done more correctly by specifing setters in cssHooks,\n\t\t\t\t// but it would mean to define eight\n\t\t\t\t// (for every problematic property) identical functions\n\t\t\t\tif ( !support.clearCloneStyle && value === \"\" && name.indexOf( \"background\" ) === 0 ) {\n\t\t\t\t\tstyle[ name ] = \"inherit\";\n\t\t\t\t}\n\n\t\t\t\t// If a hook was provided, use that value, otherwise just set the specified value\n\t\t\t\tif ( !hooks || !( \"set\" in hooks ) ||\n\t\t\t\t\t( value = hooks.set( elem, value, extra ) ) !== undefined ) {\n\n\t\t\t\t\t// Support: IE\n\t\t\t\t\t// Swallow errors from 'invalid' CSS values (#5509)\n\t\t\t\t\ttry {\n\t\t\t\t\t\tstyle[ name ] = value;\n\t\t\t\t\t} catch ( e ) {}\n\t\t\t\t}\n\n\t\t\t} else {\n\n\t\t\t\t// If a hook was provided get the non-computed value from there\n\t\t\t\tif ( hooks && \"get\" in hooks &&\n\t\t\t\t\t( ret = hooks.get( elem, false, extra ) ) !== undefined ) {\n\n\t\t\t\t\treturn ret;\n\t\t\t\t}\n\n\t\t\t\t// Otherwise just get the value from the style object\n\t\t\t\treturn style[ name ];\n\t\t\t}\n\t\t},\n\n\t\tcss: function( elem, name, extra, styles ) {\n\t\t\tvar num, val, hooks,\n\t\t\t\torigName = jQuery.camelCase( name );\n\n\t\t\t// Make sure that we're working with the right name\n\t\t\tname = jQuery.cssProps[ origName ] ||\n\t\t\t\t( jQuery.cssProps[ origName ] = vendorPropName( origName ) || origName );\n\n\t\t\t// gets hook for the prefixed version\n\t\t\t// followed by the unprefixed version\n\t\t\thooks = jQuery.cssHooks[ name ] || jQuery.cssHooks[ origName ];\n\n\t\t\t// If a hook was provided get the computed value from there\n\t\t\tif ( hooks && \"get\" in hooks ) {\n\t\t\t\tval = hooks.get( elem, true, extra );\n\t\t\t}\n\n\t\t\t// Otherwise, if a way to get the computed value exists, use that\n\t\t\tif ( val === undefined ) {\n\t\t\t\tval = curCSS( elem, name, styles );\n\t\t\t}\n\n\t\t\t//convert \"normal\" to computed value\n\t\t\tif ( val === \"normal\" && name in cssNormalTransform ) {\n\t\t\t\tval = cssNormalTransform[ name ];\n\t\t\t}\n\n\t\t\t// Return, converting to number if forced or a qualifier was provided and val looks numeric\n\t\t\tif ( extra === \"\" || extra ) {\n\t\t\t\tnum = parseFloat( val );\n\t\t\t\treturn extra === true || isFinite( num ) ? num || 0 : val;\n\t\t\t}\n\t\t\treturn val;\n\t\t}\n\t} );\n\n\tjQuery.each( [ \"height\", \"width\" ], function( i, name ) {\n\t\tjQuery.cssHooks[ name ] = {\n\t\t\tget: function( elem, computed, extra ) {\n\t\t\t\tif ( computed ) {\n\n\t\t\t\t\t// certain elements can have dimension info if we invisibly show them\n\t\t\t\t\t// however, it must have a current display style that would benefit from this\n\t\t\t\t\treturn rdisplayswap.test( jQuery.css( elem, \"display\" ) ) &&\n\t\t\t\t\telem.offsetWidth === 0 ?\n\t\t\t\t\t\tswap( elem, cssShow, function() {\n\t\t\t\t\t\t\treturn getWidthOrHeight( elem, name, extra );\n\t\t\t\t\t\t} ) :\n\t\t\t\t\t\tgetWidthOrHeight( elem, name, extra );\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tset: function( elem, value, extra ) {\n\t\t\t\tvar styles = extra && getStyles( elem );\n\t\t\t\treturn setPositiveNumber( elem, value, extra ?\n\t\t\t\t\taugmentWidthOrHeight(\n\t\t\t\t\t\telem,\n\t\t\t\t\t\tname,\n\t\t\t\t\t\textra,\n\t\t\t\t\t\tsupport.boxSizing &&\n\t\t\t\t\t\tjQuery.css( elem, \"boxSizing\", false, styles ) === \"border-box\",\n\t\t\t\t\t\tstyles\n\t\t\t\t\t) : 0\n\t\t\t\t);\n\t\t\t}\n\t\t};\n\t} );\n\n\tif ( !support.opacity ) {\n\t\tjQuery.cssHooks.opacity = {\n\t\t\tget: function( elem, computed ) {\n\n\t\t\t\t// IE uses filters for opacity\n\t\t\t\treturn ropacity.test( ( computed && elem.currentStyle ?\n\t\t\t\t\t\telem.currentStyle.filter :\n\t\t\t\t\t\telem.style.filter ) || \"\" ) ?\n\t\t\t\t( 0.01 * parseFloat( RegExp.$1 ) ) + \"\" :\n\t\t\t\t\tcomputed ? \"1\" : \"\";\n\t\t\t},\n\n\t\t\tset: function( elem, value ) {\n\t\t\t\tvar style = elem.style,\n\t\t\t\t\tcurrentStyle = elem.currentStyle,\n\t\t\t\t\topacity = jQuery.isNumeric( value ) ? \"alpha(opacity=\" + value * 100 + \")\" : \"\",\n\t\t\t\t\tfilter = currentStyle && currentStyle.filter || style.filter || \"\";\n\n\t\t\t\t// IE has trouble with opacity if it does not have layout\n\t\t\t\t// Force it by setting the zoom level\n\t\t\t\tstyle.zoom = 1;\n\n\t\t\t\t// if setting opacity to 1, and no other filters exist -\n\t\t\t\t// attempt to remove filter attribute #6652\n\t\t\t\t// if value === \"\", then remove inline opacity #12685\n\t\t\t\tif ( ( value >= 1 || value === \"\" ) &&\n\t\t\t\t\tjQuery.trim( filter.replace( ralpha, \"\" ) ) === \"\" &&\n\t\t\t\t\tstyle.removeAttribute ) {\n\n\t\t\t\t\t// Setting style.filter to null, \"\" & \" \" still leave \"filter:\" in the cssText\n\t\t\t\t\t// if \"filter:\" is present at all, clearType is disabled, we want to avoid this\n\t\t\t\t\t// style.removeAttribute is IE Only, but so apparently is this code path...\n\t\t\t\t\tstyle.removeAttribute( \"filter\" );\n\n\t\t\t\t\t// if there is no filter style applied in a css rule\n\t\t\t\t\t// or unset inline opacity, we are done\n\t\t\t\t\tif ( value === \"\" || currentStyle && !currentStyle.filter ) {\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// otherwise, set new filter values\n\t\t\t\tstyle.filter = ralpha.test( filter ) ?\n\t\t\t\t\tfilter.replace( ralpha, opacity ) :\n\t\t\t\tfilter + \" \" + opacity;\n\t\t\t}\n\t\t};\n\t}\n\n\tjQuery.cssHooks.marginRight = addGetHookIf( support.reliableMarginRight,\n\t\tfunction( elem, computed ) {\n\t\t\tif ( computed ) {\n\t\t\t\treturn swap( elem, { \"display\": \"inline-block\" },\n\t\t\t\t\tcurCSS, [ elem, \"marginRight\" ] );\n\t\t\t}\n\t\t}\n\t);\n\n\tjQuery.cssHooks.marginLeft = addGetHookIf( support.reliableMarginLeft,\n\t\tfunction( elem, computed ) {\n\t\t\tif ( computed ) {\n\t\t\t\treturn (\n\t\t\t\t\t\tparseFloat( curCSS( elem, \"marginLeft\" ) ) ||\n\n\t\t\t\t\t\t// Support: IE<=11+\n\t\t\t\t\t\t// Running getBoundingClientRect on a disconnected node in IE throws an error\n\t\t\t\t\t\t// Support: IE8 only\n\t\t\t\t\t\t// getClientRects() errors on disconnected elems\n\t\t\t\t\t\t( jQuery.contains( elem.ownerDocument, elem ) ?\n\t\t\t\t\t\t\telem.getBoundingClientRect().left -\n\t\t\t\t\t\t\tswap( elem, { marginLeft: 0 }, function() {\n\t\t\t\t\t\t\t\treturn elem.getBoundingClientRect().left;\n\t\t\t\t\t\t\t} ) :\n\t\t\t\t\t\t\t\t0\n\t\t\t\t\t\t)\n\t\t\t\t\t) + \"px\";\n\t\t\t}\n\t\t}\n\t);\n\n// These hooks are used by animate to expand properties\n\tjQuery.each( {\n\t\tmargin: \"\",\n\t\tpadding: \"\",\n\t\tborder: \"Width\"\n\t}, function( prefix, suffix ) {\n\t\tjQuery.cssHooks[ prefix + suffix ] = {\n\t\t\texpand: function( value ) {\n\t\t\t\tvar i = 0,\n\t\t\t\t\texpanded = {},\n\n\t\t\t\t\t// assumes a single number if not a string\n\t\t\t\t\tparts = typeof value === \"string\" ? value.split( \" \" ) : [ value ];\n\n\t\t\t\tfor ( ; i < 4; i++ ) {\n\t\t\t\t\texpanded[ prefix + cssExpand[ i ] + suffix ] =\n\t\t\t\t\t\tparts[ i ] || parts[ i - 2 ] || parts[ 0 ];\n\t\t\t\t}\n\n\t\t\t\treturn expanded;\n\t\t\t}\n\t\t};\n\n\t\tif ( !rmargin.test( prefix ) ) {\n\t\t\tjQuery.cssHooks[ prefix + suffix ].set = setPositiveNumber;\n\t\t}\n\t} );\n\n\tjQuery.fn.extend( {\n\t\tcss: function( name, value ) {\n\t\t\treturn access( this, function( elem, name, value ) {\n\t\t\t\tvar styles, len,\n\t\t\t\t\tmap = {},\n\t\t\t\t\ti = 0;\n\n\t\t\t\tif ( jQuery.isArray( name ) ) {\n\t\t\t\t\tstyles = getStyles( elem );\n\t\t\t\t\tlen = name.length;\n\n\t\t\t\t\tfor ( ; i < len; i++ ) {\n\t\t\t\t\t\tmap[ name[ i ] ] = jQuery.css( elem, name[ i ], false, styles );\n\t\t\t\t\t}\n\n\t\t\t\t\treturn map;\n\t\t\t\t}\n\n\t\t\t\treturn value !== undefined ?\n\t\t\t\t\tjQuery.style( elem, name, value ) :\n\t\t\t\t\tjQuery.css( elem, name );\n\t\t\t}, name, value, arguments.length > 1 );\n\t\t},\n\t\tshow: function() {\n\t\t\treturn showHide( this, true );\n\t\t},\n\t\thide: function() {\n\t\t\treturn showHide( this );\n\t\t},\n\t\ttoggle: function( state ) {\n\t\t\tif ( typeof state === \"boolean\" ) {\n\t\t\t\treturn state ? this.show() : this.hide();\n\t\t\t}\n\n\t\t\treturn this.each( function() {\n\t\t\t\tif ( isHidden( this ) ) {\n\t\t\t\t\tjQuery( this ).show();\n\t\t\t\t} else {\n\t\t\t\t\tjQuery( this ).hide();\n\t\t\t\t}\n\t\t\t} );\n\t\t}\n\t} );\n\n\n\tfunction Tween( elem, options, prop, end, easing ) {\n\t\treturn new Tween.prototype.init( elem, options, prop, end, easing );\n\t}\n\tjQuery.Tween = Tween;\n\n\tTween.prototype = {\n\t\tconstructor: Tween,\n\t\tinit: function( elem, options, prop, end, easing, unit ) {\n\t\t\tthis.elem = elem;\n\t\t\tthis.prop = prop;\n\t\t\tthis.easing = easing || jQuery.easing._default;\n\t\t\tthis.options = options;\n\t\t\tthis.start = this.now = this.cur();\n\t\t\tthis.end = end;\n\t\t\tthis.unit = unit || ( jQuery.cssNumber[ prop ] ? \"\" : \"px\" );\n\t\t},\n\t\tcur: function() {\n\t\t\tvar hooks = Tween.propHooks[ this.prop ];\n\n\t\t\treturn hooks && hooks.get ?\n\t\t\t\thooks.get( this ) :\n\t\t\t\tTween.propHooks._default.get( this );\n\t\t},\n\t\trun: function( percent ) {\n\t\t\tvar eased,\n\t\t\t\thooks = Tween.propHooks[ this.prop ];\n\n\t\t\tif ( this.options.duration ) {\n\t\t\t\tthis.pos = eased = jQuery.easing[ this.easing ](\n\t\t\t\t\tpercent, this.options.duration * percent, 0, 1, this.options.duration\n\t\t\t\t);\n\t\t\t} else {\n\t\t\t\tthis.pos = eased = percent;\n\t\t\t}\n\t\t\tthis.now = ( this.end - this.start ) * eased + this.start;\n\n\t\t\tif ( this.options.step ) {\n\t\t\t\tthis.options.step.call( this.elem, this.now, this );\n\t\t\t}\n\n\t\t\tif ( hooks && hooks.set ) {\n\t\t\t\thooks.set( this );\n\t\t\t} else {\n\t\t\t\tTween.propHooks._default.set( this );\n\t\t\t}\n\t\t\treturn this;\n\t\t}\n\t};\n\n\tTween.prototype.init.prototype = Tween.prototype;\n\n\tTween.propHooks = {\n\t\t_default: {\n\t\t\tget: function( tween ) {\n\t\t\t\tvar result;\n\n\t\t\t\t// Use a property on the element directly when it is not a DOM element,\n\t\t\t\t// or when there is no matching style property that exists.\n\t\t\t\tif ( tween.elem.nodeType !== 1 ||\n\t\t\t\t\ttween.elem[ tween.prop ] != null && tween.elem.style[ tween.prop ] == null ) {\n\t\t\t\t\treturn tween.elem[ tween.prop ];\n\t\t\t\t}\n\n\t\t\t\t// passing an empty string as a 3rd parameter to .css will automatically\n\t\t\t\t// attempt a parseFloat and fallback to a string if the parse fails\n\t\t\t\t// so, simple values such as \"10px\" are parsed to Float.\n\t\t\t\t// complex values such as \"rotate(1rad)\" are returned as is.\n\t\t\t\tresult = jQuery.css( tween.elem, tween.prop, \"\" );\n\n\t\t\t\t// Empty strings, null, undefined and \"auto\" are converted to 0.\n\t\t\t\treturn !result || result === \"auto\" ? 0 : result;\n\t\t\t},\n\t\t\tset: function( tween ) {\n\n\t\t\t\t// use step hook for back compat - use cssHook if its there - use .style if its\n\t\t\t\t// available and use plain properties where available\n\t\t\t\tif ( jQuery.fx.step[ tween.prop ] ) {\n\t\t\t\t\tjQuery.fx.step[ tween.prop ]( tween );\n\t\t\t\t} else if ( tween.elem.nodeType === 1 &&\n\t\t\t\t\t( tween.elem.style[ jQuery.cssProps[ tween.prop ] ] != null ||\n\t\t\t\t\tjQuery.cssHooks[ tween.prop ] ) ) {\n\t\t\t\t\tjQuery.style( tween.elem, tween.prop, tween.now + tween.unit );\n\t\t\t\t} else {\n\t\t\t\t\ttween.elem[ tween.prop ] = tween.now;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t};\n\n// Support: IE <=9\n// Panic based approach to setting things on disconnected nodes\n\n\tTween.propHooks.scrollTop = Tween.propHooks.scrollLeft = {\n\t\tset: function( tween ) {\n\t\t\tif ( tween.elem.nodeType && tween.elem.parentNode ) {\n\t\t\t\ttween.elem[ tween.prop ] = tween.now;\n\t\t\t}\n\t\t}\n\t};\n\n\tjQuery.easing = {\n\t\tlinear: function( p ) {\n\t\t\treturn p;\n\t\t},\n\t\tswing: function( p ) {\n\t\t\treturn 0.5 - Math.cos( p * Math.PI ) / 2;\n\t\t},\n\t\t_default: \"swing\"\n\t};\n\n\tjQuery.fx = Tween.prototype.init;\n\n// Back Compat <1.8 extension point\n\tjQuery.fx.step = {};\n\n\n\n\n\tvar\n\t\tfxNow, timerId,\n\t\trfxtypes = /^(?:toggle|show|hide)$/,\n\t\trrun = /queueHooks$/;\n\n// Animations created synchronously will run synchronously\n\tfunction createFxNow() {\n\t\twindow.setTimeout( function() {\n\t\t\tfxNow = undefined;\n\t\t} );\n\t\treturn ( fxNow = jQuery.now() );\n\t}\n\n// Generate parameters to create a standard animation\n\tfunction genFx( type, includeWidth ) {\n\t\tvar which,\n\t\t\tattrs = { height: type },\n\t\t\ti = 0;\n\n\t\t// if we include width, step value is 1 to do all cssExpand values,\n\t\t// if we don't include width, step value is 2 to skip over Left and Right\n\t\tincludeWidth = includeWidth ? 1 : 0;\n\t\tfor ( ; i < 4 ; i += 2 - includeWidth ) {\n\t\t\twhich = cssExpand[ i ];\n\t\t\tattrs[ \"margin\" + which ] = attrs[ \"padding\" + which ] = type;\n\t\t}\n\n\t\tif ( includeWidth ) {\n\t\t\tattrs.opacity = attrs.width = type;\n\t\t}\n\n\t\treturn attrs;\n\t}\n\n\tfunction createTween( value, prop, animation ) {\n\t\tvar tween,\n\t\t\tcollection = ( Animation.tweeners[ prop ] || [] ).concat( Animation.tweeners[ \"*\" ] ),\n\t\t\tindex = 0,\n\t\t\tlength = collection.length;\n\t\tfor ( ; index < length; index++ ) {\n\t\t\tif ( ( tween = collection[ index ].call( animation, prop, value ) ) ) {\n\n\t\t\t\t// we're done with this property\n\t\t\t\treturn tween;\n\t\t\t}\n\t\t}\n\t}\n\n\tfunction defaultPrefilter( elem, props, opts ) {\n\t\t/* jshint validthis: true */\n\t\tvar prop, value, toggle, tween, hooks, oldfire, display, checkDisplay,\n\t\t\tanim = this,\n\t\t\torig = {},\n\t\t\tstyle = elem.style,\n\t\t\thidden = elem.nodeType && isHidden( elem ),\n\t\t\tdataShow = jQuery._data( elem, \"fxshow\" );\n\n\t\t// handle queue: false promises\n\t\tif ( !opts.queue ) {\n\t\t\thooks = jQuery._queueHooks( elem, \"fx\" );\n\t\t\tif ( hooks.unqueued == null ) {\n\t\t\t\thooks.unqueued = 0;\n\t\t\t\toldfire = hooks.empty.fire;\n\t\t\t\thooks.empty.fire = function() {\n\t\t\t\t\tif ( !hooks.unqueued ) {\n\t\t\t\t\t\toldfire();\n\t\t\t\t\t}\n\t\t\t\t};\n\t\t\t}\n\t\t\thooks.unqueued++;\n\n\t\t\tanim.always( function() {\n\n\t\t\t\t// doing this makes sure that the complete handler will be called\n\t\t\t\t// before this completes\n\t\t\t\tanim.always( function() {\n\t\t\t\t\thooks.unqueued--;\n\t\t\t\t\tif ( !jQuery.queue( elem, \"fx\" ).length ) {\n\t\t\t\t\t\thooks.empty.fire();\n\t\t\t\t\t}\n\t\t\t\t} );\n\t\t\t} );\n\t\t}\n\n\t\t// height/width overflow pass\n\t\tif ( elem.nodeType === 1 && ( \"height\" in props || \"width\" in props ) ) {\n\n\t\t\t// Make sure that nothing sneaks out\n\t\t\t// Record all 3 overflow attributes because IE does not\n\t\t\t// change the overflow attribute when overflowX and\n\t\t\t// overflowY are set to the same value\n\t\t\topts.overflow = [ style.overflow, style.overflowX, style.overflowY ];\n\n\t\t\t// Set display property to inline-block for height/width\n\t\t\t// animations on inline elements that are having width/height animated\n\t\t\tdisplay = jQuery.css( elem, \"display\" );\n\n\t\t\t// Test default display if display is currently \"none\"\n\t\t\tcheckDisplay = display === \"none\" ?\n\t\t\tjQuery._data( elem, \"olddisplay\" ) || defaultDisplay( elem.nodeName ) : display;\n\n\t\t\tif ( checkDisplay === \"inline\" && jQuery.css( elem, \"float\" ) === \"none\" ) {\n\n\t\t\t\t// inline-level elements accept inline-block;\n\t\t\t\t// block-level elements need to be inline with layout\n\t\t\t\tif ( !support.inlineBlockNeedsLayout || defaultDisplay( elem.nodeName ) === \"inline\" ) {\n\t\t\t\t\tstyle.display = \"inline-block\";\n\t\t\t\t} else {\n\t\t\t\t\tstyle.zoom = 1;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\tif ( opts.overflow ) {\n\t\t\tstyle.overflow = \"hidden\";\n\t\t\tif ( !support.shrinkWrapBlocks() ) {\n\t\t\t\tanim.always( function() {\n\t\t\t\t\tstyle.overflow = opts.overflow[ 0 ];\n\t\t\t\t\tstyle.overflowX = opts.overflow[ 1 ];\n\t\t\t\t\tstyle.overflowY = opts.overflow[ 2 ];\n\t\t\t\t} );\n\t\t\t}\n\t\t}\n\n\t\t// show/hide pass\n\t\tfor ( prop in props ) {\n\t\t\tvalue = props[ prop ];\n\t\t\tif ( rfxtypes.exec( value ) ) {\n\t\t\t\tdelete props[ prop ];\n\t\t\t\ttoggle = toggle || value === \"toggle\";\n\t\t\t\tif ( value === ( hidden ? \"hide\" : \"show\" ) ) {\n\n\t\t\t\t\t// If there is dataShow left over from a stopped hide or show\n\t\t\t\t\t// and we are going to proceed with show, we should pretend to be hidden\n\t\t\t\t\tif ( value === \"show\" && dataShow && dataShow[ prop ] !== undefined ) {\n\t\t\t\t\t\thidden = true;\n\t\t\t\t\t} else {\n\t\t\t\t\t\tcontinue;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\torig[ prop ] = dataShow && dataShow[ prop ] || jQuery.style( elem, prop );\n\n\t\t\t\t// Any non-fx value stops us from restoring the original display value\n\t\t\t} else {\n\t\t\t\tdisplay = undefined;\n\t\t\t}\n\t\t}\n\n\t\tif ( !jQuery.isEmptyObject( orig ) ) {\n\t\t\tif ( dataShow ) {\n\t\t\t\tif ( \"hidden\" in dataShow ) {\n\t\t\t\t\thidden = dataShow.hidden;\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\tdataShow = jQuery._data( elem, \"fxshow\", {} );\n\t\t\t}\n\n\t\t\t// store state if its toggle - enables .stop().toggle() to \"reverse\"\n\t\t\tif ( toggle ) {\n\t\t\t\tdataShow.hidden = !hidden;\n\t\t\t}\n\t\t\tif ( hidden ) {\n\t\t\t\tjQuery( elem ).show();\n\t\t\t} else {\n\t\t\t\tanim.done( function() {\n\t\t\t\t\tjQuery( elem ).hide();\n\t\t\t\t} );\n\t\t\t}\n\t\t\tanim.done( function() {\n\t\t\t\tvar prop;\n\t\t\t\tjQuery._removeData( elem, \"fxshow\" );\n\t\t\t\tfor ( prop in orig ) {\n\t\t\t\t\tjQuery.style( elem, prop, orig[ prop ] );\n\t\t\t\t}\n\t\t\t} );\n\t\t\tfor ( prop in orig ) {\n\t\t\t\ttween = createTween( hidden ? dataShow[ prop ] : 0, prop, anim );\n\n\t\t\t\tif ( !( prop in dataShow ) ) {\n\t\t\t\t\tdataShow[ prop ] = tween.start;\n\t\t\t\t\tif ( hidden ) {\n\t\t\t\t\t\ttween.end = tween.start;\n\t\t\t\t\t\ttween.start = prop === \"width\" || prop === \"height\" ? 1 : 0;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// If this is a noop like .hide().hide(), restore an overwritten display value\n\t\t} else if ( ( display === \"none\" ? defaultDisplay( elem.nodeName ) : display ) === \"inline\" ) {\n\t\t\tstyle.display = display;\n\t\t}\n\t}\n\n\tfunction propFilter( props, specialEasing ) {\n\t\tvar index, name, easing, value, hooks;\n\n\t\t// camelCase, specialEasing and expand cssHook pass\n\t\tfor ( index in props ) {\n\t\t\tname = jQuery.camelCase( index );\n\t\t\teasing = specialEasing[ name ];\n\t\t\tvalue = props[ index ];\n\t\t\tif ( jQuery.isArray( value ) ) {\n\t\t\t\teasing = value[ 1 ];\n\t\t\t\tvalue = props[ index ] = value[ 0 ];\n\t\t\t}\n\n\t\t\tif ( index !== name ) {\n\t\t\t\tprops[ name ] = value;\n\t\t\t\tdelete props[ index ];\n\t\t\t}\n\n\t\t\thooks = jQuery.cssHooks[ name ];\n\t\t\tif ( hooks && \"expand\" in hooks ) {\n\t\t\t\tvalue = hooks.expand( value );\n\t\t\t\tdelete props[ name ];\n\n\t\t\t\t// not quite $.extend, this won't overwrite keys already present.\n\t\t\t\t// also - reusing 'index' from above because we have the correct \"name\"\n\t\t\t\tfor ( index in value ) {\n\t\t\t\t\tif ( !( index in props ) ) {\n\t\t\t\t\t\tprops[ index ] = value[ index ];\n\t\t\t\t\t\tspecialEasing[ index ] = easing;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\tspecialEasing[ name ] = easing;\n\t\t\t}\n\t\t}\n\t}\n\n\tfunction Animation( elem, properties, options ) {\n\t\tvar result,\n\t\t\tstopped,\n\t\t\tindex = 0,\n\t\t\tlength = Animation.prefilters.length,\n\t\t\tdeferred = jQuery.Deferred().always( function() {\n\n\t\t\t\t// don't match elem in the :animated selector\n\t\t\t\tdelete tick.elem;\n\t\t\t} ),\n\t\t\ttick = function() {\n\t\t\t\tif ( stopped ) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\tvar currentTime = fxNow || createFxNow(),\n\t\t\t\t\tremaining = Math.max( 0, animation.startTime + animation.duration - currentTime ),\n\n\t\t\t\t\t// Support: Android 2.3\n\t\t\t\t\t// Archaic crash bug won't allow us to use `1 - ( 0.5 || 0 )` (#12497)\n\t\t\t\t\ttemp = remaining / animation.duration || 0,\n\t\t\t\t\tpercent = 1 - temp,\n\t\t\t\t\tindex = 0,\n\t\t\t\t\tlength = animation.tweens.length;\n\n\t\t\t\tfor ( ; index < length ; index++ ) {\n\t\t\t\t\tanimation.tweens[ index ].run( percent );\n\t\t\t\t}\n\n\t\t\t\tdeferred.notifyWith( elem, [ animation, percent, remaining ] );\n\n\t\t\t\tif ( percent < 1 && length ) {\n\t\t\t\t\treturn remaining;\n\t\t\t\t} else {\n\t\t\t\t\tdeferred.resolveWith( elem, [ animation ] );\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t},\n\t\t\tanimation = deferred.promise( {\n\t\t\t\telem: elem,\n\t\t\t\tprops: jQuery.extend( {}, properties ),\n\t\t\t\topts: jQuery.extend( true, {\n\t\t\t\t\tspecialEasing: {},\n\t\t\t\t\teasing: jQuery.easing._default\n\t\t\t\t}, options ),\n\t\t\t\toriginalProperties: properties,\n\t\t\t\toriginalOptions: options,\n\t\t\t\tstartTime: fxNow || createFxNow(),\n\t\t\t\tduration: options.duration,\n\t\t\t\ttweens: [],\n\t\t\t\tcreateTween: function( prop, end ) {\n\t\t\t\t\tvar tween = jQuery.Tween( elem, animation.opts, prop, end,\n\t\t\t\t\t\tanimation.opts.specialEasing[ prop ] || animation.opts.easing );\n\t\t\t\t\tanimation.tweens.push( tween );\n\t\t\t\t\treturn tween;\n\t\t\t\t},\n\t\t\t\tstop: function( gotoEnd ) {\n\t\t\t\t\tvar index = 0,\n\n\t\t\t\t\t\t// if we are going to the end, we want to run all the tweens\n\t\t\t\t\t\t// otherwise we skip this part\n\t\t\t\t\t\tlength = gotoEnd ? animation.tweens.length : 0;\n\t\t\t\t\tif ( stopped ) {\n\t\t\t\t\t\treturn this;\n\t\t\t\t\t}\n\t\t\t\t\tstopped = true;\n\t\t\t\t\tfor ( ; index < length ; index++ ) {\n\t\t\t\t\t\tanimation.tweens[ index ].run( 1 );\n\t\t\t\t\t}\n\n\t\t\t\t\t// resolve when we played the last frame\n\t\t\t\t\t// otherwise, reject\n\t\t\t\t\tif ( gotoEnd ) {\n\t\t\t\t\t\tdeferred.notifyWith( elem, [ animation, 1, 0 ] );\n\t\t\t\t\t\tdeferred.resolveWith( elem, [ animation, gotoEnd ] );\n\t\t\t\t\t} else {\n\t\t\t\t\t\tdeferred.rejectWith( elem, [ animation, gotoEnd ] );\n\t\t\t\t\t}\n\t\t\t\t\treturn this;\n\t\t\t\t}\n\t\t\t} ),\n\t\t\tprops = animation.props;\n\n\t\tpropFilter( props, animation.opts.specialEasing );\n\n\t\tfor ( ; index < length ; index++ ) {\n\t\t\tresult = Animation.prefilters[ index ].call( animation, elem, props, animation.opts );\n\t\t\tif ( result ) {\n\t\t\t\tif ( jQuery.isFunction( result.stop ) ) {\n\t\t\t\t\tjQuery._queueHooks( animation.elem, animation.opts.queue ).stop =\n\t\t\t\t\t\tjQuery.proxy( result.stop, result );\n\t\t\t\t}\n\t\t\t\treturn result;\n\t\t\t}\n\t\t}\n\n\t\tjQuery.map( props, createTween, animation );\n\n\t\tif ( jQuery.isFunction( animation.opts.start ) ) {\n\t\t\tanimation.opts.start.call( elem, animation );\n\t\t}\n\n\t\tjQuery.fx.timer(\n\t\t\tjQuery.extend( tick, {\n\t\t\t\telem: elem,\n\t\t\t\tanim: animation,\n\t\t\t\tqueue: animation.opts.queue\n\t\t\t} )\n\t\t);\n\n\t\t// attach callbacks from options\n\t\treturn animation.progress( animation.opts.progress )\n\t\t\t.done( animation.opts.done, animation.opts.complete )\n\t\t\t.fail( animation.opts.fail )\n\t\t\t.always( animation.opts.always );\n\t}\n\n\tjQuery.Animation = jQuery.extend( Animation, {\n\n\t\ttweeners: {\n\t\t\t\"*\": [ function( prop, value ) {\n\t\t\t\tvar tween = this.createTween( prop, value );\n\t\t\t\tadjustCSS( tween.elem, prop, rcssNum.exec( value ), tween );\n\t\t\t\treturn tween;\n\t\t\t} ]\n\t\t},\n\n\t\ttweener: function( props, callback ) {\n\t\t\tif ( jQuery.isFunction( props ) ) {\n\t\t\t\tcallback = props;\n\t\t\t\tprops = [ \"*\" ];\n\t\t\t} else {\n\t\t\t\tprops = props.match( rnotwhite );\n\t\t\t}\n\n\t\t\tvar prop,\n\t\t\t\tindex = 0,\n\t\t\t\tlength = props.length;\n\n\t\t\tfor ( ; index < length ; index++ ) {\n\t\t\t\tprop = props[ index ];\n\t\t\t\tAnimation.tweeners[ prop ] = Animation.tweeners[ prop ] || [];\n\t\t\t\tAnimation.tweeners[ prop ].unshift( callback );\n\t\t\t}\n\t\t},\n\n\t\tprefilters: [ defaultPrefilter ],\n\n\t\tprefilter: function( callback, prepend ) {\n\t\t\tif ( prepend ) {\n\t\t\t\tAnimation.prefilters.unshift( callback );\n\t\t\t} else {\n\t\t\t\tAnimation.prefilters.push( callback );\n\t\t\t}\n\t\t}\n\t} );\n\n\tjQuery.speed = function( speed, easing, fn ) {\n\t\tvar opt = speed && typeof speed === \"object\" ? jQuery.extend( {}, speed ) : {\n\t\t\tcomplete: fn || !fn && easing ||\n\t\t\tjQuery.isFunction( speed ) && speed,\n\t\t\tduration: speed,\n\t\t\teasing: fn && easing || easing && !jQuery.isFunction( easing ) && easing\n\t\t};\n\n\t\topt.duration = jQuery.fx.off ? 0 : typeof opt.duration === \"number\" ? opt.duration :\n\t\t\topt.duration in jQuery.fx.speeds ?\n\t\t\t\tjQuery.fx.speeds[ opt.duration ] : jQuery.fx.speeds._default;\n\n\t\t// normalize opt.queue - true/undefined/null -> \"fx\"\n\t\tif ( opt.queue == null || opt.queue === true ) {\n\t\t\topt.queue = \"fx\";\n\t\t}\n\n\t\t// Queueing\n\t\topt.old = opt.complete;\n\n\t\topt.complete = function() {\n\t\t\tif ( jQuery.isFunction( opt.old ) ) {\n\t\t\t\topt.old.call( this );\n\t\t\t}\n\n\t\t\tif ( opt.queue ) {\n\t\t\t\tjQuery.dequeue( this, opt.queue );\n\t\t\t}\n\t\t};\n\n\t\treturn opt;\n\t};\n\n\tjQuery.fn.extend( {\n\t\tfadeTo: function( speed, to, easing, callback ) {\n\n\t\t\t// show any hidden elements after setting opacity to 0\n\t\t\treturn this.filter( isHidden ).css( \"opacity\", 0 ).show()\n\n\t\t\t// animate to the value specified\n\t\t\t\t.end().animate( { opacity: to }, speed, easing, callback );\n\t\t},\n\t\tanimate: function( prop, speed, easing, callback ) {\n\t\t\tvar empty = jQuery.isEmptyObject( prop ),\n\t\t\t\toptall = jQuery.speed( speed, easing, callback ),\n\t\t\t\tdoAnimation = function() {\n\n\t\t\t\t\t// Operate on a copy of prop so per-property easing won't be lost\n\t\t\t\t\tvar anim = Animation( this, jQuery.extend( {}, prop ), optall );\n\n\t\t\t\t\t// Empty animations, or finishing resolves immediately\n\t\t\t\t\tif ( empty || jQuery._data( this, \"finish\" ) ) {\n\t\t\t\t\t\tanim.stop( true );\n\t\t\t\t\t}\n\t\t\t\t};\n\t\t\tdoAnimation.finish = doAnimation;\n\n\t\t\treturn empty || optall.queue === false ?\n\t\t\t\tthis.each( doAnimation ) :\n\t\t\t\tthis.queue( optall.queue, doAnimation );\n\t\t},\n\t\tstop: function( type, clearQueue, gotoEnd ) {\n\t\t\tvar stopQueue = function( hooks ) {\n\t\t\t\tvar stop = hooks.stop;\n\t\t\t\tdelete hooks.stop;\n\t\t\t\tstop( gotoEnd );\n\t\t\t};\n\n\t\t\tif ( typeof type !== \"string\" ) {\n\t\t\t\tgotoEnd = clearQueue;\n\t\t\t\tclearQueue = type;\n\t\t\t\ttype = undefined;\n\t\t\t}\n\t\t\tif ( clearQueue && type !== false ) {\n\t\t\t\tthis.queue( type || \"fx\", [] );\n\t\t\t}\n\n\t\t\treturn this.each( function() {\n\t\t\t\tvar dequeue = true,\n\t\t\t\t\tindex = type != null && type + \"queueHooks\",\n\t\t\t\t\ttimers = jQuery.timers,\n\t\t\t\t\tdata = jQuery._data( this );\n\n\t\t\t\tif ( index ) {\n\t\t\t\t\tif ( data[ index ] && data[ index ].stop ) {\n\t\t\t\t\t\tstopQueue( data[ index ] );\n\t\t\t\t\t}\n\t\t\t\t} else {\n\t\t\t\t\tfor ( index in data ) {\n\t\t\t\t\t\tif ( data[ index ] && data[ index ].stop && rrun.test( index ) ) {\n\t\t\t\t\t\t\tstopQueue( data[ index ] );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tfor ( index = timers.length; index--; ) {\n\t\t\t\t\tif ( timers[ index ].elem === this &&\n\t\t\t\t\t\t( type == null || timers[ index ].queue === type ) ) {\n\n\t\t\t\t\t\ttimers[ index ].anim.stop( gotoEnd );\n\t\t\t\t\t\tdequeue = false;\n\t\t\t\t\t\ttimers.splice( index, 1 );\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// start the next in the queue if the last step wasn't forced\n\t\t\t\t// timers currently will call their complete callbacks, which will dequeue\n\t\t\t\t// but only if they were gotoEnd\n\t\t\t\tif ( dequeue || !gotoEnd ) {\n\t\t\t\t\tjQuery.dequeue( this, type );\n\t\t\t\t}\n\t\t\t} );\n\t\t},\n\t\tfinish: function( type ) {\n\t\t\tif ( type !== false ) {\n\t\t\t\ttype = type || \"fx\";\n\t\t\t}\n\t\t\treturn this.each( function() {\n\t\t\t\tvar index,\n\t\t\t\t\tdata = jQuery._data( this ),\n\t\t\t\t\tqueue = data[ type + \"queue\" ],\n\t\t\t\t\thooks = data[ type + \"queueHooks\" ],\n\t\t\t\t\ttimers = jQuery.timers,\n\t\t\t\t\tlength = queue ? queue.length : 0;\n\n\t\t\t\t// enable finishing flag on private data\n\t\t\t\tdata.finish = true;\n\n\t\t\t\t// empty the queue first\n\t\t\t\tjQuery.queue( this, type, [] );\n\n\t\t\t\tif ( hooks && hooks.stop ) {\n\t\t\t\t\thooks.stop.call( this, true );\n\t\t\t\t}\n\n\t\t\t\t// look for any active animations, and finish them\n\t\t\t\tfor ( index = timers.length; index--; ) {\n\t\t\t\t\tif ( timers[ index ].elem === this && timers[ index ].queue === type ) {\n\t\t\t\t\t\ttimers[ index ].anim.stop( true );\n\t\t\t\t\t\ttimers.splice( index, 1 );\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// look for any animations in the old queue and finish them\n\t\t\t\tfor ( index = 0; index < length; index++ ) {\n\t\t\t\t\tif ( queue[ index ] && queue[ index ].finish ) {\n\t\t\t\t\t\tqueue[ index ].finish.call( this );\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// turn off finishing flag\n\t\t\t\tdelete data.finish;\n\t\t\t} );\n\t\t}\n\t} );\n\n\tjQuery.each( [ \"toggle\", \"show\", \"hide\" ], function( i, name ) {\n\t\tvar cssFn = jQuery.fn[ name ];\n\t\tjQuery.fn[ name ] = function( speed, easing, callback ) {\n\t\t\treturn speed == null || typeof speed === \"boolean\" ?\n\t\t\t\tcssFn.apply( this, arguments ) :\n\t\t\t\tthis.animate( genFx( name, true ), speed, easing, callback );\n\t\t};\n\t} );\n\n// Generate shortcuts for custom animations\n\tjQuery.each( {\n\t\tslideDown: genFx( \"show\" ),\n\t\tslideUp: genFx( \"hide\" ),\n\t\tslideToggle: genFx( \"toggle\" ),\n\t\tfadeIn: { opacity: \"show\" },\n\t\tfadeOut: { opacity: \"hide\" },\n\t\tfadeToggle: { opacity: \"toggle\" }\n\t}, function( name, props ) {\n\t\tjQuery.fn[ name ] = function( speed, easing, callback ) {\n\t\t\treturn this.animate( props, speed, easing, callback );\n\t\t};\n\t} );\n\n\tjQuery.timers = [];\n\tjQuery.fx.tick = function() {\n\t\tvar timer,\n\t\t\ttimers = jQuery.timers,\n\t\t\ti = 0;\n\n\t\tfxNow = jQuery.now();\n\n\t\tfor ( ; i < timers.length; i++ ) {\n\t\t\ttimer = timers[ i ];\n\n\t\t\t// Checks the timer has not already been removed\n\t\t\tif ( !timer() && timers[ i ] === timer ) {\n\t\t\t\ttimers.splice( i--, 1 );\n\t\t\t}\n\t\t}\n\n\t\tif ( !timers.length ) {\n\t\t\tjQuery.fx.stop();\n\t\t}\n\t\tfxNow = undefined;\n\t};\n\n\tjQuery.fx.timer = function( timer ) {\n\t\tjQuery.timers.push( timer );\n\t\tif ( timer() ) {\n\t\t\tjQuery.fx.start();\n\t\t} else {\n\t\t\tjQuery.timers.pop();\n\t\t}\n\t};\n\n\tjQuery.fx.interval = 13;\n\n\tjQuery.fx.start = function() {\n\t\tif ( !timerId ) {\n\t\t\ttimerId = window.setInterval( jQuery.fx.tick, jQuery.fx.interval );\n\t\t}\n\t};\n\n\tjQuery.fx.stop = function() {\n\t\twindow.clearInterval( timerId );\n\t\ttimerId = null;\n\t};\n\n\tjQuery.fx.speeds = {\n\t\tslow: 600,\n\t\tfast: 200,\n\n\t\t// Default speed\n\t\t_default: 400\n\t};\n\n\n// Based off of the plugin by Clint Helfers, with permission.\n// http://web.archive.org/web/20100324014747/http://blindsignals.com/index.php/2009/07/jquery-delay/\n\tjQuery.fn.delay = function( time, type ) {\n\t\ttime = jQuery.fx ? jQuery.fx.speeds[ time ] || time : time;\n\t\ttype = type || \"fx\";\n\n\t\treturn this.queue( type, function( next, hooks ) {\n\t\t\tvar timeout = window.setTimeout( next, time );\n\t\t\thooks.stop = function() {\n\t\t\t\twindow.clearTimeout( timeout );\n\t\t\t};\n\t\t} );\n\t};\n\n\n\t( function() {\n\t\tvar a,\n\t\t\tinput = document.createElement( \"input\" ),\n\t\t\tdiv = document.createElement( \"div\" ),\n\t\t\tselect = document.createElement( \"select\" ),\n\t\t\topt = select.appendChild( document.createElement( \"option\" ) );\n\n\t\t// Setup\n\t\tdiv = document.createElement( \"div\" );\n\t\tdiv.setAttribute( \"className\", \"t\" );\n\t\tdiv.innerHTML = \"  <link/><table></table><a href='/a'>a</a><input type='checkbox'/>\";\n\t\ta = div.getElementsByTagName( \"a\" )[ 0 ];\n\n\t\t// Support: Windows Web Apps (WWA)\n\t\t// `type` must use .setAttribute for WWA (#14901)\n\t\tinput.setAttribute( \"type\", \"checkbox\" );\n\t\tdiv.appendChild( input );\n\n\t\ta = div.getElementsByTagName( \"a\" )[ 0 ];\n\n\t\t// First batch of tests.\n\t\ta.style.cssText = \"top:1px\";\n\n\t\t// Test setAttribute on camelCase class.\n\t\t// If it works, we need attrFixes when doing get/setAttribute (ie6/7)\n\t\tsupport.getSetAttribute = div.className !== \"t\";\n\n\t\t// Get the style information from getAttribute\n\t\t// (IE uses .cssText instead)\n\t\tsupport.style = /top/.test( a.getAttribute( \"style\" ) );\n\n\t\t// Make sure that URLs aren't manipulated\n\t\t// (IE normalizes it by default)\n\t\tsupport.hrefNormalized = a.getAttribute( \"href\" ) === \"/a\";\n\n\t\t// Check the default checkbox/radio value (\"\" on WebKit; \"on\" elsewhere)\n\t\tsupport.checkOn = !!input.value;\n\n\t\t// Make sure that a selected-by-default option has a working selected property.\n\t\t// (WebKit defaults to false instead of true, IE too, if it's in an optgroup)\n\t\tsupport.optSelected = opt.selected;\n\n\t\t// Tests for enctype support on a form (#6743)\n\t\tsupport.enctype = !!document.createElement( \"form\" ).enctype;\n\n\t\t// Make sure that the options inside disabled selects aren't marked as disabled\n\t\t// (WebKit marks them as disabled)\n\t\tselect.disabled = true;\n\t\tsupport.optDisabled = !opt.disabled;\n\n\t\t// Support: IE8 only\n\t\t// Check if we can trust getAttribute(\"value\")\n\t\tinput = document.createElement( \"input\" );\n\t\tinput.setAttribute( \"value\", \"\" );\n\t\tsupport.input = input.getAttribute( \"value\" ) === \"\";\n\n\t\t// Check if an input maintains its value after becoming a radio\n\t\tinput.value = \"t\";\n\t\tinput.setAttribute( \"type\", \"radio\" );\n\t\tsupport.radioValue = input.value === \"t\";\n\t} )();\n\n\n\tvar rreturn = /\\r/g,\n\t\trspaces = /[\\x20\\t\\r\\n\\f]+/g;\n\n\tjQuery.fn.extend( {\n\t\tval: function( value ) {\n\t\t\tvar hooks, ret, isFunction,\n\t\t\t\telem = this[ 0 ];\n\n\t\t\tif ( !arguments.length ) {\n\t\t\t\tif ( elem ) {\n\t\t\t\t\thooks = jQuery.valHooks[ elem.type ] ||\n\t\t\t\t\t\tjQuery.valHooks[ elem.nodeName.toLowerCase() ];\n\n\t\t\t\t\tif (\n\t\t\t\t\t\thooks &&\n\t\t\t\t\t\t\"get\" in hooks &&\n\t\t\t\t\t\t( ret = hooks.get( elem, \"value\" ) ) !== undefined\n\t\t\t\t\t) {\n\t\t\t\t\t\treturn ret;\n\t\t\t\t\t}\n\n\t\t\t\t\tret = elem.value;\n\n\t\t\t\t\treturn typeof ret === \"string\" ?\n\n\t\t\t\t\t\t// handle most common string cases\n\t\t\t\t\t\tret.replace( rreturn, \"\" ) :\n\n\t\t\t\t\t\t// handle cases where value is null/undef or number\n\t\t\t\t\t\tret == null ? \"\" : ret;\n\t\t\t\t}\n\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tisFunction = jQuery.isFunction( value );\n\n\t\t\treturn this.each( function( i ) {\n\t\t\t\tvar val;\n\n\t\t\t\tif ( this.nodeType !== 1 ) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tif ( isFunction ) {\n\t\t\t\t\tval = value.call( this, i, jQuery( this ).val() );\n\t\t\t\t} else {\n\t\t\t\t\tval = value;\n\t\t\t\t}\n\n\t\t\t\t// Treat null/undefined as \"\"; convert numbers to string\n\t\t\t\tif ( val == null ) {\n\t\t\t\t\tval = \"\";\n\t\t\t\t} else if ( typeof val === \"number\" ) {\n\t\t\t\t\tval += \"\";\n\t\t\t\t} else if ( jQuery.isArray( val ) ) {\n\t\t\t\t\tval = jQuery.map( val, function( value ) {\n\t\t\t\t\t\treturn value == null ? \"\" : value + \"\";\n\t\t\t\t\t} );\n\t\t\t\t}\n\n\t\t\t\thooks = jQuery.valHooks[ this.type ] || jQuery.valHooks[ this.nodeName.toLowerCase() ];\n\n\t\t\t\t// If set returns undefined, fall back to normal setting\n\t\t\t\tif ( !hooks || !( \"set\" in hooks ) || hooks.set( this, val, \"value\" ) === undefined ) {\n\t\t\t\t\tthis.value = val;\n\t\t\t\t}\n\t\t\t} );\n\t\t}\n\t} );\n\n\tjQuery.extend( {\n\t\tvalHooks: {\n\t\t\toption: {\n\t\t\t\tget: function( elem ) {\n\t\t\t\t\tvar val = jQuery.find.attr( elem, \"value\" );\n\t\t\t\t\treturn val != null ?\n\t\t\t\t\t\tval :\n\n\t\t\t\t\t\t// Support: IE10-11+\n\t\t\t\t\t\t// option.text throws exceptions (#14686, #14858)\n\t\t\t\t\t\t// Strip and collapse whitespace\n\t\t\t\t\t\t// https://html.spec.whatwg.org/#strip-and-collapse-whitespace\n\t\t\t\t\t\tjQuery.trim( jQuery.text( elem ) ).replace( rspaces, \" \" );\n\t\t\t\t}\n\t\t\t},\n\t\t\tselect: {\n\t\t\t\tget: function( elem ) {\n\t\t\t\t\tvar value, option,\n\t\t\t\t\t\toptions = elem.options,\n\t\t\t\t\t\tindex = elem.selectedIndex,\n\t\t\t\t\t\tone = elem.type === \"select-one\" || index < 0,\n\t\t\t\t\t\tvalues = one ? null : [],\n\t\t\t\t\t\tmax = one ? index + 1 : options.length,\n\t\t\t\t\t\ti = index < 0 ?\n\t\t\t\t\t\t\tmax :\n\t\t\t\t\t\t\tone ? index : 0;\n\n\t\t\t\t\t// Loop through all the selected options\n\t\t\t\t\tfor ( ; i < max; i++ ) {\n\t\t\t\t\t\toption = options[ i ];\n\n\t\t\t\t\t\t// oldIE doesn't update selected after form reset (#2551)\n\t\t\t\t\t\tif ( ( option.selected || i === index ) &&\n\n\t\t\t\t\t\t\t// Don't return options that are disabled or in a disabled optgroup\n\t\t\t\t\t\t\t( support.optDisabled ?\n\t\t\t\t\t\t\t\t!option.disabled :\n\t\t\t\t\t\t\toption.getAttribute( \"disabled\" ) === null ) &&\n\t\t\t\t\t\t\t( !option.parentNode.disabled ||\n\t\t\t\t\t\t\t!jQuery.nodeName( option.parentNode, \"optgroup\" ) ) ) {\n\n\t\t\t\t\t\t\t// Get the specific value for the option\n\t\t\t\t\t\t\tvalue = jQuery( option ).val();\n\n\t\t\t\t\t\t\t// We don't need an array for one selects\n\t\t\t\t\t\t\tif ( one ) {\n\t\t\t\t\t\t\t\treturn value;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// Multi-Selects return an array\n\t\t\t\t\t\t\tvalues.push( value );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\treturn values;\n\t\t\t\t},\n\n\t\t\t\tset: function( elem, value ) {\n\t\t\t\t\tvar optionSet, option,\n\t\t\t\t\t\toptions = elem.options,\n\t\t\t\t\t\tvalues = jQuery.makeArray( value ),\n\t\t\t\t\t\ti = options.length;\n\n\t\t\t\t\twhile ( i-- ) {\n\t\t\t\t\t\toption = options[ i ];\n\n\t\t\t\t\t\tif ( jQuery.inArray( jQuery.valHooks.option.get( option ), values ) > -1 ) {\n\n\t\t\t\t\t\t\t// Support: IE6\n\t\t\t\t\t\t\t// When new option element is added to select box we need to\n\t\t\t\t\t\t\t// force reflow of newly added node in order to workaround delay\n\t\t\t\t\t\t\t// of initialization properties\n\t\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\t\toption.selected = optionSet = true;\n\n\t\t\t\t\t\t\t} catch ( _ ) {\n\n\t\t\t\t\t\t\t\t// Will be executed only in IE6\n\t\t\t\t\t\t\t\toption.scrollHeight;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\toption.selected = false;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// Force browsers to behave consistently when non-matching value is set\n\t\t\t\t\tif ( !optionSet ) {\n\t\t\t\t\t\telem.selectedIndex = -1;\n\t\t\t\t\t}\n\n\t\t\t\t\treturn options;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t} );\n\n// Radios and checkboxes getter/setter\n\tjQuery.each( [ \"radio\", \"checkbox\" ], function() {\n\t\tjQuery.valHooks[ this ] = {\n\t\t\tset: function( elem, value ) {\n\t\t\t\tif ( jQuery.isArray( value ) ) {\n\t\t\t\t\treturn ( elem.checked = jQuery.inArray( jQuery( elem ).val(), value ) > -1 );\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\t\tif ( !support.checkOn ) {\n\t\t\tjQuery.valHooks[ this ].get = function( elem ) {\n\t\t\t\treturn elem.getAttribute( \"value\" ) === null ? \"on\" : elem.value;\n\t\t\t};\n\t\t}\n\t} );\n\n\n\n\n\tvar nodeHook, boolHook,\n\t\tattrHandle = jQuery.expr.attrHandle,\n\t\truseDefault = /^(?:checked|selected)$/i,\n\t\tgetSetAttribute = support.getSetAttribute,\n\t\tgetSetInput = support.input;\n\n\tjQuery.fn.extend( {\n\t\tattr: function( name, value ) {\n\t\t\treturn access( this, jQuery.attr, name, value, arguments.length > 1 );\n\t\t},\n\n\t\tremoveAttr: function( name ) {\n\t\t\treturn this.each( function() {\n\t\t\t\tjQuery.removeAttr( this, name );\n\t\t\t} );\n\t\t}\n\t} );\n\n\tjQuery.extend( {\n\t\tattr: function( elem, name, value ) {\n\t\t\tvar ret, hooks,\n\t\t\t\tnType = elem.nodeType;\n\n\t\t\t// Don't get/set attributes on text, comment and attribute nodes\n\t\t\tif ( nType === 3 || nType === 8 || nType === 2 ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Fallback to prop when attributes are not supported\n\t\t\tif ( typeof elem.getAttribute === \"undefined\" ) {\n\t\t\t\treturn jQuery.prop( elem, name, value );\n\t\t\t}\n\n\t\t\t// All attributes are lowercase\n\t\t\t// Grab necessary hook if one is defined\n\t\t\tif ( nType !== 1 || !jQuery.isXMLDoc( elem ) ) {\n\t\t\t\tname = name.toLowerCase();\n\t\t\t\thooks = jQuery.attrHooks[ name ] ||\n\t\t\t\t\t( jQuery.expr.match.bool.test( name ) ? boolHook : nodeHook );\n\t\t\t}\n\n\t\t\tif ( value !== undefined ) {\n\t\t\t\tif ( value === null ) {\n\t\t\t\t\tjQuery.removeAttr( elem, name );\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tif ( hooks && \"set\" in hooks &&\n\t\t\t\t\t( ret = hooks.set( elem, value, name ) ) !== undefined ) {\n\t\t\t\t\treturn ret;\n\t\t\t\t}\n\n\t\t\t\telem.setAttribute( name, value + \"\" );\n\t\t\t\treturn value;\n\t\t\t}\n\n\t\t\tif ( hooks && \"get\" in hooks && ( ret = hooks.get( elem, name ) ) !== null ) {\n\t\t\t\treturn ret;\n\t\t\t}\n\n\t\t\tret = jQuery.find.attr( elem, name );\n\n\t\t\t// Non-existent attributes return null, we normalize to undefined\n\t\t\treturn ret == null ? undefined : ret;\n\t\t},\n\n\t\tattrHooks: {\n\t\t\ttype: {\n\t\t\t\tset: function( elem, value ) {\n\t\t\t\t\tif ( !support.radioValue && value === \"radio\" &&\n\t\t\t\t\t\tjQuery.nodeName( elem, \"input\" ) ) {\n\n\t\t\t\t\t\t// Setting the type on a radio button after the value resets the value in IE8-9\n\t\t\t\t\t\t// Reset value to default in case type is set after value during creation\n\t\t\t\t\t\tvar val = elem.value;\n\t\t\t\t\t\telem.setAttribute( \"type\", value );\n\t\t\t\t\t\tif ( val ) {\n\t\t\t\t\t\t\telem.value = val;\n\t\t\t\t\t\t}\n\t\t\t\t\t\treturn value;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\tremoveAttr: function( elem, value ) {\n\t\t\tvar name, propName,\n\t\t\t\ti = 0,\n\t\t\t\tattrNames = value && value.match( rnotwhite );\n\n\t\t\tif ( attrNames && elem.nodeType === 1 ) {\n\t\t\t\twhile ( ( name = attrNames[ i++ ] ) ) {\n\t\t\t\t\tpropName = jQuery.propFix[ name ] || name;\n\n\t\t\t\t\t// Boolean attributes get special treatment (#10870)\n\t\t\t\t\tif ( jQuery.expr.match.bool.test( name ) ) {\n\n\t\t\t\t\t\t// Set corresponding property to false\n\t\t\t\t\t\tif ( getSetInput && getSetAttribute || !ruseDefault.test( name ) ) {\n\t\t\t\t\t\t\telem[ propName ] = false;\n\n\t\t\t\t\t\t\t// Support: IE<9\n\t\t\t\t\t\t\t// Also clear defaultChecked/defaultSelected (if appropriate)\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\telem[ jQuery.camelCase( \"default-\" + name ) ] =\n\t\t\t\t\t\t\t\telem[ propName ] = false;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// See #9699 for explanation of this approach (setting first, then removal)\n\t\t\t\t\t} else {\n\t\t\t\t\t\tjQuery.attr( elem, name, \"\" );\n\t\t\t\t\t}\n\n\t\t\t\t\telem.removeAttribute( getSetAttribute ? name : propName );\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t} );\n\n// Hooks for boolean attributes\n\tboolHook = {\n\t\tset: function( elem, value, name ) {\n\t\t\tif ( value === false ) {\n\n\t\t\t\t// Remove boolean attributes when set to false\n\t\t\t\tjQuery.removeAttr( elem, name );\n\t\t\t} else if ( getSetInput && getSetAttribute || !ruseDefault.test( name ) ) {\n\n\t\t\t\t// IE<8 needs the *property* name\n\t\t\t\telem.setAttribute( !getSetAttribute && jQuery.propFix[ name ] || name, name );\n\n\t\t\t} else {\n\n\t\t\t\t// Support: IE<9\n\t\t\t\t// Use defaultChecked and defaultSelected for oldIE\n\t\t\t\telem[ jQuery.camelCase( \"default-\" + name ) ] = elem[ name ] = true;\n\t\t\t}\n\t\t\treturn name;\n\t\t}\n\t};\n\n\tjQuery.each( jQuery.expr.match.bool.source.match( /\\w+/g ), function( i, name ) {\n\t\tvar getter = attrHandle[ name ] || jQuery.find.attr;\n\n\t\tif ( getSetInput && getSetAttribute || !ruseDefault.test( name ) ) {\n\t\t\tattrHandle[ name ] = function( elem, name, isXML ) {\n\t\t\t\tvar ret, handle;\n\t\t\t\tif ( !isXML ) {\n\n\t\t\t\t\t// Avoid an infinite loop by temporarily removing this function from the getter\n\t\t\t\t\thandle = attrHandle[ name ];\n\t\t\t\t\tattrHandle[ name ] = ret;\n\t\t\t\t\tret = getter( elem, name, isXML ) != null ?\n\t\t\t\t\t\tname.toLowerCase() :\n\t\t\t\t\t\tnull;\n\t\t\t\t\tattrHandle[ name ] = handle;\n\t\t\t\t}\n\t\t\t\treturn ret;\n\t\t\t};\n\t\t} else {\n\t\t\tattrHandle[ name ] = function( elem, name, isXML ) {\n\t\t\t\tif ( !isXML ) {\n\t\t\t\t\treturn elem[ jQuery.camelCase( \"default-\" + name ) ] ?\n\t\t\t\t\t\tname.toLowerCase() :\n\t\t\t\t\t\tnull;\n\t\t\t\t}\n\t\t\t};\n\t\t}\n\t} );\n\n// fix oldIE attroperties\n\tif ( !getSetInput || !getSetAttribute ) {\n\t\tjQuery.attrHooks.value = {\n\t\t\tset: function( elem, value, name ) {\n\t\t\t\tif ( jQuery.nodeName( elem, \"input\" ) ) {\n\n\t\t\t\t\t// Does not return so that setAttribute is also used\n\t\t\t\t\telem.defaultValue = value;\n\t\t\t\t} else {\n\n\t\t\t\t\t// Use nodeHook if defined (#1954); otherwise setAttribute is fine\n\t\t\t\t\treturn nodeHook && nodeHook.set( elem, value, name );\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\t}\n\n// IE6/7 do not support getting/setting some attributes with get/setAttribute\n\tif ( !getSetAttribute ) {\n\n\t\t// Use this for any attribute in IE6/7\n\t\t// This fixes almost every IE6/7 issue\n\t\tnodeHook = {\n\t\t\tset: function( elem, value, name ) {\n\n\t\t\t\t// Set the existing or create a new attribute node\n\t\t\t\tvar ret = elem.getAttributeNode( name );\n\t\t\t\tif ( !ret ) {\n\t\t\t\t\telem.setAttributeNode(\n\t\t\t\t\t\t( ret = elem.ownerDocument.createAttribute( name ) )\n\t\t\t\t\t);\n\t\t\t\t}\n\n\t\t\t\tret.value = value += \"\";\n\n\t\t\t\t// Break association with cloned elements by also using setAttribute (#9646)\n\t\t\t\tif ( name === \"value\" || value === elem.getAttribute( name ) ) {\n\t\t\t\t\treturn value;\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\n\t\t// Some attributes are constructed with empty-string values when not defined\n\t\tattrHandle.id = attrHandle.name = attrHandle.coords =\n\t\t\tfunction( elem, name, isXML ) {\n\t\t\t\tvar ret;\n\t\t\t\tif ( !isXML ) {\n\t\t\t\t\treturn ( ret = elem.getAttributeNode( name ) ) && ret.value !== \"\" ?\n\t\t\t\t\t\tret.value :\n\t\t\t\t\t\tnull;\n\t\t\t\t}\n\t\t\t};\n\n\t\t// Fixing value retrieval on a button requires this module\n\t\tjQuery.valHooks.button = {\n\t\t\tget: function( elem, name ) {\n\t\t\t\tvar ret = elem.getAttributeNode( name );\n\t\t\t\tif ( ret && ret.specified ) {\n\t\t\t\t\treturn ret.value;\n\t\t\t\t}\n\t\t\t},\n\t\t\tset: nodeHook.set\n\t\t};\n\n\t\t// Set contenteditable to false on removals(#10429)\n\t\t// Setting to empty string throws an error as an invalid value\n\t\tjQuery.attrHooks.contenteditable = {\n\t\t\tset: function( elem, value, name ) {\n\t\t\t\tnodeHook.set( elem, value === \"\" ? false : value, name );\n\t\t\t}\n\t\t};\n\n\t\t// Set width and height to auto instead of 0 on empty string( Bug #8150 )\n\t\t// This is for removals\n\t\tjQuery.each( [ \"width\", \"height\" ], function( i, name ) {\n\t\t\tjQuery.attrHooks[ name ] = {\n\t\t\t\tset: function( elem, value ) {\n\t\t\t\t\tif ( value === \"\" ) {\n\t\t\t\t\t\telem.setAttribute( name, \"auto\" );\n\t\t\t\t\t\treturn value;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t};\n\t\t} );\n\t}\n\n\tif ( !support.style ) {\n\t\tjQuery.attrHooks.style = {\n\t\t\tget: function( elem ) {\n\n\t\t\t\t// Return undefined in the case of empty string\n\t\t\t\t// Note: IE uppercases css property names, but if we were to .toLowerCase()\n\t\t\t\t// .cssText, that would destroy case sensitivity in URL's, like in \"background\"\n\t\t\t\treturn elem.style.cssText || undefined;\n\t\t\t},\n\t\t\tset: function( elem, value ) {\n\t\t\t\treturn ( elem.style.cssText = value + \"\" );\n\t\t\t}\n\t\t};\n\t}\n\n\n\n\n\tvar rfocusable = /^(?:input|select|textarea|button|object)$/i,\n\t\trclickable = /^(?:a|area)$/i;\n\n\tjQuery.fn.extend( {\n\t\tprop: function( name, value ) {\n\t\t\treturn access( this, jQuery.prop, name, value, arguments.length > 1 );\n\t\t},\n\n\t\tremoveProp: function( name ) {\n\t\t\tname = jQuery.propFix[ name ] || name;\n\t\t\treturn this.each( function() {\n\n\t\t\t\t// try/catch handles cases where IE balks (such as removing a property on window)\n\t\t\t\ttry {\n\t\t\t\t\tthis[ name ] = undefined;\n\t\t\t\t\tdelete this[ name ];\n\t\t\t\t} catch ( e ) {}\n\t\t\t} );\n\t\t}\n\t} );\n\n\tjQuery.extend( {\n\t\tprop: function( elem, name, value ) {\n\t\t\tvar ret, hooks,\n\t\t\t\tnType = elem.nodeType;\n\n\t\t\t// Don't get/set properties on text, comment and attribute nodes\n\t\t\tif ( nType === 3 || nType === 8 || nType === 2 ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tif ( nType !== 1 || !jQuery.isXMLDoc( elem ) ) {\n\n\t\t\t\t// Fix name and attach hooks\n\t\t\t\tname = jQuery.propFix[ name ] || name;\n\t\t\t\thooks = jQuery.propHooks[ name ];\n\t\t\t}\n\n\t\t\tif ( value !== undefined ) {\n\t\t\t\tif ( hooks && \"set\" in hooks &&\n\t\t\t\t\t( ret = hooks.set( elem, value, name ) ) !== undefined ) {\n\t\t\t\t\treturn ret;\n\t\t\t\t}\n\n\t\t\t\treturn ( elem[ name ] = value );\n\t\t\t}\n\n\t\t\tif ( hooks && \"get\" in hooks && ( ret = hooks.get( elem, name ) ) !== null ) {\n\t\t\t\treturn ret;\n\t\t\t}\n\n\t\t\treturn elem[ name ];\n\t\t},\n\n\t\tpropHooks: {\n\t\t\ttabIndex: {\n\t\t\t\tget: function( elem ) {\n\n\t\t\t\t\t// elem.tabIndex doesn't always return the\n\t\t\t\t\t// correct value when it hasn't been explicitly set\n\t\t\t\t\t// http://fluidproject.org/blog/2008/01/09/getting-setting-and-removing-tabindex-values-with-javascript/\n\t\t\t\t\t// Use proper attribute retrieval(#12072)\n\t\t\t\t\tvar tabindex = jQuery.find.attr( elem, \"tabindex\" );\n\n\t\t\t\t\treturn tabindex ?\n\t\t\t\t\t\tparseInt( tabindex, 10 ) :\n\t\t\t\t\t\trfocusable.test( elem.nodeName ) ||\n\t\t\t\t\t\trclickable.test( elem.nodeName ) && elem.href ?\n\t\t\t\t\t\t\t0 :\n\t\t\t\t\t\t\t-1;\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\tpropFix: {\n\t\t\t\"for\": \"htmlFor\",\n\t\t\t\"class\": \"className\"\n\t\t}\n\t} );\n\n// Some attributes require a special call on IE\n// http://msdn.microsoft.com/en-us/library/ms536429%28VS.85%29.aspx\n\tif ( !support.hrefNormalized ) {\n\n\t\t// href/src property should get the full normalized URL (#10299/#12915)\n\t\tjQuery.each( [ \"href\", \"src\" ], function( i, name ) {\n\t\t\tjQuery.propHooks[ name ] = {\n\t\t\t\tget: function( elem ) {\n\t\t\t\t\treturn elem.getAttribute( name, 4 );\n\t\t\t\t}\n\t\t\t};\n\t\t} );\n\t}\n\n// Support: Safari, IE9+\n// Accessing the selectedIndex property\n// forces the browser to respect setting selected\n// on the option\n// The getter ensures a default option is selected\n// when in an optgroup\n\tif ( !support.optSelected ) {\n\t\tjQuery.propHooks.selected = {\n\t\t\tget: function( elem ) {\n\t\t\t\tvar parent = elem.parentNode;\n\n\t\t\t\tif ( parent ) {\n\t\t\t\t\tparent.selectedIndex;\n\n\t\t\t\t\t// Make sure that it also works with optgroups, see #5701\n\t\t\t\t\tif ( parent.parentNode ) {\n\t\t\t\t\t\tparent.parentNode.selectedIndex;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\treturn null;\n\t\t\t},\n\t\t\tset: function( elem ) {\n\t\t\t\tvar parent = elem.parentNode;\n\t\t\t\tif ( parent ) {\n\t\t\t\t\tparent.selectedIndex;\n\n\t\t\t\t\tif ( parent.parentNode ) {\n\t\t\t\t\t\tparent.parentNode.selectedIndex;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\t}\n\n\tjQuery.each( [\n\t\t\"tabIndex\",\n\t\t\"readOnly\",\n\t\t\"maxLength\",\n\t\t\"cellSpacing\",\n\t\t\"cellPadding\",\n\t\t\"rowSpan\",\n\t\t\"colSpan\",\n\t\t\"useMap\",\n\t\t\"frameBorder\",\n\t\t\"contentEditable\"\n\t], function() {\n\t\tjQuery.propFix[ this.toLowerCase() ] = this;\n\t} );\n\n// IE6/7 call enctype encoding\n\tif ( !support.enctype ) {\n\t\tjQuery.propFix.enctype = \"encoding\";\n\t}\n\n\n\n\n\tvar rclass = /[\\t\\r\\n\\f]/g;\n\n\tfunction getClass( elem ) {\n\t\treturn jQuery.attr( elem, \"class\" ) || \"\";\n\t}\n\n\tjQuery.fn.extend( {\n\t\taddClass: function( value ) {\n\t\t\tvar classes, elem, cur, curValue, clazz, j, finalValue,\n\t\t\t\ti = 0;\n\n\t\t\tif ( jQuery.isFunction( value ) ) {\n\t\t\t\treturn this.each( function( j ) {\n\t\t\t\t\tjQuery( this ).addClass( value.call( this, j, getClass( this ) ) );\n\t\t\t\t} );\n\t\t\t}\n\n\t\t\tif ( typeof value === \"string\" && value ) {\n\t\t\t\tclasses = value.match( rnotwhite ) || [];\n\n\t\t\t\twhile ( ( elem = this[ i++ ] ) ) {\n\t\t\t\t\tcurValue = getClass( elem );\n\t\t\t\t\tcur = elem.nodeType === 1 &&\n\t\t\t\t\t\t( \" \" + curValue + \" \" ).replace( rclass, \" \" );\n\n\t\t\t\t\tif ( cur ) {\n\t\t\t\t\t\tj = 0;\n\t\t\t\t\t\twhile ( ( clazz = classes[ j++ ] ) ) {\n\t\t\t\t\t\t\tif ( cur.indexOf( \" \" + clazz + \" \" ) < 0 ) {\n\t\t\t\t\t\t\t\tcur += clazz + \" \";\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// only assign if different to avoid unneeded rendering.\n\t\t\t\t\t\tfinalValue = jQuery.trim( cur );\n\t\t\t\t\t\tif ( curValue !== finalValue ) {\n\t\t\t\t\t\t\tjQuery.attr( elem, \"class\", finalValue );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn this;\n\t\t},\n\n\t\tremoveClass: function( value ) {\n\t\t\tvar classes, elem, cur, curValue, clazz, j, finalValue,\n\t\t\t\ti = 0;\n\n\t\t\tif ( jQuery.isFunction( value ) ) {\n\t\t\t\treturn this.each( function( j ) {\n\t\t\t\t\tjQuery( this ).removeClass( value.call( this, j, getClass( this ) ) );\n\t\t\t\t} );\n\t\t\t}\n\n\t\t\tif ( !arguments.length ) {\n\t\t\t\treturn this.attr( \"class\", \"\" );\n\t\t\t}\n\n\t\t\tif ( typeof value === \"string\" && value ) {\n\t\t\t\tclasses = value.match( rnotwhite ) || [];\n\n\t\t\t\twhile ( ( elem = this[ i++ ] ) ) {\n\t\t\t\t\tcurValue = getClass( elem );\n\n\t\t\t\t\t// This expression is here for better compressibility (see addClass)\n\t\t\t\t\tcur = elem.nodeType === 1 &&\n\t\t\t\t\t\t( \" \" + curValue + \" \" ).replace( rclass, \" \" );\n\n\t\t\t\t\tif ( cur ) {\n\t\t\t\t\t\tj = 0;\n\t\t\t\t\t\twhile ( ( clazz = classes[ j++ ] ) ) {\n\n\t\t\t\t\t\t\t// Remove *all* instances\n\t\t\t\t\t\t\twhile ( cur.indexOf( \" \" + clazz + \" \" ) > -1 ) {\n\t\t\t\t\t\t\t\tcur = cur.replace( \" \" + clazz + \" \", \" \" );\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Only assign if different to avoid unneeded rendering.\n\t\t\t\t\t\tfinalValue = jQuery.trim( cur );\n\t\t\t\t\t\tif ( curValue !== finalValue ) {\n\t\t\t\t\t\t\tjQuery.attr( elem, \"class\", finalValue );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn this;\n\t\t},\n\n\t\ttoggleClass: function( value, stateVal ) {\n\t\t\tvar type = typeof value;\n\n\t\t\tif ( typeof stateVal === \"boolean\" && type === \"string\" ) {\n\t\t\t\treturn stateVal ? this.addClass( value ) : this.removeClass( value );\n\t\t\t}\n\n\t\t\tif ( jQuery.isFunction( value ) ) {\n\t\t\t\treturn this.each( function( i ) {\n\t\t\t\t\tjQuery( this ).toggleClass(\n\t\t\t\t\t\tvalue.call( this, i, getClass( this ), stateVal ),\n\t\t\t\t\t\tstateVal\n\t\t\t\t\t);\n\t\t\t\t} );\n\t\t\t}\n\n\t\t\treturn this.each( function() {\n\t\t\t\tvar className, i, self, classNames;\n\n\t\t\t\tif ( type === \"string\" ) {\n\n\t\t\t\t\t// Toggle individual class names\n\t\t\t\t\ti = 0;\n\t\t\t\t\tself = jQuery( this );\n\t\t\t\t\tclassNames = value.match( rnotwhite ) || [];\n\n\t\t\t\t\twhile ( ( className = classNames[ i++ ] ) ) {\n\n\t\t\t\t\t\t// Check each className given, space separated list\n\t\t\t\t\t\tif ( self.hasClass( className ) ) {\n\t\t\t\t\t\t\tself.removeClass( className );\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tself.addClass( className );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// Toggle whole class name\n\t\t\t\t} else if ( value === undefined || type === \"boolean\" ) {\n\t\t\t\t\tclassName = getClass( this );\n\t\t\t\t\tif ( className ) {\n\n\t\t\t\t\t\t// store className if set\n\t\t\t\t\t\tjQuery._data( this, \"__className__\", className );\n\t\t\t\t\t}\n\n\t\t\t\t\t// If the element has a class name or if we're passed \"false\",\n\t\t\t\t\t// then remove the whole classname (if there was one, the above saved it).\n\t\t\t\t\t// Otherwise bring back whatever was previously saved (if anything),\n\t\t\t\t\t// falling back to the empty string if nothing was stored.\n\t\t\t\t\tjQuery.attr( this, \"class\",\n\t\t\t\t\t\tclassName || value === false ?\n\t\t\t\t\t\t\t\"\" :\n\t\t\t\t\t\tjQuery._data( this, \"__className__\" ) || \"\"\n\t\t\t\t\t);\n\t\t\t\t}\n\t\t\t} );\n\t\t},\n\n\t\thasClass: function( selector ) {\n\t\t\tvar className, elem,\n\t\t\t\ti = 0;\n\n\t\t\tclassName = \" \" + selector + \" \";\n\t\t\twhile ( ( elem = this[ i++ ] ) ) {\n\t\t\t\tif ( elem.nodeType === 1 &&\n\t\t\t\t\t( \" \" + getClass( elem ) + \" \" ).replace( rclass, \" \" )\n\t\t\t\t\t\t.indexOf( className ) > -1\n\t\t\t\t) {\n\t\t\t\t\treturn true;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn false;\n\t\t}\n\t} );\n\n\n\n\n// Return jQuery for attributes-only inclusion\n\n\n\tjQuery.each( ( \"blur focus focusin focusout load resize scroll unload click dblclick \" +\n\t\t\"mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave \" +\n\t\t\"change select submit keydown keypress keyup error contextmenu\" ).split( \" \" ),\n\t\tfunction( i, name ) {\n\n\t\t\t// Handle event binding\n\t\t\tjQuery.fn[ name ] = function( data, fn ) {\n\t\t\t\treturn arguments.length > 0 ?\n\t\t\t\t\tthis.on( name, null, data, fn ) :\n\t\t\t\t\tthis.trigger( name );\n\t\t\t};\n\t\t} );\n\n\tjQuery.fn.extend( {\n\t\thover: function( fnOver, fnOut ) {\n\t\t\treturn this.mouseenter( fnOver ).mouseleave( fnOut || fnOver );\n\t\t}\n\t} );\n\n\n\tvar location = window.location;\n\n\tvar nonce = jQuery.now();\n\n\tvar rquery = ( /\\?/ );\n\n\n\n\tvar rvalidtokens = /(,)|(\\[|{)|(}|])|\"(?:[^\"\\\\\\r\\n]|\\\\[\"\\\\\\/bfnrt]|\\\\u[\\da-fA-F]{4})*\"\\s*:?|true|false|null|-?(?!0\\d)\\d+(?:\\.\\d+|)(?:[eE][+-]?\\d+|)/g;\n\n\tjQuery.parseJSON = function( data ) {\n\n\t\t// Attempt to parse using the native JSON parser first\n\t\tif ( window.JSON && window.JSON.parse ) {\n\n\t\t\t// Support: Android 2.3\n\t\t\t// Workaround failure to string-cast null input\n\t\t\treturn window.JSON.parse( data + \"\" );\n\t\t}\n\n\t\tvar requireNonComma,\n\t\t\tdepth = null,\n\t\t\tstr = jQuery.trim( data + \"\" );\n\n\t\t// Guard against invalid (and possibly dangerous) input by ensuring that nothing remains\n\t\t// after removing valid tokens\n\t\treturn str && !jQuery.trim( str.replace( rvalidtokens, function( token, comma, open, close ) {\n\n\t\t\t// Force termination if we see a misplaced comma\n\t\t\tif ( requireNonComma && comma ) {\n\t\t\t\tdepth = 0;\n\t\t\t}\n\n\t\t\t// Perform no more replacements after returning to outermost depth\n\t\t\tif ( depth === 0 ) {\n\t\t\t\treturn token;\n\t\t\t}\n\n\t\t\t// Commas must not follow \"[\", \"{\", or \",\"\n\t\t\trequireNonComma = open || comma;\n\n\t\t\t// Determine new depth\n\t\t\t// array/object open (\"[\" or \"{\"): depth += true - false (increment)\n\t\t\t// array/object close (\"]\" or \"}\"): depth += false - true (decrement)\n\t\t\t// other cases (\",\" or primitive): depth += true - true (numeric cast)\n\t\t\tdepth += !close - !open;\n\n\t\t\t// Remove this token\n\t\t\treturn \"\";\n\t\t} ) ) ?\n\t\t\t( Function( \"return \" + str ) )() :\n\t\t\tjQuery.error( \"Invalid JSON: \" + data );\n\t};\n\n\n// Cross-browser xml parsing\n\tjQuery.parseXML = function( data ) {\n\t\tvar xml, tmp;\n\t\tif ( !data || typeof data !== \"string\" ) {\n\t\t\treturn null;\n\t\t}\n\t\ttry {\n\t\t\tif ( window.DOMParser ) { // Standard\n\t\t\t\ttmp = new window.DOMParser();\n\t\t\t\txml = tmp.parseFromString( data, \"text/xml\" );\n\t\t\t} else { // IE\n\t\t\t\txml = new window.ActiveXObject( \"Microsoft.XMLDOM\" );\n\t\t\t\txml.async = \"false\";\n\t\t\t\txml.loadXML( data );\n\t\t\t}\n\t\t} catch ( e ) {\n\t\t\txml = undefined;\n\t\t}\n\t\tif ( !xml || !xml.documentElement || xml.getElementsByTagName( \"parsererror\" ).length ) {\n\t\t\tjQuery.error( \"Invalid XML: \" + data );\n\t\t}\n\t\treturn xml;\n\t};\n\n\n\tvar\n\t\trhash = /#.*$/,\n\t\trts = /([?&])_=[^&]*/,\n\n\t\t// IE leaves an \\r character at EOL\n\t\trheaders = /^(.*?):[ \\t]*([^\\r\\n]*)\\r?$/mg,\n\n\t\t// #7653, #8125, #8152: local protocol detection\n\t\trlocalProtocol = /^(?:about|app|app-storage|.+-extension|file|res|widget):$/,\n\t\trnoContent = /^(?:GET|HEAD)$/,\n\t\trprotocol = /^\\/\\//,\n\t\trurl = /^([\\w.+-]+:)(?:\\/\\/(?:[^\\/?#]*@|)([^\\/?#:]*)(?::(\\d+)|)|)/,\n\n\t\t/* Prefilters\n\t\t * 1) They are useful to introduce custom dataTypes (see ajax/jsonp.js for an example)\n\t\t * 2) These are called:\n\t\t *    - BEFORE asking for a transport\n\t\t *    - AFTER param serialization (s.data is a string if s.processData is true)\n\t\t * 3) key is the dataType\n\t\t * 4) the catchall symbol \"*\" can be used\n\t\t * 5) execution will start with transport dataType and THEN continue down to \"*\" if needed\n\t\t */\n\t\tprefilters = {},\n\n\t\t/* Transports bindings\n\t\t * 1) key is the dataType\n\t\t * 2) the catchall symbol \"*\" can be used\n\t\t * 3) selection will start with transport dataType and THEN go to \"*\" if needed\n\t\t */\n\t\ttransports = {},\n\n\t\t// Avoid comment-prolog char sequence (#10098); must appease lint and evade compression\n\t\tallTypes = \"*/\".concat( \"*\" ),\n\n\t\t// Document location\n\t\tajaxLocation = location.href,\n\n\t\t// Segment location into parts\n\t\tajaxLocParts = rurl.exec( ajaxLocation.toLowerCase() ) || [];\n\n// Base \"constructor\" for jQuery.ajaxPrefilter and jQuery.ajaxTransport\n\tfunction addToPrefiltersOrTransports( structure ) {\n\n\t\t// dataTypeExpression is optional and defaults to \"*\"\n\t\treturn function( dataTypeExpression, func ) {\n\n\t\t\tif ( typeof dataTypeExpression !== \"string\" ) {\n\t\t\t\tfunc = dataTypeExpression;\n\t\t\t\tdataTypeExpression = \"*\";\n\t\t\t}\n\n\t\t\tvar dataType,\n\t\t\t\ti = 0,\n\t\t\t\tdataTypes = dataTypeExpression.toLowerCase().match( rnotwhite ) || [];\n\n\t\t\tif ( jQuery.isFunction( func ) ) {\n\n\t\t\t\t// For each dataType in the dataTypeExpression\n\t\t\t\twhile ( ( dataType = dataTypes[ i++ ] ) ) {\n\n\t\t\t\t\t// Prepend if requested\n\t\t\t\t\tif ( dataType.charAt( 0 ) === \"+\" ) {\n\t\t\t\t\t\tdataType = dataType.slice( 1 ) || \"*\";\n\t\t\t\t\t\t( structure[ dataType ] = structure[ dataType ] || [] ).unshift( func );\n\n\t\t\t\t\t\t// Otherwise append\n\t\t\t\t\t} else {\n\t\t\t\t\t\t( structure[ dataType ] = structure[ dataType ] || [] ).push( func );\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\t}\n\n// Base inspection function for prefilters and transports\n\tfunction inspectPrefiltersOrTransports( structure, options, originalOptions, jqXHR ) {\n\n\t\tvar inspected = {},\n\t\t\tseekingTransport = ( structure === transports );\n\n\t\tfunction inspect( dataType ) {\n\t\t\tvar selected;\n\t\t\tinspected[ dataType ] = true;\n\t\t\tjQuery.each( structure[ dataType ] || [], function( _, prefilterOrFactory ) {\n\t\t\t\tvar dataTypeOrTransport = prefilterOrFactory( options, originalOptions, jqXHR );\n\t\t\t\tif ( typeof dataTypeOrTransport === \"string\" &&\n\t\t\t\t\t!seekingTransport && !inspected[ dataTypeOrTransport ] ) {\n\n\t\t\t\t\toptions.dataTypes.unshift( dataTypeOrTransport );\n\t\t\t\t\tinspect( dataTypeOrTransport );\n\t\t\t\t\treturn false;\n\t\t\t\t} else if ( seekingTransport ) {\n\t\t\t\t\treturn !( selected = dataTypeOrTransport );\n\t\t\t\t}\n\t\t\t} );\n\t\t\treturn selected;\n\t\t}\n\n\t\treturn inspect( options.dataTypes[ 0 ] ) || !inspected[ \"*\" ] && inspect( \"*\" );\n\t}\n\n// A special extend for ajax options\n// that takes \"flat\" options (not to be deep extended)\n// Fixes #9887\n\tfunction ajaxExtend( target, src ) {\n\t\tvar deep, key,\n\t\t\tflatOptions = jQuery.ajaxSettings.flatOptions || {};\n\n\t\tfor ( key in src ) {\n\t\t\tif ( src[ key ] !== undefined ) {\n\t\t\t\t( flatOptions[ key ] ? target : ( deep || ( deep = {} ) ) )[ key ] = src[ key ];\n\t\t\t}\n\t\t}\n\t\tif ( deep ) {\n\t\t\tjQuery.extend( true, target, deep );\n\t\t}\n\n\t\treturn target;\n\t}\n\n\t/* Handles responses to an ajax request:\n\t * - finds the right dataType (mediates between content-type and expected dataType)\n\t * - returns the corresponding response\n\t */\n\tfunction ajaxHandleResponses( s, jqXHR, responses ) {\n\t\tvar firstDataType, ct, finalDataType, type,\n\t\t\tcontents = s.contents,\n\t\t\tdataTypes = s.dataTypes;\n\n\t\t// Remove auto dataType and get content-type in the process\n\t\twhile ( dataTypes[ 0 ] === \"*\" ) {\n\t\t\tdataTypes.shift();\n\t\t\tif ( ct === undefined ) {\n\t\t\t\tct = s.mimeType || jqXHR.getResponseHeader( \"Content-Type\" );\n\t\t\t}\n\t\t}\n\n\t\t// Check if we're dealing with a known content-type\n\t\tif ( ct ) {\n\t\t\tfor ( type in contents ) {\n\t\t\t\tif ( contents[ type ] && contents[ type ].test( ct ) ) {\n\t\t\t\t\tdataTypes.unshift( type );\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\t// Check to see if we have a response for the expected dataType\n\t\tif ( dataTypes[ 0 ] in responses ) {\n\t\t\tfinalDataType = dataTypes[ 0 ];\n\t\t} else {\n\n\t\t\t// Try convertible dataTypes\n\t\t\tfor ( type in responses ) {\n\t\t\t\tif ( !dataTypes[ 0 ] || s.converters[ type + \" \" + dataTypes[ 0 ] ] ) {\n\t\t\t\t\tfinalDataType = type;\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t\tif ( !firstDataType ) {\n\t\t\t\t\tfirstDataType = type;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Or just use first one\n\t\t\tfinalDataType = finalDataType || firstDataType;\n\t\t}\n\n\t\t// If we found a dataType\n\t\t// We add the dataType to the list if needed\n\t\t// and return the corresponding response\n\t\tif ( finalDataType ) {\n\t\t\tif ( finalDataType !== dataTypes[ 0 ] ) {\n\t\t\t\tdataTypes.unshift( finalDataType );\n\t\t\t}\n\t\t\treturn responses[ finalDataType ];\n\t\t}\n\t}\n\n\t/* Chain conversions given the request and the original response\n\t * Also sets the responseXXX fields on the jqXHR instance\n\t */\n\tfunction ajaxConvert( s, response, jqXHR, isSuccess ) {\n\t\tvar conv2, current, conv, tmp, prev,\n\t\t\tconverters = {},\n\n\t\t\t// Work with a copy of dataTypes in case we need to modify it for conversion\n\t\t\tdataTypes = s.dataTypes.slice();\n\n\t\t// Create converters map with lowercased keys\n\t\tif ( dataTypes[ 1 ] ) {\n\t\t\tfor ( conv in s.converters ) {\n\t\t\t\tconverters[ conv.toLowerCase() ] = s.converters[ conv ];\n\t\t\t}\n\t\t}\n\n\t\tcurrent = dataTypes.shift();\n\n\t\t// Convert to each sequential dataType\n\t\twhile ( current ) {\n\n\t\t\tif ( s.responseFields[ current ] ) {\n\t\t\t\tjqXHR[ s.responseFields[ current ] ] = response;\n\t\t\t}\n\n\t\t\t// Apply the dataFilter if provided\n\t\t\tif ( !prev && isSuccess && s.dataFilter ) {\n\t\t\t\tresponse = s.dataFilter( response, s.dataType );\n\t\t\t}\n\n\t\t\tprev = current;\n\t\t\tcurrent = dataTypes.shift();\n\n\t\t\tif ( current ) {\n\n\t\t\t\t// There's only work to do if current dataType is non-auto\n\t\t\t\tif ( current === \"*\" ) {\n\n\t\t\t\t\tcurrent = prev;\n\n\t\t\t\t\t// Convert response if prev dataType is non-auto and differs from current\n\t\t\t\t} else if ( prev !== \"*\" && prev !== current ) {\n\n\t\t\t\t\t// Seek a direct converter\n\t\t\t\t\tconv = converters[ prev + \" \" + current ] || converters[ \"* \" + current ];\n\n\t\t\t\t\t// If none found, seek a pair\n\t\t\t\t\tif ( !conv ) {\n\t\t\t\t\t\tfor ( conv2 in converters ) {\n\n\t\t\t\t\t\t\t// If conv2 outputs current\n\t\t\t\t\t\t\ttmp = conv2.split( \" \" );\n\t\t\t\t\t\t\tif ( tmp[ 1 ] === current ) {\n\n\t\t\t\t\t\t\t\t// If prev can be converted to accepted input\n\t\t\t\t\t\t\t\tconv = converters[ prev + \" \" + tmp[ 0 ] ] ||\n\t\t\t\t\t\t\t\t\tconverters[ \"* \" + tmp[ 0 ] ];\n\t\t\t\t\t\t\t\tif ( conv ) {\n\n\t\t\t\t\t\t\t\t\t// Condense equivalence converters\n\t\t\t\t\t\t\t\t\tif ( conv === true ) {\n\t\t\t\t\t\t\t\t\t\tconv = converters[ conv2 ];\n\n\t\t\t\t\t\t\t\t\t\t// Otherwise, insert the intermediate dataType\n\t\t\t\t\t\t\t\t\t} else if ( converters[ conv2 ] !== true ) {\n\t\t\t\t\t\t\t\t\t\tcurrent = tmp[ 0 ];\n\t\t\t\t\t\t\t\t\t\tdataTypes.unshift( tmp[ 1 ] );\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// Apply converter (if not an equivalence)\n\t\t\t\t\tif ( conv !== true ) {\n\n\t\t\t\t\t\t// Unless errors are allowed to bubble, catch and return them\n\t\t\t\t\t\tif ( conv && s[ \"throws\" ] ) { // jscs:ignore requireDotNotation\n\t\t\t\t\t\t\tresponse = conv( response );\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\t\tresponse = conv( response );\n\t\t\t\t\t\t\t} catch ( e ) {\n\t\t\t\t\t\t\t\treturn {\n\t\t\t\t\t\t\t\t\tstate: \"parsererror\",\n\t\t\t\t\t\t\t\t\terror: conv ? e : \"No conversion from \" + prev + \" to \" + current\n\t\t\t\t\t\t\t\t};\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\treturn { state: \"success\", data: response };\n\t}\n\n\tjQuery.extend( {\n\n\t\t// Counter for holding the number of active queries\n\t\tactive: 0,\n\n\t\t// Last-Modified header cache for next request\n\t\tlastModified: {},\n\t\tetag: {},\n\n\t\tajaxSettings: {\n\t\t\turl: ajaxLocation,\n\t\t\ttype: \"GET\",\n\t\t\tisLocal: rlocalProtocol.test( ajaxLocParts[ 1 ] ),\n\t\t\tglobal: true,\n\t\t\tprocessData: true,\n\t\t\tasync: true,\n\t\t\tcontentType: \"application/x-www-form-urlencoded; charset=UTF-8\",\n\t\t\t/*\n\t\t\t timeout: 0,\n\t\t\t data: null,\n\t\t\t dataType: null,\n\t\t\t username: null,\n\t\t\t password: null,\n\t\t\t cache: null,\n\t\t\t throws: false,\n\t\t\t traditional: false,\n\t\t\t headers: {},\n\t\t\t */\n\n\t\t\taccepts: {\n\t\t\t\t\"*\": allTypes,\n\t\t\t\ttext: \"text/plain\",\n\t\t\t\thtml: \"text/html\",\n\t\t\t\txml: \"application/xml, text/xml\",\n\t\t\t\tjson: \"application/json, text/javascript\"\n\t\t\t},\n\n\t\t\tcontents: {\n\t\t\t\txml: /\\bxml\\b/,\n\t\t\t\thtml: /\\bhtml/,\n\t\t\t\tjson: /\\bjson\\b/\n\t\t\t},\n\n\t\t\tresponseFields: {\n\t\t\t\txml: \"responseXML\",\n\t\t\t\ttext: \"responseText\",\n\t\t\t\tjson: \"responseJSON\"\n\t\t\t},\n\n\t\t\t// Data converters\n\t\t\t// Keys separate source (or catchall \"*\") and destination types with a single space\n\t\t\tconverters: {\n\n\t\t\t\t// Convert anything to text\n\t\t\t\t\"* text\": String,\n\n\t\t\t\t// Text to html (true = no transformation)\n\t\t\t\t\"text html\": true,\n\n\t\t\t\t// Evaluate text as a json expression\n\t\t\t\t\"text json\": jQuery.parseJSON,\n\n\t\t\t\t// Parse text as xml\n\t\t\t\t\"text xml\": jQuery.parseXML\n\t\t\t},\n\n\t\t\t// For options that shouldn't be deep extended:\n\t\t\t// you can add your own custom options here if\n\t\t\t// and when you create one that shouldn't be\n\t\t\t// deep extended (see ajaxExtend)\n\t\t\tflatOptions: {\n\t\t\t\turl: true,\n\t\t\t\tcontext: true\n\t\t\t}\n\t\t},\n\n\t\t// Creates a full fledged settings object into target\n\t\t// with both ajaxSettings and settings fields.\n\t\t// If target is omitted, writes into ajaxSettings.\n\t\tajaxSetup: function( target, settings ) {\n\t\t\treturn settings ?\n\n\t\t\t\t// Building a settings object\n\t\t\t\tajaxExtend( ajaxExtend( target, jQuery.ajaxSettings ), settings ) :\n\n\t\t\t\t// Extending ajaxSettings\n\t\t\t\tajaxExtend( jQuery.ajaxSettings, target );\n\t\t},\n\n\t\tajaxPrefilter: addToPrefiltersOrTransports( prefilters ),\n\t\tajaxTransport: addToPrefiltersOrTransports( transports ),\n\n\t\t// Main method\n\t\tajax: function( url, options ) {\n\n\t\t\t// If url is an object, simulate pre-1.5 signature\n\t\t\tif ( typeof url === \"object\" ) {\n\t\t\t\toptions = url;\n\t\t\t\turl = undefined;\n\t\t\t}\n\n\t\t\t// Force options to be an object\n\t\t\toptions = options || {};\n\n\t\t\tvar\n\n\t\t\t\t// Cross-domain detection vars\n\t\t\t\tparts,\n\n\t\t\t\t// Loop variable\n\t\t\t\ti,\n\n\t\t\t\t// URL without anti-cache param\n\t\t\t\tcacheURL,\n\n\t\t\t\t// Response headers as string\n\t\t\t\tresponseHeadersString,\n\n\t\t\t\t// timeout handle\n\t\t\t\ttimeoutTimer,\n\n\t\t\t\t// To know if global events are to be dispatched\n\t\t\t\tfireGlobals,\n\n\t\t\t\ttransport,\n\n\t\t\t\t// Response headers\n\t\t\t\tresponseHeaders,\n\n\t\t\t\t// Create the final options object\n\t\t\t\ts = jQuery.ajaxSetup( {}, options ),\n\n\t\t\t\t// Callbacks context\n\t\t\t\tcallbackContext = s.context || s,\n\n\t\t\t\t// Context for global events is callbackContext if it is a DOM node or jQuery collection\n\t\t\t\tglobalEventContext = s.context &&\n\t\t\t\t( callbackContext.nodeType || callbackContext.jquery ) ?\n\t\t\t\t\tjQuery( callbackContext ) :\n\t\t\t\t\tjQuery.event,\n\n\t\t\t\t// Deferreds\n\t\t\t\tdeferred = jQuery.Deferred(),\n\t\t\t\tcompleteDeferred = jQuery.Callbacks( \"once memory\" ),\n\n\t\t\t\t// Status-dependent callbacks\n\t\t\t\tstatusCode = s.statusCode || {},\n\n\t\t\t\t// Headers (they are sent all at once)\n\t\t\t\trequestHeaders = {},\n\t\t\t\trequestHeadersNames = {},\n\n\t\t\t\t// The jqXHR state\n\t\t\t\tstate = 0,\n\n\t\t\t\t// Default abort message\n\t\t\t\tstrAbort = \"canceled\",\n\n\t\t\t\t// Fake xhr\n\t\t\t\tjqXHR = {\n\t\t\t\t\treadyState: 0,\n\n\t\t\t\t\t// Builds headers hashtable if needed\n\t\t\t\t\tgetResponseHeader: function( key ) {\n\t\t\t\t\t\tvar match;\n\t\t\t\t\t\tif ( state === 2 ) {\n\t\t\t\t\t\t\tif ( !responseHeaders ) {\n\t\t\t\t\t\t\t\tresponseHeaders = {};\n\t\t\t\t\t\t\t\twhile ( ( match = rheaders.exec( responseHeadersString ) ) ) {\n\t\t\t\t\t\t\t\t\tresponseHeaders[ match[ 1 ].toLowerCase() ] = match[ 2 ];\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tmatch = responseHeaders[ key.toLowerCase() ];\n\t\t\t\t\t\t}\n\t\t\t\t\t\treturn match == null ? null : match;\n\t\t\t\t\t},\n\n\t\t\t\t\t// Raw string\n\t\t\t\t\tgetAllResponseHeaders: function() {\n\t\t\t\t\t\treturn state === 2 ? responseHeadersString : null;\n\t\t\t\t\t},\n\n\t\t\t\t\t// Caches the header\n\t\t\t\t\tsetRequestHeader: function( name, value ) {\n\t\t\t\t\t\tvar lname = name.toLowerCase();\n\t\t\t\t\t\tif ( !state ) {\n\t\t\t\t\t\t\tname = requestHeadersNames[ lname ] = requestHeadersNames[ lname ] || name;\n\t\t\t\t\t\t\trequestHeaders[ name ] = value;\n\t\t\t\t\t\t}\n\t\t\t\t\t\treturn this;\n\t\t\t\t\t},\n\n\t\t\t\t\t// Overrides response content-type header\n\t\t\t\t\toverrideMimeType: function( type ) {\n\t\t\t\t\t\tif ( !state ) {\n\t\t\t\t\t\t\ts.mimeType = type;\n\t\t\t\t\t\t}\n\t\t\t\t\t\treturn this;\n\t\t\t\t\t},\n\n\t\t\t\t\t// Status-dependent callbacks\n\t\t\t\t\tstatusCode: function( map ) {\n\t\t\t\t\t\tvar code;\n\t\t\t\t\t\tif ( map ) {\n\t\t\t\t\t\t\tif ( state < 2 ) {\n\t\t\t\t\t\t\t\tfor ( code in map ) {\n\n\t\t\t\t\t\t\t\t\t// Lazy-add the new callback in a way that preserves old ones\n\t\t\t\t\t\t\t\t\tstatusCode[ code ] = [ statusCode[ code ], map[ code ] ];\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t} else {\n\n\t\t\t\t\t\t\t\t// Execute the appropriate callbacks\n\t\t\t\t\t\t\t\tjqXHR.always( map[ jqXHR.status ] );\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\treturn this;\n\t\t\t\t\t},\n\n\t\t\t\t\t// Cancel the request\n\t\t\t\t\tabort: function( statusText ) {\n\t\t\t\t\t\tvar finalText = statusText || strAbort;\n\t\t\t\t\t\tif ( transport ) {\n\t\t\t\t\t\t\ttransport.abort( finalText );\n\t\t\t\t\t\t}\n\t\t\t\t\t\tdone( 0, finalText );\n\t\t\t\t\t\treturn this;\n\t\t\t\t\t}\n\t\t\t\t};\n\n\t\t\t// Attach deferreds\n\t\t\tdeferred.promise( jqXHR ).complete = completeDeferred.add;\n\t\t\tjqXHR.success = jqXHR.done;\n\t\t\tjqXHR.error = jqXHR.fail;\n\n\t\t\t// Remove hash character (#7531: and string promotion)\n\t\t\t// Add protocol if not provided (#5866: IE7 issue with protocol-less urls)\n\t\t\t// Handle falsy url in the settings object (#10093: consistency with old signature)\n\t\t\t// We also use the url parameter if available\n\t\t\ts.url = ( ( url || s.url || ajaxLocation ) + \"\" )\n\t\t\t\t.replace( rhash, \"\" )\n\t\t\t\t.replace( rprotocol, ajaxLocParts[ 1 ] + \"//\" );\n\n\t\t\t// Alias method option to type as per ticket #12004\n\t\t\ts.type = options.method || options.type || s.method || s.type;\n\n\t\t\t// Extract dataTypes list\n\t\t\ts.dataTypes = jQuery.trim( s.dataType || \"*\" ).toLowerCase().match( rnotwhite ) || [ \"\" ];\n\n\t\t\t// A cross-domain request is in order when we have a protocol:host:port mismatch\n\t\t\tif ( s.crossDomain == null ) {\n\t\t\t\tparts = rurl.exec( s.url.toLowerCase() );\n\t\t\t\ts.crossDomain = !!( parts &&\n\t\t\t\t\t( parts[ 1 ] !== ajaxLocParts[ 1 ] || parts[ 2 ] !== ajaxLocParts[ 2 ] ||\n\t\t\t\t\t( parts[ 3 ] || ( parts[ 1 ] === \"http:\" ? \"80\" : \"443\" ) ) !==\n\t\t\t\t\t( ajaxLocParts[ 3 ] || ( ajaxLocParts[ 1 ] === \"http:\" ? \"80\" : \"443\" ) ) )\n\t\t\t\t);\n\t\t\t}\n\n\t\t\t// Convert data if not already a string\n\t\t\tif ( s.data && s.processData && typeof s.data !== \"string\" ) {\n\t\t\t\ts.data = jQuery.param( s.data, s.traditional );\n\t\t\t}\n\n\t\t\t// Apply prefilters\n\t\t\tinspectPrefiltersOrTransports( prefilters, s, options, jqXHR );\n\n\t\t\t// If request was aborted inside a prefilter, stop there\n\t\t\tif ( state === 2 ) {\n\t\t\t\treturn jqXHR;\n\t\t\t}\n\n\t\t\t// We can fire global events as of now if asked to\n\t\t\t// Don't fire events if jQuery.event is undefined in an AMD-usage scenario (#15118)\n\t\t\tfireGlobals = jQuery.event && s.global;\n\n\t\t\t// Watch for a new set of requests\n\t\t\tif ( fireGlobals && jQuery.active++ === 0 ) {\n\t\t\t\tjQuery.event.trigger( \"ajaxStart\" );\n\t\t\t}\n\n\t\t\t// Uppercase the type\n\t\t\ts.type = s.type.toUpperCase();\n\n\t\t\t// Determine if request has content\n\t\t\ts.hasContent = !rnoContent.test( s.type );\n\n\t\t\t// Save the URL in case we're toying with the If-Modified-Since\n\t\t\t// and/or If-None-Match header later on\n\t\t\tcacheURL = s.url;\n\n\t\t\t// More options handling for requests with no content\n\t\t\tif ( !s.hasContent ) {\n\n\t\t\t\t// If data is available, append data to url\n\t\t\t\tif ( s.data ) {\n\t\t\t\t\tcacheURL = ( s.url += ( rquery.test( cacheURL ) ? \"&\" : \"?\" ) + s.data );\n\n\t\t\t\t\t// #9682: remove data so that it's not used in an eventual retry\n\t\t\t\t\tdelete s.data;\n\t\t\t\t}\n\n\t\t\t\t// Add anti-cache in url if needed\n\t\t\t\tif ( s.cache === false ) {\n\t\t\t\t\ts.url = rts.test( cacheURL ) ?\n\n\t\t\t\t\t\t// If there is already a '_' parameter, set its value\n\t\t\t\t\t\tcacheURL.replace( rts, \"$1_=\" + nonce++ ) :\n\n\t\t\t\t\t\t// Otherwise add one to the end\n\t\t\t\t\tcacheURL + ( rquery.test( cacheURL ) ? \"&\" : \"?\" ) + \"_=\" + nonce++;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Set the If-Modified-Since and/or If-None-Match header, if in ifModified mode.\n\t\t\tif ( s.ifModified ) {\n\t\t\t\tif ( jQuery.lastModified[ cacheURL ] ) {\n\t\t\t\t\tjqXHR.setRequestHeader( \"If-Modified-Since\", jQuery.lastModified[ cacheURL ] );\n\t\t\t\t}\n\t\t\t\tif ( jQuery.etag[ cacheURL ] ) {\n\t\t\t\t\tjqXHR.setRequestHeader( \"If-None-Match\", jQuery.etag[ cacheURL ] );\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Set the correct header, if data is being sent\n\t\t\tif ( s.data && s.hasContent && s.contentType !== false || options.contentType ) {\n\t\t\t\tjqXHR.setRequestHeader( \"Content-Type\", s.contentType );\n\t\t\t}\n\n\t\t\t// Set the Accepts header for the server, depending on the dataType\n\t\t\tjqXHR.setRequestHeader(\n\t\t\t\t\"Accept\",\n\t\t\t\ts.dataTypes[ 0 ] && s.accepts[ s.dataTypes[ 0 ] ] ?\n\t\t\t\ts.accepts[ s.dataTypes[ 0 ] ] +\n\t\t\t\t( s.dataTypes[ 0 ] !== \"*\" ? \", \" + allTypes + \"; q=0.01\" : \"\" ) :\n\t\t\t\t\ts.accepts[ \"*\" ]\n\t\t\t);\n\n\t\t\t// Check for headers option\n\t\t\tfor ( i in s.headers ) {\n\t\t\t\tjqXHR.setRequestHeader( i, s.headers[ i ] );\n\t\t\t}\n\n\t\t\t// Allow custom headers/mimetypes and early abort\n\t\t\tif ( s.beforeSend &&\n\t\t\t\t( s.beforeSend.call( callbackContext, jqXHR, s ) === false || state === 2 ) ) {\n\n\t\t\t\t// Abort if not done already and return\n\t\t\t\treturn jqXHR.abort();\n\t\t\t}\n\n\t\t\t// aborting is no longer a cancellation\n\t\t\tstrAbort = \"abort\";\n\n\t\t\t// Install callbacks on deferreds\n\t\t\tfor ( i in { success: 1, error: 1, complete: 1 } ) {\n\t\t\t\tjqXHR[ i ]( s[ i ] );\n\t\t\t}\n\n\t\t\t// Get transport\n\t\t\ttransport = inspectPrefiltersOrTransports( transports, s, options, jqXHR );\n\n\t\t\t// If no transport, we auto-abort\n\t\t\tif ( !transport ) {\n\t\t\t\tdone( -1, \"No Transport\" );\n\t\t\t} else {\n\t\t\t\tjqXHR.readyState = 1;\n\n\t\t\t\t// Send global event\n\t\t\t\tif ( fireGlobals ) {\n\t\t\t\t\tglobalEventContext.trigger( \"ajaxSend\", [ jqXHR, s ] );\n\t\t\t\t}\n\n\t\t\t\t// If request was aborted inside ajaxSend, stop there\n\t\t\t\tif ( state === 2 ) {\n\t\t\t\t\treturn jqXHR;\n\t\t\t\t}\n\n\t\t\t\t// Timeout\n\t\t\t\tif ( s.async && s.timeout > 0 ) {\n\t\t\t\t\ttimeoutTimer = window.setTimeout( function() {\n\t\t\t\t\t\tjqXHR.abort( \"timeout\" );\n\t\t\t\t\t}, s.timeout );\n\t\t\t\t}\n\n\t\t\t\ttry {\n\t\t\t\t\tstate = 1;\n\t\t\t\t\ttransport.send( requestHeaders, done );\n\t\t\t\t} catch ( e ) {\n\n\t\t\t\t\t// Propagate exception as error if not done\n\t\t\t\t\tif ( state < 2 ) {\n\t\t\t\t\t\tdone( -1, e );\n\n\t\t\t\t\t\t// Simply rethrow otherwise\n\t\t\t\t\t} else {\n\t\t\t\t\t\tthrow e;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Callback for when everything is done\n\t\t\tfunction done( status, nativeStatusText, responses, headers ) {\n\t\t\t\tvar isSuccess, success, error, response, modified,\n\t\t\t\t\tstatusText = nativeStatusText;\n\n\t\t\t\t// Called once\n\t\t\t\tif ( state === 2 ) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\t// State is \"done\" now\n\t\t\t\tstate = 2;\n\n\t\t\t\t// Clear timeout if it exists\n\t\t\t\tif ( timeoutTimer ) {\n\t\t\t\t\twindow.clearTimeout( timeoutTimer );\n\t\t\t\t}\n\n\t\t\t\t// Dereference transport for early garbage collection\n\t\t\t\t// (no matter how long the jqXHR object will be used)\n\t\t\t\ttransport = undefined;\n\n\t\t\t\t// Cache response headers\n\t\t\t\tresponseHeadersString = headers || \"\";\n\n\t\t\t\t// Set readyState\n\t\t\t\tjqXHR.readyState = status > 0 ? 4 : 0;\n\n\t\t\t\t// Determine if successful\n\t\t\t\tisSuccess = status >= 200 && status < 300 || status === 304;\n\n\t\t\t\t// Get response data\n\t\t\t\tif ( responses ) {\n\t\t\t\t\tresponse = ajaxHandleResponses( s, jqXHR, responses );\n\t\t\t\t}\n\n\t\t\t\t// Convert no matter what (that way responseXXX fields are always set)\n\t\t\t\tresponse = ajaxConvert( s, response, jqXHR, isSuccess );\n\n\t\t\t\t// If successful, handle type chaining\n\t\t\t\tif ( isSuccess ) {\n\n\t\t\t\t\t// Set the If-Modified-Since and/or If-None-Match header, if in ifModified mode.\n\t\t\t\t\tif ( s.ifModified ) {\n\t\t\t\t\t\tmodified = jqXHR.getResponseHeader( \"Last-Modified\" );\n\t\t\t\t\t\tif ( modified ) {\n\t\t\t\t\t\t\tjQuery.lastModified[ cacheURL ] = modified;\n\t\t\t\t\t\t}\n\t\t\t\t\t\tmodified = jqXHR.getResponseHeader( \"etag\" );\n\t\t\t\t\t\tif ( modified ) {\n\t\t\t\t\t\t\tjQuery.etag[ cacheURL ] = modified;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// if no content\n\t\t\t\t\tif ( status === 204 || s.type === \"HEAD\" ) {\n\t\t\t\t\t\tstatusText = \"nocontent\";\n\n\t\t\t\t\t\t// if not modified\n\t\t\t\t\t} else if ( status === 304 ) {\n\t\t\t\t\t\tstatusText = \"notmodified\";\n\n\t\t\t\t\t\t// If we have data, let's convert it\n\t\t\t\t\t} else {\n\t\t\t\t\t\tstatusText = response.state;\n\t\t\t\t\t\tsuccess = response.data;\n\t\t\t\t\t\terror = response.error;\n\t\t\t\t\t\tisSuccess = !error;\n\t\t\t\t\t}\n\t\t\t\t} else {\n\n\t\t\t\t\t// We extract error from statusText\n\t\t\t\t\t// then normalize statusText and status for non-aborts\n\t\t\t\t\terror = statusText;\n\t\t\t\t\tif ( status || !statusText ) {\n\t\t\t\t\t\tstatusText = \"error\";\n\t\t\t\t\t\tif ( status < 0 ) {\n\t\t\t\t\t\t\tstatus = 0;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Set data for the fake xhr object\n\t\t\t\tjqXHR.status = status;\n\t\t\t\tjqXHR.statusText = ( nativeStatusText || statusText ) + \"\";\n\n\t\t\t\t// Success/Error\n\t\t\t\tif ( isSuccess ) {\n\t\t\t\t\tdeferred.resolveWith( callbackContext, [ success, statusText, jqXHR ] );\n\t\t\t\t} else {\n\t\t\t\t\tdeferred.rejectWith( callbackContext, [ jqXHR, statusText, error ] );\n\t\t\t\t}\n\n\t\t\t\t// Status-dependent callbacks\n\t\t\t\tjqXHR.statusCode( statusCode );\n\t\t\t\tstatusCode = undefined;\n\n\t\t\t\tif ( fireGlobals ) {\n\t\t\t\t\tglobalEventContext.trigger( isSuccess ? \"ajaxSuccess\" : \"ajaxError\",\n\t\t\t\t\t\t[ jqXHR, s, isSuccess ? success : error ] );\n\t\t\t\t}\n\n\t\t\t\t// Complete\n\t\t\t\tcompleteDeferred.fireWith( callbackContext, [ jqXHR, statusText ] );\n\n\t\t\t\tif ( fireGlobals ) {\n\t\t\t\t\tglobalEventContext.trigger( \"ajaxComplete\", [ jqXHR, s ] );\n\n\t\t\t\t\t// Handle the global AJAX counter\n\t\t\t\t\tif ( !( --jQuery.active ) ) {\n\t\t\t\t\t\tjQuery.event.trigger( \"ajaxStop\" );\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn jqXHR;\n\t\t},\n\n\t\tgetJSON: function( url, data, callback ) {\n\t\t\treturn jQuery.get( url, data, callback, \"json\" );\n\t\t},\n\n\t\tgetScript: function( url, callback ) {\n\t\t\treturn jQuery.get( url, undefined, callback, \"script\" );\n\t\t}\n\t} );\n\n\tjQuery.each( [ \"get\", \"post\" ], function( i, method ) {\n\t\tjQuery[ method ] = function( url, data, callback, type ) {\n\n\t\t\t// shift arguments if data argument was omitted\n\t\t\tif ( jQuery.isFunction( data ) ) {\n\t\t\t\ttype = type || callback;\n\t\t\t\tcallback = data;\n\t\t\t\tdata = undefined;\n\t\t\t}\n\n\t\t\t// The url can be an options object (which then must have .url)\n\t\t\treturn jQuery.ajax( jQuery.extend( {\n\t\t\t\turl: url,\n\t\t\t\ttype: method,\n\t\t\t\tdataType: type,\n\t\t\t\tdata: data,\n\t\t\t\tsuccess: callback\n\t\t\t}, jQuery.isPlainObject( url ) && url ) );\n\t\t};\n\t} );\n\n\n\tjQuery._evalUrl = function( url ) {\n\t\treturn jQuery.ajax( {\n\t\t\turl: url,\n\n\t\t\t// Make this explicit, since user can override this through ajaxSetup (#11264)\n\t\t\ttype: \"GET\",\n\t\t\tdataType: \"script\",\n\t\t\tcache: true,\n\t\t\tasync: false,\n\t\t\tglobal: false,\n\t\t\t\"throws\": true\n\t\t} );\n\t};\n\n\n\tjQuery.fn.extend( {\n\t\twrapAll: function( html ) {\n\t\t\tif ( jQuery.isFunction( html ) ) {\n\t\t\t\treturn this.each( function( i ) {\n\t\t\t\t\tjQuery( this ).wrapAll( html.call( this, i ) );\n\t\t\t\t} );\n\t\t\t}\n\n\t\t\tif ( this[ 0 ] ) {\n\n\t\t\t\t// The elements to wrap the target around\n\t\t\t\tvar wrap = jQuery( html, this[ 0 ].ownerDocument ).eq( 0 ).clone( true );\n\n\t\t\t\tif ( this[ 0 ].parentNode ) {\n\t\t\t\t\twrap.insertBefore( this[ 0 ] );\n\t\t\t\t}\n\n\t\t\t\twrap.map( function() {\n\t\t\t\t\tvar elem = this;\n\n\t\t\t\t\twhile ( elem.firstChild && elem.firstChild.nodeType === 1 ) {\n\t\t\t\t\t\telem = elem.firstChild;\n\t\t\t\t\t}\n\n\t\t\t\t\treturn elem;\n\t\t\t\t} ).append( this );\n\t\t\t}\n\n\t\t\treturn this;\n\t\t},\n\n\t\twrapInner: function( html ) {\n\t\t\tif ( jQuery.isFunction( html ) ) {\n\t\t\t\treturn this.each( function( i ) {\n\t\t\t\t\tjQuery( this ).wrapInner( html.call( this, i ) );\n\t\t\t\t} );\n\t\t\t}\n\n\t\t\treturn this.each( function() {\n\t\t\t\tvar self = jQuery( this ),\n\t\t\t\t\tcontents = self.contents();\n\n\t\t\t\tif ( contents.length ) {\n\t\t\t\t\tcontents.wrapAll( html );\n\n\t\t\t\t} else {\n\t\t\t\t\tself.append( html );\n\t\t\t\t}\n\t\t\t} );\n\t\t},\n\n\t\twrap: function( html ) {\n\t\t\tvar isFunction = jQuery.isFunction( html );\n\n\t\t\treturn this.each( function( i ) {\n\t\t\t\tjQuery( this ).wrapAll( isFunction ? html.call( this, i ) : html );\n\t\t\t} );\n\t\t},\n\n\t\tunwrap: function() {\n\t\t\treturn this.parent().each( function() {\n\t\t\t\tif ( !jQuery.nodeName( this, \"body\" ) ) {\n\t\t\t\t\tjQuery( this ).replaceWith( this.childNodes );\n\t\t\t\t}\n\t\t\t} ).end();\n\t\t}\n\t} );\n\n\n\tfunction getDisplay( elem ) {\n\t\treturn elem.style && elem.style.display || jQuery.css( elem, \"display\" );\n\t}\n\n\tfunction filterHidden( elem ) {\n\n\t\t// Disconnected elements are considered hidden\n\t\tif ( !jQuery.contains( elem.ownerDocument || document, elem ) ) {\n\t\t\treturn true;\n\t\t}\n\t\twhile ( elem && elem.nodeType === 1 ) {\n\t\t\tif ( getDisplay( elem ) === \"none\" || elem.type === \"hidden\" ) {\n\t\t\t\treturn true;\n\t\t\t}\n\t\t\telem = elem.parentNode;\n\t\t}\n\t\treturn false;\n\t}\n\n\tjQuery.expr.filters.hidden = function( elem ) {\n\n\t\t// Support: Opera <= 12.12\n\t\t// Opera reports offsetWidths and offsetHeights less than zero on some elements\n\t\treturn support.reliableHiddenOffsets() ?\n\t\t\t( elem.offsetWidth <= 0 && elem.offsetHeight <= 0 &&\n\t\t\t!elem.getClientRects().length ) :\n\t\t\tfilterHidden( elem );\n\t};\n\n\tjQuery.expr.filters.visible = function( elem ) {\n\t\treturn !jQuery.expr.filters.hidden( elem );\n\t};\n\n\n\n\n\tvar r20 = /%20/g,\n\t\trbracket = /\\[\\]$/,\n\t\trCRLF = /\\r?\\n/g,\n\t\trsubmitterTypes = /^(?:submit|button|image|reset|file)$/i,\n\t\trsubmittable = /^(?:input|select|textarea|keygen)/i;\n\n\tfunction buildParams( prefix, obj, traditional, add ) {\n\t\tvar name;\n\n\t\tif ( jQuery.isArray( obj ) ) {\n\n\t\t\t// Serialize array item.\n\t\t\tjQuery.each( obj, function( i, v ) {\n\t\t\t\tif ( traditional || rbracket.test( prefix ) ) {\n\n\t\t\t\t\t// Treat each array item as a scalar.\n\t\t\t\t\tadd( prefix, v );\n\n\t\t\t\t} else {\n\n\t\t\t\t\t// Item is non-scalar (array or object), encode its numeric index.\n\t\t\t\t\tbuildParams(\n\t\t\t\t\t\tprefix + \"[\" + ( typeof v === \"object\" && v != null ? i : \"\" ) + \"]\",\n\t\t\t\t\t\tv,\n\t\t\t\t\t\ttraditional,\n\t\t\t\t\t\tadd\n\t\t\t\t\t);\n\t\t\t\t}\n\t\t\t} );\n\n\t\t} else if ( !traditional && jQuery.type( obj ) === \"object\" ) {\n\n\t\t\t// Serialize object item.\n\t\t\tfor ( name in obj ) {\n\t\t\t\tbuildParams( prefix + \"[\" + name + \"]\", obj[ name ], traditional, add );\n\t\t\t}\n\n\t\t} else {\n\n\t\t\t// Serialize scalar item.\n\t\t\tadd( prefix, obj );\n\t\t}\n\t}\n\n// Serialize an array of form elements or a set of\n// key/values into a query string\n\tjQuery.param = function( a, traditional ) {\n\t\tvar prefix,\n\t\t\ts = [],\n\t\t\tadd = function( key, value ) {\n\n\t\t\t\t// If value is a function, invoke it and return its value\n\t\t\t\tvalue = jQuery.isFunction( value ) ? value() : ( value == null ? \"\" : value );\n\t\t\t\ts[ s.length ] = encodeURIComponent( key ) + \"=\" + encodeURIComponent( value );\n\t\t\t};\n\n\t\t// Set traditional to true for jQuery <= 1.3.2 behavior.\n\t\tif ( traditional === undefined ) {\n\t\t\ttraditional = jQuery.ajaxSettings && jQuery.ajaxSettings.traditional;\n\t\t}\n\n\t\t// If an array was passed in, assume that it is an array of form elements.\n\t\tif ( jQuery.isArray( a ) || ( a.jquery && !jQuery.isPlainObject( a ) ) ) {\n\n\t\t\t// Serialize the form elements\n\t\t\tjQuery.each( a, function() {\n\t\t\t\tadd( this.name, this.value );\n\t\t\t} );\n\n\t\t} else {\n\n\t\t\t// If traditional, encode the \"old\" way (the way 1.3.2 or older\n\t\t\t// did it), otherwise encode params recursively.\n\t\t\tfor ( prefix in a ) {\n\t\t\t\tbuildParams( prefix, a[ prefix ], traditional, add );\n\t\t\t}\n\t\t}\n\n\t\t// Return the resulting serialization\n\t\treturn s.join( \"&\" ).replace( r20, \"+\" );\n\t};\n\n\tjQuery.fn.extend( {\n\t\tserialize: function() {\n\t\t\treturn jQuery.param( this.serializeArray() );\n\t\t},\n\t\tserializeArray: function() {\n\t\t\treturn this.map( function() {\n\n\t\t\t\t// Can add propHook for \"elements\" to filter or add form elements\n\t\t\t\tvar elements = jQuery.prop( this, \"elements\" );\n\t\t\t\treturn elements ? jQuery.makeArray( elements ) : this;\n\t\t\t} )\n\t\t\t\t.filter( function() {\n\t\t\t\t\tvar type = this.type;\n\n\t\t\t\t\t// Use .is(\":disabled\") so that fieldset[disabled] works\n\t\t\t\t\treturn this.name && !jQuery( this ).is( \":disabled\" ) &&\n\t\t\t\t\t\trsubmittable.test( this.nodeName ) && !rsubmitterTypes.test( type ) &&\n\t\t\t\t\t\t( this.checked || !rcheckableType.test( type ) );\n\t\t\t\t} )\n\t\t\t\t.map( function( i, elem ) {\n\t\t\t\t\tvar val = jQuery( this ).val();\n\n\t\t\t\t\treturn val == null ?\n\t\t\t\t\t\tnull :\n\t\t\t\t\t\tjQuery.isArray( val ) ?\n\t\t\t\t\t\t\tjQuery.map( val, function( val ) {\n\t\t\t\t\t\t\t\treturn { name: elem.name, value: val.replace( rCRLF, \"\\r\\n\" ) };\n\t\t\t\t\t\t\t} ) :\n\t\t\t\t\t\t{ name: elem.name, value: val.replace( rCRLF, \"\\r\\n\" ) };\n\t\t\t\t} ).get();\n\t\t}\n\t} );\n\n\n// Create the request object\n// (This is still attached to ajaxSettings for backward compatibility)\n\tjQuery.ajaxSettings.xhr = window.ActiveXObject !== undefined ?\n\n\t\t// Support: IE6-IE8\n\t\tfunction() {\n\n\t\t\t// XHR cannot access local files, always use ActiveX for that case\n\t\t\tif ( this.isLocal ) {\n\t\t\t\treturn createActiveXHR();\n\t\t\t}\n\n\t\t\t// Support: IE 9-11\n\t\t\t// IE seems to error on cross-domain PATCH requests when ActiveX XHR\n\t\t\t// is used. In IE 9+ always use the native XHR.\n\t\t\t// Note: this condition won't catch Edge as it doesn't define\n\t\t\t// document.documentMode but it also doesn't support ActiveX so it won't\n\t\t\t// reach this code.\n\t\t\tif ( document.documentMode > 8 ) {\n\t\t\t\treturn createStandardXHR();\n\t\t\t}\n\n\t\t\t// Support: IE<9\n\t\t\t// oldIE XHR does not support non-RFC2616 methods (#13240)\n\t\t\t// See http://msdn.microsoft.com/en-us/library/ie/ms536648(v=vs.85).aspx\n\t\t\t// and http://www.w3.org/Protocols/rfc2616/rfc2616-sec9.html#sec9\n\t\t\t// Although this check for six methods instead of eight\n\t\t\t// since IE also does not support \"trace\" and \"connect\"\n\t\t\treturn /^(get|post|head|put|delete|options)$/i.test( this.type ) &&\n\t\t\t\tcreateStandardXHR() || createActiveXHR();\n\t\t} :\n\n\t\t// For all other browsers, use the standard XMLHttpRequest object\n\t\tcreateStandardXHR;\n\n\tvar xhrId = 0,\n\t\txhrCallbacks = {},\n\t\txhrSupported = jQuery.ajaxSettings.xhr();\n\n// Support: IE<10\n// Open requests must be manually aborted on unload (#5280)\n// See https://support.microsoft.com/kb/2856746 for more info\n\tif ( window.attachEvent ) {\n\t\twindow.attachEvent( \"onunload\", function() {\n\t\t\tfor ( var key in xhrCallbacks ) {\n\t\t\t\txhrCallbacks[ key ]( undefined, true );\n\t\t\t}\n\t\t} );\n\t}\n\n// Determine support properties\n\tsupport.cors = !!xhrSupported && ( \"withCredentials\" in xhrSupported );\n\txhrSupported = support.ajax = !!xhrSupported;\n\n// Create transport if the browser can provide an xhr\n\tif ( xhrSupported ) {\n\n\t\tjQuery.ajaxTransport( function( options ) {\n\n\t\t\t// Cross domain only allowed if supported through XMLHttpRequest\n\t\t\tif ( !options.crossDomain || support.cors ) {\n\n\t\t\t\tvar callback;\n\n\t\t\t\treturn {\n\t\t\t\t\tsend: function( headers, complete ) {\n\t\t\t\t\t\tvar i,\n\t\t\t\t\t\t\txhr = options.xhr(),\n\t\t\t\t\t\t\tid = ++xhrId;\n\n\t\t\t\t\t\t// Open the socket\n\t\t\t\t\t\txhr.open(\n\t\t\t\t\t\t\toptions.type,\n\t\t\t\t\t\t\toptions.url,\n\t\t\t\t\t\t\toptions.async,\n\t\t\t\t\t\t\toptions.username,\n\t\t\t\t\t\t\toptions.password\n\t\t\t\t\t\t);\n\n\t\t\t\t\t\t// Apply custom fields if provided\n\t\t\t\t\t\tif ( options.xhrFields ) {\n\t\t\t\t\t\t\tfor ( i in options.xhrFields ) {\n\t\t\t\t\t\t\t\txhr[ i ] = options.xhrFields[ i ];\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Override mime type if needed\n\t\t\t\t\t\tif ( options.mimeType && xhr.overrideMimeType ) {\n\t\t\t\t\t\t\txhr.overrideMimeType( options.mimeType );\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// X-Requested-With header\n\t\t\t\t\t\t// For cross-domain requests, seeing as conditions for a preflight are\n\t\t\t\t\t\t// akin to a jigsaw puzzle, we simply never set it to be sure.\n\t\t\t\t\t\t// (it can always be set on a per-request basis or even using ajaxSetup)\n\t\t\t\t\t\t// For same-domain requests, won't change header if already provided.\n\t\t\t\t\t\tif ( !options.crossDomain && !headers[ \"X-Requested-With\" ] ) {\n\t\t\t\t\t\t\theaders[ \"X-Requested-With\" ] = \"XMLHttpRequest\";\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Set headers\n\t\t\t\t\t\tfor ( i in headers ) {\n\n\t\t\t\t\t\t\t// Support: IE<9\n\t\t\t\t\t\t\t// IE's ActiveXObject throws a 'Type Mismatch' exception when setting\n\t\t\t\t\t\t\t// request header to a null-value.\n\t\t\t\t\t\t\t//\n\t\t\t\t\t\t\t// To keep consistent with other XHR implementations, cast the value\n\t\t\t\t\t\t\t// to string and ignore `undefined`.\n\t\t\t\t\t\t\tif ( headers[ i ] !== undefined ) {\n\t\t\t\t\t\t\t\txhr.setRequestHeader( i, headers[ i ] + \"\" );\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Do send the request\n\t\t\t\t\t\t// This may raise an exception which is actually\n\t\t\t\t\t\t// handled in jQuery.ajax (so no try/catch here)\n\t\t\t\t\t\txhr.send( ( options.hasContent && options.data ) || null );\n\n\t\t\t\t\t\t// Listener\n\t\t\t\t\t\tcallback = function( _, isAbort ) {\n\t\t\t\t\t\t\tvar status, statusText, responses;\n\n\t\t\t\t\t\t\t// Was never called and is aborted or complete\n\t\t\t\t\t\t\tif ( callback && ( isAbort || xhr.readyState === 4 ) ) {\n\n\t\t\t\t\t\t\t\t// Clean up\n\t\t\t\t\t\t\t\tdelete xhrCallbacks[ id ];\n\t\t\t\t\t\t\t\tcallback = undefined;\n\t\t\t\t\t\t\t\txhr.onreadystatechange = jQuery.noop;\n\n\t\t\t\t\t\t\t\t// Abort manually if needed\n\t\t\t\t\t\t\t\tif ( isAbort ) {\n\t\t\t\t\t\t\t\t\tif ( xhr.readyState !== 4 ) {\n\t\t\t\t\t\t\t\t\t\txhr.abort();\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\tresponses = {};\n\t\t\t\t\t\t\t\t\tstatus = xhr.status;\n\n\t\t\t\t\t\t\t\t\t// Support: IE<10\n\t\t\t\t\t\t\t\t\t// Accessing binary-data responseText throws an exception\n\t\t\t\t\t\t\t\t\t// (#11426)\n\t\t\t\t\t\t\t\t\tif ( typeof xhr.responseText === \"string\" ) {\n\t\t\t\t\t\t\t\t\t\tresponses.text = xhr.responseText;\n\t\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t\t// Firefox throws an exception when accessing\n\t\t\t\t\t\t\t\t\t// statusText for faulty cross-domain requests\n\t\t\t\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\t\t\t\tstatusText = xhr.statusText;\n\t\t\t\t\t\t\t\t\t} catch ( e ) {\n\n\t\t\t\t\t\t\t\t\t\t// We normalize with Webkit giving an empty statusText\n\t\t\t\t\t\t\t\t\t\tstatusText = \"\";\n\t\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t\t// Filter status for non standard behaviors\n\n\t\t\t\t\t\t\t\t\t// If the request is local and we have data: assume a success\n\t\t\t\t\t\t\t\t\t// (success with no data won't get notified, that's the best we\n\t\t\t\t\t\t\t\t\t// can do given current implementations)\n\t\t\t\t\t\t\t\t\tif ( !status && options.isLocal && !options.crossDomain ) {\n\t\t\t\t\t\t\t\t\t\tstatus = responses.text ? 200 : 404;\n\n\t\t\t\t\t\t\t\t\t\t// IE - #1450: sometimes returns 1223 when it should be 204\n\t\t\t\t\t\t\t\t\t} else if ( status === 1223 ) {\n\t\t\t\t\t\t\t\t\t\tstatus = 204;\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// Call complete if needed\n\t\t\t\t\t\t\tif ( responses ) {\n\t\t\t\t\t\t\t\tcomplete( status, statusText, responses, xhr.getAllResponseHeaders() );\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t};\n\n\t\t\t\t\t\t// Do send the request\n\t\t\t\t\t\t// `xhr.send` may raise an exception, but it will be\n\t\t\t\t\t\t// handled in jQuery.ajax (so no try/catch here)\n\t\t\t\t\t\tif ( !options.async ) {\n\n\t\t\t\t\t\t\t// If we're in sync mode we fire the callback\n\t\t\t\t\t\t\tcallback();\n\t\t\t\t\t\t} else if ( xhr.readyState === 4 ) {\n\n\t\t\t\t\t\t\t// (IE6 & IE7) if it's in cache and has been\n\t\t\t\t\t\t\t// retrieved directly we need to fire the callback\n\t\t\t\t\t\t\twindow.setTimeout( callback );\n\t\t\t\t\t\t} else {\n\n\t\t\t\t\t\t\t// Register the callback, but delay it in case `xhr.send` throws\n\t\t\t\t\t\t\t// Add to the list of active xhr callbacks\n\t\t\t\t\t\t\txhr.onreadystatechange = xhrCallbacks[ id ] = callback;\n\t\t\t\t\t\t}\n\t\t\t\t\t},\n\n\t\t\t\t\tabort: function() {\n\t\t\t\t\t\tif ( callback ) {\n\t\t\t\t\t\t\tcallback( undefined, true );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t};\n\t\t\t}\n\t\t} );\n\t}\n\n// Functions to create xhrs\n\tfunction createStandardXHR() {\n\t\ttry {\n\t\t\treturn new window.XMLHttpRequest();\n\t\t} catch ( e ) {}\n\t}\n\n\tfunction createActiveXHR() {\n\t\ttry {\n\t\t\treturn new window.ActiveXObject( \"Microsoft.XMLHTTP\" );\n\t\t} catch ( e ) {}\n\t}\n\n\n\n\n// Install script dataType\n\tjQuery.ajaxSetup( {\n\t\taccepts: {\n\t\t\tscript: \"text/javascript, application/javascript, \" +\n\t\t\t\"application/ecmascript, application/x-ecmascript\"\n\t\t},\n\t\tcontents: {\n\t\t\tscript: /\\b(?:java|ecma)script\\b/\n\t\t},\n\t\tconverters: {\n\t\t\t\"text script\": function( text ) {\n\t\t\t\tjQuery.globalEval( text );\n\t\t\t\treturn text;\n\t\t\t}\n\t\t}\n\t} );\n\n// Handle cache's special case and global\n\tjQuery.ajaxPrefilter( \"script\", function( s ) {\n\t\tif ( s.cache === undefined ) {\n\t\t\ts.cache = false;\n\t\t}\n\t\tif ( s.crossDomain ) {\n\t\t\ts.type = \"GET\";\n\t\t\ts.global = false;\n\t\t}\n\t} );\n\n// Bind script tag hack transport\n\tjQuery.ajaxTransport( \"script\", function( s ) {\n\n\t\t// This transport only deals with cross domain requests\n\t\tif ( s.crossDomain ) {\n\n\t\t\tvar script,\n\t\t\t\thead = document.head || jQuery( \"head\" )[ 0 ] || document.documentElement;\n\n\t\t\treturn {\n\n\t\t\t\tsend: function( _, callback ) {\n\n\t\t\t\t\tscript = document.createElement( \"script\" );\n\n\t\t\t\t\tscript.async = true;\n\n\t\t\t\t\tif ( s.scriptCharset ) {\n\t\t\t\t\t\tscript.charset = s.scriptCharset;\n\t\t\t\t\t}\n\n\t\t\t\t\tscript.src = s.url;\n\n\t\t\t\t\t// Attach handlers for all browsers\n\t\t\t\t\tscript.onload = script.onreadystatechange = function( _, isAbort ) {\n\n\t\t\t\t\t\tif ( isAbort || !script.readyState || /loaded|complete/.test( script.readyState ) ) {\n\n\t\t\t\t\t\t\t// Handle memory leak in IE\n\t\t\t\t\t\t\tscript.onload = script.onreadystatechange = null;\n\n\t\t\t\t\t\t\t// Remove the script\n\t\t\t\t\t\t\tif ( script.parentNode ) {\n\t\t\t\t\t\t\t\tscript.parentNode.removeChild( script );\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// Dereference the script\n\t\t\t\t\t\t\tscript = null;\n\n\t\t\t\t\t\t\t// Callback if not abort\n\t\t\t\t\t\t\tif ( !isAbort ) {\n\t\t\t\t\t\t\t\tcallback( 200, \"success\" );\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t};\n\n\t\t\t\t\t// Circumvent IE6 bugs with base elements (#2709 and #4378) by prepending\n\t\t\t\t\t// Use native DOM manipulation to avoid our domManip AJAX trickery\n\t\t\t\t\thead.insertBefore( script, head.firstChild );\n\t\t\t\t},\n\n\t\t\t\tabort: function() {\n\t\t\t\t\tif ( script ) {\n\t\t\t\t\t\tscript.onload( undefined, true );\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t};\n\t\t}\n\t} );\n\n\n\n\n\tvar oldCallbacks = [],\n\t\trjsonp = /(=)\\?(?=&|$)|\\?\\?/;\n\n// Default jsonp settings\n\tjQuery.ajaxSetup( {\n\t\tjsonp: \"callback\",\n\t\tjsonpCallback: function() {\n\t\t\tvar callback = oldCallbacks.pop() || ( jQuery.expando + \"_\" + ( nonce++ ) );\n\t\t\tthis[ callback ] = true;\n\t\t\treturn callback;\n\t\t}\n\t} );\n\n// Detect, normalize options and install callbacks for jsonp requests\n\tjQuery.ajaxPrefilter( \"json jsonp\", function( s, originalSettings, jqXHR ) {\n\n\t\tvar callbackName, overwritten, responseContainer,\n\t\t\tjsonProp = s.jsonp !== false && ( rjsonp.test( s.url ) ?\n\t\t\t\t\t\t\"url\" :\n\t\t\t\t\ttypeof s.data === \"string\" &&\n\t\t\t\t\t( s.contentType || \"\" )\n\t\t\t\t\t\t.indexOf( \"application/x-www-form-urlencoded\" ) === 0 &&\n\t\t\t\t\trjsonp.test( s.data ) && \"data\"\n\t\t\t\t);\n\n\t\t// Handle iff the expected data type is \"jsonp\" or we have a parameter to set\n\t\tif ( jsonProp || s.dataTypes[ 0 ] === \"jsonp\" ) {\n\n\t\t\t// Get callback name, remembering preexisting value associated with it\n\t\t\tcallbackName = s.jsonpCallback = jQuery.isFunction( s.jsonpCallback ) ?\n\t\t\t\ts.jsonpCallback() :\n\t\t\t\ts.jsonpCallback;\n\n\t\t\t// Insert callback into url or form data\n\t\t\tif ( jsonProp ) {\n\t\t\t\ts[ jsonProp ] = s[ jsonProp ].replace( rjsonp, \"$1\" + callbackName );\n\t\t\t} else if ( s.jsonp !== false ) {\n\t\t\t\ts.url += ( rquery.test( s.url ) ? \"&\" : \"?\" ) + s.jsonp + \"=\" + callbackName;\n\t\t\t}\n\n\t\t\t// Use data converter to retrieve json after script execution\n\t\t\ts.converters[ \"script json\" ] = function() {\n\t\t\t\tif ( !responseContainer ) {\n\t\t\t\t\tjQuery.error( callbackName + \" was not called\" );\n\t\t\t\t}\n\t\t\t\treturn responseContainer[ 0 ];\n\t\t\t};\n\n\t\t\t// force json dataType\n\t\t\ts.dataTypes[ 0 ] = \"json\";\n\n\t\t\t// Install callback\n\t\t\toverwritten = window[ callbackName ];\n\t\t\twindow[ callbackName ] = function() {\n\t\t\t\tresponseContainer = arguments;\n\t\t\t};\n\n\t\t\t// Clean-up function (fires after converters)\n\t\t\tjqXHR.always( function() {\n\n\t\t\t\t// If previous value didn't exist - remove it\n\t\t\t\tif ( overwritten === undefined ) {\n\t\t\t\t\tjQuery( window ).removeProp( callbackName );\n\n\t\t\t\t\t// Otherwise restore preexisting value\n\t\t\t\t} else {\n\t\t\t\t\twindow[ callbackName ] = overwritten;\n\t\t\t\t}\n\n\t\t\t\t// Save back as free\n\t\t\t\tif ( s[ callbackName ] ) {\n\n\t\t\t\t\t// make sure that re-using the options doesn't screw things around\n\t\t\t\t\ts.jsonpCallback = originalSettings.jsonpCallback;\n\n\t\t\t\t\t// save the callback name for future use\n\t\t\t\t\toldCallbacks.push( callbackName );\n\t\t\t\t}\n\n\t\t\t\t// Call if it was a function and we have a response\n\t\t\t\tif ( responseContainer && jQuery.isFunction( overwritten ) ) {\n\t\t\t\t\toverwritten( responseContainer[ 0 ] );\n\t\t\t\t}\n\n\t\t\t\tresponseContainer = overwritten = undefined;\n\t\t\t} );\n\n\t\t\t// Delegate to script\n\t\t\treturn \"script\";\n\t\t}\n\t} );\n\n\n\n\n// data: string of html\n// context (optional): If specified, the fragment will be created in this context,\n// defaults to document\n// keepScripts (optional): If true, will include scripts passed in the html string\n\tjQuery.parseHTML = function( data, context, keepScripts ) {\n\t\tif ( !data || typeof data !== \"string\" ) {\n\t\t\treturn null;\n\t\t}\n\t\tif ( typeof context === \"boolean\" ) {\n\t\t\tkeepScripts = context;\n\t\t\tcontext = false;\n\t\t}\n\t\tcontext = context || document;\n\n\t\tvar parsed = rsingleTag.exec( data ),\n\t\t\tscripts = !keepScripts && [];\n\n\t\t// Single tag\n\t\tif ( parsed ) {\n\t\t\treturn [ context.createElement( parsed[ 1 ] ) ];\n\t\t}\n\n\t\tparsed = buildFragment( [ data ], context, scripts );\n\n\t\tif ( scripts && scripts.length ) {\n\t\t\tjQuery( scripts ).remove();\n\t\t}\n\n\t\treturn jQuery.merge( [], parsed.childNodes );\n\t};\n\n\n// Keep a copy of the old load method\n\tvar _load = jQuery.fn.load;\n\n\t/**\n\t * Load a url into a page\n\t */\n\tjQuery.fn.load = function( url, params, callback ) {\n\t\tif ( typeof url !== \"string\" && _load ) {\n\t\t\treturn _load.apply( this, arguments );\n\t\t}\n\n\t\tvar selector, type, response,\n\t\t\tself = this,\n\t\t\toff = url.indexOf( \" \" );\n\n\t\tif ( off > -1 ) {\n\t\t\tselector = jQuery.trim( url.slice( off, url.length ) );\n\t\t\turl = url.slice( 0, off );\n\t\t}\n\n\t\t// If it's a function\n\t\tif ( jQuery.isFunction( params ) ) {\n\n\t\t\t// We assume that it's the callback\n\t\t\tcallback = params;\n\t\t\tparams = undefined;\n\n\t\t\t// Otherwise, build a param string\n\t\t} else if ( params && typeof params === \"object\" ) {\n\t\t\ttype = \"POST\";\n\t\t}\n\n\t\t// If we have elements to modify, make the request\n\t\tif ( self.length > 0 ) {\n\t\t\tjQuery.ajax( {\n\t\t\t\turl: url,\n\n\t\t\t\t// If \"type\" variable is undefined, then \"GET\" method will be used.\n\t\t\t\t// Make value of this field explicit since\n\t\t\t\t// user can override it through ajaxSetup method\n\t\t\t\ttype: type || \"GET\",\n\t\t\t\tdataType: \"html\",\n\t\t\t\tdata: params\n\t\t\t} ).done( function( responseText ) {\n\n\t\t\t\t// Save response for use in complete callback\n\t\t\t\tresponse = arguments;\n\n\t\t\t\tself.html( selector ?\n\n\t\t\t\t\t// If a selector was specified, locate the right elements in a dummy div\n\t\t\t\t\t// Exclude scripts to avoid IE 'Permission Denied' errors\n\t\t\t\t\tjQuery( \"<div>\" ).append( jQuery.parseHTML( responseText ) ).find( selector ) :\n\n\t\t\t\t\t// Otherwise use the full result\n\t\t\t\t\tresponseText );\n\n\t\t\t\t// If the request succeeds, this function gets \"data\", \"status\", \"jqXHR\"\n\t\t\t\t// but they are ignored because response was set above.\n\t\t\t\t// If it fails, this function gets \"jqXHR\", \"status\", \"error\"\n\t\t\t} ).always( callback && function( jqXHR, status ) {\n\t\t\t\t\tself.each( function() {\n\t\t\t\t\t\tcallback.apply( this, response || [ jqXHR.responseText, status, jqXHR ] );\n\t\t\t\t\t} );\n\t\t\t\t} );\n\t\t}\n\n\t\treturn this;\n\t};\n\n\n\n\n// Attach a bunch of functions for handling common AJAX events\n\tjQuery.each( [\n\t\t\"ajaxStart\",\n\t\t\"ajaxStop\",\n\t\t\"ajaxComplete\",\n\t\t\"ajaxError\",\n\t\t\"ajaxSuccess\",\n\t\t\"ajaxSend\"\n\t], function( i, type ) {\n\t\tjQuery.fn[ type ] = function( fn ) {\n\t\t\treturn this.on( type, fn );\n\t\t};\n\t} );\n\n\n\n\n\tjQuery.expr.filters.animated = function( elem ) {\n\t\treturn jQuery.grep( jQuery.timers, function( fn ) {\n\t\t\treturn elem === fn.elem;\n\t\t} ).length;\n\t};\n\n\n\n\n\n\t/**\n\t * Gets a window from an element\n\t */\n\tfunction getWindow( elem ) {\n\t\treturn jQuery.isWindow( elem ) ?\n\t\t\telem :\n\t\t\telem.nodeType === 9 ?\n\t\t\telem.defaultView || elem.parentWindow :\n\t\t\t\tfalse;\n\t}\n\n\tjQuery.offset = {\n\t\tsetOffset: function( elem, options, i ) {\n\t\t\tvar curPosition, curLeft, curCSSTop, curTop, curOffset, curCSSLeft, calculatePosition,\n\t\t\t\tposition = jQuery.css( elem, \"position\" ),\n\t\t\t\tcurElem = jQuery( elem ),\n\t\t\t\tprops = {};\n\n\t\t\t// set position first, in-case top/left are set even on static elem\n\t\t\tif ( position === \"static\" ) {\n\t\t\t\telem.style.position = \"relative\";\n\t\t\t}\n\n\t\t\tcurOffset = curElem.offset();\n\t\t\tcurCSSTop = jQuery.css( elem, \"top\" );\n\t\t\tcurCSSLeft = jQuery.css( elem, \"left\" );\n\t\t\tcalculatePosition = ( position === \"absolute\" || position === \"fixed\" ) &&\n\t\t\t\tjQuery.inArray( \"auto\", [ curCSSTop, curCSSLeft ] ) > -1;\n\n\t\t\t// need to be able to calculate position if either top or left\n\t\t\t// is auto and position is either absolute or fixed\n\t\t\tif ( calculatePosition ) {\n\t\t\t\tcurPosition = curElem.position();\n\t\t\t\tcurTop = curPosition.top;\n\t\t\t\tcurLeft = curPosition.left;\n\t\t\t} else {\n\t\t\t\tcurTop = parseFloat( curCSSTop ) || 0;\n\t\t\t\tcurLeft = parseFloat( curCSSLeft ) || 0;\n\t\t\t}\n\n\t\t\tif ( jQuery.isFunction( options ) ) {\n\n\t\t\t\t// Use jQuery.extend here to allow modification of coordinates argument (gh-1848)\n\t\t\t\toptions = options.call( elem, i, jQuery.extend( {}, curOffset ) );\n\t\t\t}\n\n\t\t\tif ( options.top != null ) {\n\t\t\t\tprops.top = ( options.top - curOffset.top ) + curTop;\n\t\t\t}\n\t\t\tif ( options.left != null ) {\n\t\t\t\tprops.left = ( options.left - curOffset.left ) + curLeft;\n\t\t\t}\n\n\t\t\tif ( \"using\" in options ) {\n\t\t\t\toptions.using.call( elem, props );\n\t\t\t} else {\n\t\t\t\tcurElem.css( props );\n\t\t\t}\n\t\t}\n\t};\n\n\tjQuery.fn.extend( {\n\t\toffset: function( options ) {\n\t\t\tif ( arguments.length ) {\n\t\t\t\treturn options === undefined ?\n\t\t\t\t\tthis :\n\t\t\t\t\tthis.each( function( i ) {\n\t\t\t\t\t\tjQuery.offset.setOffset( this, options, i );\n\t\t\t\t\t} );\n\t\t\t}\n\n\t\t\tvar docElem, win,\n\t\t\t\tbox = { top: 0, left: 0 },\n\t\t\t\telem = this[ 0 ],\n\t\t\t\tdoc = elem && elem.ownerDocument;\n\n\t\t\tif ( !doc ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tdocElem = doc.documentElement;\n\n\t\t\t// Make sure it's not a disconnected DOM node\n\t\t\tif ( !jQuery.contains( docElem, elem ) ) {\n\t\t\t\treturn box;\n\t\t\t}\n\n\t\t\t// If we don't have gBCR, just use 0,0 rather than error\n\t\t\t// BlackBerry 5, iOS 3 (original iPhone)\n\t\t\tif ( typeof elem.getBoundingClientRect !== \"undefined\" ) {\n\t\t\t\tbox = elem.getBoundingClientRect();\n\t\t\t}\n\t\t\twin = getWindow( doc );\n\t\t\treturn {\n\t\t\t\ttop: box.top  + ( win.pageYOffset || docElem.scrollTop )  - ( docElem.clientTop  || 0 ),\n\t\t\t\tleft: box.left + ( win.pageXOffset || docElem.scrollLeft ) - ( docElem.clientLeft || 0 )\n\t\t\t};\n\t\t},\n\n\t\tposition: function() {\n\t\t\tif ( !this[ 0 ] ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tvar offsetParent, offset,\n\t\t\t\tparentOffset = { top: 0, left: 0 },\n\t\t\t\telem = this[ 0 ];\n\n\t\t\t// Fixed elements are offset from window (parentOffset = {top:0, left: 0},\n\t\t\t// because it is its only offset parent\n\t\t\tif ( jQuery.css( elem, \"position\" ) === \"fixed\" ) {\n\n\t\t\t\t// we assume that getBoundingClientRect is available when computed position is fixed\n\t\t\t\toffset = elem.getBoundingClientRect();\n\t\t\t} else {\n\n\t\t\t\t// Get *real* offsetParent\n\t\t\t\toffsetParent = this.offsetParent();\n\n\t\t\t\t// Get correct offsets\n\t\t\t\toffset = this.offset();\n\t\t\t\tif ( !jQuery.nodeName( offsetParent[ 0 ], \"html\" ) ) {\n\t\t\t\t\tparentOffset = offsetParent.offset();\n\t\t\t\t}\n\n\t\t\t\t// Add offsetParent borders\n\t\t\t\tparentOffset.top  += jQuery.css( offsetParent[ 0 ], \"borderTopWidth\", true );\n\t\t\t\tparentOffset.left += jQuery.css( offsetParent[ 0 ], \"borderLeftWidth\", true );\n\t\t\t}\n\n\t\t\t// Subtract parent offsets and element margins\n\t\t\t// note: when an element has margin: auto the offsetLeft and marginLeft\n\t\t\t// are the same in Safari causing offset.left to incorrectly be 0\n\t\t\treturn {\n\t\t\t\ttop:  offset.top  - parentOffset.top - jQuery.css( elem, \"marginTop\", true ),\n\t\t\t\tleft: offset.left - parentOffset.left - jQuery.css( elem, \"marginLeft\", true )\n\t\t\t};\n\t\t},\n\n\t\toffsetParent: function() {\n\t\t\treturn this.map( function() {\n\t\t\t\tvar offsetParent = this.offsetParent;\n\n\t\t\t\twhile ( offsetParent && ( !jQuery.nodeName( offsetParent, \"html\" ) &&\n\t\t\t\tjQuery.css( offsetParent, \"position\" ) === \"static\" ) ) {\n\t\t\t\t\toffsetParent = offsetParent.offsetParent;\n\t\t\t\t}\n\t\t\t\treturn offsetParent || documentElement;\n\t\t\t} );\n\t\t}\n\t} );\n\n// Create scrollLeft and scrollTop methods\n\tjQuery.each( { scrollLeft: \"pageXOffset\", scrollTop: \"pageYOffset\" }, function( method, prop ) {\n\t\tvar top = /Y/.test( prop );\n\n\t\tjQuery.fn[ method ] = function( val ) {\n\t\t\treturn access( this, function( elem, method, val ) {\n\t\t\t\tvar win = getWindow( elem );\n\n\t\t\t\tif ( val === undefined ) {\n\t\t\t\t\treturn win ? ( prop in win ) ? win[ prop ] :\n\t\t\t\t\t\twin.document.documentElement[ method ] :\n\t\t\t\t\t\telem[ method ];\n\t\t\t\t}\n\n\t\t\t\tif ( win ) {\n\t\t\t\t\twin.scrollTo(\n\t\t\t\t\t\t!top ? val : jQuery( win ).scrollLeft(),\n\t\t\t\t\t\ttop ? val : jQuery( win ).scrollTop()\n\t\t\t\t\t);\n\n\t\t\t\t} else {\n\t\t\t\t\telem[ method ] = val;\n\t\t\t\t}\n\t\t\t}, method, val, arguments.length, null );\n\t\t};\n\t} );\n\n// Support: Safari<7-8+, Chrome<37-44+\n// Add the top/left cssHooks using jQuery.fn.position\n// Webkit bug: https://bugs.webkit.org/show_bug.cgi?id=29084\n// getComputedStyle returns percent when specified for top/left/bottom/right\n// rather than make the css module depend on the offset module, we just check for it here\n\tjQuery.each( [ \"top\", \"left\" ], function( i, prop ) {\n\t\tjQuery.cssHooks[ prop ] = addGetHookIf( support.pixelPosition,\n\t\t\tfunction( elem, computed ) {\n\t\t\t\tif ( computed ) {\n\t\t\t\t\tcomputed = curCSS( elem, prop );\n\n\t\t\t\t\t// if curCSS returns percentage, fallback to offset\n\t\t\t\t\treturn rnumnonpx.test( computed ) ?\n\t\t\t\t\tjQuery( elem ).position()[ prop ] + \"px\" :\n\t\t\t\t\t\tcomputed;\n\t\t\t\t}\n\t\t\t}\n\t\t);\n\t} );\n\n\n// Create innerHeight, innerWidth, height, width, outerHeight and outerWidth methods\n\tjQuery.each( { Height: \"height\", Width: \"width\" }, function( name, type ) {\n\t\tjQuery.each( { padding: \"inner\" + name, content: type, \"\": \"outer\" + name },\n\t\t\tfunction( defaultExtra, funcName ) {\n\n\t\t\t\t// margin is only for outerHeight, outerWidth\n\t\t\t\tjQuery.fn[ funcName ] = function( margin, value ) {\n\t\t\t\t\tvar chainable = arguments.length && ( defaultExtra || typeof margin !== \"boolean\" ),\n\t\t\t\t\t\textra = defaultExtra || ( margin === true || value === true ? \"margin\" : \"border\" );\n\n\t\t\t\t\treturn access( this, function( elem, type, value ) {\n\t\t\t\t\t\tvar doc;\n\n\t\t\t\t\t\tif ( jQuery.isWindow( elem ) ) {\n\n\t\t\t\t\t\t\t// As of 5/8/2012 this will yield incorrect results for Mobile Safari, but there\n\t\t\t\t\t\t\t// isn't a whole lot we can do. See pull request at this URL for discussion:\n\t\t\t\t\t\t\t// https://github.com/jquery/jquery/pull/764\n\t\t\t\t\t\t\treturn elem.document.documentElement[ \"client\" + name ];\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Get document width or height\n\t\t\t\t\t\tif ( elem.nodeType === 9 ) {\n\t\t\t\t\t\t\tdoc = elem.documentElement;\n\n\t\t\t\t\t\t\t// Either scroll[Width/Height] or offset[Width/Height] or client[Width/Height],\n\t\t\t\t\t\t\t// whichever is greatest\n\t\t\t\t\t\t\t// unfortunately, this causes bug #3838 in IE6/8 only,\n\t\t\t\t\t\t\t// but there is currently no good, small way to fix it.\n\t\t\t\t\t\t\treturn Math.max(\n\t\t\t\t\t\t\t\telem.body[ \"scroll\" + name ], doc[ \"scroll\" + name ],\n\t\t\t\t\t\t\t\telem.body[ \"offset\" + name ], doc[ \"offset\" + name ],\n\t\t\t\t\t\t\t\tdoc[ \"client\" + name ]\n\t\t\t\t\t\t\t);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn value === undefined ?\n\n\t\t\t\t\t\t\t// Get width or height on the element, requesting but not forcing parseFloat\n\t\t\t\t\t\t\tjQuery.css( elem, type, extra ) :\n\n\t\t\t\t\t\t\t// Set width or height on the element\n\t\t\t\t\t\t\tjQuery.style( elem, type, value, extra );\n\t\t\t\t\t}, type, chainable ? margin : undefined, chainable, null );\n\t\t\t\t};\n\t\t\t} );\n\t} );\n\n\n\tjQuery.fn.extend( {\n\n\t\tbind: function( types, data, fn ) {\n\t\t\treturn this.on( types, null, data, fn );\n\t\t},\n\t\tunbind: function( types, fn ) {\n\t\t\treturn this.off( types, null, fn );\n\t\t},\n\n\t\tdelegate: function( selector, types, data, fn ) {\n\t\t\treturn this.on( types, selector, data, fn );\n\t\t},\n\t\tundelegate: function( selector, types, fn ) {\n\n\t\t\t// ( namespace ) or ( selector, types [, fn] )\n\t\t\treturn arguments.length === 1 ?\n\t\t\t\tthis.off( selector, \"**\" ) :\n\t\t\t\tthis.off( types, selector || \"**\", fn );\n\t\t}\n\t} );\n\n// The number of elements contained in the matched element set\n\tjQuery.fn.size = function() {\n\t\treturn this.length;\n\t};\n\n\tjQuery.fn.andSelf = jQuery.fn.addBack;\n\n\n\n\n// Register as a named AMD module, since jQuery can be concatenated with other\n// files that may use define, but not via a proper concatenation script that\n// understands anonymous AMD modules. A named AMD is safest and most robust\n// way to register. Lowercase jquery is used because AMD module names are\n// derived from file names, and jQuery is normally delivered in a lowercase\n// file name. Do this after creating the global so that if an AMD module wants\n// to call noConflict to hide this version of jQuery, it will work.\n\n// Note that for maximum portability, libraries that are not jQuery should\n// declare themselves as anonymous modules, and avoid setting a global if an\n// AMD loader is present. jQuery is a special case. For more information, see\n// https://github.com/jrburke/requirejs/wiki/Updating-existing-libraries#wiki-anon\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\t\tdefine( \"jquery\", [], function() {\n\t\t\treturn jQuery;\n\t\t} );\n\t}\n\n\n\n\tvar\n\n\t\t// Map over jQuery in case of overwrite\n\t\t_jQuery = window.jQuery,\n\n\t\t// Map over the $ in case of overwrite\n\t\t_$ = window.$;\n\n\tjQuery.noConflict = function( deep ) {\n\t\tif ( window.$ === jQuery ) {\n\t\t\twindow.$ = _$;\n\t\t}\n\n\t\tif ( deep && window.jQuery === jQuery ) {\n\t\t\twindow.jQuery = _jQuery;\n\t\t}\n\n\t\treturn jQuery;\n\t};\n\n// Expose jQuery and $ identifiers, even in\n// AMD (#7102#comment:10, https://github.com/jquery/jquery/pull/557)\n// and CommonJS for browser emulators (#13566)\n\tif ( !noGlobal ) {\n\t\twindow.jQuery = window.$ = jQuery;\n\t}\n\n\treturn jQuery;\n}));","Magento_Translation/js/add-class.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['jquery'], function ($) {\n    'use strict';\n\n    return function (config, element) {\n        $(element).addClass(config.class);\n    };\n});\n","Magento_Translation/js/i18n-config.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n(function () {\n    'use strict';\n\n    require.config({\n        config: {\n            'Magento_Ui/js/lib/knockout/bindings/i18n': {\n                inlineTranslation: true\n            }\n        }\n    });\n})();\n","Magento_Translation/js/mage-translation-dictionary.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'text!js-translation.json'\n], function (dict) {\n    'use strict';\n\n    return JSON.parse(dict);\n});\n","Magento_PageCache/js/form-key-provider.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(function () {\n    'use strict';\n\n    return function () {\n        var formKey,\n            inputElements,\n            inputSelector = 'input[name=\"form_key\"]';\n\n        /**\n         * Set form_key cookie\n         * @private\n         */\n        function setFormKeyCookie(value) {\n            var expires,\n                secure,\n                date = new Date(),\n                cookiesConfig = window.cookiesConfig || {},\n                isSecure = !!cookiesConfig.secure,\n                samesite = cookiesConfig.samesite || 'lax';\n\n            date.setTime(date.getTime() + 86400000);\n            expires = '; expires=' + date.toUTCString();\n            secure = isSecure ? '; secure' : '';\n            samesite = '; samesite=' + samesite;\n\n            document.cookie = 'form_key=' + (value || '') + expires + secure + '; path=/' + samesite;\n        }\n\n        /**\n         * Retrieves form key from cookie\n         * @private\n         */\n        function getFormKeyCookie() {\n            var cookie,\n                i,\n                nameEQ = 'form_key=',\n                cookieArr = document.cookie.split(';');\n\n            for (i = 0; i < cookieArr.length; i++) {\n                cookie = cookieArr[i];\n\n                while (cookie.charAt(0) === ' ') {\n                    cookie = cookie.substring(1, cookie.length);\n                }\n\n                if (cookie.indexOf(nameEQ) === 0) {\n                    return cookie.substring(nameEQ.length, cookie.length);\n                }\n            }\n\n            return null;\n        }\n\n        /**\n         * Generate form key string\n         * @private\n         */\n        function generateFormKeyString() {\n            var result = '',\n                length = 16,\n                chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';\n\n            while (length--) {\n                result += chars[Math.round(Math.random() * (chars.length - 1))];\n            }\n\n            return result;\n        }\n\n        /**\n         * Init form_key inputs with value\n         * @private\n         */\n        function initFormKey() {\n            formKey = getFormKeyCookie();\n\n            if (!formKey) {\n                formKey = generateFormKeyString();\n                setFormKeyCookie(formKey);\n            }\n            inputElements = document.querySelectorAll(inputSelector);\n\n            if (inputElements.length) {\n                Array.prototype.forEach.call(inputElements, function (element) {\n                    element.setAttribute('value', formKey);\n                });\n            }\n        }\n\n        initFormKey();\n    };\n});\n","Magento_PageCache/js/page-cache.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'domReady',\n    'consoleLogger',\n    'Magento_PageCache/js/form-key-provider',\n    'jquery-ui-modules/widget',\n    'mage/cookies'\n], function ($, domReady, consoleLogger, formKeyInit) {\n    'use strict';\n\n    /**\n     * Helper. Generate random string\n     * TODO: Merge with mage/utils\n     * @param {String} chars - list of symbols\n     * @param {Number} length - length for need string\n     * @returns {String}\n     */\n    function generateRandomString(chars, length) {\n        var result = '';\n\n        length = length > 0 ? length : 1;\n\n        while (length--) {\n            result += chars[Math.round(Math.random() * (chars.length - 1))];\n        }\n\n        return result;\n    }\n\n    /**\n     * Nodes tree to flat list converter\n     * @returns {Array}\n     */\n    $.fn.comments = function () {\n        var elements = [],\n            contents,\n            elementContents;\n\n        /**\n         * @param {jQuery} element - Comment holder\n         */\n        (function lookup(element) {\n            var iframeHostName;\n\n            // prevent cross origin iframe content reading\n            if ($(element).prop('tagName') === 'IFRAME') {\n                iframeHostName = $('<a>').prop('href', $(element).prop('src'))\n                    .prop('hostname');\n\n                if (window.location.hostname !== iframeHostName) {\n                    return [];\n                }\n            }\n\n            /**\n             * Rewrite jQuery contents().\n             *\n             * @param {jQuery} elem\n             */\n            contents = function (elem) {\n                return $.map(elem, function (el) {\n                    try {\n                        return $.nodeName(el, 'iframe') ?\n                            el.contentDocument || (el.contentWindow ? el.contentWindow.document : []) :\n                            $.merge([], el.childNodes);\n                    } catch (e) {\n                        consoleLogger.error(e);\n\n                        return [];\n                    }\n                });\n            };\n\n            elementContents = contents($(element));\n\n            $.each(elementContents, function (index, el) {\n                switch (el.nodeType) {\n                    case 1: // ELEMENT_NODE\n                        lookup(el);\n                        break;\n\n                    case 8: // COMMENT_NODE\n                        elements.push(el);\n                        break;\n\n                    case 9: // DOCUMENT_NODE\n                        lookup($(el).find('body'));\n                        break;\n                }\n            });\n        })(this);\n\n        return elements;\n    };\n\n    /**\n     * FormKey Widget - this widget is generating from key, saves it to cookie and\n     * @deprecated see Magento/PageCache/view/frontend/web/js/form-key-provider.js\n     */\n    $.widget('mage.formKey', {\n        options: {\n            inputSelector: 'input[name=\"form_key\"]',\n            allowedCharacters: '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ',\n            length: 16\n        },\n\n        /**\n         * Creates widget 'mage.formKey'\n         * @private\n         */\n        _create: function () {\n            var formKey = $.mage.cookies.get('form_key'),\n                options = {\n                    secure: window.cookiesConfig ? window.cookiesConfig.secure : false\n                };\n\n            if (!formKey) {\n                formKey = generateRandomString(this.options.allowedCharacters, this.options.length);\n                $.mage.cookies.set('form_key', formKey, options);\n            }\n            $(this.options.inputSelector).val(formKey);\n        }\n    });\n\n    /**\n     * PageCache Widget\n     * Handles additional ajax request for rendering user private content.\n     */\n    $.widget('mage.pageCache', {\n        options: {\n            url: '/',\n            patternPlaceholderOpen: /^ BLOCK (.+) $/,\n            patternPlaceholderClose: /^ \\/BLOCK (.+) $/,\n            versionCookieName: 'private_content_version',\n            handles: []\n        },\n\n        /**\n         * Creates widget 'mage.pageCache'\n         * @private\n         */\n        _create: function () {\n            var placeholders,\n                version = $.mage.cookies.get(this.options.versionCookieName);\n\n            if (!version) {\n                return;\n            }\n            placeholders = this._searchPlaceholders(this.element.comments());\n\n            if (placeholders && placeholders.length) {\n                this._ajax(placeholders, version);\n            }\n        },\n\n        /**\n         * Parse page for placeholders.\n         * @param {Array} elements\n         * @returns {Array}\n         * @private\n         */\n        _searchPlaceholders: function (elements) {\n            var placeholders = [],\n                tmp = {},\n                ii,\n                len,\n                el, matches, name;\n\n            if (!(elements && elements.length)) {\n                return placeholders;\n            }\n\n            for (ii = 0, len = elements.length; ii < len; ii++) {\n                el = elements[ii];\n                matches = this.options.patternPlaceholderOpen.exec(el.nodeValue);\n                name = null;\n\n                if (matches) {\n                    name = matches[1];\n                    tmp[name] = {\n                        name: name,\n                        openElement: el\n                    };\n                } else {\n                    matches = this.options.patternPlaceholderClose.exec(el.nodeValue);\n\n                    if (matches) { //eslint-disable-line max-depth\n                        name = matches[1];\n\n                        if (tmp[name]) { //eslint-disable-line max-depth\n                            tmp[name].closeElement = el;\n                            placeholders.push(tmp[name]);\n                            delete tmp[name];\n                        }\n                    }\n                }\n            }\n\n            return placeholders;\n        },\n\n        /**\n         * Parse for page and replace placeholders\n         * @param {Object} placeholder\n         * @param {Object} html\n         * @protected\n         */\n        _replacePlaceholder: function (placeholder, html) {\n            var startReplacing = false,\n                prevSibling = null,\n                parent, contents, yy, len, element;\n\n            if (!placeholder || !html) {\n                return;\n            }\n\n            parent = $(placeholder.openElement).parent();\n            contents = parent.contents();\n\n            for (yy = 0, len = contents.length; yy < len; yy++) {\n                element = contents[yy];\n\n                if (element == placeholder.openElement) { //eslint-disable-line eqeqeq\n                    startReplacing = true;\n                }\n\n                if (startReplacing) {\n                    $(element).remove();\n                } else if (element.nodeType != 8) { //eslint-disable-line eqeqeq\n                    //due to comment tag doesn't have siblings we try to find it manually\n                    prevSibling = element;\n                }\n\n                if (element == placeholder.closeElement) { //eslint-disable-line eqeqeq\n                    break;\n                }\n            }\n\n            if (prevSibling) {\n                $(prevSibling).after(html);\n            } else {\n                $(parent).prepend(html);\n            }\n\n            // trigger event to use mage-data-init attribute\n            $(parent).trigger('contentUpdated');\n        },\n\n        /**\n         * AJAX helper\n         * @param {Object} placeholders\n         * @param {String} version\n         * @private\n         */\n        _ajax: function (placeholders, version) {\n            var ii,\n                data = {\n                    blocks: [],\n                    handles: this.options.handles,\n                    originalRequest: this.options.originalRequest,\n                    version: version\n                };\n\n            for (ii = 0; ii < placeholders.length; ii++) {\n                data.blocks.push(placeholders[ii].name);\n            }\n            data.blocks = JSON.stringify(data.blocks.sort());\n            data.handles = JSON.stringify(data.handles);\n            data.originalRequest = JSON.stringify(data.originalRequest);\n            $.ajax({\n                url: this.options.url,\n                data: data,\n                type: 'GET',\n                cache: true,\n                dataType: 'json',\n                context: this,\n\n                /**\n                 * Response handler\n                 * @param {Object} response\n                 */\n                success: function (response) {\n                    var placeholder, i;\n\n                    for (i = 0; i < placeholders.length; i++) {\n                        placeholder = placeholders[i];\n\n                        if (response.hasOwnProperty(placeholder.name)) {\n                            this._replacePlaceholder(placeholder, response[placeholder.name]);\n                        }\n                    }\n                }\n            });\n        }\n    });\n\n    domReady(function () {\n        formKeyInit();\n    });\n\n    return {\n        'pageCache': $.mage.pageCache,\n        'formKey': $.mage.formKey\n    };\n});\n","Magento_Swatches/js/swatch-renderer.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'mage/template',\n    'mage/smart-keyboard-handler',\n    'mage/translate',\n    'priceUtils',\n    'jquery-ui-modules/widget',\n    'jquery/jquery.parsequery',\n    'mage/validation/validation'\n], function ($, _, mageTemplate, keyboardHandler, $t, priceUtils) {\n    'use strict';\n\n    /**\n     * Extend form validation to support swatch accessibility\n     */\n    $.widget('mage.validation', $.mage.validation, {\n        /**\n         * Handle form with swatches validation. Focus on first invalid swatch block.\n         *\n         * @param {jQuery.Event} event\n         * @param {Object} validation\n         */\n        listenFormValidateHandler: function (event, validation) {\n            var swatchWrapper, firstActive, swatches, swatch, successList, errorList, firstSwatch;\n\n            this._superApply(arguments);\n\n            swatchWrapper = '.swatch-attribute-options';\n            swatches = $(event.target).find(swatchWrapper);\n\n            if (!swatches.length) {\n                return;\n            }\n\n            swatch = '.swatch-attribute';\n            firstActive = $(validation.errorList[0].element || []);\n            successList = validation.successList;\n            errorList = validation.errorList;\n            firstSwatch = $(firstActive).parent(swatch).find(swatchWrapper);\n\n            keyboardHandler.focus(swatches);\n\n            $.each(successList, function (index, item) {\n                $(item).parent(swatch).find(swatchWrapper).attr('aria-invalid', false);\n            });\n\n            $.each(errorList, function (index, item) {\n                $(item.element).parent(swatch).find(swatchWrapper).attr('aria-invalid', true);\n            });\n\n            if (firstSwatch.length) {\n                $(firstSwatch).focus();\n            }\n        }\n    });\n\n    /**\n     * Render tooltips by attributes (only to up).\n     * Required element attributes:\n     *  - data-option-type (integer, 0-3)\n     *  - data-option-label (string)\n     *  - data-option-tooltip-thumb\n     *  - data-option-tooltip-value\n     *  - data-thumb-width\n     *  - data-thumb-height\n     */\n    $.widget('mage.SwatchRendererTooltip', {\n        options: {\n            delay: 200,                             //how much ms before tooltip to show\n            tooltipClass: 'swatch-option-tooltip'  //configurable, but remember about css\n        },\n\n        /**\n         * @private\n         */\n        _init: function () {\n            var $widget = this,\n                $this = this.element,\n                $element = $('.' + $widget.options.tooltipClass),\n                timer,\n                type = parseInt($this.data('option-type'), 10),\n                label = $this.data('option-label'),\n                thumb = $this.data('option-tooltip-thumb'),\n                value = $this.data('option-tooltip-value'),\n                width = $this.data('thumb-width'),\n                height = $this.data('thumb-height'),\n                $image,\n                $title,\n                $corner;\n\n            if (!$element.length) {\n                $element = $('<div class=\"' +\n                    $widget.options.tooltipClass +\n                    '\"><div class=\"image\"></div><div class=\"title\"></div><div class=\"corner\"></div></div>'\n                );\n                $('body').append($element);\n            }\n\n            $image = $element.find('.image');\n            $title = $element.find('.title');\n            $corner = $element.find('.corner');\n\n            $this.hover(function () {\n                if (!$this.hasClass('disabled')) {\n                    timer = setTimeout(\n                        function () {\n                            var leftOpt = null,\n                                leftCorner = 0,\n                                left,\n                                $window;\n\n                            if (type === 2) {\n                                // Image\n                                $image.css({\n                                    'background': 'url(\"' + thumb + '\") no-repeat center', //Background case\n                                    'background-size': 'initial',\n                                    'width': width + 'px',\n                                    'height': height + 'px'\n                                });\n                                $image.show();\n                            } else if (type === 1) {\n                                // Color\n                                $image.css({\n                                    background: value\n                                });\n                                $image.show();\n                            } else if (type === 0 || type === 3) {\n                                // Default\n                                $image.hide();\n                            }\n\n                            $title.text(label);\n\n                            leftOpt = $this.offset().left;\n                            left = leftOpt + $this.width() / 2 - $element.width() / 2;\n                            $window = $(window);\n\n                            // the numbers (5 and 5) is magick constants for offset from left or right page\n                            if (left < 0) {\n                                left = 5;\n                            } else if (left + $element.width() > $window.width()) {\n                                left = $window.width() - $element.width() - 5;\n                            }\n\n                            // the numbers (6,  3 and 18) is magick constants for offset tooltip\n                            leftCorner = 0;\n\n                            if ($element.width() < $this.width()) {\n                                leftCorner = $element.width() / 2 - 3;\n                            } else {\n                                leftCorner = (leftOpt > left ? leftOpt - left : left - leftOpt) + $this.width() / 2 - 6;\n                            }\n\n                            $corner.css({\n                                left: leftCorner\n                            });\n                            $element.css({\n                                left: left,\n                                top: $this.offset().top - $element.height() - $corner.height() - 18\n                            }).show();\n                        },\n                        $widget.options.delay\n                    );\n                }\n            }, function () {\n                $element.hide();\n                clearTimeout(timer);\n            });\n\n            $(document).on('tap', function () {\n                $element.hide();\n                clearTimeout(timer);\n            });\n\n            $this.on('tap', function (event) {\n                event.stopPropagation();\n            });\n        }\n    });\n\n    /**\n     * Render swatch controls with options and use tooltips.\n     * Required two json:\n     *  - jsonConfig (magento's option config)\n     *  - jsonSwatchConfig (swatch's option config)\n     *\n     *  Tuning:\n     *  - numberToShow (show \"more\" button if options are more)\n     *  - onlySwatches (hide selectboxes)\n     *  - moreButtonText (text for \"more\" button)\n     *  - selectorProduct (selector for product container)\n     *  - selectorProductPrice (selector for change price)\n     */\n    $.widget('mage.SwatchRenderer', {\n        options: {\n            classes: {\n                attributeClass: 'swatch-attribute',\n                attributeLabelClass: 'swatch-attribute-label',\n                attributeSelectedOptionLabelClass: 'swatch-attribute-selected-option',\n                attributeOptionsWrapper: 'swatch-attribute-options',\n                attributeInput: 'swatch-input',\n                optionClass: 'swatch-option',\n                selectClass: 'swatch-select',\n                moreButton: 'swatch-more',\n                loader: 'swatch-option-loading'\n            },\n            // option's json config\n            jsonConfig: {},\n\n            // swatch's json config\n            jsonSwatchConfig: {},\n\n            // selector of parental block of prices and swatches (need to know where to seek for price block)\n            selectorProduct: '.product-info-main',\n\n            // selector of price wrapper (need to know where set price)\n            selectorProductPrice: '[data-role=priceBox]',\n\n            //selector of product images gallery wrapper\n            mediaGallerySelector: '[data-gallery-role=gallery-placeholder]',\n\n            // selector of category product tile wrapper\n            selectorProductTile: '.product-item',\n\n            // number of controls to show (false or zero = show all)\n            numberToShow: false,\n\n            // show only swatch controls\n            onlySwatches: false,\n\n            // enable label for control\n            enableControlLabel: true,\n\n            // control label id\n            controlLabelId: '',\n\n            // text for more button\n            moreButtonText: $t('More'),\n\n            // Callback url for media\n            mediaCallback: '',\n\n            // Local media cache\n            mediaCache: {},\n\n            // Cache for BaseProduct images. Needed when option unset\n            mediaGalleryInitial: [{}],\n\n            // Use ajax to get image data\n            useAjax: false,\n\n            /**\n             * Defines the mechanism of how images of a gallery should be\n             * updated when user switches between configurations of a product.\n             *\n             * As for now value of this option can be either 'replace' or 'prepend'.\n             *\n             * @type {String}\n             */\n            gallerySwitchStrategy: 'replace',\n\n            // whether swatches are rendered in product list or on product page\n            inProductList: false,\n\n            // sly-old-price block selector\n            slyOldPriceSelector: '.sly-old-price',\n\n            // tier prise selectors start\n            tierPriceTemplateSelector: '#tier-prices-template',\n            tierPriceBlockSelector: '[data-role=\"tier-price-block\"]',\n            tierPriceTemplate: '',\n            // tier prise selectors end\n\n            // A price label selector\n            normalPriceLabelSelector: '.product-info-main .normal-price .price-label'\n        },\n\n        /**\n         * Get chosen product\n         *\n         * @returns int|null\n         */\n        getProduct: function () {\n            var products = this._CalcProducts();\n\n            return _.isArray(products) ? products[0] : null;\n        },\n\n        /**\n         * Get chosen product id\n         *\n         * @returns int|null\n         */\n        getProductId: function () {\n            var products = this._CalcProducts();\n\n            return _.isArray(products) && products.length === 1 ? products[0] : null;\n        },\n\n        /**\n         * @private\n         */\n        _init: function () {\n            // Don't render the same set of swatches twice\n            if ($(this.element).attr('data-rendered')) {\n                return;\n            }\n\n            $(this.element).attr('data-rendered', true);\n\n            if (_.isEmpty(this.options.jsonConfig.images)) {\n                this.options.useAjax = true;\n                // creates debounced variant of _LoadProductMedia()\n                // to use it in events handlers instead of _LoadProductMedia()\n                this._debouncedLoadProductMedia = _.debounce(this._LoadProductMedia.bind(this), 500);\n            }\n\n            this.options.tierPriceTemplate = $(this.options.tierPriceTemplateSelector).html();\n\n            if (this.options.jsonConfig !== '' && this.options.jsonSwatchConfig !== '') {\n                // store unsorted attributes\n                this.options.jsonConfig.mappedAttributes = _.clone(this.options.jsonConfig.attributes);\n                this._sortAttributes();\n                this._RenderControls();\n                this._setPreSelectedGallery();\n                $(this.element).trigger('swatch.initialized');\n            } else {\n                console.log('SwatchRenderer: No input data received');\n            }\n        },\n\n        /**\n         * @private\n         */\n        _sortAttributes: function () {\n            this.options.jsonConfig.attributes = _.sortBy(this.options.jsonConfig.attributes, function (attribute) {\n                return parseInt(attribute.position, 10);\n            });\n        },\n\n        /**\n         * @private\n         */\n        _create: function () {\n            var options = this.options,\n                gallery = $('[data-gallery-role=gallery-placeholder]', '.column.main'),\n                productData = this._determineProductData(),\n                $main = productData.isInProductView ?\n                    this.element.parents('.column.main') :\n                    this.element.parents('.product-item-info');\n\n            if (productData.isInProductView) {\n                gallery.data('gallery') ?\n                    this._onGalleryLoaded(gallery) :\n                    gallery.on('gallery:loaded', this._onGalleryLoaded.bind(this, gallery));\n            } else {\n                options.mediaGalleryInitial = [{\n                    'img': $main.find('.product-image-photo').attr('src')\n                }];\n            }\n\n            this.productForm = this.element.parents(this.options.selectorProductTile).find('form:first');\n            this.inProductList = this.productForm.length > 0;\n        },\n\n        /**\n         * Determine product id and related data\n         *\n         * @returns {{productId: *, isInProductView: bool}}\n         * @private\n         */\n        _determineProductData: function () {\n            // Check if product is in a list of products.\n            var productId,\n                isInProductView = false;\n\n            productId = this.element.parents('.product-item-details')\n                    .find('.price-box.price-final_price').attr('data-product-id');\n\n            if (!productId) {\n                // Check individual product.\n                productId = $('[name=product]').val();\n                isInProductView = productId > 0;\n            }\n\n            return {\n                productId: productId,\n                isInProductView: isInProductView\n            };\n        },\n\n        /**\n         * Render controls\n         *\n         * @private\n         */\n        _RenderControls: function () {\n            var $widget = this,\n                container = this.element,\n                classes = this.options.classes,\n                chooseText = this.options.jsonConfig.chooseText,\n                showTooltip = this.options.showTooltip;\n\n            $widget.optionsMap = {};\n\n            $.each(this.options.jsonConfig.attributes, function () {\n                var item = this,\n                    controlLabelId = 'option-label-' + item.code + '-' + item.id,\n                    options = $widget._RenderSwatchOptions(item, controlLabelId),\n                    select = $widget._RenderSwatchSelect(item, chooseText),\n                    input = $widget._RenderFormInput(item),\n                    listLabel = '',\n                    label = '';\n\n                // Show only swatch controls\n                if ($widget.options.onlySwatches && !$widget.options.jsonSwatchConfig.hasOwnProperty(item.id)) {\n                    return;\n                }\n\n                if ($widget.options.enableControlLabel) {\n                    label +=\n                        '<span id=\"' + controlLabelId + '\" class=\"' + classes.attributeLabelClass + '\">' +\n                        $('<i></i>').text(item.label).html() +\n                        '</span>' +\n                        '<span class=\"' + classes.attributeSelectedOptionLabelClass + '\"></span>';\n                }\n\n                if ($widget.inProductList) {\n                    $widget.productForm.append(input);\n                    input = '';\n                    listLabel = 'aria-label=\"' + $('<i></i>').text(item.label).html() + '\"';\n                } else {\n                    listLabel = 'aria-labelledby=\"' + controlLabelId + '\"';\n                }\n\n                // Create new control\n                container.append(\n                    '<div class=\"' + classes.attributeClass + ' ' + item.code + '\" ' +\n                         'data-attribute-code=\"' + item.code + '\" ' +\n                         'data-attribute-id=\"' + item.id + '\">' +\n                        label +\n                        '<div aria-activedescendant=\"\" ' +\n                             'tabindex=\"0\" ' +\n                             'aria-invalid=\"false\" ' +\n                             'aria-required=\"true\" ' +\n                             'role=\"listbox\" ' + listLabel +\n                             'class=\"' + classes.attributeOptionsWrapper + ' clearfix\">' +\n                            options + select +\n                        '</div>' + input +\n                    '</div>'\n                );\n\n                $widget.optionsMap[item.id] = {};\n\n                // Aggregate options array to hash (key => value)\n                $.each(item.options, function () {\n                    if (this.products.length > 0) {\n                        $widget.optionsMap[item.id][this.id] = {\n                            price: parseInt(\n                                $widget.options.jsonConfig.optionPrices[this.products[0]].finalPrice.amount,\n                                10\n                            ),\n                            products: this.products\n                        };\n                    }\n                });\n            });\n\n            if (showTooltip === 1) {\n                // Connect Tooltip\n                container\n                    .find('[data-option-type=\"1\"], [data-option-type=\"2\"],' +\n                        ' [data-option-type=\"0\"], [data-option-type=\"3\"]')\n                    .SwatchRendererTooltip();\n            }\n\n            // Hide all elements below more button\n            $('.' + classes.moreButton).nextAll().hide();\n\n            // Handle events like click or change\n            $widget._EventListener();\n\n            // Rewind options\n            $widget._Rewind(container);\n\n            //Emulate click on all swatches from Request\n            $widget._EmulateSelected($.parseQuery());\n            $widget._EmulateSelected($widget._getSelectedAttributes());\n        },\n\n        /**\n         * Render swatch options by part of config\n         *\n         * @param {Object} config\n         * @param {String} controlId\n         * @returns {String}\n         * @private\n         */\n        _RenderSwatchOptions: function (config, controlId) {\n            var optionConfig = this.options.jsonSwatchConfig[config.id],\n                optionClass = this.options.classes.optionClass,\n                sizeConfig = this.options.jsonSwatchImageSizeConfig,\n                moreLimit = parseInt(this.options.numberToShow, 10),\n                moreClass = this.options.classes.moreButton,\n                moreText = this.options.moreButtonText,\n                countAttributes = 0,\n                html = '';\n\n            if (!this.options.jsonSwatchConfig.hasOwnProperty(config.id)) {\n                return '';\n            }\n\n            $.each(config.options, function (index) {\n                var id,\n                    type,\n                    value,\n                    thumb,\n                    label,\n                    width,\n                    height,\n                    attr,\n                    swatchImageWidth,\n                    swatchImageHeight;\n\n                if (!optionConfig.hasOwnProperty(this.id)) {\n                    return '';\n                }\n\n                // Add more button\n                if (moreLimit === countAttributes++) {\n                    html += '<a href=\"#\" class=\"' + moreClass + '\"><span>' + moreText + '</span></a>';\n                }\n\n                id = this.id;\n                type = parseInt(optionConfig[id].type, 10);\n                value = optionConfig[id].hasOwnProperty('value') ?\n                    $('<i></i>').text(optionConfig[id].value).html() : '';\n                thumb = optionConfig[id].hasOwnProperty('thumb') ? optionConfig[id].thumb : '';\n                width = _.has(sizeConfig, 'swatchThumb') ? sizeConfig.swatchThumb.width : 110;\n                height = _.has(sizeConfig, 'swatchThumb') ? sizeConfig.swatchThumb.height : 90;\n                label = this.label ? $('<i></i>').text(this.label).html() : '';\n                attr =\n                    ' id=\"' + controlId + '-item-' + id + '\"' +\n                    ' index=\"' + index + '\"' +\n                    ' aria-checked=\"false\"' +\n                    ' aria-describedby=\"' + controlId + '\"' +\n                    ' tabindex=\"0\"' +\n                    ' data-option-type=\"' + type + '\"' +\n                    ' data-option-id=\"' + id + '\"' +\n                    ' data-option-label=\"' + label + '\"' +\n                    ' aria-label=\"' + label + '\"' +\n                    ' role=\"option\"' +\n                    ' data-thumb-width=\"' + width + '\"' +\n                    ' data-thumb-height=\"' + height + '\"';\n\n                attr += thumb !== '' ? ' data-option-tooltip-thumb=\"' + thumb + '\"' : '';\n                attr += value !== '' ? ' data-option-tooltip-value=\"' + value + '\"' : '';\n\n                swatchImageWidth = _.has(sizeConfig, 'swatchImage') ? sizeConfig.swatchImage.width : 30;\n                swatchImageHeight = _.has(sizeConfig, 'swatchImage') ? sizeConfig.swatchImage.height : 20;\n\n                if (!this.hasOwnProperty('products') || this.products.length <= 0) {\n                    attr += ' data-option-empty=\"true\"';\n                }\n\n                if (type === 0) {\n                    // Text\n                    html += '<div class=\"' + optionClass + ' text\" ' + attr + '>' + (value ? value : label) +\n                        '</div>';\n                } else if (type === 1) {\n                    // Color\n                    html += '<div class=\"' + optionClass + ' color\" ' + attr +\n                        ' style=\"background: ' + value +\n                        ' no-repeat center; background-size: initial;\">' + '' +\n                        '</div>';\n                } else if (type === 2) {\n                    // Image\n                    html += '<div class=\"' + optionClass + ' image\" ' + attr +\n                        ' style=\"background: url(' + value + ') no-repeat center; background-size: initial;width:' +\n                        swatchImageWidth + 'px; height:' + swatchImageHeight + 'px\">' + '' +\n                        '</div>';\n                } else if (type === 3) {\n                    // Clear\n                    html += '<div class=\"' + optionClass + '\" ' + attr + '></div>';\n                } else {\n                    // Default\n                    html += '<div class=\"' + optionClass + '\" ' + attr + '>' + label + '</div>';\n                }\n            });\n\n            return html;\n        },\n\n        /**\n         * Render select by part of config\n         *\n         * @param {Object} config\n         * @param {String} chooseText\n         * @returns {String}\n         * @private\n         */\n        _RenderSwatchSelect: function (config, chooseText) {\n            var html;\n\n            if (this.options.jsonSwatchConfig.hasOwnProperty(config.id)) {\n                return '';\n            }\n\n            html =\n                '<select class=\"' + this.options.classes.selectClass + ' ' + config.code + '\">' +\n                '<option value=\"0\" data-option-id=\"0\">' + chooseText + '</option>';\n\n            $.each(config.options, function () {\n                var label = this.label,\n                    attr = ' value=\"' + this.id + '\" data-option-id=\"' + this.id + '\"';\n\n                if (!this.hasOwnProperty('products') || this.products.length <= 0) {\n                    attr += ' data-option-empty=\"true\"';\n                }\n\n                html += '<option ' + attr + '>' + label + '</option>';\n            });\n\n            html += '</select>';\n\n            return html;\n        },\n\n        /**\n         * Input for submit form.\n         * This control shouldn't have \"type=hidden\", \"display: none\" for validation work :(\n         *\n         * @param {Object} config\n         * @private\n         */\n        _RenderFormInput: function (config) {\n            return '<input class=\"' + this.options.classes.attributeInput + ' super-attribute-select\" ' +\n                'name=\"super_attribute[' + config.id + ']\" ' +\n                'type=\"text\" ' +\n                'value=\"\" ' +\n                'data-selector=\"super_attribute[' + config.id + ']\" ' +\n                'data-validate=\"{required: true}\" ' +\n                'aria-required=\"true\" ' +\n                'aria-invalid=\"false\">';\n        },\n\n        /**\n         * Event listener\n         *\n         * @private\n         */\n        _EventListener: function () {\n            var $widget = this,\n                options = this.options.classes,\n                target;\n\n            $widget.element.on('click', '.' + options.optionClass, function () {\n                return $widget._OnClick($(this), $widget);\n            });\n\n            $widget.element.on('change', '.' + options.selectClass, function () {\n                return $widget._OnChange($(this), $widget);\n            });\n\n            $widget.element.on('click', '.' + options.moreButton, function (e) {\n                e.preventDefault();\n\n                return $widget._OnMoreClick($(this));\n            });\n\n            $widget.element.on('keydown', function (e) {\n                if (e.which === 13) {\n                    target = $(e.target);\n\n                    if (target.is('.' + options.optionClass)) {\n                        return $widget._OnClick(target, $widget);\n                    } else if (target.is('.' + options.selectClass)) {\n                        return $widget._OnChange(target, $widget);\n                    } else if (target.is('.' + options.moreButton)) {\n                        e.preventDefault();\n\n                        return $widget._OnMoreClick(target);\n                    }\n                }\n            });\n        },\n\n        /**\n         * Load media gallery using ajax or json config.\n         *\n         * @private\n         */\n        _loadMedia: function () {\n            var $main = this.inProductList ?\n                    this.element.parents('.product-item-info') :\n                    this.element.parents('.column.main'),\n                images;\n\n            if (this.options.useAjax) {\n                this._debouncedLoadProductMedia();\n            }  else {\n                images = this.options.jsonConfig.images[this.getProduct()];\n\n                if (!images) {\n                    images = this.options.mediaGalleryInitial;\n                }\n                this.updateBaseImage(this._sortImages(images), $main, !this.inProductList);\n            }\n        },\n\n        /**\n         * Sorting images array\n         *\n         * @private\n         */\n        _sortImages: function (images) {\n            return _.sortBy(images, function (image) {\n                return parseInt(image.position, 10);\n            });\n        },\n\n        /**\n         * Event for swatch options\n         *\n         * @param {Object} $this\n         * @param {Object} $widget\n         * @private\n         */\n        _OnClick: function ($this, $widget) {\n            var $parent = $this.parents('.' + $widget.options.classes.attributeClass),\n                $wrapper = $this.parents('.' + $widget.options.classes.attributeOptionsWrapper),\n                $label = $parent.find('.' + $widget.options.classes.attributeSelectedOptionLabelClass),\n                attributeId = $parent.data('attribute-id'),\n                $input = $parent.find('.' + $widget.options.classes.attributeInput),\n                checkAdditionalData = JSON.parse(this.options.jsonSwatchConfig[attributeId]['additional_data']),\n                $priceBox = $widget.element.parents($widget.options.selectorProduct)\n                    .find(this.options.selectorProductPrice);\n\n            if ($widget.inProductList) {\n                $input = $widget.productForm.find(\n                    '.' + $widget.options.classes.attributeInput + '[name=\"super_attribute[' + attributeId + ']\"]'\n                );\n            }\n\n            if ($this.hasClass('disabled')) {\n                return;\n            }\n\n            if ($this.hasClass('selected')) {\n                $parent.removeAttr('data-option-selected').find('.selected').removeClass('selected');\n                $input.val('');\n                $label.text('');\n                $this.attr('aria-checked', false);\n            } else {\n                $parent.attr('data-option-selected', $this.data('option-id')).find('.selected').removeClass('selected');\n                $label.text($this.data('option-label'));\n                $input.val($this.data('option-id'));\n                $input.attr('data-attr-name', this._getAttributeCodeById(attributeId));\n                $this.addClass('selected');\n                $widget._toggleCheckedAttributes($this, $wrapper);\n            }\n\n            $widget._Rebuild();\n\n            if ($priceBox.is(':data(mage-priceBox)')) {\n                $widget._UpdatePrice();\n            }\n\n            $(document).trigger('updateMsrpPriceBlock',\n                [\n                    this._getSelectedOptionPriceIndex(),\n                    $widget.options.jsonConfig.optionPrices,\n                    $priceBox\n                ]);\n\n            if (parseInt(checkAdditionalData['update_product_preview_image'], 10) === 1) {\n                $widget._loadMedia();\n            }\n\n            $input.trigger('change');\n        },\n\n        /**\n         * Get selected option price index\n         *\n         * @return {String|undefined}\n         * @private\n         */\n        _getSelectedOptionPriceIndex: function () {\n            var allowedProduct = this._getAllowedProductWithMinPrice(this._CalcProducts());\n\n            if (_.isEmpty(allowedProduct)) {\n                return undefined;\n            }\n\n            return allowedProduct;\n        },\n\n        /**\n         * Get human readable attribute code (eg. size, color) by it ID from configuration\n         *\n         * @param {Number} attributeId\n         * @returns {*}\n         * @private\n         */\n        _getAttributeCodeById: function (attributeId) {\n            var attribute = this.options.jsonConfig.mappedAttributes[attributeId];\n\n            return attribute ? attribute.code : attributeId;\n        },\n\n        /**\n         * Toggle accessibility attributes\n         *\n         * @param {Object} $this\n         * @param {Object} $wrapper\n         * @private\n         */\n        _toggleCheckedAttributes: function ($this, $wrapper) {\n            $wrapper.attr('aria-activedescendant', $this.attr('id'))\n                    .find('.' + this.options.classes.optionClass).attr('aria-checked', false);\n            $this.attr('aria-checked', true);\n        },\n\n        /**\n         * Event for select\n         *\n         * @param {Object} $this\n         * @param {Object} $widget\n         * @private\n         */\n        _OnChange: function ($this, $widget) {\n            var $parent = $this.parents('.' + $widget.options.classes.attributeClass),\n                attributeId = $parent.data('attribute-id'),\n                $input = $parent.find('.' + $widget.options.classes.attributeInput);\n\n            if ($widget.productForm.length > 0) {\n                $input = $widget.productForm.find(\n                    '.' + $widget.options.classes.attributeInput + '[name=\"super_attribute[' + attributeId + ']\"]'\n                );\n            }\n\n            if ($this.val() > 0) {\n                $parent.attr('data-option-selected', $this.val());\n                $input.val($this.val());\n            } else {\n                $parent.removeAttr('data-option-selected');\n                $input.val('');\n            }\n\n            $widget._Rebuild();\n            $widget._UpdatePrice();\n            $widget._loadMedia();\n            $input.trigger('change');\n        },\n\n        /**\n         * Event for more switcher\n         *\n         * @param {Object} $this\n         * @private\n         */\n        _OnMoreClick: function ($this) {\n            $this.nextAll().show();\n            $this.blur().remove();\n        },\n\n        /**\n         * Rewind options for controls\n         *\n         * @private\n         */\n        _Rewind: function (controls) {\n            controls.find('div[data-option-id], option[data-option-id]').removeClass('disabled').removeAttr('disabled');\n            controls.find('div[data-option-empty], option[data-option-empty]')\n                .attr('disabled', true)\n                .addClass('disabled')\n                .attr('tabindex', '-1');\n        },\n\n        /**\n         * Rebuild container\n         *\n         * @private\n         */\n        _Rebuild: function () {\n            var $widget = this,\n                controls = $widget.element.find('.' + $widget.options.classes.attributeClass + '[data-attribute-id]'),\n                selected = controls.filter('[data-option-selected]');\n\n            // Enable all options\n            $widget._Rewind(controls);\n\n            // done if nothing selected\n            if (selected.length <= 0) {\n                return;\n            }\n\n            // Disable not available options\n            controls.each(function () {\n                var $this = $(this),\n                    id = $this.data('attribute-id'),\n                    products = $widget._CalcProducts(id);\n\n                if (selected.length === 1 && selected.first().data('attribute-id') === id) {\n                    return;\n                }\n\n                $this.find('[data-option-id]').each(function () {\n                    var $element = $(this),\n                        option = $element.data('option-id');\n\n                    if (!$widget.optionsMap.hasOwnProperty(id) || !$widget.optionsMap[id].hasOwnProperty(option) ||\n                        $element.hasClass('selected') ||\n                        $element.is(':selected')) {\n                        return;\n                    }\n\n                    if (_.intersection(products, $widget.optionsMap[id][option].products).length <= 0) {\n                        $element.attr('disabled', true).addClass('disabled');\n                    }\n                });\n            });\n        },\n\n        /**\n         * Get selected product list\n         *\n         * @returns {Array}\n         * @private\n         */\n        _CalcProducts: function ($skipAttributeId) {\n            var $widget = this,\n                selectedOptions = '.' + $widget.options.classes.attributeClass + '[data-option-selected]',\n                products = [];\n\n            // Generate intersection of products\n            $widget.element.find(selectedOptions).each(function () {\n                var id = $(this).data('attribute-id'),\n                    option = $(this).attr('data-option-selected');\n\n                if ($skipAttributeId !== undefined && $skipAttributeId === id) {\n                    return;\n                }\n\n                if (!$widget.optionsMap.hasOwnProperty(id) || !$widget.optionsMap[id].hasOwnProperty(option)) {\n                    return;\n                }\n\n                if (products.length === 0) {\n                    products = $widget.optionsMap[id][option].products;\n                } else {\n                    products = _.intersection(products, $widget.optionsMap[id][option].products);\n                }\n            });\n\n            return products;\n        },\n\n        /**\n         * Update total price\n         *\n         * @private\n         */\n        _UpdatePrice: function () {\n            var $widget = this,\n                $product = $widget.element.parents($widget.options.selectorProduct),\n                $productPrice = $product.find(this.options.selectorProductPrice),\n                result = $widget._getNewPrices(),\n                tierPriceHtml,\n                isShow;\n\n            $productPrice.trigger(\n                'updatePrice',\n                {\n                    'prices': $widget._getPrices(result, $productPrice.priceBox('option').prices)\n                }\n            );\n\n            isShow = typeof result != 'undefined' && result.oldPrice.amount !== result.finalPrice.amount;\n\n            $productPrice.find('span:first').toggleClass('special-price', isShow);\n\n            $product.find(this.options.slyOldPriceSelector)[isShow ? 'show' : 'hide']();\n\n            if (typeof result != 'undefined' && result.tierPrices && result.tierPrices.length) {\n                if (this.options.tierPriceTemplate) {\n                    tierPriceHtml = mageTemplate(\n                        this.options.tierPriceTemplate,\n                        {\n                            'tierPrices': result.tierPrices,\n                            '$t': $t,\n                            'currencyFormat': this.options.jsonConfig.currencyFormat,\n                            'priceUtils': priceUtils\n                        }\n                    );\n                    $(this.options.tierPriceBlockSelector).html(tierPriceHtml).show();\n                }\n            } else {\n                $(this.options.tierPriceBlockSelector).hide();\n            }\n\n            $(this.options.normalPriceLabelSelector).hide();\n\n            _.each($('.' + this.options.classes.attributeOptionsWrapper), function (attribute) {\n                if ($(attribute).find('.' + this.options.classes.optionClass + '.selected').length === 0) {\n                    if ($(attribute).find('.' + this.options.classes.selectClass).length > 0) {\n                        _.each($(attribute).find('.' + this.options.classes.selectClass), function (dropdown) {\n                            if ($(dropdown).val() === '0') {\n                                $(this.options.normalPriceLabelSelector).show();\n                            }\n                        }.bind(this));\n                    } else {\n                        $(this.options.normalPriceLabelSelector).show();\n                    }\n                }\n            }.bind(this));\n        },\n\n        /**\n         * Get new prices for selected options\n         *\n         * @returns {*}\n         * @private\n         */\n        _getNewPrices: function () {\n            var $widget = this,\n                newPrices = $widget.options.jsonConfig.prices,\n                allowedProduct = this._getAllowedProductWithMinPrice(this._CalcProducts());\n\n            if (!_.isEmpty(allowedProduct)) {\n                newPrices = this.options.jsonConfig.optionPrices[allowedProduct];\n            }\n\n            return newPrices;\n        },\n\n        /**\n         * Get prices\n         *\n         * @param {Object} newPrices\n         * @param {Object} displayPrices\n         * @returns {*}\n         * @private\n         */\n        _getPrices: function (newPrices, displayPrices) {\n            var $widget = this;\n\n            if (_.isEmpty(newPrices)) {\n                newPrices = $widget._getNewPrices();\n            }\n            _.each(displayPrices, function (price, code) {\n\n                if (newPrices[code]) {\n                    displayPrices[code].amount = newPrices[code].amount - displayPrices[code].amount;\n                }\n            });\n\n            return displayPrices;\n        },\n\n        /**\n         * Get product with minimum price from selected options.\n         *\n         * @param {Array} allowedProducts\n         * @returns {String}\n         * @private\n         */\n        _getAllowedProductWithMinPrice: function (allowedProducts) {\n            var optionPrices = this.options.jsonConfig.optionPrices,\n                product = {},\n                optionFinalPrice, optionMinPrice;\n\n            _.each(allowedProducts, function (allowedProduct) {\n                optionFinalPrice = parseFloat(optionPrices[allowedProduct].finalPrice.amount);\n\n                if (_.isEmpty(product) || optionFinalPrice < optionMinPrice) {\n                    optionMinPrice = optionFinalPrice;\n                    product = allowedProduct;\n                }\n            }, this);\n\n            return product;\n        },\n\n        /**\n         * Gets all product media and change current to the needed one\n         *\n         * @private\n         */\n        _LoadProductMedia: function () {\n            var $widget = this,\n                $this = $widget.element,\n                productData = this._determineProductData(),\n                mediaCallData,\n                mediaCacheKey,\n\n                /**\n                 * Processes product media data\n                 *\n                 * @param {Object} data\n                 * @returns void\n                 */\n                mediaSuccessCallback = function (data) {\n                    if (!(mediaCacheKey in $widget.options.mediaCache)) {\n                        $widget.options.mediaCache[mediaCacheKey] = data;\n                    }\n                    $widget._ProductMediaCallback($this, data, productData.isInProductView);\n                    setTimeout(function () {\n                        $widget._DisableProductMediaLoader($this);\n                    }, 300);\n                };\n\n            if (!$widget.options.mediaCallback) {\n                return;\n            }\n\n            mediaCallData = {\n                'product_id': this.getProduct()\n            };\n\n            mediaCacheKey = JSON.stringify(mediaCallData);\n\n            if (mediaCacheKey in $widget.options.mediaCache) {\n                $widget._XhrKiller();\n                $widget._EnableProductMediaLoader($this);\n                mediaSuccessCallback($widget.options.mediaCache[mediaCacheKey]);\n            } else {\n                mediaCallData.isAjax = true;\n                $widget._XhrKiller();\n                $widget._EnableProductMediaLoader($this);\n                $widget.xhr = $.ajax({\n                    url: $widget.options.mediaCallback,\n                    cache: true,\n                    type: 'GET',\n                    dataType: 'json',\n                    data: mediaCallData,\n                    success: mediaSuccessCallback\n                }).done(function () {\n                    $widget._XhrKiller();\n                });\n            }\n        },\n\n        /**\n         * Enable loader\n         *\n         * @param {Object} $this\n         * @private\n         */\n        _EnableProductMediaLoader: function ($this) {\n            var $widget = this;\n\n            if ($('body.catalog-product-view').length > 0) {\n                $this.parents('.column.main').find('.photo.image')\n                    .addClass($widget.options.classes.loader);\n            } else {\n                //Category View\n                $this.parents('.product-item-info').find('.product-image-photo')\n                    .addClass($widget.options.classes.loader);\n            }\n        },\n\n        /**\n         * Disable loader\n         *\n         * @param {Object} $this\n         * @private\n         */\n        _DisableProductMediaLoader: function ($this) {\n            var $widget = this;\n\n            if ($('body.catalog-product-view').length > 0) {\n                $this.parents('.column.main').find('.photo.image')\n                    .removeClass($widget.options.classes.loader);\n            } else {\n                //Category View\n                $this.parents('.product-item-info').find('.product-image-photo')\n                    .removeClass($widget.options.classes.loader);\n            }\n        },\n\n        /**\n         * Callback for product media\n         *\n         * @param {Object} $this\n         * @param {String} response\n         * @param {Boolean} isInProductView\n         * @private\n         */\n        _ProductMediaCallback: function ($this, response, isInProductView) {\n            var $main = isInProductView ? $this.parents('.column.main') : $this.parents('.product-item-info'),\n                $widget = this,\n                images = [],\n\n                /**\n                 * Check whether object supported or not\n                 *\n                 * @param {Object} e\n                 * @returns {*|Boolean}\n                 */\n                support = function (e) {\n                    return e.hasOwnProperty('large') && e.hasOwnProperty('medium') && e.hasOwnProperty('small');\n                };\n\n            if (_.size($widget) < 1 || !support(response)) {\n                this.updateBaseImage(this.options.mediaGalleryInitial, $main, isInProductView);\n\n                return;\n            }\n\n            images.push({\n                full: response.large,\n                img: response.medium,\n                thumb: response.small,\n                isMain: true\n            });\n\n            if (response.hasOwnProperty('gallery')) {\n                $.each(response.gallery, function () {\n                    if (!support(this) || response.large === this.large) {\n                        return;\n                    }\n                    images.push({\n                        full: this.large,\n                        img: this.medium,\n                        thumb: this.small\n                    });\n                });\n            }\n\n            this.updateBaseImage(images, $main, isInProductView);\n        },\n\n        /**\n         * Check if images to update are initial and set their type\n         * @param {Array} images\n         */\n        _setImageType: function (images) {\n            var initial = this.options.mediaGalleryInitial[0].img;\n\n            if (images[0].img === initial) {\n                images = $.extend(true, [], this.options.mediaGalleryInitial);\n            } else {\n                images.map(function (img) {\n                    if (!img.type) {\n                        img.type = 'image';\n                    }\n                });\n            }\n\n            return images;\n        },\n\n        /**\n         * Update [gallery-placeholder] or [product-image-photo]\n         * @param {Array} images\n         * @param {jQuery} context\n         * @param {Boolean} isInProductView\n         */\n        updateBaseImage: function (images, context, isInProductView) {\n            var justAnImage = images[0],\n                initialImages = this.options.mediaGalleryInitial,\n                imagesToUpdate,\n                gallery = context.find(this.options.mediaGallerySelector).data('gallery'),\n                isInitial;\n\n            if (isInProductView) {\n                if (_.isUndefined(gallery)) {\n                    context.find(this.options.mediaGallerySelector).on('gallery:loaded', function () {\n                        this.updateBaseImage(images, context, isInProductView);\n                    }.bind(this));\n\n                    return;\n                }\n\n                imagesToUpdate = images.length ? this._setImageType($.extend(true, [], images)) : [];\n                isInitial = _.isEqual(imagesToUpdate, initialImages);\n\n                if (this.options.gallerySwitchStrategy === 'prepend' && !isInitial) {\n                    imagesToUpdate = imagesToUpdate.concat(initialImages);\n                }\n\n                imagesToUpdate = this._setImageIndex(imagesToUpdate);\n\n                gallery.updateData(imagesToUpdate);\n                this._addFotoramaVideoEvents(isInitial);\n            } else if (justAnImage && justAnImage.img) {\n                context.find('.product-image-photo').attr('src', justAnImage.img);\n            }\n        },\n\n        /**\n         * Add video events\n         *\n         * @param {Boolean} isInitial\n         * @private\n         */\n        _addFotoramaVideoEvents: function (isInitial) {\n            if (_.isUndefined($.mage.AddFotoramaVideoEvents)) {\n                return;\n            }\n\n            if (isInitial) {\n                $(this.options.mediaGallerySelector).AddFotoramaVideoEvents();\n\n                return;\n            }\n\n            $(this.options.mediaGallerySelector).AddFotoramaVideoEvents({\n                selectedOption: this.getProduct(),\n                dataMergeStrategy: this.options.gallerySwitchStrategy\n            });\n        },\n\n        /**\n         * Set correct indexes for image set.\n         *\n         * @param {Array} images\n         * @private\n         */\n        _setImageIndex: function (images) {\n            var length = images.length,\n                i;\n\n            for (i = 0; length > i; i++) {\n                images[i].i = i + 1;\n            }\n\n            return images;\n        },\n\n        /**\n         * Kill doubled AJAX requests\n         *\n         * @private\n         */\n        _XhrKiller: function () {\n            var $widget = this;\n\n            if ($widget.xhr !== undefined && $widget.xhr !== null) {\n                $widget.xhr.abort();\n                $widget.xhr = null;\n            }\n        },\n\n        /**\n         * Emulate mouse click on all swatches that should be selected\n         * @param {Object} [selectedAttributes]\n         * @private\n         */\n        _EmulateSelected: function (selectedAttributes) {\n            $.each(selectedAttributes, $.proxy(function (attributeCode, optionId) {\n                var elem = this.element.find('.' + this.options.classes.attributeClass +\n                    '[data-attribute-code=\"' + attributeCode + '\"] [data-option-id=\"' + optionId + '\"]'),\n                    parentInput = elem.parent();\n\n                if (elem.hasClass('selected')) {\n                    return;\n                }\n\n                if (parentInput.hasClass(this.options.classes.selectClass)) {\n                    parentInput.val(optionId);\n                    parentInput.trigger('change');\n                } else {\n                    elem.trigger('click');\n                }\n            }, this));\n        },\n\n        /**\n         * Emulate mouse click or selection change on all swatches that should be selected\n         * @param {Object} [selectedAttributes]\n         * @private\n         */\n        _EmulateSelectedByAttributeId: function (selectedAttributes) {\n            $.each(selectedAttributes, $.proxy(function (attributeId, optionId) {\n                var elem = this.element.find('.' + this.options.classes.attributeClass +\n                    '[data-attribute-id=\"' + attributeId + '\"] [data-option-id=\"' + optionId + '\"]'),\n                    parentInput = elem.parent();\n\n                if (elem.hasClass('selected')) {\n                    return;\n                }\n\n                if (parentInput.hasClass(this.options.classes.selectClass)) {\n                    parentInput.val(optionId);\n                    parentInput.trigger('change');\n                } else {\n                    elem.trigger('click');\n                }\n            }, this));\n        },\n\n        /**\n         * Get default options values settings with either URL query parameters\n         * @private\n         */\n        _getSelectedAttributes: function () {\n            var hashIndex = window.location.href.indexOf('#'),\n                selectedAttributes = {},\n                params;\n\n            if (hashIndex !== -1) {\n                params = $.parseQuery(window.location.href.substr(hashIndex + 1));\n\n                selectedAttributes = _.invert(_.mapObject(_.invert(params), function (attributeId) {\n                    var attribute = this.options.jsonConfig.mappedAttributes[attributeId];\n\n                    return attribute ? attribute.code : attributeId;\n                }.bind(this)));\n            }\n\n            return selectedAttributes;\n        },\n\n        /**\n         * Callback which fired after gallery gets initialized.\n         *\n         * @param {HTMLElement} element - DOM element associated with a gallery.\n         */\n        _onGalleryLoaded: function (element) {\n            var galleryObject = element.data('gallery');\n\n            this.options.mediaGalleryInitial = galleryObject.returnCurrentImages();\n        },\n\n        /**\n         * Sets mediaCache for cases when jsonConfig contains preSelectedGallery on layered navigation result pages\n         *\n         * @private\n         */\n        _setPreSelectedGallery: function () {\n            var mediaCallData;\n\n            if (this.options.jsonConfig.preSelectedGallery) {\n                mediaCallData = {\n                    'product_id': this.getProduct()\n                };\n\n                this.options.mediaCache[JSON.stringify(mediaCallData)] = this.options.jsonConfig.preSelectedGallery;\n            }\n        }\n    });\n\n    return $.mage.SwatchRenderer;\n});\n","Magento_Swatches/js/catalog-add-to-cart.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\nrequire([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    /**\n     * Add selected swatch attributes to redirect url\n     *\n     * @see Magento_Catalog/js/catalog-add-to-cart\n     */\n    $('body').on('catalogCategoryAddToCartRedirect', function (event, data) {\n        $(data.form).find('[name*=\"super\"]').each(function (index, item) {\n            var $item = $(item),\n                attr;\n\n            if ($item.attr('data-attr-name')) {\n                attr = $item.attr('data-attr-name');\n            } else {\n                attr = $item.parent().attr('attribute-code');\n            }\n            data.redirectParameters.push(attr + '=' + $item.val());\n\n        });\n    });\n});\n","Magento_Swatches/js/configurable-customer-data.js":"require([\n    'jquery',\n    'Magento_ConfigurableProduct/js/options-updater'\n], function ($, Updater) {\n    'use strict';\n\n    var selectors = {\n            formSelector: '#product_addtocart_form',\n            swatchSelector: '.swatch-opt'\n        },\n        swatchWidgetName = 'mageSwatchRenderer',\n        widgetInitEvent = 'swatch.initialized',\n\n    /**\n    * Sets all configurable swatch attribute's selected values\n    */\n    updateSwatchOptions = function () {\n        var swatchWidget = $(selectors.swatchSelector).data(swatchWidgetName);\n\n        if (!swatchWidget || !swatchWidget._EmulateSelectedByAttributeId) {\n            return;\n        }\n        swatchWidget._EmulateSelectedByAttributeId(this.productOptions);\n    },\n    updater = new Updater(widgetInitEvent, updateSwatchOptions);\n\n    updater.listen();\n});\n","Magento_LoginAsCustomerFrontendUi/js/login.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Customer/js/customer-data',\n    'Magento_Customer/js/section-config'\n], function ($, customerData, sectionConfig) {\n\n    'use strict';\n\n    return function (config) {\n        customerData.reload(sectionConfig.getSectionNames()).done(function () {\n            window.location.href = config.redirectUrl;\n        });\n    };\n});\n","Magento_LoginAsCustomerFrontendUi/js/view/loginAsCustomer.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'uiComponent',\n    'Magento_Customer/js/customer-data',\n    'mage/translate'\n], function ($, _, Component, customer) {\n    'use strict';\n\n    return Component.extend({\n\n        defaults: {\n            isVisible: false\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            var customerData, loggedAsCustomerData;\n\n            this._super();\n\n            customerData = customer.get('customer');\n            loggedAsCustomerData = customer.get('loggedAsCustomer');\n\n            customerData.subscribe(function (data) {\n                this.fullname = data.fullname;\n                this.updateBanner();\n            }.bind(this));\n            loggedAsCustomerData.subscribe(function (data) {\n                this.adminUserId = data.adminUserId;\n                this.websiteName = data.websiteName;\n                this.updateBanner();\n            }.bind(this));\n\n            this.fullname = customerData().fullname;\n            this.adminUserId = loggedAsCustomerData().adminUserId;\n            this.websiteName = loggedAsCustomerData().websiteName;\n\n            this.updateBanner();\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super()\n                .observe(['isVisible', 'notificationText']);\n\n            return this;\n        },\n\n        /**\n         * Update banner area\n         *\n         * @returns void\n         */\n        updateBanner: function () {\n            if (this.adminUserId !== undefined) {\n                this.isVisible(this.adminUserId);\n            }\n\n            if (this.fullname !== undefined && this.websiteName !== undefined) {\n                this.notificationText($.mage.__('You are connected as <strong>%1</strong> on %2')\n                    .replace('%1', _.escape(this.fullname))\n                    .replace('%2', _.escape(this.websiteName)));\n            }\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/configurable.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore',\n    'mage/template',\n    'mage/translate',\n    'priceUtils',\n    'priceBox',\n    'jquery-ui-modules/widget',\n    'jquery/jquery.parsequery',\n    'fotoramaVideoEvents'\n], function ($, _, mageTemplate, $t, priceUtils) {\n    'use strict';\n\n    $.widget('mage.configurable', {\n        options: {\n            superSelector: '.super-attribute-select',\n            selectSimpleProduct: '[name=\"selected_configurable_option\"]',\n            priceHolderSelector: '.price-box',\n            spConfig: {},\n            state: {},\n            priceFormat: {},\n            optionTemplate: '<%- data.label %>' +\n            '<% if (typeof data.finalPrice.value !== \"undefined\") { %>' +\n            ' <%- data.finalPrice.formatted %>' +\n            '<% } %>',\n            mediaGallerySelector: '[data-gallery-role=gallery-placeholder]',\n            mediaGalleryInitial: null,\n            slyOldPriceSelector: '.sly-old-price',\n            normalPriceLabelSelector: '.product-info-main .normal-price .price-label',\n\n            /**\n             * Defines the mechanism of how images of a gallery should be\n             * updated when user switches between configurations of a product.\n             *\n             * As for now value of this option can be either 'replace' or 'prepend'.\n             *\n             * @type {String}\n             */\n            gallerySwitchStrategy: 'replace',\n            tierPriceTemplateSelector: '#tier-prices-template',\n            tierPriceBlockSelector: '[data-role=\"tier-price-block\"]',\n            tierPriceTemplate: ''\n        },\n\n        /**\n         * Creates widget\n         * @private\n         */\n        _create: function () {\n            // Initial setting of various option values\n            this._initializeOptions();\n\n            // Override defaults with URL query parameters and/or inputs values\n            this._overrideDefaults();\n\n            // Change events to check select reloads\n            this._setupChangeEvents();\n\n            // Fill state\n            this._fillState();\n\n            // Setup child and prev/next settings\n            this._setChildSettings();\n\n            // Setup/configure values to inputs\n            this._configureForValues();\n\n            $(this.element).trigger('configurable.initialized');\n        },\n\n        /**\n         * Initialize tax configuration, initial settings, and options values.\n         * @private\n         */\n        _initializeOptions: function () {\n            var options = this.options,\n                gallery = $(options.mediaGallerySelector),\n                priceBoxOptions = $(this.options.priceHolderSelector).priceBox('option').priceConfig || null;\n\n            if (priceBoxOptions && priceBoxOptions.optionTemplate) {\n                options.optionTemplate = priceBoxOptions.optionTemplate;\n            }\n\n            if (priceBoxOptions && priceBoxOptions.priceFormat) {\n                options.priceFormat = priceBoxOptions.priceFormat;\n            }\n            options.optionTemplate = mageTemplate(options.optionTemplate);\n            options.tierPriceTemplate = $(this.options.tierPriceTemplateSelector).html();\n\n            options.settings = options.spConfig.containerId ?\n                $(options.spConfig.containerId).find(options.superSelector) :\n                $(options.superSelector);\n\n            options.values = options.spConfig.defaultValues || {};\n            options.parentImage = $('[data-role=base-image-container] img').attr('src');\n\n            this.inputSimpleProduct = this.element.find(options.selectSimpleProduct);\n\n            gallery.data('gallery') ?\n                this._onGalleryLoaded(gallery) :\n                gallery.on('gallery:loaded', this._onGalleryLoaded.bind(this, gallery));\n\n        },\n\n        /**\n         * Override default options values settings with either URL query parameters or\n         * initialized inputs values.\n         * @private\n         */\n        _overrideDefaults: function () {\n            var hashIndex = window.location.href.indexOf('#');\n\n            if (hashIndex !== -1) {\n                this._parseQueryParams(window.location.href.substr(hashIndex + 1));\n            }\n\n            if (this.options.spConfig.inputsInitialized) {\n                this._setValuesByAttribute();\n            }\n\n            this._setInitialOptionsLabels();\n        },\n\n        /**\n         * Parse query parameters from a query string and set options values based on the\n         * key value pairs of the parameters.\n         * @param {*} queryString - URL query string containing query parameters.\n         * @private\n         */\n        _parseQueryParams: function (queryString) {\n            var queryParams = $.parseQuery({\n                query: queryString\n            });\n\n            $.each(queryParams, $.proxy(function (key, value) {\n                if (this.options.spConfig.attributes[key] !== undefined &&\n                    _.find(this.options.spConfig.attributes[key].options, function (element) {\n                        return element.id === value;\n                    })) {\n                    this.options.values[key] = value;\n                }\n            }, this));\n        },\n\n        /**\n         * Override default options values with values based on each element's attribute\n         * identifier.\n         * @private\n         */\n        _setValuesByAttribute: function () {\n            this.options.values = {};\n            $.each(this.options.settings, $.proxy(function (index, element) {\n                var attributeId;\n\n                if (element.value) {\n                    attributeId = element.id.replace(/[a-z]*/, '');\n\n                    if (this.options.spConfig.attributes[attributeId] !== undefined &&\n                        _.find(this.options.spConfig.attributes[attributeId].options, function (optionElement) {\n                            return optionElement.id === element.value;\n                        })) {\n                        this.options.values[attributeId] = element.value;\n                    }\n                }\n            }, this));\n        },\n\n        /**\n         * Set additional field with initial label to be used when switching between options with different prices.\n         * @private\n         */\n        _setInitialOptionsLabels: function () {\n            $.each(this.options.spConfig.attributes, $.proxy(function (index, element) {\n                $.each(element.options, $.proxy(function (optIndex, optElement) {\n                    this.options.spConfig.attributes[index].options[optIndex].initialLabel = optElement.label;\n                }, this));\n            }, this));\n        },\n\n        /**\n         * Set up .on('change') events for each option element to configure the option.\n         * @private\n         */\n        _setupChangeEvents: function () {\n            $.each(this.options.settings, $.proxy(function (index, element) {\n                $(element).on('change', this, this._configure);\n            }, this));\n        },\n\n        /**\n         * Iterate through the option settings and set each option's element configuration,\n         * attribute identifier. Set the state based on the attribute identifier.\n         * @private\n         */\n        _fillState: function () {\n            $.each(this.options.settings, $.proxy(function (index, element) {\n                var attributeId = element.id.replace(/[a-z]*/, '');\n\n                if (attributeId && this.options.spConfig.attributes[attributeId]) {\n                    element.config = this.options.spConfig.attributes[attributeId];\n                    element.attributeId = attributeId;\n                    this.options.state[attributeId] = false;\n                }\n            }, this));\n        },\n\n        /**\n         * Set each option's child settings, and next/prev option setting. Fill (initialize)\n         * an option's list of selections as needed or disable an option's setting.\n         * @private\n         */\n        _setChildSettings: function () {\n            var childSettings = [],\n                settings = this.options.settings,\n                index = settings.length,\n                option;\n\n            while (index--) {\n                option = settings[index];\n\n                if (index) {\n                    option.disabled = true;\n                } else {\n                    this._fillSelect(option);\n                }\n\n                _.extend(option, {\n                    childSettings: childSettings.slice(),\n                    prevSetting: settings[index - 1],\n                    nextSetting: settings[index + 1]\n                });\n\n                childSettings.push(option);\n            }\n        },\n\n        /**\n         * Setup for all configurable option settings. Set the value of the option and configure\n         * the option, which sets its state, and initializes the option's choices, etc.\n         * @private\n         */\n        _configureForValues: function () {\n            if (this.options.values) {\n                this.options.settings.each($.proxy(function (index, element) {\n                    var attributeId = element.attributeId;\n\n                    element.value = this.options.values[attributeId] || '';\n                    this._configureElement(element);\n                }, this));\n            }\n        },\n\n        /**\n         * Event handler for configuring an option.\n         * @private\n         * @param {Object} event - Event triggered to configure an option.\n         */\n        _configure: function (event) {\n            event.data._configureElement(this);\n        },\n\n        /**\n         * Configure an option, initializing it's state and enabling related options, which\n         * populates the related option's selection and resets child option selections.\n         * @private\n         * @param {*} element - The element associated with a configurable option.\n         */\n        _configureElement: function (element) {\n            this.simpleProduct = this._getSimpleProductId(element);\n\n            if (element.value) {\n                this.options.state[element.config.id] = element.value;\n\n                if (element.nextSetting) {\n                    element.nextSetting.disabled = false;\n                    this._fillSelect(element.nextSetting);\n                    this._resetChildren(element.nextSetting);\n                } else {\n                    if (!!document.documentMode) { //eslint-disable-line\n                        this.inputSimpleProduct.val(element.options[element.selectedIndex].config.allowedProducts[0]);\n                    } else {\n                        this.inputSimpleProduct.val(element.selectedOptions[0].config.allowedProducts[0]);\n                    }\n                }\n            } else {\n                this._resetChildren(element);\n            }\n\n            this._reloadPrice();\n            this._displayRegularPriceBlock(this.simpleProduct);\n            this._displayTierPriceBlock(this.simpleProduct);\n            this._displayNormalPriceLabel();\n            this._changeProductImage();\n        },\n\n        /**\n         * Change displayed product image according to chosen options of configurable product\n         *\n         * @private\n         */\n        _changeProductImage: function () {\n            var images,\n                initialImages = this.options.mediaGalleryInitial,\n                gallery = $(this.options.mediaGallerySelector).data('gallery');\n\n            if (_.isUndefined(gallery)) {\n                $(this.options.mediaGallerySelector).on('gallery:loaded', function () {\n                    this._changeProductImage();\n                }.bind(this));\n\n                return;\n            }\n\n            images = this.options.spConfig.images[this.simpleProduct];\n\n            if (images) {\n                images = this._sortImages(images);\n\n                if (this.options.gallerySwitchStrategy === 'prepend') {\n                    images = images.concat(initialImages);\n                }\n\n                images = $.extend(true, [], images);\n                images = this._setImageIndex(images);\n\n                gallery.updateData(images);\n                this._addFotoramaVideoEvents(false);\n            } else {\n                gallery.updateData(initialImages);\n                this._addFotoramaVideoEvents(true);\n            }\n        },\n\n        /**\n         * Add video events\n         *\n         * @param {Boolean} isInitial\n         * @private\n         */\n        _addFotoramaVideoEvents: function (isInitial) {\n            if (_.isUndefined($.mage.AddFotoramaVideoEvents)) {\n                return;\n            }\n\n            if (isInitial) {\n                $(this.options.mediaGallerySelector).AddFotoramaVideoEvents();\n\n                return;\n            }\n\n            $(this.options.mediaGallerySelector).AddFotoramaVideoEvents({\n                selectedOption: this.simpleProduct,\n                dataMergeStrategy: this.options.gallerySwitchStrategy\n            });\n        },\n\n        /**\n         * Sorting images array\n         *\n         * @private\n         */\n        _sortImages: function (images) {\n            return _.sortBy(images, function (image) {\n                return image.position;\n            });\n        },\n\n        /**\n         * Set correct indexes for image set.\n         *\n         * @param {Array} images\n         * @private\n         */\n        _setImageIndex: function (images) {\n            var length = images.length,\n                i;\n\n            for (i = 0; length > i; i++) {\n                images[i].i = i + 1;\n            }\n\n            return images;\n        },\n\n        /**\n         * For a given option element, reset all of its selectable options. Clear any selected\n         * index, disable the option choice, and reset the option's state if necessary.\n         * @private\n         * @param {*} element - The element associated with a configurable option.\n         */\n        _resetChildren: function (element) {\n            if (element.childSettings) {\n                _.each(element.childSettings, function (set) {\n                    set.selectedIndex = 0;\n                    set.disabled = true;\n                });\n\n                if (element.config) {\n                    this.options.state[element.config.id] = false;\n                }\n            }\n        },\n\n        /**\n         * Populates an option's selectable choices.\n         * @private\n         * @param {*} element - Element associated with a configurable option.\n         */\n        _fillSelect: function (element) {\n            var attributeId = element.id.replace(/[a-z]*/, ''),\n                options = this._getAttributeOptions(attributeId),\n                prevConfig,\n                index = 1,\n                allowedProducts,\n                allowedProductsByOption,\n                allowedProductsAll,\n                i,\n                j,\n                finalPrice = parseFloat(this.options.spConfig.prices.finalPrice.amount),\n                optionFinalPrice,\n                optionPriceDiff,\n                optionPrices = this.options.spConfig.optionPrices,\n                allowedOptions = [],\n                indexKey,\n                allowedProductMinPrice,\n                allowedProductsAllMinPrice;\n\n            this._clearSelect(element);\n            element.options[0] = new Option('', '');\n            element.options[0].innerHTML = this.options.spConfig.chooseText;\n            prevConfig = false;\n\n            if (element.prevSetting) {\n                prevConfig = element.prevSetting.options[element.prevSetting.selectedIndex];\n            }\n\n            if (options) {\n                for (indexKey in this.options.spConfig.index) {\n                    /* eslint-disable max-depth */\n                    if (this.options.spConfig.index.hasOwnProperty(indexKey)) {\n                        allowedOptions = allowedOptions.concat(_.values(this.options.spConfig.index[indexKey]));\n                    }\n                }\n\n                if (prevConfig) {\n                    allowedProductsByOption = {};\n                    allowedProductsAll = [];\n\n                    for (i = 0; i < options.length; i++) {\n                        /* eslint-disable max-depth */\n                        for (j = 0; j < options[i].products.length; j++) {\n                            // prevConfig.config can be undefined\n                            if (prevConfig.config &&\n                                prevConfig.config.allowedProducts &&\n                                prevConfig.config.allowedProducts.indexOf(options[i].products[j]) > -1) {\n                                if (!allowedProductsByOption[i]) {\n                                    allowedProductsByOption[i] = [];\n                                }\n                                allowedProductsByOption[i].push(options[i].products[j]);\n                                allowedProductsAll.push(options[i].products[j]);\n                            }\n                        }\n                    }\n\n                    if (typeof allowedProductsAll[0] !== 'undefined' &&\n                        typeof optionPrices[allowedProductsAll[0]] !== 'undefined') {\n                        allowedProductsAllMinPrice = this._getAllowedProductWithMinPrice(allowedProductsAll);\n                        finalPrice = parseFloat(optionPrices[allowedProductsAllMinPrice].finalPrice.amount);\n                    }\n                }\n\n                for (i = 0; i < options.length; i++) {\n                    if (prevConfig && typeof allowedProductsByOption[i] === 'undefined') {\n                        continue; //jscs:ignore disallowKeywords\n                    }\n\n                    allowedProducts = prevConfig ? allowedProductsByOption[i] : options[i].products.slice(0);\n                    optionPriceDiff = 0;\n\n                    if (typeof allowedProducts[0] !== 'undefined' &&\n                        typeof optionPrices[allowedProducts[0]] !== 'undefined') {\n                        allowedProductMinPrice = this._getAllowedProductWithMinPrice(allowedProducts);\n                        optionFinalPrice = parseFloat(optionPrices[allowedProductMinPrice].finalPrice.amount);\n                        optionPriceDiff = optionFinalPrice - finalPrice;\n                        options[i].label = options[i].initialLabel;\n\n                        if (optionPriceDiff !== 0) {\n                            options[i].label += ' ' + priceUtils.formatPrice(\n                                optionPriceDiff,\n                                this.options.priceFormat,\n                                true\n                            );\n                        }\n                    }\n\n                    if (allowedProducts.length > 0 || _.include(allowedOptions, options[i].id)) {\n                        options[i].allowedProducts = allowedProducts;\n                        element.options[index] = new Option(this._getOptionLabel(options[i]), options[i].id);\n\n                        if (typeof options[i].price !== 'undefined') {\n                            element.options[index].setAttribute('price', options[i].price);\n                        }\n\n                        if (allowedProducts.length === 0) {\n                            element.options[index].disabled = true;\n                        }\n\n                        element.options[index].config = options[i];\n                        index++;\n                    }\n\n                    /* eslint-enable max-depth */\n                }\n            }\n        },\n\n        /**\n         * Generate the label associated with a configurable option. This includes the option's\n         * label or value and the option's price.\n         * @private\n         * @param {*} option - A single choice among a group of choices for a configurable option.\n         * @return {String} The option label with option value and price (e.g. Black +1.99)\n         */\n        _getOptionLabel: function (option) {\n            return option.label;\n        },\n\n        /**\n         * Removes an option's selections.\n         * @private\n         * @param {*} element - The element associated with a configurable option.\n         */\n        _clearSelect: function (element) {\n            var i;\n\n            for (i = element.options.length - 1; i >= 0; i--) {\n                element.remove(i);\n            }\n        },\n\n        /**\n         * Retrieve the attribute options associated with a specific attribute Id.\n         * @private\n         * @param {Number} attributeId - The id of the attribute whose configurable options are sought.\n         * @return {Object} Object containing the attribute options.\n         */\n        _getAttributeOptions: function (attributeId) {\n            if (this.options.spConfig.attributes[attributeId]) {\n                return this.options.spConfig.attributes[attributeId].options;\n            }\n        },\n\n        /**\n         * Reload the price of the configurable product incorporating the prices of all of the\n         * configurable product's option selections.\n         */\n        _reloadPrice: function () {\n            $(this.options.priceHolderSelector).trigger('updatePrice', this._getPrices());\n        },\n\n        /**\n         * Get product various prices\n         * @returns {{}}\n         * @private\n         */\n        _getPrices: function () {\n            var prices = {},\n                elements = _.toArray(this.options.settings),\n                allowedProduct;\n\n            _.each(elements, function (element) {\n                var selected = element.options[element.selectedIndex],\n                    config = selected && selected.config,\n                    priceValue = this._calculatePrice({});\n\n                if (config && config.allowedProducts.length === 1) {\n                    priceValue = this._calculatePrice(config);\n                } else if (element.value) {\n                    allowedProduct = this._getAllowedProductWithMinPrice(config.allowedProducts);\n                    priceValue = this._calculatePrice({\n                        'allowedProducts': [\n                            allowedProduct\n                        ]\n                    });\n                }\n\n                if (!_.isEmpty(priceValue)) {\n                    prices.prices = priceValue;\n                }\n            }, this);\n\n            return prices;\n        },\n\n        /**\n         * Get product with minimum price from selected options.\n         *\n         * @param {Array} allowedProducts\n         * @returns {String}\n         * @private\n         */\n        _getAllowedProductWithMinPrice: function (allowedProducts) {\n            var optionPrices = this.options.spConfig.optionPrices,\n                product = {},\n                optionMinPrice, optionFinalPrice;\n\n            _.each(allowedProducts, function (allowedProduct) {\n                optionFinalPrice = parseFloat(optionPrices[allowedProduct].finalPrice.amount);\n\n                if (_.isEmpty(product) || optionFinalPrice < optionMinPrice) {\n                    optionMinPrice = optionFinalPrice;\n                    product = allowedProduct;\n                }\n            }, this);\n\n            return product;\n        },\n\n        /**\n         * Returns prices for configured products\n         *\n         * @param {*} config - Products configuration\n         * @returns {*}\n         * @private\n         */\n        _calculatePrice: function (config) {\n            var displayPrices = $(this.options.priceHolderSelector).priceBox('option').prices,\n                newPrices = this.options.spConfig.optionPrices[_.first(config.allowedProducts)] || {};\n\n            _.each(displayPrices, function (price, code) {\n                displayPrices[code].amount = newPrices[code] ? newPrices[code].amount - displayPrices[code].amount : 0;\n            });\n\n            return displayPrices;\n        },\n\n        /**\n         * Returns Simple product Id\n         *  depending on current selected option.\n         *\n         * @private\n         * @param {HTMLElement} element\n         * @returns {String|undefined}\n         */\n        _getSimpleProductId: function (element) {\n            // TODO: Rewrite algorithm. It should return ID of\n            //        simple product based on selected options.\n            var allOptions = element.config.options,\n                value = element.value,\n                config;\n\n            config = _.filter(allOptions, function (option) {\n                return option.id === value;\n            });\n            config = _.first(config);\n\n            return _.isEmpty(config) ?\n                undefined :\n                _.first(config.allowedProducts);\n\n        },\n\n        /**\n         * Show or hide regular price block\n         *\n         * @param {*} optionId\n         * @private\n         */\n        _displayRegularPriceBlock: function (optionId) {\n            var shouldBeShown = true;\n\n            _.each(this.options.settings, function (element) {\n                if (element.value === '') {\n                    shouldBeShown = false;\n                }\n            });\n\n            if (shouldBeShown &&\n                this.options.spConfig.optionPrices[optionId].oldPrice.amount !==\n                this.options.spConfig.optionPrices[optionId].finalPrice.amount\n            ) {\n                $(this.options.slyOldPriceSelector).show();\n            } else {\n                $(this.options.slyOldPriceSelector).hide();\n            }\n\n            $(document).trigger('updateMsrpPriceBlock',\n                [\n                    optionId,\n                    this.options.spConfig.optionPrices\n                ]\n            );\n        },\n\n        /**\n         * Show or hide normal price label\n         *\n         * @private\n         */\n        _displayNormalPriceLabel: function () {\n            var shouldBeShown = false;\n\n            _.each(this.options.settings, function (element) {\n                if (element.value === '') {\n                    shouldBeShown = true;\n                }\n            });\n\n            if (shouldBeShown) {\n                $(this.options.normalPriceLabelSelector).show();\n            } else {\n                $(this.options.normalPriceLabelSelector).hide();\n            }\n        },\n\n        /**\n         * Callback which fired after gallery gets initialized.\n         *\n         * @param {HTMLElement} element - DOM element associated with gallery.\n         */\n        _onGalleryLoaded: function (element) {\n            var galleryObject = element.data('gallery');\n\n            this.options.mediaGalleryInitial = galleryObject.returnCurrentImages();\n        },\n\n        /**\n         * Show or hide tier price block\n         *\n         * @param {*} optionId\n         * @private\n         */\n        _displayTierPriceBlock: function (optionId) {\n            var tierPrices = typeof optionId != 'undefined' && this.options.spConfig.optionPrices[optionId].tierPrices;\n\n            if (_.isArray(tierPrices) && tierPrices.length > 0) {\n\n                if (this.options.tierPriceTemplate) {\n                    $(this.options.tierPriceBlockSelector).html(\n                        mageTemplate(this.options.tierPriceTemplate, {\n                            'tierPrices': tierPrices,\n                            '$t': $t,\n                            'currencyFormat': this.options.spConfig.currencyFormat,\n                            'priceUtils': priceUtils\n                        })\n                    ).show();\n                }\n            } else {\n                $(this.options.tierPriceBlockSelector).hide();\n            }\n        }\n    });\n\n    return $.mage.configurable;\n});\n","Magento_ConfigurableProduct/js/catalog-add-to-cart-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'jquery',\n    'Magento_ConfigurableProduct/js/product/view/product-info-resolver'\n], function (_, $, productInfoResolver) {\n    'use strict';\n\n    return function (widget) {\n\n        $.widget('mage.catalogAddToCart', widget, {\n            /**\n             * @param {jQuery} form\n             */\n            ajaxSubmit: function (form) {\n                var isConfigurable = !!_.find(form.serializeArray(), function (item) {\n                    return item.name.indexOf('super_attribute') !== -1;\n                });\n\n                if (isConfigurable) {\n                    this.options.productInfoResolver = productInfoResolver;\n                }\n\n                return this._super(form);\n            }\n        });\n\n        return $.mage.catalogAddToCart;\n    };\n});\n","Magento_ConfigurableProduct/js/catalog-add-to-cart.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\nrequire([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    /**\n     * Add selected configurable attributes to redirect url\n     *\n     * @see Magento_Catalog/js/catalog-add-to-cart\n     */\n    $('body').on('catalogCategoryAddToCartRedirect', function (event, data) {\n        $(data.form).find('select[name*=\"super\"]').each(function (index, item) {\n            data.redirectParameters.push(item.config.id + '=' + $(item).val());\n        });\n    });\n});\n","Magento_ConfigurableProduct/js/configurable-customer-data.js":"require([\n    'jquery',\n    'Magento_ConfigurableProduct/js/options-updater'\n], function ($, Updater) {\n    'use strict';\n\n    var selectors = {\n            formSelector: '#product_addtocart_form'\n        },\n        configurableWidgetName = 'mageConfigurable',\n        widgetInitEvent = 'configurable.initialized',\n\n    /**\n    * Sets all configurable attribute's selected values\n    */\n    updateConfigurableOptions = function () {\n        var configurableWidget = $(selectors.formSelector).data(configurableWidgetName);\n\n        if (!configurableWidget) {\n            return;\n        }\n        configurableWidget.options.values = this.productOptions || {};\n        configurableWidget._configureForValues();\n    },\n    updater = new Updater(widgetInitEvent, updateConfigurableOptions);\n\n    updater.listen();\n});\n","Magento_ConfigurableProduct/js/options-updater.js":"define([\n    'jquery',\n    'underscore',\n    'Magento_Customer/js/customer-data'\n], function ($, _, customerData) {\n    'use strict';\n\n    var selectors = {\n        formSelector: '#product_addtocart_form',\n        productIdSelector: '#product_addtocart_form [name=\"product\"]',\n        itemIdSelector: '#product_addtocart_form [name=\"item\"]'\n    },\n    cartData = customerData.get('cart'),\n    productId = $(selectors.productIdSelector).val(),\n    itemId = $(selectors.itemIdSelector).val(),\n\n    /**\n    * set productOptions according to cart data from customer-data\n    *\n    * @param {Object} data - cart data from customer-data\n    * @returns {Boolean} - whether the new options differ from previous\n    */\n    setProductOptions = function (data) {\n        var changedProductOptions;\n\n        if (!(data && data.items && data.items.length && productId)) {\n            return false;\n        }\n        changedProductOptions = _.find(data.items, function (item) {\n            if (item['item_id'] === itemId) {\n                return item['product_id'] === productId;\n            }\n        });\n        changedProductOptions = changedProductOptions && changedProductOptions.options &&\n            changedProductOptions.options.reduce(function (obj, val) {\n                obj[val['option_id']] = val['option_value'];\n\n                return obj;\n            }, {});\n\n        if (JSON.stringify(this.productOptions || {}) === JSON.stringify(changedProductOptions || {})) {\n            return false;\n        }\n\n        this.productOptions = changedProductOptions;\n\n        return true;\n    },\n\n    /**\n    * Listens to update of cart data or options initialization and update selected option according to customer data\n    *\n    */\n    listen = function () {\n        cartData.subscribe(function (updateCartData) {\n            if (this.setProductOptions(updateCartData)) {\n                this.updateOptions();\n            }\n        }.bind(this));\n        $(selectors.formSelector).on(this.eventName, function () {\n            this.setProductOptions(cartData());\n            this.updateOptions();\n        }.bind(this));\n    },\n\n    /**\n    * Updater constructor function\n    *\n    */\n    Updater = function (eventName, updateOptionsCallback) {\n        if (this instanceof Updater) {\n            this.eventName = eventName;\n            this.updateOptions = updateOptionsCallback;\n            this.productOptions = {};\n        }\n    };\n\n    Updater.prototype.setProductOptions = setProductOptions;\n    Updater.prototype.listen = listen;\n\n    return Updater;\n});\n","Magento_ConfigurableProduct/js/product/view/product-info-resolver.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'Magento_Catalog/js/product/view/product-info'\n], function (_, productInfo) {\n    'use strict';\n\n    /**\n     * Returns info about configurable products in form.\n     *\n     * @param {jQuery} $form\n     * @return {Array}\n     */\n    return function ($form) {\n        var optionValues = [],\n            product = _.findWhere($form.serializeArray(), {\n                name: 'product'\n            }),\n            productId;\n\n        if (!_.isUndefined(product)) {\n            productId = product.value;\n            _.each($form.serializeArray(), function (item) {\n                if (item.name.indexOf('super_attribute') !== -1) {\n                    optionValues.push(item.value);\n                }\n            });\n            optionValues.sort();\n            productInfo().push(\n                {\n                    'id': productId,\n                    'optionValues': optionValues\n                }\n            );\n        }\n\n        return _.uniq(productInfo(), function (item) {\n            var optionValuesStr = item.optionValues ? item.optionValues.join() : '';\n\n            return item.id + optionValuesStr;\n        });\n    };\n});\n\n","Magento_ReCaptchaFrontendUi/js/ui-messages-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['Magento_ReCaptchaFrontendUi/js/registry'], function (registry) {\n    'use strict';\n\n    return function (originalComponent) {\n        return originalComponent.extend({\n            /**\n             * Initialize reset on messages\n             * @returns {initialize}\n             */\n            initialize: function () {\n                this._super();\n\n                this.messageContainer.errorMessages.subscribe(function () {\n                    var\n                        i,\n                        captchaList = registry.captchaList(),\n                        tokenFieldsList = registry.tokenFields();\n\n                    for (i = 0; i < captchaList.length; i++) {\n                        // eslint-disable-next-line no-undef\n                        grecaptcha.reset(captchaList[i]);\n\n                        if (tokenFieldsList[i]) {\n                            tokenFieldsList[i].value = '';\n                        }\n                    }\n                }, null, 'arrayChange');\n\n                return this;\n            }\n        });\n    };\n});\n","Magento_ReCaptchaFrontendUi/js/registry.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['ko'], function (ko) {\n    'use strict';\n\n    return {\n        ids: ko.observableArray([]),\n        captchaList: ko.observableArray([]),\n        tokenFields: ko.observableArray([])\n    };\n});\n","Magento_ReCaptchaFrontendUi/js/nonInlineReCaptchaRenderer.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global grecaptcha */\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    var reCaptchaEntities = [],\n        initialized = false,\n        rendererRecaptchaId = 'recaptcha-invisible',\n        rendererReCaptcha = null;\n\n    return {\n        /**\n         * Add reCaptcha entity to checklist.\n         *\n         * @param {jQuery} reCaptchaEntity\n         * @param {Object} parameters\n         */\n        add: function (reCaptchaEntity, parameters) {\n            if (!initialized) {\n                this.init();\n                grecaptcha.render(rendererRecaptchaId, parameters);\n                setInterval(this.resolveVisibility, 100);\n                initialized = true;\n            }\n\n            reCaptchaEntities.push(reCaptchaEntity);\n        },\n\n        /**\n         * Show additional reCaptcha instance if any other should be visible, otherwise hide it.\n         */\n        resolveVisibility: function () {\n            reCaptchaEntities.some(function (entity) {\n                return entity.is(':visible') &&\n                    // 900 is some magic z-index value of modal popups.\n                    (entity.closest('[data-role=\\'modal\\']').length === 0 || entity.zIndex() > 900);\n            }) ? rendererReCaptcha.show() : rendererReCaptcha.hide();\n        },\n\n        /**\n         * Initialize additional reCaptcha instance.\n         */\n        init: function () {\n            rendererReCaptcha = $('<div/>', {\n                'id': rendererRecaptchaId\n            });\n            rendererReCaptcha.hide();\n            $('body').append(rendererReCaptcha);\n        }\n    };\n});\n","Magento_ReCaptchaFrontendUi/js/reCaptchaScriptLoader.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    var scriptTagAdded = false;\n\n    return {\n        /**\n         * Add script tag. Script tag should be added once\n         */\n        addReCaptchaScriptTag: function () {\n            var element, scriptTag;\n\n            if (!scriptTagAdded) {\n                element = document.createElement('script');\n                scriptTag = document.getElementsByTagName('script')[0];\n\n                element.async = true;\n                element.src = 'https://www.google.com/recaptcha/api.js' +\n                    '?onload=globalOnRecaptchaOnLoadCallback&render=explicit';\n\n                scriptTag.parentNode.insertBefore(element, scriptTag);\n                scriptTagAdded = true;\n            }\n        }\n    };\n});\n","Magento_ReCaptchaFrontendUi/js/reCaptcha.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global grecaptcha */\ndefine(\n    [\n        'uiComponent',\n        'jquery',\n        'ko',\n        'underscore',\n        'Magento_ReCaptchaFrontendUi/js/registry',\n        'Magento_ReCaptchaFrontendUi/js/reCaptchaScriptLoader',\n        'Magento_ReCaptchaFrontendUi/js/nonInlineReCaptchaRenderer'\n    ], function (Component, $, ko, _, registry, reCaptchaLoader, nonInlineReCaptchaRenderer) {\n        'use strict';\n\n        return Component.extend({\n\n            defaults: {\n                template: 'Magento_ReCaptchaFrontendUi/reCaptcha',\n                reCaptchaId: 'recaptcha'\n            },\n\n            /**\n             * @inheritdoc\n             */\n            initialize: function () {\n                this._super();\n                this._loadApi();\n            },\n\n            /**\n             * Loads recaptchaapi API and triggers event, when loaded\n             * @private\n             */\n            _loadApi: function () {\n                if (this._isApiRegistered !== undefined) {\n                    if (this._isApiRegistered === true) {\n                        $(window).trigger('recaptchaapiready');\n                    }\n\n                    return;\n                }\n                this._isApiRegistered = false;\n\n                // global function\n                window.globalOnRecaptchaOnLoadCallback = function () {\n                    this._isApiRegistered = true;\n                    $(window).trigger('recaptchaapiready');\n                }.bind(this);\n\n                reCaptchaLoader.addReCaptchaScriptTag();\n            },\n\n            /**\n             * Checking that reCAPTCHA is invisible type\n             * @returns {Boolean}\n             */\n            getIsInvisibleRecaptcha: function () {\n                return this.settings.invisible;\n            },\n\n            /**\n             * reCAPTCHA callback\n             * @param {String} token\n             */\n            reCaptchaCallback: function (token) {\n                if (this.getIsInvisibleRecaptcha()) {\n                    this.tokenField.value = token;\n                    this.$parentForm.submit();\n                }\n            },\n\n            /**\n             * Initialize reCAPTCHA after first rendering\n             */\n            initCaptcha: function () {\n                var $parentForm,\n                    $wrapper,\n                    $reCaptcha,\n                    widgetId,\n                    parameters;\n\n                if (this.captchaInitialized) {\n                    return;\n                }\n\n                this.captchaInitialized = true;\n\n                /*\n                 * Workaround for data-bind issue:\n                 * We cannot use data-bind to link a dynamic id to our component\n                 * See:\n                 * https://stackoverflow.com/questions/46657573/recaptcha-the-bind-parameter-must-be-an-element-or-id\n                 *\n                 * We create a wrapper element with a wrapping id and we inject the real ID with jQuery.\n                 * In this way we have no data-bind attribute at all in our reCAPTCHA div\n                 */\n                $wrapper = $('#' + this.getReCaptchaId() + '-wrapper');\n                $reCaptcha = $wrapper.find('.g-recaptcha');\n                $reCaptcha.attr('id', this.getReCaptchaId());\n\n                $parentForm = $wrapper.parents('form');\n\n                parameters = _.extend(\n                    {\n                        'callback': function (token) { // jscs:ignore jsDoc\n                            this.reCaptchaCallback(token);\n                            this.validateReCaptcha(true);\n                        }.bind(this),\n                        'expired-callback': function () {\n                            this.validateReCaptcha(false);\n                        }.bind(this)\n                    },\n                    this.settings.rendering\n                );\n\n                if (parameters.size === 'invisible' && parameters.badge !== 'inline') {\n                    nonInlineReCaptchaRenderer.add($reCaptcha, parameters);\n                }\n\n                // eslint-disable-next-line no-undef\n                widgetId = grecaptcha.render(this.getReCaptchaId(), parameters);\n                this.initParentForm($parentForm, widgetId);\n\n                registry.ids.push(this.getReCaptchaId());\n                registry.captchaList.push(widgetId);\n                registry.tokenFields.push(this.tokenField);\n\n            },\n\n            /**\n             * Initialize parent form.\n             *\n             * @param {Object} parentForm\n             * @param {String} widgetId\n             */\n            initParentForm: function (parentForm, widgetId) {\n                var listeners;\n\n                if (this.getIsInvisibleRecaptcha() && parentForm.length > 0) {\n                    parentForm.submit(function (event) {\n                        if (!this.tokenField.value) {\n                            // eslint-disable-next-line no-undef\n                            grecaptcha.execute(widgetId);\n                            event.preventDefault(event);\n                            event.stopImmediatePropagation();\n                        }\n                    }.bind(this));\n\n                    // Move our (last) handler topmost. We need this to avoid submit bindings with ko.\n                    listeners = $._data(parentForm[0], 'events').submit;\n                    listeners.unshift(listeners.pop());\n\n                    // Create a virtual token field\n                    this.tokenField = $('<input type=\"text\" name=\"token\" style=\"display: none\" />')[0];\n                    this.$parentForm = parentForm;\n                    parentForm.append(this.tokenField);\n                } else {\n                    this.tokenField = null;\n                }\n            },\n\n            /**\n             * Validates reCAPTCHA\n             * @param {*} state\n             * @returns {jQuery}\n             */\n            validateReCaptcha: function (state) {\n                if (!this.getIsInvisibleRecaptcha()) {\n                    return $(document).find('input[type=checkbox].required-captcha').prop('checked', state);\n                }\n            },\n\n            /**\n             * Render reCAPTCHA\n             */\n            renderReCaptcha: function () {\n                if (window.grecaptcha && window.grecaptcha.render) { // Check if reCAPTCHA is already loaded\n                    this.initCaptcha();\n                } else { // Wait for reCAPTCHA to be loaded\n                    $(window).on('recaptchaapiready', function () {\n                        this.initCaptcha();\n                    }.bind(this));\n                }\n            },\n\n            /**\n             * Get reCAPTCHA ID\n             * @returns {String}\n             */\n            getReCaptchaId: function () {\n                return this.reCaptchaId;\n            }\n        });\n    });\n","Magento_CheckoutAgreements/js/model/agreements-assigner.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/*global alert*/\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    var agreementsConfig = window.checkoutConfig.checkoutAgreements;\n\n    /** Override default place order action and add agreement_ids to request */\n    return function (paymentData) {\n        var agreementForm,\n            agreementData,\n            agreementIds;\n\n        if (!agreementsConfig.isEnabled) {\n            return;\n        }\n\n        agreementForm = $('.payment-method._active div[data-role=checkout-agreements] input');\n        agreementData = agreementForm.serializeArray();\n        agreementIds = [];\n\n        agreementData.forEach(function (item) {\n            agreementIds.push(item.value);\n        });\n\n        if (paymentData['extension_attributes'] === undefined) {\n            paymentData['extension_attributes'] = {};\n        }\n\n        paymentData['extension_attributes']['agreement_ids'] = agreementIds;\n    };\n});\n","Magento_CheckoutAgreements/js/model/set-payment-information-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global alert*/\ndefine([\n    'jquery',\n    'mage/utils/wrapper',\n    'Magento_CheckoutAgreements/js/model/agreements-assigner'\n], function ($, wrapper, agreementsAssigner) {\n    'use strict';\n\n    return function (placeOrderAction) {\n\n        /** Override place-order-mixin for set-payment-information action as they differs only by method signature */\n        return wrapper.wrap(placeOrderAction, function (originalAction, messageContainer, paymentData) {\n            agreementsAssigner(paymentData);\n\n            return originalAction(messageContainer, paymentData);\n        });\n    };\n});\n","Magento_CheckoutAgreements/js/model/agreement-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/validation'\n], function ($) {\n    'use strict';\n\n    var checkoutConfig = window.checkoutConfig,\n        agreementsConfig = checkoutConfig ? checkoutConfig.checkoutAgreements : {},\n        agreementsInputPath = '.payment-method._active div.checkout-agreements input';\n\n    return {\n        /**\n         * Validate checkout agreements\n         *\n         * @returns {Boolean}\n         */\n        validate: function (hideError) {\n            var isValid = true;\n\n            if (!agreementsConfig.isEnabled || $(agreementsInputPath).length === 0) {\n                return true;\n            }\n\n            $(agreementsInputPath).each(function (index, element) {\n                if (!$.validator.validateSingleElement(element, {\n                    errorElement: 'div',\n                    hideError: hideError || false\n                })) {\n                    isValid = false;\n                }\n            });\n\n            return isValid;\n        }\n    };\n});\n","Magento_CheckoutAgreements/js/model/place-order-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/utils/wrapper',\n    'Magento_CheckoutAgreements/js/model/agreements-assigner'\n], function ($, wrapper, agreementsAssigner) {\n    'use strict';\n\n    return function (placeOrderAction) {\n\n        /** Override default place order action and add agreement_ids to request */\n        return wrapper.wrap(placeOrderAction, function (originalAction, paymentData, messageContainer) {\n            agreementsAssigner(paymentData);\n\n            return originalAction(paymentData, messageContainer);\n        });\n    };\n});\n","Magento_CheckoutAgreements/js/model/agreements-modal.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/modal',\n    'mage/translate'\n], function ($, modal, $t) {\n    'use strict';\n\n    return {\n        modalWindow: null,\n\n        /**\n         * Create popUp window for provided element.\n         *\n         * @param {HTMLElement} element\n         */\n        createModal: function (element) {\n            var options;\n\n            this.modalWindow = element;\n            options = {\n                'type': 'popup',\n                'modalClass': 'agreements-modal',\n                'responsive': true,\n                'innerScroll': true,\n                'trigger': '.show-modal',\n                'buttons': [\n                    {\n                        text: $t('Close'),\n                        class: 'action secondary action-hide-popup',\n\n                        /** @inheritdoc */\n                        click: function () {\n                            this.closeModal();\n                        }\n                    }\n                ]\n            };\n            modal(options, $(this.modalWindow));\n        },\n\n        /** Show login popup window */\n        showModal: function () {\n            $(this.modalWindow).modal('openModal');\n        }\n    };\n});\n","Magento_CheckoutAgreements/js/view/checkout-agreements.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'jquery',\n    'uiComponent',\n    'Magento_CheckoutAgreements/js/model/agreements-modal'\n], function (ko, $, Component, agreementsModal) {\n    'use strict';\n\n    var checkoutConfig = window.checkoutConfig,\n        agreementManualMode = 1,\n        agreementsConfig = checkoutConfig ? checkoutConfig.checkoutAgreements : {};\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_CheckoutAgreements/checkout/checkout-agreements'\n        },\n        isVisible: agreementsConfig.isEnabled,\n        agreements: agreementsConfig.agreements,\n        modalTitle: ko.observable(null),\n        modalContent: ko.observable(null),\n        contentHeight: ko.observable(null),\n        modalWindow: null,\n\n        /**\n         * Checks if agreement required\n         *\n         * @param {Object} element\n         */\n        isAgreementRequired: function (element) {\n            return element.mode == agreementManualMode; //eslint-disable-line eqeqeq\n        },\n\n        /**\n         * Show agreement content in modal\n         *\n         * @param {Object} element\n         */\n        showContent: function (element) {\n            this.modalTitle(element.checkboxText);\n            this.modalContent(element.content);\n            this.contentHeight(element.contentHeight ? element.contentHeight : 'auto');\n            agreementsModal.showModal();\n        },\n\n        /**\n         * build a unique id for the term checkbox\n         *\n         * @param {Object} context - the ko context\n         * @param {Number} agreementId\n         */\n        getCheckboxId: function (context, agreementId) {\n            var paymentMethodName = '',\n                paymentMethodRenderer = context.$parents[1];\n\n            // corresponding payment method fetched from parent context\n            if (paymentMethodRenderer) {\n                // item looks like this: {title: \"Check / Money order\", method: \"checkmo\"}\n                paymentMethodName = paymentMethodRenderer.item ?\n                  paymentMethodRenderer.item.method : '';\n            }\n\n            return 'agreement_' + paymentMethodName + '_' + agreementId;\n        },\n\n        /**\n         * Init modal window for rendered element\n         *\n         * @param {Object} element\n         */\n        initModal: function (element) {\n            agreementsModal.createModal(element);\n        }\n    });\n});\n","Magento_CheckoutAgreements/js/view/agreement-validation.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Checkout/js/model/payment/additional-validators',\n    'Magento_CheckoutAgreements/js/model/agreement-validator'\n], function (Component, additionalValidators, agreementValidator) {\n    'use strict';\n\n    additionalValidators.registerValidator(agreementValidator);\n\n    return Component.extend({});\n});\n","Magento_Search/js/form-mini.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore',\n    'mage/template',\n    'matchMedia',\n    'jquery-ui-modules/widget',\n    'jquery-ui-modules/core',\n    'mage/translate'\n], function ($, _, mageTemplate, mediaCheck) {\n    'use strict';\n\n    /**\n     * Check whether the incoming string is not empty or if doesn't consist of spaces.\n     *\n     * @param {String} value - Value to check.\n     * @returns {Boolean}\n     */\n    function isEmpty(value) {\n        return value.length === 0 || value == null || /^\\s+$/.test(value);\n    }\n\n    $.widget('mage.quickSearch', {\n        options: {\n            autocomplete: 'off',\n            minSearchLength: 3,\n            responseFieldElements: 'ul li',\n            selectClass: 'selected',\n            template:\n                '<li class=\"<%- data.row_class %>\" id=\"qs-option-<%- data.index %>\" role=\"option\">' +\n                '<span class=\"qs-option-name\">' +\n                ' <%- data.title %>' +\n                '</span>' +\n                '<span aria-hidden=\"true\" class=\"amount\">' +\n                '<%- data.num_results %>' +\n                '</span>' +\n                '</li>',\n            submitBtn: 'button[type=\"submit\"]',\n            searchLabel: '[data-role=minisearch-label]',\n            isExpandable: null,\n            suggestionDelay: 300\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this.responseList = {\n                indexList: null,\n                selected: null\n            };\n            this.autoComplete = $(this.options.destinationSelector);\n            this.searchForm = $(this.options.formSelector);\n            this.submitBtn = this.searchForm.find(this.options.submitBtn)[0];\n            this.searchLabel = this.searchForm.find(this.options.searchLabel);\n            this.isExpandable = this.options.isExpandable;\n\n            _.bindAll(this, '_onKeyDown', '_onPropertyChange', '_onSubmit');\n\n            this.submitBtn.disabled = true;\n\n            this.element.attr('autocomplete', this.options.autocomplete);\n\n            mediaCheck({\n                media: '(max-width: 768px)',\n                entry: function () {\n                    this.isExpandable = true;\n                }.bind(this),\n                exit: function () {\n                    this.isExpandable = true;\n                }.bind(this)\n            });\n\n            this.searchLabel.on('click', function (e) {\n                // allow input to lose its' focus when clicking on label\n                if (this.isExpandable && this.isActive()) {\n                    e.preventDefault();\n                }\n            }.bind(this));\n\n            this.element.on('blur', $.proxy(function () {\n                if (!this.searchLabel.hasClass('active')) {\n                    return;\n                }\n\n                setTimeout($.proxy(function () {\n                    if (this.autoComplete.is(':hidden')) {\n                        this.setActiveState(false);\n                    } else {\n                        this.element.trigger('focus');\n                    }\n                    this.autoComplete.hide();\n                    this._updateAriaHasPopup(false);\n                }, this), 250);\n            }, this));\n\n            if (this.element.get(0) === document.activeElement) {\n                this.setActiveState(true);\n            }\n\n            this.element.on('focus', this.setActiveState.bind(this, true));\n            this.element.on('keydown', this._onKeyDown);\n            // Prevent spamming the server with requests by waiting till the user has stopped typing for period of time\n            this.element.on('input propertychange', _.debounce(this._onPropertyChange, this.options.suggestionDelay));\n\n            this.searchForm.on('submit', $.proxy(function (e) {\n                this._onSubmit(e);\n                this._updateAriaHasPopup(false);\n            }, this));\n        },\n\n        /**\n         * Checks if search field is active.\n         *\n         * @returns {Boolean}\n         */\n        isActive: function () {\n            return this.searchLabel.hasClass('active');\n        },\n\n        /**\n         * Sets state of the search field to provided value.\n         *\n         * @param {Boolean} isActive\n         */\n        setActiveState: function (isActive) {\n            var searchValue;\n\n            this.searchForm.toggleClass('active', isActive);\n            this.searchLabel.toggleClass('active', isActive);\n\n            if (this.isExpandable) {\n                this.element.attr('aria-expanded', isActive);\n                searchValue = this.element.val();\n                this.element.val('');\n                this.element.val(searchValue);\n            }\n        },\n\n        /**\n         * @private\n         * @return {Element} The first element in the suggestion list.\n         */\n        _getFirstVisibleElement: function () {\n            return this.responseList.indexList ? this.responseList.indexList.first() : false;\n        },\n\n        /**\n         * @private\n         * @return {Element} The last element in the suggestion list.\n         */\n        _getLastElement: function () {\n            return this.responseList.indexList ? this.responseList.indexList.last() : false;\n        },\n\n        /**\n         * @private\n         * @param {Boolean} show - Set attribute aria-haspopup to \"true/false\" for element.\n         */\n        _updateAriaHasPopup: function (show) {\n            if (show) {\n                this.element.attr('aria-haspopup', 'true');\n            } else {\n                this.element.attr('aria-haspopup', 'false');\n            }\n        },\n\n        /**\n         * Clears the item selected from the suggestion list and resets the suggestion list.\n         * @private\n         * @param {Boolean} all - Controls whether to clear the suggestion list.\n         */\n        _resetResponseList: function (all) {\n            this.responseList.selected = null;\n\n            if (all === true) {\n                this.responseList.indexList = null;\n            }\n        },\n\n        /**\n         * Executes when the search box is submitted. Sets the search input field to the\n         * value of the selected item.\n         * @private\n         * @param {Event} e - The submit event\n         */\n        _onSubmit: function (e) {\n            var value = this.element.val();\n\n            if (isEmpty(value)) {\n                e.preventDefault();\n            }\n\n            if (this.responseList.selected) {\n                this.element.val(this.responseList.selected.find('.qs-option-name').text());\n            }\n        },\n\n        /**\n         * Executes when keys are pressed in the search input field. Performs specific actions\n         * depending on which keys are pressed.\n         * @private\n         * @param {Event} e - The key down event\n         * @return {Boolean} Default return type for any unhandled keys\n         */\n        _onKeyDown: function (e) {\n            var keyCode = e.keyCode || e.which;\n\n            switch (keyCode) {\n                case $.ui.keyCode.HOME:\n                    if (this._getFirstVisibleElement()) {\n                        this._getFirstVisibleElement().addClass(this.options.selectClass);\n                        this.responseList.selected = this._getFirstVisibleElement();\n                    }\n                    break;\n\n                case $.ui.keyCode.END:\n                    if (this._getLastElement()) {\n                        this._getLastElement().addClass(this.options.selectClass);\n                        this.responseList.selected = this._getLastElement();\n                    }\n                    break;\n\n                case $.ui.keyCode.ESCAPE:\n                    this._resetResponseList(true);\n                    this.autoComplete.hide();\n                    break;\n\n                case $.ui.keyCode.ENTER:\n                    if (this.element.val().length >= parseInt(this.options.minSearchLength, 10)) {\n                        this.searchForm.trigger('submit');\n                        e.preventDefault();\n                    }\n                    break;\n\n                case $.ui.keyCode.DOWN:\n                    if (this.responseList.indexList) {\n                        if (!this.responseList.selected) {  //eslint-disable-line max-depth\n                            this._getFirstVisibleElement().addClass(this.options.selectClass);\n                            this.responseList.selected = this._getFirstVisibleElement();\n                        } else if (!this._getLastElement().hasClass(this.options.selectClass)) {\n                            this.responseList.selected = this.responseList.selected\n                                .removeClass(this.options.selectClass).next().addClass(this.options.selectClass);\n                        } else {\n                            this.responseList.selected.removeClass(this.options.selectClass);\n                            this._getFirstVisibleElement().addClass(this.options.selectClass);\n                            this.responseList.selected = this._getFirstVisibleElement();\n                        }\n                        this.element.val(this.responseList.selected.find('.qs-option-name').text());\n                        this.element.attr('aria-activedescendant', this.responseList.selected.attr('id'));\n                        this._updateAriaHasPopup(true);\n                        this.autoComplete.show();\n                    }\n                    break;\n\n                case $.ui.keyCode.UP:\n                    if (this.responseList.indexList !== null) {\n                        if (!this._getFirstVisibleElement().hasClass(this.options.selectClass)) {\n                            this.responseList.selected = this.responseList.selected\n                                .removeClass(this.options.selectClass).prev().addClass(this.options.selectClass);\n\n                        } else {\n                            this.responseList.selected.removeClass(this.options.selectClass);\n                            this._getLastElement().addClass(this.options.selectClass);\n                            this.responseList.selected = this._getLastElement();\n                        }\n                        this.element.val(this.responseList.selected.find('.qs-option-name').text());\n                        this.element.attr('aria-activedescendant', this.responseList.selected.attr('id'));\n                        this._updateAriaHasPopup(true);\n                        this.autoComplete.show();\n                    }\n                    break;\n                default:\n                    return true;\n            }\n        },\n\n        /**\n         * Executes when the value of the search input field changes. Executes a GET request\n         * to populate a suggestion list based on entered text. Handles click (select), hover,\n         * and mouseout events on the populated suggestion list dropdown.\n         * @private\n         */\n        _onPropertyChange: function () {\n            var searchField = this.element,\n                clonePosition = {\n                    position: 'absolute',\n                    // Removed to fix display issues\n                    // left: searchField.offset().left,\n                    // top: searchField.offset().top + searchField.outerHeight(),\n                    width: searchField.outerWidth()\n                },\n                source = this.options.template,\n                template = mageTemplate(source),\n                dropdown = $('<ul role=\"listbox\"></ul>'),\n                value = this.element.val();\n\n            this.submitBtn.disabled = true;\n\n            if (value.length >= parseInt(this.options.minSearchLength, 10)) {\n                this.submitBtn.disabled = false;\n\n                if (this.options.url !== '') { //eslint-disable-line eqeqeq\n                    $.getJSON(this.options.url, {\n                        q: value\n                    }, $.proxy(function (data) {\n                        if (data.length) {\n                            $.each(data, function (index, element) {\n                                var html;\n\n                                element.index = index;\n                                html = template({\n                                    data: element\n                                });\n                                dropdown.append(html);\n                            });\n\n                            this._resetResponseList(true);\n\n                            this.responseList.indexList = this.autoComplete.html(dropdown)\n                                .css(clonePosition)\n                                .show()\n                                .find(this.options.responseFieldElements + ':visible');\n\n                            this.element.removeAttr('aria-activedescendant');\n\n                            if (this.responseList.indexList.length) {\n                                this._updateAriaHasPopup(true);\n                            } else {\n                                this._updateAriaHasPopup(false);\n                            }\n\n                            this.responseList.indexList\n                                .on('click', function (e) {\n                                    this.responseList.selected = $(e.currentTarget);\n                                    this.searchForm.trigger('submit');\n                                }.bind(this))\n                                .on('mouseenter mouseleave', function (e) {\n                                    this.responseList.indexList.removeClass(this.options.selectClass);\n                                    $(e.target).addClass(this.options.selectClass);\n                                    this.responseList.selected = $(e.target);\n                                    this.element.attr('aria-activedescendant', $(e.target).attr('id'));\n                                }.bind(this))\n                                .on('mouseout', function (e) {\n                                    if (!this._getLastElement() &&\n                                        this._getLastElement().hasClass(this.options.selectClass)) {\n                                        $(e.target).removeClass(this.options.selectClass);\n                                        this._resetResponseList(false);\n                                    }\n                                }.bind(this));\n                        } else {\n                            this._resetResponseList(true);\n                            this.autoComplete.hide();\n                            this._updateAriaHasPopup(false);\n                            this.element.removeAttr('aria-activedescendant');\n                        }\n                    }, this));\n                }\n            } else {\n                this._resetResponseList(true);\n                this.autoComplete.hide();\n                this._updateAriaHasPopup(false);\n                this.element.removeAttr('aria-activedescendant');\n            }\n        }\n    });\n\n    return $.mage.quickSearch;\n});\n","Magefan_Blog/js/magefan-comments.js":"/**\n * Copyright \u00a9 Magefan (support@magefan.com). All rights reserved.\n * Please visit Magefan.com for license details (https://magefan.com/end-user-license-agreement).\n *\n * Glory to Ukraine! Glory to the heroes!\n */\n\ndefine(\n    [\n    'jquery',\n    'uiComponent',\n    'mage/validation'],\n    function ($, Component, validation) {\n    'use strict';\n\n\n    return Component.extend({\n        initialize: function ($options) {\n\n            var msgLifetime = 4000;\n            var $hd = $('#post-comments');\n\n            var getMessageHtml = function (msg, type) {\n                var h = '<div class=\"message-' + type + ' ' + type + ' message\">'\n                    + '<div>' + msg + '</div>'\n                +'</div>';\n                return $(h);\n            };\n\n            var processError = function ($form, msg) {\n                $form.find('[type=submit]').removeAttr('disabled');\n                var $h = getMessageHtml(msg, 'error');\n                $h.insertBefore($form);\n                setTimeout(function () {\n                    $h.remove();\n                }, msgLifetime);\n            };\n\n            var processSuccess = function ($form, msg) {\n                $form.find('[type=submit]').removeAttr('disabled');\n                var $h = getMessageHtml(msg, 'success');\n                $h.insertBefore($form);\n                $form.hide();\n                setTimeout(function () {\n                    $h.remove();\n                }, msgLifetime);\n            };\n\n            $hd.find('form').submit(function () {\n                var $form = $(this);\n                if ($form.validation() && $form.validation('isValid')) {\n                    $form.find('[type=submit]').attr('disabled', 'disabled');\n                    $.ajax({\n                        'method': 'post',\n                        'url': $form.attr('action'),\n                        'dataType': 'json',\n                        'data': $form.serialize(),\n                        'success': function (res) {\n                            if (res.success) {\n                                processSuccess($form, res.message);\n                            } else {\n                                processError($form, res.message);\n                            }\n                        },\n                        'error': function () {\n                            processError($form, 'Unexpected error. Please try again later or contact us.')\n                        }\n                    })\n                }\n                return false;\n            });\n\n            $hd.find('.more-comments-action').click(function () {\n                var id = $(this).data('comment');\n                $hd.find('.c-comment-parent-'+id).fadeIn();\n                $(this).hide();\n                return false;\n            });\n\n            $hd.find('form textarea').click(function () {\n                $(this).parents('.no-active').removeClass('no-active');\n            });\n\n            var $rf = $('#c-replyform-comment');\n            $hd.find('.reply-action').click(function () {\n                var id = $(this).data('comment');\n                $rf.hide();\n                $rf.appendTo('.c-post-'+id);\n                $rf.find('.refresh-value').val('').html('');\n                $rf.find('[name=parent_id]').val(id);\n                $rf.find('form').show();\n                $rf.fadeIn();\n                return false;\n            });\n\n            $hd.find('.reply-cancel-action').click(function () {\n                $rf.hide();\n            });\n\n            return this;\n        },\n\n    });\n    }\n);","Magefan_Blog/js/lazyload.js":"/**\n * Copyright \u00a9 Magefan (support@magefan.com). All rights reserved.\n * Please visit Magefan.com for license details (https://magefan.com/end-user-license-agreement).\n *\n * Glory to Ukraine! Glory to the heroes!\n */\n\n/**\n * Posts autload\n */\n define([\n    'domReady!',\n    'jquery'\n], function (domReady, $) {\n    'use strict';\n\n    var Lazyload = function (options) {\n\n        var that = this;\n\n        /**\n         * Lazyload default options.\n         * @type {Object}\n         */\n        that.defaults = {\n            expires: null,\n            path: '/',\n            domain: null,\n            secure: false,\n            lifetime: null\n        };\n\n        /**\n         * Init options\n         * @type {Object}\n         */\n        that.opt = $.extend(that.default, options);\n\n        /**\n         * Load new content\n         */\n        function startLoading()\n        {\n            if (that.opt.current_page < that.opt.last_page && !that.loading) {\n                that.loading = true;\n                $('.mfblog-show-onload').show();\n                $('.mfblog-hide-onload').hide();\n\n                $.ajax({\n                    \"url\":that.opt.page_url[that.opt.current_page+1],\n                    \"cache\":true\n                }).success(function (data) {\n                    var $html = $(data);\n                    var ws = that.opt.list_wrapper;\n                    var $nw = $html.find(ws);\n                    if ($nw.length) {\n                        $(ws).append($nw.html());\n                        that.opt.current_page++;\n                    }\n\n                    endLoading();\n\n                }).fail(function (xhr, ajaxOptions, thrownError) {\n                    console.log(thrownError);\n                    endLoading();\n                });\n            }\n        }\n\n        /**\n         * On loading end\n         */\n        function endLoading()\n        {\n            that.loading = false;\n            $('.mfblog-show-onload').hide();\n            if (that.opt.current_page < that.opt.last_page) {\n                $('.mfblog-hide-onload').show();\n            }\n        }\n\n        /* Is not loading now */\n        endLoading();\n\n        /* If auto trigger enabled */\n        if (that.opt.auto_trigger) {\n            var $w = $(window);\n            $w.scroll(function () {\n                if ($w.scrollTop() + $w.height() >= $(that.opt.trigger_element).offset().top - that.opt.padding) {\n                    startLoading();\n                }\n            });\n        }\n\n        /* On trigger element click */\n        if (that.opt.trigger_element) {\n            $(that.opt.trigger_element).click(function () {\n                startLoading();\n            });\n        }\n    };\n\n    return function (options) {\n        new Lazyload(options)\n    };\n\n});\n","Magefan_Blog/js/jquery.fancybox.min.js":"// ==================================================\n// fancyBox v3.2.8\n//\n// Licensed GPLv3 for open source use\n// or fancyBox Commercial License for commercial use\n//\n// http://fancyapps.com/fancybox/\n// Copyright 2017 fancyApps\n//\n// ==================================================\n!function(t,e,n,o){\"use strict\";function a(t){var e=n(t.currentTarget),o=t.data?t.data.options:{},a=e.attr(\"data-fancybox\")||\"\",i=0,s=[];t.isDefaultPrevented()||(t.preventDefault(),a?(s=o.selector?n(o.selector):t.data?t.data.items:[],s=s.length?s.filter('[data-fancybox=\"'+a+'\"]'):n('[data-fancybox=\"'+a+'\"]'),i=s.index(e),i<0&&(i=0)):s=[e],n.fancybox.open(s,o,i))}if(n){if(n.fn.fancybox)return void(\"console\"in t&&console.log(\"fancyBox already initialized\"));var i={loop:!1,margin:[44,0],gutter:50,keyboard:!0,arrows:!0,infobar:!0,toolbar:!0,buttons:[\"slideShow\",\"fullScreen\",\"thumbs\",\"share\",\"close\"],idleTime:3,smallBtn:\"auto\",protect:!1,modal:!1,image:{preload:\"auto\"},ajax:{settings:{data:{fancybox:!0}}},iframe:{tpl:'<iframe id=\"fancybox-frame{rnd}\" name=\"fancybox-frame{rnd}\" class=\"fancybox-iframe\" frameborder=\"0\" vspace=\"0\" hspace=\"0\" webkitAllowFullScreen mozallowfullscreen allowFullScreen allowtransparency=\"true\" src=\"\"></iframe>',preload:!0,css:{},attr:{scrolling:\"auto\"}},defaultType:\"image\",animationEffect:\"zoom\",animationDuration:500,zoomOpacity:\"auto\",transitionEffect:\"fade\",transitionDuration:366,slideClass:\"\",baseClass:\"\",baseTpl:'<div class=\"fancybox-container\" role=\"dialog\" tabindex=\"-1\"><div class=\"fancybox-bg\"></div><div class=\"fancybox-inner\"><div class=\"fancybox-infobar\"><span data-fancybox-index></span>&nbsp;/&nbsp;<span data-fancybox-count></span></div><div class=\"fancybox-toolbar\">{{buttons}}</div><div class=\"fancybox-navigation\">{{arrows}}</div><div class=\"fancybox-stage\"></div><div class=\"fancybox-caption-wrap\"><div class=\"fancybox-caption\"></div></div></div></div>',spinnerTpl:'<div class=\"fancybox-loading\"></div>',errorTpl:'<div class=\"fancybox-error\"><p>{{ERROR}}<p></div>',btnTpl:{download:'<a download data-fancybox-download class=\"fancybox-button fancybox-button--download\" title=\"{{DOWNLOAD}}\"><svg viewBox=\"0 0 40 40\"><path d=\"M20,23 L20,8 L20,23 L13,16 L20,23 L27,16 L20,23 M26,28 L13,28 L27,28 L14,28\" /></svg></a>',zoom:'<button data-fancybox-zoom class=\"fancybox-button fancybox-button--zoom\" title=\"{{ZOOM}}\"><svg viewBox=\"0 0 40 40\"><path d=\"M 18,17 m-8,0 a 8,8 0 1,0 16,0 a 8,8 0 1,0 -16,0 M25,23 L31,29 L25,23\" /></svg></button>',close:'<button data-fancybox-close class=\"fancybox-button fancybox-button--close\" title=\"{{CLOSE}}\"><svg viewBox=\"0 0 40 40\"><path d=\"M10,10 L30,30 M30,10 L10,30\" /></svg></button>',smallBtn:'<button data-fancybox-close class=\"fancybox-close-small\" title=\"{{CLOSE}}\"></button>',arrowLeft:'<button data-fancybox-prev class=\"fancybox-button fancybox-button--arrow_left\" title=\"{{PREV}}\"><svg viewBox=\"0 0 40 40\"><path d=\"M10,20 L30,20 L10,20 L18,28 L10,20 L18,12 L10,20\"></path></svg></button>',arrowRight:'<button data-fancybox-next class=\"fancybox-button fancybox-button--arrow_right\" title=\"{{NEXT}}\"><svg viewBox=\"0 0 40 40\"><path d=\"M30,20 L10,20 L30,20 L22,28 L30,20 L22,12 L30,20\"></path></svg></button>'},parentEl:\"body\",autoFocus:!1,backFocus:!0,trapFocus:!0,fullScreen:{autoStart:!1},touch:{vertical:!0,momentum:!0},hash:null,media:{},slideShow:{autoStart:!1,speed:4e3},thumbs:{autoStart:!1,hideOnClose:!0,parentEl:\".fancybox-container\",axis:\"y\"},wheel:\"auto\",onInit:n.noop,beforeLoad:n.noop,afterLoad:n.noop,beforeShow:n.noop,afterShow:n.noop,beforeClose:n.noop,afterClose:n.noop,onActivate:n.noop,onDeactivate:n.noop,clickContent:function(t,e){return\"image\"===t.type&&\"zoom\"},clickSlide:\"close\",clickOutside:\"close\",dblclickContent:!1,dblclickSlide:!1,dblclickOutside:!1,mobile:{idleTime:!1,margin:0,clickContent:function(t,e){return\"image\"===t.type&&\"toggleControls\"},clickSlide:function(t,e){return\"image\"===t.type?\"toggleControls\":\"close\"},dblclickContent:function(t,e){return\"image\"===t.type&&\"zoom\"},dblclickSlide:function(t,e){return\"image\"===t.type&&\"zoom\"}},lang:\"en\",i18n:{en:{CLOSE:\"Close\",NEXT:\"Next\",PREV:\"Previous\",ERROR:\"The requested content cannot be loaded. <br/> Please try again later.\",PLAY_START:\"Start slideshow\",PLAY_STOP:\"Pause slideshow\",FULL_SCREEN:\"Full screen\",THUMBS:\"Thumbnails\",DOWNLOAD:\"Download\",SHARE:\"Share\",ZOOM:\"Zoom\"},de:{CLOSE:\"Schliessen\",NEXT:\"Weiter\",PREV:\"Zur\u00fcck\",ERROR:\"Die angeforderten Daten konnten nicht geladen werden. <br/> Bitte versuchen Sie es sp\u00e4ter nochmal.\",PLAY_START:\"Diaschau starten\",PLAY_STOP:\"Diaschau beenden\",FULL_SCREEN:\"Vollbild\",THUMBS:\"Vorschaubilder\",DOWNLOAD:\"Herunterladen\",SHARE:\"Teilen\",ZOOM:\"Ma\u00dfstab\"}}},s=n(t),r=n(e),c=0,l=function(t){return t&&t.hasOwnProperty&&t instanceof n},u=function(){return t.requestAnimationFrame||t.webkitRequestAnimationFrame||t.mozRequestAnimationFrame||t.oRequestAnimationFrame||function(e){return t.setTimeout(e,1e3/60)}}(),d=function(){var t,n=e.createElement(\"fakeelement\"),a={transition:\"transitionend\",OTransition:\"oTransitionEnd\",MozTransition:\"transitionend\",WebkitTransition:\"webkitTransitionEnd\"};for(t in a)if(n.style[t]!==o)return a[t];return\"transitionend\"}(),f=function(t){return t&&t.length&&t[0].offsetHeight},p=function(t,o,a){var i=this;i.opts=n.extend(!0,{index:a},n.fancybox.defaults,o||{}),n.fancybox.isMobile&&(i.opts=n.extend(!0,{},i.opts,i.opts.mobile)),o&&n.isArray(o.buttons)&&(i.opts.buttons=o.buttons),i.id=i.opts.id||++c,i.group=[],i.currIndex=parseInt(i.opts.index,10)||0,i.prevIndex=null,i.prevPos=null,i.currPos=0,i.firstRun=null,i.createGroup(t),i.group.length&&(i.$lastFocus=n(e.activeElement).blur(),i.slides={},i.init())};n.extend(p.prototype,{init:function(){var a,i,s,c=this,l=c.group[c.currIndex],u=l.opts,d=n.fancybox.scrollbarWidth;c.scrollTop=r.scrollTop(),c.scrollLeft=r.scrollLeft(),n.fancybox.getInstance()||(n(\"body\").addClass(\"fancybox-active\"),/iPad|iPhone|iPod/.test(navigator.userAgent)&&!t.MSStream?\"image\"!==l.type&&n(\"body\").css(\"top\",n(\"body\").scrollTop()*-1).addClass(\"fancybox-iosfix\"):!n.fancybox.isMobile&&e.body.scrollHeight>t.innerHeight&&(d===o&&(a=n('<div style=\"width:50px;height:50px;overflow:scroll;\" />').appendTo(\"body\"),d=n.fancybox.scrollbarWidth=a[0].offsetWidth-a[0].clientWidth,a.remove()),n(\"head\").append('<style id=\"fancybox-style-noscroll\" type=\"text/css\">.compensate-for-scrollbar { margin-right: '+d+\"px; }</style>\"),n(\"body\").addClass(\"compensate-for-scrollbar\"))),s=\"\",n.each(u.buttons,function(t,e){s+=u.btnTpl[e]||\"\"}),i=n(c.translate(c,u.baseTpl.replace(\"{{buttons}}\",s).replace(\"{{arrows}}\",u.btnTpl.arrowLeft+u.btnTpl.arrowRight))).attr(\"id\",\"fancybox-container-\"+c.id).addClass(\"fancybox-is-hidden\").addClass(u.baseClass).data(\"FancyBox\",c).appendTo(u.parentEl),c.$refs={container:i},[\"bg\",\"inner\",\"infobar\",\"toolbar\",\"stage\",\"caption\",\"navigation\"].forEach(function(t){c.$refs[t]=i.find(\".fancybox-\"+t)}),c.trigger(\"onInit\"),c.activate(),c.jumpTo(c.currIndex)},translate:function(t,e){var n=t.opts.i18n[t.opts.lang];return e.replace(/\\{\\{(\\w+)\\}\\}/g,function(t,e){var a=n[e];return a===o?t:a})},createGroup:function(t){var e=this,a=n.makeArray(t);n.each(a,function(t,a){var i,s,r,c,l={},u={};n.isPlainObject(a)?(l=a,u=a.opts||a):\"object\"===n.type(a)&&n(a).length?(i=n(a),u=i.data(),u=n.extend({},u,u.options||{}),u.$orig=i,l.src=u.src||i.attr(\"href\"),l.type||l.src||(l.type=\"inline\",l.src=a)):l={type:\"html\",src:a+\"\"},l.opts=n.extend(!0,{},e.opts,u),n.isArray(u.buttons)&&(l.opts.buttons=u.buttons),s=l.type||l.opts.type,r=l.src||\"\",!s&&r&&(r.match(/(^data:image\\/[a-z0-9+\\/=]*,)|(\\.(jp(e|g|eg)|gif|png|bmp|webp|svg|ico)((\\?|#).*)?$)/i)?s=\"image\":r.match(/\\.(pdf)((\\?|#).*)?$/i)?s=\"pdf\":\"#\"===r.charAt(0)&&(s=\"inline\")),s?l.type=s:e.trigger(\"objectNeedsType\",l),l.index=e.group.length,l.opts.$orig&&!l.opts.$orig.length&&delete l.opts.$orig,!l.opts.$thumb&&l.opts.$orig&&(l.opts.$thumb=l.opts.$orig.find(\"img:first\")),l.opts.$thumb&&!l.opts.$thumb.length&&delete l.opts.$thumb,\"function\"===n.type(l.opts.caption)&&(l.opts.caption=l.opts.caption.apply(a,[e,l])),\"function\"===n.type(e.opts.caption)&&(l.opts.caption=e.opts.caption.apply(a,[e,l])),l.opts.caption instanceof n||(l.opts.caption=l.opts.caption===o?\"\":l.opts.caption+\"\"),\"ajax\"===s&&(c=r.split(/\\s+/,2),c.length>1&&(l.src=c.shift(),l.opts.filter=c.shift())),\"auto\"==l.opts.smallBtn&&(n.inArray(s,[\"html\",\"inline\",\"ajax\"])>-1?(l.opts.toolbar=!1,l.opts.smallBtn=!0):l.opts.smallBtn=!1),\"pdf\"===s&&(l.type=\"iframe\",l.opts.iframe.preload=!1),l.opts.modal&&(l.opts=n.extend(!0,l.opts,{infobar:0,toolbar:0,smallBtn:0,keyboard:0,slideShow:0,fullScreen:0,thumbs:0,touch:0,clickContent:!1,clickSlide:!1,clickOutside:!1,dblclickContent:!1,dblclickSlide:!1,dblclickOutside:!1})),e.group.push(l)})},addEvents:function(){var o=this;o.removeEvents(),o.$refs.container.on(\"click.fb-close\",\"[data-fancybox-close]\",function(t){t.stopPropagation(),t.preventDefault(),o.close(t)}).on(\"click.fb-prev touchend.fb-prev\",\"[data-fancybox-prev]\",function(t){t.stopPropagation(),t.preventDefault(),o.previous()}).on(\"click.fb-next touchend.fb-next\",\"[data-fancybox-next]\",function(t){t.stopPropagation(),t.preventDefault(),o.next()}).on(\"click.fb\",\"[data-fancybox-zoom]\",function(t){o[o.isScaledDown()?\"scaleToActual\":\"scaleToFit\"]()}),s.on(\"orientationchange.fb resize.fb\",function(t){t&&t.originalEvent&&\"resize\"===t.originalEvent.type?u(function(){o.update()}):(o.$refs.stage.hide(),setTimeout(function(){o.$refs.stage.show(),o.update()},600))}),r.on(\"focusin.fb\",function(t){var a=n.fancybox?n.fancybox.getInstance():null;a.isClosing||!a.current||!a.current.opts.trapFocus||n(t.target).hasClass(\"fancybox-container\")||n(t.target).is(e)||a&&\"fixed\"!==n(t.target).css(\"position\")&&!a.$refs.container.has(t.target).length&&(t.stopPropagation(),a.focus(),s.scrollTop(o.scrollTop).scrollLeft(o.scrollLeft))}),r.on(\"keydown.fb\",function(t){var e=o.current,a=t.keyCode||t.which;if(e&&e.opts.keyboard&&!n(t.target).is(\"input\")&&!n(t.target).is(\"textarea\"))return 8===a||27===a?(t.preventDefault(),void o.close(t)):37===a||38===a?(t.preventDefault(),void o.previous()):39===a||40===a?(t.preventDefault(),void o.next()):void o.trigger(\"afterKeydown\",t,a)}),o.group[o.currIndex].opts.idleTime&&(o.idleSecondsCounter=0,r.on(\"mousemove.fb-idle mouseleave.fb-idle mousedown.fb-idle touchstart.fb-idle touchmove.fb-idle scroll.fb-idle keydown.fb-idle\",function(t){o.idleSecondsCounter=0,o.isIdle&&o.showControls(),o.isIdle=!1}),o.idleInterval=t.setInterval(function(){o.idleSecondsCounter++,o.idleSecondsCounter>=o.group[o.currIndex].opts.idleTime&&!o.isDragging&&(o.isIdle=!0,o.idleSecondsCounter=0,o.hideControls())},1e3))},removeEvents:function(){var e=this;s.off(\"orientationchange.fb resize.fb\"),r.off(\"focusin.fb keydown.fb .fb-idle\"),this.$refs.container.off(\".fb-close .fb-prev .fb-next\"),e.idleInterval&&(t.clearInterval(e.idleInterval),e.idleInterval=null)},previous:function(t){return this.jumpTo(this.currPos-1,t)},next:function(t){return this.jumpTo(this.currPos+1,t)},jumpTo:function(t,e,a){var i,s,r,c,l,u,d,p=this,h=p.group.length;if(!(p.isDragging||p.isClosing||p.isAnimating&&p.firstRun)){if(t=parseInt(t,10),s=p.current?p.current.opts.loop:p.opts.loop,!s&&(t<0||t>=h))return!1;if(i=p.firstRun=null===p.firstRun,!(h<2&&!i&&p.isDragging)){if(c=p.current,p.prevIndex=p.currIndex,p.prevPos=p.currPos,r=p.createSlide(t),h>1&&((s||r.index>0)&&p.createSlide(t-1),(s||r.index<h-1)&&p.createSlide(t+1)),p.current=r,p.currIndex=r.index,p.currPos=r.pos,p.trigger(\"beforeShow\",i),p.updateControls(),u=n.fancybox.getTranslate(r.$slide),r.isMoved=(0!==u.left||0!==u.top)&&!r.$slide.hasClass(\"fancybox-animated\"),r.forcedDuration=o,n.isNumeric(e)?r.forcedDuration=e:e=r.opts[i?\"animationDuration\":\"transitionDuration\"],e=parseInt(e,10),i)return r.opts.animationEffect&&e&&p.$refs.container.css(\"transition-duration\",e+\"ms\"),p.$refs.container.removeClass(\"fancybox-is-hidden\"),f(p.$refs.container),p.$refs.container.addClass(\"fancybox-is-open\"),r.$slide.addClass(\"fancybox-slide--current\"),p.loadSlide(r),void p.preload();n.each(p.slides,function(t,e){n.fancybox.stop(e.$slide)}),r.$slide.removeClass(\"fancybox-slide--next fancybox-slide--previous\").addClass(\"fancybox-slide--current\"),r.isMoved?(l=Math.round(r.$slide.width()),n.each(p.slides,function(t,o){var a=o.pos-r.pos;n.fancybox.animate(o.$slide,{top:0,left:a*l+a*o.opts.gutter},e,function(){o.$slide.removeAttr(\"style\").removeClass(\"fancybox-slide--next fancybox-slide--previous\"),o.pos===p.currPos&&(r.isMoved=!1,p.complete())})})):p.$refs.stage.children().removeAttr(\"style\"),r.isLoaded?p.revealContent(r):p.loadSlide(r),p.preload(),c.pos!==r.pos&&(d=\"fancybox-slide--\"+(c.pos>r.pos?\"next\":\"previous\"),c.$slide.removeClass(\"fancybox-slide--complete fancybox-slide--current fancybox-slide--next fancybox-slide--previous\"),c.isComplete=!1,e&&(r.isMoved||r.opts.transitionEffect)&&(r.isMoved?c.$slide.addClass(d):(d=\"fancybox-animated \"+d+\" fancybox-fx-\"+r.opts.transitionEffect,n.fancybox.animate(c.$slide,d,e,function(){c.$slide.removeClass(d).removeAttr(\"style\")}))))}}},createSlide:function(t){var e,o,a=this;return o=t%a.group.length,o=o<0?a.group.length+o:o,!a.slides[t]&&a.group[o]&&(e=n('<div class=\"fancybox-slide\"></div>').appendTo(a.$refs.stage),a.slides[t]=n.extend(!0,{},a.group[o],{pos:t,$slide:e,isLoaded:!1}),a.updateSlide(a.slides[t])),a.slides[t]},scaleToActual:function(t,e,a){var i,s,r,c,l,u=this,d=u.current,f=d.$content,p=parseInt(d.$slide.width(),10),h=parseInt(d.$slide.height(),10),g=d.width,b=d.height;\"image\"!=d.type||d.hasError||!f||u.isAnimating||(n.fancybox.stop(f),u.isAnimating=!0,t=t===o?.5*p:t,e=e===o?.5*h:e,i=n.fancybox.getTranslate(f),c=g/i.width,l=b/i.height,s=.5*p-.5*g,r=.5*h-.5*b,g>p&&(s=i.left*c-(t*c-t),s>0&&(s=0),s<p-g&&(s=p-g)),b>h&&(r=i.top*l-(e*l-e),r>0&&(r=0),r<h-b&&(r=h-b)),u.updateCursor(g,b),n.fancybox.animate(f,{top:r,left:s,scaleX:c,scaleY:l},a||330,function(){u.isAnimating=!1}),u.SlideShow&&u.SlideShow.isActive&&u.SlideShow.stop())},scaleToFit:function(t){var e,o=this,a=o.current,i=a.$content;\"image\"!=a.type||a.hasError||!i||o.isAnimating||(n.fancybox.stop(i),o.isAnimating=!0,e=o.getFitPos(a),o.updateCursor(e.width,e.height),n.fancybox.animate(i,{top:e.top,left:e.left,scaleX:e.width/i.width(),scaleY:e.height/i.height()},t||330,function(){o.isAnimating=!1}))},getFitPos:function(t){var e,o,a,i,s,r=this,c=t.$content,l=t.width,u=t.height,d=t.opts.margin;return!(!c||!c.length||!l&&!u)&&(\"number\"===n.type(d)&&(d=[d,d]),2==d.length&&(d=[d[0],d[1],d[0],d[1]]),e=parseInt(r.$refs.stage.width(),10)-(d[1]+d[3]),o=parseInt(r.$refs.stage.height(),10)-(d[0]+d[2]),a=Math.min(1,e/l,o/u),i=Math.floor(a*l),s=Math.floor(a*u),{top:Math.floor(.5*(o-s))+d[0],left:Math.floor(.5*(e-i))+d[3],width:i,height:s})},update:function(){var t=this;n.each(t.slides,function(e,n){t.updateSlide(n)})},updateSlide:function(t){var e=this,o=t.$content;o&&(t.width||t.height)&&(e.isAnimating=!1,n.fancybox.stop(o),n.fancybox.setTranslate(o,e.getFitPos(t)),t.pos===e.currPos&&e.updateCursor()),t.$slide.trigger(\"refresh\"),e.trigger(\"onUpdate\",t)},updateCursor:function(t,e){var n,a=this,i=a.$refs.container.removeClass(\"fancybox-is-zoomable fancybox-can-zoomIn fancybox-can-drag fancybox-can-zoomOut\");a.current&&!a.isClosing&&(a.isZoomable()?(i.addClass(\"fancybox-is-zoomable\"),n=t!==o&&e!==o?t<a.current.width&&e<a.current.height:a.isScaledDown(),n?i.addClass(\"fancybox-can-zoomIn\"):a.current.opts.touch?i.addClass(\"fancybox-can-drag\"):i.addClass(\"fancybox-can-zoomOut\")):a.current.opts.touch&&i.addClass(\"fancybox-can-drag\"))},isZoomable:function(){var t,e=this,o=e.current;if(o&&!e.isClosing)return!!(\"image\"===o.type&&o.isLoaded&&!o.hasError&&(\"zoom\"===o.opts.clickContent||n.isFunction(o.opts.clickContent)&&\"zoom\"===o.opts.clickContent(o))&&(t=e.getFitPos(o),o.width>t.width||o.height>t.height))},isScaledDown:function(){var t=this,e=t.current,o=e.$content,a=!1;return o&&(a=n.fancybox.getTranslate(o),a=a.width<e.width||a.height<e.height),a},canPan:function(){var t=this,e=t.current,n=e.$content,o=!1;return n&&(o=t.getFitPos(e),o=Math.abs(n.width()-o.width)>1||Math.abs(n.height()-o.height)>1),o},loadSlide:function(t){var e,o,a,i=this;if(!t.isLoading&&!t.isLoaded){switch(t.isLoading=!0,i.trigger(\"beforeLoad\",t),e=t.type,o=t.$slide,o.off(\"refresh\").trigger(\"onReset\").addClass(\"fancybox-slide--\"+(e||\"unknown\")).addClass(t.opts.slideClass),e){case\"image\":i.setImage(t);break;case\"iframe\":i.setIframe(t);break;case\"html\":i.setContent(t,t.src||t.content);break;case\"inline\":n(t.src).length?i.setContent(t,n(t.src)):i.setError(t);break;case\"ajax\":i.showLoading(t),a=n.ajax(n.extend({},t.opts.ajax.settings,{url:t.src,success:function(e,n){\"success\"===n&&i.setContent(t,e)},error:function(e,n){e&&\"abort\"!==n&&i.setError(t)}})),o.one(\"onReset\",function(){a.abort()});break;default:i.setError(t)}return!0}},setImage:function(e){var o,a,i,s,r=this,c=e.opts.srcset||e.opts.image.srcset;if(c){i=t.devicePixelRatio||1,s=t.innerWidth*i,a=c.split(\",\").map(function(t){var e={};return t.trim().split(/\\s+/).forEach(function(t,n){var o=parseInt(t.substring(0,t.length-1),10);return 0===n?e.url=t:void(o&&(e.value=o,e.postfix=t[t.length-1]))}),e}),a.sort(function(t,e){return t.value-e.value});for(var l=0;l<a.length;l++){var u=a[l];if(\"w\"===u.postfix&&u.value>=s||\"x\"===u.postfix&&u.value>=i){o=u;break}}!o&&a.length&&(o=a[a.length-1]),o&&(e.src=o.url,e.width&&e.height&&\"w\"==o.postfix&&(e.height=e.width/e.height*o.value,e.width=o.value))}e.$content=n('<div class=\"fancybox-image-wrap\"></div>').addClass(\"fancybox-is-hidden\").appendTo(e.$slide),e.opts.preload!==!1&&e.opts.width&&e.opts.height&&(e.opts.thumb||e.opts.$thumb)?(e.width=e.opts.width,e.height=e.opts.height,e.$ghost=n(\"<img />\").one(\"error\",function(){n(this).remove(),e.$ghost=null,r.setBigImage(e)}).one(\"load\",function(){r.afterLoad(e),r.setBigImage(e)}).addClass(\"fancybox-image\").appendTo(e.$content).attr(\"src\",e.opts.thumb||e.opts.$thumb.attr(\"src\"))):r.setBigImage(e)},setBigImage:function(t){var e=this,o=n(\"<img />\");t.$image=o.one(\"error\",function(){e.setError(t)}).one(\"load\",function(){clearTimeout(t.timouts),t.timouts=null,e.isClosing||(t.width=this.naturalWidth,t.height=this.naturalHeight,t.opts.image.srcset&&o.attr(\"sizes\",\"100vw\").attr(\"srcset\",t.opts.image.srcset),e.hideLoading(t),t.$ghost?t.timouts=setTimeout(function(){t.timouts=null,t.$ghost.hide()},Math.min(300,Math.max(1e3,t.height/1600))):e.afterLoad(t))}).addClass(\"fancybox-image\").attr(\"src\",t.src).appendTo(t.$content),(o[0].complete||\"complete\"==o[0].readyState)&&o[0].naturalWidth&&o[0].naturalHeight?o.trigger(\"load\"):o[0].error?o.trigger(\"error\"):t.timouts=setTimeout(function(){o[0].complete||t.hasError||e.showLoading(t)},100)},setIframe:function(t){var e,a=this,i=t.opts.iframe,s=t.$slide;t.$content=n('<div class=\"fancybox-content'+(i.preload?\" fancybox-is-hidden\":\"\")+'\"></div>').css(i.css).appendTo(s),e=n(i.tpl.replace(/\\{rnd\\}/g,(new Date).getTime())).attr(i.attr).appendTo(t.$content),i.preload?(a.showLoading(t),e.on(\"load.fb error.fb\",function(e){this.isReady=1,t.$slide.trigger(\"refresh\"),a.afterLoad(t)}),s.on(\"refresh.fb\",function(){var n,a,s,r=t.$content,c=i.css.width,l=i.css.height;if(1===e[0].isReady){try{a=e.contents(),s=a.find(\"body\")}catch(t){}s&&s.length&&(c===o&&(n=e[0].contentWindow.document.documentElement.scrollWidth,c=Math.ceil(s.outerWidth(!0)+(r.width()-n)),c+=r.outerWidth()-r.innerWidth()),l===o&&(l=Math.ceil(s.outerHeight(!0)),l+=r.outerHeight()-r.innerHeight()),c&&r.width(c),l&&r.height(l)),r.removeClass(\"fancybox-is-hidden\")}})):this.afterLoad(t),e.attr(\"src\",t.src),t.opts.smallBtn===!0&&t.$content.prepend(a.translate(t,t.opts.btnTpl.smallBtn)),s.one(\"onReset\",function(){try{n(this).find(\"iframe\").hide().attr(\"src\",\"//about:blank\")}catch(t){}n(this).empty(),t.isLoaded=!1})},setContent:function(t,e){var o=this;o.isClosing||(o.hideLoading(t),t.$slide.empty(),l(e)&&e.parent().length?(e.parent(\".fancybox-slide--inline\").trigger(\"onReset\"),t.$placeholder=n(\"<div></div>\").hide().insertAfter(e),e.css(\"display\",\"inline-block\")):t.hasError||(\"string\"===n.type(e)&&(e=n(\"<div>\").append(n.trim(e)).contents(),3===e[0].nodeType&&(e=n(\"<div>\").html(e))),t.opts.filter&&(e=n(\"<div>\").html(e).find(t.opts.filter))),t.$slide.one(\"onReset\",function(){n(this).find(\"video,audio\").each(function(){this.pause()}),t.$placeholder&&(t.$placeholder.after(e.hide()).remove(),t.$placeholder=null),t.$smallBtn&&(t.$smallBtn.remove(),t.$smallBtn=null),t.hasError||(n(this).empty(),t.isLoaded=!1)}),t.$content=n(e).appendTo(t.$slide),this.afterLoad(t))},setError:function(t){t.hasError=!0,t.$slide.removeClass(\"fancybox-slide--\"+t.type),this.setContent(t,this.translate(t,t.opts.errorTpl))},showLoading:function(t){var e=this;t=t||e.current,t&&!t.$spinner&&(t.$spinner=n(e.opts.spinnerTpl).appendTo(t.$slide))},hideLoading:function(t){var e=this;t=t||e.current,t&&t.$spinner&&(t.$spinner.remove(),delete t.$spinner)},afterLoad:function(t){var e=this;e.isClosing||(t.isLoading=!1,t.isLoaded=!0,e.trigger(\"afterLoad\",t),e.hideLoading(t),t.opts.smallBtn&&!t.$smallBtn&&(t.$smallBtn=n(e.translate(t,t.opts.btnTpl.smallBtn)).appendTo(t.$content.filter(\"div,form\").first())),t.opts.protect&&t.$content&&!t.hasError&&(t.$content.on(\"contextmenu.fb\",function(t){return 2==t.button&&t.preventDefault(),!0}),\"image\"===t.type&&n('<div class=\"fancybox-spaceball\"></div>').appendTo(t.$content)),e.revealContent(t))},revealContent:function(t){var e,a,i,s,r,c=this,l=t.$slide,u=!1;return e=t.opts[c.firstRun?\"animationEffect\":\"transitionEffect\"],i=t.opts[c.firstRun?\"animationDuration\":\"transitionDuration\"],i=parseInt(t.forcedDuration===o?i:t.forcedDuration,10),!t.isMoved&&t.pos===c.currPos&&i||(e=!1),\"zoom\"!==e||t.pos===c.currPos&&i&&\"image\"===t.type&&!t.hasError&&(u=c.getThumbPos(t))||(e=\"fade\"),\"zoom\"===e?(r=c.getFitPos(t),r.scaleX=r.width/u.width,r.scaleY=r.height/u.height,delete r.width,delete r.height,s=t.opts.zoomOpacity,\"auto\"==s&&(s=Math.abs(t.width/t.height-u.width/u.height)>.1),s&&(u.opacity=.1,r.opacity=1),n.fancybox.setTranslate(t.$content.removeClass(\"fancybox-is-hidden\"),u),f(t.$content),void n.fancybox.animate(t.$content,r,i,function(){c.complete()})):(c.updateSlide(t),e?(n.fancybox.stop(l),a=\"fancybox-animated fancybox-slide--\"+(t.pos>=c.prevPos?\"next\":\"previous\")+\" fancybox-fx-\"+e,l.removeAttr(\"style\").removeClass(\"fancybox-slide--current fancybox-slide--next fancybox-slide--previous\").addClass(a),t.$content.removeClass(\"fancybox-is-hidden\"),f(l),void n.fancybox.animate(l,\"fancybox-slide--current\",i,function(e){l.removeClass(a).removeAttr(\"style\"),t.pos===c.currPos&&c.complete()},!0)):(f(l),t.$content.removeClass(\"fancybox-is-hidden\"),void(t.pos===c.currPos&&c.complete())))},getThumbPos:function(o){var a,i=this,s=!1,r=function(e){for(var o,a=e[0],i=a.getBoundingClientRect(),s=[];null!==a.parentElement;)\"hidden\"!==n(a.parentElement).css(\"overflow\")&&\"auto\"!==n(a.parentElement).css(\"overflow\")||s.push(a.parentElement.getBoundingClientRect()),a=a.parentElement;return o=s.every(function(t){var e=Math.min(i.right,t.right)-Math.max(i.left,t.left),n=Math.min(i.bottom,t.bottom)-Math.max(i.top,t.top);return e>0&&n>0}),o&&i.bottom>0&&i.right>0&&i.left<n(t).width()&&i.top<n(t).height()},c=o.opts.$thumb,l=c?c.offset():0;return l&&c[0].ownerDocument===e&&r(c)&&(a=i.$refs.stage.offset(),s={top:l.top-a.top+parseFloat(c.css(\"border-top-width\")||0),left:l.left-a.left+parseFloat(c.css(\"border-left-width\")||0),width:c.width(),height:c.height(),scaleX:1,scaleY:1}),s},complete:function(){var t=this,o=t.current,a={};if(!o.isMoved&&o.isLoaded&&!o.isComplete){o.isComplete=!0,o.$slide.siblings().trigger(\"onReset\"),f(o.$slide),o.$slide.addClass(\"fancybox-slide--complete\"),n.each(t.slides,function(e,o){o.pos>=t.currPos-1&&o.pos<=t.currPos+1?a[o.pos]=o:o&&(n.fancybox.stop(o.$slide),o.$slide.off().remove())}),t.slides=a,t.updateCursor(),t.trigger(\"afterShow\");var i=o.$slide.find(\"video,audio\").first();i.length&&i[0].play(),(n(e.activeElement).is(\"[disabled]\")||o.opts.autoFocus&&\"image\"!=o.type&&\"iframe\"!==o.type)&&t.focus()}},preload:function(){var t,e,n=this;n.group.length<2||(t=n.slides[n.currPos+1],e=n.slides[n.currPos-1],t&&\"image\"===t.type&&n.loadSlide(t),e&&\"image\"===e.type&&n.loadSlide(e))},focus:function(){var t,e=this.current;this.isClosing||(e&&e.isComplete&&(t=e.$slide.find(\"input[autofocus]:enabled:visible:first\"),t.length||(t=e.$slide.find(\"button,:input,[tabindex],a\").filter(\":enabled:visible:first\"))),t=t&&t.length?t:this.$refs.container,t.focus())},activate:function(){var t=this;n(\".fancybox-container\").each(function(){var e=n(this).data(\"FancyBox\");e&&e.id!==t.id&&!e.isClosing&&(e.trigger(\"onDeactivate\"),e.removeEvents(),e.isVisible=!1)}),t.isVisible=!0,(t.current||t.isIdle)&&(t.update(),t.updateControls()),t.trigger(\"onActivate\"),t.addEvents()},close:function(t,e){var o,a,i,s,r,c,l=this,p=l.current,h=function(){l.cleanUp(t)};return!l.isClosing&&(l.isClosing=!0,l.trigger(\"beforeClose\",t)===!1?(l.isClosing=!1,u(function(){l.update()}),!1):(l.removeEvents(),p.timouts&&clearTimeout(p.timouts),i=p.$content,o=p.opts.animationEffect,a=n.isNumeric(e)?e:o?p.opts.animationDuration:0,p.$slide.off(d).removeClass(\"fancybox-slide--complete fancybox-slide--next fancybox-slide--previous fancybox-animated\"),p.$slide.siblings().trigger(\"onReset\").remove(),a&&l.$refs.container.removeClass(\"fancybox-is-open\").addClass(\"fancybox-is-closing\"),l.hideLoading(p),l.hideControls(),l.updateCursor(),\"zoom\"!==o||t!==!0&&i&&a&&\"image\"===p.type&&!p.hasError&&(c=l.getThumbPos(p))||(o=\"fade\"),\"zoom\"===o?(n.fancybox.stop(i),r=n.fancybox.getTranslate(i),r.width=r.width*r.scaleX,r.height=r.height*r.scaleY,s=p.opts.zoomOpacity,\"auto\"==s&&(s=Math.abs(p.width/p.height-c.width/c.height)>.1),s&&(c.opacity=0),r.scaleX=r.width/c.width,r.scaleY=r.height/c.height,r.width=c.width,r.height=c.height,n.fancybox.setTranslate(p.$content,r),f(p.$content),n.fancybox.animate(p.$content,c,a,h),!0):(o&&a?t===!0?setTimeout(h,a):n.fancybox.animate(p.$slide.removeClass(\"fancybox-slide--current\"),\"fancybox-animated fancybox-slide--previous fancybox-fx-\"+o,a,h):h(),!0)))},cleanUp:function(t){var o,a,i=this,r=n(\"body\");i.current.$slide.trigger(\"onReset\"),i.$refs.container.empty().remove(),i.trigger(\"afterClose\",t),i.$lastFocus&&i.current.opts.backFocus&&i.$lastFocus.focus(),i.current=null,o=n.fancybox.getInstance(),o?o.activate():(s.scrollTop(i.scrollTop).scrollLeft(i.scrollLeft),r.removeClass(\"fancybox-active compensate-for-scrollbar\"),r.hasClass(\"fancybox-iosfix\")&&(a=parseInt(e.body.style.top,10),r.removeClass(\"fancybox-iosfix\").css(\"top\",\"\").scrollTop(a*-1)),n(\"#fancybox-style-noscroll\").remove())},trigger:function(t,e){var o,a=Array.prototype.slice.call(arguments,1),i=this,s=e&&e.opts?e:i.current;return s?a.unshift(s):s=i,a.unshift(i),n.isFunction(s.opts[t])&&(o=s.opts[t].apply(s,a)),o===!1?o:void(\"afterClose\"!==t&&i.$refs?i.$refs.container.trigger(t+\".fb\",a):r.trigger(t+\".fb\",a))},updateControls:function(t){var e=this,n=e.current,o=n.index,a=n.opts.caption,i=e.$refs.container,s=e.$refs.caption;n.$slide.trigger(\"refresh\"),e.$caption=a&&a.length?s.html(a):null,e.isHiddenControls||e.isIdle||e.showControls(),i.find(\"[data-fancybox-count]\").html(e.group.length),i.find(\"[data-fancybox-index]\").html(o+1),i.find(\"[data-fancybox-prev]\").prop(\"disabled\",!n.opts.loop&&o<=0),i.find(\"[data-fancybox-next]\").prop(\"disabled\",!n.opts.loop&&o>=e.group.length-1),\"image\"===n.type?i.find(\"[data-fancybox-download]\").attr(\"href\",n.opts.image.src||n.src).show():i.find(\"[data-fancybox-download],[data-fancybox-zoom]\").hide()},hideControls:function(){this.isHiddenControls=!0,this.$refs.container.removeClass(\"fancybox-show-infobar fancybox-show-toolbar fancybox-show-caption fancybox-show-nav\")},showControls:function(){var t=this,e=t.current?t.current.opts:t.opts,n=t.$refs.container;t.isHiddenControls=!1,t.idleSecondsCounter=0,n.toggleClass(\"fancybox-show-toolbar\",!(!e.toolbar||!e.buttons)).toggleClass(\"fancybox-show-infobar\",!!(e.infobar&&t.group.length>1)).toggleClass(\"fancybox-show-nav\",!!(e.arrows&&t.group.length>1)).toggleClass(\"fancybox-is-modal\",!!e.modal),t.$caption?n.addClass(\"fancybox-show-caption \"):n.removeClass(\"fancybox-show-caption\")},toggleControls:function(){this.isHiddenControls?this.showControls():this.hideControls()}}),n.fancybox={version:\"3.2.8\",defaults:i,getInstance:function(t){var e=n('.fancybox-container:not(\".fancybox-is-closing\"):last').data(\"FancyBox\"),o=Array.prototype.slice.call(arguments,1);return e instanceof p&&(\"string\"===n.type(t)?e[t].apply(e,o):\"function\"===n.type(t)&&t.apply(e,o),e)},open:function(t,e,n){return new p(t,e,n)},close:function(t){var e=this.getInstance();e&&(e.close(),t===!0&&this.close())},destroy:function(){this.close(!0),r.off(\"click.fb-start\")},isMobile:e.createTouch!==o&&/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent),use3d:function(){var n=e.createElement(\"div\");return t.getComputedStyle&&t.getComputedStyle(n).getPropertyValue(\"transform\")&&!(e.documentMode&&e.documentMode<11)}(),getTranslate:function(t){var e;if(!t||!t.length)return!1;if(e=t.eq(0).css(\"transform\"),e&&e.indexOf(\"matrix\")!==-1?(e=e.split(\"(\")[1],e=e.split(\")\")[0],e=e.split(\",\")):e=[],e.length)e=e.length>10?[e[13],e[12],e[0],e[5]]:[e[5],e[4],e[0],e[3]],e=e.map(parseFloat);else{e=[0,0,1,1];var n=/\\.*translate\\((.*)px,(.*)px\\)/i,o=n.exec(t.eq(0).attr(\"style\"));o&&(e[0]=parseFloat(o[2]),e[1]=parseFloat(o[1]))}return{top:e[0],left:e[1],scaleX:e[2],scaleY:e[3],opacity:parseFloat(t.css(\"opacity\")),width:t.width(),height:t.height()}},setTranslate:function(t,e){var n=\"\",a={};if(t&&e)return e.left===o&&e.top===o||(n=(e.left===o?t.position().left:e.left)+\"px, \"+(e.top===o?t.position().top:e.top)+\"px\",n=this.use3d?\"translate3d(\"+n+\", 0px)\":\"translate(\"+n+\")\"),e.scaleX!==o&&e.scaleY!==o&&(n=(n.length?n+\" \":\"\")+\"scale(\"+e.scaleX+\", \"+e.scaleY+\")\"),n.length&&(a.transform=n),e.opacity!==o&&(a.opacity=e.opacity),e.width!==o&&(a.width=e.width),e.height!==o&&(a.height=e.height),t.css(a)},animate:function(t,e,a,i,s){n.isFunction(a)&&(i=a,a=null),n.isPlainObject(e)||t.removeAttr(\"style\"),t.on(d,function(a){(!a||!a.originalEvent||t.is(a.originalEvent.target)&&\"z-index\"!=a.originalEvent.propertyName)&&(n.fancybox.stop(t),n.isPlainObject(e)?e.scaleX!==o&&e.scaleY!==o&&(t.css(\"transition-duration\",\"\"),e.width=Math.round(t.width()*e.scaleX),e.height=Math.round(t.height()*e.scaleY),e.scaleX=1,e.scaleY=1,n.fancybox.setTranslate(t,e)):s!==!0&&t.removeClass(e),n.isFunction(i)&&i(a))}),n.isNumeric(a)&&t.css(\"transition-duration\",a+\"ms\"),n.isPlainObject(e)?n.fancybox.setTranslate(t,e):t.addClass(e),e.scaleX&&t.hasClass(\"fancybox-image-wrap\")&&t.parent().addClass(\"fancybox-is-scaling\"),t.data(\"timer\",setTimeout(function(){t.trigger(\"transitionend\")},a+16))},stop:function(t){clearTimeout(t.data(\"timer\")),t.off(\"transitionend\").css(\"transition-duration\",\"\"),t.hasClass(\"fancybox-image-wrap\")&&t.parent().removeClass(\"fancybox-is-scaling\")}},n.fn.fancybox=function(t){var e;return t=t||{},e=t.selector||!1,e?n(\"body\").off(\"click.fb-start\",e).on(\"click.fb-start\",e,{options:t},a):this.off(\"click.fb-start\").on(\"click.fb-start\",{items:this,options:t},a),this},r.on(\"click.fb-start\",\"[data-fancybox]\",a)}}(window,document,window.jQuery||jQuery),function(t){\"use strict\";var e=function(e,n,o){if(e)return o=o||\"\",\"object\"===t.type(o)&&(o=t.param(o,!0)),t.each(n,function(t,n){e=e.replace(\"$\"+t,n||\"\")}),o.length&&(e+=(e.indexOf(\"?\")>0?\"&\":\"?\")+o),e},n={youtube:{matcher:/(youtube\\.com|youtu\\.be|youtube\\-nocookie\\.com)\\/(watch\\?(.*&)?v=|v\\/|u\\/|embed\\/?)?(videoseries\\?list=(.*)|[\\w-]{11}|\\?listType=(.*)&list=(.*))(.*)/i,params:{autoplay:1,autohide:1,fs:1,rel:0,hd:1,wmode:\"transparent\",enablejsapi:1,html5:1},paramPlace:8,type:\"iframe\",url:\"//www.youtube.com/embed/$4\",thumb:\"//img.youtube.com/vi/$4/hqdefault.jpg\"},vimeo:{matcher:/^.+vimeo.com\\/(.*\\/)?([\\d]+)(.*)?/,params:{autoplay:1,hd:1,show_title:1,show_byline:1,show_portrait:0,fullscreen:1,api:1},paramPlace:3,type:\"iframe\",url:\"//player.vimeo.com/video/$2\"},metacafe:{matcher:/metacafe.com\\/watch\\/(\\d+)\\/(.*)?/,type:\"iframe\",url:\"//www.metacafe.com/embed/$1/?ap=1\"},dailymotion:{matcher:/dailymotion.com\\/video\\/(.*)\\/?(.*)/,params:{additionalInfos:0,autoStart:1},type:\"iframe\",url:\"//www.dailymotion.com/embed/video/$1\"},vine:{matcher:/vine.co\\/v\\/([a-zA-Z0-9\\?\\=\\-]+)/,\ntype:\"iframe\",url:\"//vine.co/v/$1/embed/simple\"},instagram:{matcher:/(instagr\\.am|instagram\\.com)\\/p\\/([a-zA-Z0-9_\\-]+)\\/?/i,type:\"image\",url:\"//$1/p/$2/media/?size=l\"},gmap_place:{matcher:/(maps\\.)?google\\.([a-z]{2,3}(\\.[a-z]{2})?)\\/(((maps\\/(place\\/(.*)\\/)?\\@(.*),(\\d+.?\\d+?)z))|(\\?ll=))(.*)?/i,type:\"iframe\",url:function(t){return\"//maps.google.\"+t[2]+\"/?ll=\"+(t[9]?t[9]+\"&z=\"+Math.floor(t[10])+(t[12]?t[12].replace(/^\\//,\"&\"):\"\"):t[12])+\"&output=\"+(t[12]&&t[12].indexOf(\"layer=c\")>0?\"svembed\":\"embed\")}},gmap_search:{matcher:/(maps\\.)?google\\.([a-z]{2,3}(\\.[a-z]{2})?)\\/(maps\\/search\\/)(.*)/i,type:\"iframe\",url:function(t){return\"//maps.google.\"+t[2]+\"/maps?q=\"+t[5].replace(\"query=\",\"q=\").replace(\"api=1\",\"\")+\"&output=embed\"}}};t(document).on(\"objectNeedsType.fb\",function(o,a,i){var s,r,c,l,u,d,f,p=i.src||\"\",h=!1;s=t.extend(!0,{},n,i.opts.media),t.each(s,function(n,o){if(c=p.match(o.matcher)){if(h=o.type,d={},o.paramPlace&&c[o.paramPlace]){u=c[o.paramPlace],\"?\"==u[0]&&(u=u.substring(1)),u=u.split(\"&\");for(var a=0;a<u.length;++a){var s=u[a].split(\"=\",2);2==s.length&&(d[s[0]]=decodeURIComponent(s[1].replace(/\\+/g,\" \")))}}return l=t.extend(!0,{},o.params,i.opts[n],d),p=\"function\"===t.type(o.url)?o.url.call(this,c,l,i):e(o.url,c,l),r=\"function\"===t.type(o.thumb)?o.thumb.call(this,c,l,i):e(o.thumb,c),\"vimeo\"===n&&(p=p.replace(\"&%23\",\"#\")),!1}}),h?(i.src=p,i.type=h,i.opts.thumb||i.opts.$thumb&&i.opts.$thumb.length||(i.opts.thumb=r),\"iframe\"===h&&(t.extend(!0,i.opts,{iframe:{preload:!1,attr:{scrolling:\"no\"}}}),i.contentProvider=f,i.opts.slideClass+=\" fancybox-slide--\"+(\"gmap_place\"==f||\"gmap_search\"==f?\"map\":\"video\"))):p&&(i.type=i.opts.defaultType)})}(window.jQuery||jQuery),function(t,e,n){\"use strict\";var o=function(){return t.requestAnimationFrame||t.webkitRequestAnimationFrame||t.mozRequestAnimationFrame||t.oRequestAnimationFrame||function(e){return t.setTimeout(e,1e3/60)}}(),a=function(){return t.cancelAnimationFrame||t.webkitCancelAnimationFrame||t.mozCancelAnimationFrame||t.oCancelAnimationFrame||function(e){t.clearTimeout(e)}}(),i=function(e){var n=[];e=e.originalEvent||e||t.e,e=e.touches&&e.touches.length?e.touches:e.changedTouches&&e.changedTouches.length?e.changedTouches:[e];for(var o in e)e[o].pageX?n.push({x:e[o].pageX,y:e[o].pageY}):e[o].clientX&&n.push({x:e[o].clientX,y:e[o].clientY});return n},s=function(t,e,n){return e&&t?\"x\"===n?t.x-e.x:\"y\"===n?t.y-e.y:Math.sqrt(Math.pow(t.x-e.x,2)+Math.pow(t.y-e.y,2)):0},r=function(t){if(t.is('a,area,button,[role=\"button\"],input,label,select,summary,textarea')||n.isFunction(t.get(0).onclick)||t.data(\"selectable\"))return!0;for(var e=0,o=t[0].attributes,a=o.length;e<a;e++)if(\"data-fancybox-\"===o[e].nodeName.substr(0,14))return!0;return!1},c=function(e){var n=t.getComputedStyle(e)[\"overflow-y\"],o=t.getComputedStyle(e)[\"overflow-x\"],a=(\"scroll\"===n||\"auto\"===n)&&e.scrollHeight>e.clientHeight,i=(\"scroll\"===o||\"auto\"===o)&&e.scrollWidth>e.clientWidth;return a||i},l=function(t){for(var e=!1;;){if(e=c(t.get(0)))break;if(t=t.parent(),!t.length||t.hasClass(\"fancybox-stage\")||t.is(\"body\"))break}return e},u=function(t){var e=this;e.instance=t,e.$bg=t.$refs.bg,e.$stage=t.$refs.stage,e.$container=t.$refs.container,e.destroy(),e.$container.on(\"touchstart.fb.touch mousedown.fb.touch\",n.proxy(e,\"ontouchstart\"))};u.prototype.destroy=function(){this.$container.off(\".fb.touch\")},u.prototype.ontouchstart=function(o){var a=this,c=n(o.target),u=a.instance,d=u.current,f=d.$content,p=\"touchstart\"==o.type;if(p&&a.$container.off(\"mousedown.fb.touch\"),!d||a.instance.isAnimating||a.instance.isClosing)return o.stopPropagation(),void o.preventDefault();if((!o.originalEvent||2!=o.originalEvent.button)&&c.length&&!r(c)&&!r(c.parent())&&!(o.originalEvent.clientX>c[0].clientWidth+c.offset().left)&&(a.startPoints=i(o),a.startPoints)){if(a.$target=c,a.$content=f,a.canTap=!0,a.opts=d.opts.touch,n(e).off(\".fb.touch\"),n(e).on(p?\"touchend.fb.touch touchcancel.fb.touch\":\"mouseup.fb.touch mouseleave.fb.touch\",n.proxy(a,\"ontouchend\")),n(e).on(p?\"touchmove.fb.touch\":\"mousemove.fb.touch\",n.proxy(a,\"ontouchmove\")),!a.opts&&!u.canPan()||!c.is(a.$stage)&&!a.$stage.find(c).length)return void(c.is(\"img\")&&o.preventDefault());o.stopPropagation(),n.fancybox.isMobile&&(l(a.$target)||l(a.$target.parent()))||o.preventDefault(),a.canvasWidth=Math.round(d.$slide[0].clientWidth),a.canvasHeight=Math.round(d.$slide[0].clientHeight),a.startTime=(new Date).getTime(),a.distanceX=a.distanceY=a.distance=0,a.isPanning=!1,a.isSwiping=!1,a.isZooming=!1,a.sliderStartPos=a.sliderLastPos||{top:0,left:0},a.contentStartPos=n.fancybox.getTranslate(a.$content),a.contentLastPos=null,1!==a.startPoints.length||a.isZooming||(a.canTap=!0,\"image\"===d.type&&(a.contentStartPos.width>a.canvasWidth+1||a.contentStartPos.height>a.canvasHeight+1)?(n.fancybox.stop(a.$content),a.$content.css(\"transition-duration\",\"\"),a.isPanning=!0):a.isSwiping=!0,a.$container.addClass(\"fancybox-controls--isGrabbing\")),2!==a.startPoints.length||u.isAnimating||d.hasError||\"image\"!==d.type||!d.isLoaded&&!d.$ghost||(a.isZooming=!0,a.isSwiping=!1,a.isPanning=!1,n.fancybox.stop(a.$content),a.$content.css(\"transition-duration\",\"\"),a.centerPointStartX=.5*(a.startPoints[0].x+a.startPoints[1].x)-n(t).scrollLeft(),a.centerPointStartY=.5*(a.startPoints[0].y+a.startPoints[1].y)-n(t).scrollTop(),a.percentageOfImageAtPinchPointX=(a.centerPointStartX-a.contentStartPos.left)/a.contentStartPos.width,a.percentageOfImageAtPinchPointY=(a.centerPointStartY-a.contentStartPos.top)/a.contentStartPos.height,a.startDistanceBetweenFingers=s(a.startPoints[0],a.startPoints[1]))}},u.prototype.ontouchmove=function(t){var e=this;if(e.newPoints=i(t),n.fancybox.isMobile&&(l(e.$target)||l(e.$target.parent())))return t.stopPropagation(),void(e.canTap=!1);if((e.opts||e.instance.canPan())&&e.newPoints&&e.newPoints.length&&(e.distanceX=s(e.newPoints[0],e.startPoints[0],\"x\"),e.distanceY=s(e.newPoints[0],e.startPoints[0],\"y\"),e.distance=s(e.newPoints[0],e.startPoints[0]),e.distance>0&&!e.tapped)){if(!e.$target.is(e.$stage)&&!e.$stage.find(e.$target).length)return;t.stopPropagation(),t.preventDefault(),e.isSwiping?e.onSwipe():e.isPanning?e.onPan():e.isZooming&&e.onZoom()}},u.prototype.onSwipe=function(){var e,i=this,s=i.isSwiping,r=i.sliderStartPos.left||0;return s===!0?void(Math.abs(i.distance)>10&&(i.canTap=!1,i.instance.group.length<2&&i.opts.vertical?i.isSwiping=\"y\":i.instance.isDragging||i.opts.vertical===!1||\"auto\"===i.opts.vertical&&n(t).width()>800?i.isSwiping=\"x\":(e=Math.abs(180*Math.atan2(i.distanceY,i.distanceX)/Math.PI),i.isSwiping=e>45&&e<135?\"y\":\"x\"),i.instance.isDragging=i.isSwiping,i.startPoints=i.newPoints,n.each(i.instance.slides,function(t,e){n.fancybox.stop(e.$slide),e.$slide.css(\"transition-duration\",\"\"),e.inTransition=!1,e.pos===i.instance.current.pos&&(i.sliderStartPos.left=n.fancybox.getTranslate(e.$slide).left)}),i.instance.SlideShow&&i.instance.SlideShow.isActive&&i.instance.SlideShow.stop())):(\"x\"==s&&(i.distanceX>0&&(i.instance.group.length<2||0===i.instance.current.index&&!i.instance.current.opts.loop)?r+=Math.pow(i.distanceX,.8):i.distanceX<0&&(i.instance.group.length<2||i.instance.current.index===i.instance.group.length-1&&!i.instance.current.opts.loop)?r-=Math.pow(-i.distanceX,.8):r+=i.distanceX),i.sliderLastPos={top:\"x\"==s?0:i.sliderStartPos.top+i.distanceY,left:r},i.requestId&&(a(i.requestId),i.requestId=null),void(i.requestId=o(function(){i.sliderLastPos&&(n.each(i.instance.slides,function(t,e){var o=e.pos-i.instance.currPos;n.fancybox.setTranslate(e.$slide,{top:i.sliderLastPos.top,left:i.sliderLastPos.left+o*i.canvasWidth+o*e.opts.gutter})}),i.$container.addClass(\"fancybox-is-sliding\"))})))},u.prototype.onPan=function(){var t,e,i,s=this;s.canTap=!1,t=s.contentStartPos.width>s.canvasWidth?s.contentStartPos.left+s.distanceX:s.contentStartPos.left,e=s.contentStartPos.top+s.distanceY,i=s.limitMovement(t,e,s.contentStartPos.width,s.contentStartPos.height),i.scaleX=s.contentStartPos.scaleX,i.scaleY=s.contentStartPos.scaleY,s.contentLastPos=i,s.requestId&&(a(s.requestId),s.requestId=null),s.requestId=o(function(){n.fancybox.setTranslate(s.$content,s.contentLastPos)})},u.prototype.limitMovement=function(t,e,n,o){var a,i,s,r,c=this,l=c.canvasWidth,u=c.canvasHeight,d=c.contentStartPos.left,f=c.contentStartPos.top,p=c.distanceX,h=c.distanceY;return a=Math.max(0,.5*l-.5*n),i=Math.max(0,.5*u-.5*o),s=Math.min(l-n,.5*l-.5*n),r=Math.min(u-o,.5*u-.5*o),n>l&&(p>0&&t>a&&(t=a-1+Math.pow(-a+d+p,.8)||0),p<0&&t<s&&(t=s+1-Math.pow(s-d-p,.8)||0)),o>u&&(h>0&&e>i&&(e=i-1+Math.pow(-i+f+h,.8)||0),h<0&&e<r&&(e=r+1-Math.pow(r-f-h,.8)||0)),{top:e,left:t}},u.prototype.limitPosition=function(t,e,n,o){var a=this,i=a.canvasWidth,s=a.canvasHeight;return n>i?(t=t>0?0:t,t=t<i-n?i-n:t):t=Math.max(0,i/2-n/2),o>s?(e=e>0?0:e,e=e<s-o?s-o:e):e=Math.max(0,s/2-o/2),{top:e,left:t}},u.prototype.onZoom=function(){var e=this,i=e.contentStartPos.width,r=e.contentStartPos.height,c=e.contentStartPos.left,l=e.contentStartPos.top,u=s(e.newPoints[0],e.newPoints[1]),d=u/e.startDistanceBetweenFingers,f=Math.floor(i*d),p=Math.floor(r*d),h=(i-f)*e.percentageOfImageAtPinchPointX,g=(r-p)*e.percentageOfImageAtPinchPointY,b=(e.newPoints[0].x+e.newPoints[1].x)/2-n(t).scrollLeft(),m=(e.newPoints[0].y+e.newPoints[1].y)/2-n(t).scrollTop(),y=b-e.centerPointStartX,v=m-e.centerPointStartY,x=c+(h+y),w=l+(g+v),$={top:w,left:x,scaleX:e.contentStartPos.scaleX*d,scaleY:e.contentStartPos.scaleY*d};e.canTap=!1,e.newWidth=f,e.newHeight=p,e.contentLastPos=$,e.requestId&&(a(e.requestId),e.requestId=null),e.requestId=o(function(){n.fancybox.setTranslate(e.$content,e.contentLastPos)})},u.prototype.ontouchend=function(t){var o=this,s=Math.max((new Date).getTime()-o.startTime,1),r=o.isSwiping,c=o.isPanning,l=o.isZooming;return o.endPoints=i(t),o.$container.removeClass(\"fancybox-controls--isGrabbing\"),n(e).off(\".fb.touch\"),o.requestId&&(a(o.requestId),o.requestId=null),o.isSwiping=!1,o.isPanning=!1,o.isZooming=!1,o.instance.isDragging=!1,o.canTap?o.onTap(t):(o.speed=366,o.velocityX=o.distanceX/s*.5,o.velocityY=o.distanceY/s*.5,o.speedX=Math.max(.5*o.speed,Math.min(1.5*o.speed,1/Math.abs(o.velocityX)*o.speed)),void(c?o.endPanning():l?o.endZooming():o.endSwiping(r)))},u.prototype.endSwiping=function(t){var e=this,o=!1;e.sliderLastPos=null,\"y\"==t&&Math.abs(e.distanceY)>50?(n.fancybox.animate(e.instance.current.$slide,{top:e.sliderStartPos.top+e.distanceY+150*e.velocityY,opacity:0},150),o=e.instance.close(!0,300)):\"x\"==t&&e.distanceX>50&&e.instance.group.length>1?o=e.instance.previous(e.speedX):\"x\"==t&&e.distanceX<-50&&e.instance.group.length>1&&(o=e.instance.next(e.speedX)),o!==!1||\"x\"!=t&&\"y\"!=t||e.instance.jumpTo(e.instance.current.index,150),e.$container.removeClass(\"fancybox-is-sliding\")},u.prototype.endPanning=function(){var t,e,o,a=this;a.contentLastPos&&(a.opts.momentum===!1?(t=a.contentLastPos.left,e=a.contentLastPos.top):(t=a.contentLastPos.left+a.velocityX*a.speed,e=a.contentLastPos.top+a.velocityY*a.speed),o=a.limitPosition(t,e,a.contentStartPos.width,a.contentStartPos.height),o.width=a.contentStartPos.width,o.height=a.contentStartPos.height,n.fancybox.animate(a.$content,o,330))},u.prototype.endZooming=function(){var t,e,o,a,i=this,s=i.instance.current,r=i.newWidth,c=i.newHeight;i.contentLastPos&&(t=i.contentLastPos.left,e=i.contentLastPos.top,a={top:e,left:t,width:r,height:c,scaleX:1,scaleY:1},n.fancybox.setTranslate(i.$content,a),r<i.canvasWidth&&c<i.canvasHeight?i.instance.scaleToFit(150):r>s.width||c>s.height?i.instance.scaleToActual(i.centerPointStartX,i.centerPointStartY,150):(o=i.limitPosition(t,e,r,c),n.fancybox.setTranslate(i.content,n.fancybox.getTranslate(i.$content)),n.fancybox.animate(i.$content,o,150)))},u.prototype.onTap=function(t){var e,o=this,a=n(t.target),s=o.instance,r=s.current,c=t&&i(t)||o.startPoints,l=c[0]?c[0].x-o.$stage.offset().left:0,u=c[0]?c[0].y-o.$stage.offset().top:0,d=function(e){var a=r.opts[e];if(n.isFunction(a)&&(a=a.apply(s,[r,t])),a)switch(a){case\"close\":s.close(o.startEvent);break;case\"toggleControls\":s.toggleControls(!0);break;case\"next\":s.next();break;case\"nextOrClose\":s.group.length>1?s.next():s.close(o.startEvent);break;case\"zoom\":\"image\"==r.type&&(r.isLoaded||r.$ghost)&&(s.canPan()?s.scaleToFit():s.isScaledDown()?s.scaleToActual(l,u):s.group.length<2&&s.close(o.startEvent))}};if(!(t.originalEvent&&2==t.originalEvent.button||l>a[0].clientWidth+a.offset().left)){if(a.is(\".fancybox-bg,.fancybox-inner,.fancybox-outer,.fancybox-container\"))e=\"Outside\";else if(a.is(\".fancybox-slide\"))e=\"Slide\";else{if(!s.current.$content||!s.current.$content.has(t.target).length)return;e=\"Content\"}if(o.tapped){if(clearTimeout(o.tapped),o.tapped=null,Math.abs(l-o.tapX)>50||Math.abs(u-o.tapY)>50)return this;d(\"dblclick\"+e)}else o.tapX=l,o.tapY=u,r.opts[\"dblclick\"+e]&&r.opts[\"dblclick\"+e]!==r.opts[\"click\"+e]?o.tapped=setTimeout(function(){o.tapped=null,d(\"click\"+e)},500):d(\"click\"+e);return this}},n(e).on(\"onActivate.fb\",function(t,e){e&&!e.Guestures&&(e.Guestures=new u(e))}),n(e).on(\"beforeClose.fb\",function(t,e){e&&e.Guestures&&e.Guestures.destroy()})}(window,document,window.jQuery||jQuery),function(t,e){\"use strict\";e.extend(!0,e.fancybox.defaults,{btnTpl:{slideShow:'<button data-fancybox-play class=\"fancybox-button fancybox-button--play\" title=\"{{PLAY_START}}\"><svg viewBox=\"0 0 40 40\"><path d=\"M13,12 L27,20 L13,27 Z\" /><path d=\"M15,10 v19 M23,10 v19\" /></svg></button>'},slideShow:{autoStart:!1,speed:3e3}});var n=function(t){this.instance=t,this.init()};e.extend(n.prototype,{timer:null,isActive:!1,$button:null,init:function(){var t=this;t.$button=t.instance.$refs.toolbar.find(\"[data-fancybox-play]\").on(\"click\",function(){t.toggle()}),(t.instance.group.length<2||!t.instance.group[t.instance.currIndex].opts.slideShow)&&t.$button.hide()},set:function(t){var e=this;e.instance&&e.instance.current&&(t===!0||e.instance.current.opts.loop||e.instance.currIndex<e.instance.group.length-1)?e.timer=setTimeout(function(){e.isActive&&e.instance.jumpTo((e.instance.currIndex+1)%e.instance.group.length)},e.instance.current.opts.slideShow.speed):(e.stop(),e.instance.idleSecondsCounter=0,e.instance.showControls())},clear:function(){var t=this;clearTimeout(t.timer),t.timer=null},start:function(){var t=this,e=t.instance.current;e&&(t.isActive=!0,t.$button.attr(\"title\",e.opts.i18n[e.opts.lang].PLAY_STOP).removeClass(\"fancybox-button--play\").addClass(\"fancybox-button--pause\"),t.set(!0))},stop:function(){var t=this,e=t.instance.current;t.clear(),t.$button.attr(\"title\",e.opts.i18n[e.opts.lang].PLAY_START).removeClass(\"fancybox-button--pause\").addClass(\"fancybox-button--play\"),t.isActive=!1},toggle:function(){var t=this;t.isActive?t.stop():t.start()}}),e(t).on({\"onInit.fb\":function(t,e){e&&!e.SlideShow&&(e.SlideShow=new n(e))},\"beforeShow.fb\":function(t,e,n,o){var a=e&&e.SlideShow;o?a&&n.opts.slideShow.autoStart&&a.start():a&&a.isActive&&a.clear()},\"afterShow.fb\":function(t,e,n){var o=e&&e.SlideShow;o&&o.isActive&&o.set()},\"afterKeydown.fb\":function(n,o,a,i,s){var r=o&&o.SlideShow;!r||!a.opts.slideShow||80!==s&&32!==s||e(t.activeElement).is(\"button,a,input\")||(i.preventDefault(),r.toggle())},\"beforeClose.fb onDeactivate.fb\":function(t,e){var n=e&&e.SlideShow;n&&n.stop()}}),e(t).on(\"visibilitychange\",function(){var n=e.fancybox.getInstance(),o=n&&n.SlideShow;o&&o.isActive&&(t.hidden?o.clear():o.set())})}(document,window.jQuery||jQuery),function(t,e){\"use strict\";var n=function(){var e,n,o,a=[[\"requestFullscreen\",\"exitFullscreen\",\"fullscreenElement\",\"fullscreenEnabled\",\"fullscreenchange\",\"fullscreenerror\"],[\"webkitRequestFullscreen\",\"webkitExitFullscreen\",\"webkitFullscreenElement\",\"webkitFullscreenEnabled\",\"webkitfullscreenchange\",\"webkitfullscreenerror\"],[\"webkitRequestFullScreen\",\"webkitCancelFullScreen\",\"webkitCurrentFullScreenElement\",\"webkitCancelFullScreen\",\"webkitfullscreenchange\",\"webkitfullscreenerror\"],[\"mozRequestFullScreen\",\"mozCancelFullScreen\",\"mozFullScreenElement\",\"mozFullScreenEnabled\",\"mozfullscreenchange\",\"mozfullscreenerror\"],[\"msRequestFullscreen\",\"msExitFullscreen\",\"msFullscreenElement\",\"msFullscreenEnabled\",\"MSFullscreenChange\",\"MSFullscreenError\"]],i={};for(n=0;n<a.length;n++)if(e=a[n],e&&e[1]in t){for(o=0;o<e.length;o++)i[a[0][o]]=e[o];return i}return!1}();if(!n)return void(e&&e.fancybox&&(e.fancybox.defaults.btnTpl.fullScreen=!1));var o={request:function(e){e=e||t.documentElement,e[n.requestFullscreen](e.ALLOW_KEYBOARD_INPUT)},exit:function(){t[n.exitFullscreen]()},toggle:function(e){e=e||t.documentElement,this.isFullscreen()?this.exit():this.request(e)},isFullscreen:function(){return Boolean(t[n.fullscreenElement])},enabled:function(){return Boolean(t[n.fullscreenEnabled])}};e.extend(!0,e.fancybox.defaults,{btnTpl:{fullScreen:'<button data-fancybox-fullscreen class=\"fancybox-button fancybox-button--fullscreen\" title=\"{{FULL_SCREEN}}\"><svg viewBox=\"0 0 40 40\"><path d=\"M9,12 h22 v16 h-22 v-16 v16 h22 v-16 Z\" /></svg></button>'},fullScreen:{autoStart:!1}}),e(t).on({\"onInit.fb\":function(t,e){var n;e&&e.group[e.currIndex].opts.fullScreen?(n=e.$refs.container,n.on(\"click.fb-fullscreen\",\"[data-fancybox-fullscreen]\",function(t){t.stopPropagation(),t.preventDefault(),o.toggle(n[0])}),e.opts.fullScreen&&e.opts.fullScreen.autoStart===!0&&o.request(n[0]),e.FullScreen=o):e&&e.$refs.toolbar.find(\"[data-fancybox-fullscreen]\").hide()},\"afterKeydown.fb\":function(t,e,n,o,a){e&&e.FullScreen&&70===a&&(o.preventDefault(),e.FullScreen.toggle(e.$refs.container[0]))},\"beforeClose.fb\":function(t){t&&t.FullScreen&&o.exit()}}),e(t).on(n.fullscreenchange,function(){var t=o.isFullscreen(),n=e.fancybox.getInstance();n&&(n.current&&\"image\"===n.current.type&&n.isAnimating&&(n.current.$content.css(\"transition\",\"none\"),n.isAnimating=!1,n.update(!0,!0,0)),n.trigger(\"onFullscreenChange\",t),n.$refs.container.toggleClass(\"fancybox-is-fullscreen\",t))})}(document,window.jQuery||jQuery),function(t,e){\"use strict\";e.fancybox.defaults=e.extend(!0,{btnTpl:{thumbs:'<button data-fancybox-thumbs class=\"fancybox-button fancybox-button--thumbs\" title=\"{{THUMBS}}\"><svg viewBox=\"0 0 120 120\"><path d=\"M30,30 h14 v14 h-14 Z M50,30 h14 v14 h-14 Z M70,30 h14 v14 h-14 Z M30,50 h14 v14 h-14 Z M50,50 h14 v14 h-14 Z M70,50 h14 v14 h-14 Z M30,70 h14 v14 h-14 Z M50,70 h14 v14 h-14 Z M70,70 h14 v14 h-14 Z\" /></svg></button>'},thumbs:{autoStart:!1,hideOnClose:!0,parentEl:\".fancybox-container\",axis:\"y\"}},e.fancybox.defaults);var n=function(t){this.init(t)};e.extend(n.prototype,{$button:null,$grid:null,$list:null,isVisible:!1,isActive:!1,init:function(t){var e=this;e.instance=t,t.Thumbs=e;var n=t.group[0],o=t.group[1];e.opts=t.group[t.currIndex].opts.thumbs,e.$button=t.$refs.toolbar.find(\"[data-fancybox-thumbs]\"),e.opts&&n&&o&&(\"image\"==n.type||n.opts.thumb||n.opts.$thumb)&&(\"image\"==o.type||o.opts.thumb||o.opts.$thumb)?(e.$button.show().on(\"click\",function(){e.toggle()}),e.isActive=!0):e.$button.hide()},create:function(){var t,n,o=this,a=o.instance,i=o.opts.parentEl;o.$grid=e('<div class=\"fancybox-thumbs fancybox-thumbs-'+o.opts.axis+'\"></div>').appendTo(a.$refs.container.find(i).addBack().filter(i)),t=\"<ul>\",e.each(a.group,function(e,o){n=o.opts.thumb||(o.opts.$thumb?o.opts.$thumb.attr(\"src\"):null),n||\"image\"!==o.type||(n=o.src),n&&n.length&&(t+='<li data-index=\"'+e+'\"  tabindex=\"0\" class=\"fancybox-thumbs-loading\"><img data-src=\"'+n+'\" /></li>')}),t+=\"</ul>\",o.$list=e(t).appendTo(o.$grid).on(\"click\",\"li\",function(){a.jumpTo(e(this).data(\"index\"))}),o.$list.find(\"img\").hide().one(\"load\",function(){var t,n,o,a,i=e(this).parent().removeClass(\"fancybox-thumbs-loading\"),s=i.outerWidth(),r=i.outerHeight();t=this.naturalWidth||this.width,n=this.naturalHeight||this.height,o=t/s,a=n/r,o>=1&&a>=1&&(o>a?(t/=a,n=r):(t=s,n/=o)),e(this).css({width:Math.floor(t),height:Math.floor(n),\"margin-top\":n>r?Math.floor(.3*r-.3*n):Math.floor(.5*r-.5*n),\"margin-left\":Math.floor(.5*s-.5*t)}).show()}).each(function(){this.src=e(this).data(\"src\")}),\"x\"===o.opts.axis&&o.$list.width(parseInt(o.$grid.css(\"padding-right\"))+a.group.length*o.$list.children().eq(0).outerWidth(!0)+\"px\")},focus:function(t){var e,n,o=this,a=o.$list;o.instance.current&&(e=a.children().removeClass(\"fancybox-thumbs-active\").filter('[data-index=\"'+o.instance.current.index+'\"]').addClass(\"fancybox-thumbs-active\"),n=e.position(),\"y\"===o.opts.axis&&(n.top<0||n.top>a.height()-e.outerHeight())?a.stop().animate({scrollTop:a.scrollTop()+n.top},t):\"x\"===o.opts.axis&&(n.left<a.parent().scrollLeft()||n.left>a.parent().scrollLeft()+(a.parent().width()-e.outerWidth()))&&a.parent().stop().animate({scrollLeft:n.left},t))},update:function(){this.instance.$refs.container.toggleClass(\"fancybox-show-thumbs\",this.isVisible),this.isVisible?(this.$grid||this.create(),this.instance.trigger(\"onThumbsShow\"),this.focus(0)):this.$grid&&this.instance.trigger(\"onThumbsHide\"),this.instance.update()},hide:function(){this.isVisible=!1,this.update()},show:function(){this.isVisible=!0,this.update()},toggle:function(){this.isVisible=!this.isVisible,this.update()}}),e(t).on({\"onInit.fb\":function(t,e){var o;e&&!e.Thumbs&&(o=new n(e),o.isActive&&o.opts.autoStart===!0&&o.show())},\"beforeShow.fb\":function(t,e,n,o){var a=e&&e.Thumbs;a&&a.isVisible&&a.focus(o?0:250)},\"afterKeydown.fb\":function(t,e,n,o,a){var i=e&&e.Thumbs;i&&i.isActive&&71===a&&(o.preventDefault(),i.toggle())},\"beforeClose.fb\":function(t,e){var n=e&&e.Thumbs;n&&n.isVisible&&n.opts.hideOnClose!==!1&&n.$grid.hide()}})}(document,window.jQuery),function(t,e){\"use strict\";function n(t){var e={\"&\":\"&amp;\",\"<\":\"&lt;\",\">\":\"&gt;\",'\"':\"&quot;\",\"'\":\"&#39;\",\"/\":\"&#x2F;\",\"`\":\"&#x60;\",\"=\":\"&#x3D;\"};return String(t).replace(/[&<>\"'`=\\/]/g,function(t){return e[t]})}e.extend(!0,e.fancybox.defaults,{btnTpl:{share:'<button data-fancybox-share class=\"fancybox-button fancybox-button--share\" title=\"{{SHARE}}\"><svg viewBox=\"0 0 40 40\"><path d=\"M6,30 C8,18 19,16 23,16 L23,16 L23,10 L33,20 L23,29 L23,24 C19,24 8,27 6,30 Z\"></svg></button>'},share:{tpl:'<div class=\"fancybox-share\"><h1>{{SHARE}}</h1><p><a href=\"https://www.facebook.com/sharer/sharer.php?u={{src}}\" target=\"_blank\" class=\"fancybox-share_button\"><svg version=\"1.1\" viewBox=\"0 0 32 32\" fill=\"#3b5998\"><path d=\"M27.6 3h-23.2c-.8 0-1.4.6-1.4 1.4v23.1c0 .9.6 1.5 1.4 1.5h12.5v-10.1h-3.4v-3.9h3.4v-2.9c0-3.4 2.1-5.2 5-5.2 1.4 0 2.7.1 3 .2v3.5h-2.1c-1.6 0-1.9.8-1.9 1.9v2.5h3.9l-.5 3.9h-3.4v10.1h6.6c.8 0 1.4-.6 1.4-1.4v-23.2c.1-.8-.5-1.4-1.3-1.4z\"></path></svg><span>Facebook</span></a><a href=\"https://www.pinterest.com/pin/create/button/?url={{src}}&amp;description={{descr}}\" target=\"_blank\" class=\"fancybox-share_button\"><svg version=\"1.1\" viewBox=\"0 0 32 32\" fill=\"#c92228\"><path d=\"M16 3c-7.2 0-13 5.8-13 13 0 5.5 3.4 10.2 8.3 12.1-.1-1-.2-2.6 0-3.7.2-1 1.5-6.5 1.5-6.5s-.4-.8-.4-1.9c0-1.8 1-3.2 2.4-3.2 1.1 0 1.6.8 1.6 1.8 0 1.1-.7 2.8-1.1 4.3-.3 1.3.6 2.3 1.9 2.3 2.3 0 4.1-2.4 4.1-6 0-3.1-2.2-5.3-5.4-5.3-3.7 0-5.9 2.8-5.9 5.6 0 1.1.4 2.3 1 3 .1.1.1.2.1.4-.1.4-.3 1.3-.4 1.5-.1.2-.2.3-.4.2-1.6-.8-2.6-3.1-2.6-5 0-4.1 3-7.9 8.6-7.9 4.5 0 8 3.2 8 7.5 0 4.5-2.8 8.1-6.7 8.1-1.3 0-2.6-.7-3-1.5 0 0-.7 2.5-.8 3.1-.3 1.1-1.1 2.5-1.6 3.4 1.2.4 2.5.6 3.8.6 7.2 0 13-5.8 13-13 0-7.1-5.8-12.9-13-12.9z\"></path></svg><span>Pinterest</span></a><a href=\"https://twitter.com/intent/tweet?url={{src}}&amp;text={{descr}}\" target=\"_blank\" class=\"fancybox-share_button\"><svg version=\"1.1\" viewBox=\"0 0 32 32\" fill=\"#1da1f2\"><path d=\"M30 7.3c-1 .5-2.1.8-3.3.9 1.2-.7 2.1-1.8 2.5-3.2-1.1.7-2.3 1.1-3.6 1.4-1-1.1-2.5-1.8-4.2-1.8-3.2 0-5.7 2.6-5.7 5.7 0 .5.1.9.1 1.3-4.8-.2-9-2.5-11.8-6-.5.9-.8 1.9-.8 3 0 2 1 3.8 2.6 4.8-.9 0-1.8-.3-2.6-.7v.1c0 2.8 2 5.1 4.6 5.6-.5.1-1 .2-1.5.2-.4 0-.7 0-1.1-.1.7 2.3 2.9 3.9 5.4 4-2 1.5-4.4 2.5-7.1 2.5-.5 0-.9 0-1.4-.1 2.5 1.6 5.6 2.6 8.8 2.6 10.6 0 16.3-8.8 16.3-16.3v-.7c1.1-1 2-2 2.8-3.2z\"></path></svg><span>Twitter</span></a></p><p><input type=\"text\" value=\"{{src_raw}}\" onfocus=\"this.select()\" /></p></div>'}}),e(t).on(\"click\",\"[data-fancybox-share]\",function(){var t,o,a=e.fancybox.getInstance();a&&(t=a.current.opts.hash===!1?a.current.src:window.location,o=a.current.opts.share.tpl.replace(/\\{\\{src\\}\\}/g,encodeURIComponent(t)).replace(/\\{\\{src_raw\\}\\}/g,n(t)).replace(/\\{\\{descr\\}\\}/g,a.$caption?encodeURIComponent(a.$caption.text()):\"\"),e.fancybox.open({src:a.translate(a,o),type:\"html\",opts:{animationEffect:\"fade\",animationDuration:250}}))})}(document,window.jQuery||jQuery),function(t,e,n){\"use strict\";function o(){var t=e.location.hash.substr(1),n=t.split(\"-\"),o=n.length>1&&/^\\+?\\d+$/.test(n[n.length-1])?parseInt(n.pop(-1),10)||1:1,a=n.join(\"-\");return o<1&&(o=1),{hash:t,index:o,gallery:a}}function a(t){var e;\"\"!==t.gallery&&(e=n(\"[data-fancybox='\"+n.escapeSelector(t.gallery)+\"']\").eq(t.index-1),e.length||(e=n(\"#\"+n.escapeSelector(t.gallery))),e.length&&(s=!1,e.trigger(\"click\")))}function i(t){var e;return!!t&&(e=t.current?t.current.opts:t.opts,e.hash||(e.$orig?e.$orig.data(\"fancybox\"):\"\"))}n.escapeSelector||(n.escapeSelector=function(t){var e=/([\\0-\\x1f\\x7f]|^-?\\d)|^-$|[^\\x80-\\uFFFF\\w-]/g,n=function(t,e){return e?\"\\0\"===t?\"\ufffd\":t.slice(0,-1)+\"\\\\\"+t.charCodeAt(t.length-1).toString(16)+\" \":\"\\\\\"+t};return(t+\"\").replace(e,n)});var s=!0,r=null,c=null;n(function(){n.fancybox.defaults.hash!==!1&&(n(t).on({\"onInit.fb\":function(t,e){var n,a;e.group[e.currIndex].opts.hash!==!1&&(n=o(),a=i(e),a&&n.gallery&&a==n.gallery&&(e.currIndex=n.index-1))},\"beforeShow.fb\":function(n,o,a){var l;a&&a.opts.hash!==!1&&(l=i(o),l&&\"\"!==l&&(e.location.hash.indexOf(l)<0&&(o.opts.origHash=e.location.hash),r=l+(o.group.length>1?\"-\"+(a.index+1):\"\"),\"replaceState\"in e.history?(c&&clearTimeout(c),c=setTimeout(function(){e.history[s?\"pushState\":\"replaceState\"]({},t.title,e.location.pathname+e.location.search+\"#\"+r),c=null,s=!1},300)):e.location.hash=r))},\"beforeClose.fb\":function(o,a,s){var l,u;c&&clearTimeout(c),s.opts.hash!==!1&&(l=i(a),u=a&&a.opts.origHash?a.opts.origHash:\"\",l&&\"\"!==l&&(\"replaceState\"in history?e.history.replaceState({},t.title,e.location.pathname+e.location.search+u):(e.location.hash=u,n(e).scrollTop(a.scrollTop).scrollLeft(a.scrollLeft))),r=null)}}),n(e).on(\"hashchange.fb\",function(){var t=o();n.fancybox.getInstance()?!r||r===t.gallery+\"-\"+t.index||1===t.index&&r==t.gallery||(r=null,n.fancybox.close()):\"\"!==t.gallery&&a(t)}),setTimeout(function(){a(o())},50))})}(document,window,window.jQuery||jQuery),function(t,e){\"use strict\";var n=(new Date).getTime();e(t).on({\"onInit.fb\":function(t,e,o){e.$refs.stage.on(\"mousewheel DOMMouseScroll wheel MozMousePixelScroll\",function(t){var o,a,i,s,r,c=e.current;c.opts.wheel===!1||\"auto\"===c.opts.wheel&&\"image\"!==c.type||c.$slide.hasClass(\"fancybox-animated\")||e.group.length<1||(t.preventDefault(),t.stopPropagation(),t=t.originalEvent||t,o-n<250||(n=o,a=t.wheelDelta||-t.deltaY||-t.detail,i=Math.max(-1,Math.min(1,a)),s=\"undefined\"!=typeof t.wheelDeltaX||\"undefined\"!=typeof t.deltaX,r=!s||Math.abs(t.wheelDeltaX)<Math.abs(t.wheelDelta)||Math.abs(t.deltaX)<Math.abs(t.deltaY),i<0?e[r?\"previous\":\"next\"]():e[r?\"next\":\"previous\"]()))})}})}(document,window.jQuery||jQuery);","Magefan_Blog/js/jquery.tagcanvas.min.js":"/**\n * Copyright (C) 2010-2015 Graham Breach\n *\n * This program is free software: you can redistribute it and/or modify\n * it under the terms of the GNU Lesser General Public License as published by\n * the Free Software Foundation, either version 3 of the License, or\n * (at your option) any later version.\n *\n * This program is distributed in the hope that it will be useful,\n * but WITHOUT ANY WARRANTY; without even the implied warranty of\n * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n * GNU Lesser General Public License for more details.\n * \n * You should have received a copy of the GNU Lesser General Public License\n * along with this program.  If not, see <http://www.gnu.org/licenses/>.\n */\n/**\n * jQuery.tagcanvas 2.9\n * For more information, please contact <graham@goat1000.com>\n */\n(function(ap){var M,K,L=Math.abs,ah=Math.sin,w=Math.cos,s=Math.max,aE=Math.min,aq=Math.ceil,F=Math.sqrt,au=Math.pow,h={},l={},m={0:\"0,\",1:\"17,\",2:\"34,\",3:\"51,\",4:\"68,\",5:\"85,\",6:\"102,\",7:\"119,\",8:\"136,\",9:\"153,\",a:\"170,\",A:\"170,\",b:\"187,\",B:\"187,\",c:\"204,\",C:\"204,\",d:\"221,\",D:\"221,\",e:\"238,\",E:\"238,\",f:\"255,\",F:\"255,\"},x,c,Q,aG,H,aH,aa,C=document,p,b={};for(M=0;M<256;++M){K=M.toString(16);if(M<16){K=\"0\"+K}l[K]=l[K.toUpperCase()]=M.toString()+\",\"}function ai(i){return typeof i!=\"undefined\"}function I(i){return typeof i==\"object\"&&i!=null}function aw(i,j,aI){return isNaN(i)?aI:aE(aI,s(j,i))}function aB(){return false}function G(){return new Date().valueOf()}function A(aI,aL){var j=[],aJ=aI.length,aK;for(aK=0;aK<aJ;++aK){j.push(aI[aK])}j.sort(aL);return j}function an(j){var aJ=j.length-1,aI,aK;while(aJ){aK=~~(Math.random()*aJ);aI=j[aJ];j[aJ]=j[aK];j[aK]=aI;--aJ}}function ae(i,aI,j){this.x=i;this.y=aI;this.z=j}H=ae.prototype;H.length=function(){return F(this.x*this.x+this.y*this.y+this.z*this.z)};H.dot=function(i){return this.x*i.x+this.y*i.y+this.z*i.z};H.cross=function(j){var i=this.y*j.z-this.z*j.y,aJ=this.z*j.x-this.x*j.z,aI=this.x*j.y-this.y*j.x;return new ae(i,aJ,aI)};H.angle=function(j){var i=this.dot(j),aI;if(i==0){return Math.PI/2}aI=i/(this.length()*j.length());if(aI>=1){return 0}if(aI<=-1){return Math.PI}return Math.acos(aI)};H.unit=function(){var i=this.length();return new ae(this.x/i,this.y/i,this.z/i)};function aj(aI,j){j=j*Math.PI/180;aI=aI*Math.PI/180;var i=ah(aI)*w(j),aK=-ah(j),aJ=-w(aI)*w(j);return new ae(i,aK,aJ)}function R(i){this[1]={1:i[0],2:i[1],3:i[2]};this[2]={1:i[3],2:i[4],3:i[5]};this[3]={1:i[6],2:i[7],3:i[8]}}aG=R.prototype;R.Identity=function(){return new R([1,0,0,0,1,0,0,0,1])};R.Rotation=function(aJ,i){var j=ah(aJ),aI=w(aJ),aK=1-aI;return new R([aI+au(i.x,2)*aK,i.x*i.y*aK-i.z*j,i.x*i.z*aK+i.y*j,i.y*i.x*aK+i.z*j,aI+au(i.y,2)*aK,i.y*i.z*aK-i.x*j,i.z*i.x*aK-i.y*j,i.z*i.y*aK+i.x*j,aI+au(i.z,2)*aK])};aG.mul=function(aI){var aJ=[],aM,aL,aK=(aI.xform?1:0);for(aM=1;aM<=3;++aM){for(aL=1;aL<=3;++aL){if(aK){aJ.push(this[aM][1]*aI[1][aL]+this[aM][2]*aI[2][aL]+this[aM][3]*aI[3][aL])}else{aJ.push(this[aM][aL]*aI)}}}return new R(aJ)};aG.xform=function(aI){var j={},i=aI.x,aK=aI.y,aJ=aI.z;j.x=i*this[1][1]+aK*this[2][1]+aJ*this[3][1];j.y=i*this[1][2]+aK*this[2][2]+aJ*this[3][2];j.z=i*this[1][3]+aK*this[2][3]+aJ*this[3][3];return j};function q(aJ,aL,aR,aO,aQ){var aM,aP,j,aN,aS=[],aI=2/aJ,aK;aK=Math.PI*(3-F(5)+(parseFloat(aQ)?parseFloat(aQ):0));for(aM=0;aM<aJ;++aM){aP=aM*aI-1+(aI/2);j=F(1-aP*aP);aN=aM*aK;aS.push([w(aN)*j*aL,aP*aR,ah(aN)*j*aO])}return aS}function W(aK,aI,aN,aU,aR,aT){var aS,aV=[],aJ=2/aK,aL,aQ,aP,aO,aM;aL=Math.PI*(3-F(5)+(parseFloat(aT)?parseFloat(aT):0));for(aQ=0;aQ<aK;++aQ){aP=aQ*aJ-1+(aJ/2);aS=aQ*aL;aO=w(aS);aM=ah(aS);aV.push(aI?[aP*aN,aO*aU,aM*aR]:[aO*aN,aP*aU,aM*aR])}return aV}function N(aI,aJ,aM,aS,aQ,aO){var aR,aT=[],aK=Math.PI*2/aJ,aP,aN,aL;for(aP=0;aP<aJ;++aP){aR=aP*aK;aN=w(aR);aL=ah(aR);aT.push(aI?[aO*aM,aN*aS,aL*aQ]:[aN*aM,aO*aS,aL*aQ])}return aT}function am(aK,j,aI,aJ,i){return W(aK,0,j,aI,aJ,i)}function av(aK,j,aI,aJ,i){return W(aK,1,j,aI,aJ,i)}function d(aK,i,j,aI,aJ){aJ=isNaN(aJ)?0:aJ*1;return N(0,aK,i,j,aI,aJ)}function n(aK,i,j,aI,aJ){aJ=isNaN(aJ)?0:aJ*1;return N(1,aK,i,j,aI,aJ)}function ao(aI){var j=new Image;j.onload=function(){var aJ=j.width/2,i=j.height/2;aI.centreFunc=function(aO,aL,aM,aK,aN){aO.setTransform(1,0,0,1,0,0);aO.globalAlpha=1;aO.drawImage(j,aK-aJ,aN-i)}};j.src=aI.centreImage}function U(aL,i){var aK=aL,aJ,aI,j=(i*1).toPrecision(3)+\")\";if(aL[0]===\"#\"){if(!h[aL]){if(aL.length===4){h[aL]=\"rgba(\"+m[aL[1]]+m[aL[2]]+m[aL[3]]}else{h[aL]=\"rgba(\"+l[aL.substr(1,2)]+l[aL.substr(3,2)]+l[aL.substr(5,2)]}}aK=h[aL]+j}else{if(aL.substr(0,4)===\"rgb(\"||aL.substr(0,4)===\"hsl(\"){aK=(aL.replace(\"(\",\"a(\").replace(\")\",\",\"+j))}else{if(aL.substr(0,5)===\"rgba(\"||aL.substr(0,5)===\"hsla(\"){aJ=aL.lastIndexOf(\",\")+1,aI=aL.indexOf(\")\");i*=parseFloat(aL.substring(aJ,aI));aK=aL.substr(0,aJ)+i.toPrecision(3)+\")\"}}}return aK}function P(i,j){if(window.G_vmlCanvasManager){return null}var aI=C.createElement(\"canvas\");aI.width=i;aI.height=j;return aI}function al(){var j=P(3,3),aJ,aI;if(!j){return false}aJ=j.getContext(\"2d\");aJ.strokeStyle=\"#000\";aJ.shadowColor=\"#fff\";aJ.shadowBlur=3;aJ.globalAlpha=0;aJ.strokeRect(2,2,2,2);aJ.globalAlpha=1;aI=aJ.getImageData(2,2,1,1);j=null;return(aI.data[0]>0)}function ak(aM,j,aL,aK){var aJ=aM.createLinearGradient(0,0,j,0),aI;for(aI in aK){aJ.addColorStop(1-aI,aK[aI])}aM.fillStyle=aJ;aM.fillRect(0,aL,j,1)}function k(aK,aI,j){var aJ=1024,aO=1,aN=aK.weightGradient,aM,aQ,aL,aP;if(aK.gCanvas){aQ=aK.gCanvas.getContext(\"2d\");aO=aK.gCanvas.height}else{if(I(aN[0])){aO=aN.length}else{aN=[aN]}aK.gCanvas=aM=P(aJ,aO);if(!aM){return null}aQ=aM.getContext(\"2d\");for(aL=0;aL<aO;++aL){ak(aQ,aJ,aL,aN[aL])}}j=s(aE(j||0,aO-1),0);aP=aQ.getImageData(~~((aJ-1)*aI),j,1,1).data;return\"rgba(\"+aP[0]+\",\"+aP[1]+\",\"+aP[2]+\",\"+(aP[3]/255)+\")\"}function X(aR,aK,j,aV,aU,aS,aQ,aM,aJ,aT,aL,aP){var aO=aU+(aM||0)+(aJ.length&&aJ[0]<0?L(aJ[0]):0),aI=aS+(aM||0)+(aJ.length&&aJ[1]<0?L(aJ[1]):0),aN,aW;aR.font=aK;aR.textBaseline=\"top\";aR.fillStyle=j;aQ&&(aR.shadowColor=aQ);aM&&(aR.shadowBlur=aM);aJ.length&&(aR.shadowOffsetX=aJ[0],aR.shadowOffsetY=aJ[1]);for(aN=0;aN<aV.length;++aN){aW=0;if(aL){if(\"right\"==aP){aW=aT-aL[aN]}else{if(\"centre\"==aP){aW=(aT-aL[aN])/2}}}aR.fillText(aV[aN],aO+aW,aI);aI+=parseInt(aK)}}function at(aM,i,aL,j,aJ,aK,aI){if(aK){aM.beginPath();aM.moveTo(i,aL+aJ-aK);aM.arcTo(i,aL,i+aK,aL,aK);aM.arcTo(i+j,aL,i+j,aL+aK,aK);aM.arcTo(i+j,aL+aJ,i+j-aK,aL+aJ,aK);aM.arcTo(i,aL+aJ,i,aL+aJ-aK,aK);aM.closePath();aM[aI?\"stroke\":\"fill\"]()}else{aM[aI?\"strokeRect\":\"fillRect\"](i,aL,j,aJ)}}function g(aO,i,aM,aJ,aN,aI,aK,aL,j){this.strings=aO;this.font=i;this.width=aM;this.height=aJ;this.maxWidth=aN;this.stringWidths=aI;this.align=aK;this.valign=aL;this.scale=j}aa=g.prototype;aa.SetImage=function(aL,j,aJ,i,aK,aN,aI,aM){this.image=aL;this.iwidth=j*this.scale;this.iheight=aJ*this.scale;this.ipos=i;this.ipad=aK*this.scale;this.iscale=aM;this.ialign=aN;this.ivalign=aI};aa.Align=function(j,aI,i){var aJ=0;if(i==\"right\"||i==\"bottom\"){aJ=aI-j}else{if(i!=\"left\"&&i!=\"top\"){aJ=(aI-j)/2}}return aJ};aa.Create=function(aV,a1,aU,a2,a0,aZ,i,aY,aQ){var aO,aM,aW,a7,a4,a3,aK,aJ,aI,j,aN,aL,aP,aX,aT,a6=L(i[0]),a5=L(i[1]),aR,aS;aY=s(aY,a6+aZ,a5+aZ);a4=2*(aY+a2);aK=2*(aY+a2);aM=this.width+a4;aW=this.height+aK;aI=j=aY+a2;if(this.image){aN=aL=aY+a2;aP=this.iwidth;aX=this.iheight;if(this.ipos==\"top\"||this.ipos==\"bottom\"){if(aP<this.width){aN+=this.Align(aP,this.width,this.ialign)}else{aI+=this.Align(this.width,aP,this.align)}if(this.ipos==\"top\"){j+=aX+this.ipad}else{aL+=this.height+this.ipad}aM=s(aM,aP+a4);aW+=aX+this.ipad}else{if(aX<this.height){aL+=this.Align(aX,this.height,this.ivalign)}else{j+=this.Align(this.height,aX,this.valign)}if(this.ipos==\"right\"){aN+=this.width+this.ipad}else{aI+=aP+this.ipad}aM+=aP+this.ipad;aW=s(aW,aX+aK)}}aO=P(aM,aW);if(!aO){return null}a4=aK=a2/2;a3=aM-a2;aJ=aW-a2;aT=aE(aQ,a3/2,aJ/2);a7=aO.getContext(\"2d\");if(a1){a7.fillStyle=a1;at(a7,a4,aK,a3,aJ,aT)}if(a2){a7.strokeStyle=aU;a7.lineWidth=a2;at(a7,a4,aK,a3,aJ,aT,true)}if(aZ||a6||a5){aR=P(aM,aW);if(aR){aS=a7;a7=aR.getContext(\"2d\")}}X(a7,this.font,aV,this.strings,aI,j,0,0,[],this.maxWidth,this.stringWidths,this.align);if(this.image){a7.drawImage(this.image,aN,aL,aP,aX)}if(aS){a7=aS;a0&&(a7.shadowColor=a0);aZ&&(a7.shadowBlur=aZ);a7.shadowOffsetX=i[0];a7.shadowOffsetY=i[1];a7.drawImage(aR,0,0)}return aO};function v(aJ,j,aK){var aI=P(j,aK),aL;if(!aI){return null}aL=aI.getContext(\"2d\");aL.drawImage(aJ,(j-aJ.width)/2,(aK-aJ.height)/2);return aI}function ay(aJ,j,aK){var aI=P(j,aK),aL;if(!aI){return null}aL=aI.getContext(\"2d\");aL.drawImage(aJ,0,0,j,aK);return aI}function aD(aV,aQ,aW,a0,aR,aP,aN,aT,aL,aM){var aJ=aQ+((2*aT)+aP)*a0,aS=aW+((2*aT)+aP)*a0,aK=P(aJ,aS),aZ,aY,aI,aX,j,a1,aU,aO;if(!aK){return null}aP*=a0;aL*=a0;aY=aI=aP/2;aX=aJ-aP;j=aS-aP;aT=(aT*a0)+aY;aZ=aK.getContext(\"2d\");aO=aE(aL,aX/2,j/2);if(aR){aZ.fillStyle=aR;at(aZ,aY,aI,aX,j,aO)}if(aP){aZ.strokeStyle=aN;aZ.lineWidth=aP;at(aZ,aY,aI,aX,j,aO,true)}if(aM){a1=P(aJ,aS);aU=a1.getContext(\"2d\");aU.drawImage(aV,aT,aT,aQ,aW);aU.globalCompositeOperation=\"source-in\";aU.fillStyle=aN;aU.fillRect(0,0,aJ,aS);aU.globalCompositeOperation=\"destination-over\";aU.drawImage(aK,0,0);aU.globalCompositeOperation=\"source-over\";aZ.drawImage(a1,0,0)}else{aZ.drawImage(aV,aT,aT,aV.width,aV.height)}return{image:aK,width:aJ/a0,height:aS/a0}}function ar(aL,j,aK,aO,aP){var aM,aN,aI=parseFloat(j),aJ=s(aK,aO);aM=P(aK,aO);if(!aM){return null}if(j.indexOf(\"%\")>0){aI=aJ*aI/100}else{aI=aI*aP}aN=aM.getContext(\"2d\");aN.globalCompositeOperation=\"source-over\";aN.fillStyle=\"#fff\";if(aI>=aJ/2){aI=aE(aK,aO)/2;aN.beginPath();aN.moveTo(aK/2,aO/2);aN.arc(aK/2,aO/2,aI,0,2*Math.PI,false);aN.fill();aN.closePath()}else{aI=aE(aK/2,aO/2,aI);at(aN,0,0,aK,aO,aI,true);aN.fill()}aN.globalCompositeOperation=\"source-in\";aN.drawImage(aL,0,0,aK,aO);return aM}function Z(aO,aU,aQ,aK,aS,aT,aJ){var aV=L(aJ[0]),aP=L(aJ[1]),aL=aU+(aV>aT?aV+aT:aT*2)*aK,j=aQ+(aP>aT?aP+aT:aT*2)*aK,aN=aK*((aT||0)+(aJ[0]<0?aV:0)),aI=aK*((aT||0)+(aJ[1]<0?aP:0)),aM,aR;aM=P(aL,j);if(!aM){return null}aR=aM.getContext(\"2d\");aS&&(aR.shadowColor=aS);aT&&(aR.shadowBlur=aT*aK);aJ&&(aR.shadowOffsetX=aJ[0]*aK,aR.shadowOffsetY=aJ[1]*aK);aR.drawImage(aO,aN,aI,aU,aQ);return{image:aM,width:aL/aK,height:j/aK}}function t(aU,aM,aS){var aT=parseInt(aU.toString().length*aS),aL=parseInt(aS*2*aU.length),aJ=P(aT,aL),aP,j,aK,aO,aR,aQ,aI,aN;if(!aJ){return null}aP=aJ.getContext(\"2d\");aP.fillStyle=\"#000\";aP.fillRect(0,0,aT,aL);X(aP,aS+\"px \"+aM,\"#fff\",aU,0,0,0,0,[],\"centre\");j=aP.getImageData(0,0,aT,aL);aK=j.width;aO=j.height;aN={min:{x:aK,y:aO},max:{x:-1,y:-1}};for(aQ=0;aQ<aO;++aQ){for(aR=0;aR<aK;++aR){aI=(aQ*aK+aR)*4;if(j.data[aI+1]>0){if(aR<aN.min.x){aN.min.x=aR}if(aR>aN.max.x){aN.max.x=aR}if(aQ<aN.min.y){aN.min.y=aQ}if(aQ>aN.max.y){aN.max.y=aQ}}}}if(aK!=aT){aN.min.x*=(aT/aK);aN.max.x*=(aT/aK)}if(aO!=aL){aN.min.y*=(aT/aO);aN.max.y*=(aT/aO)}aJ=null;return aN}function o(i){return\"'\"+i.replace(/(\\'|\\\")/g,\"\").replace(/\\s*,\\s*/g,\"', '\")+\"'\"}function ad(i,j,aI){aI=aI||C;if(aI.addEventListener){aI.addEventListener(i,j,false)}else{aI.attachEvent(\"on\"+i,j)}}function a(i,j,aI){aI=aI||C;if(aI.removeEventListener){aI.removeEventListener(i,j)}else{aI.detachEvent(\"on\"+i,j)}}function ax(aM,aI,aQ,aL){var aR=aL.imageScale,aO,aJ,aN,j,aK,aP;if(!aI.complete){return ad(\"load\",function(){ax(aM,aI,aQ,aL)},aI)}if(!aM.complete){return ad(\"load\",function(){ax(aM,aI,aQ,aL)},aM)}aI.width=aI.width;aI.height=aI.height;if(aR){aM.width=aI.width*aR;aM.height=aI.height*aR}aQ.iw=aM.width;aQ.ih=aM.height;if(aL.txtOpt){aJ=aM;aO=aL.zoomMax*aL.txtScale;aK=aQ.iw*aO;aP=aQ.ih*aO;if(aK<aI.naturalWidth||aP<aI.naturalHeight){aJ=ay(aM,aK,aP);if(aJ){aQ.fimage=aJ}}else{aK=aQ.iw;aP=aQ.ih;aO=1}if(parseFloat(aL.imageRadius)){aQ.image=aQ.fimage=aM=ar(aQ.image,aL.imageRadius,aK,aP,aO)}if(!aQ.HasText()){if(aL.shadow){aJ=Z(aQ.image,aK,aP,aO,aL.shadow,aL.shadowBlur,aL.shadowOffset);if(aJ){aQ.fimage=aJ.image;aQ.w=aJ.width;aQ.h=aJ.height}}if(aL.bgColour||aL.bgOutlineThickness){aN=aL.bgColour==\"tag\"?Y(aQ.a,\"background-color\"):aL.bgColour;j=aL.bgOutline==\"tag\"?Y(aQ.a,\"color\"):(aL.bgOutline||aL.textColour);aK=aQ.fimage.width;aP=aQ.fimage.height;if(aL.outlineMethod==\"colour\"){aJ=aD(aQ.fimage,aK,aP,aO,aN,aL.bgOutlineThickness,aQ.outline.colour,aL.padding,aL.bgRadius,1);if(aJ){aQ.oimage=aJ.image}}aJ=aD(aQ.fimage,aK,aP,aO,aN,aL.bgOutlineThickness,j,aL.padding,aL.bgRadius);if(aJ){aQ.fimage=aJ.image;aQ.w=aJ.width;aQ.h=aJ.height}}if(aL.outlineMethod==\"size\"){if(aL.outlineIncrease>0){aQ.iw+=2*aL.outlineIncrease;aQ.ih+=2*aL.outlineIncrease;aK=aO*aQ.iw;aP=aO*aQ.ih;aJ=ay(aQ.fimage,aK,aP);aQ.oimage=aJ;aQ.fimage=v(aQ.fimage,aQ.oimage.width,aQ.oimage.height)}else{aK=aO*(aQ.iw+(2*aL.outlineIncrease));aP=aO*(aQ.ih+(2*aL.outlineIncrease));aJ=ay(aQ.fimage,aK,aP);aQ.oimage=v(aJ,aQ.fimage.width,aQ.fimage.height)}}}}aQ.Init()}function Y(aJ,aI){var j=C.defaultView,i=aI.replace(/\\-([a-z])/g,function(aK){return aK.charAt(1).toUpperCase()});return(j&&j.getComputedStyle&&j.getComputedStyle(aJ,null).getPropertyValue(aI))||(aJ.currentStyle&&aJ.currentStyle[i])}function u(j,aJ,aI){var i=1,aK;if(aJ){i=1*(j.getAttribute(aJ)||aI)}else{if(aK=Y(j,\"font-size\")){i=(aK.indexOf(\"px\")>-1&&aK.replace(\"px\",\"\")*1)||(aK.indexOf(\"pt\")>-1&&aK.replace(\"pt\",\"\")*1.25)||aK*3.3}}return i}function f(i){return i.target&&ai(i.target.id)?i.target.id:i.srcElement.parentNode.id}function S(aK,aL){var aJ,aI,i=parseInt(Y(aL,\"width\"))/aL.width,j=parseInt(Y(aL,\"height\"))/aL.height;if(ai(aK.offsetX)){aJ={x:aK.offsetX,y:aK.offsetY}}else{aI=ab(aL.id);if(ai(aK.changedTouches)){aK=aK.changedTouches[0]}if(aK.pageX){aJ={x:aK.pageX-aI.x,y:aK.pageY-aI.y}}}if(aJ&&i&&j){aJ.x/=i;aJ.y/=j}return aJ}function B(aI){var j=aI.target||aI.fromElement.parentNode,i=y.tc[j.id];if(i){i.mx=i.my=-1;i.UnFreeze();i.EndDrag()}}function af(aM){var aJ,aI=y,j,aL,aK=f(aM);for(aJ in aI.tc){j=aI.tc[aJ];if(j.tttimer){clearTimeout(j.tttimer);j.tttimer=null}}if(aK&&aI.tc[aK]){j=aI.tc[aK];if(aL=S(aM,j.canvas)){j.mx=aL.x;j.my=aL.y;j.Drag(aM,aL)}j.drawn=0}}function z(aJ){var j=y,i=C.addEventListener?0:1,aI=f(aJ);if(aI&&aJ.button==i&&j.tc[aI]){j.tc[aI].BeginDrag(aJ)}}function aF(aK){var aI=y,j=C.addEventListener?0:1,aJ=f(aK),i;if(aJ&&aK.button==j&&aI.tc[aJ]){i=aI.tc[aJ];af(aK);if(!i.EndDrag()&&!i.touchState){i.Clicked(aK)}}}function T(aJ){var j=f(aJ),i=(j&&y.tc[j]),aI;if(i&&aJ.changedTouches){if(aJ.touches.length==1&&i.touchState==0){i.touchState=1;i.BeginDrag(aJ);if(aI=S(aJ,i.canvas)){i.mx=aI.x;i.my=aI.y;i.drawn=0}}else{if(aJ.targetTouches.length==2&&i.pinchZoom){i.touchState=3;i.EndDrag();i.BeginPinch(aJ)}else{i.EndDrag();i.EndPinch();i.touchState=0}}}}function r(aI){var j=f(aI),i=(j&&y.tc[j]);if(i&&aI.changedTouches){switch(i.touchState){case 1:i.Draw();i.Clicked();break;case 2:i.EndDrag();break;case 3:i.EndPinch()}i.touchState=0}}function aA(aM){var aJ,aI=y,j,aL,aK=f(aM);for(aJ in aI.tc){j=aI.tc[aJ];if(j.tttimer){clearTimeout(j.tttimer);j.tttimer=null}}j=(aK&&aI.tc[aK]);if(j&&aM.changedTouches&&j.touchState){switch(j.touchState){case 1:case 2:if(aL=S(aM,j.canvas)){j.mx=aL.x;j.my=aL.y;if(j.Drag(aM,aL)){j.touchState=2}}break;case 3:j.Pinch(aM)}j.drawn=0}}function ag(aI){var i=y,j=f(aI);if(j&&i.tc[j]){aI.cancelBubble=true;aI.returnValue=false;aI.preventDefault&&aI.preventDefault();i.tc[j].Wheel((aI.wheelDelta||aI.detail)>0)}}function ac(aJ){var aI,j=y;clearTimeout(j.scrollTimer);for(aI in j.tc){j.tc[aI].Pause()}j.scrollTimer=setTimeout(function(){var aL,aK=y;for(aL in aK.tc){aK.tc[aL].Resume()}},j.scrollPause)}function O(){E(G())}function E(aJ){var j=y.tc,aI;y.NextFrame(y.interval);aJ=aJ||G();for(aI in j){j[aI].Draw(aJ)}}function ab(aI){var aL=C.getElementById(aI),i=aL.getBoundingClientRect(),aO=C.documentElement,aM=C.body,aN=window,aJ=aN.pageXOffset||aO.scrollLeft,aP=aN.pageYOffset||aO.scrollTop,aK=aO.clientLeft||aM.clientLeft,j=aO.clientTop||aM.clientTop;return{x:i.left+aJ-aK,y:i.top+aP-j}}function V(j,aJ,aK,aI){var i=j.radius*j.z1/(j.z1+j.z2+aJ.z);return{x:aJ.x*i*aK,y:aJ.y*i*aI,z:aJ.z,w:(j.z1-aJ.z)/j.z2}}function aC(i){this.e=i;this.br=0;this.line=[];this.text=[];this.original=i.innerText||i.textContent}aH=aC.prototype;aH.Empty=function(){for(var j=0;j<this.text.length;++j){if(this.text[j].length){return false}}return true};aH.Lines=function(aK){var aJ=aK?1:0,aL,j,aI;aK=aK||this.e;aL=aK.childNodes;j=aL.length;for(aI=0;aI<j;++aI){if(aL[aI].nodeName==\"BR\"){this.text.push(this.line.join(\" \"));this.br=1}else{if(aL[aI].nodeType==3){if(this.br){this.line=[aL[aI].nodeValue];this.br=0}else{this.line.push(aL[aI].nodeValue)}}else{this.Lines(aL[aI])}}}aJ||this.br||this.text.push(this.line.join(\" \"));return this.text};aH.SplitWidth=function(aI,aP,aM,aL){var aK,aJ,aO,aN=[];aP.font=aL+\"px \"+aM;for(aK=0;aK<this.text.length;++aK){aO=this.text[aK].split(/\\s+/);this.line=[aO[0]];for(aJ=1;aJ<aO.length;++aJ){if(aP.measureText(this.line.join(\" \")+\" \"+aO[aJ]).width>aI){aN.push(this.line.join(\" \"));this.line=[aO[aJ]]}else{this.line.push(aO[aJ])}}aN.push(this.line.join(\" \"))}return this.text=aN};function J(i,j){this.ts=null;this.tc=i;this.tag=j;this.x=this.y=this.w=this.h=this.sc=1;this.z=0;this.pulse=1;this.pulsate=i.pulsateTo<1;this.colour=i.outlineColour;this.adash=~~i.outlineDash;this.agap=~~i.outlineDashSpace||this.adash;this.aspeed=i.outlineDashSpeed*1;if(this.colour==\"tag\"){this.colour=Y(j.a,\"color\")}else{if(this.colour==\"tagbg\"){this.colour=Y(j.a,\"background-color\")}}this.Draw=this.pulsate?this.DrawPulsate:this.DrawSimple;this.radius=i.outlineRadius|0;this.SetMethod(i.outlineMethod)}x=J.prototype;x.SetMethod=function(aI){var j={block:[\"PreDraw\",\"DrawBlock\"],colour:[\"PreDraw\",\"DrawColour\"],outline:[\"PostDraw\",\"DrawOutline\"],classic:[\"LastDraw\",\"DrawOutline\"],size:[\"PreDraw\",\"DrawSize\"],none:[\"LastDraw\"]},i=j[aI]||j.outline;if(aI==\"none\"){this.Draw=function(){return 1}}else{this.drawFunc=this[i[1]]}this[i[0]]=this.Draw};x.Update=function(aO,aN,aP,aK,aL,aM,aJ,i){var j=this.tc.outlineOffset,aI=2*j;this.x=aL*aO+aJ-j;this.y=aL*aN+i-j;this.w=aL*aP+aI;this.h=aL*aK+aI;this.sc=aL;this.z=aM};x.Ants=function(aN){if(!this.adash){return}var aK=this.adash,aM=this.agap,aQ=this.aspeed,j=aK+aM,aL=0,aJ=aK,i=aM,aP=0,aO=0,aI;if(aQ){aO=L(aQ)*(G()-this.ts)/50;if(aQ<0){aO=8640000-aO}aQ=~~aO%j}if(aQ){if(aK>=aQ){aL=aK-aQ;aJ=aQ}else{i=j-aQ;aP=aM-i}aI=[aL,i,aJ,aP]}else{aI=[aK,aM]}aN.setLineDash(aI)};x.DrawOutline=function(aM,i,aL,j,aI,aK){var aJ=aE(this.radius,aI/2,j/2);aM.strokeStyle=aK;this.Ants(aM);at(aM,i,aL,j,aI,aJ,true)};x.DrawSize=function(aP,aS,aQ,aT,aN,j,aU,aJ,aR){var aM=aU.w,aI=aU.h,aK,aL,aO;if(this.pulsate){if(aU.image){aO=(aU.image.height+this.tc.outlineIncrease)/aU.image.height}else{aO=aU.oscale}aL=aU.fimage||aU.image;aK=1+((aO-1)*(1-this.pulse));aU.h*=aK;aU.w*=aK}else{aL=aU.oimage}aU.alpha=1;aU.Draw(aP,aJ,aR,aL);aU.h=aI;aU.w=aM;return 1};x.DrawColour=function(aJ,aM,aK,aN,aI,i,aO,j,aL){if(aO.oimage){if(this.pulse<1){aO.alpha=1-au(this.pulse,2);aO.Draw(aJ,j,aL,aO.fimage);aO.alpha=this.pulse}else{aO.alpha=1}aO.Draw(aJ,j,aL,aO.oimage);return 1}return this[aO.image?\"DrawColourImage\":\"DrawColourText\"](aJ,aM,aK,aN,aI,i,aO,j,aL)};x.DrawColourText=function(aK,aN,aL,aO,aI,i,aP,j,aM){var aJ=aP.colour;aP.colour=i;aP.alpha=1;aP.Draw(aK,j,aM);aP.colour=aJ;return 1};x.DrawColourImage=function(aN,aQ,aO,aR,aM,i,aU,j,aP){var aS=aN.canvas,aK=~~s(aQ,0),aJ=~~s(aO,0),aL=aE(aS.width-aK,aR)+0.5|0,aT=aE(aS.height-aJ,aM)+0.5|0,aI;if(p){p.width=aL,p.height=aT}else{p=P(aL,aT)}if(!p){return this.SetMethod(\"outline\")}aI=p.getContext(\"2d\");aI.drawImage(aS,aK,aJ,aL,aT,0,0,aL,aT);aN.clearRect(aK,aJ,aL,aT);if(this.pulsate){aU.alpha=1-au(this.pulse,2)}else{aU.alpha=1}aU.Draw(aN,j,aP);aN.setTransform(1,0,0,1,0,0);aN.save();aN.beginPath();aN.rect(aK,aJ,aL,aT);aN.clip();aN.globalCompositeOperation=\"source-in\";aN.fillStyle=i;aN.fillRect(aK,aJ,aL,aT);aN.restore();aN.globalAlpha=1;aN.globalCompositeOperation=\"destination-over\";aN.drawImage(p,0,0,aL,aT,aK,aJ,aL,aT);aN.globalCompositeOperation=\"source-over\";return 1};x.DrawBlock=function(aM,i,aL,j,aI,aK){var aJ=aE(this.radius,aI/2,j/2);aM.fillStyle=aK;at(aM,i,aL,j,aI,aJ)};x.DrawSimple=function(aM,i,j,aJ,aL,aK){var aI=this.tc;aM.setTransform(1,0,0,1,0,0);aM.strokeStyle=this.colour;aM.lineWidth=aI.outlineThickness;aM.shadowBlur=aM.shadowOffsetX=aM.shadowOffsetY=0;aM.globalAlpha=aK?aL:1;return this.drawFunc(aM,this.x,this.y,this.w,this.h,this.colour,i,j,aJ)};x.DrawPulsate=function(aM,i,j,aJ){var aK=G()-this.ts,aI=this.tc,aL=aI.pulsateTo+((1-aI.pulsateTo)*(0.5+(w(2*Math.PI*aK/(1000*aI.pulsateTime))/2)));this.pulse=aL=y.Smooth(1,aL);return this.DrawSimple(aM,i,j,aJ,aL,1)};x.Active=function(aJ,i,aI){var j=(i>=this.x&&aI>=this.y&&i<=this.x+this.w&&aI<=this.y+this.h);if(j){this.ts=this.ts||G()}else{this.ts=null}return j};x.PreDraw=x.PostDraw=x.LastDraw=aB;function e(aJ,aT,aP,aS,aQ,aK,aI,aM,aR,aL,aO,j,aN,i){this.tc=aJ;this.image=null;this.text=aT;this.text_original=i;this.line_widths=[];this.title=aP.title||null;this.a=aP;this.position=new ae(aS[0],aS[1],aS[2]);this.x=this.y=this.z=0;this.w=aQ;this.h=aK;this.colour=aI||aJ.textColour;this.bgColour=aM||aJ.bgColour;this.bgRadius=aR|0;this.bgOutline=aL||this.colour;this.bgOutlineThickness=aO|0;this.textFont=j||aJ.textFont;this.padding=aN|0;this.sc=this.alpha=1;this.weighted=!aJ.weight;this.outline=new J(aJ,this)}c=e.prototype;c.Init=function(j){var i=this.tc;this.textHeight=i.textHeight;if(this.HasText()){this.Measure(i.ctxt,i)}else{this.w=this.iw;this.h=this.ih}this.SetShadowColour=i.shadowAlpha?this.SetShadowColourAlpha:this.SetShadowColourFixed;this.SetDraw(i)};c.Draw=aB;c.HasText=function(){return this.text&&this.text[0].length>0};c.EqualTo=function(aI){var j=aI.getElementsByTagName(\"img\");if(this.a.href!=aI.href){return 0}if(j.length){return this.image.src==j[0].src}return(aI.innerText||aI.textContent)==this.text_original};c.SetImage=function(j){this.image=this.fimage=j};c.SetDraw=function(i){this.Draw=this.fimage?(i.ie>7?this.DrawImageIE:this.DrawImage):this.DrawText;i.noSelect&&(this.CheckActive=aB)};c.MeasureText=function(aL){var aJ,aI=this.text.length,j=0,aK;for(aJ=0;aJ<aI;++aJ){this.line_widths[aJ]=aK=aL.measureText(this.text[aJ]).width;j=s(j,aK)}return j};c.Measure=function(aN,aQ){var aO=t(this.text,this.textFont,this.textHeight),aR,i,aK,j,aI,aM,aP,aJ,aL;aP=aO?aO.max.y+aO.min.y:this.textHeight;aN.font=this.font=this.textHeight+\"px \"+this.textFont;aM=this.MeasureText(aN);if(aQ.txtOpt){aR=aQ.txtScale;i=aR*this.textHeight;aK=i+\"px \"+this.textFont;j=[aR*aQ.shadowOffset[0],aR*aQ.shadowOffset[1]];aN.font=aK;aI=this.MeasureText(aN);aL=new g(this.text,aK,aI+aR,(aR*aP)+aR,aI,this.line_widths,aQ.textAlign,aQ.textVAlign,aR);if(this.image){aL.SetImage(this.image,this.iw,this.ih,aQ.imagePosition,aQ.imagePadding,aQ.imageAlign,aQ.imageVAlign,aQ.imageScale)}aJ=aL.Create(this.colour,this.bgColour,this.bgOutline,aR*this.bgOutlineThickness,aQ.shadow,aR*aQ.shadowBlur,j,aR*this.padding,aR*this.bgRadius);if(aQ.outlineMethod==\"colour\"){this.oimage=aL.Create(this.outline.colour,this.bgColour,this.outline.colour,aR*this.bgOutlineThickness,aQ.shadow,aR*aQ.shadowBlur,j,aR*this.padding,aR*this.bgRadius)}else{if(aQ.outlineMethod==\"size\"){aO=t(this.text,this.textFont,this.textHeight+aQ.outlineIncrease);i=aO.max.y+aO.min.y;aK=(aR*(this.textHeight+aQ.outlineIncrease))+\"px \"+this.textFont;aN.font=aK;aI=this.MeasureText(aN);aL=new g(this.text,aK,aI+aR,(aR*i)+aR,aI,this.line_widths,aQ.textAlign,aQ.textVAlign,aR);if(this.image){aL.SetImage(this.image,this.iw+aQ.outlineIncrease,this.ih+aQ.outlineIncrease,aQ.imagePosition,aQ.imagePadding,aQ.imageAlign,aQ.imageVAlign,aQ.imageScale)}this.oimage=aL.Create(this.colour,this.bgColour,this.bgOutline,aR*this.bgOutlineThickness,aQ.shadow,aR*aQ.shadowBlur,j,aR*this.padding,aR*this.bgRadius);this.oscale=this.oimage.width/aJ.width;if(aQ.outlineIncrease>0){aJ=v(aJ,this.oimage.width,this.oimage.height)}else{this.oimage=v(this.oimage,aJ.width,aJ.height)}}}if(aJ){this.fimage=aJ;aM=this.fimage.width/aR;aP=this.fimage.height/aR}this.SetDraw(aQ);aQ.txtOpt=!!this.fimage}this.h=aP;this.w=aM};c.SetFont=function(j,aJ,aI,i){this.textFont=j;this.colour=aJ;this.bgColour=aI;this.bgOutline=i;this.Measure(this.tc.ctxt,this.tc)};c.SetWeight=function(aI){var j=this.tc,aK=j.weightMode.split(/[, ]/),i,aJ,aL=aI.length;if(!this.HasText()){return}this.weighted=true;for(aJ=0;aJ<aL;++aJ){i=aK[aJ]||\"size\";if(\"both\"==i){this.Weight(aI[aJ],j.ctxt,j,\"size\",j.min_weight[aJ],j.max_weight[aJ],aJ);this.Weight(aI[aJ],j.ctxt,j,\"colour\",j.min_weight[aJ],j.max_weight[aJ],aJ)}else{this.Weight(aI[aJ],j.ctxt,j,i,j.min_weight[aJ],j.max_weight[aJ],aJ)}}this.Measure(j.ctxt,j)};c.Weight=function(aI,aN,aJ,j,aM,aK,aL){aI=isNaN(aI)?1:aI;var i=(aI-aM)/(aK-aM);if(\"colour\"==j){this.colour=k(aJ,i,aL)}else{if(\"bgcolour\"==j){this.bgColour=k(aJ,i,aL)}else{if(\"bgoutline\"==j){this.bgOutline=k(aJ,i,aL)}else{if(\"outline\"==j){this.outline.colour=k(aJ,i,aL)}else{if(\"size\"==j){if(aJ.weightSizeMin>0&&aJ.weightSizeMax>aJ.weightSizeMin){this.textHeight=aJ.weightSize*(aJ.weightSizeMin+(aJ.weightSizeMax-aJ.weightSizeMin)*i)}else{this.textHeight=s(1,aI*aJ.weightSize)}}}}}}};c.SetShadowColourFixed=function(aI,j,i){aI.shadowColor=j};c.SetShadowColourAlpha=function(aI,j,i){aI.shadowColor=U(j,i)};c.DrawText=function(aK,aN,aJ){var aO=this.tc,aM=this.x,aL=this.y,aP=this.sc,j,aI;aK.globalAlpha=this.alpha;aK.fillStyle=this.colour;aO.shadow&&this.SetShadowColour(aK,aO.shadow,this.alpha);aK.font=this.font;aM+=aN/aP;aL+=(aJ/aP)-(this.h/2);for(j=0;j<this.text.length;++j){aI=aM;if(\"right\"==aO.textAlign){aI+=this.w/2-this.line_widths[j]}else{if(\"centre\"==aO.textAlign){aI-=this.line_widths[j]/2}else{aI-=this.w/2}}aK.setTransform(aP,0,0,aP,aP*aI,aP*aL);aK.fillText(this.text[j],0,0);aL+=this.textHeight}};c.DrawImage=function(aK,aR,aJ,aM){var aO=this.x,aL=this.y,aS=this.sc,j=aM||this.fimage,aP=this.w,aI=this.h,aN=this.alpha,aQ=this.shadow;aK.globalAlpha=aN;aQ&&this.SetShadowColour(aK,aQ,aN);aO+=(aR/aS)-(aP/2);aL+=(aJ/aS)-(aI/2);aK.setTransform(aS,0,0,aS,aS*aO,aS*aL);aK.drawImage(j,0,0,aP,aI)};c.DrawImageIE=function(aK,aO,aJ){var j=this.fimage,aP=this.sc,aN=j.width=this.w*aP,aI=j.height=this.h*aP,aM=(this.x*aP)+aO-(aN/2),aL=(this.y*aP)+aJ-(aI/2);aK.setTransform(1,0,0,1,0,0);aK.globalAlpha=this.alpha;aK.drawImage(j,aM,aL)};c.Calc=function(i,aI){var j,aL=this.tc,aK=aL.minBrightness,aJ=aL.maxBrightness,aM=aL.max_radius;j=i.xform(this.position);this.xformed=j;j=V(aL,j,aL.stretchX,aL.stretchY);this.x=j.x;this.y=j.y;this.z=j.z;this.sc=j.w;this.alpha=aI*aw(aK+(aJ-aK)*(aM-this.z)/(2*aM),0,1);return this.xformed};c.UpdateActive=function(aN,aI,aL){var aK=this.outline,j=this.w,aJ=this.h,i=this.x-j/2,aM=this.y-aJ/2;aK.Update(i,aM,j,aJ,this.sc,this.z,aI,aL);return aK};c.CheckActive=function(aK,i,aJ){var j=this.tc,aI=this.UpdateActive(aK,i,aJ);return aI.Active(aK,j.mx,j.my)?aI:null};c.Clicked=function(aL){var j=this.a,aI=j.target,aJ=j.href,i;if(aI!=\"\"&&aI!=\"_self\"){if(self.frames[aI]){self.frames[aI].document.location=aJ}else{try{if(top.frames[aI]){top.frames[aI].document.location=aJ;return}}catch(aK){}window.open(aJ,aI)}return}if(C.createEvent){i=C.createEvent(\"MouseEvents\");i.initMouseEvent(\"click\",1,1,window,0,0,0,0,0,0,0,0,0,0,null);if(!j.dispatchEvent(i)){return}}else{if(j.fireEvent){if(!j.fireEvent(\"onclick\")){return}}}C.location=aJ};function y(aO,j,aJ){var aI,aL,aN=C.getElementById(aO),aK=[\"id\",\"class\",\"innerHTML\"],aM;if(!aN){throw 0}if(ai(window.G_vmlCanvasManager)){aN=window.G_vmlCanvasManager.initElement(aN);this.ie=parseFloat(navigator.appVersion.split(\"MSIE\")[1])}if(aN&&(!aN.getContext||!aN.getContext(\"2d\").fillText)){aL=C.createElement(\"DIV\");for(aI=0;aI<aK.length;++aI){aL[aK[aI]]=aN[aK[aI]]}aN.parentNode.insertBefore(aL,aN);aN.parentNode.removeChild(aN);throw 0}for(aI in y.options){this[aI]=aJ&&ai(aJ[aI])?aJ[aI]:(ai(y[aI])?y[aI]:y.options[aI])}this.canvas=aN;this.ctxt=aN.getContext(\"2d\");this.z1=250/s(this.depth,0.001);this.z2=this.z1/this.zoom;this.radius=aE(aN.height,aN.width)*0.0075;this.max_radius=100;this.max_weight=[];this.min_weight=[];this.textFont=this.textFont&&o(this.textFont);this.textHeight*=1;this.imageRadius=this.imageRadius.toString();this.pulsateTo=aw(this.pulsateTo,0,1);this.minBrightness=aw(this.minBrightness,0,1);this.maxBrightness=aw(this.maxBrightness,this.minBrightness,1);this.ctxt.textBaseline=\"top\";this.lx=(this.lock+\"\").indexOf(\"x\")+1;this.ly=(this.lock+\"\").indexOf(\"y\")+1;this.frozen=this.dx=this.dy=this.fixedAnim=this.touchState=0;this.fixedAlpha=1;this.source=j||aO;this.repeatTags=aE(64,~~this.repeatTags);this.minTags=aE(200,~~this.minTags);if(~~this.scrollPause>0){y.scrollPause=~~this.scrollPause}else{this.scrollPause=0}if(this.minTags>0&&this.repeatTags<1&&(aI=this.GetTags().length)){this.repeatTags=aq(this.minTags/aI)-1}this.transform=R.Identity();this.startTime=this.time=G();this.mx=this.my=-1;this.centreImage&&ao(this);this.Animate=this.dragControl?this.AnimateDrag:this.AnimatePosition;this.animTiming=(typeof y[this.animTiming]==\"function\"?y[this.animTiming]:y.Smooth);if(this.shadowBlur||this.shadowOffset[0]||this.shadowOffset[1]){this.ctxt.shadowColor=this.shadow;this.shadow=this.ctxt.shadowColor;this.shadowAlpha=al()}else{delete this.shadow}this.Load();if(j&&this.hideTags){(function(i){if(y.loaded){i.HideTags()}else{ad(\"load\",function(){i.HideTags()},window)}})(this)}this.yaw=this.initial?this.initial[0]*this.maxSpeed:0;this.pitch=this.initial?this.initial[1]*this.maxSpeed:0;if(this.tooltip){this.ctitle=aN.title;aN.title=\"\";if(this.tooltip==\"native\"){this.Tooltip=this.TooltipNative}else{this.Tooltip=this.TooltipDiv;if(!this.ttdiv){this.ttdiv=C.createElement(\"div\");this.ttdiv.className=this.tooltipClass;this.ttdiv.style.position=\"absolute\";this.ttdiv.style.zIndex=aN.style.zIndex+1;ad(\"mouseover\",function(i){i.target.style.display=\"none\"},this.ttdiv);C.body.appendChild(this.ttdiv)}}}else{this.Tooltip=this.TooltipNone}if(!this.noMouse&&!b[aO]){b[aO]=[[\"mousemove\",af],[\"mouseout\",B],[\"mouseup\",aF],[\"touchstart\",T],[\"touchend\",r],[\"touchcancel\",r],[\"touchmove\",aA]];if(this.dragControl){b[aO].push([\"mousedown\",z]);b[aO].push([\"selectstart\",aB])}if(this.wheelZoom){b[aO].push([\"mousewheel\",ag]);b[aO].push([\"DOMMouseScroll\",ag])}if(this.scrollPause){b[aO].push([\"scroll\",ac,window])}for(aI=0;aI<b[aO].length;++aI){aL=b[aO][aI];ad(aL[0],aL[1],aL[2]?aL[2]:aN)}}if(!y.started){aM=window.requestAnimationFrame=window.requestAnimationFrame||window.mozRequestAnimationFrame||window.webkitRequestAnimationFrame||window.msRequestAnimationFrame;y.NextFrame=aM?y.NextFrameRAF:y.NextFrameTimeout;y.interval=this.interval;y.NextFrame(this.interval);y.started=1}}Q=y.prototype;Q.SourceElements=function(){if(C.querySelectorAll){return C.querySelectorAll(\"#\"+this.source)}return[C.getElementById(this.source)]};Q.HideTags=function(){var aI=this.SourceElements(),j;for(j=0;j<aI.length;++j){aI[j].style.display=\"none\"}};Q.GetTags=function(){var aN=this.SourceElements(),aM,aJ=[],aL,aK,aI;for(aI=0;aI<=this.repeatTags;++aI){for(aL=0;aL<aN.length;++aL){aM=aN[aL].getElementsByTagName(\"a\");for(aK=0;aK<aM.length;++aK){aJ.push(aM[aK])}}}return aJ};Q.Message=function(aN){var aP=[],aJ,j,aI=aN.split(\"\"),aL,aO,aM,aK;for(aJ=0;aJ<aI.length;++aJ){if(aI[aJ]!=\" \"){j=aJ-aI.length/2;aL=C.createElement(\"A\");aL.href=\"#\";aL.innerText=aI[aJ];aM=100*ah(j/9);aK=-100*w(j/9);aO=new e(this,aI[aJ],aL,[aM,0,aK],2,18,\"#000\",\"#fff\",0,0,0,\"monospace\",2,aI[aJ]);aO.Init();aP.push(aO)}}return aP};Q.CreateTag=function(aM){var aP,aK,aQ,aL,aO,aI,aN,aJ,j=[0,0,0];if(\"text\"!=this.imageMode){aP=aM.getElementsByTagName(\"img\");if(aP.length){aK=new Image;aK.src=aP[0].src;if(!this.imageMode){aQ=new e(this,\"\",aM,j,0,0);aQ.SetImage(aK);ax(aK,aP[0],aQ,this);return aQ}}}if(\"image\"!=this.imageMode){aO=new aC(aM);aL=aO.Lines();if(!aO.Empty()){aI=this.textFont||o(Y(aM,\"font-family\"));if(this.splitWidth){aL=aO.SplitWidth(this.splitWidth,this.ctxt,aI,this.textHeight)}aN=this.bgColour==\"tag\"?Y(aM,\"background-color\"):this.bgColour;aJ=this.bgOutline==\"tag\"?Y(aM,\"color\"):this.bgOutline}else{aO=null}}if(aO||aK){aQ=new e(this,aL,aM,j,2,this.textHeight+2,this.textColour||Y(aM,\"color\"),aN,this.bgRadius,aJ,this.bgOutlineThickness,aI,this.padding,aO&&aO.original);if(aK){aQ.SetImage(aK);ax(aK,aP[0],aQ,this)}else{aQ.Init()}return aQ}};Q.UpdateTag=function(aI,i){var aL=this.textColour||Y(i,\"color\"),j=this.textFont||o(Y(i,\"font-family\")),aK=this.bgColour==\"tag\"?Y(i,\"background-color\"):this.bgColour,aJ=this.bgOutline==\"tag\"?Y(i,\"color\"):this.bgOutline;aI.a=i;aI.title=i.title;if(aI.colour!=aL||aI.textFont!=j||aI.bgColour!=aK||aI.bgOutline!=aJ){aI.SetFont(j,aL,aK,aJ)}};Q.Weight=function(aO){var aK=aO.length,aM,aI,aP,aL=[],j,aJ=this.weightFrom?this.weightFrom.split(/[, ]/):[null],aN=aJ.length;for(aI=0;aI<aK;++aI){aL[aI]=[];for(aP=0;aP<aN;++aP){aM=u(aO[aI].a,aJ[aP],this.textHeight);if(!this.max_weight[aP]||aM>this.max_weight[aP]){this.max_weight[aP]=aM}if(!this.min_weight[aP]||aM<this.min_weight[aP]){this.min_weight[aP]=aM}aL[aI][aP]=aM}}for(aP=0;aP<aN;++aP){if(this.max_weight[aP]>this.min_weight[aP]){j=1}}if(j){for(aI=0;aI<aK;++aI){aO[aI].SetWeight(aL[aI])}}};Q.Load=function(){var aS=this.GetTags(),aN=[],aQ,aR,aM,aJ,aI,j,aK,aP,aL=[],aO={sphere:q,vcylinder:am,hcylinder:av,vring:d,hring:n};if(aS.length){aL.length=aS.length;for(aP=0;aP<aS.length;++aP){aL[aP]=aP}this.shuffleTags&&an(aL);aJ=100*this.radiusX;aI=100*this.radiusY;j=100*this.radiusZ;this.max_radius=s(aJ,s(aI,j));for(aP=0;aP<aS.length;++aP){aR=this.CreateTag(aS[aL[aP]]);if(aR){aN.push(aR)}}this.weight&&this.Weight(aN,true);if(this.shapeArgs){this.shapeArgs[0]=aN.length}else{aM=this.shape.toString().split(/[(),]/);aQ=aM.shift();if(typeof window[aQ]===\"function\"){this.shape=window[aQ]}else{this.shape=aO[aQ]||aO.sphere}this.shapeArgs=[aN.length,aJ,aI,j].concat(aM)}aK=this.shape.apply(this,this.shapeArgs);this.listLength=aN.length;for(aP=0;aP<aN.length;++aP){aN[aP].position=new ae(aK[aP][0],aK[aP][1],aK[aP][2])}}if(this.noTagsMessage&&!aN.length){aP=(this.imageMode&&this.imageMode!=\"both\"?this.imageMode+\" \":\"\");aN=this.Message(\"No \"+aP+\"tags\")}this.taglist=aN};Q.Update=function(){var aR=this.GetTags(),aQ=[],aL=this.taglist,aS,aP=[],aN=[],aJ,aO,aI,aM,aK;if(!this.shapeArgs){return this.Load()}if(aR.length){aI=this.listLength=aR.length;aO=aL.length;for(aM=0;aM<aO;++aM){aQ.push(aL[aM]);aN.push(aM)}for(aM=0;aM<aI;++aM){for(aK=0,aS=0;aK<aO;++aK){if(aL[aK].EqualTo(aR[aM])){this.UpdateTag(aQ[aK],aR[aM]);aS=aN[aK]=-1}}if(!aS){aP.push(aM)}}for(aM=0,aK=0;aM<aO;++aM){if(aN[aK]==-1){aN.splice(aK,1)}else{++aK}}if(aN.length){an(aN);while(aN.length&&aP.length){aM=aN.shift();aK=aP.shift();aQ[aM]=this.CreateTag(aR[aK])}aN.sort(function(j,i){return j-i});while(aN.length){aQ.splice(aN.pop(),1)}}aK=aQ.length/(aP.length+1);aM=0;while(aP.length){aQ.splice(aq(++aM*aK),0,this.CreateTag(aR[aP.shift()]))}this.shapeArgs[0]=aI=aQ.length;aJ=this.shape.apply(this,this.shapeArgs);for(aM=0;aM<aI;++aM){aQ[aM].position=new ae(aJ[aM][0],aJ[aM][1],aJ[aM][2])}this.weight&&this.Weight(aQ)}this.taglist=aQ};Q.SetShadow=function(i){i.shadowBlur=this.shadowBlur;i.shadowOffsetX=this.shadowOffset[0];i.shadowOffsetY=this.shadowOffset[1]};Q.Draw=function(aS){if(this.paused){return}var aM=this.canvas,aK=aM.width,aR=aM.height,aU=0,aJ=(aS-this.time)*y.interval/1000,aQ=aK/2+this.offsetX,aP=aR/2+this.offsetY,aY=this.ctxt,aO,aZ,aW,aI=-1,aL=this.taglist,aV=aL.length,j=this.frontSelect,aT=(this.centreFunc==aB),aN;this.time=aS;if(this.frozen&&this.drawn){return this.Animate(aK,aR,aJ)}aN=this.AnimateFixed();aY.setTransform(1,0,0,1,0,0);for(aW=0;aW<aV;++aW){aL[aW].Calc(this.transform,this.fixedAlpha)}aL=A(aL,function(a0,i){return i.z-a0.z});if(aN&&this.fixedAnim.active){aO=this.fixedAnim.tag.UpdateActive(aY,aQ,aP)}else{this.active=null;for(aW=0;aW<aV;++aW){aZ=this.mx>=0&&this.my>=0&&this.taglist[aW].CheckActive(aY,aQ,aP);if(aZ&&aZ.sc>aU&&(!j||aZ.z<=0)){aO=aZ;aI=aW;aO.tag=this.taglist[aW];aU=aZ.sc}}this.active=aO}this.txtOpt||(this.shadow&&this.SetShadow(aY));aY.clearRect(0,0,aK,aR);for(aW=0;aW<aV;++aW){if(!aT&&aL[aW].z<=0){try{this.centreFunc(aY,aK,aR,aQ,aP)}catch(aX){alert(aX);this.centreFunc=aB}aT=true}if(!(aO&&aO.tag==aL[aW]&&aO.PreDraw(aY,aL[aW],aQ,aP))){aL[aW].Draw(aY,aQ,aP)}aO&&aO.tag==aL[aW]&&aO.PostDraw(aY)}if(this.freezeActive&&aO){this.Freeze()}else{this.UnFreeze();this.drawn=(aV==this.listLength)}if(this.fixedCallback){this.fixedCallback(this,this.fixedCallbackTag);this.fixedCallback=null}aN||this.Animate(aK,aR,aJ);aO&&aO.LastDraw(aY);aM.style.cursor=aO?this.activeCursor:\"\";this.Tooltip(aO,this.taglist[aI])};Q.TooltipNone=function(){};Q.TooltipNative=function(j,i){if(j){this.canvas.title=i&&i.title?i.title:\"\"}else{this.canvas.title=this.ctitle}};Q.SetTTDiv=function(aJ,j){var i=this,aI=i.ttdiv.style;if(aJ!=i.ttdiv.innerHTML){aI.display=\"none\"}i.ttdiv.innerHTML=aJ;j&&(j.title=i.ttdiv.innerHTML);if(aI.display==\"none\"&&!i.tttimer){i.tttimer=setTimeout(function(){var aK=ab(i.canvas.id);aI.display=\"block\";aI.left=aK.x+i.mx+\"px\";aI.top=aK.y+i.my+24+\"px\";i.tttimer=null},i.tooltipDelay)}};Q.TooltipDiv=function(j,i){if(j&&i&&i.title){this.SetTTDiv(i.title,i)}else{if(!j&&this.mx!=-1&&this.my!=-1&&this.ctitle.length){this.SetTTDiv(this.ctitle)}else{this.ttdiv.style.display=\"none\"}}};Q.Transform=function(aL,i,aN){if(i||aN){var j=ah(i),aM=w(i),aO=ah(aN),aK=w(aN),aI=new R([aK,0,aO,0,1,0,-aO,0,aK]),aJ=new R([1,0,0,0,aM,-j,0,j,aM]);aL.transform=aL.transform.mul(aI.mul(aJ))}};Q.AnimateFixed=function(){var aI,j,aK,i,aJ;if(this.fadeIn){j=G()-this.startTime;if(j>=this.fadeIn){this.fadeIn=0;this.fixedAlpha=1}else{this.fixedAlpha=j/this.fadeIn}}if(this.fixedAnim){if(!this.fixedAnim.transform){this.fixedAnim.transform=this.transform}aI=this.fixedAnim,j=G()-aI.t0,aK=aI.angle,i,aJ=this.animTiming(aI.t,j);this.transform=aI.transform;if(j>=aI.t){this.fixedCallbackTag=aI.tag;this.fixedCallback=aI.cb;this.fixedAnim=this.yaw=this.pitch=0}else{aK*=aJ}i=R.Rotation(aK,aI.axis);this.transform=this.transform.mul(i);return(this.fixedAnim!=0)}return false};Q.AnimatePosition=function(aI,aL,aJ){var j=this,i=j.mx,aN=j.my,aK,aM;if(!j.frozen&&i>=0&&aN>=0&&i<aI&&aN<aL){aK=j.maxSpeed,aM=j.reverse?-1:1;j.lx||(j.yaw=((i*2*aK/aI)-aK)*aM*aJ);j.ly||(j.pitch=((aN*2*aK/aL)-aK)*-aM*aJ);j.initial=null}else{if(!j.initial){if(j.frozen&&!j.freezeDecel){j.yaw=j.pitch=0}else{j.Decel(j)}}}this.Transform(j,j.pitch,j.yaw)};Q.AnimateDrag=function(j,aK,aJ){var i=this,aI=100*aJ*i.maxSpeed/i.max_radius/i.zoom;if(i.dx||i.dy){i.lx||(i.yaw=i.dx*aI/i.stretchX);i.ly||(i.pitch=i.dy*-aI/i.stretchY);i.dx=i.dy=0;i.initial=null}else{if(!i.initial){i.Decel(i)}}this.Transform(i,i.pitch,i.yaw)};Q.Freeze=function(){if(!this.frozen){this.preFreeze=[this.yaw,this.pitch];this.frozen=1;this.drawn=0}};Q.UnFreeze=function(){if(this.frozen){this.yaw=this.preFreeze[0];this.pitch=this.preFreeze[1];this.frozen=0}};Q.Decel=function(i){var aI=i.minSpeed,aJ=L(i.yaw),j=L(i.pitch);if(!i.lx&&aJ>aI){i.yaw=aJ>i.z0?i.yaw*i.decel:0}if(!i.ly&&j>aI){i.pitch=j>i.z0?i.pitch*i.decel:0}};Q.Zoom=function(i){this.z2=this.z1*(1/i);this.drawn=0};Q.Clicked=function(aI){var i=this.active;try{if(i&&i.tag){if(this.clickToFront===false||this.clickToFront===null){i.tag.Clicked(aI)}else{this.TagToFront(i.tag,this.clickToFront,function(){i.tag.Clicked(aI)},true)}}}catch(j){}};Q.Wheel=function(j){var aI=this.zoom+this.zoomStep*(j?1:-1);this.zoom=aE(this.zoomMax,s(this.zoomMin,aI));this.Zoom(this.zoom)};Q.BeginDrag=function(i){this.down=S(i,this.canvas);i.cancelBubble=true;i.returnValue=false;i.preventDefault&&i.preventDefault()};Q.Drag=function(aK,aJ){if(this.dragControl&&this.down){var aI=this.dragThreshold*this.dragThreshold,j=aJ.x-this.down.x,i=aJ.y-this.down.y;if(this.dragging||j*j+i*i>aI){this.dx=j;this.dy=i;this.dragging=1;this.down=aJ}}return this.dragging};Q.EndDrag=function(){var i=this.dragging;this.dragging=this.down=null;return i};function D(aI){var j=aI.targetTouches[0],i=aI.targetTouches[1];return F(au(i.pageX-j.pageX,2)+au(i.pageY-j.pageY,2))}Q.BeginPinch=function(i){this.pinched=[D(i),this.zoom];i.preventDefault&&i.preventDefault()};Q.Pinch=function(j){var aJ,aI,i=this.pinched;if(!i){return}aI=D(j);aJ=i[1]*aI/i[0];this.zoom=aE(this.zoomMax,s(this.zoomMin,aJ));this.Zoom(this.zoom)};Q.EndPinch=function(i){this.pinched=null};Q.Pause=function(){this.paused=true};Q.Resume=function(){this.paused=false};Q.SetSpeed=function(j){this.initial=j;this.yaw=j[0]*this.maxSpeed;this.pitch=j[1]*this.maxSpeed};Q.FindTag=function(aI){if(!ai(aI)){return null}ai(aI.index)&&(aI=aI.index);if(!I(aI)){return this.taglist[aI]}var aJ,aK,j;if(ai(aI.id)){aJ=\"id\",aK=aI.id}else{if(ai(aI.text)){aJ=\"innerText\",aK=aI.text}}for(j=0;j<this.taglist.length;++j){if(this.taglist[j].a[aJ]==aK){return this.taglist[j]}}};Q.RotateTag=function(aQ,aJ,aP,i,aN,aI){var aO=aQ.Calc(this.transform,1),aL=new ae(aO.x,aO.y,aO.z),aK=aj(aP,aJ),j=aL.angle(aK),aM=aL.cross(aK).unit();if(j==0){this.fixedCallbackTag=aQ;this.fixedCallback=aN}else{this.fixedAnim={angle:-j,axis:aM,t:i,t0:G(),cb:aN,tag:aQ,active:aI}}};Q.TagToFront=function(i,aI,aJ,j){this.RotateTag(i,0,0,aI,aJ,j)};y.Start=function(aI,i,j){y.Delete(aI);y.tc[aI]=new y(aI,i,j)};function az(i,j){y.tc[j]&&y.tc[j][i]()}y.Linear=function(i,j){return j/i};y.Smooth=function(i,j){return 0.5-w(j*Math.PI/i)/2};y.Pause=function(i){az(\"Pause\",i)};y.Resume=function(i){az(\"Resume\",i)};y.Reload=function(i){az(\"Load\",i)};y.Update=function(i){az(\"Update\",i)};y.SetSpeed=function(j,i){if(I(i)&&y.tc[j]&&!isNaN(i[0])&&!isNaN(i[1])){y.tc[j].SetSpeed(i);return true}return false};y.TagToFront=function(j,i){if(!I(i)){return false}i.lat=i.lng=0;return y.RotateTag(j,i)};y.RotateTag=function(aI,i){if(I(i)&&y.tc[aI]){if(isNaN(i.time)){i.time=500}var j=y.tc[aI].FindTag(i);if(j){y.tc[aI].RotateTag(j,i.lat,i.lng,i.time,i.callback,i.active);return true}}return false};y.Delete=function(aJ){var j,aI;if(b[aJ]){aI=C.getElementById(aJ);if(aI){for(j=0;j<b[aJ].length;++j){a(b[aJ][j][0],b[aJ][j][1],aI)}}}delete b[aJ];delete y.tc[aJ]};y.NextFrameRAF=function(){requestAnimationFrame(E)};y.NextFrameTimeout=function(i){setTimeout(O,i)};y.tc={};y.options={z1:20000,z2:20000,z0:0.0002,freezeActive:false,freezeDecel:false,activeCursor:\"pointer\",pulsateTo:1,pulsateTime:3,reverse:false,depth:0.5,maxSpeed:0.05,minSpeed:0,decel:0.95,interval:20,minBrightness:0.1,maxBrightness:1,outlineColour:\"#ffff99\",outlineThickness:2,outlineOffset:5,outlineMethod:\"outline\",outlineRadius:0,textColour:\"#ff99ff\",textHeight:15,textFont:\"Helvetica, Arial, sans-serif\",shadow:\"#000\",shadowBlur:0,shadowOffset:[0,0],initial:null,hideTags:true,zoom:1,weight:false,weightMode:\"size\",weightFrom:null,weightSize:1,weightSizeMin:null,weightSizeMax:null,weightGradient:{0:\"#f00\",0.33:\"#ff0\",0.66:\"#0f0\",1:\"#00f\"},txtOpt:true,txtScale:2,frontSelect:false,wheelZoom:true,zoomMin:0.3,zoomMax:3,zoomStep:0.05,shape:\"sphere\",lock:null,tooltip:null,tooltipDelay:300,tooltipClass:\"tctooltip\",radiusX:1,radiusY:1,radiusZ:1,stretchX:1,stretchY:1,offsetX:0,offsetY:0,shuffleTags:false,noSelect:false,noMouse:false,imageScale:1,paused:false,dragControl:false,dragThreshold:4,centreFunc:aB,splitWidth:0,animTiming:\"Smooth\",clickToFront:false,fadeIn:0,padding:0,bgColour:null,bgRadius:0,bgOutline:null,bgOutlineThickness:0,outlineIncrease:4,textAlign:\"centre\",textVAlign:\"middle\",imageMode:null,imagePosition:null,imagePadding:2,imageAlign:\"centre\",imageVAlign:\"middle\",noTagsMessage:true,centreImage:null,pinchZoom:false,repeatTags:0,minTags:0,imageRadius:0,scrollPause:false,outlineDash:0,outlineDashSpace:0,outlineDashSpeed:1};for(M in y.options){y[M]=y.options[M]}window.TagCanvas=y;jQuery.fn.tagcanvas=function(j,i){var aI={pause:function(){ap(this).each(function(){az(\"Pause\",ap(this)[0].id)})},resume:function(){ap(this).each(function(){az(\"Resume\",ap(this)[0].id)})},reload:function(){ap(this).each(function(){az(\"Load\",ap(this)[0].id)})},update:function(){ap(this).each(function(){az(\"Update\",ap(this)[0].id)})},tagtofront:function(){ap(this).each(function(){y.TagToFront(ap(this)[0].id,i)})},rotatetag:function(){ap(this).each(function(){y.RotateTag(ap(this)[0].id,i)})},\"delete\":function(){ap(this).each(function(){y.Delete(ap(this)[0].id)})},setspeed:function(){ap(this).each(function(){y.SetSpeed(ap(this)[0].id,i)})}};if(typeof j==\"string\"&&aI[j]){aI[j].apply(this);return this}else{y.jquery=1;ap(this).each(function(){y.Start(ap(this)[0].id,i,j)});return y.started}};ad(\"load\",function(){y.loaded=1},window)})(jQuery);\n","Magefan_Blog/js/lib/masonry.pkgd.min.js":"/*!\n * Masonry PACKAGED v4.1.1\n * Cascading grid layout library\n * http://masonry.desandro.com\n * MIT License\n * by David DeSandro\n */\n\n!function(t,e){\"function\"==typeof define&&define.amd?define(\"jquery-bridget/jquery-bridget\",[\"jquery\"],function(i){return e(t,i)}):\"object\"==typeof module&&module.exports?module.exports=e(t,require(\"jquery\")):t.jQueryBridget=e(t,t.jQuery)}(window,function(t,e){\"use strict\";function i(i,r,a){function h(t,e,n){var o,r=\"$().\"+i+'(\"'+e+'\")';return t.each(function(t,h){var u=a.data(h,i);if(!u)return void s(i+\" not initialized. Cannot call methods, i.e. \"+r);var d=u[e];if(!d||\"_\"==e.charAt(0))return void s(r+\" is not a valid method\");var l=d.apply(u,n);o=void 0===o?l:o}),void 0!==o?o:t}function u(t,e){t.each(function(t,n){var o=a.data(n,i);o?(o.option(e),o._init()):(o=new r(n,e),a.data(n,i,o))})}a=a||e||t.jQuery,a&&(r.prototype.option||(r.prototype.option=function(t){a.isPlainObject(t)&&(this.options=a.extend(!0,this.options,t))}),a.fn[i]=function(t){if(\"string\"==typeof t){var e=o.call(arguments,1);return h(this,t,e)}return u(this,t),this},n(a))}function n(t){!t||t&&t.bridget||(t.bridget=i)}var o=Array.prototype.slice,r=t.console,s=\"undefined\"==typeof r?function(){}:function(t){r.error(t)};return n(e||t.jQuery),i}),function(t,e){\"function\"==typeof define&&define.amd?define(\"ev-emitter/ev-emitter\",e):\"object\"==typeof module&&module.exports?module.exports=e():t.EvEmitter=e()}(\"undefined\"!=typeof window?window:this,function(){function t(){}var e=t.prototype;return e.on=function(t,e){if(t&&e){var i=this._events=this._events||{},n=i[t]=i[t]||[];return-1==n.indexOf(e)&&n.push(e),this}},e.once=function(t,e){if(t&&e){this.on(t,e);var i=this._onceEvents=this._onceEvents||{},n=i[t]=i[t]||{};return n[e]=!0,this}},e.off=function(t,e){var i=this._events&&this._events[t];if(i&&i.length){var n=i.indexOf(e);return-1!=n&&i.splice(n,1),this}},e.emitEvent=function(t,e){var i=this._events&&this._events[t];if(i&&i.length){var n=0,o=i[n];e=e||[];for(var r=this._onceEvents&&this._onceEvents[t];o;){var s=r&&r[o];s&&(this.off(t,o),delete r[o]),o.apply(this,e),n+=s?0:1,o=i[n]}return this}},t}),function(t,e){\"use strict\";\"function\"==typeof define&&define.amd?define(\"get-size/get-size\",[],function(){return e()}):\"object\"==typeof module&&module.exports?module.exports=e():t.getSize=e()}(window,function(){\"use strict\";function t(t){var e=parseFloat(t),i=-1==t.indexOf(\"%\")&&!isNaN(e);return i&&e}function e(){}function i(){for(var t={width:0,height:0,innerWidth:0,innerHeight:0,outerWidth:0,outerHeight:0},e=0;u>e;e++){var i=h[e];t[i]=0}return t}function n(t){var e=getComputedStyle(t);return e||a(\"Style returned \"+e+\". Are you running this code in a hidden iframe on Firefox? See http://bit.ly/getsizebug1\"),e}function o(){if(!d){d=!0;var e=document.createElement(\"div\");e.style.width=\"200px\",e.style.padding=\"1px 2px 3px 4px\",e.style.borderStyle=\"solid\",e.style.borderWidth=\"1px 2px 3px 4px\",e.style.boxSizing=\"border-box\";var i=document.body||document.documentElement;i.appendChild(e);var o=n(e);r.isBoxSizeOuter=s=200==t(o.width),i.removeChild(e)}}function r(e){if(o(),\"string\"==typeof e&&(e=document.querySelector(e)),e&&\"object\"==typeof e&&e.nodeType){var r=n(e);if(\"none\"==r.display)return i();var a={};a.width=e.offsetWidth,a.height=e.offsetHeight;for(var d=a.isBorderBox=\"border-box\"==r.boxSizing,l=0;u>l;l++){var c=h[l],f=r[c],m=parseFloat(f);a[c]=isNaN(m)?0:m}var p=a.paddingLeft+a.paddingRight,g=a.paddingTop+a.paddingBottom,y=a.marginLeft+a.marginRight,v=a.marginTop+a.marginBottom,_=a.borderLeftWidth+a.borderRightWidth,E=a.borderTopWidth+a.borderBottomWidth,z=d&&s,b=t(r.width);b!==!1&&(a.width=b+(z?0:p+_));var x=t(r.height);return x!==!1&&(a.height=x+(z?0:g+E)),a.innerWidth=a.width-(p+_),a.innerHeight=a.height-(g+E),a.outerWidth=a.width+y,a.outerHeight=a.height+v,a}}var s,a=\"undefined\"==typeof console?e:function(t){console.error(t)},h=[\"paddingLeft\",\"paddingRight\",\"paddingTop\",\"paddingBottom\",\"marginLeft\",\"marginRight\",\"marginTop\",\"marginBottom\",\"borderLeftWidth\",\"borderRightWidth\",\"borderTopWidth\",\"borderBottomWidth\"],u=h.length,d=!1;return r}),function(t,e){\"use strict\";\"function\"==typeof define&&define.amd?define(\"desandro-matches-selector/matches-selector\",e):\"object\"==typeof module&&module.exports?module.exports=e():t.matchesSelector=e()}(window,function(){\"use strict\";var t=function(){var t=Element.prototype;if(t.matches)return\"matches\";if(t.matchesSelector)return\"matchesSelector\";for(var e=[\"webkit\",\"moz\",\"ms\",\"o\"],i=0;i<e.length;i++){var n=e[i],o=n+\"MatchesSelector\";if(t[o])return o}}();return function(e,i){return e[t](i)}}),function(t,e){\"function\"==typeof define&&define.amd?define(\"fizzy-ui-utils/utils\",[\"desandro-matches-selector/matches-selector\"],function(i){return e(t,i)}):\"object\"==typeof module&&module.exports?module.exports=e(t,require(\"desandro-matches-selector\")):t.fizzyUIUtils=e(t,t.matchesSelector)}(window,function(t,e){var i={};i.extend=function(t,e){for(var i in e)t[i]=e[i];return t},i.modulo=function(t,e){return(t%e+e)%e},i.makeArray=function(t){var e=[];if(Array.isArray(t))e=t;else if(t&&\"number\"==typeof t.length)for(var i=0;i<t.length;i++)e.push(t[i]);else e.push(t);return e},i.removeFrom=function(t,e){var i=t.indexOf(e);-1!=i&&t.splice(i,1)},i.getParent=function(t,i){for(;t!=document.body;)if(t=t.parentNode,e(t,i))return t},i.getQueryElement=function(t){return\"string\"==typeof t?document.querySelector(t):t},i.handleEvent=function(t){var e=\"on\"+t.type;this[e]&&this[e](t)},i.filterFindElements=function(t,n){t=i.makeArray(t);var o=[];return t.forEach(function(t){if(t instanceof HTMLElement){if(!n)return void o.push(t);e(t,n)&&o.push(t);for(var i=t.querySelectorAll(n),r=0;r<i.length;r++)o.push(i[r])}}),o},i.debounceMethod=function(t,e,i){var n=t.prototype[e],o=e+\"Timeout\";t.prototype[e]=function(){var t=this[o];t&&clearTimeout(t);var e=arguments,r=this;this[o]=setTimeout(function(){n.apply(r,e),delete r[o]},i||100)}},i.docReady=function(t){var e=document.readyState;\"complete\"==e||\"interactive\"==e?t():document.addEventListener(\"DOMContentLoaded\",t)},i.toDashed=function(t){return t.replace(/(.)([A-Z])/g,function(t,e,i){return e+\"-\"+i}).toLowerCase()};var n=t.console;return i.htmlInit=function(e,o){i.docReady(function(){var r=i.toDashed(o),s=\"data-\"+r,a=document.querySelectorAll(\"[\"+s+\"]\"),h=document.querySelectorAll(\".js-\"+r),u=i.makeArray(a).concat(i.makeArray(h)),d=s+\"-options\",l=t.jQuery;u.forEach(function(t){var i,r=t.getAttribute(s)||t.getAttribute(d);try{i=r&&JSON.parse(r)}catch(a){return void(n&&n.error(\"Error parsing \"+s+\" on \"+t.className+\": \"+a))}var h=new e(t,i);l&&l.data(t,o,h)})})},i}),function(t,e){\"function\"==typeof define&&define.amd?define(\"outlayer/item\",[\"ev-emitter/ev-emitter\",\"get-size/get-size\"],e):\"object\"==typeof module&&module.exports?module.exports=e(require(\"ev-emitter\"),require(\"get-size\")):(t.Outlayer={},t.Outlayer.Item=e(t.EvEmitter,t.getSize))}(window,function(t,e){\"use strict\";function i(t){for(var e in t)return!1;return e=null,!0}function n(t,e){t&&(this.element=t,this.layout=e,this.position={x:0,y:0},this._create())}function o(t){return t.replace(/([A-Z])/g,function(t){return\"-\"+t.toLowerCase()})}var r=document.documentElement.style,s=\"string\"==typeof r.transition?\"transition\":\"WebkitTransition\",a=\"string\"==typeof r.transform?\"transform\":\"WebkitTransform\",h={WebkitTransition:\"webkitTransitionEnd\",transition:\"transitionend\"}[s],u={transform:a,transition:s,transitionDuration:s+\"Duration\",transitionProperty:s+\"Property\",transitionDelay:s+\"Delay\"},d=n.prototype=Object.create(t.prototype);d.constructor=n,d._create=function(){this._transn={ingProperties:{},clean:{},onEnd:{}},this.css({position:\"absolute\"})},d.handleEvent=function(t){var e=\"on\"+t.type;this[e]&&this[e](t)},d.getSize=function(){this.size=e(this.element)},d.css=function(t){var e=this.element.style;for(var i in t){var n=u[i]||i;e[n]=t[i]}},d.getPosition=function(){var t=getComputedStyle(this.element),e=this.layout._getOption(\"originLeft\"),i=this.layout._getOption(\"originTop\"),n=t[e?\"left\":\"right\"],o=t[i?\"top\":\"bottom\"],r=this.layout.size,s=-1!=n.indexOf(\"%\")?parseFloat(n)/100*r.width:parseInt(n,10),a=-1!=o.indexOf(\"%\")?parseFloat(o)/100*r.height:parseInt(o,10);s=isNaN(s)?0:s,a=isNaN(a)?0:a,s-=e?r.paddingLeft:r.paddingRight,a-=i?r.paddingTop:r.paddingBottom,this.position.x=s,this.position.y=a},d.layoutPosition=function(){var t=this.layout.size,e={},i=this.layout._getOption(\"originLeft\"),n=this.layout._getOption(\"originTop\"),o=i?\"paddingLeft\":\"paddingRight\",r=i?\"left\":\"right\",s=i?\"right\":\"left\",a=this.position.x+t[o];e[r]=this.getXValue(a),e[s]=\"\";var h=n?\"paddingTop\":\"paddingBottom\",u=n?\"top\":\"bottom\",d=n?\"bottom\":\"top\",l=this.position.y+t[h];e[u]=this.getYValue(l),e[d]=\"\",this.css(e),this.emitEvent(\"layout\",[this])},d.getXValue=function(t){var e=this.layout._getOption(\"horizontal\");return this.layout.options.percentPosition&&!e?t/this.layout.size.width*100+\"%\":t+\"px\"},d.getYValue=function(t){var e=this.layout._getOption(\"horizontal\");return this.layout.options.percentPosition&&e?t/this.layout.size.height*100+\"%\":t+\"px\"},d._transitionTo=function(t,e){this.getPosition();var i=this.position.x,n=this.position.y,o=parseInt(t,10),r=parseInt(e,10),s=o===this.position.x&&r===this.position.y;if(this.setPosition(t,e),s&&!this.isTransitioning)return void this.layoutPosition();var a=t-i,h=e-n,u={};u.transform=this.getTranslate(a,h),this.transition({to:u,onTransitionEnd:{transform:this.layoutPosition},isCleaning:!0})},d.getTranslate=function(t,e){var i=this.layout._getOption(\"originLeft\"),n=this.layout._getOption(\"originTop\");return t=i?t:-t,e=n?e:-e,\"translate3d(\"+t+\"px, \"+e+\"px, 0)\"},d.goTo=function(t,e){this.setPosition(t,e),this.layoutPosition()},d.moveTo=d._transitionTo,d.setPosition=function(t,e){this.position.x=parseInt(t,10),this.position.y=parseInt(e,10)},d._nonTransition=function(t){this.css(t.to),t.isCleaning&&this._removeStyles(t.to);for(var e in t.onTransitionEnd)t.onTransitionEnd[e].call(this)},d.transition=function(t){if(!parseFloat(this.layout.options.transitionDuration))return void this._nonTransition(t);var e=this._transn;for(var i in t.onTransitionEnd)e.onEnd[i]=t.onTransitionEnd[i];for(i in t.to)e.ingProperties[i]=!0,t.isCleaning&&(e.clean[i]=!0);if(t.from){this.css(t.from);var n=this.element.offsetHeight;n=null}this.enableTransition(t.to),this.css(t.to),this.isTransitioning=!0};var l=\"opacity,\"+o(a);d.enableTransition=function(){if(!this.isTransitioning){var t=this.layout.options.transitionDuration;t=\"number\"==typeof t?t+\"ms\":t,this.css({transitionProperty:l,transitionDuration:t,transitionDelay:this.staggerDelay||0}),this.element.addEventListener(h,this,!1)}},d.onwebkitTransitionEnd=function(t){this.ontransitionend(t)},d.onotransitionend=function(t){this.ontransitionend(t)};var c={\"-webkit-transform\":\"transform\"};d.ontransitionend=function(t){if(t.target===this.element){var e=this._transn,n=c[t.propertyName]||t.propertyName;if(delete e.ingProperties[n],i(e.ingProperties)&&this.disableTransition(),n in e.clean&&(this.element.style[t.propertyName]=\"\",delete e.clean[n]),n in e.onEnd){var o=e.onEnd[n];o.call(this),delete e.onEnd[n]}this.emitEvent(\"transitionEnd\",[this])}},d.disableTransition=function(){this.removeTransitionStyles(),this.element.removeEventListener(h,this,!1),this.isTransitioning=!1},d._removeStyles=function(t){var e={};for(var i in t)e[i]=\"\";this.css(e)};var f={transitionProperty:\"\",transitionDuration:\"\",transitionDelay:\"\"};return d.removeTransitionStyles=function(){this.css(f)},d.stagger=function(t){t=isNaN(t)?0:t,this.staggerDelay=t+\"ms\"},d.removeElem=function(){this.element.parentNode.removeChild(this.element),this.css({display:\"\"}),this.emitEvent(\"remove\",[this])},d.remove=function(){return s&&parseFloat(this.layout.options.transitionDuration)?(this.once(\"transitionEnd\",function(){this.removeElem()}),void this.hide()):void this.removeElem()},d.reveal=function(){delete this.isHidden,this.css({display:\"\"});var t=this.layout.options,e={},i=this.getHideRevealTransitionEndProperty(\"visibleStyle\");e[i]=this.onRevealTransitionEnd,this.transition({from:t.hiddenStyle,to:t.visibleStyle,isCleaning:!0,onTransitionEnd:e})},d.onRevealTransitionEnd=function(){this.isHidden||this.emitEvent(\"reveal\")},d.getHideRevealTransitionEndProperty=function(t){var e=this.layout.options[t];if(e.opacity)return\"opacity\";for(var i in e)return i},d.hide=function(){this.isHidden=!0,this.css({display:\"\"});var t=this.layout.options,e={},i=this.getHideRevealTransitionEndProperty(\"hiddenStyle\");e[i]=this.onHideTransitionEnd,this.transition({from:t.visibleStyle,to:t.hiddenStyle,isCleaning:!0,onTransitionEnd:e})},d.onHideTransitionEnd=function(){this.isHidden&&(this.css({display:\"none\"}),this.emitEvent(\"hide\"))},d.destroy=function(){this.css({position:\"\",left:\"\",right:\"\",top:\"\",bottom:\"\",transition:\"\",transform:\"\"})},n}),function(t,e){\"use strict\";\"function\"==typeof define&&define.amd?define(\"outlayer/outlayer\",[\"ev-emitter/ev-emitter\",\"get-size/get-size\",\"fizzy-ui-utils/utils\",\"./item\"],function(i,n,o,r){return e(t,i,n,o,r)}):\"object\"==typeof module&&module.exports?module.exports=e(t,require(\"ev-emitter\"),require(\"get-size\"),require(\"fizzy-ui-utils\"),require(\"./item\")):t.Outlayer=e(t,t.EvEmitter,t.getSize,t.fizzyUIUtils,t.Outlayer.Item)}(window,function(t,e,i,n,o){\"use strict\";function r(t,e){var i=n.getQueryElement(t);if(!i)return void(h&&h.error(\"Bad element for \"+this.constructor.namespace+\": \"+(i||t)));this.element=i,u&&(this.$element=u(this.element)),this.options=n.extend({},this.constructor.defaults),this.option(e);var o=++l;this.element.outlayerGUID=o,c[o]=this,this._create();var r=this._getOption(\"initLayout\");r&&this.layout()}function s(t){function e(){t.apply(this,arguments)}return e.prototype=Object.create(t.prototype),e.prototype.constructor=e,e}function a(t){if(\"number\"==typeof t)return t;var e=t.match(/(^\\d*\\.?\\d*)(\\w*)/),i=e&&e[1],n=e&&e[2];if(!i.length)return 0;i=parseFloat(i);var o=m[n]||1;return i*o}var h=t.console,u=t.jQuery,d=function(){},l=0,c={};r.namespace=\"outlayer\",r.Item=o,r.defaults={containerStyle:{position:\"relative\"},initLayout:!0,originLeft:!0,originTop:!0,resize:!0,resizeContainer:!0,transitionDuration:\"0.4s\",hiddenStyle:{opacity:0,transform:\"scale(0.001)\"},visibleStyle:{opacity:1,transform:\"scale(1)\"}};var f=r.prototype;n.extend(f,e.prototype),f.option=function(t){n.extend(this.options,t)},f._getOption=function(t){var e=this.constructor.compatOptions[t];return e&&void 0!==this.options[e]?this.options[e]:this.options[t]},r.compatOptions={initLayout:\"isInitLayout\",horizontal:\"isHorizontal\",layoutInstant:\"isLayoutInstant\",originLeft:\"isOriginLeft\",originTop:\"isOriginTop\",resize:\"isResizeBound\",resizeContainer:\"isResizingContainer\"},f._create=function(){this.reloadItems(),this.stamps=[],this.stamp(this.options.stamp),n.extend(this.element.style,this.options.containerStyle);var t=this._getOption(\"resize\");t&&this.bindResize()},f.reloadItems=function(){this.items=this._itemize(this.element.children)},f._itemize=function(t){for(var e=this._filterFindItemElements(t),i=this.constructor.Item,n=[],o=0;o<e.length;o++){var r=e[o],s=new i(r,this);n.push(s)}return n},f._filterFindItemElements=function(t){return n.filterFindElements(t,this.options.itemSelector)},f.getItemElements=function(){return this.items.map(function(t){return t.element})},f.layout=function(){this._resetLayout(),this._manageStamps();var t=this._getOption(\"layoutInstant\"),e=void 0!==t?t:!this._isLayoutInited;this.layoutItems(this.items,e),this._isLayoutInited=!0},f._init=f.layout,f._resetLayout=function(){this.getSize()},f.getSize=function(){this.size=i(this.element)},f._getMeasurement=function(t,e){var n,o=this.options[t];o?(\"string\"==typeof o?n=this.element.querySelector(o):o instanceof HTMLElement&&(n=o),this[t]=n?i(n)[e]:o):this[t]=0},f.layoutItems=function(t,e){t=this._getItemsForLayout(t),this._layoutItems(t,e),this._postLayout()},f._getItemsForLayout=function(t){return t.filter(function(t){return!t.isIgnored})},f._layoutItems=function(t,e){if(this._emitCompleteOnItems(\"layout\",t),t&&t.length){var i=[];t.forEach(function(t){var n=this._getItemLayoutPosition(t);n.item=t,n.isInstant=e||t.isLayoutInstant,i.push(n)},this),this._processLayoutQueue(i)}},f._getItemLayoutPosition=function(){return{x:0,y:0}},f._processLayoutQueue=function(t){this.updateStagger(),t.forEach(function(t,e){this._positionItem(t.item,t.x,t.y,t.isInstant,e)},this)},f.updateStagger=function(){var t=this.options.stagger;return null===t||void 0===t?void(this.stagger=0):(this.stagger=a(t),this.stagger)},f._positionItem=function(t,e,i,n,o){n?t.goTo(e,i):(t.stagger(o*this.stagger),t.moveTo(e,i))},f._postLayout=function(){this.resizeContainer()},f.resizeContainer=function(){var t=this._getOption(\"resizeContainer\");if(t){var e=this._getContainerSize();e&&(this._setContainerMeasure(e.width,!0),this._setContainerMeasure(e.height,!1))}},f._getContainerSize=d,f._setContainerMeasure=function(t,e){if(void 0!==t){var i=this.size;i.isBorderBox&&(t+=e?i.paddingLeft+i.paddingRight+i.borderLeftWidth+i.borderRightWidth:i.paddingBottom+i.paddingTop+i.borderTopWidth+i.borderBottomWidth),t=Math.max(t,0),this.element.style[e?\"width\":\"height\"]=t+\"px\"}},f._emitCompleteOnItems=function(t,e){function i(){o.dispatchEvent(t+\"Complete\",null,[e])}function n(){s++,s==r&&i()}var o=this,r=e.length;if(!e||!r)return void i();var s=0;e.forEach(function(e){e.once(t,n)})},f.dispatchEvent=function(t,e,i){var n=e?[e].concat(i):i;if(this.emitEvent(t,n),u)if(this.$element=this.$element||u(this.element),e){var o=u.Event(e);o.type=t,this.$element.trigger(o,i)}else this.$element.trigger(t,i)},f.ignore=function(t){var e=this.getItem(t);e&&(e.isIgnored=!0)},f.unignore=function(t){var e=this.getItem(t);e&&delete e.isIgnored},f.stamp=function(t){t=this._find(t),t&&(this.stamps=this.stamps.concat(t),t.forEach(this.ignore,this))},f.unstamp=function(t){t=this._find(t),t&&t.forEach(function(t){n.removeFrom(this.stamps,t),this.unignore(t)},this)},f._find=function(t){return t?(\"string\"==typeof t&&(t=this.element.querySelectorAll(t)),t=n.makeArray(t)):void 0},f._manageStamps=function(){this.stamps&&this.stamps.length&&(this._getBoundingRect(),this.stamps.forEach(this._manageStamp,this))},f._getBoundingRect=function(){var t=this.element.getBoundingClientRect(),e=this.size;this._boundingRect={left:t.left+e.paddingLeft+e.borderLeftWidth,top:t.top+e.paddingTop+e.borderTopWidth,right:t.right-(e.paddingRight+e.borderRightWidth),bottom:t.bottom-(e.paddingBottom+e.borderBottomWidth)}},f._manageStamp=d,f._getElementOffset=function(t){var e=t.getBoundingClientRect(),n=this._boundingRect,o=i(t),r={left:e.left-n.left-o.marginLeft,top:e.top-n.top-o.marginTop,right:n.right-e.right-o.marginRight,bottom:n.bottom-e.bottom-o.marginBottom};return r},f.handleEvent=n.handleEvent,f.bindResize=function(){t.addEventListener(\"resize\",this),this.isResizeBound=!0},f.unbindResize=function(){t.removeEventListener(\"resize\",this),this.isResizeBound=!1},f.onresize=function(){this.resize()},n.debounceMethod(r,\"onresize\",100),f.resize=function(){this.isResizeBound&&this.needsResizeLayout()&&this.layout()},f.needsResizeLayout=function(){var t=i(this.element),e=this.size&&t;return e&&t.innerWidth!==this.size.innerWidth},f.addItems=function(t){var e=this._itemize(t);return e.length&&(this.items=this.items.concat(e)),e},f.appended=function(t){var e=this.addItems(t);e.length&&(this.layoutItems(e,!0),this.reveal(e))},f.prepended=function(t){var e=this._itemize(t);if(e.length){var i=this.items.slice(0);this.items=e.concat(i),this._resetLayout(),this._manageStamps(),this.layoutItems(e,!0),this.reveal(e),this.layoutItems(i)}},f.reveal=function(t){if(this._emitCompleteOnItems(\"reveal\",t),t&&t.length){var e=this.updateStagger();t.forEach(function(t,i){t.stagger(i*e),t.reveal()})}},f.hide=function(t){if(this._emitCompleteOnItems(\"hide\",t),t&&t.length){var e=this.updateStagger();t.forEach(function(t,i){t.stagger(i*e),t.hide()})}},f.revealItemElements=function(t){var e=this.getItems(t);this.reveal(e)},f.hideItemElements=function(t){var e=this.getItems(t);this.hide(e)},f.getItem=function(t){for(var e=0;e<this.items.length;e++){var i=this.items[e];if(i.element==t)return i}},f.getItems=function(t){t=n.makeArray(t);var e=[];return t.forEach(function(t){var i=this.getItem(t);i&&e.push(i)},this),e},f.remove=function(t){var e=this.getItems(t);this._emitCompleteOnItems(\"remove\",e),e&&e.length&&e.forEach(function(t){t.remove(),n.removeFrom(this.items,t)},this)},f.destroy=function(){var t=this.element.style;t.height=\"\",t.position=\"\",t.width=\"\",this.items.forEach(function(t){t.destroy()}),this.unbindResize();var e=this.element.outlayerGUID;delete c[e],delete this.element.outlayerGUID,u&&u.removeData(this.element,this.constructor.namespace)},r.data=function(t){t=n.getQueryElement(t);var e=t&&t.outlayerGUID;return e&&c[e]},r.create=function(t,e){var i=s(r);return i.defaults=n.extend({},r.defaults),n.extend(i.defaults,e),i.compatOptions=n.extend({},r.compatOptions),i.namespace=t,i.data=r.data,i.Item=s(o),n.htmlInit(i,t),u&&u.bridget&&u.bridget(t,i),i};var m={ms:1,s:1e3};return r.Item=o,r}),function(t,e){\"function\"==typeof define&&define.amd?define([\"outlayer/outlayer\",\"get-size/get-size\"],e):\"object\"==typeof module&&module.exports?module.exports=e(require(\"outlayer\"),require(\"get-size\")):t.Masonry=e(t.Outlayer,t.getSize)}(window,function(t,e){var i=t.create(\"masonry\");return i.compatOptions.fitWidth=\"isFitWidth\",i.prototype._resetLayout=function(){this.getSize(),this._getMeasurement(\"columnWidth\",\"outerWidth\"),this._getMeasurement(\"gutter\",\"outerWidth\"),this.measureColumns(),this.colYs=[];for(var t=0;t<this.cols;t++)this.colYs.push(0);this.maxY=0},i.prototype.measureColumns=function(){if(this.getContainerWidth(),!this.columnWidth){var t=this.items[0],i=t&&t.element;this.columnWidth=i&&e(i).outerWidth||this.containerWidth}var n=this.columnWidth+=this.gutter,o=this.containerWidth+this.gutter,r=o/n,s=n-o%n,a=s&&1>s?\"round\":\"floor\";r=Math[a](r),this.cols=Math.max(r,1)},i.prototype.getContainerWidth=function(){var t=this._getOption(\"fitWidth\"),i=t?this.element.parentNode:this.element,n=e(i);this.containerWidth=n&&n.innerWidth},i.prototype._getItemLayoutPosition=function(t){t.getSize();var e=t.size.outerWidth%this.columnWidth,i=e&&1>e?\"round\":\"ceil\",n=Math[i](t.size.outerWidth/this.columnWidth);n=Math.min(n,this.cols);for(var o=this._getColGroup(n),r=Math.min.apply(Math,o),s=o.indexOf(r),a={x:this.columnWidth*s,y:r},h=r+t.size.outerHeight,u=this.cols+1-o.length,d=0;u>d;d++)this.colYs[s+d]=h;return a},i.prototype._getColGroup=function(t){if(2>t)return this.colYs;for(var e=[],i=this.cols+1-t,n=0;i>n;n++){var o=this.colYs.slice(n,n+t);e[n]=Math.max.apply(Math,o)}return e},i.prototype._manageStamp=function(t){var i=e(t),n=this._getElementOffset(t),o=this._getOption(\"originLeft\"),r=o?n.left:n.right,s=r+i.outerWidth,a=Math.floor(r/this.columnWidth);a=Math.max(0,a);var h=Math.floor(s/this.columnWidth);h-=s%this.columnWidth?0:1,h=Math.min(this.cols-1,h);for(var u=this._getOption(\"originTop\"),d=(u?n.top:n.bottom)+i.outerHeight,l=a;h>=l;l++)this.colYs[l]=Math.max(d,this.colYs[l])},i.prototype._getContainerSize=function(){this.maxY=Math.max.apply(Math,this.colYs);var t={height:this.maxY};return this._getOption(\"fitWidth\")&&(t.width=this._getContainerFitWidth()),t},i.prototype._getContainerFitWidth=function(){for(var t=0,e=this.cols;--e&&0===this.colYs[e];)t++;return(this.cols-t)*this.columnWidth-this.gutter},i.prototype.needsResizeLayout=function(){var t=this.containerWidth;return this.getContainerWidth(),t!=this.containerWidth},i});","Magento_Theme/menu.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/**\n * Simple Navigation with replacing old handlers.\n *\n * @param {String} id - id of ul element with navigation lists\n * @param {Object} settings - object with settings\n */\n/**\n * global mainNav\n *\n * @deprecated\n * @see lib/web/mage/menu.js\n */\ndefine([\n    'prototype'\n], function () {\n    'use strict';\n\n    /**\n     * Main nav.\n     */\n    window.mainNav = function () {\n        var main = {\n            'obj_nav':   $(arguments[0]) || $('nav'),\n            settings:  {\n                'show_delay': 0,\n                'hide_delay': 0,\n                _ie6: /MSIE 6.+Win/.test(navigator.userAgent),\n                _ie7: /MSIE 7.+Win/.test(navigator.userAgent)\n            },\n\n            /**\n             * @param {Object} obj\n             * @param {*} level\n             */\n            init: function (obj, level) {\n                obj.lists = obj.childElements();\n                obj.lists.each(function (el, ind) {\n                    main.handlNavElement(el);\n\n                    if ((main.settings._ie6 || main.settings._ie7) && level) {\n                        main.ieFixZIndex(el, ind, obj.lists.size());\n                    }\n                });\n\n                if (main.settings._ie6 && !level) {\n                    document.execCommand('BackgroundImageCache', false, true);\n                }\n            },\n\n            /**\n             * @param {Object} list\n             */\n            handlNavElement: function (list) {\n                if (list !== undefined) {\n\n                    /**\n                     * On mouse over.\n                     */\n                    list.onmouseover = function () {\n                        main.fireNavEvent(this, true);\n                    };\n\n                    /**\n                     * On mouse out.\n                     */\n                    list.onmouseout = function () {\n                        main.fireNavEvent(this, false);\n                    };\n\n                    if (list.down('ul')) {\n                        main.init(list.down('ul'), true);\n                    }\n                }\n            },\n\n            /**\n             * @param {HTMLElement} el\n             * @param {*} i\n             * @param {*} l\n             */\n            ieFixZIndex: function (el, i, l) {\n                if (el.tagName.toString().toLowerCase().indexOf('iframe') == -1) { //eslint-disable-line eqeqeq\n                    el.style.zIndex = l - i;\n                } else {\n                    el.onmouseover = 'null';\n                    el.onmouseout = 'null';\n                }\n            },\n\n            /**\n             * @param {Object} elm\n             * @param {*} ev\n             */\n            fireNavEvent: function (elm, ev) {\n                if (ev) {\n                    elm.addClassName('over');\n                    elm.down('a').addClassName('over');\n\n                    if (elm.childElements()[1]) {\n                        main.show(elm.childElements()[1]);\n                    }\n                } else {\n                    elm.removeClassName('over');\n                    elm.down('a').removeClassName('over');\n\n                    if (elm.childElements()[1]) {\n                        main.hide(elm.childElements()[1]);\n                    }\n                }\n            },\n\n            /**\n             * @param {Object} subElm\n             */\n            show: function (subElm) {\n                if (subElm['hide_time_id']) {\n                    clearTimeout(subElm['hide_time_id']);\n                }\n                subElm['show_time_id'] = setTimeout(function () {\n                    if (!subElm.hasClassName('shown-sub')) {\n                        subElm.addClassName('shown-sub');\n                    }\n                }, main.settings['show_delay']);\n            },\n\n            /**\n             * @param {Object} subElm\n             */\n            hide: function (subElm) {\n                if (subElm['show_time_id']) {\n                    clearTimeout(subElm['show_time_id']);\n                }\n                subElm['hide_time_id'] = setTimeout(function () {\n                    if (subElm.hasClassName('shown-sub')) {\n                        subElm.removeClassName('shown-sub');\n                    }\n                }, main.settings['hide_delay']);\n            }\n\n        };\n\n        if (arguments[1]) {\n            main.settings = Object.extend(main.settings, arguments[1]);\n        }\n\n        if (main['obj_nav']) {\n            main.init(main['obj_nav'], false);\n        }\n    };\n\n    document.observe('dom:loaded', function () {\n        //run navigation without delays and with default id=\"#nav\"\n        //mainNav();\n\n        //run navigation with delays\n        window.mainNav('nav', {\n            'show_delay': '100',\n            'hide_delay': '100'\n        });\n    });\n});\n","Magento_Theme/js/cookie-status.js":"define([\n    'jquery',\n    'Magento_Ui/js/modal/modal',\n    'mage/translate'\n], function ($, modal) {\n    'use strict';\n\n    $.widget('mage.cookieStatus', {\n        options: {\n            type: 'popup',\n            responsive: true,\n            innerScroll: true,\n            autoOpen: true,\n            buttons: [{\n                text: $.mage.__('Close'),\n                class: 'cookie-status',\n\n                /**\n                 * Callback for click event\n                 */\n                click: function () {\n                    this.closeModal();\n                }\n            }]\n        },\n\n        /**\n         * Init object\n         * @private\n         */\n        _init: function () {\n\n            if (!navigator.cookieEnabled) {\n                modal(this.options, $('#cookie-status'));\n            }\n        }\n    });\n\n    return $.mage.cookieStatus;\n});\n","Magento_Theme/js/truncate.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * JQuery UI Widget declaration: 'mage.truncateOptions'\n *\n * @deprecated since version 2.2.0\n */\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.truncateOptions', {\n        options: {\n            detailsLink: 'a.details',\n            mouseEvents: 'mouseover mouseout',\n            truncatedFullValue: 'div.truncated.full.value'\n        },\n\n        /**\n         * Establish the event handler for mouse events on the appropriate elements.\n         *\n         * @private\n         */\n        _create: function () {\n            this.element.on(this.options.mouseEvents, $.proxy(this._toggleShow, this))\n                .find(this.options.detailsLink).on(this.options.mouseEvents, $.proxy(this._toggleShow, this));\n        },\n\n        /**\n         * Toggle the \"show\" class on the associated element.\n         *\n         * @private\n         * @param {jQuery.Event} event - Mouse over/out event.\n         */\n        _toggleShow: function (event) {\n            $(event.currentTarget).find(this.options.truncatedFullValue).toggleClass('show');\n        }\n    });\n});\n","Magento_Theme/js/theme.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/smart-keyboard-handler',\n    'mage/mage',\n    'mage/ie-class-fixer',\n    'domReady!'\n], function ($, keyboardHandler) {\n    'use strict';\n\n    $('.cart-summary').mage('sticky', {\n        container: '#maincontent'\n    });\n\n    $('.panel.header > .header.links').clone().appendTo('#store\\\\.links');\n    $('#store\\\\.links li a').each(function () {\n        var id = $(this).attr('id');\n\n        if (id !== undefined) {\n            $(this).attr('id', id + '_mobile');\n        }\n    });\n\n    keyboardHandler.apply();\n});\n","Magento_Theme/js/row-builder.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * JQuery UI Widget declaration: 'mage.rowBuilder'\n *\n * @api\n */\ndefine([\n    'jquery',\n    'mage/template',\n    'jquery-ui-modules/widget'\n], function ($, mageTemplate) {\n    'use strict';\n\n    $.widget('mage.rowBuilder', {\n\n        /**\n         * options with default values for setting up the template\n         */\n        options: {\n            //Default template options\n            rowTemplate: '#template-registrant',\n            rowContainer: '#registrant-container',\n            //Row index used by the template rows.\n            rowIndex: 0,\n            //Row count: Should not be set externally\n            rowCount: 0,\n            rowParentElem: '<li></li>',\n            rowContainerClass: 'fields',\n            addRowBtn: '#add-registrant-button',\n            btnRemoveIdPrefix: 'btn-remove',\n            btnRemoveSelector: '.btn-remove',\n            rowIdPrefix: 'row',\n            //This class is added to rows added after the first one. Adds the dotted separator\n            additionalRowClass: 'add-row',\n\n            /*\n             This is provided during widget instantiation. eg :\n             formDataPost : {\"formData\":formData,\"templateFields\":['field1-name','field2-name'] }\n             -\"formData\" is the multi-dimensional array of form field values : [['a','b'],['c','b']]\n             received from the server and encoded\n             -\"templateFields\" are the input fields in the template with index suffixed after the field name\n             eg field1-name{index}\n             */\n            formDataPost: null,\n            //Default selectors for add element of a template\n            addEventSelector: 'button',\n            //Default selectors for remove markup elements of a template\n            remEventSelector: 'a',\n            //This option allows adding first row delete option and a row separator\n            hideFirstRowAddSeparator: true,\n            //Max rows - This option should be set when instantiating the widget\n            maxRows: 1000,\n            maxRowsMsg: '#max-registrant-message'\n        },\n\n        /**\n         * Initialize create\n         * @private\n         */\n        _create: function () {\n            this.rowTemplate = mageTemplate(this.options.rowTemplate);\n\n            this.options.rowCount = this.options.rowIndex = 0;\n\n            //On document ready related tasks\n            $($.proxy(this.ready, this));\n\n            //Binding template-wide events handlers for adding and removing rows\n            this.element.on(\n                'click',\n                this.options.addEventSelector + this.options.addRowBtn,\n                $.proxy(this.handleAdd, this)\n            );\n            this.element.on(\n                'click',\n                this.options.remEventSelector + this.options.btnRemoveSelector,\n                $.proxy(this.handleRemove, this)\n            );\n        },\n\n        /**\n         * Initialize template\n         * @public\n         */\n        ready: function () {\n            if (this.options.formDataPost &&\n                this.options.formDataPost.formData &&\n                this.options.formDataPost.formData.length\n            ) {\n                this.processFormDataArr(this.options.formDataPost);\n            } else if (this.options.rowIndex === 0 && this.options.maxRows !== 0) {\n                //If no form data , then add default row\n                this.addRow(0);\n            }\n        },\n\n        /**\n         * Process and loop through all row data to create preselected values. This is used for any error on submit.\n         * For complex implementations the inheriting widget can override this behavior\n         * @public\n         * @param {Object} formDataArr\n         */\n        processFormDataArr: function (formDataArr) {\n            var formData = formDataArr.formData,\n                templateFields = formDataArr.templateFields,\n                formRow,\n                i, j;\n\n            for (i = this.options.rowIndex = 0; i < formData.length; this.options.rowIndex = i++) {\n                this.addRow(i);\n\n                formRow = formData[i];\n\n                for (j = 0; j < formRow.length; j++) {\n                    this.setFieldById(templateFields[j] + i, formRow[j]);\n                }\n            }\n\n        },\n\n        /**\n         * Initialize and create markup for template row. Add it to the parent container.\n         * The template processing will substitute row index at all places marked with _index_ in the template\n         * using the template\n         * @public\n         * @param {Number} index - current index/count of the created template. This will be used as the id\n         * @return {*}\n         */\n        addRow: function (index) {\n            var row = $(this.options.rowParentElem),\n                tmpl;\n\n            row.addClass(this.options.rowContainerClass).attr('id', this.options.rowIdPrefix + index);\n\n            tmpl = this.rowTemplate({\n                data: {\n                    _index_: index\n                }\n            });\n\n            $(tmpl).appendTo(row);\n\n            $(this.options.rowContainer).append(row).trigger('contentUpdated');\n\n            row.addClass(this.options.additionalRowClass);\n\n            //Remove 'delete' link and additionalRowClass for first row\n            if (this.options.rowIndex === 0 && this.options.hideFirstRowAddSeparator) {\n                $('#' + this._esc(this.options.btnRemoveIdPrefix) + '0').remove();\n                $('#' + this._esc(this.options.rowIdPrefix) + '0').removeClass(this.options.additionalRowClass);\n            }\n\n            this.maxRowCheck(++this.options.rowCount);\n\n            return row;\n        },\n\n        /**\n         * Remove return item information row\n         * @public\n         * @param {*} rowIndex - return item information row index\n         * @return {Boolean}\n         */\n        removeRow: function (rowIndex) {\n            $('#' + this._esc(this.options.rowIdPrefix) + rowIndex).remove();\n            this.maxRowCheck(--this.options.rowCount);\n\n            return false;\n        },\n\n        /**\n         * Function to check if maximum rows are exceeded and render/hide maxMsg and Add btn\n         * @public\n         * @param {Number} rowIndex\n         */\n        maxRowCheck: function (rowIndex) {\n            var addRowBtn = $(this.options.addRowBtn),\n                maxRowMsg = $(this.options.maxRowsMsg);\n\n            //liIndex starts from 0\n            if (rowIndex >= this.options.maxRows) {\n                addRowBtn.hide();\n                maxRowMsg.show();\n            } else if (addRowBtn.is(':hidden')) {\n                addRowBtn.show();\n                maxRowMsg.hide();\n            }\n        },\n\n        /**\n         * Set the value on given element\n         * @public\n         * @param {String} domId\n         * @param {String} value\n         */\n        setFieldById: function (domId, value) {\n            var x = $('#' + this._esc(domId));\n\n            if (x.length) {\n\n                if (x.is(':checkbox')) {\n                    x.attr('checked', true);\n                } else if (x.is('option')) {\n                    x.attr('selected', 'selected');\n                } else {\n                    x.val(value);\n                }\n            }\n        },\n\n        /**\n         * Delegated handler for adding a row\n         * @public\n         * @return {Boolean}\n         */\n        handleAdd: function () {\n            this.addRow(++this.options.rowIndex);\n\n            return false;\n        },\n\n        /**\n         * Delegated handler for removing a selected row\n         * @public\n         * @param {Object} e - Native event object\n         * @return {Boolean}\n         */\n        handleRemove: function (e) {\n            this.removeRow($(e.currentTarget).closest('[id^=\"' + this.options.btnRemoveIdPrefix + '\"]')\n                .attr('id').replace(this.options.btnRemoveIdPrefix, ''));\n\n            return false;\n        },\n\n        /**\n         * Utility function to add escape chars for jquery selector strings\n         * @private\n         * @param {String} str - String to be processed\n         * @return {String}\n         */\n        _esc: function (str) {\n            return str ? str.replace(/([ ;&,.+*~\\':\"!\\^$\\[\\]()=>|\\/@])/g, '\\\\$1') : str;\n        }\n    });\n\n    return $.mage.rowBuilder;\n});\n","Magento_Theme/js/model/breadcrumb-list.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return [];\n});\n","Magento_Theme/js/view/breadcrumbs.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/template',\n    'Magento_Theme/js/model/breadcrumb-list',\n    'text!Magento_Theme/templates/breadcrumbs.html',\n    'jquery-ui-modules/widget'\n], function ($, mageTemplate, breadcrumbList, tpl) {\n    'use strict';\n\n    /**\n     * Breadcrumb Widget.\n     */\n    $.widget('mage.breadcrumbs', {\n\n        /** @inheritdoc */\n        _init: function () {\n            this._super();\n            this._render();\n        },\n\n        /**\n         * Render breadcrumb.\n         *\n         * @private\n         */\n        _render: function () {\n            var html,\n                crumbs = breadcrumbList,\n                template = mageTemplate(tpl);\n\n            this._decorate(crumbs);\n\n            html = template({\n                'breadcrumbs': crumbs\n            });\n\n            if (html.length) {\n                $(this.element).html(html);\n            }\n        },\n\n        /**\n         * Decorate list.\n         *\n         * @param {Array} list\n         * @private\n         */\n        _decorate: function (list) {\n\n            if (list.length) {\n                list[0].first = true;\n            }\n\n            if (list.length > 1) {\n                list[list.length - 1].last = true;\n            }\n        }\n    });\n\n    return $.mage.breadcrumbs;\n});\n","Magento_Theme/js/view/add-home-breadcrumb.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/* eslint-disable max-nested-callbacks, no-undef */\ndefine([\n    'jquery',\n    'Magento_Theme/js/model/breadcrumb-list',\n    'mage/translate'\n], function ($, breadcrumbList) {\n    'use strict';\n\n    /**\n     * @return {Object}\n     */\n    var homeCrumb = function () {\n        return {\n            name: 'home',\n            label: $.mage.__('Home'),\n            title: $.mage.__('Go to Home Page'),\n            link: BASE_URL || ''\n        };\n    };\n\n    return function (breadcrumb) {\n\n        breadcrumbList.unshift(homeCrumb());\n\n        return breadcrumb;\n    };\n});\n","Magento_Theme/js/view/messages.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'uiComponent',\n    'Magento_Customer/js/customer-data',\n    'underscore',\n    'escaper',\n    'jquery/jquery-storageapi'\n], function ($, Component, customerData, _, escaper) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            cookieMessages: [],\n            messages: [],\n            allowedTags: ['div', 'span', 'b', 'strong', 'i', 'em', 'u', 'a']\n        },\n\n        /**\n         * Extends Component object by storage observable messages.\n         */\n        initialize: function () {\n            this._super();\n\n            this.cookieMessages = _.unique($.cookieStorage.get('mage-messages'), 'text');\n            this.messages = customerData.get('messages').extend({\n                disposableCustomerData: 'messages'\n            });\n\n            // Force to clean obsolete messages\n            if (!_.isEmpty(this.messages().messages)) {\n                customerData.set('messages', {});\n            }\n\n            $.mage.cookies.set('mage-messages', '', {\n                samesite: 'strict',\n                domain: ''\n            });\n        },\n\n        /**\n         * Prepare the given message to be rendered as HTML\n         *\n         * @param {String} message\n         * @return {String}\n         */\n        prepareMessageForHtml: function (message) {\n            return escaper.escapeHtml(message, this.allowedTags);\n        }\n    });\n});\n","Magento_ReCaptchaWebapiUi/js/webapiReCaptchaRegistry.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return {\n        /**\n         * recaptchaId: token map.\n         *\n         * Tokens for already verified recaptcha.\n         */\n        tokens: {},\n\n        /**\n         * recaptchaId: triggerFn map.\n         *\n         * Call a trigger to initiate a recaptcha verification.\n         */\n        triggers: {},\n\n        /**\n         * recaptchaId: callback map\n         */\n        _listeners: {},\n\n        /**\n         * Add a listener to when the ReCaptcha finishes verification\n         * @param {String} id - ReCaptchaId\n         * @param {Function} func - Will be called back with the token\n         */\n        addListener: function (id, func) {\n            if (this.tokens.hasOwnProperty(id)) {\n                func(this.tokens[id]);\n            } else {\n                this._listeners[id] = func;\n            }\n        }\n    };\n});\n","Magento_ReCaptchaWebapiUi/js/jquery-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n// jscs:disable requireDotNotation\n\ndefine([\n    'mage/utils/wrapper'\n], function (wrapper) {\n    'use strict';\n\n    return function (jQuery) {\n        jQuery.ajax = wrapper.wrapSuper(jQuery.ajax, function () {\n            //Moving ReCaptcha value from payload to the header for requests to web API\n            var settings,\n                payload;\n\n            if (arguments.length !== 0) {\n                settings = arguments.length === 1 ? arguments[0] : arguments[1];\n            }\n\n            if (settings && settings.hasOwnProperty('data')) {\n                //The request has a body, trying to parse JSON data\n                try {\n                    payload = JSON.parse(settings.data);\n                } catch (e) {\n                    //Not JSON\n                }\n            }\n\n            if (payload && payload.hasOwnProperty('xReCaptchaValue')) {\n                if (!settings.hasOwnProperty('headers')) {\n                    settings.headers = {};\n                }\n                settings.headers['X-ReCaptcha'] = payload.xReCaptchaValue;\n                delete payload['xReCaptchaValue'];\n                settings.data = JSON.stringify(payload);\n            }\n\n            return this._super.apply(this, arguments);\n        });\n\n        return jQuery;\n    };\n});\n","Magento_ReCaptchaWebapiUi/js/webapiReCaptcha.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n// jscs:disable jsDoc\n\n/* global grecaptcha */\ndefine(\n    [\n        'Magento_ReCaptchaFrontendUi/js/reCaptcha',\n        'Magento_ReCaptchaWebapiUi/js/webapiReCaptchaRegistry'\n    ],\n    function (Component, registry) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                autoTrigger: false\n            },\n\n            /**\n             * Provide the token to the registry.\n             *\n             * @param {String} token\n             */\n            reCaptchaCallback: function (token) {\n                //Make the token retrievable in other UI components.\n                registry.tokens[this.getReCaptchaId()] = token;\n\n                if (typeof registry._listeners[this.getReCaptchaId()] !== 'undefined') {\n                    registry._listeners[this.getReCaptchaId()](token);\n                }\n            },\n\n            /**\n             * Register this ReCaptcha.\n             *\n             * @param {Object} parentForm\n             * @param {String} widgetId\n             */\n            initParentForm: function (parentForm, widgetId) {\n                var self = this,\n                    trigger;\n\n                if (this.getIsInvisibleRecaptcha()) {\n                    trigger = function () {\n                        grecaptcha.execute(widgetId);\n                    };\n                } else {\n                    trigger = function () {\n                        self.reCaptchaCallback(grecaptcha.getResponse(widgetId));\n                    };\n                }\n\n                if (this.autoTrigger) {\n                    //Validate ReCaptcha when initiated\n                    trigger();\n                    registry.triggers[this.getReCaptchaId()] = new Function();\n                } else {\n                    registry.triggers[this.getReCaptchaId()] = trigger;\n                }\n                this.tokenField = null;\n            }\n        });\n    }\n);\n","Magento_InventorySwatchesFrontendUi/js/swatch-renderer.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'configurableVariationQty',\n    'jquery-ui-modules/widget'\n], function ($, configurableVariationQty) {\n    'use strict';\n\n    return function (SwatchRenderer) {\n        $.widget('mage.SwatchRenderer', SwatchRenderer, {\n\n            /** @inheritdoc */\n            _OnClick: function ($this, widget) {\n                var salesChannel = this.options.jsonConfig.channel,\n                    salesChannelCode = this.options.jsonConfig.salesChannelCode,\n                    productVariationsSku = this.options.jsonConfig.sku;\n\n                this._super($this, widget);\n                configurableVariationQty(productVariationsSku[widget.getProductId()], salesChannel, salesChannelCode);\n            }\n        });\n\n        return $.mage.SwatchRenderer;\n    };\n});\n","Magento_InventoryConfigurableProductFrontendUi/js/configurable.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'configurableVariationQty',\n    'jquery-ui-modules/widget'\n], function ($, configurableVariationQty) {\n    'use strict';\n\n    return function (configurable) {\n        $.widget('mage.configurable', configurable, {\n\n            /** @inheritdoc */\n            _configureElement: function (element) {\n                var salesChannel = this.options.spConfig.channel,\n                    salesChannelCode = this.options.spConfig.salesChannelCode,\n                    productVariationsSku = this.options.spConfig.sku;\n\n                this._super(element);\n                configurableVariationQty(productVariationsSku[this.simpleProduct], salesChannel, salesChannelCode);\n            }\n        });\n\n        return $.mage.configurable;\n    };\n});\n","Magento_InventoryConfigurableProductFrontendUi/js/configurable-variation-qty.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * Configurable variation left qty.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'mage/url'\n], function ($, _, urlBuilder) {\n    'use strict';\n\n    return function (productSku, salesChannel, salesChannelCode) {\n        var selectorInfoStockSkuQty = '.availability.only',\n            selectorInfoStockSkuQtyValue = '.availability.only > strong',\n            productQtyInfoBlock = $(selectorInfoStockSkuQty),\n            productQtyInfo = $(selectorInfoStockSkuQtyValue);\n\n        if (!_.isUndefined(productSku) && productSku !== null) {\n            $.ajax({\n                url: urlBuilder.build('inventory_catalog/product/getQty/'),\n                dataType: 'json',\n                data: {\n                    'sku': productSku,\n                    'channel': salesChannel,\n                    'salesChannelCode': salesChannelCode\n                }\n            }).done(function (response) {\n                if (response.qty !== null && response.qty > 0) {\n                    productQtyInfo.text(response.qty);\n                    productQtyInfoBlock.show();\n                } else {\n                    productQtyInfoBlock.hide();\n                }\n            }).fail(function () {\n                productQtyInfoBlock.hide();\n            });\n        } else {\n            productQtyInfoBlock.hide();\n        }\n    };\n});\n"}
}});
