require.config({"config": {
        "jsbuild":{"jquery/ui-modules/datepicker.js":"/*!\n * jQuery UI Datepicker - v1.10.4\n * http://jqueryui.com\n *\n * Copyright 2014 jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * http://api.jqueryui.com/datepicker/\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/core',\n], function ($, undefined) {\n\n    $.extend($.ui, {datepicker: {version: \"1.10.4\"}});\n\n    var PROP_NAME = \"datepicker\",\n        instActive;\n\n    /* Date picker manager.\n       Use the singleton instance of this class, $.datepicker, to interact with the date picker.\n       Settings for (groups of) date pickers are maintained in an instance object,\n       allowing multiple different settings on the same page. */\n\n    function Datepicker() {\n        this._curInst = null; // The current instance in use\n        this._keyEvent = false; // If the last event was a key event\n        this._disabledInputs = []; // List of date picker inputs that have been disabled\n        this._datepickerShowing = false; // True if the popup picker is showing , false if not\n        this._inDialog = false; // True if showing within a \"dialog\", false if not\n        this._mainDivId = \"ui-datepicker-div\"; // The ID of the main datepicker division\n        this._inlineClass = \"ui-datepicker-inline\"; // The name of the inline marker class\n        this._appendClass = \"ui-datepicker-append\"; // The name of the append marker class\n        this._triggerClass = \"ui-datepicker-trigger\"; // The name of the trigger marker class\n        this._dialogClass = \"ui-datepicker-dialog\"; // The name of the dialog marker class\n        this._disableClass = \"ui-datepicker-disabled\"; // The name of the disabled covering marker class\n        this._unselectableClass = \"ui-datepicker-unselectable\"; // The name of the unselectable cell marker class\n        this._currentClass = \"ui-datepicker-current-day\"; // The name of the current day marker class\n        this._dayOverClass = \"ui-datepicker-days-cell-over\"; // The name of the day hover marker class\n        this.regional = []; // Available regional settings, indexed by language code\n        this.regional[\"\"] = { // Default regional settings\n            closeText: \"Done\", // Display text for close link\n            prevText: \"Prev\", // Display text for previous month link\n            nextText: \"Next\", // Display text for next month link\n            currentText: \"Today\", // Display text for current month link\n            monthNames: [\"January\", \"February\", \"March\", \"April\", \"May\", \"June\",\n                \"July\", \"August\", \"September\", \"October\", \"November\", \"December\"], // Names of months for drop-down and formatting\n            monthNamesShort: [\"Jan\", \"Feb\", \"Mar\", \"Apr\", \"May\", \"Jun\", \"Jul\", \"Aug\", \"Sep\", \"Oct\", \"Nov\", \"Dec\"], // For formatting\n            dayNames: [\"Sunday\", \"Monday\", \"Tuesday\", \"Wednesday\", \"Thursday\", \"Friday\", \"Saturday\"], // For formatting\n            dayNamesShort: [\"Sun\", \"Mon\", \"Tue\", \"Wed\", \"Thu\", \"Fri\", \"Sat\"], // For formatting\n            dayNamesMin: [\"Su\", \"Mo\", \"Tu\", \"We\", \"Th\", \"Fr\", \"Sa\"], // Column headings for days starting at Sunday\n            weekHeader: \"Wk\", // Column header for week of the year\n            dateFormat: \"mm/dd/yy\", // See format options on parseDate\n            firstDay: 0, // The first day of the week, Sun = 0, Mon = 1, ...\n            isRTL: false, // True if right-to-left language, false if left-to-right\n            showMonthAfterYear: false, // True if the year select precedes month, false for month then year\n            yearSuffix: \"\" // Additional text to append to the year in the month headers\n        };\n        this._defaults = { // Global defaults for all the date picker instances\n            showOn: \"focus\", // \"focus\" for popup on focus,\n            // \"button\" for trigger button, or \"both\" for either\n            showAnim: \"fadeIn\", // Name of jQuery animation for popup\n            showOptions: {}, // Options for enhanced animations\n            defaultDate: null, // Used when field is blank: actual date,\n            // +/-number for offset from today, null for today\n            appendText: \"\", // Display text following the input box, e.g. showing the format\n            buttonText: \"...\", // Text for trigger button\n            buttonImage: \"\", // URL for trigger button image\n            buttonImageOnly: false, // True if the image appears alone, false if it appears on a button\n            hideIfNoPrevNext: false, // True to hide next/previous month links\n            // if not applicable, false to just disable them\n            navigationAsDateFormat: false, // True if date formatting applied to prev/today/next links\n            gotoCurrent: false, // True if today link goes back to current selection instead\n            changeMonth: false, // True if month can be selected directly, false if only prev/next\n            changeYear: false, // True if year can be selected directly, false if only prev/next\n            yearRange: \"c-10:c+10\", // Range of years to display in drop-down,\n            // either relative to today's year (-nn:+nn), relative to currently displayed year\n            // (c-nn:c+nn), absolute (nnnn:nnnn), or a combination of the above (nnnn:-n)\n            showOtherMonths: false, // True to show dates in other months, false to leave blank\n            selectOtherMonths: false, // True to allow selection of dates in other months, false for unselectable\n            showWeek: false, // True to show week of the year, false to not show it\n            calculateWeek: this.iso8601Week, // How to calculate the week of the year,\n            // takes a Date and returns the number of the week for it\n            shortYearCutoff: \"+10\", // Short year values < this are in the current century,\n            // > this are in the previous century,\n            // string value starting with \"+\" for current year + value\n            minDate: null, // The earliest selectable date, or null for no limit\n            maxDate: null, // The latest selectable date, or null for no limit\n            duration: \"fast\", // Duration of display/closure\n            beforeShowDay: null, // Function that takes a date and returns an array with\n            // [0] = true if selectable, false if not, [1] = custom CSS class name(s) or \"\",\n            // [2] = cell title (optional), e.g. $.datepicker.noWeekends\n            beforeShow: null, // Function that takes an input field and\n            // returns a set of custom settings for the date picker\n            onSelect: null, // Define a callback function when a date is selected\n            onChangeMonthYear: null, // Define a callback function when the month or year is changed\n            onClose: null, // Define a callback function when the datepicker is closed\n            numberOfMonths: 1, // Number of months to show at a time\n            showCurrentAtPos: 0, // The position in multipe months at which to show the current month (starting at 0)\n            stepMonths: 1, // Number of months to step back/forward\n            stepBigMonths: 12, // Number of months to step back/forward for the big links\n            altField: \"\", // Selector for an alternate field to store selected dates into\n            altFormat: \"\", // The date format to use for the alternate field\n            constrainInput: true, // The input is constrained by the current date format\n            showButtonPanel: false, // True to show button panel, false to not show it\n            autoSize: false, // True to size the input for the date format, false to leave as is\n            disabled: false // The initial disabled state\n        };\n        $.extend(this._defaults, this.regional[\"\"]);\n        this.dpDiv = bindHover($(\"<div id='\" + this._mainDivId + \"' class='ui-datepicker ui-widget ui-widget-content ui-helper-clearfix ui-corner-all'></div>\"));\n    }\n\n    $.extend(Datepicker.prototype, {\n        /* Class name added to elements to indicate already configured with a date picker. */\n        markerClassName: \"hasDatepicker\",\n\n        //Keep track of the maximum number of rows displayed (see #7043)\n        maxRows: 4,\n\n        // TODO rename to \"widget\" when switching to widget factory\n        _widgetDatepicker: function () {\n            return this.dpDiv;\n        },\n\n        /* Override the default settings for all instances of the date picker.\n         * @param  settings  object - the new settings to use as defaults (anonymous object)\n         * @return the manager object\n         */\n        setDefaults: function (settings) {\n            extendRemove(this._defaults, settings || {});\n            return this;\n        },\n\n        /* Attach the date picker to a jQuery selection.\n         * @param  target\telement - the target input field or division or span\n         * @param  settings  object - the new settings to use for this date picker instance (anonymous)\n         */\n        _attachDatepicker: function (target, settings) {\n            var nodeName, inline, inst;\n            nodeName = target.nodeName.toLowerCase();\n            inline = (nodeName === \"div\" || nodeName === \"span\");\n            if (!target.id) {\n                this.uuid += 1;\n                target.id = \"dp\" + this.uuid;\n            }\n            inst = this._newInst($(target), inline);\n            inst.settings = $.extend({}, settings || {});\n            if (nodeName === \"input\") {\n                this._connectDatepicker(target, inst);\n            } else if (inline) {\n                this._inlineDatepicker(target, inst);\n            }\n        },\n\n        /* Create a new instance object. */\n        _newInst: function (target, inline) {\n            var id = target[0].id.replace(/([^A-Za-z0-9_\\-])/g, \"\\\\\\\\$1\"); // escape jQuery meta chars\n            return {\n                id: id, input: target, // associated target\n                selectedDay: 0, selectedMonth: 0, selectedYear: 0, // current selection\n                drawMonth: 0, drawYear: 0, // month being drawn\n                inline: inline, // is datepicker inline or not\n                dpDiv: (!inline ? this.dpDiv : // presentation div\n                    bindHover($(\"<div class='\" + this._inlineClass + \" ui-datepicker ui-widget ui-widget-content ui-helper-clearfix ui-corner-all'></div>\")))\n            };\n        },\n\n        /* Attach the date picker to an input field. */\n        _connectDatepicker: function (target, inst) {\n            var input = $(target);\n            inst.append = $([]);\n            inst.trigger = $([]);\n            if (input.hasClass(this.markerClassName)) {\n                return;\n            }\n            this._attachments(input, inst);\n            input.addClass(this.markerClassName).keydown(this._doKeyDown).keypress(this._doKeyPress).keyup(this._doKeyUp);\n            this._autoSize(inst);\n            $.data(target, PROP_NAME, inst);\n            //If disabled option is true, disable the datepicker once it has been attached to the input (see ticket #5665)\n            if (inst.settings.disabled) {\n                this._disableDatepicker(target);\n            }\n        },\n\n        /* Make attachments based on settings. */\n        _attachments: function (input, inst) {\n            var showOn, buttonText, buttonImage,\n                appendText = this._get(inst, \"appendText\"),\n                isRTL = this._get(inst, \"isRTL\");\n\n            if (inst.append) {\n                inst.append.remove();\n            }\n            if (appendText) {\n                inst.append = $(\"<span class='\" + this._appendClass + \"'>\" + appendText + \"</span>\");\n                input[isRTL ? \"before\" : \"after\"](inst.append);\n            }\n\n            input.unbind(\"focus\", this._showDatepicker);\n\n            if (inst.trigger) {\n                inst.trigger.remove();\n            }\n\n            showOn = this._get(inst, \"showOn\");\n            if (showOn === \"focus\" || showOn === \"both\") { // pop-up date picker when in the marked field\n                input.focus(this._showDatepicker);\n            }\n            if (showOn === \"button\" || showOn === \"both\") { // pop-up date picker when button clicked\n                buttonText = this._get(inst, \"buttonText\");\n                buttonImage = this._get(inst, \"buttonImage\");\n                inst.trigger = $(this._get(inst, \"buttonImageOnly\") ?\n                    $(\"<img/>\").addClass(this._triggerClass).attr({\n                        src: buttonImage,\n                        alt: buttonText,\n                        title: buttonText\n                    }) :\n                    $(\"<button type='button'></button>\").addClass(this._triggerClass).html(!buttonImage ? buttonText : $(\"<img/>\").attr(\n                        {src: buttonImage, alt: buttonText, title: buttonText})));\n                input[isRTL ? \"before\" : \"after\"](inst.trigger);\n                inst.trigger.click(function () {\n                    if ($.datepicker._datepickerShowing && $.datepicker._lastInput === input[0]) {\n                        $.datepicker._hideDatepicker();\n                    } else if ($.datepicker._datepickerShowing && $.datepicker._lastInput !== input[0]) {\n                        $.datepicker._hideDatepicker();\n                        $.datepicker._showDatepicker(input[0]);\n                    } else {\n                        $.datepicker._showDatepicker(input[0]);\n                    }\n                    return false;\n                });\n            }\n        },\n\n        /* Apply the maximum length for the date format. */\n        _autoSize: function (inst) {\n            if (this._get(inst, \"autoSize\") && !inst.inline) {\n                var findMax, max, maxI, i,\n                    date = new Date(2009, 12 - 1, 20), // Ensure double digits\n                    dateFormat = this._get(inst, \"dateFormat\");\n\n                if (dateFormat.match(/[DM]/)) {\n                    findMax = function (names) {\n                        max = 0;\n                        maxI = 0;\n                        for (i = 0; i < names.length; i++) {\n                            if (names[i].length > max) {\n                                max = names[i].length;\n                                maxI = i;\n                            }\n                        }\n                        return maxI;\n                    };\n                    date.setMonth(findMax(this._get(inst, (dateFormat.match(/MM/) ?\n                        \"monthNames\" : \"monthNamesShort\"))));\n                    date.setDate(findMax(this._get(inst, (dateFormat.match(/DD/) ?\n                        \"dayNames\" : \"dayNamesShort\"))) + 20 - date.getDay());\n                }\n                inst.input.attr(\"size\", this._formatDate(inst, date).length);\n            }\n        },\n\n        /* Attach an inline date picker to a div. */\n        _inlineDatepicker: function (target, inst) {\n            var divSpan = $(target);\n            if (divSpan.hasClass(this.markerClassName)) {\n                return;\n            }\n            divSpan.addClass(this.markerClassName).append(inst.dpDiv);\n            $.data(target, PROP_NAME, inst);\n            this._setDate(inst, this._getDefaultDate(inst), true);\n            this._updateDatepicker(inst);\n            this._updateAlternate(inst);\n            //If disabled option is true, disable the datepicker before showing it (see ticket #5665)\n            if (inst.settings.disabled) {\n                this._disableDatepicker(target);\n            }\n            // Set display:block in place of inst.dpDiv.show() which won't work on disconnected elements\n            // http://bugs.jqueryui.com/ticket/7552 - A Datepicker created on a detached div has zero height\n            inst.dpDiv.css(\"display\", \"block\");\n        },\n\n        /* Pop-up the date picker in a \"dialog\" box.\n         * @param  input element - ignored\n         * @param  date\tstring or Date - the initial date to display\n         * @param  onSelect  function - the function to call when a date is selected\n         * @param  settings  object - update the dialog date picker instance's settings (anonymous object)\n         * @param  pos int[2] - coordinates for the dialog's position within the screen or\n         *\t\t\t\t\tevent - with x/y coordinates or\n         *\t\t\t\t\tleave empty for default (screen centre)\n         * @return the manager object\n         */\n        _dialogDatepicker: function (input, date, onSelect, settings, pos) {\n            var id, browserWidth, browserHeight, scrollX, scrollY,\n                inst = this._dialogInst; // internal instance\n\n            if (!inst) {\n                this.uuid += 1;\n                id = \"dp\" + this.uuid;\n                this._dialogInput = $(\"<input type='text' id='\" + id +\n                    \"' style='position: absolute; top: -100px; width: 0px;'/>\");\n                this._dialogInput.keydown(this._doKeyDown);\n                $(\"body\").append(this._dialogInput);\n                inst = this._dialogInst = this._newInst(this._dialogInput, false);\n                inst.settings = {};\n                $.data(this._dialogInput[0], PROP_NAME, inst);\n            }\n            extendRemove(inst.settings, settings || {});\n            date = (date && date.constructor === Date ? this._formatDate(inst, date) : date);\n            this._dialogInput.val(date);\n\n            this._pos = (pos ? (pos.length ? pos : [pos.pageX, pos.pageY]) : null);\n            if (!this._pos) {\n                browserWidth = document.documentElement.clientWidth;\n                browserHeight = document.documentElement.clientHeight;\n                scrollX = document.documentElement.scrollLeft || document.body.scrollLeft;\n                scrollY = document.documentElement.scrollTop || document.body.scrollTop;\n                this._pos = // should use actual width/height below\n                    [(browserWidth / 2) - 100 + scrollX, (browserHeight / 2) - 150 + scrollY];\n            }\n\n            // move input on screen for focus, but hidden behind dialog\n            this._dialogInput.css(\"left\", (this._pos[0] + 20) + \"px\").css(\"top\", this._pos[1] + \"px\");\n            inst.settings.onSelect = onSelect;\n            this._inDialog = true;\n            this.dpDiv.addClass(this._dialogClass);\n            this._showDatepicker(this._dialogInput[0]);\n            if ($.blockUI) {\n                $.blockUI(this.dpDiv);\n            }\n            $.data(this._dialogInput[0], PROP_NAME, inst);\n            return this;\n        },\n\n        /* Detach a datepicker from its control.\n         * @param  target\telement - the target input field or division or span\n         */\n        _destroyDatepicker: function (target) {\n            var nodeName,\n                $target = $(target),\n                inst = $.data(target, PROP_NAME);\n\n            if (!$target.hasClass(this.markerClassName)) {\n                return;\n            }\n\n            nodeName = target.nodeName.toLowerCase();\n            $.removeData(target, PROP_NAME);\n            if (nodeName === \"input\") {\n                inst.append.remove();\n                inst.trigger.remove();\n                $target.removeClass(this.markerClassName).unbind(\"focus\", this._showDatepicker).unbind(\"keydown\", this._doKeyDown).unbind(\"keypress\", this._doKeyPress).unbind(\"keyup\", this._doKeyUp);\n            } else if (nodeName === \"div\" || nodeName === \"span\") {\n                $target.removeClass(this.markerClassName).empty();\n            }\n        },\n\n        /* Enable the date picker to a jQuery selection.\n         * @param  target\telement - the target input field or division or span\n         */\n        _enableDatepicker: function (target) {\n            var nodeName, inline,\n                $target = $(target),\n                inst = $.data(target, PROP_NAME);\n\n            if (!$target.hasClass(this.markerClassName)) {\n                return;\n            }\n\n            nodeName = target.nodeName.toLowerCase();\n            if (nodeName === \"input\") {\n                target.disabled = false;\n                inst.trigger.filter(\"button\").each(function () {\n                    this.disabled = false;\n                }).end().filter(\"img\").css({opacity: \"1.0\", cursor: \"\"});\n            } else if (nodeName === \"div\" || nodeName === \"span\") {\n                inline = $target.children(\".\" + this._inlineClass);\n                inline.children().removeClass(\"ui-state-disabled\");\n                inline.find(\"select.ui-datepicker-month, select.ui-datepicker-year\").prop(\"disabled\", false);\n            }\n            this._disabledInputs = $.map(this._disabledInputs,\n                function (value) {\n                    return (value === target ? null : value);\n                }); // delete entry\n        },\n\n        /* Disable the date picker to a jQuery selection.\n         * @param  target\telement - the target input field or division or span\n         */\n        _disableDatepicker: function (target) {\n            var nodeName, inline,\n                $target = $(target),\n                inst = $.data(target, PROP_NAME);\n\n            if (!$target.hasClass(this.markerClassName)) {\n                return;\n            }\n\n            nodeName = target.nodeName.toLowerCase();\n            if (nodeName === \"input\") {\n                target.disabled = true;\n                inst.trigger.filter(\"button\").each(function () {\n                    this.disabled = true;\n                }).end().filter(\"img\").css({opacity: \"0.5\", cursor: \"default\"});\n            } else if (nodeName === \"div\" || nodeName === \"span\") {\n                inline = $target.children(\".\" + this._inlineClass);\n                inline.children().addClass(\"ui-state-disabled\");\n                inline.find(\"select.ui-datepicker-month, select.ui-datepicker-year\").prop(\"disabled\", true);\n            }\n            this._disabledInputs = $.map(this._disabledInputs,\n                function (value) {\n                    return (value === target ? null : value);\n                }); // delete entry\n            this._disabledInputs[this._disabledInputs.length] = target;\n        },\n\n        /* Is the first field in a jQuery collection disabled as a datepicker?\n         * @param  target\telement - the target input field or division or span\n         * @return boolean - true if disabled, false if enabled\n         */\n        _isDisabledDatepicker: function (target) {\n            if (!target) {\n                return false;\n            }\n            for (var i = 0; i < this._disabledInputs.length; i++) {\n                if (this._disabledInputs[i] === target) {\n                    return true;\n                }\n            }\n            return false;\n        },\n\n        /* Retrieve the instance data for the target control.\n         * @param  target  element - the target input field or division or span\n         * @return  object - the associated instance data\n         * @throws  error if a jQuery problem getting data\n         */\n        _getInst: function (target) {\n            try {\n                return $.data(target, PROP_NAME);\n            } catch (err) {\n                throw \"Missing instance data for this datepicker\";\n            }\n        },\n\n        /* Update or retrieve the settings for a date picker attached to an input field or division.\n         * @param  target  element - the target input field or division or span\n         * @param  name\tobject - the new settings to update or\n         *\t\t\t\tstring - the name of the setting to change or retrieve,\n         *\t\t\t\twhen retrieving also \"all\" for all instance settings or\n         *\t\t\t\t\"defaults\" for all global defaults\n         * @param  value   any - the new value for the setting\n         *\t\t\t\t(omit if above is an object or to retrieve a value)\n         */\n        _optionDatepicker: function (target, name, value) {\n            var settings, date, minDate, maxDate,\n                inst = this._getInst(target);\n\n            if (arguments.length === 2 && typeof name === \"string\") {\n                return (name === \"defaults\" ? $.extend({}, $.datepicker._defaults) :\n                    (inst ? (name === \"all\" ? $.extend({}, inst.settings) :\n                        this._get(inst, name)) : null));\n            }\n\n            settings = name || {};\n            if (typeof name === \"string\") {\n                settings = {};\n                settings[name] = value;\n            }\n\n            if (inst) {\n                if (this._curInst === inst) {\n                    this._hideDatepicker();\n                }\n\n                date = this._getDateDatepicker(target, true);\n                minDate = this._getMinMaxDate(inst, \"min\");\n                maxDate = this._getMinMaxDate(inst, \"max\");\n                extendRemove(inst.settings, settings);\n                // reformat the old minDate/maxDate values if dateFormat changes and a new minDate/maxDate isn't provided\n                if (minDate !== null && settings.dateFormat !== undefined && settings.minDate === undefined) {\n                    inst.settings.minDate = this._formatDate(inst, minDate);\n                }\n                if (maxDate !== null && settings.dateFormat !== undefined && settings.maxDate === undefined) {\n                    inst.settings.maxDate = this._formatDate(inst, maxDate);\n                }\n                if (\"disabled\" in settings) {\n                    if (settings.disabled) {\n                        this._disableDatepicker(target);\n                    } else {\n                        this._enableDatepicker(target);\n                    }\n                }\n                this._attachments($(target), inst);\n                this._autoSize(inst);\n                this._setDate(inst, date);\n                this._updateAlternate(inst);\n                this._updateDatepicker(inst);\n            }\n        },\n\n        // change method deprecated\n        _changeDatepicker: function (target, name, value) {\n            this._optionDatepicker(target, name, value);\n        },\n\n        /* Redraw the date picker attached to an input field or division.\n         * @param  target  element - the target input field or division or span\n         */\n        _refreshDatepicker: function (target) {\n            var inst = this._getInst(target);\n            if (inst) {\n                this._updateDatepicker(inst);\n            }\n        },\n\n        /* Set the dates for a jQuery selection.\n         * @param  target element - the target input field or division or span\n         * @param  date\tDate - the new date\n         */\n        _setDateDatepicker: function (target, date) {\n            var inst = this._getInst(target);\n            if (inst) {\n                this._setDate(inst, date);\n                this._updateDatepicker(inst);\n                this._updateAlternate(inst);\n            }\n        },\n\n        /* Get the date(s) for the first entry in a jQuery selection.\n         * @param  target element - the target input field or division or span\n         * @param  noDefault boolean - true if no default date is to be used\n         * @return Date - the current date\n         */\n        _getDateDatepicker: function (target, noDefault) {\n            var inst = this._getInst(target);\n            if (inst && !inst.inline) {\n                this._setDateFromField(inst, noDefault);\n            }\n            return (inst ? this._getDate(inst) : null);\n        },\n\n        /* Handle keystrokes. */\n        _doKeyDown: function (event) {\n            var onSelect, dateStr, sel,\n                inst = $.datepicker._getInst(event.target),\n                handled = true,\n                isRTL = inst.dpDiv.is(\".ui-datepicker-rtl\");\n\n            inst._keyEvent = true;\n            if ($.datepicker._datepickerShowing) {\n                switch (event.keyCode) {\n                    case 9:\n                        $.datepicker._hideDatepicker();\n                        handled = false;\n                        break; // hide on tab out\n                    case 13:\n                        sel = $(\"td.\" + $.datepicker._dayOverClass + \":not(.\" +\n                            $.datepicker._currentClass + \")\", inst.dpDiv);\n                        if (sel[0]) {\n                            $.datepicker._selectDay(event.target, inst.selectedMonth, inst.selectedYear, sel[0]);\n                        }\n\n                        onSelect = $.datepicker._get(inst, \"onSelect\");\n                        if (onSelect) {\n                            dateStr = $.datepicker._formatDate(inst);\n\n                            // trigger custom callback\n                            onSelect.apply((inst.input ? inst.input[0] : null), [dateStr, inst]);\n                        } else {\n                            $.datepicker._hideDatepicker();\n                        }\n\n                        return false; // don't submit the form\n                    case 27:\n                        $.datepicker._hideDatepicker();\n                        break; // hide on escape\n                    case 33:\n                        $.datepicker._adjustDate(event.target, (event.ctrlKey ?\n                            -$.datepicker._get(inst, \"stepBigMonths\") :\n                            -$.datepicker._get(inst, \"stepMonths\")), \"M\");\n                        break; // previous month/year on page up/+ ctrl\n                    case 34:\n                        $.datepicker._adjustDate(event.target, (event.ctrlKey ?\n                            +$.datepicker._get(inst, \"stepBigMonths\") :\n                            +$.datepicker._get(inst, \"stepMonths\")), \"M\");\n                        break; // next month/year on page down/+ ctrl\n                    case 35:\n                        if (event.ctrlKey || event.metaKey) {\n                            $.datepicker._clearDate(event.target);\n                        }\n                        handled = event.ctrlKey || event.metaKey;\n                        break; // clear on ctrl or command +end\n                    case 36:\n                        if (event.ctrlKey || event.metaKey) {\n                            $.datepicker._gotoToday(event.target);\n                        }\n                        handled = event.ctrlKey || event.metaKey;\n                        break; // current on ctrl or command +home\n                    case 37:\n                        if (event.ctrlKey || event.metaKey) {\n                            $.datepicker._adjustDate(event.target, (isRTL ? +1 : -1), \"D\");\n                        }\n                        handled = event.ctrlKey || event.metaKey;\n                        // -1 day on ctrl or command +left\n                        if (event.originalEvent.altKey) {\n                            $.datepicker._adjustDate(event.target, (event.ctrlKey ?\n                                -$.datepicker._get(inst, \"stepBigMonths\") :\n                                -$.datepicker._get(inst, \"stepMonths\")), \"M\");\n                        }\n                        // next month/year on alt +left on Mac\n                        break;\n                    case 38:\n                        if (event.ctrlKey || event.metaKey) {\n                            $.datepicker._adjustDate(event.target, -7, \"D\");\n                        }\n                        handled = event.ctrlKey || event.metaKey;\n                        break; // -1 week on ctrl or command +up\n                    case 39:\n                        if (event.ctrlKey || event.metaKey) {\n                            $.datepicker._adjustDate(event.target, (isRTL ? -1 : +1), \"D\");\n                        }\n                        handled = event.ctrlKey || event.metaKey;\n                        // +1 day on ctrl or command +right\n                        if (event.originalEvent.altKey) {\n                            $.datepicker._adjustDate(event.target, (event.ctrlKey ?\n                                +$.datepicker._get(inst, \"stepBigMonths\") :\n                                +$.datepicker._get(inst, \"stepMonths\")), \"M\");\n                        }\n                        // next month/year on alt +right\n                        break;\n                    case 40:\n                        if (event.ctrlKey || event.metaKey) {\n                            $.datepicker._adjustDate(event.target, +7, \"D\");\n                        }\n                        handled = event.ctrlKey || event.metaKey;\n                        break; // +1 week on ctrl or command +down\n                    default:\n                        handled = false;\n                }\n            } else if (event.keyCode === 36 && event.ctrlKey) { // display the date picker on ctrl+home\n                $.datepicker._showDatepicker(this);\n            } else {\n                handled = false;\n            }\n\n            if (handled) {\n                event.preventDefault();\n                event.stopPropagation();\n            }\n        },\n\n        /* Filter entered characters - based on date format. */\n        _doKeyPress: function (event) {\n            var chars, chr,\n                inst = $.datepicker._getInst(event.target);\n\n            if ($.datepicker._get(inst, \"constrainInput\")) {\n                chars = $.datepicker._possibleChars($.datepicker._get(inst, \"dateFormat\"));\n                chr = String.fromCharCode(event.charCode == null ? event.keyCode : event.charCode);\n                return event.ctrlKey || event.metaKey || (chr < \" \" || !chars || chars.indexOf(chr) > -1);\n            }\n        },\n\n        /* Synchronise manual entry and field/alternate field. */\n        _doKeyUp: function (event) {\n            var date,\n                inst = $.datepicker._getInst(event.target);\n\n            if (inst.input.val() !== inst.lastVal) {\n                try {\n                    date = $.datepicker.parseDate($.datepicker._get(inst, \"dateFormat\"),\n                        (inst.input ? inst.input.val() : null),\n                        $.datepicker._getFormatConfig(inst));\n\n                    if (date) { // only if valid\n                        $.datepicker._setDateFromField(inst);\n                        $.datepicker._updateAlternate(inst);\n                        $.datepicker._updateDatepicker(inst);\n                    }\n                } catch (err) {\n                }\n            }\n            return true;\n        },\n\n        /* Pop-up the date picker for a given input field.\n         * If false returned from beforeShow event handler do not show.\n         * @param  input  element - the input field attached to the date picker or\n         *\t\t\t\t\tevent - if triggered by focus\n         */\n        _showDatepicker: function (input) {\n            input = input.target || input;\n            if (input.nodeName.toLowerCase() !== \"input\") { // find from button/image trigger\n                input = $(\"input\", input.parentNode)[0];\n            }\n\n            if ($.datepicker._isDisabledDatepicker(input) || $.datepicker._lastInput === input) { // already here\n                return;\n            }\n\n            var inst, beforeShow, beforeShowSettings, isFixed,\n                offset, showAnim, duration;\n\n            inst = $.datepicker._getInst(input);\n            if ($.datepicker._curInst && $.datepicker._curInst !== inst) {\n                $.datepicker._curInst.dpDiv.stop(true, true);\n                if (inst && $.datepicker._datepickerShowing) {\n                    $.datepicker._hideDatepicker($.datepicker._curInst.input[0]);\n                }\n            }\n\n            beforeShow = $.datepicker._get(inst, \"beforeShow\");\n            beforeShowSettings = beforeShow ? beforeShow.apply(input, [input, inst]) : {};\n            if (beforeShowSettings === false) {\n                return;\n            }\n            extendRemove(inst.settings, beforeShowSettings);\n\n            inst.lastVal = null;\n            $.datepicker._lastInput = input;\n            $.datepicker._setDateFromField(inst);\n\n            if ($.datepicker._inDialog) { // hide cursor\n                input.value = \"\";\n            }\n            if (!$.datepicker._pos) { // position below input\n                $.datepicker._pos = $.datepicker._findPos(input);\n                $.datepicker._pos[1] += input.offsetHeight; // add the height\n            }\n\n            isFixed = false;\n            $(input).parents().each(function () {\n                isFixed |= $(this).css(\"position\") === \"fixed\";\n                return !isFixed;\n            });\n\n            offset = {left: $.datepicker._pos[0], top: $.datepicker._pos[1]};\n            $.datepicker._pos = null;\n            //to avoid flashes on Firefox\n            inst.dpDiv.empty();\n            // determine sizing offscreen\n            inst.dpDiv.css({position: \"absolute\", display: \"block\", top: \"-1000px\"});\n            $.datepicker._updateDatepicker(inst);\n            // fix width for dynamic number of date pickers\n            // and adjust position before showing\n            offset = $.datepicker._checkOffset(inst, offset, isFixed);\n            inst.dpDiv.css({\n                position: ($.datepicker._inDialog && $.blockUI ?\n                    \"static\" : (isFixed ? \"fixed\" : \"absolute\")), display: \"none\",\n                left: offset.left + \"px\", top: offset.top + \"px\"\n            });\n\n            if (!inst.inline) {\n                showAnim = $.datepicker._get(inst, \"showAnim\");\n                duration = $.datepicker._get(inst, \"duration\");\n                inst.dpDiv.zIndex($(input).zIndex() + 1);\n                $.datepicker._datepickerShowing = true;\n\n                if ($.effects && $.effects.effect[showAnim]) {\n                    inst.dpDiv.show(showAnim, $.datepicker._get(inst, \"showOptions\"), duration);\n                } else {\n                    inst.dpDiv[showAnim || \"show\"](showAnim ? duration : null);\n                }\n\n                if ($.datepicker._shouldFocusInput(inst)) {\n                    inst.input.focus();\n                }\n\n                $.datepicker._curInst = inst;\n            }\n        },\n\n        /* Generate the date picker content. */\n        _updateDatepicker: function (inst) {\n            this.maxRows = 4; //Reset the max number of rows being displayed (see #7043)\n            instActive = inst; // for delegate hover events\n            inst.dpDiv.empty().append(this._generateHTML(inst));\n            this._attachHandlers(inst);\n            inst.dpDiv.find(\".\" + this._dayOverClass + \" a\").mouseover();\n\n            var origyearshtml,\n                numMonths = this._getNumberOfMonths(inst),\n                cols = numMonths[1],\n                width = 17;\n\n            inst.dpDiv.removeClass(\"ui-datepicker-multi-2 ui-datepicker-multi-3 ui-datepicker-multi-4\").width(\"\");\n            if (cols > 1) {\n                inst.dpDiv.addClass(\"ui-datepicker-multi-\" + cols).css(\"width\", (width * cols) + \"em\");\n            }\n            inst.dpDiv[(numMonths[0] !== 1 || numMonths[1] !== 1 ? \"add\" : \"remove\") +\n            \"Class\"](\"ui-datepicker-multi\");\n            inst.dpDiv[(this._get(inst, \"isRTL\") ? \"add\" : \"remove\") +\n            \"Class\"](\"ui-datepicker-rtl\");\n\n            if (inst === $.datepicker._curInst && $.datepicker._datepickerShowing && $.datepicker._shouldFocusInput(inst)) {\n                inst.input.focus();\n            }\n\n            // deffered render of the years select (to avoid flashes on Firefox)\n            if (inst.yearshtml) {\n                origyearshtml = inst.yearshtml;\n                setTimeout(function () {\n                    //assure that inst.yearshtml didn't change.\n                    if (origyearshtml === inst.yearshtml && inst.yearshtml) {\n                        inst.dpDiv.find(\"select.ui-datepicker-year:first\").replaceWith(inst.yearshtml);\n                    }\n                    origyearshtml = inst.yearshtml = null;\n                }, 0);\n            }\n        },\n\n        // #6694 - don't focus the input if it's already focused\n        // this breaks the change event in IE\n        // Support: IE and jQuery <1.9\n        _shouldFocusInput: function (inst) {\n            return inst.input && inst.input.is(\":visible\") && !inst.input.is(\":disabled\") && !inst.input.is(\":focus\");\n        },\n\n        /* Check positioning to remain on screen. */\n        _checkOffset: function (inst, offset, isFixed) {\n            var dpWidth = inst.dpDiv.outerWidth(),\n                dpHeight = inst.dpDiv.outerHeight(),\n                inputWidth = inst.input ? inst.input.outerWidth() : 0,\n                inputHeight = inst.input ? inst.input.outerHeight() : 0,\n                viewWidth = document.documentElement.clientWidth + (isFixed ? 0 : $(document).scrollLeft()),\n                viewHeight = document.documentElement.clientHeight + (isFixed ? 0 : $(document).scrollTop());\n\n            offset.left -= (this._get(inst, \"isRTL\") ? (dpWidth - inputWidth) : 0);\n            offset.left -= (isFixed && offset.left === inst.input.offset().left) ? $(document).scrollLeft() : 0;\n            offset.top -= (isFixed && offset.top === (inst.input.offset().top + inputHeight)) ? $(document).scrollTop() : 0;\n\n            // now check if datepicker is showing outside window viewport - move to a better place if so.\n            offset.left -= Math.min(offset.left, (offset.left + dpWidth > viewWidth && viewWidth > dpWidth) ?\n                Math.abs(offset.left + dpWidth - viewWidth) : 0);\n            offset.top -= Math.min(offset.top, (offset.top + dpHeight > viewHeight && viewHeight > dpHeight) ?\n                Math.abs(dpHeight + inputHeight) : 0);\n\n            return offset;\n        },\n\n        /* Find an object's position on the screen. */\n        _findPos: function (obj) {\n            var position,\n                inst = this._getInst(obj),\n                isRTL = this._get(inst, \"isRTL\");\n\n            while (obj && (obj.type === \"hidden\" || obj.nodeType !== 1 || $.expr.filters.hidden(obj))) {\n                obj = obj[isRTL ? \"previousSibling\" : \"nextSibling\"];\n            }\n\n            position = $(obj).offset();\n            return [position.left, position.top];\n        },\n\n        /* Hide the date picker from view.\n         * @param  input  element - the input field attached to the date picker\n         */\n        _hideDatepicker: function (input) {\n            var showAnim, duration, postProcess, onClose,\n                inst = this._curInst;\n\n            if (!inst || (input && inst !== $.data(input, PROP_NAME))) {\n                return;\n            }\n\n            if (this._datepickerShowing) {\n                showAnim = this._get(inst, \"showAnim\");\n                duration = this._get(inst, \"duration\");\n                postProcess = function () {\n                    $.datepicker._tidyDialog(inst);\n                };\n\n                // DEPRECATED: after BC for 1.8.x $.effects[ showAnim ] is not needed\n                if ($.effects && ($.effects.effect[showAnim] || $.effects[showAnim])) {\n                    inst.dpDiv.hide(showAnim, $.datepicker._get(inst, \"showOptions\"), duration, postProcess);\n                } else {\n                    inst.dpDiv[(showAnim === \"slideDown\" ? \"slideUp\" :\n                        (showAnim === \"fadeIn\" ? \"fadeOut\" : \"hide\"))]((showAnim ? duration : null), postProcess);\n                }\n\n                if (!showAnim) {\n                    postProcess();\n                }\n                this._datepickerShowing = false;\n\n                onClose = this._get(inst, \"onClose\");\n                if (onClose) {\n                    onClose.apply((inst.input ? inst.input[0] : null), [(inst.input ? inst.input.val() : \"\"), inst]);\n                }\n\n                this._lastInput = null;\n                if (this._inDialog) {\n                    this._dialogInput.css({position: \"absolute\", left: \"0\", top: \"-100px\"});\n                    if ($.blockUI) {\n                        $.unblockUI();\n                        $(\"body\").append(this.dpDiv);\n                    }\n                }\n                this._inDialog = false;\n            }\n        },\n\n        /* Tidy up after a dialog display. */\n        _tidyDialog: function (inst) {\n            inst.dpDiv.removeClass(this._dialogClass).unbind(\".ui-datepicker-calendar\");\n        },\n\n        /* Close date picker if clicked elsewhere. */\n        _checkExternalClick: function (event) {\n            if (!$.datepicker._curInst) {\n                return;\n            }\n\n            var $target = $(event.target),\n                inst = $.datepicker._getInst($target[0]);\n\n            if ((($target[0].id !== $.datepicker._mainDivId &&\n                $target.parents(\"#\" + $.datepicker._mainDivId).length === 0 &&\n                !$target.hasClass($.datepicker.markerClassName) &&\n                !$target.closest(\".\" + $.datepicker._triggerClass).length &&\n                $.datepicker._datepickerShowing && !($.datepicker._inDialog && $.blockUI))) ||\n                ($target.hasClass($.datepicker.markerClassName) && $.datepicker._curInst !== inst)) {\n                $.datepicker._hideDatepicker();\n            }\n        },\n\n        /* Adjust one of the date sub-fields. */\n        _adjustDate: function (id, offset, period) {\n            var target = $(id),\n                inst = this._getInst(target[0]);\n\n            if (this._isDisabledDatepicker(target[0])) {\n                return;\n            }\n            this._adjustInstDate(inst, offset +\n                (period === \"M\" ? this._get(inst, \"showCurrentAtPos\") : 0), // undo positioning\n                period);\n            this._updateDatepicker(inst);\n        },\n\n        /* Action for current link. */\n        _gotoToday: function (id) {\n            var date,\n                target = $(id),\n                inst = this._getInst(target[0]);\n\n            if (this._get(inst, \"gotoCurrent\") && inst.currentDay) {\n                inst.selectedDay = inst.currentDay;\n                inst.drawMonth = inst.selectedMonth = inst.currentMonth;\n                inst.drawYear = inst.selectedYear = inst.currentYear;\n            } else {\n                date = new Date();\n                inst.selectedDay = date.getDate();\n                inst.drawMonth = inst.selectedMonth = date.getMonth();\n                inst.drawYear = inst.selectedYear = date.getFullYear();\n            }\n            this._notifyChange(inst);\n            this._adjustDate(target);\n        },\n\n        /* Action for selecting a new month/year. */\n        _selectMonthYear: function (id, select, period) {\n            var target = $(id),\n                inst = this._getInst(target[0]);\n\n            inst[\"selected\" + (period === \"M\" ? \"Month\" : \"Year\")] =\n                inst[\"draw\" + (period === \"M\" ? \"Month\" : \"Year\")] =\n                    parseInt(select.options[select.selectedIndex].value, 10);\n\n            this._notifyChange(inst);\n            this._adjustDate(target);\n        },\n\n        /* Action for selecting a day. */\n        _selectDay: function (id, month, year, td) {\n            var inst,\n                target = $(id);\n\n            if ($(td).hasClass(this._unselectableClass) || this._isDisabledDatepicker(target[0])) {\n                return;\n            }\n\n            inst = this._getInst(target[0]);\n            inst.selectedDay = inst.currentDay = $(\"a\", td).html();\n            inst.selectedMonth = inst.currentMonth = month;\n            inst.selectedYear = inst.currentYear = year;\n            this._selectDate(id, this._formatDate(inst,\n                inst.currentDay, inst.currentMonth, inst.currentYear));\n        },\n\n        /* Erase the input field and hide the date picker. */\n        _clearDate: function (id) {\n            var target = $(id);\n            this._selectDate(target, \"\");\n        },\n\n        /* Update the input field with the selected date. */\n        _selectDate: function (id, dateStr) {\n            var onSelect,\n                target = $(id),\n                inst = this._getInst(target[0]);\n\n            dateStr = (dateStr != null ? dateStr : this._formatDate(inst));\n            if (inst.input) {\n                inst.input.val(dateStr);\n            }\n            this._updateAlternate(inst);\n\n            onSelect = this._get(inst, \"onSelect\");\n            if (onSelect) {\n                onSelect.apply((inst.input ? inst.input[0] : null), [dateStr, inst]);  // trigger custom callback\n            } else if (inst.input) {\n                inst.input.trigger(\"change\"); // fire the change event\n            }\n\n            if (inst.inline) {\n                this._updateDatepicker(inst);\n            } else {\n                this._hideDatepicker();\n                this._lastInput = inst.input[0];\n                if (typeof (inst.input[0]) !== \"object\") {\n                    inst.input.focus(); // restore focus\n                }\n                this._lastInput = null;\n            }\n        },\n\n        /* Update any alternate field to synchronise with the main field. */\n        _updateAlternate: function (inst) {\n            var altFormat, date, dateStr,\n                altField = this._get(inst, \"altField\");\n\n            if (altField) { // update alternate field too\n                altFormat = this._get(inst, \"altFormat\") || this._get(inst, \"dateFormat\");\n                date = this._getDate(inst);\n                dateStr = this.formatDate(altFormat, date, this._getFormatConfig(inst));\n                $(altField).each(function () {\n                    $(this).val(dateStr);\n                });\n            }\n        },\n\n        /* Set as beforeShowDay function to prevent selection of weekends.\n         * @param  date  Date - the date to customise\n         * @return [boolean, string] - is this date selectable?, what is its CSS class?\n         */\n        noWeekends: function (date) {\n            var day = date.getDay();\n            return [(day > 0 && day < 6), \"\"];\n        },\n\n        /* Set as calculateWeek to determine the week of the year based on the ISO 8601 definition.\n         * @param  date  Date - the date to get the week for\n         * @return  number - the number of the week within the year that contains this date\n         */\n        iso8601Week: function (date) {\n            var time,\n                checkDate = new Date(date.getTime());\n\n            // Find Thursday of this week starting on Monday\n            checkDate.setDate(checkDate.getDate() + 4 - (checkDate.getDay() || 7));\n\n            time = checkDate.getTime();\n            checkDate.setMonth(0); // Compare with Jan 1\n            checkDate.setDate(1);\n            return Math.floor(Math.round((time - checkDate) / 86400000) / 7) + 1;\n        },\n\n        /* Parse a string value into a date object.\n         * See formatDate below for the possible formats.\n         *\n         * @param  format string - the expected format of the date\n         * @param  value string - the date in the above format\n         * @param  settings Object - attributes include:\n         *\t\t\t\t\tshortYearCutoff  number - the cutoff year for determining the century (optional)\n         *\t\t\t\t\tdayNamesShort\tstring[7] - abbreviated names of the days from Sunday (optional)\n         *\t\t\t\t\tdayNames\t\tstring[7] - names of the days from Sunday (optional)\n         *\t\t\t\t\tmonthNamesShort string[12] - abbreviated names of the months (optional)\n         *\t\t\t\t\tmonthNames\t\tstring[12] - names of the months (optional)\n         * @return  Date - the extracted date value or null if value is blank\n         */\n        parseDate: function (format, value, settings) {\n            if (format == null || value == null) {\n                throw \"Invalid arguments\";\n            }\n\n            value = (typeof value === \"object\" ? value.toString() : value + \"\");\n            if (value === \"\") {\n                return null;\n            }\n\n            var iFormat, dim, extra,\n                iValue = 0,\n                shortYearCutoffTemp = (settings ? settings.shortYearCutoff : null) || this._defaults.shortYearCutoff,\n                shortYearCutoff = (typeof shortYearCutoffTemp !== \"string\" ? shortYearCutoffTemp :\n                    new Date().getFullYear() % 100 + parseInt(shortYearCutoffTemp, 10)),\n                dayNamesShort = (settings ? settings.dayNamesShort : null) || this._defaults.dayNamesShort,\n                dayNames = (settings ? settings.dayNames : null) || this._defaults.dayNames,\n                monthNamesShort = (settings ? settings.monthNamesShort : null) || this._defaults.monthNamesShort,\n                monthNames = (settings ? settings.monthNames : null) || this._defaults.monthNames,\n                year = -1,\n                month = -1,\n                day = -1,\n                doy = -1,\n                literal = false,\n                date,\n                // Check whether a format character is doubled\n                lookAhead = function (match) {\n                    var matches = (iFormat + 1 < format.length && format.charAt(iFormat + 1) === match);\n                    if (matches) {\n                        iFormat++;\n                    }\n                    return matches;\n                },\n                // Extract a number from the string value\n                getNumber = function (match) {\n                    var isDoubled = lookAhead(match),\n                        size = (match === \"@\" ? 14 : (match === \"!\" ? 20 :\n                            (match === \"y\" && isDoubled ? 4 : (match === \"o\" ? 3 : 2)))),\n                        digits = new RegExp(\"^\\\\d{1,\" + size + \"}\"),\n                        num = value.substring(iValue).match(digits);\n                    if (!num) {\n                        throw \"Missing number at position \" + iValue;\n                    }\n                    iValue += num[0].length;\n                    return parseInt(num[0], 10);\n                },\n                // Extract a name from the string value and convert to an index\n                getName = function (match, shortNames, longNames) {\n                    var index = -1,\n                        names = $.map(lookAhead(match) ? longNames : shortNames, function (v, k) {\n                            return [[k, v]];\n                        }).sort(function (a, b) {\n                            return -(a[1].length - b[1].length);\n                        });\n\n                    $.each(names, function (i, pair) {\n                        var name = pair[1];\n                        if (value.substr(iValue, name.length).toLowerCase() === name.toLowerCase()) {\n                            index = pair[0];\n                            iValue += name.length;\n                            return false;\n                        }\n                    });\n                    if (index !== -1) {\n                        return index + 1;\n                    } else {\n                        throw \"Unknown name at position \" + iValue;\n                    }\n                },\n                // Confirm that a literal character matches the string value\n                checkLiteral = function () {\n                    if (value.charAt(iValue) !== format.charAt(iFormat)) {\n                        throw \"Unexpected literal at position \" + iValue;\n                    }\n                    iValue++;\n                };\n\n            for (iFormat = 0; iFormat < format.length; iFormat++) {\n                if (literal) {\n                    if (format.charAt(iFormat) === \"'\" && !lookAhead(\"'\")) {\n                        literal = false;\n                    } else {\n                        checkLiteral();\n                    }\n                } else {\n                    switch (format.charAt(iFormat)) {\n                        case \"d\":\n                            day = getNumber(\"d\");\n                            break;\n                        case \"D\":\n                            getName(\"D\", dayNamesShort, dayNames);\n                            break;\n                        case \"o\":\n                            doy = getNumber(\"o\");\n                            break;\n                        case \"m\":\n                            month = getNumber(\"m\");\n                            break;\n                        case \"M\":\n                            month = getName(\"M\", monthNamesShort, monthNames);\n                            break;\n                        case \"y\":\n                            year = getNumber(\"y\");\n                            break;\n                        case \"@\":\n                            date = new Date(getNumber(\"@\"));\n                            year = date.getFullYear();\n                            month = date.getMonth() + 1;\n                            day = date.getDate();\n                            break;\n                        case \"!\":\n                            date = new Date((getNumber(\"!\") - this._ticksTo1970) / 10000);\n                            year = date.getFullYear();\n                            month = date.getMonth() + 1;\n                            day = date.getDate();\n                            break;\n                        case \"'\":\n                            if (lookAhead(\"'\")) {\n                                checkLiteral();\n                            } else {\n                                literal = true;\n                            }\n                            break;\n                        default:\n                            checkLiteral();\n                    }\n                }\n            }\n\n            if (iValue < value.length) {\n                extra = value.substr(iValue);\n                if (!/^\\s+/.test(extra)) {\n                    throw \"Extra/unparsed characters found in date: \" + extra;\n                }\n            }\n\n            if (year === -1) {\n                year = new Date().getFullYear();\n            } else if (year < 100) {\n                year += new Date().getFullYear() - new Date().getFullYear() % 100 +\n                    (year <= shortYearCutoff ? 0 : -100);\n            }\n\n            if (doy > -1) {\n                month = 1;\n                day = doy;\n                do {\n                    dim = this._getDaysInMonth(year, month - 1);\n                    if (day <= dim) {\n                        break;\n                    }\n                    month++;\n                    day -= dim;\n                } while (true);\n            }\n\n            date = this._daylightSavingAdjust(new Date(year, month - 1, day));\n            if (date.getFullYear() !== year || date.getMonth() + 1 !== month || date.getDate() !== day) {\n                throw \"Invalid date\"; // E.g. 31/02/00\n            }\n            return date;\n        },\n\n        /* Standard date formats. */\n        ATOM: \"yy-mm-dd\", // RFC 3339 (ISO 8601)\n        COOKIE: \"D, dd M yy\",\n        ISO_8601: \"yy-mm-dd\",\n        RFC_822: \"D, d M y\",\n        RFC_850: \"DD, dd-M-y\",\n        RFC_1036: \"D, d M y\",\n        RFC_1123: \"D, d M yy\",\n        RFC_2822: \"D, d M yy\",\n        RSS: \"D, d M y\", // RFC 822\n        TICKS: \"!\",\n        TIMESTAMP: \"@\",\n        W3C: \"yy-mm-dd\", // ISO 8601\n\n        _ticksTo1970: (((1970 - 1) * 365 + Math.floor(1970 / 4) - Math.floor(1970 / 100) +\n            Math.floor(1970 / 400)) * 24 * 60 * 60 * 10000000),\n\n        /* Format a date object into a string value.\n         * The format can be combinations of the following:\n         * d  - day of month (no leading zero)\n         * dd - day of month (two digit)\n         * o  - day of year (no leading zeros)\n         * oo - day of year (three digit)\n         * D  - day name short\n         * DD - day name long\n         * m  - month of year (no leading zero)\n         * mm - month of year (two digit)\n         * M  - month name short\n         * MM - month name long\n         * y  - year (two digit)\n         * yy - year (four digit)\n         * @ - Unix timestamp (ms since 01/01/1970)\n         * ! - Windows ticks (100ns since 01/01/0001)\n         * \"...\" - literal text\n         * '' - single quote\n         *\n         * @param  format string - the desired format of the date\n         * @param  date Date - the date value to format\n         * @param  settings Object - attributes include:\n         *\t\t\t\t\tdayNamesShort\tstring[7] - abbreviated names of the days from Sunday (optional)\n         *\t\t\t\t\tdayNames\t\tstring[7] - names of the days from Sunday (optional)\n         *\t\t\t\t\tmonthNamesShort string[12] - abbreviated names of the months (optional)\n         *\t\t\t\t\tmonthNames\t\tstring[12] - names of the months (optional)\n         * @return  string - the date in the above format\n         */\n        formatDate: function (format, date, settings) {\n            if (!date) {\n                return \"\";\n            }\n\n            var iFormat,\n                dayNamesShort = (settings ? settings.dayNamesShort : null) || this._defaults.dayNamesShort,\n                dayNames = (settings ? settings.dayNames : null) || this._defaults.dayNames,\n                monthNamesShort = (settings ? settings.monthNamesShort : null) || this._defaults.monthNamesShort,\n                monthNames = (settings ? settings.monthNames : null) || this._defaults.monthNames,\n                // Check whether a format character is doubled\n                lookAhead = function (match) {\n                    var matches = (iFormat + 1 < format.length && format.charAt(iFormat + 1) === match);\n                    if (matches) {\n                        iFormat++;\n                    }\n                    return matches;\n                },\n                // Format a number, with leading zero if necessary\n                formatNumber = function (match, value, len) {\n                    var num = \"\" + value;\n                    if (lookAhead(match)) {\n                        while (num.length < len) {\n                            num = \"0\" + num;\n                        }\n                    }\n                    return num;\n                },\n                // Format a name, short or long as requested\n                formatName = function (match, value, shortNames, longNames) {\n                    return (lookAhead(match) ? longNames[value] : shortNames[value]);\n                },\n                output = \"\",\n                literal = false;\n\n            if (date) {\n                for (iFormat = 0; iFormat < format.length; iFormat++) {\n                    if (literal) {\n                        if (format.charAt(iFormat) === \"'\" && !lookAhead(\"'\")) {\n                            literal = false;\n                        } else {\n                            output += format.charAt(iFormat);\n                        }\n                    } else {\n                        switch (format.charAt(iFormat)) {\n                            case \"d\":\n                                output += formatNumber(\"d\", date.getDate(), 2);\n                                break;\n                            case \"D\":\n                                output += formatName(\"D\", date.getDay(), dayNamesShort, dayNames);\n                                break;\n                            case \"o\":\n                                output += formatNumber(\"o\",\n                                    Math.round((new Date(date.getFullYear(), date.getMonth(), date.getDate()).getTime() - new Date(date.getFullYear(), 0, 0).getTime()) / 86400000), 3);\n                                break;\n                            case \"m\":\n                                output += formatNumber(\"m\", date.getMonth() + 1, 2);\n                                break;\n                            case \"M\":\n                                output += formatName(\"M\", date.getMonth(), monthNamesShort, monthNames);\n                                break;\n                            case \"y\":\n                                output += (lookAhead(\"y\") ? date.getFullYear() :\n                                    (date.getYear() % 100 < 10 ? \"0\" : \"\") + date.getYear() % 100);\n                                break;\n                            case \"@\":\n                                output += date.getTime();\n                                break;\n                            case \"!\":\n                                output += date.getTime() * 10000 + this._ticksTo1970;\n                                break;\n                            case \"'\":\n                                if (lookAhead(\"'\")) {\n                                    output += \"'\";\n                                } else {\n                                    literal = true;\n                                }\n                                break;\n                            default:\n                                output += format.charAt(iFormat);\n                        }\n                    }\n                }\n            }\n            return output;\n        },\n\n        /* Extract all possible characters from the date format. */\n        _possibleChars: function (format) {\n            var iFormat,\n                chars = \"\",\n                literal = false,\n                // Check whether a format character is doubled\n                lookAhead = function (match) {\n                    var matches = (iFormat + 1 < format.length && format.charAt(iFormat + 1) === match);\n                    if (matches) {\n                        iFormat++;\n                    }\n                    return matches;\n                };\n\n            for (iFormat = 0; iFormat < format.length; iFormat++) {\n                if (literal) {\n                    if (format.charAt(iFormat) === \"'\" && !lookAhead(\"'\")) {\n                        literal = false;\n                    } else {\n                        chars += format.charAt(iFormat);\n                    }\n                } else {\n                    switch (format.charAt(iFormat)) {\n                        case \"d\":\n                        case \"m\":\n                        case \"y\":\n                        case \"@\":\n                            chars += \"0123456789\";\n                            break;\n                        case \"D\":\n                        case \"M\":\n                            return null; // Accept anything\n                        case \"'\":\n                            if (lookAhead(\"'\")) {\n                                chars += \"'\";\n                            } else {\n                                literal = true;\n                            }\n                            break;\n                        default:\n                            chars += format.charAt(iFormat);\n                    }\n                }\n            }\n            return chars;\n        },\n\n        /* Get a setting value, defaulting if necessary. */\n        _get: function (inst, name) {\n            return inst.settings[name] !== undefined ?\n                inst.settings[name] : this._defaults[name];\n        },\n\n        /* Parse existing date and initialise date picker. */\n        _setDateFromField: function (inst, noDefault) {\n            if (inst.input.val() === inst.lastVal) {\n                return;\n            }\n\n            var dateFormat = this._get(inst, \"dateFormat\"),\n                dates = inst.lastVal = inst.input ? inst.input.val() : null,\n                defaultDate = this._getDefaultDate(inst),\n                date = defaultDate,\n                settings = this._getFormatConfig(inst);\n\n            try {\n                date = this.parseDate(dateFormat, dates, settings) || defaultDate;\n            } catch (event) {\n                dates = (noDefault ? \"\" : dates);\n            }\n            inst.selectedDay = date.getDate();\n            inst.drawMonth = inst.selectedMonth = date.getMonth();\n            inst.drawYear = inst.selectedYear = date.getFullYear();\n            inst.currentDay = (dates ? date.getDate() : 0);\n            inst.currentMonth = (dates ? date.getMonth() : 0);\n            inst.currentYear = (dates ? date.getFullYear() : 0);\n            this._adjustInstDate(inst);\n        },\n\n        /* Retrieve the default date shown on opening. */\n        _getDefaultDate: function (inst) {\n            return this._restrictMinMax(inst,\n                this._determineDate(inst, this._get(inst, \"defaultDate\"), new Date()));\n        },\n\n        /* A date may be specified as an exact value or a relative one. */\n        _determineDate: function (inst, date, defaultDate) {\n            var offsetNumeric = function (offset) {\n                    var date = new Date();\n                    date.setDate(date.getDate() + offset);\n                    return date;\n                },\n                offsetString = function (offset) {\n                    try {\n                        return $.datepicker.parseDate($.datepicker._get(inst, \"dateFormat\"),\n                            offset, $.datepicker._getFormatConfig(inst));\n                    } catch (e) {\n                        // Ignore\n                    }\n\n                    var date = (offset.toLowerCase().match(/^c/) ?\n                        $.datepicker._getDate(inst) : null) || new Date(),\n                        year = date.getFullYear(),\n                        month = date.getMonth(),\n                        day = date.getDate(),\n                        pattern = /([+\\-]?[0-9]+)\\s*(d|D|w|W|m|M|y|Y)?/g,\n                        matches = pattern.exec(offset);\n\n                    while (matches) {\n                        switch (matches[2] || \"d\") {\n                            case \"d\" :\n                            case \"D\" :\n                                day += parseInt(matches[1], 10);\n                                break;\n                            case \"w\" :\n                            case \"W\" :\n                                day += parseInt(matches[1], 10) * 7;\n                                break;\n                            case \"m\" :\n                            case \"M\" :\n                                month += parseInt(matches[1], 10);\n                                day = Math.min(day, $.datepicker._getDaysInMonth(year, month));\n                                break;\n                            case \"y\":\n                            case \"Y\" :\n                                year += parseInt(matches[1], 10);\n                                day = Math.min(day, $.datepicker._getDaysInMonth(year, month));\n                                break;\n                        }\n                        matches = pattern.exec(offset);\n                    }\n                    return new Date(year, month, day);\n                },\n                newDate = (date == null || date === \"\" ? defaultDate : (typeof date === \"string\" ? offsetString(date) :\n                    (typeof date === \"number\" ? (isNaN(date) ? defaultDate : offsetNumeric(date)) : new Date(date.getTime()))));\n\n            newDate = (newDate && newDate.toString() === \"Invalid Date\" ? defaultDate : newDate);\n            if (newDate) {\n                newDate.setHours(0);\n                newDate.setMinutes(0);\n                newDate.setSeconds(0);\n                newDate.setMilliseconds(0);\n            }\n            return this._daylightSavingAdjust(newDate);\n        },\n\n        /* Handle switch to/from daylight saving.\n         * Hours may be non-zero on daylight saving cut-over:\n         * > 12 when midnight changeover, but then cannot generate\n         * midnight datetime, so jump to 1AM, otherwise reset.\n         * @param  date  (Date) the date to check\n         * @return  (Date) the corrected date\n         */\n        _daylightSavingAdjust: function (date) {\n            if (!date) {\n                return null;\n            }\n            date.setHours(date.getHours() > 12 ? date.getHours() + 2 : 0);\n            return date;\n        },\n\n        /* Set the date(s) directly. */\n        _setDate: function (inst, date, noChange) {\n            var clear = !date,\n                origMonth = inst.selectedMonth,\n                origYear = inst.selectedYear,\n                newDate = this._restrictMinMax(inst, this._determineDate(inst, date, new Date()));\n\n            inst.selectedDay = inst.currentDay = newDate.getDate();\n            inst.drawMonth = inst.selectedMonth = inst.currentMonth = newDate.getMonth();\n            inst.drawYear = inst.selectedYear = inst.currentYear = newDate.getFullYear();\n            if ((origMonth !== inst.selectedMonth || origYear !== inst.selectedYear) && !noChange) {\n                this._notifyChange(inst);\n            }\n            this._adjustInstDate(inst);\n            if (inst.input) {\n                inst.input.val(clear ? \"\" : this._formatDate(inst));\n            }\n        },\n\n        /* Retrieve the date(s) directly. */\n        _getDate: function (inst) {\n            var startDate = (!inst.currentYear || (inst.input && inst.input.val() === \"\") ? null :\n                this._daylightSavingAdjust(new Date(\n                    inst.currentYear, inst.currentMonth, inst.currentDay)));\n            return startDate;\n        },\n\n        /* Attach the onxxx handlers.  These are declared statically so\n         * they work with static code transformers like Caja.\n         */\n        _attachHandlers: function (inst) {\n            var stepMonths = this._get(inst, \"stepMonths\"),\n                id = \"#\" + inst.id.replace(/\\\\\\\\/g, \"\\\\\");\n            inst.dpDiv.find(\"[data-handler]\").map(function () {\n                var handler = {\n                    prev: function () {\n                        $.datepicker._adjustDate(id, -stepMonths, \"M\");\n                    },\n                    next: function () {\n                        $.datepicker._adjustDate(id, +stepMonths, \"M\");\n                    },\n                    hide: function () {\n                        $.datepicker._hideDatepicker();\n                    },\n                    today: function () {\n                        $.datepicker._gotoToday(id);\n                    },\n                    selectDay: function () {\n                        $.datepicker._selectDay(id, +this.getAttribute(\"data-month\"), +this.getAttribute(\"data-year\"), this);\n                        return false;\n                    },\n                    selectMonth: function () {\n                        $.datepicker._selectMonthYear(id, this, \"M\");\n                        return false;\n                    },\n                    selectYear: function () {\n                        $.datepicker._selectMonthYear(id, this, \"Y\");\n                        return false;\n                    }\n                };\n                $(this).bind(this.getAttribute(\"data-event\"), handler[this.getAttribute(\"data-handler\")]);\n            });\n        },\n\n        /* Generate the HTML for the current state of the date picker. */\n        _generateHTML: function (inst) {\n            var maxDraw, prevText, prev, nextText, next, currentText, gotoDate,\n                controls, buttonPanel, firstDay, showWeek, dayNames, dayNamesMin,\n                monthNames, monthNamesShort, beforeShowDay, showOtherMonths,\n                selectOtherMonths, defaultDate, html, dow, row, group, col, selectedDate,\n                cornerClass, calender, thead, day, daysInMonth, leadDays, curRows, numRows,\n                printDate, dRow, tbody, daySettings, otherMonth, unselectable,\n                tempDate = new Date(),\n                today = this._daylightSavingAdjust(\n                    new Date(tempDate.getFullYear(), tempDate.getMonth(), tempDate.getDate())), // clear time\n                isRTL = this._get(inst, \"isRTL\"),\n                showButtonPanel = this._get(inst, \"showButtonPanel\"),\n                hideIfNoPrevNext = this._get(inst, \"hideIfNoPrevNext\"),\n                navigationAsDateFormat = this._get(inst, \"navigationAsDateFormat\"),\n                numMonths = this._getNumberOfMonths(inst),\n                showCurrentAtPos = this._get(inst, \"showCurrentAtPos\"),\n                stepMonths = this._get(inst, \"stepMonths\"),\n                isMultiMonth = (numMonths[0] !== 1 || numMonths[1] !== 1),\n                currentDate = this._daylightSavingAdjust((!inst.currentDay ? new Date(9999, 9, 9) :\n                    new Date(inst.currentYear, inst.currentMonth, inst.currentDay))),\n                minDate = this._getMinMaxDate(inst, \"min\"),\n                maxDate = this._getMinMaxDate(inst, \"max\"),\n                drawMonth = inst.drawMonth - showCurrentAtPos,\n                drawYear = inst.drawYear;\n\n            if (drawMonth < 0) {\n                drawMonth += 12;\n                drawYear--;\n            }\n            if (maxDate) {\n                maxDraw = this._daylightSavingAdjust(new Date(maxDate.getFullYear(),\n                    maxDate.getMonth() - (numMonths[0] * numMonths[1]) + 1, maxDate.getDate()));\n                maxDraw = (minDate && maxDraw < minDate ? minDate : maxDraw);\n                while (this._daylightSavingAdjust(new Date(drawYear, drawMonth, 1)) > maxDraw) {\n                    drawMonth--;\n                    if (drawMonth < 0) {\n                        drawMonth = 11;\n                        drawYear--;\n                    }\n                }\n            }\n            inst.drawMonth = drawMonth;\n            inst.drawYear = drawYear;\n\n            prevText = this._get(inst, \"prevText\");\n            prevText = (!navigationAsDateFormat ? prevText : this.formatDate(prevText,\n                this._daylightSavingAdjust(new Date(drawYear, drawMonth - stepMonths, 1)),\n                this._getFormatConfig(inst)));\n\n            prev = (this._canAdjustMonth(inst, -1, drawYear, drawMonth) ?\n                \"<a class='ui-datepicker-prev ui-corner-all' data-handler='prev' data-event='click'\" +\n                \" title='\" + prevText + \"'><span class='ui-icon ui-icon-circle-triangle-\" + (isRTL ? \"e\" : \"w\") + \"'>\" + prevText + \"</span></a>\" :\n                (hideIfNoPrevNext ? \"\" : \"<a class='ui-datepicker-prev ui-corner-all ui-state-disabled' title='\" + prevText + \"'><span class='ui-icon ui-icon-circle-triangle-\" + (isRTL ? \"e\" : \"w\") + \"'>\" + prevText + \"</span></a>\"));\n\n            nextText = this._get(inst, \"nextText\");\n            nextText = (!navigationAsDateFormat ? nextText : this.formatDate(nextText,\n                this._daylightSavingAdjust(new Date(drawYear, drawMonth + stepMonths, 1)),\n                this._getFormatConfig(inst)));\n\n            next = (this._canAdjustMonth(inst, +1, drawYear, drawMonth) ?\n                \"<a class='ui-datepicker-next ui-corner-all' data-handler='next' data-event='click'\" +\n                \" title='\" + nextText + \"'><span class='ui-icon ui-icon-circle-triangle-\" + (isRTL ? \"w\" : \"e\") + \"'>\" + nextText + \"</span></a>\" :\n                (hideIfNoPrevNext ? \"\" : \"<a class='ui-datepicker-next ui-corner-all ui-state-disabled' title='\" + nextText + \"'><span class='ui-icon ui-icon-circle-triangle-\" + (isRTL ? \"w\" : \"e\") + \"'>\" + nextText + \"</span></a>\"));\n\n            currentText = this._get(inst, \"currentText\");\n            gotoDate = (this._get(inst, \"gotoCurrent\") && inst.currentDay ? currentDate : today);\n            currentText = (!navigationAsDateFormat ? currentText :\n                this.formatDate(currentText, gotoDate, this._getFormatConfig(inst)));\n\n            controls = (!inst.inline ? \"<button type='button' class='ui-datepicker-close ui-state-default ui-priority-primary ui-corner-all' data-handler='hide' data-event='click'>\" +\n                this._get(inst, \"closeText\") + \"</button>\" : \"\");\n\n            buttonPanel = (showButtonPanel) ? \"<div class='ui-datepicker-buttonpane ui-widget-content'>\" + (isRTL ? controls : \"\") +\n                (this._isInRange(inst, gotoDate) ? \"<button type='button' class='ui-datepicker-current ui-state-default ui-priority-secondary ui-corner-all' data-handler='today' data-event='click'\" +\n                    \">\" + currentText + \"</button>\" : \"\") + (isRTL ? \"\" : controls) + \"</div>\" : \"\";\n\n            firstDay = parseInt(this._get(inst, \"firstDay\"), 10);\n            firstDay = (isNaN(firstDay) ? 0 : firstDay);\n\n            showWeek = this._get(inst, \"showWeek\");\n            dayNames = this._get(inst, \"dayNames\");\n            dayNamesMin = this._get(inst, \"dayNamesMin\");\n            monthNames = this._get(inst, \"monthNames\");\n            monthNamesShort = this._get(inst, \"monthNamesShort\");\n            beforeShowDay = this._get(inst, \"beforeShowDay\");\n            showOtherMonths = this._get(inst, \"showOtherMonths\");\n            selectOtherMonths = this._get(inst, \"selectOtherMonths\");\n            defaultDate = this._getDefaultDate(inst);\n            html = \"\";\n            dow;\n            for (row = 0; row < numMonths[0]; row++) {\n                group = \"\";\n                this.maxRows = 4;\n                for (col = 0; col < numMonths[1]; col++) {\n                    selectedDate = this._daylightSavingAdjust(new Date(drawYear, drawMonth, inst.selectedDay));\n                    cornerClass = \" ui-corner-all\";\n                    calender = \"\";\n                    if (isMultiMonth) {\n                        calender += \"<div class='ui-datepicker-group\";\n                        if (numMonths[1] > 1) {\n                            switch (col) {\n                                case 0:\n                                    calender += \" ui-datepicker-group-first\";\n                                    cornerClass = \" ui-corner-\" + (isRTL ? \"right\" : \"left\");\n                                    break;\n                                case numMonths[1] - 1:\n                                    calender += \" ui-datepicker-group-last\";\n                                    cornerClass = \" ui-corner-\" + (isRTL ? \"left\" : \"right\");\n                                    break;\n                                default:\n                                    calender += \" ui-datepicker-group-middle\";\n                                    cornerClass = \"\";\n                                    break;\n                            }\n                        }\n                        calender += \"'>\";\n                    }\n                    calender += \"<div class='ui-datepicker-header ui-widget-header ui-helper-clearfix\" + cornerClass + \"'>\" +\n                        (/all|left/.test(cornerClass) && row === 0 ? (isRTL ? next : prev) : \"\") +\n                        (/all|right/.test(cornerClass) && row === 0 ? (isRTL ? prev : next) : \"\") +\n                        this._generateMonthYearHeader(inst, drawMonth, drawYear, minDate, maxDate,\n                            row > 0 || col > 0, monthNames, monthNamesShort) + // draw month headers\n                        \"</div><table class='ui-datepicker-calendar'><thead>\" +\n                        \"<tr>\";\n                    thead = (showWeek ? \"<th class='ui-datepicker-week-col'>\" + this._get(inst, \"weekHeader\") + \"</th>\" : \"\");\n                    for (dow = 0; dow < 7; dow++) { // days of the week\n                        day = (dow + firstDay) % 7;\n                        thead += \"<th\" + ((dow + firstDay + 6) % 7 >= 5 ? \" class='ui-datepicker-week-end'\" : \"\") + \">\" +\n                            \"<span title='\" + dayNames[day] + \"'>\" + dayNamesMin[day] + \"</span></th>\";\n                    }\n                    calender += thead + \"</tr></thead><tbody>\";\n                    daysInMonth = this._getDaysInMonth(drawYear, drawMonth);\n                    if (drawYear === inst.selectedYear && drawMonth === inst.selectedMonth) {\n                        inst.selectedDay = Math.min(inst.selectedDay, daysInMonth);\n                    }\n                    leadDays = (this._getFirstDayOfMonth(drawYear, drawMonth) - firstDay + 7) % 7;\n                    curRows = Math.ceil((leadDays + daysInMonth) / 7); // calculate the number of rows to generate\n                    numRows = (isMultiMonth ? this.maxRows > curRows ? this.maxRows : curRows : curRows); //If multiple months, use the higher number of rows (see #7043)\n                    this.maxRows = numRows;\n                    printDate = this._daylightSavingAdjust(new Date(drawYear, drawMonth, 1 - leadDays));\n                    for (dRow = 0; dRow < numRows; dRow++) { // create date picker rows\n                        calender += \"<tr>\";\n                        tbody = (!showWeek ? \"\" : \"<td class='ui-datepicker-week-col'>\" +\n                            this._get(inst, \"calculateWeek\")(printDate) + \"</td>\");\n                        for (dow = 0; dow < 7; dow++) { // create date picker days\n                            daySettings = (beforeShowDay ?\n                                beforeShowDay.apply((inst.input ? inst.input[0] : null), [printDate]) : [true, \"\"]);\n                            otherMonth = (printDate.getMonth() !== drawMonth);\n                            unselectable = (otherMonth && !selectOtherMonths) || !daySettings[0] ||\n                                (minDate && printDate < minDate) || (maxDate && printDate > maxDate);\n                            tbody += \"<td class='\" +\n                                ((dow + firstDay + 6) % 7 >= 5 ? \" ui-datepicker-week-end\" : \"\") + // highlight weekends\n                                (otherMonth ? \" ui-datepicker-other-month\" : \"\") + // highlight days from other months\n                                ((printDate.getTime() === selectedDate.getTime() && drawMonth === inst.selectedMonth && inst._keyEvent) || // user pressed key\n                                (defaultDate.getTime() === printDate.getTime() && defaultDate.getTime() === selectedDate.getTime()) ?\n                                    // or defaultDate is current printedDate and defaultDate is selectedDate\n                                    \" \" + this._dayOverClass : \"\") + // highlight selected day\n                                (unselectable ? \" \" + this._unselectableClass + \" ui-state-disabled\" : \"\") +  // highlight unselectable days\n                                (otherMonth && !showOtherMonths ? \"\" : \" \" + daySettings[1] + // highlight custom dates\n                                    (printDate.getTime() === currentDate.getTime() ? \" \" + this._currentClass : \"\") + // highlight selected day\n                                    (printDate.getTime() === today.getTime() ? \" ui-datepicker-today\" : \"\")) + \"'\" + // highlight today (if different)\n                                ((!otherMonth || showOtherMonths) && daySettings[2] ? \" title='\" + daySettings[2].replace(/'/g, \"&#39;\") + \"'\" : \"\") + // cell title\n                                (unselectable ? \"\" : \" data-handler='selectDay' data-event='click' data-month='\" + printDate.getMonth() + \"' data-year='\" + printDate.getFullYear() + \"'\") + \">\" + // actions\n                                (otherMonth && !showOtherMonths ? \"&#xa0;\" : // display for other months\n                                    (unselectable ? \"<span class='ui-state-default'>\" + printDate.getDate() + \"</span>\" : \"<a class='ui-state-default\" +\n                                        (printDate.getTime() === today.getTime() ? \" ui-state-highlight\" : \"\") +\n                                        (printDate.getTime() === currentDate.getTime() ? \" ui-state-active\" : \"\") + // highlight selected day\n                                        (otherMonth ? \" ui-priority-secondary\" : \"\") + // distinguish dates from other months\n                                        \"' href='#'>\" + printDate.getDate() + \"</a>\")) + \"</td>\"; // display selectable date\n                            printDate.setDate(printDate.getDate() + 1);\n                            printDate = this._daylightSavingAdjust(printDate);\n                        }\n                        calender += tbody + \"</tr>\";\n                    }\n                    drawMonth++;\n                    if (drawMonth > 11) {\n                        drawMonth = 0;\n                        drawYear++;\n                    }\n                    calender += \"</tbody></table>\" + (isMultiMonth ? \"</div>\" +\n                        ((numMonths[0] > 0 && col === numMonths[1] - 1) ? \"<div class='ui-datepicker-row-break'></div>\" : \"\") : \"\");\n                    group += calender;\n                }\n                html += group;\n            }\n            html += buttonPanel;\n            inst._keyEvent = false;\n            return html;\n        },\n\n        /* Generate the month and year header. */\n        _generateMonthYearHeader: function (inst, drawMonth, drawYear, minDate, maxDate,\n                                            secondary, monthNames, monthNamesShort) {\n\n            var inMinYear, inMaxYear, month, years, thisYear, determineYear, year, endYear,\n                changeMonth = this._get(inst, \"changeMonth\"),\n                changeYear = this._get(inst, \"changeYear\"),\n                showMonthAfterYear = this._get(inst, \"showMonthAfterYear\"),\n                html = \"<div class='ui-datepicker-title'>\",\n                monthHtml = \"\";\n\n            // month selection\n            if (secondary || !changeMonth) {\n                monthHtml += \"<span class='ui-datepicker-month'>\" + monthNames[drawMonth] + \"</span>\";\n            } else {\n                inMinYear = (minDate && minDate.getFullYear() === drawYear);\n                inMaxYear = (maxDate && maxDate.getFullYear() === drawYear);\n                monthHtml += \"<select class='ui-datepicker-month' data-handler='selectMonth' data-event='change'>\";\n                for (month = 0; month < 12; month++) {\n                    if ((!inMinYear || month >= minDate.getMonth()) && (!inMaxYear || month <= maxDate.getMonth())) {\n                        monthHtml += \"<option value='\" + month + \"'\" +\n                            (month === drawMonth ? \" selected='selected'\" : \"\") +\n                            \">\" + monthNamesShort[month] + \"</option>\";\n                    }\n                }\n                monthHtml += \"</select>\";\n            }\n\n            if (!showMonthAfterYear) {\n                html += monthHtml + (secondary || !(changeMonth && changeYear) ? \"&#xa0;\" : \"\");\n            }\n\n            // year selection\n            if (!inst.yearshtml) {\n                inst.yearshtml = \"\";\n                if (secondary || !changeYear) {\n                    html += \"<span class='ui-datepicker-year'>\" + drawYear + \"</span>\";\n                } else {\n                    // determine range of years to display\n                    years = this._get(inst, \"yearRange\").split(\":\");\n                    thisYear = new Date().getFullYear();\n                    determineYear = function (value) {\n                        var year = (value.match(/c[+\\-].*/) ? drawYear + parseInt(value.substring(1), 10) :\n                            (value.match(/[+\\-].*/) ? thisYear + parseInt(value, 10) :\n                                parseInt(value, 10)));\n                        return (isNaN(year) ? thisYear : year);\n                    };\n                    year = determineYear(years[0]);\n                    endYear = Math.max(year, determineYear(years[1] || \"\"));\n                    year = (minDate ? Math.max(year, minDate.getFullYear()) : year);\n                    endYear = (maxDate ? Math.min(endYear, maxDate.getFullYear()) : endYear);\n                    inst.yearshtml += \"<select class='ui-datepicker-year' data-handler='selectYear' data-event='change'>\";\n                    for (; year <= endYear; year++) {\n                        inst.yearshtml += \"<option value='\" + year + \"'\" +\n                            (year === drawYear ? \" selected='selected'\" : \"\") +\n                            \">\" + year + \"</option>\";\n                    }\n                    inst.yearshtml += \"</select>\";\n\n                    html += inst.yearshtml;\n                    inst.yearshtml = null;\n                }\n            }\n\n            html += this._get(inst, \"yearSuffix\");\n            if (showMonthAfterYear) {\n                html += (secondary || !(changeMonth && changeYear) ? \"&#xa0;\" : \"\") + monthHtml;\n            }\n            html += \"</div>\"; // Close datepicker_header\n            return html;\n        },\n\n        /* Adjust one of the date sub-fields. */\n        _adjustInstDate: function (inst, offset, period) {\n            var year = inst.drawYear + (period === \"Y\" ? offset : 0),\n                month = inst.drawMonth + (period === \"M\" ? offset : 0),\n                day = Math.min(inst.selectedDay, this._getDaysInMonth(year, month)) + (period === \"D\" ? offset : 0),\n                date = this._restrictMinMax(inst, this._daylightSavingAdjust(new Date(year, month, day)));\n\n            inst.selectedDay = date.getDate();\n            inst.drawMonth = inst.selectedMonth = date.getMonth();\n            inst.drawYear = inst.selectedYear = date.getFullYear();\n            if (period === \"M\" || period === \"Y\") {\n                this._notifyChange(inst);\n            }\n        },\n\n        /* Ensure a date is within any min/max bounds. */\n        _restrictMinMax: function (inst, date) {\n            var minDate = this._getMinMaxDate(inst, \"min\"),\n                maxDate = this._getMinMaxDate(inst, \"max\"),\n                newDate = (minDate && date < minDate ? minDate : date);\n            return (maxDate && newDate > maxDate ? maxDate : newDate);\n        },\n\n        /* Notify change of month/year. */\n        _notifyChange: function (inst) {\n            var onChange = this._get(inst, \"onChangeMonthYear\");\n            if (onChange) {\n                onChange.apply((inst.input ? inst.input[0] : null),\n                    [inst.selectedYear, inst.selectedMonth + 1, inst]);\n            }\n        },\n\n        /* Determine the number of months to show. */\n        _getNumberOfMonths: function (inst) {\n            var numMonths = this._get(inst, \"numberOfMonths\");\n            return (numMonths == null ? [1, 1] : (typeof numMonths === \"number\" ? [1, numMonths] : numMonths));\n        },\n\n        /* Determine the current maximum date - ensure no time components are set. */\n        _getMinMaxDate: function (inst, minMax) {\n            return this._determineDate(inst, this._get(inst, minMax + \"Date\"), null);\n        },\n\n        /* Find the number of days in a given month. */\n        _getDaysInMonth: function (year, month) {\n            return 32 - this._daylightSavingAdjust(new Date(year, month, 32)).getDate();\n        },\n\n        /* Find the day of the week of the first of a month. */\n        _getFirstDayOfMonth: function (year, month) {\n            return new Date(year, month, 1).getDay();\n        },\n\n        /* Determines if we should allow a \"next/prev\" month display change. */\n        _canAdjustMonth: function (inst, offset, curYear, curMonth) {\n            var numMonths = this._getNumberOfMonths(inst),\n                date = this._daylightSavingAdjust(new Date(curYear,\n                    curMonth + (offset < 0 ? offset : numMonths[0] * numMonths[1]), 1));\n\n            if (offset < 0) {\n                date.setDate(this._getDaysInMonth(date.getFullYear(), date.getMonth()));\n            }\n            return this._isInRange(inst, date);\n        },\n\n        /* Is the given date in the accepted range? */\n        _isInRange: function (inst, date) {\n            var yearSplit, currentYear,\n                minDate = this._getMinMaxDate(inst, \"min\"),\n                maxDate = this._getMinMaxDate(inst, \"max\"),\n                minYear = null,\n                maxYear = null,\n                years = this._get(inst, \"yearRange\");\n            if (years) {\n                yearSplit = years.split(\":\");\n                currentYear = new Date().getFullYear();\n                minYear = parseInt(yearSplit[0], 10);\n                maxYear = parseInt(yearSplit[1], 10);\n                if (yearSplit[0].match(/[+\\-].*/)) {\n                    minYear += currentYear;\n                }\n                if (yearSplit[1].match(/[+\\-].*/)) {\n                    maxYear += currentYear;\n                }\n            }\n\n            return ((!minDate || date.getTime() >= minDate.getTime()) &&\n                (!maxDate || date.getTime() <= maxDate.getTime()) &&\n                (!minYear || date.getFullYear() >= minYear) &&\n                (!maxYear || date.getFullYear() <= maxYear));\n        },\n\n        /* Provide the configuration settings for formatting/parsing. */\n        _getFormatConfig: function (inst) {\n            var shortYearCutoff = this._get(inst, \"shortYearCutoff\");\n            shortYearCutoff = (typeof shortYearCutoff !== \"string\" ? shortYearCutoff :\n                new Date().getFullYear() % 100 + parseInt(shortYearCutoff, 10));\n            return {\n                shortYearCutoff: shortYearCutoff,\n                dayNamesShort: this._get(inst, \"dayNamesShort\"), dayNames: this._get(inst, \"dayNames\"),\n                monthNamesShort: this._get(inst, \"monthNamesShort\"), monthNames: this._get(inst, \"monthNames\")\n            };\n        },\n\n        /* Format the given date for display. */\n        _formatDate: function (inst, day, month, year) {\n            if (!day) {\n                inst.currentDay = inst.selectedDay;\n                inst.currentMonth = inst.selectedMonth;\n                inst.currentYear = inst.selectedYear;\n            }\n            var date = (day ? (typeof day === \"object\" ? day :\n                this._daylightSavingAdjust(new Date(year, month, day))) :\n                this._daylightSavingAdjust(new Date(inst.currentYear, inst.currentMonth, inst.currentDay)));\n            return this.formatDate(this._get(inst, \"dateFormat\"), date, this._getFormatConfig(inst));\n        }\n    });\n\n    /*\n     * Bind hover events for datepicker elements.\n     * Done via delegate so the binding only occurs once in the lifetime of the parent div.\n     * Global instActive, set by _updateDatepicker allows the handlers to find their way back to the active picker.\n     */\n    function bindHover(dpDiv) {\n        var selector = \"button, .ui-datepicker-prev, .ui-datepicker-next, .ui-datepicker-calendar td a\";\n        return dpDiv.delegate(selector, \"mouseout\", function () {\n            $(this).removeClass(\"ui-state-hover\");\n            if (this.className.indexOf(\"ui-datepicker-prev\") !== -1) {\n                $(this).removeClass(\"ui-datepicker-prev-hover\");\n            }\n            if (this.className.indexOf(\"ui-datepicker-next\") !== -1) {\n                $(this).removeClass(\"ui-datepicker-next-hover\");\n            }\n        })\n            .delegate(selector, \"mouseover\", function () {\n                if (!$.datepicker._isDisabledDatepicker(instActive.inline ? dpDiv.parent()[0] : instActive.input[0])) {\n                    $(this).parents(\".ui-datepicker-calendar\").find(\"a\").removeClass(\"ui-state-hover\");\n                    $(this).addClass(\"ui-state-hover\");\n                    if (this.className.indexOf(\"ui-datepicker-prev\") !== -1) {\n                        $(this).addClass(\"ui-datepicker-prev-hover\");\n                    }\n                    if (this.className.indexOf(\"ui-datepicker-next\") !== -1) {\n                        $(this).addClass(\"ui-datepicker-next-hover\");\n                    }\n                }\n            });\n    }\n\n    /* jQuery extend now ignores nulls! */\n    function extendRemove(target, props) {\n        $.extend(target, props);\n        for (var name in props) {\n            if (props[name] == null) {\n                target[name] = props[name];\n            }\n        }\n        return target;\n    }\n\n    /* Invoke the datepicker functionality.\n       @param  options  string - a command, optionally followed by additional parameters or\n                        Object - settings for attaching new datepicker functionality\n       @return  jQuery object */\n    $.fn.datepicker = function (options) {\n\n        /* Verify an empty collection wasn't passed - Fixes #6976 */\n        if (!this.length) {\n            return this;\n        }\n\n        /* Initialise the date picker. */\n        if (!$.datepicker.initialized) {\n            $(document).mousedown($.datepicker._checkExternalClick);\n            $.datepicker.initialized = true;\n        }\n\n        /* Append datepicker main container to body if not exist. */\n        if ($(\"#\" + $.datepicker._mainDivId).length === 0) {\n            $(\"body\").append($.datepicker.dpDiv);\n        }\n\n        var otherArgs = Array.prototype.slice.call(arguments, 1);\n        if (typeof options === \"string\" && (options === \"isDisabled\" || options === \"getDate\" || options === \"widget\")) {\n            return $.datepicker[\"_\" + options + \"Datepicker\"].apply($.datepicker, [this[0]].concat(otherArgs));\n        }\n        if (options === \"option\" && arguments.length === 2 && typeof arguments[1] === \"string\") {\n            return $.datepicker[\"_\" + options + \"Datepicker\"].apply($.datepicker, [this[0]].concat(otherArgs));\n        }\n        return this.each(function () {\n            typeof options === \"string\" ?\n                $.datepicker[\"_\" + options + \"Datepicker\"].apply($.datepicker, [this].concat(otherArgs)) :\n                $.datepicker._attachDatepicker(this, options);\n        });\n    };\n\n    $.datepicker = new Datepicker(); // singleton instance\n    $.datepicker.initialized = false;\n    $.datepicker.uuid = new Date().getTime();\n    $.datepicker.version = \"1.10.4\";\n\n});\n","jquery/ui-modules/accordion.js":"/*!\n * jQuery UI Accordion - v1.10.4\n * http://jqueryui.com\n *\n * Copyright 2014 jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * http://api.jqueryui.com/accordion/\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/core',\n    'jquery-ui-modules/widget'\n], function ($, undefined) {\n\n    var uid = 0,\n        hideProps = {},\n        showProps = {};\n\n    hideProps.height = hideProps.paddingTop = hideProps.paddingBottom =\n        hideProps.borderTopWidth = hideProps.borderBottomWidth = \"hide\";\n    showProps.height = showProps.paddingTop = showProps.paddingBottom =\n        showProps.borderTopWidth = showProps.borderBottomWidth = \"show\";\n\n    $.widget(\"ui.accordion\", {\n        version: \"1.10.4\",\n        options: {\n            active: 0,\n            animate: {},\n            collapsible: false,\n            event: \"click\",\n            header: \"> li > :first-child,> :not(li):even\",\n            heightStyle: \"auto\",\n            icons: {\n                activeHeader: \"ui-icon-triangle-1-s\",\n                header: \"ui-icon-triangle-1-e\"\n            },\n\n            // callbacks\n            activate: null,\n            beforeActivate: null\n        },\n\n        _create: function () {\n            var options = this.options;\n            this.prevShow = this.prevHide = $();\n            this.element.addClass(\"ui-accordion ui-widget ui-helper-reset\")\n            // ARIA\n                .attr(\"role\", \"tablist\");\n\n            // don't allow collapsible: false and active: false / null\n            if (!options.collapsible && (options.active === false || options.active == null)) {\n                options.active = 0;\n            }\n\n            this._processPanels();\n            // handle negative values\n            if (options.active < 0) {\n                options.active += this.headers.length;\n            }\n            this._refresh();\n        },\n\n        _getCreateEventData: function () {\n            return {\n                header: this.active,\n                panel: !this.active.length ? $() : this.active.next(),\n                content: !this.active.length ? $() : this.active.next()\n            };\n        },\n\n        _createIcons: function () {\n            var icons = this.options.icons;\n            if (icons) {\n                $(\"<span>\")\n                    .addClass(\"ui-accordion-header-icon ui-icon \" + icons.header)\n                    .prependTo(this.headers);\n                this.active.children(\".ui-accordion-header-icon\")\n                    .removeClass(icons.header)\n                    .addClass(icons.activeHeader);\n                this.headers.addClass(\"ui-accordion-icons\");\n            }\n        },\n\n        _destroyIcons: function () {\n            this.headers\n                .removeClass(\"ui-accordion-icons\")\n                .children(\".ui-accordion-header-icon\")\n                .remove();\n        },\n\n        _destroy: function () {\n            var contents;\n\n            // clean up main element\n            this.element\n                .removeClass(\"ui-accordion ui-widget ui-helper-reset\")\n                .removeAttr(\"role\");\n\n            // clean up headers\n            this.headers\n                .removeClass(\"ui-accordion-header ui-accordion-header-active ui-helper-reset ui-state-default ui-corner-all ui-state-active ui-state-disabled ui-corner-top\")\n                .removeAttr(\"role\")\n                .removeAttr(\"aria-expanded\")\n                .removeAttr(\"aria-selected\")\n                .removeAttr(\"aria-controls\")\n                .removeAttr(\"tabIndex\")\n                .each(function () {\n                    if (/^ui-accordion/.test(this.id)) {\n                        this.removeAttribute(\"id\");\n                    }\n                });\n            this._destroyIcons();\n\n            // clean up content panels\n            contents = this.headers.next()\n                .css(\"display\", \"\")\n                .removeAttr(\"role\")\n                .removeAttr(\"aria-hidden\")\n                .removeAttr(\"aria-labelledby\")\n                .removeClass(\"ui-helper-reset ui-widget-content ui-corner-bottom ui-accordion-content ui-accordion-content-active ui-state-disabled\")\n                .each(function () {\n                    if (/^ui-accordion/.test(this.id)) {\n                        this.removeAttribute(\"id\");\n                    }\n                });\n            if (this.options.heightStyle !== \"content\") {\n                contents.css(\"height\", \"\");\n            }\n        },\n\n        _setOption: function (key, value) {\n            if (key === \"active\") {\n                // _activate() will handle invalid values and update this.options\n                this._activate(value);\n                return;\n            }\n\n            if (key === \"event\") {\n                if (this.options.event) {\n                    this._off(this.headers, this.options.event);\n                }\n                this._setupEvents(value);\n            }\n\n            this._super(key, value);\n\n            // setting collapsible: false while collapsed; open first panel\n            if (key === \"collapsible\" && !value && this.options.active === false) {\n                this._activate(0);\n            }\n\n            if (key === \"icons\") {\n                this._destroyIcons();\n                if (value) {\n                    this._createIcons();\n                }\n            }\n\n            // #5332 - opacity doesn't cascade to positioned elements in IE\n            // so we need to add the disabled class to the headers and panels\n            if (key === \"disabled\") {\n                this.headers.add(this.headers.next())\n                    .toggleClass(\"ui-state-disabled\", !!value);\n            }\n        },\n\n        _keydown: function (event) {\n            if (event.altKey || event.ctrlKey) {\n                return;\n            }\n\n            var keyCode = $.ui.keyCode,\n                length = this.headers.length,\n                currentIndex = this.headers.index(event.target),\n                toFocus = false;\n\n            switch (event.keyCode) {\n                case keyCode.RIGHT:\n                case keyCode.DOWN:\n                    toFocus = this.headers[(currentIndex + 1) % length];\n                    break;\n                case keyCode.LEFT:\n                case keyCode.UP:\n                    toFocus = this.headers[(currentIndex - 1 + length) % length];\n                    break;\n                case keyCode.SPACE:\n                case keyCode.ENTER:\n                    this._eventHandler(event);\n                    break;\n                case keyCode.HOME:\n                    toFocus = this.headers[0];\n                    break;\n                case keyCode.END:\n                    toFocus = this.headers[length - 1];\n                    break;\n            }\n\n            if (toFocus) {\n                $(event.target).attr(\"tabIndex\", -1);\n                $(toFocus).attr(\"tabIndex\", 0);\n                toFocus.focus();\n                event.preventDefault();\n            }\n        },\n\n        _panelKeyDown: function (event) {\n            if (event.keyCode === $.ui.keyCode.UP && event.ctrlKey) {\n                $(event.currentTarget).prev().focus();\n            }\n        },\n\n        refresh: function () {\n            var options = this.options;\n            this._processPanels();\n\n            // was collapsed or no panel\n            if ((options.active === false && options.collapsible === true) || !this.headers.length) {\n                options.active = false;\n                this.active = $();\n                // active false only when collapsible is true\n            } else if (options.active === false) {\n                this._activate(0);\n                // was active, but active panel is gone\n            } else if (this.active.length && !$.contains(this.element[0], this.active[0])) {\n                // all remaining panel are disabled\n                if (this.headers.length === this.headers.find(\".ui-state-disabled\").length) {\n                    options.active = false;\n                    this.active = $();\n                    // activate previous panel\n                } else {\n                    this._activate(Math.max(0, options.active - 1));\n                }\n                // was active, active panel still exists\n            } else {\n                // make sure active index is correct\n                options.active = this.headers.index(this.active);\n            }\n\n            this._destroyIcons();\n\n            this._refresh();\n        },\n\n        _processPanels: function () {\n            this.headers = this.element.find(this.options.header)\n                .addClass(\"ui-accordion-header ui-helper-reset ui-state-default ui-corner-all\");\n\n            this.headers.next()\n                .addClass(\"ui-accordion-content ui-helper-reset ui-widget-content ui-corner-bottom\")\n                .filter(\":not(.ui-accordion-content-active)\")\n                .hide();\n        },\n\n        _refresh: function () {\n            var maxHeight,\n                options = this.options,\n                heightStyle = options.heightStyle,\n                parent = this.element.parent(),\n                accordionId = this.accordionId = \"ui-accordion-\" +\n                    (this.element.attr(\"id\") || ++uid);\n\n            this.active = this._findActive(options.active)\n                .addClass(\"ui-accordion-header-active ui-state-active ui-corner-top\")\n                .removeClass(\"ui-corner-all\");\n            this.active.next()\n                .addClass(\"ui-accordion-content-active\")\n                .show();\n\n            this.headers\n                .attr(\"role\", \"tab\")\n                .each(function (i) {\n                    var header = $(this),\n                        headerId = header.attr(\"id\"),\n                        panel = header.next(),\n                        panelId = panel.attr(\"id\");\n                    if (!headerId) {\n                        headerId = accordionId + \"-header-\" + i;\n                        header.attr(\"id\", headerId);\n                    }\n                    if (!panelId) {\n                        panelId = accordionId + \"-panel-\" + i;\n                        panel.attr(\"id\", panelId);\n                    }\n                    header.attr(\"aria-controls\", panelId);\n                    panel.attr(\"aria-labelledby\", headerId);\n                })\n                .next()\n                .attr(\"role\", \"tabpanel\");\n\n            this.headers\n                .not(this.active)\n                .attr({\n                    \"aria-selected\": \"false\",\n                    \"aria-expanded\": \"false\",\n                    tabIndex: -1\n                })\n                .next()\n                .attr({\n                    \"aria-hidden\": \"true\"\n                })\n                .hide();\n\n            // make sure at least one header is in the tab order\n            if (!this.active.length) {\n                this.headers.eq(0).attr(\"tabIndex\", 0);\n            } else {\n                this.active.attr({\n                    \"aria-selected\": \"true\",\n                    \"aria-expanded\": \"true\",\n                    tabIndex: 0\n                })\n                    .next()\n                    .attr({\n                        \"aria-hidden\": \"false\"\n                    });\n            }\n\n            this._createIcons();\n\n            this._setupEvents(options.event);\n\n            if (heightStyle === \"fill\") {\n                maxHeight = parent.height();\n                this.element.siblings(\":visible\").each(function () {\n                    var elem = $(this),\n                        position = elem.css(\"position\");\n\n                    if (position === \"absolute\" || position === \"fixed\") {\n                        return;\n                    }\n                    maxHeight -= elem.outerHeight(true);\n                });\n\n                this.headers.each(function () {\n                    maxHeight -= $(this).outerHeight(true);\n                });\n\n                this.headers.next()\n                    .each(function () {\n                        $(this).height(Math.max(0, maxHeight -\n                            $(this).innerHeight() + $(this).height()));\n                    })\n                    .css(\"overflow\", \"auto\");\n            } else if (heightStyle === \"auto\") {\n                maxHeight = 0;\n                this.headers.next()\n                    .each(function () {\n                        maxHeight = Math.max(maxHeight, $(this).css(\"height\", \"\").height());\n                    })\n                    .height(maxHeight);\n            }\n        },\n\n        _activate: function (index) {\n            var active = this._findActive(index)[0];\n\n            // trying to activate the already active panel\n            if (active === this.active[0]) {\n                return;\n            }\n\n            // trying to collapse, simulate a click on the currently active header\n            active = active || this.active[0];\n\n            this._eventHandler({\n                target: active,\n                currentTarget: active,\n                preventDefault: $.noop\n            });\n        },\n\n        _findActive: function (selector) {\n            return typeof selector === \"number\" ? this.headers.eq(selector) : $();\n        },\n\n        _setupEvents: function (event) {\n            var events = {\n                keydown: \"_keydown\"\n            };\n            if (event) {\n                $.each(event.split(\" \"), function (index, eventName) {\n                    events[eventName] = \"_eventHandler\";\n                });\n            }\n\n            this._off(this.headers.add(this.headers.next()));\n            this._on(this.headers, events);\n            this._on(this.headers.next(), {keydown: \"_panelKeyDown\"});\n            this._hoverable(this.headers);\n            this._focusable(this.headers);\n        },\n\n        _eventHandler: function (event) {\n            var options = this.options,\n                active = this.active,\n                clicked = $(event.currentTarget),\n                clickedIsActive = clicked[0] === active[0],\n                collapsing = clickedIsActive && options.collapsible,\n                toShow = collapsing ? $() : clicked.next(),\n                toHide = active.next(),\n                eventData = {\n                    oldHeader: active,\n                    oldPanel: toHide,\n                    newHeader: collapsing ? $() : clicked,\n                    newPanel: toShow\n                };\n\n            event.preventDefault();\n\n            if (\n                // click on active header, but not collapsible\n                (clickedIsActive && !options.collapsible) ||\n                // allow canceling activation\n                (this._trigger(\"beforeActivate\", event, eventData) === false)) {\n                return;\n            }\n\n            options.active = collapsing ? false : this.headers.index(clicked);\n\n            // when the call to ._toggle() comes after the class changes\n            // it causes a very odd bug in IE 8 (see #6720)\n            this.active = clickedIsActive ? $() : clicked;\n            this._toggle(eventData);\n\n            // switch classes\n            // corner classes on the previously active header stay after the animation\n            active.removeClass(\"ui-accordion-header-active ui-state-active\");\n            if (options.icons) {\n                active.children(\".ui-accordion-header-icon\")\n                    .removeClass(options.icons.activeHeader)\n                    .addClass(options.icons.header);\n            }\n\n            if (!clickedIsActive) {\n                clicked\n                    .removeClass(\"ui-corner-all\")\n                    .addClass(\"ui-accordion-header-active ui-state-active ui-corner-top\");\n                if (options.icons) {\n                    clicked.children(\".ui-accordion-header-icon\")\n                        .removeClass(options.icons.header)\n                        .addClass(options.icons.activeHeader);\n                }\n\n                clicked\n                    .next()\n                    .addClass(\"ui-accordion-content-active\");\n            }\n        },\n\n        _toggle: function (data) {\n            var toShow = data.newPanel,\n                toHide = this.prevShow.length ? this.prevShow : data.oldPanel;\n\n            // handle activating a panel during the animation for another activation\n            this.prevShow.add(this.prevHide).stop(true, true);\n            this.prevShow = toShow;\n            this.prevHide = toHide;\n\n            if (this.options.animate) {\n                this._animate(toShow, toHide, data);\n            } else {\n                toHide.hide();\n                toShow.show();\n                this._toggleComplete(data);\n            }\n\n            toHide.attr({\n                \"aria-hidden\": \"true\"\n            });\n            toHide.prev().attr(\"aria-selected\", \"false\");\n            // if we're switching panels, remove the old header from the tab order\n            // if we're opening from collapsed state, remove the previous header from the tab order\n            // if we're collapsing, then keep the collapsing header in the tab order\n            if (toShow.length && toHide.length) {\n                toHide.prev().attr({\n                    \"tabIndex\": -1,\n                    \"aria-expanded\": \"false\"\n                });\n            } else if (toShow.length) {\n                this.headers.filter(function () {\n                    return $(this).attr(\"tabIndex\") === 0;\n                })\n                    .attr(\"tabIndex\", -1);\n            }\n\n            toShow\n                .attr(\"aria-hidden\", \"false\")\n                .prev()\n                .attr({\n                    \"aria-selected\": \"true\",\n                    tabIndex: 0,\n                    \"aria-expanded\": \"true\"\n                });\n        },\n\n        _animate: function (toShow, toHide, data) {\n            var total, easing, duration,\n                that = this,\n                adjust = 0,\n                down = toShow.length &&\n                    (!toHide.length || (toShow.index() < toHide.index())),\n                animate = this.options.animate || {},\n                options = down && animate.down || animate,\n                complete = function () {\n                    that._toggleComplete(data);\n                };\n\n            if (typeof options === \"number\") {\n                duration = options;\n            }\n            if (typeof options === \"string\") {\n                easing = options;\n            }\n            // fall back from options to animation in case of partial down settings\n            easing = easing || options.easing || animate.easing;\n            duration = duration || options.duration || animate.duration;\n\n            if (!toHide.length) {\n                return toShow.animate(showProps, duration, easing, complete);\n            }\n            if (!toShow.length) {\n                return toHide.animate(hideProps, duration, easing, complete);\n            }\n\n            total = toShow.show().outerHeight();\n            toHide.animate(hideProps, {\n                duration: duration,\n                easing: easing,\n                step: function (now, fx) {\n                    fx.now = Math.round(now);\n                }\n            });\n            toShow\n                .hide()\n                .animate(showProps, {\n                    duration: duration,\n                    easing: easing,\n                    complete: complete,\n                    step: function (now, fx) {\n                        fx.now = Math.round(now);\n                        if (fx.prop !== \"height\") {\n                            adjust += fx.now;\n                        } else if (that.options.heightStyle !== \"content\") {\n                            fx.now = Math.round(total - toHide.outerHeight() - adjust);\n                            adjust = 0;\n                        }\n                    }\n                });\n        },\n\n        _toggleComplete: function (data) {\n            var toHide = data.oldPanel;\n\n            toHide\n                .removeClass(\"ui-accordion-content-active\")\n                .prev()\n                .removeClass(\"ui-corner-top\")\n                .addClass(\"ui-corner-all\");\n\n            // Work around for rendering bug in IE (#5421)\n            if (toHide.length) {\n                toHide.parent()[0].className = toHide.parent()[0].className;\n            }\n            this._trigger(\"activate\", null, data);\n        }\n    });\n});\n","jquery/patches/jquery-ui.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n    // 'jquery-ui-modules/dialog' - do not enable this dependency because this is already a mixin for the dialog ui component\n], function ($) {\n    'use strict';\n\n    /**\n     * Patch for CVE-2016-7103 (XSS vulnerability).\n     * Can safely remove only when jQuery UI is upgraded to >= 1.12.x.\n     * https://www.cvedetails.com/cve/CVE-2016-7103/\n     */\n    function dialogPatch() {\n        $.widget('ui.dialog', $.ui.dialog, {\n            /** @inheritdoc */\n            _createTitlebar: function () {\n                this.options.closeText = $('<a>').text('' + this.options.closeText).html();\n\n                this._superApply();\n            },\n\n            /** @inheritdoc */\n            _setOption: function (key, value) {\n                if (key === 'closeText') {\n                    value = $('<a>').text('' + value).html();\n                }\n\n                this._super(key, value);\n            }\n        });\n    }\n\n    return function () {\n        var majorVersion = $.ui.version.split('.')[0],\n            minorVersion = $.ui.version.split('.')[1];\n\n        if (majorVersion === 1 && minorVersion >= 12 || majorVersion >= 2) {\n            console.warn('jQuery patch for CVE-2016-7103 is no longer necessary, and should be removed');\n        }\n\n        dialogPatch();\n    };\n});\n","jquery/patches/jquery.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    /**\n     * Patch for CVE-2015-9251 (XSS vulnerability).\n     * Can safely remove only when jQuery UI is upgraded to >= 3.3.x.\n     * https://www.cvedetails.com/cve/CVE-2015-9251/\n     */\n    function ajaxResponsePatch(jQuery) {\n        jQuery.ajaxPrefilter(function (s) {\n            if (s.crossDomain) {\n                s.contents.script = false;\n            }\n        });\n    }\n\n    return function ($) {\n        var majorVersion = $.fn.jquery.split('.')[0];\n\n        if (majorVersion >= 3) {\n            console.warn('jQuery patch for CVE-2015-9251 is no longer necessary, and should be removed');\n        }\n\n        ajaxResponsePatch($);\n\n        return $;\n    };\n});\n","jquery/colorpicker/js/colorpicker.js":"/**\n *\n * Color picker\n * Author: Stefan Petre www.eyecon.ro\n * \n * Dual licensed under the MIT and GPL licenses\n * \n */\n\ndefine([\n\t\"jquery\",\n], function ($) {\n\tvar ColorPicker = function () {\n\t\tvar\n\t\t\tids = {},\n\t\t\tinAction,\n\t\t\tcharMin = 65,\n\t\t\tvisible,\n\t\t\ttpl = '<div class=\"colorpicker\"><div class=\"colorpicker_color\"><div><div></div></div></div><div class=\"colorpicker_hue\"><div></div></div><div class=\"colorpicker_new_color\"></div><div class=\"colorpicker_current_color\"></div><div class=\"colorpicker_hex\"><input type=\"text\" maxlength=\"6\" size=\"6\" /></div><div class=\"colorpicker_rgb_r colorpicker_field\"><input type=\"text\" maxlength=\"3\" size=\"3\" /><span></span></div><div class=\"colorpicker_rgb_g colorpicker_field\"><input type=\"text\" maxlength=\"3\" size=\"3\" /><span></span></div><div class=\"colorpicker_rgb_b colorpicker_field\"><input type=\"text\" maxlength=\"3\" size=\"3\" /><span></span></div><div class=\"colorpicker_hsb_h colorpicker_field\"><input type=\"text\" maxlength=\"3\" size=\"3\" /><span></span></div><div class=\"colorpicker_hsb_s colorpicker_field\"><input type=\"text\" maxlength=\"3\" size=\"3\" /><span></span></div><div class=\"colorpicker_hsb_b colorpicker_field\"><input type=\"text\" maxlength=\"3\" size=\"3\" /><span></span></div><div class=\"colorpicker_submit\"></div></div>',\n\t\t\tdefaults = {\n\t\t\t\teventName: 'click',\n\t\t\t\tonShow: function () {},\n\t\t\t\tonBeforeShow: function(){},\n\t\t\t\tonHide: function () {},\n\t\t\t\tonChange: function () {},\n\t\t\t\tonSubmit: function () {},\n\t\t\t\tcolor: 'ff0000',\n\t\t\t\tlivePreview: true,\n\t\t\t\tflat: false\n\t\t\t},\n\t\t\tfillRGBFields = function  (hsb, cal) {\n\t\t\t\tvar rgb = HSBToRGB(hsb);\n\t\t\t\t$(cal).data('colorpicker').fields\n\t\t\t\t\t.eq(1).val(rgb.r).end()\n\t\t\t\t\t.eq(2).val(rgb.g).end()\n\t\t\t\t\t.eq(3).val(rgb.b).end();\n\t\t\t},\n\t\t\tfillHSBFields = function  (hsb, cal) {\n\t\t\t\t$(cal).data('colorpicker').fields\n\t\t\t\t\t.eq(4).val(hsb.h).end()\n\t\t\t\t\t.eq(5).val(hsb.s).end()\n\t\t\t\t\t.eq(6).val(hsb.b).end();\n\t\t\t},\n\t\t\tfillHexFields = function (hsb, cal) {\n\t\t\t\t$(cal).data('colorpicker').fields\n\t\t\t\t\t.eq(0).val(HSBToHex(hsb)).end();\n\t\t\t},\n\t\t\tsetSelector = function (hsb, cal) {\n\t\t\t\t$(cal).data('colorpicker').selector.css('backgroundColor', '#' + HSBToHex({h: hsb.h, s: 100, b: 100}));\n\t\t\t\t$(cal).data('colorpicker').selectorIndic.css({\n\t\t\t\t\tleft: parseInt(150 * hsb.s/100, 10),\n\t\t\t\t\ttop: parseInt(150 * (100-hsb.b)/100, 10)\n\t\t\t\t});\n\t\t\t},\n\t\t\tsetHue = function (hsb, cal) {\n\t\t\t\t$(cal).data('colorpicker').hue.css('top', parseInt(150 - 150 * hsb.h/360, 10));\n\t\t\t},\n\t\t\tsetCurrentColor = function (hsb, cal) {\n\t\t\t\t$(cal).data('colorpicker').currentColor.css('backgroundColor', '#' + HSBToHex(hsb));\n\t\t\t},\n\t\t\tsetNewColor = function (hsb, cal) {\n\t\t\t\t$(cal).data('colorpicker').newColor.css('backgroundColor', '#' + HSBToHex(hsb));\n\t\t\t},\n\t\t\tkeyDown = function (ev) {\n\t\t\t\tvar pressedKey = ev.charCode || ev.keyCode || -1;\n\t\t\t\tif ((pressedKey > charMin && pressedKey <= 90) || pressedKey == 32) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\tvar cal = $(this).parent().parent();\n\t\t\t\tif (cal.data('colorpicker').livePreview === true) {\n\t\t\t\t\tchange.apply(this);\n\t\t\t\t}\n\t\t\t},\n\t\t\tchange = function (ev) {\n\t\t\t\tvar cal = $(this).parent().parent(), col;\n\t\t\t\tif (this.parentNode.className.indexOf('_hex') > 0) {\n\t\t\t\t\tcal.data('colorpicker').color = col = HexToHSB(fixHex(this.value));\n\t\t\t\t} else if (this.parentNode.className.indexOf('_hsb') > 0) {\n\t\t\t\t\tcal.data('colorpicker').color = col = fixHSB({\n\t\t\t\t\t\th: parseInt(cal.data('colorpicker').fields.eq(4).val(), 10),\n\t\t\t\t\t\ts: parseInt(cal.data('colorpicker').fields.eq(5).val(), 10),\n\t\t\t\t\t\tb: parseInt(cal.data('colorpicker').fields.eq(6).val(), 10)\n\t\t\t\t\t});\n\t\t\t\t} else {\n\t\t\t\t\tcal.data('colorpicker').color = col = RGBToHSB(fixRGB({\n\t\t\t\t\t\tr: parseInt(cal.data('colorpicker').fields.eq(1).val(), 10),\n\t\t\t\t\t\tg: parseInt(cal.data('colorpicker').fields.eq(2).val(), 10),\n\t\t\t\t\t\tb: parseInt(cal.data('colorpicker').fields.eq(3).val(), 10)\n\t\t\t\t\t}));\n\t\t\t\t}\n\t\t\t\tif (ev) {\n\t\t\t\t\tfillRGBFields(col, cal.get(0));\n\t\t\t\t\tfillHexFields(col, cal.get(0));\n\t\t\t\t\tfillHSBFields(col, cal.get(0));\n\t\t\t\t}\n\t\t\t\tsetSelector(col, cal.get(0));\n\t\t\t\tsetHue(col, cal.get(0));\n\t\t\t\tsetNewColor(col, cal.get(0));\n\t\t\t\tcal.data('colorpicker').onChange.apply(cal, [col, HSBToHex(col), HSBToRGB(col)]);\n\t\t\t},\n\t\t\tblur = function (ev) {\n\t\t\t\tvar cal = $(this).parent().parent();\n\t\t\t\tcal.data('colorpicker').fields.parent().removeClass('colorpicker_focus');\n\t\t\t},\n\t\t\tfocus = function () {\n\t\t\t\tcharMin = this.parentNode.className.indexOf('_hex') > 0 ? 70 : 65;\n\t\t\t\t$(this).parent().parent().data('colorpicker').fields.parent().removeClass('colorpicker_focus');\n\t\t\t\t$(this).parent().addClass('colorpicker_focus');\n\t\t\t},\n\t\t\tdownIncrement = function (ev) {\n\t\t\t\tvar field = $(this).parent().find('input').focus();\n\t\t\t\tvar current = {\n\t\t\t\t\tel: $(this).parent().addClass('colorpicker_slider'),\n\t\t\t\t\tmax: this.parentNode.className.indexOf('_hsb_h') > 0 ? 360 : (this.parentNode.className.indexOf('_hsb') > 0 ? 100 : 255),\n\t\t\t\t\ty: ev.pageY,\n\t\t\t\t\tfield: field,\n\t\t\t\t\tval: parseInt(field.val(), 10),\n\t\t\t\t\tpreview: $(this).parent().parent().data('colorpicker').livePreview\t\t\t\t\t\n\t\t\t\t};\n\t\t\t\t$(document).bind('mouseup', current, upIncrement);\n\t\t\t\t$(document).bind('mousemove', current, moveIncrement);\n\t\t\t},\n\t\t\tmoveIncrement = function (ev) {\n\t\t\t\tev.data.field.val(Math.max(0, Math.min(ev.data.max, parseInt(ev.data.val + ev.pageY - ev.data.y, 10))));\n\t\t\t\tif (ev.data.preview) {\n\t\t\t\t\tchange.apply(ev.data.field.get(0), [true]);\n\t\t\t\t}\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\tupIncrement = function (ev) {\n\t\t\t\tchange.apply(ev.data.field.get(0), [true]);\n\t\t\t\tev.data.el.removeClass('colorpicker_slider').find('input').focus();\n\t\t\t\t$(document).unbind('mouseup', upIncrement);\n\t\t\t\t$(document).unbind('mousemove', moveIncrement);\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\tdownHue = function (ev) {\n\t\t\t\tvar current = {\n\t\t\t\t\tcal: $(this).parent(),\n\t\t\t\t\ty: $(this).offset().top\n\t\t\t\t};\n\t\t\t\tcurrent.preview = current.cal.data('colorpicker').livePreview;\n\t\t\t\t$(document).bind('mouseup', current, upHue);\n\t\t\t\t$(document).bind('mousemove', current, moveHue);\n\t\t\t},\n\t\t\tmoveHue = function (ev) {\n\t\t\t\tchange.apply(\n\t\t\t\t\tev.data.cal.data('colorpicker')\n\t\t\t\t\t\t.fields\n\t\t\t\t\t\t.eq(4)\n\t\t\t\t\t\t.val(parseInt(360*(150 - Math.max(0,Math.min(150,(ev.pageY - ev.data.y))))/150, 10))\n\t\t\t\t\t\t.get(0),\n\t\t\t\t\t[ev.data.preview]\n\t\t\t\t);\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\tupHue = function (ev) {\n\t\t\t\tfillRGBFields(ev.data.cal.data('colorpicker').color, ev.data.cal.get(0));\n\t\t\t\tfillHexFields(ev.data.cal.data('colorpicker').color, ev.data.cal.get(0));\n\t\t\t\t$(document).unbind('mouseup', upHue);\n\t\t\t\t$(document).unbind('mousemove', moveHue);\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\tdownSelector = function (ev) {\n\t\t\t\tvar current = {\n\t\t\t\t\tcal: $(this).parent(),\n\t\t\t\t\tpos: $(this).offset()\n\t\t\t\t};\n\t\t\t\tcurrent.preview = current.cal.data('colorpicker').livePreview;\n\t\t\t\t$(document).bind('mouseup', current, upSelector);\n\t\t\t\t$(document).bind('mousemove', current, moveSelector);\n\t\t\t},\n\t\t\tmoveSelector = function (ev) {\n\t\t\t\tchange.apply(\n\t\t\t\t\tev.data.cal.data('colorpicker')\n\t\t\t\t\t\t.fields\n\t\t\t\t\t\t.eq(6)\n\t\t\t\t\t\t.val(parseInt(100*(150 - Math.max(0,Math.min(150,(ev.pageY - ev.data.pos.top))))/150, 10))\n\t\t\t\t\t\t.end()\n\t\t\t\t\t\t.eq(5)\n\t\t\t\t\t\t.val(parseInt(100*(Math.max(0,Math.min(150,(ev.pageX - ev.data.pos.left))))/150, 10))\n\t\t\t\t\t\t.get(0),\n\t\t\t\t\t[ev.data.preview]\n\t\t\t\t);\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\tupSelector = function (ev) {\n\t\t\t\tfillRGBFields(ev.data.cal.data('colorpicker').color, ev.data.cal.get(0));\n\t\t\t\tfillHexFields(ev.data.cal.data('colorpicker').color, ev.data.cal.get(0));\n\t\t\t\t$(document).unbind('mouseup', upSelector);\n\t\t\t\t$(document).unbind('mousemove', moveSelector);\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\tenterSubmit = function (ev) {\n\t\t\t\t$(this).addClass('colorpicker_focus');\n\t\t\t},\n\t\t\tleaveSubmit = function (ev) {\n\t\t\t\t$(this).removeClass('colorpicker_focus');\n\t\t\t},\n\t\t\tclickSubmit = function (ev) {\n\t\t\t\tvar cal = $(this).parent();\n\t\t\t\tvar col = cal.data('colorpicker').color;\n\t\t\t\tcal.data('colorpicker').origColor = col;\n\t\t\t\tsetCurrentColor(col, cal.get(0));\n\t\t\t\tcal.data('colorpicker').onSubmit(col, HSBToHex(col), HSBToRGB(col), cal.data('colorpicker').el);\n\t\t\t},\n\t\t\tshow = function (ev) {\n\t\t\t\tvar cal = $('#' + $(this).data('colorpickerId'));\n\t\t\t\tcal.data('colorpicker').onBeforeShow.apply(this, [cal.get(0)]);\n\t\t\t\tvar pos = $(this).offset();\n\t\t\t\tvar viewPort = getViewport();\n\t\t\t\tvar top = pos.top + this.offsetHeight;\n\t\t\t\tvar left = pos.left;\n\t\t\t\tif (top + 176 > viewPort.t + viewPort.h) {\n\t\t\t\t\ttop -= this.offsetHeight + 176;\n\t\t\t\t}\n\t\t\t\tif (left + 356 > viewPort.l + viewPort.w) {\n\t\t\t\t\tleft -= 356;\n\t\t\t\t}\n\t\t\t\tcal.css({left: left + 'px', top: top + 'px'});\n\t\t\t\tif (cal.data('colorpicker').onShow.apply(this, [cal.get(0)]) != false) {\n\t\t\t\t\tcal.show();\n\t\t\t\t}\n\t\t\t\t$(document).bind('mousedown', {cal: cal}, hide);\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\thide = function (ev) {\n\t\t\t\tif (!isChildOf(ev.data.cal.get(0), ev.target, ev.data.cal.get(0))) {\n\t\t\t\t\tif (ev.data.cal.data('colorpicker').onHide.apply(this, [ev.data.cal.get(0)]) != false) {\n\t\t\t\t\t\tev.data.cal.hide();\n\t\t\t\t\t}\n\t\t\t\t\t$(document).unbind('mousedown', hide);\n\t\t\t\t}\n\t\t\t},\n\t\t\tisChildOf = function(parentEl, el, container) {\n\t\t\t\tif (parentEl == el) {\n\t\t\t\t\treturn true;\n\t\t\t\t}\n\t\t\t\tif (parentEl.contains) {\n\t\t\t\t\treturn parentEl.contains(el);\n\t\t\t\t}\n\t\t\t\tif ( parentEl.compareDocumentPosition ) {\n\t\t\t\t\treturn !!(parentEl.compareDocumentPosition(el) & 16);\n\t\t\t\t}\n\t\t\t\tvar prEl = el.parentNode;\n\t\t\t\twhile(prEl && prEl != container) {\n\t\t\t\t\tif (prEl == parentEl)\n\t\t\t\t\t\treturn true;\n\t\t\t\t\tprEl = prEl.parentNode;\n\t\t\t\t}\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\tgetViewport = function () {\n\t\t\t\tvar m = document.compatMode == 'CSS1Compat';\n\t\t\t\treturn {\n\t\t\t\t\tl : window.pageXOffset || (m ? document.documentElement.scrollLeft : document.body.scrollLeft),\n\t\t\t\t\tt : window.pageYOffset || (m ? document.documentElement.scrollTop : document.body.scrollTop),\n\t\t\t\t\tw : window.innerWidth || (m ? document.documentElement.clientWidth : document.body.clientWidth),\n\t\t\t\t\th : window.innerHeight || (m ? document.documentElement.clientHeight : document.body.clientHeight)\n\t\t\t\t};\n\t\t\t},\n\t\t\tfixHSB = function (hsb) {\n\t\t\t\treturn {\n\t\t\t\t\th: Math.min(360, Math.max(0, hsb.h)),\n\t\t\t\t\ts: Math.min(100, Math.max(0, hsb.s)),\n\t\t\t\t\tb: Math.min(100, Math.max(0, hsb.b))\n\t\t\t\t};\n\t\t\t}, \n\t\t\tfixRGB = function (rgb) {\n\t\t\t\treturn {\n\t\t\t\t\tr: Math.min(255, Math.max(0, rgb.r)),\n\t\t\t\t\tg: Math.min(255, Math.max(0, rgb.g)),\n\t\t\t\t\tb: Math.min(255, Math.max(0, rgb.b))\n\t\t\t\t};\n\t\t\t},\n\t\t\tfixHex = function (hex) {\n\t\t\t\tvar len = 6 - hex.length;\n\t\t\t\tif (len > 0) {\n\t\t\t\t\tvar o = [];\n\t\t\t\t\tfor (var i=0; i<len; i++) {\n\t\t\t\t\t\to.push('0');\n\t\t\t\t\t}\n\t\t\t\t\to.push(hex);\n\t\t\t\t\thex = o.join('');\n\t\t\t\t}\n\t\t\t\treturn hex;\n\t\t\t}, \n\t\t\tHexToRGB = function (hex) {\n\t\t\t\tvar hex = parseInt(((hex.indexOf('#') > -1) ? hex.substring(1) : hex), 16);\n\t\t\t\treturn {r: hex >> 16, g: (hex & 0x00FF00) >> 8, b: (hex & 0x0000FF)};\n\t\t\t},\n\t\t\tHexToHSB = function (hex) {\n\t\t\t\treturn RGBToHSB(HexToRGB(hex));\n\t\t\t},\n\t\t\tRGBToHSB = function (rgb) {\n\t\t\t\tvar hsb = {\n\t\t\t\t\th: 0,\n\t\t\t\t\ts: 0,\n\t\t\t\t\tb: 0\n\t\t\t\t};\n\t\t\t\tvar min = Math.min(rgb.r, rgb.g, rgb.b);\n\t\t\t\tvar max = Math.max(rgb.r, rgb.g, rgb.b);\n\t\t\t\tvar delta = max - min;\n\t\t\t\thsb.b = max;\n\t\t\t\tif (max != 0) {\n\t\t\t\t\t\n\t\t\t\t}\n\t\t\t\thsb.s = max != 0 ? 255 * delta / max : 0;\n\t\t\t\tif (hsb.s != 0) {\n\t\t\t\t\tif (rgb.r == max) {\n\t\t\t\t\t\thsb.h = (rgb.g - rgb.b) / delta;\n\t\t\t\t\t} else if (rgb.g == max) {\n\t\t\t\t\t\thsb.h = 2 + (rgb.b - rgb.r) / delta;\n\t\t\t\t\t} else {\n\t\t\t\t\t\thsb.h = 4 + (rgb.r - rgb.g) / delta;\n\t\t\t\t\t}\n\t\t\t\t} else {\n\t\t\t\t\thsb.h = -1;\n\t\t\t\t}\n\t\t\t\thsb.h *= 60;\n\t\t\t\tif (hsb.h < 0) {\n\t\t\t\t\thsb.h += 360;\n\t\t\t\t}\n\t\t\t\thsb.s *= 100/255;\n\t\t\t\thsb.b *= 100/255;\n\t\t\t\treturn hsb;\n\t\t\t},\n\t\t\tHSBToRGB = function (hsb) {\n\t\t\t\tvar rgb = {};\n\t\t\t\tvar h = Math.round(hsb.h);\n\t\t\t\tvar s = Math.round(hsb.s*255/100);\n\t\t\t\tvar v = Math.round(hsb.b*255/100);\n\t\t\t\tif(s == 0) {\n\t\t\t\t\trgb.r = rgb.g = rgb.b = v;\n\t\t\t\t} else {\n\t\t\t\t\tvar t1 = v;\n\t\t\t\t\tvar t2 = (255-s)*v/255;\n\t\t\t\t\tvar t3 = (t1-t2)*(h%60)/60;\n\t\t\t\t\tif(h==360) h = 0;\n\t\t\t\t\tif(h<60) {rgb.r=t1;\trgb.b=t2; rgb.g=t2+t3}\n\t\t\t\t\telse if(h<120) {rgb.g=t1; rgb.b=t2;\trgb.r=t1-t3}\n\t\t\t\t\telse if(h<180) {rgb.g=t1; rgb.r=t2;\trgb.b=t2+t3}\n\t\t\t\t\telse if(h<240) {rgb.b=t1; rgb.r=t2;\trgb.g=t1-t3}\n\t\t\t\t\telse if(h<300) {rgb.b=t1; rgb.g=t2;\trgb.r=t2+t3}\n\t\t\t\t\telse if(h<360) {rgb.r=t1; rgb.g=t2;\trgb.b=t1-t3}\n\t\t\t\t\telse {rgb.r=0; rgb.g=0;\trgb.b=0}\n\t\t\t\t}\n\t\t\t\treturn {r:Math.round(rgb.r), g:Math.round(rgb.g), b:Math.round(rgb.b)};\n\t\t\t},\n\t\t\tRGBToHex = function (rgb) {\n\t\t\t\tvar hex = [\n\t\t\t\t\trgb.r.toString(16),\n\t\t\t\t\trgb.g.toString(16),\n\t\t\t\t\trgb.b.toString(16)\n\t\t\t\t];\n\t\t\t\t$.each(hex, function (nr, val) {\n\t\t\t\t\tif (val.length == 1) {\n\t\t\t\t\t\thex[nr] = '0' + val;\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t\treturn hex.join('');\n\t\t\t},\n\t\t\tHSBToHex = function (hsb) {\n\t\t\t\treturn RGBToHex(HSBToRGB(hsb));\n\t\t\t},\n\t\t\trestoreOriginal = function () {\n\t\t\t\tvar cal = $(this).parent();\n\t\t\t\tvar col = cal.data('colorpicker').origColor;\n\t\t\t\tcal.data('colorpicker').color = col;\n\t\t\t\tfillRGBFields(col, cal.get(0));\n\t\t\t\tfillHexFields(col, cal.get(0));\n\t\t\t\tfillHSBFields(col, cal.get(0));\n\t\t\t\tsetSelector(col, cal.get(0));\n\t\t\t\tsetHue(col, cal.get(0));\n\t\t\t\tsetNewColor(col, cal.get(0));\n\t\t\t};\n\t\treturn {\n\t\t\tinit: function (opt) {\n\t\t\t\topt = $.extend({}, defaults, opt||{});\n\t\t\t\tif (typeof opt.color == 'string') {\n\t\t\t\t\topt.color = HexToHSB(opt.color);\n\t\t\t\t} else if (opt.color.r != undefined && opt.color.g != undefined && opt.color.b != undefined) {\n\t\t\t\t\topt.color = RGBToHSB(opt.color);\n\t\t\t\t} else if (opt.color.h != undefined && opt.color.s != undefined && opt.color.b != undefined) {\n\t\t\t\t\topt.color = fixHSB(opt.color);\n\t\t\t\t} else {\n\t\t\t\t\treturn this;\n\t\t\t\t}\n\t\t\t\treturn this.each(function () {\n\t\t\t\t\tif (!$(this).data('colorpickerId')) {\n\t\t\t\t\t\tvar options = $.extend({}, opt);\n\t\t\t\t\t\toptions.origColor = opt.color;\n\t\t\t\t\t\tvar id = 'collorpicker_' + parseInt(Math.random() * 1000);\n\t\t\t\t\t\t$(this).data('colorpickerId', id);\n\t\t\t\t\t\tvar cal = $(tpl).attr('id', id);\n\t\t\t\t\t\tif (options.flat) {\n\t\t\t\t\t\t\tcal.appendTo(this).show();\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tcal.appendTo(document.body);\n\t\t\t\t\t\t}\n\t\t\t\t\t\toptions.fields = cal\n\t\t\t\t\t\t\t\t\t\t\t.find('input')\n\t\t\t\t\t\t\t\t\t\t\t\t.bind('keyup', keyDown)\n\t\t\t\t\t\t\t\t\t\t\t\t.bind('change', change)\n\t\t\t\t\t\t\t\t\t\t\t\t.bind('blur', blur)\n\t\t\t\t\t\t\t\t\t\t\t\t.bind('focus', focus);\n\t\t\t\t\t\tcal\n\t\t\t\t\t\t\t.find('span').bind('mousedown', downIncrement).end()\n\t\t\t\t\t\t\t.find('>div.colorpicker_current_color').bind('click', restoreOriginal);\n\t\t\t\t\t\toptions.selector = cal.find('div.colorpicker_color').bind('mousedown', downSelector);\n\t\t\t\t\t\toptions.selectorIndic = options.selector.find('div div');\n\t\t\t\t\t\toptions.el = this;\n\t\t\t\t\t\toptions.hue = cal.find('div.colorpicker_hue div');\n\t\t\t\t\t\tcal.find('div.colorpicker_hue').bind('mousedown', downHue);\n\t\t\t\t\t\toptions.newColor = cal.find('div.colorpicker_new_color');\n\t\t\t\t\t\toptions.currentColor = cal.find('div.colorpicker_current_color');\n\t\t\t\t\t\tcal.data('colorpicker', options);\n\t\t\t\t\t\tcal.find('div.colorpicker_submit')\n\t\t\t\t\t\t\t.bind('mouseenter', enterSubmit)\n\t\t\t\t\t\t\t.bind('mouseleave', leaveSubmit)\n\t\t\t\t\t\t\t.bind('click', clickSubmit);\n\t\t\t\t\t\tfillRGBFields(options.color, cal.get(0));\n\t\t\t\t\t\tfillHSBFields(options.color, cal.get(0));\n\t\t\t\t\t\tfillHexFields(options.color, cal.get(0));\n\t\t\t\t\t\tsetHue(options.color, cal.get(0));\n\t\t\t\t\t\tsetSelector(options.color, cal.get(0));\n\t\t\t\t\t\tsetCurrentColor(options.color, cal.get(0));\n\t\t\t\t\t\tsetNewColor(options.color, cal.get(0));\n\t\t\t\t\t\tif (options.flat) {\n\t\t\t\t\t\t\tcal.css({\n\t\t\t\t\t\t\t\tposition: 'relative',\n\t\t\t\t\t\t\t\tdisplay: 'block'\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t$(this).bind(options.eventName, show);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t},\n\t\t\tshowPicker: function() {\n\t\t\t\treturn this.each( function () {\n\t\t\t\t\tif ($(this).data('colorpickerId')) {\n\t\t\t\t\t\tshow.apply(this);\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t},\n\t\t\thidePicker: function() {\n\t\t\t\treturn this.each( function () {\n\t\t\t\t\tif ($(this).data('colorpickerId')) {\n\t\t\t\t\t\t$('#' + $(this).data('colorpickerId')).hide();\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t},\n\t\t\tsetColor: function(col) {\n\t\t\t\tif (typeof col == 'string') {\n\t\t\t\t\tcol = HexToHSB(col);\n\t\t\t\t} else if (col.r != undefined && col.g != undefined && col.b != undefined) {\n\t\t\t\t\tcol = RGBToHSB(col);\n\t\t\t\t} else if (col.h != undefined && col.s != undefined && col.b != undefined) {\n\t\t\t\t\tcol = fixHSB(col);\n\t\t\t\t} else {\n\t\t\t\t\treturn this;\n\t\t\t\t}\n\t\t\t\treturn this.each(function(){\n\t\t\t\t\tif ($(this).data('colorpickerId')) {\n\t\t\t\t\t\tvar cal = $('#' + $(this).data('colorpickerId'));\n\t\t\t\t\t\tcal.data('colorpicker').color = col;\n\t\t\t\t\t\tcal.data('colorpicker').origColor = col;\n\t\t\t\t\t\tfillRGBFields(col, cal.get(0));\n\t\t\t\t\t\tfillHSBFields(col, cal.get(0));\n\t\t\t\t\t\tfillHexFields(col, cal.get(0));\n\t\t\t\t\t\tsetHue(col, cal.get(0));\n\t\t\t\t\t\tsetSelector(col, cal.get(0));\n\t\t\t\t\t\tsetCurrentColor(col, cal.get(0));\n\t\t\t\t\t\tsetNewColor(col, cal.get(0));\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\t\t};\n\t}();\n\t$.fn.extend({\n\t\tColorPicker: ColorPicker.init,\n\t\tColorPickerHide: ColorPicker.hidePicker,\n\t\tColorPickerShow: ColorPicker.showPicker,\n\t\tColorPickerSetColor: ColorPicker.setColor\n\t});\n});","jquery/spectrum/tinycolor.js":"// TinyColor v1.4.1\n// https://github.com/bgrins/TinyColor\n// Brian Grinstead, MIT License\n\n(function(Math) {\n\n    var trimLeft = /^\\s+/,\n        trimRight = /\\s+$/,\n        tinyCounter = 0,\n        mathRound = Math.round,\n        mathMin = Math.min,\n        mathMax = Math.max,\n        mathRandom = Math.random;\n\n    function tinycolor (color, opts) {\n\n        color = (color) ? color : '';\n        opts = opts || { };\n\n        // If input is already a tinycolor, return itself\n        if (color instanceof tinycolor) {\n            return color;\n        }\n        // If we are called as a function, call using new instead\n        if (!(this instanceof tinycolor)) {\n            return new tinycolor(color, opts);\n        }\n\n        var rgb = inputToRGB(color);\n        this._originalInput = color,\n            this._r = rgb.r,\n            this._g = rgb.g,\n            this._b = rgb.b,\n            this._a = rgb.a,\n            this._roundA = mathRound(100*this._a) / 100,\n            this._format = opts.format || rgb.format;\n        this._gradientType = opts.gradientType;\n\n        // Don't let the range of [0,255] come back in [0,1].\n        // Potentially lose a little bit of precision here, but will fix issues where\n        // .5 gets interpreted as half of the total, instead of half of 1\n        // If it was supposed to be 128, this was already taken care of by `inputToRgb`\n        if (this._r < 1) { this._r = mathRound(this._r); }\n        if (this._g < 1) { this._g = mathRound(this._g); }\n        if (this._b < 1) { this._b = mathRound(this._b); }\n\n        this._ok = rgb.ok;\n        this._tc_id = tinyCounter++;\n    }\n\n    tinycolor.prototype = {\n        isDark: function() {\n            return this.getBrightness() < 128;\n        },\n        isLight: function() {\n            return !this.isDark();\n        },\n        isValid: function() {\n            return this._ok;\n        },\n        getOriginalInput: function() {\n            return this._originalInput;\n        },\n        getFormat: function() {\n            return this._format;\n        },\n        getAlpha: function() {\n            return this._a;\n        },\n        getBrightness: function() {\n            //http://www.w3.org/TR/AERT#color-contrast\n            var rgb = this.toRgb();\n            return (rgb.r * 299 + rgb.g * 587 + rgb.b * 114) / 1000;\n        },\n        getLuminance: function() {\n            //http://www.w3.org/TR/2008/REC-WCAG20-20081211/#relativeluminancedef\n            var rgb = this.toRgb();\n            var RsRGB, GsRGB, BsRGB, R, G, B;\n            RsRGB = rgb.r/255;\n            GsRGB = rgb.g/255;\n            BsRGB = rgb.b/255;\n\n            if (RsRGB <= 0.03928) {R = RsRGB / 12.92;} else {R = Math.pow(((RsRGB + 0.055) / 1.055), 2.4);}\n            if (GsRGB <= 0.03928) {G = GsRGB / 12.92;} else {G = Math.pow(((GsRGB + 0.055) / 1.055), 2.4);}\n            if (BsRGB <= 0.03928) {B = BsRGB / 12.92;} else {B = Math.pow(((BsRGB + 0.055) / 1.055), 2.4);}\n            return (0.2126 * R) + (0.7152 * G) + (0.0722 * B);\n        },\n        setAlpha: function(value) {\n            this._a = boundAlpha(value);\n            this._roundA = mathRound(100*this._a) / 100;\n            return this;\n        },\n        toHsv: function() {\n            var hsv = rgbToHsv(this._r, this._g, this._b);\n            return { h: hsv.h * 360, s: hsv.s, v: hsv.v, a: this._a };\n        },\n        toHsvString: function() {\n            var hsv = rgbToHsv(this._r, this._g, this._b);\n            var h = mathRound(hsv.h * 360), s = mathRound(hsv.s * 100), v = mathRound(hsv.v * 100);\n            return (this._a == 1) ?\n                \"hsv(\"  + h + \", \" + s + \"%, \" + v + \"%)\" :\n                \"hsva(\" + h + \", \" + s + \"%, \" + v + \"%, \"+ this._roundA + \")\";\n        },\n        toHsl: function() {\n            var hsl = rgbToHsl(this._r, this._g, this._b);\n            return { h: hsl.h * 360, s: hsl.s, l: hsl.l, a: this._a };\n        },\n        toHslString: function() {\n            var hsl = rgbToHsl(this._r, this._g, this._b);\n            var h = mathRound(hsl.h * 360), s = mathRound(hsl.s * 100), l = mathRound(hsl.l * 100);\n            return (this._a == 1) ?\n                \"hsl(\"  + h + \", \" + s + \"%, \" + l + \"%)\" :\n                \"hsla(\" + h + \", \" + s + \"%, \" + l + \"%, \"+ this._roundA + \")\";\n        },\n        toHex: function(allow3Char) {\n            return rgbToHex(this._r, this._g, this._b, allow3Char);\n        },\n        toHexString: function(allow3Char) {\n            return '#' + this.toHex(allow3Char);\n        },\n        toHex8: function(allow4Char) {\n            return rgbaToHex(this._r, this._g, this._b, this._a, allow4Char);\n        },\n        toHex8String: function(allow4Char) {\n            return '#' + this.toHex8(allow4Char);\n        },\n        toRgb: function() {\n            return { r: mathRound(this._r), g: mathRound(this._g), b: mathRound(this._b), a: this._a };\n        },\n        toRgbString: function() {\n            return (this._a == 1) ?\n                \"rgb(\"  + mathRound(this._r) + \", \" + mathRound(this._g) + \", \" + mathRound(this._b) + \")\" :\n                \"rgba(\" + mathRound(this._r) + \", \" + mathRound(this._g) + \", \" + mathRound(this._b) + \", \" + this._roundA + \")\";\n        },\n        toPercentageRgb: function() {\n            return { r: mathRound(bound01(this._r, 255) * 100) + \"%\", g: mathRound(bound01(this._g, 255) * 100) + \"%\", b: mathRound(bound01(this._b, 255) * 100) + \"%\", a: this._a };\n        },\n        toPercentageRgbString: function() {\n            return (this._a == 1) ?\n                \"rgb(\"  + mathRound(bound01(this._r, 255) * 100) + \"%, \" + mathRound(bound01(this._g, 255) * 100) + \"%, \" + mathRound(bound01(this._b, 255) * 100) + \"%)\" :\n                \"rgba(\" + mathRound(bound01(this._r, 255) * 100) + \"%, \" + mathRound(bound01(this._g, 255) * 100) + \"%, \" + mathRound(bound01(this._b, 255) * 100) + \"%, \" + this._roundA + \")\";\n        },\n        toName: function() {\n            if (this._a === 0) {\n                return \"transparent\";\n            }\n\n            if (this._a < 1) {\n                return false;\n            }\n\n            return hexNames[rgbToHex(this._r, this._g, this._b, true)] || false;\n        },\n        toFilter: function(secondColor) {\n            var hex8String = '#' + rgbaToArgbHex(this._r, this._g, this._b, this._a);\n            var secondHex8String = hex8String;\n            var gradientType = this._gradientType ? \"GradientType = 1, \" : \"\";\n\n            if (secondColor) {\n                var s = tinycolor(secondColor);\n                secondHex8String = '#' + rgbaToArgbHex(s._r, s._g, s._b, s._a);\n            }\n\n            return \"progid:DXImageTransform.Microsoft.gradient(\"+gradientType+\"startColorstr=\"+hex8String+\",endColorstr=\"+secondHex8String+\")\";\n        },\n        toString: function(format) {\n            var formatSet = !!format;\n            format = format || this._format;\n\n            var formattedString = false;\n            var hasAlpha = this._a < 1 && this._a >= 0;\n            var needsAlphaFormat = !formatSet && hasAlpha && (format === \"hex\" || format === \"hex6\" || format === \"hex3\" || format === \"hex4\" || format === \"hex8\" || format === \"name\");\n\n            if (needsAlphaFormat) {\n                // Special case for \"transparent\", all other non-alpha formats\n                // will return rgba when there is transparency.\n                if (format === \"name\" && this._a === 0) {\n                    return this.toName();\n                }\n                return this.toRgbString();\n            }\n            if (format === \"rgb\") {\n                formattedString = this.toRgbString();\n            }\n            if (format === \"prgb\") {\n                formattedString = this.toPercentageRgbString();\n            }\n            if (format === \"hex\" || format === \"hex6\") {\n                formattedString = this.toHexString();\n            }\n            if (format === \"hex3\") {\n                formattedString = this.toHexString(true);\n            }\n            if (format === \"hex4\") {\n                formattedString = this.toHex8String(true);\n            }\n            if (format === \"hex8\") {\n                formattedString = this.toHex8String();\n            }\n            if (format === \"name\") {\n                formattedString = this.toName();\n            }\n            if (format === \"hsl\") {\n                formattedString = this.toHslString();\n            }\n            if (format === \"hsv\") {\n                formattedString = this.toHsvString();\n            }\n\n            return formattedString || this.toHexString();\n        },\n        clone: function() {\n            return tinycolor(this.toString());\n        },\n\n        _applyModification: function(fn, args) {\n            var color = fn.apply(null, [this].concat([].slice.call(args)));\n            this._r = color._r;\n            this._g = color._g;\n            this._b = color._b;\n            this.setAlpha(color._a);\n            return this;\n        },\n        lighten: function() {\n            return this._applyModification(lighten, arguments);\n        },\n        brighten: function() {\n            return this._applyModification(brighten, arguments);\n        },\n        darken: function() {\n            return this._applyModification(darken, arguments);\n        },\n        desaturate: function() {\n            return this._applyModification(desaturate, arguments);\n        },\n        saturate: function() {\n            return this._applyModification(saturate, arguments);\n        },\n        greyscale: function() {\n            return this._applyModification(greyscale, arguments);\n        },\n        spin: function() {\n            return this._applyModification(spin, arguments);\n        },\n\n        _applyCombination: function(fn, args) {\n            return fn.apply(null, [this].concat([].slice.call(args)));\n        },\n        analogous: function() {\n            return this._applyCombination(analogous, arguments);\n        },\n        complement: function() {\n            return this._applyCombination(complement, arguments);\n        },\n        monochromatic: function() {\n            return this._applyCombination(monochromatic, arguments);\n        },\n        splitcomplement: function() {\n            return this._applyCombination(splitcomplement, arguments);\n        },\n        triad: function() {\n            return this._applyCombination(triad, arguments);\n        },\n        tetrad: function() {\n            return this._applyCombination(tetrad, arguments);\n        }\n    };\n\n// If input is an object, force 1 into \"1.0\" to handle ratios properly\n// String input requires \"1.0\" as input, so 1 will be treated as 1\n    tinycolor.fromRatio = function(color, opts) {\n        if (typeof color == \"object\") {\n            var newColor = {};\n            for (var i in color) {\n                if (color.hasOwnProperty(i)) {\n                    if (i === \"a\") {\n                        newColor[i] = color[i];\n                    }\n                    else {\n                        newColor[i] = convertToPercentage(color[i]);\n                    }\n                }\n            }\n            color = newColor;\n        }\n\n        return tinycolor(color, opts);\n    };\n\n// Given a string or object, convert that input to RGB\n// Possible string inputs:\n//\n//     \"red\"\n//     \"#f00\" or \"f00\"\n//     \"#ff0000\" or \"ff0000\"\n//     \"#ff000000\" or \"ff000000\"\n//     \"rgb 255 0 0\" or \"rgb (255, 0, 0)\"\n//     \"rgb 1.0 0 0\" or \"rgb (1, 0, 0)\"\n//     \"rgba (255, 0, 0, 1)\" or \"rgba 255, 0, 0, 1\"\n//     \"rgba (1.0, 0, 0, 1)\" or \"rgba 1.0, 0, 0, 1\"\n//     \"hsl(0, 100%, 50%)\" or \"hsl 0 100% 50%\"\n//     \"hsla(0, 100%, 50%, 1)\" or \"hsla 0 100% 50%, 1\"\n//     \"hsv(0, 100%, 100%)\" or \"hsv 0 100% 100%\"\n//\n    function inputToRGB(color) {\n\n        var rgb = { r: 0, g: 0, b: 0 };\n        var a = 1;\n        var s = null;\n        var v = null;\n        var l = null;\n        var ok = false;\n        var format = false;\n\n        if (typeof color == \"string\") {\n            color = stringInputToObject(color);\n        }\n\n        if (typeof color == \"object\") {\n            if (isValidCSSUnit(color.r) && isValidCSSUnit(color.g) && isValidCSSUnit(color.b)) {\n                rgb = rgbToRgb(color.r, color.g, color.b);\n                ok = true;\n                format = String(color.r).substr(-1) === \"%\" ? \"prgb\" : \"rgb\";\n            }\n            else if (isValidCSSUnit(color.h) && isValidCSSUnit(color.s) && isValidCSSUnit(color.v)) {\n                s = convertToPercentage(color.s);\n                v = convertToPercentage(color.v);\n                rgb = hsvToRgb(color.h, s, v);\n                ok = true;\n                format = \"hsv\";\n            }\n            else if (isValidCSSUnit(color.h) && isValidCSSUnit(color.s) && isValidCSSUnit(color.l)) {\n                s = convertToPercentage(color.s);\n                l = convertToPercentage(color.l);\n                rgb = hslToRgb(color.h, s, l);\n                ok = true;\n                format = \"hsl\";\n            }\n\n            if (color.hasOwnProperty(\"a\")) {\n                a = color.a;\n            }\n        }\n\n        a = boundAlpha(a);\n\n        return {\n            ok: ok,\n            format: color.format || format,\n            r: mathMin(255, mathMax(rgb.r, 0)),\n            g: mathMin(255, mathMax(rgb.g, 0)),\n            b: mathMin(255, mathMax(rgb.b, 0)),\n            a: a\n        };\n    }\n\n\n// Conversion Functions\n// --------------------\n\n// `rgbToHsl`, `rgbToHsv`, `hslToRgb`, `hsvToRgb` modified from:\n// <http://mjijackson.com/2008/02/rgb-to-hsl-and-rgb-to-hsv-color-model-conversion-algorithms-in-javascript>\n\n// `rgbToRgb`\n// Handle bounds / percentage checking to conform to CSS color spec\n// <http://www.w3.org/TR/css3-color/>\n// *Assumes:* r, g, b in [0, 255] or [0, 1]\n// *Returns:* { r, g, b } in [0, 255]\n    function rgbToRgb(r, g, b){\n        return {\n            r: bound01(r, 255) * 255,\n            g: bound01(g, 255) * 255,\n            b: bound01(b, 255) * 255\n        };\n    }\n\n// `rgbToHsl`\n// Converts an RGB color value to HSL.\n// *Assumes:* r, g, and b are contained in [0, 255] or [0, 1]\n// *Returns:* { h, s, l } in [0,1]\n    function rgbToHsl(r, g, b) {\n\n        r = bound01(r, 255);\n        g = bound01(g, 255);\n        b = bound01(b, 255);\n\n        var max = mathMax(r, g, b), min = mathMin(r, g, b);\n        var h, s, l = (max + min) / 2;\n\n        if(max == min) {\n            h = s = 0; // achromatic\n        }\n        else {\n            var d = max - min;\n            s = l > 0.5 ? d / (2 - max - min) : d / (max + min);\n            switch(max) {\n                case r: h = (g - b) / d + (g < b ? 6 : 0); break;\n                case g: h = (b - r) / d + 2; break;\n                case b: h = (r - g) / d + 4; break;\n            }\n\n            h /= 6;\n        }\n\n        return { h: h, s: s, l: l };\n    }\n\n// `hslToRgb`\n// Converts an HSL color value to RGB.\n// *Assumes:* h is contained in [0, 1] or [0, 360] and s and l are contained [0, 1] or [0, 100]\n// *Returns:* { r, g, b } in the set [0, 255]\n    function hslToRgb(h, s, l) {\n        var r, g, b;\n\n        h = bound01(h, 360);\n        s = bound01(s, 100);\n        l = bound01(l, 100);\n\n        function hue2rgb(p, q, t) {\n            if(t < 0) t += 1;\n            if(t > 1) t -= 1;\n            if(t < 1/6) return p + (q - p) * 6 * t;\n            if(t < 1/2) return q;\n            if(t < 2/3) return p + (q - p) * (2/3 - t) * 6;\n            return p;\n        }\n\n        if(s === 0) {\n            r = g = b = l; // achromatic\n        }\n        else {\n            var q = l < 0.5 ? l * (1 + s) : l + s - l * s;\n            var p = 2 * l - q;\n            r = hue2rgb(p, q, h + 1/3);\n            g = hue2rgb(p, q, h);\n            b = hue2rgb(p, q, h - 1/3);\n        }\n\n        return { r: r * 255, g: g * 255, b: b * 255 };\n    }\n\n// `rgbToHsv`\n// Converts an RGB color value to HSV\n// *Assumes:* r, g, and b are contained in the set [0, 255] or [0, 1]\n// *Returns:* { h, s, v } in [0,1]\n    function rgbToHsv(r, g, b) {\n\n        r = bound01(r, 255);\n        g = bound01(g, 255);\n        b = bound01(b, 255);\n\n        var max = mathMax(r, g, b), min = mathMin(r, g, b);\n        var h, s, v = max;\n\n        var d = max - min;\n        s = max === 0 ? 0 : d / max;\n\n        if(max == min) {\n            h = 0; // achromatic\n        }\n        else {\n            switch(max) {\n                case r: h = (g - b) / d + (g < b ? 6 : 0); break;\n                case g: h = (b - r) / d + 2; break;\n                case b: h = (r - g) / d + 4; break;\n            }\n            h /= 6;\n        }\n        return { h: h, s: s, v: v };\n    }\n\n// `hsvToRgb`\n// Converts an HSV color value to RGB.\n// *Assumes:* h is contained in [0, 1] or [0, 360] and s and v are contained in [0, 1] or [0, 100]\n// *Returns:* { r, g, b } in the set [0, 255]\n    function hsvToRgb(h, s, v) {\n\n        h = bound01(h, 360) * 6;\n        s = bound01(s, 100);\n        v = bound01(v, 100);\n\n        var i = Math.floor(h),\n            f = h - i,\n            p = v * (1 - s),\n            q = v * (1 - f * s),\n            t = v * (1 - (1 - f) * s),\n            mod = i % 6,\n            r = [v, q, p, p, t, v][mod],\n            g = [t, v, v, q, p, p][mod],\n            b = [p, p, t, v, v, q][mod];\n\n        return { r: r * 255, g: g * 255, b: b * 255 };\n    }\n\n// `rgbToHex`\n// Converts an RGB color to hex\n// Assumes r, g, and b are contained in the set [0, 255]\n// Returns a 3 or 6 character hex\n    function rgbToHex(r, g, b, allow3Char) {\n\n        var hex = [\n            pad2(mathRound(r).toString(16)),\n            pad2(mathRound(g).toString(16)),\n            pad2(mathRound(b).toString(16))\n        ];\n\n        // Return a 3 character hex if possible\n        if (allow3Char && hex[0].charAt(0) == hex[0].charAt(1) && hex[1].charAt(0) == hex[1].charAt(1) && hex[2].charAt(0) == hex[2].charAt(1)) {\n            return hex[0].charAt(0) + hex[1].charAt(0) + hex[2].charAt(0);\n        }\n\n        return hex.join(\"\");\n    }\n\n// `rgbaToHex`\n// Converts an RGBA color plus alpha transparency to hex\n// Assumes r, g, b are contained in the set [0, 255] and\n// a in [0, 1]. Returns a 4 or 8 character rgba hex\n    function rgbaToHex(r, g, b, a, allow4Char) {\n\n        var hex = [\n            pad2(mathRound(r).toString(16)),\n            pad2(mathRound(g).toString(16)),\n            pad2(mathRound(b).toString(16)),\n            pad2(convertDecimalToHex(a))\n        ];\n\n        // Return a 4 character hex if possible\n        if (allow4Char && hex[0].charAt(0) == hex[0].charAt(1) && hex[1].charAt(0) == hex[1].charAt(1) && hex[2].charAt(0) == hex[2].charAt(1) && hex[3].charAt(0) == hex[3].charAt(1)) {\n            return hex[0].charAt(0) + hex[1].charAt(0) + hex[2].charAt(0) + hex[3].charAt(0);\n        }\n\n        return hex.join(\"\");\n    }\n\n// `rgbaToArgbHex`\n// Converts an RGBA color to an ARGB Hex8 string\n// Rarely used, but required for \"toFilter()\"\n    function rgbaToArgbHex(r, g, b, a) {\n\n        var hex = [\n            pad2(convertDecimalToHex(a)),\n            pad2(mathRound(r).toString(16)),\n            pad2(mathRound(g).toString(16)),\n            pad2(mathRound(b).toString(16))\n        ];\n\n        return hex.join(\"\");\n    }\n\n// `equals`\n// Can be called with any tinycolor input\n    tinycolor.equals = function (color1, color2) {\n        if (!color1 || !color2) { return false; }\n        return tinycolor(color1).toRgbString() == tinycolor(color2).toRgbString();\n    };\n\n    tinycolor.random = function() {\n        return tinycolor.fromRatio({\n            r: mathRandom(),\n            g: mathRandom(),\n            b: mathRandom()\n        });\n    };\n\n\n// Modification Functions\n// ----------------------\n// Thanks to less.js for some of the basics here\n// <https://github.com/cloudhead/less.js/blob/master/lib/less/functions.js>\n\n    function desaturate(color, amount) {\n        amount = (amount === 0) ? 0 : (amount || 10);\n        var hsl = tinycolor(color).toHsl();\n        hsl.s -= amount / 100;\n        hsl.s = clamp01(hsl.s);\n        return tinycolor(hsl);\n    }\n\n    function saturate(color, amount) {\n        amount = (amount === 0) ? 0 : (amount || 10);\n        var hsl = tinycolor(color).toHsl();\n        hsl.s += amount / 100;\n        hsl.s = clamp01(hsl.s);\n        return tinycolor(hsl);\n    }\n\n    function greyscale(color) {\n        return tinycolor(color).desaturate(100);\n    }\n\n    function lighten (color, amount) {\n        amount = (amount === 0) ? 0 : (amount || 10);\n        var hsl = tinycolor(color).toHsl();\n        hsl.l += amount / 100;\n        hsl.l = clamp01(hsl.l);\n        return tinycolor(hsl);\n    }\n\n    function brighten(color, amount) {\n        amount = (amount === 0) ? 0 : (amount || 10);\n        var rgb = tinycolor(color).toRgb();\n        rgb.r = mathMax(0, mathMin(255, rgb.r - mathRound(255 * - (amount / 100))));\n        rgb.g = mathMax(0, mathMin(255, rgb.g - mathRound(255 * - (amount / 100))));\n        rgb.b = mathMax(0, mathMin(255, rgb.b - mathRound(255 * - (amount / 100))));\n        return tinycolor(rgb);\n    }\n\n    function darken (color, amount) {\n        amount = (amount === 0) ? 0 : (amount || 10);\n        var hsl = tinycolor(color).toHsl();\n        hsl.l -= amount / 100;\n        hsl.l = clamp01(hsl.l);\n        return tinycolor(hsl);\n    }\n\n// Spin takes a positive or negative amount within [-360, 360] indicating the change of hue.\n// Values outside of this range will be wrapped into this range.\n    function spin(color, amount) {\n        var hsl = tinycolor(color).toHsl();\n        var hue = (hsl.h + amount) % 360;\n        hsl.h = hue < 0 ? 360 + hue : hue;\n        return tinycolor(hsl);\n    }\n\n// Combination Functions\n// ---------------------\n// Thanks to jQuery xColor for some of the ideas behind these\n// <https://github.com/infusion/jQuery-xcolor/blob/master/jquery.xcolor.js>\n\n    function complement(color) {\n        var hsl = tinycolor(color).toHsl();\n        hsl.h = (hsl.h + 180) % 360;\n        return tinycolor(hsl);\n    }\n\n    function triad(color) {\n        var hsl = tinycolor(color).toHsl();\n        var h = hsl.h;\n        return [\n            tinycolor(color),\n            tinycolor({ h: (h + 120) % 360, s: hsl.s, l: hsl.l }),\n            tinycolor({ h: (h + 240) % 360, s: hsl.s, l: hsl.l })\n        ];\n    }\n\n    function tetrad(color) {\n        var hsl = tinycolor(color).toHsl();\n        var h = hsl.h;\n        return [\n            tinycolor(color),\n            tinycolor({ h: (h + 90) % 360, s: hsl.s, l: hsl.l }),\n            tinycolor({ h: (h + 180) % 360, s: hsl.s, l: hsl.l }),\n            tinycolor({ h: (h + 270) % 360, s: hsl.s, l: hsl.l })\n        ];\n    }\n\n    function splitcomplement(color) {\n        var hsl = tinycolor(color).toHsl();\n        var h = hsl.h;\n        return [\n            tinycolor(color),\n            tinycolor({ h: (h + 72) % 360, s: hsl.s, l: hsl.l}),\n            tinycolor({ h: (h + 216) % 360, s: hsl.s, l: hsl.l})\n        ];\n    }\n\n    function analogous(color, results, slices) {\n        results = results || 6;\n        slices = slices || 30;\n\n        var hsl = tinycolor(color).toHsl();\n        var part = 360 / slices;\n        var ret = [tinycolor(color)];\n\n        for (hsl.h = ((hsl.h - (part * results >> 1)) + 720) % 360; --results; ) {\n            hsl.h = (hsl.h + part) % 360;\n            ret.push(tinycolor(hsl));\n        }\n        return ret;\n    }\n\n    function monochromatic(color, results) {\n        results = results || 6;\n        var hsv = tinycolor(color).toHsv();\n        var h = hsv.h, s = hsv.s, v = hsv.v;\n        var ret = [];\n        var modification = 1 / results;\n\n        while (results--) {\n            ret.push(tinycolor({ h: h, s: s, v: v}));\n            v = (v + modification) % 1;\n        }\n\n        return ret;\n    }\n\n// Utility Functions\n// ---------------------\n\n    tinycolor.mix = function(color1, color2, amount) {\n        amount = (amount === 0) ? 0 : (amount || 50);\n\n        var rgb1 = tinycolor(color1).toRgb();\n        var rgb2 = tinycolor(color2).toRgb();\n\n        var p = amount / 100;\n\n        var rgba = {\n            r: ((rgb2.r - rgb1.r) * p) + rgb1.r,\n            g: ((rgb2.g - rgb1.g) * p) + rgb1.g,\n            b: ((rgb2.b - rgb1.b) * p) + rgb1.b,\n            a: ((rgb2.a - rgb1.a) * p) + rgb1.a\n        };\n\n        return tinycolor(rgba);\n    };\n\n\n// Readability Functions\n// ---------------------\n// <http://www.w3.org/TR/2008/REC-WCAG20-20081211/#contrast-ratiodef (WCAG Version 2)\n\n// `contrast`\n// Analyze the 2 colors and returns the color contrast defined by (WCAG Version 2)\n    tinycolor.readability = function(color1, color2) {\n        var c1 = tinycolor(color1);\n        var c2 = tinycolor(color2);\n        return (Math.max(c1.getLuminance(),c2.getLuminance())+0.05) / (Math.min(c1.getLuminance(),c2.getLuminance())+0.05);\n    };\n\n// `isReadable`\n// Ensure that foreground and background color combinations meet WCAG2 guidelines.\n// The third argument is an optional Object.\n//      the 'level' property states 'AA' or 'AAA' - if missing or invalid, it defaults to 'AA';\n//      the 'size' property states 'large' or 'small' - if missing or invalid, it defaults to 'small'.\n// If the entire object is absent, isReadable defaults to {level:\"AA\",size:\"small\"}.\n\n// *Example*\n//    tinycolor.isReadable(\"#000\", \"#111\") => false\n//    tinycolor.isReadable(\"#000\", \"#111\",{level:\"AA\",size:\"large\"}) => false\n    tinycolor.isReadable = function(color1, color2, wcag2) {\n        var readability = tinycolor.readability(color1, color2);\n        var wcag2Parms, out;\n\n        out = false;\n\n        wcag2Parms = validateWCAG2Parms(wcag2);\n        switch (wcag2Parms.level + wcag2Parms.size) {\n            case \"AAsmall\":\n            case \"AAAlarge\":\n                out = readability >= 4.5;\n                break;\n            case \"AAlarge\":\n                out = readability >= 3;\n                break;\n            case \"AAAsmall\":\n                out = readability >= 7;\n                break;\n        }\n        return out;\n\n    };\n\n// `mostReadable`\n// Given a base color and a list of possible foreground or background\n// colors for that base, returns the most readable color.\n// Optionally returns Black or White if the most readable color is unreadable.\n// *Example*\n//    tinycolor.mostReadable(tinycolor.mostReadable(\"#123\", [\"#124\", \"#125\"],{includeFallbackColors:false}).toHexString(); // \"#112255\"\n//    tinycolor.mostReadable(tinycolor.mostReadable(\"#123\", [\"#124\", \"#125\"],{includeFallbackColors:true}).toHexString();  // \"#ffffff\"\n//    tinycolor.mostReadable(\"#a8015a\", [\"#faf3f3\"],{includeFallbackColors:true,level:\"AAA\",size:\"large\"}).toHexString(); // \"#faf3f3\"\n//    tinycolor.mostReadable(\"#a8015a\", [\"#faf3f3\"],{includeFallbackColors:true,level:\"AAA\",size:\"small\"}).toHexString(); // \"#ffffff\"\n    tinycolor.mostReadable = function(baseColor, colorList, args) {\n        var bestColor = null;\n        var bestScore = 0;\n        var readability;\n        var includeFallbackColors, level, size ;\n        args = args || {};\n        includeFallbackColors = args.includeFallbackColors ;\n        level = args.level;\n        size = args.size;\n\n        for (var i= 0; i < colorList.length ; i++) {\n            readability = tinycolor.readability(baseColor, colorList[i]);\n            if (readability > bestScore) {\n                bestScore = readability;\n                bestColor = tinycolor(colorList[i]);\n            }\n        }\n\n        if (tinycolor.isReadable(baseColor, bestColor, {\"level\":level,\"size\":size}) || !includeFallbackColors) {\n            return bestColor;\n        }\n        else {\n            args.includeFallbackColors=false;\n            return tinycolor.mostReadable(baseColor,[\"#fff\", \"#000\"],args);\n        }\n    };\n\n\n// Big List of Colors\n// ------------------\n// <http://www.w3.org/TR/css3-color/#svg-color>\n    var names = tinycolor.names = {\n        aliceblue: \"f0f8ff\",\n        antiquewhite: \"faebd7\",\n        aqua: \"0ff\",\n        aquamarine: \"7fffd4\",\n        azure: \"f0ffff\",\n        beige: \"f5f5dc\",\n        bisque: \"ffe4c4\",\n        black: \"000\",\n        blanchedalmond: \"ffebcd\",\n        blue: \"00f\",\n        blueviolet: \"8a2be2\",\n        brown: \"a52a2a\",\n        burlywood: \"deb887\",\n        burntsienna: \"ea7e5d\",\n        cadetblue: \"5f9ea0\",\n        chartreuse: \"7fff00\",\n        chocolate: \"d2691e\",\n        coral: \"ff7f50\",\n        cornflowerblue: \"6495ed\",\n        cornsilk: \"fff8dc\",\n        crimson: \"dc143c\",\n        cyan: \"0ff\",\n        darkblue: \"00008b\",\n        darkcyan: \"008b8b\",\n        darkgoldenrod: \"b8860b\",\n        darkgray: \"a9a9a9\",\n        darkgreen: \"006400\",\n        darkgrey: \"a9a9a9\",\n        darkkhaki: \"bdb76b\",\n        darkmagenta: \"8b008b\",\n        darkolivegreen: \"556b2f\",\n        darkorange: \"ff8c00\",\n        darkorchid: \"9932cc\",\n        darkred: \"8b0000\",\n        darksalmon: \"e9967a\",\n        darkseagreen: \"8fbc8f\",\n        darkslateblue: \"483d8b\",\n        darkslategray: \"2f4f4f\",\n        darkslategrey: \"2f4f4f\",\n        darkturquoise: \"00ced1\",\n        darkviolet: \"9400d3\",\n        deeppink: \"ff1493\",\n        deepskyblue: \"00bfff\",\n        dimgray: \"696969\",\n        dimgrey: \"696969\",\n        dodgerblue: \"1e90ff\",\n        firebrick: \"b22222\",\n        floralwhite: \"fffaf0\",\n        forestgreen: \"228b22\",\n        fuchsia: \"f0f\",\n        gainsboro: \"dcdcdc\",\n        ghostwhite: \"f8f8ff\",\n        gold: \"ffd700\",\n        goldenrod: \"daa520\",\n        gray: \"808080\",\n        green: \"008000\",\n        greenyellow: \"adff2f\",\n        grey: \"808080\",\n        honeydew: \"f0fff0\",\n        hotpink: \"ff69b4\",\n        indianred: \"cd5c5c\",\n        indigo: \"4b0082\",\n        ivory: \"fffff0\",\n        khaki: \"f0e68c\",\n        lavender: \"e6e6fa\",\n        lavenderblush: \"fff0f5\",\n        lawngreen: \"7cfc00\",\n        lemonchiffon: \"fffacd\",\n        lightblue: \"add8e6\",\n        lightcoral: \"f08080\",\n        lightcyan: \"e0ffff\",\n        lightgoldenrodyellow: \"fafad2\",\n        lightgray: \"d3d3d3\",\n        lightgreen: \"90ee90\",\n        lightgrey: \"d3d3d3\",\n        lightpink: \"ffb6c1\",\n        lightsalmon: \"ffa07a\",\n        lightseagreen: \"20b2aa\",\n        lightskyblue: \"87cefa\",\n        lightslategray: \"789\",\n        lightslategrey: \"789\",\n        lightsteelblue: \"b0c4de\",\n        lightyellow: \"ffffe0\",\n        lime: \"0f0\",\n        limegreen: \"32cd32\",\n        linen: \"faf0e6\",\n        magenta: \"f0f\",\n        maroon: \"800000\",\n        mediumaquamarine: \"66cdaa\",\n        mediumblue: \"0000cd\",\n        mediumorchid: \"ba55d3\",\n        mediumpurple: \"9370db\",\n        mediumseagreen: \"3cb371\",\n        mediumslateblue: \"7b68ee\",\n        mediumspringgreen: \"00fa9a\",\n        mediumturquoise: \"48d1cc\",\n        mediumvioletred: \"c71585\",\n        midnightblue: \"191970\",\n        mintcream: \"f5fffa\",\n        mistyrose: \"ffe4e1\",\n        moccasin: \"ffe4b5\",\n        navajowhite: \"ffdead\",\n        navy: \"000080\",\n        oldlace: \"fdf5e6\",\n        olive: \"808000\",\n        olivedrab: \"6b8e23\",\n        orange: \"ffa500\",\n        orangered: \"ff4500\",\n        orchid: \"da70d6\",\n        palegoldenrod: \"eee8aa\",\n        palegreen: \"98fb98\",\n        paleturquoise: \"afeeee\",\n        palevioletred: \"db7093\",\n        papayawhip: \"ffefd5\",\n        peachpuff: \"ffdab9\",\n        peru: \"cd853f\",\n        pink: \"ffc0cb\",\n        plum: \"dda0dd\",\n        powderblue: \"b0e0e6\",\n        purple: \"800080\",\n        rebeccapurple: \"663399\",\n        red: \"f00\",\n        rosybrown: \"bc8f8f\",\n        royalblue: \"4169e1\",\n        saddlebrown: \"8b4513\",\n        salmon: \"fa8072\",\n        sandybrown: \"f4a460\",\n        seagreen: \"2e8b57\",\n        seashell: \"fff5ee\",\n        sienna: \"a0522d\",\n        silver: \"c0c0c0\",\n        skyblue: \"87ceeb\",\n        slateblue: \"6a5acd\",\n        slategray: \"708090\",\n        slategrey: \"708090\",\n        snow: \"fffafa\",\n        springgreen: \"00ff7f\",\n        steelblue: \"4682b4\",\n        tan: \"d2b48c\",\n        teal: \"008080\",\n        thistle: \"d8bfd8\",\n        tomato: \"ff6347\",\n        turquoise: \"40e0d0\",\n        violet: \"ee82ee\",\n        wheat: \"f5deb3\",\n        white: \"fff\",\n        whitesmoke: \"f5f5f5\",\n        yellow: \"ff0\",\n        yellowgreen: \"9acd32\"\n    };\n\n// Make it easy to access colors via `hexNames[hex]`\n    var hexNames = tinycolor.hexNames = flip(names);\n\n\n// Utilities\n// ---------\n\n// `{ 'name1': 'val1' }` becomes `{ 'val1': 'name1' }`\n    function flip(o) {\n        var flipped = { };\n        for (var i in o) {\n            if (o.hasOwnProperty(i)) {\n                flipped[o[i]] = i;\n            }\n        }\n        return flipped;\n    }\n\n// Return a valid alpha value [0,1] with all invalid values being set to 1\n    function boundAlpha(a) {\n        a = parseFloat(a);\n\n        if (isNaN(a) || a < 0 || a > 1) {\n            a = 1;\n        }\n\n        return a;\n    }\n\n// Take input from [0, n] and return it as [0, 1]\n    function bound01(n, max) {\n        if (isOnePointZero(n)) { n = \"100%\"; }\n\n        var processPercent = isPercentage(n);\n        n = mathMin(max, mathMax(0, parseFloat(n)));\n\n        // Automatically convert percentage into number\n        if (processPercent) {\n            n = parseInt(n * max, 10) / 100;\n        }\n\n        // Handle floating point rounding errors\n        if ((Math.abs(n - max) < 0.000001)) {\n            return 1;\n        }\n\n        // Convert into [0, 1] range if it isn't already\n        return (n % max) / parseFloat(max);\n    }\n\n// Force a number between 0 and 1\n    function clamp01(val) {\n        return mathMin(1, mathMax(0, val));\n    }\n\n// Parse a base-16 hex value into a base-10 integer\n    function parseIntFromHex(val) {\n        return parseInt(val, 16);\n    }\n\n// Need to handle 1.0 as 100%, since once it is a number, there is no difference between it and 1\n// <http://stackoverflow.com/questions/7422072/javascript-how-to-detect-number-as-a-decimal-including-1-0>\n    function isOnePointZero(n) {\n        return typeof n == \"string\" && n.indexOf('.') != -1 && parseFloat(n) === 1;\n    }\n\n// Check to see if string passed in is a percentage\n    function isPercentage(n) {\n        return typeof n === \"string\" && n.indexOf('%') != -1;\n    }\n\n// Force a hex value to have 2 characters\n    function pad2(c) {\n        return c.length == 1 ? '0' + c : '' + c;\n    }\n\n// Replace a decimal with it's percentage value\n    function convertToPercentage(n) {\n        if (n <= 1) {\n            n = (n * 100) + \"%\";\n        }\n\n        return n;\n    }\n\n// Converts a decimal to a hex value\n    function convertDecimalToHex(d) {\n        return Math.round(parseFloat(d) * 255).toString(16);\n    }\n// Converts a hex value to a decimal\n    function convertHexToDecimal(h) {\n        return (parseIntFromHex(h) / 255);\n    }\n\n    var matchers = (function() {\n\n        // <http://www.w3.org/TR/css3-values/#integers>\n        var CSS_INTEGER = \"[-\\\\+]?\\\\d+%?\";\n\n        // <http://www.w3.org/TR/css3-values/#number-value>\n        var CSS_NUMBER = \"[-\\\\+]?\\\\d*\\\\.\\\\d+%?\";\n\n        // Allow positive/negative integer/number.  Don't capture the either/or, just the entire outcome.\n        var CSS_UNIT = \"(?:\" + CSS_NUMBER + \")|(?:\" + CSS_INTEGER + \")\";\n\n        // Actual matching.\n        // Parentheses and commas are optional, but not required.\n        // Whitespace can take the place of commas or opening paren\n        var PERMISSIVE_MATCH3 = \"[\\\\s|\\\\(]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")\\\\s*\\\\)?\";\n        var PERMISSIVE_MATCH4 = \"[\\\\s|\\\\(]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")\\\\s*\\\\)?\";\n\n        return {\n            CSS_UNIT: new RegExp(CSS_UNIT),\n            rgb: new RegExp(\"rgb\" + PERMISSIVE_MATCH3),\n            rgba: new RegExp(\"rgba\" + PERMISSIVE_MATCH4),\n            hsl: new RegExp(\"hsl\" + PERMISSIVE_MATCH3),\n            hsla: new RegExp(\"hsla\" + PERMISSIVE_MATCH4),\n            hsv: new RegExp(\"hsv\" + PERMISSIVE_MATCH3),\n            hsva: new RegExp(\"hsva\" + PERMISSIVE_MATCH4),\n            hex3: /^#?([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,\n            hex6: /^#?([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/,\n            hex4: /^#?([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,\n            hex8: /^#?([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/\n        };\n    })();\n\n// `isValidCSSUnit`\n// Take in a single string / number and check to see if it looks like a CSS unit\n// (see `matchers` above for definition).\n    function isValidCSSUnit(color) {\n        return !!matchers.CSS_UNIT.exec(color);\n    }\n\n// `stringInputToObject`\n// Permissive string parsing.  Take in a number of formats, and output an object\n// based on detected format.  Returns `{ r, g, b }` or `{ h, s, l }` or `{ h, s, v}`\n    function stringInputToObject(color) {\n\n        color = color.replace(trimLeft,'').replace(trimRight, '').toLowerCase();\n        var named = false;\n        if (names[color]) {\n            color = names[color];\n            named = true;\n        }\n        else if (color == 'transparent') {\n            return { r: 0, g: 0, b: 0, a: 0, format: \"name\" };\n        }\n\n        // Try to match string input using regular expressions.\n        // Keep most of the number bounding out of this function - don't worry about [0,1] or [0,100] or [0,360]\n        // Just return an object and let the conversion functions handle that.\n        // This way the result will be the same whether the tinycolor is initialized with string or object.\n        var match;\n        if ((match = matchers.rgb.exec(color))) {\n            return { r: match[1], g: match[2], b: match[3] };\n        }\n        if ((match = matchers.rgba.exec(color))) {\n            return { r: match[1], g: match[2], b: match[3], a: match[4] };\n        }\n        if ((match = matchers.hsl.exec(color))) {\n            return { h: match[1], s: match[2], l: match[3] };\n        }\n        if ((match = matchers.hsla.exec(color))) {\n            return { h: match[1], s: match[2], l: match[3], a: match[4] };\n        }\n        if ((match = matchers.hsv.exec(color))) {\n            return { h: match[1], s: match[2], v: match[3] };\n        }\n        if ((match = matchers.hsva.exec(color))) {\n            return { h: match[1], s: match[2], v: match[3], a: match[4] };\n        }\n        if ((match = matchers.hex8.exec(color))) {\n            return {\n                r: parseIntFromHex(match[1]),\n                g: parseIntFromHex(match[2]),\n                b: parseIntFromHex(match[3]),\n                a: convertHexToDecimal(match[4]),\n                format: named ? \"name\" : \"hex8\"\n            };\n        }\n        if ((match = matchers.hex6.exec(color))) {\n            return {\n                r: parseIntFromHex(match[1]),\n                g: parseIntFromHex(match[2]),\n                b: parseIntFromHex(match[3]),\n                format: named ? \"name\" : \"hex\"\n            };\n        }\n        if ((match = matchers.hex4.exec(color))) {\n            return {\n                r: parseIntFromHex(match[1] + '' + match[1]),\n                g: parseIntFromHex(match[2] + '' + match[2]),\n                b: parseIntFromHex(match[3] + '' + match[3]),\n                a: convertHexToDecimal(match[4] + '' + match[4]),\n                format: named ? \"name\" : \"hex8\"\n            };\n        }\n        if ((match = matchers.hex3.exec(color))) {\n            return {\n                r: parseIntFromHex(match[1] + '' + match[1]),\n                g: parseIntFromHex(match[2] + '' + match[2]),\n                b: parseIntFromHex(match[3] + '' + match[3]),\n                format: named ? \"name\" : \"hex\"\n            };\n        }\n\n        return false;\n    }\n\n    function validateWCAG2Parms(parms) {\n        // return valid WCAG2 parms for isReadable.\n        // If input parms are invalid, return {\"level\":\"AA\", \"size\":\"small\"}\n        var level, size;\n        parms = parms || {\"level\":\"AA\", \"size\":\"small\"};\n        level = (parms.level || \"AA\").toUpperCase();\n        size = (parms.size || \"small\").toLowerCase();\n        if (level !== \"AA\" && level !== \"AAA\") {\n            level = \"AA\";\n        }\n        if (size !== \"small\" && size !== \"large\") {\n            size = \"small\";\n        }\n        return {\"level\":level, \"size\":size};\n    }\n\n// Node: Export function\n    if (typeof module !== \"undefined\" && module.exports) {\n        module.exports = tinycolor;\n    }\n// AMD/requirejs: Define the module\n    else if (typeof define === 'function' && define.amd) {\n        define(function () {return tinycolor;});\n    }\n// Browser: Expose to window\n    else {\n        window.tinycolor = tinycolor;\n    }\n\n})(Math);\n","jquery/spectrum/spectrum.js":"// Spectrum Colorpicker v1.8.0\n// https://github.com/bgrins/spectrum\n// Author: Brian Grinstead\n// License: MIT\n\n(function (factory) {\n    \"use strict\";\n\n    if (typeof define === 'function' && define.amd) { // AMD\n        define(['jquery'], factory);\n    }\n    else if (typeof exports == \"object\" && typeof module == \"object\") { // CommonJS\n        module.exports = factory(require('jquery'));\n    }\n    else { // Browser\n        factory(jQuery);\n    }\n})(function($, undefined) {\n    \"use strict\";\n\n    var defaultOpts = {\n\n            // Callbacks\n            beforeShow: noop,\n            move: noop,\n            change: noop,\n            show: noop,\n            hide: noop,\n\n            // Options\n            color: false,\n            flat: false,\n            showInput: false,\n            allowEmpty: false,\n            showButtons: true,\n            clickoutFiresChange: true,\n            showInitial: false,\n            showPalette: false,\n            showPaletteOnly: false,\n            hideAfterPaletteSelect: false,\n            togglePaletteOnly: false,\n            showSelectionPalette: true,\n            localStorageKey: false,\n            appendTo: \"body\",\n            maxSelectionSize: 7,\n            cancelText: \"cancel\",\n            chooseText: \"choose\",\n            togglePaletteMoreText: \"more\",\n            togglePaletteLessText: \"less\",\n            clearText: \"Clear Color Selection\",\n            noColorSelectedText: \"No Color Selected\",\n            preferredFormat: false,\n            className: \"\", // Deprecated - use containerClassName and replacerClassName instead.\n            containerClassName: \"\",\n            replacerClassName: \"\",\n            showAlpha: false,\n            theme: \"sp-light\",\n            palette: [[\"#ffffff\", \"#000000\", \"#ff0000\", \"#ff8000\", \"#ffff00\", \"#008000\", \"#0000ff\", \"#4b0082\", \"#9400d3\"]],\n            selectionPalette: [],\n            disabled: false,\n            offset: null\n        },\n        spectrums = [],\n        IE = !!/msie/i.exec( window.navigator.userAgent ),\n        rgbaSupport = (function() {\n            function contains( str, substr ) {\n                return !!~('' + str).indexOf(substr);\n            }\n\n            var elem = document.createElement('div');\n            var style = elem.style;\n            style.cssText = 'background-color:rgba(0,0,0,.5)';\n            return contains(style.backgroundColor, 'rgba') || contains(style.backgroundColor, 'hsla');\n        })(),\n        replaceInput = [\n            \"<div class='sp-replacer'>\",\n            \"<div class='sp-preview'><div class='sp-preview-inner'></div></div>\",\n            \"<div class='sp-dd'>&#9660;</div>\",\n            \"</div>\"\n        ].join(''),\n        markup = (function () {\n\n            // IE does not support gradients with multiple stops, so we need to simulate\n            //  that for the rainbow slider with 8 divs that each have a single gradient\n            var gradientFix = \"\";\n            if (IE) {\n                for (var i = 1; i <= 6; i++) {\n                    gradientFix += \"<div class='sp-\" + i + \"'></div>\";\n                }\n            }\n\n            return [\n                \"<div class='sp-container sp-hidden'>\",\n                \"<div class='sp-palette-container'>\",\n                \"<div class='sp-palette sp-thumb sp-cf'></div>\",\n                \"<div class='sp-palette-button-container sp-cf'>\",\n                \"<button type='button' class='sp-palette-toggle'></button>\",\n                \"</div>\",\n                \"</div>\",\n                \"<div class='sp-picker-container'>\",\n                \"<div class='sp-top sp-cf'>\",\n                \"<div class='sp-fill'></div>\",\n                \"<div class='sp-top-inner'>\",\n                \"<div class='sp-color'>\",\n                \"<div class='sp-sat'>\",\n                \"<div class='sp-val'>\",\n                \"<div class='sp-dragger'></div>\",\n                \"</div>\",\n                \"</div>\",\n                \"</div>\",\n                \"<div class='sp-clear sp-clear-display'>\",\n                \"</div>\",\n                \"<div class='sp-hue'>\",\n                \"<div class='sp-slider'></div>\",\n                gradientFix,\n                \"</div>\",\n                \"</div>\",\n                \"<div class='sp-alpha'><div class='sp-alpha-inner'><div class='sp-alpha-handle'></div></div></div>\",\n                \"</div>\",\n                \"<div class='sp-input-container sp-cf'>\",\n                \"<input class='sp-input' type='text' spellcheck='false'  />\",\n                \"</div>\",\n                \"<div class='sp-initial sp-thumb sp-cf'></div>\",\n                \"<div class='sp-button-container sp-cf'>\",\n                \"<a class='sp-cancel' href='#'></a>\",\n                \"<button type='button' class='sp-choose'></button>\",\n                \"</div>\",\n                \"</div>\",\n                \"</div>\"\n            ].join(\"\");\n        })();\n\n    function paletteTemplate (p, color, className, opts) {\n        var html = [];\n        for (var i = 0; i < p.length; i++) {\n            var current = p[i];\n            if(current) {\n                var tiny = tinycolor(current);\n                var c = tiny.toHsl().l < 0.5 ? \"sp-thumb-el sp-thumb-dark\" : \"sp-thumb-el sp-thumb-light\";\n                c += (tinycolor.equals(color, current)) ? \" sp-thumb-active\" : \"\";\n                var formattedString = tiny.toString(opts.preferredFormat || \"rgb\");\n                var swatchStyle = rgbaSupport ? (\"background-color:\" + tiny.toRgbString()) : \"filter:\" + tiny.toFilter();\n                html.push('<span title=\"' + formattedString + '\" data-color=\"' + tiny.toRgbString() + '\" class=\"' + c + '\"><span class=\"sp-thumb-inner\" style=\"' + swatchStyle + ';\" /></span>');\n            } else {\n                var cls = 'sp-clear-display';\n                html.push($('<div />')\n                    .append($('<span data-color=\"\" style=\"background-color:transparent;\" class=\"' + cls + '\"></span>')\n                        .attr('title', opts.noColorSelectedText)\n                    )\n                    .html()\n                );\n            }\n        }\n        return \"<div class='sp-cf \" + className + \"'>\" + html.join('') + \"</div>\";\n    }\n\n    function hideAll() {\n        for (var i = 0; i < spectrums.length; i++) {\n            if (spectrums[i]) {\n                spectrums[i].hide();\n            }\n        }\n    }\n\n    function instanceOptions(o, callbackContext) {\n        var opts = $.extend({}, defaultOpts, o);\n        opts.callbacks = {\n            'move': bind(opts.move, callbackContext),\n            'change': bind(opts.change, callbackContext),\n            'show': bind(opts.show, callbackContext),\n            'hide': bind(opts.hide, callbackContext),\n            'beforeShow': bind(opts.beforeShow, callbackContext)\n        };\n\n        return opts;\n    }\n\n    function spectrum(element, o) {\n\n        var opts = instanceOptions(o, element),\n            flat = opts.flat,\n            showSelectionPalette = opts.showSelectionPalette,\n            localStorageKey = opts.localStorageKey,\n            theme = opts.theme,\n            callbacks = opts.callbacks,\n            resize = throttle(reflow, 10),\n            visible = false,\n            isDragging = false,\n            dragWidth = 0,\n            dragHeight = 0,\n            dragHelperHeight = 0,\n            slideHeight = 0,\n            slideWidth = 0,\n            alphaWidth = 0,\n            alphaSlideHelperWidth = 0,\n            slideHelperHeight = 0,\n            currentHue = 0,\n            currentSaturation = 0,\n            currentValue = 0,\n            currentAlpha = 1,\n            palette = [],\n            paletteArray = [],\n            paletteLookup = {},\n            selectionPalette = opts.selectionPalette.slice(0),\n            maxSelectionSize = opts.maxSelectionSize,\n            draggingClass = \"sp-dragging\",\n            shiftMovementDirection = null;\n\n        var doc = element.ownerDocument,\n            body = doc.body,\n            boundElement = $(element),\n            disabled = false,\n            container = $(markup, doc).addClass(theme),\n            pickerContainer = container.find(\".sp-picker-container\"),\n            dragger = container.find(\".sp-color\"),\n            dragHelper = container.find(\".sp-dragger\"),\n            slider = container.find(\".sp-hue\"),\n            slideHelper = container.find(\".sp-slider\"),\n            alphaSliderInner = container.find(\".sp-alpha-inner\"),\n            alphaSlider = container.find(\".sp-alpha\"),\n            alphaSlideHelper = container.find(\".sp-alpha-handle\"),\n            textInput = container.find(\".sp-input\"),\n            paletteContainer = container.find(\".sp-palette\"),\n            initialColorContainer = container.find(\".sp-initial\"),\n            cancelButton = container.find(\".sp-cancel\"),\n            clearButton = container.find(\".sp-clear\"),\n            chooseButton = container.find(\".sp-choose\"),\n            toggleButton = container.find(\".sp-palette-toggle\"),\n            isInput = boundElement.is(\"input\"),\n            isInputTypeColor = isInput && boundElement.attr(\"type\") === \"color\" && inputTypeColorSupport(),\n            shouldReplace = isInput && !flat,\n            replacer = (shouldReplace) ? $(replaceInput).addClass(theme).addClass(opts.className).addClass(opts.replacerClassName) : $([]),\n            offsetElement = (shouldReplace) ? replacer : boundElement,\n            previewElement = replacer.find(\".sp-preview-inner\"),\n            initialColor = opts.color || (isInput && boundElement.val()),\n            colorOnShow = false,\n            currentPreferredFormat = opts.preferredFormat,\n            clickoutFiresChange = !opts.showButtons || opts.clickoutFiresChange,\n            isEmpty = !initialColor,\n            allowEmpty = opts.allowEmpty && !isInputTypeColor;\n\n        function applyOptions() {\n\n            if (opts.showPaletteOnly) {\n                opts.showPalette = true;\n            }\n\n            toggleButton.text(opts.showPaletteOnly ? opts.togglePaletteMoreText : opts.togglePaletteLessText);\n\n            if (opts.palette) {\n                palette = opts.palette.slice(0);\n                paletteArray = $.isArray(palette[0]) ? palette : [palette];\n                paletteLookup = {};\n                for (var i = 0; i < paletteArray.length; i++) {\n                    for (var j = 0; j < paletteArray[i].length; j++) {\n                        var rgb = tinycolor(paletteArray[i][j]).toRgbString();\n                        paletteLookup[rgb] = true;\n                    }\n                }\n            }\n\n            container.toggleClass(\"sp-flat\", flat);\n            container.toggleClass(\"sp-input-disabled\", !opts.showInput);\n            container.toggleClass(\"sp-alpha-enabled\", opts.showAlpha);\n            container.toggleClass(\"sp-clear-enabled\", allowEmpty);\n            container.toggleClass(\"sp-buttons-disabled\", !opts.showButtons);\n            container.toggleClass(\"sp-palette-buttons-disabled\", !opts.togglePaletteOnly);\n            container.toggleClass(\"sp-palette-disabled\", !opts.showPalette);\n            container.toggleClass(\"sp-palette-only\", opts.showPaletteOnly);\n            container.toggleClass(\"sp-initial-disabled\", !opts.showInitial);\n            container.addClass(opts.className).addClass(opts.containerClassName);\n\n            reflow();\n        }\n\n        function initialize() {\n\n            if (IE) {\n                container.find(\"*:not(input)\").attr(\"unselectable\", \"on\");\n            }\n\n            applyOptions();\n\n            if (shouldReplace) {\n                boundElement.after(replacer).hide();\n            }\n\n            if (!allowEmpty) {\n                clearButton.hide();\n            }\n\n            if (flat) {\n                boundElement.after(container).hide();\n            }\n            else {\n\n                var appendTo = opts.appendTo === \"parent\" ? boundElement.parent() : $(opts.appendTo);\n                if (appendTo.length !== 1) {\n                    appendTo = $(\"body\");\n                }\n\n                appendTo.append(container);\n            }\n\n            updateSelectionPaletteFromStorage();\n\n            offsetElement.bind(\"click.spectrum touchstart.spectrum\", function (e) {\n                if (!disabled) {\n                    toggle();\n                }\n\n                e.stopPropagation();\n\n                if (!$(e.target).is(\"input\")) {\n                    e.preventDefault();\n                }\n            });\n\n            if(boundElement.is(\":disabled\") || (opts.disabled === true)) {\n                disable();\n            }\n\n            // Prevent clicks from bubbling up to document.  This would cause it to be hidden.\n            container.click(stopPropagation);\n\n            // Handle user typed input\n            textInput.change(setFromTextInput);\n            textInput.bind(\"paste\", function () {\n                setTimeout(setFromTextInput, 1);\n            });\n            textInput.keydown(function (e) { if (e.keyCode == 13) { setFromTextInput(); } });\n\n            cancelButton.text(opts.cancelText);\n            cancelButton.bind(\"click.spectrum\", function (e) {\n                e.stopPropagation();\n                e.preventDefault();\n                revert();\n                hide();\n            });\n\n            clearButton.attr(\"title\", opts.clearText);\n            clearButton.bind(\"click.spectrum\", function (e) {\n                e.stopPropagation();\n                e.preventDefault();\n                isEmpty = true;\n                move();\n\n                if(flat) {\n                    //for the flat style, this is a change event\n                    updateOriginalInput(true);\n                }\n            });\n\n            chooseButton.text(opts.chooseText);\n            chooseButton.bind(\"click.spectrum\", function (e) {\n                e.stopPropagation();\n                e.preventDefault();\n\n                if (IE && textInput.is(\":focus\")) {\n                    textInput.trigger('change');\n                }\n\n                if (isValid()) {\n                    updateOriginalInput(true);\n                    hide();\n                }\n            });\n\n            toggleButton.text(opts.showPaletteOnly ? opts.togglePaletteMoreText : opts.togglePaletteLessText);\n            toggleButton.bind(\"click.spectrum\", function (e) {\n                e.stopPropagation();\n                e.preventDefault();\n\n                opts.showPaletteOnly = !opts.showPaletteOnly;\n\n                // To make sure the Picker area is drawn on the right, next to the\n                // Palette area (and not below the palette), first move the Palette\n                // to the left to make space for the picker, plus 5px extra.\n                // The 'applyOptions' function puts the whole container back into place\n                // and takes care of the button-text and the sp-palette-only CSS class.\n                if (!opts.showPaletteOnly && !flat) {\n                    container.css('left', '-=' + (pickerContainer.outerWidth(true) + 5));\n                }\n                applyOptions();\n            });\n\n            draggable(alphaSlider, function (dragX, dragY, e) {\n                currentAlpha = (dragX / alphaWidth);\n                isEmpty = false;\n                if (e.shiftKey) {\n                    currentAlpha = Math.round(currentAlpha * 10) / 10;\n                }\n\n                move();\n            }, dragStart, dragStop);\n\n            draggable(slider, function (dragX, dragY) {\n                currentHue = parseFloat(dragY / slideHeight);\n                isEmpty = false;\n                if (!opts.showAlpha) {\n                    currentAlpha = 1;\n                }\n                move();\n            }, dragStart, dragStop);\n\n            draggable(dragger, function (dragX, dragY, e) {\n\n                // shift+drag should snap the movement to either the x or y axis.\n                if (!e.shiftKey) {\n                    shiftMovementDirection = null;\n                }\n                else if (!shiftMovementDirection) {\n                    var oldDragX = currentSaturation * dragWidth;\n                    var oldDragY = dragHeight - (currentValue * dragHeight);\n                    var furtherFromX = Math.abs(dragX - oldDragX) > Math.abs(dragY - oldDragY);\n\n                    shiftMovementDirection = furtherFromX ? \"x\" : \"y\";\n                }\n\n                var setSaturation = !shiftMovementDirection || shiftMovementDirection === \"x\";\n                var setValue = !shiftMovementDirection || shiftMovementDirection === \"y\";\n\n                if (setSaturation) {\n                    currentSaturation = parseFloat(dragX / dragWidth);\n                }\n                if (setValue) {\n                    currentValue = parseFloat((dragHeight - dragY) / dragHeight);\n                }\n\n                isEmpty = false;\n                if (!opts.showAlpha) {\n                    currentAlpha = 1;\n                }\n\n                move();\n\n            }, dragStart, dragStop);\n\n            if (!!initialColor) {\n                set(initialColor);\n\n                // In case color was black - update the preview UI and set the format\n                // since the set function will not run (default color is black).\n                updateUI();\n                currentPreferredFormat = opts.preferredFormat || tinycolor(initialColor).format;\n\n                addColorToSelectionPalette(initialColor);\n            }\n            else {\n                updateUI();\n            }\n\n            if (flat) {\n                show();\n            }\n\n            function paletteElementClick(e) {\n                if (e.data && e.data.ignore) {\n                    set($(e.target).closest(\".sp-thumb-el\").data(\"color\"));\n                    move();\n                }\n                else {\n                    set($(e.target).closest(\".sp-thumb-el\").data(\"color\"));\n                    move();\n                    updateOriginalInput(true);\n                    if (opts.hideAfterPaletteSelect) {\n                        hide();\n                    }\n                }\n\n                return false;\n            }\n\n            var paletteEvent = IE ? \"mousedown.spectrum\" : \"click.spectrum touchstart.spectrum\";\n            paletteContainer.delegate(\".sp-thumb-el\", paletteEvent, paletteElementClick);\n            initialColorContainer.delegate(\".sp-thumb-el:nth-child(1)\", paletteEvent, { ignore: true }, paletteElementClick);\n        }\n\n        function updateSelectionPaletteFromStorage() {\n\n            if (localStorageKey && window.localStorage) {\n\n                // Migrate old palettes over to new format.  May want to remove this eventually.\n                try {\n                    var oldPalette = window.localStorage[localStorageKey].split(\",#\");\n                    if (oldPalette.length > 1) {\n                        delete window.localStorage[localStorageKey];\n                        $.each(oldPalette, function(i, c) {\n                            addColorToSelectionPalette(c);\n                        });\n                    }\n                }\n                catch(e) { }\n\n                try {\n                    selectionPalette = window.localStorage[localStorageKey].split(\";\");\n                }\n                catch (e) { }\n            }\n        }\n\n        function addColorToSelectionPalette(color) {\n            if (showSelectionPalette) {\n                var rgb = tinycolor(color).toRgbString();\n                if (!paletteLookup[rgb] && $.inArray(rgb, selectionPalette) === -1) {\n                    selectionPalette.push(rgb);\n                    while(selectionPalette.length > maxSelectionSize) {\n                        selectionPalette.shift();\n                    }\n                }\n\n                if (localStorageKey && window.localStorage) {\n                    try {\n                        window.localStorage[localStorageKey] = selectionPalette.join(\";\");\n                    }\n                    catch(e) { }\n                }\n            }\n        }\n\n        function getUniqueSelectionPalette() {\n            var unique = [];\n            if (opts.showPalette) {\n                for (var i = 0; i < selectionPalette.length; i++) {\n                    var rgb = tinycolor(selectionPalette[i]).toRgbString();\n\n                    if (!paletteLookup[rgb]) {\n                        unique.push(selectionPalette[i]);\n                    }\n                }\n            }\n\n            return unique.reverse().slice(0, opts.maxSelectionSize);\n        }\n\n        function drawPalette() {\n\n            var currentColor = get();\n\n            var html = $.map(paletteArray, function (palette, i) {\n                return paletteTemplate(palette, currentColor, \"sp-palette-row sp-palette-row-\" + i, opts);\n            });\n\n            updateSelectionPaletteFromStorage();\n\n            if (selectionPalette) {\n                html.push(paletteTemplate(getUniqueSelectionPalette(), currentColor, \"sp-palette-row sp-palette-row-selection\", opts));\n            }\n\n            paletteContainer.html(html.join(\"\"));\n        }\n\n        function drawInitial() {\n            if (opts.showInitial) {\n                var initial = colorOnShow;\n                var current = get();\n                initialColorContainer.html(paletteTemplate([initial, current], current, \"sp-palette-row-initial\", opts));\n            }\n        }\n\n        function dragStart() {\n            if (dragHeight <= 0 || dragWidth <= 0 || slideHeight <= 0) {\n                reflow();\n            }\n            isDragging = true;\n            container.addClass(draggingClass);\n            shiftMovementDirection = null;\n            boundElement.trigger('dragstart.spectrum', [ get() ]);\n        }\n\n        function dragStop() {\n            isDragging = false;\n            container.removeClass(draggingClass);\n            boundElement.trigger('dragstop.spectrum', [ get() ]);\n        }\n\n        function setFromTextInput() {\n\n            var value = textInput.val();\n\n            if ((value === null || value === \"\") && allowEmpty) {\n                set(null);\n                updateOriginalInput(true);\n            }\n            else {\n                var tiny = tinycolor(value);\n                if (tiny.isValid()) {\n                    set(tiny);\n                    updateOriginalInput(true);\n                }\n                else {\n                    textInput.addClass(\"sp-validation-error\");\n                }\n            }\n        }\n\n        function toggle() {\n            if (visible) {\n                hide();\n            }\n            else {\n                show();\n            }\n        }\n\n        function show() {\n            var event = $.Event('beforeShow.spectrum');\n\n            if (visible) {\n                reflow();\n                return;\n            }\n\n            boundElement.trigger(event, [ get() ]);\n\n            if (callbacks.beforeShow(get()) === false || event.isDefaultPrevented()) {\n                return;\n            }\n\n            hideAll();\n            visible = true;\n\n            $(doc).bind(\"keydown.spectrum\", onkeydown);\n            $(doc).bind(\"click.spectrum\", clickout);\n            $(window).bind(\"resize.spectrum\", resize);\n            replacer.addClass(\"sp-active\");\n            container.removeClass(\"sp-hidden\");\n\n            reflow();\n            updateUI();\n\n            colorOnShow = get();\n\n            drawInitial();\n            callbacks.show(colorOnShow);\n            boundElement.trigger('show.spectrum', [ colorOnShow ]);\n        }\n\n        function onkeydown(e) {\n            // Close on ESC\n            if (e.keyCode === 27) {\n                hide();\n            }\n        }\n\n        function clickout(e) {\n            // Return on right click.\n            if (e.button == 2) { return; }\n\n            // If a drag event was happening during the mouseup, don't hide\n            // on click.\n            if (isDragging) { return; }\n\n            if (clickoutFiresChange) {\n                updateOriginalInput(true);\n            }\n            else {\n                revert();\n            }\n            hide();\n        }\n\n        function hide() {\n            // Return if hiding is unnecessary\n            if (!visible || flat) { return; }\n            visible = false;\n\n            $(doc).unbind(\"keydown.spectrum\", onkeydown);\n            $(doc).unbind(\"click.spectrum\", clickout);\n            $(window).unbind(\"resize.spectrum\", resize);\n\n            replacer.removeClass(\"sp-active\");\n            container.addClass(\"sp-hidden\");\n\n            callbacks.hide(get());\n            boundElement.trigger('hide.spectrum', [ get() ]);\n        }\n\n        function revert() {\n            set(colorOnShow, true);\n        }\n\n        function set(color, ignoreFormatChange) {\n            if (tinycolor.equals(color, get())) {\n                // Update UI just in case a validation error needs\n                // to be cleared.\n                updateUI();\n                return;\n            }\n\n            var newColor, newHsv;\n            if (!color && allowEmpty) {\n                isEmpty = true;\n            } else {\n                isEmpty = false;\n                newColor = tinycolor(color);\n                newHsv = newColor.toHsv();\n\n                currentHue = (newHsv.h % 360) / 360;\n                currentSaturation = newHsv.s;\n                currentValue = newHsv.v;\n                currentAlpha = newHsv.a;\n            }\n            updateUI();\n\n            if (newColor && newColor.isValid() && !ignoreFormatChange) {\n                currentPreferredFormat = opts.preferredFormat || newColor.getFormat();\n            }\n        }\n\n        function get(opts) {\n            opts = opts || { };\n\n            if (allowEmpty && isEmpty) {\n                return null;\n            }\n\n            return tinycolor.fromRatio({\n                h: currentHue,\n                s: currentSaturation,\n                v: currentValue,\n                a: Math.round(currentAlpha * 100) / 100\n            }, { format: opts.format || currentPreferredFormat });\n        }\n\n        function isValid() {\n            return !textInput.hasClass(\"sp-validation-error\");\n        }\n\n        function move() {\n            updateUI();\n\n            callbacks.move(get());\n            boundElement.trigger('move.spectrum', [ get() ]);\n        }\n\n        function updateUI() {\n\n            textInput.removeClass(\"sp-validation-error\");\n\n            updateHelperLocations();\n\n            // Update dragger background color (gradients take care of saturation and value).\n            var flatColor = tinycolor.fromRatio({ h: currentHue, s: 1, v: 1 });\n            dragger.css(\"background-color\", flatColor.toHexString());\n\n            // Get a format that alpha will be included in (hex and names ignore alpha)\n            var format = currentPreferredFormat;\n            if (currentAlpha < 1 && !(currentAlpha === 0 && format === \"name\")) {\n                if (format === \"hex\" || format === \"hex3\" || format === \"hex6\" || format === \"name\") {\n                    format = \"rgb\";\n                }\n            }\n\n            var realColor = get({ format: format }),\n                displayColor = '';\n\n            //reset background info for preview element\n            previewElement.removeClass(\"sp-clear-display\");\n            previewElement.css('background-color', 'transparent');\n\n            if (!realColor && allowEmpty) {\n                // Update the replaced elements background with icon indicating no color selection\n                previewElement.addClass(\"sp-clear-display\");\n            }\n            else {\n                var realHex = realColor.toHexString(),\n                    realRgb = realColor.toRgbString();\n\n                // Update the replaced elements background color (with actual selected color)\n                if (rgbaSupport || realColor.alpha === 1) {\n                    previewElement.css(\"background-color\", realRgb);\n                }\n                else {\n                    previewElement.css(\"background-color\", \"transparent\");\n                    previewElement.css(\"filter\", realColor.toFilter());\n                }\n\n                if (opts.showAlpha) {\n                    var rgb = realColor.toRgb();\n                    rgb.a = 0;\n                    var realAlpha = tinycolor(rgb).toRgbString();\n                    var gradient = \"linear-gradient(left, \" + realAlpha + \", \" + realHex + \")\";\n\n                    if (IE) {\n                        alphaSliderInner.css(\"filter\", tinycolor(realAlpha).toFilter({ gradientType: 1 }, realHex));\n                    }\n                    else {\n                        alphaSliderInner.css(\"background\", \"-webkit-\" + gradient);\n                        alphaSliderInner.css(\"background\", \"-moz-\" + gradient);\n                        alphaSliderInner.css(\"background\", \"-ms-\" + gradient);\n                        // Use current syntax gradient on unprefixed property.\n                        alphaSliderInner.css(\"background\",\n                            \"linear-gradient(to right, \" + realAlpha + \", \" + realHex + \")\");\n                    }\n                }\n\n                displayColor = realColor.toString(format);\n            }\n\n            // Update the text entry input as it changes happen\n            if (opts.showInput) {\n                textInput.val(displayColor);\n            }\n\n            if (opts.showPalette) {\n                drawPalette();\n            }\n\n            drawInitial();\n        }\n\n        function updateHelperLocations() {\n            var s = currentSaturation;\n            var v = currentValue;\n\n            if(allowEmpty && isEmpty) {\n                //if selected color is empty, hide the helpers\n                alphaSlideHelper.hide();\n                slideHelper.hide();\n                dragHelper.hide();\n            }\n            else {\n                //make sure helpers are visible\n                alphaSlideHelper.show();\n                slideHelper.show();\n                dragHelper.show();\n\n                // Where to show the little circle in that displays your current selected color\n                var dragX = s * dragWidth;\n                var dragY = dragHeight - (v * dragHeight);\n                dragX = Math.max(\n                    -dragHelperHeight,\n                    Math.min(dragWidth - dragHelperHeight, dragX - dragHelperHeight)\n                );\n                dragY = Math.max(\n                    -dragHelperHeight,\n                    Math.min(dragHeight - dragHelperHeight, dragY - dragHelperHeight)\n                );\n                dragHelper.css({\n                    \"top\": dragY + \"px\",\n                    \"left\": dragX + \"px\"\n                });\n\n                var alphaX = currentAlpha * alphaWidth;\n                alphaSlideHelper.css({\n                    \"left\": (alphaX - (alphaSlideHelperWidth / 2)) + \"px\"\n                });\n\n                // Where to show the bar that displays your current selected hue\n                var slideY = (currentHue) * slideHeight;\n                slideHelper.css({\n                    \"top\": (slideY - slideHelperHeight) + \"px\"\n                });\n            }\n        }\n\n        function updateOriginalInput(fireCallback) {\n            var color = get(),\n                displayColor = '',\n                hasChanged = !tinycolor.equals(color, colorOnShow);\n\n            if (color) {\n                displayColor = color.toString(currentPreferredFormat);\n                // Update the selection palette with the current color\n                addColorToSelectionPalette(color);\n            }\n\n            if (isInput) {\n                boundElement.val(displayColor);\n            }\n\n            if (fireCallback && hasChanged) {\n                callbacks.change(color);\n                boundElement.trigger('change', [ color ]);\n            }\n        }\n\n        function reflow() {\n            if (!visible) {\n                return; // Calculations would be useless and wouldn't be reliable anyways\n            }\n            dragWidth = dragger.width();\n            dragHeight = dragger.height();\n            dragHelperHeight = dragHelper.height();\n            slideWidth = slider.width();\n            slideHeight = slider.height();\n            slideHelperHeight = slideHelper.height();\n            alphaWidth = alphaSlider.width();\n            alphaSlideHelperWidth = alphaSlideHelper.width();\n\n            if (!flat) {\n                container.css(\"position\", \"absolute\");\n                if (opts.offset) {\n                    container.offset(opts.offset);\n                } else {\n                    container.offset(getOffset(container, offsetElement));\n                }\n            }\n\n            updateHelperLocations();\n\n            if (opts.showPalette) {\n                drawPalette();\n            }\n\n            boundElement.trigger('reflow.spectrum');\n        }\n\n        function destroy() {\n            boundElement.show();\n            offsetElement.unbind(\"click.spectrum touchstart.spectrum\");\n            container.remove();\n            replacer.remove();\n            spectrums[spect.id] = null;\n        }\n\n        function option(optionName, optionValue) {\n            if (optionName === undefined) {\n                return $.extend({}, opts);\n            }\n            if (optionValue === undefined) {\n                return opts[optionName];\n            }\n\n            opts[optionName] = optionValue;\n\n            if (optionName === \"preferredFormat\") {\n                currentPreferredFormat = opts.preferredFormat;\n            }\n            applyOptions();\n        }\n\n        function enable() {\n            disabled = false;\n            boundElement.attr(\"disabled\", false);\n            offsetElement.removeClass(\"sp-disabled\");\n        }\n\n        function disable() {\n            hide();\n            disabled = true;\n            boundElement.attr(\"disabled\", true);\n            offsetElement.addClass(\"sp-disabled\");\n        }\n\n        function setOffset(coord) {\n            opts.offset = coord;\n            reflow();\n        }\n\n        initialize();\n\n        var spect = {\n            show: show,\n            hide: hide,\n            toggle: toggle,\n            reflow: reflow,\n            option: option,\n            enable: enable,\n            disable: disable,\n            offset: setOffset,\n            set: function (c) {\n                set(c);\n                updateOriginalInput();\n            },\n            get: get,\n            destroy: destroy,\n            container: container\n        };\n\n        spect.id = spectrums.push(spect) - 1;\n\n        return spect;\n    }\n\n    /**\n     * checkOffset - get the offset below/above and left/right element depending on screen position\n     * Thanks https://github.com/jquery/jquery-ui/blob/master/ui/jquery.ui.datepicker.js\n     */\n    function getOffset(picker, input) {\n        var extraY = 0;\n        var dpWidth = picker.outerWidth();\n        var dpHeight = picker.outerHeight();\n        var inputHeight = input.outerHeight();\n        var doc = picker[0].ownerDocument;\n        var docElem = doc.documentElement;\n        var viewWidth = docElem.clientWidth + $(doc).scrollLeft();\n        var viewHeight = docElem.clientHeight + $(doc).scrollTop();\n        var offset = input.offset();\n        offset.top += inputHeight;\n\n        offset.left -=\n            Math.min(offset.left, (offset.left + dpWidth > viewWidth && viewWidth > dpWidth) ?\n                Math.abs(offset.left + dpWidth - viewWidth) : 0);\n\n        offset.top -=\n            Math.min(offset.top, ((offset.top + dpHeight > viewHeight && viewHeight > dpHeight) ?\n                Math.abs(dpHeight + inputHeight - extraY) : extraY));\n\n        return offset;\n    }\n\n    /**\n     * noop - do nothing\n     */\n    function noop() {\n\n    }\n\n    /**\n     * stopPropagation - makes the code only doing this a little easier to read in line\n     */\n    function stopPropagation(e) {\n        e.stopPropagation();\n    }\n\n    /**\n     * Create a function bound to a given object\n     * Thanks to underscore.js\n     */\n    function bind(func, obj) {\n        var slice = Array.prototype.slice;\n        var args = slice.call(arguments, 2);\n        return function () {\n            return func.apply(obj, args.concat(slice.call(arguments)));\n        };\n    }\n\n    /**\n     * Lightweight drag helper.  Handles containment within the element, so that\n     * when dragging, the x is within [0,element.width] and y is within [0,element.height]\n     */\n    function draggable(element, onmove, onstart, onstop) {\n        onmove = onmove || function () { };\n        onstart = onstart || function () { };\n        onstop = onstop || function () { };\n        var doc = document;\n        var dragging = false;\n        var offset = {};\n        var maxHeight = 0;\n        var maxWidth = 0;\n        var hasTouch = ('ontouchstart' in window);\n\n        var duringDragEvents = {};\n        duringDragEvents[\"selectstart\"] = prevent;\n        duringDragEvents[\"dragstart\"] = prevent;\n        duringDragEvents[\"touchmove mousemove\"] = move;\n        duringDragEvents[\"touchend mouseup\"] = stop;\n\n        function prevent(e) {\n            if (e.stopPropagation) {\n                e.stopPropagation();\n            }\n            if (e.preventDefault) {\n                e.preventDefault();\n            }\n            e.returnValue = false;\n        }\n\n        function move(e) {\n            if (dragging) {\n                // Mouseup happened outside of window\n                if (IE && doc.documentMode < 9 && !e.button) {\n                    return stop();\n                }\n\n                var t0 = e.originalEvent && e.originalEvent.touches && e.originalEvent.touches[0];\n                var pageX = t0 && t0.pageX || e.pageX;\n                var pageY = t0 && t0.pageY || e.pageY;\n\n                var dragX = Math.max(0, Math.min(pageX - offset.left, maxWidth));\n                var dragY = Math.max(0, Math.min(pageY - offset.top, maxHeight));\n\n                if (hasTouch) {\n                    // Stop scrolling in iOS\n                    prevent(e);\n                }\n\n                onmove.apply(element, [dragX, dragY, e]);\n            }\n        }\n\n        function start(e) {\n            var rightclick = (e.which) ? (e.which == 3) : (e.button == 2);\n\n            if (!rightclick && !dragging) {\n                if (onstart.apply(element, arguments) !== false) {\n                    dragging = true;\n                    maxHeight = $(element).height();\n                    maxWidth = $(element).width();\n                    offset = $(element).offset();\n\n                    $(doc).bind(duringDragEvents);\n                    $(doc.body).addClass(\"sp-dragging\");\n\n                    move(e);\n\n                    prevent(e);\n                }\n            }\n        }\n\n        function stop() {\n            if (dragging) {\n                $(doc).unbind(duringDragEvents);\n                $(doc.body).removeClass(\"sp-dragging\");\n\n                // Wait a tick before notifying observers to allow the click event\n                // to fire in Chrome.\n                setTimeout(function() {\n                    onstop.apply(element, arguments);\n                }, 0);\n            }\n            dragging = false;\n        }\n\n        $(element).bind(\"touchstart mousedown\", start);\n    }\n\n    function throttle(func, wait, debounce) {\n        var timeout;\n        return function () {\n            var context = this, args = arguments;\n            var throttler = function () {\n                timeout = null;\n                func.apply(context, args);\n            };\n            if (debounce) clearTimeout(timeout);\n            if (debounce || !timeout) timeout = setTimeout(throttler, wait);\n        };\n    }\n\n    function inputTypeColorSupport() {\n        return $.fn.spectrum.inputTypeColorSupport();\n    }\n\n    /**\n     * Define a jQuery plugin\n     */\n    var dataID = \"spectrum.id\";\n    $.fn.spectrum = function (opts, extra) {\n\n        if (typeof opts == \"string\") {\n\n            var returnValue = this;\n            var args = Array.prototype.slice.call( arguments, 1 );\n\n            this.each(function () {\n                var spect = spectrums[$(this).data(dataID)];\n                if (spect) {\n                    var method = spect[opts];\n                    if (!method) {\n                        throw new Error( \"Spectrum: no such method: '\" + opts + \"'\" );\n                    }\n\n                    if (opts == \"get\") {\n                        returnValue = spect.get();\n                    }\n                    else if (opts == \"container\") {\n                        returnValue = spect.container;\n                    }\n                    else if (opts == \"option\") {\n                        returnValue = spect.option.apply(spect, args);\n                    }\n                    else if (opts == \"destroy\") {\n                        spect.destroy();\n                        $(this).removeData(dataID);\n                    }\n                    else {\n                        method.apply(spect, args);\n                    }\n                }\n            });\n\n            return returnValue;\n        }\n\n        // Initializing a new instance of spectrum\n        return this.spectrum(\"destroy\").each(function () {\n            var options = $.extend({}, opts, $(this).data());\n            var spect = spectrum(this, options);\n            $(this).data(dataID, spect.id);\n        });\n    };\n\n    $.fn.spectrum.load = true;\n    $.fn.spectrum.loadOpts = {};\n    $.fn.spectrum.draggable = draggable;\n    $.fn.spectrum.defaults = defaultOpts;\n    $.fn.spectrum.inputTypeColorSupport = function inputTypeColorSupport() {\n        if (typeof inputTypeColorSupport._cachedResult === \"undefined\") {\n            var colorInput = $(\"<input type='color'/>\")[0]; // if color element is supported, value will default to not null\n            inputTypeColorSupport._cachedResult = colorInput.type === \"color\" && colorInput.value !== \"\";\n        }\n        return inputTypeColorSupport._cachedResult;\n    };\n\n    $.spectrum = { };\n    $.spectrum.localization = { };\n    $.spectrum.palettes = { };\n\n    $.fn.spectrum.processNativeColorInputs = function () {\n        var colorInputs = $(\"input[type=color]\");\n        if (colorInputs.length && !inputTypeColorSupport()) {\n            colorInputs.spectrum({\n                preferredFormat: \"hex6\"\n            });\n        }\n    };\n\n    // TinyColor v1.1.2\n    // https://github.com/bgrins/TinyColor\n    // Brian Grinstead, MIT License\n\n    (function() {\n\n        var trimLeft = /^[\\s,#]+/,\n            trimRight = /\\s+$/,\n            tinyCounter = 0,\n            math = Math,\n            mathRound = math.round,\n            mathMin = math.min,\n            mathMax = math.max,\n            mathRandom = math.random;\n\n        var tinycolor = function(color, opts) {\n\n            color = (color) ? color : '';\n            opts = opts || { };\n\n            // If input is already a tinycolor, return itself\n            if (color instanceof tinycolor) {\n                return color;\n            }\n            // If we are called as a function, call using new instead\n            if (!(this instanceof tinycolor)) {\n                return new tinycolor(color, opts);\n            }\n\n            var rgb = inputToRGB(color);\n            this._originalInput = color,\n                this._r = rgb.r,\n                this._g = rgb.g,\n                this._b = rgb.b,\n                this._a = rgb.a,\n                this._roundA = mathRound(100*this._a) / 100,\n                this._format = opts.format || rgb.format;\n            this._gradientType = opts.gradientType;\n\n            // Don't let the range of [0,255] come back in [0,1].\n            // Potentially lose a little bit of precision here, but will fix issues where\n            // .5 gets interpreted as half of the total, instead of half of 1\n            // If it was supposed to be 128, this was already taken care of by `inputToRgb`\n            if (this._r < 1) { this._r = mathRound(this._r); }\n            if (this._g < 1) { this._g = mathRound(this._g); }\n            if (this._b < 1) { this._b = mathRound(this._b); }\n\n            this._ok = rgb.ok;\n            this._tc_id = tinyCounter++;\n        };\n\n        tinycolor.prototype = {\n            isDark: function() {\n                return this.getBrightness() < 128;\n            },\n            isLight: function() {\n                return !this.isDark();\n            },\n            isValid: function() {\n                return this._ok;\n            },\n            getOriginalInput: function() {\n                return this._originalInput;\n            },\n            getFormat: function() {\n                return this._format;\n            },\n            getAlpha: function() {\n                return this._a;\n            },\n            getBrightness: function() {\n                var rgb = this.toRgb();\n                return (rgb.r * 299 + rgb.g * 587 + rgb.b * 114) / 1000;\n            },\n            setAlpha: function(value) {\n                this._a = boundAlpha(value);\n                this._roundA = mathRound(100*this._a) / 100;\n                return this;\n            },\n            toHsv: function() {\n                var hsv = rgbToHsv(this._r, this._g, this._b);\n                return { h: hsv.h * 360, s: hsv.s, v: hsv.v, a: this._a };\n            },\n            toHsvString: function() {\n                var hsv = rgbToHsv(this._r, this._g, this._b);\n                var h = mathRound(hsv.h * 360), s = mathRound(hsv.s * 100), v = mathRound(hsv.v * 100);\n                return (this._a == 1) ?\n                    \"hsv(\"  + h + \", \" + s + \"%, \" + v + \"%)\" :\n                    \"hsva(\" + h + \", \" + s + \"%, \" + v + \"%, \"+ this._roundA + \")\";\n            },\n            toHsl: function() {\n                var hsl = rgbToHsl(this._r, this._g, this._b);\n                return { h: hsl.h * 360, s: hsl.s, l: hsl.l, a: this._a };\n            },\n            toHslString: function() {\n                var hsl = rgbToHsl(this._r, this._g, this._b);\n                var h = mathRound(hsl.h * 360), s = mathRound(hsl.s * 100), l = mathRound(hsl.l * 100);\n                return (this._a == 1) ?\n                    \"hsl(\"  + h + \", \" + s + \"%, \" + l + \"%)\" :\n                    \"hsla(\" + h + \", \" + s + \"%, \" + l + \"%, \"+ this._roundA + \")\";\n            },\n            toHex: function(allow3Char) {\n                return rgbToHex(this._r, this._g, this._b, allow3Char);\n            },\n            toHexString: function(allow3Char) {\n                return '#' + this.toHex(allow3Char);\n            },\n            toHex8: function() {\n                return rgbaToHex(this._r, this._g, this._b, this._a);\n            },\n            toHex8String: function() {\n                return '#' + this.toHex8();\n            },\n            toRgb: function() {\n                return { r: mathRound(this._r), g: mathRound(this._g), b: mathRound(this._b), a: this._a };\n            },\n            toRgbString: function() {\n                return (this._a == 1) ?\n                    \"rgb(\"  + mathRound(this._r) + \", \" + mathRound(this._g) + \", \" + mathRound(this._b) + \")\" :\n                    \"rgba(\" + mathRound(this._r) + \", \" + mathRound(this._g) + \", \" + mathRound(this._b) + \", \" + this._roundA + \")\";\n            },\n            toPercentageRgb: function() {\n                return { r: mathRound(bound01(this._r, 255) * 100) + \"%\", g: mathRound(bound01(this._g, 255) * 100) + \"%\", b: mathRound(bound01(this._b, 255) * 100) + \"%\", a: this._a };\n            },\n            toPercentageRgbString: function() {\n                return (this._a == 1) ?\n                    \"rgb(\"  + mathRound(bound01(this._r, 255) * 100) + \"%, \" + mathRound(bound01(this._g, 255) * 100) + \"%, \" + mathRound(bound01(this._b, 255) * 100) + \"%)\" :\n                    \"rgba(\" + mathRound(bound01(this._r, 255) * 100) + \"%, \" + mathRound(bound01(this._g, 255) * 100) + \"%, \" + mathRound(bound01(this._b, 255) * 100) + \"%, \" + this._roundA + \")\";\n            },\n            toName: function() {\n                if (this._a === 0) {\n                    return \"transparent\";\n                }\n\n                if (this._a < 1) {\n                    return false;\n                }\n\n                return hexNames[rgbToHex(this._r, this._g, this._b, true)] || false;\n            },\n            toFilter: function(secondColor) {\n                var hex8String = '#' + rgbaToHex(this._r, this._g, this._b, this._a);\n                var secondHex8String = hex8String;\n                var gradientType = this._gradientType ? \"GradientType = 1, \" : \"\";\n\n                if (secondColor) {\n                    var s = tinycolor(secondColor);\n                    secondHex8String = s.toHex8String();\n                }\n\n                return \"progid:DXImageTransform.Microsoft.gradient(\"+gradientType+\"startColorstr=\"+hex8String+\",endColorstr=\"+secondHex8String+\")\";\n            },\n            toString: function(format) {\n                var formatSet = !!format;\n                format = format || this._format;\n\n                var formattedString = false;\n                var hasAlpha = this._a < 1 && this._a >= 0;\n                var needsAlphaFormat = !formatSet && hasAlpha && (format === \"hex\" || format === \"hex6\" || format === \"hex3\" || format === \"name\");\n\n                if (needsAlphaFormat) {\n                    // Special case for \"transparent\", all other non-alpha formats\n                    // will return rgba when there is transparency.\n                    if (format === \"name\" && this._a === 0) {\n                        return this.toName();\n                    }\n                    return this.toRgbString();\n                }\n                if (format === \"rgb\") {\n                    formattedString = this.toRgbString();\n                }\n                if (format === \"prgb\") {\n                    formattedString = this.toPercentageRgbString();\n                }\n                if (format === \"hex\" || format === \"hex6\") {\n                    formattedString = this.toHexString();\n                }\n                if (format === \"hex3\") {\n                    formattedString = this.toHexString(true);\n                }\n                if (format === \"hex8\") {\n                    formattedString = this.toHex8String();\n                }\n                if (format === \"name\") {\n                    formattedString = this.toName();\n                }\n                if (format === \"hsl\") {\n                    formattedString = this.toHslString();\n                }\n                if (format === \"hsv\") {\n                    formattedString = this.toHsvString();\n                }\n\n                return formattedString || this.toHexString();\n            },\n\n            _applyModification: function(fn, args) {\n                var color = fn.apply(null, [this].concat([].slice.call(args)));\n                this._r = color._r;\n                this._g = color._g;\n                this._b = color._b;\n                this.setAlpha(color._a);\n                return this;\n            },\n            lighten: function() {\n                return this._applyModification(lighten, arguments);\n            },\n            brighten: function() {\n                return this._applyModification(brighten, arguments);\n            },\n            darken: function() {\n                return this._applyModification(darken, arguments);\n            },\n            desaturate: function() {\n                return this._applyModification(desaturate, arguments);\n            },\n            saturate: function() {\n                return this._applyModification(saturate, arguments);\n            },\n            greyscale: function() {\n                return this._applyModification(greyscale, arguments);\n            },\n            spin: function() {\n                return this._applyModification(spin, arguments);\n            },\n\n            _applyCombination: function(fn, args) {\n                return fn.apply(null, [this].concat([].slice.call(args)));\n            },\n            analogous: function() {\n                return this._applyCombination(analogous, arguments);\n            },\n            complement: function() {\n                return this._applyCombination(complement, arguments);\n            },\n            monochromatic: function() {\n                return this._applyCombination(monochromatic, arguments);\n            },\n            splitcomplement: function() {\n                return this._applyCombination(splitcomplement, arguments);\n            },\n            triad: function() {\n                return this._applyCombination(triad, arguments);\n            },\n            tetrad: function() {\n                return this._applyCombination(tetrad, arguments);\n            }\n        };\n\n        // If input is an object, force 1 into \"1.0\" to handle ratios properly\n        // String input requires \"1.0\" as input, so 1 will be treated as 1\n        tinycolor.fromRatio = function(color, opts) {\n            if (typeof color == \"object\") {\n                var newColor = {};\n                for (var i in color) {\n                    if (color.hasOwnProperty(i)) {\n                        if (i === \"a\") {\n                            newColor[i] = color[i];\n                        }\n                        else {\n                            newColor[i] = convertToPercentage(color[i]);\n                        }\n                    }\n                }\n                color = newColor;\n            }\n\n            return tinycolor(color, opts);\n        };\n\n        // Given a string or object, convert that input to RGB\n        // Possible string inputs:\n        //\n        //     \"red\"\n        //     \"#f00\" or \"f00\"\n        //     \"#ff0000\" or \"ff0000\"\n        //     \"#ff000000\" or \"ff000000\"\n        //     \"rgb 255 0 0\" or \"rgb (255, 0, 0)\"\n        //     \"rgb 1.0 0 0\" or \"rgb (1, 0, 0)\"\n        //     \"rgba (255, 0, 0, 1)\" or \"rgba 255, 0, 0, 1\"\n        //     \"rgba (1.0, 0, 0, 1)\" or \"rgba 1.0, 0, 0, 1\"\n        //     \"hsl(0, 100%, 50%)\" or \"hsl 0 100% 50%\"\n        //     \"hsla(0, 100%, 50%, 1)\" or \"hsla 0 100% 50%, 1\"\n        //     \"hsv(0, 100%, 100%)\" or \"hsv 0 100% 100%\"\n        //\n        function inputToRGB(color) {\n\n            var rgb = { r: 0, g: 0, b: 0 };\n            var a = 1;\n            var ok = false;\n            var format = false;\n\n            if (typeof color == \"string\") {\n                color = stringInputToObject(color);\n            }\n\n            if (typeof color == \"object\") {\n                if (color.hasOwnProperty(\"r\") && color.hasOwnProperty(\"g\") && color.hasOwnProperty(\"b\")) {\n                    rgb = rgbToRgb(color.r, color.g, color.b);\n                    ok = true;\n                    format = String(color.r).substr(-1) === \"%\" ? \"prgb\" : \"rgb\";\n                }\n                else if (color.hasOwnProperty(\"h\") && color.hasOwnProperty(\"s\") && color.hasOwnProperty(\"v\")) {\n                    color.s = convertToPercentage(color.s);\n                    color.v = convertToPercentage(color.v);\n                    rgb = hsvToRgb(color.h, color.s, color.v);\n                    ok = true;\n                    format = \"hsv\";\n                }\n                else if (color.hasOwnProperty(\"h\") && color.hasOwnProperty(\"s\") && color.hasOwnProperty(\"l\")) {\n                    color.s = convertToPercentage(color.s);\n                    color.l = convertToPercentage(color.l);\n                    rgb = hslToRgb(color.h, color.s, color.l);\n                    ok = true;\n                    format = \"hsl\";\n                }\n\n                if (color.hasOwnProperty(\"a\")) {\n                    a = color.a;\n                }\n            }\n\n            a = boundAlpha(a);\n\n            return {\n                ok: ok,\n                format: color.format || format,\n                r: mathMin(255, mathMax(rgb.r, 0)),\n                g: mathMin(255, mathMax(rgb.g, 0)),\n                b: mathMin(255, mathMax(rgb.b, 0)),\n                a: a\n            };\n        }\n\n\n        // Conversion Functions\n        // --------------------\n\n        // `rgbToHsl`, `rgbToHsv`, `hslToRgb`, `hsvToRgb` modified from:\n        // <http://mjijackson.com/2008/02/rgb-to-hsl-and-rgb-to-hsv-color-model-conversion-algorithms-in-javascript>\n\n        // `rgbToRgb`\n        // Handle bounds / percentage checking to conform to CSS color spec\n        // <http://www.w3.org/TR/css3-color/>\n        // *Assumes:* r, g, b in [0, 255] or [0, 1]\n        // *Returns:* { r, g, b } in [0, 255]\n        function rgbToRgb(r, g, b){\n            return {\n                r: bound01(r, 255) * 255,\n                g: bound01(g, 255) * 255,\n                b: bound01(b, 255) * 255\n            };\n        }\n\n        // `rgbToHsl`\n        // Converts an RGB color value to HSL.\n        // *Assumes:* r, g, and b are contained in [0, 255] or [0, 1]\n        // *Returns:* { h, s, l } in [0,1]\n        function rgbToHsl(r, g, b) {\n\n            r = bound01(r, 255);\n            g = bound01(g, 255);\n            b = bound01(b, 255);\n\n            var max = mathMax(r, g, b), min = mathMin(r, g, b);\n            var h, s, l = (max + min) / 2;\n\n            if(max == min) {\n                h = s = 0; // achromatic\n            }\n            else {\n                var d = max - min;\n                s = l > 0.5 ? d / (2 - max - min) : d / (max + min);\n                switch(max) {\n                    case r: h = (g - b) / d + (g < b ? 6 : 0); break;\n                    case g: h = (b - r) / d + 2; break;\n                    case b: h = (r - g) / d + 4; break;\n                }\n\n                h /= 6;\n            }\n\n            return { h: h, s: s, l: l };\n        }\n\n        // `hslToRgb`\n        // Converts an HSL color value to RGB.\n        // *Assumes:* h is contained in [0, 1] or [0, 360] and s and l are contained [0, 1] or [0, 100]\n        // *Returns:* { r, g, b } in the set [0, 255]\n        function hslToRgb(h, s, l) {\n            var r, g, b;\n\n            h = bound01(h, 360);\n            s = bound01(s, 100);\n            l = bound01(l, 100);\n\n            function hue2rgb(p, q, t) {\n                if(t < 0) t += 1;\n                if(t > 1) t -= 1;\n                if(t < 1/6) return p + (q - p) * 6 * t;\n                if(t < 1/2) return q;\n                if(t < 2/3) return p + (q - p) * (2/3 - t) * 6;\n                return p;\n            }\n\n            if(s === 0) {\n                r = g = b = l; // achromatic\n            }\n            else {\n                var q = l < 0.5 ? l * (1 + s) : l + s - l * s;\n                var p = 2 * l - q;\n                r = hue2rgb(p, q, h + 1/3);\n                g = hue2rgb(p, q, h);\n                b = hue2rgb(p, q, h - 1/3);\n            }\n\n            return { r: r * 255, g: g * 255, b: b * 255 };\n        }\n\n        // `rgbToHsv`\n        // Converts an RGB color value to HSV\n        // *Assumes:* r, g, and b are contained in the set [0, 255] or [0, 1]\n        // *Returns:* { h, s, v } in [0,1]\n        function rgbToHsv(r, g, b) {\n\n            r = bound01(r, 255);\n            g = bound01(g, 255);\n            b = bound01(b, 255);\n\n            var max = mathMax(r, g, b), min = mathMin(r, g, b);\n            var h, s, v = max;\n\n            var d = max - min;\n            s = max === 0 ? 0 : d / max;\n\n            if(max == min) {\n                h = 0; // achromatic\n            }\n            else {\n                switch(max) {\n                    case r: h = (g - b) / d + (g < b ? 6 : 0); break;\n                    case g: h = (b - r) / d + 2; break;\n                    case b: h = (r - g) / d + 4; break;\n                }\n                h /= 6;\n            }\n            return { h: h, s: s, v: v };\n        }\n\n        // `hsvToRgb`\n        // Converts an HSV color value to RGB.\n        // *Assumes:* h is contained in [0, 1] or [0, 360] and s and v are contained in [0, 1] or [0, 100]\n        // *Returns:* { r, g, b } in the set [0, 255]\n        function hsvToRgb(h, s, v) {\n\n            h = bound01(h, 360) * 6;\n            s = bound01(s, 100);\n            v = bound01(v, 100);\n\n            var i = math.floor(h),\n                f = h - i,\n                p = v * (1 - s),\n                q = v * (1 - f * s),\n                t = v * (1 - (1 - f) * s),\n                mod = i % 6,\n                r = [v, q, p, p, t, v][mod],\n                g = [t, v, v, q, p, p][mod],\n                b = [p, p, t, v, v, q][mod];\n\n            return { r: r * 255, g: g * 255, b: b * 255 };\n        }\n\n        // `rgbToHex`\n        // Converts an RGB color to hex\n        // Assumes r, g, and b are contained in the set [0, 255]\n        // Returns a 3 or 6 character hex\n        function rgbToHex(r, g, b, allow3Char) {\n\n            var hex = [\n                pad2(mathRound(r).toString(16)),\n                pad2(mathRound(g).toString(16)),\n                pad2(mathRound(b).toString(16))\n            ];\n\n            // Return a 3 character hex if possible\n            if (allow3Char && hex[0].charAt(0) == hex[0].charAt(1) && hex[1].charAt(0) == hex[1].charAt(1) && hex[2].charAt(0) == hex[2].charAt(1)) {\n                return hex[0].charAt(0) + hex[1].charAt(0) + hex[2].charAt(0);\n            }\n\n            return hex.join(\"\");\n        }\n        // `rgbaToHex`\n        // Converts an RGBA color plus alpha transparency to hex\n        // Assumes r, g, b and a are contained in the set [0, 255]\n        // Returns an 8 character hex\n        function rgbaToHex(r, g, b, a) {\n\n            var hex = [\n                pad2(convertDecimalToHex(a)),\n                pad2(mathRound(r).toString(16)),\n                pad2(mathRound(g).toString(16)),\n                pad2(mathRound(b).toString(16))\n            ];\n\n            return hex.join(\"\");\n        }\n\n        // `equals`\n        // Can be called with any tinycolor input\n        tinycolor.equals = function (color1, color2) {\n            if (!color1 || !color2) { return false; }\n            return tinycolor(color1).toRgbString() == tinycolor(color2).toRgbString();\n        };\n        tinycolor.random = function() {\n            return tinycolor.fromRatio({\n                r: mathRandom(),\n                g: mathRandom(),\n                b: mathRandom()\n            });\n        };\n\n\n        // Modification Functions\n        // ----------------------\n        // Thanks to less.js for some of the basics here\n        // <https://github.com/cloudhead/less.js/blob/master/lib/less/functions.js>\n\n        function desaturate(color, amount) {\n            amount = (amount === 0) ? 0 : (amount || 10);\n            var hsl = tinycolor(color).toHsl();\n            hsl.s -= amount / 100;\n            hsl.s = clamp01(hsl.s);\n            return tinycolor(hsl);\n        }\n\n        function saturate(color, amount) {\n            amount = (amount === 0) ? 0 : (amount || 10);\n            var hsl = tinycolor(color).toHsl();\n            hsl.s += amount / 100;\n            hsl.s = clamp01(hsl.s);\n            return tinycolor(hsl);\n        }\n\n        function greyscale(color) {\n            return tinycolor(color).desaturate(100);\n        }\n\n        function lighten (color, amount) {\n            amount = (amount === 0) ? 0 : (amount || 10);\n            var hsl = tinycolor(color).toHsl();\n            hsl.l += amount / 100;\n            hsl.l = clamp01(hsl.l);\n            return tinycolor(hsl);\n        }\n\n        function brighten(color, amount) {\n            amount = (amount === 0) ? 0 : (amount || 10);\n            var rgb = tinycolor(color).toRgb();\n            rgb.r = mathMax(0, mathMin(255, rgb.r - mathRound(255 * - (amount / 100))));\n            rgb.g = mathMax(0, mathMin(255, rgb.g - mathRound(255 * - (amount / 100))));\n            rgb.b = mathMax(0, mathMin(255, rgb.b - mathRound(255 * - (amount / 100))));\n            return tinycolor(rgb);\n        }\n\n        function darken (color, amount) {\n            amount = (amount === 0) ? 0 : (amount || 10);\n            var hsl = tinycolor(color).toHsl();\n            hsl.l -= amount / 100;\n            hsl.l = clamp01(hsl.l);\n            return tinycolor(hsl);\n        }\n\n        // Spin takes a positive or negative amount within [-360, 360] indicating the change of hue.\n        // Values outside of this range will be wrapped into this range.\n        function spin(color, amount) {\n            var hsl = tinycolor(color).toHsl();\n            var hue = (mathRound(hsl.h) + amount) % 360;\n            hsl.h = hue < 0 ? 360 + hue : hue;\n            return tinycolor(hsl);\n        }\n\n        // Combination Functions\n        // ---------------------\n        // Thanks to jQuery xColor for some of the ideas behind these\n        // <https://github.com/infusion/jQuery-xcolor/blob/master/jquery.xcolor.js>\n\n        function complement(color) {\n            var hsl = tinycolor(color).toHsl();\n            hsl.h = (hsl.h + 180) % 360;\n            return tinycolor(hsl);\n        }\n\n        function triad(color) {\n            var hsl = tinycolor(color).toHsl();\n            var h = hsl.h;\n            return [\n                tinycolor(color),\n                tinycolor({ h: (h + 120) % 360, s: hsl.s, l: hsl.l }),\n                tinycolor({ h: (h + 240) % 360, s: hsl.s, l: hsl.l })\n            ];\n        }\n\n        function tetrad(color) {\n            var hsl = tinycolor(color).toHsl();\n            var h = hsl.h;\n            return [\n                tinycolor(color),\n                tinycolor({ h: (h + 90) % 360, s: hsl.s, l: hsl.l }),\n                tinycolor({ h: (h + 180) % 360, s: hsl.s, l: hsl.l }),\n                tinycolor({ h: (h + 270) % 360, s: hsl.s, l: hsl.l })\n            ];\n        }\n\n        function splitcomplement(color) {\n            var hsl = tinycolor(color).toHsl();\n            var h = hsl.h;\n            return [\n                tinycolor(color),\n                tinycolor({ h: (h + 72) % 360, s: hsl.s, l: hsl.l}),\n                tinycolor({ h: (h + 216) % 360, s: hsl.s, l: hsl.l})\n            ];\n        }\n\n        function analogous(color, results, slices) {\n            results = results || 6;\n            slices = slices || 30;\n\n            var hsl = tinycolor(color).toHsl();\n            var part = 360 / slices;\n            var ret = [tinycolor(color)];\n\n            for (hsl.h = ((hsl.h - (part * results >> 1)) + 720) % 360; --results; ) {\n                hsl.h = (hsl.h + part) % 360;\n                ret.push(tinycolor(hsl));\n            }\n            return ret;\n        }\n\n        function monochromatic(color, results) {\n            results = results || 6;\n            var hsv = tinycolor(color).toHsv();\n            var h = hsv.h, s = hsv.s, v = hsv.v;\n            var ret = [];\n            var modification = 1 / results;\n\n            while (results--) {\n                ret.push(tinycolor({ h: h, s: s, v: v}));\n                v = (v + modification) % 1;\n            }\n\n            return ret;\n        }\n\n        // Utility Functions\n        // ---------------------\n\n        tinycolor.mix = function(color1, color2, amount) {\n            amount = (amount === 0) ? 0 : (amount || 50);\n\n            var rgb1 = tinycolor(color1).toRgb();\n            var rgb2 = tinycolor(color2).toRgb();\n\n            var p = amount / 100;\n            var w = p * 2 - 1;\n            var a = rgb2.a - rgb1.a;\n\n            var w1;\n\n            if (w * a == -1) {\n                w1 = w;\n            } else {\n                w1 = (w + a) / (1 + w * a);\n            }\n\n            w1 = (w1 + 1) / 2;\n\n            var w2 = 1 - w1;\n\n            var rgba = {\n                r: rgb2.r * w1 + rgb1.r * w2,\n                g: rgb2.g * w1 + rgb1.g * w2,\n                b: rgb2.b * w1 + rgb1.b * w2,\n                a: rgb2.a * p  + rgb1.a * (1 - p)\n            };\n\n            return tinycolor(rgba);\n        };\n\n\n        // Readability Functions\n        // ---------------------\n        // <http://www.w3.org/TR/AERT#color-contrast>\n\n        // `readability`\n        // Analyze the 2 colors and returns an object with the following properties:\n        //    `brightness`: difference in brightness between the two colors\n        //    `color`: difference in color/hue between the two colors\n        tinycolor.readability = function(color1, color2) {\n            var c1 = tinycolor(color1);\n            var c2 = tinycolor(color2);\n            var rgb1 = c1.toRgb();\n            var rgb2 = c2.toRgb();\n            var brightnessA = c1.getBrightness();\n            var brightnessB = c2.getBrightness();\n            var colorDiff = (\n                Math.max(rgb1.r, rgb2.r) - Math.min(rgb1.r, rgb2.r) +\n                Math.max(rgb1.g, rgb2.g) - Math.min(rgb1.g, rgb2.g) +\n                Math.max(rgb1.b, rgb2.b) - Math.min(rgb1.b, rgb2.b)\n            );\n\n            return {\n                brightness: Math.abs(brightnessA - brightnessB),\n                color: colorDiff\n            };\n        };\n\n        // `readable`\n        // http://www.w3.org/TR/AERT#color-contrast\n        // Ensure that foreground and background color combinations provide sufficient contrast.\n        // *Example*\n        //    tinycolor.isReadable(\"#000\", \"#111\") => false\n        tinycolor.isReadable = function(color1, color2) {\n            var readability = tinycolor.readability(color1, color2);\n            return readability.brightness > 125 && readability.color > 500;\n        };\n\n        // `mostReadable`\n        // Given a base color and a list of possible foreground or background\n        // colors for that base, returns the most readable color.\n        // *Example*\n        //    tinycolor.mostReadable(\"#123\", [\"#fff\", \"#000\"]) => \"#000\"\n        tinycolor.mostReadable = function(baseColor, colorList) {\n            var bestColor = null;\n            var bestScore = 0;\n            var bestIsReadable = false;\n            for (var i=0; i < colorList.length; i++) {\n\n                // We normalize both around the \"acceptable\" breaking point,\n                // but rank brightness constrast higher than hue.\n\n                var readability = tinycolor.readability(baseColor, colorList[i]);\n                var readable = readability.brightness > 125 && readability.color > 500;\n                var score = 3 * (readability.brightness / 125) + (readability.color / 500);\n\n                if ((readable && ! bestIsReadable) ||\n                    (readable && bestIsReadable && score > bestScore) ||\n                    ((! readable) && (! bestIsReadable) && score > bestScore)) {\n                    bestIsReadable = readable;\n                    bestScore = score;\n                    bestColor = tinycolor(colorList[i]);\n                }\n            }\n            return bestColor;\n        };\n\n\n        // Big List of Colors\n        // ------------------\n        // <http://www.w3.org/TR/css3-color/#svg-color>\n        var names = tinycolor.names = {\n            aliceblue: \"f0f8ff\",\n            antiquewhite: \"faebd7\",\n            aqua: \"0ff\",\n            aquamarine: \"7fffd4\",\n            azure: \"f0ffff\",\n            beige: \"f5f5dc\",\n            bisque: \"ffe4c4\",\n            black: \"000\",\n            blanchedalmond: \"ffebcd\",\n            blue: \"00f\",\n            blueviolet: \"8a2be2\",\n            brown: \"a52a2a\",\n            burlywood: \"deb887\",\n            burntsienna: \"ea7e5d\",\n            cadetblue: \"5f9ea0\",\n            chartreuse: \"7fff00\",\n            chocolate: \"d2691e\",\n            coral: \"ff7f50\",\n            cornflowerblue: \"6495ed\",\n            cornsilk: \"fff8dc\",\n            crimson: \"dc143c\",\n            cyan: \"0ff\",\n            darkblue: \"00008b\",\n            darkcyan: \"008b8b\",\n            darkgoldenrod: \"b8860b\",\n            darkgray: \"a9a9a9\",\n            darkgreen: \"006400\",\n            darkgrey: \"a9a9a9\",\n            darkkhaki: \"bdb76b\",\n            darkmagenta: \"8b008b\",\n            darkolivegreen: \"556b2f\",\n            darkorange: \"ff8c00\",\n            darkorchid: \"9932cc\",\n            darkred: \"8b0000\",\n            darksalmon: \"e9967a\",\n            darkseagreen: \"8fbc8f\",\n            darkslateblue: \"483d8b\",\n            darkslategray: \"2f4f4f\",\n            darkslategrey: \"2f4f4f\",\n            darkturquoise: \"00ced1\",\n            darkviolet: \"9400d3\",\n            deeppink: \"ff1493\",\n            deepskyblue: \"00bfff\",\n            dimgray: \"696969\",\n            dimgrey: \"696969\",\n            dodgerblue: \"1e90ff\",\n            firebrick: \"b22222\",\n            floralwhite: \"fffaf0\",\n            forestgreen: \"228b22\",\n            fuchsia: \"f0f\",\n            gainsboro: \"dcdcdc\",\n            ghostwhite: \"f8f8ff\",\n            gold: \"ffd700\",\n            goldenrod: \"daa520\",\n            gray: \"808080\",\n            green: \"008000\",\n            greenyellow: \"adff2f\",\n            grey: \"808080\",\n            honeydew: \"f0fff0\",\n            hotpink: \"ff69b4\",\n            indianred: \"cd5c5c\",\n            indigo: \"4b0082\",\n            ivory: \"fffff0\",\n            khaki: \"f0e68c\",\n            lavender: \"e6e6fa\",\n            lavenderblush: \"fff0f5\",\n            lawngreen: \"7cfc00\",\n            lemonchiffon: \"fffacd\",\n            lightblue: \"add8e6\",\n            lightcoral: \"f08080\",\n            lightcyan: \"e0ffff\",\n            lightgoldenrodyellow: \"fafad2\",\n            lightgray: \"d3d3d3\",\n            lightgreen: \"90ee90\",\n            lightgrey: \"d3d3d3\",\n            lightpink: \"ffb6c1\",\n            lightsalmon: \"ffa07a\",\n            lightseagreen: \"20b2aa\",\n            lightskyblue: \"87cefa\",\n            lightslategray: \"789\",\n            lightslategrey: \"789\",\n            lightsteelblue: \"b0c4de\",\n            lightyellow: \"ffffe0\",\n            lime: \"0f0\",\n            limegreen: \"32cd32\",\n            linen: \"faf0e6\",\n            magenta: \"f0f\",\n            maroon: \"800000\",\n            mediumaquamarine: \"66cdaa\",\n            mediumblue: \"0000cd\",\n            mediumorchid: \"ba55d3\",\n            mediumpurple: \"9370db\",\n            mediumseagreen: \"3cb371\",\n            mediumslateblue: \"7b68ee\",\n            mediumspringgreen: \"00fa9a\",\n            mediumturquoise: \"48d1cc\",\n            mediumvioletred: \"c71585\",\n            midnightblue: \"191970\",\n            mintcream: \"f5fffa\",\n            mistyrose: \"ffe4e1\",\n            moccasin: \"ffe4b5\",\n            navajowhite: \"ffdead\",\n            navy: \"000080\",\n            oldlace: \"fdf5e6\",\n            olive: \"808000\",\n            olivedrab: \"6b8e23\",\n            orange: \"ffa500\",\n            orangered: \"ff4500\",\n            orchid: \"da70d6\",\n            palegoldenrod: \"eee8aa\",\n            palegreen: \"98fb98\",\n            paleturquoise: \"afeeee\",\n            palevioletred: \"db7093\",\n            papayawhip: \"ffefd5\",\n            peachpuff: \"ffdab9\",\n            peru: \"cd853f\",\n            pink: \"ffc0cb\",\n            plum: \"dda0dd\",\n            powderblue: \"b0e0e6\",\n            purple: \"800080\",\n            rebeccapurple: \"663399\",\n            red: \"f00\",\n            rosybrown: \"bc8f8f\",\n            royalblue: \"4169e1\",\n            saddlebrown: \"8b4513\",\n            salmon: \"fa8072\",\n            sandybrown: \"f4a460\",\n            seagreen: \"2e8b57\",\n            seashell: \"fff5ee\",\n            sienna: \"a0522d\",\n            silver: \"c0c0c0\",\n            skyblue: \"87ceeb\",\n            slateblue: \"6a5acd\",\n            slategray: \"708090\",\n            slategrey: \"708090\",\n            snow: \"fffafa\",\n            springgreen: \"00ff7f\",\n            steelblue: \"4682b4\",\n            tan: \"d2b48c\",\n            teal: \"008080\",\n            thistle: \"d8bfd8\",\n            tomato: \"ff6347\",\n            turquoise: \"40e0d0\",\n            violet: \"ee82ee\",\n            wheat: \"f5deb3\",\n            white: \"fff\",\n            whitesmoke: \"f5f5f5\",\n            yellow: \"ff0\",\n            yellowgreen: \"9acd32\"\n        };\n\n        // Make it easy to access colors via `hexNames[hex]`\n        var hexNames = tinycolor.hexNames = flip(names);\n\n\n        // Utilities\n        // ---------\n\n        // `{ 'name1': 'val1' }` becomes `{ 'val1': 'name1' }`\n        function flip(o) {\n            var flipped = { };\n            for (var i in o) {\n                if (o.hasOwnProperty(i)) {\n                    flipped[o[i]] = i;\n                }\n            }\n            return flipped;\n        }\n\n        // Return a valid alpha value [0,1] with all invalid values being set to 1\n        function boundAlpha(a) {\n            a = parseFloat(a);\n\n            if (isNaN(a) || a < 0 || a > 1) {\n                a = 1;\n            }\n\n            return a;\n        }\n\n        // Take input from [0, n] and return it as [0, 1]\n        function bound01(n, max) {\n            if (isOnePointZero(n)) { n = \"100%\"; }\n\n            var processPercent = isPercentage(n);\n            n = mathMin(max, mathMax(0, parseFloat(n)));\n\n            // Automatically convert percentage into number\n            if (processPercent) {\n                n = parseInt(n * max, 10) / 100;\n            }\n\n            // Handle floating point rounding errors\n            if ((math.abs(n - max) < 0.000001)) {\n                return 1;\n            }\n\n            // Convert into [0, 1] range if it isn't already\n            return (n % max) / parseFloat(max);\n        }\n\n        // Force a number between 0 and 1\n        function clamp01(val) {\n            return mathMin(1, mathMax(0, val));\n        }\n\n        // Parse a base-16 hex value into a base-10 integer\n        function parseIntFromHex(val) {\n            return parseInt(val, 16);\n        }\n\n        // Need to handle 1.0 as 100%, since once it is a number, there is no difference between it and 1\n        // <http://stackoverflow.com/questions/7422072/javascript-how-to-detect-number-as-a-decimal-including-1-0>\n        function isOnePointZero(n) {\n            return typeof n == \"string\" && n.indexOf('.') != -1 && parseFloat(n) === 1;\n        }\n\n        // Check to see if string passed in is a percentage\n        function isPercentage(n) {\n            return typeof n === \"string\" && n.indexOf('%') != -1;\n        }\n\n        // Force a hex value to have 2 characters\n        function pad2(c) {\n            return c.length == 1 ? '0' + c : '' + c;\n        }\n\n        // Replace a decimal with it's percentage value\n        function convertToPercentage(n) {\n            if (n <= 1) {\n                n = (n * 100) + \"%\";\n            }\n\n            return n;\n        }\n\n        // Converts a decimal to a hex value\n        function convertDecimalToHex(d) {\n            return Math.round(parseFloat(d) * 255).toString(16);\n        }\n        // Converts a hex value to a decimal\n        function convertHexToDecimal(h) {\n            return (parseIntFromHex(h) / 255);\n        }\n\n        var matchers = (function() {\n\n            // <http://www.w3.org/TR/css3-values/#integers>\n            var CSS_INTEGER = \"[-\\\\+]?\\\\d+%?\";\n\n            // <http://www.w3.org/TR/css3-values/#number-value>\n            var CSS_NUMBER = \"[-\\\\+]?\\\\d*\\\\.\\\\d+%?\";\n\n            // Allow positive/negative integer/number.  Don't capture the either/or, just the entire outcome.\n            var CSS_UNIT = \"(?:\" + CSS_NUMBER + \")|(?:\" + CSS_INTEGER + \")\";\n\n            // Actual matching.\n            // Parentheses and commas are optional, but not required.\n            // Whitespace can take the place of commas or opening paren\n            var PERMISSIVE_MATCH3 = \"[\\\\s|\\\\(]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")\\\\s*\\\\)?\";\n            var PERMISSIVE_MATCH4 = \"[\\\\s|\\\\(]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")\\\\s*\\\\)?\";\n\n            return {\n                rgb: new RegExp(\"rgb\" + PERMISSIVE_MATCH3),\n                rgba: new RegExp(\"rgba\" + PERMISSIVE_MATCH4),\n                hsl: new RegExp(\"hsl\" + PERMISSIVE_MATCH3),\n                hsla: new RegExp(\"hsla\" + PERMISSIVE_MATCH4),\n                hsv: new RegExp(\"hsv\" + PERMISSIVE_MATCH3),\n                hsva: new RegExp(\"hsva\" + PERMISSIVE_MATCH4),\n                hex3: /^([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,\n                hex6: /^([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/,\n                hex8: /^([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/\n            };\n        })();\n\n        // `stringInputToObject`\n        // Permissive string parsing.  Take in a number of formats, and output an object\n        // based on detected format.  Returns `{ r, g, b }` or `{ h, s, l }` or `{ h, s, v}`\n        function stringInputToObject(color) {\n\n            color = color.replace(trimLeft,'').replace(trimRight, '').toLowerCase();\n            var named = false;\n            if (names[color]) {\n                color = names[color];\n                named = true;\n            }\n            else if (color == 'transparent') {\n                return { r: 0, g: 0, b: 0, a: 0, format: \"name\" };\n            }\n\n            // Try to match string input using regular expressions.\n            // Keep most of the number bounding out of this function - don't worry about [0,1] or [0,100] or [0,360]\n            // Just return an object and let the conversion functions handle that.\n            // This way the result will be the same whether the tinycolor is initialized with string or object.\n            var match;\n            if ((match = matchers.rgb.exec(color))) {\n                return { r: match[1], g: match[2], b: match[3] };\n            }\n            if ((match = matchers.rgba.exec(color))) {\n                return { r: match[1], g: match[2], b: match[3], a: match[4] };\n            }\n            if ((match = matchers.hsl.exec(color))) {\n                return { h: match[1], s: match[2], l: match[3] };\n            }\n            if ((match = matchers.hsla.exec(color))) {\n                return { h: match[1], s: match[2], l: match[3], a: match[4] };\n            }\n            if ((match = matchers.hsv.exec(color))) {\n                return { h: match[1], s: match[2], v: match[3] };\n            }\n            if ((match = matchers.hsva.exec(color))) {\n                return { h: match[1], s: match[2], v: match[3], a: match[4] };\n            }\n            if ((match = matchers.hex8.exec(color))) {\n                return {\n                    a: convertHexToDecimal(match[1]),\n                    r: parseIntFromHex(match[2]),\n                    g: parseIntFromHex(match[3]),\n                    b: parseIntFromHex(match[4]),\n                    format: named ? \"name\" : \"hex8\"\n                };\n            }\n            if ((match = matchers.hex6.exec(color))) {\n                return {\n                    r: parseIntFromHex(match[1]),\n                    g: parseIntFromHex(match[2]),\n                    b: parseIntFromHex(match[3]),\n                    format: named ? \"name\" : \"hex\"\n                };\n            }\n            if ((match = matchers.hex3.exec(color))) {\n                return {\n                    r: parseIntFromHex(match[1] + '' + match[1]),\n                    g: parseIntFromHex(match[2] + '' + match[2]),\n                    b: parseIntFromHex(match[3] + '' + match[3]),\n                    format: named ? \"name\" : \"hex\"\n                };\n            }\n\n            return false;\n        }\n\n        window.tinycolor = tinycolor;\n    })();\n\n    $(function () {\n        if ($.fn.spectrum.load) {\n            $.fn.spectrum.processNativeColorInputs();\n        }\n    });\n\n});\n","Amazon_Login/js/amazon-csrf.js":"/**\n * Copyright 2016 Amazon.com, Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\").\n * You may not use this file except in compliance with the License.\n * A copy of the License is located at\n *\n *  http://aws.amazon.com/apache2.0\n *\n * or in the \"license\" file accompanying this file. This file is distributed\n * on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either\n * express or implied. See the License for the specific language governing\n * permissions and limitations under the License.\n */\n\ndefine([\n    'sjcl',\n    'jquery',\n    'mage/cookies'\n], function (sjcl, $) {\n    'use strict';\n\n    return {\n        options: {\n            wordsLength: 8,\n            cookieName: 'amazon-csrf-state'\n        },\n\n        /**\n         * Create random string for Amazon CSRF cookie\n         */\n        generateNewValue: function () {\n            var randomString = sjcl.codec.base64.fromBits(sjcl.random.randomWords(this.options.wordsLength));\n\n            $.mage.cookies.set(this.options.cookieName, randomString);\n\n            return randomString;\n        },\n\n        /**\n         * Check if Amazon CSRF cookie is valid and clear cookie\n         * @param {String} stateString\n         * @returns {Boolean}\n         */\n        isValid: function (stateString) {\n            var isValid = $.mage.cookies.get(this.options.cookieName) === stateString;\n\n            this.clear(); // always clear nonce when validating\n\n            return isValid;\n        },\n\n        /**\n         * Clear Amazon CSRF cookie\n         */\n        clear: function () {\n            $.mage.cookies.clear(this.options.cookieName);\n        }\n    };\n});\n","Amazon_Login/js/amazon-redirect.js":"/**\n * Copyright 2016 Amazon.com, Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\").\n * You may not use this file except in compliance with the License.\n * A copy of the License is located at\n *\n *  http://aws.amazon.com/apache2.0\n *\n * or in the \"license\" file accompanying this file. This file is distributed\n * on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either\n * express or implied. See the License for the specific language governing\n * permissions and limitations under the License.\n */\n\ndefine([\n    'jquery',\n    'amazonCore',\n    'amazonPaymentConfig',\n    'amazonCsrf',\n    'Magento_Customer/js/customer-data',\n    'mage/loader',\n    'mage/cookies'\n], function ($, amazonCore, amazonPaymentConfig, amazonCsrf, customerData) {\n    'use strict';\n\n    var self;\n\n    $.widget('amazon.AmazonRedirect', {\n\n        /**\n         * @private\n         */\n        _create: function () {\n\n            self = this;\n            // start the loading animation. WIll en on redirect, no explicit stop here\n            $('body').trigger('processStart');\n\n            //verify nonce first\n            this.redirectOnInvalidState();\n\n            // we don't have the customer's consent or invalid request\n            this.redirectOnRequestWithError();\n            this.setAuthStateCookies();\n            self.redirect();\n        },\n\n        /**\n         * getURLParamater from URL for access OAuth Token\n         * @param {String} name\n         * @param {String} source\n         * @returns {String|Null}\n         */\n        getURLParameter: function (name, source) {\n            return decodeURIComponent((new RegExp('[?|&|#]' + name + '=' +\n                    '([^&]+?)(&|#|;|$)').exec(source) || [,''])[1].replace(\n                        /\\+/g,\n                        '%20'\n                    )) || null;\n        },\n\n        /**\n         * Set State Cache Auth Cookies if they aren't already set\n         * @returns {Boolean}\n         */\n        setAuthStateCookies: function () {\n            var token = this.getURLParameter('access_token', location.hash);\n\n            if (typeof token === 'string' && token.match(/^Atza/)) {\n                $.mage.cookies.set('amazon_Login_accessToken', token);\n            }\n\n            return true;\n        },\n\n        /**\n         * Redirect user to correct controller which logs them into M2 via Amazon hash\n         */\n        redirect: function () {\n            window.location = amazonPaymentConfig.getValue('redirectUrl') + '?access_token=' +\n                this.getURLParameter('access_token', location.hash);\n        },\n\n        /**\n         * Redirect user on invalid state\n         */\n        redirectOnInvalidState: function () {\n            var state = this.getURLParameter('state', location.hash);\n\n            if (!state || !amazonCsrf.isValid(state)) {\n                window.location = amazonPaymentConfig.getValue('customerLoginPageUrl');\n            }\n        },\n\n        /**\n         * Redirect user on request error\n         */\n        redirectOnRequestWithError: function () {\n            if (this.getURLParameter('error', window.location)) {\n                window.location = amazonPaymentConfig.getValue('customerLoginPageUrl');\n            }\n        }\n    });\n\n    return $.amazon.AmazonRedirect;\n});\n","Amazon_Login/js/amazon-logout.js":"/**\n * Copyright 2016 Amazon.com, Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\").\n * You may not use this file except in compliance with the License.\n * A copy of the License is located at\n *\n *  http://aws.amazon.com/apache2.0\n *\n * or in the \"license\" file accompanying this file. This file is distributed\n * on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either\n * express or implied. See the License for the specific language governing\n * permissions and limitations under the License.\n */\n\ndefine([\n    'jquery',\n    'amazonCore',\n    'mage/cookies'\n], function ($, core) {\n    'use strict';\n\n    $.widget('amazon.AmazonLogout', {\n        options: {\n            onInit: false\n        },\n\n        /**\n         * Create Amazon Logout Widget\n         * @private\n         */\n        _create: function () {\n            if (this.options.onInit) {\n                core.AmazonLogout(); //logout amazon user on init\n                $.mage.cookies.clear('amazon_Login_accessToken');\n            }\n        },\n\n        /**\n         * Logs out a user if called directly\n         * @private\n         */\n        _logoutAmazonUser: function () {\n            core.AmazonLogout();\n            $.mage.cookies.clear('amazon_Login_accessToken');\n        }\n    });\n\n    return $.amazon.AmazonLogout;\n});\n","Amazon_Login/js/view/login-button-wrapper.js":"/**\n * Copyright 2016 Amazon.com, Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\").\n * You may not use this file except in compliance with the License.\n * A copy of the License is located at\n *\n *  http://aws.amazon.com/apache2.0\n *\n * or in the \"license\" file accompanying this file. This file is distributed\n * on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either\n * express or implied. See the License for the specific language governing\n * permissions and limitations under the License.\n */\n\ndefine(['uiRegistry', 'Amazon_Login/js/view/login-button', 'uiComponent'], function(registry, login, component) {\n    'use strict';\n    var amazonPayment = registry.get('amazonPayment');\n\n    if (amazonPayment !== undefined && amazonPayment.allowAmLoginLoading === true) {\n        return login;\n    }\n    return component;\n});\n","Amazon_Login/js/view/login-button.js":"/**\n * Copyright 2016 Amazon.com, Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\").\n * You may not use this file except in compliance with the License.\n * A copy of the License is located at\n *\n *  http://aws.amazon.com/apache2.0\n *\n * or in the \"license\" file accompanying this file. This file is distributed\n * on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either\n * express or implied. See the License for the specific language governing\n * permissions and limitations under the License.\n */\n\ndefine(\n    [\n        'jquery',\n        'uiComponent',\n        'ko',\n        'Magento_Customer/js/model/customer',\n        'Amazon_Payment/js/model/storage',\n        'amazonPaymentConfig'\n    ],\n    function (\n        $,\n        Component,\n        ko,\n        customer,\n        amazonStorage,\n        amazonPaymentConfig\n    ) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                template: 'Amazon_Login/login-button'\n            },\n            isCustomerLoggedIn: customer.isLoggedIn,\n            isAmazonAccountLoggedIn: amazonStorage.isAmazonAccountLoggedIn,\n            isLwaVisible: ko.observable(amazonPaymentConfig.getValue('isLwaEnabled')),\n\n            /**\n             * Initialize login button\n             */\n            initialize: function () {\n                this._super();\n            }\n        });\n    }\n);\n","Magento_Wishlist/js/add-to-wishlist.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.addToWishlist', {\n        options: {\n            bundleInfo: 'div.control [name^=bundle_option]',\n            configurableInfo: '.super-attribute-select',\n            groupedInfo: '#super-product-table input',\n            downloadableInfo: '#downloadable-links-list input',\n            customOptionsInfo: '.product-custom-option',\n            qtyInfo: '#qty',\n            actionElement: '[data-action=\"add-to-wishlist\"]',\n            productListWrapper: '.product-item-info',\n            productPageWrapper: '.product-info-main'\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this._bind();\n        },\n\n        /**\n         * @private\n         */\n        _bind: function () {\n            var options = this.options,\n                dataUpdateFunc = '_updateWishlistData',\n                validateProductQty = '_validateWishlistQty',\n                changeCustomOption = 'change ' + options.customOptionsInfo,\n                changeQty = 'change ' + options.qtyInfo,\n                updateWishlist = 'click ' + options.actionElement,\n                events = {},\n                key;\n\n            if ('productType' in options) {\n                if (typeof options.productType === 'string') {\n                    options.productType = [options.productType];\n                }\n            } else {\n                options.productType = [];\n            }\n\n            events[changeCustomOption] = dataUpdateFunc;\n            events[changeQty] = dataUpdateFunc;\n            events[updateWishlist] = validateProductQty;\n\n            for (key in options.productType) {\n                if (options.productType.hasOwnProperty(key) && options.productType[key] + 'Info' in options) {\n                    events['change ' + options[options.productType[key] + 'Info']] = dataUpdateFunc;\n                }\n            }\n            this._on(events);\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _updateWishlistData: function (event) {\n            var dataToAdd = {},\n                isFileUploaded = false,\n                handleObjSelector = null,\n                self = this;\n\n            if (event.handleObj.selector == this.options.qtyInfo) { //eslint-disable-line eqeqeq\n                this._updateAddToWishlistButton({}, event);\n                event.stopPropagation();\n\n                return;\n            }\n\n            handleObjSelector = $(event.currentTarget).closest('form').find(event.handleObj.selector);\n\n            handleObjSelector.each(function (index, element) {\n                if ($(element).is('input[type=text]') ||\n                    $(element).is('input[type=email]') ||\n                    $(element).is('input[type=number]') ||\n                    $(element).is('input[type=hidden]') ||\n                    $(element).is('input[type=checkbox]:checked') ||\n                    $(element).is('input[type=radio]:checked') ||\n                    $(element).is('textarea') ||\n                    $('#' + element.id + ' option:selected').length\n                ) {\n                    if ($(element).data('selector') || $(element).attr('name')) {\n                        dataToAdd = $.extend({}, dataToAdd, self._getElementData(element));\n                    }\n\n                    return;\n                }\n\n                if ($(element).is('input[type=file]') && $(element).val()) {\n                    isFileUploaded = true;\n                }\n            });\n\n            if (isFileUploaded) {\n                this.bindFormSubmit();\n            }\n            this._updateAddToWishlistButton(dataToAdd, event);\n            event.stopPropagation();\n        },\n\n        /**\n         * @param {Object} dataToAdd\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _updateAddToWishlistButton: function (dataToAdd, event) {\n            var self = this,\n                buttons = this._getAddToWishlistButton(event);\n\n            buttons.each(function (index, element) {\n                var params = $(element).data('post'),\n                    currentTarget = event.currentTarget,\n                    targetElement,\n                    targetValue;\n\n                if (!params) {\n                    params = {\n                        'data': {}\n                    };\n                } else if ($(currentTarget).data('selector') || $(currentTarget).attr('name')) {\n                    targetElement = self._getElementData(currentTarget);\n                    targetValue = Object.keys(targetElement)[0];\n\n                    if (params.data.hasOwnProperty(targetValue) && !dataToAdd.hasOwnProperty(targetValue)) {\n                        delete params.data[targetValue];\n                    }\n                }\n\n                params.data = $.extend({}, params.data, dataToAdd, {\n                    'qty': $(self.options.qtyInfo).val()\n                });\n                $(element).data('post', params);\n            });\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _getAddToWishlistButton: function (event) {\n            var productListWrapper = $(event.currentTarget).closest(this.options.productListWrapper);\n\n            if (productListWrapper.length) {\n                return productListWrapper.find(this.options.actionElement);\n            }\n\n            return $(this.options.actionElement);\n        },\n\n        /**\n         * @param {Object} array1\n         * @param {Object} array2\n         * @return {Object}\n         * @private\n         * @deprecated\n         */\n        _arrayDiffByKeys: function (array1, array2) {\n            var result = {};\n\n            $.each(array1, function (key, value) {\n                if (key.indexOf('option') === -1) {\n                    return;\n                }\n\n                if (!array2[key]) {\n                    result[key] = value;\n                }\n            });\n\n            return result;\n        },\n\n        /**\n         * @param {HTMLElement} element\n         * @return {Object}\n         * @private\n         */\n        _getElementData: function (element) {\n            var data, elementName, elementValue;\n\n            element = $(element);\n            data = {};\n            elementName = element.data('selector') ? element.data('selector') : element.attr('name');\n            elementValue = element.val();\n\n            if (element.is('select[multiple]') && elementValue !== null) {\n                if (elementName.substr(elementName.length - 2) == '[]') { //eslint-disable-line eqeqeq\n                    elementName = elementName.substring(0, elementName.length - 2);\n                }\n                $.each(elementValue, function (key, option) {\n                    data[elementName + '[' + option + ']'] = option;\n                });\n            } else if (elementName.substr(elementName.length - 2) == '[]') { //eslint-disable-line eqeqeq, max-depth\n                elementName = elementName.substring(0, elementName.length - 2);\n\n                data[elementName + '[' + elementValue + ']'] = elementValue;\n            } else {\n                data[elementName] = elementValue;\n            }\n\n            return data;\n        },\n\n        /**\n         * @param {Object} params\n         * @param {Object} dataToAdd\n         * @private\n         * @deprecated\n         */\n        _removeExcessiveData: function (params, dataToAdd) {\n            var dataToRemove = this._arrayDiffByKeys(params.data, dataToAdd);\n\n            $.each(dataToRemove, function (key) {\n                delete params.data[key];\n            });\n        },\n\n        /**\n         * Bind form submit.\n         */\n        bindFormSubmit: function () {\n            var self = this;\n\n            $('[data-action=\"add-to-wishlist\"]').on('click', function (event) {\n                var element, params, form, action;\n\n                event.stopPropagation();\n                event.preventDefault();\n\n                element = $('input[type=file]' + self.options.customOptionsInfo);\n                params = $(event.currentTarget).data('post');\n                form = $(element).closest('form');\n                action = params.action;\n\n                if (params.data.id) {\n                    $('<input>', {\n                        type: 'hidden',\n                        name: 'id',\n                        value: params.data.id\n                    }).appendTo(form);\n                }\n\n                if (params.data.uenc) {\n                    action += 'uenc/' + params.data.uenc;\n                }\n\n                $(form).attr('action', action).trigger('submit');\n            });\n        },\n\n        /**\n         * Validate product quantity before updating Wish List\n         *\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _validateWishlistQty: function (event) {\n            var element = $(this.options.qtyInfo);\n\n            if (!(element.validation() && element.validation('isValid'))) {\n                event.preventDefault();\n                event.stopPropagation();\n\n                return;\n            }\n        }\n    });\n\n    return $.mage.addToWishlist;\n});\n","Magento_Wishlist/js/wishlist.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'mage/template',\n    'Magento_Ui/js/modal/alert',\n    'jquery-ui-modules/widget',\n    'mage/validation/validation',\n    'mage/dataPost'\n], function ($, mageTemplate, alert) {\n    'use strict';\n\n    $.widget('mage.wishlist', {\n        options: {\n            dataAttribute: 'item-id',\n            nameFormat: 'qty[{0}]',\n            btnRemoveSelector: '[data-role=remove]',\n            qtySelector: '[data-role=qty]',\n            addToCartSelector: '[data-role=tocart]',\n            addAllToCartSelector: '[data-role=all-tocart]',\n            commentInputType: 'textarea',\n            infoList: false\n        },\n\n        /**\n         * Bind handlers to events.\n         */\n        _create: function () {\n            var _this = this;\n\n            if (!this.options.infoList) {\n                this.element\n                    .on('addToCart', function (event, context) {\n                        var urlParams;\n\n                        event.stopPropagation(event);\n                        $(context).data('stop-processing', true);\n                        urlParams = _this._getItemsToCartParams(\n                            $(context).parents('[data-row=product-item]').find(_this.options.addToCartSelector)\n                        );\n                        $.mage.dataPost().postData(urlParams);\n\n                        return false;\n                    })\n                    .on('click', this.options.btnRemoveSelector, $.proxy(function (event) {\n                        event.preventDefault();\n                        $.mage.dataPost().postData($(event.currentTarget).data('post-remove'));\n                    }, this))\n                    .on('click', this.options.addToCartSelector, $.proxy(this._beforeAddToCart, this))\n                    .on('click', this.options.addAllToCartSelector, $.proxy(this._addAllWItemsToCart, this))\n                    .on('focusin focusout', this.options.commentInputType, $.proxy(this._focusComment, this));\n            }\n\n            // Setup validation for the form\n            this.element.mage('validation', {\n                /** @inheritdoc */\n                errorPlacement: function (error, element) {\n                    error.insertAfter(element.next());\n                }\n            });\n        },\n\n        /**\n         * Process data before add to cart\n         *\n         * - update item's qty value.\n         *\n         * @param {Event} event\n         * @private\n         */\n        _beforeAddToCart: function (event) {\n            var elem = $(event.currentTarget),\n                itemId = elem.data(this.options.dataAttribute),\n                qtyName = $.validator.format(this.options.nameFormat, itemId),\n                qtyValue = elem.parents().find('[name=\"' + qtyName + '\"]').val(),\n                params = elem.data('post');\n\n            if (params) {\n                params.data = $.extend({}, params.data, {\n                    'qty': qtyValue\n                });\n                elem.data('post', params);\n            }\n        },\n\n        /**\n         * Add wish list items to cart.\n         * @private\n         * @param {jQuery} elem - clicked 'add to cart' button\n         */\n        _getItemsToCartParams: function (elem) {\n            var itemId, url, qtyName, qtyValue;\n\n            if (elem.data(this.options.dataAttribute)) {\n                itemId = elem.data(this.options.dataAttribute);\n                url = this.options.addToCartUrl;\n                qtyName = $.validator.format(this.options.nameFormat, itemId);\n                qtyValue = elem.parents().find('[name=\"' + qtyName + '\"]').val();\n                url.data.item = itemId;\n                url.data.qty = qtyValue;\n\n                return url;\n            }\n        },\n\n        /**\n         * Add all wish list items to cart\n         * @private\n         */\n        _addAllWItemsToCart: function () {\n            var urlParams = this.options.addAllToCartUrl,\n                separator = urlParams.action.indexOf('?') >= 0 ? '&' : '?';\n\n            this.element.find(this.options.qtySelector).each(function (index, element) {\n                urlParams.action += separator + $(element).prop('name') + '=' + encodeURIComponent($(element).val());\n                separator = '&';\n            });\n            $.mage.dataPost().postData(urlParams);\n        },\n\n        /**\n         * Toggle comment string.\n         * @private\n         * @param {Event} e\n         */\n        _focusComment: function (e) {\n            var commentInput = e.currentTarget;\n\n            if (commentInput.value === '' || commentInput.value === this.options.commentString) {\n                commentInput.value = commentInput.value === this.options.commentString ?\n                    '' : this.options.commentString;\n            }\n        }\n    });\n\n    // Extension for mage.wishlist - Select All checkbox\n    $.widget('mage.wishlist', $.mage.wishlist, {\n        options: {\n            selectAllCheckbox: '#select-all',\n            parentContainer: '#wishlist-table'\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            var selectAllCheckboxParent, checkboxCount;\n\n            this._super();\n            selectAllCheckboxParent = $(this.options.selectAllCheckbox).parents(this.options.parentContainer);\n            checkboxCount = selectAllCheckboxParent\n                .find('input:checkbox:not(' + this.options.selectAllCheckbox + ')').length;\n            // If Select all checkbox is checked, check all item checkboxes, if unchecked, uncheck all item checkboxes\n            $(this.options.selectAllCheckbox).on('click', function () {\n                selectAllCheckboxParent.find('input:checkbox').attr('checked', $(this).is(':checked'));\n            });\n            // If all item checkboxes are checked, check select all checkbox,\n            // if not all item checkboxes are checked, uncheck select all checkbox\n            selectAllCheckboxParent.on(\n                'click',\n                'input:checkbox:not(' + this.options.selectAllCheckbox + ')',\n                $.proxy(function () {\n                    var checkedCount = selectAllCheckboxParent\n                        .find('input:checkbox:checked:not(' + this.options.selectAllCheckbox + ')').length;\n\n                    $(this.options.selectAllCheckbox).attr('checked', checkboxCount === checkedCount);\n                }, this)\n            );\n        }\n    });\n    // Extension for mage.wishlist info add to cart\n    $.widget('mage.wishlist', $.mage.wishlist, {\n        /** @inheritdoc */\n        _create: function () {\n            this._super();\n\n            if (this.options.infoList) {\n                this.element.on('addToCart', $.proxy(function (event, context) {\n                    this.element.find('input:checkbox').attr('checked', false);\n                    $(context).closest('tr').find('input:checkbox').attr('checked', true);\n                    this.element.trigger('submit');\n                }, this));\n                this._checkBoxValidate();\n            }\n        },\n\n        /**\n         * validate checkbox selection.\n         * @private\n         */\n        _checkBoxValidate: function () {\n            this.element.validation({\n                submitHandler: $.proxy(function (form) {\n                    if ($(form).find('input:checkbox:checked').length) {\n                        form.submit();\n                    } else {\n                        alert({\n                            content: this.options.checkBoxValidationMessage\n                        });\n                    }\n                }, this)\n            });\n        }\n    });\n\n    // Extension for mage.wishlist - Add Wishlist item to Gift Registry\n    $.widget('mage.wishlist', $.mage.wishlist, {\n        options: {\n            formTmplSelector: '#form-tmpl',\n            formTmplId: '#wishlist-hidden-form'\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            var _this = this;\n\n            this._super();\n            this.element.on('click', '[data-wishlist-to-giftregistry]', function () {\n                var json = $(this).data('wishlist-to-giftregistry'),\n                    tmplJson = {\n                        item: json.itemId,\n                        entity: json.entity,\n                        url: json.url\n                    },\n                    html = mageTemplate(_this.options.formTmplSelector, {\n                        data: tmplJson\n                    });\n\n                $(html).appendTo('body');\n                $(_this.options.formTmplId).trigger('submit');\n            });\n        }\n    });\n\n    return $.mage.wishlist;\n});\n","Magento_Wishlist/js/search.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.wishlistSearch', {\n\n        /**\n         * Bind handlers to events\n         */\n        _create: function () {\n            this.element.on('change', $.proxy(this._toggleForm, this));\n        },\n\n        /**\n         * Toggle Form\n         * @private\n         */\n        _toggleForm: function () {\n            switch (this.element.val()) {\n                case 'name':\n                    $(this.options.emailFormSelector).hide();\n                    $(this.options.nameFormSelector).show();\n                    break;\n\n                case 'email':\n                    $(this.options.nameFormSelector).hide();\n                    $(this.options.emailFormSelector).show();\n                    break;\n                default:\n                    $(this.options.emailFormSelector).add(this.options.nameFormSelector).hide();\n            }\n        }\n    });\n\n    return $.mage.wishlistSearch;\n});\n","Magento_Wishlist/js/product/addtowishlist-button.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'Magento_Catalog/js/product/uenc-processor',\n    'Magento_Catalog/js/product/list/column-status-validator'\n], function (Element, uencProcessor, columnStatusValidator) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            label: ''\n        },\n\n        /**\n         * Get request POST data.\n         *\n         * @param {Object} row\n         * @return {String}\n         */\n        getDataPost: function (row) {\n            return uencProcessor(row['extension_attributes']['wishlist_button'].url);\n        },\n\n        /**\n         * Check if component must be shown.\n         *\n         * @return {Boolean}\n         */\n        isAllowed: function () {\n            return columnStatusValidator.isValid(this.source(), 'add_to_wishlist', 'show_buttons');\n        },\n\n        /**\n         * Get button label.\n         *\n         * @return {String}\n         */\n        getLabel: function () {\n            return this.label;\n        }\n    });\n});\n","Magento_Wishlist/js/view/wishlist.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Customer/js/customer-data'\n], function (Component, customerData) {\n    'use strict';\n\n    return Component.extend({\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n\n            this.wishlist = customerData.get('wishlist');\n        }\n    });\n});\n","Magento_Cookie/js/jquery.storageapi.extended.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery/jquery.cookie',\n    'jquery/jquery.storageapi.min'\n], function ($) {\n    'use strict';\n\n    /**\n     *\n     * @param {Object} storage\n     * @private\n     */\n    function _extend(storage) {\n        var cookiesConfig = window.cookiesConfig || {};\n\n        $.extend(storage, {\n            _secure: !!cookiesConfig.secure,\n            _samesite: cookiesConfig.samesite ? cookiesConfig.samesite : 'lax',\n\n            /**\n             * Set value under name\n             * @param {String} name\n             * @param {String} value\n             * @param {Object} [options]\n             */\n            setItem: function (name, value, options) {\n                var _default = {\n                    expires: this._expires,\n                    path: this._path,\n                    domain: this._domain,\n                    secure: this._secure,\n                    samesite: this._samesite\n                };\n\n                $.cookie(this._prefix + name, value, $.extend(_default, options || {}));\n            },\n\n            /**\n             * Set default options\n             * @param {Object} c\n             * @returns {storage}\n             */\n            setConf: function (c) {\n                if (c.path) {\n                    this._path = c.path;\n                }\n\n                if (c.domain) {\n                    this._domain = c.domain;\n                }\n\n                if (c.expires) {\n                    this._expires = c.expires;\n                }\n\n                if (typeof c.secure !== 'undefined') {\n                    this._secure = c.secure;\n                }\n\n                if (typeof c.samesite !== 'undefined') {\n                    this._samesite = c.samesite;\n                }\n\n                return this;\n            }\n        });\n    }\n\n    if (window.cookieStorage) {\n        _extend(window.cookieStorage);\n    }\n});\n","Magento_Cookie/js/require-cookie.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/alert',\n    'jquery-ui-modules/widget',\n    'mage/mage',\n    'mage/translate'\n], function ($, alert) {\n    'use strict';\n\n    $.widget('mage.requireCookie', {\n        options: {\n            event: 'click',\n            noCookieUrl: 'enable-cookies',\n            triggers: ['.action.login', '.action.submit'],\n            isRedirectCmsPage: true\n        },\n\n        /**\n         * Constructor\n         * @private\n         */\n        _create: function () {\n            this._bind();\n        },\n\n        /**\n         * This method binds elements found in this widget.\n         * @private\n         */\n        _bind: function () {\n            var events = {};\n\n            $.each(this.options.triggers, function (index, value) {\n                events['click ' + value] = '_checkCookie';\n            });\n            this._on(events);\n        },\n\n        /**\n         * This method set the url for the redirect.\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _checkCookie: function (event) {\n            if (navigator.cookieEnabled) {\n                return;\n            }\n\n            event.preventDefault();\n\n            if (this.options.isRedirectCmsPage) {\n                window.location = this.options.noCookieUrl;\n            } else {\n                alert({\n                    content: $.mage.__('Cookies are disabled in your browser.')\n                });\n            }\n        }\n    });\n\n    return $.mage.requireCookie;\n});\n","Magento_Cookie/js/notices.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget',\n    'mage/cookies'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.cookieNotices', {\n        /** @inheritdoc */\n        _create: function () {\n            if ($.mage.cookies.get(this.options.cookieName)) {\n                this.element.hide();\n            } else {\n                this.element.show();\n            }\n            $(this.options.cookieAllowButtonSelector).on('click', $.proxy(function () {\n                var cookieExpires = new Date(new Date().getTime() + this.options.cookieLifetime * 1000);\n\n                $.mage.cookies.set(this.options.cookieName, JSON.stringify(this.options.cookieValue), {\n                    expires: cookieExpires\n                });\n\n                if ($.mage.cookies.get(this.options.cookieName)) {\n                    this.element.hide();\n                    $(document).trigger('user:allowed:save:cookie');\n                } else {\n                    window.location.href = this.options.noCookiesUrl;\n                }\n            }, this));\n        }\n    });\n\n    return $.mage.cookieNotices;\n});\n","Magento_Customer/js/password-strength-indicator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Customer/js/zxcvbn',\n    'mage/translate',\n    'mage/validation'\n], function ($, zxcvbn, $t) {\n    'use strict';\n\n    $.widget('mage.passwordStrengthIndicator', {\n        options: {\n            cache: {},\n            passwordSelector: '[type=password]',\n            passwordStrengthMeterSelector: '[data-role=password-strength-meter]',\n            passwordStrengthMeterLabelSelector: '[data-role=password-strength-meter-label]',\n            formSelector: 'form',\n            emailSelector: 'input[type=\"email\"]'\n        },\n\n        /**\n         * Widget initialization\n         * @private\n         */\n        _create: function () {\n            this.options.cache.input = $(this.options.passwordSelector, this.element);\n            this.options.cache.meter = $(this.options.passwordStrengthMeterSelector, this.element);\n            this.options.cache.label = $(this.options.passwordStrengthMeterLabelSelector, this.element);\n\n            // We need to look outside the module for backward compatibility, since someone can already use the module.\n            // @todo Narrow this selector in 2.3 so it doesn't accidentally finds the email field from the\n            // newsletter email field or any other \"email\" field.\n            this.options.cache.email = $(this.options.formSelector).find(this.options.emailSelector);\n            this._bind();\n        },\n\n        /**\n         * Event binding, will monitor change, keyup and paste events.\n         * @private\n         */\n        _bind: function () {\n            this._on(this.options.cache.input, {\n                'change': this._calculateStrength,\n                'keyup': this._calculateStrength,\n                'paste': this._calculateStrength\n            });\n\n            if (this.options.cache.email.length) {\n                this._on(this.options.cache.email, {\n                    'change': this._calculateStrength,\n                    'keyup': this._calculateStrength,\n                    'paste': this._calculateStrength\n                });\n            }\n        },\n\n        /**\n         * Calculate password strength\n         * @private\n         */\n        _calculateStrength: function () {\n            var password = this._getPassword(),\n                isEmpty = password.length === 0,\n                zxcvbnScore,\n                displayScore,\n                isValid;\n\n            // Display score is based on combination of whether password is empty, valid, and zxcvbn strength\n            if (isEmpty) {\n                displayScore = 0;\n            } else {\n                this.options.cache.input.rules('add', {\n                    'password-not-equal-to-user-name': this.options.cache.email.val()\n                });\n\n                // We should only perform this check in case there is an email field on screen\n                if (this.options.cache.email.length &&\n                    password.toLowerCase() === this.options.cache.email.val().toLowerCase()) {\n                    displayScore = 1;\n                } else {\n                    isValid = $.validator.validateSingleElement(this.options.cache.input);\n                    zxcvbnScore = zxcvbn(password).score;\n                    displayScore = isValid && zxcvbnScore > 0 ? zxcvbnScore : 1;\n                }\n            }\n\n            // Update label\n            this._displayStrength(displayScore);\n        },\n\n        /**\n         * Display strength\n         * @param {Number} displayScore\n         * @private\n         */\n        _displayStrength: function (displayScore) {\n            var strengthLabel = '',\n                className;\n\n            switch (displayScore) {\n                case 0:\n                    strengthLabel = $t('No Password');\n                    className = 'password-none';\n                    break;\n\n                case 1:\n                    strengthLabel = $t('Weak');\n                    className = 'password-weak';\n                    break;\n\n                case 2:\n                    strengthLabel = $t('Medium');\n                    className = 'password-medium';\n                    break;\n\n                case 3:\n                    strengthLabel = $t('Strong');\n                    className = 'password-strong';\n                    break;\n\n                case 4:\n                    strengthLabel = $t('Very Strong');\n                    className = 'password-very-strong';\n                    break;\n            }\n\n            this.options.cache.meter\n                .removeClass()\n                .addClass(className);\n            this.options.cache.label.text(strengthLabel);\n        },\n\n        /**\n         * Get password value\n         * @returns {*}\n         * @private\n         */\n        _getPassword: function () {\n            return this.options.cache.input.val();\n        }\n    });\n\n    return $.mage.passwordStrengthIndicator;\n});\n","Magento_Customer/js/customer-data.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore',\n    'ko',\n    'Magento_Customer/js/section-config',\n    'mage/url',\n    'mage/storage',\n    'jquery/jquery-storageapi'\n], function ($, _, ko, sectionConfig, url) {\n    'use strict';\n\n    var options = {},\n        storage,\n        storageInvalidation,\n        invalidateCacheBySessionTimeOut,\n        invalidateCacheByCloseCookieSession,\n        dataProvider,\n        buffer,\n        customerData,\n        deferred = $.Deferred();\n\n    url.setBaseUrl(window.BASE_URL);\n    options.sectionLoadUrl = url.build('customer/section/load');\n\n    /**\n     * @param {Object} invalidateOptions\n     */\n    invalidateCacheBySessionTimeOut = function (invalidateOptions) {\n        var date;\n\n        if (new Date($.localStorage.get('mage-cache-timeout')) < new Date()) {\n            storage.removeAll();\n        }\n        date = new Date(Date.now() + parseInt(invalidateOptions.cookieLifeTime, 10) * 1000);\n        $.localStorage.set('mage-cache-timeout', date);\n    };\n\n    /**\n     * Invalidate Cache By Close Cookie Session\n     */\n    invalidateCacheByCloseCookieSession = function () {\n        if (!$.cookieStorage.isSet('mage-cache-sessid')) {\n            $.cookieStorage.set('mage-cache-sessid', true);\n            storage.removeAll();\n        }\n    };\n\n    dataProvider = {\n\n        /**\n         * @param {Object} sectionNames\n         * @return {Object}\n         */\n        getFromStorage: function (sectionNames) {\n            var result = {};\n\n            _.each(sectionNames, function (sectionName) {\n                result[sectionName] = storage.get(sectionName);\n            });\n\n            return result;\n        },\n\n        /**\n         * @param {Object} sectionNames\n         * @param {Boolean} forceNewSectionTimestamp\n         * @return {*}\n         */\n        getFromServer: function (sectionNames, forceNewSectionTimestamp) {\n            var parameters;\n\n            sectionNames = sectionConfig.filterClientSideSections(sectionNames);\n            parameters = _.isArray(sectionNames) && sectionNames.indexOf('*') < 0 ? {\n                sections: sectionNames.join(',')\n            } : [];\n            parameters['force_new_section_timestamp'] = forceNewSectionTimestamp;\n\n            return $.getJSON(options.sectionLoadUrl, parameters).fail(function (jqXHR) {\n                throw new Error(jqXHR);\n            });\n        }\n    };\n\n    /**\n     * @param {Function} target\n     * @param {String} sectionName\n     * @return {*}\n     */\n    ko.extenders.disposableCustomerData = function (target, sectionName) {\n        var sectionDataIds, newSectionDataIds = {};\n\n        target.subscribe(function () {\n            setTimeout(function () {\n                storage.remove(sectionName);\n                sectionDataIds = $.cookieStorage.get('section_data_ids') || {};\n                _.each(sectionDataIds, function (data, name) {\n                    if (name != sectionName) { //eslint-disable-line eqeqeq\n                        newSectionDataIds[name] = data;\n                    }\n                });\n                $.cookieStorage.set('section_data_ids', newSectionDataIds);\n            }, 3000);\n        });\n\n        return target;\n    };\n\n    buffer = {\n        data: {},\n\n        /**\n         * @param {String} sectionName\n         */\n        bind: function (sectionName) {\n            this.data[sectionName] = ko.observable({});\n        },\n\n        /**\n         * @param {String} sectionName\n         * @return {Object}\n         */\n        get: function (sectionName) {\n            if (!this.data[sectionName]) {\n                this.bind(sectionName);\n            }\n\n            return this.data[sectionName];\n        },\n\n        /**\n         * @return {Array}\n         */\n        keys: function () {\n            return _.keys(this.data);\n        },\n\n        /**\n         * @param {String} sectionName\n         * @param {Object} sectionData\n         */\n        notify: function (sectionName, sectionData) {\n            if (!this.data[sectionName]) {\n                this.bind(sectionName);\n            }\n            this.data[sectionName](sectionData);\n        },\n\n        /**\n         * @param {Object} sections\n         */\n        update: function (sections) {\n            var sectionId = 0,\n                sectionDataIds = $.cookieStorage.get('section_data_ids') || {};\n\n            _.each(sections, function (sectionData, sectionName) {\n                sectionId = sectionData['data_id'];\n                sectionDataIds[sectionName] = sectionId;\n                storage.set(sectionName, sectionData);\n                storageInvalidation.remove(sectionName);\n                buffer.notify(sectionName, sectionData);\n            });\n            $.cookieStorage.set('section_data_ids', sectionDataIds);\n        },\n\n        /**\n         * @param {Object} sections\n         */\n        remove: function (sections) {\n            _.each(sections, function (sectionName) {\n                storage.remove(sectionName);\n\n                if (!sectionConfig.isClientSideSection(sectionName)) {\n                    storageInvalidation.set(sectionName, true);\n                }\n            });\n        }\n    };\n\n    customerData = {\n\n        /**\n         * Customer data initialization\n         */\n        init: function () {\n            var expiredSectionNames = this.getExpiredSectionNames();\n\n            if (expiredSectionNames.length > 0) {\n                _.each(dataProvider.getFromStorage(storage.keys()), function (sectionData, sectionName) {\n                    buffer.notify(sectionName, sectionData);\n                });\n                this.reload(expiredSectionNames, false);\n            } else {\n                _.each(dataProvider.getFromStorage(storage.keys()), function (sectionData, sectionName) {\n                    buffer.notify(sectionName, sectionData);\n                });\n\n                if (!_.isEmpty(storageInvalidation.keys())) {\n                    this.reload(storageInvalidation.keys(), false);\n                }\n            }\n\n            if (!_.isEmpty($.cookieStorage.get('section_data_clean'))) {\n                this.reload(sectionConfig.getSectionNames(), true);\n                $.cookieStorage.set('section_data_clean', '');\n            }\n        },\n\n        /**\n         * Storage init\n         */\n        initStorage: function () {\n            $.cookieStorage.setConf({\n                path: '/',\n                expires: new Date(Date.now() + parseInt(options.cookieLifeTime, 10) * 1000),\n                samesite: 'lax'\n            });\n            storage = $.initNamespaceStorage('mage-cache-storage').localStorage;\n            storageInvalidation = $.initNamespaceStorage('mage-cache-storage-section-invalidation').localStorage;\n        },\n\n        /**\n         * Retrieve the list of sections that has expired since last page reload.\n         *\n         * Sections can expire due to lifetime constraints or due to inconsistent storage information\n         * (validated by cookie data).\n         *\n         * @return {Array}\n         */\n        getExpiredSectionNames: function () {\n            var expiredSectionNames = [],\n                cookieSectionTimestamps = $.cookieStorage.get('section_data_ids') || {},\n                sectionLifetime = options.expirableSectionLifetime * 60,\n                currentTimestamp = Math.floor(Date.now() / 1000),\n                sectionData;\n\n            // process sections that can expire due to lifetime constraints\n            _.each(options.expirableSectionNames, function (sectionName) {\n                sectionData = storage.get(sectionName);\n\n                if (typeof sectionData === 'object' && sectionData['data_id'] + sectionLifetime <= currentTimestamp) {\n                    expiredSectionNames.push(sectionName);\n                }\n            });\n\n            // process sections that can expire due to storage information inconsistency\n            _.each(cookieSectionTimestamps, function (cookieSectionTimestamp, sectionName) {\n                sectionData = storage.get(sectionName);\n\n                if (typeof sectionData === 'undefined' ||\n                    typeof sectionData === 'object' &&\n                    cookieSectionTimestamp != sectionData['data_id'] //eslint-disable-line\n                ) {\n                    expiredSectionNames.push(sectionName);\n                }\n            });\n\n            //remove expired section names of previously installed/enable modules\n            expiredSectionNames = _.intersection(expiredSectionNames, sectionConfig.getSectionNames());\n\n            return _.uniq(expiredSectionNames);\n        },\n\n        /**\n         * Check if some sections have to be reloaded.\n         *\n         * @deprecated Use getExpiredSectionNames instead.\n         *\n         * @return {Boolean}\n         */\n        needReload: function () {\n            var expiredSectionNames = this.getExpiredSectionNames();\n\n            return expiredSectionNames.length > 0;\n        },\n\n        /**\n         * Retrieve the list of expired keys.\n         *\n         * @deprecated Use getExpiredSectionNames instead.\n         *\n         * @return {Array}\n         */\n        getExpiredKeys: function () {\n            return this.getExpiredSectionNames();\n        },\n\n        /**\n         * @param {String} sectionName\n         * @return {*}\n         */\n        get: function (sectionName) {\n            return buffer.get(sectionName);\n        },\n\n        /**\n         * @param {String} sectionName\n         * @param {Object} sectionData\n         */\n        set: function (sectionName, sectionData) {\n            var data = {};\n\n            data[sectionName] = sectionData;\n            buffer.update(data);\n        },\n\n        /**\n         * Avoid using this function directly 'cause of possible performance drawbacks.\n         * Each customer section reload brings new non-cached ajax request.\n         *\n         * @param {Array} sectionNames\n         * @param {Boolean} forceNewSectionTimestamp\n         * @return {*}\n         */\n        reload: function (sectionNames, forceNewSectionTimestamp) {\n            return dataProvider.getFromServer(sectionNames, forceNewSectionTimestamp).done(function (sections) {\n                $(document).trigger('customer-data-reload', [sectionNames]);\n                buffer.update(sections);\n            });\n        },\n\n        /**\n         * @param {Array} sectionNames\n         */\n        invalidate: function (sectionNames) {\n            var sectionDataIds,\n                sectionsNamesForInvalidation;\n\n            sectionsNamesForInvalidation = _.contains(sectionNames, '*') ? sectionConfig.getSectionNames() :\n                sectionNames;\n\n            $(document).trigger('customer-data-invalidate', [sectionsNamesForInvalidation]);\n            buffer.remove(sectionsNamesForInvalidation);\n            sectionDataIds = $.cookieStorage.get('section_data_ids') || {};\n\n            // Invalidate section in cookie (increase version of section with 1000)\n            _.each(sectionsNamesForInvalidation, function (sectionName) {\n                if (!sectionConfig.isClientSideSection(sectionName)) {\n                    sectionDataIds[sectionName] += 1000;\n                }\n            });\n            $.cookieStorage.set('section_data_ids', sectionDataIds);\n        },\n\n        /**\n         * Checks if customer data is initialized.\n         *\n         * @returns {jQuery.Deferred}\n         */\n        getInitCustomerData: function () {\n            return deferred.promise();\n        },\n\n        /**\n         * Reload sections on ajax complete\n         *\n         * @param {Object} jsonResponse\n         * @param {Object} settings\n         */\n        onAjaxComplete: function (jsonResponse, settings) {\n            var sections,\n                redirects;\n\n            if (settings.type.match(/post|put|delete/i)) {\n                sections = sectionConfig.getAffectedSections(settings.url);\n\n                if (sections && sections.length) {\n                    this.invalidate(sections);\n                    redirects = ['redirect', 'backUrl'];\n\n                    if (_.isObject(jsonResponse) && !_.isEmpty(_.pick(jsonResponse, redirects))) { //eslint-disable-line\n                        return;\n                    }\n                    this.reload(sections, true);\n                }\n            }\n        },\n\n        /**\n         * @param {Object} settings\n         * @constructor\n         */\n        'Magento_Customer/js/customer-data': function (settings) {\n            options = settings;\n            customerData.initStorage();\n            invalidateCacheBySessionTimeOut(settings);\n            invalidateCacheByCloseCookieSession();\n            customerData.init();\n            deferred.resolve();\n        }\n    };\n\n    /**\n     * Events listener\n     */\n    $(document).on('ajaxComplete', function (event, xhr, settings) {\n        customerData.onAjaxComplete(xhr.responseJSON, settings);\n    });\n\n    /**\n     * Events listener\n     */\n    $(document).on('submit', function (event) {\n        var sections;\n\n        if (event.target.method.match(/post|put|delete/i)) {\n            sections = sectionConfig.getAffectedSections(event.target.action);\n\n            if (sections) {\n                customerData.invalidate(sections);\n            }\n        }\n    });\n\n    return customerData;\n});\n","Magento_Customer/js/invalidation-processor.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'uiElement',\n    'Magento_Customer/js/customer-data'\n], function (_, Element, customerData) {\n    'use strict';\n\n    return Element.extend({\n        /**\n         * Initialize object\n         */\n        initialize: function () {\n            this._super();\n            this.process(customerData);\n        },\n\n        /**\n         * Process all rules in loop, each rule can invalidate some sections in customer data\n         *\n         * @param {Object} customerDataObject\n         */\n        process: function (customerDataObject) {\n            _.each(this.invalidationRules, function (rule, ruleName) {\n                _.each(rule, function (ruleArgs, rulePath) {\n                    require([rulePath], function (Rule) {\n                        var currentRule = new Rule(ruleArgs);\n\n                        if (!_.isFunction(currentRule.process)) {\n                            throw new Error('Rule ' + ruleName + ' should implement invalidationProcessor interface');\n                        }\n                        currentRule.process(customerDataObject);\n                    });\n                });\n            });\n        }\n    });\n});\n","Magento_Customer/js/address.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/confirm',\n    'jquery-ui-modules/widget',\n    'mage/translate'\n], function ($, confirm) {\n    'use strict';\n\n    $.widget('mage.address', {\n        /**\n         * Options common to all instances of this widget.\n         * @type {Object}\n         */\n        options: {\n            deleteConfirmMessage: $.mage.__('Are you sure you want to delete this address?')\n        },\n\n        /**\n         * Bind event handlers for adding and deleting addresses.\n         * @private\n         */\n        _create: function () {\n            var options         = this.options,\n                addAddress      = options.addAddress,\n                deleteAddress   = options.deleteAddress;\n\n            if (addAddress) {\n                $(document).on('click', addAddress, this._addAddress.bind(this));\n            }\n\n            if (deleteAddress) {\n                $(document).on('click', deleteAddress, this._deleteAddress.bind(this));\n            }\n        },\n\n        /**\n         * Add a new address.\n         * @private\n         */\n        _addAddress: function () {\n            window.location = this.options.addAddressLocation;\n        },\n\n        /**\n         * Delete the address whose id is specified in a data attribute after confirmation from the user.\n         * @private\n         * @param {jQuery.Event} e\n         * @return {Boolean}\n         */\n        _deleteAddress: function (e) {\n            var self = this;\n\n            confirm({\n                content: this.options.deleteConfirmMessage,\n                actions: {\n\n                    /** @inheritdoc */\n                    confirm: function () {\n                        if (typeof $(e.target).parent().data('address') !== 'undefined') {\n                            window.location = self.options.deleteUrlPrefix + $(e.target).parent().data('address') +\n                                '/form_key/' + $.mage.cookies.get('form_key');\n                        } else {\n                            window.location = self.options.deleteUrlPrefix + $(e.target).data('address') +\n                                '/form_key/' + $.mage.cookies.get('form_key');\n                        }\n                    }\n                }\n            });\n\n            return false;\n        }\n    });\n\n    return $.mage.address;\n});\n","Magento_Customer/js/addressValidation.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'mageUtils',\n    'mage/translate',\n    'Magento_Checkout/js/model/postcode-validator',\n    'jquery-ui-modules/widget',\n    'validation'\n], function ($, __, utils, $t, postCodeValidator) {\n    'use strict';\n\n    $.widget('mage.addressValidation', {\n        options: {\n            selectors: {\n                button: '[data-action=save-address]',\n                zip: '#zip',\n                country: 'select[name=\"country_id\"]:visible'\n            }\n        },\n\n        zipInput: null,\n        countrySelect: null,\n\n        /**\n         * Validation creation\n         *\n         * @protected\n         */\n        _create: function () {\n            var button = $(this.options.selectors.button, this.element);\n\n            this.zipInput = $(this.options.selectors.zip, this.element);\n            this.countrySelect = $(this.options.selectors.country, this.element);\n\n            this.element.validation({\n\n                /**\n                 * Submit Handler\n                 * @param {Element} form - address form\n                 */\n                submitHandler: function (form) {\n\n                    button.attr('disabled', true);\n                    form.submit();\n                }\n            });\n\n            this._addPostCodeValidation();\n        },\n\n        /**\n         * Add postcode validation\n         *\n         * @protected\n         */\n        _addPostCodeValidation: function () {\n            var self = this;\n\n            this.zipInput.on('keyup', __.debounce(function (event) {\n                    var valid = self._validatePostCode(event.target.value);\n\n                    self._renderValidationResult(valid);\n                }, 500)\n            );\n\n            this.countrySelect.on('change', function () {\n                var valid = self._validatePostCode(self.zipInput.val());\n\n                self._renderValidationResult(valid);\n            });\n        },\n\n        /**\n         * Validate post code value.\n         *\n         * @protected\n         * @param {String} postCode - post code\n         * @return {Boolean} Whether is post code valid\n         */\n        _validatePostCode: function (postCode) {\n            var countryId = this.countrySelect.val();\n\n            if (postCode === null) {\n                return true;\n            }\n\n            return postCodeValidator.validate(postCode, countryId, this.options.postCodes);\n        },\n\n        /**\n         * Renders warning messages for invalid post code.\n         *\n         * @protected\n         * @param {Boolean} valid\n         */\n        _renderValidationResult: function (valid) {\n            var warnMessage,\n                alertDiv = this.zipInput.next();\n\n            if (!valid) {\n                warnMessage = $t('Provided Zip/Postal Code seems to be invalid.');\n\n                if (postCodeValidator.validatedPostCodeExample.length) {\n                    warnMessage += $t(' Example: ') + postCodeValidator.validatedPostCodeExample.join('; ') + '. ';\n                }\n                warnMessage += $t('If you believe it is the right one you can ignore this notice.');\n            }\n\n            alertDiv.children(':first').text(warnMessage);\n\n            if (valid) {\n                alertDiv.hide();\n            } else {\n                alertDiv.show();\n            }\n        }\n    });\n\n    return $.mage.addressValidation;\n});\n","Magento_Customer/js/logout-redirect.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/mage'\n], function ($) {\n    'use strict';\n\n    return function (data) {\n        $($.mage.redirect(data.url, 'assign', 5000));\n    };\n});\n","Magento_Customer/js/change-email-password.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.changeEmailPassword', {\n        options: {\n            changeEmailSelector: '[data-role=change-email]',\n            changePasswordSelector: '[data-role=change-password]',\n            mainContainerSelector: '[data-container=change-email-password]',\n            titleSelector: '[data-title=change-email-password]',\n            emailContainerSelector: '[data-container=change-email]',\n            newPasswordContainerSelector: '[data-container=new-password]',\n            confirmPasswordContainerSelector: '[data-container=confirm-password]',\n            currentPasswordSelector: '[data-input=current-password]',\n            emailSelector: '[data-input=change-email]',\n            newPasswordSelector: '[data-input=new-password]',\n            confirmPasswordSelector: '[data-input=confirm-password]'\n        },\n\n        /**\n         * Create widget\n         * @private\n         */\n        _create: function () {\n            this.element.on('change', $.proxy(function () {\n                this._checkChoice();\n            }, this));\n\n            this._checkChoice();\n            this._bind();\n        },\n\n        /**\n         * Event binding, will monitor change, keyup and paste events.\n         * @private\n         */\n        _bind: function () {\n            this._on($(this.options.emailSelector), {\n                'change': this._updatePasswordFieldWithEmailValue,\n                'keyup': this._updatePasswordFieldWithEmailValue,\n                'paste': this._updatePasswordFieldWithEmailValue\n            });\n        },\n\n        /**\n         * Check choice\n         * @private\n         */\n        _checkChoice: function () {\n            if ($(this.options.changeEmailSelector).is(':checked') &&\n                $(this.options.changePasswordSelector).is(':checked')) {\n                this._showAll();\n            } else if ($(this.options.changeEmailSelector).is(':checked')) {\n                this._showEmail();\n            } else if ($(this.options.changePasswordSelector).is(':checked')) {\n                this._showPassword();\n            } else {\n                this._hideAll();\n            }\n        },\n\n        /**\n         * Show email and password input fields\n         * @private\n         */\n        _showAll: function () {\n            $(this.options.titleSelector).html(this.options.titleChangeEmailAndPassword);\n\n            $(this.options.mainContainerSelector).show();\n            $(this.options.emailContainerSelector).show();\n            $(this.options.newPasswordContainerSelector).show();\n            $(this.options.confirmPasswordContainerSelector).show();\n\n            $(this.options.currentPasswordSelector).attr('data-validate', '{required:true}').prop('disabled', false);\n            $(this.options.emailSelector).attr('data-validate', '{required:true}').prop('disabled', false);\n            this._updatePasswordFieldWithEmailValue();\n            $(this.options.confirmPasswordSelector).attr(\n                'data-validate',\n                '{required:true, equalTo:\"' + this.options.newPasswordSelector + '\"}'\n            ).prop('disabled', false);\n        },\n\n        /**\n         * Hide email and password input fields\n         * @private\n         */\n        _hideAll: function () {\n            $(this.options.mainContainerSelector).hide();\n            $(this.options.emailContainerSelector).hide();\n            $(this.options.newPasswordContainerSelector).hide();\n            $(this.options.confirmPasswordContainerSelector).hide();\n\n            $(this.options.currentPasswordSelector).removeAttr('data-validate').prop('disabled', true);\n            $(this.options.emailSelector).removeAttr('data-validate').prop('disabled', true);\n            $(this.options.newPasswordSelector).removeAttr('data-validate').prop('disabled', true);\n            $(this.options.confirmPasswordSelector).removeAttr('data-validate').prop('disabled', true);\n        },\n\n        /**\n         * Show email input fields\n         * @private\n         */\n        _showEmail: function () {\n            this._showAll();\n            $(this.options.titleSelector).html(this.options.titleChangeEmail);\n\n            $(this.options.newPasswordContainerSelector).hide();\n            $(this.options.confirmPasswordContainerSelector).hide();\n\n            $(this.options.newPasswordSelector).removeAttr('data-validate').prop('disabled', true);\n            $(this.options.confirmPasswordSelector).removeAttr('data-validate').prop('disabled', true);\n        },\n\n        /**\n         * Show password input fields\n         * @private\n         */\n        _showPassword: function () {\n            this._showAll();\n            $(this.options.titleSelector).html(this.options.titleChangePassword);\n\n            $(this.options.emailContainerSelector).hide();\n\n            $(this.options.emailSelector).removeAttr('data-validate').prop('disabled', true);\n        },\n\n        /**\n         * Update password validation rules with email input field value\n         * @private\n         */\n        _updatePasswordFieldWithEmailValue: function () {\n            $(this.options.newPasswordSelector).attr(\n                'data-validate',\n                '{required:true, ' +\n                '\\'validate-customer-password\\':true, ' +\n                '\\'password-not-equal-to-user-name\\':\\'' + $(this.options.emailSelector).val() + '\\'}'\n            ).prop('disabled', false);\n        }\n    });\n\n    return $.mage.changeEmailPassword;\n});\n","Magento_Customer/js/section-config.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['underscore'], function (_) {\n    'use strict';\n\n    var baseUrls = [],\n        sections = [],\n        clientSideSections = [],\n        sectionNames = [],\n        canonize;\n\n    /**\n     * @param {String} url\n     * @return {String}\n     */\n    canonize = function (url) {\n        var route = url;\n\n        _.some(baseUrls, function (baseUrl) {\n            route = url.replace(baseUrl, '');\n\n            return route !== url;\n        });\n\n        return route.replace(/^\\/?index.php\\/?/, '').toLowerCase();\n    };\n\n    return {\n        /**\n         * Returns a list of sections which should be invalidated for given URL.\n         * @param {String} url - URL which was requested.\n         * @return {Array} - List of sections to invalidate.\n         */\n        getAffectedSections: function (url) {\n            var route = canonize(url),\n                actions = _.find(sections, function (val, section) {\n                    var matched;\n\n                    // Covers the case where \"*\" works as a glob pattern.\n                    if (section.indexOf('*') >= 0) {\n                        section = section.replace(/\\*/g, '[^/]+') + '$';\n                        matched = route.match(section);\n\n                        return matched && matched[0] === route;\n                    }\n\n                    return route.indexOf(section) === 0;\n                });\n\n            return _.union(_.toArray(actions), sections['*']);\n        },\n\n        /**\n         * Filters the list of given sections to the ones defined as client side.\n         * @param {Array} allSections - List of sections to check.\n         * @return {Array} - List of filtered sections.\n         */\n        filterClientSideSections: function (allSections) {\n            return _.difference(allSections, clientSideSections);\n        },\n\n        /**\n         * Tells if section is defined as client side.\n         * @param {String} sectionName - Name of the section to check.\n         * @return {Boolean}\n         */\n        isClientSideSection: function (sectionName) {\n            return _.contains(clientSideSections, sectionName);\n        },\n\n        /**\n         * Returns array of section names.\n         * @returns {Array}\n         */\n        getSectionNames: function () {\n            return sectionNames;\n        },\n\n        /**\n         * @param {Object} options\n         * @constructor\n         */\n        'Magento_Customer/js/section-config': function (options) {\n            baseUrls = options.baseUrls;\n            sections = options.sections;\n            clientSideSections = options.clientSideSections;\n            sectionNames = options.sectionNames;\n        }\n    };\n});\n","Magento_Customer/js/validation.js":"define([\n    'jquery',\n    'moment',\n    'mageUtils',\n    'jquery/validate',\n    'validation',\n    'mage/translate'\n], function ($, moment, utils) {\n    'use strict';\n\n    $.validator.addMethod(\n        'validate-date',\n        function (value, element, params) {\n            var dateFormat = utils.normalizeDate(params.dateFormat);\n\n            if (value === '') {\n                return true;\n            }\n\n            return moment(value, dateFormat, true).isValid();\n        },\n        $.mage.__('Invalid date')\n    );\n\n    $.validator.addMethod(\n        'validate-dob',\n        function (value, element, params) {\n            var dateFormat = utils.convertToMomentFormat(params.dateFormat);\n\n            if (value === '') {\n                return true;\n            }\n\n            return moment(value, dateFormat).isBefore(moment());\n        },\n        $.mage.__('The Date of Birth should not be greater than today.')\n    );\n});\n","Magento_Customer/js/checkout-balance.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.checkoutBalance', {\n        /**\n         * Initialize store credit events\n         * @private\n         */\n        _create: function () {\n            this.eventData = {\n                price: this.options.balance,\n                totalPrice: 0\n            };\n            this.element.on('change', $.proxy(function (e) {\n                if ($(e.target).is(':checked')) {\n                    this.eventData.price = -1 * this.options.balance;\n                } else {\n                    if (this.options.amountSubstracted) { //eslint-disable-line no-lonely-if\n                        this.eventData.price = parseFloat(this.options.usedAmount);\n                        this.options.amountSubstracted = false;\n                    } else {\n                        this.eventData.price = parseFloat(this.options.balance);\n                    }\n                }\n                this.element.trigger('updateCheckoutPrice', this.eventData);\n            }, this));\n        }\n    });\n\n    return $.mage.checkoutBalance;\n});\n","Magento_Customer/js/show-password.js":"/**\n* Copyright \u00a9 Magento, Inc. All rights reserved.\n* See COPYING.txt for license details.\n*/\n\ndefine([\n    'jquery',\n    'uiComponent'\n], function ($, Component) {\n    'use strict';\n\n    return Component.extend({\n        passwordSelector: '',\n        passwordInputType: 'password',\n        textInputType: 'text',\n\n        defaults: {\n            template: 'Magento_Customer/show-password',\n            isPasswordVisible: false\n        },\n\n        /**\n         * @return {Object}\n         */\n        initObservable: function () {\n            this._super()\n                .observe(['isPasswordVisible']);\n\n            this.isPasswordVisible.subscribe(function (isChecked) {\n                this._showPassword(isChecked);\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Show/Hide password\n         * @private\n         */\n        _showPassword: function (isChecked) {\n            $(this.passwordSelector).attr('type',\n                isChecked ? this.textInputType : this.passwordInputType\n            );\n        }\n    });\n});\n","Magento_Customer/js/block-submit-on-send.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/mage'\n], function ($) {\n    'use strict';\n\n    return function (config) {\n        var dataForm = $('#' + config.formId);\n\n        dataForm.on('submit', function () {\n            $(this).find(':submit').attr('disabled', 'disabled');\n\n            if (this.isValid === false) {\n                $(this).find(':submit').prop('disabled', false);\n            }\n            this.isValid = true;\n        });\n        dataForm.on('invalid-form.validate', function () {\n            $(this).find(':submit').prop('disabled', false);\n            this.isValid = false;\n        });\n    };\n});\n","Magento_Customer/js/invalidation-rules/website-rule.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'uiClass'\n], function (Element) {\n    'use strict';\n\n    return Element.extend({\n\n        defaults: {\n            scopeConfig: {}\n        },\n\n        /**\n         * Takes website id from current customer data and compare it with current website id\n         * If customer belongs to another scope, we need to invalidate current section\n         *\n         * @param {Object} customerData\n         */\n        process: function (customerData) {\n            var customer = customerData.get('customer');\n\n            if (this.scopeConfig && customer() &&\n                ~~customer().websiteId !== ~~this.scopeConfig.websiteId && ~~customer().websiteId !== 0) {\n                customerData.reload(['customer']);\n            }\n        }\n    });\n});\n","Magento_Customer/js/action/login.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/storage',\n    'Magento_Ui/js/model/messageList',\n    'Magento_Customer/js/customer-data',\n    'mage/translate'\n], function ($, storage, globalMessageList, customerData, $t) {\n    'use strict';\n\n    var callbacks = [],\n\n        /**\n         * @param {Object} loginData\n         * @param {String} redirectUrl\n         * @param {*} isGlobal\n         * @param {Object} messageContainer\n         */\n        action = function (loginData, redirectUrl, isGlobal, messageContainer) {\n            messageContainer = messageContainer || globalMessageList;\n\n            return storage.post(\n                'customer/ajax/login',\n                JSON.stringify(loginData),\n                isGlobal\n            ).done(function (response) {\n                if (response.errors) {\n                    messageContainer.addErrorMessage(response);\n                    callbacks.forEach(function (callback) {\n                        callback(loginData);\n                    });\n                } else {\n                    callbacks.forEach(function (callback) {\n                        callback(loginData);\n                    });\n                    customerData.invalidate(['customer']);\n\n                    if (response.redirectUrl) {\n                        window.location.href = response.redirectUrl;\n                    } else if (redirectUrl) {\n                        window.location.href = redirectUrl;\n                    } else {\n                        location.reload();\n                    }\n                }\n            }).fail(function () {\n                messageContainer.addErrorMessage({\n                    'message': $t('Could not authenticate. Please try again later')\n                });\n                callbacks.forEach(function (callback) {\n                    callback(loginData);\n                });\n            });\n        };\n\n    /**\n     * @param {Function} callback\n     */\n    action.registerLoginCallback = function (callback) {\n        callbacks.push(callback);\n    };\n\n    return action;\n});\n","Magento_Customer/js/action/check-email-availability.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'mage/storage',\n    'Magento_Checkout/js/model/url-builder'\n], function (storage, urlBuilder) {\n    'use strict';\n\n    return function (deferred, email) {\n        return storage.post(\n            urlBuilder.createUrl('/customers/isEmailAvailable', {}),\n            JSON.stringify({\n                customerEmail: email\n            }),\n            false\n        ).done(function (isEmailAvailable) {\n            if (isEmailAvailable) {\n                deferred.resolve();\n            } else {\n                deferred.reject();\n            }\n        }).fail(function () {\n            deferred.reject();\n        });\n    };\n});\n","Magento_Customer/js/model/authentication-popup.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/modal'\n], function ($, modal) {\n    'use strict';\n\n    return {\n        modalWindow: null,\n\n        /**\n         * Create popUp window for provided element\n         *\n         * @param {HTMLElement} element\n         */\n        createPopUp: function (element) {\n            var options = {\n                'type': 'popup',\n                'modalClass': 'popup-authentication',\n                'focus': '[name=username]',\n                'responsive': true,\n                'innerScroll': true,\n                'trigger': '.proceed-to-checkout',\n                'buttons': []\n            };\n\n            this.modalWindow = element;\n            modal(options, $(this.modalWindow));\n        },\n\n        /** Show login popup window */\n        showModal: function () {\n            $(this.modalWindow).modal('openModal').trigger('contentUpdated');\n        }\n    };\n});\n","Magento_Customer/js/model/address-list.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'ko',\n    './customer-addresses'\n], function (ko, defaultProvider) {\n    'use strict';\n\n    return ko.observableArray(defaultProvider.getAddressItems());\n});\n","Magento_Customer/js/model/customer.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'ko',\n    'underscore',\n    './address-list'\n], function ($, ko, _, addressList) {\n    'use strict';\n\n    var isLoggedIn = ko.observable(window.isCustomerLoggedIn),\n        customerData = {};\n\n    if (isLoggedIn()) {\n        customerData = window.customerData;\n    } else {\n        customerData = {};\n    }\n\n    return {\n        customerData: customerData,\n        customerDetails: {},\n        isLoggedIn: isLoggedIn,\n\n        /**\n         * @param {Boolean} flag\n         */\n        setIsLoggedIn: function (flag) {\n            isLoggedIn(flag);\n        },\n\n        /**\n         * @return {Array}\n         */\n        getBillingAddressList: function () {\n            return addressList();\n        },\n\n        /**\n         * @return {Array}\n         */\n        getShippingAddressList: function () {\n            return addressList();\n        },\n\n        /**\n         * @param {String} fieldName\n         * @param {*} value\n         */\n        setDetails: function (fieldName, value) {\n            if (fieldName) {\n                this.customerDetails[fieldName] = value;\n            }\n        },\n\n        /**\n         * @param {String} fieldName\n         * @return {*}\n         */\n        getDetails: function (fieldName) {\n            if (fieldName) {\n                if (this.customerDetails.hasOwnProperty(fieldName)) {\n                    return this.customerDetails[fieldName];\n                }\n\n                return undefined;\n            }\n\n            return this.customerDetails;\n        },\n\n        /**\n         * @param {Array} address\n         * @return {Number}\n         */\n        addCustomerAddress: function (address) {\n            var fields = [\n                    'customer_id', 'country_id', 'street', 'company', 'telephone', 'fax', 'postcode', 'city',\n                    'firstname', 'lastname', 'middlename', 'prefix', 'suffix', 'vat_id', 'default_billing',\n                    'default_shipping'\n                ],\n                customerAddress = {},\n                hasAddress = 0,\n                existingAddress;\n\n            if (!this.customerData.addresses) {\n                this.customerData.addresses = [];\n            }\n\n            customerAddress = _.pick(address, fields);\n\n            if (address.hasOwnProperty('region_id')) {\n                customerAddress.region = {\n                    'region_id': address['region_id'],\n                    region: address.region\n                };\n            }\n\n            for (existingAddress in this.customerData.addresses) {\n                if (this.customerData.addresses.hasOwnProperty(existingAddress)) {\n                    if (_.isEqual(this.customerData.addresses[existingAddress], customerAddress)) { //eslint-disable-line\n                        hasAddress = existingAddress;\n                        break;\n                    }\n                }\n            }\n\n            if (hasAddress === 0) {\n                return this.customerData.addresses.push(customerAddress) - 1;\n            }\n\n            return hasAddress;\n        },\n\n        /**\n         * @param {*} addressId\n         * @return {Boolean}\n         */\n        setAddressAsDefaultBilling: function (addressId) {\n            if (this.customerData.addresses[addressId]) {\n                this.customerData.addresses[addressId]['default_billing'] = 1;\n\n                return true;\n            }\n\n            return false;\n        },\n\n        /**\n         * @param {*} addressId\n         * @return {Boolean}\n         */\n        setAddressAsDefaultShipping: function (addressId) {\n            if (this.customerData.addresses[addressId]) {\n                this.customerData.addresses[addressId]['default_shipping'] = 1;\n\n                return true;\n            }\n\n            return false;\n        }\n    };\n});\n","Magento_Customer/js/model/customer-addresses.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'ko',\n    './customer/address'\n], function ($, ko, Address) {\n    'use strict';\n\n    var isLoggedIn = ko.observable(window.isCustomerLoggedIn);\n\n    return {\n        /**\n         * @return {Array}\n         */\n        getAddressItems: function () {\n            var items = [],\n                customerData = window.customerData;\n\n            if (isLoggedIn()) {\n                if (Object.keys(customerData).length) {\n                    $.each(customerData.addresses, function (key, item) {\n                        items.push(new Address(item));\n                    });\n                }\n            }\n\n            return items;\n        }\n    };\n});\n","Magento_Customer/js/model/customer/address.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine(['underscore'], function (_) {\n    'use strict';\n\n    /**\n     * Returns new address object.\n     *\n     * @param {Object} addressData\n     * @return {Object}\n     */\n    return function (addressData) {\n        var regionId;\n\n        if (addressData.region['region_id'] && addressData.region['region_id'] !== '0') {\n            regionId = addressData.region['region_id'] + '';\n        }\n\n        return {\n            customerAddressId: addressData.id,\n            email: addressData.email,\n            countryId: addressData['country_id'],\n            regionId: regionId,\n            regionCode: addressData.region['region_code'],\n            region: addressData.region.region,\n            customerId: addressData['customer_id'],\n            street: addressData.street,\n            company: addressData.company,\n            telephone: addressData.telephone,\n            fax: addressData.fax,\n            postcode: addressData.postcode,\n            city: addressData.city,\n            firstname: addressData.firstname,\n            lastname: addressData.lastname,\n            middlename: addressData.middlename,\n            prefix: addressData.prefix,\n            suffix: addressData.suffix,\n            vatId: addressData['vat_id'],\n            sameAsBilling: addressData['same_as_billing'],\n            saveInAddressBook: addressData['save_in_address_book'],\n            customAttributes: _.toArray(addressData['custom_attributes']).reverse(),\n\n            /**\n             * @return {*}\n             */\n            isDefaultShipping: function () {\n                return addressData['default_shipping'];\n            },\n\n            /**\n             * @return {*}\n             */\n            isDefaultBilling: function () {\n                return addressData['default_billing'];\n            },\n\n            /**\n             * @return {*}\n             */\n            getAddressInline: function () {\n                return addressData.inline;\n            },\n\n            /**\n             * @return {String}\n             */\n            getType: function () {\n                return 'customer-address';\n            },\n\n            /**\n             * @return {String}\n             */\n            getKey: function () {\n                return this.getType() + this.customerAddressId;\n            },\n\n            /**\n             * @return {String}\n             */\n            getCacheKey: function () {\n                return this.getKey();\n            },\n\n            /**\n             * @return {Boolean}\n             */\n            isEditable: function () {\n                return false;\n            },\n\n            /**\n             * @return {Boolean}\n             */\n            canUseForBilling: function () {\n                return true;\n            }\n        };\n    };\n});\n","Magento_Customer/js/view/authentication-popup.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'ko',\n    'Magento_Ui/js/form/form',\n    'Magento_Customer/js/action/login',\n    'Magento_Customer/js/customer-data',\n    'Magento_Customer/js/model/authentication-popup',\n    'mage/translate',\n    'mage/url',\n    'Magento_Ui/js/modal/alert',\n    'mage/validation'\n], function ($, ko, Component, loginAction, customerData, authenticationPopup, $t, url, alert) {\n    'use strict';\n\n    return Component.extend({\n        registerUrl: window.authenticationPopup.customerRegisterUrl,\n        forgotPasswordUrl: window.authenticationPopup.customerForgotPasswordUrl,\n        autocomplete: window.authenticationPopup.autocomplete,\n        modalWindow: null,\n        isLoading: ko.observable(false),\n\n        defaults: {\n            template: 'Magento_Customer/authentication-popup'\n        },\n\n        /**\n         * Init\n         */\n        initialize: function () {\n            var self = this;\n\n            this._super();\n            url.setBaseUrl(window.authenticationPopup.baseUrl);\n            loginAction.registerLoginCallback(function () {\n                self.isLoading(false);\n            });\n        },\n\n        /** Init popup login window */\n        setModalElement: function (element) {\n            if (authenticationPopup.modalWindow == null) {\n                authenticationPopup.createPopUp(element);\n            }\n        },\n\n        /** Is login form enabled for current customer */\n        isActive: function () {\n            var customer = customerData.get('customer');\n\n            return customer() == false; //eslint-disable-line eqeqeq\n        },\n\n        /** Show login popup window */\n        showModal: function () {\n            if (this.modalWindow) {\n                $(this.modalWindow).modal('openModal');\n            } else {\n                alert({\n                    content: $t('Guest checkout is disabled.')\n                });\n            }\n        },\n\n        /**\n         * Provide login action\n         *\n         * @return {Boolean}\n         */\n        login: function (formUiElement, event) {\n            var loginData = {},\n                formElement = $(event.currentTarget),\n                formDataArray = formElement.serializeArray();\n\n            event.stopPropagation();\n            formDataArray.forEach(function (entry) {\n                loginData[entry.name] = entry.value;\n            });\n\n            if (formElement.validation() &&\n                formElement.validation('isValid')\n            ) {\n                this.isLoading(true);\n                loginAction(loginData);\n            }\n\n            return false;\n        }\n    });\n});\n","Magento_Customer/js/view/customer.js":"/**\n* Copyright \u00a9 Magento, Inc. All rights reserved.\n* See COPYING.txt for license details.\n*/\n\ndefine([\n    'uiComponent',\n    'Magento_Customer/js/customer-data'\n], function (Component, customerData) {\n    'use strict';\n\n    return Component.extend({\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n\n            this.customer = customerData.get('customer');\n        }\n    });\n});\n","Amazon_Payment/js/amazon-product-add.js":"/**\n * Copyright 2016 Amazon.com, Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\").\n * You may not use this file except in compliance with the License.\n * A copy of the License is located at\n *\n *  http://aws.amazon.com/apache2.0\n *\n * or in the \"license\" file accompanying this file. This file is distributed\n * on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either\n * express or implied. See the License for the specific language governing\n * permissions and limitations under the License.\n */\n\ndefine([\n    'jquery',\n    'Magento_Customer/js/customer-data',\n    'amazonCore'\n], function ($, customerData) {\n    'use strict';\n\n    var _this,\n        addedViaAmazon = false;\n\n    $.widget('amazon.AmazonProductAdd', {\n        options: {\n            addToCartForm: '#product_addtocart_form'\n        },\n\n        /**\n         * Create triggers\n         */\n        _create: function () {\n            _this = this;\n            this.setupTriggers();\n        },\n\n        /**\n         * Setup triggers when item added to cart if amazon pay button pressed\n         */\n        setupTriggers: function () {\n            this.cart = customerData.get('cart');\n\n            //subscribe to add to cart event\n            this.cart.subscribe(function () {\n                //only trigger the amazon button click if the user has chosen to add to cart via this method\n                if (addedViaAmazon) {\n                    addedViaAmazon = false;\n                    $('.login-with-amazon img').trigger('click');\n                }\n            }, this);\n\n            //setup binds for click\n            $('.amazon-addtoCart').on('click', function () {\n                if ($(_this.options.addToCartForm).valid()) {\n                    addedViaAmazon = true;\n                    $(_this.options.addToCartForm).submit();\n                }\n            });\n        }\n\n    });\n\n    return $.amazon.AmazonProductAdd;\n});\n","Amazon_Payment/js/amazon-widgets-loader.js":"/**\n * Copyright 2016 Amazon.com, Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\").\n * You may not use this file except in compliance with the License.\n * A copy of the License is located at\n *\n *  http://aws.amazon.com/apache2.0\n *\n * or in the \"license\" file accompanying this file. This file is distributed\n * on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either\n * express or implied. See the License for the specific language governing\n * permissions and limitations under the License.\n */\n\ndefine(['uiRegistry'], function(registry) {\n    'use strict';\n    registry.get('amazonPayment', function (amazonPayment) {\n        // Load external Widgets.js\n        require([amazonPayment.widgetUrl]);\n    });\n});\n","Amazon_Payment/js/amazon-button.js":"/**\n * Copyright 2016 Amazon.com, Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\").\n * You may not use this file except in compliance with the License.\n * A copy of the License is located at\n *\n *  http://aws.amazon.com/apache2.0\n *\n * or in the \"license\" file accompanying this file. This file is distributed\n * on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either\n * express or implied. See the License for the specific language governing\n * permissions and limitations under the License.\n */\ndefine([\n    'jquery',\n    'Magento_Customer/js/customer-data',\n    'Magento_Customer/js/section-config',\n    'Amazon_Payment/js/model/amazonPaymentConfig',\n    'amazonCsrf',\n    'Magento_Checkout/js/model/full-screen-loader',\n    'modernizr/modernizr',\n    'amazonCore',\n    'uiRegistry',\n    'mage/cookies'\n], function ($, customerData, sectionConfig, amazonPaymentConfig, amazonCsrf, fullScreenLoader) {\n    'use strict';\n    var _this;\n\n    if (amazonPaymentConfig.isDefined()) {\n\n        $.widget('amazon.AmazonButton', {\n            options: {\n                merchantId: null,\n                buttonType: 'LwA',\n                buttonColor: 'Gold',\n                buttonSize: 'medium',\n                redirectUrl: null,\n                loginPostUrl: null\n            },\n\n            /**\n             * Create button\n             */\n            _create: function () {\n                _this = this;\n\n                this._verifyAmazonConfig();\n\n                if (typeof OffAmazonPayments === 'undefined') {\n                    // async render\n                    $(window).on('OffAmazonPayments', $.proxy(function () {\n                        this._renderAmazonButton();\n                    }, this));\n                } else {\n                    this._renderAmazonButton();\n                }\n            },\n\n            /**\n             * Verify if checkout config is available\n             * @private\n             */\n            _verifyAmazonConfig: function () {\n                if (amazonPaymentConfig.isDefined()) {\n                    this.options.merchantId = amazonPaymentConfig.getValue('merchantId');\n                    this.options.buttonType = this.options.buttonType === 'LwA' ?\n                        amazonPaymentConfig.getValue('buttonTypeLwa') : amazonPaymentConfig.getValue('buttonTypePwa');\n                    this.options.buttonColor = amazonPaymentConfig.getValue('buttonColor');\n                    this.options.buttonSize = amazonPaymentConfig.getValue('buttonSize');\n                    this.options.redirectUrl = amazonPaymentConfig.getValue('redirectUrl');\n                    this.options.loginPostUrl = amazonPaymentConfig.getValue('loginPostUrl');\n                    this.options.loginScope = amazonPaymentConfig.getValue('loginScope');\n                    this.options.buttonLanguage = amazonPaymentConfig.getValue('displayLanguage');\n                }\n            },\n\n            /**\n             * Validate CSRF cookie and redirect to HTTPS\n             */\n            secureHttpsCallback: function (event) {\n                var sections = sectionConfig.getAffectedSections(_this.options.loginPostUrl);\n\n                if (!event.state || !amazonCsrf.isValid(event.state)) {\n                    window.location = amazonPaymentConfig.getValue('customerLoginPageUrl');\n\n                    return window.location;\n                }\n\n                // jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n                if (!event.access_token || !!event.error) {\n                    window.location = amazonPaymentConfig.getValue('customerLoginPageUrl');\n\n                    return window.location;\n                }\n\n                if (sections) {\n                    customerData.invalidate(sections);\n                }\n                $.mage.cookies.set('amazon_Login_accessToken', event.access_token);\n                window.location = _this.options.redirectUrl + '?access_token=' + event.access_token;\n                // jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n            },\n\n            /**\n             * Use popup or redirect URI\n             *\n             * @return {String}\n             */\n            _popupCallback: function () {\n                return _this.usePopUp() ? _this.secureHttpsCallback :\n                    amazonPaymentConfig.getValue('oAuthHashRedirectUrl');\n            },\n\n            /**\n             * Are touch events available\n             * (Supports both v2 and v3 Modernizr)\n             * @returns {Boolean}\n             * @private\n             */\n            _touchSupported: function () {\n                //eslint-disable-next-line no-undef\n                return Modernizr.touch !== undefined ? Modernizr.touch : Modernizr.touchevents;\n            },\n\n            /**\n             * Should we use the pop up login flow?\n             *  - are we on an HTTPS page (required for popup)\n             *  - confirm we are not on the product detail page (items are added asynchronously to the cart,\n             *    hence popups will be blocked)\n             *  - confirm we are not using a touch device (redirect provides a better mobile experience)\n             * @returns {Boolean}\n             * @public\n             */\n            usePopUp: function () {\n                return window.location.protocol === 'https:' && !$('body').hasClass('catalog-product-view') &&\n                    !this._touchSupported();\n            },\n\n            /**\n             * onAmazonPaymentsReady\n             * @private\n             */\n            _renderAmazonButton: function () {\n                OffAmazonPayments.Button(this.element[0].id, this.options.merchantId, { //eslint-disable-line no-undef\n                    type: this.options.buttonType,\n                    color: this.options.buttonColor,\n                    size: this.options.buttonSize,\n                    language: this.options.buttonLanguage,\n\n                    /**\n                     * Authorization callback\n                     */\n                    authorization: function () {\n                        //eslint-disable-next-line no-undef\n                        amazon.Login.authorize(_this._getLoginOptions(), _this._popupCallback());\n                    }\n                });\n                $('.amazon-button-container .field-tooltip').fadeIn();\n            },\n\n            /**\n             * Build login options\n             * @returns {{scope: *, popup: *, state: *}}\n             * @private\n             */\n            _getLoginOptions: function () {\n                return {\n                    scope: this.options.loginScope,\n                    popup: this.usePopUp(),\n                    state: amazonCsrf.generateNewValue()\n                };\n            }\n        });\n\n        return $.amazon.AmazonButton;\n    }\n});\n","Amazon_Payment/js/amazon-core.js":"/**\n * Copyright 2016 Amazon.com, Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\").\n * You may not use this file except in compliance with the License.\n * A copy of the License is located at\n *\n *  http://aws.amazon.com/apache2.0\n *\n * or in the \"license\" file accompanying this file. This file is distributed\n * on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either\n * express or implied. See the License for the specific language governing\n * permissions and limitations under the License.\n */\n\ndefine([\n    'jquery',\n    'ko',\n    'mage/url',\n    'amazonPaymentConfig',\n    'Magento_Ui/js/model/messageList',\n    'amazonWidgetsLoader',\n    'jquery/jquery-storageapi',\n    'mage/cookies'\n], function ($, ko, url, amazonPaymentConfig, messageList) {\n    'use strict';\n\n    var amazonDefined = ko.observable(false),\n        amazonLoginError = ko.observable(false),\n        accessToken = ko.observable(null),\n        // Match region config to amazon.Login.Region\n        regions = {'us': 'NA', 'de': 'EU', 'uk': 'EU', 'jp': 'APAC'},\n        sandboxMode,\n        region;\n\n    accessToken($.mage.cookies.get('amazon_Login_accessToken'));\n\n    var initAmazonLogin = function () {\n        amazon.Login.setClientId(amazonPaymentConfig.getValue('clientId')); //eslint-disable-line no-undef\n        amazon.Login.setSandboxMode(amazonPaymentConfig.getValue('isSandboxEnabled', false)); //eslint-disable-line no-undef\n        amazon.Login.setRegion(regions[amazonPaymentConfig.getValue('region')]); //eslint-disable-line no-undef\n        amazon.Login.setUseCookie(true); //eslint-disable-line no-undef\n\n        doLogoutOnFlagCookie(); //eslint-disable-line no-use-before-define\n        amazonDefined(true);\n    };\n\n    if (typeof amazon === 'undefined') {\n        window.onAmazonLoginReady = initAmazonLogin;\n    } else {\n        initAmazonLogin();\n    }\n\n    // Widgets.js ready callback\n    window.onAmazonPaymentsReady = function() {\n        $(window).trigger('OffAmazonPayments');\n    };\n\n    /**\n     * Log user out of amazon\n     */\n    function amazonLogout() {\n        $.mage.cookies.clear('amazon_Login_accessToken');\n        $.ajax({\n            url: url.build('amazon/logout'),\n            context: this\n        }).always(function () {\n            if (amazonDefined()) {\n                amazon.Login.logout(); //eslint-disable-line no-undef\n            } else {\n                var logout = amazonDefined.subscribe(function (defined) { //eslint-disable-line vars-on-top\n                    if (defined) {\n                        amazon.Login.logout(); // eslint-disable-line no-undef\n                        logout.dispose(); //remove subscribe\n                    }\n                });\n            }\n        });\n    }\n\n    /**\n     * Check if login error / logout cookies are present\n     */\n    function doLogoutOnFlagCookie() {\n        var errorFlagCookie = 'amz_auth_err',\n            amazonLogoutCookie = 'amz_auth_logout';\n\n        //eslint-disable-next-line no-use-before-define\n        $.cookieStorage.isSet(errorFlagCookie) ? amazonLogoutThrowError(errorFlagCookie) : false;\n        //eslint-disable-next-line no-use-before-define\n        $.cookieStorage.isSet(amazonLogoutCookie) ? amazonLogoutThrowError(amazonLogoutCookie) : false;\n    }\n\n    /**\n     * Handle deletion of cookie and log user out if present\n     */\n    function amazonLogoutThrowError(cookieToRemove) {\n        amazonLogout();\n        document.cookie = cookieToRemove + '=; Path=/; expires=Thu, 01 Jan 1970 00:00:01 GMT;';\n        amazonLoginError(true);\n    }\n\n    function handleWidgetError(error) {\n        console.log('OffAmazonPayments.Widgets', error.getErrorCode(), error.getErrorMessage());\n        switch (error.getErrorCode()) {\n            case 'BuyerSessionExpired':\n                messageList.addErrorMessage({message: $.mage.__('Your Amazon session has expired.  Please sign in again by clicking the Amazon Pay Button.')});\n                var storage = require('Amazon_Payment/js/model/storage'); //TODO: clean up this circular dependency\n                storage.amazonlogOut();\n                break;\n            case 'ITP':\n                // ITP errors are how handled within the widget code\n                break;\n            default:\n                messageList.addErrorMessage({message: $.mage.__(error.getErrorMessage())});\n        }\n    }\n\n    return {\n        /**\n         * Log user out of Amazon\n         */\n        AmazonLogout: amazonLogout,\n        amazonDefined: amazonDefined,\n        accessToken: accessToken,\n        amazonLoginError: amazonLoginError,\n        handleWidgetError: handleWidgetError\n    };\n\n});\n","Amazon_Payment/js/messages.js":"/**\n * Copyright 2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\").\n * You may not use this file except in compliance with the License.\n * A copy of the License is located at\n *\n *  http://aws.amazon.com/apache2.0\n *\n * or in the \"license\" file accompanying this file. This file is distributed\n * on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either\n * express or implied. See the License for the specific language governing\n * permissions and limitations under the License.\n */\n\ndefine(\n    [\n        'jquery',\n        'Amazon_Payment/js/model/storage',\n        'Magento_Theme/js/view/messages',\n        'Magento_Ui/js/model/messageList'\n    ], function(\n        $,\n        amazonStorage,\n        messagesFactory,\n        messageList\n    ) {\n        'use strict';\n\n        return {\n            defaults: {},\n            isAmazonAccountLoggedIn: amazonStorage.isAmazonAccountLoggedIn,\n\n            /*\n             * Magento's core Checkout module removes the \"messages\" block from the layout,\n             *  so we display them on checkout using the messageList API.\n             */\n            displayMessages: function () {\n                if(this.isAmazonAccountLoggedIn()) {\n                    var messagesComponent = messagesFactory();\n                    messagesComponent.cookieMessages.forEach(function(message) {\n                        if(message.type == 'error') {\n                            messageList.addErrorMessage({message: $.mage.__($(\"<textarea/>\").html(message.text).text())});\n                        }\n                    });\n                }\n            },\n\n            addMessage: function (type, messageText) {\n                var messageComponent = messagesFactory();\n\n                if (type === 'error') {\n                    messageList.addErrorMessage({message: $.mage.__($(\"<textarea/>\").html(messageText).text())});\n                }\n            }\n        }\n    }\n);\n","Amazon_Payment/js/action/populate-shipping-address.js":"/**\n * Copyright 2016 Amazon.com, Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\").\n * You may not use this file except in compliance with the License.\n * A copy of the License is located at\n *\n *  http://aws.amazon.com/apache2.0\n *\n * or in the \"license\" file accompanying this file. This file is distributed\n * on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either\n * express or implied. See the License for the specific language governing\n * permissions and limitations under the License.\n */\n\ndefine(\n    [\n        'jquery',\n        'Magento_Checkout/js/model/address-converter',\n        'Magento_Checkout/js/model/quote',\n        'uiRegistry',\n        'Magento_Checkout/js/checkout-data',\n        'Magento_Checkout/js/model/checkout-data-resolver',\n        'Amazon_Payment/js/model/storage'\n    ],\n    function ($, addressConverter, quote, registry, checkoutData, checkoutDataResolver, amazonStorage) {\n        'use strict';\n\n        /**\n         * Populate shipping address form in shipping step from quote model         *\n         */\n        function populateShippingForm() {\n            var shippingAddressData = checkoutData.getShippingAddressFromData();\n\n            registry.async('checkoutProvider')(function (checkoutProvider) {\n                checkoutProvider.set(\n                    'shippingAddress',\n                    $.extend({}, checkoutProvider.get('shippingAddress'), shippingAddressData)\n                );\n            });\n            checkoutDataResolver.resolveShippingAddress();\n        }\n\n        /**\n         * Populate shipping address form in shipping step from quote model\n         * @private\n         */\n        return function () {\n            //check to see if user is logged out of amazon (otherwise shipping form won't be in DOM)\n            if (!amazonStorage.isAmazonAccountLoggedIn) {\n                populateShippingForm();\n            }\n            //subscribe to logout and trigger shippingform population when logged out.\n            amazonStorage.isAmazonAccountLoggedIn.subscribe(function (loggedIn) {\n                if (!loggedIn) {\n                    populateShippingForm();\n                }\n            });\n        };\n    }\n);\n","Amazon_Payment/js/action/place-order.js":"/**\n * Copyright 2016 Amazon.com, Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\").\n * You may not use this file except in compliance with the License.\n * A copy of the License is located at\n *\n *  http://aws.amazon.com/apache2.0\n *\n * or in the \"license\" file accompanying this file. This file is distributed\n * on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either\n * express or implied. See the License for the specific language governing\n * permissions and limitations under the License.\n */\n\ndefine(\n    [\n        'Magento_Checkout/js/model/quote',\n        'Magento_Checkout/js/model/url-builder',\n        'mage/storage',\n        'mage/url',\n        'Magento_Checkout/js/model/error-processor',\n        'Magento_Customer/js/model/customer',\n        'Magento_Checkout/js/model/full-screen-loader',\n        'Amazon_Payment/js/model/storage',\n        'Amazon_Payment/js/model/amazonPaymentConfig',\n        'Magento_Customer/js/customer-data'\n    ],\n    function (quote, urlBuilder, storage, url, errorProcessor, customer, fullScreenLoader, amazonStorage, amazonPaymentConfig, customerData) {\n        'use strict';\n\n        return function (paymentData, redirectOnSuccess) {\n            var serviceUrl, payload;\n\n            redirectOnSuccess = redirectOnSuccess !== false;\n\n            /** Checkout for guest and registered customer. */\n            if (!customer.isLoggedIn()) {\n                serviceUrl = urlBuilder.createUrl('/guest-carts/:quoteId/set-payment-information', {\n                    quoteId: quote.getQuoteId()\n                });\n                payload = {\n                    confirmOrder: true,\n                    cartId: quote.getQuoteId(),\n                    email: quote.guestEmail,\n                    paymentMethod: paymentData,\n                    billingAddress: quote.billingAddress()\n                };\n            } else {\n                serviceUrl = urlBuilder.createUrl('/carts/mine/set-payment-information', {});\n                payload = {\n                    confirmOrder: true,\n                    cartId: quote.getQuoteId(),\n                    paymentMethod: paymentData,\n                    billingAddress: quote.billingAddress()\n                };\n            }\n\n            fullScreenLoader.startLoader();\n            customerData.invalidate(['cart']);\n            if(amazonPaymentConfig.getValue('scaRegions').indexOf(amazonPaymentConfig.getValue('region')) !== -1) {\n                console.log('SCA enabled for region: ' + amazonPaymentConfig.getValue('region'));\n                return OffAmazonPayments.initConfirmationFlow(amazonPaymentConfig.getValue('merchantId'), amazonStorage.getOrderReference(), function(confirmationFlow) {\n                    return storage.post(\n                        serviceUrl,\n                        JSON.stringify(payload)\n                    ).done(\n                        function () {\n                            confirmationFlow.success();\n                        }\n                    ).fail(\n                        function (response) {\n                            confirmationFlow.error();\n                            errorProcessor.process(response);\n                            amazonStorage.amazonDeclineCode(response.responseJSON.code);\n                            fullScreenLoader.stopLoader(true);\n                        }\n                    );\n                });\n            } else {\n                console.log('SCA disabled for region: ' + amazonPaymentConfig.getValue('region'));\n                return storage.post(\n                    serviceUrl,\n                    JSON.stringify(payload)\n                ).done(\n                    function () {\n                        if(redirectOnSuccess) {\n                            window.location.replace(url.build('amazonpayments/payment/completecheckout/?AuthenticationStatus=Success'));\n                        }\n                    }\n                ).fail(\n                    function (response) {\n                        errorProcessor.process(response);\n                        amazonStorage.amazonDeclineCode(response.responseJSON.code);\n                        fullScreenLoader.stopLoader(true);\n                    }\n                );\n            }\n        };\n    }\n);\n","Amazon_Payment/js/model/place-order-mixin.js":"/**\n * Copyright 2016 Amazon.com, Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\").\n * You may not use this file except in compliance with the License.\n * A copy of the License is located at\n *\n * http://aws.amazon.com/apache2.0\n *\n * or in the \"license\" file accompanying this file. This file is distributed\n * on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either\n * express or implied. See the License for the specific language governing\n * permissions and limitations under the License.\n */\n/*jshint browser:true jquery:true*/\n/*global alert*/\ndefine([\n    'jquery',\n    'mage/utils/wrapper',\n    'Magento_CheckoutAgreements/js/model/agreements-assigner'\n], function ($, wrapper, agreementsAssigner) {\n    'use strict';\n\n    return function (placeOrderAction) {\n\n        /** Override default place order action and add agreement_ids to request */\n        return wrapper.wrap(placeOrderAction, function (originalAction, paymentData,\n            redirectOnSuccess, messageContainer) {\n\n            agreementsAssigner(paymentData);\n\n            return originalAction(paymentData, redirectOnSuccess, messageContainer);\n        });\n    };\n});\n","Amazon_Payment/js/model/amazonPaymentConfig.js":"/**\n * Copyright 2016 Amazon.com, Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\").\n * You may not use this file except in compliance with the License.\n * A copy of the License is located at\n *\n *  http://aws.amazon.com/apache2.0\n *\n * or in the \"license\" file accompanying this file. This file is distributed\n * on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either\n * express or implied. See the License for the specific language governing\n * permissions and limitations under the License.\n */\ndefine(\n    ['uiRegistry'],\n    function (registry) {\n        'use strict';\n\n        var config = registry.get('amazonPayment') || {};\n\n        return {\n            /**\n             * Get config value\n             */\n            getValue: function (key, defaultValue) {\n                if (config.hasOwnProperty(key)) {\n                    return config[key];\n                } else if (defaultValue !== undefined) {\n                    return defaultValue;\n                }\n            },\n\n            /**\n             * Is amazonPayment defined?\n             */\n            isDefined: function () {\n                return registry.get('amazonPayment') !== undefined;\n            }\n        };\n    }\n);\n","Amazon_Payment/js/model/storage.js":"/**\n * Copyright 2016 Amazon.com, Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\").\n * You may not use this file except in compliance with the License.\n * A copy of the License is located at\n *\n *  http://aws.amazon.com/apache2.0\n *\n * or in the \"license\" file accompanying this file. This file is distributed\n * on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either\n * express or implied. See the License for the specific language governing\n * permissions and limitations under the License.\n */\n\ndefine(\n    [\n        'jquery',\n        'ko',\n        'amazonCore',\n        'amazonPaymentConfig'\n    ],\n    function (\n        $,\n        ko,\n        amazonCore,\n        amazonPaymentConfig\n    ) {\n        'use strict';\n\n        var isAmazonAccountLoggedIn = ko.observable(false),\n            isAmazonEnabled = ko.observable(amazonPaymentConfig.getValue('isPwaEnabled')),\n            orderReferenceId = ko.observable(amazonPaymentConfig.getValue('orderReferenceId')),\n            orderReference,\n            addressConsentToken = amazonCore.accessToken,\n            //eslint-disable-next-line no-use-before-define\n            amazonLoginError = amazonCore.amazonLoginError.subscribe(setAmazonLoggedOutIfLoginError),\n            amazonDeclineCode = ko.observable(false),\n            sandboxSimulationReference = ko.observable('default'),\n            isPlaceOrderDisabled = ko.observable(false),\n            isShippingMethodsLoading = ko.observable(false),\n            isAmazonShippingAddressSelected = ko.observable(false),\n            isQuoteDirty = ko.observable(amazonPaymentConfig.getValue('isQuoteDirty')),\n            isPwaVisible = ko.computed(function () {\n                return isAmazonEnabled() && !isQuoteDirty();\n            }),\n            isAmazonCartInValid = ko.computed(function () {\n                return isAmazonAccountLoggedIn() && isQuoteDirty();\n            }),\n            isLoginRedirectPage = $('body').hasClass('amazon-login-login-processauthhash'),\n            amazonCustomerEmail = ko.computed(function () {\n                // jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n                if (window.hasOwnProperty('checkoutConfig') &&\n                    window.checkoutConfig.hasOwnProperty('amazonLogin') &&\n                    typeof window.checkoutConfig.amazonLogin.amazon_customer_email === 'string'\n                ) {\n                    return window.checkoutConfig.amazonLogin.amazon_customer_email;\n                }\n                // jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n                return '';\n            });\n\n\n\n        /**\n         * Log out amazon user\n         */\n        function amazonLogOut() {\n            amazonCore.AmazonLogout();\n            this.isAmazonAccountLoggedIn(false);\n        }\n\n        /**\n         * Set login error if logged out\n         */\n        function setAmazonLoggedOutIfLoginError(isLoggedOut) {\n            if (isLoggedOut === true) {\n                isAmazonAccountLoggedIn(false);\n                amazonLoginError.dispose();\n            }\n        }\n\n        /** if Amazon cart contents are invalid log user out **/\n        isAmazonCartInValid.subscribe(function (isCartInValid) {\n            if (isCartInValid) {\n                amazonLogOut();\n            }\n        });\n\n        verifyAmazonLoggedIn();\n        setAmazonLoggedOutIfLoginError(amazonCore.amazonLoginError());\n\n        /**\n         * Verifies amazon user is logged in\n         */\n        function verifyAmazonLoggedIn() {\n            isAmazonAccountLoggedIn(!!amazonCore.accessToken());\n        }\n\n        return {\n            isAmazonAccountLoggedIn: isAmazonAccountLoggedIn,\n            isAmazonEnabled: isAmazonEnabled,\n            orderReferenceId: orderReferenceId,\n            amazonDeclineCode: amazonDeclineCode,\n            sandboxSimulationReference: sandboxSimulationReference,\n            isPlaceOrderDisabled: isPlaceOrderDisabled,\n            isShippingMethodsLoading: isShippingMethodsLoading,\n            isAmazonShippingAddressSelected: isAmazonShippingAddressSelected,\n            isQuoteDirty: isQuoteDirty,\n            isPwaVisible: isPwaVisible,\n            amazonlogOut: amazonLogOut,\n            amazonDefined: amazonCore.amazonDefined,\n            amazonCustomerEmail: amazonCustomerEmail,\n\n            /**\n             * Set order reference\n             */\n            setOrderReference: function (or) {\n                orderReference = or;\n            },\n\n            /**\n             * Get order reference\n             */\n            getOrderReference: function () {\n                return this.orderReferenceId() || orderReference;\n            },\n\n            /**\n             * Get address consent token\n             */\n            getAddressConsentToken: function () {\n                return addressConsentToken();\n            }\n        };\n    }\n);\n","Amazon_Payment/js/view/notification.js":"/*global define*/\ndefine(\n    [\n        'jquery',\n        'underscore',\n        'ko',\n        'uiComponent',\n        'Amazon_Payment/js/model/storage',\n        'uiRegistry'\n    ],\n    function (\n        $,\n        _,\n        ko,\n        Component,\n        amazonStorage,\n        registry\n    ) {\n        'use strict';\n\n        return Component.extend(\n            {\n                defaults: {\n                    template: 'Amazon_Payment/notification'\n                },\n                isAmazonAccountLoggedIn: amazonStorage.isAmazonAccountLoggedIn,\n                chargeOnOrder: ko.observable(registry.get('amazonPayment').chargeOnOrder),\n                isEuPaymentRegion: ko.observable(registry.get('amazonPayment').isEuPaymentRegion),\n\n                /**\n                 * Init\n                 */\n                initialize: function () {\n                    this._super();\n                }\n            }\n        );\n    }\n);\n","Amazon_Payment/js/view/checkout-revert.js":"/*global define*/\ndefine(\n    [\n        'jquery',\n        'underscore',\n        'ko',\n        'uiComponent',\n        'Amazon_Payment/js/model/storage',\n        'mage/storage',\n        'Magento_Checkout/js/model/error-processor',\n        'Magento_Checkout/js/model/url-builder',\n        'Magento_Checkout/js/model/full-screen-loader',\n        'uiRegistry'\n    ],\n    function (\n        $,\n        _,\n        ko,\n        Component,\n        amazonStorage,\n        storage,\n        errorProcessor,\n        urlBuilder,\n        fullScreenLoader,\n        registry\n    ) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                template: 'Amazon_Payment/checkout-revert'\n            },\n            isAmazonAccountLoggedIn: amazonStorage.isAmazonAccountLoggedIn,\n            isAmazonEnabled: ko.observable(registry.get('amazonPayment').isPwaEnabled),\n\n            /**\n             * Init\n             */\n            initialize: function () {\n                this._super();\n            },\n\n            /**\n             * Revert checkout\n             */\n            revertCheckout: function () {\n                var serviceUrl = urlBuilder.createUrl('/amazon/order-ref', {});\n\n                fullScreenLoader.startLoader();\n                storage.delete(\n                    serviceUrl\n                ).done(\n                    function () {\n                        amazonStorage.amazonlogOut();\n                        fullScreenLoader.stopLoader();\n                    }\n                ).fail(\n                    function (response) {\n                        fullScreenLoader.stopLoader();\n                        errorProcessor.process(response);\n                    }\n                );\n            }\n        });\n    }\n);\n","Amazon_Payment/js/view/checkout-widget-address.js":"/*global define*/\n\ndefine(\n    [\n        'jquery',\n        'uiComponent',\n        'ko',\n        'Magento_Customer/js/model/customer',\n        'Magento_Checkout/js/model/quote',\n        'Magento_Checkout/js/action/select-shipping-address',\n        'Magento_Checkout/js/model/shipping-rate-processor/new-address',\n        'Magento_Checkout/js/action/set-shipping-information',\n        'Amazon_Payment/js/model/storage',\n        'amazonCore',\n        'Magento_Checkout/js/model/shipping-service',\n        'Magento_Checkout/js/model/address-converter',\n        'mage/storage',\n        'Magento_Checkout/js/model/full-screen-loader',\n        'Magento_Checkout/js/model/error-processor',\n        'Magento_Checkout/js/model/url-builder',\n        'Magento_Checkout/js/checkout-data',\n        'Magento_Checkout/js/model/checkout-data-resolver',\n        'uiRegistry',\n        'Amazon_Payment/js/messages'\n    ],\n    function (\n        $,\n        Component,\n        ko,\n        customer,\n        quote,\n        selectShippingAddress,\n        shippingProcessor,\n        setShippingInformationAction,\n        amazonStorage,\n        amazonCore,\n        shippingService,\n        addressConverter,\n        storage,\n        fullScreenLoader,\n        errorProcessor,\n        urlBuilder,\n        checkoutData,\n        checkoutDataResolver,\n        registry,\n        amazonMessages\n    ) {\n        'use strict';\n\n        var self;\n\n        return Component.extend({\n            defaults: {\n                template: 'Amazon_Payment/checkout-widget-address'\n            },\n            options: {\n                sellerId: registry.get('amazonPayment').merchantId,\n                addressWidgetDOMId: 'addressBookWidgetDiv',\n                widgetScope: registry.get('amazonPayment').loginScope\n            },\n            isCustomerLoggedIn: customer.isLoggedIn,\n            amazonCustomerEmail: amazonStorage.amazonCustomerEmail,\n            isAmazonAccountLoggedIn: amazonStorage.isAmazonAccountLoggedIn,\n            isAmazonEnabled: ko.observable(registry.get('amazonPayment').isPwaEnabled),\n            rates: shippingService.getShippingRates(),\n\n            /**\n             * Init\n             */\n            initialize: function () {\n                self = this;\n                this._super();\n                // Update checkoutUrl for step-navigator if orderReferenceId is set (e.g. InvaldPaymentMethod)\n                if (amazonStorage.orderReferenceId()) {\n                    window.checkoutConfig.checkoutUrl += '?orderReferenceId=' + amazonStorage.orderReferenceId()\n                }\n            },\n\n            /**\n             * Call when component template is rendered\n             */\n            initAddressWidget: function () {\n                if(amazonStorage.amazonDefined()) {\n                    self.renderAddressWidget();\n                } else {\n                    var subscription = amazonStorage.amazonDefined.subscribe(function (defined) { //eslint-disable-line vars-on-top\n                        if (defined) {\n                            self.renderAddressWidget();\n                            subscription.dispose();\n                        }\n                    });\n                }\n            },\n\n            /**\n             * render Amazon address Widget\n             */\n            renderAddressWidget: function () {\n                new OffAmazonPayments.Widgets.AddressBook({ // eslint-disable-line no-undef\n                    sellerId: self.options.sellerId,\n                    scope: self.options.widgetScope,\n\n                    /**\n                     * Order reference creation callback\n                     */\n                    onOrderReferenceCreate: function (orderReference) {\n                        var orderid = amazonStorage.orderReferenceId() || orderReference.getAmazonOrderReferenceId();\n                        amazonStorage.setOrderReference(orderid);\n                    },\n\n                    /**\n                     * Address select callback\n                     */\n                    onAddressSelect: function () { // orderReference\n                        self.getShippingAddressFromAmazon();\n                    },\n                    displayMode: self.isShippingAddressReadOnly() ? 'Read' : '',\n                    design: {\n                        designMode: 'responsive'\n                    },\n\n                    /**\n                     * Error callback\n                     */\n                    onError: amazonCore.handleWidgetError\n                }).bind(self.options.addressWidgetDOMId);\n                amazonMessages.displayMessages();\n            },\n\n            /**\n             * Get shipping address from Amazon API\n             */\n            getShippingAddressFromAmazon: function () {\n                var serviceUrl, payload;\n\n                amazonStorage.isShippingMethodsLoading(true);\n                shippingService.isLoading(true);\n                serviceUrl = urlBuilder.createUrl('/amazon-shipping-address/:amazonOrderReference', {\n                    amazonOrderReference: amazonStorage.getOrderReference()\n                }),\n                    payload = {\n                        addressConsentToken: amazonStorage.getAddressConsentToken()\n                    };\n\n                storage.put(\n                    serviceUrl,\n                    JSON.stringify(payload)\n                ).done(\n                    function (data) {\n                        var amazonAddress = data.shift(),\n                            addressData = addressConverter.formAddressDataToQuoteAddress(amazonAddress),\n                            i;\n\n                        //if telephone is blank set it to 00000000 so it passes the required validation\n                        addressData.telephone = !addressData.telephone ? '0000000000' : addressData.telephone;\n\n                        //fill in blank street fields\n                        if ($.isArray(addressData.street)) {\n                            for (i = addressData.street.length; i <= 2; i++) {\n                                addressData.street[i] = '';\n                            }\n                        }\n                        checkoutData.setShippingAddressFromData(\n                            addressConverter.quoteAddressToFormAddressData(addressData)\n                        );\n                        checkoutDataResolver.resolveEstimationAddress();\n\n                        amazonStorage.isAmazonShippingAddressSelected(true);\n                    }\n                ).fail(\n                    function (response) {\n                        errorProcessor.process(response);\n                        //remove shipping loader and set shipping rates to 0 on a fail\n                        shippingService.setShippingRates([]);\n                        amazonStorage.isShippingMethodsLoading(false);\n                        if (self.isShippingAddressReadOnly()) {\n                            shippingService.isLoading(false);\n                            $('.checkout-shipping-method').hide();\n                        }\n                    }\n                );\n            },\n\n            /**\n             * Get Amazon Order Reference ID\n             */\n            getAmazonOrderReference: function () {\n                return amazonStorage.getOrderReference();\n            },\n\n            /**\n             * Get Amazon Address Consent Token\n             */\n            getAddressConsentToken: function () {\n                return amazonStorage.getAddressConsentToken();\n            },\n\n            /**\n             * Is shipping widget set to read-only (orderReferenceId already set?)\n             */\n            isShippingAddressReadOnly: function() {\n                return (amazonStorage.orderReferenceId());\n            },\n\n            /**\n             * Continue to payment (e.g. if shipping address is read-only)\n             */\n            continuePayment: function() {\n                window.location = window.checkoutConfig.checkoutUrl + '#payment';\n            }\n        });\n    }\n);\n","Amazon_Payment/js/view/checkout-button.js":"/*global define*/\n\ndefine(\n    [\n        'jquery',\n        'uiComponent',\n        'ko',\n        'Magento_Customer/js/model/customer',\n        'Amazon_Payment/js/model/storage'\n    ],\n    function (\n        $,\n        Component,\n        ko,\n        customer,\n        amazonStorage\n    ) {\n        'use strict';\n\n        return Component.extend(\n            {\n                defaults: {\n                    template: 'Amazon_Payment/checkout-button'\n                },\n                isCustomerLoggedIn: customer.isLoggedIn,\n                isAmazonAccountLoggedIn: amazonStorage.isAmazonAccountLoggedIn,\n                isPwaVisible: amazonStorage.isPwaVisible,\n\n                /**\n                 * Init\n                 */\n                initialize: function () {\n                    this._super();\n                }\n            }\n        );\n    }\n);\n\n","Amazon_Payment/js/view/checkout-sandbox-simulator.js":"/*global define*/\n\ndefine(\n    [\n        'jquery',\n        'uiComponent',\n        'ko',\n        'Amazon_Payment/js/model/storage',\n        'uiRegistry'\n    ],\n    function (\n        $,\n        Component,\n        ko,\n        amazonStorage,\n        registry\n    ) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                template: 'Amazon_Payment/checkout-sandbox-simulator'\n            },\n            isAmazonAccountLoggedIn: amazonStorage.isAmazonAccountLoggedIn,\n            isSandboxEnabled: ko.observable(registry.get('amazonPayment').isSandboxEnabled),\n            sandboxSimulationReference: amazonStorage.sandboxSimulationReference,\n            sandboxSimulationOptions: ko.observableArray(registry.get('amazonPayment').sandboxSimulationOptions),\n\n            /**\n             * Init\n             */\n            initialize: function () {\n                this._super();\n            }\n        });\n    }\n);\n","Amazon_Payment/js/view/shipping.js":"/*global define*/\ndefine(\n    [\n        'jquery',\n        'Magento_Checkout/js/view/shipping',\n        'Magento_Customer/js/model/customer',\n        'Amazon_Payment/js/model/storage',\n        'Amazon_Payment/js/messages'\n    ],\n    function (\n        $,\n        Component,\n        customer,\n        amazonStorage,\n        amazonMessages\n    ) {\n        'use strict';\n\n        return Component.extend({\n            noShippingAddressSelectedMsg: 'No shipping address has been selected for this order, please try to refresh the page or add a new shipping address in the Address Book widget.',\n\n            /**\n             * Initialize shipping\n             */\n            initialize: function () {\n                this._super();\n                this.isNewAddressAdded(amazonStorage.isAmazonAccountLoggedIn());\n                amazonStorage.isAmazonAccountLoggedIn.subscribe(function (value) {\n                    this.isNewAddressAdded(value);\n                }, this);\n\n                return this;\n            },\n\n            /**\n             * Validate guest email\n             */\n            validateGuestEmail: function () {\n                var loginFormSelector = 'form[data-role=email-with-possible-login]';\n\n                $(loginFormSelector).validation();\n\n                return $(loginFormSelector + ' input[type=email]').valid();\n            },\n\n            /**\n             * Overridden validateShippingInformation for Amazon Pay to bypass validation\n             *\n             * @inheritDoc\n             */\n            validateShippingInformation: function () {\n                if (!amazonStorage.isAmazonAccountLoggedIn()) {\n                    return this._super();\n                }\n\n                if (!customer.isLoggedIn()) {\n                    if (!(amazonStorage.isAmazonShippingAddressSelected() && this.validateGuestEmail())) {\n                        amazonMessages.addMessage('error', this.noShippingAddressSelectedMsg);\n                        amazonMessages.displayMessages();\n\n                        return false;\n                    }\n                }\n\n                if (!(amazonStorage.isAmazonShippingAddressSelected())) {\n                    amazonMessages.addMessage('error', this.noShippingAddressSelectedMsg);\n                    amazonMessages.displayMessages();\n\n                    return false;\n                }\n\n                return true;\n            }\n        });\n    }\n);\n","Amazon_Payment/js/view/form/element/email.js":"define([\n    'jquery',\n    'Magento_Checkout/js/view/form/element/email',\n    'Magento_Customer/js/customer-data',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/checkout-data',\n    'mage/validation'\n], function ($, Component, customerData, quote, checkoutData) {\n    'use strict';\n\n    /**\n     * Get Amazon customer email\n     */\n    function getAmazonCustomerEmail() {\n        // jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n        if (window.checkoutConfig.hasOwnProperty('amazonLogin') &&\n            typeof window.checkoutConfig.amazonLogin.amazon_customer_email === 'string'\n        ) {\n            return window.checkoutConfig.amazonLogin.amazon_customer_email;\n        }\n        // jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n\n        return '';\n    }\n\n    return Component.extend({\n        defaults: {\n            email: checkoutData.getInputFieldEmailValue() || getAmazonCustomerEmail(),\n            template: 'Amazon_Payment/form/element/email'\n        },\n\n        /**\n         * Init email validator\n         */\n        initialize: function () {\n            this._super();\n\n            if (this.email()) {\n\n                if ($.validator.methods['validate-email'].call(this, this.email())) {\n                    quote.guestEmail = this.email();\n                    checkoutData.setValidatedEmailValue(this.email());\n                }\n                checkoutData.setInputFieldEmailValue(this.email());\n            }\n\n            return this;\n        }\n    });\n});\n","Amazon_Payment/js/view/shipping-address/inline-form.js":"define([\n    'uiComponent',\n    'ko',\n    'Amazon_Payment/js/model/storage'\n], function (Component, ko, amazonStorage) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Amazon_Payment/shipping-address/inline-form',\n            formSelector: 'co-shipping-form',\n            accountFormSelector: 'customer-email-fieldset'\n        },\n\n        /**\n         * Init inline form\n         */\n        initObservable: function () {\n            this._super();\n            amazonStorage.isAmazonAccountLoggedIn.subscribe(this.hideInlineForm, this);\n            return this;\n        },\n\n        /**\n         * Show/hide inline form depending on Amazon login status\n         */\n        manipulateInlineForm: function () {\n            this.hideInlineForm(amazonStorage.isAmazonAccountLoggedIn());\n        },\n\n        /**\n         * Show/hide inline form\n         */\n        hideInlineForm: function(hide) {\n            var shippingForm = document.getElementById(this.formSelector);\n            var accountForm = document.getElementById(this.accountFormSelector);\n\n            if (shippingForm) {\n                shippingForm.style.display = hide ? 'none' : 'block';\n            }\n            if (accountForm) {\n                accountForm.parentElement.style.display = hide ? 'none' : 'block';\n            }\n        }\n    });\n});\n","Amazon_Payment/js/view/shipping-address/list.js":"define([\n    'Magento_Checkout/js/view/shipping-address/list',\n    'Magento_Customer/js/model/address-list',\n    'Amazon_Payment/js/model/storage',\n    'ko'\n], function (Component, addressList, amazonStorage, ko) {\n    'use strict';\n\n    return Component.extend({\n        /**\n         * Init address list\n         */\n        initObservable: function () {\n            this._super();\n            this.visible = ko.computed(function () {\n                return addressList().length > 0 && !amazonStorage.isAmazonAccountLoggedIn();\n            });\n\n            return this;\n        }\n    });\n});\n","Amazon_Payment/js/view/payment/amazonlogin.js":"define(\n    [\n        'uiComponent',\n        'Magento_Checkout/js/model/payment/renderer-list'\n    ],\n    function (\n        Component,\n        rendererList\n    ) {\n        'use strict';\n        rendererList.push(\n            {\n                type: 'amazonlogin',\n                component: 'Amazon_Payment/js/view/payment/method-renderer/amazonlogin'\n            }\n        );\n\n    // Add view logic here if needed\n\n        return Component.extend({});\n    }\n);\n","Amazon_Payment/js/view/payment/list.js":"define([\n    'jquery',\n    'underscore',\n    'ko',\n    'Magento_Checkout/js/view/payment/list',\n    'Magento_Checkout/js/model/payment/method-list',\n    'Magento_Checkout/js/model/checkout-data-resolver',\n    'Magento_Checkout/js/model/address-converter',\n    'Magento_Checkout/js/model/quote',\n    'Amazon_Payment/js/action/populate-shipping-address',\n    'Amazon_Payment/js/model/storage'\n\n], function (\n    $,\n    _,\n    ko,\n    Component,\n    paymentMethods,\n    checkoutDataResolver,\n    addressConverter,\n    quote,\n    populateShippingAddress,\n    amazonStorage\n) {\n    'use strict';\n\n    var self;\n\n    return Component.extend({\n        /**\n         * Initialize view.\n         *\n         * @returns {Component} Chainable.\n         */\n        initialize: function () {\n\n            self = this;\n            amazonStorage.isAmazonAccountLoggedIn.subscribe(function (value) {\n                if (!value) {\n                    this._reloadPaymentMethods();\n                }\n            }, this);\n\n            this._hidePaymentMethodsOnLoad(); //hide methods on load\n\n            //subscribe to payment methods to remove other payment methods from render list\n            paymentMethods.subscribe(function (changes) {\n                checkoutDataResolver.resolvePaymentMethod();\n                //remove renderer for \"deleted\" payment methods\n                _.each(changes, function (change) {\n                    if (this._shouldRemovePaymentMethod(change.value.method)) {\n                        this.removeRenderer(change.value.method);\n                        change.status = 'deleted';\n                    }\n                }, this);\n            }, this, 'arrayChange');\n\n            this._setupDeclineHandler();\n            this._super();\n\n            return this;\n        },\n\n        /**\n         * Check if a payment method is applicable with Amazon Pay\n         * @param {String} method\n         * @returns {Boolean}\n         * @private\n         */\n        _shouldRemovePaymentMethod: function (method) {\n            return amazonStorage.isAmazonAccountLoggedIn() && method !== 'amazon_payment' && method !== 'free';\n        },\n\n        /**\n         * handle decline codes\n         * @private\n         */\n        _setupDeclineHandler: function () {\n            amazonStorage.amazonDeclineCode.subscribe(function (declined) {\n                switch (declined) {\n                    //hard decline\n                    case 4273:\n                        //populate shipping form\n                        populateShippingAddress();\n                        amazonStorage.amazonlogOut();\n                        this._reloadPaymentMethods();\n                        amazonStorage.amazonDeclineCode(false);\n                        break;\n                    //soft decline\n                    case 7638:\n                        amazonStorage.isPlaceOrderDisabled(true);\n                        this._reInitializeAmazonWalletWidget();\n                        this._hideEditableOptions();\n                        amazonStorage.amazonDeclineCode(false);\n                        break;\n                    default:\n                        amazonStorage.amazonDeclineCode(false);\n                        break;\n                }\n            }, this);\n        },\n\n        /**\n         * When payment methods exist on load hook into widget render to remove when widget has rendered\n         * @private\n         */\n        _hidePaymentMethodsOnLoad: function () {\n            if (paymentMethods().length > 0) {\n                //if the payment methods are already set\n                $(document).on('rendered', '#amazon_payment', function () {\n                    _.each(paymentMethods(), function (payment) {\n                        if (this._shouldRemovePaymentMethod(payment.method)) {\n                            this.removeRenderer(payment.method);\n                        }\n                    }, self);\n                });\n            }\n        },\n\n        /**\n         * reload payment methods on decline\n         * @private\n         */\n        _reloadPaymentMethods: function () {\n            _.each(paymentMethods(), function (paymentMethodData) {\n                if (paymentMethodData.method === 'amazon_payment' && !amazonStorage.isAmazonAccountLoggedIn()) {\n                    this.removeRenderer(paymentMethodData.method);\n                } else {\n                    this.createRenderer(paymentMethodData);\n                }\n            }, this);\n        },\n\n        /**\n         * re-intialises Amazon wallet widget\n         * @private\n         */\n        _reInitializeAmazonWalletWidget: function () {\n            var child = this.getChild('amazon_payment');\n\n            if (child) {\n                child.renderPaymentWidget();\n            }\n        },\n\n        /**\n         * hides editable content and links to prevent unexptect behaviour\n         * @private\n         */\n        _hideEditableOptions: function () {\n            $('.payment-option.discount-code', '#payment').remove();\n            $('.action-edit', '.shipping-information').remove();\n            $('.opc-progress-bar-item._complete', '.opc-progress-bar').addClass('lock-step');\n        }\n    });\n});\n","Amazon_Payment/js/view/payment/amazon-pay.js":"define([\n    'uiComponent',\n    'Magento_Checkout/js/model/payment/renderer-list'\n\n], function (\n    Component,\n    rendererList\n) {\n    'use strict';\n\n    rendererList.push(\n        {\n            type: 'amazon_payment',\n            component: 'Amazon_Payment/js/view/payment/method-renderer/amazon-payment-widget'\n        }\n    );\n\n    /** Add view logic here if needed */\n    return Component.extend({});\n});\n","Amazon_Payment/js/view/payment/method-renderer/amazonlogin.js":"define(\n    [\n        'Magento_Checkout/js/view/payment/default',\n        'Amazon_Payment/js/model/storage',\n    ],\n    function (\n        Component,\n        amazonStorage\n    ) {\n        'use strict';\n\n        return Component.extend(\n            {\n                defaults: {\n                    template: 'Amazon_Payment/payment/amazonlogin'\n                },\n                getCode: function () {\n                    return 'amazonlogin';\n                },\n                isActive: function () {\n                    return true;\n                },\n                isPwaVisible: function () {\n                    return amazonStorage.isPwaVisible && amazonStorage.isAmazonEnabled;\n                }\n            }\n        );\n    }\n);\n","Amazon_Payment/js/view/payment/method-renderer/amazon-payment-widget.js":"define(\n    [\n        'jquery',\n        'Magento_Checkout/js/view/payment/default',\n        'ko',\n        'Magento_Customer/js/model/customer',\n        'Magento_Customer/js/customer-data',\n        'Magento_Checkout/js/model/quote',\n        'Amazon_Payment/js/model/storage',\n        'amazonCore',\n        'mage/storage',\n        'Magento_Checkout/js/model/full-screen-loader',\n        'Amazon_Payment/js/action/place-order',\n        'Magento_Checkout/js/action/get-totals',\n        'Magento_Checkout/js/model/error-processor',\n        'Magento_Checkout/js/model/address-converter',\n        'Magento_Checkout/js/action/select-billing-address',\n        'Magento_Checkout/js/model/payment/additional-validators',\n        'Magento_Checkout/js/model/url-builder',\n        'amazonPaymentConfig',\n        'uiRegistry',\n        'Amazon_Payment/js/messages'\n    ],\n    function (\n        $,\n        Component,\n        ko,\n        customer,\n        customerData,\n        quote,\n        amazonStorage,\n        amazonCore,\n        storage,\n        fullScreenLoader,\n        placeOrderAction,\n        getTotalsAction,\n        errorProcessor,\n        addressConverter,\n        selectBillingAddress,\n        additionalValidators,\n        urlBuilder,\n        amazonPaymentConfig,\n        registry,\n        amazonMessages\n    ) {\n        'use strict';\n\n        var countryData = customerData.get('directory-data');\n\n        return Component.extend({\n            defaults: {\n                template: 'Amazon_Payment/payment/amazon-payment-widget',\n                paymentWidgetDOMId: 'walletWidgetDiv',\n                presentmentDOMId: 'tr.totals.charge',\n                apInputDOMId: '#amazon_payment',\n                customerEmail: '#customer-email'\n            },\n            isCustomerLoggedIn: customer.isLoggedIn,\n            isAmazonAccountLoggedIn: amazonStorage.isAmazonAccountLoggedIn,\n            isPwaVisible: amazonStorage.isPwaVisible,\n            shippingAddress: quote.shippingAddress,\n            billingAddress: quote.billingAddress,\n            isPlaceOrderDisabled: amazonStorage.isPlaceOrderDisabled,\n\n            /**\n             * Inits\n             */\n            initialize: function () {\n                this._super();\n            },\n\n            /**\n             * Init payment widget\n             */\n            initPaymentWidget: function () {\n                var $amazonPayment = $(this.apInputDOMId);\n\n                this.initDefaultValues();\n                this.renderPaymentWidget();\n                $amazonPayment.trigger('click'); //activate Amazon Pay method on render\n                $amazonPayment.trigger('rendered');\n            },\n\n            /**\n             * Init potentially asynchronous values\n             */\n            initDefaultValues: function () {\n                registry.get('amazonPayment', function (amazonPayment) {\n                    this.widgetScope = amazonPayment.loginScope;\n                    this.sellerId = amazonPayment.merchantId;\n                    this.presentmentCurrency = amazonPayment.presentmentCurrency;\n                    this.useMultiCurrency = amazonPayment.useMultiCurrency;\n                }.bind(this));\n            },\n\n            /**\n             * render Amazon Pay Widget\n             */\n            renderPaymentWidget: function () {\n                var widget = new OffAmazonPayments.Widgets.Wallet({ // eslint-disable-line no-undef\n                    sellerId: this.sellerId,\n                    scope: this.widgetScope,\n                    amazonOrderReferenceId: amazonStorage.getOrderReference(),\n\n                    /**\n                     * Payment select callback\n                     */\n                    onPaymentSelect: function () { // orderReference\n                        amazonStorage.isPlaceOrderDisabled(true);\n                        this.setBillingAddressFromAmazon();\n                    }.bind(this),\n                    design: {\n                        designMode: 'responsive'\n                    },\n\n                    /**\n                     * Error callback\n                     */\n                    onError: amazonCore.handleWidgetError\n                });\n                if (this.useMultiCurrency) {\n                    widget.setPresentmentCurrency(this.presentmentCurrency);\n                    $(this.presentmentDOMId).hide();\n                }\n                else {\n                    $(this.presentmentDOMId).show();\n                }\n                widget.bind(this.paymentWidgetDOMId);\n                amazonMessages.displayMessages();\n            },\n\n            /**\n             * Return payment code\n             */\n            getCode: function () {\n                return 'amazon_payment';\n            },\n\n            /**\n             * Is widget active?\n             */\n            isActive: function () {\n                return true;\n            },\n\n            /**\n             * Return country name\n             */\n            getCountryName: function (countryId) {\n                return countryData()[countryId] !== undefined ? countryData()[countryId].name : '';\n            },\n\n            /**\n             * Check if country name set\n             */\n            checkCountryName: function (countryId) {\n                return countryData()[countryId] !== undefined;\n            },\n\n            /**\n             * Save billing address\n             */\n            setBillingAddressFromAmazon: function () {\n                var serviceUrl = urlBuilder.createUrl('/amazon-billing-address/:amazonOrderReference', {\n                        amazonOrderReference: amazonStorage.getOrderReference()\n                    }),\n                    payload = {\n                        addressConsentToken: amazonStorage.getAddressConsentToken()\n                    };\n\n                fullScreenLoader.startLoader();\n\n                storage.put(\n                    serviceUrl,\n                    JSON.stringify(payload)\n                ).done(\n                    function (data) {\n                        var amazonAddress = data.shift(), addressData;\n\n                        addressData = addressConverter.formAddressDataToQuoteAddress(amazonAddress);\n                        addressData.telephone = !addressData.telephone ? '0000000000' : addressData.telephone;\n\n                        selectBillingAddress(addressData);\n                        amazonStorage.isPlaceOrderDisabled(false);\n\n                        if (window.checkoutConfig.amazonLogin.amazon_customer_email) {\n                            var customerField = $(this.customerEmail).val();\n\n                            if (!customerField) {\n                                $(this.customerEmail).val(window.checkoutConfig.amazonLogin.amazon_customer_email);\n                            }\n                        }\n                    }\n                ).fail(\n                    function (response) {\n                        errorProcessor.process(response);\n                    }\n                ).always(\n                    function () {\n                        fullScreenLoader.stopLoader();\n                    }\n                );\n            },\n\n            /**\n             * Return Magento billing object\n             */\n            getData: function () {\n                return {\n                    'method': this.item.method,\n                    'additional_data': {\n                        'sandbox_simulation_reference': amazonStorage.sandboxSimulationReference()\n                    }\n                };\n            },\n\n            /**\n             * Save order\n             */\n            placeOrder: function (data, event) {\n                var placeOrder;\n\n                if (event) {\n                    event.preventDefault();\n                }\n\n                if (this.validate() && additionalValidators.validate()) {\n                    this.isPlaceOrderActionAllowed(false);\n                    placeOrder = placeOrderAction(this.getData(), this.redirectAfterPlaceOrder);\n\n                    $.when(placeOrder).fail(function () {\n                        this.isPlaceOrderActionAllowed(true);\n                    }.bind(this)).done(this.afterPlaceOrder.bind(this));\n\n                    return true;\n                }\n\n                return false;\n            }\n        });\n    }\n);\n","Amazon_Payment/js/view/checkout/summary/grand-total-mixin.js":"/*global define*/\n\ndefine([\n    'Amazon_Payment/js/model/storage'\n], function (amazonStorage) {\n    'use strict';\n\n    return function (GrandTotal) {\n        return GrandTotal.extend({\n            /**\n             * @return {Boolean}\n             */\n            isBaseGrandTotalDisplayNeeded: function () {\n                if (!amazonStorage.isAmazonAccountLoggedIn()) {\n                    return this._super();\n                }\n\n                return false;\n            }\n        });\n    }\n});\n","Amazon_Payment/js/lib/sjcl.min.js":"// jscs:disable\n\"use strict\";var sjcl={cipher:{},hash:{},keyexchange:{},mode:{},misc:{},codec:{},exception:{corrupt:function(a){this.toString=function(){return\"CORRUPT: \"+this.message};this.message=a},invalid:function(a){this.toString=function(){return\"INVALID: \"+this.message};this.message=a},bug:function(a){this.toString=function(){return\"BUG: \"+this.message};this.message=a},notReady:function(a){this.toString=function(){return\"NOT READY: \"+this.message};this.message=a}}};\n\"undefined\"!==typeof module&&module.exports&&(module.exports=sjcl);\"function\"===typeof define&&define([],function(){return sjcl});\nsjcl.cipher.aes=function(a){this.s[0][0][0]||this.O();var b,c,d,e,g=this.s[0][4],f=this.s[1];b=a.length;var h=1;if(4!==b&&6!==b&&8!==b)throw new sjcl.exception.invalid(\"invalid aes key size\");this.b=[d=a.slice(0),e=[]];for(a=b;a<4*b+28;a++){c=d[a-1];if(0===a%b||8===b&&4===a%b)c=g[c>>>24]<<24^g[c>>16&255]<<16^g[c>>8&255]<<8^g[c&255],0===a%b&&(c=c<<8^c>>>24^h<<24,h=h<<1^283*(h>>7));d[a]=d[a-b]^c}for(b=0;a;b++,a--)c=d[b&3?a:a-4],e[b]=4>=a||4>b?c:f[0][g[c>>>24]]^f[1][g[c>>16&255]]^f[2][g[c>>8&255]]^f[3][g[c&\n255]]};\nsjcl.cipher.aes.prototype={encrypt:function(a){return u(this,a,0)},decrypt:function(a){return u(this,a,1)},s:[[[],[],[],[],[]],[[],[],[],[],[]]],O:function(){var a=this.s[0],b=this.s[1],c=a[4],d=b[4],e,g,f,h=[],l=[],k,m,n,p;for(e=0;0x100>e;e++)l[(h[e]=e<<1^283*(e>>7))^e]=e;for(g=f=0;!c[g];g^=k||1,f=l[f]||1)for(n=f^f<<1^f<<2^f<<3^f<<4,n=n>>8^n&255^99,c[g]=n,d[n]=g,m=h[e=h[k=h[g]]],p=0x1010101*m^0x10001*e^0x101*k^0x1010100*g,m=0x101*h[n]^0x1010100*n,e=0;4>e;e++)a[e][g]=m=m<<24^m>>>8,b[e][n]=p=p<<24^p>>>8;for(e=\n0;5>e;e++)a[e]=a[e].slice(0),b[e]=b[e].slice(0)}};\nfunction u(a,b,c){if(4!==b.length)throw new sjcl.exception.invalid(\"invalid aes block size\");var d=a.b[c],e=b[0]^d[0],g=b[c?3:1]^d[1],f=b[2]^d[2];b=b[c?1:3]^d[3];var h,l,k,m=d.length/4-2,n,p=4,r=[0,0,0,0];h=a.s[c];a=h[0];var q=h[1],t=h[2],w=h[3],x=h[4];for(n=0;n<m;n++)h=a[e>>>24]^q[g>>16&255]^t[f>>8&255]^w[b&255]^d[p],l=a[g>>>24]^q[f>>16&255]^t[b>>8&255]^w[e&255]^d[p+1],k=a[f>>>24]^q[b>>16&255]^t[e>>8&255]^w[g&255]^d[p+2],b=a[b>>>24]^q[e>>16&255]^t[g>>8&255]^w[f&255]^d[p+3],p+=4,e=h,g=l,f=k;for(n=\n0;4>n;n++)r[c?3&-n:n]=x[e>>>24]<<24^x[g>>16&255]<<16^x[f>>8&255]<<8^x[b&255]^d[p++],h=e,e=g,g=f,f=b,b=h;return r}\nsjcl.bitArray={bitSlice:function(a,b,c){a=sjcl.bitArray.$(a.slice(b/32),32-(b&31)).slice(1);return void 0===c?a:sjcl.bitArray.clamp(a,c-b)},extract:function(a,b,c){var d=Math.floor(-b-c&31);return((b+c-1^b)&-32?a[b/32|0]<<32-d^a[b/32+1|0]>>>d:a[b/32|0]>>>d)&(1<<c)-1},concat:function(a,b){if(0===a.length||0===b.length)return a.concat(b);var c=a[a.length-1],d=sjcl.bitArray.getPartial(c);return 32===d?a.concat(b):sjcl.bitArray.$(b,d,c|0,a.slice(0,a.length-1))},bitLength:function(a){var b=a.length;return 0===\nb?0:32*(b-1)+sjcl.bitArray.getPartial(a[b-1])},clamp:function(a,b){if(32*a.length<b)return a;a=a.slice(0,Math.ceil(b/32));var c=a.length;b=b&31;0<c&&b&&(a[c-1]=sjcl.bitArray.partial(b,a[c-1]&2147483648>>b-1,1));return a},partial:function(a,b,c){return 32===a?b:(c?b|0:b<<32-a)+0x10000000000*a},getPartial:function(a){return Math.round(a/0x10000000000)||32},equal:function(a,b){if(sjcl.bitArray.bitLength(a)!==sjcl.bitArray.bitLength(b))return!1;var c=0,d;for(d=0;d<a.length;d++)c|=a[d]^b[d];return 0===\nc},$:function(a,b,c,d){var e;e=0;for(void 0===d&&(d=[]);32<=b;b-=32)d.push(c),c=0;if(0===b)return d.concat(a);for(e=0;e<a.length;e++)d.push(c|a[e]>>>b),c=a[e]<<32-b;e=a.length?a[a.length-1]:0;a=sjcl.bitArray.getPartial(e);d.push(sjcl.bitArray.partial(b+a&31,32<b+a?c:d.pop(),1));return d},i:function(a,b){return[a[0]^b[0],a[1]^b[1],a[2]^b[2],a[3]^b[3]]},byteswapM:function(a){var b,c;for(b=0;b<a.length;++b)c=a[b],a[b]=c>>>24|c>>>8&0xff00|(c&0xff00)<<8|c<<24;return a}};\nsjcl.codec.utf8String={fromBits:function(a){var b=\"\",c=sjcl.bitArray.bitLength(a),d,e;for(d=0;d<c/8;d++)0===(d&3)&&(e=a[d/4]),b+=String.fromCharCode(e>>>24),e<<=8;return decodeURIComponent(escape(b))},toBits:function(a){a=unescape(encodeURIComponent(a));var b=[],c,d=0;for(c=0;c<a.length;c++)d=d<<8|a.charCodeAt(c),3===(c&3)&&(b.push(d),d=0);c&3&&b.push(sjcl.bitArray.partial(8*(c&3),d));return b}};\nsjcl.codec.hex={fromBits:function(a){var b=\"\",c;for(c=0;c<a.length;c++)b+=((a[c]|0)+0xf00000000000).toString(16).substr(4);return b.substr(0,sjcl.bitArray.bitLength(a)/4)},toBits:function(a){var b,c=[],d;a=a.replace(/\\s|0x/g,\"\");d=a.length;a=a+\"00000000\";for(b=0;b<a.length;b+=8)c.push(parseInt(a.substr(b,8),16)^0);return sjcl.bitArray.clamp(c,4*d)}};\nsjcl.codec.base32={B:\"ABCDEFGHIJKLMNOPQRSTUVWXYZ234567\",X:\"0123456789ABCDEFGHIJKLMNOPQRSTUV\",BITS:32,BASE:5,REMAINING:27,fromBits:function(a,b,c){var d=sjcl.codec.base32.BASE,e=sjcl.codec.base32.REMAINING,g=\"\",f=0,h=sjcl.codec.base32.B,l=0,k=sjcl.bitArray.bitLength(a);c&&(h=sjcl.codec.base32.X);for(c=0;g.length*d<k;)g+=h.charAt((l^a[c]>>>f)>>>e),f<d?(l=a[c]<<d-f,f+=e,c++):(l<<=d,f-=d);for(;g.length&7&&!b;)g+=\"=\";return g},toBits:function(a,b){a=a.replace(/\\s|=/g,\"\").toUpperCase();var c=sjcl.codec.base32.BITS,\nd=sjcl.codec.base32.BASE,e=sjcl.codec.base32.REMAINING,g=[],f,h=0,l=sjcl.codec.base32.B,k=0,m,n=\"base32\";b&&(l=sjcl.codec.base32.X,n=\"base32hex\");for(f=0;f<a.length;f++){m=l.indexOf(a.charAt(f));if(0>m){if(!b)try{return sjcl.codec.base32hex.toBits(a)}catch(p){}throw new sjcl.exception.invalid(\"this isn't \"+n+\"!\");}h>e?(h-=e,g.push(k^m>>>h),k=m<<c-h):(h+=d,k^=m<<c-h)}h&56&&g.push(sjcl.bitArray.partial(h&56,k,1));return g}};\nsjcl.codec.base32hex={fromBits:function(a,b){return sjcl.codec.base32.fromBits(a,b,1)},toBits:function(a){return sjcl.codec.base32.toBits(a,1)}};\nsjcl.codec.base64={B:\"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/\",fromBits:function(a,b,c){var d=\"\",e=0,g=sjcl.codec.base64.B,f=0,h=sjcl.bitArray.bitLength(a);c&&(g=g.substr(0,62)+\"-_\");for(c=0;6*d.length<h;)d+=g.charAt((f^a[c]>>>e)>>>26),6>e?(f=a[c]<<6-e,e+=26,c++):(f<<=6,e-=6);for(;d.length&3&&!b;)d+=\"=\";return d},toBits:function(a,b){a=a.replace(/\\s|=/g,\"\");var c=[],d,e=0,g=sjcl.codec.base64.B,f=0,h;b&&(g=g.substr(0,62)+\"-_\");for(d=0;d<a.length;d++){h=g.indexOf(a.charAt(d));\nif(0>h)throw new sjcl.exception.invalid(\"this isn't base64!\");26<e?(e-=26,c.push(f^h>>>e),f=h<<32-e):(e+=6,f^=h<<32-e)}e&56&&c.push(sjcl.bitArray.partial(e&56,f,1));return c}};sjcl.codec.base64url={fromBits:function(a){return sjcl.codec.base64.fromBits(a,1,1)},toBits:function(a){return sjcl.codec.base64.toBits(a,1)}};sjcl.hash.sha256=function(a){this.b[0]||this.O();a?(this.F=a.F.slice(0),this.A=a.A.slice(0),this.l=a.l):this.reset()};sjcl.hash.sha256.hash=function(a){return(new sjcl.hash.sha256).update(a).finalize()};\nsjcl.hash.sha256.prototype={blockSize:512,reset:function(){this.F=this.Y.slice(0);this.A=[];this.l=0;return this},update:function(a){\"string\"===typeof a&&(a=sjcl.codec.utf8String.toBits(a));var b,c=this.A=sjcl.bitArray.concat(this.A,a);b=this.l;a=this.l=b+sjcl.bitArray.bitLength(a);for(b=512+b&-512;b<=a;b+=512)v(this,c.splice(0,16));return this},finalize:function(){var a,b=this.A,c=this.F,b=sjcl.bitArray.concat(b,[sjcl.bitArray.partial(1,1)]);for(a=b.length+2;a&15;a++)b.push(0);b.push(Math.floor(this.l/\n4294967296));for(b.push(this.l|0);b.length;)v(this,b.splice(0,16));this.reset();return c},Y:[],b:[],O:function(){function a(a){return 0x100000000*(a-Math.floor(a))|0}var b=0,c=2,d;a:for(;64>b;c++){for(d=2;d*d<=c;d++)if(0===c%d)continue a;8>b&&(this.Y[b]=a(Math.pow(c,.5)));this.b[b]=a(Math.pow(c,1/3));b++}}};\nfunction v(a,b){var c,d,e,g=b.slice(0),f=a.F,h=a.b,l=f[0],k=f[1],m=f[2],n=f[3],p=f[4],r=f[5],q=f[6],t=f[7];for(c=0;64>c;c++)16>c?d=g[c]:(d=g[c+1&15],e=g[c+14&15],d=g[c&15]=(d>>>7^d>>>18^d>>>3^d<<25^d<<14)+(e>>>17^e>>>19^e>>>10^e<<15^e<<13)+g[c&15]+g[c+9&15]|0),d=d+t+(p>>>6^p>>>11^p>>>25^p<<26^p<<21^p<<7)+(q^p&(r^q))+h[c],t=q,q=r,r=p,p=n+d|0,n=m,m=k,k=l,l=d+(k&m^n&(k^m))+(k>>>2^k>>>13^k>>>22^k<<30^k<<19^k<<10)|0;f[0]=f[0]+l|0;f[1]=f[1]+k|0;f[2]=f[2]+m|0;f[3]=f[3]+n|0;f[4]=f[4]+p|0;f[5]=f[5]+r|0;f[6]=\nf[6]+q|0;f[7]=f[7]+t|0}\nsjcl.mode.ccm={name:\"ccm\",G:[],listenProgress:function(a){sjcl.mode.ccm.G.push(a)},unListenProgress:function(a){a=sjcl.mode.ccm.G.indexOf(a);-1<a&&sjcl.mode.ccm.G.splice(a,1)},fa:function(a){var b=sjcl.mode.ccm.G.slice(),c;for(c=0;c<b.length;c+=1)b[c](a)},encrypt:function(a,b,c,d,e){var g,f=b.slice(0),h=sjcl.bitArray,l=h.bitLength(c)/8,k=h.bitLength(f)/8;e=e||64;d=d||[];if(7>l)throw new sjcl.exception.invalid(\"ccm: iv must be at least 7 bytes\");for(g=2;4>g&&k>>>8*g;g++);g<15-l&&(g=15-l);c=h.clamp(c,\n8*(15-g));b=sjcl.mode.ccm.V(a,b,c,d,e,g);f=sjcl.mode.ccm.C(a,f,c,b,e,g);return h.concat(f.data,f.tag)},decrypt:function(a,b,c,d,e){e=e||64;d=d||[];var g=sjcl.bitArray,f=g.bitLength(c)/8,h=g.bitLength(b),l=g.clamp(b,h-e),k=g.bitSlice(b,h-e),h=(h-e)/8;if(7>f)throw new sjcl.exception.invalid(\"ccm: iv must be at least 7 bytes\");for(b=2;4>b&&h>>>8*b;b++);b<15-f&&(b=15-f);c=g.clamp(c,8*(15-b));l=sjcl.mode.ccm.C(a,l,c,k,e,b);a=sjcl.mode.ccm.V(a,l.data,c,d,e,b);if(!g.equal(l.tag,a))throw new sjcl.exception.corrupt(\"ccm: tag doesn't match\");\nreturn l.data},na:function(a,b,c,d,e,g){var f=[],h=sjcl.bitArray,l=h.i;d=[h.partial(8,(b.length?64:0)|d-2<<2|g-1)];d=h.concat(d,c);d[3]|=e;d=a.encrypt(d);if(b.length)for(c=h.bitLength(b)/8,65279>=c?f=[h.partial(16,c)]:0xffffffff>=c&&(f=h.concat([h.partial(16,65534)],[c])),f=h.concat(f,b),b=0;b<f.length;b+=4)d=a.encrypt(l(d,f.slice(b,b+4).concat([0,0,0])));return d},V:function(a,b,c,d,e,g){var f=sjcl.bitArray,h=f.i;e/=8;if(e%2||4>e||16<e)throw new sjcl.exception.invalid(\"ccm: invalid tag length\");\nif(0xffffffff<d.length||0xffffffff<b.length)throw new sjcl.exception.bug(\"ccm: can't deal with 4GiB or more data\");c=sjcl.mode.ccm.na(a,d,c,e,f.bitLength(b)/8,g);for(d=0;d<b.length;d+=4)c=a.encrypt(h(c,b.slice(d,d+4).concat([0,0,0])));return f.clamp(c,8*e)},C:function(a,b,c,d,e,g){var f,h=sjcl.bitArray;f=h.i;var l=b.length,k=h.bitLength(b),m=l/50,n=m;c=h.concat([h.partial(8,g-1)],c).concat([0,0,0]).slice(0,4);d=h.bitSlice(f(d,a.encrypt(c)),0,e);if(!l)return{tag:d,data:[]};for(f=0;f<l;f+=4)f>m&&(sjcl.mode.ccm.fa(f/\nl),m+=n),c[3]++,e=a.encrypt(c),b[f]^=e[0],b[f+1]^=e[1],b[f+2]^=e[2],b[f+3]^=e[3];return{tag:d,data:h.clamp(b,k)}}};\nsjcl.mode.ocb2={name:\"ocb2\",encrypt:function(a,b,c,d,e,g){if(128!==sjcl.bitArray.bitLength(c))throw new sjcl.exception.invalid(\"ocb iv must be 128 bits\");var f,h=sjcl.mode.ocb2.S,l=sjcl.bitArray,k=l.i,m=[0,0,0,0];c=h(a.encrypt(c));var n,p=[];d=d||[];e=e||64;for(f=0;f+4<b.length;f+=4)n=b.slice(f,f+4),m=k(m,n),p=p.concat(k(c,a.encrypt(k(c,n)))),c=h(c);n=b.slice(f);b=l.bitLength(n);f=a.encrypt(k(c,[0,0,0,b]));n=l.clamp(k(n.concat([0,0,0]),f),b);m=k(m,k(n.concat([0,0,0]),f));m=a.encrypt(k(m,k(c,h(c))));\nd.length&&(m=k(m,g?d:sjcl.mode.ocb2.pmac(a,d)));return p.concat(l.concat(n,l.clamp(m,e)))},decrypt:function(a,b,c,d,e,g){if(128!==sjcl.bitArray.bitLength(c))throw new sjcl.exception.invalid(\"ocb iv must be 128 bits\");e=e||64;var f=sjcl.mode.ocb2.S,h=sjcl.bitArray,l=h.i,k=[0,0,0,0],m=f(a.encrypt(c)),n,p,r=sjcl.bitArray.bitLength(b)-e,q=[];d=d||[];for(c=0;c+4<r/32;c+=4)n=l(m,a.decrypt(l(m,b.slice(c,c+4)))),k=l(k,n),q=q.concat(n),m=f(m);p=r-32*c;n=a.encrypt(l(m,[0,0,0,p]));n=l(n,h.clamp(b.slice(c),p).concat([0,\n0,0]));k=l(k,n);k=a.encrypt(l(k,l(m,f(m))));d.length&&(k=l(k,g?d:sjcl.mode.ocb2.pmac(a,d)));if(!h.equal(h.clamp(k,e),h.bitSlice(b,r)))throw new sjcl.exception.corrupt(\"ocb: tag doesn't match\");return q.concat(h.clamp(n,p))},pmac:function(a,b){var c,d=sjcl.mode.ocb2.S,e=sjcl.bitArray,g=e.i,f=[0,0,0,0],h=a.encrypt([0,0,0,0]),h=g(h,d(d(h)));for(c=0;c+4<b.length;c+=4)h=d(h),f=g(f,a.encrypt(g(h,b.slice(c,c+4))));c=b.slice(c);128>e.bitLength(c)&&(h=g(h,d(h)),c=e.concat(c,[-2147483648,0,0,0]));f=g(f,c);\nreturn a.encrypt(g(d(g(h,d(h))),f))},S:function(a){return[a[0]<<1^a[1]>>>31,a[1]<<1^a[2]>>>31,a[2]<<1^a[3]>>>31,a[3]<<1^135*(a[0]>>>31)]}};\nsjcl.mode.gcm={name:\"gcm\",encrypt:function(a,b,c,d,e){var g=b.slice(0);b=sjcl.bitArray;d=d||[];a=sjcl.mode.gcm.C(!0,a,g,d,c,e||128);return b.concat(a.data,a.tag)},decrypt:function(a,b,c,d,e){var g=b.slice(0),f=sjcl.bitArray,h=f.bitLength(g);e=e||128;d=d||[];e<=h?(b=f.bitSlice(g,h-e),g=f.bitSlice(g,0,h-e)):(b=g,g=[]);a=sjcl.mode.gcm.C(!1,a,g,d,c,e);if(!f.equal(a.tag,b))throw new sjcl.exception.corrupt(\"gcm: tag doesn't match\");return a.data},ka:function(a,b){var c,d,e,g,f,h=sjcl.bitArray.i;e=[0,0,\n0,0];g=b.slice(0);for(c=0;128>c;c++){(d=0!==(a[Math.floor(c/32)]&1<<31-c%32))&&(e=h(e,g));f=0!==(g[3]&1);for(d=3;0<d;d--)g[d]=g[d]>>>1|(g[d-1]&1)<<31;g[0]>>>=1;f&&(g[0]^=-0x1f000000)}return e},j:function(a,b,c){var d,e=c.length;b=b.slice(0);for(d=0;d<e;d+=4)b[0]^=0xffffffff&c[d],b[1]^=0xffffffff&c[d+1],b[2]^=0xffffffff&c[d+2],b[3]^=0xffffffff&c[d+3],b=sjcl.mode.gcm.ka(b,a);return b},C:function(a,b,c,d,e,g){var f,h,l,k,m,n,p,r,q=sjcl.bitArray;n=c.length;p=q.bitLength(c);r=q.bitLength(d);h=q.bitLength(e);\nf=b.encrypt([0,0,0,0]);96===h?(e=e.slice(0),e=q.concat(e,[1])):(e=sjcl.mode.gcm.j(f,[0,0,0,0],e),e=sjcl.mode.gcm.j(f,e,[0,0,Math.floor(h/0x100000000),h&0xffffffff]));h=sjcl.mode.gcm.j(f,[0,0,0,0],d);m=e.slice(0);d=h.slice(0);a||(d=sjcl.mode.gcm.j(f,h,c));for(k=0;k<n;k+=4)m[3]++,l=b.encrypt(m),c[k]^=l[0],c[k+1]^=l[1],c[k+2]^=l[2],c[k+3]^=l[3];c=q.clamp(c,p);a&&(d=sjcl.mode.gcm.j(f,h,c));a=[Math.floor(r/0x100000000),r&0xffffffff,Math.floor(p/0x100000000),p&0xffffffff];d=sjcl.mode.gcm.j(f,d,a);l=b.encrypt(e);\nd[0]^=l[0];d[1]^=l[1];d[2]^=l[2];d[3]^=l[3];return{tag:q.bitSlice(d,0,g),data:c}}};sjcl.misc.hmac=function(a,b){this.W=b=b||sjcl.hash.sha256;var c=[[],[]],d,e=b.prototype.blockSize/32;this.w=[new b,new b];a.length>e&&(a=b.hash(a));for(d=0;d<e;d++)c[0][d]=a[d]^909522486,c[1][d]=a[d]^1549556828;this.w[0].update(c[0]);this.w[1].update(c[1]);this.R=new b(this.w[0])};\nsjcl.misc.hmac.prototype.encrypt=sjcl.misc.hmac.prototype.mac=function(a){if(this.aa)throw new sjcl.exception.invalid(\"encrypt on already updated hmac called!\");this.update(a);return this.digest(a)};sjcl.misc.hmac.prototype.reset=function(){this.R=new this.W(this.w[0]);this.aa=!1};sjcl.misc.hmac.prototype.update=function(a){this.aa=!0;this.R.update(a)};sjcl.misc.hmac.prototype.digest=function(){var a=this.R.finalize(),a=(new this.W(this.w[1])).update(a).finalize();this.reset();return a};\nsjcl.misc.pbkdf2=function(a,b,c,d,e){c=c||1E3;if(0>d||0>c)throw sjcl.exception.invalid(\"invalid params to pbkdf2\");\"string\"===typeof a&&(a=sjcl.codec.utf8String.toBits(a));\"string\"===typeof b&&(b=sjcl.codec.utf8String.toBits(b));e=e||sjcl.misc.hmac;a=new e(a);var g,f,h,l,k=[],m=sjcl.bitArray;for(l=1;32*k.length<(d||1);l++){e=g=a.encrypt(m.concat(b,[l]));for(f=1;f<c;f++)for(g=a.encrypt(g),h=0;h<g.length;h++)e[h]^=g[h];k=k.concat(e)}d&&(k=m.clamp(k,d));return k};\nsjcl.prng=function(a){this.c=[new sjcl.hash.sha256];this.m=[0];this.P=0;this.H={};this.N=0;this.U={};this.Z=this.f=this.o=this.ha=0;this.b=[0,0,0,0,0,0,0,0];this.h=[0,0,0,0];this.L=void 0;this.M=a;this.D=!1;this.K={progress:{},seeded:{}};this.u=this.ga=0;this.I=1;this.J=2;this.ca=0x10000;this.T=[0,48,64,96,128,192,0x100,384,512,768,1024];this.da=3E4;this.ba=80};\nsjcl.prng.prototype={randomWords:function(a,b){var c=[],d;d=this.isReady(b);var e;if(d===this.u)throw new sjcl.exception.notReady(\"generator isn't seeded\");if(d&this.J){d=!(d&this.I);e=[];var g=0,f;this.Z=e[0]=(new Date).valueOf()+this.da;for(f=0;16>f;f++)e.push(0x100000000*Math.random()|0);for(f=0;f<this.c.length&&(e=e.concat(this.c[f].finalize()),g+=this.m[f],this.m[f]=0,d||!(this.P&1<<f));f++);this.P>=1<<this.c.length&&(this.c.push(new sjcl.hash.sha256),this.m.push(0));this.f-=g;g>this.o&&(this.o=\ng);this.P++;this.b=sjcl.hash.sha256.hash(this.b.concat(e));this.L=new sjcl.cipher.aes(this.b);for(d=0;4>d&&(this.h[d]=this.h[d]+1|0,!this.h[d]);d++);}for(d=0;d<a;d+=4)0===(d+1)%this.ca&&y(this),e=z(this),c.push(e[0],e[1],e[2],e[3]);y(this);return c.slice(0,a)},setDefaultParanoia:function(a,b){if(0===a&&\"Setting paranoia=0 will ruin your security; use it only for testing\"!==b)throw\"Setting paranoia=0 will ruin your security; use it only for testing\";this.M=a},addEntropy:function(a,b,c){c=c||\"user\";\nvar d,e,g=(new Date).valueOf(),f=this.H[c],h=this.isReady(),l=0;d=this.U[c];void 0===d&&(d=this.U[c]=this.ha++);void 0===f&&(f=this.H[c]=0);this.H[c]=(this.H[c]+1)%this.c.length;switch(typeof a){case \"number\":void 0===b&&(b=1);this.c[f].update([d,this.N++,1,b,g,1,a|0]);break;case \"object\":c=Object.prototype.toString.call(a);if(\"[object Uint32Array]\"===c){e=[];for(c=0;c<a.length;c++)e.push(a[c]);a=e}else for(\"[object Array]\"!==c&&(l=1),c=0;c<a.length&&!l;c++)\"number\"!==typeof a[c]&&(l=1);if(!l){if(void 0===\nb)for(c=b=0;c<a.length;c++)for(e=a[c];0<e;)b++,e=e>>>1;this.c[f].update([d,this.N++,2,b,g,a.length].concat(a))}break;case \"string\":void 0===b&&(b=a.length);this.c[f].update([d,this.N++,3,b,g,a.length]);this.c[f].update(a);break;default:l=1}if(l)throw new sjcl.exception.bug(\"random: addEntropy only supports number, array of numbers or string\");this.m[f]+=b;this.f+=b;h===this.u&&(this.isReady()!==this.u&&A(\"seeded\",Math.max(this.o,this.f)),A(\"progress\",this.getProgress()))},isReady:function(a){a=this.T[void 0!==\na?a:this.M];return this.o&&this.o>=a?this.m[0]>this.ba&&(new Date).valueOf()>this.Z?this.J|this.I:this.I:this.f>=a?this.J|this.u:this.u},getProgress:function(a){a=this.T[a?a:this.M];return this.o>=a?1:this.f>a?1:this.f/a},startCollectors:function(){if(!this.D){this.a={loadTimeCollector:B(this,this.ma),mouseCollector:B(this,this.oa),keyboardCollector:B(this,this.la),accelerometerCollector:B(this,this.ea),touchCollector:B(this,this.qa)};if(window.addEventListener)window.addEventListener(\"load\",this.a.loadTimeCollector,\n!1),window.addEventListener(\"mousemove\",this.a.mouseCollector,!1),window.addEventListener(\"keypress\",this.a.keyboardCollector,!1),window.addEventListener(\"devicemotion\",this.a.accelerometerCollector,!1),window.addEventListener(\"touchmove\",this.a.touchCollector,!1);else if(document.attachEvent)document.attachEvent(\"onload\",this.a.loadTimeCollector),document.attachEvent(\"onmousemove\",this.a.mouseCollector),document.attachEvent(\"keypress\",this.a.keyboardCollector);else throw new sjcl.exception.bug(\"can't attach event\");\nthis.D=!0}},stopCollectors:function(){this.D&&(window.removeEventListener?(window.removeEventListener(\"load\",this.a.loadTimeCollector,!1),window.removeEventListener(\"mousemove\",this.a.mouseCollector,!1),window.removeEventListener(\"keypress\",this.a.keyboardCollector,!1),window.removeEventListener(\"devicemotion\",this.a.accelerometerCollector,!1),window.removeEventListener(\"touchmove\",this.a.touchCollector,!1)):document.detachEvent&&(document.detachEvent(\"onload\",this.a.loadTimeCollector),document.detachEvent(\"onmousemove\",\nthis.a.mouseCollector),document.detachEvent(\"keypress\",this.a.keyboardCollector)),this.D=!1)},addEventListener:function(a,b){this.K[a][this.ga++]=b},removeEventListener:function(a,b){var c,d,e=this.K[a],g=[];for(d in e)e.hasOwnProperty(d)&&e[d]===b&&g.push(d);for(c=0;c<g.length;c++)d=g[c],delete e[d]},la:function(){C(1)},oa:function(a){var b,c;try{b=a.x||a.clientX||a.offsetX||0,c=a.y||a.clientY||a.offsetY||0}catch(d){c=b=0}0!=b&&0!=c&&sjcl.random.addEntropy([b,c],2,\"mouse\");C(0)},qa:function(a){a=\na.touches[0]||a.changedTouches[0];sjcl.random.addEntropy([a.pageX||a.clientX,a.pageY||a.clientY],1,\"touch\");C(0)},ma:function(){C(2)},ea:function(a){a=a.accelerationIncludingGravity.x||a.accelerationIncludingGravity.y||a.accelerationIncludingGravity.z;if(window.orientation){var b=window.orientation;\"number\"===typeof b&&sjcl.random.addEntropy(b,1,\"accelerometer\")}a&&sjcl.random.addEntropy(a,2,\"accelerometer\");C(0)}};\nfunction A(a,b){var c,d=sjcl.random.K[a],e=[];for(c in d)d.hasOwnProperty(c)&&e.push(d[c]);for(c=0;c<e.length;c++)e[c](b)}function C(a){\"undefined\"!==typeof window&&window.performance&&\"function\"===typeof window.performance.now?sjcl.random.addEntropy(window.performance.now(),a,\"loadtime\"):sjcl.random.addEntropy((new Date).valueOf(),a,\"loadtime\")}function y(a){a.b=z(a).concat(z(a));a.L=new sjcl.cipher.aes(a.b)}\nfunction z(a){for(var b=0;4>b&&(a.h[b]=a.h[b]+1|0,!a.h[b]);b++);return a.L.encrypt(a.h)}function B(a,b){return function(){b.apply(a,arguments)}}sjcl.random=new sjcl.prng(6);\na:try{var D,E,F,G;if(G=\"undefined\"!==typeof module&&module.exports){var H;try{H=require(\"crypto\")}catch(a){H=null}G=E=H}if(G&&E.randomBytes)D=E.randomBytes(128),D=new Uint32Array((new Uint8Array(D)).buffer),sjcl.random.addEntropy(D,1024,\"crypto['randomBytes']\");else if(\"undefined\"!==typeof window&&\"undefined\"!==typeof Uint32Array){F=new Uint32Array(32);if(window.crypto&&window.crypto.getRandomValues)window.crypto.getRandomValues(F);else if(window.msCrypto&&window.msCrypto.getRandomValues)window.msCrypto.getRandomValues(F);\nelse break a;sjcl.random.addEntropy(F,1024,\"crypto['getRandomValues']\")}}catch(a){\"undefined\"!==typeof window&&window.console&&(console.log(\"There was an error collecting entropy from the browser:\"),console.log(a))}\nsjcl.json={defaults:{v:1,iter:1E3,ks:128,ts:64,mode:\"ccm\",adata:\"\",cipher:\"aes\"},ja:function(a,b,c,d){c=c||{};d=d||{};var e=sjcl.json,g=e.g({iv:sjcl.random.randomWords(4,0)},e.defaults),f;e.g(g,c);c=g.adata;\"string\"===typeof g.salt&&(g.salt=sjcl.codec.base64.toBits(g.salt));\"string\"===typeof g.iv&&(g.iv=sjcl.codec.base64.toBits(g.iv));if(!sjcl.mode[g.mode]||!sjcl.cipher[g.cipher]||\"string\"===typeof a&&100>=g.iter||64!==g.ts&&96!==g.ts&&128!==g.ts||128!==g.ks&&192!==g.ks&&0x100!==g.ks||2>g.iv.length||\n4<g.iv.length)throw new sjcl.exception.invalid(\"json encrypt: invalid parameters\");\"string\"===typeof a?(f=sjcl.misc.cachedPbkdf2(a,g),a=f.key.slice(0,g.ks/32),g.salt=f.salt):sjcl.ecc&&a instanceof sjcl.ecc.elGamal.publicKey&&(f=a.kem(),g.kemtag=f.tag,a=f.key.slice(0,g.ks/32));\"string\"===typeof b&&(b=sjcl.codec.utf8String.toBits(b));\"string\"===typeof c&&(g.adata=c=sjcl.codec.utf8String.toBits(c));f=new sjcl.cipher[g.cipher](a);e.g(d,g);d.key=a;g.ct=\"ccm\"===g.mode&&sjcl.arrayBuffer&&sjcl.arrayBuffer.ccm&&\nb instanceof ArrayBuffer?sjcl.arrayBuffer.ccm.encrypt(f,b,g.iv,c,g.ts):sjcl.mode[g.mode].encrypt(f,b,g.iv,c,g.ts);return g},encrypt:function(a,b,c,d){var e=sjcl.json,g=e.ja.apply(e,arguments);return e.encode(g)},ia:function(a,b,c,d){c=c||{};d=d||{};var e=sjcl.json;b=e.g(e.g(e.g({},e.defaults),b),c,!0);var g,f;g=b.adata;\"string\"===typeof b.salt&&(b.salt=sjcl.codec.base64.toBits(b.salt));\"string\"===typeof b.iv&&(b.iv=sjcl.codec.base64.toBits(b.iv));if(!sjcl.mode[b.mode]||!sjcl.cipher[b.cipher]||\"string\"===\ntypeof a&&100>=b.iter||64!==b.ts&&96!==b.ts&&128!==b.ts||128!==b.ks&&192!==b.ks&&0x100!==b.ks||!b.iv||2>b.iv.length||4<b.iv.length)throw new sjcl.exception.invalid(\"json decrypt: invalid parameters\");\"string\"===typeof a?(f=sjcl.misc.cachedPbkdf2(a,b),a=f.key.slice(0,b.ks/32),b.salt=f.salt):sjcl.ecc&&a instanceof sjcl.ecc.elGamal.secretKey&&(a=a.unkem(sjcl.codec.base64.toBits(b.kemtag)).slice(0,b.ks/32));\"string\"===typeof g&&(g=sjcl.codec.utf8String.toBits(g));f=new sjcl.cipher[b.cipher](a);g=\"ccm\"===\nb.mode&&sjcl.arrayBuffer&&sjcl.arrayBuffer.ccm&&b.ct instanceof ArrayBuffer?sjcl.arrayBuffer.ccm.decrypt(f,b.ct,b.iv,b.tag,g,b.ts):sjcl.mode[b.mode].decrypt(f,b.ct,b.iv,g,b.ts);e.g(d,b);d.key=a;return 1===c.raw?g:sjcl.codec.utf8String.fromBits(g)},decrypt:function(a,b,c,d){var e=sjcl.json;return e.ia(a,e.decode(b),c,d)},encode:function(a){var b,c=\"{\",d=\"\";for(b in a)if(a.hasOwnProperty(b)){if(!b.match(/^[a-z0-9]+$/i))throw new sjcl.exception.invalid(\"json encode: invalid property name\");c+=d+'\"'+\nb+'\":';d=\",\";switch(typeof a[b]){case \"number\":case \"boolean\":c+=a[b];break;case \"string\":c+='\"'+escape(a[b])+'\"';break;case \"object\":c+='\"'+sjcl.codec.base64.fromBits(a[b],0)+'\"';break;default:throw new sjcl.exception.bug(\"json encode: unsupported type\");}}return c+\"}\"},decode:function(a){a=a.replace(/\\s/g,\"\");if(!a.match(/^\\{.*\\}$/))throw new sjcl.exception.invalid(\"json decode: this isn't json!\");a=a.replace(/^\\{|\\}$/g,\"\").split(/,/);var b={},c,d;for(c=0;c<a.length;c++){if(!(d=a[c].match(/^\\s*(?:([\"']?)([a-z][a-z0-9]*)\\1)\\s*:\\s*(?:(-?\\d+)|\"([a-z0-9+\\/%*_.@=\\-]*)\"|(true|false))$/i)))throw new sjcl.exception.invalid(\"json decode: this isn't json!\");\nnull!=d[3]?b[d[2]]=parseInt(d[3],10):null!=d[4]?b[d[2]]=d[2].match(/^(ct|adata|salt|iv)$/)?sjcl.codec.base64.toBits(d[4]):unescape(d[4]):null!=d[5]&&(b[d[2]]=\"true\"===d[5])}return b},g:function(a,b,c){void 0===a&&(a={});if(void 0===b)return a;for(var d in b)if(b.hasOwnProperty(d)){if(c&&void 0!==a[d]&&a[d]!==b[d])throw new sjcl.exception.invalid(\"required parameter overridden\");a[d]=b[d]}return a},sa:function(a,b){var c={},d;for(d in a)a.hasOwnProperty(d)&&a[d]!==b[d]&&(c[d]=a[d]);return c},ra:function(a,\nb){var c={},d;for(d=0;d<b.length;d++)void 0!==a[b[d]]&&(c[b[d]]=a[b[d]]);return c}};sjcl.encrypt=sjcl.json.encrypt;sjcl.decrypt=sjcl.json.decrypt;sjcl.misc.pa={};sjcl.misc.cachedPbkdf2=function(a,b){var c=sjcl.misc.pa,d;b=b||{};d=b.iter||1E3;c=c[a]=c[a]||{};d=c[d]=c[d]||{firstSalt:b.salt&&b.salt.length?b.salt.slice(0):sjcl.random.randomWords(2,0)};c=void 0===b.salt?d.firstSalt:b.salt;d[c]=d[c]||sjcl.misc.pbkdf2(a,c,b.iter);return{key:d[c].slice(0),salt:c.slice(0)}};\n","requirejs/domReady.js":"/**\n * @license RequireJS domReady 2.0.1 Copyright (c) 2010-2012, The Dojo Foundation All Rights Reserved.\n * Available via the MIT or new BSD license.\n * see: http://github.com/requirejs/domReady for details\n */\n/*jslint */\n/*global require: false, define: false, requirejs: false,\n  window: false, clearInterval: false, document: false,\n  self: false, setInterval: false */\n\n\ndefine(function () {\n    'use strict';\n\n    var isTop, testDiv, scrollIntervalId,\n        isBrowser = typeof window !== \"undefined\" && window.document,\n        isPageLoaded = !isBrowser,\n        doc = isBrowser ? document : null,\n        readyCalls = [];\n\n    function runCallbacks(callbacks) {\n        var i;\n        for (i = 0; i < callbacks.length; i += 1) {\n            callbacks[i](doc);\n        }\n    }\n\n    function callReady() {\n        var callbacks = readyCalls;\n\n        if (isPageLoaded) {\n            //Call the DOM ready callbacks\n            if (callbacks.length) {\n                readyCalls = [];\n                runCallbacks(callbacks);\n            }\n        }\n    }\n\n    /**\n     * Sets the page as loaded.\n     */\n    function pageLoaded() {\n        if (!isPageLoaded) {\n            isPageLoaded = true;\n            if (scrollIntervalId) {\n                clearInterval(scrollIntervalId);\n            }\n\n            callReady();\n        }\n    }\n\n    if (isBrowser) {\n        if (document.addEventListener) {\n            //Standards. Hooray! Assumption here that if standards based,\n            //it knows about DOMContentLoaded.\n            document.addEventListener(\"DOMContentLoaded\", pageLoaded, false);\n            window.addEventListener(\"load\", pageLoaded, false);\n        } else if (window.attachEvent) {\n            window.attachEvent(\"onload\", pageLoaded);\n\n            testDiv = document.createElement('div');\n            try {\n                isTop = window.frameElement === null;\n            } catch (e) {}\n\n            //DOMContentLoaded approximation that uses a doScroll, as found by\n            //Diego Perini: http://javascript.nwbox.com/IEContentLoaded/,\n            //but modified by other contributors, including jdalton\n            if (testDiv.doScroll && isTop && window.external) {\n                scrollIntervalId = setInterval(function () {\n                    try {\n                        testDiv.doScroll();\n                        pageLoaded();\n                    } catch (e) {}\n                }, 30);\n            }\n        }\n\n        //Check if document is no longer loading, and if so, just trigger page load\n        //listeners. Latest webkit browsers also use \"interactive\", and\n        //will fire the onDOMContentLoaded before \"interactive\" but not after\n        //entering \"interactive\" or \"complete\". More details:\n        //http://dev.w3.org/html5/spec/the-end.html#the-end\n        //http://stackoverflow.com/questions/3665561/document-readystate-of-interactive-vs-ondomcontentloaded\n        //Hmm, this is more complicated on further use, see \"firing too early\"\n        //bug: https://github.com/requirejs/domReady/issues/1\n        //so removing the || document.readyState === \"interactive\" test.\n        //There is still a window.onload binding that should get fired if\n        //DOMContentLoaded is missed.\n        if (document.readyState !== \"loading\") {\n            // Handle it asynchronously to allow scripts the opportunity to delay ready\n            setTimeout(pageLoaded);\n        }\n    }\n\n    /** START OF PUBLIC API **/\n\n    /**\n     * Registers a callback for DOM ready. If DOM is already ready, the\n     * callback is called immediately.\n     * @param {Function} callback\n     */\n    function domReady(callback) {\n        if (isPageLoaded) {\n            callback(doc);\n        } else {\n            readyCalls.push(callback);\n        }\n        return domReady;\n    }\n\n    domReady.version = '2.0.1';\n\n    /**\n     * Loader Plugin API method\n     */\n    domReady.load = function (name, req, onLoad, config) {\n        if (config.isBuild) {\n            onLoad(null);\n        } else {\n            domReady(onLoad);\n        }\n    };\n\n    /** END OF PUBLIC API **/\n\n    return domReady;\n});\n","requirejs/text.js":"/**\n * @license RequireJS text 2.0.12 Copyright (c) 2010-2014, The Dojo Foundation All Rights Reserved.\n * Available via the MIT or new BSD license.\n * see: http://github.com/requirejs/text for details\n */\n/*jslint regexp: true */\n/*global require, XMLHttpRequest, ActiveXObject,\n  define, window, process, Packages,\n  java, location, Components, FileUtils */\n\ndefine(['module'], function (module) {\n    'use strict';\n\n    var text, fs, Cc, Ci, xpcIsWindows,\n        progIds = ['Msxml2.XMLHTTP', 'Microsoft.XMLHTTP', 'Msxml2.XMLHTTP.4.0'],\n        xmlRegExp = /^\\s*<\\?xml(\\s)+version=[\\'\\\"](\\d)*.(\\d)*[\\'\\\"](\\s)*\\?>/im,\n        bodyRegExp = /<body[^>]*>\\s*([\\s\\S]+)\\s*<\\/body>/im,\n        hasLocation = typeof location !== 'undefined' && location.href,\n        defaultProtocol = hasLocation && location.protocol && location.protocol.replace(/\\:/, ''),\n        defaultHostName = hasLocation && location.hostname,\n        defaultPort = hasLocation && (location.port || undefined),\n        buildMap = {},\n        masterConfig = (module.config && module.config()) || {};\n\n    text = {\n        version: '2.0.12',\n\n        strip: function (content) {\n            //Strips <?xml ...?> declarations so that external SVG and XML\n            //documents can be added to a document without worry. Also, if the string\n            //is an HTML document, only the part inside the body tag is returned.\n            if (content) {\n                content = content.replace(xmlRegExp, \"\");\n                var matches = content.match(bodyRegExp);\n                if (matches) {\n                    content = matches[1];\n                }\n            } else {\n                content = \"\";\n            }\n            return content;\n        },\n\n        jsEscape: function (content) {\n            return content.replace(/(['\\\\])/g, '\\\\$1')\n                .replace(/[\\f]/g, \"\\\\f\")\n                .replace(/[\\b]/g, \"\\\\b\")\n                .replace(/[\\n]/g, \"\\\\n\")\n                .replace(/[\\t]/g, \"\\\\t\")\n                .replace(/[\\r]/g, \"\\\\r\")\n                .replace(/[\\u2028]/g, \"\\\\u2028\")\n                .replace(/[\\u2029]/g, \"\\\\u2029\");\n        },\n\n        createXhr: masterConfig.createXhr || function () {\n            //Would love to dump the ActiveX crap in here. Need IE 6 to die first.\n            var xhr, i, progId;\n            if (typeof XMLHttpRequest !== \"undefined\") {\n                return new XMLHttpRequest();\n            } else if (typeof ActiveXObject !== \"undefined\") {\n                for (i = 0; i < 3; i += 1) {\n                    progId = progIds[i];\n                    try {\n                        xhr = new ActiveXObject(progId);\n                    } catch (e) {}\n\n                    if (xhr) {\n                        progIds = [progId];  // so faster next time\n                        break;\n                    }\n                }\n            }\n\n            return xhr;\n        },\n\n        /**\n         * Parses a resource name into its component parts. Resource names\n         * look like: module/name.ext!strip, where the !strip part is\n         * optional.\n         * @param {String} name the resource name\n         * @returns {Object} with properties \"moduleName\", \"ext\" and \"strip\"\n         * where strip is a boolean.\n         */\n        parseName: function (name) {\n            var modName, ext, temp,\n                strip = false,\n                index = name.indexOf(\".\"),\n                isRelative = name.indexOf('./') === 0 ||\n                             name.indexOf('../') === 0;\n\n            if (index !== -1 && (!isRelative || index > 1)) {\n                modName = name.substring(0, index);\n                ext = name.substring(index + 1, name.length);\n            } else {\n                modName = name;\n            }\n\n            temp = ext || modName;\n            index = temp.indexOf(\"!\");\n            if (index !== -1) {\n                //Pull off the strip arg.\n                strip = temp.substring(index + 1) === \"strip\";\n                temp = temp.substring(0, index);\n                if (ext) {\n                    ext = temp;\n                } else {\n                    modName = temp;\n                }\n            }\n\n            return {\n                moduleName: modName,\n                ext: ext,\n                strip: strip\n            };\n        },\n\n        xdRegExp: /^((\\w+)\\:)?\\/\\/([^\\/\\\\]+)/,\n\n        /**\n         * Is an URL on another domain. Only works for browser use, returns\n         * false in non-browser environments. Only used to know if an\n         * optimized .js version of a text resource should be loaded\n         * instead.\n         * @param {String} url\n         * @returns Boolean\n         */\n        useXhr: function (url, protocol, hostname, port) {\n            var uProtocol, uHostName, uPort,\n                match = text.xdRegExp.exec(url);\n            if (!match) {\n                return true;\n            }\n            uProtocol = match[2];\n            uHostName = match[3];\n\n            uHostName = uHostName.split(':');\n            uPort = uHostName[1];\n            uHostName = uHostName[0];\n\n            return (!uProtocol || uProtocol === protocol) &&\n                   (!uHostName || uHostName.toLowerCase() === hostname.toLowerCase()) &&\n                   ((!uPort && !uHostName) || uPort === port);\n        },\n\n        finishLoad: function (name, strip, content, onLoad) {\n            content = strip ? text.strip(content) : content;\n            if (masterConfig.isBuild) {\n                buildMap[name] = content;\n            }\n            onLoad(content);\n        },\n\n        load: function (name, req, onLoad, config) {\n            //Name has format: some.module.filext!strip\n            //The strip part is optional.\n            //if strip is present, then that means only get the string contents\n            //inside a body tag in an HTML string. For XML/SVG content it means\n            //removing the <?xml ...?> declarations so the content can be inserted\n            //into the current doc without problems.\n\n            // Do not bother with the work if a build and text will\n            // not be inlined.\n            if (config && config.isBuild && !config.inlineText) {\n                onLoad();\n                return;\n            }\n\n            masterConfig.isBuild = config && config.isBuild;\n\n            var parsed = text.parseName(name),\n                nonStripName = parsed.moduleName +\n                    (parsed.ext ? '.' + parsed.ext : ''),\n                url = req.toUrl(nonStripName),\n                useXhr = (masterConfig.useXhr) ||\n                         text.useXhr;\n\n            // Do not load if it is an empty: url\n            if (url.indexOf('empty:') === 0) {\n                onLoad();\n                return;\n            }\n\n            //Load the text. Use XHR if possible and in a browser.\n            if (!hasLocation || useXhr(url, defaultProtocol, defaultHostName, defaultPort)) {\n                text.get(url, function (content) {\n                    text.finishLoad(name, parsed.strip, content, onLoad);\n                }, function (err) {\n                    if (onLoad.error) {\n                        onLoad.error(err);\n                    }\n                });\n            } else {\n                //Need to fetch the resource across domains. Assume\n                //the resource has been optimized into a JS module. Fetch\n                //by the module name + extension, but do not include the\n                //!strip part to avoid file system issues.\n                req([nonStripName], function (content) {\n                    text.finishLoad(parsed.moduleName + '.' + parsed.ext,\n                                    parsed.strip, content, onLoad);\n                });\n            }\n        },\n\n        write: function (pluginName, moduleName, write, config) {\n            if (buildMap.hasOwnProperty(moduleName)) {\n                var content = text.jsEscape(buildMap[moduleName]);\n                write.asModule(pluginName + \"!\" + moduleName,\n                               \"define(function () { return '\" +\n                                   content +\n                               \"';});\\n\");\n            }\n        },\n\n        writeFile: function (pluginName, moduleName, req, write, config) {\n            var parsed = text.parseName(moduleName),\n                extPart = parsed.ext ? '.' + parsed.ext : '',\n                nonStripName = parsed.moduleName + extPart,\n                //Use a '.js' file name so that it indicates it is a\n                //script that can be loaded across domains.\n                fileName = req.toUrl(parsed.moduleName + extPart) + '.js';\n\n            //Leverage own load() method to load plugin value, but only\n            //write out values that do not have the strip argument,\n            //to avoid any potential issues with ! in file names.\n            text.load(nonStripName, req, function (value) {\n                //Use own write() method to construct full module value.\n                //But need to create shell that translates writeFile's\n                //write() to the right interface.\n                var textWrite = function (contents) {\n                    return write(fileName, contents);\n                };\n                textWrite.asModule = function (moduleName, contents) {\n                    return write.asModule(moduleName, fileName, contents);\n                };\n\n                text.write(pluginName, nonStripName, textWrite, config);\n            }, config);\n        }\n    };\n\n    if (masterConfig.env === 'node' || (!masterConfig.env &&\n            typeof process !== \"undefined\" &&\n            process.versions &&\n            !!process.versions.node &&\n            !process.versions['node-webkit'])) {\n        //Using special require.nodeRequire, something added by r.js.\n        fs = require.nodeRequire('fs');\n\n        text.get = function (url, callback, errback) {\n            try {\n                var file = fs.readFileSync(url, 'utf8');\n                //Remove BOM (Byte Mark Order) from utf8 files if it is there.\n                if (file.indexOf('\\uFEFF') === 0) {\n                    file = file.substring(1);\n                }\n                callback(file);\n            } catch (e) {\n                if (errback) {\n                    errback(e);\n                }\n            }\n        };\n    } else if (masterConfig.env === 'xhr' || (!masterConfig.env &&\n            text.createXhr())) {\n        text.get = function (url, callback, errback, headers) {\n            var xhr = text.createXhr(), header;\n            xhr.open('GET', url, true);\n\n            //Allow plugins direct access to xhr headers\n            if (headers) {\n                for (header in headers) {\n                    if (headers.hasOwnProperty(header)) {\n                        xhr.setRequestHeader(header.toLowerCase(), headers[header]);\n                    }\n                }\n            }\n\n            //Allow overrides specified in config\n            if (masterConfig.onXhr) {\n                masterConfig.onXhr(xhr, url);\n            }\n\n            xhr.onreadystatechange = function (evt) {\n                var status, err;\n                //Do not explicitly handle errors, those should be\n                //visible via console output in the browser.\n                if (xhr.readyState === 4) {\n                    status = xhr.status || 0;\n                    if (status > 399 && status < 600) {\n                        //An http 4xx or 5xx error. Signal an error.\n                        err = new Error(url + ' HTTP status: ' + status);\n                        err.xhr = xhr;\n                        if (errback) {\n                            errback(err);\n                        }\n                    } else {\n                        callback(xhr.responseText);\n                    }\n\n                    if (masterConfig.onXhrComplete) {\n                        masterConfig.onXhrComplete(xhr, url);\n                    }\n                }\n            };\n            xhr.send(null);\n        };\n    } else if (masterConfig.env === 'rhino' || (!masterConfig.env &&\n            typeof Packages !== 'undefined' && typeof java !== 'undefined')) {\n        //Why Java, why is this so awkward?\n        text.get = function (url, callback) {\n            var stringBuffer, line,\n                encoding = \"utf-8\",\n                file = new java.io.File(url),\n                lineSeparator = java.lang.System.getProperty(\"line.separator\"),\n                input = new java.io.BufferedReader(new java.io.InputStreamReader(new java.io.FileInputStream(file), encoding)),\n                content = '';\n            try {\n                stringBuffer = new java.lang.StringBuffer();\n                line = input.readLine();\n\n                // Byte Order Mark (BOM) - The Unicode Standard, version 3.0, page 324\n                // http://www.unicode.org/faq/utf_bom.html\n\n                // Note that when we use utf-8, the BOM should appear as \"EF BB BF\", but it doesn't due to this bug in the JDK:\n                // http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=4508058\n                if (line && line.length() && line.charAt(0) === 0xfeff) {\n                    // Eat the BOM, since we've already found the encoding on this file,\n                    // and we plan to concatenating this buffer with others; the BOM should\n                    // only appear at the top of a file.\n                    line = line.substring(1);\n                }\n\n                if (line !== null) {\n                    stringBuffer.append(line);\n                }\n\n                while ((line = input.readLine()) !== null) {\n                    stringBuffer.append(lineSeparator);\n                    stringBuffer.append(line);\n                }\n                //Make sure we return a JavaScript string and not a Java string.\n                content = String(stringBuffer.toString()); //String\n            } finally {\n                input.close();\n            }\n            callback(content);\n        };\n    } else if (masterConfig.env === 'xpconnect' || (!masterConfig.env &&\n            typeof Components !== 'undefined' && Components.classes &&\n            Components.interfaces)) {\n        //Avert your gaze!\n        Cc = Components.classes;\n        Ci = Components.interfaces;\n        Components.utils['import']('resource://gre/modules/FileUtils.jsm');\n        xpcIsWindows = ('@mozilla.org/windows-registry-key;1' in Cc);\n\n        text.get = function (url, callback) {\n            var inStream, convertStream, fileObj,\n                readData = {};\n\n            if (xpcIsWindows) {\n                url = url.replace(/\\//g, '\\\\');\n            }\n\n            fileObj = new FileUtils.File(url);\n\n            //XPCOM, you so crazy\n            try {\n                inStream = Cc['@mozilla.org/network/file-input-stream;1']\n                           .createInstance(Ci.nsIFileInputStream);\n                inStream.init(fileObj, 1, 0, false);\n\n                convertStream = Cc['@mozilla.org/intl/converter-input-stream;1']\n                                .createInstance(Ci.nsIConverterInputStream);\n                convertStream.init(inStream, \"utf-8\", inStream.available(),\n                Ci.nsIConverterInputStream.DEFAULT_REPLACEMENT_CHARACTER);\n\n                convertStream.readString(inStream.available(), readData);\n                convertStream.close();\n                inStream.close();\n                callback(readData.value);\n            } catch (e) {\n                throw new Error((fileObj && fileObj.path || '') + ': ' + e);\n            }\n        };\n    }\n    return text;\n});","Magento_CatalogSearch/js/search-terms-log.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mageUtils'\n], function ($, utils) {\n    'use strict';\n\n    return function (data) {\n        $.ajax({\n            method: 'GET',\n            url: data.url,\n            data: {\n                'q': utils.getUrlParameters(window.location.href).q\n            }\n        });\n    };\n});\n","Magento_Newsletter/js/subscription-status-resolver.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/url'\n], function ($, urlBuilder) {\n    'use strict';\n\n    return function (email, deferred) {\n        return $.getJSON(\n            urlBuilder.build('newsletter/ajax/status'),\n            {\n                email: email\n            }\n        ).done(function (response) {\n            if (response.errors) {\n                deferred.reject();\n            } else {\n                deferred.resolve(response.subscribed);\n            }\n        }).fail(function () {\n            deferred.reject();\n        });\n    };\n});\n","Magento_Newsletter/js/newsletter-sign-up.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'uiElement',\n    'mage/url',\n    'subscriptionStatusResolver',\n    'mage/validation'\n], function ($, Component, urlBuilder, subscriptionStatusResolver) {\n    'use strict';\n\n    return Component.extend({\n\n        defaults: {\n            signUpElement: '',\n            submitButton: '',\n            element: null\n        },\n\n        /** @inheritdoc */\n        initialize: function (config, element) {\n            this._super();\n            this.element = element;\n            $(element).on('change', $.proxy(this.updateSignUpStatus, this));\n            this.updateSignUpStatus();\n        },\n\n        /**\n         * Send status request and update subscription element according to result.\n         */\n        updateSignUpStatus: function () {\n            var element = $(this.element),\n                email = element.val(),\n                self = this,\n                newsletterSubscription;\n\n            if ($(self.signUpElement).is(':checked')) {\n                return;\n            }\n\n            if (!email || !$.validator.methods['validate-email'].call(this, email, element)) {\n                return;\n            }\n\n            newsletterSubscription = $.Deferred();\n\n            $(self.submitButton).prop('disabled', true);\n\n            subscriptionStatusResolver(email, newsletterSubscription);\n\n            $.when(newsletterSubscription).done(function (isSubscribed) {\n                if (isSubscribed) {\n                    $(self.signUpElement).prop('checked', true);\n                }\n            }).always(function () {\n                $(self.submitButton).prop('disabled', false);\n            });\n        }\n    });\n});\n","Dotdigitalgroup_Chat/js/chatData.js":"define([\n    'Magento_Customer/js/customer-data',\n    'jquery',\n    'mage/cookies'\n], function (customerData, $) {\n    'use strict';\n\n    /**\n     * Enable the chat widget\n     *\n     * @param {Object} chatData\n     */\n    function startChat(chatData) {\n        var storageKey = chatData().cookieName;\n\n        window._ddgChatConfig = {\n            apiSpace: chatData().apiSpaceId,\n            urlBase: 'https://webchat.dotdigital.com'\n        };\n\n        (function (d, s, id) {\n            var js, cjs = d.getElementsByTagName(s)[0];\n\n            if (d.getElementById(id)) {\n                return;\n            }\n            js = d.createElement(s); js.id = id;\n            js.src = '//webchat.dotdigital.com/widget/bootstrap.js';\n            cjs.parentNode.insertBefore(js, cjs);\n        }(document, 'script', 'ddg-chat-widget'));\n\n        // listen for widget message events\n        window.addEventListener('message', function (event) {\n            if (event.data.type !== 'SetWidgetState') {\n                return;\n            }\n\n            if (event.data.show === 'hidden') {\n                // user has closed the chat\n                sessionStorage.removeItem(storageKey);\n\n            } else if (sessionStorage.getItem(storageKey) === null) {\n                // Sync the Magento user id\n                window.COMAPI_WIDGET_API.profile.getProfile()\n                    .then(function (profile) {\n                        $.ajax({\n                            url: chatData().profileEndpoint,\n                            type: 'POST',\n                            data: 'profileId=' + profile.id,\n                            success: function () {\n                                // store profile ID in session to flag interaction\n                                sessionStorage.setItem(storageKey, profile.id);\n                                // store profile ID in cookie for server-side reference\n                                $.cookie(storageKey, profile.id);\n                            }\n                        });\n                    });\n            }\n        });\n    }\n\n    return function () {\n        var sectionName = 'chatData',\n            chatData = customerData.get(sectionName);\n\n        // check we have API space ID, that chat is enabled, and the API space ID was refreshed under 6 hours ago\n        if (\n            chatData().apiSpaceId == null\n            || chatData().data_id < Math.floor(new Date().getTime() / 1000 - 60 * 60)\n        ) {\n            customerData.reload([sectionName], true)\n                .done(function () {\n                    chatData = customerData.get(sectionName);\n\n                    if (chatData().isEnabled && chatData().apiSpaceId == null) {\n                        console.log('dotdigital chat error: API space ID is null. Please check your settings.');\n                    } else {\n                        startChat(chatData);\n                    }\n                });\n        } else if (chatData().isEnabled) {\n            startChat(chatData);\n        }\n    };\n});\n","Magento_Reports/js/recently-viewed.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.recentlyViewedProducts', {\n        options: {\n            localStorageKey: 'recently-viewed-products',\n            productBlock: '#widget_viewed_item',\n            viewedContainer: 'ol'\n        },\n\n        /**\n         * Bind events to the appropriate handlers.\n         * @private\n         */\n        _create: function () {\n            var productHtml = $(this.options.productBlock).html(),\n                productSku = $(this.options.productBlock).data('sku'),\n                products = JSON.parse(window.localStorage.getItem(this.options.localStorageKey)),\n                productsLength, maximum, showed, index;\n\n            if (products) {\n                productsLength = products.sku.length;\n                maximum = $(this.element).data('count');\n                showed = 0;\n\n                for (index = 0; index <= productsLength; index++) {\n                    if (products.sku[index] == productSku || showed >= maximum) { //eslint-disable-line\n                        products.sku.splice(index, 1);\n                        products.html.splice(index, 1);\n                    } else {\n                        $(this.element).find(this.options.viewedContainer).append(products.html[index]);\n                        $(this.element).show();\n                        showed++;\n                    }\n                }\n                $(this.element).find(this.options.productBlock).show();\n            } else {\n                products = {};\n                products.sku = [];\n                products.html = [];\n            }\n            products.sku.unshift(productSku);\n            products.html.unshift(productHtml);\n            window.localStorage.setItem(this.options.localStorageKey, JSON.stringify(products));\n        }\n    });\n\n    return $.mage.recentlyViewedProducts;\n});\n","Punchout2go_Punchout/js/punchout_script.js":"/* rv.2.1.20-1 */\n\ndefine([\n        'jquery',\n        'mage/url',\n        'Magento_Customer/js/customer-data',\n        'mage/cookies'\n    ],\n    function ($,url,customerData) {\n        'use strict';\n\n        return {\n            session_data: {\n                \"is_edit\": 0,\n                \"is_punchout\": false,\n                \"is_error\": false,\n                \"selected_item\": false,\n                \"posid\": null,\n                \"config\": {\n                    \"display\": {\n                        \"return_link_label\": \"Return\",\n                        \"return_link_enabled\": null\n                    },\n                    \"session\": {\n                        \"load_posdelay\": 0,\n                        \"js_clear_localdata\": false,\n                        \"js_session_clean\": false,\n                        \"js_reload_sections\": null,\n                        \"use_js_redirection\": false,\n                        \"edit_redirect_message\": \"Redirecting to your cart..\",\n                        \"l2_redirect_message\": \"Redirecting to {name}..\",\n                        \"redirect_timeout\": null\n                    },\n                    \"system\": {\n                        \"js_logging\": false\n                    }\n                }\n            },\n\n            \"punchout\" : function (settings)\n            {\n                this.init(settings);\n            },\n\n            init : function (session_config) {\n                this.session_data.config = session_config;\n                var delay = this.session_data.config.session.load_posdelay;\n                if (delay > 0\n                    || self.location.href.indexOf('posdelay') > 1) {\n                    var delay_pos = self.location.href.indexOf('posdelay=');\n                    var timeout = delay;\n                    if (delay_pos > 0) {\n                        var start = (delay_pos + 9);\n                        var end = self.location.href.indexOf('&', start);\n                        if (end > 1) {\n                        } else {\n                            end = self.location.href.length;\n                        }\n                        var len = end - start;\n                        timeout = self.location.href.substr(start, len);\n                    }\n                    setTimeout($.proxy(function () {\n                        this.loadSession();\n                    }, this), timeout);\n                } else if (delay < 0) {\n                    // do not execute JS user load\n                    // depend on class\n                    if ($('body').hasClass('is-punchout-session')) {\n                        this.session_data.is_punchout = 1;\n                        var php_session = $.cookie('PHPSESSID');\n                        if (php_session) {\n                            this.session_data.posid = php_session;\n                        } else {\n                            this.session_data.posid = 1;\n                        }\n                        this.startUp();\n                    }\n                } else {\n                    this.loadSession();\n                }\n            },\n\n            buildUrl : function (path){\n                return url.build(this.session_data.config.baseUrl + path);\n            },\n\n            loadSession : function ()\n            {\n                var data_url = this.buildUrl('punchout/session/data');\n                // console.log(\"In load session\", this.session_data.config);\n                $.ajax(data_url, {\n                    \"dataType\": \"json\",\n                    \"complete\": $.proxy(function (connection_data) {\n                        var data = connection_data.responseJSON;\n                        if (typeof data == \"undefined\") {\n                            this.session_data.is_punchout = false;\n                            this.session_data.is_error = true;\n                        } else {\n                            this.session_data = data;\n                        }\n\n                        // console.log(\"DATA URL\", data_url);\n                        // console.log(\"DATA Returned\", this.session_data);\n                        this.startUp();\n                    },this)\n                });\n            },\n\n            startUp : function ()\n            {\n                if (this.isPunchout()) {\n                    //this.log('is punchout',this.session_data);\n                    if (!$('body').hasClass('is-punchout-session')) {\n                        $('body').addClass('is-punchout-session');\n                    }\n                    this.updateDisplay();\n                    this.firstPageCheck();\n                }\n            },\n\n            updateDisplay : function ()\n                {\n                if (this.session_data.config.display.return_link_enabled) {\n                    //$('li.punchout-close').show();\n                    $('.punchout-close').addClass(\"on\");\n                    this.log('show close session');\n                }\n            },\n\n            isPunchout : function ()\n            {\n                return this.session_data.is_punchout;\n            },\n\n            isLevel2 : function ()\n            {\n                if (this.session_data.selected_item == false) {\n                    return false;\n                } else {\n                    return true;\n                }\n            },\n\n            isEdit : function ()\n            {\n                return this.session_data.is_edit;\n            },\n\n            firstPageCheck : function ()\n            {\n                if (self.location.href.indexOf('force_first_load') > 1\n                    || this.getLocalData('posid-first-load') != this.session_data.posid) {\n\n                    this.log('is first page.');\n\n                    if (this.cleanData()) {\n                        this.redirectSession();\n                    }\n\n                }\n            },\n\n            redirectSession : function ()\n            {\n                if (this.session_data.config.session.use_js_redirection) {\n                    this.log('use js redirect..');\n                    if (this.isLevel2()) {\n                        this.log('redirect level 2');\n                        this.redirectToSelectedItem();\n                    } else if (this.isEdit()) {\n                        this.log('redirect edit');\n                        this.redirectToCart();\n                    } else {\n                        this.log('no redirection');\n                    }\n                }\n            },\n\n            redirectToSelectedItem : function ()\n            {\n                var selected_item = this.session_data.selected_item;\n                var redirect_message = this.session_data.config.session.l2_redirect_message;\n                $.each(selected_item, function (key, value) {\n                    var strkey = '{'+ key +'}';\n                    redirect_message = redirect_message.replace(strkey, value);\n                });\n                Basic.Modal.show(redirect_message);\n                var timeout = this.getRedirectTimeout();\n                setTimeout(function() {\n                    self.location.href = selected_item.url;\n                },timeout);\n                this.log(redirect_message +' '+ timeout, selected_item);\n            },\n\n            redirectToCart : function ()\n            {\n                var redirect_message = this.session_data.config.session.edit_redirect_message;\n                Basic.Modal.show(redirect_message);\n                var timeout = this.getRedirectTimeout();\n                setTimeout(function() {\n                    self.location.href = url.build('/checkout/cart');\n                },timeout);\n                this.log(redirect_message +' '+ timeout);\n            },\n\n            cleanData : function()\n            {\n                //console.log('clean storage');\n                // set cookie, flag we are in.\n                //$.cookie.delete('posid-first-load');\n                this.setLocalData('posid-first-load',this.session_data.posid);\n\n                if (this.session_data.config.session.js_clear_localdata) {\n                    // clear mage storage\n                    this.log('clear local storage');\n                    var storage = $.initNamespaceStorage('mage-cache-storage').localStorage;\n                    storage.removeAll();\n                }\n\n                if (this.session_data.config.session.js_session_clean\n                    && this.isEdit()) {\n                    this.log('execute punchout/session/clean');\n                    var data_url = url.build('/punchout/session/clean');\n                    $.ajax(data_url, {\n                        \"type\" : \"POST\",\n                        \"data\" : {},\n                        \"dataType\": \"json\",\n                        \"complete\": $.proxy(function (connection_data) {\n                            this.clearCustomerData();\n                            this.redirectSession();\n                        },this)\n                    });\n                    return false;\n                } else {\n                    this.clearCustomerData();\n                    return true;\n                }\n            },\n\n            clearCustomerData : function ()\n            {\n                //require([\n                //        'Magento_Customer/js/customer-data'\n                //    ],\n                //    function (customerData) {\n                var reload_sections = this.session_data.config.session.js_reload_sections;\n                this.log('reload customer data : '+ reload_sections)\n                if (reload_sections) {\n                    //var sections = ['cart','customer'];\n                    var sections = reload_sections.split(\",\");\n                    this.log('split',sections);\n                    customerData.invalidate(sections);\n                    customerData.reload(sections, true);\n                }\n                //    }\n                //);\n            },\n\n            getRedirectTimeout : function ()\n            {\n                var redirect_timeout = parseInt(this.session_data.config.session.redirect_timeout);\n                return (typeof redirect_timeout == \"number\" ? redirect_timeout : 2000);\n            },\n\n            getLocalData : function (name)\n            {\n                var storage = $.initNamespaceStorage('punchout-data').localStorage;\n                return storage.get(name);\n            },\n\n            setLocalData : function (name,value)\n            {\n                var storage = $.initNamespaceStorage('punchout-data').localStorage;\n                return storage.set(name,value);\n            },\n\n            log : function (string,data)\n            {\n                if (this.session_data.config.system.js_logging) {\n                    console.log(string,data);\n                }\n            }\n\n        }\n\n    }\n\n);\n\n/*\n//    'underscore',\n//    'ko',\n//    'Magento_Customer/js/section-config',\n//    'Magento_Customer/js/customer-data',\n//    'jquery/jquery-storageapi'],\n// _,ko,sectionConfig,customerData,storageApi\n\n        $(function () {\n            var Punchout = {\n\n            }\n            if (!$.cookieStorage.isSet('mage-cache-sessid')\n                || ($.cookieStorage.isSet('punchout-reset-storage')\n                    && $.cookieStorage.get('punchout-reset-storage') != 0)\n                || self.location.href.indexOf('posid') > 0) {\n                //self.alert('remove all..');\n                //customerData.invalidate(['*']);\n                $.cookieStorage.set('mage-cache-sessid', true);\n                //self.alert('force invalidated..');\n                var storage = $.initNamespaceStorage('mage-cache-storage').localStorage;\n                storage.removeAll();\n                //self.alert('removed all');\n                //customerData.reload(['*'],true);\n                $.cookieStorage.set('punchout-reset-storage', '0');\n                //var sections = ['cart','customer'];\n                if (self.location.href.indexOf('edit=1') > 0) {\n                    if ($('.cart-empty')) {\n                        $('.cart-empty').html('Retrieving your previous cart items...');\n                        setTimeout(function () {\n                            require([\n                                    'Magento_Customer/js/customer-data'\n                                ],\n                                function (customerData) {\n                                    var sections = ['cart','customer'];\n                                    customerData.invalidate(sections);\n                                    customerData.reload(sections, true);\n                                }\n                            );\n                        },2000);\n                    }\n                }\n            } else {\n                //self.alert('keep local cache...');\n            }\n */","Klarna_Onsitemessaging/js/pricebox-widget-mixin.js":"/**\n * This file is part of the Klarna Onsitemessaging module\n *\n * (c) Klarna Bank AB (publ)\n *\n * For the full copyright and license information, please view the NOTICE\n * and LICENSE files that were distributed with this source code.\n */\ndefine(['jquery'], function ($) {\n    'use strict';\n\n    var priceBoxWidget = {\n\n        /**\n         * Updating the price\n         * @param {String} newPrices\n         * @returns {*}\n         */\n        updatePrice: function (newPrices) {\n            var ret = this._super(newPrices);\n\n            if (document.querySelector('klarna-placement')) {\n                // jscs:disable requireMultipleVarDecl\n                // eslint-disable-next-line vars-on-top\n                var price = Math.round(this.cache.displayPrices.finalPrice.amount * 100);\n\n                document.querySelector('klarna-placement').dataset.purchaseAmount = price;\n                window.KlarnaOnsiteService = window.KlarnaOnsiteService || [];\n                window.KlarnaOnsiteService.push({\n                    eventName: 'refresh-placements'\n                });\n            }\n\n            return ret;\n        }\n    };\n\n    return function (targetWidget) {\n        $.widget('mage.priceBox', targetWidget, priceBoxWidget);\n\n        return $.mage.priceBox;\n    };\n});\n","Klarna_Onsitemessaging/js/cart-update.js":"/**\n * This file is part of the Klarna Onsitemessaging module\n *\n * (c) Klarna Bank AB (publ)\n *\n * For the full copyright and license information, please view the NOTICE\n * and LICENSE files that were distributed with this source code.\n */\ndefine([\n    'Magento_Checkout/js/model/totals'\n], function (totalsService) {\n    'use strict';\n\n    // Monitor the cart totals so we can update messaging with any price changes\n    totalsService.totals.subscribe(function () {\n        if (document.querySelector('klarna-placement')) {\n            // eslint-disable-next-line vars-on-top\n            var grandTotal = totalsService.getSegment('grand_total').value,\n            price = Math.round(grandTotal * 100);\n\n            document.querySelector('klarna-placement').dataset.purchaseAmount = price;\n            window.KlarnaOnsiteService = window.KlarnaOnsiteService || [];\n            window.KlarnaOnsiteService.push({\n                eventName: 'refresh-placements'\n            });\n        }\n    });\n});\n","Magento_ProductAlert/js/form-submitter.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    return function (data, element) {\n\n        $(element).trigger('submit');\n    };\n});\n","fotorama/fotorama.js":"/*!\n * Fotorama 4.6.4 | http://fotorama.io/license/\n */\nfotoramaVersion = '4.6.4';\n(function (window, document, location, $, undefined) {\n    \"use strict\";\n    var _fotoramaClass = 'fotorama',\n        _fullscreenClass = 'fotorama__fullscreen',\n\n        wrapClass = _fotoramaClass + '__wrap',\n        wrapCss2Class = wrapClass + '--css2',\n        wrapCss3Class = wrapClass + '--css3',\n        wrapVideoClass = wrapClass + '--video',\n        wrapFadeClass = wrapClass + '--fade',\n        wrapSlideClass = wrapClass + '--slide',\n        wrapNoControlsClass = wrapClass + '--no-controls',\n        wrapNoShadowsClass = wrapClass + '--no-shadows',\n        wrapPanYClass = wrapClass + '--pan-y',\n        wrapRtlClass = wrapClass + '--rtl',\n        wrapOnlyActiveClass = wrapClass + '--only-active',\n        wrapNoCaptionsClass = wrapClass + '--no-captions',\n        wrapToggleArrowsClass = wrapClass + '--toggle-arrows',\n\n        stageClass = _fotoramaClass + '__stage',\n        stageFrameClass = stageClass + '__frame',\n        stageFrameVideoClass = stageFrameClass + '--video',\n        stageShaftClass = stageClass + '__shaft',\n\n        grabClass = _fotoramaClass + '__grab',\n        pointerClass = _fotoramaClass + '__pointer',\n\n        arrClass = _fotoramaClass + '__arr',\n        arrDisabledClass = arrClass + '--disabled',\n        arrPrevClass = arrClass + '--prev',\n        arrNextClass = arrClass + '--next',\n\n        navClass = _fotoramaClass + '__nav',\n        navWrapClass = navClass + '-wrap',\n        navShaftClass = navClass + '__shaft',\n        navShaftVerticalClass = navWrapClass + '--vertical',\n        navShaftListClass = navWrapClass + '--list',\n        navShafthorizontalClass = navWrapClass + '--horizontal',\n        navDotsClass = navClass + '--dots',\n        navThumbsClass = navClass + '--thumbs',\n        navFrameClass = navClass + '__frame',\n\n        fadeClass = _fotoramaClass + '__fade',\n        fadeFrontClass = fadeClass + '-front',\n        fadeRearClass = fadeClass + '-rear',\n\n        shadowClass = _fotoramaClass + '__shadow',\n        shadowsClass = shadowClass + 's',\n        shadowsLeftClass = shadowsClass + '--left',\n        shadowsRightClass = shadowsClass + '--right',\n        shadowsTopClass = shadowsClass + '--top',\n        shadowsBottomClass = shadowsClass + '--bottom',\n\n        activeClass = _fotoramaClass + '__active',\n        selectClass = _fotoramaClass + '__select',\n\n        hiddenClass = _fotoramaClass + '--hidden',\n\n        fullscreenClass = _fotoramaClass + '--fullscreen',\n        fullscreenIconClass = _fotoramaClass + '__fullscreen-icon',\n\n        errorClass = _fotoramaClass + '__error',\n        loadingClass = _fotoramaClass + '__loading',\n        loadedClass = _fotoramaClass + '__loaded',\n        loadedFullClass = loadedClass + '--full',\n        loadedImgClass = loadedClass + '--img',\n\n        grabbingClass = _fotoramaClass + '__grabbing',\n\n        imgClass = _fotoramaClass + '__img',\n        imgFullClass = imgClass + '--full',\n\n        thumbClass = _fotoramaClass + '__thumb',\n        thumbArrLeft = thumbClass + '__arr--left',\n        thumbArrRight = thumbClass + '__arr--right',\n        thumbBorderClass = thumbClass + '-border',\n\n        htmlClass = _fotoramaClass + '__html',\n\n        videoContainerClass = _fotoramaClass + '-video-container',\n        videoClass = _fotoramaClass + '__video',\n        videoPlayClass = videoClass + '-play',\n        videoCloseClass = videoClass + '-close',\n\n\n        horizontalImageClass = _fotoramaClass + '_horizontal_ratio',\n        verticalImageClass = _fotoramaClass + '_vertical_ratio',\n        fotoramaSpinnerClass = _fotoramaClass + '__spinner',\n        spinnerShowClass = fotoramaSpinnerClass + '--show';\n    var JQUERY_VERSION = $ && $.fn.jquery.split('.');\n\n    if (!JQUERY_VERSION\n        || JQUERY_VERSION[0] < 1\n        || (JQUERY_VERSION[0] == 1 && JQUERY_VERSION[1] < 8)) {\n        throw 'Fotorama requires jQuery 1.8 or later and will not run without it.';\n    }\n\n    var _ = {};\n    /* Modernizr 2.8.3 (Custom Build) | MIT & BSD\n     * Build: http://modernizr.com/download/#-csstransforms3d-csstransitions-touch-prefixed\n     */\n\n    var Modernizr = (function (window, document, undefined) {\n        var version = '2.8.3',\n            Modernizr = {},\n\n\n            docElement = document.documentElement,\n\n            mod = 'modernizr',\n            modElem = document.createElement(mod),\n            mStyle = modElem.style,\n            inputElem,\n\n\n            toString = {}.toString,\n\n            prefixes = ' -webkit- -moz- -o- -ms- '.split(' '),\n\n\n            omPrefixes = 'Webkit Moz O ms',\n\n            cssomPrefixes = omPrefixes.split(' '),\n\n            domPrefixes = omPrefixes.toLowerCase().split(' '),\n\n\n            tests = {},\n            inputs = {},\n            attrs = {},\n\n            classes = [],\n\n            slice = classes.slice,\n\n            featureName,\n\n\n            injectElementWithStyles = function (rule, callback, nodes, testnames) {\n\n                var style, ret, node, docOverflow,\n                    div = document.createElement('div'),\n                    body = document.body,\n                    fakeBody = body || document.createElement('body');\n\n                if (parseInt(nodes, 10)) {\n                    while (nodes--) {\n                        node = document.createElement('div');\n                        node.id = testnames ? testnames[nodes] : mod + (nodes + 1);\n                        div.appendChild(node);\n                    }\n                }\n\n                style = ['&#173;', '<style id=\"s', mod, '\">', rule, '</style>'].join('');\n                div.id = mod;\n                (body ? div : fakeBody).innerHTML += style;\n                fakeBody.appendChild(div);\n                if (!body) {\n                    fakeBody.style.background = '';\n                    fakeBody.style.overflow = 'hidden';\n                    docOverflow = docElement.style.overflow;\n                    docElement.style.overflow = 'hidden';\n                    docElement.appendChild(fakeBody);\n                }\n\n                ret = callback(div, rule);\n                if (!body) {\n                    fakeBody.parentNode.removeChild(fakeBody);\n                    docElement.style.overflow = docOverflow;\n                } else {\n                    div.parentNode.removeChild(div);\n                }\n\n                return !!ret;\n\n            },\n            _hasOwnProperty = ({}).hasOwnProperty, hasOwnProp;\n\n        if (!is(_hasOwnProperty, 'undefined') && !is(_hasOwnProperty.call, 'undefined')) {\n            hasOwnProp = function (object, property) {\n                return _hasOwnProperty.call(object, property);\n            };\n        }\n        else {\n            hasOwnProp = function (object, property) {\n                return ((property in object) && is(object.constructor.prototype[property], 'undefined'));\n            };\n        }\n\n\n        if (!Function.prototype.bind) {\n            Function.prototype.bind = function bind(that) {\n\n                var target = this;\n\n                if (typeof target != \"function\") {\n                    throw new TypeError();\n                }\n\n                var args = slice.call(arguments, 1),\n                    bound = function () {\n\n                        if (this instanceof bound) {\n\n                            var F = function () {\n                            };\n                            F.prototype = target.prototype;\n                            var self = new F();\n\n                            var result = target.apply(\n                                self,\n                                args.concat(slice.call(arguments))\n                            );\n                            if (Object(result) === result) {\n                                return result;\n                            }\n                            return self;\n\n                        } else {\n\n                            return target.apply(\n                                that,\n                                args.concat(slice.call(arguments))\n                            );\n\n                        }\n\n                    };\n\n                return bound;\n            };\n        }\n\n        function setCss(str) {\n            mStyle.cssText = str;\n        }\n\n        function setCssAll(str1, str2) {\n            return setCss(prefixes.join(str1 + ';') + ( str2 || '' ));\n        }\n\n        function is(obj, type) {\n            return typeof obj === type;\n        }\n\n        function contains(str, substr) {\n            return !!~('' + str).indexOf(substr);\n        }\n\n        function testProps(props, prefixed) {\n            for (var i in props) {\n                var prop = props[i];\n                if (!contains(prop, \"-\") && mStyle[prop] !== undefined) {\n                    return prefixed == 'pfx' ? prop : true;\n                }\n            }\n            return false;\n        }\n\n        function testDOMProps(props, obj, elem) {\n            for (var i in props) {\n                var item = obj[props[i]];\n                if (item !== undefined) {\n\n                    if (elem === false) return props[i];\n\n                    if (is(item, 'function')) {\n                        return item.bind(elem || obj);\n                    }\n\n                    return item;\n                }\n            }\n            return false;\n        }\n\n        function testPropsAll(prop, prefixed, elem) {\n\n            var ucProp = prop.charAt(0).toUpperCase() + prop.slice(1),\n                props = (prop + ' ' + cssomPrefixes.join(ucProp + ' ') + ucProp).split(' ');\n\n            if (is(prefixed, \"string\") || is(prefixed, \"undefined\")) {\n                return testProps(props, prefixed);\n\n            } else {\n                props = (prop + ' ' + (domPrefixes).join(ucProp + ' ') + ucProp).split(' ');\n                return testDOMProps(props, prefixed, elem);\n            }\n        }\n\n        tests['touch'] = function () {\n            var bool;\n\n            if (('ontouchstart' in window) || window.DocumentTouch && document instanceof DocumentTouch) {\n                bool = true;\n            } else {\n                injectElementWithStyles(['@media (', prefixes.join('touch-enabled),('), mod, ')', '{#modernizr{top:9px;position:absolute}}'].join(''), function (node) {\n                    bool = node.offsetTop === 9;\n                });\n            }\n\n            return bool;\n        };\n        tests['csstransforms3d'] = function () {\n\n            var ret = !!testPropsAll('perspective');\n\n            if (ret && 'webkitPerspective' in docElement.style) {\n\n                injectElementWithStyles('@media (transform-3d),(-webkit-transform-3d){#modernizr{left:9px;position:absolute;height:3px;}}', function (node, rule) {\n                    ret = node.offsetLeft === 9 && node.offsetHeight === 3;\n                });\n            }\n            return ret;\n        };\n\n\n        tests['csstransitions'] = function () {\n            return testPropsAll('transition');\n        };\n\n\n        for (var feature in tests) {\n            if (hasOwnProp(tests, feature)) {\n                featureName = feature.toLowerCase();\n                Modernizr[featureName] = tests[feature]();\n\n                classes.push((Modernizr[featureName] ? '' : 'no-') + featureName);\n            }\n        }\n\n\n        Modernizr.addTest = function (feature, test) {\n            if (typeof feature == 'object') {\n                for (var key in feature) {\n                    if (hasOwnProp(feature, key)) {\n                        Modernizr.addTest(key, feature[key]);\n                    }\n                }\n            } else {\n\n                feature = feature.toLowerCase();\n\n                if (Modernizr[feature] !== undefined) {\n                    return Modernizr;\n                }\n\n                test = typeof test == 'function' ? test() : test;\n\n                if (typeof enableClasses !== \"undefined\" && enableClasses) {\n                    docElement.className += ' ' + (test ? '' : 'no-') + feature;\n                }\n                Modernizr[feature] = test;\n\n            }\n\n            return Modernizr;\n        };\n\n\n        setCss('');\n        modElem = inputElem = null;\n\n\n        Modernizr._version = version;\n\n        Modernizr._prefixes = prefixes;\n        Modernizr._domPrefixes = domPrefixes;\n        Modernizr._cssomPrefixes = cssomPrefixes;\n\n\n        Modernizr.testProp = function (prop) {\n            return testProps([prop]);\n        };\n\n        Modernizr.testAllProps = testPropsAll;\n        Modernizr.testStyles = injectElementWithStyles;\n        Modernizr.prefixed = function (prop, obj, elem) {\n            if (!obj) {\n                return testPropsAll(prop, 'pfx');\n            } else {\n                return testPropsAll(prop, obj, elem);\n            }\n        };\n        return Modernizr;\n    })(window, document);\n\n    var fullScreenApi = {\n            ok: false,\n            is: function () {\n                return false;\n            },\n            request: function () {\n            },\n            cancel: function () {\n            },\n            event: '',\n            prefix: ''\n        },\n        browserPrefixes = 'webkit moz o ms khtml'.split(' ');\n\n// check for native support\n    if (typeof document.cancelFullScreen != 'undefined') {\n        fullScreenApi.ok = true;\n    } else {\n        // check for fullscreen support by vendor prefix\n        for (var i = 0, il = browserPrefixes.length; i < il; i++) {\n            fullScreenApi.prefix = browserPrefixes[i];\n            if (typeof document[fullScreenApi.prefix + 'CancelFullScreen'] != 'undefined') {\n                fullScreenApi.ok = true;\n                break;\n            }\n        }\n    }\n\n// update methods to do something useful\n    if (fullScreenApi.ok) {\n        fullScreenApi.event = fullScreenApi.prefix + 'fullscreenchange';\n        fullScreenApi.is = function () {\n            switch (this.prefix) {\n                case '':\n                    return document.fullScreen;\n                case 'webkit':\n                    return document.webkitIsFullScreen;\n                default:\n                    return document[this.prefix + 'FullScreen'];\n            }\n        };\n        fullScreenApi.request = function (el) {\n            return (this.prefix === '') ? el.requestFullScreen() : el[this.prefix + 'RequestFullScreen']();\n        };\n        fullScreenApi.cancel = function (el) {\n            if (!this.is()) {\n                return false;\n            }\n            return (this.prefix === '') ? document.cancelFullScreen() : document[this.prefix + 'CancelFullScreen']();\n        };\n    }\n    /* Bez v1.0.10-g5ae0136\n     * http://github.com/rdallasgray/bez\n     *\n     * A plugin to convert CSS3 cubic-bezier co-ordinates to jQuery-compatible easing functions\n     *\n     * With thanks to Nikolay Nemshilov for clarification on the cubic-bezier maths\n     * See http://st-on-it.blogspot.com/2011/05/calculating-cubic-bezier-function.html\n     *\n     * Copyright 2011 Robert Dallas Gray. All rights reserved.\n     * Provided under the FreeBSD license: https://github.com/rdallasgray/bez/blob/master/LICENSE.txt\n     */\n    function bez(coOrdArray) {\n        var encodedFuncName = \"bez_\" + $.makeArray(arguments).join(\"_\").replace(\".\", \"p\");\n        if (typeof $['easing'][encodedFuncName] !== \"function\") {\n            var polyBez = function (p1, p2) {\n                var A = [null, null],\n                    B = [null, null],\n                    C = [null, null],\n                    bezCoOrd = function (t, ax) {\n                        C[ax] = 3 * p1[ax];\n                        B[ax] = 3 * (p2[ax] - p1[ax]) - C[ax];\n                        A[ax] = 1 - C[ax] - B[ax];\n                        return t * (C[ax] + t * (B[ax] + t * A[ax]));\n                    },\n                    xDeriv = function (t) {\n                        return C[0] + t * (2 * B[0] + 3 * A[0] * t);\n                    },\n                    xForT = function (t) {\n                        var x = t, i = 0, z;\n                        while (++i < 14) {\n                            z = bezCoOrd(x, 0) - t;\n                            if (Math.abs(z) < 1e-3) break;\n                            x -= z / xDeriv(x);\n                        }\n                        return x;\n                    };\n                return function (t) {\n                    return bezCoOrd(xForT(t), 1);\n                }\n            };\n            $['easing'][encodedFuncName] = function (x, t, b, c, d) {\n                return c * polyBez([coOrdArray[0], coOrdArray[1]], [coOrdArray[2], coOrdArray[3]])(t / d) + b;\n            }\n        }\n        return encodedFuncName;\n    }\n\n    var $WINDOW = $(window),\n        $DOCUMENT = $(document),\n        $HTML,\n        $BODY,\n\n        QUIRKS_FORCE = location.hash.replace('#', '') === 'quirks',\n        TRANSFORMS3D = Modernizr.csstransforms3d,\n        CSS3 = TRANSFORMS3D && !QUIRKS_FORCE,\n        COMPAT = TRANSFORMS3D || document.compatMode === 'CSS1Compat',\n        FULLSCREEN = fullScreenApi.ok,\n\n        MOBILE = navigator.userAgent.match(/Android|webOS|iPhone|iPad|iPod|BlackBerry|Windows Phone/i),\n        SLOW = !CSS3 || MOBILE,\n\n        MS_POINTER = navigator.msPointerEnabled,\n\n        WHEEL = \"onwheel\" in document.createElement(\"div\") ? \"wheel\" : document.onmousewheel !== undefined ? \"mousewheel\" : \"DOMMouseScroll\",\n\n        TOUCH_TIMEOUT = 250,\n        TRANSITION_DURATION = 300,\n\n        SCROLL_LOCK_TIMEOUT = 1400,\n\n        AUTOPLAY_INTERVAL = 5000,\n        MARGIN = 2,\n        THUMB_SIZE = 64,\n\n        WIDTH = 500,\n        HEIGHT = 333,\n\n        STAGE_FRAME_KEY = '$stageFrame',\n        NAV_DOT_FRAME_KEY = '$navDotFrame',\n        NAV_THUMB_FRAME_KEY = '$navThumbFrame',\n\n        AUTO = 'auto',\n\n        BEZIER = bez([.1, 0, .25, 1]),\n\n        MAX_WIDTH = 1200,\n\n        /**\n         * Number of thumbnails in slide. Calculated only on setOptions and resize.\n         * @type {number}\n         */\n        thumbsPerSlide = 1,\n\n        OPTIONS = {\n\n            /**\n             * Set width for gallery.\n             * Default value - width of first image\n             * Number - set value in px\n             * String - set value in quotes\n             *\n             */\n            width: null,\n\n            /**\n             * Set min-width for gallery\n             *\n             */\n            minwidth: null,\n\n            /**\n             * Set max-width for gallery\n             *\n             */\n            maxwidth: '100%',\n\n            /**\n             * Set height for gallery\n             * Default value - height of first image\n             * Number - set value in px\n             * String - set value in quotes\n             *\n             */\n            height: null,\n\n            /**\n             * Set min-height for gallery\n             *\n             */\n            minheight: null,\n\n            /**\n             * Set max-height for gallery\n             *\n             */\n            maxheight: null,\n\n            /**\n             * Set proportion ratio for gallery depends of image\n             *\n             */\n            ratio: null, // '16/9' || 500/333 || 1.5\n\n            margin: MARGIN,\n\n            nav: 'dots', // 'thumbs' || false\n            navposition: 'bottom', // 'top'\n            navwidth: null,\n            thumbwidth: THUMB_SIZE,\n            thumbheight: THUMB_SIZE,\n            thumbmargin: MARGIN,\n            thumbborderwidth: MARGIN,\n\n            allowfullscreen: false, // true || 'native'\n\n            transition: 'slide', // 'crossfade' || 'dissolve'\n            clicktransition: null,\n            transitionduration: TRANSITION_DURATION,\n\n            captions: true,\n\n            startindex: 0,\n\n            loop: false,\n\n            autoplay: false,\n            stopautoplayontouch: true,\n\n            keyboard: false,\n\n            arrows: true,\n            click: true,\n            swipe: false,\n            trackpad: false,\n\n            shuffle: false,\n\n            direction: 'ltr', // 'rtl'\n\n            shadows: true,\n\n            showcaption: true,\n\n            /**\n             * Set type of thumbnail navigation\n             */\n            navdir: 'horizontal',\n\n            /**\n             * Set configuration to show or hide arrows in thumb navigation\n             */\n            navarrows: true,\n\n            /**\n             * Set type of navigation. Can be thumbs or slides\n             */\n            navtype: 'thumbs'\n\n        },\n\n        KEYBOARD_OPTIONS = {\n            left: true,\n            right: true,\n            down: true,\n            up: true,\n            space: false,\n            home: false,\n            end: false\n        };\n\n    function noop() {\n    }\n\n    function minMaxLimit(value, min, max) {\n        return Math.max(isNaN(min) ? -Infinity : min, Math.min(isNaN(max) ? Infinity : max, value));\n    }\n\n    function readTransform(css, dir) {\n        return css.match(/ma/) && css.match(/-?\\d+(?!d)/g)[css.match(/3d/) ?\n                (dir === 'vertical' ? 13 : 12) : (dir === 'vertical' ? 5 : 4)\n                ]\n    }\n\n    function readPosition($el, dir) {\n        if (CSS3) {\n            return +readTransform($el.css('transform'), dir);\n        } else {\n            return +$el.css(dir === 'vertical' ? 'top' : 'left').replace('px', '');\n        }\n    }\n\n    function getTranslate(pos, direction) {\n        var obj = {};\n\n        if (CSS3) {\n\n            switch (direction) {\n                case 'vertical':\n                    obj.transform = 'translate3d(0, ' + (pos) + 'px,0)';\n                    break;\n                case 'list':\n                    break;\n                default :\n                    obj.transform = 'translate3d(' + (pos) + 'px,0,0)';\n                    break;\n            }\n        } else {\n            direction === 'vertical' ?\n                obj.top = pos :\n                obj.left = pos;\n        }\n        return obj;\n    }\n\n    function getDuration(time) {\n        return {'transition-duration': time + 'ms'};\n    }\n\n    function unlessNaN(value, alternative) {\n        return isNaN(value) ? alternative : value;\n    }\n\n    function numberFromMeasure(value, measure) {\n        return unlessNaN(+String(value).replace(measure || 'px', ''));\n    }\n\n    function numberFromPercent(value) {\n        return /%$/.test(value) ? numberFromMeasure(value, '%') : undefined;\n    }\n\n    function numberFromWhatever(value, whole) {\n        return unlessNaN(numberFromPercent(value) / 100 * whole, numberFromMeasure(value));\n    }\n\n    function measureIsValid(value) {\n        return (!isNaN(numberFromMeasure(value)) || !isNaN(numberFromMeasure(value, '%'))) && value;\n    }\n\n    function getPosByIndex(index, side, margin, baseIndex) {\n\n        return (index - (baseIndex || 0)) * (side + (margin || 0));\n    }\n\n    function getIndexByPos(pos, side, margin, baseIndex) {\n        return -Math.round(pos / (side + (margin || 0)) - (baseIndex || 0));\n    }\n\n    function bindTransitionEnd($el) {\n        var elData = $el.data();\n\n        if (elData.tEnd) return;\n\n        var el = $el[0],\n            transitionEndEvent = {\n                WebkitTransition: 'webkitTransitionEnd',\n                MozTransition: 'transitionend',\n                OTransition: 'oTransitionEnd otransitionend',\n                msTransition: 'MSTransitionEnd',\n                transition: 'transitionend'\n            };\n        addEvent(el, transitionEndEvent[Modernizr.prefixed('transition')], function (e) {\n            elData.tProp && e.propertyName.match(elData.tProp) && elData.onEndFn();\n        });\n        elData.tEnd = true;\n    }\n\n    function afterTransition($el, property, fn, time) {\n        var ok,\n            elData = $el.data();\n\n        if (elData) {\n            elData.onEndFn = function () {\n                if (ok) return;\n                ok = true;\n                clearTimeout(elData.tT);\n                fn();\n            };\n            elData.tProp = property;\n\n            // Passive call, just in case of fail of native transition-end event\n            clearTimeout(elData.tT);\n            elData.tT = setTimeout(function () {\n                elData.onEndFn();\n            }, time * 1.5);\n\n            bindTransitionEnd($el);\n        }\n    }\n\n\n    function stop($el, pos/*, _001*/) {\n        var dir = $el.navdir || 'horizontal';\n        if ($el.length) {\n            var elData = $el.data();\n            if (CSS3) {\n                $el.css(getDuration(0));\n                elData.onEndFn = noop;\n                clearTimeout(elData.tT);\n            } else {\n                $el.stop();\n            }\n            var lockedPos = getNumber(pos, function () {\n                return readPosition($el, dir);\n            });\n\n            $el.css(getTranslate(lockedPos, dir/*, _001*/));//.width(); // `.width()` for reflow\n            return lockedPos;\n        }\n    }\n\n    function getNumber() {\n        var number;\n        for (var _i = 0, _l = arguments.length; _i < _l; _i++) {\n            number = _i ? arguments[_i]() : arguments[_i];\n            if (typeof number === 'number') {\n                break;\n            }\n        }\n\n        return number;\n    }\n\n    function edgeResistance(pos, edge) {\n        return Math.round(pos + ((edge - pos) / 1.5));\n    }\n\n    function getProtocol() {\n        getProtocol.p = getProtocol.p || (location.protocol === 'https:' ? 'https://' : 'http://');\n        return getProtocol.p;\n    }\n\n    function parseHref(href) {\n        var a = document.createElement('a');\n        a.href = href;\n        return a;\n    }\n\n    function findVideoId(href, forceVideo) {\n        if (typeof href !== 'string') return href;\n        href = parseHref(href);\n\n        var id,\n            type;\n\n        if (href.host.match(/youtube\\.com/) && href.search) {\n            //.log();\n            id = href.search.split('v=')[1];\n            if (id) {\n                var ampersandPosition = id.indexOf('&');\n                if (ampersandPosition !== -1) {\n                    id = id.substring(0, ampersandPosition);\n                }\n                type = 'youtube';\n            }\n        } else if (href.host.match(/youtube\\.com|youtu\\.be|youtube-nocookie.com/)) {\n            id = href.pathname.replace(/^\\/(embed\\/|v\\/)?/, '').replace(/\\/.*/, '');\n            type = 'youtube';\n        } else if (href.host.match(/vimeo\\.com/)) {\n            type = 'vimeo';\n            id = href.pathname.replace(/^\\/(video\\/)?/, '').replace(/\\/.*/, '');\n        }\n\n        if ((!id || !type) && forceVideo) {\n            id = href.href;\n            type = 'custom';\n        }\n\n        return id ? {id: id, type: type, s: href.search.replace(/^\\?/, ''), p: getProtocol()} : false;\n    }\n\n    function getVideoThumbs(dataFrame, data, fotorama) {\n        var img, thumb, video = dataFrame.video;\n        if (video.type === 'youtube') {\n            thumb = getProtocol() + 'img.youtube.com/vi/' + video.id + '/default.jpg';\n            img = thumb.replace(/\\/default.jpg$/, '/hqdefault.jpg');\n            dataFrame.thumbsReady = true;\n        } else if (video.type === 'vimeo') {\n            $.ajax({\n                url: getProtocol() + 'vimeo.com/api/oembed.json',\n                data: {\n                    url: 'https://vimeo.com/' + video.id\n                },\n                dataType: 'jsonp',\n                success: function (json) {\n                    dataFrame.thumbsReady = true;\n                    updateData(data, {\n                        img: json[0].thumbnail_url,\n                        thumb: json[0].thumbnail_url\n                    }, dataFrame.i, fotorama);\n                }\n            });\n        } else {\n            dataFrame.thumbsReady = true;\n        }\n\n        return {\n            img: img,\n            thumb: thumb\n        }\n    }\n\n    function updateData(data, _dataFrame, i, fotorama) {\n        for (var _i = 0, _l = data.length; _i < _l; _i++) {\n            var dataFrame = data[_i];\n\n            if (dataFrame.i === i && dataFrame.thumbsReady) {\n                var clear = {videoReady: true};\n                clear[STAGE_FRAME_KEY] = clear[NAV_THUMB_FRAME_KEY] = clear[NAV_DOT_FRAME_KEY] = false;\n\n                fotorama.splice(_i, 1, $.extend(\n                    {},\n                    dataFrame,\n                    clear,\n                    _dataFrame\n                ));\n\n                break;\n            }\n        }\n    }\n\n    function getDataFromHtml($el) {\n        var data = [];\n\n        function getDataFromImg($img, imgData, checkVideo) {\n            var $child = $img.children('img').eq(0),\n                _imgHref = $img.attr('href'),\n                _imgSrc = $img.attr('src'),\n                _thumbSrc = $child.attr('src'),\n                _video = imgData.video,\n                video = checkVideo ? findVideoId(_imgHref, _video === true) : false;\n\n            if (video) {\n                _imgHref = false;\n            } else {\n                video = _video;\n            }\n\n            getDimensions($img, $child, $.extend(imgData, {\n                video: video,\n                img: imgData.img || _imgHref || _imgSrc || _thumbSrc,\n                thumb: imgData.thumb || _thumbSrc || _imgSrc || _imgHref\n            }));\n        }\n\n        function getDimensions($img, $child, imgData) {\n            var separateThumbFLAG = imgData.thumb && imgData.img !== imgData.thumb,\n                width = numberFromMeasure(imgData.width || $img.attr('width')),\n                height = numberFromMeasure(imgData.height || $img.attr('height'));\n\n            $.extend(imgData, {\n                width: width,\n                height: height,\n                thumbratio: getRatio(imgData.thumbratio || (numberFromMeasure(imgData.thumbwidth || ($child && $child.attr('width')) || separateThumbFLAG || width) / numberFromMeasure(imgData.thumbheight || ($child && $child.attr('height')) || separateThumbFLAG || height)))\n            });\n        }\n\n        $el.children().each(function () {\n            var $this = $(this),\n                dataFrame = optionsToLowerCase($.extend($this.data(), {id: $this.attr('id')}));\n            if ($this.is('a, img')) {\n                getDataFromImg($this, dataFrame, true);\n            } else if (!$this.is(':empty')) {\n                getDimensions($this, null, $.extend(dataFrame, {\n                    html: this,\n                    _html: $this.html() // Because of IE\n                }));\n            } else return;\n\n            data.push(dataFrame);\n        });\n\n        return data;\n    }\n\n    function isHidden(el) {\n        return el.offsetWidth === 0 && el.offsetHeight === 0;\n    }\n\n    function isDetached(el) {\n        return !$.contains(document.documentElement, el);\n    }\n\n    function waitFor(test, fn, timeout, i) {\n        if (!waitFor.i) {\n            waitFor.i = 1;\n            waitFor.ii = [true];\n        }\n\n        i = i || waitFor.i;\n\n        if (typeof waitFor.ii[i] === 'undefined') {\n            waitFor.ii[i] = true;\n        }\n\n        if (test()) {\n            fn();\n        } else {\n            waitFor.ii[i] && setTimeout(function () {\n                waitFor.ii[i] && waitFor(test, fn, timeout, i);\n            }, timeout || 100);\n        }\n\n        return waitFor.i++;\n    }\n\n    waitFor.stop = function (i) {\n        waitFor.ii[i] = false;\n    };\n\n    function fit($el, measuresToFit) {\n        var elData = $el.data(),\n            measures = elData.measures;\n\n        if (measures && (!elData.l ||\n            elData.l.W !== measures.width ||\n            elData.l.H !== measures.height ||\n            elData.l.r !== measures.ratio ||\n            elData.l.w !== measuresToFit.w ||\n            elData.l.h !== measuresToFit.h)) {\n\n            var height = minMaxLimit(measuresToFit.h, 0, measures.height),\n                width = height * measures.ratio;\n\n            UTIL.setRatio($el, width, height);\n\n            elData.l = {\n                W: measures.width,\n                H: measures.height,\n                r: measures.ratio,\n                w: measuresToFit.w,\n                h: measuresToFit.h\n            };\n        }\n\n        return true;\n    }\n\n    function setStyle($el, style) {\n        var el = $el[0];\n        if (el.styleSheet) {\n            el.styleSheet.cssText = style;\n        } else {\n            $el.html(style);\n        }\n    }\n\n    function findShadowEdge(pos, min, max, dir) {\n        return min === max ? false :\n            dir === 'vertical' ?\n                (pos <= min ? 'top' : pos >= max ? 'bottom' : 'top bottom') :\n                (pos <= min ? 'left' : pos >= max ? 'right' : 'left right');\n    }\n\n    function smartClick($el, fn, _options) {\n        _options = _options || {};\n\n        $el.each(function () {\n            var $this = $(this),\n                thisData = $this.data(),\n                startEvent;\n\n            if (thisData.clickOn) return;\n\n            thisData.clickOn = true;\n\n            $.extend(touch($this, {\n                onStart: function (e) {\n                    startEvent = e;\n                    (_options.onStart || noop).call(this, e);\n                },\n                onMove: _options.onMove || noop,\n                onTouchEnd: _options.onTouchEnd || noop,\n                onEnd: function (result) {\n                    if (result.moved) return;\n                    fn.call(this, startEvent);\n                }\n            }), {noMove: true});\n        });\n    }\n\n    function div(classes, child) {\n        return '<div class=\"' + classes + '\">' + (child || '') + '</div>';\n    }\n\n\n    /**\n     * Function transforming into valid classname\n     * @param className - name of the class\n     * @returns {string} - dom format of class name\n     */\n    function cls(className) {\n        return \".\" + className;\n    }\n\n    /**\n     *\n     * @param {json-object} videoItem Parsed object from data.video item or href from link a in input dates\n     * @returns {string} DOM view of video iframe\n     */\n    function createVideoFrame(videoItem) {\n        var frame = '<iframe src=\"' + videoItem.p + videoItem.type + '.com/embed/' + videoItem.id + '\" frameborder=\"0\" allowfullscreen></iframe>';\n        return frame;\n    }\n\n// Fisher\u2013Yates Shuffle\n// http://bost.ocks.org/mike/shuffle/\n    function shuffle(array) {\n        // While there remain elements to shuffle\n        var l = array.length;\n        while (l) {\n            // Pick a remaining element\n            var i = Math.floor(Math.random() * l--);\n\n            // And swap it with the current element\n            var t = array[l];\n            array[l] = array[i];\n            array[i] = t;\n        }\n\n        return array;\n    }\n\n    function clone(array) {\n        return Object.prototype.toString.call(array) == '[object Array]'\n            && $.map(array, function (frame) {\n                return $.extend({}, frame);\n            });\n    }\n\n    function lockScroll($el, left, top) {\n        $el\n            .scrollLeft(left || 0)\n            .scrollTop(top || 0);\n    }\n\n    function optionsToLowerCase(options) {\n        if (options) {\n            var opts = {};\n            $.each(options, function (key, value) {\n                opts[key.toLowerCase()] = value;\n            });\n\n            return opts;\n        }\n    }\n\n    function getRatio(_ratio) {\n        if (!_ratio) return;\n        var ratio = +_ratio;\n        if (!isNaN(ratio)) {\n            return ratio;\n        } else {\n            ratio = _ratio.split('/');\n            return +ratio[0] / +ratio[1] || undefined;\n        }\n    }\n\n    function addEvent(el, e, fn, bool) {\n        if (!e) return;\n        el.addEventListener ? el.addEventListener(e, fn, {passive: true}) : el.attachEvent('on' + e, fn);\n    }\n\n    /**\n     *\n     * @param position guess position for navShaft\n     * @param restriction object contains min and max values for position\n     * @returns {*} filtered value of position\n     */\n    function validateRestrictions(position, restriction) {\n        if (position > restriction.max) {\n            position = restriction.max;\n        } else {\n            if (position < restriction.min) {\n                position = restriction.min;\n            }\n        }\n        return position;\n    }\n\n    function validateSlidePos(opt, navShaftTouchTail, guessIndex, offsetNav, $guessNavFrame, $navWrap, dir) {\n        var position,\n            size,\n            wrapSize;\n        if (dir === 'horizontal') {\n            size = opt.thumbwidth;\n            wrapSize = $navWrap.width();\n        } else {\n            size = opt.thumbheight;\n            wrapSize = $navWrap.height();\n        }\n        if ( (size + opt.margin) * (guessIndex + 1) >= (wrapSize - offsetNav) ) {\n            if (dir === 'horizontal') {\n                position = -$guessNavFrame.position().left;\n            } else {\n                position = -$guessNavFrame.position().top;\n            }\n        } else {\n            if ((size + opt.margin) * (guessIndex) <= Math.abs(offsetNav)) {\n                if (dir === 'horizontal') {\n                    position = -$guessNavFrame.position().left + wrapSize - (size + opt.margin);\n                } else {\n                    position = -$guessNavFrame.position().top + wrapSize - (size + opt.margin);\n                }\n            } else {\n                position = offsetNav;\n            }\n        }\n        position = validateRestrictions(position, navShaftTouchTail);\n\n        return position || 0;\n    }\n\n    function elIsDisabled(el) {\n        return !!el.getAttribute('disabled');\n    }\n\n    function disableAttr(FLAG, disable) {\n        if (disable) {\n            return {disabled: FLAG};\n        } else {\n            return {tabindex: FLAG * -1 + '', disabled: FLAG};\n\n        }\n    }\n\n    function addEnterUp(el, fn) {\n        addEvent(el, 'keyup', function (e) {\n            elIsDisabled(el) || e.keyCode == 13 && fn.call(el, e);\n        });\n    }\n\n    function addFocus(el, fn) {\n        addEvent(el, 'focus', el.onfocusin = function (e) {\n            fn.call(el, e);\n        }, true);\n    }\n\n    function stopEvent(e, stopPropagation) {\n        e.preventDefault ? e.preventDefault() : (e.returnValue = false);\n        stopPropagation && e.stopPropagation && e.stopPropagation();\n    }\n\n    function getDirectionSign(forward) {\n        return forward ? '>' : '<';\n    }\n\n    var UTIL = (function () {\n\n        function setRatioClass($el, wh, ht) {\n            var rateImg = wh / ht;\n\n            if (rateImg <= 1) {\n                $el.parent().removeClass(horizontalImageClass);\n                $el.parent().addClass(verticalImageClass);\n            } else {\n                $el.parent().removeClass(verticalImageClass);\n                $el.parent().addClass(horizontalImageClass);\n            }\n        }\n\n        /**\n         * Set specific attribute in thumbnail template\n         * @param $frame DOM item of specific thumbnail\n         * @param value Value which must be setted into specific attribute\n         * @param searchAttr Name of attribute where value must be included\n         */\n        function setThumbAttr($frame, value, searchAttr) {\n            var attr = searchAttr;\n\n            if (!$frame.attr(attr) && $frame.attr(attr) !== undefined) {\n                $frame.attr(attr, value);\n            }\n\n            if ($frame.find(\"[\" + attr + \"]\").length) {\n                $frame.find(\"[\" + attr + \"]\")\n                    .each(function () {\n                        $(this).attr(attr, value);\n                    });\n            }\n        }\n\n        /**\n         * Method describe behavior need to render caption on preview or not\n         * @param frameItem specific item from data\n         * @param isExpected {bool} if items with caption need render them or not\n         * @returns {boolean} if true then caption should be rendered\n         */\n        function isExpectedCaption(frameItem, isExpected, undefined) {\n            var expected = false,\n                frameExpected;\n\n            frameItem.showCaption === undefined || frameItem.showCaption === true ? frameExpected = true : frameExpected = false;\n\n            if (!isExpected) {\n                return false;\n            }\n\n            if (frameItem.caption && frameExpected) {\n                expected = true;\n            }\n\n            return expected;\n        }\n\n        return {\n            setRatio: setRatioClass,\n            setThumbAttr: setThumbAttr,\n            isExpectedCaption: isExpectedCaption\n        };\n\n    }(UTIL || {}, jQuery));\n\n    function slide($el, options) {\n        var elData = $el.data(),\n            elPos = Math.round(options.pos),\n            onEndFn = function () {\n                if (elData && elData.sliding) {\n                    elData.sliding = false;\n                }\n                (options.onEnd || noop)();\n            };\n\n        if (typeof options.overPos !== 'undefined' && options.overPos !== options.pos) {\n            elPos = options.overPos;\n        }\n\n        var translate = $.extend(getTranslate(elPos, options.direction), options.width && {width: options.width}, options.height && {height: options.height});\n        if (elData && elData.sliding) {\n            elData.sliding = true;\n        }\n\n        if (CSS3) {\n            $el.css($.extend(getDuration(options.time), translate));\n\n            if (options.time > 10) {\n                afterTransition($el, 'transform', onEndFn, options.time);\n            } else {\n                onEndFn();\n            }\n        } else {\n            $el.stop().animate(translate, options.time, BEZIER, onEndFn);\n        }\n    }\n\n    function fade($el1, $el2, $frames, options, fadeStack, chain) {\n        var chainedFLAG = typeof chain !== 'undefined';\n        if (!chainedFLAG) {\n            fadeStack.push(arguments);\n            Array.prototype.push.call(arguments, fadeStack.length);\n            if (fadeStack.length > 1) return;\n        }\n\n        $el1 = $el1 || $($el1);\n        $el2 = $el2 || $($el2);\n\n        var _$el1 = $el1[0],\n            _$el2 = $el2[0],\n            crossfadeFLAG = options.method === 'crossfade',\n            onEndFn = function () {\n                if (!onEndFn.done) {\n                    onEndFn.done = true;\n                    var args = (chainedFLAG || fadeStack.shift()) && fadeStack.shift();\n                    args && fade.apply(this, args);\n                    (options.onEnd || noop)(!!args);\n                }\n            },\n            time = options.time / (chain || 1);\n\n        $frames.removeClass(fadeRearClass + ' ' + fadeFrontClass);\n\n        $el1\n            .stop()\n            .addClass(fadeRearClass);\n        $el2\n            .stop()\n            .addClass(fadeFrontClass);\n\n        crossfadeFLAG && _$el2 && $el1.fadeTo(0, 0);\n\n        $el1.fadeTo(crossfadeFLAG ? time : 0, 1, crossfadeFLAG && onEndFn);\n        $el2.fadeTo(time, 0, onEndFn);\n\n        (_$el1 && crossfadeFLAG) || _$el2 || onEndFn();\n    }\n\n    var lastEvent,\n        moveEventType,\n        preventEvent,\n        preventEventTimeout,\n        dragDomEl;\n\n    function extendEvent(e) {\n        var touch = (e.touches || [])[0] || e;\n        e._x = touch.pageX || touch.originalEvent.pageX;\n        e._y = touch.clientY || touch.originalEvent.clientY;\n        e._now = $.now();\n    }\n\n    function touch($el, options) {\n        var el = $el[0],\n            tail = {},\n            touchEnabledFLAG,\n            startEvent,\n            $target,\n            controlTouch,\n            touchFLAG,\n            targetIsSelectFLAG,\n            targetIsLinkFlag,\n            isDisabledSwipe,\n            tolerance,\n            moved;\n\n        function onStart(e) {\n            $target = $(e.target);\n            tail.checked = targetIsSelectFLAG = targetIsLinkFlag = isDisabledSwipe = moved = false;\n\n            if (touchEnabledFLAG\n                || tail.flow\n                || (e.touches && e.touches.length > 1)\n                || e.which > 1\n                || (lastEvent && lastEvent.type !== e.type && preventEvent)\n                || (targetIsSelectFLAG = options.select && $target.is(options.select, el))) return targetIsSelectFLAG;\n\n            touchFLAG = e.type === 'touchstart';\n            targetIsLinkFlag = $target.is('a, a *', el);\n            isDisabledSwipe = $target.hasClass('disableSwipe');\n            controlTouch = tail.control;\n\n            tolerance = (tail.noMove || tail.noSwipe || controlTouch) ? 16 : !tail.snap ? 4 : 0;\n\n            extendEvent(e);\n\n            startEvent = lastEvent = e;\n            moveEventType = e.type.replace(/down|start/, 'move').replace(/Down/, 'Move');\n\n            (options.onStart || noop).call(el, e, {control: controlTouch, $target: $target});\n\n            touchEnabledFLAG = tail.flow = true;\n\n            if (!isDisabledSwipe && (!touchFLAG || tail.go)) stopEvent(e);\n        }\n\n        function onMove(e) {\n            if ((e.touches && e.touches.length > 1)\n                || (MS_POINTER && !e.isPrimary)\n                || moveEventType !== e.type\n                || !touchEnabledFLAG) {\n                touchEnabledFLAG && onEnd();\n                (options.onTouchEnd || noop)();\n                return;\n            }\n\n            isDisabledSwipe = $(e.target).hasClass('disableSwipe');\n\n            if (isDisabledSwipe) {\n                return;\n            }\n\n            extendEvent(e);\n\n            var xDiff = Math.abs(e._x - startEvent._x), // opt _x \u2192 _pageX\n                yDiff = Math.abs(e._y - startEvent._y),\n                xyDiff = xDiff - yDiff,\n                xWin = (tail.go || tail.x || xyDiff >= 0) && !tail.noSwipe,\n                yWin = xyDiff < 0;\n\n            if (touchFLAG && !tail.checked) {\n                if (touchEnabledFLAG = xWin) {\n                    stopEvent(e);\n                }\n            } else {\n                stopEvent(e);\n                if (movedEnough(xDiff,yDiff)) {\n                    (options.onMove || noop).call(el, e, {touch: touchFLAG});\n                }\n            }\n\n            if (!moved && movedEnough(xDiff, yDiff) && Math.sqrt(Math.pow(xDiff, 2) + Math.pow(yDiff, 2)) > tolerance) {\n                moved = true;\n            }\n\n            tail.checked = tail.checked || xWin || yWin;\n        }\n\n        function movedEnough(xDiff, yDiff) {\n            return xDiff > yDiff && xDiff > 1.5;\n        }\n\n        function onEnd(e) {\n            (options.onTouchEnd || noop)();\n\n            var _touchEnabledFLAG = touchEnabledFLAG;\n            tail.control = touchEnabledFLAG = false;\n\n            if (_touchEnabledFLAG) {\n                tail.flow = false;\n            }\n\n            if (!_touchEnabledFLAG || (targetIsLinkFlag && !tail.checked)) return;\n\n            e && stopEvent(e);\n\n            preventEvent = true;\n            clearTimeout(preventEventTimeout);\n            preventEventTimeout = setTimeout(function () {\n                preventEvent = false;\n            }, 1000);\n\n            (options.onEnd || noop).call(el, {\n                moved: moved,\n                $target: $target,\n                control: controlTouch,\n                touch: touchFLAG,\n                startEvent: startEvent,\n                aborted: !e || e.type === 'MSPointerCancel'\n            });\n        }\n\n        function onOtherStart() {\n            if (tail.flow) return;\n            tail.flow = true;\n        }\n\n        function onOtherEnd() {\n            if (!tail.flow) return;\n            tail.flow = false;\n        }\n\n        if (MS_POINTER) {\n            addEvent(el, 'MSPointerDown', onStart);\n            addEvent(document, 'MSPointerMove', onMove);\n            addEvent(document, 'MSPointerCancel', onEnd);\n            addEvent(document, 'MSPointerUp', onEnd);\n        } else {\n            addEvent(el, 'touchstart', onStart);\n            addEvent(el, 'touchmove', onMove);\n            addEvent(el, 'touchend', onEnd);\n\n            addEvent(document, 'touchstart', onOtherStart);\n            addEvent(document, 'touchend', onOtherEnd);\n            addEvent(document, 'touchcancel', onOtherEnd);\n\n            $WINDOW.on('scroll', onOtherEnd);\n\n            $el.on('mousedown', onStart);\n            $DOCUMENT\n                .on('mousemove', onMove)\n                .on('mouseup', onEnd);\n        }\n        if (Modernizr.touch) {\n            dragDomEl = 'a';\n        } else {\n            dragDomEl = 'div';\n        }\n        $el.on('click', dragDomEl, function (e) {\n            tail.checked && stopEvent(e);\n        });\n\n        return tail;\n    }\n\n    function moveOnTouch($el, options) {\n        var el = $el[0],\n            elData = $el.data(),\n            tail = {},\n            startCoo,\n            coo,\n            startElPos,\n            moveElPos,\n            edge,\n            moveTrack,\n            startTime,\n            endTime,\n            min,\n            max,\n            snap,\n            dir,\n            slowFLAG,\n            controlFLAG,\n            moved,\n            tracked;\n\n        function startTracking(e, noStop) {\n            tracked = true;\n            startCoo = coo = (dir === 'vertical') ? e._y : e._x;\n            startTime = e._now;\n\n            moveTrack = [\n                [startTime, startCoo]\n            ];\n\n            startElPos = moveElPos = tail.noMove || noStop ? 0 : stop($el, (options.getPos || noop)()/*, options._001*/);\n\n            (options.onStart || noop).call(el, e);\n        }\n\n        function onStart(e, result) {\n            min = tail.min;\n            max = tail.max;\n            snap = tail.snap,\n                dir = tail.direction || 'horizontal',\n                $el.navdir = dir;\n\n            slowFLAG = e.altKey;\n            tracked = moved = false;\n\n            controlFLAG = result.control;\n\n            if (!controlFLAG && !elData.sliding) {\n                startTracking(e);\n            }\n        }\n\n        function onMove(e, result) {\n            if (!tail.noSwipe) {\n                if (!tracked) {\n                    startTracking(e);\n                }\n                coo = (dir === 'vertical') ? e._y : e._x;\n\n                moveTrack.push([e._now, coo]);\n\n                moveElPos = startElPos - (startCoo - coo);\n\n                edge = findShadowEdge(moveElPos, min, max, dir);\n\n                if (moveElPos <= min) {\n                    moveElPos = edgeResistance(moveElPos, min);\n                } else if (moveElPos >= max) {\n                    moveElPos = edgeResistance(moveElPos, max);\n                }\n\n                if (!tail.noMove) {\n                    $el.css(getTranslate(moveElPos, dir));\n                    if (!moved) {\n                        moved = true;\n                        // only for mouse\n                        result.touch || MS_POINTER || $el.addClass(grabbingClass);\n                    }\n\n                    (options.onMove || noop).call(el, e, {pos: moveElPos, edge: edge});\n                }\n            }\n        }\n\n        function onEnd(result) {\n            if (tail.noSwipe && result.moved) return;\n\n            if (!tracked) {\n                startTracking(result.startEvent, true);\n            }\n\n            result.touch || MS_POINTER || $el.removeClass(grabbingClass);\n\n            endTime = $.now();\n\n            var _backTimeIdeal = endTime - TOUCH_TIMEOUT,\n                _backTime,\n                _timeDiff,\n                _timeDiffLast,\n                backTime = null,\n                backCoo,\n                virtualPos,\n                limitPos,\n                newPos,\n                overPos,\n                time = TRANSITION_DURATION,\n                speed,\n                friction = options.friction;\n\n            for (var _i = moveTrack.length - 1; _i >= 0; _i--) {\n                _backTime = moveTrack[_i][0];\n                _timeDiff = Math.abs(_backTime - _backTimeIdeal);\n                if (backTime === null || _timeDiff < _timeDiffLast) {\n                    backTime = _backTime;\n                    backCoo = moveTrack[_i][1];\n                } else if (backTime === _backTimeIdeal || _timeDiff > _timeDiffLast) {\n                    break;\n                }\n                _timeDiffLast = _timeDiff;\n            }\n\n            newPos = minMaxLimit(moveElPos, min, max);\n\n            var cooDiff = backCoo - coo,\n                forwardFLAG = cooDiff >= 0,\n                timeDiff = endTime - backTime,\n                longTouchFLAG = timeDiff > TOUCH_TIMEOUT,\n                swipeFLAG = !longTouchFLAG && moveElPos !== startElPos && newPos === moveElPos;\n\n            if (snap) {\n                newPos = minMaxLimit(Math[swipeFLAG ? (forwardFLAG ? 'floor' : 'ceil') : 'round'](moveElPos / snap) * snap, min, max);\n                min = max = newPos;\n            }\n\n            if (swipeFLAG && (snap || newPos === moveElPos)) {\n                speed = -(cooDiff / timeDiff);\n                time *= minMaxLimit(Math.abs(speed), options.timeLow, options.timeHigh);\n                virtualPos = Math.round(moveElPos + speed * time / friction);\n\n                if (!snap) {\n                    newPos = virtualPos;\n                }\n\n                if (!forwardFLAG && virtualPos > max || forwardFLAG && virtualPos < min) {\n                    limitPos = forwardFLAG ? min : max;\n                    overPos = virtualPos - limitPos;\n                    if (!snap) {\n                        newPos = limitPos;\n                    }\n                    overPos = minMaxLimit(newPos + overPos * .03, limitPos - 50, limitPos + 50);\n                    time = Math.abs((moveElPos - overPos) / (speed / friction));\n                }\n            }\n\n            time *= slowFLAG ? 10 : 1;\n\n            (options.onEnd || noop).call(el, $.extend(result, {\n                moved: result.moved || longTouchFLAG && snap,\n                pos: moveElPos,\n                newPos: newPos,\n                overPos: overPos,\n                time: time,\n                dir: dir\n            }));\n        }\n\n        tail = $.extend(touch(options.$wrap, $.extend({}, options, {\n            onStart: onStart,\n            onMove: onMove,\n            onEnd: onEnd\n        })), tail);\n\n        return tail;\n    }\n\n    function wheel($el, options) {\n        var el = $el[0],\n            lockFLAG,\n            lastDirection,\n            lastNow,\n            tail = {\n                prevent: {}\n            };\n\n        addEvent(el, WHEEL, function (e) {\n            var yDelta = e.wheelDeltaY || -1 * e.deltaY || 0,\n                xDelta = e.wheelDeltaX || -1 * e.deltaX || 0,\n                xWin = Math.abs(xDelta) && !Math.abs(yDelta),\n                direction = getDirectionSign(xDelta < 0),\n                sameDirection = lastDirection === direction,\n                now = $.now(),\n                tooFast = now - lastNow < TOUCH_TIMEOUT;\n\n            lastDirection = direction;\n            lastNow = now;\n\n            if (!xWin || !tail.ok || tail.prevent[direction] && !lockFLAG) {\n                return;\n            } else {\n                stopEvent(e, true);\n                if (lockFLAG && sameDirection && tooFast) {\n                    return;\n                }\n            }\n\n            if (options.shift) {\n                lockFLAG = true;\n                clearTimeout(tail.t);\n                tail.t = setTimeout(function () {\n                    lockFLAG = false;\n                }, SCROLL_LOCK_TIMEOUT);\n            }\n\n            (options.onEnd || noop)(e, options.shift ? direction : xDelta);\n\n        });\n\n        return tail;\n    }\n\n    jQuery.Fotorama = function ($fotorama, opts) {\n        $HTML = $('html');\n        $BODY = $('body');\n\n        var that = this,\n            stamp = $.now(),\n            stampClass = _fotoramaClass + stamp,\n            fotorama = $fotorama[0],\n            data,\n            dataFrameCount = 1,\n            fotoramaData = $fotorama.data(),\n            size,\n\n            $style = $('<style></style>'),\n\n            $anchor = $(div(hiddenClass)),\n            $wrap = $fotorama.find(cls(wrapClass)),\n            $stage = $wrap.find(cls(stageClass)),\n            stage = $stage[0],\n\n            $stageShaft = $fotorama.find(cls(stageShaftClass)),\n            $stageFrame = $(),\n            $arrPrev = $fotorama.find(cls(arrPrevClass)),\n            $arrNext = $fotorama.find(cls(arrNextClass)),\n            $arrs = $fotorama.find(cls(arrClass)),\n            $navWrap = $fotorama.find(cls(navWrapClass)),\n            $nav = $navWrap.find(cls(navClass)),\n            $navShaft = $nav.find(cls(navShaftClass)),\n            $navFrame,\n            $navDotFrame = $(),\n            $navThumbFrame = $(),\n\n            stageShaftData = $stageShaft.data(),\n            navShaftData = $navShaft.data(),\n\n            $thumbBorder = $fotorama.find(cls(thumbBorderClass)),\n            $thumbArrLeft = $fotorama.find(cls(thumbArrLeft)),\n            $thumbArrRight = $fotorama.find(cls(thumbArrRight)),\n\n            $fullscreenIcon = $fotorama.find(cls(fullscreenIconClass)),\n            fullscreenIcon = $fullscreenIcon[0],\n            $videoPlay = $(div(videoPlayClass)),\n            $videoClose = $fotorama.find(cls(videoCloseClass)),\n            videoClose = $videoClose[0],\n\n            $spinner = $fotorama.find(cls(fotoramaSpinnerClass)),\n\n            $videoPlaying,\n\n            activeIndex = false,\n            activeFrame,\n            activeIndexes,\n            repositionIndex,\n            dirtyIndex,\n            lastActiveIndex,\n            prevIndex,\n            nextIndex,\n            nextAutoplayIndex,\n            startIndex,\n\n            o_loop,\n            o_nav,\n            o_navThumbs,\n            o_navTop,\n            o_allowFullScreen,\n            o_nativeFullScreen,\n            o_fade,\n            o_thumbSide,\n            o_thumbSide2,\n            o_transitionDuration,\n            o_transition,\n            o_shadows,\n            o_rtl,\n            o_keyboard,\n            lastOptions = {},\n\n            measures = {},\n            measuresSetFLAG,\n\n            stageShaftTouchTail = {},\n            stageWheelTail = {},\n            navShaftTouchTail = {},\n            navWheelTail = {},\n\n            scrollTop,\n            scrollLeft,\n\n            showedFLAG,\n            pausedAutoplayFLAG,\n            stoppedAutoplayFLAG,\n\n            toDeactivate = {},\n            toDetach = {},\n\n            measuresStash,\n\n            touchedFLAG,\n\n            hoverFLAG,\n\n            navFrameKey,\n            stageLeft = 0,\n\n            fadeStack = [];\n\n        $wrap[STAGE_FRAME_KEY] = $('<div class=\"' + stageFrameClass + '\"></div>');\n        $wrap[NAV_THUMB_FRAME_KEY] = $($.Fotorama.jst.thumb());\n        $wrap[NAV_DOT_FRAME_KEY] = $($.Fotorama.jst.dots());\n\n        toDeactivate[STAGE_FRAME_KEY] = [];\n        toDeactivate[NAV_THUMB_FRAME_KEY] = [];\n        toDeactivate[NAV_DOT_FRAME_KEY] = [];\n        toDetach[STAGE_FRAME_KEY] = {};\n\n        $wrap.addClass(CSS3 ? wrapCss3Class : wrapCss2Class);\n\n        fotoramaData.fotorama = this;\n\n        /**\n         * Search video items in incoming data and transform object for video layout.\n         *\n         */\n        function checkForVideo() {\n            $.each(data, function (i, dataFrame) {\n                if (!dataFrame.i) {\n                    dataFrame.i = dataFrameCount++;\n                    var video = findVideoId(dataFrame.video, true);\n                    if (video) {\n                        var thumbs = {};\n                        dataFrame.video = video;\n                        if (!dataFrame.img && !dataFrame.thumb) {\n                            thumbs = getVideoThumbs(dataFrame, data, that);\n                        } else {\n                            dataFrame.thumbsReady = true;\n                        }\n                        updateData(data, {img: thumbs.img, thumb: thumbs.thumb}, dataFrame.i, that);\n                    }\n                }\n            });\n        }\n\n        /**\n         * Checks if current media object is YouTube or Vimeo video stream\n         * @returns {boolean}\n         */\n        function isVideo() {\n            return $((that.activeFrame || {}).$stageFrame || {}).hasClass('fotorama-video-container');\n        }\n\n        function allowKey(key) {\n            return o_keyboard[key];\n        }\n\n        function setStagePosition() {\n            if ($stage !== undefined) {\n\n                if (opts.navdir == 'vertical') {\n                    var padding = opts.thumbwidth + opts.thumbmargin;\n\n                    $stage.css('left', padding);\n                    $arrNext.css('right', padding);\n                    $fullscreenIcon.css('right', padding);\n                    $wrap.css('width', $wrap.css('width') + padding);\n                    $stageShaft.css('max-width', $wrap.width() - padding);\n                } else {\n                    $stage.css('left', '');\n                    $arrNext.css('right', '');\n                    $fullscreenIcon.css('right', '');\n                    $wrap.css('width', $wrap.css('width') + padding);\n                    $stageShaft.css('max-width', '');\n                }\n            }\n        }\n\n        function bindGlobalEvents(FLAG) {\n            var keydownCommon = 'keydown.' + _fotoramaClass,\n                localStamp = _fotoramaClass + stamp,\n                keydownLocal = 'keydown.' + localStamp,\n                keyupLocal = 'keyup.' + localStamp,\n                resizeLocal = 'resize.' + localStamp + ' ' + 'orientationchange.' + localStamp,\n                showParams;\n\n            if (FLAG) {\n                $DOCUMENT\n                    .on(keydownLocal, function (e) {\n                        var catched,\n                            index;\n\n                        if ($videoPlaying && e.keyCode === 27) {\n                            catched = true;\n                            unloadVideo($videoPlaying, true, true);\n                        } else if (that.fullScreen || (opts.keyboard && !that.index)) {\n                            if (e.keyCode === 27) {\n                                catched = true;\n                                that.cancelFullScreen();\n                            } else if ((e.shiftKey && e.keyCode === 32 && allowKey('space')) || (!e.altKey && !e.metaKey && e.keyCode === 37 && allowKey('left')) || (e.keyCode === 38 && allowKey('up') && $(':focus').attr('data-gallery-role'))) {\n                                that.longPress.progress();\n                                index = '<';\n                            } else if ((e.keyCode === 32 && allowKey('space')) || (!e.altKey && !e.metaKey && e.keyCode === 39 && allowKey('right')) || (e.keyCode === 40 && allowKey('down') && $(':focus').attr('data-gallery-role'))) {\n                                that.longPress.progress();\n                                index = '>';\n                            } else if (e.keyCode === 36 && allowKey('home')) {\n                                that.longPress.progress();\n                                index = '<<';\n                            } else if (e.keyCode === 35 && allowKey('end')) {\n                                that.longPress.progress();\n                                index = '>>';\n                            }\n                        }\n\n                        (catched || index) && stopEvent(e);\n                        showParams = {index: index, slow: e.altKey, user: true};\n                        index && (that.longPress.inProgress ?\n                            that.showWhileLongPress(showParams) :\n                            that.show(showParams));\n                    });\n\n                if (FLAG) {\n                    $DOCUMENT\n                        .on(keyupLocal, function (e) {\n                            if (that.longPress.inProgress) {\n                                that.showEndLongPress({user: true});\n                            }\n                            that.longPress.reset();\n                        });\n                }\n\n                if (!that.index) {\n                    $DOCUMENT\n                        .off(keydownCommon)\n                        .on(keydownCommon, 'textarea, input, select', function (e) {\n                            !$BODY.hasClass(_fullscreenClass) && e.stopPropagation();\n                        });\n                }\n\n                $WINDOW.on(resizeLocal, that.resize);\n            } else {\n                $DOCUMENT.off(keydownLocal);\n                $WINDOW.off(resizeLocal);\n            }\n        }\n\n        function appendElements(FLAG) {\n            if (FLAG === appendElements.f) return;\n\n            if (FLAG) {\n                $fotorama\n                    .addClass(_fotoramaClass + ' ' + stampClass)\n                    .before($anchor)\n                    .before($style);\n                addInstance(that);\n            } else {\n                $anchor.detach();\n                $style.detach();\n                $fotorama\n                    .html(fotoramaData.urtext)\n                    .removeClass(stampClass);\n\n                hideInstance(that);\n            }\n\n            bindGlobalEvents(FLAG);\n            appendElements.f = FLAG;\n        }\n\n        /**\n         * Set and install data from incoming @param {JSON} options or takes data attr from data-\"name\"=... values.\n         */\n        function setData() {\n            data = that.data = data || clone(opts.data) || getDataFromHtml($fotorama);\n            size = that.size = data.length;\n\n            ready.ok && opts.shuffle && shuffle(data);\n\n            checkForVideo();\n\n            activeIndex = limitIndex(activeIndex);\n\n            size && appendElements(true);\n        }\n\n        function stageNoMove() {\n            var _noMove = size < 2 || $videoPlaying;\n            stageShaftTouchTail.noMove = _noMove || o_fade;\n            stageShaftTouchTail.noSwipe = _noMove || !opts.swipe;\n\n            !o_transition && $stageShaft.toggleClass(grabClass, !opts.click && !stageShaftTouchTail.noMove && !stageShaftTouchTail.noSwipe);\n            MS_POINTER && $wrap.toggleClass(wrapPanYClass, !stageShaftTouchTail.noSwipe);\n        }\n\n        function setAutoplayInterval(interval) {\n            if (interval === true) interval = '';\n            opts.autoplay = Math.max(+interval || AUTOPLAY_INTERVAL, o_transitionDuration * 1.5);\n        }\n\n        function updateThumbArrow(opt) {\n            if (opt.navarrows && opt.nav === 'thumbs') {\n                $thumbArrLeft.show();\n                $thumbArrRight.show();\n            } else {\n                $thumbArrLeft.hide();\n                $thumbArrRight.hide();\n            }\n\n        }\n\n        function getThumbsInSlide($el, opts) {\n            return Math.floor($wrap.width() / (opts.thumbwidth + opts.thumbmargin));\n        }\n\n        /**\n         * Options on the fly\n         * */\n        function setOptions() {\n            if (!opts.nav || opts.nav === 'dots') {\n                opts.navdir = 'horizontal'\n            }\n\n            that.options = opts = optionsToLowerCase(opts);\n            thumbsPerSlide = getThumbsInSlide($wrap, opts);\n\n            o_fade = (opts.transition === 'crossfade' || opts.transition === 'dissolve');\n\n            o_loop = opts.loop && (size > 2 || (o_fade && (!o_transition || o_transition !== 'slide')));\n\n            o_transitionDuration = +opts.transitionduration || TRANSITION_DURATION;\n\n            o_rtl = opts.direction === 'rtl';\n\n            o_keyboard = $.extend({}, opts.keyboard && KEYBOARD_OPTIONS, opts.keyboard);\n            updateThumbArrow(opts);\n            var classes = {add: [], remove: []};\n\n            function addOrRemoveClass(FLAG, value) {\n                classes[FLAG ? 'add' : 'remove'].push(value);\n            }\n\n            if (size > 1) {\n                o_nav = opts.nav;\n                o_navTop = opts.navposition === 'top';\n                classes.remove.push(selectClass);\n\n                $arrs.toggle(!!opts.arrows);\n            } else {\n                o_nav = false;\n                $arrs.hide();\n            }\n\n            arrsUpdate();\n            stageWheelUpdate();\n            thumbArrUpdate();\n            if (opts.autoplay) setAutoplayInterval(opts.autoplay);\n\n            o_thumbSide = numberFromMeasure(opts.thumbwidth) || THUMB_SIZE;\n            o_thumbSide2 = numberFromMeasure(opts.thumbheight) || THUMB_SIZE;\n\n            stageWheelTail.ok = navWheelTail.ok = opts.trackpad && !SLOW;\n\n            stageNoMove();\n\n            extendMeasures(opts, [measures]);\n\n            o_navThumbs = o_nav === 'thumbs';\n\n            if ($navWrap.filter(':hidden') && !!o_nav) {\n                $navWrap.show();\n            }\n            if (o_navThumbs) {\n                frameDraw(size, 'navThumb');\n\n                $navFrame = $navThumbFrame;\n                navFrameKey = NAV_THUMB_FRAME_KEY;\n\n                setStyle($style, $.Fotorama.jst.style({\n                    w: o_thumbSide,\n                    h: o_thumbSide2,\n                    b: opts.thumbborderwidth,\n                    m: opts.thumbmargin,\n                    s: stamp,\n                    q: !COMPAT\n                }));\n\n                $nav\n                    .addClass(navThumbsClass)\n                    .removeClass(navDotsClass);\n            } else if (o_nav === 'dots') {\n                frameDraw(size, 'navDot');\n\n                $navFrame = $navDotFrame;\n                navFrameKey = NAV_DOT_FRAME_KEY;\n\n                $nav\n                    .addClass(navDotsClass)\n                    .removeClass(navThumbsClass);\n            } else {\n                $navWrap.hide();\n                o_nav = false;\n                $nav.removeClass(navThumbsClass + ' ' + navDotsClass);\n            }\n\n            if (o_nav) {\n                if (o_navTop) {\n                    $navWrap.insertBefore($stage);\n                } else {\n                    $navWrap.insertAfter($stage);\n                }\n                frameAppend.nav = false;\n\n                frameAppend($navFrame, $navShaft, 'nav');\n            }\n\n            o_allowFullScreen = opts.allowfullscreen;\n\n            if (o_allowFullScreen) {\n                $fullscreenIcon.prependTo($stage);\n                o_nativeFullScreen = FULLSCREEN && o_allowFullScreen === 'native';\n            } else {\n                $fullscreenIcon.detach();\n                o_nativeFullScreen = false;\n            }\n\n            addOrRemoveClass(o_fade, wrapFadeClass);\n            addOrRemoveClass(!o_fade, wrapSlideClass);\n            addOrRemoveClass(!opts.captions, wrapNoCaptionsClass);\n            addOrRemoveClass(o_rtl, wrapRtlClass);\n            addOrRemoveClass(opts.arrows, wrapToggleArrowsClass);\n\n            o_shadows = opts.shadows && !SLOW;\n            addOrRemoveClass(!o_shadows, wrapNoShadowsClass);\n\n            $wrap\n                .addClass(classes.add.join(' '))\n                .removeClass(classes.remove.join(' '));\n\n            lastOptions = $.extend({}, opts);\n            setStagePosition();\n        }\n\n        function normalizeIndex(index) {\n            return index < 0 ? (size + (index % size)) % size : index >= size ? index % size : index;\n        }\n\n        function limitIndex(index) {\n            return minMaxLimit(index, 0, size - 1);\n        }\n\n        function edgeIndex(index) {\n            return o_loop ? normalizeIndex(index) : limitIndex(index);\n        }\n\n        function getPrevIndex(index) {\n            return index > 0 || o_loop ? index - 1 : false;\n        }\n\n        function getNextIndex(index) {\n            return index < size - 1 || o_loop ? index + 1 : false;\n        }\n\n        function setStageShaftMinmaxAndSnap() {\n            stageShaftTouchTail.min = o_loop ? -Infinity : -getPosByIndex(size - 1, measures.w, opts.margin, repositionIndex);\n            stageShaftTouchTail.max = o_loop ? Infinity : -getPosByIndex(0, measures.w, opts.margin, repositionIndex);\n            stageShaftTouchTail.snap = measures.w + opts.margin;\n        }\n\n        function setNavShaftMinMax() {\n\n            var isVerticalDir = (opts.navdir === 'vertical');\n            var param = isVerticalDir ? $navShaft.height() : $navShaft.width();\n            var mainParam = isVerticalDir ? measures.h : measures.nw;\n            navShaftTouchTail.min = Math.min(0, mainParam - param);\n            navShaftTouchTail.max = 0;\n            navShaftTouchTail.direction = opts.navdir;\n            $navShaft.toggleClass(grabClass, !(navShaftTouchTail.noMove = navShaftTouchTail.min === navShaftTouchTail.max));\n        }\n\n        function eachIndex(indexes, type, fn) {\n            if (typeof indexes === 'number') {\n                indexes = new Array(indexes);\n                var rangeFLAG = true;\n            }\n            return $.each(indexes, function (i, index) {\n                if (rangeFLAG) index = i;\n                if (typeof index === 'number') {\n                    var dataFrame = data[normalizeIndex(index)];\n\n                    if (dataFrame) {\n                        var key = '$' + type + 'Frame',\n                            $frame = dataFrame[key];\n\n                        fn.call(this, i, index, dataFrame, $frame, key, $frame && $frame.data());\n                    }\n                }\n            });\n        }\n\n        function setMeasures(width, height, ratio, index) {\n            if (!measuresSetFLAG || (measuresSetFLAG === '*' && index === startIndex)) {\n\n                width = measureIsValid(opts.width) || measureIsValid(width) || WIDTH;\n                height = measureIsValid(opts.height) || measureIsValid(height) || HEIGHT;\n                that.resize({\n                    width: width,\n                    ratio: opts.ratio || ratio || width / height\n                }, 0, index !== startIndex && '*');\n            }\n        }\n\n        function loadImg(indexes, type, specialMeasures, again) {\n\n            eachIndex(indexes, type, function (i, index, dataFrame, $frame, key, frameData) {\n\n                if (!$frame) return;\n\n                var fullFLAG = that.fullScreen && !frameData.$full && type === 'stage';\n\n                if (frameData.$img && !again && !fullFLAG) return;\n\n                var img = new Image(),\n                    $img = $(img),\n                    imgData = $img.data();\n\n                frameData[fullFLAG ? '$full' : '$img'] = $img;\n\n                var srcKey = type === 'stage' ? (fullFLAG ? 'full' : 'img') : 'thumb',\n                    src = dataFrame[srcKey],\n                    dummy = fullFLAG ? dataFrame['img'] : dataFrame[type === 'stage' ? 'thumb' : 'img'];\n\n                if (type === 'navThumb') $frame = frameData.$wrap;\n\n                function triggerTriggerEvent(event) {\n                    var _index = normalizeIndex(index);\n                    triggerEvent(event, {\n                        index: _index,\n                        src: src,\n                        frame: data[_index]\n                    });\n                }\n\n                function error() {\n                    $img.remove();\n\n                    $.Fotorama.cache[src] = 'error';\n\n                    if ((!dataFrame.html || type !== 'stage') && dummy && dummy !== src) {\n                        dataFrame[srcKey] = src = dummy;\n                        frameData.$full = null;\n                        loadImg([index], type, specialMeasures, true);\n                    } else {\n                        if (src && !dataFrame.html && !fullFLAG) {\n                            $frame\n                                .trigger('f:error')\n                                .removeClass(loadingClass)\n                                .addClass(errorClass);\n\n                            triggerTriggerEvent('error');\n                        } else if (type === 'stage') {\n                            $frame\n                                .trigger('f:load')\n                                .removeClass(loadingClass + ' ' + errorClass)\n                                .addClass(loadedClass);\n\n                            triggerTriggerEvent('load');\n                            setMeasures();\n                        }\n\n                        frameData.state = 'error';\n\n                        if (size > 1 && data[index] === dataFrame && !dataFrame.html && !dataFrame.deleted && !dataFrame.video && !fullFLAG) {\n                            dataFrame.deleted = true;\n                            that.splice(index, 1);\n                        }\n                    }\n                }\n\n                function loaded() {\n                    $.Fotorama.measures[src] = imgData.measures = $.Fotorama.measures[src] || {\n                            width: img.width,\n                            height: img.height,\n                            ratio: img.width / img.height\n                        };\n\n                    setMeasures(imgData.measures.width, imgData.measures.height, imgData.measures.ratio, index);\n\n                    $img\n                        .off('load error')\n                        .addClass('' + (fullFLAG ? imgFullClass: imgClass))\n                        .attr('aria-hidden', 'false')\n                        .prependTo($frame);\n\n                    if ($frame.hasClass(stageFrameClass) && !$frame.hasClass(videoContainerClass)) {\n                        $frame.attr(\"href\", $img.attr(\"src\"));\n                    }\n\n                    fit($img, (\n                            $.isFunction(specialMeasures) ? specialMeasures() : specialMeasures) || measures);\n\n                    $.Fotorama.cache[src] = frameData.state = 'loaded';\n\n                    setTimeout(function () {\n                        $frame\n                            .trigger('f:load')\n                            .removeClass(loadingClass + ' ' + errorClass)\n                            .addClass(loadedClass + ' ' + (fullFLAG ? loadedFullClass : loadedImgClass));\n\n                        if (type === 'stage') {\n                            triggerTriggerEvent('load');\n                        } else if (dataFrame.thumbratio === AUTO || !dataFrame.thumbratio && opts.thumbratio === AUTO) {\n                            // danger! reflow for all thumbnails\n                            dataFrame.thumbratio = imgData.measures.ratio;\n                            reset();\n                        }\n                    }, 0);\n                }\n\n                if (!src) {\n                    error();\n                    return;\n                }\n\n                function waitAndLoad() {\n                    var _i = 10;\n                    waitFor(function () {\n                        return !touchedFLAG || !_i-- && !SLOW;\n                    }, function () {\n                        loaded();\n                    });\n                }\n\n                if (!$.Fotorama.cache[src]) {\n                    $.Fotorama.cache[src] = '*';\n\n                    $img\n                        .on('load', waitAndLoad)\n                        .on('error', error);\n                } else {\n                    (function justWait() {\n                        if ($.Fotorama.cache[src] === 'error') {\n                            error();\n                        } else if ($.Fotorama.cache[src] === 'loaded') {\n                            setTimeout(waitAndLoad, 0);\n                        } else {\n                            setTimeout(justWait, 100);\n                        }\n                    })();\n                }\n\n                frameData.state = '';\n                img.src = src;\n\n                if (frameData.data.caption) {\n                    img.alt = frameData.data.caption || \"\";\n                }\n\n                if (frameData.data.full) {\n                    $(img).data('original', frameData.data.full);\n                }\n\n                if (UTIL.isExpectedCaption(dataFrame, opts.showcaption)) {\n                    $(img).attr('aria-labelledby', dataFrame.labelledby);\n                }\n            });\n        }\n\n        function updateFotoramaState() {\n            var $frame = activeFrame[STAGE_FRAME_KEY];\n\n            if ($frame && !$frame.data().state) {\n                $spinner.addClass(spinnerShowClass);\n                $frame.on('f:load f:error', function () {\n                    $frame.off('f:load f:error');\n                    $spinner.removeClass(spinnerShowClass);\n                });\n            }\n        }\n\n        function addNavFrameEvents(frame) {\n            addEnterUp(frame, onNavFrameClick);\n            addFocus(frame, function () {\n\n                setTimeout(function () {\n                    lockScroll($nav);\n                }, 0);\n                slideNavShaft({time: o_transitionDuration, guessIndex: $(this).data().eq, minMax: navShaftTouchTail});\n            });\n        }\n\n        function frameDraw(indexes, type) {\n            eachIndex(indexes, type, function (i, index, dataFrame, $frame, key, frameData) {\n                if ($frame) return;\n\n                $frame = dataFrame[key] = $wrap[key].clone();\n                frameData = $frame.data();\n                frameData.data = dataFrame;\n                var frame = $frame[0],\n                    labelledbyValue = \"labelledby\" + $.now();\n\n                if (type === 'stage') {\n\n                    if (dataFrame.html) {\n                        $('<div class=\"' + htmlClass + '\"></div>')\n                            .append(\n                            dataFrame._html ? $(dataFrame.html)\n                                .removeAttr('id')\n                                .html(dataFrame._html) // Because of IE\n                                : dataFrame.html\n                        )\n                            .appendTo($frame);\n                    }\n\n                    if (dataFrame.id) {\n                        labelledbyValue = dataFrame.id || labelledbyValue;\n                    }\n                    dataFrame.labelledby = labelledbyValue;\n\n                    if (UTIL.isExpectedCaption(dataFrame, opts.showcaption)) {\n                        $($.Fotorama.jst.frameCaption({\n                            caption: dataFrame.caption,\n                            labelledby: labelledbyValue\n                        })).appendTo($frame);\n                    }\n\n                    dataFrame.video && $frame\n                        .addClass(stageFrameVideoClass)\n                        .append($videoPlay.clone());\n\n                    // This solves tabbing problems\n                    addFocus(frame, function (e) {\n                        setTimeout(function () {\n                            lockScroll($stage);\n                        }, 0);\n                        clickToShow({index: frameData.eq, user: true}, e);\n                    });\n\n                    $stageFrame = $stageFrame.add($frame);\n                } else if (type === 'navDot') {\n                    addNavFrameEvents(frame);\n                    $navDotFrame = $navDotFrame.add($frame);\n                } else if (type === 'navThumb') {\n                    addNavFrameEvents(frame);\n                    frameData.$wrap = $frame.children(':first');\n\n                    $navThumbFrame = $navThumbFrame.add($frame);\n                    if (dataFrame.video) {\n                        frameData.$wrap.append($videoPlay.clone());\n                    }\n                }\n            });\n        }\n\n        function callFit($img, measuresToFit) {\n            return $img && $img.length && fit($img, measuresToFit);\n        }\n\n        function stageFramePosition(indexes) {\n            eachIndex(indexes, 'stage', function (i, index, dataFrame, $frame, key, frameData) {\n                if (!$frame) return;\n\n                var normalizedIndex = normalizeIndex(index);\n                frameData.eq = normalizedIndex;\n\n                toDetach[STAGE_FRAME_KEY][normalizedIndex] = $frame.css($.extend({left: o_fade ? 0 : getPosByIndex(index, measures.w, opts.margin, repositionIndex)}, o_fade && getDuration(0)));\n\n                if (isDetached($frame[0])) {\n                    $frame.appendTo($stageShaft);\n                    unloadVideo(dataFrame.$video);\n                }\n\n                callFit(frameData.$img, measures);\n                callFit(frameData.$full, measures);\n\n                if ($frame.hasClass(stageFrameClass) && !($frame.attr('aria-hidden') === \"false\" && $frame.hasClass(activeClass))) {\n                    $frame.attr('aria-hidden', 'true');\n                }\n            });\n        }\n\n        function thumbsDraw(pos, loadFLAG) {\n            var leftLimit,\n                rightLimit,\n                exceedLimit;\n\n\n            if (o_nav !== 'thumbs' || isNaN(pos)) return;\n\n            leftLimit = -pos;\n            rightLimit = -pos + measures.nw;\n\n            if (opts.navdir === 'vertical') {\n                pos = pos - opts.thumbheight;\n                rightLimit = -pos + measures.h;\n            }\n\n            $navThumbFrame.each(function () {\n                var $this = $(this),\n                    thisData = $this.data(),\n                    eq = thisData.eq,\n                    getSpecialMeasures = function () {\n                        return {\n                            h: o_thumbSide2,\n                            w: thisData.w\n                        }\n                    },\n                    specialMeasures = getSpecialMeasures(),\n                    exceedLimit = opts.navdir === 'vertical' ?\n                    thisData.t > rightLimit : thisData.l > rightLimit;\n                specialMeasures.w = thisData.w;\n\n                if ((opts.navdir !== 'vertical' && thisData.l + thisData.w < leftLimit)\n                    || exceedLimit\n                    || callFit(thisData.$img, specialMeasures)) return;\n\n                loadFLAG && loadImg([eq], 'navThumb', getSpecialMeasures);\n            });\n        }\n\n        function frameAppend($frames, $shaft, type) {\n            if (!frameAppend[type]) {\n\n                var thumbsFLAG = type === 'nav' && o_navThumbs,\n                    left = 0,\n                    top = 0;\n\n                $shaft.append(\n                    $frames\n                        .filter(function () {\n                            var actual,\n                                $this = $(this),\n                                frameData = $this.data();\n                            for (var _i = 0, _l = data.length; _i < _l; _i++) {\n                                if (frameData.data === data[_i]) {\n                                    actual = true;\n                                    frameData.eq = _i;\n                                    break;\n                                }\n                            }\n                            return actual || $this.remove() && false;\n                        })\n                        .sort(function (a, b) {\n                            return $(a).data().eq - $(b).data().eq;\n                        })\n                        .each(function () {\n                            var $this = $(this),\n                                frameData = $this.data();\n                            UTIL.setThumbAttr($this, frameData.data.caption, \"aria-label\");\n                        })\n                        .each(function () {\n\n                            if (!thumbsFLAG) return;\n\n                            var $this = $(this),\n                                frameData = $this.data(),\n                                thumbwidth = Math.round(o_thumbSide2 * frameData.data.thumbratio) || o_thumbSide,\n                                thumbheight = Math.round(o_thumbSide / frameData.data.thumbratio) || o_thumbSide2;\n                            frameData.t = top;\n                            frameData.h = thumbheight;\n                            frameData.l = left;\n                            frameData.w = thumbwidth;\n\n                            $this.css({width: thumbwidth});\n\n                            top += thumbheight + opts.thumbmargin;\n                            left += thumbwidth + opts.thumbmargin;\n                        })\n                );\n\n                frameAppend[type] = true;\n            }\n        }\n\n        function getDirection(x) {\n            return x - stageLeft > measures.w / 3;\n        }\n\n        function disableDirrection(i) {\n            return !o_loop && (!(activeIndex + i) || !(activeIndex - size + i)) && !$videoPlaying;\n        }\n\n        function arrsUpdate() {\n            var disablePrev = disableDirrection(0),\n                disableNext = disableDirrection(1);\n            $arrPrev\n                .toggleClass(arrDisabledClass, disablePrev)\n                .attr(disableAttr(disablePrev, false));\n            $arrNext\n                .toggleClass(arrDisabledClass, disableNext)\n                .attr(disableAttr(disableNext, false));\n        }\n\n        function thumbArrUpdate() {\n            var isLeftDisable = false,\n                isRightDisable = false;\n            if (opts.navtype === 'thumbs' && !opts.loop) {\n                (activeIndex == 0) ? isLeftDisable = true : isLeftDisable = false;\n                (activeIndex == opts.data.length - 1) ? isRightDisable = true : isRightDisable = false;\n            }\n            if (opts.navtype === 'slides') {\n                var pos = readPosition($navShaft, opts.navdir);\n                pos >= navShaftTouchTail.max ? isLeftDisable = true : isLeftDisable = false;\n                pos <= navShaftTouchTail.min ? isRightDisable = true : isRightDisable = false;\n            }\n            $thumbArrLeft\n                .toggleClass(arrDisabledClass, isLeftDisable)\n                .attr(disableAttr(isLeftDisable, true));\n            $thumbArrRight\n                .toggleClass(arrDisabledClass, isRightDisable)\n                .attr(disableAttr(isRightDisable, true));\n        }\n\n        function stageWheelUpdate() {\n            if (stageWheelTail.ok) {\n                stageWheelTail.prevent = {'<': disableDirrection(0), '>': disableDirrection(1)};\n            }\n        }\n\n        function getNavFrameBounds($navFrame) {\n            var navFrameData = $navFrame.data(),\n                left,\n                top,\n                width,\n                height;\n\n            if (o_navThumbs) {\n                left = navFrameData.l;\n                top = navFrameData.t;\n                width = navFrameData.w;\n                height = navFrameData.h;\n            } else {\n                left = $navFrame.position().left;\n                width = $navFrame.width();\n            }\n\n            var horizontalBounds = {\n                c: left + width / 2,\n                min: -left + opts.thumbmargin * 10,\n                max: -left + measures.w - width - opts.thumbmargin * 10\n            };\n\n            var verticalBounds = {\n                c: top + height / 2,\n                min: -top + opts.thumbmargin * 10,\n                max: -top + measures.h - height - opts.thumbmargin * 10\n            };\n\n            return opts.navdir === 'vertical' ? verticalBounds : horizontalBounds;\n        }\n\n        function slideThumbBorder(time) {\n            var navFrameData = activeFrame[navFrameKey].data();\n            slide($thumbBorder, {\n                time: time * 1.2,\n                pos: (opts.navdir === 'vertical' ? navFrameData.t : navFrameData.l),\n                width: navFrameData.w,\n                height: navFrameData.h,\n                direction: opts.navdir\n            });\n        }\n\n        function slideNavShaft(options) {\n            var $guessNavFrame = data[options.guessIndex][navFrameKey],\n                typeOfAnimation = opts.navtype;\n\n            var overflowFLAG,\n                time,\n                minMax,\n                boundTop,\n                boundLeft,\n                l,\n                pos,\n                x;\n\n            if ($guessNavFrame) {\n                if (typeOfAnimation === 'thumbs') {\n                    overflowFLAG = navShaftTouchTail.min !== navShaftTouchTail.max;\n                    minMax = options.minMax || overflowFLAG && getNavFrameBounds(activeFrame[navFrameKey]);\n                    boundTop = overflowFLAG && (options.keep && slideNavShaft.t ? slideNavShaft.l : minMaxLimit((options.coo || measures.nw / 2) - getNavFrameBounds($guessNavFrame).c, minMax.min, minMax.max));\n                    boundLeft = overflowFLAG && (options.keep && slideNavShaft.l ? slideNavShaft.l : minMaxLimit((options.coo || measures.nw / 2) - getNavFrameBounds($guessNavFrame).c, minMax.min, minMax.max));\n                    l = (opts.navdir === 'vertical' ? boundTop : boundLeft);\n                    pos = overflowFLAG && minMaxLimit(l, navShaftTouchTail.min, navShaftTouchTail.max) || 0;\n                    time = options.time * 1.1;\n                    slide($navShaft, {\n                        time: time,\n                        pos: pos,\n                        direction: opts.navdir,\n                        onEnd: function () {\n                            thumbsDraw(pos, true);\n                            thumbArrUpdate();\n                        }\n                    });\n\n                    setShadow($nav, findShadowEdge(pos, navShaftTouchTail.min, navShaftTouchTail.max, opts.navdir));\n                    slideNavShaft.l = l;\n                } else {\n                    x = readPosition($navShaft, opts.navdir);\n                    time = options.time * 1.11;\n\n                    pos = validateSlidePos(opts, navShaftTouchTail, options.guessIndex, x, $guessNavFrame, $navWrap, opts.navdir);\n\n                    slide($navShaft, {\n                        time: time,\n                        pos: pos,\n                        direction: opts.navdir,\n                        onEnd: function () {\n                            thumbsDraw(pos, true);\n                            thumbArrUpdate();\n                        }\n                    });\n                    setShadow($nav, findShadowEdge(pos, navShaftTouchTail.min, navShaftTouchTail.max, opts.navdir));\n                }\n            }\n        }\n\n        function navUpdate() {\n            deactivateFrames(navFrameKey);\n            toDeactivate[navFrameKey].push(activeFrame[navFrameKey].addClass(activeClass).attr('data-active', true));\n        }\n\n        function deactivateFrames(key) {\n            var _toDeactivate = toDeactivate[key];\n\n            while (_toDeactivate.length) {\n                _toDeactivate.shift().removeClass(activeClass).attr('data-active', false);\n            }\n        }\n\n        function detachFrames(key) {\n            var _toDetach = toDetach[key];\n\n            $.each(activeIndexes, function (i, index) {\n                delete _toDetach[normalizeIndex(index)];\n            });\n\n            $.each(_toDetach, function (index, $frame) {\n                delete _toDetach[index];\n                $frame.detach();\n            });\n        }\n\n        function stageShaftReposition(skipOnEnd) {\n\n            repositionIndex = dirtyIndex = activeIndex;\n\n            var $frame = activeFrame[STAGE_FRAME_KEY];\n\n            if ($frame) {\n                deactivateFrames(STAGE_FRAME_KEY);\n                toDeactivate[STAGE_FRAME_KEY].push($frame.addClass(activeClass).attr('data-active', true));\n\n                if ($frame.hasClass(stageFrameClass)) {\n                    $frame.attr('aria-hidden', 'false');\n                }\n\n                skipOnEnd || that.showStage.onEnd(true);\n                stop($stageShaft, 0, true);\n\n                detachFrames(STAGE_FRAME_KEY);\n                stageFramePosition(activeIndexes);\n                setStageShaftMinmaxAndSnap();\n                setNavShaftMinMax();\n                addEnterUp($stageShaft[0], function () {\n                    if (!$fotorama.hasClass(fullscreenClass)) {\n                        that.requestFullScreen();\n                        $fullscreenIcon.focus();\n                    }\n                });\n            }\n        }\n\n        function extendMeasures(options, measuresArray) {\n            if (!options) return;\n\n            $.each(measuresArray, function (i, measures) {\n                if (!measures) return;\n\n                $.extend(measures, {\n                    width: options.width || measures.width,\n                    height: options.height,\n                    minwidth: options.minwidth,\n                    maxwidth: options.maxwidth,\n                    minheight: options.minheight,\n                    maxheight: options.maxheight,\n                    ratio: getRatio(options.ratio)\n                })\n            });\n        }\n\n        function triggerEvent(event, extra) {\n            $fotorama.trigger(_fotoramaClass + ':' + event, [that, extra]);\n        }\n\n        function onTouchStart() {\n            clearTimeout(onTouchEnd.t);\n            touchedFLAG = 1;\n\n            if (opts.stopautoplayontouch) {\n                that.stopAutoplay();\n            } else {\n                pausedAutoplayFLAG = true;\n            }\n        }\n\n        function onTouchEnd() {\n            if (!touchedFLAG) return;\n            if (!opts.stopautoplayontouch) {\n                releaseAutoplay();\n                changeAutoplay();\n            }\n\n            onTouchEnd.t = setTimeout(function () {\n                touchedFLAG = 0;\n            }, TRANSITION_DURATION + TOUCH_TIMEOUT);\n        }\n\n        function releaseAutoplay() {\n            pausedAutoplayFLAG = !!($videoPlaying || stoppedAutoplayFLAG);\n        }\n\n        function changeAutoplay() {\n\n            clearTimeout(changeAutoplay.t);\n            waitFor.stop(changeAutoplay.w);\n\n            if (!opts.autoplay || pausedAutoplayFLAG) {\n                if (that.autoplay) {\n                    that.autoplay = false;\n                    triggerEvent('stopautoplay');\n                }\n\n                return;\n            }\n\n            if (!that.autoplay) {\n                that.autoplay = true;\n                triggerEvent('startautoplay');\n            }\n\n            var _activeIndex = activeIndex;\n\n\n            var frameData = activeFrame[STAGE_FRAME_KEY].data();\n            changeAutoplay.w = waitFor(function () {\n                return frameData.state || _activeIndex !== activeIndex;\n            }, function () {\n                changeAutoplay.t = setTimeout(function () {\n\n                    if (pausedAutoplayFLAG || _activeIndex !== activeIndex) return;\n\n                    var _nextAutoplayIndex = nextAutoplayIndex,\n                        nextFrameData = data[_nextAutoplayIndex][STAGE_FRAME_KEY].data();\n\n                    changeAutoplay.w = waitFor(function () {\n\n                        return nextFrameData.state || _nextAutoplayIndex !== nextAutoplayIndex;\n                    }, function () {\n                        if (pausedAutoplayFLAG || _nextAutoplayIndex !== nextAutoplayIndex) return;\n                        that.show(o_loop ? getDirectionSign(!o_rtl) : nextAutoplayIndex);\n                    });\n                }, opts.autoplay);\n            });\n\n        }\n\n        that.startAutoplay = function (interval) {\n            if (that.autoplay) return this;\n            pausedAutoplayFLAG = stoppedAutoplayFLAG = false;\n            setAutoplayInterval(interval || opts.autoplay);\n            changeAutoplay();\n\n            return this;\n        };\n\n        that.stopAutoplay = function () {\n            if (that.autoplay) {\n                pausedAutoplayFLAG = stoppedAutoplayFLAG = true;\n                changeAutoplay();\n            }\n            return this;\n        };\n\n        that.showSlide = function (slideDir) {\n            var currentPosition = readPosition($navShaft, opts.navdir),\n                pos,\n                time = 500 * 1.1,\n                size = opts.navdir === 'horizontal' ? opts.thumbwidth : opts.thumbheight,\n                onEnd = function () {\n                    thumbArrUpdate();\n                };\n            if (slideDir === 'next') {\n                pos = currentPosition - (size + opts.margin) * thumbsPerSlide;\n            }\n            if (slideDir === 'prev') {\n                pos = currentPosition + (size + opts.margin) * thumbsPerSlide;\n            }\n            pos = validateRestrictions(pos, navShaftTouchTail);\n            thumbsDraw(pos, true);\n            slide($navShaft, {\n                time: time,\n                pos: pos,\n                direction: opts.navdir,\n                onEnd: onEnd\n            });\n        };\n\n        that.showWhileLongPress = function (options) {\n            if (that.longPress.singlePressInProgress) {\n                return;\n            }\n\n            var index = calcActiveIndex(options);\n            calcGlobalIndexes(index);\n            var time = calcTime(options) / 50;\n            var _activeFrame = activeFrame;\n            that.activeFrame = activeFrame = data[activeIndex];\n            var silent = _activeFrame === activeFrame && !options.user;\n\n            that.showNav(silent, options, time);\n\n            return this;\n        };\n\n        that.showEndLongPress = function (options) {\n            if (that.longPress.singlePressInProgress) {\n                return;\n            }\n\n            var index = calcActiveIndex(options);\n            calcGlobalIndexes(index);\n            var time = calcTime(options) / 50;\n            var _activeFrame = activeFrame;\n            that.activeFrame = activeFrame = data[activeIndex];\n\n            var silent = _activeFrame === activeFrame && !options.user;\n\n            that.showStage(silent, options, time);\n\n            showedFLAG = typeof lastActiveIndex !== 'undefined' && lastActiveIndex !== activeIndex;\n            lastActiveIndex = activeIndex;\n            return this;\n        };\n\n        function calcActiveIndex (options) {\n            var index;\n\n            if (typeof options !== 'object') {\n                index = options;\n                options = {};\n            } else {\n                index = options.index;\n            }\n\n            index = index === '>' ? dirtyIndex + 1 : index === '<' ? dirtyIndex - 1 : index === '<<' ? 0 : index === '>>' ? size - 1 : index;\n            index = isNaN(index) ? undefined : index;\n            index = typeof index === 'undefined' ? activeIndex || 0 : index;\n\n            return index;\n        }\n\n        function calcGlobalIndexes (index) {\n            that.activeIndex = activeIndex = edgeIndex(index);\n            prevIndex = getPrevIndex(activeIndex);\n            nextIndex = getNextIndex(activeIndex);\n            nextAutoplayIndex = normalizeIndex(activeIndex + (o_rtl ? -1 : 1));\n            activeIndexes = [activeIndex, prevIndex, nextIndex];\n\n            dirtyIndex = o_loop ? index : activeIndex;\n        }\n\n        function calcTime (options) {\n            var diffIndex = Math.abs(lastActiveIndex - dirtyIndex),\n                time = getNumber(options.time, function () {\n                    return Math.min(o_transitionDuration * (1 + (diffIndex - 1) / 12), o_transitionDuration * 2);\n                });\n\n            if (options.slow) {\n                time *= 10;\n            }\n\n            return time;\n        }\n\n        that.showStage = function (silent, options, time, e) {\n            if (e !== undefined && e.target.tagName == 'IFRAME') {\n                return;\n            }\n            unloadVideo($videoPlaying, activeFrame.i !== data[normalizeIndex(repositionIndex)].i);\n            frameDraw(activeIndexes, 'stage');\n            stageFramePosition(SLOW ? [dirtyIndex] : [dirtyIndex, getPrevIndex(dirtyIndex), getNextIndex(dirtyIndex)]);\n            updateTouchTails('go', true);\n\n            silent || triggerEvent('show', {\n                user: options.user,\n                time: time\n            });\n\n            pausedAutoplayFLAG = true;\n\n            var overPos = options.overPos;\n            var onEnd = that.showStage.onEnd = function (skipReposition) {\n                if (onEnd.ok) return;\n                onEnd.ok = true;\n\n                skipReposition || stageShaftReposition(true);\n\n                if (!silent) {\n                    triggerEvent('showend', {\n                        user: options.user\n                    });\n                }\n\n                if (!skipReposition && o_transition && o_transition !== opts.transition) {\n                    that.setOptions({transition: o_transition});\n                    o_transition = false;\n                    return;\n                }\n\n                updateFotoramaState();\n                loadImg(activeIndexes, 'stage');\n\n                updateTouchTails('go', false);\n                stageWheelUpdate();\n\n                stageCursor();\n                releaseAutoplay();\n                changeAutoplay();\n\n                if (that.fullScreen) {\n                    activeFrame[STAGE_FRAME_KEY].find('.' + imgFullClass).attr('aria-hidden', false);\n                    activeFrame[STAGE_FRAME_KEY].find('.' + imgClass).attr('aria-hidden', true)\n                } else {\n                    activeFrame[STAGE_FRAME_KEY].find('.' + imgFullClass).attr('aria-hidden', true);\n                    activeFrame[STAGE_FRAME_KEY].find('.' + imgClass).attr('aria-hidden', false)\n                }\n            };\n\n            if (!o_fade) {\n                slide($stageShaft, {\n                    pos: -getPosByIndex(dirtyIndex, measures.w, opts.margin, repositionIndex),\n                    overPos: overPos,\n                    time: time,\n                    onEnd: onEnd\n                });\n            } else {\n                var $activeFrame = activeFrame[STAGE_FRAME_KEY],\n                    $prevActiveFrame = data[lastActiveIndex] && activeIndex !== lastActiveIndex ? data[lastActiveIndex][STAGE_FRAME_KEY] : null;\n\n                fade($activeFrame, $prevActiveFrame, $stageFrame, {\n                    time: time,\n                    method: opts.transition,\n                    onEnd: onEnd\n                }, fadeStack);\n            }\n\n            arrsUpdate();\n        };\n\n        that.showNav = function(silent, options, time){\n            thumbArrUpdate();\n            if (o_nav) {\n                navUpdate();\n\n                var guessIndex = limitIndex(activeIndex + minMaxLimit(dirtyIndex - lastActiveIndex, -1, 1));\n                slideNavShaft({\n                    time: time,\n                    coo: guessIndex !== activeIndex && options.coo,\n                    guessIndex: typeof options.coo !== 'undefined' ? guessIndex : activeIndex,\n                    keep: silent\n                });\n                if (o_navThumbs) slideThumbBorder(time);\n            }\n        };\n\n        that.show = function (options, e) {\n            that.longPress.singlePressInProgress = true;\n\n            var index = calcActiveIndex(options);\n            calcGlobalIndexes(index);\n            var time = calcTime(options);\n            var _activeFrame = activeFrame;\n            that.activeFrame = activeFrame = data[activeIndex];\n\n            var silent = _activeFrame === activeFrame && !options.user;\n\n            that.showStage(silent, options, time, e);\n            that.showNav(silent, options, time);\n\n            showedFLAG = typeof lastActiveIndex !== 'undefined' && lastActiveIndex !== activeIndex;\n            lastActiveIndex = activeIndex;\n            that.longPress.singlePressInProgress = false;\n\n            return this;\n        };\n\n        that.requestFullScreen = function () {\n            if (o_allowFullScreen && !that.fullScreen) {\n\n                //check that this is not video\n                if(isVideo()) {\n                    return;\n                }\n\n                scrollTop = $WINDOW.scrollTop();\n                scrollLeft = $WINDOW.scrollLeft();\n\n                lockScroll($WINDOW);\n\n                updateTouchTails('x', true);\n\n                measuresStash = $.extend({}, measures);\n\n                $fotorama\n                    .addClass(fullscreenClass)\n                    .appendTo($BODY.addClass(_fullscreenClass));\n\n                $HTML.addClass(_fullscreenClass);\n\n                unloadVideo($videoPlaying, true, true);\n\n                that.fullScreen = true;\n\n                if (o_nativeFullScreen) {\n                    fullScreenApi.request(fotorama);\n                }\n\n                that.resize();\n                loadImg(activeIndexes, 'stage');\n                updateFotoramaState();\n                triggerEvent('fullscreenenter');\n\n                if (!('ontouchstart' in window)) {\n                    $fullscreenIcon.focus();\n                }\n            }\n\n            return this;\n        };\n\n        function cancelFullScreen() {\n            if (that.fullScreen) {\n                that.fullScreen = false;\n\n                if (FULLSCREEN) {\n                    fullScreenApi.cancel(fotorama);\n                }\n\n                $BODY.removeClass(_fullscreenClass);\n                $HTML.removeClass(_fullscreenClass);\n\n                $fotorama\n                    .removeClass(fullscreenClass)\n                    .insertAfter($anchor);\n\n                measures = $.extend({}, measuresStash);\n\n                unloadVideo($videoPlaying, true, true);\n\n                updateTouchTails('x', false);\n\n                that.resize();\n                loadImg(activeIndexes, 'stage');\n\n                lockScroll($WINDOW, scrollLeft, scrollTop);\n\n                triggerEvent('fullscreenexit');\n            }\n        }\n\n        that.cancelFullScreen = function () {\n            if (o_nativeFullScreen && fullScreenApi.is()) {\n                fullScreenApi.cancel(document);\n            } else {\n                cancelFullScreen();\n            }\n\n            return this;\n        };\n\n        that.toggleFullScreen = function () {\n            return that[(that.fullScreen ? 'cancel' : 'request') + 'FullScreen']();\n        };\n\n        that.resize = function (options) {\n            if (!data) return this;\n\n            var time = arguments[1] || 0,\n                setFLAG = arguments[2];\n\n            thumbsPerSlide = getThumbsInSlide($wrap, opts);\n            extendMeasures(!that.fullScreen ? optionsToLowerCase(options) : {\n                width: $(window).width(),\n                maxwidth: null,\n                minwidth: null,\n                height: $(window).height(),\n                maxheight: null,\n                minheight: null\n            }, [measures, setFLAG || that.fullScreen || opts]);\n\n            var width = measures.width,\n                height = measures.height,\n                ratio = measures.ratio,\n                windowHeight = $WINDOW.height() - (o_nav ? $nav.height() : 0);\n\n            if (measureIsValid(width)) {\n                $wrap.css({width: ''});\n                $stage.css({width: ''});\n                $stageShaft.css({width: ''});\n                $nav.css({width: ''});\n                $wrap.css({minWidth: measures.minwidth || 0, maxWidth: measures.maxwidth || MAX_WIDTH});\n\n                if (o_nav === 'dots') {\n                    $navWrap.hide();\n                }\n                width = measures.W = measures.w = $wrap.width();\n                measures.nw = o_nav && numberFromWhatever(opts.navwidth, width) || width;\n\n                $stageShaft.css({width: measures.w, marginLeft: (measures.W - measures.w) / 2});\n\n                height = numberFromWhatever(height, windowHeight);\n\n                height = height || (ratio && width / ratio);\n\n                if (height) {\n                    width = Math.round(width);\n                    height = measures.h = Math.round(minMaxLimit(height, numberFromWhatever(measures.minheight, windowHeight), numberFromWhatever(measures.maxheight, windowHeight)));\n                    $stage.css({'width': width, 'height': height});\n\n                    if (opts.navdir === 'vertical' && !that.fullscreen) {\n                        $nav.width(opts.thumbwidth + opts.thumbmargin * 2);\n                    }\n\n                    if (opts.navdir === 'horizontal' && !that.fullscreen) {\n                        $nav.height(opts.thumbheight + opts.thumbmargin * 2);\n                    }\n\n                    if (o_nav === 'dots') {\n                        $nav.width(width)\n                            .height('auto');\n                        $navWrap.show();\n                    }\n\n                    if (opts.navdir === 'vertical' && that.fullScreen) {\n                        $stage.css('height', $WINDOW.height());\n                    }\n\n                    if (opts.navdir === 'horizontal' && that.fullScreen) {\n                        $stage.css('height', $WINDOW.height() - $nav.height());\n                    }\n\n                    if (o_nav) {\n                        switch (opts.navdir) {\n                            case 'vertical':\n                                $navWrap.removeClass(navShafthorizontalClass);\n                                $navWrap.removeClass(navShaftListClass);\n                                $navWrap.addClass(navShaftVerticalClass);\n                                $nav\n                                    .stop()\n                                    .animate({height: measures.h, width: opts.thumbwidth}, time);\n                                break;\n                            case 'list':\n                                $navWrap.removeClass(navShaftVerticalClass);\n                                $navWrap.removeClass(navShafthorizontalClass);\n                                $navWrap.addClass(navShaftListClass);\n                                break;\n                            default:\n                                $navWrap.removeClass(navShaftVerticalClass);\n                                $navWrap.removeClass(navShaftListClass);\n                                $navWrap.addClass(navShafthorizontalClass);\n                                $nav\n                                    .stop()\n                                    .animate({width: measures.nw}, time);\n                                break;\n                        }\n\n                        stageShaftReposition();\n                        slideNavShaft({guessIndex: activeIndex, time: time, keep: true});\n                        if (o_navThumbs && frameAppend.nav) slideThumbBorder(time);\n                    }\n\n                    measuresSetFLAG = setFLAG || true;\n\n                    ready.ok = true;\n                    ready();\n                }\n            }\n\n            stageLeft = $stage.offset().left;\n            setStagePosition();\n\n            return this;\n        };\n\n        that.setOptions = function (options) {\n            $.extend(opts, options);\n            reset();\n            return this;\n        };\n\n        that.shuffle = function () {\n            data && shuffle(data) && reset();\n            return this;\n        };\n\n        function setShadow($el, edge) {\n            if (o_shadows) {\n                $el.removeClass(shadowsLeftClass + ' ' + shadowsRightClass);\n                $el.removeClass(shadowsTopClass + ' ' + shadowsBottomClass);\n                edge && !$videoPlaying && $el.addClass(edge.replace(/^|\\s/g, ' ' + shadowsClass + '--'));\n            }\n        }\n\n        that.longPress = {\n            threshold: 1,\n            count: 0,\n            thumbSlideTime: 20,\n            progress: function(){\n                if (!this.inProgress) {\n                    this.count++;\n                    this.inProgress = this.count > this.threshold;\n                }\n            },\n            end: function(){\n                if(this.inProgress) {\n                    this.isEnded = true\n                }\n            },\n            reset: function(){\n                this.count = 0;\n                this.inProgress = false;\n                this.isEnded = false;\n            }\n        };\n\n        that.destroy = function () {\n            that.cancelFullScreen();\n            that.stopAutoplay();\n\n            data = that.data = null;\n\n            appendElements();\n\n            activeIndexes = [];\n            detachFrames(STAGE_FRAME_KEY);\n\n            reset.ok = false;\n\n            return this;\n        };\n\n        /**\n         *\n         * @returns {jQuery.Fotorama}\n         */\n        that.playVideo = function () {\n            var dataFrame = activeFrame,\n                video = dataFrame.video,\n                _activeIndex = activeIndex;\n\n            if (typeof video === 'object' && dataFrame.videoReady) {\n                o_nativeFullScreen && that.fullScreen && that.cancelFullScreen();\n\n                waitFor(function () {\n                    return !fullScreenApi.is() || _activeIndex !== activeIndex;\n                }, function () {\n                    if (_activeIndex === activeIndex) {\n                        dataFrame.$video = dataFrame.$video || $(div(videoClass)).append(createVideoFrame(video));\n                        dataFrame.$video.appendTo(dataFrame[STAGE_FRAME_KEY]);\n\n                        $wrap.addClass(wrapVideoClass);\n                        $videoPlaying = dataFrame.$video;\n\n                        stageNoMove();\n\n                        $arrs.blur();\n                        $fullscreenIcon.blur();\n\n                        triggerEvent('loadvideo');\n                    }\n                });\n            }\n\n            return this;\n        };\n\n        that.stopVideo = function () {\n            unloadVideo($videoPlaying, true, true);\n            return this;\n        };\n\n        that.spliceByIndex = function (index, newImgObj) {\n            newImgObj.i = index + 1;\n            newImgObj.img && $.ajax({\n                url: newImgObj.img,\n                type: 'HEAD',\n                success: function () {\n                    data.splice(index, 1, newImgObj);\n                    reset();\n                }\n            });\n        };\n\n        function unloadVideo($video, unloadActiveFLAG, releaseAutoplayFLAG) {\n            if (unloadActiveFLAG) {\n                $wrap.removeClass(wrapVideoClass);\n                $videoPlaying = false;\n\n                stageNoMove();\n            }\n\n            if ($video && $video !== $videoPlaying) {\n                $video.remove();\n                triggerEvent('unloadvideo');\n            }\n\n            if (releaseAutoplayFLAG) {\n                releaseAutoplay();\n                changeAutoplay();\n            }\n        }\n\n        function toggleControlsClass(FLAG) {\n            $wrap.toggleClass(wrapNoControlsClass, FLAG);\n        }\n\n        function stageCursor(e) {\n            if (stageShaftTouchTail.flow) return;\n\n            var x = e ? e.pageX : stageCursor.x,\n                pointerFLAG = x && !disableDirrection(getDirection(x)) && opts.click;\n\n            if (stageCursor.p !== pointerFLAG\n                && $stage.toggleClass(pointerClass, pointerFLAG)) {\n                stageCursor.p = pointerFLAG;\n                stageCursor.x = x;\n            }\n        }\n\n        $stage.on('mousemove', stageCursor);\n\n        function clickToShow(showOptions, e) {\n            clearTimeout(clickToShow.t);\n\n            if (opts.clicktransition && opts.clicktransition !== opts.transition) {\n                setTimeout(function () {\n                    var _o_transition = opts.transition;\n\n                    that.setOptions({transition: opts.clicktransition});\n\n                    // now safe to pass base transition to o_transition, so that.show will restor it\n                    o_transition = _o_transition;\n                    // this timeout is here to prevent jerking in some browsers\n                    clickToShow.t = setTimeout(function () {\n                        that.show(showOptions);\n                    }, 10);\n                }, 0);\n            } else {\n                that.show(showOptions, e);\n            }\n        }\n\n        function onStageTap(e, toggleControlsFLAG) {\n            var target = e.target,\n                $target = $(target);\n            if ($target.hasClass(videoPlayClass)) {\n                that.playVideo();\n            } else if (target === fullscreenIcon) {\n                that.toggleFullScreen();\n            } else if ($videoPlaying) {\n                target === videoClose && unloadVideo($videoPlaying, true, true);\n            } else if (!$fotorama.hasClass(fullscreenClass)) {\n                that.requestFullScreen();\n            }\n        }\n\n        function updateTouchTails(key, value) {\n            stageShaftTouchTail[key] = navShaftTouchTail[key] = value;\n        }\n\n        stageShaftTouchTail = moveOnTouch($stageShaft, {\n            onStart: onTouchStart,\n            onMove: function (e, result) {\n                setShadow($stage, result.edge);\n            },\n            onTouchEnd: onTouchEnd,\n            onEnd: function (result) {\n                var toggleControlsFLAG;\n\n                setShadow($stage);\n                toggleControlsFLAG = (MS_POINTER && !hoverFLAG || result.touch) &&\n                    opts.arrows;\n\n                if ((result.moved || (toggleControlsFLAG && result.pos !== result.newPos && !result.control)) && result.$target[0] !== $fullscreenIcon[0]) {\n                    var index = getIndexByPos(result.newPos, measures.w, opts.margin, repositionIndex);\n\n                    that.show({\n                        index: index,\n                        time: o_fade ? o_transitionDuration : result.time,\n                        overPos: result.overPos,\n                        user: true\n                    });\n                } else if (!result.aborted && !result.control) {\n                    onStageTap(result.startEvent, toggleControlsFLAG);\n                }\n            },\n            timeLow: 1,\n            timeHigh: 1,\n            friction: 2,\n            select: '.' + selectClass + ', .' + selectClass + ' *',\n            $wrap: $stage,\n            direction: 'horizontal'\n\n        });\n\n        navShaftTouchTail = moveOnTouch($navShaft, {\n            onStart: onTouchStart,\n            onMove: function (e, result) {\n                setShadow($nav, result.edge);\n            },\n            onTouchEnd: onTouchEnd,\n            onEnd: function (result) {\n\n                function onEnd() {\n                    slideNavShaft.l = result.newPos;\n                    releaseAutoplay();\n                    changeAutoplay();\n                    thumbsDraw(result.newPos, true);\n                    thumbArrUpdate();\n                }\n\n                if (!result.moved) {\n                    var target = result.$target.closest('.' + navFrameClass, $navShaft)[0];\n                    target && onNavFrameClick.call(target, result.startEvent);\n                } else if (result.pos !== result.newPos) {\n                    pausedAutoplayFLAG = true;\n                    slide($navShaft, {\n                        time: result.time,\n                        pos: result.newPos,\n                        overPos: result.overPos,\n                        direction: opts.navdir,\n                        onEnd: onEnd\n                    });\n                    thumbsDraw(result.newPos);\n                    o_shadows && setShadow($nav, findShadowEdge(result.newPos, navShaftTouchTail.min, navShaftTouchTail.max, result.dir));\n                } else {\n                    onEnd();\n                }\n            },\n            timeLow: .5,\n            timeHigh: 2,\n            friction: 5,\n            $wrap: $nav,\n            direction: opts.navdir\n        });\n\n        stageWheelTail = wheel($stage, {\n            shift: true,\n            onEnd: function (e, direction) {\n                onTouchStart();\n                onTouchEnd();\n                that.show({index: direction, slow: e.altKey})\n            }\n        });\n\n        navWheelTail = wheel($nav, {\n            onEnd: function (e, direction) {\n                onTouchStart();\n                onTouchEnd();\n                var newPos = stop($navShaft) + direction * .25;\n                $navShaft.css(getTranslate(minMaxLimit(newPos, navShaftTouchTail.min, navShaftTouchTail.max), opts.navdir));\n                o_shadows && setShadow($nav, findShadowEdge(newPos, navShaftTouchTail.min, navShaftTouchTail.max, opts.navdir));\n                navWheelTail.prevent = {'<': newPos >= navShaftTouchTail.max, '>': newPos <= navShaftTouchTail.min};\n                clearTimeout(navWheelTail.t);\n                navWheelTail.t = setTimeout(function () {\n                    slideNavShaft.l = newPos;\n                    thumbsDraw(newPos, true)\n                }, TOUCH_TIMEOUT);\n                thumbsDraw(newPos);\n            }\n        });\n\n        $wrap.hover(\n            function () {\n                setTimeout(function () {\n                    if (touchedFLAG) return;\n                    toggleControlsClass(!(hoverFLAG = true));\n                }, 0);\n            },\n            function () {\n                if (!hoverFLAG) return;\n                toggleControlsClass(!(hoverFLAG = false));\n            }\n        );\n\n        function onNavFrameClick(e) {\n            var index = $(this).data().eq;\n\n            if (opts.navtype === 'thumbs') {\n                clickToShow({index: index, slow: e.altKey, user: true, coo: e._x - $nav.offset().left});\n            } else {\n                clickToShow({index: index, slow: e.altKey, user: true});\n            }\n        }\n\n        function onArrClick(e) {\n            clickToShow({index: $arrs.index(this) ? '>' : '<', slow: e.altKey, user: true});\n        }\n\n        smartClick($arrs, function (e) {\n            stopEvent(e);\n            onArrClick.call(this, e);\n        }, {\n            onStart: function () {\n                onTouchStart();\n                stageShaftTouchTail.control = true;\n            },\n            onTouchEnd: onTouchEnd\n        });\n\n        smartClick($thumbArrLeft, function (e) {\n            stopEvent(e);\n            if (opts.navtype === 'thumbs') {\n\n                that.show('<');\n            } else {\n                that.showSlide('prev')\n            }\n        });\n\n        smartClick($thumbArrRight, function (e) {\n            stopEvent(e);\n            if (opts.navtype === 'thumbs') {\n                that.show('>');\n            } else {\n                that.showSlide('next')\n            }\n\n        });\n\n\n        function addFocusOnControls(el) {\n            addFocus(el, function () {\n                setTimeout(function () {\n                    lockScroll($stage);\n                }, 0);\n                toggleControlsClass(false);\n            });\n        }\n\n        $arrs.each(function () {\n            addEnterUp(this, function (e) {\n                onArrClick.call(this, e);\n            });\n            addFocusOnControls(this);\n        });\n\n        addEnterUp(fullscreenIcon, function () {\n            if ($fotorama.hasClass(fullscreenClass)) {\n                that.cancelFullScreen();\n                $stageShaft.focus();\n            } else {\n                that.requestFullScreen();\n                $fullscreenIcon.focus();\n            }\n\n        });\n        addFocusOnControls(fullscreenIcon);\n\n        function reset() {\n            setData();\n            setOptions();\n\n            if (!reset.i) {\n                reset.i = true;\n                // Only once\n                var _startindex = opts.startindex;\n                activeIndex = repositionIndex = dirtyIndex = lastActiveIndex = startIndex = edgeIndex(_startindex) || 0;\n                /*(o_rtl ? size - 1 : 0)*///;\n            }\n\n            if (size) {\n                if (changeToRtl()) return;\n\n                if ($videoPlaying) {\n                    unloadVideo($videoPlaying, true);\n                }\n\n                activeIndexes = [];\n\n                if (!isVideo()) {\n                    detachFrames(STAGE_FRAME_KEY);\n                }\n\n                reset.ok = true;\n\n                that.show({index: activeIndex, time: 0});\n                that.resize();\n            } else {\n                that.destroy();\n            }\n        }\n\n        function changeToRtl() {\n\n            if (!changeToRtl.f === o_rtl) {\n                changeToRtl.f = o_rtl;\n                activeIndex = size - 1 - activeIndex;\n                that.reverse();\n\n                return true;\n            }\n        }\n\n        $.each('load push pop shift unshift reverse sort splice'.split(' '), function (i, method) {\n            that[method] = function () {\n                data = data || [];\n                if (method !== 'load') {\n                    Array.prototype[method].apply(data, arguments);\n                } else if (arguments[0] && typeof arguments[0] === 'object' && arguments[0].length) {\n                    data = clone(arguments[0]);\n                }\n                reset();\n                return that;\n            }\n        });\n\n        function ready() {\n            if (ready.ok) {\n                ready.ok = false;\n                triggerEvent('ready');\n            }\n        }\n\n        reset();\n    };\n    $.fn.fotorama = function (opts) {\n        return this.each(function () {\n            var that = this,\n                $fotorama = $(this),\n                fotoramaData = $fotorama.data(),\n                fotorama = fotoramaData.fotorama;\n\n            if (!fotorama) {\n                waitFor(function () {\n                    return !isHidden(that);\n                }, function () {\n                    fotoramaData.urtext = $fotorama.html();\n                    new $.Fotorama($fotorama,\n                        $.extend(\n                            {},\n                            OPTIONS,\n                            window.fotoramaDefaults,\n                            opts,\n                            fotoramaData\n                        )\n                    );\n                });\n            } else {\n                fotorama.setOptions(opts, true);\n            }\n        });\n    };\n    $.Fotorama.instances = [];\n\n    function calculateIndexes() {\n        $.each($.Fotorama.instances, function (index, instance) {\n            instance.index = index;\n        });\n    }\n\n    function addInstance(instance) {\n        $.Fotorama.instances.push(instance);\n        calculateIndexes();\n    }\n\n    function hideInstance(instance) {\n        $.Fotorama.instances.splice(instance.index, 1);\n        calculateIndexes();\n    }\n\n    $.Fotorama.cache = {};\n    $.Fotorama.measures = {};\n    $ = $ || {};\n    $.Fotorama = $.Fotorama || {};\n    $.Fotorama.jst = $.Fotorama.jst || {};\n\n    $.Fotorama.jst.dots = function (v) {\n        var __t, __p = '', __e = _.escape;\n        __p += '<div class=\"fotorama__nav__frame fotorama__nav__frame--dot\" tabindex=\"0\" role=\"button\" data-gallery-role=\"nav-frame\" data-nav-type=\"thumb\" aria-label>\\r\\n    <div class=\"fotorama__dot\"></div>\\r\\n</div>';\n        return __p\n    };\n\n    $.Fotorama.jst.frameCaption = function (v) {\n        var __t, __p = '', __e = _.escape;\n        __p += '<div class=\"fotorama__caption\" aria-hidden=\"true\">\\r\\n    <div class=\"fotorama__caption__wrap\" id=\"' +\n            ((__t = ( v.labelledby )) == null ? '' : __t) +\n            '\">' +\n            ((__t = ( v.caption )) == null ? '' : __t) +\n            '</div>\\r\\n</div>\\r\\n';\n        return __p\n    };\n\n    $.Fotorama.jst.style = function (v) {\n        var __t, __p = '', __e = _.escape;\n        __p += '.fotorama' +\n            ((__t = ( v.s )) == null ? '' : __t) +\n            ' .fotorama__nav--thumbs .fotorama__nav__frame{\\r\\npadding:' +\n            ((__t = ( v.m )) == null ? '' : __t) +\n            'px;\\r\\nheight:' +\n            ((__t = ( v.h )) == null ? '' : __t) +\n            'px}\\r\\n.fotorama' +\n            ((__t = ( v.s )) == null ? '' : __t) +\n            ' .fotorama__thumb-border{\\r\\nheight:' +\n            ((__t = ( v.h )) == null ? '' : __t) +\n            'px;\\r\\nborder-width:' +\n            ((__t = ( v.b )) == null ? '' : __t) +\n            'px;\\r\\nmargin-top:' +\n            ((__t = ( v.m )) == null ? '' : __t) +\n            'px}';\n        return __p\n    };\n\n    $.Fotorama.jst.thumb = function (v) {\n        var __t, __p = '', __e = _.escape;\n        __p += '<div class=\"fotorama__nav__frame fotorama__nav__frame--thumb\" tabindex=\"0\" role=\"button\" data-gallery-role=\"nav-frame\" data-nav-type=\"thumb\" aria-label>\\r\\n    <div class=\"fotorama__thumb\">\\r\\n    </div>\\r\\n</div>';\n        return __p\n    };\n})(window, document, location, typeof jQuery !== 'undefined' && jQuery);\n\n","Magento_Persistent/js/view/remember-me.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @deprecated since version 2.2.0\n */\ndefine([\n    'ko',\n    'uiComponent'\n], function (ko, Component) {\n    'use strict';\n\n    var persistenceConfig = window.checkoutConfig.persistenceConfig;\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Persistent/remember-me'\n        },\n        dataScope: 'global',\n        isRememberMeCheckboxVisible: ko.observable(persistenceConfig.isRememberMeCheckboxVisible),\n        isRememberMeCheckboxChecked: ko.observable(persistenceConfig.isRememberMeCheckboxChecked)\n    });\n});\n","Magento_Persistent/js/view/customer-data-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'mage/utils/wrapper'\n], function ($, wrapper) {\n    'use strict';\n\n    var mixin = {\n\n        /**\n         * Check if persistent section is expired due to lifetime.\n         *\n         * @param {Function} originFn - Original method.\n         * @return {Array}\n         */\n        getExpiredSectionNames: function (originFn) {\n            var expiredSections = originFn(),\n                storage = $.initNamespaceStorage('mage-cache-storage').localStorage,\n                currentTimestamp = Math.floor(Date.now() / 1000),\n                persistentIndex = expiredSections.indexOf('persistent'),\n                persistentLifeTime = 0,\n                sectionData;\n\n            if (window.persistent !== undefined && window.persistent.expirationLifetime !== undefined) {\n                persistentLifeTime = window.persistent.expirationLifetime;\n            }\n\n            if (persistentIndex !== -1) {\n                sectionData = storage.get('persistent');\n\n                if (typeof sectionData === 'object' &&\n                    sectionData['data_id'] + persistentLifeTime >= currentTimestamp\n                ) {\n                    expiredSections.splice(persistentIndex, 1);\n                }\n            }\n\n            return expiredSections;\n        }\n    };\n\n    /**\n     * Override default customer-data.getExpiredSectionNames().\n     */\n    return function (target) {\n        return wrapper.extend(target, mixin);\n    };\n});\n","Magento_Persistent/js/view/additional-welcome.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/translate',\n    'Magento_Customer/js/customer-data'\n], function ($, $t, customerData) {\n    'use strict';\n\n    return {\n        /**\n         * Init.\n         */\n        init: function () {\n            var persistent = customerData.get('persistent');\n\n            if (persistent().fullname === undefined) {\n                customerData.get('persistent').subscribe(this.replacePersistentWelcome);\n            } else {\n                this.replacePersistentWelcome();\n            }\n        },\n\n        /**\n         * Replace welcome message for customer with persistent cookie.\n         */\n        replacePersistentWelcome: function () {\n            var persistent = customerData.get('persistent'),\n                welcomeElems;\n\n            if (persistent().fullname !== undefined) {\n                welcomeElems = $('li.greet.welcome > span.not-logged-in');\n\n                if (welcomeElems.length) {\n                    $(welcomeElems).each(function () {\n                        var html = $t('Welcome, %1!').replace('%1', persistent().fullname);\n\n                        $(this).attr('data-bind', html);\n                        $(this).html(html);\n                    });\n                    $(welcomeElems).append(' <span><a ' + window.notYouLink + '>' + $t('Not you?') + '</a>');\n                }\n            }\n        },\n\n        /**\n         * @constructor\n         */\n        'Magento_Persistent/js/view/additional-welcome': function () {\n            this.init();\n        }\n    };\n});\n","Magento_Sales/js/orders-returns.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.ordersReturns', {\n        options: {\n            zipCode: '#oar-zip', // Search by zip code.\n            emailAddress: '#oar-email', // Search by email address.\n            searchType: '#quick-search-type-id' // Search element used for choosing between the two.\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            $(this.options.searchType).on('change', $.proxy(this._showIdentifyBlock, this)).trigger('change');\n        },\n\n        /**\n         * Show either the search by zip code option or the search by email address option.\n         * @private\n         * @param {jQuery.Event} e - Change event. Event target value is either 'zip' or 'email'.\n         */\n        _showIdentifyBlock: function (e) {\n            var value = $(e.target).val();\n\n            $(this.options.zipCode).toggle(value === 'zip');\n            $(this.options.emailAddress).toggle(value === 'email');\n        }\n    });\n\n    return $.mage.ordersReturns;\n});\n","Magento_Sales/js/gift-message.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.giftMessage', {\n        options: {\n            rowPrefix: '#order-item-row-', // Selector prefix for item's row in the table.\n            linkPrefix: '#order-item-gift-message-link-', // Selector prefix for the 'Gift Message' link.\n            duration: 100, // Toggle duration.\n            expandedClass: 'expanded', // Class added/removed to/from the 'Gift Message' link.\n            expandedContentClass: 'expanded-content', // Class added/removed to/from the 'Gift Message' content.\n            lastClass: 'last' // Class added/removed to/from the last item's row in the products table.\n        },\n\n        /**\n         * Bind a click handler on the widget's element to toggle the gift message.\n         * @private\n         */\n        _create: function () {\n            this.element.on('click', $.proxy(this._toggleGiftMessage, this));\n        },\n\n        /**\n         * Toggle the display of the item's corresponding gift message.\n         * @private\n         * @param {jQuery.Event} event - Click event.\n         */\n        _toggleGiftMessage: function (event) {\n            var element = $(event.target), // Click target. The 'Gift Message' link or 'Close' button.\n                options = this.options, // Cached widget options.\n                itemId = element.data('item-id'), // The individual item's numeric id.\n                link = $(options.linkPrefix + itemId), // The 'Gift Message' expandable link.\n                row = $(options.rowPrefix + itemId), // The item's row in the products table.\n                region = $('#' + element.attr('aria-controls')); // The gift message container region.\n\n            region.toggleClass(options.expandedContentClass, options.duration, function () {\n                if (region.attr('aria-expanded') === 'true') {\n                    region.attr('aria-expanded', 'false');\n\n                    if (region.hasClass(options.lastClass)) {\n                        row.addClass(options.lastClass);\n                    }\n                } else {\n                    region.attr('aria-expanded', 'true');\n\n                    if (region.hasClass(options.lastClass)) {\n                        row.removeClass(options.lastClass);\n                    }\n                }\n                link.toggleClass(options.expandedClass);\n            });\n            event.preventDefault(); // Prevent event propagation and avoid going to the link's href.\n        }\n    });\n\n    return $.mage.giftMessage;\n});\n","Magento_Sales/js/view/last-ordered-items.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Customer/js/customer-data',\n    'underscore'\n], function (Component, customerData, _) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            isShowAddToCart: false\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            this.lastOrderedItems = customerData.get('last-ordered-items');\n            this.lastOrderedItems.subscribe(this.checkSalableItems.bind(this));\n            this.checkSalableItems();\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super()\n                .observe('isShowAddToCart');\n\n            return this;\n        },\n\n        /**\n         * Check if items is_saleable and change add to cart button visibility.\n         */\n        checkSalableItems: function () {\n            var isShowAddToCart = _.some(this.lastOrderedItems().items, {\n                'is_saleable': true\n            });\n\n            this.isShowAddToCart(isShowAddToCart);\n        }\n    });\n});\n","Rahi_Customization/js/view/minicart-mixin.js":"define([\n    'uiComponent',\n    'Magento_Customer/js/customer-data',\n    'jquery',\n    'ko',\n    'underscore',\n    'sidebar',\n    'mage/translate',\n    'mage/dropdown'\n], function (Component, customerData, $, ko, _) {\n    'use strict';\n\n    var mixin = {\n        isAnixter: function (items) {\n            var value = true;\n            _.each(items, function (item) {\n                if (item.is_anixter == '1') {\n                    value = false;\n                }\n            })\n            return value;\n        }\n    };\n\n    return function (target) {\n        return target.extend(mixin);\n    };\n});","Magento_GiftMessage/js/extra-options.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @deprecated since version 2.2.0\n */\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.extraOptions', {\n        options: {\n            events: 'billingSave shippingSave',\n            additionalContainer: '#onepage-checkout-shipping-method-additional-load'\n        },\n\n        /**\n         * Set up event handler for requesting any additional extra options from the backend.\n         * @private\n         */\n        _create: function () {\n            this.element.on(this.options.events, $.proxy(this._addExtraOptions, this));\n        },\n\n        /**\n         * Fetch the extra options using an Ajax call. Extra options include Gift Receipt and\n         * Printed Card.\n         * @private\n         */\n        _addExtraOptions: function () {\n            $.ajax({\n                url: this.options.additionalUrl,\n                context: this,\n                type: 'post',\n                async: false,\n\n                /** @inheritdoc */\n                success: function (response) {\n                    $(this.options.additionalContainer).html(response).trigger('contentUpdated');\n                }\n            });\n        }\n    });\n\n    return $.mage.extraOptions;\n});\n","Magento_GiftMessage/js/gift-options.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.giftOptions', {\n        options: {\n            mageError: 'mage-error',\n            noDisplay: 'no-display',\n            requiredEntry: 'required-entry'\n        },\n\n        /**\n         * Initial toggle of the various gift options after widget instantiation.\n         * @private\n         */\n        _init: function () {\n            this._toggleVisibility();\n        },\n\n        /**\n         * Bind a click handler to the widget's context element.\n         * @private\n         */\n        _create: function () {\n            this.element.on('click', $.proxy(this._toggleVisibility, this));\n            $(this.element.data('selector').id).find('.giftmessage-area')\n                .on('change', $.proxy(this._toggleRequired, this));\n        },\n\n        /**\n         * Toggle the visibility of the widget's context element's selector(s).\n         * @private\n         * @param {jQuery.Event} event - Click event. Target is a checkbox.\n         */\n        _toggleVisibility: function (event) {\n            var checkbox = event ? $(event.target) : this.element,\n                container = $(checkbox.data('selector').id),\n                _this;\n\n            if (checkbox.is(':checked')) {\n                container.show()\n                    .find('.giftmessage-area:not(:visible)').each(function (x, element) {\n                        if ($(element).val().length > 0) {\n                            $(element).change();\n                            container.find('a').click();\n                        }\n                    });\n            } else {\n                _this = this;\n                container.hide()\n                    .find('.input-text:not(.giftmessage-area)').each(function (x, element) {\n                        $(element).val(element.defaultValue).removeClass(_this.options.mageError)\n                            .next('div.' + _this.options.mageError).remove();\n                    }).end()\n                    .find('.giftmessage-area').val('').change().end()\n                    .find('.select').val('').change().end()\n                    .find('.checkbox:checked').prop('checked', false).click().prop('checked', false).end()\n                    .find('.price-box').addClass(this.options.noDisplay).end();\n            }\n        },\n\n        /**\n         * Make the From and To input fields required if a gift message has been written.\n         * @private\n         * @param {jQuery.Event} event - Change event. Target is a textarea.\n         */\n        _toggleRequired: function (event) {\n            var textArea = $(event.target),\n                length = textArea.val().length;\n\n            textArea.closest('li').prev('.fields')\n                .find('.input-text').toggleClass(this.options.requiredEntry, length > 0);\n        }\n    });\n\n    return $.mage.giftOptions;\n});\n","Magento_GiftMessage/js/action/gift-options.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_GiftMessage/js/model/url-builder',\n    'mage/storage',\n    'Magento_Ui/js/model/messageList',\n    'Magento_Checkout/js/model/error-processor',\n    'mage/url',\n    'Magento_Checkout/js/model/quote',\n    'underscore'\n], function (urlBuilder, storage, messageList, errorProcessor, url, quote, _) {\n    'use strict';\n\n    return function (giftMessage, remove) {\n        var serviceUrl;\n\n        url.setBaseUrl(giftMessage.getConfigValue('baseUrl'));\n\n        if (giftMessage.getConfigValue('isCustomerLoggedIn')) {\n            serviceUrl = urlBuilder.createUrl('/carts/mine/gift-message', {});\n\n            if (giftMessage.itemId != 'orderLevel') { //eslint-disable-line eqeqeq\n                serviceUrl = urlBuilder.createUrl('/carts/mine/gift-message/:itemId', {\n                    itemId: giftMessage.itemId\n                });\n            }\n        } else {\n            serviceUrl = urlBuilder.createUrl('/guest-carts/:cartId/gift-message', {\n                cartId: quote.getQuoteId()\n            });\n\n            if (giftMessage.itemId != 'orderLevel') { //eslint-disable-line eqeqeq\n                serviceUrl = urlBuilder.createUrl(\n                    '/guest-carts/:cartId/gift-message/:itemId',\n                    {\n                        cartId: quote.getQuoteId(), itemId: giftMessage.itemId\n                    }\n                );\n            }\n        }\n        messageList.clear();\n\n        storage.post(\n            serviceUrl,\n            JSON.stringify({\n                'gift_message': giftMessage.getSubmitParams(remove)\n            })\n        ).done(function () {\n            giftMessage.reset();\n            _.each(giftMessage.getAfterSubmitCallbacks(), function (callback) {\n                if (_.isFunction(callback)) {\n                    callback();\n                }\n            });\n        }).fail(function (response) {\n            errorProcessor.process(response);\n        });\n    };\n});\n","Magento_GiftMessage/js/model/url-builder.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Checkout/js/model/url-builder'\n], function ($, urlBuilder) {\n    'use strict';\n\n    return $.extend(urlBuilder, {\n        storeCode: window.giftOptionsConfig.storeCode\n    });\n});\n","Magento_GiftMessage/js/model/gift-options.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'ko'\n], function (_, ko) {\n    'use strict';\n\n    return {\n        options: ko.observableArray([]),\n\n        /**\n         * @param {Object} option\n         */\n        addOption: function (option) {\n            if (!this.options().hasOwnProperty(option.itemId)) {\n                this.options.push({\n                        id: option.itemId, value: option\n                    }\n                );\n            }\n        },\n\n        /**\n         * @param {*} itemId\n         * @return {*}\n         */\n        getOptionByItemId: function (itemId) {\n            var option = null;\n\n            _.each(this.options(), function (data) {\n                if (data.id === itemId) {\n                    option = data.value;\n\n                    return false;\n                }\n            });\n\n            return option;\n        }\n    };\n});\n","Magento_GiftMessage/js/model/gift-message.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'uiElement',\n    'underscore',\n    'mage/url'\n], function (uiElement, _, url) {\n    'use strict';\n\n    var provider = uiElement();\n\n    return function (itemId) {\n        var model = {\n            id: 'message-' + itemId,\n            itemId: itemId,\n            observables: {},\n            additionalOptions: [],\n            submitParams: [\n                'recipient',\n                'sender',\n                'message'\n            ],\n\n            /**\n             * Initialize.\n             */\n            initialize: function () {\n                var message = false;\n\n                this.getObservable('alreadyAdded')(false);\n\n                if (this.itemId == 'orderLevel') { //eslint-disable-line eqeqeq\n                    message = window.giftOptionsConfig.giftMessage.hasOwnProperty(this.itemId) ?\n                        window.giftOptionsConfig.giftMessage[this.itemId] :\n                        null;\n                } else {\n                    message =\n                        window.giftOptionsConfig.giftMessage.hasOwnProperty('itemLevel') &&\n                        window.giftOptionsConfig.giftMessage.itemLevel.hasOwnProperty(this.itemId) ?\n                            window.giftOptionsConfig.giftMessage.itemLevel[this.itemId].message :\n                            null;\n                }\n\n                if (_.isObject(message)) {\n                    this.getObservable('recipient')(message.recipient);\n                    this.getObservable('sender')(message.sender);\n                    this.getObservable('message')(message.message);\n                    this.getObservable('alreadyAdded')(true);\n                }\n            },\n\n            /**\n             * @param {String} key\n             * @return {*}\n             */\n            getObservable: function (key) {\n                this.initObservable(this.id, key);\n\n                return provider[this.getUniqueKey(this.id, key)];\n            },\n\n            /**\n             * @param {String} node\n             * @param {String} key\n             */\n            initObservable: function (node, key) {\n                if (node && !this.observables.hasOwnProperty(node)) {\n                    this.observables[node] = [];\n                }\n\n                if (key && this.observables[node].indexOf(key) === -1) {\n                    this.observables[node].push(key);\n                    provider.observe(this.getUniqueKey(node, key));\n                }\n            },\n\n            /**\n             * @param {String} node\n             * @param {String} key\n             * @return {String}\n             */\n            getUniqueKey: function (node, key) {\n                return node + '-' + key;\n            },\n\n            /**\n             * @param {String} key\n             * @return {null}\n             */\n            getConfigValue: function (key) {\n                return window.giftOptionsConfig.hasOwnProperty(key) ?\n                    window.giftOptionsConfig[key]\n                    : null;\n            },\n\n            /**\n             * Reset.\n             */\n            reset: function () {\n                this.getObservable('isClear')(true);\n            },\n\n            /**\n             * @return {Array}\n             */\n            getAfterSubmitCallbacks: function () {\n                var callbacks = [];\n\n                callbacks.push(this.afterSubmit);\n                _.each(this.additionalOptions, function (option) {\n                    if (_.isFunction(option.afterSubmit)) {\n                        callbacks.push(option.afterSubmit);\n                    }\n                });\n\n                return callbacks;\n            },\n\n            /**\n             * After submit.\n             */\n            afterSubmit: function () {\n                window.location.href = url.build('checkout/cart/updatePost') +\n                    '?form_key=' + window.checkoutConfig.formKey +\n                    '&cart[]';\n            },\n\n            /**\n             * @param {Boolean} remove\n             * @return {Object}\n             */\n            getSubmitParams: function (remove) {\n                var params = {},\n                    self = this;\n\n                _.each(this.submitParams, function (key) {\n                    var observable = provider[self.getUniqueKey(self.id, key)];\n\n                    if (_.isFunction(observable)) {\n                        params[key] = remove ? null : observable();\n                    }\n                });\n\n                if (this.additionalOptions.length) {\n                    params['extension_attributes'] = {};\n                }\n                _.each(this.additionalOptions, function (option) {\n                    if (_.isFunction(option.getSubmitParams)) {\n                        params['extension_attributes'] = _.extend(\n                            params['extension_attributes'],\n                            option.getSubmitParams(remove)\n                        );\n                    }\n                });\n\n                return params;\n            },\n\n            /**\n             * Check if gift message can be displayed\n             *\n             * @returns {Boolean}\n             */\n            isGiftMessageAvailable: function () {\n                var isGloballyAvailable,\n                    giftMessageConfig,\n                    itemConfig;\n\n                // itemId represent gift message level: 'orderLevel' constant or cart item ID\n                if (this.itemId === 'orderLevel') {\n                    return this.getConfigValue('isOrderLevelGiftOptionsEnabled');\n                }\n\n                // gift message product configuration must override system configuration\n                isGloballyAvailable = this.getConfigValue('isItemLevelGiftOptionsEnabled');\n                giftMessageConfig = window.giftOptionsConfig.giftMessage;\n                itemConfig = giftMessageConfig.hasOwnProperty('itemLevel') &&\n                    giftMessageConfig.itemLevel.hasOwnProperty(this.itemId) ?\n                    giftMessageConfig.itemLevel[this.itemId] :\n                    {};\n\n                return itemConfig.hasOwnProperty('is_available') ? itemConfig['is_available'] : isGloballyAvailable;\n            }\n        };\n\n        model.initialize();\n\n        return model;\n    };\n});\n","Magento_GiftMessage/js/view/gift-message.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_GiftMessage/js/model/gift-message',\n    'Magento_GiftMessage/js/model/gift-options',\n    'Magento_GiftMessage/js/action/gift-options'\n], function (Component, GiftMessage, giftOptions, giftOptionsService) {\n    'use strict';\n\n    return Component.extend({\n        formBlockVisibility: null,\n        resultBlockVisibility: null,\n        model: {},\n\n        /**\n         * Component init\n         */\n        initialize: function () {\n            var self = this,\n                model;\n\n            this._super()\n                .observe('formBlockVisibility')\n                .observe({\n                    'resultBlockVisibility': false\n                });\n\n            this.itemId = this.itemId || 'orderLevel';\n            model = new GiftMessage(this.itemId);\n            this.model = model;\n            this.isResultBlockVisible();\n            giftOptions.addOption(model);\n\n            this.model.getObservable('isClear').subscribe(function (value) {\n                if (value == true) { //eslint-disable-line eqeqeq\n                    self.formBlockVisibility(false);\n                    self.model.getObservable('alreadyAdded')(true);\n                }\n            });\n        },\n\n        /**\n         * Is reslt block visible\n         */\n        isResultBlockVisible: function () {\n            var self = this;\n\n            if (this.model.getObservable('alreadyAdded')()) {\n                this.resultBlockVisibility(true);\n            }\n            this.model.getObservable('additionalOptionsApplied').subscribe(function (value) {\n                if (value == true) { //eslint-disable-line eqeqeq\n                    self.resultBlockVisibility(true);\n                }\n            });\n        },\n\n        /**\n         * @param {String} key\n         * @return {*}\n         */\n        getObservable: function (key) {\n            return this.model.getObservable(key);\n        },\n\n        /**\n         * Hide\\Show form block\n         */\n        toggleFormBlockVisibility: function () {\n            if (!this.model.getObservable('alreadyAdded')()) {\n                this.formBlockVisibility(!this.formBlockVisibility());\n            } else {\n                this.resultBlockVisibility(!this.resultBlockVisibility());\n            }\n        },\n\n        /**\n         * Edit options\n         */\n        editOptions: function () {\n            this.resultBlockVisibility(false);\n            this.formBlockVisibility(true);\n        },\n\n        /**\n         * Delete options\n         */\n        deleteOptions: function () {\n            giftOptionsService(this.model, true);\n        },\n\n        /**\n         * Hide form block\n         */\n        hideFormBlock: function () {\n            this.formBlockVisibility(false);\n\n            if (this.model.getObservable('alreadyAdded')()) {\n                this.resultBlockVisibility(true);\n            }\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        hasActiveOptions: function () {\n            var regionData = this.getRegion('additionalOptions'),\n                options = regionData(),\n                i;\n\n            for (i = 0; i < options.length; i++) {\n                if (options[i].isActive()) {\n                    return true;\n                }\n            }\n\n            return false;\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isActive: function () {\n            return this.model.isGiftMessageAvailable();\n        },\n\n        /**\n         * Submit options\n         */\n        submitOptions: function () {\n            giftOptionsService(this.model);\n        }\n    });\n});\n","ET_Base/js/countdown-timer.min.js":"define([\r\n    \"jquery\",\r\n], function($) {\r\n!function(t){\"use strict\";function e(t){if(t instanceof Date)return t;throw new Error(\"Couldn't cast `\"+t+\"` to a date object.\")}function s(t){var e=t.toString().replace(/([.?*+^$[\\]\\\\(){}|-])/g,\"\\\\$1\");return new RegExp(e)}function o(t){var e={Y:\"years\",m:\"months\",n:\"daysToMonth\",d:\"daysToWeek\",w:\"weeks\",W:\"weeksToMonth\",H:\"hours\",M:\"minutes\",S:\"seconds\",D:\"totalDays\",I:\"totalHours\",N:\"totalMinutes\",T:\"totalSeconds\"};return function(o){var n=o.match(/%(-|!)?[A-Z]{1}(:[^;]+;)?/gi);if(n)for(var a=0,l=n.length;a<l;++a){var h=n[a].match(/%(-|!)?([a-zA-Z]{1})(:[^;]+;)?/),r=s(h[0]),c=h[1]||\"\",f=h[3]||\"\",u=null;h=h[2],e.hasOwnProperty(h)&&(u=e[h],u=Number(t[u])),null!==u&&(\"!\"===c&&(u=i(f,u)),\"\"===c&&u<10&&(u=\"0\"+u.toString()),o=o.replace(r,u.toString()))}return o=o.replace(/%%/,\"%\")}}function i(t,e){var s=\"s\",o=\"\";return t&&(1===(t=t.replace(/(:|;|\\s)/gi,\"\").split(/\\,/)).length?s=t[0]:(o=t[0],s=t[1])),Math.abs(e)>1?s:o}var n=[],a={precision:100,elapse:!1,defer:!1},l=function(e,s,o){this.el=e,this.$el=t(e),this.interval=null,this.offset={},this.options=t.extend({},a),this.instanceNumber=n.length,n.push(this),this.$el.data(\"countdown-instance\",this.instanceNumber),o&&(\"function\"==typeof o?(this.$el.on(\"update.countdown\",o),this.$el.on(\"stoped.countdown\",o),this.$el.on(\"finish.countdown\",o)):this.options=t.extend({},a,o)),this.setFinalDate(s),!1===this.options.defer&&this.start()};l.prototype.start=function(){null!==this.interval&&clearInterval(this.interval);var t=this;this.update(),this.interval=setInterval(function(){t.update.call(t)},this.options.precision)},l.prototype.stop=function(){clearInterval(this.interval),this.interval=null,this.dispatchEvent(\"stoped\")},l.prototype.toggle=function(){this.interval?this.stop():this.start()},l.prototype.pause=function(){this.stop()},l.prototype.resume=function(){this.start()},l.prototype.remove=function(){this.stop.call(this),n[this.instanceNumber]=null,delete this.$el.data().countdownInstance},l.prototype.setFinalDate=function(t){this.finalDate=e(t)},l.prototype.update=function(){if(0!==this.$el.closest(\"html\").length){var e,s=void 0!==t._data(this.el,\"events\"),o=new Date;e=this.finalDate.getTime()-o.getTime(),e=Math.ceil(e/1e3),e=!this.options.elapse&&e<0?0:Math.abs(e),this.totalSecsLeft!==e&&s&&(this.totalSecsLeft=e,this.elapsed=o>=this.finalDate,this.offset={seconds:this.totalSecsLeft%60,minutes:Math.floor(this.totalSecsLeft/60)%60,hours:Math.floor(this.totalSecsLeft/60/60)%24,days:Math.floor(this.totalSecsLeft/60/60/24)%7,daysToWeek:Math.floor(this.totalSecsLeft/60/60/24)%7,daysToMonth:Math.floor(this.totalSecsLeft/60/60/24%30.4368),weeks:Math.floor(this.totalSecsLeft/60/60/24/7),weeksToMonth:Math.floor(this.totalSecsLeft/60/60/24/7)%4,months:Math.floor(this.totalSecsLeft/60/60/24/30.4368),years:Math.abs(this.finalDate.getFullYear()-o.getFullYear()),totalDays:Math.floor(this.totalSecsLeft/60/60/24),totalHours:Math.floor(this.totalSecsLeft/60/60),totalMinutes:Math.floor(this.totalSecsLeft/60),totalSeconds:this.totalSecsLeft},this.options.elapse||0!==this.totalSecsLeft?this.dispatchEvent(\"update\"):(this.stop(),this.dispatchEvent(\"finish\")))}else this.remove()},l.prototype.dispatchEvent=function(e){var s=t.Event(e+\".countdown\");s.finalDate=this.finalDate,s.elapsed=this.elapsed,s.offset=t.extend({},this.offset),s.strftime=o(this.offset),this.$el.trigger(s)},t.fn.countdown=function(){var e=Array.prototype.slice.call(arguments,0);return this.each(function(){var s=t(this).data(\"countdown-instance\");if(void 0!==s){var o=n[s],i=e[0];l.prototype.hasOwnProperty(i)?o[i].apply(o,e.slice(1)):null===String(i).match(/^[$A-Z_][0-9A-Z_$]*$/i)?(o.setFinalDate.call(o,i),o.start()):t.error(\"Method %s does not exist on jQuery.countdown\".replace(/\\%s/gi,i))}else new l(this,e[0],e[1])})}}(window.jQuery);\r\n});","ET_Base/js/owl.carousel.min.js":"/**\n * Owl Carousel v2.3.4\n * Copyright 2013-2018 David Deutsch\n * Licensed under: SEE LICENSE IN https://github.com/OwlCarousel2/OwlCarousel2/blob/master/LICENSE\n */\ndefine(['jquery'], function () {\n!function(a,b,c,d){function e(b,c){this.settings=null,this.options=a.extend({},e.Defaults,c),this.$element=a(b),this._handlers={},this._plugins={},this._supress={},this._current=null,this._speed=null,this._coordinates=[],this._breakpoint=null,this._width=null,this._items=[],this._clones=[],this._mergers=[],this._widths=[],this._invalidated={},this._pipe=[],this._drag={time:null,target:null,pointer:null,stage:{start:null,current:null},direction:null},this._states={current:{},tags:{initializing:[\"busy\"],animating:[\"busy\"],dragging:[\"interacting\"]}},a.each([\"onResize\",\"onThrottledResize\"],a.proxy(function(b,c){this._handlers[c]=a.proxy(this[c],this)},this)),a.each(e.Plugins,a.proxy(function(a,b){this._plugins[a.charAt(0).toLowerCase()+a.slice(1)]=new b(this)},this)),a.each(e.Workers,a.proxy(function(b,c){this._pipe.push({filter:c.filter,run:a.proxy(c.run,this)})},this)),this.setup(),this.initialize()}e.Defaults={items:3,loop:!1,center:!1,rewind:!1,checkVisibility:!0,mouseDrag:!0,touchDrag:!0,pullDrag:!0,freeDrag:!1,margin:0,stagePadding:0,merge:!1,mergeFit:!0,autoWidth:!1,startPosition:0,rtl:!1,smartSpeed:250,fluidSpeed:!1,dragEndSpeed:!1,responsive:{},responsiveRefreshRate:200,responsiveBaseElement:b,fallbackEasing:\"swing\",slideTransition:\"\",info:!1,nestedItemSelector:!1,itemElement:\"div\",stageElement:\"div\",refreshClass:\"owl-refresh\",loadedClass:\"owl-loaded\",loadingClass:\"owl-loading\",rtlClass:\"owl-rtl\",responsiveClass:\"owl-responsive\",dragClass:\"owl-drag\",itemClass:\"owl-item\",stageClass:\"owl-stage\",stageOuterClass:\"owl-stage-outer\",grabClass:\"owl-grab\"},e.Width={Default:\"default\",Inner:\"inner\",Outer:\"outer\"},e.Type={Event:\"event\",State:\"state\"},e.Plugins={},e.Workers=[{filter:[\"width\",\"settings\"],run:function(){this._width=this.$element.width()}},{filter:[\"width\",\"items\",\"settings\"],run:function(a){a.current=this._items&&this._items[this.relative(this._current)]}},{filter:[\"items\",\"settings\"],run:function(){this.$stage.children(\".cloned\").remove()}},{filter:[\"width\",\"items\",\"settings\"],run:function(a){var b=this.settings.margin||\"\",c=!this.settings.autoWidth,d=this.settings.rtl,e={width:\"auto\",\"margin-left\":d?b:\"\",\"margin-right\":d?\"\":b};!c&&this.$stage.children().css(e),a.css=e}},{filter:[\"width\",\"items\",\"settings\"],run:function(a){var b=(this.width()/this.settings.items).toFixed(3)-this.settings.margin,c=null,d=this._items.length,e=!this.settings.autoWidth,f=[];for(a.items={merge:!1,width:b};d--;)c=this._mergers[d],c=this.settings.mergeFit&&Math.min(c,this.settings.items)||c,a.items.merge=c>1||a.items.merge,f[d]=e?b*c:this._items[d].width();this._widths=f}},{filter:[\"items\",\"settings\"],run:function(){var b=[],c=this._items,d=this.settings,e=Math.max(2*d.items,4),f=2*Math.ceil(c.length/2),g=d.loop&&c.length?d.rewind?e:Math.max(e,f):0,h=\"\",i=\"\";for(g/=2;g>0;)b.push(this.normalize(b.length/2,!0)),h+=c[b[b.length-1]][0].outerHTML,b.push(this.normalize(c.length-1-(b.length-1)/2,!0)),i=c[b[b.length-1]][0].outerHTML+i,g-=1;this._clones=b,a(h).addClass(\"cloned\").appendTo(this.$stage),a(i).addClass(\"cloned\").prependTo(this.$stage)}},{filter:[\"width\",\"items\",\"settings\"],run:function(){for(var a=this.settings.rtl?1:-1,b=this._clones.length+this._items.length,c=-1,d=0,e=0,f=[];++c<b;)d=f[c-1]||0,e=this._widths[this.relative(c)]+this.settings.margin,f.push(d+e*a);this._coordinates=f}},{filter:[\"width\",\"items\",\"settings\"],run:function(){var a=this.settings.stagePadding,b=this._coordinates,c={width:Math.ceil(Math.abs(b[b.length-1]))+2*a,\"padding-left\":a||\"\",\"padding-right\":a||\"\"};this.$stage.css(c)}},{filter:[\"width\",\"items\",\"settings\"],run:function(a){var b=this._coordinates.length,c=!this.settings.autoWidth,d=this.$stage.children();if(c&&a.items.merge)for(;b--;)a.css.width=this._widths[this.relative(b)],d.eq(b).css(a.css);else c&&(a.css.width=a.items.width,d.css(a.css))}},{filter:[\"items\"],run:function(){this._coordinates.length<1&&this.$stage.removeAttr(\"style\")}},{filter:[\"width\",\"items\",\"settings\"],run:function(a){a.current=a.current?this.$stage.children().index(a.current):0,a.current=Math.max(this.minimum(),Math.min(this.maximum(),a.current)),this.reset(a.current)}},{filter:[\"position\"],run:function(){this.animate(this.coordinates(this._current))}},{filter:[\"width\",\"position\",\"items\",\"settings\"],run:function(){var a,b,c,d,e=this.settings.rtl?1:-1,f=2*this.settings.stagePadding,g=this.coordinates(this.current())+f,h=g+this.width()*e,i=[];for(c=0,d=this._coordinates.length;c<d;c++)a=this._coordinates[c-1]||0,b=Math.abs(this._coordinates[c])+f*e,(this.op(a,\"<=\",g)&&this.op(a,\">\",h)||this.op(b,\"<\",g)&&this.op(b,\">\",h))&&i.push(c);this.$stage.children(\".active\").removeClass(\"active\"),this.$stage.children(\":eq(\"+i.join(\"), :eq(\")+\")\").addClass(\"active\"),this.$stage.children(\".center\").removeClass(\"center\"),this.settings.center&&this.$stage.children().eq(this.current()).addClass(\"center\")}}],e.prototype.initializeStage=function(){this.$stage=this.$element.find(\".\"+this.settings.stageClass),this.$stage.length||(this.$element.addClass(this.options.loadingClass),this.$stage=a(\"<\"+this.settings.stageElement+\">\",{class:this.settings.stageClass}).wrap(a(\"<div/>\",{class:this.settings.stageOuterClass})),this.$element.append(this.$stage.parent()))},e.prototype.initializeItems=function(){var b=this.$element.find(\".owl-item\");if(b.length)return this._items=b.get().map(function(b){return a(b)}),this._mergers=this._items.map(function(){return 1}),void this.refresh();this.replace(this.$element.children().not(this.$stage.parent())),this.isVisible()?this.refresh():this.invalidate(\"width\"),this.$element.removeClass(this.options.loadingClass).addClass(this.options.loadedClass)},e.prototype.initialize=function(){if(this.enter(\"initializing\"),this.trigger(\"initialize\"),this.$element.toggleClass(this.settings.rtlClass,this.settings.rtl),this.settings.autoWidth&&!this.is(\"pre-loading\")){var a,b,c;a=this.$element.find(\"img\"),b=this.settings.nestedItemSelector?\".\"+this.settings.nestedItemSelector:d,c=this.$element.children(b).width(),a.length&&c<=0&&this.preloadAutoWidthImages(a)}this.initializeStage(),this.initializeItems(),this.registerEventHandlers(),this.leave(\"initializing\"),this.trigger(\"initialized\")},e.prototype.isVisible=function(){return!this.settings.checkVisibility||this.$element.is(\":visible\")},e.prototype.setup=function(){var b=this.viewport(),c=this.options.responsive,d=-1,e=null;c?(a.each(c,function(a){a<=b&&a>d&&(d=Number(a))}),e=a.extend({},this.options,c[d]),\"function\"==typeof e.stagePadding&&(e.stagePadding=e.stagePadding()),delete e.responsive,e.responsiveClass&&this.$element.attr(\"class\",this.$element.attr(\"class\").replace(new RegExp(\"(\"+this.options.responsiveClass+\"-)\\\\S+\\\\s\",\"g\"),\"$1\"+d))):e=a.extend({},this.options),this.trigger(\"change\",{property:{name:\"settings\",value:e}}),this._breakpoint=d,this.settings=e,this.invalidate(\"settings\"),this.trigger(\"changed\",{property:{name:\"settings\",value:this.settings}})},e.prototype.optionsLogic=function(){this.settings.autoWidth&&(this.settings.stagePadding=!1,this.settings.merge=!1)},e.prototype.prepare=function(b){var c=this.trigger(\"prepare\",{content:b});return c.data||(c.data=a(\"<\"+this.settings.itemElement+\"/>\").addClass(this.options.itemClass).append(b)),this.trigger(\"prepared\",{content:c.data}),c.data},e.prototype.update=function(){for(var b=0,c=this._pipe.length,d=a.proxy(function(a){return this[a]},this._invalidated),e={};b<c;)(this._invalidated.all||a.grep(this._pipe[b].filter,d).length>0)&&this._pipe[b].run(e),b++;this._invalidated={},!this.is(\"valid\")&&this.enter(\"valid\")},e.prototype.width=function(a){switch(a=a||e.Width.Default){case e.Width.Inner:case e.Width.Outer:return this._width;default:return this._width-2*this.settings.stagePadding+this.settings.margin}},e.prototype.refresh=function(){this.enter(\"refreshing\"),this.trigger(\"refresh\"),this.setup(),this.optionsLogic(),this.$element.addClass(this.options.refreshClass),this.update(),this.$element.removeClass(this.options.refreshClass),this.leave(\"refreshing\"),this.trigger(\"refreshed\")},e.prototype.onThrottledResize=function(){b.clearTimeout(this.resizeTimer),this.resizeTimer=b.setTimeout(this._handlers.onResize,this.settings.responsiveRefreshRate)},e.prototype.onResize=function(){return!!this._items.length&&(this._width!==this.$element.width()&&(!!this.isVisible()&&(this.enter(\"resizing\"),this.trigger(\"resize\").isDefaultPrevented()?(this.leave(\"resizing\"),!1):(this.invalidate(\"width\"),this.refresh(),this.leave(\"resizing\"),void this.trigger(\"resized\")))))},e.prototype.registerEventHandlers=function(){a.support.transition&&this.$stage.on(a.support.transition.end+\".owl.core\",a.proxy(this.onTransitionEnd,this)),!1!==this.settings.responsive&&this.on(b,\"resize\",this._handlers.onThrottledResize),this.settings.mouseDrag&&(this.$element.addClass(this.options.dragClass),this.$stage.on(\"mousedown.owl.core\",a.proxy(this.onDragStart,this)),this.$stage.on(\"dragstart.owl.core selectstart.owl.core\",function(){return!1})),this.settings.touchDrag&&(this.$stage.on(\"touchstart.owl.core\",a.proxy(this.onDragStart,this)),this.$stage.on(\"touchcancel.owl.core\",a.proxy(this.onDragEnd,this)))},e.prototype.onDragStart=function(b){var d=null;3!==b.which&&(a.support.transform?(d=this.$stage.css(\"transform\").replace(/.*\\(|\\)| /g,\"\").split(\",\"),d={x:d[16===d.length?12:4],y:d[16===d.length?13:5]}):(d=this.$stage.position(),d={x:this.settings.rtl?d.left+this.$stage.width()-this.width()+this.settings.margin:d.left,y:d.top}),this.is(\"animating\")&&(a.support.transform?this.animate(d.x):this.$stage.stop(),this.invalidate(\"position\")),this.$element.toggleClass(this.options.grabClass,\"mousedown\"===b.type),this.speed(0),this._drag.time=(new Date).getTime(),this._drag.target=a(b.target),this._drag.stage.start=d,this._drag.stage.current=d,this._drag.pointer=this.pointer(b),a(c).on(\"mouseup.owl.core touchend.owl.core\",a.proxy(this.onDragEnd,this)),a(c).one(\"mousemove.owl.core touchmove.owl.core\",a.proxy(function(b){var d=this.difference(this._drag.pointer,this.pointer(b));a(c).on(\"mousemove.owl.core touchmove.owl.core\",a.proxy(this.onDragMove,this)),Math.abs(d.x)<Math.abs(d.y)&&this.is(\"valid\")||(b.preventDefault(),this.enter(\"dragging\"),this.trigger(\"drag\"))},this)))},e.prototype.onDragMove=function(a){var b=null,c=null,d=null,e=this.difference(this._drag.pointer,this.pointer(a)),f=this.difference(this._drag.stage.start,e);this.is(\"dragging\")&&(a.preventDefault(),this.settings.loop?(b=this.coordinates(this.minimum()),c=this.coordinates(this.maximum()+1)-b,f.x=((f.x-b)%c+c)%c+b):(b=this.settings.rtl?this.coordinates(this.maximum()):this.coordinates(this.minimum()),c=this.settings.rtl?this.coordinates(this.minimum()):this.coordinates(this.maximum()),d=this.settings.pullDrag?-1*e.x/5:0,f.x=Math.max(Math.min(f.x,b+d),c+d)),this._drag.stage.current=f,this.animate(f.x))},e.prototype.onDragEnd=function(b){var d=this.difference(this._drag.pointer,this.pointer(b)),e=this._drag.stage.current,f=d.x>0^this.settings.rtl?\"left\":\"right\";a(c).off(\".owl.core\"),this.$element.removeClass(this.options.grabClass),(0!==d.x&&this.is(\"dragging\")||!this.is(\"valid\"))&&(this.speed(this.settings.dragEndSpeed||this.settings.smartSpeed),this.current(this.closest(e.x,0!==d.x?f:this._drag.direction)),this.invalidate(\"position\"),this.update(),this._drag.direction=f,(Math.abs(d.x)>3||(new Date).getTime()-this._drag.time>300)&&this._drag.target.one(\"click.owl.core\",function(){return!1})),this.is(\"dragging\")&&(this.leave(\"dragging\"),this.trigger(\"dragged\"))},e.prototype.closest=function(b,c){var e=-1,f=30,g=this.width(),h=this.coordinates();return this.settings.freeDrag||a.each(h,a.proxy(function(a,i){return\"left\"===c&&b>i-f&&b<i+f?e=a:\"right\"===c&&b>i-g-f&&b<i-g+f?e=a+1:this.op(b,\"<\",i)&&this.op(b,\">\",h[a+1]!==d?h[a+1]:i-g)&&(e=\"left\"===c?a+1:a),-1===e},this)),this.settings.loop||(this.op(b,\">\",h[this.minimum()])?e=b=this.minimum():this.op(b,\"<\",h[this.maximum()])&&(e=b=this.maximum())),e},e.prototype.animate=function(b){var c=this.speed()>0;this.is(\"animating\")&&this.onTransitionEnd(),c&&(this.enter(\"animating\"),this.trigger(\"translate\")),a.support.transform3d&&a.support.transition?this.$stage.css({transform:\"translate3d(\"+b+\"px,0px,0px)\",transition:this.speed()/1e3+\"s\"+(this.settings.slideTransition?\" \"+this.settings.slideTransition:\"\")}):c?this.$stage.animate({left:b+\"px\"},this.speed(),this.settings.fallbackEasing,a.proxy(this.onTransitionEnd,this)):this.$stage.css({left:b+\"px\"})},e.prototype.is=function(a){return this._states.current[a]&&this._states.current[a]>0},e.prototype.current=function(a){if(a===d)return this._current;if(0===this._items.length)return d;if(a=this.normalize(a),this._current!==a){var b=this.trigger(\"change\",{property:{name:\"position\",value:a}});b.data!==d&&(a=this.normalize(b.data)),this._current=a,this.invalidate(\"position\"),this.trigger(\"changed\",{property:{name:\"position\",value:this._current}})}return this._current},e.prototype.invalidate=function(b){return\"string\"===a.type(b)&&(this._invalidated[b]=!0,this.is(\"valid\")&&this.leave(\"valid\")),a.map(this._invalidated,function(a,b){return b})},e.prototype.reset=function(a){(a=this.normalize(a))!==d&&(this._speed=0,this._current=a,this.suppress([\"translate\",\"translated\"]),this.animate(this.coordinates(a)),this.release([\"translate\",\"translated\"]))},e.prototype.normalize=function(a,b){var c=this._items.length,e=b?0:this._clones.length;return!this.isNumeric(a)||c<1?a=d:(a<0||a>=c+e)&&(a=((a-e/2)%c+c)%c+e/2),a},e.prototype.relative=function(a){return a-=this._clones.length/2,this.normalize(a,!0)},e.prototype.maximum=function(a){var b,c,d,e=this.settings,f=this._coordinates.length;if(e.loop)f=this._clones.length/2+this._items.length-1;else if(e.autoWidth||e.merge){if(b=this._items.length)for(c=this._items[--b].width(),d=this.$element.width();b--&&!((c+=this._items[b].width()+this.settings.margin)>d););f=b+1}else f=e.center?this._items.length-1:this._items.length-e.items;return a&&(f-=this._clones.length/2),Math.max(f,0)},e.prototype.minimum=function(a){return a?0:this._clones.length/2},e.prototype.items=function(a){return a===d?this._items.slice():(a=this.normalize(a,!0),this._items[a])},e.prototype.mergers=function(a){return a===d?this._mergers.slice():(a=this.normalize(a,!0),this._mergers[a])},e.prototype.clones=function(b){var c=this._clones.length/2,e=c+this._items.length,f=function(a){return a%2==0?e+a/2:c-(a+1)/2};return b===d?a.map(this._clones,function(a,b){return f(b)}):a.map(this._clones,function(a,c){return a===b?f(c):null})},e.prototype.speed=function(a){return a!==d&&(this._speed=a),this._speed},e.prototype.coordinates=function(b){var c,e=1,f=b-1;return b===d?a.map(this._coordinates,a.proxy(function(a,b){return this.coordinates(b)},this)):(this.settings.center?(this.settings.rtl&&(e=-1,f=b+1),c=this._coordinates[b],c+=(this.width()-c+(this._coordinates[f]||0))/2*e):c=this._coordinates[f]||0,c=Math.ceil(c))},e.prototype.duration=function(a,b,c){return 0===c?0:Math.min(Math.max(Math.abs(b-a),1),6)*Math.abs(c||this.settings.smartSpeed)},e.prototype.to=function(a,b){var c=this.current(),d=null,e=a-this.relative(c),f=(e>0)-(e<0),g=this._items.length,h=this.minimum(),i=this.maximum();this.settings.loop?(!this.settings.rewind&&Math.abs(e)>g/2&&(e+=-1*f*g),a=c+e,(d=((a-h)%g+g)%g+h)!==a&&d-e<=i&&d-e>0&&(c=d-e,a=d,this.reset(c))):this.settings.rewind?(i+=1,a=(a%i+i)%i):a=Math.max(h,Math.min(i,a)),this.speed(this.duration(c,a,b)),this.current(a),this.isVisible()&&this.update()},e.prototype.next=function(a){a=a||!1,this.to(this.relative(this.current())+1,a)},e.prototype.prev=function(a){a=a||!1,this.to(this.relative(this.current())-1,a)},e.prototype.onTransitionEnd=function(a){if(a!==d&&(a.stopPropagation(),(a.target||a.srcElement||a.originalTarget)!==this.$stage.get(0)))return!1;this.leave(\"animating\"),this.trigger(\"translated\")},e.prototype.viewport=function(){var d;return this.options.responsiveBaseElement!==b?d=a(this.options.responsiveBaseElement).width():b.innerWidth?d=b.innerWidth:c.documentElement&&c.documentElement.clientWidth?d=c.documentElement.clientWidth:console.warn(\"Can not detect viewport width.\"),d},e.prototype.replace=function(b){this.$stage.empty(),this._items=[],b&&(b=b instanceof jQuery?b:a(b)),this.settings.nestedItemSelector&&(b=b.find(\".\"+this.settings.nestedItemSelector)),b.filter(function(){return 1===this.nodeType}).each(a.proxy(function(a,b){b=this.prepare(b),this.$stage.append(b),this._items.push(b),this._mergers.push(1*b.find(\"[data-merge]\").addBack(\"[data-merge]\").attr(\"data-merge\")||1)},this)),this.reset(this.isNumeric(this.settings.startPosition)?this.settings.startPosition:0),this.invalidate(\"items\")},e.prototype.add=function(b,c){var e=this.relative(this._current);c=c===d?this._items.length:this.normalize(c,!0),b=b instanceof jQuery?b:a(b),this.trigger(\"add\",{content:b,position:c}),b=this.prepare(b),0===this._items.length||c===this._items.length?(0===this._items.length&&this.$stage.append(b),0!==this._items.length&&this._items[c-1].after(b),this._items.push(b),this._mergers.push(1*b.find(\"[data-merge]\").addBack(\"[data-merge]\").attr(\"data-merge\")||1)):(this._items[c].before(b),this._items.splice(c,0,b),this._mergers.splice(c,0,1*b.find(\"[data-merge]\").addBack(\"[data-merge]\").attr(\"data-merge\")||1)),this._items[e]&&this.reset(this._items[e].index()),this.invalidate(\"items\"),this.trigger(\"added\",{content:b,position:c})},e.prototype.remove=function(a){(a=this.normalize(a,!0))!==d&&(this.trigger(\"remove\",{content:this._items[a],position:a}),this._items[a].remove(),this._items.splice(a,1),this._mergers.splice(a,1),this.invalidate(\"items\"),this.trigger(\"removed\",{content:null,position:a}))},e.prototype.preloadAutoWidthImages=function(b){b.each(a.proxy(function(b,c){this.enter(\"pre-loading\"),c=a(c),a(new Image).one(\"load\",a.proxy(function(a){c.attr(\"src\",a.target.src),c.css(\"opacity\",1),this.leave(\"pre-loading\"),!this.is(\"pre-loading\")&&!this.is(\"initializing\")&&this.refresh()},this)).attr(\"src\",c.attr(\"src\")||c.attr(\"data-src\")||c.attr(\"data-src-retina\"))},this))},e.prototype.destroy=function(){this.$element.off(\".owl.core\"),this.$stage.off(\".owl.core\"),a(c).off(\".owl.core\"),!1!==this.settings.responsive&&(b.clearTimeout(this.resizeTimer),this.off(b,\"resize\",this._handlers.onThrottledResize));for(var d in this._plugins)this._plugins[d].destroy();this.$stage.children(\".cloned\").remove(),this.$stage.unwrap(),this.$stage.children().contents().unwrap(),this.$stage.children().unwrap(),this.$stage.remove(),this.$element.removeClass(this.options.refreshClass).removeClass(this.options.loadingClass).removeClass(this.options.loadedClass).removeClass(this.options.rtlClass).removeClass(this.options.dragClass).removeClass(this.options.grabClass).attr(\"class\",this.$element.attr(\"class\").replace(new RegExp(this.options.responsiveClass+\"-\\\\S+\\\\s\",\"g\"),\"\")).removeData(\"owl.carousel\")},e.prototype.op=function(a,b,c){var d=this.settings.rtl;switch(b){case\"<\":return d?a>c:a<c;case\">\":return d?a<c:a>c;case\">=\":return d?a<=c:a>=c;case\"<=\":return d?a>=c:a<=c}},e.prototype.on=function(a,b,c,d){a.addEventListener?a.addEventListener(b,c,d):a.attachEvent&&a.attachEvent(\"on\"+b,c)},e.prototype.off=function(a,b,c,d){a.removeEventListener?a.removeEventListener(b,c,d):a.detachEvent&&a.detachEvent(\"on\"+b,c)},e.prototype.trigger=function(b,c,d,f,g){var h={item:{count:this._items.length,index:this.current()}},i=a.camelCase(a.grep([\"on\",b,d],function(a){return a}).join(\"-\").toLowerCase()),j=a.Event([b,\"owl\",d||\"carousel\"].join(\".\").toLowerCase(),a.extend({relatedTarget:this},h,c));return this._supress[b]||(a.each(this._plugins,function(a,b){b.onTrigger&&b.onTrigger(j)}),this.register({type:e.Type.Event,name:b}),this.$element.trigger(j),this.settings&&\"function\"==typeof this.settings[i]&&this.settings[i].call(this,j)),j},e.prototype.enter=function(b){a.each([b].concat(this._states.tags[b]||[]),a.proxy(function(a,b){this._states.current[b]===d&&(this._states.current[b]=0),this._states.current[b]++},this))},e.prototype.leave=function(b){a.each([b].concat(this._states.tags[b]||[]),a.proxy(function(a,b){this._states.current[b]--},this))},e.prototype.register=function(b){if(b.type===e.Type.Event){if(a.event.special[b.name]||(a.event.special[b.name]={}),!a.event.special[b.name].owl){var c=a.event.special[b.name]._default;a.event.special[b.name]._default=function(a){return!c||!c.apply||a.namespace&&-1!==a.namespace.indexOf(\"owl\")?a.namespace&&a.namespace.indexOf(\"owl\")>-1:c.apply(this,arguments)},a.event.special[b.name].owl=!0}}else b.type===e.Type.State&&(this._states.tags[b.name]?this._states.tags[b.name]=this._states.tags[b.name].concat(b.tags):this._states.tags[b.name]=b.tags,this._states.tags[b.name]=a.grep(this._states.tags[b.name],a.proxy(function(c,d){return a.inArray(c,this._states.tags[b.name])===d},this)))},e.prototype.suppress=function(b){a.each(b,a.proxy(function(a,b){this._supress[b]=!0},this))},e.prototype.release=function(b){a.each(b,a.proxy(function(a,b){delete this._supress[b]},this))},e.prototype.pointer=function(a){var c={x:null,y:null};return a=a.originalEvent||a||b.event,a=a.touches&&a.touches.length?a.touches[0]:a.changedTouches&&a.changedTouches.length?a.changedTouches[0]:a,a.pageX?(c.x=a.pageX,c.y=a.pageY):(c.x=a.clientX,c.y=a.clientY),c},e.prototype.isNumeric=function(a){return!isNaN(parseFloat(a))},e.prototype.difference=function(a,b){return{x:a.x-b.x,y:a.y-b.y}},a.fn.owlCarousel=function(b){var c=Array.prototype.slice.call(arguments,1);return this.each(function(){var d=a(this),f=d.data(\"owl.carousel\");f||(f=new e(this,\"object\"==typeof b&&b),d.data(\"owl.carousel\",f),a.each([\"next\",\"prev\",\"to\",\"destroy\",\"refresh\",\"replace\",\"add\",\"remove\"],function(b,c){f.register({type:e.Type.Event,name:c}),f.$element.on(c+\".owl.carousel.core\",a.proxy(function(a){a.namespace&&a.relatedTarget!==this&&(this.suppress([c]),f[c].apply(this,[].slice.call(arguments,1)),this.release([c]))},f))})),\"string\"==typeof b&&\"_\"!==b.charAt(0)&&f[b].apply(f,c)})},a.fn.owlCarousel.Constructor=e}(window.Zepto||window.jQuery,window,document),function(a,b,c,d){var e=function(b){this._core=b,this._interval=null,this._visible=null,this._handlers={\"initialized.owl.carousel\":a.proxy(function(a){a.namespace&&this._core.settings.autoRefresh&&this.watch()},this)},this._core.options=a.extend({},e.Defaults,this._core.options),this._core.$element.on(this._handlers)};e.Defaults={autoRefresh:!0,autoRefreshInterval:500},e.prototype.watch=function(){this._interval||(this._visible=this._core.isVisible(),this._interval=b.setInterval(a.proxy(this.refresh,this),this._core.settings.autoRefreshInterval))},e.prototype.refresh=function(){this._core.isVisible()!==this._visible&&(this._visible=!this._visible,this._core.$element.toggleClass(\"owl-hidden\",!this._visible),this._visible&&this._core.invalidate(\"width\")&&this._core.refresh())},e.prototype.destroy=function(){var a,c;b.clearInterval(this._interval);for(a in this._handlers)this._core.$element.off(a,this._handlers[a]);for(c in Object.getOwnPropertyNames(this))\"function\"!=typeof this[c]&&(this[c]=null)},a.fn.owlCarousel.Constructor.Plugins.AutoRefresh=e}(window.Zepto||window.jQuery,window,document),function(a,b,c,d){var e=function(b){this._core=b,this._loaded=[],this._handlers={\"initialized.owl.carousel change.owl.carousel resized.owl.carousel\":a.proxy(function(b){if(b.namespace&&this._core.settings&&this._core.settings.lazyLoad&&(b.property&&\"position\"==b.property.name||\"initialized\"==b.type)){var c=this._core.settings,e=c.center&&Math.ceil(c.items/2)||c.items,f=c.center&&-1*e||0,g=(b.property&&b.property.value!==d?b.property.value:this._core.current())+f,h=this._core.clones().length,i=a.proxy(function(a,b){this.load(b)},this);for(c.lazyLoadEager>0&&(e+=c.lazyLoadEager,c.loop&&(g-=c.lazyLoadEager,e++));f++<e;)this.load(h/2+this._core.relative(g)),h&&a.each(this._core.clones(this._core.relative(g)),i),g++}},this)},this._core.options=a.extend({},e.Defaults,this._core.options),this._core.$element.on(this._handlers)};e.Defaults={lazyLoad:!1,lazyLoadEager:0},e.prototype.load=function(c){var d=this._core.$stage.children().eq(c),e=d&&d.find(\".owl-lazy\");!e||a.inArray(d.get(0),this._loaded)>-1||(e.each(a.proxy(function(c,d){var e,f=a(d),g=b.devicePixelRatio>1&&f.attr(\"data-src-retina\")||f.attr(\"data-src\")||f.attr(\"data-srcset\");this._core.trigger(\"load\",{element:f,url:g},\"lazy\"),f.is(\"img\")?f.one(\"load.owl.lazy\",a.proxy(function(){f.css(\"opacity\",1),this._core.trigger(\"loaded\",{element:f,url:g},\"lazy\")},this)).attr(\"src\",g):f.is(\"source\")?f.one(\"load.owl.lazy\",a.proxy(function(){this._core.trigger(\"loaded\",{element:f,url:g},\"lazy\")},this)).attr(\"srcset\",g):(e=new Image,e.onload=a.proxy(function(){f.css({\"background-image\":'url(\"'+g+'\")',opacity:\"1\"}),this._core.trigger(\"loaded\",{element:f,url:g},\"lazy\")},this),e.src=g)},this)),this._loaded.push(d.get(0)))},e.prototype.destroy=function(){var a,b;for(a in this.handlers)this._core.$element.off(a,this.handlers[a]);for(b in Object.getOwnPropertyNames(this))\"function\"!=typeof this[b]&&(this[b]=null)},a.fn.owlCarousel.Constructor.Plugins.Lazy=e}(window.Zepto||window.jQuery,window,document),function(a,b,c,d){var e=function(c){this._core=c,this._previousHeight=null,this._handlers={\"initialized.owl.carousel refreshed.owl.carousel\":a.proxy(function(a){a.namespace&&this._core.settings.autoHeight&&this.update()},this),\"changed.owl.carousel\":a.proxy(function(a){a.namespace&&this._core.settings.autoHeight&&\"position\"===a.property.name&&this.update()},this),\"loaded.owl.lazy\":a.proxy(function(a){a.namespace&&this._core.settings.autoHeight&&a.element.closest(\".\"+this._core.settings.itemClass).index()===this._core.current()&&this.update()},this)},this._core.options=a.extend({},e.Defaults,this._core.options),this._core.$element.on(this._handlers),this._intervalId=null;var d=this;a(b).on(\"load\",function(){d._core.settings.autoHeight&&d.update()}),a(b).resize(function(){d._core.settings.autoHeight&&(null!=d._intervalId&&clearTimeout(d._intervalId),d._intervalId=setTimeout(function(){d.update()},250))})};e.Defaults={autoHeight:!1,autoHeightClass:\"owl-height\"},e.prototype.update=function(){var b=this._core._current,c=b+this._core.settings.items,d=this._core.settings.lazyLoad,e=this._core.$stage.children().toArray().slice(b,c),f=[],g=0;a.each(e,function(b,c){f.push(a(c).height())}),g=Math.max.apply(null,f),g<=1&&d&&this._previousHeight&&(g=this._previousHeight),this._previousHeight=g,this._core.$stage.parent().height(g).addClass(this._core.settings.autoHeightClass)},e.prototype.destroy=function(){var a,b;for(a in this._handlers)this._core.$element.off(a,this._handlers[a]);for(b in Object.getOwnPropertyNames(this))\"function\"!=typeof this[b]&&(this[b]=null)},a.fn.owlCarousel.Constructor.Plugins.AutoHeight=e}(window.Zepto||window.jQuery,window,document),function(a,b,c,d){var e=function(b){this._core=b,this._videos={},this._playing=null,this._handlers={\"initialized.owl.carousel\":a.proxy(function(a){a.namespace&&this._core.register({type:\"state\",name:\"playing\",tags:[\"interacting\"]})},this),\"resize.owl.carousel\":a.proxy(function(a){a.namespace&&this._core.settings.video&&this.isInFullScreen()&&a.preventDefault()},this),\"refreshed.owl.carousel\":a.proxy(function(a){a.namespace&&this._core.is(\"resizing\")&&this._core.$stage.find(\".cloned .owl-video-frame\").remove()},this),\"changed.owl.carousel\":a.proxy(function(a){a.namespace&&\"position\"===a.property.name&&this._playing&&this.stop()},this),\"prepared.owl.carousel\":a.proxy(function(b){if(b.namespace){var c=a(b.content).find(\".owl-video\");c.length&&(c.css(\"display\",\"none\"),this.fetch(c,a(b.content)))}},this)},this._core.options=a.extend({},e.Defaults,this._core.options),this._core.$element.on(this._handlers),this._core.$element.on(\"click.owl.video\",\".owl-video-play-icon\",a.proxy(function(a){this.play(a)},this))};e.Defaults={video:!1,videoHeight:!1,videoWidth:!1},e.prototype.fetch=function(a,b){var c=function(){return a.attr(\"data-vimeo-id\")?\"vimeo\":a.attr(\"data-vzaar-id\")?\"vzaar\":\"youtube\"}(),d=a.attr(\"data-vimeo-id\")||a.attr(\"data-youtube-id\")||a.attr(\"data-vzaar-id\"),e=a.attr(\"data-width\")||this._core.settings.videoWidth,f=a.attr(\"data-height\")||this._core.settings.videoHeight,g=a.attr(\"href\");if(!g)throw new Error(\"Missing video URL.\");if(d=g.match(/(http:|https:|)\\/\\/(player.|www.|app.)?(vimeo\\.com|youtu(be\\.com|\\.be|be\\.googleapis\\.com|be\\-nocookie\\.com)|vzaar\\.com)\\/(video\\/|videos\\/|embed\\/|channels\\/.+\\/|groups\\/.+\\/|watch\\?v=|v\\/)?([A-Za-z0-9._%-]*)(\\&\\S+)?/),d[3].indexOf(\"youtu\")>-1)c=\"youtube\";else if(d[3].indexOf(\"vimeo\")>-1)c=\"vimeo\";else{if(!(d[3].indexOf(\"vzaar\")>-1))throw new Error(\"Video URL not supported.\");c=\"vzaar\"}d=d[6],this._videos[g]={type:c,id:d,width:e,height:f},b.attr(\"data-video\",g),this.thumbnail(a,this._videos[g])},e.prototype.thumbnail=function(b,c){var d,e,f,g=c.width&&c.height?\"width:\"+c.width+\"px;height:\"+c.height+\"px;\":\"\",h=b.find(\"img\"),i=\"src\",j=\"\",k=this._core.settings,l=function(c){e='<div class=\"owl-video-play-icon\"></div>',d=k.lazyLoad?a(\"<div/>\",{class:\"owl-video-tn \"+j,srcType:c}):a(\"<div/>\",{class:\"owl-video-tn\",style:\"opacity:1;background-image:url(\"+c+\")\"}),b.after(d),b.after(e)};if(b.wrap(a(\"<div/>\",{class:\"owl-video-wrapper\",style:g})),this._core.settings.lazyLoad&&(i=\"data-src\",j=\"owl-lazy\"),h.length)return l(h.attr(i)),h.remove(),!1;\"youtube\"===c.type?(f=\"//img.youtube.com/vi/\"+c.id+\"/hqdefault.jpg\",l(f)):\"vimeo\"===c.type?a.ajax({type:\"GET\",url:\"//vimeo.com/api/v2/video/\"+c.id+\".json\",jsonp:\"callback\",dataType:\"jsonp\",success:function(a){f=a[0].thumbnail_large,l(f)}}):\"vzaar\"===c.type&&a.ajax({type:\"GET\",url:\"//vzaar.com/api/videos/\"+c.id+\".json\",jsonp:\"callback\",dataType:\"jsonp\",success:function(a){f=a.framegrab_url,l(f)}})},e.prototype.stop=function(){this._core.trigger(\"stop\",null,\"video\"),this._playing.find(\".owl-video-frame\").remove(),this._playing.removeClass(\"owl-video-playing\"),this._playing=null,this._core.leave(\"playing\"),this._core.trigger(\"stopped\",null,\"video\")},e.prototype.play=function(b){var c,d=a(b.target),e=d.closest(\".\"+this._core.settings.itemClass),f=this._videos[e.attr(\"data-video\")],g=f.width||\"100%\",h=f.height||this._core.$stage.height();this._playing||(this._core.enter(\"playing\"),this._core.trigger(\"play\",null,\"video\"),e=this._core.items(this._core.relative(e.index())),this._core.reset(e.index()),c=a('<iframe frameborder=\"0\" allowfullscreen mozallowfullscreen webkitAllowFullScreen ></iframe>'),c.attr(\"height\",h),c.attr(\"width\",g),\"youtube\"===f.type?c.attr(\"src\",\"//www.youtube.com/embed/\"+f.id+\"?autoplay=1&rel=0&v=\"+f.id):\"vimeo\"===f.type?c.attr(\"src\",\"//player.vimeo.com/video/\"+f.id+\"?autoplay=1\"):\"vzaar\"===f.type&&c.attr(\"src\",\"//view.vzaar.com/\"+f.id+\"/player?autoplay=true\"),a(c).wrap('<div class=\"owl-video-frame\" />').insertAfter(e.find(\".owl-video\")),this._playing=e.addClass(\"owl-video-playing\"))},e.prototype.isInFullScreen=function(){var b=c.fullscreenElement||c.mozFullScreenElement||c.webkitFullscreenElement;return b&&a(b).parent().hasClass(\"owl-video-frame\")},e.prototype.destroy=function(){var a,b;this._core.$element.off(\"click.owl.video\");for(a in this._handlers)this._core.$element.off(a,this._handlers[a]);for(b in Object.getOwnPropertyNames(this))\"function\"!=typeof this[b]&&(this[b]=null)},a.fn.owlCarousel.Constructor.Plugins.Video=e}(window.Zepto||window.jQuery,window,document),function(a,b,c,d){var e=function(b){this.core=b,this.core.options=a.extend({},e.Defaults,this.core.options),this.swapping=!0,this.previous=d,this.next=d,this.handlers={\"change.owl.carousel\":a.proxy(function(a){a.namespace&&\"position\"==a.property.name&&(this.previous=this.core.current(),this.next=a.property.value)},this),\"drag.owl.carousel dragged.owl.carousel translated.owl.carousel\":a.proxy(function(a){a.namespace&&(this.swapping=\"translated\"==a.type)},this),\"translate.owl.carousel\":a.proxy(function(a){a.namespace&&this.swapping&&(this.core.options.animateOut||this.core.options.animateIn)&&this.swap()},this)},this.core.$element.on(this.handlers)};e.Defaults={animateOut:!1,\nanimateIn:!1},e.prototype.swap=function(){if(1===this.core.settings.items&&a.support.animation&&a.support.transition){this.core.speed(0);var b,c=a.proxy(this.clear,this),d=this.core.$stage.children().eq(this.previous),e=this.core.$stage.children().eq(this.next),f=this.core.settings.animateIn,g=this.core.settings.animateOut;this.core.current()!==this.previous&&(g&&(b=this.core.coordinates(this.previous)-this.core.coordinates(this.next),d.one(a.support.animation.end,c).css({left:b+\"px\"}).addClass(\"animated owl-animated-out\").addClass(g)),f&&e.one(a.support.animation.end,c).addClass(\"animated owl-animated-in\").addClass(f))}},e.prototype.clear=function(b){a(b.target).css({left:\"\"}).removeClass(\"animated owl-animated-out owl-animated-in\").removeClass(this.core.settings.animateIn).removeClass(this.core.settings.animateOut),this.core.onTransitionEnd()},e.prototype.destroy=function(){var a,b;for(a in this.handlers)this.core.$element.off(a,this.handlers[a]);for(b in Object.getOwnPropertyNames(this))\"function\"!=typeof this[b]&&(this[b]=null)},a.fn.owlCarousel.Constructor.Plugins.Animate=e}(window.Zepto||window.jQuery,window,document),function(a,b,c,d){var e=function(b){this._core=b,this._call=null,this._time=0,this._timeout=0,this._paused=!0,this._handlers={\"changed.owl.carousel\":a.proxy(function(a){a.namespace&&\"settings\"===a.property.name?this._core.settings.autoplay?this.play():this.stop():a.namespace&&\"position\"===a.property.name&&this._paused&&(this._time=0)},this),\"initialized.owl.carousel\":a.proxy(function(a){a.namespace&&this._core.settings.autoplay&&this.play()},this),\"play.owl.autoplay\":a.proxy(function(a,b,c){a.namespace&&this.play(b,c)},this),\"stop.owl.autoplay\":a.proxy(function(a){a.namespace&&this.stop()},this),\"mouseover.owl.autoplay\":a.proxy(function(){this._core.settings.autoplayHoverPause&&this._core.is(\"rotating\")&&this.pause()},this),\"mouseleave.owl.autoplay\":a.proxy(function(){this._core.settings.autoplayHoverPause&&this._core.is(\"rotating\")&&this.play()},this),\"touchstart.owl.core\":a.proxy(function(){this._core.settings.autoplayHoverPause&&this._core.is(\"rotating\")&&this.pause()},this),\"touchend.owl.core\":a.proxy(function(){this._core.settings.autoplayHoverPause&&this.play()},this)},this._core.$element.on(this._handlers),this._core.options=a.extend({},e.Defaults,this._core.options)};e.Defaults={autoplay:!1,autoplayTimeout:5e3,autoplayHoverPause:!1,autoplaySpeed:!1},e.prototype._next=function(d){this._call=b.setTimeout(a.proxy(this._next,this,d),this._timeout*(Math.round(this.read()/this._timeout)+1)-this.read()),this._core.is(\"interacting\")||c.hidden||this._core.next(d||this._core.settings.autoplaySpeed)},e.prototype.read=function(){return(new Date).getTime()-this._time},e.prototype.play=function(c,d){var e;this._core.is(\"rotating\")||this._core.enter(\"rotating\"),c=c||this._core.settings.autoplayTimeout,e=Math.min(this._time%(this._timeout||c),c),this._paused?(this._time=this.read(),this._paused=!1):b.clearTimeout(this._call),this._time+=this.read()%c-e,this._timeout=c,this._call=b.setTimeout(a.proxy(this._next,this,d),c-e)},e.prototype.stop=function(){this._core.is(\"rotating\")&&(this._time=0,this._paused=!0,b.clearTimeout(this._call),this._core.leave(\"rotating\"))},e.prototype.pause=function(){this._core.is(\"rotating\")&&!this._paused&&(this._time=this.read(),this._paused=!0,b.clearTimeout(this._call))},e.prototype.destroy=function(){var a,b;this.stop();for(a in this._handlers)this._core.$element.off(a,this._handlers[a]);for(b in Object.getOwnPropertyNames(this))\"function\"!=typeof this[b]&&(this[b]=null)},a.fn.owlCarousel.Constructor.Plugins.autoplay=e}(window.Zepto||window.jQuery,window,document),function(a,b,c,d){\"use strict\";var e=function(b){this._core=b,this._initialized=!1,this._pages=[],this._controls={},this._templates=[],this.$element=this._core.$element,this._overrides={next:this._core.next,prev:this._core.prev,to:this._core.to},this._handlers={\"prepared.owl.carousel\":a.proxy(function(b){b.namespace&&this._core.settings.dotsData&&this._templates.push('<div class=\"'+this._core.settings.dotClass+'\">'+a(b.content).find(\"[data-dot]\").addBack(\"[data-dot]\").attr(\"data-dot\")+\"</div>\")},this),\"added.owl.carousel\":a.proxy(function(a){a.namespace&&this._core.settings.dotsData&&this._templates.splice(a.position,0,this._templates.pop())},this),\"remove.owl.carousel\":a.proxy(function(a){a.namespace&&this._core.settings.dotsData&&this._templates.splice(a.position,1)},this),\"changed.owl.carousel\":a.proxy(function(a){a.namespace&&\"position\"==a.property.name&&this.draw()},this),\"initialized.owl.carousel\":a.proxy(function(a){a.namespace&&!this._initialized&&(this._core.trigger(\"initialize\",null,\"navigation\"),this.initialize(),this.update(),this.draw(),this._initialized=!0,this._core.trigger(\"initialized\",null,\"navigation\"))},this),\"refreshed.owl.carousel\":a.proxy(function(a){a.namespace&&this._initialized&&(this._core.trigger(\"refresh\",null,\"navigation\"),this.update(),this.draw(),this._core.trigger(\"refreshed\",null,\"navigation\"))},this)},this._core.options=a.extend({},e.Defaults,this._core.options),this.$element.on(this._handlers)};e.Defaults={nav:!1,navText:['<span aria-label=\"Previous\">&#x2039;</span>','<span aria-label=\"Next\">&#x203a;</span>'],navSpeed:!1,navElement:'button type=\"button\" role=\"presentation\"',navContainer:!1,navContainerClass:\"owl-nav\",navClass:[\"owl-prev\",\"owl-next\"],slideBy:1,dotClass:\"owl-dot\",dotsClass:\"owl-dots\",dots:!0,dotsEach:!1,dotsData:!1,dotsSpeed:!1,dotsContainer:!1},e.prototype.initialize=function(){var b,c=this._core.settings;this._controls.$relative=(c.navContainer?a(c.navContainer):a(\"<div>\").addClass(c.navContainerClass).appendTo(this.$element)).addClass(\"disabled\"),this._controls.$previous=a(\"<\"+c.navElement+\">\").addClass(c.navClass[0]).html(c.navText[0]).prependTo(this._controls.$relative).on(\"click\",a.proxy(function(a){this.prev(c.navSpeed)},this)),this._controls.$next=a(\"<\"+c.navElement+\">\").addClass(c.navClass[1]).html(c.navText[1]).appendTo(this._controls.$relative).on(\"click\",a.proxy(function(a){this.next(c.navSpeed)},this)),c.dotsData||(this._templates=[a('<button role=\"button\">').addClass(c.dotClass).append(a(\"<span>\")).prop(\"outerHTML\")]),this._controls.$absolute=(c.dotsContainer?a(c.dotsContainer):a(\"<div>\").addClass(c.dotsClass).appendTo(this.$element)).addClass(\"disabled\"),this._controls.$absolute.on(\"click\",\"button\",a.proxy(function(b){var d=a(b.target).parent().is(this._controls.$absolute)?a(b.target).index():a(b.target).parent().index();b.preventDefault(),this.to(d,c.dotsSpeed)},this));for(b in this._overrides)this._core[b]=a.proxy(this[b],this)},e.prototype.destroy=function(){var a,b,c,d,e;e=this._core.settings;for(a in this._handlers)this.$element.off(a,this._handlers[a]);for(b in this._controls)\"$relative\"===b&&e.navContainer?this._controls[b].html(\"\"):this._controls[b].remove();for(d in this.overides)this._core[d]=this._overrides[d];for(c in Object.getOwnPropertyNames(this))\"function\"!=typeof this[c]&&(this[c]=null)},e.prototype.update=function(){var a,b,c,d=this._core.clones().length/2,e=d+this._core.items().length,f=this._core.maximum(!0),g=this._core.settings,h=g.center||g.autoWidth||g.dotsData?1:g.dotsEach||g.items;if(\"page\"!==g.slideBy&&(g.slideBy=Math.min(g.slideBy,g.items)),g.dots||\"page\"==g.slideBy)for(this._pages=[],a=d,b=0,c=0;a<e;a++){if(b>=h||0===b){if(this._pages.push({start:Math.min(f,a-d),end:a-d+h-1}),Math.min(f,a-d)===f)break;b=0,++c}b+=this._core.mergers(this._core.relative(a))}},e.prototype.draw=function(){var b,c=this._core.settings,d=this._core.items().length<=c.items,e=this._core.relative(this._core.current()),f=c.loop||c.rewind;this._controls.$relative.toggleClass(\"disabled\",!c.nav||d),c.nav&&(this._controls.$previous.toggleClass(\"disabled\",!f&&e<=this._core.minimum(!0)),this._controls.$next.toggleClass(\"disabled\",!f&&e>=this._core.maximum(!0))),this._controls.$absolute.toggleClass(\"disabled\",!c.dots||d),c.dots&&(b=this._pages.length-this._controls.$absolute.children().length,c.dotsData&&0!==b?this._controls.$absolute.html(this._templates.join(\"\")):b>0?this._controls.$absolute.append(new Array(b+1).join(this._templates[0])):b<0&&this._controls.$absolute.children().slice(b).remove(),this._controls.$absolute.find(\".active\").removeClass(\"active\"),this._controls.$absolute.children().eq(a.inArray(this.current(),this._pages)).addClass(\"active\"))},e.prototype.onTrigger=function(b){var c=this._core.settings;b.page={index:a.inArray(this.current(),this._pages),count:this._pages.length,size:c&&(c.center||c.autoWidth||c.dotsData?1:c.dotsEach||c.items)}},e.prototype.current=function(){var b=this._core.relative(this._core.current());return a.grep(this._pages,a.proxy(function(a,c){return a.start<=b&&a.end>=b},this)).pop()},e.prototype.getPosition=function(b){var c,d,e=this._core.settings;return\"page\"==e.slideBy?(c=a.inArray(this.current(),this._pages),d=this._pages.length,b?++c:--c,c=this._pages[(c%d+d)%d].start):(c=this._core.relative(this._core.current()),d=this._core.items().length,b?c+=e.slideBy:c-=e.slideBy),c},e.prototype.next=function(b){a.proxy(this._overrides.to,this._core)(this.getPosition(!0),b)},e.prototype.prev=function(b){a.proxy(this._overrides.to,this._core)(this.getPosition(!1),b)},e.prototype.to=function(b,c,d){var e;!d&&this._pages.length?(e=this._pages.length,a.proxy(this._overrides.to,this._core)(this._pages[(b%e+e)%e].start,c)):a.proxy(this._overrides.to,this._core)(b,c)},a.fn.owlCarousel.Constructor.Plugins.Navigation=e}(window.Zepto||window.jQuery,window,document),function(a,b,c,d){\"use strict\";var e=function(c){this._core=c,this._hashes={},this.$element=this._core.$element,this._handlers={\"initialized.owl.carousel\":a.proxy(function(c){c.namespace&&\"URLHash\"===this._core.settings.startPosition&&a(b).trigger(\"hashchange.owl.navigation\")},this),\"prepared.owl.carousel\":a.proxy(function(b){if(b.namespace){var c=a(b.content).find(\"[data-hash]\").addBack(\"[data-hash]\").attr(\"data-hash\");if(!c)return;this._hashes[c]=b.content}},this),\"changed.owl.carousel\":a.proxy(function(c){if(c.namespace&&\"position\"===c.property.name){var d=this._core.items(this._core.relative(this._core.current())),e=a.map(this._hashes,function(a,b){return a===d?b:null}).join();if(!e||b.location.hash.slice(1)===e)return;b.location.hash=e}},this)},this._core.options=a.extend({},e.Defaults,this._core.options),this.$element.on(this._handlers),a(b).on(\"hashchange.owl.navigation\",a.proxy(function(a){var c=b.location.hash.substring(1),e=this._core.$stage.children(),f=this._hashes[c]&&e.index(this._hashes[c]);f!==d&&f!==this._core.current()&&this._core.to(this._core.relative(f),!1,!0)},this))};e.Defaults={URLhashListener:!1},e.prototype.destroy=function(){var c,d;a(b).off(\"hashchange.owl.navigation\");for(c in this._handlers)this._core.$element.off(c,this._handlers[c]);for(d in Object.getOwnPropertyNames(this))\"function\"!=typeof this[d]&&(this[d]=null)},a.fn.owlCarousel.Constructor.Plugins.Hash=e}(window.Zepto||window.jQuery,window,document),function(a,b,c,d){function e(b,c){var e=!1,f=b.charAt(0).toUpperCase()+b.slice(1);return a.each((b+\" \"+h.join(f+\" \")+f).split(\" \"),function(a,b){if(g[b]!==d)return e=!c||b,!1}),e}function f(a){return e(a,!0)}var g=a(\"<support>\").get(0).style,h=\"Webkit Moz O ms\".split(\" \"),i={transition:{end:{WebkitTransition:\"webkitTransitionEnd\",MozTransition:\"transitionend\",OTransition:\"oTransitionEnd\",transition:\"transitionend\"}},animation:{end:{WebkitAnimation:\"webkitAnimationEnd\",MozAnimation:\"animationend\",OAnimation:\"oAnimationEnd\",animation:\"animationend\"}}},j={csstransforms:function(){return!!e(\"transform\")},csstransforms3d:function(){return!!e(\"perspective\")},csstransitions:function(){return!!e(\"transition\")},cssanimations:function(){return!!e(\"animation\")}};j.csstransitions()&&(a.support.transition=new String(f(\"transition\")),a.support.transition.end=i.transition.end[a.support.transition]),j.cssanimations()&&(a.support.animation=new String(f(\"animation\")),a.support.animation.end=i.animation.end[a.support.animation]),j.csstransforms()&&(a.support.transform=new String(f(\"transform\")),a.support.transform3d=j.csstransforms3d())}(window.Zepto||window.jQuery,window,document);\n                                                                                                            });","Magento_Downloadable/js/downloadable.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget',\n    'Magento_Catalog/js/price-box'\n], function ($) {\n    'use strict';\n\n    /**\n     * Downloadable widget\n     */\n    $.widget('mage.downloadable', {\n        options: {\n            priceHolderSelector: '.price-box',\n            linkElement: '',\n            allElements: ''\n        },\n\n        /**\n         * @inheritdoc\n         */\n        _init: function initLinks() {\n            var element = this.element,\n                options = $(this.options.linkElement, element);\n\n            options.trigger('change');\n        },\n\n        /**\n         *  @inheritdoc\n         */\n        _create: function () {\n            var self = this;\n\n            this.element.find(this.options.linkElement).on('change', $.proxy(function () {\n                this._reloadPrice();\n            }, this));\n\n            this.element.find(this.options.allElements).on('change', function () {\n                if (this.checked) {\n                    $('label[for=\"' + this.id + '\"] > span').text($(this).attr('data-checked'));\n                    self.element.find(self.options.linkElement + ':not(:checked)').each(function () {\n                        $(this).trigger('click');\n                    });\n                } else {\n                    $('[for=\"' + this.id + '\"] > span').text($(this).attr('data-notchecked'));\n                    self.element.find(self.options.linkElement + ':checked').each(function () {\n                        $(this).trigger('click');\n                    });\n                }\n            });\n\n            this._reloadPrice();\n        },\n\n        /**\n         * Reload product price with selected link price included\n         * @private\n         */\n        _reloadPrice: function () {\n            var finalPrice = 0,\n                basePrice = 0;\n\n            this.element.find(this.options.linkElement + ':checked').each($.proxy(function (index, element) {\n                finalPrice += this.options.config.links[$(element).val()].finalPrice;\n                basePrice += this.options.config.links[$(element).val()].basePrice;\n            }, this));\n\n            $(this.options.priceHolderSelector).trigger('updatePrice', {\n                'prices': {\n                    'finalPrice': {\n                        'amount': finalPrice\n                    },\n                    'basePrice': {\n                        'amount': basePrice\n                    }\n                }\n            });\n\n            this.reloadAllCheckText();\n        },\n\n        /**\n         * Reload all-elements-checkbox's label\n         * @private\n         */\n        reloadAllCheckText: function () {\n            var allChecked = true,\n                allElementsCheck = $(this.options.allElements),\n                allElementsLabel = $('label[for=\"' + allElementsCheck.attr('id') + '\"] > span');\n\n            $(this.options.linkElement).each(function () {\n                if (!this.checked) {\n                    allChecked = false;\n                }\n            });\n\n            if (allChecked) {\n                allElementsLabel.text(allElementsCheck.attr('data-checked'));\n                allElementsCheck.prop('checked', true);\n            } else {\n                allElementsLabel.text(allElementsCheck.attr('data-notchecked'));\n                allElementsCheck.prop('checked', false);\n            }\n        }\n    });\n\n    return $.mage.downloadable;\n});\n","Magento_CardinalCommerce/js/cardinal-client.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'uiClass',\n    'Magento_CardinalCommerce/js/cardinal-factory',\n    'Magento_Checkout/js/model/quote',\n    'mage/translate'\n], function ($, Class, cardinalFactory, quote, $t) {\n    'use strict';\n\n    return {\n        /**\n         * Starts Cardinal Consumer Authentication\n         *\n         * @param {Object} cardData\n         * @return {jQuery.Deferred}\n         */\n        startAuthentication: function (cardData) {\n            var deferred = $.Deferred();\n\n            if (this.cardinalClient) {\n                this._startAuthentication(deferred, cardData);\n            } else {\n                cardinalFactory(this.getEnvironment())\n                    .done(function (client) {\n                        this.cardinalClient = client;\n                        this._startAuthentication(deferred, cardData);\n                    }.bind(this));\n            }\n\n            return deferred.promise();\n        },\n\n        /**\n         * Cardinal Consumer Authentication\n         *\n         * @param {jQuery.Deferred} deferred\n         * @param {Object} cardData\n         */\n        _startAuthentication: function (deferred, cardData) {\n            //this.cardinalClient.configure({ logging: { level: 'verbose' } });\n            this.cardinalClient.on('payments.validated', function (data, jwt) {\n                if (data.ErrorNumber !== 0) {\n                    deferred.reject(data.ErrorDescription);\n                } else if ($.inArray(data.ActionCode, ['FAILURE', 'ERROR']) !== -1) {\n                    deferred.reject($t('Authentication Failed. Please try again with another form of payment.'));\n                } else {\n                    deferred.resolve(jwt);\n                }\n                this.cardinalClient.off('payments.validated');\n            }.bind(this));\n\n            this.cardinalClient.on('payments.setupComplete', function () {\n                this.cardinalClient.start('cca', this.getRequestOrderObject(cardData));\n                this.cardinalClient.off('payments.setupComplete');\n            }.bind(this));\n\n            this.cardinalClient.setup('init', {\n                jwt: this.getRequestJWT()\n            });\n        },\n\n        /**\n         * Returns request order object.\n         *\n         * The request order object is structured object that is used to pass data\n         * to Cardinal that describes an order you'd like to process.\n         *\n         * If you pass a request object in both the JWT and the browser,\n         * Cardinal will merge the objects together where the browser overwrites\n         * the JWT object as it is considered the most recently captured data.\n         *\n         * @param {Object} cardData\n         * @returns {Object}\n         */\n        getRequestOrderObject: function (cardData) {\n            var totalAmount = quote.totals()['base_grand_total'],\n                currencyCode = quote.totals()['base_currency_code'],\n                billingAddress = quote.billingAddress(),\n                requestObject;\n\n            requestObject = {\n                OrderDetails: {\n                    Amount: totalAmount * 100,\n                    CurrencyCode: currencyCode\n                },\n                Consumer: {\n                    Account: {\n                        AccountNumber: cardData.accountNumber,\n                        ExpirationMonth: cardData.expMonth,\n                        ExpirationYear: cardData.expYear,\n                        CardCode: cardData.cardCode\n                    },\n                    BillingAddress: {\n                        FirstName: billingAddress.firstname,\n                        LastName: billingAddress.lastname,\n                        Address1: billingAddress.street[0],\n                        Address2: billingAddress.street[1],\n                        City: billingAddress.city,\n                        State: billingAddress.region,\n                        PostalCode: billingAddress.postcode,\n                        CountryCode: billingAddress.countryId,\n                        Phone1: billingAddress.telephone\n                    }\n                }\n            };\n\n            return requestObject;\n        },\n\n        /**\n         * Returns request JWT\n         * @returns {String}\n         */\n        getRequestJWT: function () {\n            return window.checkoutConfig.cardinal.requestJWT;\n        },\n\n        /**\n         * Returns type of environment\n         * @returns {String}\n         */\n        getEnvironment: function () {\n            return window.checkoutConfig.cardinal.environment;\n        }\n    };\n});\n","Magento_CardinalCommerce/js/cardinal-factory.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    return function (environment) {\n        var deferred = $.Deferred(),\n            dependency = 'cardinaljs';\n\n        if (environment === 'sandbox') {\n            dependency = 'cardinaljsSandbox';\n        }\n\n        require(\n            [dependency],\n            function (Cardinal) {\n                deferred.resolve(Cardinal);\n            },\n            deferred.reject\n        );\n\n        return deferred.promise();\n    };\n});\n","Magento_Ups/js/model/shipping-rates-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mageUtils',\n    'Magento_Ups/js/model/shipping-rates-validation-rules',\n    'mage/translate'\n], function ($, utils, validationRules, $t) {\n    'use strict';\n\n    return {\n        validationErrors: [],\n\n        /**\n         * @param {Object} address\n         * @return {Boolean}\n         */\n        validate: function (address) {\n            var self = this;\n\n            this.validationErrors = [];\n            $.each(validationRules.getRules(), function (field, rule) {\n                var message;\n\n                if (rule.required && utils.isEmpty(address[field])) {\n                    message = $t('Field ') + field + $t(' is required.');\n                    self.validationErrors.push(message);\n                }\n            });\n\n            return !this.validationErrors.length;\n        }\n    };\n});\n","Magento_Ups/js/model/shipping-rates-validation-rules.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return {\n        /**\n         * @return {Object}\n         */\n        getRules: function () {\n            return {\n                'postcode': {\n                    'required': true\n                },\n                'country_id': {\n                    'required': true\n                }\n            };\n        }\n    };\n});\n","Magento_Ups/js/view/shipping-rates-validation.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Checkout/js/model/shipping-rates-validator',\n    'Magento_Checkout/js/model/shipping-rates-validation-rules',\n    'Magento_Ups/js/model/shipping-rates-validator',\n    'Magento_Ups/js/model/shipping-rates-validation-rules'\n], function (\n    Component,\n    defaultShippingRatesValidator,\n    defaultShippingRatesValidationRules,\n    upsShippingRatesValidator,\n    upsShippingRatesValidationRules\n) {\n    'use strict';\n\n    defaultShippingRatesValidator.registerValidator('ups', upsShippingRatesValidator);\n    defaultShippingRatesValidationRules.registerRules('ups', upsShippingRatesValidationRules);\n\n    return Component;\n});\n","Magento_Variable/js/grid/columns/radioselect.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'mage/translate',\n    'Magento_Ui/js/grid/columns/column',\n    'jquery'\n], function (_, $t, Column, jQuery) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'Magento_Variable/grid/cells/radioselect',\n            draggable: false,\n            sortable: false,\n            selectedVariableCode: null,\n            selectedVariableType: null\n        },\n\n        /**\n         * Calls 'initObservable' of parent\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super().observe(['selectedVariableCode']);\n\n            return this;\n        },\n\n        /**\n         * Remove disable class from Insert Variable button after Variable has been chosen.\n         *\n         * @return {Boolean}\n         */\n        selectVariable: function () {\n            if (jQuery('#insert_variable').hasClass('disabled')) {\n                jQuery('#insert_variable').removeClass('disabled');\n            }\n\n            return true;\n        }\n    });\n});\n","Magento_Security/js/escaper.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * A loose JavaScript version of Magento\\Framework\\Escaper\n *\n * Due to differences in how XML/HTML is processed in PHP vs JS there are a couple of minor differences in behavior\n * from the PHP counterpart.\n *\n * The first difference is that the default invocation of escapeHtml without allowedTags will double-escape existing\n * entities as the intention of such an invocation is that the input isn't supposed to contain any HTML.\n *\n * The second difference is that escapeHtml will not escape quotes. Since the input is actually being processed by the\n * DOM there is no chance of quotes being mixed with HTML syntax. And, since escapeHtml is not\n * intended to be used with raw injection into a HTML attribute, this is acceptable.\n *\n * @api\n */\ndefine([], function () {\n    'use strict';\n\n    return {\n        neverAllowedElements: ['script', 'img', 'embed', 'iframe', 'video', 'source', 'object', 'audio'],\n        generallyAllowedAttributes: ['id', 'class', 'href', 'title', 'style'],\n        forbiddenAttributesByElement: {\n            a: ['style']\n        },\n\n        /**\n         * Escape a string for safe injection into HTML\n         *\n         * @param {String} data\n         * @param {Array|null} allowedTags\n         * @returns {String}\n         */\n        escapeHtml: function (data, allowedTags) {\n            var domParser = new DOMParser(),\n                fragment = domParser.parseFromString('<div></div>', 'text/html');\n\n            fragment = fragment.body.childNodes[0];\n            allowedTags = typeof allowedTags === 'object' && allowedTags.length ? allowedTags : null;\n\n            if (allowedTags) {\n                fragment.innerHTML = data || '';\n                allowedTags = this._filterProhibitedTags(allowedTags);\n\n                this._removeComments(fragment);\n                this._removeNotAllowedElements(fragment, allowedTags);\n                this._removeNotAllowedAttributes(fragment);\n\n                return fragment.innerHTML;\n            }\n\n            fragment.textContent = data || '';\n\n            return fragment.innerHTML;\n        },\n\n        /**\n         * Remove the always forbidden tags from a list of provided tags\n         *\n         * @param {Array} tags\n         * @returns {Array}\n         * @private\n         */\n        _filterProhibitedTags: function (tags) {\n            return tags.filter(function (n) {\n                return this.neverAllowedElements.indexOf(n) === -1;\n            }.bind(this));\n        },\n\n        /**\n         * Remove comment nodes from the given node\n         *\n         * @param {Node} node\n         * @private\n         */\n        _removeComments: function (node) {\n            var treeWalker = node.ownerDocument.createTreeWalker(\n                    node,\n                    NodeFilter.SHOW_COMMENT,\n                    function () {\n                        return NodeFilter.FILTER_ACCEPT;\n                    },\n                    false\n                ),\n                nodesToRemove = [];\n\n            while (treeWalker.nextNode()) {\n                nodesToRemove.push(treeWalker.currentNode);\n            }\n\n            nodesToRemove.forEach(function (nodeToRemove) {\n                nodeToRemove.parentNode.removeChild(nodeToRemove);\n            });\n        },\n\n        /**\n         * Strip the given node of all disallowed tags while permitting any nested text nodes\n         *\n         * @param {Node} node\n         * @param {Array|null} allowedTags\n         * @private\n         */\n        _removeNotAllowedElements: function (node, allowedTags) {\n            var treeWalker = node.ownerDocument.createTreeWalker(\n                    node,\n                    NodeFilter.SHOW_ELEMENT,\n                    function (currentNode) {\n                        return allowedTags.indexOf(currentNode.nodeName.toLowerCase()) === -1 ?\n                            NodeFilter.FILTER_ACCEPT\n                            // SKIP instead of REJECT because REJECT also rejects child nodes\n                            : NodeFilter.FILTER_SKIP;\n                    },\n                false\n                ),\n                nodesToRemove = [];\n\n            while (treeWalker.nextNode()) {\n                if (allowedTags.indexOf(treeWalker.currentNode.nodeName.toLowerCase()) === -1) {\n                    nodesToRemove.push(treeWalker.currentNode);\n                }\n            }\n\n            nodesToRemove.forEach(function (nodeToRemove) {\n                nodeToRemove.parentNode.replaceChild(\n                    node.ownerDocument.createTextNode(nodeToRemove.textContent),\n                    nodeToRemove\n                );\n            });\n        },\n\n        /**\n         * Remove any invalid attributes from the given node\n         *\n         * @param {Node} node\n         * @private\n         */\n        _removeNotAllowedAttributes: function (node) {\n            var treeWalker = node.ownerDocument.createTreeWalker(\n                    node,\n                    NodeFilter.SHOW_ELEMENT,\n                    function () {\n                        return NodeFilter.FILTER_ACCEPT;\n                    },\n                false\n                ),\n                i,\n                attribute,\n                nodeName,\n                attributesToRemove = [];\n\n            while (treeWalker.nextNode()) {\n                for (i = 0; i < treeWalker.currentNode.attributes.length; i++) {\n                    attribute = treeWalker.currentNode.attributes[i];\n                    nodeName = treeWalker.currentNode.nodeName.toLowerCase();\n\n                    if (this.generallyAllowedAttributes.indexOf(attribute.name) === -1  || // eslint-disable-line max-depth,max-len\n                        this._checkHrefValue(attribute) ||\n                        this.forbiddenAttributesByElement[nodeName] &&\n                        this.forbiddenAttributesByElement[nodeName].indexOf(attribute.name) !== -1\n                    ) {\n                        attributesToRemove.push(attribute);\n                    }\n                }\n            }\n\n            attributesToRemove.forEach(function (attributeToRemove) {\n                attributeToRemove.ownerElement.removeAttribute(attributeToRemove.name);\n            });\n        },\n\n        /**\n         * Check that attribute contains script content\n         *\n         * @param {Object} attribute\n         * @private\n         */\n        _checkHrefValue: function (attribute) {\n            return attribute.nodeName === 'href' && attribute.nodeValue.startsWith('javascript');\n        }\n    };\n});\n","Magento_Fedex/js/model/shipping-rates-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mageUtils',\n    'Magento_Fedex/js/model/shipping-rates-validation-rules',\n    'mage/translate'\n], function ($, utils, validationRules, $t) {\n    'use strict';\n\n    return {\n        validationErrors: [],\n\n        /**\n         * @param {Object} address\n         * @return {Boolean}\n         */\n        validate: function (address) {\n            var self = this;\n\n            this.validationErrors = [];\n            $.each(validationRules.getRules(), function (field, rule) {\n                var message;\n\n                if (rule.required && utils.isEmpty(address[field])) {\n                    message = $t('Field ') + field + $t(' is required.');\n\n                    self.validationErrors.push(message);\n                }\n            });\n\n            return !this.validationErrors.length;\n        }\n    };\n});\n","Magento_Fedex/js/model/shipping-rates-validation-rules.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return {\n        /**\n         * @return {Object}\n         */\n        getRules: function () {\n            return {\n                'postcode': {\n                    'required': true\n                },\n                'country_id': {\n                    'required': true\n                },\n                'city': {\n                    'required': true\n                }\n            };\n        }\n    };\n});\n","Magento_Fedex/js/view/shipping-rates-validation.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Checkout/js/model/shipping-rates-validator',\n    'Magento_Checkout/js/model/shipping-rates-validation-rules',\n    'Magento_Fedex/js/model/shipping-rates-validator',\n    'Magento_Fedex/js/model/shipping-rates-validation-rules'\n], function (\n    Component,\n    defaultShippingRatesValidator,\n    defaultShippingRatesValidationRules,\n    fedexShippingRatesValidator,\n    fedexShippingRatesValidationRules\n) {\n    'use strict';\n\n    defaultShippingRatesValidator.registerValidator('fedex', fedexShippingRatesValidator);\n    defaultShippingRatesValidationRules.registerRules('fedex', fedexShippingRatesValidationRules);\n\n    return Component;\n});\n","Magento_ReCaptchaCheckout/js/model/place-order-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* eslint-disable max-nested-callbacks */\n\ndefine([\n    'jquery',\n    'mage/utils/wrapper',\n    'Magento_ReCaptchaWebapiUi/js/webapiReCaptchaRegistry'\n], function ($, wrapper, recaptchaRegistry) {\n    'use strict';\n\n    return function (placeOrder) {\n        return wrapper.wrap(placeOrder, function (originalAction, serviceUrl, payload, messageContainer) {\n            var recaptchaDeferred;\n\n            if (recaptchaRegistry.triggers.hasOwnProperty('recaptcha-checkout-place-order')) {\n                //ReCaptcha is present for checkout\n                recaptchaDeferred = $.Deferred();\n                recaptchaRegistry.addListener('recaptcha-checkout-place-order', function (token) {\n                    //Add reCaptcha value to place-order request and resolve deferred with the API call results\n                    payload.xReCaptchaValue = token;\n                    originalAction(serviceUrl, payload, messageContainer).done(function () {\n                        recaptchaDeferred.resolve.apply(recaptchaDeferred, arguments);\n                    }).fail(function () {\n                        recaptchaDeferred.reject.apply(recaptchaDeferred, arguments);\n                    });\n                });\n                //Trigger ReCaptcha validation\n                recaptchaRegistry.triggers['recaptcha-checkout-place-order']();\n\n                return recaptchaDeferred;\n            }\n\n            //No ReCaptcha, just sending the request\n            return originalAction(serviceUrl, payload, messageContainer);\n        });\n    };\n});\n","Plumrocket_LayeredNavigationLite/js/init.js":"/**\n * @package     Plumrocket_LayeredNavigationLite\n * @copyright   Copyright (c) 2020 Plumrocket Inc. (https://plumrocket.com)\n * @license     https://plumrocket.com/license   End-user License Agreement\n */\n\ndefine([\n    'underscore',\n    \"jquery\",\n    'plumrocket/product-filter/action',\n    'Plumrocket_LayeredNavigationLite/js/product/list/toolbar',\n    'Plumrocket_LayeredNavigationLite/js/model/swatch',\n    'Plumrocket_LayeredNavigationLite/js/model/price',\n    'Plumrocket_LayeredNavigationLite/js/model/real-variables',\n    'plumrocket/utils',\n    'Plumrocket_LayeredNavigationLite/js/view/apply-button',\n    'domReady!'\n], function (_, $, filterAction, toolbar, swatch, price, realVariables, utils, applyButton) {\n    \"use strict\";\n\n    $.widget('plumrocket.productfilter', {\n\n        options: {\n            filterItemSelector: '#narrow-by-list .item a, #narrow-by-list .swatch-option-link-layered',\n            pagerButtons: '.pages-items .item a',\n            clearButton: '#product-filter-clear',\n            removeFilterLink: '.filter-current .item a.action',\n            productListSelector: '.column.main',\n            filterSelector: '#layered-filter-block',\n            auto: true,\n            mobileAuto: true,\n            cleanUrl: '',\n            variables: {},\n            loader: {\n                icon: '',\n                containerSelector: '.products.wrapper',\n            },\n            scrollUp: true,\n        },\n\n        _create: function () {\n            if (! this.options.cleanUrl) {\n                return;\n            }\n\n            // Disable manual mode for mobile as it is not convenient on mobile phones.\n            if (utils.isMobile()) {\n                this.options.auto = this.options.mobileAuto;\n            }\n\n            this.options.variables = this.fixNoVariablesFormat(this.options.variables);\n\n            //Set parameters for other js\n            realVariables.init(this.options.variables);\n\n            filterAction.init(this.options);\n            filterAction.setAfterFilterCallback('initListeners', this.afterFilterCallback.bind(this), 40);\n\n            price.auto = this.options.auto;\n            price.init = this;\n\n            //Rewrite toolbar function for getting url for toolbar item\n            toolbar.rewrite();\n\n            //Emulate selected parameters for swatches\n            swatch.emulateSelected(this.options.variables);\n\n            this.addOptionChangeListener();\n            this.addPriceChangeListener();\n            this.addPageChangeListener();\n            this.initFilterContainer(this.options.filterSelector);\n        },\n\n        addOptionChangeListener: function () {\n            var self = this;\n\n            var filterContainer = document.getElementById('layered-filter-block');\n            if (! filterContainer) {\n                return;\n            }\n\n            function handleFilterItemClick(event)\n            {\n                var elem = event.target;\n                if (swatch.isSwatch(elem)) {\n                    event.preventDefault();\n                    return self.onOptionClick(elem);\n                }\n\n                elem = self.tryFindFilterElement(elem);\n\n                if (! elem.dataset.prFilter) {\n                    return;\n                }\n\n                event.preventDefault();\n                switch (elem.dataset.prFilter) {\n                    case 'item':\n                        self.onOptionClick(elem);\n                        break;\n                    case 'clearItem':\n                        realVariables.remove(elem.dataset.variable, elem.dataset.value);\n                        filterAction.applyChanges();\n                        break;\n                    case 'clearAll':\n                        realVariables.clear();\n                        filterAction.applyChanges();\n                        break;\n                    case 'doManualFilter':\n                        filterAction.applyChanges();\n                        break;\n                }\n\n                return false;\n            }\n\n            filterContainer.removeEventListener('click', handleFilterItemClick);\n            filterContainer.addEventListener('click', handleFilterItemClick);\n        },\n\n        addPriceChangeListener: function () {\n            $('#narrow-by-list .item a[data-request=\"price\"]').on('click', $.proxy(price.changeRange, this));\n        },\n\n        addPageChangeListener: function () {\n            $(this.options.pagerButtons).on('click', $.proxy(this.changePageAction, this));\n        },\n\n        /**\n         * Handle click on not selected option.\n         *\n         * @param {HTMLElement} filterItem\n         * @return {boolean}\n         */\n        onOptionClick: function (filterItem) {\n            //Fix for disabled configurable swatches\n            if (filterItem.classList.contains('swatch-option-link-layered')) {\n                if ($(filterItem).find('.disabled').length) {\n                    return false;\n                }\n                return false;\n            }\n\n            if (swatch.isSwatch(filterItem)) {\n                var request = swatch.getItemRequest(filterItem);\n                if (swatch.toggleSelected(filterItem)) {\n                    realVariables.add(request.variable, request.value);\n                } else {\n                    realVariables.remove(request.variable, request.value);\n                }\n            } else {\n                // Remove another value, but leave current to toggle work correctly.\n                if (filterItem.dataset.radio\n                    && ! realVariables.has(filterItem.dataset.variable, filterItem.dataset.value)\n                ) {\n                    $(filterItem).parents('.filter-options-content').find('.item a').removeClass('selected');\n                    realVariables.removeAllValues(filterItem.dataset.variable);\n                }\n                filterItem.classList.toggle('selected');\n                realVariables.toggle(filterItem.dataset.variable, filterItem.dataset.value);\n            }\n\n            if (this.options.auto) {\n                filterAction.applyChanges();\n            } else {\n                filterAction.preloadChanges();\n                applyButton.showFilterButton(filterItem, this.options.filterSelector);\n            }\n\n            return false;\n        },\n\n        /**\n         * Handle click on pager link.\n         *\n         * @param event\n         * @return {boolean}\n         */\n        changePageAction: function (event) {\n            var pageNumber = utils.getUrlParameter('p', event.currentTarget.href);\n            realVariables.setCurrentPage(pageNumber);\n            filterAction.applyChanges();\n            return false;\n        },\n\n        /**\n         * @param selector\n         */\n        initFilterContainer: function (selector) {\n            var containerCollapsible = $(selector).find('[data-role=\"collapsible\"]');\n            if ($(window).width() <= 750 ) {\n                try {\n                    containerCollapsible.collapsible('deactivate');\n                } catch (e) {\n                }\n            }\n\n            if ($('body').hasClass('ppf-pos-toolbar')) {\n                $(document).on('mouseup', function (e) {\n                    if (! containerCollapsible.is(e.target) // if the target of the click isn't the container...\n                        && containerCollapsible.has(e.target).length === 0 // ... nor a descendant of the container\n                    ) {\n                        try {\n                            containerCollapsible.collapsible('deactivate');\n                        } catch (e) {\n                        }\n                    }\n                });\n            }\n        },\n\n        /**\n         * Convert empty array to empty object.\n         *\n         * If there is no variables, server send empty array instead of empty object.\n         *\n         * @param variables\n         * @return {object}\n         */\n        fixNoVariablesFormat: function (variables) {\n            return _.isEmpty(variables) ? {} : variables;\n        },\n\n        /**\n         * Find needed product filter element.\n         *\n         * @param {HTMLElement} elem\n         * @return {object}\n         */\n        tryFindFilterElement: function (elem) {\n            for (var i = 1; i < 5; i++) {\n                if (elem.dataset.prFilter) {\n                    return elem;\n                }\n                if (elem.parentElement) {\n                    elem = elem.parentElement\n                } else {\n                    return elem;\n                }\n            }\n            return elem;\n        },\n\n        /**\n         * Find needed product filter element.\n         *\n         * @param {{}} data\n         */\n        afterFilterCallback: function (data) {\n            var self = this;\n            setTimeout(function () {\n                self._create();\n            }, 500)\n        },\n    });\n\n    return $.plumrocket.productfilter;\n});\n","Plumrocket_LayeredNavigationLite/js/jquery/jquery.ui.touch-punch.min.js":"/*!\n * jQuery UI Touch Punch 0.2.3\n *\n * Copyright 2011\u20132014, Dave Furfero\n * Dual licensed under the MIT or GPL Version 2 licenses.\n *\n * Depends:\n *  jquery.ui.widget.js\n *  jquery.ui.mouse.js\n */\n!function(a){function f(a,b){if(!(a.originalEvent.touches.length>1)){a.preventDefault();var c=a.originalEvent.changedTouches[0],d=document.createEvent(\"MouseEvents\");d.initMouseEvent(b,!0,!0,window,1,c.screenX,c.screenY,c.clientX,c.clientY,!1,!1,!1,!1,0,null),a.target.dispatchEvent(d)}}if(a.support.touch=\"ontouchend\"in document,a.support.touch){var e,b=a.ui.mouse.prototype,c=b._mouseInit,d=b._mouseDestroy;b._touchStart=function(a){var b=this;!e&&b._mouseCapture(a.originalEvent.changedTouches[0])&&(e=!0,b._touchMoved=!1,f(a,\"mouseover\"),f(a,\"mousemove\"),f(a,\"mousedown\"))},b._touchMove=function(a){e&&(this._touchMoved=!0,f(a,\"mousemove\"))},b._touchEnd=function(a){e&&(f(a,\"mouseup\"),f(a,\"mouseout\"),this._touchMoved||f(a,\"click\"),e=!1)},b._mouseInit=function(){var b=this;b.element.bind({touchstart:a.proxy(b,\"_touchStart\"),touchmove:a.proxy(b,\"_touchMove\"),touchend:a.proxy(b,\"_touchEnd\")}),c.call(b)},b._mouseDestroy=function(){var b=this;b.element.unbind({touchstart:a.proxy(b,\"_touchStart\"),touchmove:a.proxy(b,\"_touchMove\"),touchend:a.proxy(b,\"_touchEnd\")}),d.call(b)}}}(jQuery);","Plumrocket_LayeredNavigationLite/js/product/list/toolbar.js":"/**\n * @package     Plumrocket_ProductFilter\n * @copyright   Copyright (c) 2016 Plumrocket Inc. (https://plumrocket.com)\n * @license     https://plumrocket.com/license   End-user License Agreement\n */\n\ndefine([\n    'jquery',\n    'productListToolbarForm',\n    'plumrocket/product-filter/action',\n    'Plumrocket_LayeredNavigationLite/js/model/real-variables',\n], function ($, toolbar, processor, realVariables) {\n\n    return {\n        rewrite: function () {\n            $.mage.productListToolbarForm.prototype.changeUrl = this.changeUrl;\n        },\n        changeUrl: function (pName, pValue, defValue) {\n            realVariables.removeAllValues(pName);\n            realVariables.add(pName, pValue);\n            processor.applyChanges();\n        }\n    }\n});\n","Plumrocket_LayeredNavigationLite/js/model/real-variables.js":"/**\n * @package     Plumrocket_LayeredNavigationLite\n * @copyright   Copyright (c) 2022 Plumrocket Inc. (https://plumrocket.com)\n * @license     https://plumrocket.com/license   End-user License Agreement\n */\n\ndefine(['underscore'], function (_) {\n    'use strict';\n\n    /**\n     * Contains current filter state in following format:\n     *\n     * {\n     *     variableName: [selectedOptionId, ...],\n     * }\n     *\n     * @var {{{string}: []}}\n     */\n    var variables = {};\n\n    var currentPage = 1;\n\n    return {\n        /**\n         * Convert object of strings to object of arrays and save it.\n         *\n         * @param {{string}} realVariables\n         */\n        init: function (realVariables) {\n            variables = realVariables;\n        },\n\n        /**\n         * Add variable value.\n         *\n         * @param {string} variable\n         * @param {string} value\n         */\n        add: function (variable, value) {\n            value = String(value);\n            if (this.has(variable, value)) {\n                return;\n            }\n\n            if (typeof variables[variable] === 'object') {\n                variables[variable].push(value);\n            } else {\n                variables[variable] = [value];\n            }\n\n            this.resetCurrentPage();\n        },\n\n        /**\n         * Remove variable value.\n         *\n         * @param {string} variable\n         * @param {string} value\n         */\n        remove: function (variable, value) {\n            if (! variables.hasOwnProperty(variable)) {\n                return;\n            }\n\n            value = String(value);\n            variables[variable] = variables[variable].filter(function (val) {\n                return value !== val;\n            })\n\n            if (! variables[variable].length) {\n                delete variables[variable];\n            }\n\n            this.resetCurrentPage();\n        },\n\n        /**\n         * Remove all values of specified variable.\n         *\n         * @param {string} variable\n         */\n        removeAllValues: function (variable) {\n            if (variables.hasOwnProperty(variable)) {\n                delete variables[variable];\n            }\n        },\n\n        /**\n         * Remove all selected values.\n         */\n        clear: function () {\n            this.resetCurrentPage();\n            _.each(_.keys(variables), function (variable) {\n                this.removeAllValues(variable);\n            }.bind(this))\n        },\n\n        /**\n         * Check if value is already set.\n         *\n         * @param {string} variable\n         * @param {string} value\n         */\n        has: function (variable, value) {\n            value = String(value);\n            return typeof variables[variable] === 'object' && _.contains(variables[variable], value);\n        },\n\n        /**\n         * Remove variable value.\n         *\n         * @param {string} variable\n         * @param {string} value\n         */\n        toggle: function (variable, value) {\n            if (this.has(variable, value)) {\n                this.remove(variable, value);\n            } else {\n                this.add(variable, value);\n            }\n        },\n\n        /**\n         * Add variable.\n         *\n         * @return {{[]}}\n         */\n        getList: function () {\n            return variables;\n        },\n\n        /**\n         * Get variables hash.\n         *\n         * @return {string}\n         */\n        getCacheKey: function () {\n            var variablesNames = _.keys(variables)\n            variablesNames.sort();\n\n            var cacheVars = [];\n            _.each(variablesNames, function (variableName) {\n                cacheVars.push(variableName + '|' + variables[variableName].join('|'));\n            }.bind(this));\n            cacheVars.push('currentPage|' + this.getCurrentPage());\n\n            return cacheVars.join('||');\n        },\n\n        /**\n         * Restore 'variables' and 'currentPage' variables by cache key.\n         *\n         * @param {string} cacheKey\n         */\n        toState: function (cacheKey) {\n            this.clear();\n            var vars = cacheKey.split('||');\n\n            vars.forEach(function (item) {\n                var parts = item.split('|');\n                if ('currentPage' === parts[0]) {\n                    this.setCurrentPage(+parts[1]);\n                } else {\n                    parts.slice(1).forEach(function (value) {\n                        this.add(parts[0], value);\n                    }.bind(this));\n                }\n            }.bind(this));\n        },\n\n        /**\n         * @return {number}\n         */\n        getCurrentPage: function () {\n            return currentPage;\n        },\n\n        /**\n         * @param {number} pageNumber\n         */\n        setCurrentPage: function (pageNumber) {\n            currentPage = +pageNumber;\n        },\n\n        /**\n         * Reset page number.\n         *\n         * After applying filter we get lees products and current page con be empty,\n         * therefore we show first page.\n         */\n        resetCurrentPage: function () {\n            currentPage = 1;\n        }\n    };\n});\n","Plumrocket_LayeredNavigationLite/js/model/url-utils.js":"/**\n * @package     Plumrocket_LayeredNavigationLite\n * @copyright   Copyright (c) 2021 Plumrocket Inc. (https://plumrocket.com)\n * @license     https://plumrocket.com/license   End-user License Agreement\n */\n\n/** @deprecated since 1.1.0 */\ndefine([], function () {\n    'use strict';\n\n    return {\n        /**\n         * Parse GET params\n         *\n         * @param name\n         * @param url\n         * @return {string}\n         */\n        getUrlParameter: function (name, url) {\n            name = name.replace(/[\\[]/, '\\\\[').replace(/[\\]]/, '\\\\]');\n            var regex = new RegExp('[\\\\?&]' + name + '=([^&#]*)');\n            var results = regex.exec(url ? url : location.search);\n            return results === null ? '' : decodeURIComponent(results[1].replace(/\\+/g, ' '));\n        },\n\n        /**\n         * Adds or updates a URL parameter.\n         *\n         * @param {string} url  the URL to modify\n         * @param {string} param  the name of the parameter\n         * @param {string} paramVal  the new value for the parameter\n         * @return {string} the updated URL\n         */\n        setParameter: function (url, param, paramVal) {\n            // http://stackoverflow.com/a/10997390/2391566\n            var parts = url.split('?');\n            var baseUrl = parts[0];\n            var oldQueryString = parts[1];\n            var newParameters = [];\n            if (oldQueryString) {\n                var oldParameters = oldQueryString.split('&');\n                for (var i = 0; i < oldParameters.length; i++) {\n                    if (oldParameters[i].split('=')[0] != param) {\n                        newParameters.push(oldParameters[i]);\n                    }\n                }\n            }\n            if (paramVal) {\n                newParameters.push(param + '=' + encodeURI(paramVal));\n            }\n            if (newParameters.length > 0) {\n                newParameters.sort(); // minify count of different url\n                return baseUrl + '?' + newParameters.join('&');\n            } else {\n                return baseUrl;\n            }\n        },\n\n        /**\n         * Add/update/remove param in url\n         *\n         * @param {string} paramName\n         * @param {string} value\n         * @return {exports}\n         */\n        updateUrlParam: function (paramName, value) {\n            if (window.history.replaceState) {\n                //prevents browser from storing history with each change:\n                var newUrl = this.setParameter(window.location.href, paramName, value);\n                window.history.replaceState('', '', newUrl);\n            }\n            return this;\n        },\n    };\n});\n","Plumrocket_LayeredNavigationLite/js/model/cache.js":"/**\n * @package     Plumrocket_LayeredNavigationLite\n * @copyright   Copyright (c) 2022 Plumrocket Inc. (https://plumrocket.com)\n * @license     https://plumrocket.com/license   End-user License Agreement\n */\n\ndefine([], function () {\n    'use strict';\n\n    return {\n        dataCache: {},\n\n        /**\n         * Url to cache key mapping.\n         * e.g. https://example.com/... -> CACHE_KEY\n         *\n         * Used for navigation backward and forward.\n         */\n        urlCacheMapping: {},\n\n        has: function (cacheKey) {\n            return this.dataCache.hasOwnProperty(cacheKey);\n        },\n\n        hasUrlCache: function (url) {\n            return this.urlCacheMapping.hasOwnProperty(url);\n        },\n\n        save: function (cacheKey, data) {\n            this.dataCache[cacheKey] = data;\n            this.urlCacheMapping[data.nextUrl] = cacheKey;\n        },\n\n        get: function (cacheKey) {\n            return this.dataCache[cacheKey];\n        },\n\n        getKeyByUrl: function (url) {\n            return this.urlCacheMapping[url];\n        },\n    };\n});\n","Plumrocket_LayeredNavigationLite/js/model/data-layered.js":"/**\n * @package     Plumrocket_LayeredNavigationLite\n * @copyright   Copyright (c) 2021 Plumrocket Inc. (https://plumrocket.com)\n * @license     https://plumrocket.com/license   End-user License Agreement\n */\n\ndefine([\n    'underscore',\n    'domReady!'\n], function ($) {\n    \"use strict\";\n\n    return {\n        updateDataLayer: function (data) {\n            if (data.productlist && typeof dataLayer != 'undefined' && data.googleTagManager.length > 0) {\n                $('.products-grid').append(data.googleTagManager);\n\n                var impressions = [];\n                var impressionsData;\n\n                if (typeof staticImpressions['search_result_list'] != 'undefined') {\n                    impressionsData = staticImpressions['search_result_list'];\n                } else {\n                    impressionsData = staticImpressions['category.products.list'];\n                }\n\n                for (var i = 0; i < impressionsData.length; i++) {\n                    impressions.push({\n                        'id': impressionsData[i].id,\n                        'name': impressionsData[i].name,\n                        'category': impressionsData[i].category,\n                        'list': impressionsData[i].list,\n                        'position': impressionsData[i].position\n                    });\n                }\n\n                dataLayer.push({\n                    'event': 'productImpression',\n                    'ecommerce': {\n                        'impressions': impressions\n                    }\n                });\n            }\n        }\n    };\n});\n","Plumrocket_LayeredNavigationLite/js/model/debug-logger.js":"/**\n * @package     Plumrocket_LayeredNavigationLite\n * @copyright   Copyright (c) 2021 Plumrocket Inc. (https://plumrocket.com)\n * @license     https://plumrocket.com/license   End-user License Agreement\n */\n\ndefine([], function () {\n        'use strict';\n\n        var isDebugMode = false;\n\n        return {\n            log: function () {\n                if (isDebugMode) {\n                    console.log('Product filter debug log:');\n                    console.log(arguments);\n                }\n            },\n        };\n    }\n);\n","Plumrocket_LayeredNavigationLite/js/model/price.js":"/**\n * @package     Plumrocket_LayeredNavigationLite\n * @copyright   Copyright (c) 2016 Plumrocket Inc. (https://plumrocket.com)\n * @license     https://plumrocket.com/license   End-user License Agreement\n */\n\ndefine([\n    'jquery',\n    'Plumrocket_LayeredNavigationLite/js/model/real-variables',\n    'plumrocket/product-filter/action',\n    'Plumrocket_LayeredNavigationLite/js/model/swatch',\n    'Plumrocket_LayeredNavigationLite/js/view/apply-button',\n    'domReady!'\n], function ($, realVariables, processor, swatch, applyButton) {\n    \"use strict\";\n\n    return {\n\n        auto: true,\n        lastTo: 0,\n        lastFrom: 0,\n\n        change: function (from, to, notPrsInt, element) {\n            if (!notPrsInt) {\n                from = parseInt(from);\n                to = parseInt(to);\n            }\n\n            from = Math.floor(from);\n            to = Math.ceil(to);\n            if (this.lastTo === to && this.lastFrom === from) {\n                return;\n            }\n            this.lastTo = to;\n            this.lastFrom = from;\n\n            var $ranges = $('#narrow-by-list .item a[data-request=\"price\"]');\n            if ($ranges.length) {\n                $ranges.removeClass('selected');\n            }\n\n            realVariables.removeAllValues('price');\n            realVariables.add('price', from + '_' + to);\n\n            if (this.auto) {\n                processor.applyChanges();\n            } else {\n                processor.preloadChanges();\n                applyButton.showFilterButton(element, '#layered-filter-block');\n            }\n        },\n\n        changeRange: function (event) {\n            var $item = $(event.currentTarget);\n\n            realVariables.removeAllValues('price');\n            //Remove selected from all price ranges\n            $('#narrow-by-list .item a[data-request=\"price\"]').removeClass('selected');\n\n            //Add current price to selected filters\n            $item.addClass('selected');\n            realVariables.add('price', $item.data('value'));\n\n            var values = $item.data('value').split('_');\n            values = [parseInt(values[0]), parseInt(values[1])];\n\n            if (!values[1]) {\n                values[1] = $('#product-filter-init').data('max-price');\n            }\n\n            if (typeof jQuery.plumrocket.priceslider != 'undefined') {\n                $('#slider-range').slider(\"option\", \"values\", values);\n                $('#filter-price-amount-from').html(values[0]);\n                $('#filter-price-amount-to').html(values[1]);\n            }\n\n            if (typeof jQuery.plumrocket.priceinput != 'undefined') {\n                $('#filter-input-price-from').val(values[0]);\n                $('#filter-input-price-to').val(values[1]);\n            }\n        }\n    };\n});\n","Plumrocket_LayeredNavigationLite/js/model/filter-action.js":"/**\n * @package     Plumrocket_LayeredNavigationLite\n * @copyright   Copyright (c) 2016 Plumrocket Inc. (https://plumrocket.com)\n * @license     https://plumrocket.com/license   End-user License Agreement\n */\n\ndefine([\n    'underscore',\n    'jquery',\n    'Plumrocket_LayeredNavigationLite/js/model/full-screen-loader',\n    'Plumrocket_LayeredNavigationLite/js/model/swatch',\n    'plumrocket/utils',\n    'Plumrocket_LayeredNavigationLite/js/model/real-variables',\n    'Plumrocket_LayeredNavigationLite/js/model/data-layered',\n    'Plumrocket_LayeredNavigationLite/js/model/debug-logger',\n    'Plumrocket_LayeredNavigationLite/js/model/cache',\n    'Magento_Ui/js/modal/alert',\n    'domReady!'\n], function (_, $, loader, swatch, utils, realVariables, gtm, debugLogger, cache, alert) {\n    \"use strict\";\n\n    var skipHistory = false;\n\n    return {\n\n        currentRequest: null,\n\n        preloadRequest: null,\n\n        applyChangesInProcess: false,\n\n        /**\n         * @var {{auto: boolean, scrollUp: boolean, scrollUpTo: string}}\n         */\n        options : {},\n\n        /**\n         * @var {[{key: string, action: function, sortOrder: number}]}\n         */\n        afterFilterCallbacks: [],\n\n        /**\n         * Save configurations from init.js\n         *\n         * @param options\n         */\n        init: function (options) {\n            this.reset();\n            this.options = options;\n            loader.init(options.loader);\n\n            this.setAfterFilterCallback('replaceProductList', this.defaultCallbacks.replaceProductListCallback.bind(this), 10);\n            this.setAfterFilterCallback('replaceFilters', this.defaultCallbacks.replaceFiltersCallback.bind(this), 20);\n            this.setAfterFilterCallback('replaceH1', this.defaultCallbacks.replaceH1.bind(this), 25);\n            this.setAfterFilterCallback('updateGtmDataLayer', gtm.updateDataLayer.bind(gtm), 30);\n            this.setAfterFilterCallback('updateBrowserHistory', this.defaultCallbacks.updateBrowserHistoryCallback.bind(this), 40);\n            this.setAfterFilterCallback('scrollToTop', this.defaultCallbacks.scrollUp.bind(this), 50);\n            this.setAfterFilterCallback('knockout', this.defaultCallbacks.initKnockoutCallback.bind(this), 60);\n            this.setAfterFilterCallback('fixesCallback', this.defaultCallbacks.fixesCallback.bind(this), 70);\n            this.setAfterFilterCallback('catalogAddToCart', this.defaultCallbacks.initCatalogAddToCartCallback.bind(this), 80);\n            this.setAfterFilterCallback('initSwatches', swatch.afterFilterCallback.bind(swatch), 90);\n            this.setAfterFilterCallback('stopLoader', loader.stopLoader.bind(loader), 100);\n        },\n\n        /**\n         * Reset state.\n         *\n         * After filter done callback init.js afterFilterCallback will init this object again,\n         * so we need to reset to avoid bugs.\n         */\n        reset: function () {\n            this.options = {};\n            this.afterFilterCallbacks = [];\n        },\n\n        /**\n         * Send request with selected options.\n         *\n         * Will update product list and sidebar after.\n         */\n        applyChanges: function () {\n            var self = this;\n            var cacheKey = realVariables.getCacheKey();\n\n            if (this.currentRequest) { // Cancel existing request to start new one.\n                this.currentRequest.abort();\n            }\n\n            if (this.preloadRequest) {\n                loader.startLoader();\n                this.applyChangesInProcess = true;\n                return false;\n            }\n\n            if (cache.has(cacheKey)) {\n                loader.fixLoader();\n                self.done(cache.get(cacheKey));\n            } else {\n                loader.startLoader();\n                this.currentRequest = $.ajax({\n                    url: self.getRequestUrl(),\n                    data: self.getRequestData(),\n                    cache: true,\n                    success: function (response) {\n                        cache.save(cacheKey, response);\n                        self.done(response);\n                    },\n                    error: function (xhr, type, message) {\n                        if (type === 'abort') {\n                            return;\n                        }\n                        alert({\n                            title: message,\n                            content: $.mage.__('Sorry, something went wrong while filtering. Please try again later.'),\n                        });\n                    }\n                });\n            }\n        },\n\n        preloadChanges: function () {\n            var self = this;\n            var cacheKey = realVariables.getCacheKey();\n\n            if (this.preloadRequest) { // Cancel existing request to start new one.\n                this.preloadRequest.abort();\n                this.preloadRequest = null;\n            }\n\n            if (cache.has(cacheKey)) {\n                self.preloadChangesDone(cache.get(cacheKey));\n            } else {\n                document.getElementById('pr-filter-amount').classList.add('pr-filter-loader');\n                this.preloadRequest = $.ajax({\n                    url: self.getRequestUrl(),\n                    data: self.getRequestData(),\n                    cache: true,\n                    success: function (response) {\n                        cache.save(cacheKey, response);\n                        self.preloadChangesDone(response);\n                    },\n                    error: function (xhr, type, message) {\n                        if (type === 'abort') {\n                            return;\n                        }\n                        alert({\n                            title: message,\n                            content: $.mage.__('Sorry, something went wrong while filtering. Please try again later.'),\n                        });\n                    }\n                });\n            }\n        },\n\n        preloadChangesDone: function (data) {\n            if (! this.applyChangesInProcess) {\n                this.updateFilterCount(data);\n            } else {\n                this.done(data);\n            }\n        },\n\n        getRequestUrl: function () {\n            let url = this.options.cleanUrl;\n            if (realVariables.getCurrentPage() !== 1) {\n                url = utils.setParameter(url, 'p', realVariables.getCurrentPage());\n            } else {\n                url = utils.setParameter(url, 'p', '')\n            }\n\n            return url;\n        },\n\n        getRequestData: function () {\n            let data = this.toGetParamsArray(realVariables.getList());\n            data.push({name: 'prfilter_ajax', value: '1'});\n\n            return data;\n        },\n\n        updateFilterCount: function (data) {\n            this.preloadRequest = null;\n            document.getElementById('pr-filter-amount').innerHTML = data.productsCount;\n            document.getElementById('pr-filter-amount').classList.remove('pr-filter-loader');\n        },\n\n        toGetParamsArray: function (variables) {\n            return _.map(variables, function (values, variable) {\n                return {name: 'prfilter_variables[' + variable + ']', value: values.join(',')};\n            })\n        },\n\n        /**\n         * @param {string}   key\n         * @param {function} callback\n         * @param {number}   sortOrder\n         */\n        setAfterFilterCallback: function (key, callback, sortOrder) {\n            this.afterFilterCallbacks.push({key: key, action: callback, sortOrder: sortOrder});\n        },\n\n        /**\n         * Retrieve sorted callbacks.\n         *\n         * @return {[{key: string, action: function, sortOrder: number}]}\n         */\n        getSortedAfterFilterCallbacks: function () {\n            this.afterFilterCallbacks.sort(function (callback1, callback2) {\n                return callback1.sortOrder - callback2.sortOrder;\n            });\n            return this.afterFilterCallbacks;\n        },\n\n        /**\n         * @param {{productlist: string, leftnav: string, nextUrl: string}} data\n         */\n        done: function (data) {\n            this.currentRequest = null;\n            this.preloadRequest = null;\n            this.applyChangesInProcess = false;\n\n            debugLogger.log('response data', data);\n\n            this.getSortedAfterFilterCallbacks().forEach(function (callback) {\n                debugLogger.log('Run callback ' + callback.key);\n                callback.action(data);\n            });\n        },\n\n        applyUrl: function (url) {\n            if (cache.hasUrlCache(url)) {\n                realVariables.toState(cache.getKeyByUrl(url));\n                this.applyChanges();\n            } else {\n                window.location.reload();\n            }\n        },\n\n        setSkipHistory: function (flag) {\n            skipHistory = flag;\n        },\n\n        /**\n         * Replace toolbar, filters and product list.\n         *\n         * If any of them cannot be replaced (fail to find old position) this method returns false.\n         *\n         * @param html\n         * @param containerSelector\n         * @returns {boolean}\n         * @private\n         */\n        _replaceElements: function (html, containerSelector) {\n            var items = $(html.trim());\n\n            var container = document.querySelector(containerSelector);\n            var jsContainer = document.querySelector(this.options.productListSelector);\n            if (! jsContainer) {\n                jsContainer = document.querySelector('body');\n            }\n            var toolbar = 'top';\n\n            return _.every(items, function (item) {\n                if (! item.nodeName || item.nodeName === 'TEXT') {\n                    return true;\n                }\n\n                if (item.nodeName === 'SCRIPT') {\n                    jsContainer.append(item);\n                    return true;\n                }\n\n                var oldItem;\n                if (item.id) {\n                    oldItem = document.getElementById(item.id);\n                    if (! oldItem) {\n                        return false;\n                    }\n                    $(oldItem).replaceWith(item);\n                    return true;\n                }\n\n                if (item.className) {\n                    var selector = '';\n                    item.classList.forEach(function (className) {\n                        if (className.indexOf(':') !== -1 || className.indexOf('.') !== -1) {\n                            return true;\n                        }\n                        selector += '.' + className;\n                    });\n\n                    if (item.classList.contains('toolbar-products') && toolbar !== 'top') {\n                        oldItem = _.last(container.querySelectorAll(selector));\n                    } else {\n                        oldItem = container.querySelector(selector);\n                        toolbar = 'bottom';\n                    }\n                    if (! oldItem) {\n                        return false;\n                    }\n                    $(oldItem).replaceWith(item);\n                    return true;\n                }\n            }.bind(this));\n        },\n\n        /**\n         * List of callbacks for calling after finish request.\n         */\n        defaultCallbacks: {\n            scrollUp: function () {\n                if (this.options.scrollUp) {\n                    var toolbar = document.querySelector(this.options.scrollUpTo);\n                    if (toolbar && toolbar.scrollIntoView) {\n                        toolbar.scrollIntoView();\n                    }\n                }\n            },\n            replaceProductListCallback: function (data) {\n                if (! data.productlist) {\n                    return;\n                }\n\n                if (! this._replaceElements(data.productlist, this.options.productListSelector)) {\n                    $(this.options.productListSelector).html(data.productlist);\n                }\n            },\n\n            replaceFiltersCallback: function (data) {\n                if (! data.leftnav) {\n                    return;\n                }\n\n                if (! this._replaceElements(data.leftnav, this.options.filterSelector)) {\n                    if ($(this.options.filterSelector).length) {\n                        $(this.options.filterSelector).replaceWith(data.leftnav);\n                    } else {\n                        $(this.options.productListSelector).prepend(data.leftnav);\n                        $('.filter-options').hide(); /* fix */\n                    }\n                }\n            },\n\n            replaceH1: function (data) {\n                if (! data.h1) {\n                    return;\n                }\n\n                var title = document.getElementById('page-title-heading');\n                if (title) {\n                    title.innerHTML = data.h1;\n                }\n            },\n\n            /**\n             * Add history to browser address line\n             *\n             * @param data\n             */\n            updateBrowserHistoryCallback: function (data) {\n                if (skipHistory) {\n                    skipHistory = false;\n                    return;\n                }\n                try {\n                    let pageTitle = data.pageTitle ? data.pageTitle : '';\n                    window.history.pushState(data.nextUrl, pageTitle, data.nextUrl);\n                    if (pageTitle && pageTitle !== document.title) {\n                        document.title = pageTitle;\n                    }\n                } catch (e) {\n                    console.log(e);\n                }\n            },\n\n            fixesCallback: function () {\n                if (window.setGridItemsEqualHeight) {\n                    setGridItemsEqualHeight($);\n                }\n            },\n\n            initKnockoutCallback: function () {\n                $('body').trigger('contentUpdated');\n            },\n\n            initCatalogAddToCartCallback: function () {\n                setTimeout(function () {\n                    if ($.fn.catalogAddToCart) {\n                        $(\"form[data-role='tocart-form']\").each(function () {\n                            var form = jQuery(this);\n                            // Check if listener is already bound.\n                            if (!$._data(form[0], 'events') || !$._data(form[0], 'events')['submit']) {\n                                form.catalogAddToCart();\n                            }\n                        });\n                    }\n                }, 500);\n            },\n        },\n    };\n});\n","Plumrocket_LayeredNavigationLite/js/model/swatch.js":"/**\n * @package     Plumrocket_LayeredNavigationLite\n * @copyright   Copyright (c) 2016 Plumrocket Inc. (https://plumrocket.com)\n * @license     https://plumrocket.com/license   End-user License Agreement\n */\n\ndefine([\n    'underscore',\n    'jquery'\n], function (_, $) {\n    \"use strict\";\n\n    return {\n        options: {\n            swatchLinkClass: 'swatch-option-link-layered',\n            swatchAttributeContainer: 'swatch-attribute',\n            swatchOptionClass: 'swatch-option'\n        },\n\n        /**\n         * Check if item is a configurable swatch.\n         *\n         * @param {HTMLElement} item\n         * @return {Boolean}\n         */\n        isSwatch: function (item) {\n            return item.classList.contains(this.options.swatchLinkClass)\n                || item.classList.contains(this.options.swatchOptionClass);\n        },\n\n        /**\n         * @param {HTMLElement} item\n         * @return {{variable: null|string, value: null|string}}\n         */\n        getItemRequest: function (item) {\n            var request = {variable: null, value: null};\n            if (this.isSwatch(item)) {\n                var optionContainer = $(item).parents('.' + this.options.swatchAttributeContainer)[0];\n                if (optionContainer.dataset.attributeCode) {\n                    request.variable = optionContainer.dataset.attributeCode;\n                } else { // for magento 2.3 and older\n                    request.variable = optionContainer.getAttribute('attribute-code');\n                }\n\n                var swatchOption = this.getSwatchOption(item);\n                if (swatchOption.dataset.optionId) {\n                    request.value = swatchOption.dataset.optionId;\n                } else { // for magento 2.3 and older\n                    request.value = swatchOption.getAttribute('option-id');\n                }\n            }\n            return request;\n        },\n\n        getSwatchOption: function (item) {\n            return item.classList.contains(this.options.swatchOptionClass)\n                ? item\n                : item.querySelector('.' + this.options.swatchOptionClass);\n        },\n\n        /**\n         * @param {HTMLElement} item\n         * @return {boolean}\n         */\n        toggleSelected: function (item) {\n            var swatch = this.getSwatchOption(item);\n            swatch.classList.toggle('selected');\n            return swatch.classList.contains('selected');\n        },\n\n        /**\n         * This function is the analog of swatches function.\n         * Look to SwatchRender widget to method _EmulateSelected.\n         *\n         * @param params\n         * @param noForce\n         */\n        emulateSelected: function (params, noForce) {\n            var updateProductList = true;\n            var $productItemDetails = $('.product-item-details');\n\n            if (noForce && $productItemDetails.find('.swatch-attribute-options .swatch-option.selected').length > 0) {\n                updateProductList = false;\n            }\n\n            var attributeClass = $.mage.SwatchRenderer\n                ? $.mage.SwatchRenderer.prototype.options.classes.attributeClass\n                : 'swatch-attribute';\n\n            var $filterContainer = $('#narrow-by-list');\n\n            $filterContainer.find('.swatch-layered .swatch-option').removeClass('selected');\n            if (updateProductList) {\n                $productItemDetails.find('.swatch-attribute-options .swatch-option').removeClass('selected');\n            }\n\n            _.each(params, $.proxy(function (optionIds, attributeCode) {\n                _.each(optionIds, function (value) {\n                    if (updateProductList) {\n                        $productItemDetails.find('.' + attributeClass +\n                            '[attribute-code=\"' + attributeCode + '\"] [option-id=\"' + value + '\"]').trigger('click');\n                        $productItemDetails.find('.' + attributeClass +\n                            '[data-attribute-code=\"' + attributeCode + '\"] [data-option-id=\"' + value + '\"]').trigger('click');\n                    }\n\n                    /** First selector for magento 2.0-2.3, second for 2.4 */\n                    var selectors = '.swatch-layered[attribute-code=\"' + attributeCode + '\"] [option-id=\"' + value + '\"], '\n                        + '.swatch-layered[data-attribute-code=\"' + attributeCode + '\"] [data-option-id=\"' + value + '\"]'\n\n                    $filterContainer.find(selectors).addClass('selected');\n                    $filterContainer.find(selectors).parent().addClass('selected');\n                });\n            }, this));\n        },\n\n        /**\n         * Callback for after filter.\n         *\n         * @param {{}} data\n         */\n        afterFilterCallback: function (data) {\n            var self = this;\n            $('.swatch-option-tooltip').hide();\n            setTimeout(function () {\n                if (self && data.variables) {\n                    self.emulateSelected(data.variables, true);\n                }\n            }, 1000);\n        },\n    };\n});\n","Plumrocket_LayeredNavigationLite/js/model/full-screen-loader.js":"/**\n * @package     Plumrocket_LayeredNavigationLite\n * @copyright   Copyright (c) 2016 Plumrocket Inc. (https://plumrocket.com)\n * @license     https://plumrocket.com/license   End-user License Agreement\n */\n\ndefine([\n        'jquery',\n        'loader'\n    ], function ($) {\n        'use strict';\n\n        var loaderOptions = {\n            icon: '',\n            containerSelector: '.products.wrapper',\n        };\n\n        return {\n            init: function (options) {\n                loaderOptions = _.extend(loaderOptions, options);\n            },\n\n            /**\n             * Fix removing spinner of loader when loader had not showed before.\n             */\n            fixLoader: function () {\n                $(loaderOptions.containerSelector).loader({icon: loaderOptions.icon});\n                $(loaderOptions.containerSelector).loader('show');\n            },\n\n            startLoader: function () {\n                $(loaderOptions.containerSelector).loader({icon: loaderOptions.icon});\n                $(loaderOptions.containerSelector).loader('show');\n                this.setLoaderPosition();\n            },\n\n            stopLoader: function () {\n                $(loaderOptions.containerSelector).loader({icon: loaderOptions.icon});\n                $(loaderOptions.containerSelector).loader('hide');\n            },\n\n            calcLoaderPosition: function (el) {\n                let elH = el.offsetHeight,\n                    viewPortHeight = window.innerHeight,\n                    r = el.getBoundingClientRect(),\n                    topPosition = r.top,\n                    bottomPosition = r.bottom,\n                    visibleArea = function () {\n                        var position;\n                        if (topPosition > 0) {\n                            position = Math.max(0, Math.min(elH, viewPortHeight - topPosition) / 2);\n                            return position < 70 ? 70 : position;\n                        }\n\n                        if (Math.min(bottomPosition, viewPortHeight) === viewPortHeight\n                            || (viewPortHeight >= bottomPosition && bottomPosition > 0)\n                        ) {\n                            position = Math.max(0, (Math.abs(topPosition * 2) + Math.min(bottomPosition, viewPortHeight)) / 2);\n                            return bottomPosition < 70 ? position - 70 : position;\n                        }\n\n                        return 0;\n                    }\n\n                return visibleArea();\n            },\n\n            setLoaderPosition: function () {\n                var container = document.querySelector(loaderOptions.containerSelector),\n                    setParams = function (el) {\n                        if (el) {\n                            el.style.setProperty('--loader-position', this.calcLoaderPosition(el) + 'px');\n                            el.style.position = 'relative';\n                            el.classList.add('pr-loader__wrapper')\n                        }\n                    }.bind(this);\n\n                window.addEventListener('scroll', function () {\n                    setParams(container);\n                });\n                setParams(container);\n            }\n        };\n    }\n);\n","Plumrocket_LayeredNavigationLite/js/view/apply-button.js":"/**\n * @package     Plumrocket_LayeredNavigationLite\n * @copyright   Copyright (c) 2022 Plumrocket Inc. (https://plumrocket.com)\n * @license     https://plumrocket.com/license   End-user License Agreement\n */\n\ndefine([], function () {\n    'use strict';\n\n    return {\n        filterButton: document.getElementById('manual-filter'),\n        filterButtonListener: false,\n        buttonTopClass: 'pr-filter-fixed-top',\n        buttonBottomClass: 'pr-filter-fixed-bottom',\n        initParams: {},\n\n        showFilterButton: function (filterItem, filterSelector) {\n            if (!this.filterButtonListener) {\n                this.addFilterButtonListener(this.initParams);\n            }\n\n            //delete init params\n            for (const prop of Object.getOwnPropertyNames(this.initParams)) {\n                delete this.initParams[prop];\n            }\n\n            this._clearClasses(this.filterButton);\n\n            this._updateNode();\n\n            this._setButtonPosition(filterItem, this.filterButton, filterSelector)\n        },\n\n        addFilterButtonListener: function (initParams) {\n            var self = this;\n\n            this._handleScroll = function (e) {\n                let filterButtonRect = self.filterButton.getBoundingClientRect();\n                let scrollPosition = window.scrollY;\n\n                //set scroll position to initParams\n                if (filterButtonRect.top < 20) {\n                    if (!initParams.hasOwnProperty('top')) {\n                        initParams.top = window.scrollY;\n                    }\n\n                    if (!initParams.hasOwnProperty('currentClass') || initParams.currentClass !== self.buttonTopClass) {\n                        initParams.currentClass = self.buttonTopClass;\n                    }\n\n                } else if (window.innerHeight - filterButtonRect.bottom < 20) {\n                    if (!initParams.hasOwnProperty('bottom')) {\n                        initParams.bottom = window.scrollY;\n                    }\n\n                    if (!initParams.hasOwnProperty('currentClass') || initParams.currentClass !== self.buttonBottomClass) {\n                        initParams.currentClass = self.buttonBottomClass;\n                    }\n                }\n\n                //Switch css classes\n                if (scrollPosition >= initParams.top || scrollPosition <= initParams.bottom) {\n                    self.filterButton.classList.add(initParams.currentClass);\n                } else {\n                    self._clearClasses();\n                }\n            };\n\n            document.removeEventListener('scroll', this._handleScroll);\n            document.addEventListener('scroll', this._handleScroll);\n            this.filterButtonListener = true;\n        },\n\n        _setButtonPosition: function (filterItem, button, filterSelector) {\n            const bodyElement = document.querySelector(filterSelector),\n                sidebar = document.querySelector('.sidebar'),\n                bodyRect = bodyElement.getBoundingClientRect();\n\n            if (filterItem.closest('.sidebar')) {\n                const itemRect = filterItem.getBoundingClientRect(),\n                    offset = Math.round(itemRect.top + (itemRect.height / 2) - bodyRect.top);\n\n                button.style.setProperty('--pr-top-position', offset + 'px');\n                button.style.setProperty('--pr-sidebar-width', Math.round(bodyRect.width) + 'px');\n\n            } else {\n                const rectItemSection = filterItem.closest('.filter-options-item');\n                bodyElement.classList.add('pr-toolbar-wrapper');\n                button.style.setProperty('--pr-left-position', rectItemSection.offsetLeft + rectItemSection.clientWidth / 2 + 'px');\n\n                if (sidebar) {\n                    button.style.setProperty('--pr-sidebar-left', sidebar.getBoundingClientRect().left + 'px');\n                    button.style.setProperty('--pr-sidebar-width', sidebar.clientWidth + 'px');\n                }\n            }\n        },\n\n        _clearClasses: function () {\n            this.filterButton.classList.remove(this.buttonTopClass, this.buttonBottomClass);\n        },\n\n        _updateNode: function () {\n            this.filterButton = document.getElementById('manual-filter');\n            this.filterButton.removeAttribute(\"style\");\n            this.filterButton.style.setProperty('--pr-button-height', this.filterButton.offsetHeight + 'px');\n        },\n    };\n});\n","Plumrocket_LayeredNavigationLite/js/view/price/slider.js":"/**\n * @package     Plumrocket_LayeredNavigationLite\n * @copyright   Copyright (c) 2022 Plumrocket Inc. (https://plumrocket.com)\n * @license     https://plumrocket.com/license   End-user License Agreement\n */\n\ndefine([\n    'jquery',\n    'Plumrocket_LayeredNavigationLite/js/model/price',\n    'plumrocket/noUiSlider',\n    'domReady!'\n], function ($, price, noUiSlider) {\n    \"use strict\";\n\n    $.widget('plumrocket.priceslider', {\n\n        initedElement: $('#product-filter-init'),\n\n        currentRanges : [],\n\n        _create: function () {\n            var self = this,\n                emptyPriceRequest = Object.keys(self.options.request).length === 0;\n\n            if (!this.initedElement.data('max-price') || emptyPriceRequest) {\n                this.initedElement.data('max-price', self.options.max);\n                this.initedElement.data('min-price', self.options.min);\n            }\n\n            var values = [];\n            if (this.options.request.min) {\n                self.currentRanges[0] = Math.floor(this.options.request.min);\n                values.push(this.options.request.min);\n            } else {\n                self.currentRanges[0] = self.options.min;\n                values.push(self.options.min);\n            }\n\n            if (this.options.request.max) {\n                self.currentRanges[1] = Math.ceil(this.options.request.max);\n                values.push(this.options.request.max);\n            } else {\n                self.currentRanges[1] = self.options.max;\n                values.push(self.options.max);\n            }\n\n            try {\n                var slider = this.element[0];\n                noUiSlider.create(slider, {\n                    start: values,\n                    connect: true,\n                    step: 0.01,\n                    range: {\n                        'min': this.initedElement.data('min-price'),\n                        'max': this.initedElement.data('max-price')\n                    },\n                    format: {\n                        // 'to' the formatted value. Receives a number.\n                        to: function (value) {\n                            return value.toFixed(2);\n                        },\n                        // 'from' the formatted value.\n                        // Receives a string, should return a number.\n                        from: function (value) {\n                            return Number(value).toFixed(2);\n                        }\n                    }\n                });\n\n                slider.noUiSlider.on('update', function (values, handle) {\n                    self.currentRanges = values;\n                    self.changeInputValue(self.currentRanges[0], self.currentRanges[1]);\n                });\n\n                slider.noUiSlider.on('set', function () {\n                    price.change(\n                        self.currentRanges[0]/self.options.rate,\n                        self.currentRanges[1]/self.options.rate,\n                        true,\n                        this.target\n                    );\n                });\n            } catch (err) {\n            }\n        },\n\n        changeRangeHtml: function (from, to) {\n            $(this.options.amountFrom).html(from);\n            $(this.options.amountTo).html(to);\n        },\n\n        changeInputValue: function (from, to) {\n            this.changeRangeHtml(from, to);\n            if ($('div[data-filter-type=\"input\"]').length) {\n                var inputFrom = document.querySelector(this.options.inputFrom);\n                var inputTo = document.querySelector(this.options.inputTo);\n\n                if (inputFrom && inputFrom.value !== from) {\n                    inputFrom.value = from;\n                }\n                if (inputTo && inputTo.value !== to) {\n                    inputTo.value = to;\n                }\n            }\n        }\n    });\n\n    return $.plumrocket.priceslider;\n});","Plumrocket_LayeredNavigationLite/js/lib/nouislider.min.js":"!function(t,e){\"object\"==typeof exports&&\"undefined\"!=typeof module?e(exports):\"function\"==typeof define&&define.amd?define([\"exports\"],e):e((t=\"undefined\"!=typeof globalThis?globalThis:t||self).noUiSlider={})}(this,function(ot){\"use strict\";function n(t){return\"object\"==typeof t&&\"function\"==typeof t.to}function st(t){t.parentElement.removeChild(t)}function at(t){return null!=t}function lt(t){t.preventDefault()}function i(t){return\"number\"==typeof t&&!isNaN(t)&&isFinite(t)}function ut(t,e,r){0<r&&(ft(t,e),setTimeout(function(){dt(t,e)},r))}function ct(t){return Math.max(Math.min(t,100),0)}function pt(t){return Array.isArray(t)?t:[t]}function e(t){t=(t=String(t)).split(\".\");return 1<t.length?t[1].length:0}function ft(t,e){t.classList&&!/\\s/.test(e)?t.classList.add(e):t.className+=\" \"+e}function dt(t,e){t.classList&&!/\\s/.test(e)?t.classList.remove(e):t.className=t.className.replace(new RegExp(\"(^|\\\\b)\"+e.split(\" \").join(\"|\")+\"(\\\\b|$)\",\"gi\"),\" \")}function ht(t){var e=void 0!==window.pageXOffset,r=\"CSS1Compat\"===(t.compatMode||\"\");return{x:e?window.pageXOffset:(r?t.documentElement:t.body).scrollLeft,y:e?window.pageYOffset:(r?t.documentElement:t.body).scrollTop}}function s(t,e){return 100/(e-t)}function a(t,e,r){return 100*e/(t[r+1]-t[r])}function l(t,e){for(var r=1;t>=e[r];)r+=1;return r}function r(t,e,r){if(r>=t.slice(-1)[0])return 100;var n=l(r,t),i=t[n-1],o=t[n],t=e[n-1],n=e[n];return t+(r=r,a(o=[i,o],o[0]<0?r+Math.abs(o[0]):r-o[0],0)/s(t,n))}function o(t,e,r,n){if(100===n)return n;var i=l(n,t),o=t[i-1],s=t[i];return r?(s-o)/2<n-o?s:o:e[i-1]?t[i-1]+(t=n-t[i-1],i=e[i-1],Math.round(t/i)*i):n}ot.PipsMode=void 0,(H=ot.PipsMode||(ot.PipsMode={})).Range=\"range\",H.Steps=\"steps\",H.Positions=\"positions\",H.Count=\"count\",H.Values=\"values\",ot.PipsType=void 0,(H=ot.PipsType||(ot.PipsType={}))[H.None=-1]=\"None\",H[H.NoValue=0]=\"NoValue\",H[H.LargeValue=1]=\"LargeValue\",H[H.SmallValue=2]=\"SmallValue\";var u=(t.prototype.getDistance=function(t){for(var e=[],r=0;r<this.xNumSteps.length-1;r++)e[r]=a(this.xVal,t,r);return e},t.prototype.getAbsoluteDistance=function(t,e,r){var n=0;if(t<this.xPct[this.xPct.length-1])for(;t>this.xPct[n+1];)n++;else t===this.xPct[this.xPct.length-1]&&(n=this.xPct.length-2);r||t!==this.xPct[n+1]||n++;for(var i,o=1,s=(e=null===e?[]:e)[n],a=0,l=0,u=0,c=r?(t-this.xPct[n])/(this.xPct[n+1]-this.xPct[n]):(this.xPct[n+1]-t)/(this.xPct[n+1]-this.xPct[n]);0<s;)i=this.xPct[n+1+u]-this.xPct[n+u],100<e[n+u]*o+100-100*c?(a=i*c,o=(s-100*c)/e[n+u],c=1):(a=e[n+u]*i/100*o,o=0),r?(l-=a,1<=this.xPct.length+u&&u--):(l+=a,1<=this.xPct.length-u&&u++),s=e[n+u]*o;return t+l},t.prototype.toStepping=function(t){return t=r(this.xVal,this.xPct,t)},t.prototype.fromStepping=function(t){return function(t,e,r){if(100<=r)return t.slice(-1)[0];var n=l(r,e),i=t[n-1],o=t[n],t=e[n-1],n=e[n];return(r-t)*s(t,n)*((o=[i,o])[1]-o[0])/100+o[0]}(this.xVal,this.xPct,t)},t.prototype.getStep=function(t){return t=o(this.xPct,this.xSteps,this.snap,t)},t.prototype.getDefaultStep=function(t,e,r){var n=l(t,this.xPct);return(100===t||e&&t===this.xPct[n-1])&&(n=Math.max(n-1,1)),(this.xVal[n]-this.xVal[n-1])/r},t.prototype.getNearbySteps=function(t){t=l(t,this.xPct);return{stepBefore:{startValue:this.xVal[t-2],step:this.xNumSteps[t-2],highestStep:this.xHighestCompleteStep[t-2]},thisStep:{startValue:this.xVal[t-1],step:this.xNumSteps[t-1],highestStep:this.xHighestCompleteStep[t-1]},stepAfter:{startValue:this.xVal[t],step:this.xNumSteps[t],highestStep:this.xHighestCompleteStep[t]}}},t.prototype.countStepDecimals=function(){var t=this.xNumSteps.map(e);return Math.max.apply(null,t)},t.prototype.hasNoSize=function(){return this.xVal[0]===this.xVal[this.xVal.length-1]},t.prototype.convert=function(t){return this.getStep(this.toStepping(t))},t.prototype.handleEntryPoint=function(t,e){t=\"min\"===t?0:\"max\"===t?100:parseFloat(t);if(!i(t)||!i(e[0]))throw new Error(\"noUiSlider: 'range' value isn't numeric.\");this.xPct.push(t),this.xVal.push(e[0]);e=Number(e[1]);t?this.xSteps.push(!isNaN(e)&&e):isNaN(e)||(this.xSteps[0]=e),this.xHighestCompleteStep.push(0)},t.prototype.handleStepPoint=function(t,e){e&&(this.xVal[t]!==this.xVal[t+1]?(this.xSteps[t]=a([this.xVal[t],this.xVal[t+1]],e,0)/s(this.xPct[t],this.xPct[t+1]),e=(this.xVal[t+1]-this.xVal[t])/this.xNumSteps[t],e=Math.ceil(Number(e.toFixed(3))-1),e=this.xVal[t]+this.xNumSteps[t]*e,this.xHighestCompleteStep[t]=e):this.xSteps[t]=this.xHighestCompleteStep[t]=this.xVal[t])},t);function t(e,t,r){var n;this.xPct=[],this.xVal=[],this.xSteps=[],this.xNumSteps=[],this.xHighestCompleteStep=[],this.xSteps=[r||!1],this.xNumSteps=[!1],this.snap=t;var i=[];for(Object.keys(e).forEach(function(t){i.push([pt(e[t]),t])}),i.sort(function(t,e){return t[0][0]-e[0][0]}),n=0;n<i.length;n++)this.handleEntryPoint(i[n][1],i[n][0]);for(this.xNumSteps=this.xSteps.slice(0),n=0;n<this.xNumSteps.length;n++)this.handleStepPoint(n,this.xNumSteps[n])}var c={to:function(t){return void 0===t?\"\":t.toFixed(2)},from:Number},p={target:\"target\",base:\"base\",origin:\"origin\",handle:\"handle\",handleLower:\"handle-lower\",handleUpper:\"handle-upper\",touchArea:\"touch-area\",horizontal:\"horizontal\",vertical:\"vertical\",background:\"background\",connect:\"connect\",connects:\"connects\",ltr:\"ltr\",rtl:\"rtl\",textDirectionLtr:\"txt-dir-ltr\",textDirectionRtl:\"txt-dir-rtl\",draggable:\"draggable\",drag:\"state-drag\",tap:\"state-tap\",active:\"active\",tooltip:\"tooltip\",pips:\"pips\",pipsHorizontal:\"pips-horizontal\",pipsVertical:\"pips-vertical\",marker:\"marker\",markerHorizontal:\"marker-horizontal\",markerVertical:\"marker-vertical\",markerNormal:\"marker-normal\",markerLarge:\"marker-large\",markerSub:\"marker-sub\",value:\"value\",valueHorizontal:\"value-horizontal\",valueVertical:\"value-vertical\",valueNormal:\"value-normal\",valueLarge:\"value-large\",valueSub:\"value-sub\"},mt={tooltips:\".__tooltips\",aria:\".__aria\"};function f(t,e){if(!i(e))throw new Error(\"noUiSlider: 'step' is not numeric.\");t.singleStep=e}function d(t,e){if(!i(e))throw new Error(\"noUiSlider: 'keyboardPageMultiplier' is not numeric.\");t.keyboardPageMultiplier=e}function h(t,e){if(!i(e))throw new Error(\"noUiSlider: 'keyboardMultiplier' is not numeric.\");t.keyboardMultiplier=e}function m(t,e){if(!i(e))throw new Error(\"noUiSlider: 'keyboardDefaultStep' is not numeric.\");t.keyboardDefaultStep=e}function g(t,e){if(\"object\"!=typeof e||Array.isArray(e))throw new Error(\"noUiSlider: 'range' is not an object.\");if(void 0===e.min||void 0===e.max)throw new Error(\"noUiSlider: Missing 'min' or 'max' in 'range'.\");t.spectrum=new u(e,t.snap||!1,t.singleStep)}function v(t,e){if(e=pt(e),!Array.isArray(e)||!e.length)throw new Error(\"noUiSlider: 'start' option is incorrect.\");t.handles=e.length,t.start=e}function b(t,e){if(\"boolean\"!=typeof e)throw new Error(\"noUiSlider: 'snap' option must be a boolean.\");t.snap=e}function S(t,e){if(\"boolean\"!=typeof e)throw new Error(\"noUiSlider: 'animate' option must be a boolean.\");t.animate=e}function x(t,e){if(\"number\"!=typeof e)throw new Error(\"noUiSlider: 'animationDuration' option must be a number.\");t.animationDuration=e}function y(t,e){var r,n=[!1];if(\"lower\"===e?e=[!0,!1]:\"upper\"===e&&(e=[!1,!0]),!0===e||!1===e){for(r=1;r<t.handles;r++)n.push(e);n.push(!1)}else{if(!Array.isArray(e)||!e.length||e.length!==t.handles+1)throw new Error(\"noUiSlider: 'connect' option doesn't match handle count.\");n=e}t.connect=n}function w(t,e){switch(e){case\"horizontal\":t.ort=0;break;case\"vertical\":t.ort=1;break;default:throw new Error(\"noUiSlider: 'orientation' option is invalid.\")}}function E(t,e){if(!i(e))throw new Error(\"noUiSlider: 'margin' option must be numeric.\");0!==e&&(t.margin=t.spectrum.getDistance(e))}function P(t,e){if(!i(e))throw new Error(\"noUiSlider: 'limit' option must be numeric.\");if(t.limit=t.spectrum.getDistance(e),!t.limit||t.handles<2)throw new Error(\"noUiSlider: 'limit' option is only supported on linear sliders with 2 or more handles.\")}function C(t,e){var r;if(!i(e)&&!Array.isArray(e))throw new Error(\"noUiSlider: 'padding' option must be numeric or array of exactly 2 numbers.\");if(Array.isArray(e)&&2!==e.length&&!i(e[0])&&!i(e[1]))throw new Error(\"noUiSlider: 'padding' option must be numeric or array of exactly 2 numbers.\");if(0!==e){for(Array.isArray(e)||(e=[e,e]),t.padding=[t.spectrum.getDistance(e[0]),t.spectrum.getDistance(e[1])],r=0;r<t.spectrum.xNumSteps.length-1;r++)if(t.padding[0][r]<0||t.padding[1][r]<0)throw new Error(\"noUiSlider: 'padding' option must be a positive number(s).\");var n=e[0]+e[1],e=t.spectrum.xVal[0];if(1<n/(t.spectrum.xVal[t.spectrum.xVal.length-1]-e))throw new Error(\"noUiSlider: 'padding' option must not exceed 100% of the range.\")}}function N(t,e){switch(e){case\"ltr\":t.dir=0;break;case\"rtl\":t.dir=1;break;default:throw new Error(\"noUiSlider: 'direction' option was not recognized.\")}}function V(t,e){if(\"string\"!=typeof e)throw new Error(\"noUiSlider: 'behaviour' must be a string containing options.\");var r=0<=e.indexOf(\"tap\"),n=0<=e.indexOf(\"drag\"),i=0<=e.indexOf(\"fixed\"),o=0<=e.indexOf(\"snap\"),s=0<=e.indexOf(\"hover\"),a=0<=e.indexOf(\"unconstrained\"),e=0<=e.indexOf(\"drag-all\");if(i){if(2!==t.handles)throw new Error(\"noUiSlider: 'fixed' behaviour must be used with 2 handles\");E(t,t.start[1]-t.start[0])}if(a&&(t.margin||t.limit))throw new Error(\"noUiSlider: 'unconstrained' behaviour cannot be used with margin or limit\");t.events={tap:r||o,drag:n,dragAll:e,fixed:i,snap:o,hover:s,unconstrained:a}}function k(t,e){if(!1!==e)if(!0===e||n(e)){t.tooltips=[];for(var r=0;r<t.handles;r++)t.tooltips.push(e)}else{if((e=pt(e)).length!==t.handles)throw new Error(\"noUiSlider: must pass a formatter for all handles.\");e.forEach(function(t){if(\"boolean\"!=typeof t&&!n(t))throw new Error(\"noUiSlider: 'tooltips' must be passed a formatter or 'false'.\")}),t.tooltips=e}}function M(t,e){if(e.length!==t.handles)throw new Error(\"noUiSlider: must pass a attributes for all handles.\");t.handleAttributes=e}function A(t,e){if(!n(e))throw new Error(\"noUiSlider: 'ariaFormat' requires 'to' method.\");t.ariaFormat=e}function U(t,e){if(!n(r=e)||\"function\"!=typeof r.from)throw new Error(\"noUiSlider: 'format' requires 'to' and 'from' methods.\");var r;t.format=e}function D(t,e){if(\"boolean\"!=typeof e)throw new Error(\"noUiSlider: 'keyboardSupport' option must be a boolean.\");t.keyboardSupport=e}function O(t,e){t.documentElement=e}function L(t,e){if(\"string\"!=typeof e&&!1!==e)throw new Error(\"noUiSlider: 'cssPrefix' must be a string or `false`.\");t.cssPrefix=e}function T(e,r){if(\"object\"!=typeof r)throw new Error(\"noUiSlider: 'cssClasses' must be an object.\");\"string\"==typeof e.cssPrefix?(e.cssClasses={},Object.keys(r).forEach(function(t){e.cssClasses[t]=e.cssPrefix+r[t]})):e.cssClasses=r}function gt(e){var r={margin:null,limit:null,padding:null,animate:!0,animationDuration:300,ariaFormat:c,format:c},n={step:{r:!1,t:f},keyboardPageMultiplier:{r:!1,t:d},keyboardMultiplier:{r:!1,t:h},keyboardDefaultStep:{r:!1,t:m},start:{r:!0,t:v},connect:{r:!0,t:y},direction:{r:!0,t:N},snap:{r:!1,t:b},animate:{r:!1,t:S},animationDuration:{r:!1,t:x},range:{r:!0,t:g},orientation:{r:!1,t:w},margin:{r:!1,t:E},limit:{r:!1,t:P},padding:{r:!1,t:C},behaviour:{r:!0,t:V},ariaFormat:{r:!1,t:A},format:{r:!1,t:U},tooltips:{r:!1,t:k},keyboardSupport:{r:!0,t:D},documentElement:{r:!1,t:O},cssPrefix:{r:!0,t:L},cssClasses:{r:!0,t:T},handleAttributes:{r:!1,t:M}},i={connect:!1,direction:\"ltr\",behaviour:\"tap\",orientation:\"horizontal\",keyboardSupport:!0,cssPrefix:\"noUi-\",cssClasses:p,keyboardPageMultiplier:5,keyboardMultiplier:1,keyboardDefaultStep:10};e.format&&!e.ariaFormat&&(e.ariaFormat=e.format),Object.keys(n).forEach(function(t){if(at(e[t])||void 0!==i[t])n[t].t(r,(at(e[t])?e:i)[t]);else if(n[t].r)throw new Error(\"noUiSlider: '\"+t+\"' is required.\")}),r.pips=e.pips;var t=document.createElement(\"div\"),o=void 0!==t.style.msTransform,t=void 0!==t.style.transform;r.transformRule=t?\"transform\":o?\"msTransform\":\"webkitTransform\";return r.style=[[\"left\",\"top\"],[\"right\",\"bottom\"]][r.dir][r.ort],r}function j(t,f,o){var i,a,l,n,s,u,c=window.navigator.pointerEnabled?{start:\"pointerdown\",move:\"pointermove\",end:\"pointerup\"}:window.navigator.msPointerEnabled?{start:\"MSPointerDown\",move:\"MSPointerMove\",end:\"MSPointerUp\"}:{start:\"mousedown touchstart\",move:\"mousemove touchmove\",end:\"mouseup touchend\"},p=window.CSS&&CSS.supports&&CSS.supports(\"touch-action\",\"none\")&&function(){var t=!1;try{var e=Object.defineProperty({},\"passive\",{get:function(){t=!0}});window.addEventListener(\"test\",null,e)}catch(t){}return t}(),d=t,S=f.spectrum,h=[],m=[],g=[],v=0,b={},x=t.ownerDocument,y=f.documentElement||x.documentElement,w=x.body,E=\"rtl\"===x.dir||1===f.ort?0:100;function P(t,e){var r=x.createElement(\"div\");return e&&ft(r,e),t.appendChild(r),r}function C(t,e){var r,t=P(t,f.cssClasses.origin),n=P(t,f.cssClasses.handle);return P(n,f.cssClasses.touchArea),n.setAttribute(\"data-handle\",String(e)),f.keyboardSupport&&(n.setAttribute(\"tabindex\",\"0\"),n.addEventListener(\"keydown\",function(t){return function(t,e){if(V()||k(e))return!1;var r=[\"Left\",\"Right\"],n=[\"Down\",\"Up\"],i=[\"PageDown\",\"PageUp\"],o=[\"Home\",\"End\"];f.dir&&!f.ort?r.reverse():f.ort&&!f.dir&&(n.reverse(),i.reverse());var s=t.key.replace(\"Arrow\",\"\"),a=s===i[0],l=s===i[1],i=s===n[0]||s===r[0]||a,n=s===n[1]||s===r[1]||l,r=s===o[0],o=s===o[1];if(!(i||n||r||o))return!0;if(t.preventDefault(),n||i){var u=i?0:1,u=nt(e)[u];if(null===u)return!1;!1===u&&(u=S.getDefaultStep(m[e],i,f.keyboardDefaultStep)),u*=l||a?f.keyboardPageMultiplier:f.keyboardMultiplier,u=Math.max(u,1e-7),u*=i?-1:1,u=h[e]+u}else u=o?f.spectrum.xVal[f.spectrum.xVal.length-1]:f.spectrum.xVal[0];return Q(e,S.toStepping(u),!0,!0),I(\"slide\",e),I(\"update\",e),I(\"change\",e),I(\"set\",e),!1}(t,e)})),void 0!==f.handleAttributes&&(r=f.handleAttributes[e],Object.keys(r).forEach(function(t){n.setAttribute(t,r[t])})),n.setAttribute(\"role\",\"slider\"),n.setAttribute(\"aria-orientation\",f.ort?\"vertical\":\"horizontal\"),0===e?ft(n,f.cssClasses.handleLower):e===f.handles-1&&ft(n,f.cssClasses.handleUpper),t}function N(t,e){return!!e&&P(t,f.cssClasses.connect)}function e(t,e){return!(!f.tooltips||!f.tooltips[e])&&P(t.firstChild,f.cssClasses.tooltip)}function V(){return d.hasAttribute(\"disabled\")}function k(t){return a[t].hasAttribute(\"disabled\")}function M(){s&&(Y(\"update\"+mt.tooltips),s.forEach(function(t){t&&st(t)}),s=null)}function A(){M(),s=a.map(e),X(\"update\"+mt.tooltips,function(t,e,r){s&&f.tooltips&&!1!==s[e]&&(t=t[e],!0!==f.tooltips[e]&&(t=f.tooltips[e].to(r[e])),s[e].innerHTML=t)})}function U(t,e){return t.map(function(t){return S.fromStepping(e?S.getStep(t):t)})}function D(d){var h=function(t){if(t.mode===ot.PipsMode.Range||t.mode===ot.PipsMode.Steps)return S.xVal;if(t.mode!==ot.PipsMode.Count)return t.mode===ot.PipsMode.Positions?U(t.values,t.stepped):t.mode===ot.PipsMode.Values?t.stepped?t.values.map(function(t){return S.fromStepping(S.getStep(S.toStepping(t)))}):t.values:[];if(t.values<2)throw new Error(\"noUiSlider: 'values' (>= 2) required for mode 'count'.\");for(var e=t.values-1,r=100/e,n=[];e--;)n[e]=e*r;return n.push(100),U(n,t.stepped)}(d),m={},t=S.xVal[0],e=S.xVal[S.xVal.length-1],g=!1,v=!1,b=0;return(h=h.slice().sort(function(t,e){return t-e}).filter(function(t){return!this[t]&&(this[t]=!0)},{}))[0]!==t&&(h.unshift(t),g=!0),h[h.length-1]!==e&&(h.push(e),v=!0),h.forEach(function(t,e){var r,n,i,o,s,a,l,u,t=t,c=h[e+1],p=d.mode===ot.PipsMode.Steps,f=(f=p?S.xNumSteps[e]:f)||c-t;for(void 0===c&&(c=t),f=Math.max(f,1e-7),r=t;r<=c;r=Number((r+f).toFixed(7))){for(a=(o=(i=S.toStepping(r))-b)/(d.density||1),u=o/(l=Math.round(a)),n=1;n<=l;n+=1)m[(s=b+n*u).toFixed(5)]=[S.fromStepping(s),0];a=-1<h.indexOf(r)?ot.PipsType.LargeValue:p?ot.PipsType.SmallValue:ot.PipsType.NoValue,!e&&g&&r!==c&&(a=0),r===c&&v||(m[i.toFixed(5)]=[r,a]),b=i}}),m}function O(i,o,s){var t,a=x.createElement(\"div\"),n=((t={})[ot.PipsType.None]=\"\",t[ot.PipsType.NoValue]=f.cssClasses.valueNormal,t[ot.PipsType.LargeValue]=f.cssClasses.valueLarge,t[ot.PipsType.SmallValue]=f.cssClasses.valueSub,t),l=((t={})[ot.PipsType.None]=\"\",t[ot.PipsType.NoValue]=f.cssClasses.markerNormal,t[ot.PipsType.LargeValue]=f.cssClasses.markerLarge,t[ot.PipsType.SmallValue]=f.cssClasses.markerSub,t),u=[f.cssClasses.valueHorizontal,f.cssClasses.valueVertical],c=[f.cssClasses.markerHorizontal,f.cssClasses.markerVertical];function p(t,e){var r=e===f.cssClasses.value;return e+\" \"+(r?u:c)[f.ort]+\" \"+(r?n:l)[t]}return ft(a,f.cssClasses.pips),ft(a,0===f.ort?f.cssClasses.pipsHorizontal:f.cssClasses.pipsVertical),Object.keys(i).forEach(function(t){var e,r,n;r=i[e=t][0],n=i[t][1],(n=o?o(r,n):n)!==ot.PipsType.None&&((t=P(a,!1)).className=p(n,f.cssClasses.marker),t.style[f.style]=e+\"%\",n>ot.PipsType.NoValue&&((t=P(a,!1)).className=p(n,f.cssClasses.value),t.setAttribute(\"data-value\",String(r)),t.style[f.style]=e+\"%\",t.innerHTML=String(s.to(r))))}),a}function L(){n&&(st(n),n=null)}function T(t){L();var e=D(t),r=t.filter,t=t.format||{to:function(t){return String(Math.round(t))}};return n=d.appendChild(O(e,r,t))}function j(){var t=i.getBoundingClientRect(),e=\"offset\"+[\"Width\",\"Height\"][f.ort];return 0===f.ort?t.width||i[e]:t.height||i[e]}function z(n,i,o,s){function e(t){var e,r=function(e,t,r){var n=0===e.type.indexOf(\"touch\"),i=0===e.type.indexOf(\"mouse\"),o=0===e.type.indexOf(\"pointer\"),s=0,a=0;0===e.type.indexOf(\"MSPointer\")&&(o=!0);if(\"mousedown\"===e.type&&!e.buttons&&!e.touches)return!1;if(n){var l=function(t){t=t.target;return t===r||r.contains(t)||e.composed&&e.composedPath().shift()===r};if(\"touchstart\"===e.type){n=Array.prototype.filter.call(e.touches,l);if(1<n.length)return!1;s=n[0].pageX,a=n[0].pageY}else{l=Array.prototype.find.call(e.changedTouches,l);if(!l)return!1;s=l.pageX,a=l.pageY}}t=t||ht(x),(i||o)&&(s=e.clientX+t.x,a=e.clientY+t.y);return e.pageOffset=t,e.points=[s,a],e.cursor=i||o,e}(t,s.pageOffset,s.target||i);return!!r&&(!(V()&&!s.doNotReject)&&(e=d,t=f.cssClasses.tap,!((e.classList?e.classList.contains(t):new RegExp(\"\\\\b\"+t+\"\\\\b\").test(e.className))&&!s.doNotReject)&&(!(n===c.start&&void 0!==r.buttons&&1<r.buttons)&&((!s.hover||!r.buttons)&&(p||r.preventDefault(),r.calcPoint=r.points[f.ort],void o(r,s))))))}var r=[];return n.split(\" \").forEach(function(t){i.addEventListener(t,e,!!p&&{passive:!0}),r.push([t,e])}),r}function H(t){var e,r,n=ct(n=100*(t-(n=i,e=f.ort,r=n.getBoundingClientRect(),n=(t=n.ownerDocument).documentElement,t=ht(t),/webkit.*Chrome.*Mobile/i.test(navigator.userAgent)&&(t.x=0),e?r.top+t.y-n.clientTop:r.left+t.x-n.clientLeft))/j());return f.dir?100-n:n}function F(t,e){\"mouseout\"===t.type&&\"HTML\"===t.target.nodeName&&null===t.relatedTarget&&_(t,e)}function R(t,e){if(-1===navigator.appVersion.indexOf(\"MSIE 9\")&&0===t.buttons&&0!==e.buttonsProperty)return _(t,e);t=(f.dir?-1:1)*(t.calcPoint-e.startCalcPoint);G(0<t,100*t/e.baseSize,e.locations,e.handleNumbers,e.connect)}function _(t,e){e.handle&&(dt(e.handle,f.cssClasses.active),--v),e.listeners.forEach(function(t){y.removeEventListener(t[0],t[1])}),0===v&&(dt(d,f.cssClasses.drag),K(),t.cursor&&(w.style.cursor=\"\",w.removeEventListener(\"selectstart\",lt))),e.handleNumbers.forEach(function(t){I(\"change\",t),I(\"set\",t),I(\"end\",t)})}function B(t,e){var r,n,i,o;e.handleNumbers.some(k)||(1===e.handleNumbers.length&&(o=a[e.handleNumbers[0]].children[0],v+=1,ft(o,f.cssClasses.active)),t.stopPropagation(),n=z(c.move,y,R,{target:t.target,handle:o,connect:e.connect,listeners:r=[],startCalcPoint:t.calcPoint,baseSize:j(),pageOffset:t.pageOffset,handleNumbers:e.handleNumbers,buttonsProperty:t.buttons,locations:m.slice()}),i=z(c.end,y,_,{target:t.target,handle:o,listeners:r,doNotReject:!0,handleNumbers:e.handleNumbers}),o=z(\"mouseout\",y,F,{target:t.target,handle:o,listeners:r,doNotReject:!0,handleNumbers:e.handleNumbers}),r.push.apply(r,n.concat(i,o)),t.cursor&&(w.style.cursor=getComputedStyle(t.target).cursor,1<a.length&&ft(d,f.cssClasses.drag),w.addEventListener(\"selectstart\",lt,!1)),e.handleNumbers.forEach(function(t){I(\"start\",t)}))}function r(t){t.stopPropagation();var i,o,s,e=H(t.calcPoint),r=(i=e,s=!(o=100),a.forEach(function(t,e){var r,n;k(e)||(r=m[e],((n=Math.abs(r-i))<o||n<=o&&r<i||100===n&&100===o)&&(s=e,o=n))}),s);!1!==r&&(f.events.snap||ut(d,f.cssClasses.tap,f.animationDuration),Q(r,e,!0,!0),K(),I(\"slide\",r,!0),I(\"update\",r,!0),f.events.snap?B(t,{handleNumbers:[r]}):(I(\"change\",r,!0),I(\"set\",r,!0)))}function q(t){var t=H(t.calcPoint),t=S.getStep(t),e=S.fromStepping(t);Object.keys(b).forEach(function(t){\"hover\"===t.split(\".\")[0]&&b[t].forEach(function(t){t.call(it,e)})})}function X(t,e){b[t]=b[t]||[],b[t].push(e),\"update\"===t.split(\".\")[0]&&a.forEach(function(t,e){I(\"update\",e)})}function Y(t){var n=t&&t.split(\".\")[0],i=n?t.substring(n.length):t;Object.keys(b).forEach(function(t){var e=t.split(\".\")[0],r=t.substring(e.length);n&&n!==e||i&&i!==r||((e=r)!==mt.aria&&e!==mt.tooltips||i===r)&&delete b[t]})}function I(r,n,i){Object.keys(b).forEach(function(t){var e=t.split(\".\")[0];r===e&&b[t].forEach(function(t){t.call(it,h.map(f.format.to),n,h.slice(),i||!1,m.slice(),it)})})}function W(t,e,r,n,i,o){var s;return 1<a.length&&!f.events.unconstrained&&(n&&0<e&&(s=S.getAbsoluteDistance(t[e-1],f.margin,!1),r=Math.max(r,s)),i&&e<a.length-1&&(s=S.getAbsoluteDistance(t[e+1],f.margin,!0),r=Math.min(r,s))),1<a.length&&f.limit&&(n&&0<e&&(s=S.getAbsoluteDistance(t[e-1],f.limit,!1),r=Math.min(r,s)),i&&e<a.length-1&&(s=S.getAbsoluteDistance(t[e+1],f.limit,!0),r=Math.max(r,s))),f.padding&&(0===e&&(s=S.getAbsoluteDistance(0,f.padding[0],!1),r=Math.max(r,s)),e===a.length-1&&(s=S.getAbsoluteDistance(100,f.padding[1],!0),r=Math.min(r,s))),!((r=ct(r=S.getStep(r)))===t[e]&&!o)&&r}function $(t,e){var r=f.ort;return(r?e:t)+\", \"+(r?t:e)}function G(t,r,n,e,i){var o=n.slice(),s=e[0],a=[!t,t],l=[t,!t];e=e.slice(),t&&e.reverse(),1<e.length?e.forEach(function(t,e){e=W(o,t,o[t]+r,a[e],l[e],!1);!1===e?r=0:(r=e-o[t],o[t]=e)}):a=l=[!0];var u=!1;e.forEach(function(t,e){u=Q(t,n[t]+r,a[e],l[e])||u}),u&&(e.forEach(function(t){I(\"update\",t),I(\"slide\",t)}),null!=i&&I(\"drag\",s))}function J(t,e){return f.dir?100-t-e:t}function K(){g.forEach(function(t){var e=50<m[t]?-1:1,e=3+(a.length+e*t);a[t].style.zIndex=String(e)})}function Q(t,e,r,n,i){return!1!==(e=i?e:W(m,t,e,r,n,!1))&&(e=e,m[t=t]=e,h[t]=S.fromStepping(e),e=\"translate(\"+$(J(e,0)-E+\"%\",\"0\")+\")\",a[t].style[f.transformRule]=e,Z(t),Z(t+1),!0)}function Z(t){var e,r;l[t]&&(r=100,e=\"translate(\"+$(J(e=(e=0)!==t?m[t-1]:e,r=(r=t!==l.length-1?m[t]:r)-e)+\"%\",\"0\")+\")\",r=\"scale(\"+$(r/100,\"1\")+\")\",l[t].style[f.transformRule]=e+\" \"+r)}function tt(t,e){return null===t||!1===t||void 0===t?m[e]:(\"number\"==typeof t&&(t=String(t)),!1===(t=!1!==(t=f.format.from(t))?S.toStepping(t):t)||isNaN(t)?m[e]:t)}function et(t,e,r){var n=pt(t),t=void 0===m[0];e=void 0===e||e,f.animate&&!t&&ut(d,f.cssClasses.tap,f.animationDuration),g.forEach(function(t){Q(t,tt(n[t],t),!0,!1,r)});var i,o=1===g.length?0:1;for(t&&S.hasNoSize()&&(r=!0,m[0]=0,1<g.length&&(i=100/(g.length-1),g.forEach(function(t){m[t]=t*i})));o<g.length;++o)g.forEach(function(t){Q(t,m[t],!0,!0,r)});K(),g.forEach(function(t){I(\"update\",t),null!==n[t]&&e&&I(\"set\",t)})}function rt(t){if(t=void 0===t?!1:t)return 1===h.length?h[0]:h.slice(0);t=h.map(f.format.to);return 1===t.length?t[0]:t}function nt(t){var e=m[t],r=S.getNearbySteps(e),n=h[t],i=r.thisStep.step,t=null;if(f.snap)return[n-r.stepBefore.startValue||null,r.stepAfter.startValue-n||null];!1!==i&&n+i>r.stepAfter.startValue&&(i=r.stepAfter.startValue-n),t=n>r.thisStep.startValue?r.thisStep.step:!1!==r.stepBefore.step&&n-r.stepBefore.highestStep,100===e?i=null:0===e&&(t=null);e=S.countStepDecimals();return null!==i&&!1!==i&&(i=Number(i.toFixed(e))),[t=null!==t&&!1!==t?Number(t.toFixed(e)):t,i]}ft(t=d,f.cssClasses.target),0===f.dir?ft(t,f.cssClasses.ltr):ft(t,f.cssClasses.rtl),0===f.ort?ft(t,f.cssClasses.horizontal):ft(t,f.cssClasses.vertical),ft(t,\"rtl\"===getComputedStyle(t).direction?f.cssClasses.textDirectionRtl:f.cssClasses.textDirectionLtr),i=P(t,f.cssClasses.base),function(t,e){var r=P(e,f.cssClasses.connects);a=[],(l=[]).push(N(r,t[0]));for(var n=0;n<f.handles;n++)a.push(C(e,n)),g[n]=n,l.push(N(r,t[n+1]))}(f.connect,i),(u=f.events).fixed||a.forEach(function(t,e){z(c.start,t.children[0],B,{handleNumbers:[e]})}),u.tap&&z(c.start,i,r,{}),u.hover&&z(c.move,i,q,{hover:!0}),u.drag&&l.forEach(function(e,t){var r,n,i,o,s;!1!==e&&0!==t&&t!==l.length-1&&(r=a[t-1],n=a[t],i=[e],o=[r,n],s=[t-1,t],ft(e,f.cssClasses.draggable),u.fixed&&(i.push(r.children[0]),i.push(n.children[0])),u.dragAll&&(o=a,s=g),i.forEach(function(t){z(c.start,t,B,{handles:o,handleNumbers:s,connect:e})}))}),et(f.start),f.pips&&T(f.pips),f.tooltips&&A(),Y(\"update\"+mt.aria),X(\"update\"+mt.aria,function(t,e,o,r,s){g.forEach(function(t){var e=a[t],r=W(m,t,0,!0,!0,!0),n=W(m,t,100,!0,!0,!0),i=s[t],t=String(f.ariaFormat.to(o[t])),r=S.fromStepping(r).toFixed(1),n=S.fromStepping(n).toFixed(1),i=S.fromStepping(i).toFixed(1);e.children[0].setAttribute(\"aria-valuemin\",r),e.children[0].setAttribute(\"aria-valuemax\",n),e.children[0].setAttribute(\"aria-valuenow\",i),e.children[0].setAttribute(\"aria-valuetext\",t)})});var it={destroy:function(){for(Y(mt.aria),Y(mt.tooltips),Object.keys(f.cssClasses).forEach(function(t){dt(d,f.cssClasses[t])});d.firstChild;)d.removeChild(d.firstChild);delete d.noUiSlider},steps:function(){return g.map(nt)},on:X,off:Y,get:rt,set:et,setHandle:function(t,e,r,n){if(!(0<=(t=Number(t))&&t<g.length))throw new Error(\"noUiSlider: invalid handle number, got: \"+t);Q(t,tt(e,t),!0,!0,n),I(\"update\",t),r&&I(\"set\",t)},reset:function(t){et(f.start,t)},__moveHandles:function(t,e,r){G(t,e,m,r)},options:o,updateOptions:function(e,t){var r=rt(),n=[\"margin\",\"limit\",\"padding\",\"range\",\"animate\",\"snap\",\"step\",\"format\",\"pips\",\"tooltips\"];n.forEach(function(t){void 0!==e[t]&&(o[t]=e[t])});var i=gt(o);n.forEach(function(t){void 0!==e[t]&&(f[t]=i[t])}),S=i.spectrum,f.margin=i.margin,f.limit=i.limit,f.padding=i.padding,f.pips?T(f.pips):L(),(f.tooltips?A:M)(),m=[],et(at(e.start)?e.start:r,t)},target:d,removePips:L,removeTooltips:M,getPositions:function(){return m.slice()},getTooltips:function(){return s},getOrigins:function(){return a},pips:T};return it}function z(t,e){if(!t||!t.nodeName)throw new Error(\"noUiSlider: create requires a single element, got: \"+t);if(t.noUiSlider)throw new Error(\"noUiSlider: Slider was already initialized.\");e=j(t,gt(e),e);return t.noUiSlider=e}var H={__spectrum:u,cssClasses:p,create:z};ot.create=z,ot.cssClasses=p,ot.default=H,Object.defineProperty(ot,\"__esModule\",{value:!0})});","Vertex_AddressValidation/uiRegistry.js":"/**\n * @copyright  Vertex. All rights reserved.  https://www.vertexinc.com/\n * @author     Mediotype                     https://www.mediotype.com/\n */\n\ndefine(function () {\n    'use strict';\n\n    return {\n        load: function (name, req, onload, config) {\n            req(['uiRegistry'], function (registry) {\n                let count = 0;\n                let timer = setInterval(function() {\n                    if(typeof(registry.get(name)) !== 'undefined') {\n                        onload(registry.get(name));\n                        clearInterval(timer);\n                    }\n                    count++;\n\n                    if(count >= 10) {\n                        clearInterval(timer);\n                        onload.error(new Error(name + 'never loaded into the registry'));\n                    }\n                }, 500);\n            });\n        }\n    }\n});\n","Vertex_AddressValidation/js/billing-validation-mixin.js":"/**\n * @copyright  Vertex. All rights reserved.  https://www.vertexinc.com/\n * @author     Mediotype                     https://www.mediotype.com/\n */\n\ndefine([\n    'jquery',\n    'uiRegistry',\n    'Magento_Checkout/js/checkout-data'\n], function ($, registry, checkoutData) {\n    'use strict';\n\n    return function (Component) {\n        return Component.extend({\n            validationConfig: window.checkoutConfig.vertexAddressValidationConfig,\n            addressValidator: null,\n\n            /**\n             * @returns {Object}\n             */\n            initialize: function () {\n                let self = this;\n                this._super();\n\n                registry.get(\n                    'checkout.steps.billing-step.payment.payments-list' +\n                    '.before-place-order.billingAdditional' +\n                    '.address-validation-message.validator',\n                    function (validator) {\n                        this.addressValidator = validator;\n                    }.bind(this)\n                );\n\n                this.isAddressDetailsVisible.subscribe(function (isVisible) {\n                    self.addressDetailsVisibilityChanged(isVisible);\n                });\n\n                return this;\n            },\n\n            /**\n             * @returns {self}\n             */\n            updateAddress: function () {\n                this.registerAddressInvalidationTrigger();\n\n                var billingData = checkoutData.getBillingAddressFromData();\n\n                if (!this.validationConfig.isAddressValidationEnabled ||\n                    this.addressValidator.isAddressValid ||\n                    billingData === null ||\n                    this.selectedAddress() && !this.isAddressFormVisible() ||\n                    this.validationConfig.countryValidation.indexOf(billingData.country_id) === -1\n                ) {\n                    return this._super();\n                }\n\n                this.addressValidator.addressValidation().done(function () {\n                    if (!this.validationConfig.showValidationSuccessMessage) {\n                        return this.updateAddress();\n                    }\n                }.bind(this));\n            },\n\n            /**\n             * When called, register a single (mind the \"one\") address invalidation trigger,\n             * that sets the \"this.addressValidator.isAddressValid = false\" for any further billing address field change.\n             */\n            registerAddressInvalidationTrigger: function () {\n                let that = this;\n                $('fieldset')\n                    .find('[data-form=\"billing-new-address\"]')\n                    .one(\n                        'keyup change paste',\n                        'input[name^=\"street\"]' +\n                        ', input[name=\"postcode\"]' +\n                        ', input[name=\"city\"]' +\n                        ', input[name=\"country_id\"]' +\n                        ', select[name=\"region_id\"]',\n                        function () {\n                            that.addressValidator.isAddressValid = false;\n                        });\n            },\n\n            /**\n             * If the address details are visible, then remove the validation address warning message\n             *\n             * @param isVisible\n             */\n            addressDetailsVisibilityChanged: function (isVisible) {\n                let message = this.addressValidator.message;\n                if (isVisible && message.hasMessage() && message.message.type === 1) {\n                    message.clear();\n                }\n            }\n        });\n    };\n});\n","Vertex_AddressValidation/js/shipping-validation-mixin.js":"/**\n * @copyright  Vertex. All rights reserved.  https://www.vertexinc.com/\n * @author     Mediotype                     https://www.mediotype.com/\n */\n\ndefine([\n    'uiRegistry',\n    'Magento_Checkout/js/model/quote'\n], function (registry, quote) {\n    'use strict';\n\n    return function (Component) {\n        return Component.extend({\n            validationConfig: window.checkoutConfig.vertexAddressValidationConfig,\n            shippingData: null,\n            addressValidator: null,\n\n            /**\n             * @returns {Object}\n             */\n            initialize: function () {\n                this._super();\n\n                registry.get(\n                    'checkout.steps.shipping-step.shippingAddress' +\n                    '.before-shipping-method-form.shippingAdditional' +\n                    '.address-validation-message.validator',\n                    function (validator) {\n                        this.addressValidator = validator;\n                    }.bind(this)\n                );\n\n                this.shippingData = quote.shippingAddress();\n                return this;\n            },\n\n            /**\n             * @return {Boolean}\n             */\n            validateShippingInformation: function () {\n                var superResult = this._super();\n\n                // Proceed with saving the address\n                if (!this.validationConfig.isAddressValidationEnabled ||\n                    !superResult ||\n                    this.addressValidator.isAddressValid ||\n                    !quote.shippingAddress().isEditable() ||\n                    this.validationConfig.countryValidation.indexOf(this.shippingData.countryId) === -1\n                ) {\n                    this.addressValidator.message.clear();\n                    return superResult;\n                }\n\n                // Run address validation\n                if (superResult) {\n                    this.addressValidator.addressValidation().done(function () {\n                        if (!this.validationConfig.showValidationSuccessMessage) {\n                            this.setShippingInformation();\n                        }\n                    }.bind(this));\n\n                    return false;\n                }\n                return superResult;\n            }\n        });\n    };\n});\n","Vertex_AddressValidation/js/definitions.js":"/*\n * @copyright  Vertex. All rights reserved.  https://www.vertexinc.com/\n * @author     Mediotype                     https://www.mediotype.com/\n */\n\n/**\n * @typedef UncleanAddress\n * @api\n * @property {string[]} streetAddress\n * @property {string} city\n * @property {string} mainDivision - Region, State, or Province\n * @property {string} postalCode - ZIP or postal code\n * @property {string} country - 2 or 3 letter country code\n */\n\n/**\n * @typedef CleanAddress\n * @api\n * @property {string[]} streetAddress - street address lines\n * @property {?string} city - name of the city\n * @property {?string} subDivision - name of the sub-division (county, parish)\n * @property {?string} regionName - name of the region (state/province)\n * @property {?int} regionId - numeric (state/province) region identifier in the Magento database\n * @property {?string} postalCode - ZIP+4 or postal code\n * @property {?string} countryCode - 2 letter country code\n * @property {?string} countryName - name of the country\n */\n","Vertex_AddressValidation/js/shipping-invalidate-mixin.js":"/**\n * @copyright  Vertex. All rights reserved.  https://www.vertexinc.com/\n * @author     Mediotype                     https://www.mediotype.com/\n */\n\ndefine([\n    'uiRegistry',\n    'mage/utils/wrapper'\n], function (registry, wrapper) {\n    'use strict';\n\n    var config = window.checkoutConfig.vertexAddressValidationConfig || {};\n\n    return function (target) {\n        if (!config.isAddressValidationEnabled) {\n            return target;\n        }\n\n        var validationMessage = registry.get(\n            'checkout.steps.shipping-step.shippingAddress' +\n            '.before-shipping-method-form.shippingAdditional'\n        );\n\n        target.setSelectedShippingAddress = wrapper.wrap(target.setSelectedShippingAddress, function (original, args) {\n            var addressValidator = registry.get(\n                'checkout.steps.shipping-step.shippingAddress' +\n                '.before-shipping-method-form.shippingAdditional' +\n                '.address-validation-message.validator'\n            );\n\n            addressValidator.isAddressValid = false;\n            validationMessage.clear();\n\n            return original(args);\n        });\n\n        return target;\n    }\n});\n","Vertex_AddressValidation/js/validation-messages.js":"/*\n * @copyright  Vertex. All rights reserved.  https://www.vertexinc.com/\n * @author     Mediotype                     https://www.mediotype.com/\n */\ndefine(['mage/translate'], function ($t) {\n    'use strict';\n\n    /**\n     * Messages here may not be the final version.  Please check the module's\n     * i18n.csv file for final english versions.\n     *\n     * Messages are kept here as-is for backwards compatibility with translations\n     */\n    return {\n        noChangesNecessary: $t('The address is valid'),\n        noAddressFound: $t('We did not find a valid address'),\n        changesFound: $t('The address is not valid'),\n        adminChangesFound: $t('The intended address could be:'),\n        addressUpdated: $t('The address was updated'),\n        streetAddressUpdateWarning: $t('Warning: Updating the address will replace all street address fields.')\n    };\n})\n","Vertex_AddressValidation/js/customer-validation-mixin.js":"/**\n * @copyright  Vertex. All rights reserved.  https://www.vertexinc.com/\n * @author     Mediotype                     https://www.mediotype.com/\n */\n\ndefine(['jquery'], function ($) {\n    'use strict';\n\n    const config = window.vertexAddressValidationConfig || {};\n\n    return function (addressValidation) {\n        if (!config.enabled) {\n            return addressValidation;\n        }\n\n        $.widget('mage.addressValidation', addressValidation, {\n            _vertexValidator: null,\n            _vertexForm: null,\n\n            /**\n             * Initialize widget\n             *\n             * @returns {*}\n             * @private\n             */\n            _create: function () {\n                var result = this._super(),\n                    button = $(this.options.selectors.button, this.element);\n\n                require([\n                    'Vertex_AddressValidation/js/view/customer/address-form',\n                    'Vertex_AddressValidation/js/view/customer/address-validation'\n                ], function (addressForm, addressValidator) {\n                    this._vertexValidator = addressValidator();\n                    this._vertexForm = addressForm;\n\n                    addressForm.initialize(this.element, button);\n                    addressForm.renameSubmitButton(config.validateButtonText);\n                }.bind(this));\n\n                this.element.data('validator').settings.submitHandler = function (form) {\n                    if (this._vertexForm && this._vertexForm.isSaveAsIs) {\n                        this._vertexForm.isSaveAsIs = false;\n                        return this.submitForm(form);\n                    }\n\n                    if (this._vertexValidator && this._vertexForm) {\n                        this._vertexValidator.addressValidation(this._vertexForm.getAddress()).done(this.submitForm.bind(this, form));\n                    }\n                }.bind(this);\n\n                return result;\n            },\n\n            /**\n             * Submit form\n             *\n             * @param {Object} form\n             */\n            submitForm: function (form) {\n                if (this._vertexForm) {\n                    this._vertexForm.disableSubmitButtons();\n                }\n                form.submit();\n            }\n        });\n        return $.mage.addressValidation;\n    };\n});\n","Vertex_AddressValidation/js/action/address-validation-request.js":"/**\n * @copyright  Vertex. All rights reserved.  https://www.vertexinc.com/\n * @author     Mediotype                     https://www.mediotype.com/\n */\n\ndefine([\n    'mage/storage',\n    'Vertex_AddressValidation/js/model/url-builder'\n], function (\n    storage,\n    urlBuilder\n) {\n    'use strict';\n\n    /**\n     * Cleanse an Address\n     *\n     * @param {UncleanAddress} address\n     */\n    return function (address) {\n        let url = '/address/cleanse';\n        const params = {address: address};\n\n        if (window.checkoutConfig && window.checkoutConfig.isCustomerLoggedIn === false) {\n            url = '/guest-address/cleanse';\n            params.cartId = window.checkoutConfig.quoteId;\n        }\n\n        return storage.post(\n            urlBuilder.createUrl(url, {}),\n            JSON.stringify(params)\n        );\n    };\n});\n","Vertex_AddressValidation/js/action/build-quote-address.js":"/*\n * @copyright  Vertex. All rights reserved.  https://www.vertexinc.com/\n * @author     Mediotype                     https://www.mediotype.com/\n */\n\ndefine([], function () {\n    'use strict';\n\n    /**\n     * Convert a Cleansed Address to a Magento Quote Address object\n     *\n     * @param {CleanAddress} address\n     * @returns {Object} quoteAddress\n     */\n    return function (address) {\n        return {\n            street: address.street_address,\n            city: address.city,\n            region: address.region_name,\n            region_id: address.region_id,\n            postcode: address.postal_code,\n            country_id: address.country_code\n        }\n    }\n})\n","Vertex_AddressValidation/js/action/convert-quote-address.js":"/*\n * @copyright  Vertex. All rights reserved.  https://www.vertexinc.com/\n * @author     Mediotype                     https://www.mediotype.com/\n */\n\ndefine(['uiRegistry'], function (registry) {\n    'use strict';\n\n    /**\n     * Convert a Magento Quote or Customer Address to an unclean address\n     *\n     * In most instances, the caller will need to set the region property on the address object.\n     *\n     * @param {Object} address\n     * @returns {UncleanAddress}\n     */\n    return function (address) {\n        const streetAddress = [];\n\n        for (let i in address.street) {\n            if (!address.street.hasOwnProperty(i)) {\n                continue;\n            }\n            if (address.street[i].length > 0) {\n                streetAddress.push(address.street[i]);\n            }\n        }\n\n        let countryId;\n        if (typeof address.countryId !== 'undefined') {\n            countryId = address.countryId;\n        } else if (typeof address.country_id !== 'undefined') {\n            countryId = address.country_id;\n        }\n\n        return {\n            street_address: streetAddress,\n            city: address.city,\n            main_division: address.region,\n            postal_code: address.postcode,\n            country: countryId\n        };\n    };\n});\n","Vertex_AddressValidation/js/model/difference-determiner.js":"/*\n * @copyright  Vertex. All rights reserved.  https://www.vertexinc.com/\n * @author     Mediotype                     https://www.mediotype.com/\n */\n\ndefine(['mage/translate'], function ($t) {\n    'use strict';\n\n    /**\n     * @typedef VertexAddressReadableDifference\n     * @property {string} type - Type of difference (used for code)\n     * @property {string} name - Human readable name of the item that has changed\n     * @property {(string|string[])} value - Human readable value of the item that has changed\n     * @property {(string|string[])} rawValue - Script usable value of the item that has changed\n     */\n\n    /**\n     * @param {UncleanAddress} uncleanAddress\n     * @param {CleanAddress} cleanAddress\n     * @returns {boolean}\n     */\n    function streetAddressesAreDifferent(uncleanAddress, cleanAddress) {\n        uncleanAddress.street_address.filter(function (val) {\n            // Filter out empty strings\n            return val.length > 0;\n        });\n\n        if (uncleanAddress.street_address.length !== cleanAddress.street_address.length) {\n            return true;\n        }\n        for(let index = 0,length = uncleanAddress.street_address.length;index < length;++index) {\n            if (uncleanAddress.street_address[index] !== cleanAddress.street_address[index]) {\n                return true;\n            }\n        }\n        return false;\n    }\n\n    /**\n     * @param {UncleanAddress} uncleanAddress\n     * @param {CleanAddress} cleanAddress\n     * @returns {VertexAddressReadableDifference[]}\n     */\n    return function (uncleanAddress, cleanAddress) {\n        const listedDifferences = [];\n        if (streetAddressesAreDifferent(uncleanAddress, cleanAddress)) {\n            listedDifferences.push({type: 'street', name: $t('Street Address'), value: cleanAddress.street_address, rawValue: cleanAddress.street_address});\n        }\n        if (uncleanAddress.city !== cleanAddress.city) {\n            listedDifferences.push({type: 'city', name: $t('City'), value: cleanAddress.city, rawValue: cleanAddress.city});\n        }\n        if (uncleanAddress.main_division !== cleanAddress.region_name) {\n            listedDifferences.push({type: 'region', name: $t('State/Province'), value: cleanAddress.region_name, rawValue: cleanAddress.region_id});\n        }\n        if (uncleanAddress.postal_code !== cleanAddress.postal_code) {\n            listedDifferences.push({type: 'postcode', name: $t('Zip/Postal Code'), value: cleanAddress.postal_code, rawValue: cleanAddress.postal_code});\n        }\n        if (uncleanAddress.country !== cleanAddress.country_code) {\n            listedDifferences.push({type: 'country', name: $t('Country'), value: cleanAddress.country_name, rawValue: cleanAddress.country_code});\n        }\n        return listedDifferences;\n    };\n});\n","Vertex_AddressValidation/js/model/url-builder.js":"/**\n * @copyright  Vertex. All rights reserved.  https://www.vertexinc.com/\n * @author     Mediotype                     https://www.mediotype.com/\n */\n\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    var config = window.checkoutConfig || window.vertexAddressValidationConfig || {};\n\n    return {\n        method: 'rest',\n        storeCode: config.storeCode,\n        version: 'V1',\n        serviceUrl: ':method/:storeCode/:version',\n\n        /**\n         * @param {String} url\n         * @param {Object} params\n         * @return {*}\n         */\n        createUrl: function (url, params) {\n            var completeUrl = this.serviceUrl + url;\n            return this.bindParams(completeUrl, params);\n        },\n\n        /**\n         * @param {String} url\n         * @param {Object} params\n         * @return {*}\n         */\n        bindParams: function (url, params) {\n            var urlParts;\n\n            params.method = this.method;\n            params.storeCode = this.storeCode;\n            params.version = this.version;\n\n            urlParts = url.split('/');\n            urlParts = urlParts.filter(Boolean);\n\n            $.each(urlParts, function (key, part) {\n                part = part.replace(':', '');\n\n                if (params[part] !== undefined) {\n                    urlParts[key] = params[part];\n                }\n            });\n\n            return urlParts.join('/');\n        }\n    };\n});\n","Vertex_AddressValidation/js/model/address-difference-template-renderer.js":"/*\n * @copyright  Vertex. All rights reserved.  https://www.vertexinc.com/\n * @author     Mediotype                     https://www.mediotype.com/\n */\n\ndefine(['underscore', 'uiClass'], function (_, Component) {\n    'use strict';\n\n    /**\n     * @typedef {Object} vertexDifferenceRendererObject\n     * @property {vertexDifferenceObject_Message} message\n     */\n\n    /**\n     * @typedef {Object} vertexDifferenceObject_Message\n     * @property {string} text - Informative message to end user\n     * @property {vertexDifferenceObject_Difference[]} differences - Array of differences\n     */\n\n    /**\n     * @typedef {Object} vertexDifferenceObject_Difference\n     * @property {string} name - Human readable name of field that has a difference\n     * @property {string} value - New value for the field\n     */\n\n    /**\n     * @api\n     */\n    return Component.extend({\n        /**\n         * @var {string} template - Location of file to render\n         */\n        template: 'Vertex_AddressValidation/template/validation-result.html',\n\n        /**\n         * @var {*} renderer - Underscore.js template object\n         */\n        renderer: null,\n\n        /**\n         * @constructor\n         * @param {string} template - File to render\n         * @returns {*}\n         */\n        initialize: function (template) {\n            if (typeof this.template !== 'undefined') {\n                this.template = template;\n            }\n\n            require(['text!' + this.template], function (templateContents) {\n                this.renderer = _.template(templateContents);\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * @param {vertexDifferenceRendererObject} message\n         * @returns {string} HTML\n         */\n        render: function (message) {\n            return this.renderer(message);\n        }\n    });\n});\n","Vertex_AddressValidation/js/model/checkout/shipping/address-resolver.js":"/**\n * @copyright  Vertex. All rights reserved.  https://www.vertexinc.com/\n * @author     Mediotype                     https://www.mediotype.com/\n */\n\ndefine([\n    'jquery',\n    'uiRegistry',\n    'Magento_Customer/js/model/address-list',\n    'Vertex_AddressValidation/js/model/customer/address-resolver',\n    'Magento_Checkout/js/action/create-shipping-address',\n    'Magento_Checkout/js/checkout-data'\n], function ($, registry, addressList, addressResolver, createShippingAddress, checkoutData) {\n    'use strict';\n\n    addressResolver = $.extend({}, addressResolver, {\n        checkoutProvider: registry.get('checkoutProvider'),\n\n        updateFields: function (element, value) {\n            var addressData = $.extend({}, this.checkoutProvider.get('shippingAddress'));\n\n            if (element.name === 'street') {\n                // Just updating the addressData element doesn't seem to work on street inputs\n                const streetInputs = $('.form-shipping-address input[name^=\"street[\"]');\n                value = typeof value === \"string\" ? [value] : Object.values(value);\n                streetInputs.val('');\n                for(let index = 0, length = value.length;index < length;++index) {\n                    addressData[element.name][index] = typeof value[index] !== 'undefined' ? value[index] : '';\n                    $(streetInputs[index])\n                        .val(addressData[element.name][index]);\n                }\n            } else {\n                addressData[element.name] = value;\n            }\n\n            this.checkoutProvider.set('shippingAddress', addressData);\n            this.checkoutProvider.trigger('shippingAddress', addressData);\n\n            // Update address list containers\n            createShippingAddress(addressData);\n            checkoutData.setNewCustomerShippingAddress($.extend(true, {}, addressData));\n        }\n    });\n    return addressResolver;\n});\n","Vertex_AddressValidation/js/model/checkout/billing/address-resolver.js":"/**\n * @copyright  Vertex. All rights reserved.  https://www.vertexinc.com/\n * @author     Mediotype                     https://www.mediotype.com/\n */\n\ndefine([\n    'jquery',\n    'uiRegistry',\n    'Magento_Customer/js/model/address-list',\n    'Vertex_AddressValidation/js/model/customer/address-resolver'\n], function ($, registry, addressList, addressResolver) {\n    'use strict';\n\n    addressResolver = $.extend({}, addressResolver, {\n        updateFields: function (element, value) {\n            if (element.name === 'street') {\n                const streetInputs = $('.payment-method input[name^=\"street[\"]');\n                streetInputs.val('');\n                value = typeof value === \"string\" ? [value] : Object.values(value);\n                for (let index = 0, length = value.length;index < length;++index) {\n                    $(streetInputs[index])\n                        .val(value[index]);\n                }\n                streetInputs.trigger('change').trigger('blur');\n            } else {\n                $('.payment-method input[name=\"' + element.name + '\"]')\n                    .val(value)\n                    .trigger('change')\n                    .trigger('blur');\n            }\n        }\n    });\n    return addressResolver;\n});\n","Vertex_AddressValidation/js/model/customer/address-resolver.js":"/**\n * @copyright  Vertex. All rights reserved.  https://www.vertexinc.com/\n * @author     Mediotype                     https://www.mediotype.com/\n */\n\ndefine([\n    'jquery',\n    'underscore'\n], function ($, _) {\n    'use strict';\n\n    return {\n        addressFieldsForValidation: ['city', 'postcode', 'street'],\n        responseAddressData: {},\n        formAddressData: {},\n\n        /**\n         * Will check if the response is different, same or invalid\n         *\n         * @param {Object} responseAddressData\n         * @param {Object} formAddressData\n         * @returns {Boolean|Array}\n         */\n        resolveAddressDifference: function (responseAddressData, formAddressData) {\n            var differences = [],\n                valid = [];\n\n            this.responseAddressData = responseAddressData;\n            this.formAddressData = formAddressData;\n\n            if (this.invalidErrorResponse(responseAddressData)) {\n                return [];\n            }\n\n            _.each(this.addressFieldsForValidation, function (v, i) {\n                var responseValue, value, name, isComplex,\n                    complexValues = [],\n                    isDifferent = false;\n\n                isComplex = _.isObject(formAddressData[v]) || _.isArray(formAddressData[v]);\n\n                if (responseAddressData[v] !== formAddressData[v]) {\n                    if (isComplex) {\n                        _.each(formAddressData[v], function (val, index) {\n                            if (val && responseAddressData[v][index] && val !== responseAddressData[v][index]) {\n                                complexValues[index] = responseAddressData[v][index];\n                                isDifferent = true;\n                            }\n                        });\n                    }\n\n                    if (!isDifferent && isComplex) {\n                        valid.push(v);\n                    }\n\n                    responseValue = responseAddressData[v];\n                    if (complexValues.length) {\n                        responseValue = complexValues.join(', ');\n                    }\n\n                    if (!complexValues.length && _.isArray(responseValue) || responseValue === null) {\n                        return;\n                    }\n\n                    value = responseValue.substr(0, 1).toUpperCase() + responseValue.substr(1);\n                    name = v.substr(0, 1).toUpperCase() + v.substr(1);\n                    differences.push({\n                        value: value,\n                        name: name\n                    });\n\n                    return;\n                }\n                valid[i] = v;\n            });\n\n            if (valid.length === this.addressFieldsForValidation.length && _.isEmpty(differences)) {\n                return true;\n            }\n            return differences;\n        },\n\n        /**\n         * Updates form inputs with the values from the API response\n         *\n         * @returns {*}\n         */\n        resolveAddressUpdate: function () {\n            var responseAddressData = this.responseAddressData,\n                formAddressData = this.formAddressData,\n                self = this;\n\n            _.each(this.addressFieldsForValidation, function (v) {\n                var fieldValue = responseAddressData[v],\n                    linesObj = {};\n\n                if (_.isObject(formAddressData[v])) {\n                    _.each(formAddressData[v], function (val, i) {\n                        if (fieldValue[i]) {\n                            linesObj[i] = fieldValue[i];\n                            self.updateFields({name: v, key: i}, fieldValue[i]);\n\n                            return;\n                        }\n                        linesObj[i] = val;\n                    });\n                    formAddressData[v] = linesObj;\n                    return;\n                }\n\n                formAddressData[v] = fieldValue;\n                self.updateFields({name: v}, fieldValue);\n            });\n\n            return formAddressData;\n        },\n\n        /**\n         * Update validated fields\n         *\n         * @param {Object} element\n         * @param {String} value\n         */\n        updateFields: function (element, value) {\n            if (element.key !== undefined) {\n                $('input[name=\"' + element.name + '[]\"]').eq(element.key).val(value).trigger('change');\n            } else {\n                $('input[name=\"' + element.name + '\"]').val(value).trigger('change');\n            }\n        },\n\n        /**\n         * Will check if the api response found a address\n         *\n         * @param {Object} responseData\n         * @returns {Boolean}\n         */\n        invalidErrorResponse: function (responseData) {\n            _.each(this.addressFieldsForValidation, function (v) {\n                if (_.isArray(responseData[v]) && responseData[v][0] === '') {\n                    return true;\n                }\n\n                if (responseData[v] === null) {\n                    return true;\n                }\n            });\n            return false;\n        }\n    };\n});\n","Vertex_AddressValidation/js/view/validation-message.js":"define([\n    'ko',\n    'uiComponent',\n    'Vertex_AddressValidation/js/model/address-difference-template-renderer',\n    'Vertex_AddressValidation/js/validation-messages'\n], function (ko, Component, differenceRenderer, validationMessages) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Vertex_AddressValidation/validation-message',\n            cleanseAddressTemplate: 'Vertex_AddressValidation/template/validation-result.html',\n            showSuccessMessage: false,\n            message: {},\n            address: null,\n            hasMessage: false,\n            tracks: {\n                showSuccessMessage: true,\n                message: true\n            }\n        },\n\n        templateRenderer: null,\n\n        initialize: function () {\n            this._super();\n            this.templateRenderer = new differenceRenderer(this.cleanseAddressTemplate);\n            return this;\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Model} Chainable.\n         */\n        initObservable: function () {\n            this.address = ko.observable();\n\n            this.hasMessage = ko.pureComputed(function() {\n                return this._objectHasEntries(this.message);\n            }.bind(this));\n\n            this.renderedTemplate = ko.pureComputed(function () {\n                const templateVariables = {\n                    message: {\n                        text: this.message.text,\n                        differences: this.message.differences\n                    },\n                    address: this.address()\n                };\n\n                for (let index = 0,length = this.message.differences.length;index < length;++index) {\n                    if (this.message.differences[index].type === 'street') {\n                        templateVariables.warning = validationMessages.streetAddressUpdateWarning;\n                        break;\n                    }\n                }\n\n                return this.templateRenderer.render(templateVariables);\n            }.bind(this));\n\n            return this._super();\n        },\n\n\n        /**\n         * Sets a success message\n         *\n         * @param {String} text\n         * @param {Object} differences\n         */\n        setSuccessMessage: function (text, differences) {\n            this.setMessage(0, 'message success', text, differences || []);\n        },\n\n        /**\n         * Sets a warning message\n         *\n         * @param {String} text\n         * @param {Object} differences\n         * @param {CleanAddress} address\n         */\n        setWarningMessage: function (text, differences, address) {\n            this.address(address || {});\n            this.setMessage(1, 'message warning', text, differences || []);\n        },\n\n        /**\n         * Sets a message\n         *\n         * @param {Integer} type\n         * @param {String} cssClass\n         * @param {String} text\n         * @param {Object} differences\n         */\n        setMessage: function (type, cssClass, text, differences) {\n            this.message = {\n                type: type,\n                text: text,\n                class: cssClass || '',\n                differences: differences || []\n            };\n        },\n\n        /**\n         * Returns if message exists\n         *\n         * @returns {Boolean}\n         */\n        hasMessage: function () {\n            return ko.computed(function () {\n                return this._objectHasEntries(this.message);\n            }.bind(this));\n        },\n\n        /**\n         * Returns message\n         *\n         * {Object}\n         */\n        clear: function () {\n            this.message = {};\n        },\n\n        /**\n         * Return whether or not the object has any entries\n         *\n         * Object.entries is not supported by IE11 or Opera Mini.\n         * Writing a quick method to serve the same purpose was easier than\n         * importing a shim.\n         *\n         * @param {Object} object\n         * @returns {boolean}\n         * @private\n         */\n        _objectHasEntries: function(object) {\n            if (typeof Object.entries !== 'undefined') {\n                return Object.entries(object).length !== 0;\n            }\n            for (let key in object) {\n                if (object.hasOwnProperty(key)) {\n                    return true;\n                }\n            }\n        },\n    });\n});\n","Vertex_AddressValidation/js/view/checkout/shipping/address-validation.js":"/**\n * @copyright  Vertex. All rights reserved.  https://www.vertexinc.com/\n * @author     Mediotype                     https://www.mediotype.com/\n */\n\ndefine([\n    'jquery',\n    'uiRegistry',\n    'uiComponent',\n    'Vertex_AddressValidation/js/action/address-validation-request',\n    'Vertex_AddressValidation/js/model/checkout/shipping/address-resolver',\n    'Magento_Checkout/js/model/full-screen-loader',\n    'Magento_Checkout/js/checkout-data',\n    'Magento_Checkout/js/model/error-processor',\n    'Magento_Ui/js/model/messageList',\n    'Vertex_AddressValidation/js/validation-messages',\n    'Vertex_AddressValidation/js/action/convert-quote-address',\n    'Vertex_AddressValidation/js/action/build-quote-address',\n    'Vertex_AddressValidation/js/model/difference-determiner'\n], function (\n    $,\n    registry,\n    Component,\n    addressValidationRequest,\n    addressResolver,\n    fullScreenLoader,\n    checkoutData,\n    errorProcessor,\n    messageContainer,\n    validationMessages,\n    convertQuoteAddress,\n    buildQuoteAddress,\n    differenceDeterminer\n) {\n    'use strict';\n\n    return Component.extend({\n        validationConfig: window.checkoutConfig.vertexAddressValidationConfig || {},\n        resolver: addressResolver,\n        isAddressValid: false,\n        message: null,\n        defaults: {\n            listens: {\n                addressData: 'addressUpdated'\n            },\n            imports: {\n                addressData: '${ $.provider }:shippingAddress'\n            }\n        },\n\n        /**\n         * Reset validation after address update\n         */\n        addressUpdated: function () {\n            this.isAddressValid = false;\n            this.updateAddress = false;\n\n            if (this.message) {\n                this.message.clear();\n                this.message.showSuccessMessage = false;\n            }\n        },\n\n        /**\n         * @returns {Object}\n         */\n        initialize: function () {\n            this._super();\n            this.message = registry.get(this.parentName);\n\n            return this;\n        },\n\n        /**\n         * @returns {Object}\n         */\n        getFormData: function () {\n            const formData = checkoutData.getShippingAddressFromData(),\n                checkoutProvider = registry.get('checkoutProvider');\n\n            if (checkoutProvider && checkoutProvider.dictionaries && checkoutProvider.dictionaries.region_id) {\n                const region = registry.get('checkoutProvider').dictionaries.region_id.find(function (obj) {\n                    return obj.value === formData.region_id;\n                });\n                if (region && region.label) {\n                    formData.region = region.label;\n                }\n            }\n\n            return formData;\n        },\n\n        /**\n         * Triggers a request to the address validation builder and adds the response\n         */\n        addressValidation: function () {\n            var deferred = $.Deferred();\n            this.isAddressValid = false;\n            fullScreenLoader.startLoader();\n\n            addressValidationRequest(convertQuoteAddress(this.getFormData()))\n                .done(function (response) {\n                    this.isAddressValid = true;\n                    if (this.handleAddressDifferenceResponse(response) === true) {\n                        deferred.resolve();\n                    }\n                }.bind(this)).fail(function (response) {\n                errorProcessor.process(response, messageContainer);\n            }).always(function () {\n                fullScreenLoader.stopLoader();\n            });\n\n            return deferred;\n        },\n\n        /**\n         * Get the message with the differences\n         *\n         * @param {?CleanAddress} response\n         */\n        handleAddressDifferenceResponse: function (response) {\n            if (response === null || !Object.keys(response).length) {\n                this.message.setWarningMessage(validationMessages.noAddressFound);\n                return;\n            }\n\n            this.resolver.responseAddressData = buildQuoteAddress(response);\n\n            const differences = differenceDeterminer(convertQuoteAddress(this.getFormData()), response),\n                showSuccessMessage = this.validationConfig.showValidationSuccessMessage || false;\n\n            if (differences.length === 0 && showSuccessMessage) {\n                this.message.setSuccessMessage(validationMessages.noChangesNecessary);\n            } else if (differences.length > 0) {\n                this.message.setWarningMessage(validationMessages.changesFound, differences, response);\n            } else {\n                return true;\n            }\n        },\n\n        /**\n         * Get the update message\n         */\n        updateVertexAddress: function () {\n            this.resolver.resolveAddressUpdate();\n\n            this.message.setSuccessMessage(validationMessages.addressUpdated);\n            this.isAddressValid = true;\n        }\n    });\n});\n","Vertex_AddressValidation/js/view/checkout/billing/address-validation.js":"/**\n * @copyright  Vertex. All rights reserved.  https://www.vertexinc.com/\n * @author     Mediotype                     https://www.mediotype.com/\n */\n\ndefine([\n    'Vertex_AddressValidation/js/view/checkout/shipping/address-validation',\n    'Vertex_AddressValidation/js/model/checkout/billing/address-resolver',\n    'Magento_Checkout/js/checkout-data',\n    'uiRegistry'\n], function (\n    Component,\n    addressResolver,\n    checkoutData,\n    registry\n) {\n    'use strict';\n\n    return Component.extend({\n        resolver: addressResolver,\n\n        /**\n         * @returns {Object}\n         */\n        getFormData: function () {\n            const formData = checkoutData.getBillingAddressFromData(),\n                checkoutProvider = registry.get('checkoutProvider');\n\n            if (checkoutProvider && checkoutProvider.dictionaries && checkoutProvider.dictionaries.region_id) {\n                const region = registry.get('checkoutProvider').dictionaries.region_id.find(function (obj) {\n                    return obj.value === formData.region_id;\n                });\n                if (region && region.label) {\n                    formData.region = region.label;\n                }\n            }\n\n            return formData;\n        }\n    });\n});\n","Vertex_AddressValidation/js/view/customer/address-form.js":"/**\n * @copyright  Vertex. All rights reserved.  https://www.vertexinc.com/\n * @author     Mediotype                     https://www.mediotype.com/\n */\n\ndefine([\n    'jquery',\n    'ko',\n    'underscore',\n    'Vertex_AddressValidation/js/model/customer/address-resolver'\n], function ($, ko, _, addressResolver) {\n    'use strict';\n\n    const config = window.vertexAddressValidationConfig || {};\n\n    return {\n        form: {},\n        button: {},\n        saveAsIsButton: {},\n        formUpdated: ko.observable(false),\n        isSaveAsIs: false,\n\n        /**\n         * Initialize address form object\n         *\n         * @param {Object} form\n         * @param {Object} button\n         */\n        initialize: function (form, button) {\n            var self = this,\n                fieldsToValidate = _.clone(addressResolver.addressFieldsForValidation);\n\n            this.form = form || {};\n            this.button = button || {};\n\n            fieldsToValidate.push('country_id');\n            fieldsToValidate.forEach(function (name) {\n                self.getFieldByName(name).on('input', function () {\n                    self.formUpdated(true);\n                });\n            });\n        },\n\n        /**\n         * Return jQuery object by name\n         *\n         * @param {String} name\n         */\n        getFieldByName: function (name) {\n            return this.form.find('[name=%s]'.replace('%s', name));\n        },\n\n        /**\n         * Rename form button value\n         *\n         * @param {String} value\n         */\n        renameSubmitButton: function (value, button) {\n            var button = button || this.button;\n            var buttonValue = $(button.html()).html(value);\n            button.html(buttonValue).attr('title', value);\n        },\n\n        /**\n         * Show 'Save As Is' button\n         */\n        showSaveAsIsButton: function () {\n            if (!_.isEmpty(this.saveAsIsButton)) {\n                this.saveAsIsButton.show();\n                return;\n            }\n\n            this.saveAsIsButton = $('<button/>', {\n                text: config.saveAsIsButtonText || '',\n                class: 'action save vertex-secondary',\n                'data-action': 'save-as-is-address',\n                click: function () {\n                    this.isSaveAsIs = true;\n                }.bind(this)\n            });\n\n            this.saveAsIsButton.insertAfter(this.button);\n        },\n\n        /**\n         * Hide 'Save As Is' button\n         */\n        hideSaveAsIsButton: function () {\n            if (!_.isEmpty(this.saveAsIsButton)) {\n                this.saveAsIsButton.hide();\n            }\n        },\n\n        /**\n         * Disable form submit buttons\n         */\n        disableSubmitButtons: function () {\n            this.button.attr('disabled', true);\n\n            if (!_.isEmpty(this.saveAsIsButton)) {\n                this.saveAsIsButton.attr('disabled', true);\n            }\n        },\n\n        /**\n         * Retrieves form address and converts it to customer address\n         *\n         * @returns {UncleanAddress}\n         */\n        getAddress: function () {\n            const address = {},\n                city = this.form.find('input[name=\"city\"]').val(),\n                streetAddress = this.form.find('input[name=\"street[]\"]')\n                    .map(function (index, element) {\n                        return $(element).val();\n                    })\n                    .toArray()\n                    .filter(function (value) {\n                        return value.length > 0;\n                    }),\n                mainDivisionValue = this.form.find('select[name=\"region_id\"]').val(),\n                mainDivision = this.form.find('select[name=\"region_id\"] option[value=\"' + mainDivisionValue + '\"]').text(),\n                postalCode = this.form.find('input[name=\"postcode\"]').val(),\n                country = this.form.find('select[name=\"country_id\"]').val();\n\n            address.street_address = streetAddress;\n            if (city.length > 0) {\n                address.city = city;\n            }\n            if (mainDivisionValue.length > 0) {\n                address.main_division = mainDivision;\n            }\n            if (postalCode.length > 0) {\n                address.postal_code = postalCode;\n            }\n            address.country = country;\n\n            return address;\n        },\n\n        updateAddress: function (differences) {\n            for (let index = 0, length = differences.length;index < length;++index) {\n                let difference = differences[index];\n                switch (difference.type) {\n                    case 'street':\n                        this.form.find('input[name=\"street[]\"]').val('');\n                        for (\n                            let streetIndex = 0, streetLength = difference.rawValue.length;\n                            streetIndex < streetLength;\n                            ++streetIndex\n                        ) {\n                            $(this.form.find('input[name=\"street[]\"]')[streetIndex])\n                                .val(difference.rawValue[streetIndex])\n                                .trigger('change')\n                                .trigger('blur');\n                        }\n                        break;\n                    case 'city':\n                        this.form.find('input[name=\"city\"]')\n                            .val(difference.rawValue)\n                            .trigger('change')\n                            .trigger('blur');\n                        break;\n                    case 'region':\n                        this.form.find('select[name=\"region_id\"]')\n                            .val(difference.rawValue)\n                            .trigger('change')\n                            .trigger('blur');\n                        break;\n                    case 'postcode':\n                        this.form.find('input[name=\"postcode\"]')\n                            .val(difference.rawValue)\n                            .trigger('change')\n                            .trigger('blur');\n                        break;\n                    case 'country':\n                        this.form.find('select[name=\"country_id\"]')\n                            .val(difference.rawValue)\n                            .trigger('change')\n                            .trigger('blur');\n                        break;\n                }\n            }\n        },\n\n        /**\n         * Start loader\n         */\n        startLoader: function () {\n            $('body').trigger('processStart');\n        },\n\n        /**\n         * Stop loader\n         */\n        stopLoader: function () {\n            $('body').trigger('processStop');\n        }\n    };\n});\n","Vertex_AddressValidation/js/view/customer/address-validation.js":"/**\n * @copyright  Vertex. All rights reserved.  https://www.vertexinc.com/\n * @author     Mediotype                     https://www.mediotype.com/\n */\n\ndefine([\n    'jquery',\n    'ko',\n    'uiRegistry',\n    'uiComponent',\n    'Vertex_AddressValidation/js/validation-messages',\n    'Vertex_AddressValidation/js/action/address-validation-request',\n    'Vertex_AddressValidation/js/model/customer/address-resolver',\n    'Vertex_AddressValidation/js/view/validation-message',\n    'Vertex_AddressValidation/js/view/customer/address-form',\n    'Vertex_AddressValidation/js/model/difference-determiner',\n    'Vertex_AddressValidation/uiRegistry!addressValidationMessage'\n], function (\n    $,\n    ko,\n    registry,\n    Component,\n    validationMessages,\n    addressValidationRequest,\n    addressResolver,\n    message,\n    addressForm,\n    differenceDeterminer,\n    addressValidationMessage\n) {\n    'use strict';\n\n    var config = window.vertexAddressValidationConfig || {};\n\n    return Component.extend({\n        message: null,\n        formAddressData: null,\n        isAddressValid: false,\n        updateAddress: false,\n        addressResolver: addressResolver,\n        correctAddress: null,\n\n        initialize: function () {\n            this._super();\n\n            this.message = addressValidationMessage;\n            addressForm.formUpdated.extend({notify: 'always'}).subscribe(this.addressUpdated.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Reset validation after address update\n         */\n        addressUpdated: function () {\n            addressForm.renameSubmitButton(config.validateButtonText);\n            addressForm.hideSaveAsIsButton();\n            this.isAddressValid = false;\n            this.updateAddress = false;\n            this.message.clear();\n            this.message.showSuccessMessage = false;\n        },\n\n        /**\n         * Triggers a request to the address validation builder and adds the response\n         *\n         * @param {Object} formAddressData\n         * @returns {Object}\n         */\n        addressValidation: function (formAddressData) {\n            var deferred = $.Deferred();\n\n            if (this.isAddressValid || !this.validateCountry()) {\n                if (this.updateAddress) {\n                    this.updateVertexAddress();\n                }\n                return deferred.resolve();\n            }\n\n            this.formAddressData = formAddressData;\n            addressForm.startLoader();\n\n            addressValidationRequest(formAddressData)\n                .done(function (response) {\n                    this.isAddressValid = true;\n                    this.correctAddress = response;\n                    if (this.handleAddressDifferenceResponse(response) === true) {\n                        deferred.resolve();\n                    } else {\n                        addressForm.stopLoader();\n                    }\n                }.bind(this)).fail(function () {\n                deferred.reject();\n            }).fail(function () {\n                addressForm.stopLoader();\n            });\n\n            return deferred;\n        },\n\n        /**\n         * Check if country is used in validation\n         *\n         * @returns {boolean}\n         */\n        validateCountry: function () {\n            var countryCode = addressForm.getFieldByName('country_id').val();\n\n            return countryCode !== undefined\n                ? config.countryValidation.includes(countryCode)\n                : true;\n        },\n\n        /**\n         * Get the message with the differences\n         *\n         * @param {?CleanAddress} response\n         */\n        handleAddressDifferenceResponse: function (response) {\n            if (response === null || !Object.keys(response).length) {\n                addressForm.renameSubmitButton(config.saveAsIsButtonText);\n                this.message.setWarningMessage(validationMessages.noAddressFound);\n                return;\n            }\n\n            const differences = differenceDeterminer(this.formAddressData, response);\n\n            if (differences.length === 0 && config.showSuccessMessage) {\n                this.message.showSuccessMessage = true;\n                return true;\n            } else if (differences.length > 0) {\n                this.updateAddress = true;\n                addressForm.renameSubmitButton(config.updateButtonText);\n                addressForm.showSaveAsIsButton();\n                this.message.setWarningMessage(validationMessages.changesFound, differences, response);\n            } else {\n                return true;\n            }\n        },\n\n        /**\n         * Get the update message\n         */\n        updateVertexAddress: function () {\n            addressForm.updateAddress(differenceDeterminer(this.formAddressData, this.correctAddress));\n            this.message.setSuccessMessage(validationMessages.addressUpdated);\n\n            if (config.showSuccessMessage) {\n                this.message.showSuccessMessage = true;\n            }\n        }\n    });\n});\n","Plumrocket_Base/js/utils.js":"/**\n * @package     Plumrocket_Base\n * @copyright   Copyright (c) 2022 Plumrocket Inc. (https://plumrocket.com)\n * @license     https://plumrocket.com/license   End-user License Agreement\n */\n\ndefine([], function () {\n    'use strict';\n\n    var isMobile = null;\n\n    return {\n        /**\n         * Detect mobile devices\n         *\n         * @return {boolean}\n         */\n        isMobile: function () {\n            if (null === isMobile) {\n                isMobile = false;\n                (function (a) {\n                    if (/(android|bb\\d+|meego).+mobile|avantgo|bada\\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i.test(a)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\\-(n|u)|c55\\/|capi|ccwa|cdm\\-|cell|chtm|cldc|cmd\\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\\-s|devi|dica|dmob|do(c|p)o|ds(12|\\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\\-|_)|g1 u|g560|gene|gf\\-5|g\\-mo|go(\\.w|od)|gr(ad|un)|haie|hcit|hd\\-(m|p|t)|hei\\-|hi(pt|ta)|hp( i|ip)|hs\\-c|ht(c(\\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\\-(20|go|ma)|i230|iac( |\\-|\\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\\/)|klon|kpt |kwc\\-|kyo(c|k)|le(no|xi)|lg( g|\\/(k|l|u)|50|54|\\-[a-w])|libw|lynx|m1\\-w|m3ga|m50\\/|ma(te|ui|xo)|mc(01|21|ca)|m\\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\\-2|po(ck|rt|se)|prox|psio|pt\\-g|qa\\-a|qc(07|12|21|32|60|\\-[2-7]|i\\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\\-|oo|p\\-)|sdk\\/|se(c(\\-|0|1)|47|mc|nd|ri)|sgh\\-|shar|sie(\\-|m)|sk\\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\\-|v\\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\\-|tdg\\-|tel(i|m)|tim\\-|t\\-mo|to(pl|sh)|ts(70|m\\-|m3|m5)|tx\\-9|up(\\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\\-|your|zeto|zte\\-/i.test(a.substr(0,4))) {\n                        isMobile = true\n                    }\n                })(navigator.userAgent || navigator.vendor || window.opera);\n            }\n            return isMobile;\n        },\n\n        /**\n         * @param {string} pattern\n         * @param {[]}     phrases\n         * @return {string}\n         */\n        applyTextToTranslate: function (pattern, phrases) {\n            phrases.forEach(function (phrase, index) {\n                pattern = pattern.replace('%' + (index + 1), phrase);\n            });\n            return pattern;\n        },\n\n        /**\n         * Parse GET params\n         *\n         * @param name\n         * @param url\n         * @return {string}\n         */\n        getUrlParameter: function (name, url) {\n            name = name.replace(/[\\[]/, '\\\\[').replace(/[\\]]/, '\\\\]');\n            var regex = new RegExp('[\\\\?&]' + name + '=([^&#]*)');\n            var results = regex.exec(url ? url : location.search);\n            return results === null ? '' : decodeURIComponent(results[1].replace(/\\+/g, ' '));\n        },\n\n        /**\n         * Adds or updates a URL parameter.\n         *\n         * @param {string} url  the URL to modify\n         * @param {string} param  the name of the parameter\n         * @param {string} paramVal  the new value for the parameter\n         * @return {string} the updated URL\n         */\n        setParameter: function (url, param, paramVal) {\n            // http://stackoverflow.com/a/10997390/2391566\n            var parts = url.split('?');\n            var baseUrl = parts[0];\n            var oldQueryString = parts[1];\n            var newParameters = [];\n            if (oldQueryString) {\n                var oldParameters = oldQueryString.split('&');\n                for (var i = 0; i < oldParameters.length; i++) {\n                    if (oldParameters[i].split('=')[0] != param) {\n                        newParameters.push(oldParameters[i]);\n                    }\n                }\n            }\n            if (paramVal) {\n                newParameters.push(param + '=' + encodeURI(paramVal));\n            }\n            if (newParameters.length > 0) {\n                newParameters.sort(); // minify count of different url\n                return baseUrl + '?' + newParameters.join('&');\n            } else {\n                return baseUrl;\n            }\n        },\n\n        /**\n         * Add/update/remove param in url\n         *\n         * @param {string} paramName\n         * @param {string} value\n         * @return {exports}\n         */\n        updateUrlParam: function (paramName, value) {\n            if (window.history.replaceState) {\n                //prevents browser from storing history with each change:\n                var newUrl = this.setParameter(window.location.href, paramName, value);\n                window.history.replaceState('', '', newUrl);\n            }\n            return this;\n        },\n    };\n});\n","Magento_LoginAsCustomerAssistance/js/opt-in.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    return function (config, element) {\n        $(element).on('submit', function () {\n            this.elements['assistance_allowed'].value =\n                this.elements['assistance_allowed_checkbox'].checked ?\n                    config.allowAccess : config.denyAccess;\n        });\n    };\n});\n","Magento_OfflinePayments/js/view/payment/offline-payments.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\ndefine([\n    'uiComponent',\n    'Magento_Checkout/js/model/payment/renderer-list'\n], function (Component, rendererList) {\n    'use strict';\n\n    rendererList.push(\n        {\n            type: 'checkmo',\n            component: 'Magento_OfflinePayments/js/view/payment/method-renderer/checkmo-method'\n        },\n        {\n            type: 'banktransfer',\n            component: 'Magento_OfflinePayments/js/view/payment/method-renderer/banktransfer-method'\n        },\n        {\n            type: 'cashondelivery',\n            component: 'Magento_OfflinePayments/js/view/payment/method-renderer/cashondelivery-method'\n        },\n        {\n            type: 'purchaseorder',\n            component: 'Magento_OfflinePayments/js/view/payment/method-renderer/purchaseorder-method'\n        }\n    );\n\n    /** Add view logic here if needed */\n    return Component.extend({});\n});\n","Magento_OfflinePayments/js/view/payment/method-renderer/checkmo-method.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\ndefine([\n    'Magento_Checkout/js/view/payment/default'\n], function (Component) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_OfflinePayments/payment/checkmo'\n        },\n\n        /**\n         * Returns send check to info.\n         *\n         * @return {*}\n         */\n        getMailingAddress: function () {\n            return window.checkoutConfig.payment.checkmo.mailingAddress;\n        },\n\n        /**\n         * Returns payable to info.\n         *\n         * @return {*}\n         */\n        getPayableTo: function () {\n            return window.checkoutConfig.payment.checkmo.payableTo;\n        }\n    });\n});\n","Magento_OfflinePayments/js/view/payment/method-renderer/cashondelivery-method.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\ndefine([\n    'Magento_Checkout/js/view/payment/default'\n], function (Component) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_OfflinePayments/payment/cashondelivery'\n        },\n\n        /**\n         * Returns payment method instructions.\n         *\n         * @return {*}\n         */\n        getInstructions: function () {\n            return window.checkoutConfig.payment.instructions[this.item.method];\n        }\n    });\n});\n","Magento_OfflinePayments/js/view/payment/method-renderer/banktransfer-method.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\ndefine([\n    'ko',\n    'Magento_Checkout/js/view/payment/default'\n], function (ko, Component) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_OfflinePayments/payment/banktransfer'\n        },\n\n        /**\n         * Get value of instruction field.\n         * @returns {String}\n         */\n        getInstructions: function () {\n            return window.checkoutConfig.payment.instructions[this.item.method];\n        }\n    });\n});\n","Magento_OfflinePayments/js/view/payment/method-renderer/purchaseorder-method.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\ndefine([\n    'Magento_Checkout/js/view/payment/default',\n    'jquery',\n    'mage/validation'\n], function (Component, $) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_OfflinePayments/payment/purchaseorder-form',\n            purchaseOrderNumber: ''\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super()\n                .observe('purchaseOrderNumber');\n\n            return this;\n        },\n\n        /**\n         * @return {Object}\n         */\n        getData: function () {\n            return {\n                method: this.item.method,\n                'po_number': this.purchaseOrderNumber(),\n                'additional_data': null\n            };\n        },\n\n        /**\n         * @return {jQuery}\n         */\n        validate: function () {\n            var form = 'form[data-role=purchaseorder-form]';\n\n            return $(form).validation() && $(form).validation('isValid');\n        }\n    });\n});\n","Magento_Msrp/js/msrp.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_Catalog/js/price-utils',\n    'underscore',\n    'jquery-ui-modules/widget',\n    'mage/dropdown',\n    'mage/template'\n], function ($, priceUtils, _) {\n    'use strict';\n\n    $.widget('mage.addToCart', {\n        options: {\n            showAddToCart: true,\n            submitUrl: '',\n            cartButtonId: '',\n            singleOpenDropDown: true,\n            dialog: {}, // Options for mage/dropdown\n            dialogDelay: 500, // Delay in ms after resize dropdown shown again\n            origin: '', //Required, type of popup: 'msrp', 'tier' or 'info' popup\n\n            // Selectors\n            cartForm: '.form.map.checkout',\n            msrpLabelId: '#map-popup-msrp',\n            msrpPriceElement: '#map-popup-msrp .price-wrapper',\n            priceLabelId: '#map-popup-price',\n            priceElement: '#map-popup-price .price',\n            mapInfoLinks: '.map-show-info',\n            displayPriceElement: '.old-price.map-old-price .price-wrapper',\n            fallbackPriceElement: '.normal-price.map-fallback-price .price-wrapper',\n            displayPriceContainer: '.old-price.map-old-price',\n            fallbackPriceContainer: '.normal-price.map-fallback-price',\n            popUpAttr: '[data-role=msrp-popup-template]',\n            popupCartButtonId: '#map-popup-button',\n            paypalCheckoutButons: '[data-action=checkout-form-submit]',\n            popupId: '',\n            realPrice: '',\n            isSaleable: '',\n            msrpPrice: '',\n            helpLinkId: '',\n            addToCartButton: '',\n\n            // Text options\n            productName: '',\n            addToCartUrl: ''\n        },\n\n        openDropDown: null,\n        triggerClass: 'dropdown-active',\n\n        popUpOptions: {\n            appendTo: 'body',\n            dialogContentClass: 'active',\n            closeOnMouseLeave: false,\n            autoPosition: true,\n            closeOnClickOutside: false,\n            'dialogClass': 'popup map-popup-wrapper',\n            position: {\n                my: 'left top',\n                collision: 'fit none',\n                at: 'left bottom',\n                within: 'body'\n            },\n            shadowHinter: 'popup popup-pointer'\n        },\n        popupOpened: false,\n        wasOpened: false,\n\n        /**\n         * Creates widget instance\n         *\n         * @private\n         */\n        _create: function () {\n            if (this.options.origin === 'msrp') {\n                this.initMsrpPopup();\n            } else if (this.options.origin === 'info') {\n                this.initInfoPopup();\n            } else if (this.options.origin === 'tier') {\n                this.initTierPopup();\n            }\n            $(this.options.cartButtonId).on('click', this._addToCartSubmit.bind(this));\n            $(document).on('updateMsrpPriceBlock', this.onUpdateMsrpPrice.bind(this));\n            $(this.options.cartForm).on('submit', this._onSubmitForm.bind(this));\n        },\n\n        /**\n         * Init msrp popup\n         *\n         * @private\n         */\n        initMsrpPopup: function () {\n            var popupDOM = $(this.options.popUpAttr)[0],\n                $msrpPopup = $(popupDOM.innerHTML.trim());\n\n            $msrpPopup.find(this.options.productIdInput).val(this.options.productId);\n            $('body').append($msrpPopup);\n            $msrpPopup.trigger('contentUpdated');\n\n            $msrpPopup.find('button')\n                .on('click',\n                    this.handleMsrpAddToCart.bind(this))\n                .filter(this.options.popupCartButtonId)\n                .text($(this.options.addToCartButton).text());\n\n            $msrpPopup.find(this.options.paypalCheckoutButons).on('click',\n                this.handleMsrpPaypalCheckout.bind(this));\n\n            $(this.options.popupId).on('click',\n                this.openPopup.bind(this));\n\n            this.$popup = $msrpPopup;\n        },\n\n        /**\n         * Init info popup\n         *\n         * @private\n         */\n        initInfoPopup: function () {\n            var infoPopupDOM = $('[data-role=msrp-info-template]')[0],\n                $infoPopup = $(infoPopupDOM.innerHTML.trim());\n\n            $('body').append($infoPopup);\n\n            $(this.options.helpLinkId).on('click', function (e) {\n                this.popUpOptions.position.of = $(e.target);\n                $infoPopup.dropdownDialog(this.popUpOptions).dropdownDialog('open');\n                this._toggle($infoPopup);\n            }.bind(this));\n\n            this.$popup = $infoPopup;\n        },\n\n        /**\n         * Init tier price popup\n         * @private\n         */\n        initTierPopup: function () {\n            var popupDOM = $(this.options.popUpAttr)[0],\n                $tierPopup = $(popupDOM.innerHTML.trim());\n\n            $('body').append($tierPopup);\n            $tierPopup.find(this.options.productIdInput).val(this.options.productId);\n            this.popUpOptions.position.of = $(this.options.helpLinkId);\n\n            $tierPopup.find('button').on('click',\n                this.handleTierAddToCart.bind(this))\n                .filter(this.options.popupCartButtonId)\n                .text($(this.options.addToCartButton).text());\n\n            $tierPopup.find(this.options.paypalCheckoutButons).on('click',\n                this.handleTierPaypalCheckout.bind(this));\n\n            $(this.options.attr).on('click', function (e) {\n                this.$popup = $tierPopup;\n                this.tierOptions = $(e.target).data('tier-price');\n                this.openPopup(e);\n            }.bind(this));\n        },\n\n        /**\n         * handle 'AddToCart' click on Msrp popup\n         * @param {Object} ev\n         *\n         * @private\n         */\n        handleMsrpAddToCart: function (ev) {\n            ev.preventDefault();\n\n            if (this.options.addToCartButton) {\n                $(this.options.addToCartButton).click();\n                this.closePopup(this.$popup);\n            }\n        },\n\n        /**\n         * handle 'paypal checkout buttons' click on Msrp popup\n         *\n         * @private\n         */\n        handleMsrpPaypalCheckout: function () {\n            this.closePopup(this.$popup);\n        },\n\n        /**\n         * handle 'AddToCart' click on Tier popup\n         *\n         * @param {Object} ev\n         * @private\n         */\n        handleTierAddToCart: function (ev) {\n            ev.preventDefault();\n\n            if (this.options.addToCartButton &&\n                this.options.inputQty && !isNaN(this.tierOptions.qty)\n            ) {\n                $(this.options.inputQty).val(this.tierOptions.qty);\n                $(this.options.addToCartButton).click();\n                this.closePopup(this.$popup);\n            }\n        },\n\n        /**\n         * handle 'paypal checkout buttons' click on Tier popup\n         *\n         * @private\n         */\n        handleTierPaypalCheckout: function () {\n            if (this.options.inputQty && !isNaN(this.tierOptions.qty)\n            ) {\n                $(this.options.inputQty).val(this.tierOptions.qty);\n                this.closePopup(this.$popup);\n            }\n        },\n\n        /**\n         * Open and set up popup\n         *\n         * @param {Object} event\n         */\n        openPopup: function (event) {\n            var options = this.tierOptions || this.options;\n\n            this.popUpOptions.position.of = $(event.target);\n\n            if (!this.wasOpened) {\n                this.$popup.find(this.options.msrpLabelId).html(options.msrpPrice);\n                this.$popup.find(this.options.priceLabelId).html(options.realPrice);\n                this.wasOpened = true;\n            }\n            this.$popup.dropdownDialog(this.popUpOptions).dropdownDialog('open');\n            this._toggle(this.$popup);\n\n            if (!this.options.isSaleable) {\n                this.$popup.find('form').hide();\n            }\n        },\n\n        /**\n         * Toggle MAP popup visibility\n         *\n         * @param {HTMLElement} $elem\n         * @private\n         */\n        _toggle: function ($elem) {\n            $(document).on('mouseup.msrp touchend.msrp', function (e) {\n                if (!$elem.is(e.target) && $elem.has(e.target).length === 0) {\n                    this.closePopup($elem);\n                }\n            }.bind(this));\n            $(window).on('resize', function () {\n                this.closePopup($elem);\n            }.bind(this));\n        },\n\n        /**\n         * Close MAP information popup\n         *\n         * @param {HTMLElement} $elem\n         */\n        closePopup: function ($elem) {\n            $elem.dropdownDialog('close');\n            $(document).off('mouseup.msrp touchend.msrp');\n        },\n\n        /**\n         * Handler for addToCart action\n         *\n         * @param {Object} e\n         */\n        _addToCartSubmit: function (e) {\n            this.element.trigger('addToCart', this.element);\n\n            if (this.element.data('stop-processing')) {\n                return false;\n            }\n\n            if (this.options.addToCartButton) {\n                $(this.options.addToCartButton).click();\n\n                return false;\n            }\n\n            if (this.options.addToCartUrl) {\n                $('.mage-dropdown-dialog > .ui-dialog-content').dropdownDialog('close');\n            }\n\n            e.preventDefault();\n            $(this.options.cartForm).trigger('submit');\n        },\n\n        /**\n         * Call on event updatePrice. Proxy to updateMsrpPrice method.\n         *\n         * @param {Event} event\n         * @param {mixed} priceIndex\n         * @param {Object} prices\n         * @param {Object|undefined} $priceBox\n         */\n        onUpdateMsrpPrice: function onUpdateMsrpPrice(event, priceIndex, prices, $priceBox) {\n\n            var defaultMsrp,\n                defaultPrice,\n                msrpPrice,\n                finalPrice;\n\n            defaultMsrp = _.chain(prices).map(function (price) {\n                return price.msrpPrice.amount;\n            }).reject(function (p) {\n                return p === null;\n            }).max().value();\n\n            defaultPrice = _.chain(prices).map(function (p) {\n                return p.finalPrice.amount;\n            }).min().value();\n\n            if (typeof priceIndex !== 'undefined') {\n                msrpPrice = prices[priceIndex].msrpPrice.amount;\n                finalPrice = prices[priceIndex].finalPrice.amount;\n\n                if (msrpPrice === null || msrpPrice <= finalPrice) {\n                    this.updateNonMsrpPrice(priceUtils.formatPrice(finalPrice), $priceBox);\n                } else {\n                    this.updateMsrpPrice(\n                        priceUtils.formatPrice(finalPrice),\n                        priceUtils.formatPrice(msrpPrice),\n                        false,\n                        $priceBox);\n                }\n            } else {\n                this.updateMsrpPrice(\n                    priceUtils.formatPrice(defaultPrice),\n                    priceUtils.formatPrice(defaultMsrp),\n                    true,\n                    $priceBox);\n            }\n        },\n\n        /**\n         * Update prices for configurable product with MSRP enabled\n         *\n         * @param {String} finalPrice\n         * @param {String} msrpPrice\n         * @param {Boolean} useDefaultPrice\n         * @param {Object|undefined} $priceBox\n         */\n        updateMsrpPrice: function (finalPrice, msrpPrice, useDefaultPrice, $priceBox) {\n            var options = this.tierOptions || this.options;\n\n            $(this.options.fallbackPriceContainer, $priceBox).hide();\n            $(this.options.displayPriceContainer, $priceBox).show();\n            $(this.options.mapInfoLinks, $priceBox).show();\n\n            if (useDefaultPrice || !this.wasOpened) {\n                if (this.$popup) {\n                    this.$popup.find(this.options.msrpLabelId).html(options.msrpPrice);\n                    this.$popup.find(this.options.priceLabelId).html(options.realPrice);\n                }\n\n                $(this.options.displayPriceElement, $priceBox).html(msrpPrice);\n                this.wasOpened = true;\n            }\n\n            if (!useDefaultPrice) {\n                this.$popup.find(this.options.msrpPriceElement).html(msrpPrice);\n                this.$popup.find(this.options.priceElement).html(finalPrice);\n                $(this.options.displayPriceElement, $priceBox).html(msrpPrice);\n            }\n        },\n\n        /**\n         * Display non MAP price for irrelevant products\n         *\n         * @param {String} price\n         * @param {Object|undefined} $priceBox\n         */\n        updateNonMsrpPrice: function (price, $priceBox) {\n            $(this.options.fallbackPriceElement, $priceBox).html(price);\n            $(this.options.displayPriceContainer, $priceBox).hide();\n            $(this.options.mapInfoLinks, $priceBox).hide();\n            $(this.options.fallbackPriceContainer, $priceBox).show();\n        },\n\n        /**\n         * Handler for submit form\n         *\n         * @private\n         */\n        _onSubmitForm: function () {\n            if ($(this.options.cartForm).valid()) {\n                $(this.options.cartButtonId).prop('disabled', true);\n            }\n        }\n\n    });\n\n    return $.mage.addToCart;\n});\n","Magento_Msrp/js/product/list/columns/msrp-price.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_Catalog/js/product/list/columns/price-box',\n    'Magento_Catalog/js/product/addtocart-button',\n    'mage/dropdown'\n], function ($, _, PriceBox) {\n    'use strict';\n\n    return PriceBox.extend({\n        defaults: {\n            priceBoxSelector: '[data-role=msrp-price-box]',\n            popupTmpl: 'Magento_Msrp/product/item/popup',\n            popupTriggerSelector: '[data-role=msrp-popup-trigger]',\n            popupSelector: '[data-role=msrp-popup]',\n            popupOptions: {\n                appendTo: 'body',\n                dialogContentClass: 'active',\n                closeOnMouseLeave: false,\n                autoPosition: true,\n                dialogClass: 'popup map-popup-wrapper',\n                position: {\n                    my: 'left top',\n                    collision: 'fit none',\n                    at: 'left bottom',\n                    within: 'body'\n                },\n                shadowHinter: 'popup popup-pointer'\n            }\n        },\n\n        /**\n         * Create and open popup with Msrp information.\n         *\n         * @param {Object} data - element data\n         * @param {DOMElement} elem - element\n         * @param {Event} event - event object\n         */\n        openPopup: function (data, elem, event) {\n            var $elem = $(elem),\n                $popup = $elem.find(this.popupSelector),\n                $trigger = $elem.find(this.popupTriggerSelector);\n\n            event.stopPropagation();\n\n            this.popupOptions.position.of = $trigger;\n            this.popupOptions.triggerTarget = $trigger;\n\n            $popup.dropdownDialog(this.popupOptions)\n                  .dropdownDialog('open');\n        },\n\n        /**\n         * Set listeners.\n         *\n         * @param {DOMElement} elem - DOM element\n         * @param {Object} data - element data\n         */\n        initListeners: function (elem, data) {\n            var $trigger = $(elem).find(this.popupTriggerSelector);\n\n            $trigger.on('click', this.openPopup.bind(this, data, elem));\n        },\n\n        /**\n         * Check whether we can apply msrp, or should use standard price.\n         *\n         * @param {Object} row\n         * @returns {Bool}\n         */\n        isMsrpApplicable: function (row) {\n            return this.getPrice(row)['is_applicable'];\n        },\n\n        /**\n         * Retrieve msrp formatted price\n         *\n         * @param {Object} row\n         * @returns {String}\n         */\n        getPrice: function (row) {\n            return row['price_info']['extension_attributes'].msrp;\n        },\n\n        /**\n         * Returns path to the columns' body template.\n         *\n         * @returns {String}\n         */\n        getBody: function () {\n            return this.bodyTmpl;\n        },\n\n        /**\n         * Check if popup with actual price must be shown.\n         *\n         * @returns {Boolean}\n         */\n        isShowPriceOnGesture: function (row) {\n            return this.getPrice(row)['is_shown_price_on_gesture'];\n        },\n\n        /**\n         * Get msrp price supporting text.\n         *\n         * @returns {String}\n         */\n        getMsrpPriceMessage: function (row) {\n            return this.getPrice(row)['msrp_message'];\n        },\n\n        /**\n         * Get msrp price supporting text, when actual price is hidden.\n         *\n         * @returns {String}\n         */\n        getExplanationMessage: function (row) {\n            return this.getPrice(row)['explanation_message'];\n        }\n    });\n});\n","Magento_Msrp/js/view/checkout/minicart/subtotal/totals.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'Magento_Tax/js/view/checkout/minicart/subtotal/totals',\n    'underscore'\n], function (Component, _) {\n    'use strict';\n\n    return Component.extend({\n\n        /**\n         * @override\n         */\n        initialize: function () {\n            this._super();\n            this.displaySubtotal(this.isMsrpApplied(this.cart().items));\n            this.cart.subscribe(function (updatedCart) {\n\n                this.displaySubtotal(this.isMsrpApplied(updatedCart.items));\n            }, this);\n        },\n\n        /**\n         * Determine if subtotal should be hidden.\n         * @param {Array} cartItems\n         * @return {Boolean}\n         */\n        isMsrpApplied: function (cartItems) {\n            return !_.find(cartItems, function (item) {\n                if (_.has(item, 'canApplyMsrp')) {\n                    return item.canApplyMsrp;\n                }\n\n                return false;\n            });\n        }\n    });\n});\n","magnifier/magnify.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'magnifier/magnifier'\n], function ($, _) {\n    'use strict';\n\n    return function (config, element) {\n\n        var isTouchEnabled = 'ontouchstart' in document.documentElement,\n            gallerySelector = '[data-gallery-role=\"gallery\"]',\n            magnifierSelector = '[data-gallery-role=\"magnifier\"]',\n            magnifierZoomSelector = '[data-gallery-role=\"magnifier-zoom\"]',\n            zoomInButtonSelector = '[data-gallery-role=\"fotorama__zoom-in\"]',\n            zoomOutButtonSelector = '[data-gallery-role=\"fotorama__zoom-out\"]',\n            fullscreenImageSelector = '[data-gallery-role=\"stage-shaft\"] [data-active=\"true\"] .fotorama__img--full',\n            imageDraggableClass = 'fotorama__img--draggable',\n            imageZoommable = 'fotorama__img--zoommable',\n            zoomInLoaded = 'zoom-in-loaded',\n            zoomOutLoaded = 'zoom-out-loaded',\n            zoomInDisabled = 'fotorama__zoom-in--disabled',\n            zoomOutDisabled = 'fotorama__zoom-out--disabled',\n            keyboardNavigation,\n            videoContainerClass = 'fotorama-video-container',\n            hideMagnifier,\n            dragFlag,\n            endX,\n            transitionEnabled,\n            transitionActive = false,\n            tapFlag = 0,\n            allowZoomOut = false,\n            allowZoomIn = true;\n\n        transitionEnabled = document.documentElement.style.transition !== undefined ||\n            document.documentElement.style.WebkitTransition !== undefined ||\n            document.documentElement.style.MozTransition !== undefined ||\n            document.documentElement.style.MsTransition !== undefined ||\n            document.documentElement.style.OTransition !== undefined;\n\n        /**\n         * Return width and height of original image\n         * @param img original image node\n         * @returns {{rw: number, rh: number}}\n         */\n        function getImageSize(img) {\n            return {\n                rw: img.naturalWidth,\n                rh: img.naturalHeight\n            };\n        }\n\n        /**\n         * Sets min-height and min-width for image to avoid transition bug\n         * @param $image - fullscreen image\n         */\n        function calculateMinSize($image) {\n\n            var minHeight,\n                minWidth,\n                height = $image.height(),\n                width = $image.width(),\n                parentHeight = $image.parent().height(),\n                parentWidth = $image.parent().width();\n\n            if (width > parentWidth || height > parentHeight) {\n\n                if (width / height < parentWidth / parentHeight) {\n                    minHeight = parentHeight;\n                    minWidth = width * (parentHeight / height);\n                } else {\n                    minWidth = parentWidth;\n                    minHeight = height * parentWidth / width;\n                }\n                $image.css({\n                    'min-width': minWidth,\n                    'min-height': minHeight\n                });\n            }\n        }\n\n        function toggleZoomable($image, flag) {\n            if (flag) {\n                $image.css({\n                    'min-width': $image.width(),\n                    'min-height': $image.height(),\n                    'width': $image.width(),\n                    'height': $image.height()\n                }).addClass(imageZoommable);\n            } else {\n                $image.css({\n                    width: '',\n                    height: '',\n                    top: '',\n                    left: '',\n                    right: '',\n                    bottom: ''\n                }).removeClass(imageZoommable);\n                calculateMinSize($image);\n            }\n        }\n\n        function resetVars($image) {\n            allowZoomIn = true;\n            allowZoomOut = dragFlag = transitionActive = false;\n            $image.hasClass(imageDraggableClass) && $image.removeClass(imageDraggableClass);\n            toggleZoomable($image, false);\n        }\n\n        /**\n         * Set state for zoom controls.\n         * If state is true, zoom controls will be visible.\n         * IF state is false, zoom controls will be hidden.\n         * @param isHide\n         */\n        function hideZoomControls(isHide) {\n            if (isHide) {\n                $(zoomInButtonSelector).addClass(zoomInDisabled);\n                $(zoomOutButtonSelector).addClass(zoomOutDisabled);\n            } else {\n                $(zoomInButtonSelector).removeClass(zoomInDisabled);\n                $(zoomOutButtonSelector).removeClass(zoomOutDisabled);\n            }\n        }\n\n        /**\n         * Asynchronus control visibility of zoom buttons.\n         * If image bigger than her wrapper. Zoom controls must visible.\n         * @param path - image source path\n         * @param $image\n         */\n        function asyncToggleZoomButtons(path, $image) {\n            var img = new Image();\n\n            img.onload = function () {\n                this.height > $image.parent().height() || this.width > $image.parent().width() ?\n                    hideZoomControls(false) : hideZoomControls(true);\n            };\n            img.src = path;\n        }\n\n        /**\n         * Control visibility of zoom buttons.\n         * Zoom controls must be invisible for video content and touch devices.\n         * On touch devices active pinchIn/pinchOut.\n         * @param $image\n         * @param isTouchScreen - true for touch devices\n         * @param isVideoActiveFrame - true for active video frame\n         */\n        function toggleZoomButtons($image, isTouchScreen, isVideoActiveFrame) {\n            var path = $image.attr('src');\n\n            if (path && !isTouchScreen && !isVideoActiveFrame) {\n                asyncToggleZoomButtons(path, $image);\n            } else {\n                hideZoomControls(true);\n            }\n        }\n\n        /**\n         * Handle resize event in fullscreen.\n         * @param $image - Fullscreen image.\n         * @param e - Event.\n         */\n        function resizeHandler(e, $image) {\n            var imageSize,\n                parentWidth,\n                parentHeight,\n                isImageSmall,\n                isImageFit;\n\n            if (!e.data.$image || !e.data.$image.length)\n                return;\n\n            imageSize = getImageSize($(fullscreenImageSelector)[0]);\n            parentWidth = e.data.$image.parent().width();\n            parentHeight = e.data.$image.parent().height();\n            isImageSmall = parentWidth >= imageSize.rw && parentHeight >= imageSize.rh;\n            isImageFit = parentWidth > e.data.$image.width() && parentHeight > e.data.$image.height();\n\n            toggleZoomButtons(e.data.$image, isTouchEnabled, checkForVideo(e.data.fotorama.activeFrame.$stageFrame));\n            calculateMinSize(e.data.$image);\n\n            if (e.data.$image.hasClass(imageZoommable) && !allowZoomOut || isImageSmall || isImageFit) {\n                resetVars(e.data.$image);\n            }\n\n            if (!isImageSmall) {\n                toggleStandartNavigation();\n            }\n        }\n\n        function getTopValue($image, topProp, step, height, containerHeight) {\n            var top;\n\n            if (parseInt($image.css('marginTop')) || parseInt($image.css('marginLeft'))) {\n                top = dragFlag ? topProp - step / 4 : 0;\n                top = top < containerHeight - height ? containerHeight - height : top;\n                top = top > height - containerHeight ? height - containerHeight : top;\n            } else {\n                top = topProp + step / 2;\n                top = top < containerHeight - height ? containerHeight - height : top;\n                top = top > 0 ? 0 : top;\n\n                if (!dragFlag && step < 0) {\n                    top = top < (containerHeight - height) / 2 ? (containerHeight - height) / 2 : top;\n                }\n            }\n\n            return top;\n        }\n\n        function getLeftValue(leftProp, step, width, containerWidth) {\n            var left;\n\n            left = leftProp + step / 2;\n            left = left < containerWidth - width ? containerWidth - width : left;\n            left = left > 0 ? 0 : left;\n\n            if (!dragFlag && step < 0) {\n                left = left < (containerWidth - width) / 2 ? (containerWidth - width) / 2 : left;\n            }\n\n            return left;\n        }\n\n        function checkFullscreenImagePosition($image, dimentions, widthStep, heightStep) {\n            var $imageContainer,\n                containerWidth,\n                containerHeight,\n                settings,\n                top,\n                left,\n                right,\n                bottom,\n                ratio;\n\n            if ($(gallerySelector).data('fotorama').fullScreen) {\n                transitionActive = true;\n                $imageContainer = $image.parent();\n                containerWidth = $imageContainer.width();\n                containerHeight = $imageContainer.height();\n                top = $image.position().top;\n                left = $image.position().left;\n                ratio = $image.width() / $image.height();\n                dimentions.height = isNaN(dimentions.height) ? dimentions.width / ratio : dimentions.height;\n                dimentions.width = isNaN(dimentions.width) ? dimentions.height * ratio : dimentions.width;\n\n                top = dimentions.height >= containerHeight ?\n                    getTopValue($image, top, heightStep, dimentions.height, containerHeight) : 0;\n\n                left = dimentions.width >= containerWidth ?\n                    getLeftValue(left, widthStep, dimentions.width, containerWidth) : 0;\n\n                right = dragFlag && left < (containerWidth - dimentions.width) / 2 ? 0 : left;\n                bottom = dragFlag ? 0 : top;\n\n                settings = $.extend(dimentions, {\n                    top: top,\n                    left: left,\n                    right: right\n                });\n\n                $image.css(settings);\n            }\n        }\n\n        /**\n         * Toggles fotorama's keyboard and mouse/touch navigation.\n         */\n        function toggleStandartNavigation() {\n            var $selectable =\n                    $('a[href], area[href], input, select, textarea, button, iframe, object, embed, *[tabindex], *[contenteditable]')\n                    .not('[tabindex=-1], [disabled], :hidden'),\n                fotorama = $(gallerySelector).data('fotorama'),\n                $focus = $(':focus'),\n                index;\n\n            if (fotorama.fullScreen) {\n\n                $selectable.each(function (number) {\n\n                    if ($(this).is($focus)) {\n                        index = number;\n                    }\n                });\n\n                fotorama.setOptions({\n                    swipe: !allowZoomOut,\n                    keyboard: !allowZoomOut\n                });\n\n                if (_.isNumber(index)) {\n                    $selectable.eq(index).focus();\n                }\n            }\n        }\n\n        function zoomIn(e, xStep, yStep) {\n            var $image,\n                imgOriginalSize,\n                imageWidth,\n                imageHeight,\n                zoomWidthStep,\n                zoomHeightStep,\n                widthResult,\n                heightResult,\n                ratio,\n                dimentions = {};\n\n            if (allowZoomIn && (!transitionEnabled || !transitionActive) && (isTouchEnabled ||\n                !$(zoomInButtonSelector).hasClass(zoomInDisabled))) {\n                $image = $(fullscreenImageSelector);\n                imgOriginalSize = getImageSize($image[0]);\n                imageWidth = $image.width();\n                imageHeight = $image.height();\n                ratio = imageWidth / imageHeight;\n                allowZoomOut = true;\n                toggleStandartNavigation();\n\n                if (!$image.hasClass(imageZoommable)) {\n                    toggleZoomable($image, true);\n                }\n\n                e.preventDefault();\n\n                if (imageWidth >= imageHeight) {\n                    zoomWidthStep = xStep || Math.ceil(imageWidth * parseFloat(config.magnifierOpts.fullscreenzoom) / 100);\n                    widthResult = imageWidth + zoomWidthStep;\n\n                    if (widthResult >= imgOriginalSize.rw) {\n                        widthResult = imgOriginalSize.rw;\n                        zoomWidthStep = xStep || widthResult - imageWidth;\n                        allowZoomIn = false;\n                    }\n                    heightResult = widthResult / ratio;\n                    zoomHeightStep = yStep || heightResult - imageHeight;\n                } else {\n                    zoomHeightStep = yStep || Math.ceil(imageHeight * parseFloat(config.magnifierOpts.fullscreenzoom) / 100);\n                    heightResult = imageHeight + zoomHeightStep;\n\n                    if (heightResult >= imgOriginalSize.rh) {\n                        heightResult = imgOriginalSize.rh;\n                        zoomHeightStep = yStep || heightResult - imageHeight;\n                        allowZoomIn = false;\n                    }\n                    widthResult = heightResult * ratio;\n                    zoomWidthStep = xStep || widthResult - imageWidth;\n                }\n\n                if (imageWidth >= imageHeight && imageWidth !== imgOriginalSize.rw) {\n                    dimentions = $.extend(dimentions, {\n                        width: widthResult,\n                        height: 'auto'\n                    });\n                    checkFullscreenImagePosition($image, dimentions, -zoomWidthStep, -zoomHeightStep);\n\n                } else if (imageWidth < imageHeight && imageHeight !== imgOriginalSize.rh) {\n                    dimentions = $.extend(dimentions, {\n                        width: 'auto',\n                        height: heightResult\n                    });\n                    checkFullscreenImagePosition($image, dimentions, -zoomWidthStep, -zoomHeightStep);\n                }\n            }\n\n            return false;\n        }\n\n        function zoomOut(e, xStep, yStep) {\n            var $image,\n                widthResult,\n                heightResult,\n                dimentions,\n                parentWidth,\n                parentHeight,\n                imageWidth,\n                imageHeight,\n                zoomWidthStep,\n                zoomHeightStep,\n                ratio,\n                fitIntoParent;\n\n            if (allowZoomOut && (!transitionEnabled || !transitionActive) && (isTouchEnabled ||\n                !$(zoomOutButtonSelector).hasClass(zoomOutDisabled))) {\n                allowZoomIn = true;\n                $image = $(fullscreenImageSelector);\n                parentWidth = $image.parent().width();\n                parentHeight = $image.parent().height();\n                imageWidth = $image.width();\n                imageHeight = $image.height();\n                ratio = imageWidth / imageHeight;\n\n                e.preventDefault();\n\n                if (imageWidth >= imageHeight) {\n                    zoomWidthStep = xStep || Math.ceil(imageWidth * parseFloat(config.magnifierOpts.fullscreenzoom) / 100);\n                    widthResult = imageWidth - zoomWidthStep;\n                    heightResult = widthResult / ratio;\n                    zoomHeightStep = yStep || imageHeight - heightResult;\n                } else {\n                    zoomHeightStep = yStep || Math.ceil(imageHeight * parseFloat(config.magnifierOpts.fullscreenzoom) / 100);\n                    heightResult = imageHeight - zoomHeightStep;\n                    widthResult = heightResult * ratio;\n                    zoomWidthStep = xStep || imageWidth - widthResult;\n                }\n\n                fitIntoParent = function () {\n                    if (ratio > parentWidth / parentHeight) {\n                        widthResult = parentWidth;\n                        zoomWidthStep = imageWidth - widthResult;\n                        heightResult = widthResult / ratio;\n                        zoomHeightStep = imageHeight - heightResult;\n                        dimentions = {\n                            width: widthResult,\n                            height: 'auto'\n                        };\n                    } else {\n                        heightResult = parentHeight;\n                        zoomHeightStep = imageHeight - heightResult;\n                        widthResult = heightResult * ratio;\n                        zoomWidthStep = imageWidth - widthResult;\n                        dimentions = {\n                            width: 'auto',\n                            height: heightResult\n                        };\n                    }\n                    checkFullscreenImagePosition($image, dimentions, zoomWidthStep, zoomHeightStep);\n                };\n\n                if (imageWidth >= imageHeight) {\n                    if (widthResult > parentWidth) {\n                        dimentions = {\n                            width: widthResult,\n                            height: 'auto'\n                        };\n                        checkFullscreenImagePosition($image, dimentions, zoomWidthStep, zoomHeightStep);\n                    } else if (heightResult > parentHeight) {\n                        dimentions = {\n                            width: widthResult,\n                            height: 'auto'\n                        };\n                        checkFullscreenImagePosition($image, dimentions, zoomWidthStep, zoomHeightStep);\n                    } else {\n                        allowZoomOut = dragFlag = false;\n                        toggleStandartNavigation();\n                        fitIntoParent();\n                    }\n                } else if (heightResult > parentHeight) {\n                    dimentions = {\n                        width: 'auto',\n                        height: heightResult\n                    };\n                    checkFullscreenImagePosition($image, dimentions, zoomWidthStep, zoomHeightStep);\n                } else if (widthResult > parentWidth) {\n                    dimentions = {\n                        width: 'auto',\n                        height: heightResult\n                    };\n                    checkFullscreenImagePosition($image, dimentions, zoomWidthStep, zoomHeightStep);\n                } else {\n                    allowZoomOut = dragFlag = false;\n                    toggleStandartNavigation();\n                    fitIntoParent();\n                }\n            }\n\n            return false;\n        }\n\n        /**\n         * Bind event on scroll on active item in fotorama\n         * @param e\n         * @param fotorama - object of fotorama\n         */\n        function mousewheel(e, fotorama, element) {\n            var $fotoramaStage = fotorama.activeFrame.$stageFrame,\n                fotoramaStage = $fotoramaStage.get(0);\n\n            function onWheel(e) {\n                var delta = e.deltaY || e.wheelDelta,\n                    ev = e || window.event;\n\n                if ($(gallerySelector).data('fotorama').fullScreen) {\n\n                    if (e.deltaY) {\n                        if (delta > 0) {\n                            zoomOut(ev);\n                        } else {\n                            zoomIn(ev);\n                        }\n                    } else if (delta > 0) {\n                        zoomIn(ev);\n                    } else {\n                        zoomOut(ev);\n                    }\n\n                    e.preventDefault ? e.preventDefault() : e.returnValue = false;\n                }\n            }\n\n            if (!$fotoramaStage.hasClass('magnify-wheel-loaded')) {\n                if (fotoramaStage && fotoramaStage.addEventListener) {\n                    if ('onwheel' in document) {\n                        fotoramaStage.addEventListener('wheel', onWheel);\n                    } else if ('onmousewheel' in document) {\n                        fotoramaStage.addEventListener('mousewheel', onWheel);\n                    } else {\n                        fotoramaStage.addEventListener('MozMousePixelScroll', onWheel);\n                    }\n                    $fotoramaStage.addClass('magnify-wheel-loaded');\n                }\n            }\n        }\n\n        /**\n         * Method which makes draggable picture. Also work on touch devices.\n         */\n        function magnifierFullscreen(fotorama) {\n            var isDragActive = false,\n                startX,\n                startY,\n                imagePosX,\n                imagePosY,\n                touch,\n                swipeSlide,\n                $gallery = $(gallerySelector),\n                $image = $(fullscreenImageSelector, $gallery),\n                $imageContainer = $('[data-gallery-role=\"stage-shaft\"] [data-active=\"true\"]'),\n                gallery = $gallery.data('fotorama'),\n                pinchDimention;\n\n            swipeSlide = _.throttle(function (direction) {\n                $(gallerySelector).data('fotorama').show(direction);\n            }, 500, {\n                trailing: false\n            });\n\n            /**\n             * Returns top position value for passed jQuery object.\n             *\n             * @param $el\n             * @return {number}\n             */\n            function getTop($el) {\n                return parseInt($el.get(0).style.top);\n            }\n\n            function shiftImage(dx, dy, e) {\n                var top = +imagePosY + dy,\n                    left = +imagePosX + dx,\n                    swipeCondition = $image.width() / 10 + 20;\n\n                dragFlag = true;\n\n                if ($image.offset().left === $imageContainer.offset().left + $imageContainer.width() - $image.width() && e.keyCode === 39 ||\n                    endX - 1 < $imageContainer.offset().left + $imageContainer.width() - $image.width() && dx < 0 &&\n                    _.isNumber(endX) &&\n                    (e.type === 'mousemove' || e.type === 'touchmove' || e.type === 'pointermove' || e.type === 'MSPointerMove')) {\n                    endX = null;\n                    swipeSlide('>');\n\n                    return;\n                }\n\n                if ($image.offset().left === $imageContainer.offset().left && dx !== 0 && e.keyCode === 37 ||\n                    endX === $imageContainer.offset().left && dx > 0 &&\n                    (e.type === 'mousemove' || e.type === 'touchmove' || e.type === 'pointermove' || e.type === 'MSPointerMove')) {\n                    endX = null;\n                    swipeSlide('<');\n\n                    return;\n                }\n\n                if ($image.height() > $imageContainer.height()) {\n                    if ($imageContainer.height() > $image.height() + top) {\n                        $image.css('top', $imageContainer.height() - $image.height());\n                    } else {\n                        top = $image.height() - getTop($image) - $imageContainer.height();\n                        dy = dy < top ? dy : top;\n                        $image.css('top', getTop($image) + dy);\n                    }\n                }\n\n                if ($image.width() > $imageContainer.width()) {\n\n                    if ($imageContainer.offset().left + $imageContainer.width() > left + $image.width()) {\n                        left = $imageContainer.offset().left + $imageContainer.width() - $image.width();\n                    } else {\n                        left = $imageContainer.offset().left < left ? $imageContainer.offset().left : left;\n                    }\n                    $image.offset({\n                        'left': left\n                    });\n                    $image.css('right', '');\n                } else if (Math.abs(dy) < 1 && allowZoomOut &&\n                    !(e.type === 'mousemove' || e.type === 'touchmove' || e.type === 'pointermove' || e.type === 'MSPointerMove')) {\n                    dx < 0 ? $(gallerySelector).data('fotorama').show('>') : $(gallerySelector).data('fotorama').show('<');\n                }\n\n                if ($image.width() <= $imageContainer.width() && allowZoomOut &&\n                    (e.type === 'mousemove' || e.type === 'touchmove' || e.type === 'pointermove' || e.type === 'MSPointerMove') &&\n                    Math.abs(dx) > Math.abs(dy) && Math.abs(dx) > swipeCondition) {\n                    dx < 0 ? swipeSlide('>') : swipeSlide('<');\n                }\n            }\n\n            /**\n             * Sets image size to original or fit in parent block\n             * @param e - event object\n             */\n            function dblClickHandler(e) {\n                var imgOriginalSize = getImageSize($image[0]),\n                    proportions;\n\n                if (imgOriginalSize.rh < $image.parent().height() && imgOriginalSize.rw < $image.parent().width()) {\n                    return;\n                }\n\n                proportions = imgOriginalSize.rw / imgOriginalSize.rh;\n\n                if (allowZoomIn) {\n                    zoomIn(e, imgOriginalSize.rw - $image.width(), imgOriginalSize.rh - $image.height());\n                } else if (proportions > $imageContainer.width() / $imageContainer.height()) {\n                    zoomOut(e, imgOriginalSize.rw - $imageContainer.width(), imgOriginalSize.rw / proportions);\n                } else {\n                    zoomOut(e, imgOriginalSize.rw * proportions, imgOriginalSize.rh - $imageContainer.height());\n                }\n            }\n\n            function detectDoubleTap(e) {\n                var now = new Date().getTime(),\n                    timesince = now - tapFlag;\n\n                if (timesince < 400 && timesince > 0) {\n                    transitionActive = false;\n                    tapFlag = 0;\n                    dblClickHandler(e);\n                } else {\n                    tapFlag = new Date().getTime();\n                }\n            }\n\n            if (isTouchEnabled) {\n                $image.off('tap');\n                $image.on('tap', function (e) {\n                    if (e.originalEvent.originalEvent.touches.length === 0) {\n                        detectDoubleTap(e);\n                    }\n                });\n            } else {\n                $image.off('dblclick');\n                $image.dblclick(dblClickHandler);\n            }\n\n            if (gallery.fullScreen) {\n                toggleZoomButtons($image, isTouchEnabled, checkForVideo(fotorama.activeFrame.$stageFrame));\n            }\n\n            function getDimention(event) {\n                return Math.sqrt(\n                    (event.touches[0].clientX - event.touches[1].clientX) * (event.touches[0].clientX - event.touches[1].clientX) +\n                    (event.touches[0].clientY - event.touches[1].clientY) * (event.touches[0].clientY - event.touches[1].clientY));\n            }\n\n            $image.off(isTouchEnabled ? 'touchstart' : 'pointerdown mousedown MSPointerDown');\n            $image.on(isTouchEnabled ? 'touchstart' : 'pointerdown mousedown MSPointerDown', function (e) {\n                if (e && e.originalEvent.touches && e.originalEvent.touches.length >= 2) {\n                    e.preventDefault();\n                    pinchDimention = getDimention(e.originalEvent);\n                    isDragActive = false;\n\n                    if ($image.hasClass(imageDraggableClass)) {\n                        $image.removeClass(imageDraggableClass);\n                    }\n                } else if (gallery.fullScreen && (!transitionEnabled || !transitionActive)) {\n                    imagePosY = getTop($image);\n                    imagePosX = $image.offset().left;\n\n                    if (isTouchEnabled) {\n                        touch = e.originalEvent.touches[0] || e.originalEvent.changedTouches[0];\n                        e.clientX = touch.pageX;\n                        e.clientY = touch.pageY;\n                    }\n                    startX = e.clientX || e.originalEvent.clientX;\n                    startY = e.clientY || e.originalEvent.clientY;\n                    isDragActive = true;\n                }\n\n                if ($image.offset() && $image.width() > $imageContainer.width()) {\n                    endX = $image.offset().left;\n                }\n            });\n\n            $image.off(isTouchEnabled ? 'touchmove' : 'mousemove pointermove MSPointerMove');\n            $image.on(isTouchEnabled ? 'touchmove' : 'mousemove pointermove MSPointerMove', function (e) {\n                if (e && e.originalEvent.touches && e.originalEvent.touches.length >= 2) {\n                    e.preventDefault();\n                    var currentDimention = getDimention(e.originalEvent);\n\n                    if ($image.hasClass(imageDraggableClass)) {\n                        $image.removeClass(imageDraggableClass);\n                    }\n\n                    if (currentDimention < pinchDimention) {\n                        zoomOut(e);\n                        pinchDimention = currentDimention;\n                    } else if (currentDimention > pinchDimention) {\n                        zoomIn(e);\n                        pinchDimention = currentDimention;\n                    }\n                } else {\n                    var clientX,\n                        clientY;\n\n                    if (gallery.fullScreen && isDragActive && (!transitionEnabled || !transitionActive)) {\n\n                        if (allowZoomOut && !$image.hasClass(imageDraggableClass)) {\n                            $image.addClass(imageDraggableClass);\n                        }\n                        clientX = e.clientX || e.originalEvent.clientX;\n                        clientY = e.clientY || e.originalEvent.clientY;\n\n                        e.preventDefault();\n\n                        if (isTouchEnabled) {\n                            touch = e.originalEvent.touches[0] || e.originalEvent.changedTouches[0];\n                            clientX = touch.pageX;\n                            clientY = touch.pageY;\n                        }\n\n                        if (allowZoomOut) {\n                            imagePosY = getTop($(fullscreenImageSelector, $gallery));\n                            shiftImage(clientX - startX, clientY - startY, e);\n                        }\n                    }\n                }\n            });\n\n            $image.off('transitionend webkitTransitionEnd mozTransitionEnd msTransitionEnd ');\n            $image.on('transitionend webkitTransitionEnd mozTransitionEnd msTransitionEnd', function () {\n                transitionActive = false;\n            });\n\n            if (keyboardNavigation) {\n                $(document).off('keydown', keyboardNavigation);\n            }\n\n            /**\n             * Replaces original navigations with better one\n             * @param e - event object\n             */\n            keyboardNavigation = function (e) {\n                var step = 40,\n                    $focus = $(':focus'),\n                    isFullScreen = $(gallerySelector).data('fotorama').fullScreen,\n                    initVars = function () {\n                        imagePosX = $(fullscreenImageSelector, $gallery).offset().left;\n                        imagePosY = getTop($(fullscreenImageSelector, $gallery));\n                    };\n\n                if (($focus.attr('data-gallery-role') || !$focus.length) && allowZoomOut) {\n                    if (isFullScreen) {\n                        imagePosX = $(fullscreenImageSelector, $(gallerySelector)).offset().left;\n                        imagePosY = getTop($(fullscreenImageSelector, $(gallerySelector)));\n                    }\n\n                    if (e.keyCode === 39) {\n\n                        if (isFullScreen) {\n                            initVars();\n                            shiftImage(-step, 0, e);\n                        }\n                    }\n\n                    if (e.keyCode === 38) {\n\n                        if (isFullScreen) {\n                            initVars();\n                            shiftImage(0, step, e);\n                        }\n                    }\n\n                    if (e.keyCode === 37) {\n\n                        if (isFullScreen) {\n                            initVars();\n                            shiftImage(step, 0, e);\n                        }\n                    }\n\n                    if (e.keyCode === 40) {\n\n                        if (isFullScreen) {\n                            e.preventDefault();\n                            initVars();\n                            shiftImage(0, -step, e);\n                        }\n                    }\n                }\n\n                if (e.keyCode === 27 && isFullScreen && allowZoomOut) {\n                    $(gallerySelector).data('fotorama').cancelFullScreen();\n                }\n            };\n\n            /**\n             * @todo keyboard navigation through Fotorama Api.\n             */\n            $(document).keydown(keyboardNavigation);\n\n            $(document).on(isTouchEnabled ? 'touchend' : 'mouseup pointerup MSPointerUp', function (e) {\n                if (gallery.fullScreen) {\n\n                    if ($image.offset() && $image.width() > $imageContainer.width()) {\n                        endX = $image.offset().left;\n                    }\n\n                    isDragActive = false;\n                    $image.removeClass(imageDraggableClass);\n                }\n            });\n\n            $(window).off('resize', resizeHandler);\n            $(window).on('resize', {\n                $image: $image,\n                fotorama: fotorama\n            }, resizeHandler);\n        }\n\n        /**\n         * Hides magnifier preview and zoom blocks.\n         */\n        hideMagnifier = function () {\n            $(magnifierSelector).empty().hide();\n            $(magnifierZoomSelector).remove();\n        };\n\n        /**\n         * Check is active frame in gallery include video content.\n         * If true activeFrame contain video.\n         * @param $stageFrame - active frame in gallery\n         * @returns {*|Boolean}\n         */\n        function checkForVideo($stageFrame) {\n            return $stageFrame.hasClass(videoContainerClass);\n        }\n\n        /**\n         * Hides magnifier on drag and while arrow click.\n         */\n        function behaveOnDrag(e, initPos) {\n            var pos = [e.pageX, e.pageY],\n                isArrow = $(e.target).data('gallery-role') === 'arrow',\n                isClick = initPos[0] === pos[0] && initPos[1] === pos[1],\n                isImg = $(e.target).parent().data('active');\n\n            if (isArrow || isImg && !isClick) {\n                hideMagnifier();\n            }\n        }\n\n        if (config.magnifierOpts.enabled) {\n            $(element).on('pointerdown mousedown MSPointerDown', function (e) {\n                var pos = [e.pageX, e.pageY];\n\n                $(element).on('mousemove pointermove MSPointerMove', function (ev) {\n                    navigator.msPointerEnabled ? hideMagnifier() : behaveOnDrag(ev, pos);\n                });\n                $(document).on('mouseup pointerup MSPointerUp', function () {\n                    $(element).off('mousemove pointermove MSPointerMove');\n                });\n            });\n        }\n\n        $.extend(config.magnifierOpts, {\n            zoomable: false,\n            thumb: '.fotorama__img',\n            largeWrapper: '[data-gallery-role=\"magnifier\"]',\n            height: config.magnifierOpts.height || function () {\n                return $('[data-active=\"true\"]').height();\n            },\n            width: config.magnifierOpts.width || function () {\n                var productMedia = $(gallerySelector).parent().parent();\n\n                return productMedia.parent().width() - productMedia.width() - 20;\n            },\n            left: config.magnifierOpts.left || function () {\n                return $(gallerySelector).offset().left + $(gallerySelector).width() + 20;\n            },\n            top: config.magnifierOpts.top || function () {\n                return $(gallerySelector).offset().top;\n            }\n        });\n\n        $(element).on('fotorama:load fotorama:showend fotorama:fullscreenexit fotorama:ready', function (e, fotorama) {\n            var $activeStageFrame = $(gallerySelector).data('fotorama').activeFrame.$stageFrame;\n\n            if (!$activeStageFrame.find(magnifierZoomSelector).length) {\n                hideMagnifier();\n\n                if (config.magnifierOpts) {\n                    config.magnifierOpts.large = $(gallerySelector).data('fotorama').activeFrame.img;\n                    config.magnifierOpts.full = fotorama.data[fotorama.activeIndex].original;\n                    !checkForVideo($activeStageFrame) && $($activeStageFrame).magnify(config.magnifierOpts);\n                }\n            }\n        });\n\n        $(element).on('gallery:loaded', function (e) {\n            var $prevImage;\n\n            $(element).find(gallerySelector)\n                .on('fotorama:ready', function (e, fotorama) {\n                    var $zoomIn = $(zoomInButtonSelector),\n                        $zoomOut = $(zoomOutButtonSelector);\n\n                    if (!$zoomIn.hasClass(zoomInLoaded)) {\n                        $zoomIn.on('click touchstart', zoomIn);\n                        $zoomIn.on('mousedown', function (e) {\n                            e.stopPropagation();\n                        });\n\n                        $zoomIn.keyup(function (e) {\n\n                            if (e.keyCode === 13) {\n                                zoomIn(e);\n                            }\n                        });\n\n                        $(window).keyup(function (e) {\n\n                            if (e.keyCode === 107 || fotorama.fullscreen) {\n                                zoomIn(e);\n                            }\n                        });\n\n                        $zoomIn.addClass(zoomInLoaded);\n                    }\n\n                    if (!$zoomOut.hasClass(zoomOutLoaded)) {\n                        $zoomOut.on('click touchstart', zoomOut);\n                        $zoomOut.on('mousedown', function (e) {\n                            e.stopPropagation();\n                        });\n\n                        $zoomOut.keyup(function (e) {\n\n                            if (e.keyCode === 13) {\n                                zoomOut(e);\n                            }\n                        });\n\n                        $(window).keyup(function (e) {\n\n                            if (e.keyCode === 109 || fotorama.fullscreen) {\n                                zoomOut(e);\n                            }\n                        });\n\n                        $zoomOut.addClass(zoomOutLoaded);\n                    }\n                })\n                .on('fotorama:fullscreenenter fotorama:showend', function (e, fotorama) {\n                    hideMagnifier();\n\n                    if (!$(fullscreenImageSelector).is($prevImage)) {\n                        resetVars($(fullscreenImageSelector));\n                    }\n                    magnifierFullscreen(fotorama);\n                    mousewheel(e, fotorama, element);\n\n                    if ($prevImage) {\n                        calculateMinSize($prevImage);\n\n                        if (!$(fullscreenImageSelector).is($prevImage)) {\n                            resetVars($prevImage);\n                        }\n                    }\n\n                    toggleStandartNavigation();\n                })\n                .on('fotorama:load', function (e, fotorama) {\n                    if ($(gallerySelector).data('fotorama').fullScreen) {\n                        toggleZoomButtons($(fullscreenImageSelector), isTouchEnabled,\n                            checkForVideo(fotorama.activeFrame.$stageFrame));\n                    }\n                    magnifierFullscreen(fotorama);\n                })\n                .on('fotorama:show', function (e, fotorama) {\n                    $prevImage = _.clone($(fullscreenImageSelector));\n                    hideMagnifier();\n                })\n                .on('fotorama:fullscreenexit', function (e, fotorama) {\n                    resetVars($(fullscreenImageSelector));\n                    hideMagnifier();\n                    hideZoomControls(true);\n                });\n        });\n\n        return config;\n    };\n});\n","magnifier/magnifier.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n(function ($) {\n    $.fn.magnify = function (options) {\n        'use strict';\n\n        var magnify = new Magnify($(this), options);\n\n        /* events must be tracked here */\n\n        /**\n         * Return that from _init function\n         *\n         */\n        return magnify;\n    };\n\n    function Magnify(element, options) {\n        var customUserOptions = options || {},\n            $box = $(element),\n            $thumb,\n            that = this,\n            largeWrapper = options.largeWrapper || '.magnifier-preview',\n            $magnifierPreview = $(largeWrapper);\n\n        curThumb = null,\n        magnifierOptions = {\n            x: 0,\n            y: 0,\n            w: 0,\n            h: 0,\n            lensW: 0,\n            lensH: 0,\n            lensBgX: 0,\n            lensBgY: 0,\n            largeW: 0,\n            largeH: 0,\n            largeL: 0,\n            largeT: 0,\n            zoom: 2,\n            zoomMin: 1.1,\n            zoomMax: 5,\n            mode: 'outside',\n            eventType: 'click',\n            status: 0,\n            zoomAttached: false,\n            zoomable: customUserOptions.zoomable !== undefined ?\n                customUserOptions.zoomable\n                : false,\n            onthumbenter: customUserOptions.onthumbenter !== undefined ?\n                customUserOptions.onthumbenter\n                : null,\n            onthumbmove: customUserOptions.onthumbmove !== undefined ?\n                customUserOptions.onthumbmove\n                : null,\n            onthumbleave: customUserOptions.onthumbleave !== undefined ?\n                customUserOptions.onthumbleave\n                : null,\n            onzoom: customUserOptions.onzoom !== undefined ?\n                customUserOptions.onzoom\n                : null\n        },\n        pos = {\n            t: 0,\n            l: 0,\n            x: 0,\n            y: 0\n        },\n        gId = 0,\n        status = 0,\n        curIdx = '',\n        curLens = null,\n        curLarge = null,\n        lensbg = customUserOptions.bg !== undefined ?\n            customUserOptions.lensbg\n            : true,\n        gZoom = customUserOptions.zoom !== undefined ?\n            customUserOptions.zoom\n            : magnifierOptions.zoom,\n        gZoomMin = customUserOptions.zoomMin !== undefined ?\n            customUserOptions.zoomMin\n            : magnifierOptions.zoomMin,\n        gZoomMax = customUserOptions.zoomMax !== undefined ?\n            customUserOptions.zoomMax\n            : magnifierOptions.zoomMax,\n        gMode = customUserOptions.mode || magnifierOptions.mode,\n        gEventType = customUserOptions.eventType || magnifierOptions.eventType,\n        data = {},\n        inBounds = false,\n        isOverThumb = false,\n        rate = 1,\n        paddingX = 0,\n        paddingY = 0,\n        enabled = true,\n        showWrapper = true;\n\n        var MagnifyCls = {\n            magnifyHidden: 'magnify-hidden',\n            magnifyOpaque: 'magnify-opaque',\n            magnifyFull: 'magnify-fullimage'\n        };\n\n        /**\n         * Update Lens positon on.\n         *\n         */\n        that.update = function () {\n            updateLensOnLoad();\n        };\n\n        /**\n         * Init new Magnifier\n         *\n         */\n        that.init = function () {\n            _init($box, options);\n        };\n\n        function _toBoolean(str) {\n            if (typeof str === 'string') {\n                if (str === 'true') {\n                    return true;\n                } else if (str === 'false' || '') {\n                    return false;\n                }\n                console.warn('Wrong type: can\\'t be transformed to Boolean');\n\n            } else if (typeof str === 'boolean') {\n                return str;\n            }\n        }\n\n        function createLens(thumb) {\n            if ($(thumb).siblings('.magnify-lens').length) {\n                return false;\n            }\n            var lens = $('<div class=\"magnify-lens magnify-hidden\" data-gallery-role=\"magnifier-zoom\"></div>');\n\n            $(thumb).parent().append(lens);\n        }\n\n        function updateLensOnLoad(idSelectorMainImg, thumb, largeImgInMagnifyLens, largeWrapper) {\n            var magnifyLensElement= $box.find('.magnify-lens'),\n                textWrapper;\n\n            if (data[idSelectorMainImg].status === 1) {\n                textWrapper = $('<div class=\"magnifier-loader-text\"></div>');\n                magnifyLensElement.className = 'magnifier-loader magnify-hidden';\n                textWrapper.html('Loading...');\n                magnifyLensElement.html('').append(textWrapper);\n            } else if (data[idSelectorMainImg].status === 2) {\n                magnifyLensElement.addClass(MagnifyCls.magnifyHidden);\n                magnifyLensElement.html('');\n\n                largeImgInMagnifyLens.id = idSelectorMainImg + '-large';\n                largeImgInMagnifyLens.style.width = data[idSelectorMainImg].largeImgInMagnifyLensWidth + 'px';\n                largeImgInMagnifyLens.style.height = data[idSelectorMainImg].largeImgInMagnifyLensHeight + 'px';\n                largeImgInMagnifyLens.className = 'magnifier-large magnify-hidden';\n\n                if (data[idSelectorMainImg].mode === 'inside') {\n                    magnifyLensElement.append(largeImgInMagnifyLens);\n                } else {\n                    largeWrapper.html('').append(largeImgInMagnifyLens);\n                }\n            }\n\n            data[idSelectorMainImg].lensH = data[idSelectorMainImg].lensH > $thumb.height() ? $thumb.height() : data[idSelectorMainImg].lensH;\n\n            if (Math.round(data[idSelectorMainImg].lensW) === 0) {\n                magnifyLensElement.css('display', 'none');\n            } else {\n                magnifyLensElement.css({\n                    width: Math.round(data[idSelectorMainImg].lensW) + 'px',\n                    height: Math.round(data[idSelectorMainImg].lensH) + 'px',\n                    display: ''\n                });\n            }\n        }\n\n        function getMousePos() {\n            var xPos = pos.x - magnifierOptions.x,\n                yPos = pos.y - magnifierOptions.y,\n                t,\n                l;\n\n            inBounds =  xPos < 0 || yPos < 0 || xPos > magnifierOptions.w || yPos > magnifierOptions.h  ? false : true;\n\n            l = xPos - magnifierOptions.lensW / 2;\n            t = yPos - magnifierOptions.lensH / 2;\n\n            if (xPos < magnifierOptions.lensW / 2) {\n                l = 0;\n            }\n\n            if (yPos < magnifierOptions.lensH / 2) {\n                t = 0;\n            }\n\n            if (xPos - magnifierOptions.w + Math.ceil(magnifierOptions.lensW / 2) > 0) {\n                l = magnifierOptions.w - Math.ceil(magnifierOptions.lensW + 2);\n            }\n\n            if (yPos - magnifierOptions.h + Math.ceil(magnifierOptions.lensH / 2) > 0) {\n                t = magnifierOptions.h - Math.ceil(magnifierOptions.lensH);\n            }\n\n            pos.l = l;\n            pos.t = t;\n\n            magnifierOptions.lensBgX = pos.l;\n            magnifierOptions.lensBgY = pos.t;\n\n            if (magnifierOptions.mode === 'inside') {\n                magnifierOptions.largeL = Math.round(xPos * (magnifierOptions.zoom - magnifierOptions.lensW / magnifierOptions.w));\n                magnifierOptions.largeT = Math.round(yPos * (magnifierOptions.zoom - magnifierOptions.lensH / magnifierOptions.h));\n            } else {\n                magnifierOptions.largeL = Math.round(magnifierOptions.lensBgX * magnifierOptions.zoom * (magnifierOptions.largeWrapperW / magnifierOptions.w));\n                magnifierOptions.largeT = Math.round(magnifierOptions.lensBgY * magnifierOptions.zoom * (magnifierOptions.largeWrapperH / magnifierOptions.h));\n            }\n        }\n\n        function onThumbEnter() {\n            if (_toBoolean(enabled)) {\n                magnifierOptions = data[curIdx];\n                curLens = $box.find('.magnify-lens');\n\n                if (magnifierOptions.status === 2) {\n                    curLens.removeClass(MagnifyCls.magnifyOpaque);\n                    curLarge = $('#' + curIdx + '-large');\n                    curLarge.removeClass(MagnifyCls.magnifyHidden);\n                } else if (magnifierOptions.status === 1) {\n                    curLens.className = 'magnifier-loader';\n                }\n            }\n        }\n\n        function onThumbLeave() {\n            if (magnifierOptions.status > 0) {\n                var handler = magnifierOptions.onthumbleave;\n\n                if (handler !== null) {\n                    handler({\n                        thumb: curThumb,\n                        lens: curLens,\n                        large: curLarge,\n                        x: pos.x,\n                        y: pos.y\n                    });\n                }\n\n                if (!curLens.hasClass(MagnifyCls.magnifyHidden)) {\n                    curLens.addClass(MagnifyCls.magnifyHidden);\n\n                    //$curThumb.removeClass(MagnifyCls.magnifyOpaque);\n                    if (curLarge !== null) {\n                        curLarge.addClass(MagnifyCls.magnifyHidden);\n                    }\n                }\n            }\n        }\n\n        function move() {\n            if (_toBoolean(enabled)) {\n                if (status !== magnifierOptions.status) {\n                    onThumbEnter();\n                }\n\n                if (magnifierOptions.status > 0) {\n                    curThumb.className = magnifierOptions.thumbCssClass + ' magnify-opaque';\n\n                    if (magnifierOptions.status === 1) {\n                        curLens.className = 'magnifier-loader';\n                    } else if (magnifierOptions.status === 2) {\n                        curLens.removeClass(MagnifyCls.magnifyHidden);\n                        curLarge.removeClass(MagnifyCls.magnifyHidden);\n                        curLarge.css({\n                            left: '-' + magnifierOptions.largeL + 'px',\n                            top: '-' + magnifierOptions.largeT + 'px'\n                        });\n                    }\n\n                    var borderOffset = 2; // Offset for magnify-lens border\n                    pos.t = pos.t <= 0 ? 0 : pos.t - borderOffset;\n\n                    curLens.css({\n                        left: pos.l + paddingX + 'px',\n                        top: pos.t + paddingY + 'px'\n                    });\n\n                    if (lensbg) {\n                        curLens.css({\n                            'background-color': 'rgba(f,f,f,.5)'\n                        });\n                    } else {\n                        curLens.get(0).style.backgroundPosition = '-' +\n                        magnifierOptions.lensBgX + 'px -' +\n                        magnifierOptions.lensBgY + 'px';\n                    }\n                    var handler = magnifierOptions.onthumbmove;\n\n                    if (handler !== null) {\n                        handler({\n                            thumb: curThumb,\n                            lens: curLens,\n                            large: curLarge,\n                            x: pos.x,\n                            y: pos.y\n                        });\n                    }\n                }\n\n                status = magnifierOptions.status;\n            }\n        }\n\n        function setThumbData(mainImage, mainImageData) {\n            var thumbBounds = mainImage.getBoundingClientRect(),\n                w = 0,\n                h = 0;\n\n            mainImageData.x = Math.round(thumbBounds.left);\n            mainImageData.y = Math.round(thumbBounds.top);\n            mainImageData.w = Math.round(thumbBounds.right - mainImageData.x);\n            mainImageData.h = Math.round(thumbBounds.bottom - mainImageData.y);\n\n            if (mainImageData.mode === 'inside') {\n                w = mainImageData.w;\n                h = mainImageData.h;\n            } else {\n                w = mainImageData.largeWrapperW;\n                h = mainImageData.largeWrapperH;\n            }\n\n            mainImageData.largeImgInMagnifyLensWidth = Math.round(mainImageData.zoom * w);\n            mainImageData.largeImgInMagnifyLensHeight = Math.round(mainImageData.zoom * h);\n\n            mainImageData.lensW = Math.round(mainImageData.w / mainImageData.zoom);\n            mainImageData.lensH = Math.round(mainImageData.h / mainImageData.zoom);\n        }\n\n        function _init($box, options) {\n            var opts = {};\n\n            if (options.thumb === undefined) {\n                return false;\n            }\n\n            $thumb = $box.find(options.thumb);\n\n            if ($thumb.length) {\n                for (var key in options) {\n                    opts[key] = options[key];\n                }\n\n                opts.thumb = $thumb;\n                enabled = opts.enabled;\n\n                if (_toBoolean(enabled)) {\n\n                    $magnifierPreview.show().css('display', '');\n                    $magnifierPreview.addClass(MagnifyCls.magnifyHidden);\n                    set(opts);\n                } else {\n                    $magnifierPreview.empty().hide();\n                }\n            }\n\n            return that;\n        }\n\n        function hoverEvents(thumb) {\n            $(thumb).on('mouseover', function (e) {\n\n                if (showWrapper) {\n\n                    if (magnifierOptions.status !== 0) {\n                        onThumbLeave();\n                    }\n                    handleEvents(e);\n                    isOverThumb = inBounds;\n                }\n            }).trigger('mouseover');\n        }\n\n        function clickEvents(thumb) {\n            $(thumb).on('click', function (e) {\n\n                if (showWrapper) {\n                    if (!isOverThumb) {\n                        if (magnifierOptions.status !== 0) {\n                            onThumbLeave();\n                        }\n                        handleEvents(e);\n                        isOverThumb = true;\n                    }\n                }\n            });\n        }\n\n        function bindEvents(eType, thumb) {\n            var eventFlag = 'hasBoundEvent_' + eType;\n            if (thumb[eventFlag]) {\n                // Events are already bound, no need to bind in duplicate\n                return;\n            }\n            thumb[eventFlag] = true;\n\n            switch (eType) {\n                case 'hover':\n                    hoverEvents(thumb);\n                    break;\n\n                case 'click':\n                    clickEvents(thumb);\n                    break;\n            }\n        }\n\n        function handleEvents(e) {\n            var src = e.target;\n\n            curIdx = src.id;\n            curThumb = src;\n\n            onThumbEnter(src);\n\n            setThumbData(curThumb, magnifierOptions);\n\n            pos.x = e.clientX;\n            pos.y = e.clientY;\n\n            getMousePos();\n            move();\n\n            var handler = magnifierOptions.onthumbenter;\n\n            if (handler !== null) {\n                handler({\n                    thumb: curThumb,\n                    lens: curLens,\n                    large: curLarge,\n                    x: pos.x,\n                    y: pos.y\n                });\n            }\n        }\n\n        function set(options) {\n            if (data[options.thumb.id] !== undefined) {\n                curThumb = options.thumb;\n\n                return false;\n            }\n\n            var thumbObj = new Image(),\n                largeObj = new Image(),\n                $thumb = options.thumb,\n                thumb = $thumb.get(0),\n                idx = thumb.id,\n                largeUrl,\n                largeWrapper = $(options.largeWrapper),\n                zoom = options.zoom || thumb.getAttribute('data-zoom') || gZoom,\n                zoomMin = options.zoomMin || gZoomMin,\n                zoomMax = options.zoomMax || gZoomMax,\n                mode = options.mode || thumb.getAttribute('data-mode') || gMode,\n                eventType = options.eventType || thumb.getAttribute('data-eventType') || gEventType,\n                onthumbenter = options.onthumbenter !== undefined ?\n                    options.onthumbenter\n                    : magnifierOptions.onthumbenter,\n                onthumbleave = options.onthumbleave !== undefined ?\n                    options.onthumbleave\n                    : magnifierOptions.onthumbleave,\n                onthumbmove = options.onthumbmove !== undefined ?\n                    options.onthumbmove\n                    : magnifierOptions.onthumbmove;\n\n            largeUrl = $thumb.data('original') || customUserOptions.full || $thumb.attr('src');\n\n            if (thumb.id === '') {\n                idx = thumb.id = 'magnifier-item-' + gId;\n                gId += 1;\n            }\n\n            createLens(thumb, idx);\n\n            if (options.width) {\n                largeWrapper.width(options.width);\n            }\n\n            if (options.height) {\n                largeWrapper.height(options.height);\n            }\n\n            if (options.top) {\n                if (typeof options.top == 'function') {\n                    var top = options.top() + 'px';\n                } else {\n                    var top = options.top + 'px';\n                }\n\n                if (largeWrapper.length) {\n                    largeWrapper[0].style.top = top.replace('%px', '%');\n                }\n            }\n\n            if (options.left) {\n                if (typeof options.left == 'function') {\n                    var left = options.left() + 'px';\n                } else {\n                    var left = options.left + 'px';\n                }\n\n                if (largeWrapper.length) {\n                    largeWrapper[0].style.left = left.replace('%px', '%');\n                }\n            }\n\n            data[idx] = {\n                zoom: zoom,\n                zoomMin: zoomMin,\n                zoomMax: zoomMax,\n                mode: mode,\n                eventType: eventType,\n                thumbCssClass: thumb.className,\n                zoomAttached: false,\n                status: 0,\n                largeUrl: largeUrl,\n                largeWrapperId: mode === 'outside' ? largeWrapper.attr('id') : null,\n                largeWrapperW: mode === 'outside' ? largeWrapper.width() : null,\n                largeWrapperH: mode === 'outside' ? largeWrapper.height() : null,\n                onthumbenter: onthumbenter,\n                onthumbleave: onthumbleave,\n                onthumbmove: onthumbmove\n            };\n\n            paddingX = ($thumb.parent().width() - $thumb.width()) / 2;\n            paddingY = ($thumb.parent().height() - $thumb.height()) / 2;\n\n            showWrapper = false;\n            $(thumbObj).on('load', function () {\n                data[idx].status = 1;\n\n                $(largeObj).on('load', function () {\n\n                    if (largeObj.width > largeWrapper.width() || largeObj.height > largeWrapper.height()) {\n                        showWrapper = true;\n                        bindEvents(eventType, thumb);\n                        data[idx].status = 2;\n                        if (largeObj.width > largeObj.height) {\n                            data[idx].zoom = largeObj.width / largeWrapper.width();\n                        } else {\n                            data[idx].zoom = largeObj.height / largeWrapper.height();\n                        }\n                        setThumbData(thumb, data[idx]);\n                        updateLensOnLoad(idx, thumb, largeObj, largeWrapper);\n                    }\n                });\n\n                largeObj.src = data[idx].largeUrl;\n            });\n\n            thumbObj.src = thumb.src;\n        }\n\n        /**\n         * Hide magnifier when mouse exceeds image bounds.\n         */\n        function onMouseLeave() {\n            onThumbLeave();\n            isOverThumb = false;\n            $magnifierPreview.addClass(MagnifyCls.magnifyHidden);\n        }\n\n        function onMousemove(e) {\n            pos.x = e.clientX;\n            pos.y = e.clientY;\n\n            getMousePos();\n\n            if (gEventType === 'hover') {\n                isOverThumb = inBounds;\n            }\n\n            if (inBounds && isOverThumb) {\n                if (gMode === 'outside') {\n                    $magnifierPreview.removeClass(MagnifyCls.magnifyHidden);\n                }\n                move();\n            }\n        }\n\n        function onScroll() {\n            if (curThumb !== null) {\n                setThumbData(curThumb, magnifierOptions);\n            }\n        }\n\n        $(window).on('scroll', onScroll);\n        $(window).resize(function () {\n            _init($box, customUserOptions);\n        });\n\n        $box.on('mousemove', onMousemove);\n        $box.on('mouseleave', onMouseLeave);\n\n        _init($box, customUserOptions);\n    }\n}(jQuery));\n","Magento_PaypalCaptcha/js/model/skipRefreshCaptcha.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['ko'], function (ko) {\n    'use strict';\n\n    return {\n        skip: ko.observable(false)\n    };\n});\n","Magento_PaypalCaptcha/js/view/payment/list-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Captcha/js/model/captchaList'\n], function ($, captchaList) {\n    'use strict';\n\n    var mixin = {\n\n        formId: 'co-payment-form',\n\n        /**\n         * Sets custom template for Payflow Pro\n         *\n         * @param {Object} payment\n         * @returns {Object}\n         */\n        createComponent: function (payment) {\n\n            var component = this._super(payment);\n\n            if (component.component === 'Magento_Paypal/js/view/payment/method-renderer/payflowpro-method') {\n                component.template = 'Magento_PaypalCaptcha/payment/payflowpro-form';\n                $(window).off('clearTimeout')\n                    .on('clearTimeout', this.clearTimeout.bind(this));\n            }\n\n            return component;\n        },\n\n        /**\n         * Overrides default window.clearTimeout() to catch errors from iframe and reload Captcha.\n         *\n         * @param {Number} timeoutID\n         */\n        clearTimeout: function (timeoutID) {\n            var captcha = captchaList.getCaptchaByFormId(this.formId);\n\n            if (captcha !== null) {\n                captcha.refresh();\n            }\n            clearTimeout(timeoutID);\n        }\n    };\n\n    /**\n     * Overrides `Magento_Checkout/js/view/payment/list::createComponent`\n     */\n    return function (target) {\n        return target.extend(mixin);\n    };\n});\n","Magento_PaypalCaptcha/js/view/payment/method-renderer/payflowpro-method-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_PaypalCaptcha/js/model/skipRefreshCaptcha'\n], function (skipRefreshCaptcha) {\n    'use strict';\n\n    var payflowProMethodMixin = {\n        /**\n         * @override\n         */\n        placeOrder: function () {\n            skipRefreshCaptcha.skip(true);\n            this._super();\n        }\n    };\n\n    return function (payflowProMethod) {\n        return payflowProMethod.extend(payflowProMethodMixin);\n    };\n});\n","Magento_PaypalCaptcha/js/view/checkout/paymentCaptcha.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Captcha/js/view/checkout/defaultCaptcha',\n    'Magento_Captcha/js/model/captchaList',\n    'Magento_Captcha/js/model/captcha'\n],\nfunction ($, defaultCaptcha, captchaList, Captcha) {\n    'use strict';\n\n    return defaultCaptcha.extend({\n\n        /** @inheritdoc */\n        initialize: function () {\n            var captchaConfigPayment,\n                currentCaptcha;\n\n            this._super();\n\n            if (window[this.configSource] && window[this.configSource].captchaPayments) {\n                captchaConfigPayment = window[this.configSource].captchaPayments;\n\n                $.each(captchaConfigPayment, function (formId, captchaData) {\n                    var captcha;\n\n                    captchaData.formId = formId;\n                    captcha = Captcha(captchaData);\n                    captchaList.add(captcha);\n                });\n            }\n\n            currentCaptcha = captchaList.getCaptchaByFormId(this.formId);\n\n            if (currentCaptcha != null) {\n                currentCaptcha.setIsVisible(true);\n                this.setCurrentCaptcha(currentCaptcha);\n            }\n        }\n    });\n});\n","Magento_PaypalCaptcha/js/view/checkout/defaultCaptcha-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_PaypalCaptcha/js/model/skipRefreshCaptcha'\n], function (skipRefreshCaptcha) {\n    'use strict';\n\n    var defaultCaptchaMixin = {\n        /**\n         * @override\n         */\n        refresh: function () {\n            if (!skipRefreshCaptcha.skip()) {\n                this._super();\n            } else {\n                skipRefreshCaptcha.skip(false);\n            }\n        }\n    };\n\n    return function (defaultCaptcha) {\n        return defaultCaptcha.extend(defaultCaptchaMixin);\n    };\n});\n","PayPal_Braintree/js/validator.js":"/**\n * Copyright \u00a9 2013-2017 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    return {\n        config: {},\n\n        /**\n         * Set configuration\n         * @param {Object} config\n         */\n        setConfig: function (config) {\n            this.config = config;\n        },\n\n        /**\n         * Get List of available card types\n         * @returns {*|exports.defaults.availableCardTypes|{}}\n         */\n        getAvailableCardTypes: function () {\n            return this.config.availableCardTypes;\n        },\n\n        /**\n         * Get list of card types\n         * @returns {Object}\n         */\n        getCcTypesMapper: function () {\n            return this.config.ccTypesMapper;\n        },\n\n        /**\n         * Find mage card type by Braintree type\n         * @param {String} type\n         * @param {Object} availableTypes\n         * @returns {*}\n         */\n        getMageCardType: function (type, availableTypes) {\n            var storedCardType = null,\n                mapper = this.getCcTypesMapper();\n\n            if (type && typeof mapper[type] !== 'undefined') {\n                storedCardType = mapper[type];\n\n                if (_.indexOf(availableTypes, storedCardType) !== -1) {\n                    return storedCardType;\n                }\n            }\n\n            return null;\n        },\n\n        /**\n         * Filter list of available card types\n         * @param {Object} availableTypes\n         * @param {Object} countrySpecificCardTypes\n         * @returns {Object}\n         */\n        collectTypes: function (availableTypes, countrySpecificCardTypes) {\n            var key,\n                filteredTypes = [];\n\n            for (key in availableTypes) {\n                if (_.indexOf(countrySpecificCardTypes, availableTypes[key]) !== -1) {\n                    filteredTypes.push(availableTypes[key]);\n                }\n            }\n\n            return filteredTypes;\n        },\n\n        /**\n         * Get list of card types for country\n         * @param {String} countryId\n         * @returns {*}\n         */\n        getCountrySpecificCardTypes: function (countryId) {\n            if (typeof this.config.countrySpecificCardTypes[countryId] !== 'undefined') {\n                return this.config.countrySpecificCardTypes[countryId];\n            }\n\n            return false;\n        }\n    };\n});\n","PayPal_Braintree/js/form-builder.js":"/**\n * Copyright \u00a9 2013-2017 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'jquery',\n        'underscore',\n        'mage/template'\n    ],\n    function ($, _, mageTemplate) {\n        'use strict';\n\n        return {\n\n            /**\n             * @param {Object} formData\n             * @returns {*|jQuery}\n             */\n            build: function (formData) {\n                var formTmpl = mageTemplate('<form action=\"<%= data.action %>\"' +\n                    ' method=\"POST\" hidden enctype=\"application/x-www-form-urlencoded\">' +\n                        '<% _.each(data.fields, function(val, key){ %>' +\n                            '<input value=\\'<%= val %>\\' name=\"<%= key %>\" type=\"hidden\">' +\n                        '<% }); %>' +\n                    '</form>');\n\n                return $(formTmpl({\n                    data: {\n                        action: formData.action,\n                        fields: formData.fields\n                    }\n                })).appendTo($('[data-container=\"body\"]'));\n            }\n        };\n    }\n);\n","PayPal_Braintree/js/googlepay/button.js":"/**\n * Braintree Google Pay button\n **/\ndefine(\n    [\n        'uiComponent',\n        \"knockout\",\n        \"jquery\",\n        'braintree',\n        'braintreeGooglePay',\n        'mage/translate',\n        'googlePayLibrary'\n        ],\n    function (\n        Component,\n        ko,\n        jQuery,\n        braintree,\n        googlePay,\n        $t\n    ) {\n        'use strict';\n\n        return {\n            init: function (element, context) {\n                // No element or context\n                if (!element || !context || !this.deviceSupported()) {\n                    return;\n                }\n\n                // Context must implement these methods\n                if (typeof context.getClientToken !== 'function') {\n                    console.error(\"Braintree GooglePay Context passed does not provide a getClientToken method\", context);\n                    return;\n                }\n                if (typeof context.getPaymentRequest !== 'function') {\n                    console.error(\"Braintree GooglePay Context passed does not provide a getPaymentRequest method\", context);\n                    return;\n                }\n                if (typeof context.startPlaceOrder !== 'function') {\n                    console.error(\"Braintree GooglePay Context passed does not provide a startPlaceOrder method\", context);\n                    return;\n                }\n\n                // init google pay object\n                var paymentsClient = new google.payments.api.PaymentsClient({\n                    environment: context.getEnvironment()\n                });\n\n                // Create a button within the KO element, as google pay can only be instantiated through\n                // a valid on click event (ko onclick bind interferes with this).\n                var button = document.createElement('button');\n                button.className = \"braintree-googlepay-button long \" + (context.getBtnColor() == 1 ? 'black' : 'white');\n                button.title = $t(\"Buy with Google Pay\");\n\n                // init braintree api\n                braintree.create({\n                    authorization: context.getClientToken()\n                }, function (clientErr, clientInstance) {\n                    if (clientErr) {\n                        console.error('Error creating client:', clientErr);\n                        return;\n                    }\n\n                    googlePay.create({\n                        client: clientInstance\n                    }, function (googlePayErr, googlePaymentInstance) {\n                        // No instance\n                        if (googlePayErr) {\n                            console.error('Braintree GooglePay Error creating googlePayInstance:', googlePayErr);\n                            return;\n                        }\n\n                        paymentsClient.isReadyToPay({\n                            allowedPaymentMethods: googlePaymentInstance.createPaymentDataRequest().allowedPaymentMethods\n                        }).then(function(response) {\n                            if (response.result) {\n                                button.addEventListener('click', function (event) {\n                                    event.preventDefault();\n                                    jQuery(\"body\").loader('show');\n                                    var responseData;\n\n                                    var paymentDataRequest = googlePaymentInstance.createPaymentDataRequest(context.getPaymentRequest());\n                                    paymentsClient.loadPaymentData(paymentDataRequest).then(function (paymentData) {\n                                        // Persist the paymentData (shipping address etc)\n                                        responseData = paymentData;\n                                        // Return the braintree nonce promise\n                                        return googlePaymentInstance.parseResponse(paymentData);\n                                    }).then(function (result) {\n                                        context.startPlaceOrder(result.nonce, responseData);\n                                    }).catch(function (err) {\n                                        // Handle errors\n                                        // err = {statusCode: \"CANCELED\"}\n                                        console.error(err);\n                                        jQuery(\"body\").loader('hide');\n                                    });\n                                });\n\n                                element.appendChild(button);\n                            }\n                        }).catch(function (err) {\n                            console.error(err);\n                            jQuery(\"body\").loader('hide');\n                        });\n                    });\n                });\n            },\n\n            deviceSupported: function() {\n                return !!(window.PaymentRequest);\n            }\n        };\n    }\n);","PayPal_Braintree/js/googlepay/api.js":"/**\n * Braintree Google Pay button api\n **/\ndefine([\n    'uiComponent',\n    'mage/translate',\n    'mage/storage',\n    'jquery',\n    'PayPal_Braintree/js/form-builder'\n], function (Component, $t, storage, jQuery, formBuilder) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            clientToken: null,\n            merchantId: null,\n            currencyCode: null,\n            actionSuccess: null,\n            amount: null,\n            cardTypes: [],\n            btnColor: 0\n        },\n\n        /**\n         * Set & get environment\n         * \"PRODUCTION\" or \"TEST\"\n         */\n        setEnvironment: function (value) {\n            this.environment = value;\n        },\n        getEnvironment: function () {\n            return this.environment;\n        },\n\n        /**\n         * Set & get api token\n         */\n        setClientToken: function (value) {\n            this.clientToken = value;\n        },\n        getClientToken: function () {\n            return this.clientToken;\n        },\n\n        /**\n         * Set and get display name\n         */\n        setMerchantId: function (value) {\n            this.merchantId = value;\n        },\n        getMerchantId: function () {\n            return this.merchantId;\n        },\n\n        /**\n         * Set and get currency code\n         */\n        setAmount: function (value) {\n            this.amount = parseFloat(value).toFixed(2);\n        },\n        getAmount: function () {\n            return this.amount;\n        },\n\n        /**\n         * Set and get currency code\n         */\n        setCurrencyCode: function (value) {\n            this.currencyCode = value;\n        },\n        getCurrencyCode: function () {\n            return this.currencyCode;\n        },\n\n        /**\n         * Set and get success redirection url\n         */\n        setActionSuccess: function (value) {\n            this.actionSuccess = value;\n        },\n        getActionSuccess: function () {\n            return this.actionSuccess;\n        },\n\n        /**\n         * Set and get success redirection url\n         */\n        setCardTypes: function (value) {\n            this.cardTypes = value;\n        },\n        getCardTypes: function () {\n            return this.cardTypes;\n        },\n\n        /**\n         * BTN Color\n         */\n        setBtnColor: function (value) {\n            this.btnColor = value;\n        },\n        getBtnColor: function () {\n            return this.btnColor;\n        },\n\n        /**\n         * Payment request info\n         */\n        getPaymentRequest: function () {\n            var result = {\n                transactionInfo: {\n                    totalPriceStatus: 'ESTIMATED',\n                    totalPrice: this.getAmount(),\n                    currencyCode: this.getCurrencyCode()\n                },\n                allowedPaymentMethods: ['CARD'],\n                phoneNumberRequired: true,\n                emailRequired: true,\n                shippingAddressRequired: true,\n                cardRequirements: {\n                    billingAddressRequired: true,\n                    billingAddressFormat: 'FULL',\n                    allowedCardNetworks: this.getCardTypes()\n                }\n            };\n\n            if (this.getEnvironment() !== \"TEST\") {\n                result['merchantId'] = this.getMerchantId();\n            }\n\n            return result;\n        },\n\n        /**\n         * Place the order\n         */\n        startPlaceOrder: function (nonce, paymentData) {\n            var payload = {\n                details: {\n                    shippingAddress: {\n                        streetAddress: paymentData.shippingAddress.address1 + \"\\n\"\n                        + paymentData.shippingAddress.address2,\n                        locality: paymentData.shippingAddress.locality,\n                        postalCode: paymentData.shippingAddress.postalCode,\n                        countryCodeAlpha2: paymentData.shippingAddress.countryCode,\n                        email: paymentData.email,\n                        name: paymentData.shippingAddress.name,\n                        telephone: typeof paymentData.shippingAddress.phoneNumber !== 'undefined' ? paymentData.shippingAddress.phoneNumber : '',\n                        region: typeof paymentData.shippingAddress.administrativeArea !== 'undefined' ? paymentData.shippingAddress.administrativeArea : ''\n                    },\n                    billingAddress: {\n                        streetAddress: paymentData.cardInfo.billingAddress.address1 + \"\\n\"\n                        + paymentData.cardInfo.billingAddress.address2,\n                        locality: paymentData.cardInfo.billingAddress.locality,\n                        postalCode: paymentData.cardInfo.billingAddress.postalCode,\n                        countryCodeAlpha2: paymentData.cardInfo.billingAddress.countryCode,\n                        email: paymentData.email,\n                        name: paymentData.cardInfo.billingAddress.name,\n                        telephone: typeof paymentData.cardInfo.billingAddress.phoneNumber !== 'undefined' ? paymentData.cardInfo.billingAddress.phoneNumber : '',\n                        region: typeof paymentData.cardInfo.billingAddress.administrativeArea !== 'undefined' ? paymentData.cardInfo.billingAddress.administrativeArea : ''\n                    }\n                },\n                nonce: nonce\n            };\n\n            formBuilder.build({\n                action: this.getActionSuccess(),\n                fields: {\n                    result: JSON.stringify(payload)\n                }\n            }).submit();\n        }\n    });\n});","PayPal_Braintree/js/googlepay/implementations/shortcut.js":"/**\n * Braintree Google Pay mini cart payment method integration.\n **/\ndefine(\n    [\n        'uiComponent',\n        'PayPal_Braintree/js/googlepay/button',\n        'PayPal_Braintree/js/googlepay/api',\n        'mage/translate',\n        'domReady!'\n    ],\n    function (\n        Component,\n        button,\n        buttonApi,\n        $t\n    ) {\n        'use strict';\n\n        return Component.extend({\n\n            defaults: {\n                id: null,\n                clientToken: null,\n                merchantId: null,\n                currencyCode: null,\n                actionSuccess: null,\n                amount: null,\n                environment: \"TEST\",\n                cardType: [],\n                btnColor: 0\n            },\n\n            /**\n             * @returns {Object}\n             */\n            initialize: function () {\n                this._super();\n\n                var api = new buttonApi();\n                api.setEnvironment(this.environment);\n                api.setCurrencyCode(this.currencyCode);\n                api.setClientToken(this.clientToken);\n                api.setMerchantId(this.merchantId);\n                api.setActionSuccess(this.actionSuccess);\n                api.setAmount(this.amount);\n                api.setCardTypes(this.cardTypes)\n                api.setBtnColor(this.btnColor);\n\n                // Attach the button\n                button.init(\n                    document.getElementById(this.id),\n                    api\n                );\n\n                return this;\n            }\n        });\n    }\n);\n","PayPal_Braintree/js/googlepay/implementations/core-checkout/method-googlepay.js":"define(\n    ['uiComponent', 'Magento_Checkout/js/model/payment/renderer-list'],\n    function (Component, rendererList) {\n        'use strict';\n\n        rendererList.push(\n            {\n                type: 'braintree_googlepay',\n                component: 'PayPal_Braintree/js/googlepay/implementations/core-checkout/method-renderer/googlepay'\n            }\n        );\n\n        return Component.extend({});\n    }\n);","PayPal_Braintree/js/googlepay/implementations/core-checkout/method-renderer/googlepay.js":"/**\n * Braintree Google Pay payment method integration.\n **/\ndefine([\n    'Magento_Checkout/js/view/payment/default',\n    'Magento_Checkout/js/model/quote',\n    'PayPal_Braintree/js/googlepay/button'\n], function (\n    Component,\n    quote,\n    button\n) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'PayPal_Braintree/googlepay/core-checkout',\n            paymentMethodNonce: null,\n            deviceSupported: button.deviceSupported(),\n            grandTotalAmount: 0\n        },\n\n        /**\n         * Inject the google pay button into the target element\n         */\n        getGooglePayBtn: function (id) {\n            button.init(\n                document.getElementById(id),\n                this\n            );\n        },\n\n        /**\n         * Subscribe to grand totals\n         */\n        initObservable: function () {\n            this._super();\n            this.grandTotalAmount = parseFloat(quote.totals()['b