require.config({"config": {
        "jsbuild":{"knockoutjs/knockout.js":"/*!\n * Knockout JavaScript library v3.5.1\n * (c) The Knockout.js team - http://knockoutjs.com/\n * License: MIT (http://www.opensource.org/licenses/mit-license.php)\n */\n\n(function(){\n    var DEBUG=true;\n    (function(undefined){\n        // (0, eval)('this') is a robust way of getting a reference to the global object\n        // For details, see http://stackoverflow.com/questions/14119988/return-this-0-evalthis/14120023#14120023\n        var window = this || (0, eval)('this'),\n            document = window['document'],\n            navigator = window['navigator'],\n            jQueryInstance = window[\"jQuery\"],\n            JSON = window[\"JSON\"];\n\n        if (!jQueryInstance && typeof jQuery !== \"undefined\") {\n            jQueryInstance = jQuery;\n        }\n        (function(factory) {\n            // Support three module loading scenarios\n            if (typeof define === 'function' && define['amd']) {\n                // [1] AMD anonymous module\n                define(['exports', 'require'], factory);\n            } else if (typeof exports === 'object' && typeof module === 'object') {\n                // [2] CommonJS/Node.js\n                factory(module['exports'] || exports);  // module.exports is for Node.js\n            } else {\n                // [3] No module loader (plain <script> tag) - put directly in global namespace\n                factory(window['ko'] = {});\n            }\n        }(function(koExports, amdRequire){\n// Internally, all KO objects are attached to koExports (even the non-exported ones whose names will be minified by the closure compiler).\n// In the future, the following \"ko\" variable may be made distinct from \"koExports\" so that private objects are not externally reachable.\n            var ko = typeof koExports !== 'undefined' ? koExports : {};\n// Google Closure Compiler helpers (used only to make the minified file smaller)\n            ko.exportSymbol = function(koPath, object) {\n                var tokens = koPath.split(\".\");\n\n                // In the future, \"ko\" may become distinct from \"koExports\" (so that non-exported objects are not reachable)\n                // At that point, \"target\" would be set to: (typeof koExports !== \"undefined\" ? koExports : ko)\n                var target = ko;\n\n                for (var i = 0; i < tokens.length - 1; i++)\n                    target = target[tokens[i]];\n                target[tokens[tokens.length - 1]] = object;\n            };\n            ko.exportProperty = function(owner, publicName, object) {\n                owner[publicName] = object;\n            };\n            ko.version = \"3.5.1\";\n\n            ko.exportSymbol('version', ko.version);\n// For any options that may affect various areas of Knockout and aren't directly associated with data binding.\n            ko.options = {\n                'deferUpdates': false,\n                'useOnlyNativeEvents': false,\n                'foreachHidesDestroyed': false\n            };\n\n//ko.exportSymbol('options', ko.options);   // 'options' isn't minified\n            ko.utils = (function () {\n                var hasOwnProperty = Object.prototype.hasOwnProperty;\n\n                function objectForEach(obj, action) {\n                    for (var prop in obj) {\n                        if (hasOwnProperty.call(obj, prop)) {\n                            action(prop, obj[prop]);\n                        }\n                    }\n                }\n\n                function extend(target, source) {\n                    if (source) {\n                        for(var prop in source) {\n                            if(hasOwnProperty.call(source, prop)) {\n                                target[prop] = source[prop];\n                            }\n                        }\n                    }\n                    return target;\n                }\n\n                function setPrototypeOf(obj, proto) {\n                    obj.__proto__ = proto;\n                    return obj;\n                }\n\n                var canSetPrototype = ({ __proto__: [] } instanceof Array);\n                var canUseSymbols = !DEBUG && typeof Symbol === 'function';\n\n                // Represent the known event types in a compact way, then at runtime transform it into a hash with event name as key (for fast lookup)\n                var knownEvents = {}, knownEventTypesByEventName = {};\n                var keyEventTypeName = (navigator && /Firefox\\/2/i.test(navigator.userAgent)) ? 'KeyboardEvent' : 'UIEvents';\n                knownEvents[keyEventTypeName] = ['keyup', 'keydown', 'keypress'];\n                knownEvents['MouseEvents'] = ['click', 'dblclick', 'mousedown', 'mouseup', 'mousemove', 'mouseover', 'mouseout', 'mouseenter', 'mouseleave'];\n                objectForEach(knownEvents, function(eventType, knownEventsForType) {\n                    if (knownEventsForType.length) {\n                        for (var i = 0, j = knownEventsForType.length; i < j; i++)\n                            knownEventTypesByEventName[knownEventsForType[i]] = eventType;\n                    }\n                });\n                var eventsThatMustBeRegisteredUsingAttachEvent = { 'propertychange': true }; // Workaround for an IE9 issue - https://github.com/SteveSanderson/knockout/issues/406\n\n                // Detect IE versions for bug workarounds (uses IE conditionals, not UA string, for robustness)\n                // Note that, since IE 10 does not support conditional comments, the following logic only detects IE < 10.\n                // Currently this is by design, since IE 10+ behaves correctly when treated as a standard browser.\n                // If there is a future need to detect specific versions of IE10+, we will amend this.\n                var ieVersion = document && (function() {\n                    var version = 3, div = document.createElement('div'), iElems = div.getElementsByTagName('i');\n\n                    // Keep constructing conditional HTML blocks until we hit one that resolves to an empty fragment\n                    while (\n                        div.innerHTML = '<!--[if gt IE ' + (++version) + ']><i></i><![endif]-->',\n                            iElems[0]\n                        ) {}\n                    return version > 4 ? version : undefined;\n                }());\n                var isIe6 = ieVersion === 6,\n                    isIe7 = ieVersion === 7;\n\n                function isClickOnCheckableElement(element, eventType) {\n                    if ((ko.utils.tagNameLower(element) !== \"input\") || !element.type) return false;\n                    if (eventType.toLowerCase() != \"click\") return false;\n                    var inputType = element.type;\n                    return (inputType == \"checkbox\") || (inputType == \"radio\");\n                }\n\n                // For details on the pattern for changing node classes\n                // see: https://github.com/knockout/knockout/issues/1597\n                var cssClassNameRegex = /\\S+/g;\n\n                var jQueryEventAttachName;\n\n                function toggleDomNodeCssClass(node, classNames, shouldHaveClass) {\n                    var addOrRemoveFn;\n                    if (classNames) {\n                        if (typeof node.classList === 'object') {\n                            addOrRemoveFn = node.classList[shouldHaveClass ? 'add' : 'remove'];\n                            ko.utils.arrayForEach(classNames.match(cssClassNameRegex), function(className) {\n                                addOrRemoveFn.call(node.classList, className);\n                            });\n                        } else if (typeof node.className['baseVal'] === 'string') {\n                            // SVG tag .classNames is an SVGAnimatedString instance\n                            toggleObjectClassPropertyString(node.className, 'baseVal', classNames, shouldHaveClass);\n                        } else {\n                            // node.className ought to be a string.\n                            toggleObjectClassPropertyString(node, 'className', classNames, shouldHaveClass);\n                        }\n                    }\n                }\n\n                function toggleObjectClassPropertyString(obj, prop, classNames, shouldHaveClass) {\n                    // obj/prop is either a node/'className' or a SVGAnimatedString/'baseVal'.\n                    var currentClassNames = obj[prop].match(cssClassNameRegex) || [];\n                    ko.utils.arrayForEach(classNames.match(cssClassNameRegex), function(className) {\n                        ko.utils.addOrRemoveItem(currentClassNames, className, shouldHaveClass);\n                    });\n                    obj[prop] = currentClassNames.join(\" \");\n                }\n\n                return {\n                    fieldsIncludedWithJsonPost: ['authenticity_token', /^__RequestVerificationToken(_.*)?$/],\n\n                    arrayForEach: function (array, action, actionOwner) {\n                        for (var i = 0, j = array.length; i < j; i++) {\n                            action.call(actionOwner, array[i], i, array);\n                        }\n                    },\n\n                    arrayIndexOf: typeof Array.prototype.indexOf == \"function\"\n                        ? function (array, item) {\n                            return Array.prototype.indexOf.call(array, item);\n                        }\n                        : function (array, item) {\n                            for (var i = 0, j = array.length; i < j; i++) {\n                                if (array[i] === item)\n                                    return i;\n                            }\n                            return -1;\n                        },\n\n                    arrayFirst: function (array, predicate, predicateOwner) {\n                        for (var i = 0, j = array.length; i < j; i++) {\n                            if (predicate.call(predicateOwner, array[i], i, array))\n                                return array[i];\n                        }\n                        return undefined;\n                    },\n\n                    arrayRemoveItem: function (array, itemToRemove) {\n                        var index = ko.utils.arrayIndexOf(array, itemToRemove);\n                        if (index > 0) {\n                            array.splice(index, 1);\n                        }\n                        else if (index === 0) {\n                            array.shift();\n                        }\n                    },\n\n                    arrayGetDistinctValues: function (array) {\n                        var result = [];\n                        if (array) {\n                            ko.utils.arrayForEach(array, function(item) {\n                                if (ko.utils.arrayIndexOf(result, item) < 0)\n                                    result.push(item);\n                            });\n                        }\n                        return result;\n                    },\n\n                    arrayMap: function (array, mapping, mappingOwner) {\n                        var result = [];\n                        if (array) {\n                            for (var i = 0, j = array.length; i < j; i++)\n                                result.push(mapping.call(mappingOwner, array[i], i));\n                        }\n                        return result;\n                    },\n\n                    arrayFilter: function (array, predicate, predicateOwner) {\n                        var result = [];\n                        if (array) {\n                            for (var i = 0, j = array.length; i < j; i++)\n                                if (predicate.call(predicateOwner, array[i], i))\n                                    result.push(array[i]);\n                        }\n                        return result;\n                    },\n\n                    arrayPushAll: function (array, valuesToPush) {\n                        if (valuesToPush instanceof Array)\n                            array.push.apply(array, valuesToPush);\n                        else\n                            for (var i = 0, j = valuesToPush.length; i < j; i++)\n                                array.push(valuesToPush[i]);\n                        return array;\n                    },\n\n                    addOrRemoveItem: function(array, value, included) {\n                        var existingEntryIndex = ko.utils.arrayIndexOf(ko.utils.peekObservable(array), value);\n                        if (existingEntryIndex < 0) {\n                            if (included)\n                                array.push(value);\n                        } else {\n                            if (!included)\n                                array.splice(existingEntryIndex, 1);\n                        }\n                    },\n\n                    canSetPrototype: canSetPrototype,\n\n                    extend: extend,\n\n                    setPrototypeOf: setPrototypeOf,\n\n                    setPrototypeOfOrExtend: canSetPrototype ? setPrototypeOf : extend,\n\n                    objectForEach: objectForEach,\n\n                    objectMap: function(source, mapping, mappingOwner) {\n                        if (!source)\n                            return source;\n                        var target = {};\n                        for (var prop in source) {\n                            if (hasOwnProperty.call(source, prop)) {\n                                target[prop] = mapping.call(mappingOwner, source[prop], prop, source);\n                            }\n                        }\n                        return target;\n                    },\n\n                    emptyDomNode: function (domNode) {\n                        while (domNode.firstChild) {\n                            ko.removeNode(domNode.firstChild);\n                        }\n                    },\n\n                    moveCleanedNodesToContainerElement: function(nodes) {\n                        // Ensure it's a real array, as we're about to reparent the nodes and\n                        // we don't want the underlying collection to change while we're doing that.\n                        var nodesArray = ko.utils.makeArray(nodes);\n                        var templateDocument = (nodesArray[0] && nodesArray[0].ownerDocument) || document;\n\n                        var container = templateDocument.createElement('div');\n                        for (var i = 0, j = nodesArray.length; i < j; i++) {\n                            container.appendChild(ko.cleanNode(nodesArray[i]));\n                        }\n                        return container;\n                    },\n\n                    cloneNodes: function (nodesArray, shouldCleanNodes) {\n                        for (var i = 0, j = nodesArray.length, newNodesArray = []; i < j; i++) {\n                            var clonedNode = nodesArray[i].cloneNode(true);\n                            newNodesArray.push(shouldCleanNodes ? ko.cleanNode(clonedNode) : clonedNode);\n                        }\n                        return newNodesArray;\n                    },\n\n                    setDomNodeChildren: function (domNode, childNodes) {\n                        ko.utils.emptyDomNode(domNode);\n                        if (childNodes) {\n                            for (var i = 0, j = childNodes.length; i < j; i++)\n                                domNode.appendChild(childNodes[i]);\n                        }\n                    },\n\n                    replaceDomNodes: function (nodeToReplaceOrNodeArray, newNodesArray) {\n                        var nodesToReplaceArray = nodeToReplaceOrNodeArray.nodeType ? [nodeToReplaceOrNodeArray] : nodeToReplaceOrNodeArray;\n                        if (nodesToReplaceArray.length > 0) {\n                            var insertionPoint = nodesToReplaceArray[0];\n                            var parent = insertionPoint.parentNode;\n                            for (var i = 0, j = newNodesArray.length; i < j; i++)\n                                parent.insertBefore(newNodesArray[i], insertionPoint);\n                            for (var i = 0, j = nodesToReplaceArray.length; i < j; i++) {\n                                ko.removeNode(nodesToReplaceArray[i]);\n                            }\n                        }\n                    },\n\n                    fixUpContinuousNodeArray: function(continuousNodeArray, parentNode) {\n                        // Before acting on a set of nodes that were previously outputted by a template function, we have to reconcile\n                        // them against what is in the DOM right now. It may be that some of the nodes have already been removed, or that\n                        // new nodes might have been inserted in the middle, for example by a binding. Also, there may previously have been\n                        // leading comment nodes (created by rewritten string-based templates) that have since been removed during binding.\n                        // So, this function translates the old \"map\" output array into its best guess of the set of current DOM nodes.\n                        //\n                        // Rules:\n                        //   [A] Any leading nodes that have been removed should be ignored\n                        //       These most likely correspond to memoization nodes that were already removed during binding\n                        //       See https://github.com/knockout/knockout/pull/440\n                        //   [B] Any trailing nodes that have been remove should be ignored\n                        //       This prevents the code here from adding unrelated nodes to the array while processing rule [C]\n                        //       See https://github.com/knockout/knockout/pull/1903\n                        //   [C] We want to output a continuous series of nodes. So, ignore any nodes that have already been removed,\n                        //       and include any nodes that have been inserted among the previous collection\n\n                        if (continuousNodeArray.length) {\n                            // The parent node can be a virtual element; so get the real parent node\n                            parentNode = (parentNode.nodeType === 8 && parentNode.parentNode) || parentNode;\n\n                            // Rule [A]\n                            while (continuousNodeArray.length && continuousNodeArray[0].parentNode !== parentNode)\n                                continuousNodeArray.splice(0, 1);\n\n                            // Rule [B]\n                            while (continuousNodeArray.length > 1 && continuousNodeArray[continuousNodeArray.length - 1].parentNode !== parentNode)\n                                continuousNodeArray.length--;\n\n                            // Rule [C]\n                            if (continuousNodeArray.length > 1) {\n                                var current = continuousNodeArray[0], last = continuousNodeArray[continuousNodeArray.length - 1];\n                                // Replace with the actual new continuous node set\n                                continuousNodeArray.length = 0;\n                                while (current !== last) {\n                                    continuousNodeArray.push(current);\n                                    current = current.nextSibling;\n                                }\n                                continuousNodeArray.push(last);\n                            }\n                        }\n                        return continuousNodeArray;\n                    },\n\n                    setOptionNodeSelectionState: function (optionNode, isSelected) {\n                        // IE6 sometimes throws \"unknown error\" if you try to write to .selected directly, whereas Firefox struggles with setAttribute. Pick one based on browser.\n                        if (ieVersion < 7)\n                            optionNode.setAttribute(\"selected\", isSelected);\n                        else\n                            optionNode.selected = isSelected;\n                    },\n\n                    stringTrim: function (string) {\n                        return string === null || string === undefined ? '' :\n                            string.trim ?\n                                string.trim() :\n                                string.toString().replace(/^[\\s\\xa0]+|[\\s\\xa0]+$/g, '');\n                    },\n\n                    stringStartsWith: function (string, startsWith) {\n                        string = string || \"\";\n                        if (startsWith.length > string.length)\n                            return false;\n                        return string.substring(0, startsWith.length) === startsWith;\n                    },\n\n                    domNodeIsContainedBy: function (node, containedByNode) {\n                        if (node === containedByNode)\n                            return true;\n                        if (node.nodeType === 11)\n                            return false; // Fixes issue #1162 - can't use node.contains for document fragments on IE8\n                        if (containedByNode.contains)\n                            return containedByNode.contains(node.nodeType !== 1 ? node.parentNode : node);\n                        if (containedByNode.compareDocumentPosition)\n                            return (containedByNode.compareDocumentPosition(node) & 16) == 16;\n                        while (node && node != containedByNode) {\n                            node = node.parentNode;\n                        }\n                        return !!node;\n                    },\n\n                    domNodeIsAttachedToDocument: function (node) {\n                        return ko.utils.domNodeIsContainedBy(node, node.ownerDocument.documentElement);\n                    },\n\n                    anyDomNodeIsAttachedToDocument: function(nodes) {\n                        return !!ko.utils.arrayFirst(nodes, ko.utils.domNodeIsAttachedToDocument);\n                    },\n\n                    tagNameLower: function(element) {\n                        // For HTML elements, tagName will always be upper case; for XHTML elements, it'll be lower case.\n                        // Possible future optimization: If we know it's an element from an XHTML document (not HTML),\n                        // we don't need to do the .toLowerCase() as it will always be lower case anyway.\n                        return element && element.tagName && element.tagName.toLowerCase();\n                    },\n\n                    catchFunctionErrors: function (delegate) {\n                        return ko['onError'] ? function () {\n                            try {\n                                return delegate.apply(this, arguments);\n                            } catch (e) {\n                                ko['onError'] && ko['onError'](e);\n                                throw e;\n                            }\n                        } : delegate;\n                    },\n\n                    setTimeout: function (handler, timeout) {\n                        return setTimeout(ko.utils.catchFunctionErrors(handler), timeout);\n                    },\n\n                    deferError: function (error) {\n                        setTimeout(function () {\n                            ko['onError'] && ko['onError'](error);\n                            throw error;\n                        }, 0);\n                    },\n\n                    registerEventHandler: function (element, eventType, handler) {\n                        var wrappedHandler = ko.utils.catchFunctionErrors(handler);\n\n                        var mustUseAttachEvent = eventsThatMustBeRegisteredUsingAttachEvent[eventType];\n                        if (!ko.options['useOnlyNativeEvents'] && !mustUseAttachEvent && jQueryInstance) {\n                            if (!jQueryEventAttachName) {\n                                jQueryEventAttachName = (typeof jQueryInstance(element)['on'] == 'function') ? 'on' : 'bind';\n                            }\n                            jQueryInstance(element)[jQueryEventAttachName](eventType, wrappedHandler);\n                        } else if (!mustUseAttachEvent && typeof element.addEventListener == \"function\")\n                            element.addEventListener(eventType, wrappedHandler, false);\n                        else if (typeof element.attachEvent != \"undefined\") {\n                            var attachEventHandler = function (event) { wrappedHandler.call(element, event); },\n                                attachEventName = \"on\" + eventType;\n                            element.attachEvent(attachEventName, attachEventHandler);\n\n                            // IE does not dispose attachEvent handlers automatically (unlike with addEventListener)\n                            // so to avoid leaks, we have to remove them manually. See bug #856\n                            ko.utils.domNodeDisposal.addDisposeCallback(element, function() {\n                                element.detachEvent(attachEventName, attachEventHandler);\n                            });\n                        } else\n                            throw new Error(\"Browser doesn't support addEventListener or attachEvent\");\n                    },\n\n                    triggerEvent: function (element, eventType) {\n                        if (!(element && element.nodeType))\n                            throw new Error(\"element must be a DOM node when calling triggerEvent\");\n\n                        // For click events on checkboxes and radio buttons, jQuery toggles the element checked state *after* the\n                        // event handler runs instead of *before*. (This was fixed in 1.9 for checkboxes but not for radio buttons.)\n                        // IE doesn't change the checked state when you trigger the click event using \"fireEvent\".\n                        // In both cases, we'll use the click method instead.\n                        var useClickWorkaround = isClickOnCheckableElement(element, eventType);\n\n                        if (!ko.options['useOnlyNativeEvents'] && jQueryInstance && !useClickWorkaround) {\n                            jQueryInstance(element)['trigger'](eventType);\n                        } else if (typeof document.createEvent == \"function\") {\n                            if (typeof element.dispatchEvent == \"function\") {\n                                var eventCategory = knownEventTypesByEventName[eventType] || \"HTMLEvents\";\n                                var event = document.createEvent(eventCategory);\n                                event.initEvent(eventType, true, true, window, 0, 0, 0, 0, 0, false, false, false, false, 0, element);\n                                element.dispatchEvent(event);\n                            }\n                            else\n                                throw new Error(\"The supplied element doesn't support dispatchEvent\");\n                        } else if (useClickWorkaround && element.click) {\n                            element.click();\n                        } else if (typeof element.fireEvent != \"undefined\") {\n                            element.fireEvent(\"on\" + eventType);\n                        } else {\n                            throw new Error(\"Browser doesn't support triggering events\");\n                        }\n                    },\n\n                    unwrapObservable: function (value) {\n                        return ko.isObservable(value) ? value() : value;\n                    },\n\n                    peekObservable: function (value) {\n                        return ko.isObservable(value) ? value.peek() : value;\n                    },\n\n                    toggleDomNodeCssClass: toggleDomNodeCssClass,\n\n                    setTextContent: function(element, textContent) {\n                        var value = ko.utils.unwrapObservable(textContent);\n                        if ((value === null) || (value === undefined))\n                            value = \"\";\n\n                        // We need there to be exactly one child: a text node.\n                        // If there are no children, more than one, or if it's not a text node,\n                        // we'll clear everything and create a single text node.\n                        var innerTextNode = ko.virtualElements.firstChild(element);\n                        if (!innerTextNode || innerTextNode.nodeType != 3 || ko.virtualElements.nextSibling(innerTextNode)) {\n                            ko.virtualElements.setDomNodeChildren(element, [element.ownerDocument.createTextNode(value)]);\n                        } else {\n                            innerTextNode.data = value;\n                        }\n\n                        ko.utils.forceRefresh(element);\n                    },\n\n                    setElementName: function(element, name) {\n                        element.name = name;\n\n                        // Workaround IE 6/7 issue\n                        // - https://github.com/SteveSanderson/knockout/issues/197\n                        // - http://www.matts411.com/post/setting_the_name_attribute_in_ie_dom/\n                        if (ieVersion <= 7) {\n                            try {\n                                var escapedName = element.name.replace(/[&<>'\"]/g, function(r){ return \"&#\" + r.charCodeAt(0) + \";\"; });\n                                element.mergeAttributes(document.createElement(\"<input name='\" + escapedName + \"'/>\"), false);\n                            }\n                            catch(e) {} // For IE9 with doc mode \"IE9 Standards\" and browser mode \"IE9 Compatibility View\"\n                        }\n                    },\n\n                    forceRefresh: function(node) {\n                        // Workaround for an IE9 rendering bug - https://github.com/SteveSanderson/knockout/issues/209\n                        if (ieVersion >= 9) {\n                            // For text nodes and comment nodes (most likely virtual elements), we will have to refresh the container\n                            var elem = node.nodeType == 1 ? node : node.parentNode;\n                            if (elem.style)\n                                elem.style.zoom = elem.style.zoom;\n                        }\n                    },\n\n                    ensureSelectElementIsRenderedCorrectly: function(selectElement) {\n                        // Workaround for IE9 rendering bug - it doesn't reliably display all the text in dynamically-added select boxes unless you force it to re-render by updating the width.\n                        // (See https://github.com/SteveSanderson/knockout/issues/312, http://stackoverflow.com/questions/5908494/select-only-shows-first-char-of-selected-option)\n                        // Also fixes IE7 and IE8 bug that causes selects to be zero width if enclosed by 'if' or 'with'. (See issue #839)\n                        if (ieVersion) {\n                            var originalWidth = selectElement.style.width;\n                            selectElement.style.width = 0;\n                            selectElement.style.width = originalWidth;\n                        }\n                    },\n\n                    range: function (min, max) {\n                        min = ko.utils.unwrapObservable(min);\n                        max = ko.utils.unwrapObservable(max);\n                        var result = [];\n                        for (var i = min; i <= max; i++)\n                            result.push(i);\n                        return result;\n                    },\n\n                    makeArray: function(arrayLikeObject) {\n                        var result = [];\n                        for (var i = 0, j = arrayLikeObject.length; i < j; i++) {\n                            result.push(arrayLikeObject[i]);\n                        };\n                        return result;\n                    },\n\n                    createSymbolOrString: function(identifier) {\n                        return canUseSymbols ? Symbol(identifier) : identifier;\n                    },\n\n                    isIe6 : isIe6,\n                    isIe7 : isIe7,\n                    ieVersion : ieVersion,\n\n                    getFormFields: function(form, fieldName) {\n                        var fields = ko.utils.makeArray(form.getElementsByTagName(\"input\")).concat(ko.utils.makeArray(form.getElementsByTagName(\"textarea\")));\n                        var isMatchingField = (typeof fieldName == 'string')\n                            ? function(field) { return field.name === fieldName }\n                            : function(field) { return fieldName.test(field.name) }; // Treat fieldName as regex or object containing predicate\n                        var matches = [];\n                        for (var i = fields.length - 1; i >= 0; i--) {\n                            if (isMatchingField(fields[i]))\n                                matches.push(fields[i]);\n                        };\n                        return matches;\n                    },\n\n                    parseJson: function (jsonString) {\n                        if (typeof jsonString == \"string\") {\n                            jsonString = ko.utils.stringTrim(jsonString);\n                            if (jsonString) {\n                                if (JSON && JSON.parse) // Use native parsing where available\n                                    return JSON.parse(jsonString);\n                                return (new Function(\"return \" + jsonString))(); // Fallback on less safe parsing for older browsers\n                            }\n                        }\n                        return null;\n                    },\n\n                    stringifyJson: function (data, replacer, space) {   // replacer and space are optional\n                        if (!JSON || !JSON.stringify)\n                            throw new Error(\"Cannot find JSON.stringify(). Some browsers (e.g., IE < 8) don't support it natively, but you can overcome this by adding a script reference to json2.js, downloadable from http://www.json.org/json2.js\");\n                        return JSON.stringify(ko.utils.unwrapObservable(data), replacer, space);\n                    },\n\n                    postJson: function (urlOrForm, data, options) {\n                        options = options || {};\n                        var params = options['params'] || {};\n                        var includeFields = options['includeFields'] || this.fieldsIncludedWithJsonPost;\n                        var url = urlOrForm;\n\n                        // If we were given a form, use its 'action' URL and pick out any requested field values\n                        if((typeof urlOrForm == 'object') && (ko.utils.tagNameLower(urlOrForm) === \"form\")) {\n                            var originalForm = urlOrForm;\n                            url = originalForm.action;\n                            for (var i = includeFields.length - 1; i >= 0; i--) {\n                                var fields = ko.utils.getFormFields(originalForm, includeFields[i]);\n                                for (var j = fields.length - 1; j >= 0; j--)\n                                    params[fields[j].name] = fields[j].value;\n                            }\n                        }\n\n                        data = ko.utils.unwrapObservable(data);\n                        var form = document.createElement(\"form\");\n                        form.style.display = \"none\";\n                        form.action = url;\n                        form.method = \"post\";\n                        for (var key in data) {\n                            // Since 'data' this is a model object, we include all properties including those inherited from its prototype\n                            var input = document.createElement(\"input\");\n                            input.type = \"hidden\";\n                            input.name = key;\n                            input.value = ko.utils.stringifyJson(ko.utils.unwrapObservable(data[key]));\n                            form.appendChild(input);\n                        }\n                        objectForEach(params, function(key, value) {\n                            var input = document.createElement(\"input\");\n                            input.type = \"hidden\";\n                            input.name = key;\n                            input.value = value;\n                            form.appendChild(input);\n                        });\n                        document.body.appendChild(form);\n                        options['submitter'] ? options['submitter'](form) : form.submit();\n                        setTimeout(function () { form.parentNode.removeChild(form); }, 0);\n                    }\n                }\n            }());\n\n            ko.exportSymbol('utils', ko.utils);\n            ko.exportSymbol('utils.arrayForEach', ko.utils.arrayForEach);\n            ko.exportSymbol('utils.arrayFirst', ko.utils.arrayFirst);\n            ko.exportSymbol('utils.arrayFilter', ko.utils.arrayFilter);\n            ko.exportSymbol('utils.arrayGetDistinctValues', ko.utils.arrayGetDistinctValues);\n            ko.exportSymbol('utils.arrayIndexOf', ko.utils.arrayIndexOf);\n            ko.exportSymbol('utils.arrayMap', ko.utils.arrayMap);\n            ko.exportSymbol('utils.arrayPushAll', ko.utils.arrayPushAll);\n            ko.exportSymbol('utils.arrayRemoveItem', ko.utils.arrayRemoveItem);\n            ko.exportSymbol('utils.cloneNodes', ko.utils.cloneNodes);\n            ko.exportSymbol('utils.createSymbolOrString', ko.utils.createSymbolOrString);\n            ko.exportSymbol('utils.extend', ko.utils.extend);\n            ko.exportSymbol('utils.fieldsIncludedWithJsonPost', ko.utils.fieldsIncludedWithJsonPost);\n            ko.exportSymbol('utils.getFormFields', ko.utils.getFormFields);\n            ko.exportSymbol('utils.objectMap', ko.utils.objectMap);\n            ko.exportSymbol('utils.peekObservable', ko.utils.peekObservable);\n            ko.exportSymbol('utils.postJson', ko.utils.postJson);\n            ko.exportSymbol('utils.parseJson', ko.utils.parseJson);\n            ko.exportSymbol('utils.registerEventHandler', ko.utils.registerEventHandler);\n            ko.exportSymbol('utils.stringifyJson', ko.utils.stringifyJson);\n            ko.exportSymbol('utils.range', ko.utils.range);\n            ko.exportSymbol('utils.toggleDomNodeCssClass', ko.utils.toggleDomNodeCssClass);\n            ko.exportSymbol('utils.triggerEvent', ko.utils.triggerEvent);\n            ko.exportSymbol('utils.unwrapObservable', ko.utils.unwrapObservable);\n            ko.exportSymbol('utils.objectForEach', ko.utils.objectForEach);\n            ko.exportSymbol('utils.addOrRemoveItem', ko.utils.addOrRemoveItem);\n            ko.exportSymbol('utils.setTextContent', ko.utils.setTextContent);\n            ko.exportSymbol('unwrap', ko.utils.unwrapObservable); // Convenient shorthand, because this is used so commonly\n\n            if (!Function.prototype['bind']) {\n                // Function.prototype.bind is a standard part of ECMAScript 5th Edition (December 2009, http://www.ecma-international.org/publications/files/ECMA-ST/ECMA-262.pdf)\n                // In case the browser doesn't implement it natively, provide a JavaScript implementation. This implementation is based on the one in prototype.js\n                Function.prototype['bind'] = function (object) {\n                    var originalFunction = this;\n                    if (arguments.length === 1) {\n                        return function () {\n                            return originalFunction.apply(object, arguments);\n                        };\n                    } else {\n                        var partialArgs = Array.prototype.slice.call(arguments, 1);\n                        return function () {\n                            var args = partialArgs.slice(0);\n                            args.push.apply(args, arguments);\n                            return originalFunction.apply(object, args);\n                        };\n                    }\n                };\n            }\n\n            ko.utils.domData = new (function () {\n                var uniqueId = 0;\n                var dataStoreKeyExpandoPropertyName = \"__ko__\" + (new Date).getTime();\n                var dataStore = {};\n\n                var getDataForNode, clear;\n                if (!ko.utils.ieVersion) {\n                    // We considered using WeakMap, but it has a problem in IE 11 and Edge that prevents using\n                    // it cross-window, so instead we just store the data directly on the node.\n                    // See https://github.com/knockout/knockout/issues/2141\n                    getDataForNode = function (node, createIfNotFound) {\n                        var dataForNode = node[dataStoreKeyExpandoPropertyName];\n                        if (!dataForNode && createIfNotFound) {\n                            dataForNode = node[dataStoreKeyExpandoPropertyName] = {};\n                        }\n                        return dataForNode;\n                    };\n                    clear = function (node) {\n                        if (node[dataStoreKeyExpandoPropertyName]) {\n                            delete node[dataStoreKeyExpandoPropertyName];\n                            return true; // Exposing \"did clean\" flag purely so specs can infer whether things have been cleaned up as intended\n                        }\n                        return false;\n                    };\n                } else {\n                    // Old IE versions have memory issues if you store objects on the node, so we use a\n                    // separate data storage and link to it from the node using a string key.\n                    getDataForNode = function (node, createIfNotFound) {\n                        var dataStoreKey = node[dataStoreKeyExpandoPropertyName];\n                        var hasExistingDataStore = dataStoreKey && (dataStoreKey !== \"null\") && dataStore[dataStoreKey];\n                        if (!hasExistingDataStore) {\n                            if (!createIfNotFound)\n                                return undefined;\n                            dataStoreKey = node[dataStoreKeyExpandoPropertyName] = \"ko\" + uniqueId++;\n                            dataStore[dataStoreKey] = {};\n                        }\n                        return dataStore[dataStoreKey];\n                    };\n                    clear = function (node) {\n                        var dataStoreKey = node[dataStoreKeyExpandoPropertyName];\n                        if (dataStoreKey) {\n                            delete dataStore[dataStoreKey];\n                            node[dataStoreKeyExpandoPropertyName] = null;\n                            return true; // Exposing \"did clean\" flag purely so specs can infer whether things have been cleaned up as intended\n                        }\n                        return false;\n                    };\n                }\n\n                return {\n                    get: function (node, key) {\n                        var dataForNode = getDataForNode(node, false);\n                        return dataForNode && dataForNode[key];\n                    },\n                    set: function (node, key, value) {\n                        // Make sure we don't actually create a new domData key if we are actually deleting a value\n                        var dataForNode = getDataForNode(node, value !== undefined /* createIfNotFound */);\n                        dataForNode && (dataForNode[key] = value);\n                    },\n                    getOrSet: function (node, key, value) {\n                        var dataForNode = getDataForNode(node, true /* createIfNotFound */);\n                        return dataForNode[key] || (dataForNode[key] = value);\n                    },\n                    clear: clear,\n\n                    nextKey: function () {\n                        return (uniqueId++) + dataStoreKeyExpandoPropertyName;\n                    }\n                };\n            })();\n\n            ko.exportSymbol('utils.domData', ko.utils.domData);\n            ko.exportSymbol('utils.domData.clear', ko.utils.domData.clear); // Exporting only so specs can clear up after themselves fully\n\n            ko.utils.domNodeDisposal = new (function () {\n                var domDataKey = ko.utils.domData.nextKey();\n                var cleanableNodeTypes = { 1: true, 8: true, 9: true };       // Element, Comment, Document\n                var cleanableNodeTypesWithDescendants = { 1: true, 9: true }; // Element, Document\n\n                function getDisposeCallbacksCollection(node, createIfNotFound) {\n                    var allDisposeCallbacks = ko.utils.domData.get(node, domDataKey);\n                    if ((allDisposeCallbacks === undefined) && createIfNotFound) {\n                        allDisposeCallbacks = [];\n                        ko.utils.domData.set(node, domDataKey, allDisposeCallbacks);\n                    }\n                    return allDisposeCallbacks;\n                }\n                function destroyCallbacksCollection(node) {\n                    ko.utils.domData.set(node, domDataKey, undefined);\n                }\n\n                function cleanSingleNode(node) {\n                    // Run all the dispose callbacks\n                    var callbacks = getDisposeCallbacksCollection(node, false);\n                    if (callbacks) {\n                        callbacks = callbacks.slice(0); // Clone, as the array may be modified during iteration (typically, callbacks will remove themselves)\n                        for (var i = 0; i < callbacks.length; i++)\n                            callbacks[i](node);\n                    }\n\n                    // Erase the DOM data\n                    ko.utils.domData.clear(node);\n\n                    // Perform cleanup needed by external libraries (currently only jQuery, but can be extended)\n                    ko.utils.domNodeDisposal[\"cleanExternalData\"](node);\n\n                    // Clear any immediate-child comment nodes, as these wouldn't have been found by\n                    // node.getElementsByTagName(\"*\") in cleanNode() (comment nodes aren't elements)\n                    if (cleanableNodeTypesWithDescendants[node.nodeType]) {\n                        cleanNodesInList(node.childNodes, true/*onlyComments*/);\n                    }\n                }\n\n                function cleanNodesInList(nodeList, onlyComments) {\n                    var cleanedNodes = [], lastCleanedNode;\n                    for (var i = 0; i < nodeList.length; i++) {\n                        if (!onlyComments || nodeList[i].nodeType === 8) {\n                            cleanSingleNode(cleanedNodes[cleanedNodes.length] = lastCleanedNode = nodeList[i]);\n                            if (nodeList[i] !== lastCleanedNode) {\n                                while (i-- && ko.utils.arrayIndexOf(cleanedNodes, nodeList[i]) == -1) {}\n                            }\n                        }\n                    }\n                }\n\n                return {\n                    addDisposeCallback : function(node, callback) {\n                        if (typeof callback != \"function\")\n                            throw new Error(\"Callback must be a function\");\n                        getDisposeCallbacksCollection(node, true).push(callback);\n                    },\n\n                    removeDisposeCallback : function(node, callback) {\n                        var callbacksCollection = getDisposeCallbacksCollection(node, false);\n                        if (callbacksCollection) {\n                            ko.utils.arrayRemoveItem(callbacksCollection, callback);\n                            if (callbacksCollection.length == 0)\n                                destroyCallbacksCollection(node);\n                        }\n                    },\n\n                    cleanNode : function(node) {\n                        ko.dependencyDetection.ignore(function () {\n                            // First clean this node, where applicable\n                            if (cleanableNodeTypes[node.nodeType]) {\n                                cleanSingleNode(node);\n\n                                // ... then its descendants, where applicable\n                                if (cleanableNodeTypesWithDescendants[node.nodeType]) {\n                                    cleanNodesInList(node.getElementsByTagName(\"*\"));\n                                }\n                            }\n                        });\n\n                        return node;\n                    },\n\n                    removeNode : function(node) {\n                        ko.cleanNode(node);\n                        if (node.parentNode)\n                            node.parentNode.removeChild(node);\n                    },\n\n                    \"cleanExternalData\" : function (node) {\n                        // Special support for jQuery here because it's so commonly used.\n                        // Many jQuery plugins (including jquery.tmpl) store data using jQuery's equivalent of domData\n                        // so notify it to tear down any resources associated with the node & descendants here.\n                        if (jQueryInstance && (typeof jQueryInstance['cleanData'] == \"function\"))\n                            jQueryInstance['cleanData']([node]);\n                    }\n                };\n            })();\n            ko.cleanNode = ko.utils.domNodeDisposal.cleanNode; // Shorthand name for convenience\n            ko.removeNode = ko.utils.domNodeDisposal.removeNode; // Shorthand name for convenience\n            ko.exportSymbol('cleanNode', ko.cleanNode);\n            ko.exportSymbol('removeNode', ko.removeNode);\n            ko.exportSymbol('utils.domNodeDisposal', ko.utils.domNodeDisposal);\n            ko.exportSymbol('utils.domNodeDisposal.addDisposeCallback', ko.utils.domNodeDisposal.addDisposeCallback);\n            ko.exportSymbol('utils.domNodeDisposal.removeDisposeCallback', ko.utils.domNodeDisposal.removeDisposeCallback);\n            (function () {\n                var none = [0, \"\", \"\"],\n                    table = [1, \"<table>\", \"</table>\"],\n                    tbody = [2, \"<table><tbody>\", \"</tbody></table>\"],\n                    tr = [3, \"<table><tbody><tr>\", \"</tr></tbody></table>\"],\n                    select = [1, \"<select multiple='multiple'>\", \"</select>\"],\n                    lookup = {\n                        'thead': table,\n                        'tbody': table,\n                        'tfoot': table,\n                        'tr': tbody,\n                        'td': tr,\n                        'th': tr,\n                        'option': select,\n                        'optgroup': select\n                    },\n\n                    // This is needed for old IE if you're *not* using either jQuery or innerShiv. Doesn't affect other cases.\n                    mayRequireCreateElementHack = ko.utils.ieVersion <= 8;\n\n                function getWrap(tags) {\n                    var m = tags.match(/^(?:<!--.*?-->\\s*?)*?<([a-z]+)[\\s>]/);\n                    return (m && lookup[m[1]]) || none;\n                }\n\n                function simpleHtmlParse(html, documentContext) {\n                    documentContext || (documentContext = document);\n                    var windowContext = documentContext['parentWindow'] || documentContext['defaultView'] || window;\n\n                    // Based on jQuery's \"clean\" function, but only accounting for table-related elements.\n                    // If you have referenced jQuery, this won't be used anyway - KO will use jQuery's \"clean\" function directly\n\n                    // Note that there's still an issue in IE < 9 whereby it will discard comment nodes that are the first child of\n                    // a descendant node. For example: \"<div><!-- mycomment -->abc</div>\" will get parsed as \"<div>abc</div>\"\n                    // This won't affect anyone who has referenced jQuery, and there's always the workaround of inserting a dummy node\n                    // (possibly a text node) in front of the comment. So, KO does not attempt to workaround this IE issue automatically at present.\n\n                    // Trim whitespace, otherwise indexOf won't work as expected\n                    var tags = ko.utils.stringTrim(html).toLowerCase(), div = documentContext.createElement(\"div\"),\n                        wrap = getWrap(tags),\n                        depth = wrap[0];\n\n                    // Go to html and back, then peel off extra wrappers\n                    // Note that we always prefix with some dummy text, because otherwise, IE<9 will strip out leading comment nodes in descendants. Total madness.\n                    var markup = \"ignored<div>\" + wrap[1] + html + wrap[2] + \"</div>\";\n                    if (typeof windowContext['innerShiv'] == \"function\") {\n                        // Note that innerShiv is deprecated in favour of html5shiv. We should consider adding\n                        // support for html5shiv (except if no explicit support is needed, e.g., if html5shiv\n                        // somehow shims the native APIs so it just works anyway)\n                        div.appendChild(windowContext['innerShiv'](markup));\n                    } else {\n                        if (mayRequireCreateElementHack) {\n                            // The document.createElement('my-element') trick to enable custom elements in IE6-8\n                            // only works if we assign innerHTML on an element associated with that document.\n                            documentContext.body.appendChild(div);\n                        }\n\n                        div.innerHTML = markup;\n\n                        if (mayRequireCreateElementHack) {\n                            div.parentNode.removeChild(div);\n                        }\n                    }\n\n                    // Move to the right depth\n                    while (depth--)\n                        div = div.lastChild;\n\n                    return ko.utils.makeArray(div.lastChild.childNodes);\n                }\n\n                function jQueryHtmlParse(html, documentContext) {\n                    // jQuery's \"parseHTML\" function was introduced in jQuery 1.8.0 and is a documented public API.\n                    if (jQueryInstance['parseHTML']) {\n                        return jQueryInstance['parseHTML'](html, documentContext) || []; // Ensure we always return an array and never null\n                    } else {\n                        // For jQuery < 1.8.0, we fall back on the undocumented internal \"clean\" function.\n                        var elems = jQueryInstance['clean']([html], documentContext);\n\n                        // As of jQuery 1.7.1, jQuery parses the HTML by appending it to some dummy parent nodes held in an in-memory document fragment.\n                        // Unfortunately, it never clears the dummy parent nodes from the document fragment, so it leaks memory over time.\n                        // Fix this by finding the top-most dummy parent element, and detaching it from its owner fragment.\n                        if (elems && elems[0]) {\n                            // Find the top-most parent element that's a direct child of a document fragment\n                            var elem = elems[0];\n                            while (elem.parentNode && elem.parentNode.nodeType !== 11 /* i.e., DocumentFragment */)\n                                elem = elem.parentNode;\n                            // ... then detach it\n                            if (elem.parentNode)\n                                elem.parentNode.removeChild(elem);\n                        }\n\n                        return elems;\n                    }\n                }\n\n                ko.utils.parseHtmlFragment = function(html, documentContext) {\n                    return jQueryInstance ?\n                        jQueryHtmlParse(html, documentContext) :   // As below, benefit from jQuery's optimisations where possible\n                        simpleHtmlParse(html, documentContext);  // ... otherwise, this simple logic will do in most common cases.\n                };\n\n                ko.utils.parseHtmlForTemplateNodes = function(html, documentContext) {\n                    var nodes = ko.utils.parseHtmlFragment(html, documentContext);\n                    return (nodes.length && nodes[0].parentElement) || ko.utils.moveCleanedNodesToContainerElement(nodes);\n                };\n\n                ko.utils.setHtml = function(node, html) {\n                    ko.utils.emptyDomNode(node);\n\n                    // There's no legitimate reason to display a stringified observable without unwrapping it, so we'll unwrap it\n                    html = ko.utils.unwrapObservable(html);\n\n                    if ((html !== null) && (html !== undefined)) {\n                        if (typeof html != 'string')\n                            html = html.toString();\n\n                        // jQuery contains a lot of sophisticated code to parse arbitrary HTML fragments,\n                        // for example <tr> elements which are not normally allowed to exist on their own.\n                        // If you've referenced jQuery we'll use that rather than duplicating its code.\n                        if (jQueryInstance) {\n                            jQueryInstance(node)['html'](html);\n                        } else {\n                            // ... otherwise, use KO's own parsing logic.\n                            var parsedNodes = ko.utils.parseHtmlFragment(html, node.ownerDocument);\n                            for (var i = 0; i < parsedNodes.length; i++)\n                                node.appendChild(parsedNodes[i]);\n                        }\n                    }\n                };\n            })();\n\n            ko.exportSymbol('utils.parseHtmlFragment', ko.utils.parseHtmlFragment);\n            ko.exportSymbol('utils.setHtml', ko.utils.setHtml);\n\n            ko.memoization = (function () {\n                var memos = {};\n\n                function randomMax8HexChars() {\n                    return (((1 + Math.random()) * 0x100000000) | 0).toString(16).substring(1);\n                }\n                function generateRandomId() {\n                    return randomMax8HexChars() + randomMax8HexChars();\n                }\n                function findMemoNodes(rootNode, appendToArray) {\n                    if (!rootNode)\n                        return;\n                    if (rootNode.nodeType == 8) {\n                        var memoId = ko.memoization.parseMemoText(rootNode.nodeValue);\n                        if (memoId != null)\n                            appendToArray.push({ domNode: rootNode, memoId: memoId });\n                    } else if (rootNode.nodeType == 1) {\n                        for (var i = 0, childNodes = rootNode.childNodes, j = childNodes.length; i < j; i++)\n                            findMemoNodes(childNodes[i], appendToArray);\n                    }\n                }\n\n                return {\n                    memoize: function (callback) {\n                        if (typeof callback != \"function\")\n                            throw new Error(\"You can only pass a function to ko.memoization.memoize()\");\n                        var memoId = generateRandomId();\n                        memos[memoId] = callback;\n                        return \"<!--[ko_memo:\" + memoId + \"]-->\";\n                    },\n\n                    unmemoize: function (memoId, callbackParams) {\n                        var callback = memos[memoId];\n                        if (callback === undefined)\n                            throw new Error(\"Couldn't find any memo with ID \" + memoId + \". Perhaps it's already been unmemoized.\");\n                        try {\n                            callback.apply(null, callbackParams || []);\n                            return true;\n                        }\n                        finally { delete memos[memoId]; }\n                    },\n\n                    unmemoizeDomNodeAndDescendants: function (domNode, extraCallbackParamsArray) {\n                        var memos = [];\n                        findMemoNodes(domNode, memos);\n                        for (var i = 0, j = memos.length; i < j; i++) {\n                            var node = memos[i].domNode;\n                            var combinedParams = [node];\n                            if (extraCallbackParamsArray)\n                                ko.utils.arrayPushAll(combinedParams, extraCallbackParamsArray);\n                            ko.memoization.unmemoize(memos[i].memoId, combinedParams);\n                            node.nodeValue = \"\"; // Neuter this node so we don't try to unmemoize it again\n                            if (node.parentNode)\n                                node.parentNode.removeChild(node); // If possible, erase it totally (not always possible - someone else might just hold a reference to it then call unmemoizeDomNodeAndDescendants again)\n                        }\n                    },\n\n                    parseMemoText: function (memoText) {\n                        var match = memoText.match(/^\\[ko_memo\\:(.*?)\\]$/);\n                        return match ? match[1] : null;\n                    }\n                };\n            })();\n\n            ko.exportSymbol('memoization', ko.memoization);\n            ko.exportSymbol('memoization.memoize', ko.memoization.memoize);\n            ko.exportSymbol('memoization.unmemoize', ko.memoization.unmemoize);\n            ko.exportSymbol('memoization.parseMemoText', ko.memoization.parseMemoText);\n            ko.exportSymbol('memoization.unmemoizeDomNodeAndDescendants', ko.memoization.unmemoizeDomNodeAndDescendants);\n            ko.tasks = (function () {\n                var scheduler,\n                    taskQueue = [],\n                    taskQueueLength = 0,\n                    nextHandle = 1,\n                    nextIndexToProcess = 0;\n\n                if (window['MutationObserver']) {\n                    // Chrome 27+, Firefox 14+, IE 11+, Opera 15+, Safari 6.1+\n                    // From https://github.com/petkaantonov/bluebird * Copyright (c) 2014 Petka Antonov * License: MIT\n                    scheduler = (function (callback) {\n                        var div = document.createElement(\"div\");\n                        new MutationObserver(callback).observe(div, {attributes: true});\n                        return function () { div.classList.toggle(\"foo\"); };\n                    })(scheduledProcess);\n                } else if (document && \"onreadystatechange\" in document.createElement(\"script\")) {\n                    // IE 6-10\n                    // From https://github.com/YuzuJS/setImmediate * Copyright (c) 2012 Barnesandnoble.com, llc, Donavon West, and Domenic Denicola * License: MIT\n                    scheduler = function (callback) {\n                        var script = document.createElement(\"script\");\n                        script.onreadystatechange = function () {\n                            script.onreadystatechange = null;\n                            document.documentElement.removeChild(script);\n                            script = null;\n                            callback();\n                        };\n                        document.documentElement.appendChild(script);\n                    };\n                } else {\n                    scheduler = function (callback) {\n                        setTimeout(callback, 0);\n                    };\n                }\n\n                function processTasks() {\n                    if (taskQueueLength) {\n                        // Each mark represents the end of a logical group of tasks and the number of these groups is\n                        // limited to prevent unchecked recursion.\n                        var mark = taskQueueLength, countMarks = 0;\n\n                        // nextIndexToProcess keeps track of where we are in the queue; processTasks can be called recursively without issue\n                        for (var task; nextIndexToProcess < taskQueueLength; ) {\n                            if (task = taskQueue[nextIndexToProcess++]) {\n                                if (nextIndexToProcess > mark) {\n                                    if (++countMarks >= 5000) {\n                                        nextIndexToProcess = taskQueueLength;   // skip all tasks remaining in the queue since any of them could be causing the recursion\n                                        ko.utils.deferError(Error(\"'Too much recursion' after processing \" + countMarks + \" task groups.\"));\n                                        break;\n                                    }\n                                    mark = taskQueueLength;\n                                }\n                                try {\n                                    task();\n                                } catch (ex) {\n                                    ko.utils.deferError(ex);\n                                }\n                            }\n                        }\n                    }\n                }\n\n                function scheduledProcess() {\n                    processTasks();\n\n                    // Reset the queue\n                    nextIndexToProcess = taskQueueLength = taskQueue.length = 0;\n                }\n\n                function scheduleTaskProcessing() {\n                    ko.tasks['scheduler'](scheduledProcess);\n                }\n\n                var tasks = {\n                    'scheduler': scheduler,     // Allow overriding the scheduler\n\n                    schedule: function (func) {\n                        if (!taskQueueLength) {\n                            scheduleTaskProcessing();\n                        }\n\n                        taskQueue[taskQueueLength++] = func;\n                        return nextHandle++;\n                    },\n\n                    cancel: function (handle) {\n                        var index = handle - (nextHandle - taskQueueLength);\n                        if (index >= nextIndexToProcess && index < taskQueueLength) {\n                            taskQueue[index] = null;\n                        }\n                    },\n\n                    // For testing only: reset the queue and return the previous queue length\n                    'resetForTesting': function () {\n                        var length = taskQueueLength - nextIndexToProcess;\n                        nextIndexToProcess = taskQueueLength = taskQueue.length = 0;\n                        return length;\n                    },\n\n                    runEarly: processTasks\n                };\n\n                return tasks;\n            })();\n\n            ko.exportSymbol('tasks', ko.tasks);\n            ko.exportSymbol('tasks.schedule', ko.tasks.schedule);\n//ko.exportSymbol('tasks.cancel', ko.tasks.cancel);  \"cancel\" isn't minified\n            ko.exportSymbol('tasks.runEarly', ko.tasks.runEarly);\n            ko.extenders = {\n                'throttle': function(target, timeout) {\n                    // Throttling means two things:\n\n                    // (1) For dependent observables, we throttle *evaluations* so that, no matter how fast its dependencies\n                    //     notify updates, the target doesn't re-evaluate (and hence doesn't notify) faster than a certain rate\n                    target['throttleEvaluation'] = timeout;\n\n                    // (2) For writable targets (observables, or writable dependent observables), we throttle *writes*\n                    //     so the target cannot change value synchronously or faster than a certain rate\n                    var writeTimeoutInstance = null;\n                    return ko.dependentObservable({\n                        'read': target,\n                        'write': function(value) {\n                            clearTimeout(writeTimeoutInstance);\n                            writeTimeoutInstance = ko.utils.setTimeout(function() {\n                                target(value);\n                            }, timeout);\n                        }\n                    });\n                },\n\n                'rateLimit': function(target, options) {\n                    var timeout, method, limitFunction;\n\n                    if (typeof options == 'number') {\n                        timeout = options;\n                    } else {\n                        timeout = options['timeout'];\n                        method = options['method'];\n                    }\n\n                    // rateLimit supersedes deferred updates\n                    target._deferUpdates = false;\n\n                    limitFunction = typeof method == 'function' ? method : method == 'notifyWhenChangesStop' ?  debounce : throttle;\n                    target.limit(function(callback) {\n                        return limitFunction(callback, timeout, options);\n                    });\n                },\n\n                'deferred': function(target, options) {\n                    if (options !== true) {\n                        throw new Error('The \\'deferred\\' extender only accepts the value \\'true\\', because it is not supported to turn deferral off once enabled.')\n                    }\n\n                    if (!target._deferUpdates) {\n                        target._deferUpdates = true;\n                        target.limit(function (callback) {\n                            var handle,\n                                ignoreUpdates = false;\n                            return function () {\n                                if (!ignoreUpdates) {\n                                    ko.tasks.cancel(handle);\n                                    handle = ko.tasks.schedule(callback);\n\n                                    try {\n                                        ignoreUpdates = true;\n                                        target['notifySubscribers'](undefined, 'dirty');\n                                    } finally {\n                                        ignoreUpdates = false;\n                                    }\n                                }\n                            };\n                        });\n                    }\n                },\n\n                'notify': function(target, notifyWhen) {\n                    target[\"equalityComparer\"] = notifyWhen == \"always\" ?\n                        null :  // null equalityComparer means to always notify\n                        valuesArePrimitiveAndEqual;\n                }\n            };\n\n            var primitiveTypes = { 'undefined':1, 'boolean':1, 'number':1, 'string':1 };\n            function valuesArePrimitiveAndEqual(a, b) {\n                var oldValueIsPrimitive = (a === null) || (typeof(a) in primitiveTypes);\n                return oldValueIsPrimitive ? (a === b) : false;\n            }\n\n            function throttle(callback, timeout) {\n                var timeoutInstance;\n                return function () {\n                    if (!timeoutInstance) {\n                        timeoutInstance = ko.utils.setTimeout(function () {\n                            timeoutInstance = undefined;\n                            callback();\n                        }, timeout);\n                    }\n                };\n            }\n\n            function debounce(callback, timeout) {\n                var timeoutInstance;\n                return function () {\n                    clearTimeout(timeoutInstance);\n                    timeoutInstance = ko.utils.setTimeout(callback, timeout);\n                };\n            }\n\n            function applyExtenders(requestedExtenders) {\n                var target = this;\n                if (requestedExtenders) {\n                    ko.utils.objectForEach(requestedExtenders, function(key, value) {\n                        var extenderHandler = ko.extenders[key];\n                        if (typeof extenderHandler == 'function') {\n                            target = extenderHandler(target, value) || target;\n                        }\n                    });\n                }\n                return target;\n            }\n\n            ko.exportSymbol('extenders', ko.extenders);\n\n            ko.subscription = function (target, callback, disposeCallback) {\n                this._target = target;\n                this._callback = callback;\n                this._disposeCallback = disposeCallback;\n                this._isDisposed = false;\n                this._node = null;\n                this._domNodeDisposalCallback = null;\n                ko.exportProperty(this, 'dispose', this.dispose);\n                ko.exportProperty(this, 'disposeWhenNodeIsRemoved', this.disposeWhenNodeIsRemoved);\n            };\n            ko.subscription.prototype.dispose = function () {\n                var self = this;\n                if (!self._isDisposed) {\n                    if (self._domNodeDisposalCallback) {\n                        ko.utils.domNodeDisposal.removeDisposeCallback(self._node, self._domNodeDisposalCallback);\n                    }\n                    self._isDisposed = true;\n                    self._disposeCallback();\n\n                    self._target = self._callback = self._disposeCallback = self._node = self._domNodeDisposalCallback = null;\n                }\n            };\n            ko.subscription.prototype.disposeWhenNodeIsRemoved = function (node) {\n                this._node = node;\n                ko.utils.domNodeDisposal.addDisposeCallback(node, this._domNodeDisposalCallback = this.dispose.bind(this));\n            };\n\n            ko.subscribable = function () {\n                ko.utils.setPrototypeOfOrExtend(this, ko_subscribable_fn);\n                ko_subscribable_fn.init(this);\n            }\n\n            var defaultEvent = \"change\";\n\n// Moved out of \"limit\" to avoid the extra closure\n            function limitNotifySubscribers(value, event) {\n                if (!event || event === defaultEvent) {\n                    this._limitChange(value);\n                } else if (event === 'beforeChange') {\n                    this._limitBeforeChange(value);\n                } else {\n                    this._origNotifySubscribers(value, event);\n                }\n            }\n\n            var ko_subscribable_fn = {\n                init: function(instance) {\n                    instance._subscriptions = { \"change\": [] };\n                    instance._versionNumber = 1;\n                },\n\n                subscribe: function (callback, callbackTarget, event) {\n                    var self = this;\n\n                    event = event || defaultEvent;\n                    var boundCallback = callbackTarget ? callback.bind(callbackTarget) : callback;\n\n                    var subscription = new ko.subscription(self, boundCallback, function () {\n                        ko.utils.arrayRemoveItem(self._subscriptions[event], subscription);\n                        if (self.afterSubscriptionRemove)\n                            self.afterSubscriptionRemove(event);\n                    });\n\n                    if (self.beforeSubscriptionAdd)\n                        self.beforeSubscriptionAdd(event);\n\n                    if (!self._subscriptions[event])\n                        self._subscriptions[event] = [];\n                    self._subscriptions[event].push(subscription);\n\n                    return subscription;\n                },\n\n                \"notifySubscribers\": function (valueToNotify, event) {\n                    event = event || defaultEvent;\n                    if (event === defaultEvent) {\n                        this.updateVersion();\n                    }\n                    if (this.hasSubscriptionsForEvent(event)) {\n                        var subs = event === defaultEvent && this._changeSubscriptions || this._subscriptions[event].slice(0);\n                        try {\n                            ko.dependencyDetection.begin(); // Begin suppressing dependency detection (by setting the top frame to undefined)\n                            for (var i = 0, subscription; subscription = subs[i]; ++i) {\n                                // In case a subscription was disposed during the arrayForEach cycle, check\n                                // for isDisposed on each subscription before invoking its callback\n                                if (!subscription._isDisposed)\n                                    subscription._callback(valueToNotify);\n                            }\n                        } finally {\n                            ko.dependencyDetection.end(); // End suppressing dependency detection\n                        }\n                    }\n                },\n\n                getVersion: function () {\n                    return this._versionNumber;\n                },\n\n                hasChanged: function (versionToCheck) {\n                    return this.getVersion() !== versionToCheck;\n                },\n\n                updateVersion: function () {\n                    ++this._versionNumber;\n                },\n\n                limit: function(limitFunction) {\n                    var self = this, selfIsObservable = ko.isObservable(self),\n                        ignoreBeforeChange, notifyNextChange, previousValue, pendingValue, didUpdate,\n                        beforeChange = 'beforeChange';\n\n                    if (!self._origNotifySubscribers) {\n                        self._origNotifySubscribers = self[\"notifySubscribers\"];\n                        self[\"notifySubscribers\"] = limitNotifySubscribers;\n                    }\n\n                    var finish = limitFunction(function() {\n                        self._notificationIsPending = false;\n\n                        // If an observable provided a reference to itself, access it to get the latest value.\n                        // This allows computed observables to delay calculating their value until needed.\n                        if (selfIsObservable && pendingValue === self) {\n                            pendingValue = self._evalIfChanged ? self._evalIfChanged() : self();\n                        }\n                        var shouldNotify = notifyNextChange || (didUpdate && self.isDifferent(previousValue, pendingValue));\n\n                        didUpdate = notifyNextChange = ignoreBeforeChange = false;\n\n                        if (shouldNotify) {\n                            self._origNotifySubscribers(previousValue = pendingValue);\n                        }\n                    });\n\n                    self._limitChange = function(value, isDirty) {\n                        if (!isDirty || !self._notificationIsPending) {\n                            didUpdate = !isDirty;\n                        }\n                        self._changeSubscriptions = self._subscriptions[defaultEvent].slice(0);\n                        self._notificationIsPending = ignoreBeforeChange = true;\n                        pendingValue = value;\n                        finish();\n                    };\n                    self._limitBeforeChange = function(value) {\n                        if (!ignoreBeforeChange) {\n                            previousValue = value;\n                            self._origNotifySubscribers(value, beforeChange);\n                        }\n                    };\n                    self._recordUpdate = function() {\n                        didUpdate = true;\n                    };\n                    self._notifyNextChangeIfValueIsDifferent = function() {\n                        if (self.isDifferent(previousValue, self.peek(true /*evaluate*/))) {\n                            notifyNextChange = true;\n                        }\n                    };\n                },\n\n                hasSubscriptionsForEvent: function(event) {\n                    return this._subscriptions[event] && this._subscriptions[event].length;\n                },\n\n                getSubscriptionsCount: function (event) {\n                    if (event) {\n                        return this._subscriptions[event] && this._subscriptions[event].length || 0;\n                    } else {\n                        var total = 0;\n                        ko.utils.objectForEach(this._subscriptions, function(eventName, subscriptions) {\n                            if (eventName !== 'dirty')\n                                total += subscriptions.length;\n                        });\n                        return total;\n                    }\n                },\n\n                isDifferent: function(oldValue, newValue) {\n                    return !this['equalityComparer'] || !this['equalityComparer'](oldValue, newValue);\n                },\n\n                toString: function() {\n                    return '[object Object]'\n                },\n\n                extend: applyExtenders\n            };\n\n            ko.exportProperty(ko_subscribable_fn, 'init', ko_subscribable_fn.init);\n            ko.exportProperty(ko_subscribable_fn, 'subscribe', ko_subscribable_fn.subscribe);\n            ko.exportProperty(ko_subscribable_fn, 'extend', ko_subscribable_fn.extend);\n            ko.exportProperty(ko_subscribable_fn, 'getSubscriptionsCount', ko_subscribable_fn.getSubscriptionsCount);\n\n// For browsers that support proto assignment, we overwrite the prototype of each\n// observable instance. Since observables are functions, we need Function.prototype\n// to still be in the prototype chain.\n            if (ko.utils.canSetPrototype) {\n                ko.utils.setPrototypeOf(ko_subscribable_fn, Function.prototype);\n            }\n\n            ko.subscribable['fn'] = ko_subscribable_fn;\n\n\n            ko.isSubscribable = function (instance) {\n                return instance != null && typeof instance.subscribe == \"function\" && typeof instance[\"notifySubscribers\"] == \"function\";\n            };\n\n            ko.exportSymbol('subscribable', ko.subscribable);\n            ko.exportSymbol('isSubscribable', ko.isSubscribable);\n\n            ko.computedContext = ko.dependencyDetection = (function () {\n                var outerFrames = [],\n                    currentFrame,\n                    lastId = 0;\n\n                // Return a unique ID that can be assigned to an observable for dependency tracking.\n                // Theoretically, you could eventually overflow the number storage size, resulting\n                // in duplicate IDs. But in JavaScript, the largest exact integral value is 2^53\n                // or 9,007,199,254,740,992. If you created 1,000,000 IDs per second, it would\n                // take over 285 years to reach that number.\n                // Reference http://blog.vjeux.com/2010/javascript/javascript-max_int-number-limits.html\n                function getId() {\n                    return ++lastId;\n                }\n\n                function begin(options) {\n                    outerFrames.push(currentFrame);\n                    currentFrame = options;\n                }\n\n                function end() {\n                    currentFrame = outerFrames.pop();\n                }\n\n                return {\n                    begin: begin,\n\n                    end: end,\n\n                    registerDependency: function (subscribable) {\n                        if (currentFrame) {\n                            if (!ko.isSubscribable(subscribable))\n                                throw new Error(\"Only subscribable things can act as dependencies\");\n                            currentFrame.callback.call(currentFrame.callbackTarget, subscribable, subscribable._id || (subscribable._id = getId()));\n                        }\n                    },\n\n                    ignore: function (callback, callbackTarget, callbackArgs) {\n                        try {\n                            begin();\n                            return callback.apply(callbackTarget, callbackArgs || []);\n                        } finally {\n                            end();\n                        }\n                    },\n\n                    getDependenciesCount: function () {\n                        if (currentFrame)\n                            return currentFrame.computed.getDependenciesCount();\n                    },\n\n                    getDependencies: function () {\n                        if (currentFrame)\n                            return currentFrame.computed.getDependencies();\n                    },\n\n                    isInitial: function() {\n                        if (currentFrame)\n                            return currentFrame.isInitial;\n                    },\n\n                    computed: function() {\n                        if (currentFrame)\n                            return currentFrame.computed;\n                    }\n                };\n            })();\n\n            ko.exportSymbol('computedContext', ko.computedContext);\n            ko.exportSymbol('computedContext.getDependenciesCount', ko.computedContext.getDependenciesCount);\n            ko.exportSymbol('computedContext.getDependencies', ko.computedContext.getDependencies);\n            ko.exportSymbol('computedContext.isInitial', ko.computedContext.isInitial);\n            ko.exportSymbol('computedContext.registerDependency', ko.computedContext.registerDependency);\n\n            ko.exportSymbol('ignoreDependencies', ko.ignoreDependencies = ko.dependencyDetection.ignore);\n            var observableLatestValue = ko.utils.createSymbolOrString('_latestValue');\n\n            ko.observable = function (initialValue) {\n                function observable() {\n                    if (arguments.length > 0) {\n                        // Write\n\n                        // Ignore writes if the value hasn't changed\n                        if (observable.isDifferent(observable[observableLatestValue], arguments[0])) {\n                            observable.valueWillMutate();\n                            observable[observableLatestValue] = arguments[0];\n                            observable.valueHasMutated();\n                        }\n                        return this; // Permits chained assignments\n                    }\n                    else {\n                        // Read\n                        ko.dependencyDetection.registerDependency(observable); // The caller only needs to be notified of changes if they did a \"read\" operation\n                        return observable[observableLatestValue];\n                    }\n                }\n\n                observable[observableLatestValue] = initialValue;\n\n                // Inherit from 'subscribable'\n                if (!ko.utils.canSetPrototype) {\n                    // 'subscribable' won't be on the prototype chain unless we put it there directly\n                    ko.utils.extend(observable, ko.subscribable['fn']);\n                }\n                ko.subscribable['fn'].init(observable);\n\n                // Inherit from 'observable'\n                ko.utils.setPrototypeOfOrExtend(observable, observableFn);\n\n                if (ko.options['deferUpdates']) {\n                    ko.extenders['deferred'](observable, true);\n                }\n\n                return observable;\n            }\n\n// Define prototype for observables\n            var observableFn = {\n                'equalityComparer': valuesArePrimitiveAndEqual,\n                peek: function() { return this[observableLatestValue]; },\n                valueHasMutated: function () {\n                    this['notifySubscribers'](this[observableLatestValue], 'spectate');\n                    this['notifySubscribers'](this[observableLatestValue]);\n                },\n                valueWillMutate: function () { this['notifySubscribers'](this[observableLatestValue], 'beforeChange'); }\n            };\n\n// Note that for browsers that don't support proto assignment, the\n// inheritance chain is created manually in the ko.observable constructor\n            if (ko.utils.canSetPrototype) {\n                ko.utils.setPrototypeOf(observableFn, ko.subscribable['fn']);\n            }\n\n            var protoProperty = ko.observable.protoProperty = '__ko_proto__';\n            observableFn[protoProperty] = ko.observable;\n\n            ko.isObservable = function (instance) {\n                var proto = typeof instance == 'function' && instance[protoProperty];\n                if (proto && proto !== observableFn[protoProperty] && proto !== ko.computed['fn'][protoProperty]) {\n                    throw Error(\"Invalid object that looks like an observable; possibly from another Knockout instance\");\n                }\n                return !!proto;\n            };\n\n            ko.isWriteableObservable = function (instance) {\n                return (typeof instance == 'function' && (\n                    (instance[protoProperty] === observableFn[protoProperty]) ||  // Observable\n                    (instance[protoProperty] === ko.computed['fn'][protoProperty] && instance.hasWriteFunction)));   // Writable computed observable\n            };\n\n            ko.exportSymbol('observable', ko.observable);\n            ko.exportSymbol('isObservable', ko.isObservable);\n            ko.exportSymbol('isWriteableObservable', ko.isWriteableObservable);\n            ko.exportSymbol('isWritableObservable', ko.isWriteableObservable);\n            ko.exportSymbol('observable.fn', observableFn);\n            ko.exportProperty(observableFn, 'peek', observableFn.peek);\n            ko.exportProperty(observableFn, 'valueHasMutated', observableFn.valueHasMutated);\n            ko.exportProperty(observableFn, 'valueWillMutate', observableFn.valueWillMutate);\n            ko.observableArray = function (initialValues) {\n                initialValues = initialValues || [];\n\n                if (typeof initialValues != 'object' || !('length' in initialValues))\n                    throw new Error(\"The argument passed when initializing an observable array must be an array, or null, or undefined.\");\n\n                var result = ko.observable(initialValues);\n                ko.utils.setPrototypeOfOrExtend(result, ko.observableArray['fn']);\n                return result.extend({'trackArrayChanges':true});\n            };\n\n            ko.observableArray['fn'] = {\n                'remove': function (valueOrPredicate) {\n                    var underlyingArray = this.peek();\n                    var removedValues = [];\n                    var predicate = typeof valueOrPredicate == \"function\" && !ko.isObservable(valueOrPredicate) ? valueOrPredicate : function (value) { return value === valueOrPredicate; };\n                    for (var i = 0; i < underlyingArray.length; i++) {\n                        var value = underlyingArray[i];\n                        if (predicate(value)) {\n                            if (removedValues.length === 0) {\n                                this.valueWillMutate();\n                            }\n                            if (underlyingArray[i] !== value) {\n                                throw Error(\"Array modified during remove; cannot remove item\");\n                            }\n                            removedValues.push(value);\n                            underlyingArray.splice(i, 1);\n                            i--;\n                        }\n                    }\n                    if (removedValues.length) {\n                        this.valueHasMutated();\n                    }\n                    return removedValues;\n                },\n\n                'removeAll': function (arrayOfValues) {\n                    // If you passed zero args, we remove everything\n                    if (arrayOfValues === undefined) {\n                        var underlyingArray = this.peek();\n                        var allValues = underlyingArray.slice(0);\n                        this.valueWillMutate();\n                        underlyingArray.splice(0, underlyingArray.length);\n                        this.valueHasMutated();\n                        return allValues;\n                    }\n                    // If you passed an arg, we interpret it as an array of entries to remove\n                    if (!arrayOfValues)\n                        return [];\n                    return this['remove'](function (value) {\n                        return ko.utils.arrayIndexOf(arrayOfValues, value) >= 0;\n                    });\n                },\n\n                'destroy': function (valueOrPredicate) {\n                    var underlyingArray = this.peek();\n                    var predicate = typeof valueOrPredicate == \"function\" && !ko.isObservable(valueOrPredicate) ? valueOrPredicate : function (value) { return value === valueOrPredicate; };\n                    this.valueWillMutate();\n                    for (var i = underlyingArray.length - 1; i >= 0; i--) {\n                        var value = underlyingArray[i];\n                        if (predicate(value))\n                            value[\"_destroy\"] = true;\n                    }\n                    this.valueHasMutated();\n                },\n\n                'destroyAll': function (arrayOfValues) {\n                    // If you passed zero args, we destroy everything\n                    if (arrayOfValues === undefined)\n                        return this['destroy'](function() { return true });\n\n                    // If you passed an arg, we interpret it as an array of entries to destroy\n                    if (!arrayOfValues)\n                        return [];\n                    return this['destroy'](function (value) {\n                        return ko.utils.arrayIndexOf(arrayOfValues, value) >= 0;\n                    });\n                },\n\n                'indexOf': function (item) {\n                    var underlyingArray = this();\n                    return ko.utils.arrayIndexOf(underlyingArray, item);\n                },\n\n                'replace': function(oldItem, newItem) {\n                    var index = this['indexOf'](oldItem);\n                    if (index >= 0) {\n                        this.valueWillMutate();\n                        this.peek()[index] = newItem;\n                        this.valueHasMutated();\n                    }\n                },\n\n                'sorted': function (compareFunction) {\n                    var arrayCopy = this().slice(0);\n                    return compareFunction ? arrayCopy.sort(compareFunction) : arrayCopy.sort();\n                },\n\n                'reversed': function () {\n                    return this().slice(0).reverse();\n                }\n            };\n\n// Note that for browsers that don't support proto assignment, the\n// inheritance chain is created manually in the ko.observableArray constructor\n            if (ko.utils.canSetPrototype) {\n                ko.utils.setPrototypeOf(ko.observableArray['fn'], ko.observable['fn']);\n            }\n\n// Populate ko.observableArray.fn with read/write functions from native arrays\n// Important: Do not add any additional functions here that may reasonably be used to *read* data from the array\n// because we'll eval them without causing subscriptions, so ko.computed output could end up getting stale\n            ko.utils.arrayForEach([\"pop\", \"push\", \"reverse\", \"shift\", \"sort\", \"splice\", \"unshift\"], function (methodName) {\n                ko.observableArray['fn'][methodName] = function () {\n                    // Use \"peek\" to avoid creating a subscription in any computed that we're executing in the context of\n                    // (for consistency with mutating regular observables)\n                    var underlyingArray = this.peek();\n                    this.valueWillMutate();\n                    this.cacheDiffForKnownOperation(underlyingArray, methodName, arguments);\n                    var methodCallResult = underlyingArray[methodName].apply(underlyingArray, arguments);\n                    this.valueHasMutated();\n                    // The native sort and reverse methods return a reference to the array, but it makes more sense to return the observable array instead.\n                    return methodCallResult === underlyingArray ? this : methodCallResult;\n                };\n            });\n\n// Populate ko.observableArray.fn with read-only functions from native arrays\n            ko.utils.arrayForEach([\"slice\"], function (methodName) {\n                ko.observableArray['fn'][methodName] = function () {\n                    var underlyingArray = this();\n                    return underlyingArray[methodName].apply(underlyingArray, arguments);\n                };\n            });\n\n            ko.isObservableArray = function (instance) {\n                return ko.isObservable(instance)\n                    && typeof instance[\"remove\"] == \"function\"\n                    && typeof instance[\"push\"] == \"function\";\n            };\n\n            ko.exportSymbol('observableArray', ko.observableArray);\n            ko.exportSymbol('isObservableArray', ko.isObservableArray);\n            var arrayChangeEventName = 'arrayChange';\n            ko.extenders['trackArrayChanges'] = function(target, options) {\n                // Use the provided options--each call to trackArrayChanges overwrites the previously set options\n                target.compareArrayOptions = {};\n                if (options && typeof options == \"object\") {\n                    ko.utils.extend(target.compareArrayOptions, options);\n                }\n                target.compareArrayOptions['sparse'] = true;\n\n                // Only modify the target observable once\n                if (target.cacheDiffForKnownOperation) {\n                    return;\n                }\n                var trackingChanges = false,\n                    cachedDiff = null,\n                    changeSubscription,\n                    spectateSubscription,\n                    pendingChanges = 0,\n                    previousContents,\n                    underlyingBeforeSubscriptionAddFunction = target.beforeSubscriptionAdd,\n                    underlyingAfterSubscriptionRemoveFunction = target.afterSubscriptionRemove;\n\n                // Watch \"subscribe\" calls, and for array change events, ensure change tracking is enabled\n                target.beforeSubscriptionAdd = function (event) {\n                    if (underlyingBeforeSubscriptionAddFunction) {\n                        underlyingBeforeSubscriptionAddFunction.call(target, event);\n                    }\n                    if (event === arrayChangeEventName) {\n                        trackChanges();\n                    }\n                };\n                // Watch \"dispose\" calls, and for array change events, ensure change tracking is disabled when all are disposed\n                target.afterSubscriptionRemove = function (event) {\n                    if (underlyingAfterSubscriptionRemoveFunction) {\n                        underlyingAfterSubscriptionRemoveFunction.call(target, event);\n                    }\n                    if (event === arrayChangeEventName && !target.hasSubscriptionsForEvent(arrayChangeEventName)) {\n                        if (changeSubscription) {\n                            changeSubscription.dispose();\n                        }\n                        if (spectateSubscription) {\n                            spectateSubscription.dispose();\n                        }\n                        spectateSubscription = changeSubscription = null;\n                        trackingChanges = false;\n                        previousContents = undefined;\n                    }\n                };\n\n                function trackChanges() {\n                    if (trackingChanges) {\n                        // Whenever there's a new subscription and there are pending notifications, make sure all previous\n                        // subscriptions are notified of the change so that all subscriptions are in sync.\n                        notifyChanges();\n                        return;\n                    }\n\n                    trackingChanges = true;\n\n                    // Track how many times the array actually changed value\n                    spectateSubscription = target.subscribe(function () {\n                        ++pendingChanges;\n                    }, null, \"spectate\");\n\n                    // Each time the array changes value, capture a clone so that on the next\n                    // change it's possible to produce a diff\n                    previousContents = [].concat(target.peek() || []);\n                    cachedDiff = null;\n                    changeSubscription = target.subscribe(notifyChanges);\n\n                    function notifyChanges() {\n                        if (pendingChanges) {\n                            // Make a copy of the current contents and ensure it's an array\n                            var currentContents = [].concat(target.peek() || []), changes;\n\n                            // Compute the diff and issue notifications, but only if someone is listening\n                            if (target.hasSubscriptionsForEvent(arrayChangeEventName)) {\n                                changes = getChanges(previousContents, currentContents);\n                            }\n\n                            // Eliminate references to the old, removed items, so they can be GCed\n                            previousContents = currentContents;\n                            cachedDiff = null;\n                            pendingChanges = 0;\n\n                            if (changes && changes.length) {\n                                target['notifySubscribers'](changes, arrayChangeEventName);\n                            }\n                        }\n                    }\n                }\n\n                function getChanges(previousContents, currentContents) {\n                    // We try to re-use cached diffs.\n                    // The scenarios where pendingChanges > 1 are when using rate limiting or deferred updates,\n                    // which without this check would not be compatible with arrayChange notifications. Normally,\n                    // notifications are issued immediately so we wouldn't be queueing up more than one.\n                    if (!cachedDiff || pendingChanges > 1) {\n                        cachedDiff = ko.utils.compareArrays(previousContents, currentContents, target.compareArrayOptions);\n                    }\n\n                    return cachedDiff;\n                }\n\n                target.cacheDiffForKnownOperation = function(rawArray, operationName, args) {\n                    // Only run if we're currently tracking changes for this observable array\n                    // and there aren't any pending deferred notifications.\n                    if (!trackingChanges || pendingChanges) {\n                        return;\n                    }\n                    var diff = [],\n                        arrayLength = rawArray.length,\n                        argsLength = args.length,\n                        offset = 0;\n\n                    function pushDiff(status, value, index) {\n                        return diff[diff.length] = { 'status': status, 'value': value, 'index': index };\n                    }\n                    switch (operationName) {\n                        case 'push':\n                            offset = arrayLength;\n                        case 'unshift':\n                            for (var index = 0; index < argsLength; index++) {\n                                pushDiff('added', args[index], offset + index);\n                            }\n                            break;\n\n                        case 'pop':\n                            offset = arrayLength - 1;\n                        case 'shift':\n                            if (arrayLength) {\n                                pushDiff('deleted', rawArray[offset], offset);\n                            }\n                            break;\n\n                        case 'splice':\n                            // Negative start index means 'from end of array'. After that we clamp to [0...arrayLength].\n                            // See https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/splice\n                            var startIndex = Math.min(Math.max(0, args[0] < 0 ? arrayLength + args[0] : args[0]), arrayLength),\n                                endDeleteIndex = argsLength === 1 ? arrayLength : Math.min(startIndex + (args[1] || 0), arrayLength),\n                                endAddIndex = startIndex + argsLength - 2,\n                                endIndex = Math.max(endDeleteIndex, endAddIndex),\n                                additions = [], deletions = [];\n                            for (var index = startIndex, argsIndex = 2; index < endIndex; ++index, ++argsIndex) {\n                                if (index < endDeleteIndex)\n                                    deletions.push(pushDiff('deleted', rawArray[index], index));\n                                if (index < endAddIndex)\n                                    additions.push(pushDiff('added', args[argsIndex], index));\n                            }\n                            ko.utils.findMovesInArrayComparison(deletions, additions);\n                            break;\n\n                        default:\n                            return;\n                    }\n                    cachedDiff = diff;\n                };\n            };\n            var computedState = ko.utils.createSymbolOrString('_state');\n\n            ko.computed = ko.dependentObservable = function (evaluatorFunctionOrOptions, evaluatorFunctionTarget, options) {\n                if (typeof evaluatorFunctionOrOptions === \"object\") {\n                    // Single-parameter syntax - everything is on this \"options\" param\n                    options = evaluatorFunctionOrOptions;\n                } else {\n                    // Multi-parameter syntax - construct the options according to the params passed\n                    options = options || {};\n                    if (evaluatorFunctionOrOptions) {\n                        options[\"read\"] = evaluatorFunctionOrOptions;\n                    }\n                }\n                if (typeof options[\"read\"] != \"function\")\n                    throw Error(\"Pass a function that returns the value of the ko.computed\");\n\n                var writeFunction = options[\"write\"];\n                var state = {\n                    latestValue: undefined,\n                    isStale: true,\n                    isDirty: true,\n                    isBeingEvaluated: false,\n                    suppressDisposalUntilDisposeWhenReturnsFalse: false,\n                    isDisposed: false,\n                    pure: false,\n                    isSleeping: false,\n                    readFunction: options[\"read\"],\n                    evaluatorFunctionTarget: evaluatorFunctionTarget || options[\"owner\"],\n                    disposeWhenNodeIsRemoved: options[\"disposeWhenNodeIsRemoved\"] || options.disposeWhenNodeIsRemoved || null,\n                    disposeWhen: options[\"disposeWhen\"] || options.disposeWhen,\n                    domNodeDisposalCallback: null,\n                    dependencyTracking: {},\n                    dependenciesCount: 0,\n                    evaluationTimeoutInstance: null\n                };\n\n                function computedObservable() {\n                    if (arguments.length > 0) {\n                        if (typeof writeFunction === \"function\") {\n                            // Writing a value\n                            writeFunction.apply(state.evaluatorFunctionTarget, arguments);\n                        } else {\n                            throw new Error(\"Cannot write a value to a ko.computed unless you specify a 'write' option. If you wish to read the current value, don't pass any parameters.\");\n                        }\n                        return this; // Permits chained assignments\n                    } else {\n                        // Reading the value\n                        if (!state.isDisposed) {\n                            ko.dependencyDetection.registerDependency(computedObservable);\n                        }\n                        if (state.isDirty || (state.isSleeping && computedObservable.haveDependenciesChanged())) {\n                            computedObservable.evaluateImmediate();\n                        }\n                        return state.latestValue;\n                    }\n                }\n\n                computedObservable[computedState] = state;\n                computedObservable.hasWriteFunction = typeof writeFunction === \"function\";\n\n                // Inherit from 'subscribable'\n                if (!ko.utils.canSetPrototype) {\n                    // 'subscribable' won't be on the prototype chain unless we put it there directly\n                    ko.utils.extend(computedObservable, ko.subscribable['fn']);\n                }\n                ko.subscribable['fn'].init(computedObservable);\n\n                // Inherit from 'computed'\n                ko.utils.setPrototypeOfOrExtend(computedObservable, computedFn);\n\n                if (options['pure']) {\n                    state.pure = true;\n                    state.isSleeping = true;     // Starts off sleeping; will awake on the first subscription\n                    ko.utils.extend(computedObservable, pureComputedOverrides);\n                } else if (options['deferEvaluation']) {\n                    ko.utils.extend(computedObservable, deferEvaluationOverrides);\n                }\n\n                if (ko.options['deferUpdates']) {\n                    ko.extenders['deferred'](computedObservable, true);\n                }\n\n                if (DEBUG) {\n                    // #1731 - Aid debugging by exposing the computed's options\n                    computedObservable[\"_options\"] = options;\n                }\n\n                if (state.disposeWhenNodeIsRemoved) {\n                    // Since this computed is associated with a DOM node, and we don't want to dispose the computed\n                    // until the DOM node is *removed* from the document (as opposed to never having been in the document),\n                    // we'll prevent disposal until \"disposeWhen\" first returns false.\n                    state.suppressDisposalUntilDisposeWhenReturnsFalse = true;\n\n                    // disposeWhenNodeIsRemoved: true can be used to opt into the \"only dispose after first false result\"\n                    // behaviour even if there's no specific node to watch. In that case, clear the option so we don't try\n                    // to watch for a non-node's disposal. This technique is intended for KO's internal use only and shouldn't\n                    // be documented or used by application code, as it's likely to change in a future version of KO.\n                    if (!state.disposeWhenNodeIsRemoved.nodeType) {\n                        state.disposeWhenNodeIsRemoved = null;\n                    }\n                }\n\n                // Evaluate, unless sleeping or deferEvaluation is true\n                if (!state.isSleeping && !options['deferEvaluation']) {\n                    computedObservable.evaluateImmediate();\n                }\n\n                // Attach a DOM node disposal callback so that the computed will be proactively disposed as soon as the node is\n                // removed using ko.removeNode. But skip if isActive is false (there will never be any dependencies to dispose).\n                if (state.disposeWhenNodeIsRemoved && computedObservable.isActive()) {\n                    ko.utils.domNodeDisposal.addDisposeCallback(state.disposeWhenNodeIsRemoved, state.domNodeDisposalCallback = function () {\n                        computedObservable.dispose();\n                    });\n                }\n\n                return computedObservable;\n            };\n\n// Utility function that disposes a given dependencyTracking entry\n            function computedDisposeDependencyCallback(id, entryToDispose) {\n                if (entryToDispose !== null && entryToDispose.dispose) {\n                    entryToDispose.dispose();\n                }\n            }\n\n// This function gets called each time a dependency is detected while evaluating a computed.\n// It's factored out as a shared function to avoid creating unnecessary function instances during evaluation.\n            function computedBeginDependencyDetectionCallback(subscribable, id) {\n                var computedObservable = this.computedObservable,\n                    state = computedObservable[computedState];\n                if (!state.isDisposed) {\n                    if (this.disposalCount && this.disposalCandidates[id]) {\n                        // Don't want to dispose this subscription, as it's still being used\n                        computedObservable.addDependencyTracking(id, subscribable, this.disposalCandidates[id]);\n                        this.disposalCandidates[id] = null; // No need to actually delete the property - disposalCandidates is a transient object anyway\n                        --this.disposalCount;\n                    } else if (!state.dependencyTracking[id]) {\n                        // Brand new subscription - add it\n                        computedObservable.addDependencyTracking(id, subscribable, state.isSleeping ? { _target: subscribable } : computedObservable.subscribeToDependency(subscribable));\n                    }\n                    // If the observable we've accessed has a pending notification, ensure we get notified of the actual final value (bypass equality checks)\n                    if (subscribable._notificationIsPending) {\n                        subscribable._notifyNextChangeIfValueIsDifferent();\n                    }\n                }\n            }\n\n            var computedFn = {\n                \"equalityComparer\": valuesArePrimitiveAndEqual,\n                getDependenciesCount: function () {\n                    return this[computedState].dependenciesCount;\n                },\n                getDependencies: function () {\n                    var dependencyTracking = this[computedState].dependencyTracking, dependentObservables = [];\n\n                    ko.utils.objectForEach(dependencyTracking, function (id, dependency) {\n                        dependentObservables[dependency._order] = dependency._target;\n                    });\n\n                    return dependentObservables;\n                },\n                hasAncestorDependency: function (obs) {\n                    if (!this[computedState].dependenciesCount) {\n                        return false;\n                    }\n                    var dependencies = this.getDependencies();\n                    if (ko.utils.arrayIndexOf(dependencies, obs) !== -1) {\n                        return true;\n                    }\n                    return !!ko.utils.arrayFirst(dependencies, function (dep) {\n                        return dep.hasAncestorDependency && dep.hasAncestorDependency(obs);\n                    });\n                },\n                addDependencyTracking: function (id, target, trackingObj) {\n                    if (this[computedState].pure && target === this) {\n                        throw Error(\"A 'pure' computed must not be called recursively\");\n                    }\n\n                    this[computedState].dependencyTracking[id] = trackingObj;\n                    trackingObj._order = this[computedState].dependenciesCount++;\n                    trackingObj._version = target.getVersion();\n                },\n                haveDependenciesChanged: function () {\n                    var id, dependency, dependencyTracking = this[computedState].dependencyTracking;\n                    for (id in dependencyTracking) {\n                        if (Object.prototype.hasOwnProperty.call(dependencyTracking, id)) {\n                            dependency = dependencyTracking[id];\n                            if ((this._evalDelayed && dependency._target._notificationIsPending) || dependency._target.hasChanged(dependency._version)) {\n                                return true;\n                            }\n                        }\n                    }\n                },\n                markDirty: function () {\n                    // Process \"dirty\" events if we can handle delayed notifications\n                    if (this._evalDelayed && !this[computedState].isBeingEvaluated) {\n                        this._evalDelayed(false /*isChange*/);\n                    }\n                },\n                isActive: function () {\n                    var state = this[computedState];\n                    return state.isDirty || state.dependenciesCount > 0;\n                },\n                respondToChange: function () {\n                    // Ignore \"change\" events if we've already scheduled a delayed notification\n                    if (!this._notificationIsPending) {\n                        this.evaluatePossiblyAsync();\n                    } else if (this[computedState].isDirty) {\n                        this[computedState].isStale = true;\n                    }\n                },\n                subscribeToDependency: function (target) {\n                    if (target._deferUpdates) {\n                        var dirtySub = target.subscribe(this.markDirty, this, 'dirty'),\n                            changeSub = target.subscribe(this.respondToChange, this);\n                        return {\n                            _target: target,\n                            dispose: function () {\n                                dirtySub.dispose();\n                                changeSub.dispose();\n                            }\n                        };\n                    } else {\n                        return target.subscribe(this.evaluatePossiblyAsync, this);\n                    }\n                },\n                evaluatePossiblyAsync: function () {\n                    var computedObservable = this,\n                        throttleEvaluationTimeout = computedObservable['throttleEvaluation'];\n                    if (throttleEvaluationTimeout && throttleEvaluationTimeout >= 0) {\n                        clearTimeout(this[computedState].evaluationTimeoutInstance);\n                        this[computedState].evaluationTimeoutInstance = ko.utils.setTimeout(function () {\n                            computedObservable.evaluateImmediate(true /*notifyChange*/);\n                        }, throttleEvaluationTimeout);\n                    } else if (computedObservable._evalDelayed) {\n                        computedObservable._evalDelayed(true /*isChange*/);\n                    } else {\n                        computedObservable.evaluateImmediate(true /*notifyChange*/);\n                    }\n                },\n                evaluateImmediate: function (notifyChange) {\n                    var computedObservable = this,\n                        state = computedObservable[computedState],\n                        disposeWhen = state.disposeWhen,\n                        changed = false;\n\n                    if (state.isBeingEvaluated) {\n                        // If the evaluation of a ko.computed causes side effects, it's possible that it will trigger its own re-evaluation.\n                        // This is not desirable (it's hard for a developer to realise a chain of dependencies might cause this, and they almost\n                        // certainly didn't intend infinite re-evaluations). So, for predictability, we simply prevent ko.computeds from causing\n                        // their own re-evaluation. Further discussion at https://github.com/SteveSanderson/knockout/pull/387\n                        return;\n                    }\n\n                    // Do not evaluate (and possibly capture new dependencies) if disposed\n                    if (state.isDisposed) {\n                        return;\n                    }\n\n                    if (state.disposeWhenNodeIsRemoved && !ko.utils.domNodeIsAttachedToDocument(state.disposeWhenNodeIsRemoved) || disposeWhen && disposeWhen()) {\n                        // See comment above about suppressDisposalUntilDisposeWhenReturnsFalse\n                        if (!state.suppressDisposalUntilDisposeWhenReturnsFalse) {\n                            computedObservable.dispose();\n                            return;\n                        }\n                    } else {\n                        // It just did return false, so we can stop suppressing now\n                        state.suppressDisposalUntilDisposeWhenReturnsFalse = false;\n                    }\n\n                    state.isBeingEvaluated = true;\n                    try {\n                        changed = this.evaluateImmediate_CallReadWithDependencyDetection(notifyChange);\n                    } finally {\n                        state.isBeingEvaluated = false;\n                    }\n\n                    return changed;\n                },\n                evaluateImmediate_CallReadWithDependencyDetection: function (notifyChange) {\n                    // This function is really just part of the evaluateImmediate logic. You would never call it from anywhere else.\n                    // Factoring it out into a separate function means it can be independent of the try/catch block in evaluateImmediate,\n                    // which contributes to saving about 40% off the CPU overhead of computed evaluation (on V8 at least).\n\n                    var computedObservable = this,\n                        state = computedObservable[computedState],\n                        changed = false;\n\n                    // Initially, we assume that none of the subscriptions are still being used (i.e., all are candidates for disposal).\n                    // Then, during evaluation, we cross off any that are in fact still being used.\n                    var isInitial = state.pure ? undefined : !state.dependenciesCount,   // If we're evaluating when there are no previous dependencies, it must be the first time\n                        dependencyDetectionContext = {\n                            computedObservable: computedObservable,\n                            disposalCandidates: state.dependencyTracking,\n                            disposalCount: state.dependenciesCount\n                        };\n\n                    ko.dependencyDetection.begin({\n                        callbackTarget: dependencyDetectionContext,\n                        callback: computedBeginDependencyDetectionCallback,\n                        computed: computedObservable,\n                        isInitial: isInitial\n                    });\n\n                    state.dependencyTracking = {};\n                    state.dependenciesCount = 0;\n\n                    var newValue = this.evaluateImmediate_CallReadThenEndDependencyDetection(state, dependencyDetectionContext);\n\n                    if (!state.dependenciesCount) {\n                        computedObservable.dispose();\n                        changed = true; // When evaluation causes a disposal, make sure all dependent computeds get notified so they'll see the new state\n                    } else {\n                        changed = computedObservable.isDifferent(state.latestValue, newValue);\n                    }\n\n                    if (changed) {\n                        if (!state.isSleeping) {\n                            computedObservable[\"notifySubscribers\"](state.latestValue, \"beforeChange\");\n                        } else {\n                            computedObservable.updateVersion();\n                        }\n\n                        state.latestValue = newValue;\n                        if (DEBUG) computedObservable._latestValue = newValue;\n\n                        computedObservable[\"notifySubscribers\"](state.latestValue, \"spectate\");\n\n                        if (!state.isSleeping && notifyChange) {\n                            computedObservable[\"notifySubscribers\"](state.latestValue);\n                        }\n                        if (computedObservable._recordUpdate) {\n                            computedObservable._recordUpdate();\n                        }\n                    }\n\n                    if (isInitial) {\n                        computedObservable[\"notifySubscribers\"](state.latestValue, \"awake\");\n                    }\n\n                    return changed;\n                },\n                evaluateImmediate_CallReadThenEndDependencyDetection: function (state, dependencyDetectionContext) {\n                    // This function is really part of the evaluateImmediate_CallReadWithDependencyDetection logic.\n                    // You'd never call it from anywhere else. Factoring it out means that evaluateImmediate_CallReadWithDependencyDetection\n                    // can be independent of try/finally blocks, which contributes to saving about 40% off the CPU\n                    // overhead of computed evaluation (on V8 at least).\n\n                    try {\n                        var readFunction = state.readFunction;\n                        return state.evaluatorFunctionTarget ? readFunction.call(state.evaluatorFunctionTarget) : readFunction();\n                    } finally {\n                        ko.dependencyDetection.end();\n\n                        // For each subscription no longer being used, remove it from the active subscriptions list and dispose it\n                        if (dependencyDetectionContext.disposalCount && !state.isSleeping) {\n                            ko.utils.objectForEach(dependencyDetectionContext.disposalCandidates, computedDisposeDependencyCallback);\n                        }\n\n                        state.isStale = state.isDirty = false;\n                    }\n                },\n                peek: function (evaluate) {\n                    // By default, peek won't re-evaluate, except while the computed is sleeping or to get the initial value when \"deferEvaluation\" is set.\n                    // Pass in true to evaluate if needed.\n                    var state = this[computedState];\n                    if ((state.isDirty && (evaluate || !state.dependenciesCount)) || (state.isSleeping && this.haveDependenciesChanged())) {\n                        this.evaluateImmediate();\n                    }\n                    return state.latestValue;\n                },\n                limit: function (limitFunction) {\n                    // Override the limit function with one that delays evaluation as well\n                    ko.subscribable['fn'].limit.call(this, limitFunction);\n                    this._evalIfChanged = function () {\n                        if (!this[computedState].isSleeping) {\n                            if (this[computedState].isStale) {\n                                this.evaluateImmediate();\n                            } else {\n                                this[computedState].isDirty = false;\n                            }\n                        }\n                        return this[computedState].latestValue;\n                    };\n                    this._evalDelayed = function (isChange) {\n                        this._limitBeforeChange(this[computedState].latestValue);\n\n                        // Mark as dirty\n                        this[computedState].isDirty = true;\n                        if (isChange) {\n                            this[computedState].isStale = true;\n                        }\n\n                        // Pass the observable to the \"limit\" code, which will evaluate it when\n                        // it's time to do the notification.\n                        this._limitChange(this, !isChange /* isDirty */);\n                    };\n                },\n                dispose: function () {\n                    var state = this[computedState];\n                    if (!state.isSleeping && state.dependencyTracking) {\n                        ko.utils.objectForEach(state.dependencyTracking, function (id, dependency) {\n                            if (dependency.dispose)\n                                dependency.dispose();\n                        });\n                    }\n                    if (state.disposeWhenNodeIsRemoved && state.domNodeDisposalCallback) {\n                        ko.utils.domNodeDisposal.removeDisposeCallback(state.disposeWhenNodeIsRemoved, state.domNodeDisposalCallback);\n                    }\n                    state.dependencyTracking = undefined;\n                    state.dependenciesCount = 0;\n                    state.isDisposed = true;\n                    state.isStale = false;\n                    state.isDirty = false;\n                    state.isSleeping = false;\n                    state.disposeWhenNodeIsRemoved = undefined;\n                    state.disposeWhen = undefined;\n                    state.readFunction = undefined;\n                    if (!this.hasWriteFunction) {\n                        state.evaluatorFunctionTarget = undefined;\n                    }\n                }\n            };\n\n            var pureComputedOverrides = {\n                beforeSubscriptionAdd: function (event) {\n                    // If asleep, wake up the computed by subscribing to any dependencies.\n                    var computedObservable = this,\n                        state = computedObservable[computedState];\n                    if (!state.isDisposed && state.isSleeping && event == 'change') {\n                        state.isSleeping = false;\n                        if (state.isStale || computedObservable.haveDependenciesChanged()) {\n                            state.dependencyTracking = null;\n                            state.dependenciesCount = 0;\n                            if (computedObservable.evaluateImmediate()) {\n                                computedObservable.updateVersion();\n                            }\n                        } else {\n                            // First put the dependencies in order\n                            var dependenciesOrder = [];\n                            ko.utils.objectForEach(state.dependencyTracking, function (id, dependency) {\n                                dependenciesOrder[dependency._order] = id;\n                            });\n                            // Next, subscribe to each one\n                            ko.utils.arrayForEach(dependenciesOrder, function (id, order) {\n                                var dependency = state.dependencyTracking[id],\n                                    subscription = computedObservable.subscribeToDependency(dependency._target);\n                                subscription._order = order;\n                                subscription._version = dependency._version;\n                                state.dependencyTracking[id] = subscription;\n                            });\n                            // Waking dependencies may have triggered effects\n                            if (computedObservable.haveDependenciesChanged()) {\n                                if (computedObservable.evaluateImmediate()) {\n                                    computedObservable.updateVersion();\n                                }\n                            }\n                        }\n\n                        if (!state.isDisposed) {     // test since evaluating could trigger disposal\n                            computedObservable[\"notifySubscribers\"](state.latestValue, \"awake\");\n                        }\n                    }\n                },\n                afterSubscriptionRemove: function (event) {\n                    var state = this[computedState];\n                    if (!state.isDisposed && event == 'change' && !this.hasSubscriptionsForEvent('change')) {\n                        ko.utils.objectForEach(state.dependencyTracking, function (id, dependency) {\n                            if (dependency.dispose) {\n                                state.dependencyTracking[id] = {\n                                    _target: dependency._target,\n                                    _order: dependency._order,\n                                    _version: dependency._version\n                                };\n                                dependency.dispose();\n                            }\n                        });\n                        state.isSleeping = true;\n                        this[\"notifySubscribers\"](undefined, \"asleep\");\n                    }\n                },\n                getVersion: function () {\n                    // Because a pure computed is not automatically updated while it is sleeping, we can't\n                    // simply return the version number. Instead, we check if any of the dependencies have\n                    // changed and conditionally re-evaluate the computed observable.\n                    var state = this[computedState];\n                    if (state.isSleeping && (state.isStale || this.haveDependenciesChanged())) {\n                        this.evaluateImmediate();\n                    }\n                    return ko.subscribable['fn'].getVersion.call(this);\n                }\n            };\n\n            var deferEvaluationOverrides = {\n                beforeSubscriptionAdd: function (event) {\n                    // This will force a computed with deferEvaluation to evaluate when the first subscription is registered.\n                    if (event == 'change' || event == 'beforeChange') {\n                        this.peek();\n                    }\n                }\n            };\n\n// Note that for browsers that don't support proto assignment, the\n// inheritance chain is created manually in the ko.computed constructor\n            if (ko.utils.canSetPrototype) {\n                ko.utils.setPrototypeOf(computedFn, ko.subscribable['fn']);\n            }\n\n// Set the proto values for ko.computed\n            var protoProp = ko.observable.protoProperty; // == \"__ko_proto__\"\n            computedFn[protoProp] = ko.computed;\n\n            ko.isComputed = function (instance) {\n                return (typeof instance == 'function' && instance[protoProp] === computedFn[protoProp]);\n            };\n\n            ko.isPureComputed = function (instance) {\n                return ko.isComputed(instance) && instance[computedState] && instance[computedState].pure;\n            };\n\n            ko.exportSymbol('computed', ko.computed);\n            ko.exportSymbol('dependentObservable', ko.computed);    // export ko.dependentObservable for backwards compatibility (1.x)\n            ko.exportSymbol('isComputed', ko.isComputed);\n            ko.exportSymbol('isPureComputed', ko.isPureComputed);\n            ko.exportSymbol('computed.fn', computedFn);\n            ko.exportProperty(computedFn, 'peek', computedFn.peek);\n            ko.exportProperty(computedFn, 'dispose', computedFn.dispose);\n            ko.exportProperty(computedFn, 'isActive', computedFn.isActive);\n            ko.exportProperty(computedFn, 'getDependenciesCount', computedFn.getDependenciesCount);\n            ko.exportProperty(computedFn, 'getDependencies', computedFn.getDependencies);\n\n            ko.pureComputed = function (evaluatorFunctionOrOptions, evaluatorFunctionTarget) {\n                if (typeof evaluatorFunctionOrOptions === 'function') {\n                    return ko.computed(evaluatorFunctionOrOptions, evaluatorFunctionTarget, {'pure':true});\n                } else {\n                    evaluatorFunctionOrOptions = ko.utils.extend({}, evaluatorFunctionOrOptions);   // make a copy of the parameter object\n                    evaluatorFunctionOrOptions['pure'] = true;\n                    return ko.computed(evaluatorFunctionOrOptions, evaluatorFunctionTarget);\n                }\n            }\n            ko.exportSymbol('pureComputed', ko.pureComputed);\n\n            (function() {\n                var maxNestedObservableDepth = 10; // Escape the (unlikely) pathological case where an observable's current value is itself (or similar reference cycle)\n\n                ko.toJS = function(rootObject) {\n                    if (arguments.length == 0)\n                        throw new Error(\"When calling ko.toJS, pass the object you want to convert.\");\n\n                    // We just unwrap everything at every level in the object graph\n                    return mapJsObjectGraph(rootObject, function(valueToMap) {\n                        // Loop because an observable's value might in turn be another observable wrapper\n                        for (var i = 0; ko.isObservable(valueToMap) && (i < maxNestedObservableDepth); i++)\n                            valueToMap = valueToMap();\n                        return valueToMap;\n                    });\n                };\n\n                ko.toJSON = function(rootObject, replacer, space) {     // replacer and space are optional\n                    var plainJavaScriptObject = ko.toJS(rootObject);\n                    return ko.utils.stringifyJson(plainJavaScriptObject, replacer, space);\n                };\n\n                function mapJsObjectGraph(rootObject, mapInputCallback, visitedObjects) {\n                    visitedObjects = visitedObjects || new objectLookup();\n\n                    rootObject = mapInputCallback(rootObject);\n                    var canHaveProperties = (typeof rootObject == \"object\") && (rootObject !== null) && (rootObject !== undefined) && (!(rootObject instanceof RegExp)) && (!(rootObject instanceof Date)) && (!(rootObject instanceof String)) && (!(rootObject instanceof Number)) && (!(rootObject instanceof Boolean));\n                    if (!canHaveProperties)\n                        return rootObject;\n\n                    var outputProperties = rootObject instanceof Array ? [] : {};\n                    visitedObjects.save(rootObject, outputProperties);\n\n                    visitPropertiesOrArrayEntries(rootObject, function(indexer) {\n                        var propertyValue = mapInputCallback(rootObject[indexer]);\n\n                        switch (typeof propertyValue) {\n                            case \"boolean\":\n                            case \"number\":\n                            case \"string\":\n                            case \"function\":\n                                outputProperties[indexer] = propertyValue;\n                                break;\n                            case \"object\":\n                            case \"undefined\":\n                                var previouslyMappedValue = visitedObjects.get(propertyValue);\n                                outputProperties[indexer] = (previouslyMappedValue !== undefined)\n                                    ? previouslyMappedValue\n                                    : mapJsObjectGraph(propertyValue, mapInputCallback, visitedObjects);\n                                break;\n                        }\n                    });\n\n                    return outputProperties;\n                }\n\n                function visitPropertiesOrArrayEntries(rootObject, visitorCallback) {\n                    if (rootObject instanceof Array) {\n                        for (var i = 0; i < rootObject.length; i++)\n                            visitorCallback(i);\n\n                        // For arrays, also respect toJSON property for custom mappings (fixes #278)\n                        if (typeof rootObject['toJSON'] == 'function')\n                            visitorCallback('toJSON');\n                    } else {\n                        for (var propertyName in rootObject) {\n                            visitorCallback(propertyName);\n                        }\n                    }\n                };\n\n                function objectLookup() {\n                    this.keys = [];\n                    this.values = [];\n                };\n\n                objectLookup.prototype = {\n                    constructor: objectLookup,\n                    save: function(key, value) {\n                        var existingIndex = ko.utils.arrayIndexOf(this.keys, key);\n                        if (existingIndex >= 0)\n                            this.values[existingIndex] = value;\n                        else {\n                            this.keys.push(key);\n                            this.values.push(value);\n                        }\n                    },\n                    get: function(key) {\n                        var existingIndex = ko.utils.arrayIndexOf(this.keys, key);\n                        return (existingIndex >= 0) ? this.values[existingIndex] : undefined;\n                    }\n                };\n            })();\n\n            ko.exportSymbol('toJS', ko.toJS);\n            ko.exportSymbol('toJSON', ko.toJSON);\n            ko.when = function(predicate, callback, context) {\n                function kowhen (resolve) {\n                    var observable = ko.pureComputed(predicate, context).extend({notify:'always'});\n                    var subscription = observable.subscribe(function(value) {\n                        if (value) {\n                            subscription.dispose();\n                            resolve(value);\n                        }\n                    });\n                    // In case the initial value is true, process it right away\n                    observable['notifySubscribers'](observable.peek());\n\n                    return subscription;\n                }\n                if (typeof Promise === \"function\" && !callback) {\n                    return new Promise(kowhen);\n                } else {\n                    return kowhen(callback.bind(context));\n                }\n            };\n\n            ko.exportSymbol('when', ko.when);\n            (function () {\n                var hasDomDataExpandoProperty = '__ko__hasDomDataOptionValue__';\n\n                // Normally, SELECT elements and their OPTIONs can only take value of type 'string' (because the values\n                // are stored on DOM attributes). ko.selectExtensions provides a way for SELECTs/OPTIONs to have values\n                // that are arbitrary objects. This is very convenient when implementing things like cascading dropdowns.\n                ko.selectExtensions = {\n                    readValue : function(element) {\n                        switch (ko.utils.tagNameLower(element)) {\n                            case 'option':\n                                if (element[hasDomDataExpandoProperty] === true)\n                                    return ko.utils.domData.get(element, ko.bindingHandlers.options.optionValueDomDataKey);\n                                return ko.utils.ieVersion <= 7\n                                    ? (element.getAttributeNode('value') && element.getAttributeNode('value').specified ? element.value : element.text)\n                                    : element.value;\n                            case 'select':\n                                return element.selectedIndex >= 0 ? ko.selectExtensions.readValue(element.options[element.selectedIndex]) : undefined;\n                            default:\n                                return element.value;\n                        }\n                    },\n\n                    writeValue: function(element, value, allowUnset) {\n                        switch (ko.utils.tagNameLower(element)) {\n                            case 'option':\n                                if (typeof value === \"string\") {\n                                    ko.utils.domData.set(element, ko.bindingHandlers.options.optionValueDomDataKey, undefined);\n                                    if (hasDomDataExpandoProperty in element) { // IE <= 8 throws errors if you delete non-existent properties from a DOM node\n                                        delete element[hasDomDataExpandoProperty];\n                                    }\n                                    element.value = value;\n                                }\n                                else {\n                                    // Store arbitrary object using DomData\n                                    ko.utils.domData.set(element, ko.bindingHandlers.options.optionValueDomDataKey, value);\n                                    element[hasDomDataExpandoProperty] = true;\n\n                                    // Special treatment of numbers is just for backward compatibility. KO 1.2.1 wrote numerical values to element.value.\n                                    element.value = typeof value === \"number\" ? value : \"\";\n                                }\n                                break;\n                            case 'select':\n                                if (value === \"\" || value === null)       // A blank string or null value will select the caption\n                                    value = undefined;\n                                var selection = -1;\n                                for (var i = 0, n = element.options.length, optionValue; i < n; ++i) {\n                                    optionValue = ko.selectExtensions.readValue(element.options[i]);\n                                    // Include special check to handle selecting a caption with a blank string value\n                                    if (optionValue == value || (optionValue === \"\" && value === undefined)) {\n                                        selection = i;\n                                        break;\n                                    }\n                                }\n                                if (allowUnset || selection >= 0 || (value === undefined && element.size > 1)) {\n                                    element.selectedIndex = selection;\n                                    if (ko.utils.ieVersion === 6) {\n                                        // Workaround for IE6 bug: It won't reliably apply values to SELECT nodes during the same execution thread\n                                        // right after you've changed the set of OPTION nodes on it. So for that node type, we'll schedule a second thread\n                                        // to apply the value as well.\n                                        ko.utils.setTimeout(function () {\n                                            element.selectedIndex = selection;\n                                        }, 0);\n                                    }\n                                }\n                                break;\n                            default:\n                                if ((value === null) || (value === undefined))\n                                    value = \"\";\n                                element.value = value;\n                                break;\n                        }\n                    }\n                };\n            })();\n\n            ko.exportSymbol('selectExtensions', ko.selectExtensions);\n            ko.exportSymbol('selectExtensions.readValue', ko.selectExtensions.readValue);\n            ko.exportSymbol('selectExtensions.writeValue', ko.selectExtensions.writeValue);\n            ko.expressionRewriting = (function () {\n                var javaScriptReservedWords = [\"true\", \"false\", \"null\", \"undefined\"];\n\n                // Matches something that can be assigned to--either an isolated identifier or something ending with a property accessor\n                // This is designed to be simple and avoid false negatives, but could produce false positives (e.g., a+b.c).\n                // This also will not properly handle nested brackets (e.g., obj1[obj2['prop']]; see #911).\n                var javaScriptAssignmentTarget = /^(?:[$_a-z][$\\w]*|(.+)(\\.\\s*[$_a-z][$\\w]*|\\[.+\\]))$/i;\n\n                function getWriteableValue(expression) {\n                    if (ko.utils.arrayIndexOf(javaScriptReservedWords, expression) >= 0)\n                        return false;\n                    var match = expression.match(javaScriptAssignmentTarget);\n                    return match === null ? false : match[1] ? ('Object(' + match[1] + ')' + match[2]) : expression;\n                }\n\n                // The following regular expressions will be used to split an object-literal string into tokens\n\n                var specials = ',\"\\'`{}()/:[\\\\]',    // These characters have special meaning to the parser and must not appear in the middle of a token, except as part of a string.\n                    // Create the actual regular expression by or-ing the following regex strings. The order is important.\n                    bindingToken = RegExp([\n                        // These match strings, either with double quotes, single quotes, or backticks\n                        '\"(?:\\\\\\\\.|[^\"])*\"',\n                        \"'(?:\\\\\\\\.|[^'])*'\",\n                        \"`(?:\\\\\\\\.|[^`])*`\",\n                        // Match C style comments\n                        \"/\\\\*(?:[^*]|\\\\*+[^*/])*\\\\*+/\",\n                        // Match C++ style comments\n                        \"//.*\\n\",\n                        // Match a regular expression (text enclosed by slashes), but will also match sets of divisions\n                        // as a regular expression (this is handled by the parsing loop below).\n                        '/(?:\\\\\\\\.|[^/])+/\\w*',\n                        // Match text (at least two characters) that does not contain any of the above special characters,\n                        // although some of the special characters are allowed to start it (all but the colon and comma).\n                        // The text can contain spaces, but leading or trailing spaces are skipped.\n                        '[^\\\\s:,/][^' + specials + ']*[^\\\\s' + specials + ']',\n                        // Match any non-space character not matched already. This will match colons and commas, since they're\n                        // not matched by \"everyThingElse\", but will also match any other single character that wasn't already\n                        // matched (for example: in \"a: 1, b: 2\", each of the non-space characters will be matched by oneNotSpace).\n                        '[^\\\\s]'\n                    ].join('|'), 'g'),\n\n                    // Match end of previous token to determine whether a slash is a division or regex.\n                    divisionLookBehind = /[\\])\"'A-Za-z0-9_$]+$/,\n                    keywordRegexLookBehind = {'in':1,'return':1,'typeof':1};\n\n                function parseObjectLiteral(objectLiteralString) {\n                    // Trim leading and trailing spaces from the string\n                    var str = ko.utils.stringTrim(objectLiteralString);\n\n                    // Trim braces '{' surrounding the whole object literal\n                    if (str.charCodeAt(0) === 123) str = str.slice(1, -1);\n\n                    // Add a newline to correctly match a C++ style comment at the end of the string and\n                    // add a comma so that we don't need a separate code block to deal with the last item\n                    str += \"\\n,\";\n\n                    // Split into tokens\n                    var result = [], toks = str.match(bindingToken), key, values = [], depth = 0;\n\n                    if (toks.length > 1) {\n                        for (var i = 0, tok; tok = toks[i]; ++i) {\n                            var c = tok.charCodeAt(0);\n                            // A comma signals the end of a key/value pair if depth is zero\n                            if (c === 44) { // \",\"\n                                if (depth <= 0) {\n                                    result.push((key && values.length) ? {key: key, value: values.join('')} : {'unknown': key || values.join('')});\n                                    key = depth = 0;\n                                    values = [];\n                                    continue;\n                                }\n                                // Simply skip the colon that separates the name and value\n                            } else if (c === 58) { // \":\"\n                                if (!depth && !key && values.length === 1) {\n                                    key = values.pop();\n                                    continue;\n                                }\n                                // Comments: skip them\n                            } else if (c === 47 && tok.length > 1 && (tok.charCodeAt(1) === 47 || tok.charCodeAt(1) === 42)) {  // \"//\" or \"/*\"\n                                continue;\n                                // A set of slashes is initially matched as a regular expression, but could be division\n                            } else if (c === 47 && i && tok.length > 1) {  // \"/\"\n                                // Look at the end of the previous token to determine if the slash is actually division\n                                var match = toks[i-1].match(divisionLookBehind);\n                                if (match && !keywordRegexLookBehind[match[0]]) {\n                                    // The slash is actually a division punctuator; re-parse the remainder of the string (not including the slash)\n                                    str = str.substr(str.indexOf(tok) + 1);\n                                    toks = str.match(bindingToken);\n                                    i = -1;\n                                    // Continue with just the slash\n                                    tok = '/';\n                                }\n                                // Increment depth for parentheses, braces, and brackets so that interior commas are ignored\n                            } else if (c === 40 || c === 123 || c === 91) { // '(', '{', '['\n                                ++depth;\n                            } else if (c === 41 || c === 125 || c === 93) { // ')', '}', ']'\n                                --depth;\n                                // The key will be the first token; if it's a string, trim the quotes\n                            } else if (!key && !values.length && (c === 34 || c === 39)) { // '\"', \"'\"\n                                tok = tok.slice(1, -1);\n                            }\n                            values.push(tok);\n                        }\n                        if (depth > 0) {\n                            throw Error(\"Unbalanced parentheses, braces, or brackets\");\n                        }\n                    }\n                    return result;\n                }\n\n                // Two-way bindings include a write function that allow the handler to update the value even if it's not an observable.\n                var twoWayBindings = {};\n\n                function preProcessBindings(bindingsStringOrKeyValueArray, bindingOptions) {\n                    bindingOptions = bindingOptions || {};\n\n                    function processKeyValue(key, val) {\n                        var writableVal;\n                        function callPreprocessHook(obj) {\n                            return (obj && obj['preprocess']) ? (val = obj['preprocess'](val, key, processKeyValue)) : true;\n                        }\n                        if (!bindingParams) {\n                            if (!callPreprocessHook(ko['getBindingHandler'](key)))\n                                return;\n\n                            if (twoWayBindings[key] && (writableVal = getWriteableValue(val))) {\n                                // For two-way bindings, provide a write method in case the value\n                                // isn't a writable observable.\n                                var writeKey = typeof twoWayBindings[key] == 'string' ? twoWayBindings[key] : key;\n                                propertyAccessorResultStrings.push(\"'\" + writeKey + \"':function(_z){\" + writableVal + \"=_z}\");\n                            }\n                        }\n                        // Values are wrapped in a function so that each value can be accessed independently\n                        if (makeValueAccessors) {\n                            val = 'function(){return ' + val + ' }';\n                        }\n                        resultStrings.push(\"'\" + key + \"':\" + val);\n                    }\n\n                    var resultStrings = [],\n                        propertyAccessorResultStrings = [],\n                        makeValueAccessors = bindingOptions['valueAccessors'],\n                        bindingParams = bindingOptions['bindingParams'],\n                        keyValueArray = typeof bindingsStringOrKeyValueArray === \"string\" ?\n                            parseObjectLiteral(bindingsStringOrKeyValueArray) : bindingsStringOrKeyValueArray;\n\n                    ko.utils.arrayForEach(keyValueArray, function(keyValue) {\n                        processKeyValue(keyValue.key || keyValue['unknown'], keyValue.value);\n                    });\n\n                    if (propertyAccessorResultStrings.length)\n                        processKeyValue('_ko_property_writers', \"{\" + propertyAccessorResultStrings.join(\",\") + \" }\");\n\n                    return resultStrings.join(\",\");\n                }\n\n                return {\n                    bindingRewriteValidators: [],\n\n                    twoWayBindings: twoWayBindings,\n\n                    parseObjectLiteral: parseObjectLiteral,\n\n                    preProcessBindings: preProcessBindings,\n\n                    keyValueArrayContainsKey: function(keyValueArray, key) {\n                        for (var i = 0; i < keyValueArray.length; i++)\n                            if (keyValueArray[i]['key'] == key)\n                                return true;\n                        return false;\n                    },\n\n                    // Internal, private KO utility for updating model properties from within bindings\n                    // property:            If the property being updated is (or might be) an observable, pass it here\n                    //                      If it turns out to be a writable observable, it will be written to directly\n                    // allBindings:         An object with a get method to retrieve bindings in the current execution context.\n                    //                      This will be searched for a '_ko_property_writers' property in case you're writing to a non-observable\n                    // key:                 The key identifying the property to be written. Example: for { hasFocus: myValue }, write to 'myValue' by specifying the key 'hasFocus'\n                    // value:               The value to be written\n                    // checkIfDifferent:    If true, and if the property being written is a writable observable, the value will only be written if\n                    //                      it is !== existing value on that writable observable\n                    writeValueToProperty: function(property, allBindings, key, value, checkIfDifferent) {\n                        if (!property || !ko.isObservable(property)) {\n                            var propWriters = allBindings.get('_ko_property_writers');\n                            if (propWriters && propWriters[key])\n                                propWriters[key](value);\n                        } else if (ko.isWriteableObservable(property) && (!checkIfDifferent || property.peek() !== value)) {\n                            property(value);\n                        }\n                    }\n                };\n            })();\n\n            ko.exportSymbol('expressionRewriting', ko.expressionRewriting);\n            ko.exportSymbol('expressionRewriting.bindingRewriteValidators', ko.expressionRewriting.bindingRewriteValidators);\n            ko.exportSymbol('expressionRewriting.parseObjectLiteral', ko.expressionRewriting.parseObjectLiteral);\n            ko.exportSymbol('expressionRewriting.preProcessBindings', ko.expressionRewriting.preProcessBindings);\n\n// Making bindings explicitly declare themselves as \"two way\" isn't ideal in the long term (it would be better if\n// all bindings could use an official 'property writer' API without needing to declare that they might). However,\n// since this is not, and has never been, a public API (_ko_property_writers was never documented), it's acceptable\n// as an internal implementation detail in the short term.\n// For those developers who rely on _ko_property_writers in their custom bindings, we expose _twoWayBindings as an\n// undocumented feature that makes it relatively easy to upgrade to KO 3.0. However, this is still not an official\n// public API, and we reserve the right to remove it at any time if we create a real public property writers API.\n            ko.exportSymbol('expressionRewriting._twoWayBindings', ko.expressionRewriting.twoWayBindings);\n\n// For backward compatibility, define the following aliases. (Previously, these function names were misleading because\n// they referred to JSON specifically, even though they actually work with arbitrary JavaScript object literal expressions.)\n            ko.exportSymbol('jsonExpressionRewriting', ko.expressionRewriting);\n            ko.exportSymbol('jsonExpressionRewriting.insertPropertyAccessorsIntoJson', ko.expressionRewriting.preProcessBindings);\n            (function() {\n                // \"Virtual elements\" is an abstraction on top of the usual DOM API which understands the notion that comment nodes\n                // may be used to represent hierarchy (in addition to the DOM's natural hierarchy).\n                // If you call the DOM-manipulating functions on ko.virtualElements, you will be able to read and write the state\n                // of that virtual hierarchy\n                //\n                // The point of all this is to support containerless templates (e.g., <!-- ko foreach:someCollection -->blah<!-- /ko -->)\n                // without having to scatter special cases all over the binding and templating code.\n\n                // IE 9 cannot reliably read the \"nodeValue\" property of a comment node (see https://github.com/SteveSanderson/knockout/issues/186)\n                // but it does give them a nonstandard alternative property called \"text\" that it can read reliably. Other browsers don't have that property.\n                // So, use node.text where available, and node.nodeValue elsewhere\n                var commentNodesHaveTextProperty = document && document.createComment(\"test\").text === \"<!--test-->\";\n\n                var startCommentRegex = commentNodesHaveTextProperty ? /^<!--\\s*ko(?:\\s+([\\s\\S]+))?\\s*-->$/ : /^\\s*ko(?:\\s+([\\s\\S]+))?\\s*$/;\n                var endCommentRegex =   commentNodesHaveTextProperty ? /^<!--\\s*\\/ko\\s*-->$/ : /^\\s*\\/ko\\s*$/;\n                var htmlTagsWithOptionallyClosingChildren = { 'ul': true, 'ol': true };\n\n                function isStartComment(node) {\n                    return (node.nodeType == 8) && startCommentRegex.test(commentNodesHaveTextProperty ? node.text : node.nodeValue);\n                }\n\n                function isEndComment(node) {\n                    return (node.nodeType == 8) && endCommentRegex.test(commentNodesHaveTextProperty ? node.text : node.nodeValue);\n                }\n\n                function isUnmatchedEndComment(node) {\n                    return isEndComment(node) && !(ko.utils.domData.get(node, matchedEndCommentDataKey));\n                }\n\n                var matchedEndCommentDataKey = \"__ko_matchedEndComment__\"\n\n                function getVirtualChildren(startComment, allowUnbalanced) {\n                    var currentNode = startComment;\n                    var depth = 1;\n                    var children = [];\n                    while (currentNode = currentNode.nextSibling) {\n                        if (isEndComment(currentNode)) {\n                            ko.utils.domData.set(currentNode, matchedEndCommentDataKey, true);\n                            depth--;\n                            if (depth === 0)\n                                return children;\n                        }\n\n                        children.push(currentNode);\n\n                        if (isStartComment(currentNode))\n                            depth++;\n                    }\n                    if (!allowUnbalanced)\n                        throw new Error(\"Cannot find closing comment tag to match: \" + startComment.nodeValue);\n                    return null;\n                }\n\n                function getMatchingEndComment(startComment, allowUnbalanced) {\n                    var allVirtualChildren = getVirtualChildren(startComment, allowUnbalanced);\n                    if (allVirtualChildren) {\n                        if (allVirtualChildren.length > 0)\n                            return allVirtualChildren[allVirtualChildren.length - 1].nextSibling;\n                        return startComment.nextSibling;\n                    } else\n                        return null; // Must have no matching end comment, and allowUnbalanced is true\n                }\n\n                function getUnbalancedChildTags(node) {\n                    // e.g., from <div>OK</div><!-- ko blah --><span>Another</span>, returns: <!-- ko blah --><span>Another</span>\n                    //       from <div>OK</div><!-- /ko --><!-- /ko -->,             returns: <!-- /ko --><!-- /ko -->\n                    var childNode = node.firstChild, captureRemaining = null;\n                    if (childNode) {\n                        do {\n                            if (captureRemaining)                   // We already hit an unbalanced node and are now just scooping up all subsequent nodes\n                                captureRemaining.push(childNode);\n                            else if (isStartComment(childNode)) {\n                                var matchingEndComment = getMatchingEndComment(childNode, /* allowUnbalanced: */ true);\n                                if (matchingEndComment)             // It's a balanced tag, so skip immediately to the end of this virtual set\n                                    childNode = matchingEndComment;\n                                else\n                                    captureRemaining = [childNode]; // It's unbalanced, so start capturing from this point\n                            } else if (isEndComment(childNode)) {\n                                captureRemaining = [childNode];     // It's unbalanced (if it wasn't, we'd have skipped over it already), so start capturing\n                            }\n                        } while (childNode = childNode.nextSibling);\n                    }\n                    return captureRemaining;\n                }\n\n                ko.virtualElements = {\n                    allowedBindings: {},\n\n                    childNodes: function(node) {\n                        return isStartComment(node) ? getVirtualChildren(node) : node.childNodes;\n                    },\n\n                    emptyNode: function(node) {\n                        if (!isStartComment(node))\n                            ko.utils.emptyDomNode(node);\n                        else {\n                            var virtualChildren = ko.virtualElements.childNodes(node);\n                            for (var i = 0, j = virtualChildren.length; i < j; i++)\n                                ko.removeNode(virtualChildren[i]);\n                        }\n                    },\n\n                    setDomNodeChildren: function(node, childNodes) {\n                        if (!isStartComment(node))\n                            ko.utils.setDomNodeChildren(node, childNodes);\n                        else {\n                            ko.virtualElements.emptyNode(node);\n                            var endCommentNode = node.nextSibling; // Must be the next sibling, as we just emptied the children\n                            for (var i = 0, j = childNodes.length; i < j; i++)\n                                endCommentNode.parentNode.insertBefore(childNodes[i], endCommentNode);\n                        }\n                    },\n\n                    prepend: function(containerNode, nodeToPrepend) {\n                        var insertBeforeNode;\n\n                        if (isStartComment(containerNode)) {\n                            // Start comments must always have a parent and at least one following sibling (the end comment)\n                            insertBeforeNode = containerNode.nextSibling;\n                            containerNode = containerNode.parentNode;\n                        } else {\n                            insertBeforeNode = containerNode.firstChild;\n                        }\n\n                        if (!insertBeforeNode) {\n                            containerNode.appendChild(nodeToPrepend);\n                        } else if (nodeToPrepend !== insertBeforeNode) {       // IE will sometimes crash if you try to insert a node before itself\n                            containerNode.insertBefore(nodeToPrepend, insertBeforeNode);\n                        }\n                    },\n\n                    insertAfter: function(containerNode, nodeToInsert, insertAfterNode) {\n                        if (!insertAfterNode) {\n                            ko.virtualElements.prepend(containerNode, nodeToInsert);\n                        } else {\n                            // Children of start comments must always have a parent and at least one following sibling (the end comment)\n                            var insertBeforeNode = insertAfterNode.nextSibling;\n\n                            if (isStartComment(containerNode)) {\n                                containerNode = containerNode.parentNode;\n                            }\n\n                            if (!insertBeforeNode) {\n                                containerNode.appendChild(nodeToInsert);\n                            } else if (nodeToInsert !== insertBeforeNode) {       // IE will sometimes crash if you try to insert a node before itself\n                                containerNode.insertBefore(nodeToInsert, insertBeforeNode);\n                            }\n                        }\n                    },\n\n                    firstChild: function(node) {\n                        if (!isStartComment(node)) {\n                            if (node.firstChild && isEndComment(node.firstChild)) {\n                                throw new Error(\"Found invalid end comment, as the first child of \" + node);\n                            }\n                            return node.firstChild;\n                        } else if (!node.nextSibling || isEndComment(node.nextSibling)) {\n                            return null;\n                        } else {\n                            return node.nextSibling;\n                        }\n                    },\n\n                    nextSibling: function(node) {\n                        if (isStartComment(node)) {\n                            node = getMatchingEndComment(node);\n                        }\n\n                        if (node.nextSibling && isEndComment(node.nextSibling)) {\n                            if (isUnmatchedEndComment(node.nextSibling)) {\n                                throw Error(\"Found end comment without a matching opening comment, as child of \" + node);\n                            } else {\n                                return null;\n                            }\n                        } else {\n                            return node.nextSibling;\n                        }\n                    },\n\n                    hasBindingValue: isStartComment,\n\n                    virtualNodeBindingValue: function(node) {\n                        var regexMatch = (commentNodesHaveTextProperty ? node.text : node.nodeValue).match(startCommentRegex);\n                        return regexMatch ? regexMatch[1] : null;\n                    },\n\n                    normaliseVirtualElementDomStructure: function(elementVerified) {\n                        // Workaround for https://github.com/SteveSanderson/knockout/issues/155\n                        // (IE <= 8 or IE 9 quirks mode parses your HTML weirdly, treating closing </li> tags as if they don't exist, thereby moving comment nodes\n                        // that are direct descendants of <ul> into the preceding <li>)\n                        if (!htmlTagsWithOptionallyClosingChildren[ko.utils.tagNameLower(elementVerified)])\n                            return;\n\n                        // Scan immediate children to see if they contain unbalanced comment tags. If they do, those comment tags\n                        // must be intended to appear *after* that child, so move them there.\n                        var childNode = elementVerified.firstChild;\n                        if (childNode) {\n                            do {\n                                if (childNode.nodeType === 1) {\n                                    var unbalancedTags = getUnbalancedChildTags(childNode);\n                                    if (unbalancedTags) {\n                                        // Fix up the DOM by moving the unbalanced tags to where they most likely were intended to be placed - *after* the child\n                                        var nodeToInsertBefore = childNode.nextSibling;\n                                        for (var i = 0; i < unbalancedTags.length; i++) {\n                                            if (nodeToInsertBefore)\n                                                elementVerified.insertBefore(unbalancedTags[i], nodeToInsertBefore);\n                                            else\n                                                elementVerified.appendChild(unbalancedTags[i]);\n                                        }\n                                    }\n                                }\n                            } while (childNode = childNode.nextSibling);\n                        }\n                    }\n                };\n            })();\n            ko.exportSymbol('virtualElements', ko.virtualElements);\n            ko.exportSymbol('virtualElements.allowedBindings', ko.virtualElements.allowedBindings);\n            ko.exportSymbol('virtualElements.emptyNode', ko.virtualElements.emptyNode);\n//ko.exportSymbol('virtualElements.firstChild', ko.virtualElements.firstChild);     // firstChild is not minified\n            ko.exportSymbol('virtualElements.insertAfter', ko.virtualElements.insertAfter);\n//ko.exportSymbol('virtualElements.nextSibling', ko.virtualElements.nextSibling);   // nextSibling is not minified\n            ko.exportSymbol('virtualElements.prepend', ko.virtualElements.prepend);\n            ko.exportSymbol('virtualElements.setDomNodeChildren', ko.virtualElements.setDomNodeChildren);\n            (function() {\n                var defaultBindingAttributeName = \"data-bind\";\n\n                ko.bindingProvider = function() {\n                    this.bindingCache = {};\n                };\n\n                ko.utils.extend(ko.bindingProvider.prototype, {\n                    'nodeHasBindings': function(node) {\n                        switch (node.nodeType) {\n                            case 1: // Element\n                                return node.getAttribute(defaultBindingAttributeName) != null\n                                    || ko.components['getComponentNameForNode'](node);\n                            case 8: // Comment node\n                                return ko.virtualElements.hasBindingValue(node);\n                            default: return false;\n                        }\n                    },\n\n                    'getBindings': function(node, bindingContext) {\n                        var bindingsString = this['getBindingsString'](node, bindingContext),\n                            parsedBindings = bindingsString ? this['parseBindingsString'](bindingsString, bindingContext, node) : null;\n                        return ko.components.addBindingsForCustomElement(parsedBindings, node, bindingContext, /* valueAccessors */ false);\n                    },\n\n                    'getBindingAccessors': function(node, bindingContext) {\n                        var bindingsString = this['getBindingsString'](node, bindingContext),\n                            parsedBindings = bindingsString ? this['parseBindingsString'](bindingsString, bindingContext, node, { 'valueAccessors': true }) : null;\n                        return ko.components.addBindingsForCustomElement(parsedBindings, node, bindingContext, /* valueAccessors */ true);\n                    },\n\n                    // The following function is only used internally by this default provider.\n                    // It's not part of the interface definition for a general binding provider.\n                    'getBindingsString': function(node, bindingContext) {\n                        switch (node.nodeType) {\n                            case 1: return node.getAttribute(defaultBindingAttributeName);   // Element\n                            case 8: return ko.virtualElements.virtualNodeBindingValue(node); // Comment node\n                            default: return null;\n                        }\n                    },\n\n                    // The following function is only used internally by this default provider.\n                    // It's not part of the interface definition for a general binding provider.\n                    'parseBindingsString': function(bindingsString, bindingContext, node, options) {\n                        try {\n                            var bindingFunction = createBindingsStringEvaluatorViaCache(bindingsString, this.bindingCache, options);\n                            return bindingFunction(bindingContext, node);\n                        } catch (ex) {\n                            ex.message = \"Unable to parse bindings.\\nBindings value: \" + bindingsString + \"\\nMessage: \" + ex.message;\n                            throw ex;\n                        }\n                    }\n                });\n\n                ko.bindingProvider['instance'] = new ko.bindingProvider();\n\n                function createBindingsStringEvaluatorViaCache(bindingsString, cache, options) {\n                    var cacheKey = bindingsString + (options && options['valueAccessors'] || '');\n                    return cache[cacheKey]\n                        || (cache[cacheKey] = createBindingsStringEvaluator(bindingsString, options));\n                }\n\n                function createBindingsStringEvaluator(bindingsString, options) {\n                    // Build the source for a function that evaluates \"expression\"\n                    // For each scope variable, add an extra level of \"with\" nesting\n                    // Example result: with(sc1) { with(sc0) { return (expression) } }\n                    var rewrittenBindings = ko.expressionRewriting.preProcessBindings(bindingsString, options),\n                        functionBody = \"with($context){with($data||{}){return{\" + rewrittenBindings + \"}}}\";\n                    return new Function(\"$context\", \"$element\", functionBody);\n                }\n            })();\n\n            ko.exportSymbol('bindingProvider', ko.bindingProvider);\n            (function () {\n                // Hide or don't minify context properties, see https://github.com/knockout/knockout/issues/2294\n                var contextSubscribable = ko.utils.createSymbolOrString('_subscribable');\n                var contextAncestorBindingInfo = ko.utils.createSymbolOrString('_ancestorBindingInfo');\n                var contextDataDependency = ko.utils.createSymbolOrString('_dataDependency');\n\n                ko.bindingHandlers = {};\n\n                // The following element types will not be recursed into during binding.\n                var bindingDoesNotRecurseIntoElementTypes = {\n                    // Don't want bindings that operate on text nodes to mutate <script> and <textarea> contents,\n                    // because it's unexpected and a potential XSS issue.\n                    // Also bindings should not operate on <template> elements since this breaks in Internet Explorer\n                    // and because such elements' contents are always intended to be bound in a different context\n                    // from where they appear in the document.\n                    'script': true,\n                    'textarea': true,\n                    'template': true\n                };\n\n                // Use an overridable method for retrieving binding handlers so that plugins may support dynamically created handlers\n                ko['getBindingHandler'] = function(bindingKey) {\n                    return ko.bindingHandlers[bindingKey];\n                };\n\n                var inheritParentVm = {};\n\n                // The ko.bindingContext constructor is only called directly to create the root context. For child\n                // contexts, use bindingContext.createChildContext or bindingContext.extend.\n                ko.bindingContext = function(dataItemOrAccessor, parentContext, dataItemAlias, extendCallback, options) {\n\n                    // The binding context object includes static properties for the current, parent, and root view models.\n                    // If a view model is actually stored in an observable, the corresponding binding context object, and\n                    // any child contexts, must be updated when the view model is changed.\n                    function updateContext() {\n                        // Most of the time, the context will directly get a view model object, but if a function is given,\n                        // we call the function to retrieve the view model. If the function accesses any observables or returns\n                        // an observable, the dependency is tracked, and those observables can later cause the binding\n                        // context to be updated.\n                        var dataItemOrObservable = isFunc ? realDataItemOrAccessor() : realDataItemOrAccessor,\n                            dataItem = ko.utils.unwrapObservable(dataItemOrObservable);\n\n                        if (parentContext) {\n                            // Copy $root and any custom properties from the parent context\n                            ko.utils.extend(self, parentContext);\n\n                            // Copy Symbol properties\n                            if (contextAncestorBindingInfo in parentContext) {\n                                self[contextAncestorBindingInfo] = parentContext[contextAncestorBindingInfo];\n                            }\n                        } else {\n                            self['$parents'] = [];\n                            self['$root'] = dataItem;\n\n                            // Export 'ko' in the binding context so it will be available in bindings and templates\n                            // even if 'ko' isn't exported as a global, such as when using an AMD loader.\n                            // See https://github.com/SteveSanderson/knockout/issues/490\n                            self['ko'] = ko;\n                        }\n\n                        self[contextSubscribable] = subscribable;\n\n                        if (shouldInheritData) {\n                            dataItem = self['$data'];\n                        } else {\n                            self['$rawData'] = dataItemOrObservable;\n                            self['$data'] = dataItem;\n                        }\n\n                        if (dataItemAlias)\n                            self[dataItemAlias] = dataItem;\n\n                        // The extendCallback function is provided when creating a child context or extending a context.\n                        // It handles the specific actions needed to finish setting up the binding context. Actions in this\n                        // function could also add dependencies to this binding context.\n                        if (extendCallback)\n                            extendCallback(self, parentContext, dataItem);\n\n                        // When a \"parent\" context is given and we don't already have a dependency on its context, register a dependency on it.\n                        // Thus whenever the parent context is updated, this context will also be updated.\n                        if (parentContext && parentContext[contextSubscribable] && !ko.computedContext.computed().hasAncestorDependency(parentContext[contextSubscribable])) {\n                            parentContext[contextSubscribable]();\n                        }\n\n                        if (dataDependency) {\n                            self[contextDataDependency] = dataDependency;\n                        }\n\n                        return self['$data'];\n                    }\n\n                    var self = this,\n                        shouldInheritData = dataItemOrAccessor === inheritParentVm,\n                        realDataItemOrAccessor = shouldInheritData ? undefined : dataItemOrAccessor,\n                        isFunc = typeof(realDataItemOrAccessor) == \"function\" && !ko.isObservable(realDataItemOrAccessor),\n                        nodes,\n                        subscribable,\n                        dataDependency = options && options['dataDependency'];\n\n                    if (options && options['exportDependencies']) {\n                        // The \"exportDependencies\" option means that the calling code will track any dependencies and re-create\n                        // the binding context when they change.\n                        updateContext();\n                    } else {\n                        subscribable = ko.pureComputed(updateContext);\n                        subscribable.peek();\n\n                        // At this point, the binding context has been initialized, and the \"subscribable\" computed observable is\n                        // subscribed to any observables that were accessed in the process. If there is nothing to track, the\n                        // computed will be inactive, and we can safely throw it away. If it's active, the computed is stored in\n                        // the context object.\n                        if (subscribable.isActive()) {\n                            // Always notify because even if the model ($data) hasn't changed, other context properties might have changed\n                            subscribable['equalityComparer'] = null;\n                        } else {\n                            self[contextSubscribable] = undefined;\n                        }\n                    }\n                }\n\n                // Extend the binding context hierarchy with a new view model object. If the parent context is watching\n                // any observables, the new child context will automatically get a dependency on the parent context.\n                // But this does not mean that the $data value of the child context will also get updated. If the child\n                // view model also depends on the parent view model, you must provide a function that returns the correct\n                // view model on each update.\n                ko.bindingContext.prototype['createChildContext'] = function (dataItemOrAccessor, dataItemAlias, extendCallback, options) {\n                    if (!options && dataItemAlias && typeof dataItemAlias == \"object\") {\n                        options = dataItemAlias;\n                        dataItemAlias = options['as'];\n                        extendCallback = options['extend'];\n                    }\n\n                    if (dataItemAlias && options && options['noChildContext']) {\n                        var isFunc = typeof(dataItemOrAccessor) == \"function\" && !ko.isObservable(dataItemOrAccessor);\n                        return new ko.bindingContext(inheritParentVm, this, null, function (self) {\n                            if (extendCallback)\n                                extendCallback(self);\n                            self[dataItemAlias] = isFunc ? dataItemOrAccessor() : dataItemOrAccessor;\n                        }, options);\n                    }\n\n                    return new ko.bindingContext(dataItemOrAccessor, this, dataItemAlias, function (self, parentContext) {\n                        // Extend the context hierarchy by setting the appropriate pointers\n                        self['$parentContext'] = parentContext;\n                        self['$parent'] = parentContext['$data'];\n                        self['$parents'] = (parentContext['$parents'] || []).slice(0);\n                        self['$parents'].unshift(self['$parent']);\n                        if (extendCallback)\n                            extendCallback(self);\n                    }, options);\n                };\n\n                // Extend the binding context with new custom properties. This doesn't change the context hierarchy.\n                // Similarly to \"child\" contexts, provide a function here to make sure that the correct values are set\n                // when an observable view model is updated.\n                ko.bindingContext.prototype['extend'] = function(properties, options) {\n                    return new ko.bindingContext(inheritParentVm, this, null, function(self, parentContext) {\n                        ko.utils.extend(self, typeof(properties) == \"function\" ? properties(self) : properties);\n                    }, options);\n                };\n\n                var boundElementDomDataKey = ko.utils.domData.nextKey();\n\n                function asyncContextDispose(node) {\n                    var bindingInfo = ko.utils.domData.get(node, boundElementDomDataKey),\n                        asyncContext = bindingInfo && bindingInfo.asyncContext;\n                    if (asyncContext) {\n                        bindingInfo.asyncContext = null;\n                        asyncContext.notifyAncestor();\n                    }\n                }\n                function AsyncCompleteContext(node, bindingInfo, ancestorBindingInfo) {\n                    this.node = node;\n                    this.bindingInfo = bindingInfo;\n                    this.asyncDescendants = [];\n                    this.childrenComplete = false;\n\n                    if (!bindingInfo.asyncContext) {\n                        ko.utils.domNodeDisposal.addDisposeCallback(node, asyncContextDispose);\n                    }\n\n                    if (ancestorBindingInfo && ancestorBindingInfo.asyncContext) {\n                        ancestorBindingInfo.asyncContext.asyncDescendants.push(node);\n                        this.ancestorBindingInfo = ancestorBindingInfo;\n                    }\n                }\n                AsyncCompleteContext.prototype.notifyAncestor = function () {\n                    if (this.ancestorBindingInfo && this.ancestorBindingInfo.asyncContext) {\n                        this.ancestorBindingInfo.asyncContext.descendantComplete(this.node);\n                    }\n                };\n                AsyncCompleteContext.prototype.descendantComplete = function (node) {\n                    ko.utils.arrayRemoveItem(this.asyncDescendants, node);\n                    if (!this.asyncDescendants.length && this.childrenComplete) {\n                        this.completeChildren();\n                    }\n                };\n                AsyncCompleteContext.prototype.completeChildren = function () {\n                    this.childrenComplete = true;\n                    if (this.bindingInfo.asyncContext && !this.asyncDescendants.length) {\n                        this.bindingInfo.asyncContext = null;\n                        ko.utils.domNodeDisposal.removeDisposeCallback(this.node, asyncContextDispose);\n                        ko.bindingEvent.notify(this.node, ko.bindingEvent.descendantsComplete);\n                        this.notifyAncestor();\n                    }\n                };\n\n                ko.bindingEvent = {\n                    childrenComplete: \"childrenComplete\",\n                    descendantsComplete : \"descendantsComplete\",\n\n                    subscribe: function (node, event, callback, context, options) {\n                        var bindingInfo = ko.utils.domData.getOrSet(node, boundElementDomDataKey, {});\n                        if (!bindingInfo.eventSubscribable) {\n                            bindingInfo.eventSubscribable = new ko.subscribable;\n                        }\n                        if (options && options['notifyImmediately'] && bindingInfo.notifiedEvents[event]) {\n                            ko.dependencyDetection.ignore(callback, context, [node]);\n                        }\n                        return bindingInfo.eventSubscribable.subscribe(callback, context, event);\n                    },\n\n                    notify: function (node, event) {\n                        var bindingInfo = ko.utils.domData.get(node, boundElementDomDataKey);\n                        if (bindingInfo) {\n                            bindingInfo.notifiedEvents[event] = true;\n                            if (bindingInfo.eventSubscribable) {\n                                bindingInfo.eventSubscribable['notifySubscribers'](node, event);\n                            }\n                            if (event == ko.bindingEvent.childrenComplete) {\n                                if (bindingInfo.asyncContext) {\n                                    bindingInfo.asyncContext.completeChildren();\n                                } else if (bindingInfo.asyncContext === undefined && bindingInfo.eventSubscribable && bindingInfo.eventSubscribable.hasSubscriptionsForEvent(ko.bindingEvent.descendantsComplete)) {\n                                    // It's currently an error to register a descendantsComplete handler for a node that was never registered as completing asynchronously.\n                                    // That's because without the asyncContext, we don't have a way to know that all descendants have completed.\n                                    throw new Error(\"descendantsComplete event not supported for bindings on this node\");\n                                }\n                            }\n                        }\n                    },\n\n                    startPossiblyAsyncContentBinding: function (node, bindingContext) {\n                        var bindingInfo = ko.utils.domData.getOrSet(node, boundElementDomDataKey, {});\n\n                        if (!bindingInfo.asyncContext) {\n                            bindingInfo.asyncContext = new AsyncCompleteContext(node, bindingInfo, bindingContext[contextAncestorBindingInfo]);\n                        }\n\n                        // If the provided context was already extended with this node's binding info, just return the extended context\n                        if (bindingContext[contextAncestorBindingInfo] == bindingInfo) {\n                            return bindingContext;\n                        }\n\n                        return bindingContext['extend'](function (ctx) {\n                            ctx[contextAncestorBindingInfo] = bindingInfo;\n                        });\n                    }\n                };\n\n                // Returns the valueAccessor function for a binding value\n                function makeValueAccessor(value) {\n                    return function() {\n                        return value;\n                    };\n                }\n\n                // Returns the value of a valueAccessor function\n                function evaluateValueAccessor(valueAccessor) {\n                    return valueAccessor();\n                }\n\n                // Given a function that returns bindings, create and return a new object that contains\n                // binding value-accessors functions. Each accessor function calls the original function\n                // so that it always gets the latest value and all dependencies are captured. This is used\n                // by ko.applyBindingsToNode and getBindingsAndMakeAccessors.\n                function makeAccessorsFromFunction(callback) {\n                    return ko.utils.objectMap(ko.dependencyDetection.ignore(callback), function(value, key) {\n                        return function() {\n                            return callback()[key];\n                        };\n                    });\n                }\n\n                // Given a bindings function or object, create and return a new object that contains\n                // binding value-accessors functions. This is used by ko.applyBindingsToNode.\n                function makeBindingAccessors(bindings, context, node) {\n                    if (typeof bindings === 'function') {\n                        return makeAccessorsFromFunction(bindings.bind(null, context, node));\n                    } else {\n                        return ko.utils.objectMap(bindings, makeValueAccessor);\n                    }\n                }\n\n                // This function is used if the binding provider doesn't include a getBindingAccessors function.\n                // It must be called with 'this' set to the provider instance.\n                function getBindingsAndMakeAccessors(node, context) {\n                    return makeAccessorsFromFunction(this['getBindings'].bind(this, node, context));\n                }\n\n                function validateThatBindingIsAllowedForVirtualElements(bindingName) {\n                    var validator = ko.virtualElements.allowedBindings[bindingName];\n                    if (!validator)\n                        throw new Error(\"The binding '\" + bindingName + \"' cannot be used with virtual elements\")\n                }\n\n                function applyBindingsToDescendantsInternal(bindingContext, elementOrVirtualElement) {\n                    var nextInQueue = ko.virtualElements.firstChild(elementOrVirtualElement);\n\n                    if (nextInQueue) {\n                        var currentChild,\n                            provider = ko.bindingProvider['instance'],\n                            preprocessNode = provider['preprocessNode'];\n\n                        // Preprocessing allows a binding provider to mutate a node before bindings are applied to it. For example it's\n                        // possible to insert new siblings after it, and/or replace the node with a different one. This can be used to\n                        // implement custom binding syntaxes, such as {{ value }} for string interpolation, or custom element types that\n                        // trigger insertion of <template> contents at that point in the document.\n                        if (preprocessNode) {\n                            while (currentChild = nextInQueue) {\n                                nextInQueue = ko.virtualElements.nextSibling(currentChild);\n                                preprocessNode.call(provider, currentChild);\n                            }\n                            // Reset nextInQueue for the next loop\n                            nextInQueue = ko.virtualElements.firstChild(elementOrVirtualElement);\n                        }\n\n                        while (currentChild = nextInQueue) {\n                            // Keep a record of the next child *before* applying bindings, in case the binding removes the current child from its position\n                            nextInQueue = ko.virtualElements.nextSibling(currentChild);\n                            applyBindingsToNodeAndDescendantsInternal(bindingContext, currentChild);\n                        }\n                    }\n                    ko.bindingEvent.notify(elementOrVirtualElement, ko.bindingEvent.childrenComplete);\n                }\n\n                function applyBindingsToNodeAndDescendantsInternal(bindingContext, nodeVerified) {\n                    var bindingContextForDescendants = bindingContext;\n\n                    var isElement = (nodeVerified.nodeType === 1);\n                    if (isElement) // Workaround IE <= 8 HTML parsing weirdness\n                        ko.virtualElements.normaliseVirtualElementDomStructure(nodeVerified);\n\n                    // Perf optimisation: Apply bindings only if...\n                    // (1) We need to store the binding info for the node (all element nodes)\n                    // (2) It might have bindings (e.g., it has a data-bind attribute, or it's a marker for a containerless template)\n                    var shouldApplyBindings = isElement || ko.bindingProvider['instance']['nodeHasBindings'](nodeVerified);\n                    if (shouldApplyBindings)\n                        bindingContextForDescendants = applyBindingsToNodeInternal(nodeVerified, null, bindingContext)['bindingContextForDescendants'];\n\n                    if (bindingContextForDescendants && !bindingDoesNotRecurseIntoElementTypes[ko.utils.tagNameLower(nodeVerified)]) {\n                        applyBindingsToDescendantsInternal(bindingContextForDescendants, nodeVerified);\n                    }\n                }\n\n                function topologicalSortBindings(bindings) {\n                    // Depth-first sort\n                    var result = [],                // The list of key/handler pairs that we will return\n                        bindingsConsidered = {},    // A temporary record of which bindings are already in 'result'\n                        cyclicDependencyStack = []; // Keeps track of a depth-search so that, if there's a cycle, we know which bindings caused it\n                    ko.utils.objectForEach(bindings, function pushBinding(bindingKey) {\n                        if (!bindingsConsidered[bindingKey]) {\n                            var binding = ko['getBindingHandler'](bindingKey);\n                            if (binding) {\n                                // First add dependencies (if any) of the current binding\n                                if (binding['after']) {\n                                    cyclicDependencyStack.push(bindingKey);\n                                    ko.utils.arrayForEach(binding['after'], function(bindingDependencyKey) {\n                                        if (bindings[bindingDependencyKey]) {\n                                            if (ko.utils.arrayIndexOf(cyclicDependencyStack, bindingDependencyKey) !== -1) {\n                                                throw Error(\"Cannot combine the following bindings, because they have a cyclic dependency: \" + cyclicDependencyStack.join(\", \"));\n                                            } else {\n                                                pushBinding(bindingDependencyKey);\n                                            }\n                                        }\n                                    });\n                                    cyclicDependencyStack.length--;\n                                }\n                                // Next add the current binding\n                                result.push({ key: bindingKey, handler: binding });\n                            }\n                            bindingsConsidered[bindingKey] = true;\n                        }\n                    });\n\n                    return result;\n                }\n\n                function applyBindingsToNodeInternal(node, sourceBindings, bindingContext) {\n                    var bindingInfo = ko.utils.domData.getOrSet(node, boundElementDomDataKey, {});\n\n                    // Prevent multiple applyBindings calls for the same node, except when a binding value is specified\n                    var alreadyBound = bindingInfo.alreadyBound;\n                    if (!sourceBindings) {\n                        if (alreadyBound) {\n                            throw Error(\"You cannot apply bindings multiple times to the same element.\");\n                        }\n                        bindingInfo.alreadyBound = true;\n                    }\n                    if (!alreadyBound) {\n                        bindingInfo.context = bindingContext;\n                    }\n                    if (!bindingInfo.notifiedEvents) {\n                        bindingInfo.notifiedEvents = {};\n                    }\n\n                    // Use bindings if given, otherwise fall back on asking the bindings provider to give us some bindings\n                    var bindings;\n                    if (sourceBindings && typeof sourceBindings !== 'function') {\n                        bindings = sourceBindings;\n                    } else {\n                        var provider = ko.bindingProvider['instance'],\n                            getBindings = provider['getBindingAccessors'] || getBindingsAndMakeAccessors;\n\n                        // Get the binding from the provider within a computed observable so that we can update the bindings whenever\n                        // the binding context is updated or if the binding provider accesses observables.\n                        var bindingsUpdater = ko.dependentObservable(\n                            function() {\n                                bindings = sourceBindings ? sourceBindings(bindingContext, node) : getBindings.call(provider, node, bindingContext);\n                                // Register a dependency on the binding context to support observable view models.\n                                if (bindings) {\n                                    if (bindingContext[contextSubscribable]) {\n                                        bindingContext[contextSubscribable]();\n                                    }\n                                    if (bindingContext[contextDataDependency]) {\n                                        bindingContext[contextDataDependency]();\n                                    }\n                                }\n                                return bindings;\n                            },\n                            null, { disposeWhenNodeIsRemoved: node }\n                        );\n\n                        if (!bindings || !bindingsUpdater.isActive())\n                            bindingsUpdater = null;\n                    }\n\n                    var contextToExtend = bindingContext;\n                    var bindingHandlerThatControlsDescendantBindings;\n                    if (bindings) {\n                        // Return the value accessor for a given binding. When bindings are static (won't be updated because of a binding\n                        // context update), just return the value accessor from the binding. Otherwise, return a function that always gets\n                        // the latest binding value and registers a dependency on the binding updater.\n                        var getValueAccessor = bindingsUpdater\n                            ? function(bindingKey) {\n                                return function() {\n                                    return evaluateValueAccessor(bindingsUpdater()[bindingKey]);\n                                };\n                            } : function(bindingKey) {\n                                return bindings[bindingKey];\n                            };\n\n                        // Use of allBindings as a function is maintained for backwards compatibility, but its use is deprecated\n                        function allBindings() {\n                            return ko.utils.objectMap(bindingsUpdater ? bindingsUpdater() : bindings, evaluateValueAccessor);\n                        }\n                        // The following is the 3.x allBindings API\n                        allBindings['get'] = function(key) {\n                            return bindings[key] && evaluateValueAccessor(getValueAccessor(key));\n                        };\n                        allBindings['has'] = function(key) {\n                            return key in bindings;\n                        };\n\n                        if (ko.bindingEvent.childrenComplete in bindings) {\n                            ko.bindingEvent.subscribe(node, ko.bindingEvent.childrenComplete, function () {\n                                var callback = evaluateValueAccessor(bindings[ko.bindingEvent.childrenComplete]);\n                                if (callback) {\n                                    var nodes = ko.virtualElements.childNodes(node);\n                                    if (nodes.length) {\n                                        callback(nodes, ko.dataFor(nodes[0]));\n                                    }\n                                }\n                            });\n                        }\n\n                        if (ko.bindingEvent.descendantsComplete in bindings) {\n                            contextToExtend = ko.bindingEvent.startPossiblyAsyncContentBinding(node, bindingContext);\n                            ko.bindingEvent.subscribe(node, ko.bindingEvent.descendantsComplete, function () {\n                                var callback = evaluateValueAccessor(bindings[ko.bindingEvent.descendantsComplete]);\n                                if (callback && ko.virtualElements.firstChild(node)) {\n                                    callback(node);\n                                }\n                            });\n                        }\n\n                        // First put the bindings into the right order\n                        var orderedBindings = topologicalSortBindings(bindings);\n\n                        // Go through the sorted bindings, calling init and update for each\n                        ko.utils.arrayForEach(orderedBindings, function(bindingKeyAndHandler) {\n                            // Note that topologicalSortBindings has already filtered out any nonexistent binding handlers,\n                            // so bindingKeyAndHandler.handler will always be nonnull.\n                            var handlerInitFn = bindingKeyAndHandler.handler[\"init\"],\n                                handlerUpdateFn = bindingKeyAndHandler.handler[\"update\"],\n                                bindingKey = bindingKeyAndHandler.key;\n\n                            if (node.nodeType === 8) {\n                                validateThatBindingIsAllowedForVirtualElements(bindingKey);\n                            }\n\n                            try {\n                                // Run init, ignoring any dependencies\n                                if (typeof handlerInitFn == \"function\") {\n                                    ko.dependencyDetection.ignore(function() {\n                                        var initResult = handlerInitFn(node, getValueAccessor(bindingKey), allBindings, contextToExtend['$data'], contextToExtend);\n\n                                        // If this binding handler claims to control descendant bindings, make a note of this\n                                        if (initResult && initResult['controlsDescendantBindings']) {\n                                            if (bindingHandlerThatControlsDescendantBindings !== undefined)\n                                                throw new Error(\"Multiple bindings (\" + bindingHandlerThatControlsDescendantBindings + \" and \" + bindingKey + \") are trying to control descendant bindings of the same element. You cannot use these bindings together on the same element.\");\n                                            bindingHandlerThatControlsDescendantBindings = bindingKey;\n                                        }\n                                    });\n                                }\n\n                                // Run update in its own computed wrapper\n                                if (typeof handlerUpdateFn == \"function\") {\n                                    ko.dependentObservable(\n                                        function() {\n                                            handlerUpdateFn(node, getValueAccessor(bindingKey), allBindings, contextToExtend['$data'], contextToExtend);\n                                        },\n                                        null,\n                                        { disposeWhenNodeIsRemoved: node }\n                                    );\n                                }\n                            } catch (ex) {\n                                ex.message = \"Unable to process binding \\\"\" + bindingKey + \": \" + bindings[bindingKey] + \"\\\"\\nMessage: \" + ex.message;\n                                throw ex;\n                            }\n                        });\n                    }\n\n                    var shouldBindDescendants = bindingHandlerThatControlsDescendantBindings === undefined;\n                    return {\n                        'shouldBindDescendants': shouldBindDescendants,\n                        'bindingContextForDescendants': shouldBindDescendants && contextToExtend\n                    };\n                };\n\n                ko.storedBindingContextForNode = function (node) {\n                    var bindingInfo = ko.utils.domData.get(node, boundElementDomDataKey);\n                    return bindingInfo && bindingInfo.context;\n                }\n\n                function getBindingContext(viewModelOrBindingContext, extendContextCallback) {\n                    return viewModelOrBindingContext && (viewModelOrBindingContext instanceof ko.bindingContext)\n                        ? viewModelOrBindingContext\n                        : new ko.bindingContext(viewModelOrBindingContext, undefined, undefined, extendContextCallback);\n                }\n\n                ko.applyBindingAccessorsToNode = function (node, bindings, viewModelOrBindingContext) {\n                    if (node.nodeType === 1) // If it's an element, workaround IE <= 8 HTML parsing weirdness\n                        ko.virtualElements.normaliseVirtualElementDomStructure(node);\n                    return applyBindingsToNodeInternal(node, bindings, getBindingContext(viewModelOrBindingContext));\n                };\n\n                ko.applyBindingsToNode = function (node, bindings, viewModelOrBindingContext) {\n                    var context = getBindingContext(viewModelOrBindingContext);\n                    return ko.applyBindingAccessorsToNode(node, makeBindingAccessors(bindings, context, node), context);\n                };\n\n                ko.applyBindingsToDescendants = function(viewModelOrBindingContext, rootNode) {\n                    if (rootNode.nodeType === 1 || rootNode.nodeType === 8)\n                        applyBindingsToDescendantsInternal(getBindingContext(viewModelOrBindingContext), rootNode);\n                };\n\n                ko.applyBindings = function (viewModelOrBindingContext, rootNode, extendContextCallback) {\n                    // If jQuery is loaded after Knockout, we won't initially have access to it. So save it here.\n                    if (!jQueryInstance && window['jQuery']) {\n                        jQueryInstance = window['jQuery'];\n                    }\n\n                    if (arguments.length < 2) {\n                        rootNode = document.body;\n                        if (!rootNode) {\n                            throw Error(\"ko.applyBindings: could not find document.body; has the document been loaded?\");\n                        }\n                    } else if (!rootNode || (rootNode.nodeType !== 1 && rootNode.nodeType !== 8)) {\n                        throw Error(\"ko.applyBindings: first parameter should be your view model; second parameter should be a DOM node\");\n                    }\n\n                    applyBindingsToNodeAndDescendantsInternal(getBindingContext(viewModelOrBindingContext, extendContextCallback), rootNode);\n                };\n\n                // Retrieving binding context from arbitrary nodes\n                ko.contextFor = function(node) {\n                    // We can only do something meaningful for elements and comment nodes (in particular, not text nodes, as IE can't store domdata for them)\n                    if (node && (node.nodeType === 1 || node.nodeType === 8)) {\n                        return ko.storedBindingContextForNode(node);\n                    }\n                    return undefined;\n                };\n                ko.dataFor = function(node) {\n                    var context = ko.contextFor(node);\n                    return context ? context['$data'] : undefined;\n                };\n\n                ko.exportSymbol('bindingHandlers', ko.bindingHandlers);\n                ko.exportSymbol('bindingEvent', ko.bindingEvent);\n                ko.exportSymbol('bindingEvent.subscribe', ko.bindingEvent.subscribe);\n                ko.exportSymbol('bindingEvent.startPossiblyAsyncContentBinding', ko.bindingEvent.startPossiblyAsyncContentBinding);\n                ko.exportSymbol('applyBindings', ko.applyBindings);\n                ko.exportSymbol('applyBindingsToDescendants', ko.applyBindingsToDescendants);\n                ko.exportSymbol('applyBindingAccessorsToNode', ko.applyBindingAccessorsToNode);\n                ko.exportSymbol('applyBindingsToNode', ko.applyBindingsToNode);\n                ko.exportSymbol('contextFor', ko.contextFor);\n                ko.exportSymbol('dataFor', ko.dataFor);\n            })();\n            (function(undefined) {\n                var loadingSubscribablesCache = {}, // Tracks component loads that are currently in flight\n                    loadedDefinitionsCache = {};    // Tracks component loads that have already completed\n\n                ko.components = {\n                    get: function(componentName, callback) {\n                        var cachedDefinition = getObjectOwnProperty(loadedDefinitionsCache, componentName);\n                        if (cachedDefinition) {\n                            // It's already loaded and cached. Reuse the same definition object.\n                            // Note that for API consistency, even cache hits complete asynchronously by default.\n                            // You can bypass this by putting synchronous:true on your component config.\n                            if (cachedDefinition.isSynchronousComponent) {\n                                ko.dependencyDetection.ignore(function() { // See comment in loaderRegistryBehaviors.js for reasoning\n                                    callback(cachedDefinition.definition);\n                                });\n                            } else {\n                                ko.tasks.schedule(function() { callback(cachedDefinition.definition); });\n                            }\n                        } else {\n                            // Join the loading process that is already underway, or start a new one.\n                            loadComponentAndNotify(componentName, callback);\n                        }\n                    },\n\n                    clearCachedDefinition: function(componentName) {\n                        delete loadedDefinitionsCache[componentName];\n                    },\n\n                    _getFirstResultFromLoaders: getFirstResultFromLoaders\n                };\n\n                function getObjectOwnProperty(obj, propName) {\n                    return Object.prototype.hasOwnProperty.call(obj, propName) ? obj[propName] : undefined;\n                }\n\n                function loadComponentAndNotify(componentName, callback) {\n                    var subscribable = getObjectOwnProperty(loadingSubscribablesCache, componentName),\n                        completedAsync;\n                    if (!subscribable) {\n                        // It's not started loading yet. Start loading, and when it's done, move it to loadedDefinitionsCache.\n                        subscribable = loadingSubscribablesCache[componentName] = new ko.subscribable();\n                        subscribable.subscribe(callback);\n\n                        beginLoadingComponent(componentName, function(definition, config) {\n                            var isSynchronousComponent = !!(config && config['synchronous']);\n                            loadedDefinitionsCache[componentName] = { definition: definition, isSynchronousComponent: isSynchronousComponent };\n                            delete loadingSubscribablesCache[componentName];\n\n                            // For API consistency, all loads complete asynchronously. However we want to avoid\n                            // adding an extra task schedule if it's unnecessary (i.e., the completion is already\n                            // async).\n                            //\n                            // You can bypass the 'always asynchronous' feature by putting the synchronous:true\n                            // flag on your component configuration when you register it.\n                            if (completedAsync || isSynchronousComponent) {\n                                // Note that notifySubscribers ignores any dependencies read within the callback.\n                                // See comment in loaderRegistryBehaviors.js for reasoning\n                                subscribable['notifySubscribers'](definition);\n                            } else {\n                                ko.tasks.schedule(function() {\n                                    subscribable['notifySubscribers'](definition);\n                                });\n                            }\n                        });\n                        completedAsync = true;\n                    } else {\n                        subscribable.subscribe(callback);\n                    }\n                }\n\n                function beginLoadingComponent(componentName, callback) {\n                    getFirstResultFromLoaders('getConfig', [componentName], function(config) {\n                        if (config) {\n                            // We have a config, so now load its definition\n                            getFirstResultFromLoaders('loadComponent', [componentName, config], function(definition) {\n                                callback(definition, config);\n                            });\n                        } else {\n                            // The component has no config - it's unknown to all the loaders.\n                            // Note that this is not an error (e.g., a module loading error) - that would abort the\n                            // process and this callback would not run. For this callback to run, all loaders must\n                            // have confirmed they don't know about this component.\n                            callback(null, null);\n                        }\n                    });\n                }\n\n                function getFirstResultFromLoaders(methodName, argsExceptCallback, callback, candidateLoaders) {\n                    // On the first call in the stack, start with the full set of loaders\n                    if (!candidateLoaders) {\n                        candidateLoaders = ko.components['loaders'].slice(0); // Use a copy, because we'll be mutating this array\n                    }\n\n                    // Try the next candidate\n                    var currentCandidateLoader = candidateLoaders.shift();\n                    if (currentCandidateLoader) {\n                        var methodInstance = currentCandidateLoader[methodName];\n                        if (methodInstance) {\n                            var wasAborted = false,\n                                synchronousReturnValue = methodInstance.apply(currentCandidateLoader, argsExceptCallback.concat(function(result) {\n                                    if (wasAborted) {\n                                        callback(null);\n                                    } else if (result !== null) {\n                                        // This candidate returned a value. Use it.\n                                        callback(result);\n                                    } else {\n                                        // Try the next candidate\n                                        getFirstResultFromLoaders(methodName, argsExceptCallback, callback, candidateLoaders);\n                                    }\n                                }));\n\n                            // Currently, loaders may not return anything synchronously. This leaves open the possibility\n                            // that we'll extend the API to support synchronous return values in the future. It won't be\n                            // a breaking change, because currently no loader is allowed to return anything except undefined.\n                            if (synchronousReturnValue !== undefined) {\n                                wasAborted = true;\n\n                                // Method to suppress exceptions will remain undocumented. This is only to keep\n                                // KO's specs running tidily, since we can observe the loading got aborted without\n                                // having exceptions cluttering up the console too.\n                                if (!currentCandidateLoader['suppressLoaderExceptions']) {\n                                    throw new Error('Component loaders must supply values by invoking the callback, not by returning values synchronously.');\n                                }\n                            }\n                        } else {\n                            // This candidate doesn't have the relevant handler. Synchronously move on to the next one.\n                            getFirstResultFromLoaders(methodName, argsExceptCallback, callback, candidateLoaders);\n                        }\n                    } else {\n                        // No candidates returned a value\n                        callback(null);\n                    }\n                }\n\n                // Reference the loaders via string name so it's possible for developers\n                // to replace the whole array by assigning to ko.components.loaders\n                ko.components['loaders'] = [];\n\n                ko.exportSymbol('components', ko.components);\n                ko.exportSymbol('components.get', ko.components.get);\n                ko.exportSymbol('components.clearCachedDefinition', ko.components.clearCachedDefinition);\n            })();\n            (function(undefined) {\n\n                // The default loader is responsible for two things:\n                // 1. Maintaining the default in-memory registry of component configuration objects\n                //    (i.e., the thing you're writing to when you call ko.components.register(someName, ...))\n                // 2. Answering requests for components by fetching configuration objects\n                //    from that default in-memory registry and resolving them into standard\n                //    component definition objects (of the form { createViewModel: ..., template: ... })\n                // Custom loaders may override either of these facilities, i.e.,\n                // 1. To supply configuration objects from some other source (e.g., conventions)\n                // 2. Or, to resolve configuration objects by loading viewmodels/templates via arbitrary logic.\n\n                var defaultConfigRegistry = {};\n\n                ko.components.register = function(componentName, config) {\n                    if (!config) {\n                        throw new Error('Invalid configuration for ' + componentName);\n                    }\n\n                    if (ko.components.isRegistered(componentName)) {\n                        throw new Error('Component ' + componentName + ' is already registered');\n                    }\n\n                    defaultConfigRegistry[componentName] = config;\n                };\n\n                ko.components.isRegistered = function(componentName) {\n                    return Object.prototype.hasOwnProperty.call(defaultConfigRegistry, componentName);\n                };\n\n                ko.components.unregister = function(componentName) {\n                    delete defaultConfigRegistry[componentName];\n                    ko.components.clearCachedDefinition(componentName);\n                };\n\n                ko.components.defaultLoader = {\n                    'getConfig': function(componentName, callback) {\n                        var result = ko.components.isRegistered(componentName)\n                            ? defaultConfigRegistry[componentName]\n                            : null;\n                        callback(result);\n                    },\n\n                    'loadComponent': function(componentName, config, callback) {\n                        var errorCallback = makeErrorCallback(componentName);\n                        possiblyGetConfigFromAmd(errorCallback, config, function(loadedConfig) {\n                            resolveConfig(componentName, errorCallback, loadedConfig, callback);\n                        });\n                    },\n\n                    'loadTemplate': function(componentName, templateConfig, callback) {\n                        resolveTemplate(makeErrorCallback(componentName), templateConfig, callback);\n                    },\n\n                    'loadViewModel': function(componentName, viewModelConfig, callback) {\n                        resolveViewModel(makeErrorCallback(componentName), viewModelConfig, callback);\n                    }\n                };\n\n                var createViewModelKey = 'createViewModel';\n\n                // Takes a config object of the form { template: ..., viewModel: ... }, and asynchronously convert it\n                // into the standard component definition format:\n                //    { template: <ArrayOfDomNodes>, createViewModel: function(params, componentInfo) { ... } }.\n                // Since both template and viewModel may need to be resolved asynchronously, both tasks are performed\n                // in parallel, and the results joined when both are ready. We don't depend on any promises infrastructure,\n                // so this is implemented manually below.\n                function resolveConfig(componentName, errorCallback, config, callback) {\n                    var result = {},\n                        makeCallBackWhenZero = 2,\n                        tryIssueCallback = function() {\n                            if (--makeCallBackWhenZero === 0) {\n                                callback(result);\n                            }\n                        },\n                        templateConfig = config['template'],\n                        viewModelConfig = config['viewModel'];\n\n                    if (templateConfig) {\n                        possiblyGetConfigFromAmd(errorCallback, templateConfig, function(loadedConfig) {\n                            ko.components._getFirstResultFromLoaders('loadTemplate', [componentName, loadedConfig], function(resolvedTemplate) {\n                                result['template'] = resolvedTemplate;\n                                tryIssueCallback();\n                            });\n                        });\n                    } else {\n                        tryIssueCallback();\n                    }\n\n                    if (viewModelConfig) {\n                        possiblyGetConfigFromAmd(errorCallback, viewModelConfig, function(loadedConfig) {\n                            ko.components._getFirstResultFromLoaders('loadViewModel', [componentName, loadedConfig], function(resolvedViewModel) {\n                                result[createViewModelKey] = resolvedViewModel;\n                                tryIssueCallback();\n                            });\n                        });\n                    } else {\n                        tryIssueCallback();\n                    }\n                }\n\n                function resolveTemplate(errorCallback, templateConfig, callback) {\n                    if (typeof templateConfig === 'string') {\n                        // Markup - parse it\n                        callback(ko.utils.parseHtmlFragment(templateConfig));\n                    } else if (templateConfig instanceof Array) {\n                        // Assume already an array of DOM nodes - pass through unchanged\n                        callback(templateConfig);\n                    } else if (isDocumentFragment(templateConfig)) {\n                        // Document fragment - use its child nodes\n                        callback(ko.utils.makeArray(templateConfig.childNodes));\n                    } else if (templateConfig['element']) {\n                        var element = templateConfig['element'];\n                        if (isDomElement(element)) {\n                            // Element instance - copy its child nodes\n                            callback(cloneNodesFromTemplateSourceElement(element));\n                        } else if (typeof element === 'string') {\n                            // Element ID - find it, then copy its child nodes\n                            var elemInstance = document.getElementById(element);\n                            if (elemInstance) {\n                                callback(cloneNodesFromTemplateSourceElement(elemInstance));\n                            } else {\n                                errorCallback('Cannot find element with ID ' + element);\n                            }\n                        } else {\n                            errorCallback('Unknown element type: ' + element);\n                        }\n                    } else {\n                        errorCallback('Unknown template value: ' + templateConfig);\n                    }\n                }\n\n                function resolveViewModel(errorCallback, viewModelConfig, callback) {\n                    if (typeof viewModelConfig === 'function') {\n                        // Constructor - convert to standard factory function format\n                        // By design, this does *not* supply componentInfo to the constructor, as the intent is that\n                        // componentInfo contains non-viewmodel data (e.g., the component's element) that should only\n                        // be used in factory functions, not viewmodel constructors.\n                        callback(function (params /*, componentInfo */) {\n                            return new viewModelConfig(params);\n                        });\n                    } else if (typeof viewModelConfig[createViewModelKey] === 'function') {\n                        // Already a factory function - use it as-is\n                        callback(viewModelConfig[createViewModelKey]);\n                    } else if ('instance' in viewModelConfig) {\n                        // Fixed object instance - promote to createViewModel format for API consistency\n                        var fixedInstance = viewModelConfig['instance'];\n                        callback(function (params, componentInfo) {\n                            return fixedInstance;\n                        });\n                    } else if ('viewModel' in viewModelConfig) {\n                        // Resolved AMD module whose value is of the form { viewModel: ... }\n                        resolveViewModel(errorCallback, viewModelConfig['viewModel'], callback);\n                    } else {\n                        errorCallback('Unknown viewModel value: ' + viewModelConfig);\n                    }\n                }\n\n                function cloneNodesFromTemplateSourceElement(elemInstance) {\n                    switch (ko.utils.tagNameLower(elemInstance)) {\n                        case 'script':\n                            return ko.utils.parseHtmlFragment(elemInstance.text);\n                        case 'textarea':\n                            return ko.utils.parseHtmlFragment(elemInstance.value);\n                        case 'template':\n                            // For browsers with proper <template> element support (i.e., where the .content property\n                            // gives a document fragment), use that document fragment.\n                            if (isDocumentFragment(elemInstance.content)) {\n                                return ko.utils.cloneNodes(elemInstance.content.childNodes);\n                            }\n                    }\n\n                    // Regular elements such as <div>, and <template> elements on old browsers that don't really\n                    // understand <template> and just treat it as a regular container\n                    return ko.utils.cloneNodes(elemInstance.childNodes);\n                }\n\n                function isDomElement(obj) {\n                    if (window['HTMLElement']) {\n                        return obj instanceof HTMLElement;\n                    } else {\n                        return obj && obj.tagName && obj.nodeType === 1;\n                    }\n                }\n\n                function isDocumentFragment(obj) {\n                    if (window['DocumentFragment']) {\n                        return obj instanceof DocumentFragment;\n                    } else {\n                        return obj && obj.nodeType === 11;\n                    }\n                }\n\n                function possiblyGetConfigFromAmd(errorCallback, config, callback) {\n                    if (typeof config['require'] === 'string') {\n                        // The config is the value of an AMD module\n                        if (amdRequire || window['require']) {\n                            (amdRequire || window['require'])([config['require']], function (module) {\n                                if (module && typeof module === 'object' && module.__esModule && module.default) {\n                                    module = module.default;\n                                }\n                                callback(module);\n                            });\n                        } else {\n                            errorCallback('Uses require, but no AMD loader is present');\n                        }\n                    } else {\n                        callback(config);\n                    }\n                }\n\n                function makeErrorCallback(componentName) {\n                    return function (message) {\n                        throw new Error('Component \\'' + componentName + '\\': ' + message);\n                    };\n                }\n\n                ko.exportSymbol('components.register', ko.components.register);\n                ko.exportSymbol('components.isRegistered', ko.components.isRegistered);\n                ko.exportSymbol('components.unregister', ko.components.unregister);\n\n                // Expose the default loader so that developers can directly ask it for configuration\n                // or to resolve configuration\n                ko.exportSymbol('components.defaultLoader', ko.components.defaultLoader);\n\n                // By default, the default loader is the only registered component loader\n                ko.components['loaders'].push(ko.components.defaultLoader);\n\n                // Privately expose the underlying config registry for use in old-IE shim\n                ko.components._allRegisteredComponents = defaultConfigRegistry;\n            })();\n            (function (undefined) {\n                // Overridable API for determining which component name applies to a given node. By overriding this,\n                // you can for example map specific tagNames to components that are not preregistered.\n                ko.components['getComponentNameForNode'] = function(node) {\n                    var tagNameLower = ko.utils.tagNameLower(node);\n                    if (ko.components.isRegistered(tagNameLower)) {\n                        // Try to determine that this node can be considered a *custom* element; see https://github.com/knockout/knockout/issues/1603\n                        if (tagNameLower.indexOf('-') != -1 || ('' + node) == \"[object HTMLUnknownElement]\" || (ko.utils.ieVersion <= 8 && node.tagName === tagNameLower)) {\n                            return tagNameLower;\n                        }\n                    }\n                };\n\n                ko.components.addBindingsForCustomElement = function(allBindings, node, bindingContext, valueAccessors) {\n                    // Determine if it's really a custom element matching a component\n                    if (node.nodeType === 1) {\n                        var componentName = ko.components['getComponentNameForNode'](node);\n                        if (componentName) {\n                            // It does represent a component, so add a component binding for it\n                            allBindings = allBindings || {};\n\n                            if (allBindings['component']) {\n                                // Avoid silently overwriting some other 'component' binding that may already be on the element\n                                throw new Error('Cannot use the \"component\" binding on a custom element matching a component');\n                            }\n\n                            var componentBindingValue = { 'name': componentName, 'params': getComponentParamsFromCustomElement(node, bindingContext) };\n\n                            allBindings['component'] = valueAccessors\n                                ? function() { return componentBindingValue; }\n                                : componentBindingValue;\n                        }\n                    }\n\n                    return allBindings;\n                }\n\n                var nativeBindingProviderInstance = new ko.bindingProvider();\n\n                function getComponentParamsFromCustomElement(elem, bindingContext) {\n                    var paramsAttribute = elem.getAttribute('params');\n\n                    if (paramsAttribute) {\n                        var params = nativeBindingProviderInstance['parseBindingsString'](paramsAttribute, bindingContext, elem, { 'valueAccessors': true, 'bindingParams': true }),\n                            rawParamComputedValues = ko.utils.objectMap(params, function(paramValue, paramName) {\n                                return ko.computed(paramValue, null, { disposeWhenNodeIsRemoved: elem });\n                            }),\n                            result = ko.utils.objectMap(rawParamComputedValues, function(paramValueComputed, paramName) {\n                                var paramValue = paramValueComputed.peek();\n                                // Does the evaluation of the parameter value unwrap any observables?\n                                if (!paramValueComputed.isActive()) {\n                                    // No it doesn't, so there's no need for any computed wrapper. Just pass through the supplied value directly.\n                                    // Example: \"someVal: firstName, age: 123\" (whether or not firstName is an observable/computed)\n                                    return paramValue;\n                                } else {\n                                    // Yes it does. Supply a computed property that unwraps both the outer (binding expression)\n                                    // level of observability, and any inner (resulting model value) level of observability.\n                                    // This means the component doesn't have to worry about multiple unwrapping. If the value is a\n                                    // writable observable, the computed will also be writable and pass the value on to the observable.\n                                    return ko.computed({\n                                        'read': function() {\n                                            return ko.utils.unwrapObservable(paramValueComputed());\n                                        },\n                                        'write': ko.isWriteableObservable(paramValue) && function(value) {\n                                            paramValueComputed()(value);\n                                        },\n                                        disposeWhenNodeIsRemoved: elem\n                                    });\n                                }\n                            });\n\n                        // Give access to the raw computeds, as long as that wouldn't overwrite any custom param also called '$raw'\n                        // This is in case the developer wants to react to outer (binding) observability separately from inner\n                        // (model value) observability, or in case the model value observable has subobservables.\n                        if (!Object.prototype.hasOwnProperty.call(result, '$raw')) {\n                            result['$raw'] = rawParamComputedValues;\n                        }\n\n                        return result;\n                    } else {\n                        // For consistency, absence of a \"params\" attribute is treated the same as the presence of\n                        // any empty one. Otherwise component viewmodels need special code to check whether or not\n                        // 'params' or 'params.$raw' is null/undefined before reading subproperties, which is annoying.\n                        return { '$raw': {} };\n                    }\n                }\n\n                // --------------------------------------------------------------------------------\n                // Compatibility code for older (pre-HTML5) IE browsers\n\n                if (ko.utils.ieVersion < 9) {\n                    // Whenever you preregister a component, enable it as a custom element in the current document\n                    ko.components['register'] = (function(originalFunction) {\n                        return function(componentName) {\n                            document.createElement(componentName); // Allows IE<9 to parse markup containing the custom element\n                            return originalFunction.apply(this, arguments);\n                        }\n                    })(ko.components['register']);\n\n                    // Whenever you create a document fragment, enable all preregistered component names as custom elements\n                    // This is needed to make innerShiv/jQuery HTML parsing correctly handle the custom elements\n                    document.createDocumentFragment = (function(originalFunction) {\n                        return function() {\n                            var newDocFrag = originalFunction(),\n                                allComponents = ko.components._allRegisteredComponents;\n                            for (var componentName in allComponents) {\n                                if (Object.prototype.hasOwnProperty.call(allComponents, componentName)) {\n                                    newDocFrag.createElement(componentName);\n                                }\n                            }\n                            return newDocFrag;\n                        };\n                    })(document.createDocumentFragment);\n                }\n            })();(function(undefined) {\n                var componentLoadingOperationUniqueId = 0;\n\n                ko.bindingHandlers['component'] = {\n                    'init': function(element, valueAccessor, ignored1, ignored2, bindingContext) {\n                        var currentViewModel,\n                            currentLoadingOperationId,\n                            afterRenderSub,\n                            disposeAssociatedComponentViewModel = function () {\n                                var currentViewModelDispose = currentViewModel && currentViewModel['dispose'];\n                                if (typeof currentViewModelDispose === 'function') {\n                                    currentViewModelDispose.call(currentViewModel);\n                                }\n                                if (afterRenderSub) {\n                                    afterRenderSub.dispose();\n                                }\n                                afterRenderSub = null;\n                                currentViewModel = null;\n                                // Any in-flight loading operation is no longer relevant, so make sure we ignore its completion\n                                currentLoadingOperationId = null;\n                            },\n                            originalChildNodes = ko.utils.makeArray(ko.virtualElements.childNodes(element));\n\n                        ko.virtualElements.emptyNode(element);\n                        ko.utils.domNodeDisposal.addDisposeCallback(element, disposeAssociatedComponentViewModel);\n\n                        ko.computed(function () {\n                            var value = ko.utils.unwrapObservable(valueAccessor()),\n                                componentName, componentParams;\n\n                            if (typeof value === 'string') {\n                                componentName = value;\n                            } else {\n                                componentName = ko.utils.unwrapObservable(value['name']);\n                                componentParams = ko.utils.unwrapObservable(value['params']);\n                            }\n\n                            if (!componentName) {\n                                throw new Error('No component name specified');\n                            }\n\n                            var asyncContext = ko.bindingEvent.startPossiblyAsyncContentBinding(element, bindingContext);\n\n                            var loadingOperationId = currentLoadingOperationId = ++componentLoadingOperationUniqueId;\n                            ko.components.get(componentName, function(componentDefinition) {\n                                // If this is not the current load operation for this element, ignore it.\n                                if (currentLoadingOperationId !== loadingOperationId) {\n                                    return;\n                                }\n\n                                // Clean up previous state\n                                disposeAssociatedComponentViewModel();\n\n                                // Instantiate and bind new component. Implicitly this cleans any old DOM nodes.\n                                if (!componentDefinition) {\n                                    throw new Error('Unknown component \\'' + componentName + '\\'');\n                                }\n                                cloneTemplateIntoElement(componentName, componentDefinition, element);\n\n                                var componentInfo = {\n                                    'element': element,\n                                    'templateNodes': originalChildNodes\n                                };\n\n                                var componentViewModel = createViewModel(componentDefinition, componentParams, componentInfo),\n                                    childBindingContext = asyncContext['createChildContext'](componentViewModel, {\n                                        'extend': function(ctx) {\n                                            ctx['$component'] = componentViewModel;\n                                            ctx['$componentTemplateNodes'] = originalChildNodes;\n                                        }\n                                    });\n\n                                if (componentViewModel && componentViewModel['koDescendantsComplete']) {\n                                    afterRenderSub = ko.bindingEvent.subscribe(element, ko.bindingEvent.descendantsComplete, componentViewModel['koDescendantsComplete'], componentViewModel);\n                                }\n\n                                currentViewModel = componentViewModel;\n                                ko.applyBindingsToDescendants(childBindingContext, element);\n                            });\n                        }, null, { disposeWhenNodeIsRemoved: element });\n\n                        return { 'controlsDescendantBindings': true };\n                    }\n                };\n\n                ko.virtualElements.allowedBindings['component'] = true;\n\n                function cloneTemplateIntoElement(componentName, componentDefinition, element) {\n                    var template = componentDefinition['template'];\n                    if (!template) {\n                        throw new Error('Component \\'' + componentName + '\\' has no template');\n                    }\n\n                    var clonedNodesArray = ko.utils.cloneNodes(template);\n                    ko.virtualElements.setDomNodeChildren(element, clonedNodesArray);\n                }\n\n                function createViewModel(componentDefinition, componentParams, componentInfo) {\n                    var componentViewModelFactory = componentDefinition['createViewModel'];\n                    return componentViewModelFactory\n                        ? componentViewModelFactory.call(componentDefinition, componentParams, componentInfo)\n                        : componentParams; // Template-only component\n                }\n\n            })();\n            var attrHtmlToJavaScriptMap = { 'class': 'className', 'for': 'htmlFor' };\n            ko.bindingHandlers['attr'] = {\n                'update': function(element, valueAccessor, allBindings) {\n                    var value = ko.utils.unwrapObservable(valueAccessor()) || {};\n                    ko.utils.objectForEach(value, function(attrName, attrValue) {\n                        attrValue = ko.utils.unwrapObservable(attrValue);\n\n                        // Find the namespace of this attribute, if any.\n                        var prefixLen = attrName.indexOf(':');\n                        var namespace = \"lookupNamespaceURI\" in element && prefixLen > 0 && element.lookupNamespaceURI(attrName.substr(0, prefixLen));\n\n                        // To cover cases like \"attr: { checked:someProp }\", we want to remove the attribute entirely\n                        // when someProp is a \"no value\"-like value (strictly null, false, or undefined)\n                        // (because the absence of the \"checked\" attr is how to mark an element as not checked, etc.)\n                        var toRemove = (attrValue === false) || (attrValue === null) || (attrValue === undefined);\n                        if (toRemove) {\n                            namespace ? element.removeAttributeNS(namespace, attrName) : element.removeAttribute(attrName);\n                        } else {\n                            attrValue = attrValue.toString();\n                        }\n\n                        // In IE <= 7 and IE8 Quirks Mode, you have to use the JavaScript property name instead of the\n                        // HTML attribute name for certain attributes. IE8 Standards Mode supports the correct behavior,\n                        // but instead of figuring out the mode, we'll just set the attribute through the JavaScript\n                        // property for IE <= 8.\n                        if (ko.utils.ieVersion <= 8 && attrName in attrHtmlToJavaScriptMap) {\n                            attrName = attrHtmlToJavaScriptMap[attrName];\n                            if (toRemove)\n                                element.removeAttribute(attrName);\n                            else\n                                element[attrName] = attrValue;\n                        } else if (!toRemove) {\n                            namespace ? element.setAttributeNS(namespace, attrName, attrValue) : element.setAttribute(attrName, attrValue);\n                        }\n\n                        // Treat \"name\" specially - although you can think of it as an attribute, it also needs\n                        // special handling on older versions of IE (https://github.com/SteveSanderson/knockout/pull/333)\n                        // Deliberately being case-sensitive here because XHTML would regard \"Name\" as a different thing\n                        // entirely, and there's no strong reason to allow for such casing in HTML.\n                        if (attrName === \"name\") {\n                            ko.utils.setElementName(element, toRemove ? \"\" : attrValue);\n                        }\n                    });\n                }\n            };\n            (function() {\n\n                ko.bindingHandlers['checked'] = {\n                    'after': ['value', 'attr'],\n                    'init': function (element, valueAccessor, allBindings) {\n                        var checkedValue = ko.pureComputed(function() {\n                            // Treat \"value\" like \"checkedValue\" when it is included with \"checked\" binding\n                            if (allBindings['has']('checkedValue')) {\n                                return ko.utils.unwrapObservable(allBindings.get('checkedValue'));\n                            } else if (useElementValue) {\n                                if (allBindings['has']('value')) {\n                                    return ko.utils.unwrapObservable(allBindings.get('value'));\n                                } else {\n                                    return element.value;\n                                }\n                            }\n                        });\n\n                        function updateModel() {\n                            // This updates the model value from the view value.\n                            // It runs in response to DOM events (click) and changes in checkedValue.\n                            var isChecked = element.checked,\n                                elemValue = checkedValue();\n\n                            // When we're first setting up this computed, don't change any model state.\n                            if (ko.computedContext.isInitial()) {\n                                return;\n                            }\n\n                            // We can ignore unchecked radio buttons, because some other radio\n                            // button will be checked, and that one can take care of updating state.\n                            // Also ignore value changes to an already unchecked checkbox.\n                            if (!isChecked && (isRadio || ko.computedContext.getDependenciesCount())) {\n                                return;\n                            }\n\n                            var modelValue = ko.dependencyDetection.ignore(valueAccessor);\n                            if (valueIsArray) {\n                                var writableValue = rawValueIsNonArrayObservable ? modelValue.peek() : modelValue,\n                                    saveOldValue = oldElemValue;\n                                oldElemValue = elemValue;\n\n                                if (saveOldValue !== elemValue) {\n                                    // When we're responding to the checkedValue changing, and the element is\n                                    // currently checked, replace the old elem value with the new elem value\n                                    // in the model array.\n                                    if (isChecked) {\n                                        ko.utils.addOrRemoveItem(writableValue, elemValue, true);\n                                        ko.utils.addOrRemoveItem(writableValue, saveOldValue, false);\n                                    }\n                                } else {\n                                    // When we're responding to the user having checked/unchecked a checkbox,\n                                    // add/remove the element value to the model array.\n                                    ko.utils.addOrRemoveItem(writableValue, elemValue, isChecked);\n                                }\n\n                                if (rawValueIsNonArrayObservable && ko.isWriteableObservable(modelValue)) {\n                                    modelValue(writableValue);\n                                }\n                            } else {\n                                if (isCheckbox) {\n                                    if (elemValue === undefined) {\n                                        elemValue = isChecked;\n                                    } else if (!isChecked) {\n                                        elemValue = undefined;\n                                    }\n                                }\n                                ko.expressionRewriting.writeValueToProperty(modelValue, allBindings, 'checked', elemValue, true);\n                            }\n                        };\n\n                        function updateView() {\n                            // This updates the view value from the model value.\n                            // It runs in response to changes in the bound (checked) value.\n                            var modelValue = ko.utils.unwrapObservable(valueAccessor()),\n                                elemValue = checkedValue();\n\n                            if (valueIsArray) {\n                                // When a checkbox is bound to an array, being checked represents its value being present in that array\n                                element.checked = ko.utils.arrayIndexOf(modelValue, elemValue) >= 0;\n                                oldElemValue = elemValue;\n                            } else if (isCheckbox && elemValue === undefined) {\n                                // When a checkbox is bound to any other value (not an array) and \"checkedValue\" is not defined,\n                                // being checked represents the value being trueish\n                                element.checked = !!modelValue;\n                            } else {\n                                // Otherwise, being checked means that the checkbox or radio button's value corresponds to the model value\n                                element.checked = (checkedValue() === modelValue);\n                            }\n                        };\n\n                        var isCheckbox = element.type == \"checkbox\",\n                            isRadio = element.type == \"radio\";\n\n                        // Only bind to check boxes and radio buttons\n                        if (!isCheckbox && !isRadio) {\n                            return;\n                        }\n\n                        var rawValue = valueAccessor(),\n                            valueIsArray = isCheckbox && (ko.utils.unwrapObservable(rawValue) instanceof Array),\n                            rawValueIsNonArrayObservable = !(valueIsArray && rawValue.push && rawValue.splice),\n                            useElementValue = isRadio || valueIsArray,\n                            oldElemValue = valueIsArray ? checkedValue() : undefined;\n\n                        // IE 6 won't allow radio buttons to be selected unless they have a name\n                        if (isRadio && !element.name)\n                            ko.bindingHandlers['uniqueName']['init'](element, function() { return true });\n\n                        // Set up two computeds to update the binding:\n\n                        // The first responds to changes in the checkedValue value and to element clicks\n                        ko.computed(updateModel, null, { disposeWhenNodeIsRemoved: element });\n                        ko.utils.registerEventHandler(element, \"click\", updateModel);\n\n                        // The second responds to changes in the model value (the one associated with the checked binding)\n                        ko.computed(updateView, null, { disposeWhenNodeIsRemoved: element });\n\n                        rawValue = undefined;\n                    }\n                };\n                ko.expressionRewriting.twoWayBindings['checked'] = true;\n\n                ko.bindingHandlers['checkedValue'] = {\n                    'update': function (element, valueAccessor) {\n                        element.value = ko.utils.unwrapObservable(valueAccessor());\n                    }\n                };\n\n            })();var classesWrittenByBindingKey = '__ko__cssValue';\n            ko.bindingHandlers['class'] = {\n                'update': function (element, valueAccessor) {\n                    var value = ko.utils.stringTrim(ko.utils.unwrapObservable(valueAccessor()));\n                    ko.utils.toggleDomNodeCssClass(element, element[classesWrittenByBindingKey], false);\n                    element[classesWrittenByBindingKey] = value;\n                    ko.utils.toggleDomNodeCssClass(element, value, true);\n                }\n            };\n\n            ko.bindingHandlers['css'] = {\n                'update': function (element, valueAccessor) {\n                    var value = ko.utils.unwrapObservable(valueAccessor());\n                    if (value !== null && typeof value == \"object\") {\n                        ko.utils.objectForEach(value, function(className, shouldHaveClass) {\n                            shouldHaveClass = ko.utils.unwrapObservable(shouldHaveClass);\n                            ko.utils.toggleDomNodeCssClass(element, className, shouldHaveClass);\n                        });\n                    } else {\n                        ko.bindingHandlers['class']['update'](element, valueAccessor);\n                    }\n                }\n            };\n            ko.bindingHandlers['enable'] = {\n                'update': function (element, valueAccessor) {\n                    var value = ko.utils.unwrapObservable(valueAccessor());\n                    if (value && element.disabled)\n                        element.removeAttribute(\"disabled\");\n                    else if ((!value) && (!element.disabled))\n                        element.disabled = true;\n                }\n            };\n\n            ko.bindingHandlers['disable'] = {\n                'update': function (element, valueAccessor) {\n                    ko.bindingHandlers['enable']['update'](element, function() { return !ko.utils.unwrapObservable(valueAccessor()) });\n                }\n            };\n// For certain common events (currently just 'click'), allow a simplified data-binding syntax\n// e.g. click:handler instead of the usual full-length event:{click:handler}\n            function makeEventHandlerShortcut(eventName) {\n                ko.bindingHandlers[eventName] = {\n                    'init': function(element, valueAccessor, allBindings, viewModel, bindingContext) {\n                        var newValueAccessor = function () {\n                            var result = {};\n                            result[eventName] = valueAccessor();\n                            return result;\n                        };\n                        return ko.bindingHandlers['event']['init'].call(this, element, newValueAccessor, allBindings, viewModel, bindingContext);\n                    }\n                }\n            }\n\n            ko.bindingHandlers['event'] = {\n                'init' : function (element, valueAccessor, allBindings, viewModel, bindingContext) {\n                    var eventsToHandle = valueAccessor() || {};\n                    ko.utils.objectForEach(eventsToHandle, function(eventName) {\n                        if (typeof eventName == \"string\") {\n                            ko.utils.registerEventHandler(element, eventName, function (event) {\n                                var handlerReturnValue;\n                                var handlerFunction = valueAccessor()[eventName];\n                                if (!handlerFunction)\n                                    return;\n\n                                try {\n                                    // Take all the event args, and prefix with the viewmodel\n                                    var argsForHandler = ko.utils.makeArray(arguments);\n                                    viewModel = bindingContext['$data'];\n                                    argsForHandler.unshift(viewModel);\n                                    handlerReturnValue = handlerFunction.apply(viewModel, argsForHandler);\n                                } finally {\n                                    if (handlerReturnValue !== true) { // Normally we want to prevent default action. Developer can override this be explicitly returning true.\n                                        if (event.preventDefault)\n                                            event.preventDefault();\n                                        else\n                                            event.returnValue = false;\n                                    }\n                                }\n\n                                var bubble = allBindings.get(eventName + 'Bubble') !== false;\n                                if (!bubble) {\n                                    event.cancelBubble = true;\n                                    if (event.stopPropagation)\n                                        event.stopPropagation();\n                                }\n                            });\n                        }\n                    });\n                }\n            };\n// \"foreach: someExpression\" is equivalent to \"template: { foreach: someExpression }\"\n// \"foreach: { data: someExpression, afterAdd: myfn }\" is equivalent to \"template: { foreach: someExpression, afterAdd: myfn }\"\n            ko.bindingHandlers['foreach'] = {\n                makeTemplateValueAccessor: function(valueAccessor) {\n                    return function() {\n                        var modelValue = valueAccessor(),\n                            unwrappedValue = ko.utils.peekObservable(modelValue);    // Unwrap without setting a dependency here\n\n                        // If unwrappedValue is the array, pass in the wrapped value on its own\n                        // The value will be unwrapped and tracked within the template binding\n                        // (See https://github.com/SteveSanderson/knockout/issues/523)\n                        if ((!unwrappedValue) || typeof unwrappedValue.length == \"number\")\n                            return { 'foreach': modelValue, 'templateEngine': ko.nativeTemplateEngine.instance };\n\n                        // If unwrappedValue.data is the array, preserve all relevant options and unwrap again value so we get updates\n                        ko.utils.unwrapObservable(modelValue);\n                        return {\n                            'foreach': unwrappedValue['data'],\n                            'as': unwrappedValue['as'],\n                            'noChildContext': unwrappedValue['noChildContext'],\n                            'includeDestroyed': unwrappedValue['includeDestroyed'],\n                            'afterAdd': unwrappedValue['afterAdd'],\n                            'beforeRemove': unwrappedValue['beforeRemove'],\n                            'afterRender': unwrappedValue['afterRender'],\n                            'beforeMove': unwrappedValue['beforeMove'],\n                            'afterMove': unwrappedValue['afterMove'],\n                            'templateEngine': ko.nativeTemplateEngine.instance\n                        };\n                    };\n                },\n                'init': function(element, valueAccessor, allBindings, viewModel, bindingContext) {\n                    return ko.bindingHandlers['template']['init'](element, ko.bindingHandlers['foreach'].makeTemplateValueAccessor(valueAccessor));\n                },\n                'update': function(element, valueAccessor, allBindings, viewModel, bindingContext) {\n                    return ko.bindingHandlers['template']['update'](element, ko.bindingHandlers['foreach'].makeTemplateValueAccessor(valueAccessor), allBindings, viewModel, bindingContext);\n                }\n            };\n            ko.expressionRewriting.bindingRewriteValidators['foreach'] = false; // Can't rewrite control flow bindings\n            ko.virtualElements.allowedBindings['foreach'] = true;\n            var hasfocusUpdatingProperty = '__ko_hasfocusUpdating';\n            var hasfocusLastValue = '__ko_hasfocusLastValue';\n            ko.bindingHandlers['hasfocus'] = {\n                'init': function(element, valueAccessor, allBindings) {\n                    var handleElementFocusChange = function(isFocused) {\n                        // Where possible, ignore which event was raised and determine focus state using activeElement,\n                        // as this avoids phantom focus/blur events raised when changing tabs in modern browsers.\n                        // However, not all KO-targeted browsers (Firefox 2) support activeElement. For those browsers,\n                        // prevent a loss of focus when changing tabs/windows by setting a flag that prevents hasfocus\n                        // from calling 'blur()' on the element when it loses focus.\n                        // Discussion at https://github.com/SteveSanderson/knockout/pull/352\n                        element[hasfocusUpdatingProperty] = true;\n                        var ownerDoc = element.ownerDocument;\n                        if (\"activeElement\" in ownerDoc) {\n                            var active;\n                            try {\n                                active = ownerDoc.activeElement;\n                            } catch(e) {\n                                // IE9 throws if you access activeElement during page load (see issue #703)\n                                active = ownerDoc.body;\n                            }\n                            isFocused = (active === element);\n                        }\n                        var modelValue = valueAccessor();\n                        ko.expressionRewriting.writeValueToProperty(modelValue, allBindings, 'hasfocus', isFocused, true);\n\n                        //cache the latest value, so we can avoid unnecessarily calling focus/blur in the update function\n                        element[hasfocusLastValue] = isFocused;\n                        element[hasfocusUpdatingProperty] = false;\n                    };\n                    var handleElementFocusIn = handleElementFocusChange.bind(null, true);\n                    var handleElementFocusOut = handleElementFocusChange.bind(null, false);\n\n                    ko.utils.registerEventHandler(element, \"focus\", handleElementFocusIn);\n                    ko.utils.registerEventHandler(element, \"focusin\", handleElementFocusIn); // For IE\n                    ko.utils.registerEventHandler(element, \"blur\",  handleElementFocusOut);\n                    ko.utils.registerEventHandler(element, \"focusout\",  handleElementFocusOut); // For IE\n\n                    // Assume element is not focused (prevents \"blur\" being called initially)\n                    element[hasfocusLastValue] = false;\n                },\n                'update': function(element, valueAccessor) {\n                    var value = !!ko.utils.unwrapObservable(valueAccessor());\n\n                    if (!element[hasfocusUpdatingProperty] && element[hasfocusLastValue] !== value) {\n                        value ? element.focus() : element.blur();\n\n                        // In IE, the blur method doesn't always cause the element to lose focus (for example, if the window is not in focus).\n                        // Setting focus to the body element does seem to be reliable in IE, but should only be used if we know that the current\n                        // element was focused already.\n                        if (!value && element[hasfocusLastValue]) {\n                            element.ownerDocument.body.focus();\n                        }\n\n                        // For IE, which doesn't reliably fire \"focus\" or \"blur\" events synchronously\n                        ko.dependencyDetection.ignore(ko.utils.triggerEvent, null, [element, value ? \"focusin\" : \"focusout\"]);\n                    }\n                }\n            };\n            ko.expressionRewriting.twoWayBindings['hasfocus'] = true;\n\n            ko.bindingHandlers['hasFocus'] = ko.bindingHandlers['hasfocus']; // Make \"hasFocus\" an alias\n            ko.expressionRewriting.twoWayBindings['hasFocus'] = 'hasfocus';\n            ko.bindingHandlers['html'] = {\n                'init': function() {\n                    // Prevent binding on the dynamically-injected HTML (as developers are unlikely to expect that, and it has security implications)\n                    return { 'controlsDescendantBindings': true };\n                },\n                'update': function (element, valueAccessor) {\n                    // setHtml will unwrap the value if needed\n                    ko.utils.setHtml(element, valueAccessor());\n                }\n            };\n            (function () {\n\n// Makes a binding like with or if\n                function makeWithIfBinding(bindingKey, isWith, isNot) {\n                    ko.bindingHandlers[bindingKey] = {\n                        'init': function(element, valueAccessor, allBindings, viewModel, bindingContext) {\n                            var didDisplayOnLastUpdate, savedNodes, contextOptions = {}, completeOnRender, needAsyncContext, renderOnEveryChange;\n\n                            if (isWith) {\n                                var as = allBindings.get('as'), noChildContext = allBindings.get('noChildContext');\n                                renderOnEveryChange = !(as && noChildContext);\n                                contextOptions = { 'as': as, 'noChildContext': noChildContext, 'exportDependencies': renderOnEveryChange };\n                            }\n\n                            completeOnRender = allBindings.get(\"completeOn\") == \"render\";\n                            needAsyncContext = completeOnRender || allBindings['has'](ko.bindingEvent.descendantsComplete);\n\n                            ko.computed(function() {\n                                var value = ko.utils.unwrapObservable(valueAccessor()),\n                                    shouldDisplay = !isNot !== !value, // equivalent to isNot ? !value : !!value,\n                                    isInitial = !savedNodes,\n                                    childContext;\n\n                                if (!renderOnEveryChange && shouldDisplay === didDisplayOnLastUpdate) {\n                                    return;\n                                }\n\n                                if (needAsyncContext) {\n                                    bindingContext = ko.bindingEvent.startPossiblyAsyncContentBinding(element, bindingContext);\n                                }\n\n                                if (shouldDisplay) {\n                                    if (!isWith || renderOnEveryChange) {\n                                        contextOptions['dataDependency'] = ko.computedContext.computed();\n                                    }\n\n                                    if (isWith) {\n                                        childContext = bindingContext['createChildContext'](typeof value == \"function\" ? value : valueAccessor, contextOptions);\n                                    } else if (ko.computedContext.getDependenciesCount()) {\n                                        childContext = bindingContext['extend'](null, contextOptions);\n                                    } else {\n                                        childContext = bindingContext;\n                                    }\n                                }\n\n                                // Save a copy of the inner nodes on the initial update, but only if we have dependencies.\n                                if (isInitial && ko.computedContext.getDependenciesCount()) {\n                                    savedNodes = ko.utils.cloneNodes(ko.virtualElements.childNodes(element), true /* shouldCleanNodes */);\n                                }\n\n                                if (shouldDisplay) {\n                                    if (!isInitial) {\n                                        ko.virtualElements.setDomNodeChildren(element, ko.utils.cloneNodes(savedNodes));\n                                    }\n\n                                    ko.applyBindingsToDescendants(childContext, element);\n                                } else {\n                                    ko.virtualElements.emptyNode(element);\n\n                                    if (!completeOnRender) {\n                                        ko.bindingEvent.notify(element, ko.bindingEvent.childrenComplete);\n                                    }\n                                }\n\n                                didDisplayOnLastUpdate = shouldDisplay;\n\n                            }, null, { disposeWhenNodeIsRemoved: element });\n\n                            return { 'controlsDescendantBindings': true };\n                        }\n                    };\n                    ko.expressionRewriting.bindingRewriteValidators[bindingKey] = false; // Can't rewrite control flow bindings\n                    ko.virtualElements.allowedBindings[bindingKey] = true;\n                }\n\n// Construct the actual binding handlers\n                makeWithIfBinding('if');\n                makeWithIfBinding('ifnot', false /* isWith */, true /* isNot */);\n                makeWithIfBinding('with', true /* isWith */);\n\n            })();ko.bindingHandlers['let'] = {\n                'init': function(element, valueAccessor, allBindings, viewModel, bindingContext) {\n                    // Make a modified binding context, with extra properties, and apply it to descendant elements\n                    var innerContext = bindingContext['extend'](valueAccessor);\n                    ko.applyBindingsToDescendants(innerContext, element);\n\n                    return { 'controlsDescendantBindings': true };\n                }\n            };\n            ko.virtualElements.allowedBindings['let'] = true;\n            var captionPlaceholder = {};\n            ko.bindingHandlers['options'] = {\n                'init': function(element) {\n                    if (ko.utils.tagNameLower(element) !== \"select\")\n                        throw new Error(\"options binding applies only to SELECT elements\");\n\n                    // Remove all existing <option>s.\n                    while (element.length > 0) {\n                        element.remove(0);\n                    }\n\n                    // Ensures that the binding processor doesn't try to bind the options\n                    return { 'controlsDescendantBindings': true };\n                },\n                'update': function (element, valueAccessor, allBindings) {\n                    function selectedOptions() {\n                        return ko.utils.arrayFilter(element.options, function (node) { return node.selected; });\n                    }\n\n                    var selectWasPreviouslyEmpty = element.length == 0,\n                        multiple = element.multiple,\n                        previousScrollTop = (!selectWasPreviouslyEmpty && multiple) ? element.scrollTop : null,\n                        unwrappedArray = ko.utils.unwrapObservable(valueAccessor()),\n                        valueAllowUnset = allBindings.get('valueAllowUnset') && allBindings['has']('value'),\n                        includeDestroyed = allBindings.get('optionsIncludeDestroyed'),\n                        arrayToDomNodeChildrenOptions = {},\n                        captionValue,\n                        filteredArray,\n                        previousSelectedValues = [];\n\n                    if (!valueAllowUnset) {\n                        if (multiple) {\n                            previousSelectedValues = ko.utils.arrayMap(selectedOptions(), ko.selectExtensions.readValue);\n                        } else if (element.selectedIndex >= 0) {\n                            previousSelectedValues.push(ko.selectExtensions.readValue(element.options[element.selectedIndex]));\n                        }\n                    }\n\n                    if (unwrappedArray) {\n                        if (typeof unwrappedArray.length == \"undefined\") // Coerce single value into array\n                            unwrappedArray = [unwrappedArray];\n\n                        // Filter out any entries marked as destroyed\n                        filteredArray = ko.utils.arrayFilter(unwrappedArray, function(item) {\n                            return includeDestroyed || item === undefined || item === null || !ko.utils.unwrapObservable(item['_destroy']);\n                        });\n\n                        // If caption is included, add it to the array\n                        if (allBindings['has']('optionsCaption')) {\n                            captionValue = ko.utils.unwrapObservable(allBindings.get('optionsCaption'));\n                            // If caption value is null or undefined, don't show a caption\n                            if (captionValue !== null && captionValue !== undefined) {\n                                filteredArray.unshift(captionPlaceholder);\n                            }\n                        }\n                    } else {\n                        // If a falsy value is provided (e.g. null), we'll simply empty the select element\n                    }\n\n                    function applyToObject(object, predicate, defaultValue) {\n                        var predicateType = typeof predicate;\n                        if (predicateType == \"function\")    // Given a function; run it against the data value\n                            return predicate(object);\n                        else if (predicateType == \"string\") // Given a string; treat it as a property name on the data value\n                            return object[predicate];\n                        else                                // Given no optionsText arg; use the data value itself\n                            return defaultValue;\n                    }\n\n                    // The following functions can run at two different times:\n                    // The first is when the whole array is being updated directly from this binding handler.\n                    // The second is when an observable value for a specific array entry is updated.\n                    // oldOptions will be empty in the first case, but will be filled with the previously generated option in the second.\n                    var itemUpdate = false;\n                    function optionForArrayItem(arrayEntry, index, oldOptions) {\n                        if (oldOptions.length) {\n                            previousSelectedValues = !valueAllowUnset && oldOptions[0].selected ? [ ko.selectExtensions.readValue(oldOptions[0]) ] : [];\n                            itemUpdate = true;\n                        }\n                        var option = element.ownerDocument.createElement(\"option\");\n                        if (arrayEntry === captionPlaceholder) {\n                            ko.utils.setTextContent(option, allBindings.get('optionsCaption'));\n                            ko.selectExtensions.writeValue(option, undefined);\n                        } else {\n                            // Apply a value to the option element\n                            var optionValue = applyToObject(arrayEntry, allBindings.get('optionsValue'), arrayEntry);\n                            ko.selectExtensions.writeValue(option, ko.utils.unwrapObservable(optionValue));\n\n                            // Apply some text to the option element\n                            var optionText = applyToObject(arrayEntry, allBindings.get('optionsText'), optionValue);\n                            ko.utils.setTextContent(option, optionText);\n                        }\n                        return [option];\n                    }\n\n                    // By using a beforeRemove callback, we delay the removal until after new items are added. This fixes a selection\n                    // problem in IE<=8 and Firefox. See https://github.com/knockout/knockout/issues/1208\n                    arrayToDomNodeChildrenOptions['beforeRemove'] =\n                        function (option) {\n                            element.removeChild(option);\n                        };\n\n                    function setSelectionCallback(arrayEntry, newOptions) {\n                        if (itemUpdate && valueAllowUnset) {\n                            // The model value is authoritative, so make sure its value is the one selected\n                            ko.bindingEvent.notify(element, ko.bindingEvent.childrenComplete);\n                        } else if (previousSelectedValues.length) {\n                            // IE6 doesn't like us to assign selection to OPTION nodes before they're added to the document.\n                            // That's why we first added them without selection. Now it's time to set the selection.\n                            var isSelected = ko.utils.arrayIndexOf(previousSelectedValues, ko.selectExtensions.readValue(newOptions[0])) >= 0;\n                            ko.utils.setOptionNodeSelectionState(newOptions[0], isSelected);\n\n                            // If this option was changed from being selected during a single-item update, notify the change\n                            if (itemUpdate && !isSelected) {\n                                ko.dependencyDetection.ignore(ko.utils.triggerEvent, null, [element, \"change\"]);\n                            }\n                        }\n                    }\n\n                    var callback = setSelectionCallback;\n                    if (allBindings['has']('optionsAfterRender') && typeof allBindings.get('optionsAfterRender') == \"function\") {\n                        callback = function(arrayEntry, newOptions) {\n                            setSelectionCallback(arrayEntry, newOptions);\n                            ko.dependencyDetection.ignore(allBindings.get('optionsAfterRender'), null, [newOptions[0], arrayEntry !== captionPlaceholder ? arrayEntry : undefined]);\n                        }\n                    }\n\n                    ko.utils.setDomNodeChildrenFromArrayMapping(element, filteredArray, optionForArrayItem, arrayToDomNodeChildrenOptions, callback);\n\n                    if (!valueAllowUnset) {\n                        // Determine if the selection has changed as a result of updating the options list\n                        var selectionChanged;\n                        if (multiple) {\n                            // For a multiple-select box, compare the new selection count to the previous one\n                            // But if nothing was selected before, the selection can't have changed\n                            selectionChanged = previousSelectedValues.length && selectedOptions().length < previousSelectedValues.length;\n                        } else {\n                            // For a single-select box, compare the current value to the previous value\n                            // But if nothing was selected before or nothing is selected now, just look for a change in selection\n                            selectionChanged = (previousSelectedValues.length && element.selectedIndex >= 0)\n                                ? (ko.selectExtensions.readValue(element.options[element.selectedIndex]) !== previousSelectedValues[0])\n                                : (previousSelectedValues.length || element.selectedIndex >= 0);\n                        }\n\n                        // Ensure consistency between model value and selected option.\n                        // If the dropdown was changed so that selection is no longer the same,\n                        // notify the value or selectedOptions binding.\n                        if (selectionChanged) {\n                            ko.dependencyDetection.ignore(ko.utils.triggerEvent, null, [element, \"change\"]);\n                        }\n                    }\n\n                    if (valueAllowUnset || ko.computedContext.isInitial()) {\n                        ko.bindingEvent.notify(element, ko.bindingEvent.childrenComplete);\n                    }\n\n                    // Workaround for IE bug\n                    ko.utils.ensureSelectElementIsRenderedCorrectly(element);\n\n                    if (previousScrollTop && Math.abs(previousScrollTop - element.scrollTop) > 20)\n                        element.scrollTop = previousScrollTop;\n                }\n            };\n            ko.bindingHandlers['options'].optionValueDomDataKey = ko.utils.domData.nextKey();\n            ko.bindingHandlers['selectedOptions'] = {\n                'init': function (element, valueAccessor, allBindings) {\n                    function updateFromView() {\n                        var value = valueAccessor(), valueToWrite = [];\n                        ko.utils.arrayForEach(element.getElementsByTagName(\"option\"), function(node) {\n                            if (node.selected)\n                                valueToWrite.push(ko.selectExtensions.readValue(node));\n                        });\n                        ko.expressionRewriting.writeValueToProperty(value, allBindings, 'selectedOptions', valueToWrite);\n                    }\n\n                    function updateFromModel() {\n                        var newValue = ko.utils.unwrapObservable(valueAccessor()),\n                            previousScrollTop = element.scrollTop;\n\n                        if (newValue && typeof newValue.length == \"number\") {\n                            ko.utils.arrayForEach(element.getElementsByTagName(\"option\"), function(node) {\n                                var isSelected = ko.utils.arrayIndexOf(newValue, ko.selectExtensions.readValue(node)) >= 0;\n                                if (node.selected != isSelected) {      // This check prevents flashing of the select element in IE\n                                    ko.utils.setOptionNodeSelectionState(node, isSelected);\n                                }\n                            });\n                        }\n\n                        element.scrollTop = previousScrollTop;\n                    }\n\n                    if (ko.utils.tagNameLower(element) != \"select\") {\n                        throw new Error(\"selectedOptions binding applies only to SELECT elements\");\n                    }\n\n                    var updateFromModelComputed;\n                    ko.bindingEvent.subscribe(element, ko.bindingEvent.childrenComplete, function () {\n                        if (!updateFromModelComputed) {\n                            ko.utils.registerEventHandler(element, \"change\", updateFromView);\n                            updateFromModelComputed = ko.computed(updateFromModel, null, { disposeWhenNodeIsRemoved: element });\n                        } else {\n                            updateFromView();\n                        }\n                    }, null, { 'notifyImmediately': true });\n                },\n                'update': function() {} // Keep for backwards compatibility with code that may have wrapped binding\n            };\n            ko.expressionRewriting.twoWayBindings['selectedOptions'] = true;\n            ko.bindingHandlers['style'] = {\n                'update': function (element, valueAccessor) {\n                    var value = ko.utils.unwrapObservable(valueAccessor() || {});\n                    ko.utils.objectForEach(value, function(styleName, styleValue) {\n                        styleValue = ko.utils.unwrapObservable(styleValue);\n\n                        if (styleValue === null || styleValue === undefined || styleValue === false) {\n                            // Empty string removes the value, whereas null/undefined have no effect\n                            styleValue = \"\";\n                        }\n\n                        if (jQueryInstance) {\n                            jQueryInstance(element)['css'](styleName, styleValue);\n                        } else if (/^--/.test(styleName)) {\n                            // Is styleName a custom CSS property?\n                            element.style.setProperty(styleName, styleValue);\n                        } else {\n                            styleName = styleName.replace(/-(\\w)/g, function (all, letter) {\n                                return letter.toUpperCase();\n                            });\n\n                            var previousStyle = element.style[styleName];\n                            element.style[styleName] = styleValue;\n\n                            if (styleValue !== previousStyle && element.style[styleName] == previousStyle && !isNaN(styleValue)) {\n                                element.style[styleName] = styleValue + \"px\";\n                            }\n                        }\n                    });\n                }\n            };\n            ko.bindingHandlers['submit'] = {\n                'init': function (element, valueAccessor, allBindings, viewModel, bindingContext) {\n                    if (typeof valueAccessor() != \"function\")\n                        throw new Error(\"The value for a submit binding must be a function\");\n                    ko.utils.registerEventHandler(element, \"submit\", function (event) {\n                        var handlerReturnValue;\n                        var value = valueAccessor();\n                        try { handlerReturnValue = value.call(bindingContext['$data'], element); }\n                        finally {\n                            if (handlerReturnValue !== true) { // Normally we want to prevent default action. Developer can override this be explicitly returning true.\n                                if (event.preventDefault)\n                                    event.preventDefault();\n                                else\n                                    event.returnValue = false;\n                            }\n                        }\n                    });\n                }\n            };\n            ko.bindingHandlers['text'] = {\n                'init': function() {\n                    // Prevent binding on the dynamically-injected text node (as developers are unlikely to expect that, and it has security implications).\n                    // It should also make things faster, as we no longer have to consider whether the text node might be bindable.\n                    return { 'controlsDescendantBindings': true };\n                },\n                'update': function (element, valueAccessor) {\n                    ko.utils.setTextContent(element, valueAccessor());\n                }\n            };\n            ko.virtualElements.allowedBindings['text'] = true;\n            (function () {\n\n                if (window && window.navigator) {\n                    var parseVersion = function (matches) {\n                        if (matches) {\n                            return parseFloat(matches[1]);\n                        }\n                    };\n\n                    // Detect various browser versions because some old versions don't fully support the 'input' event\n                    var userAgent = window.navigator.userAgent,\n                        operaVersion, chromeVersion, safariVersion, firefoxVersion, ieVersion, edgeVersion;\n\n                    (operaVersion = window.opera && window.opera.version && parseInt(window.opera.version()))\n                    || (edgeVersion = parseVersion(userAgent.match(/Edge\\/([^ ]+)$/)))\n                    || (chromeVersion = parseVersion(userAgent.match(/Chrome\\/([^ ]+)/)))\n                    || (safariVersion = parseVersion(userAgent.match(/Version\\/([^ ]+) Safari/)))\n                    || (firefoxVersion = parseVersion(userAgent.match(/Firefox\\/([^ ]+)/)))\n                    || (ieVersion = ko.utils.ieVersion || parseVersion(userAgent.match(/MSIE ([^ ]+)/)))      // Detects up to IE 10\n                    || (ieVersion = parseVersion(userAgent.match(/rv:([^ )]+)/)));      // Detects IE 11\n                }\n\n// IE 8 and 9 have bugs that prevent the normal events from firing when the value changes.\n// But it does fire the 'selectionchange' event on many of those, presumably because the\n// cursor is moving and that counts as the selection changing. The 'selectionchange' event is\n// fired at the document level only and doesn't directly indicate which element changed. We\n// set up just one event handler for the document and use 'activeElement' to determine which\n// element was changed.\n                if (ieVersion >= 8 && ieVersion < 10) {\n                    var selectionChangeRegisteredName = ko.utils.domData.nextKey(),\n                        selectionChangeHandlerName = ko.utils.domData.nextKey();\n                    var selectionChangeHandler = function(event) {\n                        var target = this.activeElement,\n                            handler = target && ko.utils.domData.get(target, selectionChangeHandlerName);\n                        if (handler) {\n                            handler(event);\n                        }\n                    };\n                    var registerForSelectionChangeEvent = function (element, handler) {\n                        var ownerDoc = element.ownerDocument;\n                        if (!ko.utils.domData.get(ownerDoc, selectionChangeRegisteredName)) {\n                            ko.utils.domData.set(ownerDoc, selectionChangeRegisteredName, true);\n                            ko.utils.registerEventHandler(ownerDoc, 'selectionchange', selectionChangeHandler);\n                        }\n                        ko.utils.domData.set(element, selectionChangeHandlerName, handler);\n                    };\n                }\n\n                ko.bindingHandlers['textInput'] = {\n                    'init': function (element, valueAccessor, allBindings) {\n\n                        var previousElementValue = element.value,\n                            timeoutHandle,\n                            elementValueBeforeEvent;\n\n                        var updateModel = function (event) {\n                            clearTimeout(timeoutHandle);\n                            elementValueBeforeEvent = timeoutHandle = undefined;\n\n                            var elementValue = element.value;\n                            if (previousElementValue !== elementValue) {\n                                // Provide a way for tests to know exactly which event was processed\n                                if (DEBUG && event) element['_ko_textInputProcessedEvent'] = event.type;\n                                previousElementValue = elementValue;\n                                ko.expressionRewriting.writeValueToProperty(valueAccessor(), allBindings, 'textInput', elementValue);\n                            }\n                        };\n\n                        var deferUpdateModel = function (event) {\n                            if (!timeoutHandle) {\n                                // The elementValueBeforeEvent variable is set *only* during the brief gap between an\n                                // event firing and the updateModel function running. This allows us to ignore model\n                                // updates that are from the previous state of the element, usually due to techniques\n                                // such as rateLimit. Such updates, if not ignored, can cause keystrokes to be lost.\n                                elementValueBeforeEvent = element.value;\n                                var handler = DEBUG ? updateModel.bind(element, {type: event.type}) : updateModel;\n                                timeoutHandle = ko.utils.setTimeout(handler, 4);\n                            }\n                        };\n\n                        // IE9 will mess up the DOM if you handle events synchronously which results in DOM changes (such as other bindings);\n                        // so we'll make sure all updates are asynchronous\n                        var ieUpdateModel = ko.utils.ieVersion == 9 ? deferUpdateModel : updateModel,\n                            ourUpdate = false;\n\n                        var updateView = function () {\n                            var modelValue = ko.utils.unwrapObservable(valueAccessor());\n\n                            if (modelValue === null || modelValue === undefined) {\n                                modelValue = '';\n                            }\n\n                            if (elementValueBeforeEvent !== undefined && modelValue === elementValueBeforeEvent) {\n                                ko.utils.setTimeout(updateView, 4);\n                                return;\n                            }\n\n                            // Update the element only if the element and model are different. On some browsers, updating the value\n                            // will move the cursor to the end of the input, which would be bad while the user is typing.\n                            if (element.value !== modelValue) {\n                                ourUpdate = true;  // Make sure we ignore events (propertychange) that result from updating the value\n                                element.value = modelValue;\n                                ourUpdate = false;\n                                previousElementValue = element.value; // In case the browser changes the value (see #2281)\n                            }\n                        };\n\n                        var onEvent = function (event, handler) {\n                            ko.utils.registerEventHandler(element, event, handler);\n                        };\n\n                        if (DEBUG && ko.bindingHandlers['textInput']['_forceUpdateOn']) {\n                            // Provide a way for tests to specify exactly which events are bound\n                            ko.utils.arrayForEach(ko.bindingHandlers['textInput']['_forceUpdateOn'], function(eventName) {\n                                if (eventName.slice(0,5) == 'after') {\n                                    onEvent(eventName.slice(5), deferUpdateModel);\n                                } else {\n                                    onEvent(eventName, updateModel);\n                                }\n                            });\n                        } else {\n                            if (ieVersion) {\n                                // All versions (including 11) of Internet Explorer have a bug that they don't generate an input or propertychange event when ESC is pressed\n                                onEvent('keypress', updateModel);\n                            }\n                            if (ieVersion < 11) {\n                                // Internet Explorer <= 8 doesn't support the 'input' event, but does include 'propertychange' that fires whenever\n                                // any property of an element changes. Unlike 'input', it also fires if a property is changed from JavaScript code,\n                                // but that's an acceptable compromise for this binding. IE 9 and 10 support 'input', but since they don't always\n                                // fire it when using autocomplete, we'll use 'propertychange' for them also.\n                                onEvent('propertychange', function(event) {\n                                    if (!ourUpdate && event.propertyName === 'value') {\n                                        ieUpdateModel(event);\n                                    }\n                                });\n                            }\n                            if (ieVersion == 8) {\n                                // IE 8 has a bug where it fails to fire 'propertychange' on the first update following a value change from\n                                // JavaScript code. It also doesn't fire if you clear the entire value. To fix this, we bind to the following\n                                // events too.\n                                onEvent('keyup', updateModel);      // A single keystoke\n                                onEvent('keydown', updateModel);    // The first character when a key is held down\n                            }\n                            if (registerForSelectionChangeEvent) {\n                                // Internet Explorer 9 doesn't fire the 'input' event when deleting text, including using\n                                // the backspace, delete, or ctrl-x keys, clicking the 'x' to clear the input, dragging text\n                                // out of the field, and cutting or deleting text using the context menu. 'selectionchange'\n                                // can detect all of those except dragging text out of the field, for which we use 'dragend'.\n                                // These are also needed in IE8 because of the bug described above.\n                                registerForSelectionChangeEvent(element, ieUpdateModel);  // 'selectionchange' covers cut, paste, drop, delete, etc.\n                                onEvent('dragend', deferUpdateModel);\n                            }\n\n                            if (!ieVersion || ieVersion >= 9) {\n                                // All other supported browsers support the 'input' event, which fires whenever the content of the element is changed\n                                // through the user interface.\n                                onEvent('input', ieUpdateModel);\n                            }\n\n                            if (safariVersion < 5 && ko.utils.tagNameLower(element) === \"textarea\") {\n                                // Safari <5 doesn't fire the 'input' event for <textarea> elements (it does fire 'textInput'\n                                // but only when typing). So we'll just catch as much as we can with keydown, cut, and paste.\n                                onEvent('keydown', deferUpdateModel);\n                                onEvent('paste', deferUpdateModel);\n                                onEvent('cut', deferUpdateModel);\n                            } else if (operaVersion < 11) {\n                                // Opera 10 doesn't always fire the 'input' event for cut, paste, undo & drop operations.\n                                // We can try to catch some of those using 'keydown'.\n                                onEvent('keydown', deferUpdateModel);\n                            } else if (firefoxVersion < 4.0) {\n                                // Firefox <= 3.6 doesn't fire the 'input' event when text is filled in through autocomplete\n                                onEvent('DOMAutoComplete', updateModel);\n\n                                // Firefox <=3.5 doesn't fire the 'input' event when text is dropped into the input.\n                                onEvent('dragdrop', updateModel);       // <3.5\n                                onEvent('drop', updateModel);           // 3.5\n                            } else if (edgeVersion && element.type === \"number\") {\n                                // Microsoft Edge doesn't fire 'input' or 'change' events for number inputs when\n                                // the value is changed via the up / down arrow keys\n                                onEvent('keydown', deferUpdateModel);\n                            }\n                        }\n\n                        // Bind to the change event so that we can catch programmatic updates of the value that fire this event.\n                        onEvent('change', updateModel);\n\n                        // To deal with browsers that don't notify any kind of event for some changes (IE, Safari, etc.)\n                        onEvent('blur', updateModel);\n\n                        ko.computed(updateView, null, { disposeWhenNodeIsRemoved: element });\n                    }\n                };\n                ko.expressionRewriting.twoWayBindings['textInput'] = true;\n\n// textinput is an alias for textInput\n                ko.bindingHandlers['textinput'] = {\n                    // preprocess is the only way to set up a full alias\n                    'preprocess': function (value, name, addBinding) {\n                        addBinding('textInput', value);\n                    }\n                };\n\n            })();ko.bindingHandlers['uniqueName'] = {\n                'init': function (element, valueAccessor) {\n                    if (valueAccessor()) {\n                        var name = \"ko_unique_\" + (++ko.bindingHandlers['uniqueName'].currentIndex);\n                        ko.utils.setElementName(element, name);\n                    }\n                }\n            };\n            ko.bindingHandlers['uniqueName'].currentIndex = 0;\n            ko.bindingHandlers['using'] = {\n                'init': function(element, valueAccessor, allBindings, viewModel, bindingContext) {\n                    var options;\n\n                    if (allBindings['has']('as')) {\n                        options = { 'as': allBindings.get('as'), 'noChildContext': allBindings.get('noChildContext') };\n                    }\n\n                    var innerContext = bindingContext['createChildContext'](valueAccessor, options);\n                    ko.applyBindingsToDescendants(innerContext, element);\n\n                    return { 'controlsDescendantBindings': true };\n                }\n            };\n            ko.virtualElements.allowedBindings['using'] = true;\n            ko.bindingHandlers['value'] = {\n                'init': function (element, valueAccessor, allBindings) {\n                    var tagName = ko.utils.tagNameLower(element),\n                        isInputElement = tagName == \"input\";\n\n                    // If the value binding is placed on a radio/checkbox, then just pass through to checkedValue and quit\n                    if (isInputElement && (element.type == \"checkbox\" || element.type == \"radio\")) {\n                        ko.applyBindingAccessorsToNode(element, { 'checkedValue': valueAccessor });\n                        return;\n                    }\n\n                    var eventsToCatch = [];\n                    var requestedEventsToCatch = allBindings.get(\"valueUpdate\");\n                    var propertyChangedFired = false;\n                    var elementValueBeforeEvent = null;\n\n                    if (requestedEventsToCatch) {\n                        // Allow both individual event names, and arrays of event names\n                        if (typeof requestedEventsToCatch == \"string\") {\n                            eventsToCatch = [requestedEventsToCatch];\n                        } else {\n                            eventsToCatch = ko.utils.arrayGetDistinctValues(requestedEventsToCatch);\n                        }\n                        ko.utils.arrayRemoveItem(eventsToCatch, \"change\");  // We'll subscribe to \"change\" events later\n                    }\n\n                    var valueUpdateHandler = function() {\n                        elementValueBeforeEvent = null;\n                        propertyChangedFired = false;\n                        var modelValue = valueAccessor();\n                        var elementValue = ko.selectExtensions.readValue(element);\n                        ko.expressionRewriting.writeValueToProperty(modelValue, allBindings, 'value', elementValue);\n                    }\n\n                    // Workaround for https://github.com/SteveSanderson/knockout/issues/122\n                    // IE doesn't fire \"change\" events on textboxes if the user selects a value from its autocomplete list\n                    var ieAutoCompleteHackNeeded = ko.utils.ieVersion && isInputElement && element.type == \"text\"\n                        && element.autocomplete != \"off\" && (!element.form || element.form.autocomplete != \"off\");\n                    if (ieAutoCompleteHackNeeded && ko.utils.arrayIndexOf(eventsToCatch, \"propertychange\") == -1) {\n                        ko.utils.registerEventHandler(element, \"propertychange\", function () { propertyChangedFired = true });\n                        ko.utils.registerEventHandler(element, \"focus\", function () { propertyChangedFired = false });\n                        ko.utils.registerEventHandler(element, \"blur\", function() {\n                            if (propertyChangedFired) {\n                                valueUpdateHandler();\n                            }\n                        });\n                    }\n\n                    ko.utils.arrayForEach(eventsToCatch, function(eventName) {\n                        // The syntax \"after<eventname>\" means \"run the handler asynchronously after the event\"\n                        // This is useful, for example, to catch \"keydown\" events after the browser has updated the control\n                        // (otherwise, ko.selectExtensions.readValue(this) will receive the control's value *before* the key event)\n                        var handler = valueUpdateHandler;\n                        if (ko.utils.stringStartsWith(eventName, \"after\")) {\n                            handler = function() {\n                                // The elementValueBeforeEvent variable is non-null *only* during the brief gap between\n                                // a keyX event firing and the valueUpdateHandler running, which is scheduled to happen\n                                // at the earliest asynchronous opportunity. We store this temporary information so that\n                                // if, between keyX and valueUpdateHandler, the underlying model value changes separately,\n                                // we can overwrite that model value change with the value the user just typed. Otherwise,\n                                // techniques like rateLimit can trigger model changes at critical moments that will\n                                // override the user's inputs, causing keystrokes to be lost.\n                                elementValueBeforeEvent = ko.selectExtensions.readValue(element);\n                                ko.utils.setTimeout(valueUpdateHandler, 0);\n                            };\n                            eventName = eventName.substring(\"after\".length);\n                        }\n                        ko.utils.registerEventHandler(element, eventName, handler);\n                    });\n\n                    var updateFromModel;\n\n                    if (isInputElement && element.type == \"file\") {\n                        // For file input elements, can only write the empty string\n                        updateFromModel = function () {\n                            var newValue = ko.utils.unwrapObservable(valueAccessor());\n                            if (newValue === null || newValue === undefined || newValue === \"\") {\n                                element.value = \"\";\n                            } else {\n                                ko.dependencyDetection.ignore(valueUpdateHandler);  // reset the model to match the element\n                            }\n                        }\n                    } else {\n                        updateFromModel = function () {\n                            var newValue = ko.utils.unwrapObservable(valueAccessor());\n                            var elementValue = ko.selectExtensions.readValue(element);\n\n                            if (elementValueBeforeEvent !== null && newValue === elementValueBeforeEvent) {\n                                ko.utils.setTimeout(updateFromModel, 0);\n                                return;\n                            }\n\n                            var valueHasChanged = newValue !== elementValue;\n\n                            if (valueHasChanged || elementValue === undefined) {\n                                if (tagName === \"select\") {\n                                    var allowUnset = allBindings.get('valueAllowUnset');\n                                    ko.selectExtensions.writeValue(element, newValue, allowUnset);\n                                    if (!allowUnset && newValue !== ko.selectExtensions.readValue(element)) {\n                                        // If you try to set a model value that can't be represented in an already-populated dropdown, reject that change,\n                                        // because you're not allowed to have a model value that disagrees with a visible UI selection.\n                                        ko.dependencyDetection.ignore(valueUpdateHandler);\n                                    }\n                                } else {\n                                    ko.selectExtensions.writeValue(element, newValue);\n                                }\n                            }\n                        };\n                    }\n\n                    if (tagName === \"select\") {\n                        var updateFromModelComputed;\n                        ko.bindingEvent.subscribe(element, ko.bindingEvent.childrenComplete, function () {\n                            if (!updateFromModelComputed) {\n                                ko.utils.registerEventHandler(element, \"change\", valueUpdateHandler);\n                                updateFromModelComputed = ko.computed(updateFromModel, null, { disposeWhenNodeIsRemoved: element });\n                            } else if (allBindings.get('valueAllowUnset')) {\n                                updateFromModel();\n                            } else {\n                                valueUpdateHandler();\n                            }\n                        }, null, { 'notifyImmediately': true });\n                    } else {\n                        ko.utils.registerEventHandler(element, \"change\", valueUpdateHandler);\n                        ko.computed(updateFromModel, null, { disposeWhenNodeIsRemoved: element });\n                    }\n                },\n                'update': function() {} // Keep for backwards compatibility with code that may have wrapped value binding\n            };\n            ko.expressionRewriting.twoWayBindings['value'] = true;\n            ko.bindingHandlers['visible'] = {\n                'update': function (element, valueAccessor) {\n                    var value = ko.utils.unwrapObservable(valueAccessor());\n                    var isCurrentlyVisible = !(element.style.display == \"none\");\n                    if (value && !isCurrentlyVisible)\n                        element.style.display = \"\";\n                    else if ((!value) && isCurrentlyVisible)\n                        element.style.display = \"none\";\n                }\n            };\n\n            ko.bindingHandlers['hidden'] = {\n                'update': function (element, valueAccessor) {\n                    ko.bindingHandlers['visible']['update'](element, function() { return !ko.utils.unwrapObservable(valueAccessor()) });\n                }\n            };\n// 'click' is just a shorthand for the usual full-length event:{click:handler}\n            makeEventHandlerShortcut('click');\n// If you want to make a custom template engine,\n//\n// [1] Inherit from this class (like ko.nativeTemplateEngine does)\n// [2] Override 'renderTemplateSource', supplying a function with this signature:\n//\n//        function (templateSource, bindingContext, options) {\n//            // - templateSource.text() is the text of the template you should render\n//            // - bindingContext.$data is the data you should pass into the template\n//            //   - you might also want to make bindingContext.$parent, bindingContext.$parents,\n//            //     and bindingContext.$root available in the template too\n//            // - options gives you access to any other properties set on \"data-bind: { template: options }\"\n//            // - templateDocument is the document object of the template\n//            //\n//            // Return value: an array of DOM nodes\n//        }\n//\n// [3] Override 'createJavaScriptEvaluatorBlock', supplying a function with this signature:\n//\n//        function (script) {\n//            // Return value: Whatever syntax means \"Evaluate the JavaScript statement 'script' and output the result\"\n//            //               For example, the jquery.tmpl template engine converts 'someScript' to '${ someScript }'\n//        }\n//\n//     This is only necessary if you want to allow data-bind attributes to reference arbitrary template variables.\n//     If you don't want to allow that, you can set the property 'allowTemplateRewriting' to false (like ko.nativeTemplateEngine does)\n//     and then you don't need to override 'createJavaScriptEvaluatorBlock'.\n\n            ko.templateEngine = function () { };\n\n            ko.templateEngine.prototype['renderTemplateSource'] = function (templateSource, bindingContext, options, templateDocument) {\n                throw new Error(\"Override renderTemplateSource\");\n            };\n\n            ko.templateEngine.prototype['createJavaScriptEvaluatorBlock'] = function (script) {\n                throw new Error(\"Override createJavaScriptEvaluatorBlock\");\n            };\n\n            ko.templateEngine.prototype['makeTemplateSource'] = function(template, templateDocument) {\n                // Named template\n                if (typeof template == \"string\") {\n                    templateDocument = templateDocument || document;\n                    var elem = templateDocument.getElementById(template);\n                    if (!elem)\n                        throw new Error(\"Cannot find template with ID \" + template);\n                    return new ko.templateSources.domElement(elem);\n                } else if ((template.nodeType == 1) || (template.nodeType == 8)) {\n                    // Anonymous template\n                    return new ko.templateSources.anonymousTemplate(template);\n                } else\n                    throw new Error(\"Unknown template type: \" + template);\n            };\n\n            ko.templateEngine.prototype['renderTemplate'] = function (template, bindingContext, options, templateDocument) {\n                var templateSource = this['makeTemplateSource'](template, templateDocument);\n                return this['renderTemplateSource'](templateSource, bindingContext, options, templateDocument);\n            };\n\n            ko.templateEngine.prototype['isTemplateRewritten'] = function (template, templateDocument) {\n                // Skip rewriting if requested\n                if (this['allowTemplateRewriting'] === false)\n                    return true;\n                return this['makeTemplateSource'](template, templateDocument)['data'](\"isRewritten\");\n            };\n\n            ko.templateEngine.prototype['rewriteTemplate'] = function (template, rewriterCallback, templateDocument) {\n                var templateSource = this['makeTemplateSource'](template, templateDocument);\n                var rewritten = rewriterCallback(templateSource['text']());\n                templateSource['text'](rewritten);\n                templateSource['data'](\"isRewritten\", true);\n            };\n\n            ko.exportSymbol('templateEngine', ko.templateEngine);\n\n            ko.templateRewriting = (function () {\n                var memoizeDataBindingAttributeSyntaxRegex = /(<([a-z]+\\d*)(?:\\s+(?!data-bind\\s*=\\s*)[a-z0-9\\-]+(?:=(?:\\\"[^\\\"]*\\\"|\\'[^\\']*\\'|[^>]*))?)*\\s+)data-bind\\s*=\\s*([\"'])([\\s\\S]*?)\\3/gi;\n                var memoizeVirtualContainerBindingSyntaxRegex = /<!--\\s*ko\\b\\s*([\\s\\S]*?)\\s*-->/g;\n\n                function validateDataBindValuesForRewriting(keyValueArray) {\n                    var allValidators = ko.expressionRewriting.bindingRewriteValidators;\n                    for (var i = 0; i < keyValueArray.length; i++) {\n                        var key = keyValueArray[i]['key'];\n                        if (Object.prototype.hasOwnProperty.call(allValidators, key)) {\n                            var validator = allValidators[key];\n\n                            if (typeof validator === \"function\") {\n                                var possibleErrorMessage = validator(keyValueArray[i]['value']);\n                                if (possibleErrorMessage)\n                                    throw new Error(possibleErrorMessage);\n                            } else if (!validator) {\n                                throw new Error(\"This template engine does not support the '\" + key + \"' binding within its templates\");\n                            }\n                        }\n                    }\n                }\n\n                function constructMemoizedTagReplacement(dataBindAttributeValue, tagToRetain, nodeName, templateEngine) {\n                    var dataBindKeyValueArray = ko.expressionRewriting.parseObjectLiteral(dataBindAttributeValue);\n                    validateDataBindValuesForRewriting(dataBindKeyValueArray);\n                    var rewrittenDataBindAttributeValue = ko.expressionRewriting.preProcessBindings(dataBindKeyValueArray, {'valueAccessors':true});\n\n                    // For no obvious reason, Opera fails to evaluate rewrittenDataBindAttributeValue unless it's wrapped in an additional\n                    // anonymous function, even though Opera's built-in debugger can evaluate it anyway. No other browser requires this\n                    // extra indirection.\n                    var applyBindingsToNextSiblingScript =\n                        \"ko.__tr_ambtns(function($context,$element){return(function(){return{ \" + rewrittenDataBindAttributeValue + \" } })()},'\" + nodeName.toLowerCase() + \"')\";\n                    return templateEngine['createJavaScriptEvaluatorBlock'](applyBindingsToNextSiblingScript) + tagToRetain;\n                }\n\n                return {\n                    ensureTemplateIsRewritten: function (template, templateEngine, templateDocument) {\n                        if (!templateEngine['isTemplateRewritten'](template, templateDocument))\n                            templateEngine['rewriteTemplate'](template, function (htmlString) {\n                                return ko.templateRewriting.memoizeBindingAttributeSyntax(htmlString, templateEngine);\n                            }, templateDocument);\n                    },\n\n                    memoizeBindingAttributeSyntax: function (htmlString, templateEngine) {\n                        return htmlString.replace(memoizeDataBindingAttributeSyntaxRegex, function () {\n                            return constructMemoizedTagReplacement(/* dataBindAttributeValue: */ arguments[4], /* tagToRetain: */ arguments[1], /* nodeName: */ arguments[2], templateEngine);\n                        }).replace(memoizeVirtualContainerBindingSyntaxRegex, function() {\n                            return constructMemoizedTagReplacement(/* dataBindAttributeValue: */ arguments[1], /* tagToRetain: */ \"<!-- ko -->\", /* nodeName: */ \"#comment\", templateEngine);\n                        });\n                    },\n\n                    applyMemoizedBindingsToNextSibling: function (bindings, nodeName) {\n                        return ko.memoization.memoize(function (domNode, bindingContext) {\n                            var nodeToBind = domNode.nextSibling;\n                            if (nodeToBind && nodeToBind.nodeName.toLowerCase() === nodeName) {\n                                ko.applyBindingAccessorsToNode(nodeToBind, bindings, bindingContext);\n                            }\n                        });\n                    }\n                }\n            })();\n\n\n// Exported only because it has to be referenced by string lookup from within rewritten template\n            ko.exportSymbol('__tr_ambtns', ko.templateRewriting.applyMemoizedBindingsToNextSibling);\n            (function() {\n                // A template source represents a read/write way of accessing a template. This is to eliminate the need for template loading/saving\n                // logic to be duplicated in every template engine (and means they can all work with anonymous templates, etc.)\n                //\n                // Two are provided by default:\n                //  1. ko.templateSources.domElement       - reads/writes the text content of an arbitrary DOM element\n                //  2. ko.templateSources.anonymousElement - uses ko.utils.domData to read/write text *associated* with the DOM element, but\n                //                                           without reading/writing the actual element text content, since it will be overwritten\n                //                                           with the rendered template output.\n                // You can implement your own template source if you want to fetch/store templates somewhere other than in DOM elements.\n                // Template sources need to have the following functions:\n                //   text() \t\t\t- returns the template text from your storage location\n                //   text(value)\t\t- writes the supplied template text to your storage location\n                //   data(key)\t\t\t- reads values stored using data(key, value) - see below\n                //   data(key, value)\t- associates \"value\" with this template and the key \"key\". Is used to store information like \"isRewritten\".\n                //\n                // Optionally, template sources can also have the following functions:\n                //   nodes()            - returns a DOM element containing the nodes of this template, where available\n                //   nodes(value)       - writes the given DOM element to your storage location\n                // If a DOM element is available for a given template source, template engines are encouraged to use it in preference over text()\n                // for improved speed. However, all templateSources must supply text() even if they don't supply nodes().\n                //\n                // Once you've implemented a templateSource, make your template engine use it by subclassing whatever template engine you were\n                // using and overriding \"makeTemplateSource\" to return an instance of your custom template source.\n\n                ko.templateSources = {};\n\n                // ---- ko.templateSources.domElement -----\n\n                // template types\n                var templateScript = 1,\n                    templateTextArea = 2,\n                    templateTemplate = 3,\n                    templateElement = 4;\n\n                ko.templateSources.domElement = function(element) {\n                    this.domElement = element;\n\n                    if (element) {\n                        var tagNameLower = ko.utils.tagNameLower(element);\n                        this.templateType =\n                            tagNameLower === \"script\" ? templateScript :\n                                tagNameLower === \"textarea\" ? templateTextArea :\n                                    // For browsers with proper <template> element support, where the .content property gives a document fragment\n                                    tagNameLower == \"template\" && element.content && element.content.nodeType === 11 ? templateTemplate :\n                                        templateElement;\n                    }\n                }\n\n                ko.templateSources.domElement.prototype['text'] = function(/* valueToWrite */) {\n                    var elemContentsProperty = this.templateType === templateScript ? \"text\"\n                        : this.templateType === templateTextArea ? \"value\"\n                            : \"innerHTML\";\n\n                    if (arguments.length == 0) {\n                        return this.domElement[elemContentsProperty];\n                    } else {\n                        var valueToWrite = arguments[0];\n                        if (elemContentsProperty === \"innerHTML\")\n                            ko.utils.setHtml(this.domElement, valueToWrite);\n                        else\n                            this.domElement[elemContentsProperty] = valueToWrite;\n                    }\n                };\n\n                var dataDomDataPrefix = ko.utils.domData.nextKey() + \"_\";\n                ko.templateSources.domElement.prototype['data'] = function(key /*, valueToWrite */) {\n                    if (arguments.length === 1) {\n                        return ko.utils.domData.get(this.domElement, dataDomDataPrefix + key);\n                    } else {\n                        ko.utils.domData.set(this.domElement, dataDomDataPrefix + key, arguments[1]);\n                    }\n                };\n\n                var templatesDomDataKey = ko.utils.domData.nextKey();\n                function getTemplateDomData(element) {\n                    return ko.utils.domData.get(element, templatesDomDataKey) || {};\n                }\n                function setTemplateDomData(element, data) {\n                    ko.utils.domData.set(element, templatesDomDataKey, data);\n                }\n\n                ko.templateSources.domElement.prototype['nodes'] = function(/* valueToWrite */) {\n                    var element = this.domElement;\n                    if (arguments.length == 0) {\n                        var templateData = getTemplateDomData(element),\n                            nodes = templateData.containerData || (\n                                this.templateType === templateTemplate ? element.content :\n                                    this.templateType === templateElement ? element :\n                                        undefined);\n                        if (!nodes || templateData.alwaysCheckText) {\n                            // If the template is associated with an element that stores the template as text,\n                            // parse and cache the nodes whenever there's new text content available. This allows\n                            // the user to update the template content by updating the text of template node.\n                            var text = this['text']();\n                            if (text && text !== templateData.textData) {\n                                nodes = ko.utils.parseHtmlForTemplateNodes(text, element.ownerDocument);\n                                setTemplateDomData(element, {containerData: nodes, textData: text, alwaysCheckText: true});\n                            }\n                        }\n                        return nodes;\n                    } else {\n                        var valueToWrite = arguments[0];\n                        if (this.templateType !== undefined) {\n                            this['text'](\"\");   // clear the text from the node\n                        }\n                        setTemplateDomData(element, {containerData: valueToWrite});\n                    }\n                };\n\n                // ---- ko.templateSources.anonymousTemplate -----\n                // Anonymous templates are normally saved/retrieved as DOM nodes through \"nodes\".\n                // For compatibility, you can also read \"text\"; it will be serialized from the nodes on demand.\n                // Writing to \"text\" is still supported, but then the template data will not be available as DOM nodes.\n\n                ko.templateSources.anonymousTemplate = function(element) {\n                    this.domElement = element;\n                }\n                ko.templateSources.anonymousTemplate.prototype = new ko.templateSources.domElement();\n                ko.templateSources.anonymousTemplate.prototype.constructor = ko.templateSources.anonymousTemplate;\n                ko.templateSources.anonymousTemplate.prototype['text'] = function(/* valueToWrite */) {\n                    if (arguments.length == 0) {\n                        var templateData = getTemplateDomData(this.domElement);\n                        if (templateData.textData === undefined && templateData.containerData)\n                            templateData.textData = templateData.containerData.innerHTML;\n                        return templateData.textData;\n                    } else {\n                        var valueToWrite = arguments[0];\n                        setTemplateDomData(this.domElement, {textData: valueToWrite});\n                    }\n                };\n\n                ko.exportSymbol('templateSources', ko.templateSources);\n                ko.exportSymbol('templateSources.domElement', ko.templateSources.domElement);\n                ko.exportSymbol('templateSources.anonymousTemplate', ko.templateSources.anonymousTemplate);\n            })();\n            (function () {\n                var _templateEngine;\n                ko.setTemplateEngine = function (templateEngine) {\n                    if ((templateEngine != undefined) && !(templateEngine instanceof ko.templateEngine))\n                        throw new Error(\"templateEngine must inherit from ko.templateEngine\");\n                    _templateEngine = templateEngine;\n                }\n\n                function invokeForEachNodeInContinuousRange(firstNode, lastNode, action) {\n                    var node, nextInQueue = firstNode, firstOutOfRangeNode = ko.virtualElements.nextSibling(lastNode);\n                    while (nextInQueue && ((node = nextInQueue) !== firstOutOfRangeNode)) {\n                        nextInQueue = ko.virtualElements.nextSibling(node);\n                        action(node, nextInQueue);\n                    }\n                }\n\n                function activateBindingsOnContinuousNodeArray(continuousNodeArray, bindingContext) {\n                    // To be used on any nodes that have been rendered by a template and have been inserted into some parent element\n                    // Walks through continuousNodeArray (which *must* be continuous, i.e., an uninterrupted sequence of sibling nodes, because\n                    // the algorithm for walking them relies on this), and for each top-level item in the virtual-element sense,\n                    // (1) Does a regular \"applyBindings\" to associate bindingContext with this node and to activate any non-memoized bindings\n                    // (2) Unmemoizes any memos in the DOM subtree (e.g., to activate bindings that had been memoized during template rewriting)\n\n                    if (continuousNodeArray.length) {\n                        var firstNode = continuousNodeArray[0],\n                            lastNode = continuousNodeArray[continuousNodeArray.length - 1],\n                            parentNode = firstNode.parentNode,\n                            provider = ko.bindingProvider['instance'],\n                            preprocessNode = provider['preprocessNode'];\n\n                        if (preprocessNode) {\n                            invokeForEachNodeInContinuousRange(firstNode, lastNode, function(node, nextNodeInRange) {\n                                var nodePreviousSibling = node.previousSibling;\n                                var newNodes = preprocessNode.call(provider, node);\n                                if (newNodes) {\n                                    if (node === firstNode)\n                                        firstNode = newNodes[0] || nextNodeInRange;\n                                    if (node === lastNode)\n                                        lastNode = newNodes[newNodes.length - 1] || nodePreviousSibling;\n                                }\n                            });\n\n                            // Because preprocessNode can change the nodes, including the first and last nodes, update continuousNodeArray to match.\n                            // We need the full set, including inner nodes, because the unmemoize step might remove the first node (and so the real\n                            // first node needs to be in the array).\n                            continuousNodeArray.length = 0;\n                            if (!firstNode) { // preprocessNode might have removed all the nodes, in which case there's nothing left to do\n                                return;\n                            }\n                            if (firstNode === lastNode) {\n                                continuousNodeArray.push(firstNode);\n                            } else {\n                                continuousNodeArray.push(firstNode, lastNode);\n                                ko.utils.fixUpContinuousNodeArray(continuousNodeArray, parentNode);\n                            }\n                        }\n\n                        // Need to applyBindings *before* unmemoziation, because unmemoization might introduce extra nodes (that we don't want to re-bind)\n                        // whereas a regular applyBindings won't introduce new memoized nodes\n                        invokeForEachNodeInContinuousRange(firstNode, lastNode, function(node) {\n                            if (node.nodeType === 1 || node.nodeType === 8)\n                                ko.applyBindings(bindingContext, node);\n                        });\n                        invokeForEachNodeInContinuousRange(firstNode, lastNode, function(node) {\n                            if (node.nodeType === 1 || node.nodeType === 8)\n                                ko.memoization.unmemoizeDomNodeAndDescendants(node, [bindingContext]);\n                        });\n\n                        // Make sure any changes done by applyBindings or unmemoize are reflected in the array\n                        ko.utils.fixUpContinuousNodeArray(continuousNodeArray, parentNode);\n                    }\n                }\n\n                function getFirstNodeFromPossibleArray(nodeOrNodeArray) {\n                    return nodeOrNodeArray.nodeType ? nodeOrNodeArray\n                        : nodeOrNodeArray.length > 0 ? nodeOrNodeArray[0]\n                            : null;\n                }\n\n                function executeTemplate(targetNodeOrNodeArray, renderMode, template, bindingContext, options) {\n                    options = options || {};\n                    var firstTargetNode = targetNodeOrNodeArray && getFirstNodeFromPossibleArray(targetNodeOrNodeArray);\n                    var templateDocument = (firstTargetNode || template || {}).ownerDocument;\n                    var templateEngineToUse = (options['templateEngine'] || _templateEngine);\n                    ko.templateRewriting.ensureTemplateIsRewritten(template, templateEngineToUse, templateDocument);\n                    var renderedNodesArray = templateEngineToUse['renderTemplate'](template, bindingContext, options, templateDocument);\n\n                    // Loosely check result is an array of DOM nodes\n                    if ((typeof renderedNodesArray.length != \"number\") || (renderedNodesArray.length > 0 && typeof renderedNodesArray[0].nodeType != \"number\"))\n                        throw new Error(\"Template engine must return an array of DOM nodes\");\n\n                    var haveAddedNodesToParent = false;\n                    switch (renderMode) {\n                        case \"replaceChildren\":\n                            ko.virtualElements.setDomNodeChildren(targetNodeOrNodeArray, renderedNodesArray);\n                            haveAddedNodesToParent = true;\n                            break;\n                        case \"replaceNode\":\n                            ko.utils.replaceDomNodes(targetNodeOrNodeArray, renderedNodesArray);\n                            haveAddedNodesToParent = true;\n                            break;\n                        case \"ignoreTargetNode\": break;\n                        default:\n                            throw new Error(\"Unknown renderMode: \" + renderMode);\n                    }\n\n                    if (haveAddedNodesToParent) {\n                        activateBindingsOnContinuousNodeArray(renderedNodesArray, bindingContext);\n                        if (options['afterRender']) {\n                            ko.dependencyDetection.ignore(options['afterRender'], null, [renderedNodesArray, bindingContext[options['as'] || '$data']]);\n                        }\n                        if (renderMode == \"replaceChildren\") {\n                            ko.bindingEvent.notify(targetNodeOrNodeArray, ko.bindingEvent.childrenComplete);\n                        }\n                    }\n\n                    return renderedNodesArray;\n                }\n\n                function resolveTemplateName(template, data, context) {\n                    // The template can be specified as:\n                    if (ko.isObservable(template)) {\n                        // 1. An observable, with string value\n                        return template();\n                    } else if (typeof template === 'function') {\n                        // 2. A function of (data, context) returning a string\n                        return template(data, context);\n                    } else {\n                        // 3. A string\n                        return template;\n                    }\n                }\n\n                ko.renderTemplate = function (template, dataOrBindingContext, options, targetNodeOrNodeArray, renderMode) {\n                    options = options || {};\n                    if ((options['templateEngine'] || _templateEngine) == undefined)\n                        throw new Error(\"Set a template engine before calling renderTemplate\");\n                    renderMode = renderMode || \"replaceChildren\";\n\n                    if (targetNodeOrNodeArray) {\n                        var firstTargetNode = getFirstNodeFromPossibleArray(targetNodeOrNodeArray);\n\n                        var whenToDispose = function () { return (!firstTargetNode) || !ko.utils.domNodeIsAttachedToDocument(firstTargetNode); }; // Passive disposal (on next evaluation)\n                        var activelyDisposeWhenNodeIsRemoved = (firstTargetNode && renderMode == \"replaceNode\") ? firstTargetNode.parentNode : firstTargetNode;\n\n                        return ko.dependentObservable( // So the DOM is automatically updated when any dependency changes\n                            function () {\n                                // Ensure we've got a proper binding context to work with\n                                var bindingContext = (dataOrBindingContext && (dataOrBindingContext instanceof ko.bindingContext))\n                                    ? dataOrBindingContext\n                                    : new ko.bindingContext(dataOrBindingContext, null, null, null, { \"exportDependencies\": true });\n\n                                var templateName = resolveTemplateName(template, bindingContext['$data'], bindingContext),\n                                    renderedNodesArray = executeTemplate(targetNodeOrNodeArray, renderMode, templateName, bindingContext, options);\n\n                                if (renderMode == \"replaceNode\") {\n                                    targetNodeOrNodeArray = renderedNodesArray;\n                                    firstTargetNode = getFirstNodeFromPossibleArray(targetNodeOrNodeArray);\n                                }\n                            },\n                            null,\n                            { disposeWhen: whenToDispose, disposeWhenNodeIsRemoved: activelyDisposeWhenNodeIsRemoved }\n                        );\n                    } else {\n                        // We don't yet have a DOM node to evaluate, so use a memo and render the template later when there is a DOM node\n                        return ko.memoization.memoize(function (domNode) {\n                            ko.renderTemplate(template, dataOrBindingContext, options, domNode, \"replaceNode\");\n                        });\n                    }\n                };\n\n                ko.renderTemplateForEach = function (template, arrayOrObservableArray, options, targetNode, parentBindingContext) {\n                    // Since setDomNodeChildrenFromArrayMapping always calls executeTemplateForArrayItem and then\n                    // activateBindingsCallback for added items, we can store the binding context in the former to use in the latter.\n                    var arrayItemContext, asName = options['as'];\n\n                    // This will be called by setDomNodeChildrenFromArrayMapping to get the nodes to add to targetNode\n                    var executeTemplateForArrayItem = function (arrayValue, index) {\n                        // Support selecting template as a function of the data being rendered\n                        arrayItemContext = parentBindingContext['createChildContext'](arrayValue, {\n                            'as': asName,\n                            'noChildContext': options['noChildContext'],\n                            'extend': function(context) {\n                                context['$index'] = index;\n                                if (asName) {\n                                    context[asName + \"Index\"] = index;\n                                }\n                            }\n                        });\n\n                        var templateName = resolveTemplateName(template, arrayValue, arrayItemContext);\n                        return executeTemplate(targetNode, \"ignoreTargetNode\", templateName, arrayItemContext, options);\n                    };\n\n                    // This will be called whenever setDomNodeChildrenFromArrayMapping has added nodes to targetNode\n                    var activateBindingsCallback = function(arrayValue, addedNodesArray, index) {\n                        activateBindingsOnContinuousNodeArray(addedNodesArray, arrayItemContext);\n                        if (options['afterRender'])\n                            options['afterRender'](addedNodesArray, arrayValue);\n\n                        // release the \"cache\" variable, so that it can be collected by\n                        // the GC when its value isn't used from within the bindings anymore.\n                        arrayItemContext = null;\n                    };\n\n                    var setDomNodeChildrenFromArrayMapping = function (newArray, changeList) {\n                        // Call setDomNodeChildrenFromArrayMapping, ignoring any observables unwrapped within (most likely from a callback function).\n                        // If the array items are observables, though, they will be unwrapped in executeTemplateForArrayItem and managed within setDomNodeChildrenFromArrayMapping.\n                        ko.dependencyDetection.ignore(ko.utils.setDomNodeChildrenFromArrayMapping, null, [targetNode, newArray, executeTemplateForArrayItem, options, activateBindingsCallback, changeList]);\n                        ko.bindingEvent.notify(targetNode, ko.bindingEvent.childrenComplete);\n                    };\n\n                    var shouldHideDestroyed = (options['includeDestroyed'] === false) || (ko.options['foreachHidesDestroyed'] && !options['includeDestroyed']);\n\n                    if (!shouldHideDestroyed && !options['beforeRemove'] && ko.isObservableArray(arrayOrObservableArray)) {\n                        setDomNodeChildrenFromArrayMapping(arrayOrObservableArray.peek());\n\n                        var subscription = arrayOrObservableArray.subscribe(function (changeList) {\n                            setDomNodeChildrenFromArrayMapping(arrayOrObservableArray(), changeList);\n                        }, null, \"arrayChange\");\n                        subscription.disposeWhenNodeIsRemoved(targetNode);\n\n                        return subscription;\n                    } else {\n                        return ko.dependentObservable(function () {\n                            var unwrappedArray = ko.utils.unwrapObservable(arrayOrObservableArray) || [];\n                            if (typeof unwrappedArray.length == \"undefined\") // Coerce single value into array\n                                unwrappedArray = [unwrappedArray];\n\n                            if (shouldHideDestroyed) {\n                                // Filter out any entries marked as destroyed\n                                unwrappedArray = ko.utils.arrayFilter(unwrappedArray, function(item) {\n                                    return item === undefined || item === null || !ko.utils.unwrapObservable(item['_destroy']);\n                                });\n                            }\n                            setDomNodeChildrenFromArrayMapping(unwrappedArray);\n\n                        }, null, { disposeWhenNodeIsRemoved: targetNode });\n                    }\n                };\n\n                var templateComputedDomDataKey = ko.utils.domData.nextKey();\n                function disposeOldComputedAndStoreNewOne(element, newComputed) {\n                    var oldComputed = ko.utils.domData.get(element, templateComputedDomDataKey);\n                    if (oldComputed && (typeof(oldComputed.dispose) == 'function'))\n                        oldComputed.dispose();\n                    ko.utils.domData.set(element, templateComputedDomDataKey, (newComputed && (!newComputed.isActive || newComputed.isActive())) ? newComputed : undefined);\n                }\n\n                var cleanContainerDomDataKey = ko.utils.domData.nextKey();\n                ko.bindingHandlers['template'] = {\n                    'init': function(element, valueAccessor) {\n                        // Support anonymous templates\n                        var bindingValue = ko.utils.unwrapObservable(valueAccessor());\n                        if (typeof bindingValue == \"string\" || 'name' in bindingValue) {\n                            // It's a named template - clear the element\n                            ko.virtualElements.emptyNode(element);\n                        } else if ('nodes' in bindingValue) {\n                            // We've been given an array of DOM nodes. Save them as the template source.\n                            // There is no known use case for the node array being an observable array (if the output\n                            // varies, put that behavior *into* your template - that's what templates are for), and\n                            // the implementation would be a mess, so assert that it's not observable.\n                            var nodes = bindingValue['nodes'] || [];\n                            if (ko.isObservable(nodes)) {\n                                throw new Error('The \"nodes\" option must be a plain, non-observable array.');\n                            }\n\n                            // If the nodes are already attached to a KO-generated container, we reuse that container without moving the\n                            // elements to a new one (we check only the first node, as the nodes are always moved together)\n                            var container = nodes[0] && nodes[0].parentNode;\n                            if (!container || !ko.utils.domData.get(container, cleanContainerDomDataKey)) {\n                                container = ko.utils.moveCleanedNodesToContainerElement(nodes);\n                                ko.utils.domData.set(container, cleanContainerDomDataKey, true);\n                            }\n\n                            new ko.templateSources.anonymousTemplate(element)['nodes'](container);\n                        } else {\n                            // It's an anonymous template - store the element contents, then clear the element\n                            var templateNodes = ko.virtualElements.childNodes(element);\n                            if (templateNodes.length > 0) {\n                                var container = ko.utils.moveCleanedNodesToContainerElement(templateNodes); // This also removes the nodes from their current parent\n                                new ko.templateSources.anonymousTemplate(element)['nodes'](container);\n                            } else {\n                                throw new Error(\"Anonymous template defined, but no template content was provided\");\n                            }\n                        }\n                        return { 'controlsDescendantBindings': true };\n                    },\n                    'update': function (element, valueAccessor, allBindings, viewModel, bindingContext) {\n                        var value = valueAccessor(),\n                            options = ko.utils.unwrapObservable(value),\n                            shouldDisplay = true,\n                            templateComputed = null,\n                            template;\n\n                        if (typeof options == \"string\") {\n                            template = value;\n                            options = {};\n                        } else {\n                            template = 'name' in options ? options['name'] : element;\n\n                            // Support \"if\"/\"ifnot\" conditions\n                            if ('if' in options)\n                                shouldDisplay = ko.utils.unwrapObservable(options['if']);\n                            if (shouldDisplay && 'ifnot' in options)\n                                shouldDisplay = !ko.utils.unwrapObservable(options['ifnot']);\n\n                            // Don't show anything if an empty name is given (see #2446)\n                            if (shouldDisplay && !template) {\n                                shouldDisplay = false;\n                            }\n                        }\n\n                        if ('foreach' in options) {\n                            // Render once for each data point (treating data set as empty if shouldDisplay==false)\n                            var dataArray = (shouldDisplay && options['foreach']) || [];\n                            templateComputed = ko.renderTemplateForEach(template, dataArray, options, element, bindingContext);\n                        } else if (!shouldDisplay) {\n                            ko.virtualElements.emptyNode(element);\n                        } else {\n                            // Render once for this single data point (or use the viewModel if no data was provided)\n                            var innerBindingContext = bindingContext;\n                            if ('data' in options) {\n                                innerBindingContext = bindingContext['createChildContext'](options['data'], {\n                                    'as': options['as'],\n                                    'noChildContext': options['noChildContext'],\n                                    'exportDependencies': true\n                                });\n                            }\n                            templateComputed = ko.renderTemplate(template, innerBindingContext, options, element);\n                        }\n\n                        // It only makes sense to have a single template computed per element (otherwise which one should have its output displayed?)\n                        disposeOldComputedAndStoreNewOne(element, templateComputed);\n                    }\n                };\n\n                // Anonymous templates can't be rewritten. Give a nice error message if you try to do it.\n                ko.expressionRewriting.bindingRewriteValidators['template'] = function(bindingValue) {\n                    var parsedBindingValue = ko.expressionRewriting.parseObjectLiteral(bindingValue);\n\n                    if ((parsedBindingValue.length == 1) && parsedBindingValue[0]['unknown'])\n                        return null; // It looks like a string literal, not an object literal, so treat it as a named template (which is allowed for rewriting)\n\n                    if (ko.expressionRewriting.keyValueArrayContainsKey(parsedBindingValue, \"name\"))\n                        return null; // Named templates can be rewritten, so return \"no error\"\n                    return \"This template engine does not support anonymous templates nested within its templates\";\n                };\n\n                ko.virtualElements.allowedBindings['template'] = true;\n            })();\n\n            ko.exportSymbol('setTemplateEngine', ko.setTemplateEngine);\n            ko.exportSymbol('renderTemplate', ko.renderTemplate);\n// Go through the items that have been added and deleted and try to find matches between them.\n            ko.utils.findMovesInArrayComparison = function (left, right, limitFailedCompares) {\n                if (left.length && right.length) {\n                    var failedCompares, l, r, leftItem, rightItem;\n                    for (failedCompares = l = 0; (!limitFailedCompares || failedCompares < limitFailedCompares) && (leftItem = left[l]); ++l) {\n                        for (r = 0; rightItem = right[r]; ++r) {\n                            if (leftItem['value'] === rightItem['value']) {\n                                leftItem['moved'] = rightItem['index'];\n                                rightItem['moved'] = leftItem['index'];\n                                right.splice(r, 1);         // This item is marked as moved; so remove it from right list\n                                failedCompares = r = 0;     // Reset failed compares count because we're checking for consecutive failures\n                                break;\n                            }\n                        }\n                        failedCompares += r;\n                    }\n                }\n            };\n\n            ko.utils.compareArrays = (function () {\n                var statusNotInOld = 'added', statusNotInNew = 'deleted';\n\n                // Simple calculation based on Levenshtein distance.\n                function compareArrays(oldArray, newArray, options) {\n                    // For backward compatibility, if the third arg is actually a bool, interpret\n                    // it as the old parameter 'dontLimitMoves'. Newer code should use { dontLimitMoves: true }.\n                    options = (typeof options === 'boolean') ? { 'dontLimitMoves': options } : (options || {});\n                    oldArray = oldArray || [];\n                    newArray = newArray || [];\n\n                    if (oldArray.length < newArray.length)\n                        return compareSmallArrayToBigArray(oldArray, newArray, statusNotInOld, statusNotInNew, options);\n                    else\n                        return compareSmallArrayToBigArray(newArray, oldArray, statusNotInNew, statusNotInOld, options);\n                }\n\n                function compareSmallArrayToBigArray(smlArray, bigArray, statusNotInSml, statusNotInBig, options) {\n                    var myMin = Math.min,\n                        myMax = Math.max,\n                        editDistanceMatrix = [],\n                        smlIndex, smlIndexMax = smlArray.length,\n                        bigIndex, bigIndexMax = bigArray.length,\n                        compareRange = (bigIndexMax - smlIndexMax) || 1,\n                        maxDistance = smlIndexMax + bigIndexMax + 1,\n                        thisRow, lastRow,\n                        bigIndexMaxForRow, bigIndexMinForRow;\n\n                    for (smlIndex = 0; smlIndex <= smlIndexMax; smlIndex++) {\n                        lastRow = thisRow;\n                        editDistanceMatrix.push(thisRow = []);\n                        bigIndexMaxForRow = myMin(bigIndexMax, smlIndex + compareRange);\n                        bigIndexMinForRow = myMax(0, smlIndex - 1);\n                        for (bigIndex = bigIndexMinForRow; bigIndex <= bigIndexMaxForRow; bigIndex++) {\n                            if (!bigIndex)\n                                thisRow[bigIndex] = smlIndex + 1;\n                            else if (!smlIndex)  // Top row - transform empty array into new array via additions\n                                thisRow[bigIndex] = bigIndex + 1;\n                            else if (smlArray[smlIndex - 1] === bigArray[bigIndex - 1])\n                                thisRow[bigIndex] = lastRow[bigIndex - 1];                  // copy value (no edit)\n                            else {\n                                var northDistance = lastRow[bigIndex] || maxDistance;       // not in big (deletion)\n                                var westDistance = thisRow[bigIndex - 1] || maxDistance;    // not in small (addition)\n                                thisRow[bigIndex] = myMin(northDistance, westDistance) + 1;\n                            }\n                        }\n                    }\n\n                    var editScript = [], meMinusOne, notInSml = [], notInBig = [];\n                    for (smlIndex = smlIndexMax, bigIndex = bigIndexMax; smlIndex || bigIndex;) {\n                        meMinusOne = editDistanceMatrix[smlIndex][bigIndex] - 1;\n                        if (bigIndex && meMinusOne === editDistanceMatrix[smlIndex][bigIndex-1]) {\n                            notInSml.push(editScript[editScript.length] = {     // added\n                                'status': statusNotInSml,\n                                'value': bigArray[--bigIndex],\n                                'index': bigIndex });\n                        } else if (smlIndex && meMinusOne === editDistanceMatrix[smlIndex - 1][bigIndex]) {\n                            notInBig.push(editScript[editScript.length] = {     // deleted\n                                'status': statusNotInBig,\n                                'value': smlArray[--smlIndex],\n                                'index': smlIndex });\n                        } else {\n                            --bigIndex;\n                            --smlIndex;\n                            if (!options['sparse']) {\n                                editScript.push({\n                                    'status': \"retained\",\n                                    'value': bigArray[bigIndex] });\n                            }\n                        }\n                    }\n\n                    // Set a limit on the number of consecutive non-matching comparisons; having it a multiple of\n                    // smlIndexMax keeps the time complexity of this algorithm linear.\n                    ko.utils.findMovesInArrayComparison(notInBig, notInSml, !options['dontLimitMoves'] && smlIndexMax * 10);\n\n                    return editScript.reverse();\n                }\n\n                return compareArrays;\n            })();\n\n            ko.exportSymbol('utils.compareArrays', ko.utils.compareArrays);\n            (function () {\n                // Objective:\n                // * Given an input array, a container DOM node, and a function from array elements to arrays of DOM nodes,\n                //   map the array elements to arrays of DOM nodes, concatenate together all these arrays, and use them to populate the container DOM node\n                // * Next time we're given the same combination of things (with the array possibly having mutated), update the container DOM node\n                //   so that its children is again the concatenation of the mappings of the array elements, but don't re-map any array elements that we\n                //   previously mapped - retain those nodes, and just insert/delete other ones\n\n                // \"callbackAfterAddingNodes\" will be invoked after any \"mapping\"-generated nodes are inserted into the container node\n                // You can use this, for example, to activate bindings on those nodes.\n\n                function mapNodeAndRefreshWhenChanged(containerNode, mapping, valueToMap, callbackAfterAddingNodes, index) {\n                    // Map this array value inside a dependentObservable so we re-map when any dependency changes\n                    var mappedNodes = [];\n                    var dependentObservable = ko.dependentObservable(function() {\n                        var newMappedNodes = mapping(valueToMap, index, ko.utils.fixUpContinuousNodeArray(mappedNodes, containerNode)) || [];\n\n                        // On subsequent evaluations, just replace the previously-inserted DOM nodes\n                        if (mappedNodes.length > 0) {\n                            ko.utils.replaceDomNodes(mappedNodes, newMappedNodes);\n                            if (callbackAfterAddingNodes)\n                                ko.dependencyDetection.ignore(callbackAfterAddingNodes, null, [valueToMap, newMappedNodes, index]);\n                        }\n\n                        // Replace the contents of the mappedNodes array, thereby updating the record\n                        // of which nodes would be deleted if valueToMap was itself later removed\n                        mappedNodes.length = 0;\n                        ko.utils.arrayPushAll(mappedNodes, newMappedNodes);\n                    }, null, { disposeWhenNodeIsRemoved: containerNode, disposeWhen: function() { return !ko.utils.anyDomNodeIsAttachedToDocument(mappedNodes); } });\n                    return { mappedNodes : mappedNodes, dependentObservable : (dependentObservable.isActive() ? dependentObservable : undefined) };\n                }\n\n                var lastMappingResultDomDataKey = ko.utils.domData.nextKey(),\n                    deletedItemDummyValue = ko.utils.domData.nextKey();\n\n                ko.utils.setDomNodeChildrenFromArrayMapping = function (domNode, array, mapping, options, callbackAfterAddingNodes, editScript) {\n                    array = array || [];\n                    if (typeof array.length == \"undefined\") // Coerce single value into array\n                        array = [array];\n\n                    options = options || {};\n                    var lastMappingResult = ko.utils.domData.get(domNode, lastMappingResultDomDataKey);\n                    var isFirstExecution = !lastMappingResult;\n\n                    // Build the new mapping result\n                    var newMappingResult = [];\n                    var lastMappingResultIndex = 0;\n                    var currentArrayIndex = 0;\n\n                    var nodesToDelete = [];\n                    var itemsToMoveFirstIndexes = [];\n                    var itemsForBeforeRemoveCallbacks = [];\n                    var itemsForMoveCallbacks = [];\n                    var itemsForAfterAddCallbacks = [];\n                    var mapData;\n                    var countWaitingForRemove = 0;\n\n                    function itemAdded(value) {\n                        mapData = { arrayEntry: value, indexObservable: ko.observable(currentArrayIndex++) };\n                        newMappingResult.push(mapData);\n                        if (!isFirstExecution) {\n                            itemsForAfterAddCallbacks.push(mapData);\n                        }\n                    }\n\n                    function itemMovedOrRetained(oldPosition) {\n                        mapData = lastMappingResult[oldPosition];\n                        if (currentArrayIndex !== mapData.indexObservable.peek())\n                            itemsForMoveCallbacks.push(mapData);\n                        // Since updating the index might change the nodes, do so before calling fixUpContinuousNodeArray\n                        mapData.indexObservable(currentArrayIndex++);\n                        ko.utils.fixUpContinuousNodeArray(mapData.mappedNodes, domNode);\n                        newMappingResult.push(mapData);\n                    }\n\n                    function callCallback(callback, items) {\n                        if (callback) {\n                            for (var i = 0, n = items.length; i < n; i++) {\n                                ko.utils.arrayForEach(items[i].mappedNodes, function(node) {\n                                    callback(node, i, items[i].arrayEntry);\n                                });\n                            }\n                        }\n                    }\n\n                    if (isFirstExecution) {\n                        ko.utils.arrayForEach(array, itemAdded);\n                    } else {\n                        if (!editScript || (lastMappingResult && lastMappingResult['_countWaitingForRemove'])) {\n                            // Compare the provided array against the previous one\n                            var lastArray = ko.utils.arrayMap(lastMappingResult, function (x) { return x.arrayEntry; }),\n                                compareOptions = {\n                                    'dontLimitMoves': options['dontLimitMoves'],\n                                    'sparse': true\n                                };\n                            editScript = ko.utils.compareArrays(lastArray, array, compareOptions);\n                        }\n\n                        for (var i = 0, editScriptItem, movedIndex, itemIndex; editScriptItem = editScript[i]; i++) {\n                            movedIndex = editScriptItem['moved'];\n                            itemIndex = editScriptItem['index'];\n                            switch (editScriptItem['status']) {\n                                case \"deleted\":\n                                    while (lastMappingResultIndex < itemIndex) {\n                                        itemMovedOrRetained(lastMappingResultIndex++);\n                                    }\n                                    if (movedIndex === undefined) {\n                                        mapData = lastMappingResult[lastMappingResultIndex];\n\n                                        // Stop tracking changes to the mapping for these nodes\n                                        if (mapData.dependentObservable) {\n                                            mapData.dependentObservable.dispose();\n                                            mapData.dependentObservable = undefined;\n                                        }\n\n                                        // Queue these nodes for later removal\n                                        if (ko.utils.fixUpContinuousNodeArray(mapData.mappedNodes, domNode).length) {\n                                            if (options['beforeRemove']) {\n                                                newMappingResult.push(mapData);\n                                                countWaitingForRemove++;\n                                                if (mapData.arrayEntry === deletedItemDummyValue) {\n                                                    mapData = null;\n                                                } else {\n                                                    itemsForBeforeRemoveCallbacks.push(mapData);\n                                                }\n                                            }\n                                            if (mapData) {\n                                                nodesToDelete.push.apply(nodesToDelete, mapData.mappedNodes);\n                                            }\n                                        }\n                                    }\n                                    lastMappingResultIndex++;\n                                    break;\n\n                                case \"added\":\n                                    while (currentArrayIndex < itemIndex) {\n                                        itemMovedOrRetained(lastMappingResultIndex++);\n                                    }\n                                    if (movedIndex !== undefined) {\n                                        itemsToMoveFirstIndexes.push(newMappingResult.length);\n                                        itemMovedOrRetained(movedIndex);\n                                    } else {\n                                        itemAdded(editScriptItem['value']);\n                                    }\n                                    break;\n                            }\n                        }\n\n                        while (currentArrayIndex < array.length) {\n                            itemMovedOrRetained(lastMappingResultIndex++);\n                        }\n\n                        // Record that the current view may still contain deleted items\n                        // because it means we won't be able to use a provided editScript.\n                        newMappingResult['_countWaitingForRemove'] = countWaitingForRemove;\n                    }\n\n                    // Store a copy of the array items we just considered so we can difference it next time\n                    ko.utils.domData.set(domNode, lastMappingResultDomDataKey, newMappingResult);\n\n                    // Call beforeMove first before any changes have been made to the DOM\n                    callCallback(options['beforeMove'], itemsForMoveCallbacks);\n\n                    // Next remove nodes for deleted items (or just clean if there's a beforeRemove callback)\n                    ko.utils.arrayForEach(nodesToDelete, options['beforeRemove'] ? ko.cleanNode : ko.removeNode);\n\n                    var i, j, lastNode, nodeToInsert, mappedNodes, activeElement;\n\n                    // Since most browsers remove the focus from an element when it's moved to another location,\n                    // save the focused element and try to restore it later.\n                    try {\n                        activeElement = domNode.ownerDocument.activeElement;\n                    } catch(e) {\n                        // IE9 throws if you access activeElement during page load (see issue #703)\n                    }\n\n                    // Try to reduce overall moved nodes by first moving the ones that were marked as moved by the edit script\n                    if (itemsToMoveFirstIndexes.length) {\n                        while ((i = itemsToMoveFirstIndexes.shift()) != undefined) {\n                            mapData = newMappingResult[i];\n                            for (lastNode = undefined; i; ) {\n                                if ((mappedNodes = newMappingResult[--i].mappedNodes) && mappedNodes.length) {\n                                    lastNode = mappedNodes[mappedNodes.length-1];\n                                    break;\n                                }\n                            }\n                            for (j = 0; nodeToInsert = mapData.mappedNodes[j]; lastNode = nodeToInsert, j++) {\n                                ko.virtualElements.insertAfter(domNode, nodeToInsert, lastNode);\n                            }\n                        }\n                    }\n\n                    // Next add/reorder the remaining items (will include deleted items if there's a beforeRemove callback)\n                    for (i = 0; mapData = newMappingResult[i]; i++) {\n                        // Get nodes for newly added items\n                        if (!mapData.mappedNodes)\n                            ko.utils.extend(mapData, mapNodeAndRefreshWhenChanged(domNode, mapping, mapData.arrayEntry, callbackAfterAddingNodes, mapData.indexObservable));\n\n                        // Put nodes in the right place if they aren't there already\n                        for (j = 0; nodeToInsert = mapData.mappedNodes[j]; lastNode = nodeToInsert, j++) {\n                            ko.virtualElements.insertAfter(domNode, nodeToInsert, lastNode);\n                        }\n\n                        // Run the callbacks for newly added nodes (for example, to apply bindings, etc.)\n                        if (!mapData.initialized && callbackAfterAddingNodes) {\n                            callbackAfterAddingNodes(mapData.arrayEntry, mapData.mappedNodes, mapData.indexObservable);\n                            mapData.initialized = true;\n                            lastNode = mapData.mappedNodes[mapData.mappedNodes.length - 1];     // get the last node again since it may have been changed by a preprocessor\n                        }\n                    }\n\n                    // Restore the focused element if it had lost focus\n                    if (activeElement && domNode.ownerDocument.activeElement != activeElement) {\n                        activeElement.focus();\n                    }\n\n                    // If there's a beforeRemove callback, call it after reordering.\n                    // Note that we assume that the beforeRemove callback will usually be used to remove the nodes using\n                    // some sort of animation, which is why we first reorder the nodes that will be removed. If the\n                    // callback instead removes the nodes right away, it would be more efficient to skip reordering them.\n                    // Perhaps we'll make that change in the future if this scenario becomes more common.\n                    callCallback(options['beforeRemove'], itemsForBeforeRemoveCallbacks);\n\n                    // Replace the stored values of deleted items with a dummy value. This provides two benefits: it marks this item\n                    // as already \"removed\" so we won't call beforeRemove for it again, and it ensures that the item won't match up\n                    // with an actual item in the array and appear as \"retained\" or \"moved\".\n                    for (i = 0; i < itemsForBeforeRemoveCallbacks.length; ++i) {\n                        itemsForBeforeRemoveCallbacks[i].arrayEntry = deletedItemDummyValue;\n                    }\n\n                    // Finally call afterMove and afterAdd callbacks\n                    callCallback(options['afterMove'], itemsForMoveCallbacks);\n                    callCallback(options['afterAdd'], itemsForAfterAddCallbacks);\n                }\n            })();\n\n            ko.exportSymbol('utils.setDomNodeChildrenFromArrayMapping', ko.utils.setDomNodeChildrenFromArrayMapping);\n            ko.nativeTemplateEngine = function () {\n                this['allowTemplateRewriting'] = false;\n            }\n\n            ko.nativeTemplateEngine.prototype = new ko.templateEngine();\n            ko.nativeTemplateEngine.prototype.constructor = ko.nativeTemplateEngine;\n            ko.nativeTemplateEngine.prototype['renderTemplateSource'] = function (templateSource, bindingContext, options, templateDocument) {\n                var useNodesIfAvailable = !(ko.utils.ieVersion < 9), // IE<9 cloneNode doesn't work properly\n                    templateNodesFunc = useNodesIfAvailable ? templateSource['nodes'] : null,\n                    templateNodes = templateNodesFunc ? templateSource['nodes']() : null;\n\n                if (templateNodes) {\n                    return ko.utils.makeArray(templateNodes.cloneNode(true).childNodes);\n                } else {\n                    var templateText = templateSource['text']();\n                    return ko.utils.parseHtmlFragment(templateText, templateDocument);\n                }\n            };\n\n            ko.nativeTemplateEngine.instance = new ko.nativeTemplateEngine();\n            ko.setTemplateEngine(ko.nativeTemplateEngine.instance);\n\n            ko.exportSymbol('nativeTemplateEngine', ko.nativeTemplateEngine);\n            (function() {\n                ko.jqueryTmplTemplateEngine = function () {\n                    // Detect which version of jquery-tmpl you're using. Unfortunately jquery-tmpl\n                    // doesn't expose a version number, so we have to infer it.\n                    // Note that as of Knockout 1.3, we only support jQuery.tmpl 1.0.0pre and later,\n                    // which KO internally refers to as version \"2\", so older versions are no longer detected.\n                    var jQueryTmplVersion = this.jQueryTmplVersion = (function() {\n                        if (!jQueryInstance || !(jQueryInstance['tmpl']))\n                            return 0;\n                        // Since it exposes no official version number, we use our own numbering system. To be updated as jquery-tmpl evolves.\n                        try {\n                            if (jQueryInstance['tmpl']['tag']['tmpl']['open'].toString().indexOf('__') >= 0) {\n                                // Since 1.0.0pre, custom tags should append markup to an array called \"__\"\n                                return 2; // Final version of jquery.tmpl\n                            }\n                        } catch(ex) { /* Apparently not the version we were looking for */ }\n\n                        return 1; // Any older version that we don't support\n                    })();\n\n                    function ensureHasReferencedJQueryTemplates() {\n                        if (jQueryTmplVersion < 2)\n                            throw new Error(\"Your version of jQuery.tmpl is too old. Please upgrade to jQuery.tmpl 1.0.0pre or later.\");\n                    }\n\n                    function executeTemplate(compiledTemplate, data, jQueryTemplateOptions) {\n                        return jQueryInstance['tmpl'](compiledTemplate, data, jQueryTemplateOptions);\n                    }\n\n                    this['renderTemplateSource'] = function(templateSource, bindingContext, options, templateDocument) {\n                        templateDocument = templateDocument || document;\n                        options = options || {};\n                        ensureHasReferencedJQueryTemplates();\n\n                        // Ensure we have stored a precompiled version of this template (don't want to reparse on every render)\n                        var precompiled = templateSource['data']('precompiled');\n                        if (!precompiled) {\n                            var templateText = templateSource['text']() || \"\";\n                            // Wrap in \"with($whatever.koBindingContext) { ... }\"\n                            templateText = \"{{ko_with $item.koBindingContext}}\" + templateText + \"{{/ko_with}}\";\n\n                            precompiled = jQueryInstance['template'](null, templateText);\n                            templateSource['data']('precompiled', precompiled);\n                        }\n\n                        var data = [bindingContext['$data']]; // Prewrap the data in an array to stop jquery.tmpl from trying to unwrap any arrays\n                        var jQueryTemplateOptions = jQueryInstance['extend']({ 'koBindingContext': bindingContext }, options['templateOptions']);\n\n                        var resultNodes = executeTemplate(precompiled, data, jQueryTemplateOptions);\n                        resultNodes['appendTo'](templateDocument.createElement(\"div\")); // Using \"appendTo\" forces jQuery/jQuery.tmpl to perform necessary cleanup work\n\n                        jQueryInstance['fragments'] = {}; // Clear jQuery's fragment cache to avoid a memory leak after a large number of template renders\n                        return resultNodes;\n                    };\n\n                    this['createJavaScriptEvaluatorBlock'] = function(script) {\n                        return \"{{ko_code ((function() { return \" + script + \" })()) }}\";\n                    };\n\n                    this['addTemplate'] = function(templateName, templateMarkup) {\n                        document.write(\"<script type='text/html' id='\" + templateName + \"'>\" + templateMarkup + \"<\" + \"/script>\");\n                    };\n\n                    if (jQueryTmplVersion > 0) {\n                        jQueryInstance['tmpl']['tag']['ko_code'] = {\n                            open: \"__.push($1 || '');\"\n                        };\n                        jQueryInstance['tmpl']['tag']['ko_with'] = {\n                            open: \"with($1) {\",\n                            close: \"} \"\n                        };\n                    }\n                };\n\n                ko.jqueryTmplTemplateEngine.prototype = new ko.templateEngine();\n                ko.jqueryTmplTemplateEngine.prototype.constructor = ko.jqueryTmplTemplateEngine;\n\n                // Use this one by default *only if jquery.tmpl is referenced*\n                var jqueryTmplTemplateEngineInstance = new ko.jqueryTmplTemplateEngine();\n                if (jqueryTmplTemplateEngineInstance.jQueryTmplVersion > 0)\n                    ko.setTemplateEngine(jqueryTmplTemplateEngineInstance);\n\n                ko.exportSymbol('jqueryTmplTemplateEngine', ko.jqueryTmplTemplateEngine);\n            })();\n        }));\n    }());\n})();\n","knockoutjs/knockout-fast-foreach.js":"/*!\n  Knockout Fast Foreach v0.4.1 (2015-07-17T14:06:15.974Z)\n  By: Brian M Hunt (C) 2015\n  License: MIT\n\n  Adds `fastForEach` to `ko.bindingHandlers`.\n*/\n(function (root, factory) {\n  if (typeof define === 'function' && define.amd) {\n    define(['knockout'], factory);\n  } else if (typeof exports === 'object') {\n    module.exports = factory(require('knockout'));\n  } else {\n    root.KnockoutFastForeach = factory(root.ko);\n  }\n}(this, function (ko) {\n  \"use strict\";\n// index.js\n// --------\n// Fast For Each\n//\n// Employing sound techniques to make a faster Knockout foreach binding.\n// --------\n\n//      Utilities\n\n// from https://github.com/jonschlinkert/is-plain-object\nfunction isPlainObject(o) {\n  return !!o && typeof o === 'object' && o.constructor === Object;\n}\n\n// From knockout/src/virtualElements.js\nvar commentNodesHaveTextProperty = document && document.createComment(\"test\").text === \"<!--test-->\";\nvar startCommentRegex = commentNodesHaveTextProperty ? /^<!--\\s*ko(?:\\s+([\\s\\S]+))?\\s*-->$/ : /^\\s*ko(?:\\s+([\\s\\S]+))?\\s*$/;\nvar supportsDocumentFragment = document && typeof document.createDocumentFragment === \"function\";\nfunction isVirtualNode(node) {\n  return (node.nodeType === 8) && startCommentRegex.test(commentNodesHaveTextProperty ? node.text : node.nodeValue);\n}\n\n\n// Get a copy of the (possibly virtual) child nodes of the given element,\n// put them into a container, then empty the given node.\nfunction makeTemplateNode(sourceNode) {\n  var container = document.createElement(\"div\");\n  var parentNode;\n  if (sourceNode.content) {\n    // For e.g. <template> tags\n    parentNode = sourceNode.content;\n  } else if (sourceNode.tagName === 'SCRIPT') {\n    parentNode = document.createElement(\"div\");\n    parentNode.innerHTML = sourceNode.text;\n  } else {\n    // Anything else e.g. <div>\n    parentNode = sourceNode;\n  }\n  ko.utils.arrayForEach(ko.virtualElements.childNodes(parentNode), function (child) {\n    // FIXME - This cloneNode could be expensive; we may prefer to iterate over the\n    // parentNode children in reverse (so as not to foul the indexes as childNodes are\n    // removed from parentNode when inserted into the container)\n    if (child) {\n      container.insertBefore(child.cloneNode(true), null);\n    }\n  });\n  return container;\n}\n\nfunction insertAllAfter(containerNode, nodeOrNodeArrayToInsert, insertAfterNode) {\n  var frag, len, i;\n  // poor man's node and array check, should be enough for this\n  if (typeof nodeOrNodeArrayToInsert.nodeType !== \"undefined\" && typeof nodeOrNodeArrayToInsert.length === \"undefined\") {\n    throw new Error(\"Expected a single node or a node array\");\n  }\n\n  if (typeof nodeOrNodeArrayToInsert.nodeType !== \"undefined\") {\n    ko.virtualElements.insertAfter(containerNode, nodeOrNodeArrayToInsert, insertAfterNode);\n    return;\n  }\n\n  if (nodeOrNodeArrayToInsert.length === 1) {\n    ko.virtualElements.insertAfter(containerNode, nodeOrNodeArrayToInsert[0], insertAfterNode);\n    return;\n  }\n\n  if (supportsDocumentFragment) {\n    frag = document.createDocumentFragment();\n\n    for (i = 0, len = nodeOrNodeArrayToInsert.length; i !== len; ++i) {\n      frag.appendChild(nodeOrNodeArrayToInsert[i]);\n    }\n    ko.virtualElements.insertAfter(containerNode, frag, insertAfterNode);\n  } else {\n    // Nodes are inserted in reverse order - pushed down immediately after\n    // the last node for the previous item or as the first node of element.\n    for (i = nodeOrNodeArrayToInsert.length - 1; i >= 0; --i) {\n      var child = nodeOrNodeArrayToInsert[i];\n      if (!child) {\n        return;\n      }\n      ko.virtualElements.insertAfter(containerNode, child, insertAfterNode);\n    }\n  }\n}\n\n// Mimic a KO change item 'add'\nfunction valueToChangeAddItem(value, index) {\n  return {\n    status: 'added',\n    value: value,\n    index: index\n  };\n}\n\nfunction isAdditionAdjacentToLast(changeIndex, arrayChanges) {\n  return changeIndex > 0 &&\n    changeIndex < arrayChanges.length &&\n    arrayChanges[changeIndex].status === \"added\" &&\n    arrayChanges[changeIndex - 1].status === \"added\" &&\n    arrayChanges[changeIndex - 1].index === arrayChanges[changeIndex].index - 1;\n}\n\nfunction FastForEach(spec) {\n  this.element = spec.element;\n  this.container = isVirtualNode(this.element) ?\n                   this.element.parentNode : this.element;\n  this.$context = spec.$context;\n  this.data = spec.data;\n  this.as = spec.as;\n  this.noContext = spec.noContext;\n  this.templateNode = makeTemplateNode(\n    spec.name ? document.getElementById(spec.name).cloneNode(true) : spec.element\n  );\n  this.afterQueueFlush = spec.afterQueueFlush;\n  this.beforeQueueFlush = spec.beforeQueueFlush;\n  this.changeQueue = [];\n  this.lastNodesList = [];\n  this.indexesToDelete = [];\n  this.rendering_queued = false;\n\n  // Remove existing content.\n  ko.virtualElements.emptyNode(this.element);\n\n  // Prime content\n  var primeData = ko.unwrap(this.data);\n  if (primeData.map) {\n    this.onArrayChange(primeData.map(valueToChangeAddItem));\n  }\n\n  // Watch for changes\n  if (ko.isObservable(this.data)) {\n    if (!this.data.indexOf) {\n      // Make sure the observable is trackable.\n      this.data = this.data.extend({trackArrayChanges: true});\n    }\n    this.changeSubs = this.data.subscribe(this.onArrayChange, this, 'arrayChange');\n  }\n}\n\n\nFastForEach.animateFrame = window.requestAnimationFrame || window.webkitRequestAnimationFrame ||\n  window.mozRequestAnimationFrame || window.msRequestAnimationFrame ||\n  function(cb) { return window.setTimeout(cb, 1000 / 60); };\n\n\nFastForEach.prototype.dispose = function () {\n  if (this.changeSubs) {\n    this.changeSubs.dispose();\n  }\n};\n\n\n// If the array changes we register the change.\nFastForEach.prototype.onArrayChange = function (changeSet) {\n  var self = this;\n  var changeMap = {\n    added: [],\n    deleted: []\n  };\n  for (var i = 0, len = changeSet.length; i < len; i++) {\n    // the change is appended to a last change info object when both are 'added' and have indexes next to each other\n    // here I presume that ko is sending changes in monotonic order (in index variable) which happens to be true, tested with push and splice with multiple pushed values\n    if (isAdditionAdjacentToLast(i, changeSet)) {\n      var batchValues = changeMap.added[changeMap.added.length - 1].values;\n      if (!batchValues) {\n        // transform the last addition into a batch addition object\n        var lastAddition = changeMap.added.pop();\n        var batchAddition = {\n          isBatch: true,\n          status: 'added',\n          index: lastAddition.index,\n          values: [lastAddition.value]\n        };\n        batchValues = batchAddition.values;\n        changeMap.added.push(batchAddition);\n      }\n      batchValues.push(changeSet[i].value);\n    } else {\n      changeMap[changeSet[i].status].push(changeSet[i]);\n    }\n  }\n  if (changeMap.deleted.length > 0) {\n    this.changeQueue.push.apply(this.changeQueue, changeMap.deleted);\n    this.changeQueue.push({status: 'clearDeletedIndexes'});\n  }\n  this.changeQueue.push.apply(this.changeQueue, changeMap.added);\n  // Once a change is registered, the ticking count-down starts for the processQueue.\n  if (this.changeQueue.length > 0 && !this.rendering_queued) {\n    this.rendering_queued = true;\n    FastForEach.animateFrame.call(window, function () { self.processQueue(); });\n  }\n};\n\n\n// Reflect all the changes in the queue in the DOM, then wipe the queue.\nFastForEach.prototype.processQueue = function () {\n  var self = this;\n\n  // Callback so folks can do things before the queue flush.\n  if (typeof this.beforeQueueFlush === 'function') {\n    this.beforeQueueFlush(this.changeQueue);\n  }\n\n  ko.utils.arrayForEach(this.changeQueue, function (changeItem) {\n    // console.log(self.data(), \"CI\", JSON.stringify(changeItem, null, 2), JSON.stringify($(self.element).text()))\n    self[changeItem.status](changeItem);\n    // console.log(\"  ==> \", JSON.stringify($(self.element).text()))\n  });\n  this.rendering_queued = false;\n  // Callback so folks can do things.\n  if (typeof this.afterQueueFlush === 'function') {\n    this.afterQueueFlush(this.changeQueue);\n  }\n  this.changeQueue = [];\n};\n\n\n// Process a changeItem with {status: 'added', ...}\nFastForEach.prototype.added = function (changeItem) {\n  var index = changeItem.index;\n  var valuesToAdd = changeItem.isBatch ? changeItem.values : [changeItem.value];\n  var referenceElement = this.lastNodesList[index - 1] || null;\n  // gather all childnodes for a possible batch insertion\n  var allChildNodes = [];\n\n  for (var i = 0, len = valuesToAdd.length; i < len; ++i) {\n    var templateClone = this.templateNode.cloneNode(true);\n    var childContext;\n\n    if (this.noContext) {\n      childContext = this.$context.extend({\n        '$item': valuesToAdd[i]\n      });\n    } else {\n      childContext = this.$context.createChildContext(valuesToAdd[i], this.as || null);\n    }\n\n    // apply bindings first, and then process child nodes, because bindings can add childnodes\n    ko.applyBindingsToDescendants(childContext, templateClone);\n\n    var childNodes = ko.virtualElements.childNodes(templateClone);\n    // Note discussion at https://github.com/angular/angular.js/issues/7851\n    allChildNodes.push.apply(allChildNodes, Array.prototype.slice.call(childNodes));\n    this.lastNodesList.splice(index + i, 0, childNodes[childNodes.length - 1]);\n  }\n\n  insertAllAfter(this.element, allChildNodes, referenceElement);\n};\n\n\n// Process a changeItem with {status: 'deleted', ...}\nFastForEach.prototype.deleted = function (changeItem) {\n  var index = changeItem.index;\n  var ptr = this.lastNodesList[index],\n      // We use this.element because that will be the last previous node\n      // for virtual element lists.\n      lastNode = this.lastNodesList[index - 1] || this.element;\n  do {\n    ptr = ptr.previousSibling;\n    ko.removeNode((ptr && ptr.nextSibling) || ko.virtualElements.firstChild(this.element));\n  } while (ptr && ptr !== lastNode);\n  // The \"last node\" in the DOM from which we begin our delets of the next adjacent node is\n  // now the sibling that preceded the first node of this item.\n  this.lastNodesList[index] = this.lastNodesList[index - 1];\n  this.indexesToDelete.push(index);\n};\n\n\n// We batch our deletion of item indexes in our parallel array.\n// See brianmhunt/knockout-fast-foreach#6/#8\nFastForEach.prototype.clearDeletedIndexes = function () {\n  // We iterate in reverse on the presumption (following the unit tests) that KO's diff engine\n  // processes diffs (esp. deletes) monotonically ascending i.e. from index 0 -> N.\n  for (var i = this.indexesToDelete.length - 1; i >= 0; --i) {\n    this.lastNodesList.splice(this.indexesToDelete[i], 1);\n  }\n  this.indexesToDelete = [];\n};\n\n\nko.bindingHandlers.fastForEach = {\n  // Valid valueAccessors:\n  //    []\n  //    ko.observable([])\n  //    ko.observableArray([])\n  //    ko.computed\n  //    {data: array, name: string, as: string}\n  init: function init(element, valueAccessor, bindings, vm, context) {\n    var value = valueAccessor(),\n        ffe;\n    if (isPlainObject(value)) {\n      value.element = value.element || element;\n      value.$context = context;\n      ffe = new FastForEach(value);\n    } else {\n      ffe = new FastForEach({\n        element: element,\n        data: ko.unwrap(context.$rawData) === value ? context.$rawData : value,\n        $context: context\n      });\n    }\n    ko.utils.domNodeDisposal.addDisposeCallback(element, function () {\n      ffe.dispose();\n    });\n    return {controlsDescendantBindings: true};\n  },\n\n  // Export for testing, debugging, and overloading.\n  FastForEach: FastForEach\n};\n\nko.virtualElements.allowedBindings.fastForEach = true;\n}));","knockoutjs/knockout-repeat.js":"// REPEAT binding for Knockout http://knockoutjs.com/\n// (c) Michael Best\n// License: MIT (http://www.opensource.org/licenses/mit-license.php)\n// Version 2.1.0\n\n(function(factory) {\n    if (typeof define === 'function' && define.amd) {\n        // [1] AMD anonymous module\n        define(['knockout'], factory);\n    } else if (typeof exports === 'object') {\n        // [2] commonJS\n        factory(require('knockout'));\n    } else {\n        // [3] No module loader (plain <script> tag) - put directly in global namespace\n        factory(window.ko);\n    }\n})(function(ko) {\n\nif (!ko.virtualElements)\n    throw Error('Repeat requires at least Knockout 2.1');\n\nvar ko_bindingFlags = ko.bindingFlags || {};\nvar ko_unwrap = ko.utils.unwrapObservable;\n\nvar koProtoName = '__ko_proto__';\n\nif (ko.version >= \"3.0.0\") {\n    // In Knockout 3.0.0, use the node preprocessor to replace a node with a repeat binding with a virtual element\n    var provider = ko.bindingProvider.instance, previousPreprocessFn = provider.preprocessNode;\n    provider.preprocessNode = function(node) {\n        var newNodes, nodeBinding;\n        if (!previousPreprocessFn || !(newNodes = previousPreprocessFn.call(this, node))) {\n            if (node.nodeType === 1 && (nodeBinding = node.getAttribute('data-bind'))) {\n                if (/^\\s*repeat\\s*:/.test(nodeBinding)) {\n                    var leadingComment = node.ownerDocument.createComment('ko ' + nodeBinding),\n                        trailingComment = node.ownerDocument.createComment('/ko');\n                    node.parentNode.insertBefore(leadingComment, node);\n                    node.parentNode.insertBefore(trailingComment, node.nextSibling);\n                    node.removeAttribute('data-bind');\n                    newNodes = [leadingComment, node, trailingComment];\n                }\n            }\n        }\n        return newNodes;\n    };\n}\n\nko.virtualElements.allowedBindings.repeat = true;\nko.bindingHandlers.repeat = {\n    flags: ko_bindingFlags.contentBind | ko_bindingFlags.canUseVirtual,\n    init: function(element, valueAccessor, allBindingsAccessor, xxx, bindingContext) {\n\n        // Read and set fixed options--these options cannot be changed\n        var repeatParam = ko_unwrap(valueAccessor());\n        if (repeatParam && typeof repeatParam == 'object' && !('length' in repeatParam)) {\n            var repeatIndex = repeatParam.index,\n                repeatData = repeatParam.item,\n                repeatStep = repeatParam.step,\n                repeatReversed = repeatParam.reverse,\n                repeatBind = repeatParam.bind,\n                repeatInit = repeatParam.init,\n                repeatUpdate = repeatParam.update;\n        }\n        // Set default values for options that need it\n        repeatIndex = repeatIndex || '$index';\n        repeatData = repeatData || ko.bindingHandlers.repeat.itemName || '$item';\n        repeatStep = repeatStep || 1;\n        repeatReversed = repeatReversed || false;\n\n        var parent = element.parentNode, placeholder;\n        if (element.nodeType == 8) {    // virtual element\n            // Extract the \"children\" and find the single element node\n            var childNodes = ko.utils.arrayFilter(ko.virtualElements.childNodes(element), function(node) { return node.nodeType == 1;});\n            if (childNodes.length !== 1) {\n                throw Error(\"Repeat binding requires a single element to repeat\");\n            }\n            ko.virtualElements.emptyNode(element);\n\n            // The placeholder is the closing comment normally, or the opening comment if reversed\n            placeholder = repeatReversed ? element : element.nextSibling;\n            // The element to repeat is the contained element\n            element = childNodes[0];\n        } else {    // regular element\n            // First clean the element node and remove node's binding\n            var origBindString = element.getAttribute('data-bind');\n            ko.cleanNode(element);\n            element.removeAttribute('data-bind');\n\n            // Original element is no longer needed: delete it and create a placeholder comment\n            placeholder = element.ownerDocument.createComment('ko_repeatplaceholder ' + origBindString);\n            parent.replaceChild(placeholder, element);\n        }\n\n        // extract and remove a data-repeat-bind attribute, if present\n        if (!repeatBind) {\n            repeatBind = element.getAttribute('data-repeat-bind');\n            if (repeatBind) {\n                element.removeAttribute('data-repeat-bind');\n            }\n        }\n\n        // Make a copy of the element node to be copied for each repetition\n        var cleanNode = element.cloneNode(true);\n        if (typeof repeatBind == \"string\") {\n            cleanNode.setAttribute('data-bind', repeatBind);\n            repeatBind = null;\n        }\n\n        // Set up persistent data\n        var lastRepeatCount = 0,\n            notificationObservable = ko.observable(),\n            repeatArray, arrayObservable;\n\n        if (repeatInit) {\n            repeatInit(parent);\n        }\n\n        var subscribable = ko.computed(function() {\n            function makeArrayItemAccessor(index) {\n                var f = function(newValue) {\n                    var item = repeatArray[index];\n                    // Reading the value of the item\n                    if (!arguments.length) {\n                        notificationObservable();   // for dependency tracking\n                        return ko_unwrap(item);\n                    }\n                    // Writing a value to the item\n                    if (ko.isObservable(item)) {\n                        item(newValue);\n                    } else if (arrayObservable && arrayObservable.splice) {\n                        arrayObservable.splice(index, 1, newValue);\n                    } else {\n                        repeatArray[index] = newValue;\n                    }\n                    return this;\n                };\n                // Pretend that our accessor function is an observable\n                f[koProtoName] = ko.observable;\n                return f;\n            }\n\n            function makeBinding(item, index, context) {\n                return repeatArray\n                    ? function() { return repeatBind.call(bindingContext.$data, item, index, context); }\n                    : function() { return repeatBind.call(bindingContext.$data, index, context); }\n            }\n\n            // Read and set up variable options--these options can change and will update the binding\n            var paramObservable = valueAccessor(), repeatParam = ko_unwrap(paramObservable), repeatCount = 0;\n            if (repeatParam && typeof repeatParam == 'object') {\n                if ('length' in repeatParam) {\n                    repeatArray = repeatParam;\n                    repeatCount = repeatArray.length;\n                } else {\n                    if ('foreach' in repeatParam) {\n                        repeatArray = ko_unwrap(paramObservable = repeatParam.foreach);\n                        if (repeatArray && typeof repeatArray == 'object' && 'length' in repeatArray) {\n                            repeatCount = repeatArray.length || 0;\n                        } else {\n                            repeatCount = repeatArray || 0;\n                            repeatArray = null;\n                        }\n                    }\n                    // If a count value is provided (>0), always output that number of items\n                    if ('count' in repeatParam)\n                        repeatCount = ko_unwrap(repeatParam.count) || repeatCount;\n                    // If a limit is provided, don't output more than the limit\n                    if ('limit' in repeatParam)\n                        repeatCount = Math.min(repeatCount, ko_unwrap(repeatParam.limit)) || repeatCount;\n                }\n                arrayObservable = repeatArray && ko.isObservable(paramObservable) ? paramObservable : null;\n            } else {\n                repeatCount = repeatParam || 0;\n            }\n\n            // Remove nodes from end if array is shorter\n            for (; lastRepeatCount > repeatCount; lastRepeatCount-=repeatStep) {\n                ko.removeNode(repeatReversed ? placeholder.nextSibling : placeholder.previousSibling);\n            }\n\n            // Notify existing nodes of change\n            notificationObservable.notifySubscribers();\n\n            // Add nodes to end if array is longer (also initially populates nodes)\n            for (; lastRepeatCount < repeatCount; lastRepeatCount+=repeatStep) {\n                // Clone node and add to document\n                var newNode = cleanNode.cloneNode(true);\n                parent.insertBefore(newNode, repeatReversed ? placeholder.nextSibling : placeholder);\n                newNode.setAttribute('data-repeat-index', lastRepeatCount);\n\n                // Apply bindings to inserted node\n                if (repeatArray && repeatData == '$data') {\n                    var newContext = bindingContext.createChildContext(makeArrayItemAccessor(lastRepeatCount));\n                } else {\n                    var newContext = bindingContext.extend();\n                    if (repeatArray)\n                        newContext[repeatData] = makeArrayItemAccessor(lastRepeatCount);\n                }\n                newContext[repeatIndex] = lastRepeatCount;\n                if (repeatBind) {\n                    var result = ko.applyBindingsToNode(newNode, makeBinding(newContext[repeatData], lastRepeatCount, newContext), newContext, true),\n                        shouldBindDescendants = result && result.shouldBindDescendants;\n                }\n                if (!repeatBind || (result && shouldBindDescendants !== false)) {\n                    ko.applyBindings(newContext, newNode);\n                }\n            }\n            if (repeatUpdate) {\n                repeatUpdate(parent);\n            }\n        }, null, {disposeWhenNodeIsRemoved: placeholder});\n\n        return { controlsDescendantBindings: true, subscribable: subscribable };\n    }\n};\n});","knockoutjs/knockout-es5.js":"/*!\n * Knockout ES5 plugin - https://github.com/SteveSanderson/knockout-es5\n * Copyright (c) Steve Sanderson\n * MIT license\n */\n\n(function(global, undefined) {\n  'use strict';\n\n  var ko;\n\n  // Model tracking\n  // --------------\n  //\n  // This is the central feature of Knockout-ES5. We augment model objects by converting properties\n  // into ES5 getter/setter pairs that read/write an underlying Knockout observable. This means you can\n  // use plain JavaScript syntax to read/write the property while still getting the full benefits of\n  // Knockout's automatic dependency detection and notification triggering.\n  //\n  // For comparison, here's Knockout ES3-compatible syntax:\n  //\n  //     var firstNameLength = myModel.user().firstName().length; // Read\n  //     myModel.user().firstName('Bert'); // Write\n  //\n  // ... versus Knockout-ES5 syntax:\n  //\n  //     var firstNameLength = myModel.user.firstName.length; // Read\n  //     myModel.user.firstName = 'Bert'; // Write\n\n  // `ko.track(model)` converts each property on the given model object into a getter/setter pair that\n  // wraps a Knockout observable. Optionally specify an array of property names to wrap; otherwise we\n  // wrap all properties. If any of the properties are already observables, we replace them with\n  // ES5 getter/setter pairs that wrap your original observable instances. In the case of readonly\n  // ko.computed properties, we simply do not define a setter (so attempted writes will be ignored,\n  // which is how ES5 readonly properties normally behave).\n  //\n  // By design, this does *not* recursively walk child object properties, because making literally\n  // everything everywhere independently observable is usually unhelpful. When you do want to track\n  // child object properties independently, define your own class for those child objects and put\n  // a separate ko.track call into its constructor --- this gives you far more control.\n  /**\n   * @param {object} obj\n   * @param {object|array.<string>} propertyNamesOrSettings\n   * @param {boolean} propertyNamesOrSettings.deep Use deep track.\n   * @param {array.<string>} propertyNamesOrSettings.fields Array of property names to wrap.\n   * todo: @param {array.<string>} propertyNamesOrSettings.exclude Array of exclude property names to wrap.\n   * todo: @param {function(string, *):boolean} propertyNamesOrSettings.filter Function to filter property \n   *   names to wrap. A function that takes ... params\n   * @return {object}\n   */\n  function track(obj, propertyNamesOrSettings) {\n    if (!obj || typeof obj !== 'object') {\n      throw new Error('When calling ko.track, you must pass an object as the first parameter.');\n    }\n\n    var propertyNames;\n\n    if ( isPlainObject(propertyNamesOrSettings) ) {\n      // defaults\n      propertyNamesOrSettings.deep = propertyNamesOrSettings.deep || false;\n      propertyNamesOrSettings.fields = propertyNamesOrSettings.fields || Object.getOwnPropertyNames(obj);\n      propertyNamesOrSettings.lazy = propertyNamesOrSettings.lazy || false;\n\n      wrap(obj, propertyNamesOrSettings.fields, propertyNamesOrSettings);\n    } else {\n      propertyNames = propertyNamesOrSettings || Object.getOwnPropertyNames(obj);\n      wrap(obj, propertyNames, {});\n    }\n\n    return obj;\n  }\n\n  // fix for ie\n  var rFunctionName = /^function\\s*([^\\s(]+)/;\n  function getFunctionName( ctor ){\n    if (ctor.name) {\n      return ctor.name;\n    }\n    return (ctor.toString().trim().match( rFunctionName ) || [])[1];\n  }\n\n  function canTrack(obj) {\n    return obj && typeof obj === 'object' && getFunctionName(obj.constructor) === 'Object';\n  }\n\n  function createPropertyDescriptor(originalValue, prop, map) {\n    var isObservable = ko.isObservable(originalValue);\n    var isArray = !isObservable && Array.isArray(originalValue);\n    var observable = isObservable ? originalValue\n        : isArray ? ko.observableArray(originalValue)\n        : ko.observable(originalValue);\n\n    map[prop] = function () { return observable; };\n\n    // add check in case the object is already an observable array\n    if (isArray || (isObservable && 'push' in observable)) {\n      notifyWhenPresentOrFutureArrayValuesMutate(ko, observable);\n    }\n\n    return {\n      configurable: true,\n      enumerable: true,\n      get: observable,\n      set: ko.isWriteableObservable(observable) ? observable : undefined\n    };\n  }\n\n  function createLazyPropertyDescriptor(originalValue, prop, map) {\n    if (ko.isObservable(originalValue)) {\n      // no need to be lazy if we already have an observable\n      return createPropertyDescriptor(originalValue, prop, map);\n    }\n\n    var observable;\n\n    function getOrCreateObservable(value, writing) {\n      if (observable) {\n        return writing ? observable(value) : observable;\n      }\n\n      if (Array.isArray(value)) {\n        observable = ko.observableArray(value);\n        notifyWhenPresentOrFutureArrayValuesMutate(ko, observable);\n        return observable;\n      }\n\n      return (observable = ko.observable(value));\n    }\n\n    map[prop] = function () { return getOrCreateObservable(originalValue); };\n    return {\n      configurable: true,\n      enumerable: true,\n      get: function () { return getOrCreateObservable(originalValue)(); },\n      set: function (value) { getOrCreateObservable(value, true); }\n    };\n  }\n\n  function wrap(obj, props, options) {\n    if (!props.length) {\n      return;\n    }\n\n    var allObservablesForObject = getAllObservablesForObject(obj, true);\n    var descriptors = {};\n\n    props.forEach(function (prop) {\n      // Skip properties that are already tracked\n      if (prop in allObservablesForObject) {\n        return;\n      }\n\n      // Skip properties where descriptor can't be redefined\n      if (Object.getOwnPropertyDescriptor(obj, prop).configurable === false){\n        return;\n      }\n\n      var originalValue = obj[prop];\n      descriptors[prop] = (options.lazy ? createLazyPropertyDescriptor : createPropertyDescriptor)\n        (originalValue, prop, allObservablesForObject);\n\n      if (options.deep && canTrack(originalValue)) {\n        wrap(originalValue, Object.keys(originalValue), options);\n      }\n    });\n\n    Object.defineProperties(obj, descriptors);\n  }\n\n  function isPlainObject( obj ){\n    return !!obj && typeof obj === 'object' && obj.constructor === Object;\n  }\n\n  // Lazily created by `getAllObservablesForObject` below. Has to be created lazily because the\n  // WeakMap factory isn't available until the module has finished loading (may be async).\n  var objectToObservableMap;\n\n  // Gets or creates the hidden internal key-value collection of observables corresponding to\n  // properties on the model object.\n  function getAllObservablesForObject(obj, createIfNotDefined) {\n    if (!objectToObservableMap) {\n      objectToObservableMap = weakMapFactory();\n    }\n\n    var result = objectToObservableMap.get(obj);\n    if (!result && createIfNotDefined) {\n      result = {};\n      objectToObservableMap.set(obj, result);\n    }\n    return result;\n  }\n\n  // Removes the internal references to observables mapped to the specified properties\n  // or the entire object reference if no properties are passed in. This allows the\n  // observables to be replaced and tracked again.\n  function untrack(obj, propertyNames) {\n    if (!objectToObservableMap) {\n      return;\n    }\n\n    if (arguments.length === 1) {\n      objectToObservableMap['delete'](obj);\n    } else {\n      var allObservablesForObject = getAllObservablesForObject(obj, false);\n      if (allObservablesForObject) {\n        propertyNames.forEach(function(propertyName) {\n          delete allObservablesForObject[propertyName];\n        });\n      }\n    }\n  }\n\n  // Computed properties\n  // -------------------\n  //\n  // The preceding code is already sufficient to upgrade ko.computed model properties to ES5\n  // getter/setter pairs (or in the case of readonly ko.computed properties, just a getter).\n  // These then behave like a regular property with a getter function, except they are smarter:\n  // your evaluator is only invoked when one of its dependencies changes. The result is cached\n  // and used for all evaluations until the next time a dependency changes).\n  //\n  // However, instead of forcing developers to declare a ko.computed property explicitly, it's\n  // nice to offer a utility function that declares a computed getter directly.\n\n  // Implements `ko.defineProperty`\n  function defineComputedProperty(obj, propertyName, evaluatorOrOptions) {\n    var ko = this,\n      computedOptions = { owner: obj, deferEvaluation: true };\n\n    if (typeof evaluatorOrOptions === 'function') {\n      computedOptions.read = evaluatorOrOptions;\n    } else {\n      if ('value' in evaluatorOrOptions) {\n        throw new Error('For ko.defineProperty, you must not specify a \"value\" for the property. ' +\n                        'You must provide a \"get\" function.');\n      }\n\n      if (typeof evaluatorOrOptions.get !== 'function') {\n        throw new Error('For ko.defineProperty, the third parameter must be either an evaluator function, ' +\n                        'or an options object containing a function called \"get\".');\n      }\n\n      computedOptions.read = evaluatorOrOptions.get;\n      computedOptions.write = evaluatorOrOptions.set;\n    }\n\n    obj[propertyName] = ko.computed(computedOptions);\n    track.call(ko, obj, [propertyName]);\n    return obj;\n  }\n\n  // Array handling\n  // --------------\n  //\n  // Arrays are special, because unlike other property types, they have standard mutator functions\n  // (`push`/`pop`/`splice`/etc.) and it's desirable to trigger a change notification whenever one of\n  // those mutator functions is invoked.\n  //\n  // Traditionally, Knockout handles this by putting special versions of `push`/`pop`/etc. on observable\n  // arrays that mutate the underlying array and then trigger a notification. That approach doesn't\n  // work for Knockout-ES5 because properties now return the underlying arrays, so the mutator runs\n  // in the context of the underlying array, not any particular observable:\n  //\n  //     // Operates on the underlying array value\n  //     myModel.someCollection.push('New value');\n  //\n  // To solve this, Knockout-ES5 detects array values, and modifies them as follows:\n  //  1. Associates a hidden subscribable with each array instance that it encounters\n  //  2. Intercepts standard mutators (`push`/`pop`/etc.) and makes them trigger the subscribable\n  // Then, for model properties whose values are arrays, the property's underlying observable\n  // subscribes to the array subscribable, so it can trigger a change notification after mutation.\n\n  // Given an observable that underlies a model property, watch for any array value that might\n  // be assigned as the property value, and hook into its change events\n  function notifyWhenPresentOrFutureArrayValuesMutate(ko, observable) {\n    var watchingArraySubscription = null;\n    ko.computed(function () {\n      // Unsubscribe to any earlier array instance\n      if (watchingArraySubscription) {\n        watchingArraySubscription.dispose();\n        watchingArraySubscription = null;\n      }\n\n      // Subscribe to the new array instance\n      var newArrayInstance = observable();\n      if (newArrayInstance instanceof Array) {\n        watchingArraySubscription = startWatchingArrayInstance(ko, observable, newArrayInstance);\n      }\n    });\n  }\n\n  // Listens for array mutations, and when they happen, cause the observable to fire notifications.\n  // This is used to make model properties of type array fire notifications when the array changes.\n  // Returns a subscribable that can later be disposed.\n  function startWatchingArrayInstance(ko, observable, arrayInstance) {\n    var subscribable = getSubscribableForArray(ko, arrayInstance);\n    return subscribable.subscribe(observable);\n  }\n\n  // Lazily created by `getSubscribableForArray` below. Has to be created lazily because the\n  // WeakMap factory isn't available until the module has finished loading (may be async).\n  var arraySubscribablesMap;\n\n  // Gets or creates a subscribable that fires after each array mutation\n  function getSubscribableForArray(ko, arrayInstance) {\n    if (!arraySubscribablesMap) {\n      arraySubscribablesMap = weakMapFactory();\n    }\n\n    var subscribable = arraySubscribablesMap.get(arrayInstance);\n    if (!subscribable) {\n      subscribable = new ko.subscribable();\n      arraySubscribablesMap.set(arrayInstance, subscribable);\n\n      var notificationPauseSignal = {};\n      wrapStandardArrayMutators(arrayInstance, subscribable, notificationPauseSignal);\n      addKnockoutArrayMutators(ko, arrayInstance, subscribable, notificationPauseSignal);\n    }\n\n    return subscribable;\n  }\n\n  // After each array mutation, fires a notification on the given subscribable\n  function wrapStandardArrayMutators(arrayInstance, subscribable, notificationPauseSignal) {\n    ['pop', 'push', 'reverse', 'shift', 'sort', 'splice', 'unshift'].forEach(function(fnName) {\n      var origMutator = arrayInstance[fnName];\n      arrayInstance[fnName] = function() {\n        var result = origMutator.apply(this, arguments);\n        if (notificationPauseSignal.pause !== true) {\n          subscribable.notifySubscribers(this);\n        }\n        return result;\n      };\n    });\n  }\n\n  // Adds Knockout's additional array mutation functions to the array\n  function addKnockoutArrayMutators(ko, arrayInstance, subscribable, notificationPauseSignal) {\n    ['remove', 'removeAll', 'destroy', 'destroyAll', 'replace'].forEach(function(fnName) {\n      // Make it a non-enumerable property for consistency with standard Array functions\n      Object.defineProperty(arrayInstance, fnName, {\n        enumerable: false,\n        value: function() {\n          var result;\n\n          // These additional array mutators are built using the underlying push/pop/etc.\n          // mutators, which are wrapped to trigger notifications. But we don't want to\n          // trigger multiple notifications, so pause the push/pop/etc. wrappers and\n          // delivery only one notification at the end of the process.\n          notificationPauseSignal.pause = true;\n          try {\n            // Creates a temporary observableArray that can perform the operation.\n            result = ko.observableArray.fn[fnName].apply(ko.observableArray(arrayInstance), arguments);\n          }\n          finally {\n            notificationPauseSignal.pause = false;\n          }\n          subscribable.notifySubscribers(arrayInstance);\n          return result;\n        }\n      });\n    });\n  }\n\n  // Static utility functions\n  // ------------------------\n  //\n  // Since Knockout-ES5 sets up properties that return values, not observables, you can't\n  // trivially subscribe to the underlying observables (e.g., `someProperty.subscribe(...)`),\n  // or tell them that object values have mutated, etc. To handle this, we set up some\n  // extra utility functions that can return or work with the underlying observables.\n\n  // Returns the underlying observable associated with a model property (or `null` if the\n  // model or property doesn't exist, or isn't associated with an observable). This means\n  // you can subscribe to the property, e.g.:\n  //\n  //     ko.getObservable(model, 'propertyName')\n  //       .subscribe(function(newValue) { ... });\n  function getObservable(obj, propertyName) {\n    if (!obj || typeof obj !== 'object') {\n      return null;\n    }\n\n    var allObservablesForObject = getAllObservablesForObject(obj, false);\n    if (allObservablesForObject && propertyName in allObservablesForObject) {\n      return allObservablesForObject[propertyName]();\n    }\n\n    return null;\n  }\n  \n  // Returns a boolean indicating whether the property on the object has an underlying\n  // observables. This does the check in a way not to create an observable if the\n  // object was created with lazily created observables\n  function isTracked(obj, propertyName) {\n    if (!obj || typeof obj !== 'object') {\n      return false;\n    }\n    \n    var allObservablesForObject = getAllObservablesForObject(obj, false);\n    return !!allObservablesForObject && propertyName in allObservablesForObject;\n  }\n\n  // Causes a property's associated observable to fire a change notification. Useful when\n  // the property value is a complex object and you've modified a child property.\n  function valueHasMutated(obj, propertyName) {\n    var observable = getObservable(obj, propertyName);\n\n    if (observable) {\n      observable.valueHasMutated();\n    }\n  }\n\n  // Module initialisation\n  // ---------------------\n  //\n  // When this script is first evaluated, it works out what kind of module loading scenario\n  // it is in (Node.js or a browser `<script>` tag), stashes a reference to its dependencies\n  // (currently that's just the WeakMap shim), and then finally attaches itself to whichever\n  // instance of Knockout.js it can find.\n\n  // A function that returns a new ES6-compatible WeakMap instance (using ES5 shim if needed).\n  // Instantiated by prepareExports, accounting for which module loader is being used.\n  var weakMapFactory;\n\n  // Extends a Knockout instance with Knockout-ES5 functionality\n  function attachToKo(ko) {\n    ko.track = track;\n    ko.untrack = untrack;\n    ko.getObservable = getObservable;\n    ko.valueHasMutated = valueHasMutated;\n    ko.defineProperty = defineComputedProperty;\n\n    // todo: test it, maybe added it to ko. directly\n    ko.es5 = {\n      getAllObservablesForObject: getAllObservablesForObject,\n      notifyWhenPresentOrFutureArrayValuesMutate: notifyWhenPresentOrFutureArrayValuesMutate,\n      isTracked: isTracked\n    };\n  }\n\n  // Determines which module loading scenario we're in, grabs dependencies, and attaches to KO\n  function prepareExports() {\n    if (typeof exports === 'object' && typeof module === 'object') {\n      // Node.js case - load KO and WeakMap modules synchronously\n      ko = require('knockout');\n      var WM = require('../lib/weakmap');\n      attachToKo(ko);\n      weakMapFactory = function() { return new WM(); };\n      module.exports = ko;\n    } else if (typeof define === 'function' && define.amd) {\n      define(['knockout'], function(koModule) {\n        ko = koModule;\n        attachToKo(koModule);\n        weakMapFactory = function() { return new global.WeakMap(); };\n        return koModule;\n      });\n    } else if ('ko' in global) {\n      // Non-module case - attach to the global instance, and assume a global WeakMap constructor\n      ko = global.ko;\n      attachToKo(global.ko);\n      weakMapFactory = function() { return new global.WeakMap(); };\n    }\n  }\n\n  prepareExports();\n\n})(this);","Magento_Tax/js/price/adjustment.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'mage/translate'\n], function (Element, $t) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            bodyTmpl: 'Magento_Tax/price/adjustment',\n            taxPriceType: 'final_price',\n            taxPriceCssClass: 'price-including-tax',\n            bothPrices: 3,\n            inclTax: 2,\n            exclTax: 1,\n            modules: {\n                price: '${ $.parentName }'\n            },\n            listens: {\n                price: 'initializePriceAttributes'\n            }\n        },\n\n        /**\n         * {@inheritdoc}\n         */\n        initialize: function () {\n            this._super()\n                .initializePriceAttributes();\n\n            return this;\n        },\n\n        /**\n         * Update parent price.\n         *\n         * @returns {Object} Chainable.\n         */\n        initializePriceAttributes: function () {\n            if (this.displayBothPrices && this.price()) {\n                this.price().priceWrapperCssClasses = this.taxPriceCssClass;\n                this.price().priceWrapperAttr = {\n                    'data-label': $t('Incl. Tax')\n                };\n            }\n\n            return this;\n        },\n\n        /**\n         * Get price tax adjustment.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} tax html\n         */\n        getTax: function (row) {\n            return row['price_info']['extension_attributes']['tax_adjustments']['formatted_prices'][this.taxPriceType];\n        },\n\n        /**\n         * Set price tax type.\n         *\n         * @param {String} priceType\n         * @return {Object}\n         */\n        setPriceType: function (priceType) {\n            this.taxPriceType = priceType;\n\n            return this;\n        },\n\n        /**\n         * Return whether display setting is to display\n         * both price including tax and price excluding tax.\n         *\n         * @return {Boolean}\n         */\n        displayBothPrices: function () {\n            return +this.source.data.displayTaxes === this.bothPrices;\n        },\n\n        /**\n         * Return whether display setting is to display price including tax.\n         *\n         * @return {Boolean}\n         */\n        displayPriceIncludeTax: function () {\n            return +this.source.data.displayTaxes === this.inclTax;\n        },\n\n        /**\n         * Return whether display setting is to display price excluding tax.\n         *\n         * @return {Boolean}\n         */\n        displayPriceExclTax: function () {\n            return +this.source.data.displayTaxes === this.exclTax;\n        }\n    });\n});\n","Magento_Tax/js/view/checkout/shipping_method/price.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Catalog/js/price-utils'\n], function (Component, quote, priceUtils) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Tax/checkout/shipping_method/price'\n        },\n        isDisplayShippingPriceExclTax: window.checkoutConfig.isDisplayShippingPriceExclTax,\n        isDisplayShippingBothPrices: window.checkoutConfig.isDisplayShippingBothPrices,\n\n        /**\n         * @param {Object} item\n         * @return {Boolean}\n         */\n        isPriceEqual: function (item) {\n            return item['price_excl_tax'] != item['price_incl_tax']; //eslint-disable-line eqeqeq\n        },\n\n        /**\n         * @param {*} price\n         * @return {*|String}\n         */\n        getFormattedPrice: function (price) {\n            //todo add format data\n            return priceUtils.formatPrice(price, quote.getPriceFormat());\n        }\n    });\n});\n","Magento_Tax/js/view/checkout/minicart/subtotal/totals.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'ko',\n    'uiComponent',\n    'Magento_Customer/js/customer-data'\n], function (ko, Component, customerData) {\n    'use strict';\n\n    return Component.extend({\n        displaySubtotal: ko.observable(true),\n\n        /**\n         * @override\n         */\n        initialize: function () {\n            this._super();\n            this.cart = customerData.get('cart');\n        }\n    });\n});\n","Magento_Tax/js/view/checkout/cart/totals/tax.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'Magento_Tax/js/view/checkout/summary/tax',\n    'Magento_Checkout/js/model/totals'\n], function (Component, totals) {\n    'use strict';\n\n    var isFullTaxSummaryDisplayed = window.checkoutConfig.isFullTaxSummaryDisplayed,\n        isZeroTaxDisplayed = window.checkoutConfig.isZeroTaxDisplayed;\n\n    return Component.extend({\n        /**\n         * @override\n         */\n        ifShowValue: function () {\n            if (this.getPureValue() === 0) {\n                return isZeroTaxDisplayed;\n            }\n\n            return true;\n        },\n\n        /**\n         * @override\n         */\n        ifShowDetails: function () {\n            return this.getPureValue() > 0 && isFullTaxSummaryDisplayed;\n        },\n\n        /**\n         * @override\n         */\n        isCalculated: function () {\n            return this.totals() && totals.getSegment('tax') !== null;\n        }\n    });\n});\n","Magento_Tax/js/view/checkout/cart/totals/grand-total.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'Magento_Tax/js/view/checkout/summary/grand-total'\n], function (Component) {\n    'use strict';\n\n    return Component.extend({\n        /**\n         * @override\n         */\n        isDisplayed: function () {\n            return true;\n        }\n    });\n});\n","Magento_Tax/js/view/checkout/cart/totals/shipping.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'Magento_Tax/js/view/checkout/summary/shipping',\n    'Magento_Checkout/js/model/quote'\n], function (Component, quote) {\n    'use strict';\n\n    return Component.extend({\n        /**\n         * @override\n         */\n        isCalculated: function () {\n            return !!quote.shippingMethod();\n        },\n\n        /**\n         * @override\n         */\n        getShippingMethodTitle: function () {\n            return '(' + this._super() + ')';\n        }\n    });\n});\n","Magento_Tax/js/view/checkout/summary/subtotal.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'Magento_Checkout/js/view/summary/abstract-total',\n    'Magento_Checkout/js/model/quote'\n], function (Component, quote) {\n    'use strict';\n\n    var displaySubtotalMode = window.checkoutConfig.reviewTotalsDisplayMode;\n\n    return Component.extend({\n        defaults: {\n            displaySubtotalMode: displaySubtotalMode,\n            template: 'Magento_Tax/checkout/summary/subtotal'\n        },\n        totals: quote.getTotals(),\n\n        /**\n         * @return {*|String}\n         */\n        getValue: function () {\n            var price = 0;\n\n            if (this.totals()) {\n                price = this.totals().subtotal;\n            }\n\n            return this.getFormattedPrice(price);\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isBothPricesDisplayed: function () {\n            return this.displaySubtotalMode == 'both'; //eslint-disable-line eqeqeq\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isIncludingTaxDisplayed: function () {\n            return this.displaySubtotalMode == 'including'; //eslint-disable-line eqeqeq\n        },\n\n        /**\n         * @return {*|String}\n         */\n        getValueInclTax: function () {\n            var price = 0;\n\n            if (this.totals()) {\n                price = this.totals()['subtotal_incl_tax'];\n            }\n\n            return this.getFormattedPrice(price);\n        }\n    });\n});\n","Magento_Tax/js/view/checkout/summary/tax.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'ko',\n    'Magento_Checkout/js/view/summary/abstract-total',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/totals',\n    'mage/translate',\n    'underscore'\n], function (ko, Component, quote, totals, $t, _) {\n    'use strict';\n\n    var isTaxDisplayedInGrandTotal = window.checkoutConfig.includeTaxInGrandTotal,\n        isFullTaxSummaryDisplayed = window.checkoutConfig.isFullTaxSummaryDisplayed,\n        isZeroTaxDisplayed = window.checkoutConfig.isZeroTaxDisplayed,\n        taxAmount = 0,\n        rates = 0;\n\n    return Component.extend({\n        defaults: {\n            isTaxDisplayedInGrandTotal: isTaxDisplayedInGrandTotal,\n            notCalculatedMessage: $t('Not yet calculated'),\n            template: 'Magento_Tax/checkout/summary/tax'\n        },\n        totals: quote.getTotals(),\n        isFullTaxSummaryDisplayed: isFullTaxSummaryDisplayed,\n\n        /**\n         * @return {Boolean}\n         */\n        ifShowValue: function () {\n            if (this.isFullMode() && this.getPureValue() == 0) { //eslint-disable-line eqeqeq\n                return isZeroTaxDisplayed;\n            }\n\n            return true;\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        ifShowDetails: function () {\n            if (!this.isFullMode()) {\n                return false;\n            }\n\n            return this.getPureValue() > 0 && isFullTaxSummaryDisplayed;\n        },\n\n        /**\n         * @return {Number}\n         */\n        getPureValue: function () {\n            var amount = 0,\n                taxTotal;\n\n            if (this.totals()) {\n                taxTotal = totals.getSegment('tax');\n\n                if (taxTotal) {\n                    amount = taxTotal.value;\n                }\n            }\n\n            return amount;\n        },\n\n        /**\n         * @return {*|Boolean}\n         */\n        isCalculated: function () {\n            return this.totals() && this.isFullMode() && totals.getSegment('tax') != null;\n        },\n\n        /**\n         * @return {*}\n         */\n        getValue: function () {\n            var amount;\n\n            if (!this.isCalculated()) {\n                return this.notCalculatedMessage;\n            }\n            amount = totals.getSegment('tax').value;\n\n            return this.getFormattedPrice(amount);\n        },\n\n        /**\n         * @param {*} amount\n         * @return {*|String}\n         */\n        formatPrice: function (amount) {\n            return this.getFormattedPrice(amount);\n        },\n\n        /**\n         * @param {*} parent\n         * @param {*} percentage\n         * @return {*|String}\n         */\n        getTaxAmount: function (parent, percentage) {\n            var totalPercentage = 0;\n\n            taxAmount = parent.amount;\n            rates = parent.rates;\n            _.each(rates, function (rate) {\n                totalPercentage += parseFloat(rate.percent);\n            });\n\n            return this.getFormattedPrice(this.getPercentAmount(taxAmount, totalPercentage, percentage));\n        },\n\n        /**\n         * @param {*} amount\n         * @param {*} totalPercentage\n         * @param {*} percentage\n         * @return {*|String}\n         */\n        getPercentAmount: function (amount, totalPercentage, percentage) {\n            return parseFloat(amount * percentage / totalPercentage);\n        },\n\n        /**\n         * @return {Array}\n         */\n        getDetails: function () {\n            var taxSegment = totals.getSegment('tax');\n\n            if (taxSegment && taxSegment['extension_attributes']) {\n                return taxSegment['extension_attributes']['tax_grandtotal_details'];\n            }\n\n            return [];\n        }\n    });\n});\n","Magento_Tax/js/view/checkout/summary/grand-total.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'Magento_Checkout/js/view/summary/abstract-total',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Catalog/js/price-utils',\n    'Magento_Checkout/js/model/totals'\n], function (Component, quote, priceUtils, totals) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            isFullTaxSummaryDisplayed: window.checkoutConfig.isFullTaxSummaryDisplayed || false,\n            template: 'Magento_Tax/checkout/summary/grand-total'\n        },\n        totals: quote.getTotals(),\n        isTaxDisplayedInGrandTotal: window.checkoutConfig.includeTaxInGrandTotal || false,\n\n        /**\n         * @return {*}\n         */\n        isDisplayed: function () {\n            return this.isFullMode();\n        },\n\n        /**\n         * @return {*|String}\n         */\n        getValue: function () {\n            var price = 0;\n\n            if (this.totals()) {\n                price = totals.getSegment('grand_total').value;\n            }\n\n            return this.getFormattedPrice(price);\n        },\n\n        /**\n         * @return {*|String}\n         */\n        getBaseValue: function () {\n            var price = 0;\n\n            if (this.totals()) {\n                price = this.totals()['base_grand_total'];\n            }\n\n            return priceUtils.formatPrice(price, quote.getBasePriceFormat());\n        },\n\n        /**\n         * @return {*}\n         */\n        getGrandTotalExclTax: function () {\n            var total = this.totals();\n\n            if (!total) {\n                return 0;\n            }\n\n            return this.getFormattedPrice(total['grand_total']);\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isBaseGrandTotalDisplayNeeded: function () {\n            var total = this.totals();\n\n            if (!total) {\n                return false;\n            }\n\n            return total['base_currency_code'] != total['quote_currency_code']; //eslint-disable-line eqeqeq\n        }\n    });\n});\n","Magento_Tax/js/view/checkout/summary/shipping.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'jquery',\n    'Magento_Checkout/js/view/summary/shipping',\n    'Magento_Checkout/js/model/quote'\n], function ($, Component, quote) {\n    'use strict';\n\n    var displayMode = window.checkoutConfig.reviewShippingDisplayMode;\n\n    return Component.extend({\n        defaults: {\n            displayMode: displayMode,\n            template: 'Magento_Tax/checkout/summary/shipping'\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isBothPricesDisplayed: function () {\n            return this.displayMode == 'both'; //eslint-disable-line eqeqeq\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isIncludingDisplayed: function () {\n            return this.displayMode == 'including'; //eslint-disable-line eqeqeq\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isExcludingDisplayed: function () {\n            return this.displayMode == 'excluding'; //eslint-disable-line eqeqeq\n        },\n\n        /**\n         * @return {*|Boolean}\n         */\n        isCalculated: function () {\n            return this.totals() && this.isFullMode() && quote.shippingMethod() != null;\n        },\n\n        /**\n         * @return {*}\n         */\n        getIncludingValue: function () {\n            var price;\n\n            if (!this.isCalculated()) {\n                return this.notCalculatedMessage;\n            }\n            price = this.totals()['shipping_incl_tax'];\n\n            return this.getFormattedPrice(price);\n        },\n\n        /**\n         * @return {*}\n         */\n        getExcludingValue: function () {\n            var price;\n\n            if (!this.isCalculated()) {\n                return this.notCalculatedMessage;\n            }\n            price = this.totals()['shipping_amount'];\n\n            return this.getFormattedPrice(price);\n        }\n    });\n});\n","Magento_Tax/js/view/checkout/summary/item/details/subtotal.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'Magento_Checkout/js/view/summary/item/details/subtotal'\n], function (subtotal) {\n    'use strict';\n\n    var displayPriceMode = window.checkoutConfig.reviewItemPriceDisplayMode || 'including';\n\n    return subtotal.extend({\n        defaults: {\n            displayPriceMode: displayPriceMode,\n            template: 'Magento_Tax/checkout/summary/item/details/subtotal'\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isPriceInclTaxDisplayed: function () {\n            return displayPriceMode == 'both' || displayPriceMode == 'including'; //eslint-disable-line eqeqeq\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isPriceExclTaxDisplayed: function () {\n            return displayPriceMode == 'both' || displayPriceMode == 'excluding'; //eslint-disable-line eqeqeq\n        },\n\n        /**\n         * @param {Object} quoteItem\n         * @return {*|String}\n         */\n        getValueInclTax: function (quoteItem) {\n            return this.getFormattedPrice(quoteItem['row_total_incl_tax']);\n        },\n\n        /**\n         * @param {Object} quoteItem\n         * @return {*|String}\n         */\n        getValueExclTax: function (quoteItem) {\n            return this.getFormattedPrice(quoteItem['row_total']);\n        }\n\n    });\n});\n","Mageplaza_Reports/js/store-switcher.js":"/**\n * Mageplaza\n *\n * NOTICE OF LICENSE\n *\n * This source file is subject to the Mageplaza.com license that is\n * available through the world-wide-web at this URL:\n * https://www.mageplaza.com/LICENSE.txt\n *\n * DISCLAIMER\n *\n * Do not edit or add to this file if you wish to upgrade this extension to newer\n * version in the future.\n *\n * @category    Mageplaza\n * @package     Mageplaza_Reports\n * @copyright   Copyright (c) Mageplaza (https://www.mageplaza.com/)\n * @license     https://www.mageplaza.com/LICENSE.txt\n */\n\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    /**\n     * @param {Object} storeSwitchConfig\n     */\n    return function (storeSwitchConfig) {\n        var scopeSwitcherHandler;\n\n        (function () {\n            var storesList = $('[data-role=stores-list]');\n\n            storesList.on('click', '[data-value]', function (event) {\n                var val      = $(event.target).data('value'),\n                    role     = $(event.target).data('role'),\n                    switcher = $('[data-role=' + role + ']');\n\n                event.preventDefault();\n\n                if (!switcher.val() || val !== switcher.val()) {\n\n                    /* Set the value & trigger event */\n                    switcher.val(val).trigger('change');\n                }\n            });\n        })($);\n\n        /**\n         * Switch store scope\n         *\n         * @param {Object} obj\n         * @return void\n         */\n        function switchScope (obj) {\n            var switcher       = $(obj),\n                scopeId        = switcher.val(),\n                scopeParams    = '',\n                switcherParams = {};\n\n            if (scopeId) {\n                scopeParams = switcher.data('param') + '/' + scopeId + '/';\n            }\n\n            if (obj.switchParams) {\n                scopeParams += obj.switchParams;\n            }\n\n            /**\n             * Reload function for switcher\n             */\n            function reload () {\n                var url;\n\n                if (!storeSwitchConfig.isUsingIframe) {\n\n                    if (storeSwitchConfig.switchUrl && storeSwitchConfig.switchUrl.length > 0) {\n                        url = storeSwitchConfig.switchUrl + scopeParams;\n\n                        /* eslint-disable no-undef */\n                        setLocation(url);\n                    }\n\n                } else {\n                    $('#preview_selected_store').val(scopeId);\n                    $('#preview_form').trigger('submit');\n\n                    $('.store-switcher .dropdown-menu li a').each(function () {\n                        var $this = $(this);\n\n                        if ($this.data('role') === 'store-view-id' && $this.data('value') === scopeId) {\n                            $('#store-change-button').html($this.text());\n                        }\n                    });\n\n                    $('#store-change-button').click();\n                }\n            }\n\n            if (typeof scopeSwitcherHandler !== 'undefined') {\n                switcherParams = {\n                    scopeId: scopeId,\n                    scopeParams: scopeParams,\n                    useConfirm: storeSwitchConfig.useConfirm\n                };\n\n                scopeSwitcherHandler(switcherParams);\n            } else if (storeSwitchConfig.useConfirm) {\n                require([\n                    'Magento_Ui/js/modal/confirm',\n                    'mage/translate'\n                ], function (confirm, $t) {\n                    confirm({\n                        content: $t('Please confirm scope switching. All data that hasn\\'t been saved will be lost.'),\n                        actions: {\n\n                            /**\n                             * Confirm action\n                             */\n                            confirm: function () {\n                                reload();\n                            },\n\n                            /**\n                             * Cancel action\n                             */\n                            cancel: function () {\n                                obj.value = storeSwitchConfig.storeId ? storeSwitchConfig.storeId : '';\n                            }\n                        }\n                    });\n                });\n            } else {\n                reload();\n            }\n        }\n\n        window.scopeSwitcherHandler = scopeSwitcherHandler;\n        window.switchScope          = switchScope;\n    };\n});\n","Mageplaza_Reports/js/dashboard/initGridStack.js":"/**\r\n * Mageplaza\r\n *\r\n * NOTICE OF LICENSE\r\n *\r\n * This source file is subject to the Mageplaza.com license that is\r\n * available through the world-wide-web at this URL:\r\n * https://www.mageplaza.com/LICENSE.txt\r\n *\r\n * DISCLAIMER\r\n *\r\n * Do not edit or add to this file if you wish to upgrade this extension to newer\r\n * version in the future.\r\n *\r\n * @category    Mageplaza\r\n * @package     Mageplaza_Reports\r\n * @copyright   Copyright (c) Mageplaza (https://www.mageplaza.com/)\r\n * @license     https://www.mageplaza.com/LICENSE.txt\r\n */\r\n\r\ndefine([\r\n    'jquery',\r\n    'underscore',\r\n    'Magento_Ui/js/modal/alert',\r\n    'gridstack',\r\n    'gridstackJqueryUi',\r\n    'touchPunch'\r\n], function ($, _, uiAlert) {\r\n    'use strict';\r\n\r\n    $.widget('mageplaza.initGridStack', {\r\n        options: {\r\n            url: '',\r\n            loadCardUrl: '',\r\n            gridWidget: []\r\n        },\r\n        _create: function () {\r\n            this.initGrid();\r\n            this.changeCardPositionObs();\r\n            this.toggleCardTable();\r\n            this.toggleCardVisible();\r\n            this.element.trigger('mpCardLoaded');\r\n        },\r\n        toggleCardTable: function () {\r\n            var cardsTableEl = $('.mp-ar-card.admin__action-dropdown-wrap.admin__data-grid-action-columns');\r\n\r\n            $('button#mp-ar-card').on('click', function () {\r\n                if (cardsTableEl.hasClass('_active')) {\r\n                    cardsTableEl.removeClass('_active');\r\n                } else {\r\n                    cardsTableEl.addClass('_active');\r\n                }\r\n            });\r\n            $('body').on('click', function (e) {\r\n                if (!$(e.target).parents().hasClass('mp-ar-card')) {\r\n                    cardsTableEl.removeClass('_active');\r\n                }\r\n            });\r\n        },\r\n        changeCardPositionObs: function () {\r\n            var self = this;\r\n            var gridStackEl = $('.grid-stack');\r\n\r\n            gridStackEl.on('change', function (event, items) {\r\n                var data = {};\r\n\r\n                if (items === undefined) {\r\n                    return;\r\n                }\r\n                _.each(items, function (item) {\r\n                    data[item.id] = {\r\n                        'x': item.x,\r\n                        'y': item.y,\r\n                        'width': item.width,\r\n                        'height': item.height\r\n                    };\r\n                });\r\n\r\n                self.saveCardPosition(data);\r\n            });\r\n        },\r\n        toggleCardVisible: function () {\r\n            var self = this;\r\n\r\n            $('.admin__action-dropdown-menu-content .admin__control-checkbox').each(function () {\r\n                $(this).change(function () {\r\n                    var cardId = $(this).attr('data-card-id'),\r\n                        cardEl = $('#' + cardId),\r\n                        card, dateRange,\r\n                        dateRangeEl = $('.ar_dashboard #daterange'),\r\n                        compareDateRangEl = $('.ar_dashboard #compare-daterange');\r\n\r\n                    if (cardEl.length < 1) {\r\n                        card = this;\r\n                        dateRange = [\r\n                            dateRangeEl.data('startDate').format('Y-MM-DD'),\r\n                            dateRangeEl.data('endDate').format('Y-MM-DD'),\r\n                        ];\r\n                        if (compareDateRangEl.length) {\r\n                            dateRange[2] = compareDateRangEl.data('startDate').format('Y-MM-DD');\r\n                            dateRange[3] = compareDateRangEl.data('endDate').format('Y-MM-DD');\r\n                        } else {\r\n                            dateRange[2] = dateRange[3] = null;\r\n                        }\r\n                        $.ajax({\r\n                            url: self.options.loadCardUrl,\r\n                            data: {card_id: cardId, dateRange: dateRange},\r\n                            showLoader: true,\r\n                            success: function (result) {\r\n                                if (cardEl.length < 1) {\r\n                                    if (result.html) {\r\n                                        $('.grid-stack').append(result.html);\r\n                                    } else {\r\n                                        uiAlert({\r\n                                            content: result.message\r\n                                        });\r\n                                        return;\r\n                                    }\r\n                                }\r\n                                self.changeCard(card, cardId);\r\n                                $('#' + cardId).trigger('contentUpdated');\r\n                            }\r\n                        });\r\n                    } else {\r\n                        self.changeCard(this, cardId);\r\n                    }\r\n                });\r\n            });\r\n        },\r\n        changeCard: function (card, cardId) {\r\n            var cardEl = $('#' + cardId),\r\n                data = {};\r\n\r\n            if (card.checked) {\r\n                cardEl.removeClass('hide');\r\n                this.options.grid.addWidget(cardEl);\r\n            } else {\r\n                this.options.grid.removeWidget(cardEl, 0);\r\n                cardEl.attr('data-gs-y', 100).attr('data-gs-x', 0);\r\n                cardEl.addClass('hide');\r\n            }\r\n            data[cardId] = {\r\n                'visible': card.checked ? 1 : 0,\r\n                'x': cardEl.attr('data-gs-x'),\r\n                'y': cardEl.attr('data-gs-y'),\r\n                'width': cardEl.attr('data-gs-width'),\r\n                'height': cardEl.attr('data-gs-height')\r\n            };\r\n            // save card position when show/hide card\r\n            this.saveCardPosition(data);\r\n        },\r\n        saveCardPosition: function (data) {\r\n            $.ajax({\r\n                url: this.options.url,\r\n                data: {items: data},\r\n                type: 'POST'\r\n            });\r\n        },\r\n        initGrid: function () {\r\n            var gridStackEl = $('.grid-stack');\r\n            var options = {\r\n                alwaysShowResizeHandle:\r\n                    /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent),\r\n                cellHeight: 30,\r\n                verticalMargin: 10,\r\n                draggable: {handle: '.draggable', scroll: true, appendTo: 'body'},\r\n            };\r\n\r\n            gridStackEl.gridstack(options);\r\n            this.options.grid = gridStackEl.data('gridstack');\r\n        }\r\n    });\r\n\r\n    return $.mageplaza.initGridStack;\r\n});\r\n","Mageplaza_Reports/js/dashboard/initChart.js":"/**\n * Mageplaza\n *\n * NOTICE OF LICENSE\n *\n * This source file is subject to the Mageplaza.com license that is\n * available through the world-wide-web at this URL:\n * https://www.mageplaza.com/LICENSE.txt\n *\n * DISCLAIMER\n *\n * Do not edit or add to this file if you wish to upgrade this extension to newer\n * version in the future.\n *\n * @category    Mageplaza\n * @package     Mageplaza_Reports\n * @copyright   Copyright (c) Mageplaza (https://www.mageplaza.com/)\n * @license     https://www.mageplaza.com/LICENSE.txt\n */\n\ndefine([\n    'jquery',\n    'Magento_Catalog/js/price-utils',\n    'chartBundle'\n], function ($, priceUtils) {\n    'use strict';\n    $.widget('mageplaza.initChart', {\n        options: {\n            chartData: {\n                yUnit: ''\n            }\n        },\n        _create: function () {\n            var ctx  = $('#' + this.options.chartData.name + '-chart'),\n                data = {\n                    type: 'line',\n                    data: this.getData(),\n                    options: this.getOptions()\n                };\n\n            new window.Chart(ctx, data);\n        },\n        getOptions: function () {\n            var self = this;\n\n            return {\n                fillColor: 'rgba(220,220,220,0.9)',\n                legend: {\n                    display: true,\n\n                    position: 'bottom',\n                    labels: {\n                        usePointStyle: true,\n                        fontColor: '#333'\n                    }\n                },\n                tooltips: {\n                    mode: 'index',\n                    intersect: true,\n                    callbacks: {\n                        label: function (tooltipItem, data) {\n                            var dataset = data.datasets[tooltipItem.datasetIndex],\n                                index   = tooltipItem.index;\n\n                            return dataset.labels[index] + ': ' +\n                                (data.yUnit\n                                    ? priceUtils.formatPrice(dataset.data[index], data.yUnit)\n                                    : dataset.data[index]);\n                        },\n                        title: function (tooltipItems, data) {\n                            if (data.index === 'repeatCustomerRate') {\n                                return tooltipItems[0].xLabel;\n                            }\n                            return '';\n                        }\n                    }\n                },\n                scales: {\n                    xAxes: [{\n                        display: true,\n                        labelString: 'Time',\n                        type: 'time',\n                        // distribution: 'series',\n                        time: {\n                            stepSize: this.options.chartData.stepSize,\n                            unit: 'day',\n                            displayFormats: {\n                                day: 'Y-M-D'\n                            }\n                        },\n                        ticks: {\n                            callback: function (label) {\n                                return label;\n                            }\n                        }\n                    }],\n                    yAxes: [{\n                        scaleStartValue: 0,\n                        scaleLabel: {\n                            display: true,\n                            labelUnit: this.options.chartData.yUnit,\n                            labelString: this.options.chartData.yLabel,\n                            scaleStepWidth: 1\n                        },\n                        ticks: {\n                            min: 0,\n                            // Include a currency sign in the ticks\n                            callback: function (value) {\n                                if (Math.floor(value) === value) {\n                                    return self.options.chartData.yUnit\n                                        ? priceUtils.formatPrice(value, self.options.chartData.yUnit)\n                                        : value;\n                                }\n                            }\n                        }\n                    }]\n                }\n            };\n        },\n        getData: function () {\n            var data           = {\n                index: this.options.chartData.name,\n                labels: this.options.chartData['labels'],\n                yUnit: this.options.chartData['yUnit'],\n                datasets: [\n                    {\n                        labels: this.options.chartData['data']['labels'],\n                        label: this.options.chartData['label'][0],\n                        data: this.options.chartData['data']['data'],\n                        backgroundColor: '#977bca',\n                        borderColor: '#6f42c1',\n                        borderWidth: 1,\n                        lineTension: 0.5, //cong\n                        pointBorderWidth: 1,\n                        pointBorderColor: 'transparent',\n                        fill: this.options.chartData.isFill\n                    }\n                ]\n            };\n            var compareDataset = this.getCompareDataSet();\n\n            if (this.options.chartData.isCompare === '1' || this.options.chartData.name === 'repeatCustomerRate') {\n                data.datasets.push(compareDataset);\n            }\n\n            return data;\n        },\n        getCompareDataSet: function () {\n            return {\n                labels: this.options.chartData['compareData']['labels'],\n                label: this.options.chartData['label'][1],\n                data: this.options.chartData['compareData']['data'],\n                backgroundColor: '#59a7b3',\n                borderColor: '#17a2b8',\n                borderWidth: 1,\n                lineTension: 0.5,\n                pointBorderColor: 'transparent',\n                // pointBackgroundColor: 'transparent',\n                // pointHoverBackgroundColor: 'blue',\n                fill: this.options.chartData.isFill\n            };\n        }\n    });\n\n    return $.mageplaza.initChart;\n});\n","Mageplaza_Reports/js/dashboard/initDateRange.js":"/**\r\n * Mageplaza\r\n *\r\n * NOTICE OF LICENSE\r\n *\r\n * This source file is subject to the Mageplaza.com license that is\r\n * available through the world-wide-web at this URL:\r\n * https://www.mageplaza.com/LICENSE.txt\r\n *\r\n * DISCLAIMER\r\n *\r\n * Do not edit or add to this file if you wish to upgrade this extension to newer\r\n * version in the future.\r\n *\r\n * @category    Mageplaza\r\n * @package     Mageplaza_Reports\r\n * @copyright   Copyright (c) Mageplaza (https://www.mageplaza.com/)\r\n * @license     https://www.mageplaza.com/LICENSE.txt\r\n */\r\n\r\ndefine([\r\n    'jquery',\r\n    'moment',\r\n    'daterangepicker'\r\n], function ($, moment) {\r\n    'use strict';\r\n\r\n    var dateRangeEl = $('#daterange'),\r\n        compareDateRangeEl = $('#compare-daterange'),\r\n        dashboardContainer = $('.dashboard-container');\r\n\r\n    $.widget('mageplaza.initDateRange', {\r\n        options: {\r\n            url: '',\r\n            isCompare: ''\r\n        },\r\n\r\n        _create: function () {\r\n            this.initNowDateRange();\r\n            if (this.options.isCompare) {\r\n                this.initCompareDateRange();\r\n                this.initNowDateRangeHideObserver();\r\n            }\r\n            this.initNowDateRangeObserver();\r\n        },\r\n\r\n        initDateRange: function (el, start, end, data) {\r\n            function cb(cbStart, cbEnd) {\r\n                el.find('span').html(cbStart.format('MMM DD, YYYY') + ' - ' + cbEnd.format('MMM DD, YYYY'));\r\n            }\r\n\r\n            el.daterangepicker(data, cb);\r\n            cb(start, end);\r\n        },\r\n\r\n        initNowDateRange: function () {\r\n            var start = moment(this.options.date[0]),\r\n                end = moment(this.options.date[1]),\r\n                dateRangeData = {\r\n                    startDate: start,\r\n                    endDate: end,\r\n                    ranges: {\r\n                        'Today': [moment(), moment()],\r\n                        'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],\r\n                        'Last 7 Days': [moment().subtract(6, 'days'), moment()],\r\n                        'Last 30 Days': [moment().subtract(29, 'days'), moment()],\r\n                        'This Month': [moment().startOf('month'), moment().endOf('month')],\r\n                        'Last Month': [\r\n                            moment().subtract(1, 'month').startOf('month'),\r\n                            moment().subtract(1, 'month').endOf('month')\r\n                        ],\r\n                        'YTD': [moment().subtract(1, 'year'), moment()],\r\n                        '2YTD': [moment().subtract(2, 'year'), moment()]\r\n                    }\r\n                };\r\n\r\n            this.initDateRange(dateRangeEl, start, end, dateRangeData);\r\n        },\r\n\r\n        initCompareDateRange: function (initStartDate, initEndDate) {\r\n            var self = this,\r\n                startDate = initStartDate || dateRangeEl.data().startDate,\r\n                endDate = initEndDate || dateRangeEl.data().endDate,\r\n                days = endDate.diff(startDate, 'days'),\r\n                compareEndDate = moment(startDate.format('Y-MM-DD')).subtract(1, 'days'),\r\n                compareStartDate = moment(compareEndDate.format('Y-MM-DD')).subtract(days, 'days').endOf('days'),\r\n                compareDateRangeData = {\r\n                    startDate: compareStartDate,\r\n                    endDate: compareEndDate,\r\n                    ranges: {\r\n                        'Previous period': [compareStartDate, compareEndDate],\r\n                        'Previous year': [\r\n                            moment(startDate.format('Y-MM-DD')).subtract(1, 'year'),\r\n                            moment(endDate.format('Y-MM-DD')).subtract(1, 'year')\r\n                        ]\r\n                    }\r\n                };\r\n\r\n            this.initDateRange(compareDateRangeEl, compareStartDate, compareEndDate, compareDateRangeData);\r\n\r\n            compareDateRangeEl.on('apply.daterangepicker', function (ev, picker) {\r\n                compareDateRangeEl.data().startDate = picker.startDate;\r\n                compareDateRangeEl.data().endDate = picker.endDate;\r\n                var data = {\r\n                    dateRange: {\r\n                        0: dateRangeEl.data().startDate.format('Y-MM-DD H:m:s'),\r\n                        1: dateRangeEl.data().endDate.format('Y-MM-DD H:m:s'),\r\n                        2: picker.startDate.format('Y-MM-DD H:m:s'),\r\n                        3: picker.endDate.format('Y-MM-DD H:m:s')\r\n                    }\r\n                };\r\n\r\n                self.ajaxSubmit(data);\r\n            });\r\n        },\r\n\r\n        ajaxSubmit: function (data) {\r\n            $.ajax({\r\n                url: this.options.url,\r\n                data: data,\r\n                type: 'POST',\r\n                showLoader: true,\r\n                success: function (res) {\r\n                    var dashboard = $('<div>' + res.dashboard + '</div>').find('.dashboard-container');\r\n\r\n                    dashboardContainer.html(dashboard.html());\r\n                    dashboardContainer.trigger('contentUpdated');\r\n                },\r\n            });\r\n        },\r\n\r\n        initNowDateRangeObserver: function () {\r\n            var self = this;\r\n\r\n            dateRangeEl.on('apply.daterangepicker', function (ev, picker) {\r\n                var data;\r\n\r\n                dateRangeEl.data().startDate = picker.startDate;\r\n                dateRangeEl.data().endDate = picker.endDate;\r\n                data = {\r\n                    dateRange: {\r\n                        0: picker.startDate.format('Y-MM-DD H:m:s'),\r\n                        1: picker.endDate.format('Y-MM-DD H:m:s'),\r\n                        2: self.options.isCompare ? compareDateRangeEl.data().startDate.format('Y-MM-DD H:m:s') : null,\r\n                        3: self.options.isCompare ? compareDateRangeEl.data().endDate.format('Y-MM-DD H:m:s') : null\r\n                    }\r\n                };\r\n\r\n                self.ajaxSubmit(data);\r\n            });\r\n        },\r\n\r\n        initNowDateRangeHideObserver: function () {\r\n            var self = this;\r\n\r\n            dateRangeEl.on('hide.daterangepicker', function (ev, picker) {\r\n                self.initCompareDateRange(picker.startDate, picker.endDate);\r\n            });\r\n        }\r\n    });\r\n\r\n    return $.mageplaza.initDateRange;\r\n});\r\n","Mageplaza_Reports/js/lib/gridstack.jQueryUI.js":"/**\r\n * gridstack.js 1.0.0-dev\r\n * http://troolee.github.io/gridstack.js/\r\n * (c) 2014-2017 Pavel Reznikov, Dylan Weiss\r\n * gridstack.js may be freely distributed under the MIT license.\r\n * @preserve\r\n */\r\n(function(factory) {\r\n    if (typeof define === 'function' && define.amd) {\r\n        define(['jquery', 'lodash', 'gridstack', 'jquery/ui'], factory);\r\n    } else if (typeof exports !== 'undefined') {\r\n        try { jQuery = require('jquery'); } catch (e) {}\r\n        try { _ = require('lodash'); } catch (e) {}\r\n        try { GridStackUI = require('gridstack'); } catch (e) {}\r\n        factory(jQuery, _, GridStackUI);\r\n    } else {\r\n        factory(jQuery, _, GridStackUI);\r\n    }\r\n})(function($, _, GridStackUI) {\r\n\r\n    var scope = window;\r\n\r\n    /**\r\n     * @class JQueryUIGridStackDragDropPlugin\r\n     * jQuery UI implementation of drag'n'drop gridstack plugin.\r\n     */\r\n    function JQueryUIGridStackDragDropPlugin(grid) {\r\n        GridStackUI.GridStackDragDropPlugin.call(this, grid);\r\n    }\r\n\r\n    GridStackUI.GridStackDragDropPlugin.registerPlugin(JQueryUIGridStackDragDropPlugin);\r\n\r\n    JQueryUIGridStackDragDropPlugin.prototype = Object.create(GridStackUI.GridStackDragDropPlugin.prototype);\r\n    JQueryUIGridStackDragDropPlugin.prototype.constructor = JQueryUIGridStackDragDropPlugin;\r\n\r\n    JQueryUIGridStackDragDropPlugin.prototype.resizable = function(el, opts) {\r\n        el = $(el);\r\n        if (opts === 'disable' || opts === 'enable') {\r\n            el.resizable(opts);\r\n        } else if (opts === 'option') {\r\n            var key = arguments[2];\r\n            var value = arguments[3];\r\n            el.resizable(opts, key, value);\r\n        } else {\r\n            var handles = el.data('gs-resize-handles') ? el.data('gs-resize-handles') :\r\n                this.grid.opts.resizable.handles;\r\n            el.resizable(_.extend({}, this.grid.opts.resizable, {\r\n                handles: handles\r\n            }, {\r\n                start: opts.start || function() {},\r\n                stop: opts.stop || function() {},\r\n                resize: opts.resize || function() {}\r\n            }));\r\n        }\r\n        return this;\r\n    };\r\n\r\n    JQueryUIGridStackDragDropPlugin.prototype.draggable = function(el, opts) {\r\n        el = $(el);\r\n        if (opts === 'disable' || opts === 'enable') {\r\n            el.draggable(opts);\r\n        } else {\r\n            el.draggable(_.extend({}, this.grid.opts.draggable, {\r\n                containment: this.grid.opts.isNested ? this.grid.container.parent() : null,\r\n                start: opts.start || function() {},\r\n                stop: opts.stop || function() {},\r\n                drag: opts.drag || function() {}\r\n            }));\r\n        }\r\n        return this;\r\n    };\r\n\r\n    JQueryUIGridStackDragDropPlugin.prototype.droppable = function(el, opts) {\r\n        el = $(el);\r\n        el.droppable(opts);\r\n        return this;\r\n    };\r\n\r\n    JQueryUIGridStackDragDropPlugin.prototype.isDroppable = function(el, opts) {\r\n        el = $(el);\r\n        return Boolean(el.data('droppable'));\r\n    };\r\n\r\n    JQueryUIGridStackDragDropPlugin.prototype.on = function(el, eventName, callback) {\r\n        $(el).on(eventName, callback);\r\n        return this;\r\n    };\r\n\r\n    return JQueryUIGridStackDragDropPlugin;\r\n});","Mageplaza_Reports/js/lib/Chart.bundle.min.js":"/*!\r\n * Chart.js\r\n * http://chartjs.org/\r\n * Version: 2.7.2\r\n *\r\n * Copyright 2018 Chart.js Contributors\r\n * Released under the MIT license\r\n * https://github.com/chartjs/Chart.js/blob/master/LICENSE.md\r\n */\r\n!function(t){if(\"object\"==typeof exports&&\"undefined\"!=typeof module)module.exports=t();else if(\"function\"==typeof define&&define.amd)define([],t);else{(\"undefined\"!=typeof window?window:\"undefined\"!=typeof global?global:\"undefined\"!=typeof self?self:this).Chart=t()}}(function(){return function t(e,i,n){function a(o,s){if(!i[o]){if(!e[o]){var l=\"function\"==typeof require&&require;if(!s&&l)return l(o,!0);if(r)return r(o,!0);var u=new Error(\"Cannot find module '\"+o+\"'\");throw u.code=\"MODULE_NOT_FOUND\",u}var d=i[o]={exports:{}};e[o][0].call(d.exports,function(t){var i=e[o][1][t];return a(i||t)},d,d.exports,t,e,i,n)}return i[o].exports}for(var r=\"function\"==typeof require&&require,o=0;o<n.length;o++)a(n[o]);return a}({1:[function(t,e,i){var n=t(5);function a(t){if(t){var e=[0,0,0],i=1,a=t.match(/^#([a-fA-F0-9]{3})$/i);if(a){a=a[1];for(var r=0;r<e.length;r++)e[r]=parseInt(a[r]+a[r],16)}else if(a=t.match(/^#([a-fA-F0-9]{6})$/i)){a=a[1];for(r=0;r<e.length;r++)e[r]=parseInt(a.slice(2*r,2*r+2),16)}else if(a=t.match(/^rgba?\\(\\s*([+-]?\\d+)\\s*,\\s*([+-]?\\d+)\\s*,\\s*([+-]?\\d+)\\s*(?:,\\s*([+-]?[\\d\\.]+)\\s*)?\\)$/i)){for(r=0;r<e.length;r++)e[r]=parseInt(a[r+1]);i=parseFloat(a[4])}else if(a=t.match(/^rgba?\\(\\s*([+-]?[\\d\\.]+)\\%\\s*,\\s*([+-]?[\\d\\.]+)\\%\\s*,\\s*([+-]?[\\d\\.]+)\\%\\s*(?:,\\s*([+-]?[\\d\\.]+)\\s*)?\\)$/i)){for(r=0;r<e.length;r++)e[r]=Math.round(2.55*parseFloat(a[r+1]));i=parseFloat(a[4])}else if(a=t.match(/(\\w+)/)){if(\"transparent\"==a[1])return[0,0,0,0];if(!(e=n[a[1]]))return}for(r=0;r<e.length;r++)e[r]=d(e[r],0,255);return i=i||0==i?d(i,0,1):1,e[3]=i,e}}function r(t){if(t){var e=t.match(/^hsla?\\(\\s*([+-]?\\d+)(?:deg)?\\s*,\\s*([+-]?[\\d\\.]+)%\\s*,\\s*([+-]?[\\d\\.]+)%\\s*(?:,\\s*([+-]?[\\d\\.]+)\\s*)?\\)/);if(e){var i=parseFloat(e[4]);return[d(parseInt(e[1]),0,360),d(parseFloat(e[2]),0,100),d(parseFloat(e[3]),0,100),d(isNaN(i)?1:i,0,1)]}}}function o(t){if(t){var e=t.match(/^hwb\\(\\s*([+-]?\\d+)(?:deg)?\\s*,\\s*([+-]?[\\d\\.]+)%\\s*,\\s*([+-]?[\\d\\.]+)%\\s*(?:,\\s*([+-]?[\\d\\.]+)\\s*)?\\)/);if(e){var i=parseFloat(e[4]);return[d(parseInt(e[1]),0,360),d(parseFloat(e[2]),0,100),d(parseFloat(e[3]),0,100),d(isNaN(i)?1:i,0,1)]}}}function s(t,e){return void 0===e&&(e=void 0!==t[3]?t[3]:1),\"rgba(\"+t[0]+\", \"+t[1]+\", \"+t[2]+\", \"+e+\")\"}function l(t,e){return\"rgba(\"+Math.round(t[0]/255*100)+\"%, \"+Math.round(t[1]/255*100)+\"%, \"+Math.round(t[2]/255*100)+\"%, \"+(e||t[3]||1)+\")\"}function u(t,e){return void 0===e&&(e=void 0!==t[3]?t[3]:1),\"hsla(\"+t[0]+\", \"+t[1]+\"%, \"+t[2]+\"%, \"+e+\")\"}function d(t,e,i){return Math.min(Math.max(e,t),i)}function h(t){var e=t.toString(16).toUpperCase();return e.length<2?\"0\"+e:e}e.exports={getRgba:a,getHsla:r,getRgb:function(t){var e=a(t);return e&&e.slice(0,3)},getHsl:function(t){var e=r(t);return e&&e.slice(0,3)},getHwb:o,getAlpha:function(t){var e=a(t);{if(e)return e[3];if(e=r(t))return e[3];if(e=o(t))return e[3]}},hexString:function(t){return\"#\"+h(t[0])+h(t[1])+h(t[2])},rgbString:function(t,e){if(e<1||t[3]&&t[3]<1)return s(t,e);return\"rgb(\"+t[0]+\", \"+t[1]+\", \"+t[2]+\")\"},rgbaString:s,percentString:function(t,e){if(e<1||t[3]&&t[3]<1)return l(t,e);var i=Math.round(t[0]/255*100),n=Math.round(t[1]/255*100),a=Math.round(t[2]/255*100);return\"rgb(\"+i+\"%, \"+n+\"%, \"+a+\"%)\"},percentaString:l,hslString:function(t,e){if(e<1||t[3]&&t[3]<1)return u(t,e);return\"hsl(\"+t[0]+\", \"+t[1]+\"%, \"+t[2]+\"%)\"},hslaString:u,hwbString:function(t,e){void 0===e&&(e=void 0!==t[3]?t[3]:1);return\"hwb(\"+t[0]+\", \"+t[1]+\"%, \"+t[2]+\"%\"+(void 0!==e&&1!==e?\", \"+e:\"\")+\")\"},keyword:function(t){return c[t.slice(0,3)]}};var c={};for(var f in n)c[n[f]]=f},{5:5}],2:[function(t,e,i){var n=t(4),a=t(1),r=function(t){return t instanceof r?t:this instanceof r?(this.valid=!1,this.values={rgb:[0,0,0],hsl:[0,0,0],hsv:[0,0,0],hwb:[0,0,0],cmyk:[0,0,0,0],alpha:1},void(\"string\"==typeof t?(e=a.getRgba(t))?this.setValues(\"rgb\",e):(e=a.getHsla(t))?this.setValues(\"hsl\",e):(e=a.getHwb(t))&&this.setValues(\"hwb\",e):\"object\"==typeof t&&(void 0!==(e=t).r||void 0!==e.red?this.setValues(\"rgb\",e):void 0!==e.l||void 0!==e.lightness?this.setValues(\"hsl\",e):void 0!==e.v||void 0!==e.value?this.setValues(\"hsv\",e):void 0!==e.w||void 0!==e.whiteness?this.setValues(\"hwb\",e):void 0===e.c&&void 0===e.cyan||this.setValues(\"cmyk\",e)))):new r(t);var e};r.prototype={isValid:function(){return this.valid},rgb:function(){return this.setSpace(\"rgb\",arguments)},hsl:function(){return this.setSpace(\"hsl\",arguments)},hsv:function(){return this.setSpace(\"hsv\",arguments)},hwb:function(){return this.setSpace(\"hwb\",arguments)},cmyk:function(){return this.setSpace(\"cmyk\",arguments)},rgbArray:function(){return this.values.rgb},hslArray:function(){return this.values.hsl},hsvArray:function(){return this.values.hsv},hwbArray:function(){var t=this.values;return 1!==t.alpha?t.hwb.concat([t.alpha]):t.hwb},cmykArray:function(){return this.values.cmyk},rgbaArray:function(){var t=this.values;return t.rgb.concat([t.alpha])},hslaArray:function(){var t=this.values;return t.hsl.concat([t.alpha])},alpha:function(t){return void 0===t?this.values.alpha:(this.setValues(\"alpha\",t),this)},red:function(t){return this.setChannel(\"rgb\",0,t)},green:function(t){return this.setChannel(\"rgb\",1,t)},blue:function(t){return this.setChannel(\"rgb\",2,t)},hue:function(t){return t&&(t=(t%=360)<0?360+t:t),this.setChannel(\"hsl\",0,t)},saturation:function(t){return this.setChannel(\"hsl\",1,t)},lightness:function(t){return this.setChannel(\"hsl\",2,t)},saturationv:function(t){return this.setChannel(\"hsv\",1,t)},whiteness:function(t){return this.setChannel(\"hwb\",1,t)},blackness:function(t){return this.setChannel(\"hwb\",2,t)},value:function(t){return this.setChannel(\"hsv\",2,t)},cyan:function(t){return this.setChannel(\"cmyk\",0,t)},magenta:function(t){return this.setChannel(\"cmyk\",1,t)},yellow:function(t){return this.setChannel(\"cmyk\",2,t)},black:function(t){return this.setChannel(\"cmyk\",3,t)},hexString:function(){return a.hexString(this.values.rgb)},rgbString:function(){return a.rgbString(this.values.rgb,this.values.alpha)},rgbaString:function(){return a.rgbaString(this.values.rgb,this.values.alpha)},percentString:function(){return a.percentString(this.values.rgb,this.values.alpha)},hslString:function(){return a.hslString(this.values.hsl,this.values.alpha)},hslaString:function(){return a.hslaString(this.values.hsl,this.values.alpha)},hwbString:function(){return a.hwbString(this.values.hwb,this.values.alpha)},keyword:function(){return a.keyword(this.values.rgb,this.values.alpha)},rgbNumber:function(){var t=this.values.rgb;return t[0]<<16|t[1]<<8|t[2]},luminosity:function(){for(var t=this.values.rgb,e=[],i=0;i<t.length;i++){var n=t[i]/255;e[i]=n<=.03928?n/12.92:Math.pow((n+.055)/1.055,2.4)}return.2126*e[0]+.7152*e[1]+.0722*e[2]},contrast:function(t){var e=this.luminosity(),i=t.luminosity();return e>i?(e+.05)/(i+.05):(i+.05)/(e+.05)},level:function(t){var e=this.contrast(t);return e>=7.1?\"AAA\":e>=4.5?\"AA\":\"\"},dark:function(){var t=this.values.rgb;return(299*t[0]+587*t[1]+114*t[2])/1e3<128},light:function(){return!this.dark()},negate:function(){for(var t=[],e=0;e<3;e++)t[e]=255-this.values.rgb[e];return this.setValues(\"rgb\",t),this},lighten:function(t){var e=this.values.hsl;return e[2]+=e[2]*t,this.setValues(\"hsl\",e),this},darken:function(t){var e=this.values.hsl;return e[2]-=e[2]*t,this.setValues(\"hsl\",e),this},saturate:function(t){var e=this.values.hsl;return e[1]+=e[1]*t,this.setValues(\"hsl\",e),this},desaturate:function(t){var e=this.values.hsl;return e[1]-=e[1]*t,this.setValues(\"hsl\",e),this},whiten:function(t){var e=this.values.hwb;return e[1]+=e[1]*t,this.setValues(\"hwb\",e),this},blacken:function(t){var e=this.values.hwb;return e[2]+=e[2]*t,this.setValues(\"hwb\",e),this},greyscale:function(){var t=this.values.rgb,e=.3*t[0]+.59*t[1]+.11*t[2];return this.setValues(\"rgb\",[e,e,e]),this},clearer:function(t){var e=this.values.alpha;return this.setValues(\"alpha\",e-e*t),this},opaquer:function(t){var e=this.values.alpha;return this.setValues(\"alpha\",e+e*t),this},rotate:function(t){var e=this.values.hsl,i=(e[0]+t)%360;return e[0]=i<0?360+i:i,this.setValues(\"hsl\",e),this},mix:function(t,e){var i=this,n=t,a=void 0===e?.5:e,r=2*a-1,o=i.alpha()-n.alpha(),s=((r*o==-1?r:(r+o)/(1+r*o))+1)/2,l=1-s;return this.rgb(s*i.red()+l*n.red(),s*i.green()+l*n.green(),s*i.blue()+l*n.blue()).alpha(i.alpha()*a+n.alpha()*(1-a))},toJSON:function(){return this.rgb()},clone:function(){var t,e,i=new r,n=this.values,a=i.values;for(var o in n)n.hasOwnProperty(o)&&(t=n[o],\"[object Array]\"===(e={}.toString.call(t))?a[o]=t.slice(0):\"[object Number]\"===e?a[o]=t:console.error(\"unexpected color value:\",t));return i}},r.prototype.spaces={rgb:[\"red\",\"green\",\"blue\"],hsl:[\"hue\",\"saturation\",\"lightness\"],hsv:[\"hue\",\"saturation\",\"value\"],hwb:[\"hue\",\"whiteness\",\"blackness\"],cmyk:[\"cyan\",\"magenta\",\"yellow\",\"black\"]},r.prototype.maxes={rgb:[255,255,255],hsl:[360,100,100],hsv:[360,100,100],hwb:[360,100,100],cmyk:[100,100,100,100]},r.prototype.getValues=function(t){for(var e=this.values,i={},n=0;n<t.length;n++)i[t.charAt(n)]=e[t][n];return 1!==e.alpha&&(i.a=e.alpha),i},r.prototype.setValues=function(t,e){var i,a,r=this.values,o=this.spaces,s=this.maxes,l=1;if(this.valid=!0,\"alpha\"===t)l=e;else if(e.length)r[t]=e.slice(0,t.length),l=e[t.length];else if(void 0!==e[t.charAt(0)]){for(i=0;i<t.length;i++)r[t][i]=e[t.charAt(i)];l=e.a}else if(void 0!==e[o[t][0]]){var u=o[t];for(i=0;i<t.length;i++)r[t][i]=e[u[i]];l=e.alpha}if(r.alpha=Math.max(0,Math.min(1,void 0===l?r.alpha:l)),\"alpha\"===t)return!1;for(i=0;i<t.length;i++)a=Math.max(0,Math.min(s[t][i],r[t][i])),r[t][i]=Math.round(a);for(var d in o)d!==t&&(r[d]=n[t][d](r[t]));return!0},r.prototype.setSpace=function(t,e){var i=e[0];return void 0===i?this.getValues(t):(\"number\"==typeof i&&(i=Array.prototype.slice.call(e)),this.setValues(t,i),this)},r.prototype.setChannel=function(t,e,i){var n=this.values[t];return void 0===i?n[e]:i===n[e]?this:(n[e]=i,this.setValues(t,n),this)},\"undefined\"!=typeof window&&(window.Color=r),e.exports=r},{1:1,4:4}],3:[function(t,e,i){function n(t){var e,i,n=t[0]/255,a=t[1]/255,r=t[2]/255,o=Math.min(n,a,r),s=Math.max(n,a,r),l=s-o;return s==o?e=0:n==s?e=(a-r)/l:a==s?e=2+(r-n)/l:r==s&&(e=4+(n-a)/l),(e=Math.min(60*e,360))<0&&(e+=360),i=(o+s)/2,[e,100*(s==o?0:i<=.5?l/(s+o):l/(2-s-o)),100*i]}function a(t){var e,i,n=t[0],a=t[1],r=t[2],o=Math.min(n,a,r),s=Math.max(n,a,r),l=s-o;return i=0==s?0:l/s*1e3/10,s==o?e=0:n==s?e=(a-r)/l:a==s?e=2+(r-n)/l:r==s&&(e=4+(n-a)/l),(e=Math.min(60*e,360))<0&&(e+=360),[e,i,s/255*1e3/10]}function o(t){var e=t[0],i=t[1],a=t[2];return[n(t)[0],100*(1/255*Math.min(e,Math.min(i,a))),100*(a=1-1/255*Math.max(e,Math.max(i,a)))]}function s(t){var e,i=t[0]/255,n=t[1]/255,a=t[2]/255;return[100*((1-i-(e=Math.min(1-i,1-n,1-a)))/(1-e)||0),100*((1-n-e)/(1-e)||0),100*((1-a-e)/(1-e)||0),100*e]}function l(t){return S[JSON.stringify(t)]}function u(t){var e=t[0]/255,i=t[1]/255,n=t[2]/255;return[100*(.4124*(e=e>.04045?Math.pow((e+.055)/1.055,2.4):e/12.92)+.3576*(i=i>.04045?Math.pow((i+.055)/1.055,2.4):i/12.92)+.1805*(n=n>.04045?Math.pow((n+.055)/1.055,2.4):n/12.92)),100*(.2126*e+.7152*i+.0722*n),100*(.0193*e+.1192*i+.9505*n)]}function d(t){var e=u(t),i=e[0],n=e[1],a=e[2];return n/=100,a/=108.883,i=(i/=95.047)>.008856?Math.pow(i,1/3):7.787*i+16/116,[116*(n=n>.008856?Math.pow(n,1/3):7.787*n+16/116)-16,500*(i-n),200*(n-(a=a>.008856?Math.pow(a,1/3):7.787*a+16/116))]}function h(t){var e,i,n,a,r,o=t[0]/360,s=t[1]/100,l=t[2]/100;if(0==s)return[r=255*l,r,r];e=2*l-(i=l<.5?l*(1+s):l+s-l*s),a=[0,0,0];for(var u=0;u<3;u++)(n=o+1/3*-(u-1))<0&&n++,n>1&&n--,r=6*n<1?e+6*(i-e)*n:2*n<1?i:3*n<2?e+(i-e)*(2/3-n)*6:e,a[u]=255*r;return a}function c(t){var e=t[0]/60,i=t[1]/100,n=t[2]/100,a=Math.floor(e)%6,r=e-Math.floor(e),o=255*n*(1-i),s=255*n*(1-i*r),l=255*n*(1-i*(1-r));n*=255;switch(a){case 0:return[n,l,o];case 1:return[s,n,o];case 2:return[o,n,l];case 3:return[o,s,n];case 4:return[l,o,n];case 5:return[n,o,s]}}function f(t){var e,i,n,a,o=t[0]/360,s=t[1]/100,l=t[2]/100,u=s+l;switch(u>1&&(s/=u,l/=u),n=6*o-(e=Math.floor(6*o)),0!=(1&e)&&(n=1-n),a=s+n*((i=1-l)-s),e){default:case 6:case 0:r=i,g=a,b=s;break;case 1:r=a,g=i,b=s;break;case 2:r=s,g=i,b=a;break;case 3:r=s,g=a,b=i;break;case 4:r=a,g=s,b=i;break;case 5:r=i,g=s,b=a}return[255*r,255*g,255*b]}function m(t){var e=t[0]/100,i=t[1]/100,n=t[2]/100,a=t[3]/100;return[255*(1-Math.min(1,e*(1-a)+a)),255*(1-Math.min(1,i*(1-a)+a)),255*(1-Math.min(1,n*(1-a)+a))]}function p(t){var e,i,n,a=t[0]/100,r=t[1]/100,o=t[2]/100;return i=-.9689*a+1.8758*r+.0415*o,n=.0557*a+-.204*r+1.057*o,e=(e=3.2406*a+-1.5372*r+-.4986*o)>.0031308?1.055*Math.pow(e,1/2.4)-.055:e*=12.92,i=i>.0031308?1.055*Math.pow(i,1/2.4)-.055:i*=12.92,n=n>.0031308?1.055*Math.pow(n,1/2.4)-.055:n*=12.92,[255*(e=Math.min(Math.max(0,e),1)),255*(i=Math.min(Math.max(0,i),1)),255*(n=Math.min(Math.max(0,n),1))]}function v(t){var e=t[0],i=t[1],n=t[2];return i/=100,n/=108.883,e=(e/=95.047)>.008856?Math.pow(e,1/3):7.787*e+16/116,[116*(i=i>.008856?Math.pow(i,1/3):7.787*i+16/116)-16,500*(e-i),200*(i-(n=n>.008856?Math.pow(n,1/3):7.787*n+16/116))]}function y(t){var e,i,n,a,r=t[0],o=t[1],s=t[2];return r<=8?a=(i=100*r/903.3)/100*7.787+16/116:(i=100*Math.pow((r+16)/116,3),a=Math.pow(i/100,1/3)),[e=e/95.047<=.008856?e=95.047*(o/500+a-16/116)/7.787:95.047*Math.pow(o/500+a,3),i,n=n/108.883<=.008859?n=108.883*(a-s/200-16/116)/7.787:108.883*Math.pow(a-s/200,3)]}function x(t){var e,i=t[0],n=t[1],a=t[2];return(e=360*Math.atan2(a,n)/2/Math.PI)<0&&(e+=360),[i,Math.sqrt(n*n+a*a),e]}function _(t){return p(y(t))}function k(t){var e,i=t[0],n=t[1];return e=t[2]/360*2*Math.PI,[i,n*Math.cos(e),n*Math.sin(e)]}function w(t){return M[t]}e.exports={rgb2hsl:n,rgb2hsv:a,rgb2hwb:o,rgb2cmyk:s,rgb2keyword:l,rgb2xyz:u,rgb2lab:d,rgb2lch:function(t){return x(d(t))},hsl2rgb:h,hsl2hsv:function(t){var e=t[0],i=t[1]/100,n=t[2]/100;if(0===n)return[0,0,0];return[e,100*(2*(i*=(n*=2)<=1?n:2-n)/(n+i)),100*((n+i)/2)]},hsl2hwb:function(t){return o(h(t))},hsl2cmyk:function(t){return s(h(t))},hsl2keyword:function(t){return l(h(t))},hsv2rgb:c,hsv2hsl:function(t){var e,i,n=t[0],a=t[1]/100,r=t[2]/100;return e=a*r,[n,100*(e=(e/=(i=(2-a)*r)<=1?i:2-i)||0),100*(i/=2)]},hsv2hwb:function(t){return o(c(t))},hsv2cmyk:function(t){return s(c(t))},hsv2keyword:function(t){return l(c(t))},hwb2rgb:f,hwb2hsl:function(t){return n(f(t))},hwb2hsv:function(t){return a(f(t))},hwb2cmyk:function(t){return s(f(t))},hwb2keyword:function(t){return l(f(t))},cmyk2rgb:m,cmyk2hsl:function(t){return n(m(t))},cmyk2hsv:function(t){return a(m(t))},cmyk2hwb:function(t){return o(m(t))},cmyk2keyword:function(t){return l(m(t))},keyword2rgb:w,keyword2hsl:function(t){return n(w(t))},keyword2hsv:function(t){return a(w(t))},keyword2hwb:function(t){return o(w(t))},keyword2cmyk:function(t){return s(w(t))},keyword2lab:function(t){return d(w(t))},keyword2xyz:function(t){return u(w(t))},xyz2rgb:p,xyz2lab:v,xyz2lch:function(t){return x(v(t))},lab2xyz:y,lab2rgb:_,lab2lch:x,lch2lab:k,lch2xyz:function(t){return y(k(t))},lch2rgb:function(t){return _(k(t))}};var M={aliceblue:[240,248,255],antiquewhite:[250,235,215],aqua:[0,255,255],aquamarine:[127,255,212],azure:[240,255,255],beige:[245,245,220],bisque:[255,228,196],black:[0,0,0],blanchedalmond:[255,235,205],blue:[0,0,255],blueviolet:[138,43,226],brown:[165,42,42],burlywood:[222,184,135],cadetblue:[95,158,160],chartreuse:[127,255,0],chocolate:[210,105,30],coral:[255,127,80],cornflowerblue:[100,149,237],cornsilk:[255,248,220],crimson:[220,20,60],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgoldenrod:[184,134,11],darkgray:[169,169,169],darkgreen:[0,100,0],darkgrey:[169,169,169],darkkhaki:[189,183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,150,122],darkseagreen:[143,188,143],darkslateblue:[72,61,139],darkslategray:[47,79,79],darkslategrey:[47,79,79],darkturquoise:[0,206,209],darkviolet:[148,0,211],deeppink:[255,20,147],deepskyblue:[0,191,255],dimgray:[105,105,105],dimgrey:[105,105,105],dodgerblue:[30,144,255],firebrick:[178,34,34],floralwhite:[255,250,240],forestgreen:[34,139,34],fuchsia:[255,0,255],gainsboro:[220,220,220],ghostwhite:[248,248,255],gold:[255,215,0],goldenrod:[218,165,32],gray:[128,128,128],green:[0,128,0],greenyellow:[173,255,47],grey:[128,128,128],honeydew:[240,255,240],hotpink:[255,105,180],indianred:[205,92,92],indigo:[75,0,130],ivory:[255,255,240],khaki:[240,230,140],lavender:[230,230,250],lavenderblush:[255,240,245],lawngreen:[124,252,0],lemonchiffon:[255,250,205],lightblue:[173,216,230],lightcoral:[240,128,128],lightcyan:[224,255,255],lightgoldenrodyellow:[250,250,210],lightgray:[211,211,211],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,182,193],lightsalmon:[255,160,122],lightseagreen:[32,178,170],lightskyblue:[135,206,250],lightslategray:[119,136,153],lightslategrey:[119,136,153],lightsteelblue:[176,196,222],lightyellow:[255,255,224],lime:[0,255,0],limegreen:[50,205,50],linen:[250,240,230],magenta:[255,0,255],maroon:[128,0,0],mediumaquamarine:[102,205,170],mediumblue:[0,0,205],mediumorchid:[186,85,211],mediumpurple:[147,112,219],mediumseagreen:[60,179,113],mediumslateblue:[123,104,238],mediumspringgreen:[0,250,154],mediumturquoise:[72,209,204],mediumvioletred:[199,21,133],midnightblue:[25,25,112],mintcream:[245,255,250],mistyrose:[255,228,225],moccasin:[255,228,181],navajowhite:[255,222,173],navy:[0,0,128],oldlace:[253,245,230],olive:[128,128,0],olivedrab:[107,142,35],orange:[255,165,0],orangered:[255,69,0],orchid:[218,112,214],palegoldenrod:[238,232,170],palegreen:[152,251,152],paleturquoise:[175,238,238],palevioletred:[219,112,147],papayawhip:[255,239,213],peachpuff:[255,218,185],peru:[205,133,63],pink:[255,192,203],plum:[221,160,221],powderblue:[176,224,230],purple:[128,0,128],rebeccapurple:[102,51,153],red:[255,0,0],rosybrown:[188,143,143],royalblue:[65,105,225],saddlebrown:[139,69,19],salmon:[250,128,114],sandybrown:[244,164,96],seagreen:[46,139,87],seashell:[255,245,238],sienna:[160,82,45],silver:[192,192,192],skyblue:[135,206,235],slateblue:[106,90,205],slategray:[112,128,144],slategrey:[112,128,144],snow:[255,250,250],springgreen:[0,255,127],steelblue:[70,130,180],tan:[210,180,140],teal:[0,128,128],thistle:[216,191,216],tomato:[255,99,71],turquoise:[64,224,208],violet:[238,130,238],wheat:[245,222,179],white:[255,255,255],whitesmoke:[245,245,245],yellow:[255,255,0],yellowgreen:[154,205,50]},S={};for(var D in M)S[JSON.stringify(M[D])]=D},{}],4:[function(t,e,i){var n=t(3),a=function(){return new u};for(var r in n){a[r+\"Raw\"]=function(t){return function(e){return\"number\"==typeof e&&(e=Array.prototype.slice.call(arguments)),n[t](e)}}(r);var o=/(\\w+)2(\\w+)/.exec(r),s=o[1],l=o[2];(a[s]=a[s]||{})[l]=a[r]=function(t){return function(e){\"number\"==typeof e&&(e=Array.prototype.slice.call(arguments));var i=n[t](e);if(\"string\"==typeof i||void 0===i)return i;for(var a=0;a<i.length;a++)i[a]=Math.round(i[a]);return i}}(r)}var u=function(){this.convs={}};u.prototype.routeSpace=function(t,e){var i=e[0];return void 0===i?this.getValues(t):(\"number\"==typeof i&&(i=Array.prototype.slice.call(e)),this.setValues(t,i))},u.prototype.setValues=function(t,e){return this.space=t,this.convs={},this.convs[t]=e,this},u.prototype.getValues=function(t){var e=this.convs[t];if(!e){var i=this.space,n=this.convs[i];e=a[i][t](n),this.convs[t]=e}return e},[\"rgb\",\"hsl\",\"hsv\",\"cmyk\",\"keyword\"].forEach(function(t){u.prototype[t]=function(e){return this.routeSpace(t,arguments)}}),e.exports=a},{3:3}],5:[function(t,e,i){\"use strict\";e.exports={aliceblue:[240,248,255],antiquewhite:[250,235,215],aqua:[0,255,255],aquamarine:[127,255,212],azure:[240,255,255],beige:[245,245,220],bisque:[255,228,196],black:[0,0,0],blanchedalmond:[255,235,205],blue:[0,0,255],blueviolet:[138,43,226],brown:[165,42,42],burlywood:[222,184,135],cadetblue:[95,158,160],chartreuse:[127,255,0],chocolate:[210,105,30],coral:[255,127,80],cornflowerblue:[100,149,237],cornsilk:[255,248,220],crimson:[220,20,60],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgoldenrod:[184,134,11],darkgray:[169,169,169],darkgreen:[0,100,0],darkgrey:[169,169,169],darkkhaki:[189,183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,150,122],darkseagreen:[143,188,143],darkslateblue:[72,61,139],darkslategray:[47,79,79],darkslategrey:[47,79,79],darkturquoise:[0,206,209],darkviolet:[148,0,211],deeppink:[255,20,147],deepskyblue:[0,191,255],dimgray:[105,105,105],dimgrey:[105,105,105],dodgerblue:[30,144,255],firebrick:[178,34,34],floralwhite:[255,250,240],forestgreen:[34,139,34],fuchsia:[255,0,255],gainsboro:[220,220,220],ghostwhite:[248,248,255],gold:[255,215,0],goldenrod:[218,165,32],gray:[128,128,128],green:[0,128,0],greenyellow:[173,255,47],grey:[128,128,128],honeydew:[240,255,240],hotpink:[255,105,180],indianred:[205,92,92],indigo:[75,0,130],ivory:[255,255,240],khaki:[240,230,140],lavender:[230,230,250],lavenderblush:[255,240,245],lawngreen:[124,252,0],lemonchiffon:[255,250,205],lightblue:[173,216,230],lightcoral:[240,128,128],lightcyan:[224,255,255],lightgoldenrodyellow:[250,250,210],lightgray:[211,211,211],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,182,193],lightsalmon:[255,160,122],lightseagreen:[32,178,170],lightskyblue:[135,206,250],lightslategray:[119,136,153],lightslategrey:[119,136,153],lightsteelblue:[176,196,222],lightyellow:[255,255,224],lime:[0,255,0],limegreen:[50,205,50],linen:[250,240,230],magenta:[255,0,255],maroon:[128,0,0],mediumaquamarine:[102,205,170],mediumblue:[0,0,205],mediumorchid:[186,85,211],mediumpurple:[147,112,219],mediumseagreen:[60,179,113],mediumslateblue:[123,104,238],mediumspringgreen:[0,250,154],mediumturquoise:[72,209,204],mediumvioletred:[199,21,133],midnightblue:[25,25,112],mintcream:[245,255,250],mistyrose:[255,228,225],moccasin:[255,228,181],navajowhite:[255,222,173],navy:[0,0,128],oldlace:[253,245,230],olive:[128,128,0],olivedrab:[107,142,35],orange:[255,165,0],orangered:[255,69,0],orchid:[218,112,214],palegoldenrod:[238,232,170],palegreen:[152,251,152],paleturquoise:[175,238,238],palevioletred:[219,112,147],papayawhip:[255,239,213],peachpuff:[255,218,185],peru:[205,133,63],pink:[255,192,203],plum:[221,160,221],powderblue:[176,224,230],purple:[128,0,128],rebeccapurple:[102,51,153],red:[255,0,0],rosybrown:[188,143,143],royalblue:[65,105,225],saddlebrown:[139,69,19],salmon:[250,128,114],sandybrown:[244,164,96],seagreen:[46,139,87],seashell:[255,245,238],sienna:[160,82,45],silver:[192,192,192],skyblue:[135,206,235],slateblue:[106,90,205],slategray:[112,128,144],slategrey:[112,128,144],snow:[255,250,250],springgreen:[0,255,127],steelblue:[70,130,180],tan:[210,180,140],teal:[0,128,128],thistle:[216,191,216],tomato:[255,99,71],turquoise:[64,224,208],violet:[238,130,238],wheat:[245,222,179],white:[255,255,255],whitesmoke:[245,245,245],yellow:[255,255,0],yellowgreen:[154,205,50]}},{}],6:[function(t,e,i){var n,a;n=this,a=function(){\"use strict\";var i,n;function a(){return i.apply(null,arguments)}function r(t){return t instanceof Array||\"[object Array]\"===Object.prototype.toString.call(t)}function o(t){return null!=t&&\"[object Object]\"===Object.prototype.toString.call(t)}function s(t){return void 0===t}function l(t){return\"number\"==typeof t||\"[object Number]\"===Object.prototype.toString.call(t)}function u(t){return t instanceof Date||\"[object Date]\"===Object.prototype.toString.call(t)}function d(t,e){var i,n=[];for(i=0;i<t.length;++i)n.push(e(t[i],i));return n}function h(t,e){return Object.prototype.hasOwnProperty.call(t,e)}function c(t,e){for(var i in e)h(e,i)&&(t[i]=e[i]);return h(e,\"toString\")&&(t.toString=e.toString),h(e,\"valueOf\")&&(t.valueOf=e.valueOf),t}function f(t,e,i,n){return Pe(t,e,i,n,!0).utc()}function g(t){return null==t._pf&&(t._pf={empty:!1,unusedTokens:[],unusedInput:[],overflow:-2,charsLeftOver:0,nullInput:!1,invalidMonth:null,invalidFormat:!1,userInvalidated:!1,iso:!1,parsedDateParts:[],meridiem:null,rfc2822:!1,weekdayMismatch:!1}),t._pf}function m(t){if(null==t._isValid){var e=g(t),i=n.call(e.parsedDateParts,function(t){return null!=t}),a=!isNaN(t._d.getTime())&&e.overflow<0&&!e.empty&&!e.invalidMonth&&!e.invalidWeekday&&!e.weekdayMismatch&&!e.nullInput&&!e.invalidFormat&&!e.userInvalidated&&(!e.meridiem||e.meridiem&&i);if(t._strict&&(a=a&&0===e.charsLeftOver&&0===e.unusedTokens.length&&void 0===e.bigHour),null!=Object.isFrozen&&Object.isFrozen(t))return a;t._isValid=a}return t._isValid}function p(t){var e=f(NaN);return null!=t?c(g(e),t):g(e).userInvalidated=!0,e}n=Array.prototype.some?Array.prototype.some:function(t){for(var e=Object(this),i=e.length>>>0,n=0;n<i;n++)if(n in e&&t.call(this,e[n],n,e))return!0;return!1};var v=a.momentProperties=[];function y(t,e){var i,n,a;if(s(e._isAMomentObject)||(t._isAMomentObject=e._isAMomentObject),s(e._i)||(t._i=e._i),s(e._f)||(t._f=e._f),s(e._l)||(t._l=e._l),s(e._strict)||(t._strict=e._strict),s(e._tzm)||(t._tzm=e._tzm),s(e._isUTC)||(t._isUTC=e._isUTC),s(e._offset)||(t._offset=e._offset),s(e._pf)||(t._pf=g(e)),s(e._locale)||(t._locale=e._locale),v.length>0)for(i=0;i<v.length;i++)s(a=e[n=v[i]])||(t[n]=a);return t}var b=!1;function x(t){y(this,t),this._d=new Date(null!=t._d?t._d.getTime():NaN),this.isValid()||(this._d=new Date(NaN)),!1===b&&(b=!0,a.updateOffset(this),b=!1)}function _(t){return t instanceof x||null!=t&&null!=t._isAMomentObject}function k(t){return t<0?Math.ceil(t)||0:Math.floor(t)}function w(t){var e=+t,i=0;return 0!==e&&isFinite(e)&&(i=k(e)),i}function M(t,e,i){var n,a=Math.min(t.length,e.length),r=Math.abs(t.length-e.length),o=0;for(n=0;n<a;n++)(i&&t[n]!==e[n]||!i&&w(t[n])!==w(e[n]))&&o++;return o+r}function S(t){!1===a.suppressDeprecationWarnings&&\"undefined\"!=typeof console&&console.warn&&console.warn(\"Deprecation warning: \"+t)}function D(t,e){var i=!0;return c(function(){if(null!=a.deprecationHandler&&a.deprecationHandler(null,t),i){for(var n,r=[],o=0;o<arguments.length;o++){if(n=\"\",\"object\"==typeof arguments[o]){for(var s in n+=\"\\n[\"+o+\"] \",arguments[0])n+=s+\": \"+arguments[0][s]+\", \";n=n.slice(0,-2)}else n=arguments[o];r.push(n)}S(t+\"\\nArguments: \"+Array.prototype.slice.call(r).join(\"\")+\"\\n\"+(new Error).stack),i=!1}return e.apply(this,arguments)},e)}var C,P={};function T(t,e){null!=a.deprecationHandler&&a.deprecationHandler(t,e),P[t]||(S(e),P[t]=!0)}function O(t){return t instanceof Function||\"[object Function]\"===Object.prototype.toString.call(t)}function I(t,e){var i,n=c({},t);for(i in e)h(e,i)&&(o(t[i])&&o(e[i])?(n[i]={},c(n[i],t[i]),c(n[i],e[i])):null!=e[i]?n[i]=e[i]:delete n[i]);for(i in t)h(t,i)&&!h(e,i)&&o(t[i])&&(n[i]=c({},n[i]));return n}function A(t){null!=t&&this.set(t)}a.suppressDeprecationWarnings=!1,a.deprecationHandler=null,C=Object.keys?Object.keys:function(t){var e,i=[];for(e in t)h(t,e)&&i.push(e);return i};var F={};function R(t,e){var i=t.toLowerCase();F[i]=F[i+\"s\"]=F[e]=t}function L(t){return\"string\"==typeof t?F[t]||F[t.toLowerCase()]:void 0}function W(t){var e,i,n={};for(i in t)h(t,i)&&(e=L(i))&&(n[e]=t[i]);return n}var Y={};function N(t,e){Y[t]=e}function z(t,e,i){var n=\"\"+Math.abs(t),a=e-n.length;return(t>=0?i?\"+\":\"\":\"-\")+Math.pow(10,Math.max(0,a)).toString().substr(1)+n}var H=/(\\[[^\\[]*\\])|(\\\\)?([Hh]mm(ss)?|Mo|MM?M?M?|Do|DDDo|DD?D?D?|ddd?d?|do?|w[o|w]?|W[o|W]?|Qo?|YYYYYY|YYYYY|YYYY|YY|gg(ggg?)?|GG(GGG?)?|e|E|a|A|hh?|HH?|kk?|mm?|ss?|S{1,9}|x|X|zz?|ZZ?|.)/g,V=/(\\[[^\\[]*\\])|(\\\\)?(LTS|LT|LL?L?L?|l{1,4})/g,B={},E={};function j(t,e,i,n){var a=n;\"string\"==typeof n&&(a=function(){return this[n]()}),t&&(E[t]=a),e&&(E[e[0]]=function(){return z(a.apply(this,arguments),e[1],e[2])}),i&&(E[i]=function(){return this.localeData().ordinal(a.apply(this,arguments),t)})}function U(t,e){return t.isValid()?(e=q(e,t.localeData()),B[e]=B[e]||function(t){var e,i,n,a=t.match(H);for(e=0,i=a.length;e<i;e++)E[a[e]]?a[e]=E[a[e]]:a[e]=(n=a[e]).match(/\\[[\\s\\S]/)?n.replace(/^\\[|\\]$/g,\"\"):n.replace(/\\\\/g,\"\");return function(e){var n,r=\"\";for(n=0;n<i;n++)r+=O(a[n])?a[n].call(e,t):a[n];return r}}(e),B[e](t)):t.localeData().invalidDate()}function q(t,e){var i=5;function n(t){return e.longDateFormat(t)||t}for(V.lastIndex=0;i>=0&&V.test(t);)t=t.replace(V,n),V.lastIndex=0,i-=1;return t}var G=/\\d/,Z=/\\d\\d/,X=/\\d{3}/,J=/\\d{4}/,K=/[+-]?\\d{6}/,$=/\\d\\d?/,Q=/\\d\\d\\d\\d?/,tt=/\\d\\d\\d\\d\\d\\d?/,et=/\\d{1,3}/,it=/\\d{1,4}/,nt=/[+-]?\\d{1,6}/,at=/\\d+/,rt=/[+-]?\\d+/,ot=/Z|[+-]\\d\\d:?\\d\\d/gi,st=/Z|[+-]\\d\\d(?::?\\d\\d)?/gi,lt=/[0-9]{0,256}['a-z\\u00A0-\\u05FF\\u0700-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFF07\\uFF10-\\uFFEF]{1,256}|[\\u0600-\\u06FF\\/]{1,256}(\\s*?[\\u0600-\\u06FF]{1,256}){1,2}/i,ut={};function dt(t,e,i){ut[t]=O(e)?e:function(t,n){return t&&i?i:e}}function ht(t,e){return h(ut,t)?ut[t](e._strict,e._locale):new RegExp(ct(t.replace(\"\\\\\",\"\").replace(/\\\\(\\[)|\\\\(\\])|\\[([^\\]\\[]*)\\]|\\\\(.)/g,function(t,e,i,n,a){return e||i||n||a})))}function ct(t){return t.replace(/[-\\/\\\\^$*+?.()|[\\]{}]/g,\"\\\\$&\")}var ft={};function gt(t,e){var i,n=e;for(\"string\"==typeof t&&(t=[t]),l(e)&&(n=function(t,i){i[e]=w(t)}),i=0;i<t.length;i++)ft[t[i]]=n}function mt(t,e){gt(t,function(t,i,n,a){n._w=n._w||{},e(t,n._w,n,a)})}var pt=0,vt=1,yt=2,bt=3,xt=4,_t=5,kt=6,wt=7,Mt=8;function St(t){return Dt(t)?366:365}function Dt(t){return t%4==0&&t%100!=0||t%400==0}j(\"Y\",0,0,function(){var t=this.year();return t<=9999?\"\"+t:\"+\"+t}),j(0,[\"YY\",2],0,function(){return this.year()%100}),j(0,[\"YYYY\",4],0,\"year\"),j(0,[\"YYYYY\",5],0,\"year\"),j(0,[\"YYYYYY\",6,!0],0,\"year\"),R(\"year\",\"y\"),N(\"year\",1),dt(\"Y\",rt),dt(\"YY\",$,Z),dt(\"YYYY\",it,J),dt(\"YYYYY\",nt,K),dt(\"YYYYYY\",nt,K),gt([\"YYYYY\",\"YYYYYY\"],pt),gt(\"YYYY\",function(t,e){e[pt]=2===t.length?a.parseTwoDigitYear(t):w(t)}),gt(\"YY\",function(t,e){e[pt]=a.parseTwoDigitYear(t)}),gt(\"Y\",function(t,e){e[pt]=parseInt(t,10)}),a.parseTwoDigitYear=function(t){return w(t)+(w(t)>68?1900:2e3)};var Ct,Pt=Tt(\"FullYear\",!0);function Tt(t,e){return function(i){return null!=i?(It(this,t,i),a.updateOffset(this,e),this):Ot(this,t)}}function Ot(t,e){return t.isValid()?t._d[\"get\"+(t._isUTC?\"UTC\":\"\")+e]():NaN}function It(t,e,i){t.isValid()&&!isNaN(i)&&(\"FullYear\"===e&&Dt(t.year())&&1===t.month()&&29===t.date()?t._d[\"set\"+(t._isUTC?\"UTC\":\"\")+e](i,t.month(),At(i,t.month())):t._d[\"set\"+(t._isUTC?\"UTC\":\"\")+e](i))}function At(t,e){if(isNaN(t)||isNaN(e))return NaN;var i,n=(e%(i=12)+i)%i;return t+=(e-n)/12,1===n?Dt(t)?29:28:31-n%7%2}Ct=Array.prototype.indexOf?Array.prototype.indexOf:function(t){var e;for(e=0;e<this.length;++e)if(this[e]===t)return e;return-1},j(\"M\",[\"MM\",2],\"Mo\",function(){return this.month()+1}),j(\"MMM\",0,0,function(t){return this.localeData().monthsShort(this,t)}),j(\"MMMM\",0,0,function(t){return this.localeData().months(this,t)}),R(\"month\",\"M\"),N(\"month\",8),dt(\"M\",$),dt(\"MM\",$,Z),dt(\"MMM\",function(t,e){return e.monthsShortRegex(t)}),dt(\"MMMM\",function(t,e){return e.monthsRegex(t)}),gt([\"M\",\"MM\"],function(t,e){e[vt]=w(t)-1}),gt([\"MMM\",\"MMMM\"],function(t,e,i,n){var a=i._locale.monthsParse(t,n,i._strict);null!=a?e[vt]=a:g(i).invalidMonth=t});var Ft=/D[oD]?(\\[[^\\[\\]]*\\]|\\s)+MMMM?/,Rt=\"January_February_March_April_May_June_July_August_September_October_November_December\".split(\"_\");var Lt=\"Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec\".split(\"_\");function Wt(t,e){var i;if(!t.isValid())return t;if(\"string\"==typeof e)if(/^\\d+$/.test(e))e=w(e);else if(!l(e=t.localeData().monthsParse(e)))return t;return i=Math.min(t.date(),At(t.year(),e)),t._d[\"set\"+(t._isUTC?\"UTC\":\"\")+\"Month\"](e,i),t}function Yt(t){return null!=t?(Wt(this,t),a.updateOffset(this,!0),this):Ot(this,\"Month\")}var Nt=lt;var zt=lt;function Ht(){function t(t,e){return e.length-t.length}var e,i,n=[],a=[],r=[];for(e=0;e<12;e++)i=f([2e3,e]),n.push(this.monthsShort(i,\"\")),a.push(this.months(i,\"\")),r.push(this.months(i,\"\")),r.push(this.monthsShort(i,\"\"));for(n.sort(t),a.sort(t),r.sort(t),e=0;e<12;e++)n[e]=ct(n[e]),a[e]=ct(a[e]);for(e=0;e<24;e++)r[e]=ct(r[e]);this._monthsRegex=new RegExp(\"^(\"+r.join(\"|\")+\")\",\"i\"),this._monthsShortRegex=this._monthsRegex,this._monthsStrictRegex=new RegExp(\"^(\"+a.join(\"|\")+\")\",\"i\"),this._monthsShortStrictRegex=new RegExp(\"^(\"+n.join(\"|\")+\")\",\"i\")}function Vt(t){var e=new Date(Date.UTC.apply(null,arguments));return t<100&&t>=0&&isFinite(e.getUTCFullYear())&&e.setUTCFullYear(t),e}function Bt(t,e,i){var n=7+e-i;return-((7+Vt(t,0,n).getUTCDay()-e)%7)+n-1}function Et(t,e,i,n,a){var r,o,s=1+7*(e-1)+(7+i-n)%7+Bt(t,n,a);return s<=0?o=St(r=t-1)+s:s>St(t)?(r=t+1,o=s-St(t)):(r=t,o=s),{year:r,dayOfYear:o}}function jt(t,e,i){var n,a,r=Bt(t.year(),e,i),o=Math.floor((t.dayOfYear()-r-1)/7)+1;return o<1?n=o+Ut(a=t.year()-1,e,i):o>Ut(t.year(),e,i)?(n=o-Ut(t.year(),e,i),a=t.year()+1):(a=t.year(),n=o),{week:n,year:a}}function Ut(t,e,i){var n=Bt(t,e,i),a=Bt(t+1,e,i);return(St(t)-n+a)/7}j(\"w\",[\"ww\",2],\"wo\",\"week\"),j(\"W\",[\"WW\",2],\"Wo\",\"isoWeek\"),R(\"week\",\"w\"),R(\"isoWeek\",\"W\"),N(\"week\",5),N(\"isoWeek\",5),dt(\"w\",$),dt(\"ww\",$,Z),dt(\"W\",$),dt(\"WW\",$,Z),mt([\"w\",\"ww\",\"W\",\"WW\"],function(t,e,i,n){e[n.substr(0,1)]=w(t)});j(\"d\",0,\"do\",\"day\"),j(\"dd\",0,0,function(t){return this.localeData().weekdaysMin(this,t)}),j(\"ddd\",0,0,function(t){return this.localeData().weekdaysShort(this,t)}),j(\"dddd\",0,0,function(t){return this.localeData().weekdays(this,t)}),j(\"e\",0,0,\"weekday\"),j(\"E\",0,0,\"isoWeekday\"),R(\"day\",\"d\"),R(\"weekday\",\"e\"),R(\"isoWeekday\",\"E\"),N(\"day\",11),N(\"weekday\",11),N(\"isoWeekday\",11),dt(\"d\",$),dt(\"e\",$),dt(\"E\",$),dt(\"dd\",function(t,e){return e.weekdaysMinRegex(t)}),dt(\"ddd\",function(t,e){return e.weekdaysShortRegex(t)}),dt(\"dddd\",function(t,e){return e.weekdaysRegex(t)}),mt([\"dd\",\"ddd\",\"dddd\"],function(t,e,i,n){var a=i._locale.weekdaysParse(t,n,i._strict);null!=a?e.d=a:g(i).invalidWeekday=t}),mt([\"d\",\"e\",\"E\"],function(t,e,i,n){e[n]=w(t)});var qt=\"Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday\".split(\"_\");var Gt=\"Sun_Mon_Tue_Wed_Thu_Fri_Sat\".split(\"_\");var Zt=\"Su_Mo_Tu_We_Th_Fr_Sa\".split(\"_\");var Xt=lt;var Jt=lt;var Kt=lt;function $t(){function t(t,e){return e.length-t.length}var e,i,n,a,r,o=[],s=[],l=[],u=[];for(e=0;e<7;e++)i=f([2e3,1]).day(e),n=this.weekdaysMin(i,\"\"),a=this.weekdaysShort(i,\"\"),r=this.weekdays(i,\"\"),o.push(n),s.push(a),l.push(r),u.push(n),u.push(a),u.push(r);for(o.sort(t),s.sort(t),l.sort(t),u.sort(t),e=0;e<7;e++)s[e]=ct(s[e]),l[e]=ct(l[e]),u[e]=ct(u[e]);this._weekdaysRegex=new RegExp(\"^(\"+u.join(\"|\")+\")\",\"i\"),this._weekdaysShortRegex=this._weekdaysRegex,this._weekdaysMinRegex=this._weekdaysRegex,this._weekdaysStrictRegex=new RegExp(\"^(\"+l.join(\"|\")+\")\",\"i\"),this._weekdaysShortStrictRegex=new RegExp(\"^(\"+s.join(\"|\")+\")\",\"i\"),this._weekdaysMinStrictRegex=new RegExp(\"^(\"+o.join(\"|\")+\")\",\"i\")}function Qt(){return this.hours()%12||12}function te(t,e){j(t,0,0,function(){return this.localeData().meridiem(this.hours(),this.minutes(),e)})}function ee(t,e){return e._meridiemParse}j(\"H\",[\"HH\",2],0,\"hour\"),j(\"h\",[\"hh\",2],0,Qt),j(\"k\",[\"kk\",2],0,function(){return this.hours()||24}),j(\"hmm\",0,0,function(){return\"\"+Qt.apply(this)+z(this.minutes(),2)}),j(\"hmmss\",0,0,function(){return\"\"+Qt.apply(this)+z(this.minutes(),2)+z(this.seconds(),2)}),j(\"Hmm\",0,0,function(){return\"\"+this.hours()+z(this.minutes(),2)}),j(\"Hmmss\",0,0,function(){return\"\"+this.hours()+z(this.minutes(),2)+z(this.seconds(),2)}),te(\"a\",!0),te(\"A\",!1),R(\"hour\",\"h\"),N(\"hour\",13),dt(\"a\",ee),dt(\"A\",ee),dt(\"H\",$),dt(\"h\",$),dt(\"k\",$),dt(\"HH\",$,Z),dt(\"hh\",$,Z),dt(\"kk\",$,Z),dt(\"hmm\",Q),dt(\"hmmss\",tt),dt(\"Hmm\",Q),dt(\"Hmmss\",tt),gt([\"H\",\"HH\"],bt),gt([\"k\",\"kk\"],function(t,e,i){var n=w(t);e[bt]=24===n?0:n}),gt([\"a\",\"A\"],function(t,e,i){i._isPm=i._locale.isPM(t),i._meridiem=t}),gt([\"h\",\"hh\"],function(t,e,i){e[bt]=w(t),g(i).bigHour=!0}),gt(\"hmm\",function(t,e,i){var n=t.length-2;e[bt]=w(t.substr(0,n)),e[xt]=w(t.substr(n)),g(i).bigHour=!0}),gt(\"hmmss\",function(t,e,i){var n=t.length-4,a=t.length-2;e[bt]=w(t.substr(0,n)),e[xt]=w(t.substr(n,2)),e[_t]=w(t.substr(a)),g(i).bigHour=!0}),gt(\"Hmm\",function(t,e,i){var n=t.length-2;e[bt]=w(t.substr(0,n)),e[xt]=w(t.substr(n))}),gt(\"Hmmss\",function(t,e,i){var n=t.length-4,a=t.length-2;e[bt]=w(t.substr(0,n)),e[xt]=w(t.substr(n,2)),e[_t]=w(t.substr(a))});var ie,ne=Tt(\"Hours\",!0),ae={calendar:{sameDay:\"[Today at] LT\",nextDay:\"[Tomorrow at] LT\",nextWeek:\"dddd [at] LT\",lastDay:\"[Yesterday at] LT\",lastWeek:\"[Last] dddd [at] LT\",sameElse:\"L\"},longDateFormat:{LTS:\"h:mm:ss A\",LT:\"h:mm A\",L:\"MM/DD/YYYY\",LL:\"MMMM D, YYYY\",LLL:\"MMMM D, YYYY h:mm A\",LLLL:\"dddd, MMMM D, YYYY h:mm A\"},invalidDate:\"Invalid date\",ordinal:\"%d\",dayOfMonthOrdinalParse:/\\d{1,2}/,relativeTime:{future:\"in %s\",past:\"%s ago\",s:\"a few seconds\",ss:\"%d seconds\",m:\"a minute\",mm:\"%d minutes\",h:\"an hour\",hh:\"%d hours\",d:\"a day\",dd:\"%d days\",M:\"a month\",MM:\"%d months\",y:\"a year\",yy:\"%d years\"},months:Rt,monthsShort:Lt,week:{dow:0,doy:6},weekdays:qt,weekdaysMin:Zt,weekdaysShort:Gt,meridiemParse:/[ap]\\.?m?\\.?/i},re={},oe={};function se(t){return t?t.toLowerCase().replace(\"_\",\"-\"):t}function le(i){var n=null;if(!re[i]&&void 0!==e&&e&&e.exports)try{n=ie._abbr,t(\"./locale/\"+i),ue(n)}catch(t){}return re[i]}function ue(t,e){var i;return t&&(i=s(e)?he(t):de(t,e))&&(ie=i),ie._abbr}function de(t,e){if(null!==e){var i=ae;if(e.abbr=t,null!=re[t])T(\"defineLocaleOverride\",\"use moment.updateLocale(localeName, config) to change an existing locale. moment.defineLocale(localeName, config) should only be used for creating a new locale See http://momentjs.com/guides/#/warnings/define-locale/ for more info.\"),i=re[t]._config;else if(null!=e.parentLocale){if(null==re[e.parentLocale])return oe[e.parentLocale]||(oe[e.parentLocale]=[]),oe[e.parentLocale].push({name:t,config:e}),null;i=re[e.parentLocale]._config}return re[t]=new A(I(i,e)),oe[t]&&oe[t].forEach(function(t){de(t.name,t.config)}),ue(t),re[t]}return delete re[t],null}function he(t){var e;if(t&&t._locale&&t._locale._abbr&&(t=t._locale._abbr),!t)return ie;if(!r(t)){if(e=le(t))return e;t=[t]}return function(t){for(var e,i,n,a,r=0;r<t.length;){for(e=(a=se(t[r]).split(\"-\")).length,i=(i=se(t[r+1]))?i.split(\"-\"):null;e>0;){if(n=le(a.slice(0,e).join(\"-\")))return n;if(i&&i.length>=e&&M(a,i,!0)>=e-1)break;e--}r++}return null}(t)}function ce(t){var e,i=t._a;return i&&-2===g(t).overflow&&(e=i[vt]<0||i[vt]>11?vt:i[yt]<1||i[yt]>At(i[pt],i[vt])?yt:i[bt]<0||i[bt]>24||24===i[bt]&&(0!==i[xt]||0!==i[_t]||0!==i[kt])?bt:i[xt]<0||i[xt]>59?xt:i[_t]<0||i[_t]>59?_t:i[kt]<0||i[kt]>999?kt:-1,g(t)._overflowDayOfYear&&(e<pt||e>yt)&&(e=yt),g(t)._overflowWeeks&&-1===e&&(e=wt),g(t)._overflowWeekday&&-1===e&&(e=Mt),g(t).overflow=e),t}function fe(t,e,i){return null!=t?t:null!=e?e:i}function ge(t){var e,i,n,r,o,s=[];if(!t._d){var l,u;for(l=t,u=new Date(a.now()),n=l._useUTC?[u.getUTCFullYear(),u.getUTCMonth(),u.getUTCDate()]:[u.getFullYear(),u.getMonth(),u.getDate()],t._w&&null==t._a[yt]&&null==t._a[vt]&&function(t){var e,i,n,a,r,o,s,l;if(null!=(e=t._w).GG||null!=e.W||null!=e.E)r=1,o=4,i=fe(e.GG,t._a[pt],jt(Te(),1,4).year),n=fe(e.W,1),((a=fe(e.E,1))<1||a>7)&&(l=!0);else{r=t._locale._week.dow,o=t._locale._week.doy;var u=jt(Te(),r,o);i=fe(e.gg,t._a[pt],u.year),n=fe(e.w,u.week),null!=e.d?((a=e.d)<0||a>6)&&(l=!0):null!=e.e?(a=e.e+r,(e.e<0||e.e>6)&&(l=!0)):a=r}n<1||n>Ut(i,r,o)?g(t)._overflowWeeks=!0:null!=l?g(t)._overflowWeekday=!0:(s=Et(i,n,a,r,o),t._a[pt]=s.year,t._dayOfYear=s.dayOfYear)}(t),null!=t._dayOfYear&&(o=fe(t._a[pt],n[pt]),(t._dayOfYear>St(o)||0===t._dayOfYear)&&(g(t)._overflowDayOfYear=!0),i=Vt(o,0,t._dayOfYear),t._a[vt]=i.getUTCMonth(),t._a[yt]=i.getUTCDate()),e=0;e<3&&null==t._a[e];++e)t._a[e]=s[e]=n[e];for(;e<7;e++)t._a[e]=s[e]=null==t._a[e]?2===e?1:0:t._a[e];24===t._a[bt]&&0===t._a[xt]&&0===t._a[_t]&&0===t._a[kt]&&(t._nextDay=!0,t._a[bt]=0),t._d=(t._useUTC?Vt:function(t,e,i,n,a,r,o){var s=new Date(t,e,i,n,a,r,o);return t<100&&t>=0&&isFinite(s.getFullYear())&&s.setFullYear(t),s}).apply(null,s),r=t._useUTC?t._d.getUTCDay():t._d.getDay(),null!=t._tzm&&t._d.setUTCMinutes(t._d.getUTCMinutes()-t._tzm),t._nextDay&&(t._a[bt]=24),t._w&&void 0!==t._w.d&&t._w.d!==r&&(g(t).weekdayMismatch=!0)}}var me=/^\\s*((?:[+-]\\d{6}|\\d{4})-(?:\\d\\d-\\d\\d|W\\d\\d-\\d|W\\d\\d|\\d\\d\\d|\\d\\d))(?:(T| )(\\d\\d(?::\\d\\d(?::\\d\\d(?:[.,]\\d+)?)?)?)([\\+\\-]\\d\\d(?::?\\d\\d)?|\\s*Z)?)?$/,pe=/^\\s*((?:[+-]\\d{6}|\\d{4})(?:\\d\\d\\d\\d|W\\d\\d\\d|W\\d\\d|\\d\\d\\d|\\d\\d))(?:(T| )(\\d\\d(?:\\d\\d(?:\\d\\d(?:[.,]\\d+)?)?)?)([\\+\\-]\\d\\d(?::?\\d\\d)?|\\s*Z)?)?$/,ve=/Z|[+-]\\d\\d(?::?\\d\\d)?/,ye=[[\"YYYYYY-MM-DD\",/[+-]\\d{6}-\\d\\d-\\d\\d/],[\"YYYY-MM-DD\",/\\d{4}-\\d\\d-\\d\\d/],[\"GGGG-[W]WW-E\",/\\d{4}-W\\d\\d-\\d/],[\"GGGG-[W]WW\",/\\d{4}-W\\d\\d/,!1],[\"YYYY-DDD\",/\\d{4}-\\d{3}/],[\"YYYY-MM\",/\\d{4}-\\d\\d/,!1],[\"YYYYYYMMDD\",/[+-]\\d{10}/],[\"YYYYMMDD\",/\\d{8}/],[\"GGGG[W]WWE\",/\\d{4}W\\d{3}/],[\"GGGG[W]WW\",/\\d{4}W\\d{2}/,!1],[\"YYYYDDD\",/\\d{7}/]],be=[[\"HH:mm:ss.SSSS\",/\\d\\d:\\d\\d:\\d\\d\\.\\d+/],[\"HH:mm:ss,SSSS\",/\\d\\d:\\d\\d:\\d\\d,\\d+/],[\"HH:mm:ss\",/\\d\\d:\\d\\d:\\d\\d/],[\"HH:mm\",/\\d\\d:\\d\\d/],[\"HHmmss.SSSS\",/\\d\\d\\d\\d\\d\\d\\.\\d+/],[\"HHmmss,SSSS\",/\\d\\d\\d\\d\\d\\d,\\d+/],[\"HHmmss\",/\\d\\d\\d\\d\\d\\d/],[\"HHmm\",/\\d\\d\\d\\d/],[\"HH\",/\\d\\d/]],xe=/^\\/?Date\\((\\-?\\d+)/i;function _e(t){var e,i,n,a,r,o,s=t._i,l=me.exec(s)||pe.exec(s);if(l){for(g(t).iso=!0,e=0,i=ye.length;e<i;e++)if(ye[e][1].exec(l[1])){a=ye[e][0],n=!1!==ye[e][2];break}if(null==a)return void(t._isValid=!1);if(l[3]){for(e=0,i=be.length;e<i;e++)if(be[e][1].exec(l[3])){r=(l[2]||\" \")+be[e][0];break}if(null==r)return void(t._isValid=!1)}if(!n&&null!=r)return void(t._isValid=!1);if(l[4]){if(!ve.exec(l[4]))return void(t._isValid=!1);o=\"Z\"}t._f=a+(r||\"\")+(o||\"\"),De(t)}else t._isValid=!1}var ke=/^(?:(Mon|Tue|Wed|Thu|Fri|Sat|Sun),?\\s)?(\\d{1,2})\\s(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\\s(\\d{2,4})\\s(\\d\\d):(\\d\\d)(?::(\\d\\d))?\\s(?:(UT|GMT|[ECMP][SD]T)|([Zz])|([+-]\\d{4}))$/;function we(t,e,i,n,a,r){var o=[function(t){var e=parseInt(t,10);{if(e<=49)return 2e3+e;if(e<=999)return 1900+e}return e}(t),Lt.indexOf(e),parseInt(i,10),parseInt(n,10),parseInt(a,10)];return r&&o.push(parseInt(r,10)),o}var Me={UT:0,GMT:0,EDT:-240,EST:-300,CDT:-300,CST:-360,MDT:-360,MST:-420,PDT:-420,PST:-480};function Se(t){var e,i,n,a=ke.exec(t._i.replace(/\\([^)]*\\)|[\\n\\t]/g,\" \").replace(/(\\s\\s+)/g,\" \").trim());if(a){var r=we(a[4],a[3],a[2],a[5],a[6],a[7]);if(e=a[1],i=r,n=t,e&&Gt.indexOf(e)!==new Date(i[0],i[1],i[2]).getDay()&&(g(n).weekdayMismatch=!0,n._isValid=!1,1))return;t._a=r,t._tzm=function(t,e,i){if(t)return Me[t];if(e)return 0;var n=parseInt(i,10),a=n%100;return(n-a)/100*60+a}(a[8],a[9],a[10]),t._d=Vt.apply(null,t._a),t._d.setUTCMinutes(t._d.getUTCMinutes()-t._tzm),g(t).rfc2822=!0}else t._isValid=!1}function De(t){if(t._f!==a.ISO_8601)if(t._f!==a.RFC_2822){t._a=[],g(t).empty=!0;var e,i,n,r,o,s,l,u,d=\"\"+t._i,c=d.length,f=0;for(n=q(t._f,t._locale).match(H)||[],e=0;e<n.length;e++)r=n[e],(i=(d.match(ht(r,t))||[])[0])&&((o=d.substr(0,d.indexOf(i))).length>0&&g(t).unusedInput.push(o),d=d.slice(d.indexOf(i)+i.length),f+=i.length),E[r]?(i?g(t).empty=!1:g(t).unusedTokens.push(r),s=r,u=t,null!=(l=i)&&h(ft,s)&&ft[s](l,u._a,u,s)):t._strict&&!i&&g(t).unusedTokens.push(r);g(t).charsLeftOver=c-f,d.length>0&&g(t).unusedInput.push(d),t._a[bt]<=12&&!0===g(t).bigHour&&t._a[bt]>0&&(g(t).bigHour=void 0),g(t).parsedDateParts=t._a.slice(0),g(t).meridiem=t._meridiem,t._a[bt]=function(t,e,i){var n;if(null==i)return e;return null!=t.meridiemHour?t.meridiemHour(e,i):null!=t.isPM?((n=t.isPM(i))&&e<12&&(e+=12),n||12!==e||(e=0),e):e}(t._locale,t._a[bt],t._meridiem),ge(t),ce(t)}else Se(t);else _e(t)}function Ce(t){var e,i,n,h,f=t._i,v=t._f;return t._locale=t._locale||he(t._l),null===f||void 0===v&&\"\"===f?p({nullInput:!0}):(\"string\"==typeof f&&(t._i=f=t._locale.preparse(f)),_(f)?new x(ce(f)):(u(f)?t._d=f:r(v)?function(t){var e,i,n,a,r;if(0===t._f.length)return g(t).invalidFormat=!0,void(t._d=new Date(NaN));for(a=0;a<t._f.length;a++)r=0,e=y({},t),null!=t._useUTC&&(e._useUTC=t._useUTC),e._f=t._f[a],De(e),m(e)&&(r+=g(e).charsLeftOver,r+=10*g(e).unusedTokens.length,g(e).score=r,(null==n||r<n)&&(n=r,i=e));c(t,i||e)}(t):v?De(t):s(i=(e=t)._i)?e._d=new Date(a.now()):u(i)?e._d=new Date(i.valueOf()):\"string\"==typeof i?(n=e,null===(h=xe.exec(n._i))?(_e(n),!1===n._isValid&&(delete n._isValid,Se(n),!1===n._isValid&&(delete n._isValid,a.createFromInputFallback(n)))):n._d=new Date(+h[1])):r(i)?(e._a=d(i.slice(0),function(t){return parseInt(t,10)}),ge(e)):o(i)?function(t){if(!t._d){var e=W(t._i);t._a=d([e.year,e.month,e.day||e.date,e.hour,e.minute,e.second,e.millisecond],function(t){return t&&parseInt(t,10)}),ge(t)}}(e):l(i)?e._d=new Date(i):a.createFromInputFallback(e),m(t)||(t._d=null),t))}function Pe(t,e,i,n,a){var s,l={};return!0!==i&&!1!==i||(n=i,i=void 0),(o(t)&&function(t){if(Object.getOwnPropertyNames)return 0===Object.getOwnPropertyNames(t).length;var e;for(e in t)if(t.hasOwnProperty(e))return!1;return!0}(t)||r(t)&&0===t.length)&&(t=void 0),l._isAMomentObject=!0,l._useUTC=l._isUTC=a,l._l=i,l._i=t,l._f=e,l._strict=n,(s=new x(ce(Ce(l))))._nextDay&&(s.add(1,\"d\"),s._nextDay=void 0),s}function Te(t,e,i,n){return Pe(t,e,i,n,!1)}a.createFromInputFallback=D(\"value provided is not in a recognized RFC2822 or ISO format. moment construction falls back to js Date(), which is not reliable across all browsers and versions. Non RFC2822/ISO date formats are discouraged and will be removed in an upcoming major release. Please refer to http://momentjs.com/guides/#/warnings/js-date/ for more info.\",function(t){t._d=new Date(t._i+(t._useUTC?\" UTC\":\"\"))}),a.ISO_8601=function(){},a.RFC_2822=function(){};var Oe=D(\"moment().min is deprecated, use moment.max instead. http://momentjs.com/guides/#/warnings/min-max/\",function(){var t=Te.apply(null,arguments);return this.isValid()&&t.isValid()?t<this?this:t:p()}),Ie=D(\"moment().max is deprecated, use moment.min instead. http://momentjs.com/guides/#/warnings/min-max/\",function(){var t=Te.apply(null,arguments);return this.isValid()&&t.isValid()?t>this?this:t:p()});function Ae(t,e){var i,n;if(1===e.length&&r(e[0])&&(e=e[0]),!e.length)return Te();for(i=e[0],n=1;n<e.length;++n)e[n].isValid()&&!e[n][t](i)||(i=e[n]);return i}var Fe=[\"year\",\"quarter\",\"month\",\"week\",\"day\",\"hour\",\"minute\",\"second\",\"millisecond\"];function Re(t){var e=W(t),i=e.year||0,n=e.quarter||0,a=e.month||0,r=e.week||0,o=e.day||0,s=e.hour||0,l=e.minute||0,u=e.second||0,d=e.millisecond||0;this._isValid=function(t){for(var e in t)if(-1===Ct.call(Fe,e)||null!=t[e]&&isNaN(t[e]))return!1;for(var i=!1,n=0;n<Fe.length;++n)if(t[Fe[n]]){if(i)return!1;parseFloat(t[Fe[n]])!==w(t[Fe[n]])&&(i=!0)}return!0}(e),this._milliseconds=+d+1e3*u+6e4*l+1e3*s*60*60,this._days=+o+7*r,this._months=+a+3*n+12*i,this._data={},this._locale=he(),this._bubble()}function Le(t){return t instanceof Re}function We(t){return t<0?-1*Math.round(-1*t):Math.round(t)}function Ye(t,e){j(t,0,0,function(){var t=this.utcOffset(),i=\"+\";return t<0&&(t=-t,i=\"-\"),i+z(~~(t/60),2)+e+z(~~t%60,2)})}Ye(\"Z\",\":\"),Ye(\"ZZ\",\"\"),dt(\"Z\",st),dt(\"ZZ\",st),gt([\"Z\",\"ZZ\"],function(t,e,i){i._useUTC=!0,i._tzm=ze(st,t)});var Ne=/([\\+\\-]|\\d\\d)/gi;function ze(t,e){var i=(e||\"\").match(t);if(null===i)return null;var n=((i[i.length-1]||[])+\"\").match(Ne)||[\"-\",0,0],a=60*n[1]+w(n[2]);return 0===a?0:\"+\"===n[0]?a:-a}function He(t,e){var i,n;return e._isUTC?(i=e.clone(),n=(_(t)||u(t)?t.valueOf():Te(t).valueOf())-i.valueOf(),i._d.setTime(i._d.valueOf()+n),a.updateOffset(i,!1),i):Te(t).local()}function Ve(t){return 15*-Math.round(t._d.getTimezoneOffset()/15)}function Be(){return!!this.isValid()&&(this._isUTC&&0===this._offset)}a.updateOffset=function(){};var Ee=/^(\\-|\\+)?(?:(\\d*)[. ])?(\\d+)\\:(\\d+)(?:\\:(\\d+)(\\.\\d*)?)?$/,je=/^(-|\\+)?P(?:([-+]?[0-9,.]*)Y)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)W)?(?:([-+]?[0-9,.]*)D)?(?:T(?:([-+]?[0-9,.]*)H)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)S)?)?$/;function Ue(t,e){var i,n,a,r=t,o=null;return Le(t)?r={ms:t._milliseconds,d:t._days,M:t._months}:l(t)?(r={},e?r[e]=t:r.milliseconds=t):(o=Ee.exec(t))?(i=\"-\"===o[1]?-1:1,r={y:0,d:w(o[yt])*i,h:w(o[bt])*i,m:w(o[xt])*i,s:w(o[_t])*i,ms:w(We(1e3*o[kt]))*i}):(o=je.exec(t))?(i=\"-\"===o[1]?-1:(o[1],1),r={y:qe(o[2],i),M:qe(o[3],i),w:qe(o[4],i),d:qe(o[5],i),h:qe(o[6],i),m:qe(o[7],i),s:qe(o[8],i)}):null==r?r={}:\"object\"==typeof r&&(\"from\"in r||\"to\"in r)&&(a=function(t,e){var i;if(!t.isValid()||!e.isValid())return{milliseconds:0,months:0};e=He(e,t),t.isBefore(e)?i=Ge(t,e):((i=Ge(e,t)).milliseconds=-i.milliseconds,i.months=-i.months);return i}(Te(r.from),Te(r.to)),(r={}).ms=a.milliseconds,r.M=a.months),n=new Re(r),Le(t)&&h(t,\"_locale\")&&(n._locale=t._locale),n}function qe(t,e){var i=t&&parseFloat(t.replace(\",\",\".\"));return(isNaN(i)?0:i)*e}function Ge(t,e){var i={milliseconds:0,months:0};return i.months=e.month()-t.month()+12*(e.year()-t.year()),t.clone().add(i.months,\"M\").isAfter(e)&&--i.months,i.milliseconds=+e-+t.clone().add(i.months,\"M\"),i}function Ze(t,e){return function(i,n){var a;return null===n||isNaN(+n)||(T(e,\"moment().\"+e+\"(period, number) is deprecated. Please use moment().\"+e+\"(number, period). See http://momentjs.com/guides/#/warnings/add-inverted-param/ for more info.\"),a=i,i=n,n=a),Xe(this,Ue(i=\"string\"==typeof i?+i:i,n),t),this}}function Xe(t,e,i,n){var r=e._milliseconds,o=We(e._days),s=We(e._months);t.isValid()&&(n=null==n||n,s&&Wt(t,Ot(t,\"Month\")+s*i),o&&It(t,\"Date\",Ot(t,\"Date\")+o*i),r&&t._d.setTime(t._d.valueOf()+r*i),n&&a.updateOffset(t,o||s))}Ue.fn=Re.prototype,Ue.invalid=function(){return Ue(NaN)};var Je=Ze(1,\"add\"),Ke=Ze(-1,\"subtract\");function $e(t,e){var i=12*(e.year()-t.year())+(e.month()-t.month()),n=t.clone().add(i,\"months\");return-(i+(e-n<0?(e-n)/(n-t.clone().add(i-1,\"months\")):(e-n)/(t.clone().add(i+1,\"months\")-n)))||0}function Qe(t){var e;return void 0===t?this._locale._abbr:(null!=(e=he(t))&&(this._locale=e),this)}a.defaultFormat=\"YYYY-MM-DDTHH:mm:ssZ\",a.defaultFormatUtc=\"YYYY-MM-DDTHH:mm:ss[Z]\";var ti=D(\"moment().lang() is deprecated. Instead, use moment().localeData() to get the language configuration. Use moment().locale() to change languages.\",function(t){return void 0===t?this.localeData():this.locale(t)});function ei(){return this._locale}function ii(t,e){j(0,[t,t.length],0,e)}function ni(t,e,i,n,a){var r;return null==t?jt(this,n,a).year:(e>(r=Ut(t,n,a))&&(e=r),function(t,e,i,n,a){var r=Et(t,e,i,n,a),o=Vt(r.year,0,r.dayOfYear);return this.year(o.getUTCFullYear()),this.month(o.getUTCMonth()),this.date(o.getUTCDate()),this}.call(this,t,e,i,n,a))}j(0,[\"gg\",2],0,function(){return this.weekYear()%100}),j(0,[\"GG\",2],0,function(){return this.isoWeekYear()%100}),ii(\"gggg\",\"weekYear\"),ii(\"ggggg\",\"weekYear\"),ii(\"GGGG\",\"isoWeekYear\"),ii(\"GGGGG\",\"isoWeekYear\"),R(\"weekYear\",\"gg\"),R(\"isoWeekYear\",\"GG\"),N(\"weekYear\",1),N(\"isoWeekYear\",1),dt(\"G\",rt),dt(\"g\",rt),dt(\"GG\",$,Z),dt(\"gg\",$,Z),dt(\"GGGG\",it,J),dt(\"gggg\",it,J),dt(\"GGGGG\",nt,K),dt(\"ggggg\",nt,K),mt([\"gggg\",\"ggggg\",\"GGGG\",\"GGGGG\"],function(t,e,i,n){e[n.substr(0,2)]=w(t)}),mt([\"gg\",\"GG\"],function(t,e,i,n){e[n]=a.parseTwoDigitYear(t)}),j(\"Q\",0,\"Qo\",\"quarter\"),R(\"quarter\",\"Q\"),N(\"quarter\",7),dt(\"Q\",G),gt(\"Q\",function(t,e){e[vt]=3*(w(t)-1)}),j(\"D\",[\"DD\",2],\"Do\",\"date\"),R(\"date\",\"D\"),N(\"date\",9),dt(\"D\",$),dt(\"DD\",$,Z),dt(\"Do\",function(t,e){return t?e._dayOfMonthOrdinalParse||e._ordinalParse:e._dayOfMonthOrdinalParseLenient}),gt([\"D\",\"DD\"],yt),gt(\"Do\",function(t,e){e[yt]=w(t.match($)[0])});var ai=Tt(\"Date\",!0);j(\"DDD\",[\"DDDD\",3],\"DDDo\",\"dayOfYear\"),R(\"dayOfYear\",\"DDD\"),N(\"dayOfYear\",4),dt(\"DDD\",et),dt(\"DDDD\",X),gt([\"DDD\",\"DDDD\"],function(t,e,i){i._dayOfYear=w(t)}),j(\"m\",[\"mm\",2],0,\"minute\"),R(\"minute\",\"m\"),N(\"minute\",14),dt(\"m\",$),dt(\"mm\",$,Z),gt([\"m\",\"mm\"],xt);var ri=Tt(\"Minutes\",!1);j(\"s\",[\"ss\",2],0,\"second\"),R(\"second\",\"s\"),N(\"second\",15),dt(\"s\",$),dt(\"ss\",$,Z),gt([\"s\",\"ss\"],_t);var oi,si=Tt(\"Seconds\",!1);for(j(\"S\",0,0,function(){return~~(this.millisecond()/100)}),j(0,[\"SS\",2],0,function(){return~~(this.millisecond()/10)}),j(0,[\"SSS\",3],0,\"millisecond\"),j(0,[\"SSSS\",4],0,function(){return 10*this.millisecond()}),j(0,[\"SSSSS\",5],0,function(){return 100*this.millisecond()}),j(0,[\"SSSSSS\",6],0,function(){return 1e3*this.millisecond()}),j(0,[\"SSSSSSS\",7],0,function(){return 1e4*this.millisecond()}),j(0,[\"SSSSSSSS\",8],0,function(){return 1e5*this.millisecond()}),j(0,[\"SSSSSSSSS\",9],0,function(){return 1e6*this.millisecond()}),R(\"millisecond\",\"ms\"),N(\"millisecond\",16),dt(\"S\",et,G),dt(\"SS\",et,Z),dt(\"SSS\",et,X),oi=\"SSSS\";oi.length<=9;oi+=\"S\")dt(oi,at);function li(t,e){e[kt]=w(1e3*(\"0.\"+t))}for(oi=\"S\";oi.length<=9;oi+=\"S\")gt(oi,li);var ui=Tt(\"Milliseconds\",!1);j(\"z\",0,0,\"zoneAbbr\"),j(\"zz\",0,0,\"zoneName\");var di=x.prototype;function hi(t){return t}di.add=Je,di.calendar=function(t,e){var i=t||Te(),n=He(i,this).startOf(\"day\"),r=a.calendarFormat(this,n)||\"sameElse\",o=e&&(O(e[r])?e[r].call(this,i):e[r]);return this.format(o||this.localeData().calendar(r,this,Te(i)))},di.clone=function(){return new x(this)},di.diff=function(t,e,i){var n,a,r;if(!this.isValid())return NaN;if(!(n=He(t,this)).isValid())return NaN;switch(a=6e4*(n.utcOffset()-this.utcOffset()),e=L(e)){case\"year\":r=$e(this,n)/12;break;case\"month\":r=$e(this,n);break;case\"quarter\":r=$e(this,n)/3;break;case\"second\":r=(this-n)/1e3;break;case\"minute\":r=(this-n)/6e4;break;case\"hour\":r=(this-n)/36e5;break;case\"day\":r=(this-n-a)/864e5;break;case\"week\":r=(this-n-a)/6048e5;break;default:r=this-n}return i?r:k(r)},di.endOf=function(t){return void 0===(t=L(t))||\"millisecond\"===t?this:(\"date\"===t&&(t=\"day\"),this.startOf(t).add(1,\"isoWeek\"===t?\"week\":t).subtract(1,\"ms\"))},di.format=function(t){t||(t=this.isUtc()?a.defaultFormatUtc:a.defaultFormat);var e=U(this,t);return this.localeData().postformat(e)},di.from=function(t,e){return this.isValid()&&(_(t)&&t.isValid()||Te(t).isValid())?Ue({to:this,from:t}).locale(this.locale()).humanize(!e):this.localeData().invalidDate()},di.fromNow=function(t){return this.from(Te(),t)},di.to=function(t,e){return this.isValid()&&(_(t)&&t.isValid()||Te(t).isValid())?Ue({from:this,to:t}).locale(this.locale()).humanize(!e):this.localeData().invalidDate()},di.toNow=function(t){return this.to(Te(),t)},di.get=function(t){return O(this[t=L(t)])?this[t]():this},di.invalidAt=function(){return g(this).overflow},di.isAfter=function(t,e){var i=_(t)?t:Te(t);return!(!this.isValid()||!i.isValid())&&(\"millisecond\"===(e=L(s(e)?\"millisecond\":e))?this.valueOf()>i.valueOf():i.valueOf()<this.clone().startOf(e).valueOf())},di.isBefore=function(t,e){var i=_(t)?t:Te(t);return!(!this.isValid()||!i.isValid())&&(\"millisecond\"===(e=L(s(e)?\"millisecond\":e))?this.valueOf()<i.valueOf():this.clone().endOf(e).valueOf()<i.valueOf())},di.isBetween=function(t,e,i,n){return(\"(\"===(n=n||\"()\")[0]?this.isAfter(t,i):!this.isBefore(t,i))&&(\")\"===n[1]?this.isBefore(e,i):!this.isAfter(e,i))},di.isSame=function(t,e){var i,n=_(t)?t:Te(t);return!(!this.isValid()||!n.isValid())&&(\"millisecond\"===(e=L(e||\"millisecond\"))?this.valueOf()===n.valueOf():(i=n.valueOf(),this.clone().startOf(e).valueOf()<=i&&i<=this.clone().endOf(e).valueOf()))},di.isSameOrAfter=function(t,e){return this.isSame(t,e)||this.isAfter(t,e)},di.isSameOrBefore=function(t,e){return this.isSame(t,e)||this.isBefore(t,e)},di.isValid=function(){return m(this)},di.lang=ti,di.locale=Qe,di.localeData=ei,di.max=Ie,di.min=Oe,di.parsingFlags=function(){return c({},g(this))},di.set=function(t,e){if(\"object\"==typeof t)for(var i=function(t){var e=[];for(var i in t)e.push({unit:i,priority:Y[i]});return e.sort(function(t,e){return t.priority-e.priority}),e}(t=W(t)),n=0;n<i.length;n++)this[i[n].unit](t[i[n].unit]);else if(O(this[t=L(t)]))return this[t](e);return this},di.startOf=function(t){switch(t=L(t)){case\"year\":this.month(0);case\"quarter\":case\"month\":this.date(1);case\"week\":case\"isoWeek\":case\"day\":case\"date\":this.hours(0);case\"hour\":this.minutes(0);case\"minute\":this.seconds(0);case\"second\":this.milliseconds(0)}return\"week\"===t&&this.weekday(0),\"isoWeek\"===t&&this.isoWeekday(1),\"quarter\"===t&&this.month(3*Math.floor(this.month()/3)),this},di.subtract=Ke,di.toArray=function(){var t=this;return[t.year(),t.month(),t.date(),t.hour(),t.minute(),t.second(),t.millisecond()]},di.toObject=function(){var t=this;return{years:t.year(),months:t.month(),date:t.date(),hours:t.hours(),minutes:t.minutes(),seconds:t.seconds(),milliseconds:t.milliseconds()}},di.toDate=function(){return new Date(this.valueOf())},di.toISOString=function(t){if(!this.isValid())return null;var e=!0!==t,i=e?this.clone().utc():this;return i.year()<0||i.year()>9999?U(i,e?\"YYYYYY-MM-DD[T]HH:mm:ss.SSS[Z]\":\"YYYYYY-MM-DD[T]HH:mm:ss.SSSZ\"):O(Date.prototype.toISOString)?e?this.toDate().toISOString():new Date(this._d.valueOf()).toISOString().replace(\"Z\",U(i,\"Z\")):U(i,e?\"YYYY-MM-DD[T]HH:mm:ss.SSS[Z]\":\"YYYY-MM-DD[T]HH:mm:ss.SSSZ\")},di.inspect=function(){if(!this.isValid())return\"moment.invalid(/* \"+this._i+\" */)\";var t=\"moment\",e=\"\";this.isLocal()||(t=0===this.utcOffset()?\"moment.utc\":\"moment.parseZone\",e=\"Z\");var i=\"[\"+t+'(\"]',n=0<=this.year()&&this.year()<=9999?\"YYYY\":\"YYYYYY\",a=e+'[\")]';return this.format(i+n+\"-MM-DD[T]HH:mm:ss.SSS\"+a)},di.toJSON=function(){return this.isValid()?this.toISOString():null},di.toString=function(){return this.clone().locale(\"en\").format(\"ddd MMM DD YYYY HH:mm:ss [GMT]ZZ\")},di.unix=function(){return Math.floor(this.valueOf()/1e3)},di.valueOf=function(){return this._d.valueOf()-6e4*(this._offset||0)},di.creationData=function(){return{input:this._i,format:this._f,locale:this._locale,isUTC:this._isUTC,strict:this._strict}},di.year=Pt,di.isLeapYear=function(){return Dt(this.year())},di.weekYear=function(t){return ni.call(this,t,this.week(),this.weekday(),this.localeData()._week.dow,this.localeData()._week.doy)},di.isoWeekYear=function(t){return ni.call(this,t,this.isoWeek(),this.isoWeekday(),1,4)},di.quarter=di.quarters=function(t){return null==t?Math.ceil((this.month()+1)/3):this.month(3*(t-1)+this.month()%3)},di.month=Yt,di.daysInMonth=function(){return At(this.year(),this.month())},di.week=di.weeks=function(t){var e=this.localeData().week(this);return null==t?e:this.add(7*(t-e),\"d\")},di.isoWeek=di.isoWeeks=function(t){var e=jt(this,1,4).week;return null==t?e:this.add(7*(t-e),\"d\")},di.weeksInYear=function(){var t=this.localeData()._week;return Ut(this.year(),t.dow,t.doy)},di.isoWeeksInYear=function(){return Ut(this.year(),1,4)},di.date=ai,di.day=di.days=function(t){if(!this.isValid())return null!=t?this:NaN;var e,i,n=this._isUTC?this._d.getUTCDay():this._d.getDay();return null!=t?(e=t,i=this.localeData(),t=\"string\"!=typeof e?e:isNaN(e)?\"number\"==typeof(e=i.weekdaysParse(e))?e:null:parseInt(e,10),this.add(t-n,\"d\")):n},di.weekday=function(t){if(!this.isValid())return null!=t?this:NaN;var e=(this.day()+7-this.localeData()._week.dow)%7;return null==t?e:this.add(t-e,\"d\")},di.isoWeekday=function(t){if(!this.isValid())return null!=t?this:NaN;if(null!=t){var e=(i=t,n=this.localeData(),\"string\"==typeof i?n.weekdaysParse(i)%7||7:isNaN(i)?null:i);return this.day(this.day()%7?e:e-7)}return this.day()||7;var i,n},di.dayOfYear=function(t){var e=Math.round((this.clone().startOf(\"day\")-this.clone().startOf(\"year\"))/864e5)+1;return null==t?e:this.add(t-e,\"d\")},di.hour=di.hours=ne,di.minute=di.minutes=ri,di.second=di.seconds=si,di.millisecond=di.milliseconds=ui,di.utcOffset=function(t,e,i){var n,r=this._offset||0;if(!this.isValid())return null!=t?this:NaN;if(null!=t){if(\"string\"==typeof t){if(null===(t=ze(st,t)))return this}else Math.abs(t)<16&&!i&&(t*=60);return!this._isUTC&&e&&(n=Ve(this)),this._offset=t,this._isUTC=!0,null!=n&&this.add(n,\"m\"),r!==t&&(!e||this._changeInProgress?Xe(this,Ue(t-r,\"m\"),1,!1):this._changeInProgress||(this._changeInProgress=!0,a.updateOffset(this,!0),this._changeInProgress=null)),this}return this._isUTC?r:Ve(this)},di.utc=function(t){return this.utcOffset(0,t)},di.local=function(t){return this._isUTC&&(this.utcOffset(0,t),this._isUTC=!1,t&&this.subtract(Ve(this),\"m\")),this},di.parseZone=function(){if(null!=this._tzm)this.utcOffset(this._tzm,!1,!0);else if(\"string\"==typeof this._i){var t=ze(ot,this._i);null!=t?this.utcOffset(t):this.utcOffset(0,!0)}return this},di.hasAlignedHourOffset=function(t){return!!this.isValid()&&(t=t?Te(t).utcOffset():0,(this.utcOffset()-t)%60==0)},di.isDST=function(){return this.utcOffset()>this.clone().month(0).utcOffset()||this.utcOffset()>this.clone().month(5).utcOffset()},di.isLocal=function(){return!!this.isValid()&&!this._isUTC},di.isUtcOffset=function(){return!!this.isValid()&&this._isUTC},di.isUtc=Be,di.isUTC=Be,di.zoneAbbr=function(){return this._isUTC?\"UTC\":\"\"},di.zoneName=function(){return this._isUTC?\"Coordinated Universal Time\":\"\"},di.dates=D(\"dates accessor is deprecated. Use date instead.\",ai),di.months=D(\"months accessor is deprecated. Use month instead\",Yt),di.years=D(\"years accessor is deprecated. Use year instead\",Pt),di.zone=D(\"moment().zone is deprecated, use moment().utcOffset instead. http://momentjs.com/guides/#/warnings/zone/\",function(t,e){return null!=t?(\"string\"!=typeof t&&(t=-t),this.utcOffset(t,e),this):-this.utcOffset()}),di.isDSTShifted=D(\"isDSTShifted is deprecated. See http://momentjs.com/guides/#/warnings/dst-shifted/ for more information\",function(){if(!s(this._isDSTShifted))return this._isDSTShifted;var t={};if(y(t,this),(t=Ce(t))._a){var e=t._isUTC?f(t._a):Te(t._a);this._isDSTShifted=this.isValid()&&M(t._a,e.toArray())>0}else this._isDSTShifted=!1;return this._isDSTShifted});var ci=A.prototype;function fi(t,e,i,n){var a=he(),r=f().set(n,e);return a[i](r,t)}function gi(t,e,i){if(l(t)&&(e=t,t=void 0),t=t||\"\",null!=e)return fi(t,e,i,\"month\");var n,a=[];for(n=0;n<12;n++)a[n]=fi(t,n,i,\"month\");return a}function mi(t,e,i,n){\"boolean\"==typeof t?(l(e)&&(i=e,e=void 0),e=e||\"\"):(i=e=t,t=!1,l(e)&&(i=e,e=void 0),e=e||\"\");var a,r=he(),o=t?r._week.dow:0;if(null!=i)return fi(e,(i+o)%7,n,\"day\");var s=[];for(a=0;a<7;a++)s[a]=fi(e,(a+o)%7,n,\"day\");return s}ci.calendar=function(t,e,i){var n=this._calendar[t]||this._calendar.sameElse;return O(n)?n.call(e,i):n},ci.longDateFormat=function(t){var e=this._longDateFormat[t],i=this._longDateFormat[t.toUpperCase()];return e||!i?e:(this._longDateFormat[t]=i.replace(/MMMM|MM|DD|dddd/g,function(t){return t.slice(1)}),this._longDateFormat[t])},ci.invalidDate=function(){return this._invalidDate},ci.ordinal=function(t){return this._ordinal.replace(\"%d\",t)},ci.preparse=hi,ci.postformat=hi,ci.relativeTime=function(t,e,i,n){var a=this._relativeTime[i];return O(a)?a(t,e,i,n):a.replace(/%d/i,t)},ci.pastFuture=function(t,e){var i=this._relativeTime[t>0?\"future\":\"past\"];return O(i)?i(e):i.replace(/%s/i,e)},ci.set=function(t){var e,i;for(i in t)O(e=t[i])?this[i]=e:this[\"_\"+i]=e;this._config=t,this._dayOfMonthOrdinalParseLenient=new RegExp((this._dayOfMonthOrdinalParse.source||this._ordinalParse.source)+\"|\"+/\\d{1,2}/.source)},ci.months=function(t,e){return t?r(this._months)?this._months[t.month()]:this._months[(this._months.isFormat||Ft).test(e)?\"format\":\"standalone\"][t.month()]:r(this._months)?this._months:this._months.standalone},ci.monthsShort=function(t,e){return t?r(this._monthsShort)?this._monthsShort[t.month()]:this._monthsShort[Ft.test(e)?\"format\":\"standalone\"][t.month()]:r(this._monthsShort)?this._monthsShort:this._monthsShort.standalone},ci.monthsParse=function(t,e,i){var n,a,r;if(this._monthsParseExact)return function(t,e,i){var n,a,r,o=t.toLocaleLowerCase();if(!this._monthsParse)for(this._monthsParse=[],this._longMonthsParse=[],this._shortMonthsParse=[],n=0;n<12;++n)r=f([2e3,n]),this._shortMonthsParse[n]=this.monthsShort(r,\"\").toLocaleLowerCase(),this._longMonthsParse[n]=this.months(r,\"\").toLocaleLowerCase();return i?\"MMM\"===e?-1!==(a=Ct.call(this._shortMonthsParse,o))?a:null:-1!==(a=Ct.call(this._longMonthsParse,o))?a:null:\"MMM\"===e?-1!==(a=Ct.call(this._shortMonthsParse,o))?a:-1!==(a=Ct.call(this._longMonthsParse,o))?a:null:-1!==(a=Ct.call(this._longMonthsParse,o))?a:-1!==(a=Ct.call(this._shortMonthsParse,o))?a:null}.call(this,t,e,i);for(this._monthsParse||(this._monthsParse=[],this._longMonthsParse=[],this._shortMonthsParse=[]),n=0;n<12;n++){if(a=f([2e3,n]),i&&!this._longMonthsParse[n]&&(this._longMonthsParse[n]=new RegExp(\"^\"+this.months(a,\"\").replace(\".\",\"\")+\"$\",\"i\"),this._shortMonthsParse[n]=new RegExp(\"^\"+this.monthsShort(a,\"\").replace(\".\",\"\")+\"$\",\"i\")),i||this._monthsParse[n]||(r=\"^\"+this.months(a,\"\")+\"|^\"+this.monthsShort(a,\"\"),this._monthsParse[n]=new RegExp(r.replace(\".\",\"\"),\"i\")),i&&\"MMMM\"===e&&this._longMonthsParse[n].test(t))return n;if(i&&\"MMM\"===e&&this._shortMonthsParse[n].test(t))return n;if(!i&&this._monthsParse[n].test(t))return n}},ci.monthsRegex=function(t){return this._monthsParseExact?(h(this,\"_monthsRegex\")||Ht.call(this),t?this._monthsStrictRegex:this._monthsRegex):(h(this,\"_monthsRegex\")||(this._monthsRegex=zt),this._monthsStrictRegex&&t?this._monthsStrictRegex:this._monthsRegex)},ci.monthsShortRegex=function(t){return this._monthsParseExact?(h(this,\"_monthsRegex\")||Ht.call(this),t?this._monthsShortStrictRegex:this._monthsShortRegex):(h(this,\"_monthsShortRegex\")||(this._monthsShortRegex=Nt),this._monthsShortStrictRegex&&t?this._monthsShortStrictRegex:this._monthsShortRegex)},ci.week=function(t){return jt(t,this._week.dow,this._week.doy).week},ci.firstDayOfYear=function(){return this._week.doy},ci.firstDayOfWeek=function(){return this._week.dow},ci.weekdays=function(t,e){return t?r(this._weekdays)?this._weekdays[t.day()]:this._weekdays[this._weekdays.isFormat.test(e)?\"format\":\"standalone\"][t.day()]:r(this._weekdays)?this._weekdays:this._weekdays.standalone},ci.weekdaysMin=function(t){return t?this._weekdaysMin[t.day()]:this._weekdaysMin},ci.weekdaysShort=function(t){return t?this._weekdaysShort[t.day()]:this._weekdaysShort},ci.weekdaysParse=function(t,e,i){var n,a,r;if(this._weekdaysParseExact)return function(t,e,i){var n,a,r,o=t.toLocaleLowerCase();if(!this._weekdaysParse)for(this._weekdaysParse=[],this._shortWeekdaysParse=[],this._minWeekdaysParse=[],n=0;n<7;++n)r=f([2e3,1]).day(n),this._minWeekdaysParse[n]=this.weekdaysMin(r,\"\").toLocaleLowerCase(),this._shortWeekdaysParse[n]=this.weekdaysShort(r,\"\").toLocaleLowerCase(),this._weekdaysParse[n]=this.weekdays(r,\"\").toLocaleLowerCase();return i?\"dddd\"===e?-1!==(a=Ct.call(this._weekdaysParse,o))?a:null:\"ddd\"===e?-1!==(a=Ct.call(this._shortWeekdaysParse,o))?a:null:-1!==(a=Ct.call(this._minWeekdaysParse,o))?a:null:\"dddd\"===e?-1!==(a=Ct.call(this._weekdaysParse,o))?a:-1!==(a=Ct.call(this._shortWeekdaysParse,o))?a:-1!==(a=Ct.call(this._minWeekdaysParse,o))?a:null:\"ddd\"===e?-1!==(a=Ct.call(this._shortWeekdaysParse,o))?a:-1!==(a=Ct.call(this._weekdaysParse,o))?a:-1!==(a=Ct.call(this._minWeekdaysParse,o))?a:null:-1!==(a=Ct.call(this._minWeekdaysParse,o))?a:-1!==(a=Ct.call(this._weekdaysParse,o))?a:-1!==(a=Ct.call(this._shortWeekdaysParse,o))?a:null}.call(this,t,e,i);for(this._weekdaysParse||(this._weekdaysParse=[],this._minWeekdaysParse=[],this._shortWeekdaysParse=[],this._fullWeekdaysParse=[]),n=0;n<7;n++){if(a=f([2e3,1]).day(n),i&&!this._fullWeekdaysParse[n]&&(this._fullWeekdaysParse[n]=new RegExp(\"^\"+this.weekdays(a,\"\").replace(\".\",\".?\")+\"$\",\"i\"),this._shortWeekdaysParse[n]=new RegExp(\"^\"+this.weekdaysShort(a,\"\").replace(\".\",\".?\")+\"$\",\"i\"),this._minWeekdaysParse[n]=new RegExp(\"^\"+this.weekdaysMin(a,\"\").replace(\".\",\".?\")+\"$\",\"i\")),this._weekdaysParse[n]||(r=\"^\"+this.weekdays(a,\"\")+\"|^\"+this.weekdaysShort(a,\"\")+\"|^\"+this.weekdaysMin(a,\"\"),this._weekdaysParse[n]=new RegExp(r.replace(\".\",\"\"),\"i\")),i&&\"dddd\"===e&&this._fullWeekdaysParse[n].test(t))return n;if(i&&\"ddd\"===e&&this._shortWeekdaysParse[n].test(t))return n;if(i&&\"dd\"===e&&this._minWeekdaysParse[n].test(t))return n;if(!i&&this._weekdaysParse[n].test(t))return n}},ci.weekdaysRegex=function(t){return this._weekdaysParseExact?(h(this,\"_weekdaysRegex\")||$t.call(this),t?this._weekdaysStrictRegex:this._weekdaysRegex):(h(this,\"_weekdaysRegex\")||(this._weekdaysRegex=Xt),this._weekdaysStrictRegex&&t?this._weekdaysStrictRegex:this._weekdaysRegex)},ci.weekdaysShortRegex=function(t){return this._weekdaysParseExact?(h(this,\"_weekdaysRegex\")||$t.call(this),t?this._weekdaysShortStrictRegex:this._weekdaysShortRegex):(h(this,\"_weekdaysShortRegex\")||(this._weekdaysShortRegex=Jt),this._weekdaysShortStrictRegex&&t?this._weekdaysShortStrictRegex:this._weekdaysShortRegex)},ci.weekdaysMinRegex=function(t){return this._weekdaysParseExact?(h(this,\"_weekdaysRegex\")||$t.call(this),t?this._weekdaysMinStrictRegex:this._weekdaysMinRegex):(h(this,\"_weekdaysMinRegex\")||(this._weekdaysMinRegex=Kt),this._weekdaysMinStrictRegex&&t?this._weekdaysMinStrictRegex:this._weekdaysMinRegex)},ci.isPM=function(t){return\"p\"===(t+\"\").toLowerCase().charAt(0)},ci.meridiem=function(t,e,i){return t>11?i?\"pm\":\"PM\":i?\"am\":\"AM\"},ue(\"en\",{dayOfMonthOrdinalParse:/\\d{1,2}(th|st|nd|rd)/,ordinal:function(t){var e=t%10;return t+(1===w(t%100/10)?\"th\":1===e?\"st\":2===e?\"nd\":3===e?\"rd\":\"th\")}}),a.lang=D(\"moment.lang is deprecated. Use moment.locale instead.\",ue),a.langData=D(\"moment.langData is deprecated. Use moment.localeData instead.\",he);var pi=Math.abs;function vi(t,e,i,n){var a=Ue(e,i);return t._milliseconds+=n*a._milliseconds,t._days+=n*a._days,t._months+=n*a._months,t._bubble()}function yi(t){return t<0?Math.floor(t):Math.ceil(t)}function bi(t){return 4800*t/146097}function xi(t){return 146097*t/4800}function _i(t){return function(){return this.as(t)}}var ki=_i(\"ms\"),wi=_i(\"s\"),Mi=_i(\"m\"),Si=_i(\"h\"),Di=_i(\"d\"),Ci=_i(\"w\"),Pi=_i(\"M\"),Ti=_i(\"y\");function Oi(t){return function(){return this.isValid()?this._data[t]:NaN}}var Ii=Oi(\"milliseconds\"),Ai=Oi(\"seconds\"),Fi=Oi(\"minutes\"),Ri=Oi(\"hours\"),Li=Oi(\"days\"),Wi=Oi(\"months\"),Yi=Oi(\"years\");var Ni=Math.round,zi={ss:44,s:45,m:45,h:22,d:26,M:11};var Hi=Math.abs;function Vi(t){return(t>0)-(t<0)||+t}function Bi(){if(!this.isValid())return this.localeData().invalidDate();var t,e,i=Hi(this._milliseconds)/1e3,n=Hi(this._days),a=Hi(this._months);e=k((t=k(i/60))/60),i%=60,t%=60;var r=k(a/12),o=a%=12,s=n,l=e,u=t,d=i?i.toFixed(3).replace(/\\.?0+$/,\"\"):\"\",h=this.asSeconds();if(!h)return\"P0D\";var c=h<0?\"-\":\"\",f=Vi(this._months)!==Vi(h)?\"-\":\"\",g=Vi(this._days)!==Vi(h)?\"-\":\"\",m=Vi(this._milliseconds)!==Vi(h)?\"-\":\"\";return c+\"P\"+(r?f+r+\"Y\":\"\")+(o?f+o+\"M\":\"\")+(s?g+s+\"D\":\"\")+(l||u||d?\"T\":\"\")+(l?m+l+\"H\":\"\")+(u?m+u+\"M\":\"\")+(d?m+d+\"S\":\"\")}var Ei=Re.prototype;return Ei.isValid=function(){return this._isValid},Ei.abs=function(){var t=this._data;return this._milliseconds=pi(this._milliseconds),this._days=pi(this._days),this._months=pi(this._months),t.milliseconds=pi(t.milliseconds),t.seconds=pi(t.seconds),t.minutes=pi(t.minutes),t.hours=pi(t.hours),t.months=pi(t.months),t.years=pi(t.years),this},Ei.add=function(t,e){return vi(this,t,e,1)},Ei.subtract=function(t,e){return vi(this,t,e,-1)},Ei.as=function(t){if(!this.isValid())return NaN;var e,i,n=this._milliseconds;if(\"month\"===(t=L(t))||\"year\"===t)return e=this._days+n/864e5,i=this._months+bi(e),\"month\"===t?i:i/12;switch(e=this._days+Math.round(xi(this._months)),t){case\"week\":return e/7+n/6048e5;case\"day\":return e+n/864e5;case\"hour\":return 24*e+n/36e5;case\"minute\":return 1440*e+n/6e4;case\"second\":return 86400*e+n/1e3;case\"millisecond\":return Math.floor(864e5*e)+n;default:throw new Error(\"Unknown unit \"+t)}},Ei.asMilliseconds=ki,Ei.asSeconds=wi,Ei.asMinutes=Mi,Ei.asHours=Si,Ei.asDays=Di,Ei.asWeeks=Ci,Ei.asMonths=Pi,Ei.asYears=Ti,Ei.valueOf=function(){return this.isValid()?this._milliseconds+864e5*this._days+this._months%12*2592e6+31536e6*w(this._months/12):NaN},Ei._bubble=function(){var t,e,i,n,a,r=this._milliseconds,o=this._days,s=this._months,l=this._data;return r>=0&&o>=0&&s>=0||r<=0&&o<=0&&s<=0||(r+=864e5*yi(xi(s)+o),o=0,s=0),l.milliseconds=r%1e3,t=k(r/1e3),l.seconds=t%60,e=k(t/60),l.minutes=e%60,i=k(e/60),l.hours=i%24,s+=a=k(bi(o+=k(i/24))),o-=yi(xi(a)),n=k(s/12),s%=12,l.days=o,l.months=s,l.years=n,this},Ei.clone=function(){return Ue(this)},Ei.get=function(t){return t=L(t),this.isValid()?this[t+\"s\"]():NaN},Ei.milliseconds=Ii,Ei.seconds=Ai,Ei.minutes=Fi,Ei.hours=Ri,Ei.days=Li,Ei.weeks=function(){return k(this.days()/7)},Ei.months=Wi,Ei.years=Yi,Ei.humanize=function(t){if(!this.isValid())return this.localeData().invalidDate();var e,i,n,a,r,o,s,l,u,d,h,c=this.localeData(),f=(i=!t,n=c,a=Ue(e=this).abs(),r=Ni(a.as(\"s\")),o=Ni(a.as(\"m\")),s=Ni(a.as(\"h\")),l=Ni(a.as(\"d\")),u=Ni(a.as(\"M\")),d=Ni(a.as(\"y\")),(h=r<=zi.ss&&[\"s\",r]||r<zi.s&&[\"ss\",r]||o<=1&&[\"m\"]||o<zi.m&&[\"mm\",o]||s<=1&&[\"h\"]||s<zi.h&&[\"hh\",s]||l<=1&&[\"d\"]||l<zi.d&&[\"dd\",l]||u<=1&&[\"M\"]||u<zi.M&&[\"MM\",u]||d<=1&&[\"y\"]||[\"yy\",d])[2]=i,h[3]=+e>0,h[4]=n,function(t,e,i,n,a){return a.relativeTime(e||1,!!i,t,n)}.apply(null,h));return t&&(f=c.pastFuture(+this,f)),c.postformat(f)},Ei.toISOString=Bi,Ei.toString=Bi,Ei.toJSON=Bi,Ei.locale=Qe,Ei.localeData=ei,Ei.toIsoString=D(\"toIsoString() is deprecated. Please use toISOString() instead (notice the capitals)\",Bi),Ei.lang=ti,j(\"X\",0,0,\"unix\"),j(\"x\",0,0,\"valueOf\"),dt(\"x\",rt),dt(\"X\",/[+-]?\\d+(\\.\\d{1,3})?/),gt(\"X\",function(t,e,i){i._d=new Date(1e3*parseFloat(t,10))}),gt(\"x\",function(t,e,i){i._d=new Date(w(t))}),a.version=\"2.20.1\",i=Te,a.fn=di,a.min=function(){return Ae(\"isBefore\",[].slice.call(arguments,0))},a.max=function(){return Ae(\"isAfter\",[].slice.call(arguments,0))},a.now=function(){return Date.now?Date.now():+new Date},a.utc=f,a.unix=function(t){return Te(1e3*t)},a.months=function(t,e){return gi(t,e,\"months\")},a.isDate=u,a.locale=ue,a.invalid=p,a.duration=Ue,a.isMoment=_,a.weekdays=function(t,e,i){return mi(t,e,i,\"weekdays\")},a.parseZone=function(){return Te.apply(null,arguments).parseZone()},a.localeData=he,a.isDuration=Le,a.monthsShort=function(t,e){return gi(t,e,\"monthsShort\")},a.weekdaysMin=function(t,e,i){return mi(t,e,i,\"weekdaysMin\")},a.defineLocale=de,a.updateLocale=function(t,e){if(null!=e){var i,n,a=ae;null!=(n=le(t))&&(a=n._config),(i=new A(e=I(a,e))).parentLocale=re[t],re[t]=i,ue(t)}else null!=re[t]&&(null!=re[t].parentLocale?re[t]=re[t].parentLocale:null!=re[t]&&delete re[t]);return re[t]},a.locales=function(){return C(re)},a.weekdaysShort=function(t,e,i){return mi(t,e,i,\"weekdaysShort\")},a.normalizeUnits=L,a.relativeTimeRounding=function(t){return void 0===t?Ni:\"function\"==typeof t&&(Ni=t,!0)},a.relativeTimeThreshold=function(t,e){return void 0!==zi[t]&&(void 0===e?zi[t]:(zi[t]=e,\"s\"===t&&(zi.ss=e-1),!0))},a.calendarFormat=function(t,e){var i=t.diff(e,\"days\",!0);return i<-6?\"sameElse\":i<-1?\"lastWeek\":i<0?\"lastDay\":i<1?\"sameDay\":i<2?\"nextDay\":i<7?\"nextWeek\":\"sameElse\"},a.prototype=di,a.HTML5_FMT={DATETIME_LOCAL:\"YYYY-MM-DDTHH:mm\",DATETIME_LOCAL_SECONDS:\"YYYY-MM-DDTHH:mm:ss\",DATETIME_LOCAL_MS:\"YYYY-MM-DDTHH:mm:ss.SSS\",DATE:\"YYYY-MM-DD\",TIME:\"HH:mm\",TIME_SECONDS:\"HH:mm:ss\",TIME_MS:\"HH:mm:ss.SSS\",WEEK:\"YYYY-[W]WW\",MONTH:\"YYYY-MM\"},a},\"object\"==typeof i&&void 0!==e?e.exports=a():n.moment=a()},{}],7:[function(t,e,i){var n=t(29)();n.helpers=t(45),t(27)(n),n.defaults=t(25),n.Element=t(26),n.elements=t(40),n.Interaction=t(28),n.layouts=t(30),n.platform=t(48),n.plugins=t(31),n.Ticks=t(34),t(22)(n),t(23)(n),t(24)(n),t(33)(n),t(32)(n),t(35)(n),t(55)(n),t(53)(n),t(54)(n),t(56)(n),t(57)(n),t(58)(n),t(15)(n),t(16)(n),t(17)(n),t(18)(n),t(19)(n),t(20)(n),t(21)(n),t(8)(n),t(9)(n),t(10)(n),t(11)(n),t(12)(n),t(13)(n),t(14)(n);var a=t(49);for(var r in a)a.hasOwnProperty(r)&&n.plugins.register(a[r]);n.platform.initialize(),e.exports=n,\"undefined\"!=typeof window&&(window.Chart=n),n.Legend=a.legend._element,n.Title=a.title._element,n.pluginService=n.plugins,n.PluginBase=n.Element.extend({}),n.canvasHelpers=n.helpers.canvas,n.layoutService=n.layouts},{10:10,11:11,12:12,13:13,14:14,15:15,16:16,17:17,18:18,19:19,20:20,21:21,22:22,23:23,24:24,25:25,26:26,27:27,28:28,29:29,30:30,31:31,32:32,33:33,34:34,35:35,40:40,45:45,48:48,49:49,53:53,54:54,55:55,56:56,57:57,58:58,8:8,9:9}],8:[function(t,e,i){\"use strict\";e.exports=function(t){t.Bar=function(e,i){return i.type=\"bar\",new t(e,i)}}},{}],9:[function(t,e,i){\"use strict\";e.exports=function(t){t.Bubble=function(e,i){return i.type=\"bubble\",new t(e,i)}}},{}],10:[function(t,e,i){\"use strict\";e.exports=function(t){t.Doughnut=function(e,i){return i.type=\"doughnut\",new t(e,i)}}},{}],11:[function(t,e,i){\"use strict\";e.exports=function(t){t.Line=function(e,i){return i.type=\"line\",new t(e,i)}}},{}],12:[function(t,e,i){\"use strict\";e.exports=function(t){t.PolarArea=function(e,i){return i.type=\"polarArea\",new t(e,i)}}},{}],13:[function(t,e,i){\"use strict\";e.exports=function(t){t.Radar=function(e,i){return i.type=\"radar\",new t(e,i)}}},{}],14:[function(t,e,i){\"use strict\";e.exports=function(t){t.Scatter=function(e,i){return i.type=\"scatter\",new t(e,i)}}},{}],15:[function(t,e,i){\"use strict\";var n=t(25),a=t(40),r=t(45);n._set(\"bar\",{hover:{mode:\"label\"},scales:{xAxes:[{type:\"category\",categoryPercentage:.8,barPercentage:.9,offset:!0,gridLines:{offsetGridLines:!0}}],yAxes:[{type:\"linear\"}]}}),n._set(\"horizontalBar\",{hover:{mode:\"index\",axis:\"y\"},scales:{xAxes:[{type:\"linear\",position:\"bottom\"}],yAxes:[{position:\"left\",type:\"category\",categoryPercentage:.8,barPercentage:.9,offset:!0,gridLines:{offsetGridLines:!0}}]},elements:{rectangle:{borderSkipped:\"left\"}},tooltips:{callbacks:{title:function(t,e){var i=\"\";return t.length>0&&(t[0].yLabel?i=t[0].yLabel:e.labels.length>0&&t[0].index<e.labels.length&&(i=e.labels[t[0].index])),i},label:function(t,e){return(e.datasets[t.datasetIndex].label||\"\")+\": \"+t.xLabel}},mode:\"index\",axis:\"y\"}}),e.exports=function(t){t.controllers.bar=t.DatasetController.extend({dataElementType:a.Rectangle,initialize:function(){var e;t.DatasetController.prototype.initialize.apply(this,arguments),(e=this.getMeta()).stack=this.getDataset().stack,e.bar=!0},update:function(t){var e,i,n=this.getMeta().data;for(this._ruler=this.getRuler(),e=0,i=n.length;e<i;++e)this.updateElement(n[e],e,t)},updateElement:function(t,e,i){var n=this,a=n.chart,o=n.getMeta(),s=n.getDataset(),l=t.custom||{},u=a.options.elements.rectangle;t._xScale=n.getScaleForId(o.xAxisID),t._yScale=n.getScaleForId(o.yAxisID),t._datasetIndex=n.index,t._index=e,t._model={datasetLabel:s.label,label:a.data.labels[e],borderSkipped:l.borderSkipped?l.borderSkipped:u.borderSkipped,backgroundColor:l.backgroundColor?l.backgroundColor:r.valueAtIndexOrDefault(s.backgroundColor,e,u.backgroundColor),borderColor:l.borderColor?l.borderColor:r.valueAtIndexOrDefault(s.borderColor,e,u.borderColor),borderWidth:l.borderWidth?l.borderWidth:r.valueAtIndexOrDefault(s.borderWidth,e,u.borderWidth)},n.updateElementGeometry(t,e,i),t.pivot()},updateElementGeometry:function(t,e,i){var n=this,a=t._model,r=n.getValueScale(),o=r.getBasePixel(),s=r.isHorizontal(),l=n._ruler||n.getRuler(),u=n.calculateBarValuePixels(n.index,e),d=n.calculateBarIndexPixels(n.index,e,l);a.horizontal=s,a.base=i?o:u.base,a.x=s?i?o:u.head:d.center,a.y=s?d.center:i?o:u.head,a.height=s?d.size:void 0,a.width=s?void 0:d.size},getValueScaleId:function(){return this.getMeta().yAxisID},getIndexScaleId:function(){return this.getMeta().xAxisID},getValueScale:function(){return this.getScaleForId(this.getValueScaleId())},getIndexScale:function(){return this.getScaleForId(this.getIndexScaleId())},_getStacks:function(t){var e,i,n=this.chart,a=this.getIndexScale().options.stacked,r=void 0===t?n.data.datasets.length:t+1,o=[];for(e=0;e<r;++e)(i=n.getDatasetMeta(e)).bar&&n.isDatasetVisible(e)&&(!1===a||!0===a&&-1===o.indexOf(i.stack)||void 0===a&&(void 0===i.stack||-1===o.indexOf(i.stack)))&&o.push(i.stack);return o},getStackCount:function(){return this._getStacks().length},getStackIndex:function(t,e){var i=this._getStacks(t),n=void 0!==e?i.indexOf(e):-1;return-1===n?i.length-1:n},getRuler:function(){var t,e,i=this.getIndexScale(),n=this.getStackCount(),a=this.index,o=i.isHorizontal(),s=o?i.left:i.top,l=s+(o?i.width:i.height),u=[];for(t=0,e=this.getMeta().data.length;t<e;++t)u.push(i.getPixelForValue(null,t,a));return{min:r.isNullOrUndef(i.options.barThickness)?function(t,e){var i,n,a,r,o=t.isHorizontal()?t.width:t.height,s=t.getTicks();for(a=1,r=e.length;a<r;++a)o=Math.min(o,e[a]-e[a-1]);for(a=0,r=s.length;a<r;++a)n=t.getPixelForTick(a),o=a>0?Math.min(o,n-i):o,i=n;return o}(i,u):-1,pixels:u,start:s,end:l,stackCount:n,scale:i}},calculateBarValuePixels:function(t,e){var i,n,a,r,o,s,l=this.chart,u=this.getMeta(),d=this.getValueScale(),h=l.data.datasets,c=d.getRightValue(h[t].data[e]),f=d.options.stacked,g=u.stack,m=0;if(f||void 0===f&&void 0!==g)for(i=0;i<t;++i)(n=l.getDatasetMeta(i)).bar&&n.stack===g&&n.controller.getValueScaleId()===d.id&&l.isDatasetVisible(i)&&(a=d.getRightValue(h[i].data[e]),(c<0&&a<0||c>=0&&a>0)&&(m+=a));return r=d.getPixelForValue(m),{size:s=((o=d.getPixelForValue(m+c))-r)/2,base:r,head:o,center:o+s/2}},calculateBarIndexPixels:function(t,e,i){var n,a,o,s,l,u,d,h,c,f,g,m,p,v,y,b,x,_=i.scale.options,k=\"flex\"===_.barThickness?(c=e,g=_,p=(f=i).pixels,v=p[c],y=c>0?p[c-1]:null,b=c<p.length-1?p[c+1]:null,x=g.categoryPercentage,null===y&&(y=v-(null===b?f.end-v:b-v)),null===b&&(b=v+v-y),m=v-(v-y)/2*x,{chunk:(b-y)/2*x/f.stackCount,ratio:g.barPercentage,start:m}):(n=e,a=i,u=(o=_).barThickness,d=a.stackCount,h=a.pixels[n],r.isNullOrUndef(u)?(s=a.min*o.categoryPercentage,l=o.barPercentage):(s=u*d,l=1),{chunk:s/d,ratio:l,start:h-s/2}),w=this.getStackIndex(t,this.getMeta().stack),M=k.start+k.chunk*w+k.chunk/2,S=Math.min(r.valueOrDefault(_.maxBarThickness,1/0),k.chunk*k.ratio);return{base:M-S/2,head:M+S/2,center:M,size:S}},draw:function(){var t=this.chart,e=this.getValueScale(),i=this.getMeta().data,n=this.getDataset(),a=i.length,o=0;for(r.canvas.clipArea(t.ctx,t.chartArea);o<a;++o)isNaN(e.getRightValue(n.data[o]))||i[o].draw();r.canvas.unclipArea(t.ctx)},setHoverStyle:function(t){var e=this.chart.data.datasets[t._datasetIndex],i=t._index,n=t.custom||{},a=t._model;a.backgroundColor=n.hoverBackgroundColor?n.hoverBackgroundColor:r.valueAtIndexOrDefault(e.hoverBackgroundColor,i,r.getHoverColor(a.backgroundColor)),a.borderColor=n.hoverBorderColor?n.hoverBorderColor:r.valueAtIndexOrDefault(e.hoverBorderColor,i,r.getHoverColor(a.borderColor)),a.borderWidth=n.hoverBorderWidth?n.hoverBorderWidth:r.valueAtIndexOrDefault(e.hoverBorderWidth,i,a.borderWidth)},removeHoverStyle:function(t){var e=this.chart.data.datasets[t._datasetIndex],i=t._index,n=t.custom||{},a=t._model,o=this.chart.options.elements.rectangle;a.backgroundColor=n.backgroundColor?n.backgroundColor:r.valueAtIndexOrDefault(e.backgroundColor,i,o.backgroundColor),a.borderColor=n.borderColor?n.borderColor:r.valueAtIndexOrDefault(e.borderColor,i,o.borderColor),a.borderWidth=n.borderWidth?n.borderWidth:r.valueAtIndexOrDefault(e.borderWidth,i,o.borderWidth)}}),t.controllers.horizontalBar=t.controllers.bar.extend({getValueScaleId:function(){return this.getMeta().xAxisID},getIndexScaleId:function(){return this.getMeta().yAxisID}})}},{25:25,40:40,45:45}],16:[function(t,e,i){\"use strict\";var n=t(25),a=t(40),r=t(45);n._set(\"bubble\",{hover:{mode:\"single\"},scales:{xAxes:[{type:\"linear\",position:\"bottom\",id:\"x-axis-0\"}],yAxes:[{type:\"linear\",position:\"left\",id:\"y-axis-0\"}]},tooltips:{callbacks:{title:function(){return\"\"},label:function(t,e){var i=e.datasets[t.datasetIndex].label||\"\",n=e.datasets[t.datasetIndex].data[t.index];return i+\": (\"+t.xLabel+\", \"+t.yLabel+\", \"+n.r+\")\"}}}}),e.exports=function(t){t.controllers.bubble=t.DatasetController.extend({dataElementType:a.Point,update:function(t){var e=this,i=e.getMeta().data;r.each(i,function(i,n){e.updateElement(i,n,t)})},updateElement:function(t,e,i){var n=this,a=n.getMeta(),r=t.custom||{},o=n.getScaleForId(a.xAxisID),s=n.getScaleForId(a.yAxisID),l=n._resolveElementOptions(t,e),u=n.getDataset().data[e],d=n.index,h=i?o.getPixelForDecimal(.5):o.getPixelForValue(\"object\"==typeof u?u:NaN,e,d),c=i?s.getBasePixel():s.getPixelForValue(u,e,d);t._xScale=o,t._yScale=s,t._options=l,t._datasetIndex=d,t._index=e,t._model={backgroundColor:l.backgroundColor,borderColor:l.borderColor,borderWidth:l.borderWidth,hitRadius:l.hitRadius,pointStyle:l.pointStyle,radius:i?0:l.radius,skip:r.skip||isNaN(h)||isNaN(c),x:h,y:c},t.pivot()},setHoverStyle:function(t){var e=t._model,i=t._options;e.backgroundColor=r.valueOrDefault(i.hoverBackgroundColor,r.getHoverColor(i.backgroundColor)),e.borderColor=r.valueOrDefault(i.hoverBorderColor,r.getHoverColor(i.borderColor)),e.borderWidth=r.valueOrDefault(i.hoverBorderWidth,i.borderWidth),e.radius=i.radius+i.hoverRadius},removeHoverStyle:function(t){var e=t._model,i=t._options;e.backgroundColor=i.backgroundColor,e.borderColor=i.borderColor,e.borderWidth=i.borderWidth,e.radius=i.radius},_resolveElementOptions:function(t,e){var i,n,a,o=this.chart,s=o.data.datasets[this.index],l=t.custom||{},u=o.options.elements.point,d=r.options.resolve,h=s.data[e],c={},f={chart:o,dataIndex:e,dataset:s,datasetIndex:this.index},g=[\"backgroundColor\",\"borderColor\",\"borderWidth\",\"hoverBackgroundColor\",\"hoverBorderColor\",\"hoverBorderWidth\",\"hoverRadius\",\"hitRadius\",\"pointStyle\"];for(i=0,n=g.length;i<n;++i)c[a=g[i]]=d([l[a],s[a],u[a]],f,e);return c.radius=d([l.radius,h?h.r:void 0,s.radius,u.radius],f,e),c}})}},{25:25,40:40,45:45}],17:[function(t,e,i){\"use strict\";var n=t(25),a=t(40),r=t(45);n._set(\"doughnut\",{animation:{animateRotate:!0,animateScale:!1},hover:{mode:\"single\"},legendCallback:function(t){var e=[];e.push('<ul class=\"'+t.id+'-legend\">');var i=t.data,n=i.datasets,a=i.labels;if(n.length)for(var r=0;r<n[0].data.length;++r)e.push('<li><span style=\"background-color:'+n[0].backgroundColor[r]+'\"></span>'),a[r]&&e.push(a[r]),e.push(\"</li>\");return e.push(\"</ul>\"),e.join(\"\")},legend:{labels:{generateLabels:function(t){var e=t.data;return e.labels.length&&e.datasets.length?e.labels.map(function(i,n){var a=t.getDatasetMeta(0),o=e.datasets[0],s=a.data[n],l=s&&s.custom||{},u=r.valueAtIndexOrDefault,d=t.options.elements.arc;return{text:i,fillStyle:l.backgroundColor?l.backgroundColor:u(o.backgroundColor,n,d.backgroundColor),strokeStyle:l.borderColor?l.borderColor:u(o.borderColor,n,d.borderColor),lineWidth:l.borderWidth?l.borderWidth:u(o.borderWidth,n,d.borderWidth),hidden:isNaN(o.data[n])||a.data[n].hidden,index:n}}):[]}},onClick:function(t,e){var i,n,a,r=e.index,o=this.chart;for(i=0,n=(o.data.datasets||[]).length;i<n;++i)(a=o.getDatasetMeta(i)).data[r]&&(a.data[r].hidden=!a.data[r].hidden);o.update()}},cutoutPercentage:50,rotation:-.5*Math.PI,circumference:2*Math.PI,tooltips:{callbacks:{title:function(){return\"\"},label:function(t,e){var i=e.labels[t.index],n=\": \"+e.datasets[t.datasetIndex].data[t.index];return r.isArray(i)?(i=i.slice())[0]+=n:i+=n,i}}}}),n._set(\"pie\",r.clone(n.doughnut)),n._set(\"pie\",{cutoutPercentage:0}),e.exports=function(t){t.controllers.doughnut=t.controllers.pie=t.DatasetController.extend({dataElementType:a.Arc,linkScales:r.noop,getRingIndex:function(t){for(var e=0,i=0;i<t;++i)this.chart.isDatasetVisible(i)&&++e;return e},update:function(t){var e=this,i=e.chart,n=i.chartArea,a=i.options,o=a.elements.arc,s=n.right-n.left-o.borderWidth,l=n.bottom-n.top-o.borderWidth,u=Math.min(s,l),d={x:0,y:0},h=e.getMeta(),c=a.cutoutPercentage,f=a.circumference;if(f<2*Math.PI){var g=a.rotation%(2*Math.PI),m=(g+=2*Math.PI*(g>=Math.PI?-1:g<-Math.PI?1:0))+f,p=Math.cos(g),v=Math.sin(g),y=Math.cos(m),b=Math.sin(m),x=g<=0&&m>=0||g<=2*Math.PI&&2*Math.PI<=m,_=g<=.5*Math.PI&&.5*Math.PI<=m||g<=2.5*Math.PI&&2.5*Math.PI<=m,k=g<=-Math.PI&&-Math.PI<=m||g<=Math.PI&&Math.PI<=m,w=g<=.5*-Math.PI&&.5*-Math.PI<=m||g<=1.5*Math.PI&&1.5*Math.PI<=m,M=c/100,S=k?-1:Math.min(p*(p<0?1:M),y*(y<0?1:M)),D=w?-1:Math.min(v*(v<0?1:M),b*(b<0?1:M)),C=x?1:Math.max(p*(p>0?1:M),y*(y>0?1:M)),P=_?1:Math.max(v*(v>0?1:M),b*(b>0?1:M)),T=.5*(C-S),O=.5*(P-D);u=Math.min(s/T,l/O),d={x:-.5*(C+S),y:-.5*(P+D)}}i.borderWidth=e.getMaxBorderWidth(h.data),i.outerRadius=Math.max((u-i.borderWidth)/2,0),i.innerRadius=Math.max(c?i.outerRadius/100*c:0,0),i.radiusLength=(i.outerRadius-i.innerRadius)/i.getVisibleDatasetCount(),i.offsetX=d.x*i.outerRadius,i.offsetY=d.y*i.outerRadius,h.total=e.calculateTotal(),e.outerRadius=i.outerRadius-i.radiusLength*e.getRingIndex(e.index),e.innerRadius=Math.max(e.outerRadius-i.radiusLength,0),r.each(h.data,function(i,n){e.updateElement(i,n,t)})},updateElement:function(t,e,i){var n=this,a=n.chart,o=a.chartArea,s=a.options,l=s.animation,u=(o.left+o.right)/2,d=(o.top+o.bottom)/2,h=s.rotation,c=s.rotation,f=n.getDataset(),g=i&&l.animateRotate?0:t.hidden?0:n.calculateCircumference(f.data[e])*(s.circumference/(2*Math.PI)),m=i&&l.animateScale?0:n.innerRadius,p=i&&l.animateScale?0:n.outerRadius,v=r.valueAtIndexOrDefault;r.extend(t,{_datasetIndex:n.index,_index:e,_model:{x:u+a.offsetX,y:d+a.offsetY,startAngle:h,endAngle:c,circumference:g,outerRadius:p,innerRadius:m,label:v(f.label,e,a.data.labels[e])}});var y=t._model;this.removeHoverStyle(t),i&&l.animateRotate||(y.startAngle=0===e?s.rotation:n.getMeta().data[e-1]._model.endAngle,y.endAngle=y.startAngle+y.circumference),t.pivot()},removeHoverStyle:function(e){t.DatasetController.prototype.removeHoverStyle.call(this,e,this.chart.options.elements.arc)},calculateTotal:function(){var t,e=this.getDataset(),i=this.getMeta(),n=0;return r.each(i.data,function(i,a){t=e.data[a],isNaN(t)||i.hidden||(n+=Math.abs(t))}),n},calculateCircumference:function(t){var e=this.getMeta().total;return e>0&&!isNaN(t)?2*Math.PI*(Math.abs(t)/e):0},getMaxBorderWidth:function(t){for(var e,i,n=0,a=this.index,r=t.length,o=0;o<r;o++)e=t[o]._model?t[o]._model.borderWidth:0,n=(i=t[o]._chart?t[o]._chart.config.data.datasets[a].hoverBorderWidth:0)>(n=e>n?e:n)?i:n;return n}})}},{25:25,40:40,45:45}],18:[function(t,e,i){\"use strict\";var n=t(25),a=t(40),r=t(45);n._set(\"line\",{showLines:!0,spanGaps:!1,hover:{mode:\"label\"},scales:{xAxes:[{type:\"category\",id:\"x-axis-0\"}],yAxes:[{type:\"linear\",id:\"y-axis-0\"}]}}),e.exports=function(t){function e(t,e){return r.valueOrDefault(t.showLine,e.showLines)}t.controllers.line=t.DatasetController.extend({datasetElementType:a.Line,dataElementType:a.Point,update:function(t){var i,n,a,o=this,s=o.getMeta(),l=s.dataset,u=s.data||[],d=o.chart.options,h=d.elements.line,c=o.getScaleForId(s.yAxisID),f=o.getDataset(),g=e(f,d);for(g&&(a=l.custom||{},void 0!==f.tension&&void 0===f.lineTension&&(f.lineTension=f.tension),l._scale=c,l._datasetIndex=o.index,l._children=u,l._model={spanGaps:f.spanGaps?f.spanGaps:d.spanGaps,tension:a.tension?a.tension:r.valueOrDefault(f.lineTension,h.tension),backgroundColor:a.backgroundColor?a.backgroundColor:f.backgroundColor||h.backgroundColor,borderWidth:a.borderWidth?a.borderWidth:f.borderWidth||h.borderWidth,borderColor:a.borderColor?a.borderColor:f.borderColor||h.borderColor,borderCapStyle:a.borderCapStyle?a.borderCapStyle:f.borderCapStyle||h.borderCapStyle,borderDash:a.borderDash?a.borderDash:f.borderDash||h.borderDash,borderDashOffset:a.borderDashOffset?a.borderDashOffset:f.borderDashOffset||h.borderDashOffset,borderJoinStyle:a.borderJoinStyle?a.borderJoinStyle:f.borderJoinStyle||h.borderJoinStyle,fill:a.fill?a.fill:void 0!==f.fill?f.fill:h.fill,steppedLine:a.steppedLine?a.steppedLine:r.valueOrDefault(f.steppedLine,h.stepped),cubicInterpolationMode:a.cubicInterpolationMode?a.cubicInterpolationMode:r.valueOrDefault(f.cubicInterpolationMode,h.cubicInterpolationMode)},l.pivot()),i=0,n=u.length;i<n;++i)o.updateElement(u[i],i,t);for(g&&0!==l._model.tension&&o.updateBezierControlPoints(),i=0,n=u.length;i<n;++i)u[i].pivot()},getPointBackgroundColor:function(t,e){var i=this.chart.options.elements.point.backgroundColor,n=this.getDataset(),a=t.custom||{};return a.backgroundColor?i=a.backgroundColor:n.pointBackgroundColor?i=r.valueAtIndexOrDefault(n.pointBackgroundColor,e,i):n.backgroundColor&&(i=n.backgroundColor),i},getPointBorderColor:function(t,e){var i=this.chart.options.elements.point.borderColor,n=this.getDataset(),a=t.custom||{};return a.borderColor?i=a.borderColor:n.pointBorderColor?i=r.valueAtIndexOrDefault(n.pointBorderColor,e,i):n.borderColor&&(i=n.borderColor),i},getPointBorderWidth:function(t,e){var i=this.chart.options.elements.point.borderWidth,n=this.getDataset(),a=t.custom||{};return isNaN(a.borderWidth)?!isNaN(n.pointBorderWidth)||r.isArray(n.pointBorderWidth)?i=r.valueAtIndexOrDefault(n.pointBorderWidth,e,i):isNaN(n.borderWidth)||(i=n.borderWidth):i=a.borderWidth,i},updateElement:function(t,e,i){var n,a,o=this,s=o.getMeta(),l=t.custom||{},u=o.getDataset(),d=o.index,h=u.data[e],c=o.getScaleForId(s.yAxisID),f=o.getScaleForId(s.xAxisID),g=o.chart.options.elements.point;void 0!==u.radius&&void 0===u.pointRadius&&(u.pointRadius=u.radius),void 0!==u.hitRadius&&void 0===u.pointHitRadius&&(u.pointHitRadius=u.hitRadius),n=f.getPixelForValue(\"object\"==typeof h?h:NaN,e,d),a=i?c.getBasePixel():o.calculatePointY(h,e,d),t._xScale=f,t._yScale=c,t._datasetIndex=d,t._index=e,t._model={x:n,y:a,skip:l.skip||isNaN(n)||isNaN(a),radius:l.radius||r.valueAtIndexOrDefault(u.pointRadius,e,g.radius),pointStyle:l.pointStyle||r.valueAtIndexOrDefault(u.pointStyle,e,g.pointStyle),backgroundColor:o.getPointBackgroundColor(t,e),borderColor:o.getPointBorderColor(t,e),borderWidth:o.getPointBorderWidth(t,e),tension:s.dataset._model?s.dataset._model.tension:0,steppedLine:!!s.dataset._model&&s.dataset._model.steppedLine,hitRadius:l.hitRadius||r.valueAtIndexOrDefault(u.pointHitRadius,e,g.hitRadius)}},calculatePointY:function(t,e,i){var n,a,r,o=this.chart,s=this.getMeta(),l=this.getScaleForId(s.yAxisID),u=0,d=0;if(l.options.stacked){for(n=0;n<i;n++)if(a=o.data.datasets[n],\"line\"===(r=o.getDatasetMeta(n)).type&&r.yAxisID===l.id&&o.isDatasetVisible(n)){var h=Number(l.getRightValue(a.data[e]));h<0?d+=h||0:u+=h||0}var c=Number(l.getRightValue(t));return c<0?l.getPixelForValue(d+c):l.getPixelForValue(u+c)}return l.getPixelForValue(t)},updateBezierControlPoints:function(){var t,e,i,n,a=this.getMeta(),o=this.chart.chartArea,s=a.data||[];function l(t,e,i){return Math.max(Math.min(t,i),e)}if(a.dataset._model.spanGaps&&(s=s.filter(function(t){return!t._model.skip})),\"monotone\"===a.dataset._model.cubicInterpolationMode)r.splineCurveMonotone(s);else for(t=0,e=s.length;t<e;++t)i=s[t]._model,n=r.splineCurve(r.previousItem(s,t)._model,i,r.nextItem(s,t)._model,a.dataset._model.tension),i.controlPointPreviousX=n.previous.x,i.controlPointPreviousY=n.previous.y,i.controlPointNextX=n.next.x,i.controlPointNextY=n.next.y;if(this.chart.options.elements.line.capBezierPoints)for(t=0,e=s.length;t<e;++t)(i=s[t]._model).controlPointPreviousX=l(i.controlPointPreviousX,o.left,o.right),i.controlPointPreviousY=l(i.controlPointPreviousY,o.top,o.bottom),i.controlPointNextX=l(i.controlPointNextX,o.left,o.right),i.controlPointNextY=l(i.controlPointNextY,o.top,o.bottom)},draw:function(){var t=this.chart,i=this.getMeta(),n=i.data||[],a=t.chartArea,o=n.length,s=0;for(r.canvas.clipArea(t.ctx,a),e(this.getDataset(),t.options)&&i.dataset.draw(),r.canvas.unclipArea(t.ctx);s<o;++s)n[s].draw(a)},setHoverStyle:function(t){var e=this.chart.data.datasets[t._datasetIndex],i=t._index,n=t.custom||{},a=t._model;a.radius=n.hoverRadius||r.valueAtIndexOrDefault(e.pointHoverRadius,i,this.chart.options.elements.point.hoverRadius),a.backgroundColor=n.hoverBackgroundColor||r.valueAtIndexOrDefault(e.pointHoverBackgroundColor,i,r.getHoverColor(a.backgroundColor)),a.borderColor=n.hoverBorderColor||r.valueAtIndexOrDefault(e.pointHoverBorderColor,i,r.getHoverColor(a.borderColor)),a.borderWidth=n.hoverBorderWidth||r.valueAtIndexOrDefault(e.pointHoverBorderWidth,i,a.borderWidth)},removeHoverStyle:function(t){var e=this,i=e.chart.data.datasets[t._datasetIndex],n=t._index,a=t.custom||{},o=t._model;void 0!==i.radius&&void 0===i.pointRadius&&(i.pointRadius=i.radius),o.radius=a.radius||r.valueAtIndexOrDefault(i.pointRadius,n,e.chart.options.elements.point.radius),o.backgroundColor=e.getPointBackgroundColor(t,n),o.borderColor=e.getPointBorderColor(t,n),o.borderWidth=e.getPointBorderWidth(t,n)}})}},{25:25,40:40,45:45}],19:[function(t,e,i){\"use strict\";var n=t(25),a=t(40),r=t(45);n._set(\"polarArea\",{scale:{type:\"radialLinear\",angleLines:{display:!1},gridLines:{circular:!0},pointLabels:{display:!1},ticks:{beginAtZero:!0}},animation:{animateRotate:!0,animateScale:!0},startAngle:-.5*Math.PI,legendCallback:function(t){var e=[];e.push('<ul class=\"'+t.id+'-legend\">');var i=t.data,n=i.datasets,a=i.labels;if(n.length)for(var r=0;r<n[0].data.length;++r)e.push('<li><span style=\"background-color:'+n[0].backgroundColor[r]+'\"></span>'),a[r]&&e.push(a[r]),e.push(\"</li>\");return e.push(\"</ul>\"),e.join(\"\")},legend:{labels:{generateLabels:function(t){var e=t.data;return e.labels.length&&e.datasets.length?e.labels.map(function(i,n){var a=t.getDatasetMeta(0),o=e.datasets[0],s=a.data[n].custom||{},l=r.valueAtIndexOrDefault,u=t.options.elements.arc;return{text:i,fillStyle:s.backgroundColor?s.backgroundColor:l(o.backgroundColor,n,u.backgroundColor),strokeStyle:s.borderColor?s.borderColor:l(o.borderColor,n,u.borderColor),lineWidth:s.borderWidth?s.borderWidth:l(o.borderWidth,n,u.borderWidth),hidden:isNaN(o.data[n])||a.data[n].hidden,index:n}}):[]}},onClick:function(t,e){var i,n,a,r=e.index,o=this.chart;for(i=0,n=(o.data.datasets||[]).length;i<n;++i)(a=o.getDatasetMeta(i)).data[r].hidden=!a.data[r].hidden;o.update()}},tooltips:{callbacks:{title:function(){return\"\"},label:function(t,e){return e.labels[t.index]+\": \"+t.yLabel}}}}),e.exports=function(t){t.controllers.polarArea=t.DatasetController.extend({dataElementType:a.Arc,linkScales:r.noop,update:function(t){var e=this,i=e.chart,n=i.chartArea,a=e.getMeta(),o=i.options,s=o.elements.arc,l=Math.min(n.right-n.left,n.bottom-n.top);i.outerRadius=Math.max((l-s.borderWidth/2)/2,0),i.innerRadius=Math.max(o.cutoutPercentage?i.outerRadius/100*o.cutoutPercentage:1,0),i.radiusLength=(i.outerRadius-i.innerRadius)/i.getVisibleDatasetCount(),e.outerRadius=i.outerRadius-i.radiusLength*e.index,e.innerRadius=e.outerRadius-i.radiusLength,a.count=e.countVisibleElements(),r.each(a.data,function(i,n){e.updateElement(i,n,t)})},updateElement:function(t,e,i){for(var n=this,a=n.chart,o=n.getDataset(),s=a.options,l=s.animation,u=a.scale,d=a.data.labels,h=n.calculateCircumference(o.data[e]),c=u.xCenter,f=u.yCenter,g=0,m=n.getMeta(),p=0;p<e;++p)isNaN(o.data[p])||m.data[p].hidden||++g;var v=s.startAngle,y=t.hidden?0:u.getDistanceFromCenterForValue(o.data[e]),b=v+h*g,x=b+(t.hidden?0:h),_=l.animateScale?0:u.getDistanceFromCenterForValue(o.data[e]);r.extend(t,{_datasetIndex:n.index,_index:e,_scale:u,_model:{x:c,y:f,innerRadius:0,outerRadius:i?_:y,startAngle:i&&l.animateRotate?v:b,endAngle:i&&l.animateRotate?v:x,label:r.valueAtIndexOrDefault(d,e,d[e])}}),n.removeHoverStyle(t),t.pivot()},removeHoverStyle:function(e){t.DatasetController.prototype.removeHoverStyle.call(this,e,this.chart.options.elements.arc)},countVisibleElements:function(){var t=this.getDataset(),e=this.getMeta(),i=0;return r.each(e.data,function(e,n){isNaN(t.data[n])||e.hidden||i++}),i},calculateCircumference:function(t){var e=this.getMeta().count;return e>0&&!isNaN(t)?2*Math.PI/e:0}})}},{25:25,40:40,45:45}],20:[function(t,e,i){\"use strict\";var n=t(25),a=t(40),r=t(45);n._set(\"radar\",{scale:{type:\"radialLinear\"},elements:{line:{tension:0}}}),e.exports=function(t){t.controllers.radar=t.DatasetController.extend({datasetElementType:a.Line,dataElementType:a.Point,linkScales:r.noop,update:function(t){var e=this,i=e.getMeta(),n=i.dataset,a=i.data,o=n.custom||{},s=e.getDataset(),l=e.chart.options.elements.line,u=e.chart.scale;void 0!==s.tension&&void 0===s.lineTension&&(s.lineTension=s.tension),r.extend(i.dataset,{_datasetIndex:e.index,_scale:u,_children:a,_loop:!0,_model:{tension:o.tension?o.tension:r.valueOrDefault(s.lineTension,l.tension),backgroundColor:o.backgroundColor?o.backgroundColor:s.backgroundColor||l.backgroundColor,borderWidth:o.borderWidth?o.borderWidth:s.borderWidth||l.borderWidth,borderColor:o.borderColor?o.borderColor:s.borderColor||l.borderColor,fill:o.fill?o.fill:void 0!==s.fill?s.fill:l.fill,borderCapStyle:o.borderCapStyle?o.borderCapStyle:s.borderCapStyle||l.borderCapStyle,borderDash:o.borderDash?o.borderDash:s.borderDash||l.borderDash,borderDashOffset:o.borderDashOffset?o.borderDashOffset:s.borderDashOffset||l.borderDashOffset,borderJoinStyle:o.borderJoinStyle?o.borderJoinStyle:s.borderJoinStyle||l.borderJoinStyle}}),i.dataset.pivot(),r.each(a,function(i,n){e.updateElement(i,n,t)},e),e.updateBezierControlPoints()},updateElement:function(t,e,i){var n=this,a=t.custom||{},o=n.getDataset(),s=n.chart.scale,l=n.chart.options.elements.point,u=s.getPointPositionForValue(e,o.data[e]);void 0!==o.radius&&void 0===o.pointRadius&&(o.pointRadius=o.radius),void 0!==o.hitRadius&&void 0===o.pointHitRadius&&(o.pointHitRadius=o.hitRadius),r.extend(t,{_datasetIndex:n.index,_index:e,_scale:s,_model:{x:i?s.xCenter:u.x,y:i?s.yCenter:u.y,tension:a.tension?a.tension:r.valueOrDefault(o.lineTension,n.chart.options.elements.line.tension),radius:a.radius?a.radius:r.valueAtIndexOrDefault(o.pointRadius,e,l.radius),backgroundColor:a.backgroundColor?a.backgroundColor:r.valueAtIndexOrDefault(o.pointBackgroundColor,e,l.backgroundColor),borderColor:a.borderColor?a.borderColor:r.valueAtIndexOrDefault(o.pointBorderColor,e,l.borderColor),borderWidth:a.borderWidth?a.borderWidth:r.valueAtIndexOrDefault(o.pointBorderWidth,e,l.borderWidth),pointStyle:a.pointStyle?a.pointStyle:r.valueAtIndexOrDefault(o.pointStyle,e,l.pointStyle),hitRadius:a.hitRadius?a.hitRadius:r.valueAtIndexOrDefault(o.pointHitRadius,e,l.hitRadius)}}),t._model.skip=a.skip?a.skip:isNaN(t._model.x)||isNaN(t._model.y)},updateBezierControlPoints:function(){var t=this.chart.chartArea,e=this.getMeta();r.each(e.data,function(i,n){var a=i._model,o=r.splineCurve(r.previousItem(e.data,n,!0)._model,a,r.nextItem(e.data,n,!0)._model,a.tension);a.controlPointPreviousX=Math.max(Math.min(o.previous.x,t.right),t.left),a.controlPointPreviousY=Math.max(Math.min(o.previous.y,t.bottom),t.top),a.controlPointNextX=Math.max(Math.min(o.next.x,t.right),t.left),a.controlPointNextY=Math.max(Math.min(o.next.y,t.bottom),t.top),i.pivot()})},setHoverStyle:function(t){var e=this.chart.data.datasets[t._datasetIndex],i=t.custom||{},n=t._index,a=t._model;a.radius=i.hoverRadius?i.hoverRadius:r.valueAtIndexOrDefault(e.pointHoverRadius,n,this.chart.options.elements.point.hoverRadius),a.backgroundColor=i.hoverBackgroundColor?i.hoverBackgroundColor:r.valueAtIndexOrDefault(e.pointHoverBackgroundColor,n,r.getHoverColor(a.backgroundColor)),a.borderColor=i.hoverBorderColor?i.hoverBorderColor:r.valueAtIndexOrDefault(e.pointHoverBorderColor,n,r.getHoverColor(a.borderColor)),a.borderWidth=i.hoverBorderWidth?i.hoverBorderWidth:r.valueAtIndexOrDefault(e.pointHoverBorderWidth,n,a.borderWidth)},removeHoverStyle:function(t){var e=this.chart.data.datasets[t._datasetIndex],i=t.custom||{},n=t._index,a=t._model,o=this.chart.options.elements.point;a.radius=i.radius?i.radius:r.valueAtIndexOrDefault(e.pointRadius,n,o.radius),a.backgroundColor=i.backgroundColor?i.backgroundColor:r.valueAtIndexOrDefault(e.pointBackgroundColor,n,o.backgroundColor),a.borderColor=i.borderColor?i.borderColor:r.valueAtIndexOrDefault(e.pointBorderColor,n,o.borderColor),a.borderWidth=i.borderWidth?i.borderWidth:r.valueAtIndexOrDefault(e.pointBorderWidth,n,o.borderWidth)}})}},{25:25,40:40,45:45}],21:[function(t,e,i){\"use strict\";t(25)._set(\"scatter\",{hover:{mode:\"single\"},scales:{xAxes:[{id:\"x-axis-1\",type:\"linear\",position:\"bottom\"}],yAxes:[{id:\"y-axis-1\",type:\"linear\",position:\"left\"}]},showLines:!1,tooltips:{callbacks:{title:function(){return\"\"},label:function(t){return\"(\"+t.xLabel+\", \"+t.yLabel+\")\"}}}}),e.exports=function(t){t.controllers.scatter=t.controllers.line}},{25:25}],22:[function(t,e,i){\"use strict\";var n=t(25),a=t(26),r=t(45);n._set(\"global\",{animation:{duration:1e3,easing:\"easeOutQuart\",onProgress:r.noop,onComplete:r.noop}}),e.exports=function(t){t.Animation=a.extend({chart:null,currentStep:0,numSteps:60,easing:\"\",render:null,onAnimationProgress:null,onAnimationComplete:null}),t.animationService={frameDuration:17,animations:[],dropFrames:0,request:null,addAnimation:function(t,e,i,n){var a,r,o=this.animations;for(e.chart=t,n||(t.animating=!0),a=0,r=o.length;a<r;++a)if(o[a].chart===t)return void(o[a]=e);o.push(e),1===o.length&&this.requestAnimationFrame()},cancelAnimation:function(t){var e=r.findIndex(this.animations,function(e){return e.chart===t});-1!==e&&(this.animations.splice(e,1),t.animating=!1)},requestAnimationFrame:function(){var t=this;null===t.request&&(t.request=r.requestAnimFrame.call(window,function(){t.request=null,t.startDigest()}))},startDigest:function(){var t=this,e=Date.now(),i=0;t.dropFrames>1&&(i=Math.floor(t.dropFrames),t.dropFrames=t.dropFrames%1),t.advance(1+i);var n=Date.now();t.dropFrames+=(n-e)/t.frameDuration,t.animations.length>0&&t.requestAnimationFrame()},advance:function(t){for(var e,i,n=this.animations,a=0;a<n.length;)i=(e=n[a]).chart,e.currentStep=(e.currentStep||0)+t,e.currentStep=Math.min(e.currentStep,e.numSteps),r.callback(e.render,[i,e],i),r.callback(e.onAnimationProgress,[e],i),e.currentStep>=e.numSteps?(r.callback(e.onAnimationComplete,[e],i),i.animating=!1,n.splice(a,1)):++a}},Object.defineProperty(t.Animation.prototype,\"animationObject\",{get:function(){return this}}),Object.defineProperty(t.Animation.prototype,\"chartInstance\",{get:function(){return this.chart},set:function(t){this.chart=t}})}},{25:25,26:26,45:45}],23:[function(t,e,i){\"use strict\";var n=t(25),a=t(45),r=t(28),o=t(30),s=t(48),l=t(31);e.exports=function(t){function e(t){return\"top\"===t||\"bottom\"===t}t.types={},t.instances={},t.controllers={},a.extend(t.prototype,{construct:function(e,i){var r,o,l=this;(o=(r=(r=i)||{}).data=r.data||{}).datasets=o.datasets||[],o.labels=o.labels||[],r.options=a.configMerge(n.global,n[r.type],r.options||{}),i=r;var u=s.acquireContext(e,i),d=u&&u.canvas,h=d&&d.height,c=d&&d.width;l.id=a.uid(),l.ctx=u,l.canvas=d,l.config=i,l.width=c,l.height=h,l.aspectRatio=h?c/h:null,l.options=i.options,l._bufferedRender=!1,l.chart=l,l.controller=l,t.instances[l.id]=l,Object.defineProperty(l,\"data\",{get:function(){return l.config.data},set:function(t){l.config.data=t}}),u&&d?(l.initialize(),l.update()):console.error(\"Failed to create chart: can't acquire context from the given item\")},initialize:function(){var t=this;return l.notify(t,\"beforeInit\"),a.retinaScale(t,t.options.devicePixelRatio),t.bindEvents(),t.options.responsive&&t.resize(!0),t.ensureScalesHaveIDs(),t.buildOrUpdateScales(),t.initToolTip(),l.notify(t,\"afterInit\"),t},clear:function(){return a.canvas.clear(this),this},stop:function(){return t.animationService.cancelAnimation(this),this},resize:function(t){var e=this,i=e.options,n=e.canvas,r=i.maintainAspectRatio&&e.aspectRatio||null,o=Math.max(0,Math.floor(a.getMaximumWidth(n))),s=Math.max(0,Math.floor(r?o/r:a.getMaximumHeight(n)));if((e.width!==o||e.height!==s)&&(n.width=e.width=o,n.height=e.height=s,n.style.width=o+\"px\",n.style.height=s+\"px\",a.retinaScale(e,i.devicePixelRatio),!t)){var u={width:o,height:s};l.notify(e,\"resize\",[u]),e.options.onResize&&e.options.onResize(e,u),e.stop(),e.update(e.options.responsiveAnimationDuration)}},ensureScalesHaveIDs:function(){var t=this.options,e=t.scales||{},i=t.scale;a.each(e.xAxes,function(t,e){t.id=t.id||\"x-axis-\"+e}),a.each(e.yAxes,function(t,e){t.id=t.id||\"y-axis-\"+e}),i&&(i.id=i.id||\"scale\")},buildOrUpdateScales:function(){var i=this,n=i.options,r=i.scales||{},o=[],s=Object.keys(r).reduce(function(t,e){return t[e]=!1,t},{});n.scales&&(o=o.concat((n.scales.xAxes||[]).map(function(t){return{options:t,dtype:\"category\",dposition:\"bottom\"}}),(n.scales.yAxes||[]).map(function(t){return{options:t,dtype:\"linear\",dposition:\"left\"}}))),n.scale&&o.push({options:n.scale,dtype:\"radialLinear\",isDefault:!0,dposition:\"chartArea\"}),a.each(o,function(n){var o=n.options,l=o.id,u=a.valueOrDefault(o.type,n.dtype);e(o.position)!==e(n.dposition)&&(o.position=n.dposition),s[l]=!0;var d=null;if(l in r&&r[l].type===u)(d=r[l]).options=o,d.ctx=i.ctx,d.chart=i;else{var h=t.scaleService.getScaleConstructor(u);if(!h)return;d=new h({id:l,type:u,options:o,ctx:i.ctx,chart:i}),r[d.id]=d}d.mergeTicksOptions(),n.isDefault&&(i.scale=d)}),a.each(s,function(t,e){t||delete r[e]}),i.scales=r,t.scaleService.addScalesToLayout(this)},buildOrUpdateControllers:function(){var e=this,i=[],n=[];return a.each(e.data.datasets,function(a,r){var o=e.getDatasetMeta(r),s=a.type||e.config.type;if(o.type&&o.type!==s&&(e.destroyDatasetMeta(r),o=e.getDatasetMeta(r)),o.type=s,i.push(o.type),o.controller)o.controller.updateIndex(r),o.controller.linkScales();else{var l=t.controllers[o.type];if(void 0===l)throw new Error('\"'+o.type+'\" is not a chart type.');o.controller=new l(e,r),n.push(o.controller)}},e),n},resetElements:function(){var t=this;a.each(t.data.datasets,function(e,i){t.getDatasetMeta(i).controller.reset()},t)},reset:function(){this.resetElements(),this.tooltip.initialize()},update:function(e){var i,n,r=this;if(e&&\"object\"==typeof e||(e={duration:e,lazy:arguments[1]}),n=(i=r).options,a.each(i.scales,function(t){o.removeBox(i,t)}),n=a.configMerge(t.defaults.global,t.defaults[i.config.type],n),i.options=i.config.options=n,i.ensureScalesHaveIDs(),i.buildOrUpdateScales(),i.tooltip._options=n.tooltips,i.tooltip.initialize(),l._invalidate(r),!1!==l.notify(r,\"beforeUpdate\")){r.tooltip._data=r.data;var s=r.buildOrUpdateControllers();a.each(r.data.datasets,function(t,e){r.getDatasetMeta(e).controller.buildOrUpdateElements()},r),r.updateLayout(),r.options.animation&&r.options.animation.duration&&a.each(s,function(t){t.reset()}),r.updateDatasets(),r.tooltip.initialize(),r.lastActive=[],l.notify(r,\"afterUpdate\"),r._bufferedRender?r._bufferedRequest={duration:e.duration,easing:e.easing,lazy:e.lazy}:r.render(e)}},updateLayout:function(){!1!==l.notify(this,\"beforeLayout\")&&(o.update(this,this.width,this.height),l.notify(this,\"afterScaleUpdate\"),l.notify(this,\"afterLayout\"))},updateDatasets:function(){if(!1!==l.notify(this,\"beforeDatasetsUpdate\")){for(var t=0,e=this.data.datasets.length;t<e;++t)this.updateDataset(t);l.notify(this,\"afterDatasetsUpdate\")}},updateDataset:function(t){var e=this.getDatasetMeta(t),i={meta:e,index:t};!1!==l.notify(this,\"beforeDatasetUpdate\",[i])&&(e.controller.update(),l.notify(this,\"afterDatasetUpdate\",[i]))},render:function(e){var i=this;e&&\"object\"==typeof e||(e={duration:e,lazy:arguments[1]});var n=e.duration,r=e.lazy;if(!1!==l.notify(i,\"beforeRender\")){var o=i.options.animation,s=function(t){l.notify(i,\"afterRender\"),a.callback(o&&o.onComplete,[t],i)};if(o&&(void 0!==n&&0!==n||void 0===n&&0!==o.duration)){var u=new t.Animation({numSteps:(n||o.duration)/16.66,easing:e.easing||o.easing,render:function(t,e){var i=a.easing.effects[e.easing],n=e.currentStep,r=n/e.numSteps;t.draw(i(r),r,n)},onAnimationProgress:o.onProgress,onAnimationComplete:s});t.animationService.addAnimation(i,u,n,r)}else i.draw(),s(new t.Animation({numSteps:0,chart:i}));return i}},draw:function(t){var e=this;e.clear(),a.isNullOrUndef(t)&&(t=1),e.transition(t),!1!==l.notify(e,\"beforeDraw\",[t])&&(a.each(e.boxes,function(t){t.draw(e.chartArea)},e),e.scale&&e.scale.draw(),e.drawDatasets(t),e._drawTooltip(t),l.notify(e,\"afterDraw\",[t]))},transition:function(t){for(var e=0,i=(this.data.datasets||[]).length;e<i;++e)this.isDatasetVisible(e)&&this.getDatasetMeta(e).controller.transition(t);this.tooltip.transition(t)},drawDatasets:function(t){var e=this;if(!1!==l.notify(e,\"beforeDatasetsDraw\",[t])){for(var i=(e.data.datasets||[]).length-1;i>=0;--i)e.isDatasetVisible(i)&&e.drawDataset(i,t);l.notify(e,\"afterDatasetsDraw\",[t])}},drawDataset:function(t,e){var i=this.getDatasetMeta(t),n={meta:i,index:t,easingValue:e};!1!==l.notify(this,\"beforeDatasetDraw\",[n])&&(i.controller.draw(e),l.notify(this,\"afterDatasetDraw\",[n]))},_drawTooltip:function(t){var e=this.tooltip,i={tooltip:e,easingValue:t};!1!==l.notify(this,\"beforeTooltipDraw\",[i])&&(e.draw(),l.notify(this,\"afterTooltipDraw\",[i]))},getElementAtEvent:function(t){return r.modes.single(this,t)},getElementsAtEvent:function(t){return r.modes.label(this,t,{intersect:!0})},getElementsAtXAxis:function(t){return r.modes[\"x-axis\"](this,t,{intersect:!0})},getElementsAtEventForMode:function(t,e,i){var n=r.modes[e];return\"function\"==typeof n?n(this,t,i):[]},getDatasetAtEvent:function(t){return r.modes.dataset(this,t,{intersect:!0})},getDatasetMeta:function(t){var e=this.data.datasets[t];e._meta||(e._meta={});var i=e._meta[this.id];return i||(i=e._meta[this.id]={type:null,data:[],dataset:null,controller:null,hidden:null,xAxisID:null,yAxisID:null}),i},getVisibleDatasetCount:function(){for(var t=0,e=0,i=this.data.datasets.length;e<i;++e)this.isDatasetVisible(e)&&t++;return t},isDatasetVisible:function(t){var e=this.getDatasetMeta(t);return\"boolean\"==typeof e.hidden?!e.hidden:!this.data.datasets[t].hidden},generateLegend:function(){return this.options.legendCallback(this)},destroyDatasetMeta:function(t){var e=this.id,i=this.data.datasets[t],n=i._meta&&i._meta[e];n&&(n.controller.destroy(),delete i._meta[e])},destroy:function(){var e,i,n=this,r=n.canvas;for(n.stop(),e=0,i=n.data.datasets.length;e<i;++e)n.destroyDatasetMeta(e);r&&(n.unbindEvents(),a.canvas.clear(n),s.releaseContext(n.ctx),n.canvas=null,n.ctx=null),l.notify(n,\"destroy\"),delete t.instances[n.id]},toBase64Image:function(){return this.canvas.toDataURL.apply(this.canvas,arguments)},initToolTip:function(){var e=this;e.tooltip=new t.Tooltip({_chart:e,_chartInstance:e,_data:e.data,_options:e.options.tooltips},e)},bindEvents:function(){var t=this,e=t._listeners={},i=function(){t.eventHandler.apply(t,arguments)};a.each(t.options.events,function(n){s.addEventListener(t,n,i),e[n]=i}),t.options.responsive&&(i=function(){t.resize()},s.addEventListener(t,\"resize\",i),e.resize=i)},unbindEvents:function(){var t=this,e=t._listeners;e&&(delete t._listeners,a.each(e,function(e,i){s.removeEventListener(t,i,e)}))},updateHoverStyle:function(t,e,i){var n,a,r,o=i?\"setHoverStyle\":\"removeHoverStyle\";for(a=0,r=t.length;a<r;++a)(n=t[a])&&this.getDatasetMeta(n._datasetIndex).controller[o](n)},eventHandler:function(t){var e=this,i=e.tooltip;if(!1!==l.notify(e,\"beforeEvent\",[t])){e._bufferedRender=!0,e._bufferedRequest=null;var n=e.handleEvent(t);i&&(n=i._start?i.handleEvent(t):n|i.handleEvent(t)),l.notify(e,\"afterEvent\",[t]);var a=e._bufferedRequest;return a?e.render(a):n&&!e.animating&&(e.stop(),e.render(e.options.hover.animationDuration,!0)),e._bufferedRender=!1,e._bufferedRequest=null,e}},handleEvent:function(t){var e,i=this,n=i.options||{},r=n.hover;return i.lastActive=i.lastActive||[],\"mouseout\"===t.type?i.active=[]:i.active=i.getElementsAtEventForMode(t,r.mode,r),a.callback(n.onHover||n.hover.onHover,[t.native,i.active],i),\"mouseup\"!==t.type&&\"click\"!==t.type||n.onClick&&n.onClick.call(i,t.native,i.active),i.lastActive.length&&i.updateHoverStyle(i.lastActive,r.mode,!1),i.active.length&&r.mode&&i.updateHoverStyle(i.active,r.mode,!0),e=!a.arrayEquals(i.active,i.lastActive),i.lastActive=i.active,e}}),t.Controller=t}},{25:25,28:28,30:30,31:31,45:45,48:48}],24:[function(t,e,i){\"use strict\";var n=t(45);e.exports=function(t){var e=[\"push\",\"pop\",\"shift\",\"splice\",\"unshift\"];function i(t,i){var n=t._chartjs;if(n){var a=n.listeners,r=a.indexOf(i);-1!==r&&a.splice(r,1),a.length>0||(e.forEach(function(e){delete t[e]}),delete t._chartjs)}}t.DatasetController=function(t,e){this.initialize(t,e)},n.extend(t.DatasetController.prototype,{datasetElementType:null,dataElementType:null,initialize:function(t,e){this.chart=t,this.index=e,this.linkScales(),this.addElements()},updateIndex:function(t){this.index=t},linkScales:function(){var t=this,e=t.getMeta(),i=t.getDataset();null!==e.xAxisID&&e.xAxisID in t.chart.scales||(e.xAxisID=i.xAxisID||t.chart.options.scales.xAxes[0].id),null!==e.yAxisID&&e.yAxisID in t.chart.scales||(e.yAxisID=i.yAxisID||t.chart.options.scales.yAxes[0].id)},getDataset:function(){return this.chart.data.datasets[this.index]},getMeta:function(){return this.chart.getDatasetMeta(this.index)},getScaleForId:function(t){return this.chart.scales[t]},reset:function(){this.update(!0)},destroy:function(){this._data&&i(this._data,this)},createMetaDataset:function(){var t=this.datasetElementType;return t&&new t({_chart:this.chart,_datasetIndex:this.index})},createMetaData:function(t){var e=this.dataElementType;return e&&new e({_chart:this.chart,_datasetIndex:this.index,_index:t})},addElements:function(){var t,e,i=this.getMeta(),n=this.getDataset().data||[],a=i.data;for(t=0,e=n.length;t<e;++t)a[t]=a[t]||this.createMetaData(t);i.dataset=i.dataset||this.createMetaDataset()},addElementAndReset:function(t){var e=this.createMetaData(t);this.getMeta().data.splice(t,0,e),this.updateElement(e,t,!0)},buildOrUpdateElements:function(){var t,a,r=this,o=r.getDataset(),s=o.data||(o.data=[]);r._data!==s&&(r._data&&i(r._data,r),a=r,(t=s)._chartjs?t._chartjs.listeners.push(a):(Object.defineProperty(t,\"_chartjs\",{configurable:!0,enumerable:!1,value:{listeners:[a]}}),e.forEach(function(e){var i=\"onData\"+e.charAt(0).toUpperCase()+e.slice(1),a=t[e];Object.defineProperty(t,e,{configurable:!0,enumerable:!1,value:function(){var e=Array.prototype.slice.call(arguments),r=a.apply(this,e);return n.each(t._chartjs.listeners,function(t){\"function\"==typeof t[i]&&t[i].apply(t,e)}),r}})})),r._data=s),r.resyncElements()},update:n.noop,transition:function(t){for(var e=this.getMeta(),i=e.data||[],n=i.length,a=0;a<n;++a)i[a].transition(t);e.dataset&&e.dataset.transition(t)},draw:function(){var t=this.getMeta(),e=t.data||[],i=e.length,n=0;for(t.dataset&&t.dataset.draw();n<i;++n)e[n].draw()},removeHoverStyle:function(t,e){var i=this.chart.data.datasets[t._datasetIndex],a=t._index,r=t.custom||{},o=n.valueAtIndexOrDefault,s=t._model;s.backgroundColor=r.backgroundColor?r.backgroundColor:o(i.backgroundColor,a,e.backgroundColor),s.borderColor=r.borderColor?r.borderColor:o(i.borderColor,a,e.borderColor),s.borderWidth=r.borderWidth?r.borderWidth:o(i.borderWidth,a,e.borderWidth)},setHoverStyle:function(t){var e=this.chart.data.datasets[t._datasetIndex],i=t._index,a=t.custom||{},r=n.valueAtIndexOrDefault,o=n.getHoverColor,s=t._model;s.backgroundColor=a.hoverBackgroundColor?a.hoverBackgroundColor:r(e.hoverBackgroundColor,i,o(s.backgroundColor)),s.borderColor=a.hoverBorderColor?a.hoverBorderColor:r(e.hoverBorderColor,i,o(s.borderColor)),s.borderWidth=a.hoverBorderWidth?a.hoverBorderWidth:r(e.hoverBorderWidth,i,s.borderWidth)},resyncElements:function(){var t=this.getMeta(),e=this.getDataset().data,i=t.data.length,n=e.length;n<i?t.data.splice(n,i-n):n>i&&this.insertElements(i,n-i)},insertElements:function(t,e){for(var i=0;i<e;++i)this.addElementAndReset(t+i)},onDataPush:function(){this.insertElements(this.getDataset().data.length-1,arguments.length)},onDataPop:function(){this.getMeta().data.pop()},onDataShift:function(){this.getMeta().data.shift()},onDataSplice:function(t,e){this.getMeta().data.splice(t,e),this.insertElements(t,arguments.length-2)},onDataUnshift:function(){this.insertElements(0,arguments.length)}}),t.DatasetController.extend=n.inherits}},{45:45}],25:[function(t,e,i){\"use strict\";var n=t(45);e.exports={_set:function(t,e){return n.merge(this[t]||(this[t]={}),e)}}},{45:45}],26:[function(t,e,i){\"use strict\";var n=t(2),a=t(45);var r=function(t){a.extend(this,t),this.initialize.apply(this,arguments)};a.extend(r.prototype,{initialize:function(){this.hidden=!1},pivot:function(){var t=this;return t._view||(t._view=a.clone(t._model)),t._start={},t},transition:function(t){var e=this,i=e._model,a=e._start,r=e._view;return i&&1!==t?(r||(r=e._view={}),a||(a=e._start={}),function(t,e,i,a){var r,o,s,l,u,d,h,c,f,g=Object.keys(i);for(r=0,o=g.length;r<o;++r)if(d=i[s=g[r]],e.hasOwnProperty(s)||(e[s]=d),(l=e[s])!==d&&\"_\"!==s[0]){if(t.hasOwnProperty(s)||(t[s]=l),(h=typeof d)==typeof(u=t[s]))if(\"string\"===h){if((c=n(u)).valid&&(f=n(d)).valid){e[s]=f.mix(c,a).rgbString();continue}}else if(\"number\"===h&&isFinite(u)&&isFinite(d)){e[s]=u+(d-u)*a;continue}e[s]=d}}(a,r,i,t),e):(e._view=i,e._start=null,e)},tooltipPosition:function(){return{x:this._model.x,y:this._model.y}},hasValue:function(){return a.isNumber(this._model.x)&&a.isNumber(this._model.y)}}),r.extend=a.inherits,e.exports=r},{2:2,45:45}],27:[function(t,e,i){\"use strict\";var n=t(2),a=t(25),r=t(45);e.exports=function(t){function e(t,e,i){var n;return\"string\"==typeof t?(n=parseInt(t,10),-1!==t.indexOf(\"%\")&&(n=n/100*e.parentNode[i])):n=t,n}function i(t){return null!=t&&\"none\"!==t}function o(t,n,a){var r=document.defaultView,o=t.parentNode,s=r.getComputedStyle(t)[n],l=r.getComputedStyle(o)[n],u=i(s),d=i(l),h=Number.POSITIVE_INFINITY;return u||d?Math.min(u?e(s,t,a):h,d?e(l,o,a):h):\"none\"}r.configMerge=function(){return r.merge(r.clone(arguments[0]),[].slice.call(arguments,1),{merger:function(e,i,n,a){var o=i[e]||{},s=n[e];\"scales\"===e?i[e]=r.scaleMerge(o,s):\"scale\"===e?i[e]=r.merge(o,[t.scaleService.getScaleDefaults(s.type),s]):r._merger(e,i,n,a)}})},r.scaleMerge=function(){return r.merge(r.clone(arguments[0]),[].slice.call(arguments,1),{merger:function(e,i,n,a){if(\"xAxes\"===e||\"yAxes\"===e){var o,s,l,u=n[e].length;for(i[e]||(i[e]=[]),o=0;o<u;++o)l=n[e][o],s=r.valueOrDefault(l.type,\"xAxes\"===e?\"category\":\"linear\"),o>=i[e].length&&i[e].push({}),!i[e][o].type||l.type&&l.type!==i[e][o].type?r.merge(i[e][o],[t.scaleService.getScaleDefaults(s),l]):r.merge(i[e][o],l)}else r._merger(e,i,n,a)}})},r.where=function(t,e){if(r.isArray(t)&&Array.prototype.filter)return t.filter(e);var i=[];return r.each(t,function(t){e(t)&&i.push(t)}),i},r.findIndex=Array.prototype.findIndex?function(t,e,i){return t.findIndex(e,i)}:function(t,e,i){i=void 0===i?t:i;for(var n=0,a=t.length;n<a;++n)if(e.call(i,t[n],n,t))return n;return-1},r.findNextWhere=function(t,e,i){r.isNullOrUndef(i)&&(i=-1);for(var n=i+1;n<t.length;n++){var a=t[n];if(e(a))return a}},r.findPreviousWhere=function(t,e,i){r.isNullOrUndef(i)&&(i=t.length);for(var n=i-1;n>=0;n--){var a=t[n];if(e(a))return a}},r.isNumber=function(t){return!isNaN(parseFloat(t))&&isFinite(t)},r.almostEquals=function(t,e,i){return Math.abs(t-e)<i},r.almostWhole=function(t,e){var i=Math.round(t);return i-e<t&&i+e>t},r.max=function(t){return t.reduce(function(t,e){return isNaN(e)?t:Math.max(t,e)},Number.NEGATIVE_INFINITY)},r.min=function(t){return t.reduce(function(t,e){return isNaN(e)?t:Math.min(t,e)},Number.POSITIVE_INFINITY)},r.sign=Math.sign?function(t){return Math.sign(t)}:function(t){return 0===(t=+t)||isNaN(t)?t:t>0?1:-1},r.log10=Math.log10?function(t){return Math.log10(t)}:function(t){var e=Math.log(t)*Math.LOG10E,i=Math.round(e);return t===Math.pow(10,i)?i:e},r.toRadians=function(t){return t*(Math.PI/180)},r.toDegrees=function(t){return t*(180/Math.PI)},r.getAngleFromPoint=function(t,e){var i=e.x-t.x,n=e.y-t.y,a=Math.sqrt(i*i+n*n),r=Math.atan2(n,i);return r<-.5*Math.PI&&(r+=2*Math.PI),{angle:r,distance:a}},r.distanceBetweenPoints=function(t,e){return Math.sqrt(Math.pow(e.x-t.x,2)+Math.pow(e.y-t.y,2))},r.aliasPixel=function(t){return t%2==0?0:.5},r.splineCurve=function(t,e,i,n){var a=t.skip?e:t,r=e,o=i.skip?e:i,s=Math.sqrt(Math.pow(r.x-a.x,2)+Math.pow(r.y-a.y,2)),l=Math.sqrt(Math.pow(o.x-r.x,2)+Math.pow(o.y-r.y,2)),u=s/(s+l),d=l/(s+l),h=n*(u=isNaN(u)?0:u),c=n*(d=isNaN(d)?0:d);return{previous:{x:r.x-h*(o.x-a.x),y:r.y-h*(o.y-a.y)},next:{x:r.x+c*(o.x-a.x),y:r.y+c*(o.y-a.y)}}},r.EPSILON=Number.EPSILON||1e-14,r.splineCurveMonotone=function(t){var e,i,n,a,o,s,l,u,d,h=(t||[]).map(function(t){return{model:t._model,deltaK:0,mK:0}}),c=h.length;for(e=0;e<c;++e)if(!(n=h[e]).model.skip){if(i=e>0?h[e-1]:null,(a=e<c-1?h[e+1]:null)&&!a.model.skip){var f=a.model.x-n.model.x;n.deltaK=0!==f?(a.model.y-n.model.y)/f:0}!i||i.model.skip?n.mK=n.deltaK:!a||a.model.skip?n.mK=i.deltaK:this.sign(i.deltaK)!==this.sign(n.deltaK)?n.mK=0:n.mK=(i.deltaK+n.deltaK)/2}for(e=0;e<c-1;++e)n=h[e],a=h[e+1],n.model.skip||a.model.skip||(r.almostEquals(n.deltaK,0,this.EPSILON)?n.mK=a.mK=0:(o=n.mK/n.deltaK,s=a.mK/n.deltaK,(u=Math.pow(o,2)+Math.pow(s,2))<=9||(l=3/Math.sqrt(u),n.mK=o*l*n.deltaK,a.mK=s*l*n.deltaK)));for(e=0;e<c;++e)(n=h[e]).model.skip||(i=e>0?h[e-1]:null,a=e<c-1?h[e+1]:null,i&&!i.model.skip&&(d=(n.model.x-i.model.x)/3,n.model.controlPointPreviousX=n.model.x-d,n.model.controlPointPreviousY=n.model.y-d*n.mK),a&&!a.model.skip&&(d=(a.model.x-n.model.x)/3,n.model.controlPointNextX=n.model.x+d,n.model.controlPointNextY=n.model.y+d*n.mK))},r.nextItem=function(t,e,i){return i?e>=t.length-1?t[0]:t[e+1]:e>=t.length-1?t[t.length-1]:t[e+1]},r.previousItem=function(t,e,i){return i?e<=0?t[t.length-1]:t[e-1]:e<=0?t[0]:t[e-1]},r.niceNum=function(t,e){var i=Math.floor(r.log10(t)),n=t/Math.pow(10,i);return(e?n<1.5?1:n<3?2:n<7?5:10:n<=1?1:n<=2?2:n<=5?5:10)*Math.pow(10,i)},r.requestAnimFrame=\"undefined\"==typeof window?function(t){t()}:window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||window.oRequestAnimationFrame||window.msRequestAnimationFrame||function(t){return window.setTimeout(t,1e3/60)},r.getRelativePosition=function(t,e){var i,n,a=t.originalEvent||t,o=t.currentTarget||t.srcElement,s=o.getBoundingClientRect(),l=a.touches;l&&l.length>0?(i=l[0].clientX,n=l[0].clientY):(i=a.clientX,n=a.clientY);var u=parseFloat(r.getStyle(o,\"padding-left\")),d=parseFloat(r.getStyle(o,\"padding-top\")),h=parseFloat(r.getStyle(o,\"padding-right\")),c=parseFloat(r.getStyle(o,\"padding-bottom\")),f=s.right-s.left-u-h,g=s.bottom-s.top-d-c;return{x:i=Math.round((i-s.left-u)/f*o.width/e.currentDevicePixelRatio),y:n=Math.round((n-s.top-d)/g*o.height/e.currentDevicePixelRatio)}},r.getConstraintWidth=function(t){return o(t,\"max-width\",\"clientWidth\")},r.getConstraintHeight=function(t){return o(t,\"max-height\",\"clientHeight\")},r.getMaximumWidth=function(t){var e=t.parentNode;if(!e)return t.clientWidth;var i=parseInt(r.getStyle(e,\"padding-left\"),10),n=parseInt(r.getStyle(e,\"padding-right\"),10),a=e.clientWidth-i-n,o=r.getConstraintWidth(t);return isNaN(o)?a:Math.min(a,o)},r.getMaximumHeight=function(t){var e=t.parentNode;if(!e)return t.clientHeight;var i=parseInt(r.getStyle(e,\"padding-top\"),10),n=parseInt(r.getStyle(e,\"padding-bottom\"),10),a=e.clientHeight-i-n,o=r.getConstraintHeight(t);return isNaN(o)?a:Math.min(a,o)},r.getStyle=function(t,e){return t.currentStyle?t.currentStyle[e]:document.defaultView.getComputedStyle(t,null).getPropertyValue(e)},r.retinaScale=function(t,e){var i=t.currentDevicePixelRatio=e||window.devicePixelRatio||1;if(1!==i){var n=t.canvas,a=t.height,r=t.width;n.height=a*i,n.width=r*i,t.ctx.scale(i,i),n.style.height||n.style.width||(n.style.height=a+\"px\",n.style.width=r+\"px\")}},r.fontString=function(t,e,i){return e+\" \"+t+\"px \"+i},r.longestText=function(t,e,i,n){var a=(n=n||{}).data=n.data||{},o=n.garbageCollect=n.garbageCollect||[];n.font!==e&&(a=n.data={},o=n.garbageCollect=[],n.font=e),t.font=e;var s=0;r.each(i,function(e){null!=e&&!0!==r.isArray(e)?s=r.measureText(t,a,o,s,e):r.isArray(e)&&r.each(e,function(e){null==e||r.isArray(e)||(s=r.measureText(t,a,o,s,e))})});var l=o.length/2;if(l>i.length){for(var u=0;u<l;u++)delete a[o[u]];o.splice(0,l)}return s},r.measureText=function(t,e,i,n,a){var r=e[a];return r||(r=e[a]=t.measureText(a).width,i.push(a)),r>n&&(n=r),n},r.numberOfLabelLines=function(t){var e=1;return r.each(t,function(t){r.isArray(t)&&t.length>e&&(e=t.length)}),e},r.color=n?function(t){return t instanceof CanvasGradient&&(t=a.global.defaultColor),n(t)}:function(t){return console.error(\"Color.js not found!\"),t},r.getHoverColor=function(t){return t instanceof CanvasPattern?t:r.color(t).saturate(.5).darken(.1).rgbString()}}},{2:2,25:25,45:45}],28:[function(t,e,i){\"use strict\";var n=t(45);function a(t,e){return t.native?{x:t.x,y:t.y}:n.getRelativePosition(t,e)}function r(t,e){var i,n,a,r,o;for(n=0,r=t.data.datasets.length;n<r;++n)if(t.isDatasetVisible(n))for(a=0,o=(i=t.getDatasetMeta(n)).data.length;a<o;++a){var s=i.data[a];s._view.skip||e(s)}}function o(t,e){var i=[];return r(t,function(t){t.inRange(e.x,e.y)&&i.push(t)}),i}function s(t,e,i,n){var a=Number.POSITIVE_INFINITY,o=[];return r(t,function(t){if(!i||t.inRange(e.x,e.y)){var r=t.getCenterPoint(),s=n(e,r);s<a?(o=[t],a=s):s===a&&o.push(t)}}),o}function l(t){var e=-1!==t.indexOf(\"x\"),i=-1!==t.indexOf(\"y\");return function(t,n){var a=e?Math.abs(t.x-n.x):0,r=i?Math.abs(t.y-n.y):0;return Math.sqrt(Math.pow(a,2)+Math.pow(r,2))}}function u(t,e,i){var n=a(e,t);i.axis=i.axis||\"x\";var r=l(i.axis),u=i.intersect?o(t,n):s(t,n,!1,r),d=[];return u.length?(t.data.datasets.forEach(function(e,i){if(t.isDatasetVisible(i)){var n=t.getDatasetMeta(i).data[u[0]._index];n&&!n._view.skip&&d.push(n)}}),d):[]}e.exports={modes:{single:function(t,e){var i=a(e,t),n=[];return r(t,function(t){if(t.inRange(i.x,i.y))return n.push(t),n}),n.slice(0,1)},label:u,index:u,dataset:function(t,e,i){var n=a(e,t);i.axis=i.axis||\"xy\";var r=l(i.axis),u=i.intersect?o(t,n):s(t,n,!1,r);return u.length>0&&(u=t.getDatasetMeta(u[0]._datasetIndex).data),u},\"x-axis\":function(t,e){return u(t,e,{intersect:!1})},point:function(t,e){return o(t,a(e,t))},nearest:function(t,e,i){var n=a(e,t);i.axis=i.axis||\"xy\";var r=l(i.axis),o=s(t,n,i.intersect,r);return o.length>1&&o.sort(function(t,e){var i=t.getArea()-e.getArea();return 0===i&&(i=t._datasetIndex-e._datasetIndex),i}),o.slice(0,1)},x:function(t,e,i){var n=a(e,t),o=[],s=!1;return r(t,function(t){t.inXRange(n.x)&&o.push(t),t.inRange(n.x,n.y)&&(s=!0)}),i.intersect&&!s&&(o=[]),o},y:function(t,e,i){var n=a(e,t),o=[],s=!1;return r(t,function(t){t.inYRange(n.y)&&o.push(t),t.inRange(n.x,n.y)&&(s=!0)}),i.intersect&&!s&&(o=[]),o}}}},{45:45}],29:[function(t,e,i){\"use strict\";t(25)._set(\"global\",{responsive:!0,responsiveAnimationDuration:0,maintainAspectRatio:!0,events:[\"mousemove\",\"mouseout\",\"click\",\"touchstart\",\"touchmove\"],hover:{onHover:null,mode:\"nearest\",intersect:!0,animationDuration:400},onClick:null,defaultColor:\"rgba(0,0,0,0.1)\",defaultFontColor:\"#666\",defaultFontFamily:\"'Helvetica Neue', 'Helvetica', 'Arial', sans-serif\",defaultFontSize:12,defaultFontStyle:\"normal\",showLines:!0,elements:{},layout:{padding:{top:0,right:0,bottom:0,left:0}}}),e.exports=function(){var t=function(t,e){return this.construct(t,e),this};return t.Chart=t,t}},{25:25}],30:[function(t,e,i){\"use strict\";var n=t(45);function a(t,e){return n.where(t,function(t){return t.position===e})}function r(t,e){t.forEach(function(t,e){return t._tmpIndex_=e,t}),t.sort(function(t,i){var n=e?i:t,a=e?t:i;return n.weight===a.weight?n._tmpIndex_-a._tmpIndex_:n.weight-a.weight}),t.forEach(function(t){delete t._tmpIndex_})}e.exports={defaults:{},addBox:function(t,e){t.boxes||(t.boxes=[]),e.fullWidth=e.fullWidth||!1,e.position=e.position||\"top\",e.weight=e.weight||0,t.boxes.push(e)},removeBox:function(t,e){var i=t.boxes?t.boxes.indexOf(e):-1;-1!==i&&t.boxes.splice(i,1)},configure:function(t,e,i){for(var n,a=[\"fullWidth\",\"position\",\"weight\"],r=a.length,o=0;o<r;++o)n=a[o],i.hasOwnProperty(n)&&(e[n]=i[n])},update:function(t,e,i){if(t){var o=t.options.layout||{},s=n.options.toPadding(o.padding),l=s.left,u=s.right,d=s.top,h=s.bottom,c=a(t.boxes,\"left\"),f=a(t.boxes,\"right\"),g=a(t.boxes,\"top\"),m=a(t.boxes,\"bottom\"),p=a(t.boxes,\"chartArea\");r(c,!0),r(f,!1),r(g,!0),r(m,!1);var v=e-l-u,y=i-d-h,b=y/2,x=(e-v/2)/(c.length+f.length),_=(i-b)/(g.length+m.length),k=v,w=y,M=[];n.each(c.concat(f,g,m),function(t){var e,i=t.isHorizontal();i?(e=t.update(t.fullWidth?v:k,_),w-=e.height):(e=t.update(x,w),k-=e.width),M.push({horizontal:i,minSize:e,box:t})});var S=0,D=0,C=0,P=0;n.each(g.concat(m),function(t){if(t.getPadding){var e=t.getPadding();S=Math.max(S,e.left),D=Math.max(D,e.right)}}),n.each(c.concat(f),function(t){if(t.getPadding){var e=t.getPadding();C=Math.max(C,e.top),P=Math.max(P,e.bottom)}});var T=l,O=u,I=d,A=h;n.each(c.concat(f),z),n.each(c,function(t){T+=t.width}),n.each(f,function(t){O+=t.width}),n.each(g.concat(m),z),n.each(g,function(t){I+=t.height}),n.each(m,function(t){A+=t.height}),n.each(c.concat(f),function(t){var e=n.findNextWhere(M,function(e){return e.box===t}),i={left:0,right:0,top:I,bottom:A};e&&t.update(e.minSize.width,w,i)}),T=l,O=u,I=d,A=h,n.each(c,function(t){T+=t.width}),n.each(f,function(t){O+=t.width}),n.each(g,function(t){I+=t.height}),n.each(m,function(t){A+=t.height});var F=Math.max(S-T,0);T+=F,O+=Math.max(D-O,0);var R=Math.max(C-I,0);I+=R,A+=Math.max(P-A,0);var L=i-I-A,W=e-T-O;W===k&&L===w||(n.each(c,function(t){t.height=L}),n.each(f,function(t){t.height=L}),n.each(g,function(t){t.fullWidth||(t.width=W)}),n.each(m,function(t){t.fullWidth||(t.width=W)}),w=L,k=W);var Y=l+F,N=d+R;n.each(c.concat(g),H),Y+=k,N+=w,n.each(f,H),n.each(m,H),t.chartArea={left:T,top:I,right:T+k,bottom:I+w},n.each(p,function(e){e.left=t.chartArea.left,e.top=t.chartArea.top,e.right=t.chartArea.right,e.bottom=t.chartArea.bottom,e.update(k,w)})}function z(t){var e=n.findNextWhere(M,function(e){return e.box===t});if(e)if(t.isHorizontal()){var i={left:Math.max(T,S),right:Math.max(O,D),top:0,bottom:0};t.update(t.fullWidth?v:k,y/2,i)}else t.update(e.minSize.width,w)}function H(t){t.isHorizontal()?(t.left=t.fullWidth?l:T,t.right=t.fullWidth?e-u:T+k,t.top=N,t.bottom=N+t.height,N=t.bottom):(t.left=Y,t.right=Y+t.width,t.top=I,t.bottom=I+w,Y=t.right)}}}},{45:45}],31:[function(t,e,i){\"use strict\";var n=t(25),a=t(45);n._set(\"global\",{plugins:{}}),e.exports={_plugins:[],_cacheId:0,register:function(t){var e=this._plugins;[].concat(t).forEach(function(t){-1===e.indexOf(t)&&e.push(t)}),this._cacheId++},unregister:function(t){var e=this._plugins;[].concat(t).forEach(function(t){var i=e.indexOf(t);-1!==i&&e.splice(i,1)}),this._cacheId++},clear:function(){this._plugins=[],this._cacheId++},count:function(){return this._plugins.length},getAll:function(){return this._plugins},notify:function(t,e,i){var n,a,r,o,s,l=this.descriptors(t),u=l.length;for(n=0;n<u;++n)if(\"function\"==typeof(s=(r=(a=l[n]).plugin)[e])&&((o=[t].concat(i||[])).push(a.options),!1===s.apply(r,o)))return!1;return!0},descriptors:function(t){var e=t.$plugins||(t.$plugins={});if(e.id===this._cacheId)return e.descriptors;var i=[],r=[],o=t&&t.config||{},s=o.options&&o.options.plugins||{};return this._plugins.concat(o.plugins||[]).forEach(function(t){if(-1===i.indexOf(t)){var e=t.id,o=s[e];!1!==o&&(!0===o&&(o=a.clone(n.global.plugins[e])),i.push(t),r.push({plugin:t,options:o||{}}))}}),e.descriptors=r,e.id=this._cacheId,r},_invalidate:function(t){delete t.$plugins}}},{25:25,45:45}],32:[function(t,e,i){\"use strict\";var n=t(25),a=t(26),r=t(45),o=t(34);function s(t){var e,i,n=[];for(e=0,i=t.length;e<i;++e)n.push(t[e].label);return n}function l(t,e,i){var n=t.getPixelForTick(e);return i&&(n-=0===e?(t.getPixelForTick(1)-n)/2:(n-t.getPixelForTick(e-1))/2),n}n._set(\"scale\",{display:!0,position:\"left\",offset:!1,gridLines:{display:!0,color:\"rgba(0, 0, 0, 0.1)\",lineWidth:1,drawBorder:!0,drawOnChartArea:!0,drawTicks:!0,tickMarkLength:10,zeroLineWidth:1,zeroLineColor:\"rgba(0,0,0,0.25)\",zeroLineBorderDash:[],zeroLineBorderDashOffset:0,offsetGridLines:!1,borderDash:[],borderDashOffset:0},scaleLabel:{display:!1,labelString:\"\",lineHeight:1.2,padding:{top:4,bottom:4}},ticks:{beginAtZero:!1,minRotation:0,maxRotation:50,mirror:!1,padding:0,reverse:!1,display:!0,autoSkip:!0,autoSkipPadding:0,labelOffset:0,callback:o.formatters.values,minor:{},major:{}}}),e.exports=function(t){function e(t,e,i){return r.isArray(e)?r.longestText(t,i,e):t.measureText(e).width}function i(t){var e=r.valueOrDefault,i=n.global,a=e(t.fontSize,i.defaultFontSize),o=e(t.fontStyle,i.defaultFontStyle),s=e(t.fontFamily,i.defaultFontFamily);return{size:a,style:o,family:s,font:r.fontString(a,o,s)}}function o(t){return r.options.toLineHeight(r.valueOrDefault(t.lineHeight,1.2),r.valueOrDefault(t.fontSize,n.global.defaultFontSize))}t.Scale=a.extend({getPadding:function(){return{left:this.paddingLeft||0,top:this.paddingTop||0,right:this.paddingRight||0,bottom:this.paddingBottom||0}},getTicks:function(){return this._ticks},mergeTicksOptions:function(){var t=this.options.ticks;for(var e in!1===t.minor&&(t.minor={display:!1}),!1===t.major&&(t.major={display:!1}),t)\"major\"!==e&&\"minor\"!==e&&(void 0===t.minor[e]&&(t.minor[e]=t[e]),void 0===t.major[e]&&(t.major[e]=t[e]))},beforeUpdate:function(){r.callback(this.options.beforeUpdate,[this])},update:function(t,e,i){var n,a,o,s,l,u,d=this;for(d.beforeUpdate(),d.maxWidth=t,d.maxHeight=e,d.margins=r.extend({left:0,right:0,top:0,bottom:0},i),d.longestTextCache=d.longestTextCache||{},d.beforeSetDimensions(),d.setDimensions(),d.afterSetDimensions(),d.beforeDataLimits(),d.determineDataLimits(),d.afterDataLimits(),d.beforeBuildTicks(),l=d.buildTicks()||[],d.afterBuildTicks(),d.beforeTickToLabelConversion(),o=d.convertTicksToLabels(l)||d.ticks,d.afterTickToLabelConversion(),d.ticks=o,n=0,a=o.length;n<a;++n)s=o[n],(u=l[n])?u.label=s:l.push(u={label:s,major:!1});return d._ticks=l,d.beforeCalculateTickRotation(),d.calculateTickRotation(),d.afterCalculateTickRotation(),d.beforeFit(),d.fit(),d.afterFit(),d.afterUpdate(),d.minSize},afterUpdate:function(){r.callback(this.options.afterUpdate,[this])},beforeSetDimensions:function(){r.callback(this.options.beforeSetDimensions,[this])},setDimensions:function(){var t=this;t.isHorizontal()?(t.width=t.maxWidth,t.left=0,t.right=t.width):(t.height=t.maxHeight,t.top=0,t.bottom=t.height),t.paddingLeft=0,t.paddingTop=0,t.paddingRight=0,t.paddingBottom=0},afterSetDimensions:function(){r.callback(this.options.afterSetDimensions,[this])},beforeDataLimits:function(){r.callback(this.options.beforeDataLimits,[this])},determineDataLimits:r.noop,afterDataLimits:function(){r.callback(this.options.afterDataLimits,[this])},beforeBuildTicks:function(){r.callback(this.options.beforeBuildTicks,[this])},buildTicks:r.noop,afterBuildTicks:function(){r.callback(this.options.afterBuildTicks,[this])},beforeTickToLabelConversion:function(){r.callback(this.options.beforeTickToLabelConversion,[this])},convertTicksToLabels:function(){var t=this.options.ticks;this.ticks=this.ticks.map(t.userCallback||t.callback,this)},afterTickToLabelConversion:function(){r.callback(this.options.afterTickToLabelConversion,[this])},beforeCalculateTickRotation:function(){r.callback(this.options.beforeCalculateTickRotation,[this])},calculateTickRotation:function(){var t=this,e=t.ctx,n=t.options.ticks,a=s(t._ticks),o=i(n);e.font=o.font;var l=n.minRotation||0;if(a.length&&t.options.display&&t.isHorizontal())for(var u,d=r.longestText(e,o.font,a,t.longestTextCache),h=d,c=t.getPixelForTick(1)-t.getPixelForTick(0)-6;h>c&&l<n.maxRotation;){var f=r.toRadians(l);if(u=Math.cos(f),Math.sin(f)*d>t.maxHeight){l--;break}l++,h=u*d}t.labelRotation=l},afterCalculateTickRotation:function(){r.callback(this.options.afterCalculateTickRotation,[this])},beforeFit:function(){r.callback(this.options.beforeFit,[this])},fit:function(){var t=this,n=t.minSize={width:0,height:0},a=s(t._ticks),l=t.options,u=l.ticks,d=l.scaleLabel,h=l.gridLines,c=l.display,f=t.isHorizontal(),g=i(u),m=l.gridLines.tickMarkLength;if(n.width=f?t.isFullWidth()?t.maxWidth-t.margins.left-t.margins.right:t.maxWidth:c&&h.drawTicks?m:0,n.height=f?c&&h.drawTicks?m:0:t.maxHeight,d.display&&c){var p=o(d)+r.options.toPadding(d.padding).height;f?n.height+=p:n.width+=p}if(u.display&&c){var v=r.longestText(t.ctx,g.font,a,t.longestTextCache),y=r.numberOfLabelLines(a),b=.5*g.size,x=t.options.ticks.padding;if(f){t.longestLabelWidth=v;var _=r.toRadians(t.labelRotation),k=Math.cos(_),w=Math.sin(_)*v+g.size*y+b*(y-1)+b;n.height=Math.min(t.maxHeight,n.height+w+x),t.ctx.font=g.font;var M=e(t.ctx,a[0],g.font),S=e(t.ctx,a[a.length-1],g.font);0!==t.labelRotation?(t.paddingLeft=\"bottom\"===l.position?k*M+3:k*b+3,t.paddingRight=\"bottom\"===l.position?k*b+3:k*S+3):(t.paddingLeft=M/2+3,t.paddingRight=S/2+3)}else u.mirror?v=0:v+=x+b,n.width=Math.min(t.maxWidth,n.width+v),t.paddingTop=g.size/2,t.paddingBottom=g.size/2}t.handleMargins(),t.width=n.width,t.height=n.height},handleMargins:function(){var t=this;t.margins&&(t.paddingLeft=Math.max(t.paddingLeft-t.margins.left,0),t.paddingTop=Math.max(t.paddingTop-t.margins.top,0),t.paddingRight=Math.max(t.paddingRight-t.margins.right,0),t.paddingBottom=Math.max(t.paddingBottom-t.margins.bottom,0))},afterFit:function(){r.callback(this.options.afterFit,[this])},isHorizontal:function(){return\"top\"===this.options.position||\"bottom\"===this.options.position},isFullWidth:function(){return this.options.fullWidth},getRightValue:function(t){if(r.isNullOrUndef(t))return NaN;if(\"number\"==typeof t&&!isFinite(t))return NaN;if(t)if(this.isHorizontal()){if(void 0!==t.x)return this.getRightValue(t.x)}else if(void 0!==t.y)return this.getRightValue(t.y);return t},getLabelForIndex:r.noop,getPixelForValue:r.noop,getValueForPixel:r.noop,getPixelForTick:function(t){var e=this,i=e.options.offset;if(e.isHorizontal()){var n=(e.width-(e.paddingLeft+e.paddingRight))/Math.max(e._ticks.length-(i?0:1),1),a=n*t+e.paddingLeft;i&&(a+=n/2);var r=e.left+Math.round(a);return r+=e.isFullWidth()?e.margins.left:0}var o=e.height-(e.paddingTop+e.paddingBottom);return e.top+t*(o/(e._ticks.length-1))},getPixelForDecimal:function(t){var e=this;if(e.isHorizontal()){var i=(e.width-(e.paddingLeft+e.paddingRight))*t+e.paddingLeft,n=e.left+Math.round(i);return n+=e.isFullWidth()?e.margins.left:0}return e.top+t*e.height},getBasePixel:function(){return this.getPixelForValue(this.getBaseValue())},getBaseValue:function(){var t=this.min,e=this.max;return this.beginAtZero?0:t<0&&e<0?e:t>0&&e>0?t:0},_autoSkip:function(t){var e,i,n,a,o=this,s=o.isHorizontal(),l=o.options.ticks.minor,u=t.length,d=r.toRadians(o.labelRotation),h=Math.cos(d),c=o.longestLabelWidth*h,f=[];for(l.maxTicksLimit&&(a=l.maxTicksLimit),s&&(e=!1,(c+l.autoSkipPadding)*u>o.width-(o.paddingLeft+o.paddingRight)&&(e=1+Math.floor((c+l.autoSkipPadding)*u/(o.width-(o.paddingLeft+o.paddingRight)))),a&&u>a&&(e=Math.max(e,Math.floor(u/a)))),i=0;i<u;i++)n=t[i],(e>1&&i%e>0||i%e==0&&i+e>=u)&&i!==u-1&&delete n.label,f.push(n);return f},draw:function(t){var e=this,a=e.options;if(a.display){var s=e.ctx,u=n.global,d=a.ticks.minor,h=a.ticks.major||d,c=a.gridLines,f=a.scaleLabel,g=0!==e.labelRotation,m=e.isHorizontal(),p=d.autoSkip?e._autoSkip(e.getTicks()):e.getTicks(),v=r.valueOrDefault(d.fontColor,u.defaultFontColor),y=i(d),b=r.valueOrDefault(h.fontColor,u.defaultFontColor),x=i(h),_=c.drawTicks?c.tickMarkLength:0,k=r.valueOrDefault(f.fontColor,u.defaultFontColor),w=i(f),M=r.options.toPadding(f.padding),S=r.toRadians(e.labelRotation),D=[],C=e.options.gridLines.lineWidth,P=\"right\"===a.position?e.right:e.right-C-_,T=\"right\"===a.position?e.right+_:e.right,O=\"bottom\"===a.position?e.top+C:e.bottom-_-C,I=\"bottom\"===a.position?e.top+C+_:e.bottom+C;if(r.each(p,function(i,n){if(!r.isNullOrUndef(i.label)){var o,s,h,f,v,y,b,x,k,w,M,A,F,R,L=i.label;n===e.zeroLineIndex&&a.offset===c.offsetGridLines?(o=c.zeroLineWidth,s=c.zeroLineColor,h=c.zeroLineBorderDash,f=c.zeroLineBorderDashOffset):(o=r.valueAtIndexOrDefault(c.lineWidth,n),s=r.valueAtIndexOrDefault(c.color,n),h=r.valueOrDefault(c.borderDash,u.borderDash),f=r.valueOrDefault(c.borderDashOffset,u.borderDashOffset));var W=\"middle\",Y=\"middle\",N=d.padding;if(m){var z=_+N;\"bottom\"===a.position?(Y=g?\"middle\":\"top\",W=g?\"right\":\"center\",R=e.top+z):(Y=g?\"middle\":\"bottom\",W=g?\"left\":\"center\",R=e.bottom-z);var H=l(e,n,c.offsetGridLines&&p.length>1);H<e.left&&(s=\"rgba(0,0,0,0)\"),H+=r.aliasPixel(o),F=e.getPixelForTick(n)+d.labelOffset,v=b=k=M=H,y=O,x=I,w=t.top,A=t.bottom+C}else{var V,B=\"left\"===a.position;d.mirror?(W=B?\"left\":\"right\",V=N):(W=B?\"right\":\"left\",V=_+N),F=B?e.right-V:e.left+V;var E=l(e,n,c.offsetGridLines&&p.length>1);E<e.top&&(s=\"rgba(0,0,0,0)\"),E+=r.aliasPixel(o),R=e.getPixelForTick(n)+d.labelOffset,v=P,b=T,k=t.left,M=t.right+C,y=x=w=A=E}D.push({tx1:v,ty1:y,tx2:b,ty2:x,x1:k,y1:w,x2:M,y2:A,labelX:F,labelY:R,glWidth:o,glColor:s,glBorderDash:h,glBorderDashOffset:f,rotation:-1*S,label:L,major:i.major,textBaseline:Y,textAlign:W})}}),r.each(D,function(t){if(c.display&&(s.save(),s.lineWidth=t.glWidth,s.strokeStyle=t.glColor,s.setLineDash&&(s.setLineDash(t.glBorderDash),s.lineDashOffset=t.glBorderDashOffset),s.beginPath(),c.drawTicks&&(s.moveTo(t.tx1,t.ty1),s.lineTo(t.tx2,t.ty2)),c.drawOnChartArea&&(s.moveTo(t.x1,t.y1),s.lineTo(t.x2,t.y2)),s.stroke(),s.restore()),d.display){s.save(),s.translate(t.labelX,t.labelY),s.rotate(t.rotation),s.font=t.major?x.font:y.font,s.fillStyle=t.major?b:v,s.textBaseline=t.textBaseline,s.textAlign=t.textAlign;var i=t.label;if(r.isArray(i))for(var n=i.length,a=1.5*y.size,o=e.isHorizontal()?0:-a*(n-1)/2,l=0;l<n;++l)s.fillText(\"\"+i[l],0,o),o+=a;else s.fillText(i,0,0);s.restore()}}),f.display){var A,F,R=0,L=o(f)/2;if(m)A=e.left+(e.right-e.left)/2,F=\"bottom\"===a.position?e.bottom-L-M.bottom:e.top+L+M.top;else{var W=\"left\"===a.position;A=W?e.left+L+M.top:e.right-L-M.top,F=e.top+(e.bottom-e.top)/2,R=W?-.5*Math.PI:.5*Math.PI}s.save(),s.translate(A,F),s.rotate(R),s.textAlign=\"center\",s.textBaseline=\"middle\",s.fillStyle=k,s.font=w.font,s.fillText(f.labelString,0,0),s.restore()}if(c.drawBorder){s.lineWidth=r.valueAtIndexOrDefault(c.lineWidth,0),s.strokeStyle=r.valueAtIndexOrDefault(c.color,0);var Y=e.left,N=e.right+C,z=e.top,H=e.bottom+C,V=r.aliasPixel(s.lineWidth);m?(z=H=\"top\"===a.position?e.bottom:e.top,z+=V,H+=V):(Y=N=\"left\"===a.position?e.right:e.left,Y+=V,N+=V),s.beginPath(),s.moveTo(Y,z),s.lineTo(N,H),s.stroke()}}}})}},{25:25,26:26,34:34,45:45}],33:[function(t,e,i){\"use strict\";var n=t(25),a=t(45),r=t(30);e.exports=function(t){t.scaleService={constructors:{},defaults:{},registerScaleType:function(t,e,i){this.constructors[t]=e,this.defaults[t]=a.clone(i)},getScaleConstructor:function(t){return this.constructors.hasOwnProperty(t)?this.constructors[t]:void 0},getScaleDefaults:function(t){return this.defaults.hasOwnProperty(t)?a.merge({},[n.scale,this.defaults[t]]):{}},updateScaleDefaults:function(t,e){this.defaults.hasOwnProperty(t)&&(this.defaults[t]=a.extend(this.defaults[t],e))},addScalesToLayout:function(t){a.each(t.scales,function(e){e.fullWidth=e.options.fullWidth,e.position=e.options.position,e.weight=e.options.weight,r.addBox(t,e)})}}}},{25:25,30:30,45:45}],34:[function(t,e,i){\"use strict\";var n=t(45);e.exports={formatters:{values:function(t){return n.isArray(t)?t:\"\"+t},linear:function(t,e,i){var a=i.length>3?i[2]-i[1]:i[1]-i[0];Math.abs(a)>1&&t!==Math.floor(t)&&(a=t-Math.floor(t));var r=n.log10(Math.abs(a)),o=\"\";if(0!==t){var s=-1*Math.floor(r);s=Math.max(Math.min(s,20),0),o=t.toFixed(s)}else o=\"0\";return o},logarithmic:function(t,e,i){var a=t/Math.pow(10,Math.floor(n.log10(t)));return 0===t?\"0\":1===a||2===a||5===a||0===e||e===i.length-1?t.toExponential():\"\"}}}},{45:45}],35:[function(t,e,i){\"use strict\";var n=t(25),a=t(26),r=t(45);n._set(\"global\",{tooltips:{enabled:!0,custom:null,mode:\"nearest\",position:\"average\",intersect:!0,backgroundColor:\"rgba(0,0,0,0.8)\",titleFontStyle:\"bold\",titleSpacing:2,titleMarginBottom:6,titleFontColor:\"#fff\",titleAlign:\"left\",bodySpacing:2,bodyFontColor:\"#fff\",bodyAlign:\"left\",footerFontStyle:\"bold\",footerSpacing:2,footerMarginTop:6,footerFontColor:\"#fff\",footerAlign:\"left\",yPadding:6,xPadding:6,caretPadding:2,caretSize:5,cornerRadius:6,multiKeyBackground:\"#fff\",displayColors:!0,borderColor:\"rgba(0,0,0,0)\",borderWidth:0,callbacks:{beforeTitle:r.noop,title:function(t,e){var i=\"\",n=e.labels,a=n?n.length:0;if(t.length>0){var r=t[0];r.xLabel?i=r.xLabel:a>0&&r.index<a&&(i=n[r.index])}return i},afterTitle:r.noop,beforeBody:r.noop,beforeLabel:r.noop,label:function(t,e){var i=e.datasets[t.datasetIndex].label||\"\";return i&&(i+=\": \"),i+=t.yLabel},labelColor:function(t,e){var i=e.getDatasetMeta(t.datasetIndex).data[t.index]._view;return{borderColor:i.borderColor,backgroundColor:i.backgroundColor}},labelTextColor:function(){return this._options.bodyFontColor},afterLabel:r.noop,afterBody:r.noop,beforeFooter:r.noop,footer:r.noop,afterFooter:r.noop}}}),e.exports=function(t){function e(t,e){var i=r.color(t);return i.alpha(e*i.alpha()).rgbaString()}function i(t,e){return e&&(r.isArray(e)?Array.prototype.push.apply(t,e):t.push(e)),t}function o(t){var e=n.global,i=r.valueOrDefault;return{xPadding:t.xPadding,yPadding:t.yPadding,xAlign:t.xAlign,yAlign:t.yAlign,bodyFontColor:t.bodyFontColor,_bodyFontFamily:i(t.bodyFontFamily,e.defaultFontFamily),_bodyFontStyle:i(t.bodyFontStyle,e.defaultFontStyle),_bodyAlign:t.bodyAlign,bodyFontSize:i(t.bodyFontSize,e.defaultFontSize),bodySpacing:t.bodySpacing,titleFontColor:t.titleFontColor,_titleFontFamily:i(t.titleFontFamily,e.defaultFontFamily),_titleFontStyle:i(t.titleFontStyle,e.defaultFontStyle),titleFontSize:i(t.titleFontSize,e.defaultFontSize),_titleAlign:t.titleAlign,titleSpacing:t.titleSpacing,titleMarginBottom:t.titleMarginBottom,footerFontColor:t.footerFontColor,_footerFontFamily:i(t.footerFontFamily,e.defaultFontFamily),_footerFontStyle:i(t.footerFontStyle,e.defaultFontStyle),footerFontSize:i(t.footerFontSize,e.defaultFontSize),_footerAlign:t.footerAlign,footerSpacing:t.footerSpacing,footerMarginTop:t.footerMarginTop,caretSize:t.caretSize,cornerRadius:t.cornerRadius,backgroundColor:t.backgroundColor,opacity:0,legendColorBackground:t.multiKeyBackground,displayColors:t.displayColors,borderColor:t.borderColor,borderWidth:t.borderWidth}}t.Tooltip=a.extend({initialize:function(){this._model=o(this._options),this._lastActive=[]},getTitle:function(){var t=this._options.callbacks,e=t.beforeTitle.apply(this,arguments),n=t.title.apply(this,arguments),a=t.afterTitle.apply(this,arguments),r=[];return r=i(r=i(r=i(r,e),n),a)},getBeforeBody:function(){var t=this._options.callbacks.beforeBody.apply(this,arguments);return r.isArray(t)?t:void 0!==t?[t]:[]},getBody:function(t,e){var n=this,a=n._options.callbacks,o=[];return r.each(t,function(t){var r={before:[],lines:[],after:[]};i(r.before,a.beforeLabel.call(n,t,e)),i(r.lines,a.label.call(n,t,e)),i(r.after,a.afterLabel.call(n,t,e)),o.push(r)}),o},getAfterBody:function(){var t=this._options.callbacks.afterBody.apply(this,arguments);return r.isArray(t)?t:void 0!==t?[t]:[]},getFooter:function(){var t=this._options.callbacks,e=t.beforeFooter.apply(this,arguments),n=t.footer.apply(this,arguments),a=t.afterFooter.apply(this,arguments),r=[];return r=i(r=i(r=i(r,e),n),a)},update:function(e){var i,n,a,s,l,u,d,h,c,f,g,m,p,v,y,b,x,_,k,w,M=this,S=M._options,D=M._model,C=M._model=o(S),P=M._active,T=M._data,O={xAlign:D.xAlign,yAlign:D.yAlign},I={x:D.x,y:D.y},A={width:D.width,height:D.height},F={x:D.caretX,y:D.caretY};if(P.length){C.opacity=1;var R=[],L=[];F=t.Tooltip.positioners[S.position].call(M,P,M._eventPosition);var W=[];for(i=0,n=P.length;i<n;++i)W.push((b=P[i],x=void 0,_=void 0,void 0,void 0,x=b._xScale,_=b._yScale||b._scale,k=b._index,w=b._datasetIndex,{xLabel:x?x.getLabelForIndex(k,w):\"\",yLabel:_?_.getLabelForIndex(k,w):\"\",index:k,datasetIndex:w,x:b._model.x,y:b._model.y}));S.filter&&(W=W.filter(function(t){return S.filter(t,T)})),S.itemSort&&(W=W.sort(function(t,e){return S.itemSort(t,e,T)})),r.each(W,function(t){R.push(S.callbacks.labelColor.call(M,t,M._chart)),L.push(S.callbacks.labelTextColor.call(M,t,M._chart))}),C.title=M.getTitle(W,T),C.beforeBody=M.getBeforeBody(W,T),C.body=M.getBody(W,T),C.afterBody=M.getAfterBody(W,T),C.footer=M.getFooter(W,T),C.x=Math.round(F.x),C.y=Math.round(F.y),C.caretPadding=S.caretPadding,C.labelColors=R,C.labelTextColors=L,C.dataPoints=W,O=function(t,e){var i,n,a,r,o,s=t._model,l=t._chart,u=t._chart.chartArea,d=\"center\",h=\"center\";s.y<e.height?h=\"top\":s.y>l.height-e.height&&(h=\"bottom\");var c=(u.left+u.right)/2,f=(u.top+u.bottom)/2;\"center\"===h?(i=function(t){return t<=c},n=function(t){return t>c}):(i=function(t){return t<=e.width/2},n=function(t){return t>=l.width-e.width/2}),a=function(t){return t+e.width+s.caretSize+s.caretPadding>l.width},r=function(t){return t-e.width-s.caretSize-s.caretPadding<0},o=function(t){return t<=f?\"top\":\"bottom\"},i(s.x)?(d=\"left\",a(s.x)&&(d=\"center\",h=o(s.y))):n(s.x)&&(d=\"right\",r(s.x)&&(d=\"center\",h=o(s.y)));var g=t._options;return{xAlign:g.xAlign?g.xAlign:d,yAlign:g.yAlign?g.yAlign:h}}(this,A=function(t,e){var i=t._chart.ctx,n=2*e.yPadding,a=0,o=e.body,s=o.reduce(function(t,e){return t+e.before.length+e.lines.length+e.after.length},0);s+=e.beforeBody.length+e.afterBody.length;var l=e.title.length,u=e.footer.length,d=e.titleFontSize,h=e.bodyFontSize,c=e.footerFontSize;n+=l*d,n+=l?(l-1)*e.titleSpacing:0,n+=l?e.titleMarginBottom:0,n+=s*h,n+=s?(s-1)*e.bodySpacing:0,n+=u?e.footerMarginTop:0,n+=u*c,n+=u?(u-1)*e.footerSpacing:0;var f=0,g=function(t){a=Math.max(a,i.measureText(t).width+f)};return i.font=r.fontString(d,e._titleFontStyle,e._titleFontFamily),r.each(e.title,g),i.font=r.fontString(h,e._bodyFontStyle,e._bodyFontFamily),r.each(e.beforeBody.concat(e.afterBody),g),f=e.displayColors?h+2:0,r.each(o,function(t){r.each(t.before,g),r.each(t.lines,g),r.each(t.after,g)}),f=0,i.font=r.fontString(c,e._footerFontStyle,e._footerFontFamily),r.each(e.footer,g),{width:a+=2*e.xPadding,height:n}}(this,C)),a=C,s=A,l=O,u=M._chart,d=a.x,h=a.y,c=a.caretSize,f=a.caretPadding,g=a.cornerRadius,m=l.xAlign,p=l.yAlign,v=c+f,y=g+f,\"right\"===m?d-=s.width:\"center\"===m&&((d-=s.width/2)+s.width>u.width&&(d=u.width-s.width),d<0&&(d=0)),\"top\"===p?h+=v:h-=\"bottom\"===p?s.height+v:s.height/2,\"center\"===p?\"left\"===m?d+=v:\"right\"===m&&(d-=v):\"left\"===m?d-=y:\"right\"===m&&(d+=y),I={x:d,y:h}}else C.opacity=0;return C.xAlign=O.xAlign,C.yAlign=O.yAlign,C.x=I.x,C.y=I.y,C.width=A.width,C.height=A.height,C.caretX=F.x,C.caretY=F.y,M._model=C,e&&S.custom&&S.custom.call(M,C),M},drawCaret:function(t,e){var i=this._chart.ctx,n=this._view,a=this.getCaretPosition(t,e,n);i.lineTo(a.x1,a.y1),i.lineTo(a.x2,a.y2),i.lineTo(a.x3,a.y3)},getCaretPosition:function(t,e,i){var n,a,r,o,s,l,u=i.caretSize,d=i.cornerRadius,h=i.xAlign,c=i.yAlign,f=t.x,g=t.y,m=e.width,p=e.height;if(\"center\"===c)s=g+p/2,\"left\"===h?(a=(n=f)-u,r=n,o=s+u,l=s-u):(a=(n=f+m)+u,r=n,o=s-u,l=s+u);else if(\"left\"===h?(n=(a=f+d+u)-u,r=a+u):\"right\"===h?(n=(a=f+m-d-u)-u,r=a+u):(n=(a=i.caretX)-u,r=a+u),\"top\"===c)s=(o=g)-u,l=o;else{s=(o=g+p)+u,l=o;var v=r;r=n,n=v}return{x1:n,x2:a,x3:r,y1:o,y2:s,y3:l}},drawTitle:function(t,i,n,a){var o=i.title;if(o.length){n.textAlign=i._titleAlign,n.textBaseline=\"top\";var s,l,u=i.titleFontSize,d=i.titleSpacing;for(n.fillStyle=e(i.titleFontColor,a),n.font=r.fontString(u,i._titleFontStyle,i._titleFontFamily),s=0,l=o.length;s<l;++s)n.fillText(o[s],t.x,t.y),t.y+=u+d,s+1===o.length&&(t.y+=i.titleMarginBottom-d)}},drawBody:function(t,i,n,a){var o=i.bodyFontSize,s=i.bodySpacing,l=i.body;n.textAlign=i._bodyAlign,n.textBaseline=\"top\",n.font=r.fontString(o,i._bodyFontStyle,i._bodyFontFamily);var u=0,d=function(e){n.fillText(e,t.x+u,t.y),t.y+=o+s};n.fillStyle=e(i.bodyFontColor,a),r.each(i.beforeBody,d);var h=i.displayColors;u=h?o+2:0,r.each(l,function(s,l){var u=e(i.labelTextColors[l],a);n.fillStyle=u,r.each(s.before,d),r.each(s.lines,function(r){h&&(n.fillStyle=e(i.legendColorBackground,a),n.fillRect(t.x,t.y,o,o),n.lineWidth=1,n.strokeStyle=e(i.labelColors[l].borderColor,a),n.strokeRect(t.x,t.y,o,o),n.fillStyle=e(i.labelColors[l].backgroundColor,a),n.fillRect(t.x+1,t.y+1,o-2,o-2),n.fillStyle=u),d(r)}),r.each(s.after,d)}),u=0,r.each(i.afterBody,d),t.y-=s},drawFooter:function(t,i,n,a){var o=i.footer;o.length&&(t.y+=i.footerMarginTop,n.textAlign=i._footerAlign,n.textBaseline=\"top\",n.fillStyle=e(i.footerFontColor,a),n.font=r.fontString(i.footerFontSize,i._footerFontStyle,i._footerFontFamily),r.each(o,function(e){n.fillText(e,t.x,t.y),t.y+=i.footerFontSize+i.footerSpacing}))},drawBackground:function(t,i,n,a,r){n.fillStyle=e(i.backgroundColor,r),n.strokeStyle=e(i.borderColor,r),n.lineWidth=i.borderWidth;var o=i.xAlign,s=i.yAlign,l=t.x,u=t.y,d=a.width,h=a.height,c=i.cornerRadius;n.beginPath(),n.moveTo(l+c,u),\"top\"===s&&this.drawCaret(t,a),n.lineTo(l+d-c,u),n.quadraticCurveTo(l+d,u,l+d,u+c),\"center\"===s&&\"right\"===o&&this.drawCaret(t,a),n.lineTo(l+d,u+h-c),n.quadraticCurveTo(l+d,u+h,l+d-c,u+h),\"bottom\"===s&&this.drawCaret(t,a),n.lineTo(l+c,u+h),n.quadraticCurveTo(l,u+h,l,u+h-c),\"center\"===s&&\"left\"===o&&this.drawCaret(t,a),n.lineTo(l,u+c),n.quadraticCurveTo(l,u,l+c,u),n.closePath(),n.fill(),i.borderWidth>0&&n.stroke()},draw:function(){var t=this._chart.ctx,e=this._view;if(0!==e.opacity){var i={width:e.width,height:e.height},n={x:e.x,y:e.y},a=Math.abs(e.opacity<.001)?0:e.opacity,r=e.title.length||e.beforeBody.length||e.body.length||e.afterBody.length||e.footer.length;this._options.enabled&&r&&(this.drawBackground(n,e,t,i,a),n.x+=e.xPadding,n.y+=e.yPadding,this.drawTitle(n,e,t,a),this.drawBody(n,e,t,a),this.drawFooter(n,e,t,a))}},handleEvent:function(t){var e,i=this,n=i._options;return i._lastActive=i._lastActive||[],\"mouseout\"===t.type?i._active=[]:i._active=i._chart.getElementsAtEventForMode(t,n.mode,n),(e=!r.arrayEquals(i._active,i._lastActive))&&(i._lastActive=i._active,(n.enabled||n.custom)&&(i._eventPosition={x:t.x,y:t.y},i.update(!0),i.pivot())),e}}),t.Tooltip.positioners={average:function(t){if(!t.length)return!1;var e,i,n=0,a=0,r=0;for(e=0,i=t.length;e<i;++e){var o=t[e];if(o&&o.hasValue()){var s=o.tooltipPosition();n+=s.x,a+=s.y,++r}}return{x:Math.round(n/r),y:Math.round(a/r)}},nearest:function(t,e){var i,n,a,o=e.x,s=e.y,l=Number.POSITIVE_INFINITY;for(i=0,n=t.length;i<n;++i){var u=t[i];if(u&&u.hasValue()){var d=u.getCenterPoint(),h=r.distanceBetweenPoints(e,d);h<l&&(l=h,a=u)}}if(a){var c=a.tooltipPosition();o=c.x,s=c.y}return{x:o,y:s}}}}},{25:25,26:26,45:45}],36:[function(t,e,i){\"use strict\";var n=t(25),a=t(26),r=t(45);n._set(\"global\",{elements:{arc:{backgroundColor:n.global.defaultColor,borderColor:\"#fff\",borderWidth:2}}}),e.exports=a.extend({inLabelRange:function(t){var e=this._view;return!!e&&Math.pow(t-e.x,2)<Math.pow(e.radius+e.hoverRadius,2)},inRange:function(t,e){var i=this._view;if(i){for(var n=r.getAngleFromPoint(i,{x:t,y:e}),a=n.angle,o=n.distance,s=i.startAngle,l=i.endAngle;l<s;)l+=2*Math.PI;for(;a>l;)a-=2*Math.PI;for(;a<s;)a+=2*Math.PI;var u=a>=s&&a<=l,d=o>=i.innerRadius&&o<=i.outerRadius;return u&&d}return!1},getCenterPoint:function(){var t=this._view,e=(t.startAngle+t.endAngle)/2,i=(t.innerRadius+t.outerRadius)/2;return{x:t.x+Math.cos(e)*i,y:t.y+Math.sin(e)*i}},getArea:function(){var t=this._view;return Math.PI*((t.endAngle-t.startAngle)/(2*Math.PI))*(Math.pow(t.outerRadius,2)-Math.pow(t.innerRadius,2))},tooltipPosition:function(){var t=this._view,e=t.startAngle+(t.endAngle-t.startAngle)/2,i=(t.outerRadius-t.innerRadius)/2+t.innerRadius;return{x:t.x+Math.cos(e)*i,y:t.y+Math.sin(e)*i}},draw:function(){var t=this._chart.ctx,e=this._view,i=e.startAngle,n=e.endAngle;t.beginPath(),t.arc(e.x,e.y,e.outerRadius,i,n),t.arc(e.x,e.y,e.innerRadius,n,i,!0),t.closePath(),t.strokeStyle=e.borderColor,t.lineWidth=e.borderWidth,t.fillStyle=e.backgroundColor,t.fill(),t.lineJoin=\"bevel\",e.borderWidth&&t.stroke()}})},{25:25,26:26,45:45}],37:[function(t,e,i){\"use strict\";var n=t(25),a=t(26),r=t(45),o=n.global;n._set(\"global\",{elements:{line:{tension:.4,backgroundColor:o.defaultColor,borderWidth:3,borderColor:o.defaultColor,borderCapStyle:\"butt\",borderDash:[],borderDashOffset:0,borderJoinStyle:\"miter\",capBezierPoints:!0,fill:!0}}}),e.exports=a.extend({draw:function(){var t,e,i,n,a=this._view,s=this._chart.ctx,l=a.spanGaps,u=this._children.slice(),d=o.elements.line,h=-1;for(this._loop&&u.length&&u.push(u[0]),s.save(),s.lineCap=a.borderCapStyle||d.borderCapStyle,s.setLineDash&&s.setLineDash(a.borderDash||d.borderDash),s.lineDashOffset=a.borderDashOffset||d.borderDashOffset,s.lineJoin=a.borderJoinStyle||d.borderJoinStyle,s.lineWidth=a.borderWidth||d.borderWidth,s.strokeStyle=a.borderColor||o.defaultColor,s.beginPath(),h=-1,t=0;t<u.length;++t)e=u[t],i=r.previousItem(u,t),n=e._view,0===t?n.skip||(s.moveTo(n.x,n.y),h=t):(i=-1===h?i:u[h],n.skip||(h!==t-1&&!l||-1===h?s.moveTo(n.x,n.y):r.canvas.lineTo(s,i._view,e._view),h=t));s.stroke(),s.restore()}})},{25:25,26:26,45:45}],38:[function(t,e,i){\"use strict\";var n=t(25),a=t(26),r=t(45),o=n.global.defaultColor;function s(t){var e=this._view;return!!e&&Math.abs(t-e.x)<e.radius+e.hitRadius}n._set(\"global\",{elements:{point:{radius:3,pointStyle:\"circle\",backgroundColor:o,borderColor:o,borderWidth:1,hitRadius:1,hoverRadius:4,hoverBorderWidth:1}}}),e.exports=a.extend({inRange:function(t,e){var i=this._view;return!!i&&Math.pow(t-i.x,2)+Math.pow(e-i.y,2)<Math.pow(i.hitRadius+i.radius,2)},inLabelRange:s,inXRange:s,inYRange:function(t){var e=this._view;return!!e&&Math.abs(t-e.y)<e.radius+e.hitRadius},getCenterPoint:function(){var t=this._view;return{x:t.x,y:t.y}},getArea:function(){return Math.PI*Math.pow(this._view.radius,2)},tooltipPosition:function(){var t=this._view;return{x:t.x,y:t.y,padding:t.radius+t.borderWidth}},draw:function(t){var e=this._view,i=this._model,a=this._chart.ctx,s=e.pointStyle,l=e.radius,u=e.x,d=e.y,h=r.color,c=0;e.skip||(a.strokeStyle=e.borderColor||o,a.lineWidth=r.valueOrDefault(e.borderWidth,n.global.elements.point.borderWidth),a.fillStyle=e.backgroundColor||o,void 0!==t&&(i.x<t.left||1.01*t.right<i.x||i.y<t.top||1.01*t.bottom<i.y)&&(i.x<t.left?c=(u-i.x)/(t.left-i.x):1.01*t.right<i.x?c=(i.x-u)/(i.x-t.right):i.y<t.top?c=(d-i.y)/(t.top-i.y):1.01*t.bottom<i.y&&(c=(i.y-d)/(i.y-t.bottom)),c=Math.round(100*c)/100,a.strokeStyle=h(a.strokeStyle).alpha(c).rgbString(),a.fillStyle=h(a.fillStyle).alpha(c).rgbString()),r.canvas.drawPoint(a,s,l,u,d))}})},{25:25,26:26,45:45}],39:[function(t,e,i){\"use strict\";var n=t(25),a=t(26);function r(t){return void 0!==t._view.width}function o(t){var e,i,n,a,o=t._view;if(r(t)){var s=o.width/2;e=o.x-s,i=o.x+s,n=Math.min(o.y,o.base),a=Math.max(o.y,o.base)}else{var l=o.height/2;e=Math.min(o.x,o.base),i=Math.max(o.x,o.base),n=o.y-l,a=o.y+l}return{left:e,top:n,right:i,bottom:a}}n._set(\"global\",{elements:{rectangle:{backgroundColor:n.global.defaultColor,borderColor:n.global.defaultColor,borderSkipped:\"bottom\",borderWidth:0}}}),e.exports=a.extend({draw:function(){var t,e,i,n,a,r,o,s=this._chart.ctx,l=this._view,u=l.borderWidth;if(l.horizontal?(t=l.base,e=l.x,i=l.y-l.height/2,n=l.y+l.height/2,a=e>t?1:-1,r=1,o=l.borderSkipped||\"left\"):(t=l.x-l.width/2,e=l.x+l.width/2,i=l.y,a=1,r=(n=l.base)>i?1:-1,o=l.borderSkipped||\"bottom\"),u){var d=Math.min(Math.abs(t-e),Math.abs(i-n)),h=(u=u>d?d:u)/2,c=t+(\"left\"!==o?h*a:0),f=e+(\"right\"!==o?-h*a:0),g=i+(\"top\"!==o?h*r:0),m=n+(\"bottom\"!==o?-h*r:0);c!==f&&(i=g,n=m),g!==m&&(t=c,e=f)}s.beginPath(),s.fillStyle=l.backgroundColor,s.strokeStyle=l.borderColor,s.lineWidth=u;var p=[[t,n],[t,i],[e,i],[e,n]],v=[\"bottom\",\"left\",\"top\",\"right\"].indexOf(o,0);function y(t){return p[(v+t)%4]}-1===v&&(v=0);var b=y(0);s.moveTo(b[0],b[1]);for(var x=1;x<4;x++)b=y(x),s.lineTo(b[0],b[1]);s.fill(),u&&s.stroke()},height:function(){var t=this._view;return t.base-t.y},inRange:function(t,e){var i=!1;if(this._view){var n=o(this);i=t>=n.left&&t<=n.right&&e>=n.top&&e<=n.bottom}return i},inLabelRange:function(t,e){if(!this._view)return!1;var i=o(this);return r(this)?t>=i.left&&t<=i.right:e>=i.top&&e<=i.bottom},inXRange:function(t){var e=o(this);return t>=e.left&&t<=e.right},inYRange:function(t){var e=o(this);return t>=e.top&&t<=e.bottom},getCenterPoint:function(){var t,e,i=this._view;return r(this)?(t=i.x,e=(i.y+i.base)/2):(t=(i.x+i.base)/2,e=i.y),{x:t,y:e}},getArea:function(){var t=this._view;return t.width*Math.abs(t.y-t.base)},tooltipPosition:function(){var t=this._view;return{x:t.x,y:t.y}}})},{25:25,26:26}],40:[function(t,e,i){\"use strict\";e.exports={},e.exports.Arc=t(36),e.exports.Line=t(37),e.exports.Point=t(38),e.exports.Rectangle=t(39)},{36:36,37:37,38:38,39:39}],41:[function(t,e,i){\"use strict\";var n=t(42);i=e.exports={clear:function(t){t.ctx.clearRect(0,0,t.width,t.height)},roundedRect:function(t,e,i,n,a,r){if(r){var o=Math.min(r,n/2),s=Math.min(r,a/2);t.moveTo(e+o,i),t.lineTo(e+n-o,i),t.quadraticCurveTo(e+n,i,e+n,i+s),t.lineTo(e+n,i+a-s),t.quadraticCurveTo(e+n,i+a,e+n-o,i+a),t.lineTo(e+o,i+a),t.quadraticCurveTo(e,i+a,e,i+a-s),t.lineTo(e,i+s),t.quadraticCurveTo(e,i,e+o,i)}else t.rect(e,i,n,a)},drawPoint:function(t,e,i,n,a){var r,o,s,l,u,d;if(!e||\"object\"!=typeof e||\"[object HTMLImageElement]\"!==(r=e.toString())&&\"[object HTMLCanvasElement]\"!==r){if(!(isNaN(i)||i<=0)){switch(e){default:t.beginPath(),t.arc(n,a,i,0,2*Math.PI),t.closePath(),t.fill();break;case\"triangle\":t.beginPath(),u=(o=3*i/Math.sqrt(3))*Math.sqrt(3)/2,t.moveTo(n-o/2,a+u/3),t.lineTo(n+o/2,a+u/3),t.lineTo(n,a-2*u/3),t.closePath(),t.fill();break;case\"rect\":d=1/Math.SQRT2*i,t.beginPath(),t.fillRect(n-d,a-d,2*d,2*d),t.strokeRect(n-d,a-d,2*d,2*d);break;case\"rectRounded\":var h=i/Math.SQRT2,c=n-h,f=a-h,g=Math.SQRT2*i;t.beginPath(),this.roundedRect(t,c,f,g,g,i/2),t.closePath(),t.fill();break;case\"rectRot\":d=1/Math.SQRT2*i,t.beginPath(),t.moveTo(n-d,a),t.lineTo(n,a+d),t.lineTo(n+d,a),t.lineTo(n,a-d),t.closePath(),t.fill();break;case\"cross\":t.beginPath(),t.moveTo(n,a+i),t.lineTo(n,a-i),t.moveTo(n-i,a),t.lineTo(n+i,a),t.closePath();break;case\"crossRot\":t.beginPath(),s=Math.cos(Math.PI/4)*i,l=Math.sin(Math.PI/4)*i,t.moveTo(n-s,a-l),t.lineTo(n+s,a+l),t.moveTo(n-s,a+l),t.lineTo(n+s,a-l),t.closePath();break;case\"star\":t.beginPath(),t.moveTo(n,a+i),t.lineTo(n,a-i),t.moveTo(n-i,a),t.lineTo(n+i,a),s=Math.cos(Math.PI/4)*i,l=Math.sin(Math.PI/4)*i,t.moveTo(n-s,a-l),t.lineTo(n+s,a+l),t.moveTo(n-s,a+l),t.lineTo(n+s,a-l),t.closePath();break;case\"line\":t.beginPath(),t.moveTo(n-i,a),t.lineTo(n+i,a),t.closePath();break;case\"dash\":t.beginPath(),t.moveTo(n,a),t.lineTo(n+i,a),t.closePath()}t.stroke()}}else t.drawImage(e,n-e.width/2,a-e.height/2,e.width,e.height)},clipArea:function(t,e){t.save(),t.beginPath(),t.rect(e.left,e.top,e.right-e.left,e.bottom-e.top),t.clip()},unclipArea:function(t){t.restore()},lineTo:function(t,e,i,n){if(i.steppedLine)return\"after\"===i.steppedLine&&!n||\"after\"!==i.steppedLine&&n?t.lineTo(e.x,i.y):t.lineTo(i.x,e.y),void t.lineTo(i.x,i.y);i.tension?t.bezierCurveTo(n?e.controlPointPreviousX:e.controlPointNextX,n?e.controlPointPreviousY:e.controlPointNextY,n?i.controlPointNextX:i.controlPointPreviousX,n?i.controlPointNextY:i.controlPointPreviousY,i.x,i.y):t.lineTo(i.x,i.y)}};n.clear=i.clear,n.drawRoundedRectangle=function(t){t.beginPath(),i.roundedRect.apply(i,arguments),t.closePath()}},{42:42}],42:[function(t,e,i){\"use strict\";var n,a={noop:function(){},uid:(n=0,function(){return n++}),isNullOrUndef:function(t){return null==t},isArray:Array.isArray?Array.isArray:function(t){return\"[object Array]\"===Object.prototype.toString.call(t)},isObject:function(t){return null!==t&&\"[object Object]\"===Object.prototype.toString.call(t)},valueOrDefault:function(t,e){return void 0===t?e:t},valueAtIndexOrDefault:function(t,e,i){return a.valueOrDefault(a.isArray(t)?t[e]:t,i)},callback:function(t,e,i){if(t&&\"function\"==typeof t.call)return t.apply(i,e)},each:function(t,e,i,n){var r,o,s;if(a.isArray(t))if(o=t.length,n)for(r=o-1;r>=0;r--)e.call(i,t[r],r);else for(r=0;r<o;r++)e.call(i,t[r],r);else if(a.isObject(t))for(o=(s=Object.keys(t)).length,r=0;r<o;r++)e.call(i,t[s[r]],s[r])},arrayEquals:function(t,e){var i,n,r,o;if(!t||!e||t.length!==e.length)return!1;for(i=0,n=t.length;i<n;++i)if(r=t[i],o=e[i],r instanceof Array&&o instanceof Array){if(!a.arrayEquals(r,o))return!1}else if(r!==o)return!1;return!0},clone:function(t){if(a.isArray(t))return t.map(a.clone);if(a.isObject(t)){for(var e={},i=Object.keys(t),n=i.length,r=0;r<n;++r)e[i[r]]=a.clone(t[i[r]]);return e}return t},_merger:function(t,e,i,n){var r=e[t],o=i[t];a.isObject(r)&&a.isObject(o)?a.merge(r,o,n):e[t]=a.clone(o)},_mergerIf:function(t,e,i){var n=e[t],r=i[t];a.isObject(n)&&a.isObject(r)?a.mergeIf(n,r):e.hasOwnProperty(t)||(e[t]=a.clone(r))},merge:function(t,e,i){var n,r,o,s,l,u=a.isArray(e)?e:[e],d=u.length;if(!a.isObject(t))return t;for(n=(i=i||{}).merger||a._merger,r=0;r<d;++r)if(e=u[r],a.isObject(e))for(l=0,s=(o=Object.keys(e)).length;l<s;++l)n(o[l],t,e,i);return t},mergeIf:function(t,e){return a.merge(t,e,{merger:a._mergerIf})},extend:function(t){for(var e=function(e,i){t[i]=e},i=1,n=arguments.length;i<n;++i)a.each(arguments[i],e);return t},inherits:function(t){var e=this,i=t&&t.hasOwnProperty(\"constructor\")?t.constructor:function(){return e.apply(this,arguments)},n=function(){this.constructor=i};return n.prototype=e.prototype,i.prototype=new n,i.extend=a.inherits,t&&a.extend(i.prototype,t),i.__super__=e.prototype,i}};e.exports=a,a.callCallback=a.callback,a.indexOf=function(t,e,i){return Array.prototype.indexOf.call(t,e,i)},a.getValueOrDefault=a.valueOrDefault,a.getValueAtIndexOrDefault=a.valueAtIndexOrDefault},{}],43:[function(t,e,i){\"use strict\";var n=t(42),a={linear:function(t){return t},easeInQuad:function(t){return t*t},easeOutQuad:function(t){return-t*(t-2)},easeInOutQuad:function(t){return(t/=.5)<1?.5*t*t:-.5*(--t*(t-2)-1)},easeInCubic:function(t){return t*t*t},easeOutCubic:function(t){return(t-=1)*t*t+1},easeInOutCubic:function(t){return(t/=.5)<1?.5*t*t*t:.5*((t-=2)*t*t+2)},easeInQuart:function(t){return t*t*t*t},easeOutQuart:function(t){return-((t-=1)*t*t*t-1)},easeInOutQuart:function(t){return(t/=.5)<1?.5*t*t*t*t:-.5*((t-=2)*t*t*t-2)},easeInQuint:function(t){return t*t*t*t*t},easeOutQuint:function(t){return(t-=1)*t*t*t*t+1},easeInOutQuint:function(t){return(t/=.5)<1?.5*t*t*t*t*t:.5*((t-=2)*t*t*t*t+2)},easeInSine:function(t){return 1-Math.cos(t*(Math.PI/2))},easeOutSine:function(t){return Math.sin(t*(Math.PI/2))},easeInOutSine:function(t){return-.5*(Math.cos(Math.PI*t)-1)},easeInExpo:function(t){return 0===t?0:Math.pow(2,10*(t-1))},easeOutExpo:function(t){return 1===t?1:1-Math.pow(2,-10*t)},easeInOutExpo:function(t){return 0===t?0:1===t?1:(t/=.5)<1?.5*Math.pow(2,10*(t-1)):.5*(2-Math.pow(2,-10*--t))},easeInCirc:function(t){return t>=1?t:-(Math.sqrt(1-t*t)-1)},easeOutCirc:function(t){return Math.sqrt(1-(t-=1)*t)},easeInOutCirc:function(t){return(t/=.5)<1?-.5*(Math.sqrt(1-t*t)-1):.5*(Math.sqrt(1-(t-=2)*t)+1)},easeInElastic:function(t){var e=1.70158,i=0,n=1;return 0===t?0:1===t?1:(i||(i=.3),n<1?(n=1,e=i/4):e=i/(2*Math.PI)*Math.asin(1/n),-n*Math.pow(2,10*(t-=1))*Math.sin((t-e)*(2*Math.PI)/i))},easeOutElastic:function(t){var e=1.70158,i=0,n=1;return 0===t?0:1===t?1:(i||(i=.3),n<1?(n=1,e=i/4):e=i/(2*Math.PI)*Math.asin(1/n),n*Math.pow(2,-10*t)*Math.sin((t-e)*(2*Math.PI)/i)+1)},easeInOutElastic:function(t){var e=1.70158,i=0,n=1;return 0===t?0:2==(t/=.5)?1:(i||(i=.45),n<1?(n=1,e=i/4):e=i/(2*Math.PI)*Math.asin(1/n),t<1?n*Math.pow(2,10*(t-=1))*Math.sin((t-e)*(2*Math.PI)/i)*-.5:n*Math.pow(2,-10*(t-=1))*Math.sin((t-e)*(2*Math.PI)/i)*.5+1)},easeInBack:function(t){return t*t*(2.70158*t-1.70158)},easeOutBack:function(t){return(t-=1)*t*(2.70158*t+1.70158)+1},easeInOutBack:function(t){var e=1.70158;return(t/=.5)<1?t*t*((1+(e*=1.525))*t-e)*.5:.5*((t-=2)*t*((1+(e*=1.525))*t+e)+2)},easeInBounce:function(t){return 1-a.easeOutBounce(1-t)},easeOutBounce:function(t){return t<1/2.75?7.5625*t*t:t<2/2.75?7.5625*(t-=1.5/2.75)*t+.75:t<2.5/2.75?7.5625*(t-=2.25/2.75)*t+.9375:7.5625*(t-=2.625/2.75)*t+.984375},easeInOutBounce:function(t){return t<.5?.5*a.easeInBounce(2*t):.5*a.easeOutBounce(2*t-1)+.5}};e.exports={effects:a},n.easingEffects=a},{42:42}],44:[function(t,e,i){\"use strict\";var n=t(42);e.exports={toLineHeight:function(t,e){var i=(\"\"+t).match(/^(normal|(\\d+(?:\\.\\d+)?)(px|em|%)?)$/);if(!i||\"normal\"===i[1])return 1.2*e;switch(t=+i[2],i[3]){case\"px\":return t;case\"%\":t/=100}return e*t},toPadding:function(t){var e,i,a,r;return n.isObject(t)?(e=+t.top||0,i=+t.right||0,a=+t.bottom||0,r=+t.left||0):e=i=a=r=+t||0,{top:e,right:i,bottom:a,left:r,height:e+a,width:r+i}},resolve:function(t,e,i){var a,r,o;for(a=0,r=t.length;a<r;++a)if(void 0!==(o=t[a])&&(void 0!==e&&\"function\"==typeof o&&(o=o(e)),void 0!==i&&n.isArray(o)&&(o=o[i]),void 0!==o))return o}}},{42:42}],45:[function(t,e,i){\"use strict\";e.exports=t(42),e.exports.easing=t(43),e.exports.canvas=t(41),e.exports.options=t(44)},{41:41,42:42,43:43,44:44}],46:[function(t,e,i){e.exports={acquireContext:function(t){return t&&t.canvas&&(t=t.canvas),t&&t.getContext(\"2d\")||null}}},{}],47:[function(t,e,i){\"use strict\";var n=t(45),a=\"$chartjs\",r=\"chartjs-\",o=r+\"render-monitor\",s=r+\"render-animation\",l=[\"animationstart\",\"webkitAnimationStart\"],u={touchstart:\"mousedown\",touchmove:\"mousemove\",touchend:\"mouseup\",pointerenter:\"mouseenter\",pointerdown:\"mousedown\",pointermove:\"mousemove\",pointerup:\"mouseup\",pointerleave:\"mouseout\",pointerout:\"mouseout\"};function d(t,e){var i=n.getStyle(t,e),a=i&&i.match(/^(\\d+)(\\.\\d+)?px$/);return a?Number(a[1]):void 0}var h=!!function(){var t=!1;try{var e=Object.defineProperty({},\"passive\",{get:function(){t=!0}});window.addEventListener(\"e\",null,e)}catch(t){}return t}()&&{passive:!0};function c(t,e,i){t.addEventListener(e,i,h)}function f(t,e,i){t.removeEventListener(e,i,h)}function g(t,e,i,n,a){return{type:t,chart:e,native:a||null,x:void 0!==i?i:null,y:void 0!==n?n:null}}function m(t,e,i){var u,d,h,f,m,p,v,y,b=t[a]||(t[a]={}),x=b.resizer=function(t){var e=document.createElement(\"div\"),i=r+\"size-monitor\",n=\"position:absolute;left:0;top:0;right:0;bottom:0;overflow:hidden;pointer-events:none;visibility:hidden;z-index:-1;\";e.style.cssText=n,e.className=i,e.innerHTML='<div class=\"'+i+'-expand\" style=\"'+n+'\"><div style=\"position:absolute;width:1000000px;height:1000000px;left:0;top:0\"></div></div><div class=\"'+i+'-shrink\" style=\"'+n+'\"><div style=\"position:absolute;width:200%;height:200%;left:0; top:0\"></div></div>';var a=e.childNodes[0],o=e.childNodes[1];e._reset=function(){a.scrollLeft=1e6,a.scrollTop=1e6,o.scrollLeft=1e6,o.scrollTop=1e6};var s=function(){e._reset(),t()};return c(a,\"scroll\",s.bind(a,\"expand\")),c(o,\"scroll\",s.bind(o,\"shrink\")),e}((u=function(){if(b.resizer)return e(g(\"resize\",i))},h=!1,f=[],function(){f=Array.prototype.slice.call(arguments),d=d||this,h||(h=!0,n.requestAnimFrame.call(window,function(){h=!1,u.apply(d,f)}))}));p=function(){if(b.resizer){var e=t.parentNode;e&&e!==x.parentNode&&e.insertBefore(x,e.firstChild),x._reset()}},v=(m=t)[a]||(m[a]={}),y=v.renderProxy=function(t){t.animationName===s&&p()},n.each(l,function(t){c(m,t,y)}),v.reflow=!!m.offsetParent,m.classList.add(o)}function p(t){var e,i,r,s=t[a]||{},u=s.resizer;delete s.resizer,i=(e=t)[a]||{},(r=i.renderProxy)&&(n.each(l,function(t){f(e,t,r)}),delete i.renderProxy),e.classList.remove(o),u&&u.parentNode&&u.parentNode.removeChild(u)}e.exports={_enabled:\"undefined\"!=typeof window&&\"undefined\"!=typeof document,initialize:function(){var t,e,i,n=\"from{opacity:0.99}to{opacity:1}\";e=\"@-webkit-keyframes \"+s+\"{\"+n+\"}@keyframes \"+s+\"{\"+n+\"}.\"+o+\"{-webkit-animation:\"+s+\" 0.001s;animation:\"+s+\" 0.001s;}\",i=(t=this)._style||document.createElement(\"style\"),t._style||(t._style=i,e=\"/* Chart.js */\\n\"+e,i.setAttribute(\"type\",\"text/css\"),document.getElementsByTagName(\"head\")[0].appendChild(i)),i.appendChild(document.createTextNode(e))},acquireContext:function(t,e){\"string\"==typeof t?t=document.getElementById(t):t.length&&(t=t[0]),t&&t.canvas&&(t=t.canvas);var i=t&&t.getContext&&t.getContext(\"2d\");return i&&i.canvas===t?(function(t,e){var i=t.style,n=t.getAttribute(\"height\"),r=t.getAttribute(\"width\");if(t[a]={initial:{height:n,width:r,style:{display:i.display,height:i.height,width:i.width}}},i.display=i.display||\"block\",null===r||\"\"===r){var o=d(t,\"width\");void 0!==o&&(t.width=o)}if(null===n||\"\"===n)if(\"\"===t.style.height)t.height=t.width/(e.options.aspectRatio||2);else{var s=d(t,\"height\");void 0!==o&&(t.height=s)}}(t,e),i):null},releaseContext:function(t){var e=t.canvas;if(e[a]){var i=e[a].initial;[\"height\",\"width\"].forEach(function(t){var a=i[t];n.isNullOrUndef(a)?e.removeAttribute(t):e.setAttribute(t,a)}),n.each(i.style||{},function(t,i){e.style[i]=t}),e.width=e.width,delete e[a]}},addEventListener:function(t,e,i){var r=t.canvas;if(\"resize\"!==e){var o=i[a]||(i[a]={});c(r,e,(o.proxies||(o.proxies={}))[t.id+\"_\"+e]=function(e){var a,r,o,s;i((r=t,o=u[(a=e).type]||a.type,s=n.getRelativePosition(a,r),g(o,r,s.x,s.y,a)))})}else m(r,i,t)},removeEventListener:function(t,e,i){var n=t.canvas;if(\"resize\"!==e){var r=((i[a]||{}).proxies||{})[t.id+\"_\"+e];r&&f(n,e,r)}else p(n)}},n.addEvent=c,n.removeEvent=f},{45:45}],48:[function(t,e,i){\"use strict\";var n=t(45),a=t(46),r=t(47),o=r._enabled?r:a;e.exports=n.extend({initialize:function(){},acquireContext:function(){},releaseContext:function(){},addEventListener:function(){},removeEventListener:function(){}},o)},{45:45,46:46,47:47}],49:[function(t,e,i){\"use strict\";e.exports={},e.exports.filler=t(50),e.exports.legend=t(51),e.exports.title=t(52)},{50:50,51:51,52:52}],50:[function(t,e,i){\"use strict\";var n=t(25),a=t(40),r=t(45);n._set(\"global\",{plugins:{filler:{propagate:!0}}});var o={dataset:function(t){var e=t.fill,i=t.chart,n=i.getDatasetMeta(e),a=n&&i.isDatasetVisible(e)&&n.dataset._children||[],r=a.length||0;return r?function(t,e){return e<r&&a[e]._view||null}:null},boundary:function(t){var e=t.boundary,i=e?e.x:null,n=e?e.y:null;return function(t){return{x:null===i?t.x:i,y:null===n?t.y:n}}}};function s(t,e,i){var n,a=t._model||{},r=a.fill;if(void 0===r&&(r=!!a.backgroundColor),!1===r||null===r)return!1;if(!0===r)return\"origin\";if(n=parseFloat(r,10),isFinite(n)&&Math.floor(n)===n)return\"-\"!==r[0]&&\"+\"!==r[0]||(n=e+n),!(n===e||n<0||n>=i)&&n;switch(r){case\"bottom\":return\"start\";case\"top\":return\"end\";case\"zero\":return\"origin\";case\"origin\":case\"start\":case\"end\":return r;default:return!1}}function l(t){var e,i=t.el._model||{},n=t.el._scale||{},a=t.fill,r=null;if(isFinite(a))return null;if(\"start\"===a?r=void 0===i.scaleBottom?n.bottom:i.scaleBottom:\"end\"===a?r=void 0===i.scaleTop?n.top:i.scaleTop:void 0!==i.scaleZero?r=i.scaleZero:n.getBasePosition?r=n.getBasePosition():n.getBasePixel&&(r=n.getBasePixel()),null!=r){if(void 0!==r.x&&void 0!==r.y)return r;if(\"number\"==typeof r&&isFinite(r))return{x:(e=n.isHorizontal())?r:null,y:e?null:r}}return null}function u(t,e,i){var n,a=t[e].fill,r=[e];if(!i)return a;for(;!1!==a&&-1===r.indexOf(a);){if(!isFinite(a))return a;if(!(n=t[a]))return!1;if(n.visible)return a;r.push(a),a=n.fill}return!1}function d(t){return t&&!t.skip}function h(t,e,i,n,a){var o;if(n&&a){for(t.moveTo(e[0].x,e[0].y),o=1;o<n;++o)r.canvas.lineTo(t,e[o-1],e[o]);for(t.lineTo(i[a-1].x,i[a-1].y),o=a-1;o>0;--o)r.canvas.lineTo(t,i[o],i[o-1],!0)}}e.exports={id:\"filler\",afterDatasetsUpdate:function(t,e){var i,n,r,d,h,c,f,g=(t.data.datasets||[]).length,m=e.propagate,p=[];for(n=0;n<g;++n)d=null,(r=(i=t.getDatasetMeta(n)).dataset)&&r._model&&r instanceof a.Line&&(d={visible:t.isDatasetVisible(n),fill:s(r,n,g),chart:t,el:r}),i.$filler=d,p.push(d);for(n=0;n<g;++n)(d=p[n])&&(d.fill=u(p,n,m),d.boundary=l(d),d.mapper=(void 0,f=void 0,c=(h=d).fill,f=\"dataset\",!1===c?null:(isFinite(c)||(f=\"boundary\"),o[f](h))))},beforeDatasetDraw:function(t,e){var i=e.meta.$filler;if(i){var a=t.ctx,o=i.el,s=o._view,l=o._children||[],u=i.mapper,c=s.backgroundColor||n.global.defaultColor;u&&c&&l.length&&(r.canvas.clipArea(a,t.chartArea),function(t,e,i,n,a,r){var o,s,l,u,c,f,g,m=e.length,p=n.spanGaps,v=[],y=[],b=0,x=0;for(t.beginPath(),o=0,s=m+!!r;o<s;++o)c=i(u=e[l=o%m]._view,l,n),f=d(u),g=d(c),f&&g?(b=v.push(u),x=y.push(c)):b&&x&&(p?(f&&v.push(u),g&&y.push(c)):(h(t,v,y,b,x),b=x=0,v=[],y=[]));h(t,v,y,b,x),t.closePath(),t.fillStyle=a,t.fill()}(a,l,u,s,c,o._loop),r.canvas.unclipArea(a))}}}},{25:25,40:40,45:45}],51:[function(t,e,i){\"use strict\";var n=t(25),a=t(26),r=t(45),o=t(30),s=r.noop;function l(t,e){return t.usePointStyle?e*Math.SQRT2:t.boxWidth}n._set(\"global\",{legend:{display:!0,position:\"top\",fullWidth:!0,reverse:!1,weight:1e3,onClick:function(t,e){var i=e.datasetIndex,n=this.chart,a=n.getDatasetMeta(i);a.hidden=null===a.hidden?!n.data.datasets[i].hidden:null,n.update()},onHover:null,labels:{boxWidth:40,padding:10,generateLabels:function(t){var e=t.data;return r.isArray(e.datasets)?e.datasets.map(function(e,i){return{text:e.label,fillStyle:r.isArray(e.backgroundColor)?e.backgroundColor[0]:e.backgroundColor,hidden:!t.isDatasetVisible(i),lineCap:e.borderCapStyle,lineDash:e.borderDash,lineDashOffset:e.borderDashOffset,lineJoin:e.borderJoinStyle,lineWidth:e.borderWidth,strokeStyle:e.borderColor,pointStyle:e.pointStyle,datasetIndex:i}},this):[]}}},legendCallback:function(t){var e=[];e.push('<ul class=\"'+t.id+'-legend\">');for(var i=0;i<t.data.datasets.length;i++)e.push('<li><span style=\"background-color:'+t.data.datasets[i].backgroundColor+'\"></span>'),t.data.datasets[i].label&&e.push(t.data.datasets[i].label),e.push(\"</li>\");return e.push(\"</ul>\"),e.join(\"\")}});var u=a.extend({initialize:function(t){r.extend(this,t),this.legendHitBoxes=[],this.doughnutMode=!1},beforeUpdate:s,update:function(t,e,i){var n=this;return n.beforeUpdate(),n.maxWidth=t,n.maxHeight=e,n.margins=i,n.beforeSetDimensions(),n.setDimensions(),n.afterSetDimensions(),n.beforeBuildLabels(),n.buildLabels(),n.afterBuildLabels(),n.beforeFit(),n.fit(),n.afterFit(),n.afterUpdate(),n.minSize},afterUpdate:s,beforeSetDimensions:s,setDimensions:function(){var t=this;t.isHorizontal()?(t.width=t.maxWidth,t.left=0,t.right=t.width):(t.height=t.maxHeight,t.top=0,t.bottom=t.height),t.paddingLeft=0,t.paddingTop=0,t.paddingRight=0,t.paddingBottom=0,t.minSize={width:0,height:0}},afterSetDimensions:s,beforeBuildLabels:s,buildLabels:function(){var t=this,e=t.options.labels||{},i=r.callback(e.generateLabels,[t.chart],t)||[];e.filter&&(i=i.filter(function(i){return e.filter(i,t.chart.data)})),t.options.reverse&&i.reverse(),t.legendItems=i},afterBuildLabels:s,beforeFit:s,fit:function(){var t=this,e=t.options,i=e.labels,a=e.display,o=t.ctx,s=n.global,u=r.valueOrDefault,d=u(i.fontSize,s.defaultFontSize),h=u(i.fontStyle,s.defaultFontStyle),c=u(i.fontFamily,s.defaultFontFamily),f=r.fontString(d,h,c),g=t.legendHitBoxes=[],m=t.minSize,p=t.isHorizontal();if(p?(m.width=t.maxWidth,m.height=a?10:0):(m.width=a?10:0,m.height=t.maxHeight),a)if(o.font=f,p){var v=t.lineWidths=[0],y=t.legendItems.length?d+i.padding:0;o.textAlign=\"left\",o.textBaseline=\"top\",r.each(t.legendItems,function(e,n){var a=l(i,d)+d/2+o.measureText(e.text).width;v[v.length-1]+a+i.padding>=t.width&&(y+=d+i.padding,v[v.length]=t.left),g[n]={left:0,top:0,width:a,height:d},v[v.length-1]+=a+i.padding}),m.height+=y}else{var b=i.padding,x=t.columnWidths=[],_=i.padding,k=0,w=0,M=d+b;r.each(t.legendItems,function(t,e){var n=l(i,d)+d/2+o.measureText(t.text).width;w+M>m.height&&(_+=k+i.padding,x.push(k),k=0,w=0),k=Math.max(k,n),w+=M,g[e]={left:0,top:0,width:n,height:d}}),_+=k,x.push(k),m.width+=_}t.width=m.width,t.height=m.height},afterFit:s,isHorizontal:function(){return\"top\"===this.options.position||\"bottom\"===this.options.position},draw:function(){var t=this,e=t.options,i=e.labels,a=n.global,o=a.elements.line,s=t.width,u=t.lineWidths;if(e.display){var d,h=t.ctx,c=r.valueOrDefault,f=c(i.fontColor,a.defaultFontColor),g=c(i.fontSize,a.defaultFontSize),m=c(i.fontStyle,a.defaultFontStyle),p=c(i.fontFamily,a.defaultFontFamily),v=r.fontString(g,m,p);h.textAlign=\"left\",h.textBaseline=\"middle\",h.lineWidth=.5,h.strokeStyle=f,h.fillStyle=f,h.font=v;var y=l(i,g),b=t.legendHitBoxes,x=t.isHorizontal();d=x?{x:t.left+(s-u[0])/2,y:t.top+i.padding,line:0}:{x:t.left+i.padding,y:t.top+i.padding,line:0};var _=g+i.padding;r.each(t.legendItems,function(n,l){var f,m,p,v,k,w=h.measureText(n.text).width,M=y+g/2+w,S=d.x,D=d.y;x?S+M>=s&&(D=d.y+=_,d.line++,S=d.x=t.left+(s-u[d.line])/2):D+_>t.bottom&&(S=d.x=S+t.columnWidths[d.line]+i.padding,D=d.y=t.top+i.padding,d.line++),function(t,i,n){if(!(isNaN(y)||y<=0)){h.save(),h.fillStyle=c(n.fillStyle,a.defaultColor),h.lineCap=c(n.lineCap,o.borderCapStyle),h.lineDashOffset=c(n.lineDashOffset,o.borderDashOffset),h.lineJoin=c(n.lineJoin,o.borderJoinStyle),h.lineWidth=c(n.lineWidth,o.borderWidth),h.strokeStyle=c(n.strokeStyle,a.defaultColor);var s=0===c(n.lineWidth,o.borderWidth);if(h.setLineDash&&h.setLineDash(c(n.lineDash,o.borderDash)),e.labels&&e.labels.usePointStyle){var l=g*Math.SQRT2/2,u=l/Math.SQRT2,d=t+u,f=i+u;r.canvas.drawPoint(h,n.pointStyle,l,d,f)}else s||h.strokeRect(t,i,y,g),h.fillRect(t,i,y,g);h.restore()}}(S,D,n),b[l].left=S,b[l].top=D,f=n,m=w,v=y+(p=g/2)+S,k=D+p,h.fillText(f.text,v,k),f.hidden&&(h.beginPath(),h.lineWidth=2,h.moveTo(v,k),h.lineTo(v+m,k),h.stroke()),x?d.x+=M+i.padding:d.y+=_})}},handleEvent:function(t){var e=this,i=e.options,n=\"mouseup\"===t.type?\"click\":t.type,a=!1;if(\"mousemove\"===n){if(!i.onHover)return}else{if(\"click\"!==n)return;if(!i.onClick)return}var r=t.x,o=t.y;if(r>=e.left&&r<=e.right&&o>=e.top&&o<=e.bottom)for(var s=e.legendHitBoxes,l=0;l<s.length;++l){var u=s[l];if(r>=u.left&&r<=u.left+u.width&&o>=u.top&&o<=u.top+u.height){if(\"click\"===n){i.onClick.call(e,t.native,e.legendItems[l]),a=!0;break}if(\"mousemove\"===n){i.onHover.call(e,t.native,e.legendItems[l]),a=!0;break}}}return a}});function d(t,e){var i=new u({ctx:t.ctx,options:e,chart:t});o.configure(t,i,e),o.addBox(t,i),t.legend=i}e.exports={id:\"legend\",_element:u,beforeInit:function(t){var e=t.options.legend;e&&d(t,e)},beforeUpdate:function(t){var e=t.options.legend,i=t.legend;e?(r.mergeIf(e,n.global.legend),i?(o.configure(t,i,e),i.options=e):d(t,e)):i&&(o.removeBox(t,i),delete t.legend)},afterEvent:function(t,e){var i=t.legend;i&&i.handleEvent(e)}}},{25:25,26:26,30:30,45:45}],52:[function(t,e,i){\"use strict\";var n=t(25),a=t(26),r=t(45),o=t(30),s=r.noop;n._set(\"global\",{title:{display:!1,fontStyle:\"bold\",fullWidth:!0,lineHeight:1.2,padding:10,position:\"top\",text:\"\",weight:2e3}});var l=a.extend({initialize:function(t){r.extend(this,t),this.legendHitBoxes=[]},beforeUpdate:s,update:function(t,e,i){var n=this;return n.beforeUpdate(),n.maxWidth=t,n.maxHeight=e,n.margins=i,n.beforeSetDimensions(),n.setDimensions(),n.afterSetDimensions(),n.beforeBuildLabels(),n.buildLabels(),n.afterBuildLabels(),n.beforeFit(),n.fit(),n.afterFit(),n.afterUpdate(),n.minSize},afterUpdate:s,beforeSetDimensions:s,setDimensions:function(){var t=this;t.isHorizontal()?(t.width=t.maxWidth,t.left=0,t.right=t.width):(t.height=t.maxHeight,t.top=0,t.bottom=t.height),t.paddingLeft=0,t.paddingTop=0,t.paddingRight=0,t.paddingBottom=0,t.minSize={width:0,height:0}},afterSetDimensions:s,beforeBuildLabels:s,buildLabels:s,afterBuildLabels:s,beforeFit:s,fit:function(){var t=r.valueOrDefault,e=this.options,i=e.display,a=t(e.fontSize,n.global.defaultFontSize),o=this.minSize,s=r.isArray(e.text)?e.text.length:1,l=r.options.toLineHeight(e.lineHeight,a),u=i?s*l+2*e.padding:0;this.isHorizontal()?(o.width=this.maxWidth,o.height=u):(o.width=u,o.height=this.maxHeight),this.width=o.width,this.height=o.height},afterFit:s,isHorizontal:function(){var t=this.options.position;return\"top\"===t||\"bottom\"===t},draw:function(){var t=this.ctx,e=r.valueOrDefault,i=this.options,a=n.global;if(i.display){var o,s,l,u=e(i.fontSize,a.defaultFontSize),d=e(i.fontStyle,a.defaultFontStyle),h=e(i.fontFamily,a.defaultFontFamily),c=r.fontString(u,d,h),f=r.options.toLineHeight(i.lineHeight,u),g=f/2+i.padding,m=0,p=this.top,v=this.left,y=this.bottom,b=this.right;t.fillStyle=e(i.fontColor,a.defaultFontColor),t.font=c,this.isHorizontal()?(s=v+(b-v)/2,l=p+g,o=b-v):(s=\"left\"===i.position?v+g:b-g,l=p+(y-p)/2,o=y-p,m=Math.PI*(\"left\"===i.position?-.5:.5)),t.save(),t.translate(s,l),t.rotate(m),t.textAlign=\"center\",t.textBaseline=\"middle\";var x=i.text;if(r.isArray(x))for(var _=0,k=0;k<x.length;++k)t.fillText(x[k],0,_,o),_+=f;else t.fillText(x,0,0,o);t.restore()}}});function u(t,e){var i=new l({ctx:t.ctx,options:e,chart:t});o.configure(t,i,e),o.addBox(t,i),t.titleBlock=i}e.exports={id:\"title\",_element:l,beforeInit:function(t){var e=t.options.title;e&&u(t,e)},beforeUpdate:function(t){var e=t.options.title,i=t.titleBlock;e?(r.mergeIf(e,n.global.title),i?(o.configure(t,i,e),i.options=e):u(t,e)):i&&(o.removeBox(t,i),delete t.titleBlock)}}},{25:25,26:26,30:30,45:45}],53:[function(t,e,i){\"use strict\";e.exports=function(t){var e=t.Scale.extend({getLabels:function(){var t=this.chart.data;return this.options.labels||(this.isHorizontal()?t.xLabels:t.yLabels)||t.labels},determineDataLimits:function(){var t,e=this,i=e.getLabels();e.minIndex=0,e.maxIndex=i.length-1,void 0!==e.options.ticks.min&&(t=i.indexOf(e.options.ticks.min),e.minIndex=-1!==t?t:e.minIndex),void 0!==e.options.ticks.max&&(t=i.indexOf(e.options.ticks.max),e.maxIndex=-1!==t?t:e.maxIndex),e.min=i[e.minIndex],e.max=i[e.maxIndex]},buildTicks:function(){var t=this.getLabels();this.ticks=0===this.minIndex&&this.maxIndex===t.length-1?t:t.slice(this.minIndex,this.maxIndex+1)},getLabelForIndex:function(t,e){var i=this.chart.data,n=this.isHorizontal();return i.yLabels&&!n?this.getRightValue(i.datasets[e].data[t]):this.ticks[t-this.minIndex]},getPixelForValue:function(t,e){var i,n=this,a=n.options.offset,r=Math.max(n.maxIndex+1-n.minIndex-(a?0:1),1);if(null!=t&&(i=n.isHorizontal()?t.x:t.y),void 0!==i||void 0!==t&&isNaN(e)){t=i||t;var o=n.getLabels().indexOf(t);e=-1!==o?o:e}if(n.isHorizontal()){var s=n.width/r,l=s*(e-n.minIndex);return a&&(l+=s/2),n.left+Math.round(l)}var u=n.height/r,d=u*(e-n.minIndex);return a&&(d+=u/2),n.top+Math.round(d)},getPixelForTick:function(t){return this.getPixelForValue(this.ticks[t],t+this.minIndex,null)},getValueForPixel:function(t){var e=this.options.offset,i=Math.max(this._ticks.length-(e?0:1),1),n=this.isHorizontal(),a=(n?this.width:this.height)/i;return t-=n?this.left:this.top,e&&(t-=a/2),(t<=0?0:Math.round(t/a))+this.minIndex},getBasePixel:function(){return this.bottom}});t.scaleService.registerScaleType(\"category\",e,{position:\"bottom\"})}},{}],54:[function(t,e,i){\"use strict\";var n=t(25),a=t(45),r=t(34);e.exports=function(t){var e={position:\"left\",ticks:{callback:r.formatters.linear}},i=t.LinearScaleBase.extend({determineDataLimits:function(){var t=this,e=t.options,i=t.chart,n=i.data.datasets,r=t.isHorizontal();function o(e){return r?e.xAxisID===t.id:e.yAxisID===t.id}t.min=null,t.max=null;var s=e.stacked;if(void 0===s&&a.each(n,function(t,e){if(!s){var n=i.getDatasetMeta(e);i.isDatasetVisible(e)&&o(n)&&void 0!==n.stack&&(s=!0)}}),e.stacked||s){var l={};a.each(n,function(n,r){var s=i.getDatasetMeta(r),u=[s.type,void 0===e.stacked&&void 0===s.stack?r:\"\",s.stack].join(\".\");void 0===l[u]&&(l[u]={positiveValues:[],negativeValues:[]});var d=l[u].positiveValues,h=l[u].negativeValues;i.isDatasetVisible(r)&&o(s)&&a.each(n.data,function(i,n){var a=+t.getRightValue(i);isNaN(a)||s.data[n].hidden||(d[n]=d[n]||0,h[n]=h[n]||0,e.relativePoints?d[n]=100:a<0?h[n]+=a:d[n]+=a)})}),a.each(l,function(e){var i=e.positiveValues.concat(e.negativeValues),n=a.min(i),r=a.max(i);t.min=null===t.min?n:Math.min(t.min,n),t.max=null===t.max?r:Math.max(t.max,r)})}else a.each(n,function(e,n){var r=i.getDatasetMeta(n);i.isDatasetVisible(n)&&o(r)&&a.each(e.data,function(e,i){var n=+t.getRightValue(e);isNaN(n)||r.data[i].hidden||(null===t.min?t.min=n:n<t.min&&(t.min=n),null===t.max?t.max=n:n>t.max&&(t.max=n))})});t.min=isFinite(t.min)&&!isNaN(t.min)?t.min:0,t.max=isFinite(t.max)&&!isNaN(t.max)?t.max:1,this.handleTickRangeOptions()},getTickLimit:function(){var t,e=this.options.ticks;if(this.isHorizontal())t=Math.min(e.maxTicksLimit?e.maxTicksLimit:11,Math.ceil(this.width/50));else{var i=a.valueOrDefault(e.fontSize,n.global.defaultFontSize);t=Math.min(e.maxTicksLimit?e.maxTicksLimit:11,Math.ceil(this.height/(2*i)))}return t},handleDirectionalChanges:function(){this.isHorizontal()||this.ticks.reverse()},getLabelForIndex:function(t,e){return+this.getRightValue(this.chart.data.datasets[e].data[t])},getPixelForValue:function(t){var e=this.start,i=+this.getRightValue(t),n=this.end-e;return this.isHorizontal()?this.left+this.width/n*(i-e):this.bottom-this.height/n*(i-e)},getValueForPixel:function(t){var e=this.isHorizontal(),i=e?this.width:this.height,n=(e?t-this.left:this.bottom-t)/i;return this.start+(this.end-this.start)*n},getPixelForTick:function(t){return this.getPixelForValue(this.ticksAsNumbers[t])}});t.scaleService.registerScaleType(\"linear\",i,e)}},{25:25,34:34,45:45}],55:[function(t,e,i){\"use strict\";var n=t(45);e.exports=function(t){var e=n.noop;t.LinearScaleBase=t.Scale.extend({getRightValue:function(e){return\"string\"==typeof e?+e:t.Scale.prototype.getRightValue.call(this,e)},handleTickRangeOptions:function(){var t=this,e=t.options.ticks;if(e.beginAtZero){var i=n.sign(t.min),a=n.sign(t.max);i<0&&a<0?t.max=0:i>0&&a>0&&(t.min=0)}var r=void 0!==e.min||void 0!==e.suggestedMin,o=void 0!==e.max||void 0!==e.suggestedMax;void 0!==e.min?t.min=e.min:void 0!==e.suggestedMin&&(null===t.min?t.min=e.suggestedMin:t.min=Math.min(t.min,e.suggestedMin)),void 0!==e.max?t.max=e.max:void 0!==e.suggestedMax&&(null===t.max?t.max=e.suggestedMax:t.max=Math.max(t.max,e.suggestedMax)),r!==o&&t.min>=t.max&&(r?t.max=t.min+1:t.min=t.max-1),t.min===t.max&&(t.max++,e.beginAtZero||t.min--)},getTickLimit:e,handleDirectionalChanges:e,buildTicks:function(){var t=this,e=t.options.ticks,i=t.getTickLimit(),a={maxTicks:i=Math.max(2,i),min:e.min,max:e.max,stepSize:n.valueOrDefault(e.fixedStepSize,e.stepSize)},r=t.ticks=function(t,e){var i,a=[];if(t.stepSize&&t.stepSize>0)i=t.stepSize;else{var r=n.niceNum(e.max-e.min,!1);i=n.niceNum(r/(t.maxTicks-1),!0)}var o=Math.floor(e.min/i)*i,s=Math.ceil(e.max/i)*i;t.min&&t.max&&t.stepSize&&n.almostWhole((t.max-t.min)/t.stepSize,i/1e3)&&(o=t.min,s=t.max);var l=(s-o)/i;l=n.almostEquals(l,Math.round(l),i/1e3)?Math.round(l):Math.ceil(l);var u=1;i<1&&(u=Math.pow(10,i.toString().length-2),o=Math.round(o*u)/u,s=Math.round(s*u)/u),a.push(void 0!==t.min?t.min:o);for(var d=1;d<l;++d)a.push(Math.round((o+d*i)*u)/u);return a.push(void 0!==t.max?t.max:s),a}(a,t);t.handleDirectionalChanges(),t.max=n.max(r),t.min=n.min(r),e.reverse?(r.reverse(),t.start=t.max,t.end=t.min):(t.start=t.min,t.end=t.max)},convertTicksToLabels:function(){this.ticksAsNumbers=this.ticks.slice(),this.zeroLineIndex=this.ticks.indexOf(0),t.Scale.prototype.convertTicksToLabels.call(this)}})}},{45:45}],56:[function(t,e,i){\"use strict\";var n=t(45),a=t(34);e.exports=function(t){var e={position:\"left\",ticks:{callback:a.formatters.logarithmic}},i=t.Scale.extend({determineDataLimits:function(){var t=this,e=t.options,i=t.chart,a=i.data.datasets,r=t.isHorizontal();function o(e){return r?e.xAxisID===t.id:e.yAxisID===t.id}t.min=null,t.max=null,t.minNotZero=null;var s=e.stacked;if(void 0===s&&n.each(a,function(t,e){if(!s){var n=i.getDatasetMeta(e);i.isDatasetVisible(e)&&o(n)&&void 0!==n.stack&&(s=!0)}}),e.stacked||s){var l={};n.each(a,function(a,r){var s=i.getDatasetMeta(r),u=[s.type,void 0===e.stacked&&void 0===s.stack?r:\"\",s.stack].join(\".\");i.isDatasetVisible(r)&&o(s)&&(void 0===l[u]&&(l[u]=[]),n.each(a.data,function(e,i){var n=l[u],a=+t.getRightValue(e);isNaN(a)||s.data[i].hidden||a<0||(n[i]=n[i]||0,n[i]+=a)}))}),n.each(l,function(e){if(e.length>0){var i=n.min(e),a=n.max(e);t.min=null===t.min?i:Math.min(t.min,i),t.max=null===t.max?a:Math.max(t.max,a)}})}else n.each(a,function(e,a){var r=i.getDatasetMeta(a);i.isDatasetVisible(a)&&o(r)&&n.each(e.data,function(e,i){var n=+t.getRightValue(e);isNaN(n)||r.data[i].hidden||n<0||(null===t.min?t.min=n:n<t.min&&(t.min=n),null===t.max?t.max=n:n>t.max&&(t.max=n),0!==n&&(null===t.minNotZero||n<t.minNotZero)&&(t.minNotZero=n))})});this.handleTickRangeOptions()},handleTickRangeOptions:function(){var t=this,e=t.options.ticks,i=n.valueOrDefault;t.min=i(e.min,t.min),t.max=i(e.max,t.max),t.min===t.max&&(0!==t.min&&null!==t.min?(t.min=Math.pow(10,Math.floor(n.log10(t.min))-1),t.max=Math.pow(10,Math.floor(n.log10(t.max))+1)):(t.min=1,t.max=10)),null===t.min&&(t.min=Math.pow(10,Math.floor(n.log10(t.max))-1)),null===t.max&&(t.max=0!==t.min?Math.pow(10,Math.floor(n.log10(t.min))+1):10),null===t.minNotZero&&(t.min>0?t.minNotZero=t.min:t.max<1?t.minNotZero=Math.pow(10,Math.floor(n.log10(t.max))):t.minNotZero=1)},buildTicks:function(){var t=this,e=t.options.ticks,i=!t.isHorizontal(),a={min:e.min,max:e.max},r=t.ticks=function(t,e){var i,a,r=[],o=n.valueOrDefault,s=o(t.min,Math.pow(10,Math.floor(n.log10(e.min)))),l=Math.floor(n.log10(e.max)),u=Math.ceil(e.max/Math.pow(10,l));0===s?(i=Math.floor(n.log10(e.minNotZero)),a=Math.floor(e.minNotZero/Math.pow(10,i)),r.push(s),s=a*Math.pow(10,i)):(i=Math.floor(n.log10(s)),a=Math.floor(s/Math.pow(10,i)));for(var d=i<0?Math.pow(10,Math.abs(i)):1;r.push(s),10==++a&&(a=1,d=++i>=0?1:d),s=Math.round(a*Math.pow(10,i)*d)/d,i<l||i===l&&a<u;);var h=o(t.max,s);return r.push(h),r}(a,t);t.max=n.max(r),t.min=n.min(r),e.reverse?(i=!i,t.start=t.max,t.end=t.min):(t.start=t.min,t.end=t.max),i&&r.reverse()},convertTicksToLabels:function(){this.tickValues=this.ticks.slice(),t.Scale.prototype.convertTicksToLabels.call(this)},getLabelForIndex:function(t,e){return+this.getRightValue(this.chart.data.datasets[e].data[t])},getPixelForTick:function(t){return this.getPixelForValue(this.tickValues[t])},_getFirstTickValue:function(t){var e=Math.floor(n.log10(t));return Math.floor(t/Math.pow(10,e))*Math.pow(10,e)},getPixelForValue:function(e){var i,a,r,o,s,l=this,u=l.options.ticks.reverse,d=n.log10,h=l._getFirstTickValue(l.minNotZero),c=0;return e=+l.getRightValue(e),u?(r=l.end,o=l.start,s=-1):(r=l.start,o=l.end,s=1),l.isHorizontal()?(i=l.width,a=u?l.right:l.left):(i=l.height,s*=-1,a=u?l.top:l.bottom),e!==r&&(0===r&&(i-=c=n.getValueOrDefault(l.options.ticks.fontSize,t.defaults.global.defaultFontSize),r=h),0!==e&&(c+=i/(d(o)-d(r))*(d(e)-d(r))),a+=s*c),a},getValueForPixel:function(e){var i,a,r,o,s=this,l=s.options.ticks.reverse,u=n.log10,d=s._getFirstTickValue(s.minNotZero);if(l?(a=s.end,r=s.start):(a=s.start,r=s.end),s.isHorizontal()?(i=s.width,o=l?s.right-e:e-s.left):(i=s.height,o=l?e-s.top:s.bottom-e),o!==a){if(0===a){var h=n.getValueOrDefault(s.options.ticks.fontSize,t.defaults.global.defaultFontSize);o-=h,i-=h,a=d}o*=u(r)-u(a),o/=i,o=Math.pow(10,u(a)+o)}return o}});t.scaleService.registerScaleType(\"logarithmic\",i,e)}},{34:34,45:45}],57:[function(t,e,i){\"use strict\";var n=t(25),a=t(45),r=t(34);e.exports=function(t){var e=n.global,i={display:!0,animate:!0,position:\"chartArea\",angleLines:{display:!0,color:\"rgba(0, 0, 0, 0.1)\",lineWidth:1},gridLines:{circular:!1},ticks:{showLabelBackdrop:!0,backdropColor:\"rgba(255,255,255,0.75)\",backdropPaddingY:2,backdropPaddingX:2,callback:r.formatters.linear},pointLabels:{display:!0,fontSize:10,callback:function(t){return t}}};function o(t){var e=t.options;return e.angleLines.display||e.pointLabels.display?t.chart.data.labels.length:0}function s(t){var i=t.options.pointLabels,n=a.valueOrDefault(i.fontSize,e.defaultFontSize),r=a.valueOrDefault(i.fontStyle,e.defaultFontStyle),o=a.valueOrDefault(i.fontFamily,e.defaultFontFamily);return{size:n,style:r,family:o,font:a.fontString(n,r,o)}}function l(t,e,i,n,a){return t===n||t===a?{start:e-i/2,end:e+i/2}:t<n||t>a?{start:e-i-5,end:e}:{start:e,end:e+i+5}}function u(t,e,i,n){if(a.isArray(e))for(var r=i.y,o=1.5*n,s=0;s<e.length;++s)t.fillText(e[s],i.x,r),r+=o;else t.fillText(e,i.x,i.y)}function d(t){return a.isNumber(t)?t:0}var h=t.LinearScaleBase.extend({setDimensions:function(){var t=this,i=t.options,n=i.ticks;t.width=t.maxWidth,t.height=t.maxHeight,t.xCenter=Math.round(t.width/2),t.yCenter=Math.round(t.height/2);var r=a.min([t.height,t.width]),o=a.valueOrDefault(n.fontSize,e.defaultFontSize);t.drawingArea=i.display?r/2-(o/2+n.backdropPaddingY):r/2},determineDataLimits:function(){var t=this,e=t.chart,i=Number.POSITIVE_INFINITY,n=Number.NEGATIVE_INFINITY;a.each(e.data.datasets,function(r,o){if(e.isDatasetVisible(o)){var s=e.getDatasetMeta(o);a.each(r.data,function(e,a){var r=+t.getRightValue(e);isNaN(r)||s.data[a].hidden||(i=Math.min(r,i),n=Math.max(r,n))})}}),t.min=i===Number.POSITIVE_INFINITY?0:i,t.max=n===Number.NEGATIVE_INFINITY?0:n,t.handleTickRangeOptions()},getTickLimit:function(){var t=this.options.ticks,i=a.valueOrDefault(t.fontSize,e.defaultFontSize);return Math.min(t.maxTicksLimit?t.maxTicksLimit:11,Math.ceil(this.drawingArea/(1.5*i)))},convertTicksToLabels:function(){t.LinearScaleBase.prototype.convertTicksToLabels.call(this),this.pointLabels=this.chart.data.labels.map(this.options.pointLabels.callback,this)},getLabelForIndex:function(t,e){return+this.getRightValue(this.chart.data.datasets[e].data[t])},fit:function(){var t,e;this.options.pointLabels.display?function(t){var e,i,n,r=s(t),u=Math.min(t.height/2,t.width/2),d={r:t.width,l:0,t:t.height,b:0},h={};t.ctx.font=r.font,t._pointLabelSizes=[];var c,f,g,m=o(t);for(e=0;e<m;e++){n=t.getPointPosition(e,u),c=t.ctx,f=r.size,g=t.pointLabels[e]||\"\",i=a.isArray(g)?{w:a.longestText(c,c.font,g),h:g.length*f+1.5*(g.length-1)*f}:{w:c.measureText(g).width,h:f},t._pointLabelSizes[e]=i;var p=t.getIndexAngle(e),v=a.toDegrees(p)%360,y=l(v,n.x,i.w,0,180),b=l(v,n.y,i.h,90,270);y.start<d.l&&(d.l=y.start,h.l=p),y.end>d.r&&(d.r=y.end,h.r=p),b.start<d.t&&(d.t=b.start,h.t=p),b.end>d.b&&(d.b=b.end,h.b=p)}t.setReductions(u,d,h)}(this):(t=this,e=Math.min(t.height/2,t.width/2),t.drawingArea=Math.round(e),t.setCenterPoint(0,0,0,0))},setReductions:function(t,e,i){var n=e.l/Math.sin(i.l),a=Math.max(e.r-this.width,0)/Math.sin(i.r),r=-e.t/Math.cos(i.t),o=-Math.max(e.b-this.height,0)/Math.cos(i.b);n=d(n),a=d(a),r=d(r),o=d(o),this.drawingArea=Math.min(Math.round(t-(n+a)/2),Math.round(t-(r+o)/2)),this.setCenterPoint(n,a,r,o)},setCenterPoint:function(t,e,i,n){var a=this,r=a.width-e-a.drawingArea,o=t+a.drawingArea,s=i+a.drawingArea,l=a.height-n-a.drawingArea;a.xCenter=Math.round((o+r)/2+a.left),a.yCenter=Math.round((s+l)/2+a.top)},getIndexAngle:function(t){return t*(2*Math.PI/o(this))+(this.chart.options&&this.chart.options.startAngle?this.chart.options.startAngle:0)*Math.PI*2/360},getDistanceFromCenterForValue:function(t){if(null===t)return 0;var e=this.drawingArea/(this.max-this.min);return this.options.ticks.reverse?(this.max-t)*e:(t-this.min)*e},getPointPosition:function(t,e){var i=this.getIndexAngle(t)-Math.PI/2;return{x:Math.round(Math.cos(i)*e)+this.xCenter,y:Math.round(Math.sin(i)*e)+this.yCenter}},getPointPositionForValue:function(t,e){return this.getPointPosition(t,this.getDistanceFromCenterForValue(e))},getBasePosition:function(){var t=this.min,e=this.max;return this.getPointPositionForValue(0,this.beginAtZero?0:t<0&&e<0?e:t>0&&e>0?t:0)},draw:function(){var t=this,i=t.options,n=i.gridLines,r=i.ticks,l=a.valueOrDefault;if(i.display){var d=t.ctx,h=this.getIndexAngle(0),c=l(r.fontSize,e.defaultFontSize),f=l(r.fontStyle,e.defaultFontStyle),g=l(r.fontFamily,e.defaultFontFamily),m=a.fontString(c,f,g);a.each(t.ticks,function(i,s){if(s>0||r.reverse){var u=t.getDistanceFromCenterForValue(t.ticksAsNumbers[s]);if(n.display&&0!==s&&function(t,e,i,n){var r=t.ctx;if(r.strokeStyle=a.valueAtIndexOrDefault(e.color,n-1),r.lineWidth=a.valueAtIndexOrDefault(e.lineWidth,n-1),t.options.gridLines.circular)r.beginPath(),r.arc(t.xCenter,t.yCenter,i,0,2*Math.PI),r.closePath(),r.stroke();else{var s=o(t);if(0===s)return;r.beginPath();var l=t.getPointPosition(0,i);r.moveTo(l.x,l.y);for(var u=1;u<s;u++)l=t.getPointPosition(u,i),r.lineTo(l.x,l.y);r.closePath(),r.stroke()}}(t,n,u,s),r.display){var f=l(r.fontColor,e.defaultFontColor);if(d.font=m,d.save(),d.translate(t.xCenter,t.yCenter),d.rotate(h),r.showLabelBackdrop){var g=d.measureText(i).width;d.fillStyle=r.backdropColor,d.fillRect(-g/2-r.backdropPaddingX,-u-c/2-r.backdropPaddingY,g+2*r.backdropPaddingX,c+2*r.backdropPaddingY)}d.textAlign=\"center\",d.textBaseline=\"middle\",d.fillStyle=f,d.fillText(i,0,-u),d.restore()}}}),(i.angleLines.display||i.pointLabels.display)&&function(t){var i=t.ctx,n=t.options,r=n.angleLines,l=n.pointLabels;i.lineWidth=r.lineWidth,i.strokeStyle=r.color;var d,h,c,f,g=t.getDistanceFromCenterForValue(n.ticks.reverse?t.min:t.max),m=s(t);i.textBaseline=\"top\";for(var p=o(t)-1;p>=0;p--){if(r.display){var v=t.getPointPosition(p,g);i.beginPath(),i.moveTo(t.xCenter,t.yCenter),i.lineTo(v.x,v.y),i.stroke(),i.closePath()}if(l.display){var y=t.getPointPosition(p,g+5),b=a.valueAtIndexOrDefault(l.fontColor,p,e.defaultFontColor);i.font=m.font,i.fillStyle=b;var x=t.getIndexAngle(p),_=a.toDegrees(x);i.textAlign=0===(f=_)||180===f?\"center\":f<180?\"left\":\"right\",d=_,h=t._pointLabelSizes[p],c=y,90===d||270===d?c.y-=h.h/2:(d>270||d<90)&&(c.y-=h.h),u(i,t.pointLabels[p]||\"\",y,m.size)}}}(t)}}});t.scaleService.registerScaleType(\"radialLinear\",h,i)}},{25:25,34:34,45:45}],58:[function(t,e,i){\"use strict\";var n=t(6);n=\"function\"==typeof n?n:window.moment;var a=t(25),r=t(45),o=Number.MIN_SAFE_INTEGER||-9007199254740991,s=Number.MAX_SAFE_INTEGER||9007199254740991,l={millisecond:{common:!0,size:1,steps:[1,2,5,10,20,50,100,250,500]},second:{common:!0,size:1e3,steps:[1,2,5,10,30]},minute:{common:!0,size:6e4,steps:[1,2,5,10,30]},hour:{common:!0,size:36e5,steps:[1,2,3,6,12]},day:{common:!0,size:864e5,steps:[1,2,5]},week:{common:!1,size:6048e5,steps:[1,2,3,4]},month:{common:!0,size:2628e6,steps:[1,2,3]},quarter:{common:!1,size:7884e6,steps:[1,2,3,4]},year:{common:!0,size:3154e7}},u=Object.keys(l);function d(t,e){return t-e}function h(t){var e,i,n,a={},r=[];for(e=0,i=t.length;e<i;++e)a[n=t[e]]||(a[n]=!0,r.push(n));return r}function c(t,e,i,n){var a=function(t,e,i){for(var n,a,r,o=0,s=t.length-1;o>=0&&o<=s;){if(a=t[(n=o+s>>1)-1]||null,r=t[n],!a)return{lo:null,hi:r};if(r[e]<i)o=n+1;else{if(!(a[e]>i))return{lo:a,hi:r};s=n-1}}return{lo:r,hi:null}}(t,e,i),r=a.lo?a.hi?a.lo:t[t.length-2]:t[0],o=a.lo?a.hi?a.hi:t[t.length-1]:t[1],s=o[e]-r[e],l=s?(i-r[e])/s:0,u=(o[n]-r[n])*l;return r[n]+u}function f(t,e){var i=e.parser,a=e.parser||e.format;return\"function\"==typeof i?i(t):\"string\"==typeof t&&\"string\"==typeof a?n(t,a):(t instanceof n||(t=n(t)),t.isValid()?t:\"function\"==typeof a?a(t):t)}function g(t,e){if(r.isNullOrUndef(t))return null;var i=e.options.time,n=f(e.getRightValue(t),i);return n.isValid()?(i.round&&n.startOf(i.round),n.valueOf()):null}function m(t){for(var e=u.indexOf(t)+1,i=u.length;e<i;++e)if(l[u[e]].common)return u[e]}function p(t,e,i,a){var o,d=a.time,h=d.unit||function(t,e,i,n){var a,r,o,d=u.length;for(a=u.indexOf(t);a<d-1;++a)if(o=(r=l[u[a]]).steps?r.steps[r.steps.length-1]:s,r.common&&Math.ceil((i-e)/(o*r.size))<=n)return u[a];return u[d-1]}(d.minUnit,t,e,i),c=m(h),f=r.valueOrDefault(d.stepSize,d.unitStepSize),g=\"week\"===h&&d.isoWeekday,p=a.ticks.major.enabled,v=l[h],y=n(t),b=n(e),x=[];for(f||(f=function(t,e,i,n){var a,r,o,s=e-t,u=l[i],d=u.size,h=u.steps;if(!h)return Math.ceil(s/(n*d));for(a=0,r=h.length;a<r&&(o=h[a],!(Math.ceil(s/(d*o))<=n));++a);return o}(t,e,h,i)),g&&(y=y.isoWeekday(g),b=b.isoWeekday(g)),y=y.startOf(g?\"day\":h),(b=b.startOf(g?\"day\":h))<e&&b.add(1,h),o=n(y),p&&c&&!g&&!d.round&&(o.startOf(c),o.add(~~((y-o)/(v.size*f))*f,h));o<b;o.add(f,h))x.push(+o);return x.push(+o),x}e.exports=function(t){var e=t.Scale.extend({initialize:function(){if(!n)throw new Error(\"Chart.js - Moment.js could not be found! You must include it before Chart.js to use the time scale. Download at https://momentjs.com\");this.mergeTicksOptions(),t.Scale.prototype.initialize.call(this)},update:function(){var e=this.options;return e.time&&e.time.format&&console.warn(\"options.time.format is deprecated and replaced by options.time.parser.\"),t.Scale.prototype.update.apply(this,arguments)},getRightValue:function(e){return e&&void 0!==e.t&&(e=e.t),t.Scale.prototype.getRightValue.call(this,e)},determineDataLimits:function(){var t,e,i,a,l,u,c=this,f=c.chart,m=c.options.time,p=m.unit||\"day\",v=s,y=o,b=[],x=[],_=[];for(t=0,i=f.data.labels.length;t<i;++t)_.push(g(f.data.labels[t],c));for(t=0,i=(f.data.datasets||[]).length;t<i;++t)if(f.isDatasetVisible(t))if(l=f.data.datasets[t].data,r.isObject(l[0]))for(x[t]=[],e=0,a=l.length;e<a;++e)u=g(l[e],c),b.push(u),x[t][e]=u;else b.push.apply(b,_),x[t]=_.slice(0);else x[t]=[];_.length&&(_=h(_).sort(d),v=Math.min(v,_[0]),y=Math.max(y,_[_.length-1])),b.length&&(b=h(b).sort(d),v=Math.min(v,b[0]),y=Math.max(y,b[b.length-1])),v=g(m.min,c)||v,y=g(m.max,c)||y,v=v===s?+n().startOf(p):v,y=y===o?+n().endOf(p)+1:y,c.min=Math.min(v,y),c.max=Math.max(v+1,y),c._horizontal=c.isHorizontal(),c._table=[],c._timestamps={data:b,datasets:x,labels:_}},buildTicks:function(){var t,e,i,a,r,o,s,d,h,v,y,b,x=this,_=x.min,k=x.max,w=x.options,M=w.time,S=[],D=[];switch(w.ticks.source){case\"data\":S=x._timestamps.data;break;case\"labels\":S=x._timestamps.labels;break;case\"auto\":default:S=p(_,k,x.getLabelCapacity(_),w)}for(\"ticks\"===w.bounds&&S.length&&(_=S[0],k=S[S.length-1]),_=g(M.min,x)||_,k=g(M.max,x)||k,t=0,e=S.length;t<e;++t)(i=S[t])>=_&&i<=k&&D.push(i);return x.min=_,x.max=k,x._unit=M.unit||function(t,e,i,a){var r,o,s=n.duration(n(a).diff(n(i)));for(r=u.length-1;r>=u.indexOf(e);r--)if(o=u[r],l[o].common&&s.as(o)>=t.length)return o;return u[e?u.indexOf(e):0]}(D,M.minUnit,x.min,x.max),x._majorUnit=m(x._unit),x._table=function(t,e,i,n){if(\"linear\"===n||!t.length)return[{time:e,pos:0},{time:i,pos:1}];var a,r,o,s,l,u=[],d=[e];for(a=0,r=t.length;a<r;++a)(s=t[a])>e&&s<i&&d.push(s);for(d.push(i),a=0,r=d.length;a<r;++a)l=d[a+1],o=d[a-1],s=d[a],void 0!==o&&void 0!==l&&Math.round((l+o)/2)===s||u.push({time:s,pos:a/(r-1)});return u}(x._timestamps.data,_,k,w.distribution),x._offsets=(a=x._table,r=D,o=_,s=k,y=0,b=0,(d=w).offset&&r.length&&(d.time.min||(h=r.length>1?r[1]:s,v=r[0],y=(c(a,\"time\",h,\"pos\")-c(a,\"time\",v,\"pos\"))/2),d.time.max||(h=r[r.length-1],v=r.length>1?r[r.length-2]:o,b=(c(a,\"time\",h,\"pos\")-c(a,\"time\",v,\"pos\"))/2)),{left:y,right:b}),x._labelFormat=function(t,e){var i,n,a,r=t.length;for(i=0;i<r;i++){if(0!==(n=f(t[i],e)).millisecond())return\"MMM D, YYYY h:mm:ss.SSS a\";0===n.second()&&0===n.minute()&&0===n.hour()||(a=!0)}return a?\"MMM D, YYYY h:mm:ss a\":\"MMM D, YYYY\"}(x._timestamps.data,M),function(t,e){var i,a,r,o,s=[];for(i=0,a=t.length;i<a;++i)r=t[i],o=!!e&&r===+n(r).startOf(e),s.push({value:r,major:o});return s}(D,x._majorUnit)},getLabelForIndex:function(t,e){var i=this.chart.data,n=this.options.time,a=i.labels&&t<i.labels.length?i.labels[t]:\"\",o=i.datasets[e].data[t];return r.isObject(o)&&(a=this.getRightValue(o)),n.tooltipFormat?f(a,n).format(n.tooltipFormat):\"string\"==typeof a?a:f(a,n).format(this._labelFormat)},tickFormatFunction:function(t,e,i,n){var a=this.options,o=t.valueOf(),s=a.time.displayFormats,l=s[this._unit],u=this._majorUnit,d=s[u],h=t.clone().startOf(u).valueOf(),c=a.ticks.major,f=c.enabled&&u&&d&&o===h,g=t.format(n||(f?d:l)),m=f?c:a.ticks.minor,p=r.valueOrDefault(m.callback,m.userCallback);return p?p(g,e,i):g},convertTicksToLabels:function(t){var e,i,a=[];for(e=0,i=t.length;e<i;++e)a.push(this.tickFormatFunction(n(t[e].value),e,t));return a},getPixelForOffset:function(t){var e=this,i=e._horizontal?e.width:e.height,n=e._horizontal?e.left:e.top,a=c(e._table,\"time\",t,\"pos\");return n+i*(e._offsets.left+a)/(e._offsets.left+1+e._offsets.right)},getPixelForValue:function(t,e,i){var n=null;if(void 0!==e&&void 0!==i&&(n=this._timestamps.datasets[i][e]),null===n&&(n=g(t,this)),null!==n)return this.getPixelForOffset(n)},getPixelForTick:function(t){var e=this.getTicks();return t>=0&&t<e.length?this.getPixelForOffset(e[t].value):null},getValueForPixel:function(t){var e=this,i=e._horizontal?e.width:e.height,a=e._horizontal?e.left:e.top,r=(i?(t-a)/i:0)*(e._offsets.left+1+e._offsets.left)-e._offsets.right,o=c(e._table,\"pos\",r,\"time\");return n(o)},getLabelWidth:function(t){var e=this.options.ticks,i=this.ctx.measureText(t).width,n=r.toRadians(e.maxRotation),o=Math.cos(n),s=Math.sin(n);return i*o+r.valueOrDefault(e.fontSize,a.global.defaultFontSize)*s},getLabelCapacity:function(t){var e=this.options.time.displayFormats.millisecond,i=this.tickFormatFunction(n(t),0,[],e),a=this.getLabelWidth(i),r=this.isHorizontal()?this.width:this.height,o=Math.floor(r/a);return o>0?o:1}});t.scaleService.registerScaleType(\"time\",e,{position:\"bottom\",distribution:\"linear\",bounds:\"data\",time:{parser:!1,format:!1,unit:!1,round:!1,displayFormat:!1,isoWeekday:!1,minUnit:\"millisecond\",displayFormats:{millisecond:\"h:mm:ss.SSS a\",second:\"h:mm:ss a\",minute:\"h:mm a\",hour:\"hA\",day:\"MMM D\",week:\"ll\",month:\"MMM YYYY\",quarter:\"[Q]Q - YYYY\",year:\"YYYY\"}},ticks:{autoSkip:!1,source:\"auto\",major:{enabled:!1}}})}},{25:25,45:45,6:6}]},{},[7])(7)});","Mageplaza_Reports/js/lib/gridstack.js":"/**\r\n * gridstack.js 1.0.0-dev\r\n * http://troolee.github.io/gridstack.js/\r\n * (c) 2014-2017 Pavel Reznikov, Dylan Weiss\r\n * gridstack.js may be freely distributed under the MIT license.\r\n * @preserve\r\n */\r\n(function(factory) {\r\n    if (typeof define === 'function' && define.amd) {\r\n        define(['jquery', 'lodash'], factory);\r\n    } else if (typeof exports !== 'undefined') {\r\n        try { jQuery = require('jquery'); } catch (e) {}\r\n        try { _ = require('lodash'); } catch (e) {}\r\n        factory(jQuery, _);\r\n    } else {\r\n        factory(jQuery, _);\r\n    }\r\n})(function($, _) {\r\n\r\n    var scope = window;\r\n\r\n    var obsolete = function(f, oldName, newName) {\r\n        var wrapper = function() {\r\n            console.warn('gridstack.js: Function `' + oldName + '` is deprecated as of v0.2.5 and has been replaced ' +\r\n                'with `' + newName + '`. It will be **completely** removed in v1.0.');\r\n            return f.apply(this, arguments);\r\n        };\r\n        wrapper.prototype = f.prototype;\r\n\r\n        return wrapper;\r\n    };\r\n\r\n    var obsoleteOpts = function(oldName, newName) {\r\n        console.warn('gridstack.js: Option `' + oldName + '` is deprecated as of v0.2.5 and has been replaced with `' +\r\n            newName + '`. It will be **completely** removed in v1.0.');\r\n    };\r\n\r\n    var Utils = {\r\n        isIntercepted: function(a, b) {\r\n            return !(a.x + a.width <= b.x || b.x + b.width <= a.x || a.y + a.height <= b.y || b.y + b.height <= a.y);\r\n        },\r\n\r\n        sort: function(nodes, dir, width) {\r\n            width = width || _.chain(nodes).map(function(node) { return node.x + node.width; }).max().value();\r\n            dir = dir != -1 ? 1 : -1;\r\n            return _.sortBy(nodes, function(n) { return dir * (n.x + n.y * width); });\r\n        },\r\n\r\n        createStylesheet: function(id) {\r\n            var style = document.createElement('style');\r\n            style.setAttribute('type', 'text/css');\r\n            style.setAttribute('data-gs-style-id', id);\r\n            if (style.styleSheet) {\r\n                style.styleSheet.cssText = '';\r\n            } else {\r\n                style.appendChild(document.createTextNode(''));\r\n            }\r\n            document.getElementsByTagName('head')[0].appendChild(style);\r\n            return style.sheet;\r\n        },\r\n\r\n        removeStylesheet: function(id) {\r\n            $('STYLE[data-gs-style-id=' + id + ']').remove();\r\n        },\r\n\r\n        insertCSSRule: function(sheet, selector, rules, index) {\r\n            if (typeof sheet.insertRule === 'function') {\r\n                sheet.insertRule(selector + '{' + rules + '}', index);\r\n            } else if (typeof sheet.addRule === 'function') {\r\n                sheet.addRule(selector, rules, index);\r\n            }\r\n        },\r\n\r\n        toBool: function(v) {\r\n            if (typeof v == 'boolean') {\r\n                return v;\r\n            }\r\n            if (typeof v == 'string') {\r\n                v = v.toLowerCase();\r\n                return !(v === '' || v == 'no' || v == 'false' || v == '0');\r\n            }\r\n            return Boolean(v);\r\n        },\r\n\r\n        _collisionNodeCheck: function(n) {\r\n            return n != this.node && Utils.isIntercepted(n, this.nn);\r\n        },\r\n\r\n        _didCollide: function(bn) {\r\n            return Utils.isIntercepted({x: this.n.x, y: this.newY, width: this.n.width, height: this.n.height}, bn);\r\n        },\r\n\r\n        _isAddNodeIntercepted: function(n) {\r\n            return Utils.isIntercepted({x: this.x, y: this.y, width: this.node.width, height: this.node.height}, n);\r\n        },\r\n\r\n        parseHeight: function(val) {\r\n            var height = val;\r\n            var heightUnit = 'px';\r\n            if (height && _.isString(height)) {\r\n                var match = height.match(/^(-[0-9]+\\.[0-9]+|[0-9]*\\.[0-9]+|-[0-9]+|[0-9]+)(px|em|rem|vh|vw)?$/);\r\n                if (!match) {\r\n                    throw new Error('Invalid height');\r\n                }\r\n                heightUnit = match[2] || 'px';\r\n                height = parseFloat(match[1]);\r\n            }\r\n            return {height: height, unit: heightUnit};\r\n        },\r\n\r\n        removePositioningStyles: function(el) {\r\n            var style = el[0].style;\r\n            if (style.position) {\r\n                style.removeProperty('position');\r\n            }\r\n            if (style.left) {\r\n                style.removeProperty('left');\r\n            }\r\n            if (style.top) {\r\n                style.removeProperty('top');\r\n            }\r\n            if (style.width) {\r\n                style.removeProperty('width');\r\n            }\r\n            if (style.height) {\r\n                style.removeProperty('height');\r\n            }\r\n        }\r\n    };\r\n\r\n    // jscs:disable requireCamelCaseOrUpperCaseIdentifiers\r\n    Utils.is_intercepted = obsolete(Utils.isIntercepted, 'is_intercepted', 'isIntercepted');\r\n\r\n    Utils.create_stylesheet = obsolete(Utils.createStylesheet, 'create_stylesheet', 'createStylesheet');\r\n\r\n    Utils.remove_stylesheet = obsolete(Utils.removeStylesheet, 'remove_stylesheet', 'removeStylesheet');\r\n\r\n    Utils.insert_css_rule = obsolete(Utils.insertCSSRule, 'insert_css_rule', 'insertCSSRule');\r\n    // jscs:enable requireCamelCaseOrUpperCaseIdentifiers\r\n\r\n    /**\r\n     * @class GridStackDragDropPlugin\r\n     * Base class for drag'n'drop plugin.\r\n     */\r\n    function GridStackDragDropPlugin(grid) {\r\n        this.grid = grid;\r\n    }\r\n\r\n    GridStackDragDropPlugin.registeredPlugins = [];\r\n\r\n    GridStackDragDropPlugin.registerPlugin = function(pluginClass) {\r\n        GridStackDragDropPlugin.registeredPlugins.push(pluginClass);\r\n    };\r\n\r\n    GridStackDragDropPlugin.prototype.resizable = function(el, opts) {\r\n        return this;\r\n    };\r\n\r\n    GridStackDragDropPlugin.prototype.draggable = function(el, opts) {\r\n        return this;\r\n    };\r\n\r\n    GridStackDragDropPlugin.prototype.droppable = function(el, opts) {\r\n        return this;\r\n    };\r\n\r\n    GridStackDragDropPlugin.prototype.isDroppable = function(el) {\r\n        return false;\r\n    };\r\n\r\n    GridStackDragDropPlugin.prototype.on = function(el, eventName, callback) {\r\n        return this;\r\n    };\r\n\r\n\r\n    var idSeq = 0;\r\n\r\n    var GridStackEngine = function(width, onchange, floatMode, height, items) {\r\n        this.width = width;\r\n        this.float = floatMode || false;\r\n        this.height = height || 0;\r\n\r\n        this.nodes = items || [];\r\n        this.onchange = onchange || function() {};\r\n\r\n        this._updateCounter = 0;\r\n        this._float = this.float;\r\n\r\n        this._addedNodes = [];\r\n        this._removedNodes = [];\r\n    };\r\n\r\n    GridStackEngine.prototype.batchUpdate = function() {\r\n        this._updateCounter = 1;\r\n        this.float = true;\r\n    };\r\n\r\n    GridStackEngine.prototype.commit = function() {\r\n        if (this._updateCounter !== 0) {\r\n            this._updateCounter = 0;\r\n            this.float = this._float;\r\n            this._packNodes();\r\n            this._notify();\r\n        }\r\n    };\r\n\r\n    // For Meteor support: https://github.com/troolee/gridstack.js/pull/272\r\n    GridStackEngine.prototype.getNodeDataByDOMEl = function(el) {\r\n        return _.find(this.nodes, function(n) { return el.get(0) === n.el.get(0); });\r\n    };\r\n\r\n    GridStackEngine.prototype._fixCollisions = function(node) {\r\n        var self = this;\r\n        this._sortNodes(-1);\r\n\r\n        var nn = node;\r\n        var hasLocked = Boolean(_.find(this.nodes, function(n) { return n.locked; }));\r\n        if (!this.float && !hasLocked) {\r\n            nn = {x: 0, y: node.y, width: this.width, height: node.height};\r\n        }\r\n        while (true) {\r\n            var collisionNode = _.find(this.nodes, _.bind(Utils._collisionNodeCheck, {node: node, nn: nn}));\r\n            if (typeof collisionNode == 'undefined') {\r\n                return;\r\n            }\r\n            this.moveNode(collisionNode, collisionNode.x, node.y + node.height,\r\n                collisionNode.width, collisionNode.height, true);\r\n        }\r\n    };\r\n\r\n    GridStackEngine.prototype.isAreaEmpty = function(x, y, width, height) {\r\n        var nn = {x: x || 0, y: y || 0, width: width || 1, height: height || 1};\r\n        var collisionNode = _.find(this.nodes, _.bind(function(n) {\r\n            return Utils.isIntercepted(n, nn);\r\n        }, this));\r\n        return collisionNode === null || typeof collisionNode === 'undefined';\r\n    };\r\n\r\n    GridStackEngine.prototype._sortNodes = function(dir) {\r\n        this.nodes = Utils.sort(this.nodes, dir, this.width);\r\n    };\r\n\r\n    GridStackEngine.prototype._packNodes = function() {\r\n        this._sortNodes();\r\n\r\n        if (this.float) {\r\n            _.each(this.nodes, _.bind(function(n, i) {\r\n                if (n._updating || typeof n._origY == 'undefined' || n.y == n._origY) {\r\n                    return;\r\n                }\r\n\r\n                var newY = n.y;\r\n                while (newY >= n._origY) {\r\n                    var collisionNode = _.chain(this.nodes)\r\n                        .take(i)\r\n                        .find(_.bind(Utils._didCollide, {n: n, newY: newY}))\r\n                        .value();\r\n\r\n                    if (!collisionNode) {\r\n                        n._dirty = true;\r\n                        n.y = newY;\r\n                    }\r\n                    --newY;\r\n                }\r\n            }, this));\r\n        } else {\r\n            _.each(this.nodes, _.bind(function(n, i) {\r\n                if (n.locked) {\r\n                    return;\r\n                }\r\n                while (n.y > 0) {\r\n                    var newY = n.y - 1;\r\n                    var canBeMoved = i === 0;\r\n\r\n                    if (i > 0) {\r\n                        var collisionNode = _.chain(this.nodes)\r\n                            .take(i)\r\n                            .find(_.bind(Utils._didCollide, {n: n, newY: newY}))\r\n                            .value();\r\n                        canBeMoved = typeof collisionNode == 'undefined';\r\n                    }\r\n\r\n                    if (!canBeMoved) {\r\n                        break;\r\n                    }\r\n                    n._dirty = n.y != newY;\r\n                    n.y = newY;\r\n                }\r\n            }, this));\r\n        }\r\n    };\r\n\r\n    GridStackEngine.prototype._prepareNode = function(node, resizing) {\r\n        node = _.defaults(node || {}, {width: 1, height: 1, x: 0, y: 0});\r\n\r\n        node.x = parseInt('' + node.x);\r\n        node.y = parseInt('' + node.y);\r\n        node.width = parseInt('' + node.width);\r\n        node.height = parseInt('' + node.height);\r\n        node.autoPosition = node.autoPosition || false;\r\n        node.noResize = node.noResize || false;\r\n        node.noMove = node.noMove || false;\r\n\r\n        if (node.width > this.width) {\r\n            node.width = this.width;\r\n        } else if (node.width < 1) {\r\n            node.width = 1;\r\n        }\r\n\r\n        if (node.height < 1) {\r\n            node.height = 1;\r\n        }\r\n\r\n        if (node.x < 0) {\r\n            node.x = 0;\r\n        }\r\n\r\n        if (node.x + node.width > this.width) {\r\n            if (resizing) {\r\n                node.width = this.width - node.x;\r\n            } else {\r\n                node.x = this.width - node.width;\r\n            }\r\n        }\r\n\r\n        if (node.y < 0) {\r\n            node.y = 0;\r\n        }\r\n\r\n        return node;\r\n    };\r\n\r\n    GridStackEngine.prototype._notify = function() {\r\n        var args = Array.prototype.slice.call(arguments, 0);\r\n        args[0] = typeof args[0] === 'undefined' ? [] : [args[0]];\r\n        args[1] = typeof args[1] === 'undefined' ? true : args[1];\r\n        if (this._updateCounter) {\r\n            return;\r\n        }\r\n        var deletedNodes = args[0].concat(this.getDirtyNodes());\r\n        this.onchange(deletedNodes, args[1]);\r\n    };\r\n\r\n    GridStackEngine.prototype.cleanNodes = function() {\r\n        if (this._updateCounter) {\r\n            return;\r\n        }\r\n        _.each(this.nodes, function(n) {n._dirty = false; });\r\n    };\r\n\r\n    GridStackEngine.prototype.getDirtyNodes = function() {\r\n        return _.filter(this.nodes, function(n) { return n._dirty; });\r\n    };\r\n\r\n    GridStackEngine.prototype.addNode = function(node, triggerAddEvent) {\r\n        node = this._prepareNode(node);\r\n\r\n        if (typeof node.maxWidth != 'undefined') { node.width = Math.min(node.width, node.maxWidth); }\r\n        if (typeof node.maxHeight != 'undefined') { node.height = Math.min(node.height, node.maxHeight); }\r\n        if (typeof node.minWidth != 'undefined') { node.width = Math.max(node.width, node.minWidth); }\r\n        if (typeof node.minHeight != 'undefined') { node.height = Math.max(node.height, node.minHeight); }\r\n\r\n        node._id = ++idSeq;\r\n        node._dirty = true;\r\n\r\n        if (node.autoPosition) {\r\n            this._sortNodes();\r\n\r\n            for (var i = 0;; ++i) {\r\n                var x = i % this.width;\r\n                var y = Math.floor(i / this.width);\r\n                if (x + node.width > this.width) {\r\n                    continue;\r\n                }\r\n                if (!_.find(this.nodes, _.bind(Utils._isAddNodeIntercepted, {x: x, y: y, node: node}))) {\r\n                    node.x = x;\r\n                    node.y = y;\r\n                    break;\r\n                }\r\n            }\r\n        }\r\n\r\n        this.nodes.push(node);\r\n        if (typeof triggerAddEvent != 'undefined' && triggerAddEvent) {\r\n            this._addedNodes.push(_.clone(node));\r\n        }\r\n\r\n        this._fixCollisions(node);\r\n        this._packNodes();\r\n        this._notify();\r\n        return node;\r\n    };\r\n\r\n    GridStackEngine.prototype.removeNode = function(node, detachNode) {\r\n        detachNode = typeof detachNode === 'undefined' ? true : detachNode;\r\n        this._removedNodes.push(_.clone(node));\r\n        node._id = null;\r\n        this.nodes = _.without(this.nodes, node);\r\n        this._packNodes();\r\n        this._notify(node, detachNode);\r\n    };\r\n\r\n    GridStackEngine.prototype.canMoveNode = function(node, x, y, width, height) {\r\n        if (!this.isNodeChangedPosition(node, x, y, width, height)) {\r\n            return false;\r\n        }\r\n        var hasLocked = Boolean(_.find(this.nodes, function(n) { return n.locked; }));\r\n\r\n        if (!this.height && !hasLocked) {\r\n            return true;\r\n        }\r\n\r\n        var clonedNode;\r\n        var clone = new GridStackEngine(\r\n            this.width,\r\n            null,\r\n            this.float,\r\n            0,\r\n            _.map(this.nodes, function(n) {\r\n                if (n == node) {\r\n                    clonedNode = $.extend({}, n);\r\n                    return clonedNode;\r\n                }\r\n                return $.extend({}, n);\r\n            }));\r\n\r\n        if (typeof clonedNode === 'undefined') {\r\n            return true;\r\n        }\r\n\r\n        clone.moveNode(clonedNode, x, y, width, height);\r\n\r\n        var res = true;\r\n\r\n        if (hasLocked) {\r\n            res &= !Boolean(_.find(clone.nodes, function(n) {\r\n                return n != clonedNode && Boolean(n.locked) && Boolean(n._dirty);\r\n            }));\r\n        }\r\n        if (this.height) {\r\n            res &= clone.getGridHeight() <= this.height;\r\n        }\r\n\r\n        return res;\r\n    };\r\n\r\n    GridStackEngine.prototype.canBePlacedWithRespectToHeight = function(node) {\r\n        if (!this.height) {\r\n            return true;\r\n        }\r\n\r\n        var clone = new GridStackEngine(\r\n            this.width,\r\n            null,\r\n            this.float,\r\n            0,\r\n            _.map(this.nodes, function(n) { return $.extend({}, n); }));\r\n        clone.addNode(node);\r\n        return clone.getGridHeight() <= this.height;\r\n    };\r\n\r\n    GridStackEngine.prototype.isNodeChangedPosition = function(node, x, y, width, height) {\r\n        if (typeof x != 'number') { x = node.x; }\r\n        if (typeof y != 'number') { y = node.y; }\r\n        if (typeof width != 'number') { width = node.width; }\r\n        if (typeof height != 'number') { height = node.height; }\r\n\r\n        if (typeof node.maxWidth != 'undefined') { width = Math.min(width, node.maxWidth); }\r\n        if (typeof node.maxHeight != 'undefined') { height = Math.min(height, node.maxHeight); }\r\n        if (typeof node.minWidth != 'undefined') { width = Math.max(width, node.minWidth); }\r\n        if (typeof node.minHeight != 'undefined') { height = Math.max(height, node.minHeight); }\r\n\r\n        if (node.x == x && node.y == y && node.width == width && node.height == height) {\r\n            return false;\r\n        }\r\n        return true;\r\n    };\r\n\r\n    GridStackEngine.prototype.moveNode = function(node, x, y, width, height, noPack) {\r\n        if (!this.isNodeChangedPosition(node, x, y, width, height)) {\r\n            return node;\r\n        }\r\n        if (typeof x != 'number') { x = node.x; }\r\n        if (typeof y != 'number') { y = node.y; }\r\n        if (typeof width != 'number') { width = node.width; }\r\n        if (typeof height != 'number') { height = node.height; }\r\n\r\n        if (typeof node.maxWidth != 'undefined') { width = Math.min(width, node.maxWidth); }\r\n        if (typeof node.maxHeight != 'undefined') { height = Math.min(height, node.maxHeight); }\r\n        if (typeof node.minWidth != 'undefined') { width = Math.max(width, node.minWidth); }\r\n        if (typeof node.minHeight != 'undefined') { height = Math.max(height, node.minHeight); }\r\n\r\n        if (node.x == x && node.y == y && node.width == width && node.height == height) {\r\n            return node;\r\n        }\r\n\r\n        var resizing = node.width != width;\r\n        node._dirty = true;\r\n\r\n        node.x = x;\r\n        node.y = y;\r\n        node.width = width;\r\n        node.height = height;\r\n\r\n        node.lastTriedX = x;\r\n        node.lastTriedY = y;\r\n        node.lastTriedWidth = width;\r\n        node.lastTriedHeight = height;\r\n\r\n        node = this._prepareNode(node, resizing);\r\n\r\n        this._fixCollisions(node);\r\n        if (!noPack) {\r\n            this._packNodes();\r\n            this._notify();\r\n        }\r\n        return node;\r\n    };\r\n\r\n    GridStackEngine.prototype.getGridHeight = function() {\r\n        return _.reduce(this.nodes, function(memo, n) { return Math.max(memo, n.y + n.height); }, 0);\r\n    };\r\n\r\n    GridStackEngine.prototype.beginUpdate = function(node) {\r\n        _.each(this.nodes, function(n) {\r\n            n._origY = n.y;\r\n        });\r\n        node._updating = true;\r\n    };\r\n\r\n    GridStackEngine.prototype.endUpdate = function() {\r\n        _.each(this.nodes, function(n) {\r\n            n._origY = n.y;\r\n        });\r\n        var n = _.find(this.nodes, function(n) { return n._updating; });\r\n        if (n) {\r\n            n._updating = false;\r\n        }\r\n    };\r\n\r\n    var GridStack = function(el, opts) {\r\n        var self = this;\r\n        var oneColumnMode, isAutoCellHeight;\r\n\r\n        opts = opts || {};\r\n\r\n        this.container = $(el);\r\n\r\n        // jscs:disable requireCamelCaseOrUpperCaseIdentifiers\r\n        if (typeof opts.handle_class !== 'undefined') {\r\n            opts.handleClass = opts.handle_class;\r\n            obsoleteOpts('handle_class', 'handleClass');\r\n        }\r\n        if (typeof opts.item_class !== 'undefined') {\r\n            opts.itemClass = opts.item_class;\r\n            obsoleteOpts('item_class', 'itemClass');\r\n        }\r\n        if (typeof opts.placeholder_class !== 'undefined') {\r\n            opts.placeholderClass = opts.placeholder_class;\r\n            obsoleteOpts('placeholder_class', 'placeholderClass');\r\n        }\r\n        if (typeof opts.placeholder_text !== 'undefined') {\r\n            opts.placeholderText = opts.placeholder_text;\r\n            obsoleteOpts('placeholder_text', 'placeholderText');\r\n        }\r\n        if (typeof opts.cell_height !== 'undefined') {\r\n            opts.cellHeight = opts.cell_height;\r\n            obsoleteOpts('cell_height', 'cellHeight');\r\n        }\r\n        if (typeof opts.vertical_margin !== 'undefined') {\r\n            opts.verticalMargin = opts.vertical_margin;\r\n            obsoleteOpts('vertical_margin', 'verticalMargin');\r\n        }\r\n        if (typeof opts.min_width !== 'undefined') {\r\n            opts.minWidth = opts.min_width;\r\n            obsoleteOpts('min_width', 'minWidth');\r\n        }\r\n        if (typeof opts.static_grid !== 'undefined') {\r\n            opts.staticGrid = opts.static_grid;\r\n            obsoleteOpts('static_grid', 'staticGrid');\r\n        }\r\n        if (typeof opts.is_nested !== 'undefined') {\r\n            opts.isNested = opts.is_nested;\r\n            obsoleteOpts('is_nested', 'isNested');\r\n        }\r\n        if (typeof opts.always_show_resize_handle !== 'undefined') {\r\n            opts.alwaysShowResizeHandle = opts.always_show_resize_handle;\r\n            obsoleteOpts('always_show_resize_handle', 'alwaysShowResizeHandle');\r\n        }\r\n        // jscs:enable requireCamelCaseOrUpperCaseIdentifiers\r\n\r\n        opts.itemClass = opts.itemClass || 'grid-stack-item';\r\n        var isNested = this.container.closest('.' + opts.itemClass).length > 0;\r\n\r\n        this.opts = _.defaults(opts || {}, {\r\n            width: parseInt(this.container.attr('data-gs-width')) || 12,\r\n            height: parseInt(this.container.attr('data-gs-height')) || 0,\r\n            itemClass: 'grid-stack-item',\r\n            placeholderClass: 'grid-stack-placeholder',\r\n            placeholderText: '',\r\n            handle: '.grid-stack-item-content',\r\n            handleClass: null,\r\n            cellHeight: 60,\r\n            verticalMargin: 20,\r\n            auto: true,\r\n            minWidth: 768,\r\n            float: false,\r\n            staticGrid: false,\r\n            _class: 'grid-stack-instance-' + (Math.random() * 10000).toFixed(0),\r\n            animate: Boolean(this.container.attr('data-gs-animate')) || false,\r\n            alwaysShowResizeHandle: opts.alwaysShowResizeHandle || false,\r\n            resizable: _.defaults(opts.resizable || {}, {\r\n                autoHide: !(opts.alwaysShowResizeHandle || false),\r\n                handles: 'se'\r\n            }),\r\n            draggable: _.defaults(opts.draggable || {}, {\r\n                handle: (opts.handleClass ? '.' + opts.handleClass : (opts.handle ? opts.handle : '')) ||\r\n                '.grid-stack-item-content',\r\n                scroll: false,\r\n                appendTo: 'body'\r\n            }),\r\n            disableDrag: opts.disableDrag || false,\r\n            disableResize: opts.disableResize || false,\r\n            rtl: 'auto',\r\n            removable: false,\r\n            removableOptions: _.defaults(opts.removableOptions || {}, {\r\n                accept: '.' + opts.itemClass\r\n            }),\r\n            removeTimeout: 2000,\r\n            verticalMarginUnit: 'px',\r\n            cellHeightUnit: 'px',\r\n            disableOneColumnMode: opts.disableOneColumnMode || false,\r\n            oneColumnModeClass: opts.oneColumnModeClass || 'grid-stack-one-column-mode',\r\n            ddPlugin: null\r\n        });\r\n\r\n        if (this.opts.ddPlugin === false) {\r\n            this.opts.ddPlugin = GridStackDragDropPlugin;\r\n        } else if (this.opts.ddPlugin === null) {\r\n            this.opts.ddPlugin = _.first(GridStackDragDropPlugin.registeredPlugins) || GridStackDragDropPlugin;\r\n        }\r\n\r\n        this.dd = new this.opts.ddPlugin(this);\r\n\r\n        if (this.opts.rtl === 'auto') {\r\n            this.opts.rtl = this.container.css('direction') === 'rtl';\r\n        }\r\n\r\n        if (this.opts.rtl) {\r\n            this.container.addClass('grid-stack-rtl');\r\n        }\r\n\r\n        this.opts.isNested = isNested;\r\n\r\n        isAutoCellHeight = this.opts.cellHeight === 'auto';\r\n        if (isAutoCellHeight) {\r\n            self.cellHeight(self.cellWidth(), true);\r\n        } else {\r\n            this.cellHeight(this.opts.cellHeight, true);\r\n        }\r\n        this.verticalMargin(this.opts.verticalMargin, true);\r\n\r\n        this.container.addClass(this.opts._class);\r\n\r\n        this._setStaticClass();\r\n\r\n        if (isNested) {\r\n            this.container.addClass('grid-stack-nested');\r\n        }\r\n\r\n        this._initStyles();\r\n\r\n        this.grid = new GridStackEngine(this.opts.width, function(nodes, detachNode) {\r\n            detachNode = typeof detachNode === 'undefined' ? true : detachNode;\r\n            var maxHeight = 0;\r\n            _.each(this.nodes, function(n) {\r\n                maxHeight = Math.max(maxHeight, n.y + n.height);\r\n            });\r\n            _.each(nodes, function(n) {\r\n                if (detachNode && n._id === null) {\r\n                    if (n.el) {\r\n                        n.el.remove();\r\n                    }\r\n                } else {\r\n                    n.el\r\n                        .attr('data-gs-x', n.x)\r\n                        .attr('data-gs-y', n.y)\r\n                        .attr('data-gs-width', n.width)\r\n                        .attr('data-gs-height', n.height);\r\n                }\r\n            });\r\n            self._updateStyles(maxHeight + 10);\r\n        }, this.opts.float, this.opts.height);\r\n\r\n        if (this.opts.auto) {\r\n            var elements = [];\r\n            var _this = this;\r\n            this.container.children('.' + this.opts.itemClass + ':not(.' + this.opts.placeholderClass + ')')\r\n                .each(function(index, el) {\r\n                    el = $(el);\r\n                    elements.push({\r\n                        el: el,\r\n                        i: parseInt(el.attr('data-gs-x')) + parseInt(el.attr('data-gs-y')) * _this.opts.width\r\n                    });\r\n                });\r\n            _.chain(elements).sortBy(function(x) { return x.i; }).each(function(i) {\r\n                self._prepareElement(i.el);\r\n            }).value();\r\n        }\r\n\r\n        this.setAnimation(this.opts.animate);\r\n\r\n        this.placeholder = $(\r\n            '<div class=\"' + this.opts.placeholderClass + ' ' + this.opts.itemClass + '\">' +\r\n            '<div class=\"placeholder-content\">' + this.opts.placeholderText + '</div></div>').hide();\r\n\r\n        this._updateContainerHeight();\r\n\r\n        this._updateHeightsOnResize = _.throttle(function() {\r\n            self.cellHeight(self.cellWidth(), false);\r\n        }, 100);\r\n\r\n        this.onResizeHandler = function() {\r\n            if (isAutoCellHeight) {\r\n                self._updateHeightsOnResize();\r\n            }\r\n\r\n            if (self._isOneColumnMode() && !self.opts.disableOneColumnMode) {\r\n                if (oneColumnMode) {\r\n                    return;\r\n                }\r\n                self.container.addClass(self.opts.oneColumnModeClass);\r\n                oneColumnMode = true;\r\n\r\n                self.grid._sortNodes();\r\n                _.each(self.grid.nodes, function(node) {\r\n                    self.container.append(node.el);\r\n\r\n                    if (self.opts.staticGrid) {\r\n                        return;\r\n                    }\r\n                    self.dd.draggable(node.el, 'disable');\r\n                    self.dd.resizable(node.el, 'disable');\r\n\r\n                    node.el.trigger('resize');\r\n                });\r\n            } else {\r\n                if (!oneColumnMode) {\r\n                    return;\r\n                }\r\n\r\n                self.container.removeClass(self.opts.oneColumnModeClass);\r\n                oneColumnMode = false;\r\n\r\n                if (self.opts.staticGrid) {\r\n                    return;\r\n                }\r\n\r\n                _.each(self.grid.nodes, function(node) {\r\n                    if (!node.noMove && !self.opts.disableDrag) {\r\n                        self.dd.draggable(node.el, 'enable');\r\n                    }\r\n                    if (!node.noResize && !self.opts.disableResize) {\r\n                        self.dd.resizable(node.el, 'enable');\r\n                    }\r\n\r\n                    node.el.trigger('resize');\r\n                });\r\n            }\r\n        };\r\n\r\n        $(window).resize(this.onResizeHandler);\r\n        this.onResizeHandler();\r\n\r\n        if (!self.opts.staticGrid && typeof self.opts.removable === 'string') {\r\n            var trashZone = $(self.opts.removable);\r\n            if (!this.dd.isDroppable(trashZone)) {\r\n                this.dd.droppable(trashZone, self.opts.removableOptions);\r\n            }\r\n            this.dd\r\n                .on(trashZone, 'dropover', function(event, ui) {\r\n                    var el = $(ui.draggable);\r\n                    var node = el.data('_gridstack_node');\r\n                    if (node._grid !== self) {\r\n                        return;\r\n                    }\r\n                    el.data('inTrashZone', true);\r\n                    self._setupRemovingTimeout(el);\r\n                })\r\n                .on(trashZone, 'dropout', function(event, ui) {\r\n                    var el = $(ui.draggable);\r\n                    var node = el.data('_gridstack_node');\r\n                    if (node._grid !== self) {\r\n                        return;\r\n                    }\r\n                    el.data('inTrashZone', false);\r\n                    self._clearRemovingTimeout(el);\r\n                });\r\n        }\r\n\r\n        if (!self.opts.staticGrid && self.opts.acceptWidgets) {\r\n            var draggingElement = null;\r\n\r\n            var onDrag = function(event, ui) {\r\n                var el = draggingElement;\r\n                var node = el.data('_gridstack_node');\r\n                var pos = self.getCellFromPixel({left: event.pageX, top: event.pageY}, true);\r\n                var x = Math.max(0, pos.x);\r\n                var y = Math.max(0, pos.y);\r\n                if (!node._added) {\r\n                    node._added = true;\r\n\r\n                    node.el = el;\r\n                    node.autoPosition = true;\r\n                    node.x = x;\r\n                    node.y = y;\r\n                    self.grid.cleanNodes();\r\n                    self.grid.beginUpdate(node);\r\n                    self.grid.addNode(node);\r\n\r\n                    self.container.append(self.placeholder);\r\n                    self.placeholder\r\n                        .attr('data-gs-x', node.x)\r\n                        .attr('data-gs-y', node.y)\r\n                        .attr('data-gs-width', node.width)\r\n                        .attr('data-gs-height', node.height)\r\n                        .show();\r\n                    node.el = self.placeholder;\r\n                    node._beforeDragX = node.x;\r\n                    node._beforeDragY = node.y;\r\n\r\n                    self._updateContainerHeight();\r\n                }\r\n                if (!self.grid.canMoveNode(node, x, y)) {\r\n                    return;\r\n                }\r\n                self.grid.moveNode(node, x, y);\r\n                self._updateContainerHeight();\r\n            };\r\n\r\n            this.dd\r\n                .droppable(self.container, {\r\n                    accept: function(el) {\r\n                        el = $(el);\r\n                        var node = el.data('_gridstack_node');\r\n                        if (node && node._grid === self) {\r\n                            return false;\r\n                        }\r\n                        return el.is(self.opts.acceptWidgets === true ? '.grid-stack-item' : self.opts.acceptWidgets);\r\n                    }\r\n                })\r\n                .on(self.container, 'dropover', function(event, ui) {\r\n                    var offset = self.container.offset();\r\n                    var el = $(ui.draggable);\r\n                    var cellWidth = self.cellWidth();\r\n                    var cellHeight = self.cellHeight();\r\n                    var origNode = el.data('_gridstack_node');\r\n\r\n                    var width = origNode ? origNode.width : (Math.ceil(el.outerWidth() / cellWidth));\r\n                    var height = origNode ? origNode.height : (Math.ceil(el.outerHeight() / cellHeight));\r\n\r\n                    draggingElement = el;\r\n\r\n                    var node = self.grid._prepareNode({width: width, height: height, _added: false, _temporary: true});\r\n                    el.data('_gridstack_node', node);\r\n                    el.data('_gridstack_node_orig', origNode);\r\n\r\n                    el.on('drag', onDrag);\r\n                })\r\n                .on(self.container, 'dropout', function(event, ui) {\r\n                    var el = $(ui.draggable);\r\n                    if (!el.data('_gridstack_node')) {\r\n                        return;\r\n                    }\r\n                    el.unbind('drag', onDrag);\r\n                    var node = el.data('_gridstack_node');\r\n                    node.el = null;\r\n                    self.grid.removeNode(node);\r\n                    self.placeholder.detach();\r\n                    self._updateContainerHeight();\r\n                    el.data('_gridstack_node', el.data('_gridstack_node_orig'));\r\n                })\r\n                .on(self.container, 'drop', function(event, ui) {\r\n                    self.placeholder.detach();\r\n\r\n                    var node = $(ui.draggable).data('_gridstack_node');\r\n                    node._grid = self;\r\n                    var el = $(ui.draggable).clone(false);\r\n                    el.data('_gridstack_node', node);\r\n                    var originalNode = $(ui.draggable).data('_gridstack_node_orig');\r\n                    if (typeof originalNode !== 'undefined' && typeof originalNode._grid !== 'undefined') {\r\n                        originalNode._grid._triggerRemoveEvent();\r\n                    }\r\n                    $(ui.helper).remove();\r\n                    node.el = el;\r\n                    self.placeholder.hide();\r\n                    Utils.removePositioningStyles(el);\r\n                    el.find('div.ui-resizable-handle').remove();\r\n\r\n                    el\r\n                        .attr('data-gs-x', node.x)\r\n                        .attr('data-gs-y', node.y)\r\n                        .attr('data-gs-width', node.width)\r\n                        .attr('data-gs-height', node.height)\r\n                        .addClass(self.opts.itemClass)\r\n                        .enableSelection()\r\n                        .removeData('draggable')\r\n                        .removeClass('ui-draggable ui-draggable-dragging ui-draggable-disabled')\r\n                        .unbind('drag', onDrag);\r\n                    self.container.append(el);\r\n                    self._prepareElementsByNode(el, node);\r\n                    self._updateContainerHeight();\r\n                    self.grid._addedNodes.push(node);\r\n                    self._triggerAddEvent();\r\n                    self._triggerChangeEvent();\r\n\r\n                    self.grid.endUpdate();\r\n                    $(ui.draggable).unbind('drag', onDrag);\r\n                    $(ui.draggable).removeData('_gridstack_node');\r\n                    $(ui.draggable).removeData('_gridstack_node_orig');\r\n                });\r\n        }\r\n    };\r\n\r\n    GridStack.prototype._triggerChangeEvent = function(forceTrigger) {\r\n        var elements = this.grid.getDirtyNodes();\r\n        var hasChanges = false;\r\n\r\n        var eventParams = [];\r\n        if (elements && elements.length) {\r\n            eventParams.push(elements);\r\n            hasChanges = true;\r\n        }\r\n\r\n        if (hasChanges || forceTrigger === true) {\r\n            this.container.trigger('change', eventParams);\r\n        }\r\n    };\r\n\r\n    GridStack.prototype._triggerAddEvent = function() {\r\n        if (this.grid._addedNodes && this.grid._addedNodes.length > 0) {\r\n            this.container.trigger('added', [_.map(this.grid._addedNodes, _.clone)]);\r\n            this.grid._addedNodes = [];\r\n        }\r\n    };\r\n\r\n    GridStack.prototype._triggerRemoveEvent = function() {\r\n        if (this.grid._removedNodes && this.grid._removedNodes.length > 0) {\r\n            this.container.trigger('removed', [_.map(this.grid._removedNodes, _.clone)]);\r\n            this.grid._removedNodes = [];\r\n        }\r\n    };\r\n\r\n    GridStack.prototype._initStyles = function() {\r\n        if (this._stylesId) {\r\n            Utils.removeStylesheet(this._stylesId);\r\n        }\r\n        this._stylesId = 'gridstack-style-' + (Math.random() * 100000).toFixed();\r\n        this._styles = Utils.createStylesheet(this._stylesId);\r\n        if (this._styles !== null) {\r\n            this._styles._max = 0;\r\n        }\r\n    };\r\n\r\n    GridStack.prototype._updateStyles = function(maxHeight) {\r\n        if (this._styles === null || typeof this._styles === 'undefined') {\r\n            return;\r\n        }\r\n\r\n        var prefix = '.' + this.opts._class + ' .' + this.opts.itemClass;\r\n        var self = this;\r\n        var getHeight;\r\n\r\n        if (typeof maxHeight == 'undefined') {\r\n            maxHeight = this._styles._max;\r\n        }\r\n        if (this._styles._max !== 0 && maxHeight <= this._styles._max) { // Keep this._styles._max increasing\r\n            return ;\r\n        }\r\n        this._initStyles();\r\n        this._updateContainerHeight();\r\n        if (!this.opts.cellHeight) { // The rest will be handled by CSS\r\n            return ;\r\n        }\r\n\r\n        if (!this.opts.verticalMargin || this.opts.cellHeightUnit === this.opts.verticalMarginUnit) {\r\n            getHeight = function(nbRows, nbMargins) {\r\n                return (self.opts.cellHeight * nbRows + self.opts.verticalMargin * nbMargins) +\r\n                    self.opts.cellHeightUnit;\r\n            };\r\n        } else {\r\n            getHeight = function(nbRows, nbMargins) {\r\n                if (!nbRows || !nbMargins) {\r\n                    return (self.opts.cellHeight * nbRows + self.opts.verticalMargin * nbMargins) +\r\n                        self.opts.cellHeightUnit;\r\n                }\r\n                return 'calc(' + ((self.opts.cellHeight * nbRows) + self.opts.cellHeightUnit) + ' + ' +\r\n                    ((self.opts.verticalMargin * nbMargins) + self.opts.verticalMarginUnit) + ')';\r\n            };\r\n        }\r\n\r\n        if (this._styles._max === 0) {\r\n            Utils.insertCSSRule(this._styles, prefix, 'min-height: ' + getHeight(1, 0) + ';', 0);\r\n        }\r\n\r\n        if (maxHeight > this._styles._max) {\r\n            for (var i = this._styles._max; i < maxHeight; ++i) {\r\n                Utils.insertCSSRule(this._styles,\r\n                    prefix + '[data-gs-height=\"' + (i + 1) + '\"]',\r\n                    'height: ' + getHeight(i + 1, i) + ';',\r\n                    i\r\n                );\r\n                Utils.insertCSSRule(this._styles,\r\n                    prefix + '[data-gs-min-height=\"' + (i + 1) + '\"]',\r\n                    'min-height: ' + getHeight(i + 1, i) + ';',\r\n                    i\r\n                );\r\n                Utils.insertCSSRule(this._styles,\r\n                    prefix + '[data-gs-max-height=\"' + (i + 1) + '\"]',\r\n                    'max-height: ' + getHeight(i + 1, i) + ';',\r\n                    i\r\n                );\r\n                Utils.insertCSSRule(this._styles,\r\n                    prefix + '[data-gs-y=\"' + i + '\"]',\r\n                    'top: ' + getHeight(i, i) + ';',\r\n                    i\r\n                );\r\n            }\r\n            this._styles._max = maxHeight;\r\n        }\r\n    };\r\n\r\n    GridStack.prototype._updateContainerHeight = function() {\r\n        if (this.grid._updateCounter) {\r\n            return;\r\n        }\r\n        var height = this.grid.getGridHeight();\r\n        // check for css min height. Each row is cellHeight + verticalMargin, until last one which has no margin below\r\n        var cssMinHeight = parseInt(this.container.css('min-height'));\r\n        if (cssMinHeight > 0) {\r\n            var minHeight = (cssMinHeight + this.opts.verticalMargin) / (this.cellHeight() + this.opts.verticalMargin);\r\n            if (height < minHeight) {\r\n                height = minHeight;\r\n            }\r\n        }\r\n        this.container.attr('data-gs-current-height', height);\r\n        if (!this.opts.cellHeight) {\r\n            return ;\r\n        }\r\n        if (!this.opts.verticalMargin) {\r\n            this.container.css('height', (height * (this.opts.cellHeight)) + this.opts.cellHeightUnit);\r\n        } else if (this.opts.cellHeightUnit === this.opts.verticalMarginUnit) {\r\n            this.container.css('height', (height * (this.opts.cellHeight + this.opts.verticalMargin) -\r\n                this.opts.verticalMargin) + this.opts.cellHeightUnit);\r\n        } else {\r\n            this.container.css('height', 'calc(' + ((height * (this.opts.cellHeight)) + this.opts.cellHeightUnit) +\r\n                ' + ' + ((height * (this.opts.verticalMargin - 1)) + this.opts.verticalMarginUnit) + ')');\r\n        }\r\n    };\r\n\r\n    GridStack.prototype._isOneColumnMode = function() {\r\n        return (window.innerWidth || document.documentElement.clientWidth || document.body.clientWidth) <=\r\n            this.opts.minWidth;\r\n    };\r\n\r\n    GridStack.prototype._setupRemovingTimeout = function(el) {\r\n        var self = this;\r\n        var node = $(el).data('_gridstack_node');\r\n\r\n        if (node._removeTimeout || !self.opts.removable) {\r\n            return;\r\n        }\r\n        node._removeTimeout = setTimeout(function() {\r\n            el.addClass('grid-stack-item-removing');\r\n            node._isAboutToRemove = true;\r\n        }, self.opts.removeTimeout);\r\n    };\r\n\r\n    GridStack.prototype._clearRemovingTimeout = function(el) {\r\n        var node = $(el).data('_gridstack_node');\r\n\r\n        if (!node._removeTimeout) {\r\n            return;\r\n        }\r\n        clearTimeout(node._removeTimeout);\r\n        node._removeTimeout = null;\r\n        el.removeClass('grid-stack-item-removing');\r\n        node._isAboutToRemove = false;\r\n    };\r\n\r\n    GridStack.prototype._prepareElementsByNode = function(el, node) {\r\n        var self = this;\r\n\r\n        var cellWidth;\r\n        var cellHeight;\r\n\r\n        var dragOrResize = function(event, ui) {\r\n            var x = Math.round(ui.position.left / cellWidth);\r\n            var y = Math.floor((ui.position.top + cellHeight / 2) / cellHeight);\r\n            var width;\r\n            var height;\r\n\r\n            if (event.type != 'drag') {\r\n                width = Math.round(ui.size.width / cellWidth);\r\n                height = Math.round(ui.size.height / cellHeight);\r\n            }\r\n\r\n            if (event.type == 'drag') {\r\n                if (el.data('inTrashZone') || x < 0 || x >= self.grid.width || y < 0 ||\r\n                    (!self.grid.float && y > self.grid.getGridHeight())) {\r\n                    if (!node._temporaryRemoved) {\r\n                        if (self.opts.removable === true) {\r\n                            self._setupRemovingTimeout(el);\r\n                        }\r\n\r\n                        x = node._beforeDragX;\r\n                        y = node._beforeDragY;\r\n\r\n                        self.placeholder.detach();\r\n                        self.placeholder.hide();\r\n                        self.grid.removeNode(node);\r\n                        self._updateContainerHeight();\r\n\r\n                        node._temporaryRemoved = true;\r\n                    }\r\n                } else {\r\n                    self._clearRemovingTimeout(el);\r\n\r\n                    if (node._temporaryRemoved) {\r\n                        self.grid.addNode(node);\r\n                        self.placeholder\r\n                            .attr('data-gs-x', x)\r\n                            .attr('data-gs-y', y)\r\n                            .attr('data-gs-width', width)\r\n                            .attr('data-gs-height', height)\r\n                            .show();\r\n                        self.container.append(self.placeholder);\r\n                        node.el = self.placeholder;\r\n                        node._temporaryRemoved = false;\r\n                    }\r\n                }\r\n            } else if (event.type == 'resize')  {\r\n                if (x < 0) {\r\n                    return;\r\n                }\r\n            }\r\n            // width and height are undefined if not resizing\r\n            var lastTriedWidth = typeof width !== 'undefined' ? width : node.lastTriedWidth;\r\n            var lastTriedHeight = typeof height !== 'undefined' ? height : node.lastTriedHeight;\r\n            if (!self.grid.canMoveNode(node, x, y, width, height) ||\r\n                (node.lastTriedX === x && node.lastTriedY === y &&\r\n                    node.lastTriedWidth === lastTriedWidth && node.lastTriedHeight === lastTriedHeight)) {\r\n                return;\r\n            }\r\n            node.lastTriedX = x;\r\n            node.lastTriedY = y;\r\n            node.lastTriedWidth = width;\r\n            node.lastTriedHeight = height;\r\n            self.grid.moveNode(node, x, y, width, height);\r\n            self._updateContainerHeight();\r\n        };\r\n\r\n        var onStartMoving = function(event, ui) {\r\n            self.container.append(self.placeholder);\r\n            var o = $(this);\r\n            self.grid.cleanNodes();\r\n            self.grid.beginUpdate(node);\r\n            cellWidth = self.cellWidth();\r\n            var strictCellHeight = Math.ceil(o.outerHeight() / o.attr('data-gs-height'));\r\n            cellHeight = self.container.height() / parseInt(self.container.attr('data-gs-current-height'));\r\n            self.placeholder\r\n                .attr('data-gs-x', o.attr('data-gs-x'))\r\n                .attr('data-gs-y', o.attr('data-gs-y'))\r\n                .attr('data-gs-width', o.attr('data-gs-width'))\r\n                .attr('data-gs-height', o.attr('data-gs-height'))\r\n                .show();\r\n            node.el = self.placeholder;\r\n            node._beforeDragX = node.x;\r\n            node._beforeDragY = node.y;\r\n\r\n            self.dd.resizable(el, 'option', 'minWidth', cellWidth * (node.minWidth || 1));\r\n            self.dd.resizable(el, 'option', 'minHeight', strictCellHeight * (node.minHeight || 1));\r\n\r\n            if (event.type == 'resizestart') {\r\n                o.find('.grid-stack-item').trigger('resizestart');\r\n            }\r\n        };\r\n\r\n        var onEndMoving = function(event, ui) {\r\n            var o = $(this);\r\n            if (!o.data('_gridstack_node')) {\r\n                return;\r\n            }\r\n\r\n            var forceNotify = false;\r\n            self.placeholder.detach();\r\n            node.el = o;\r\n            self.placeholder.hide();\r\n\r\n            if (node._isAboutToRemove) {\r\n                forceNotify = true;\r\n                var gridToNotify = el.data('_gridstack_node')._grid;\r\n                gridToNotify._triggerRemoveEvent();\r\n                el.removeData('_gridstack_node');\r\n                el.remove();\r\n            } else {\r\n                self._clearRemovingTimeout(el);\r\n                if (!node._temporaryRemoved) {\r\n                    Utils.removePositioningStyles(o);\r\n                    o\r\n                        .attr('data-gs-x', node.x)\r\n                        .attr('data-gs-y', node.y)\r\n                        .attr('data-gs-width', node.width)\r\n                        .attr('data-gs-height', node.height);\r\n                } else {\r\n                    Utils.removePositioningStyles(o);\r\n                    o\r\n                        .attr('data-gs-x', node._beforeDragX)\r\n                        .attr('data-gs-y', node._beforeDragY)\r\n                        .attr('data-gs-width', node.width)\r\n                        .attr('data-gs-height', node.height);\r\n                    node.x = node._beforeDragX;\r\n                    node.y = node._beforeDragY;\r\n                    node._temporaryRemoved = false;\r\n                    self.grid.addNode(node);\r\n                }\r\n            }\r\n            self._updateContainerHeight();\r\n            self._triggerChangeEvent(forceNotify);\r\n\r\n            self.grid.endUpdate();\r\n\r\n            var nestedGrids = o.find('.grid-stack');\r\n            if (nestedGrids.length && event.type == 'resizestop') {\r\n                nestedGrids.each(function(index, el) {\r\n                    $(el).data('gridstack').onResizeHandler();\r\n                });\r\n                o.find('.grid-stack-item').trigger('resizestop');\r\n                o.find('.grid-stack-item').trigger('gsresizestop');\r\n            }\r\n            if (event.type == 'resizestop') {\r\n                self.container.trigger('gsresizestop', o);\r\n            }\r\n        };\r\n\r\n        this.dd\r\n            .draggable(el, {\r\n                start: onStartMoving,\r\n                stop: onEndMoving,\r\n                drag: dragOrResize\r\n            })\r\n            .resizable(el, {\r\n                start: onStartMoving,\r\n                stop: onEndMoving,\r\n                resize: dragOrResize\r\n            });\r\n\r\n        if (node.noMove || (this._isOneColumnMode() && !self.opts.disableOneColumnMode) || this.opts.disableDrag ||\r\n            this.opts.staticGrid) {\r\n            this.dd.draggable(el, 'disable');\r\n        }\r\n\r\n        if (node.noResize || (this._isOneColumnMode() && !self.opts.disableOneColumnMode) || this.opts.disableResize ||\r\n            this.opts.staticGrid) {\r\n            this.dd.resizable(el, 'disable');\r\n        }\r\n\r\n        el.attr('data-gs-locked', node.locked ? 'yes' : null);\r\n    };\r\n\r\n    GridStack.prototype._prepareElement = function(el, triggerAddEvent) {\r\n        triggerAddEvent = typeof triggerAddEvent != 'undefined' ? triggerAddEvent : false;\r\n        var self = this;\r\n        el = $(el);\r\n\r\n        el.addClass(this.opts.itemClass);\r\n        var node = self.grid.addNode({\r\n            x: parseInt(el.attr('data-gs-x'), 10),\r\n            y: parseInt(el.attr('data-gs-y'), 10),\r\n            width: el.attr('data-gs-width'),\r\n            height: el.attr('data-gs-height'),\r\n            maxWidth: el.attr('data-gs-max-width'),\r\n            minWidth: el.attr('data-gs-min-width'),\r\n            maxHeight: el.attr('data-gs-max-height'),\r\n            minHeight: el.attr('data-gs-min-height'),\r\n            autoPosition: Utils.toBool(el.attr('data-gs-auto-position')),\r\n            noResize: Utils.toBool(el.attr('data-gs-no-resize')),\r\n            noMove: Utils.toBool(el.attr('data-gs-no-move')),\r\n            locked: Utils.toBool(el.attr('data-gs-locked')),\r\n            resizeHandles: el.attr('data-gs-resize-handles'),\r\n            el: el,\r\n            id: el.attr('data-gs-id'),\r\n            _grid: self\r\n        }, triggerAddEvent);\r\n        el.data('_gridstack_node', node);\r\n\r\n        this._prepareElementsByNode(el, node);\r\n    };\r\n\r\n    GridStack.prototype.setAnimation = function(enable) {\r\n        if (enable) {\r\n            this.container.addClass('grid-stack-animate');\r\n        } else {\r\n            this.container.removeClass('grid-stack-animate');\r\n        }\r\n    };\r\n\r\n    GridStack.prototype.addWidget = function(el, x, y, width, height, autoPosition, minWidth, maxWidth,\r\n                                             minHeight, maxHeight, id) {\r\n        el = $(el);\r\n        if (typeof x != 'undefined') { el.attr('data-gs-x', x); }\r\n        if (typeof y != 'undefined') { el.attr('data-gs-y', y); }\r\n        if (typeof width != 'undefined') { el.attr('data-gs-width', width); }\r\n        if (typeof height != 'undefined') { el.attr('data-gs-height', height); }\r\n        if (typeof autoPosition != 'undefined') { el.attr('data-gs-auto-position', autoPosition ? 'yes' : null); }\r\n        if (typeof minWidth != 'undefined') { el.attr('data-gs-min-width', minWidth); }\r\n        if (typeof maxWidth != 'undefined') { el.attr('data-gs-max-width', maxWidth); }\r\n        if (typeof minHeight != 'undefined') { el.attr('data-gs-min-height', minHeight); }\r\n        if (typeof maxHeight != 'undefined') { el.attr('data-gs-max-height', maxHeight); }\r\n        if (typeof id != 'undefined') { el.attr('data-gs-id', id); }\r\n        this.container.append(el);\r\n        this._prepareElement(el, true);\r\n        this._triggerAddEvent();\r\n        this._updateContainerHeight();\r\n        this._triggerChangeEvent(true);\r\n\r\n        return el;\r\n    };\r\n\r\n    GridStack.prototype.makeWidget = function(el) {\r\n        el = $(el);\r\n        this._prepareElement(el, true);\r\n        this._triggerAddEvent();\r\n        this._updateContainerHeight();\r\n        this._triggerChangeEvent(true);\r\n\r\n        return el;\r\n    };\r\n\r\n    GridStack.prototype.willItFit = function(x, y, width, height, autoPosition) {\r\n        var node = {x: x, y: y, width: width, height: height, autoPosition: autoPosition};\r\n        return this.grid.canBePlacedWithRespectToHeight(node);\r\n    };\r\n\r\n    GridStack.prototype.removeWidget = function(el, detachNode) {\r\n        detachNode = typeof detachNode === 'undefined' ? true : detachNode;\r\n        el = $(el);\r\n        var node = el.data('_gridstack_node');\r\n\r\n        // For Meteor support: https://github.com/troolee/gridstack.js/pull/272\r\n        if (!node) {\r\n            node = this.grid.getNodeDataByDOMEl(el);\r\n        }\r\n\r\n        this.grid.removeNode(node, detachNode);\r\n        el.removeData('_gridstack_node');\r\n        this._updateContainerHeight();\r\n        if (detachNode) {\r\n            el.remove();\r\n        }\r\n        this._triggerChangeEvent(true);\r\n        this._triggerRemoveEvent();\r\n    };\r\n\r\n    GridStack.prototype.removeAll = function(detachNode) {\r\n        _.each(this.grid.nodes, _.bind(function(node) {\r\n            this.removeWidget(node.el, detachNode);\r\n        }, this));\r\n        this.grid.nodes = [];\r\n        this._updateContainerHeight();\r\n    };\r\n\r\n    GridStack.prototype.destroy = function(detachGrid) {\r\n        $(window).off('resize', this.onResizeHandler);\r\n        this.disable();\r\n        if (typeof detachGrid != 'undefined' && !detachGrid) {\r\n            this.removeAll(false);\r\n            this.container.removeData('gridstack');\r\n        } else {\r\n            this.container.remove();\r\n        }\r\n        Utils.removeStylesheet(this._stylesId);\r\n        if (this.grid) {\r\n            this.grid = null;\r\n        }\r\n    };\r\n\r\n    GridStack.prototype.resizable = function(el, val) {\r\n        var self = this;\r\n        el = $(el);\r\n        el.each(function(index, el) {\r\n            el = $(el);\r\n            var node = el.data('_gridstack_node');\r\n            if (typeof node == 'undefined' || node === null) {\r\n                return;\r\n            }\r\n\r\n            node.noResize = !(val || false);\r\n            if (node.noResize || (self._isOneColumnMode() && !self.opts.disableOneColumnMode)) {\r\n                self.dd.resizable(el, 'disable');\r\n            } else {\r\n                self.dd.resizable(el, 'enable');\r\n            }\r\n        });\r\n        return this;\r\n    };\r\n\r\n    GridStack.prototype.movable = function(el, val) {\r\n        var self = this;\r\n        el = $(el);\r\n        el.each(function(index, el) {\r\n            el = $(el);\r\n            var node = el.data('_gridstack_node');\r\n            if (typeof node == 'undefined' || node === null) {\r\n                return;\r\n            }\r\n\r\n            node.noMove = !(val || false);\r\n            if (node.noMove || (self._isOneColumnMode() && !self.opts.disableOneColumnMode)) {\r\n                self.dd.draggable(el, 'disable');\r\n                el.removeClass('ui-draggable-handle');\r\n            } else {\r\n                self.dd.draggable(el, 'enable');\r\n                el.addClass('ui-draggable-handle');\r\n            }\r\n        });\r\n        return this;\r\n    };\r\n\r\n    GridStack.prototype.enableMove = function(doEnable, includeNewWidgets) {\r\n        this.movable(this.container.children('.' + this.opts.itemClass), doEnable);\r\n        if (includeNewWidgets) {\r\n            this.opts.disableDrag = !doEnable;\r\n        }\r\n    };\r\n\r\n    GridStack.prototype.enableResize = function(doEnable, includeNewWidgets) {\r\n        this.resizable(this.container.children('.' + this.opts.itemClass), doEnable);\r\n        if (includeNewWidgets) {\r\n            this.opts.disableResize = !doEnable;\r\n        }\r\n    };\r\n\r\n    GridStack.prototype.disable = function() {\r\n        this.movable(this.container.children('.' + this.opts.itemClass), false);\r\n        this.resizable(this.container.children('.' + this.opts.itemClass), false);\r\n        this.container.trigger('disable');\r\n    };\r\n\r\n    GridStack.prototype.enable = function() {\r\n        this.movable(this.container.children('.' + this.opts.itemClass), true);\r\n        this.resizable(this.container.children('.' + this.opts.itemClass), true);\r\n        this.container.trigger('enable');\r\n    };\r\n\r\n    GridStack.prototype.locked = function(el, val) {\r\n        el = $(el);\r\n        el.each(function(index, el) {\r\n            el = $(el);\r\n            var node = el.data('_gridstack_node');\r\n            if (typeof node == 'undefined' || node === null) {\r\n                return;\r\n            }\r\n\r\n            node.locked = (val || false);\r\n            el.attr('data-gs-locked', node.locked ? 'yes' : null);\r\n        });\r\n        return this;\r\n    };\r\n\r\n    GridStack.prototype.maxHeight = function(el, val) {\r\n        el = $(el);\r\n        el.each(function(index, el) {\r\n            el = $(el);\r\n            var node = el.data('_gridstack_node');\r\n            if (typeof node === 'undefined' || node === null) {\r\n                return;\r\n            }\r\n\r\n            if (!isNaN(val)) {\r\n                node.maxHeight = (val || false);\r\n                el.attr('data-gs-max-height', val);\r\n            }\r\n        });\r\n        return this;\r\n    };\r\n\r\n    GridStack.prototype.minHeight = function(el, val) {\r\n        el = $(el);\r\n        el.each(function(index, el) {\r\n            el = $(el);\r\n            var node = el.data('_gridstack_node');\r\n            if (typeof node === 'undefined' || node === null) {\r\n                return;\r\n            }\r\n\r\n            if (!isNaN(val)) {\r\n                node.minHeight = (val || false);\r\n                el.attr('data-gs-min-height', val);\r\n            }\r\n        });\r\n        return this;\r\n    };\r\n\r\n    GridStack.prototype.maxWidth = function(el, val) {\r\n        el = $(el);\r\n        el.each(function(index, el) {\r\n            el = $(el);\r\n            var node = el.data('_gridstack_node');\r\n            if (typeof node === 'undefined' || node === null) {\r\n                return;\r\n            }\r\n\r\n            if (!isNaN(val)) {\r\n                node.maxWidth = (val || false);\r\n                el.attr('data-gs-max-width', val);\r\n            }\r\n        });\r\n        return this;\r\n    };\r\n\r\n    GridStack.prototype.minWidth = function(el, val) {\r\n        el = $(el);\r\n        el.each(function(index, el) {\r\n            el = $(el);\r\n            var node = el.data('_gridstack_node');\r\n            if (typeof node === 'undefined' || node === null) {\r\n                return;\r\n            }\r\n\r\n            if (!isNaN(val)) {\r\n                node.minWidth = (val || false);\r\n                el.attr('data-gs-min-width', val);\r\n            }\r\n        });\r\n        return this;\r\n    };\r\n\r\n    GridStack.prototype._updateElement = function(el, callback) {\r\n        el = $(el).first();\r\n        var node = el.data('_gridstack_node');\r\n        if (typeof node == 'undefined' || node === null) {\r\n            return;\r\n        }\r\n\r\n        var self = this;\r\n\r\n        self.grid.cleanNodes();\r\n        self.grid.beginUpdate(node);\r\n\r\n        callback.call(this, el, node);\r\n\r\n        self._updateContainerHeight();\r\n        self._triggerChangeEvent();\r\n\r\n        self.grid.endUpdate();\r\n    };\r\n\r\n    GridStack.prototype.resize = function(el, width, height) {\r\n        this._updateElement(el, function(el, node) {\r\n            width = (width !== null && typeof width != 'undefined') ? width : node.width;\r\n            height = (height !== null && typeof height != 'undefined') ? height : node.height;\r\n\r\n            this.grid.moveNode(node, node.x, node.y, width, height);\r\n        });\r\n    };\r\n\r\n    GridStack.prototype.move = function(el, x, y) {\r\n        this._updateElement(el, function(el, node) {\r\n            x = (x !== null && typeof x != 'undefined') ? x : node.x;\r\n            y = (y !== null && typeof y != 'undefined') ? y : node.y;\r\n\r\n            this.grid.moveNode(node, x, y, node.width, node.height);\r\n        });\r\n    };\r\n\r\n    GridStack.prototype.update = function(el, x, y, width, height) {\r\n        this._updateElement(el, function(el, node) {\r\n            x = (x !== null && typeof x != 'undefined') ? x : node.x;\r\n            y = (y !== null && typeof y != 'undefined') ? y : node.y;\r\n            width = (width !== null && typeof width != 'undefined') ? width : node.width;\r\n            height = (height !== null && typeof height != 'undefined') ? height : node.height;\r\n\r\n            this.grid.moveNode(node, x, y, width, height);\r\n        });\r\n    };\r\n\r\n    GridStack.prototype.verticalMargin = function(val, noUpdate) {\r\n        if (typeof val == 'undefined') {\r\n            return this.opts.verticalMargin;\r\n        }\r\n\r\n        var heightData = Utils.parseHeight(val);\r\n\r\n        if (this.opts.verticalMarginUnit === heightData.unit && this.opts.height === heightData.height) {\r\n            return ;\r\n        }\r\n        this.opts.verticalMarginUnit = heightData.unit;\r\n        this.opts.verticalMargin = heightData.height;\r\n\r\n        if (!noUpdate) {\r\n            this._updateStyles();\r\n        }\r\n    };\r\n\r\n    GridStack.prototype.cellHeight = function(val, noUpdate) {\r\n        if (typeof val == 'undefined') {\r\n            if (this.opts.cellHeight) {\r\n                return this.opts.cellHeight;\r\n            }\r\n            var o = this.container.children('.' + this.opts.itemClass).first();\r\n            return Math.ceil(o.outerHeight() / o.attr('data-gs-height'));\r\n        }\r\n        var heightData = Utils.parseHeight(val);\r\n\r\n        if (this.opts.cellHeightUnit === heightData.unit && this.opts.cellHeight === heightData.height) {\r\n            return ;\r\n        }\r\n        this.opts.cellHeightUnit = heightData.unit;\r\n        this.opts.cellHeight = heightData.height;\r\n\r\n        if (!noUpdate) {\r\n            this._updateStyles();\r\n        }\r\n\r\n    };\r\n\r\n    GridStack.prototype.cellWidth = function() {\r\n        return Math.round(this.container.outerWidth() / this.opts.width);\r\n    };\r\n\r\n    GridStack.prototype.getCellFromPixel = function(position, useOffset) {\r\n        var containerPos = (typeof useOffset != 'undefined' && useOffset) ?\r\n            this.container.offset() : this.container.position();\r\n        var relativeLeft = position.left - containerPos.left;\r\n        var relativeTop = position.top - containerPos.top;\r\n\r\n        var columnWidth = Math.floor(this.container.width() / this.opts.width);\r\n        var rowHeight = Math.floor(this.container.height() / parseInt(this.container.attr('data-gs-current-height')));\r\n\r\n        return {x: Math.floor(relativeLeft / columnWidth), y: Math.floor(relativeTop / rowHeight)};\r\n    };\r\n\r\n    GridStack.prototype.batchUpdate = function() {\r\n        this.grid.batchUpdate();\r\n    };\r\n\r\n    GridStack.prototype.commit = function() {\r\n        this.grid.commit();\r\n        this._updateContainerHeight();\r\n    };\r\n\r\n    GridStack.prototype.isAreaEmpty = function(x, y, width, height) {\r\n        return this.grid.isAreaEmpty(x, y, width, height);\r\n    };\r\n\r\n    GridStack.prototype.setStatic = function(staticValue) {\r\n        this.opts.staticGrid = (staticValue === true);\r\n        this.enableMove(!staticValue);\r\n        this.enableResize(!staticValue);\r\n        this._setStaticClass();\r\n    };\r\n\r\n    GridStack.prototype._setStaticClass = function() {\r\n        var staticClassName = 'grid-stack-static';\r\n\r\n        if (this.opts.staticGrid === true) {\r\n            this.container.addClass(staticClassName);\r\n        } else {\r\n            this.container.removeClass(staticClassName);\r\n        }\r\n    };\r\n\r\n    GridStack.prototype._updateNodeWidths = function(oldWidth, newWidth) {\r\n        this.grid._sortNodes();\r\n        this.grid.batchUpdate();\r\n        var node = {};\r\n        for (var i = 0; i < this.grid.nodes.length; i++) {\r\n            node = this.grid.nodes[i];\r\n            this.update(node.el, Math.round(node.x * newWidth / oldWidth), undefined,\r\n                Math.round(node.width * newWidth / oldWidth), undefined);\r\n        }\r\n        this.grid.commit();\r\n    };\r\n\r\n    GridStack.prototype.setGridWidth = function(gridWidth,doNotPropagate) {\r\n        this.container.removeClass('grid-stack-' + this.opts.width);\r\n        if (doNotPropagate !== true) {\r\n            this._updateNodeWidths(this.opts.width, gridWidth);\r\n        }\r\n        this.opts.width = gridWidth;\r\n        this.grid.width = gridWidth;\r\n        this.container.addClass('grid-stack-' + gridWidth);\r\n    };\r\n\r\n    // jscs:disable requireCamelCaseOrUpperCaseIdentifiers\r\n    GridStackEngine.prototype.batch_update = obsolete(GridStackEngine.prototype.batchUpdate);\r\n    GridStackEngine.prototype._fix_collisions = obsolete(GridStackEngine.prototype._fixCollisions,\r\n        '_fix_collisions', '_fixCollisions');\r\n    GridStackEngine.prototype.is_area_empty = obsolete(GridStackEngine.prototype.isAreaEmpty,\r\n        'is_area_empty', 'isAreaEmpty');\r\n    GridStackEngine.prototype._sort_nodes = obsolete(GridStackEngine.prototype._sortNodes,\r\n        '_sort_nodes', '_sortNodes');\r\n    GridStackEngine.prototype._pack_nodes = obsolete(GridStackEngine.prototype._packNodes,\r\n        '_pack_nodes', '_packNodes');\r\n    GridStackEngine.prototype._prepare_node = obsolete(GridStackEngine.prototype._prepareNode,\r\n        '_prepare_node', '_prepareNode');\r\n    GridStackEngine.prototype.clean_nodes = obsolete(GridStackEngine.prototype.cleanNodes,\r\n        'clean_nodes', 'cleanNodes');\r\n    GridStackEngine.prototype.get_dirty_nodes = obsolete(GridStackEngine.prototype.getDirtyNodes,\r\n        'get_dirty_nodes', 'getDirtyNodes');\r\n    GridStackEngine.prototype.add_node = obsolete(GridStackEngine.prototype.addNode,\r\n        'add_node', 'addNode, ');\r\n    GridStackEngine.prototype.remove_node = obsolete(GridStackEngine.prototype.removeNode,\r\n        'remove_node', 'removeNode');\r\n    GridStackEngine.prototype.can_move_node = obsolete(GridStackEngine.prototype.canMoveNode,\r\n        'can_move_node', 'canMoveNode');\r\n    GridStackEngine.prototype.move_node = obsolete(GridStackEngine.prototype.moveNode,\r\n        'move_node', 'moveNode');\r\n    GridStackEngine.prototype.get_grid_height = obsolete(GridStackEngine.prototype.getGridHeight,\r\n        'get_grid_height', 'getGridHeight');\r\n    GridStackEngine.prototype.begin_update = obsolete(GridStackEngine.prototype.beginUpdate,\r\n        'begin_update', 'beginUpdate');\r\n    GridStackEngine.prototype.end_update = obsolete(GridStackEngine.prototype.endUpdate,\r\n        'end_update', 'endUpdate');\r\n    GridStackEngine.prototype.can_be_placed_with_respect_to_height =\r\n        obsolete(GridStackEngine.prototype.canBePlacedWithRespectToHeight,\r\n            'can_be_placed_with_respect_to_height', 'canBePlacedWithRespectToHeight');\r\n    GridStack.prototype._trigger_change_event = obsolete(GridStack.prototype._triggerChangeEvent,\r\n        '_trigger_change_event', '_triggerChangeEvent');\r\n    GridStack.prototype._init_styles = obsolete(GridStack.prototype._initStyles,\r\n        '_init_styles', '_initStyles');\r\n    GridStack.prototype._update_styles = obsolete(GridStack.prototype._updateStyles,\r\n        '_update_styles', '_updateStyles');\r\n    GridStack.prototype._update_container_height = obsolete(GridStack.prototype._updateContainerHeight,\r\n        '_update_container_height', '_updateContainerHeight');\r\n    GridStack.prototype._is_one_column_mode = obsolete(GridStack.prototype._isOneColumnMode,\r\n        '_is_one_column_mode','_isOneColumnMode');\r\n    GridStack.prototype._prepare_element = obsolete(GridStack.prototype._prepareElement,\r\n        '_prepare_element', '_prepareElement');\r\n    GridStack.prototype.set_animation = obsolete(GridStack.prototype.setAnimation,\r\n        'set_animation', 'setAnimation');\r\n    GridStack.prototype.add_widget = obsolete(GridStack.prototype.addWidget,\r\n        'add_widget', 'addWidget');\r\n    GridStack.prototype.make_widget = obsolete(GridStack.prototype.makeWidget,\r\n        'make_widget', 'makeWidget');\r\n    GridStack.prototype.will_it_fit = obsolete(GridStack.prototype.willItFit,\r\n        'will_it_fit', 'willItFit');\r\n    GridStack.prototype.remove_widget = obsolete(GridStack.prototype.removeWidget,\r\n        'remove_widget', 'removeWidget');\r\n    GridStack.prototype.remove_all = obsolete(GridStack.prototype.removeAll,\r\n        'remove_all', 'removeAll');\r\n    GridStack.prototype.min_height = obsolete(GridStack.prototype.minHeight,\r\n        'min_height', 'minHeight');\r\n    GridStack.prototype.min_width = obsolete(GridStack.prototype.minWidth,\r\n        'min_width', 'minWidth');\r\n    GridStack.prototype._update_element = obsolete(GridStack.prototype._updateElement,\r\n        '_update_element', '_updateElement');\r\n    GridStack.prototype.cell_height = obsolete(GridStack.prototype.cellHeight,\r\n        'cell_height', 'cellHeight');\r\n    GridStack.prototype.cell_width = obsolete(GridStack.prototype.cellWidth,\r\n        'cell_width', 'cellWidth');\r\n    GridStack.prototype.get_cell_from_pixel = obsolete(GridStack.prototype.getCellFromPixel,\r\n        'get_cell_from_pixel', 'getCellFromPixel');\r\n    GridStack.prototype.batch_update = obsolete(GridStack.prototype.batchUpdate,\r\n        'batch_update', 'batchUpdate');\r\n    GridStack.prototype.is_area_empty = obsolete(GridStack.prototype.isAreaEmpty,\r\n        'is_area_empty', 'isAreaEmpty');\r\n    GridStack.prototype.set_static = obsolete(GridStack.prototype.setStatic,\r\n        'set_static', 'setStatic');\r\n    GridStack.prototype._set_static_class = obsolete(GridStack.prototype._setStaticClass,\r\n        '_set_static_class', '_setStaticClass');\r\n    // jscs:enable requireCamelCaseOrUpperCaseIdentifiers\r\n\r\n    scope.GridStackUI = GridStack;\r\n\r\n    scope.GridStackUI.Utils = Utils;\r\n    scope.GridStackUI.Engine = GridStackEngine;\r\n    scope.GridStackUI.GridStackDragDropPlugin = GridStackDragDropPlugin;\r\n\r\n    $.fn.gridstack = function(opts) {\r\n        return this.each(function() {\r\n            var o = $(this);\r\n            if (!o.data('gridstack')) {\r\n                o\r\n                    .data('gridstack', new GridStack(this, opts));\r\n            }\r\n        });\r\n    };\r\n\r\n    return scope.GridStackUI;\r\n});","Mageplaza_Reports/js/lib/daterangepicker.min.js":"/**\r\n * Minified by jsDelivr using UglifyJS v3.4.0.\r\n * Original file: /npm/daterangepicker@3.0.3/daterangepicker.js\r\n *\r\n * Do NOT use SRI with dynamically generated files! More information: https://www.jsdelivr.com/using-sri-with-dynamic-files\r\n */\r\n!function(t,a){if(\"function\"==typeof define&&define.amd)define([\"moment\",\"jquery\"],function(t,e){return e.fn||(e.fn={}),a(t,e)});else if(\"object\"==typeof module&&module.exports){var e=\"undefined\"!=typeof window?window.jQuery:void 0;e||(e=require(\"jquery\")).fn||(e.fn={});var i=\"undefined\"!=typeof window&&void 0!==window.moment?window.moment:require(\"moment\");module.exports=a(i,e)}else t.daterangepicker=a(t.moment,t.jQuery)}(this,function(H,R){var i=function(t,e,a){if(this.parentEl=\"body\",this.element=R(t),this.startDate=H().startOf(\"day\"),this.endDate=H().endOf(\"day\"),this.minDate=!1,this.maxDate=!1,this.maxSpan=!1,this.autoApply=!1,this.singleDatePicker=!1,this.showDropdowns=!1,this.minYear=H().subtract(100,\"year\").format(\"YYYY\"),this.maxYear=H().add(100,\"year\").format(\"YYYY\"),this.showWeekNumbers=!1,this.showISOWeekNumbers=!1,this.showCustomRangeLabel=!0,this.timePicker=!1,this.timePicker24Hour=!1,this.timePickerIncrement=1,this.timePickerSeconds=!1,this.linkedCalendars=!0,this.autoUpdateInput=!0,this.alwaysShowCalendars=!1,this.ranges={},this.opens=\"right\",this.element.hasClass(\"pull-right\")&&(this.opens=\"left\"),this.drops=\"down\",this.element.hasClass(\"dropup\")&&(this.drops=\"up\"),this.buttonClasses=\"btn btn-sm\",this.applyButtonClasses=\"btn-primary\",this.cancelButtonClasses=\"btn-default\",this.locale={direction:\"ltr\",format:H.localeData().longDateFormat(\"L\"),separator:\" - \",applyLabel:\"Apply\",cancelLabel:\"Cancel\",weekLabel:\"W\",customRangeLabel:\"Custom Range\",daysOfWeek:H.weekdaysMin(),monthNames:H.monthsShort(),firstDay:H.localeData().firstDayOfWeek()},this.callback=function(){},this.isShowing=!1,this.leftCalendar={},this.rightCalendar={},\"object\"==typeof e&&null!==e||(e={}),\"string\"==typeof(e=R.extend(this.element.data(),e)).template||e.template instanceof R||(e.template='<div class=\"daterangepicker\"><div class=\"ranges\"></div><div class=\"drp-calendar left\"><div class=\"calendar-table\"></div><div class=\"calendar-time\"></div></div><div class=\"drp-calendar right\"><div class=\"calendar-table\"></div><div class=\"calendar-time\"></div></div><div class=\"drp-buttons\"><span class=\"drp-selected\"></span><button class=\"cancelBtn\" type=\"button\"></button><button class=\"applyBtn\" disabled=\"disabled\" type=\"button\"></button> </div></div>'),this.parentEl=e.parentEl&&R(e.parentEl).length?R(e.parentEl):R(this.parentEl),this.container=R(e.template).appendTo(this.parentEl),\"object\"==typeof e.locale&&(\"string\"==typeof e.locale.direction&&(this.locale.direction=e.locale.direction),\"string\"==typeof e.locale.format&&(this.locale.format=e.locale.format),\"string\"==typeof e.locale.separator&&(this.locale.separator=e.locale.separator),\"object\"==typeof e.locale.daysOfWeek&&(this.locale.daysOfWeek=e.locale.daysOfWeek.slice()),\"object\"==typeof e.locale.monthNames&&(this.locale.monthNames=e.locale.monthNames.slice()),\"number\"==typeof e.locale.firstDay&&(this.locale.firstDay=e.locale.firstDay),\"string\"==typeof e.locale.applyLabel&&(this.locale.applyLabel=e.locale.applyLabel),\"string\"==typeof e.locale.cancelLabel&&(this.locale.cancelLabel=e.locale.cancelLabel),\"string\"==typeof e.locale.weekLabel&&(this.locale.weekLabel=e.locale.weekLabel),\"string\"==typeof e.locale.customRangeLabel)){(d=document.createElement(\"textarea\")).innerHTML=e.locale.customRangeLabel;var i=d.value;this.locale.customRangeLabel=i}if(this.container.addClass(this.locale.direction),\"string\"==typeof e.startDate&&(this.startDate=H(e.startDate,this.locale.format)),\"string\"==typeof e.endDate&&(this.endDate=H(e.endDate,this.locale.format)),\"string\"==typeof e.minDate&&(this.minDate=H(e.minDate,this.locale.format)),\"string\"==typeof e.maxDate&&(this.maxDate=H(e.maxDate,this.locale.format)),\"object\"==typeof e.startDate&&(this.startDate=H(e.startDate)),\"object\"==typeof e.endDate&&(this.endDate=H(e.endDate)),\"object\"==typeof e.minDate&&(this.minDate=H(e.minDate)),\"object\"==typeof e.maxDate&&(this.maxDate=H(e.maxDate)),this.minDate&&this.startDate.isBefore(this.minDate)&&(this.startDate=this.minDate.clone()),this.maxDate&&this.endDate.isAfter(this.maxDate)&&(this.endDate=this.maxDate.clone()),\"string\"==typeof e.applyButtonClasses&&(this.applyButtonClasses=e.applyButtonClasses),\"string\"==typeof e.applyClass&&(this.applyButtonClasses=e.applyClass),\"string\"==typeof e.cancelButtonClasses&&(this.cancelButtonClasses=e.cancelButtonClasses),\"string\"==typeof e.cancelClass&&(this.cancelButtonClasses=e.cancelClass),\"object\"==typeof e.maxSpan&&(this.maxSpan=e.maxSpan),\"object\"==typeof e.dateLimit&&(this.maxSpan=e.dateLimit),\"string\"==typeof e.opens&&(this.opens=e.opens),\"string\"==typeof e.drops&&(this.drops=e.drops),\"boolean\"==typeof e.showWeekNumbers&&(this.showWeekNumbers=e.showWeekNumbers),\"boolean\"==typeof e.showISOWeekNumbers&&(this.showISOWeekNumbers=e.showISOWeekNumbers),\"string\"==typeof e.buttonClasses&&(this.buttonClasses=e.buttonClasses),\"object\"==typeof e.buttonClasses&&(this.buttonClasses=e.buttonClasses.join(\" \")),\"boolean\"==typeof e.showDropdowns&&(this.showDropdowns=e.showDropdowns),\"number\"==typeof e.minYear&&(this.minYear=e.minYear),\"number\"==typeof e.maxYear&&(this.maxYear=e.maxYear),\"boolean\"==typeof e.showCustomRangeLabel&&(this.showCustomRangeLabel=e.showCustomRangeLabel),\"boolean\"==typeof e.singleDatePicker&&(this.singleDatePicker=e.singleDatePicker,this.singleDatePicker&&(this.endDate=this.startDate.clone())),\"boolean\"==typeof e.timePicker&&(this.timePicker=e.timePicker),\"boolean\"==typeof e.timePickerSeconds&&(this.timePickerSeconds=e.timePickerSeconds),\"number\"==typeof e.timePickerIncrement&&(this.timePickerIncrement=e.timePickerIncrement),\"boolean\"==typeof e.timePicker24Hour&&(this.timePicker24Hour=e.timePicker24Hour),\"boolean\"==typeof e.autoApply&&(this.autoApply=e.autoApply),\"boolean\"==typeof e.autoUpdateInput&&(this.autoUpdateInput=e.autoUpdateInput),\"boolean\"==typeof e.linkedCalendars&&(this.linkedCalendars=e.linkedCalendars),\"function\"==typeof e.isInvalidDate&&(this.isInvalidDate=e.isInvalidDate),\"function\"==typeof e.isCustomDate&&(this.isCustomDate=e.isCustomDate),\"boolean\"==typeof e.alwaysShowCalendars&&(this.alwaysShowCalendars=e.alwaysShowCalendars),0!=this.locale.firstDay)for(var s=this.locale.firstDay;0<s;)this.locale.daysOfWeek.push(this.locale.daysOfWeek.shift()),s--;var n,r,o;if(void 0===e.startDate&&void 0===e.endDate&&R(this.element).is(\":text\")){var h=R(this.element).val(),l=h.split(this.locale.separator);n=r=null,2==l.length?(n=H(l[0],this.locale.format),r=H(l[1],this.locale.format)):this.singleDatePicker&&\"\"!==h&&(n=H(h,this.locale.format),r=H(h,this.locale.format)),null!==n&&null!==r&&(this.setStartDate(n),this.setEndDate(r))}if(\"object\"==typeof e.ranges){for(o in e.ranges){n=\"string\"==typeof e.ranges[o][0]?H(e.ranges[o][0],this.locale.format):H(e.ranges[o][0]),r=\"string\"==typeof e.ranges[o][1]?H(e.ranges[o][1],this.locale.format):H(e.ranges[o][1]),this.minDate&&n.isBefore(this.minDate)&&(n=this.minDate.clone());var c=this.maxDate;if(this.maxSpan&&c&&n.clone().add(this.maxSpan).isAfter(c)&&(c=n.clone().add(this.maxSpan)),c&&r.isAfter(c)&&(r=c.clone()),!(this.minDate&&r.isBefore(this.minDate,this.timepicker?\"minute\":\"day\")||c&&n.isAfter(c,this.timepicker?\"minute\":\"day\"))){var d;(d=document.createElement(\"textarea\")).innerHTML=o;i=d.value;this.ranges[i]=[n,r]}}var m=\"<ul>\";for(o in this.ranges)m+='<li data-range-key=\"'+o+'\">'+o+\"</li>\";this.showCustomRangeLabel&&(m+='<li data-range-key=\"'+this.locale.customRangeLabel+'\">'+this.locale.customRangeLabel+\"</li>\"),m+=\"</ul>\",this.container.find(\".ranges\").prepend(m)}\"function\"==typeof a&&(this.callback=a),this.timePicker||(this.startDate=this.startDate.startOf(\"day\"),this.endDate=this.endDate.endOf(\"day\"),this.container.find(\".calendar-time\").hide()),this.timePicker&&this.autoApply&&(this.autoApply=!1),this.autoApply&&this.container.addClass(\"auto-apply\"),\"object\"==typeof e.ranges&&this.container.addClass(\"show-ranges\"),this.singleDatePicker&&(this.container.addClass(\"single\"),this.container.find(\".drp-calendar.left\").addClass(\"single\"),this.container.find(\".drp-calendar.left\").show(),this.container.find(\".drp-calendar.right\").hide(),this.timePicker||this.container.addClass(\"auto-apply\")),(void 0===e.ranges&&!this.singleDatePicker||this.alwaysShowCalendars)&&this.container.addClass(\"show-calendar\"),this.container.addClass(\"opens\"+this.opens),this.container.find(\".applyBtn, .cancelBtn\").addClass(this.buttonClasses),this.applyButtonClasses.length&&this.container.find(\".applyBtn\").addClass(this.applyButtonClasses),this.cancelButtonClasses.length&&this.container.find(\".cancelBtn\").addClass(this.cancelButtonClasses),this.container.find(\".applyBtn\").html(this.locale.applyLabel),this.container.find(\".cancelBtn\").html(this.locale.cancelLabel),this.container.find(\".drp-calendar\").on(\"click.daterangepicker\",\".prev\",R.proxy(this.clickPrev,this)).on(\"click.daterangepicker\",\".next\",R.proxy(this.clickNext,this)).on(\"mousedown.daterangepicker\",\"td.available\",R.proxy(this.clickDate,this)).on(\"mouseenter.daterangepicker\",\"td.available\",R.proxy(this.hoverDate,this)).on(\"change.daterangepicker\",\"select.yearselect\",R.proxy(this.monthOrYearChanged,this)).on(\"change.daterangepicker\",\"select.monthselect\",R.proxy(this.monthOrYearChanged,this)).on(\"change.daterangepicker\",\"select.hourselect,select.minuteselect,select.secondselect,select.ampmselect\",R.proxy(this.timeChanged,this)),this.container.find(\".ranges\").on(\"click.daterangepicker\",\"li\",R.proxy(this.clickRange,this)),this.container.find(\".drp-buttons\").on(\"click.daterangepicker\",\"button.applyBtn\",R.proxy(this.clickApply,this)).on(\"click.daterangepicker\",\"button.cancelBtn\",R.proxy(this.clickCancel,this)),this.element.is(\"input\")||this.element.is(\"button\")?this.element.on({\"click.daterangepicker\":R.proxy(this.show,this),\"focus.daterangepicker\":R.proxy(this.show,this),\"keyup.daterangepicker\":R.proxy(this.elementChanged,this),\"keydown.daterangepicker\":R.proxy(this.keydown,this)}):(this.element.on(\"click.daterangepicker\",R.proxy(this.toggle,this)),this.element.on(\"keydown.daterangepicker\",R.proxy(this.toggle,this))),this.updateElement()};return i.prototype={constructor:i,setStartDate:function(t){\"string\"==typeof t&&(this.startDate=H(t,this.locale.format)),\"object\"==typeof t&&(this.startDate=H(t)),this.timePicker||(this.startDate=this.startDate.startOf(\"day\")),this.timePicker&&this.timePickerIncrement&&this.startDate.minute(Math.round(this.startDate.minute()/this.timePickerIncrement)*this.timePickerIncrement),this.minDate&&this.startDate.isBefore(this.minDate)&&(this.startDate=this.minDate.clone(),this.timePicker&&this.timePickerIncrement&&this.startDate.minute(Math.round(this.startDate.minute()/this.timePickerIncrement)*this.timePickerIncrement)),this.maxDate&&this.startDate.isAfter(this.maxDate)&&(this.startDate=this.maxDate.clone(),this.timePicker&&this.timePickerIncrement&&this.startDate.minute(Math.floor(this.startDate.minute()/this.timePickerIncrement)*this.timePickerIncrement)),this.isShowing||this.updateElement(),this.updateMonthsInView()},setEndDate:function(t){\"string\"==typeof t&&(this.endDate=H(t,this.locale.format)),\"object\"==typeof t&&(this.endDate=H(t)),this.timePicker||(this.endDate=this.endDate.add(1,\"d\").startOf(\"day\").subtract(1,\"second\")),this.timePicker&&this.timePickerIncrement&&this.endDate.minute(Math.round(this.endDate.minute()/this.timePickerIncrement)*this.timePickerIncrement),this.endDate.isBefore(this.startDate)&&(this.endDate=this.startDate.clone()),this.maxDate&&this.endDate.isAfter(this.maxDate)&&(this.endDate=this.maxDate.clone()),this.maxSpan&&this.startDate.clone().add(this.maxSpan).isBefore(this.endDate)&&(this.endDate=this.startDate.clone().add(this.maxSpan)),this.previousRightTime=this.endDate.clone(),this.container.find(\".drp-selected\").html(this.startDate.format(this.locale.format)+this.locale.separator+this.endDate.format(this.locale.format)),this.isShowing||this.updateElement(),this.updateMonthsInView()},isInvalidDate:function(){return!1},isCustomDate:function(){return!1},updateView:function(){this.timePicker&&(this.renderTimePicker(\"left\"),this.renderTimePicker(\"right\"),this.endDate?this.container.find(\".right .calendar-time select\").removeAttr(\"disabled\").removeClass(\"disabled\"):this.container.find(\".right .calendar-time select\").attr(\"disabled\",\"disabled\").addClass(\"disabled\")),this.endDate&&this.container.find(\".drp-selected\").html(this.startDate.format(this.locale.format)+this.locale.separator+this.endDate.format(this.locale.format)),this.updateMonthsInView(),this.updateCalendars(),this.updateFormInputs()},updateMonthsInView:function(){if(this.endDate){if(!this.singleDatePicker&&this.leftCalendar.month&&this.rightCalendar.month&&(this.startDate.format(\"YYYY-MM\")==this.leftCalendar.month.format(\"YYYY-MM\")||this.startDate.format(\"YYYY-MM\")==this.rightCalendar.month.format(\"YYYY-MM\"))&&(this.endDate.format(\"YYYY-MM\")==this.leftCalendar.month.format(\"YYYY-MM\")||this.endDate.format(\"YYYY-MM\")==this.rightCalendar.month.format(\"YYYY-MM\")))return;this.leftCalendar.month=this.startDate.clone().date(2),this.linkedCalendars||this.endDate.month()==this.startDate.month()&&this.endDate.year()==this.startDate.year()?this.rightCalendar.month=this.startDate.clone().date(2).add(1,\"month\"):this.rightCalendar.month=this.endDate.clone().date(2)}else this.leftCalendar.month.format(\"YYYY-MM\")!=this.startDate.format(\"YYYY-MM\")&&this.rightCalendar.month.format(\"YYYY-MM\")!=this.startDate.format(\"YYYY-MM\")&&(this.leftCalendar.month=this.startDate.clone().date(2),this.rightCalendar.month=this.startDate.clone().date(2).add(1,\"month\"));this.maxDate&&this.linkedCalendars&&!this.singleDatePicker&&this.rightCalendar.month>this.maxDate&&(this.rightCalendar.month=this.maxDate.clone().date(2),this.leftCalendar.month=this.maxDate.clone().date(2).subtract(1,\"month\"))},updateCalendars:function(){if(this.timePicker){var t,e,a,i;if(this.endDate){if(t=parseInt(this.container.find(\".left .hourselect\").val(),10),e=parseInt(this.container.find(\".left .minuteselect\").val(),10),a=this.timePickerSeconds?parseInt(this.container.find(\".left .secondselect\").val(),10):0,!this.timePicker24Hour)\"PM\"===(i=this.container.find(\".left .ampmselect\").val())&&t<12&&(t+=12),\"AM\"===i&&12===t&&(t=0)}else if(t=parseInt(this.container.find(\".right .hourselect\").val(),10),e=parseInt(this.container.find(\".right .minuteselect\").val(),10),a=this.timePickerSeconds?parseInt(this.container.find(\".right .secondselect\").val(),10):0,!this.timePicker24Hour)\"PM\"===(i=this.container.find(\".right .ampmselect\").val())&&t<12&&(t+=12),\"AM\"===i&&12===t&&(t=0);this.leftCalendar.month.hour(t).minute(e).second(a),this.rightCalendar.month.hour(t).minute(e).second(a)}this.renderCalendar(\"left\"),this.renderCalendar(\"right\"),this.container.find(\".ranges li\").removeClass(\"active\"),null!=this.endDate&&this.calculateChosenLabel()},renderCalendar:function(t){var e,a=(e=\"left\"==t?this.leftCalendar:this.rightCalendar).month.month(),i=e.month.year(),s=e.month.hour(),n=e.month.minute(),r=e.month.second(),o=H([i,a]).daysInMonth(),h=H([i,a,1]),l=H([i,a,o]),c=H(h).subtract(1,\"month\").month(),d=H(h).subtract(1,\"month\").year(),m=H([d,c]).daysInMonth(),f=h.day();(e=[]).firstDay=h,e.lastDay=l;for(var p=0;p<6;p++)e[p]=[];var u=m-f+this.locale.firstDay+1;m<u&&(u-=7),f==this.locale.firstDay&&(u=m-6);for(var D=H([d,c,u,12,n,r]),g=(p=0,0),y=0;p<42;p++,g++,D=H(D).add(24,\"hour\"))0<p&&g%7==0&&(g=0,y++),e[y][g]=D.clone().hour(s).minute(n).second(r),D.hour(12),this.minDate&&e[y][g].format(\"YYYY-MM-DD\")==this.minDate.format(\"YYYY-MM-DD\")&&e[y][g].isBefore(this.minDate)&&\"left\"==t&&(e[y][g]=this.minDate.clone()),this.maxDate&&e[y][g].format(\"YYYY-MM-DD\")==this.maxDate.format(\"YYYY-MM-DD\")&&e[y][g].isAfter(this.maxDate)&&\"right\"==t&&(e[y][g]=this.maxDate.clone());\"left\"==t?this.leftCalendar.calendar=e:this.rightCalendar.calendar=e;var k=\"left\"==t?this.minDate:this.startDate,b=this.maxDate,C=(\"left\"==t?this.startDate:this.endDate,this.locale.direction,'<table class=\"table-condensed\">');C+=\"<thead>\",C+=\"<tr>\",(this.showWeekNumbers||this.showISOWeekNumbers)&&(C+=\"<th></th>\"),k&&!k.isBefore(e.firstDay)||this.linkedCalendars&&\"left\"!=t?C+=\"<th></th>\":C+='<th class=\"prev available\"><span></span></th>';var v=this.locale.monthNames[e[1][1].month()]+e[1][1].format(\" YYYY\");if(this.showDropdowns){for(var Y=e[1][1].month(),w=e[1][1].year(),P=b&&b.year()||this.maxYear,x=k&&k.year()||this.minYear,M=w==x,S=w==P,I='<select class=\"monthselect\">',B=0;B<12;B++)(!M||B>=k.month())&&(!S||B<=b.month())?I+=\"<option value='\"+B+\"'\"+(B===Y?\" selected='selected'\":\"\")+\">\"+this.locale.monthNames[B]+\"</option>\":I+=\"<option value='\"+B+\"'\"+(B===Y?\" selected='selected'\":\"\")+\" disabled='disabled'>\"+this.locale.monthNames[B]+\"</option>\";I+=\"</select>\";for(var A='<select class=\"yearselect\">',L=x;L<=P;L++)A+='<option value=\"'+L+'\"'+(L===w?' selected=\"selected\"':\"\")+\">\"+L+\"</option>\";v=I+(A+=\"</select>\")}if(C+='<th colspan=\"5\" class=\"month\">'+v+\"</th>\",b&&!b.isAfter(e.lastDay)||this.linkedCalendars&&\"right\"!=t&&!this.singleDatePicker?C+=\"<th></th>\":C+='<th class=\"next available\"><span></span></th>',C+=\"</tr>\",C+=\"<tr>\",(this.showWeekNumbers||this.showISOWeekNumbers)&&(C+='<th class=\"week\">'+this.locale.weekLabel+\"</th>\"),R.each(this.locale.daysOfWeek,function(t,e){C+=\"<th>\"+e+\"</th>\"}),C+=\"</tr>\",C+=\"</thead>\",C+=\"<tbody>\",null==this.endDate&&this.maxSpan){var E=this.startDate.clone().add(this.maxSpan).endOf(\"day\");b&&!E.isBefore(b)||(b=E)}for(y=0;y<6;y++){C+=\"<tr>\",this.showWeekNumbers?C+='<td class=\"week\">'+e[y][0].week()+\"</td>\":this.showISOWeekNumbers&&(C+='<td class=\"week\">'+e[y][0].isoWeek()+\"</td>\");for(g=0;g<7;g++){var W=[];e[y][g].isSame(new Date,\"day\")&&W.push(\"today\"),5<e[y][g].isoWeekday()&&W.push(\"weekend\"),e[y][g].month()!=e[1][1].month()&&W.push(\"off\"),this.minDate&&e[y][g].isBefore(this.minDate,\"day\")&&W.push(\"off\",\"disabled\"),b&&e[y][g].isAfter(b,\"day\")&&W.push(\"off\",\"disabled\"),this.isInvalidDate(e[y][g])&&W.push(\"off\",\"disabled\"),e[y][g].format(\"YYYY-MM-DD\")==this.startDate.format(\"YYYY-MM-DD\")&&W.push(\"active\",\"start-date\"),null!=this.endDate&&e[y][g].format(\"YYYY-MM-DD\")==this.endDate.format(\"YYYY-MM-DD\")&&W.push(\"active\",\"end-date\"),null!=this.endDate&&e[y][g]>this.startDate&&e[y][g]<this.endDate&&W.push(\"in-range\");var O=this.isCustomDate(e[y][g]);!1!==O&&(\"string\"==typeof O?W.push(O):Array.prototype.push.apply(W,O));var N=\"\",j=!1;for(p=0;p<W.length;p++)N+=W[p]+\" \",\"disabled\"==W[p]&&(j=!0);j||(N+=\"available\"),C+='<td class=\"'+N.replace(/^\\s+|\\s+$/g,\"\")+'\" data-title=\"r'+y+\"c\"+g+'\">'+e[y][g].date()+\"</td>\"}C+=\"</tr>\"}C+=\"</tbody>\",C+=\"</table>\",this.container.find(\".drp-calendar.\"+t+\" .calendar-table\").html(C)},renderTimePicker:function(t){if(\"right\"!=t||this.endDate){var e,a,i,s=this.maxDate;if(!this.maxSpan||this.maxDate&&!this.startDate.clone().add(this.maxSpan).isAfter(this.maxDate)||(s=this.startDate.clone().add(this.maxSpan)),\"left\"==t)a=this.startDate.clone(),i=this.minDate;else if(\"right\"==t){a=this.endDate.clone(),i=this.startDate;var n=this.container.find(\".drp-calendar.right .calendar-time\");if(\"\"!=n.html()&&(a.hour(a.hour()||n.find(\".hourselect option:selected\").val()),a.minute(a.minute()||n.find(\".minuteselect option:selected\").val()),a.second(a.second()||n.find(\".secondselect option:selected\").val()),!this.timePicker24Hour)){var r=n.find(\".ampmselect option:selected\").val();\"PM\"===r&&a.hour()<12&&a.hour(a.hour()+12),\"AM\"===r&&12===a.hour()&&a.hour(0)}a.isBefore(this.startDate)&&(a=this.startDate.clone()),s&&a.isAfter(s)&&(a=s.clone())}e='<select class=\"hourselect\">';for(var o=this.timePicker24Hour?0:1,h=this.timePicker24Hour?23:12,l=o;l<=h;l++){var c=l;this.timePicker24Hour||(c=12<=a.hour()?12==l?12:l+12:12==l?0:l);var d=a.clone().hour(c),m=!1;i&&d.minute(59).isBefore(i)&&(m=!0),s&&d.minute(0).isAfter(s)&&(m=!0),c!=a.hour()||m?e+=m?'<option value=\"'+l+'\" disabled=\"disabled\" class=\"disabled\">'+l+\"</option>\":'<option value=\"'+l+'\">'+l+\"</option>\":e+='<option value=\"'+l+'\" selected=\"selected\">'+l+\"</option>\"}e+=\"</select> \",e+=': <select class=\"minuteselect\">';for(l=0;l<60;l+=this.timePickerIncrement){var f=l<10?\"0\"+l:l;d=a.clone().minute(l),m=!1;i&&d.second(59).isBefore(i)&&(m=!0),s&&d.second(0).isAfter(s)&&(m=!0),a.minute()!=l||m?e+=m?'<option value=\"'+l+'\" disabled=\"disabled\" class=\"disabled\">'+f+\"</option>\":'<option value=\"'+l+'\">'+f+\"</option>\":e+='<option value=\"'+l+'\" selected=\"selected\">'+f+\"</option>\"}if(e+=\"</select> \",this.timePickerSeconds){e+=': <select class=\"secondselect\">';for(l=0;l<60;l++){f=l<10?\"0\"+l:l,d=a.clone().second(l),m=!1;i&&d.isBefore(i)&&(m=!0),s&&d.isAfter(s)&&(m=!0),a.second()!=l||m?e+=m?'<option value=\"'+l+'\" disabled=\"disabled\" class=\"disabled\">'+f+\"</option>\":'<option value=\"'+l+'\">'+f+\"</option>\":e+='<option value=\"'+l+'\" selected=\"selected\">'+f+\"</option>\"}e+=\"</select> \"}if(!this.timePicker24Hour){e+='<select class=\"ampmselect\">';var p=\"\",u=\"\";i&&a.clone().hour(12).minute(0).second(0).isBefore(i)&&(p=' disabled=\"disabled\" class=\"disabled\"'),s&&a.clone().hour(0).minute(0).second(0).isAfter(s)&&(u=' disabled=\"disabled\" class=\"disabled\"'),12<=a.hour()?e+='<option value=\"AM\"'+p+'>AM</option><option value=\"PM\" selected=\"selected\"'+u+\">PM</option>\":e+='<option value=\"AM\" selected=\"selected\"'+p+'>AM</option><option value=\"PM\"'+u+\">PM</option>\",e+=\"</select>\"}this.container.find(\".drp-calendar.\"+t+\" .calendar-time\").html(e)}},updateFormInputs:function(){this.singleDatePicker||this.endDate&&(this.startDate.isBefore(this.endDate)||this.startDate.isSame(this.endDate))?this.container.find(\"button.applyBtn\").removeAttr(\"disabled\"):this.container.find(\"button.applyBtn\").attr(\"disabled\",\"disabled\")},move:function(){var t,e={top:0,left:0},a=R(window).width();this.parentEl.is(\"body\")||(e={top:this.parentEl.offset().top-this.parentEl.scrollTop(),left:this.parentEl.offset().left-this.parentEl.scrollLeft()},a=this.parentEl[0].clientWidth+this.parentEl.offset().left),t=\"up\"==this.drops?this.element.offset().top-this.container.outerHeight()-e.top:this.element.offset().top+this.element.outerHeight()-e.top,this.container[\"up\"==this.drops?\"addClass\":\"removeClass\"](\"drop-up\"),\"left\"==this.opens?(this.container.css({top:t,right:a-this.element.offset().left-this.element.outerWidth(),left:\"auto\"}),this.container.offset().left<0&&this.container.css({right:\"auto\",left:9})):\"center\"==this.opens?(this.container.css({top:t,left:this.element.offset().left-e.left+this.element.outerWidth()/2-this.container.outerWidth()/2,right:\"auto\"}),this.container.offset().left<0&&this.container.css({right:\"auto\",left:9})):(this.container.css({top:t,left:this.element.offset().left-e.left,right:\"auto\"}),this.container.offset().left+this.container.outerWidth()>R(window).width()&&this.container.css({left:\"auto\",right:0}))},show:function(t){this.isShowing||(this._outsideClickProxy=R.proxy(function(t){this.outsideClick(t)},this),R(document).on(\"mousedown.daterangepicker\",this._outsideClickProxy).on(\"touchend.daterangepicker\",this._outsideClickProxy).on(\"click.daterangepicker\",\"[data-toggle=dropdown]\",this._outsideClickProxy).on(\"focusin.daterangepicker\",this._outsideClickProxy),R(window).on(\"resize.daterangepicker\",R.proxy(function(t){this.move(t)},this)),this.oldStartDate=this.startDate.clone(),this.oldEndDate=this.endDate.clone(),this.previousRightTime=this.endDate.clone(),this.updateView(),this.container.show(),this.move(),this.element.trigger(\"show.daterangepicker\",this),this.isShowing=!0)},hide:function(t){this.isShowing&&(this.endDate||(this.startDate=this.oldStartDate.clone(),this.endDate=this.oldEndDate.clone()),this.startDate.isSame(this.oldStartDate)&&this.endDate.isSame(this.oldEndDate)||this.callback(this.startDate.clone(),this.endDate.clone(),this.chosenLabel),this.updateElement(),R(document).off(\".daterangepicker\"),R(window).off(\".daterangepicker\"),this.container.hide(),this.element.trigger(\"hide.daterangepicker\",this),this.isShowing=!1)},toggle:function(t){this.isShowing?this.hide():this.show()},outsideClick:function(t){var e=R(t.target);\"focusin\"==t.type||e.closest(this.element).length||e.closest(this.container).length||e.closest(\".calendar-table\").length||(this.hide(),this.element.trigger(\"outsideClick.daterangepicker\",this))},showCalendars:function(){this.container.addClass(\"show-calendar\"),this.move(),this.element.trigger(\"showCalendar.daterangepicker\",this)},hideCalendars:function(){this.container.removeClass(\"show-calendar\"),this.element.trigger(\"hideCalendar.daterangepicker\",this)},clickRange:function(t){var e=t.target.getAttribute(\"data-range-key\");if((this.chosenLabel=e)==this.locale.customRangeLabel)this.showCalendars();else{var a=this.ranges[e];this.startDate=a[0],this.endDate=a[1],this.timePicker||(this.startDate.startOf(\"day\"),this.endDate.endOf(\"day\")),this.alwaysShowCalendars||this.hideCalendars(),this.clickApply()}},clickPrev:function(t){R(t.target).parents(\".drp-calendar\").hasClass(\"left\")?(this.leftCalendar.month.subtract(1,\"month\"),this.linkedCalendars&&this.rightCalendar.month.subtract(1,\"month\")):this.rightCalendar.month.subtract(1,\"month\"),this.updateCalendars()},clickNext:function(t){R(t.target).parents(\".drp-calendar\").hasClass(\"left\")?this.leftCalendar.month.add(1,\"month\"):(this.rightCalendar.month.add(1,\"month\"),this.linkedCalendars&&this.leftCalendar.month.add(1,\"month\")),this.updateCalendars()},hoverDate:function(t){if(R(t.target).hasClass(\"available\")){var e=R(t.target).attr(\"data-title\"),a=e.substr(1,1),i=e.substr(3,1),r=R(t.target).parents(\".drp-calendar\").hasClass(\"left\")?this.leftCalendar.calendar[a][i]:this.rightCalendar.calendar[a][i],o=this.leftCalendar,h=this.rightCalendar,l=this.startDate;this.endDate||this.container.find(\".drp-calendar tbody td\").each(function(t,e){if(!R(e).hasClass(\"week\")){var a=R(e).attr(\"data-title\"),i=a.substr(1,1),s=a.substr(3,1),n=R(e).parents(\".drp-calendar\").hasClass(\"left\")?o.calendar[i][s]:h.calendar[i][s];n.isAfter(l)&&n.isBefore(r)||n.isSame(r,\"day\")?R(e).addClass(\"in-range\"):R(e).removeClass(\"in-range\")}})}},clickDate:function(t){if(R(t.target).hasClass(\"available\")){var e=R(t.target).attr(\"data-title\"),a=e.substr(1,1),i=e.substr(3,1),s=R(t.target).parents(\".drp-calendar\").hasClass(\"left\")?this.leftCalendar.calendar[a][i]:this.rightCalendar.calendar[a][i];if(this.endDate||s.isBefore(this.startDate,\"day\")){if(this.timePicker){var n=parseInt(this.container.find(\".left .hourselect\").val(),10);if(!this.timePicker24Hour)\"PM\"===(h=this.container.find(\".left .ampmselect\").val())&&n<12&&(n+=12),\"AM\"===h&&12===n&&(n=0);var r=parseInt(this.container.find(\".left .minuteselect\").val(),10),o=this.timePickerSeconds?parseInt(this.container.find(\".left .secondselect\").val(),10):0;s=s.clone().hour(n).minute(r).second(o)}this.endDate=null,this.setStartDate(s.clone())}else if(!this.endDate&&s.isBefore(this.startDate))this.setEndDate(this.startDate.clone());else{if(this.timePicker){var h;n=parseInt(this.container.find(\".right .hourselect\").val(),10);if(!this.timePicker24Hour)\"PM\"===(h=this.container.find(\".right .ampmselect\").val())&&n<12&&(n+=12),\"AM\"===h&&12===n&&(n=0);r=parseInt(this.container.find(\".right .minuteselect\").val(),10),o=this.timePickerSeconds?parseInt(this.container.find(\".right .secondselect\").val(),10):0;s=s.clone().hour(n).minute(r).second(o)}this.setEndDate(s.clone()),this.autoApply&&(this.calculateChosenLabel(),this.clickApply())}this.singleDatePicker&&(this.setEndDate(this.startDate),this.timePicker||this.clickApply()),this.updateView(),t.stopPropagation()}},calculateChosenLabel:function(){var t=!0,e=0;for(var a in this.ranges){if(this.timePicker){var i=this.timePickerSeconds?\"YYYY-MM-DD hh:mm:ss\":\"YYYY-MM-DD hh:mm\";if(this.startDate.format(i)==this.ranges[a][0].format(i)&&this.endDate.format(i)==this.ranges[a][1].format(i)){t=!1,this.chosenLabel=this.container.find(\".ranges li:eq(\"+e+\")\").addClass(\"active\").attr(\"data-range-key\");break}}else if(this.startDate.format(\"YYYY-MM-DD\")==this.ranges[a][0].format(\"YYYY-MM-DD\")&&this.endDate.format(\"YYYY-MM-DD\")==this.ranges[a][1].format(\"YYYY-MM-DD\")){t=!1,this.chosenLabel=this.container.find(\".ranges li:eq(\"+e+\")\").addClass(\"active\").attr(\"data-range-key\");break}e++}t&&(this.showCustomRangeLabel?this.chosenLabel=this.container.find(\".ranges li:last\").addClass(\"active\").attr(\"data-range-key\"):this.chosenLabel=null,this.showCalendars())},clickApply:function(t){this.hide(),this.element.trigger(\"apply.daterangepicker\",this)},clickCancel:function(t){this.startDate=this.oldStartDate,this.endDate=this.oldEndDate,this.hide(),this.element.trigger(\"cancel.daterangepicker\",this)},monthOrYearChanged:function(t){var e=R(t.target).closest(\".drp-calendar\").hasClass(\"left\"),a=e?\"left\":\"right\",i=this.container.find(\".drp-calendar.\"+a),s=parseInt(i.find(\".monthselect\").val(),10),n=i.find(\".yearselect\").val();e||(n<this.startDate.year()||n==this.startDate.year()&&s<this.startDate.month())&&(s=this.startDate.month(),n=this.startDate.year()),this.minDate&&(n<this.minDate.year()||n==this.minDate.year()&&s<this.minDate.month())&&(s=this.minDate.month(),n=this.minDate.year()),this.maxDate&&(n>this.maxDate.year()||n==this.maxDate.year()&&s>this.maxDate.month())&&(s=this.maxDate.month(),n=this.maxDate.year()),e?(this.leftCalendar.month.month(s).year(n),this.linkedCalendars&&(this.rightCalendar.month=this.leftCalendar.month.clone().add(1,\"month\"))):(this.rightCalendar.month.month(s).year(n),this.linkedCalendars&&(this.leftCalendar.month=this.rightCalendar.month.clone().subtract(1,\"month\"))),this.updateCalendars()},timeChanged:function(t){var e=R(t.target).closest(\".drp-calendar\"),a=e.hasClass(\"left\"),i=parseInt(e.find(\".hourselect\").val(),10),s=parseInt(e.find(\".minuteselect\").val(),10),n=this.timePickerSeconds?parseInt(e.find(\".secondselect\").val(),10):0;if(!this.timePicker24Hour){var r=e.find(\".ampmselect\").val();\"PM\"===r&&i<12&&(i+=12),\"AM\"===r&&12===i&&(i=0)}if(a){var o=this.startDate.clone();o.hour(i),o.minute(s),o.second(n),this.setStartDate(o),this.singleDatePicker?this.endDate=this.startDate.clone():this.endDate&&this.endDate.format(\"YYYY-MM-DD\")==o.format(\"YYYY-MM-DD\")&&this.endDate.isBefore(o)&&this.setEndDate(o.clone())}else if(this.endDate){var h=this.endDate.clone();h.hour(i),h.minute(s),h.second(n),this.setEndDate(h)}this.updateCalendars(),this.updateFormInputs(),this.renderTimePicker(\"left\"),this.renderTimePicker(\"right\")},elementChanged:function(){if(this.element.is(\"input\")&&this.element.val().length){var t=this.element.val().split(this.locale.separator),e=null,a=null;2===t.length&&(e=H(t[0],this.locale.format),a=H(t[1],this.locale.format)),(this.singleDatePicker||null===e||null===a)&&(a=e=H(this.element.val(),this.locale.format)),e.isValid()&&a.isValid()&&(this.setStartDate(e),this.setEndDate(a),this.updateView())}},keydown:function(t){9!==t.keyCode&&13!==t.keyCode||this.hide(),27===t.keyCode&&(t.preventDefault(),t.stopPropagation(),this.hide())},updateElement:function(){if(this.element.is(\"input\")&&this.autoUpdateInput){var t=this.startDate.format(this.locale.format);this.singleDatePicker||(t+=this.locale.separator+this.endDate.format(this.locale.format)),t!==this.element.val()&&this.element.val(t).trigger(\"change\")}},remove:function(){this.container.remove(),this.element.off(\".daterangepicker\"),this.element.removeData()}},R.fn.daterangepicker=function(t,e){var a=R.extend(!0,{},R.fn.daterangepicker.defaultOptions,t);return this.each(function(){var t=R(this);t.data(\"daterangepicker\")&&t.data(\"daterangepicker\").remove(),t.data(\"daterangepicker\",new i(t,a,e))}),this},i});\r\n//# sourceMappingURL=/sm/8cfffddf058dc09b67d92f8d849675e6b459dfb8ede5136cf5c98d10acf78cc3.map","Mageplaza_Reports/js/lib/moment.min.js":"!function(e,t){\"object\"==typeof exports&&\"undefined\"!=typeof module?module.exports=t():\"function\"==typeof define&&define.amd?define(t):e.moment=t()}(this,function(){\"use strict\";var e,i;function c(){return e.apply(null,arguments)}function o(e){return e instanceof Array||\"[object Array]\"===Object.prototype.toString.call(e)}function u(e){return null!=e&&\"[object Object]\"===Object.prototype.toString.call(e)}function l(e){return void 0===e}function d(e){return\"number\"==typeof e||\"[object Number]\"===Object.prototype.toString.call(e)}function h(e){return e instanceof Date||\"[object Date]\"===Object.prototype.toString.call(e)}function f(e,t){var n,s=[];for(n=0;n<e.length;++n)s.push(t(e[n],n));return s}function m(e,t){return Object.prototype.hasOwnProperty.call(e,t)}function _(e,t){for(var n in t)m(t,n)&&(e[n]=t[n]);return m(t,\"toString\")&&(e.toString=t.toString),m(t,\"valueOf\")&&(e.valueOf=t.valueOf),e}function y(e,t,n,s){return Ot(e,t,n,s,!0).utc()}function g(e){return null==e._pf&&(e._pf={empty:!1,unusedTokens:[],unusedInput:[],overflow:-2,charsLeftOver:0,nullInput:!1,invalidMonth:null,invalidFormat:!1,userInvalidated:!1,iso:!1,parsedDateParts:[],meridiem:null,rfc2822:!1,weekdayMismatch:!1}),e._pf}function p(e){if(null==e._isValid){var t=g(e),n=i.call(t.parsedDateParts,function(e){return null!=e}),s=!isNaN(e._d.getTime())&&t.overflow<0&&!t.empty&&!t.invalidMonth&&!t.invalidWeekday&&!t.weekdayMismatch&&!t.nullInput&&!t.invalidFormat&&!t.userInvalidated&&(!t.meridiem||t.meridiem&&n);if(e._strict&&(s=s&&0===t.charsLeftOver&&0===t.unusedTokens.length&&void 0===t.bigHour),null!=Object.isFrozen&&Object.isFrozen(e))return s;e._isValid=s}return e._isValid}function v(e){var t=y(NaN);return null!=e?_(g(t),e):g(t).userInvalidated=!0,t}i=Array.prototype.some?Array.prototype.some:function(e){for(var t=Object(this),n=t.length>>>0,s=0;s<n;s++)if(s in t&&e.call(this,t[s],s,t))return!0;return!1};var r=c.momentProperties=[];function w(e,t){var n,s,i;if(l(t._isAMomentObject)||(e._isAMomentObject=t._isAMomentObject),l(t._i)||(e._i=t._i),l(t._f)||(e._f=t._f),l(t._l)||(e._l=t._l),l(t._strict)||(e._strict=t._strict),l(t._tzm)||(e._tzm=t._tzm),l(t._isUTC)||(e._isUTC=t._isUTC),l(t._offset)||(e._offset=t._offset),l(t._pf)||(e._pf=g(t)),l(t._locale)||(e._locale=t._locale),0<r.length)for(n=0;n<r.length;n++)l(i=t[s=r[n]])||(e[s]=i);return e}var t=!1;function M(e){w(this,e),this._d=new Date(null!=e._d?e._d.getTime():NaN),this.isValid()||(this._d=new Date(NaN)),!1===t&&(t=!0,c.updateOffset(this),t=!1)}function S(e){return e instanceof M||null!=e&&null!=e._isAMomentObject}function D(e){return e<0?Math.ceil(e)||0:Math.floor(e)}function k(e){var t=+e,n=0;return 0!==t&&isFinite(t)&&(n=D(t)),n}function a(e,t,n){var s,i=Math.min(e.length,t.length),r=Math.abs(e.length-t.length),a=0;for(s=0;s<i;s++)(n&&e[s]!==t[s]||!n&&k(e[s])!==k(t[s]))&&a++;return a+r}function Y(e){!1===c.suppressDeprecationWarnings&&\"undefined\"!=typeof console&&console.warn&&console.warn(\"Deprecation warning: \"+e)}function n(i,r){var a=!0;return _(function(){if(null!=c.deprecationHandler&&c.deprecationHandler(null,i),a){for(var e,t=[],n=0;n<arguments.length;n++){if(e=\"\",\"object\"==typeof arguments[n]){for(var s in e+=\"\\n[\"+n+\"] \",arguments[0])e+=s+\": \"+arguments[0][s]+\", \";e=e.slice(0,-2)}else e=arguments[n];t.push(e)}Y(i+\"\\nArguments: \"+Array.prototype.slice.call(t).join(\"\")+\"\\n\"+(new Error).stack),a=!1}return r.apply(this,arguments)},r)}var s,O={};function T(e,t){null!=c.deprecationHandler&&c.deprecationHandler(e,t),O[e]||(Y(t),O[e]=!0)}function x(e){return e instanceof Function||\"[object Function]\"===Object.prototype.toString.call(e)}function b(e,t){var n,s=_({},e);for(n in t)m(t,n)&&(u(e[n])&&u(t[n])?(s[n]={},_(s[n],e[n]),_(s[n],t[n])):null!=t[n]?s[n]=t[n]:delete s[n]);for(n in e)m(e,n)&&!m(t,n)&&u(e[n])&&(s[n]=_({},s[n]));return s}function P(e){null!=e&&this.set(e)}c.suppressDeprecationWarnings=!1,c.deprecationHandler=null,s=Object.keys?Object.keys:function(e){var t,n=[];for(t in e)m(e,t)&&n.push(t);return n};var W={};function H(e,t){var n=e.toLowerCase();W[n]=W[n+\"s\"]=W[t]=e}function R(e){return\"string\"==typeof e?W[e]||W[e.toLowerCase()]:void 0}function C(e){var t,n,s={};for(n in e)m(e,n)&&(t=R(n))&&(s[t]=e[n]);return s}var F={};function L(e,t){F[e]=t}function U(e,t,n){var s=\"\"+Math.abs(e),i=t-s.length;return(0<=e?n?\"+\":\"\":\"-\")+Math.pow(10,Math.max(0,i)).toString().substr(1)+s}var N=/(\\[[^\\[]*\\])|(\\\\)?([Hh]mm(ss)?|Mo|MM?M?M?|Do|DDDo|DD?D?D?|ddd?d?|do?|w[o|w]?|W[o|W]?|Qo?|YYYYYY|YYYYY|YYYY|YY|gg(ggg?)?|GG(GGG?)?|e|E|a|A|hh?|HH?|kk?|mm?|ss?|S{1,9}|x|X|zz?|ZZ?|.)/g,G=/(\\[[^\\[]*\\])|(\\\\)?(LTS|LT|LL?L?L?|l{1,4})/g,V={},E={};function I(e,t,n,s){var i=s;\"string\"==typeof s&&(i=function(){return this[s]()}),e&&(E[e]=i),t&&(E[t[0]]=function(){return U(i.apply(this,arguments),t[1],t[2])}),n&&(E[n]=function(){return this.localeData().ordinal(i.apply(this,arguments),e)})}function A(e,t){return e.isValid()?(t=j(t,e.localeData()),V[t]=V[t]||function(s){var e,i,t,r=s.match(N);for(e=0,i=r.length;e<i;e++)E[r[e]]?r[e]=E[r[e]]:r[e]=(t=r[e]).match(/\\[[\\s\\S]/)?t.replace(/^\\[|\\]$/g,\"\"):t.replace(/\\\\/g,\"\");return function(e){var t,n=\"\";for(t=0;t<i;t++)n+=x(r[t])?r[t].call(e,s):r[t];return n}}(t),V[t](e)):e.localeData().invalidDate()}function j(e,t){var n=5;function s(e){return t.longDateFormat(e)||e}for(G.lastIndex=0;0<=n&&G.test(e);)e=e.replace(G,s),G.lastIndex=0,n-=1;return e}var Z=/\\d/,z=/\\d\\d/,$=/\\d{3}/,q=/\\d{4}/,J=/[+-]?\\d{6}/,B=/\\d\\d?/,Q=/\\d\\d\\d\\d?/,X=/\\d\\d\\d\\d\\d\\d?/,K=/\\d{1,3}/,ee=/\\d{1,4}/,te=/[+-]?\\d{1,6}/,ne=/\\d+/,se=/[+-]?\\d+/,ie=/Z|[+-]\\d\\d:?\\d\\d/gi,re=/Z|[+-]\\d\\d(?::?\\d\\d)?/gi,ae=/[0-9]{0,256}['a-z\\u00A0-\\u05FF\\u0700-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFF07\\uFF10-\\uFFEF]{1,256}|[\\u0600-\\u06FF\\/]{1,256}(\\s*?[\\u0600-\\u06FF]{1,256}){1,2}/i,oe={};function ue(e,n,s){oe[e]=x(n)?n:function(e,t){return e&&s?s:n}}function le(e,t){return m(oe,e)?oe[e](t._strict,t._locale):new RegExp(de(e.replace(\"\\\\\",\"\").replace(/\\\\(\\[)|\\\\(\\])|\\[([^\\]\\[]*)\\]|\\\\(.)/g,function(e,t,n,s,i){return t||n||s||i})))}function de(e){return e.replace(/[-\\/\\\\^$*+?.()|[\\]{}]/g,\"\\\\$&\")}var he={};function ce(e,n){var t,s=n;for(\"string\"==typeof e&&(e=[e]),d(n)&&(s=function(e,t){t[n]=k(e)}),t=0;t<e.length;t++)he[e[t]]=s}function fe(e,i){ce(e,function(e,t,n,s){n._w=n._w||{},i(e,n._w,n,s)})}var me=0,_e=1,ye=2,ge=3,pe=4,ve=5,we=6,Me=7,Se=8;function De(e){return ke(e)?366:365}function ke(e){return e%4==0&&e%100!=0||e%400==0}I(\"Y\",0,0,function(){var e=this.year();return e<=9999?\"\"+e:\"+\"+e}),I(0,[\"YY\",2],0,function(){return this.year()%100}),I(0,[\"YYYY\",4],0,\"year\"),I(0,[\"YYYYY\",5],0,\"year\"),I(0,[\"YYYYYY\",6,!0],0,\"year\"),H(\"year\",\"y\"),L(\"year\",1),ue(\"Y\",se),ue(\"YY\",B,z),ue(\"YYYY\",ee,q),ue(\"YYYYY\",te,J),ue(\"YYYYYY\",te,J),ce([\"YYYYY\",\"YYYYYY\"],me),ce(\"YYYY\",function(e,t){t[me]=2===e.length?c.parseTwoDigitYear(e):k(e)}),ce(\"YY\",function(e,t){t[me]=c.parseTwoDigitYear(e)}),ce(\"Y\",function(e,t){t[me]=parseInt(e,10)}),c.parseTwoDigitYear=function(e){return k(e)+(68<k(e)?1900:2e3)};var Ye,Oe=Te(\"FullYear\",!0);function Te(t,n){return function(e){return null!=e?(be(this,t,e),c.updateOffset(this,n),this):xe(this,t)}}function xe(e,t){return e.isValid()?e._d[\"get\"+(e._isUTC?\"UTC\":\"\")+t]():NaN}function be(e,t,n){e.isValid()&&!isNaN(n)&&(\"FullYear\"===t&&ke(e.year())&&1===e.month()&&29===e.date()?e._d[\"set\"+(e._isUTC?\"UTC\":\"\")+t](n,e.month(),Pe(n,e.month())):e._d[\"set\"+(e._isUTC?\"UTC\":\"\")+t](n))}function Pe(e,t){if(isNaN(e)||isNaN(t))return NaN;var n,s=(t%(n=12)+n)%n;return e+=(t-s)/12,1===s?ke(e)?29:28:31-s%7%2}Ye=Array.prototype.indexOf?Array.prototype.indexOf:function(e){var t;for(t=0;t<this.length;++t)if(this[t]===e)return t;return-1},I(\"M\",[\"MM\",2],\"Mo\",function(){return this.month()+1}),I(\"MMM\",0,0,function(e){return this.localeData().monthsShort(this,e)}),I(\"MMMM\",0,0,function(e){return this.localeData().months(this,e)}),H(\"month\",\"M\"),L(\"month\",8),ue(\"M\",B),ue(\"MM\",B,z),ue(\"MMM\",function(e,t){return t.monthsShortRegex(e)}),ue(\"MMMM\",function(e,t){return t.monthsRegex(e)}),ce([\"M\",\"MM\"],function(e,t){t[_e]=k(e)-1}),ce([\"MMM\",\"MMMM\"],function(e,t,n,s){var i=n._locale.monthsParse(e,s,n._strict);null!=i?t[_e]=i:g(n).invalidMonth=e});var We=/D[oD]?(\\[[^\\[\\]]*\\]|\\s)+MMMM?/,He=\"January_February_March_April_May_June_July_August_September_October_November_December\".split(\"_\");var Re=\"Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec\".split(\"_\");function Ce(e,t){var n;if(!e.isValid())return e;if(\"string\"==typeof t)if(/^\\d+$/.test(t))t=k(t);else if(!d(t=e.localeData().monthsParse(t)))return e;return n=Math.min(e.date(),Pe(e.year(),t)),e._d[\"set\"+(e._isUTC?\"UTC\":\"\")+\"Month\"](t,n),e}function Fe(e){return null!=e?(Ce(this,e),c.updateOffset(this,!0),this):xe(this,\"Month\")}var Le=ae;var Ue=ae;function Ne(){function e(e,t){return t.length-e.length}var t,n,s=[],i=[],r=[];for(t=0;t<12;t++)n=y([2e3,t]),s.push(this.monthsShort(n,\"\")),i.push(this.months(n,\"\")),r.push(this.months(n,\"\")),r.push(this.monthsShort(n,\"\"));for(s.sort(e),i.sort(e),r.sort(e),t=0;t<12;t++)s[t]=de(s[t]),i[t]=de(i[t]);for(t=0;t<24;t++)r[t]=de(r[t]);this._monthsRegex=new RegExp(\"^(\"+r.join(\"|\")+\")\",\"i\"),this._monthsShortRegex=this._monthsRegex,this._monthsStrictRegex=new RegExp(\"^(\"+i.join(\"|\")+\")\",\"i\"),this._monthsShortStrictRegex=new RegExp(\"^(\"+s.join(\"|\")+\")\",\"i\")}function Ge(e){var t=new Date(Date.UTC.apply(null,arguments));return e<100&&0<=e&&isFinite(t.getUTCFullYear())&&t.setUTCFullYear(e),t}function Ve(e,t,n){var s=7+t-n;return-((7+Ge(e,0,s).getUTCDay()-t)%7)+s-1}function Ee(e,t,n,s,i){var r,a,o=1+7*(t-1)+(7+n-s)%7+Ve(e,s,i);return o<=0?a=De(r=e-1)+o:o>De(e)?(r=e+1,a=o-De(e)):(r=e,a=o),{year:r,dayOfYear:a}}function Ie(e,t,n){var s,i,r=Ve(e.year(),t,n),a=Math.floor((e.dayOfYear()-r-1)/7)+1;return a<1?s=a+Ae(i=e.year()-1,t,n):a>Ae(e.year(),t,n)?(s=a-Ae(e.year(),t,n),i=e.year()+1):(i=e.year(),s=a),{week:s,year:i}}function Ae(e,t,n){var s=Ve(e,t,n),i=Ve(e+1,t,n);return(De(e)-s+i)/7}I(\"w\",[\"ww\",2],\"wo\",\"week\"),I(\"W\",[\"WW\",2],\"Wo\",\"isoWeek\"),H(\"week\",\"w\"),H(\"isoWeek\",\"W\"),L(\"week\",5),L(\"isoWeek\",5),ue(\"w\",B),ue(\"ww\",B,z),ue(\"W\",B),ue(\"WW\",B,z),fe([\"w\",\"ww\",\"W\",\"WW\"],function(e,t,n,s){t[s.substr(0,1)]=k(e)});I(\"d\",0,\"do\",\"day\"),I(\"dd\",0,0,function(e){return this.localeData().weekdaysMin(this,e)}),I(\"ddd\",0,0,function(e){return this.localeData().weekdaysShort(this,e)}),I(\"dddd\",0,0,function(e){return this.localeData().weekdays(this,e)}),I(\"e\",0,0,\"weekday\"),I(\"E\",0,0,\"isoWeekday\"),H(\"day\",\"d\"),H(\"weekday\",\"e\"),H(\"isoWeekday\",\"E\"),L(\"day\",11),L(\"weekday\",11),L(\"isoWeekday\",11),ue(\"d\",B),ue(\"e\",B),ue(\"E\",B),ue(\"dd\",function(e,t){return t.weekdaysMinRegex(e)}),ue(\"ddd\",function(e,t){return t.weekdaysShortRegex(e)}),ue(\"dddd\",function(e,t){return t.weekdaysRegex(e)}),fe([\"dd\",\"ddd\",\"dddd\"],function(e,t,n,s){var i=n._locale.weekdaysParse(e,s,n._strict);null!=i?t.d=i:g(n).invalidWeekday=e}),fe([\"d\",\"e\",\"E\"],function(e,t,n,s){t[s]=k(e)});var je=\"Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday\".split(\"_\");var Ze=\"Sun_Mon_Tue_Wed_Thu_Fri_Sat\".split(\"_\");var ze=\"Su_Mo_Tu_We_Th_Fr_Sa\".split(\"_\");var $e=ae;var qe=ae;var Je=ae;function Be(){function e(e,t){return t.length-e.length}var t,n,s,i,r,a=[],o=[],u=[],l=[];for(t=0;t<7;t++)n=y([2e3,1]).day(t),s=this.weekdaysMin(n,\"\"),i=this.weekdaysShort(n,\"\"),r=this.weekdays(n,\"\"),a.push(s),o.push(i),u.push(r),l.push(s),l.push(i),l.push(r);for(a.sort(e),o.sort(e),u.sort(e),l.sort(e),t=0;t<7;t++)o[t]=de(o[t]),u[t]=de(u[t]),l[t]=de(l[t]);this._weekdaysRegex=new RegExp(\"^(\"+l.join(\"|\")+\")\",\"i\"),this._weekdaysShortRegex=this._weekdaysRegex,this._weekdaysMinRegex=this._weekdaysRegex,this._weekdaysStrictRegex=new RegExp(\"^(\"+u.join(\"|\")+\")\",\"i\"),this._weekdaysShortStrictRegex=new RegExp(\"^(\"+o.join(\"|\")+\")\",\"i\"),this._weekdaysMinStrictRegex=new RegExp(\"^(\"+a.join(\"|\")+\")\",\"i\")}function Qe(){return this.hours()%12||12}function Xe(e,t){I(e,0,0,function(){return this.localeData().meridiem(this.hours(),this.minutes(),t)})}function Ke(e,t){return t._meridiemParse}I(\"H\",[\"HH\",2],0,\"hour\"),I(\"h\",[\"hh\",2],0,Qe),I(\"k\",[\"kk\",2],0,function(){return this.hours()||24}),I(\"hmm\",0,0,function(){return\"\"+Qe.apply(this)+U(this.minutes(),2)}),I(\"hmmss\",0,0,function(){return\"\"+Qe.apply(this)+U(this.minutes(),2)+U(this.seconds(),2)}),I(\"Hmm\",0,0,function(){return\"\"+this.hours()+U(this.minutes(),2)}),I(\"Hmmss\",0,0,function(){return\"\"+this.hours()+U(this.minutes(),2)+U(this.seconds(),2)}),Xe(\"a\",!0),Xe(\"A\",!1),H(\"hour\",\"h\"),L(\"hour\",13),ue(\"a\",Ke),ue(\"A\",Ke),ue(\"H\",B),ue(\"h\",B),ue(\"k\",B),ue(\"HH\",B,z),ue(\"hh\",B,z),ue(\"kk\",B,z),ue(\"hmm\",Q),ue(\"hmmss\",X),ue(\"Hmm\",Q),ue(\"Hmmss\",X),ce([\"H\",\"HH\"],ge),ce([\"k\",\"kk\"],function(e,t,n){var s=k(e);t[ge]=24===s?0:s}),ce([\"a\",\"A\"],function(e,t,n){n._isPm=n._locale.isPM(e),n._meridiem=e}),ce([\"h\",\"hh\"],function(e,t,n){t[ge]=k(e),g(n).bigHour=!0}),ce(\"hmm\",function(e,t,n){var s=e.length-2;t[ge]=k(e.substr(0,s)),t[pe]=k(e.substr(s)),g(n).bigHour=!0}),ce(\"hmmss\",function(e,t,n){var s=e.length-4,i=e.length-2;t[ge]=k(e.substr(0,s)),t[pe]=k(e.substr(s,2)),t[ve]=k(e.substr(i)),g(n).bigHour=!0}),ce(\"Hmm\",function(e,t,n){var s=e.length-2;t[ge]=k(e.substr(0,s)),t[pe]=k(e.substr(s))}),ce(\"Hmmss\",function(e,t,n){var s=e.length-4,i=e.length-2;t[ge]=k(e.substr(0,s)),t[pe]=k(e.substr(s,2)),t[ve]=k(e.substr(i))});var et,tt=Te(\"Hours\",!0),nt={calendar:{sameDay:\"[Today at] LT\",nextDay:\"[Tomorrow at] LT\",nextWeek:\"dddd [at] LT\",lastDay:\"[Yesterday at] LT\",lastWeek:\"[Last] dddd [at] LT\",sameElse:\"L\"},longDateFormat:{LTS:\"h:mm:ss A\",LT:\"h:mm A\",L:\"MM/DD/YYYY\",LL:\"MMMM D, YYYY\",LLL:\"MMMM D, YYYY h:mm A\",LLLL:\"dddd, MMMM D, YYYY h:mm A\"},invalidDate:\"Invalid date\",ordinal:\"%d\",dayOfMonthOrdinalParse:/\\d{1,2}/,relativeTime:{future:\"in %s\",past:\"%s ago\",s:\"a few seconds\",ss:\"%d seconds\",m:\"a minute\",mm:\"%d minutes\",h:\"an hour\",hh:\"%d hours\",d:\"a day\",dd:\"%d days\",M:\"a month\",MM:\"%d months\",y:\"a year\",yy:\"%d years\"},months:He,monthsShort:Re,week:{dow:0,doy:6},weekdays:je,weekdaysMin:ze,weekdaysShort:Ze,meridiemParse:/[ap]\\.?m?\\.?/i},st={},it={};function rt(e){return e?e.toLowerCase().replace(\"_\",\"-\"):e}function at(e){var t=null;if(!st[e]&&\"undefined\"!=typeof module&&module&&module.exports)try{t=et._abbr,require(\"./locale/\"+e),ot(t)}catch(e){}return st[e]}function ot(e,t){var n;return e&&((n=l(t)?lt(e):ut(e,t))?et=n:\"undefined\"!=typeof console&&console.warn&&console.warn(\"Locale \"+e+\" not found. Did you forget to load it?\")),et._abbr}function ut(e,t){if(null!==t){var n,s=nt;if(t.abbr=e,null!=st[e])T(\"defineLocaleOverride\",\"use moment.updateLocale(localeName, config) to change an existing locale. moment.defineLocale(localeName, config) should only be used for creating a new locale See http://momentjs.com/guides/#/warnings/define-locale/ for more info.\"),s=st[e]._config;else if(null!=t.parentLocale)if(null!=st[t.parentLocale])s=st[t.parentLocale]._config;else{if(null==(n=at(t.parentLocale)))return it[t.parentLocale]||(it[t.parentLocale]=[]),it[t.parentLocale].push({name:e,config:t}),null;s=n._config}return st[e]=new P(b(s,t)),it[e]&&it[e].forEach(function(e){ut(e.name,e.config)}),ot(e),st[e]}return delete st[e],null}function lt(e){var t;if(e&&e._locale&&e._locale._abbr&&(e=e._locale._abbr),!e)return et;if(!o(e)){if(t=at(e))return t;e=[e]}return function(e){for(var t,n,s,i,r=0;r<e.length;){for(t=(i=rt(e[r]).split(\"-\")).length,n=(n=rt(e[r+1]))?n.split(\"-\"):null;0<t;){if(s=at(i.slice(0,t).join(\"-\")))return s;if(n&&n.length>=t&&a(i,n,!0)>=t-1)break;t--}r++}return et}(e)}function dt(e){var t,n=e._a;return n&&-2===g(e).overflow&&(t=n[_e]<0||11<n[_e]?_e:n[ye]<1||n[ye]>Pe(n[me],n[_e])?ye:n[ge]<0||24<n[ge]||24===n[ge]&&(0!==n[pe]||0!==n[ve]||0!==n[we])?ge:n[pe]<0||59<n[pe]?pe:n[ve]<0||59<n[ve]?ve:n[we]<0||999<n[we]?we:-1,g(e)._overflowDayOfYear&&(t<me||ye<t)&&(t=ye),g(e)._overflowWeeks&&-1===t&&(t=Me),g(e)._overflowWeekday&&-1===t&&(t=Se),g(e).overflow=t),e}function ht(e,t,n){return null!=e?e:null!=t?t:n}function ct(e){var t,n,s,i,r,a=[];if(!e._d){var o,u;for(o=e,u=new Date(c.now()),s=o._useUTC?[u.getUTCFullYear(),u.getUTCMonth(),u.getUTCDate()]:[u.getFullYear(),u.getMonth(),u.getDate()],e._w&&null==e._a[ye]&&null==e._a[_e]&&function(e){var t,n,s,i,r,a,o,u;if(null!=(t=e._w).GG||null!=t.W||null!=t.E)r=1,a=4,n=ht(t.GG,e._a[me],Ie(Tt(),1,4).year),s=ht(t.W,1),((i=ht(t.E,1))<1||7<i)&&(u=!0);else{r=e._locale._week.dow,a=e._locale._week.doy;var l=Ie(Tt(),r,a);n=ht(t.gg,e._a[me],l.year),s=ht(t.w,l.week),null!=t.d?((i=t.d)<0||6<i)&&(u=!0):null!=t.e?(i=t.e+r,(t.e<0||6<t.e)&&(u=!0)):i=r}s<1||s>Ae(n,r,a)?g(e)._overflowWeeks=!0:null!=u?g(e)._overflowWeekday=!0:(o=Ee(n,s,i,r,a),e._a[me]=o.year,e._dayOfYear=o.dayOfYear)}(e),null!=e._dayOfYear&&(r=ht(e._a[me],s[me]),(e._dayOfYear>De(r)||0===e._dayOfYear)&&(g(e)._overflowDayOfYear=!0),n=Ge(r,0,e._dayOfYear),e._a[_e]=n.getUTCMonth(),e._a[ye]=n.getUTCDate()),t=0;t<3&&null==e._a[t];++t)e._a[t]=a[t]=s[t];for(;t<7;t++)e._a[t]=a[t]=null==e._a[t]?2===t?1:0:e._a[t];24===e._a[ge]&&0===e._a[pe]&&0===e._a[ve]&&0===e._a[we]&&(e._nextDay=!0,e._a[ge]=0),e._d=(e._useUTC?Ge:function(e,t,n,s,i,r,a){var o=new Date(e,t,n,s,i,r,a);return e<100&&0<=e&&isFinite(o.getFullYear())&&o.setFullYear(e),o}).apply(null,a),i=e._useUTC?e._d.getUTCDay():e._d.getDay(),null!=e._tzm&&e._d.setUTCMinutes(e._d.getUTCMinutes()-e._tzm),e._nextDay&&(e._a[ge]=24),e._w&&void 0!==e._w.d&&e._w.d!==i&&(g(e).weekdayMismatch=!0)}}var ft=/^\\s*((?:[+-]\\d{6}|\\d{4})-(?:\\d\\d-\\d\\d|W\\d\\d-\\d|W\\d\\d|\\d\\d\\d|\\d\\d))(?:(T| )(\\d\\d(?::\\d\\d(?::\\d\\d(?:[.,]\\d+)?)?)?)([\\+\\-]\\d\\d(?::?\\d\\d)?|\\s*Z)?)?$/,mt=/^\\s*((?:[+-]\\d{6}|\\d{4})(?:\\d\\d\\d\\d|W\\d\\d\\d|W\\d\\d|\\d\\d\\d|\\d\\d))(?:(T| )(\\d\\d(?:\\d\\d(?:\\d\\d(?:[.,]\\d+)?)?)?)([\\+\\-]\\d\\d(?::?\\d\\d)?|\\s*Z)?)?$/,_t=/Z|[+-]\\d\\d(?::?\\d\\d)?/,yt=[[\"YYYYYY-MM-DD\",/[+-]\\d{6}-\\d\\d-\\d\\d/],[\"YYYY-MM-DD\",/\\d{4}-\\d\\d-\\d\\d/],[\"GGGG-[W]WW-E\",/\\d{4}-W\\d\\d-\\d/],[\"GGGG-[W]WW\",/\\d{4}-W\\d\\d/,!1],[\"YYYY-DDD\",/\\d{4}-\\d{3}/],[\"YYYY-MM\",/\\d{4}-\\d\\d/,!1],[\"YYYYYYMMDD\",/[+-]\\d{10}/],[\"YYYYMMDD\",/\\d{8}/],[\"GGGG[W]WWE\",/\\d{4}W\\d{3}/],[\"GGGG[W]WW\",/\\d{4}W\\d{2}/,!1],[\"YYYYDDD\",/\\d{7}/]],gt=[[\"HH:mm:ss.SSSS\",/\\d\\d:\\d\\d:\\d\\d\\.\\d+/],[\"HH:mm:ss,SSSS\",/\\d\\d:\\d\\d:\\d\\d,\\d+/],[\"HH:mm:ss\",/\\d\\d:\\d\\d:\\d\\d/],[\"HH:mm\",/\\d\\d:\\d\\d/],[\"HHmmss.SSSS\",/\\d\\d\\d\\d\\d\\d\\.\\d+/],[\"HHmmss,SSSS\",/\\d\\d\\d\\d\\d\\d,\\d+/],[\"HHmmss\",/\\d\\d\\d\\d\\d\\d/],[\"HHmm\",/\\d\\d\\d\\d/],[\"HH\",/\\d\\d/]],pt=/^\\/?Date\\((\\-?\\d+)/i;function vt(e){var t,n,s,i,r,a,o=e._i,u=ft.exec(o)||mt.exec(o);if(u){for(g(e).iso=!0,t=0,n=yt.length;t<n;t++)if(yt[t][1].exec(u[1])){i=yt[t][0],s=!1!==yt[t][2];break}if(null==i)return void(e._isValid=!1);if(u[3]){for(t=0,n=gt.length;t<n;t++)if(gt[t][1].exec(u[3])){r=(u[2]||\" \")+gt[t][0];break}if(null==r)return void(e._isValid=!1)}if(!s&&null!=r)return void(e._isValid=!1);if(u[4]){if(!_t.exec(u[4]))return void(e._isValid=!1);a=\"Z\"}e._f=i+(r||\"\")+(a||\"\"),kt(e)}else e._isValid=!1}var wt=/^(?:(Mon|Tue|Wed|Thu|Fri|Sat|Sun),?\\s)?(\\d{1,2})\\s(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\\s(\\d{2,4})\\s(\\d\\d):(\\d\\d)(?::(\\d\\d))?\\s(?:(UT|GMT|[ECMP][SD]T)|([Zz])|([+-]\\d{4}))$/;function Mt(e,t,n,s,i,r){var a=[function(e){var t=parseInt(e,10);{if(t<=49)return 2e3+t;if(t<=999)return 1900+t}return t}(e),Re.indexOf(t),parseInt(n,10),parseInt(s,10),parseInt(i,10)];return r&&a.push(parseInt(r,10)),a}var St={UT:0,GMT:0,EDT:-240,EST:-300,CDT:-300,CST:-360,MDT:-360,MST:-420,PDT:-420,PST:-480};function Dt(e){var t,n,s,i=wt.exec(e._i.replace(/\\([^)]*\\)|[\\n\\t]/g,\" \").replace(/(\\s\\s+)/g,\" \").replace(/^\\s\\s*/,\"\").replace(/\\s\\s*$/,\"\"));if(i){var r=Mt(i[4],i[3],i[2],i[5],i[6],i[7]);if(t=i[1],n=r,s=e,t&&Ze.indexOf(t)!==new Date(n[0],n[1],n[2]).getDay()&&(g(s).weekdayMismatch=!0,!(s._isValid=!1)))return;e._a=r,e._tzm=function(e,t,n){if(e)return St[e];if(t)return 0;var s=parseInt(n,10),i=s%100;return(s-i)/100*60+i}(i[8],i[9],i[10]),e._d=Ge.apply(null,e._a),e._d.setUTCMinutes(e._d.getUTCMinutes()-e._tzm),g(e).rfc2822=!0}else e._isValid=!1}function kt(e){if(e._f!==c.ISO_8601)if(e._f!==c.RFC_2822){e._a=[],g(e).empty=!0;var t,n,s,i,r,a,o,u,l=\"\"+e._i,d=l.length,h=0;for(s=j(e._f,e._locale).match(N)||[],t=0;t<s.length;t++)i=s[t],(n=(l.match(le(i,e))||[])[0])&&(0<(r=l.substr(0,l.indexOf(n))).length&&g(e).unusedInput.push(r),l=l.slice(l.indexOf(n)+n.length),h+=n.length),E[i]?(n?g(e).empty=!1:g(e).unusedTokens.push(i),a=i,u=e,null!=(o=n)&&m(he,a)&&he[a](o,u._a,u,a)):e._strict&&!n&&g(e).unusedTokens.push(i);g(e).charsLeftOver=d-h,0<l.length&&g(e).unusedInput.push(l),e._a[ge]<=12&&!0===g(e).bigHour&&0<e._a[ge]&&(g(e).bigHour=void 0),g(e).parsedDateParts=e._a.slice(0),g(e).meridiem=e._meridiem,e._a[ge]=function(e,t,n){var s;if(null==n)return t;return null!=e.meridiemHour?e.meridiemHour(t,n):(null!=e.isPM&&((s=e.isPM(n))&&t<12&&(t+=12),s||12!==t||(t=0)),t)}(e._locale,e._a[ge],e._meridiem),ct(e),dt(e)}else Dt(e);else vt(e)}function Yt(e){var t,n,s,i,r=e._i,a=e._f;return e._locale=e._locale||lt(e._l),null===r||void 0===a&&\"\"===r?v({nullInput:!0}):(\"string\"==typeof r&&(e._i=r=e._locale.preparse(r)),S(r)?new M(dt(r)):(h(r)?e._d=r:o(a)?function(e){var t,n,s,i,r;if(0===e._f.length)return g(e).invalidFormat=!0,e._d=new Date(NaN);for(i=0;i<e._f.length;i++)r=0,t=w({},e),null!=e._useUTC&&(t._useUTC=e._useUTC),t._f=e._f[i],kt(t),p(t)&&(r+=g(t).charsLeftOver,r+=10*g(t).unusedTokens.length,g(t).score=r,(null==s||r<s)&&(s=r,n=t));_(e,n||t)}(e):a?kt(e):l(n=(t=e)._i)?t._d=new Date(c.now()):h(n)?t._d=new Date(n.valueOf()):\"string\"==typeof n?(s=t,null===(i=pt.exec(s._i))?(vt(s),!1===s._isValid&&(delete s._isValid,Dt(s),!1===s._isValid&&(delete s._isValid,c.createFromInputFallback(s)))):s._d=new Date(+i[1])):o(n)?(t._a=f(n.slice(0),function(e){return parseInt(e,10)}),ct(t)):u(n)?function(e){if(!e._d){var t=C(e._i);e._a=f([t.year,t.month,t.day||t.date,t.hour,t.minute,t.second,t.millisecond],function(e){return e&&parseInt(e,10)}),ct(e)}}(t):d(n)?t._d=new Date(n):c.createFromInputFallback(t),p(e)||(e._d=null),e))}function Ot(e,t,n,s,i){var r,a={};return!0!==n&&!1!==n||(s=n,n=void 0),(u(e)&&function(e){if(Object.getOwnPropertyNames)return 0===Object.getOwnPropertyNames(e).length;var t;for(t in e)if(e.hasOwnProperty(t))return!1;return!0}(e)||o(e)&&0===e.length)&&(e=void 0),a._isAMomentObject=!0,a._useUTC=a._isUTC=i,a._l=n,a._i=e,a._f=t,a._strict=s,(r=new M(dt(Yt(a))))._nextDay&&(r.add(1,\"d\"),r._nextDay=void 0),r}function Tt(e,t,n,s){return Ot(e,t,n,s,!1)}c.createFromInputFallback=n(\"value provided is not in a recognized RFC2822 or ISO format. moment construction falls back to js Date(), which is not reliable across all browsers and versions. Non RFC2822/ISO date formats are discouraged and will be removed in an upcoming major release. Please refer to http://momentjs.com/guides/#/warnings/js-date/ for more info.\",function(e){e._d=new Date(e._i+(e._useUTC?\" UTC\":\"\"))}),c.ISO_8601=function(){},c.RFC_2822=function(){};var xt=n(\"moment().min is deprecated, use moment.max instead. http://momentjs.com/guides/#/warnings/min-max/\",function(){var e=Tt.apply(null,arguments);return this.isValid()&&e.isValid()?e<this?this:e:v()}),bt=n(\"moment().max is deprecated, use moment.min instead. http://momentjs.com/guides/#/warnings/min-max/\",function(){var e=Tt.apply(null,arguments);return this.isValid()&&e.isValid()?this<e?this:e:v()});function Pt(e,t){var n,s;if(1===t.length&&o(t[0])&&(t=t[0]),!t.length)return Tt();for(n=t[0],s=1;s<t.length;++s)t[s].isValid()&&!t[s][e](n)||(n=t[s]);return n}var Wt=[\"year\",\"quarter\",\"month\",\"week\",\"day\",\"hour\",\"minute\",\"second\",\"millisecond\"];function Ht(e){var t=C(e),n=t.year||0,s=t.quarter||0,i=t.month||0,r=t.week||0,a=t.day||0,o=t.hour||0,u=t.minute||0,l=t.second||0,d=t.millisecond||0;this._isValid=function(e){for(var t in e)if(-1===Ye.call(Wt,t)||null!=e[t]&&isNaN(e[t]))return!1;for(var n=!1,s=0;s<Wt.length;++s)if(e[Wt[s]]){if(n)return!1;parseFloat(e[Wt[s]])!==k(e[Wt[s]])&&(n=!0)}return!0}(t),this._milliseconds=+d+1e3*l+6e4*u+1e3*o*60*60,this._days=+a+7*r,this._months=+i+3*s+12*n,this._data={},this._locale=lt(),this._bubble()}function Rt(e){return e instanceof Ht}function Ct(e){return e<0?-1*Math.round(-1*e):Math.round(e)}function Ft(e,n){I(e,0,0,function(){var e=this.utcOffset(),t=\"+\";return e<0&&(e=-e,t=\"-\"),t+U(~~(e/60),2)+n+U(~~e%60,2)})}Ft(\"Z\",\":\"),Ft(\"ZZ\",\"\"),ue(\"Z\",re),ue(\"ZZ\",re),ce([\"Z\",\"ZZ\"],function(e,t,n){n._useUTC=!0,n._tzm=Ut(re,e)});var Lt=/([\\+\\-]|\\d\\d)/gi;function Ut(e,t){var n=(t||\"\").match(e);if(null===n)return null;var s=((n[n.length-1]||[])+\"\").match(Lt)||[\"-\",0,0],i=60*s[1]+k(s[2]);return 0===i?0:\"+\"===s[0]?i:-i}function Nt(e,t){var n,s;return t._isUTC?(n=t.clone(),s=(S(e)||h(e)?e.valueOf():Tt(e).valueOf())-n.valueOf(),n._d.setTime(n._d.valueOf()+s),c.updateOffset(n,!1),n):Tt(e).local()}function Gt(e){return 15*-Math.round(e._d.getTimezoneOffset()/15)}function Vt(){return!!this.isValid()&&(this._isUTC&&0===this._offset)}c.updateOffset=function(){};var Et=/^(\\-|\\+)?(?:(\\d*)[. ])?(\\d+)\\:(\\d+)(?:\\:(\\d+)(\\.\\d*)?)?$/,It=/^(-|\\+)?P(?:([-+]?[0-9,.]*)Y)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)W)?(?:([-+]?[0-9,.]*)D)?(?:T(?:([-+]?[0-9,.]*)H)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)S)?)?$/;function At(e,t){var n,s,i,r=e,a=null;return Rt(e)?r={ms:e._milliseconds,d:e._days,M:e._months}:d(e)?(r={},t?r[t]=e:r.milliseconds=e):(a=Et.exec(e))?(n=\"-\"===a[1]?-1:1,r={y:0,d:k(a[ye])*n,h:k(a[ge])*n,m:k(a[pe])*n,s:k(a[ve])*n,ms:k(Ct(1e3*a[we]))*n}):(a=It.exec(e))?(n=\"-\"===a[1]?-1:(a[1],1),r={y:jt(a[2],n),M:jt(a[3],n),w:jt(a[4],n),d:jt(a[5],n),h:jt(a[6],n),m:jt(a[7],n),s:jt(a[8],n)}):null==r?r={}:\"object\"==typeof r&&(\"from\"in r||\"to\"in r)&&(i=function(e,t){var n;if(!e.isValid()||!t.isValid())return{milliseconds:0,months:0};t=Nt(t,e),e.isBefore(t)?n=Zt(e,t):((n=Zt(t,e)).milliseconds=-n.milliseconds,n.months=-n.months);return n}(Tt(r.from),Tt(r.to)),(r={}).ms=i.milliseconds,r.M=i.months),s=new Ht(r),Rt(e)&&m(e,\"_locale\")&&(s._locale=e._locale),s}function jt(e,t){var n=e&&parseFloat(e.replace(\",\",\".\"));return(isNaN(n)?0:n)*t}function Zt(e,t){var n={milliseconds:0,months:0};return n.months=t.month()-e.month()+12*(t.year()-e.year()),e.clone().add(n.months,\"M\").isAfter(t)&&--n.months,n.milliseconds=+t-+e.clone().add(n.months,\"M\"),n}function zt(s,i){return function(e,t){var n;return null===t||isNaN(+t)||(T(i,\"moment().\"+i+\"(period, number) is deprecated. Please use moment().\"+i+\"(number, period). See http://momentjs.com/guides/#/warnings/add-inverted-param/ for more info.\"),n=e,e=t,t=n),$t(this,At(e=\"string\"==typeof e?+e:e,t),s),this}}function $t(e,t,n,s){var i=t._milliseconds,r=Ct(t._days),a=Ct(t._months);e.isValid()&&(s=null==s||s,a&&Ce(e,xe(e,\"Month\")+a*n),r&&be(e,\"Date\",xe(e,\"Date\")+r*n),i&&e._d.setTime(e._d.valueOf()+i*n),s&&c.updateOffset(e,r||a))}At.fn=Ht.prototype,At.invalid=function(){return At(NaN)};var qt=zt(1,\"add\"),Jt=zt(-1,\"subtract\");function Bt(e,t){var n=12*(t.year()-e.year())+(t.month()-e.month()),s=e.clone().add(n,\"months\");return-(n+(t-s<0?(t-s)/(s-e.clone().add(n-1,\"months\")):(t-s)/(e.clone().add(n+1,\"months\")-s)))||0}function Qt(e){var t;return void 0===e?this._locale._abbr:(null!=(t=lt(e))&&(this._locale=t),this)}c.defaultFormat=\"YYYY-MM-DDTHH:mm:ssZ\",c.defaultFormatUtc=\"YYYY-MM-DDTHH:mm:ss[Z]\";var Xt=n(\"moment().lang() is deprecated. Instead, use moment().localeData() to get the language configuration. Use moment().locale() to change languages.\",function(e){return void 0===e?this.localeData():this.locale(e)});function Kt(){return this._locale}function en(e,t){I(0,[e,e.length],0,t)}function tn(e,t,n,s,i){var r;return null==e?Ie(this,s,i).year:((r=Ae(e,s,i))<t&&(t=r),function(e,t,n,s,i){var r=Ee(e,t,n,s,i),a=Ge(r.year,0,r.dayOfYear);return this.year(a.getUTCFullYear()),this.month(a.getUTCMonth()),this.date(a.getUTCDate()),this}.call(this,e,t,n,s,i))}I(0,[\"gg\",2],0,function(){return this.weekYear()%100}),I(0,[\"GG\",2],0,function(){return this.isoWeekYear()%100}),en(\"gggg\",\"weekYear\"),en(\"ggggg\",\"weekYear\"),en(\"GGGG\",\"isoWeekYear\"),en(\"GGGGG\",\"isoWeekYear\"),H(\"weekYear\",\"gg\"),H(\"isoWeekYear\",\"GG\"),L(\"weekYear\",1),L(\"isoWeekYear\",1),ue(\"G\",se),ue(\"g\",se),ue(\"GG\",B,z),ue(\"gg\",B,z),ue(\"GGGG\",ee,q),ue(\"gggg\",ee,q),ue(\"GGGGG\",te,J),ue(\"ggggg\",te,J),fe([\"gggg\",\"ggggg\",\"GGGG\",\"GGGGG\"],function(e,t,n,s){t[s.substr(0,2)]=k(e)}),fe([\"gg\",\"GG\"],function(e,t,n,s){t[s]=c.parseTwoDigitYear(e)}),I(\"Q\",0,\"Qo\",\"quarter\"),H(\"quarter\",\"Q\"),L(\"quarter\",7),ue(\"Q\",Z),ce(\"Q\",function(e,t){t[_e]=3*(k(e)-1)}),I(\"D\",[\"DD\",2],\"Do\",\"date\"),H(\"date\",\"D\"),L(\"date\",9),ue(\"D\",B),ue(\"DD\",B,z),ue(\"Do\",function(e,t){return e?t._dayOfMonthOrdinalParse||t._ordinalParse:t._dayOfMonthOrdinalParseLenient}),ce([\"D\",\"DD\"],ye),ce(\"Do\",function(e,t){t[ye]=k(e.match(B)[0])});var nn=Te(\"Date\",!0);I(\"DDD\",[\"DDDD\",3],\"DDDo\",\"dayOfYear\"),H(\"dayOfYear\",\"DDD\"),L(\"dayOfYear\",4),ue(\"DDD\",K),ue(\"DDDD\",$),ce([\"DDD\",\"DDDD\"],function(e,t,n){n._dayOfYear=k(e)}),I(\"m\",[\"mm\",2],0,\"minute\"),H(\"minute\",\"m\"),L(\"minute\",14),ue(\"m\",B),ue(\"mm\",B,z),ce([\"m\",\"mm\"],pe);var sn=Te(\"Minutes\",!1);I(\"s\",[\"ss\",2],0,\"second\"),H(\"second\",\"s\"),L(\"second\",15),ue(\"s\",B),ue(\"ss\",B,z),ce([\"s\",\"ss\"],ve);var rn,an=Te(\"Seconds\",!1);for(I(\"S\",0,0,function(){return~~(this.millisecond()/100)}),I(0,[\"SS\",2],0,function(){return~~(this.millisecond()/10)}),I(0,[\"SSS\",3],0,\"millisecond\"),I(0,[\"SSSS\",4],0,function(){return 10*this.millisecond()}),I(0,[\"SSSSS\",5],0,function(){return 100*this.millisecond()}),I(0,[\"SSSSSS\",6],0,function(){return 1e3*this.millisecond()}),I(0,[\"SSSSSSS\",7],0,function(){return 1e4*this.millisecond()}),I(0,[\"SSSSSSSS\",8],0,function(){return 1e5*this.millisecond()}),I(0,[\"SSSSSSSSS\",9],0,function(){return 1e6*this.millisecond()}),H(\"millisecond\",\"ms\"),L(\"millisecond\",16),ue(\"S\",K,Z),ue(\"SS\",K,z),ue(\"SSS\",K,$),rn=\"SSSS\";rn.length<=9;rn+=\"S\")ue(rn,ne);function on(e,t){t[we]=k(1e3*(\"0.\"+e))}for(rn=\"S\";rn.length<=9;rn+=\"S\")ce(rn,on);var un=Te(\"Milliseconds\",!1);I(\"z\",0,0,\"zoneAbbr\"),I(\"zz\",0,0,\"zoneName\");var ln=M.prototype;function dn(e){return e}ln.add=qt,ln.calendar=function(e,t){var n=e||Tt(),s=Nt(n,this).startOf(\"day\"),i=c.calendarFormat(this,s)||\"sameElse\",r=t&&(x(t[i])?t[i].call(this,n):t[i]);return this.format(r||this.localeData().calendar(i,this,Tt(n)))},ln.clone=function(){return new M(this)},ln.diff=function(e,t,n){var s,i,r;if(!this.isValid())return NaN;if(!(s=Nt(e,this)).isValid())return NaN;switch(i=6e4*(s.utcOffset()-this.utcOffset()),t=R(t)){case\"year\":r=Bt(this,s)/12;break;case\"month\":r=Bt(this,s);break;case\"quarter\":r=Bt(this,s)/3;break;case\"second\":r=(this-s)/1e3;break;case\"minute\":r=(this-s)/6e4;break;case\"hour\":r=(this-s)/36e5;break;case\"day\":r=(this-s-i)/864e5;break;case\"week\":r=(this-s-i)/6048e5;break;default:r=this-s}return n?r:D(r)},ln.endOf=function(e){return void 0===(e=R(e))||\"millisecond\"===e?this:(\"date\"===e&&(e=\"day\"),this.startOf(e).add(1,\"isoWeek\"===e?\"week\":e).subtract(1,\"ms\"))},ln.format=function(e){e||(e=this.isUtc()?c.defaultFormatUtc:c.defaultFormat);var t=A(this,e);return this.localeData().postformat(t)},ln.from=function(e,t){return this.isValid()&&(S(e)&&e.isValid()||Tt(e).isValid())?At({to:this,from:e}).locale(this.locale()).humanize(!t):this.localeData().invalidDate()},ln.fromNow=function(e){return this.from(Tt(),e)},ln.to=function(e,t){return this.isValid()&&(S(e)&&e.isValid()||Tt(e).isValid())?At({from:this,to:e}).locale(this.locale()).humanize(!t):this.localeData().invalidDate()},ln.toNow=function(e){return this.to(Tt(),e)},ln.get=function(e){return x(this[e=R(e)])?this[e]():this},ln.invalidAt=function(){return g(this).overflow},ln.isAfter=function(e,t){var n=S(e)?e:Tt(e);return!(!this.isValid()||!n.isValid())&&(\"millisecond\"===(t=R(l(t)?\"millisecond\":t))?this.valueOf()>n.valueOf():n.valueOf()<this.clone().startOf(t).valueOf())},ln.isBefore=function(e,t){var n=S(e)?e:Tt(e);return!(!this.isValid()||!n.isValid())&&(\"millisecond\"===(t=R(l(t)?\"millisecond\":t))?this.valueOf()<n.valueOf():this.clone().endOf(t).valueOf()<n.valueOf())},ln.isBetween=function(e,t,n,s){return(\"(\"===(s=s||\"()\")[0]?this.isAfter(e,n):!this.isBefore(e,n))&&(\")\"===s[1]?this.isBefore(t,n):!this.isAfter(t,n))},ln.isSame=function(e,t){var n,s=S(e)?e:Tt(e);return!(!this.isValid()||!s.isValid())&&(\"millisecond\"===(t=R(t||\"millisecond\"))?this.valueOf()===s.valueOf():(n=s.valueOf(),this.clone().startOf(t).valueOf()<=n&&n<=this.clone().endOf(t).valueOf()))},ln.isSameOrAfter=function(e,t){return this.isSame(e,t)||this.isAfter(e,t)},ln.isSameOrBefore=function(e,t){return this.isSame(e,t)||this.isBefore(e,t)},ln.isValid=function(){return p(this)},ln.lang=Xt,ln.locale=Qt,ln.localeData=Kt,ln.max=bt,ln.min=xt,ln.parsingFlags=function(){return _({},g(this))},ln.set=function(e,t){if(\"object\"==typeof e)for(var n=function(e){var t=[];for(var n in e)t.push({unit:n,priority:F[n]});return t.sort(function(e,t){return e.priority-t.priority}),t}(e=C(e)),s=0;s<n.length;s++)this[n[s].unit](e[n[s].unit]);else if(x(this[e=R(e)]))return this[e](t);return this},ln.startOf=function(e){switch(e=R(e)){case\"year\":this.month(0);case\"quarter\":case\"month\":this.date(1);case\"week\":case\"isoWeek\":case\"day\":case\"date\":this.hours(0);case\"hour\":this.minutes(0);case\"minute\":this.seconds(0);case\"second\":this.milliseconds(0)}return\"week\"===e&&this.weekday(0),\"isoWeek\"===e&&this.isoWeekday(1),\"quarter\"===e&&this.month(3*Math.floor(this.month()/3)),this},ln.subtract=Jt,ln.toArray=function(){var e=this;return[e.year(),e.month(),e.date(),e.hour(),e.minute(),e.second(),e.millisecond()]},ln.toObject=function(){var e=this;return{years:e.year(),months:e.month(),date:e.date(),hours:e.hours(),minutes:e.minutes(),seconds:e.seconds(),milliseconds:e.milliseconds()}},ln.toDate=function(){return new Date(this.valueOf())},ln.toISOString=function(e){if(!this.isValid())return null;var t=!0!==e,n=t?this.clone().utc():this;return n.year()<0||9999<n.year()?A(n,t?\"YYYYYY-MM-DD[T]HH:mm:ss.SSS[Z]\":\"YYYYYY-MM-DD[T]HH:mm:ss.SSSZ\"):x(Date.prototype.toISOString)?t?this.toDate().toISOString():new Date(this.valueOf()+60*this.utcOffset()*1e3).toISOString().replace(\"Z\",A(n,\"Z\")):A(n,t?\"YYYY-MM-DD[T]HH:mm:ss.SSS[Z]\":\"YYYY-MM-DD[T]HH:mm:ss.SSSZ\")},ln.inspect=function(){if(!this.isValid())return\"moment.invalid(/* \"+this._i+\" */)\";var e=\"moment\",t=\"\";this.isLocal()||(e=0===this.utcOffset()?\"moment.utc\":\"moment.parseZone\",t=\"Z\");var n=\"[\"+e+'(\"]',s=0<=this.year()&&this.year()<=9999?\"YYYY\":\"YYYYYY\",i=t+'[\")]';return this.format(n+s+\"-MM-DD[T]HH:mm:ss.SSS\"+i)},ln.toJSON=function(){return this.isValid()?this.toISOString():null},ln.toString=function(){return this.clone().locale(\"en\").format(\"ddd MMM DD YYYY HH:mm:ss [GMT]ZZ\")},ln.unix=function(){return Math.floor(this.valueOf()/1e3)},ln.valueOf=function(){return this._d.valueOf()-6e4*(this._offset||0)},ln.creationData=function(){return{input:this._i,format:this._f,locale:this._locale,isUTC:this._isUTC,strict:this._strict}},ln.year=Oe,ln.isLeapYear=function(){return ke(this.year())},ln.weekYear=function(e){return tn.call(this,e,this.week(),this.weekday(),this.localeData()._week.dow,this.localeData()._week.doy)},ln.isoWeekYear=function(e){return tn.call(this,e,this.isoWeek(),this.isoWeekday(),1,4)},ln.quarter=ln.quarters=function(e){return null==e?Math.ceil((this.month()+1)/3):this.month(3*(e-1)+this.month()%3)},ln.month=Fe,ln.daysInMonth=function(){return Pe(this.year(),this.month())},ln.week=ln.weeks=function(e){var t=this.localeData().week(this);return null==e?t:this.add(7*(e-t),\"d\")},ln.isoWeek=ln.isoWeeks=function(e){var t=Ie(this,1,4).week;return null==e?t:this.add(7*(e-t),\"d\")},ln.weeksInYear=function(){var e=this.localeData()._week;return Ae(this.year(),e.dow,e.doy)},ln.isoWeeksInYear=function(){return Ae(this.year(),1,4)},ln.date=nn,ln.day=ln.days=function(e){if(!this.isValid())return null!=e?this:NaN;var t,n,s=this._isUTC?this._d.getUTCDay():this._d.getDay();return null!=e?(t=e,n=this.localeData(),e=\"string\"!=typeof t?t:isNaN(t)?\"number\"==typeof(t=n.weekdaysParse(t))?t:null:parseInt(t,10),this.add(e-s,\"d\")):s},ln.weekday=function(e){if(!this.isValid())return null!=e?this:NaN;var t=(this.day()+7-this.localeData()._week.dow)%7;return null==e?t:this.add(e-t,\"d\")},ln.isoWeekday=function(e){if(!this.isValid())return null!=e?this:NaN;if(null!=e){var t=(n=e,s=this.localeData(),\"string\"==typeof n?s.weekdaysParse(n)%7||7:isNaN(n)?null:n);return this.day(this.day()%7?t:t-7)}return this.day()||7;var n,s},ln.dayOfYear=function(e){var t=Math.round((this.clone().startOf(\"day\")-this.clone().startOf(\"year\"))/864e5)+1;return null==e?t:this.add(e-t,\"d\")},ln.hour=ln.hours=tt,ln.minute=ln.minutes=sn,ln.second=ln.seconds=an,ln.millisecond=ln.milliseconds=un,ln.utcOffset=function(e,t,n){var s,i=this._offset||0;if(!this.isValid())return null!=e?this:NaN;if(null!=e){if(\"string\"==typeof e){if(null===(e=Ut(re,e)))return this}else Math.abs(e)<16&&!n&&(e*=60);return!this._isUTC&&t&&(s=Gt(this)),this._offset=e,this._isUTC=!0,null!=s&&this.add(s,\"m\"),i!==e&&(!t||this._changeInProgress?$t(this,At(e-i,\"m\"),1,!1):this._changeInProgress||(this._changeInProgress=!0,c.updateOffset(this,!0),this._changeInProgress=null)),this}return this._isUTC?i:Gt(this)},ln.utc=function(e){return this.utcOffset(0,e)},ln.local=function(e){return this._isUTC&&(this.utcOffset(0,e),this._isUTC=!1,e&&this.subtract(Gt(this),\"m\")),this},ln.parseZone=function(){if(null!=this._tzm)this.utcOffset(this._tzm,!1,!0);else if(\"string\"==typeof this._i){var e=Ut(ie,this._i);null!=e?this.utcOffset(e):this.utcOffset(0,!0)}return this},ln.hasAlignedHourOffset=function(e){return!!this.isValid()&&(e=e?Tt(e).utcOffset():0,(this.utcOffset()-e)%60==0)},ln.isDST=function(){return this.utcOffset()>this.clone().month(0).utcOffset()||this.utcOffset()>this.clone().month(5).utcOffset()},ln.isLocal=function(){return!!this.isValid()&&!this._isUTC},ln.isUtcOffset=function(){return!!this.isValid()&&this._isUTC},ln.isUtc=Vt,ln.isUTC=Vt,ln.zoneAbbr=function(){return this._isUTC?\"UTC\":\"\"},ln.zoneName=function(){return this._isUTC?\"Coordinated Universal Time\":\"\"},ln.dates=n(\"dates accessor is deprecated. Use date instead.\",nn),ln.months=n(\"months accessor is deprecated. Use month instead\",Fe),ln.years=n(\"years accessor is deprecated. Use year instead\",Oe),ln.zone=n(\"moment().zone is deprecated, use moment().utcOffset instead. http://momentjs.com/guides/#/warnings/zone/\",function(e,t){return null!=e?(\"string\"!=typeof e&&(e=-e),this.utcOffset(e,t),this):-this.utcOffset()}),ln.isDSTShifted=n(\"isDSTShifted is deprecated. See http://momentjs.com/guides/#/warnings/dst-shifted/ for more information\",function(){if(!l(this._isDSTShifted))return this._isDSTShifted;var e={};if(w(e,this),(e=Yt(e))._a){var t=e._isUTC?y(e._a):Tt(e._a);this._isDSTShifted=this.isValid()&&0<a(e._a,t.toArray())}else this._isDSTShifted=!1;return this._isDSTShifted});var hn=P.prototype;function cn(e,t,n,s){var i=lt(),r=y().set(s,t);return i[n](r,e)}function fn(e,t,n){if(d(e)&&(t=e,e=void 0),e=e||\"\",null!=t)return cn(e,t,n,\"month\");var s,i=[];for(s=0;s<12;s++)i[s]=cn(e,s,n,\"month\");return i}function mn(e,t,n,s){\"boolean\"==typeof e?d(t)&&(n=t,t=void 0):(t=e,e=!1,d(n=t)&&(n=t,t=void 0)),t=t||\"\";var i,r=lt(),a=e?r._week.dow:0;if(null!=n)return cn(t,(n+a)%7,s,\"day\");var o=[];for(i=0;i<7;i++)o[i]=cn(t,(i+a)%7,s,\"day\");return o}hn.calendar=function(e,t,n){var s=this._calendar[e]||this._calendar.sameElse;return x(s)?s.call(t,n):s},hn.longDateFormat=function(e){var t=this._longDateFormat[e],n=this._longDateFormat[e.toUpperCase()];return t||!n?t:(this._longDateFormat[e]=n.replace(/MMMM|MM|DD|dddd/g,function(e){return e.slice(1)}),this._longDateFormat[e])},hn.invalidDate=function(){return this._invalidDate},hn.ordinal=function(e){return this._ordinal.replace(\"%d\",e)},hn.preparse=dn,hn.postformat=dn,hn.relativeTime=function(e,t,n,s){var i=this._relativeTime[n];return x(i)?i(e,t,n,s):i.replace(/%d/i,e)},hn.pastFuture=function(e,t){var n=this._relativeTime[0<e?\"future\":\"past\"];return x(n)?n(t):n.replace(/%s/i,t)},hn.set=function(e){var t,n;for(n in e)x(t=e[n])?this[n]=t:this[\"_\"+n]=t;this._config=e,this._dayOfMonthOrdinalParseLenient=new RegExp((this._dayOfMonthOrdinalParse.source||this._ordinalParse.source)+\"|\"+/\\d{1,2}/.source)},hn.months=function(e,t){return e?o(this._months)?this._months[e.month()]:this._months[(this._months.isFormat||We).test(t)?\"format\":\"standalone\"][e.month()]:o(this._months)?this._months:this._months.standalone},hn.monthsShort=function(e,t){return e?o(this._monthsShort)?this._monthsShort[e.month()]:this._monthsShort[We.test(t)?\"format\":\"standalone\"][e.month()]:o(this._monthsShort)?this._monthsShort:this._monthsShort.standalone},hn.monthsParse=function(e,t,n){var s,i,r;if(this._monthsParseExact)return function(e,t,n){var s,i,r,a=e.toLocaleLowerCase();if(!this._monthsParse)for(this._monthsParse=[],this._longMonthsParse=[],this._shortMonthsParse=[],s=0;s<12;++s)r=y([2e3,s]),this._shortMonthsParse[s]=this.monthsShort(r,\"\").toLocaleLowerCase(),this._longMonthsParse[s]=this.months(r,\"\").toLocaleLowerCase();return n?\"MMM\"===t?-1!==(i=Ye.call(this._shortMonthsParse,a))?i:null:-1!==(i=Ye.call(this._longMonthsParse,a))?i:null:\"MMM\"===t?-1!==(i=Ye.call(this._shortMonthsParse,a))?i:-1!==(i=Ye.call(this._longMonthsParse,a))?i:null:-1!==(i=Ye.call(this._longMonthsParse,a))?i:-1!==(i=Ye.call(this._shortMonthsParse,a))?i:null}.call(this,e,t,n);for(this._monthsParse||(this._monthsParse=[],this._longMonthsParse=[],this._shortMonthsParse=[]),s=0;s<12;s++){if(i=y([2e3,s]),n&&!this._longMonthsParse[s]&&(this._longMonthsParse[s]=new RegExp(\"^\"+this.months(i,\"\").replace(\".\",\"\")+\"$\",\"i\"),this._shortMonthsParse[s]=new RegExp(\"^\"+this.monthsShort(i,\"\").replace(\".\",\"\")+\"$\",\"i\")),n||this._monthsParse[s]||(r=\"^\"+this.months(i,\"\")+\"|^\"+this.monthsShort(i,\"\"),this._monthsParse[s]=new RegExp(r.replace(\".\",\"\"),\"i\")),n&&\"MMMM\"===t&&this._longMonthsParse[s].test(e))return s;if(n&&\"MMM\"===t&&this._shortMonthsParse[s].test(e))return s;if(!n&&this._monthsParse[s].test(e))return s}},hn.monthsRegex=function(e){return this._monthsParseExact?(m(this,\"_monthsRegex\")||Ne.call(this),e?this._monthsStrictRegex:this._monthsRegex):(m(this,\"_monthsRegex\")||(this._monthsRegex=Ue),this._monthsStrictRegex&&e?this._monthsStrictRegex:this._monthsRegex)},hn.monthsShortRegex=function(e){return this._monthsParseExact?(m(this,\"_monthsRegex\")||Ne.call(this),e?this._monthsShortStrictRegex:this._monthsShortRegex):(m(this,\"_monthsShortRegex\")||(this._monthsShortRegex=Le),this._monthsShortStrictRegex&&e?this._monthsShortStrictRegex:this._monthsShortRegex)},hn.week=function(e){return Ie(e,this._week.dow,this._week.doy).week},hn.firstDayOfYear=function(){return this._week.doy},hn.firstDayOfWeek=function(){return this._week.dow},hn.weekdays=function(e,t){return e?o(this._weekdays)?this._weekdays[e.day()]:this._weekdays[this._weekdays.isFormat.test(t)?\"format\":\"standalone\"][e.day()]:o(this._weekdays)?this._weekdays:this._weekdays.standalone},hn.weekdaysMin=function(e){return e?this._weekdaysMin[e.day()]:this._weekdaysMin},hn.weekdaysShort=function(e){return e?this._weekdaysShort[e.day()]:this._weekdaysShort},hn.weekdaysParse=function(e,t,n){var s,i,r;if(this._weekdaysParseExact)return function(e,t,n){var s,i,r,a=e.toLocaleLowerCase();if(!this._weekdaysParse)for(this._weekdaysParse=[],this._shortWeekdaysParse=[],this._minWeekdaysParse=[],s=0;s<7;++s)r=y([2e3,1]).day(s),this._minWeekdaysParse[s]=this.weekdaysMin(r,\"\").toLocaleLowerCase(),this._shortWeekdaysParse[s]=this.weekdaysShort(r,\"\").toLocaleLowerCase(),this._weekdaysParse[s]=this.weekdays(r,\"\").toLocaleLowerCase();return n?\"dddd\"===t?-1!==(i=Ye.call(this._weekdaysParse,a))?i:null:\"ddd\"===t?-1!==(i=Ye.call(this._shortWeekdaysParse,a))?i:null:-1!==(i=Ye.call(this._minWeekdaysParse,a))?i:null:\"dddd\"===t?-1!==(i=Ye.call(this._weekdaysParse,a))?i:-1!==(i=Ye.call(this._shortWeekdaysParse,a))?i:-1!==(i=Ye.call(this._minWeekdaysParse,a))?i:null:\"ddd\"===t?-1!==(i=Ye.call(this._shortWeekdaysParse,a))?i:-1!==(i=Ye.call(this._weekdaysParse,a))?i:-1!==(i=Ye.call(this._minWeekdaysParse,a))?i:null:-1!==(i=Ye.call(this._minWeekdaysParse,a))?i:-1!==(i=Ye.call(this._weekdaysParse,a))?i:-1!==(i=Ye.call(this._shortWeekdaysParse,a))?i:null}.call(this,e,t,n);for(this._weekdaysParse||(this._weekdaysParse=[],this._minWeekdaysParse=[],this._shortWeekdaysParse=[],this._fullWeekdaysParse=[]),s=0;s<7;s++){if(i=y([2e3,1]).day(s),n&&!this._fullWeekdaysParse[s]&&(this._fullWeekdaysParse[s]=new RegExp(\"^\"+this.weekdays(i,\"\").replace(\".\",\"\\\\.?\")+\"$\",\"i\"),this._shortWeekdaysParse[s]=new RegExp(\"^\"+this.weekdaysShort(i,\"\").replace(\".\",\"\\\\.?\")+\"$\",\"i\"),this._minWeekdaysParse[s]=new RegExp(\"^\"+this.weekdaysMin(i,\"\").replace(\".\",\"\\\\.?\")+\"$\",\"i\")),this._weekdaysParse[s]||(r=\"^\"+this.weekdays(i,\"\")+\"|^\"+this.weekdaysShort(i,\"\")+\"|^\"+this.weekdaysMin(i,\"\"),this._weekdaysParse[s]=new RegExp(r.replace(\".\",\"\"),\"i\")),n&&\"dddd\"===t&&this._fullWeekdaysParse[s].test(e))return s;if(n&&\"ddd\"===t&&this._shortWeekdaysParse[s].test(e))return s;if(n&&\"dd\"===t&&this._minWeekdaysParse[s].test(e))return s;if(!n&&this._weekdaysParse[s].test(e))return s}},hn.weekdaysRegex=function(e){return this._weekdaysParseExact?(m(this,\"_weekdaysRegex\")||Be.call(this),e?this._weekdaysStrictRegex:this._weekdaysRegex):(m(this,\"_weekdaysRegex\")||(this._weekdaysRegex=$e),this._weekdaysStrictRegex&&e?this._weekdaysStrictRegex:this._weekdaysRegex)},hn.weekdaysShortRegex=function(e){return this._weekdaysParseExact?(m(this,\"_weekdaysRegex\")||Be.call(this),e?this._weekdaysShortStrictRegex:this._weekdaysShortRegex):(m(this,\"_weekdaysShortRegex\")||(this._weekdaysShortRegex=qe),this._weekdaysShortStrictRegex&&e?this._weekdaysShortStrictRegex:this._weekdaysShortRegex)},hn.weekdaysMinRegex=function(e){return this._weekdaysParseExact?(m(this,\"_weekdaysRegex\")||Be.call(this),e?this._weekdaysMinStrictRegex:this._weekdaysMinRegex):(m(this,\"_weekdaysMinRegex\")||(this._weekdaysMinRegex=Je),this._weekdaysMinStrictRegex&&e?this._weekdaysMinStrictRegex:this._weekdaysMinRegex)},hn.isPM=function(e){return\"p\"===(e+\"\").toLowerCase().charAt(0)},hn.meridiem=function(e,t,n){return 11<e?n?\"pm\":\"PM\":n?\"am\":\"AM\"},ot(\"en\",{dayOfMonthOrdinalParse:/\\d{1,2}(th|st|nd|rd)/,ordinal:function(e){var t=e%10;return e+(1===k(e%100/10)?\"th\":1===t?\"st\":2===t?\"nd\":3===t?\"rd\":\"th\")}}),c.lang=n(\"moment.lang is deprecated. Use moment.locale instead.\",ot),c.langData=n(\"moment.langData is deprecated. Use moment.localeData instead.\",lt);var _n=Math.abs;function yn(e,t,n,s){var i=At(t,n);return e._milliseconds+=s*i._milliseconds,e._days+=s*i._days,e._months+=s*i._months,e._bubble()}function gn(e){return e<0?Math.floor(e):Math.ceil(e)}function pn(e){return 4800*e/146097}function vn(e){return 146097*e/4800}function wn(e){return function(){return this.as(e)}}var Mn=wn(\"ms\"),Sn=wn(\"s\"),Dn=wn(\"m\"),kn=wn(\"h\"),Yn=wn(\"d\"),On=wn(\"w\"),Tn=wn(\"M\"),xn=wn(\"y\");function bn(e){return function(){return this.isValid()?this._data[e]:NaN}}var Pn=bn(\"milliseconds\"),Wn=bn(\"seconds\"),Hn=bn(\"minutes\"),Rn=bn(\"hours\"),Cn=bn(\"days\"),Fn=bn(\"months\"),Ln=bn(\"years\");var Un=Math.round,Nn={ss:44,s:45,m:45,h:22,d:26,M:11};var Gn=Math.abs;function Vn(e){return(0<e)-(e<0)||+e}function En(){if(!this.isValid())return this.localeData().invalidDate();var e,t,n=Gn(this._milliseconds)/1e3,s=Gn(this._days),i=Gn(this._months);t=D((e=D(n/60))/60),n%=60,e%=60;var r=D(i/12),a=i%=12,o=s,u=t,l=e,d=n?n.toFixed(3).replace(/\\.?0+$/,\"\"):\"\",h=this.asSeconds();if(!h)return\"P0D\";var c=h<0?\"-\":\"\",f=Vn(this._months)!==Vn(h)?\"-\":\"\",m=Vn(this._days)!==Vn(h)?\"-\":\"\",_=Vn(this._milliseconds)!==Vn(h)?\"-\":\"\";return c+\"P\"+(r?f+r+\"Y\":\"\")+(a?f+a+\"M\":\"\")+(o?m+o+\"D\":\"\")+(u||l||d?\"T\":\"\")+(u?_+u+\"H\":\"\")+(l?_+l+\"M\":\"\")+(d?_+d+\"S\":\"\")}var In=Ht.prototype;return In.isValid=function(){return this._isValid},In.abs=function(){var e=this._data;return this._milliseconds=_n(this._milliseconds),this._days=_n(this._days),this._months=_n(this._months),e.milliseconds=_n(e.milliseconds),e.seconds=_n(e.seconds),e.minutes=_n(e.minutes),e.hours=_n(e.hours),e.months=_n(e.months),e.years=_n(e.years),this},In.add=function(e,t){return yn(this,e,t,1)},In.subtract=function(e,t){return yn(this,e,t,-1)},In.as=function(e){if(!this.isValid())return NaN;var t,n,s=this._milliseconds;if(\"month\"===(e=R(e))||\"year\"===e)return t=this._days+s/864e5,n=this._months+pn(t),\"month\"===e?n:n/12;switch(t=this._days+Math.round(vn(this._months)),e){case\"week\":return t/7+s/6048e5;case\"day\":return t+s/864e5;case\"hour\":return 24*t+s/36e5;case\"minute\":return 1440*t+s/6e4;case\"second\":return 86400*t+s/1e3;case\"millisecond\":return Math.floor(864e5*t)+s;default:throw new Error(\"Unknown unit \"+e)}},In.asMilliseconds=Mn,In.asSeconds=Sn,In.asMinutes=Dn,In.asHours=kn,In.asDays=Yn,In.asWeeks=On,In.asMonths=Tn,In.asYears=xn,In.valueOf=function(){return this.isValid()?this._milliseconds+864e5*this._days+this._months%12*2592e6+31536e6*k(this._months/12):NaN},In._bubble=function(){var e,t,n,s,i,r=this._milliseconds,a=this._days,o=this._months,u=this._data;return 0<=r&&0<=a&&0<=o||r<=0&&a<=0&&o<=0||(r+=864e5*gn(vn(o)+a),o=a=0),u.milliseconds=r%1e3,e=D(r/1e3),u.seconds=e%60,t=D(e/60),u.minutes=t%60,n=D(t/60),u.hours=n%24,o+=i=D(pn(a+=D(n/24))),a-=gn(vn(i)),s=D(o/12),o%=12,u.days=a,u.months=o,u.years=s,this},In.clone=function(){return At(this)},In.get=function(e){return e=R(e),this.isValid()?this[e+\"s\"]():NaN},In.milliseconds=Pn,In.seconds=Wn,In.minutes=Hn,In.hours=Rn,In.days=Cn,In.weeks=function(){return D(this.days()/7)},In.months=Fn,In.years=Ln,In.humanize=function(e){if(!this.isValid())return this.localeData().invalidDate();var t,n,s,i,r,a,o,u,l,d,h,c=this.localeData(),f=(n=!e,s=c,i=At(t=this).abs(),r=Un(i.as(\"s\")),a=Un(i.as(\"m\")),o=Un(i.as(\"h\")),u=Un(i.as(\"d\")),l=Un(i.as(\"M\")),d=Un(i.as(\"y\")),(h=r<=Nn.ss&&[\"s\",r]||r<Nn.s&&[\"ss\",r]||a<=1&&[\"m\"]||a<Nn.m&&[\"mm\",a]||o<=1&&[\"h\"]||o<Nn.h&&[\"hh\",o]||u<=1&&[\"d\"]||u<Nn.d&&[\"dd\",u]||l<=1&&[\"M\"]||l<Nn.M&&[\"MM\",l]||d<=1&&[\"y\"]||[\"yy\",d])[2]=n,h[3]=0<+t,h[4]=s,function(e,t,n,s,i){return i.relativeTime(t||1,!!n,e,s)}.apply(null,h));return e&&(f=c.pastFuture(+this,f)),c.postformat(f)},In.toISOString=En,In.toString=En,In.toJSON=En,In.locale=Qt,In.localeData=Kt,In.toIsoString=n(\"toIsoString() is deprecated. Please use toISOString() instead (notice the capitals)\",En),In.lang=Xt,I(\"X\",0,0,\"unix\"),I(\"x\",0,0,\"valueOf\"),ue(\"x\",se),ue(\"X\",/[+-]?\\d+(\\.\\d{1,3})?/),ce(\"X\",function(e,t,n){n._d=new Date(1e3*parseFloat(e,10))}),ce(\"x\",function(e,t,n){n._d=new Date(k(e))}),c.version=\"2.22.2\",e=Tt,c.fn=ln,c.min=function(){return Pt(\"isBefore\",[].slice.call(arguments,0))},c.max=function(){return Pt(\"isAfter\",[].slice.call(arguments,0))},c.now=function(){return Date.now?Date.now():+new Date},c.utc=y,c.unix=function(e){return Tt(1e3*e)},c.months=function(e,t){return fn(e,t,\"months\")},c.isDate=h,c.locale=ot,c.invalid=v,c.duration=At,c.isMoment=S,c.weekdays=function(e,t,n){return mn(e,t,n,\"weekdays\")},c.parseZone=function(){return Tt.apply(null,arguments).parseZone()},c.localeData=lt,c.isDuration=Rt,c.monthsShort=function(e,t){return fn(e,t,\"monthsShort\")},c.weekdaysMin=function(e,t,n){return mn(e,t,n,\"weekdaysMin\")},c.defineLocale=ut,c.updateLocale=function(e,t){if(null!=t){var n,s,i=nt;null!=(s=at(e))&&(i=s._config),(n=new P(t=b(i,t))).parentLocale=st[e],st[e]=n,ot(e)}else null!=st[e]&&(null!=st[e].parentLocale?st[e]=st[e].parentLocale:null!=st[e]&&delete st[e]);return st[e]},c.locales=function(){return s(st)},c.weekdaysShort=function(e,t,n){return mn(e,t,n,\"weekdaysShort\")},c.normalizeUnits=R,c.relativeTimeRounding=function(e){return void 0===e?Un:\"function\"==typeof e&&(Un=e,!0)},c.relativeTimeThreshold=function(e,t){return void 0!==Nn[e]&&(void 0===t?Nn[e]:(Nn[e]=t,\"s\"===e&&(Nn.ss=t-1),!0))},c.calendarFormat=function(e,t){var n=e.diff(t,\"days\",!0);return n<-6?\"sameElse\":n<-1?\"lastWeek\":n<0?\"lastDay\":n<1?\"sameDay\":n<2?\"nextDay\":n<7?\"nextWeek\":\"sameElse\"},c.prototype=ln,c.HTML5_FMT={DATETIME_LOCAL:\"YYYY-MM-DDTHH:mm\",DATETIME_LOCAL_SECONDS:\"YYYY-MM-DDTHH:mm:ss\",DATETIME_LOCAL_MS:\"YYYY-MM-DDTHH:mm:ss.SSS\",DATE:\"YYYY-MM-DD\",TIME:\"HH:mm\",TIME_SECONDS:\"HH:mm:ss\",TIME_MS:\"HH:mm:ss.SSS\",WEEK:\"YYYY-[W]WW\",MONTH:\"YYYY-MM\"},c});","Rahi_Equote/js/eqoute.js":"require(['jquery'], function ($) {\n    $(document).ready(function() {\n\t$('.add').click(function(){\n\t\talert('added');\n\t});\n    });\n});\n\n","Magento_Captcha/js/captcha.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    /**\n     * @api\n     */\n    $.widget('mage.captcha', {\n        options: {\n            refreshClass: 'refreshing',\n            reloadSelector: '.captcha-reload',\n            imageSelector: '.captcha-img',\n            imageLoader: ''\n        },\n\n        /**\n         * Method binds click event to reload image\n         * @private\n         */\n        _create: function () {\n            this.element.on('click', this.options.reloadSelector, $.proxy(this.refresh, this));\n        },\n\n        /**\n         * Method triggers an AJAX request to refresh the CAPTCHA image\n         */\n        refresh: function () {\n            var imageLoader = this.options.imageLoader;\n\n            if (imageLoader) {\n                this.element.find(this.options.imageSelector).attr('src', imageLoader);\n            }\n            this.element.addClass(this.options.refreshClass);\n\n            $.ajax({\n                url: this.options.url,\n                type: 'post',\n                async: false,\n                dataType: 'json',\n                context: this,\n                data: {\n                    'formId': this.options.type\n                },\n\n                /**\n                 * @param {Object} response\n                 */\n                success: function (response) {\n                    if (response.imgSrc) {\n                        this.element.find(this.options.imageSelector).attr('src', response.imgSrc);\n                    }\n                },\n\n                /** Complete callback. */\n                complete: function () {\n                    this.element.removeClass(this.options.refreshClass);\n                }\n            });\n        }\n    });\n\n    return $.mage.captcha;\n});\n","Magento_Captcha/js/action/refresh.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery', 'mage/url'\n], function ($, urlBuilder) {\n    'use strict';\n\n    return function (refreshUrl, formId, imageSource) {\n        return $.ajax({\n            url: urlBuilder.build(refreshUrl),\n            type: 'POST',\n            async: false,\n            data: JSON.stringify({\n                'formId': formId\n            }),\n            global: false,\n            contentType: 'application/json'\n        }).done(\n            function (response) {\n                if (response.imgSrc) {\n                    imageSource(response.imgSrc);\n                }\n            }\n        );\n    };\n});\n","Magento_Captcha/js/model/captcha.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/*global alert*/\ndefine([\n    'jquery',\n    'ko',\n    'Magento_Captcha/js/action/refresh'\n], function ($, ko, refreshAction) {\n    'use strict';\n\n    return function (captchaData) {\n        return {\n            formId: captchaData.formId,\n            imageSource: ko.observable(captchaData.imageSrc),\n            visibility: ko.observable(false),\n            captchaValue: ko.observable(null),\n            isRequired: ko.observable(captchaData.isRequired),\n            isCaseSensitive: captchaData.isCaseSensitive,\n            imageHeight: captchaData.imageHeight,\n            refreshUrl: captchaData.refreshUrl,\n            isLoading: ko.observable(false),\n            timestamp: null,\n\n            /**\n             * @return {String}\n             */\n            getFormId: function () {\n                return this.formId;\n            },\n\n            /**\n             * @param {String} formId\n             */\n            setFormId: function (formId) {\n                this.formId = formId;\n            },\n\n            /**\n             * @return {Boolean}\n             */\n            getIsVisible: function () {\n                return this.visibility();\n            },\n\n            /**\n             * @param {Boolean} flag\n             */\n            setIsVisible: function (flag) {\n                this.visibility(flag);\n            },\n\n            /**\n             * @return {Boolean}\n             */\n            getIsRequired: function () {\n                return this.isRequired();\n            },\n\n            /**\n             * @param {Boolean} flag\n             */\n            setIsRequired: function (flag) {\n                this.isRequired(flag);\n            },\n\n            /**\n             * @return {Boolean}\n             */\n            getIsCaseSensitive: function () {\n                return this.isCaseSensitive;\n            },\n\n            /**\n             * @param {Boolean} flag\n             */\n            setIsCaseSensitive: function (flag) {\n                this.isCaseSensitive = flag;\n            },\n\n            /**\n             * @return {String|Number}\n             */\n            getImageHeight: function () {\n                return this.imageHeight;\n            },\n\n            /**\n             * @param {String|Number}height\n             */\n            setImageHeight: function (height) {\n                this.imageHeight = height;\n            },\n\n            /**\n             * @return {String}\n             */\n            getImageSource: function () {\n                return this.imageSource;\n            },\n\n            /**\n             * @param {String} imageSource\n             */\n            setImageSource: function (imageSource) {\n                this.imageSource(imageSource);\n            },\n\n            /**\n             * @return {String}\n             */\n            getRefreshUrl: function () {\n                return this.refreshUrl;\n            },\n\n            /**\n             * @param {String} url\n             */\n            setRefreshUrl: function (url) {\n                this.refreshUrl = url;\n            },\n\n            /**\n             * @return {*}\n             */\n            getCaptchaValue: function () {\n                return this.captchaValue;\n            },\n\n            /**\n             * @param {*} value\n             */\n            setCaptchaValue: function (value) {\n                this.captchaValue(value);\n            },\n\n            /**\n             * Refresh captcha.\n             */\n            refresh: function () {\n                var refresh,\n                    self = this;\n\n                this.isLoading(true);\n\n                refresh = refreshAction(this.getRefreshUrl(), this.getFormId(), this.getImageSource());\n                $.when(refresh).done(function () {\n                    self.isLoading(false);\n                });\n            }\n        };\n    };\n});\n","Magento_Captcha/js/model/captchaList.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['jquery'], function ($) {\n    'use strict';\n\n    var captchaList = [];\n\n    return {\n        /**\n         * @param {Object} captcha\n         */\n        add: function (captcha) {\n            captchaList.push(captcha);\n        },\n\n        /**\n         * @param {String} formId\n         * @return {Object}\n         */\n        getCaptchaByFormId: function (formId) {\n            var captcha = null;\n\n            $.each(captchaList, function (key, item) {\n                if (formId === item.formId) {\n                    captcha = item;\n\n                    return false;\n                }\n            });\n\n            return captcha;\n        },\n\n        /**\n         * @return {Array}\n         */\n        getCaptchaList: function () {\n            return captchaList;\n        }\n    };\n});\n","Magento_Captcha/js/view/checkout/loginCaptcha.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Captcha/js/view/checkout/defaultCaptcha',\n    'Magento_Captcha/js/model/captchaList',\n    'Magento_Customer/js/action/login',\n    'underscore'\n],\nfunction (defaultCaptcha, captchaList, loginAction, _) {\n    'use strict';\n\n    return defaultCaptcha.extend({\n        /** @inheritdoc */\n        initialize: function () {\n            var self = this,\n                currentCaptcha;\n\n            this._super();\n            currentCaptcha = captchaList.getCaptchaByFormId(this.formId);\n\n            if (currentCaptcha != null) {\n                currentCaptcha.setIsVisible(true);\n                this.setCurrentCaptcha(currentCaptcha);\n\n                loginAction.registerLoginCallback(function (loginData) {\n                    if (loginData['captcha_form_id'] &&\n                        loginData['captcha_form_id'] === self.formId &&\n                        self.isRequired()\n                    ) {\n                        _.defer(self.refresh.bind(self));\n                    }\n                });\n            }\n        }\n    });\n});\n","Magento_Captcha/js/view/checkout/defaultCaptcha.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'uiComponent',\n    'Magento_Captcha/js/model/captcha',\n    'Magento_Captcha/js/model/captchaList',\n    'Magento_Customer/js/customer-data',\n    'underscore'\n], function ($, Component, Captcha, captchaList, customerData, _) {\n    'use strict';\n\n    var captchaConfig;\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Captcha/checkout/captcha'\n        },\n        dataScope: 'global',\n        currentCaptcha: null,\n        subscribedFormIds: [],\n\n        /**\n         * @return {*}\n         */\n        captchaValue: function () {\n            return this.currentCaptcha.getCaptchaValue();\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n\n            if (window[this.configSource] && window[this.configSource].captcha) {\n                captchaConfig = window[this.configSource].captcha;\n                $.each(captchaConfig, function (formId, captchaData) {\n                    var captcha;\n\n                    captchaData.formId = formId;\n                    captcha = Captcha(captchaData);\n                    this.checkCustomerData(formId, customerData.get('captcha')(), captcha);\n                    this.subscribeCustomerData(formId, captcha);\n                    captchaList.add(captcha);\n                }.bind(this));\n            }\n        },\n\n        /**\n         * Check customer data for captcha configuration.\n         *\n         * @param {String} formId\n         * @param {Object} captchaData\n         * @param {Object} captcha\n         */\n        checkCustomerData: function (formId, captchaData, captcha) {\n            if (!_.isEmpty(captchaData) &&\n                !_.isEmpty(captchaData[formId]) &&\n                captchaData[formId].timestamp > captcha.timestamp\n            ) {\n                if (!captcha.isRequired() && captchaData[formId].isRequired) {\n                    captcha.refresh();\n                }\n                captcha.isRequired(captchaData[formId].isRequired);\n                captcha.timestamp = captchaData[formId].timestamp;\n            }\n        },\n\n        /**\n         * Subscribe for customer data updates.\n         *\n         * @param {String} formId\n         * @param {Object} captcha\n         */\n        subscribeCustomerData: function (formId, captcha) {\n            if (this.subscribedFormIds.includes(formId) === false) {\n                this.subscribedFormIds.push(formId);\n                customerData.get('captcha').subscribe(function (captchaData) {\n                    this.checkCustomerData(formId, captchaData, captcha);\n                }.bind(this));\n            }\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        getIsLoading: function () {\n            return this.currentCaptcha !== null ? this.currentCaptcha.isLoading : false;\n        },\n\n        /**\n         * @return {null|Object}\n         */\n        getCurrentCaptcha: function () {\n            return this.currentCaptcha;\n        },\n\n        /**\n         * @param {Object} captcha\n         */\n        setCurrentCaptcha: function (captcha) {\n            this.currentCaptcha = captcha;\n        },\n\n        /**\n         * @return {String|null}\n         */\n        getFormId: function () {\n            return this.currentCaptcha !== null ? this.currentCaptcha.getFormId() : null;\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        getIsVisible: function () {\n            return this.currentCaptcha !== null ? this.currentCaptcha.getIsVisible() : false;\n        },\n\n        /**\n         * @param {Boolean} flag\n         */\n        setIsVisible: function (flag) {\n            this.currentCaptcha.setIsVisible(flag);\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isRequired: function () {\n            return this.currentCaptcha !== null ? this.currentCaptcha.getIsRequired() : false;\n        },\n\n        /**\n         * Set isRequired on current captcha model.\n         *\n         * @param {Boolean} flag\n         */\n        setIsRequired: function (flag) {\n            this.currentCaptcha.setIsRequired(flag);\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isCaseSensitive: function () {\n            return this.currentCaptcha !== null ? this.currentCaptcha.getIsCaseSensitive() : false;\n        },\n\n        /**\n         * @return {String|Number|null}\n         */\n        imageHeight: function () {\n            return this.currentCaptcha !== null ? this.currentCaptcha.getImageHeight() : null;\n        },\n\n        /**\n         * @return {String|null}\n         */\n        getImageSource: function () {\n            return this.currentCaptcha !== null ? this.currentCaptcha.getImageSource() : null;\n        },\n\n        /**\n         * Refresh captcha.\n         */\n        refresh: function () {\n            this.currentCaptcha.refresh();\n        }\n    });\n});\n","Dotdigitalgroup_Sms/js/telephoneValidatorCheckout.js":"define([\n    'jquery',\n    'ko',\n    'intlTelInput'\n], function ($, ko, intlTelInput) {\n    'use strict';\n\n    return function (validator) {\n\n        var errorMap = [\n            'Invalid telephone number',\n            'Invalid country code',\n            'Telephone number is too short',\n            'Telephone number is too long',\n            'Invalid telephone number'\n        ];\n\n        var validatorObj = {\n            message: '',\n\n            /**\n             * @param {String} value\n             * @param {*} params\n             * @param {Object} additionalParams\n             */\n            validate: function (value, params, additionalParams) {\n                var target = $('#' + additionalParams.uid),\n                    countryCodeClass = target.parent().find('.iti__selected-flag .iti__flag').attr('class'),\n                    countryCode,\n                    isValid = false,\n                    errorCode;\n\n                if (countryCodeClass === undefined || countryCodeClass.indexOf(' ') === -1) {\n                    this.message = errorMap[1];\n\n                    return false;\n                }\n\n                countryCodeClass = countryCodeClass.split(' ')[1];\n                countryCode = countryCodeClass.split('__')[1];\n                isValid = window.intlTelInputUtils.isValidNumber(value, countryCode);\n\n                if (!isValid) {\n                    errorCode = window.intlTelInputUtils.getValidationError(value, countryCode);\n                    this.message = typeof errorMap[errorCode] === 'undefined' ?\n                        errorMap[0] :\n                        errorMap[errorCode];\n                }\n\n                // Ensure that changing the flag always updates the model\n                ko.utils.triggerEvent(target[0], 'change');\n\n                return isValid;\n            }\n        };\n\n        validator.addRule(\n            'validate-phone-number',\n            validatorObj.validate,\n            $.mage.__(validatorObj.message)\n        );\n\n        return validator;\n    };\n});\n","Dotdigitalgroup_Sms/js/telephoneValidatorAddress.js":"define([\n    'jquery',\n    'intlTelInput',\n    'jquery/validate'\n], function ($, intlTelInput) {\n    'use strict';\n\n    var errorMap = [\n            'Invalid telephone number',\n            'Invalid country code',\n            'Telephone number is too short',\n            'Telephone number is too long',\n            'Invalid telephone number'\n        ],\n        validatorObj = {\n            validate: function (value) {\n                var countryCodeClass = $('.iti__selected-flag .iti__flag').attr('class'),\n                    countryCode,\n                    isValid,\n                    errorCode;\n\n                countryCodeClass = countryCodeClass.split(' ')[1];\n\n                if (countryCodeClass === undefined) {\n                    $.validator.messages['validate-phone-number'] = errorMap[1];\n\n                    return false;\n                }\n\n                countryCode = countryCodeClass.split('__')[1];\n                isValid = intlTelInputUtils.isValidNumber(value, countryCode);\n\n                if (!isValid) {\n                    errorCode = window.intlTelInputUtils.getValidationError(value, countryCode);\n\n                    $.validator.messages['validate-phone-number'] = typeof errorMap[errorCode] === 'undefined' ?\n                        errorMap[0] :\n                        errorMap[errorCode];\n                }\n\n                return isValid;\n            }\n        };\n\n    $.validator.addMethod(\n        'validate-phone-number',\n        validatorObj.validate,\n        $.validator.messages['validate-phone-number']\n    );\n\n    return function (widget) {\n        return widget;\n    };\n});\n","Dotdigitalgroup_Sms/js/intlTelInput.js":"/*\n * International Telephone Input v17.0.8\n * https://github.com/jackocnr/intl-tel-input.git\n * Licensed under the MIT license\n */\n\n// wrap in UMD\n(function(factory) {\n    if (typeof module === \"object\" && module.exports) module.exports = factory(); else window.intlTelInput = factory();\n})(function(undefined) {\n    \"use strict\";\n    return function() {\n        // Array of country objects for the flag dropdown.\n        // Here is the criteria for the plugin to support a given country/territory\n        // - It has an iso2 code: https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2\n        // - It has it's own country calling code (it is not a sub-region of another country): https://en.wikipedia.org/wiki/List_of_country_calling_codes\n        // - It has a flag in the region-flags project: https://github.com/behdad/region-flags/tree/gh-pages/png\n        // - It is supported by libphonenumber (it must be listed on this page): https://github.com/googlei18n/libphonenumber/blob/master/resources/ShortNumberMetadata.xml\n        // Each country array has the following information:\n        // [\n        //    Country name,\n        //    iso2 code,\n        //    International dial code,\n        //    Order (if >1 country with same dial code),\n        //    Area codes\n        // ]\n        var allCountries = [ [ \"Afghanistan (\u202b\u0627\u0641\u063a\u0627\u0646\u0633\u062a\u0627\u0646\u202c\u200e)\", \"af\", \"93\" ], [ \"Albania (Shqip\u00ebri)\", \"al\", \"355\" ], [ \"Algeria (\u202b\u0627\u0644\u062c\u0632\u0627\u0626\u0631\u202c\u200e)\", \"dz\", \"213\" ], [ \"American Samoa\", \"as\", \"1\", 5, [ \"684\" ] ], [ \"Andorra\", \"ad\", \"376\" ], [ \"Angola\", \"ao\", \"244\" ], [ \"Anguilla\", \"ai\", \"1\", 6, [ \"264\" ] ], [ \"Antigua and Barbuda\", \"ag\", \"1\", 7, [ \"268\" ] ], [ \"Argentina\", \"ar\", \"54\" ], [ \"Armenia (\u0540\u0561\u0575\u0561\u057d\u057f\u0561\u0576)\", \"am\", \"374\" ], [ \"Aruba\", \"aw\", \"297\" ], [ \"Australia\", \"au\", \"61\", 0 ], [ \"Austria (\u00d6sterreich)\", \"at\", \"43\" ], [ \"Azerbaijan (Az\u0259rbaycan)\", \"az\", \"994\" ], [ \"Bahamas\", \"bs\", \"1\", 8, [ \"242\" ] ], [ \"Bahrain (\u202b\u0627\u0644\u0628\u062d\u0631\u064a\u0646\u202c\u200e)\", \"bh\", \"973\" ], [ \"Bangladesh (\u09ac\u09be\u0982\u09b2\u09be\u09a6\u09c7\u09b6)\", \"bd\", \"880\" ], [ \"Barbados\", \"bb\", \"1\", 9, [ \"246\" ] ], [ \"Belarus (\u0411\u0435\u043b\u0430\u0440\u0443\u0441\u044c)\", \"by\", \"375\" ], [ \"Belgium (Belgi\u00eb)\", \"be\", \"32\" ], [ \"Belize\", \"bz\", \"501\" ], [ \"Benin (B\u00e9nin)\", \"bj\", \"229\" ], [ \"Bermuda\", \"bm\", \"1\", 10, [ \"441\" ] ], [ \"Bhutan (\u0f60\u0f56\u0fb2\u0f74\u0f42)\", \"bt\", \"975\" ], [ \"Bolivia\", \"bo\", \"591\" ], [ \"Bosnia and Herzegovina (\u0411\u043e\u0441\u043d\u0430 \u0438 \u0425\u0435\u0440\u0446\u0435\u0433\u043e\u0432\u0438\u043d\u0430)\", \"ba\", \"387\" ], [ \"Botswana\", \"bw\", \"267\" ], [ \"Brazil (Brasil)\", \"br\", \"55\" ], [ \"British Indian Ocean Territory\", \"io\", \"246\" ], [ \"British Virgin Islands\", \"vg\", \"1\", 11, [ \"284\" ] ], [ \"Brunei\", \"bn\", \"673\" ], [ \"Bulgaria (\u0411\u044a\u043b\u0433\u0430\u0440\u0438\u044f)\", \"bg\", \"359\" ], [ \"Burkina Faso\", \"bf\", \"226\" ], [ \"Burundi (Uburundi)\", \"bi\", \"257\" ], [ \"Cambodia (\u1780\u1798\u17d2\u1796\u17bb\u1787\u17b6)\", \"kh\", \"855\" ], [ \"Cameroon (Cameroun)\", \"cm\", \"237\" ], [ \"Canada\", \"ca\", \"1\", 1, [ \"204\", \"226\", \"236\", \"249\", \"250\", \"289\", \"306\", \"343\", \"365\", \"387\", \"403\", \"416\", \"418\", \"431\", \"437\", \"438\", \"450\", \"506\", \"514\", \"519\", \"548\", \"579\", \"581\", \"587\", \"604\", \"613\", \"639\", \"647\", \"672\", \"705\", \"709\", \"742\", \"778\", \"780\", \"782\", \"807\", \"819\", \"825\", \"867\", \"873\", \"902\", \"905\" ] ], [ \"Cape Verde (Kabu Verdi)\", \"cv\", \"238\" ], [ \"Caribbean Netherlands\", \"bq\", \"599\", 1, [ \"3\", \"4\", \"7\" ] ], [ \"Cayman Islands\", \"ky\", \"1\", 12, [ \"345\" ] ], [ \"Central African Republic (R\u00e9publique centrafricaine)\", \"cf\", \"236\" ], [ \"Chad (Tchad)\", \"td\", \"235\" ], [ \"Chile\", \"cl\", \"56\" ], [ \"China (\u4e2d\u56fd)\", \"cn\", \"86\" ], [ \"Christmas Island\", \"cx\", \"61\", 2, [ \"89164\" ] ], [ \"Cocos (Keeling) Islands\", \"cc\", \"61\", 1, [ \"89162\" ] ], [ \"Colombia\", \"co\", \"57\" ], [ \"Comoros (\u202b\u062c\u0632\u0631 \u0627\u0644\u0642\u0645\u0631\u202c\u200e)\", \"km\", \"269\" ], [ \"Congo (DRC) (Jamhuri ya Kidemokrasia ya Kongo)\", \"cd\", \"243\" ], [ \"Congo (Republic) (Congo-Brazzaville)\", \"cg\", \"242\" ], [ \"Cook Islands\", \"ck\", \"682\" ], [ \"Costa Rica\", \"cr\", \"506\" ], [ \"C\u00f4te d\u2019Ivoire\", \"ci\", \"225\" ], [ \"Croatia (Hrvatska)\", \"hr\", \"385\" ], [ \"Cuba\", \"cu\", \"53\" ], [ \"Cura\u00e7ao\", \"cw\", \"599\", 0 ], [ \"Cyprus (\u039a\u03cd\u03c0\u03c1\u03bf\u03c2)\", \"cy\", \"357\" ], [ \"Czech Republic (\u010cesk\u00e1 republika)\", \"cz\", \"420\" ], [ \"Denmark (Danmark)\", \"dk\", \"45\" ], [ \"Djibouti\", \"dj\", \"253\" ], [ \"Dominica\", \"dm\", \"1\", 13, [ \"767\" ] ], [ \"Dominican Republic (Rep\u00fablica Dominicana)\", \"do\", \"1\", 2, [ \"809\", \"829\", \"849\" ] ], [ \"Ecuador\", \"ec\", \"593\" ], [ \"Egypt (\u202b\u0645\u0635\u0631\u202c\u200e)\", \"eg\", \"20\" ], [ \"El Salvador\", \"sv\", \"503\" ], [ \"Equatorial Guinea (Guinea Ecuatorial)\", \"gq\", \"240\" ], [ \"Eritrea\", \"er\", \"291\" ], [ \"Estonia (Eesti)\", \"ee\", \"372\" ], [ \"Eswatini\", \"sz\", \"268\" ], [ \"Ethiopia\", \"et\", \"251\" ], [ \"Falkland Islands (Islas Malvinas)\", \"fk\", \"500\" ], [ \"Faroe Islands (F\u00f8royar)\", \"fo\", \"298\" ], [ \"Fiji\", \"fj\", \"679\" ], [ \"Finland (Suomi)\", \"fi\", \"358\", 0 ], [ \"France\", \"fr\", \"33\" ], [ \"French Guiana (Guyane fran\u00e7aise)\", \"gf\", \"594\" ], [ \"French Polynesia (Polyn\u00e9sie fran\u00e7aise)\", \"pf\", \"689\" ], [ \"Gabon\", \"ga\", \"241\" ], [ \"Gambia\", \"gm\", \"220\" ], [ \"Georgia (\u10e1\u10d0\u10e5\u10d0\u10e0\u10d7\u10d5\u10d4\u10da\u10dd)\", \"ge\", \"995\" ], [ \"Germany (Deutschland)\", \"de\", \"49\" ], [ \"Ghana (Gaana)\", \"gh\", \"233\" ], [ \"Gibraltar\", \"gi\", \"350\" ], [ \"Greece (\u0395\u03bb\u03bb\u03ac\u03b4\u03b1)\", \"gr\", \"30\" ], [ \"Greenland (Kalaallit Nunaat)\", \"gl\", \"299\" ], [ \"Grenada\", \"gd\", \"1\", 14, [ \"473\" ] ], [ \"Guadeloupe\", \"gp\", \"590\", 0 ], [ \"Guam\", \"gu\", \"1\", 15, [ \"671\" ] ], [ \"Guatemala\", \"gt\", \"502\" ], [ \"Guernsey\", \"gg\", \"44\", 1, [ \"1481\", \"7781\", \"7839\", \"7911\" ] ], [ \"Guinea (Guin\u00e9e)\", \"gn\", \"224\" ], [ \"Guinea-Bissau (Guin\u00e9 Bissau)\", \"gw\", \"245\" ], [ \"Guyana\", \"gy\", \"592\" ], [ \"Haiti\", \"ht\", \"509\" ], [ \"Honduras\", \"hn\", \"504\" ], [ \"Hong Kong (\u9999\u6e2f)\", \"hk\", \"852\" ], [ \"Hungary (Magyarorsz\u00e1g)\", \"hu\", \"36\" ], [ \"Iceland (\u00cdsland)\", \"is\", \"354\" ], [ \"India (\u092d\u093e\u0930\u0924)\", \"in\", \"91\" ], [ \"Indonesia\", \"id\", \"62\" ], [ \"Iran (\u202b\u0627\u06cc\u0631\u0627\u0646\u202c\u200e)\", \"ir\", \"98\" ], [ \"Iraq (\u202b\u0627\u0644\u0639\u0631\u0627\u0642\u202c\u200e)\", \"iq\", \"964\" ], [ \"Ireland\", \"ie\", \"353\" ], [ \"Isle of Man\", \"im\", \"44\", 2, [ \"1624\", \"74576\", \"7524\", \"7924\", \"7624\" ] ], [ \"Israel (\u202b\u05d9\u05e9\u05e8\u05d0\u05dc\u202c\u200e)\", \"il\", \"972\" ], [ \"Italy (Italia)\", \"it\", \"39\", 0 ], [ \"Jamaica\", \"jm\", \"1\", 4, [ \"876\", \"658\" ] ], [ \"Japan (\u65e5\u672c)\", \"jp\", \"81\" ], [ \"Jersey\", \"je\", \"44\", 3, [ \"1534\", \"7509\", \"7700\", \"7797\", \"7829\", \"7937\" ] ], [ \"Jordan (\u202b\u0627\u0644\u0623\u0631\u062f\u0646\u202c\u200e)\", \"jo\", \"962\" ], [ \"Kazakhstan (\u041a\u0430\u0437\u0430\u0445\u0441\u0442\u0430\u043d)\", \"kz\", \"7\", 1, [ \"33\", \"7\" ] ], [ \"Kenya\", \"ke\", \"254\" ], [ \"Kiribati\", \"ki\", \"686\" ], [ \"Kosovo\", \"xk\", \"383\" ], [ \"Kuwait (\u202b\u0627\u0644\u0643\u0648\u064a\u062a\u202c\u200e)\", \"kw\", \"965\" ], [ \"Kyrgyzstan (\u041a\u044b\u0440\u0433\u044b\u0437\u0441\u0442\u0430\u043d)\", \"kg\", \"996\" ], [ \"Laos (\u0ea5\u0eb2\u0ea7)\", \"la\", \"856\" ], [ \"Latvia (Latvija)\", \"lv\", \"371\" ], [ \"Lebanon (\u202b\u0644\u0628\u0646\u0627\u0646\u202c\u200e)\", \"lb\", \"961\" ], [ \"Lesotho\", \"ls\", \"266\" ], [ \"Liberia\", \"lr\", \"231\" ], [ \"Libya (\u202b\u0644\u064a\u0628\u064a\u0627\u202c\u200e)\", \"ly\", \"218\" ], [ \"Liechtenstein\", \"li\", \"423\" ], [ \"Lithuania (Lietuva)\", \"lt\", \"370\" ], [ \"Luxembourg\", \"lu\", \"352\" ], [ \"Macau (\u6fb3\u9580)\", \"mo\", \"853\" ], [ \"Macedonia (FYROM) (\u041c\u0430\u043a\u0435\u0434\u043e\u043d\u0438\u0458\u0430)\", \"mk\", \"389\" ], [ \"Madagascar (Madagasikara)\", \"mg\", \"261\" ], [ \"Malawi\", \"mw\", \"265\" ], [ \"Malaysia\", \"my\", \"60\" ], [ \"Maldives\", \"mv\", \"960\" ], [ \"Mali\", \"ml\", \"223\" ], [ \"Malta\", \"mt\", \"356\" ], [ \"Marshall Islands\", \"mh\", \"692\" ], [ \"Martinique\", \"mq\", \"596\" ], [ \"Mauritania (\u202b\u0645\u0648\u0631\u064a\u062a\u0627\u0646\u064a\u0627\u202c\u200e)\", \"mr\", \"222\" ], [ \"Mauritius (Moris)\", \"mu\", \"230\" ], [ \"Mayotte\", \"yt\", \"262\", 1, [ \"269\", \"639\" ] ], [ \"Mexico (M\u00e9xico)\", \"mx\", \"52\" ], [ \"Micronesia\", \"fm\", \"691\" ], [ \"Moldova (Republica Moldova)\", \"md\", \"373\" ], [ \"Monaco\", \"mc\", \"377\" ], [ \"Mongolia (\u041c\u043e\u043d\u0433\u043e\u043b)\", \"mn\", \"976\" ], [ \"Montenegro (Crna Gora)\", \"me\", \"382\" ], [ \"Montserrat\", \"ms\", \"1\", 16, [ \"664\" ] ], [ \"Morocco (\u202b\u0627\u0644\u0645\u063a\u0631\u0628\u202c\u200e)\", \"ma\", \"212\", 0 ], [ \"Mozambique (Mo\u00e7ambique)\", \"mz\", \"258\" ], [ \"Myanmar (Burma) (\u1019\u103c\u1014\u103a\u1019\u102c)\", \"mm\", \"95\" ], [ \"Namibia (Namibi\u00eb)\", \"na\", \"264\" ], [ \"Nauru\", \"nr\", \"674\" ], [ \"Nepal (\u0928\u0947\u092a\u093e\u0932)\", \"np\", \"977\" ], [ \"Netherlands (Nederland)\", \"nl\", \"31\" ], [ \"New Caledonia (Nouvelle-Cal\u00e9donie)\", \"nc\", \"687\" ], [ \"New Zealand\", \"nz\", \"64\" ], [ \"Nicaragua\", \"ni\", \"505\" ], [ \"Niger (Nijar)\", \"ne\", \"227\" ], [ \"Nigeria\", \"ng\", \"234\" ], [ \"Niue\", \"nu\", \"683\" ], [ \"Norfolk Island\", \"nf\", \"672\" ], [ \"North Korea (\uc870\uc120 \ubbfc\uc8fc\uc8fc\uc758 \uc778\ubbfc \uacf5\ud654\uad6d)\", \"kp\", \"850\" ], [ \"Northern Mariana Islands\", \"mp\", \"1\", 17, [ \"670\" ] ], [ \"Norway (Norge)\", \"no\", \"47\", 0 ], [ \"Oman (\u202b\u0639\u064f\u0645\u0627\u0646\u202c\u200e)\", \"om\", \"968\" ], [ \"Pakistan (\u202b\u067e\u0627\u06a9\u0633\u062a\u0627\u0646\u202c\u200e)\", \"pk\", \"92\" ], [ \"Palau\", \"pw\", \"680\" ], [ \"Palestine (\u202b\u0641\u0644\u0633\u0637\u064a\u0646\u202c\u200e)\", \"ps\", \"970\" ], [ \"Panama (Panam\u00e1)\", \"pa\", \"507\" ], [ \"Papua New Guinea\", \"pg\", \"675\" ], [ \"Paraguay\", \"py\", \"595\" ], [ \"Peru (Per\u00fa)\", \"pe\", \"51\" ], [ \"Philippines\", \"ph\", \"63\" ], [ \"Poland (Polska)\", \"pl\", \"48\" ], [ \"Portugal\", \"pt\", \"351\" ], [ \"Puerto Rico\", \"pr\", \"1\", 3, [ \"787\", \"939\" ] ], [ \"Qatar (\u202b\u0642\u0637\u0631\u202c\u200e)\", \"qa\", \"974\" ], [ \"R\u00e9union (La R\u00e9union)\", \"re\", \"262\", 0 ], [ \"Romania (Rom\u00e2nia)\", \"ro\", \"40\" ], [ \"Russia (\u0420\u043e\u0441\u0441\u0438\u044f)\", \"ru\", \"7\", 0 ], [ \"Rwanda\", \"rw\", \"250\" ], [ \"Saint Barth\u00e9lemy\", \"bl\", \"590\", 1 ], [ \"Saint Helena\", \"sh\", \"290\" ], [ \"Saint Kitts and Nevis\", \"kn\", \"1\", 18, [ \"869\" ] ], [ \"Saint Lucia\", \"lc\", \"1\", 19, [ \"758\" ] ], [ \"Saint Martin (Saint-Martin (partie fran\u00e7aise))\", \"mf\", \"590\", 2 ], [ \"Saint Pierre and Miquelon (Saint-Pierre-et-Miquelon)\", \"pm\", \"508\" ], [ \"Saint Vincent and the Grenadines\", \"vc\", \"1\", 20, [ \"784\" ] ], [ \"Samoa\", \"ws\", \"685\" ], [ \"San Marino\", \"sm\", \"378\" ], [ \"S\u00e3o Tom\u00e9 and Pr\u00edncipe (S\u00e3o Tom\u00e9 e Pr\u00edncipe)\", \"st\", \"239\" ], [ \"Saudi Arabia (\u202b\u0627\u0644\u0645\u0645\u0644\u0643\u0629 \u0627\u0644\u0639\u0631\u0628\u064a\u0629 \u0627\u0644\u0633\u0639\u0648\u062f\u064a\u0629\u202c\u200e)\", \"sa\", \"966\" ], [ \"Senegal (S\u00e9n\u00e9gal)\", \"sn\", \"221\" ], [ \"Serbia (\u0421\u0440\u0431\u0438\u0458\u0430)\", \"rs\", \"381\" ], [ \"Seychelles\", \"sc\", \"248\" ], [ \"Sierra Leone\", \"sl\", \"232\" ], [ \"Singapore\", \"sg\", \"65\" ], [ \"Sint Maarten\", \"sx\", \"1\", 21, [ \"721\" ] ], [ \"Slovakia (Slovensko)\", \"sk\", \"421\" ], [ \"Slovenia (Slovenija)\", \"si\", \"386\" ], [ \"Solomon Islands\", \"sb\", \"677\" ], [ \"Somalia (Soomaaliya)\", \"so\", \"252\" ], [ \"South Africa\", \"za\", \"27\" ], [ \"South Korea (\ub300\ud55c\ubbfc\uad6d)\", \"kr\", \"82\" ], [ \"South Sudan (\u202b\u062c\u0646\u0648\u0628 \u0627\u0644\u0633\u0648\u062f\u0627\u0646\u202c\u200e)\", \"ss\", \"211\" ], [ \"Spain (Espa\u00f1a)\", \"es\", \"34\" ], [ \"Sri Lanka (\u0dc1\u0dca\u200d\u0dbb\u0dd3 \u0dbd\u0d82\u0d9a\u0dcf\u0dc0)\", \"lk\", \"94\" ], [ \"Sudan (\u202b\u0627\u0644\u0633\u0648\u062f\u0627\u0646\u202c\u200e)\", \"sd\", \"249\" ], [ \"Suriname\", \"sr\", \"597\" ], [ \"Svalbard and Jan Mayen\", \"sj\", \"47\", 1, [ \"79\" ] ], [ \"Sweden (Sverige)\", \"se\", \"46\" ], [ \"Switzerland (Schweiz)\", \"ch\", \"41\" ], [ \"Syria (\u202b\u0633\u0648\u0631\u064a\u0627\u202c\u200e)\", \"sy\", \"963\" ], [ \"Taiwan (\u53f0\u7063)\", \"tw\", \"886\" ], [ \"Tajikistan\", \"tj\", \"992\" ], [ \"Tanzania\", \"tz\", \"255\" ], [ \"Thailand (\u0e44\u0e17\u0e22)\", \"th\", \"66\" ], [ \"Timor-Leste\", \"tl\", \"670\" ], [ \"Togo\", \"tg\", \"228\" ], [ \"Tokelau\", \"tk\", \"690\" ], [ \"Tonga\", \"to\", \"676\" ], [ \"Trinidad and Tobago\", \"tt\", \"1\", 22, [ \"868\" ] ], [ \"Tunisia (\u202b\u062a\u0648\u0646\u0633\u202c\u200e)\", \"tn\", \"216\" ], [ \"Turkey (T\u00fcrkiye)\", \"tr\", \"90\" ], [ \"Turkmenistan\", \"tm\", \"993\" ], [ \"Turks and Caicos Islands\", \"tc\", \"1\", 23, [ \"649\" ] ], [ \"Tuvalu\", \"tv\", \"688\" ], [ \"U.S. Virgin Islands\", \"vi\", \"1\", 24, [ \"340\" ] ], [ \"Uganda\", \"ug\", \"256\" ], [ \"Ukraine (\u0423\u043a\u0440\u0430\u0457\u043d\u0430)\", \"ua\", \"380\" ], [ \"United Arab Emirates (\u202b\u0627\u0644\u0625\u0645\u0627\u0631\u0627\u062a \u0627\u0644\u0639\u0631\u0628\u064a\u0629 \u0627\u0644\u0645\u062a\u062d\u062f\u0629\u202c\u200e)\", \"ae\", \"971\" ], [ \"United Kingdom\", \"gb\", \"44\", 0 ], [ \"United States\", \"us\", \"1\", 0 ], [ \"Uruguay\", \"uy\", \"598\" ], [ \"Uzbekistan (O\u02bbzbekiston)\", \"uz\", \"998\" ], [ \"Vanuatu\", \"vu\", \"678\" ], [ \"Vatican City (Citt\u00e0 del Vaticano)\", \"va\", \"39\", 1, [ \"06698\" ] ], [ \"Venezuela\", \"ve\", \"58\" ], [ \"Vietnam (Vi\u1ec7t Nam)\", \"vn\", \"84\" ], [ \"Wallis and Futuna (Wallis-et-Futuna)\", \"wf\", \"681\" ], [ \"Western Sahara (\u202b\u0627\u0644\u0635\u062d\u0631\u0627\u0621 \u0627\u0644\u063a\u0631\u0628\u064a\u0629\u202c\u200e)\", \"eh\", \"212\", 1, [ \"5288\", \"5289\" ] ], [ \"Yemen (\u202b\u0627\u0644\u064a\u0645\u0646\u202c\u200e)\", \"ye\", \"967\" ], [ \"Zambia\", \"zm\", \"260\" ], [ \"Zimbabwe\", \"zw\", \"263\" ], [ \"\u00c5land Islands\", \"ax\", \"358\", 1, [ \"18\" ] ] ];\n        // loop over all of the countries above, restructuring the data to be objects with named keys\n        for (var i = 0; i < allCountries.length; i++) {\n            var c = allCountries[i];\n            allCountries[i] = {\n                name: c[0],\n                iso2: c[1],\n                dialCode: c[2],\n                priority: c[3] || 0,\n                areaCodes: c[4] || null\n            };\n        }\n        \"use strict\";\n        function _classCallCheck(instance, Constructor) {\n            if (!(instance instanceof Constructor)) {\n                throw new TypeError(\"Cannot call a class as a function\");\n            }\n        }\n        function _defineProperties(target, props) {\n            for (var i = 0; i < props.length; i++) {\n                var descriptor = props[i];\n                descriptor.enumerable = descriptor.enumerable || false;\n                descriptor.configurable = true;\n                if (\"value\" in descriptor) descriptor.writable = true;\n                Object.defineProperty(target, descriptor.key, descriptor);\n            }\n        }\n        function _createClass(Constructor, protoProps, staticProps) {\n            if (protoProps) _defineProperties(Constructor.prototype, protoProps);\n            if (staticProps) _defineProperties(Constructor, staticProps);\n            return Constructor;\n        }\n        var intlTelInputGlobals = {\n            getInstance: function getInstance(input) {\n                var id = input.getAttribute(\"data-intl-tel-input-id\");\n                return window.intlTelInputGlobals.instances[id];\n            },\n            instances: {},\n            // using a global like this allows us to mock it in the tests\n            documentReady: function documentReady() {\n                return document.readyState === \"complete\";\n            }\n        };\n        if (typeof window === \"object\") window.intlTelInputGlobals = intlTelInputGlobals;\n        // these vars persist through all instances of the plugin\n        var id = 0;\n        var defaults = {\n            // whether or not to allow the dropdown\n            allowDropdown: true,\n            // if there is just a dial code in the input: remove it on blur\n            autoHideDialCode: true,\n            // add a placeholder in the input with an example number for the selected country\n            autoPlaceholder: \"polite\",\n            // modify the parentClass\n            customContainer: \"\",\n            // modify the auto placeholder\n            customPlaceholder: null,\n            // append menu to specified element\n            dropdownContainer: null,\n            // don't display these countries\n            excludeCountries: [],\n            // format the input value during initialisation and on setNumber\n            formatOnDisplay: true,\n            // geoIp lookup function\n            geoIpLookup: null,\n            // inject a hidden input with this name, and on submit, populate it with the result of getNumber\n            hiddenInput: \"\",\n            // initial country\n            initialCountry: \"\",\n            // localized country names e.g. { 'de': 'Deutschland' }\n            localizedCountries: null,\n            // don't insert international dial codes\n            nationalMode: true,\n            // display only these countries\n            onlyCountries: [],\n            // number type to use for placeholders\n            placeholderNumberType: \"MOBILE\",\n            // the countries at the top of the list. defaults to united states and united kingdom\n            preferredCountries: [ \"us\", \"gb\" ],\n            // display the country dial code next to the selected flag so it's not part of the typed number\n            separateDialCode: false,\n            // specify the path to the libphonenumber script to enable validation/formatting\n            utilsScript: \"\"\n        };\n        // https://en.wikipedia.org/wiki/List_of_North_American_Numbering_Plan_area_codes#Non-geographic_area_codes\n        var regionlessNanpNumbers = [ \"800\", \"822\", \"833\", \"844\", \"855\", \"866\", \"877\", \"880\", \"881\", \"882\", \"883\", \"884\", \"885\", \"886\", \"887\", \"888\", \"889\" ];\n        // utility function to iterate over an object. can't use Object.entries or native forEach because\n        // of IE11\n        var forEachProp = function forEachProp(obj, callback) {\n            var keys = Object.keys(obj);\n            for (var i = 0; i < keys.length; i++) {\n                callback(keys[i], obj[keys[i]]);\n            }\n        };\n        // run a method on each instance of the plugin\n        var forEachInstance = function forEachInstance(method) {\n            forEachProp(window.intlTelInputGlobals.instances, function(key) {\n                window.intlTelInputGlobals.instances[key][method]();\n            });\n        };\n        // this is our plugin class that we will create an instance of\n        // eslint-disable-next-line no-unused-vars\n        var Iti = /*#__PURE__*/\n            function() {\n                function Iti(input, options) {\n                    var _this = this;\n                    _classCallCheck(this, Iti);\n                    this.id = id++;\n                    this.telInput = input;\n                    this.activeItem = null;\n                    this.highlightedItem = null;\n                    // process specified options / defaults\n                    // alternative to Object.assign, which isn't supported by IE11\n                    var customOptions = options || {};\n                    this.options = {};\n                    forEachProp(defaults, function(key, value) {\n                        _this.options[key] = customOptions.hasOwnProperty(key) ? customOptions[key] : value;\n                    });\n                    this.hadInitialPlaceholder = Boolean(input.getAttribute(\"placeholder\"));\n                }\n                _createClass(Iti, [ {\n                    key: \"_init\",\n                    value: function _init() {\n                        var _this2 = this;\n                        // if in nationalMode, disable options relating to dial codes\n                        if (this.options.nationalMode) this.options.autoHideDialCode = false;\n                        // if separateDialCode then doesn't make sense to A) insert dial code into input\n                        // (autoHideDialCode), and B) display national numbers (because we're displaying the country\n                        // dial code next to them)\n                        if (this.options.separateDialCode) {\n                            this.options.autoHideDialCode = this.options.nationalMode = false;\n                        }\n                        // we cannot just test screen size as some smartphones/website meta tags will report desktop\n                        // resolutions\n                        // Note: for some reason jasmine breaks if you put this in the main Plugin function with the\n                        // rest of these declarations\n                        // Note: to target Android Mobiles (and not Tablets), we must find 'Android' and 'Mobile'\n                        this.isMobile = /Android.+Mobile|webOS|iPhone|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent);\n                        if (this.isMobile) {\n                            // trigger the mobile dropdown css\n                            document.body.classList.add(\"iti-mobile\");\n                            // on mobile, we want a full screen dropdown, so we must append it to the body\n                            if (!this.options.dropdownContainer) this.options.dropdownContainer = document.body;\n                        }\n                        // these promises get resolved when their individual requests complete\n                        // this way the dev can do something like iti.promise.then(...) to know when all requests are\n                        // complete\n                        if (typeof Promise !== \"undefined\") {\n                            var autoCountryPromise = new Promise(function(resolve, reject) {\n                                _this2.resolveAutoCountryPromise = resolve;\n                                _this2.rejectAutoCountryPromise = reject;\n                            });\n                            var utilsScriptPromise = new Promise(function(resolve, reject) {\n                                _this2.resolveUtilsScriptPromise = resolve;\n                                _this2.rejectUtilsScriptPromise = reject;\n                            });\n                            this.promise = Promise.all([ autoCountryPromise, utilsScriptPromise ]);\n                        } else {\n                            // prevent errors when Promise doesn't exist\n                            this.resolveAutoCountryPromise = this.rejectAutoCountryPromise = function() {};\n                            this.resolveUtilsScriptPromise = this.rejectUtilsScriptPromise = function() {};\n                        }\n                        // in various situations there could be no country selected initially, but we need to be able\n                        // to assume this variable exists\n                        this.selectedCountryData = {};\n                        // process all the data: onlyCountries, excludeCountries, preferredCountries etc\n                        this._processCountryData();\n                        // generate the markup\n                        this._generateMarkup();\n                        // set the initial state of the input value and the selected flag\n                        this._setInitialState();\n                        // start all of the event listeners: autoHideDialCode, input keydown, selectedFlag click\n                        this._initListeners();\n                        // utils script, and auto country\n                        this._initRequests();\n                    }\n                }, {\n                    key: \"_processCountryData\",\n                    value: function _processCountryData() {\n                        // process onlyCountries or excludeCountries array if present\n                        this._processAllCountries();\n                        // process the countryCodes map\n                        this._processCountryCodes();\n                        // process the preferredCountries\n                        this._processPreferredCountries();\n                        // translate countries according to localizedCountries option\n                        if (this.options.localizedCountries) this._translateCountriesByLocale();\n                        // sort countries by name\n                        if (this.options.onlyCountries.length || this.options.localizedCountries) {\n                            this.countries.sort(this._countryNameSort);\n                        }\n                    }\n                }, {\n                    key: \"_addCountryCode\",\n                    value: function _addCountryCode(iso2, countryCode, priority) {\n                        if (countryCode.length > this.countryCodeMaxLen) {\n                            this.countryCodeMaxLen = countryCode.length;\n                        }\n                        if (!this.countryCodes.hasOwnProperty(countryCode)) {\n                            this.countryCodes[countryCode] = [];\n                        }\n                        // bail if we already have this country for this countryCode\n                        for (var i = 0; i < this.countryCodes[countryCode].length; i++) {\n                            if (this.countryCodes[countryCode][i] === iso2) return;\n                        }\n                        // check for undefined as 0 is falsy\n                        var index = priority !== undefined ? priority : this.countryCodes[countryCode].length;\n                        this.countryCodes[countryCode][index] = iso2;\n                    }\n                }, {\n                    key: \"_processAllCountries\",\n                    value: function _processAllCountries() {\n                        if (this.options.onlyCountries.length) {\n                            var lowerCaseOnlyCountries = this.options.onlyCountries.map(function(country) {\n                                return country.toLowerCase();\n                            });\n                            this.countries = allCountries.filter(function(country) {\n                                return lowerCaseOnlyCountries.indexOf(country.iso2) > -1;\n                            });\n                        } else if (this.options.excludeCountries.length) {\n                            var lowerCaseExcludeCountries = this.options.excludeCountries.map(function(country) {\n                                return country.toLowerCase();\n                            });\n                            this.countries = allCountries.filter(function(country) {\n                                return lowerCaseExcludeCountries.indexOf(country.iso2) === -1;\n                            });\n                        } else {\n                            this.countries = allCountries;\n                        }\n                    }\n                }, {\n                    key: \"_translateCountriesByLocale\",\n                    value: function _translateCountriesByLocale() {\n                        for (var i = 0; i < this.countries.length; i++) {\n                            var iso = this.countries[i].iso2.toLowerCase();\n                            if (this.options.localizedCountries.hasOwnProperty(iso)) {\n                                this.countries[i].name = this.options.localizedCountries[iso];\n                            }\n                        }\n                    }\n                }, {\n                    key: \"_countryNameSort\",\n                    value: function _countryNameSort(a, b) {\n                        return a.name.localeCompare(b.name);\n                    }\n                }, {\n                    key: \"_processCountryCodes\",\n                    value: function _processCountryCodes() {\n                        this.countryCodeMaxLen = 0;\n                        // here we store just dial codes\n                        this.dialCodes = {};\n                        // here we store \"country codes\" (both dial codes and their area codes)\n                        this.countryCodes = {};\n                        // first: add dial codes\n                        for (var i = 0; i < this.countries.length; i++) {\n                            var c = this.countries[i];\n                            if (!this.dialCodes[c.dialCode]) this.dialCodes[c.dialCode] = true;\n                            this._addCountryCode(c.iso2, c.dialCode, c.priority);\n                        }\n                        // next: add area codes\n                        // this is a second loop over countries, to make sure we have all of the \"root\" countries\n                        // already in the map, so that we can access them, as each time we add an area code substring\n                        // to the map, we also need to include the \"root\" country's code, as that also matches\n                        for (var _i = 0; _i < this.countries.length; _i++) {\n                            var _c = this.countries[_i];\n                            // area codes\n                            if (_c.areaCodes) {\n                                var rootCountryCode = this.countryCodes[_c.dialCode][0];\n                                // for each area code\n                                for (var j = 0; j < _c.areaCodes.length; j++) {\n                                    var areaCode = _c.areaCodes[j];\n                                    // for each digit in the area code to add all partial matches as well\n                                    for (var k = 1; k < areaCode.length; k++) {\n                                        var partialDialCode = _c.dialCode + areaCode.substr(0, k);\n                                        // start with the root country, as that also matches this dial code\n                                        this._addCountryCode(rootCountryCode, partialDialCode);\n                                        this._addCountryCode(_c.iso2, partialDialCode);\n                                    }\n                                    // add the full area code\n                                    this._addCountryCode(_c.iso2, _c.dialCode + areaCode);\n                                }\n                            }\n                        }\n                    }\n                }, {\n                    key: \"_processPreferredCountries\",\n                    value: function _processPreferredCountries() {\n                        this.preferredCountries = [];\n                        for (var i = 0; i < this.options.preferredCountries.length; i++) {\n                            var countryCode = this.options.preferredCountries[i].toLowerCase();\n                            var countryData = this._getCountryData(countryCode, false, true);\n                            if (countryData) this.preferredCountries.push(countryData);\n                        }\n                    }\n                }, {\n                    key: \"_createEl\",\n                    value: function _createEl(name, attrs, container) {\n                        var el = document.createElement(name);\n                        if (attrs) forEachProp(attrs, function(key, value) {\n                            return el.setAttribute(key, value);\n                        });\n                        if (container) container.appendChild(el);\n                        return el;\n                    }\n                }, {\n                    key: \"_generateMarkup\",\n                    value: function _generateMarkup() {\n                        // if autocomplete does not exist on the element and its form, then\n                        // prevent autocomplete as there's no safe, cross-browser event we can react to, so it can\n                        // easily put the plugin in an inconsistent state e.g. the wrong flag selected for the\n                        // autocompleted number, which on submit could mean wrong number is saved (esp in nationalMode)\n                        if (!this.telInput.hasAttribute(\"autocomplete\") && !(this.telInput.form && this.telInput.form.hasAttribute(\"autocomplete\"))) {\n                            this.telInput.setAttribute(\"autocomplete\", \"off\");\n                        }\n                        // containers (mostly for positioning)\n                        var parentClass = \"iti\";\n                        if (this.options.allowDropdown) parentClass += \" iti--allow-dropdown\";\n                        if (this.options.separateDialCode) parentClass += \" iti--separate-dial-code\";\n                        if (this.options.customContainer) {\n                            parentClass += \" \";\n                            parentClass += this.options.customContainer;\n                        }\n                        var wrapper = this._createEl(\"div\", {\n                            \"class\": parentClass\n                        });\n                        this.telInput.parentNode.insertBefore(wrapper, this.telInput);\n                        this.flagsContainer = this._createEl(\"div\", {\n                            \"class\": \"iti__flag-container\"\n                        }, wrapper);\n                        wrapper.appendChild(this.telInput);\n                        // selected flag (displayed to left of input)\n                        this.selectedFlag = this._createEl(\"div\", {\n                            \"class\": \"iti__selected-flag\",\n                            role: \"combobox\",\n                            \"aria-controls\": \"iti-\".concat(this.id, \"__country-listbox\"),\n                            \"aria-owns\": \"iti-\".concat(this.id, \"__country-listbox\"),\n                            \"aria-expanded\": \"false\"\n                        }, this.flagsContainer);\n                        this.selectedFlagInner = this._createEl(\"div\", {\n                            \"class\": \"iti__flag\"\n                        }, this.selectedFlag);\n                        if (this.options.separateDialCode) {\n                            this.selectedDialCode = this._createEl(\"div\", {\n                                \"class\": \"iti__selected-dial-code\"\n                            }, this.selectedFlag);\n                        }\n                        if (this.options.allowDropdown) {\n                            // make element focusable and tab navigable\n                            this.selectedFlag.setAttribute(\"tabindex\", \"0\");\n                            this.dropdownArrow = this._createEl(\"div\", {\n                                \"class\": \"iti__arrow\"\n                            }, this.selectedFlag);\n                            // country dropdown: preferred countries, then divider, then all countries\n                            this.countryList = this._createEl(\"ul\", {\n                                \"class\": \"iti__country-list iti__hide\",\n                                id: \"iti-\".concat(this.id, \"__country-listbox\"),\n                                role: \"listbox\",\n                                \"aria-label\": \"List of countries\"\n                            });\n                            if (this.preferredCountries.length) {\n                                this._appendListItems(this.preferredCountries, \"iti__preferred\", true);\n                                this._createEl(\"li\", {\n                                    \"class\": \"iti__divider\",\n                                    role: \"separator\",\n                                    \"aria-disabled\": \"true\"\n                                }, this.countryList);\n                            }\n                            this._appendListItems(this.countries, \"iti__standard\");\n                            // create dropdownContainer markup\n                            if (this.options.dropdownContainer) {\n                                this.dropdown = this._createEl(\"div\", {\n                                    \"class\": \"iti iti--container\"\n                                });\n                                this.dropdown.appendChild(this.countryList);\n                            } else {\n                                this.flagsContainer.appendChild(this.countryList);\n                            }\n                        }\n                        if (this.options.hiddenInput) {\n                            var hiddenInputName = this.options.hiddenInput;\n                            var name = this.telInput.getAttribute(\"name\");\n                            if (name) {\n                                var i = name.lastIndexOf(\"[\");\n                                // if input name contains square brackets, then give the hidden input the same name,\n                                // replacing the contents of the last set of brackets with the given hiddenInput name\n                                if (i !== -1) hiddenInputName = \"\".concat(name.substr(0, i), \"[\").concat(hiddenInputName, \"]\");\n                            }\n                            this.hiddenInput = this._createEl(\"input\", {\n                                type: \"hidden\",\n                                name: hiddenInputName\n                            });\n                            wrapper.appendChild(this.hiddenInput);\n                        }\n                    }\n                }, {\n                    key: \"_appendListItems\",\n                    value: function _appendListItems(countries, className, preferred) {\n                        // we create so many DOM elements, it is faster to build a temp string\n                        // and then add everything to the DOM in one go at the end\n                        var tmp = \"\";\n                        // for each country\n                        for (var i = 0; i < countries.length; i++) {\n                            var c = countries[i];\n                            var idSuffix = preferred ? \"-preferred\" : \"\";\n                            // open the list item\n                            tmp += \"<li class='iti__country \".concat(className, \"' tabIndex='-1' id='iti-\").concat(this.id, \"__item-\").concat(c.iso2).concat(idSuffix, \"' role='option' data-dial-code='\").concat(c.dialCode, \"' data-country-code='\").concat(c.iso2, \"' aria-selected='false'>\");\n                            // add the flag\n                            tmp += \"<div class='iti__flag-box'><div class='iti__flag iti__\".concat(c.iso2, \"'></div></div>\");\n                            // and the country name and dial code\n                            tmp += \"<span class='iti__country-name'>\".concat(c.name, \"</span>\");\n                            tmp += \"<span class='iti__dial-code'>+\".concat(c.dialCode, \"</span>\");\n                            // close the list item\n                            tmp += \"</li>\";\n                        }\n                        this.countryList.insertAdjacentHTML(\"beforeend\", tmp);\n                    }\n                }, {\n                    key: \"_setInitialState\",\n                    value: function _setInitialState() {\n                        var val = this.telInput.value;\n                        var dialCode = this._getDialCode(val);\n                        var isRegionlessNanp = this._isRegionlessNanp(val);\n                        var _this$options = this.options, initialCountry = _this$options.initialCountry, nationalMode = _this$options.nationalMode, autoHideDialCode = _this$options.autoHideDialCode, separateDialCode = _this$options.separateDialCode;\n                        // if we already have a dial code, and it's not a regionlessNanp, we can go ahead and set the\n                        // flag, else fall back to the default country\n                        if (dialCode && !isRegionlessNanp) {\n                            this._updateFlagFromNumber(val);\n                        } else if (initialCountry !== \"auto\") {\n                            // see if we should select a flag\n                            if (initialCountry) {\n                                this._setFlag(initialCountry.toLowerCase());\n                            } else {\n                                if (dialCode && isRegionlessNanp) {\n                                    // has intl dial code, is regionless nanp, and no initialCountry, so default to US\n                                    this._setFlag(\"us\");\n                                } else {\n                                    // no dial code and no initialCountry, so default to first in list\n                                    this.defaultCountry = this.preferredCountries.length ? this.preferredCountries[0].iso2 : this.countries[0].iso2;\n                                    if (!val) {\n                                        this._setFlag(this.defaultCountry);\n                                    }\n                                }\n                            }\n                            // if empty and no nationalMode and no autoHideDialCode then insert the default dial code\n                            if (!val && !nationalMode && !autoHideDialCode && !separateDialCode) {\n                                this.telInput.value = \"+\".concat(this.selectedCountryData.dialCode);\n                            }\n                        }\n                        // NOTE: if initialCountry is set to auto, that will be handled separately\n                        // format - note this wont be run after _updateDialCode as that's only called if no val\n                        if (val) this._updateValFromNumber(val);\n                    }\n                }, {\n                    key: \"_initListeners\",\n                    value: function _initListeners() {\n                        this._initKeyListeners();\n                        if (this.options.autoHideDialCode) this._initBlurListeners();\n                        if (this.options.allowDropdown) this._initDropdownListeners();\n                        if (this.hiddenInput) this._initHiddenInputListener();\n                    }\n                }, {\n                    key: \"_initHiddenInputListener\",\n                    value: function _initHiddenInputListener() {\n                        var _this3 = this;\n                        this._handleHiddenInputSubmit = function() {\n                            _this3.hiddenInput.value = _this3.getNumber();\n                        };\n                        if (this.telInput.form) this.telInput.form.addEventListener(\"submit\", this._handleHiddenInputSubmit);\n                    }\n                }, {\n                    key: \"_getClosestLabel\",\n                    value: function _getClosestLabel() {\n                        var el = this.telInput;\n                        while (el && el.tagName !== \"LABEL\") {\n                            el = el.parentNode;\n                        }\n                        return el;\n                    }\n                }, {\n                    key: \"_initDropdownListeners\",\n                    value: function _initDropdownListeners() {\n                        var _this4 = this;\n                        // hack for input nested inside label (which is valid markup): clicking the selected-flag to\n                        // open the dropdown would then automatically trigger a 2nd click on the input which would\n                        // close it again\n                        this._handleLabelClick = function(e) {\n                            // if the dropdown is closed, then focus the input, else ignore the click\n                            if (_this4.countryList.classList.contains(\"iti__hide\")) _this4.telInput.focus(); else e.preventDefault();\n                        };\n                        var label = this._getClosestLabel();\n                        if (label) label.addEventListener(\"click\", this._handleLabelClick);\n                        // toggle country dropdown on click\n                        this._handleClickSelectedFlag = function() {\n                            // only intercept this event if we're opening the dropdown\n                            // else let it bubble up to the top (\"click-off-to-close\" listener)\n                            // we cannot just stopPropagation as it may be needed to close another instance\n                            if (_this4.countryList.classList.contains(\"iti__hide\") && !_this4.telInput.disabled && !_this4.telInput.readOnly) {\n                                _this4._showDropdown();\n                            }\n                        };\n                        this.selectedFlag.addEventListener(\"click\", this._handleClickSelectedFlag);\n                        // open dropdown list if currently focused\n                        this._handleFlagsContainerKeydown = function(e) {\n                            var isDropdownHidden = _this4.countryList.classList.contains(\"iti__hide\");\n                            if (isDropdownHidden && [ \"ArrowUp\", \"Up\", \"ArrowDown\", \"Down\", \" \", \"Enter\" ].indexOf(e.key) !== -1) {\n                                // prevent form from being submitted if \"ENTER\" was pressed\n                                e.preventDefault();\n                                // prevent event from being handled again by document\n                                e.stopPropagation();\n                                _this4._showDropdown();\n                            }\n                            // allow navigation from dropdown to input on TAB\n                            if (e.key === \"Tab\") _this4._closeDropdown();\n                        };\n                        this.flagsContainer.addEventListener(\"keydown\", this._handleFlagsContainerKeydown);\n                    }\n                }, {\n                    key: \"_initRequests\",\n                    value: function _initRequests() {\n                        var _this5 = this;\n                        // if the user has specified the path to the utils script, fetch it on window.load, else resolve\n                        if (this.options.utilsScript && !window.intlTelInputUtils) {\n                            // if the plugin is being initialised after the window.load event has already been fired\n                            if (window.intlTelInputGlobals.documentReady()) {\n                                window.intlTelInputGlobals.loadUtils(this.options.utilsScript);\n                            } else {\n                                // wait until the load event so we don't block any other requests e.g. the flags image\n                                window.addEventListener(\"load\", function() {\n                                    window.intlTelInputGlobals.loadUtils(_this5.options.utilsScript);\n                                });\n                            }\n                        } else this.resolveUtilsScriptPromise();\n                        if (this.options.initialCountry === \"auto\") this._loadAutoCountry(); else this.resolveAutoCountryPromise();\n                    }\n                }, {\n                    key: \"_loadAutoCountry\",\n                    value: function _loadAutoCountry() {\n                        // 3 options:\n                        // 1) already loaded (we're done)\n                        // 2) not already started loading (start)\n                        // 3) already started loading (do nothing - just wait for loading callback to fire)\n                        if (window.intlTelInputGlobals.autoCountry) {\n                            this.handleAutoCountry();\n                        } else if (!window.intlTelInputGlobals.startedLoadingAutoCountry) {\n                            // don't do this twice!\n                            window.intlTelInputGlobals.startedLoadingAutoCountry = true;\n                            if (typeof this.options.geoIpLookup === \"function\") {\n                                this.options.geoIpLookup(function(countryCode) {\n                                    window.intlTelInputGlobals.autoCountry = countryCode.toLowerCase();\n                                    // tell all instances the auto country is ready\n                                    // TODO: this should just be the current instances\n                                    // UPDATE: use setTimeout in case their geoIpLookup function calls this callback straight\n                                    // away (e.g. if they have already done the geo ip lookup somewhere else). Using\n                                    // setTimeout means that the current thread of execution will finish before executing\n                                    // this, which allows the plugin to finish initialising.\n                                    setTimeout(function() {\n                                        return forEachInstance(\"handleAutoCountry\");\n                                    });\n                                }, function() {\n                                    return forEachInstance(\"rejectAutoCountryPromise\");\n                                });\n                            }\n                        }\n                    }\n                }, {\n                    key: \"_initKeyListeners\",\n                    value: function _initKeyListeners() {\n                        var _this6 = this;\n                        // update flag on keyup\n                        this._handleKeyupEvent = function() {\n                            if (_this6._updateFlagFromNumber(_this6.telInput.value)) {\n                                _this6._triggerCountryChange();\n                            }\n                        };\n                        this.telInput.addEventListener(\"keyup\", this._handleKeyupEvent);\n                        // update flag on cut/paste events (now supported in all major browsers)\n                        this._handleClipboardEvent = function() {\n                            // hack because \"paste\" event is fired before input is updated\n                            setTimeout(_this6._handleKeyupEvent);\n                        };\n                        this.telInput.addEventListener(\"cut\", this._handleClipboardEvent);\n                        this.telInput.addEventListener(\"paste\", this._handleClipboardEvent);\n                    }\n                }, {\n                    key: \"_cap\",\n                    value: function _cap(number) {\n                        var max = this.telInput.getAttribute(\"maxlength\");\n                        return max && number.length > max ? number.substr(0, max) : number;\n                    }\n                }, {\n                    key: \"_initBlurListeners\",\n                    value: function _initBlurListeners() {\n                        var _this7 = this;\n                        // on blur or form submit: if just a dial code then remove it\n                        this._handleSubmitOrBlurEvent = function() {\n                            _this7._removeEmptyDialCode();\n                        };\n                        if (this.telInput.form) this.telInput.form.addEventListener(\"submit\", this._handleSubmitOrBlurEvent);\n                        this.telInput.addEventListener(\"blur\", this._handleSubmitOrBlurEvent);\n                    }\n                }, {\n                    key: \"_removeEmptyDialCode\",\n                    value: function _removeEmptyDialCode() {\n                        if (this.telInput.value.charAt(0) === \"+\") {\n                            var numeric = this._getNumeric(this.telInput.value);\n                            // if just a plus, or if just a dial code\n                            if (!numeric || this.selectedCountryData.dialCode === numeric) {\n                                this.telInput.value = \"\";\n                            }\n                        }\n                    }\n                }, {\n                    key: \"_getNumeric\",\n                    value: function _getNumeric(s) {\n                        return s.replace(/\\D/g, \"\");\n                    }\n                }, {\n                    key: \"_trigger\",\n                    value: function _trigger(name) {\n                        // have to use old school document.createEvent as IE11 doesn't support `new Event()` syntax\n                        var e = document.createEvent(\"Event\");\n                        e.initEvent(name, true, true);\n                        // can bubble, and is cancellable\n                        this.telInput.dispatchEvent(e);\n                    }\n                }, {\n                    key: \"_showDropdown\",\n                    value: function _showDropdown() {\n                        this.countryList.classList.remove(\"iti__hide\");\n                        this.selectedFlag.setAttribute(\"aria-expanded\", \"true\");\n                        this._setDropdownPosition();\n                        // update highlighting and scroll to active list item\n                        if (this.activeItem) {\n                            this._highlightListItem(this.activeItem, false);\n                            this._scrollTo(this.activeItem, true);\n                        }\n                        // bind all the dropdown-related listeners: mouseover, click, click-off, keydown\n                        this._bindDropdownListeners();\n                        // update the arrow\n                        this.dropdownArrow.classList.add(\"iti__arrow--up\");\n                        this._trigger(\"open:countrydropdown\");\n                    }\n                }, {\n                    key: \"_toggleClass\",\n                    value: function _toggleClass(el, className, shouldHaveClass) {\n                        if (shouldHaveClass && !el.classList.contains(className)) el.classList.add(className); else if (!shouldHaveClass && el.classList.contains(className)) el.classList.remove(className);\n                    }\n                }, {\n                    key: \"_setDropdownPosition\",\n                    value: function _setDropdownPosition() {\n                        var _this8 = this;\n                        if (this.options.dropdownContainer) {\n                            this.options.dropdownContainer.appendChild(this.dropdown);\n                        }\n                        if (!this.isMobile) {\n                            var pos = this.telInput.getBoundingClientRect();\n                            // windowTop from https://stackoverflow.com/a/14384091/217866\n                            var windowTop = window.pageYOffset || document.documentElement.scrollTop;\n                            var inputTop = pos.top + windowTop;\n                            var dropdownHeight = this.countryList.offsetHeight;\n                            // dropdownFitsBelow = (dropdownBottom < windowBottom)\n                            var dropdownFitsBelow = inputTop + this.telInput.offsetHeight + dropdownHeight < windowTop + window.innerHeight;\n                            var dropdownFitsAbove = inputTop - dropdownHeight > windowTop;\n                            // by default, the dropdown will be below the input. If we want to position it above the\n                            // input, we add the dropup class.\n                            this._toggleClass(this.countryList, \"iti__country-list--dropup\", !dropdownFitsBelow && dropdownFitsAbove);\n                            // if dropdownContainer is enabled, calculate postion\n                            if (this.options.dropdownContainer) {\n                                // by default the dropdown will be directly over the input because it's not in the flow.\n                                // If we want to position it below, we need to add some extra top value.\n                                var extraTop = !dropdownFitsBelow && dropdownFitsAbove ? 0 : this.telInput.offsetHeight;\n                                // calculate placement\n                                this.dropdown.style.top = \"\".concat(inputTop + extraTop, \"px\");\n                                this.dropdown.style.left = \"\".concat(pos.left + document.body.scrollLeft, \"px\");\n                                // close menu on window scroll\n                                this._handleWindowScroll = function() {\n                                    return _this8._closeDropdown();\n                                };\n                                window.addEventListener(\"scroll\", this._handleWindowScroll);\n                            }\n                        }\n                    }\n                }, {\n                    key: \"_getClosestListItem\",\n                    value: function _getClosestListItem(target) {\n                        var el = target;\n                        while (el && el !== this.countryList && !el.classList.contains(\"iti__country\")) {\n                            el = el.parentNode;\n                        }\n                        // if we reached the countryList element, then return null\n                        return el === this.countryList ? null : el;\n                    }\n                }, {\n                    key: \"_bindDropdownListeners\",\n                    value: function _bindDropdownListeners() {\n                        var _this9 = this;\n                        // when mouse over a list item, just highlight that one\n                        // we add the class \"highlight\", so if they hit \"enter\" we know which one to select\n                        this._handleMouseoverCountryList = function(e) {\n                            // handle event delegation, as we're listening for this event on the countryList\n                            var listItem = _this9._getClosestListItem(e.target);\n                            if (listItem) _this9._highlightListItem(listItem, false);\n                        };\n                        this.countryList.addEventListener(\"mouseover\", this._handleMouseoverCountryList);\n                        // listen for country selection\n                        this._handleClickCountryList = function(e) {\n                            var listItem = _this9._getClosestListItem(e.target);\n                            if (listItem) _this9._selectListItem(listItem);\n                        };\n                        this.countryList.addEventListener(\"click\", this._handleClickCountryList);\n                        // click off to close\n                        // (except when this initial opening click is bubbling up)\n                        // we cannot just stopPropagation as it may be needed to close another instance\n                        var isOpening = true;\n                        this._handleClickOffToClose = function() {\n                            if (!isOpening) _this9._closeDropdown();\n                            isOpening = false;\n                        };\n                        document.documentElement.addEventListener(\"click\", this._handleClickOffToClose);\n                        // listen for up/down scrolling, enter to select, or letters to jump to country name.\n                        // use keydown as keypress doesn't fire for non-char keys and we want to catch if they\n                        // just hit down and hold it to scroll down (no keyup event).\n                        // listen on the document because that's where key events are triggered if no input has focus\n                        var query = \"\";\n                        var queryTimer = null;\n                        this._handleKeydownOnDropdown = function(e) {\n                            // prevent down key from scrolling the whole page,\n                            // and enter key from submitting a form etc\n                            e.preventDefault();\n                            // up and down to navigate\n                            if (e.key === \"ArrowUp\" || e.key === \"Up\" || e.key === \"ArrowDown\" || e.key === \"Down\") _this9._handleUpDownKey(e.key); else if (e.key === \"Enter\") _this9._handleEnterKey(); else if (e.key === \"Escape\") _this9._closeDropdown(); else if (/^[a-zA-Z\u00c0-\u00ff\u0430-\u044f\u0410-\u042f ]$/.test(e.key)) {\n                                // jump to countries that start with the query string\n                                if (queryTimer) clearTimeout(queryTimer);\n                                query += e.key.toLowerCase();\n                                _this9._searchForCountry(query);\n                                // if the timer hits 1 second, reset the query\n                                queryTimer = setTimeout(function() {\n                                    query = \"\";\n                                }, 1e3);\n                            }\n                        };\n                        document.addEventListener(\"keydown\", this._handleKeydownOnDropdown);\n                    }\n                }, {\n                    key: \"_handleUpDownKey\",\n                    value: function _handleUpDownKey(key) {\n                        var next = key === \"ArrowUp\" || key === \"Up\" ? this.highlightedItem.previousElementSibling : this.highlightedItem.nextElementSibling;\n                        if (next) {\n                            // skip the divider\n                            if (next.classList.contains(\"iti__divider\")) {\n                                next = key === \"ArrowUp\" || key === \"Up\" ? next.previousElementSibling : next.nextElementSibling;\n                            }\n                            this._highlightListItem(next, true);\n                        }\n                    }\n                }, {\n                    key: \"_handleEnterKey\",\n                    value: function _handleEnterKey() {\n                        if (this.highlightedItem) this._selectListItem(this.highlightedItem);\n                    }\n                }, {\n                    key: \"_searchForCountry\",\n                    value: function _searchForCountry(query) {\n                        for (var i = 0; i < this.countries.length; i++) {\n                            if (this._startsWith(this.countries[i].name, query)) {\n                                var listItem = this.countryList.querySelector(\"#iti-\".concat(this.id, \"__item-\").concat(this.countries[i].iso2));\n                                // update highlighting and scroll\n                                this._highlightListItem(listItem, false);\n                                this._scrollTo(listItem, true);\n                                break;\n                            }\n                        }\n                    }\n                }, {\n                    key: \"_startsWith\",\n                    value: function _startsWith(a, b) {\n                        return a.substr(0, b.length).toLowerCase() === b;\n                    }\n                }, {\n                    key: \"_updateValFromNumber\",\n                    value: function _updateValFromNumber(originalNumber) {\n                        var number = originalNumber;\n                        if (this.options.formatOnDisplay && window.intlTelInputUtils && this.selectedCountryData) {\n                            var useNational = !this.options.separateDialCode && (this.options.nationalMode || number.charAt(0) !== \"+\");\n                            var _intlTelInputUtils$nu = intlTelInputUtils.numberFormat, NATIONAL = _intlTelInputUtils$nu.NATIONAL, INTERNATIONAL = _intlTelInputUtils$nu.INTERNATIONAL;\n                            var format = useNational ? NATIONAL : INTERNATIONAL;\n                            number = intlTelInputUtils.formatNumber(number, this.selectedCountryData.iso2, format);\n                        }\n                        number = this._beforeSetNumber(number);\n                        this.telInput.value = number;\n                    }\n                }, {\n                    key: \"_updateFlagFromNumber\",\n                    value: function _updateFlagFromNumber(originalNumber) {\n                        // if we're in nationalMode and we already have US/Canada selected, make sure the number starts\n                        // with a +1 so _getDialCode will be able to extract the area code\n                        // update: if we dont yet have selectedCountryData, but we're here (trying to update the flag\n                        // from the number), that means we're initialising the plugin with a number that already has a\n                        // dial code, so fine to ignore this bit\n                        var number = originalNumber;\n                        var selectedDialCode = this.selectedCountryData.dialCode;\n                        var isNanp = selectedDialCode === \"1\";\n                        if (number && this.options.nationalMode && isNanp && number.charAt(0) !== \"+\") {\n                            if (number.charAt(0) !== \"1\") number = \"1\".concat(number);\n                            number = \"+\".concat(number);\n                        }\n                        // update flag if user types area code for another country\n                        if (this.options.separateDialCode && selectedDialCode && number.charAt(0) !== \"+\") {\n                            number = \"+\".concat(selectedDialCode).concat(number);\n                        }\n                        // try and extract valid dial code from input\n                        var dialCode = this._getDialCode(number, true);\n                        var numeric = this._getNumeric(number);\n                        var countryCode = null;\n                        if (dialCode) {\n                            var countryCodes = this.countryCodes[this._getNumeric(dialCode)];\n                            // check if the right country is already selected. this should be false if the number is\n                            // longer than the matched dial code because in this case we need to make sure that if\n                            // there are multiple country matches, that the first one is selected (note: we could\n                            // just check that here, but it requires the same loop that we already have later)\n                            var alreadySelected = countryCodes.indexOf(this.selectedCountryData.iso2) !== -1 && numeric.length <= dialCode.length - 1;\n                            var isRegionlessNanpNumber = selectedDialCode === \"1\" && this._isRegionlessNanp(numeric);\n                            // only update the flag if:\n                            // A) NOT (we currently have a NANP flag selected, and the number is a regionlessNanp)\n                            // AND\n                            // B) the right country is not already selected\n                            if (!isRegionlessNanpNumber && !alreadySelected) {\n                                // if using onlyCountries option, countryCodes[0] may be empty, so we must find the first\n                                // non-empty index\n                                for (var j = 0; j < countryCodes.length; j++) {\n                                    if (countryCodes[j]) {\n                                        countryCode = countryCodes[j];\n                                        break;\n                                    }\n                                }\n                            }\n                        } else if (number.charAt(0) === \"+\" && numeric.length) {\n                            // invalid dial code, so empty\n                            // Note: use getNumeric here because the number has not been formatted yet, so could contain\n                            // bad chars\n                            countryCode = \"\";\n                        } else if (!number || number === \"+\") {\n                            // empty, or just a plus, so default\n                            countryCode = this.defaultCountry;\n                        }\n                        if (countryCode !== null) {\n                            return this._setFlag(countryCode);\n                        }\n                        return false;\n                    }\n                }, {\n                    key: \"_isRegionlessNanp\",\n                    value: function _isRegionlessNanp(number) {\n                        var numeric = this._getNumeric(number);\n                        if (numeric.charAt(0) === \"1\") {\n                            var areaCode = numeric.substr(1, 3);\n                            return regionlessNanpNumbers.indexOf(areaCode) !== -1;\n                        }\n                        return false;\n                    }\n                }, {\n                    key: \"_highlightListItem\",\n                    value: function _highlightListItem(listItem, shouldFocus) {\n                        var prevItem = this.highlightedItem;\n                        if (prevItem) prevItem.classList.remove(\"iti__highlight\");\n                        this.highlightedItem = listItem;\n                        this.highlightedItem.classList.add(\"iti__highlight\");\n                        if (shouldFocus) this.highlightedItem.focus();\n                    }\n                }, {\n                    key: \"_getCountryData\",\n                    value: function _getCountryData(countryCode, ignoreOnlyCountriesOption, allowFail) {\n                        var countryList = ignoreOnlyCountriesOption ? allCountries : this.countries;\n                        for (var i = 0; i < countryList.length; i++) {\n                            if (countryList[i].iso2 === countryCode) {\n                                return countryList[i];\n                            }\n                        }\n                        if (allowFail) {\n                            return null;\n                        }\n                        throw new Error(\"No country data for '\".concat(countryCode, \"'\"));\n                    }\n                }, {\n                    key: \"_setFlag\",\n                    value: function _setFlag(countryCode) {\n                        var prevCountry = this.selectedCountryData.iso2 ? this.selectedCountryData : {};\n                        // do this first as it will throw an error and stop if countryCode is invalid\n                        this.selectedCountryData = countryCode ? this._getCountryData(countryCode, false, false) : {};\n                        // update the defaultCountry - we only need the iso2 from now on, so just store that\n                        if (this.selectedCountryData.iso2) {\n                            this.defaultCountry = this.selectedCountryData.iso2;\n                        }\n                        this.selectedFlagInner.setAttribute(\"class\", \"iti__flag iti__\".concat(countryCode));\n                        // update the selected country's title attribute\n                        var title = countryCode ? \"\".concat(this.selectedCountryData.name, \": +\").concat(this.selectedCountryData.dialCode) : \"Unknown\";\n                        this.selectedFlag.setAttribute(\"title\", title);\n                        if (this.options.separateDialCode) {\n                            var dialCode = this.selectedCountryData.dialCode ? \"+\".concat(this.selectedCountryData.dialCode) : \"\";\n                            this.selectedDialCode.innerHTML = dialCode;\n                            // offsetWidth is zero if input is in a hidden container during initialisation\n                            var selectedFlagWidth = this.selectedFlag.offsetWidth || this._getHiddenSelectedFlagWidth();\n                            // add 6px of padding after the grey selected-dial-code box, as this is what we use in the css\n                            this.telInput.style.paddingLeft = \"\".concat(selectedFlagWidth + 6, \"px\");\n                        }\n                        // and the input's placeholder\n                        this._updatePlaceholder();\n                        // update the active list item\n                        if (this.options.allowDropdown) {\n                            var prevItem = this.activeItem;\n                            if (prevItem) {\n                                prevItem.classList.remove(\"iti__active\");\n                                prevItem.setAttribute(\"aria-selected\", \"false\");\n                            }\n                            if (countryCode) {\n                                // check if there is a preferred item first, else fall back to standard\n                                var nextItem = this.countryList.querySelector(\"#iti-\".concat(this.id, \"__item-\").concat(countryCode, \"-preferred\")) || this.countryList.querySelector(\"#iti-\".concat(this.id, \"__item-\").concat(countryCode));\n                                nextItem.setAttribute(\"aria-selected\", \"true\");\n                                nextItem.classList.add(\"iti__active\");\n                                this.activeItem = nextItem;\n                                this.selectedFlag.setAttribute(\"aria-activedescendant\", nextItem.getAttribute(\"id\"));\n                            }\n                        }\n                        // return if the flag has changed or not\n                        return prevCountry.iso2 !== countryCode;\n                    }\n                }, {\n                    key: \"_getHiddenSelectedFlagWidth\",\n                    value: function _getHiddenSelectedFlagWidth() {\n                        // to get the right styling to apply, all we need is a shallow clone of the container,\n                        // and then to inject a deep clone of the selectedFlag element\n                        var containerClone = this.telInput.parentNode.cloneNode();\n                        containerClone.style.visibility = \"hidden\";\n                        document.body.appendChild(containerClone);\n                        var flagsContainerClone = this.flagsContainer.cloneNode();\n                        containerClone.appendChild(flagsContainerClone);\n                        var selectedFlagClone = this.selectedFlag.cloneNode(true);\n                        flagsContainerClone.appendChild(selectedFlagClone);\n                        var width = selectedFlagClone.offsetWidth;\n                        containerClone.parentNode.removeChild(containerClone);\n                        return width;\n                    }\n                }, {\n                    key: \"_updatePlaceholder\",\n                    value: function _updatePlaceholder() {\n                        var shouldSetPlaceholder = this.options.autoPlaceholder === \"aggressive\" || !this.hadInitialPlaceholder && this.options.autoPlaceholder === \"polite\";\n                        if (window.intlTelInputUtils && shouldSetPlaceholder) {\n                            var numberType = intlTelInputUtils.numberType[this.options.placeholderNumberType];\n                            var placeholder = this.selectedCountryData.iso2 ? intlTelInputUtils.getExampleNumber(this.selectedCountryData.iso2, this.options.nationalMode, numberType) : \"\";\n                            placeholder = this._beforeSetNumber(placeholder);\n                            if (typeof this.options.customPlaceholder === \"function\") {\n                                placeholder = this.options.customPlaceholder(placeholder, this.selectedCountryData);\n                            }\n                            this.telInput.setAttribute(\"placeholder\", placeholder);\n                        }\n                    }\n                }, {\n                    key: \"_selectListItem\",\n                    value: function _selectListItem(listItem) {\n                        // update selected flag and active list item\n                        var flagChanged = this._setFlag(listItem.getAttribute(\"data-country-code\"));\n                        this._closeDropdown();\n                        this._updateDialCode(listItem.getAttribute(\"data-dial-code\"), true);\n                        // focus the input\n                        this.telInput.focus();\n                        // put cursor at end - this fix is required for FF and IE11 (with nationalMode=false i.e. auto\n                        // inserting dial code), who try to put the cursor at the beginning the first time\n                        var len = this.telInput.value.length;\n                        this.telInput.setSelectionRange(len, len);\n                        if (flagChanged) {\n                            this._triggerCountryChange();\n                        }\n                    }\n                }, {\n                    key: \"_closeDropdown\",\n                    value: function _closeDropdown() {\n                        this.countryList.classList.add(\"iti__hide\");\n                        this.selectedFlag.setAttribute(\"aria-expanded\", \"false\");\n                        // update the arrow\n                        this.dropdownArrow.classList.remove(\"iti__arrow--up\");\n                        // unbind key events\n                        document.removeEventListener(\"keydown\", this._handleKeydownOnDropdown);\n                        document.documentElement.removeEventListener(\"click\", this._handleClickOffToClose);\n                        this.countryList.removeEventListener(\"mouseover\", this._handleMouseoverCountryList);\n                        this.countryList.removeEventListener(\"click\", this._handleClickCountryList);\n                        // remove menu from container\n                        if (this.options.dropdownContainer) {\n                            if (!this.isMobile) window.removeEventListener(\"scroll\", this._handleWindowScroll);\n                            if (this.dropdown.parentNode) this.dropdown.parentNode.removeChild(this.dropdown);\n                        }\n                        this._trigger(\"close:countrydropdown\");\n                    }\n                }, {\n                    key: \"_scrollTo\",\n                    value: function _scrollTo(element, middle) {\n                        var container = this.countryList;\n                        // windowTop from https://stackoverflow.com/a/14384091/217866\n                        var windowTop = window.pageYOffset || document.documentElement.scrollTop;\n                        var containerHeight = container.offsetHeight;\n                        var containerTop = container.getBoundingClientRect().top + windowTop;\n                        var containerBottom = containerTop + containerHeight;\n                        var elementHeight = element.offsetHeight;\n                        var elementTop = element.getBoundingClientRect().top + windowTop;\n                        var elementBottom = elementTop + elementHeight;\n                        var newScrollTop = elementTop - containerTop + container.scrollTop;\n                        var middleOffset = containerHeight / 2 - elementHeight / 2;\n                        if (elementTop < containerTop) {\n                            // scroll up\n                            if (middle) newScrollTop -= middleOffset;\n                            container.scrollTop = newScrollTop;\n                        } else if (elementBottom > containerBottom) {\n                            // scroll down\n                            if (middle) newScrollTop += middleOffset;\n                            var heightDifference = containerHeight - elementHeight;\n                            container.scrollTop = newScrollTop - heightDifference;\n                        }\n                    }\n                }, {\n                    key: \"_updateDialCode\",\n                    value: function _updateDialCode(newDialCodeBare, hasSelectedListItem) {\n                        var inputVal = this.telInput.value;\n                        // save having to pass this every time\n                        var newDialCode = \"+\".concat(newDialCodeBare);\n                        var newNumber;\n                        if (inputVal.charAt(0) === \"+\") {\n                            // there's a plus so we're dealing with a replacement (doesn't matter if nationalMode or not)\n                            var prevDialCode = this._getDialCode(inputVal);\n                            if (prevDialCode) {\n                                // current number contains a valid dial code, so replace it\n                                newNumber = inputVal.replace(prevDialCode, newDialCode);\n                            } else {\n                                // current number contains an invalid dial code, so ditch it\n                                // (no way to determine where the invalid dial code ends and the rest of the number begins)\n                                newNumber = newDialCode;\n                            }\n                        } else if (this.options.nationalMode || this.options.separateDialCode) {\n                            // don't do anything\n                            return;\n                        } else {\n                            // nationalMode is disabled\n                            if (inputVal) {\n                                // there is an existing value with no dial code: prefix the new dial code\n                                newNumber = newDialCode + inputVal;\n                            } else if (hasSelectedListItem || !this.options.autoHideDialCode) {\n                                // no existing value and either they've just selected a list item, or autoHideDialCode is\n                                // disabled: insert new dial code\n                                newNumber = newDialCode;\n                            } else {\n                                return;\n                            }\n                        }\n                        this.telInput.value = newNumber;\n                    }\n                }, {\n                    key: \"_getDialCode\",\n                    value: function _getDialCode(number, includeAreaCode) {\n                        var dialCode = \"\";\n                        // only interested in international numbers (starting with a plus)\n                        if (number.charAt(0) === \"+\") {\n                            var numericChars = \"\";\n                            // iterate over chars\n                            for (var i = 0; i < number.length; i++) {\n                                var c = number.charAt(i);\n                                // if char is number (https://stackoverflow.com/a/8935649/217866)\n                                if (!isNaN(parseInt(c, 10))) {\n                                    numericChars += c;\n                                    // if current numericChars make a valid dial code\n                                    if (includeAreaCode) {\n                                        if (this.countryCodes[numericChars]) {\n                                            // store the actual raw string (useful for matching later)\n                                            dialCode = number.substr(0, i + 1);\n                                        }\n                                    } else {\n                                        if (this.dialCodes[numericChars]) {\n                                            dialCode = number.substr(0, i + 1);\n                                            // if we're just looking for a dial code, we can break as soon as we find one\n                                            break;\n                                        }\n                                    }\n                                    // stop searching as soon as we can - in this case when we hit max len\n                                    if (numericChars.length === this.countryCodeMaxLen) {\n                                        break;\n                                    }\n                                }\n                            }\n                        }\n                        return dialCode;\n                    }\n                }, {\n                    key: \"_getFullNumber\",\n                    value: function _getFullNumber() {\n                        var val = this.telInput.value.trim();\n                        var dialCode = this.selectedCountryData.dialCode;\n                        var prefix;\n                        var numericVal = this._getNumeric(val);\n                        if (this.options.separateDialCode && val.charAt(0) !== \"+\" && dialCode && numericVal) {\n                            // when using separateDialCode, it is visible so is effectively part of the typed number\n                            prefix = \"+\".concat(dialCode);\n                        } else {\n                            prefix = \"\";\n                        }\n                        return prefix + val;\n                    }\n                }, {\n                    key: \"_beforeSetNumber\",\n                    value: function _beforeSetNumber(originalNumber) {\n                        var number = originalNumber;\n                        if (this.options.separateDialCode) {\n                            var dialCode = this._getDialCode(number);\n                            // if there is a valid dial code\n                            if (dialCode) {\n                                // in case _getDialCode returned an area code as well\n                                dialCode = \"+\".concat(this.selectedCountryData.dialCode);\n                                // a lot of numbers will have a space separating the dial code and the main number, and\n                                // some NANP numbers will have a hyphen e.g. +1 684-733-1234 - in both cases we want to get\n                                // rid of it\n                                // NOTE: don't just trim all non-numerics as may want to preserve an open parenthesis etc\n                                var start = number[dialCode.length] === \" \" || number[dialCode.length] === \"-\" ? dialCode.length + 1 : dialCode.length;\n                                number = number.substr(start);\n                            }\n                        }\n                        return this._cap(number);\n                    }\n                }, {\n                    key: \"_triggerCountryChange\",\n                    value: function _triggerCountryChange() {\n                        this._trigger(\"countrychange\");\n                    }\n                }, {\n                    key: \"handleAutoCountry\",\n                    value: function handleAutoCountry() {\n                        if (this.options.initialCountry === \"auto\") {\n                            // we must set this even if there is an initial val in the input: in case the initial val is\n                            // invalid and they delete it - they should see their auto country\n                            this.defaultCountry = window.intlTelInputGlobals.autoCountry;\n                            // if there's no initial value in the input, then update the flag\n                            if (!this.telInput.value) {\n                                this.setCountry(this.defaultCountry);\n                            }\n                            this.resolveAutoCountryPromise();\n                        }\n                    }\n                }, {\n                    key: \"handleUtils\",\n                    value: function handleUtils() {\n                        // if the request was successful\n                        if (window.intlTelInputUtils) {\n                            // if there's an initial value in the input, then format it\n                            if (this.telInput.value) {\n                                this._updateValFromNumber(this.telInput.value);\n                            }\n                            this._updatePlaceholder();\n                        }\n                        this.resolveUtilsScriptPromise();\n                    }\n                }, {\n                    key: \"destroy\",\n                    value: function destroy() {\n                        var form = this.telInput.form;\n                        if (this.options.allowDropdown) {\n                            // make sure the dropdown is closed (and unbind listeners)\n                            this._closeDropdown();\n                            this.selectedFlag.removeEventListener(\"click\", this._handleClickSelectedFlag);\n                            this.flagsContainer.removeEventListener(\"keydown\", this._handleFlagsContainerKeydown);\n                            // label click hack\n                            var label = this._getClosestLabel();\n                            if (label) label.removeEventListener(\"click\", this._handleLabelClick);\n                        }\n                        // unbind hiddenInput listeners\n                        if (this.hiddenInput && form) form.removeEventListener(\"submit\", this._handleHiddenInputSubmit);\n                        // unbind autoHideDialCode listeners\n                        if (this.options.autoHideDialCode) {\n                            if (form) form.removeEventListener(\"submit\", this._handleSubmitOrBlurEvent);\n                            this.telInput.removeEventListener(\"blur\", this._handleSubmitOrBlurEvent);\n                        }\n                        // unbind key events, and cut/paste events\n                        this.telInput.removeEventListener(\"keyup\", this._handleKeyupEvent);\n                        this.telInput.removeEventListener(\"cut\", this._handleClipboardEvent);\n                        this.telInput.removeEventListener(\"paste\", this._handleClipboardEvent);\n                        // remove attribute of id instance: data-intl-tel-input-id\n                        this.telInput.removeAttribute(\"data-intl-tel-input-id\");\n                        // remove markup (but leave the original input)\n                        var wrapper = this.telInput.parentNode;\n                        wrapper.parentNode.insertBefore(this.telInput, wrapper);\n                        wrapper.parentNode.removeChild(wrapper);\n                        delete window.intlTelInputGlobals.instances[this.id];\n                    }\n                }, {\n                    key: \"getExtension\",\n                    value: function getExtension() {\n                        if (window.intlTelInputUtils) {\n                            return intlTelInputUtils.getExtension(this._getFullNumber(), this.selectedCountryData.iso2);\n                        }\n                        return \"\";\n                    }\n                }, {\n                    key: \"getNumber\",\n                    value: function getNumber(format) {\n                        if (window.intlTelInputUtils) {\n                            var iso2 = this.selectedCountryData.iso2;\n                            return intlTelInputUtils.formatNumber(this._getFullNumber(), iso2, format);\n                        }\n                        return \"\";\n                    }\n                }, {\n                    key: \"getNumberType\",\n                    value: function getNumberType() {\n                        if (window.intlTelInputUtils) {\n                            return intlTelInputUtils.getNumberType(this._getFullNumber(), this.selectedCountryData.iso2);\n                        }\n                        return -99;\n                    }\n                }, {\n                    key: \"getSelectedCountryData\",\n                    value: function getSelectedCountryData() {\n                        return this.selectedCountryData;\n                    }\n                }, {\n                    key: \"getValidationError\",\n                    value: function getValidationError() {\n                        if (window.intlTelInputUtils) {\n                            var iso2 = this.selectedCountryData.iso2;\n                            return intlTelInputUtils.getValidationError(this._getFullNumber(), iso2);\n                        }\n                        return -99;\n                    }\n                }, {\n                    key: \"isValidNumber\",\n                    value: function isValidNumber() {\n                        var val = this._getFullNumber().trim();\n                        var countryCode = this.options.nationalMode ? this.selectedCountryData.iso2 : \"\";\n                        return window.intlTelInputUtils ? intlTelInputUtils.isValidNumber(val, countryCode) : null;\n                    }\n                }, {\n                    key: \"setCountry\",\n                    value: function setCountry(originalCountryCode) {\n                        var countryCode = originalCountryCode.toLowerCase();\n                        // check if already selected\n                        if (!this.selectedFlagInner.classList.contains(\"iti__\".concat(countryCode))) {\n                            this._setFlag(countryCode);\n                            this._updateDialCode(this.selectedCountryData.dialCode, false);\n                            this._triggerCountryChange();\n                        }\n                    }\n                }, {\n                    key: \"setNumber\",\n                    value: function setNumber(number) {\n                        // we must update the flag first, which updates this.selectedCountryData, which is used for\n                        // formatting the number before displaying it\n                        var flagChanged = this._updateFlagFromNumber(number);\n                        this._updateValFromNumber(number);\n                        if (flagChanged) {\n                            this._triggerCountryChange();\n                        }\n                    }\n                }, {\n                    key: \"setPlaceholderNumberType\",\n                    value: function setPlaceholderNumberType(type) {\n                        this.options.placeholderNumberType = type;\n                        this._updatePlaceholder();\n                    }\n                } ]);\n                return Iti;\n            }();\n        /********************\n         *  STATIC METHODS\n         ********************/\n        // get the country data object\n        intlTelInputGlobals.getCountryData = function() {\n            return allCountries;\n        };\n        // inject a <script> element to load utils.js\n        var injectScript = function injectScript(path, handleSuccess, handleFailure) {\n            // inject a new script element into the page\n            var script = document.createElement(\"script\");\n            script.onload = function() {\n                forEachInstance(\"handleUtils\");\n                if (handleSuccess) handleSuccess();\n            };\n            script.onerror = function() {\n                forEachInstance(\"rejectUtilsScriptPromise\");\n                if (handleFailure) handleFailure();\n            };\n            script.className = \"iti-load-utils\";\n            script.async = true;\n            script.src = path;\n            document.body.appendChild(script);\n        };\n        // load the utils script\n        intlTelInputGlobals.loadUtils = function(path) {\n            // 2 options:\n            // 1) not already started loading (start)\n            // 2) already started loading (do nothing - just wait for the onload callback to fire, which will\n            // trigger handleUtils on all instances, invoking their resolveUtilsScriptPromise functions)\n            if (!window.intlTelInputUtils && !window.intlTelInputGlobals.startedLoadingUtilsScript) {\n                // only do this once\n                window.intlTelInputGlobals.startedLoadingUtilsScript = true;\n                // if we have promises, then return a promise\n                if (typeof Promise !== \"undefined\") {\n                    return new Promise(function(resolve, reject) {\n                        return injectScript(path, resolve, reject);\n                    });\n                }\n                injectScript(path);\n            }\n            return null;\n        };\n        // default options\n        intlTelInputGlobals.defaults = defaults;\n        // version\n        intlTelInputGlobals.version = \"17.0.8\";\n        // convenience wrapper\n        return function(input, options) {\n            var iti = new Iti(input, options);\n            iti._init();\n            input.setAttribute(\"data-intl-tel-input-id\", iti.id);\n            window.intlTelInputGlobals.instances[iti.id] = iti;\n            return iti;\n        };\n    }();\n});\n"}
}});
