<?php

namespace Rahi\Equote\Block\Customer\Quote\View;

use Magento\Framework\View\Element\Template;
use Rahi\Equote\Model\ResourceModel\Equote\CollectionFactory;
use Magento\Catalog\Model\Product;

class Index extends Template
{
    protected $product;
    protected $scopeConfig;
    protected $collection;

    public function __construct(
	\Magento\Framework\View\Element\Template\Context $context,
	\Magento\Customer\Model\Session $customerSession,
	\Magento\Framework\Message\ManagerInterface $messageManager,
	\Rahi\Equote\Model\Equote $_equote_model,
	CollectionFactory $blockCollectionFactory, 
	Product $product
	)
    {
        $this->scopeConfig = $context->getScopeConfig();
	$this->product = $product;
        $this->customerSession = $customerSession;
        $this->messageManager = $messageManager;
        $this->_equote_model = $_equote_model;
        $this->collection = $blockCollectionFactory->create();
        parent::__construct($context);
    }

   /* public function getFormAction()
    {
        return $this->getUrl('equote/index/post', ['_secure' => true]);
    }*/
    public function getCustomerId()
    {
        return $this->customerSession->getCustomer()->getId();
    }
    public function getCustomerName()
    {
        $customerFullName = $this->customerSession->getCustomer()->getFirstname() . ' ' . $this->customerSession->getCustomer()->getLastname();
        return $customerFullName;
    }
    public function getCustomerLoggedInStatus()
    {
        $customerData = $this->customerSession->isLoggedIn();
        // var_dump($customerData);
        return $customerData;
    }
    public function getCollection()
    {
        $itemsCollection = $this->collection->getItems();
        return $itemsCollection;
    }
    public function getAvailableStatus()
    {
        $availableOptions = $this->_equote_model->getAvailableStatuses();
        return $availableOptions;
    }
/*    public function getViewUrl($equoteId)
    {
        return $this->getUrl('equote/view', ['equote_id' => $equoteId]);
    }*/

    /**
     * @return \Rahi\Equote\Model\ResourceModel\EquoteComments\Collection
     */
    public function getCommentsCollection()
    {
        return $this->_collection;
    }
    public function getPunchoutUrl($equoteId)
    {
        return $this->getUrl('equote/customer/punchout/',['equote_id'=>$equoteId]);
    }	
    public function showPunchoutButton($items){
        $return = 1; //print_r($items);
        foreach ($items as $item) {
            //if item is not present present break the loop and set return 0;
		if($item['eol']==0){
	            if(!$this->product->getIdBySku($item['mpn'])){
        	        $return = 0;
                	//break;
		}
            }
        }   
        return $return;
    }
}
