<?php

namespace Rahi\Equote\Controller\Adminhtml\AddItems;

use Magento\Catalog\Model\Product;
use Magento\Framework\Controller\Result\JsonFactory;
use Rahi\Equote\Helper\Data;
use Magento\Catalog\Api\ProductRepositoryInterface;
use Magento\Catalog\Model\Product\Action as ProductAction;

class Index extends \Magento\Backend\App\Action
{
    protected $jsonFactory;
    protected $categoryLinkManagementInterface;
    protected $productFactory;
    protected $helper;
    private $productRepository;
    private $productAction;

    public function __construct(
        JsonFactory $jsonFactory,
        Product $product,
        Data $helper,
        \Magento\CatalogInventory\Api\StockRegistryInterface $stockRegistry,
        \Magento\Catalog\Api\CategoryLinkManagementInterface  $categoryLinkManagementInterface,
        \Magento\Catalog\Model\ProductFactory $productFactory,
        ProductRepositoryInterface $productRepository,
        ProductAction $action,
        \Magento\Backend\App\Action\Context $context
    ) {
        $this->jsonFactory = $jsonFactory;
        $this->product = $product;
        $this->helper = $helper;
        $this->stockRegistry = $stockRegistry;
        $this->productRepository = $productRepository;
        $this->productAction = $action;
        $this->categoryLinkManagementInterface = $categoryLinkManagementInterface;
        $this->productFactory = $productFactory;
        parent::__construct($context);
    }
    public function execute()
    {
        $resultJson = $this->jsonFactory->create();
        $error = false;
        $postItems = $_POST['itemInfo']['0'];
//       print_r($postItems);
	 $messages = [];
        foreach ($postItems as $postItemsEach) {
            if (isset($postItemsEach['eol'])) {
                if ($postItemsEach['eol'] == 1) {
                    continue;
                }
            }
            if (!$this->product->loadByAttribute('sku', $postItemsEach['mpn'])) { //die('not');
                $newProduct = $this->productFactory->create();
                $newProduct->setSku($postItemsEach['mpn']);
		 $newProduct->setMpn($postItemsEach['mpn']);
                $newProduct->setName($postItemsEach['mpn']);
                $newProduct->setPrice(0.0);
                $newProduct->setTypeId('simple');
                $newProduct->setStatus(1);
                $newProduct->setAttributeSetId(4);
                $newProduct->setVisibility(4);
                $newProduct->setCategoryIds([2,10]);
                $newProduct->setTaxClassId(0);
                $newProduct->setData('website_ids', [1]);
		$newProduct->setUrlKey($postItemsEach['mpn']);
                $newProduct->setStockData(
                    array(
                        'use_config_manage_stock' => 1,
                        'manage_stock' => 1,
                        'is_in_stock' => 1,
                        'qty' => 9999
                    )
                );
                $newProduct->save();
            }
            $product = $this->product->loadByAttribute('sku', $postItemsEach['mpn']);
            $optLabel = $postItemsEach['manufacturer'];
            $attrCode = 'manufacturer';
            $productAttrOptions = $this->helper->getAttributeOptionId($attrCode, $optLabel);
            if (!empty($postItemsEach['gpn'])) {
                $product->setData('gpn', $postItemsEach['gpn']);
            }
            if (!empty($postItemsEach['unit_price'])) {
                $product->setData('price', $postItemsEach['unit_price']);
            }
            if (!empty($postItemsEach['manufacturer'])) {
                $product->setData('manufacturer', $productAttrOptions);
            }
            if (!empty($postItemsEach['netsuite_id'])) {
                $product->setData('ns_item_id', $postItemsEach['netsuite_id']);
            }
            $product->setData('ncnr', $postItemsEach['ncnr']);
            if (!empty($postItemsEach['lead_time'])) {
                $product->setData('lead_time', $postItemsEach['lead_time']);
            }
            if (!empty($postItemsEach['description'])) {
                $product->setData('description', $postItemsEach['description']);
            }
            $product->save();
            $messages[] = __('Saved Successully.');
            $error = false;
        }
        return $resultJson->setData([
            'messages' => $messages,
            'error' => $error
        ]);
    }
}
