<?php

namespace Rahi\Equote\Controller\Customer;
use Magento\Framework\App\Action\Context;
use Magento\Framework\View\Result\PageFactory;
use Magento\Framework\Controller\Result\Redirect;

class View extends \Magento\Framework\App\Action\Action
{
    protected $resultPageFactory;
    protected $session;
    protected $resultRedirectFactory;
    protected $equoteModel;


    public function __construct(
        \Magento\Framework\App\Action\Context $context,
        \Magento\Customer\Model\Session $customerSession,
        \Rahi\Equote\Model\Equote $equoteModel,
        Redirect $resultRedirectFactory,
        PageFactory $resultPageFactory
    )
    {
        $this->session = $customerSession;
        parent::__construct($context);
        $this->resultRedirectFactory = $resultRedirectFactory;
	$this->equoteModel = $equoteModel;
        $this->resultPageFactory = $resultPageFactory;
    }
    public function execute()
    {
        if ($this->session->isLoggedIn()) {
            $customerId = $this->session->getCustomer()->getId();

		$id = $this->getRequest()->getParam('equote_id');
		$equote = $this->equoteModel->load($id);
		$equote_customer_id = $equote->getCustomerId();
	        $watchlist_emails = $equote->getWatchlistEmails();
		$access_denied = 1;
		if($watchlist_emails){
			$emails_array = explode(',',$watchlist_emails);
			$email  = $this->session->getCustomer()->getEmailId();
			if(!in_array($email,$emails_array)){ $access_denied = 1;  }else{ $access_denied = 0;  }
		}
		if($customerId == $equote_customer_id){ $access_denied = 0;}

		if($access_denied){
		   $this->messageManager->addError(__('You are not authorised to view this equote.'));
                   $this->_redirect('equote/customer');
		}
        }
        if (!$this->session->isLoggedIn()) {
            // $resultRedirect = $this->resultRedirectFactory->create();
            // $resultRedirect->setUrl($this->_redirect->getRefererUrl());
            $this->messageManager->addError(__('Please sign in to view or generate equote...'));
        }
        $this->_view->loadLayout();
        $this->_view->renderLayout();
    }
}
