-- MySQL dump 10.13  Distrib 5.7.39, for Linux (x86_64)
--
-- Host: localhost    Database: dev_google_punchout
-- ------------------------------------------------------
-- Server version	5.7.39-0ubuntu0.18.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `admin_analytics_usage_version_log`
--

DROP TABLE IF EXISTS `admin_analytics_usage_version_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `admin_analytics_usage_version_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Log ID',
  `last_viewed_in_version` varchar(50) NOT NULL COMMENT 'Viewer last viewed on product version',
  PRIMARY KEY (`id`),
  UNIQUE KEY `ADMIN_ANALYTICS_USAGE_VERSION_LOG_LAST_VIEWED_IN_VERSION` (`last_viewed_in_version`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='Admin Notification Viewer Log Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_analytics_usage_version_log`
--

LOCK TABLES `admin_analytics_usage_version_log` WRITE;
/*!40000 ALTER TABLE `admin_analytics_usage_version_log` DISABLE KEYS */;
INSERT INTO `admin_analytics_usage_version_log` VALUES (1,'2.4.1');
/*!40000 ALTER TABLE `admin_analytics_usage_version_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_passwords`
--

DROP TABLE IF EXISTS `admin_passwords`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `admin_passwords` (
  `password_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Password ID',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'User ID',
  `password_hash` varchar(255) DEFAULT NULL COMMENT 'Password Hash',
  `expires` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Deprecated',
  `last_updated` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Last Updated',
  PRIMARY KEY (`password_id`),
  KEY `ADMIN_PASSWORDS_USER_ID` (`user_id`),
  CONSTRAINT `ADMIN_PASSWORDS_USER_ID_ADMIN_USER_USER_ID` FOREIGN KEY (`user_id`) REFERENCES `admin_user` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8 COMMENT='Admin Passwords';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_passwords`
--

LOCK TABLES `admin_passwords` WRITE;
/*!40000 ALTER TABLE `admin_passwords` DISABLE KEYS */;
INSERT INTO `admin_passwords` VALUES (7,4,'99d5b388ecddce0ddac2d673d6f408677ab8e0a0f78fe1f91ffe18696020d5c5:7zjBDQq8nNT0BP9iZidJK9av12OQyRSi:3_32_2_67108864',0,1633404726),(8,4,'0a08bb59add5c67c63d9c631a2ff7855ef94431f3ff5715a0560627e7d92ff9d:qY8ymL0jOeAvk13AGsA4m6Koqr9I4MFW:3_32_2_67108864',0,1641192620),(10,6,'d6ebf7a2dd1003c008d41d4cab6a6ae564955457775d7e1a0e957ecfa73c3944:RUt55kjIw7WEu7d8wgPGBbErhdQUSERH:3_32_2_67108864',0,1651044129),(11,6,'6d1a69d84b7a78c1f7e854094293e58a980cbd6b00e2f8a03dbac373311f3a33:D8Evs4QthTde1zZwQ0W5S6YSV9jP1ZlG:3_32_2_67108864',0,1651044669),(12,7,'f534cc6bdf201922e6496d0cad36afdda1b9c22e2be4169db45b13427656970c:7UAFzReLSvURhH31WDGbidurcydUH29y:3_32_2_67108864',0,1651061298),(13,7,'50d62bdf078e0f6651e3f70087b04b7ca9419a8be928c9b682417b8bd969183f:wMpeKGaL5tfJXOFyc1WT7vbPPL2lgWl8:3_32_2_67108864',0,1651074194),(14,8,'bd78558268803b043889d771f3503d0d542e7a891daabe55aca523f10ee566c7:85CDpoZpNboFhSmlAkXdvOv0ox7zHQzy:3_32_2_67108864',0,1652175959),(15,9,'2b543d453ca3cf64767b7348006eaa2dd1186f7916f98208863961422edbfe01:o2ByBF3YrqiUYopZ5WogtMyzMvMQ3jDM:3_32_2_67108864',0,1652176088),(16,7,'253a8937b48d3e39c0e0a635f0f7ed53d02f0b56efbe2a2d314d67287ea4fdb7:vXrGCXWU1EzXDhe3LiRkGLa1ev0fqzJz:3_32_2_67108864',0,1654185852),(17,10,'d368e95ea29ecb0179bbbc663f70e7862c9f59794a3b9920fba466227b1f98fb:WUfIXbM1ZxO886ZTRWQUfzIj0uurPcwT:3_32_2_67108864',0,1657778764),(18,11,'7f7303a5c48ef469f213ba7b10e1c26ee21cf4760e762252b05ca753e9e08d79:E1Ny52j9d53p0fu8S6ubyFKdegkgV7ky:3_32_2_67108864',0,1659114772),(19,11,'cb0a10540cfd82d8b63b88dd7746af47f674533b4f98291c11860890bde67d60:y1d1dozjqpD3IvmwBcSy3TM3EcqLpJgO:3_32_2_67108864',0,1659115274),(20,12,'089ccd0f0e31ce32cdcffde309e6b1ec91e53b144852da7244436eb0563d61a5:10CZGbdXL9dGo5j4m10dYYIYJe8UFFVS:3_32_2_67108864',0,1659115393),(21,13,'0fb5c2571887d7b033c170c7ad55c504326d792228f87df65947dbe82de0f3c7:3VTPRphQiI55Ol1xsMxNZ4L6Gwz7w0gs:3_32_2_67108864',0,1659115517),(22,14,'5511e993d4ad76bb0d7d9dea68e182a74100e06002dbe432bc69d66d462437fa:usDAcmFEiFGnVfM691PadUmzecBFceYb:3_32_2_67108864',0,1659115662),(23,15,'8072ad973630ee8f094a4abd270a6bf30a6ae1031051f8fee76a087fecf63110:ZdOcqBWUlVF5YNfJi3jT827q1lqdg8l8:3_32_2_67108864',0,1659116048),(24,6,'00a1310fcdbc10e2440dbd3a4b01da5cb675f8ffc8355dc1af21fd7421c13a94:DkNhpW0HJnCITJoGU0dCKIrlae5K4xHY:3_32_2_67108864',0,1659588008),(25,16,'fe7ee97e584e5d21c6263d224560cc1f3ab48764d7da2a4df2f1d4ad3a52f73d:Vb780TNBL2iL0tHGt9JxDGgBV7RC0WtY:3_32_2_67108864',0,1659588097),(26,9,'202d8ecc1ff10da4010d2f15dd790ec9279238429c964cd765faf35891925ddc:4VbrPqMgbXNs6mmCL7Rl7oIoK7eMWhWl:3_32_2_67108864',0,1659952764);
/*!40000 ALTER TABLE `admin_passwords` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_system_messages`
--

DROP TABLE IF EXISTS `admin_system_messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `admin_system_messages` (
  `identity` varchar(100) NOT NULL COMMENT 'Message ID',
  `severity` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Problem type',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Create date',
  PRIMARY KEY (`identity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Admin System Messages';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_system_messages`
--

LOCK TABLES `admin_system_messages` WRITE;
/*!40000 ALTER TABLE `admin_system_messages` DISABLE KEYS */;
/*!40000 ALTER TABLE `admin_system_messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_user`
--

DROP TABLE IF EXISTS `admin_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `admin_user` (
  `user_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'User ID',
  `firstname` varchar(32) DEFAULT NULL COMMENT 'User First Name',
  `lastname` varchar(32) DEFAULT NULL COMMENT 'User Last Name',
  `email` varchar(128) DEFAULT NULL COMMENT 'User Email',
  `username` varchar(40) DEFAULT NULL COMMENT 'User Login',
  `password` varchar(255) NOT NULL COMMENT 'User Password',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'User Created Time',
  `modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'User Modified Time',
  `logdate` timestamp NULL DEFAULT NULL COMMENT 'User Last Login Time',
  `lognum` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'User Login Number',
  `reload_acl_flag` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Reload ACL',
  `is_active` smallint(6) NOT NULL DEFAULT '1' COMMENT 'User Is Active',
  `extra` text COMMENT 'User Extra Data',
  `rp_token` text COMMENT 'Reset Password Link Token',
  `rp_token_created_at` timestamp NULL DEFAULT NULL COMMENT 'Reset Password Link Token Creation Date',
  `interface_locale` varchar(16) NOT NULL DEFAULT 'en_US' COMMENT 'Backend interface locale',
  `failures_num` smallint(6) DEFAULT '0' COMMENT 'Failure Number',
  `first_failure` timestamp NULL DEFAULT NULL COMMENT 'First Failure',
  `lock_expires` timestamp NULL DEFAULT NULL COMMENT 'Expiration Lock Dates',
  `refresh_token` text COMMENT 'Email connector refresh token',
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `ADMIN_USER_USERNAME` (`username`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8 COMMENT='Admin User Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_user`
--

LOCK TABLES `admin_user` WRITE;
/*!40000 ALTER TABLE `admin_user` DISABLE KEYS */;
INSERT INTO `admin_user` VALUES (6,'Rahi','Admin','rahiadmin@rahisystems.com','admin','00a1310fcdbc10e2440dbd3a4b01da5cb675f8ffc8355dc1af21fd7421c13a94:DkNhpW0HJnCITJoGU0dCKIrlae5K4xHY:3_32_2_67108864','2022-04-27 07:22:09','2022-08-10 06:54:34','2022-08-10 06:54:34',81,0,1,'{\"configState\":{\"themecore_general\":\"1\",\"themecore_theme_layout\":\"1\",\"themecore_product_information\":\"1\",\"themecore_advanced\":\"1\",\"themecore_product_detail\":\"1\",\"themecore_product_listing\":\"1\",\"market_theme_layout\":\"0\",\"market_mobile_theme_layout\":\"0\",\"market_theme_install\":\"0\",\"market_product_information\":\"0\",\"punchout2go_punchout_system\":\"1\",\"categories_general\":\"1\",\"categories_source\":\"0\",\"punchout2go_punchout_defaults\":\"1\",\"punchout2go_punchout_security\":\"1\",\"punchout2go_punchout_site\":\"1\",\"punchout2go_punchout_session\":\"1\",\"punchout2go_punchout_customer\":\"1\",\"punchout2go_punchout_display\":\"1\",\"punchout2go_punchout_order\":\"1\",\"cpanelsection_layoutgroup\":\"1\",\"cpanelsection_headergroup\":\"1\",\"cpanelsection_footergroup\":\"1\",\"general_country\":\"0\",\"general_region\":\"0\",\"general_locale\":\"0\",\"general_store_information\":\"0\",\"cpanelsection_listpagegroup\":\"0\",\"cpanelsection_viewpagegroup\":\"0\",\"cpanelsection_contactpagegroup\":\"1\",\"web_default\":\"1\",\"web_url\":\"1\",\"web_seo\":\"0\",\"web_unsecure\":\"0\",\"web_secure\":\"0\",\"web_default_layouts\":\"0\",\"web_cookie\":\"0\",\"web_session\":\"0\",\"web_browser_capabilities\":\"0\",\"system_adobe_stock_integration\":\"1\",\"dev_front_end_development_workflow\":\"0\",\"dev_restrict\":\"0\",\"mfblog_general\":\"1\",\"mfblog_index_page\":\"0\",\"mfblog_post_view\":\"0\",\"mfblog_post_list\":\"0\",\"mfblog_sidebar\":\"0\",\"mfblog_product_page\":\"0\",\"mfblog_author\":\"0\",\"mfblog_tag\":\"0\",\"mfblog_search\":\"0\",\"mfblog_permalink\":\"0\",\"mfblog_seo\":\"0\",\"mfblog_social\":\"0\",\"mfblog_top_menu\":\"1\",\"catalog_frontend\":\"1\",\"currency_options\":\"1\",\"currency_fixerio\":\"1\",\"currency_currencyconverterapi\":\"0\",\"currency_import\":\"0\",\"punchout2go_punchout_current_version\":\"0\",\"cataloginventory_options\":\"1\",\"cataloginventory_item_options\":\"1\"}}',NULL,NULL,'en_US',0,NULL,NULL,NULL),(7,'PO2GO','Team','ie_team@punchout2go.com','ie_team@punchout2go.com','253a8937b48d3e39c0e0a635f0f7ed53d02f0b56efbe2a2d314d67287ea4fdb7:vXrGCXWU1EzXDhe3LiRkGLa1ev0fqzJz:3_32_2_67108864','2022-04-27 12:08:18','2022-08-10 04:49:03','2022-08-10 04:49:03',13,0,1,'{\"configState\":{\"punchout2go_punchout_system\":\"1\",\"punchout2go_punchout_defaults\":\"1\",\"punchout2go_punchout_security\":\"1\",\"punchout2go_punchout_site\":\"1\",\"punchout2go_punchout_display\":\"1\",\"punchout2go_punchout_order\":\"1\",\"punchout2go_punchout_session\":\"1\",\"punchout2go_punchout_customer\":\"1\",\"punchout2go_punchout_current_version\":\"1\"}}',NULL,NULL,'en_US',0,NULL,NULL,NULL),(8,'Mounika','Alla','mounika.a@rahisystems.com','MounikaA','bd78558268803b043889d771f3503d0d542e7a891daabe55aca523f10ee566c7:85CDpoZpNboFhSmlAkXdvOv0ox7zHQzy:3_32_2_67108864','2022-05-10 09:45:59','2022-05-10 09:45:59',NULL,0,0,1,'null',NULL,NULL,'en_US',0,NULL,NULL,NULL),(9,'Tejas','Ambole','tejas.ambole@rahisystems.com','TejasA','202d8ecc1ff10da4010d2f15dd790ec9279238429c964cd765faf35891925ddc:4VbrPqMgbXNs6mmCL7Rl7oIoK7eMWhWl:3_32_2_67108864','2022-05-10 09:48:08','2022-08-08 11:55:51','2022-07-07 07:44:58',8,0,1,'null','DS5MQJXzOPYuDJ8f4cutVZwn2WTUppzS','2022-08-08 10:06:29','en_US',1,'2022-08-08 11:55:51',NULL,NULL),(10,'Sumit','Nautiyal','sumit.nautiyal@rahisystems.com','nautiyal_sumit','d368e95ea29ecb0179bbbc663f70e7862c9f59794a3b9920fba466227b1f98fb:WUfIXbM1ZxO886ZTRWQUfzIj0uurPcwT:3_32_2_67108864','2022-07-14 06:06:04','2022-08-08 11:45:27','2022-08-08 11:45:27',19,0,1,'{\"configState\":{\"cataloginventory_item_options\":\"1\",\"cataloginventory_options\":\"0\",\"cataloginventory_bulk_operations\":\"0\",\"cataloginventory_indexer\":\"0\",\"cataloginventory_source_selection_distance_based\":\"0\",\"cataloginventory_source_selection_distance_based_google\":\"0\",\"system_full_page_cache\":\"0\",\"catalog_search\":\"1\",\"punchout2go_punchout_order\":\"1\",\"punchout2go_punchout_current_version\":\"1\",\"punchout2go_punchout_display\":\"1\",\"punchout2go_punchout_customer\":\"1\",\"punchout2go_punchout_session\":\"1\",\"punchout2go_punchout_site\":\"1\",\"punchout2go_punchout_security\":\"1\",\"punchout2go_punchout_defaults\":\"1\",\"punchout2go_punchout_system\":\"1\",\"smtp_configuration_option\":\"1\",\"smtp_module\":\"0\",\"smtp_general\":\"0\",\"smtp_developer\":\"0\"}}',NULL,NULL,'en_US',0,NULL,NULL,NULL),(11,'Bhavya ','Seth','bhavya.seth@rahisystems.com','bhavya_seth','cb0a10540cfd82d8b63b88dd7746af47f674533b4f98291c11860890bde67d60:y1d1dozjqpD3IvmwBcSy3TM3EcqLpJgO:3_32_2_67108864','2022-07-29 17:12:52','2022-08-04 16:13:51','2022-08-04 16:13:51',4,0,1,'null',NULL,NULL,'en_US',0,NULL,NULL,NULL),(12,'Fengran ','Huang','fengran.huang@rahisystems.com','fengran_huang','089ccd0f0e31ce32cdcffde309e6b1ec91e53b144852da7244436eb0563d61a5:10CZGbdXL9dGo5j4m10dYYIYJe8UFFVS:3_32_2_67108864','2022-07-29 17:23:13','2022-08-04 16:08:56','2022-08-04 16:08:56',2,0,1,'null',NULL,NULL,'en_US',0,NULL,NULL,NULL),(13,'Harsh','Shah','harsh.shah@rahisystems.com','harsh_shah','0fb5c2571887d7b033c170c7ad55c504326d792228f87df65947dbe82de0f3c7:3VTPRphQiI55Ol1xsMxNZ4L6Gwz7w0gs:3_32_2_67108864','2022-07-29 17:25:17','2022-07-29 17:25:17',NULL,0,1,1,'null',NULL,NULL,'en_US',0,NULL,NULL,NULL),(14,'Arturo','Reyes','arturo.reyes@rahisystems.com','arturo_reyes','5511e993d4ad76bb0d7d9dea68e182a74100e06002dbe432bc69d66d462437fa:usDAcmFEiFGnVfM691PadUmzecBFceYb:3_32_2_67108864','2022-07-29 17:27:42','2022-07-29 17:27:42',NULL,0,1,1,'null',NULL,NULL,'en_US',0,NULL,NULL,NULL),(15,'Kevin','Chemparathy','kevin.chemparathy@rahisystems.com','kevin_chemparathy','8072ad973630ee8f094a4abd270a6bf30a6ae1031051f8fee76a087fecf63110:ZdOcqBWUlVF5YNfJi3jT827q1lqdg8l8:3_32_2_67108864','2022-07-29 17:34:08','2022-08-10 16:06:38','2022-08-10 16:06:38',15,0,1,'null',NULL,NULL,'en_US',0,NULL,NULL,NULL),(16,'Akshay','S','akshay.satbhai@rahisystems.com','adminAkshay','fe7ee97e584e5d21c6263d224560cc1f3ab48764d7da2a4df2f1d4ad3a52f73d:Vb780TNBL2iL0tHGt9JxDGgBV7RC0WtY:3_32_2_67108864','2022-08-04 04:41:37','2022-08-09 09:25:09','2022-08-09 09:25:09',14,0,1,'null',NULL,NULL,'en_US',0,NULL,NULL,NULL);
/*!40000 ALTER TABLE `admin_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_user_expiration`
--

DROP TABLE IF EXISTS `admin_user_expiration`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `admin_user_expiration` (
  `user_id` int(10) unsigned NOT NULL COMMENT 'User ID',
  `expires_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'User Expiration Date',
  PRIMARY KEY (`user_id`),
  CONSTRAINT `ADMIN_USER_EXPIRATION_USER_ID_ADMIN_USER_USER_ID` FOREIGN KEY (`user_id`) REFERENCES `admin_user` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Admin User expiration dates table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_user_expiration`
--

LOCK TABLES `admin_user_expiration` WRITE;
/*!40000 ALTER TABLE `admin_user_expiration` DISABLE KEYS */;
INSERT INTO `admin_user_expiration` VALUES (8,'2022-07-27 09:44:54'),(9,'2022-10-31 09:58:34');
/*!40000 ALTER TABLE `admin_user_expiration` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_user_session`
--

DROP TABLE IF EXISTS `admin_user_session`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `admin_user_session` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `session_id` varchar(128) NOT NULL COMMENT 'Session ID value',
  `user_id` int(10) unsigned DEFAULT NULL COMMENT 'Admin User ID',
  `status` smallint(5) unsigned NOT NULL DEFAULT '1' COMMENT 'Current Session status',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created Time',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Update Time',
  `ip` varchar(15) NOT NULL COMMENT 'Remote user IP',
  PRIMARY KEY (`id`),
  KEY `ADMIN_USER_SESSION_SESSION_ID` (`session_id`),
  KEY `ADMIN_USER_SESSION_USER_ID` (`user_id`),
  CONSTRAINT `ADMIN_USER_SESSION_USER_ID_ADMIN_USER_USER_ID` FOREIGN KEY (`user_id`) REFERENCES `admin_user` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=547 DEFAULT CHARSET=utf8 COMMENT='Admin User sessions table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_user_session`
--

LOCK TABLES `admin_user_session` WRITE;
/*!40000 ALTER TABLE `admin_user_session` DISABLE KEYS */;
INSERT INTO `admin_user_session` VALUES (382,'bvlopo6qti82icqnnv7gq9fogo',6,2,'2022-04-27 07:33:11','2022-04-27 09:00:26','172.70.178.18'),(383,'e5ur746qs5gk5ssjfvk1fuje9c',6,2,'2022-04-27 09:00:26','2022-04-27 11:21:42','172.70.178.90'),(384,'74tgrurl6qesgl40t69n7opjc3',6,0,'2022-04-27 11:21:42','2022-04-27 12:08:33','172.70.178.206'),(385,'ouggbkliusr40csrcqv4p24rrn',7,2,'2022-04-27 12:08:39','2022-04-27 12:43:09','172.68.133.84'),(386,'d9m26842j715ncgpkjd0hpcd6e',7,2,'2022-04-27 12:43:09','2022-04-27 12:48:01','162.158.191.214'),(387,'26jctn7uj4s82t9306pijseh2g',7,2,'2022-04-27 12:48:01','2022-04-27 15:25:22','172.70.178.50'),(388,'cmumukgorhdh385rm0g0tf90vd',7,2,'2022-04-27 15:25:22','2022-04-27 18:21:05','162.158.212.192'),(389,'dthlsq0pedcv62m0aqn51lcpdk',7,2,'2022-04-27 18:21:05','2022-04-28 00:04:14','172.70.178.178'),(390,'6dj42mvji5ev4fp0rffngrsnjb',7,0,'2022-04-28 00:04:14','2022-04-28 00:05:15','172.70.178.248'),(391,'vtqlfvhts5d1msk950m6iupk4d',6,2,'2022-04-28 04:39:16','2022-04-29 06:24:48','162.158.191.218'),(392,'uld7i1qmarg01jk0m3718npsr3',6,1,'2022-04-29 06:24:48','2022-04-29 06:43:29','172.70.178.56'),(393,'eandnd15g8cak6gpk9m3rs3e53',6,1,'2022-05-02 09:06:17','2022-05-02 11:09:10','172.70.178.194'),(394,'ahc0qlc33tkmodhqou6c8g4h7j',6,1,'2022-05-03 15:21:33','2022-05-03 15:21:33','172.70.131.147'),(395,'hckcoppm7ckpi31dj4qv7cguev',7,2,'2022-05-03 16:24:09','2022-05-04 13:20:11','172.70.178.156'),(396,'1q3opmrr14g4frehovimujsafj',7,1,'2022-05-04 13:20:11','2022-05-04 15:14:37','172.70.178.94'),(397,'dclv0uf9tumrg3c0phookt10dv',6,1,'2022-05-04 15:25:38','2022-05-04 15:25:38','172.69.42.118'),(398,'vjtjjoqmqekl6j0totjg2auesh',6,1,'2022-05-06 08:48:23','2022-05-06 08:49:12','172.70.178.134'),(399,'uc6rl9opodp24cg7j4ed9d5qlu',6,2,'2022-05-10 04:45:59','2022-05-10 09:44:21','172.68.34.144'),(400,'rieb5856ofaqak290ku8v6lemk',6,1,'2022-05-10 09:44:21','2022-05-10 09:48:07','172.68.35.17'),(401,'ajsesg8h8926009p2a447omug6',6,2,'2022-05-12 05:51:06','2022-05-12 08:20:45','172.68.35.19'),(402,'6t1o0gsjv1iercvm19be8884je',6,0,'2022-05-12 08:20:45','2022-05-12 09:04:21','172.68.34.250'),(403,'n2bvqdl6hag2unc6ng4dlqjovj',6,2,'2022-05-12 09:04:27','2022-05-12 11:30:03','172.68.35.13'),(404,'nmldm4ecq010sg0ha6qmuqc5r9',6,2,'2022-05-12 11:30:03','2022-05-13 05:25:52','172.68.133.236'),(405,'ijj5qifsha3alcg3fnb8jt82dk',8,1,'2022-05-12 17:56:41','2022-05-12 17:57:30','172.69.42.118'),(406,'u5s214vthpqtgu98cffqjo3tq0',6,2,'2022-05-13 05:25:52','2022-05-13 08:19:09','172.70.178.114'),(407,'gg3910not2i0pa9j6tii32dh9b',6,2,'2022-05-13 08:19:09','2022-05-14 09:54:41','172.70.178.80'),(408,'e4g0nh934sq82uakbasnpfeubf',9,2,'2022-05-13 09:57:44','2022-05-14 05:58:04','172.70.178.172'),(409,'i239a62nk6gbqv4rjqkmrmkdm6',9,1,'2022-05-14 05:58:04','2022-05-14 05:58:04','172.70.178.160'),(410,'n4184n6ijbdifeabcv7ghe3dvq',6,1,'2022-05-14 09:54:41','2022-05-14 10:03:18','172.70.131.213'),(411,'r8m6n5g5jv7eltc4chc4lc8h4q',6,2,'2022-05-24 02:54:50','2022-05-24 09:49:42','172.68.34.186'),(412,'m302n0b6dgmefcviicpgtska6e',6,2,'2022-05-24 09:49:42','2022-05-24 11:34:33','172.70.179.3'),(413,'d8kgrip91798rcqjt0qfb665lo',6,1,'2022-05-24 11:34:33','2022-05-24 11:55:18','172.70.179.19'),(414,'t9ul0iefklsuqrei9q3d6hj96s',6,2,'2022-06-01 04:14:06','2022-06-01 04:50:23','172.70.130.212'),(415,'d9l6ateg5f9b7eqhp91ckud8ns',6,2,'2022-06-01 04:50:23','2022-06-01 06:22:34','172.68.34.168'),(416,'fnlod3sl8u7mhqgslji36ilchq',6,2,'2022-06-01 06:22:34','2022-06-01 09:14:44','172.70.178.52'),(417,'23mbg1qakojq6etq8ncdp1clli',6,2,'2022-06-01 09:14:44','2022-06-01 12:16:12','172.70.130.88'),(418,'pugq8k3nv1kfa5i540lm7g1t57',6,1,'2022-06-01 12:16:12','2022-06-01 12:16:12','172.70.131.65'),(419,'tscv63uq03blp9jkaann05ltgl',9,1,'2022-06-01 12:34:08','2022-06-01 13:19:23','172.70.130.96'),(420,'tv85f39uu95nhk03htua095ge1',6,0,'2022-06-02 15:54:27','2022-06-02 16:58:46','172.70.130.84'),(421,'b357pqikh18pk4n8vpgqr528gd',7,1,'2022-06-02 16:58:55','2022-06-02 17:10:04','172.68.34.222'),(422,'a1ifai38n7puqb9ubldnkhhs4t',6,2,'2022-06-02 17:54:53','2022-06-03 05:16:33','172.68.133.236'),(423,'5dof0fjkk2mm34ci3tpjdk4rcb',6,1,'2022-06-03 05:16:33','2022-06-03 05:22:50','172.70.130.226'),(424,'bbn3btu8rf726smusodd6rgg74',6,2,'2022-06-08 17:20:13','2022-06-09 04:15:10','172.70.130.166'),(425,'udpqfv4butipc15jkt5vppf0on',6,1,'2022-06-09 04:15:10','2022-06-09 05:07:26','172.70.130.242'),(426,'b52jq7gc5lkvpm2c87236bg3sp',6,1,'2022-06-15 04:45:26','2022-06-15 04:57:53','172.70.131.13'),(427,'cfajjis6b2eiq801nkdlr0s6bj',9,2,'2022-06-15 05:26:12','2022-06-15 06:21:41','172.70.131.179'),(428,'ds9990e10fi33lvh2unh42onbq',9,1,'2022-06-15 06:21:41','2022-06-15 06:23:26','172.70.178.220'),(429,'2spiichm0dpsc1qbi27k420kv4',6,2,'2022-06-22 16:42:35','2022-06-22 16:50:06','172.70.130.178'),(430,'4olan7rfd1cqrg305l9vj9aoj0',6,2,'2022-06-22 16:50:06','2022-06-23 06:03:55','172.70.131.83'),(431,'n9h8hgq8dffiibi3oocmkoikb8',6,2,'2022-06-23 06:03:55','2022-06-23 12:13:19','172.70.178.116'),(432,'6b0br2ofi3me1j2jk02uqbsjft',6,2,'2022-06-23 12:13:19','2022-06-24 05:42:29','172.70.178.56'),(433,'o8ssev266qtvicssq277vcnmia',9,1,'2022-06-23 12:35:51','2022-06-23 12:36:37','172.70.178.152'),(434,'5j5ulv0pfvha3fr6gc2kugoorn',6,2,'2022-06-24 05:42:29','2022-06-24 09:08:49','172.70.178.12'),(435,'2grbvqje7lg4lkgmq8lvvpa2fc',6,2,'2022-06-24 09:08:49','2022-06-24 11:58:21','172.70.178.232'),(436,'jqakga7nua5272knb70vtc6k0v',6,1,'2022-06-24 11:58:21','2022-06-24 12:21:53','172.70.178.20'),(437,'so7qe6svaf92uth34oubblg9hl',6,2,'2022-06-28 11:20:53','2022-06-28 12:49:16','172.70.130.200'),(438,'fi08m6m54c49mdcc1qc9k25k42',9,1,'2022-06-28 12:45:29','2022-06-28 12:56:02','172.70.131.123'),(439,'7rrq7o6kd19cvdd1ou40f7m0kg',6,2,'2022-06-28 12:49:16','2022-06-29 08:46:45','172.70.130.60'),(440,'993kni7in0s85p0ipkae6kt6v4',6,2,'2022-06-29 08:46:45','2022-06-29 11:42:35','172.70.130.108'),(441,'v5cjqfv92h3cfab6qp0m2a402q',6,2,'2022-06-29 11:42:35','2022-06-30 03:46:47','172.70.130.138'),(442,'oive27377if6v5ncrnmm762dua',6,2,'2022-06-30 03:46:47','2022-06-30 05:18:24','172.70.131.11'),(443,'30rq2d9msvnq5ni7q1iv2obcvs',6,2,'2022-06-30 05:18:24','2022-06-30 09:00:02','172.70.130.138'),(444,'iul7qfacjce0719qrkaq3ms9ao',6,1,'2022-06-30 09:00:02','2022-06-30 10:31:44','172.70.131.75'),(445,'22ncd8l17407mnhh5722c95hqc',9,1,'2022-06-30 10:42:54','2022-06-30 10:42:54','172.70.179.19'),(446,'r6j6bo66il7skeqne8dnbjc277',6,1,'2022-07-07 07:09:46','2022-07-07 07:15:44','172.70.178.158'),(447,'ajqor2s98heshbef3s8ki6ffqq',9,1,'2022-07-07 07:44:58','2022-07-07 07:44:58','162.158.191.204'),(448,'e5ka9tuc02daq1hutpaip4qk1g',6,1,'2022-07-11 16:12:21','2022-07-11 16:27:57','172.70.178.62'),(449,'opbsiiiq1tlmqs6up3q6ofe6ao',6,2,'2022-07-13 10:23:35','2022-07-13 12:52:18','172.70.218.30'),(450,'27g89011okeq0srjg55issh596',6,1,'2022-07-13 12:52:18','2022-07-13 13:43:17','162.158.198.194'),(451,'mg3e0ec1fbi8fls92srvojmh94',10,2,'2022-07-14 08:20:37','2022-07-14 08:20:46','172.68.35.21'),(452,'31nd6j3hskkqjpt63nm66n05pl',10,2,'2022-07-14 08:20:46','2022-07-14 08:21:29','172.68.34.220'),(453,'ktjl82h36epfhebce92mri5il7',10,1,'2022-07-14 08:21:29','2022-07-14 08:22:18','172.68.35.21'),(454,'bi3knct5dd66qgd94kv43vtcci',6,2,'2022-07-20 05:16:31','2022-07-20 05:24:46','172.70.130.70'),(455,'3jgal00ig3fdq83s38hi06hbha',6,2,'2022-07-20 05:24:46','2022-07-20 06:30:47','172.70.131.155'),(456,'214ladr9ajpieai8afqkrs1c9p',6,2,'2022-07-20 06:30:47','2022-07-20 17:10:48','108.162.242.55'),(457,'6e3ehof3rpfs9llmkag0a8ih51',6,2,'2022-07-20 17:10:48','2022-07-21 08:50:31','108.162.241.120'),(458,'3459kr5auro4f5fqfldm9an39u',6,1,'2022-07-21 08:50:31','2022-07-21 09:08:25','108.162.241.216'),(459,'v17r7ce4lmba1bfr2gbpd6lftl',6,2,'2022-07-25 01:59:08','2022-07-25 04:32:26','108.162.241.222'),(460,'ch7f5vjk2ujtslqvag34urqvha',6,1,'2022-07-25 04:32:26','2022-07-25 04:34:11','108.162.241.168'),(461,'m3rurcfnflo6dsakhv19vij3n3',6,1,'2022-07-26 04:43:57','2022-07-26 04:46:57','172.70.130.124'),(462,'hcu6an64qnmrm82gl6hrl5616e',6,2,'2022-07-29 09:29:28','2022-07-29 13:08:34','172.70.178.64'),(463,'aria4vb5rcm1bcsjc6j3so62pv',6,2,'2022-07-29 13:08:34','2022-07-29 16:28:04','172.70.178.120'),(464,'vdhqverk1tso6nclt46n98dled',10,2,'2022-07-29 13:24:54','2022-07-29 15:27:29','172.68.34.144'),(465,'9vqsbntmtrbm6l3psg4fkpol82',10,2,'2022-07-29 15:27:29','2022-07-29 15:27:35','172.68.34.254'),(466,'hiep03cqdqel9uent4cvgdkj2i',10,1,'2022-07-29 15:27:35','2022-07-29 17:34:07','172.68.35.5'),(467,'o4upcn6qek700dphvpsrhjnf9f',6,2,'2022-07-29 16:28:04','2022-07-30 06:22:05','172.68.34.126'),(468,'vu4r73kv5jf0egfba478g5aira',11,0,'2022-07-29 17:28:18','2022-07-29 17:28:36','172.68.34.222'),(469,'bdu1spafo13vc8ji4erjpchckc',12,1,'2022-07-29 23:46:03','2022-07-29 23:46:03','172.68.34.150'),(470,'8s155nq00hhr333niik5eel6ti',6,2,'2022-07-30 06:22:05','2022-07-30 10:45:18','172.70.178.118'),(471,'llvp0g3cq2m7a10vf9om45dllt',6,1,'2022-07-30 10:45:18','2022-07-30 14:26:10','172.70.178.80'),(472,'kmgup7pfb2v9nfkm4ncq400uhd',10,2,'2022-08-01 05:32:49','2022-08-01 10:01:49','172.70.130.198'),(473,'9sdo3tb61g01i98qkufhvon8va',10,1,'2022-08-01 10:01:49','2022-08-01 11:08:25','172.70.131.149'),(474,'p38dhsr448n5eagd0mvd7op8l0',6,2,'2022-08-01 17:01:15','2022-08-02 07:01:44','172.70.178.66'),(475,'l7b6mht93uvt27130o8mjo6ojt',11,2,'2022-08-02 00:25:46','2022-08-02 18:45:18','172.68.34.254'),(476,'0v32ua5mmho453hof46gdi1ktg',6,1,'2022-08-02 07:01:44','2022-08-02 07:02:31','172.70.131.209'),(477,'easvv8ntpg2sba3h0i4l5uo4ek',15,2,'2022-08-02 18:41:17','2022-08-03 16:38:04','172.68.35.9'),(478,'k20be8bilck0h1uuv21obg2027',11,2,'2022-08-02 18:45:18','2022-08-03 17:16:03','172.68.35.5'),(479,'trqiv747uogrpgrf1egg4u8alj',10,2,'2022-08-03 08:03:45','2022-08-03 17:30:57','172.70.130.140'),(480,'ql52mp4ocieur2rr2br1qsh4ou',6,2,'2022-08-03 10:55:10','2022-08-03 17:02:56','172.70.130.74'),(481,'csvv5dksjqvhm52v7s98t30lca',15,2,'2022-08-03 16:38:03','2022-08-03 20:24:26','172.68.35.13'),(482,'vddun672mloufpmqsqptbpop6i',6,2,'2022-08-03 17:02:56','2022-08-04 03:25:48','172.68.34.186'),(483,'hfmgkv3lubo5pgs8tscj21iklv',11,2,'2022-08-03 17:16:03','2022-08-04 16:13:52','172.68.34.222'),(484,'lhtraqfbg7g5e46j7i62j2mc1j',12,2,'2022-08-03 17:16:21','2022-08-04 16:08:56','172.68.35.25'),(485,'tq58c8h7p21t2cu1ug4j5aunt4',10,2,'2022-08-03 17:30:57','2022-08-03 18:11:19','172.68.35.13'),(486,'t59djfft3nraqp20lt9d2lai61',10,2,'2022-08-03 18:11:19','2022-08-03 19:42:53','172.68.34.162'),(487,'q969eq7k9299gttra5he0vuqdi',10,2,'2022-08-03 19:42:53','2022-08-03 21:20:37','172.68.34.248'),(488,'4pu4pd3gcj504a8rsqek9qjte9',15,2,'2022-08-03 20:24:26','2022-08-04 16:13:32','162.158.166.92'),(489,'7n8khur8573p5o9vj5f3mr17dl',10,2,'2022-08-03 21:20:37','2022-08-04 05:13:48','172.69.134.20'),(490,'pofhdjpton4lf8jhfg4cl11vbh',6,2,'2022-08-04 03:25:48','2022-08-04 04:31:54','172.70.131.185'),(491,'ftb3j21qrt2v59ff8m0dmo317r',6,2,'2022-08-04 04:31:54','2022-08-04 06:06:24','162.158.191.130'),(492,'bbb68s0cs20pdruacirq44d8je',16,2,'2022-08-04 04:43:39','2022-08-04 06:58:22','172.70.130.110'),(493,'tccbbis29danstqlknef4b2pp4',10,2,'2022-08-04 05:13:48','2022-08-04 11:40:59','172.70.178.228'),(494,'a8f07ocvud9a44ja00lfthl44s',6,2,'2022-08-04 06:06:24','2022-08-04 07:12:46','172.70.179.3'),(495,'dvde1c6d9k70au97mpnq8ihp8r',7,2,'2022-08-04 06:32:54','2022-08-04 09:44:28','172.70.218.48'),(496,'h4b4ae2b3napgv9vtftd4rkabs',16,2,'2022-08-04 06:58:22','2022-08-04 09:27:16','172.70.178.52'),(497,'qa5ao8ht5p3vtfvs6n1d7u3n7d',6,2,'2022-08-04 07:12:46','2022-08-04 09:06:00','172.70.178.102'),(498,'a2d3c6mp3gfb6tcjllufhuancd',6,2,'2022-08-04 09:06:00','2022-08-04 11:45:51','172.70.178.16'),(499,'rvei1h3rg39olqkt60s5n7beaj',16,2,'2022-08-04 09:27:16','2022-08-04 11:12:26','172.70.178.36'),(500,'8pha038qklda5vqf74ae12flra',7,1,'2022-08-04 09:44:28','2022-08-04 09:45:17','172.70.178.226'),(501,'epffqu9jpiku3vrpq75lse3r8o',16,2,'2022-08-04 11:12:26','2022-08-05 05:11:15','172.70.130.158'),(502,'rcul5ive3a8b48i4kjch48imtp',10,2,'2022-08-04 11:40:59','2022-08-04 16:04:47','172.70.130.94'),(503,'8451gihtie9vk1kvidkrt0ga0f',6,2,'2022-08-04 11:45:51','2022-08-04 12:55:01','162.158.191.204'),(504,'psbii8b12lnovd7lun32bsg1kc',6,2,'2022-08-04 12:55:01','2022-08-05 03:52:30','172.70.178.98'),(505,'7ijp23fi7392lkhvm9ed4gh0dq',10,2,'2022-08-04 16:04:47','2022-08-04 18:24:49','162.158.48.100'),(506,'j7c95ml4on1p6kvtl0ma0v51bf',12,1,'2022-08-04 16:08:56','2022-08-04 16:14:23','172.68.34.254'),(507,'obilqok1cdak83a958v6ispd42',15,0,'2022-08-04 16:13:32','2022-08-04 17:44:36','172.69.22.84'),(508,'heonio97lkvr4gb1n1teegp4df',11,1,'2022-08-04 16:13:52','2022-08-04 16:27:13','172.68.34.126'),(509,'mqlas77o4ovj8p3jabes6b72vs',10,1,'2022-08-04 18:24:49','2022-08-04 19:19:52','172.68.34.218'),(510,'og3dkntbvvpp269upi25b370n1',15,2,'2022-08-04 19:36:47','2022-08-04 20:54:11','172.68.34.218'),(511,'ua23cbops6f1kciqcrgitgd1q4',15,2,'2022-08-04 20:54:11','2022-08-04 21:53:56','172.68.35.25'),(512,'loa3rgm3vtofdp3sv38bqu0ts2',15,0,'2022-08-04 21:53:56','2022-08-04 22:16:45','172.68.34.162'),(513,'1cfu72qlml0ljueeepfq8eeigo',15,0,'2022-08-04 22:16:47','2022-08-04 23:39:30','162.158.166.126'),(514,'d4qmd8oghoeqb1vqioq0ld0f4m',15,2,'2022-08-04 23:46:10','2022-08-05 06:07:18','172.68.34.150'),(515,'pn25ajesrqbq5spnbkqqusscl2',6,2,'2022-08-05 03:52:30','2022-08-05 05:17:35','172.70.130.170'),(516,'aghh5rgimupi11nb185ca6qs8v',16,2,'2022-08-05 05:11:15','2022-08-05 09:00:10','172.70.178.178'),(517,'i36mh4j3f9eivn4463pe5i53dm',6,2,'2022-08-05 05:17:35','2022-08-05 09:06:34','172.70.178.76'),(518,'6pmgufm0aa0p2qffok0hd6ep29',15,2,'2022-08-05 06:07:18','2022-08-05 08:37:47','172.68.34.222'),(519,'ltuoopbf9amb1fhojrcuiv7idl',15,0,'2022-08-05 08:37:47','2022-08-05 09:39:19','172.68.34.254'),(520,'p1p80rgmq3jkqhctpb3iv5d3qg',16,2,'2022-08-05 09:00:10','2022-08-05 12:39:30','172.70.179.23'),(521,'elj97lv9a5cbkcr8scjd12ps22',6,2,'2022-08-05 09:06:34','2022-08-05 13:02:01','172.70.178.56'),(522,'3djtc7ddv2mbju78aact2mb46a',15,2,'2022-08-05 09:50:34','2022-08-05 18:26:08','172.68.34.174'),(523,'l60ri4jm7nn2acgtv31ulatagk',7,1,'2022-08-05 11:20:05','2022-08-05 11:20:59','172.70.178.232'),(524,'f95te2bil18gp5h4dsn817kieo',16,1,'2022-08-05 12:39:30','2022-08-05 13:39:33','172.70.130.74'),(525,'ehdphbfcp2n2tros9vk091n5f7',6,1,'2022-08-05 13:02:01','2022-08-05 13:02:01','172.70.130.134'),(526,'o74m270g4l1vuqoa6cirj8m98p',15,1,'2022-08-05 18:26:08','2022-08-05 18:31:44','172.68.34.222'),(527,'34ubkvqdlpt6ptdt9745lvpchj',16,1,'2022-08-07 09:46:16','2022-08-07 09:48:05','172.68.34.250'),(528,'9dn0rcms76jmljgi46cnlqi6g3',16,2,'2022-08-08 09:54:48','2022-08-08 11:54:36','172.70.130.128'),(529,'njg5hn464ffpqd9fihdilsbb3f',6,2,'2022-08-08 09:58:06','2022-08-08 11:36:14','172.70.130.70'),(530,'qcru5m83e1gel665s9kc9hrica',10,2,'2022-08-08 10:35:08','2022-08-08 11:45:27','172.70.131.7'),(531,'ch7i78io9lpmsk04o87he5093a',6,1,'2022-08-08 11:36:14','2022-08-08 11:37:09','172.70.130.166'),(532,'psobgcv74sd8un4gqe263tvf40',10,1,'2022-08-08 11:45:27','2022-08-08 12:20:12','172.70.178.164'),(533,'2qtgglol948g08p0aamm7jt7ib',16,2,'2022-08-08 11:54:36','2022-08-08 12:24:29','172.70.131.99'),(534,'blgpj8uai9rmmnj7gq91jlfhm2',9,1,'2022-08-08 11:56:15','2022-08-08 11:59:00','172.70.178.88'),(535,'gbl7d6l06b60al4p30kldsjrda',16,2,'2022-08-08 12:24:29','2022-08-08 12:34:33','172.70.179.13'),(536,'vsefs7n531r94sse6cjvm0r3sk',7,1,'2022-08-08 12:26:32','2022-08-08 12:42:50','172.70.178.178'),(537,'6j8b3jj73sok7nvnphopl5em19',16,2,'2022-08-08 12:34:33','2022-08-08 12:36:50','172.70.130.130'),(538,'44fvg7rn76b73vu5755km4o5q5',16,2,'2022-08-08 12:36:50','2022-08-09 04:15:43','162.158.235.69'),(539,'1b81d5qg67msif86b10neoq3qb',16,2,'2022-08-09 04:15:43','2022-08-09 09:25:09','172.70.178.10'),(540,'sq94egj1qngguivm3v0qqvgrur',16,1,'2022-08-09 09:25:09','2022-08-09 09:25:09','172.70.178.204'),(541,'7gktegfhgpsptes64jj3a09tme',15,2,'2022-08-09 18:48:36','2022-08-09 20:29:13','172.68.34.192'),(542,'v8c481urh5fgvu79p5lmdim2eh',15,2,'2022-08-09 20:29:13','2022-08-10 16:06:38','172.68.35.5'),(543,'453du57fml5o9re0ei9oseebhq',7,2,'2022-08-10 03:28:15','2022-08-10 04:49:03','172.70.178.138'),(544,'ivtlnj9f5n9geog8r20ggn1uln',7,1,'2022-08-10 04:49:03','2022-08-10 04:51:07','172.70.179.11'),(545,'42iingoosphut319mc0alfm3mu',6,1,'2022-08-10 06:54:34','2022-08-10 06:54:34','172.70.178.96'),(546,'isp43i996k31i7r3m53ctear7v',15,1,'2022-08-10 16:06:38','2022-08-10 16:49:19','172.68.35.23');
/*!40000 ALTER TABLE `admin_user_session` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adminnotification_inbox`
--

DROP TABLE IF EXISTS `adminnotification_inbox`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `adminnotification_inbox` (
  `notification_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Notification ID',
  `severity` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Problem type',
  `date_added` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Create date',
  `title` varchar(255) NOT NULL COMMENT 'Title',
  `description` text COMMENT 'Description',
  `url` varchar(255) DEFAULT NULL COMMENT 'Url',
  `is_read` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Flag if notification read',
  `is_remove` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Flag if notification might be removed',
  PRIMARY KEY (`notification_id`),
  KEY `ADMINNOTIFICATION_INBOX_SEVERITY` (`severity`),
  KEY `ADMINNOTIFICATION_INBOX_IS_READ` (`is_read`),
  KEY `ADMINNOTIFICATION_INBOX_IS_REMOVE` (`is_remove`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8 COMMENT='Adminnotification Inbox';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adminnotification_inbox`
--

LOCK TABLES `adminnotification_inbox` WRITE;
/*!40000 ALTER TABLE `adminnotification_inbox` DISABLE KEYS */;
INSERT INTO `adminnotification_inbox` VALUES (1,4,'2020-12-16 03:07:55','Disable Notice','To improve performance, collecting statistics for the Magento Report module is disabled by default. \nYou can enable it in System Config.','',0,0),(2,3,'2020-12-16 03:49:11','New version 2.9.7 of Magefan Magento 2 Blog Extension is now available.',' You can download the new version from Magefan Store or update it via composer. Get us in touch if you need our help with an update or you have any questions.\n                                    https://magefan.com/magento2-blog-extension?version=2.9.7\n                                 ','https://magefan.com/magento2-blog-extension?version=2.9.7',0,0),(3,4,'2020-12-16 03:49:11','FAQ: How to configure &quot;read more&quot; in your Magento 2 blog post',' If you still don&#039;t know how to configure read more functionality in your magento 2 blog post, please read this article.\n                    Online documentation for Magento 2 blog extension is also available on our website. http://goo.gl/XOEdpy ','http://magefan.com/blog/add-read-more-tag-to-blog-post-content/?from=notification1',0,0),(4,4,'2021-01-08 21:35:55','Happy new year! Is Your Website Selling as Much as It Can? Watch our on-demand webinar and learn how to turn your website into a conversion machine.','Watch our on-demand webinar: Is Your Website Selling As Much As It Can? Digital Strategist Ereika Stimley and eCommerce Consultant Corey Gelato will walk you through a website self-assessment and live demo that will help you uncover opportunities to increase conversions and grow revenues. Watch now: https://bit.ly/2EAujMc','https://bit.ly/2EAujMc',0,0),(5,4,'2021-01-14 01:32:42','You&#039;re invited to our webinar: Is Magento Commerce or Open Source right for you? ','Magento Commerce and Magento Open Source may sound alike, but each offers sharply distinct benefits. To get the facts, sign up for our webinar Is Magento Commerce or Open Source right for you? at 10:00 AM PT on February 4th. Register now: http://bit.ly/3icfnTM','http://bit.ly/3icfnTM',0,0),(6,4,'2021-02-10 15:06:05','Magento Commerce 2.4.2 delivers important security updates and features to help secure and optimize your store','Magento Open Source 2.4.2, along with security-only patches 2.3.6-p1 and 2.4.1-p1, is now generally available. The latest release of Magento Open Source includes important security enhancements along with new functionality and platform quality improvements. With these important updates we strongly recommend that you upgrade to ensure your sites maintain the highest level of security. You can review the release notes for more information about all of the enhancements. Learn how this release can help you save time and maximize resources at Magento.com/blog. ','https://devdocs.magento.com/guides/v2.4/release-notes/bk-release-notes.html',0,0),(7,4,'2021-02-10 15:08:37','Register now for Summit 2021 and stay ahead of commerce trends ','Learn best practices from digital commerce experts during two days of live keynotes, sessions, and sneak peeks. Understand the latest digital commerce trends, discover industry best practices, and network with peers around the world. Register now!','https://summit.adobe.com/na/?utm_source=m1o&amp;utm_medium=rss&amp;utm_campaign=NA_210427_12576_RSS_EVTR_ACOM_FM_Summit_2021_M1_OS',0,0),(8,4,'2021-02-22 23:52:27','Quarterly Business Planning - reach out to us today to get your free site assessment.','Would you like a free site assessment? Our best-in-breed commerce solution gives your business unmatched agility and scalability. It&#039;s time to experience limitless eCommerce with no comprises. Learn more: https://bit.ly/3lcgILt','https://bit.ly/3lcgILt',0,0),(9,4,'2021-03-23 00:33:54','You&#039;re invited to our webinar this week: How digital commerce can scale B2B selling','Digital commerce is fast becoming the default way to buy—even for B2B customers. In just 8 weeks, Byrne Electrical, the leading manufacturer of power and data solutions for numerous industries, launched an eCommerce portal for more than 1,100 of their customers. To learn how they did it, join George Fabis, Director of IT for Byrne, and Slava Kravchuk, CEO &amp; Founder of Atwix, a Magento Commerce solutions partner, for a live discussion on Thursday, March 25. Register Now: https://bit.ly/3r1MCvG','https://bit.ly/3r1MCvG',0,0),(10,3,'2021-04-12 08:15:30','New version 2.9.8 of Magefan Magento 2 Blog Extension is now available.',' You can download the new version from Magefan Store or update it via composer. Get us in touch if you need our help with an update or you have any questions.\n                                    https://magefan.com/magento2-blog-extension?version=2.9.8\n                                 ','https://magefan.com/magento2-blog-extension?version=2.9.8',0,0),(11,4,'2021-05-11 20:44:41','Magento Open Source 2.4.2-p1 &amp; 2.3.7 deliver important security updates','The latest releases of Magento Open Source – 2.3.7 and 2.4.2-p1 – are now generally available. The latest release of Magento Open Source includes important security updates. With these important updates we strongly recommend that you upgrade to ensure your sites maintain the highest level of security. You can review the release notes for more information about all of the updates. Learn how this release can help you save time and maximize resources at Magento.com/blog.','https://devdocs.magento.com/guides/v2.3/release-notes/bk-release-notes.html ',0,0),(12,3,'2021-05-24 03:01:35','New version 2.10.1 of Magefan Magento 2 Blog Extension is now available.',' You can download the new version from Magefan Store or update it via composer. Get us in touch if you need our help with an update or you have any questions.\n                                    https://magefan.com/magento2-blog-extension?version=2.10.1\n                                 ','https://magefan.com/magento2-blog-extension?version=2.10.1',0,0),(13,3,'2021-07-22 02:54:57','New version 2.10.2 of Magefan Magento 2 Blog Extension is now available.',' You can download the new version from Magefan Store or update it via composer. Get us in touch if you need our help with an update or you have any questions.\n                                    https://magefan.com/magento2-blog-extension?version=2.10.2\n                                 ','https://magefan.com/magento2-blog-extension?version=2.10.2',0,0),(14,3,'2021-08-03 00:00:00','New FREE Magento 2 Facebook Pixel Extension','Integrate Facebook Pixel just in a few clicks with the new FREE Magento 2 Facebook Pixel Extension. Hurry up to try it out! https://magefan.com/magento-2-facebook-pixel-extension','https://magefan.com/magento-2-facebook-pixel-extension?utm_source=website&amp;utm_medium=admin_notification&amp;utm_campaign=new_extension_fb_pixel',0,0),(15,4,'2021-08-10 17:53:11','Magento Open Source 2.4.3 available today!','Magento Open Source 2.4.3, along with security-only patches 2.4.2-p1 and 2.3.7-p2, is now generally available. Magento Open Source 2.4.3 includes 33 security and 370+ quality improvements, along with performance and scale enhancements.  With these important updates, we strongly recommend that you upgrade to maintain the highest level of security for your sites. Learn how this release can help you save time and maximize resources in our release blog. ','http://magento.com/blog/magento-news/get-ready-your-peak-season-adobe-commerce-243',0,0),(16,3,'2021-09-16 07:10:33','New version 2.10.3 of Magefan Magento 2 Blog Extension is now available.',' You can download the new version from Magefan Store or update it via composer. Get us in touch if you need our help with an update or you have any questions.\n                                    https://magefan.com/magento2-blog-extension?version=2.10.3\n                                 ','https://magefan.com/magento2-blog-extension?version=2.10.3',0,0),(17,4,'2021-10-22 19:06:48','Magento Technology Stack Evaluation Survey','Please take a few minutes to fill out this survey https://forms.office.com/r/DLN8K3h2h0. We appreciate your effort to support the future of Adobe Commerce!','https://forms.office.com/r/DLN8K3h2h0',0,0),(18,3,'2021-11-17 07:05:17','New version 2.10.4 of Magefan Magento 2 Blog Extension is now available.',' You can download the new version from Magefan Store or update it via composer. Get us in touch if you need our help with an update or you have any questions.\n                                    https://magefan.com/magento2-blog-extension?version=2.10.4\n                                 ','https://magefan.com/magento2-blog-extension?version=2.10.4',0,0),(19,4,'2021-11-17 00:00:00','Guess whose birthday it is today? Magefan&#039;s!','Hurry up to get FREE Installation Service with any of Magento 2 extension purchased on November 2021! ','https://magefan.com/magento2-extensions?utm_source=website_admin&amp;utm_medium=a_notification&amp;utm_campaign=magefan6&amp;utm_id=magefan%27sbday',0,0),(20,4,'2021-11-22 00:00:00','This Deal’s Unreal! ','Save up to 50% OFF all Magento 2 extensions this Black Friday. Explore the best offers of the year now! https://bit.ly/3HLUQ4Y','https://magefan.com/magento2-extensions?utm_source=admn-ntf&amp;utm_medium=notice&amp;utm_campaign=black-friday-sale&amp;utm_id=bf-2021',0,0),(21,4,'2021-11-28 00:00:00','Missed Black Friday Deals? Cyber Monday is here.','Save up to 30% off all Magento 2 extensions - this week only. Buy more and pay less this last BIG sale of the year! Visit our website https://bit.ly/3p78GWZ','https://magefan.com/magento2-extensions?utm_source=admn-ntfct&amp;utm_medium=notice&amp;utm_campaign=cyber-monday-sale&amp;utm_id=cm-2021',0,0),(22,4,'2021-12-06 00:00:00','NEW Magento 2 AMP Blog Release! ','This extension integrates our Magento 2 Blog Extension with Magento 2 AMP extension by  Plumrocket, our trusted partner.  Improve your Blog on mobile devices for better user engagement!  https://bit.ly/3y2Yy5z','https://magefan.com/magento-2-amp-blog-extension?utm_source=admin&amp;utm_medium=notifications&amp;utm_id=new-release-ampblog',0,0),(23,4,'2021-12-15 00:00:00','Save up to 15% OFF select M2 extensions - Happy Holidays from the Magefan team!  ','Wishing you and your families peaceful and joyful holidays! Check out our Christmas Sale https://bit.ly/3s51aPw','https://magefan.com/magento2-extensions?utm_source=admin-notif&amp;utm_medium=ntf&amp;utm_campaign=christmas-sale&amp;utm_id=15off ',0,1),(24,3,'2022-02-26 03:22:02','New version 2.10.5 of Magefan Magento 2 Blog Extension is now available.',' You can download the new version from Magefan Store or update it via composer. Get us in touch if you need our help with an update or you have any questions.\n                                    https://magefan.com/magento2-blog-extension?version=2.10.5\n                                 ','https://magefan.com/magento2-blog-extension?version=2.10.5',0,0),(25,2,'2022-03-01 23:33:53','Magento Open Source 2.4.4 Coming April 12','To help ensure this release delivers the highest standards of security and quality, general availability of Magento Open Source is now planned for April 12. For more information, visit our DevBlog. ','https://community.magento.com/t5/Magento-DevBlog/Adobe-Commerce-2-4-4-Now-Coming-April-12/ba-p/492935',0,0),(26,3,'2022-03-14 03:48:01','New version 2.10.6 of Magefan Magento 2 Blog Extension is now available.',' You can download the new version from Magefan Store or update it via composer. Get us in touch if you need our help with an update or you have any questions.\n                                    https://magefan.com/magento2-blog-extension?version=2.10.6\n                                 ','https://magefan.com/magento2-blog-extension?version=2.10.6',0,0),(27,3,'2022-04-27 07:33:16','New version 2.10.7 of Magefan Magento 2 Blog Extension is now available.',' You can download the new version from Magefan Store or update it via composer. Get us in touch if you need our help with an update or you have any questions.\n                                    https://magefan.com/magento2-blog-extension?version=2.10.7\n                                 ','https://magefan.com/magento2-blog-extension?version=2.10.7',0,0),(28,1,'2022-04-27 11:31:39','Error during export process occurred','Error during export process occurred. Please check logs for detail','',0,0),(29,1,'2022-04-27 11:32:21','Error during export process occurred','Error during export process occurred. Please check logs for detail','',0,0),(30,2,'2022-04-27 11:39:34','Your export file is ready','You can pick up your file at export main page','',0,0),(31,3,'2022-05-12 05:51:09','New version 2.10.8 of Magefan Magento 2 Blog Extension is now available.',' You can download the new version from Magefan Store or update it via composer. Get us in touch if you need our help with an update or you have any questions.\n                                    https://magefan.com/magento2-blog-extension?version=2.10.8\n                                 ','https://magefan.com/magento2-blog-extension?version=2.10.8',0,0),(32,2,'2022-05-13 10:17:15','Your export file is ready','You can pick up your file at export main page','',0,0),(33,4,'2022-05-24 15:06:25','Prepared to upgrade to Magento Open Source 2.4.4?','With 2.3 end of support (EOS) in September and 2.4.0-2.4.3 EOS in November, it is critical to have an upgrade plan in place to make sure your site stays secure, performant and PCI-Compliant. Learn more about how Magento Open Source 2.4.4 will future-proof your business.','https://business.adobe.com/blog/perspectives/future-proof-your-business-with-adobe-commerce-2-4-4',0,0),(34,2,'2022-06-09 04:40:19','Your export file is ready','You can pick up your file at export main page','',0,0),(35,2,'2022-06-23 12:15:56','Your export file is ready','You can pick up your file at export main page','',0,0),(36,2,'2022-06-24 09:10:55','Your export file is ready','You can pick up your file at export main page','',0,0),(37,3,'2022-06-28 11:20:55','New version 2.10.9 of Magefan Magento 2 Blog Extension is now available.',' You can download the new version from Magefan Store or update it via composer. Get us in touch if you need our help with an update or you have any questions.\n                                    https://magefan.com/magento2-blog-extension?version=2.10.9\n                                 ','https://magefan.com/magento2-blog-extension?version=2.10.9',0,0),(38,4,'2022-06-23 00:00:00','New Magento 2 Edit Order Extension','Edit orders without cancel. Update payment, shipping, customer, and order items information within the order view page.','https://magefan.com/magento-2-edit-order-extension?utm_source=admin&amp;utm_medium=ntf&amp;utm_campaign=new-release&amp;utm_id=new-oe ',0,0),(39,2,'2022-06-28 11:46:25','Your export file is ready','You can pick up your file at export main page','',0,0),(40,2,'2022-07-11 16:13:28','Your export file is ready','You can pick up your file at export main page','',0,0),(41,2,'2022-07-20 05:29:13','Your export file is ready','You can pick up your file at export main page','',0,0),(42,2,'2022-07-20 06:39:18','Your export file is ready','You can pick up your file at export main page','',0,0),(43,4,'2022-07-26 16:18:18','Expanded video library on the Adobe Commerce Experience League','Check out our expanded video library on the Adobe Commerce Experience League that now has a set of 35 short demo videos of our core Adobe Commerce capabilities and support tools.','https://experienceleague.adobe.com/docs/commerce-learn/tutorials/overview.html?lang=en',0,0),(44,2,'2022-08-08 11:58:00','Your export file is ready','You can pick up your file at export main page','',0,0);
/*!40000 ALTER TABLE `adminnotification_inbox` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adobe_stock_asset`
--

DROP TABLE IF EXISTS `adobe_stock_asset`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `adobe_stock_asset` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `media_gallery_id` int(10) unsigned DEFAULT NULL COMMENT 'Media gallery ID',
  `category_id` int(10) unsigned DEFAULT NULL COMMENT 'Category ID',
  `creator_id` int(10) unsigned DEFAULT NULL COMMENT 'Creator ID',
  `is_licensed` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Licensed',
  `creation_date` varchar(255) DEFAULT NULL COMMENT 'Creation Date',
  PRIMARY KEY (`id`),
  KEY `ADOBE_STOCK_ASSET_MEDIA_GALLERY_ID_MEDIA_GALLERY_ASSET_ID` (`media_gallery_id`),
  KEY `ADOBE_STOCK_ASSET_ID` (`id`),
  KEY `ADOBE_STOCK_ASSET_CATEGORY_ID` (`category_id`),
  KEY `ADOBE_STOCK_ASSET_CREATOR_ID` (`creator_id`),
  CONSTRAINT `ADOBE_STOCK_ASSET_CATEGORY_ID_ADOBE_STOCK_CATEGORY_ID` FOREIGN KEY (`category_id`) REFERENCES `adobe_stock_category` (`id`) ON DELETE SET NULL,
  CONSTRAINT `ADOBE_STOCK_ASSET_CREATOR_ID_ADOBE_STOCK_CREATOR_ID` FOREIGN KEY (`creator_id`) REFERENCES `adobe_stock_creator` (`id`) ON DELETE SET NULL,
  CONSTRAINT `ADOBE_STOCK_ASSET_MEDIA_GALLERY_ID_MEDIA_GALLERY_ASSET_ID` FOREIGN KEY (`media_gallery_id`) REFERENCES `media_gallery_asset` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Adobe Stock Asset';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adobe_stock_asset`
--

LOCK TABLES `adobe_stock_asset` WRITE;
/*!40000 ALTER TABLE `adobe_stock_asset` DISABLE KEYS */;
/*!40000 ALTER TABLE `adobe_stock_asset` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adobe_stock_category`
--

DROP TABLE IF EXISTS `adobe_stock_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `adobe_stock_category` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `name` varchar(255) DEFAULT NULL COMMENT 'Name',
  PRIMARY KEY (`id`),
  KEY `ADOBE_STOCK_CATEGORY_ID` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Adobe Stock Category';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adobe_stock_category`
--

LOCK TABLES `adobe_stock_category` WRITE;
/*!40000 ALTER TABLE `adobe_stock_category` DISABLE KEYS */;
/*!40000 ALTER TABLE `adobe_stock_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adobe_stock_creator`
--

DROP TABLE IF EXISTS `adobe_stock_creator`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `adobe_stock_creator` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `name` varchar(255) DEFAULT NULL COMMENT 'Asset creator''s name',
  PRIMARY KEY (`id`),
  KEY `ADOBE_STOCK_CREATOR_ID` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Adobe Stock Creator';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adobe_stock_creator`
--

LOCK TABLES `adobe_stock_creator` WRITE;
/*!40000 ALTER TABLE `adobe_stock_creator` DISABLE KEYS */;
/*!40000 ALTER TABLE `adobe_stock_creator` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adobe_user_profile`
--

DROP TABLE IF EXISTS `adobe_user_profile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `adobe_user_profile` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `admin_user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Admin User Id',
  `name` varchar(255) NOT NULL COMMENT 'Display Name',
  `email` varchar(255) NOT NULL COMMENT 'user profile email',
  `image` varchar(255) NOT NULL COMMENT 'user profile avatar',
  `account_type` varchar(255) DEFAULT NULL COMMENT 'Account Type',
  `access_token` text COMMENT 'Access Token',
  `refresh_token` text COMMENT 'Refresh Token',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created At',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Updated At',
  `access_token_expires_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'Access Token Expires At',
  PRIMARY KEY (`id`),
  KEY `ADOBE_USER_PROFILE_ADMIN_USER_ID_ADMIN_USER_USER_ID` (`admin_user_id`),
  KEY `ADOBE_USER_PROFILE_ID` (`id`),
  CONSTRAINT `ADOBE_USER_PROFILE_ADMIN_USER_ID_ADMIN_USER_USER_ID` FOREIGN KEY (`admin_user_id`) REFERENCES `admin_user` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Adobe IMS User Profile';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adobe_user_profile`
--

LOCK TABLES `adobe_user_profile` WRITE;
/*!40000 ALTER TABLE `adobe_user_profile` DISABLE KEYS */;
/*!40000 ALTER TABLE `adobe_user_profile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `amazon_customer`
--

DROP TABLE IF EXISTS `amazon_customer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amazon_customer` (
  `entity_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity_id',
  `customer_id` int(10) unsigned NOT NULL COMMENT 'Customer_id',
  `amazon_id` varchar(255) NOT NULL COMMENT 'Amazon_id',
  PRIMARY KEY (`entity_id`),
  UNIQUE KEY `AMAZON_CUSTOMER_CUSTOMER_ID_AMAZON_ID` (`customer_id`,`amazon_id`),
  UNIQUE KEY `AMAZON_CUSTOMER_CUSTOMER_ID` (`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='amazon_customer';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `amazon_customer`
--

LOCK TABLES `amazon_customer` WRITE;
/*!40000 ALTER TABLE `amazon_customer` DISABLE KEYS */;
/*!40000 ALTER TABLE `amazon_customer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `amazon_pending_authorization`
--

DROP TABLE IF EXISTS `amazon_pending_authorization`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amazon_pending_authorization` (
  `entity_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity_id',
  `order_id` int(10) unsigned NOT NULL COMMENT 'Order_id',
  `payment_id` int(10) unsigned NOT NULL COMMENT 'Payment_id',
  `authorization_id` varchar(255) DEFAULT NULL COMMENT 'Authorization_id',
  `created_at` datetime NOT NULL COMMENT 'Created_at',
  `updated_at` datetime DEFAULT NULL COMMENT 'Updated_at',
  `processed` smallint(5) unsigned DEFAULT '0' COMMENT 'Initial authorization processed',
  `capture` smallint(5) unsigned DEFAULT '0' COMMENT 'Initial authorization has capture',
  `capture_id` varchar(255) DEFAULT NULL COMMENT 'Initial authorization capture id',
  PRIMARY KEY (`entity_id`),
  UNIQUE KEY `UNQ_E6CCA08713FB32BB136A56837009C371` (`order_id`,`payment_id`,`authorization_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='amazon_pending_authorization';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `amazon_pending_authorization`
--

LOCK TABLES `amazon_pending_authorization` WRITE;
/*!40000 ALTER TABLE `amazon_pending_authorization` DISABLE KEYS */;
/*!40000 ALTER TABLE `amazon_pending_authorization` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `amazon_pending_capture`
--

DROP TABLE IF EXISTS `amazon_pending_capture`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amazon_pending_capture` (
  `entity_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity_id',
  `capture_id` varchar(255) NOT NULL COMMENT 'Capture_id',
  `created_at` datetime NOT NULL COMMENT 'Created_at',
  `order_id` int(10) unsigned NOT NULL COMMENT 'order id',
  `payment_id` int(10) unsigned NOT NULL COMMENT 'payment id',
  PRIMARY KEY (`entity_id`),
  UNIQUE KEY `AMAZON_PENDING_CAPTURE_ORDER_ID_PAYMENT_ID_CAPTURE_ID` (`order_id`,`payment_id`,`capture_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='amazon_pending_capture';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `amazon_pending_capture`
--

LOCK TABLES `amazon_pending_capture` WRITE;
/*!40000 ALTER TABLE `amazon_pending_capture` DISABLE KEYS */;
/*!40000 ALTER TABLE `amazon_pending_capture` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `amazon_pending_refund`
--

DROP TABLE IF EXISTS `amazon_pending_refund`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amazon_pending_refund` (
  `entity_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity_id',
  `refund_id` varchar(255) NOT NULL COMMENT 'Refund_id',
  `created_at` datetime NOT NULL COMMENT 'Created_at',
  `order_id` int(10) unsigned NOT NULL COMMENT 'Order_id',
  `payment_id` int(10) unsigned NOT NULL COMMENT 'Payment_id',
  PRIMARY KEY (`entity_id`),
  UNIQUE KEY `AMAZON_PENDING_REFUND_ORDER_ID_PAYMENT_ID_REFUND_ID` (`order_id`,`payment_id`,`refund_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='amazon_pending_refund';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `amazon_pending_refund`
--

LOCK TABLES `amazon_pending_refund` WRITE;
/*!40000 ALTER TABLE `amazon_pending_refund` DISABLE KEYS */;
/*!40000 ALTER TABLE `amazon_pending_refund` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `amazon_quote`
--

DROP TABLE IF EXISTS `amazon_quote`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amazon_quote` (
  `entity_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `quote_id` int(10) unsigned NOT NULL COMMENT 'Quote ID',
  `amazon_order_reference_id` varchar(255) NOT NULL COMMENT 'Amazon Order Reference ID',
  `sandbox_simulation_reference` varchar(255) DEFAULT NULL COMMENT 'Sandbox simulation reference',
  `confirmed` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Quote confirmed with Amazon',
  PRIMARY KEY (`entity_id`),
  UNIQUE KEY `AMAZON_QUOTE_QUOTE_ID` (`quote_id`),
  CONSTRAINT `AMAZON_QUOTE_QUOTE_ID_QUOTE_ENTITY_ID` FOREIGN KEY (`quote_id`) REFERENCES `quote` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='amazon_quote';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `amazon_quote`
--

LOCK TABLES `amazon_quote` WRITE;
/*!40000 ALTER TABLE `amazon_quote` DISABLE KEYS */;
/*!40000 ALTER TABLE `amazon_quote` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `amazon_sales_order`
--

DROP TABLE IF EXISTS `amazon_sales_order`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amazon_sales_order` (
  `entity_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `order_id` int(10) unsigned NOT NULL COMMENT 'Order ID',
  `amazon_order_reference_id` varchar(255) NOT NULL COMMENT 'Amazon Order Reference ID',
  PRIMARY KEY (`entity_id`),
  UNIQUE KEY `AMAZON_SALES_ORDER_ORDER_ID` (`order_id`),
  CONSTRAINT `AMAZON_SALES_ORDER_ORDER_ID_SALES_ORDER_ENTITY_ID` FOREIGN KEY (`order_id`) REFERENCES `sales_order` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='amazon_sales_order';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `amazon_sales_order`
--

LOCK TABLES `amazon_sales_order` WRITE;
/*!40000 ALTER TABLE `amazon_sales_order` DISABLE KEYS */;
/*!40000 ALTER TABLE `amazon_sales_order` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `authorization_role`
--

DROP TABLE IF EXISTS `authorization_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `authorization_role` (
  `role_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Role ID',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Parent Role ID',
  `tree_level` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Role Tree Level',
  `sort_order` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Role Sort Order',
  `role_type` varchar(1) NOT NULL DEFAULT '0' COMMENT 'Role Type',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'User ID',
  `user_type` varchar(16) DEFAULT NULL COMMENT 'User Type',
  `role_name` varchar(50) DEFAULT NULL COMMENT 'Role Name',
  PRIMARY KEY (`role_id`),
  KEY `AUTHORIZATION_ROLE_PARENT_ID_SORT_ORDER` (`parent_id`,`sort_order`),
  KEY `AUTHORIZATION_ROLE_TREE_LEVEL` (`tree_level`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8 COMMENT='Admin Role Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `authorization_role`
--

LOCK TABLES `authorization_role` WRITE;
/*!40000 ALTER TABLE `authorization_role` DISABLE KEYS */;
INSERT INTO `authorization_role` VALUES (1,0,1,1,'G',0,'2','Administrators'),(2,1,2,0,'U',1,'2','admin'),(3,1,2,0,'U',2,'2','admin'),(4,1,2,0,'U',3,'2','admin'),(5,1,2,0,'U',4,'2','admin'),(7,1,2,0,'U',6,'2','admin'),(12,1,2,0,'U',8,'2','Mounika'),(14,1,2,0,'U',7,'2','PO2GO'),(15,1,2,0,'U',10,'2','nautiyal_sumit'),(17,1,2,0,'U',11,'2','Bhavya '),(18,1,2,0,'U',12,'2','Fengran '),(19,1,2,0,'U',13,'2','Harsh'),(20,1,2,0,'U',14,'2','Arturo'),(21,1,2,0,'U',15,'2','Kevin'),(22,1,2,0,'U',16,'2','Akshay'),(24,1,2,0,'U',9,'2','Tejas');
/*!40000 ALTER TABLE `authorization_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `authorization_rule`
--

DROP TABLE IF EXISTS `authorization_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `authorization_rule` (
  `rule_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Rule ID',
  `role_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Role ID',
  `resource_id` varchar(255) DEFAULT NULL COMMENT 'Resource ID',
  `privileges` varchar(20) DEFAULT NULL COMMENT 'Privileges',
  `permission` varchar(10) DEFAULT NULL COMMENT 'Permission',
  PRIMARY KEY (`rule_id`),
  KEY `AUTHORIZATION_RULE_RESOURCE_ID_ROLE_ID` (`resource_id`,`role_id`),
  KEY `AUTHORIZATION_RULE_ROLE_ID_RESOURCE_ID` (`role_id`,`resource_id`),
  CONSTRAINT `AUTHORIZATION_RULE_ROLE_ID_AUTHORIZATION_ROLE_ROLE_ID` FOREIGN KEY (`role_id`) REFERENCES `authorization_role` (`role_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='Admin Rule Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `authorization_rule`
--

LOCK TABLES `authorization_rule` WRITE;
/*!40000 ALTER TABLE `authorization_rule` DISABLE KEYS */;
INSERT INTO `authorization_rule` VALUES (1,1,'Magento_Backend::all',NULL,'allow');
/*!40000 ALTER TABLE `authorization_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `braintree_credit_prices`
--

DROP TABLE IF EXISTS `braintree_credit_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `braintree_credit_prices` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Row ID',
  `product_id` int(10) unsigned NOT NULL COMMENT 'Product Id',
  `term` int(11) NOT NULL COMMENT 'Credit Term',
  `monthly_payment` decimal(12,2) NOT NULL COMMENT 'Monthly Payment',
  `instalment_rate` decimal(12,2) NOT NULL COMMENT 'Instalment Rate',
  `cost_of_purchase` decimal(12,2) NOT NULL COMMENT 'Cost of purchase',
  `total_inc_interest` decimal(12,2) NOT NULL COMMENT 'Total Inc Interest',
  PRIMARY KEY (`id`),
  UNIQUE KEY `BRAINTREE_CREDIT_PRICES_PRODUCT_ID_TERM` (`product_id`,`term`),
  KEY `BRAINTREE_CREDIT_PRICES_PRODUCT_ID` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Braintree credit rates';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `braintree_credit_prices`
--

LOCK TABLES `braintree_credit_prices` WRITE;
/*!40000 ALTER TABLE `braintree_credit_prices` DISABLE KEYS */;
/*!40000 ALTER TABLE `braintree_credit_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `braintree_transaction_details`
--

DROP TABLE IF EXISTS `braintree_transaction_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `braintree_transaction_details` (
  `entity_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `order_id` int(10) unsigned NOT NULL COMMENT 'Order Id',
  `transaction_source` varchar(12) DEFAULT NULL COMMENT 'Transaction Source',
  PRIMARY KEY (`entity_id`),
  KEY `BRAINTREE_TRANSACTION_DETAILS_ORDER_ID` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Braintree transaction details table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `braintree_transaction_details`
--

LOCK TABLES `braintree_transaction_details` WRITE;
/*!40000 ALTER TABLE `braintree_transaction_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `braintree_transaction_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache`
--

DROP TABLE IF EXISTS `cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cache` (
  `id` varchar(200) NOT NULL COMMENT 'Cache Id',
  `data` mediumblob COMMENT 'Cache Data',
  `create_time` int(11) DEFAULT NULL COMMENT 'Cache Creation Time',
  `update_time` int(11) DEFAULT NULL COMMENT 'Time of Cache Updating',
  `expire_time` int(11) DEFAULT NULL COMMENT 'Cache Expiration Time',
  PRIMARY KEY (`id`),
  KEY `CACHE_EXPIRE_TIME` (`expire_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Caches';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache`
--

LOCK TABLES `cache` WRITE;
/*!40000 ALTER TABLE `cache` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache_tag`
--

DROP TABLE IF EXISTS `cache_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cache_tag` (
  `tag` varchar(100) NOT NULL COMMENT 'Tag',
  `cache_id` varchar(200) NOT NULL COMMENT 'Cache Id',
  PRIMARY KEY (`tag`,`cache_id`),
  KEY `CACHE_TAG_CACHE_ID` (`cache_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tag Caches';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_tag`
--

LOCK TABLES `cache_tag` WRITE;
/*!40000 ALTER TABLE `cache_tag` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `captcha_log`
--

DROP TABLE IF EXISTS `captcha_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `captcha_log` (
  `type` varchar(32) NOT NULL COMMENT 'Type',
  `value` varchar(255) NOT NULL COMMENT 'Value',
  `count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Count',
  `updated_at` timestamp NULL DEFAULT NULL COMMENT 'Update Time',
  PRIMARY KEY (`type`,`value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Count Login Attempts';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `captcha_log`
--

LOCK TABLES `captcha_log` WRITE;
/*!40000 ALTER TABLE `captcha_log` DISABLE KEYS */;
INSERT INTO `captcha_log` VALUES ('1','162.158.166.152',1,'2022-08-03 17:15:42'),('1','162.158.191.130',1,'2022-08-04 09:43:32'),('1','162.158.191.216',1,'2022-08-08 09:56:18'),('1','162.158.55.17',1,'2022-04-28 07:11:47'),('1','162.158.55.43',3,'2022-04-28 07:14:07'),('1','172.68.34.138',1,'2022-08-04 19:36:24'),('1','172.68.34.180',1,'2022-07-29 16:27:33'),('1','172.68.34.216',1,'2022-08-10 16:06:34'),('1','172.68.34.220',1,'2022-08-03 20:24:15'),('1','172.68.35.13',1,'2022-08-04 16:13:21'),('1','172.68.35.15',1,'2022-08-04 16:13:43'),('1','172.68.35.27',1,'2022-08-05 08:37:41'),('1','172.69.42.124',1,'2022-05-12 18:21:52'),('1','172.70.130.122',1,'2022-08-08 09:55:49'),('1','172.70.130.142',1,'2022-08-08 10:04:40'),('1','172.70.130.146',1,'2022-08-04 06:32:43'),('1','172.70.130.148',1,'2022-06-29 12:48:08'),('1','172.70.130.164',1,'2022-08-04 04:43:17'),('1','172.70.130.168',2,'2022-08-03 17:11:05'),('1','172.70.130.190',1,'2022-08-05 13:01:54'),('1','172.70.130.198',1,'2022-08-08 10:00:30'),('1','172.70.130.224',1,'2022-08-03 12:40:58'),('1','172.70.130.242',1,'2022-08-08 11:35:55'),('1','172.70.130.54',1,'2022-08-08 09:59:47'),('1','172.70.130.64',1,'2022-08-08 10:02:53'),('1','172.70.130.84',1,'2022-08-08 10:05:22'),('1','172.70.131.115',1,'2022-08-08 10:03:12'),('1','172.70.131.141',1,'2022-08-04 06:32:34'),('1','172.70.131.149',1,'2022-08-08 10:00:09'),('1','172.70.131.173',2,'2022-08-08 09:59:52'),('1','172.70.131.189',1,'2022-08-08 11:31:56'),('1','172.70.131.199',2,'2022-08-08 09:58:04'),('1','172.70.131.3',1,'2022-08-04 04:42:31'),('1','172.70.131.33',1,'2022-08-08 09:58:22'),('1','172.70.131.37',1,'2022-08-04 04:42:49'),('1','172.70.131.43',1,'2022-08-08 10:00:15'),('1','172.70.131.7',1,'2022-08-08 11:31:47'),('1','172.70.131.71',1,'2022-08-05 12:39:19'),('1','172.70.131.79',1,'2022-08-08 09:55:29'),('1','172.70.131.81',2,'2022-08-03 10:55:00'),('1','172.70.131.93',2,'2022-08-05 13:01:49'),('1','172.70.131.97',1,'2022-08-03 12:40:17'),('1','172.70.178.166',1,'2022-08-04 09:43:09'),('1','172.70.178.224',1,'2022-08-05 09:00:01'),('1','172.70.178.54',1,'2022-08-04 05:43:26'),('1','172.70.178.68',1,'2022-04-28 07:14:06'),('1','172.70.178.8',1,'2022-08-08 11:55:51'),('1','172.70.218.52',1,'2022-08-08 11:55:57'),('1','172.70.38.50',2,'2022-04-27 12:35:48'),('2',' tucker.gregg',2,'2022-04-28 07:13:32'),('2','admin123',1,'2021-01-27 10:24:30'),('2','admin_rahi',1,'2022-08-04 06:32:47'),('2','akshay.satbhai@rahisystems.com',1,'2022-08-05 12:39:19'),('2','ashish.bubne@rahisystems.com',3,'2022-08-04 09:43:32'),('2','bhavya.seth',1,'2022-08-04 16:13:43'),('2','gregg.tucker',3,'2022-04-27 12:40:09'),('2','kaustubh.borate@rahisystems.com',2,'2022-08-05 13:01:54'),('2','kaustubh_borate',1,'2022-07-29 16:27:54'),('2','kevin.chemparathy@rahisystems.com',1,'2022-08-10 16:06:34'),('2','kevin_chemparathy@rahisystems.com',1,'2022-08-02 18:48:39'),('2','mounika.a@rahisystems.com',1,'2022-05-12 18:21:52'),('2','mounika.alla@rahisystems.com',1,'2022-08-04 21:05:50'),('2','tejas.ambole@rahisystems.com',4,'2022-07-29 14:38:53'),('2','tejasambole@rahisystems.com',1,'2022-07-29 14:38:01'),('2','tucker.gregg',4,'2022-04-28 07:14:16');
/*!40000 ALTER TABLE `captcha_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_entity`
--

DROP TABLE IF EXISTS `catalog_category_entity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_entity` (
  `entity_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `attribute_set_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute Set ID',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Parent Category ID',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Creation Time',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Update Time',
  `path` varchar(255) NOT NULL COMMENT 'Tree Path',
  `position` int(11) NOT NULL COMMENT 'Position',
  `level` int(11) NOT NULL DEFAULT '0' COMMENT 'Tree Level',
  `children_count` int(11) NOT NULL COMMENT 'Child Count',
  PRIMARY KEY (`entity_id`),
  KEY `CATALOG_CATEGORY_ENTITY_LEVEL` (`level`),
  KEY `CATALOG_CATEGORY_ENTITY_PATH` (`path`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COMMENT='Catalog Category Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_entity`
--

LOCK TABLES `catalog_category_entity` WRITE;
/*!40000 ALTER TABLE `catalog_category_entity` DISABLE KEYS */;
INSERT INTO `catalog_category_entity` VALUES (1,3,0,'2020-12-16 03:06:55','2022-04-28 05:08:22','1',0,0,2),(2,3,1,'2020-12-16 03:06:57','2022-08-10 16:44:39','1/2',1,1,1),(10,3,2,'2020-12-16 07:19:41','2022-08-10 16:44:40','1/2/10',8,2,0);
/*!40000 ALTER TABLE `catalog_category_entity` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_entity_datetime`
--

DROP TABLE IF EXISTS `catalog_category_entity_datetime`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_entity_datetime` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` datetime DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_CATEGORY_ENTITY_DATETIME_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_CATEGORY_ENTITY_DATETIME_ENTITY_ID` (`entity_id`),
  KEY `CATALOG_CATEGORY_ENTITY_DATETIME_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_CATEGORY_ENTITY_DATETIME_STORE_ID` (`store_id`),
  CONSTRAINT `CATALOG_CATEGORY_ENTITY_DATETIME_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_CTGR_ENTT_DTIME_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_CTGR_ENTT_DTIME_ENTT_ID_CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=191 DEFAULT CHARSET=utf8 COMMENT='Catalog Category Datetime Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_entity_datetime`
--

LOCK TABLES `catalog_category_entity_datetime` WRITE;
/*!40000 ALTER TABLE `catalog_category_entity_datetime` DISABLE KEYS */;
INSERT INTO `catalog_category_entity_datetime` VALUES (187,61,0,10,NULL),(188,62,0,10,NULL),(189,61,0,2,NULL),(190,62,0,2,NULL);
/*!40000 ALTER TABLE `catalog_category_entity_datetime` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_entity_decimal`
--

DROP TABLE IF EXISTS `catalog_category_entity_decimal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_entity_decimal` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` decimal(20,6) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_CATEGORY_ENTITY_DECIMAL_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_CATEGORY_ENTITY_DECIMAL_ENTITY_ID` (`entity_id`),
  KEY `CATALOG_CATEGORY_ENTITY_DECIMAL_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_CATEGORY_ENTITY_DECIMAL_STORE_ID` (`store_id`),
  CONSTRAINT `CATALOG_CATEGORY_ENTITY_DECIMAL_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_CTGR_ENTT_DEC_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_CTGR_ENTT_DEC_ENTT_ID_CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Decimal Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_entity_decimal`
--

LOCK TABLES `catalog_category_entity_decimal` WRITE;
/*!40000 ALTER TABLE `catalog_category_entity_decimal` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_category_entity_decimal` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_entity_int`
--

DROP TABLE IF EXISTS `catalog_category_entity_int`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_entity_int` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` int(11) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_CATEGORY_ENTITY_INT_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_CATEGORY_ENTITY_INT_ENTITY_ID` (`entity_id`),
  KEY `CATALOG_CATEGORY_ENTITY_INT_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_CATEGORY_ENTITY_INT_STORE_ID` (`store_id`),
  CONSTRAINT `CATALOG_CATEGORY_ENTITY_INT_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_CTGR_ENTT_INT_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_CTGR_ENTT_INT_ENTT_ID_CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1799 DEFAULT CHARSET=utf8 COMMENT='Catalog Category Integer Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_entity_int`
--

LOCK TABLES `catalog_category_entity_int` WRITE;
/*!40000 ALTER TABLE `catalog_category_entity_int` DISABLE KEYS */;
INSERT INTO `catalog_category_entity_int` VALUES (1,69,0,1,1),(2,69,0,2,1),(3,46,0,2,1),(39,46,0,10,1),(40,54,0,10,1),(41,69,0,10,1),(42,70,0,10,0),(43,71,0,10,0),(1786,53,0,10,NULL),(1787,53,0,2,NULL),(1788,54,0,2,1),(1789,70,0,2,0),(1790,71,0,2,0),(1791,46,5,2,1),(1792,69,5,2,1),(1793,70,5,2,0),(1794,71,5,2,0),(1795,46,5,10,1),(1796,69,5,10,1),(1797,70,5,10,0),(1798,71,5,10,0);
/*!40000 ALTER TABLE `catalog_category_entity_int` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_entity_text`
--

DROP TABLE IF EXISTS `catalog_category_entity_text`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_entity_text` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` mediumtext COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_CATEGORY_ENTITY_TEXT_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_CATEGORY_ENTITY_TEXT_ENTITY_ID` (`entity_id`),
  KEY `CATALOG_CATEGORY_ENTITY_TEXT_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_CATEGORY_ENTITY_TEXT_STORE_ID` (`store_id`),
  CONSTRAINT `CATALOG_CATEGORY_ENTITY_TEXT_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_CTGR_ENTT_TEXT_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_CTGR_ENTT_TEXT_ENTT_ID_CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=286 DEFAULT CHARSET=utf8 COMMENT='Catalog Category Text Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_entity_text`
--

LOCK TABLES `catalog_category_entity_text` WRITE;
/*!40000 ALTER TABLE `catalog_category_entity_text` DISABLE KEYS */;
INSERT INTO `catalog_category_entity_text` VALUES (280,47,0,10,NULL),(281,50,0,10,NULL),(282,51,0,10,NULL),(283,47,0,2,NULL),(284,50,0,2,NULL),(285,51,0,2,NULL);
/*!40000 ALTER TABLE `catalog_category_entity_text` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_entity_varchar`
--

DROP TABLE IF EXISTS `catalog_category_entity_varchar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_entity_varchar` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` varchar(255) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_CATEGORY_ENTITY_VARCHAR_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_CATEGORY_ENTITY_VARCHAR_ENTITY_ID` (`entity_id`),
  KEY `CATALOG_CATEGORY_ENTITY_VARCHAR_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_CATEGORY_ENTITY_VARCHAR_STORE_ID` (`store_id`),
  CONSTRAINT `CATALOG_CATEGORY_ENTITY_VARCHAR_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_CTGR_ENTT_VCHR_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_CTGR_ENTT_VCHR_ENTT_ID_CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2251 DEFAULT CHARSET=utf8 COMMENT='Catalog Category Varchar Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_entity_varchar`
--

LOCK TABLES `catalog_category_entity_varchar` WRITE;
/*!40000 ALTER TABLE `catalog_category_entity_varchar` DISABLE KEYS */;
INSERT INTO `catalog_category_entity_varchar` VALUES (1,45,0,1,'Root Catalog'),(2,52,0,2,'PRODUCTS'),(3,45,0,2,'Default Category'),(32,45,0,10,'All Products'),(33,52,0,10,'PRODUCTS'),(34,119,0,10,'laptops-accessories'),(35,120,0,10,'laptops-accessories'),(2113,48,0,10,NULL),(2114,49,0,10,NULL),(2115,60,0,10,NULL),(2116,63,0,10,NULL),(2117,48,0,2,NULL),(2118,49,0,2,NULL),(2119,60,0,2,NULL),(2120,63,0,2,NULL),(2121,119,0,2,'default-category'),(2122,120,0,2,NULL),(2130,68,0,10,'name'),(2131,45,5,2,'Default Category'),(2132,52,5,2,'PRODUCTS'),(2133,119,5,2,'default-category'),(2134,120,5,2,NULL),(2136,45,5,10,'All Products'),(2137,52,5,10,'PRODUCTS'),(2138,68,5,10,'name'),(2139,119,5,10,'laptops-accessories'),(2250,120,5,10,'laptops-accessories');
/*!40000 ALTER TABLE `catalog_category_entity_varchar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product`
--

DROP TABLE IF EXISTS `catalog_category_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_product` (
  `entity_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `category_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Category ID',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `position` int(11) NOT NULL DEFAULT '0' COMMENT 'Position',
  PRIMARY KEY (`entity_id`,`category_id`,`product_id`),
  UNIQUE KEY `CATALOG_CATEGORY_PRODUCT_CATEGORY_ID_PRODUCT_ID` (`category_id`,`product_id`),
  KEY `CATALOG_CATEGORY_PRODUCT_PRODUCT_ID` (`product_id`),
  CONSTRAINT `CAT_CTGR_PRD_CTGR_ID_CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`category_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_CTGR_PRD_PRD_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=57907 DEFAULT CHARSET=utf8 COMMENT='Catalog Product To Category Linkage Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product`
--

LOCK TABLES `catalog_category_product` WRITE;
/*!40000 ALTER TABLE `catalog_category_product` DISABLE KEYS */;
INSERT INTO `catalog_category_product` VALUES (980,2,18310,0),(981,2,18311,0),(982,2,18312,0),(983,2,18313,0),(984,2,18314,0),(985,2,18315,0),(986,2,18316,0),(987,2,18317,0),(988,2,18318,0),(989,2,18319,0),(990,2,18320,0),(991,2,18321,0),(992,2,18322,0),(993,2,18323,0),(994,2,18324,0),(995,2,18325,0),(996,2,18326,0),(997,2,18327,0),(998,2,18328,0),(999,2,18329,0),(1000,2,18330,0),(1001,2,18331,0),(1002,2,18332,0),(1003,2,18333,0),(1004,2,18334,0),(1005,2,18335,0),(1006,2,18336,0),(1007,2,18337,0),(1008,2,18338,0),(1009,2,18339,0),(1010,2,18340,0),(1011,2,18341,0),(1012,2,18342,0),(1013,2,18343,0),(1014,2,18344,0),(1015,2,18345,0),(1016,2,18346,0),(1017,2,18347,0),(1018,2,18348,0),(1019,2,18349,0),(1020,2,18350,0),(1021,2,18351,0),(1022,2,18352,0),(1023,2,18353,0),(1024,2,18354,0),(1025,2,18355,0),(1026,2,18356,0),(1027,2,18357,0),(1028,2,18358,0),(1029,2,18359,0),(1030,2,18360,0),(1031,2,18361,0),(1032,2,18362,0),(1033,2,18363,0),(1034,2,18364,0),(1035,2,18365,0),(1036,2,18366,0),(1037,2,18367,0),(1038,2,18368,0),(1039,2,18369,0),(1040,2,18370,0),(1041,2,18371,0),(1042,2,18372,0),(1043,2,18373,0),(1044,2,18374,0),(1045,2,18375,0),(1046,2,18376,0),(1047,2,18377,0),(1048,2,18378,0),(1049,2,18379,0),(1050,2,18380,0),(1051,2,18381,0),(1052,2,18382,0),(1053,2,18383,0),(1054,2,18384,0),(1055,2,18385,0),(1056,2,18386,0),(1057,2,18387,0),(1058,2,18388,0),(1059,2,18389,0),(1060,2,18390,0),(1061,2,18391,0),(1062,2,18392,0),(1063,2,18393,0),(1064,2,18394,0),(1065,2,18395,0),(1066,2,18396,0),(1067,2,18397,0),(1068,2,18398,0),(1069,2,18399,0),(1070,2,18400,0),(1071,2,18401,0),(1072,2,18402,0),(1073,2,18403,0),(1074,2,18404,0),(1075,2,18405,0),(1076,2,18406,0),(1077,2,18407,0),(1078,2,18408,0),(1079,2,18409,0),(1080,2,18410,0),(1081,2,18411,0),(1082,2,18412,0),(1083,2,18413,0),(1084,2,18414,0),(1085,2,18415,0),(1086,2,18416,0),(1087,2,18417,0),(1088,2,18418,0),(1089,2,18419,0),(1090,2,18420,0),(1091,2,18421,0),(1092,2,18422,0),(1093,2,18423,0),(1094,2,18424,0),(1095,2,18425,0),(1096,2,18426,0),(1097,2,18427,0),(1098,2,18428,0),(1099,2,18429,0),(1100,2,18430,0),(1101,2,18431,0),(1102,2,18432,0),(1103,2,18433,0),(1104,2,18434,0),(1105,2,18435,0),(1106,2,18436,0),(1107,2,18437,0),(1108,2,18438,0),(1109,2,18439,0),(1110,2,18440,0),(1111,2,18441,0),(1112,2,18442,0),(1113,2,18443,0),(1114,2,18444,0),(1115,2,18445,0),(1116,2,18446,0),(1117,2,18447,0),(1118,2,18448,0),(1119,2,18449,0),(1120,2,18450,0),(1121,2,18451,0),(1122,2,18452,0),(1123,2,18453,0),(1124,2,18454,0),(1125,2,18455,0),(1126,2,18456,0),(1127,2,18457,0),(1128,2,18458,0),(1129,2,18459,0),(1130,2,18460,0),(1131,2,18461,0),(1132,2,18462,0),(1133,2,18463,0),(1134,2,18464,0),(1135,2,18465,0),(1136,2,18466,0),(1137,2,18467,0),(1138,2,18468,0),(1139,2,18469,0),(1140,2,18470,0),(1141,2,18471,0),(1142,2,18472,0),(1143,2,18473,0),(1144,2,18474,0),(1145,2,18475,0),(1146,2,18476,0),(1147,2,18477,0),(1148,2,18478,0),(1149,2,18479,0),(1150,2,18480,0),(1151,2,18481,0),(1152,2,18482,0),(1153,2,18483,0),(1154,2,18484,0),(1155,2,18485,0),(1156,2,18486,0),(1157,2,18487,0),(1158,2,18488,0),(1159,2,18489,0),(1160,2,18490,0),(1161,2,18491,0),(1162,2,18492,0),(1163,2,18493,0),(1164,2,18494,0),(1165,2,18495,0),(1166,2,18496,0),(1167,2,18497,0),(1168,2,18498,0),(1169,2,18499,0),(1170,2,18500,0),(1171,2,18501,0),(1172,2,18502,0),(1173,2,18503,0),(1174,2,18504,0),(1175,2,18505,0),(1176,2,18506,0),(1177,2,18507,0),(1178,2,18508,0),(1179,2,18509,0),(1180,2,18510,0),(1181,2,18511,0),(1182,2,18512,0),(1183,2,18513,0),(1184,2,18514,0),(1185,2,18515,0),(1186,2,18516,0),(1187,2,18517,0),(1188,2,18518,0),(1189,2,18519,0),(1190,2,18520,0),(1191,2,18521,0),(1192,2,18522,0),(1193,2,18523,0),(1194,2,18524,0),(1195,2,18525,0),(1196,2,18526,0),(1197,2,18527,0),(1198,2,18528,0),(1199,2,18529,0),(1200,2,18530,0),(1201,2,18531,0),(1202,2,18532,0),(1203,2,18533,0),(1204,2,18534,0),(1205,2,18535,0),(1206,2,18536,0),(1207,2,18537,0),(1208,2,18538,0),(1209,2,18539,0),(1210,2,18540,0),(1211,2,18541,0),(1212,2,18542,0),(1213,2,18543,0),(1214,2,18544,0),(1215,2,18545,0),(1216,2,18546,0),(1217,2,18547,0),(1218,2,18548,0),(1219,2,18549,0),(1220,2,18550,0),(1221,2,18551,0),(1222,2,18552,0),(1223,2,18553,0),(1224,2,18554,0),(1225,2,18555,0),(1226,2,18556,0),(1227,2,18557,0),(1228,2,18558,0),(1229,2,18559,0),(1230,2,18560,0),(1231,2,18561,0),(1232,2,18562,0),(1233,2,18563,0),(1234,2,18564,0),(1235,2,18565,0),(1236,2,18566,0),(1237,2,18567,0),(1238,2,18568,0),(1239,2,18569,0),(1240,2,18570,0),(1241,2,18571,0),(1242,2,18572,0),(1243,2,18573,0),(1244,2,18574,0),(1245,2,18575,0),(1246,2,18576,0),(1247,2,18577,0),(1248,2,18578,0),(1249,2,18579,0),(1250,2,18580,0),(1251,2,18581,0),(1252,2,18582,0),(1253,2,18583,0),(1254,2,18584,0),(1255,2,18585,0),(1256,2,18586,0),(1257,2,18587,0),(1258,2,18588,0),(1259,2,18589,0),(1260,2,18590,0),(1261,2,18591,0),(1262,2,18592,0),(1263,2,18593,0),(1264,2,18594,0),(1265,2,18595,0),(1266,2,18596,0),(1267,2,18597,0),(1268,2,18598,0),(1269,2,18599,0),(1270,2,18600,0),(1271,2,18601,0),(1272,2,18602,0),(1273,2,18603,0),(1274,2,18604,0),(1275,2,18605,0),(1276,2,18606,0),(1277,2,18607,0),(1278,2,18608,0),(1279,2,18609,0),(1280,2,18610,0),(1281,2,18611,0),(1282,2,18612,0),(1283,2,18613,0),(1284,2,18614,0),(1285,2,18615,0),(1286,2,18616,0),(1287,2,18617,0),(1288,2,18618,0),(1289,2,18619,0),(1290,2,18620,0),(1291,2,18621,0),(1292,2,18622,0),(1293,2,18623,0),(1294,2,18624,0),(1295,2,18625,0),(1296,2,18626,0),(1297,2,18627,0),(1298,2,18628,0),(1299,2,18629,0),(1300,2,18630,0),(1301,2,18631,0),(1302,2,18632,0),(1303,2,18633,0),(1304,2,18634,0),(1305,2,18635,0),(1306,2,18636,0),(1307,2,18637,0),(1308,2,18638,0),(1309,2,18639,0),(1310,2,18640,0),(1311,2,18641,0),(1312,2,18642,0),(1313,2,18643,0),(1314,2,18644,0),(1315,2,18645,0),(1316,2,18646,0),(1317,2,18647,0),(1318,2,18648,0),(1319,2,18649,0),(1320,2,18650,0),(1321,2,18651,0),(1322,2,18652,0),(1323,2,18653,0),(1324,2,18654,0),(1325,2,18655,0),(1326,2,18656,0),(1327,2,18657,0),(1328,2,18658,0),(1329,2,18659,0),(1330,2,18660,0),(1331,2,18661,0),(1332,2,18662,0),(1333,2,18663,0),(1334,2,18664,0),(1335,2,18665,0),(1336,2,18666,0),(1337,2,18667,0),(1338,2,18668,0),(1339,2,18669,0),(1340,2,18670,0),(1341,2,18671,0),(1342,2,18672,0),(1343,2,18673,0),(1344,2,18674,0),(1345,2,18675,0),(1346,2,18676,0),(1347,2,18677,0),(1348,2,18678,0),(1349,2,18679,0),(1350,2,18680,0),(1351,2,18681,0),(1352,2,18682,0),(1353,2,18683,0),(1354,2,18684,0),(1355,2,18685,0),(1356,2,18686,0),(1357,2,18687,0),(1358,2,18688,0),(1359,2,18689,0),(1360,2,18690,0),(1361,2,18691,0),(1362,2,18692,0),(1363,2,18693,0),(1364,2,18694,0),(1365,2,18695,0),(1366,2,18696,0),(1367,2,18697,0),(1368,2,18698,0),(1369,2,18699,0),(1370,2,18700,0),(1371,2,18701,0),(1372,2,18702,0),(1373,2,18703,0),(1374,2,18704,0),(1375,2,18705,0),(1376,2,18706,0),(1377,2,18707,0),(1378,2,18708,0),(1379,2,18709,0),(1380,2,18710,0),(1381,2,18711,0),(1382,2,18712,0),(1383,2,18713,0),(1384,2,18714,0),(1385,2,18715,0),(1386,2,18716,0),(1387,2,18717,0),(1388,2,18718,0),(1389,2,18719,0),(1390,2,18720,0),(1391,2,18721,0),(1392,2,18722,0),(1393,2,18723,0),(1394,2,18724,0),(1395,2,18725,0),(1396,2,18726,0),(1397,2,18727,0),(1398,2,18728,0),(1399,2,18729,0),(1400,2,18730,0),(1401,2,18731,0),(1402,2,18732,0),(1403,2,18733,0),(1404,2,18734,0),(1405,2,18735,0),(1406,2,18736,0),(1407,2,18737,0),(1408,2,18738,0),(1409,2,18739,0),(1410,2,18740,0),(1411,2,18741,0),(1412,2,18742,0),(1413,2,18743,0),(1414,2,18744,0),(1415,2,18745,0),(1416,2,18746,0),(1417,2,18747,0),(1418,2,18748,0),(1419,2,18749,0),(1420,2,18750,0),(1421,2,18751,0),(1422,2,18752,0),(1423,2,18753,0),(1424,2,18754,0),(1425,2,18755,0),(1426,2,18756,0),(1427,2,18757,0),(1428,2,18758,0),(1429,2,18759,0),(1430,2,18760,0),(1431,2,18761,0),(1432,2,18762,0),(1433,2,18763,0),(1434,2,18764,0),(1435,2,18765,0),(1436,2,18766,0),(1437,2,18767,0),(1438,2,18768,0),(1439,2,18769,0),(1440,2,18770,0),(1441,2,18771,0),(1442,2,18772,0),(1443,2,18773,0),(1444,2,18774,0),(1445,2,18775,0),(1446,2,18776,0),(1447,2,18777,0),(1448,2,18778,0),(1449,2,18779,0),(1450,2,18780,0),(1451,2,18781,0),(1452,2,18782,0),(1453,2,18783,0),(1454,2,18784,0),(1455,2,18785,0),(1456,2,18786,0),(1457,2,18787,0),(1458,2,18788,0),(1459,2,18789,0),(1460,2,18790,0),(1461,2,18791,0),(1462,2,18792,0),(1463,2,18793,0),(1464,2,18794,0),(1465,2,18795,0),(1466,2,18796,0),(1467,2,18797,0),(1468,2,18798,0),(1469,2,18799,0),(1470,2,18800,0),(1471,2,18801,0),(1472,2,18802,0),(1473,2,18803,0),(1474,2,18804,0),(1475,2,18805,0),(1476,2,18806,0),(1477,2,18807,0),(1478,2,18808,0),(1479,2,18809,0),(1480,2,18810,0),(1481,2,18811,0),(1482,2,18812,0),(1483,2,18813,0),(1484,2,18814,0),(1485,2,18815,0),(1486,2,18816,0),(1487,2,18817,0),(1488,2,18818,0),(1489,2,18819,0),(1490,2,18820,0),(1491,2,18821,0),(1492,2,18822,0),(1493,2,18823,0),(1494,2,18824,0),(1495,2,18825,0),(1496,2,18826,0),(1497,2,18827,0),(1498,2,18828,0),(1499,2,18829,0),(1500,2,18830,0),(1501,2,18831,0),(1502,2,18832,0),(1503,2,18833,0),(1504,2,18834,0),(1505,2,18835,0),(1506,2,18836,0),(1507,2,18837,0),(1508,2,18838,0),(1509,2,18839,0),(1510,2,18840,0),(1511,2,18841,0),(1512,2,18842,0),(1513,2,18843,0),(1514,2,18844,0),(1515,2,18845,0),(1516,2,18846,0),(1517,2,18847,0),(1518,2,18848,0),(1519,2,18849,0),(1520,2,18850,0),(1521,2,18851,0),(1522,2,18852,0),(1523,2,18853,0),(1524,2,18854,0),(1525,2,18855,0),(1526,2,18856,0),(1527,2,18857,0),(1528,2,18858,0),(1529,2,18859,0),(1530,2,18860,0),(1531,2,18861,0),(1532,2,18862,0),(1533,2,18863,0),(1534,2,18864,0),(1535,2,18865,0),(1536,2,18866,0),(1537,2,18867,0),(1538,2,18868,0),(1539,2,18869,0),(1540,2,18870,0),(1541,2,18871,0),(1542,2,18872,0),(1543,2,18873,0),(1544,2,18874,0),(1545,2,18875,0),(1546,2,18876,0),(1547,2,18877,0),(1548,2,18878,0),(1549,2,18879,0),(1550,2,18880,0),(1551,2,18881,0),(1552,2,18882,0),(1553,2,18883,0),(1554,2,18884,0),(1555,2,18885,0),(1556,2,18886,0),(1557,2,18887,0),(1558,2,18888,0),(1559,2,18889,0),(1560,2,18890,0),(1561,2,18891,0),(1562,2,18892,0),(1563,2,18893,0),(1564,2,18894,0),(1565,2,18895,0),(1566,2,18896,0),(1567,2,18897,0),(1568,2,18898,0),(1569,2,18899,0),(1570,2,18900,0),(1571,2,18901,0),(1572,2,18902,0),(1573,2,18903,0),(1574,2,18904,0),(1575,2,18905,0),(1576,2,18906,0),(1577,2,18907,0),(1578,2,18908,0),(1579,2,18909,0),(1580,2,18910,0),(1581,2,18911,0),(1582,2,18912,0),(1583,2,18913,0),(1584,2,18914,0),(1585,2,18915,0),(1586,2,18916,0),(1587,2,18917,0),(1588,2,18918,0),(1589,2,18919,0),(1590,2,18920,0),(1591,2,18921,0),(1592,2,18922,0),(1593,2,18923,0),(1594,2,18924,0),(1595,2,18925,0),(1596,2,18926,0),(1597,2,18927,0),(1598,2,18928,0),(1599,2,18929,0),(1600,2,18930,0),(1601,2,18931,0),(1602,2,18932,0),(1603,2,18933,0),(1604,2,18934,0),(1605,2,18935,0),(1606,2,18936,0),(1607,2,18937,0),(1608,2,18938,0),(1609,2,18939,0),(1610,2,18940,0),(1611,2,18941,0),(1612,2,18942,0),(1613,2,18943,0),(1614,2,18944,0),(1615,2,18945,0),(1616,2,18946,0),(1617,2,18947,0),(1618,2,18948,0),(1619,2,18949,0),(1620,2,18950,0),(1621,2,18951,0),(1622,2,18952,0),(1623,2,18953,0),(1624,2,18954,0),(1625,2,18955,0),(1626,2,18956,0),(1627,2,18957,0),(1628,2,18958,0),(1629,2,18959,0),(1630,2,18960,0),(1631,2,18961,0),(1632,2,18962,0),(1633,2,18963,0),(1634,2,18964,0),(1635,2,18965,0),(1636,2,18966,0),(1637,2,18967,0),(1638,2,18968,0),(1639,2,18969,0),(1640,2,18970,0),(1641,2,18971,0),(1642,2,18972,0),(1643,2,18973,0),(1644,2,18974,0),(1645,2,18975,0),(1646,2,18976,0),(1647,2,18977,0),(1648,2,18978,0),(1649,2,18979,0),(1650,2,18980,0),(1651,2,18981,0),(1652,2,18982,0),(1653,2,18983,0),(1654,2,18984,0),(1655,2,18985,0),(1656,2,18986,0),(1657,2,18987,0),(1658,2,18988,0),(1659,2,18989,0),(1660,2,18990,0),(1661,2,18991,0),(1662,2,18992,0),(1663,2,18993,0),(1664,2,18994,0),(1665,2,18995,0),(1666,2,18996,0),(1667,2,18997,0),(1668,2,18998,0),(1669,2,18999,0),(1670,2,19000,0),(1671,2,19001,0),(1672,2,19002,0),(1673,2,19003,0),(1674,2,19004,0),(1675,2,19005,0),(1676,2,19006,0),(1677,2,19007,0),(1678,2,19008,0),(1679,2,19009,0),(1680,2,19010,0),(1681,2,19011,0),(1682,2,19012,0),(1683,2,19013,0),(1684,2,19014,0),(1685,2,19015,0),(1686,2,19016,0),(1687,2,19017,0),(1688,2,19018,0),(1689,2,19019,0),(1690,2,19020,0),(1691,2,19021,0),(1692,2,19022,0),(1693,2,19023,0),(1694,2,19024,0),(1695,2,19025,0),(1696,2,19026,0),(1697,2,19027,0),(1698,2,19028,0),(1699,2,19029,0),(1700,2,19030,0),(1701,2,19031,0),(1702,2,19032,0),(1703,2,19033,0),(1704,2,19034,0),(1705,2,19035,0),(1706,2,19036,0),(1707,2,19037,0),(1708,2,19038,0),(1709,2,19039,0),(1710,2,19040,0),(1711,2,19041,0),(1712,2,19042,0),(1713,2,19043,0),(1714,2,19044,0),(1715,2,19045,0),(1716,2,19046,0),(1717,2,19047,0),(1718,2,19048,0),(1719,2,19049,0),(1720,2,19050,0),(1721,2,19051,0),(1722,2,19052,0),(1723,2,19053,0),(1724,2,19054,0),(1725,2,19055,0),(1726,2,19056,0),(1727,2,19057,0),(1728,2,19058,0),(1729,2,19059,0),(1730,2,19060,0),(1731,2,19061,0),(1732,2,19062,0),(1733,2,19063,0),(1734,2,19064,0),(1735,2,19065,0),(1736,2,19066,0),(1737,2,19067,0),(1738,2,19068,0),(1739,2,19069,0),(1740,2,19070,0),(1741,2,19071,0),(1742,2,19072,0),(1743,2,19073,0),(1744,2,19074,0),(1745,2,19075,0),(1746,2,19076,0),(1747,2,19077,0),(1748,2,19078,0),(1749,2,19079,0),(1750,2,19080,0),(1751,2,19081,0),(1752,2,19082,0),(1753,2,19083,0),(1754,2,19084,0),(1755,2,19085,0),(1756,2,19086,0),(1757,2,19087,0),(1758,2,19088,0),(1759,2,19089,0),(1760,2,19090,0),(1761,2,19091,0),(1762,2,19092,0),(1763,2,19093,0),(1764,2,19094,0),(1765,2,19095,0),(1766,2,19096,0),(1767,2,19097,0),(1768,2,19098,0),(1769,2,19099,0),(1770,2,19100,0),(1771,2,19101,0),(1772,2,19102,0),(1773,2,19103,0),(1774,2,19104,0),(1775,2,19105,0),(1776,2,19106,0),(1777,2,19107,0),(1778,2,19108,0),(1779,2,19109,0),(1780,2,19110,0),(1781,2,19111,0),(1782,2,19112,0),(1783,2,19113,0),(1784,2,19114,0),(1785,2,19115,0),(1786,2,19116,0),(1787,2,19117,0),(1788,2,19118,0),(1789,2,19119,0),(1790,2,19120,0),(1791,2,19121,0),(1792,2,19122,0),(1793,2,19123,0),(1794,2,19124,0),(1795,2,19125,0),(1796,2,19126,0),(1797,2,19127,0),(1798,2,19128,0),(1799,2,19129,0),(1800,2,19130,0),(1801,2,19131,0),(1802,2,19132,0),(1803,2,19133,0),(1804,2,19134,0),(1805,2,19135,0),(1806,2,19136,0),(1807,2,19137,0),(1808,2,19138,0),(1809,2,19139,0),(1810,2,19140,0),(1811,2,19141,0),(1812,2,19142,0),(1813,2,19143,0),(1814,2,19144,0),(1815,2,19145,0),(1816,2,19146,0),(1817,2,19147,0),(1818,2,19148,0),(1819,2,19149,0),(1820,2,19150,0),(1821,2,19151,0),(1822,2,19152,0),(1823,2,19153,0),(1824,2,19154,0),(1825,2,19155,0),(1826,2,19156,0),(1827,2,19157,0),(1828,2,19158,0),(1829,2,19159,0),(1830,2,19160,0),(1831,2,19161,0),(1832,2,19162,0),(1833,2,19163,0),(1834,2,19164,0),(1835,2,19165,0),(1836,2,19166,0),(1837,2,19167,0),(1838,2,19168,0),(1839,2,19169,0),(1840,2,19170,0),(1841,2,19171,0),(1842,2,19172,0),(1843,2,19173,0),(1844,2,19174,0),(1845,2,19175,0),(1846,2,19176,0),(1847,2,19177,0),(1848,2,19178,0),(1849,2,19179,0),(1850,2,19180,0),(1851,2,19181,0),(1852,2,19182,0),(1853,2,19183,0),(1854,2,19184,0),(1855,2,19185,0),(1856,2,19186,0),(1857,2,19187,0),(1858,2,19188,0),(1859,2,19189,0),(1860,2,19190,0),(1861,2,19191,0),(1862,2,19192,0),(1863,2,19193,0),(1864,2,19194,0),(1865,2,19195,0),(1866,2,19196,0),(1867,2,19197,0),(1868,2,19198,0),(1869,2,19199,0),(1870,2,19200,0),(1871,2,19201,0),(1872,2,19202,0),(1873,2,19203,0),(1874,2,19204,0),(1875,2,19205,0),(1876,2,19206,0),(1877,2,19207,0),(1878,2,19208,0),(1879,2,19209,0),(1880,2,19210,0),(1881,2,19211,0),(1882,2,19212,0),(1883,2,19213,0),(1884,2,19214,0),(1885,2,19215,0),(1886,2,19216,0),(1887,2,19217,0),(1888,2,19218,0),(1889,2,19219,0),(1890,2,19220,0),(1891,2,19221,0),(1892,2,19222,0),(1893,2,19223,0),(1894,2,19224,0),(1895,2,19225,0),(1896,2,19226,0),(1897,2,19227,0),(1898,2,19228,0),(1899,2,19229,0),(1900,2,19230,0),(1901,2,19231,0),(1902,2,19232,0),(1903,2,19233,0),(1904,2,19234,0),(1905,2,19235,0),(1906,2,19236,0),(1907,2,19237,0),(1908,2,19238,0),(1909,2,19239,0),(1910,2,19240,0),(1911,2,19241,0),(1912,2,19242,0),(1913,2,19243,0),(1914,2,19244,0),(1915,2,19245,0),(1916,2,19246,0),(1917,2,19247,0),(1918,2,19248,0),(1919,2,19249,0),(1920,2,19250,0),(1921,2,19251,0),(1922,2,19252,0),(1923,2,19253,0),(1924,2,19254,0),(1925,2,19255,0),(1926,2,19256,0),(1927,2,19257,0),(1928,2,19258,0),(1929,2,19259,0),(1930,2,19260,0),(1931,2,19261,0),(1932,2,19262,0),(1933,2,19263,0),(1934,2,19264,0),(1935,2,19265,0),(1936,2,19266,0),(1937,2,19267,0),(1938,2,19268,0),(1939,2,19269,0),(1940,2,19270,0),(1941,2,19271,0),(1942,2,19272,0),(1943,2,19273,0),(1944,2,19274,0),(1945,2,19275,0),(1946,2,19276,0),(1947,2,19277,0),(1948,2,19278,0),(1949,2,19279,0),(1950,2,19280,0),(1951,2,19281,0),(1952,2,19282,0),(1953,2,19283,0),(1954,2,19284,0),(1955,2,19285,0),(1956,2,19286,0),(1957,2,19287,0),(1958,2,19288,0),(1959,2,19289,0),(1960,2,19290,0),(1961,2,19291,0),(1962,2,19292,0),(1963,2,19293,0),(1964,2,19294,0),(1965,2,19295,0),(1966,2,19296,0),(1967,2,19297,0),(1968,2,19298,0),(1969,2,19299,0),(1970,2,19300,0),(1971,2,19301,0),(1972,2,19302,0),(1973,2,19303,0),(1974,2,19304,0),(1975,2,19305,0),(1976,2,19306,0),(1977,2,19307,0),(1978,2,19308,0),(1979,2,19309,0),(1980,2,19310,0),(1981,2,19311,0),(1982,2,19312,0),(1983,2,19313,0),(1984,2,19314,0),(1985,2,19315,0),(1986,2,19316,0),(1987,2,19317,0),(1988,2,19318,0),(1989,2,19319,0),(1990,2,19320,0),(1991,2,19321,0),(1992,2,19322,0),(1993,2,19323,0),(1994,2,19324,0),(1995,2,19325,0),(1996,2,19326,0),(1997,2,19327,0),(1998,2,19328,0),(1999,2,19329,0),(2000,2,19330,0),(2001,2,19331,0),(2002,2,19332,0),(2003,2,19333,0),(2004,2,19334,0),(2005,2,19335,0),(2006,2,19336,0),(2007,2,19337,0),(2008,2,19338,0),(2009,2,19339,0),(2010,2,19340,0),(2011,2,19341,0),(2012,2,19342,0),(2013,2,19343,0),(2014,2,19344,0),(2015,2,19345,0),(2016,2,19346,0),(2017,2,19347,0),(2018,2,19348,0),(2019,2,19349,0),(2020,2,19350,0),(2021,2,19351,0),(2022,2,19352,0),(2023,2,19353,0),(2024,2,19354,0),(2025,2,19355,0),(2026,2,19356,0),(2027,2,19357,0),(2028,2,19358,0),(2029,2,19359,0),(2030,2,19360,0),(2031,2,19361,0),(2032,2,19362,0),(2033,2,19363,0),(2034,2,19364,0),(2035,2,19365,0),(2036,2,19366,0),(2037,2,19367,0),(2038,2,19368,0),(2039,2,19369,0),(2040,2,19370,0),(2041,2,19371,0),(2042,2,19372,0),(2043,2,19373,0),(2044,2,19374,0),(2045,2,19375,0),(2046,2,19376,0),(2047,2,19377,0),(2048,2,19378,0),(2049,2,19379,0),(2050,2,19380,0),(2051,2,19381,0),(2052,2,19382,0),(2053,2,19383,0),(2054,2,19384,0),(2055,2,19385,0),(2056,2,19386,0),(2057,2,19387,0),(2058,2,19388,0),(2059,2,19389,0),(2060,2,19390,0),(2061,2,19391,0),(2062,2,19392,0),(2063,2,19393,0),(2064,2,19394,0),(2065,2,19395,0),(2066,2,19396,0),(2067,2,19397,0),(2068,2,19398,0),(2069,2,19399,0),(2070,2,19400,0),(2071,2,19401,0),(2072,2,19402,0),(2073,2,19403,0),(2074,2,19404,0),(2075,2,19405,0),(2076,2,19406,0),(2077,2,19407,0),(2078,2,19408,0),(2079,2,19409,0),(2080,2,19410,0),(2081,2,19411,0),(2082,2,19412,0),(2083,2,19413,0),(2084,2,19414,0),(2085,2,19415,0),(2086,2,19416,0),(2087,2,19417,0),(2088,2,19418,0),(2089,2,19419,0),(2090,2,19420,0),(2091,2,19421,0),(2092,2,19422,0),(2093,2,19423,0),(2094,2,19424,0),(2095,2,19425,0),(2096,2,19426,0),(2097,2,19427,0),(2098,2,19428,0),(2099,2,19429,0),(2100,2,19430,0),(2101,2,19431,0),(2102,2,19432,0),(2103,2,19433,0),(2104,2,19434,0),(2105,2,19435,0),(2106,2,19436,0),(2107,2,19437,0),(2108,2,19438,0),(2109,2,19439,0),(2110,2,19440,0),(2111,2,19441,0),(2112,2,19442,0),(2113,2,19443,0),(2114,2,19444,0),(2115,2,19445,0),(2116,2,19446,0),(2117,2,19447,0),(2118,2,19448,0),(2119,2,19449,0),(2120,2,19450,0),(2121,2,19451,0),(2122,2,19452,0),(2123,2,19453,0),(2124,2,19454,0),(2125,2,19455,0),(2126,2,19456,0),(2127,2,19457,0),(2128,2,19458,0),(2129,2,19459,0),(2130,2,19460,0),(2131,2,19461,0),(2132,2,19462,0),(2133,2,19463,0),(2134,2,19464,0),(2135,2,19465,0),(2136,2,19466,0),(2137,2,19467,0),(2138,2,19468,0),(2139,2,19469,0),(2140,2,19470,0),(2141,2,19471,0),(2142,2,19472,0),(2143,2,19473,0),(2144,2,19474,0),(2145,2,19475,0),(2146,2,19476,0),(2147,2,19477,0),(2148,2,19478,0),(2149,2,19479,0),(2150,2,19480,0),(2151,2,19481,0),(2152,2,19482,0),(2153,2,19483,0),(2154,2,19484,0),(2155,2,19485,0),(2156,2,19486,0),(2157,2,19487,0),(2158,2,19488,0),(2159,2,19489,0),(2160,2,19490,0),(2161,2,19491,0),(2162,2,19492,0),(2163,2,19493,0),(2164,2,19494,0),(2165,2,19495,0),(2166,2,19496,0),(2167,2,19497,0),(2168,2,19498,0),(2169,2,19499,0),(2170,2,19500,0),(2171,2,19501,0),(2172,2,19502,0),(2173,2,19503,0),(2174,2,19504,0),(2175,2,19505,0),(2176,2,19506,0),(2177,2,19507,0),(2178,2,19508,0),(2179,2,19509,0),(2180,10,18310,0),(2181,10,18311,0),(2182,10,18312,0),(2183,10,18313,0),(2184,10,18314,0),(2185,10,18315,0),(2186,10,18316,0),(2187,10,18317,0),(2188,10,18318,0),(2189,10,18319,0),(2190,10,18320,0),(2191,10,18321,0),(2192,10,18322,0),(2193,10,18323,0),(2194,10,18324,0),(2195,10,18325,0),(2196,10,18326,0),(2197,10,18327,0),(2198,10,18328,0),(2199,10,18329,0),(2200,10,18330,0),(2201,10,18331,0),(2202,10,18332,0),(2203,10,18333,0),(2204,10,18334,0),(2205,10,18335,0),(2206,10,18336,0),(2207,10,18337,0),(2208,10,18338,0),(2209,10,18339,0),(2210,10,18340,0),(2211,10,18341,0),(2212,10,18342,0),(2213,10,18343,0),(2214,10,18344,0),(2215,10,18345,0),(2216,10,18346,0),(2217,10,18347,0),(2218,10,18348,0),(2219,10,18349,0),(2220,10,18350,0),(2221,10,18351,0),(2222,10,18352,0),(2223,10,18353,0),(2224,10,18354,0),(2225,10,18355,0),(2226,10,18356,0),(2227,10,18357,0),(2228,10,18358,0),(2229,10,18359,0),(2230,10,18360,0),(2231,10,18361,0),(2232,10,18362,0),(2233,10,18363,0),(2234,10,18364,0),(2235,10,18365,0),(2236,10,18366,0),(2237,10,18367,0),(2238,10,18368,0),(2239,10,18369,0),(2240,10,18370,0),(2241,10,18371,0),(2242,10,18372,0),(2243,10,18373,0),(2244,10,18374,0),(2245,10,18375,0),(2246,10,18376,0),(2247,10,18377,0),(2248,10,18378,0),(2249,10,18379,0),(2250,10,18380,0),(2251,10,18381,0),(2252,10,18382,0),(2253,10,18383,0),(2254,10,18384,0),(2255,10,18385,0),(2256,10,18386,0),(2257,10,18387,0),(2258,10,18388,0),(2259,10,18389,0),(2260,10,18390,0),(2261,10,18391,0),(2262,10,18392,0),(2263,10,18393,0),(2264,10,18394,0),(2265,10,18395,0),(2266,10,18396,0),(2267,10,18397,0),(2268,10,18398,0),(2269,10,18399,0),(2270,10,18400,0),(2271,10,18401,0),(2272,10,18402,0),(2273,10,18403,0),(2274,10,18404,0),(2275,10,18405,0),(2276,10,18406,0),(2277,10,18407,0),(2278,10,18408,0),(2279,10,18409,0),(2280,10,18410,0),(2281,10,18411,0),(2282,10,18412,0),(2283,10,18413,0),(2284,10,18414,0),(2285,10,18415,0),(2286,10,18416,0),(2287,10,18417,0),(2288,10,18418,0),(2289,10,18419,0),(2290,10,18420,0),(2291,10,18421,0),(2292,10,18422,0),(2293,10,18423,0),(2294,10,18424,0),(2295,10,18425,0),(2296,10,18426,0),(2297,10,18427,0),(2298,10,18428,0),(2299,10,18429,0),(2300,10,18430,0),(2301,10,18431,0),(2302,10,18432,0),(2303,10,18433,0),(2304,10,18434,0),(2305,10,18435,0),(2306,10,18436,0),(2307,10,18437,0),(2308,10,18438,0),(2309,10,18439,0),(2310,10,18440,0),(2311,10,18441,0),(2312,10,18442,0),(2313,10,18443,0),(2314,10,18444,0),(2315,10,18445,0),(2316,10,18446,0),(2317,10,18447,0),(2318,10,18448,0),(2319,10,18449,0),(2320,10,18450,0),(2321,10,18451,0),(2322,10,18452,0),(2323,10,18453,0),(2324,10,18454,0),(2325,10,18455,0),(2326,10,18456,0),(2327,10,18457,0),(2328,10,18458,0),(2329,10,18459,0),(2330,10,18460,0),(2331,10,18461,0),(2332,10,18462,0),(2333,10,18463,0),(2334,10,18464,0),(2335,10,18465,0),(2336,10,18466,0),(2337,10,18467,0),(2338,10,18468,0),(2339,10,18469,0),(2340,10,18470,0),(2341,10,18471,0),(2342,10,18472,0),(2343,10,18473,0),(2344,10,18474,0),(2345,10,18475,0),(2346,10,18476,0),(2347,10,18477,0),(2348,10,18478,0),(2349,10,18479,0),(2350,10,18480,0),(2351,10,18481,0),(2352,10,18482,0),(2353,10,18483,0),(2354,10,18484,0),(2355,10,18485,0),(2356,10,18486,0),(2357,10,18487,0),(2358,10,18488,0),(2359,10,18489,0),(2360,10,18490,0),(2361,10,18491,0),(2362,10,18492,0),(2363,10,18493,0),(2364,10,18494,0),(2365,10,18495,0),(2366,10,18496,0),(2367,10,18497,0),(2368,10,18498,0),(2369,10,18499,0),(2370,10,18500,0),(2371,10,18501,0),(2372,10,18502,0),(2373,10,18503,0),(2374,10,18504,0),(2375,10,18505,0),(2376,10,18506,0),(2377,10,18507,0),(2378,10,18508,0),(2379,10,18509,0),(2380,10,18510,0),(2381,10,18511,0),(2382,10,18512,0),(2383,10,18513,0),(2384,10,18514,0),(2385,10,18515,0),(2386,10,18516,0),(2387,10,18517,0),(2388,10,18518,0),(2389,10,18519,0),(2390,10,18520,0),(2391,10,18521,0),(2392,10,18522,0),(2393,10,18523,0),(2394,10,18524,0),(2395,10,18525,0),(2396,10,18526,0),(2397,10,18527,0),(2398,10,18528,0),(2399,10,18529,0),(2400,10,18530,0),(2401,10,18531,0),(2402,10,18532,0),(2403,10,18533,0),(2404,10,18534,0),(2405,10,18535,0),(2406,10,18536,0),(2407,10,18537,0),(2408,10,18538,0),(2409,10,18539,0),(2410,10,18540,0),(2411,10,18541,0),(2412,10,18542,0),(2413,10,18543,0),(2414,10,18544,0),(2415,10,18545,0),(2416,10,18546,0),(2417,10,18547,0),(2418,10,18548,0),(2419,10,18549,0),(2420,10,18550,0),(2421,10,18551,0),(2422,10,18552,0),(2423,10,18553,0),(2424,10,18554,0),(2425,10,18555,0),(2426,10,18556,0),(2427,10,18557,0),(2428,10,18558,0),(2429,10,18559,0),(2430,10,18560,0),(2431,10,18561,0),(2432,10,18562,0),(2433,10,18563,0),(2434,10,18564,0),(2435,10,18565,0),(2436,10,18566,0),(2437,10,18567,0),(2438,10,18568,0),(2439,10,18569,0),(2440,10,18570,0),(2441,10,18571,0),(2442,10,18572,0),(2443,10,18573,0),(2444,10,18574,0),(2445,10,18575,0),(2446,10,18576,0),(2447,10,18577,0),(2448,10,18578,0),(2449,10,18579,0),(2450,10,18580,0),(2451,10,18581,0),(2452,10,18582,0),(2453,10,18583,0),(2454,10,18584,0),(2455,10,18585,0),(2456,10,18586,0),(2457,10,18587,0),(2458,10,18588,0),(2459,10,18589,0),(2460,10,18590,0),(2461,10,18591,0),(2462,10,18592,0),(2463,10,18593,0),(2464,10,18594,0),(2465,10,18595,0),(2466,10,18596,0),(2467,10,18597,0),(2468,10,18598,0),(2469,10,18599,0),(2470,10,18600,0),(2471,10,18601,0),(2472,10,18602,0),(2473,10,18603,0),(2474,10,18604,0),(2475,10,18605,0),(2476,10,18606,0),(2477,10,18607,0),(2478,10,18608,0),(2479,10,18609,0),(2480,10,18610,0),(2481,10,18611,0),(2482,10,18612,0),(2483,10,18613,0),(2484,10,18614,0),(2485,10,18615,0),(2486,10,18616,0),(2487,10,18617,0),(2488,10,18618,0),(2489,10,18619,0),(2490,10,18620,0),(2491,10,18621,0),(2492,10,18622,0),(2493,10,18623,0),(2494,10,18624,0),(2495,10,18625,0),(2496,10,18626,0),(2497,10,18627,0),(2498,10,18628,0),(2499,10,18629,0),(2500,10,18630,0),(2501,10,18631,0),(2502,10,18632,0),(2503,10,18633,0),(2504,10,18634,0),(2505,10,18635,0),(2506,10,18636,0),(2507,10,18637,0),(2508,10,18638,0),(2509,10,18639,0),(2510,10,18640,0),(2511,10,18641,0),(2512,10,18642,0),(2513,10,18643,0),(2514,10,18644,0),(2515,10,18645,0),(2516,10,18646,0),(2517,10,18647,0),(2518,10,18648,0),(2519,10,18649,0),(2520,10,18650,0),(2521,10,18651,0),(2522,10,18652,0),(2523,10,18653,0),(2524,10,18654,0),(2525,10,18655,0),(2526,10,18656,0),(2527,10,18657,0),(2528,10,18658,0),(2529,10,18659,0),(2530,10,18660,0),(2531,10,18661,0),(2532,10,18662,0),(2533,10,18663,0),(2534,10,18664,0),(2535,10,18665,0),(2536,10,18666,0),(2537,10,18667,0),(2538,10,18668,0),(2539,10,18669,0),(2540,10,18670,0),(2541,10,18671,0),(2542,10,18672,0),(2543,10,18673,0),(2544,10,18674,0),(2545,10,18675,0),(2546,10,18676,0),(2547,10,18677,0),(2548,10,18678,0),(2549,10,18679,0),(2550,10,18680,0),(2551,10,18681,0),(2552,10,18682,0),(2553,10,18683,0),(2554,10,18684,0),(2555,10,18685,0),(2556,10,18686,0),(2557,10,18687,0),(2558,10,18688,0),(2559,10,18689,0),(2560,10,18690,0),(2561,10,18691,0),(2562,10,18692,0),(2563,10,18693,0),(2564,10,18694,0),(2565,10,18695,0),(2566,10,18696,0),(2567,10,18697,0),(2568,10,18698,0),(2569,10,18699,0),(2570,10,18700,0),(2571,10,18701,0),(2572,10,18702,0),(2573,10,18703,0),(2574,10,18704,0),(2575,10,18705,0),(2576,10,18706,0),(2577,10,18707,0),(2578,10,18708,0),(2579,10,18709,0),(2580,10,18710,0),(2581,10,18711,0),(2582,10,18712,0),(2583,10,18713,0),(2584,10,18714,0),(2585,10,18715,0),(2586,10,18716,0),(2587,10,18717,0),(2588,10,18718,0),(2589,10,18719,0),(2590,10,18720,0),(2591,10,18721,0),(2592,10,18722,0),(2593,10,18723,0),(2594,10,18724,0),(2595,10,18725,0),(2596,10,18726,0),(2597,10,18727,0),(2598,10,18728,0),(2599,10,18729,0),(2600,10,18730,0),(2601,10,18731,0),(2602,10,18732,0),(2603,10,18733,0),(2604,10,18734,0),(2605,10,18735,0),(2606,10,18736,0),(2607,10,18737,0),(2608,10,18738,0),(2609,10,18739,0),(2610,10,18740,0),(2611,10,18741,0),(2612,10,18742,0),(2613,10,18743,0),(2614,10,18744,0),(2615,10,18745,0),(2616,10,18746,0),(2617,10,18747,0),(2618,10,18748,0),(2619,10,18749,0),(2620,10,18750,0),(2621,10,18751,0),(2622,10,18752,0),(2623,10,18753,0),(2624,10,18754,0),(2625,10,18755,0),(2626,10,18756,0),(2627,10,18757,0),(2628,10,18758,0),(2629,10,18759,0),(2630,10,18760,0),(2631,10,18761,0),(2632,10,18762,0),(2633,10,18763,0),(2634,10,18764,0),(2635,10,18765,0),(2636,10,18766,0),(2637,10,18767,0),(2638,10,18768,0),(2639,10,18769,0),(2640,10,18770,0),(2641,10,18771,0),(2642,10,18772,0),(2643,10,18773,0),(2644,10,18774,0),(2645,10,18775,0),(2646,10,18776,0),(2647,10,18777,0),(2648,10,18778,0),(2649,10,18779,0),(2650,10,18780,0),(2651,10,18781,0),(2652,10,18782,0),(2653,10,18783,0),(2654,10,18784,0),(2655,10,18785,0),(2656,10,18786,0),(2657,10,18787,0),(2658,10,18788,0),(2659,10,18789,0),(2660,10,18790,0),(2661,10,18791,0),(2662,10,18792,0),(2663,10,18793,0),(2664,10,18794,0),(2665,10,18795,0),(2666,10,18796,0),(2667,10,18797,0),(2668,10,18798,0),(2669,10,18799,0),(2670,10,18800,0),(2671,10,18801,0),(2672,10,18802,0),(2673,10,18803,0),(2674,10,18804,0),(2675,10,18805,0),(2676,10,18806,0),(2677,10,18807,0),(2678,10,18808,0),(2679,10,18809,0),(2680,10,18810,0),(2681,10,18811,0),(2682,10,18812,0),(2683,10,18813,0),(2684,10,18814,0),(2685,10,18815,0),(2686,10,18816,0),(2687,10,18817,0),(2688,10,18818,0),(2689,10,18819,0),(2690,10,18820,0),(2691,10,18821,0),(2692,10,18822,0),(2693,10,18823,0),(2694,10,18824,0),(2695,10,18825,0),(2696,10,18826,0),(2697,10,18827,0),(2698,10,18828,0),(2699,10,18829,0),(2700,10,18830,0),(2701,10,18831,0),(2702,10,18832,0),(2703,10,18833,0),(2704,10,18834,0),(2705,10,18835,0),(2706,10,18836,0),(2707,10,18837,0),(2708,10,18838,0),(2709,10,18839,0),(2710,10,18840,0),(2711,10,18841,0),(2712,10,18842,0),(2713,10,18843,0),(2714,10,18844,0),(2715,10,18845,0),(2716,10,18846,0),(2717,10,18847,0),(2718,10,18848,0),(2719,10,18849,0),(2720,10,18850,0),(2721,10,18851,0),(2722,10,18852,0),(2723,10,18853,0),(2724,10,18854,0),(2725,10,18855,0),(2726,10,18856,0),(2727,10,18857,0),(2728,10,18858,0),(2729,10,18859,0),(2730,10,18860,0),(2731,10,18861,0),(2732,10,18862,0),(2733,10,18863,0),(2734,10,18864,0),(2735,10,18865,0),(2736,10,18866,0),(2737,10,18867,0),(2738,10,18868,0),(2739,10,18869,0),(2740,10,18870,0),(2741,10,18871,0),(2742,10,18872,0),(2743,10,18873,0),(2744,10,18874,0),(2745,10,18875,0),(2746,10,18876,0),(2747,10,18877,0),(2748,10,18878,0),(2749,10,18879,0),(2750,10,18880,0),(2751,10,18881,0),(2752,10,18882,0),(2753,10,18883,0),(2754,10,18884,0),(2755,10,18885,0),(2756,10,18886,0),(2757,10,18887,0),(2758,10,18888,0),(2759,10,18889,0),(2760,10,18890,0),(2761,10,18891,0),(2762,10,18892,0),(2763,10,18893,0),(2764,10,18894,0),(2765,10,18895,0),(2766,10,18896,0),(2767,10,18897,0),(2768,10,18898,0),(2769,10,18899,0),(2770,10,18900,0),(2771,10,18901,0),(2772,10,18902,0),(2773,10,18903,0),(2774,10,18904,0),(2775,10,18905,0),(2776,10,18906,0),(2777,10,18907,0),(2778,10,18908,0),(2779,10,18909,0),(2780,10,18910,0),(2781,10,18911,0),(2782,10,18912,0),(2783,10,18913,0),(2784,10,18914,0),(2785,10,18915,0),(2786,10,18916,0),(2787,10,18917,0),(2788,10,18918,0),(2789,10,18919,0),(2790,10,18920,0),(2791,10,18921,0),(2792,10,18922,0),(2793,10,18923,0),(2794,10,18924,0),(2795,10,18925,0),(2796,10,18926,0),(2797,10,18927,0),(2798,10,18928,0),(2799,10,18929,0),(2800,10,18930,0),(2801,10,18931,0),(2802,10,18932,0),(2803,10,18933,0),(2804,10,18934,0),(2805,10,18935,0),(2806,10,18936,0),(2807,10,18937,0),(2808,10,18938,0),(2809,10,18939,0),(2810,10,18940,0),(2811,10,18941,0),(2812,10,18942,0),(2813,10,18943,0),(2814,10,18944,0),(2815,10,18945,0),(2816,10,18946,0),(2817,10,18947,0),(2818,10,18948,0),(2819,10,18949,0),(2820,10,18950,0),(2821,10,18951,0),(2822,10,18952,0),(2823,10,18953,0),(2824,10,18954,0),(2825,10,18955,0),(2826,10,18956,0),(2827,10,18957,0),(2828,10,18958,0),(2829,10,18959,0),(2830,10,18960,0),(2831,10,18961,0),(2832,10,18962,0),(2833,10,18963,0),(2834,10,18964,0),(2835,10,18965,0),(2836,10,18966,0),(2837,10,18967,0),(2838,10,18968,0),(2839,10,18969,0),(2840,10,18970,0),(2841,10,18971,0),(2842,10,18972,0),(2843,10,18973,0),(2844,10,18974,0),(2845,10,18975,0),(2846,10,18976,0),(2847,10,18977,0),(2848,10,18978,0),(2849,10,18979,0),(2850,10,18980,0),(2851,10,18981,0),(2852,10,18982,0),(2853,10,18983,0),(2854,10,18984,0),(2855,10,18985,0),(2856,10,18986,0),(2857,10,18987,0),(2858,10,18988,0),(2859,10,18989,0),(2860,10,18990,0),(2861,10,18991,0),(2862,10,18992,0),(2863,10,18993,0),(2864,10,18994,0),(2865,10,18995,0),(2866,10,18996,0),(2867,10,18997,0),(2868,10,18998,0),(2869,10,18999,0),(2870,10,19000,0),(2871,10,19001,0),(2872,10,19002,0),(2873,10,19003,0),(2874,10,19004,0),(2875,10,19005,0),(2876,10,19006,0),(2877,10,19007,0),(2878,10,19008,0),(2879,10,19009,0),(2880,10,19010,0),(2881,10,19011,0),(2882,10,19012,0),(2883,10,19013,0),(2884,10,19014,0),(2885,10,19015,0),(2886,10,19016,0),(2887,10,19017,0),(2888,10,19018,0),(2889,10,19019,0),(2890,10,19020,0),(2891,10,19021,0),(2892,10,19022,0),(2893,10,19023,0),(2894,10,19024,0),(2895,10,19025,0),(2896,10,19026,0),(2897,10,19027,0),(2898,10,19028,0),(2899,10,19029,0),(2900,10,19030,0),(2901,10,19031,0),(2902,10,19032,0),(2903,10,19033,0),(2904,10,19034,0),(2905,10,19035,0),(2906,10,19036,0),(2907,10,19037,0),(2908,10,19038,0),(2909,10,19039,0),(2910,10,19040,0),(2911,10,19041,0),(2912,10,19042,0),(2913,10,19043,0),(2914,10,19044,0),(2915,10,19045,0),(2916,10,19046,0),(2917,10,19047,0),(2918,10,19048,0),(2919,10,19049,0),(2920,10,19050,0),(2921,10,19051,0),(2922,10,19052,0),(2923,10,19053,0),(2924,10,19054,0),(2925,10,19055,0),(2926,10,19056,0),(2927,10,19057,0),(2928,10,19058,0),(2929,10,19059,0),(2930,10,19060,0),(2931,10,19061,0),(2932,10,19062,0),(2933,10,19063,0),(2934,10,19064,0),(2935,10,19065,0),(2936,10,19066,0),(2937,10,19067,0),(2938,10,19068,0),(2939,10,19069,0),(2940,10,19070,0),(2941,10,19071,0),(2942,10,19072,0),(2943,10,19073,0),(2944,10,19074,0),(2945,10,19075,0),(2946,10,19076,0),(2947,10,19077,0),(2948,10,19078,0),(2949,10,19079,0),(2950,10,19080,0),(2951,10,19081,0),(2952,10,19082,0),(2953,10,19083,0),(2954,10,19084,0),(2955,10,19085,0),(2956,10,19086,0),(2957,10,19087,0),(2958,10,19088,0),(2959,10,19089,0),(2960,10,19090,0),(2961,10,19091,0),(2962,10,19092,0),(2963,10,19093,0),(2964,10,19094,0),(2965,10,19095,0),(2966,10,19096,0),(2967,10,19097,0),(2968,10,19098,0),(2969,10,19099,0),(2970,10,19100,0),(2971,10,19101,0),(2972,10,19102,0),(2973,10,19103,0),(2974,10,19104,0),(2975,10,19105,0),(2976,10,19106,0),(2977,10,19107,0),(2978,10,19108,0),(2979,10,19109,0),(2980,10,19110,0),(2981,10,19111,0),(2982,10,19112,0),(2983,10,19113,0),(2984,10,19114,0),(2985,10,19115,0),(2986,10,19116,0),(2987,10,19117,0),(2988,10,19118,0),(2989,10,19119,0),(2990,10,19120,0),(2991,10,19121,0),(2992,10,19122,0),(2993,10,19123,0),(2994,10,19124,0),(2995,10,19125,0),(2996,10,19126,0),(2997,10,19127,0),(2998,10,19128,0),(2999,10,19129,0),(3000,10,19130,0),(3001,10,19131,0),(3002,10,19132,0),(3003,10,19133,0),(3004,10,19134,0),(3005,10,19135,0),(3006,10,19136,0),(3007,10,19137,0),(3008,10,19138,0),(3009,10,19139,0),(3010,10,19140,0),(3011,10,19141,0),(3012,10,19142,0),(3013,10,19143,0),(3014,10,19144,0),(3015,10,19145,0),(3016,10,19146,0),(3017,10,19147,0),(3018,10,19148,0),(3019,10,19149,0),(3020,10,19150,0),(3021,10,19151,0),(3022,10,19152,0),(3023,10,19153,0),(3024,10,19154,0),(3025,10,19155,0),(3026,10,19156,0),(3027,10,19157,0),(3028,10,19158,0),(3029,10,19159,0),(3030,10,19160,0),(3031,10,19161,0),(3032,10,19162,0),(3033,10,19163,0),(3034,10,19164,0),(3035,10,19165,0),(3036,10,19166,0),(3037,10,19167,0),(3038,10,19168,0),(3039,10,19169,0),(3040,10,19170,0),(3041,10,19171,0),(3042,10,19172,0),(3043,10,19173,0),(3044,10,19174,0),(3045,10,19175,0),(3046,10,19176,0),(3047,10,19177,0),(3048,10,19178,0),(3049,10,19179,0),(3050,10,19180,0),(3051,10,19181,0),(3052,10,19182,0),(3053,10,19183,0),(3054,10,19184,0),(3055,10,19185,0),(3056,10,19186,0),(3057,10,19187,0),(3058,10,19188,0),(3059,10,19189,0),(3060,10,19190,0),(3061,10,19191,0),(3062,10,19192,0),(3063,10,19193,0),(3064,10,19194,0),(3065,10,19195,0),(3066,10,19196,0),(3067,10,19197,0),(3068,10,19198,0),(3069,10,19199,0),(3070,10,19200,0),(3071,10,19201,0),(3072,10,19202,0),(3073,10,19203,0),(3074,10,19204,0),(3075,10,19205,0),(3076,10,19206,0),(3077,10,19207,0),(3078,10,19208,0),(3079,10,19209,0),(3080,10,19210,0),(3081,10,19211,0),(3082,10,19212,0),(3083,10,19213,0),(3084,10,19214,0),(3085,10,19215,0),(3086,10,19216,0),(3087,10,19217,0),(3088,10,19218,0),(3089,10,19219,0),(3090,10,19220,0),(3091,10,19221,0),(3092,10,19222,0),(3093,10,19223,0),(3094,10,19224,0),(3095,10,19225,0),(3096,10,19226,0),(3097,10,19227,0),(3098,10,19228,0),(3099,10,19229,0),(3100,10,19230,0),(3101,10,19231,0),(3102,10,19232,0),(3103,10,19233,0),(3104,10,19234,0),(3105,10,19235,0),(3106,10,19236,0),(3107,10,19237,0),(3108,10,19238,0),(3109,10,19239,0),(3110,10,19240,0),(3111,10,19241,0),(3112,10,19242,0),(3113,10,19243,0),(3114,10,19244,0),(3115,10,19245,0),(3116,10,19246,0),(3117,10,19247,0),(3118,10,19248,0),(3119,10,19249,0),(3120,10,19250,0),(3121,10,19251,0),(3122,10,19252,0),(3123,10,19253,0),(3124,10,19254,0),(3125,10,19255,0),(3126,10,19256,0),(3127,10,19257,0),(3128,10,19258,0),(3129,10,19259,0),(3130,10,19260,0),(3131,10,19261,0),(3132,10,19262,0),(3133,10,19263,0),(3134,10,19264,0),(3135,10,19265,0),(3136,10,19266,0),(3137,10,19267,0),(3138,10,19268,0),(3139,10,19269,0),(3140,10,19270,0),(3141,10,19271,0),(3142,10,19272,0),(3143,10,19273,0),(3144,10,19274,0),(3145,10,19275,0),(3146,10,19276,0),(3147,10,19277,0),(3148,10,19278,0),(3149,10,19279,0),(3150,10,19280,0),(3151,10,19281,0),(3152,10,19282,0),(3153,10,19283,0),(3154,10,19284,0),(3155,10,19285,0),(3156,10,19286,0),(3157,10,19287,0),(3158,10,19288,0),(3159,10,19289,0),(3160,10,19290,0),(3161,10,19291,0),(3162,10,19292,0),(3163,10,19293,0),(3164,10,19294,0),(3165,10,19295,0),(3166,10,19296,0),(3167,10,19297,0),(3168,10,19298,0),(3169,10,19299,0),(3170,10,19300,0),(3171,10,19301,0),(3172,10,19302,0),(3173,10,19303,0),(3174,10,19304,0),(3175,10,19305,0),(3176,10,19306,0),(3177,10,19307,0),(3178,10,19308,0),(3179,10,19309,0),(3180,10,19310,0),(3181,10,19311,0),(3182,10,19312,0),(3183,10,19313,0),(3184,10,19314,0),(3185,10,19315,0),(3186,10,19316,0),(3187,10,19317,0),(3188,10,19318,0),(3189,10,19319,0),(3190,10,19320,0),(3191,10,19321,0),(3192,10,19322,0),(3193,10,19323,0),(3194,10,19324,0),(3195,10,19325,0),(3196,10,19326,0),(3197,10,19327,0),(3198,10,19328,0),(3199,10,19329,0),(3200,10,19330,0),(3201,10,19331,0),(3202,10,19332,0),(3203,10,19333,0),(3204,10,19334,0),(3205,10,19335,0),(3206,10,19336,0),(3207,10,19337,0),(3208,10,19338,0),(3209,10,19339,0),(3210,10,19340,0),(3211,10,19341,0),(3212,10,19342,0),(3213,10,19343,0),(3214,10,19344,0),(3215,10,19345,0),(3216,10,19346,0),(3217,10,19347,0),(3218,10,19348,0),(3219,10,19349,0),(3220,10,19350,0),(3221,10,19351,0),(3222,10,19352,0),(3223,10,19353,0),(3224,10,19354,0),(3225,10,19355,0),(3226,10,19356,0),(3227,10,19357,0),(3228,10,19358,0),(3229,10,19359,0),(3230,10,19360,0),(3231,10,19361,0),(3232,10,19362,0),(3233,10,19363,0),(3234,10,19364,0),(3235,10,19365,0),(3236,10,19366,0),(3237,10,19367,0),(3238,10,19368,0),(3239,10,19369,0),(3240,10,19370,0),(3241,10,19371,0),(3242,10,19372,0),(3243,10,19373,0),(3244,10,19374,0),(3245,10,19375,0),(3246,10,19376,0),(3247,10,19377,0),(3248,10,19378,0),(3249,10,19379,0),(3250,10,19380,0),(3251,10,19381,0),(3252,10,19382,0),(3253,10,19383,0),(3254,10,19384,0),(3255,10,19385,0),(3256,10,19386,0),(3257,10,19387,0),(3258,10,19388,0),(3259,10,19389,0),(3260,10,19390,0),(3261,10,19391,0),(3262,10,19392,0),(3263,10,19393,0),(3264,10,19394,0),(3265,10,19395,0),(3266,10,19396,0),(3267,10,19397,0),(3268,10,19398,0),(3269,10,19399,0),(3270,10,19400,0),(3271,10,19401,0),(3272,10,19402,0),(3273,10,19403,0),(3274,10,19404,0),(3275,10,19405,0),(3276,10,19406,0),(3277,10,19407,0),(3278,10,19408,0),(3279,10,19409,0),(3280,10,19410,0),(3281,10,19411,0),(3282,10,19412,0),(3283,10,19413,0),(3284,10,19414,0),(3285,10,19415,0),(3286,10,19416,0),(3287,10,19417,0),(3288,10,19418,0),(3289,10,19419,0),(3290,10,19420,0),(3291,10,19421,0),(3292,10,19422,0),(3293,10,19423,0),(3294,10,19424,0),(3295,10,19425,0),(3296,10,19426,0),(3297,10,19427,0),(3298,10,19428,0),(3299,10,19429,0),(3300,10,19430,0),(3301,10,19431,0),(3302,10,19432,0),(3303,10,19433,0),(3304,10,19434,0),(3305,10,19435,0),(3306,10,19436,0),(3307,10,19437,0),(3308,10,19438,0),(3309,10,19439,0),(3310,10,19440,0),(3311,10,19441,0),(3312,10,19442,0),(3313,10,19443,0),(3314,10,19444,0),(3315,10,19445,0),(3316,10,19446,0),(3317,10,19447,0),(3318,10,19448,0),(3319,10,19449,0),(3320,10,19450,0),(3321,10,19451,0),(3322,10,19452,0),(3323,10,19453,0),(3324,10,19454,0),(3325,10,19455,0),(3326,10,19456,0),(3327,10,19457,0),(3328,10,19458,0),(3329,10,19459,0),(3330,10,19460,0),(3331,10,19461,0),(3332,10,19462,0),(3333,10,19463,0),(3334,10,19464,0),(3335,10,19465,0),(3336,10,19466,0),(3337,10,19467,0),(3338,10,19468,0),(3339,10,19469,0),(3340,10,19470,0),(3341,10,19471,0),(3342,10,19472,0),(3343,10,19473,0),(3344,10,19474,0),(3345,10,19475,0),(3346,10,19476,0),(3347,10,19477,0),(3348,10,19478,0),(3349,10,19479,0),(3350,10,19480,0),(3351,10,19481,0),(3352,10,19482,0),(3353,10,19483,0),(3354,10,19484,0),(3355,10,19485,0),(3356,10,19486,0),(3357,10,19487,0),(3358,10,19488,0),(3359,10,19489,0),(3360,10,19490,0),(3361,10,19491,0),(3362,10,19492,0),(3363,10,19493,0),(3364,10,19494,0),(3365,10,19495,0),(3366,10,19496,0),(3367,10,19497,0),(3368,10,19498,0),(3369,10,19499,0),(3370,10,19500,0),(3371,10,19501,0),(3372,10,19502,0),(3373,10,19503,0),(3374,10,19504,0),(3375,10,19505,0),(3376,10,19506,0),(3377,10,19507,0),(3378,10,19508,0),(3379,10,19509,0),(3380,10,18290,0),(3381,10,18291,0),(3382,10,18292,0),(3383,10,18293,0),(3384,10,18294,0),(3385,10,18295,0),(3386,10,18296,0),(3387,10,18297,0),(3388,10,18298,0),(3389,10,18299,0),(3390,10,18300,0),(3391,10,18301,0),(3392,10,18302,0),(3393,10,18303,0),(3394,10,18304,0),(3395,10,18305,0),(3396,10,18306,0),(3397,10,18307,0),(3398,10,18308,0),(3399,10,18309,0),(3400,10,18090,0),(3401,10,18091,0),(3402,10,18092,0),(3403,10,18093,0),(3404,10,18094,0),(3405,10,18095,0),(3406,10,18096,0),(3407,10,18097,0),(3408,10,18098,0),(3409,10,18099,0),(3410,10,18100,0),(3411,10,18101,0),(3412,10,18102,0),(3413,10,18103,0),(3414,10,18104,0),(3415,10,18105,0),(3416,10,18106,0),(3417,10,18107,0),(3418,10,18108,0),(3419,10,18109,0),(3420,10,18110,0),(3421,10,18111,0),(3422,10,18112,0),(3423,10,18113,0),(3424,10,18114,0),(3425,10,18115,0),(3426,10,18116,0),(3427,10,18117,0),(3428,10,18118,0),(3429,10,18119,0),(3430,10,18120,0),(3431,10,18121,0),(3432,10,18122,0),(3433,10,18123,0),(3434,10,18124,0),(3435,10,18125,0),(3436,10,18126,0),(3437,10,18127,0),(3438,10,18128,0),(3439,10,18129,0),(3440,10,18130,0),(3441,10,18131,0),(3442,10,18132,0),(3443,10,18133,0),(3444,10,18134,0),(3445,10,18135,0),(3446,10,18136,0),(3447,10,18137,0),(3448,10,18138,0),(3449,10,18139,0),(3450,10,18140,0),(3451,10,18141,0),(3452,10,18142,0),(3453,10,18143,0),(3454,10,18144,0),(3455,10,18145,0),(3456,10,18146,0),(3457,10,18147,0),(3458,10,18148,0),(3459,10,18149,0),(3460,10,18150,0),(3461,10,18151,0),(3462,10,18152,0),(3463,10,18153,0),(3464,10,18154,0),(3465,10,18155,0),(3466,10,18156,0),(3467,10,18157,0),(3468,10,18158,0),(3469,10,18159,0),(3470,10,18160,0),(3471,10,18161,0),(3472,10,18162,0),(3473,10,18163,0),(3474,10,18164,0),(3475,10,18165,0),(3476,10,18166,0),(3477,10,18167,0),(3478,10,18168,0),(3479,10,18169,0),(3480,10,18170,0),(3481,10,18171,0),(3482,10,18172,0),(3483,10,18173,0),(3484,10,18174,0),(3485,10,18175,0),(3486,10,18176,0),(3487,10,18177,0),(3488,10,18178,0),(3489,10,18179,0),(3490,10,18180,0),(3491,10,18181,0),(3492,10,18182,0),(3493,10,18183,0),(3494,10,18184,0),(3495,10,18185,0),(3496,10,18186,0),(3497,10,18187,0),(3498,10,18188,0),(3499,10,18189,0),(3500,10,18190,0),(3501,10,18191,0),(3502,10,18192,0),(3503,10,18193,0),(3504,10,18194,0),(3505,10,18195,0),(3506,10,18196,0),(3507,10,18197,0),(3508,10,18198,0),(3509,10,18199,0),(3510,10,18200,0),(3511,10,18201,0),(3512,10,18202,0),(3513,10,18203,0),(3514,10,18204,0),(3515,10,18205,0),(3516,10,18206,0),(3517,10,18207,0),(3518,10,18208,0),(3519,10,18209,0),(3520,10,18210,0),(3521,10,18211,0),(3522,10,18212,0),(3523,10,18213,0),(3524,10,18214,0),(3525,10,18215,0),(3526,10,18216,0),(3527,10,18217,0),(3528,10,18218,0),(3529,10,18219,0),(3530,10,18220,0),(3531,10,18221,0),(3532,10,18222,0),(3533,10,18223,0),(3534,10,18224,0),(3535,10,18225,0),(3536,10,18226,0),(3537,10,18227,0),(3538,10,18228,0),(3539,10,18229,0),(3540,10,18230,0),(3541,10,18231,0),(3542,10,18232,0),(3543,10,18233,0),(3544,10,18234,0),(3545,10,18235,0),(3546,10,18236,0),(3547,10,18237,0),(3548,10,18238,0),(3549,10,18239,0),(3550,10,18240,0),(3551,10,18241,0),(3552,10,18242,0),(3553,10,18243,0),(3554,10,18244,0),(3555,10,18245,0),(3556,10,18246,0),(3557,10,18247,0),(3558,10,18248,0),(3559,10,18249,0),(3560,10,18250,0),(3561,10,18251,0),(3562,10,18252,0),(3563,10,18253,0),(3564,10,18254,0),(3565,10,18255,0),(3566,10,18256,0),(3567,10,18257,0),(3568,10,18258,0),(3569,10,18259,0),(3570,10,18260,0),(3571,10,18261,0),(3572,10,18262,0),(3573,10,18263,0),(3574,10,18264,0),(3575,10,18265,0),(3576,10,18266,0),(3577,10,18267,0),(3578,10,18268,0),(3579,10,18269,0),(3580,10,18270,0),(3581,10,18271,0),(3582,10,18272,0),(3583,10,18273,0),(3584,10,18274,0),(3585,10,18275,0),(3586,10,18276,0),(3587,10,18277,0),(3588,10,18278,0),(3589,10,18279,0),(3590,10,18280,0),(3591,10,18281,0),(3592,10,18282,0),(3593,10,18283,0),(3594,10,18284,0),(3595,10,18285,0),(3596,10,18286,0),(3597,10,18287,0),(3598,10,18288,0),(3599,10,18289,0),(3600,2,299,0),(3601,10,299,0),(3602,2,300,0),(3603,10,300,0),(3604,2,301,0),(3605,10,301,0),(3606,2,302,0),(3607,10,302,0),(3608,2,303,0),(3609,10,303,0),(3610,2,304,0),(3611,10,304,0),(3612,2,305,0),(3613,10,305,0),(3614,2,306,0),(3615,10,306,0),(3616,2,307,0),(3617,10,307,0),(3618,2,308,0),(3619,10,308,0),(3620,2,309,0),(3621,10,309,0),(3622,2,310,0),(3623,10,310,0),(3624,2,311,0),(3625,10,311,0),(3626,2,312,0),(3627,10,312,0),(3628,2,313,0),(3629,10,313,0),(3630,2,314,0),(3631,10,314,0),(3632,2,315,0),(3633,10,315,0),(3634,2,316,0),(3635,10,316,0),(3636,2,317,0),(3637,10,317,0),(3638,2,318,0),(3639,10,318,0),(3640,2,319,0),(3641,10,319,0),(3642,2,320,0),(3643,10,320,0),(3644,2,321,0),(3645,10,321,0),(3646,2,322,0),(3647,10,322,0),(3648,2,323,0),(3649,10,323,0),(3650,2,324,0),(3651,10,324,0),(3652,2,325,0),(3653,10,325,0),(3654,2,326,0),(3655,10,326,0),(3656,2,327,0),(3657,10,327,0),(3658,2,328,0),(3659,10,328,0),(3660,2,329,0),(3661,10,329,0),(3662,2,330,0),(3663,10,330,0),(3664,2,331,0),(3665,10,331,0),(3666,2,332,0),(3667,10,332,0),(3668,2,333,0),(3669,10,333,0),(3670,2,334,0),(3671,10,334,0),(3672,2,335,0),(3673,10,335,0),(3674,2,336,0),(3675,10,336,0),(3676,2,337,0),(3677,10,337,0),(3678,2,338,0),(3679,10,338,0),(3680,2,339,0),(3681,10,339,0),(3682,2,340,0),(3683,10,340,0),(3684,2,341,0),(3685,10,341,0),(3686,2,342,0),(3687,10,342,0),(3688,2,343,0),(3689,10,343,0),(3690,2,344,0),(3691,10,344,0),(3692,2,345,0),(3693,10,345,0),(3694,2,346,0),(3695,10,346,0),(3696,2,347,0),(3697,10,347,0),(3698,2,348,0),(3699,10,348,0),(3700,2,349,0),(3701,10,349,0),(3702,2,350,0),(3703,10,350,0),(3704,2,351,0),(3705,10,351,0),(3706,2,352,0),(3707,10,352,0),(3708,2,353,0),(3709,10,353,0),(3710,2,354,0),(3711,10,354,0),(3712,2,355,0),(3713,10,355,0),(3714,2,356,0),(3715,10,356,0),(3716,2,357,0),(3717,10,357,0),(3718,2,358,0),(3719,10,358,0),(3720,2,359,0),(3721,10,359,0),(3722,2,360,0),(3723,10,360,0),(3724,2,361,0),(3725,10,361,0),(3726,2,362,0),(3727,10,362,0),(3728,2,363,0),(3729,10,363,0),(3730,2,364,0),(3731,10,364,0),(3732,2,365,0),(3733,10,365,0),(3734,2,366,0),(3735,10,366,0),(3736,2,367,0),(3737,10,367,0),(3738,2,368,0),(3739,10,368,0),(3740,2,369,0),(3741,10,369,0),(3742,2,370,0),(3743,10,370,0),(3744,2,371,0),(3745,10,371,0),(3746,2,372,0),(3747,10,372,0),(3748,2,373,0),(3749,10,373,0),(3750,2,374,0),(3751,10,374,0),(3752,2,375,0),(3753,10,375,0),(3754,2,376,0),(3755,10,376,0),(3756,2,377,0),(3757,10,377,0),(3758,2,378,0),(3759,10,378,0),(3760,2,379,0),(3761,10,379,0),(3762,2,380,0),(3763,10,380,0),(3764,2,381,0),(3765,10,381,0),(3766,2,382,0),(3767,10,382,0),(3768,2,383,0),(3769,10,383,0),(3770,2,384,0),(3771,10,384,0),(3772,2,385,0),(3773,10,385,0),(3774,2,386,0),(3775,10,386,0),(3776,2,387,0),(3777,10,387,0),(3778,2,388,0),(3779,10,388,0),(3780,2,389,0),(3781,10,389,0),(3782,2,390,0),(3783,10,390,0),(3784,2,391,0),(3785,10,391,0),(3786,2,392,0),(3787,10,392,0),(3788,2,393,0),(3789,10,393,0),(3790,2,394,0),(3791,10,394,0),(3792,2,395,0),(3793,10,395,0),(3794,2,396,0),(3795,10,396,0),(3796,2,397,0),(3797,10,397,0),(3798,2,398,0),(3799,10,398,0),(3800,2,399,0),(3801,10,399,0),(3802,2,400,0),(3803,10,400,0),(3804,2,401,0),(3805,10,401,0),(3806,2,402,0),(3807,10,402,0),(3808,2,403,0),(3809,10,403,0),(3810,2,404,0),(3811,10,404,0),(3812,2,405,0),(3813,10,405,0),(3814,2,406,0),(3815,10,406,0),(3816,2,407,0),(3817,10,407,0),(3818,2,408,0),(3819,10,408,0),(3820,2,409,0),(3821,10,409,0),(3822,2,410,0),(3823,10,410,0),(3824,2,411,0),(3825,10,411,0),(3826,2,412,0),(3827,10,412,0),(3828,2,413,0),(3829,10,413,0),(3830,2,414,0),(3831,10,414,0),(3832,2,415,0),(3833,10,415,0),(3834,2,416,0),(3835,10,416,0),(3836,2,417,0),(3837,10,417,0),(3838,2,418,0),(3839,10,418,0),(3840,2,419,0),(3841,10,419,0),(3842,2,420,0),(3843,10,420,0),(3844,2,421,0),(3845,10,421,0),(3846,2,422,0),(3847,10,422,0),(3848,2,423,0),(3849,10,423,0),(3850,2,424,0),(3851,10,424,0),(3852,2,425,0),(3853,10,425,0),(3854,2,426,0),(3855,10,426,0),(3856,2,427,0),(3857,10,427,0),(3858,2,428,0),(3859,10,428,0),(3860,2,429,0),(3861,10,429,0),(3862,2,430,0),(3863,10,430,0),(3864,2,431,0),(3865,10,431,0),(3866,2,432,0),(3867,10,432,0),(3868,2,433,0),(3869,10,433,0),(3870,2,434,0),(3871,10,434,0),(3872,2,435,0),(3873,10,435,0),(3874,2,436,0),(3875,10,436,0),(3876,2,437,0),(3877,10,437,0),(3878,2,438,0),(3879,10,438,0),(3880,2,439,0),(3881,10,439,0),(3882,2,440,0),(3883,10,440,0),(3884,2,441,0),(3885,10,441,0),(3886,2,442,0),(3887,10,442,0),(3888,2,443,0),(3889,10,443,0),(3890,2,444,0),(3891,10,444,0),(3892,2,445,0),(3893,10,445,0),(3894,2,446,0),(3895,10,446,0),(3896,2,447,0),(3897,10,447,0),(3898,2,448,0),(3899,10,448,0),(3900,2,449,0),(3901,10,449,0),(3902,2,450,0),(3903,10,450,0),(3904,2,451,0),(3905,10,451,0),(3906,2,452,0),(3907,10,452,0),(3908,2,453,0),(3909,10,453,0),(3910,2,454,0),(3911,10,454,0),(3912,2,455,0),(3913,10,455,0),(3914,2,456,0),(3915,10,456,0),(3916,2,457,0),(3917,10,457,0),(3918,2,458,0),(3919,10,458,0),(3920,2,459,0),(3921,10,459,0),(3922,2,460,0),(3923,10,460,0),(3924,2,461,0),(3925,10,461,0),(3926,2,462,0),(3927,10,462,0),(3928,2,463,0),(3929,10,463,0),(3930,2,464,0),(3931,10,464,0),(3932,2,465,0),(3933,10,465,0),(3934,2,466,0),(3935,10,466,0),(3936,2,467,0),(3937,10,467,0),(3938,2,468,0),(3939,10,468,0),(3940,2,469,0),(3941,10,469,0),(3942,2,470,0),(3943,10,470,0),(3944,2,471,0),(3945,10,471,0),(3946,2,472,0),(3947,10,472,0),(3948,2,473,0),(3949,10,473,0),(3950,2,474,0),(3951,10,474,0),(3952,2,475,0),(3953,10,475,0),(3954,2,476,0),(3955,10,476,0),(3956,2,477,0),(3957,10,477,0),(3958,2,478,0),(3959,10,478,0),(3960,2,479,0),(3961,10,479,0),(3962,2,480,0),(3963,10,480,0),(3964,2,481,0),(3965,10,481,0),(3966,2,482,0),(3967,10,482,0),(3968,2,483,0),(3969,10,483,0),(3970,2,484,0),(3971,10,484,0),(3972,2,485,0),(3973,10,485,0),(3974,2,486,0),(3975,10,486,0),(3976,2,487,0),(3977,10,487,0),(3978,2,488,0),(3979,10,488,0),(3980,2,489,0),(3981,10,489,0),(3982,2,490,0),(3983,10,490,0),(3984,2,491,0),(3985,10,491,0),(3986,2,492,0),(3987,10,492,0),(3988,2,493,0),(3989,10,493,0),(3990,2,494,0),(3991,10,494,0),(3992,2,495,0),(3993,10,495,0),(3994,2,496,0),(3995,10,496,0),(3996,2,497,0),(3997,10,497,0),(3998,2,498,0),(3999,10,498,0),(4000,2,499,0),(4001,10,499,0),(4002,2,500,0),(4003,10,500,0),(4004,2,501,0),(4005,10,501,0),(4006,2,502,0),(4007,10,502,0),(4008,2,503,0),(4009,10,503,0),(4010,2,504,0),(4011,10,504,0),(4012,2,505,0),(4013,10,505,0),(4014,2,506,0),(4015,10,506,0),(4016,2,507,0),(4017,10,507,0),(4018,2,508,0),(4019,10,508,0),(4020,2,509,0),(4021,10,509,0),(4022,2,510,0),(4023,10,510,0),(4024,2,511,0),(4025,10,511,0),(4026,2,512,0),(4027,10,512,0),(4028,2,513,0),(4029,10,513,0),(4030,2,514,0),(4031,10,514,0),(4032,2,515,0),(4033,10,515,0),(4034,2,516,0),(4035,10,516,0),(4036,2,517,0),(4037,10,517,0),(4038,2,518,0),(4039,10,518,0),(4040,2,519,0),(4041,10,519,0),(4042,2,520,0),(4043,10,520,0),(4044,2,521,0),(4045,10,521,0),(4046,2,522,0),(4047,10,522,0),(4048,2,523,0),(4049,10,523,0),(4050,2,524,0),(4051,10,524,0),(4052,2,525,0),(4053,10,525,0),(4054,2,526,0),(4055,10,526,0),(4056,2,527,0),(4057,10,527,0),(4058,2,528,0),(4059,10,528,0),(4060,2,529,0),(4061,10,529,0),(4062,2,530,0),(4063,10,530,0),(4064,2,531,0),(4065,10,531,0),(4066,2,532,0),(4067,10,532,0),(4068,2,533,0),(4069,10,533,0),(4070,2,534,0),(4071,10,534,0),(4072,2,535,0),(4073,10,535,0),(4074,2,536,0),(4075,10,536,0),(4076,2,537,0),(4077,10,537,0),(4078,2,538,0),(4079,10,538,0),(4080,2,539,0),(4081,10,539,0),(4082,2,540,0),(4083,10,540,0),(4084,2,541,0),(4085,10,541,0),(4086,2,542,0),(4087,10,542,0),(4088,2,543,0),(4089,10,543,0),(4090,2,544,0),(4091,10,544,0),(4092,2,545,0),(4093,10,545,0),(4094,2,546,0),(4095,10,546,0),(4096,2,547,0),(4097,10,547,0),(4098,2,548,0),(4099,10,548,0),(4100,2,549,0),(4101,10,549,0),(4102,2,550,0),(4103,10,550,0),(4104,2,551,0),(4105,10,551,0),(4106,2,552,0),(4107,10,552,0),(4108,2,553,0),(4109,10,553,0),(4110,2,554,0),(4111,10,554,0),(4112,2,555,0),(4113,10,555,0),(4114,2,556,0),(4115,10,556,0),(4116,2,557,0),(4117,10,557,0),(4118,2,558,0),(4119,10,558,0),(4120,2,559,0),(4121,10,559,0),(4122,2,560,0),(4123,10,560,0),(4124,2,561,0),(4125,10,561,0),(4126,2,562,0),(4127,10,562,0),(4128,2,563,0),(4129,10,563,0),(4130,2,564,0),(4131,10,564,0),(4132,2,565,0),(4133,10,565,0),(4134,2,566,0),(4135,10,566,0),(4136,2,567,0),(4137,10,567,0),(4138,2,568,0),(4139,10,568,0),(4140,2,569,0),(4141,10,569,0),(4142,2,570,0),(4143,10,570,0),(4144,2,571,0),(4145,10,571,0),(4146,2,572,0),(4147,10,572,0),(4148,2,573,0),(4149,10,573,0),(4150,2,574,0),(4151,10,574,0),(4152,2,575,0),(4153,10,575,0),(4154,2,576,0),(4155,10,576,0),(4156,2,577,0),(4157,10,577,0),(4158,2,578,0),(4159,10,578,0),(4160,2,579,0),(4161,10,579,0),(4162,2,580,0),(4163,10,580,0),(4164,2,581,0),(4165,10,581,0),(4166,2,582,0),(4167,10,582,0),(4168,2,583,0),(4169,10,583,0),(4170,2,584,0),(4171,10,584,0),(4172,2,585,0),(4173,10,585,0),(4174,2,586,0),(4175,10,586,0),(4176,2,587,0),(4177,10,587,0),(4178,2,588,0),(4179,10,588,0),(4180,2,589,0),(4181,10,589,0),(4182,2,590,0),(4183,10,590,0),(4184,2,591,0),(4185,10,591,0),(4186,2,592,0),(4187,10,592,0),(4188,2,593,0),(4189,10,593,0),(4190,2,594,0),(4191,10,594,0),(4192,2,595,0),(4193,10,595,0),(4194,2,596,0),(4195,10,596,0),(4196,2,597,0),(4197,10,597,0),(4198,2,598,0),(4199,10,598,0),(4200,2,599,0),(4201,10,599,0),(4202,2,600,0),(4203,10,600,0),(4204,2,601,0),(4205,10,601,0),(4206,2,602,0),(4207,10,602,0),(4208,2,603,0),(4209,10,603,0),(4210,2,604,0),(4211,10,604,0),(4212,2,605,0),(4213,10,605,0),(4214,2,606,0),(4215,10,606,0),(4216,2,607,0),(4217,10,607,0),(4218,2,608,0),(4219,10,608,0),(4220,2,609,0),(4221,10,609,0),(4222,2,610,0),(4223,10,610,0),(4224,2,611,0),(4225,10,611,0),(4226,2,612,0),(4227,10,612,0),(4228,2,613,0),(4229,10,613,0),(4230,2,614,0),(4231,10,614,0),(4232,2,615,0),(4233,10,615,0),(4234,2,616,0),(4235,10,616,0),(4236,2,617,0),(4237,10,617,0),(4238,2,618,0),(4239,10,618,0),(4240,2,619,0),(4241,10,619,0),(4242,2,620,0),(4243,10,620,0),(4244,2,621,0),(4245,10,621,0),(4246,2,622,0),(4247,10,622,0),(4248,2,623,0),(4249,10,623,0),(4250,2,624,0),(4251,10,624,0),(4252,2,625,0),(4253,10,625,0),(4254,2,626,0),(4255,10,626,0),(4256,2,627,0),(4257,10,627,0),(4258,2,628,0),(4259,10,628,0),(4260,2,629,0),(4261,10,629,0),(4262,2,630,0),(4263,10,630,0),(4264,2,631,0),(4265,10,631,0),(4266,2,632,0),(4267,10,632,0),(4268,2,633,0),(4269,10,633,0),(4270,2,634,0),(4271,10,634,0),(4272,2,635,0),(4273,10,635,0),(4274,2,636,0),(4275,10,636,0),(4276,2,637,0),(4277,10,637,0),(4278,2,638,0),(4279,10,638,0),(4280,2,639,0),(4281,10,639,0),(4282,2,640,0),(4283,10,640,0),(4284,2,641,0),(4285,10,641,0),(4286,2,642,0),(4287,10,642,0),(4288,2,643,0),(4289,10,643,0),(4290,2,644,0),(4291,10,644,0),(4292,2,645,0),(4293,10,645,0),(4294,2,646,0),(4295,10,646,0),(4296,2,647,0),(4297,10,647,0),(4298,2,648,0),(4299,10,648,0),(4300,2,649,0),(4301,10,649,0),(4302,2,650,0),(4303,10,650,0),(4304,2,651,0),(4305,10,651,0),(4306,2,652,0),(4307,10,652,0),(4308,2,653,0),(4309,10,653,0),(4310,2,654,0),(4311,10,654,0),(4312,2,655,0),(4313,10,655,0),(4314,2,656,0),(4315,10,656,0),(4316,2,657,0),(4317,10,657,0),(4318,2,658,0),(4319,10,658,0),(4320,2,659,0),(4321,10,659,0),(4322,2,660,0),(4323,10,660,0),(4324,2,661,0),(4325,10,661,0),(4326,2,662,0),(4327,10,662,0),(4328,2,663,0),(4329,10,663,0),(4330,2,664,0),(4331,10,664,0),(4332,2,665,0),(4333,10,665,0),(4334,2,666,0),(4335,10,666,0),(4336,2,667,0),(4337,10,667,0),(4338,2,668,0),(4339,10,668,0),(4340,2,669,0),(4341,10,669,0),(4342,2,670,0),(4343,10,670,0),(4344,2,671,0),(4345,10,671,0),(4346,2,672,0),(4347,10,672,0),(4348,2,673,0),(4349,10,673,0),(4350,2,674,0),(4351,10,674,0),(4352,2,675,0),(4353,10,675,0),(4354,2,676,0),(4355,10,676,0),(4356,2,677,0),(4357,10,677,0),(4358,2,678,0),(4359,10,678,0),(4360,2,679,0),(4361,10,679,0),(4362,2,680,0),(4363,10,680,0),(4364,2,681,0),(4365,10,681,0),(4366,2,682,0),(4367,10,682,0),(4368,2,683,0),(4369,10,683,0),(4370,2,684,0),(4371,10,684,0),(4372,2,685,0),(4373,10,685,0),(4374,2,686,0),(4375,10,686,0),(4376,2,687,0),(4377,10,687,0),(4378,2,688,0),(4379,10,688,0),(4380,2,689,0),(4381,10,689,0),(4382,2,690,0),(4383,10,690,0),(4384,2,691,0),(4385,10,691,0),(4386,2,692,0),(4387,10,692,0),(4388,2,693,0),(4389,10,693,0),(4390,2,694,0),(4391,10,694,0),(4392,2,695,0),(4393,10,695,0),(4394,2,696,0),(4395,10,696,0),(4396,2,697,0),(4397,10,697,0),(4398,2,698,0),(4399,10,698,0),(4400,2,699,0),(4401,10,699,0),(4402,2,700,0),(4403,10,700,0),(4404,2,701,0),(4405,10,701,0),(4406,2,702,0),(4407,10,702,0),(4408,2,703,0),(4409,10,703,0),(4410,2,704,0),(4411,10,704,0),(4412,2,705,0),(4413,10,705,0),(4414,2,706,0),(4415,10,706,0),(4416,2,707,0),(4417,10,707,0),(4418,2,708,0),(4419,10,708,0),(4420,2,709,0),(4421,10,709,0),(4422,2,710,0),(4423,10,710,0),(4424,2,711,0),(4425,10,711,0),(4426,2,712,0),(4427,10,712,0),(4428,2,713,0),(4429,10,713,0),(4430,2,714,0),(4431,10,714,0),(4432,2,715,0),(4433,10,715,0),(4434,2,716,0),(4435,10,716,0),(4436,2,717,0),(4437,10,717,0),(4438,2,718,0),(4439,10,718,0),(4440,2,719,0),(4441,10,719,0),(4442,2,720,0),(4443,10,720,0),(4444,2,721,0),(4445,10,721,0),(4446,2,722,0),(4447,10,722,0),(4448,2,723,0),(4449,10,723,0),(4450,2,724,0),(4451,10,724,0),(4452,2,725,0),(4453,10,725,0),(4454,2,726,0),(4455,10,726,0),(4456,2,727,0),(4457,10,727,0),(4458,2,728,0),(4459,10,728,0),(4460,2,729,0),(4461,10,729,0),(4462,2,730,0),(4463,10,730,0),(4464,2,731,0),(4465,10,731,0),(4466,2,732,0),(4467,10,732,0),(4468,2,733,0),(4469,10,733,0),(4470,2,734,0),(4471,10,734,0),(4472,2,735,0),(4473,10,735,0),(4474,2,736,0),(4475,10,736,0),(4476,2,737,0),(4477,10,737,0),(4478,2,738,0),(4479,10,738,0),(4480,2,739,0),(4481,10,739,0),(4482,2,740,0),(4483,10,740,0),(4484,2,741,0),(4485,10,741,0),(4486,2,742,0),(4487,10,742,0),(4488,2,743,0),(4489,10,743,0),(4490,2,744,0),(4491,10,744,0),(4492,2,745,0),(4493,10,745,0),(4494,2,746,0),(4495,10,746,0),(4496,2,747,0),(4497,10,747,0),(4498,2,748,0),(4499,10,748,0),(4500,2,749,0),(4501,10,749,0),(4502,2,750,0),(4503,10,750,0),(4504,2,751,0),(4505,10,751,0),(4506,2,752,0),(4507,10,752,0),(4508,2,753,0),(4509,10,753,0),(4510,2,754,0),(4511,10,754,0),(4512,2,755,0),(4513,10,755,0),(4514,2,756,0),(4515,10,756,0),(4516,2,757,0),(4517,10,757,0),(4518,2,758,0),(4519,10,758,0),(4520,2,759,0),(4521,10,759,0),(4522,2,760,0),(4523,10,760,0),(4524,2,761,0),(4525,10,761,0),(4526,2,762,0),(4527,10,762,0),(4528,2,763,0),(4529,10,763,0),(4530,2,764,0),(4531,10,764,0),(4532,2,765,0),(4533,10,765,0),(4534,2,766,0),(4535,10,766,0),(4536,2,767,0),(4537,10,767,0),(4538,2,768,0),(4539,10,768,0),(4540,2,769,0),(4541,10,769,0),(4542,2,770,0),(4543,10,770,0),(4544,2,771,0),(4545,10,771,0),(4546,2,772,0),(4547,10,772,0),(4548,2,773,0),(4549,10,773,0),(4550,2,774,0),(4551,10,774,0),(4552,2,775,0),(4553,10,775,0),(4554,2,776,0),(4555,10,776,0),(4556,2,777,0),(4557,10,777,0),(4558,2,778,0),(4559,10,778,0),(4560,2,779,0),(4561,10,779,0),(4562,2,780,0),(4563,10,780,0),(4564,2,781,0),(4565,10,781,0),(4566,2,782,0),(4567,10,782,0),(4568,2,783,0),(4569,10,783,0),(4570,2,784,0),(4571,10,784,0),(4572,2,785,0),(4573,10,785,0),(4574,2,786,0),(4575,10,786,0),(4576,2,787,0),(4577,10,787,0),(4578,2,788,0),(4579,10,788,0),(4580,2,789,0),(4581,10,789,0),(4582,2,790,0),(4583,10,790,0),(4584,2,791,0),(4585,10,791,0),(4586,2,792,0),(4587,10,792,0),(4588,2,793,0),(4589,10,793,0),(4590,2,794,0),(4591,10,794,0),(4592,2,795,0),(4593,10,795,0),(4594,2,796,0),(4595,10,796,0),(4596,2,797,0),(4597,10,797,0),(4598,2,798,0),(4599,10,798,0),(4600,2,799,0),(4601,10,799,0),(4602,2,800,0),(4603,10,800,0),(4604,2,801,0),(4605,10,801,0),(4606,2,802,0),(4607,10,802,0),(4608,2,803,0),(4609,10,803,0),(4610,2,804,0),(4611,10,804,0),(4612,2,805,0),(4613,10,805,0),(4614,2,806,0),(4615,10,806,0),(4616,2,807,0),(4617,10,807,0),(4618,2,808,0),(4619,10,808,0),(4620,2,809,0),(4621,10,809,0),(4622,2,810,0),(4623,10,810,0),(4624,2,811,0),(4625,10,811,0),(4626,2,812,0),(4627,10,812,0),(4628,2,813,0),(4629,10,813,0),(4630,2,814,0),(4631,10,814,0),(4632,2,815,0),(4633,10,815,0),(4634,2,816,0),(4635,10,816,0),(4636,2,817,0),(4637,10,817,0),(4638,2,818,0),(4639,10,818,0),(4640,2,819,0),(4641,10,819,0),(4642,2,820,0),(4643,10,820,0),(4644,2,821,0),(4645,10,821,0),(4646,2,822,0),(4647,10,822,0),(4648,2,823,0),(4649,10,823,0),(4650,2,824,0),(4651,10,824,0),(4652,2,825,0),(4653,10,825,0),(4654,2,826,0),(4655,10,826,0),(4656,2,827,0),(4657,10,827,0),(4658,2,828,0),(4659,10,828,0),(4660,2,829,0),(4661,10,829,0),(4662,2,830,0),(4663,10,830,0),(4664,2,831,0),(4665,10,831,0),(4666,2,832,0),(4667,10,832,0),(4668,2,833,0),(4669,10,833,0),(4670,2,834,0),(4671,10,834,0),(4672,2,835,0),(4673,10,835,0),(4674,2,836,0),(4675,10,836,0),(4676,2,837,0),(4677,10,837,0),(4678,2,838,0),(4679,10,838,0),(4680,2,839,0),(4681,10,839,0),(4682,2,840,0),(4683,10,840,0),(4684,2,841,0),(4685,10,841,0),(4686,2,842,0),(4687,10,842,0),(4688,2,843,0),(4689,10,843,0),(4690,2,844,0),(4691,10,844,0),(4692,2,845,0),(4693,10,845,0),(4694,2,846,0),(4695,10,846,0),(4696,2,847,0),(4697,10,847,0),(4698,2,848,0),(4699,10,848,0),(4700,2,849,0),(4701,10,849,0),(4702,2,850,0),(4703,10,850,0),(4704,2,851,0),(4705,10,851,0),(4706,2,852,0),(4707,10,852,0),(4708,2,853,0),(4709,10,853,0),(4710,2,854,0),(4711,10,854,0),(4712,2,855,0),(4713,10,855,0),(4714,2,856,0),(4715,10,856,0),(4716,2,857,0),(4717,10,857,0),(4718,2,858,0),(4719,10,858,0),(4720,2,859,0),(4721,10,859,0),(4722,2,860,0),(4723,10,860,0),(4724,2,861,0),(4725,10,861,0),(4726,2,862,0),(4727,10,862,0),(4728,2,863,0),(4729,10,863,0),(4730,2,864,0),(4731,10,864,0),(4732,2,865,0),(4733,10,865,0),(4734,2,866,0),(4735,10,866,0),(4736,2,867,0),(4737,10,867,0),(4738,2,868,0),(4739,10,868,0),(4740,2,869,0),(4741,10,869,0),(4742,2,870,0),(4743,10,870,0),(4744,2,871,0),(4745,10,871,0),(4746,2,872,0),(4747,10,872,0),(4748,2,873,0),(4749,10,873,0),(4750,2,874,0),(4751,10,874,0),(4752,2,875,0),(4753,10,875,0),(4754,2,876,0),(4755,10,876,0),(4756,2,877,0),(4757,10,877,0),(4758,2,878,0),(4759,10,878,0),(4760,2,879,0),(4761,10,879,0),(4762,2,880,0),(4763,10,880,0),(4764,2,881,0),(4765,10,881,0),(4766,2,882,0),(4767,10,882,0),(4768,2,883,0),(4769,10,883,0),(4770,2,884,0),(4771,10,884,0),(4772,2,885,0),(4773,10,885,0),(4774,2,886,0),(4775,10,886,0),(4776,2,887,0),(4777,10,887,0),(4778,2,888,0),(4779,10,888,0),(4780,2,889,0),(4781,10,889,0),(4782,2,890,0),(4783,10,890,0),(4784,2,891,0),(4785,10,891,0),(4786,2,892,0),(4787,10,892,0),(4788,2,893,0),(4789,10,893,0),(4790,2,894,0),(4791,10,894,0),(4792,2,895,0),(4793,10,895,0),(4794,2,896,0),(4795,10,896,0),(4796,2,897,0),(4797,10,897,0),(4798,2,898,0),(4799,10,898,0),(4800,2,899,0),(4801,10,899,0),(4802,2,900,0),(4803,10,900,0),(4804,2,901,0),(4805,10,901,0),(4806,2,902,0),(4807,10,902,0),(4808,2,903,0),(4809,10,903,0),(4810,2,904,0),(4811,10,904,0),(4812,2,905,0),(4813,10,905,0),(4814,2,906,0),(4815,10,906,0),(4816,2,907,0),(4817,10,907,0),(4818,2,908,0),(4819,10,908,0),(4820,2,909,0),(4821,10,909,0),(4822,2,910,0),(4823,10,910,0),(4824,2,911,0),(4825,10,911,0),(4826,2,912,0),(4827,10,912,0),(4828,2,913,0),(4829,10,913,0),(4830,2,914,0),(4831,10,914,0),(4832,2,915,0),(4833,10,915,0),(4834,2,916,0),(4835,10,916,0),(4836,2,917,0),(4837,10,917,0),(4838,2,918,0),(4839,10,918,0),(4840,2,919,0),(4841,10,919,0),(4842,2,920,0),(4843,10,920,0),(4844,2,921,0),(4845,10,921,0),(4846,2,922,0),(4847,10,922,0),(4848,2,923,0),(4849,10,923,0),(4850,2,924,0),(4851,10,924,0),(4852,2,925,0),(4853,10,925,0),(4854,2,926,0),(4855,10,926,0),(4856,2,927,0),(4857,10,927,0),(4858,2,928,0),(4859,10,928,0),(4860,2,929,0),(4861,10,929,0),(4862,2,930,0),(4863,10,930,0),(4864,2,931,0),(4865,10,931,0),(4866,2,932,0),(4867,10,932,0),(4868,2,933,0),(4869,10,933,0),(4870,2,934,0),(4871,10,934,0),(4872,2,935,0),(4873,10,935,0),(4874,2,936,0),(4875,10,936,0),(4876,2,937,0),(4877,10,937,0),(4878,2,938,0),(4879,10,938,0),(4880,2,939,0),(4881,10,939,0),(4882,2,940,0),(4883,10,940,0),(4884,2,941,0),(4885,10,941,0),(4886,2,942,0),(4887,10,942,0),(4888,2,943,0),(4889,10,943,0),(4890,2,944,0),(4891,10,944,0),(4892,2,945,0),(4893,10,945,0),(4894,2,946,0),(4895,10,946,0),(4896,2,947,0),(4897,10,947,0),(4898,2,948,0),(4899,10,948,0),(4900,2,949,0),(4901,10,949,0),(4902,2,950,0),(4903,10,950,0),(4904,2,951,0),(4905,10,951,0),(4906,2,952,0),(4907,10,952,0),(4908,2,953,0),(4909,10,953,0),(4910,2,954,0),(4911,10,954,0),(4912,2,955,0),(4913,10,955,0),(4914,2,956,0),(4915,10,956,0),(4916,2,957,0),(4917,10,957,0),(4918,2,958,0),(4919,10,958,0),(4920,2,959,0),(4921,10,959,0),(4922,2,960,0),(4923,10,960,0),(4924,2,961,0),(4925,10,961,0),(4926,2,962,0),(4927,10,962,0),(4928,2,963,0),(4929,10,963,0),(4930,2,964,0),(4931,10,964,0),(4932,2,965,0),(4933,10,965,0),(4934,2,966,0),(4935,10,966,0),(4936,2,967,0),(4937,10,967,0),(4938,2,968,0),(4939,10,968,0),(4940,2,969,0),(4941,10,969,0),(4942,2,970,0),(4943,10,970,0),(4944,2,971,0),(4945,10,971,0),(4946,2,972,0),(4947,10,972,0),(4948,2,973,0),(4949,10,973,0),(4950,2,974,0),(4951,10,974,0),(4952,2,975,0),(4953,10,975,0),(4954,2,976,0),(4955,10,976,0),(4956,2,977,0),(4957,10,977,0),(4958,2,978,0),(4959,10,978,0),(4960,2,979,0),(4961,10,979,0),(4962,2,980,0),(4963,10,980,0),(4964,2,981,0),(4965,10,981,0),(4966,2,982,0),(4967,10,982,0),(4968,2,983,0),(4969,10,983,0),(4970,2,984,0),(4971,10,984,0),(4972,2,985,0),(4973,10,985,0),(4974,2,986,0),(4975,10,986,0),(4976,2,987,0),(4977,10,987,0),(4978,2,988,0),(4979,10,988,0),(4980,2,989,0),(4981,10,989,0),(4982,2,990,0),(4983,10,990,0),(4984,2,991,0),(4985,10,991,0),(4986,2,992,0),(4987,10,992,0),(4988,2,993,0),(4989,10,993,0),(4990,2,994,0),(4991,10,994,0),(4992,2,995,0),(4993,10,995,0),(4994,2,996,0),(4995,10,996,0),(4996,2,997,0),(4997,10,997,0),(4998,2,998,0),(4999,10,998,0),(5000,2,999,0),(5001,10,999,0),(5002,2,1000,0),(5003,10,1000,0),(5004,2,1001,0),(5005,10,1001,0),(5006,2,1002,0),(5007,10,1002,0),(5008,2,1003,0),(5009,10,1003,0),(5010,2,1004,0),(5011,10,1004,0),(5012,2,1005,0),(5013,10,1005,0),(5014,2,1006,0),(5015,10,1006,0),(5016,2,1007,0),(5017,10,1007,0),(5018,2,1008,0),(5019,10,1008,0),(5020,2,1009,0),(5021,10,1009,0),(5022,2,1010,0),(5023,10,1010,0),(5024,2,1011,0),(5025,10,1011,0),(5026,2,1012,0),(5027,10,1012,0),(5028,2,1013,0),(5029,10,1013,0),(5030,2,1014,0),(5031,10,1014,0),(5032,2,1015,0),(5033,10,1015,0),(5034,2,1016,0),(5035,10,1016,0),(5036,2,1017,0),(5037,10,1017,0),(5038,2,1018,0),(5039,10,1018,0),(5040,2,1019,0),(5041,10,1019,0),(5042,2,1020,0),(5043,10,1020,0),(5044,2,1021,0),(5045,10,1021,0),(5046,2,1022,0),(5047,10,1022,0),(5048,2,1023,0),(5049,10,1023,0),(5050,2,1024,0),(5051,10,1024,0),(5052,2,1025,0),(5053,10,1025,0),(5054,2,1026,0),(5055,10,1026,0),(5056,2,1027,0),(5057,10,1027,0),(5058,2,1028,0),(5059,10,1028,0),(5060,2,1029,0),(5061,10,1029,0),(5062,2,1030,0),(5063,10,1030,0),(5064,2,1031,0),(5065,10,1031,0),(5066,2,1032,0),(5067,10,1032,0),(5068,2,1033,0),(5069,10,1033,0),(5070,2,1034,0),(5071,10,1034,0),(5072,2,1035,0),(5073,10,1035,0),(5074,2,1036,0),(5075,10,1036,0),(5076,2,1037,0),(5077,10,1037,0),(5078,2,1038,0),(5079,10,1038,0),(5080,2,1039,0),(5081,10,1039,0),(5082,2,1040,0),(5083,10,1040,0),(5084,2,1041,0),(5085,10,1041,0),(5086,2,1042,0),(5087,10,1042,0),(5088,2,1043,0),(5089,10,1043,0),(5090,2,1044,0),(5091,10,1044,0),(5092,2,1045,0),(5093,10,1045,0),(5094,2,1046,0),(5095,10,1046,0),(5096,2,1047,0),(5097,10,1047,0),(5098,2,1048,0),(5099,10,1048,0),(5100,2,1049,0),(5101,10,1049,0),(5102,2,1050,0),(5103,10,1050,0),(5104,2,1051,0),(5105,10,1051,0),(5106,2,1052,0),(5107,10,1052,0),(5108,2,1053,0),(5109,10,1053,0),(5110,2,1054,0),(5111,10,1054,0),(5112,2,1055,0),(5113,10,1055,0),(5114,2,1056,0),(5115,10,1056,0),(5116,2,1057,0),(5117,10,1057,0),(5118,2,1058,0),(5119,10,1058,0),(5120,2,1059,0),(5121,10,1059,0),(5122,2,1060,0),(5123,10,1060,0),(5124,2,1061,0),(5125,10,1061,0),(5126,2,1062,0),(5127,10,1062,0),(5128,2,1063,0),(5129,10,1063,0),(5130,2,1064,0),(5131,10,1064,0),(5132,2,1065,0),(5133,10,1065,0),(5134,2,1066,0),(5135,10,1066,0),(5136,2,1067,0),(5137,10,1067,0),(5138,2,1068,0),(5139,10,1068,0),(5140,2,1069,0),(5141,10,1069,0),(5142,2,1070,0),(5143,10,1070,0),(5144,2,1071,0),(5145,10,1071,0),(5146,2,1072,0),(5147,10,1072,0),(5148,2,1073,0),(5149,10,1073,0),(5150,2,1074,0),(5151,10,1074,0),(5152,2,1075,0),(5153,10,1075,0),(5154,2,1076,0),(5155,10,1076,0),(5156,2,1077,0),(5157,10,1077,0),(5158,2,1078,0),(5159,10,1078,0),(5160,2,1079,0),(5161,10,1079,0),(5162,2,1080,0),(5163,10,1080,0),(5164,2,1081,0),(5165,10,1081,0),(5166,2,1082,0),(5167,10,1082,0),(5168,2,1083,0),(5169,10,1083,0),(5170,2,1084,0),(5171,10,1084,0),(5172,2,1085,0),(5173,10,1085,0),(5174,2,1086,0),(5175,10,1086,0),(5176,2,1087,0),(5177,10,1087,0),(5178,2,1088,0),(5179,10,1088,0),(5180,2,1089,0),(5181,10,1089,0),(5182,2,1090,0),(5183,10,1090,0),(5184,2,1091,0),(5185,10,1091,0),(5186,2,1092,0),(5187,10,1092,0),(5188,2,1093,0),(5189,10,1093,0),(5190,2,1094,0),(5191,10,1094,0),(5192,2,1095,0),(5193,10,1095,0),(5194,2,1096,0),(5195,10,1096,0),(5196,2,1097,0),(5197,10,1097,0),(5198,2,1098,0),(5199,10,1098,0),(5200,2,1099,0),(5201,10,1099,0),(5202,2,1100,0),(5203,10,1100,0),(5204,2,1101,0),(5205,10,1101,0),(5206,2,1102,0),(5207,10,1102,0),(5208,2,1103,0),(5209,10,1103,0),(5210,2,1104,0),(5211,10,1104,0),(5212,2,1105,0),(5213,10,1105,0),(5214,2,1106,0),(5215,10,1106,0),(5216,2,1107,0),(5217,10,1107,0),(5218,2,1108,0),(5219,10,1108,0),(5220,2,1109,0),(5221,10,1109,0),(5222,2,1110,0),(5223,10,1110,0),(5224,2,1111,0),(5225,10,1111,0),(5226,2,1112,0),(5227,10,1112,0),(5228,2,1113,0),(5229,10,1113,0),(5230,2,1114,0),(5231,10,1114,0),(5232,2,1115,0),(5233,10,1115,0),(5234,2,1116,0),(5235,10,1116,0),(5236,2,1117,0),(5237,10,1117,0),(5238,2,1118,0),(5239,10,1118,0),(5240,2,1119,0),(5241,10,1119,0),(5242,2,1120,0),(5243,10,1120,0),(5244,2,1121,0),(5245,10,1121,0),(5246,2,1122,0),(5247,10,1122,0),(5248,2,1123,0),(5249,10,1123,0),(5250,2,1124,0),(5251,10,1124,0),(5252,2,1125,0),(5253,10,1125,0),(5254,2,1126,0),(5255,10,1126,0),(5256,2,1127,0),(5257,10,1127,0),(5258,2,1128,0),(5259,10,1128,0),(5260,2,1129,0),(5261,10,1129,0),(5262,2,1130,0),(5263,10,1130,0),(5264,2,1131,0),(5265,10,1131,0),(5266,2,1132,0),(5267,10,1132,0),(5268,2,1133,0),(5269,10,1133,0),(5270,2,1134,0),(5271,10,1134,0),(5272,2,1135,0),(5273,10,1135,0),(5274,2,1136,0),(5275,10,1136,0),(5276,2,1137,0),(5277,10,1137,0),(5278,2,1138,0),(5279,10,1138,0),(5280,2,1139,0),(5281,10,1139,0),(5282,2,1140,0),(5283,10,1140,0),(5284,2,1141,0),(5285,10,1141,0),(5286,2,1142,0),(5287,10,1142,0),(5288,2,1143,0),(5289,10,1143,0),(5290,2,1144,0),(5291,10,1144,0),(5292,2,1145,0),(5293,10,1145,0),(5294,2,1146,0),(5295,10,1146,0),(5296,2,1147,0),(5297,10,1147,0),(5298,2,1148,0),(5299,10,1148,0),(5300,2,1149,0),(5301,10,1149,0),(5302,2,1150,0),(5303,10,1150,0),(5304,2,1151,0),(5305,10,1151,0),(5306,2,1152,0),(5307,10,1152,0),(5308,2,1153,0),(5309,10,1153,0),(5310,2,1154,0),(5311,10,1154,0),(5312,2,1155,0),(5313,10,1155,0),(5314,2,1156,0),(5315,10,1156,0),(5316,2,1157,0),(5317,10,1157,0),(5318,2,1158,0),(5319,10,1158,0),(5320,2,1159,0),(5321,10,1159,0),(5322,2,1160,0),(5323,10,1160,0),(5324,2,1161,0),(5325,10,1161,0),(5326,2,1162,0),(5327,10,1162,0),(5328,2,1163,0),(5329,10,1163,0),(5330,2,1164,0),(5331,10,1164,0),(5332,2,1165,0),(5333,10,1165,0),(5334,2,1166,0),(5335,10,1166,0),(5336,2,1167,0),(5337,10,1167,0),(5338,2,1168,0),(5339,10,1168,0),(5340,2,1169,0),(5341,10,1169,0),(5342,2,1170,0),(5343,10,1170,0),(5344,2,1171,0),(5345,10,1171,0),(5346,2,1172,0),(5347,10,1172,0),(5348,2,1173,0),(5349,10,1173,0),(5350,2,1174,0),(5351,10,1174,0),(5352,2,1175,0),(5353,10,1175,0),(5354,2,1176,0),(5355,10,1176,0),(5356,2,1177,0),(5357,10,1177,0),(5358,2,1178,0),(5359,10,1178,0),(5360,2,1179,0),(5361,10,1179,0),(5362,2,1180,0),(5363,10,1180,0),(5364,2,1181,0),(5365,10,1181,0),(5366,2,1182,0),(5367,10,1182,0),(5368,2,1183,0),(5369,10,1183,0),(5370,2,1184,0),(5371,10,1184,0),(5372,2,1185,0),(5373,10,1185,0),(5374,2,1186,0),(5375,10,1186,0),(5376,2,1187,0),(5377,10,1187,0),(5378,2,1188,0),(5379,10,1188,0),(5380,2,1189,0),(5381,10,1189,0),(5382,2,1190,0),(5383,10,1190,0),(5384,2,1191,0),(5385,10,1191,0),(5386,2,1192,0),(5387,10,1192,0),(5388,2,1193,0),(5389,10,1193,0),(5390,2,1194,0),(5391,10,1194,0),(5392,2,1195,0),(5393,10,1195,0),(5394,2,1196,0),(5395,10,1196,0),(5396,2,1197,0),(5397,10,1197,0),(5398,2,1198,0),(5399,10,1198,0),(5400,2,1199,0),(5401,10,1199,0),(5402,2,1200,0),(5403,10,1200,0),(5404,2,1201,0),(5405,10,1201,0),(5406,2,1202,0),(5407,10,1202,0),(5408,2,1203,0),(5409,10,1203,0),(5410,2,1204,0),(5411,10,1204,0),(5412,2,1205,0),(5413,10,1205,0),(5414,2,1206,0),(5415,10,1206,0),(5416,2,1207,0),(5417,10,1207,0),(5418,2,1208,0),(5419,10,1208,0),(5420,2,1209,0),(5421,10,1209,0),(5422,2,1210,0),(5423,10,1210,0),(5424,2,1211,0),(5425,10,1211,0),(5426,2,1212,0),(5427,10,1212,0),(5428,2,1213,0),(5429,10,1213,0),(5430,2,1214,0),(5431,10,1214,0),(5432,2,1215,0),(5433,10,1215,0),(5434,2,1216,0),(5435,10,1216,0),(5436,2,1217,0),(5437,10,1217,0),(5438,2,1218,0),(5439,10,1218,0),(5440,2,1219,0),(5441,10,1219,0),(5442,2,1220,0),(5443,10,1220,0),(5444,2,1221,0),(5445,10,1221,0),(5446,2,1222,0),(5447,10,1222,0),(5448,2,1223,0),(5449,10,1223,0),(5450,2,1224,0),(5451,10,1224,0),(5452,2,1225,0),(5453,10,1225,0),(5454,2,1226,0),(5455,10,1226,0),(5456,2,1227,0),(5457,10,1227,0),(5458,2,1228,0),(5459,10,1228,0),(5460,2,1229,0),(5461,10,1229,0),(5462,2,1230,0),(5463,10,1230,0),(5464,2,1231,0),(5465,10,1231,0),(5466,2,1232,0),(5467,10,1232,0),(5468,2,1233,0),(5469,10,1233,0),(5470,2,1234,0),(5471,10,1234,0),(5472,2,1235,0),(5473,10,1235,0),(5474,2,1236,0),(5475,10,1236,0),(5476,2,1237,0),(5477,10,1237,0),(5478,2,1238,0),(5479,10,1238,0),(5480,2,1239,0),(5481,10,1239,0),(5482,2,1240,0),(5483,10,1240,0),(5484,2,1241,0),(5485,10,1241,0),(5486,2,1242,0),(5487,10,1242,0),(5488,2,1243,0),(5489,10,1243,0),(5490,2,1244,0),(5491,10,1244,0),(5492,2,1245,0),(5493,10,1245,0),(5494,2,1246,0),(5495,10,1246,0),(5496,2,1247,0),(5497,10,1247,0),(5498,2,1248,0),(5499,10,1248,0),(5500,2,1249,0),(5501,10,1249,0),(5502,2,1250,0),(5503,10,1250,0),(5504,2,1251,0),(5505,10,1251,0),(5506,2,1252,0),(5507,10,1252,0),(5508,2,1253,0),(5509,10,1253,0),(5510,2,1254,0),(5511,10,1254,0),(5512,2,1255,0),(5513,10,1255,0),(5514,2,1256,0),(5515,10,1256,0),(5516,2,1257,0),(5517,10,1257,0),(5518,2,1258,0),(5519,10,1258,0),(5520,2,1259,0),(5521,10,1259,0),(5522,2,1260,0),(5523,10,1260,0),(5524,2,1261,0),(5525,10,1261,0),(5526,2,1262,0),(5527,10,1262,0),(5528,2,1263,0),(5529,10,1263,0),(5530,2,1264,0),(5531,10,1264,0),(5532,2,1265,0),(5533,10,1265,0),(5534,2,1266,0),(5535,10,1266,0),(5536,2,1267,0),(5537,10,1267,0),(5538,2,1268,0),(5539,10,1268,0),(5540,2,1269,0),(5541,10,1269,0),(5542,2,1270,0),(5543,10,1270,0),(5544,2,1271,0),(5545,10,1271,0),(5546,2,1272,0),(5547,10,1272,0),(5548,2,1273,0),(5549,10,1273,0),(5550,2,1274,0),(5551,10,1274,0),(5552,2,1275,0),(5553,10,1275,0),(5554,2,1276,0),(5555,10,1276,0),(5556,2,1277,0),(5557,10,1277,0),(5558,2,1278,0),(5559,10,1278,0),(5560,2,1279,0),(5561,10,1279,0),(5562,2,1280,0),(5563,10,1280,0),(5564,2,1281,0),(5565,10,1281,0),(5566,2,1282,0),(5567,10,1282,0),(5568,2,1283,0),(5569,10,1283,0),(5570,2,1284,0),(5571,10,1284,0),(5572,2,1285,0),(5573,10,1285,0),(5574,2,1286,0),(5575,10,1286,0),(5576,2,1287,0),(5577,10,1287,0),(5578,2,1288,0),(5579,10,1288,0),(5580,2,1289,0),(5581,10,1289,0),(5582,2,1290,0),(5583,10,1290,0),(5584,2,1291,0),(5585,10,1291,0),(5586,2,1292,0),(5587,10,1292,0),(5588,2,1293,0),(5589,10,1293,0),(5590,2,1294,0),(5591,10,1294,0),(5592,2,1295,0),(5593,10,1295,0),(5594,2,1296,0),(5595,10,1296,0),(5596,2,1297,0),(5597,10,1297,0),(5598,2,1298,0),(5599,10,1298,0),(5600,2,1299,0),(5601,10,1299,0),(5602,2,1300,0),(5603,10,1300,0),(5604,2,1301,0),(5605,10,1301,0),(5606,2,1302,0),(5607,10,1302,0),(5608,2,1303,0),(5609,10,1303,0),(5610,2,1304,0),(5611,10,1304,0),(5612,2,1305,0),(5613,10,1305,0),(5614,2,1306,0),(5615,10,1306,0),(5616,2,1307,0),(5617,10,1307,0),(5618,2,1308,0),(5619,10,1308,0),(5620,2,1309,0),(5621,10,1309,0),(5622,2,1310,0),(5623,10,1310,0),(5624,2,1311,0),(5625,10,1311,0),(5626,2,1312,0),(5627,10,1312,0),(5628,2,1313,0),(5629,10,1313,0),(5630,2,1314,0),(5631,10,1314,0),(5632,2,1315,0),(5633,10,1315,0),(5634,2,1316,0),(5635,10,1316,0),(5636,2,1317,0),(5637,10,1317,0),(5638,2,1318,0),(5639,10,1318,0),(5640,2,1319,0),(5641,10,1319,0),(5642,2,1320,0),(5643,10,1320,0),(5644,2,1321,0),(5645,10,1321,0),(5646,2,1322,0),(5647,10,1322,0),(5648,2,1323,0),(5649,10,1323,0),(5650,2,1324,0),(5651,10,1324,0),(5652,2,1325,0),(5653,10,1325,0),(5654,2,1326,0),(5655,10,1326,0),(5656,2,1327,0),(5657,10,1327,0),(5658,2,1328,0),(5659,10,1328,0),(5660,2,1329,0),(5661,10,1329,0),(5662,2,1330,0),(5663,10,1330,0),(5664,2,1331,0),(5665,10,1331,0),(5666,2,1332,0),(5667,10,1332,0),(5668,2,1333,0),(5669,10,1333,0),(5670,2,1334,0),(5671,10,1334,0),(5672,2,1335,0),(5673,10,1335,0),(5674,2,1336,0),(5675,10,1336,0),(5676,2,1337,0),(5677,10,1337,0),(5678,2,1338,0),(5679,10,1338,0),(5680,2,1339,0),(5681,10,1339,0),(5682,2,1340,0),(5683,10,1340,0),(5684,2,1341,0),(5685,10,1341,0),(5686,2,1342,0),(5687,10,1342,0),(5688,2,1343,0),(5689,10,1343,0),(5690,2,1344,0),(5691,10,1344,0),(5692,2,1345,0),(5693,10,1345,0),(5694,2,1346,0),(5695,10,1346,0),(5696,2,1347,0),(5697,10,1347,0),(5698,2,1348,0),(5699,10,1348,0),(5700,2,1349,0),(5701,10,1349,0),(5702,2,1350,0),(5703,10,1350,0),(5704,2,1351,0),(5705,10,1351,0),(5706,2,1352,0),(5707,10,1352,0),(5708,2,1353,0),(5709,10,1353,0),(5710,2,1354,0),(5711,10,1354,0),(5712,2,1355,0),(5713,10,1355,0),(5714,2,1356,0),(5715,10,1356,0),(5716,2,1357,0),(5717,10,1357,0),(5718,2,1358,0),(5719,10,1358,0),(5720,2,1359,0),(5721,10,1359,0),(5722,2,1360,0),(5723,10,1360,0),(5724,2,1361,0),(5725,10,1361,0),(5726,2,1362,0),(5727,10,1362,0),(5728,2,1363,0),(5729,10,1363,0),(5730,2,1364,0),(5731,10,1364,0),(5732,2,1365,0),(5733,10,1365,0),(5734,2,1366,0),(5735,10,1366,0),(5736,2,1367,0),(5737,10,1367,0),(5738,2,1368,0),(5739,10,1368,0),(5740,2,1369,0),(5741,10,1369,0),(5742,2,1370,0),(5743,10,1370,0),(5744,2,1371,0),(5745,10,1371,0),(5746,2,1372,0),(5747,10,1372,0),(5748,2,1373,0),(5749,10,1373,0),(5750,2,1374,0),(5751,10,1374,0),(5752,2,1375,0),(5753,10,1375,0),(5754,2,1376,0),(5755,10,1376,0),(5756,2,1377,0),(5757,10,1377,0),(5758,2,1378,0),(5759,10,1378,0),(5760,2,1379,0),(5761,10,1379,0),(5762,2,1380,0),(5763,10,1380,0),(5764,2,1381,0),(5765,10,1381,0),(5766,2,1382,0),(5767,10,1382,0),(5768,2,1383,0),(5769,10,1383,0),(5770,2,1384,0),(5771,10,1384,0),(5772,2,1385,0),(5773,10,1385,0),(5774,2,1386,0),(5775,10,1386,0),(5776,2,1387,0),(5777,10,1387,0),(5778,2,1388,0),(5779,10,1388,0),(5780,2,1389,0),(5781,10,1389,0),(5782,2,1390,0),(5783,10,1390,0),(5784,2,1391,0),(5785,10,1391,0),(5786,2,1392,0),(5787,10,1392,0),(5788,2,1393,0),(5789,10,1393,0),(5790,2,1394,0),(5791,10,1394,0),(5792,2,1395,0),(5793,10,1395,0),(5794,2,1396,0),(5795,10,1396,0),(5796,2,1397,0),(5797,10,1397,0),(5798,2,1398,0),(5799,10,1398,0),(5800,2,1399,0),(5801,10,1399,0),(5802,2,1400,0),(5803,10,1400,0),(5804,2,1401,0),(5805,10,1401,0),(5806,2,1402,0),(5807,10,1402,0),(5808,2,1403,0),(5809,10,1403,0),(5810,2,1404,0),(5811,10,1404,0),(5812,2,1405,0),(5813,10,1405,0),(5814,2,1406,0),(5815,10,1406,0),(5816,2,1407,0),(5817,10,1407,0),(5818,2,1408,0),(5819,10,1408,0),(5820,2,1409,0),(5821,10,1409,0),(5822,2,1410,0),(5823,10,1410,0),(5824,2,1411,0),(5825,10,1411,0),(5826,2,1412,0),(5827,10,1412,0),(5828,2,1413,0),(5829,10,1413,0),(5830,2,1414,0),(5831,10,1414,0),(5832,2,1415,0),(5833,10,1415,0),(5834,2,1416,0),(5835,10,1416,0),(5836,2,1417,0),(5837,10,1417,0),(5838,2,1418,0),(5839,10,1418,0),(5840,2,1419,0),(5841,10,1419,0),(5842,2,1420,0),(5843,10,1420,0),(5844,2,1421,0),(5845,10,1421,0),(5846,2,1422,0),(5847,10,1422,0),(5848,2,1423,0),(5849,10,1423,0),(5850,2,1424,0),(5851,10,1424,0),(5852,2,1425,0),(5853,10,1425,0),(5854,2,1426,0),(5855,10,1426,0),(5856,2,1427,0),(5857,10,1427,0),(5858,2,1428,0),(5859,10,1428,0),(5860,2,1429,0),(5861,10,1429,0),(5862,2,1430,0),(5863,10,1430,0),(5864,2,1431,0),(5865,10,1431,0),(5866,2,1432,0),(5867,10,1432,0),(5868,2,1433,0),(5869,10,1433,0),(5870,2,1434,0),(5871,10,1434,0),(5872,2,1435,0),(5873,10,1435,0),(5874,2,1436,0),(5875,10,1436,0),(5876,2,1437,0),(5877,10,1437,0),(5878,2,1438,0),(5879,10,1438,0),(5880,2,1439,0),(5881,10,1439,0),(5882,2,1440,0),(5883,10,1440,0),(5884,2,1441,0),(5885,10,1441,0),(5886,2,1442,0),(5887,10,1442,0),(5888,2,1443,0),(5889,10,1443,0),(5890,2,1444,0),(5891,10,1444,0),(5892,2,1445,0),(5893,10,1445,0),(5894,2,1446,0),(5895,10,1446,0),(5896,2,1447,0),(5897,10,1447,0),(5898,2,1448,0),(5899,10,1448,0),(5900,2,1449,0),(5901,10,1449,0),(5902,2,1450,0),(5903,10,1450,0),(5904,2,1451,0),(5905,10,1451,0),(5906,2,1452,0),(5907,10,1452,0),(5908,2,1453,0),(5909,10,1453,0),(5910,2,1454,0),(5911,10,1454,0),(5912,2,1455,0),(5913,10,1455,0),(5914,2,1456,0),(5915,10,1456,0),(5916,2,1457,0),(5917,10,1457,0),(5918,2,1458,0),(5919,10,1458,0),(5920,2,1459,0),(5921,10,1459,0),(5922,2,1460,0),(5923,10,1460,0),(5924,2,1461,0),(5925,10,1461,0),(5926,2,1462,0),(5927,10,1462,0),(5928,2,1463,0),(5929,10,1463,0),(5930,2,1464,0),(5931,10,1464,0),(5932,2,1465,0),(5933,10,1465,0),(5934,2,1466,0),(5935,10,1466,0),(5936,2,1467,0),(5937,10,1467,0),(5938,2,1468,0),(5939,10,1468,0),(5940,2,1469,0),(5941,10,1469,0),(5942,2,1470,0),(5943,10,1470,0),(5944,2,1471,0),(5945,10,1471,0),(5946,2,1472,0),(5947,10,1472,0),(5948,2,1473,0),(5949,10,1473,0),(5950,2,1474,0),(5951,10,1474,0),(5952,2,1475,0),(5953,10,1475,0),(5954,2,1476,0),(5955,10,1476,0),(5956,2,1477,0),(5957,10,1477,0),(5958,2,1478,0),(5959,10,1478,0),(5960,2,1479,0),(5961,10,1479,0),(5962,2,1480,0),(5963,10,1480,0),(5964,2,1481,0),(5965,10,1481,0),(5966,2,1482,0),(5967,10,1482,0),(5968,2,1483,0),(5969,10,1483,0),(5970,2,1484,0),(5971,10,1484,0),(5972,2,1485,0),(5973,10,1485,0),(5974,2,1486,0),(5975,10,1486,0),(5976,2,1487,0),(5977,10,1487,0),(5978,2,1488,0),(5979,10,1488,0),(5980,2,1489,0),(5981,10,1489,0),(5982,2,1490,0),(5983,10,1490,0),(5984,2,1491,0),(5985,10,1491,0),(5986,2,1492,0),(5987,10,1492,0),(5988,2,1493,0),(5989,10,1493,0),(5990,2,1494,0),(5991,10,1494,0),(5992,2,1495,0),(5993,10,1495,0),(5994,2,1496,0),(5995,10,1496,0),(5996,2,1497,0),(5997,10,1497,0),(5998,2,1498,0),(5999,10,1498,0),(6000,2,1499,0),(6001,10,1499,0),(6002,2,1500,0),(6003,10,1500,0),(6004,2,1501,0),(6005,10,1501,0),(6006,2,1502,0),(6007,10,1502,0),(6008,2,1503,0),(6009,10,1503,0),(6010,2,1504,0),(6011,10,1504,0),(6012,2,1505,0),(6013,10,1505,0),(6014,2,1506,0),(6015,10,1506,0),(6016,2,1507,0),(6017,10,1507,0),(6018,2,1508,0),(6019,10,1508,0),(6020,2,1509,0),(6021,10,1509,0),(6022,2,1510,0),(6023,10,1510,0),(6024,2,1511,0),(6025,10,1511,0),(6026,2,1512,0),(6027,10,1512,0),(6028,2,1513,0),(6029,10,1513,0),(6030,2,1514,0),(6031,10,1514,0),(6032,2,1515,0),(6033,10,1515,0),(6034,2,1516,0),(6035,10,1516,0),(6036,2,1517,0),(6037,10,1517,0),(6038,2,1518,0),(6039,10,1518,0),(6040,2,1519,0),(6041,10,1519,0),(6042,2,1520,0),(6043,10,1520,0),(6044,2,1521,0),(6045,10,1521,0),(6046,2,1522,0),(6047,10,1522,0),(6048,2,1523,0),(6049,10,1523,0),(6050,2,1524,0),(6051,10,1524,0),(6052,2,1525,0),(6053,10,1525,0),(6054,2,1526,0),(6055,10,1526,0),(6056,2,1527,0),(6057,10,1527,0),(6058,2,1528,0),(6059,10,1528,0),(6060,2,1529,0),(6061,10,1529,0),(6062,2,1530,0),(6063,10,1530,0),(6064,2,1531,0),(6065,10,1531,0),(6066,2,1532,0),(6067,10,1532,0),(6068,2,1533,0),(6069,10,1533,0),(6070,2,1534,0),(6071,10,1534,0),(6072,2,1535,0),(6073,10,1535,0),(6074,2,1536,0),(6075,10,1536,0),(6076,2,1537,0),(6077,10,1537,0),(6078,2,1538,0),(6079,10,1538,0),(6080,2,1539,0),(6081,10,1539,0),(6082,2,1540,0),(6083,10,1540,0),(6084,2,1541,0),(6085,10,1541,0),(6086,2,1542,0),(6087,10,1542,0),(6088,2,1543,0),(6089,10,1543,0),(6090,2,1544,0),(6091,10,1544,0),(6092,2,1545,0),(6093,10,1545,0),(6094,2,1546,0),(6095,10,1546,0),(6096,2,1547,0),(6097,10,1547,0),(6098,2,1548,0),(6099,10,1548,0),(6100,2,1549,0),(6101,10,1549,0),(6102,2,1550,0),(6103,10,1550,0),(6104,2,1551,0),(6105,10,1551,0),(6106,2,1552,0),(6107,10,1552,0),(6108,2,1553,0),(6109,10,1553,0),(6110,2,1554,0),(6111,10,1554,0),(6112,2,1555,0),(6113,10,1555,0),(6114,2,1556,0),(6115,10,1556,0),(6116,2,1557,0),(6117,10,1557,0),(6118,2,1558,0),(6119,10,1558,0),(6120,2,1559,0),(6121,10,1559,0),(6122,2,1560,0),(6123,10,1560,0),(6124,2,1561,0),(6125,10,1561,0),(6126,2,1562,0),(6127,10,1562,0),(6128,2,1563,0),(6129,10,1563,0),(6130,2,1564,0),(6131,10,1564,0),(6132,2,1565,0),(6133,10,1565,0),(6134,2,1566,0),(6135,10,1566,0),(6136,2,1567,0),(6137,10,1567,0),(6138,2,1568,0),(6139,10,1568,0),(6140,2,1569,0),(6141,10,1569,0),(6142,2,1570,0),(6143,10,1570,0),(6144,2,1571,0),(6145,10,1571,0),(6146,2,1572,0),(6147,10,1572,0),(6148,2,1573,0),(6149,10,1573,0),(6150,2,1574,0),(6151,10,1574,0),(6152,2,1575,0),(6153,10,1575,0),(6154,2,1576,0),(6155,10,1576,0),(6156,2,1577,0),(6157,10,1577,0),(6158,2,1578,0),(6159,10,1578,0),(6160,2,1579,0),(6161,10,1579,0),(6162,2,1580,0),(6163,10,1580,0),(6164,2,1581,0),(6165,10,1581,0),(6166,2,1582,0),(6167,10,1582,0),(6168,2,1583,0),(6169,10,1583,0),(6170,2,1584,0),(6171,10,1584,0),(6172,2,1585,0),(6173,10,1585,0),(6174,2,1586,0),(6175,10,1586,0),(6176,2,1587,0),(6177,10,1587,0),(6178,2,1588,0),(6179,10,1588,0),(6180,2,1589,0),(6181,10,1589,0),(6182,2,1590,0),(6183,10,1590,0),(6184,2,1591,0),(6185,10,1591,0),(6186,2,1592,0),(6187,10,1592,0),(6188,2,1593,0),(6189,10,1593,0),(6190,2,1594,0),(6191,10,1594,0),(6192,2,1595,0),(6193,10,1595,0),(6194,2,1596,0),(6195,10,1596,0),(6196,2,1597,0),(6197,10,1597,0),(6198,2,1598,0),(6199,10,1598,0),(6200,2,1599,0),(6201,10,1599,0),(6202,2,1600,0),(6203,10,1600,0),(6204,2,1601,0),(6205,10,1601,0),(6206,2,1602,0),(6207,10,1602,0),(6208,2,1603,0),(6209,10,1603,0),(6210,2,1604,0),(6211,10,1604,0),(6212,2,1605,0),(6213,10,1605,0),(6214,2,1606,0),(6215,10,1606,0),(6216,2,1607,0),(6217,10,1607,0),(6218,2,1608,0),(6219,10,1608,0),(6220,2,1609,0),(6221,10,1609,0),(6222,2,1610,0),(6223,10,1610,0),(6224,2,1611,0),(6225,10,1611,0),(6226,2,1612,0),(6227,10,1612,0),(6228,2,1613,0),(6229,10,1613,0),(6230,2,1614,0),(6231,10,1614,0),(6232,2,1615,0),(6233,10,1615,0),(6234,2,1616,0),(6235,10,1616,0),(6236,2,1617,0),(6237,10,1617,0),(6238,2,1618,0),(6239,10,1618,0),(6240,2,1619,0),(6241,10,1619,0),(6242,2,1620,0),(6243,10,1620,0),(6244,2,1621,0),(6245,10,1621,0),(6246,2,1622,0),(6247,10,1622,0),(6248,2,1623,0),(6249,10,1623,0),(6250,2,1624,0),(6251,10,1624,0),(6252,2,1625,0),(6253,10,1625,0),(6254,2,1626,0),(6255,10,1626,0),(6256,2,1627,0),(6257,10,1627,0),(6258,2,1628,0),(6259,10,1628,0),(6260,2,1629,0),(6261,10,1629,0),(6262,2,1630,0),(6263,10,1630,0),(6264,2,1631,0),(6265,10,1631,0),(6266,2,1632,0),(6267,10,1632,0),(6268,2,1633,0),(6269,10,1633,0),(6270,2,1634,0),(6271,10,1634,0),(6272,2,1635,0),(6273,10,1635,0),(6274,2,1636,0),(6275,10,1636,0),(6276,2,1637,0),(6277,10,1637,0),(6278,2,1638,0),(6279,10,1638,0),(6280,2,1639,0),(6281,10,1639,0),(6282,2,1640,0),(6283,10,1640,0),(6284,2,1641,0),(6285,10,1641,0),(6286,2,1642,0),(6287,10,1642,0),(6288,2,1643,0),(6289,10,1643,0),(6290,2,1644,0),(6291,10,1644,0),(6292,2,1645,0),(6293,10,1645,0),(6294,2,1646,0),(6295,10,1646,0),(6296,2,1647,0),(6297,10,1647,0),(6298,2,1648,0),(6299,10,1648,0),(6300,2,1649,0),(6301,10,1649,0),(6302,2,1650,0),(6303,10,1650,0),(6304,2,1651,0),(6305,10,1651,0),(6306,2,1652,0),(6307,10,1652,0),(6308,2,1653,0),(6309,10,1653,0),(6310,2,1654,0),(6311,10,1654,0),(6312,2,1655,0),(6313,10,1655,0),(6314,2,1656,0),(6315,10,1656,0),(6316,2,1657,0),(6317,10,1657,0),(6318,2,1658,0),(6319,10,1658,0),(6320,2,1659,0),(6321,10,1659,0),(6322,2,1660,0),(6323,10,1660,0),(6324,2,1661,0),(6325,10,1661,0),(6326,2,1662,0),(6327,10,1662,0),(6328,2,1663,0),(6329,10,1663,0),(6330,2,1664,0),(6331,10,1664,0),(6332,2,1665,0),(6333,10,1665,0),(6334,2,1666,0),(6335,10,1666,0),(6336,2,1667,0),(6337,10,1667,0),(6338,2,1668,0),(6339,10,1668,0),(6340,2,1669,0),(6341,10,1669,0),(6342,2,1670,0),(6343,10,1670,0),(6344,2,1671,0),(6345,10,1671,0),(6346,2,1672,0),(6347,10,1672,0),(6348,2,1673,0),(6349,10,1673,0),(6350,2,1674,0),(6351,10,1674,0),(6352,2,1675,0),(6353,10,1675,0),(6354,2,1676,0),(6355,10,1676,0),(6356,2,1677,0),(6357,10,1677,0),(6358,2,1678,0),(6359,10,1678,0),(6360,2,1679,0),(6361,10,1679,0),(6362,2,1680,0),(6363,10,1680,0),(6364,2,1681,0),(6365,10,1681,0),(6366,2,1682,0),(6367,10,1682,0),(6368,2,1683,0),(6369,10,1683,0),(6370,2,1684,0),(6371,10,1684,0),(6372,2,1685,0),(6373,10,1685,0),(6374,2,1686,0),(6375,10,1686,0),(6376,2,1687,0),(6377,10,1687,0),(6378,2,1688,0),(6379,10,1688,0),(6380,2,1689,0),(6381,10,1689,0),(6382,2,1690,0),(6383,10,1690,0),(6384,2,1691,0),(6385,10,1691,0),(6386,2,1692,0),(6387,10,1692,0),(6388,2,1693,0),(6389,10,1693,0),(6390,2,1694,0),(6391,10,1694,0),(6392,2,1695,0),(6393,10,1695,0),(6394,2,1696,0),(6395,10,1696,0),(6396,2,1697,0),(6397,10,1697,0),(6398,2,1698,0),(6399,10,1698,0),(6400,2,1699,0),(6401,10,1699,0),(6402,2,1700,0),(6403,10,1700,0),(6404,2,1701,0),(6405,10,1701,0),(6406,2,1702,0),(6407,10,1702,0),(6408,2,1703,0),(6409,10,1703,0),(6410,2,1704,0),(6411,10,1704,0),(6412,2,1705,0),(6413,10,1705,0),(6414,2,1706,0),(6415,10,1706,0),(6416,2,1707,0),(6417,10,1707,0),(6418,2,1708,0),(6419,10,1708,0),(6420,2,1709,0),(6421,10,1709,0),(6422,2,1710,0),(6423,10,1710,0),(6424,2,1711,0),(6425,10,1711,0),(6426,2,1712,0),(6427,10,1712,0),(6428,2,1713,0),(6429,10,1713,0),(6430,2,1714,0),(6431,10,1714,0),(6432,2,1715,0),(6433,10,1715,0),(6434,2,1716,0),(6435,10,1716,0),(6436,2,1717,0),(6437,10,1717,0),(6438,2,1718,0),(6439,10,1718,0),(6440,2,1719,0),(6441,10,1719,0),(6442,2,1720,0),(6443,10,1720,0),(6444,2,1721,0),(6445,10,1721,0),(6446,2,1722,0),(6447,10,1722,0),(6448,2,1723,0),(6449,10,1723,0),(6450,2,1724,0),(6451,10,1724,0),(6452,2,1725,0),(6453,10,1725,0),(6454,2,1726,0),(6455,10,1726,0),(6456,2,1727,0),(6457,10,1727,0),(6458,2,1728,0),(6459,10,1728,0),(6460,2,1729,0),(6461,10,1729,0),(6462,2,1730,0),(6463,10,1730,0),(6464,2,1731,0),(6465,10,1731,0),(6466,2,1732,0),(6467,10,1732,0),(6468,2,1733,0),(6469,10,1733,0),(6470,2,1734,0),(6471,10,1734,0),(6472,2,1735,0),(6473,10,1735,0),(6474,2,1736,0),(6475,10,1736,0),(6476,2,1737,0),(6477,10,1737,0),(6478,2,1738,0),(6479,10,1738,0),(6480,2,1739,0),(6481,10,1739,0),(6482,2,1740,0),(6483,10,1740,0),(6484,2,1741,0),(6485,10,1741,0),(6486,2,1742,0),(6487,10,1742,0),(6488,2,1743,0),(6489,10,1743,0),(6490,2,1744,0),(6491,10,1744,0),(6492,2,1745,0),(6493,10,1745,0),(6494,2,1746,0),(6495,10,1746,0),(6496,2,1747,0),(6497,10,1747,0),(6498,2,1748,0),(6499,10,1748,0),(6500,2,1749,0),(6501,10,1749,0),(6502,2,1750,0),(6503,10,1750,0),(6504,2,1751,0),(6505,10,1751,0),(6506,2,1752,0),(6507,10,1752,0),(6508,2,1753,0),(6509,10,1753,0),(6510,2,1754,0),(6511,10,1754,0),(6512,2,1755,0),(6513,10,1755,0),(6514,2,1756,0),(6515,10,1756,0),(6516,2,1757,0),(6517,10,1757,0),(6518,2,1758,0),(6519,10,1758,0),(6520,2,1759,0),(6521,10,1759,0),(6522,2,1760,0),(6523,10,1760,0),(6524,2,1761,0),(6525,10,1761,0),(6526,2,1762,0),(6527,10,1762,0),(6528,2,1763,0),(6529,10,1763,0),(6530,2,1764,0),(6531,10,1764,0),(6532,2,1765,0),(6533,10,1765,0),(6534,2,1766,0),(6535,10,1766,0),(6536,2,1767,0),(6537,10,1767,0),(6538,2,1768,0),(6539,10,1768,0),(6540,2,1769,0),(6541,10,1769,0),(6542,2,1770,0),(6543,10,1770,0),(6544,2,1771,0),(6545,10,1771,0),(6546,2,1772,0),(6547,10,1772,0),(6548,2,1773,0),(6549,10,1773,0),(6550,2,1774,0),(6551,10,1774,0),(6552,2,1775,0),(6553,10,1775,0),(6554,2,1776,0),(6555,10,1776,0),(6556,2,1777,0),(6557,10,1777,0),(6558,2,1778,0),(6559,10,1778,0),(6560,2,1779,0),(6561,10,1779,0),(6562,2,1780,0),(6563,10,1780,0),(6564,2,1781,0),(6565,10,1781,0),(6566,2,1782,0),(6567,10,1782,0),(6568,2,1783,0),(6569,10,1783,0),(6570,2,1784,0),(6571,10,1784,0),(6572,2,1785,0),(6573,10,1785,0),(6574,2,1786,0),(6575,10,1786,0),(6576,2,1787,0),(6577,10,1787,0),(6578,2,1788,0),(6579,10,1788,0),(6580,2,1789,0),(6581,10,1789,0),(6582,2,1790,0),(6583,10,1790,0),(6584,2,1791,0),(6585,10,1791,0),(6586,2,1792,0),(6587,10,1792,0),(6588,2,1793,0),(6589,10,1793,0),(6590,2,1794,0),(6591,10,1794,0),(6592,2,1795,0),(6593,10,1795,0),(6594,2,1796,0),(6595,10,1796,0),(6596,2,1797,0),(6597,10,1797,0),(6598,2,1798,0),(6599,10,1798,0),(6600,2,1799,0),(6601,10,1799,0),(6602,2,1800,0),(6603,10,1800,0),(6604,2,1801,0),(6605,10,1801,0),(6606,2,1802,0),(6607,10,1802,0),(6608,2,1803,0),(6609,10,1803,0),(6610,2,1804,0),(6611,10,1804,0),(6612,2,1805,0),(6613,10,1805,0),(6614,2,1806,0),(6615,10,1806,0),(6616,2,1807,0),(6617,10,1807,0),(6618,2,1808,0),(6619,10,1808,0),(6620,2,1809,0),(6621,10,1809,0),(6622,2,1810,0),(6623,10,1810,0),(6624,2,1811,0),(6625,10,1811,0),(6626,2,1812,0),(6627,10,1812,0),(6628,2,1813,0),(6629,10,1813,0),(6630,2,1814,0),(6631,10,1814,0),(6632,2,1815,0),(6633,10,1815,0),(6634,2,1816,0),(6635,10,1816,0),(6636,2,1817,0),(6637,10,1817,0),(6638,2,1818,0),(6639,10,1818,0),(6640,2,1819,0),(6641,10,1819,0),(6642,2,1820,0),(6643,10,1820,0),(6644,2,1821,0),(6645,10,1821,0),(6646,2,1822,0),(6647,10,1822,0),(6648,2,1823,0),(6649,10,1823,0),(6650,2,1824,0),(6651,10,1824,0),(6652,2,1825,0),(6653,10,1825,0),(6654,2,1826,0),(6655,10,1826,0),(6656,2,1827,0),(6657,10,1827,0),(6658,2,1828,0),(6659,10,1828,0),(6660,2,1829,0),(6661,10,1829,0),(6662,2,1830,0),(6663,10,1830,0),(6664,2,1831,0),(6665,10,1831,0),(6666,2,1832,0),(6667,10,1832,0),(6668,2,1833,0),(6669,10,1833,0),(6670,2,1834,0),(6671,10,1834,0),(6672,2,1835,0),(6673,10,1835,0),(6674,2,1836,0),(6675,10,1836,0),(6676,2,1837,0),(6677,10,1837,0),(6678,2,1838,0),(6679,10,1838,0),(6680,2,1839,0),(6681,10,1839,0),(6682,2,1840,0),(6683,10,1840,0),(6684,2,1841,0),(6685,10,1841,0),(6686,2,1842,0),(6687,10,1842,0),(6688,2,1843,0),(6689,10,1843,0),(6690,2,1844,0),(6691,10,1844,0),(6692,2,1845,0),(6693,10,1845,0),(6694,2,1846,0),(6695,10,1846,0),(6696,2,1847,0),(6697,10,1847,0),(6698,2,1848,0),(6699,10,1848,0),(6700,2,1849,0),(6701,10,1849,0),(6702,2,1850,0),(6703,10,1850,0),(6704,2,1851,0),(6705,10,1851,0),(6706,2,1852,0),(6707,10,1852,0),(6708,2,1853,0),(6709,10,1853,0),(6710,2,1854,0),(6711,10,1854,0),(6712,2,1855,0),(6713,10,1855,0),(6714,2,1856,0),(6715,10,1856,0),(6716,2,1857,0),(6717,10,1857,0),(6718,2,1858,0),(6719,10,1858,0),(6720,2,1859,0),(6721,10,1859,0),(6722,2,1860,0),(6723,10,1860,0),(6724,2,1861,0),(6725,10,1861,0),(6726,2,1862,0),(6727,10,1862,0),(6728,2,1863,0),(6729,10,1863,0),(6730,2,1864,0),(6731,10,1864,0),(6732,2,1865,0),(6733,10,1865,0),(6734,2,1866,0),(6735,10,1866,0),(6736,2,1867,0),(6737,10,1867,0),(6738,2,1868,0),(6739,10,1868,0),(6740,2,1869,0),(6741,10,1869,0),(6742,2,1870,0),(6743,10,1870,0),(6744,2,1871,0),(6745,10,1871,0),(6746,2,1872,0),(6747,10,1872,0),(6748,2,1873,0),(6749,10,1873,0),(6750,2,1874,0),(6751,10,1874,0),(6752,2,1875,0),(6753,10,1875,0),(6754,2,1876,0),(6755,10,1876,0),(6756,2,1877,0),(6757,10,1877,0),(6758,2,1878,0),(6759,10,1878,0),(6760,2,1879,0),(6761,10,1879,0),(6762,2,1880,0),(6763,10,1880,0),(6764,2,1881,0),(6765,10,1881,0),(6766,2,1882,0),(6767,10,1882,0),(6768,2,1883,0),(6769,10,1883,0),(6770,2,1884,0),(6771,10,1884,0),(6772,2,1885,0),(6773,10,1885,0),(6774,2,1886,0),(6775,10,1886,0),(6776,2,1887,0),(6777,10,1887,0),(6778,2,1888,0),(6779,10,1888,0),(6780,2,1889,0),(6781,10,1889,0),(6782,2,1890,0),(6783,10,1890,0),(6784,2,1891,0),(6785,10,1891,0),(6786,2,1892,0),(6787,10,1892,0),(6788,2,1893,0),(6789,10,1893,0),(6790,2,1894,0),(6791,10,1894,0),(6792,2,1895,0),(6793,10,1895,0),(6794,2,1896,0),(6795,10,1896,0),(6796,2,1897,0),(6797,10,1897,0),(6798,2,1898,0),(6799,10,1898,0),(6800,2,1899,0),(6801,10,1899,0),(6802,2,1900,0),(6803,10,1900,0),(6804,2,1901,0),(6805,10,1901,0),(6806,2,1902,0),(6807,10,1902,0),(6808,2,1903,0),(6809,10,1903,0),(6810,2,1904,0),(6811,10,1904,0),(6812,2,1905,0),(6813,10,1905,0),(6814,2,1906,0),(6815,10,1906,0),(6816,2,1907,0),(6817,10,1907,0),(6818,2,1908,0),(6819,10,1908,0),(6820,2,1909,0),(6821,10,1909,0),(6822,2,1910,0),(6823,10,1910,0),(6824,2,1911,0),(6825,10,1911,0),(6826,2,1912,0),(6827,10,1912,0),(6828,2,1913,0),(6829,10,1913,0),(6830,2,1914,0),(6831,10,1914,0),(6832,2,1915,0),(6833,10,1915,0),(6834,2,1916,0),(6835,10,1916,0),(6836,2,1917,0),(6837,10,1917,0),(6838,2,1918,0),(6839,10,1918,0),(6840,2,1919,0),(6841,10,1919,0),(6842,2,1920,0),(6843,10,1920,0),(6844,2,1921,0),(6845,10,1921,0),(6846,2,1922,0),(6847,10,1922,0),(6848,2,1923,0),(6849,10,1923,0),(6850,2,1924,0),(6851,10,1924,0),(6852,2,1925,0),(6853,10,1925,0),(6854,2,1926,0),(6855,10,1926,0),(6856,2,1927,0),(6857,10,1927,0),(6858,2,1928,0),(6859,10,1928,0),(6860,2,1929,0),(6861,10,1929,0),(6862,2,1930,0),(6863,10,1930,0),(6864,2,1931,0),(6865,10,1931,0),(6866,2,1932,0),(6867,10,1932,0),(6868,2,1933,0),(6869,10,1933,0),(6870,2,1934,0),(6871,10,1934,0),(6872,2,1935,0),(6873,10,1935,0),(6874,2,1936,0),(6875,10,1936,0),(6876,2,1937,0),(6877,10,1937,0),(6878,2,1938,0),(6879,10,1938,0),(6880,2,1939,0),(6881,10,1939,0),(6882,2,1940,0),(6883,10,1940,0),(6884,2,1941,0),(6885,10,1941,0),(6886,2,1942,0),(6887,10,1942,0),(6888,2,1943,0),(6889,10,1943,0),(6890,2,1944,0),(6891,10,1944,0),(6892,2,1945,0),(6893,10,1945,0),(6894,2,1946,0),(6895,10,1946,0),(6896,2,1947,0),(6897,10,1947,0),(6898,2,1948,0),(6899,10,1948,0),(6900,2,1949,0),(6901,10,1949,0),(6902,2,1950,0),(6903,10,1950,0),(6904,2,1951,0),(6905,10,1951,0),(6906,2,1952,0),(6907,10,1952,0),(6908,2,1953,0),(6909,10,1953,0),(6910,2,1954,0),(6911,10,1954,0),(6912,2,1955,0),(6913,10,1955,0),(6914,2,1956,0),(6915,10,1956,0),(6916,2,1957,0),(6917,10,1957,0),(6918,2,1958,0),(6919,10,1958,0),(6920,2,1959,0),(6921,10,1959,0),(6922,2,1960,0),(6923,10,1960,0),(6924,2,1961,0),(6925,10,1961,0),(6926,2,1962,0),(6927,10,1962,0),(6928,2,1963,0),(6929,10,1963,0),(6930,2,1964,0),(6931,10,1964,0),(6932,2,1965,0),(6933,10,1965,0),(6934,2,1966,0),(6935,10,1966,0),(6936,2,1967,0),(6937,10,1967,0),(6938,2,1968,0),(6939,10,1968,0),(6940,2,1969,0),(6941,10,1969,0),(6942,2,1970,0),(6943,10,1970,0),(6944,2,1971,0),(6945,10,1971,0),(6946,2,1972,0),(6947,10,1972,0),(6948,2,1973,0),(6949,10,1973,0),(6950,2,1974,0),(6951,10,1974,0),(6952,2,1975,0),(6953,10,1975,0),(6954,2,1976,0),(6955,10,1976,0),(6956,2,1977,0),(6957,10,1977,0),(6958,2,1978,0),(6959,10,1978,0),(6960,2,1979,0),(6961,10,1979,0),(6962,2,1980,0),(6963,10,1980,0),(6964,2,1981,0),(6965,10,1981,0),(6966,2,1982,0),(6967,10,1982,0),(6968,2,1983,0),(6969,10,1983,0),(6970,2,1984,0),(6971,10,1984,0),(6972,2,1985,0),(6973,10,1985,0),(6974,2,1986,0),(6975,10,1986,0),(6976,2,1987,0),(6977,10,1987,0),(6978,2,1988,0),(6979,10,1988,0),(6980,2,1989,0),(6981,10,1989,0),(6982,2,1990,0),(6983,10,1990,0),(6984,2,1991,0),(6985,10,1991,0),(6986,2,1992,0),(6987,10,1992,0),(6988,2,1993,0),(6989,10,1993,0),(6990,2,1994,0),(6991,10,1994,0),(6992,2,1995,0),(6993,10,1995,0),(6994,2,1996,0),(6995,10,1996,0),(6996,2,1997,0),(6997,10,1997,0),(6998,2,1998,0),(6999,10,1998,0),(7000,2,1999,0),(7001,10,1999,0),(7002,2,2000,0),(7003,10,2000,0),(7004,2,2001,0),(7005,10,2001,0),(7006,2,2002,0),(7007,10,2002,0),(7008,2,2003,0),(7009,10,2003,0),(7010,2,2004,0),(7011,10,2004,0),(7012,2,2005,0),(7013,10,2005,0),(7014,2,2006,0),(7015,10,2006,0),(7016,2,2007,0),(7017,10,2007,0),(7018,2,2008,0),(7019,10,2008,0),(7020,2,2009,0),(7021,10,2009,0),(7022,2,2010,0),(7023,10,2010,0),(7024,2,2011,0),(7025,10,2011,0),(7026,2,2012,0),(7027,10,2012,0),(7028,2,2013,0),(7029,10,2013,0),(7030,2,2014,0),(7031,10,2014,0),(7032,2,2015,0),(7033,10,2015,0),(7034,2,2016,0),(7035,10,2016,0),(7036,2,2017,0),(7037,10,2017,0),(7038,2,2018,0),(7039,10,2018,0),(7040,2,2019,0),(7041,10,2019,0),(7042,2,2020,0),(7043,10,2020,0),(7044,2,2021,0),(7045,10,2021,0),(7046,2,2022,0),(7047,10,2022,0),(7048,2,2023,0),(7049,10,2023,0),(7050,2,2024,0),(7051,10,2024,0),(7052,2,2025,0),(7053,10,2025,0),(7054,2,2026,0),(7055,10,2026,0),(7056,2,2027,0),(7057,10,2027,0),(7058,2,2028,0),(7059,10,2028,0),(7060,2,2029,0),(7061,10,2029,0),(7062,2,2030,0),(7063,10,2030,0),(7064,2,2031,0),(7065,10,2031,0),(7066,2,2032,0),(7067,10,2032,0),(7068,2,2033,0),(7069,10,2033,0),(7070,2,2034,0),(7071,10,2034,0),(7072,2,2035,0),(7073,10,2035,0),(7074,2,2036,0),(7075,10,2036,0),(7076,2,2037,0),(7077,10,2037,0),(7078,2,2038,0),(7079,10,2038,0),(7080,2,2039,0),(7081,10,2039,0),(7082,2,2040,0),(7083,10,2040,0),(7084,2,2041,0),(7085,10,2041,0),(7086,2,2042,0),(7087,10,2042,0),(7088,2,2043,0),(7089,10,2043,0),(7090,2,2044,0),(7091,10,2044,0),(7092,2,2045,0),(7093,10,2045,0),(7094,2,2046,0),(7095,10,2046,0),(7096,2,2047,0),(7097,10,2047,0),(7098,2,2048,0),(7099,10,2048,0),(7100,2,2049,0),(7101,10,2049,0),(7102,2,2050,0),(7103,10,2050,0),(7104,2,2051,0),(7105,10,2051,0),(7106,2,2052,0),(7107,10,2052,0),(7108,2,2053,0),(7109,10,2053,0),(7110,2,2054,0),(7111,10,2054,0),(7112,2,2055,0),(7113,10,2055,0),(7114,2,2056,0),(7115,10,2056,0),(7116,2,2057,0),(7117,10,2057,0),(7118,2,2058,0),(7119,10,2058,0),(7120,2,2059,0),(7121,10,2059,0),(7122,2,2060,0),(7123,10,2060,0),(7124,2,2061,0),(7125,10,2061,0),(7126,2,2062,0),(7127,10,2062,0),(7128,2,2063,0),(7129,10,2063,0),(7130,2,2064,0),(7131,10,2064,0),(7132,2,2065,0),(7133,10,2065,0),(7134,2,2066,0),(7135,10,2066,0),(7136,2,2067,0),(7137,10,2067,0),(7138,2,2068,0),(7139,10,2068,0),(7140,2,2069,0),(7141,10,2069,0),(7142,2,2070,0),(7143,10,2070,0),(7144,2,2071,0),(7145,10,2071,0),(7146,2,2072,0),(7147,10,2072,0),(7148,2,2073,0),(7149,10,2073,0),(7150,2,2074,0),(7151,10,2074,0),(7152,2,2075,0),(7153,10,2075,0),(7154,2,2076,0),(7155,10,2076,0),(7156,2,2077,0),(7157,10,2077,0),(7158,2,2078,0),(7159,10,2078,0),(7160,2,2079,0),(7161,10,2079,0),(7162,2,2080,0),(7163,10,2080,0),(7164,2,2081,0),(7165,10,2081,0),(7166,2,2082,0),(7167,10,2082,0),(7168,2,2083,0),(7169,10,2083,0),(7170,2,2084,0),(7171,10,2084,0),(7172,2,2085,0),(7173,10,2085,0),(7174,2,2086,0),(7175,10,2086,0),(7176,2,2087,0),(7177,10,2087,0),(7178,2,2088,0),(7179,10,2088,0),(7180,2,2089,0),(7181,10,2089,0),(7182,2,2090,0),(7183,10,2090,0),(7184,2,2091,0),(7185,10,2091,0),(7186,2,2092,0),(7187,10,2092,0),(7188,2,2093,0),(7189,10,2093,0),(7190,2,2094,0),(7191,10,2094,0),(7192,2,2095,0),(7193,10,2095,0),(7194,2,2096,0),(7195,10,2096,0),(7196,2,2097,0),(7197,10,2097,0),(7198,2,2098,0),(7199,10,2098,0),(7200,2,2099,0),(7201,10,2099,0),(7202,2,2100,0),(7203,10,2100,0),(7204,2,2101,0),(7205,10,2101,0),(7206,2,2102,0),(7207,10,2102,0),(7208,2,2103,0),(7209,10,2103,0),(7210,2,2104,0),(7211,10,2104,0),(7212,2,2105,0),(7213,10,2105,0),(7214,2,2106,0),(7215,10,2106,0),(7216,2,2107,0),(7217,10,2107,0),(7218,2,2108,0),(7219,10,2108,0),(7220,2,2109,0),(7221,10,2109,0),(7222,2,2110,0),(7223,10,2110,0),(7224,2,2111,0),(7225,10,2111,0),(7226,2,2112,0),(7227,10,2112,0),(7228,2,2113,0),(7229,10,2113,0),(7230,2,2114,0),(7231,10,2114,0),(7232,2,2115,0),(7233,10,2115,0),(7234,2,2116,0),(7235,10,2116,0),(7236,2,2117,0),(7237,10,2117,0),(7238,2,2118,0),(7239,10,2118,0),(7240,2,2119,0),(7241,10,2119,0),(7242,2,2120,0),(7243,10,2120,0),(7244,2,2121,0),(7245,10,2121,0),(7246,2,2122,0),(7247,10,2122,0),(7248,2,2123,0),(7249,10,2123,0),(7250,2,2124,0),(7251,10,2124,0),(7252,2,2125,0),(7253,10,2125,0),(7254,2,2126,0),(7255,10,2126,0),(7256,2,2127,0),(7257,10,2127,0),(7258,2,2128,0),(7259,10,2128,0),(7260,2,2129,0),(7261,10,2129,0),(7262,2,2130,0),(7263,10,2130,0),(7264,2,2131,0),(7265,10,2131,0),(7266,2,2132,0),(7267,10,2132,0),(7268,2,2133,0),(7269,10,2133,0),(7270,2,2134,0),(7271,10,2134,0),(7272,2,2135,0),(7273,10,2135,0),(7274,2,2136,0),(7275,10,2136,0),(7276,2,2137,0),(7277,10,2137,0),(7278,2,2138,0),(7279,10,2138,0),(7280,2,2139,0),(7281,10,2139,0),(7282,2,2140,0),(7283,10,2140,0),(7284,2,2141,0),(7285,10,2141,0),(7286,2,2142,0),(7287,10,2142,0),(7288,2,2143,0),(7289,10,2143,0),(7290,2,2144,0),(7291,10,2144,0),(7292,2,2145,0),(7293,10,2145,0),(7294,2,2146,0),(7295,10,2146,0),(7296,2,2147,0),(7297,10,2147,0),(7298,2,2148,0),(7299,10,2148,0),(7300,2,2149,0),(7301,10,2149,0),(7302,2,2150,0),(7303,10,2150,0),(7304,2,2151,0),(7305,10,2151,0),(7306,2,2152,0),(7307,10,2152,0),(7308,2,2153,0),(7309,10,2153,0),(7310,2,2154,0),(7311,10,2154,0),(7312,2,2155,0),(7313,10,2155,0),(7314,2,2156,0),(7315,10,2156,0),(7316,2,2157,0),(7317,10,2157,0),(7318,2,2158,0),(7319,10,2158,0),(7320,2,2159,0),(7321,10,2159,0),(7322,2,2160,0),(7323,10,2160,0),(7324,2,2161,0),(7325,10,2161,0),(7326,2,2162,0),(7327,10,2162,0),(7328,2,2163,0),(7329,10,2163,0),(7330,2,2164,0),(7331,10,2164,0),(7332,2,2165,0),(7333,10,2165,0),(7334,2,2166,0),(7335,10,2166,0),(7336,2,2167,0),(7337,10,2167,0),(7338,2,2168,0),(7339,10,2168,0),(7340,2,2169,0),(7341,10,2169,0),(7342,2,2170,0),(7343,10,2170,0),(7344,2,2171,0),(7345,10,2171,0),(7346,2,2172,0),(7347,10,2172,0),(7348,2,2173,0),(7349,10,2173,0),(7350,2,2174,0),(7351,10,2174,0),(7352,2,2175,0),(7353,10,2175,0),(7354,2,2176,0),(7355,10,2176,0),(7356,2,2177,0),(7357,10,2177,0),(7358,2,2178,0),(7359,10,2178,0),(7360,2,2179,0),(7361,10,2179,0),(7362,2,2180,0),(7363,10,2180,0),(7364,2,2181,0),(7365,10,2181,0),(7366,2,2182,0),(7367,10,2182,0),(7368,2,2183,0),(7369,10,2183,0),(7370,2,2184,0),(7371,10,2184,0),(7372,2,2185,0),(7373,10,2185,0),(7374,2,2186,0),(7375,10,2186,0),(7376,2,2187,0),(7377,10,2187,0),(7378,2,2188,0),(7379,10,2188,0),(7380,2,2189,0),(7381,10,2189,0),(7382,2,2190,0),(7383,10,2190,0),(7384,2,2191,0),(7385,10,2191,0),(7386,2,2192,0),(7387,10,2192,0),(7388,2,2193,0),(7389,10,2193,0),(7390,2,2194,0),(7391,10,2194,0),(7392,2,2195,0),(7393,10,2195,0),(7394,2,2196,0),(7395,10,2196,0),(7396,2,2197,0),(7397,10,2197,0),(7398,2,2198,0),(7399,10,2198,0),(7400,2,2199,0),(7401,10,2199,0),(7402,2,2200,0),(7403,10,2200,0),(7404,2,2201,0),(7405,10,2201,0),(7406,2,2202,0),(7407,10,2202,0),(7408,2,2203,0),(7409,10,2203,0),(7410,2,2204,0),(7411,10,2204,0),(7412,2,2205,0),(7413,10,2205,0),(7414,2,2206,0),(7415,10,2206,0),(7416,2,2207,0),(7417,10,2207,0),(7418,2,2208,0),(7419,10,2208,0),(7420,2,2209,0),(7421,10,2209,0),(7422,2,2210,0),(7423,10,2210,0),(7424,2,2211,0),(7425,10,2211,0),(7426,2,2212,0),(7427,10,2212,0),(7428,2,2213,0),(7429,10,2213,0),(7430,2,2214,0),(7431,10,2214,0),(7432,2,2215,0),(7433,10,2215,0),(7434,2,2216,0),(7435,10,2216,0),(7436,2,2217,0),(7437,10,2217,0),(7438,2,2218,0),(7439,10,2218,0),(7440,2,2219,0),(7441,10,2219,0),(7442,2,2220,0),(7443,10,2220,0),(7444,2,2221,0),(7445,10,2221,0),(7446,2,2222,0),(7447,10,2222,0),(7448,2,2223,0),(7449,10,2223,0),(7450,2,2224,0),(7451,10,2224,0),(7452,2,2225,0),(7453,10,2225,0),(7454,2,2226,0),(7455,10,2226,0),(7456,2,2227,0),(7457,10,2227,0),(7458,2,2228,0),(7459,10,2228,0),(7460,2,2229,0),(7461,10,2229,0),(7462,2,2230,0),(7463,10,2230,0),(7464,2,2231,0),(7465,10,2231,0),(7466,2,2232,0),(7467,10,2232,0),(7468,2,2233,0),(7469,10,2233,0),(7470,2,2234,0),(7471,10,2234,0),(7472,2,2235,0),(7473,10,2235,0),(7474,2,2236,0),(7475,10,2236,0),(7476,2,2237,0),(7477,10,2237,0),(7478,2,2238,0),(7479,10,2238,0),(7480,2,2239,0),(7481,10,2239,0),(7482,2,2240,0),(7483,10,2240,0),(7484,2,2241,0),(7485,10,2241,0),(7486,2,2242,0),(7487,10,2242,0),(7488,2,2243,0),(7489,10,2243,0),(7490,2,2244,0),(7491,10,2244,0),(7492,2,2245,0),(7493,10,2245,0),(7494,2,2246,0),(7495,10,2246,0),(7496,2,2247,0),(7497,10,2247,0),(7498,2,2248,0),(7499,10,2248,0),(7500,2,2249,0),(7501,10,2249,0),(7502,2,2250,0),(7503,10,2250,0),(7504,2,2251,0),(7505,10,2251,0),(7506,2,2252,0),(7507,10,2252,0),(7508,2,2253,0),(7509,10,2253,0),(7510,2,2254,0),(7511,10,2254,0),(7512,2,2255,0),(7513,10,2255,0),(7514,2,2256,0),(7515,10,2256,0),(7516,2,2257,0),(7517,10,2257,0),(7518,2,2258,0),(7519,10,2258,0),(7520,2,2259,0),(7521,10,2259,0),(7522,2,2260,0),(7523,10,2260,0),(7524,2,2261,0),(7525,10,2261,0),(7526,2,2262,0),(7527,10,2262,0),(7528,2,2263,0),(7529,10,2263,0),(7530,2,2264,0),(7531,10,2264,0),(7532,2,2265,0),(7533,10,2265,0),(7534,2,2266,0),(7535,10,2266,0),(7536,2,2267,0),(7537,10,2267,0),(7538,2,2268,0),(7539,10,2268,0),(7540,2,2269,0),(7541,10,2269,0),(7542,2,2270,0),(7543,10,2270,0),(7544,2,2271,0),(7545,10,2271,0),(7546,2,2272,0),(7547,10,2272,0),(7548,2,2273,0),(7549,10,2273,0),(7550,2,2274,0),(7551,10,2274,0),(7552,2,2275,0),(7553,10,2275,0),(7554,2,2276,0),(7555,10,2276,0),(7556,2,2277,0),(7557,10,2277,0),(7558,2,2278,0),(7559,10,2278,0),(7560,2,2279,0),(7561,10,2279,0),(7562,2,2280,0),(7563,10,2280,0),(7564,2,2281,0),(7565,10,2281,0),(7566,2,2282,0),(7567,10,2282,0),(7568,2,2283,0),(7569,10,2283,0),(7570,2,2284,0),(7571,10,2284,0),(7572,2,2285,0),(7573,10,2285,0),(7574,2,2286,0),(7575,10,2286,0),(7576,2,2287,0),(7577,10,2287,0),(7578,2,2288,0),(7579,10,2288,0),(7580,2,2289,0),(7581,10,2289,0),(7582,2,2290,0),(7583,10,2290,0),(7584,2,2291,0),(7585,10,2291,0),(7586,2,2292,0),(7587,10,2292,0),(7588,2,2293,0),(7589,10,2293,0),(7590,2,2294,0),(7591,10,2294,0),(7592,2,2295,0),(7593,10,2295,0),(7594,2,2296,0),(7595,10,2296,0),(7596,2,2297,0),(7597,10,2297,0),(7598,2,2298,0),(7599,10,2298,0),(7600,2,2299,0),(7601,10,2299,0),(7602,2,2300,0),(7603,10,2300,0),(7604,2,2301,0),(7605,10,2301,0),(7606,2,2302,0),(7607,10,2302,0),(7608,2,2303,0),(7609,10,2303,0),(7610,2,2304,0),(7611,10,2304,0),(7612,2,2305,0),(7613,10,2305,0),(7614,2,2306,0),(7615,10,2306,0),(7616,2,2307,0),(7617,10,2307,0),(7618,2,2308,0),(7619,10,2308,0),(7620,2,2309,0),(7621,10,2309,0),(7622,2,2310,0),(7623,10,2310,0),(7624,2,2311,0),(7625,10,2311,0),(7626,2,2312,0),(7627,10,2312,0),(7628,2,2313,0),(7629,10,2313,0),(7630,2,2314,0),(7631,10,2314,0),(7632,2,2315,0),(7633,10,2315,0),(7634,2,2316,0),(7635,10,2316,0),(7636,2,2317,0),(7637,10,2317,0),(7638,2,2318,0),(7639,10,2318,0),(7640,2,2319,0),(7641,10,2319,0),(7642,2,2320,0),(7643,10,2320,0),(7644,2,2321,0),(7645,10,2321,0),(7646,2,2322,0),(7647,10,2322,0),(7648,2,2323,0),(7649,10,2323,0),(7650,2,2324,0),(7651,10,2324,0),(7652,2,2325,0),(7653,10,2325,0),(7654,2,2326,0),(7655,10,2326,0),(7656,2,2327,0),(7657,10,2327,0),(7658,2,2328,0),(7659,10,2328,0),(7660,2,2329,0),(7661,10,2329,0),(7662,2,2330,0),(7663,10,2330,0),(7664,2,2331,0),(7665,10,2331,0),(7666,2,2332,0),(7667,10,2332,0),(7668,2,2333,0),(7669,10,2333,0),(7670,2,2334,0),(7671,10,2334,0),(7672,2,2335,0),(7673,10,2335,0),(7674,2,2336,0),(7675,10,2336,0),(7676,2,2337,0),(7677,10,2337,0),(7678,2,2338,0),(7679,10,2338,0),(7680,2,2339,0),(7681,10,2339,0),(7682,2,2340,0),(7683,10,2340,0),(7684,2,2341,0),(7685,10,2341,0),(7686,2,2342,0),(7687,10,2342,0),(7688,2,2343,0),(7689,10,2343,0),(7690,2,2344,0),(7691,10,2344,0),(7692,2,2345,0),(7693,10,2345,0),(7694,2,2346,0),(7695,10,2346,0),(7696,2,2347,0),(7697,10,2347,0),(7698,2,2348,0),(7699,10,2348,0),(7700,2,2349,0),(7701,10,2349,0),(7702,2,2350,0),(7703,10,2350,0),(7704,2,2351,0),(7705,10,2351,0),(7706,2,2352,0),(7707,10,2352,0),(7708,2,2353,0),(7709,10,2353,0),(7710,2,2354,0),(7711,10,2354,0),(7712,2,2355,0),(7713,10,2355,0),(7714,2,2356,0),(7715,10,2356,0),(7716,2,2357,0),(7717,10,2357,0),(7718,2,2358,0),(7719,10,2358,0),(7720,2,2359,0),(7721,10,2359,0),(7722,2,2360,0),(7723,10,2360,0),(7724,2,2361,0),(7725,10,2361,0),(7726,2,2362,0),(7727,10,2362,0),(7728,2,2363,0),(7729,10,2363,0),(7730,2,2364,0),(7731,10,2364,0),(7732,2,2365,0),(7733,10,2365,0),(7734,2,2366,0),(7735,10,2366,0),(7736,2,2367,0),(7737,10,2367,0),(7738,2,2368,0),(7739,10,2368,0),(7740,2,2369,0),(7741,10,2369,0),(7742,2,2370,0),(7743,10,2370,0),(7744,2,2371,0),(7745,10,2371,0),(7746,2,2372,0),(7747,10,2372,0),(7748,2,2373,0),(7749,10,2373,0),(7750,2,2374,0),(7751,10,2374,0),(7752,2,2375,0),(7753,10,2375,0),(7754,2,2376,0),(7755,10,2376,0),(7756,2,2377,0),(7757,10,2377,0),(7758,2,2378,0),(7759,10,2378,0),(7760,2,2379,0),(7761,10,2379,0),(7762,2,2380,0),(7763,10,2380,0),(7764,2,2381,0),(7765,10,2381,0),(7766,2,2382,0),(7767,10,2382,0),(7768,2,2383,0),(7769,10,2383,0),(7770,2,2384,0),(7771,10,2384,0),(7772,2,2385,0),(7773,10,2385,0),(7774,2,2386,0),(7775,10,2386,0),(7776,2,2387,0),(7777,10,2387,0),(7778,2,2388,0),(7779,10,2388,0),(7780,2,2389,0),(7781,10,2389,0),(7782,2,2390,0),(7783,10,2390,0),(7784,2,2391,0),(7785,10,2391,0),(7786,2,2392,0),(7787,10,2392,0),(7788,2,2393,0),(7789,10,2393,0),(7790,2,2394,0),(7791,10,2394,0),(7792,2,2395,0),(7793,10,2395,0),(7794,2,2396,0),(7795,10,2396,0),(7796,2,2397,0),(7797,10,2397,0),(7798,2,2398,0),(7799,10,2398,0),(7800,2,2399,0),(7801,10,2399,0),(7802,2,2400,0),(7803,10,2400,0),(7804,2,2401,0),(7805,10,2401,0),(7806,2,2402,0),(7807,10,2402,0),(7808,2,2403,0),(7809,10,2403,0),(7810,2,2404,0),(7811,10,2404,0),(7812,2,2405,0),(7813,10,2405,0),(7814,2,2406,0),(7815,10,2406,0),(7816,2,2407,0),(7817,10,2407,0),(7818,2,2408,0),(7819,10,2408,0),(7820,2,2409,0),(7821,10,2409,0),(7822,2,2410,0),(7823,10,2410,0),(7824,2,2411,0),(7825,10,2411,0),(7826,2,2412,0),(7827,10,2412,0),(7828,2,2413,0),(7829,10,2413,0),(7830,2,2414,0),(7831,10,2414,0),(7832,2,2415,0),(7833,10,2415,0),(7834,2,2416,0),(7835,10,2416,0),(7836,2,2417,0),(7837,10,2417,0),(7838,2,2418,0),(7839,10,2418,0),(7840,2,2419,0),(7841,10,2419,0),(7842,2,2420,0),(7843,10,2420,0),(7844,2,2421,0),(7845,10,2421,0),(7846,2,2422,0),(7847,10,2422,0),(7848,2,2423,0),(7849,10,2423,0),(7850,2,2424,0),(7851,10,2424,0),(7852,2,2425,0),(7853,10,2425,0),(7854,2,2426,0),(7855,10,2426,0),(7856,2,2427,0),(7857,10,2427,0),(7858,2,2428,0),(7859,10,2428,0),(7860,2,2429,0),(7861,10,2429,0),(7862,2,2430,0),(7863,10,2430,0),(7864,2,2431,0),(7865,10,2431,0),(7866,2,2432,0),(7867,10,2432,0),(7868,2,2433,0),(7869,10,2433,0),(7870,2,2434,0),(7871,10,2434,0),(7872,2,2435,0),(7873,10,2435,0),(7874,2,2436,0),(7875,10,2436,0),(7876,2,2437,0),(7877,10,2437,0),(7878,2,2438,0),(7879,10,2438,0),(7880,2,2439,0),(7881,10,2439,0),(7882,2,2440,0),(7883,10,2440,0),(7884,2,2441,0),(7885,10,2441,0),(7886,2,2442,0),(7887,10,2442,0),(7888,2,2443,0),(7889,10,2443,0),(7890,2,2444,0),(7891,10,2444,0),(7892,2,2445,0),(7893,10,2445,0),(7894,2,2446,0),(7895,10,2446,0),(7896,2,2447,0),(7897,10,2447,0),(7898,2,2448,0),(7899,10,2448,0),(7900,2,2449,0),(7901,10,2449,0),(7902,2,2450,0),(7903,10,2450,0),(7904,2,2451,0),(7905,10,2451,0),(7906,2,2452,0),(7907,10,2452,0),(7908,2,2453,0),(7909,10,2453,0),(7910,2,2454,0),(7911,10,2454,0),(7912,2,2455,0),(7913,10,2455,0),(7914,2,2456,0),(7915,10,2456,0),(7916,2,2457,0),(7917,10,2457,0),(7918,2,2458,0),(7919,10,2458,0),(7920,2,2459,0),(7921,10,2459,0),(7922,2,2460,0),(7923,10,2460,0),(7924,2,2461,0),(7925,10,2461,0),(7926,2,2462,0),(7927,10,2462,0),(7928,2,2463,0),(7929,10,2463,0),(7930,2,2464,0),(7931,10,2464,0),(7932,2,2465,0),(7933,10,2465,0),(7934,2,2466,0),(7935,10,2466,0),(7936,2,2467,0),(7937,10,2467,0),(7938,2,2468,0),(7939,10,2468,0),(7940,2,2469,0),(7941,10,2469,0),(7942,2,2470,0),(7943,10,2470,0),(7944,2,2471,0),(7945,10,2471,0),(7946,2,2472,0),(7947,10,2472,0),(7948,2,2473,0),(7949,10,2473,0),(7950,2,2474,0),(7951,10,2474,0),(7952,2,2475,0),(7953,10,2475,0),(7954,2,2476,0),(7955,10,2476,0),(7956,2,2477,0),(7957,10,2477,0),(7958,2,2478,0),(7959,10,2478,0),(7960,2,2479,0),(7961,10,2479,0),(7962,2,2480,0),(7963,10,2480,0),(7964,2,2481,0),(7965,10,2481,0),(7966,2,2482,0),(7967,10,2482,0),(7968,2,2483,0),(7969,10,2483,0),(7970,2,2484,0),(7971,10,2484,0),(7972,2,2485,0),(7973,10,2485,0),(7974,2,2486,0),(7975,10,2486,0),(7976,2,2487,0),(7977,10,2487,0),(7978,2,2488,0),(7979,10,2488,0),(7980,2,2489,0),(7981,10,2489,0),(7982,2,2490,0),(7983,10,2490,0),(7984,2,2491,0),(7985,10,2491,0),(7986,2,2492,0),(7987,10,2492,0),(7988,2,2493,0),(7989,10,2493,0),(7990,2,2494,0),(7991,10,2494,0),(7992,2,2495,0),(7993,10,2495,0),(7994,2,2496,0),(7995,10,2496,0),(7996,2,2497,0),(7997,10,2497,0),(7998,2,2498,0),(7999,10,2498,0),(8000,2,2499,0),(8001,10,2499,0),(8002,2,2500,0),(8003,10,2500,0),(8004,2,2501,0),(8005,10,2501,0),(8006,2,2502,0),(8007,10,2502,0),(8008,2,2503,0),(8009,10,2503,0),(8010,2,2504,0),(8011,10,2504,0),(8012,2,2505,0),(8013,10,2505,0),(8014,2,2506,0),(8015,10,2506,0),(8016,2,2507,0),(8017,10,2507,0),(8018,2,2508,0),(8019,10,2508,0),(8020,2,2509,0),(8021,10,2509,0),(8022,2,2510,0),(8023,10,2510,0),(8024,2,2511,0),(8025,10,2511,0),(8026,2,2512,0),(8027,10,2512,0),(8028,2,2513,0),(8029,10,2513,0),(8030,2,2514,0),(8031,10,2514,0),(8032,2,2515,0),(8033,10,2515,0),(8034,2,2516,0),(8035,10,2516,0),(8036,2,2517,0),(8037,10,2517,0),(8038,2,2518,0),(8039,10,2518,0),(8040,2,2519,0),(8041,10,2519,0),(8042,2,2520,0),(8043,10,2520,0),(8044,2,2521,0),(8045,10,2521,0),(8046,2,2522,0),(8047,10,2522,0),(8048,2,2523,0),(8049,10,2523,0),(8050,2,2524,0),(8051,10,2524,0),(8052,2,2525,0),(8053,10,2525,0),(8054,2,2526,0),(8055,10,2526,0),(8056,2,2527,0),(8057,10,2527,0),(8058,2,2528,0),(8059,10,2528,0),(8060,2,2529,0),(8061,10,2529,0),(8062,2,2530,0),(8063,10,2530,0),(8064,2,2531,0),(8065,10,2531,0),(8066,2,2532,0),(8067,10,2532,0),(8068,2,2533,0),(8069,10,2533,0),(8070,2,2534,0),(8071,10,2534,0),(8072,2,2535,0),(8073,10,2535,0),(8074,2,2536,0),(8075,10,2536,0),(8076,2,2537,0),(8077,10,2537,0),(8078,2,2538,0),(8079,10,2538,0),(8080,2,2539,0),(8081,10,2539,0),(8082,2,2540,0),(8083,10,2540,0),(8084,2,2541,0),(8085,10,2541,0),(8086,2,2542,0),(8087,10,2542,0),(8088,2,2543,0),(8089,10,2543,0),(8090,2,2544,0),(8091,10,2544,0),(8092,2,2545,0),(8093,10,2545,0),(8094,2,2546,0),(8095,10,2546,0),(8096,2,2547,0),(8097,10,2547,0),(8098,2,2548,0),(8099,10,2548,0),(8100,2,2549,0),(8101,10,2549,0),(8102,2,2550,0),(8103,10,2550,0),(8104,2,2551,0),(8105,10,2551,0),(8106,2,2552,0),(8107,10,2552,0),(8108,2,2553,0),(8109,10,2553,0),(8110,2,2554,0),(8111,10,2554,0),(8112,2,2555,0),(8113,10,2555,0),(8114,2,2556,0),(8115,10,2556,0),(8116,2,2557,0),(8117,10,2557,0),(8118,2,2558,0),(8119,10,2558,0),(8120,2,2559,0),(8121,10,2559,0),(8122,2,2560,0),(8123,10,2560,0),(8124,2,2561,0),(8125,10,2561,0),(8126,2,2562,0),(8127,10,2562,0),(8128,2,2563,0),(8129,10,2563,0),(8130,2,2564,0),(8131,10,2564,0),(8132,2,2565,0),(8133,10,2565,0),(8134,2,2566,0),(8135,10,2566,0),(8136,2,2567,0),(8137,10,2567,0),(8138,2,2568,0),(8139,10,2568,0),(8140,2,2569,0),(8141,10,2569,0),(8142,2,2570,0),(8143,10,2570,0),(8144,2,2571,0),(8145,10,2571,0),(8146,2,2572,0),(8147,10,2572,0),(8148,2,2573,0),(8149,10,2573,0),(8150,2,2574,0),(8151,10,2574,0),(8152,2,2575,0),(8153,10,2575,0),(8154,2,2576,0),(8155,10,2576,0),(8156,2,2577,0),(8157,10,2577,0),(8158,2,2578,0),(8159,10,2578,0),(8160,2,2579,0),(8161,10,2579,0),(8162,2,2580,0),(8163,10,2580,0),(8164,2,2581,0),(8165,10,2581,0),(8166,2,2582,0),(8167,10,2582,0),(8168,2,2583,0),(8169,10,2583,0),(8170,2,2584,0),(8171,10,2584,0),(8172,2,2585,0),(8173,10,2585,0),(8174,2,2586,0),(8175,10,2586,0),(8176,2,2587,0),(8177,10,2587,0),(8178,2,2588,0),(8179,10,2588,0),(8180,2,2589,0),(8181,10,2589,0),(8182,2,2590,0),(8183,10,2590,0),(8184,2,2591,0),(8185,10,2591,0),(8186,2,2592,0),(8187,10,2592,0),(8188,2,2593,0),(8189,10,2593,0),(8190,2,2594,0),(8191,10,2594,0),(8192,2,2595,0),(8193,10,2595,0),(8194,2,2596,0),(8195,10,2596,0),(8196,2,2597,0),(8197,10,2597,0),(8198,2,2598,0),(8199,10,2598,0),(8200,2,2599,0),(8201,10,2599,0),(8202,2,2600,0),(8203,10,2600,0),(8204,2,2601,0),(8205,10,2601,0),(8206,2,2602,0),(8207,10,2602,0),(8208,2,2603,0),(8209,10,2603,0),(8210,2,2604,0),(8211,10,2604,0),(8212,2,2605,0),(8213,10,2605,0),(8214,2,2606,0),(8215,10,2606,0),(8216,2,2607,0),(8217,10,2607,0),(8218,2,2608,0),(8219,10,2608,0),(8220,2,2609,0),(8221,10,2609,0),(8222,2,2610,0),(8223,10,2610,0),(8224,2,2611,0),(8225,10,2611,0),(8226,2,2612,0),(8227,10,2612,0),(8228,2,2613,0),(8229,10,2613,0),(8230,2,2614,0),(8231,10,2614,0),(8232,2,2615,0),(8233,10,2615,0),(8234,2,2616,0),(8235,10,2616,0),(8236,2,2617,0),(8237,10,2617,0),(8238,2,2618,0),(8239,10,2618,0),(8240,2,2619,0),(8241,10,2619,0),(8242,2,2620,0),(8243,10,2620,0),(8244,2,2621,0),(8245,10,2621,0),(8246,2,2622,0),(8247,10,2622,0),(8248,2,2623,0),(8249,10,2623,0),(8250,2,2624,0),(8251,10,2624,0),(8252,2,2625,0),(8253,10,2625,0),(8254,2,2626,0),(8255,10,2626,0),(8256,2,2627,0),(8257,10,2627,0),(8258,2,2628,0),(8259,10,2628,0),(8260,2,2629,0),(8261,10,2629,0),(8262,2,2630,0),(8263,10,2630,0),(8264,2,2631,0),(8265,10,2631,0),(8266,2,2632,0),(8267,10,2632,0),(8268,2,2633,0),(8269,10,2633,0),(8270,2,2634,0),(8271,10,2634,0),(8272,2,2635,0),(8273,10,2635,0),(8274,2,2636,0),(8275,10,2636,0),(8276,2,2637,0),(8277,10,2637,0),(8278,2,2638,0),(8279,10,2638,0),(8280,2,2639,0),(8281,10,2639,0),(8282,2,2640,0),(8283,10,2640,0),(8284,2,2641,0),(8285,10,2641,0),(8286,2,2642,0),(8287,10,2642,0),(8288,2,2643,0),(8289,10,2643,0),(8290,2,2644,0),(8291,10,2644,0),(8292,2,2645,0),(8293,10,2645,0),(8294,2,2646,0),(8295,10,2646,0),(8296,2,2647,0),(8297,10,2647,0),(8298,2,2648,0),(8299,10,2648,0),(8300,2,2649,0),(8301,10,2649,0),(8302,2,2650,0),(8303,10,2650,0),(8304,2,2651,0),(8305,10,2651,0),(8306,2,2652,0),(8307,10,2652,0),(8308,2,2653,0),(8309,10,2653,0),(8310,2,2654,0),(8311,10,2654,0),(8312,2,2655,0),(8313,10,2655,0),(8314,2,2656,0),(8315,10,2656,0),(8316,2,2657,0),(8317,10,2657,0),(8318,2,2658,0),(8319,10,2658,0),(8320,2,2659,0),(8321,10,2659,0),(8322,2,2660,0),(8323,10,2660,0),(8324,2,2661,0),(8325,10,2661,0),(8326,2,2662,0),(8327,10,2662,0),(8328,2,2663,0),(8329,10,2663,0),(8330,2,2664,0),(8331,10,2664,0),(8332,2,2665,0),(8333,10,2665,0),(8334,2,2666,0),(8335,10,2666,0),(8336,2,2667,0),(8337,10,2667,0),(8338,2,2668,0),(8339,10,2668,0),(8340,2,2669,0),(8341,10,2669,0),(8342,2,2670,0),(8343,10,2670,0),(8344,2,2671,0),(8345,10,2671,0),(8346,2,2672,0),(8347,10,2672,0),(8348,2,2673,0),(8349,10,2673,0),(8350,2,2674,0),(8351,10,2674,0),(8352,2,2675,0),(8353,10,2675,0),(8354,2,2676,0),(8355,10,2676,0),(8356,2,2677,0),(8357,10,2677,0),(8358,2,2678,0),(8359,10,2678,0),(8360,2,2679,0),(8361,10,2679,0),(8362,2,2680,0),(8363,10,2680,0),(8364,2,2681,0),(8365,10,2681,0),(8366,2,2682,0),(8367,10,2682,0),(8368,2,2683,0),(8369,10,2683,0),(8370,2,2684,0),(8371,10,2684,0),(8372,2,2685,0),(8373,10,2685,0),(8374,2,2686,0),(8375,10,2686,0),(8376,2,2687,0),(8377,10,2687,0),(8378,2,2688,0),(8379,10,2688,0),(8380,2,2689,0),(8381,10,2689,0),(8382,2,2690,0),(8383,10,2690,0),(8384,2,2691,0),(8385,10,2691,0),(8386,2,2692,0),(8387,10,2692,0),(8388,2,2693,0),(8389,10,2693,0),(8390,2,2694,0),(8391,10,2694,0),(8392,2,2695,0),(8393,10,2695,0),(8394,2,2696,0),(8395,10,2696,0),(8396,2,2697,0),(8397,10,2697,0),(8398,2,2698,0),(8399,10,2698,0),(8400,2,2699,0),(8401,10,2699,0),(8402,2,2700,0),(8403,10,2700,0),(8404,2,2701,0),(8405,10,2701,0),(8406,2,2702,0),(8407,10,2702,0),(8408,2,2703,0),(8409,10,2703,0),(8410,2,2704,0),(8411,10,2704,0),(8412,2,2705,0),(8413,10,2705,0),(8414,2,2706,0),(8415,10,2706,0),(8416,2,2707,0),(8417,10,2707,0),(8418,2,2708,0),(8419,10,2708,0),(8420,2,2709,0),(8421,10,2709,0),(8422,2,2710,0),(8423,10,2710,0),(8424,2,2711,0),(8425,10,2711,0),(8426,2,2712,0),(8427,10,2712,0),(8428,2,2713,0),(8429,10,2713,0),(8430,2,2714,0),(8431,10,2714,0),(8432,2,2715,0),(8433,10,2715,0),(8434,2,2716,0),(8435,10,2716,0),(8436,2,2717,0),(8437,10,2717,0),(8438,2,2718,0),(8439,10,2718,0),(8440,2,2719,0),(8441,10,2719,0),(8442,2,2720,0),(8443,10,2720,0),(8444,2,2721,0),(8445,10,2721,0),(8446,2,2722,0),(8447,10,2722,0),(8448,2,2723,0),(8449,10,2723,0),(8450,2,2724,0),(8451,10,2724,0),(8452,2,2725,0),(8453,10,2725,0),(8454,2,2726,0),(8455,10,2726,0),(8456,2,2727,0),(8457,10,2727,0),(8458,2,2728,0),(8459,10,2728,0),(8460,2,2729,0),(8461,10,2729,0),(8462,2,2730,0),(8463,10,2730,0),(8464,2,2731,0),(8465,10,2731,0),(8466,2,2732,0),(8467,10,2732,0),(8468,2,2733,0),(8469,10,2733,0),(8470,2,2734,0),(8471,10,2734,0),(8472,2,2735,0),(8473,10,2735,0),(8474,2,2736,0),(8475,10,2736,0),(8476,2,2737,0),(8477,10,2737,0),(8478,2,2738,0),(8479,10,2738,0),(8480,2,2739,0),(8481,10,2739,0),(8482,2,2740,0),(8483,10,2740,0),(8484,2,2741,0),(8485,10,2741,0),(8486,2,2742,0),(8487,10,2742,0),(8488,2,2743,0),(8489,10,2743,0),(8490,2,2744,0),(8491,10,2744,0),(8492,2,2745,0),(8493,10,2745,0),(8494,2,2746,0),(8495,10,2746,0),(8496,2,2747,0),(8497,10,2747,0),(8498,2,2748,0),(8499,10,2748,0),(8500,2,2749,0),(8501,10,2749,0),(8502,2,2750,0),(8503,10,2750,0),(8504,2,2751,0),(8505,10,2751,0),(8506,2,2752,0),(8507,10,2752,0),(8508,2,2753,0),(8509,10,2753,0),(8510,2,2754,0),(8511,10,2754,0),(8512,2,2755,0),(8513,10,2755,0),(8514,2,2756,0),(8515,10,2756,0),(8516,2,2757,0),(8517,10,2757,0),(8518,2,2758,0),(8519,10,2758,0),(8520,2,2759,0),(8521,10,2759,0),(8522,2,2760,0),(8523,10,2760,0),(8524,2,2761,0),(8525,10,2761,0),(8526,2,2762,0),(8527,10,2762,0),(8528,2,2763,0),(8529,10,2763,0),(8530,2,2764,0),(8531,10,2764,0),(8532,2,2765,0),(8533,10,2765,0),(8534,2,2766,0),(8535,10,2766,0),(8536,2,2767,0),(8537,10,2767,0),(8538,2,2768,0),(8539,10,2768,0),(8540,2,2769,0),(8541,10,2769,0),(8542,2,2770,0),(8543,10,2770,0),(8544,2,2771,0),(8545,10,2771,0),(8546,2,2772,0),(8547,10,2772,0),(8548,2,2773,0),(8549,10,2773,0),(8550,2,2774,0),(8551,10,2774,0),(8552,2,2775,0),(8553,10,2775,0),(8554,2,2776,0),(8555,10,2776,0),(8556,2,2777,0),(8557,10,2777,0),(8558,2,2778,0),(8559,10,2778,0),(8560,2,2779,0),(8561,10,2779,0),(8562,2,2780,0),(8563,10,2780,0),(8564,2,2781,0),(8565,10,2781,0),(8566,2,2782,0),(8567,10,2782,0),(8568,2,2783,0),(8569,10,2783,0),(8570,2,2784,0),(8571,10,2784,0),(8572,2,2785,0),(8573,10,2785,0),(8574,2,2786,0),(8575,10,2786,0),(8576,2,2787,0),(8577,10,2787,0),(8578,2,2788,0),(8579,10,2788,0),(8580,2,2789,0),(8581,10,2789,0),(8582,2,2790,0),(8583,10,2790,0),(8584,2,2791,0),(8585,10,2791,0),(8586,2,2792,0),(8587,10,2792,0),(8588,2,2793,0),(8589,10,2793,0),(8590,2,2794,0),(8591,10,2794,0),(8592,2,2795,0),(8593,10,2795,0),(8594,2,2796,0),(8595,10,2796,0),(8596,2,2797,0),(8597,10,2797,0),(8598,2,2798,0),(8599,10,2798,0),(8600,2,2799,0),(8601,10,2799,0),(8602,2,2800,0),(8603,10,2800,0),(8604,2,2801,0),(8605,10,2801,0),(8606,2,2802,0),(8607,10,2802,0),(8608,2,2803,0),(8609,10,2803,0),(8610,2,2804,0),(8611,10,2804,0),(8612,2,2805,0),(8613,10,2805,0),(8614,2,2806,0),(8615,10,2806,0),(8616,2,2807,0),(8617,10,2807,0),(8618,2,2808,0),(8619,10,2808,0),(8620,2,2809,0),(8621,10,2809,0),(8622,2,2810,0),(8623,10,2810,0),(8624,2,2811,0),(8625,10,2811,0),(8626,2,2812,0),(8627,10,2812,0),(8628,2,2813,0),(8629,10,2813,0),(8630,2,2814,0),(8631,10,2814,0),(8632,2,2815,0),(8633,10,2815,0),(8634,2,2816,0),(8635,10,2816,0),(8636,2,2817,0),(8637,10,2817,0),(8638,2,2818,0),(8639,10,2818,0),(8640,2,2819,0),(8641,10,2819,0),(8642,2,2820,0),(8643,10,2820,0),(8644,2,2821,0),(8645,10,2821,0),(8646,2,2822,0),(8647,10,2822,0),(8648,2,2823,0),(8649,10,2823,0),(8650,2,2824,0),(8651,10,2824,0),(8652,2,2825,0),(8653,10,2825,0),(8654,2,2826,0),(8655,10,2826,0),(8656,2,2827,0),(8657,10,2827,0),(8658,2,2828,0),(8659,10,2828,0),(8660,2,2829,0),(8661,10,2829,0),(8662,2,2830,0),(8663,10,2830,0),(8664,2,2831,0),(8665,10,2831,0),(8666,2,2832,0),(8667,10,2832,0),(8668,2,2833,0),(8669,10,2833,0),(8670,2,2834,0),(8671,10,2834,0),(8672,2,2835,0),(8673,10,2835,0),(8674,2,2836,0),(8675,10,2836,0),(8676,2,2837,0),(8677,10,2837,0),(8678,2,2838,0),(8679,10,2838,0),(8680,2,2839,0),(8681,10,2839,0),(8682,2,2840,0),(8683,10,2840,0),(8684,2,2841,0),(8685,10,2841,0),(8686,2,2842,0),(8687,10,2842,0),(8688,2,2843,0),(8689,10,2843,0),(8690,2,2844,0),(8691,10,2844,0),(8692,2,2845,0),(8693,10,2845,0),(8694,2,2846,0),(8695,10,2846,0),(8696,2,2847,0),(8697,10,2847,0),(8698,2,2848,0),(8699,10,2848,0),(8700,2,2849,0),(8701,10,2849,0),(8702,2,2850,0),(8703,10,2850,0),(8704,2,2851,0),(8705,10,2851,0),(8706,2,2852,0),(8707,10,2852,0),(8708,2,2853,0),(8709,10,2853,0),(8710,2,2854,0),(8711,10,2854,0),(8712,2,2855,0),(8713,10,2855,0),(8714,2,2856,0),(8715,10,2856,0),(8716,2,2857,0),(8717,10,2857,0),(8718,2,2858,0),(8719,10,2858,0),(8720,2,2859,0),(8721,10,2859,0),(8722,2,2860,0),(8723,10,2860,0),(8724,2,2861,0),(8725,10,2861,0),(8726,2,2862,0),(8727,10,2862,0),(8728,2,2863,0),(8729,10,2863,0),(8730,2,2864,0),(8731,10,2864,0),(8732,2,2865,0),(8733,10,2865,0),(8734,2,2866,0),(8735,10,2866,0),(8736,2,2867,0),(8737,10,2867,0),(8738,2,2868,0),(8739,10,2868,0),(8740,2,2869,0),(8741,10,2869,0),(8742,2,2870,0),(8743,10,2870,0),(8744,2,2871,0),(8745,10,2871,0),(8746,2,2872,0),(8747,10,2872,0),(8748,2,2873,0),(8749,10,2873,0),(8750,2,2874,0),(8751,10,2874,0),(8752,2,2875,0),(8753,10,2875,0),(8754,2,2876,0),(8755,10,2876,0),(8756,2,2877,0),(8757,10,2877,0),(8758,2,2878,0),(8759,10,2878,0),(8760,2,2879,0),(8761,10,2879,0),(8762,2,2880,0),(8763,10,2880,0),(8764,2,2881,0),(8765,10,2881,0),(8766,2,2882,0),(8767,10,2882,0),(8768,2,2883,0),(8769,10,2883,0),(8770,2,2884,0),(8771,10,2884,0),(8772,2,2885,0),(8773,10,2885,0),(8774,2,2886,0),(8775,10,2886,0),(8776,2,2887,0),(8777,10,2887,0),(8778,2,2888,0),(8779,10,2888,0),(8780,2,2889,0),(8781,10,2889,0),(8782,2,2890,0),(8783,10,2890,0),(8784,2,2891,0),(8785,10,2891,0),(8786,2,2892,0),(8787,10,2892,0),(8788,2,2893,0),(8789,10,2893,0),(8790,2,2894,0),(8791,10,2894,0),(8792,2,2895,0),(8793,10,2895,0),(8794,2,2896,0),(8795,10,2896,0),(8796,2,2897,0),(8797,10,2897,0),(8798,2,2898,0),(8799,10,2898,0),(8800,2,2899,0),(8801,10,2899,0),(8802,2,2900,0),(8803,10,2900,0),(8804,2,2901,0),(8805,10,2901,0),(8806,2,2902,0),(8807,10,2902,0),(8808,2,2903,0),(8809,10,2903,0),(8810,2,2904,0),(8811,10,2904,0),(8812,2,2905,0),(8813,10,2905,0),(8814,2,2906,0),(8815,10,2906,0),(8816,2,2907,0),(8817,10,2907,0),(8818,2,2908,0),(8819,10,2908,0),(8820,2,2909,0),(8821,10,2909,0),(8822,2,2910,0),(8823,10,2910,0),(8824,2,2911,0),(8825,10,2911,0),(8826,2,2912,0),(8827,10,2912,0),(8828,2,2913,0),(8829,10,2913,0),(8830,2,2914,0),(8831,10,2914,0),(8832,2,2915,0),(8833,10,2915,0),(8834,2,2916,0),(8835,10,2916,0),(8836,2,2917,0),(8837,10,2917,0),(8838,2,2918,0),(8839,10,2918,0),(8840,2,2919,0),(8841,10,2919,0),(8842,2,2920,0),(8843,10,2920,0),(8844,2,2921,0),(8845,10,2921,0),(8846,2,2922,0),(8847,10,2922,0),(8848,2,2923,0),(8849,10,2923,0),(8850,2,2924,0),(8851,10,2924,0),(8852,2,2925,0),(8853,10,2925,0),(8854,2,2926,0),(8855,10,2926,0),(8856,2,2927,0),(8857,10,2927,0),(8858,2,2928,0),(8859,10,2928,0),(8860,2,2929,0),(8861,10,2929,0),(8862,2,2930,0),(8863,10,2930,0),(8864,2,2931,0),(8865,10,2931,0),(8866,2,2932,0),(8867,10,2932,0),(8868,2,2933,0),(8869,10,2933,0),(8870,2,2934,0),(8871,10,2934,0),(8872,2,2935,0),(8873,10,2935,0),(8874,2,2936,0),(8875,10,2936,0),(8876,2,2937,0),(8877,10,2937,0),(8878,2,2938,0),(8879,10,2938,0),(8880,2,2939,0),(8881,10,2939,0),(8882,2,2940,0),(8883,10,2940,0),(8884,2,2941,0),(8885,10,2941,0),(8886,2,2942,0),(8887,10,2942,0),(8888,2,2943,0),(8889,10,2943,0),(8890,2,2944,0),(8891,10,2944,0),(8892,2,2945,0),(8893,10,2945,0),(8894,2,2946,0),(8895,10,2946,0),(8896,2,2947,0),(8897,10,2947,0),(8898,2,2948,0),(8899,10,2948,0),(8900,2,2949,0),(8901,10,2949,0),(8902,2,2950,0),(8903,10,2950,0),(8904,2,2951,0),(8905,10,2951,0),(8906,2,2952,0),(8907,10,2952,0),(8908,2,2953,0),(8909,10,2953,0),(8910,2,2954,0),(8911,10,2954,0),(8912,2,2955,0),(8913,10,2955,0),(8914,2,2956,0),(8915,10,2956,0),(8916,2,2957,0),(8917,10,2957,0),(8918,2,2958,0),(8919,10,2958,0),(8920,2,2959,0),(8921,10,2959,0),(8922,2,2960,0),(8923,10,2960,0),(8924,2,2961,0),(8925,10,2961,0),(8926,2,2962,0),(8927,10,2962,0),(8928,2,2963,0),(8929,10,2963,0),(8930,2,2964,0),(8931,10,2964,0),(8932,2,2965,0),(8933,10,2965,0),(8934,2,2966,0),(8935,10,2966,0),(8936,2,2967,0),(8937,10,2967,0),(8938,2,2968,0),(8939,10,2968,0),(8940,2,2969,0),(8941,10,2969,0),(8942,2,2970,0),(8943,10,2970,0),(8944,2,2971,0),(8945,10,2971,0),(8946,2,2972,0),(8947,10,2972,0),(8948,2,2973,0),(8949,10,2973,0),(8950,2,2974,0),(8951,10,2974,0),(8952,2,2975,0),(8953,10,2975,0),(8954,2,2976,0),(8955,10,2976,0),(8956,2,2977,0),(8957,10,2977,0),(8958,2,2978,0),(8959,10,2978,0),(8960,2,2979,0),(8961,10,2979,0),(8962,2,2980,0),(8963,10,2980,0),(8964,2,2981,0),(8965,10,2981,0),(8966,2,2982,0),(8967,10,2982,0),(8968,2,2983,0),(8969,10,2983,0),(8970,2,2984,0),(8971,10,2984,0),(8972,2,2985,0),(8973,10,2985,0),(8974,2,2986,0),(8975,10,2986,0),(8976,2,2987,0),(8977,10,2987,0),(8978,2,2988,0),(8979,10,2988,0),(8980,2,2989,0),(8981,10,2989,0),(8982,2,2990,0),(8983,10,2990,0),(8984,2,2991,0),(8985,10,2991,0),(8986,2,2992,0),(8987,10,2992,0),(8988,2,2993,0),(8989,10,2993,0),(8990,2,2994,0),(8991,10,2994,0),(8992,2,2995,0),(8993,10,2995,0),(8994,2,2996,0),(8995,10,2996,0),(8996,2,2997,0),(8997,10,2997,0),(8998,2,2998,0),(8999,10,2998,0),(9000,2,2999,0),(9001,10,2999,0),(9002,2,3000,0),(9003,10,3000,0),(9004,2,3001,0),(9005,10,3001,0),(9006,2,3002,0),(9007,10,3002,0),(9008,2,3003,0),(9009,10,3003,0),(9010,2,3004,0),(9011,10,3004,0),(9012,2,3005,0),(9013,10,3005,0),(9014,2,3006,0),(9015,10,3006,0),(9016,2,3007,0),(9017,10,3007,0),(9018,2,3008,0),(9019,10,3008,0),(9020,2,3009,0),(9021,10,3009,0),(9022,2,3010,0),(9023,10,3010,0),(9024,2,3011,0),(9025,10,3011,0),(9026,2,3012,0),(9027,10,3012,0),(9028,2,3013,0),(9029,10,3013,0),(9030,2,3014,0),(9031,10,3014,0),(9032,2,3015,0),(9033,10,3015,0),(9034,2,3016,0),(9035,10,3016,0),(9036,2,3017,0),(9037,10,3017,0),(9038,2,3018,0),(9039,10,3018,0),(9040,2,3019,0),(9041,10,3019,0),(9042,2,3020,0),(9043,10,3020,0),(9044,2,3021,0),(9045,10,3021,0),(9046,2,3022,0),(9047,10,3022,0),(9048,2,3023,0),(9049,10,3023,0),(9050,2,3024,0),(9051,10,3024,0),(9052,2,3025,0),(9053,10,3025,0),(9054,2,3026,0),(9055,10,3026,0),(9056,2,3027,0),(9057,10,3027,0),(9058,2,3028,0),(9059,10,3028,0),(9060,2,3029,0),(9061,10,3029,0),(9062,2,3030,0),(9063,10,3030,0),(9064,2,3031,0),(9065,10,3031,0),(9066,2,3032,0),(9067,10,3032,0),(9068,2,3033,0),(9069,10,3033,0),(9070,2,3034,0),(9071,10,3034,0),(9072,2,3035,0),(9073,10,3035,0),(9074,2,3036,0),(9075,10,3036,0),(9076,2,3037,0),(9077,10,3037,0),(9078,2,3038,0),(9079,10,3038,0),(9080,2,3039,0),(9081,10,3039,0),(9082,2,3040,0),(9083,10,3040,0),(9084,2,3041,0),(9085,10,3041,0),(9086,2,3042,0),(9087,10,3042,0),(9088,2,3043,0),(9089,10,3043,0),(9090,2,3044,0),(9091,10,3044,0),(9092,2,3045,0),(9093,10,3045,0),(9094,2,3046,0),(9095,10,3046,0),(9096,2,3047,0),(9097,10,3047,0),(9098,2,3048,0),(9099,10,3048,0),(9100,2,3049,0),(9101,10,3049,0),(9102,2,3050,0),(9103,10,3050,0),(9104,2,3051,0),(9105,10,3051,0),(9106,2,3052,0),(9107,10,3052,0),(9108,2,3053,0),(9109,10,3053,0),(9110,2,3054,0),(9111,10,3054,0),(9112,2,3055,0),(9113,10,3055,0),(9114,2,3056,0),(9115,10,3056,0),(9116,2,3057,0),(9117,10,3057,0),(9118,2,3058,0),(9119,10,3058,0),(9120,2,3059,0),(9121,10,3059,0),(9122,2,3060,0),(9123,10,3060,0),(9124,2,3061,0),(9125,10,3061,0),(9126,2,3062,0),(9127,10,3062,0),(9128,2,3063,0),(9129,10,3063,0),(9130,2,3064,0),(9131,10,3064,0),(9132,2,3065,0),(9133,10,3065,0),(9134,2,3066,0),(9135,10,3066,0),(9136,2,3067,0),(9137,10,3067,0),(9138,2,3068,0),(9139,10,3068,0),(9140,2,3069,0),(9141,10,3069,0),(9142,2,3070,0),(9143,10,3070,0),(9144,2,3071,0),(9145,10,3071,0),(9146,2,3072,0),(9147,10,3072,0),(9148,2,3073,0),(9149,10,3073,0),(9150,2,3074,0),(9151,10,3074,0),(9152,2,3075,0),(9153,10,3075,0),(9154,2,3076,0),(9155,10,3076,0),(9156,2,3077,0),(9157,10,3077,0),(9158,2,3078,0),(9159,10,3078,0),(9160,2,3079,0),(9161,10,3079,0),(9162,2,3080,0),(9163,10,3080,0),(9164,2,3081,0),(9165,10,3081,0),(9166,2,3082,0),(9167,10,3082,0),(9168,2,3083,0),(9169,10,3083,0),(9170,2,3084,0),(9171,10,3084,0),(9172,2,3085,0),(9173,10,3085,0),(9174,2,3086,0),(9175,10,3086,0),(9176,2,3087,0),(9177,10,3087,0),(9178,2,3088,0),(9179,10,3088,0),(9180,2,3089,0),(9181,10,3089,0),(9182,2,3090,0),(9183,10,3090,0),(9184,2,3091,0),(9185,10,3091,0),(9186,2,3092,0),(9187,10,3092,0),(9188,2,3093,0),(9189,10,3093,0),(9190,2,3094,0),(9191,10,3094,0),(9192,2,3095,0),(9193,10,3095,0),(9194,2,3096,0),(9195,10,3096,0),(9196,2,3097,0),(9197,10,3097,0),(9198,2,3098,0),(9199,10,3098,0),(9200,2,3099,0),(9201,10,3099,0),(9202,2,3100,0),(9203,10,3100,0),(9204,2,3101,0),(9205,10,3101,0),(9206,2,3102,0),(9207,10,3102,0),(9208,2,3103,0),(9209,10,3103,0),(9210,2,3104,0),(9211,10,3104,0),(9212,2,3105,0),(9213,10,3105,0),(9214,2,3106,0),(9215,10,3106,0),(9216,2,3107,0),(9217,10,3107,0),(9218,2,3108,0),(9219,10,3108,0),(9220,2,3109,0),(9221,10,3109,0),(9222,2,3110,0),(9223,10,3110,0),(9224,2,3111,0),(9225,10,3111,0),(9226,2,3112,0),(9227,10,3112,0),(9228,2,3113,0),(9229,10,3113,0),(9230,2,3114,0),(9231,10,3114,0),(9232,2,3115,0),(9233,10,3115,0),(9234,2,3116,0),(9235,10,3116,0),(9236,2,3117,0),(9237,10,3117,0),(9238,2,3118,0),(9239,10,3118,0),(9240,2,3119,0),(9241,10,3119,0),(9242,2,3120,0),(9243,10,3120,0),(9244,2,3121,0),(9245,10,3121,0),(9246,2,3122,0),(9247,10,3122,0),(9248,2,3123,0),(9249,10,3123,0),(9250,2,3124,0),(9251,10,3124,0),(9252,2,3125,0),(9253,10,3125,0),(9254,2,3126,0),(9255,10,3126,0),(9256,2,3127,0),(9257,10,3127,0),(9258,2,3128,0),(9259,10,3128,0),(9260,2,3129,0),(9261,10,3129,0),(9262,2,3130,0),(9263,10,3130,0),(9264,2,3131,0),(9265,10,3131,0),(9266,2,3132,0),(9267,10,3132,0),(9268,2,3133,0),(9269,10,3133,0),(9270,2,3134,0),(9271,10,3134,0),(9272,2,3135,0),(9273,10,3135,0),(9274,2,3136,0),(9275,10,3136,0),(9276,2,3137,0),(9277,10,3137,0),(9278,2,3138,0),(9279,10,3138,0),(9280,2,3139,0),(9281,10,3139,0),(9282,2,3140,0),(9283,10,3140,0),(9284,2,3141,0),(9285,10,3141,0),(9286,2,3142,0),(9287,10,3142,0),(9288,2,3143,0),(9289,10,3143,0),(9290,2,3144,0),(9291,10,3144,0),(9292,2,3145,0),(9293,10,3145,0),(9294,2,3146,0),(9295,10,3146,0),(9296,2,3147,0),(9297,10,3147,0),(9298,2,3148,0),(9299,10,3148,0),(9300,2,3149,0),(9301,10,3149,0),(9302,2,3150,0),(9303,10,3150,0),(9304,2,3151,0),(9305,10,3151,0),(9306,2,3152,0),(9307,10,3152,0),(9308,2,3153,0),(9309,10,3153,0),(9310,2,3154,0),(9311,10,3154,0),(9312,2,3155,0),(9313,10,3155,0),(9314,2,3156,0),(9315,10,3156,0),(9316,2,3157,0),(9317,10,3157,0),(9318,2,3158,0),(9319,10,3158,0),(9320,2,3159,0),(9321,10,3159,0),(9322,2,3160,0),(9323,10,3160,0),(9324,2,3161,0),(9325,10,3161,0),(9326,2,3162,0),(9327,10,3162,0),(9328,2,3163,0),(9329,10,3163,0),(9330,2,3164,0),(9331,10,3164,0),(9332,2,3165,0),(9333,10,3165,0),(9334,2,3166,0),(9335,10,3166,0),(9336,2,3167,0),(9337,10,3167,0),(9338,2,3168,0),(9339,10,3168,0),(9340,2,3169,0),(9341,10,3169,0),(9342,2,3170,0),(9343,10,3170,0),(9344,2,3171,0),(9345,10,3171,0),(9346,2,3172,0),(9347,10,3172,0),(9348,2,3173,0),(9349,10,3173,0),(9350,2,3174,0),(9351,10,3174,0),(9352,2,3175,0),(9353,10,3175,0),(9354,2,3176,0),(9355,10,3176,0),(9356,2,3177,0),(9357,10,3177,0),(9358,2,3178,0),(9359,10,3178,0),(9360,2,3179,0),(9361,10,3179,0),(9362,2,3180,0),(9363,10,3180,0),(9364,2,3181,0),(9365,10,3181,0),(9366,2,3182,0),(9367,10,3182,0),(9368,2,3183,0),(9369,10,3183,0),(9370,2,3184,0),(9371,10,3184,0),(9372,2,3185,0),(9373,10,3185,0),(9374,2,3186,0),(9375,10,3186,0),(9376,2,3187,0),(9377,10,3187,0),(9378,2,3188,0),(9379,10,3188,0),(9380,2,3189,0),(9381,10,3189,0),(9382,2,3190,0),(9383,10,3190,0),(9384,2,3191,0),(9385,10,3191,0),(9386,2,3192,0),(9387,10,3192,0),(9388,2,3193,0),(9389,10,3193,0),(9390,2,3194,0),(9391,10,3194,0),(9392,2,3195,0),(9393,10,3195,0),(9394,2,3196,0),(9395,10,3196,0),(9396,2,3197,0),(9397,10,3197,0),(9398,2,3198,0),(9399,10,3198,0),(9400,2,3199,0),(9401,10,3199,0),(9402,2,3200,0),(9403,10,3200,0),(9404,2,3201,0),(9405,10,3201,0),(9406,2,3202,0),(9407,10,3202,0),(9408,2,3203,0),(9409,10,3203,0),(9410,2,3204,0),(9411,10,3204,0),(9412,2,3205,0),(9413,10,3205,0),(9414,2,3206,0),(9415,10,3206,0),(9416,2,3207,0),(9417,10,3207,0),(9418,2,3208,0),(9419,10,3208,0),(9420,2,3209,0),(9421,10,3209,0),(9422,2,3210,0),(9423,10,3210,0),(9424,2,3211,0),(9425,10,3211,0),(9426,2,3212,0),(9427,10,3212,0),(9428,2,3213,0),(9429,10,3213,0),(9430,2,3214,0),(9431,10,3214,0),(9432,2,3215,0),(9433,10,3215,0),(9434,2,3216,0),(9435,10,3216,0),(9436,2,3217,0),(9437,10,3217,0),(9438,2,3218,0),(9439,10,3218,0),(9440,2,3219,0),(9441,10,3219,0),(9442,2,3220,0),(9443,10,3220,0),(9444,2,3221,0),(9445,10,3221,0),(9446,2,3222,0),(9447,10,3222,0),(9448,2,3223,0),(9449,10,3223,0),(9450,2,3224,0),(9451,10,3224,0),(9452,2,3225,0),(9453,10,3225,0),(9454,2,3226,0),(9455,10,3226,0),(9456,2,3227,0),(9457,10,3227,0),(9458,2,3228,0),(9459,10,3228,0),(9460,2,3229,0),(9461,10,3229,0),(9462,2,3230,0),(9463,10,3230,0),(9464,2,3231,0),(9465,10,3231,0),(9466,2,3232,0),(9467,10,3232,0),(9468,2,3233,0),(9469,10,3233,0),(9470,2,3234,0),(9471,10,3234,0),(9472,2,3235,0),(9473,10,3235,0),(9474,2,3236,0),(9475,10,3236,0),(9476,2,3237,0),(9477,10,3237,0),(9478,2,3238,0),(9479,10,3238,0),(9480,2,3239,0),(9481,10,3239,0),(9482,2,3240,0),(9483,10,3240,0),(9484,2,3241,0),(9485,10,3241,0),(9486,2,3242,0),(9487,10,3242,0),(9488,2,3243,0),(9489,10,3243,0),(9490,2,3244,0),(9491,10,3244,0),(9492,2,3245,0),(9493,10,3245,0),(9494,2,3246,0),(9495,10,3246,0),(9496,2,3247,0),(9497,10,3247,0),(9498,2,3248,0),(9499,10,3248,0),(9500,2,3249,0),(9501,10,3249,0),(9502,2,3250,0),(9503,10,3250,0),(9504,2,3251,0),(9505,10,3251,0),(9506,2,3252,0),(9507,10,3252,0),(9508,2,3253,0),(9509,10,3253,0),(9510,2,3254,0),(9511,10,3254,0),(9512,2,3255,0),(9513,10,3255,0),(9514,2,3256,0),(9515,10,3256,0),(9516,2,3257,0),(9517,10,3257,0),(9518,2,3258,0),(9519,10,3258,0),(9520,2,3259,0),(9521,10,3259,0),(9522,2,3260,0),(9523,10,3260,0),(9524,2,3261,0),(9525,10,3261,0),(9526,2,3262,0),(9527,10,3262,0),(9528,2,3263,0),(9529,10,3263,0),(9530,2,3264,0),(9531,10,3264,0),(9532,2,3265,0),(9533,10,3265,0),(9534,2,3266,0),(9535,10,3266,0),(9536,2,3267,0),(9537,10,3267,0),(9538,2,3268,0),(9539,10,3268,0),(9540,2,3269,0),(9541,10,3269,0),(9542,2,3270,0),(9543,10,3270,0),(9544,2,3271,0),(9545,10,3271,0),(9546,2,3272,0),(9547,10,3272,0),(9548,2,3273,0),(9549,10,3273,0),(9550,2,3274,0),(9551,10,3274,0),(9552,2,3275,0),(9553,10,3275,0),(9554,2,3276,0),(9555,10,3276,0),(9556,2,3277,0),(9557,10,3277,0),(9558,2,3278,0),(9559,10,3278,0),(9560,2,3279,0),(9561,10,3279,0),(9562,2,3280,0),(9563,10,3280,0),(9564,2,3281,0),(9565,10,3281,0),(9566,2,3282,0),(9567,10,3282,0),(9568,2,3283,0),(9569,10,3283,0),(9570,2,3284,0),(9571,10,3284,0),(9572,2,3285,0),(9573,10,3285,0),(9574,2,3286,0),(9575,10,3286,0),(9576,2,3287,0),(9577,10,3287,0),(9578,2,3288,0),(9579,10,3288,0),(9580,2,3289,0),(9581,10,3289,0),(9582,2,3290,0),(9583,10,3290,0),(9584,2,3291,0),(9585,10,3291,0),(9586,2,3292,0),(9587,10,3292,0),(9588,2,3293,0),(9589,10,3293,0),(9590,2,3294,0),(9591,10,3294,0),(9592,2,3295,0),(9593,10,3295,0),(9594,2,3296,0),(9595,10,3296,0),(9596,2,3297,0),(9597,10,3297,0),(9598,2,3298,0),(9599,10,3298,0),(9600,2,3299,0),(9601,10,3299,0),(9602,2,3300,0),(9603,10,3300,0),(9604,2,3301,0),(9605,10,3301,0),(9606,2,3302,0),(9607,10,3302,0),(9608,2,3303,0),(9609,10,3303,0),(9610,2,3304,0),(9611,10,3304,0),(9612,2,3305,0),(9613,10,3305,0),(9614,2,3306,0),(9615,10,3306,0),(9616,2,3307,0),(9617,10,3307,0),(9618,2,3308,0),(9619,10,3308,0),(9620,2,3309,0),(9621,10,3309,0),(9622,2,3310,0),(9623,10,3310,0),(9624,2,3311,0),(9625,10,3311,0),(9626,2,3312,0),(9627,10,3312,0),(9628,2,3313,0),(9629,10,3313,0),(9630,2,3314,0),(9631,10,3314,0),(9632,2,3315,0),(9633,10,3315,0),(9634,2,3316,0),(9635,10,3316,0),(9636,2,3317,0),(9637,10,3317,0),(9638,2,3318,0),(9639,10,3318,0),(9640,2,3319,0),(9641,10,3319,0),(9642,2,3320,0),(9643,10,3320,0),(9644,2,3321,0),(9645,10,3321,0),(9646,2,3322,0),(9647,10,3322,0),(9648,2,3323,0),(9649,10,3323,0),(9650,2,3324,0),(9651,10,3324,0),(9652,2,3325,0),(9653,10,3325,0),(9654,2,3326,0),(9655,10,3326,0),(9656,2,3327,0),(9657,10,3327,0),(9658,2,3328,0),(9659,10,3328,0),(9660,2,3329,0),(9661,10,3329,0),(9662,2,3330,0),(9663,10,3330,0),(9664,2,3331,0),(9665,10,3331,0),(9666,2,3332,0),(9667,10,3332,0),(9668,2,3333,0),(9669,10,3333,0),(9670,2,3334,0),(9671,10,3334,0),(9672,2,3335,0),(9673,10,3335,0),(9674,2,3336,0),(9675,10,3336,0),(9676,2,3337,0),(9677,10,3337,0),(9678,2,3338,0),(9679,10,3338,0),(9680,2,3339,0),(9681,10,3339,0),(9682,2,3340,0),(9683,10,3340,0),(9684,2,3341,0),(9685,10,3341,0),(9686,2,3342,0),(9687,10,3342,0),(9688,2,3343,0),(9689,10,3343,0),(9690,2,3344,0),(9691,10,3344,0),(9692,2,3345,0),(9693,10,3345,0),(9694,2,3346,0),(9695,10,3346,0),(9696,2,3347,0),(9697,10,3347,0),(9698,2,3348,0),(9699,10,3348,0),(9700,2,3349,0),(9701,10,3349,0),(9702,2,3350,0),(9703,10,3350,0),(9704,2,3351,0),(9705,10,3351,0),(9706,2,3352,0),(9707,10,3352,0),(9708,2,3353,0),(9709,10,3353,0),(9710,2,3354,0),(9711,10,3354,0),(9712,2,3355,0),(9713,10,3355,0),(9714,2,3356,0),(9715,10,3356,0),(9716,2,3357,0),(9717,10,3357,0),(9718,2,3358,0),(9719,10,3358,0),(9720,2,3359,0),(9721,10,3359,0),(9722,2,3360,0),(9723,10,3360,0),(9724,2,3361,0),(9725,10,3361,0),(9726,2,3362,0),(9727,10,3362,0),(9728,2,3363,0),(9729,10,3363,0),(9730,2,3364,0),(9731,10,3364,0),(9732,2,3365,0),(9733,10,3365,0),(9734,2,3366,0),(9735,10,3366,0),(9736,2,3367,0),(9737,10,3367,0),(9738,2,3368,0),(9739,10,3368,0),(9740,2,3369,0),(9741,10,3369,0),(9742,2,3370,0),(9743,10,3370,0),(9744,2,3371,0),(9745,10,3371,0),(9746,2,3372,0),(9747,10,3372,0),(9748,2,3373,0),(9749,10,3373,0),(9750,2,3374,0),(9751,10,3374,0),(9752,2,3375,0),(9753,10,3375,0),(9754,2,3376,0),(9755,10,3376,0),(9756,2,3377,0),(9757,10,3377,0),(9758,2,3378,0),(9759,10,3378,0),(9760,2,3379,0),(9761,10,3379,0),(9762,2,3380,0),(9763,10,3380,0),(9764,2,3381,0),(9765,10,3381,0),(9766,2,3382,0),(9767,10,3382,0),(9768,2,3383,0),(9769,10,3383,0),(9770,2,3384,0),(9771,10,3384,0),(9772,2,3385,0),(9773,10,3385,0),(9774,2,3386,0),(9775,10,3386,0),(9776,2,3387,0),(9777,10,3387,0),(9778,2,3388,0),(9779,10,3388,0),(9780,2,3389,0),(9781,10,3389,0),(9782,2,3390,0),(9783,10,3390,0),(9784,2,3391,0),(9785,10,3391,0),(9786,2,3392,0),(9787,10,3392,0),(9788,2,3393,0),(9789,10,3393,0),(9790,2,3394,0),(9791,10,3394,0),(9792,2,3395,0),(9793,10,3395,0),(9794,2,3396,0),(9795,10,3396,0),(9796,2,3397,0),(9797,10,3397,0),(9798,2,3398,0),(9799,10,3398,0),(9800,2,3399,0),(9801,10,3399,0),(9802,2,3400,0),(9803,10,3400,0),(9804,2,3401,0),(9805,10,3401,0),(9806,2,3402,0),(9807,10,3402,0),(9808,2,3403,0),(9809,10,3403,0),(9810,2,3404,0),(9811,10,3404,0),(9812,2,3405,0),(9813,10,3405,0),(9814,2,3406,0),(9815,10,3406,0),(9816,2,3407,0),(9817,10,3407,0),(9818,2,3408,0),(9819,10,3408,0),(9820,2,3409,0),(9821,10,3409,0),(9822,2,3410,0),(9823,10,3410,0),(9824,2,3411,0),(9825,10,3411,0),(9826,2,3412,0),(9827,10,3412,0),(9828,2,3413,0),(9829,10,3413,0),(9830,2,3414,0),(9831,10,3414,0),(9832,2,3415,0),(9833,10,3415,0),(9834,2,3416,0),(9835,10,3416,0),(9836,2,3417,0),(9837,10,3417,0),(9838,2,3418,0),(9839,10,3418,0),(9840,2,3419,0),(9841,10,3419,0),(9842,2,3420,0),(9843,10,3420,0),(9844,2,3421,0),(9845,10,3421,0),(9846,2,3422,0),(9847,10,3422,0),(9848,2,3423,0),(9849,10,3423,0),(9850,2,3424,0),(9851,10,3424,0),(9852,2,3425,0),(9853,10,3425,0),(9854,2,3426,0),(9855,10,3426,0),(9856,2,3427,0),(9857,10,3427,0),(9858,2,3428,0),(9859,10,3428,0),(9860,2,3429,0),(9861,10,3429,0),(9862,2,3430,0),(9863,10,3430,0),(9864,2,3431,0),(9865,10,3431,0),(9866,2,3432,0),(9867,10,3432,0),(9868,2,3433,0),(9869,10,3433,0),(9870,2,3434,0),(9871,10,3434,0),(9872,2,3435,0),(9873,10,3435,0),(9874,2,3436,0),(9875,10,3436,0),(9876,2,3437,0),(9877,10,3437,0),(9878,2,3438,0),(9879,10,3438,0),(9880,2,3439,0),(9881,10,3439,0),(9882,2,3440,0),(9883,10,3440,0),(9884,2,3441,0),(9885,10,3441,0),(9886,2,3442,0),(9887,10,3442,0),(9888,2,3443,0),(9889,10,3443,0),(9890,2,3444,0),(9891,10,3444,0),(9892,2,3445,0),(9893,10,3445,0),(9894,2,3446,0),(9895,10,3446,0),(9896,2,3447,0),(9897,10,3447,0),(9898,2,3448,0),(9899,10,3448,0),(9900,2,3449,0),(9901,10,3449,0),(9902,2,3450,0),(9903,10,3450,0),(9904,2,3451,0),(9905,10,3451,0),(9906,2,3452,0),(9907,10,3452,0),(9908,2,3453,0),(9909,10,3453,0),(9910,2,3454,0),(9911,10,3454,0),(9912,2,3455,0),(9913,10,3455,0),(9914,2,3456,0),(9915,10,3456,0),(9916,2,3457,0),(9917,10,3457,0),(9918,2,3458,0),(9919,10,3458,0),(9920,2,3459,0),(9921,10,3459,0),(9922,2,3460,0),(9923,10,3460,0),(9924,2,3461,0),(9925,10,3461,0),(9926,2,3462,0),(9927,10,3462,0),(9928,2,3463,0),(9929,10,3463,0),(9930,2,3464,0),(9931,10,3464,0),(9932,2,3465,0),(9933,10,3465,0),(9934,2,3466,0),(9935,10,3466,0),(9936,2,3467,0),(9937,10,3467,0),(9938,2,3468,0),(9939,10,3468,0),(9940,2,3469,0),(9941,10,3469,0),(9942,2,3470,0),(9943,10,3470,0),(9944,2,3471,0),(9945,10,3471,0),(9946,2,3472,0),(9947,10,3472,0),(9948,2,3473,0),(9949,10,3473,0),(9950,2,3474,0),(9951,10,3474,0),(9952,2,3475,0),(9953,10,3475,0),(9954,2,3476,0),(9955,10,3476,0),(9956,2,3477,0),(9957,10,3477,0),(9958,2,3478,0),(9959,10,3478,0),(9960,2,3479,0),(9961,10,3479,0),(9962,2,3480,0),(9963,10,3480,0),(9964,2,3481,0),(9965,10,3481,0),(9966,2,3482,0),(9967,10,3482,0),(9968,2,3483,0),(9969,10,3483,0),(9970,2,3484,0),(9971,10,3484,0),(9972,2,3485,0),(9973,10,3485,0),(9974,2,3486,0),(9975,10,3486,0),(9976,2,3487,0),(9977,10,3487,0),(9978,2,3488,0),(9979,10,3488,0),(9980,2,3489,0),(9981,10,3489,0),(9982,2,3490,0),(9983,10,3490,0),(9984,2,3491,0),(9985,10,3491,0),(9986,2,3492,0),(9987,10,3492,0),(9988,2,3493,0),(9989,10,3493,0),(9990,2,3494,0),(9991,10,3494,0),(9992,2,3495,0),(9993,10,3495,0),(9994,2,3496,0),(9995,10,3496,0),(9996,2,3497,0),(9997,10,3497,0),(9998,2,3498,0),(9999,10,3498,0),(10000,2,3499,0),(10001,10,3499,0),(10002,2,3500,0),(10003,10,3500,0),(10004,2,3501,0),(10005,10,3501,0),(10006,2,3502,0),(10007,10,3502,0),(10008,2,3503,0),(10009,10,3503,0),(10010,2,3504,0),(10011,10,3504,0),(10012,2,3505,0),(10013,10,3505,0),(10014,2,3506,0),(10015,10,3506,0),(10016,2,3507,0),(10017,10,3507,0),(10018,2,3508,0),(10019,10,3508,0),(10020,2,3509,0),(10021,10,3509,0),(10022,2,3510,0),(10023,10,3510,0),(10024,2,3511,0),(10025,10,3511,0),(10026,2,3512,0),(10027,10,3512,0),(10028,2,3513,0),(10029,10,3513,0),(10030,2,3514,0),(10031,10,3514,0),(10032,2,3515,0),(10033,10,3515,0),(10034,2,3516,0),(10035,10,3516,0),(10036,2,3517,0),(10037,10,3517,0),(10038,2,3518,0),(10039,10,3518,0),(10040,2,3519,0),(10041,10,3519,0),(10042,2,3520,0),(10043,10,3520,0),(10044,2,3521,0),(10045,10,3521,0),(10046,2,3522,0),(10047,10,3522,0),(10048,2,3523,0),(10049,10,3523,0),(10050,2,3524,0),(10051,10,3524,0),(10052,2,3525,0),(10053,10,3525,0),(10054,2,3526,0),(10055,10,3526,0),(10056,2,3527,0),(10057,10,3527,0),(10058,2,3528,0),(10059,10,3528,0),(10060,2,3529,0),(10061,10,3529,0),(10062,2,3530,0),(10063,10,3530,0),(10064,2,3531,0),(10065,10,3531,0),(10066,2,3532,0),(10067,10,3532,0),(10068,2,3533,0),(10069,10,3533,0),(10070,2,3534,0),(10071,10,3534,0),(10072,2,3535,0),(10073,10,3535,0),(10074,2,3536,0),(10075,10,3536,0),(10076,2,3537,0),(10077,10,3537,0),(10078,2,3538,0),(10079,10,3538,0),(10080,2,3539,0),(10081,10,3539,0),(10082,2,3540,0),(10083,10,3540,0),(10084,2,3541,0),(10085,10,3541,0),(10086,2,3542,0),(10087,10,3542,0),(10088,2,3543,0),(10089,10,3543,0),(10090,2,3544,0),(10091,10,3544,0),(10092,2,3545,0),(10093,10,3545,0),(10094,2,3546,0),(10095,10,3546,0),(10096,2,3547,0),(10097,10,3547,0),(10098,2,3548,0),(10099,10,3548,0),(10100,2,3549,0),(10101,10,3549,0),(10102,2,3550,0),(10103,10,3550,0),(10104,2,3551,0),(10105,10,3551,0),(10106,2,3552,0),(10107,10,3552,0),(10108,2,3553,0),(10109,10,3553,0),(10110,2,3554,0),(10111,10,3554,0),(10112,2,3555,0),(10113,10,3555,0),(10114,2,3556,0),(10115,10,3556,0),(10116,2,3557,0),(10117,10,3557,0),(10118,2,3558,0),(10119,10,3558,0),(10120,2,3559,0),(10121,10,3559,0),(10122,2,3560,0),(10123,10,3560,0),(10124,2,3561,0),(10125,10,3561,0),(10126,2,3562,0),(10127,10,3562,0),(10128,2,3563,0),(10129,10,3563,0),(10130,2,3564,0),(10131,10,3564,0),(10132,2,3565,0),(10133,10,3565,0),(10134,2,3566,0),(10135,10,3566,0),(10136,2,3567,0),(10137,10,3567,0),(10138,2,3568,0),(10139,10,3568,0),(10140,2,3569,0),(10141,10,3569,0),(10142,2,3570,0),(10143,10,3570,0),(10144,2,3571,0),(10145,10,3571,0),(10146,2,3572,0),(10147,10,3572,0),(10148,2,3573,0),(10149,10,3573,0),(10150,2,3574,0),(10151,10,3574,0),(10152,2,3575,0),(10153,10,3575,0),(10154,2,3576,0),(10155,10,3576,0),(10156,2,3577,0),(10157,10,3577,0),(10158,2,3578,0),(10159,10,3578,0),(10160,2,3579,0),(10161,10,3579,0),(10162,2,3580,0),(10163,10,3580,0),(10164,2,3581,0),(10165,10,3581,0),(10166,2,3582,0),(10167,10,3582,0),(10168,2,3583,0),(10169,10,3583,0),(10170,2,3584,0),(10171,10,3584,0),(10172,2,3585,0),(10173,10,3585,0),(10174,2,3586,0),(10175,10,3586,0),(10176,2,3587,0),(10177,10,3587,0),(10178,2,3588,0),(10179,10,3588,0),(10180,2,3589,0),(10181,10,3589,0),(10182,2,3590,0),(10183,10,3590,0),(10184,2,3591,0),(10185,10,3591,0),(10186,2,3592,0),(10187,10,3592,0),(10188,2,3593,0),(10189,10,3593,0),(10190,2,3594,0),(10191,10,3594,0),(10192,2,3595,0),(10193,10,3595,0),(10194,2,3596,0),(10195,10,3596,0),(10196,2,3597,0),(10197,10,3597,0),(10198,2,3598,0),(10199,10,3598,0),(10200,2,3599,0),(10201,10,3599,0),(10202,2,3600,0),(10203,10,3600,0),(10204,2,3601,0),(10205,10,3601,0),(10206,2,3602,0),(10207,10,3602,0),(10208,2,3603,0),(10209,10,3603,0),(10210,2,3604,0),(10211,10,3604,0),(10212,2,3605,0),(10213,10,3605,0),(10214,2,3606,0),(10215,10,3606,0),(10216,2,3607,0),(10217,10,3607,0),(10218,2,3608,0),(10219,10,3608,0),(10220,2,3609,0),(10221,10,3609,0),(10222,2,3610,0),(10223,10,3610,0),(10224,2,3611,0),(10225,10,3611,0),(10226,2,3612,0),(10227,10,3612,0),(10228,2,3613,0),(10229,10,3613,0),(10230,2,3614,0),(10231,10,3614,0),(10232,2,3615,0),(10233,10,3615,0),(10234,2,3616,0),(10235,10,3616,0),(10236,2,3617,0),(10237,10,3617,0),(10238,2,3618,0),(10239,10,3618,0),(10240,2,3619,0),(10241,10,3619,0),(10242,2,3620,0),(10243,10,3620,0),(10244,2,3621,0),(10245,10,3621,0),(10246,2,3622,0),(10247,10,3622,0),(10248,2,3623,0),(10249,10,3623,0),(10250,2,3624,0),(10251,10,3624,0),(10252,2,3625,0),(10253,10,3625,0),(10254,2,3626,0),(10255,10,3626,0),(10256,2,3627,0),(10257,10,3627,0),(10258,2,3628,0),(10259,10,3628,0),(10260,2,3629,0),(10261,10,3629,0),(10262,2,3630,0),(10263,10,3630,0),(10264,2,3631,0),(10265,10,3631,0),(10266,2,3632,0),(10267,10,3632,0),(10268,2,3633,0),(10269,10,3633,0),(10270,2,3634,0),(10271,10,3634,0),(10272,2,3635,0),(10273,10,3635,0),(10274,2,3636,0),(10275,10,3636,0),(10276,2,3637,0),(10277,10,3637,0),(10278,2,3638,0),(10279,10,3638,0),(10280,2,3639,0),(10281,10,3639,0),(10282,2,3640,0),(10283,10,3640,0),(10284,2,3641,0),(10285,10,3641,0),(10286,2,3642,0),(10287,10,3642,0),(10288,2,3643,0),(10289,10,3643,0),(10290,2,3644,0),(10291,10,3644,0),(10292,2,3645,0),(10293,10,3645,0),(10294,2,3646,0),(10295,10,3646,0),(10296,2,3647,0),(10297,10,3647,0),(10298,2,3648,0),(10299,10,3648,0),(10300,2,3649,0),(10301,10,3649,0),(10302,2,3650,0),(10303,10,3650,0),(10304,2,3651,0),(10305,10,3651,0),(10306,2,3652,0),(10307,10,3652,0),(10308,2,3653,0),(10309,10,3653,0),(10310,2,3654,0),(10311,10,3654,0),(10312,2,3655,0),(10313,10,3655,0),(10314,2,3656,0),(10315,10,3656,0),(10316,2,3657,0),(10317,10,3657,0),(10318,2,3658,0),(10319,10,3658,0),(10320,2,3659,0),(10321,10,3659,0),(10322,2,3660,0),(10323,10,3660,0),(10324,2,3661,0),(10325,10,3661,0),(10326,2,3662,0),(10327,10,3662,0),(10328,2,3663,0),(10329,10,3663,0),(10330,2,3664,0),(10331,10,3664,0),(10332,2,3665,0),(10333,10,3665,0),(10334,2,3666,0),(10335,10,3666,0),(10336,2,3667,0),(10337,10,3667,0),(10338,2,3668,0),(10339,10,3668,0),(10340,2,3669,0),(10341,10,3669,0),(10342,2,3670,0),(10343,10,3670,0),(10344,2,3671,0),(10345,10,3671,0),(10346,2,3672,0),(10347,10,3672,0),(10348,2,3673,0),(10349,10,3673,0),(10350,2,3674,0),(10351,10,3674,0),(10352,2,3675,0),(10353,10,3675,0),(10354,2,3676,0),(10355,10,3676,0),(10356,2,3677,0),(10357,10,3677,0),(10358,2,3678,0),(10359,10,3678,0),(10360,2,3679,0),(10361,10,3679,0),(10362,2,3680,0),(10363,10,3680,0),(10364,2,3681,0),(10365,10,3681,0),(10366,2,3682,0),(10367,10,3682,0),(10368,2,3683,0),(10369,10,3683,0),(10370,2,3684,0),(10371,10,3684,0),(10372,2,3685,0),(10373,10,3685,0),(10374,2,3686,0),(10375,10,3686,0),(10376,2,3687,0),(10377,10,3687,0),(10378,2,3688,0),(10379,10,3688,0),(10380,2,3689,0),(10381,10,3689,0),(10382,2,3690,0),(10383,10,3690,0),(10384,2,3691,0),(10385,10,3691,0),(10386,2,3692,0),(10387,10,3692,0),(10388,2,3693,0),(10389,10,3693,0),(10390,2,3694,0),(10391,10,3694,0),(10392,2,3695,0),(10393,10,3695,0),(10394,2,3696,0),(10395,10,3696,0),(10396,2,3697,0),(10397,10,3697,0),(10398,2,3698,0),(10399,10,3698,0),(10400,2,3699,0),(10401,10,3699,0),(10402,2,3700,0),(10403,10,3700,0),(10404,2,3701,0),(10405,10,3701,0),(10406,2,3702,0),(10407,10,3702,0),(10408,2,3703,0),(10409,10,3703,0),(10410,2,3704,0),(10411,10,3704,0),(10412,2,3705,0),(10413,10,3705,0),(10414,2,3706,0),(10415,10,3706,0),(10416,2,3707,0),(10417,10,3707,0),(10418,2,3708,0),(10419,10,3708,0),(10420,2,3709,0),(10421,10,3709,0),(10422,2,3710,0),(10423,10,3710,0),(10424,2,3711,0),(10425,10,3711,0),(10426,2,3712,0),(10427,10,3712,0),(10428,2,3713,0),(10429,10,3713,0),(10430,2,3714,0),(10431,10,3714,0),(10432,2,3715,0),(10433,10,3715,0),(10434,2,3716,0),(10435,10,3716,0),(10436,2,3717,0),(10437,10,3717,0),(10438,2,3718,0),(10439,10,3718,0),(10440,2,3719,0),(10441,10,3719,0),(10442,2,3720,0),(10443,10,3720,0),(10444,2,3721,0),(10445,10,3721,0),(10446,2,3722,0),(10447,10,3722,0),(10448,2,3723,0),(10449,10,3723,0),(10450,2,3724,0),(10451,10,3724,0),(10452,2,3725,0),(10453,10,3725,0),(10454,2,3726,0),(10455,10,3726,0),(10456,2,3727,0),(10457,10,3727,0),(10458,2,3728,0),(10459,10,3728,0),(10460,2,3729,0),(10461,10,3729,0),(10462,2,3730,0),(10463,10,3730,0),(10464,2,3731,0),(10465,10,3731,0),(10466,2,3732,0),(10467,10,3732,0),(10468,2,3733,0),(10469,10,3733,0),(10470,2,3734,0),(10471,10,3734,0),(10472,2,3735,0),(10473,10,3735,0),(10474,2,3736,0),(10475,10,3736,0),(10476,2,3737,0),(10477,10,3737,0),(10478,2,3738,0),(10479,10,3738,0),(10480,2,3739,0),(10481,10,3739,0),(10482,2,3740,0),(10483,10,3740,0),(10484,2,3741,0),(10485,10,3741,0),(10486,2,3742,0),(10487,10,3742,0),(10488,2,3743,0),(10489,10,3743,0),(10490,2,3744,0),(10491,10,3744,0),(10492,2,3745,0),(10493,10,3745,0),(10494,2,3746,0),(10495,10,3746,0),(10496,2,3747,0),(10497,10,3747,0),(10498,2,3748,0),(10499,10,3748,0),(10500,2,3749,0),(10501,10,3749,0),(10502,2,3750,0),(10503,10,3750,0),(10504,2,3751,0),(10505,10,3751,0),(10506,2,3752,0),(10507,10,3752,0),(10508,2,3753,0),(10509,10,3753,0),(10510,2,3754,0),(10511,10,3754,0),(10512,2,3755,0),(10513,10,3755,0),(10514,2,3756,0),(10515,10,3756,0),(10516,2,3757,0),(10517,10,3757,0),(10518,2,3758,0),(10519,10,3758,0),(10520,2,3759,0),(10521,10,3759,0),(10522,2,3760,0),(10523,10,3760,0),(10524,2,3761,0),(10525,10,3761,0),(10526,2,3762,0),(10527,10,3762,0),(10528,2,3763,0),(10529,10,3763,0),(10530,2,3764,0),(10531,10,3764,0),(10532,2,3765,0),(10533,10,3765,0),(10534,2,3766,0),(10535,10,3766,0),(10536,2,3767,0),(10537,10,3767,0),(10538,2,3768,0),(10539,10,3768,0),(10540,2,3769,0),(10541,10,3769,0),(10542,2,3770,0),(10543,10,3770,0),(10544,2,3771,0),(10545,10,3771,0),(10546,2,3772,0),(10547,10,3772,0),(10548,2,3773,0),(10549,10,3773,0),(10550,2,3774,0),(10551,10,3774,0),(10552,2,3775,0),(10553,10,3775,0),(10554,2,3776,0),(10555,10,3776,0),(10556,2,3777,0),(10557,10,3777,0),(10558,2,3778,0),(10559,10,3778,0),(10560,2,3779,0),(10561,10,3779,0),(10562,2,3780,0),(10563,10,3780,0),(10564,2,3781,0),(10565,10,3781,0),(10566,2,3782,0),(10567,10,3782,0),(10568,2,3783,0),(10569,10,3783,0),(10570,2,3784,0),(10571,10,3784,0),(10572,2,3785,0),(10573,10,3785,0),(10574,2,3786,0),(10575,10,3786,0),(10576,2,3787,0),(10577,10,3787,0),(10578,2,3788,0),(10579,10,3788,0),(10580,2,3789,0),(10581,10,3789,0),(10582,2,3790,0),(10583,10,3790,0),(10584,2,3791,0),(10585,10,3791,0),(10586,2,3792,0),(10587,10,3792,0),(10588,2,3793,0),(10589,10,3793,0),(10590,2,3794,0),(10591,10,3794,0),(10592,2,3795,0),(10593,10,3795,0),(10594,2,3796,0),(10595,10,3796,0),(10596,2,3797,0),(10597,10,3797,0),(10598,2,3798,0),(10599,10,3798,0),(10600,2,3799,0),(10601,10,3799,0),(10602,2,3800,0),(10603,10,3800,0),(10604,2,3801,0),(10605,10,3801,0),(10606,2,3802,0),(10607,10,3802,0),(10608,2,3803,0),(10609,10,3803,0),(10610,2,3804,0),(10611,10,3804,0),(10612,2,3805,0),(10613,10,3805,0),(10614,2,3806,0),(10615,10,3806,0),(10616,2,3807,0),(10617,10,3807,0),(10618,2,3808,0),(10619,10,3808,0),(10620,2,3809,0),(10621,10,3809,0),(10622,2,3810,0),(10623,10,3810,0),(10624,2,3811,0),(10625,10,3811,0),(10626,2,3812,0),(10627,10,3812,0),(10628,2,3813,0),(10629,10,3813,0),(10630,2,3814,0),(10631,10,3814,0),(10632,2,3815,0),(10633,10,3815,0),(10634,2,3816,0),(10635,10,3816,0),(10636,2,3817,0),(10637,10,3817,0),(10638,2,3818,0),(10639,10,3818,0),(10640,2,3819,0),(10641,10,3819,0),(10642,2,3820,0),(10643,10,3820,0),(10644,2,3821,0),(10645,10,3821,0),(10646,2,3822,0),(10647,10,3822,0),(10648,2,3823,0),(10649,10,3823,0),(10650,2,3824,0),(10651,10,3824,0),(10652,2,3825,0),(10653,10,3825,0),(10654,2,3826,0),(10655,10,3826,0),(10656,2,3827,0),(10657,10,3827,0),(10658,2,3828,0),(10659,10,3828,0),(10660,2,3829,0),(10661,10,3829,0),(10662,2,3830,0),(10663,10,3830,0),(10664,2,3831,0),(10665,10,3831,0),(10666,2,3832,0),(10667,10,3832,0),(10668,2,3833,0),(10669,10,3833,0),(10670,2,3834,0),(10671,10,3834,0),(10672,2,3835,0),(10673,10,3835,0),(10674,2,3836,0),(10675,10,3836,0),(10676,2,3837,0),(10677,10,3837,0),(10678,2,3838,0),(10679,10,3838,0),(10680,2,3839,0),(10681,10,3839,0),(10682,2,3840,0),(10683,10,3840,0),(10684,2,3841,0),(10685,10,3841,0),(10686,2,3842,0),(10687,10,3842,0),(10688,2,3843,0),(10689,10,3843,0),(10690,2,3844,0),(10691,10,3844,0),(10692,2,3845,0),(10693,10,3845,0),(10694,2,3846,0),(10695,10,3846,0),(10696,2,3847,0),(10697,10,3847,0),(10698,2,3848,0),(10699,10,3848,0),(10700,2,3849,0),(10701,10,3849,0),(10702,2,3850,0),(10703,10,3850,0),(10704,2,3851,0),(10705,10,3851,0),(10706,2,3852,0),(10707,10,3852,0),(10708,2,3853,0),(10709,10,3853,0),(10710,2,3854,0),(10711,10,3854,0),(10712,2,3855,0),(10713,10,3855,0),(10714,2,3856,0),(10715,10,3856,0),(10716,2,3857,0),(10717,10,3857,0),(10718,2,3858,0),(10719,10,3858,0),(10720,2,3859,0),(10721,10,3859,0),(10722,2,3860,0),(10723,10,3860,0),(10724,2,3861,0),(10725,10,3861,0),(10726,2,3862,0),(10727,10,3862,0),(10728,2,3863,0),(10729,10,3863,0),(10730,2,3864,0),(10731,10,3864,0),(10732,2,3865,0),(10733,10,3865,0),(10734,2,3866,0),(10735,10,3866,0),(10736,2,3867,0),(10737,10,3867,0),(10738,2,3868,0),(10739,10,3868,0),(10740,2,3869,0),(10741,10,3869,0),(10742,2,3870,0),(10743,10,3870,0),(10744,2,3871,0),(10745,10,3871,0),(10746,2,3872,0),(10747,10,3872,0),(10748,2,3873,0),(10749,10,3873,0),(10750,2,3874,0),(10751,10,3874,0),(10752,2,3875,0),(10753,10,3875,0),(10754,2,3876,0),(10755,10,3876,0),(10756,2,3877,0),(10757,10,3877,0),(10758,2,3878,0),(10759,10,3878,0),(10760,2,3879,0),(10761,10,3879,0),(10762,2,3880,0),(10763,10,3880,0),(10764,2,3881,0),(10765,10,3881,0),(10766,2,3882,0),(10767,10,3882,0),(10768,2,3883,0),(10769,10,3883,0),(10770,2,3884,0),(10771,10,3884,0),(10772,2,3885,0),(10773,10,3885,0),(10774,2,3886,0),(10775,10,3886,0),(10776,2,3887,0),(10777,10,3887,0),(10778,2,3888,0),(10779,10,3888,0),(10780,2,3889,0),(10781,10,3889,0),(10782,2,3890,0),(10783,10,3890,0),(10784,2,3891,0),(10785,10,3891,0),(10786,2,3892,0),(10787,10,3892,0),(10788,2,3893,0),(10789,10,3893,0),(10790,2,3894,0),(10791,10,3894,0),(10792,2,3895,0),(10793,10,3895,0),(10794,2,3896,0),(10795,10,3896,0),(10796,2,3897,0),(10797,10,3897,0),(10798,2,3898,0),(10799,10,3898,0),(10800,2,3899,0),(10801,10,3899,0),(10802,2,3900,0),(10803,10,3900,0),(10804,2,3901,0),(10805,10,3901,0),(10806,2,3902,0),(10807,10,3902,0),(10808,2,3903,0),(10809,10,3903,0),(10810,2,3904,0),(10811,10,3904,0),(10812,2,3905,0),(10813,10,3905,0),(10814,2,3906,0),(10815,10,3906,0),(10816,2,3907,0),(10817,10,3907,0),(10818,2,3908,0),(10819,10,3908,0),(10820,2,3909,0),(10821,10,3909,0),(10822,2,3910,0),(10823,10,3910,0),(10824,2,3911,0),(10825,10,3911,0),(10826,2,3912,0),(10827,10,3912,0),(10828,2,3913,0),(10829,10,3913,0),(10830,2,3914,0),(10831,10,3914,0),(10832,2,3915,0),(10833,10,3915,0),(10834,2,3916,0),(10835,10,3916,0),(10836,2,3917,0),(10837,10,3917,0),(10838,2,3918,0),(10839,10,3918,0),(10840,2,3919,0),(10841,10,3919,0),(10842,2,3920,0),(10843,10,3920,0),(10844,2,3921,0),(10845,10,3921,0),(10846,2,3922,0),(10847,10,3922,0),(10848,2,3923,0),(10849,10,3923,0),(10850,2,3924,0),(10851,10,3924,0),(10852,2,3925,0),(10853,10,3925,0),(10854,2,3926,0),(10855,10,3926,0),(10856,2,3927,0),(10857,10,3927,0),(10858,2,3928,0),(10859,10,3928,0),(10860,2,3929,0),(10861,10,3929,0),(10862,2,3930,0),(10863,10,3930,0),(10864,2,3931,0),(10865,10,3931,0),(10866,2,3932,0),(10867,10,3932,0),(10868,2,3933,0),(10869,10,3933,0),(10870,2,3934,0),(10871,10,3934,0),(10872,2,3935,0),(10873,10,3935,0),(10874,2,3936,0),(10875,10,3936,0),(10876,2,3937,0),(10877,10,3937,0),(10878,2,3938,0),(10879,10,3938,0),(10880,2,3939,0),(10881,10,3939,0),(10882,2,3940,0),(10883,10,3940,0),(10884,2,3941,0),(10885,10,3941,0),(10886,2,3942,0),(10887,10,3942,0),(10888,2,3943,0),(10889,10,3943,0),(10890,2,3944,0),(10891,10,3944,0),(10892,2,3945,0),(10893,10,3945,0),(10894,2,3946,0),(10895,10,3946,0),(10896,2,3947,0),(10897,10,3947,0),(10898,2,3948,0),(10899,10,3948,0),(10900,2,3949,0),(10901,10,3949,0),(10902,2,3950,0),(10903,10,3950,0),(10904,2,3951,0),(10905,10,3951,0),(10906,2,3952,0),(10907,10,3952,0),(10908,2,3953,0),(10909,10,3953,0),(10910,2,3954,0),(10911,10,3954,0),(10912,2,3955,0),(10913,10,3955,0),(10914,2,3956,0),(10915,10,3956,0),(10916,2,3957,0),(10917,10,3957,0),(10918,2,3958,0),(10919,10,3958,0),(10920,2,3959,0),(10921,10,3959,0),(10922,2,3960,0),(10923,10,3960,0),(10924,2,3961,0),(10925,10,3961,0),(10926,2,3962,0),(10927,10,3962,0),(10928,2,3963,0),(10929,10,3963,0),(10930,2,3964,0),(10931,10,3964,0),(10932,2,3965,0),(10933,10,3965,0),(10934,2,3966,0),(10935,10,3966,0),(10936,2,3967,0),(10937,10,3967,0),(10938,2,3968,0),(10939,10,3968,0),(10940,2,3969,0),(10941,10,3969,0),(10942,2,3970,0),(10943,10,3970,0),(10944,2,3971,0),(10945,10,3971,0),(10946,2,3972,0),(10947,10,3972,0),(10948,2,3973,0),(10949,10,3973,0),(10950,2,3974,0),(10951,10,3974,0),(10952,2,3975,0),(10953,10,3975,0),(10954,2,3976,0),(10955,10,3976,0),(10956,2,3977,0),(10957,10,3977,0),(10958,2,3978,0),(10959,10,3978,0),(10960,2,3979,0),(10961,10,3979,0),(10962,2,3980,0),(10963,10,3980,0),(10964,2,3981,0),(10965,10,3981,0),(10966,2,3982,0),(10967,10,3982,0),(10968,2,3983,0),(10969,10,3983,0),(10970,2,3984,0),(10971,10,3984,0),(10972,2,3985,0),(10973,10,3985,0),(10974,2,3986,0),(10975,10,3986,0),(10976,2,3987,0),(10977,10,3987,0),(10978,2,3988,0),(10979,10,3988,0),(10980,2,3989,0),(10981,10,3989,0),(10982,2,3990,0),(10983,10,3990,0),(10984,2,3991,0),(10985,10,3991,0),(10986,2,3992,0),(10987,10,3992,0),(10988,2,3993,0),(10989,10,3993,0),(10990,2,3994,0),(10991,10,3994,0),(10992,2,3995,0),(10993,10,3995,0),(10994,2,3996,0),(10995,10,3996,0),(10996,2,3997,0),(10997,10,3997,0),(10998,2,3998,0),(10999,10,3998,0),(11000,2,3999,0),(11001,10,3999,0),(11002,2,4000,0),(11003,10,4000,0),(11004,2,4001,0),(11005,10,4001,0),(11006,2,4002,0),(11007,10,4002,0),(11008,2,4003,0),(11009,10,4003,0),(11010,2,4004,0),(11011,10,4004,0),(11012,2,4005,0),(11013,10,4005,0),(11014,2,4006,0),(11015,10,4006,0),(11016,2,4007,0),(11017,10,4007,0),(11018,2,4008,0),(11019,10,4008,0),(11020,2,4009,0),(11021,10,4009,0),(11022,2,4010,0),(11023,10,4010,0),(11024,2,4011,0),(11025,10,4011,0),(11026,2,4012,0),(11027,10,4012,0),(11028,2,4013,0),(11029,10,4013,0),(11030,2,4014,0),(11031,10,4014,0),(11032,2,4015,0),(11033,10,4015,0),(11034,2,4016,0),(11035,10,4016,0),(11036,2,4017,0),(11037,10,4017,0),(11038,2,4018,0),(11039,10,4018,0),(11040,2,4019,0),(11041,10,4019,0),(11042,2,4020,0),(11043,10,4020,0),(11044,2,4021,0),(11045,10,4021,0),(11046,2,4022,0),(11047,10,4022,0),(11048,2,4023,0),(11049,10,4023,0),(11050,2,4024,0),(11051,10,4024,0),(11052,2,4025,0),(11053,10,4025,0),(11054,2,4026,0),(11055,10,4026,0),(11056,2,4027,0),(11057,10,4027,0),(11058,2,4028,0),(11059,10,4028,0),(11060,2,4029,0),(11061,10,4029,0),(11062,2,4030,0),(11063,10,4030,0),(11064,2,4031,0),(11065,10,4031,0),(11066,2,4032,0),(11067,10,4032,0),(11068,2,4033,0),(11069,10,4033,0),(11070,2,4034,0),(11071,10,4034,0),(11072,2,4035,0),(11073,10,4035,0),(11074,2,4036,0),(11075,10,4036,0),(11076,2,4037,0),(11077,10,4037,0),(11078,2,4038,0),(11079,10,4038,0),(11080,2,4039,0),(11081,10,4039,0),(11082,2,4040,0),(11083,10,4040,0),(11084,2,4041,0),(11085,10,4041,0),(11086,2,4042,0),(11087,10,4042,0),(11088,2,4043,0),(11089,10,4043,0),(11090,2,4044,0),(11091,10,4044,0),(11092,2,4045,0),(11093,10,4045,0),(11094,2,4046,0),(11095,10,4046,0),(11096,2,4047,0),(11097,10,4047,0),(11098,2,4048,0),(11099,10,4048,0),(11100,2,4049,0),(11101,10,4049,0),(11102,2,4050,0),(11103,10,4050,0),(11104,2,4051,0),(11105,10,4051,0),(11106,2,4052,0),(11107,10,4052,0),(11108,2,4053,0),(11109,10,4053,0),(11110,2,4054,0),(11111,10,4054,0),(11112,2,4055,0),(11113,10,4055,0),(11114,2,4056,0),(11115,10,4056,0),(11116,2,4057,0),(11117,10,4057,0),(11118,2,4058,0),(11119,10,4058,0),(11120,2,4059,0),(11121,10,4059,0),(11122,2,4060,0),(11123,10,4060,0),(11124,2,4061,0),(11125,10,4061,0),(11126,2,4062,0),(11127,10,4062,0),(11128,2,4063,0),(11129,10,4063,0),(11130,2,4064,0),(11131,10,4064,0),(11132,2,4065,0),(11133,10,4065,0),(11134,2,4066,0),(11135,10,4066,0),(11136,2,4067,0),(11137,10,4067,0),(11138,2,4068,0),(11139,10,4068,0),(11140,2,4069,0),(11141,10,4069,0),(11142,2,4070,0),(11143,10,4070,0),(11144,2,4071,0),(11145,10,4071,0),(11146,2,4072,0),(11147,10,4072,0),(11148,2,4073,0),(11149,10,4073,0),(11150,2,4074,0),(11151,10,4074,0),(11152,2,4075,0),(11153,10,4075,0),(11154,2,4076,0),(11155,10,4076,0),(11156,2,4077,0),(11157,10,4077,0),(11158,2,4078,0),(11159,10,4078,0),(11160,2,4079,0),(11161,10,4079,0),(11162,2,4080,0),(11163,10,4080,0),(11164,2,4081,0),(11165,10,4081,0),(11166,2,4082,0),(11167,10,4082,0),(11168,2,4083,0),(11169,10,4083,0),(11170,2,4084,0),(11171,10,4084,0),(11172,2,4085,0),(11173,10,4085,0),(11174,2,4086,0),(11175,10,4086,0),(11176,2,4087,0),(11177,10,4087,0),(11178,2,4088,0),(11179,10,4088,0),(11180,2,4089,0),(11181,10,4089,0),(11182,2,4090,0),(11183,10,4090,0),(11184,2,4091,0),(11185,10,4091,0),(11186,2,4092,0),(11187,10,4092,0),(11188,2,4093,0),(11189,10,4093,0),(11190,2,4094,0),(11191,10,4094,0),(11192,2,4095,0),(11193,10,4095,0),(11194,2,4096,0),(11195,10,4096,0),(11196,2,4097,0),(11197,10,4097,0),(11198,2,4098,0),(11199,10,4098,0),(11200,2,4099,0),(11201,10,4099,0),(11202,2,4100,0),(11203,10,4100,0),(11204,2,4101,0),(11205,10,4101,0),(11206,2,4102,0),(11207,10,4102,0),(11208,2,4103,0),(11209,10,4103,0),(11210,2,4104,0),(11211,10,4104,0),(11212,2,4105,0),(11213,10,4105,0),(11214,2,4106,0),(11215,10,4106,0),(11216,2,4107,0),(11217,10,4107,0),(11218,2,4108,0),(11219,10,4108,0),(11220,2,4109,0),(11221,10,4109,0),(11222,2,4110,0),(11223,10,4110,0),(11224,2,4111,0),(11225,10,4111,0),(11226,2,4112,0),(11227,10,4112,0),(11228,2,4113,0),(11229,10,4113,0),(11230,2,4114,0),(11231,10,4114,0),(11232,2,4115,0),(11233,10,4115,0),(11234,2,4116,0),(11235,10,4116,0),(11236,2,4117,0),(11237,10,4117,0),(11238,2,4118,0),(11239,10,4118,0),(11240,2,4119,0),(11241,10,4119,0),(11242,2,4120,0),(11243,10,4120,0),(11244,2,4121,0),(11245,10,4121,0),(11246,2,4122,0),(11247,10,4122,0),(11248,2,4123,0),(11249,10,4123,0),(11250,2,4124,0),(11251,10,4124,0),(11252,2,4125,0),(11253,10,4125,0),(11254,2,4126,0),(11255,10,4126,0),(11256,2,4127,0),(11257,10,4127,0),(11258,2,4128,0),(11259,10,4128,0),(11260,2,4129,0),(11261,10,4129,0),(11262,2,4130,0),(11263,10,4130,0),(11264,2,4131,0),(11265,10,4131,0),(11266,2,4132,0),(11267,10,4132,0),(11268,2,4133,0),(11269,10,4133,0),(11270,2,4134,0),(11271,10,4134,0),(11272,2,4135,0),(11273,10,4135,0),(11274,2,4136,0),(11275,10,4136,0),(11276,2,4137,0),(11277,10,4137,0),(11278,2,4138,0),(11279,10,4138,0),(11280,2,4139,0),(11281,10,4139,0),(11282,2,4140,0),(11283,10,4140,0),(11284,2,4141,0),(11285,10,4141,0),(11286,2,4142,0),(11287,10,4142,0),(11288,2,4143,0),(11289,10,4143,0),(11290,2,4144,0),(11291,10,4144,0),(11292,2,4145,0),(11293,10,4145,0),(11294,2,4146,0),(11295,10,4146,0),(11296,2,4147,0),(11297,10,4147,0),(11298,2,4148,0),(11299,10,4148,0),(11300,2,4149,0),(11301,10,4149,0),(11302,2,4150,0),(11303,10,4150,0),(11304,2,4151,0),(11305,10,4151,0),(11306,2,4152,0),(11307,10,4152,0),(11308,2,4153,0),(11309,10,4153,0),(11310,2,4154,0),(11311,10,4154,0),(11312,2,4155,0),(11313,10,4155,0),(11314,2,4156,0),(11315,10,4156,0),(11316,2,4157,0),(11317,10,4157,0),(11318,2,4158,0),(11319,10,4158,0),(11320,2,4159,0),(11321,10,4159,0),(11322,2,4160,0),(11323,10,4160,0),(11324,2,4161,0),(11325,10,4161,0),(11326,2,4162,0),(11327,10,4162,0),(11328,2,4163,0),(11329,10,4163,0),(11330,2,4164,0),(11331,10,4164,0),(11332,2,4165,0),(11333,10,4165,0),(11334,2,4166,0),(11335,10,4166,0),(11336,2,4167,0),(11337,10,4167,0),(11338,2,4168,0),(11339,10,4168,0),(11340,2,4169,0),(11341,10,4169,0),(11342,2,4170,0),(11343,10,4170,0),(11344,2,4171,0),(11345,10,4171,0),(11346,2,4172,0),(11347,10,4172,0),(11348,2,4173,0),(11349,10,4173,0),(11350,2,4174,0),(11351,10,4174,0),(11352,2,4175,0),(11353,10,4175,0),(11354,2,4176,0),(11355,10,4176,0),(11356,2,4177,0),(11357,10,4177,0),(11358,2,4178,0),(11359,10,4178,0),(11360,2,4179,0),(11361,10,4179,0),(11362,2,4180,0),(11363,10,4180,0),(11364,2,4181,0),(11365,10,4181,0),(11366,2,4182,0),(11367,10,4182,0),(11368,2,4183,0),(11369,10,4183,0),(11370,2,4184,0),(11371,10,4184,0),(11372,2,4185,0),(11373,10,4185,0),(11374,2,4186,0),(11375,10,4186,0),(11376,2,4187,0),(11377,10,4187,0),(11378,2,4188,0),(11379,10,4188,0),(11380,2,4189,0),(11381,10,4189,0),(11382,2,4190,0),(11383,10,4190,0),(11384,2,4191,0),(11385,10,4191,0),(11386,2,4192,0),(11387,10,4192,0),(11388,2,4193,0),(11389,10,4193,0),(11390,2,4194,0),(11391,10,4194,0),(11392,2,4195,0),(11393,10,4195,0),(11394,2,4196,0),(11395,10,4196,0),(11396,2,4197,0),(11397,10,4197,0),(11398,2,4198,0),(11399,10,4198,0),(11400,2,4199,0),(11401,10,4199,0),(11402,2,4200,0),(11403,10,4200,0),(11404,2,4201,0),(11405,10,4201,0),(11406,2,4202,0),(11407,10,4202,0),(11408,2,4203,0),(11409,10,4203,0),(11410,2,4204,0),(11411,10,4204,0),(11412,2,4205,0),(11413,10,4205,0),(11414,2,4206,0),(11415,10,4206,0),(11416,2,4207,0),(11417,10,4207,0),(11418,2,4208,0),(11419,10,4208,0),(11420,2,4209,0),(11421,10,4209,0),(11422,2,4210,0),(11423,10,4210,0),(11424,2,4211,0),(11425,10,4211,0),(11426,2,4212,0),(11427,10,4212,0),(11428,2,4213,0),(11429,10,4213,0),(11430,2,4214,0),(11431,10,4214,0),(11432,2,4215,0),(11433,10,4215,0),(11434,2,4216,0),(11435,10,4216,0),(11436,2,4217,0),(11437,10,4217,0),(11438,2,4218,0),(11439,10,4218,0),(11440,2,4219,0),(11441,10,4219,0),(11442,2,4220,0),(11443,10,4220,0),(11444,2,4221,0),(11445,10,4221,0),(11446,2,4222,0),(11447,10,4222,0),(11448,2,4223,0),(11449,10,4223,0),(11450,2,4224,0),(11451,10,4224,0),(11452,2,4225,0),(11453,10,4225,0),(11454,2,4226,0),(11455,10,4226,0),(11456,2,4227,0),(11457,10,4227,0),(11458,2,4228,0),(11459,10,4228,0),(11460,2,4229,0),(11461,10,4229,0),(11462,2,4230,0),(11463,10,4230,0),(11464,2,4231,0),(11465,10,4231,0),(11466,2,4232,0),(11467,10,4232,0),(11468,2,4233,0),(11469,10,4233,0),(11470,2,4234,0),(11471,10,4234,0),(11472,2,4235,0),(11473,10,4235,0),(11474,2,4236,0),(11475,10,4236,0),(11476,2,4237,0),(11477,10,4237,0),(11478,2,4238,0),(11479,10,4238,0),(11480,2,4239,0),(11481,10,4239,0),(11482,2,4240,0),(11483,10,4240,0),(11484,2,4241,0),(11485,10,4241,0),(11486,2,4242,0),(11487,10,4242,0),(11488,2,4243,0),(11489,10,4243,0),(11490,2,4244,0),(11491,10,4244,0),(11492,2,4245,0),(11493,10,4245,0),(11494,2,4246,0),(11495,10,4246,0),(11496,2,4247,0),(11497,10,4247,0),(11498,2,4248,0),(11499,10,4248,0),(11500,2,4249,0),(11501,10,4249,0),(11502,2,4250,0),(11503,10,4250,0),(11504,2,4251,0),(11505,10,4251,0),(11506,2,4252,0),(11507,10,4252,0),(11508,2,4253,0),(11509,10,4253,0),(11510,2,4254,0),(11511,10,4254,0),(11512,2,4255,0),(11513,10,4255,0),(11514,2,4256,0),(11515,10,4256,0),(11516,2,4257,0),(11517,10,4257,0),(11518,2,4258,0),(11519,10,4258,0),(11520,2,4259,0),(11521,10,4259,0),(11522,2,4260,0),(11523,10,4260,0),(11524,2,4261,0),(11525,10,4261,0),(11526,2,4262,0),(11527,10,4262,0),(11528,2,4263,0),(11529,10,4263,0),(11530,2,4264,0),(11531,10,4264,0),(11532,2,4265,0),(11533,10,4265,0),(11534,2,4266,0),(11535,10,4266,0),(11536,2,4267,0),(11537,10,4267,0),(11538,2,4268,0),(11539,10,4268,0),(11540,2,4269,0),(11541,10,4269,0),(11542,2,4270,0),(11543,10,4270,0),(11544,2,4271,0),(11545,10,4271,0),(11546,2,4272,0),(11547,10,4272,0),(11548,2,4273,0),(11549,10,4273,0),(11550,2,4274,0),(11551,10,4274,0),(11552,2,4275,0),(11553,10,4275,0),(11554,2,4276,0),(11555,10,4276,0),(11556,2,4277,0),(11557,10,4277,0),(11558,2,4278,0),(11559,10,4278,0),(11560,2,4279,0),(11561,10,4279,0),(11562,2,4280,0),(11563,10,4280,0),(11564,2,4281,0),(11565,10,4281,0),(11566,2,4282,0),(11567,10,4282,0),(11568,2,4283,0),(11569,10,4283,0),(11570,2,4284,0),(11571,10,4284,0),(11572,2,4285,0),(11573,10,4285,0),(11574,2,4286,0),(11575,10,4286,0),(11576,2,4287,0),(11577,10,4287,0),(11578,2,4288,0),(11579,10,4288,0),(11580,2,4289,0),(11581,10,4289,0),(11582,2,4290,0),(11583,10,4290,0),(11584,2,4291,0),(11585,10,4291,0),(11586,2,4292,0),(11587,10,4292,0),(11588,2,4293,0),(11589,10,4293,0),(11590,2,4294,0),(11591,10,4294,0),(11592,2,4295,0),(11593,10,4295,0),(11594,2,4296,0),(11595,10,4296,0),(11596,2,4297,0),(11597,10,4297,0),(11598,2,4298,0),(11599,10,4298,0),(11600,2,4299,0),(11601,10,4299,0),(11602,2,4300,0),(11603,10,4300,0),(11604,2,4301,0),(11605,10,4301,0),(11606,2,4302,0),(11607,10,4302,0),(11608,2,4303,0),(11609,10,4303,0),(11610,2,4304,0),(11611,10,4304,0),(11612,2,4305,0),(11613,10,4305,0),(11614,2,4306,0),(11615,10,4306,0),(11616,2,4307,0),(11617,10,4307,0),(11618,2,4308,0),(11619,10,4308,0),(11620,2,4309,0),(11621,10,4309,0),(11622,2,4310,0),(11623,10,4310,0),(11624,2,4311,0),(11625,10,4311,0),(11626,2,4312,0),(11627,10,4312,0),(11628,2,4313,0),(11629,10,4313,0),(11630,2,4314,0),(11631,10,4314,0),(11632,2,4315,0),(11633,10,4315,0),(11634,2,4316,0),(11635,10,4316,0),(11636,2,4317,0),(11637,10,4317,0),(11638,2,4318,0),(11639,10,4318,0),(11640,2,4319,0),(11641,10,4319,0),(11642,2,4320,0),(11643,10,4320,0),(11644,2,4321,0),(11645,10,4321,0),(11646,2,4322,0),(11647,10,4322,0),(11648,2,4323,0),(11649,10,4323,0),(11650,2,4324,0),(11651,10,4324,0),(11652,2,4325,0),(11653,10,4325,0),(11654,2,4326,0),(11655,10,4326,0),(11656,2,4327,0),(11657,10,4327,0),(11658,2,4328,0),(11659,10,4328,0),(11660,2,4329,0),(11661,10,4329,0),(11662,2,4330,0),(11663,10,4330,0),(11664,2,4331,0),(11665,10,4331,0),(11666,2,4332,0),(11667,10,4332,0),(11668,2,4333,0),(11669,10,4333,0),(11670,2,4334,0),(11671,10,4334,0),(11672,2,4335,0),(11673,10,4335,0),(11674,2,4336,0),(11675,10,4336,0),(11676,2,4337,0),(11677,10,4337,0),(11678,2,4338,0),(11679,10,4338,0),(11680,2,4339,0),(11681,10,4339,0),(11682,2,4340,0),(11683,10,4340,0),(11684,2,4341,0),(11685,10,4341,0),(11686,2,4342,0),(11687,10,4342,0),(11688,2,4343,0),(11689,10,4343,0),(11690,2,4344,0),(11691,10,4344,0),(11692,2,4345,0),(11693,10,4345,0),(11694,2,4346,0),(11695,10,4346,0),(11696,2,4347,0),(11697,10,4347,0),(11698,2,4348,0),(11699,10,4348,0),(11700,2,4349,0),(11701,10,4349,0),(11702,2,4350,0),(11703,10,4350,0),(11704,2,4351,0),(11705,10,4351,0),(11706,2,4352,0),(11707,10,4352,0),(11708,2,4353,0),(11709,10,4353,0),(11710,2,4354,0),(11711,10,4354,0),(11712,2,4355,0),(11713,10,4355,0),(11714,2,4356,0),(11715,10,4356,0),(11716,2,4357,0),(11717,10,4357,0),(11718,2,4358,0),(11719,10,4358,0),(11720,2,4359,0),(11721,10,4359,0),(11722,2,4360,0),(11723,10,4360,0),(11724,2,4361,0),(11725,10,4361,0),(11726,2,4362,0),(11727,10,4362,0),(11728,2,4363,0),(11729,10,4363,0),(11730,2,4364,0),(11731,10,4364,0),(11732,2,4365,0),(11733,10,4365,0),(11734,2,4366,0),(11735,10,4366,0),(11736,2,4367,0),(11737,10,4367,0),(11738,2,4368,0),(11739,10,4368,0),(11740,2,4369,0),(11741,10,4369,0),(11742,2,4370,0),(11743,10,4370,0),(11744,2,4371,0),(11745,10,4371,0),(11746,2,4372,0),(11747,10,4372,0),(11748,2,4373,0),(11749,10,4373,0),(11750,2,4374,0),(11751,10,4374,0),(11752,2,4375,0),(11753,10,4375,0),(11754,2,4376,0),(11755,10,4376,0),(11756,2,4377,0),(11757,10,4377,0),(11758,2,4378,0),(11759,10,4378,0),(11760,2,4379,0),(11761,10,4379,0),(11762,2,4380,0),(11763,10,4380,0),(11764,2,4381,0),(11765,10,4381,0),(11766,2,4382,0),(11767,10,4382,0),(11768,2,4383,0),(11769,10,4383,0),(11770,2,4384,0),(11771,10,4384,0),(11772,2,4385,0),(11773,10,4385,0),(11774,2,4386,0),(11775,10,4386,0),(11776,2,4387,0),(11777,10,4387,0),(11778,2,4388,0),(11779,10,4388,0),(11780,2,4389,0),(11781,10,4389,0),(11782,2,4390,0),(11783,10,4390,0),(11784,2,4391,0),(11785,10,4391,0),(11786,2,4392,0),(11787,10,4392,0),(11788,2,4393,0),(11789,10,4393,0),(11790,2,4394,0),(11791,10,4394,0),(11792,2,4395,0),(11793,10,4395,0),(11794,2,4396,0),(11795,10,4396,0),(11796,2,4397,0),(11797,10,4397,0),(11798,2,4398,0),(11799,10,4398,0),(11800,2,4399,0),(11801,10,4399,0),(11802,2,4400,0),(11803,10,4400,0),(11804,2,4401,0),(11805,10,4401,0),(11806,2,4402,0),(11807,10,4402,0),(11808,2,4403,0),(11809,10,4403,0),(11810,2,4404,0),(11811,10,4404,0),(11812,2,4405,0),(11813,10,4405,0),(11814,2,4406,0),(11815,10,4406,0),(11816,2,4407,0),(11817,10,4407,0),(11818,2,4408,0),(11819,10,4408,0),(11820,2,4409,0),(11821,10,4409,0),(11822,2,4410,0),(11823,10,4410,0),(11824,2,4411,0),(11825,10,4411,0),(11826,2,4412,0),(11827,10,4412,0),(11828,2,4413,0),(11829,10,4413,0),(11830,2,4414,0),(11831,10,4414,0),(11832,2,4415,0),(11833,10,4415,0),(11834,2,4416,0),(11835,10,4416,0),(11836,2,4417,0),(11837,10,4417,0),(11838,2,4418,0),(11839,10,4418,0),(11840,2,4419,0),(11841,10,4419,0),(11842,2,4420,0),(11843,10,4420,0),(11844,2,4421,0),(11845,10,4421,0),(11846,2,4422,0),(11847,10,4422,0),(11848,2,4423,0),(11849,10,4423,0),(11850,2,4424,0),(11851,10,4424,0),(11852,2,4425,0),(11853,10,4425,0),(11854,2,4426,0),(11855,10,4426,0),(11856,2,4427,0),(11857,10,4427,0),(11858,2,4428,0),(11859,10,4428,0),(11860,2,4429,0),(11861,10,4429,0),(11862,2,4430,0),(11863,10,4430,0),(11864,2,4431,0),(11865,10,4431,0),(11866,2,4432,0),(11867,10,4432,0),(11868,2,4433,0),(11869,10,4433,0),(11870,2,4434,0),(11871,10,4434,0),(11872,2,4435,0),(11873,10,4435,0),(11874,2,4436,0),(11875,10,4436,0),(11876,2,4437,0),(11877,10,4437,0),(11878,2,4438,0),(11879,10,4438,0),(11880,2,4439,0),(11881,10,4439,0),(11882,2,4440,0),(11883,10,4440,0),(11884,2,4441,0),(11885,10,4441,0),(11886,2,4442,0),(11887,10,4442,0),(11888,2,4443,0),(11889,10,4443,0),(11890,2,4444,0),(11891,10,4444,0),(11892,2,4445,0),(11893,10,4445,0),(11894,2,4446,0),(11895,10,4446,0),(11896,2,4447,0),(11897,10,4447,0),(11898,2,4448,0),(11899,10,4448,0),(11900,2,4449,0),(11901,10,4449,0),(11902,2,4450,0),(11903,10,4450,0),(11904,2,4451,0),(11905,10,4451,0),(11906,2,4452,0),(11907,10,4452,0),(11908,2,4453,0),(11909,10,4453,0),(11910,2,4454,0),(11911,10,4454,0),(11912,2,4455,0),(11913,10,4455,0),(11914,2,4456,0),(11915,10,4456,0),(11916,2,4457,0),(11917,10,4457,0),(11918,2,4458,0),(11919,10,4458,0),(11920,2,4459,0),(11921,10,4459,0),(11922,2,4460,0),(11923,10,4460,0),(11924,2,4461,0),(11925,10,4461,0),(11926,2,4462,0),(11927,10,4462,0),(11928,2,4463,0),(11929,10,4463,0),(11930,2,4464,0),(11931,10,4464,0),(11932,2,4465,0),(11933,10,4465,0),(11934,2,4466,0),(11935,10,4466,0),(11936,2,4467,0),(11937,10,4467,0),(11938,2,4468,0),(11939,10,4468,0),(11940,2,4469,0),(11941,10,4469,0),(11942,2,4470,0),(11943,10,4470,0),(11944,2,4471,0),(11945,10,4471,0),(11946,2,4472,0),(11947,10,4472,0),(11948,2,4473,0),(11949,10,4473,0),(11950,2,4474,0),(11951,10,4474,0),(11952,2,4475,0),(11953,10,4475,0),(11954,2,4476,0),(11955,10,4476,0),(11956,2,4477,0),(11957,10,4477,0),(11958,2,4478,0),(11959,10,4478,0),(11960,2,4479,0),(11961,10,4479,0),(11962,2,4480,0),(11963,10,4480,0),(11964,2,4481,0),(11965,10,4481,0),(11966,2,4482,0),(11967,10,4482,0),(11968,2,4483,0),(11969,10,4483,0),(11970,2,4484,0),(11971,10,4484,0),(11972,2,4485,0),(11973,10,4485,0),(11974,2,4486,0),(11975,10,4486,0),(11976,2,4487,0),(11977,10,4487,0),(11978,2,4488,0),(11979,10,4488,0),(11980,2,4489,0),(11981,10,4489,0),(11982,2,4490,0),(11983,10,4490,0),(11984,2,4491,0),(11985,10,4491,0),(11986,2,4492,0),(11987,10,4492,0),(11988,2,4493,0),(11989,10,4493,0),(11990,2,4494,0),(11991,10,4494,0),(11992,2,4495,0),(11993,10,4495,0),(11994,2,4496,0),(11995,10,4496,0),(11996,2,4497,0),(11997,10,4497,0),(11998,2,4498,0),(11999,10,4498,0),(12000,2,4499,0),(12001,10,4499,0),(12002,2,4500,0),(12003,10,4500,0),(12004,2,4501,0),(12005,10,4501,0),(12006,2,4502,0),(12007,10,4502,0),(12008,2,4503,0),(12009,10,4503,0),(12010,2,4504,0),(12011,10,4504,0),(12012,2,4505,0),(12013,10,4505,0),(12014,2,4506,0),(12015,10,4506,0),(12016,2,4507,0),(12017,10,4507,0),(12018,2,4508,0),(12019,10,4508,0),(12020,2,4509,0),(12021,10,4509,0),(12022,2,4510,0),(12023,10,4510,0),(12024,2,4511,0),(12025,10,4511,0),(12026,2,4512,0),(12027,10,4512,0),(12028,2,4513,0),(12029,10,4513,0),(12030,2,4514,0),(12031,10,4514,0),(12032,2,4515,0),(12033,10,4515,0),(12034,2,4516,0),(12035,10,4516,0),(12036,2,4517,0),(12037,10,4517,0),(12038,2,4518,0),(12039,10,4518,0),(12040,2,4519,0),(12041,10,4519,0),(12042,2,4520,0),(12043,10,4520,0),(12044,2,4521,0),(12045,10,4521,0),(12046,2,4522,0),(12047,10,4522,0),(12048,2,4523,0),(12049,10,4523,0),(12050,2,4524,0),(12051,10,4524,0),(12052,2,4525,0),(12053,10,4525,0),(12054,2,4526,0),(12055,10,4526,0),(12056,2,4527,0),(12057,10,4527,0),(12058,2,4528,0),(12059,10,4528,0),(12060,2,4529,0),(12061,10,4529,0),(12062,2,4530,0),(12063,10,4530,0),(12064,2,4531,0),(12065,10,4531,0),(12066,2,4532,0),(12067,10,4532,0),(12068,2,4533,0),(12069,10,4533,0),(12070,2,4534,0),(12071,10,4534,0),(12072,2,4535,0),(12073,10,4535,0),(12074,2,4536,0),(12075,10,4536,0),(12076,2,4537,0),(12077,10,4537,0),(12078,2,4538,0),(12079,10,4538,0),(12080,2,4539,0),(12081,10,4539,0),(12082,2,4540,0),(12083,10,4540,0),(12084,2,4541,0),(12085,10,4541,0),(12086,2,4542,0),(12087,10,4542,0),(12088,2,4543,0),(12089,10,4543,0),(12090,2,4544,0),(12091,10,4544,0),(12092,2,4545,0),(12093,10,4545,0),(12094,2,4546,0),(12095,10,4546,0),(12096,2,4547,0),(12097,10,4547,0),(12098,2,4548,0),(12099,10,4548,0),(12100,2,4549,0),(12101,10,4549,0),(12102,2,4550,0),(12103,10,4550,0),(12104,2,4551,0),(12105,10,4551,0),(12106,2,4552,0),(12107,10,4552,0),(12108,2,4553,0),(12109,10,4553,0),(12110,2,4554,0),(12111,10,4554,0),(12112,2,4555,0),(12113,10,4555,0),(12114,2,4556,0),(12115,10,4556,0),(12116,2,4557,0),(12117,10,4557,0),(12118,2,4558,0),(12119,10,4558,0),(12120,2,4559,0),(12121,10,4559,0),(12122,2,4560,0),(12123,10,4560,0),(12124,2,4561,0),(12125,10,4561,0),(12126,2,4562,0),(12127,10,4562,0),(12128,2,4563,0),(12129,10,4563,0),(12130,2,4564,0),(12131,10,4564,0),(12132,2,4565,0),(12133,10,4565,0),(12134,2,4566,0),(12135,10,4566,0),(12136,2,4567,0),(12137,10,4567,0),(12138,2,4568,0),(12139,10,4568,0),(12140,2,4569,0),(12141,10,4569,0),(12142,2,4570,0),(12143,10,4570,0),(12144,2,4571,0),(12145,10,4571,0),(12146,2,4572,0),(12147,10,4572,0),(12148,2,4573,0),(12149,10,4573,0),(12150,2,4574,0),(12151,10,4574,0),(12152,2,4575,0),(12153,10,4575,0),(12154,2,4576,0),(12155,10,4576,0),(12156,2,4577,0),(12157,10,4577,0),(12158,2,4578,0),(12159,10,4578,0),(12160,2,4579,0),(12161,10,4579,0),(12162,2,4580,0),(12163,10,4580,0),(12164,2,4581,0),(12165,10,4581,0),(12166,2,4582,0),(12167,10,4582,0),(12168,2,4583,0),(12169,10,4583,0),(12170,2,4584,0),(12171,10,4584,0),(12172,2,4585,0),(12173,10,4585,0),(12174,2,4586,0),(12175,10,4586,0),(12176,2,4587,0),(12177,10,4587,0),(12178,2,4588,0),(12179,10,4588,0),(12180,2,4589,0),(12181,10,4589,0),(12182,2,4590,0),(12183,10,4590,0),(12184,2,4591,0),(12185,10,4591,0),(12186,2,4592,0),(12187,10,4592,0),(12188,2,4593,0),(12189,10,4593,0),(12190,2,4594,0),(12191,10,4594,0),(12192,2,4595,0),(12193,10,4595,0),(12194,2,4596,0),(12195,10,4596,0),(12196,2,4597,0),(12197,10,4597,0),(12198,2,4598,0),(12199,10,4598,0),(12200,2,4599,0),(12201,10,4599,0),(12202,2,4600,0),(12203,10,4600,0),(12204,2,4601,0),(12205,10,4601,0),(12206,2,4602,0),(12207,10,4602,0),(12208,2,4603,0),(12209,10,4603,0),(12210,2,4604,0),(12211,10,4604,0),(12212,2,4605,0),(12213,10,4605,0),(12214,2,4606,0),(12215,10,4606,0),(12216,2,4607,0),(12217,10,4607,0),(12218,2,4608,0),(12219,10,4608,0),(12220,2,4609,0),(12221,10,4609,0),(12222,2,4610,0),(12223,10,4610,0),(12224,2,4611,0),(12225,10,4611,0),(12226,2,4612,0),(12227,10,4612,0),(12228,2,4613,0),(12229,10,4613,0),(12230,2,4614,0),(12231,10,4614,0),(12232,2,4615,0),(12233,10,4615,0),(12234,2,4616,0),(12235,10,4616,0),(12236,2,4617,0),(12237,10,4617,0),(12238,2,4618,0),(12239,10,4618,0),(12240,2,4619,0),(12241,10,4619,0),(12242,2,4620,0),(12243,10,4620,0),(12244,2,4621,0),(12245,10,4621,0),(12246,2,4622,0),(12247,10,4622,0),(12248,2,4623,0),(12249,10,4623,0),(12250,2,4624,0),(12251,10,4624,0),(12252,2,4625,0),(12253,10,4625,0),(12254,2,4626,0),(12255,10,4626,0),(12256,2,4627,0),(12257,10,4627,0),(12258,2,4628,0),(12259,10,4628,0),(12260,2,4629,0),(12261,10,4629,0),(12262,2,4630,0),(12263,10,4630,0),(12264,2,4631,0),(12265,10,4631,0),(12266,2,4632,0),(12267,10,4632,0),(12268,2,4633,0),(12269,10,4633,0),(12270,2,4634,0),(12271,10,4634,0),(12272,2,4635,0),(12273,10,4635,0),(12274,2,4636,0),(12275,10,4636,0),(12276,2,4637,0),(12277,10,4637,0),(12278,2,4638,0),(12279,10,4638,0),(12280,2,4639,0),(12281,10,4639,0),(12282,2,4640,0),(12283,10,4640,0),(12284,2,4641,0),(12285,10,4641,0),(12286,2,4642,0),(12287,10,4642,0),(12288,2,4643,0),(12289,10,4643,0),(12290,2,4644,0),(12291,10,4644,0),(12292,2,4645,0),(12293,10,4645,0),(12294,2,4646,0),(12295,10,4646,0),(12296,2,4647,0),(12297,10,4647,0),(12298,2,4648,0),(12299,10,4648,0),(12300,2,4649,0),(12301,10,4649,0),(12302,2,4650,0),(12303,10,4650,0),(12304,2,4651,0),(12305,10,4651,0),(12306,2,4652,0),(12307,10,4652,0),(12308,2,4653,0),(12309,10,4653,0),(12310,2,4654,0),(12311,10,4654,0),(12312,2,4655,0),(12313,10,4655,0),(12314,2,4656,0),(12315,10,4656,0),(12316,2,4657,0),(12317,10,4657,0),(12318,2,4658,0),(12319,10,4658,0),(12320,2,4659,0),(12321,10,4659,0),(12322,2,4660,0),(12323,10,4660,0),(12324,2,4661,0),(12325,10,4661,0),(12326,2,4662,0),(12327,10,4662,0),(12328,2,4663,0),(12329,10,4663,0),(12330,2,4664,0),(12331,10,4664,0),(12332,2,4665,0),(12333,10,4665,0),(12334,2,4666,0),(12335,10,4666,0),(12336,2,4667,0),(12337,10,4667,0),(12338,2,4668,0),(12339,10,4668,0),(12340,2,4669,0),(12341,10,4669,0),(12342,2,4670,0),(12343,10,4670,0),(12344,2,4671,0),(12345,10,4671,0),(12346,2,4672,0),(12347,10,4672,0),(12348,2,4673,0),(12349,10,4673,0),(12350,2,4674,0),(12351,10,4674,0),(12352,2,4675,0),(12353,10,4675,0),(12354,2,4676,0),(12355,10,4676,0),(12356,2,4677,0),(12357,10,4677,0),(12358,2,4678,0),(12359,10,4678,0),(12360,2,4679,0),(12361,10,4679,0),(12362,2,4680,0),(12363,10,4680,0),(12364,2,4681,0),(12365,10,4681,0),(12366,2,4682,0),(12367,10,4682,0),(12368,2,4683,0),(12369,10,4683,0),(12370,2,4684,0),(12371,10,4684,0),(12372,2,4685,0),(12373,10,4685,0),(12374,2,4686,0),(12375,10,4686,0),(12376,2,4687,0),(12377,10,4687,0),(12378,2,4688,0),(12379,10,4688,0),(12380,2,4689,0),(12381,10,4689,0),(12382,2,4690,0),(12383,10,4690,0),(12384,2,4691,0),(12385,10,4691,0),(12386,2,4692,0),(12387,10,4692,0),(12388,2,4693,0),(12389,10,4693,0),(12390,2,4694,0),(12391,10,4694,0),(12392,2,4695,0),(12393,10,4695,0),(12394,2,4696,0),(12395,10,4696,0),(12396,2,4697,0),(12397,10,4697,0),(12398,2,4698,0),(12399,10,4698,0),(12400,2,4699,0),(12401,10,4699,0),(12402,2,4700,0),(12403,10,4700,0),(12404,2,4701,0),(12405,10,4701,0),(12406,2,4702,0),(12407,10,4702,0),(12408,2,4703,0),(12409,10,4703,0),(12410,2,4704,0),(12411,10,4704,0),(12412,2,4705,0),(12413,10,4705,0),(12414,2,4706,0),(12415,10,4706,0),(12416,2,4707,0),(12417,10,4707,0),(12418,2,4708,0),(12419,10,4708,0),(12420,2,4709,0),(12421,10,4709,0),(12422,2,4710,0),(12423,10,4710,0),(12424,2,4711,0),(12425,10,4711,0),(12426,2,4712,0),(12427,10,4712,0),(12428,2,4713,0),(12429,10,4713,0),(12430,2,4714,0),(12431,10,4714,0),(12432,2,4715,0),(12433,10,4715,0),(12434,2,4716,0),(12435,10,4716,0),(12436,2,4717,0),(12437,10,4717,0),(12438,2,4718,0),(12439,10,4718,0),(12440,2,4719,0),(12441,10,4719,0),(12442,2,4720,0),(12443,10,4720,0),(12444,2,4721,0),(12445,10,4721,0),(12446,2,4722,0),(12447,10,4722,0),(12448,2,4723,0),(12449,10,4723,0),(12450,2,4724,0),(12451,10,4724,0),(12452,2,4725,0),(12453,10,4725,0),(12454,2,4726,0),(12455,10,4726,0),(12456,2,4727,0),(12457,10,4727,0),(12458,2,4728,0),(12459,10,4728,0),(12460,2,4729,0),(12461,10,4729,0),(12462,2,4730,0),(12463,10,4730,0),(12464,2,4731,0),(12465,10,4731,0),(12466,2,4732,0),(12467,10,4732,0),(12468,2,4733,0),(12469,10,4733,0),(12470,2,4734,0),(12471,10,4734,0),(12472,2,4735,0),(12473,10,4735,0),(12474,2,4736,0),(12475,10,4736,0),(12476,2,4737,0),(12477,10,4737,0),(12478,2,4738,0),(12479,10,4738,0),(12480,2,4739,0),(12481,10,4739,0),(12482,2,4740,0),(12483,10,4740,0),(12484,2,4741,0),(12485,10,4741,0),(12486,2,4742,0),(12487,10,4742,0),(12488,2,4743,0),(12489,10,4743,0),(12490,2,4744,0),(12491,10,4744,0),(12492,2,4745,0),(12493,10,4745,0),(12494,2,4746,0),(12495,10,4746,0),(12496,2,4747,0),(12497,10,4747,0),(12498,2,4748,0),(12499,10,4748,0),(12500,2,4749,0),(12501,10,4749,0),(12502,2,4750,0),(12503,10,4750,0),(12504,2,4751,0),(12505,10,4751,0),(12506,2,4752,0),(12507,10,4752,0),(12508,2,4753,0),(12509,10,4753,0),(12510,2,4754,0),(12511,10,4754,0),(12512,2,4755,0),(12513,10,4755,0),(12514,2,4756,0),(12515,10,4756,0),(12516,2,4757,0),(12517,10,4757,0),(12518,2,4758,0),(12519,10,4758,0),(12520,2,4759,0),(12521,10,4759,0),(12522,2,4760,0),(12523,10,4760,0),(12524,2,4761,0),(12525,10,4761,0),(12526,2,4762,0),(12527,10,4762,0),(12528,2,4763,0),(12529,10,4763,0),(12530,2,4764,0),(12531,10,4764,0),(12532,2,4765,0),(12533,10,4765,0),(12534,2,4766,0),(12535,10,4766,0),(12536,2,4767,0),(12537,10,4767,0),(12538,2,4768,0),(12539,10,4768,0),(12540,2,4769,0),(12541,10,4769,0),(12542,2,4770,0),(12543,10,4770,0),(12544,2,4771,0),(12545,10,4771,0),(12546,2,4772,0),(12547,10,4772,0),(12548,2,4773,0),(12549,10,4773,0),(12550,2,4774,0),(12551,10,4774,0),(12552,2,4775,0),(12553,10,4775,0),(12554,2,4776,0),(12555,10,4776,0),(12556,2,4777,0),(12557,10,4777,0),(12558,2,4778,0),(12559,10,4778,0),(12560,2,4779,0),(12561,10,4779,0),(12562,2,4780,0),(12563,10,4780,0),(12564,2,4781,0),(12565,10,4781,0),(12566,2,4782,0),(12567,10,4782,0),(12568,2,4783,0),(12569,10,4783,0),(12570,2,4784,0),(12571,10,4784,0),(12572,2,4785,0),(12573,10,4785,0),(12574,2,4786,0),(12575,10,4786,0),(12576,2,4787,0),(12577,10,4787,0),(12578,2,4788,0),(12579,10,4788,0),(12580,2,4789,0),(12581,10,4789,0),(12582,2,4790,0),(12583,10,4790,0),(12584,2,4791,0),(12585,10,4791,0),(12586,2,4792,0),(12587,10,4792,0),(12588,2,4793,0),(12589,10,4793,0),(12590,2,4794,0),(12591,10,4794,0),(12592,2,4795,0),(12593,10,4795,0),(12594,2,4796,0),(12595,10,4796,0),(12596,2,4797,0),(12597,10,4797,0),(12598,2,4798,0),(12599,10,4798,0),(12600,2,4799,0),(12601,10,4799,0),(12602,2,4800,0),(12603,10,4800,0),(12604,2,4801,0),(12605,10,4801,0),(12606,2,4802,0),(12607,10,4802,0),(12608,2,4803,0),(12609,10,4803,0),(12610,2,4804,0),(12611,10,4804,0),(12612,2,4805,0),(12613,10,4805,0),(12614,2,4806,0),(12615,10,4806,0),(12616,2,4807,0),(12617,10,4807,0),(12618,2,4808,0),(12619,10,4808,0),(12620,2,4809,0),(12621,10,4809,0),(12622,2,4810,0),(12623,10,4810,0),(12624,2,4811,0),(12625,10,4811,0),(12626,2,4812,0),(12627,10,4812,0),(12628,2,4813,0),(12629,10,4813,0),(12630,2,4814,0),(12631,10,4814,0),(12632,2,4815,0),(12633,10,4815,0),(12634,2,4816,0),(12635,10,4816,0),(12636,2,4817,0),(12637,10,4817,0),(12638,2,4818,0),(12639,10,4818,0),(12640,2,4819,0),(12641,10,4819,0),(12642,2,4820,0),(12643,10,4820,0),(12644,2,4821,0),(12645,10,4821,0),(12646,2,4822,0),(12647,10,4822,0),(12648,2,4823,0),(12649,10,4823,0),(12650,2,4824,0),(12651,10,4824,0),(12652,2,4825,0),(12653,10,4825,0),(12654,2,4826,0),(12655,10,4826,0),(12656,2,4827,0),(12657,10,4827,0),(12658,2,4828,0),(12659,10,4828,0),(12660,2,4829,0),(12661,10,4829,0),(12662,2,4830,0),(12663,10,4830,0),(12664,2,4831,0),(12665,10,4831,0),(12666,2,4832,0),(12667,10,4832,0),(12668,2,4833,0),(12669,10,4833,0),(12670,2,4834,0),(12671,10,4834,0),(12672,2,4835,0),(12673,10,4835,0),(12674,2,4836,0),(12675,10,4836,0),(12676,2,4837,0),(12677,10,4837,0),(12678,2,4838,0),(12679,10,4838,0),(12680,2,4839,0),(12681,10,4839,0),(12682,2,4840,0),(12683,10,4840,0),(12684,2,4841,0),(12685,10,4841,0),(12686,2,4842,0),(12687,10,4842,0),(12688,2,4843,0),(12689,10,4843,0),(12690,2,4844,0),(12691,10,4844,0),(12692,2,4845,0),(12693,10,4845,0),(12694,2,4846,0),(12695,10,4846,0),(12696,2,4847,0),(12697,10,4847,0),(12698,2,4848,0),(12699,10,4848,0),(12700,2,4849,0),(12701,10,4849,0),(12702,2,4850,0),(12703,10,4850,0),(12704,2,4851,0),(12705,10,4851,0),(12706,2,4852,0),(12707,10,4852,0),(12708,2,4853,0),(12709,10,4853,0),(12710,2,4854,0),(12711,10,4854,0),(12712,2,4855,0),(12713,10,4855,0),(12714,2,4856,0),(12715,10,4856,0),(12716,2,4857,0),(12717,10,4857,0),(12718,2,4858,0),(12719,10,4858,0),(12720,2,4859,0),(12721,10,4859,0),(12722,2,4860,0),(12723,10,4860,0),(12724,2,4861,0),(12725,10,4861,0),(12726,2,4862,0),(12727,10,4862,0),(12728,2,4863,0),(12729,10,4863,0),(12730,2,4864,0),(12731,10,4864,0),(12732,2,4865,0),(12733,10,4865,0),(12734,2,4866,0),(12735,10,4866,0),(12736,2,4867,0),(12737,10,4867,0),(12738,2,4868,0),(12739,10,4868,0),(12740,2,4869,0),(12741,10,4869,0),(12742,2,4870,0),(12743,10,4870,0),(12744,2,4871,0),(12745,10,4871,0),(12746,2,4872,0),(12747,10,4872,0),(12748,2,4873,0),(12749,10,4873,0),(12750,2,4874,0),(12751,10,4874,0),(12752,2,4875,0),(12753,10,4875,0),(12754,2,4876,0),(12755,10,4876,0),(12756,2,4877,0),(12757,10,4877,0),(12758,2,4878,0),(12759,10,4878,0),(12760,2,4879,0),(12761,10,4879,0),(12762,2,4880,0),(12763,10,4880,0),(12764,2,4881,0),(12765,10,4881,0),(12766,2,4882,0),(12767,10,4882,0),(12768,2,4883,0),(12769,10,4883,0),(12770,2,4884,0),(12771,10,4884,0),(12772,2,4885,0),(12773,10,4885,0),(12774,2,4886,0),(12775,10,4886,0),(12776,2,4887,0),(12777,10,4887,0),(12778,2,4888,0),(12779,10,4888,0),(12780,2,4889,0),(12781,10,4889,0),(12782,2,4890,0),(12783,10,4890,0),(12784,2,4891,0),(12785,10,4891,0),(12786,2,4892,0),(12787,10,4892,0),(12788,2,4893,0),(12789,10,4893,0),(12790,2,4894,0),(12791,10,4894,0),(12792,2,4895,0),(12793,10,4895,0),(12794,2,4896,0),(12795,10,4896,0),(12796,2,4897,0),(12797,10,4897,0),(12798,2,4898,0),(12799,10,4898,0),(12800,2,4899,0),(12801,10,4899,0),(12802,2,4900,0),(12803,10,4900,0),(12804,2,4901,0),(12805,10,4901,0),(12806,2,4902,0),(12807,10,4902,0),(12808,2,4903,0),(12809,10,4903,0),(12810,2,4904,0),(12811,10,4904,0),(12812,2,4905,0),(12813,10,4905,0),(12814,2,4906,0),(12815,10,4906,0),(12816,2,4907,0),(12817,10,4907,0),(12818,2,4908,0),(12819,10,4908,0),(12820,2,4909,0),(12821,10,4909,0),(12822,2,4910,0),(12823,10,4910,0),(12824,2,4911,0),(12825,10,4911,0),(12826,2,4912,0),(12827,10,4912,0),(12828,2,4913,0),(12829,10,4913,0),(12830,2,4914,0),(12831,10,4914,0),(12832,2,4915,0),(12833,10,4915,0),(12834,2,4916,0),(12835,10,4916,0),(12836,2,4917,0),(12837,10,4917,0),(12838,2,4918,0),(12839,10,4918,0),(12840,2,4919,0),(12841,10,4919,0),(12842,2,4920,0),(12843,10,4920,0),(12844,2,4921,0),(12845,10,4921,0),(12846,2,4922,0),(12847,10,4922,0),(12848,2,4923,0),(12849,10,4923,0),(12850,2,4924,0),(12851,10,4924,0),(12852,2,4925,0),(12853,10,4925,0),(12854,2,4926,0),(12855,10,4926,0),(12856,2,4927,0),(12857,10,4927,0),(12858,2,4928,0),(12859,10,4928,0),(12860,2,4929,0),(12861,10,4929,0),(12862,2,4930,0),(12863,10,4930,0),(12864,2,4931,0),(12865,10,4931,0),(12866,2,4932,0),(12867,10,4932,0),(12868,2,4933,0),(12869,10,4933,0),(12870,2,4934,0),(12871,10,4934,0),(12872,2,4935,0),(12873,10,4935,0),(12874,2,4936,0),(12875,10,4936,0),(12876,2,4937,0),(12877,10,4937,0),(12878,2,4938,0),(12879,10,4938,0),(12880,2,4939,0),(12881,10,4939,0),(12882,2,4940,0),(12883,10,4940,0),(12884,2,4941,0),(12885,10,4941,0),(12886,2,4942,0),(12887,10,4942,0),(12888,2,4943,0),(12889,10,4943,0),(12890,2,4944,0),(12891,10,4944,0),(12892,2,4945,0),(12893,10,4945,0),(12894,2,4946,0),(12895,10,4946,0),(12896,2,4947,0),(12897,10,4947,0),(12898,2,4948,0),(12899,10,4948,0),(12900,2,4949,0),(12901,10,4949,0),(12902,2,4950,0),(12903,10,4950,0),(12904,2,4951,0),(12905,10,4951,0),(12906,2,4952,0),(12907,10,4952,0),(12908,2,4953,0),(12909,10,4953,0),(12910,2,4954,0),(12911,10,4954,0),(12912,2,4955,0),(12913,10,4955,0),(12914,2,4956,0),(12915,10,4956,0),(12916,2,4957,0),(12917,10,4957,0),(12918,2,4958,0),(12919,10,4958,0),(12920,2,4959,0),(12921,10,4959,0),(12922,2,4960,0),(12923,10,4960,0),(12924,2,4961,0),(12925,10,4961,0),(12926,2,4962,0),(12927,10,4962,0),(12928,2,4963,0),(12929,10,4963,0),(12930,2,4964,0),(12931,10,4964,0),(12932,2,4965,0),(12933,10,4965,0),(12934,2,4966,0),(12935,10,4966,0),(12936,2,4967,0),(12937,10,4967,0),(12938,2,4968,0),(12939,10,4968,0),(12940,2,4969,0),(12941,10,4969,0),(12942,2,4970,0),(12943,10,4970,0),(12944,2,4971,0),(12945,10,4971,0),(12946,2,4972,0),(12947,10,4972,0),(12948,2,4973,0),(12949,10,4973,0),(12950,2,4974,0),(12951,10,4974,0),(12952,2,4975,0),(12953,10,4975,0),(12954,2,4976,0),(12955,10,4976,0),(12956,2,4977,0),(12957,10,4977,0),(12958,2,4978,0),(12959,10,4978,0),(12960,2,4979,0),(12961,10,4979,0),(12962,2,4980,0),(12963,10,4980,0),(12964,2,4981,0),(12965,10,4981,0),(12966,2,4982,0),(12967,10,4982,0),(12968,2,4983,0),(12969,10,4983,0),(12970,2,4984,0),(12971,10,4984,0),(12972,2,4985,0),(12973,10,4985,0),(12974,2,4986,0),(12975,10,4986,0),(12976,2,4987,0),(12977,10,4987,0),(12978,2,4988,0),(12979,10,4988,0),(12980,2,4989,0),(12981,10,4989,0),(12982,2,4990,0),(12983,10,4990,0),(12984,2,4991,0),(12985,10,4991,0),(12986,2,4992,0),(12987,10,4992,0),(12988,2,4993,0),(12989,10,4993,0),(12990,2,4994,0),(12991,10,4994,0),(12992,2,4995,0),(12993,10,4995,0),(12994,2,4996,0),(12995,10,4996,0),(12996,2,4997,0),(12997,10,4997,0),(12998,2,4998,0),(12999,10,4998,0),(13000,2,4999,0),(13001,10,4999,0),(13002,2,5000,0),(13003,10,5000,0),(13004,2,5001,0),(13005,10,5001,0),(13006,2,5002,0),(13007,10,5002,0),(13008,2,5003,0),(13009,10,5003,0),(13010,2,5004,0),(13011,10,5004,0),(13012,2,5005,0),(13013,10,5005,0),(13014,2,5006,0),(13015,10,5006,0),(13016,2,5007,0),(13017,10,5007,0),(13018,2,5008,0),(13019,10,5008,0),(13020,2,5009,0),(13021,10,5009,0),(13022,2,5010,0),(13023,10,5010,0),(13024,2,5011,0),(13025,10,5011,0),(13026,2,5012,0),(13027,10,5012,0),(13028,2,5013,0),(13029,10,5013,0),(13030,2,5014,0),(13031,10,5014,0),(13032,2,5015,0),(13033,10,5015,0),(13034,2,5016,0),(13035,10,5016,0),(13036,2,5017,0),(13037,10,5017,0),(13038,2,5018,0),(13039,10,5018,0),(13040,2,5019,0),(13041,10,5019,0),(13042,2,5020,0),(13043,10,5020,0),(13044,2,5021,0),(13045,10,5021,0),(13046,2,5022,0),(13047,10,5022,0),(13048,2,5023,0),(13049,10,5023,0),(13050,2,5024,0),(13051,10,5024,0),(13052,2,5025,0),(13053,10,5025,0),(13054,2,5026,0),(13055,10,5026,0),(13056,2,5027,0),(13057,10,5027,0),(13058,2,5028,0),(13059,10,5028,0),(13060,2,5029,0),(13061,10,5029,0),(13062,2,5030,0),(13063,10,5030,0),(13064,2,5031,0),(13065,10,5031,0),(13066,2,5032,0),(13067,10,5032,0),(13068,2,5033,0),(13069,10,5033,0),(13070,2,5034,0),(13071,10,5034,0),(13072,2,5035,0),(13073,10,5035,0),(13074,2,5036,0),(13075,10,5036,0),(13076,2,5037,0),(13077,10,5037,0),(13078,2,5038,0),(13079,10,5038,0),(13080,2,5039,0),(13081,10,5039,0),(13082,2,5040,0),(13083,10,5040,0),(13084,2,5041,0),(13085,10,5041,0),(13086,2,5042,0),(13087,10,5042,0),(13088,2,5043,0),(13089,10,5043,0),(13090,2,5044,0),(13091,10,5044,0),(13092,2,5045,0),(13093,10,5045,0),(13094,2,5046,0),(13095,10,5046,0),(13096,2,5047,0),(13097,10,5047,0),(13098,2,5048,0),(13099,10,5048,0),(13100,2,5049,0),(13101,10,5049,0),(13102,2,5050,0),(13103,10,5050,0),(13104,2,5051,0),(13105,10,5051,0),(13106,2,5052,0),(13107,10,5052,0),(13108,2,5053,0),(13109,10,5053,0),(13110,2,5054,0),(13111,10,5054,0),(13112,2,5055,0),(13113,10,5055,0),(13114,2,5056,0),(13115,10,5056,0),(13116,2,5057,0),(13117,10,5057,0),(13118,2,5058,0),(13119,10,5058,0),(13120,2,5059,0),(13121,10,5059,0),(13122,2,5060,0),(13123,10,5060,0),(13124,2,5061,0),(13125,10,5061,0),(13126,2,5062,0),(13127,10,5062,0),(13128,2,5063,0),(13129,10,5063,0),(13130,2,5064,0),(13131,10,5064,0),(13132,2,5065,0),(13133,10,5065,0),(13134,2,5066,0),(13135,10,5066,0),(13136,2,5067,0),(13137,10,5067,0),(13138,2,5068,0),(13139,10,5068,0),(13140,2,5069,0),(13141,10,5069,0),(13142,2,5070,0),(13143,10,5070,0),(13144,2,5071,0),(13145,10,5071,0),(13146,2,5072,0),(13147,10,5072,0),(13148,2,5073,0),(13149,10,5073,0),(13150,2,5074,0),(13151,10,5074,0),(13152,2,5075,0),(13153,10,5075,0),(13154,2,5076,0),(13155,10,5076,0),(13156,2,5077,0),(13157,10,5077,0),(13158,2,5078,0),(13159,10,5078,0),(13160,2,5079,0),(13161,10,5079,0),(13162,2,5080,0),(13163,10,5080,0),(13164,2,5081,0),(13165,10,5081,0),(13166,2,5082,0),(13167,10,5082,0),(13168,2,5083,0),(13169,10,5083,0),(13170,2,5084,0),(13171,10,5084,0),(13172,2,5085,0),(13173,10,5085,0),(13174,2,5086,0),(13175,10,5086,0),(13176,2,5087,0),(13177,10,5087,0),(13178,2,5088,0),(13179,10,5088,0),(13180,2,5089,0),(13181,10,5089,0),(13182,2,5090,0),(13183,10,5090,0),(13184,2,5091,0),(13185,10,5091,0),(13186,2,5092,0),(13187,10,5092,0),(13188,2,5093,0),(13189,10,5093,0),(13190,2,5094,0),(13191,10,5094,0),(13192,2,5095,0),(13193,10,5095,0),(13194,2,5096,0),(13195,10,5096,0),(13196,2,5097,0),(13197,10,5097,0),(13198,2,5098,0),(13199,10,5098,0),(13200,2,5099,0),(13201,10,5099,0),(13202,2,5100,0),(13203,10,5100,0),(13204,2,5101,0),(13205,10,5101,0),(13206,2,5102,0),(13207,10,5102,0),(13208,2,5103,0),(13209,10,5103,0),(13210,2,5104,0),(13211,10,5104,0),(13212,2,5105,0),(13213,10,5105,0),(13214,2,5106,0),(13215,10,5106,0),(13216,2,5107,0),(13217,10,5107,0),(13218,2,5108,0),(13219,10,5108,0),(13220,2,5109,0),(13221,10,5109,0),(13222,2,5110,0),(13223,10,5110,0),(13224,2,5111,0),(13225,10,5111,0),(13226,2,5112,0),(13227,10,5112,0),(13228,2,5113,0),(13229,10,5113,0),(13230,2,5114,0),(13231,10,5114,0),(13232,2,5115,0),(13233,10,5115,0),(13234,2,5116,0),(13235,10,5116,0),(13236,2,5117,0),(13237,10,5117,0),(13238,2,5118,0),(13239,10,5118,0),(13240,2,5119,0),(13241,10,5119,0),(13242,2,5120,0),(13243,10,5120,0),(13244,2,5121,0),(13245,10,5121,0),(13246,2,5122,0),(13247,10,5122,0),(13248,2,5123,0),(13249,10,5123,0),(13250,2,5124,0),(13251,10,5124,0),(13252,2,5125,0),(13253,10,5125,0),(13254,2,5126,0),(13255,10,5126,0),(13256,2,5127,0),(13257,10,5127,0),(13258,2,5128,0),(13259,10,5128,0),(13260,2,5129,0),(13261,10,5129,0),(13262,2,5130,0),(13263,10,5130,0),(13264,2,5131,0),(13265,10,5131,0),(13266,2,5132,0),(13267,10,5132,0),(13268,2,5133,0),(13269,10,5133,0),(13270,2,5134,0),(13271,10,5134,0),(13272,2,5135,0),(13273,10,5135,0),(13274,2,5136,0),(13275,10,5136,0),(13276,2,5137,0),(13277,10,5137,0),(13278,2,5138,0),(13279,10,5138,0),(13280,2,5139,0),(13281,10,5139,0),(13282,2,5140,0),(13283,10,5140,0),(13284,2,5141,0),(13285,10,5141,0),(13286,2,5142,0),(13287,10,5142,0),(13288,2,5143,0),(13289,10,5143,0),(13290,2,5144,0),(13291,10,5144,0),(13292,2,5145,0),(13293,10,5145,0),(13294,2,5146,0),(13295,10,5146,0),(13296,2,5147,0),(13297,10,5147,0),(13298,2,5148,0),(13299,10,5148,0),(13300,2,5149,0),(13301,10,5149,0),(13302,2,5150,0),(13303,10,5150,0),(13304,2,5151,0),(13305,10,5151,0),(13306,2,5152,0),(13307,10,5152,0),(13308,2,5153,0),(13309,10,5153,0),(13310,2,5154,0),(13311,10,5154,0),(13312,2,5155,0),(13313,10,5155,0),(13314,2,5156,0),(13315,10,5156,0),(13316,2,5157,0),(13317,10,5157,0),(13318,2,5158,0),(13319,10,5158,0),(13320,2,5159,0),(13321,10,5159,0),(13322,2,5160,0),(13323,10,5160,0),(13324,2,5161,0),(13325,10,5161,0),(13326,2,5162,0),(13327,10,5162,0),(13328,2,5163,0),(13329,10,5163,0),(13330,2,5164,0),(13331,10,5164,0),(13332,2,5165,0),(13333,10,5165,0),(13334,2,5166,0),(13335,10,5166,0),(13336,2,5167,0),(13337,10,5167,0),(13338,2,5168,0),(13339,10,5168,0),(13340,2,5169,0),(13341,10,5169,0),(13342,2,5170,0),(13343,10,5170,0),(13344,2,5171,0),(13345,10,5171,0),(13346,2,5172,0),(13347,10,5172,0),(13348,2,5173,0),(13349,10,5173,0),(13350,2,5174,0),(13351,10,5174,0),(13352,2,5175,0),(13353,10,5175,0),(13354,2,5176,0),(13355,10,5176,0),(13356,2,5177,0),(13357,10,5177,0),(13358,2,5178,0),(13359,10,5178,0),(13360,2,5179,0),(13361,10,5179,0),(13362,2,5180,0),(13363,10,5180,0),(13364,2,5181,0),(13365,10,5181,0),(13366,2,5182,0),(13367,10,5182,0),(13368,2,5183,0),(13369,10,5183,0),(13370,2,5184,0),(13371,10,5184,0),(13372,2,5185,0),(13373,10,5185,0),(13374,2,5186,0),(13375,10,5186,0),(13376,2,5187,0),(13377,10,5187,0),(13378,2,5188,0),(13379,10,5188,0),(13380,2,5189,0),(13381,10,5189,0),(13382,2,5190,0),(13383,10,5190,0),(13384,2,5191,0),(13385,10,5191,0),(13386,2,5192,0),(13387,10,5192,0),(13388,2,5193,0),(13389,10,5193,0),(13390,2,5194,0),(13391,10,5194,0),(13392,2,5195,0),(13393,10,5195,0),(13394,2,5196,0),(13395,10,5196,0),(13396,2,5197,0),(13397,10,5197,0),(13398,2,5198,0),(13399,10,5198,0),(13400,2,5199,0),(13401,10,5199,0),(13402,2,5200,0),(13403,10,5200,0),(13404,2,5201,0),(13405,10,5201,0),(13406,2,5202,0),(13407,10,5202,0),(13408,2,5203,0),(13409,10,5203,0),(13410,2,5204,0),(13411,10,5204,0),(13412,2,5205,0),(13413,10,5205,0),(13414,2,5206,0),(13415,10,5206,0),(13416,2,5207,0),(13417,10,5207,0),(13418,2,5208,0),(13419,10,5208,0),(13420,2,5209,0),(13421,10,5209,0),(13422,2,5210,0),(13423,10,5210,0),(13424,2,5211,0),(13425,10,5211,0),(13426,2,5212,0),(13427,10,5212,0),(13428,2,5213,0),(13429,10,5213,0),(13430,2,5214,0),(13431,10,5214,0),(13432,2,5215,0),(13433,10,5215,0),(13434,2,5216,0),(13435,10,5216,0),(13436,2,5217,0),(13437,10,5217,0),(13438,2,5218,0),(13439,10,5218,0),(13440,2,5219,0),(13441,10,5219,0),(13442,2,5220,0),(13443,10,5220,0),(13444,2,5221,0),(13445,10,5221,0),(13446,2,5222,0),(13447,10,5222,0),(13448,2,5223,0),(13449,10,5223,0),(13450,2,5224,0),(13451,10,5224,0),(13452,2,5225,0),(13453,10,5225,0),(13454,2,5226,0),(13455,10,5226,0),(13456,2,5227,0),(13457,10,5227,0),(13458,2,5228,0),(13459,10,5228,0),(13460,2,5229,0),(13461,10,5229,0),(13462,2,5230,0),(13463,10,5230,0),(13464,2,5231,0),(13465,10,5231,0),(13466,2,5232,0),(13467,10,5232,0),(13468,2,5233,0),(13469,10,5233,0),(13470,2,5234,0),(13471,10,5234,0),(13472,2,5235,0),(13473,10,5235,0),(13474,2,5236,0),(13475,10,5236,0),(13476,2,5237,0),(13477,10,5237,0),(13478,2,5238,0),(13479,10,5238,0),(13480,2,5239,0),(13481,10,5239,0),(13482,2,5240,0),(13483,10,5240,0),(13484,2,5241,0),(13485,10,5241,0),(13486,2,5242,0),(13487,10,5242,0),(13488,2,5243,0),(13489,10,5243,0),(13490,2,5244,0),(13491,10,5244,0),(13492,2,5245,0),(13493,10,5245,0),(13494,2,5246,0),(13495,10,5246,0),(13496,2,5247,0),(13497,10,5247,0),(13498,2,5248,0),(13499,10,5248,0),(13500,2,5249,0),(13501,10,5249,0),(13502,2,5250,0),(13503,10,5250,0),(13504,2,5251,0),(13505,10,5251,0),(13506,2,5252,0),(13507,10,5252,0),(13508,2,5253,0),(13509,10,5253,0),(13510,2,5254,0),(13511,10,5254,0),(13512,2,5255,0),(13513,10,5255,0),(13514,2,5256,0),(13515,10,5256,0),(13516,2,5257,0),(13517,10,5257,0),(13518,2,5258,0),(13519,10,5258,0),(13520,2,5259,0),(13521,10,5259,0),(13522,2,5260,0),(13523,10,5260,0),(13524,2,5261,0),(13525,10,5261,0),(13526,2,5262,0),(13527,10,5262,0),(13528,2,5263,0),(13529,10,5263,0),(13530,2,5264,0),(13531,10,5264,0),(13532,2,5265,0),(13533,10,5265,0),(13534,2,5266,0),(13535,10,5266,0),(13536,2,5267,0),(13537,10,5267,0),(13538,2,5268,0),(13539,10,5268,0),(13540,2,5269,0),(13541,10,5269,0),(13542,2,5270,0),(13543,10,5270,0),(13544,2,5271,0),(13545,10,5271,0),(13546,2,5272,0),(13547,10,5272,0),(13548,2,5273,0),(13549,10,5273,0),(13550,2,5274,0),(13551,10,5274,0),(13552,2,5275,0),(13553,10,5275,0),(13554,2,5276,0),(13555,10,5276,0),(13556,2,5277,0),(13557,10,5277,0),(13558,2,5278,0),(13559,10,5278,0),(13560,2,5279,0),(13561,10,5279,0),(13562,2,5280,0),(13563,10,5280,0),(13564,2,5281,0),(13565,10,5281,0),(13566,2,5282,0),(13567,10,5282,0),(13568,2,5283,0),(13569,10,5283,0),(13570,2,5284,0),(13571,10,5284,0),(13572,2,5285,0),(13573,10,5285,0),(13574,2,5286,0),(13575,10,5286,0),(13576,2,5287,0),(13577,10,5287,0),(13578,2,5288,0),(13579,10,5288,0),(13580,2,5289,0),(13581,10,5289,0),(13582,2,5290,0),(13583,10,5290,0),(13584,2,5291,0),(13585,10,5291,0),(13586,2,5292,0),(13587,10,5292,0),(13588,2,5293,0),(13589,10,5293,0),(13590,2,5294,0),(13591,10,5294,0),(13592,2,5295,0),(13593,10,5295,0),(13594,2,5296,0),(13595,10,5296,0),(13596,2,5297,0),(13597,10,5297,0),(13598,2,5298,0),(13599,10,5298,0),(13600,2,5299,0),(13601,10,5299,0),(13602,2,5300,0),(13603,10,5300,0),(13604,2,5301,0),(13605,10,5301,0),(13606,2,5302,0),(13607,10,5302,0),(13608,2,5303,0),(13609,10,5303,0),(13610,2,5304,0),(13611,10,5304,0),(13612,2,5305,0),(13613,10,5305,0),(13614,2,5306,0),(13615,10,5306,0),(13616,2,5307,0),(13617,10,5307,0),(13618,2,5308,0),(13619,10,5308,0),(13620,2,5309,0),(13621,10,5309,0),(13622,2,5310,0),(13623,10,5310,0),(13624,2,5311,0),(13625,10,5311,0),(13626,2,5312,0),(13627,10,5312,0),(13628,2,5313,0),(13629,10,5313,0),(13630,2,5314,0),(13631,10,5314,0),(13632,2,5315,0),(13633,10,5315,0),(13634,2,5316,0),(13635,10,5316,0),(13636,2,5317,0),(13637,10,5317,0),(13638,2,5318,0),(13639,10,5318,0),(13640,2,5319,0),(13641,10,5319,0),(13642,2,5320,0),(13643,10,5320,0),(13644,2,5321,0),(13645,10,5321,0),(13646,2,5322,0),(13647,10,5322,0),(13648,2,5323,0),(13649,10,5323,0),(13650,2,5324,0),(13651,10,5324,0),(13652,2,5325,0),(13653,10,5325,0),(13654,2,5326,0),(13655,10,5326,0),(13656,2,5327,0),(13657,10,5327,0),(13658,2,5328,0),(13659,10,5328,0),(13660,2,5329,0),(13661,10,5329,0),(13662,2,5330,0),(13663,10,5330,0),(13664,2,5331,0),(13665,10,5331,0),(13666,2,5332,0),(13667,10,5332,0),(13668,2,5333,0),(13669,10,5333,0),(13670,2,5334,0),(13671,10,5334,0),(13672,2,5335,0),(13673,10,5335,0),(13674,2,5336,0),(13675,10,5336,0),(13676,2,5337,0),(13677,10,5337,0),(13678,2,5338,0),(13679,10,5338,0),(13680,2,5339,0),(13681,10,5339,0),(13682,2,5340,0),(13683,10,5340,0),(13684,2,5341,0),(13685,10,5341,0),(13686,2,5342,0),(13687,10,5342,0),(13688,2,5343,0),(13689,10,5343,0),(13690,2,5344,0),(13691,10,5344,0),(13692,2,5345,0),(13693,10,5345,0),(13694,2,5346,0),(13695,10,5346,0),(13696,2,5347,0),(13697,10,5347,0),(13698,2,5348,0),(13699,10,5348,0),(13700,2,5349,0),(13701,10,5349,0),(13702,2,5350,0),(13703,10,5350,0),(13704,2,5351,0),(13705,10,5351,0),(13706,2,5352,0),(13707,10,5352,0),(13708,2,5353,0),(13709,10,5353,0),(13710,2,5354,0),(13711,10,5354,0),(13712,2,5355,0),(13713,10,5355,0),(13714,2,5356,0),(13715,10,5356,0),(13716,2,5357,0),(13717,10,5357,0),(13718,2,5358,0),(13719,10,5358,0),(13720,2,5359,0),(13721,10,5359,0),(13722,2,5360,0),(13723,10,5360,0),(13724,2,5361,0),(13725,10,5361,0),(13726,2,5362,0),(13727,10,5362,0),(13728,2,5363,0),(13729,10,5363,0),(13730,2,5364,0),(13731,10,5364,0),(13732,2,5365,0),(13733,10,5365,0),(13734,2,5366,0),(13735,10,5366,0),(13736,2,5367,0),(13737,10,5367,0),(13738,2,5368,0),(13739,10,5368,0),(13740,2,5369,0),(13741,10,5369,0),(13742,2,5370,0),(13743,10,5370,0),(13744,2,5371,0),(13745,10,5371,0),(13746,2,5372,0),(13747,10,5372,0),(13748,2,5373,0),(13749,10,5373,0),(13750,2,5374,0),(13751,10,5374,0),(13752,2,5375,0),(13753,10,5375,0),(13754,2,5376,0),(13755,10,5376,0),(13756,2,5377,0),(13757,10,5377,0),(13758,2,5378,0),(13759,10,5378,0),(13760,2,5379,0),(13761,10,5379,0),(13762,2,5380,0),(13763,10,5380,0),(13764,2,5381,0),(13765,10,5381,0),(13766,2,5382,0),(13767,10,5382,0),(13768,2,5383,0),(13769,10,5383,0),(13770,2,5384,0),(13771,10,5384,0),(13772,2,5385,0),(13773,10,5385,0),(13774,2,5386,0),(13775,10,5386,0),(13776,2,5387,0),(13777,10,5387,0),(13778,2,5388,0),(13779,10,5388,0),(13780,2,5389,0),(13781,10,5389,0),(13782,2,5390,0),(13783,10,5390,0),(13784,2,5391,0),(13785,10,5391,0),(13786,2,5392,0),(13787,10,5392,0),(13788,2,5393,0),(13789,10,5393,0),(13790,2,5394,0),(13791,10,5394,0),(13792,2,5395,0),(13793,10,5395,0),(13794,2,5396,0),(13795,10,5396,0),(13796,2,5397,0),(13797,10,5397,0),(13798,2,5398,0),(13799,10,5398,0),(13800,2,5399,0),(13801,10,5399,0),(13802,2,5400,0),(13803,10,5400,0),(13804,2,5401,0),(13805,10,5401,0),(13806,2,5402,0),(13807,10,5402,0),(13808,2,5403,0),(13809,10,5403,0),(13810,2,5404,0),(13811,10,5404,0),(13812,2,5405,0),(13813,10,5405,0),(13814,2,5406,0),(13815,10,5406,0),(13816,2,5407,0),(13817,10,5407,0),(13818,2,5408,0),(13819,10,5408,0),(13820,2,5409,0),(13821,10,5409,0),(13822,2,5410,0),(13823,10,5410,0),(13824,2,5411,0),(13825,10,5411,0),(13826,2,5412,0),(13827,10,5412,0),(13828,2,5413,0),(13829,10,5413,0),(13830,2,5414,0),(13831,10,5414,0),(13832,2,5415,0),(13833,10,5415,0),(13834,2,5416,0),(13835,10,5416,0),(13836,2,5417,0),(13837,10,5417,0),(13838,2,5418,0),(13839,10,5418,0),(13840,2,5419,0),(13841,10,5419,0),(13842,2,5420,0),(13843,10,5420,0),(13844,2,5421,0),(13845,10,5421,0),(13846,2,5422,0),(13847,10,5422,0),(13848,2,5423,0),(13849,10,5423,0),(13850,2,5424,0),(13851,10,5424,0),(13852,2,5425,0),(13853,10,5425,0),(13854,2,5426,0),(13855,10,5426,0),(13856,2,5427,0),(13857,10,5427,0),(13858,2,5428,0),(13859,10,5428,0),(13860,2,5429,0),(13861,10,5429,0),(13862,2,5430,0),(13863,10,5430,0),(13864,2,5431,0),(13865,10,5431,0),(13866,2,5432,0),(13867,10,5432,0),(13868,2,5433,0),(13869,10,5433,0),(13870,2,5434,0),(13871,10,5434,0),(13872,2,5435,0),(13873,10,5435,0),(13874,2,5436,0),(13875,10,5436,0),(13876,2,5437,0),(13877,10,5437,0),(13878,2,5438,0),(13879,10,5438,0),(13880,2,5439,0),(13881,10,5439,0),(13882,2,5440,0),(13883,10,5440,0),(13884,2,5441,0),(13885,10,5441,0),(13886,2,5442,0),(13887,10,5442,0),(13888,2,5443,0),(13889,10,5443,0),(13890,2,5444,0),(13891,10,5444,0),(13892,2,5445,0),(13893,10,5445,0),(13894,2,5446,0),(13895,10,5446,0),(13896,2,5447,0),(13897,10,5447,0),(13898,2,5448,0),(13899,10,5448,0),(13900,2,5449,0),(13901,10,5449,0),(13902,2,5450,0),(13903,10,5450,0),(13904,2,5451,0),(13905,10,5451,0),(13906,2,5452,0),(13907,10,5452,0),(13908,2,5453,0),(13909,10,5453,0),(13910,2,5454,0),(13911,10,5454,0),(13912,2,5455,0),(13913,10,5455,0),(13914,2,5456,0),(13915,10,5456,0),(13916,2,5457,0),(13917,10,5457,0),(13918,2,5458,0),(13919,10,5458,0),(13920,2,5459,0),(13921,10,5459,0),(13922,2,5460,0),(13923,10,5460,0),(13924,2,5461,0),(13925,10,5461,0),(13926,2,5462,0),(13927,10,5462,0),(13928,2,5463,0),(13929,10,5463,0),(13930,2,5464,0),(13931,10,5464,0),(13932,2,5465,0),(13933,10,5465,0),(13934,2,5466,0),(13935,10,5466,0),(13936,2,5467,0),(13937,10,5467,0),(13938,2,5468,0),(13939,10,5468,0),(13940,2,5469,0),(13941,10,5469,0),(13942,2,5470,0),(13943,10,5470,0),(13944,2,5471,0),(13945,10,5471,0),(13946,2,5472,0),(13947,10,5472,0),(13948,2,5473,0),(13949,10,5473,0),(13950,2,5474,0),(13951,10,5474,0),(13952,2,5475,0),(13953,10,5475,0),(13954,2,5476,0),(13955,10,5476,0),(13956,2,5477,0),(13957,10,5477,0),(13958,2,5478,0),(13959,10,5478,0),(13960,2,5479,0),(13961,10,5479,0),(13962,2,5480,0),(13963,10,5480,0),(13964,2,5481,0),(13965,10,5481,0),(13966,2,5482,0),(13967,10,5482,0),(13968,2,5483,0),(13969,10,5483,0),(13970,2,5484,0),(13971,10,5484,0),(13972,2,5485,0),(13973,10,5485,0),(13974,2,5486,0),(13975,10,5486,0),(13976,2,5487,0),(13977,10,5487,0),(13978,2,5488,0),(13979,10,5488,0),(13980,2,5489,0),(13981,10,5489,0),(13982,2,5490,0),(13983,10,5490,0),(13984,2,5491,0),(13985,10,5491,0),(13986,2,5492,0),(13987,10,5492,0),(13988,2,5493,0),(13989,10,5493,0),(13990,2,5494,0),(13991,10,5494,0),(13992,2,5495,0),(13993,10,5495,0),(13994,2,5496,0),(13995,10,5496,0),(13996,2,5497,0),(13997,10,5497,0),(13998,2,5498,0),(13999,10,5498,0),(14000,2,5499,0),(14001,10,5499,0),(14002,2,5500,0),(14003,10,5500,0),(14004,2,5501,0),(14005,10,5501,0),(14006,2,5502,0),(14007,10,5502,0),(14008,2,5503,0),(14009,10,5503,0),(14010,2,5504,0),(14011,10,5504,0),(14012,2,5505,0),(14013,10,5505,0),(14014,2,5506,0),(14015,10,5506,0),(14016,2,5507,0),(14017,10,5507,0),(14018,2,5508,0),(14019,10,5508,0),(14020,2,5509,0),(14021,10,5509,0),(14022,2,5510,0),(14023,10,5510,0),(14024,2,5511,0),(14025,10,5511,0),(14026,2,5512,0),(14027,10,5512,0),(14028,2,5513,0),(14029,10,5513,0),(14030,2,5514,0),(14031,10,5514,0),(14032,2,5515,0),(14033,10,5515,0),(14034,2,5516,0),(14035,10,5516,0),(14036,2,5517,0),(14037,10,5517,0),(14038,2,5518,0),(14039,10,5518,0),(14040,2,5519,0),(14041,10,5519,0),(14042,2,5520,0),(14043,10,5520,0),(14044,2,5521,0),(14045,10,5521,0),(14046,2,5522,0),(14047,10,5522,0),(14048,2,5523,0),(14049,10,5523,0),(14050,2,5524,0),(14051,10,5524,0),(14052,2,5525,0),(14053,10,5525,0),(14054,2,5526,0),(14055,10,5526,0),(14056,2,5527,0),(14057,10,5527,0),(14058,2,5528,0),(14059,10,5528,0),(14060,2,5529,0),(14061,10,5529,0),(14062,2,5530,0),(14063,10,5530,0),(14064,2,5531,0),(14065,10,5531,0),(14066,2,5532,0),(14067,10,5532,0),(14068,2,5533,0),(14069,10,5533,0),(14070,2,5534,0),(14071,10,5534,0),(14072,2,5535,0),(14073,10,5535,0),(14074,2,5536,0),(14075,10,5536,0),(14076,2,5537,0),(14077,10,5537,0),(14078,2,5538,0),(14079,10,5538,0),(14080,2,5539,0),(14081,10,5539,0),(14082,2,5540,0),(14083,10,5540,0),(14084,2,5541,0),(14085,10,5541,0),(14086,2,5542,0),(14087,10,5542,0),(14088,2,5543,0),(14089,10,5543,0),(14090,2,5544,0),(14091,10,5544,0),(14092,2,5545,0),(14093,10,5545,0),(14094,2,5546,0),(14095,10,5546,0),(14096,2,5547,0),(14097,10,5547,0),(14098,2,5548,0),(14099,10,5548,0),(14100,2,5549,0),(14101,10,5549,0),(14102,2,5550,0),(14103,10,5550,0),(14104,2,5551,0),(14105,10,5551,0),(14106,2,5552,0),(14107,10,5552,0),(14108,2,5553,0),(14109,10,5553,0),(14110,2,5554,0),(14111,10,5554,0),(14112,2,5555,0),(14113,10,5555,0),(14114,2,5556,0),(14115,10,5556,0),(14116,2,5557,0),(14117,10,5557,0),(14118,2,5558,0),(14119,10,5558,0),(14120,2,5559,0),(14121,10,5559,0),(14122,2,5560,0),(14123,10,5560,0),(14124,2,5561,0),(14125,10,5561,0),(14126,2,5562,0),(14127,10,5562,0),(14128,2,5563,0),(14129,10,5563,0),(14130,2,5564,0),(14131,10,5564,0),(14132,2,5565,0),(14133,10,5565,0),(14134,2,5566,0),(14135,10,5566,0),(14136,2,5567,0),(14137,10,5567,0),(14138,2,5568,0),(14139,10,5568,0),(14140,2,5569,0),(14141,10,5569,0),(14142,2,5570,0),(14143,10,5570,0),(14144,2,5571,0),(14145,10,5571,0),(14146,2,5572,0),(14147,10,5572,0),(14148,2,5573,0),(14149,10,5573,0),(14150,2,5574,0),(14151,10,5574,0),(14152,2,5575,0),(14153,10,5575,0),(14154,2,5576,0),(14155,10,5576,0),(14156,2,5577,0),(14157,10,5577,0),(14158,2,5578,0),(14159,10,5578,0),(14160,2,5579,0),(14161,10,5579,0),(14162,2,5580,0),(14163,10,5580,0),(14164,2,5581,0),(14165,10,5581,0),(14166,2,5582,0),(14167,10,5582,0),(14168,2,5583,0),(14169,10,5583,0),(14170,2,5584,0),(14171,10,5584,0),(14172,2,5585,0),(14173,10,5585,0),(14174,2,5586,0),(14175,10,5586,0),(14176,2,5587,0),(14177,10,5587,0),(14178,2,5588,0),(14179,10,5588,0),(14180,2,5589,0),(14181,10,5589,0),(14182,2,5590,0),(14183,10,5590,0),(14184,2,5591,0),(14185,10,5591,0),(14186,2,5592,0),(14187,10,5592,0),(14188,2,5593,0),(14189,10,5593,0),(14190,2,5594,0),(14191,10,5594,0),(14192,2,5595,0),(14193,10,5595,0),(14194,2,5596,0),(14195,10,5596,0),(14196,2,5597,0),(14197,10,5597,0),(14198,2,5598,0),(14199,10,5598,0),(14200,2,5599,0),(14201,10,5599,0),(14202,2,5600,0),(14203,10,5600,0),(14204,2,5601,0),(14205,10,5601,0),(14206,2,5602,0),(14207,10,5602,0),(14208,2,5603,0),(14209,10,5603,0),(14210,2,5604,0),(14211,10,5604,0),(14212,2,5605,0),(14213,10,5605,0),(14214,2,5606,0),(14215,10,5606,0),(14216,2,5607,0),(14217,10,5607,0),(14218,2,5608,0),(14219,10,5608,0),(14220,2,5609,0),(14221,10,5609,0),(14222,2,5610,0),(14223,10,5610,0),(14224,2,5611,0),(14225,10,5611,0),(14226,2,5612,0),(14227,10,5612,0),(14228,2,5613,0),(14229,10,5613,0),(14230,2,5614,0),(14231,10,5614,0),(14232,2,5615,0),(14233,10,5615,0),(14234,2,5616,0),(14235,10,5616,0),(14236,2,5617,0),(14237,10,5617,0),(14238,2,5618,0),(14239,10,5618,0),(14240,2,5619,0),(14241,10,5619,0),(14242,2,5620,0),(14243,10,5620,0),(14244,2,5621,0),(14245,10,5621,0),(14246,2,5622,0),(14247,10,5622,0),(14248,2,5623,0),(14249,10,5623,0),(14250,2,5624,0),(14251,10,5624,0),(14252,2,5625,0),(14253,10,5625,0),(14254,2,5626,0),(14255,10,5626,0),(14256,2,5627,0),(14257,10,5627,0),(14258,2,5628,0),(14259,10,5628,0),(14260,2,5629,0),(14261,10,5629,0),(14262,2,5630,0),(14263,10,5630,0),(14264,2,5631,0),(14265,10,5631,0),(14266,2,5632,0),(14267,10,5632,0),(14268,2,5633,0),(14269,10,5633,0),(14270,2,5634,0),(14271,10,5634,0),(14272,2,5635,0),(14273,10,5635,0),(14274,2,5636,0),(14275,10,5636,0),(14276,2,5637,0),(14277,10,5637,0),(14278,2,5638,0),(14279,10,5638,0),(14280,2,5639,0),(14281,10,5639,0),(14282,2,5640,0),(14283,10,5640,0),(14284,2,5641,0),(14285,10,5641,0),(14286,2,5642,0),(14287,10,5642,0),(14288,2,5643,0),(14289,10,5643,0),(14290,2,5644,0),(14291,10,5644,0),(14292,2,5645,0),(14293,10,5645,0),(14294,2,5646,0),(14295,10,5646,0),(14296,2,5647,0),(14297,10,5647,0),(14298,2,5648,0),(14299,10,5648,0),(14300,2,5649,0),(14301,10,5649,0),(14302,2,5650,0),(14303,10,5650,0),(14304,2,5651,0),(14305,10,5651,0),(14306,2,5652,0),(14307,10,5652,0),(14308,2,5653,0),(14309,10,5653,0),(14310,2,5654,0),(14311,10,5654,0),(14312,2,5655,0),(14313,10,5655,0),(14314,2,5656,0),(14315,10,5656,0),(14316,2,5657,0),(14317,10,5657,0),(14318,2,5658,0),(14319,10,5658,0),(14320,2,5659,0),(14321,10,5659,0),(14322,2,5660,0),(14323,10,5660,0),(14324,2,5661,0),(14325,10,5661,0),(14326,2,5662,0),(14327,10,5662,0),(14328,2,5663,0),(14329,10,5663,0),(14330,2,5664,0),(14331,10,5664,0),(14332,2,5665,0),(14333,10,5665,0),(14334,2,5666,0),(14335,10,5666,0),(14336,2,5667,0),(14337,10,5667,0),(14338,2,5668,0),(14339,10,5668,0),(14340,2,5669,0),(14341,10,5669,0),(14342,2,5670,0),(14343,10,5670,0),(14344,2,5671,0),(14345,10,5671,0),(14346,2,5672,0),(14347,10,5672,0),(14348,2,5673,0),(14349,10,5673,0),(14350,2,5674,0),(14351,10,5674,0),(14352,2,5675,0),(14353,10,5675,0),(14354,2,5676,0),(14355,10,5676,0),(14356,2,5677,0),(14357,10,5677,0),(14358,2,5678,0),(14359,10,5678,0),(14360,2,5679,0),(14361,10,5679,0),(14362,2,5680,0),(14363,10,5680,0),(14364,2,5681,0),(14365,10,5681,0),(14366,2,5682,0),(14367,10,5682,0),(14368,2,5683,0),(14369,10,5683,0),(14370,2,5684,0),(14371,10,5684,0),(14372,2,5685,0),(14373,10,5685,0),(14374,2,5686,0),(14375,10,5686,0),(14376,2,5687,0),(14377,10,5687,0),(14378,2,5688,0),(14379,10,5688,0),(14380,2,5689,0),(14381,10,5689,0),(14382,2,5690,0),(14383,10,5690,0),(14384,2,5691,0),(14385,10,5691,0),(14386,2,5692,0),(14387,10,5692,0),(14388,2,5693,0),(14389,10,5693,0),(14390,2,5694,0),(14391,10,5694,0),(14392,2,5695,0),(14393,10,5695,0),(14394,2,5696,0),(14395,10,5696,0),(14396,2,5697,0),(14397,10,5697,0),(14398,2,5698,0),(14399,10,5698,0),(14400,2,5699,0),(14401,10,5699,0),(14402,2,5700,0),(14403,10,5700,0),(14404,2,5701,0),(14405,10,5701,0),(14406,2,5702,0),(14407,10,5702,0),(14408,2,5703,0),(14409,10,5703,0),(14410,2,5704,0),(14411,10,5704,0),(14412,2,5705,0),(14413,10,5705,0),(14414,2,5706,0),(14415,10,5706,0),(14416,2,5707,0),(14417,10,5707,0),(14418,2,5708,0),(14419,10,5708,0),(14420,2,5709,0),(14421,10,5709,0),(14422,2,5710,0),(14423,10,5710,0),(14424,2,5711,0),(14425,10,5711,0),(14426,2,5712,0),(14427,10,5712,0),(14428,2,5713,0),(14429,10,5713,0),(14430,2,5714,0),(14431,10,5714,0),(14432,2,5715,0),(14433,10,5715,0),(14434,2,5716,0),(14435,10,5716,0),(14436,2,5717,0),(14437,10,5717,0),(14438,2,5718,0),(14439,10,5718,0),(14440,2,5719,0),(14441,10,5719,0),(14442,2,5720,0),(14443,10,5720,0),(14444,2,5721,0),(14445,10,5721,0),(14446,2,5722,0),(14447,10,5722,0),(14448,2,5723,0),(14449,10,5723,0),(14450,2,5724,0),(14451,10,5724,0),(14452,2,5725,0),(14453,10,5725,0),(14454,2,5726,0),(14455,10,5726,0),(14456,2,5727,0),(14457,10,5727,0),(14458,2,5728,0),(14459,10,5728,0),(14460,2,5729,0),(14461,10,5729,0),(14462,2,5730,0),(14463,10,5730,0),(14464,2,5731,0),(14465,10,5731,0),(14466,2,5732,0),(14467,10,5732,0),(14468,2,5733,0),(14469,10,5733,0),(14470,2,5734,0),(14471,10,5734,0),(14472,2,5735,0),(14473,10,5735,0),(14474,2,5736,0),(14475,10,5736,0),(14476,2,5737,0),(14477,10,5737,0),(14478,2,5738,0),(14479,10,5738,0),(14480,2,5739,0),(14481,10,5739,0),(14482,2,5740,0),(14483,10,5740,0),(14484,2,5741,0),(14485,10,5741,0),(14486,2,5742,0),(14487,10,5742,0),(14488,2,5743,0),(14489,10,5743,0),(14490,2,5744,0),(14491,10,5744,0),(14492,2,5745,0),(14493,10,5745,0),(14494,2,5746,0),(14495,10,5746,0),(14496,2,5747,0),(14497,10,5747,0),(14498,2,5748,0),(14499,10,5748,0),(14500,2,5749,0),(14501,10,5749,0),(14502,2,5750,0),(14503,10,5750,0),(14504,2,5751,0),(14505,10,5751,0),(14506,2,5752,0),(14507,10,5752,0),(14508,2,5753,0),(14509,10,5753,0),(14510,2,5754,0),(14511,10,5754,0),(14512,2,5755,0),(14513,10,5755,0),(14514,2,5756,0),(14515,10,5756,0),(14516,2,5757,0),(14517,10,5757,0),(14518,2,5758,0),(14519,10,5758,0),(14520,2,5759,0),(14521,10,5759,0),(14522,2,5760,0),(14523,10,5760,0),(14524,2,5761,0),(14525,10,5761,0),(14526,2,5762,0),(14527,10,5762,0),(14528,2,5763,0),(14529,10,5763,0),(14530,2,5764,0),(14531,10,5764,0),(14532,2,5765,0),(14533,10,5765,0),(14534,2,5766,0),(14535,10,5766,0),(14536,2,5767,0),(14537,10,5767,0),(14538,2,5768,0),(14539,10,5768,0),(14540,2,5769,0),(14541,10,5769,0),(14542,2,5770,0),(14543,10,5770,0),(14544,2,5771,0),(14545,10,5771,0),(14546,2,5772,0),(14547,10,5772,0),(14548,2,5773,0),(14549,10,5773,0),(14550,2,5774,0),(14551,10,5774,0),(14552,2,5775,0),(14553,10,5775,0),(14554,2,5776,0),(14555,10,5776,0),(14556,2,5777,0),(14557,10,5777,0),(14558,2,5778,0),(14559,10,5778,0),(14560,2,5779,0),(14561,10,5779,0),(14562,2,5780,0),(14563,10,5780,0),(14564,2,5781,0),(14565,10,5781,0),(14566,2,5782,0),(14567,10,5782,0),(14568,2,5783,0),(14569,10,5783,0),(14570,2,5784,0),(14571,10,5784,0),(14572,2,5785,0),(14573,10,5785,0),(14574,2,5786,0),(14575,10,5786,0),(14576,2,5787,0),(14577,10,5787,0),(14578,2,5788,0),(14579,10,5788,0),(14580,2,5789,0),(14581,10,5789,0),(14582,2,5790,0),(14583,10,5790,0),(14584,2,5791,0),(14585,10,5791,0),(14586,2,5792,0),(14587,10,5792,0),(14588,2,5793,0),(14589,10,5793,0),(14590,2,5794,0),(14591,10,5794,0),(14592,2,5795,0),(14593,10,5795,0),(14594,2,5796,0),(14595,10,5796,0),(14596,2,5797,0),(14597,10,5797,0),(14598,2,5798,0),(14599,10,5798,0),(14600,2,5799,0),(14601,10,5799,0),(14602,2,5800,0),(14603,10,5800,0),(14604,2,5801,0),(14605,10,5801,0),(14606,2,5802,0),(14607,10,5802,0),(14608,2,5803,0),(14609,10,5803,0),(14610,2,5804,0),(14611,10,5804,0),(14612,2,5805,0),(14613,10,5805,0),(14614,2,5806,0),(14615,10,5806,0),(14616,2,5807,0),(14617,10,5807,0),(14618,2,5808,0),(14619,10,5808,0),(14620,2,5809,0),(14621,10,5809,0),(14622,2,5810,0),(14623,10,5810,0),(14624,2,5811,0),(14625,10,5811,0),(14626,2,5812,0),(14627,10,5812,0),(14628,2,5813,0),(14629,10,5813,0),(14630,2,5814,0),(14631,10,5814,0),(14632,2,5815,0),(14633,10,5815,0),(14634,2,5816,0),(14635,10,5816,0),(14636,2,5817,0),(14637,10,5817,0),(14638,2,5818,0),(14639,10,5818,0),(14640,2,5819,0),(14641,10,5819,0),(14642,2,5820,0),(14643,10,5820,0),(14644,2,5821,0),(14645,10,5821,0),(14646,2,5822,0),(14647,10,5822,0),(14648,2,5823,0),(14649,10,5823,0),(14650,2,5824,0),(14651,10,5824,0),(14652,2,5825,0),(14653,10,5825,0),(14654,2,5826,0),(14655,10,5826,0),(14656,2,5827,0),(14657,10,5827,0),(14658,2,5828,0),(14659,10,5828,0),(14660,2,5829,0),(14661,10,5829,0),(14662,2,5830,0),(14663,10,5830,0),(14664,2,5831,0),(14665,10,5831,0),(14666,2,5832,0),(14667,10,5832,0),(14668,2,5833,0),(14669,10,5833,0),(14670,2,5834,0),(14671,10,5834,0),(14672,2,5835,0),(14673,10,5835,0),(14674,2,5836,0),(14675,10,5836,0),(14676,2,5837,0),(14677,10,5837,0),(14678,2,5838,0),(14679,10,5838,0),(14680,2,5839,0),(14681,10,5839,0),(14682,2,5840,0),(14683,10,5840,0),(14684,2,5841,0),(14685,10,5841,0),(14686,2,5842,0),(14687,10,5842,0),(14688,2,5843,0),(14689,10,5843,0),(14690,2,5844,0),(14691,10,5844,0),(14692,2,5845,0),(14693,10,5845,0),(14694,2,5846,0),(14695,10,5846,0),(14696,2,5847,0),(14697,10,5847,0),(14698,2,5848,0),(14699,10,5848,0),(14700,2,5849,0),(14701,10,5849,0),(14702,2,5850,0),(14703,10,5850,0),(14704,2,5851,0),(14705,10,5851,0),(14706,2,5852,0),(14707,10,5852,0),(14708,2,5853,0),(14709,10,5853,0),(14710,2,5854,0),(14711,10,5854,0),(14712,2,5855,0),(14713,10,5855,0),(14714,2,5856,0),(14715,10,5856,0),(14716,2,5857,0),(14717,10,5857,0),(14718,2,5858,0),(14719,10,5858,0),(14720,2,5859,0),(14721,10,5859,0),(14722,2,5860,0),(14723,10,5860,0),(14724,2,5861,0),(14725,10,5861,0),(14726,2,5862,0),(14727,10,5862,0),(14728,2,5863,0),(14729,10,5863,0),(14730,2,5864,0),(14731,10,5864,0),(14732,2,5865,0),(14733,10,5865,0),(14734,2,5866,0),(14735,10,5866,0),(14736,2,5867,0),(14737,10,5867,0),(14738,2,5868,0),(14739,10,5868,0),(14740,2,5869,0),(14741,10,5869,0),(14742,2,5870,0),(14743,10,5870,0),(14744,2,5871,0),(14745,10,5871,0),(14746,2,5872,0),(14747,10,5872,0),(14748,2,5873,0),(14749,10,5873,0),(14750,2,5874,0),(14751,10,5874,0),(14752,2,5875,0),(14753,10,5875,0),(14754,2,5876,0),(14755,10,5876,0),(14756,2,5877,0),(14757,10,5877,0),(14758,2,5878,0),(14759,10,5878,0),(14760,2,5879,0),(14761,10,5879,0),(14762,2,5880,0),(14763,10,5880,0),(14764,2,5881,0),(14765,10,5881,0),(14766,2,5882,0),(14767,10,5882,0),(14768,2,5883,0),(14769,10,5883,0),(14770,2,5884,0),(14771,10,5884,0),(14772,2,5885,0),(14773,10,5885,0),(14774,2,5886,0),(14775,10,5886,0),(14776,2,5887,0),(14777,10,5887,0),(14778,2,5888,0),(14779,10,5888,0),(14780,2,5889,0),(14781,10,5889,0),(14782,2,5890,0),(14783,10,5890,0),(14784,2,5891,0),(14785,10,5891,0),(14786,2,5892,0),(14787,10,5892,0),(14788,2,5893,0),(14789,10,5893,0),(14790,2,5894,0),(14791,10,5894,0),(14792,2,5895,0),(14793,10,5895,0),(14794,2,5896,0),(14795,10,5896,0),(14796,2,5897,0),(14797,10,5897,0),(14798,2,5898,0),(14799,10,5898,0),(14800,2,5899,0),(14801,10,5899,0),(14802,2,5900,0),(14803,10,5900,0),(14804,2,5901,0),(14805,10,5901,0),(14806,2,5902,0),(14807,10,5902,0),(14808,2,5903,0),(14809,10,5903,0),(14810,2,5904,0),(14811,10,5904,0),(14812,2,5905,0),(14813,10,5905,0),(14814,2,5906,0),(14815,10,5906,0),(14816,2,5907,0),(14817,10,5907,0),(14818,2,5908,0),(14819,10,5908,0),(14820,2,5909,0),(14821,10,5909,0),(14822,2,5910,0),(14823,10,5910,0),(14824,2,5911,0),(14825,10,5911,0),(14826,2,5912,0),(14827,10,5912,0),(14828,2,5913,0),(14829,10,5913,0),(14830,2,5914,0),(14831,10,5914,0),(14832,2,5915,0),(14833,10,5915,0),(14834,2,5916,0),(14835,10,5916,0),(14836,2,5917,0),(14837,10,5917,0),(14838,2,5918,0),(14839,10,5918,0),(14840,2,5919,0),(14841,10,5919,0),(14842,2,5920,0),(14843,10,5920,0),(14844,2,5921,0),(14845,10,5921,0),(14846,2,5922,0),(14847,10,5922,0),(14848,2,5923,0),(14849,10,5923,0),(14850,2,5924,0),(14851,10,5924,0),(14852,2,5925,0),(14853,10,5925,0),(14854,2,5926,0),(14855,10,5926,0),(14856,2,5927,0),(14857,10,5927,0),(14858,2,5928,0),(14859,10,5928,0),(14860,2,5929,0),(14861,10,5929,0),(14862,2,5930,0),(14863,10,5930,0),(14864,2,5931,0),(14865,10,5931,0),(14866,2,5932,0),(14867,10,5932,0),(14868,2,5933,0),(14869,10,5933,0),(14870,2,5934,0),(14871,10,5934,0),(14872,2,5935,0),(14873,10,5935,0),(14874,2,5936,0),(14875,10,5936,0),(14876,2,5937,0),(14877,10,5937,0),(14878,2,5938,0),(14879,10,5938,0),(14880,2,5939,0),(14881,10,5939,0),(14882,2,5940,0),(14883,10,5940,0),(14884,2,5941,0),(14885,10,5941,0),(14886,2,5942,0),(14887,10,5942,0),(14888,2,5943,0),(14889,10,5943,0),(14890,2,5944,0),(14891,10,5944,0),(14892,2,5945,0),(14893,10,5945,0),(14894,2,5946,0),(14895,10,5946,0),(14896,2,5947,0),(14897,10,5947,0),(14898,2,5948,0),(14899,10,5948,0),(14900,2,5949,0),(14901,10,5949,0),(14902,2,5950,0),(14903,10,5950,0),(14904,2,5951,0),(14905,10,5951,0),(14906,2,5952,0),(14907,10,5952,0),(14908,2,5953,0),(14909,10,5953,0),(14910,2,5954,0),(14911,10,5954,0),(14912,2,5955,0),(14913,10,5955,0),(14914,2,5956,0),(14915,10,5956,0),(14916,2,5957,0),(14917,10,5957,0),(14918,2,5958,0),(14919,10,5958,0),(14920,2,5959,0),(14921,10,5959,0),(14922,2,5960,0),(14923,10,5960,0),(14924,2,5961,0),(14925,10,5961,0),(14926,2,5962,0),(14927,10,5962,0),(14928,2,5963,0),(14929,10,5963,0),(14930,2,5964,0),(14931,10,5964,0),(14932,2,5965,0),(14933,10,5965,0),(14934,2,5966,0),(14935,10,5966,0),(14936,2,5967,0),(14937,10,5967,0),(14938,2,5968,0),(14939,10,5968,0),(14940,2,5969,0),(14941,10,5969,0),(14942,2,5970,0),(14943,10,5970,0),(14944,2,5971,0),(14945,10,5971,0),(14946,2,5972,0),(14947,10,5972,0),(14948,2,5973,0),(14949,10,5973,0),(14950,2,5974,0),(14951,10,5974,0),(14952,2,5975,0),(14953,10,5975,0),(14954,2,5976,0),(14955,10,5976,0),(14956,2,5977,0),(14957,10,5977,0),(14958,2,5978,0),(14959,10,5978,0),(14960,2,5979,0),(14961,10,5979,0),(14962,2,5980,0),(14963,10,5980,0),(14964,2,5981,0),(14965,10,5981,0),(14966,2,5982,0),(14967,10,5982,0),(14968,2,5983,0),(14969,10,5983,0),(14970,2,5984,0),(14971,10,5984,0),(14972,2,5985,0),(14973,10,5985,0),(14974,2,5986,0),(14975,10,5986,0),(14976,2,5987,0),(14977,10,5987,0),(14978,2,5988,0),(14979,10,5988,0),(14980,2,5989,0),(14981,10,5989,0),(14982,2,5990,0),(14983,10,5990,0),(14984,2,5991,0),(14985,10,5991,0),(14986,2,5992,0),(14987,10,5992,0),(14988,2,5993,0),(14989,10,5993,0),(14990,2,5994,0),(14991,10,5994,0),(14992,2,5995,0),(14993,10,5995,0),(14994,2,5996,0),(14995,10,5996,0),(14996,2,5997,0),(14997,10,5997,0),(14998,2,5998,0),(14999,10,5998,0),(15000,2,5999,0),(15001,10,5999,0),(15002,2,6000,0),(15003,10,6000,0),(15004,2,6001,0),(15005,10,6001,0),(15006,2,6002,0),(15007,10,6002,0),(15008,2,6003,0),(15009,10,6003,0),(15010,2,6004,0),(15011,10,6004,0),(15012,2,6005,0),(15013,10,6005,0),(15014,2,6006,0),(15015,10,6006,0),(15016,2,6007,0),(15017,10,6007,0),(15018,2,6008,0),(15019,10,6008,0),(15020,2,6009,0),(15021,10,6009,0),(15022,2,6010,0),(15023,10,6010,0),(15024,2,6011,0),(15025,10,6011,0),(15026,2,6012,0),(15027,10,6012,0),(15028,2,6013,0),(15029,10,6013,0),(15030,2,6014,0),(15031,10,6014,0),(15032,2,6015,0),(15033,10,6015,0),(15034,2,6016,0),(15035,10,6016,0),(15036,2,6017,0),(15037,10,6017,0),(15038,2,6018,0),(15039,10,6018,0),(15040,2,6019,0),(15041,10,6019,0),(15042,2,6020,0),(15043,10,6020,0),(15044,2,6021,0),(15045,10,6021,0),(15046,2,6022,0),(15047,10,6022,0),(15048,2,6023,0),(15049,10,6023,0),(15050,2,6024,0),(15051,10,6024,0),(15052,2,6025,0),(15053,10,6025,0),(15054,2,6026,0),(15055,10,6026,0),(15056,2,6027,0),(15057,10,6027,0),(15058,2,6028,0),(15059,10,6028,0),(15060,2,6029,0),(15061,10,6029,0),(15062,2,6030,0),(15063,10,6030,0),(15064,2,6031,0),(15065,10,6031,0),(15066,2,6032,0),(15067,10,6032,0),(15068,2,6033,0),(15069,10,6033,0),(15070,2,6034,0),(15071,10,6034,0),(15072,2,6035,0),(15073,10,6035,0),(15074,2,6036,0),(15075,10,6036,0),(15076,2,6037,0),(15077,10,6037,0),(15078,2,6038,0),(15079,10,6038,0),(15080,2,6039,0),(15081,10,6039,0),(15082,2,6040,0),(15083,10,6040,0),(15084,2,6041,0),(15085,10,6041,0),(15086,2,6042,0),(15087,10,6042,0),(15088,2,6043,0),(15089,10,6043,0),(15090,2,6044,0),(15091,10,6044,0),(15092,2,6045,0),(15093,10,6045,0),(15094,2,6046,0),(15095,10,6046,0),(15096,2,6047,0),(15097,10,6047,0),(15098,2,6048,0),(15099,10,6048,0),(15100,2,6049,0),(15101,10,6049,0),(15102,2,6050,0),(15103,10,6050,0),(15104,2,6051,0),(15105,10,6051,0),(15106,2,6052,0),(15107,10,6052,0),(15108,2,6053,0),(15109,10,6053,0),(15110,2,6054,0),(15111,10,6054,0),(15112,2,6055,0),(15113,10,6055,0),(15114,2,6056,0),(15115,10,6056,0),(15116,2,6057,0),(15117,10,6057,0),(15118,2,6058,0),(15119,10,6058,0),(15120,2,6059,0),(15121,10,6059,0),(15122,2,6060,0),(15123,10,6060,0),(15124,2,6061,0),(15125,10,6061,0),(15126,2,6062,0),(15127,10,6062,0),(15128,2,6063,0),(15129,10,6063,0),(15130,2,6064,0),(15131,10,6064,0),(15132,2,6065,0),(15133,10,6065,0),(15134,2,6066,0),(15135,10,6066,0),(15136,2,6067,0),(15137,10,6067,0),(15138,2,6068,0),(15139,10,6068,0),(15140,2,6069,0),(15141,10,6069,0),(15142,2,6070,0),(15143,10,6070,0),(15144,2,6071,0),(15145,10,6071,0),(15146,2,6072,0),(15147,10,6072,0),(15148,2,6073,0),(15149,10,6073,0),(15150,2,6074,0),(15151,10,6074,0),(15152,2,6075,0),(15153,10,6075,0),(15154,2,6076,0),(15155,10,6076,0),(15156,2,6077,0),(15157,10,6077,0),(15158,2,6078,0),(15159,10,6078,0),(15160,2,6079,0),(15161,10,6079,0),(15162,2,6080,0),(15163,10,6080,0),(15164,2,6081,0),(15165,10,6081,0),(15166,2,6082,0),(15167,10,6082,0),(15168,2,6083,0),(15169,10,6083,0),(15170,2,6084,0),(15171,10,6084,0),(15172,2,6085,0),(15173,10,6085,0),(15174,2,6086,0),(15175,10,6086,0),(15176,2,6087,0),(15177,10,6087,0),(15178,2,6088,0),(15179,10,6088,0),(15180,2,6089,0),(15181,10,6089,0),(15182,2,6090,0),(15183,10,6090,0),(15184,2,6091,0),(15185,10,6091,0),(15186,2,6092,0),(15187,10,6092,0),(15188,2,6093,0),(15189,10,6093,0),(15190,2,6094,0),(15191,10,6094,0),(15192,2,6095,0),(15193,10,6095,0),(15194,2,6096,0),(15195,10,6096,0),(15196,2,6097,0),(15197,10,6097,0),(15198,2,6098,0),(15199,10,6098,0),(15200,2,6099,0),(15201,10,6099,0),(15202,2,6100,0),(15203,10,6100,0),(15204,2,6101,0),(15205,10,6101,0),(15206,2,6102,0),(15207,10,6102,0),(15208,2,6103,0),(15209,10,6103,0),(15210,2,6104,0),(15211,10,6104,0),(15212,2,6105,0),(15213,10,6105,0),(15214,2,6106,0),(15215,10,6106,0),(15216,2,6107,0),(15217,10,6107,0),(15218,2,6108,0),(15219,10,6108,0),(15220,2,6109,0),(15221,10,6109,0),(15222,2,6110,0),(15223,10,6110,0),(15224,2,6111,0),(15225,10,6111,0),(15226,2,6112,0),(15227,10,6112,0),(15228,2,6113,0),(15229,10,6113,0),(15230,2,6114,0),(15231,10,6114,0),(15232,2,6115,0),(15233,10,6115,0),(15234,2,6116,0),(15235,10,6116,0),(15236,2,6117,0),(15237,10,6117,0),(15238,2,6118,0),(15239,10,6118,0),(15240,2,6119,0),(15241,10,6119,0),(15242,2,6120,0),(15243,10,6120,0),(15244,2,6121,0),(15245,10,6121,0),(15246,2,6122,0),(15247,10,6122,0),(15248,2,6123,0),(15249,10,6123,0),(15250,2,6124,0),(15251,10,6124,0),(15252,2,6125,0),(15253,10,6125,0),(15254,2,6126,0),(15255,10,6126,0),(15256,2,6127,0),(15257,10,6127,0),(15258,2,6128,0),(15259,10,6128,0),(15260,2,6129,0),(15261,10,6129,0),(15262,2,6130,0),(15263,10,6130,0),(15264,2,6131,0),(15265,10,6131,0),(15266,2,6132,0),(15267,10,6132,0),(15268,2,6133,0),(15269,10,6133,0),(15270,2,6134,0),(15271,10,6134,0),(15272,2,6135,0),(15273,10,6135,0),(15274,2,6136,0),(15275,10,6136,0),(15276,2,6137,0),(15277,10,6137,0),(15278,2,6138,0),(15279,10,6138,0),(15280,2,6139,0),(15281,10,6139,0),(15282,2,6140,0),(15283,10,6140,0),(15284,2,6141,0),(15285,10,6141,0),(15286,2,6142,0),(15287,10,6142,0),(15288,2,6143,0),(15289,10,6143,0),(15290,2,6144,0),(15291,10,6144,0),(15292,2,6145,0),(15293,10,6145,0),(15294,2,6146,0),(15295,10,6146,0),(15296,2,6147,0),(15297,10,6147,0),(15298,2,6148,0),(15299,10,6148,0),(15300,2,6149,0),(15301,10,6149,0),(15302,2,6150,0),(15303,10,6150,0),(15304,2,6151,0),(15305,10,6151,0),(15306,2,6152,0),(15307,10,6152,0),(15308,2,6153,0),(15309,10,6153,0),(15310,2,6154,0),(15311,10,6154,0),(15312,2,6155,0),(15313,10,6155,0),(15314,2,6156,0),(15315,10,6156,0),(15316,2,6157,0),(15317,10,6157,0),(15318,2,6158,0),(15319,10,6158,0),(15320,2,6159,0),(15321,10,6159,0),(15322,2,6160,0),(15323,10,6160,0),(15324,2,6161,0),(15325,10,6161,0),(15326,2,6162,0),(15327,10,6162,0),(15328,2,6163,0),(15329,10,6163,0),(15330,2,6164,0),(15331,10,6164,0),(15332,2,6165,0),(15333,10,6165,0),(15334,2,6166,0),(15335,10,6166,0),(15336,2,6167,0),(15337,10,6167,0),(15338,2,6168,0),(15339,10,6168,0),(15340,2,6169,0),(15341,10,6169,0),(15342,2,6170,0),(15343,10,6170,0),(15344,2,6171,0),(15345,10,6171,0),(15346,2,6172,0),(15347,10,6172,0),(15348,2,6173,0),(15349,10,6173,0),(15350,2,6174,0),(15351,10,6174,0),(15352,2,6175,0),(15353,10,6175,0),(15354,2,6176,0),(15355,10,6176,0),(15356,2,6177,0),(15357,10,6177,0),(15358,2,6178,0),(15359,10,6178,0),(15360,2,6179,0),(15361,10,6179,0),(15362,2,6180,0),(15363,10,6180,0),(15364,2,6181,0),(15365,10,6181,0),(15366,2,6182,0),(15367,10,6182,0),(15368,2,6183,0),(15369,10,6183,0),(15370,2,6184,0),(15371,10,6184,0),(15372,2,6185,0),(15373,10,6185,0),(15374,2,6186,0),(15375,10,6186,0),(15376,2,6187,0),(15377,10,6187,0),(15378,2,6188,0),(15379,10,6188,0),(15380,2,6189,0),(15381,10,6189,0),(15382,2,6190,0),(15383,10,6190,0),(15384,2,6191,0),(15385,10,6191,0),(15386,2,6192,0),(15387,10,6192,0),(15388,2,6193,0),(15389,10,6193,0),(15390,2,6194,0),(15391,10,6194,0),(15392,2,6195,0),(15393,10,6195,0),(15394,2,6196,0),(15395,10,6196,0),(15396,2,6197,0),(15397,10,6197,0),(15398,2,6198,0),(15399,10,6198,0),(15400,2,6199,0),(15401,10,6199,0),(15402,2,6200,0),(15403,10,6200,0),(15404,2,6201,0),(15405,10,6201,0),(15406,2,6202,0),(15407,10,6202,0),(15408,2,6203,0),(15409,10,6203,0),(15410,2,6204,0),(15411,10,6204,0),(15412,2,6205,0),(15413,10,6205,0),(15414,2,6206,0),(15415,10,6206,0),(15416,2,6207,0),(15417,10,6207,0),(15418,2,6208,0),(15419,10,6208,0),(15420,2,6209,0),(15421,10,6209,0),(15422,2,6210,0),(15423,10,6210,0),(15424,2,6211,0),(15425,10,6211,0),(15426,2,6212,0),(15427,10,6212,0),(15428,2,6213,0),(15429,10,6213,0),(15430,2,6214,0),(15431,10,6214,0),(15432,2,6215,0),(15433,10,6215,0),(15434,2,6216,0),(15435,10,6216,0),(15436,2,6217,0),(15437,10,6217,0),(15438,2,6218,0),(15439,10,6218,0),(15440,2,6219,0),(15441,10,6219,0),(15442,2,6220,0),(15443,10,6220,0),(15444,2,6221,0),(15445,10,6221,0),(15446,2,6222,0),(15447,10,6222,0),(15448,2,6223,0),(15449,10,6223,0),(15450,2,6224,0),(15451,10,6224,0),(15452,2,6225,0),(15453,10,6225,0),(15454,2,6226,0),(15455,10,6226,0),(15456,2,6227,0),(15457,10,6227,0),(15458,2,6228,0),(15459,10,6228,0),(15460,2,6229,0),(15461,10,6229,0),(15462,2,6230,0),(15463,10,6230,0),(15464,2,6231,0),(15465,10,6231,0),(15466,2,6232,0),(15467,10,6232,0),(15468,2,6233,0),(15469,10,6233,0),(15470,2,6234,0),(15471,10,6234,0),(15472,2,6235,0),(15473,10,6235,0),(15474,2,6236,0),(15475,10,6236,0),(15476,2,6237,0),(15477,10,6237,0),(15478,2,6238,0),(15479,10,6238,0),(15480,2,6239,0),(15481,10,6239,0),(15482,2,6240,0),(15483,10,6240,0),(15484,2,6241,0),(15485,10,6241,0),(15486,2,6242,0),(15487,10,6242,0),(15488,2,6243,0),(15489,10,6243,0),(15490,2,6244,0),(15491,10,6244,0),(15492,2,6245,0),(15493,10,6245,0),(15494,2,6246,0),(15495,10,6246,0),(15496,2,6247,0),(15497,10,6247,0),(15498,2,6248,0),(15499,10,6248,0),(15500,2,6249,0),(15501,10,6249,0),(15502,2,6250,0),(15503,10,6250,0),(15504,2,6251,0),(15505,10,6251,0),(15506,2,6252,0),(15507,10,6252,0),(15508,2,6253,0),(15509,10,6253,0),(15510,2,6254,0),(15511,10,6254,0),(15512,2,6255,0),(15513,10,6255,0),(15514,2,6256,0),(15515,10,6256,0),(15516,2,6257,0),(15517,10,6257,0),(15518,2,6258,0),(15519,10,6258,0),(15520,2,6259,0),(15521,10,6259,0),(15522,2,6260,0),(15523,10,6260,0),(15524,2,6261,0),(15525,10,6261,0),(15526,2,6262,0),(15527,10,6262,0),(15528,2,6263,0),(15529,10,6263,0),(15530,2,6264,0),(15531,10,6264,0),(15532,2,6265,0),(15533,10,6265,0),(15534,2,6266,0),(15535,10,6266,0),(15536,2,6267,0),(15537,10,6267,0),(15538,2,6268,0),(15539,10,6268,0),(15540,2,6269,0),(15541,10,6269,0),(15542,2,6270,0),(15543,10,6270,0),(15544,2,6271,0),(15545,10,6271,0),(15546,2,6272,0),(15547,10,6272,0),(15548,2,6273,0),(15549,10,6273,0),(15550,2,6274,0),(15551,10,6274,0),(15552,2,6275,0),(15553,10,6275,0),(15554,2,6276,0),(15555,10,6276,0),(15556,2,6277,0),(15557,10,6277,0),(15558,2,6278,0),(15559,10,6278,0),(15560,2,6279,0),(15561,10,6279,0),(15562,2,6280,0),(15563,10,6280,0),(15564,2,6281,0),(15565,10,6281,0),(15566,2,6282,0),(15567,10,6282,0),(15568,2,6283,0),(15569,10,6283,0),(15570,2,6284,0),(15571,10,6284,0),(15572,2,6285,0),(15573,10,6285,0),(15574,2,6286,0),(15575,10,6286,0),(15576,2,6287,0),(15577,10,6287,0),(15578,2,6288,0),(15579,10,6288,0),(15580,2,6289,0),(15581,10,6289,0),(15582,2,6290,0),(15583,10,6290,0),(15584,2,6291,0),(15585,10,6291,0),(15586,2,6292,0),(15587,10,6292,0),(15588,2,6293,0),(15589,10,6293,0),(15590,2,6294,0),(15591,10,6294,0),(15592,2,6295,0),(15593,10,6295,0),(15594,2,6296,0),(15595,10,6296,0),(15596,2,6297,0),(15597,10,6297,0),(15598,2,6298,0),(15599,10,6298,0),(15600,2,6299,0),(15601,10,6299,0),(15602,2,6300,0),(15603,10,6300,0),(15604,2,6301,0),(15605,10,6301,0),(15606,2,6302,0),(15607,10,6302,0),(15608,2,6303,0),(15609,10,6303,0),(15610,2,6304,0),(15611,10,6304,0),(15612,2,6305,0),(15613,10,6305,0),(15614,2,6306,0),(15615,10,6306,0),(15616,2,6307,0),(15617,10,6307,0),(15618,2,6308,0),(15619,10,6308,0),(15620,2,6309,0),(15621,10,6309,0),(15622,2,6310,0),(15623,10,6310,0),(15624,2,6311,0),(15625,10,6311,0),(15626,2,6312,0),(15627,10,6312,0),(15628,2,6313,0),(15629,10,6313,0),(15630,2,6314,0),(15631,10,6314,0),(15632,2,6315,0),(15633,10,6315,0),(15634,2,6316,0),(15635,10,6316,0),(15636,2,6317,0),(15637,10,6317,0),(15638,2,6318,0),(15639,10,6318,0),(15640,2,6319,0),(15641,10,6319,0),(15642,2,6320,0),(15643,10,6320,0),(15644,2,6321,0),(15645,10,6321,0),(15646,2,6322,0),(15647,10,6322,0),(15648,2,6323,0),(15649,10,6323,0),(15650,2,6324,0),(15651,10,6324,0),(15652,2,6325,0),(15653,10,6325,0),(15654,2,6326,0),(15655,10,6326,0),(15656,2,6327,0),(15657,10,6327,0),(15658,2,6328,0),(15659,10,6328,0),(15660,2,6329,0),(15661,10,6329,0),(15662,2,6330,0),(15663,10,6330,0),(15664,2,6331,0),(15665,10,6331,0),(15666,2,6332,0),(15667,10,6332,0),(15668,2,6333,0),(15669,10,6333,0),(15670,2,6334,0),(15671,10,6334,0),(15672,2,6335,0),(15673,10,6335,0),(15674,2,6336,0),(15675,10,6336,0),(15676,2,6337,0),(15677,10,6337,0),(15678,2,6338,0),(15679,10,6338,0),(15680,2,6339,0),(15681,10,6339,0),(15682,2,6340,0),(15683,10,6340,0),(15684,2,6341,0),(15685,10,6341,0),(15686,2,6342,0),(15687,10,6342,0),(15688,2,6343,0),(15689,10,6343,0),(15690,2,6344,0),(15691,10,6344,0),(15692,2,6345,0),(15693,10,6345,0),(15694,2,6346,0),(15695,10,6346,0),(15696,2,6347,0),(15697,10,6347,0),(15698,2,6348,0),(15699,10,6348,0),(15700,2,6349,0),(15701,10,6349,0),(15702,2,6350,0),(15703,10,6350,0),(15704,2,6351,0),(15705,10,6351,0),(15706,2,6352,0),(15707,10,6352,0),(15708,2,6353,0),(15709,10,6353,0),(15710,2,6354,0),(15711,10,6354,0),(15712,2,6355,0),(15713,10,6355,0),(15714,2,6356,0),(15715,10,6356,0),(15716,2,6357,0),(15717,10,6357,0),(15718,2,6358,0),(15719,10,6358,0),(15720,2,6359,0),(15721,10,6359,0),(15722,2,6360,0),(15723,10,6360,0),(15724,2,6361,0),(15725,10,6361,0),(15726,2,6362,0),(15727,10,6362,0),(15728,2,6363,0),(15729,10,6363,0),(15730,2,6364,0),(15731,10,6364,0),(15732,2,6365,0),(15733,10,6365,0),(15734,2,6366,0),(15735,10,6366,0),(15736,2,6367,0),(15737,10,6367,0),(15738,2,6368,0),(15739,10,6368,0),(15740,2,6369,0),(15741,10,6369,0),(15742,2,6370,0),(15743,10,6370,0),(15744,2,6371,0),(15745,10,6371,0),(15746,2,6372,0),(15747,10,6372,0),(15748,2,6373,0),(15749,10,6373,0),(15750,2,6374,0),(15751,10,6374,0),(15752,2,6375,0),(15753,10,6375,0),(15754,2,6376,0),(15755,10,6376,0),(15756,2,6377,0),(15757,10,6377,0),(15758,2,6378,0),(15759,10,6378,0),(15760,2,6379,0),(15761,10,6379,0),(15762,2,6380,0),(15763,10,6380,0),(15764,2,6381,0),(15765,10,6381,0),(15766,2,6382,0),(15767,10,6382,0),(15768,2,6383,0),(15769,10,6383,0),(15770,2,6384,0),(15771,10,6384,0),(15772,2,6385,0),(15773,10,6385,0),(15774,2,6386,0),(15775,10,6386,0),(15776,2,6387,0),(15777,10,6387,0),(15778,2,6388,0),(15779,10,6388,0),(15780,2,6389,0),(15781,10,6389,0),(15782,2,6390,0),(15783,10,6390,0),(15784,2,6391,0),(15785,10,6391,0),(15786,2,6392,0),(15787,10,6392,0),(15788,2,6393,0),(15789,10,6393,0),(15790,2,6394,0),(15791,10,6394,0),(15792,2,6395,0),(15793,10,6395,0),(15794,2,6396,0),(15795,10,6396,0),(15796,2,6397,0),(15797,10,6397,0),(15798,2,6398,0),(15799,10,6398,0),(15800,2,6399,0),(15801,10,6399,0),(15802,2,6400,0),(15803,10,6400,0),(15804,2,6401,0),(15805,10,6401,0),(15806,2,6402,0),(15807,10,6402,0),(15808,2,6403,0),(15809,10,6403,0),(15810,2,6404,0),(15811,10,6404,0),(15812,2,6405,0),(15813,10,6405,0),(15814,2,6406,0),(15815,10,6406,0),(15816,2,6407,0),(15817,10,6407,0),(15818,2,6408,0),(15819,10,6408,0),(15820,2,6409,0),(15821,10,6409,0),(15822,2,6410,0),(15823,10,6410,0),(15824,2,6411,0),(15825,10,6411,0),(15826,2,6412,0),(15827,10,6412,0),(15828,2,6413,0),(15829,10,6413,0),(15830,2,6414,0),(15831,10,6414,0),(15832,2,6415,0),(15833,10,6415,0),(15834,2,6416,0),(15835,10,6416,0),(15836,2,6417,0),(15837,10,6417,0),(15838,2,6418,0),(15839,10,6418,0),(15840,2,6419,0),(15841,10,6419,0),(15842,2,6420,0),(15843,10,6420,0),(15844,2,6421,0),(15845,10,6421,0),(15846,2,6422,0),(15847,10,6422,0),(15848,2,6423,0),(15849,10,6423,0),(15850,2,6424,0),(15851,10,6424,0),(15852,2,6425,0),(15853,10,6425,0),(15854,2,6426,0),(15855,10,6426,0),(15856,2,6427,0),(15857,10,6427,0),(15858,2,6428,0),(15859,10,6428,0),(15860,2,6429,0),(15861,10,6429,0),(15862,2,6430,0),(15863,10,6430,0),(15864,2,6431,0),(15865,10,6431,0),(15866,2,6432,0),(15867,10,6432,0),(15868,2,6433,0),(15869,10,6433,0),(15870,2,6434,0),(15871,10,6434,0),(15872,2,6435,0),(15873,10,6435,0),(15874,2,6436,0),(15875,10,6436,0),(15876,2,6437,0),(15877,10,6437,0),(15878,2,6438,0),(15879,10,6438,0),(15880,2,6439,0),(15881,10,6439,0),(15882,2,6440,0),(15883,10,6440,0),(15884,2,6441,0),(15885,10,6441,0),(15886,2,6442,0),(15887,10,6442,0),(15888,2,6443,0),(15889,10,6443,0),(15890,2,6444,0),(15891,10,6444,0),(15892,2,6445,0),(15893,10,6445,0),(15894,2,6446,0),(15895,10,6446,0),(15896,2,6447,0),(15897,10,6447,0),(15898,2,6448,0),(15899,10,6448,0),(15900,2,6449,0),(15901,10,6449,0),(15902,2,6450,0),(15903,10,6450,0),(15904,2,6451,0),(15905,10,6451,0),(15906,2,6452,0),(15907,10,6452,0),(15908,2,6453,0),(15909,10,6453,0),(15910,2,6454,0),(15911,10,6454,0),(15912,2,6455,0),(15913,10,6455,0),(15914,2,6456,0),(15915,10,6456,0),(15916,2,6457,0),(15917,10,6457,0),(15918,2,6458,0),(15919,10,6458,0),(15920,2,6459,0),(15921,10,6459,0),(15922,2,6460,0),(15923,10,6460,0),(15924,2,6461,0),(15925,10,6461,0),(15926,2,6462,0),(15927,10,6462,0),(15928,2,6463,0),(15929,10,6463,0),(15930,2,6464,0),(15931,10,6464,0),(15932,2,6465,0),(15933,10,6465,0),(15934,2,6466,0),(15935,10,6466,0),(15936,2,6467,0),(15937,10,6467,0),(15938,2,6468,0),(15939,10,6468,0),(15940,2,6469,0),(15941,10,6469,0),(15942,2,6470,0),(15943,10,6470,0),(15944,2,6471,0),(15945,10,6471,0),(15946,2,6472,0),(15947,10,6472,0),(15948,2,6473,0),(15949,10,6473,0),(15950,2,6474,0),(15951,10,6474,0),(15952,2,6475,0),(15953,10,6475,0),(15954,2,6476,0),(15955,10,6476,0),(15956,2,6477,0),(15957,10,6477,0),(15958,2,6478,0),(15959,10,6478,0),(15960,2,6479,0),(15961,10,6479,0),(15962,2,6480,0),(15963,10,6480,0),(15964,2,6481,0),(15965,10,6481,0),(15966,2,6482,0),(15967,10,6482,0),(15968,2,6483,0),(15969,10,6483,0),(15970,2,6484,0),(15971,10,6484,0),(15972,2,6485,0),(15973,10,6485,0),(15974,2,6486,0),(15975,10,6486,0),(15976,2,6487,0),(15977,10,6487,0),(15978,2,6488,0),(15979,10,6488,0),(15980,2,6489,0),(15981,10,6489,0),(15982,2,6490,0),(15983,10,6490,0),(15984,2,6491,0),(15985,10,6491,0),(15986,2,6492,0),(15987,10,6492,0),(15988,2,6493,0),(15989,10,6493,0),(15990,2,6494,0),(15991,10,6494,0),(15992,2,6495,0),(15993,10,6495,0),(15994,2,6496,0),(15995,10,6496,0),(15996,2,6497,0),(15997,10,6497,0),(15998,2,6498,0),(15999,10,6498,0),(16000,2,6499,0),(16001,10,6499,0),(16002,2,6500,0),(16003,10,6500,0),(16004,2,6501,0),(16005,10,6501,0),(16006,2,6502,0),(16007,10,6502,0),(16008,2,6503,0),(16009,10,6503,0),(16010,2,6504,0),(16011,10,6504,0),(16012,2,6505,0),(16013,10,6505,0),(16014,2,6506,0),(16015,10,6506,0),(16016,2,6507,0),(16017,10,6507,0),(16018,2,6508,0),(16019,10,6508,0),(16020,2,6509,0),(16021,10,6509,0),(16022,2,6510,0),(16023,10,6510,0),(16024,2,6511,0),(16025,10,6511,0),(16026,2,6512,0),(16027,10,6512,0),(16028,2,6513,0),(16029,10,6513,0),(16030,2,6514,0),(16031,10,6514,0),(16032,2,6515,0),(16033,10,6515,0),(16034,2,6516,0),(16035,10,6516,0),(16036,2,6517,0),(16037,10,6517,0),(16038,2,6518,0),(16039,10,6518,0),(16040,2,6519,0),(16041,10,6519,0),(16042,2,6520,0),(16043,10,6520,0),(16044,2,6521,0),(16045,10,6521,0),(16046,2,6522,0),(16047,10,6522,0),(16048,2,6523,0),(16049,10,6523,0),(16050,2,6524,0),(16051,10,6524,0),(16052,2,6525,0),(16053,10,6525,0),(16054,2,6526,0),(16055,10,6526,0),(16056,2,6527,0),(16057,10,6527,0),(16058,2,6528,0),(16059,10,6528,0),(16060,2,6529,0),(16061,10,6529,0),(16062,2,6530,0),(16063,10,6530,0),(16064,2,6531,0),(16065,10,6531,0),(16066,2,6532,0),(16067,10,6532,0),(16068,2,6533,0),(16069,10,6533,0),(16070,2,6534,0),(16071,10,6534,0),(16072,2,6535,0),(16073,10,6535,0),(16074,2,6536,0),(16075,10,6536,0),(16076,2,6537,0),(16077,10,6537,0),(16078,2,6538,0),(16079,10,6538,0),(16080,2,6539,0),(16081,10,6539,0),(16082,2,6540,0),(16083,10,6540,0),(16084,2,6541,0),(16085,10,6541,0),(16086,2,6542,0),(16087,10,6542,0),(16088,2,6543,0),(16089,10,6543,0),(16090,2,6544,0),(16091,10,6544,0),(16092,2,6545,0),(16093,10,6545,0),(16094,2,6546,0),(16095,10,6546,0),(16096,2,6547,0),(16097,10,6547,0),(16098,2,6548,0),(16099,10,6548,0),(16100,2,6549,0),(16101,10,6549,0),(16102,2,6550,0),(16103,10,6550,0),(16104,2,6551,0),(16105,10,6551,0),(16106,2,6552,0),(16107,10,6552,0),(16108,2,6553,0),(16109,10,6553,0),(16110,2,6554,0),(16111,10,6554,0),(16112,2,6555,0),(16113,10,6555,0),(16114,2,6556,0),(16115,10,6556,0),(16116,2,6557,0),(16117,10,6557,0),(16118,2,6558,0),(16119,10,6558,0),(16120,2,6559,0),(16121,10,6559,0),(16122,2,6560,0),(16123,10,6560,0),(16124,2,6561,0),(16125,10,6561,0),(16126,2,6562,0),(16127,10,6562,0),(16128,2,6563,0),(16129,10,6563,0),(16130,2,6564,0),(16131,10,6564,0),(16132,2,6565,0),(16133,10,6565,0),(16134,2,6566,0),(16135,10,6566,0),(16136,2,6567,0),(16137,10,6567,0),(16138,2,6568,0),(16139,10,6568,0),(16140,2,6569,0),(16141,10,6569,0),(16142,2,6570,0),(16143,10,6570,0),(16144,2,6571,0),(16145,10,6571,0),(16146,2,6572,0),(16147,10,6572,0),(16148,2,6573,0),(16149,10,6573,0),(16150,2,6574,0),(16151,10,6574,0),(16152,2,6575,0),(16153,10,6575,0),(16154,2,6576,0),(16155,10,6576,0),(16156,2,6577,0),(16157,10,6577,0),(16158,2,6578,0),(16159,10,6578,0),(16160,2,6579,0),(16161,10,6579,0),(16162,2,6580,0),(16163,10,6580,0),(16164,2,6581,0),(16165,10,6581,0),(16166,2,6582,0),(16167,10,6582,0),(16168,2,6583,0),(16169,10,6583,0),(16170,2,6584,0),(16171,10,6584,0),(16172,2,6585,0),(16173,10,6585,0),(16174,2,6586,0),(16175,10,6586,0),(16176,2,6587,0),(16177,10,6587,0),(16178,2,6588,0),(16179,10,6588,0),(16180,2,6589,0),(16181,10,6589,0),(16182,2,6590,0),(16183,10,6590,0),(16184,2,6591,0),(16185,10,6591,0),(16186,2,6592,0),(16187,10,6592,0),(16188,2,6593,0),(16189,10,6593,0),(16190,2,6594,0),(16191,10,6594,0),(16192,2,6595,0),(16193,10,6595,0),(16194,2,6596,0),(16195,10,6596,0),(16196,2,6597,0),(16197,10,6597,0),(16198,2,6598,0),(16199,10,6598,0),(16200,2,6599,0),(16201,10,6599,0),(16202,2,6600,0),(16203,10,6600,0),(16204,2,6601,0),(16205,10,6601,0),(16206,2,6602,0),(16207,10,6602,0),(16208,2,6603,0),(16209,10,6603,0),(16210,2,6604,0),(16211,10,6604,0),(16212,2,6605,0),(16213,10,6605,0),(16214,2,6606,0),(16215,10,6606,0),(16216,2,6607,0),(16217,10,6607,0),(16218,2,6608,0),(16219,10,6608,0),(16220,2,6609,0),(16221,10,6609,0),(16222,2,6610,0),(16223,10,6610,0),(16224,2,6611,0),(16225,10,6611,0),(16226,2,6612,0),(16227,10,6612,0),(16228,2,6613,0),(16229,10,6613,0),(16230,2,6614,0),(16231,10,6614,0),(16232,2,6615,0),(16233,10,6615,0),(16234,2,6616,0),(16235,10,6616,0),(16236,2,6617,0),(16237,10,6617,0),(16238,2,6618,0),(16239,10,6618,0),(16240,2,6619,0),(16241,10,6619,0),(16242,2,6620,0),(16243,10,6620,0),(16244,2,6621,0),(16245,10,6621,0),(16246,2,6622,0),(16247,10,6622,0),(16248,2,6623,0),(16249,10,6623,0),(16250,2,6624,0),(16251,10,6624,0),(16252,2,6625,0),(16253,10,6625,0),(16254,2,6626,0),(16255,10,6626,0),(16256,2,6627,0),(16257,10,6627,0),(16258,2,6628,0),(16259,10,6628,0),(16260,2,6629,0),(16261,10,6629,0),(16262,2,6630,0),(16263,10,6630,0),(16264,2,6631,0),(16265,10,6631,0),(16266,2,6632,0),(16267,10,6632,0),(16268,2,6633,0),(16269,10,6633,0),(16270,2,6634,0),(16271,10,6634,0),(16272,2,6635,0),(16273,10,6635,0),(16274,2,6636,0),(16275,10,6636,0),(16276,2,6637,0),(16277,10,6637,0),(16278,2,6638,0),(16279,10,6638,0),(16280,2,6639,0),(16281,10,6639,0),(16282,2,6640,0),(16283,10,6640,0),(16284,2,6641,0),(16285,10,6641,0),(16286,2,6642,0),(16287,10,6642,0),(16288,2,6643,0),(16289,10,6643,0),(16290,2,6644,0),(16291,10,6644,0),(16292,2,6645,0),(16293,10,6645,0),(16294,2,6646,0),(16295,10,6646,0),(16296,2,6647,0),(16297,10,6647,0),(16298,2,6648,0),(16299,10,6648,0),(16300,2,6649,0),(16301,10,6649,0),(16302,2,6650,0),(16303,10,6650,0),(16304,2,6651,0),(16305,10,6651,0),(16306,2,6652,0),(16307,10,6652,0),(16308,2,6653,0),(16309,10,6653,0),(16310,2,6654,0),(16311,10,6654,0),(16312,2,6655,0),(16313,10,6655,0),(16314,2,6656,0),(16315,10,6656,0),(16316,2,6657,0),(16317,10,6657,0),(16318,2,6658,0),(16319,10,6658,0),(16320,2,6659,0),(16321,10,6659,0),(16322,2,6660,0),(16323,10,6660,0),(16324,2,6661,0),(16325,10,6661,0),(16326,2,6662,0),(16327,10,6662,0),(16328,2,6663,0),(16329,10,6663,0),(16330,2,6664,0),(16331,10,6664,0),(16332,2,6665,0),(16333,10,6665,0),(16334,2,6666,0),(16335,10,6666,0),(16336,2,6667,0),(16337,10,6667,0),(16338,2,6668,0),(16339,10,6668,0),(16340,2,6669,0),(16341,10,6669,0),(16342,2,6670,0),(16343,10,6670,0),(16344,2,6671,0),(16345,10,6671,0),(16346,2,6672,0),(16347,10,6672,0),(16348,2,6673,0),(16349,10,6673,0),(16350,2,6674,0),(16351,10,6674,0),(16352,2,6675,0),(16353,10,6675,0),(16354,2,6676,0),(16355,10,6676,0),(16356,2,6677,0),(16357,10,6677,0),(16358,2,6678,0),(16359,10,6678,0),(16360,2,6679,0),(16361,10,6679,0),(16362,2,6680,0),(16363,10,6680,0),(16364,2,6681,0),(16365,10,6681,0),(16366,2,6682,0),(16367,10,6682,0),(16368,2,6683,0),(16369,10,6683,0),(16370,2,6684,0),(16371,10,6684,0),(16372,2,6685,0),(16373,10,6685,0),(16374,2,6686,0),(16375,10,6686,0),(16376,2,6687,0),(16377,10,6687,0),(16378,2,6688,0),(16379,10,6688,0),(16380,2,6689,0),(16381,10,6689,0),(16382,2,6690,0),(16383,10,6690,0),(16384,2,6691,0),(16385,10,6691,0),(16386,2,6692,0),(16387,10,6692,0),(16388,2,6693,0),(16389,10,6693,0),(16390,2,6694,0),(16391,10,6694,0),(16392,2,6695,0),(16393,10,6695,0),(16394,2,6696,0),(16395,10,6696,0),(16396,2,6697,0),(16397,10,6697,0),(16398,2,6698,0),(16399,10,6698,0),(16400,2,6699,0),(16401,10,6699,0),(16402,2,6700,0),(16403,10,6700,0),(16404,2,6701,0),(16405,10,6701,0),(16406,2,6702,0),(16407,10,6702,0),(16408,2,6703,0),(16409,10,6703,0),(16410,2,6704,0),(16411,10,6704,0),(16412,2,6705,0),(16413,10,6705,0),(16414,2,6706,0),(16415,10,6706,0),(16416,2,6707,0),(16417,10,6707,0),(16418,2,6708,0),(16419,10,6708,0),(16420,2,6709,0),(16421,10,6709,0),(16422,2,6710,0),(16423,10,6710,0),(16424,2,6711,0),(16425,10,6711,0),(16426,2,6712,0),(16427,10,6712,0),(16428,2,6713,0),(16429,10,6713,0),(16430,2,6714,0),(16431,10,6714,0),(16432,2,6715,0),(16433,10,6715,0),(16434,2,6716,0),(16435,10,6716,0),(16436,2,6717,0),(16437,10,6717,0),(16438,2,6718,0),(16439,10,6718,0),(16440,2,6719,0),(16441,10,6719,0),(16442,2,6720,0),(16443,10,6720,0),(16444,2,6721,0),(16445,10,6721,0),(16446,2,6722,0),(16447,10,6722,0),(16448,2,6723,0),(16449,10,6723,0),(16450,2,6724,0),(16451,10,6724,0),(16452,2,6725,0),(16453,10,6725,0),(16454,2,6726,0),(16455,10,6726,0),(16456,2,6727,0),(16457,10,6727,0),(16458,2,6728,0),(16459,10,6728,0),(16460,2,6729,0),(16461,10,6729,0),(16462,2,6730,0),(16463,10,6730,0),(16464,2,6731,0),(16465,10,6731,0),(16466,2,6732,0),(16467,10,6732,0),(16468,2,6733,0),(16469,10,6733,0),(16470,2,6734,0),(16471,10,6734,0),(16472,2,6735,0),(16473,10,6735,0),(16474,2,6736,0),(16475,10,6736,0),(16476,2,6737,0),(16477,10,6737,0),(16478,2,6738,0),(16479,10,6738,0),(16480,2,6739,0),(16481,10,6739,0),(16482,2,6740,0),(16483,10,6740,0),(16484,2,6741,0),(16485,10,6741,0),(16486,2,6742,0),(16487,10,6742,0),(16488,2,6743,0),(16489,10,6743,0),(16490,2,6744,0),(16491,10,6744,0),(16492,2,6745,0),(16493,10,6745,0),(16494,2,6746,0),(16495,10,6746,0),(16496,2,6747,0),(16497,10,6747,0),(16498,2,6748,0),(16499,10,6748,0),(16500,2,6749,0),(16501,10,6749,0),(16502,2,6750,0),(16503,10,6750,0),(16504,2,6751,0),(16505,10,6751,0),(16506,2,6752,0),(16507,10,6752,0),(16508,2,6753,0),(16509,10,6753,0),(16510,2,6754,0),(16511,10,6754,0),(16512,2,6755,0),(16513,10,6755,0),(16514,2,6756,0),(16515,10,6756,0),(16516,2,6757,0),(16517,10,6757,0),(16518,2,6758,0),(16519,10,6758,0),(16520,2,6759,0),(16521,10,6759,0),(16522,2,6760,0),(16523,10,6760,0),(16524,2,6761,0),(16525,10,6761,0),(16526,2,6762,0),(16527,10,6762,0),(16528,2,6763,0),(16529,10,6763,0),(16530,2,6764,0),(16531,10,6764,0),(16532,2,6765,0),(16533,10,6765,0),(16534,2,6766,0),(16535,10,6766,0),(16536,2,6767,0),(16537,10,6767,0),(16538,2,6768,0),(16539,10,6768,0),(16540,2,6769,0),(16541,10,6769,0),(16542,2,6770,0),(16543,10,6770,0),(16544,2,6771,0),(16545,10,6771,0),(16546,2,6772,0),(16547,10,6772,0),(16548,2,6773,0),(16549,10,6773,0),(16550,2,6774,0),(16551,10,6774,0),(16552,2,6775,0),(16553,10,6775,0),(16554,2,6776,0),(16555,10,6776,0),(16556,2,6777,0),(16557,10,6777,0),(16558,2,6778,0),(16559,10,6778,0),(16560,2,6779,0),(16561,10,6779,0),(16562,2,6780,0),(16563,10,6780,0),(16564,2,6781,0),(16565,10,6781,0),(16566,2,6782,0),(16567,10,6782,0),(16568,2,6783,0),(16569,10,6783,0),(16570,2,6784,0),(16571,10,6784,0),(16572,2,6785,0),(16573,10,6785,0),(16574,2,6786,0),(16575,10,6786,0),(16576,2,6787,0),(16577,10,6787,0),(16578,2,6788,0),(16579,10,6788,0),(16580,2,6789,0),(16581,10,6789,0),(16582,2,6790,0),(16583,10,6790,0),(16584,2,6791,0),(16585,10,6791,0),(16586,2,6792,0),(16587,10,6792,0),(16588,2,6793,0),(16589,10,6793,0),(16590,2,6794,0),(16591,10,6794,0),(16592,2,6795,0),(16593,10,6795,0),(16594,2,6796,0),(16595,10,6796,0),(16596,2,6797,0),(16597,10,6797,0),(16598,2,6798,0),(16599,10,6798,0),(16600,2,6799,0),(16601,10,6799,0),(16602,2,6800,0),(16603,10,6800,0),(16604,2,6801,0),(16605,10,6801,0),(16606,2,6802,0),(16607,10,6802,0),(16608,2,6803,0),(16609,10,6803,0),(16610,2,6804,0),(16611,10,6804,0),(16612,2,6805,0),(16613,10,6805,0),(16614,2,6806,0),(16615,10,6806,0),(16616,2,6807,0),(16617,10,6807,0),(16618,2,6808,0),(16619,10,6808,0),(16620,2,6809,0),(16621,10,6809,0),(16622,2,6810,0),(16623,10,6810,0),(16624,2,6811,0),(16625,10,6811,0),(16626,2,6812,0),(16627,10,6812,0),(16628,2,6813,0),(16629,10,6813,0),(16630,2,6814,0),(16631,10,6814,0),(16632,2,6815,0),(16633,10,6815,0),(16634,2,6816,0),(16635,10,6816,0),(16636,2,6817,0),(16637,10,6817,0),(16638,2,6818,0),(16639,10,6818,0),(16640,2,6819,0),(16641,10,6819,0),(16642,2,6820,0),(16643,10,6820,0),(16644,2,6821,0),(16645,10,6821,0),(16646,2,6822,0),(16647,10,6822,0),(16648,2,6823,0),(16649,10,6823,0),(16650,2,6824,0),(16651,10,6824,0),(16652,2,6825,0),(16653,10,6825,0),(16654,2,6826,0),(16655,10,6826,0),(16656,2,6827,0),(16657,10,6827,0),(16658,2,6828,0),(16659,10,6828,0),(16660,2,6829,0),(16661,10,6829,0),(16662,2,6830,0),(16663,10,6830,0),(16664,2,6831,0),(16665,10,6831,0),(16666,2,6832,0),(16667,10,6832,0),(16668,2,6833,0),(16669,10,6833,0),(16670,2,6834,0),(16671,10,6834,0),(16672,2,6835,0),(16673,10,6835,0),(16674,2,6836,0),(16675,10,6836,0),(16676,2,6837,0),(16677,10,6837,0),(16678,2,6838,0),(16679,10,6838,0),(16680,2,6839,0),(16681,10,6839,0),(16682,2,6840,0),(16683,10,6840,0),(16684,2,6841,0),(16685,10,6841,0),(16686,2,6842,0),(16687,10,6842,0),(16688,2,6843,0),(16689,10,6843,0),(16690,2,6844,0),(16691,10,6844,0),(16692,2,6845,0),(16693,10,6845,0),(16694,2,6846,0),(16695,10,6846,0),(16696,2,6847,0),(16697,10,6847,0),(16698,2,6848,0),(16699,10,6848,0),(16700,2,6849,0),(16701,10,6849,0),(16702,2,6850,0),(16703,10,6850,0),(16704,2,6851,0),(16705,10,6851,0),(16706,2,6852,0),(16707,10,6852,0),(16708,2,6853,0),(16709,10,6853,0),(16710,2,6854,0),(16711,10,6854,0),(16712,2,6855,0),(16713,10,6855,0),(16714,2,6856,0),(16715,10,6856,0),(16716,2,6857,0),(16717,10,6857,0),(16718,2,6858,0),(16719,10,6858,0),(16720,2,6859,0),(16721,10,6859,0),(16722,2,6860,0),(16723,10,6860,0),(16724,2,6861,0),(16725,10,6861,0),(16726,2,6862,0),(16727,10,6862,0),(16728,2,6863,0),(16729,10,6863,0),(16730,2,6864,0),(16731,10,6864,0),(16732,2,6865,0),(16733,10,6865,0),(16734,2,6866,0),(16735,10,6866,0),(16736,2,6867,0),(16737,10,6867,0),(16738,2,6868,0),(16739,10,6868,0),(16740,2,6869,0),(16741,10,6869,0),(16742,2,6870,0),(16743,10,6870,0),(16744,2,6871,0),(16745,10,6871,0),(16746,2,6872,0),(16747,10,6872,0),(16748,2,6873,0),(16749,10,6873,0),(16750,2,6874,0),(16751,10,6874,0),(16752,2,6875,0),(16753,10,6875,0),(16754,2,6876,0),(16755,10,6876,0),(16756,2,6877,0),(16757,10,6877,0),(16758,2,6878,0),(16759,10,6878,0),(16760,2,6879,0),(16761,10,6879,0),(16762,2,6880,0),(16763,10,6880,0),(16764,2,6881,0),(16765,10,6881,0),(16766,2,6882,0),(16767,10,6882,0),(16768,2,6883,0),(16769,10,6883,0),(16770,2,6884,0),(16771,10,6884,0),(16772,2,6885,0),(16773,10,6885,0),(16774,2,6886,0),(16775,10,6886,0),(16776,2,6887,0),(16777,10,6887,0),(16778,2,6888,0),(16779,10,6888,0),(16780,2,6889,0),(16781,10,6889,0),(16782,2,6890,0),(16783,10,6890,0),(16784,2,6891,0),(16785,10,6891,0),(16786,2,6892,0),(16787,10,6892,0),(16788,2,6893,0),(16789,10,6893,0),(16790,2,6894,0),(16791,10,6894,0),(16792,2,6895,0),(16793,10,6895,0),(16794,2,6896,0),(16795,10,6896,0),(16796,2,6897,0),(16797,10,6897,0),(16798,2,6898,0),(16799,10,6898,0),(16800,2,6899,0),(16801,10,6899,0),(16802,2,6900,0),(16803,10,6900,0),(16804,2,6901,0),(16805,10,6901,0),(16806,2,6902,0),(16807,10,6902,0),(16808,2,6903,0),(16809,10,6903,0),(16810,2,6904,0),(16811,10,6904,0),(16812,2,6905,0),(16813,10,6905,0),(16814,2,6906,0),(16815,10,6906,0),(16816,2,6907,0),(16817,10,6907,0),(16818,2,6908,0),(16819,10,6908,0),(16820,2,6909,0),(16821,10,6909,0),(16822,2,6910,0),(16823,10,6910,0),(16824,2,6911,0),(16825,10,6911,0),(16826,2,6912,0),(16827,10,6912,0),(16828,2,6913,0),(16829,10,6913,0),(16830,2,6914,0),(16831,10,6914,0),(16832,2,6915,0),(16833,10,6915,0),(16834,2,6916,0),(16835,10,6916,0),(16836,2,6917,0),(16837,10,6917,0),(16838,2,6918,0),(16839,10,6918,0),(16840,2,6919,0),(16841,10,6919,0),(16842,2,6920,0),(16843,10,6920,0),(16844,2,6921,0),(16845,10,6921,0),(16846,2,6922,0),(16847,10,6922,0),(16848,2,6923,0),(16849,10,6923,0),(16850,2,6924,0),(16851,10,6924,0),(16852,2,6925,0),(16853,10,6925,0),(16854,2,6926,0),(16855,10,6926,0),(16856,2,6927,0),(16857,10,6927,0),(16858,2,6928,0),(16859,10,6928,0),(16860,2,6929,0),(16861,10,6929,0),(16862,2,6930,0),(16863,10,6930,0),(16864,2,6931,0),(16865,10,6931,0),(16866,2,6932,0),(16867,10,6932,0),(16868,2,6933,0),(16869,10,6933,0),(16870,2,6934,0),(16871,10,6934,0),(16872,2,6935,0),(16873,10,6935,0),(16874,2,6936,0),(16875,10,6936,0),(16876,2,6937,0),(16877,10,6937,0),(16878,2,6938,0),(16879,10,6938,0),(16880,2,6939,0),(16881,10,6939,0),(16882,2,6940,0),(16883,10,6940,0),(16884,2,6941,0),(16885,10,6941,0),(16886,2,6942,0),(16887,10,6942,0),(16888,2,6943,0),(16889,10,6943,0),(16890,2,6944,0),(16891,10,6944,0),(16892,2,6945,0),(16893,10,6945,0),(16894,2,6946,0),(16895,10,6946,0),(16896,2,6947,0),(16897,10,6947,0),(16898,2,6948,0),(16899,10,6948,0),(16900,2,6949,0),(16901,10,6949,0),(16902,2,6950,0),(16903,10,6950,0),(16904,2,6951,0),(16905,10,6951,0),(16906,2,6952,0),(16907,10,6952,0),(16908,2,6953,0),(16909,10,6953,0),(16910,2,6954,0),(16911,10,6954,0),(16912,2,6955,0),(16913,10,6955,0),(16914,2,6956,0),(16915,10,6956,0),(16916,2,6957,0),(16917,10,6957,0),(16918,2,6958,0),(16919,10,6958,0),(16920,2,6959,0),(16921,10,6959,0),(16922,2,6960,0),(16923,10,6960,0),(16924,2,6961,0),(16925,10,6961,0),(16926,2,6962,0),(16927,10,6962,0),(16928,2,6963,0),(16929,10,6963,0),(16930,2,6964,0),(16931,10,6964,0),(16932,2,6965,0),(16933,10,6965,0),(16934,2,6966,0),(16935,10,6966,0),(16936,2,6967,0),(16937,10,6967,0),(16938,2,6968,0),(16939,10,6968,0),(16940,2,6969,0),(16941,10,6969,0),(16942,2,6970,0),(16943,10,6970,0),(16944,2,6971,0),(16945,10,6971,0),(16946,2,6972,0),(16947,10,6972,0),(16948,2,6973,0),(16949,10,6973,0),(16950,2,6974,0),(16951,10,6974,0),(16952,2,6975,0),(16953,10,6975,0),(16954,2,6976,0),(16955,10,6976,0),(16956,2,6977,0),(16957,10,6977,0),(16958,2,6978,0),(16959,10,6978,0),(16960,2,6979,0),(16961,10,6979,0),(16962,2,6980,0),(16963,10,6980,0),(16964,2,6981,0),(16965,10,6981,0),(16966,2,6982,0),(16967,10,6982,0),(16968,2,6983,0),(16969,10,6983,0),(16970,2,6984,0),(16971,10,6984,0),(16972,2,6985,0),(16973,10,6985,0),(16974,2,6986,0),(16975,10,6986,0),(16976,2,6987,0),(16977,10,6987,0),(16978,2,6988,0),(16979,10,6988,0),(16980,2,6989,0),(16981,10,6989,0),(16982,2,6990,0),(16983,10,6990,0),(16984,2,6991,0),(16985,10,6991,0),(16986,2,6992,0),(16987,10,6992,0),(16988,2,6993,0),(16989,10,6993,0),(16990,2,6994,0),(16991,10,6994,0),(16992,2,6995,0),(16993,10,6995,0),(16994,2,6996,0),(16995,10,6996,0),(16996,2,6997,0),(16997,10,6997,0),(16998,2,6998,0),(16999,10,6998,0),(17000,2,6999,0),(17001,10,6999,0),(17002,2,7000,0),(17003,10,7000,0),(17004,2,7001,0),(17005,10,7001,0),(17006,2,7002,0),(17007,10,7002,0),(17008,2,7003,0),(17009,10,7003,0),(17010,2,7004,0),(17011,10,7004,0),(17012,2,7005,0),(17013,10,7005,0),(17014,2,7006,0),(17015,10,7006,0),(17016,2,7007,0),(17017,10,7007,0),(17018,2,7008,0),(17019,10,7008,0),(17020,2,7009,0),(17021,10,7009,0),(17022,2,7010,0),(17023,10,7010,0),(17024,2,7011,0),(17025,10,7011,0),(17026,2,7012,0),(17027,10,7012,0),(17028,2,7013,0),(17029,10,7013,0),(17030,2,7014,0),(17031,10,7014,0),(17032,2,7015,0),(17033,10,7015,0),(17034,2,7016,0),(17035,10,7016,0),(17036,2,7017,0),(17037,10,7017,0),(17038,2,7018,0),(17039,10,7018,0),(17040,2,7019,0),(17041,10,7019,0),(17042,2,7020,0),(17043,10,7020,0),(17044,2,7021,0),(17045,10,7021,0),(17046,2,7022,0),(17047,10,7022,0),(17048,2,7023,0),(17049,10,7023,0),(17050,2,7024,0),(17051,10,7024,0),(17052,2,7025,0),(17053,10,7025,0),(17054,2,7026,0),(17055,10,7026,0),(17056,2,7027,0),(17057,10,7027,0),(17058,2,7028,0),(17059,10,7028,0),(17060,2,7029,0),(17061,10,7029,0),(17062,2,7030,0),(17063,10,7030,0),(17064,2,7031,0),(17065,10,7031,0),(17066,2,7032,0),(17067,10,7032,0),(17068,2,7033,0),(17069,10,7033,0),(17070,2,7034,0),(17071,10,7034,0),(17072,2,7035,0),(17073,10,7035,0),(17074,2,7036,0),(17075,10,7036,0),(17076,2,7037,0),(17077,10,7037,0),(17078,2,7038,0),(17079,10,7038,0),(17080,2,7039,0),(17081,10,7039,0),(17082,2,7040,0),(17083,10,7040,0),(17084,2,7041,0),(17085,10,7041,0),(17086,2,7042,0),(17087,10,7042,0),(17088,2,7043,0),(17089,10,7043,0),(17090,2,7044,0),(17091,10,7044,0),(17092,2,7045,0),(17093,10,7045,0),(17094,2,7046,0),(17095,10,7046,0),(17096,2,7047,0),(17097,10,7047,0),(17098,2,7048,0),(17099,10,7048,0),(17100,2,7049,0),(17101,10,7049,0),(17102,2,7050,0),(17103,10,7050,0),(17104,2,7051,0),(17105,10,7051,0),(17106,2,7052,0),(17107,10,7052,0),(17108,2,7053,0),(17109,10,7053,0),(17110,2,7054,0),(17111,10,7054,0),(17112,2,7055,0),(17113,10,7055,0),(17114,2,7056,0),(17115,10,7056,0),(17116,2,7057,0),(17117,10,7057,0),(17118,2,7058,0),(17119,10,7058,0),(17120,2,7059,0),(17121,10,7059,0),(17122,2,7060,0),(17123,10,7060,0),(17124,2,7061,0),(17125,10,7061,0),(17126,2,7062,0),(17127,10,7062,0),(17128,2,7063,0),(17129,10,7063,0),(17130,2,7064,0),(17131,10,7064,0),(17132,2,7065,0),(17133,10,7065,0),(17134,2,7066,0),(17135,10,7066,0),(17136,2,7067,0),(17137,10,7067,0),(17138,2,7068,0),(17139,10,7068,0),(17140,2,7069,0),(17141,10,7069,0),(17142,2,7070,0),(17143,10,7070,0),(17144,2,7071,0),(17145,10,7071,0),(17146,2,7072,0),(17147,10,7072,0),(17148,2,7073,0),(17149,10,7073,0),(17150,2,7074,0),(17151,10,7074,0),(17152,2,7075,0),(17153,10,7075,0),(17154,2,7076,0),(17155,10,7076,0),(17156,2,7077,0),(17157,10,7077,0),(17158,2,7078,0),(17159,10,7078,0),(17160,2,7079,0),(17161,10,7079,0),(17162,2,7080,0),(17163,10,7080,0),(17164,2,7081,0),(17165,10,7081,0),(17166,2,7082,0),(17167,10,7082,0),(17168,2,7083,0),(17169,10,7083,0),(17170,2,7084,0),(17171,10,7084,0),(17172,2,7085,0),(17173,10,7085,0),(17174,2,7086,0),(17175,10,7086,0),(17176,2,7087,0),(17177,10,7087,0),(17178,2,7088,0),(17179,10,7088,0),(17180,2,7089,0),(17181,10,7089,0),(17182,2,7090,0),(17183,10,7090,0),(17184,2,7091,0),(17185,10,7091,0),(17186,2,7092,0),(17187,10,7092,0),(17188,2,7093,0),(17189,10,7093,0),(17190,2,7094,0),(17191,10,7094,0),(17192,2,7095,0),(17193,10,7095,0),(17194,2,7096,0),(17195,10,7096,0),(17196,2,7097,0),(17197,10,7097,0),(17198,2,7098,0),(17199,10,7098,0),(17200,2,7099,0),(17201,10,7099,0),(17202,2,7100,0),(17203,10,7100,0),(17204,2,7101,0),(17205,10,7101,0),(17206,2,7102,0),(17207,10,7102,0),(17208,2,7103,0),(17209,10,7103,0),(17210,2,7104,0),(17211,10,7104,0),(17212,2,7105,0),(17213,10,7105,0),(17214,2,7106,0),(17215,10,7106,0),(17216,2,7107,0),(17217,10,7107,0),(17218,2,7108,0),(17219,10,7108,0),(17220,2,7109,0),(17221,10,7109,0),(17222,2,7110,0),(17223,10,7110,0),(17224,2,7111,0),(17225,10,7111,0),(17226,2,7112,0),(17227,10,7112,0),(17228,2,7113,0),(17229,10,7113,0),(17230,2,7114,0),(17231,10,7114,0),(17232,2,7115,0),(17233,10,7115,0),(17234,2,7116,0),(17235,10,7116,0),(17236,2,7117,0),(17237,10,7117,0),(17238,2,7118,0),(17239,10,7118,0),(17240,2,7119,0),(17241,10,7119,0),(17242,2,7120,0),(17243,10,7120,0),(17244,2,7121,0),(17245,10,7121,0),(17246,2,7122,0),(17247,10,7122,0),(17248,2,7123,0),(17249,10,7123,0),(17250,2,7124,0),(17251,10,7124,0),(17252,2,7125,0),(17253,10,7125,0),(17254,2,7126,0),(17255,10,7126,0),(17256,2,7127,0),(17257,10,7127,0),(17258,2,7128,0),(17259,10,7128,0),(17260,2,7129,0),(17261,10,7129,0),(17262,2,7130,0),(17263,10,7130,0),(17264,2,7131,0),(17265,10,7131,0),(17266,2,7132,0),(17267,10,7132,0),(17268,2,7133,0),(17269,10,7133,0),(17270,2,7134,0),(17271,10,7134,0),(17272,2,7135,0),(17273,10,7135,0),(17274,2,7136,0),(17275,10,7136,0),(17276,2,7137,0),(17277,10,7137,0),(17278,2,7138,0),(17279,10,7138,0),(17280,2,7139,0),(17281,10,7139,0),(17282,2,7140,0),(17283,10,7140,0),(17284,2,7141,0),(17285,10,7141,0),(17286,2,7142,0),(17287,10,7142,0),(17288,2,7143,0),(17289,10,7143,0),(17290,2,7144,0),(17291,10,7144,0),(17292,2,7145,0),(17293,10,7145,0),(17294,2,7146,0),(17295,10,7146,0),(17296,2,7147,0),(17297,10,7147,0),(17298,2,7148,0),(17299,10,7148,0),(17300,2,7149,0),(17301,10,7149,0),(17302,2,7150,0),(17303,10,7150,0),(17304,2,7151,0),(17305,10,7151,0),(17306,2,7152,0),(17307,10,7152,0),(17308,2,7153,0),(17309,10,7153,0),(17310,2,7154,0),(17311,10,7154,0),(17312,2,7155,0),(17313,10,7155,0),(17314,2,7156,0),(17315,10,7156,0),(17316,2,7157,0),(17317,10,7157,0),(17318,2,7158,0),(17319,10,7158,0),(17320,2,7159,0),(17321,10,7159,0),(17322,2,7160,0),(17323,10,7160,0),(17324,2,7161,0),(17325,10,7161,0),(17326,2,7162,0),(17327,10,7162,0),(17328,2,7163,0),(17329,10,7163,0),(17330,2,7164,0),(17331,10,7164,0),(17332,2,7165,0),(17333,10,7165,0),(17334,2,7166,0),(17335,10,7166,0),(17336,2,7167,0),(17337,10,7167,0),(17338,2,7168,0),(17339,10,7168,0),(17340,2,7169,0),(17341,10,7169,0),(17342,2,7170,0),(17343,10,7170,0),(17344,2,7171,0),(17345,10,7171,0),(17346,2,7172,0),(17347,10,7172,0),(17348,2,7173,0),(17349,10,7173,0),(17350,2,7174,0),(17351,10,7174,0),(17352,2,7175,0),(17353,10,7175,0),(17354,2,7176,0),(17355,10,7176,0),(17356,2,7177,0),(17357,10,7177,0),(17358,2,7178,0),(17359,10,7178,0),(17360,2,7179,0),(17361,10,7179,0),(17362,2,7180,0),(17363,10,7180,0),(17364,2,7181,0),(17365,10,7181,0),(17366,2,7182,0),(17367,10,7182,0),(17368,2,7183,0),(17369,10,7183,0),(17370,2,7184,0),(17371,10,7184,0),(17372,2,7185,0),(17373,10,7185,0),(17374,2,7186,0),(17375,10,7186,0),(17376,2,7187,0),(17377,10,7187,0),(17378,2,7188,0),(17379,10,7188,0),(17380,2,7189,0),(17381,10,7189,0),(17382,2,7190,0),(17383,10,7190,0),(17384,2,7191,0),(17385,10,7191,0),(17386,2,7192,0),(17387,10,7192,0),(17388,2,7193,0),(17389,10,7193,0),(17390,2,7194,0),(17391,10,7194,0),(17392,2,7195,0),(17393,10,7195,0),(17394,2,7196,0),(17395,10,7196,0),(17396,2,7197,0),(17397,10,7197,0),(17398,2,7198,0),(17399,10,7198,0),(17400,2,7199,0),(17401,10,7199,0),(17402,2,7200,0),(17403,10,7200,0),(17404,2,7201,0),(17405,10,7201,0),(17406,2,7202,0),(17407,10,7202,0),(17408,2,7203,0),(17409,10,7203,0),(17410,2,7204,0),(17411,10,7204,0),(17412,2,7205,0),(17413,10,7205,0),(17414,2,7206,0),(17415,10,7206,0),(17416,2,7207,0),(17417,10,7207,0),(17418,2,7208,0),(17419,10,7208,0),(17420,2,7209,0),(17421,10,7209,0),(17422,2,7210,0),(17423,10,7210,0),(17424,2,7211,0),(17425,10,7211,0),(17426,2,7212,0),(17427,10,7212,0),(17428,2,7213,0),(17429,10,7213,0),(17430,2,7214,0),(17431,10,7214,0),(17432,2,7215,0),(17433,10,7215,0),(17434,2,7216,0),(17435,10,7216,0),(17436,2,7217,0),(17437,10,7217,0),(17438,2,7218,0),(17439,10,7218,0),(17440,2,7219,0),(17441,10,7219,0),(17442,2,7220,0),(17443,10,7220,0),(17444,2,7221,0),(17445,10,7221,0),(17446,2,7222,0),(17447,10,7222,0),(17448,2,7223,0),(17449,10,7223,0),(17450,2,7224,0),(17451,10,7224,0),(17452,2,7225,0),(17453,10,7225,0),(17454,2,7226,0),(17455,10,7226,0),(17456,2,7227,0),(17457,10,7227,0),(17458,2,7228,0),(17459,10,7228,0),(17460,2,7229,0),(17461,10,7229,0),(17462,2,7230,0),(17463,10,7230,0),(17464,2,7231,0),(17465,10,7231,0),(17466,2,7232,0),(17467,10,7232,0),(17468,2,7233,0),(17469,10,7233,0),(17470,2,7234,0),(17471,10,7234,0),(17472,2,7235,0),(17473,10,7235,0),(17474,2,7236,0),(17475,10,7236,0),(17476,2,7237,0),(17477,10,7237,0),(17478,2,7238,0),(17479,10,7238,0),(17480,2,7239,0),(17481,10,7239,0),(17482,2,7240,0),(17483,10,7240,0),(17484,2,7241,0),(17485,10,7241,0),(17486,2,7242,0),(17487,10,7242,0),(17488,2,7243,0),(17489,10,7243,0),(17490,2,7244,0),(17491,10,7244,0),(17492,2,7245,0),(17493,10,7245,0),(17494,2,7246,0),(17495,10,7246,0),(17496,2,7247,0),(17497,10,7247,0),(17498,2,7248,0),(17499,10,7248,0),(17500,2,7249,0),(17501,10,7249,0),(17502,2,7250,0),(17503,10,7250,0),(17504,2,7251,0),(17505,10,7251,0),(17506,2,7252,0),(17507,10,7252,0),(17508,2,7253,0),(17509,10,7253,0),(17510,2,7254,0),(17511,10,7254,0),(17512,2,7255,0),(17513,10,7255,0),(17514,2,7256,0),(17515,10,7256,0),(17516,2,7257,0),(17517,10,7257,0),(17518,2,7258,0),(17519,10,7258,0),(17520,2,7259,0),(17521,10,7259,0),(17522,2,7260,0),(17523,10,7260,0),(17524,2,7261,0),(17525,10,7261,0),(17526,2,7262,0),(17527,10,7262,0),(17528,2,7263,0),(17529,10,7263,0),(17530,2,7264,0),(17531,10,7264,0),(17532,2,7265,0),(17533,10,7265,0),(17534,2,7266,0),(17535,10,7266,0),(17536,2,7267,0),(17537,10,7267,0),(17538,2,7268,0),(17539,10,7268,0),(17540,2,7269,0),(17541,10,7269,0),(17542,2,7270,0),(17543,10,7270,0),(17544,2,7271,0),(17545,10,7271,0),(17546,2,7272,0),(17547,10,7272,0),(17548,2,7273,0),(17549,10,7273,0),(17550,2,7274,0),(17551,10,7274,0),(17552,2,7275,0),(17553,10,7275,0),(17554,2,7276,0),(17555,10,7276,0),(17556,2,7277,0),(17557,10,7277,0),(17558,2,7278,0),(17559,10,7278,0),(17560,2,7279,0),(17561,10,7279,0),(17562,2,7280,0),(17563,10,7280,0),(17564,2,7281,0),(17565,10,7281,0),(17566,2,7282,0),(17567,10,7282,0),(17568,2,7283,0),(17569,10,7283,0),(17570,2,7284,0),(17571,10,7284,0),(17572,2,7285,0),(17573,10,7285,0),(17574,2,7286,0),(17575,10,7286,0),(17576,2,7287,0),(17577,10,7287,0),(17578,2,7288,0),(17579,10,7288,0),(17580,2,7289,0),(17581,10,7289,0),(17582,2,7290,0),(17583,10,7290,0),(17584,2,7291,0),(17585,10,7291,0),(17586,2,7292,0),(17587,10,7292,0),(17588,2,7293,0),(17589,10,7293,0),(17590,2,7294,0),(17591,10,7294,0),(17592,2,7295,0),(17593,10,7295,0),(17594,2,7296,0),(17595,10,7296,0),(17596,2,7297,0),(17597,10,7297,0),(17598,2,7298,0),(17599,10,7298,0),(17600,2,7299,0),(17601,10,7299,0),(17602,2,7300,0),(17603,10,7300,0),(17604,2,7301,0),(17605,10,7301,0),(17606,2,7302,0),(17607,10,7302,0),(17608,2,7303,0),(17609,10,7303,0),(17610,2,7304,0),(17611,10,7304,0),(17612,2,7305,0),(17613,10,7305,0),(17614,2,7306,0),(17615,10,7306,0),(17616,2,7307,0),(17617,10,7307,0),(17618,2,7308,0),(17619,10,7308,0),(17620,2,7309,0),(17621,10,7309,0),(17622,2,7310,0),(17623,10,7310,0),(17624,2,7311,0),(17625,10,7311,0),(17626,2,7312,0),(17627,10,7312,0),(17628,2,7313,0),(17629,10,7313,0),(17630,2,7314,0),(17631,10,7314,0),(17632,2,7315,0),(17633,10,7315,0),(17634,2,7316,0),(17635,10,7316,0),(17636,2,7317,0),(17637,10,7317,0),(17638,2,7318,0),(17639,10,7318,0),(17640,2,7319,0),(17641,10,7319,0),(17642,2,7320,0),(17643,10,7320,0),(17644,2,7321,0),(17645,10,7321,0),(17646,2,7322,0),(17647,10,7322,0),(17648,2,7323,0),(17649,10,7323,0),(17650,2,7324,0),(17651,10,7324,0),(17652,2,7325,0),(17653,10,7325,0),(17654,2,7326,0),(17655,10,7326,0),(17656,2,7327,0),(17657,10,7327,0),(17658,2,7328,0),(17659,10,7328,0),(17660,2,7329,0),(17661,10,7329,0),(17662,2,7330,0),(17663,10,7330,0),(17664,2,7331,0),(17665,10,7331,0),(17666,2,7332,0),(17667,10,7332,0),(17668,2,7333,0),(17669,10,7333,0),(17670,2,7334,0),(17671,10,7334,0),(17672,2,7335,0),(17673,10,7335,0),(17674,2,7336,0),(17675,10,7336,0),(17676,2,7337,0),(17677,10,7337,0),(17678,2,7338,0),(17679,10,7338,0),(17680,2,7339,0),(17681,10,7339,0),(17682,2,7340,0),(17683,10,7340,0),(17684,2,7341,0),(17685,10,7341,0),(17686,2,7342,0),(17687,10,7342,0),(17688,2,7343,0),(17689,10,7343,0),(17690,2,7344,0),(17691,10,7344,0),(17692,2,7345,0),(17693,10,7345,0),(17694,2,7346,0),(17695,10,7346,0),(17696,2,7347,0),(17697,10,7347,0),(17698,2,7348,0),(17699,10,7348,0),(17700,2,7349,0),(17701,10,7349,0),(17702,2,7350,0),(17703,10,7350,0),(17704,2,7351,0),(17705,10,7351,0),(17706,2,7352,0),(17707,10,7352,0),(17708,2,7353,0),(17709,10,7353,0),(17710,2,7354,0),(17711,10,7354,0),(17712,2,7355,0),(17713,10,7355,0),(17714,2,7356,0),(17715,10,7356,0),(17716,2,7357,0),(17717,10,7357,0),(17718,2,7358,0),(17719,10,7358,0),(17720,2,7359,0),(17721,10,7359,0),(17722,2,7360,0),(17723,10,7360,0),(17724,2,7361,0),(17725,10,7361,0),(17726,2,7362,0),(17727,10,7362,0),(17728,2,7363,0),(17729,10,7363,0),(17730,2,7364,0),(17731,10,7364,0),(17732,2,7365,0),(17733,10,7365,0),(17734,2,7366,0),(17735,10,7366,0),(17736,2,7367,0),(17737,10,7367,0),(17738,2,7368,0),(17739,10,7368,0),(17740,2,7369,0),(17741,10,7369,0),(17742,2,7370,0),(17743,10,7370,0),(17744,2,7371,0),(17745,10,7371,0),(17746,2,7372,0),(17747,10,7372,0),(17748,2,7373,0),(17749,10,7373,0),(17750,2,7374,0),(17751,10,7374,0),(17752,2,7375,0),(17753,10,7375,0),(17754,2,7376,0),(17755,10,7376,0),(17756,2,7377,0),(17757,10,7377,0),(17758,2,7378,0),(17759,10,7378,0),(17760,2,7379,0),(17761,10,7379,0),(17762,2,7380,0),(17763,10,7380,0),(17764,2,7381,0),(17765,10,7381,0),(17766,2,7382,0),(17767,10,7382,0),(17768,2,7383,0),(17769,10,7383,0),(17770,2,7384,0),(17771,10,7384,0),(17772,2,7385,0),(17773,10,7385,0),(17774,2,7386,0),(17775,10,7386,0),(17776,2,7387,0),(17777,10,7387,0),(17778,2,7388,0),(17779,10,7388,0),(17780,2,7389,0),(17781,10,7389,0),(17782,2,7390,0),(17783,10,7390,0),(17784,2,7391,0),(17785,10,7391,0),(17786,2,7392,0),(17787,10,7392,0),(17788,2,7393,0),(17789,10,7393,0),(17790,2,7394,0),(17791,10,7394,0),(17792,2,7395,0),(17793,10,7395,0),(17794,2,7396,0),(17795,10,7396,0),(17796,2,7397,0),(17797,10,7397,0),(17798,2,7398,0),(17799,10,7398,0),(17800,2,7399,0),(17801,10,7399,0),(17802,2,7400,0),(17803,10,7400,0),(17804,2,7401,0),(17805,10,7401,0),(17806,2,7402,0),(17807,10,7402,0),(17808,2,7403,0),(17809,10,7403,0),(17810,2,7404,0),(17811,10,7404,0),(17812,2,7405,0),(17813,10,7405,0),(17814,2,7406,0),(17815,10,7406,0),(17816,2,7407,0),(17817,10,7407,0),(17818,2,7408,0),(17819,10,7408,0),(17820,2,7409,0),(17821,10,7409,0),(17822,2,7410,0),(17823,10,7410,0),(17824,2,7411,0),(17825,10,7411,0),(17826,2,7412,0),(17827,10,7412,0),(17828,2,7413,0),(17829,10,7413,0),(17830,2,7414,0),(17831,10,7414,0),(17832,2,7415,0),(17833,10,7415,0),(17834,2,7416,0),(17835,10,7416,0),(17836,2,7417,0),(17837,10,7417,0),(17838,2,7418,0),(17839,10,7418,0),(17840,2,7419,0),(17841,10,7419,0),(17842,2,7420,0),(17843,10,7420,0),(17844,2,7421,0),(17845,10,7421,0),(17846,2,7422,0),(17847,10,7422,0),(17848,2,7423,0),(17849,10,7423,0),(17850,2,7424,0),(17851,10,7424,0),(17852,2,7425,0),(17853,10,7425,0),(17854,2,7426,0),(17855,10,7426,0),(17856,2,7427,0),(17857,10,7427,0),(17858,2,7428,0),(17859,10,7428,0),(17860,2,7429,0),(17861,10,7429,0),(17862,2,7430,0),(17863,10,7430,0),(17864,2,7431,0),(17865,10,7431,0),(17866,2,7432,0),(17867,10,7432,0),(17868,2,7433,0),(17869,10,7433,0),(17870,2,7434,0),(17871,10,7434,0),(17872,2,7435,0),(17873,10,7435,0),(17874,2,7436,0),(17875,10,7436,0),(17876,2,7437,0),(17877,10,7437,0),(17878,2,7438,0),(17879,10,7438,0),(17880,2,7439,0),(17881,10,7439,0),(17882,2,7440,0),(17883,10,7440,0),(17884,2,7441,0),(17885,10,7441,0),(17886,2,7442,0),(17887,10,7442,0),(17888,2,7443,0),(17889,10,7443,0),(17890,2,7444,0),(17891,10,7444,0),(17892,2,7445,0),(17893,10,7445,0),(17894,2,7446,0),(17895,10,7446,0),(17896,2,7447,0),(17897,10,7447,0),(17898,2,7448,0),(17899,10,7448,0),(17900,2,7449,0),(17901,10,7449,0),(17902,2,7450,0),(17903,10,7450,0),(17904,2,7451,0),(17905,10,7451,0),(17906,2,7452,0),(17907,10,7452,0),(17908,2,7453,0),(17909,10,7453,0),(17910,2,7454,0),(17911,10,7454,0),(17912,2,7455,0),(17913,10,7455,0),(17914,2,7456,0),(17915,10,7456,0),(17916,2,7457,0),(17917,10,7457,0),(17918,2,7458,0),(17919,10,7458,0),(17920,2,7459,0),(17921,10,7459,0),(17922,2,7460,0),(17923,10,7460,0),(17924,2,7461,0),(17925,10,7461,0),(17926,2,7462,0),(17927,10,7462,0),(17928,2,7463,0),(17929,10,7463,0),(17930,2,7464,0),(17931,10,7464,0),(17932,2,7465,0),(17933,10,7465,0),(17934,2,7466,0),(17935,10,7466,0),(17936,2,7467,0),(17937,10,7467,0),(17938,2,7468,0),(17939,10,7468,0),(17940,2,7469,0),(17941,10,7469,0),(17942,2,7470,0),(17943,10,7470,0),(17944,2,7471,0),(17945,10,7471,0),(17946,2,7472,0),(17947,10,7472,0),(17948,2,7473,0),(17949,10,7473,0),(17950,2,7474,0),(17951,10,7474,0),(17952,2,7475,0),(17953,10,7475,0),(17954,2,7476,0),(17955,10,7476,0),(17956,2,7477,0),(17957,10,7477,0),(17958,2,7478,0),(17959,10,7478,0),(17960,2,7479,0),(17961,10,7479,0),(17962,2,7480,0),(17963,10,7480,0),(17964,2,7481,0),(17965,10,7481,0),(17966,2,7482,0),(17967,10,7482,0),(17968,2,7483,0),(17969,10,7483,0),(17970,2,7484,0),(17971,10,7484,0),(17972,2,7485,0),(17973,10,7485,0),(17974,2,7486,0),(17975,10,7486,0),(17976,2,7487,0),(17977,10,7487,0),(17978,2,7488,0),(17979,10,7488,0),(17980,2,7489,0),(17981,10,7489,0),(17982,2,7490,0),(17983,10,7490,0),(17984,2,7491,0),(17985,10,7491,0),(17986,2,7492,0),(17987,10,7492,0),(17988,2,7493,0),(17989,10,7493,0),(17990,2,7494,0),(17991,10,7494,0),(17992,2,7495,0),(17993,10,7495,0),(17994,2,7496,0),(17995,10,7496,0),(17996,2,7497,0),(17997,10,7497,0),(17998,2,7498,0),(17999,10,7498,0),(18000,2,7499,0),(18001,10,7499,0),(18002,2,7500,0),(18003,10,7500,0),(18004,2,7501,0),(18005,10,7501,0),(18006,2,7502,0),(18007,10,7502,0),(18008,2,7503,0),(18009,10,7503,0),(18010,2,7504,0),(18011,10,7504,0),(18012,2,7505,0),(18013,10,7505,0),(18014,2,7506,0),(18015,10,7506,0),(18016,2,7507,0),(18017,10,7507,0),(18018,2,7508,0),(18019,10,7508,0),(18020,2,7509,0),(18021,10,7509,0),(18022,2,7510,0),(18023,10,7510,0),(18024,2,7511,0),(18025,10,7511,0),(18026,2,7512,0),(18027,10,7512,0),(18028,2,7513,0),(18029,10,7513,0),(18030,2,7514,0),(18031,10,7514,0),(18032,2,7515,0),(18033,10,7515,0),(18034,2,7516,0),(18035,10,7516,0),(18036,2,7517,0),(18037,10,7517,0),(18038,2,7518,0),(18039,10,7518,0),(18040,2,7519,0),(18041,10,7519,0),(18042,2,7520,0),(18043,10,7520,0),(18044,2,7521,0),(18045,10,7521,0),(18046,2,7522,0),(18047,10,7522,0),(18048,2,7523,0),(18049,10,7523,0),(18050,2,7524,0),(18051,10,7524,0),(18052,2,7525,0),(18053,10,7525,0),(18054,2,7526,0),(18055,10,7526,0),(18056,2,7527,0),(18057,10,7527,0),(18058,2,7528,0),(18059,10,7528,0),(18060,2,7529,0),(18061,10,7529,0),(18062,2,7530,0),(18063,10,7530,0),(18064,2,7531,0),(18065,10,7531,0),(18066,2,7532,0),(18067,10,7532,0),(18068,2,7533,0),(18069,10,7533,0),(18070,2,7534,0),(18071,10,7534,0),(18072,2,7535,0),(18073,10,7535,0),(18074,2,7536,0),(18075,10,7536,0),(18076,2,7537,0),(18077,10,7537,0),(18078,2,7538,0),(18079,10,7538,0),(18080,2,7539,0),(18081,10,7539,0),(18082,2,7540,0),(18083,10,7540,0),(18084,2,7541,0),(18085,10,7541,0),(18086,2,7542,0),(18087,10,7542,0),(18088,2,7543,0),(18089,10,7543,0),(18090,2,7544,0),(18091,10,7544,0),(18092,2,7545,0),(18093,10,7545,0),(18094,2,7546,0),(18095,10,7546,0),(18096,2,7547,0),(18097,10,7547,0),(18098,2,7548,0),(18099,10,7548,0),(18100,2,7549,0),(18101,10,7549,0),(18102,2,7550,0),(18103,10,7550,0),(18104,2,7551,0),(18105,10,7551,0),(18106,2,7552,0),(18107,10,7552,0),(18108,2,7553,0),(18109,10,7553,0),(18110,2,7554,0),(18111,10,7554,0),(18112,2,7555,0),(18113,10,7555,0),(18114,2,7556,0),(18115,10,7556,0),(18116,2,7557,0),(18117,10,7557,0),(18118,2,7558,0),(18119,10,7558,0),(18120,2,7559,0),(18121,10,7559,0),(18122,2,7560,0),(18123,10,7560,0),(18124,2,7561,0),(18125,10,7561,0),(18126,2,7562,0),(18127,10,7562,0),(18128,2,7563,0),(18129,10,7563,0),(18130,2,7564,0),(18131,10,7564,0),(18132,2,7565,0),(18133,10,7565,0),(18134,2,7566,0),(18135,10,7566,0),(18136,2,7567,0),(18137,10,7567,0),(18138,2,7568,0),(18139,10,7568,0),(18140,2,7569,0),(18141,10,7569,0),(18142,2,7570,0),(18143,10,7570,0),(18144,2,7571,0),(18145,10,7571,0),(18146,2,7572,0),(18147,10,7572,0),(18148,2,7573,0),(18149,10,7573,0),(18150,2,7574,0),(18151,10,7574,0),(18152,2,7575,0),(18153,10,7575,0),(18154,2,7576,0),(18155,10,7576,0),(18156,2,7577,0),(18157,10,7577,0),(18158,2,7578,0),(18159,10,7578,0),(18160,2,7579,0),(18161,10,7579,0),(18162,2,7580,0),(18163,10,7580,0),(18164,2,7581,0),(18165,10,7581,0),(18166,2,7582,0),(18167,10,7582,0),(18168,2,7583,0),(18169,10,7583,0),(18170,2,7584,0),(18171,10,7584,0),(18172,2,7585,0),(18173,10,7585,0),(18174,2,7586,0),(18175,10,7586,0),(18176,2,7587,0),(18177,10,7587,0),(18178,2,7588,0),(18179,10,7588,0),(18180,2,7589,0),(18181,10,7589,0),(18182,2,7590,0),(18183,10,7590,0),(18184,2,7591,0),(18185,10,7591,0),(18186,2,7592,0),(18187,10,7592,0),(18188,2,7593,0),(18189,10,7593,0),(18190,2,7594,0),(18191,10,7594,0),(18192,2,7595,0),(18193,10,7595,0),(18194,2,7596,0),(18195,10,7596,0),(18196,2,7597,0),(18197,10,7597,0),(18198,2,7598,0),(18199,10,7598,0),(18200,2,7599,0),(18201,10,7599,0),(18202,2,7600,0),(18203,10,7600,0),(18204,2,7601,0),(18205,10,7601,0),(18206,2,7602,0),(18207,10,7602,0),(18208,2,7603,0),(18209,10,7603,0),(18210,2,7604,0),(18211,10,7604,0),(18212,2,7605,0),(18213,10,7605,0),(18214,2,7606,0),(18215,10,7606,0),(18216,2,7607,0),(18217,10,7607,0),(18218,2,7608,0),(18219,10,7608,0),(18220,2,7609,0),(18221,10,7609,0),(18222,2,7610,0),(18223,10,7610,0),(18224,2,7611,0),(18225,10,7611,0),(18226,2,7612,0),(18227,10,7612,0),(18228,2,7613,0),(18229,10,7613,0),(18230,2,7614,0),(18231,10,7614,0),(18232,2,7615,0),(18233,10,7615,0),(18234,2,7616,0),(18235,10,7616,0),(18236,2,7617,0),(18237,10,7617,0),(18238,2,7618,0),(18239,10,7618,0),(18240,2,7619,0),(18241,10,7619,0),(18242,2,7620,0),(18243,10,7620,0),(18244,2,7621,0),(18245,10,7621,0),(18246,2,7622,0),(18247,10,7622,0),(18248,2,7623,0),(18249,10,7623,0),(18250,2,7624,0),(18251,10,7624,0),(18252,2,7625,0),(18253,10,7625,0),(18254,2,7626,0),(18255,10,7626,0),(18256,2,7627,0),(18257,10,7627,0),(18258,2,7628,0),(18259,10,7628,0),(18260,2,7629,0),(18261,10,7629,0),(18262,2,7630,0),(18263,10,7630,0),(18264,2,7631,0),(18265,10,7631,0),(18266,2,7632,0),(18267,10,7632,0),(18268,2,7633,0),(18269,10,7633,0),(18270,2,7634,0),(18271,10,7634,0),(18272,2,7635,0),(18273,10,7635,0),(18274,2,7636,0),(18275,10,7636,0),(18276,2,7637,0),(18277,10,7637,0),(18278,2,7638,0),(18279,10,7638,0),(18280,2,7639,0),(18281,10,7639,0),(18282,2,7640,0),(18283,10,7640,0),(18284,2,7641,0),(18285,10,7641,0),(18286,2,7642,0),(18287,10,7642,0),(18288,2,7643,0),(18289,10,7643,0),(18290,2,7644,0),(18291,10,7644,0),(18292,2,7645,0),(18293,10,7645,0),(18294,2,7646,0),(18295,10,7646,0),(18296,2,7647,0),(18297,10,7647,0),(18298,2,7648,0),(18299,10,7648,0),(18300,2,7649,0),(18301,10,7649,0),(18302,2,7650,0),(18303,10,7650,0),(18304,2,7651,0),(18305,10,7651,0),(18306,2,7652,0),(18307,10,7652,0),(18308,2,7653,0),(18309,10,7653,0),(18310,2,7654,0),(18311,10,7654,0),(18312,2,7655,0),(18313,10,7655,0),(18314,2,7656,0),(18315,10,7656,0),(18316,2,7657,0),(18317,10,7657,0),(18318,2,7658,0),(18319,10,7658,0),(18320,2,7659,0),(18321,10,7659,0),(18322,2,7660,0),(18323,10,7660,0),(18324,2,7661,0),(18325,10,7661,0),(18326,2,7662,0),(18327,10,7662,0),(18328,2,7663,0),(18329,10,7663,0),(18330,2,7664,0),(18331,10,7664,0),(18332,2,7665,0),(18333,10,7665,0),(18334,2,7666,0),(18335,10,7666,0),(18336,2,7667,0),(18337,10,7667,0),(18338,2,7668,0),(18339,10,7668,0),(18340,2,7669,0),(18341,10,7669,0),(18342,2,7670,0),(18343,10,7670,0),(18344,2,7671,0),(18345,10,7671,0),(18346,2,7672,0),(18347,10,7672,0),(18348,2,7673,0),(18349,10,7673,0),(18350,2,7674,0),(18351,10,7674,0),(18352,2,7675,0),(18353,10,7675,0),(18354,2,7676,0),(18355,10,7676,0),(18356,2,7677,0),(18357,10,7677,0),(18358,2,7678,0),(18359,10,7678,0),(18360,2,7679,0),(18361,10,7679,0),(18362,2,7680,0),(18363,10,7680,0),(18364,2,7681,0),(18365,10,7681,0),(18366,2,7682,0),(18367,10,7682,0),(18368,2,7683,0),(18369,10,7683,0),(18370,2,7684,0),(18371,10,7684,0),(18372,2,7685,0),(18373,10,7685,0),(18374,2,7686,0),(18375,10,7686,0),(18376,2,7687,0),(18377,10,7687,0),(18378,2,7688,0),(18379,10,7688,0),(18380,2,7689,0),(18381,10,7689,0),(18382,2,7690,0),(18383,10,7690,0),(18384,2,7691,0),(18385,10,7691,0),(18386,2,7692,0),(18387,10,7692,0),(18388,2,7693,0),(18389,10,7693,0),(18390,2,7694,0),(18391,10,7694,0),(18392,2,7695,0),(18393,10,7695,0),(18394,2,7696,0),(18395,10,7696,0),(18396,2,7697,0),(18397,10,7697,0),(18398,2,7698,0),(18399,10,7698,0),(18400,2,7699,0),(18401,10,7699,0),(18402,2,7700,0),(18403,10,7700,0),(18404,2,7701,0),(18405,10,7701,0),(18406,2,7702,0),(18407,10,7702,0),(18408,2,7703,0),(18409,10,7703,0),(18410,2,7704,0),(18411,10,7704,0),(18412,2,7705,0),(18413,10,7705,0),(18414,2,7706,0),(18415,10,7706,0),(18416,2,7707,0),(18417,10,7707,0),(18418,2,7708,0),(18419,10,7708,0),(18420,2,7709,0),(18421,10,7709,0),(18422,2,7710,0),(18423,10,7710,0),(18424,2,7711,0),(18425,10,7711,0),(18426,2,7712,0),(18427,10,7712,0),(18428,2,7713,0),(18429,10,7713,0),(18430,2,7714,0),(18431,10,7714,0),(18432,2,7715,0),(18433,10,7715,0),(18434,2,7716,0),(18435,10,7716,0),(18436,2,7717,0),(18437,10,7717,0),(18438,2,7718,0),(18439,10,7718,0),(18440,2,7719,0),(18441,10,7719,0),(18442,2,7720,0),(18443,10,7720,0),(18444,2,7721,0),(18445,10,7721,0),(18446,2,7722,0),(18447,10,7722,0),(18448,2,7723,0),(18449,10,7723,0),(18450,2,7724,0),(18451,10,7724,0),(18452,2,7725,0),(18453,10,7725,0),(18454,2,7726,0),(18455,10,7726,0),(18456,2,7727,0),(18457,10,7727,0),(18458,2,7728,0),(18459,10,7728,0),(18460,2,7729,0),(18461,10,7729,0),(18462,2,7730,0),(18463,10,7730,0),(18464,2,7731,0),(18465,10,7731,0),(18466,2,7732,0),(18467,10,7732,0),(18468,2,7733,0),(18469,10,7733,0),(18470,2,7734,0),(18471,10,7734,0),(18472,2,7735,0),(18473,10,7735,0),(18474,2,7736,0),(18475,10,7736,0),(18476,2,7737,0),(18477,10,7737,0),(18478,2,7738,0),(18479,10,7738,0),(18480,2,7739,0),(18481,10,7739,0),(18482,2,7740,0),(18483,10,7740,0),(18484,2,7741,0),(18485,10,7741,0),(18486,2,7742,0),(18487,10,7742,0),(18488,2,7743,0),(18489,10,7743,0),(18490,2,7744,0),(18491,10,7744,0),(18492,2,7745,0),(18493,10,7745,0),(18494,2,7746,0),(18495,10,7746,0),(18496,2,7747,0),(18497,10,7747,0),(18498,2,7748,0),(18499,10,7748,0),(18500,2,7749,0),(18501,10,7749,0),(18502,2,7750,0),(18503,10,7750,0),(18504,2,7751,0),(18505,10,7751,0),(18506,2,7752,0),(18507,10,7752,0),(18508,2,7753,0),(18509,10,7753,0),(18510,2,7754,0),(18511,10,7754,0),(18512,2,7755,0),(18513,10,7755,0),(18514,2,7756,0),(18515,10,7756,0),(18516,2,7757,0),(18517,10,7757,0),(18518,2,7758,0),(18519,10,7758,0),(18520,2,7759,0),(18521,10,7759,0),(18522,2,7760,0),(18523,10,7760,0),(18524,2,7761,0),(18525,10,7761,0),(18526,2,7762,0),(18527,10,7762,0),(18528,2,7763,0),(18529,10,7763,0),(18530,2,7764,0),(18531,10,7764,0),(18532,2,7765,0),(18533,10,7765,0),(18534,2,7766,0),(18535,10,7766,0),(18536,2,7767,0),(18537,10,7767,0),(18538,2,7768,0),(18539,10,7768,0),(18540,2,7769,0),(18541,10,7769,0),(18542,2,7770,0),(18543,10,7770,0),(18544,2,7771,0),(18545,10,7771,0),(18546,2,7772,0),(18547,10,7772,0),(18548,2,7773,0),(18549,10,7773,0),(18550,2,7774,0),(18551,10,7774,0),(18552,2,7775,0),(18553,10,7775,0),(18554,2,7776,0),(18555,10,7776,0),(18556,2,7777,0),(18557,10,7777,0),(18558,2,7778,0),(18559,10,7778,0),(18560,2,7779,0),(18561,10,7779,0),(18562,2,7780,0),(18563,10,7780,0),(18564,2,7781,0),(18565,10,7781,0),(18566,2,7782,0),(18567,10,7782,0),(18568,2,7783,0),(18569,10,7783,0),(18570,2,7784,0),(18571,10,7784,0),(18572,2,7785,0),(18573,10,7785,0),(18574,2,7786,0),(18575,10,7786,0),(18576,2,7787,0),(18577,10,7787,0),(18578,2,7788,0),(18579,10,7788,0),(18580,2,7789,0),(18581,10,7789,0),(18582,2,7790,0),(18583,10,7790,0),(18584,2,7791,0),(18585,10,7791,0),(18586,2,7792,0),(18587,10,7792,0),(18588,2,7793,0),(18589,10,7793,0),(18590,2,7794,0),(18591,10,7794,0),(18592,2,7795,0),(18593,10,7795,0),(18594,2,7796,0),(18595,10,7796,0),(18596,2,7797,0),(18597,10,7797,0),(18598,2,7798,0),(18599,10,7798,0),(18600,2,7799,0),(18601,10,7799,0),(18602,2,7800,0),(18603,10,7800,0),(18604,2,7801,0),(18605,10,7801,0),(18606,2,7802,0),(18607,10,7802,0),(18608,2,7803,0),(18609,10,7803,0),(18610,2,7804,0),(18611,10,7804,0),(18612,2,7805,0),(18613,10,7805,0),(18614,2,7806,0),(18615,10,7806,0),(18616,2,7807,0),(18617,10,7807,0),(18618,2,7808,0),(18619,10,7808,0),(18620,2,7809,0),(18621,10,7809,0),(18622,2,7810,0),(18623,10,7810,0),(18624,2,7811,0),(18625,10,7811,0),(18626,2,7812,0),(18627,10,7812,0),(18628,2,7813,0),(18629,10,7813,0),(18630,2,7814,0),(18631,10,7814,0),(18632,2,7815,0),(18633,10,7815,0),(18634,2,7816,0),(18635,10,7816,0),(18636,2,7817,0),(18637,10,7817,0),(18638,2,7818,0),(18639,10,7818,0),(18640,2,7819,0),(18641,10,7819,0),(18642,2,7820,0),(18643,10,7820,0),(18644,2,7821,0),(18645,10,7821,0),(18646,2,7822,0),(18647,10,7822,0),(18648,2,7823,0),(18649,10,7823,0),(18650,2,7824,0),(18651,10,7824,0),(18652,2,7825,0),(18653,10,7825,0),(18654,2,7826,0),(18655,10,7826,0),(18656,2,7827,0),(18657,10,7827,0),(18658,2,7828,0),(18659,10,7828,0),(18660,2,7829,0),(18661,10,7829,0),(18662,2,7830,0),(18663,10,7830,0),(18664,2,7831,0),(18665,10,7831,0),(18666,2,7832,0),(18667,10,7832,0),(18668,2,7833,0),(18669,10,7833,0),(18670,2,7834,0),(18671,10,7834,0),(18672,2,7835,0),(18673,10,7835,0),(18674,2,7836,0),(18675,10,7836,0),(18676,2,7837,0),(18677,10,7837,0),(18678,2,7838,0),(18679,10,7838,0),(18680,2,7839,0),(18681,10,7839,0),(18682,2,7840,0),(18683,10,7840,0),(18684,2,7841,0),(18685,10,7841,0),(18686,2,7842,0),(18687,10,7842,0),(18688,2,7843,0),(18689,10,7843,0),(18690,2,7844,0),(18691,10,7844,0),(18692,2,7845,0),(18693,10,7845,0),(18694,2,7846,0),(18695,10,7846,0),(18696,2,7847,0),(18697,10,7847,0),(18698,2,7848,0),(18699,10,7848,0),(18700,2,7849,0),(18701,10,7849,0),(18702,2,7850,0),(18703,10,7850,0),(18704,2,7851,0),(18705,10,7851,0),(18706,2,7852,0),(18707,10,7852,0),(18708,2,7853,0),(18709,10,7853,0),(18710,2,7854,0),(18711,10,7854,0),(18712,2,7855,0),(18713,10,7855,0),(18714,2,7856,0),(18715,10,7856,0),(18716,2,7857,0),(18717,10,7857,0),(18718,2,7858,0),(18719,10,7858,0),(18720,2,7859,0),(18721,10,7859,0),(18722,2,7860,0),(18723,10,7860,0),(18724,2,7861,0),(18725,10,7861,0),(18726,2,7862,0),(18727,10,7862,0),(18728,2,7863,0),(18729,10,7863,0),(18730,2,7864,0),(18731,10,7864,0),(18732,2,7865,0),(18733,10,7865,0),(18734,2,7866,0),(18735,10,7866,0),(18736,2,7867,0),(18737,10,7867,0),(18738,2,7868,0),(18739,10,7868,0),(18740,2,7869,0),(18741,10,7869,0),(18742,2,7870,0),(18743,10,7870,0),(18744,2,7871,0),(18745,10,7871,0),(18746,2,7872,0),(18747,10,7872,0),(18748,2,7873,0),(18749,10,7873,0),(18750,2,7874,0),(18751,10,7874,0),(18752,2,7875,0),(18753,10,7875,0),(18754,2,7876,0),(18755,10,7876,0),(18756,2,7877,0),(18757,10,7877,0),(18758,2,7878,0),(18759,10,7878,0),(18760,2,7879,0),(18761,10,7879,0),(18762,2,7880,0),(18763,10,7880,0),(18764,2,7881,0),(18765,10,7881,0),(18766,2,7882,0),(18767,10,7882,0),(18768,2,7883,0),(18769,10,7883,0),(18770,2,7884,0),(18771,10,7884,0),(18772,2,7885,0),(18773,10,7885,0),(18774,2,7886,0),(18775,10,7886,0),(18776,2,7887,0),(18777,10,7887,0),(18778,2,7888,0),(18779,10,7888,0),(18780,2,7889,0),(18781,10,7889,0),(18782,2,7890,0),(18783,10,7890,0),(18784,2,7891,0),(18785,10,7891,0),(18786,2,7892,0),(18787,10,7892,0),(18788,2,7893,0),(18789,10,7893,0),(18790,2,7894,0),(18791,10,7894,0),(18792,2,7895,0),(18793,10,7895,0),(18794,2,7896,0),(18795,10,7896,0),(18796,2,7897,0),(18797,10,7897,0),(18798,2,7898,0),(18799,10,7898,0),(18800,2,7899,0),(18801,10,7899,0),(18802,2,7900,0),(18803,10,7900,0),(18804,2,7901,0),(18805,10,7901,0),(18806,2,7902,0),(18807,10,7902,0),(18808,2,7903,0),(18809,10,7903,0),(18810,2,7904,0),(18811,10,7904,0),(18812,2,7905,0),(18813,10,7905,0),(18814,2,7906,0),(18815,10,7906,0),(18816,2,7907,0),(18817,10,7907,0),(18818,2,7908,0),(18819,10,7908,0),(18820,2,7909,0),(18821,10,7909,0),(18822,2,7910,0),(18823,10,7910,0),(18824,2,7911,0),(18825,10,7911,0),(18826,2,7912,0),(18827,10,7912,0),(18828,2,7913,0),(18829,10,7913,0),(18830,2,7914,0),(18831,10,7914,0),(18832,2,7915,0),(18833,10,7915,0),(18834,2,7916,0),(18835,10,7916,0),(18836,2,7917,0),(18837,10,7917,0),(18838,2,7918,0),(18839,10,7918,0),(18840,2,7919,0),(18841,10,7919,0),(18842,2,7920,0),(18843,10,7920,0),(18844,2,7921,0),(18845,10,7921,0),(18846,2,7922,0),(18847,10,7922,0),(18848,2,7923,0),(18849,10,7923,0),(18850,2,7924,0),(18851,10,7924,0),(18852,2,7925,0),(18853,10,7925,0),(18854,2,7926,0),(18855,10,7926,0),(18856,2,7927,0),(18857,10,7927,0),(18858,2,7928,0),(18859,10,7928,0),(18860,2,7929,0),(18861,10,7929,0),(18862,2,7930,0),(18863,10,7930,0),(18864,2,7931,0),(18865,10,7931,0),(18866,2,7932,0),(18867,10,7932,0),(18868,2,7933,0),(18869,10,7933,0),(18870,2,7934,0),(18871,10,7934,0),(18872,2,7935,0),(18873,10,7935,0),(18874,2,7936,0),(18875,10,7936,0),(18876,2,7937,0),(18877,10,7937,0),(18878,2,7938,0),(18879,10,7938,0),(18880,2,7939,0),(18881,10,7939,0),(18882,2,7940,0),(18883,10,7940,0),(18884,2,7941,0),(18885,10,7941,0),(18886,2,7942,0),(18887,10,7942,0),(18888,2,7943,0),(18889,10,7943,0),(18890,2,7944,0),(18891,10,7944,0),(18892,2,7945,0),(18893,10,7945,0),(18894,2,7946,0),(18895,10,7946,0),(18896,2,7947,0),(18897,10,7947,0),(18898,2,7948,0),(18899,10,7948,0),(18900,2,7949,0),(18901,10,7949,0),(18902,2,7950,0),(18903,10,7950,0),(18904,2,7951,0),(18905,10,7951,0),(18906,2,7952,0),(18907,10,7952,0),(18908,2,7953,0),(18909,10,7953,0),(18910,2,7954,0),(18911,10,7954,0),(18912,2,7955,0),(18913,10,7955,0),(18914,2,7956,0),(18915,10,7956,0),(18916,2,7957,0),(18917,10,7957,0),(18918,2,7958,0),(18919,10,7958,0),(18920,2,7959,0),(18921,10,7959,0),(18922,2,7960,0),(18923,10,7960,0),(18924,2,7961,0),(18925,10,7961,0),(18926,2,7962,0),(18927,10,7962,0),(18928,2,7963,0),(18929,10,7963,0),(18930,2,7964,0),(18931,10,7964,0),(18932,2,7965,0),(18933,10,7965,0),(18934,2,7966,0),(18935,10,7966,0),(18936,2,7967,0),(18937,10,7967,0),(18938,2,7968,0),(18939,10,7968,0),(18940,2,7969,0),(18941,10,7969,0),(18942,2,7970,0),(18943,10,7970,0),(18944,2,7971,0),(18945,10,7971,0),(18946,2,7972,0),(18947,10,7972,0),(18948,2,7973,0),(18949,10,7973,0),(18950,2,7974,0),(18951,10,7974,0),(18952,2,7975,0),(18953,10,7975,0),(18954,2,7976,0),(18955,10,7976,0),(18956,2,7977,0),(18957,10,7977,0),(18958,2,7978,0),(18959,10,7978,0),(18960,2,7979,0),(18961,10,7979,0),(18962,2,7980,0),(18963,10,7980,0),(18964,2,7981,0),(18965,10,7981,0),(18966,2,7982,0),(18967,10,7982,0),(18968,2,7983,0),(18969,10,7983,0),(18970,2,7984,0),(18971,10,7984,0),(18972,2,7985,0),(18973,10,7985,0),(18974,2,7986,0),(18975,10,7986,0),(18976,2,7987,0),(18977,10,7987,0),(18978,2,7988,0),(18979,10,7988,0),(18980,2,7989,0),(18981,10,7989,0),(18982,2,7990,0),(18983,10,7990,0),(18984,2,7991,0),(18985,10,7991,0),(18986,2,7992,0),(18987,10,7992,0),(18988,2,7993,0),(18989,10,7993,0),(18990,2,7994,0),(18991,10,7994,0),(18992,2,7995,0),(18993,10,7995,0),(18994,2,7996,0),(18995,10,7996,0),(18996,2,7997,0),(18997,10,7997,0),(18998,2,7998,0),(18999,10,7998,0),(19000,2,7999,0),(19001,10,7999,0),(19002,2,8000,0),(19003,10,8000,0),(19004,2,8001,0),(19005,10,8001,0),(19006,2,8002,0),(19007,10,8002,0),(19008,2,8003,0),(19009,10,8003,0),(19010,2,8004,0),(19011,10,8004,0),(19012,2,8005,0),(19013,10,8005,0),(19014,2,8006,0),(19015,10,8006,0),(19016,2,8007,0),(19017,10,8007,0),(19018,2,8008,0),(19019,10,8008,0),(19020,2,8009,0),(19021,10,8009,0),(19022,2,8010,0),(19023,10,8010,0),(19024,2,8011,0),(19025,10,8011,0),(19026,2,8012,0),(19027,10,8012,0),(19028,2,8013,0),(19029,10,8013,0),(19030,2,8014,0),(19031,10,8014,0),(19032,2,8015,0),(19033,10,8015,0),(19034,2,8016,0),(19035,10,8016,0),(19036,2,8017,0),(19037,10,8017,0),(19038,2,8018,0),(19039,10,8018,0),(19040,2,8019,0),(19041,10,8019,0),(19042,2,8020,0),(19043,10,8020,0),(19044,2,8021,0),(19045,10,8021,0),(19046,2,8022,0),(19047,10,8022,0),(19048,2,8023,0),(19049,10,8023,0),(19050,2,8024,0),(19051,10,8024,0),(19052,2,8025,0),(19053,10,8025,0),(19054,2,8026,0),(19055,10,8026,0),(19056,2,8027,0),(19057,10,8027,0),(19058,2,8028,0),(19059,10,8028,0),(19060,2,8029,0),(19061,10,8029,0),(19062,2,8030,0),(19063,10,8030,0),(19064,2,8031,0),(19065,10,8031,0),(19066,2,8032,0),(19067,10,8032,0),(19068,2,8033,0),(19069,10,8033,0),(19070,2,8034,0),(19071,10,8034,0),(19072,2,8035,0),(19073,10,8035,0),(19074,2,8036,0),(19075,10,8036,0),(19076,2,8037,0),(19077,10,8037,0),(19078,2,8038,0),(19079,10,8038,0),(19080,2,8039,0),(19081,10,8039,0),(19082,2,8040,0),(19083,10,8040,0),(19084,2,8041,0),(19085,10,8041,0),(19086,2,8042,0),(19087,10,8042,0),(19088,2,8043,0),(19089,10,8043,0),(19090,2,8044,0),(19091,10,8044,0),(19092,2,8045,0),(19093,10,8045,0),(19094,2,8046,0),(19095,10,8046,0),(19096,2,8047,0),(19097,10,8047,0),(19098,2,8048,0),(19099,10,8048,0),(19100,2,8049,0),(19101,10,8049,0),(19102,2,8050,0),(19103,10,8050,0),(19104,2,8051,0),(19105,10,8051,0),(19106,2,8052,0),(19107,10,8052,0),(19108,2,8053,0),(19109,10,8053,0),(19110,2,8054,0),(19111,10,8054,0),(19112,2,8055,0),(19113,10,8055,0),(19114,2,8056,0),(19115,10,8056,0),(19116,2,8057,0),(19117,10,8057,0),(19118,2,8058,0),(19119,10,8058,0),(19120,2,8059,0),(19121,10,8059,0),(19122,2,8060,0),(19123,10,8060,0),(19124,2,8061,0),(19125,10,8061,0),(19126,2,8062,0),(19127,10,8062,0),(19128,2,8063,0),(19129,10,8063,0),(19130,2,8064,0),(19131,10,8064,0),(19132,2,8065,0),(19133,10,8065,0),(19134,2,8066,0),(19135,10,8066,0),(19136,2,8067,0),(19137,10,8067,0),(19138,2,8068,0),(19139,10,8068,0),(19140,2,8069,0),(19141,10,8069,0),(19142,2,8070,0),(19143,10,8070,0),(19144,2,8071,0),(19145,10,8071,0),(19146,2,8072,0),(19147,10,8072,0),(19148,2,8073,0),(19149,10,8073,0),(19150,2,8074,0),(19151,10,8074,0),(19152,2,8075,0),(19153,10,8075,0),(19154,2,8076,0),(19155,10,8076,0),(19156,2,8077,0),(19157,10,8077,0),(19158,2,8078,0),(19159,10,8078,0),(19160,2,8079,0),(19161,10,8079,0),(19162,2,8080,0),(19163,10,8080,0),(19164,2,8081,0),(19165,10,8081,0),(19166,2,8082,0),(19167,10,8082,0),(19168,2,8083,0),(19169,10,8083,0),(19170,2,8084,0),(19171,10,8084,0),(19172,2,8085,0),(19173,10,8085,0),(19174,2,8086,0),(19175,10,8086,0),(19176,2,8087,0),(19177,10,8087,0),(19178,2,8088,0),(19179,10,8088,0),(19180,2,8089,0),(19181,10,8089,0),(19182,2,8090,0),(19183,10,8090,0),(19184,2,8091,0),(19185,10,8091,0),(19186,2,8092,0),(19187,10,8092,0),(19188,2,8093,0),(19189,10,8093,0),(19190,2,8094,0),(19191,10,8094,0),(19192,2,8095,0),(19193,10,8095,0),(19194,2,8096,0),(19195,10,8096,0),(19196,2,8097,0),(19197,10,8097,0),(19198,2,8098,0),(19199,10,8098,0),(19200,2,8099,0),(19201,10,8099,0),(19202,2,8100,0),(19203,10,8100,0),(19204,2,8101,0),(19205,10,8101,0),(19206,2,8102,0),(19207,10,8102,0),(19208,2,8103,0),(19209,10,8103,0),(19210,2,8104,0),(19211,10,8104,0),(19212,2,8105,0),(19213,10,8105,0),(19214,2,8106,0),(19215,10,8106,0),(19216,2,8107,0),(19217,10,8107,0),(19218,2,8108,0),(19219,10,8108,0),(19220,2,8109,0),(19221,10,8109,0),(19222,2,8110,0),(19223,10,8110,0),(19224,2,8111,0),(19225,10,8111,0),(19226,2,8112,0),(19227,10,8112,0),(19228,2,8113,0),(19229,10,8113,0),(19230,2,8114,0),(19231,10,8114,0),(19232,2,8115,0),(19233,10,8115,0),(19234,2,8116,0),(19235,10,8116,0),(19236,2,8117,0),(19237,10,8117,0),(19238,2,8118,0),(19239,10,8118,0),(19240,2,8119,0),(19241,10,8119,0),(19242,2,8120,0),(19243,10,8120,0),(19244,2,8121,0),(19245,10,8121,0),(19246,2,8122,0),(19247,10,8122,0),(19248,2,8123,0),(19249,10,8123,0),(19250,2,8124,0),(19251,10,8124,0),(19252,2,8125,0),(19253,10,8125,0),(19254,2,8126,0),(19255,10,8126,0),(19256,2,8127,0),(19257,10,8127,0),(19258,2,8128,0),(19259,10,8128,0),(19260,2,8129,0),(19261,10,8129,0),(19262,2,8130,0),(19263,10,8130,0),(19264,2,8131,0),(19265,10,8131,0),(19266,2,8132,0),(19267,10,8132,0),(19268,2,8133,0),(19269,10,8133,0),(19270,2,8134,0),(19271,10,8134,0),(19272,2,8135,0),(19273,10,8135,0),(19274,2,8136,0),(19275,10,8136,0),(19276,2,8137,0),(19277,10,8137,0),(19278,2,8138,0),(19279,10,8138,0),(19280,2,8139,0),(19281,10,8139,0),(19282,2,8140,0),(19283,10,8140,0),(19284,2,8141,0),(19285,10,8141,0),(19286,2,8142,0),(19287,10,8142,0),(19288,2,8143,0),(19289,10,8143,0),(19290,2,8144,0),(19291,10,8144,0),(19292,2,8145,0),(19293,10,8145,0),(19294,2,8146,0),(19295,10,8146,0),(19296,2,8147,0),(19297,10,8147,0),(19298,2,8148,0),(19299,10,8148,0),(19300,2,8149,0),(19301,10,8149,0),(19302,2,8150,0),(19303,10,8150,0),(19304,2,8151,0),(19305,10,8151,0),(19306,2,8152,0),(19307,10,8152,0),(19308,2,8153,0),(19309,10,8153,0),(19310,2,8154,0),(19311,10,8154,0),(19312,2,8155,0),(19313,10,8155,0),(19314,2,8156,0),(19315,10,8156,0),(19316,2,8157,0),(19317,10,8157,0),(19318,2,8158,0),(19319,10,8158,0),(19320,2,8159,0),(19321,10,8159,0),(19322,2,8160,0),(19323,10,8160,0),(19324,2,8161,0),(19325,10,8161,0),(19326,2,8162,0),(19327,10,8162,0),(19328,2,8163,0),(19329,10,8163,0),(19330,2,8164,0),(19331,10,8164,0),(19332,2,8165,0),(19333,10,8165,0),(19334,2,8166,0),(19335,10,8166,0),(19336,2,8167,0),(19337,10,8167,0),(19338,2,8168,0),(19339,10,8168,0),(19340,2,8169,0),(19341,10,8169,0),(19342,2,8170,0),(19343,10,8170,0),(19344,2,8171,0),(19345,10,8171,0),(19346,2,8172,0),(19347,10,8172,0),(19348,2,8173,0),(19349,10,8173,0),(19350,2,8174,0),(19351,10,8174,0),(19352,2,8175,0),(19353,10,8175,0),(19354,2,8176,0),(19355,10,8176,0),(19356,2,8177,0),(19357,10,8177,0),(19358,2,8178,0),(19359,10,8178,0),(19360,2,8179,0),(19361,10,8179,0),(19362,2,8180,0),(19363,10,8180,0),(19364,2,8181,0),(19365,10,8181,0),(19366,2,8182,0),(19367,10,8182,0),(19368,2,8183,0),(19369,10,8183,0),(19370,2,8184,0),(19371,10,8184,0),(19372,2,8185,0),(19373,10,8185,0),(19374,2,8186,0),(19375,10,8186,0),(19376,2,8187,0),(19377,10,8187,0),(19378,2,8188,0),(19379,10,8188,0),(19380,2,8189,0),(19381,10,8189,0),(19382,2,8190,0),(19383,10,8190,0),(19384,2,8191,0),(19385,10,8191,0),(19386,2,8192,0),(19387,10,8192,0),(19388,2,8193,0),(19389,10,8193,0),(19390,2,8194,0),(19391,10,8194,0),(19392,2,8195,0),(19393,10,8195,0),(19394,2,8196,0),(19395,10,8196,0),(19396,2,8197,0),(19397,10,8197,0),(19398,2,8198,0),(19399,10,8198,0),(19400,2,8199,0),(19401,10,8199,0),(19402,2,8200,0),(19403,10,8200,0),(19404,2,8201,0),(19405,10,8201,0),(19406,2,8202,0),(19407,10,8202,0),(19408,2,8203,0),(19409,10,8203,0),(19410,2,8204,0),(19411,10,8204,0),(19412,2,8205,0),(19413,10,8205,0),(19414,2,8206,0),(19415,10,8206,0),(19416,2,8207,0),(19417,10,8207,0),(19418,2,8208,0),(19419,10,8208,0),(19420,2,8209,0),(19421,10,8209,0),(19422,2,8210,0),(19423,10,8210,0),(19424,2,8211,0),(19425,10,8211,0),(19426,2,8212,0),(19427,10,8212,0),(19428,2,8213,0),(19429,10,8213,0),(19430,2,8214,0),(19431,10,8214,0),(19432,2,8215,0),(19433,10,8215,0),(19434,2,8216,0),(19435,10,8216,0),(19436,2,8217,0),(19437,10,8217,0),(19438,2,8218,0),(19439,10,8218,0),(19440,2,8219,0),(19441,10,8219,0),(19442,2,8220,0),(19443,10,8220,0),(19444,2,8221,0),(19445,10,8221,0),(19446,2,8222,0),(19447,10,8222,0),(19448,2,8223,0),(19449,10,8223,0),(19450,2,8224,0),(19451,10,8224,0),(19452,2,8225,0),(19453,10,8225,0),(19454,2,8226,0),(19455,10,8226,0),(19456,2,8227,0),(19457,10,8227,0),(19458,2,8228,0),(19459,10,8228,0),(19460,2,8229,0),(19461,10,8229,0),(19462,2,8230,0),(19463,10,8230,0),(19464,2,8231,0),(19465,10,8231,0),(19466,2,8232,0),(19467,10,8232,0),(19468,2,8233,0),(19469,10,8233,0),(19470,2,8234,0),(19471,10,8234,0),(19472,2,8235,0),(19473,10,8235,0),(19474,2,8236,0),(19475,10,8236,0),(19476,2,8237,0),(19477,10,8237,0),(19478,2,8238,0),(19479,10,8238,0),(19480,2,8239,0),(19481,10,8239,0),(19482,2,8240,0),(19483,10,8240,0),(19484,2,8241,0),(19485,10,8241,0),(19486,2,8242,0),(19487,10,8242,0),(19488,2,8243,0),(19489,10,8243,0),(19490,2,8244,0),(19491,10,8244,0),(19492,2,8245,0),(19493,10,8245,0),(19494,2,8246,0),(19495,10,8246,0),(19496,2,8247,0),(19497,10,8247,0),(19498,2,8248,0),(19499,10,8248,0),(19500,2,8249,0),(19501,10,8249,0),(19502,2,8250,0),(19503,10,8250,0),(19504,2,8251,0),(19505,10,8251,0),(19506,2,8252,0),(19507,10,8252,0),(19508,2,8253,0),(19509,10,8253,0),(19510,2,8254,0),(19511,10,8254,0),(19512,2,8255,0),(19513,10,8255,0),(19514,2,8256,0),(19515,10,8256,0),(19516,2,8257,0),(19517,10,8257,0),(19518,2,8258,0),(19519,10,8258,0),(19520,2,8259,0),(19521,10,8259,0),(19522,2,8260,0),(19523,10,8260,0),(19524,2,8261,0),(19525,10,8261,0),(19526,2,8262,0),(19527,10,8262,0),(19528,2,8263,0),(19529,10,8263,0),(19530,2,8264,0),(19531,10,8264,0),(19532,2,8265,0),(19533,10,8265,0),(19534,2,8266,0),(19535,10,8266,0),(19536,2,8267,0),(19537,10,8267,0),(19538,2,8268,0),(19539,10,8268,0),(19540,2,8269,0),(19541,10,8269,0),(19542,2,8270,0),(19543,10,8270,0),(19544,2,8271,0),(19545,10,8271,0),(19546,2,8272,0),(19547,10,8272,0),(19548,2,8273,0),(19549,10,8273,0),(19550,2,8274,0),(19551,10,8274,0),(19552,2,8275,0),(19553,10,8275,0),(19554,2,8276,0),(19555,10,8276,0),(19556,2,8277,0),(19557,10,8277,0),(19558,2,8278,0),(19559,10,8278,0),(19560,2,8279,0),(19561,10,8279,0),(19562,2,8280,0),(19563,10,8280,0),(19564,2,8281,0),(19565,10,8281,0),(19566,2,8282,0),(19567,10,8282,0),(19568,2,8283,0),(19569,10,8283,0),(19570,2,8284,0),(19571,10,8284,0),(19572,2,8285,0),(19573,10,8285,0),(19574,2,8286,0),(19575,10,8286,0),(19576,2,8287,0),(19577,10,8287,0),(19578,2,8288,0),(19579,10,8288,0),(19580,2,8289,0),(19581,10,8289,0),(19582,2,8290,0),(19583,10,8290,0),(19584,2,8291,0),(19585,10,8291,0),(19586,2,8292,0),(19587,10,8292,0),(19588,2,8293,0),(19589,10,8293,0),(19590,2,8294,0),(19591,10,8294,0),(19592,2,8295,0),(19593,10,8295,0),(19594,2,8296,0),(19595,10,8296,0),(19596,2,8297,0),(19597,10,8297,0),(19598,2,8298,0),(19599,10,8298,0),(19600,2,8299,0),(19601,10,8299,0),(19602,2,8300,0),(19603,10,8300,0),(19604,2,8301,0),(19605,10,8301,0),(19606,2,8302,0),(19607,10,8302,0),(19608,2,8303,0),(19609,10,8303,0),(19610,2,8304,0),(19611,10,8304,0),(19612,2,8305,0),(19613,10,8305,0),(19614,2,8306,0),(19615,10,8306,0),(19616,2,8307,0),(19617,10,8307,0),(19618,2,8308,0),(19619,10,8308,0),(19620,2,8309,0),(19621,10,8309,0),(19622,2,8310,0),(19623,10,8310,0),(19624,2,8311,0),(19625,10,8311,0),(19626,2,8312,0),(19627,10,8312,0),(19628,2,8313,0),(19629,10,8313,0),(19630,2,8314,0),(19631,10,8314,0),(19632,2,8315,0),(19633,10,8315,0),(19634,2,8316,0),(19635,10,8316,0),(19636,2,8317,0),(19637,10,8317,0),(19638,2,8318,0),(19639,10,8318,0),(19640,2,8319,0),(19641,10,8319,0),(19642,2,8320,0),(19643,10,8320,0),(19644,2,8321,0),(19645,10,8321,0),(19646,2,8322,0),(19647,10,8322,0),(19648,2,8323,0),(19649,10,8323,0),(19650,2,8324,0),(19651,10,8324,0),(19652,2,8325,0),(19653,10,8325,0),(19654,2,8326,0),(19655,10,8326,0),(19656,2,8327,0),(19657,10,8327,0),(19658,2,8328,0),(19659,10,8328,0),(19660,2,8329,0),(19661,10,8329,0),(19662,2,8330,0),(19663,10,8330,0),(19664,2,8331,0),(19665,10,8331,0),(19666,2,8332,0),(19667,10,8332,0),(19668,2,8333,0),(19669,10,8333,0),(19670,2,8334,0),(19671,10,8334,0),(19672,2,8335,0),(19673,10,8335,0),(19674,2,8336,0),(19675,10,8336,0),(19676,2,8337,0),(19677,10,8337,0),(19678,2,8338,0),(19679,10,8338,0),(19680,2,8339,0),(19681,10,8339,0),(19682,2,8340,0),(19683,10,8340,0),(19684,2,8341,0),(19685,10,8341,0),(19686,2,8342,0),(19687,10,8342,0),(19688,2,8343,0),(19689,10,8343,0),(19690,2,8344,0),(19691,10,8344,0),(19692,2,8345,0),(19693,10,8345,0),(19694,2,8346,0),(19695,10,8346,0),(19696,2,8347,0),(19697,10,8347,0),(19698,2,8348,0),(19699,10,8348,0),(19700,2,8349,0),(19701,10,8349,0),(19702,2,8350,0),(19703,10,8350,0),(19704,2,8351,0),(19705,10,8351,0),(19706,2,8352,0),(19707,10,8352,0),(19708,2,8353,0),(19709,10,8353,0),(19710,2,8354,0),(19711,10,8354,0),(19712,2,8355,0),(19713,10,8355,0),(19714,2,8356,0),(19715,10,8356,0),(19716,2,8357,0),(19717,10,8357,0),(19718,2,8358,0),(19719,10,8358,0),(19720,2,8359,0),(19721,10,8359,0),(19722,2,8360,0),(19723,10,8360,0),(19724,2,8361,0),(19725,10,8361,0),(19726,2,8362,0),(19727,10,8362,0),(19728,2,8363,0),(19729,10,8363,0),(19730,2,8364,0),(19731,10,8364,0),(19732,2,8365,0),(19733,10,8365,0),(19734,2,8366,0),(19735,10,8366,0),(19736,2,8367,0),(19737,10,8367,0),(19738,2,8368,0),(19739,10,8368,0),(19740,2,8369,0),(19741,10,8369,0),(19742,2,8370,0),(19743,10,8370,0),(19744,2,8371,0),(19745,10,8371,0),(19746,2,8372,0),(19747,10,8372,0),(19748,2,8373,0),(19749,10,8373,0),(19750,2,8374,0),(19751,10,8374,0),(19752,2,8375,0),(19753,10,8375,0),(19754,2,8376,0),(19755,10,8376,0),(19756,2,8377,0),(19757,10,8377,0),(19758,2,8378,0),(19759,10,8378,0),(19760,2,8379,0),(19761,10,8379,0),(19762,2,8380,0),(19763,10,8380,0),(19764,2,8381,0),(19765,10,8381,0),(19766,2,8382,0),(19767,10,8382,0),(19768,2,8383,0),(19769,10,8383,0),(19770,2,8384,0),(19771,10,8384,0),(19772,2,8385,0),(19773,10,8385,0),(19774,2,8386,0),(19775,10,8386,0),(19776,2,8387,0),(19777,10,8387,0),(19778,2,8388,0),(19779,10,8388,0),(19780,2,8389,0),(19781,10,8389,0),(19782,2,8390,0),(19783,10,8390,0),(19784,2,8391,0),(19785,10,8391,0),(19786,2,8392,0),(19787,10,8392,0),(19788,2,8393,0),(19789,10,8393,0),(19790,2,8394,0),(19791,10,8394,0),(19792,2,8395,0),(19793,10,8395,0),(19794,2,8396,0),(19795,10,8396,0),(19796,2,8397,0),(19797,10,8397,0),(19798,2,8398,0),(19799,10,8398,0),(19800,2,8399,0),(19801,10,8399,0),(19802,2,8400,0),(19803,10,8400,0),(19804,2,8401,0),(19805,10,8401,0),(19806,2,8402,0),(19807,10,8402,0),(19808,2,8403,0),(19809,10,8403,0),(19810,2,8404,0),(19811,10,8404,0),(19812,2,8405,0),(19813,10,8405,0),(19814,2,8406,0),(19815,10,8406,0),(19816,2,8407,0),(19817,10,8407,0),(19818,2,8408,0),(19819,10,8408,0),(19820,2,8409,0),(19821,10,8409,0),(19822,2,8410,0),(19823,10,8410,0),(19824,2,8411,0),(19825,10,8411,0),(19826,2,8412,0),(19827,10,8412,0),(19828,2,8413,0),(19829,10,8413,0),(19830,2,8414,0),(19831,10,8414,0),(19832,2,8415,0),(19833,10,8415,0),(19834,2,8416,0),(19835,10,8416,0),(19836,2,8417,0),(19837,10,8417,0),(19838,2,8418,0),(19839,10,8418,0),(19840,2,8419,0),(19841,10,8419,0),(19842,2,8420,0),(19843,10,8420,0),(19844,2,8421,0),(19845,10,8421,0),(19846,2,8422,0),(19847,10,8422,0),(19848,2,8423,0),(19849,10,8423,0),(19850,2,8424,0),(19851,10,8424,0),(19852,2,8425,0),(19853,10,8425,0),(19854,2,8426,0),(19855,10,8426,0),(19856,2,8427,0),(19857,10,8427,0),(19858,2,8428,0),(19859,10,8428,0),(19860,2,8429,0),(19861,10,8429,0),(19862,2,8430,0),(19863,10,8430,0),(19864,2,8431,0),(19865,10,8431,0),(19866,2,8432,0),(19867,10,8432,0),(19868,2,8433,0),(19869,10,8433,0),(19870,2,8434,0),(19871,10,8434,0),(19872,2,8435,0),(19873,10,8435,0),(19874,2,8436,0),(19875,10,8436,0),(19876,2,8437,0),(19877,10,8437,0),(19878,2,8438,0),(19879,10,8438,0),(19880,2,8439,0),(19881,10,8439,0),(19882,2,8440,0),(19883,10,8440,0),(19884,2,8441,0),(19885,10,8441,0),(19886,2,8442,0),(19887,10,8442,0),(19888,2,8443,0),(19889,10,8443,0),(19890,2,8444,0),(19891,10,8444,0),(19892,2,8445,0),(19893,10,8445,0),(19894,2,8446,0),(19895,10,8446,0),(19896,2,8447,0),(19897,10,8447,0),(19898,2,8448,0),(19899,10,8448,0),(19900,2,8449,0),(19901,10,8449,0),(19902,2,8450,0),(19903,10,8450,0),(19904,2,8451,0),(19905,10,8451,0),(19906,2,8452,0),(19907,10,8452,0),(19908,2,8453,0),(19909,10,8453,0),(19910,2,8454,0),(19911,10,8454,0),(19912,2,8455,0),(19913,10,8455,0),(19914,2,8456,0),(19915,10,8456,0),(19916,2,8457,0),(19917,10,8457,0),(19918,2,8458,0),(19919,10,8458,0),(19920,2,8459,0),(19921,10,8459,0),(19922,2,8460,0),(19923,10,8460,0),(19924,2,8461,0),(19925,10,8461,0),(19926,2,8462,0),(19927,10,8462,0),(19928,2,8463,0),(19929,10,8463,0),(19930,2,8464,0),(19931,10,8464,0),(19932,2,8465,0),(19933,10,8465,0),(19934,2,8466,0),(19935,10,8466,0),(19936,2,8467,0),(19937,10,8467,0),(19938,2,8468,0),(19939,10,8468,0),(19940,2,8469,0),(19941,10,8469,0),(19942,2,8470,0),(19943,10,8470,0),(19944,2,8471,0),(19945,10,8471,0),(19946,2,8472,0),(19947,10,8472,0),(19948,2,8473,0),(19949,10,8473,0),(19950,2,8474,0),(19951,10,8474,0),(19952,2,8475,0),(19953,10,8475,0),(19954,2,8476,0),(19955,10,8476,0),(19956,2,8477,0),(19957,10,8477,0),(19958,2,8478,0),(19959,10,8478,0),(19960,2,8479,0),(19961,10,8479,0),(19962,2,8480,0),(19963,10,8480,0),(19964,2,8481,0),(19965,10,8481,0),(19966,2,8482,0),(19967,10,8482,0),(19968,2,8483,0),(19969,10,8483,0),(19970,2,8484,0),(19971,10,8484,0),(19972,2,8485,0),(19973,10,8485,0),(19974,2,8486,0),(19975,10,8486,0),(19976,2,8487,0),(19977,10,8487,0),(19978,2,8488,0),(19979,10,8488,0),(19980,2,8489,0),(19981,10,8489,0),(19982,2,8490,0),(19983,10,8490,0),(19984,2,8491,0),(19985,10,8491,0),(19986,2,8492,0),(19987,10,8492,0),(19988,2,8493,0),(19989,10,8493,0),(19990,2,8494,0),(19991,10,8494,0),(19992,2,8495,0),(19993,10,8495,0),(19994,2,8496,0),(19995,10,8496,0),(19996,2,8497,0),(19997,10,8497,0),(19998,2,8498,0),(19999,10,8498,0),(20000,2,8499,0),(20001,10,8499,0),(20002,2,8500,0),(20003,10,8500,0),(20004,2,8501,0),(20005,10,8501,0),(20006,2,8502,0),(20007,10,8502,0),(20008,2,8503,0),(20009,10,8503,0),(20010,2,8504,0),(20011,10,8504,0),(20012,2,8505,0),(20013,10,8505,0),(20014,2,8506,0),(20015,10,8506,0),(20016,2,8507,0),(20017,10,8507,0),(20018,2,8508,0),(20019,10,8508,0),(20020,2,8509,0),(20021,10,8509,0),(20022,2,8510,0),(20023,10,8510,0),(20024,2,8511,0),(20025,10,8511,0),(20026,2,8512,0),(20027,10,8512,0),(20028,2,8513,0),(20029,10,8513,0),(20030,2,8514,0),(20031,10,8514,0),(20032,2,8515,0),(20033,10,8515,0),(20034,2,8516,0),(20035,10,8516,0),(20036,2,8517,0),(20037,10,8517,0),(20038,2,8518,0),(20039,10,8518,0),(20040,2,8519,0),(20041,10,8519,0),(20042,2,8520,0),(20043,10,8520,0),(20044,2,8521,0),(20045,10,8521,0),(20046,2,8522,0),(20047,10,8522,0),(20048,2,8523,0),(20049,10,8523,0),(20050,2,8524,0),(20051,10,8524,0),(20052,2,8525,0),(20053,10,8525,0),(20054,2,8526,0),(20055,10,8526,0),(20056,2,8527,0),(20057,10,8527,0),(20058,2,8528,0),(20059,10,8528,0),(20060,2,8529,0),(20061,10,8529,0),(20062,2,8530,0),(20063,10,8530,0),(20064,2,8531,0),(20065,10,8531,0),(20066,2,8532,0),(20067,10,8532,0),(20068,2,8533,0),(20069,10,8533,0),(20070,2,8534,0),(20071,10,8534,0),(20072,2,8535,0),(20073,10,8535,0),(20074,2,8536,0),(20075,10,8536,0),(20076,2,8537,0),(20077,10,8537,0),(20078,2,8538,0),(20079,10,8538,0),(20080,2,8539,0),(20081,10,8539,0),(20082,2,8540,0),(20083,10,8540,0),(20084,2,8541,0),(20085,10,8541,0),(20086,2,8542,0),(20087,10,8542,0),(20088,2,8543,0),(20089,10,8543,0),(20090,2,8544,0),(20091,10,8544,0),(20092,2,8545,0),(20093,10,8545,0),(20094,2,8546,0),(20095,10,8546,0),(20096,2,8547,0),(20097,10,8547,0),(20098,2,8548,0),(20099,10,8548,0),(20100,2,8549,0),(20101,10,8549,0),(20102,2,8550,0),(20103,10,8550,0),(20104,2,8551,0),(20105,10,8551,0),(20106,2,8552,0),(20107,10,8552,0),(20108,2,8553,0),(20109,10,8553,0),(20110,2,8554,0),(20111,10,8554,0),(20112,2,8555,0),(20113,10,8555,0),(20114,2,8556,0),(20115,10,8556,0),(20116,2,8557,0),(20117,10,8557,0),(20118,2,8558,0),(20119,10,8558,0),(20120,2,8559,0),(20121,10,8559,0),(20122,2,8560,0),(20123,10,8560,0),(20124,2,8561,0),(20125,10,8561,0),(20126,2,8562,0),(20127,10,8562,0),(20128,2,8563,0),(20129,10,8563,0),(20130,2,8564,0),(20131,10,8564,0),(20132,2,8565,0),(20133,10,8565,0),(20134,2,8566,0),(20135,10,8566,0),(20136,2,8567,0),(20137,10,8567,0),(20138,2,8568,0),(20139,10,8568,0),(20140,2,8569,0),(20141,10,8569,0),(20142,2,8570,0),(20143,10,8570,0),(20144,2,8571,0),(20145,10,8571,0),(20146,2,8572,0),(20147,10,8572,0),(20148,2,8573,0),(20149,10,8573,0),(20150,2,8574,0),(20151,10,8574,0),(20152,2,8575,0),(20153,10,8575,0),(20154,2,8576,0),(20155,10,8576,0),(20156,2,8577,0),(20157,10,8577,0),(20158,2,8578,0),(20159,10,8578,0),(20160,2,8579,0),(20161,10,8579,0),(20162,2,8580,0),(20163,10,8580,0),(20164,2,8581,0),(20165,10,8581,0),(20166,2,8582,0),(20167,10,8582,0),(20168,2,8583,0),(20169,10,8583,0),(20170,2,8584,0),(20171,10,8584,0),(20172,2,8585,0),(20173,10,8585,0),(20174,2,8586,0),(20175,10,8586,0),(20176,2,8587,0),(20177,10,8587,0),(20178,2,8588,0),(20179,10,8588,0),(20180,2,8589,0),(20181,10,8589,0),(20182,2,8590,0),(20183,10,8590,0),(20184,2,8591,0),(20185,10,8591,0),(20186,2,8592,0),(20187,10,8592,0),(20188,2,8593,0),(20189,10,8593,0),(20190,2,8594,0),(20191,10,8594,0),(20192,2,8595,0),(20193,10,8595,0),(20194,2,8596,0),(20195,10,8596,0),(20196,2,8597,0),(20197,10,8597,0),(20198,2,8598,0),(20199,10,8598,0),(20200,2,8599,0),(20201,10,8599,0),(20202,2,8600,0),(20203,10,8600,0),(20204,2,8601,0),(20205,10,8601,0),(20206,2,8602,0),(20207,10,8602,0),(20208,2,8603,0),(20209,10,8603,0),(20210,2,8604,0),(20211,10,8604,0),(20212,2,8605,0),(20213,10,8605,0),(20214,2,8606,0),(20215,10,8606,0),(20216,2,8607,0),(20217,10,8607,0),(20218,2,8608,0),(20219,10,8608,0),(20220,2,8609,0),(20221,10,8609,0),(20222,2,8610,0),(20223,10,8610,0),(20224,2,8611,0),(20225,10,8611,0),(20226,2,8612,0),(20227,10,8612,0),(20228,2,8613,0),(20229,10,8613,0),(20230,2,8614,0),(20231,10,8614,0),(20232,2,8615,0),(20233,10,8615,0),(20234,2,8616,0),(20235,10,8616,0),(20236,2,8617,0),(20237,10,8617,0),(20238,2,8618,0),(20239,10,8618,0),(20240,2,8619,0),(20241,10,8619,0),(20242,2,8620,0),(20243,10,8620,0),(20244,2,8621,0),(20245,10,8621,0),(20246,2,8622,0),(20247,10,8622,0),(20248,2,8623,0),(20249,10,8623,0),(20250,2,8624,0),(20251,10,8624,0),(20252,2,8625,0),(20253,10,8625,0),(20254,2,8626,0),(20255,10,8626,0),(20256,2,8627,0),(20257,10,8627,0),(20258,2,8628,0),(20259,10,8628,0),(20260,2,8629,0),(20261,10,8629,0),(20262,2,8630,0),(20263,10,8630,0),(20264,2,8631,0),(20265,10,8631,0),(20266,2,8632,0),(20267,10,8632,0),(20268,2,8633,0),(20269,10,8633,0),(20270,2,8634,0),(20271,10,8634,0),(20272,2,8635,0),(20273,10,8635,0),(20274,2,8636,0),(20275,10,8636,0),(20276,2,8637,0),(20277,10,8637,0),(20278,2,8638,0),(20279,10,8638,0),(20280,2,8639,0),(20281,10,8639,0),(20282,2,8640,0),(20283,10,8640,0),(20284,2,8641,0),(20285,10,8641,0),(20286,2,8642,0),(20287,10,8642,0),(20288,2,8643,0),(20289,10,8643,0),(20290,2,8644,0),(20291,10,8644,0),(20292,2,8645,0),(20293,10,8645,0),(20294,2,8646,0),(20295,10,8646,0),(20296,2,8647,0),(20297,10,8647,0),(20298,2,8648,0),(20299,10,8648,0),(20300,2,8649,0),(20301,10,8649,0),(20302,2,8650,0),(20303,10,8650,0),(20304,2,8651,0),(20305,10,8651,0),(20306,2,8652,0),(20307,10,8652,0),(20308,2,8653,0),(20309,10,8653,0),(20310,2,8654,0),(20311,10,8654,0),(20312,2,8655,0),(20313,10,8655,0),(20314,2,8656,0),(20315,10,8656,0),(20316,2,8657,0),(20317,10,8657,0),(20318,2,8658,0),(20319,10,8658,0),(20320,2,8659,0),(20321,10,8659,0),(20322,2,8660,0),(20323,10,8660,0),(20324,2,8661,0),(20325,10,8661,0),(20326,2,8662,0),(20327,10,8662,0),(20328,2,8663,0),(20329,10,8663,0),(20330,2,8664,0),(20331,10,8664,0),(20332,2,8665,0),(20333,10,8665,0),(20334,2,8666,0),(20335,10,8666,0),(20336,2,8667,0),(20337,10,8667,0),(20338,2,8668,0),(20339,10,8668,0),(20340,2,8669,0),(20341,10,8669,0),(20342,2,8670,0),(20343,10,8670,0),(20344,2,8671,0),(20345,10,8671,0),(20346,2,8672,0),(20347,10,8672,0),(20348,2,8673,0),(20349,10,8673,0),(20350,2,8674,0),(20351,10,8674,0),(20352,2,8675,0),(20353,10,8675,0),(20354,2,8676,0),(20355,10,8676,0),(20356,2,8677,0),(20357,10,8677,0),(20358,2,8678,0),(20359,10,8678,0),(20360,2,8679,0),(20361,10,8679,0),(20362,2,8680,0),(20363,10,8680,0),(20364,2,8681,0),(20365,10,8681,0),(20366,2,8682,0),(20367,10,8682,0),(20368,2,8683,0),(20369,10,8683,0),(20370,2,8684,0),(20371,10,8684,0),(20372,2,8685,0),(20373,10,8685,0),(20374,2,8686,0),(20375,10,8686,0),(20376,2,8687,0),(20377,10,8687,0),(20378,2,8688,0),(20379,10,8688,0),(20380,2,8689,0),(20381,10,8689,0),(20382,2,8690,0),(20383,10,8690,0),(20384,2,8691,0),(20385,10,8691,0),(20386,2,8692,0),(20387,10,8692,0),(20388,2,8693,0),(20389,10,8693,0),(20390,2,8694,0),(20391,10,8694,0),(20392,2,8695,0),(20393,10,8695,0),(20394,2,8696,0),(20395,10,8696,0),(20396,2,8697,0),(20397,10,8697,0),(20398,2,8698,0),(20399,10,8698,0),(20400,2,8699,0),(20401,10,8699,0),(20402,2,8700,0),(20403,10,8700,0),(20404,2,8701,0),(20405,10,8701,0),(20406,2,8702,0),(20407,10,8702,0),(20408,2,8703,0),(20409,10,8703,0),(20410,2,8704,0),(20411,10,8704,0),(20412,2,8705,0),(20413,10,8705,0),(20414,2,8706,0),(20415,10,8706,0),(20416,2,8707,0),(20417,10,8707,0),(20418,2,8708,0),(20419,10,8708,0),(20420,2,8709,0),(20421,10,8709,0),(20422,2,8710,0),(20423,10,8710,0),(20424,2,8711,0),(20425,10,8711,0),(20426,2,8712,0),(20427,10,8712,0),(20428,2,8713,0),(20429,10,8713,0),(20430,2,8714,0),(20431,10,8714,0),(20432,2,8715,0),(20433,10,8715,0),(20434,2,8716,0),(20435,10,8716,0),(20436,2,8717,0),(20437,10,8717,0),(20438,2,8718,0),(20439,10,8718,0),(20440,2,8719,0),(20441,10,8719,0),(20442,2,8720,0),(20443,10,8720,0),(20444,2,8721,0),(20445,10,8721,0),(20446,2,8722,0),(20447,10,8722,0),(20448,2,8723,0),(20449,10,8723,0),(20450,2,8724,0),(20451,10,8724,0),(20452,2,8725,0),(20453,10,8725,0),(20454,2,8726,0),(20455,10,8726,0),(20456,2,8727,0),(20457,10,8727,0),(20458,2,8728,0),(20459,10,8728,0),(20460,2,8729,0),(20461,10,8729,0),(20462,2,8730,0),(20463,10,8730,0),(20464,2,8731,0),(20465,10,8731,0),(20466,2,8732,0),(20467,10,8732,0),(20468,2,8733,0),(20469,10,8733,0),(20470,2,8734,0),(20471,10,8734,0),(20472,2,8735,0),(20473,10,8735,0),(20474,2,8736,0),(20475,10,8736,0),(20476,2,8737,0),(20477,10,8737,0),(20478,2,8738,0),(20479,10,8738,0),(20480,2,8739,0),(20481,10,8739,0),(20482,2,8740,0),(20483,10,8740,0),(20484,2,8741,0),(20485,10,8741,0),(20486,2,8742,0),(20487,10,8742,0),(20488,2,8743,0),(20489,10,8743,0),(20490,2,8744,0),(20491,10,8744,0),(20492,2,8745,0),(20493,10,8745,0),(20494,2,8746,0),(20495,10,8746,0),(20496,2,8747,0),(20497,10,8747,0),(20498,2,8748,0),(20499,10,8748,0),(20500,2,8749,0),(20501,10,8749,0),(20502,2,8750,0),(20503,10,8750,0),(20504,2,8751,0),(20505,10,8751,0),(20506,2,8752,0),(20507,10,8752,0),(20508,2,8753,0),(20509,10,8753,0),(20510,2,8754,0),(20511,10,8754,0),(20512,2,8755,0),(20513,10,8755,0),(20514,2,8756,0),(20515,10,8756,0),(20516,2,8757,0),(20517,10,8757,0),(20518,2,8758,0),(20519,10,8758,0),(20520,2,8759,0),(20521,10,8759,0),(20522,2,8760,0),(20523,10,8760,0),(20524,2,8761,0),(20525,10,8761,0),(20526,2,8762,0),(20527,10,8762,0),(20528,2,8763,0),(20529,10,8763,0),(20530,2,8764,0),(20531,10,8764,0),(20532,2,8765,0),(20533,10,8765,0),(20534,2,8766,0),(20535,10,8766,0),(20536,2,8767,0),(20537,10,8767,0),(20538,2,8768,0),(20539,10,8768,0),(20540,2,8769,0),(20541,10,8769,0),(20542,2,8770,0),(20543,10,8770,0),(20544,2,8771,0),(20545,10,8771,0),(20546,2,8772,0),(20547,10,8772,0),(20548,2,8773,0),(20549,10,8773,0),(20550,2,8774,0),(20551,10,8774,0),(20552,2,8775,0),(20553,10,8775,0),(20554,2,8776,0),(20555,10,8776,0),(20556,2,8777,0),(20557,10,8777,0),(20558,2,8778,0),(20559,10,8778,0),(20560,2,8779,0),(20561,10,8779,0),(20562,2,8780,0),(20563,10,8780,0),(20564,2,8781,0),(20565,10,8781,0),(20566,2,8782,0),(20567,10,8782,0),(20568,2,8783,0),(20569,10,8783,0),(20570,2,8784,0),(20571,10,8784,0),(20572,2,8785,0),(20573,10,8785,0),(20574,2,8786,0),(20575,10,8786,0),(20576,2,8787,0),(20577,10,8787,0),(20578,2,8788,0),(20579,10,8788,0),(20580,2,8789,0),(20581,10,8789,0),(20582,2,8790,0),(20583,10,8790,0),(20584,2,8791,0),(20585,10,8791,0),(20586,2,8792,0),(20587,10,8792,0),(20588,2,8793,0),(20589,10,8793,0),(20590,2,8794,0),(20591,10,8794,0),(20592,2,8795,0),(20593,10,8795,0),(20594,2,8796,0),(20595,10,8796,0),(20596,2,8797,0),(20597,10,8797,0),(20598,2,8798,0),(20599,10,8798,0),(20600,2,8799,0),(20601,10,8799,0),(20602,2,8800,0),(20603,10,8800,0),(20604,2,8801,0),(20605,10,8801,0),(20606,2,8802,0),(20607,10,8802,0),(20608,2,8803,0),(20609,10,8803,0),(20610,2,8804,0),(20611,10,8804,0),(20612,2,8805,0),(20613,10,8805,0),(20614,2,8806,0),(20615,10,8806,0),(20616,2,8807,0),(20617,10,8807,0),(20618,2,8808,0),(20619,10,8808,0),(20620,2,8809,0),(20621,10,8809,0),(20622,2,8810,0),(20623,10,8810,0),(20624,2,8811,0),(20625,10,8811,0),(20626,2,8812,0),(20627,10,8812,0),(20628,2,8813,0),(20629,10,8813,0),(20630,2,8814,0),(20631,10,8814,0),(20632,2,8815,0),(20633,10,8815,0),(20634,2,8816,0),(20635,10,8816,0),(20636,2,8817,0),(20637,10,8817,0),(20638,2,8818,0),(20639,10,8818,0),(20640,2,8819,0),(20641,10,8819,0),(20642,2,8820,0),(20643,10,8820,0),(20644,2,8821,0),(20645,10,8821,0),(20646,2,8822,0),(20647,10,8822,0),(20648,2,8823,0),(20649,10,8823,0),(20650,2,8824,0),(20651,10,8824,0),(20652,2,8825,0),(20653,10,8825,0),(20654,2,8826,0),(20655,10,8826,0),(20656,2,8827,0),(20657,10,8827,0),(20658,2,8828,0),(20659,10,8828,0),(20660,2,8829,0),(20661,10,8829,0),(20662,2,8830,0),(20663,10,8830,0),(20664,2,8831,0),(20665,10,8831,0),(20666,2,8832,0),(20667,10,8832,0),(20668,2,8833,0),(20669,10,8833,0),(20670,2,8834,0),(20671,10,8834,0),(20672,2,8835,0),(20673,10,8835,0),(20674,2,8836,0),(20675,10,8836,0),(20676,2,8837,0),(20677,10,8837,0),(20678,2,8838,0),(20679,10,8838,0),(20680,2,8839,0),(20681,10,8839,0),(20682,2,8840,0),(20683,10,8840,0),(20684,2,8841,0),(20685,10,8841,0),(20686,2,8842,0),(20687,10,8842,0),(20688,2,8843,0),(20689,10,8843,0),(20690,2,8844,0),(20691,10,8844,0),(20692,2,8845,0),(20693,10,8845,0),(20694,2,8846,0),(20695,10,8846,0),(20696,2,8847,0),(20697,10,8847,0),(20698,2,8848,0),(20699,10,8848,0),(20700,2,8849,0),(20701,10,8849,0),(20702,2,8850,0),(20703,10,8850,0),(20704,2,8851,0),(20705,10,8851,0),(20706,2,8852,0),(20707,10,8852,0),(20708,2,8853,0),(20709,10,8853,0),(20710,2,8854,0),(20711,10,8854,0),(20712,2,8855,0),(20713,10,8855,0),(20714,2,8856,0),(20715,10,8856,0),(20716,2,8857,0),(20717,10,8857,0),(20718,2,8858,0),(20719,10,8858,0),(20720,2,8859,0),(20721,10,8859,0),(20722,2,8860,0),(20723,10,8860,0),(20724,2,8861,0),(20725,10,8861,0),(20726,2,8862,0),(20727,10,8862,0),(20728,2,8863,0),(20729,10,8863,0),(20730,2,8864,0),(20731,10,8864,0),(20732,2,8865,0),(20733,10,8865,0),(20734,2,8866,0),(20735,10,8866,0),(20736,2,8867,0),(20737,10,8867,0),(20738,2,8868,0),(20739,10,8868,0),(20740,2,8869,0),(20741,10,8869,0),(20742,2,8870,0),(20743,10,8870,0),(20744,2,8871,0),(20745,10,8871,0),(20746,2,8872,0),(20747,10,8872,0),(20748,2,8873,0),(20749,10,8873,0),(20750,2,8874,0),(20751,10,8874,0),(20752,2,8875,0),(20753,10,8875,0),(20754,2,8876,0),(20755,10,8876,0),(20756,2,8877,0),(20757,10,8877,0),(20758,2,8878,0),(20759,10,8878,0),(20760,2,8879,0),(20761,10,8879,0),(20762,2,8880,0),(20763,10,8880,0),(20764,2,8881,0),(20765,10,8881,0),(20766,2,8882,0),(20767,10,8882,0),(20768,2,8883,0),(20769,10,8883,0),(20770,2,8884,0),(20771,10,8884,0),(20772,2,8885,0),(20773,10,8885,0),(20774,2,8886,0),(20775,10,8886,0),(20776,2,8887,0),(20777,10,8887,0),(20778,2,8888,0),(20779,10,8888,0),(20780,2,8889,0),(20781,10,8889,0),(20782,2,8890,0),(20783,10,8890,0),(20784,2,8891,0),(20785,10,8891,0),(20786,2,8892,0),(20787,10,8892,0),(20788,2,8893,0),(20789,10,8893,0),(20790,2,8894,0),(20791,10,8894,0),(20792,2,8895,0),(20793,10,8895,0),(20794,2,8896,0),(20795,10,8896,0),(20796,2,8897,0),(20797,10,8897,0),(20798,2,8898,0),(20799,10,8898,0),(20800,2,8899,0),(20801,10,8899,0),(20802,2,8900,0),(20803,10,8900,0),(20804,2,8901,0),(20805,10,8901,0),(20806,2,8902,0),(20807,10,8902,0),(20808,2,8903,0),(20809,10,8903,0),(20810,2,8904,0),(20811,10,8904,0),(20812,2,8905,0),(20813,10,8905,0),(20814,2,8906,0),(20815,10,8906,0),(20816,2,8907,0),(20817,10,8907,0),(20818,2,8908,0),(20819,10,8908,0),(20820,2,8909,0),(20821,10,8909,0),(20822,2,8910,0),(20823,10,8910,0),(20824,2,8911,0),(20825,10,8911,0),(20826,2,8912,0),(20827,10,8912,0),(20828,2,8913,0),(20829,10,8913,0),(20830,2,8914,0),(20831,10,8914,0),(20832,2,8915,0),(20833,10,8915,0),(20834,2,8916,0),(20835,10,8916,0),(20836,2,8917,0),(20837,10,8917,0),(20838,2,8918,0),(20839,10,8918,0),(20840,2,8919,0),(20841,10,8919,0),(20842,2,8920,0),(20843,10,8920,0),(20844,2,8921,0),(20845,10,8921,0),(20846,2,8922,0),(20847,10,8922,0),(20848,2,8923,0),(20849,10,8923,0),(20850,2,8924,0),(20851,10,8924,0),(20852,2,8925,0),(20853,10,8925,0),(20854,2,8926,0),(20855,10,8926,0),(20856,2,8927,0),(20857,10,8927,0),(20858,2,8928,0),(20859,10,8928,0),(20860,2,8929,0),(20861,10,8929,0),(20862,2,8930,0),(20863,10,8930,0),(20864,2,8931,0),(20865,10,8931,0),(20866,2,8932,0),(20867,10,8932,0),(20868,2,8933,0),(20869,10,8933,0),(20870,2,8934,0),(20871,10,8934,0),(20872,2,8935,0),(20873,10,8935,0),(20874,2,8936,0),(20875,10,8936,0),(20876,2,8937,0),(20877,10,8937,0),(20878,2,8938,0),(20879,10,8938,0),(20880,2,8939,0),(20881,10,8939,0),(20882,2,8940,0),(20883,10,8940,0),(20884,2,8941,0),(20885,10,8941,0),(20886,2,8942,0),(20887,10,8942,0),(20888,2,8943,0),(20889,10,8943,0),(20890,2,8944,0),(20891,10,8944,0),(20892,2,8945,0),(20893,10,8945,0),(20894,2,8946,0),(20895,10,8946,0),(20896,2,8947,0),(20897,10,8947,0),(20898,2,8948,0),(20899,10,8948,0),(20900,2,8949,0),(20901,10,8949,0),(20902,2,8950,0),(20903,10,8950,0),(20904,2,8951,0),(20905,10,8951,0),(20906,2,8952,0),(20907,10,8952,0),(20908,2,8953,0),(20909,10,8953,0),(20910,2,8954,0),(20911,10,8954,0),(20912,2,8955,0),(20913,10,8955,0),(20914,2,8956,0),(20915,10,8956,0),(20916,2,8957,0),(20917,10,8957,0),(20918,2,8958,0),(20919,10,8958,0),(20920,2,8959,0),(20921,10,8959,0),(20922,2,8960,0),(20923,10,8960,0),(20924,2,8961,0),(20925,10,8961,0),(20926,2,8962,0),(20927,10,8962,0),(20928,2,8963,0),(20929,10,8963,0),(20930,2,8964,0),(20931,10,8964,0),(20932,2,8965,0),(20933,10,8965,0),(20934,2,8966,0),(20935,10,8966,0),(20936,2,8967,0),(20937,10,8967,0),(20938,2,8968,0),(20939,10,8968,0),(20940,2,8969,0),(20941,10,8969,0),(20942,2,8970,0),(20943,10,8970,0),(20944,2,8971,0),(20945,10,8971,0),(20946,2,8972,0),(20947,10,8972,0),(20948,2,8973,0),(20949,10,8973,0),(20950,2,8974,0),(20951,10,8974,0),(20952,2,8975,0),(20953,10,8975,0),(20954,2,8976,0),(20955,10,8976,0),(20956,2,8977,0),(20957,10,8977,0),(20958,2,8978,0),(20959,10,8978,0),(20960,2,8979,0),(20961,10,8979,0),(20962,2,8980,0),(20963,10,8980,0),(20964,2,8981,0),(20965,10,8981,0),(20966,2,8982,0),(20967,10,8982,0),(20968,2,8983,0),(20969,10,8983,0),(20970,2,8984,0),(20971,10,8984,0),(20972,2,8985,0),(20973,10,8985,0),(20974,2,8986,0),(20975,10,8986,0),(20976,2,8987,0),(20977,10,8987,0),(20978,2,8988,0),(20979,10,8988,0),(20980,2,8989,0),(20981,10,8989,0),(20982,2,8990,0),(20983,10,8990,0),(20984,2,8991,0),(20985,10,8991,0),(20986,2,8992,0),(20987,10,8992,0),(20988,2,8993,0),(20989,10,8993,0),(20990,2,8994,0),(20991,10,8994,0),(20992,2,8995,0),(20993,10,8995,0),(20994,2,8996,0),(20995,10,8996,0),(20996,2,8997,0),(20997,10,8997,0),(20998,2,8998,0),(20999,10,8998,0),(21000,2,8999,0),(21001,10,8999,0),(21002,2,9000,0),(21003,10,9000,0),(21004,2,9001,0),(21005,10,9001,0),(21006,2,9002,0),(21007,10,9002,0),(21008,2,9003,0),(21009,10,9003,0),(21010,2,9004,0),(21011,10,9004,0),(21012,2,9005,0),(21013,10,9005,0),(21014,2,9006,0),(21015,10,9006,0),(21016,2,9007,0),(21017,10,9007,0),(21018,2,9008,0),(21019,10,9008,0),(21020,2,9009,0),(21021,10,9009,0),(21022,2,9010,0),(21023,10,9010,0),(21024,2,9011,0),(21025,10,9011,0),(21026,2,9012,0),(21027,10,9012,0),(21028,2,9013,0),(21029,10,9013,0),(21030,2,9014,0),(21031,10,9014,0),(21032,2,9015,0),(21033,10,9015,0),(21034,2,9016,0),(21035,10,9016,0),(21036,2,9017,0),(21037,10,9017,0),(21038,2,9018,0),(21039,10,9018,0),(21040,2,9019,0),(21041,10,9019,0),(21042,2,9020,0),(21043,10,9020,0),(21044,2,9021,0),(21045,10,9021,0),(21046,2,9022,0),(21047,10,9022,0),(21048,2,9023,0),(21049,10,9023,0),(21050,2,9024,0),(21051,10,9024,0),(21052,2,9025,0),(21053,10,9025,0),(21054,2,9026,0),(21055,10,9026,0),(21056,2,9027,0),(21057,10,9027,0),(21058,2,9028,0),(21059,10,9028,0),(21060,2,9029,0),(21061,10,9029,0),(21062,2,9030,0),(21063,10,9030,0),(21064,2,9031,0),(21065,10,9031,0),(21066,2,9032,0),(21067,10,9032,0),(21068,2,9033,0),(21069,10,9033,0),(21070,2,9034,0),(21071,10,9034,0),(21072,2,9035,0),(21073,10,9035,0),(21074,2,9036,0),(21075,10,9036,0),(21076,2,9037,0),(21077,10,9037,0),(21078,2,9038,0),(21079,10,9038,0),(21080,2,9039,0),(21081,10,9039,0),(21082,2,9040,0),(21083,10,9040,0),(21084,2,9041,0),(21085,10,9041,0),(21086,2,9042,0),(21087,10,9042,0),(21088,2,9043,0),(21089,10,9043,0),(21090,2,9044,0),(21091,10,9044,0),(21092,2,9045,0),(21093,10,9045,0),(21094,2,9046,0),(21095,10,9046,0),(21096,2,9047,0),(21097,10,9047,0),(21098,2,9048,0),(21099,10,9048,0),(21100,2,9049,0),(21101,10,9049,0),(21102,2,9050,0),(21103,10,9050,0),(21104,2,9051,0),(21105,10,9051,0),(21106,2,9052,0),(21107,10,9052,0),(21108,2,9053,0),(21109,10,9053,0),(21110,2,9054,0),(21111,10,9054,0),(21112,2,9055,0),(21113,10,9055,0),(21114,2,9056,0),(21115,10,9056,0),(21116,2,9057,0),(21117,10,9057,0),(21118,2,9058,0),(21119,10,9058,0),(21120,2,9059,0),(21121,10,9059,0),(21122,2,9060,0),(21123,10,9060,0),(21124,2,9061,0),(21125,10,9061,0),(21126,2,9062,0),(21127,10,9062,0),(21128,2,9063,0),(21129,10,9063,0),(21130,2,9064,0),(21131,10,9064,0),(21132,2,9065,0),(21133,10,9065,0),(21134,2,9066,0),(21135,10,9066,0),(21136,2,9067,0),(21137,10,9067,0),(21138,2,9068,0),(21139,10,9068,0),(21140,2,9069,0),(21141,10,9069,0),(21142,2,9070,0),(21143,10,9070,0),(21144,2,9071,0),(21145,10,9071,0),(21146,2,9072,0),(21147,10,9072,0),(21148,2,9073,0),(21149,10,9073,0),(21150,2,9074,0),(21151,10,9074,0),(21152,2,9075,0),(21153,10,9075,0),(21154,2,9076,0),(21155,10,9076,0),(21156,2,9077,0),(21157,10,9077,0),(21158,2,9078,0),(21159,10,9078,0),(21160,2,9079,0),(21161,10,9079,0),(21162,2,9080,0),(21163,10,9080,0),(21164,2,9081,0),(21165,10,9081,0),(21166,2,9082,0),(21167,10,9082,0),(21168,2,9083,0),(21169,10,9083,0),(21170,2,9084,0),(21171,10,9084,0),(21172,2,9085,0),(21173,10,9085,0),(21174,2,9086,0),(21175,10,9086,0),(21176,2,9087,0),(21177,10,9087,0),(21178,2,9088,0),(21179,10,9088,0),(21180,2,9089,0),(21181,10,9089,0),(21182,2,9090,0),(21183,10,9090,0),(21184,2,9091,0),(21185,10,9091,0),(21186,2,9092,0),(21187,10,9092,0),(21188,2,9093,0),(21189,10,9093,0),(21190,2,9094,0),(21191,10,9094,0),(21192,2,9095,0),(21193,10,9095,0),(21194,2,9096,0),(21195,10,9096,0),(21196,2,9097,0),(21197,10,9097,0),(21198,2,9098,0),(21199,10,9098,0),(21200,2,9099,0),(21201,10,9099,0),(21202,2,9100,0),(21203,10,9100,0),(21204,2,9101,0),(21205,10,9101,0),(21206,2,9102,0),(21207,10,9102,0),(21208,2,9103,0),(21209,10,9103,0),(21210,2,9104,0),(21211,10,9104,0),(21212,2,9105,0),(21213,10,9105,0),(21214,2,9106,0),(21215,10,9106,0),(21216,2,9107,0),(21217,10,9107,0),(21218,2,9108,0),(21219,10,9108,0),(21220,2,9109,0),(21221,10,9109,0),(21222,2,9110,0),(21223,10,9110,0),(21224,2,9111,0),(21225,10,9111,0),(21226,2,9112,0),(21227,10,9112,0),(21228,2,9113,0),(21229,10,9113,0),(21230,2,9114,0),(21231,10,9114,0),(21232,2,9115,0),(21233,10,9115,0),(21234,2,9116,0),(21235,10,9116,0),(21236,2,9117,0),(21237,10,9117,0),(21238,2,9118,0),(21239,10,9118,0),(21240,2,9119,0),(21241,10,9119,0),(21242,2,9120,0),(21243,10,9120,0),(21244,2,9121,0),(21245,10,9121,0),(21246,2,9122,0),(21247,10,9122,0),(21248,2,9123,0),(21249,10,9123,0),(21250,2,9124,0),(21251,10,9124,0),(21252,2,9125,0),(21253,10,9125,0),(21254,2,9126,0),(21255,10,9126,0),(21256,2,9127,0),(21257,10,9127,0),(21258,2,9128,0),(21259,10,9128,0),(21260,2,9129,0),(21261,10,9129,0),(21262,2,9130,0),(21263,10,9130,0),(21264,2,9131,0),(21265,10,9131,0),(21266,2,9132,0),(21267,10,9132,0),(21268,2,9133,0),(21269,10,9133,0),(21270,2,9134,0),(21271,10,9134,0),(21272,2,9135,0),(21273,10,9135,0),(21274,2,9136,0),(21275,10,9136,0),(21276,2,9137,0),(21277,10,9137,0),(21278,2,9138,0),(21279,10,9138,0),(21280,2,9139,0),(21281,10,9139,0),(21282,2,9140,0),(21283,10,9140,0),(21284,2,9141,0),(21285,10,9141,0),(21286,2,9142,0),(21287,10,9142,0),(21288,2,9143,0),(21289,10,9143,0),(21290,2,9144,0),(21291,10,9144,0),(21292,2,9145,0),(21293,10,9145,0),(21294,2,9146,0),(21295,10,9146,0),(21296,2,9147,0),(21297,10,9147,0),(21298,2,9148,0),(21299,10,9148,0),(21300,2,9149,0),(21301,10,9149,0),(21302,2,9150,0),(21303,10,9150,0),(21304,2,9151,0),(21305,10,9151,0),(21306,2,9152,0),(21307,10,9152,0),(21308,2,9153,0),(21309,10,9153,0),(21310,2,9154,0),(21311,10,9154,0),(21312,2,9155,0),(21313,10,9155,0),(21314,2,9156,0),(21315,10,9156,0),(21316,2,9157,0),(21317,10,9157,0),(21318,2,9158,0),(21319,10,9158,0),(21320,2,9159,0),(21321,10,9159,0),(21322,2,9160,0),(21323,10,9160,0),(21324,2,9161,0),(21325,10,9161,0),(21326,2,9162,0),(21327,10,9162,0),(21328,2,9163,0),(21329,10,9163,0),(21330,2,9164,0),(21331,10,9164,0),(21332,2,9165,0),(21333,10,9165,0),(21334,2,9166,0),(21335,10,9166,0),(21336,2,9167,0),(21337,10,9167,0),(21338,2,9168,0),(21339,10,9168,0),(21340,2,9169,0),(21341,10,9169,0),(21342,2,9170,0),(21343,10,9170,0),(21344,2,9171,0),(21345,10,9171,0),(21346,2,9172,0),(21347,10,9172,0),(21348,2,9173,0),(21349,10,9173,0),(21350,2,9174,0),(21351,10,9174,0),(21352,2,9175,0),(21353,10,9175,0),(21354,2,9176,0),(21355,10,9176,0),(21356,2,9177,0),(21357,10,9177,0),(21358,2,9178,0),(21359,10,9178,0),(21360,2,9179,0),(21361,10,9179,0),(21362,2,9180,0),(21363,10,9180,0),(21364,2,9181,0),(21365,10,9181,0),(21366,2,9182,0),(21367,10,9182,0),(21368,2,9183,0),(21369,10,9183,0),(21370,2,9184,0),(21371,10,9184,0),(21372,2,9185,0),(21373,10,9185,0),(21374,2,9186,0),(21375,10,9186,0),(21376,2,9187,0),(21377,10,9187,0),(21378,2,9188,0),(21379,10,9188,0),(21380,2,9189,0),(21381,10,9189,0),(21382,2,9190,0),(21383,10,9190,0),(21384,2,9191,0),(21385,10,9191,0),(21386,2,9192,0),(21387,10,9192,0),(21388,2,9193,0),(21389,10,9193,0),(21390,2,9194,0),(21391,10,9194,0),(21392,2,9195,0),(21393,10,9195,0),(21394,2,9196,0),(21395,10,9196,0),(21396,2,9197,0),(21397,10,9197,0),(21398,2,9198,0),(21399,10,9198,0),(21400,2,9199,0),(21401,10,9199,0),(21402,2,9200,0),(21403,10,9200,0),(21404,2,9201,0),(21405,10,9201,0),(21406,2,9202,0),(21407,10,9202,0),(21408,2,9203,0),(21409,10,9203,0),(21410,2,9204,0),(21411,10,9204,0),(21412,2,9205,0),(21413,10,9205,0),(21414,2,9206,0),(21415,10,9206,0),(21416,2,9207,0),(21417,10,9207,0),(21418,2,9208,0),(21419,10,9208,0),(21420,2,9209,0),(21421,10,9209,0),(21422,2,9210,0),(21423,10,9210,0),(21424,2,9211,0),(21425,10,9211,0),(21426,2,9212,0),(21427,10,9212,0),(21428,2,9213,0),(21429,10,9213,0),(21430,2,9214,0),(21431,10,9214,0),(21432,2,9215,0),(21433,10,9215,0),(21434,2,9216,0),(21435,10,9216,0),(21436,2,9217,0),(21437,10,9217,0),(21438,2,9218,0),(21439,10,9218,0),(21440,2,9219,0),(21441,10,9219,0),(21442,2,9220,0),(21443,10,9220,0),(21444,2,9221,0),(21445,10,9221,0),(21446,2,9222,0),(21447,10,9222,0),(21448,2,9223,0),(21449,10,9223,0),(21450,2,9224,0),(21451,10,9224,0),(21452,2,9225,0),(21453,10,9225,0),(21454,2,9226,0),(21455,10,9226,0),(21456,2,9227,0),(21457,10,9227,0),(21458,2,9228,0),(21459,10,9228,0),(21460,2,9229,0),(21461,10,9229,0),(21462,2,9230,0),(21463,10,9230,0),(21464,2,9231,0),(21465,10,9231,0),(21466,2,9232,0),(21467,10,9232,0),(21468,2,9233,0),(21469,10,9233,0),(21470,2,9234,0),(21471,10,9234,0),(21472,2,9235,0),(21473,10,9235,0),(21474,2,9236,0),(21475,10,9236,0),(21476,2,9237,0),(21477,10,9237,0),(21478,2,9238,0),(21479,10,9238,0),(21480,2,9239,0),(21481,10,9239,0),(21482,2,9240,0),(21483,10,9240,0),(21484,2,9241,0),(21485,10,9241,0),(21486,2,9242,0),(21487,10,9242,0),(21488,2,9243,0),(21489,10,9243,0),(21490,2,9244,0),(21491,10,9244,0),(21492,2,9245,0),(21493,10,9245,0),(21494,2,9246,0),(21495,10,9246,0),(21496,2,9247,0),(21497,10,9247,0),(21498,2,9248,0),(21499,10,9248,0),(21500,2,9249,0),(21501,10,9249,0),(21502,2,9250,0),(21503,10,9250,0),(21504,2,9251,0),(21505,10,9251,0),(21506,2,9252,0),(21507,10,9252,0),(21508,2,9253,0),(21509,10,9253,0),(21510,2,9254,0),(21511,10,9254,0),(21512,2,9255,0),(21513,10,9255,0),(21514,2,9256,0),(21515,10,9256,0),(21516,2,9257,0),(21517,10,9257,0),(21518,2,9258,0),(21519,10,9258,0),(21520,2,9259,0),(21521,10,9259,0),(21522,2,9260,0),(21523,10,9260,0),(21524,2,9261,0),(21525,10,9261,0),(21526,2,9262,0),(21527,10,9262,0),(21528,2,9263,0),(21529,10,9263,0),(21530,2,9264,0),(21531,10,9264,0),(21532,2,9265,0),(21533,10,9265,0),(21534,2,9266,0),(21535,10,9266,0),(21536,2,9267,0),(21537,10,9267,0),(21538,2,9268,0),(21539,10,9268,0),(21540,2,9269,0),(21541,10,9269,0),(21542,2,9270,0),(21543,10,9270,0),(21544,2,9271,0),(21545,10,9271,0),(21546,2,9272,0),(21547,10,9272,0),(21548,2,9273,0),(21549,10,9273,0),(21550,2,9274,0),(21551,10,9274,0),(21552,2,9275,0),(21553,10,9275,0),(21554,2,9276,0),(21555,10,9276,0),(21556,2,9277,0),(21557,10,9277,0),(21558,2,9278,0),(21559,10,9278,0),(21560,2,9279,0),(21561,10,9279,0),(21562,2,9280,0),(21563,10,9280,0),(21564,2,9281,0),(21565,10,9281,0),(21566,2,9282,0),(21567,10,9282,0),(21568,2,9283,0),(21569,10,9283,0),(21570,2,9284,0),(21571,10,9284,0),(21572,2,9285,0),(21573,10,9285,0),(21574,2,9286,0),(21575,10,9286,0),(21576,2,9287,0),(21577,10,9287,0),(21578,2,9288,0),(21579,10,9288,0),(21580,2,9289,0),(21581,10,9289,0),(21582,2,9290,0),(21583,10,9290,0),(21584,2,9291,0),(21585,10,9291,0),(21586,2,9292,0),(21587,10,9292,0),(21588,2,9293,0),(21589,10,9293,0),(21590,2,9294,0),(21591,10,9294,0),(21592,2,9295,0),(21593,10,9295,0),(21594,2,9296,0),(21595,10,9296,0),(21596,2,9297,0),(21597,10,9297,0),(21598,2,9298,0),(21599,10,9298,0),(21600,2,9299,0),(21601,10,9299,0),(21602,2,9300,0),(21603,10,9300,0),(21604,2,9301,0),(21605,10,9301,0),(21606,2,9302,0),(21607,10,9302,0),(21608,2,9303,0),(21609,10,9303,0),(21610,2,9304,0),(21611,10,9304,0),(21612,2,9305,0),(21613,10,9305,0),(21614,2,9306,0),(21615,10,9306,0),(21616,2,9307,0),(21617,10,9307,0),(21618,2,9308,0),(21619,10,9308,0),(21620,2,9309,0),(21621,10,9309,0),(21622,2,9310,0),(21623,10,9310,0),(21624,2,9311,0),(21625,10,9311,0),(21626,2,9312,0),(21627,10,9312,0),(21628,2,9313,0),(21629,10,9313,0),(21630,2,9314,0),(21631,10,9314,0),(21632,2,9315,0),(21633,10,9315,0),(21634,2,9316,0),(21635,10,9316,0),(21636,2,9317,0),(21637,10,9317,0),(21638,2,9318,0),(21639,10,9318,0),(21640,2,9319,0),(21641,10,9319,0),(21642,2,9320,0),(21643,10,9320,0),(21644,2,9321,0),(21645,10,9321,0),(21646,2,9322,0),(21647,10,9322,0),(21648,2,9323,0),(21649,10,9323,0),(21650,2,9324,0),(21651,10,9324,0),(21652,2,9325,0),(21653,10,9325,0),(21654,2,9326,0),(21655,10,9326,0),(21656,2,9327,0),(21657,10,9327,0),(21658,2,9328,0),(21659,10,9328,0),(21660,2,9329,0),(21661,10,9329,0),(21662,2,9330,0),(21663,10,9330,0),(21664,2,9331,0),(21665,10,9331,0),(21666,2,9332,0),(21667,10,9332,0),(21668,2,9333,0),(21669,10,9333,0),(21670,2,9334,0),(21671,10,9334,0),(21672,2,9335,0),(21673,10,9335,0),(21674,2,9336,0),(21675,10,9336,0),(21676,2,9337,0),(21677,10,9337,0),(21678,2,9338,0),(21679,10,9338,0),(21680,2,9339,0),(21681,10,9339,0),(21682,2,9340,0),(21683,10,9340,0),(21684,2,9341,0),(21685,10,9341,0),(21686,2,9342,0),(21687,10,9342,0),(21688,2,9343,0),(21689,10,9343,0),(21690,2,9344,0),(21691,10,9344,0),(21692,2,9345,0),(21693,10,9345,0),(21694,2,9346,0),(21695,10,9346,0),(21696,2,9347,0),(21697,10,9347,0),(21698,2,9348,0),(21699,10,9348,0),(21700,2,9349,0),(21701,10,9349,0),(21702,2,9350,0),(21703,10,9350,0),(21704,2,9351,0),(21705,10,9351,0),(21706,2,9352,0),(21707,10,9352,0),(21708,2,9353,0),(21709,10,9353,0),(21710,2,9354,0),(21711,10,9354,0),(21712,2,9355,0),(21713,10,9355,0),(21714,2,9356,0),(21715,10,9356,0),(21716,2,9357,0),(21717,10,9357,0),(21718,2,9358,0),(21719,10,9358,0),(21720,2,9359,0),(21721,10,9359,0),(21722,2,9360,0),(21723,10,9360,0),(21724,2,9361,0),(21725,10,9361,0),(21726,2,9362,0),(21727,10,9362,0),(21728,2,9363,0),(21729,10,9363,0),(21730,2,9364,0),(21731,10,9364,0),(21732,2,9365,0),(21733,10,9365,0),(21734,2,9366,0),(21735,10,9366,0),(21736,2,9367,0),(21737,10,9367,0),(21738,2,9368,0),(21739,10,9368,0),(21740,2,9369,0),(21741,10,9369,0),(21742,2,9370,0),(21743,10,9370,0),(21744,2,9371,0),(21745,10,9371,0),(21746,2,9372,0),(21747,10,9372,0),(21748,2,9373,0),(21749,10,9373,0),(21750,2,9374,0),(21751,10,9374,0),(21752,2,9375,0),(21753,10,9375,0),(21754,2,9376,0),(21755,10,9376,0),(21756,2,9377,0),(21757,10,9377,0),(21758,2,9378,0),(21759,10,9378,0),(21760,2,9379,0),(21761,10,9379,0),(21762,2,9380,0),(21763,10,9380,0),(21764,2,9381,0),(21765,10,9381,0),(21766,2,9382,0),(21767,10,9382,0),(21768,2,9383,0),(21769,10,9383,0),(21770,2,9384,0),(21771,10,9384,0),(21772,2,9385,0),(21773,10,9385,0),(21774,2,9386,0),(21775,10,9386,0),(21776,2,9387,0),(21777,10,9387,0),(21778,2,9388,0),(21779,10,9388,0),(21780,2,9389,0),(21781,10,9389,0),(21782,2,9390,0),(21783,10,9390,0),(21784,2,9391,0),(21785,10,9391,0),(21786,2,9392,0),(21787,10,9392,0),(21788,2,9393,0),(21789,10,9393,0),(21790,2,9394,0),(21791,10,9394,0),(21792,2,9395,0),(21793,10,9395,0),(21794,2,9396,0),(21795,10,9396,0),(21796,2,9397,0),(21797,10,9397,0),(21798,2,9398,0),(21799,10,9398,0),(21800,2,9399,0),(21801,10,9399,0),(21802,2,9400,0),(21803,10,9400,0),(21804,2,9401,0),(21805,10,9401,0),(21806,2,9402,0),(21807,10,9402,0),(21808,2,9403,0),(21809,10,9403,0),(21810,2,9404,0),(21811,10,9404,0),(21812,2,9405,0),(21813,10,9405,0),(21814,2,9406,0),(21815,10,9406,0),(21816,2,9407,0),(21817,10,9407,0),(21818,2,9408,0),(21819,10,9408,0),(21820,2,9409,0),(21821,10,9409,0),(21822,2,9410,0),(21823,10,9410,0),(21824,2,9411,0),(21825,10,9411,0),(21826,2,9412,0),(21827,10,9412,0),(21828,2,9413,0),(21829,10,9413,0),(21830,2,9414,0),(21831,10,9414,0),(21832,2,9415,0),(21833,10,9415,0),(21834,2,9416,0),(21835,10,9416,0),(21836,2,9417,0),(21837,10,9417,0),(21838,2,9418,0),(21839,10,9418,0),(21840,2,9419,0),(21841,10,9419,0),(21842,2,9420,0),(21843,10,9420,0),(21844,2,9421,0),(21845,10,9421,0),(21846,2,9422,0),(21847,10,9422,0),(21848,2,9423,0),(21849,10,9423,0),(21850,2,9424,0),(21851,10,9424,0),(21852,2,9425,0),(21853,10,9425,0),(21854,2,9426,0),(21855,10,9426,0),(21856,2,9427,0),(21857,10,9427,0),(21858,2,9428,0),(21859,10,9428,0),(21860,2,9429,0),(21861,10,9429,0),(21862,2,9430,0),(21863,10,9430,0),(21864,2,9431,0),(21865,10,9431,0),(21866,2,9432,0),(21867,10,9432,0),(21868,2,9433,0),(21869,10,9433,0),(21870,2,9434,0),(21871,10,9434,0),(21872,2,9435,0),(21873,10,9435,0),(21874,2,9436,0),(21875,10,9436,0),(21876,2,9437,0),(21877,10,9437,0),(21878,2,9438,0),(21879,10,9438,0),(21880,2,9439,0),(21881,10,9439,0),(21882,2,9440,0),(21883,10,9440,0),(21884,2,9441,0),(21885,10,9441,0),(21886,2,9442,0),(21887,10,9442,0),(21888,2,9443,0),(21889,10,9443,0),(21890,2,9444,0),(21891,10,9444,0),(21892,2,9445,0),(21893,10,9445,0),(21894,2,9446,0),(21895,10,9446,0),(21896,2,9447,0),(21897,10,9447,0),(21898,2,9448,0),(21899,10,9448,0),(21900,2,9449,0),(21901,10,9449,0),(21902,2,9450,0),(21903,10,9450,0),(21904,2,9451,0),(21905,10,9451,0),(21906,2,9452,0),(21907,10,9452,0),(21908,2,9453,0),(21909,10,9453,0),(21910,2,9454,0),(21911,10,9454,0),(21912,2,9455,0),(21913,10,9455,0),(21914,2,9456,0),(21915,10,9456,0),(21916,2,9457,0),(21917,10,9457,0),(21918,2,9458,0),(21919,10,9458,0),(21920,2,9459,0),(21921,10,9459,0),(21922,2,9460,0),(21923,10,9460,0),(21924,2,9461,0),(21925,10,9461,0),(21926,2,9462,0),(21927,10,9462,0),(21928,2,9463,0),(21929,10,9463,0),(21930,2,9464,0),(21931,10,9464,0),(21932,2,9465,0),(21933,10,9465,0),(21934,2,9466,0),(21935,10,9466,0),(21936,2,9467,0),(21937,10,9467,0),(21938,2,9468,0),(21939,10,9468,0),(21940,2,9469,0),(21941,10,9469,0),(21942,2,9470,0),(21943,10,9470,0),(21944,2,9471,0),(21945,10,9471,0),(21946,2,9472,0),(21947,10,9472,0),(21948,2,9473,0),(21949,10,9473,0),(21950,2,9474,0),(21951,10,9474,0),(21952,2,9475,0),(21953,10,9475,0),(21954,2,9476,0),(21955,10,9476,0),(21956,2,9477,0),(21957,10,9477,0),(21958,2,9478,0),(21959,10,9478,0),(21960,2,9479,0),(21961,10,9479,0),(21962,2,9480,0),(21963,10,9480,0),(21964,2,9481,0),(21965,10,9481,0),(21966,2,9482,0),(21967,10,9482,0),(21968,2,9483,0),(21969,10,9483,0),(21970,2,9484,0),(21971,10,9484,0),(21972,2,9485,0),(21973,10,9485,0),(21974,2,9486,0),(21975,10,9486,0),(21976,2,9487,0),(21977,10,9487,0),(21978,2,9488,0),(21979,10,9488,0),(21980,2,9489,0),(21981,10,9489,0),(21982,2,9490,0),(21983,10,9490,0),(21984,2,9491,0),(21985,10,9491,0),(21986,2,9492,0),(21987,10,9492,0),(21988,2,9493,0),(21989,10,9493,0),(21990,2,9494,0),(21991,10,9494,0),(21992,2,9495,0),(21993,10,9495,0),(21994,2,9496,0),(21995,10,9496,0),(21996,2,9497,0),(21997,10,9497,0),(21998,2,9498,0),(21999,10,9498,0),(22000,2,9499,0),(22001,10,9499,0),(22002,2,9500,0),(22003,10,9500,0),(22004,2,9501,0),(22005,10,9501,0),(22006,2,9502,0),(22007,10,9502,0),(22008,2,9503,0),(22009,10,9503,0),(22010,2,9504,0),(22011,10,9504,0),(22012,2,9505,0),(22013,10,9505,0),(22014,2,9506,0),(22015,10,9506,0),(22016,2,9507,0),(22017,10,9507,0),(22018,2,9508,0),(22019,10,9508,0),(22020,2,9509,0),(22021,10,9509,0),(22022,2,9510,0),(22023,10,9510,0),(22024,2,9511,0),(22025,10,9511,0),(22026,2,9512,0),(22027,10,9512,0),(22028,2,9513,0),(22029,10,9513,0),(22030,2,9514,0),(22031,10,9514,0),(22032,2,9515,0),(22033,10,9515,0),(22034,2,9516,0),(22035,10,9516,0),(22036,2,9517,0),(22037,10,9517,0),(22038,2,9518,0),(22039,10,9518,0),(22040,2,9519,0),(22041,10,9519,0),(22042,2,9520,0),(22043,10,9520,0),(22044,2,9521,0),(22045,10,9521,0),(22046,2,9522,0),(22047,10,9522,0),(22048,2,9523,0),(22049,10,9523,0),(22050,2,9524,0),(22051,10,9524,0),(22052,2,9525,0),(22053,10,9525,0),(22054,2,9526,0),(22055,10,9526,0),(22056,2,9527,0),(22057,10,9527,0),(22058,2,9528,0),(22059,10,9528,0),(22060,2,9529,0),(22061,10,9529,0),(22062,2,9530,0),(22063,10,9530,0),(22064,2,9531,0),(22065,10,9531,0),(22066,2,9532,0),(22067,10,9532,0),(22068,2,9533,0),(22069,10,9533,0),(22070,2,9534,0),(22071,10,9534,0),(22072,2,9535,0),(22073,10,9535,0),(22074,2,9536,0),(22075,10,9536,0),(22076,2,9537,0),(22077,10,9537,0),(22078,2,9538,0),(22079,10,9538,0),(22080,2,9539,0),(22081,10,9539,0),(22082,2,9540,0),(22083,10,9540,0),(22084,2,9541,0),(22085,10,9541,0),(22086,2,9542,0),(22087,10,9542,0),(22088,2,9543,0),(22089,10,9543,0),(22090,2,9544,0),(22091,10,9544,0),(22092,2,9545,0),(22093,10,9545,0),(22094,2,9546,0),(22095,10,9546,0),(22096,2,9547,0),(22097,10,9547,0),(22098,2,9548,0),(22099,10,9548,0),(22100,2,9549,0),(22101,10,9549,0),(22102,2,9550,0),(22103,10,9550,0),(22104,2,9551,0),(22105,10,9551,0),(22106,2,9552,0),(22107,10,9552,0),(22108,2,9553,0),(22109,10,9553,0),(22110,2,9554,0),(22111,10,9554,0),(22112,2,9555,0),(22113,10,9555,0),(22114,2,9556,0),(22115,10,9556,0),(22116,2,9557,0),(22117,10,9557,0),(22118,2,9558,0),(22119,10,9558,0),(22120,2,9559,0),(22121,10,9559,0),(22122,2,9560,0),(22123,10,9560,0),(22124,2,9561,0),(22125,10,9561,0),(22126,2,9562,0),(22127,10,9562,0),(22128,2,9563,0),(22129,10,9563,0),(22130,2,9564,0),(22131,10,9564,0),(22132,2,9565,0),(22133,10,9565,0),(22134,2,9566,0),(22135,10,9566,0),(22136,2,9567,0),(22137,10,9567,0),(22138,2,9568,0),(22139,10,9568,0),(22140,2,9569,0),(22141,10,9569,0),(22142,2,9570,0),(22143,10,9570,0),(22144,2,9571,0),(22145,10,9571,0),(22146,2,9572,0),(22147,10,9572,0),(22148,2,9573,0),(22149,10,9573,0),(22150,2,9574,0),(22151,10,9574,0),(22152,2,9575,0),(22153,10,9575,0),(22154,2,9576,0),(22155,10,9576,0),(22156,2,9577,0),(22157,10,9577,0),(22158,2,9578,0),(22159,10,9578,0),(22160,2,9579,0),(22161,10,9579,0),(22162,2,9580,0),(22163,10,9580,0),(22164,2,9581,0),(22165,10,9581,0),(22166,2,9582,0),(22167,10,9582,0),(22168,2,9583,0),(22169,10,9583,0),(22170,2,9584,0),(22171,10,9584,0),(22172,2,9585,0),(22173,10,9585,0),(22174,2,9586,0),(22175,10,9586,0),(22176,2,9587,0),(22177,10,9587,0),(22178,2,9588,0),(22179,10,9588,0),(22180,2,9589,0),(22181,10,9589,0),(22182,2,9590,0),(22183,10,9590,0),(22184,2,9591,0),(22185,10,9591,0),(22186,2,9592,0),(22187,10,9592,0),(22188,2,9593,0),(22189,10,9593,0),(22190,2,9594,0),(22191,10,9594,0),(22192,2,9595,0),(22193,10,9595,0),(22194,2,9596,0),(22195,10,9596,0),(22196,2,9597,0),(22197,10,9597,0),(22198,2,9598,0),(22199,10,9598,0),(22200,2,9599,0),(22201,10,9599,0),(22202,2,9600,0),(22203,10,9600,0),(22204,2,9601,0),(22205,10,9601,0),(22206,2,9602,0),(22207,10,9602,0),(22208,2,9603,0),(22209,10,9603,0),(22210,2,9604,0),(22211,10,9604,0),(22212,2,9605,0),(22213,10,9605,0),(22214,2,9606,0),(22215,10,9606,0),(22216,2,9607,0),(22217,10,9607,0),(22218,2,9608,0),(22219,10,9608,0),(22220,2,9609,0),(22221,10,9609,0),(22222,2,9610,0),(22223,10,9610,0),(22224,2,9611,0),(22225,10,9611,0),(22226,2,9612,0),(22227,10,9612,0),(22228,2,9613,0),(22229,10,9613,0),(22230,2,9614,0),(22231,10,9614,0),(22232,2,9615,0),(22233,10,9615,0),(22234,2,9616,0),(22235,10,9616,0),(22236,2,9617,0),(22237,10,9617,0),(22238,2,9618,0),(22239,10,9618,0),(22240,2,9619,0),(22241,10,9619,0),(22242,2,9620,0),(22243,10,9620,0),(22244,2,9621,0),(22245,10,9621,0),(22246,2,9622,0),(22247,10,9622,0),(22248,2,9623,0),(22249,10,9623,0),(22250,2,9624,0),(22251,10,9624,0),(22252,2,9625,0),(22253,10,9625,0),(22254,2,9626,0),(22255,10,9626,0),(22256,2,9627,0),(22257,10,9627,0),(22258,2,9628,0),(22259,10,9628,0),(22260,2,9629,0),(22261,10,9629,0),(22262,2,9630,0),(22263,10,9630,0),(22264,2,9631,0),(22265,10,9631,0),(22266,2,9632,0),(22267,10,9632,0),(22268,2,9633,0),(22269,10,9633,0),(22270,2,9634,0),(22271,10,9634,0),(22272,2,9635,0),(22273,10,9635,0),(22274,2,9636,0),(22275,10,9636,0),(22276,2,9637,0),(22277,10,9637,0),(22278,2,9638,0),(22279,10,9638,0),(22280,2,9639,0),(22281,10,9639,0),(22282,2,9640,0),(22283,10,9640,0),(22284,2,9641,0),(22285,10,9641,0),(22286,2,9642,0),(22287,10,9642,0),(22288,2,9643,0),(22289,10,9643,0),(22290,2,9644,0),(22291,10,9644,0),(22292,2,9645,0),(22293,10,9645,0),(22294,2,9646,0),(22295,10,9646,0),(22296,2,9647,0),(22297,10,9647,0),(22298,2,9648,0),(22299,10,9648,0),(22300,2,9649,0),(22301,10,9649,0),(22302,2,9650,0),(22303,10,9650,0),(22304,2,9651,0),(22305,10,9651,0),(22306,2,9652,0),(22307,10,9652,0),(22308,2,9653,0),(22309,10,9653,0),(22310,2,9654,0),(22311,10,9654,0),(22312,2,9655,0),(22313,10,9655,0),(22314,2,9656,0),(22315,10,9656,0),(22316,2,9657,0),(22317,10,9657,0),(22318,2,9658,0),(22319,10,9658,0),(22320,2,9659,0),(22321,10,9659,0),(22322,2,9660,0),(22323,10,9660,0),(22324,2,9661,0),(22325,10,9661,0),(22326,2,9662,0),(22327,10,9662,0),(22328,2,9663,0),(22329,10,9663,0),(22330,2,9664,0),(22331,10,9664,0),(22332,2,9665,0),(22333,10,9665,0),(22334,2,9666,0),(22335,10,9666,0),(22336,2,9667,0),(22337,10,9667,0),(22338,2,9668,0),(22339,10,9668,0),(22340,2,9669,0),(22341,10,9669,0),(22342,2,9670,0),(22343,10,9670,0),(22344,2,9671,0),(22345,10,9671,0),(22346,2,9672,0),(22347,10,9672,0),(22348,2,9673,0),(22349,10,9673,0),(22350,2,9674,0),(22351,10,9674,0),(22352,2,9675,0),(22353,10,9675,0),(22354,2,9676,0),(22355,10,9676,0),(22356,2,9677,0),(22357,10,9677,0),(22358,2,9678,0),(22359,10,9678,0),(22360,2,9679,0),(22361,10,9679,0),(22362,2,9680,0),(22363,10,9680,0),(22364,2,9681,0),(22365,10,9681,0),(22366,2,9682,0),(22367,10,9682,0),(22368,2,9683,0),(22369,10,9683,0),(22370,2,9684,0),(22371,10,9684,0),(22372,2,9685,0),(22373,10,9685,0),(22374,2,9686,0),(22375,10,9686,0),(22376,2,9687,0),(22377,10,9687,0),(22378,2,9688,0),(22379,10,9688,0),(22380,2,9689,0),(22381,10,9689,0),(22382,2,9690,0),(22383,10,9690,0),(22384,2,9691,0),(22385,10,9691,0),(22386,2,9692,0),(22387,10,9692,0),(22388,2,9693,0),(22389,10,9693,0),(22390,2,9694,0),(22391,10,9694,0),(22392,2,9695,0),(22393,10,9695,0),(22394,2,9696,0),(22395,10,9696,0),(22396,2,9697,0),(22397,10,9697,0),(22398,2,9698,0),(22399,10,9698,0),(22400,2,9699,0),(22401,10,9699,0),(22402,2,9700,0),(22403,10,9700,0),(22404,2,9701,0),(22405,10,9701,0),(22406,2,9702,0),(22407,10,9702,0),(22408,2,9703,0),(22409,10,9703,0),(22410,2,9704,0),(22411,10,9704,0),(22412,2,9705,0),(22413,10,9705,0),(22414,2,9706,0),(22415,10,9706,0),(22416,2,9707,0),(22417,10,9707,0),(22418,2,9708,0),(22419,10,9708,0),(22420,2,9709,0),(22421,10,9709,0),(22422,2,9710,0),(22423,10,9710,0),(22424,2,9711,0),(22425,10,9711,0),(22426,2,9712,0),(22427,10,9712,0),(22428,2,9713,0),(22429,10,9713,0),(22430,2,9714,0),(22431,10,9714,0),(22432,2,9715,0),(22433,10,9715,0),(22434,2,9716,0),(22435,10,9716,0),(22436,2,9717,0),(22437,10,9717,0),(22438,2,9718,0),(22439,10,9718,0),(22440,2,9719,0),(22441,10,9719,0),(22442,2,9720,0),(22443,10,9720,0),(22444,2,9721,0),(22445,10,9721,0),(22446,2,9722,0),(22447,10,9722,0),(22448,2,9723,0),(22449,10,9723,0),(22450,2,9724,0),(22451,10,9724,0),(22452,2,9725,0),(22453,10,9725,0),(22454,2,9726,0),(22455,10,9726,0),(22456,2,9727,0),(22457,10,9727,0),(22458,2,9728,0),(22459,10,9728,0),(22460,2,9729,0),(22461,10,9729,0),(22462,2,9730,0),(22463,10,9730,0),(22464,2,9731,0),(22465,10,9731,0),(22466,2,9732,0),(22467,10,9732,0),(22468,2,9733,0),(22469,10,9733,0),(22470,2,9734,0),(22471,10,9734,0),(22472,2,9735,0),(22473,10,9735,0),(22474,2,9736,0),(22475,10,9736,0),(22476,2,9737,0),(22477,10,9737,0),(22478,2,9738,0),(22479,10,9738,0),(22480,2,9739,0),(22481,10,9739,0),(22482,2,9740,0),(22483,10,9740,0),(22484,2,9741,0),(22485,10,9741,0),(22486,2,9742,0),(22487,10,9742,0),(22488,2,9743,0),(22489,10,9743,0),(22490,2,9744,0),(22491,10,9744,0),(22492,2,9745,0),(22493,10,9745,0),(22494,2,9746,0),(22495,10,9746,0),(22496,2,9747,0),(22497,10,9747,0),(22498,2,9748,0),(22499,10,9748,0),(22500,2,9749,0),(22501,10,9749,0),(22502,2,9750,0),(22503,10,9750,0),(22504,2,9751,0),(22505,10,9751,0),(22506,2,9752,0),(22507,10,9752,0),(22508,2,9753,0),(22509,10,9753,0),(22510,2,9754,0),(22511,10,9754,0),(22512,2,9755,0),(22513,10,9755,0),(22514,2,9756,0),(22515,10,9756,0),(22516,2,9757,0),(22517,10,9757,0),(22518,2,9758,0),(22519,10,9758,0),(22520,2,9759,0),(22521,10,9759,0),(22522,2,9760,0),(22523,10,9760,0),(22524,2,9761,0),(22525,10,9761,0),(22526,2,9762,0),(22527,10,9762,0),(22528,2,9763,0),(22529,10,9763,0),(22530,2,9764,0),(22531,10,9764,0),(22532,2,9765,0),(22533,10,9765,0),(22534,2,9766,0),(22535,10,9766,0),(22536,2,9767,0),(22537,10,9767,0),(22538,2,9768,0),(22539,10,9768,0),(22540,2,9769,0),(22541,10,9769,0),(22542,2,9770,0),(22543,10,9770,0),(22544,2,9771,0),(22545,10,9771,0),(22546,2,9772,0),(22547,10,9772,0),(22548,2,9773,0),(22549,10,9773,0),(22550,2,9774,0),(22551,10,9774,0),(22552,2,9775,0),(22553,10,9775,0),(22554,2,9776,0),(22555,10,9776,0),(22556,2,9777,0),(22557,10,9777,0),(22558,2,9778,0),(22559,10,9778,0),(22560,2,9779,0),(22561,10,9779,0),(22562,2,9780,0),(22563,10,9780,0),(22564,2,9781,0),(22565,10,9781,0),(22566,2,9782,0),(22567,10,9782,0),(22568,2,9783,0),(22569,10,9783,0),(22570,2,9784,0),(22571,10,9784,0),(22572,2,9785,0),(22573,10,9785,0),(22574,2,9786,0),(22575,10,9786,0),(22576,2,9787,0),(22577,10,9787,0),(22578,2,9788,0),(22579,10,9788,0),(22580,2,9789,0),(22581,10,9789,0),(22582,2,9790,0),(22583,10,9790,0),(22584,2,9791,0),(22585,10,9791,0),(22586,2,9792,0),(22587,10,9792,0),(22588,2,9793,0),(22589,10,9793,0),(22590,2,9794,0),(22591,10,9794,0),(22592,2,9795,0),(22593,10,9795,0),(22594,2,9796,0),(22595,10,9796,0),(22596,2,9797,0),(22597,10,9797,0),(22598,2,9798,0),(22599,10,9798,0),(22600,2,9799,0),(22601,10,9799,0),(22602,2,9800,0),(22603,10,9800,0),(22604,2,9801,0),(22605,10,9801,0),(22606,2,9802,0),(22607,10,9802,0),(22608,2,9803,0),(22609,10,9803,0),(22610,2,9804,0),(22611,10,9804,0),(22612,2,9805,0),(22613,10,9805,0),(22614,2,9806,0),(22615,10,9806,0),(22616,2,9807,0),(22617,10,9807,0),(22618,2,9808,0),(22619,10,9808,0),(22620,2,9809,0),(22621,10,9809,0),(22622,2,9810,0),(22623,10,9810,0),(22624,2,9811,0),(22625,10,9811,0),(22626,2,9812,0),(22627,10,9812,0),(22628,2,9813,0),(22629,10,9813,0),(22630,2,9814,0),(22631,10,9814,0),(22632,2,9815,0),(22633,10,9815,0),(22634,2,9816,0),(22635,10,9816,0),(22636,2,9817,0),(22637,10,9817,0),(22638,2,9818,0),(22639,10,9818,0),(22640,2,9819,0),(22641,10,9819,0),(22642,2,9820,0),(22643,10,9820,0),(22644,2,9821,0),(22645,10,9821,0),(22646,2,9822,0),(22647,10,9822,0),(22648,2,9823,0),(22649,10,9823,0),(22650,2,9824,0),(22651,10,9824,0),(22652,2,9825,0),(22653,10,9825,0),(22654,2,9826,0),(22655,10,9826,0),(22656,2,9827,0),(22657,10,9827,0),(22658,2,9828,0),(22659,10,9828,0),(22660,2,9829,0),(22661,10,9829,0),(22662,2,9830,0),(22663,10,9830,0),(22664,2,9831,0),(22665,10,9831,0),(22666,2,9832,0),(22667,10,9832,0),(22668,2,9833,0),(22669,10,9833,0),(22670,2,9834,0),(22671,10,9834,0),(22672,2,9835,0),(22673,10,9835,0),(22674,2,9836,0),(22675,10,9836,0),(22676,2,9837,0),(22677,10,9837,0),(22678,2,9838,0),(22679,10,9838,0),(22680,2,9839,0),(22681,10,9839,0),(22682,2,9840,0),(22683,10,9840,0),(22684,2,9841,0),(22685,10,9841,0),(22686,2,9842,0),(22687,10,9842,0),(22688,2,9843,0),(22689,10,9843,0),(22690,2,9844,0),(22691,10,9844,0),(22692,2,9845,0),(22693,10,9845,0),(22694,2,9846,0),(22695,10,9846,0),(22696,2,9847,0),(22697,10,9847,0),(22698,2,9848,0),(22699,10,9848,0),(22700,2,9849,0),(22701,10,9849,0),(22702,2,9850,0),(22703,10,9850,0),(22704,2,9851,0),(22705,10,9851,0),(22706,2,9852,0),(22707,10,9852,0),(22708,2,9853,0),(22709,10,9853,0),(22710,2,9854,0),(22711,10,9854,0),(22712,2,9855,0),(22713,10,9855,0),(22714,2,9856,0),(22715,10,9856,0),(22716,2,9857,0),(22717,10,9857,0),(22718,2,9858,0),(22719,10,9858,0),(22720,2,9859,0),(22721,10,9859,0),(22722,2,9860,0),(22723,10,9860,0),(22724,2,9861,0),(22725,10,9861,0),(22726,2,9862,0),(22727,10,9862,0),(22728,2,9863,0),(22729,10,9863,0),(22730,2,9864,0),(22731,10,9864,0),(22732,2,9865,0),(22733,10,9865,0),(22734,2,9866,0),(22735,10,9866,0),(22736,2,9867,0),(22737,10,9867,0),(22738,2,9868,0),(22739,10,9868,0),(22740,2,9869,0),(22741,10,9869,0),(22742,2,9870,0),(22743,10,9870,0),(22744,2,9871,0),(22745,10,9871,0),(22746,2,9872,0),(22747,10,9872,0),(22748,2,9873,0),(22749,10,9873,0),(22750,2,9874,0),(22751,10,9874,0),(22752,2,9875,0),(22753,10,9875,0),(22754,2,9876,0),(22755,10,9876,0),(22756,2,9877,0),(22757,10,9877,0),(22758,2,9878,0),(22759,10,9878,0),(22760,2,9879,0),(22761,10,9879,0),(22762,2,9880,0),(22763,10,9880,0),(22764,2,9881,0),(22765,10,9881,0),(22766,2,9882,0),(22767,10,9882,0),(22768,2,9883,0),(22769,10,9883,0),(22770,2,9884,0),(22771,10,9884,0),(22772,2,9885,0),(22773,10,9885,0),(22774,2,9886,0),(22775,10,9886,0),(22776,2,9887,0),(22777,10,9887,0),(22778,2,9888,0),(22779,10,9888,0),(22780,2,9889,0),(22781,10,9889,0),(22782,2,9890,0),(22783,10,9890,0),(22784,2,9891,0),(22785,10,9891,0),(22786,2,9892,0),(22787,10,9892,0),(22788,2,9893,0),(22789,10,9893,0),(22790,2,9894,0),(22791,10,9894,0),(22792,2,9895,0),(22793,10,9895,0),(22794,2,9896,0),(22795,10,9896,0),(22796,2,9897,0),(22797,10,9897,0),(22798,2,9898,0),(22799,10,9898,0),(22800,2,9899,0),(22801,10,9899,0),(22802,2,9900,0),(22803,10,9900,0),(22804,2,9901,0),(22805,10,9901,0),(22806,2,9902,0),(22807,10,9902,0),(22808,2,9903,0),(22809,10,9903,0),(22810,2,9904,0),(22811,10,9904,0),(22812,2,9905,0),(22813,10,9905,0),(22814,2,9906,0),(22815,10,9906,0),(22816,2,9907,0),(22817,10,9907,0),(22818,2,9908,0),(22819,10,9908,0),(22820,2,9909,0),(22821,10,9909,0),(22822,2,9910,0),(22823,10,9910,0),(22824,2,9911,0),(22825,10,9911,0),(22826,2,9912,0),(22827,10,9912,0),(22828,2,9913,0),(22829,10,9913,0),(22830,2,9914,0),(22831,10,9914,0),(22832,2,9915,0),(22833,10,9915,0),(22834,2,9916,0),(22835,10,9916,0),(22836,2,9917,0),(22837,10,9917,0),(22838,2,9918,0),(22839,10,9918,0),(22840,2,9919,0),(22841,10,9919,0),(22842,2,9920,0),(22843,10,9920,0),(22844,2,9921,0),(22845,10,9921,0),(22846,2,9922,0),(22847,10,9922,0),(22848,2,9923,0),(22849,10,9923,0),(22850,2,9924,0),(22851,10,9924,0),(22852,2,9925,0),(22853,10,9925,0),(22854,2,9926,0),(22855,10,9926,0),(22856,2,9927,0),(22857,10,9927,0),(22858,2,9928,0),(22859,10,9928,0),(22860,2,9929,0),(22861,10,9929,0),(22862,2,9930,0),(22863,10,9930,0),(22864,2,9931,0),(22865,10,9931,0),(22866,2,9932,0),(22867,10,9932,0),(22868,2,9933,0),(22869,10,9933,0),(22870,2,9934,0),(22871,10,9934,0),(22872,2,9935,0),(22873,10,9935,0),(22874,2,9936,0),(22875,10,9936,0),(22876,2,9937,0),(22877,10,9937,0),(22878,2,9938,0),(22879,10,9938,0),(22880,2,9939,0),(22881,10,9939,0),(22882,2,9940,0),(22883,10,9940,0),(22884,2,9941,0),(22885,10,9941,0),(22886,2,9942,0),(22887,10,9942,0),(22888,2,9943,0),(22889,10,9943,0),(22890,2,9944,0),(22891,10,9944,0),(22892,2,9945,0),(22893,10,9945,0),(22894,2,9946,0),(22895,10,9946,0),(22896,2,9947,0),(22897,10,9947,0),(22898,2,9948,0),(22899,10,9948,0),(22900,2,9949,0),(22901,10,9949,0),(22902,2,9950,0),(22903,10,9950,0),(22904,2,9951,0),(22905,10,9951,0),(22906,2,9952,0),(22907,10,9952,0),(22908,2,9953,0),(22909,10,9953,0),(22910,2,9954,0),(22911,10,9954,0),(22912,2,9955,0),(22913,10,9955,0),(22914,2,9956,0),(22915,10,9956,0),(22916,2,9957,0),(22917,10,9957,0),(22918,2,9958,0),(22919,10,9958,0),(22920,2,9959,0),(22921,10,9959,0),(22922,2,9960,0),(22923,10,9960,0),(22924,2,9961,0),(22925,10,9961,0),(22926,2,9962,0),(22927,10,9962,0),(22928,2,9963,0),(22929,10,9963,0),(22930,2,9964,0),(22931,10,9964,0),(22932,2,9965,0),(22933,10,9965,0),(22934,2,9966,0),(22935,10,9966,0),(22936,2,9967,0),(22937,10,9967,0),(22938,2,9968,0),(22939,10,9968,0),(22940,2,9969,0),(22941,10,9969,0),(22942,2,9970,0),(22943,10,9970,0),(22944,2,9971,0),(22945,10,9971,0),(22946,2,9972,0),(22947,10,9972,0),(22948,2,9973,0),(22949,10,9973,0),(22950,2,9974,0),(22951,10,9974,0),(22952,2,9975,0),(22953,10,9975,0),(22954,2,9976,0),(22955,10,9976,0),(22956,2,9977,0),(22957,10,9977,0),(22958,2,9978,0),(22959,10,9978,0),(22960,2,9979,0),(22961,10,9979,0),(22962,2,9980,0),(22963,10,9980,0),(22964,2,9981,0),(22965,10,9981,0),(22966,2,9982,0),(22967,10,9982,0),(22968,2,9983,0),(22969,10,9983,0),(22970,2,9984,0),(22971,10,9984,0),(22972,2,9985,0),(22973,10,9985,0),(22974,2,9986,0),(22975,10,9986,0),(22976,2,9987,0),(22977,10,9987,0),(22978,2,9988,0),(22979,10,9988,0),(22980,2,9989,0),(22981,10,9989,0),(22982,2,9990,0),(22983,10,9990,0),(22984,2,9991,0),(22985,10,9991,0),(22986,2,9992,0),(22987,10,9992,0),(22988,2,9993,0),(22989,10,9993,0),(22990,2,9994,0),(22991,10,9994,0),(22992,2,9995,0),(22993,10,9995,0),(22994,2,9996,0),(22995,10,9996,0),(22996,2,9997,0),(22997,10,9997,0),(22998,2,9998,0),(22999,10,9998,0),(23000,2,9999,0),(23001,10,9999,0),(23002,2,10000,0),(23003,10,10000,0),(23004,2,10001,0),(23005,10,10001,0),(23006,2,10002,0),(23007,10,10002,0),(23008,2,10003,0),(23009,10,10003,0),(23010,2,10004,0),(23011,10,10004,0),(23012,2,10005,0),(23013,10,10005,0),(23014,2,10006,0),(23015,10,10006,0),(23016,2,10007,0),(23017,10,10007,0),(23018,2,10008,0),(23019,10,10008,0),(23020,2,10009,0),(23021,10,10009,0),(23022,2,10010,0),(23023,10,10010,0),(23024,2,10011,0),(23025,10,10011,0),(23026,2,10012,0),(23027,10,10012,0),(23028,2,10013,0),(23029,10,10013,0),(23030,2,10014,0),(23031,10,10014,0),(23032,2,10015,0),(23033,10,10015,0),(23034,2,10016,0),(23035,10,10016,0),(23036,2,10017,0),(23037,10,10017,0),(23038,2,10018,0),(23039,10,10018,0),(23040,2,10019,0),(23041,10,10019,0),(23042,2,10020,0),(23043,10,10020,0),(23044,2,10021,0),(23045,10,10021,0),(23046,2,10022,0),(23047,10,10022,0),(23048,2,10023,0),(23049,10,10023,0),(23050,2,10024,0),(23051,10,10024,0),(23052,2,10025,0),(23053,10,10025,0),(23054,2,10026,0),(23055,10,10026,0),(23056,2,10027,0),(23057,10,10027,0),(23058,2,10028,0),(23059,10,10028,0),(23060,2,10029,0),(23061,10,10029,0),(23062,2,10030,0),(23063,10,10030,0),(23064,2,10031,0),(23065,10,10031,0),(23066,2,10032,0),(23067,10,10032,0),(23068,2,10033,0),(23069,10,10033,0),(23070,2,10034,0),(23071,10,10034,0),(23072,2,10035,0),(23073,10,10035,0),(23074,2,10036,0),(23075,10,10036,0),(23076,2,10037,0),(23077,10,10037,0),(23078,2,10038,0),(23079,10,10038,0),(23080,2,10039,0),(23081,10,10039,0),(23082,2,10040,0),(23083,10,10040,0),(23084,2,10041,0),(23085,10,10041,0),(23086,2,10042,0),(23087,10,10042,0),(23088,2,10043,0),(23089,10,10043,0),(23090,2,10044,0),(23091,10,10044,0),(23092,2,10045,0),(23093,10,10045,0),(23094,2,10046,0),(23095,10,10046,0),(23096,2,10047,0),(23097,10,10047,0),(23098,2,10048,0),(23099,10,10048,0),(23100,2,10049,0),(23101,10,10049,0),(23102,2,10050,0),(23103,10,10050,0),(23104,2,10051,0),(23105,10,10051,0),(23106,2,10052,0),(23107,10,10052,0),(23108,2,10053,0),(23109,10,10053,0),(23110,2,10054,0),(23111,10,10054,0),(23112,2,10055,0),(23113,10,10055,0),(23114,2,10056,0),(23115,10,10056,0),(23116,2,10057,0),(23117,10,10057,0),(23118,2,10058,0),(23119,10,10058,0),(23120,2,10059,0),(23121,10,10059,0),(23122,2,10060,0),(23123,10,10060,0),(23124,2,10061,0),(23125,10,10061,0),(23126,2,10062,0),(23127,10,10062,0),(23128,2,10063,0),(23129,10,10063,0),(23130,2,10064,0),(23131,10,10064,0),(23132,2,10065,0),(23133,10,10065,0),(23134,2,10066,0),(23135,10,10066,0),(23136,2,10067,0),(23137,10,10067,0),(23138,2,10068,0),(23139,10,10068,0),(23140,2,10069,0),(23141,10,10069,0),(23142,2,10070,0),(23143,10,10070,0),(23144,2,10071,0),(23145,10,10071,0),(23146,2,10072,0),(23147,10,10072,0),(23148,2,10073,0),(23149,10,10073,0),(23150,2,10074,0),(23151,10,10074,0),(23152,2,10075,0),(23153,10,10075,0),(23154,2,10076,0),(23155,10,10076,0),(23156,2,10077,0),(23157,10,10077,0),(23158,2,10078,0),(23159,10,10078,0),(23160,2,10079,0),(23161,10,10079,0),(23162,2,10080,0),(23163,10,10080,0),(23164,2,10081,0),(23165,10,10081,0),(23166,2,10082,0),(23167,10,10082,0),(23168,2,10083,0),(23169,10,10083,0),(23170,2,10084,0),(23171,10,10084,0),(23172,2,10085,0),(23173,10,10085,0),(23174,2,10086,0),(23175,10,10086,0),(23176,2,10087,0),(23177,10,10087,0),(23178,2,10088,0),(23179,10,10088,0),(23180,2,10089,0),(23181,10,10089,0),(23182,2,10090,0),(23183,10,10090,0),(23184,2,10091,0),(23185,10,10091,0),(23186,2,10092,0),(23187,10,10092,0),(23188,2,10093,0),(23189,10,10093,0),(23190,2,10094,0),(23191,10,10094,0),(23192,2,10095,0),(23193,10,10095,0),(23194,2,10096,0),(23195,10,10096,0),(23196,2,10097,0),(23197,10,10097,0),(23198,2,10098,0),(23199,10,10098,0),(23200,2,10099,0),(23201,10,10099,0),(23202,2,10100,0),(23203,10,10100,0),(23204,2,10101,0),(23205,10,10101,0),(23206,2,10102,0),(23207,10,10102,0),(23208,2,10103,0),(23209,10,10103,0),(23210,2,10104,0),(23211,10,10104,0),(23212,2,10105,0),(23213,10,10105,0),(23214,2,10106,0),(23215,10,10106,0),(23216,2,10107,0),(23217,10,10107,0),(23218,2,10108,0),(23219,10,10108,0),(23220,2,10109,0),(23221,10,10109,0),(23222,2,10110,0),(23223,10,10110,0),(23224,2,10111,0),(23225,10,10111,0),(23226,2,10112,0),(23227,10,10112,0),(23228,2,10113,0),(23229,10,10113,0),(23230,2,10114,0),(23231,10,10114,0),(23232,2,10115,0),(23233,10,10115,0),(23234,2,10116,0),(23235,10,10116,0),(23236,2,10117,0),(23237,10,10117,0),(23238,2,10118,0),(23239,10,10118,0),(23240,2,10119,0),(23241,10,10119,0),(23242,2,10120,0),(23243,10,10120,0),(23244,2,10121,0),(23245,10,10121,0),(23246,2,10122,0),(23247,10,10122,0),(23248,2,10123,0),(23249,10,10123,0),(23250,2,10124,0),(23251,10,10124,0),(23252,2,10125,0),(23253,10,10125,0),(23254,2,10126,0),(23255,10,10126,0),(23256,2,10127,0),(23257,10,10127,0),(23258,2,10128,0),(23259,10,10128,0),(23260,2,10129,0),(23261,10,10129,0),(23262,2,10130,0),(23263,10,10130,0),(23264,2,10131,0),(23265,10,10131,0),(23266,2,10132,0),(23267,10,10132,0),(23268,2,10133,0),(23269,10,10133,0),(23270,2,10134,0),(23271,10,10134,0),(23272,2,10135,0),(23273,10,10135,0),(23274,2,10136,0),(23275,10,10136,0),(23276,2,10137,0),(23277,10,10137,0),(23278,2,10138,0),(23279,10,10138,0),(23280,2,10139,0),(23281,10,10139,0),(23282,2,10140,0),(23283,10,10140,0),(23284,2,10141,0),(23285,10,10141,0),(23286,2,10142,0),(23287,10,10142,0),(23288,2,10143,0),(23289,10,10143,0),(23290,2,10144,0),(23291,10,10144,0),(23292,2,10145,0),(23293,10,10145,0),(23294,2,10146,0),(23295,10,10146,0),(23296,2,10147,0),(23297,10,10147,0),(23298,2,10148,0),(23299,10,10148,0),(23300,2,10149,0),(23301,10,10149,0),(23302,2,10150,0),(23303,10,10150,0),(23304,2,10151,0),(23305,10,10151,0),(23306,2,10152,0),(23307,10,10152,0),(23308,2,10153,0),(23309,10,10153,0),(23310,2,10154,0),(23311,10,10154,0),(23312,2,10155,0),(23313,10,10155,0),(23314,2,10156,0),(23315,10,10156,0),(23316,2,10157,0),(23317,10,10157,0),(23318,2,10158,0),(23319,10,10158,0),(23320,2,10159,0),(23321,10,10159,0),(23322,2,10160,0),(23323,10,10160,0),(23324,2,10161,0),(23325,10,10161,0),(23326,2,10162,0),(23327,10,10162,0),(23328,2,10163,0),(23329,10,10163,0),(23330,2,10164,0),(23331,10,10164,0),(23332,2,10165,0),(23333,10,10165,0),(23334,2,10166,0),(23335,10,10166,0),(23336,2,10167,0),(23337,10,10167,0),(23338,2,10168,0),(23339,10,10168,0),(23340,2,10169,0),(23341,10,10169,0),(23342,2,10170,0),(23343,10,10170,0),(23344,2,10171,0),(23345,10,10171,0),(23346,2,10172,0),(23347,10,10172,0),(23348,2,10173,0),(23349,10,10173,0),(23350,2,10174,0),(23351,10,10174,0),(23352,2,10175,0),(23353,10,10175,0),(23354,2,10176,0),(23355,10,10176,0),(23356,2,10177,0),(23357,10,10177,0),(23358,2,10178,0),(23359,10,10178,0),(23360,2,10179,0),(23361,10,10179,0),(23362,2,10180,0),(23363,10,10180,0),(23364,2,10181,0),(23365,10,10181,0),(23366,2,10182,0),(23367,10,10182,0),(23368,2,10183,0),(23369,10,10183,0),(23370,2,10184,0),(23371,10,10184,0),(23372,2,10185,0),(23373,10,10185,0),(23374,2,10186,0),(23375,10,10186,0),(23376,2,10187,0),(23377,10,10187,0),(23378,2,10188,0),(23379,10,10188,0),(23380,2,10189,0),(23381,10,10189,0),(23382,2,10190,0),(23383,10,10190,0),(23384,2,10191,0),(23385,10,10191,0),(23386,2,10192,0),(23387,10,10192,0),(23388,2,10193,0),(23389,10,10193,0),(23390,2,10194,0),(23391,10,10194,0),(23392,2,10195,0),(23393,10,10195,0),(23394,2,10196,0),(23395,10,10196,0),(23396,2,10197,0),(23397,10,10197,0),(23398,2,10198,0),(23399,10,10198,0),(23400,2,10199,0),(23401,10,10199,0),(23402,2,10200,0),(23403,10,10200,0),(23404,2,10201,0),(23405,10,10201,0),(23406,2,10202,0),(23407,10,10202,0),(23408,2,10203,0),(23409,10,10203,0),(23410,2,10204,0),(23411,10,10204,0),(23412,2,10205,0),(23413,10,10205,0),(23414,2,10206,0),(23415,10,10206,0),(23416,2,10207,0),(23417,10,10207,0),(23418,2,10208,0),(23419,10,10208,0),(23420,2,10209,0),(23421,10,10209,0),(23422,2,10210,0),(23423,10,10210,0),(23424,2,10211,0),(23425,10,10211,0),(23426,2,10212,0),(23427,10,10212,0),(23428,2,10213,0),(23429,10,10213,0),(23430,2,10214,0),(23431,10,10214,0),(23432,2,10215,0),(23433,10,10215,0),(23434,2,10216,0),(23435,10,10216,0),(23436,2,10217,0),(23437,10,10217,0),(23438,2,10218,0),(23439,10,10218,0),(23440,2,10219,0),(23441,10,10219,0),(23442,2,10220,0),(23443,10,10220,0),(23444,2,10221,0),(23445,10,10221,0),(23446,2,10222,0),(23447,10,10222,0),(23448,2,10223,0),(23449,10,10223,0),(23450,2,10224,0),(23451,10,10224,0),(23452,2,10225,0),(23453,10,10225,0),(23454,2,10226,0),(23455,10,10226,0),(23456,2,10227,0),(23457,10,10227,0),(23458,2,10228,0),(23459,10,10228,0),(23460,2,10229,0),(23461,10,10229,0),(23462,2,10230,0),(23463,10,10230,0),(23464,2,10231,0),(23465,10,10231,0),(23466,2,10232,0),(23467,10,10232,0),(23468,2,10233,0),(23469,10,10233,0),(23470,2,10234,0),(23471,10,10234,0),(23472,2,10235,0),(23473,10,10235,0),(23474,2,10236,0),(23475,10,10236,0),(23476,2,10237,0),(23477,10,10237,0),(23478,2,10238,0),(23479,10,10238,0),(23480,2,10239,0),(23481,10,10239,0),(23482,2,10240,0),(23483,10,10240,0),(23484,2,10241,0),(23485,10,10241,0),(23486,2,10242,0),(23487,10,10242,0),(23488,2,10243,0),(23489,10,10243,0),(23490,2,10244,0),(23491,10,10244,0),(23492,2,10245,0),(23493,10,10245,0),(23494,2,10246,0),(23495,10,10246,0),(23496,2,10247,0),(23497,10,10247,0),(23498,2,10248,0),(23499,10,10248,0),(23500,2,10249,0),(23501,10,10249,0),(23502,2,10250,0),(23503,10,10250,0),(23504,2,10251,0),(23505,10,10251,0),(23506,2,10252,0),(23507,10,10252,0),(23508,2,10253,0),(23509,10,10253,0),(23510,2,10254,0),(23511,10,10254,0),(23512,2,10255,0),(23513,10,10255,0),(23514,2,10256,0),(23515,10,10256,0),(23516,2,10257,0),(23517,10,10257,0),(23518,2,10258,0),(23519,10,10258,0),(23520,2,10259,0),(23521,10,10259,0),(23522,2,10260,0),(23523,10,10260,0),(23524,2,10261,0),(23525,10,10261,0),(23526,2,10262,0),(23527,10,10262,0),(23528,2,10263,0),(23529,10,10263,0),(23530,2,10264,0),(23531,10,10264,0),(23532,2,10265,0),(23533,10,10265,0),(23534,2,10266,0),(23535,10,10266,0),(23536,2,10267,0),(23537,10,10267,0),(23538,2,10268,0),(23539,10,10268,0),(23540,2,10269,0),(23541,10,10269,0),(23542,2,10270,0),(23543,10,10270,0),(23544,2,10271,0),(23545,10,10271,0),(23546,2,10272,0),(23547,10,10272,0),(23548,2,10273,0),(23549,10,10273,0),(23550,2,10274,0),(23551,10,10274,0),(23552,2,10275,0),(23553,10,10275,0),(23554,2,10276,0),(23555,10,10276,0),(23556,2,10277,0),(23557,10,10277,0),(23558,2,10278,0),(23559,10,10278,0),(23560,2,10279,0),(23561,10,10279,0),(23562,2,10280,0),(23563,10,10280,0),(23564,2,10281,0),(23565,10,10281,0),(23566,2,10282,0),(23567,10,10282,0),(23568,2,10283,0),(23569,10,10283,0),(23570,2,10284,0),(23571,10,10284,0),(23572,2,10285,0),(23573,10,10285,0),(23574,2,10286,0),(23575,10,10286,0),(23576,2,10287,0),(23577,10,10287,0),(23578,2,10288,0),(23579,10,10288,0),(23580,2,10289,0),(23581,10,10289,0),(23582,2,10290,0),(23583,10,10290,0),(23584,2,10291,0),(23585,10,10291,0),(23586,2,10292,0),(23587,10,10292,0),(23588,2,10293,0),(23589,10,10293,0),(23590,2,10294,0),(23591,10,10294,0),(23592,2,10295,0),(23593,10,10295,0),(23594,2,10296,0),(23595,10,10296,0),(23596,2,10297,0),(23597,10,10297,0),(23598,2,10298,0),(23599,10,10298,0),(23600,2,10299,0),(23601,10,10299,0),(23602,2,10300,0),(23603,10,10300,0),(23604,2,10301,0),(23605,10,10301,0),(23606,2,10302,0),(23607,10,10302,0),(23608,2,10303,0),(23609,10,10303,0),(23610,2,10304,0),(23611,10,10304,0),(23612,2,10305,0),(23613,10,10305,0),(23614,2,10306,0),(23615,10,10306,0),(23616,2,10307,0),(23617,10,10307,0),(23618,2,10308,0),(23619,10,10308,0),(23620,2,10309,0),(23621,10,10309,0),(23622,2,10310,0),(23623,10,10310,0),(23624,2,10311,0),(23625,10,10311,0),(23626,2,10312,0),(23627,10,10312,0),(23628,2,10313,0),(23629,10,10313,0),(23630,2,10314,0),(23631,10,10314,0),(23632,2,10315,0),(23633,10,10315,0),(23634,2,10316,0),(23635,10,10316,0),(23636,2,10317,0),(23637,10,10317,0),(23638,2,10318,0),(23639,10,10318,0),(23640,2,10319,0),(23641,10,10319,0),(23642,2,10320,0),(23643,10,10320,0),(23644,2,10321,0),(23645,10,10321,0),(23646,2,10322,0),(23647,10,10322,0),(23648,2,10323,0),(23649,10,10323,0),(23650,2,10324,0),(23651,10,10324,0),(23652,2,10325,0),(23653,10,10325,0),(23654,2,10326,0),(23655,10,10326,0),(23656,2,10327,0),(23657,10,10327,0),(23658,2,10328,0),(23659,10,10328,0),(23660,2,10329,0),(23661,10,10329,0),(23662,2,10330,0),(23663,10,10330,0),(23664,2,10331,0),(23665,10,10331,0),(23666,2,10332,0),(23667,10,10332,0),(23668,2,10333,0),(23669,10,10333,0),(23670,2,10334,0),(23671,10,10334,0),(23672,2,10335,0),(23673,10,10335,0),(23674,2,10336,0),(23675,10,10336,0),(23676,2,10337,0),(23677,10,10337,0),(23678,2,10338,0),(23679,10,10338,0),(23680,2,10339,0),(23681,10,10339,0),(23682,2,10340,0),(23683,10,10340,0),(23684,2,10341,0),(23685,10,10341,0),(23686,2,10342,0),(23687,10,10342,0),(23688,2,10343,0),(23689,10,10343,0),(23690,2,10344,0),(23691,10,10344,0),(23692,2,10345,0),(23693,10,10345,0),(23694,2,10346,0),(23695,10,10346,0),(23696,2,10347,0),(23697,10,10347,0),(23698,2,10348,0),(23699,10,10348,0),(23700,2,10349,0),(23701,10,10349,0),(23702,2,10350,0),(23703,10,10350,0),(23704,2,10351,0),(23705,10,10351,0),(23706,2,10352,0),(23707,10,10352,0),(23708,2,10353,0),(23709,10,10353,0),(23710,2,10354,0),(23711,10,10354,0),(23712,2,10355,0),(23713,10,10355,0),(23714,2,10356,0),(23715,10,10356,0),(23716,2,10357,0),(23717,10,10357,0),(23718,2,10358,0),(23719,10,10358,0),(23720,2,10359,0),(23721,10,10359,0),(23722,2,10360,0),(23723,10,10360,0),(23724,2,10361,0),(23725,10,10361,0),(23726,2,10362,0),(23727,10,10362,0),(23728,2,10363,0),(23729,10,10363,0),(23730,2,10364,0),(23731,10,10364,0),(23732,2,10365,0),(23733,10,10365,0),(23734,2,10366,0),(23735,10,10366,0),(23736,2,10367,0),(23737,10,10367,0),(23738,2,10368,0),(23739,10,10368,0),(23740,2,10369,0),(23741,10,10369,0),(23742,2,10370,0),(23743,10,10370,0),(23744,2,10371,0),(23745,10,10371,0),(23746,2,10372,0),(23747,10,10372,0),(23748,2,10373,0),(23749,10,10373,0),(23750,2,10374,0),(23751,10,10374,0),(23752,2,10375,0),(23753,10,10375,0),(23754,2,10376,0),(23755,10,10376,0),(23756,2,10377,0),(23757,10,10377,0),(23758,2,10378,0),(23759,10,10378,0),(23760,2,10379,0),(23761,10,10379,0),(23762,2,10380,0),(23763,10,10380,0),(23764,2,10381,0),(23765,10,10381,0),(23766,2,10382,0),(23767,10,10382,0),(23768,2,10383,0),(23769,10,10383,0),(23770,2,10384,0),(23771,10,10384,0),(23772,2,10385,0),(23773,10,10385,0),(23774,2,10386,0),(23775,10,10386,0),(23776,2,10387,0),(23777,10,10387,0),(23778,2,10388,0),(23779,10,10388,0),(23780,2,10389,0),(23781,10,10389,0),(23782,2,10390,0),(23783,10,10390,0),(23784,2,10391,0),(23785,10,10391,0),(23786,2,10392,0),(23787,10,10392,0),(23788,2,10393,0),(23789,10,10393,0),(23790,2,10394,0),(23791,10,10394,0),(23792,2,10395,0),(23793,10,10395,0),(23794,2,10396,0),(23795,10,10396,0),(23796,2,10397,0),(23797,10,10397,0),(23798,2,10398,0),(23799,10,10398,0),(23800,2,10399,0),(23801,10,10399,0),(23802,2,10400,0),(23803,10,10400,0),(23804,2,10401,0),(23805,10,10401,0),(23806,2,10402,0),(23807,10,10402,0),(23808,2,10403,0),(23809,10,10403,0),(23810,2,10404,0),(23811,10,10404,0),(23812,2,10405,0),(23813,10,10405,0),(23814,2,10406,0),(23815,10,10406,0),(23816,2,10407,0),(23817,10,10407,0),(23818,2,10408,0),(23819,10,10408,0),(23820,2,10409,0),(23821,10,10409,0),(23822,2,10410,0),(23823,10,10410,0),(23824,2,10411,0),(23825,10,10411,0),(23826,2,10412,0),(23827,10,10412,0),(23828,2,10413,0),(23829,10,10413,0),(23830,2,10414,0),(23831,10,10414,0),(23832,2,10415,0),(23833,10,10415,0),(23834,2,10416,0),(23835,10,10416,0),(23836,2,10417,0),(23837,10,10417,0),(23838,2,10418,0),(23839,10,10418,0),(23840,2,10419,0),(23841,10,10419,0),(23842,2,10420,0),(23843,10,10420,0),(23844,2,10421,0),(23845,10,10421,0),(23846,2,10422,0),(23847,10,10422,0),(23848,2,10423,0),(23849,10,10423,0),(23850,2,10424,0),(23851,10,10424,0),(23852,2,10425,0),(23853,10,10425,0),(23854,2,10426,0),(23855,10,10426,0),(23856,2,10427,0),(23857,10,10427,0),(23858,2,10428,0),(23859,10,10428,0),(23860,2,10429,0),(23861,10,10429,0),(23862,2,10430,0),(23863,10,10430,0),(23864,2,10431,0),(23865,10,10431,0),(23866,2,10432,0),(23867,10,10432,0),(23868,2,10433,0),(23869,10,10433,0),(23870,2,10434,0),(23871,10,10434,0),(23872,2,10435,0),(23873,10,10435,0),(23874,2,10436,0),(23875,10,10436,0),(23876,2,10437,0),(23877,10,10437,0),(23878,2,10438,0),(23879,10,10438,0),(23880,2,10439,0),(23881,10,10439,0),(23882,2,10440,0),(23883,10,10440,0),(23884,2,10441,0),(23885,10,10441,0),(23886,2,10442,0),(23887,10,10442,0),(23888,2,10443,0),(23889,10,10443,0),(23890,2,10444,0),(23891,10,10444,0),(23892,2,10445,0),(23893,10,10445,0),(23894,2,10446,0),(23895,10,10446,0),(23896,2,10447,0),(23897,10,10447,0),(23898,2,10448,0),(23899,10,10448,0),(23900,2,10449,0),(23901,10,10449,0),(23902,2,10450,0),(23903,10,10450,0),(23904,2,10451,0),(23905,10,10451,0),(23906,2,10452,0),(23907,10,10452,0),(23908,2,10453,0),(23909,10,10453,0),(23910,2,10454,0),(23911,10,10454,0),(23912,2,10455,0),(23913,10,10455,0),(23914,2,10456,0),(23915,10,10456,0),(23916,2,10457,0),(23917,10,10457,0),(23918,2,10458,0),(23919,10,10458,0),(23920,2,10459,0),(23921,10,10459,0),(23922,2,10460,0),(23923,10,10460,0),(23924,2,10461,0),(23925,10,10461,0),(23926,2,10462,0),(23927,10,10462,0),(23928,2,10463,0),(23929,10,10463,0),(23930,2,10464,0),(23931,10,10464,0),(23932,2,10465,0),(23933,10,10465,0),(23934,2,10466,0),(23935,10,10466,0),(23936,2,10467,0),(23937,10,10467,0),(23938,2,10468,0),(23939,10,10468,0),(23940,2,10469,0),(23941,10,10469,0),(23942,2,10470,0),(23943,10,10470,0),(23944,2,10471,0),(23945,10,10471,0),(23946,2,10472,0),(23947,10,10472,0),(23948,2,10473,0),(23949,10,10473,0),(23950,2,10474,0),(23951,10,10474,0),(23952,2,10475,0),(23953,10,10475,0),(23954,2,10476,0),(23955,10,10476,0),(23956,2,10477,0),(23957,10,10477,0),(23958,2,10478,0),(23959,10,10478,0),(23960,2,10479,0),(23961,10,10479,0),(23962,2,10480,0),(23963,10,10480,0),(23964,2,10481,0),(23965,10,10481,0),(23966,2,10482,0),(23967,10,10482,0),(23968,2,10483,0),(23969,10,10483,0),(23970,2,10484,0),(23971,10,10484,0),(23972,2,10485,0),(23973,10,10485,0),(23974,2,10486,0),(23975,10,10486,0),(23976,2,10487,0),(23977,10,10487,0),(23978,2,10488,0),(23979,10,10488,0),(23980,2,10489,0),(23981,10,10489,0),(23982,2,10490,0),(23983,10,10490,0),(23984,2,10491,0),(23985,10,10491,0),(23986,2,10492,0),(23987,10,10492,0),(23988,2,10493,0),(23989,10,10493,0),(23990,2,10494,0),(23991,10,10494,0),(23992,2,10495,0),(23993,10,10495,0),(23994,2,10496,0),(23995,10,10496,0),(23996,2,10497,0),(23997,10,10497,0),(23998,2,10498,0),(23999,10,10498,0),(24000,2,10499,0),(24001,10,10499,0),(24002,2,10500,0),(24003,10,10500,0),(24004,2,10501,0),(24005,10,10501,0),(24006,2,10502,0),(24007,10,10502,0),(24008,2,10503,0),(24009,10,10503,0),(24010,2,10504,0),(24011,10,10504,0),(24012,2,10505,0),(24013,10,10505,0),(24014,2,10506,0),(24015,10,10506,0),(24016,2,10507,0),(24017,10,10507,0),(24018,2,10508,0),(24019,10,10508,0),(24020,2,10509,0),(24021,10,10509,0),(24022,2,10510,0),(24023,10,10510,0),(24024,2,10511,0),(24025,10,10511,0),(24026,2,10512,0),(24027,10,10512,0),(24028,2,10513,0),(24029,10,10513,0),(24030,2,10514,0),(24031,10,10514,0),(24032,2,10515,0),(24033,10,10515,0),(24034,2,10516,0),(24035,10,10516,0),(24036,2,10517,0),(24037,10,10517,0),(24038,2,10518,0),(24039,10,10518,0),(24040,2,10519,0),(24041,10,10519,0),(24042,2,10520,0),(24043,10,10520,0),(24044,2,10521,0),(24045,10,10521,0),(24046,2,10522,0),(24047,10,10522,0),(24048,2,10523,0),(24049,10,10523,0),(24050,2,10524,0),(24051,10,10524,0),(24052,2,10525,0),(24053,10,10525,0),(24054,2,10526,0),(24055,10,10526,0),(24056,2,10527,0),(24057,10,10527,0),(24058,2,10528,0),(24059,10,10528,0),(24060,2,10529,0),(24061,10,10529,0),(24062,2,10530,0),(24063,10,10530,0),(24064,2,10531,0),(24065,10,10531,0),(24066,2,10532,0),(24067,10,10532,0),(24068,2,10533,0),(24069,10,10533,0),(24070,2,10534,0),(24071,10,10534,0),(24072,2,10535,0),(24073,10,10535,0),(24074,2,10536,0),(24075,10,10536,0),(24076,2,10537,0),(24077,10,10537,0),(24078,2,10538,0),(24079,10,10538,0),(24080,2,10539,0),(24081,10,10539,0),(24082,2,10540,0),(24083,10,10540,0),(24084,2,10541,0),(24085,10,10541,0),(24086,2,10542,0),(24087,10,10542,0),(24088,2,10543,0),(24089,10,10543,0),(24090,2,10544,0),(24091,10,10544,0),(24092,2,10545,0),(24093,10,10545,0),(24094,2,10546,0),(24095,10,10546,0),(24096,2,10547,0),(24097,10,10547,0),(24098,2,10548,0),(24099,10,10548,0),(24100,2,10549,0),(24101,10,10549,0),(24102,2,10550,0),(24103,10,10550,0),(24104,2,10551,0),(24105,10,10551,0),(24106,2,10552,0),(24107,10,10552,0),(24108,2,10553,0),(24109,10,10553,0),(24110,2,10554,0),(24111,10,10554,0),(24112,2,10555,0),(24113,10,10555,0),(24114,2,10556,0),(24115,10,10556,0),(24116,2,10557,0),(24117,10,10557,0),(24118,2,10558,0),(24119,10,10558,0),(24120,2,10559,0),(24121,10,10559,0),(24122,2,10560,0),(24123,10,10560,0),(24124,2,10561,0),(24125,10,10561,0),(24126,2,10562,0),(24127,10,10562,0),(24128,2,10563,0),(24129,10,10563,0),(24130,2,10564,0),(24131,10,10564,0),(24132,2,10565,0),(24133,10,10565,0),(24134,2,10566,0),(24135,10,10566,0),(24136,2,10567,0),(24137,10,10567,0),(24138,2,10568,0),(24139,10,10568,0),(24140,2,10569,0),(24141,10,10569,0),(24142,2,10570,0),(24143,10,10570,0),(24144,2,10571,0),(24145,10,10571,0),(24146,2,10572,0),(24147,10,10572,0),(24148,2,10573,0),(24149,10,10573,0),(24150,2,10574,0),(24151,10,10574,0),(24152,2,10575,0),(24153,10,10575,0),(24154,2,10576,0),(24155,10,10576,0),(24156,2,10577,0),(24157,10,10577,0),(24158,2,10578,0),(24159,10,10578,0),(24160,2,10579,0),(24161,10,10579,0),(24162,2,10580,0),(24163,10,10580,0),(24164,2,10581,0),(24165,10,10581,0),(24166,2,10582,0),(24167,10,10582,0),(24168,2,10583,0),(24169,10,10583,0),(24170,2,10584,0),(24171,10,10584,0),(24172,2,10585,0),(24173,10,10585,0),(24174,2,10586,0),(24175,10,10586,0),(24176,2,10587,0),(24177,10,10587,0),(24178,2,10588,0),(24179,10,10588,0),(24180,2,10589,0),(24181,10,10589,0),(24182,2,10590,0),(24183,10,10590,0),(24184,2,10591,0),(24185,10,10591,0),(24186,2,10592,0),(24187,10,10592,0),(24188,2,10593,0),(24189,10,10593,0),(24190,2,10594,0),(24191,10,10594,0),(24192,2,10595,0),(24193,10,10595,0),(24194,2,10596,0),(24195,10,10596,0),(24196,2,10597,0),(24197,10,10597,0),(24198,2,10598,0),(24199,10,10598,0),(24200,2,10599,0),(24201,10,10599,0),(24202,2,10600,0),(24203,10,10600,0),(24204,2,10601,0),(24205,10,10601,0),(24206,2,10602,0),(24207,10,10602,0),(24208,2,10603,0),(24209,10,10603,0),(24210,2,10604,0),(24211,10,10604,0),(24212,2,10605,0),(24213,10,10605,0),(24214,2,10606,0),(24215,10,10606,0),(24216,2,10607,0),(24217,10,10607,0),(24218,2,10608,0),(24219,10,10608,0),(24220,2,10609,0),(24221,10,10609,0),(24222,2,10610,0),(24223,10,10610,0),(24224,2,10611,0),(24225,10,10611,0),(24226,2,10612,0),(24227,10,10612,0),(24228,2,10613,0),(24229,10,10613,0),(24230,2,10614,0),(24231,10,10614,0),(24232,2,10615,0),(24233,10,10615,0),(24234,2,10616,0),(24235,10,10616,0),(24236,2,10617,0),(24237,10,10617,0),(24238,2,10618,0),(24239,10,10618,0),(24240,2,10619,0),(24241,10,10619,0),(24242,2,10620,0),(24243,10,10620,0),(24244,2,10621,0),(24245,10,10621,0),(24246,2,10622,0),(24247,10,10622,0),(24248,2,10623,0),(24249,10,10623,0),(24250,2,10624,0),(24251,10,10624,0),(24252,2,10625,0),(24253,10,10625,0),(24254,2,10626,0),(24255,10,10626,0),(24256,2,10627,0),(24257,10,10627,0),(24258,2,10628,0),(24259,10,10628,0),(24260,2,10629,0),(24261,10,10629,0),(24262,2,10630,0),(24263,10,10630,0),(24264,2,10631,0),(24265,10,10631,0),(24266,2,10632,0),(24267,10,10632,0),(24268,2,10633,0),(24269,10,10633,0),(24270,2,10634,0),(24271,10,10634,0),(24272,2,10635,0),(24273,10,10635,0),(24274,2,10636,0),(24275,10,10636,0),(24276,2,10637,0),(24277,10,10637,0),(24278,2,10638,0),(24279,10,10638,0),(24280,2,10639,0),(24281,10,10639,0),(24282,2,10640,0),(24283,10,10640,0),(24284,2,10641,0),(24285,10,10641,0),(24286,2,10642,0),(24287,10,10642,0),(24288,2,10643,0),(24289,10,10643,0),(24290,2,10644,0),(24291,10,10644,0),(24292,2,10645,0),(24293,10,10645,0),(24294,2,10646,0),(24295,10,10646,0),(24296,2,10647,0),(24297,10,10647,0),(24298,2,10648,0),(24299,10,10648,0),(24300,2,10649,0),(24301,10,10649,0),(24302,2,10650,0),(24303,10,10650,0),(24304,2,10651,0),(24305,10,10651,0),(24306,2,10652,0),(24307,10,10652,0),(24308,2,10653,0),(24309,10,10653,0),(24310,2,10654,0),(24311,10,10654,0),(24312,2,10655,0),(24313,10,10655,0),(24314,2,10656,0),(24315,10,10656,0),(24316,2,10657,0),(24317,10,10657,0),(24318,2,10658,0),(24319,10,10658,0),(24320,2,10659,0),(24321,10,10659,0),(24322,2,10660,0),(24323,10,10660,0),(24324,2,10661,0),(24325,10,10661,0),(24326,2,10662,0),(24327,10,10662,0),(24328,2,10663,0),(24329,10,10663,0),(24330,2,10664,0),(24331,10,10664,0),(24332,2,10665,0),(24333,10,10665,0),(24334,2,10666,0),(24335,10,10666,0),(24336,2,10667,0),(24337,10,10667,0),(24338,2,10668,0),(24339,10,10668,0),(24340,2,10669,0),(24341,10,10669,0),(24342,2,10670,0),(24343,10,10670,0),(24344,2,10671,0),(24345,10,10671,0),(24346,2,10672,0),(24347,10,10672,0),(24348,2,10673,0),(24349,10,10673,0),(24350,2,10674,0),(24351,10,10674,0),(24352,2,10675,0),(24353,10,10675,0),(24354,2,10676,0),(24355,10,10676,0),(24356,2,10677,0),(24357,10,10677,0),(24358,2,10678,0),(24359,10,10678,0),(24360,2,10679,0),(24361,10,10679,0),(24362,2,10680,0),(24363,10,10680,0),(24364,2,10681,0),(24365,10,10681,0),(24366,2,10682,0),(24367,10,10682,0),(24368,2,10683,0),(24369,10,10683,0),(24370,2,10684,0),(24371,10,10684,0),(24372,2,10685,0),(24373,10,10685,0),(24374,2,10686,0),(24375,10,10686,0),(24376,2,10687,0),(24377,10,10687,0),(24378,2,10688,0),(24379,10,10688,0),(24380,2,10689,0),(24381,10,10689,0),(24382,2,10690,0),(24383,10,10690,0),(24384,2,10691,0),(24385,10,10691,0),(24386,2,10692,0),(24387,10,10692,0),(24388,2,10693,0),(24389,10,10693,0),(24390,2,10694,0),(24391,10,10694,0),(24392,2,10695,0),(24393,10,10695,0),(24394,2,10696,0),(24395,10,10696,0),(24396,2,10697,0),(24397,10,10697,0),(24398,2,10698,0),(24399,10,10698,0),(24400,2,10699,0),(24401,10,10699,0),(24402,2,10700,0),(24403,10,10700,0),(24404,2,10701,0),(24405,10,10701,0),(24406,2,10702,0),(24407,10,10702,0),(24408,2,10703,0),(24409,10,10703,0),(24410,2,10704,0),(24411,10,10704,0),(24412,2,10705,0),(24413,10,10705,0),(24414,2,10706,0),(24415,10,10706,0),(24416,2,10707,0),(24417,10,10707,0),(24418,2,10708,0),(24419,10,10708,0),(24420,2,10709,0),(24421,10,10709,0),(24422,2,10710,0),(24423,10,10710,0),(24424,2,10711,0),(24425,10,10711,0),(24426,2,10712,0),(24427,10,10712,0),(24428,2,10713,0),(24429,10,10713,0),(24430,2,10714,0),(24431,10,10714,0),(24432,2,10715,0),(24433,10,10715,0),(24434,2,10716,0),(24435,10,10716,0),(24436,2,10717,0),(24437,10,10717,0),(24438,2,10718,0),(24439,10,10718,0),(24440,2,10719,0),(24441,10,10719,0),(24442,2,10720,0),(24443,10,10720,0),(24444,2,10721,0),(24445,10,10721,0),(24446,2,10722,0),(24447,10,10722,0),(24448,2,10723,0),(24449,10,10723,0),(24450,2,10724,0),(24451,10,10724,0),(24452,2,10725,0),(24453,10,10725,0),(24454,2,10726,0),(24455,10,10726,0),(24456,2,10727,0),(24457,10,10727,0),(24458,2,10728,0),(24459,10,10728,0),(24460,2,10729,0),(24461,10,10729,0),(24462,2,10730,0),(24463,10,10730,0),(24464,2,10731,0),(24465,10,10731,0),(24466,2,10732,0),(24467,10,10732,0),(24468,2,10733,0),(24469,10,10733,0),(24470,2,10734,0),(24471,10,10734,0),(24472,2,10735,0),(24473,10,10735,0),(24474,2,10736,0),(24475,10,10736,0),(24476,2,10737,0),(24477,10,10737,0),(24478,2,10738,0),(24479,10,10738,0),(24480,2,10739,0),(24481,10,10739,0),(24482,2,10740,0),(24483,10,10740,0),(24484,2,10741,0),(24485,10,10741,0),(24486,2,10742,0),(24487,10,10742,0),(24488,2,10743,0),(24489,10,10743,0),(24490,2,10744,0),(24491,10,10744,0),(24492,2,10745,0),(24493,10,10745,0),(24494,2,10746,0),(24495,10,10746,0),(24496,2,10747,0),(24497,10,10747,0),(24498,2,10748,0),(24499,10,10748,0),(24500,2,10749,0),(24501,10,10749,0),(24502,2,10750,0),(24503,10,10750,0),(24504,2,10751,0),(24505,10,10751,0),(24506,2,10752,0),(24507,10,10752,0),(24508,2,10753,0),(24509,10,10753,0),(24510,2,10754,0),(24511,10,10754,0),(24512,2,10755,0),(24513,10,10755,0),(24514,2,10756,0),(24515,10,10756,0),(24516,2,10757,0),(24517,10,10757,0),(24518,2,10758,0),(24519,10,10758,0),(24520,2,10759,0),(24521,10,10759,0),(24522,2,10760,0),(24523,10,10760,0),(24524,2,10761,0),(24525,10,10761,0),(24526,2,10762,0),(24527,10,10762,0),(24528,2,10763,0),(24529,10,10763,0),(24530,2,10764,0),(24531,10,10764,0),(24532,2,10765,0),(24533,10,10765,0),(24534,2,10766,0),(24535,10,10766,0),(24536,2,10767,0),(24537,10,10767,0),(24538,2,10768,0),(24539,10,10768,0),(24540,2,10769,0),(24541,10,10769,0),(24542,2,10770,0),(24543,10,10770,0),(24544,2,10771,0),(24545,10,10771,0),(24546,2,10772,0),(24547,10,10772,0),(24548,2,10773,0),(24549,10,10773,0),(24550,2,10774,0),(24551,10,10774,0),(24552,2,10775,0),(24553,10,10775,0),(24554,2,10776,0),(24555,10,10776,0),(24556,2,10777,0),(24557,10,10777,0),(24558,2,10778,0),(24559,10,10778,0),(24560,2,10779,0),(24561,10,10779,0),(24562,2,10780,0),(24563,10,10780,0),(24564,2,10781,0),(24565,10,10781,0),(24566,2,10782,0),(24567,10,10782,0),(24568,2,10783,0),(24569,10,10783,0),(24570,2,10784,0),(24571,10,10784,0),(24572,2,10785,0),(24573,10,10785,0),(24574,2,10786,0),(24575,10,10786,0),(24576,2,10787,0),(24577,10,10787,0),(24578,2,10788,0),(24579,10,10788,0),(24580,2,10789,0),(24581,10,10789,0),(24582,2,10790,0),(24583,10,10790,0),(24584,2,10791,0),(24585,10,10791,0),(24586,2,10792,0),(24587,10,10792,0),(24588,2,10793,0),(24589,10,10793,0),(24590,2,10794,0),(24591,10,10794,0),(24592,2,10795,0),(24593,10,10795,0),(24594,2,10796,0),(24595,10,10796,0),(24596,2,10797,0),(24597,10,10797,0),(24598,2,10798,0),(24599,10,10798,0),(24600,2,10799,0),(24601,10,10799,0),(24602,2,10800,0),(24603,10,10800,0),(24604,2,10801,0),(24605,10,10801,0),(24606,2,10802,0),(24607,10,10802,0),(24608,2,10803,0),(24609,10,10803,0),(24610,2,10804,0),(24611,10,10804,0),(24612,2,10805,0),(24613,10,10805,0),(24614,2,10806,0),(24615,10,10806,0),(24616,2,10807,0),(24617,10,10807,0),(24618,2,10808,0),(24619,10,10808,0),(24620,2,10809,0),(24621,10,10809,0),(24622,2,10810,0),(24623,10,10810,0),(24624,2,10811,0),(24625,10,10811,0),(24626,2,10812,0),(24627,10,10812,0),(24628,2,10813,0),(24629,10,10813,0),(24630,2,10814,0),(24631,10,10814,0),(24632,2,10815,0),(24633,10,10815,0),(24634,2,10816,0),(24635,10,10816,0),(24636,2,10817,0),(24637,10,10817,0),(24638,2,10818,0),(24639,10,10818,0),(24640,2,10819,0),(24641,10,10819,0),(24642,2,10820,0),(24643,10,10820,0),(24644,2,10821,0),(24645,10,10821,0),(24646,2,10822,0),(24647,10,10822,0),(24648,2,10823,0),(24649,10,10823,0),(24650,2,10824,0),(24651,10,10824,0),(24652,2,10825,0),(24653,10,10825,0),(24654,2,10826,0),(24655,10,10826,0),(24656,2,10827,0),(24657,10,10827,0),(24658,2,10828,0),(24659,10,10828,0),(24660,2,10829,0),(24661,10,10829,0),(24662,2,10830,0),(24663,10,10830,0),(24664,2,10831,0),(24665,10,10831,0),(24666,2,10832,0),(24667,10,10832,0),(24668,2,10833,0),(24669,10,10833,0),(24670,2,10834,0),(24671,10,10834,0),(24672,2,10835,0),(24673,10,10835,0),(24674,2,10836,0),(24675,10,10836,0),(24676,2,10837,0),(24677,10,10837,0),(24678,2,10838,0),(24679,10,10838,0),(24680,2,10839,0),(24681,10,10839,0),(24682,2,10840,0),(24683,10,10840,0),(24684,2,10841,0),(24685,10,10841,0),(24686,2,10842,0),(24687,10,10842,0),(24688,2,10843,0),(24689,10,10843,0),(24690,2,10844,0),(24691,10,10844,0),(24692,2,10845,0),(24693,10,10845,0),(24694,2,10846,0),(24695,10,10846,0),(24696,2,10847,0),(24697,10,10847,0),(24698,2,10848,0),(24699,10,10848,0),(24700,2,10849,0),(24701,10,10849,0),(24702,2,10850,0),(24703,10,10850,0),(24704,2,10851,0),(24705,10,10851,0),(24706,2,10852,0),(24707,10,10852,0),(24708,2,10853,0),(24709,10,10853,0),(24710,2,10854,0),(24711,10,10854,0),(24712,2,10855,0),(24713,10,10855,0),(24714,2,10856,0),(24715,10,10856,0),(24716,2,10857,0),(24717,10,10857,0),(24718,2,10858,0),(24719,10,10858,0),(24720,2,10859,0),(24721,10,10859,0),(24722,2,10860,0),(24723,10,10860,0),(24724,2,10861,0),(24725,10,10861,0),(24726,2,10862,0),(24727,10,10862,0),(24728,2,10863,0),(24729,10,10863,0),(24730,2,10864,0),(24731,10,10864,0),(24732,2,10865,0),(24733,10,10865,0),(24734,2,10866,0),(24735,10,10866,0),(24736,2,10867,0),(24737,10,10867,0),(24738,2,10868,0),(24739,10,10868,0),(24740,2,10869,0),(24741,10,10869,0),(24742,2,10870,0),(24743,10,10870,0),(24744,2,10871,0),(24745,10,10871,0),(24746,2,10872,0),(24747,10,10872,0),(24748,2,10873,0),(24749,10,10873,0),(24750,2,10874,0),(24751,10,10874,0),(24752,2,10875,0),(24753,10,10875,0),(24754,2,10876,0),(24755,10,10876,0),(24756,2,10877,0),(24757,10,10877,0),(24758,2,10878,0),(24759,10,10878,0),(24760,2,10879,0),(24761,10,10879,0),(24762,2,10880,0),(24763,10,10880,0),(24764,2,10881,0),(24765,10,10881,0),(24766,2,10882,0),(24767,10,10882,0),(24768,2,10883,0),(24769,10,10883,0),(24770,2,10884,0),(24771,10,10884,0),(24772,2,10885,0),(24773,10,10885,0),(24774,2,10886,0),(24775,10,10886,0),(24776,2,10887,0),(24777,10,10887,0),(24778,2,10888,0),(24779,10,10888,0),(24780,2,10889,0),(24781,10,10889,0),(24782,2,10890,0),(24783,10,10890,0),(24784,2,10891,0),(24785,10,10891,0),(24786,2,10892,0),(24787,10,10892,0),(24788,2,10893,0),(24789,10,10893,0),(24790,2,10894,0),(24791,10,10894,0),(24792,2,10895,0),(24793,10,10895,0),(24794,2,10896,0),(24795,10,10896,0),(24796,2,10897,0),(24797,10,10897,0),(24798,2,10898,0),(24799,10,10898,0),(24800,2,10899,0),(24801,10,10899,0),(24802,2,10900,0),(24803,10,10900,0),(24804,2,10901,0),(24805,10,10901,0),(24806,2,10902,0),(24807,10,10902,0),(24808,2,10903,0),(24809,10,10903,0),(24810,2,10904,0),(24811,10,10904,0),(24812,2,10905,0),(24813,10,10905,0),(24814,2,10906,0),(24815,10,10906,0),(24816,2,10907,0),(24817,10,10907,0),(24818,2,10908,0),(24819,10,10908,0),(24820,2,10909,0),(24821,10,10909,0),(24822,2,10910,0),(24823,10,10910,0),(24824,2,10911,0),(24825,10,10911,0),(24826,2,10912,0),(24827,10,10912,0),(24828,2,10913,0),(24829,10,10913,0),(24830,2,10914,0),(24831,10,10914,0),(24832,2,10915,0),(24833,10,10915,0),(24834,2,10916,0),(24835,10,10916,0),(24836,2,10917,0),(24837,10,10917,0),(24838,2,10918,0),(24839,10,10918,0),(24840,2,10919,0),(24841,10,10919,0),(24842,2,10920,0),(24843,10,10920,0),(24844,2,10921,0),(24845,10,10921,0),(24846,2,10922,0),(24847,10,10922,0),(24848,2,10923,0),(24849,10,10923,0),(24850,2,10924,0),(24851,10,10924,0),(24852,2,10925,0),(24853,10,10925,0),(24854,2,10926,0),(24855,10,10926,0),(24856,2,10927,0),(24857,10,10927,0),(24858,2,10928,0),(24859,10,10928,0),(24860,2,10929,0),(24861,10,10929,0),(24862,2,10930,0),(24863,10,10930,0),(24864,2,10931,0),(24865,10,10931,0),(24866,2,10932,0),(24867,10,10932,0),(24868,2,10933,0),(24869,10,10933,0),(24870,2,10934,0),(24871,10,10934,0),(24872,2,10935,0),(24873,10,10935,0),(24874,2,10936,0),(24875,10,10936,0),(24876,2,10937,0),(24877,10,10937,0),(24878,2,10938,0),(24879,10,10938,0),(24880,2,10939,0),(24881,10,10939,0),(24882,2,10940,0),(24883,10,10940,0),(24884,2,10941,0),(24885,10,10941,0),(24886,2,10942,0),(24887,10,10942,0),(24888,2,10943,0),(24889,10,10943,0),(24890,2,10944,0),(24891,10,10944,0),(24892,2,10945,0),(24893,10,10945,0),(24894,2,10946,0),(24895,10,10946,0),(24896,2,10947,0),(24897,10,10947,0),(24898,2,10948,0),(24899,10,10948,0),(24900,2,10949,0),(24901,10,10949,0),(24902,2,10950,0),(24903,10,10950,0),(24904,2,10951,0),(24905,10,10951,0),(24906,2,10952,0),(24907,10,10952,0),(24908,2,10953,0),(24909,10,10953,0),(24910,2,10954,0),(24911,10,10954,0),(24912,2,10955,0),(24913,10,10955,0),(24914,2,10956,0),(24915,10,10956,0),(24916,2,10957,0),(24917,10,10957,0),(24918,2,10958,0),(24919,10,10958,0),(24920,2,10959,0),(24921,10,10959,0),(24922,2,10960,0),(24923,10,10960,0),(24924,2,10961,0),(24925,10,10961,0),(24926,2,10962,0),(24927,10,10962,0),(24928,2,10963,0),(24929,10,10963,0),(24930,2,10964,0),(24931,10,10964,0),(24932,2,10965,0),(24933,10,10965,0),(24934,2,10966,0),(24935,10,10966,0),(24936,2,10967,0),(24937,10,10967,0),(24938,2,10968,0),(24939,10,10968,0),(24940,2,10969,0),(24941,10,10969,0),(24942,2,10970,0),(24943,10,10970,0),(24944,2,10971,0),(24945,10,10971,0),(24946,2,10972,0),(24947,10,10972,0),(24948,2,10973,0),(24949,10,10973,0),(24950,2,10974,0),(24951,10,10974,0),(24952,2,10975,0),(24953,10,10975,0),(24954,2,10976,0),(24955,10,10976,0),(24956,2,10977,0),(24957,10,10977,0),(24958,2,10978,0),(24959,10,10978,0),(24960,2,10979,0),(24961,10,10979,0),(24962,2,10980,0),(24963,10,10980,0),(24964,2,10981,0),(24965,10,10981,0),(24966,2,10982,0),(24967,10,10982,0),(24968,2,10983,0),(24969,10,10983,0),(24970,2,10984,0),(24971,10,10984,0),(24972,2,10985,0),(24973,10,10985,0),(24974,2,10986,0),(24975,10,10986,0),(24976,2,10987,0),(24977,10,10987,0),(24978,2,10988,0),(24979,10,10988,0),(24980,2,10989,0),(24981,10,10989,0),(24982,2,10990,0),(24983,10,10990,0),(24984,2,10991,0),(24985,10,10991,0),(24986,2,10992,0),(24987,10,10992,0),(24988,2,10993,0),(24989,10,10993,0),(24990,2,10994,0),(24991,10,10994,0),(24992,2,10995,0),(24993,10,10995,0),(24994,2,10996,0),(24995,10,10996,0),(24996,2,10997,0),(24997,10,10997,0),(24998,2,10998,0),(24999,10,10998,0),(25000,2,10999,0),(25001,10,10999,0),(25002,2,11000,0),(25003,10,11000,0),(25004,2,11001,0),(25005,10,11001,0),(25006,2,11002,0),(25007,10,11002,0),(25008,2,11003,0),(25009,10,11003,0),(25010,2,11004,0),(25011,10,11004,0),(25012,2,11005,0),(25013,10,11005,0),(25014,2,11006,0),(25015,10,11006,0),(25016,2,11007,0),(25017,10,11007,0),(25018,2,11008,0),(25019,10,11008,0),(25020,2,11009,0),(25021,10,11009,0),(25022,2,11010,0),(25023,10,11010,0),(25024,2,11011,0),(25025,10,11011,0),(25026,2,11012,0),(25027,10,11012,0),(25028,2,11013,0),(25029,10,11013,0),(25030,2,11014,0),(25031,10,11014,0),(25032,2,11015,0),(25033,10,11015,0),(25034,2,11016,0),(25035,10,11016,0),(25036,2,11017,0),(25037,10,11017,0),(25038,2,11018,0),(25039,10,11018,0),(25040,2,11019,0),(25041,10,11019,0),(25042,2,11020,0),(25043,10,11020,0),(25044,2,11021,0),(25045,10,11021,0),(25046,2,11022,0),(25047,10,11022,0),(25048,2,11023,0),(25049,10,11023,0),(25050,2,11024,0),(25051,10,11024,0),(25052,2,11025,0),(25053,10,11025,0),(25054,2,11026,0),(25055,10,11026,0),(25056,2,11027,0),(25057,10,11027,0),(25058,2,11028,0),(25059,10,11028,0),(25060,2,11029,0),(25061,10,11029,0),(25062,2,11030,0),(25063,10,11030,0),(25064,2,11031,0),(25065,10,11031,0),(25066,2,11032,0),(25067,10,11032,0),(25068,2,11033,0),(25069,10,11033,0),(25070,2,11034,0),(25071,10,11034,0),(25072,2,11035,0),(25073,10,11035,0),(25074,2,11036,0),(25075,10,11036,0),(25076,2,11037,0),(25077,10,11037,0),(25078,2,11038,0),(25079,10,11038,0),(25080,2,11039,0),(25081,10,11039,0),(25082,2,11040,0),(25083,10,11040,0),(25084,2,11041,0),(25085,10,11041,0),(25086,2,11042,0),(25087,10,11042,0),(25088,2,11043,0),(25089,10,11043,0),(25090,2,11044,0),(25091,10,11044,0),(25092,2,11045,0),(25093,10,11045,0),(25094,2,11046,0),(25095,10,11046,0),(25096,2,11047,0),(25097,10,11047,0),(25098,2,11048,0),(25099,10,11048,0),(25100,2,11049,0),(25101,10,11049,0),(25102,2,11050,0),(25103,10,11050,0),(25104,2,11051,0),(25105,10,11051,0),(25106,2,11052,0),(25107,10,11052,0),(25108,2,11053,0),(25109,10,11053,0),(25110,2,11054,0),(25111,10,11054,0),(25112,2,11055,0),(25113,10,11055,0),(25114,2,11056,0),(25115,10,11056,0),(25116,2,11057,0),(25117,10,11057,0),(25118,2,11058,0),(25119,10,11058,0),(25120,2,11059,0),(25121,10,11059,0),(25122,2,11060,0),(25123,10,11060,0),(25124,2,11061,0),(25125,10,11061,0),(25126,2,11062,0),(25127,10,11062,0),(25128,2,11063,0),(25129,10,11063,0),(25130,2,11064,0),(25131,10,11064,0),(25132,2,11065,0),(25133,10,11065,0),(25134,2,11066,0),(25135,10,11066,0),(25136,2,11067,0),(25137,10,11067,0),(25138,2,11068,0),(25139,10,11068,0),(25140,2,11069,0),(25141,10,11069,0),(25142,2,11070,0),(25143,10,11070,0),(25144,2,11071,0),(25145,10,11071,0),(25146,2,11072,0),(25147,10,11072,0),(25148,2,11073,0),(25149,10,11073,0),(25150,2,11074,0),(25151,10,11074,0),(25152,2,11075,0),(25153,10,11075,0),(25154,2,11076,0),(25155,10,11076,0),(25156,2,11077,0),(25157,10,11077,0),(25158,2,11078,0),(25159,10,11078,0),(25160,2,11079,0),(25161,10,11079,0),(25162,2,11080,0),(25163,10,11080,0),(25164,2,11081,0),(25165,10,11081,0),(25166,2,11082,0),(25167,10,11082,0),(25168,2,11083,0),(25169,10,11083,0),(25170,2,11084,0),(25171,10,11084,0),(25172,2,11085,0),(25173,10,11085,0),(25174,2,11086,0),(25175,10,11086,0),(25176,2,11087,0),(25177,10,11087,0),(25178,2,11088,0),(25179,10,11088,0),(25180,2,11089,0),(25181,10,11089,0),(25182,2,11090,0),(25183,10,11090,0),(25184,2,11091,0),(25185,10,11091,0),(25186,2,11092,0),(25187,10,11092,0),(25188,2,11093,0),(25189,10,11093,0),(25190,2,11094,0),(25191,10,11094,0),(25192,2,11095,0),(25193,10,11095,0),(25194,2,11096,0),(25195,10,11096,0),(25196,2,11097,0),(25197,10,11097,0),(25198,2,11098,0),(25199,10,11098,0),(25200,2,11099,0),(25201,10,11099,0),(25202,2,11100,0),(25203,10,11100,0),(25204,2,11101,0),(25205,10,11101,0),(25206,2,11102,0),(25207,10,11102,0),(25208,2,11103,0),(25209,10,11103,0),(25210,2,11104,0),(25211,10,11104,0),(25212,2,11105,0),(25213,10,11105,0),(25214,2,11106,0),(25215,10,11106,0),(25216,2,11107,0),(25217,10,11107,0),(25218,2,11108,0),(25219,10,11108,0),(25220,2,11109,0),(25221,10,11109,0),(25222,2,11110,0),(25223,10,11110,0),(25224,2,11111,0),(25225,10,11111,0),(25226,2,11112,0),(25227,10,11112,0),(25228,2,11113,0),(25229,10,11113,0),(25230,2,11114,0),(25231,10,11114,0),(25232,2,11115,0),(25233,10,11115,0),(25234,2,11116,0),(25235,10,11116,0),(25236,2,11117,0),(25237,10,11117,0),(25238,2,11118,0),(25239,10,11118,0),(25240,2,11119,0),(25241,10,11119,0),(25242,2,11120,0),(25243,10,11120,0),(25244,2,11121,0),(25245,10,11121,0),(25246,2,11122,0),(25247,10,11122,0),(25248,2,11123,0),(25249,10,11123,0),(25250,2,11124,0),(25251,10,11124,0),(25252,2,11125,0),(25253,10,11125,0),(25254,2,11126,0),(25255,10,11126,0),(25256,2,11127,0),(25257,10,11127,0),(25258,2,11128,0),(25259,10,11128,0),(25260,2,11129,0),(25261,10,11129,0),(25262,2,11130,0),(25263,10,11130,0),(25264,2,11131,0),(25265,10,11131,0),(25266,2,11132,0),(25267,10,11132,0),(25268,2,11133,0),(25269,10,11133,0),(25270,2,11134,0),(25271,10,11134,0),(25272,2,11135,0),(25273,10,11135,0),(25274,2,11136,0),(25275,10,11136,0),(25276,2,11137,0),(25277,10,11137,0),(25278,2,11138,0),(25279,10,11138,0),(25280,2,11139,0),(25281,10,11139,0),(25282,2,11140,0),(25283,10,11140,0),(25284,2,11141,0),(25285,10,11141,0),(25286,2,11142,0),(25287,10,11142,0),(25288,2,11143,0),(25289,10,11143,0),(25290,2,11144,0),(25291,10,11144,0),(25292,2,11145,0),(25293,10,11145,0),(25294,2,11146,0),(25295,10,11146,0),(25296,2,11147,0),(25297,10,11147,0),(25298,2,11148,0),(25299,10,11148,0),(25300,2,11149,0),(25301,10,11149,0),(25302,2,11150,0),(25303,10,11150,0),(25304,2,11151,0),(25305,10,11151,0),(25306,2,11152,0),(25307,10,11152,0),(25308,2,11153,0),(25309,10,11153,0),(25310,2,11154,0),(25311,10,11154,0),(25312,2,11155,0),(25313,10,11155,0),(25314,2,11156,0),(25315,10,11156,0),(25316,2,11157,0),(25317,10,11157,0),(25318,2,11158,0),(25319,10,11158,0),(25320,2,11159,0),(25321,10,11159,0),(25322,2,11160,0),(25323,10,11160,0),(25324,2,11161,0),(25325,10,11161,0),(25326,2,11162,0),(25327,10,11162,0),(25328,2,11163,0),(25329,10,11163,0),(25330,2,11164,0),(25331,10,11164,0),(25332,2,11165,0),(25333,10,11165,0),(25334,2,11166,0),(25335,10,11166,0),(25336,2,11167,0),(25337,10,11167,0),(25338,2,11168,0),(25339,10,11168,0),(25340,2,11169,0),(25341,10,11169,0),(25342,2,11170,0),(25343,10,11170,0),(25344,2,11171,0),(25345,10,11171,0),(25346,2,11172,0),(25347,10,11172,0),(25348,2,11173,0),(25349,10,11173,0),(25350,2,11174,0),(25351,10,11174,0),(25352,2,11175,0),(25353,10,11175,0),(25354,2,11176,0),(25355,10,11176,0),(25356,2,11177,0),(25357,10,11177,0),(25358,2,11178,0),(25359,10,11178,0),(25360,2,11179,0),(25361,10,11179,0),(25362,2,11180,0),(25363,10,11180,0),(25364,2,11181,0),(25365,10,11181,0),(25366,2,11182,0),(25367,10,11182,0),(25368,2,11183,0),(25369,10,11183,0),(25370,2,11184,0),(25371,10,11184,0),(25372,2,11185,0),(25373,10,11185,0),(25374,2,11186,0),(25375,10,11186,0),(25376,2,11187,0),(25377,10,11187,0),(25378,2,11188,0),(25379,10,11188,0),(25380,2,11189,0),(25381,10,11189,0),(25382,2,11190,0),(25383,10,11190,0),(25384,2,11191,0),(25385,10,11191,0),(25386,2,11192,0),(25387,10,11192,0),(25388,2,11193,0),(25389,10,11193,0),(25390,2,11194,0),(25391,10,11194,0),(25392,2,11195,0),(25393,10,11195,0),(25394,2,11196,0),(25395,10,11196,0),(25396,2,11197,0),(25397,10,11197,0),(25398,2,11198,0),(25399,10,11198,0),(25400,2,11199,0),(25401,10,11199,0),(25402,2,11200,0),(25403,10,11200,0),(25404,2,11201,0),(25405,10,11201,0),(25406,2,11202,0),(25407,10,11202,0),(25408,2,11203,0),(25409,10,11203,0),(25410,2,11204,0),(25411,10,11204,0),(25412,2,11205,0),(25413,10,11205,0),(25414,2,11206,0),(25415,10,11206,0),(25416,2,11207,0),(25417,10,11207,0),(25418,2,11208,0),(25419,10,11208,0),(25420,2,11209,0),(25421,10,11209,0),(25422,2,11210,0),(25423,10,11210,0),(25424,2,11211,0),(25425,10,11211,0),(25426,2,11212,0),(25427,10,11212,0),(25428,2,11213,0),(25429,10,11213,0),(25430,2,11214,0),(25431,10,11214,0),(25432,2,11215,0),(25433,10,11215,0),(25434,2,11216,0),(25435,10,11216,0),(25436,2,11217,0),(25437,10,11217,0),(25438,2,11218,0),(25439,10,11218,0),(25440,2,11219,0),(25441,10,11219,0),(25442,2,11220,0),(25443,10,11220,0),(25444,2,11221,0),(25445,10,11221,0),(25446,2,11222,0),(25447,10,11222,0),(25448,2,11223,0),(25449,10,11223,0),(25450,2,11224,0),(25451,10,11224,0),(25452,2,11225,0),(25453,10,11225,0),(25454,2,11226,0),(25455,10,11226,0),(25456,2,11227,0),(25457,10,11227,0),(25458,2,11228,0),(25459,10,11228,0),(25460,2,11229,0),(25461,10,11229,0),(25462,2,11230,0),(25463,10,11230,0),(25464,2,11231,0),(25465,10,11231,0),(25466,2,11232,0),(25467,10,11232,0),(25468,2,11233,0),(25469,10,11233,0),(25470,2,11234,0),(25471,10,11234,0),(25472,2,11235,0),(25473,10,11235,0),(25474,2,11236,0),(25475,10,11236,0),(25476,2,11237,0),(25477,10,11237,0),(25478,2,11238,0),(25479,10,11238,0),(25480,2,11239,0),(25481,10,11239,0),(25482,2,11240,0),(25483,10,11240,0),(25484,2,11241,0),(25485,10,11241,0),(25486,2,11242,0),(25487,10,11242,0),(25488,2,11243,0),(25489,10,11243,0),(25490,2,11244,0),(25491,10,11244,0),(25492,2,11245,0),(25493,10,11245,0),(25494,2,11246,0),(25495,10,11246,0),(25496,2,11247,0),(25497,10,11247,0),(25498,2,11248,0),(25499,10,11248,0),(25500,2,11249,0),(25501,10,11249,0),(25502,2,11250,0),(25503,10,11250,0),(25504,2,11251,0),(25505,10,11251,0),(25506,2,11252,0),(25507,10,11252,0),(25508,2,11253,0),(25509,10,11253,0),(25510,2,11254,0),(25511,10,11254,0),(25512,2,11255,0),(25513,10,11255,0),(25514,2,11256,0),(25515,10,11256,0),(25516,2,11257,0),(25517,10,11257,0),(25518,2,11258,0),(25519,10,11258,0),(25520,2,11259,0),(25521,10,11259,0),(25522,2,11260,0),(25523,10,11260,0),(25524,2,11261,0),(25525,10,11261,0),(25526,2,11262,0),(25527,10,11262,0),(25528,2,11263,0),(25529,10,11263,0),(25530,2,11264,0),(25531,10,11264,0),(25532,2,11265,0),(25533,10,11265,0),(25534,2,11266,0),(25535,10,11266,0),(25536,2,11267,0),(25537,10,11267,0),(25538,2,11268,0),(25539,10,11268,0),(25540,2,11269,0),(25541,10,11269,0),(25542,2,11270,0),(25543,10,11270,0),(25544,2,11271,0),(25545,10,11271,0),(25546,2,11272,0),(25547,10,11272,0),(25548,2,11273,0),(25549,10,11273,0),(25550,2,11274,0),(25551,10,11274,0),(25552,2,11275,0),(25553,10,11275,0),(25554,2,11276,0),(25555,10,11276,0),(25556,2,11277,0),(25557,10,11277,0),(25558,2,11278,0),(25559,10,11278,0),(25560,2,11279,0),(25561,10,11279,0),(25562,2,11280,0),(25563,10,11280,0),(25564,2,11281,0),(25565,10,11281,0),(25566,2,11282,0),(25567,10,11282,0),(25568,2,11283,0),(25569,10,11283,0),(25570,2,11284,0),(25571,10,11284,0),(25572,2,11285,0),(25573,10,11285,0),(25574,2,11286,0),(25575,10,11286,0),(25576,2,11287,0),(25577,10,11287,0),(25578,2,11288,0),(25579,10,11288,0),(25580,2,11289,0),(25581,10,11289,0),(25582,2,11290,0),(25583,10,11290,0),(25584,2,11291,0),(25585,10,11291,0),(25586,2,11292,0),(25587,10,11292,0),(25588,2,11293,0),(25589,10,11293,0),(25590,2,11294,0),(25591,10,11294,0),(25592,2,11295,0),(25593,10,11295,0),(25594,2,11296,0),(25595,10,11296,0),(25596,2,11297,0),(25597,10,11297,0),(25598,2,11298,0),(25599,10,11298,0),(25600,2,11299,0),(25601,10,11299,0),(25602,2,11300,0),(25603,10,11300,0),(25604,2,11301,0),(25605,10,11301,0),(25606,2,11302,0),(25607,10,11302,0),(25608,2,11303,0),(25609,10,11303,0),(25610,2,11304,0),(25611,10,11304,0),(25612,2,11305,0),(25613,10,11305,0),(25614,2,11306,0),(25615,10,11306,0),(25616,2,11307,0),(25617,10,11307,0),(25618,2,11308,0),(25619,10,11308,0),(25620,2,11309,0),(25621,10,11309,0),(25622,2,11310,0),(25623,10,11310,0),(25624,2,11311,0),(25625,10,11311,0),(25626,2,11312,0),(25627,10,11312,0),(25628,2,11313,0),(25629,10,11313,0),(25630,2,11314,0),(25631,10,11314,0),(25632,2,11315,0),(25633,10,11315,0),(25634,2,11316,0),(25635,10,11316,0),(25636,2,11317,0),(25637,10,11317,0),(25638,2,11318,0),(25639,10,11318,0),(25640,2,11319,0),(25641,10,11319,0),(25642,2,11320,0),(25643,10,11320,0),(25644,2,11321,0),(25645,10,11321,0),(25646,2,11322,0),(25647,10,11322,0),(25648,2,11323,0),(25649,10,11323,0),(25650,2,11324,0),(25651,10,11324,0),(25652,2,11325,0),(25653,10,11325,0),(25654,2,11326,0),(25655,10,11326,0),(25656,2,11327,0),(25657,10,11327,0),(25658,2,11328,0),(25659,10,11328,0),(25660,2,11329,0),(25661,10,11329,0),(25662,2,11330,0),(25663,10,11330,0),(25664,2,11331,0),(25665,10,11331,0),(25666,2,11332,0),(25667,10,11332,0),(25668,2,11333,0),(25669,10,11333,0),(25670,2,11334,0),(25671,10,11334,0),(25672,2,11335,0),(25673,10,11335,0),(25674,2,11336,0),(25675,10,11336,0),(25676,2,11337,0),(25677,10,11337,0),(25678,2,11338,0),(25679,10,11338,0),(25680,2,11339,0),(25681,10,11339,0),(25682,2,11340,0),(25683,10,11340,0),(25684,2,11341,0),(25685,10,11341,0),(25686,2,11342,0),(25687,10,11342,0),(25688,2,11343,0),(25689,10,11343,0),(25690,2,11344,0),(25691,10,11344,0),(25692,2,11345,0),(25693,10,11345,0),(25694,2,11346,0),(25695,10,11346,0),(25696,2,11347,0),(25697,10,11347,0),(25698,2,11348,0),(25699,10,11348,0),(25700,2,11349,0),(25701,10,11349,0),(25702,2,11350,0),(25703,10,11350,0),(25704,2,11351,0),(25705,10,11351,0),(25706,2,11352,0),(25707,10,11352,0),(25708,2,11353,0),(25709,10,11353,0),(25710,2,11354,0),(25711,10,11354,0),(25712,2,11355,0),(25713,10,11355,0),(25714,2,11356,0),(25715,10,11356,0),(25716,2,11357,0),(25717,10,11357,0),(25718,2,11358,0),(25719,10,11358,0),(25720,2,11359,0),(25721,10,11359,0),(25722,2,11360,0),(25723,10,11360,0),(25724,2,11361,0),(25725,10,11361,0),(25726,2,11362,0),(25727,10,11362,0),(25728,2,11363,0),(25729,10,11363,0),(25730,2,11364,0),(25731,10,11364,0),(25732,2,11365,0),(25733,10,11365,0),(25734,2,11366,0),(25735,10,11366,0),(25736,2,11367,0),(25737,10,11367,0),(25738,2,11368,0),(25739,10,11368,0),(25740,2,11369,0),(25741,10,11369,0),(25742,2,11370,0),(25743,10,11370,0),(25744,2,11371,0),(25745,10,11371,0),(25746,2,11372,0),(25747,10,11372,0),(25748,2,11373,0),(25749,10,11373,0),(25750,2,11374,0),(25751,10,11374,0),(25752,2,11375,0),(25753,10,11375,0),(25754,2,11376,0),(25755,10,11376,0),(25756,2,11377,0),(25757,10,11377,0),(25758,2,11378,0),(25759,10,11378,0),(25760,2,11379,0),(25761,10,11379,0),(25762,2,11380,0),(25763,10,11380,0),(25764,2,11381,0),(25765,10,11381,0),(25766,2,11382,0),(25767,10,11382,0),(25768,2,11383,0),(25769,10,11383,0),(25770,2,11384,0),(25771,10,11384,0),(25772,2,11385,0),(25773,10,11385,0),(25774,2,11386,0),(25775,10,11386,0),(25776,2,11387,0),(25777,10,11387,0),(25778,2,11388,0),(25779,10,11388,0),(25780,2,11389,0),(25781,10,11389,0),(25782,2,11390,0),(25783,10,11390,0),(25784,2,11391,0),(25785,10,11391,0),(25786,2,11392,0),(25787,10,11392,0),(25788,2,11393,0),(25789,10,11393,0),(25790,2,11394,0),(25791,10,11394,0),(25792,2,11395,0),(25793,10,11395,0),(25794,2,11396,0),(25795,10,11396,0),(25796,2,11397,0),(25797,10,11397,0),(25798,2,11398,0),(25799,10,11398,0),(25800,2,11399,0),(25801,10,11399,0),(25802,2,11400,0),(25803,10,11400,0),(25804,2,11401,0),(25805,10,11401,0),(25806,2,11402,0),(25807,10,11402,0),(25808,2,11403,0),(25809,10,11403,0),(25810,2,11404,0),(25811,10,11404,0),(25812,2,11405,0),(25813,10,11405,0),(25814,2,11406,0),(25815,10,11406,0),(25816,2,11407,0),(25817,10,11407,0),(25818,2,11408,0),(25819,10,11408,0),(25820,2,11409,0),(25821,10,11409,0),(25822,2,11410,0),(25823,10,11410,0),(25824,2,11411,0),(25825,10,11411,0),(25826,2,11412,0),(25827,10,11412,0),(25828,2,11413,0),(25829,10,11413,0),(25830,2,11414,0),(25831,10,11414,0),(25832,2,11415,0),(25833,10,11415,0),(25834,2,11416,0),(25835,10,11416,0),(25836,2,11417,0),(25837,10,11417,0),(25838,2,11418,0),(25839,10,11418,0),(25840,2,11419,0),(25841,10,11419,0),(25842,2,11420,0),(25843,10,11420,0),(25844,2,11421,0),(25845,10,11421,0),(25846,2,11422,0),(25847,10,11422,0),(25848,2,11423,0),(25849,10,11423,0),(25850,2,11424,0),(25851,10,11424,0),(25852,2,11425,0),(25853,10,11425,0),(25854,2,11426,0),(25855,10,11426,0),(25856,2,11427,0),(25857,10,11427,0),(25858,2,11428,0),(25859,10,11428,0),(25860,2,11429,0),(25861,10,11429,0),(25862,2,11430,0),(25863,10,11430,0),(25864,2,11431,0),(25865,10,11431,0),(25866,2,11432,0),(25867,10,11432,0),(25868,2,11433,0),(25869,10,11433,0),(25870,2,11434,0),(25871,10,11434,0),(25872,2,11435,0),(25873,10,11435,0),(25874,2,11436,0),(25875,10,11436,0),(25876,2,11437,0),(25877,10,11437,0),(25878,2,11438,0),(25879,10,11438,0),(25880,2,11439,0),(25881,10,11439,0),(25882,2,11440,0),(25883,10,11440,0),(25884,2,11441,0),(25885,10,11441,0),(25886,2,11442,0),(25887,10,11442,0),(25888,2,11443,0),(25889,10,11443,0),(25890,2,11444,0),(25891,10,11444,0),(25892,2,11445,0),(25893,10,11445,0),(25894,2,11446,0),(25895,10,11446,0),(25896,2,11447,0),(25897,10,11447,0),(25898,2,11448,0),(25899,10,11448,0),(25900,2,11449,0),(25901,10,11449,0),(25902,2,11450,0),(25903,10,11450,0),(25904,2,11451,0),(25905,10,11451,0),(25906,2,11452,0),(25907,10,11452,0),(25908,2,11453,0),(25909,10,11453,0),(25910,2,11454,0),(25911,10,11454,0),(25912,2,11455,0),(25913,10,11455,0),(25914,2,11456,0),(25915,10,11456,0),(25916,2,11457,0),(25917,10,11457,0),(25918,2,11458,0),(25919,10,11458,0),(25920,2,11459,0),(25921,10,11459,0),(25922,2,11460,0),(25923,10,11460,0),(25924,2,11461,0),(25925,10,11461,0),(25926,2,11462,0),(25927,10,11462,0),(25928,2,11463,0),(25929,10,11463,0),(25930,2,11464,0),(25931,10,11464,0),(25932,2,11465,0),(25933,10,11465,0),(25934,2,11466,0),(25935,10,11466,0),(25936,2,11467,0),(25937,10,11467,0),(25938,2,11468,0),(25939,10,11468,0),(25940,2,11469,0),(25941,10,11469,0),(25942,2,11470,0),(25943,10,11470,0),(25944,2,11471,0),(25945,10,11471,0),(25946,2,11472,0),(25947,10,11472,0),(25948,2,11473,0),(25949,10,11473,0),(25950,2,11474,0),(25951,10,11474,0),(25952,2,11475,0),(25953,10,11475,0),(25954,2,11476,0),(25955,10,11476,0),(25956,2,11477,0),(25957,10,11477,0),(25958,2,11478,0),(25959,10,11478,0),(25960,2,11479,0),(25961,10,11479,0),(25962,2,11480,0),(25963,10,11480,0),(25964,2,11481,0),(25965,10,11481,0),(25966,2,11482,0),(25967,10,11482,0),(25968,2,11483,0),(25969,10,11483,0),(25970,2,11484,0),(25971,10,11484,0),(25972,2,11485,0),(25973,10,11485,0),(25974,2,11486,0),(25975,10,11486,0),(25976,2,11487,0),(25977,10,11487,0),(25978,2,11488,0),(25979,10,11488,0),(25980,2,11489,0),(25981,10,11489,0),(25982,2,11490,0),(25983,10,11490,0),(25984,2,11491,0),(25985,10,11491,0),(25986,2,11492,0),(25987,10,11492,0),(25988,2,11493,0),(25989,10,11493,0),(25990,2,11494,0),(25991,10,11494,0),(25992,2,11495,0),(25993,10,11495,0),(25994,2,11496,0),(25995,10,11496,0),(25996,2,11497,0),(25997,10,11497,0),(25998,2,11498,0),(25999,10,11498,0),(26000,2,11499,0),(26001,10,11499,0),(26002,2,11500,0),(26003,10,11500,0),(26004,2,11501,0),(26005,10,11501,0),(26006,2,11502,0),(26007,10,11502,0),(26008,2,11503,0),(26009,10,11503,0),(26010,2,11504,0),(26011,10,11504,0),(26012,2,11505,0),(26013,10,11505,0),(26014,2,11506,0),(26015,10,11506,0),(26016,2,11507,0),(26017,10,11507,0),(26018,2,11508,0),(26019,10,11508,0),(26020,2,11509,0),(26021,10,11509,0),(26022,2,11510,0),(26023,10,11510,0),(26024,2,11511,0),(26025,10,11511,0),(26026,2,11512,0),(26027,10,11512,0),(26028,2,11513,0),(26029,10,11513,0),(26030,2,11514,0),(26031,10,11514,0),(26032,2,11515,0),(26033,10,11515,0),(26034,2,11516,0),(26035,10,11516,0),(26036,2,11517,0),(26037,10,11517,0),(26038,2,11518,0),(26039,10,11518,0),(26040,2,11519,0),(26041,10,11519,0),(26042,2,11520,0),(26043,10,11520,0),(26044,2,11521,0),(26045,10,11521,0),(26046,2,11522,0),(26047,10,11522,0),(26048,2,11523,0),(26049,10,11523,0),(26050,2,11524,0),(26051,10,11524,0),(26052,2,11525,0),(26053,10,11525,0),(26054,2,11526,0),(26055,10,11526,0),(26056,2,11527,0),(26057,10,11527,0),(26058,2,11528,0),(26059,10,11528,0),(26060,2,11529,0),(26061,10,11529,0),(26062,2,11530,0),(26063,10,11530,0),(26064,2,11531,0),(26065,10,11531,0),(26066,2,11532,0),(26067,10,11532,0),(26068,2,11533,0),(26069,10,11533,0),(26070,2,11534,0),(26071,10,11534,0),(26072,2,11535,0),(26073,10,11535,0),(26074,2,11536,0),(26075,10,11536,0),(26076,2,11537,0),(26077,10,11537,0),(26078,2,11538,0),(26079,10,11538,0),(26080,2,11539,0),(26081,10,11539,0),(26082,2,11540,0),(26083,10,11540,0),(26084,2,11541,0),(26085,10,11541,0),(26086,2,11542,0),(26087,10,11542,0),(26088,2,11543,0),(26089,10,11543,0),(26090,2,11544,0),(26091,10,11544,0),(26092,2,11545,0),(26093,10,11545,0),(26094,2,11546,0),(26095,10,11546,0),(26096,2,11547,0),(26097,10,11547,0),(26098,2,11548,0),(26099,10,11548,0),(26100,2,11549,0),(26101,10,11549,0),(26102,2,11550,0),(26103,10,11550,0),(26104,2,11551,0),(26105,10,11551,0),(26106,2,11552,0),(26107,10,11552,0),(26108,2,11553,0),(26109,10,11553,0),(26110,2,11554,0),(26111,10,11554,0),(26112,2,11555,0),(26113,10,11555,0),(26114,2,11556,0),(26115,10,11556,0),(26116,2,11557,0),(26117,10,11557,0),(26118,2,11558,0),(26119,10,11558,0),(26120,2,11559,0),(26121,10,11559,0),(26122,2,11560,0),(26123,10,11560,0),(26124,2,11561,0),(26125,10,11561,0),(26126,2,11562,0),(26127,10,11562,0),(26128,2,11563,0),(26129,10,11563,0),(26130,2,11564,0),(26131,10,11564,0),(26132,2,11565,0),(26133,10,11565,0),(26134,2,11566,0),(26135,10,11566,0),(26136,2,11567,0),(26137,10,11567,0),(26138,2,11568,0),(26139,10,11568,0),(26140,2,11569,0),(26141,10,11569,0),(26142,2,11570,0),(26143,10,11570,0),(26144,2,11571,0),(26145,10,11571,0),(26146,2,11572,0),(26147,10,11572,0),(26148,2,11573,0),(26149,10,11573,0),(26150,2,11574,0),(26151,10,11574,0),(26152,2,11575,0),(26153,10,11575,0),(26154,2,11576,0),(26155,10,11576,0),(26156,2,11577,0),(26157,10,11577,0),(26158,2,11578,0),(26159,10,11578,0),(26160,2,11579,0),(26161,10,11579,0),(26162,2,11580,0),(26163,10,11580,0),(26164,2,11581,0),(26165,10,11581,0),(26166,2,11582,0),(26167,10,11582,0),(26168,2,11583,0),(26169,10,11583,0),(26170,2,11584,0),(26171,10,11584,0),(26172,2,11585,0),(26173,10,11585,0),(26174,2,11586,0),(26175,10,11586,0),(26176,2,11587,0),(26177,10,11587,0),(26178,2,11588,0),(26179,10,11588,0),(26180,2,11589,0),(26181,10,11589,0),(26182,2,11590,0),(26183,10,11590,0),(26184,2,11591,0),(26185,10,11591,0),(26186,2,11592,0),(26187,10,11592,0),(26188,2,11593,0),(26189,10,11593,0),(26190,2,11594,0),(26191,10,11594,0),(26192,2,11595,0),(26193,10,11595,0),(26194,2,11596,0),(26195,10,11596,0),(26196,2,11597,0),(26197,10,11597,0),(26198,2,11598,0),(26199,10,11598,0),(26200,2,11599,0),(26201,10,11599,0),(26202,2,11600,0),(26203,10,11600,0),(26204,2,11601,0),(26205,10,11601,0),(26206,2,11602,0),(26207,10,11602,0),(26208,2,11603,0),(26209,10,11603,0),(26210,2,11604,0),(26211,10,11604,0),(26212,2,11605,0),(26213,10,11605,0),(26214,2,11606,0),(26215,10,11606,0),(26216,2,11607,0),(26217,10,11607,0),(26218,2,11608,0),(26219,10,11608,0),(26220,2,11609,0),(26221,10,11609,0),(26222,2,11610,0),(26223,10,11610,0),(26224,2,11611,0),(26225,10,11611,0),(26226,2,11612,0),(26227,10,11612,0),(26228,2,11613,0),(26229,10,11613,0),(26230,2,11614,0),(26231,10,11614,0),(26232,2,11615,0),(26233,10,11615,0),(26234,2,11616,0),(26235,10,11616,0),(26236,2,11617,0),(26237,10,11617,0),(26238,2,11618,0),(26239,10,11618,0),(26240,2,11619,0),(26241,10,11619,0),(26242,2,11620,0),(26243,10,11620,0),(26244,2,11621,0),(26245,10,11621,0),(26246,2,11622,0),(26247,10,11622,0),(26248,2,11623,0),(26249,10,11623,0),(26250,2,11624,0),(26251,10,11624,0),(26252,2,11625,0),(26253,10,11625,0),(26254,2,11626,0),(26255,10,11626,0),(26256,2,11627,0),(26257,10,11627,0),(26258,2,11628,0),(26259,10,11628,0),(26260,2,11629,0),(26261,10,11629,0),(26262,2,11630,0),(26263,10,11630,0),(26264,2,11631,0),(26265,10,11631,0),(26266,2,11632,0),(26267,10,11632,0),(26268,2,11633,0),(26269,10,11633,0),(26270,2,11634,0),(26271,10,11634,0),(26272,2,11635,0),(26273,10,11635,0),(26274,2,11636,0),(26275,10,11636,0),(26276,2,11637,0),(26277,10,11637,0),(26278,2,11638,0),(26279,10,11638,0),(26280,2,11639,0),(26281,10,11639,0),(26282,2,11640,0),(26283,10,11640,0),(26284,2,11641,0),(26285,10,11641,0),(26286,2,11642,0),(26287,10,11642,0),(26288,2,11643,0),(26289,10,11643,0),(26290,2,11644,0),(26291,10,11644,0),(26292,2,11645,0),(26293,10,11645,0),(26294,2,11646,0),(26295,10,11646,0),(26296,2,11647,0),(26297,10,11647,0),(26298,2,11648,0),(26299,10,11648,0),(26300,2,11649,0),(26301,10,11649,0),(26302,2,11650,0),(26303,10,11650,0),(26304,2,11651,0),(26305,10,11651,0),(26306,2,11652,0),(26307,10,11652,0),(26308,2,11653,0),(26309,10,11653,0),(26310,2,11654,0),(26311,10,11654,0),(26312,2,11655,0),(26313,10,11655,0),(26314,2,11656,0),(26315,10,11656,0),(26316,2,11657,0),(26317,10,11657,0),(26318,2,11658,0),(26319,10,11658,0),(26320,2,11659,0),(26321,10,11659,0),(26322,2,11660,0),(26323,10,11660,0),(26324,2,11661,0),(26325,10,11661,0),(26326,2,11662,0),(26327,10,11662,0),(26328,2,11663,0),(26329,10,11663,0),(26330,2,11664,0),(26331,10,11664,0),(26332,2,11665,0),(26333,10,11665,0),(26334,2,11666,0),(26335,10,11666,0),(26336,2,11667,0),(26337,10,11667,0),(26338,2,11668,0),(26339,10,11668,0),(26340,2,11669,0),(26341,10,11669,0),(26342,2,11670,0),(26343,10,11670,0),(26344,2,11671,0),(26345,10,11671,0),(26346,2,11672,0),(26347,10,11672,0),(26348,2,11673,0),(26349,10,11673,0),(26350,2,11674,0),(26351,10,11674,0),(26352,2,11675,0),(26353,10,11675,0),(26354,2,11676,0),(26355,10,11676,0),(26356,2,11677,0),(26357,10,11677,0),(26358,2,11678,0),(26359,10,11678,0),(26360,2,11679,0),(26361,10,11679,0),(26362,2,11680,0),(26363,10,11680,0),(26364,2,11681,0),(26365,10,11681,0),(26366,2,11682,0),(26367,10,11682,0),(26368,2,11683,0),(26369,10,11683,0),(26370,2,11684,0),(26371,10,11684,0),(26372,2,11685,0),(26373,10,11685,0),(26374,2,11686,0),(26375,10,11686,0),(26376,2,11687,0),(26377,10,11687,0),(26378,2,11688,0),(26379,10,11688,0),(26380,2,11689,0),(26381,10,11689,0),(26382,2,11690,0),(26383,10,11690,0),(26384,2,11691,0),(26385,10,11691,0),(26386,2,11692,0),(26387,10,11692,0),(26388,2,11693,0),(26389,10,11693,0),(26390,2,11694,0),(26391,10,11694,0),(26392,2,11695,0),(26393,10,11695,0),(26394,2,11696,0),(26395,10,11696,0),(26396,2,11697,0),(26397,10,11697,0),(26398,2,11698,0),(26399,10,11698,0),(26400,2,11699,0),(26401,10,11699,0),(26402,2,11700,0),(26403,10,11700,0),(26404,2,11701,0),(26405,10,11701,0),(26406,2,11702,0),(26407,10,11702,0),(26408,2,11703,0),(26409,10,11703,0),(26410,2,11704,0),(26411,10,11704,0),(26412,2,11705,0),(26413,10,11705,0),(26414,2,11706,0),(26415,10,11706,0),(26416,2,11707,0),(26417,10,11707,0),(26418,2,11708,0),(26419,10,11708,0),(26420,2,11709,0),(26421,10,11709,0),(26422,2,11710,0),(26423,10,11710,0),(26424,2,11711,0),(26425,10,11711,0),(26426,2,11712,0),(26427,10,11712,0),(26428,2,11713,0),(26429,10,11713,0),(26430,2,11714,0),(26431,10,11714,0),(26432,2,11715,0),(26433,10,11715,0),(26434,2,11716,0),(26435,10,11716,0),(26436,2,11717,0),(26437,10,11717,0),(26438,2,11718,0),(26439,10,11718,0),(26440,2,11719,0),(26441,10,11719,0),(26442,2,11720,0),(26443,10,11720,0),(26444,2,11721,0),(26445,10,11721,0),(26446,2,11722,0),(26447,10,11722,0),(26448,2,11723,0),(26449,10,11723,0),(26450,2,11724,0),(26451,10,11724,0),(26452,2,11725,0),(26453,10,11725,0),(26454,2,11726,0),(26455,10,11726,0),(26456,2,11727,0),(26457,10,11727,0),(26458,2,11728,0),(26459,10,11728,0),(26460,2,11729,0),(26461,10,11729,0),(26462,2,11730,0),(26463,10,11730,0),(26464,2,11731,0),(26465,10,11731,0),(26466,2,11732,0),(26467,10,11732,0),(26468,2,11733,0),(26469,10,11733,0),(26470,2,11734,0),(26471,10,11734,0),(26472,2,11735,0),(26473,10,11735,0),(26474,2,11736,0),(26475,10,11736,0),(26476,2,11737,0),(26477,10,11737,0),(26478,2,11738,0),(26479,10,11738,0),(26480,2,11739,0),(26481,10,11739,0),(26482,2,11740,0),(26483,10,11740,0),(26484,2,11741,0),(26485,10,11741,0),(26486,2,11742,0),(26487,10,11742,0),(26488,2,11743,0),(26489,10,11743,0),(26490,2,11744,0),(26491,10,11744,0),(26492,2,11745,0),(26493,10,11745,0),(26494,2,11746,0),(26495,10,11746,0),(26496,2,11747,0),(26497,10,11747,0),(26498,2,11748,0),(26499,10,11748,0),(26500,2,11749,0),(26501,10,11749,0),(26502,2,11750,0),(26503,10,11750,0),(26504,2,11751,0),(26505,10,11751,0),(26506,2,11752,0),(26507,10,11752,0),(26508,2,11753,0),(26509,10,11753,0),(26510,2,11754,0),(26511,10,11754,0),(26512,2,11755,0),(26513,10,11755,0),(26514,2,11756,0),(26515,10,11756,0),(26516,2,11757,0),(26517,10,11757,0),(26518,2,11758,0),(26519,10,11758,0),(26520,2,11759,0),(26521,10,11759,0),(26522,2,11760,0),(26523,10,11760,0),(26524,2,11761,0),(26525,10,11761,0),(26526,2,11762,0),(26527,10,11762,0),(26528,2,11763,0),(26529,10,11763,0),(26530,2,11764,0),(26531,10,11764,0),(26532,2,11765,0),(26533,10,11765,0),(26534,2,11766,0),(26535,10,11766,0),(26536,2,11767,0),(26537,10,11767,0),(26538,2,11768,0),(26539,10,11768,0),(26540,2,11769,0),(26541,10,11769,0),(26542,2,11770,0),(26543,10,11770,0),(26544,2,11771,0),(26545,10,11771,0),(26546,2,11772,0),(26547,10,11772,0),(26548,2,11773,0),(26549,10,11773,0),(26550,2,11774,0),(26551,10,11774,0),(26552,2,11775,0),(26553,10,11775,0),(26554,2,11776,0),(26555,10,11776,0),(26556,2,11777,0),(26557,10,11777,0),(26558,2,11778,0),(26559,10,11778,0),(26560,2,11779,0),(26561,10,11779,0),(26562,2,11780,0),(26563,10,11780,0),(26564,2,11781,0),(26565,10,11781,0),(26566,2,11782,0),(26567,10,11782,0),(26568,2,11783,0),(26569,10,11783,0),(26570,2,11784,0),(26571,10,11784,0),(26572,2,11785,0),(26573,10,11785,0),(26574,2,11786,0),(26575,10,11786,0),(26576,2,11787,0),(26577,10,11787,0),(26578,2,11788,0),(26579,10,11788,0),(26580,2,11789,0),(26581,10,11789,0),(26582,2,11790,0),(26583,10,11790,0),(26584,2,11791,0),(26585,10,11791,0),(26586,2,11792,0),(26587,10,11792,0),(26588,2,11793,0),(26589,10,11793,0),(26590,2,11794,0),(26591,10,11794,0),(26592,2,11795,0),(26593,10,11795,0),(26594,2,11796,0),(26595,10,11796,0),(26596,2,11797,0),(26597,10,11797,0),(26598,2,11798,0),(26599,10,11798,0),(26600,2,11799,0),(26601,10,11799,0),(26602,2,11800,0),(26603,10,11800,0),(26604,2,11801,0),(26605,10,11801,0),(26606,2,11802,0),(26607,10,11802,0),(26608,2,11803,0),(26609,10,11803,0),(26610,2,11804,0),(26611,10,11804,0),(26612,2,11805,0),(26613,10,11805,0),(26614,2,11806,0),(26615,10,11806,0),(26616,2,11807,0),(26617,10,11807,0),(26618,2,11808,0),(26619,10,11808,0),(26620,2,11809,0),(26621,10,11809,0),(26622,2,11810,0),(26623,10,11810,0),(26624,2,11811,0),(26625,10,11811,0),(26626,2,11812,0),(26627,10,11812,0),(26628,2,11813,0),(26629,10,11813,0),(26630,2,11814,0),(26631,10,11814,0),(26632,2,11815,0),(26633,10,11815,0),(26634,2,11816,0),(26635,10,11816,0),(26636,2,11817,0),(26637,10,11817,0),(26638,2,11818,0),(26639,10,11818,0),(26640,2,11819,0),(26641,10,11819,0),(26642,2,11820,0),(26643,10,11820,0),(26644,2,11821,0),(26645,10,11821,0),(26646,2,11822,0),(26647,10,11822,0),(26648,2,11823,0),(26649,10,11823,0),(26650,2,11824,0),(26651,10,11824,0),(26652,2,11825,0),(26653,10,11825,0),(26654,2,11826,0),(26655,10,11826,0),(26656,2,11827,0),(26657,10,11827,0),(26658,2,11828,0),(26659,10,11828,0),(26660,2,11829,0),(26661,10,11829,0),(26662,2,11830,0),(26663,10,11830,0),(26664,2,11831,0),(26665,10,11831,0),(26666,2,11832,0),(26667,10,11832,0),(26668,2,11833,0),(26669,10,11833,0),(26670,2,11834,0),(26671,10,11834,0),(26672,2,11835,0),(26673,10,11835,0),(26674,2,11836,0),(26675,10,11836,0),(26676,2,11837,0),(26677,10,11837,0),(26678,2,11838,0),(26679,10,11838,0),(26680,2,11839,0),(26681,10,11839,0),(26682,2,11840,0),(26683,10,11840,0),(26684,2,11841,0),(26685,10,11841,0),(26686,2,11842,0),(26687,10,11842,0),(26688,2,11843,0),(26689,10,11843,0),(26690,2,11844,0),(26691,10,11844,0),(26692,2,11845,0),(26693,10,11845,0),(26694,2,11846,0),(26695,10,11846,0),(26696,2,11847,0),(26697,10,11847,0),(26698,2,11848,0),(26699,10,11848,0),(26700,2,11849,0),(26701,10,11849,0),(26702,2,11850,0),(26703,10,11850,0),(26704,2,11851,0),(26705,10,11851,0),(26706,2,11852,0),(26707,10,11852,0),(26708,2,11853,0),(26709,10,11853,0),(26710,2,11854,0),(26711,10,11854,0),(26712,2,11855,0),(26713,10,11855,0),(26714,2,11856,0),(26715,10,11856,0),(26716,2,11857,0),(26717,10,11857,0),(26718,2,11858,0),(26719,10,11858,0),(26720,2,11859,0),(26721,10,11859,0),(26722,2,11860,0),(26723,10,11860,0),(26724,2,11861,0),(26725,10,11861,0),(26726,2,11862,0),(26727,10,11862,0),(26728,2,11863,0),(26729,10,11863,0),(26730,2,11864,0),(26731,10,11864,0),(26732,2,11865,0),(26733,10,11865,0),(26734,2,11866,0),(26735,10,11866,0),(26736,2,11867,0),(26737,10,11867,0),(26738,2,11868,0),(26739,10,11868,0),(26740,2,11869,0),(26741,10,11869,0),(26742,2,11870,0),(26743,10,11870,0),(26744,2,11871,0),(26745,10,11871,0),(26746,2,11872,0),(26747,10,11872,0),(26748,2,11873,0),(26749,10,11873,0),(26750,2,11874,0),(26751,10,11874,0),(26752,2,11875,0),(26753,10,11875,0),(26754,2,11876,0),(26755,10,11876,0),(26756,2,11877,0),(26757,10,11877,0),(26758,2,11878,0),(26759,10,11878,0),(26760,2,11879,0),(26761,10,11879,0),(26762,2,11880,0),(26763,10,11880,0),(26764,2,11881,0),(26765,10,11881,0),(26766,2,11882,0),(26767,10,11882,0),(26768,2,11883,0),(26769,10,11883,0),(26770,2,11884,0),(26771,10,11884,0),(26772,2,11885,0),(26773,10,11885,0),(26774,2,11886,0),(26775,10,11886,0),(26776,2,11887,0),(26777,10,11887,0),(26778,2,11888,0),(26779,10,11888,0),(26780,2,11889,0),(26781,10,11889,0),(26782,2,11890,0),(26783,10,11890,0),(26784,2,11891,0),(26785,10,11891,0),(26786,2,11892,0),(26787,10,11892,0),(26788,2,11893,0),(26789,10,11893,0),(26790,2,11894,0),(26791,10,11894,0),(26792,2,11895,0),(26793,10,11895,0),(26794,2,11896,0),(26795,10,11896,0),(26796,2,11897,0),(26797,10,11897,0),(26798,2,11898,0),(26799,10,11898,0),(26800,2,11899,0),(26801,10,11899,0),(26802,2,11900,0),(26803,10,11900,0),(26804,2,11901,0),(26805,10,11901,0),(26806,2,11902,0),(26807,10,11902,0),(26808,2,11903,0),(26809,10,11903,0),(26810,2,11904,0),(26811,10,11904,0),(26812,2,11905,0),(26813,10,11905,0),(26814,2,11906,0),(26815,10,11906,0),(26816,2,11907,0),(26817,10,11907,0),(26818,2,11908,0),(26819,10,11908,0),(26820,2,11909,0),(26821,10,11909,0),(26822,2,11910,0),(26823,10,11910,0),(26824,2,11911,0),(26825,10,11911,0),(26826,2,11912,0),(26827,10,11912,0),(26828,2,11913,0),(26829,10,11913,0),(26830,2,11914,0),(26831,10,11914,0),(26832,2,11915,0),(26833,10,11915,0),(26834,2,11916,0),(26835,10,11916,0),(26836,2,11917,0),(26837,10,11917,0),(26838,2,11918,0),(26839,10,11918,0),(26840,2,11919,0),(26841,10,11919,0),(26842,2,11920,0),(26843,10,11920,0),(26844,2,11921,0),(26845,10,11921,0),(26846,2,11922,0),(26847,10,11922,0),(26848,2,11923,0),(26849,10,11923,0),(26850,2,11924,0),(26851,10,11924,0),(26852,2,11925,0),(26853,10,11925,0),(26854,2,11926,0),(26855,10,11926,0),(26856,2,11927,0),(26857,10,11927,0),(26858,2,11928,0),(26859,10,11928,0),(26860,2,11929,0),(26861,10,11929,0),(26862,2,11930,0),(26863,10,11930,0),(26864,2,11931,0),(26865,10,11931,0),(26866,2,11932,0),(26867,10,11932,0),(26868,2,11933,0),(26869,10,11933,0),(26870,2,11934,0),(26871,10,11934,0),(26872,2,11935,0),(26873,10,11935,0),(26874,2,11936,0),(26875,10,11936,0),(26876,2,11937,0),(26877,10,11937,0),(26878,2,11938,0),(26879,10,11938,0),(26880,2,11939,0),(26881,10,11939,0),(26882,2,11940,0),(26883,10,11940,0),(26884,2,11941,0),(26885,10,11941,0),(26886,2,11942,0),(26887,10,11942,0),(26888,2,11943,0),(26889,10,11943,0),(26890,2,11944,0),(26891,10,11944,0),(26892,2,11945,0),(26893,10,11945,0),(26894,2,11946,0),(26895,10,11946,0),(26896,2,11947,0),(26897,10,11947,0),(26898,2,11948,0),(26899,10,11948,0),(26900,2,11949,0),(26901,10,11949,0),(26902,2,11950,0),(26903,10,11950,0),(26904,2,11951,0),(26905,10,11951,0),(26906,2,11952,0),(26907,10,11952,0),(26908,2,11953,0),(26909,10,11953,0),(26910,2,11954,0),(26911,10,11954,0),(26912,2,11955,0),(26913,10,11955,0),(26914,2,11956,0),(26915,10,11956,0),(26916,2,11957,0),(26917,10,11957,0),(26918,2,11958,0),(26919,10,11958,0),(26920,2,11959,0),(26921,10,11959,0),(26922,2,11960,0),(26923,10,11960,0),(26924,2,11961,0),(26925,10,11961,0),(26926,2,11962,0),(26927,10,11962,0),(26928,2,11963,0),(26929,10,11963,0),(26930,2,11964,0),(26931,10,11964,0),(26932,2,11965,0),(26933,10,11965,0),(26934,2,11966,0),(26935,10,11966,0),(26936,2,11967,0),(26937,10,11967,0),(26938,2,11968,0),(26939,10,11968,0),(26940,2,11969,0),(26941,10,11969,0),(26942,2,11970,0),(26943,10,11970,0),(26944,2,11971,0),(26945,10,11971,0),(26946,2,11972,0),(26947,10,11972,0),(26948,2,11973,0),(26949,10,11973,0),(26950,2,11974,0),(26951,10,11974,0),(26952,2,11975,0),(26953,10,11975,0),(26954,2,11976,0),(26955,10,11976,0),(26956,2,11977,0),(26957,10,11977,0),(26958,2,11978,0),(26959,10,11978,0),(26960,2,11979,0),(26961,10,11979,0),(26962,2,11980,0),(26963,10,11980,0),(26964,2,11981,0),(26965,10,11981,0),(26966,2,11982,0),(26967,10,11982,0),(26968,2,11983,0),(26969,10,11983,0),(26970,2,11984,0),(26971,10,11984,0),(26972,2,11985,0),(26973,10,11985,0),(26974,2,11986,0),(26975,10,11986,0),(26976,2,11987,0),(26977,10,11987,0),(26978,2,11988,0),(26979,10,11988,0),(26980,2,11989,0),(26981,10,11989,0),(26982,2,11990,0),(26983,10,11990,0),(26984,2,11991,0),(26985,10,11991,0),(26986,2,11992,0),(26987,10,11992,0),(26988,2,11993,0),(26989,10,11993,0),(26990,2,11994,0),(26991,10,11994,0),(26992,2,11995,0),(26993,10,11995,0),(26994,2,11996,0),(26995,10,11996,0),(26996,2,11997,0),(26997,10,11997,0),(26998,2,11998,0),(26999,10,11998,0),(27000,2,11999,0),(27001,10,11999,0),(27002,2,12000,0),(27003,10,12000,0),(27004,2,12001,0),(27005,10,12001,0),(27006,2,12002,0),(27007,10,12002,0),(27008,2,12003,0),(27009,10,12003,0),(27010,2,12004,0),(27011,10,12004,0),(27012,2,12005,0),(27013,10,12005,0),(27014,2,12006,0),(27015,10,12006,0),(27016,2,12007,0),(27017,10,12007,0),(27018,2,12008,0),(27019,10,12008,0),(27020,2,12009,0),(27021,10,12009,0),(27022,2,12010,0),(27023,10,12010,0),(27024,2,12011,0),(27025,10,12011,0),(27026,2,12012,0),(27027,10,12012,0),(27028,2,12013,0),(27029,10,12013,0),(27030,2,12014,0),(27031,10,12014,0),(27032,2,12015,0),(27033,10,12015,0),(27034,2,12016,0),(27035,10,12016,0),(27036,2,12017,0),(27037,10,12017,0),(27038,2,12018,0),(27039,10,12018,0),(27040,2,12019,0),(27041,10,12019,0),(27042,2,12020,0),(27043,10,12020,0),(27044,2,12021,0),(27045,10,12021,0),(27046,2,12022,0),(27047,10,12022,0),(27048,2,12023,0),(27049,10,12023,0),(27050,2,12024,0),(27051,10,12024,0),(27052,2,12025,0),(27053,10,12025,0),(27054,2,12026,0),(27055,10,12026,0),(27056,2,12027,0),(27057,10,12027,0),(27058,2,12028,0),(27059,10,12028,0),(27060,2,12029,0),(27061,10,12029,0),(27062,2,12030,0),(27063,10,12030,0),(27064,2,12031,0),(27065,10,12031,0),(27066,2,12032,0),(27067,10,12032,0),(27068,2,12033,0),(27069,10,12033,0),(27070,2,12034,0),(27071,10,12034,0),(27072,2,12035,0),(27073,10,12035,0),(27074,2,12036,0),(27075,10,12036,0),(27076,2,12037,0),(27077,10,12037,0),(27078,2,12038,0),(27079,10,12038,0),(27080,2,12039,0),(27081,10,12039,0),(27082,2,12040,0),(27083,10,12040,0),(27084,2,12041,0),(27085,10,12041,0),(27086,2,12042,0),(27087,10,12042,0),(27088,2,12043,0),(27089,10,12043,0),(27090,2,12044,0),(27091,10,12044,0),(27092,2,12045,0),(27093,10,12045,0),(27094,2,12046,0),(27095,10,12046,0),(27096,2,12047,0),(27097,10,12047,0),(27098,2,12048,0),(27099,10,12048,0),(27100,2,12049,0),(27101,10,12049,0),(27102,2,12050,0),(27103,10,12050,0),(27104,2,12051,0),(27105,10,12051,0),(27106,2,12052,0),(27107,10,12052,0),(27108,2,12053,0),(27109,10,12053,0),(27110,2,12054,0),(27111,10,12054,0),(27112,2,12055,0),(27113,10,12055,0),(27114,2,12056,0),(27115,10,12056,0),(27116,2,12057,0),(27117,10,12057,0),(27118,2,12058,0),(27119,10,12058,0),(27120,2,12059,0),(27121,10,12059,0),(27122,2,12060,0),(27123,10,12060,0),(27124,2,12061,0),(27125,10,12061,0),(27126,2,12062,0),(27127,10,12062,0),(27128,2,12063,0),(27129,10,12063,0),(27130,2,12064,0),(27131,10,12064,0),(27132,2,12065,0),(27133,10,12065,0),(27134,2,12066,0),(27135,10,12066,0),(27136,2,12067,0),(27137,10,12067,0),(27138,2,12068,0),(27139,10,12068,0),(27140,2,12069,0),(27141,10,12069,0),(27142,2,12070,0),(27143,10,12070,0),(27144,2,12071,0),(27145,10,12071,0),(27146,2,12072,0),(27147,10,12072,0),(27148,2,12073,0),(27149,10,12073,0),(27150,2,12074,0),(27151,10,12074,0),(27152,2,12075,0),(27153,10,12075,0),(27154,2,12076,0),(27155,10,12076,0),(27156,2,12077,0),(27157,10,12077,0),(27158,2,12078,0),(27159,10,12078,0),(27160,2,12079,0),(27161,10,12079,0),(27162,2,12080,0),(27163,10,12080,0),(27164,2,12081,0),(27165,10,12081,0),(27166,2,12082,0),(27167,10,12082,0),(27168,2,12083,0),(27169,10,12083,0),(27170,2,12084,0),(27171,10,12084,0),(27172,2,12085,0),(27173,10,12085,0),(27174,2,12086,0),(27175,10,12086,0),(27176,2,12087,0),(27177,10,12087,0),(27178,2,12088,0),(27179,10,12088,0),(27180,2,12089,0),(27181,10,12089,0),(27182,2,12090,0),(27183,10,12090,0),(27184,2,12091,0),(27185,10,12091,0),(27186,2,12092,0),(27187,10,12092,0),(27188,2,12093,0),(27189,10,12093,0),(27190,2,12094,0),(27191,10,12094,0),(27192,2,12095,0),(27193,10,12095,0),(27194,2,12096,0),(27195,10,12096,0),(27196,2,12097,0),(27197,10,12097,0),(27198,2,12098,0),(27199,10,12098,0),(27200,2,12099,0),(27201,10,12099,0),(27202,2,12100,0),(27203,10,12100,0),(27204,2,12101,0),(27205,10,12101,0),(27206,2,12102,0),(27207,10,12102,0),(27208,2,12103,0),(27209,10,12103,0),(27210,2,12104,0),(27211,10,12104,0),(27212,2,12105,0),(27213,10,12105,0),(27214,2,12106,0),(27215,10,12106,0),(27216,2,12107,0),(27217,10,12107,0),(27218,2,12108,0),(27219,10,12108,0),(27220,2,12109,0),(27221,10,12109,0),(27222,2,12110,0),(27223,10,12110,0),(27224,2,12111,0),(27225,10,12111,0),(27226,2,12112,0),(27227,10,12112,0),(27228,2,12113,0),(27229,10,12113,0),(27230,2,12114,0),(27231,10,12114,0),(27232,2,12115,0),(27233,10,12115,0),(27234,2,12116,0),(27235,10,12116,0),(27236,2,12117,0),(27237,10,12117,0),(27238,2,12118,0),(27239,10,12118,0),(27240,2,12119,0),(27241,10,12119,0),(27242,2,12120,0),(27243,10,12120,0),(27244,2,12121,0),(27245,10,12121,0),(27246,2,12122,0),(27247,10,12122,0),(27248,2,12123,0),(27249,10,12123,0),(27250,2,12124,0),(27251,10,12124,0),(27252,2,12125,0),(27253,10,12125,0),(27254,2,12126,0),(27255,10,12126,0),(27256,2,12127,0),(27257,10,12127,0),(27258,2,12128,0),(27259,10,12128,0),(27260,2,12129,0),(27261,10,12129,0),(27262,2,12130,0),(27263,10,12130,0),(27264,2,12131,0),(27265,10,12131,0),(27266,2,12132,0),(27267,10,12132,0),(27268,2,12133,0),(27269,10,12133,0),(27270,2,12134,0),(27271,10,12134,0),(27272,2,12135,0),(27273,10,12135,0),(27274,2,12136,0),(27275,10,12136,0),(27276,2,12137,0),(27277,10,12137,0),(27278,2,12138,0),(27279,10,12138,0),(27280,2,12139,0),(27281,10,12139,0),(27282,2,12140,0),(27283,10,12140,0),(27284,2,12141,0),(27285,10,12141,0),(27286,2,12142,0),(27287,10,12142,0),(27288,2,12143,0),(27289,10,12143,0),(27290,2,12144,0),(27291,10,12144,0),(27292,2,12145,0),(27293,10,12145,0),(27294,2,12146,0),(27295,10,12146,0),(27296,2,12147,0),(27297,10,12147,0),(27298,2,12148,0),(27299,10,12148,0),(27300,2,12149,0),(27301,10,12149,0),(27302,2,12150,0),(27303,10,12150,0),(27304,2,12151,0),(27305,10,12151,0),(27306,2,12152,0),(27307,10,12152,0),(27308,2,12153,0),(27309,10,12153,0),(27310,2,12154,0),(27311,10,12154,0),(27312,2,12155,0),(27313,10,12155,0),(27314,2,12156,0),(27315,10,12156,0),(27316,2,12157,0),(27317,10,12157,0),(27318,2,12158,0),(27319,10,12158,0),(27320,2,12159,0),(27321,10,12159,0),(27322,2,12160,0),(27323,10,12160,0),(27324,2,12161,0),(27325,10,12161,0),(27326,2,12162,0),(27327,10,12162,0),(27328,2,12163,0),(27329,10,12163,0),(27330,2,12164,0),(27331,10,12164,0),(27332,2,12165,0),(27333,10,12165,0),(27334,2,12166,0),(27335,10,12166,0),(27336,2,12167,0),(27337,10,12167,0),(27338,2,12168,0),(27339,10,12168,0),(27340,2,12169,0),(27341,10,12169,0),(27342,2,12170,0),(27343,10,12170,0),(27344,2,12171,0),(27345,10,12171,0),(27346,2,12172,0),(27347,10,12172,0),(27348,2,12173,0),(27349,10,12173,0),(27350,2,12174,0),(27351,10,12174,0),(27352,2,12175,0),(27353,10,12175,0),(27354,2,12176,0),(27355,10,12176,0),(27356,2,12177,0),(27357,10,12177,0),(27358,2,12178,0),(27359,10,12178,0),(27360,2,12179,0),(27361,10,12179,0),(27362,2,12180,0),(27363,10,12180,0),(27364,2,12181,0),(27365,10,12181,0),(27366,2,12182,0),(27367,10,12182,0),(27368,2,12183,0),(27369,10,12183,0),(27370,2,12184,0),(27371,10,12184,0),(27372,2,12185,0),(27373,10,12185,0),(27374,2,12186,0),(27375,10,12186,0),(27376,2,12187,0),(27377,10,12187,0),(27378,2,12188,0),(27379,10,12188,0),(27380,2,12189,0),(27381,10,12189,0),(27382,2,12190,0),(27383,10,12190,0),(27384,2,12191,0),(27385,10,12191,0),(27386,2,12192,0),(27387,10,12192,0),(27388,2,12193,0),(27389,10,12193,0),(27390,2,12194,0),(27391,10,12194,0),(27392,2,12195,0),(27393,10,12195,0),(27394,2,12196,0),(27395,10,12196,0),(27396,2,12197,0),(27397,10,12197,0),(27398,2,12198,0),(27399,10,12198,0),(27400,2,12199,0),(27401,10,12199,0),(27402,2,12200,0),(27403,10,12200,0),(27404,2,12201,0),(27405,10,12201,0),(27406,2,12202,0),(27407,10,12202,0),(27408,2,12203,0),(27409,10,12203,0),(27410,2,12204,0),(27411,10,12204,0),(27412,2,12205,0),(27413,10,12205,0),(27414,2,12206,0),(27415,10,12206,0),(27416,2,12207,0),(27417,10,12207,0),(27418,2,12208,0),(27419,10,12208,0),(27420,2,12209,0),(27421,10,12209,0),(27422,2,12210,0),(27423,10,12210,0),(27424,2,12211,0),(27425,10,12211,0),(27426,2,12212,0),(27427,10,12212,0),(27428,2,12213,0),(27429,10,12213,0),(27430,2,12214,0),(27431,10,12214,0),(27432,2,12215,0),(27433,10,12215,0),(27434,2,12216,0),(27435,10,12216,0),(27436,2,12217,0),(27437,10,12217,0),(27438,2,12218,0),(27439,10,12218,0),(27440,2,12219,0),(27441,10,12219,0),(27442,2,12220,0),(27443,10,12220,0),(27444,2,12221,0),(27445,10,12221,0),(27446,2,12222,0),(27447,10,12222,0),(27448,2,12223,0),(27449,10,12223,0),(27450,2,12224,0),(27451,10,12224,0),(27452,2,12225,0),(27453,10,12225,0),(27454,2,12226,0),(27455,10,12226,0),(27456,2,12227,0),(27457,10,12227,0),(27458,2,12228,0),(27459,10,12228,0),(27460,2,12229,0),(27461,10,12229,0),(27462,2,12230,0),(27463,10,12230,0),(27464,2,12231,0),(27465,10,12231,0),(27466,2,12232,0),(27467,10,12232,0),(27468,2,12233,0),(27469,10,12233,0),(27470,2,12234,0),(27471,10,12234,0),(27472,2,12235,0),(27473,10,12235,0),(27474,2,12236,0),(27475,10,12236,0),(27476,2,12237,0),(27477,10,12237,0),(27478,2,12238,0),(27479,10,12238,0),(27480,2,12239,0),(27481,10,12239,0),(27482,2,12240,0),(27483,10,12240,0),(27484,2,12241,0),(27485,10,12241,0),(27486,2,12242,0),(27487,10,12242,0),(27488,2,12243,0),(27489,10,12243,0),(27490,2,12244,0),(27491,10,12244,0),(27492,2,12245,0),(27493,10,12245,0),(27494,2,12246,0),(27495,10,12246,0),(27496,2,12247,0),(27497,10,12247,0),(27498,2,12248,0),(27499,10,12248,0),(27500,2,12249,0),(27501,10,12249,0),(27502,2,12250,0),(27503,10,12250,0),(27504,2,12251,0),(27505,10,12251,0),(27506,2,12252,0),(27507,10,12252,0),(27508,2,12253,0),(27509,10,12253,0),(27510,2,12254,0),(27511,10,12254,0),(27512,2,12255,0),(27513,10,12255,0),(27514,2,12256,0),(27515,10,12256,0),(27516,2,12257,0),(27517,10,12257,0),(27518,2,12258,0),(27519,10,12258,0),(27520,2,12259,0),(27521,10,12259,0),(27522,2,12260,0),(27523,10,12260,0),(27524,2,12261,0),(27525,10,12261,0),(27526,2,12262,0),(27527,10,12262,0),(27528,2,12263,0),(27529,10,12263,0),(27530,2,12264,0),(27531,10,12264,0),(27532,2,12265,0),(27533,10,12265,0),(27534,2,12266,0),(27535,10,12266,0),(27536,2,12267,0),(27537,10,12267,0),(27538,2,12268,0),(27539,10,12268,0),(27540,2,12269,0),(27541,10,12269,0),(27542,2,12270,0),(27543,10,12270,0),(27544,2,12271,0),(27545,10,12271,0),(27546,2,12272,0),(27547,10,12272,0),(27548,2,12273,0),(27549,10,12273,0),(27550,2,12274,0),(27551,10,12274,0),(27552,2,12275,0),(27553,10,12275,0),(27554,2,12276,0),(27555,10,12276,0),(27556,2,12277,0),(27557,10,12277,0),(27558,2,12278,0),(27559,10,12278,0),(27560,2,12279,0),(27561,10,12279,0),(27562,2,12280,0),(27563,10,12280,0),(27564,2,12281,0),(27565,10,12281,0),(27566,2,12282,0),(27567,10,12282,0),(27568,2,12283,0),(27569,10,12283,0),(27570,2,12284,0),(27571,10,12284,0),(27572,2,12285,0),(27573,10,12285,0),(27574,2,12286,0),(27575,10,12286,0),(27576,2,12287,0),(27577,10,12287,0),(27578,2,12288,0),(27579,10,12288,0),(27580,2,12289,0),(27581,10,12289,0),(27582,2,12290,0),(27583,10,12290,0),(27584,2,12291,0),(27585,10,12291,0),(27586,2,12292,0),(27587,10,12292,0),(27588,2,12293,0),(27589,10,12293,0),(27590,2,12294,0),(27591,10,12294,0),(27592,2,12295,0),(27593,10,12295,0),(27594,2,12296,0),(27595,10,12296,0),(27596,2,12297,0),(27597,10,12297,0),(27598,2,12298,0),(27599,10,12298,0),(27600,2,12299,0),(27601,10,12299,0),(27602,2,12300,0),(27603,10,12300,0),(27604,2,12301,0),(27605,10,12301,0),(27606,2,12302,0),(27607,10,12302,0),(27608,2,12303,0),(27609,10,12303,0),(27610,2,12304,0),(27611,10,12304,0),(27612,2,12305,0),(27613,10,12305,0),(27614,2,12306,0),(27615,10,12306,0),(27616,2,12307,0),(27617,10,12307,0),(27618,2,12308,0),(27619,10,12308,0),(27620,2,12309,0),(27621,10,12309,0),(27622,2,12310,0),(27623,10,12310,0),(27624,2,12311,0),(27625,10,12311,0),(27626,2,12312,0),(27627,10,12312,0),(27628,2,12313,0),(27629,10,12313,0),(27630,2,12314,0),(27631,10,12314,0),(27632,2,12315,0),(27633,10,12315,0),(27634,2,12316,0),(27635,10,12316,0),(27636,2,12317,0),(27637,10,12317,0),(27638,2,12318,0),(27639,10,12318,0),(27640,2,12319,0),(27641,10,12319,0),(27642,2,12320,0),(27643,10,12320,0),(27644,2,12321,0),(27645,10,12321,0),(27646,2,12322,0),(27647,10,12322,0),(27648,2,12323,0),(27649,10,12323,0),(27650,2,12324,0),(27651,10,12324,0),(27652,2,12325,0),(27653,10,12325,0),(27654,2,12326,0),(27655,10,12326,0),(27656,2,12327,0),(27657,10,12327,0),(27658,2,12328,0),(27659,10,12328,0),(27660,2,12329,0),(27661,10,12329,0),(27662,2,12330,0),(27663,10,12330,0),(27664,2,12331,0),(27665,10,12331,0),(27666,2,12332,0),(27667,10,12332,0),(27668,2,12333,0),(27669,10,12333,0),(27670,2,12334,0),(27671,10,12334,0),(27672,2,12335,0),(27673,10,12335,0),(27674,2,12336,0),(27675,10,12336,0),(27676,2,12337,0),(27677,10,12337,0),(27678,2,12338,0),(27679,10,12338,0),(27680,2,12339,0),(27681,10,12339,0),(27682,2,12340,0),(27683,10,12340,0),(27684,2,12341,0),(27685,10,12341,0),(27686,2,12342,0),(27687,10,12342,0),(27688,2,12343,0),(27689,10,12343,0),(27690,2,12344,0),(27691,10,12344,0),(27692,2,12345,0),(27693,10,12345,0),(27694,2,12346,0),(27695,10,12346,0),(27696,2,12347,0),(27697,10,12347,0),(27698,2,12348,0),(27699,10,12348,0),(27700,2,12349,0),(27701,10,12349,0),(27702,2,12350,0),(27703,10,12350,0),(27704,2,12351,0),(27705,10,12351,0),(27706,2,12352,0),(27707,10,12352,0),(27708,2,12353,0),(27709,10,12353,0),(27710,2,12354,0),(27711,10,12354,0),(27712,2,12355,0),(27713,10,12355,0),(27714,2,12356,0),(27715,10,12356,0),(27716,2,12357,0),(27717,10,12357,0),(27718,2,12358,0),(27719,10,12358,0),(27720,2,12359,0),(27721,10,12359,0),(27722,2,12360,0),(27723,10,12360,0),(27724,2,12361,0),(27725,10,12361,0),(27726,2,12362,0),(27727,10,12362,0),(27728,2,12363,0),(27729,10,12363,0),(27730,2,12364,0),(27731,10,12364,0),(27732,2,12365,0),(27733,10,12365,0),(27734,2,12366,0),(27735,10,12366,0),(27736,2,12367,0),(27737,10,12367,0),(27738,2,12368,0),(27739,10,12368,0),(27740,2,12369,0),(27741,10,12369,0),(27742,2,12370,0),(27743,10,12370,0),(27744,2,12371,0),(27745,10,12371,0),(27746,2,12372,0),(27747,10,12372,0),(27748,2,12373,0),(27749,10,12373,0),(27750,2,12374,0),(27751,10,12374,0),(27752,2,12375,0),(27753,10,12375,0),(27754,2,12376,0),(27755,10,12376,0),(27756,2,12377,0),(27757,10,12377,0),(27758,2,12378,0),(27759,10,12378,0),(27760,2,12379,0),(27761,10,12379,0),(27762,2,12380,0),(27763,10,12380,0),(27764,2,12381,0),(27765,10,12381,0),(27766,2,12382,0),(27767,10,12382,0),(27768,2,12383,0),(27769,10,12383,0),(27770,2,12384,0),(27771,10,12384,0),(27772,2,12385,0),(27773,10,12385,0),(27774,2,12386,0),(27775,10,12386,0),(27776,2,12387,0),(27777,10,12387,0),(27778,2,12388,0),(27779,10,12388,0),(27780,2,12389,0),(27781,10,12389,0),(27782,2,12390,0),(27783,10,12390,0),(27784,2,12391,0),(27785,10,12391,0),(27786,2,12392,0),(27787,10,12392,0),(27788,2,12393,0),(27789,10,12393,0),(27790,2,12394,0),(27791,10,12394,0),(27792,2,12395,0),(27793,10,12395,0),(27794,2,12396,0),(27795,10,12396,0),(27796,2,12397,0),(27797,10,12397,0),(27798,2,12398,0),(27799,10,12398,0),(27800,2,12399,0),(27801,10,12399,0),(27802,2,12400,0),(27803,10,12400,0),(27804,2,12401,0),(27805,10,12401,0),(27806,2,12402,0),(27807,10,12402,0),(27808,2,12403,0),(27809,10,12403,0),(27810,2,12404,0),(27811,10,12404,0),(27812,2,12405,0),(27813,10,12405,0),(27814,2,12406,0),(27815,10,12406,0),(27816,2,12407,0),(27817,10,12407,0),(27818,2,12408,0),(27819,10,12408,0),(27820,2,12409,0),(27821,10,12409,0),(27822,2,12410,0),(27823,10,12410,0),(27824,2,12411,0),(27825,10,12411,0),(27826,2,12412,0),(27827,10,12412,0),(27828,2,12413,0),(27829,10,12413,0),(27830,2,12414,0),(27831,10,12414,0),(27832,2,12415,0),(27833,10,12415,0),(27834,2,12416,0),(27835,10,12416,0),(27836,2,12417,0),(27837,10,12417,0),(27838,2,12418,0),(27839,10,12418,0),(27840,2,12419,0),(27841,10,12419,0),(27842,2,12420,0),(27843,10,12420,0),(27844,2,12421,0),(27845,10,12421,0),(27846,2,12422,0),(27847,10,12422,0),(27848,2,12423,0),(27849,10,12423,0),(27850,2,12424,0),(27851,10,12424,0),(27852,2,12425,0),(27853,10,12425,0),(27854,2,12426,0),(27855,10,12426,0),(27856,2,12427,0),(27857,10,12427,0),(27858,2,12428,0),(27859,10,12428,0),(27860,2,12429,0),(27861,10,12429,0),(27862,2,12430,0),(27863,10,12430,0),(27864,2,12431,0),(27865,10,12431,0),(27866,2,12432,0),(27867,10,12432,0),(27868,2,12433,0),(27869,10,12433,0),(27870,2,12434,0),(27871,10,12434,0),(27872,2,12435,0),(27873,10,12435,0),(27874,2,12436,0),(27875,10,12436,0),(27876,2,12437,0),(27877,10,12437,0),(27878,2,12438,0),(27879,10,12438,0),(27880,2,12439,0),(27881,10,12439,0),(27882,2,12440,0),(27883,10,12440,0),(27884,2,12441,0),(27885,10,12441,0),(27886,2,12442,0),(27887,10,12442,0),(27888,2,12443,0),(27889,10,12443,0),(27890,2,12444,0),(27891,10,12444,0),(27892,2,12445,0),(27893,10,12445,0),(27894,2,12446,0),(27895,10,12446,0),(27896,2,12447,0),(27897,10,12447,0),(27898,2,12448,0),(27899,10,12448,0),(27900,2,12449,0),(27901,10,12449,0),(27902,2,12450,0),(27903,10,12450,0),(27904,2,12451,0),(27905,10,12451,0),(27906,2,12452,0),(27907,10,12452,0),(27908,2,12453,0),(27909,10,12453,0),(27910,2,12454,0),(27911,10,12454,0),(27912,2,12455,0),(27913,10,12455,0),(27914,2,12456,0),(27915,10,12456,0),(27916,2,12457,0),(27917,10,12457,0),(27918,2,12458,0),(27919,10,12458,0),(27920,2,12459,0),(27921,10,12459,0),(27922,2,12460,0),(27923,10,12460,0),(27924,2,12461,0),(27925,10,12461,0),(27926,2,12462,0),(27927,10,12462,0),(27928,2,12463,0),(27929,10,12463,0),(27930,2,12464,0),(27931,10,12464,0),(27932,2,12465,0),(27933,10,12465,0),(27934,2,12466,0),(27935,10,12466,0),(27936,2,12467,0),(27937,10,12467,0),(27938,2,12468,0),(27939,10,12468,0),(27940,2,12469,0),(27941,10,12469,0),(27942,2,12470,0),(27943,10,12470,0),(27944,2,12471,0),(27945,10,12471,0),(27946,2,12472,0),(27947,10,12472,0),(27948,2,12473,0),(27949,10,12473,0),(27950,2,12474,0),(27951,10,12474,0),(27952,2,12475,0),(27953,10,12475,0),(27954,2,12476,0),(27955,10,12476,0),(27956,2,12477,0),(27957,10,12477,0),(27958,2,12478,0),(27959,10,12478,0),(27960,2,12479,0),(27961,10,12479,0),(27962,2,12480,0),(27963,10,12480,0),(27964,2,12481,0),(27965,10,12481,0),(27966,2,12482,0),(27967,10,12482,0),(27968,2,12483,0),(27969,10,12483,0),(27970,2,12484,0),(27971,10,12484,0),(27972,2,12485,0),(27973,10,12485,0),(27974,2,12486,0),(27975,10,12486,0),(27976,2,12487,0),(27977,10,12487,0),(27978,2,12488,0),(27979,10,12488,0),(27980,2,12489,0),(27981,10,12489,0),(27982,2,12490,0),(27983,10,12490,0),(27984,2,12491,0),(27985,10,12491,0),(27986,2,12492,0),(27987,10,12492,0),(27988,2,12493,0),(27989,10,12493,0),(27990,2,12494,0),(27991,10,12494,0),(27992,2,12495,0),(27993,10,12495,0),(27994,2,12496,0),(27995,10,12496,0),(27996,2,12497,0),(27997,10,12497,0),(27998,2,12498,0),(27999,10,12498,0),(28000,2,12499,0),(28001,10,12499,0),(28002,2,12500,0),(28003,10,12500,0),(28004,2,12501,0),(28005,10,12501,0),(28006,2,12502,0),(28007,10,12502,0),(28008,2,12503,0),(28009,10,12503,0),(28010,2,12504,0),(28011,10,12504,0),(28012,2,12505,0),(28013,10,12505,0),(28014,2,12506,0),(28015,10,12506,0),(28016,2,12507,0),(28017,10,12507,0),(28018,2,12508,0),(28019,10,12508,0),(28020,2,12509,0),(28021,10,12509,0),(28022,2,12510,0),(28023,10,12510,0),(28024,2,12511,0),(28025,10,12511,0),(28026,2,12512,0),(28027,10,12512,0),(28028,2,12513,0),(28029,10,12513,0),(28030,2,12514,0),(28031,10,12514,0),(28032,2,12515,0),(28033,10,12515,0),(28034,2,12516,0),(28035,10,12516,0),(28036,2,12517,0),(28037,10,12517,0),(28038,2,12518,0),(28039,10,12518,0),(28040,2,12519,0),(28041,10,12519,0),(28042,2,12520,0),(28043,10,12520,0),(28044,2,12521,0),(28045,10,12521,0),(28046,2,12522,0),(28047,10,12522,0),(28048,2,12523,0),(28049,10,12523,0),(28050,2,12524,0),(28051,10,12524,0),(28052,2,12525,0),(28053,10,12525,0),(28054,2,12526,0),(28055,10,12526,0),(28056,2,12527,0),(28057,10,12527,0),(28058,2,12528,0),(28059,10,12528,0),(28060,2,12529,0),(28061,10,12529,0),(28062,2,12530,0),(28063,10,12530,0),(28064,2,12531,0),(28065,10,12531,0),(28066,2,12532,0),(28067,10,12532,0),(28068,2,12533,0),(28069,10,12533,0),(28070,2,12534,0),(28071,10,12534,0),(28072,2,12535,0),(28073,10,12535,0),(28074,2,12536,0),(28075,10,12536,0),(28076,2,12537,0),(28077,10,12537,0),(28078,2,12538,0),(28079,10,12538,0),(28080,2,12539,0),(28081,10,12539,0),(28082,2,12540,0),(28083,10,12540,0),(28084,2,12541,0),(28085,10,12541,0),(28086,2,12542,0),(28087,10,12542,0),(28088,2,12543,0),(28089,10,12543,0),(28090,2,12544,0),(28091,10,12544,0),(28092,2,12545,0),(28093,10,12545,0),(28094,2,12546,0),(28095,10,12546,0),(28096,2,12547,0),(28097,10,12547,0),(28098,2,12548,0),(28099,10,12548,0),(28100,2,12549,0),(28101,10,12549,0),(28102,2,12550,0),(28103,10,12550,0),(28104,2,12551,0),(28105,10,12551,0),(28106,2,12552,0),(28107,10,12552,0),(28108,2,12553,0),(28109,10,12553,0),(28110,2,12554,0),(28111,10,12554,0),(28112,2,12555,0),(28113,10,12555,0),(28114,2,12556,0),(28115,10,12556,0),(28116,2,12557,0),(28117,10,12557,0),(28118,2,12558,0),(28119,10,12558,0),(28120,2,12559,0),(28121,10,12559,0),(28122,2,12560,0),(28123,10,12560,0),(28124,2,12561,0),(28125,10,12561,0),(28126,2,12562,0),(28127,10,12562,0),(28128,2,12563,0),(28129,10,12563,0),(28130,2,12564,0),(28131,10,12564,0),(28132,2,12565,0),(28133,10,12565,0),(28134,2,12566,0),(28135,10,12566,0),(28136,2,12567,0),(28137,10,12567,0),(28138,2,12568,0),(28139,10,12568,0),(28140,2,12569,0),(28141,10,12569,0),(28142,2,12570,0),(28143,10,12570,0),(28144,2,12571,0),(28145,10,12571,0),(28146,2,12572,0),(28147,10,12572,0),(28148,2,12573,0),(28149,10,12573,0),(28150,2,12574,0),(28151,10,12574,0),(28152,2,12575,0),(28153,10,12575,0),(28154,2,12576,0),(28155,10,12576,0),(28156,2,12577,0),(28157,10,12577,0),(28158,2,12578,0),(28159,10,12578,0),(28160,2,12579,0),(28161,10,12579,0),(28162,2,12580,0),(28163,10,12580,0),(28164,2,12581,0),(28165,10,12581,0),(28166,2,12582,0),(28167,10,12582,0),(28168,2,12583,0),(28169,10,12583,0),(28170,2,12584,0),(28171,10,12584,0),(28172,2,12585,0),(28173,10,12585,0),(28174,2,12586,0),(28175,10,12586,0),(28176,2,12587,0),(28177,10,12587,0),(28178,2,12588,0),(28179,10,12588,0),(28180,2,12589,0),(28181,10,12589,0),(28182,2,12590,0),(28183,10,12590,0),(28184,2,12591,0),(28185,10,12591,0),(28186,2,12592,0),(28187,10,12592,0),(28188,2,12593,0),(28189,10,12593,0),(28190,2,12594,0),(28191,10,12594,0),(28192,2,12595,0),(28193,10,12595,0),(28194,2,12596,0),(28195,10,12596,0),(28196,2,12597,0),(28197,10,12597,0),(28198,2,12598,0),(28199,10,12598,0),(28200,2,12599,0),(28201,10,12599,0),(28202,2,12600,0),(28203,10,12600,0),(28204,2,12601,0),(28205,10,12601,0),(28206,2,12602,0),(28207,10,12602,0),(28208,2,12603,0),(28209,10,12603,0),(28210,2,12604,0),(28211,10,12604,0),(28212,2,12605,0),(28213,10,12605,0),(28214,2,12606,0),(28215,10,12606,0),(28216,2,12607,0),(28217,10,12607,0),(28218,2,12608,0),(28219,10,12608,0),(28220,2,12609,0),(28221,10,12609,0),(28222,2,12610,0),(28223,10,12610,0),(28224,2,12611,0),(28225,10,12611,0),(28226,2,12612,0),(28227,10,12612,0),(28228,2,12613,0),(28229,10,12613,0),(28230,2,12614,0),(28231,10,12614,0),(28232,2,12615,0),(28233,10,12615,0),(28234,2,12616,0),(28235,10,12616,0),(28236,2,12617,0),(28237,10,12617,0),(28238,2,12618,0),(28239,10,12618,0),(28240,2,12619,0),(28241,10,12619,0),(28242,2,12620,0),(28243,10,12620,0),(28244,2,12621,0),(28245,10,12621,0),(28246,2,12622,0),(28247,10,12622,0),(28248,2,12623,0),(28249,10,12623,0),(28250,2,12624,0),(28251,10,12624,0),(28252,2,12625,0),(28253,10,12625,0),(28254,2,12626,0),(28255,10,12626,0),(28256,2,12627,0),(28257,10,12627,0),(28258,2,12628,0),(28259,10,12628,0),(28260,2,12629,0),(28261,10,12629,0),(28262,2,12630,0),(28263,10,12630,0),(28264,2,12631,0),(28265,10,12631,0),(28266,2,12632,0),(28267,10,12632,0),(28268,2,12633,0),(28269,10,12633,0),(28270,2,12634,0),(28271,10,12634,0),(28272,2,12635,0),(28273,10,12635,0),(28274,2,12636,0),(28275,10,12636,0),(28276,2,12637,0),(28277,10,12637,0),(28278,2,12638,0),(28279,10,12638,0),(28280,2,12639,0),(28281,10,12639,0),(28282,2,12640,0),(28283,10,12640,0),(28284,2,12641,0),(28285,10,12641,0),(28286,2,12642,0),(28287,10,12642,0),(28288,2,12643,0),(28289,10,12643,0),(28290,2,12644,0),(28291,10,12644,0),(28292,2,12645,0),(28293,10,12645,0),(28294,2,12646,0),(28295,10,12646,0),(28296,2,12647,0),(28297,10,12647,0),(28298,2,12648,0),(28299,10,12648,0),(28300,2,12649,0),(28301,10,12649,0),(28302,2,12650,0),(28303,10,12650,0),(28304,2,12651,0),(28305,10,12651,0),(28306,2,12652,0),(28307,10,12652,0),(28308,2,12653,0),(28309,10,12653,0),(28310,2,12654,0),(28311,10,12654,0),(28312,2,12655,0),(28313,10,12655,0),(28314,2,12656,0),(28315,10,12656,0),(28316,2,12657,0),(28317,10,12657,0),(28318,2,12658,0),(28319,10,12658,0),(28320,2,12659,0),(28321,10,12659,0),(28322,2,12660,0),(28323,10,12660,0),(28324,2,12661,0),(28325,10,12661,0),(28326,2,12662,0),(28327,10,12662,0),(28328,2,12663,0),(28329,10,12663,0),(28330,2,12664,0),(28331,10,12664,0),(28332,2,12665,0),(28333,10,12665,0),(28334,2,12666,0),(28335,10,12666,0),(28336,2,12667,0),(28337,10,12667,0),(28338,2,12668,0),(28339,10,12668,0),(28340,2,12669,0),(28341,10,12669,0),(28342,2,12670,0),(28343,10,12670,0),(28344,2,12671,0),(28345,10,12671,0),(28346,2,12672,0),(28347,10,12672,0),(28348,2,12673,0),(28349,10,12673,0),(28350,2,12674,0),(28351,10,12674,0),(28352,2,12675,0),(28353,10,12675,0),(28354,2,12676,0),(28355,10,12676,0),(28356,2,12677,0),(28357,10,12677,0),(28358,2,12678,0),(28359,10,12678,0),(28360,2,12679,0),(28361,10,12679,0),(28362,2,12680,0),(28363,10,12680,0),(28364,2,12681,0),(28365,10,12681,0),(28366,2,12682,0),(28367,10,12682,0),(28368,2,12683,0),(28369,10,12683,0),(28370,2,12684,0),(28371,10,12684,0),(28372,2,12685,0),(28373,10,12685,0),(28374,2,12686,0),(28375,10,12686,0),(28376,2,12687,0),(28377,10,12687,0),(28378,2,12688,0),(28379,10,12688,0),(28380,2,12689,0),(28381,10,12689,0),(28382,2,12690,0),(28383,10,12690,0),(28384,2,12691,0),(28385,10,12691,0),(28386,2,12692,0),(28387,10,12692,0),(28388,2,12693,0),(28389,10,12693,0),(28390,2,12694,0),(28391,10,12694,0),(28392,2,12695,0),(28393,10,12695,0),(28394,2,12696,0),(28395,10,12696,0),(28396,2,12697,0),(28397,10,12697,0),(28398,2,12698,0),(28399,10,12698,0),(28400,2,12699,0),(28401,10,12699,0),(28402,2,12700,0),(28403,10,12700,0),(28404,2,12701,0),(28405,10,12701,0),(28406,2,12702,0),(28407,10,12702,0),(28408,2,12703,0),(28409,10,12703,0),(28410,2,12704,0),(28411,10,12704,0),(28412,2,12705,0),(28413,10,12705,0),(28414,2,12706,0),(28415,10,12706,0),(28416,2,12707,0),(28417,10,12707,0),(28418,2,12708,0),(28419,10,12708,0),(28420,2,12709,0),(28421,10,12709,0),(28422,2,12710,0),(28423,10,12710,0),(28424,2,12711,0),(28425,10,12711,0),(28426,2,12712,0),(28427,10,12712,0),(28428,2,12713,0),(28429,10,12713,0),(28430,2,12714,0),(28431,10,12714,0),(28432,2,12715,0),(28433,10,12715,0),(28434,2,12716,0),(28435,10,12716,0),(28436,2,12717,0),(28437,10,12717,0),(28438,2,12718,0),(28439,10,12718,0),(28440,2,12719,0),(28441,10,12719,0),(28442,2,12720,0),(28443,10,12720,0),(28444,2,12721,0),(28445,10,12721,0),(28446,2,12722,0),(28447,10,12722,0),(28448,2,12723,0),(28449,10,12723,0),(28450,2,12724,0),(28451,10,12724,0),(28452,2,12725,0),(28453,10,12725,0),(28454,2,12726,0),(28455,10,12726,0),(28456,2,12727,0),(28457,10,12727,0),(28458,2,12728,0),(28459,10,12728,0),(28460,2,12729,0),(28461,10,12729,0),(28462,2,12730,0),(28463,10,12730,0),(28464,2,12731,0),(28465,10,12731,0),(28466,2,12732,0),(28467,10,12732,0),(28468,2,12733,0),(28469,10,12733,0),(28470,2,12734,0),(28471,10,12734,0),(28472,2,12735,0),(28473,10,12735,0),(28474,2,12736,0),(28475,10,12736,0),(28476,2,12737,0),(28477,10,12737,0),(28478,2,12738,0),(28479,10,12738,0),(28480,2,12739,0),(28481,10,12739,0),(28482,2,12740,0),(28483,10,12740,0),(28484,2,12741,0),(28485,10,12741,0),(28486,2,12742,0),(28487,10,12742,0),(28488,2,12743,0),(28489,10,12743,0),(28490,2,12744,0),(28491,10,12744,0),(28492,2,12745,0),(28493,10,12745,0),(28494,2,12746,0),(28495,10,12746,0),(28496,2,12747,0),(28497,10,12747,0),(28498,2,12748,0),(28499,10,12748,0),(28500,2,12749,0),(28501,10,12749,0),(28502,2,12750,0),(28503,10,12750,0),(28504,2,12751,0),(28505,10,12751,0),(28506,2,12752,0),(28507,10,12752,0),(28508,2,12753,0),(28509,10,12753,0),(28510,2,12754,0),(28511,10,12754,0),(28512,2,12755,0),(28513,10,12755,0),(28514,2,12756,0),(28515,10,12756,0),(28516,2,12757,0),(28517,10,12757,0),(28518,2,12758,0),(28519,10,12758,0),(28520,2,12759,0),(28521,10,12759,0),(28522,2,12760,0),(28523,10,12760,0),(28524,2,12761,0),(28525,10,12761,0),(28526,2,12762,0),(28527,10,12762,0),(28528,2,12763,0),(28529,10,12763,0),(28530,2,12764,0),(28531,10,12764,0),(28532,2,12765,0),(28533,10,12765,0),(28534,2,12766,0),(28535,10,12766,0),(28536,2,12767,0),(28537,10,12767,0),(28538,2,12768,0),(28539,10,12768,0),(28540,2,12769,0),(28541,10,12769,0),(28542,2,12770,0),(28543,10,12770,0),(28544,2,12771,0),(28545,10,12771,0),(28546,2,12772,0),(28547,10,12772,0),(28548,2,12773,0),(28549,10,12773,0),(28550,2,12774,0),(28551,10,12774,0),(28552,2,12775,0),(28553,10,12775,0),(28554,2,12776,0),(28555,10,12776,0),(28556,2,12777,0),(28557,10,12777,0),(28558,2,12778,0),(28559,10,12778,0),(28560,2,12779,0),(28561,10,12779,0),(28562,2,12780,0),(28563,10,12780,0),(28564,2,12781,0),(28565,10,12781,0),(28566,2,12782,0),(28567,10,12782,0),(28568,2,12783,0),(28569,10,12783,0),(28570,2,12784,0),(28571,10,12784,0),(28572,2,12785,0),(28573,10,12785,0),(28574,2,12786,0),(28575,10,12786,0),(28576,2,12787,0),(28577,10,12787,0),(28578,2,12788,0),(28579,10,12788,0),(28580,2,12789,0),(28581,10,12789,0),(28582,2,12790,0),(28583,10,12790,0),(28584,2,12791,0),(28585,10,12791,0),(28586,2,12792,0),(28587,10,12792,0),(28588,2,12793,0),(28589,10,12793,0),(28590,2,12794,0),(28591,10,12794,0),(28592,2,12795,0),(28593,10,12795,0),(28594,2,12796,0),(28595,10,12796,0),(28596,2,12797,0),(28597,10,12797,0),(28598,2,12798,0),(28599,10,12798,0),(28600,2,12799,0),(28601,10,12799,0),(28602,2,12800,0),(28603,10,12800,0),(28604,2,12801,0),(28605,10,12801,0),(28606,2,12802,0),(28607,10,12802,0),(28608,2,12803,0),(28609,10,12803,0),(28610,2,12804,0),(28611,10,12804,0),(28612,2,12805,0),(28613,10,12805,0),(28614,2,12806,0),(28615,10,12806,0),(28616,2,12807,0),(28617,10,12807,0),(28618,2,12808,0),(28619,10,12808,0),(28620,2,12809,0),(28621,10,12809,0),(28622,2,12810,0),(28623,10,12810,0),(28624,2,12811,0),(28625,10,12811,0),(28626,2,12812,0),(28627,10,12812,0),(28628,2,12813,0),(28629,10,12813,0),(28630,2,12814,0),(28631,10,12814,0),(28632,2,12815,0),(28633,10,12815,0),(28634,2,12816,0),(28635,10,12816,0),(28636,2,12817,0),(28637,10,12817,0),(28638,2,12818,0),(28639,10,12818,0),(28640,2,12819,0),(28641,10,12819,0),(28642,2,12820,0),(28643,10,12820,0),(28644,2,12821,0),(28645,10,12821,0),(28646,2,12822,0),(28647,10,12822,0),(28648,2,12823,0),(28649,10,12823,0),(28650,2,12824,0),(28651,10,12824,0),(28652,2,12825,0),(28653,10,12825,0),(28654,2,12826,0),(28655,10,12826,0),(28656,2,12827,0),(28657,10,12827,0),(28658,2,12828,0),(28659,10,12828,0),(28660,2,12829,0),(28661,10,12829,0),(28662,2,12830,0),(28663,10,12830,0),(28664,2,12831,0),(28665,10,12831,0),(28666,2,12832,0),(28667,10,12832,0),(28668,2,12833,0),(28669,10,12833,0),(28670,2,12834,0),(28671,10,12834,0),(28672,2,12835,0),(28673,10,12835,0),(28674,2,12836,0),(28675,10,12836,0),(28676,2,12837,0),(28677,10,12837,0),(28678,2,12838,0),(28679,10,12838,0),(28680,2,12839,0),(28681,10,12839,0),(28682,2,12840,0),(28683,10,12840,0),(28684,2,12841,0),(28685,10,12841,0),(28686,2,12842,0),(28687,10,12842,0),(28688,2,12843,0),(28689,10,12843,0),(28690,2,12844,0),(28691,10,12844,0),(28692,2,12845,0),(28693,10,12845,0),(28694,2,12846,0),(28695,10,12846,0),(28696,2,12847,0),(28697,10,12847,0),(28698,2,12848,0),(28699,10,12848,0),(28700,2,12849,0),(28701,10,12849,0),(28702,2,12850,0),(28703,10,12850,0),(28704,2,12851,0),(28705,10,12851,0),(28706,2,12852,0),(28707,10,12852,0),(28708,2,12853,0),(28709,10,12853,0),(28710,2,12854,0),(28711,10,12854,0),(28712,2,12855,0),(28713,10,12855,0),(28714,2,12856,0),(28715,10,12856,0),(28716,2,12857,0),(28717,10,12857,0),(28718,2,12858,0),(28719,10,12858,0),(28720,2,12859,0),(28721,10,12859,0),(28722,2,12860,0),(28723,10,12860,0),(28724,2,12861,0),(28725,10,12861,0),(28726,2,12862,0),(28727,10,12862,0),(28728,2,12863,0),(28729,10,12863,0),(28730,2,12864,0),(28731,10,12864,0),(28732,2,12865,0),(28733,10,12865,0),(28734,2,12866,0),(28735,10,12866,0),(28736,2,12867,0),(28737,10,12867,0),(28738,2,12868,0),(28739,10,12868,0),(28740,2,12869,0),(28741,10,12869,0),(28742,2,12870,0),(28743,10,12870,0),(28744,2,12871,0),(28745,10,12871,0),(28746,2,12872,0),(28747,10,12872,0),(28748,2,12873,0),(28749,10,12873,0),(28750,2,12874,0),(28751,10,12874,0),(28752,2,12875,0),(28753,10,12875,0),(28754,2,12876,0),(28755,10,12876,0),(28756,2,12877,0),(28757,10,12877,0),(28758,2,12878,0),(28759,10,12878,0),(28760,2,12879,0),(28761,10,12879,0),(28762,2,12880,0),(28763,10,12880,0),(28764,2,12881,0),(28765,10,12881,0),(28766,2,12882,0),(28767,10,12882,0),(28768,2,12883,0),(28769,10,12883,0),(28770,2,12884,0),(28771,10,12884,0),(28772,2,12885,0),(28773,10,12885,0),(28774,2,12886,0),(28775,10,12886,0),(28776,2,12887,0),(28777,10,12887,0),(28778,2,12888,0),(28779,10,12888,0),(28780,2,12889,0),(28781,10,12889,0),(28782,2,12890,0),(28783,10,12890,0),(28784,2,12891,0),(28785,10,12891,0),(28786,2,12892,0),(28787,10,12892,0),(28788,2,12893,0),(28789,10,12893,0),(28790,2,12894,0),(28791,10,12894,0),(28792,2,12895,0),(28793,10,12895,0),(28794,2,12896,0),(28795,10,12896,0),(28796,2,12897,0),(28797,10,12897,0),(28798,2,12898,0),(28799,10,12898,0),(28800,2,12899,0),(28801,10,12899,0),(28802,2,12900,0),(28803,10,12900,0),(28804,2,12901,0),(28805,10,12901,0),(28806,2,12902,0),(28807,10,12902,0),(28808,2,12903,0),(28809,10,12903,0),(28810,2,12904,0),(28811,10,12904,0),(28812,2,12905,0),(28813,10,12905,0),(28814,2,12906,0),(28815,10,12906,0),(28816,2,12907,0),(28817,10,12907,0),(28818,2,12908,0),(28819,10,12908,0),(28820,2,12909,0),(28821,10,12909,0),(28822,2,12910,0),(28823,10,12910,0),(28824,2,12911,0),(28825,10,12911,0),(28826,2,12912,0),(28827,10,12912,0),(28828,2,12913,0),(28829,10,12913,0),(28830,2,12914,0),(28831,10,12914,0),(28832,2,12915,0),(28833,10,12915,0),(28834,2,12916,0),(28835,10,12916,0),(28836,2,12917,0),(28837,10,12917,0),(28838,2,12918,0),(28839,10,12918,0),(28840,2,12919,0),(28841,10,12919,0),(28842,2,12920,0),(28843,10,12920,0),(28844,2,12921,0),(28845,10,12921,0),(28846,2,12922,0),(28847,10,12922,0),(28848,2,12923,0),(28849,10,12923,0),(28850,2,12924,0),(28851,10,12924,0),(28852,2,12925,0),(28853,10,12925,0),(28854,2,12926,0),(28855,10,12926,0),(28856,2,12927,0),(28857,10,12927,0),(28858,2,12928,0),(28859,10,12928,0),(28860,2,12929,0),(28861,10,12929,0),(28862,2,12930,0),(28863,10,12930,0),(28864,2,12931,0),(28865,10,12931,0),(28866,2,12932,0),(28867,10,12932,0),(28868,2,12933,0),(28869,10,12933,0),(28870,2,12934,0),(28871,10,12934,0),(28872,2,12935,0),(28873,10,12935,0),(28874,2,12936,0),(28875,10,12936,0),(28876,2,12937,0),(28877,10,12937,0),(28878,2,12938,0),(28879,10,12938,0),(28880,2,12939,0),(28881,10,12939,0),(28882,2,12940,0),(28883,10,12940,0),(28884,2,12941,0),(28885,10,12941,0),(28886,2,12942,0),(28887,10,12942,0),(28888,2,12943,0),(28889,10,12943,0),(28890,2,12944,0),(28891,10,12944,0),(28892,2,12945,0),(28893,10,12945,0),(28894,2,12946,0),(28895,10,12946,0),(28896,2,12947,0),(28897,10,12947,0),(28898,2,12948,0),(28899,10,12948,0),(28900,2,12949,0),(28901,10,12949,0),(28902,2,12950,0),(28903,10,12950,0),(28904,2,12951,0),(28905,10,12951,0),(28906,2,12952,0),(28907,10,12952,0),(28908,2,12953,0),(28909,10,12953,0),(28910,2,12954,0),(28911,10,12954,0),(28912,2,12955,0),(28913,10,12955,0),(28914,2,12956,0),(28915,10,12956,0),(28916,2,12957,0),(28917,10,12957,0),(28918,2,12958,0),(28919,10,12958,0),(28920,2,12959,0),(28921,10,12959,0),(28922,2,12960,0),(28923,10,12960,0),(28924,2,12961,0),(28925,10,12961,0),(28926,2,12962,0),(28927,10,12962,0),(28928,2,12963,0),(28929,10,12963,0),(28930,2,12964,0),(28931,10,12964,0),(28932,2,12965,0),(28933,10,12965,0),(28934,2,12966,0),(28935,10,12966,0),(28936,2,12967,0),(28937,10,12967,0),(28938,2,12968,0),(28939,10,12968,0),(28940,2,12969,0),(28941,10,12969,0),(28942,2,12970,0),(28943,10,12970,0),(28944,2,12971,0),(28945,10,12971,0),(28946,2,12972,0),(28947,10,12972,0),(28948,2,12973,0),(28949,10,12973,0),(28950,2,12974,0),(28951,10,12974,0),(28952,2,12975,0),(28953,10,12975,0),(28954,2,12976,0),(28955,10,12976,0),(28956,2,12977,0),(28957,10,12977,0),(28958,2,12978,0),(28959,10,12978,0),(28960,2,12979,0),(28961,10,12979,0),(28962,2,12980,0),(28963,10,12980,0),(28964,2,12981,0),(28965,10,12981,0),(28966,2,12982,0),(28967,10,12982,0),(28968,2,12983,0),(28969,10,12983,0),(28970,2,12984,0),(28971,10,12984,0),(28972,2,12985,0),(28973,10,12985,0),(28974,2,12986,0),(28975,10,12986,0),(28976,2,12987,0),(28977,10,12987,0),(28978,2,12988,0),(28979,10,12988,0),(28980,2,12989,0),(28981,10,12989,0),(28982,2,12990,0),(28983,10,12990,0),(28984,2,12991,0),(28985,10,12991,0),(28986,2,12992,0),(28987,10,12992,0),(28988,2,12993,0),(28989,10,12993,0),(28990,2,12994,0),(28991,10,12994,0),(28992,2,12995,0),(28993,10,12995,0),(28994,2,12996,0),(28995,10,12996,0),(28996,2,12997,0),(28997,10,12997,0),(28998,2,12998,0),(28999,10,12998,0),(29000,2,12999,0),(29001,10,12999,0),(29002,2,13000,0),(29003,10,13000,0),(29004,2,13001,0),(29005,10,13001,0),(29006,2,13002,0),(29007,10,13002,0),(29008,2,13003,0),(29009,10,13003,0),(29010,2,13004,0),(29011,10,13004,0),(29012,2,13005,0),(29013,10,13005,0),(29014,2,13006,0),(29015,10,13006,0),(29016,2,13007,0),(29017,10,13007,0),(29018,2,13008,0),(29019,10,13008,0),(29020,2,13009,0),(29021,10,13009,0),(29022,2,13010,0),(29023,10,13010,0),(29024,2,13011,0),(29025,10,13011,0),(29026,2,13012,0),(29027,10,13012,0),(29028,2,13013,0),(29029,10,13013,0),(29030,2,13014,0),(29031,10,13014,0),(29032,2,13015,0),(29033,10,13015,0),(29034,2,13016,0),(29035,10,13016,0),(29036,2,13017,0),(29037,10,13017,0),(29038,2,13018,0),(29039,10,13018,0),(29040,2,13019,0),(29041,10,13019,0),(29042,2,13020,0),(29043,10,13020,0),(29044,2,13021,0),(29045,10,13021,0),(29046,2,13022,0),(29047,10,13022,0),(29048,2,13023,0),(29049,10,13023,0),(29050,2,13024,0),(29051,10,13024,0),(29052,2,13025,0),(29053,10,13025,0),(29054,2,13026,0),(29055,10,13026,0),(29056,2,13027,0),(29057,10,13027,0),(29058,2,13028,0),(29059,10,13028,0),(29060,2,13029,0),(29061,10,13029,0),(29062,2,13030,0),(29063,10,13030,0),(29064,2,13031,0),(29065,10,13031,0),(29066,2,13032,0),(29067,10,13032,0),(29068,2,13033,0),(29069,10,13033,0),(29070,2,13034,0),(29071,10,13034,0),(29072,2,13035,0),(29073,10,13035,0),(29074,2,13036,0),(29075,10,13036,0),(29076,2,13037,0),(29077,10,13037,0),(29078,2,13038,0),(29079,10,13038,0),(29080,2,13039,0),(29081,10,13039,0),(29082,2,13040,0),(29083,10,13040,0),(29084,2,13041,0),(29085,10,13041,0),(29086,2,13042,0),(29087,10,13042,0),(29088,2,13043,0),(29089,10,13043,0),(29090,2,13044,0),(29091,10,13044,0),(29092,2,13045,0),(29093,10,13045,0),(29094,2,13046,0),(29095,10,13046,0),(29096,2,13047,0),(29097,10,13047,0),(29098,2,13048,0),(29099,10,13048,0),(29100,2,13049,0),(29101,10,13049,0),(29102,2,13050,0),(29103,10,13050,0),(29104,2,13051,0),(29105,10,13051,0),(29106,2,13052,0),(29107,10,13052,0),(29108,2,13053,0),(29109,10,13053,0),(29110,2,13054,0),(29111,10,13054,0),(29112,2,13055,0),(29113,10,13055,0),(29114,2,13056,0),(29115,10,13056,0),(29116,2,13057,0),(29117,10,13057,0),(29118,2,13058,0),(29119,10,13058,0),(29120,2,13059,0),(29121,10,13059,0),(29122,2,13060,0),(29123,10,13060,0),(29124,2,13061,0),(29125,10,13061,0),(29126,2,13062,0),(29127,10,13062,0),(29128,2,13063,0),(29129,10,13063,0),(29130,2,13064,0),(29131,10,13064,0),(29132,2,13065,0),(29133,10,13065,0),(29134,2,13066,0),(29135,10,13066,0),(29136,2,13067,0),(29137,10,13067,0),(29138,2,13068,0),(29139,10,13068,0),(29140,2,13069,0),(29141,10,13069,0),(29142,2,13070,0),(29143,10,13070,0),(29144,2,13071,0),(29145,10,13071,0),(29146,2,13072,0),(29147,10,13072,0),(29148,2,13073,0),(29149,10,13073,0),(29150,2,13074,0),(29151,10,13074,0),(29152,2,13075,0),(29153,10,13075,0),(29154,2,13076,0),(29155,10,13076,0),(29156,2,13077,0),(29157,10,13077,0),(29158,2,13078,0),(29159,10,13078,0),(29160,2,13079,0),(29161,10,13079,0),(29162,2,13080,0),(29163,10,13080,0),(29164,2,13081,0),(29165,10,13081,0),(29166,2,13082,0),(29167,10,13082,0),(29168,2,13083,0),(29169,10,13083,0),(29170,2,13084,0),(29171,10,13084,0),(29172,2,13085,0),(29173,10,13085,0),(29174,2,13086,0),(29175,10,13086,0),(29176,2,13087,0),(29177,10,13087,0),(29178,2,13088,0),(29179,10,13088,0),(29180,2,13089,0),(29181,10,13089,0),(29182,2,13090,0),(29183,10,13090,0),(29184,2,13091,0),(29185,10,13091,0),(29186,2,13092,0),(29187,10,13092,0),(29188,2,13093,0),(29189,10,13093,0),(29190,2,13094,0),(29191,10,13094,0),(29192,2,13095,0),(29193,10,13095,0),(29194,2,13096,0),(29195,10,13096,0),(29196,2,13097,0),(29197,10,13097,0),(29198,2,13098,0),(29199,10,13098,0),(29200,2,13099,0),(29201,10,13099,0),(29202,2,13100,0),(29203,10,13100,0),(29204,2,13101,0),(29205,10,13101,0),(29206,2,13102,0),(29207,10,13102,0),(29208,2,13103,0),(29209,10,13103,0),(29210,2,13104,0),(29211,10,13104,0),(29212,2,13105,0),(29213,10,13105,0),(29214,2,13106,0),(29215,10,13106,0),(29216,2,13107,0),(29217,10,13107,0),(29218,2,13108,0),(29219,10,13108,0),(29220,2,13109,0),(29221,10,13109,0),(29222,2,13110,0),(29223,10,13110,0),(29224,2,13111,0),(29225,10,13111,0),(29226,2,13112,0),(29227,10,13112,0),(29228,2,13113,0),(29229,10,13113,0),(29230,2,13114,0),(29231,10,13114,0),(29232,2,13115,0),(29233,10,13115,0),(29234,2,13116,0),(29235,10,13116,0),(29236,2,13117,0),(29237,10,13117,0),(29238,2,13118,0),(29239,10,13118,0),(29240,2,13119,0),(29241,10,13119,0),(29242,2,13120,0),(29243,10,13120,0),(29244,2,13121,0),(29245,10,13121,0),(29246,2,13122,0),(29247,10,13122,0),(29248,2,13123,0),(29249,10,13123,0),(29250,2,13124,0),(29251,10,13124,0),(29252,2,13125,0),(29253,10,13125,0),(29254,2,13126,0),(29255,10,13126,0),(29256,2,13127,0),(29257,10,13127,0),(29258,2,13128,0),(29259,10,13128,0),(29260,2,13129,0),(29261,10,13129,0),(29262,2,13130,0),(29263,10,13130,0),(29264,2,13131,0),(29265,10,13131,0),(29266,2,13132,0),(29267,10,13132,0),(29268,2,13133,0),(29269,10,13133,0),(29270,2,13134,0),(29271,10,13134,0),(29272,2,13135,0),(29273,10,13135,0),(29274,2,13136,0),(29275,10,13136,0),(29276,2,13137,0),(29277,10,13137,0),(29278,2,13138,0),(29279,10,13138,0),(29280,2,13139,0),(29281,10,13139,0),(29282,2,13140,0),(29283,10,13140,0),(29284,2,13141,0),(29285,10,13141,0),(29286,2,13142,0),(29287,10,13142,0),(29288,2,13143,0),(29289,10,13143,0),(29290,2,13144,0),(29291,10,13144,0),(29292,2,13145,0),(29293,10,13145,0),(29294,2,13146,0),(29295,10,13146,0),(29296,2,13147,0),(29297,10,13147,0),(29298,2,13148,0),(29299,10,13148,0),(29300,2,13149,0),(29301,10,13149,0),(29302,2,13150,0),(29303,10,13150,0),(29304,2,13151,0),(29305,10,13151,0),(29306,2,13152,0),(29307,10,13152,0),(29308,2,13153,0),(29309,10,13153,0),(29310,2,13154,0),(29311,10,13154,0),(29312,2,13155,0),(29313,10,13155,0),(29314,2,13156,0),(29315,10,13156,0),(29316,2,13157,0),(29317,10,13157,0),(29318,2,13158,0),(29319,10,13158,0),(29320,2,13159,0),(29321,10,13159,0),(29322,2,13160,0),(29323,10,13160,0),(29324,2,13161,0),(29325,10,13161,0),(29326,2,13162,0),(29327,10,13162,0),(29328,2,13163,0),(29329,10,13163,0),(29330,2,13164,0),(29331,10,13164,0),(29332,2,13165,0),(29333,10,13165,0),(29334,2,13166,0),(29335,10,13166,0),(29336,2,13167,0),(29337,10,13167,0),(29338,2,13168,0),(29339,10,13168,0),(29340,2,13169,0),(29341,10,13169,0),(29342,2,13170,0),(29343,10,13170,0),(29344,2,13171,0),(29345,10,13171,0),(29346,2,13172,0),(29347,10,13172,0),(29348,2,13173,0),(29349,10,13173,0),(29350,2,13174,0),(29351,10,13174,0),(29352,2,13175,0),(29353,10,13175,0),(29354,2,13176,0),(29355,10,13176,0),(29356,2,13177,0),(29357,10,13177,0),(29358,2,13178,0),(29359,10,13178,0),(29360,2,13179,0),(29361,10,13179,0),(29362,2,13180,0),(29363,10,13180,0),(29364,2,13181,0),(29365,10,13181,0),(29366,2,13182,0),(29367,10,13182,0),(29368,2,13183,0),(29369,10,13183,0),(29370,2,13184,0),(29371,10,13184,0),(29372,2,13185,0),(29373,10,13185,0),(29374,2,13186,0),(29375,10,13186,0),(29376,2,13187,0),(29377,10,13187,0),(29378,2,13188,0),(29379,10,13188,0),(29380,2,13189,0),(29381,10,13189,0),(29382,2,13190,0),(29383,10,13190,0),(29384,2,13191,0),(29385,10,13191,0),(29386,2,13192,0),(29387,10,13192,0),(29388,2,13193,0),(29389,10,13193,0),(29390,2,13194,0),(29391,10,13194,0),(29392,2,13195,0),(29393,10,13195,0),(29394,2,13196,0),(29395,10,13196,0),(29396,2,13197,0),(29397,10,13197,0),(29398,2,13198,0),(29399,10,13198,0),(29400,2,13199,0),(29401,10,13199,0),(29402,2,13200,0),(29403,10,13200,0),(29404,2,13201,0),(29405,10,13201,0),(29406,2,13202,0),(29407,10,13202,0),(29408,2,13203,0),(29409,10,13203,0),(29410,2,13204,0),(29411,10,13204,0),(29412,2,13205,0),(29413,10,13205,0),(29414,2,13206,0),(29415,10,13206,0),(29416,2,13207,0),(29417,10,13207,0),(29418,2,13208,0),(29419,10,13208,0),(29420,2,13209,0),(29421,10,13209,0),(29422,2,13210,0),(29423,10,13210,0),(29424,2,13211,0),(29425,10,13211,0),(29426,2,13212,0),(29427,10,13212,0),(29428,2,13213,0),(29429,10,13213,0),(29430,2,13214,0),(29431,10,13214,0),(29432,2,13215,0),(29433,10,13215,0),(29434,2,13216,0),(29435,10,13216,0),(29436,2,13217,0),(29437,10,13217,0),(29438,2,13218,0),(29439,10,13218,0),(29440,2,13219,0),(29441,10,13219,0),(29442,2,13220,0),(29443,10,13220,0),(29444,2,13221,0),(29445,10,13221,0),(29446,2,13222,0),(29447,10,13222,0),(29448,2,13223,0),(29449,10,13223,0),(29450,2,13224,0),(29451,10,13224,0),(29452,2,13225,0),(29453,10,13225,0),(29454,2,13226,0),(29455,10,13226,0),(29456,2,13227,0),(29457,10,13227,0),(29458,2,13228,0),(29459,10,13228,0),(29460,2,13229,0),(29461,10,13229,0),(29462,2,13230,0),(29463,10,13230,0),(29464,2,13231,0),(29465,10,13231,0),(29466,2,13232,0),(29467,10,13232,0),(29468,2,13233,0),(29469,10,13233,0),(29470,2,13234,0),(29471,10,13234,0),(29472,2,13235,0),(29473,10,13235,0),(29474,2,13236,0),(29475,10,13236,0),(29476,2,13237,0),(29477,10,13237,0),(29478,2,13238,0),(29479,10,13238,0),(29480,2,13239,0),(29481,10,13239,0),(29482,2,13240,0),(29483,10,13240,0),(29484,2,13241,0),(29485,10,13241,0),(29486,2,13242,0),(29487,10,13242,0),(29488,2,13243,0),(29489,10,13243,0),(29490,2,13244,0),(29491,10,13244,0),(29492,2,13245,0),(29493,10,13245,0),(29494,2,13246,0),(29495,10,13246,0),(29496,2,13247,0),(29497,10,13247,0),(29498,2,13248,0),(29499,10,13248,0),(29500,2,13249,0),(29501,10,13249,0),(29502,2,13250,0),(29503,10,13250,0),(29504,2,13251,0),(29505,10,13251,0),(29506,2,13252,0),(29507,10,13252,0),(29508,2,13253,0),(29509,10,13253,0),(29510,2,13254,0),(29511,10,13254,0),(29512,2,13255,0),(29513,10,13255,0),(29514,2,13256,0),(29515,10,13256,0),(29516,2,13257,0),(29517,10,13257,0),(29518,2,13258,0),(29519,10,13258,0),(29520,2,13259,0),(29521,10,13259,0),(29522,2,13260,0),(29523,10,13260,0),(29524,2,13261,0),(29525,10,13261,0),(29526,2,13262,0),(29527,10,13262,0),(29528,2,13263,0),(29529,10,13263,0),(29530,2,13264,0),(29531,10,13264,0),(29532,2,13265,0),(29533,10,13265,0),(29534,2,13266,0),(29535,10,13266,0),(29536,2,13267,0),(29537,10,13267,0),(29538,2,13268,0),(29539,10,13268,0),(29540,2,13269,0),(29541,10,13269,0),(29542,2,13270,0),(29543,10,13270,0),(29544,2,13271,0),(29545,10,13271,0),(29546,2,13272,0),(29547,10,13272,0),(29548,2,13273,0),(29549,10,13273,0),(29550,2,13274,0),(29551,10,13274,0),(29552,2,13275,0),(29553,10,13275,0),(29554,2,13276,0),(29555,10,13276,0),(29556,2,13277,0),(29557,10,13277,0),(29558,2,13278,0),(29559,10,13278,0),(29560,2,13279,0),(29561,10,13279,0),(29562,2,13280,0),(29563,10,13280,0),(29564,2,13281,0),(29565,10,13281,0),(29566,2,13282,0),(29567,10,13282,0),(29568,2,13283,0),(29569,10,13283,0),(29570,2,13284,0),(29571,10,13284,0),(29572,2,13285,0),(29573,10,13285,0),(29574,2,13286,0),(29575,10,13286,0),(29576,2,13287,0),(29577,10,13287,0),(29578,2,13288,0),(29579,10,13288,0),(29580,2,13289,0),(29581,10,13289,0),(29582,2,13290,0),(29583,10,13290,0),(29584,2,13291,0),(29585,10,13291,0),(29586,2,13292,0),(29587,10,13292,0),(29588,2,13293,0),(29589,10,13293,0),(29590,2,13294,0),(29591,10,13294,0),(29592,2,13295,0),(29593,10,13295,0),(29594,2,13296,0),(29595,10,13296,0),(29596,2,13297,0),(29597,10,13297,0),(29598,2,13298,0),(29599,10,13298,0),(29600,2,13299,0),(29601,10,13299,0),(29602,2,13300,0),(29603,10,13300,0),(29604,2,13301,0),(29605,10,13301,0),(29606,2,13302,0),(29607,10,13302,0),(29608,2,13303,0),(29609,10,13303,0),(29610,2,13304,0),(29611,10,13304,0),(29612,2,13305,0),(29613,10,13305,0),(29614,2,13306,0),(29615,10,13306,0),(29616,2,13307,0),(29617,10,13307,0),(29618,2,13308,0),(29619,10,13308,0),(29620,2,13309,0),(29621,10,13309,0),(29622,2,13310,0),(29623,10,13310,0),(29624,2,13311,0),(29625,10,13311,0),(29626,2,13312,0),(29627,10,13312,0),(29628,2,13313,0),(29629,10,13313,0),(29630,2,13314,0),(29631,10,13314,0),(29632,2,13315,0),(29633,10,13315,0),(29634,2,13316,0),(29635,10,13316,0),(29636,2,13317,0),(29637,10,13317,0),(29638,2,13318,0),(29639,10,13318,0),(29640,2,13319,0),(29641,10,13319,0),(29642,2,13320,0),(29643,10,13320,0),(29644,2,13321,0),(29645,10,13321,0),(29646,2,13322,0),(29647,10,13322,0),(29648,2,13323,0),(29649,10,13323,0),(29650,2,13324,0),(29651,10,13324,0),(29652,2,13325,0),(29653,10,13325,0),(29654,2,13326,0),(29655,10,13326,0),(29656,2,13327,0),(29657,10,13327,0),(29658,2,13328,0),(29659,10,13328,0),(29660,2,13329,0),(29661,10,13329,0),(29662,2,13330,0),(29663,10,13330,0),(29664,2,13331,0),(29665,10,13331,0),(29666,2,13332,0),(29667,10,13332,0),(29668,2,13333,0),(29669,10,13333,0),(29670,2,13334,0),(29671,10,13334,0),(29672,2,13335,0),(29673,10,13335,0),(29674,2,13336,0),(29675,10,13336,0),(29676,2,13337,0),(29677,10,13337,0),(29678,2,13338,0),(29679,10,13338,0),(29680,2,13339,0),(29681,10,13339,0),(29682,2,13340,0),(29683,10,13340,0),(29684,2,13341,0),(29685,10,13341,0),(29686,2,13342,0),(29687,10,13342,0),(29688,2,13343,0),(29689,10,13343,0),(29690,2,13344,0),(29691,10,13344,0),(29692,2,13345,0),(29693,10,13345,0),(29694,2,13346,0),(29695,10,13346,0),(29696,2,13347,0),(29697,10,13347,0),(29698,2,13348,0),(29699,10,13348,0),(29700,2,13349,0),(29701,10,13349,0),(29702,2,13350,0),(29703,10,13350,0),(29704,2,13351,0),(29705,10,13351,0),(29706,2,13352,0),(29707,10,13352,0),(29708,2,13353,0),(29709,10,13353,0),(29710,2,13354,0),(29711,10,13354,0),(29712,2,13355,0),(29713,10,13355,0),(29714,2,13356,0),(29715,10,13356,0),(29716,2,13357,0),(29717,10,13357,0),(29718,2,13358,0),(29719,10,13358,0),(29720,2,13359,0),(29721,10,13359,0),(29722,2,13360,0),(29723,10,13360,0),(29724,2,13361,0),(29725,10,13361,0),(29726,2,13362,0),(29727,10,13362,0),(29728,2,13363,0),(29729,10,13363,0),(29730,2,13364,0),(29731,10,13364,0),(29732,2,13365,0),(29733,10,13365,0),(29734,2,13366,0),(29735,10,13366,0),(29736,2,13367,0),(29737,10,13367,0),(29738,2,13368,0),(29739,10,13368,0),(29740,2,13369,0),(29741,10,13369,0),(29742,2,13370,0),(29743,10,13370,0),(29744,2,13371,0),(29745,10,13371,0),(29746,2,13372,0),(29747,10,13372,0),(29748,2,13373,0),(29749,10,13373,0),(29750,2,13374,0),(29751,10,13374,0),(29752,2,13375,0),(29753,10,13375,0),(29754,2,13376,0),(29755,10,13376,0),(29756,2,13377,0),(29757,10,13377,0),(29758,2,13378,0),(29759,10,13378,0),(29760,2,13379,0),(29761,10,13379,0),(29762,2,13380,0),(29763,10,13380,0),(29764,2,13381,0),(29765,10,13381,0),(29766,2,13382,0),(29767,10,13382,0),(29768,2,13383,0),(29769,10,13383,0),(29770,2,13384,0),(29771,10,13384,0),(29772,2,13385,0),(29773,10,13385,0),(29774,2,13386,0),(29775,10,13386,0),(29776,2,13387,0),(29777,10,13387,0),(29778,2,13388,0),(29779,10,13388,0),(29780,2,13389,0),(29781,10,13389,0),(29782,2,13390,0),(29783,10,13390,0),(29784,2,13391,0),(29785,10,13391,0),(29786,2,13392,0),(29787,10,13392,0),(29788,2,13393,0),(29789,10,13393,0),(29790,2,13394,0),(29791,10,13394,0),(29792,2,13395,0),(29793,10,13395,0),(29794,2,13396,0),(29795,10,13396,0),(29796,2,13397,0),(29797,10,13397,0),(29798,2,13398,0),(29799,10,13398,0),(29800,2,13399,0),(29801,10,13399,0),(29802,2,13400,0),(29803,10,13400,0),(29804,2,13401,0),(29805,10,13401,0),(29806,2,13402,0),(29807,10,13402,0),(29808,2,13403,0),(29809,10,13403,0),(29810,2,13404,0),(29811,10,13404,0),(29812,2,13405,0),(29813,10,13405,0),(29814,2,13406,0),(29815,10,13406,0),(29816,2,13407,0),(29817,10,13407,0),(29818,2,13408,0),(29819,10,13408,0),(29820,2,13409,0),(29821,10,13409,0),(29822,2,13410,0),(29823,10,13410,0),(29824,2,13411,0),(29825,10,13411,0),(29826,2,13412,0),(29827,10,13412,0),(29828,2,13413,0),(29829,10,13413,0),(29830,2,13414,0),(29831,10,13414,0),(29832,2,13415,0),(29833,10,13415,0),(29834,2,13416,0),(29835,10,13416,0),(29836,2,13417,0),(29837,10,13417,0),(29838,2,13418,0),(29839,10,13418,0),(29840,2,13419,0),(29841,10,13419,0),(29842,2,13420,0),(29843,10,13420,0),(29844,2,13421,0),(29845,10,13421,0),(29846,2,13422,0),(29847,10,13422,0),(29848,2,13423,0),(29849,10,13423,0),(29850,2,13424,0),(29851,10,13424,0),(29852,2,13425,0),(29853,10,13425,0),(29854,2,13426,0),(29855,10,13426,0),(29856,2,13427,0),(29857,10,13427,0),(29858,2,13428,0),(29859,10,13428,0),(29860,2,13429,0),(29861,10,13429,0),(29862,2,13430,0),(29863,10,13430,0),(29864,2,13431,0),(29865,10,13431,0),(29866,2,13432,0),(29867,10,13432,0),(29868,2,13433,0),(29869,10,13433,0),(29870,2,13434,0),(29871,10,13434,0),(29872,2,13435,0),(29873,10,13435,0),(29874,2,13436,0),(29875,10,13436,0),(29876,2,13437,0),(29877,10,13437,0),(29878,2,13438,0),(29879,10,13438,0),(29880,2,13439,0),(29881,10,13439,0),(29882,2,13440,0),(29883,10,13440,0),(29884,2,13441,0),(29885,10,13441,0),(29886,2,13442,0),(29887,10,13442,0),(29888,2,13443,0),(29889,10,13443,0),(29890,2,13444,0),(29891,10,13444,0),(29892,2,13445,0),(29893,10,13445,0),(29894,2,13446,0),(29895,10,13446,0),(29896,2,13447,0),(29897,10,13447,0),(29898,2,13448,0),(29899,10,13448,0),(29900,2,13449,0),(29901,10,13449,0),(29902,2,13450,0),(29903,10,13450,0),(29904,2,13451,0),(29905,10,13451,0),(29906,2,13452,0),(29907,10,13452,0),(29908,2,13453,0),(29909,10,13453,0),(29910,2,13454,0),(29911,10,13454,0),(29912,2,13455,0),(29913,10,13455,0),(29914,2,13456,0),(29915,10,13456,0),(29916,2,13457,0),(29917,10,13457,0),(29918,2,13458,0),(29919,10,13458,0),(29920,2,13459,0),(29921,10,13459,0),(29922,2,13460,0),(29923,10,13460,0),(29924,2,13461,0),(29925,10,13461,0),(29926,2,13462,0),(29927,10,13462,0),(29928,2,13463,0),(29929,10,13463,0),(29930,2,13464,0),(29931,10,13464,0),(29932,2,13465,0),(29933,10,13465,0),(29934,2,13466,0),(29935,10,13466,0),(29936,2,13467,0),(29937,10,13467,0),(29938,2,13468,0),(29939,10,13468,0),(29940,2,13469,0),(29941,10,13469,0),(29942,2,13470,0),(29943,10,13470,0),(29944,2,13471,0),(29945,10,13471,0),(29946,2,13472,0),(29947,10,13472,0),(29948,2,13473,0),(29949,10,13473,0),(29950,2,13474,0),(29951,10,13474,0),(29952,2,13475,0),(29953,10,13475,0),(29954,2,13476,0),(29955,10,13476,0),(29956,2,13477,0),(29957,10,13477,0),(29958,2,13478,0),(29959,10,13478,0),(29960,2,13479,0),(29961,10,13479,0),(29962,2,13480,0),(29963,10,13480,0),(29964,2,13481,0),(29965,10,13481,0),(29966,2,13482,0),(29967,10,13482,0),(29968,2,13483,0),(29969,10,13483,0),(29970,2,13484,0),(29971,10,13484,0),(29972,2,13485,0),(29973,10,13485,0),(29974,2,13486,0),(29975,10,13486,0),(29976,2,13487,0),(29977,10,13487,0),(29978,2,13488,0),(29979,10,13488,0),(29980,2,13489,0),(29981,10,13489,0),(29982,2,13490,0),(29983,10,13490,0),(29984,2,13491,0),(29985,10,13491,0),(29986,2,13492,0),(29987,10,13492,0),(29988,2,13493,0),(29989,10,13493,0),(29990,2,13494,0),(29991,10,13494,0),(29992,2,13495,0),(29993,10,13495,0),(29994,2,13496,0),(29995,10,13496,0),(29996,2,13497,0),(29997,10,13497,0),(29998,2,13498,0),(29999,10,13498,0),(30000,2,13499,0),(30001,10,13499,0),(30002,2,13500,0),(30003,10,13500,0),(30004,2,13501,0),(30005,10,13501,0),(30006,2,13502,0),(30007,10,13502,0),(30008,2,13503,0),(30009,10,13503,0),(30010,2,13504,0),(30011,10,13504,0),(30012,2,13505,0),(30013,10,13505,0),(30014,2,13506,0),(30015,10,13506,0),(30016,2,13507,0),(30017,10,13507,0),(30018,2,13508,0),(30019,10,13508,0),(30020,2,13509,0),(30021,10,13509,0),(30022,2,13510,0),(30023,10,13510,0),(30024,2,13511,0),(30025,10,13511,0),(30026,2,13512,0),(30027,10,13512,0),(30028,2,13513,0),(30029,10,13513,0),(30030,2,13514,0),(30031,10,13514,0),(30032,2,13515,0),(30033,10,13515,0),(30034,2,13516,0),(30035,10,13516,0),(30036,2,13517,0),(30037,10,13517,0),(30038,2,13518,0),(30039,10,13518,0),(30040,2,13519,0),(30041,10,13519,0),(30042,2,13520,0),(30043,10,13520,0),(30044,2,13521,0),(30045,10,13521,0),(30046,2,13522,0),(30047,10,13522,0),(30048,2,13523,0),(30049,10,13523,0),(30050,2,13524,0),(30051,10,13524,0),(30052,2,13525,0),(30053,10,13525,0),(30054,2,13526,0),(30055,10,13526,0),(30056,2,13527,0),(30057,10,13527,0),(30058,2,13528,0),(30059,10,13528,0),(30060,2,13529,0),(30061,10,13529,0),(30062,2,13530,0),(30063,10,13530,0),(30064,2,13531,0),(30065,10,13531,0),(30066,2,13532,0),(30067,10,13532,0),(30068,2,13533,0),(30069,10,13533,0),(30070,2,13534,0),(30071,10,13534,0),(30072,2,13535,0),(30073,10,13535,0),(30074,2,13536,0),(30075,10,13536,0),(30076,2,13537,0),(30077,10,13537,0),(30078,2,13538,0),(30079,10,13538,0),(30080,2,13539,0),(30081,10,13539,0),(30082,2,13540,0),(30083,10,13540,0),(30084,2,13541,0),(30085,10,13541,0),(30086,2,13542,0),(30087,10,13542,0),(30088,2,13543,0),(30089,10,13543,0),(30090,2,13544,0),(30091,10,13544,0),(30092,2,13545,0),(30093,10,13545,0),(30094,2,13546,0),(30095,10,13546,0),(30096,2,13547,0),(30097,10,13547,0),(30098,2,13548,0),(30099,10,13548,0),(30100,2,13549,0),(30101,10,13549,0),(30102,2,13550,0),(30103,10,13550,0),(30104,2,13551,0),(30105,10,13551,0),(30106,2,13552,0),(30107,10,13552,0),(30108,2,13553,0),(30109,10,13553,0),(30110,2,13554,0),(30111,10,13554,0),(30112,2,13555,0),(30113,10,13555,0),(30114,2,13556,0),(30115,10,13556,0),(30116,2,13557,0),(30117,10,13557,0),(30118,2,13558,0),(30119,10,13558,0),(30120,2,13559,0),(30121,10,13559,0),(30122,2,13560,0),(30123,10,13560,0),(30124,2,13561,0),(30125,10,13561,0),(30126,2,13562,0),(30127,10,13562,0),(30128,2,13563,0),(30129,10,13563,0),(30130,2,13564,0),(30131,10,13564,0),(30132,2,13565,0),(30133,10,13565,0),(30134,2,13566,0),(30135,10,13566,0),(30136,2,13567,0),(30137,10,13567,0),(30138,2,13568,0),(30139,10,13568,0),(30140,2,13569,0),(30141,10,13569,0),(30142,2,13570,0),(30143,10,13570,0),(30144,2,13571,0),(30145,10,13571,0),(30146,2,13572,0),(30147,10,13572,0),(30148,2,13573,0),(30149,10,13573,0),(30150,2,13574,0),(30151,10,13574,0),(30152,2,13575,0),(30153,10,13575,0),(30154,2,13576,0),(30155,10,13576,0),(30156,2,13577,0),(30157,10,13577,0),(30158,2,13578,0),(30159,10,13578,0),(30160,2,13579,0),(30161,10,13579,0),(30162,2,13580,0),(30163,10,13580,0),(30164,2,13581,0),(30165,10,13581,0),(30166,2,13582,0),(30167,10,13582,0),(30168,2,13583,0),(30169,10,13583,0),(30170,2,13584,0),(30171,10,13584,0),(30172,2,13585,0),(30173,10,13585,0),(30174,2,13586,0),(30175,10,13586,0),(30176,2,13587,0),(30177,10,13587,0),(30178,2,13588,0),(30179,10,13588,0),(30180,2,13589,0),(30181,10,13589,0),(30182,2,13590,0),(30183,10,13590,0),(30184,2,13591,0),(30185,10,13591,0),(30186,2,13592,0),(30187,10,13592,0),(30188,2,13593,0),(30189,10,13593,0),(30190,2,13594,0),(30191,10,13594,0),(30192,2,13595,0),(30193,10,13595,0),(30194,2,13596,0),(30195,10,13596,0),(30196,2,13597,0),(30197,10,13597,0),(30198,2,13598,0),(30199,10,13598,0),(30200,2,13599,0),(30201,10,13599,0),(30202,2,13600,0),(30203,10,13600,0),(30204,2,13601,0),(30205,10,13601,0),(30206,2,13602,0),(30207,10,13602,0),(30208,2,13603,0),(30209,10,13603,0),(30210,2,13604,0),(30211,10,13604,0),(30212,2,13605,0),(30213,10,13605,0),(30214,2,13606,0),(30215,10,13606,0),(30216,2,13607,0),(30217,10,13607,0),(30218,2,13608,0),(30219,10,13608,0),(30220,2,13609,0),(30221,10,13609,0),(30222,2,13610,0),(30223,10,13610,0),(30224,2,13611,0),(30225,10,13611,0),(30226,2,13612,0),(30227,10,13612,0),(30228,2,13613,0),(30229,10,13613,0),(30230,2,13614,0),(30231,10,13614,0),(30232,2,13615,0),(30233,10,13615,0),(30234,2,13616,0),(30235,10,13616,0),(30236,2,13617,0),(30237,10,13617,0),(30238,2,13618,0),(30239,10,13618,0),(30240,2,13619,0),(30241,10,13619,0),(30242,2,13620,0),(30243,10,13620,0),(30244,2,13621,0),(30245,10,13621,0),(30246,2,13622,0),(30247,10,13622,0),(30248,2,13623,0),(30249,10,13623,0),(30250,2,13624,0),(30251,10,13624,0),(30252,2,13625,0),(30253,10,13625,0),(30254,2,13626,0),(30255,10,13626,0),(30256,2,13627,0),(30257,10,13627,0),(30258,2,13628,0),(30259,10,13628,0),(30260,2,13629,0),(30261,10,13629,0),(30262,2,13630,0),(30263,10,13630,0),(30264,2,13631,0),(30265,10,13631,0),(30266,2,13632,0),(30267,10,13632,0),(30268,2,13633,0),(30269,10,13633,0),(30270,2,13634,0),(30271,10,13634,0),(30272,2,13635,0),(30273,10,13635,0),(30274,2,13636,0),(30275,10,13636,0),(30276,2,13637,0),(30277,10,13637,0),(30278,2,13638,0),(30279,10,13638,0),(30280,2,13639,0),(30281,10,13639,0),(30282,2,13640,0),(30283,10,13640,0),(30284,2,13641,0),(30285,10,13641,0),(30286,2,13642,0),(30287,10,13642,0),(30288,2,13643,0),(30289,10,13643,0),(30290,2,13644,0),(30291,10,13644,0),(30292,2,13645,0),(30293,10,13645,0),(30294,2,13646,0),(30295,10,13646,0),(30296,2,13647,0),(30297,10,13647,0),(30298,2,13648,0),(30299,10,13648,0),(30300,2,13649,0),(30301,10,13649,0),(30302,2,13650,0),(30303,10,13650,0),(30304,2,13651,0),(30305,10,13651,0),(30306,2,13652,0),(30307,10,13652,0),(30308,2,13653,0),(30309,10,13653,0),(30310,2,13654,0),(30311,10,13654,0),(30312,2,13655,0),(30313,10,13655,0),(30314,2,13656,0),(30315,10,13656,0),(30316,2,13657,0),(30317,10,13657,0),(30318,2,13658,0),(30319,10,13658,0),(30320,2,13659,0),(30321,10,13659,0),(30322,2,13660,0),(30323,10,13660,0),(30324,2,13661,0),(30325,10,13661,0),(30326,2,13662,0),(30327,10,13662,0),(30328,2,13663,0),(30329,10,13663,0),(30330,2,13664,0),(30331,10,13664,0),(30332,2,13665,0),(30333,10,13665,0),(30334,2,13666,0),(30335,10,13666,0),(30336,2,13667,0),(30337,10,13667,0),(30338,2,13668,0),(30339,10,13668,0),(30340,2,13669,0),(30341,10,13669,0),(30342,2,13670,0),(30343,10,13670,0),(30344,2,13671,0),(30345,10,13671,0),(30346,2,13672,0),(30347,10,13672,0),(30348,2,13673,0),(30349,10,13673,0),(30350,2,13674,0),(30351,10,13674,0),(30352,2,13675,0),(30353,10,13675,0),(30354,2,13676,0),(30355,10,13676,0),(30356,2,13677,0),(30357,10,13677,0),(30358,2,13678,0),(30359,10,13678,0),(30360,2,13679,0),(30361,10,13679,0),(30362,2,13680,0),(30363,10,13680,0),(30364,2,13681,0),(30365,10,13681,0),(30366,2,13682,0),(30367,10,13682,0),(30368,2,13683,0),(30369,10,13683,0),(30370,2,13684,0),(30371,10,13684,0),(30372,2,13685,0),(30373,10,13685,0),(30374,2,13686,0),(30375,10,13686,0),(30376,2,13687,0),(30377,10,13687,0),(30378,2,13688,0),(30379,10,13688,0),(30380,2,13689,0),(30381,10,13689,0),(30382,2,13690,0),(30383,10,13690,0),(30384,2,13691,0),(30385,10,13691,0),(30386,2,13692,0),(30387,10,13692,0),(30388,2,13693,0),(30389,10,13693,0),(30390,2,13694,0),(30391,10,13694,0),(30392,2,13695,0),(30393,10,13695,0),(30394,2,13696,0),(30395,10,13696,0),(30396,2,13697,0),(30397,10,13697,0),(30398,2,13698,0),(30399,10,13698,0),(30400,2,13699,0),(30401,10,13699,0),(30402,2,13700,0),(30403,10,13700,0),(30404,2,13701,0),(30405,10,13701,0),(30406,2,13702,0),(30407,10,13702,0),(30408,2,13703,0),(30409,10,13703,0),(30410,2,13704,0),(30411,10,13704,0),(30412,2,13705,0),(30413,10,13705,0),(30414,2,13706,0),(30415,10,13706,0),(30416,2,13707,0),(30417,10,13707,0),(30418,2,13708,0),(30419,10,13708,0),(30420,2,13709,0),(30421,10,13709,0),(30422,2,13710,0),(30423,10,13710,0),(30424,2,13711,0),(30425,10,13711,0),(30426,2,13712,0),(30427,10,13712,0),(30428,2,13713,0),(30429,10,13713,0),(30430,2,13714,0),(30431,10,13714,0),(30432,2,13715,0),(30433,10,13715,0),(30434,2,13716,0),(30435,10,13716,0),(30436,2,13717,0),(30437,10,13717,0),(30438,2,13718,0),(30439,10,13718,0),(30440,2,13719,0),(30441,10,13719,0),(30442,2,13720,0),(30443,10,13720,0),(30444,2,13721,0),(30445,10,13721,0),(30446,2,13722,0),(30447,10,13722,0),(30448,2,13723,0),(30449,10,13723,0),(30450,2,13724,0),(30451,10,13724,0),(30452,2,13725,0),(30453,10,13725,0),(30454,2,13726,0),(30455,10,13726,0),(30456,2,13727,0),(30457,10,13727,0),(30458,2,13728,0),(30459,10,13728,0),(30460,2,13729,0),(30461,10,13729,0),(30462,2,13730,0),(30463,10,13730,0),(30464,2,13731,0),(30465,10,13731,0),(30466,2,13732,0),(30467,10,13732,0),(30468,2,13733,0),(30469,10,13733,0),(30470,2,13734,0),(30471,10,13734,0),(30472,2,13735,0),(30473,10,13735,0),(30474,2,13736,0),(30475,10,13736,0),(30476,2,13737,0),(30477,10,13737,0),(30478,2,13738,0),(30479,10,13738,0),(30480,2,13739,0),(30481,10,13739,0),(30482,2,13740,0),(30483,10,13740,0),(30484,2,13741,0),(30485,10,13741,0),(30486,2,13742,0),(30487,10,13742,0),(30488,2,13743,0),(30489,10,13743,0),(30490,2,13744,0),(30491,10,13744,0),(30492,2,13745,0),(30493,10,13745,0),(30494,2,13746,0),(30495,10,13746,0),(30496,2,13747,0),(30497,10,13747,0),(30498,2,13748,0),(30499,10,13748,0),(30500,2,13749,0),(30501,10,13749,0),(30502,2,13750,0),(30503,10,13750,0),(30504,2,13751,0),(30505,10,13751,0),(30506,2,13752,0),(30507,10,13752,0),(30508,2,13753,0),(30509,10,13753,0),(30510,2,13754,0),(30511,10,13754,0),(30512,2,13755,0),(30513,10,13755,0),(30514,2,13756,0),(30515,10,13756,0),(30516,2,13757,0),(30517,10,13757,0),(30518,2,13758,0),(30519,10,13758,0),(30520,2,13759,0),(30521,10,13759,0),(30522,2,13760,0),(30523,10,13760,0),(30524,2,13761,0),(30525,10,13761,0),(30526,2,13762,0),(30527,10,13762,0),(30528,2,13763,0),(30529,10,13763,0),(30530,2,13764,0),(30531,10,13764,0),(30532,2,13765,0),(30533,10,13765,0),(30534,2,13766,0),(30535,10,13766,0),(30536,2,13767,0),(30537,10,13767,0),(30538,2,13768,0),(30539,10,13768,0),(30540,2,13769,0),(30541,10,13769,0),(30542,2,13770,0),(30543,10,13770,0),(30544,2,13771,0),(30545,10,13771,0),(30546,2,13772,0),(30547,10,13772,0),(30548,2,13773,0),(30549,10,13773,0),(30550,2,13774,0),(30551,10,13774,0),(30552,2,13775,0),(30553,10,13775,0),(30554,2,13776,0),(30555,10,13776,0),(30556,2,13777,0),(30557,10,13777,0),(30558,2,13778,0),(30559,10,13778,0),(30560,2,13779,0),(30561,10,13779,0),(30562,2,13780,0),(30563,10,13780,0),(30564,2,13781,0),(30565,10,13781,0),(30566,2,13782,0),(30567,10,13782,0),(30568,2,13783,0),(30569,10,13783,0),(30570,2,13784,0),(30571,10,13784,0),(30572,2,13785,0),(30573,10,13785,0),(30574,2,13786,0),(30575,10,13786,0),(30576,2,13787,0),(30577,10,13787,0),(30578,2,13788,0),(30579,10,13788,0),(30580,2,13789,0),(30581,10,13789,0),(30582,2,13790,0),(30583,10,13790,0),(30584,2,13791,0),(30585,10,13791,0),(30586,2,13792,0),(30587,10,13792,0),(30588,2,13793,0),(30589,10,13793,0),(30590,2,13794,0),(30591,10,13794,0),(30592,2,13795,0),(30593,10,13795,0),(30594,2,13796,0),(30595,10,13796,0),(30596,2,13797,0),(30597,10,13797,0),(30598,2,13798,0),(30599,10,13798,0),(30600,2,13799,0),(30601,10,13799,0),(30602,2,13800,0),(30603,10,13800,0),(30604,2,13801,0),(30605,10,13801,0),(30606,2,13802,0),(30607,10,13802,0),(30608,2,13803,0),(30609,10,13803,0),(30610,2,13804,0),(30611,10,13804,0),(30612,2,13805,0),(30613,10,13805,0),(30614,2,13806,0),(30615,10,13806,0),(30616,2,13807,0),(30617,10,13807,0),(30618,2,13808,0),(30619,10,13808,0),(30620,2,13809,0),(30621,10,13809,0),(30622,2,13810,0),(30623,10,13810,0),(30624,2,13811,0),(30625,10,13811,0),(30626,2,13812,0),(30627,10,13812,0),(30628,2,13813,0),(30629,10,13813,0),(30630,2,13814,0),(30631,10,13814,0),(30632,2,13815,0),(30633,10,13815,0),(30634,2,13816,0),(30635,10,13816,0),(30636,2,13817,0),(30637,10,13817,0),(30638,2,13818,0),(30639,10,13818,0),(30640,2,13819,0),(30641,10,13819,0),(30642,2,13820,0),(30643,10,13820,0),(30644,2,13821,0),(30645,10,13821,0),(30646,2,13822,0),(30647,10,13822,0),(30648,2,13823,0),(30649,10,13823,0),(30650,2,13824,0),(30651,10,13824,0),(30652,2,13825,0),(30653,10,13825,0),(30654,2,13826,0),(30655,10,13826,0),(30656,2,13827,0),(30657,10,13827,0),(30658,2,13828,0),(30659,10,13828,0),(30660,2,13829,0),(30661,10,13829,0),(30662,2,13830,0),(30663,10,13830,0),(30664,2,13831,0),(30665,10,13831,0),(30666,2,13832,0),(30667,10,13832,0),(30668,2,13833,0),(30669,10,13833,0),(30670,2,13834,0),(30671,10,13834,0),(30672,2,13835,0),(30673,10,13835,0),(30674,2,13836,0),(30675,10,13836,0),(30676,2,13837,0),(30677,10,13837,0),(30678,2,13838,0),(30679,10,13838,0),(30680,2,13839,0),(30681,10,13839,0),(30682,2,13840,0),(30683,10,13840,0),(30684,2,13841,0),(30685,10,13841,0),(30686,2,13842,0),(30687,10,13842,0),(30688,2,13843,0),(30689,10,13843,0),(30690,2,13844,0),(30691,10,13844,0),(30692,2,13845,0),(30693,10,13845,0),(30694,2,13846,0),(30695,10,13846,0),(30696,2,13847,0),(30697,10,13847,0),(30698,2,13848,0),(30699,10,13848,0),(30700,2,13849,0),(30701,10,13849,0),(30702,2,13850,0),(30703,10,13850,0),(30704,2,13851,0),(30705,10,13851,0),(30706,2,13852,0),(30707,10,13852,0),(30708,2,13853,0),(30709,10,13853,0),(30710,2,13854,0),(30711,10,13854,0),(30712,2,13855,0),(30713,10,13855,0),(30714,2,13856,0),(30715,10,13856,0),(30716,2,13857,0),(30717,10,13857,0),(30718,2,13858,0),(30719,10,13858,0),(30720,2,13859,0),(30721,10,13859,0),(30722,2,13860,0),(30723,10,13860,0),(30724,2,13861,0),(30725,10,13861,0),(30726,2,13862,0),(30727,10,13862,0),(30728,2,13863,0),(30729,10,13863,0),(30730,2,13864,0),(30731,10,13864,0),(30732,2,13865,0),(30733,10,13865,0),(30734,2,13866,0),(30735,10,13866,0),(30736,2,13867,0),(30737,10,13867,0),(30738,2,13868,0),(30739,10,13868,0),(30740,2,13869,0),(30741,10,13869,0),(30742,2,13870,0),(30743,10,13870,0),(30744,2,13871,0),(30745,10,13871,0),(30746,2,13872,0),(30747,10,13872,0),(30748,2,13873,0),(30749,10,13873,0),(30750,2,13874,0),(30751,10,13874,0),(30752,2,13875,0),(30753,10,13875,0),(30754,2,13876,0),(30755,10,13876,0),(30756,2,13877,0),(30757,10,13877,0),(30758,2,13878,0),(30759,10,13878,0),(30760,2,13879,0),(30761,10,13879,0),(30762,2,13880,0),(30763,10,13880,0),(30764,2,13881,0),(30765,10,13881,0),(30766,2,13882,0),(30767,10,13882,0),(30768,2,13883,0),(30769,10,13883,0),(30770,2,13884,0),(30771,10,13884,0),(30772,2,13885,0),(30773,10,13885,0),(30774,2,13886,0),(30775,10,13886,0),(30776,2,13887,0),(30777,10,13887,0),(30778,2,13888,0),(30779,10,13888,0),(30780,2,13889,0),(30781,10,13889,0),(30782,2,13890,0),(30783,10,13890,0),(30784,2,13891,0),(30785,10,13891,0),(30786,2,13892,0),(30787,10,13892,0),(30788,2,13893,0),(30789,10,13893,0),(30790,2,13894,0),(30791,10,13894,0),(30792,2,13895,0),(30793,10,13895,0),(30794,2,13896,0),(30795,10,13896,0),(30796,2,13897,0),(30797,10,13897,0),(30798,2,13898,0),(30799,10,13898,0),(30800,2,13899,0),(30801,10,13899,0),(30802,2,13900,0),(30803,10,13900,0),(30804,2,13901,0),(30805,10,13901,0),(30806,2,13902,0),(30807,10,13902,0),(30808,2,13903,0),(30809,10,13903,0),(30810,2,13904,0),(30811,10,13904,0),(30812,2,13905,0),(30813,10,13905,0),(30814,2,13906,0),(30815,10,13906,0),(30816,2,13907,0),(30817,10,13907,0),(30818,2,13908,0),(30819,10,13908,0),(30820,2,13909,0),(30821,10,13909,0),(30822,2,13910,0),(30823,10,13910,0),(30824,2,13911,0),(30825,10,13911,0),(30826,2,13912,0),(30827,10,13912,0),(30828,2,13913,0),(30829,10,13913,0),(30830,2,13914,0),(30831,10,13914,0),(30832,2,13915,0),(30833,10,13915,0),(30834,2,13916,0),(30835,10,13916,0),(30836,2,13917,0),(30837,10,13917,0),(30838,2,13918,0),(30839,10,13918,0),(30840,2,13919,0),(30841,10,13919,0),(30842,2,13920,0),(30843,10,13920,0),(30844,2,13921,0),(30845,10,13921,0),(30846,2,13922,0),(30847,10,13922,0),(30848,2,13923,0),(30849,10,13923,0),(30850,2,13924,0),(30851,10,13924,0),(30852,2,13925,0),(30853,10,13925,0),(30854,2,13926,0),(30855,10,13926,0),(30856,2,13927,0),(30857,10,13927,0),(30858,2,13928,0),(30859,10,13928,0),(30860,2,13929,0),(30861,10,13929,0),(30862,2,13930,0),(30863,10,13930,0),(30864,2,13931,0),(30865,10,13931,0),(30866,2,13932,0),(30867,10,13932,0),(30868,2,13933,0),(30869,10,13933,0),(30870,2,13934,0),(30871,10,13934,0),(30872,2,13935,0),(30873,10,13935,0),(30874,2,13936,0),(30875,10,13936,0),(30876,2,13937,0),(30877,10,13937,0),(30878,2,13938,0),(30879,10,13938,0),(30880,2,13939,0),(30881,10,13939,0),(30882,2,13940,0),(30883,10,13940,0),(30884,2,13941,0),(30885,10,13941,0),(30886,2,13942,0),(30887,10,13942,0),(30888,2,13943,0),(30889,10,13943,0),(30890,2,13944,0),(30891,10,13944,0),(30892,2,13945,0),(30893,10,13945,0),(30894,2,13946,0),(30895,10,13946,0),(30896,2,13947,0),(30897,10,13947,0),(30898,2,13948,0),(30899,10,13948,0),(30900,2,13949,0),(30901,10,13949,0),(30902,2,13950,0),(30903,10,13950,0),(30904,2,13951,0),(30905,10,13951,0),(30906,2,13952,0),(30907,10,13952,0),(30908,2,13953,0),(30909,10,13953,0),(30910,2,13954,0),(30911,10,13954,0),(30912,2,13955,0),(30913,10,13955,0),(30914,2,13956,0),(30915,10,13956,0),(30916,2,13957,0),(30917,10,13957,0),(30918,2,13958,0),(30919,10,13958,0),(30920,2,13959,0),(30921,10,13959,0),(30922,2,13960,0),(30923,10,13960,0),(30924,2,13961,0),(30925,10,13961,0),(30926,2,13962,0),(30927,10,13962,0),(30928,2,13963,0),(30929,10,13963,0),(30930,2,13964,0),(30931,10,13964,0),(30932,2,13965,0),(30933,10,13965,0),(30934,2,13966,0),(30935,10,13966,0),(30936,2,13967,0),(30937,10,13967,0),(30938,2,13968,0),(30939,10,13968,0),(30940,2,13969,0),(30941,10,13969,0),(30942,2,13970,0),(30943,10,13970,0),(30944,2,13971,0),(30945,10,13971,0),(30946,2,13972,0),(30947,10,13972,0),(30948,2,13973,0),(30949,10,13973,0),(30950,2,13974,0),(30951,10,13974,0),(30952,2,13975,0),(30953,10,13975,0),(30954,2,13976,0),(30955,10,13976,0),(30956,2,13977,0),(30957,10,13977,0),(30958,2,13978,0),(30959,10,13978,0),(30960,2,13979,0),(30961,10,13979,0),(30962,2,13980,0),(30963,10,13980,0),(30964,2,13981,0),(30965,10,13981,0),(30966,2,13982,0),(30967,10,13982,0),(30968,2,13983,0),(30969,10,13983,0),(30970,2,13984,0),(30971,10,13984,0),(30972,2,13985,0),(30973,10,13985,0),(30974,2,13986,0),(30975,10,13986,0),(30976,2,13987,0),(30977,10,13987,0),(30978,2,13988,0),(30979,10,13988,0),(30980,2,13989,0),(30981,10,13989,0),(30982,2,13990,0),(30983,10,13990,0),(30984,2,13991,0),(30985,10,13991,0),(30986,2,13992,0),(30987,10,13992,0),(30988,2,13993,0),(30989,10,13993,0),(30990,2,13994,0),(30991,10,13994,0),(30992,2,13995,0),(30993,10,13995,0),(30994,2,13996,0),(30995,10,13996,0),(30996,2,13997,0),(30997,10,13997,0),(30998,2,13998,0),(30999,10,13998,0),(31000,2,13999,0),(31001,10,13999,0),(31002,2,14000,0),(31003,10,14000,0),(31004,2,14001,0),(31005,10,14001,0),(31006,2,14002,0),(31007,10,14002,0),(31008,2,14003,0),(31009,10,14003,0),(31010,2,14004,0),(31011,10,14004,0),(31012,2,14005,0),(31013,10,14005,0),(31014,2,14006,0),(31015,10,14006,0),(31016,2,14007,0),(31017,10,14007,0),(31018,2,14008,0),(31019,10,14008,0),(31020,2,14009,0),(31021,10,14009,0),(31022,2,14010,0),(31023,10,14010,0),(31024,2,14011,0),(31025,10,14011,0),(31026,2,14012,0),(31027,10,14012,0),(31028,2,14013,0),(31029,10,14013,0),(31030,2,14014,0),(31031,10,14014,0),(31032,2,14015,0),(31033,10,14015,0),(31034,2,14016,0),(31035,10,14016,0),(31036,2,14017,0),(31037,10,14017,0),(31038,2,14018,0),(31039,10,14018,0),(31040,2,14019,0),(31041,10,14019,0),(31042,2,14020,0),(31043,10,14020,0),(31044,2,14021,0),(31045,10,14021,0),(31046,2,14022,0),(31047,10,14022,0),(31048,2,14023,0),(31049,10,14023,0),(31050,2,14024,0),(31051,10,14024,0),(31052,2,14025,0),(31053,10,14025,0),(31054,2,14026,0),(31055,10,14026,0),(31056,2,14027,0),(31057,10,14027,0),(31058,2,14028,0),(31059,10,14028,0),(31060,2,14029,0),(31061,10,14029,0),(31062,2,14030,0),(31063,10,14030,0),(31064,2,14031,0),(31065,10,14031,0),(31066,2,14032,0),(31067,10,14032,0),(31068,2,14033,0),(31069,10,14033,0),(31070,2,14034,0),(31071,10,14034,0),(31072,2,14035,0),(31073,10,14035,0),(31074,2,14036,0),(31075,10,14036,0),(31076,2,14037,0),(31077,10,14037,0),(31078,2,14038,0),(31079,10,14038,0),(31080,2,14039,0),(31081,10,14039,0),(31082,2,14040,0),(31083,10,14040,0),(31084,2,14041,0),(31085,10,14041,0),(31086,2,14042,0),(31087,10,14042,0),(31088,2,14043,0),(31089,10,14043,0),(31090,2,14044,0),(31091,10,14044,0),(31092,2,14045,0),(31093,10,14045,0),(31094,2,14046,0),(31095,10,14046,0),(31096,2,14047,0),(31097,10,14047,0),(31098,2,14048,0),(31099,10,14048,0),(31100,2,14049,0),(31101,10,14049,0),(31102,2,14050,0),(31103,10,14050,0),(31104,2,14051,0),(31105,10,14051,0),(31106,2,14052,0),(31107,10,14052,0),(31108,2,14053,0),(31109,10,14053,0),(31110,2,14054,0),(31111,10,14054,0),(31112,2,14055,0),(31113,10,14055,0),(31114,2,14056,0),(31115,10,14056,0),(31116,2,14057,0),(31117,10,14057,0),(31118,2,14058,0),(31119,10,14058,0),(31120,2,14059,0),(31121,10,14059,0),(31122,2,14060,0),(31123,10,14060,0),(31124,2,14061,0),(31125,10,14061,0),(31126,2,14062,0),(31127,10,14062,0),(31128,2,14063,0),(31129,10,14063,0),(31130,2,14064,0),(31131,10,14064,0),(31132,2,14065,0),(31133,10,14065,0),(31134,2,14066,0),(31135,10,14066,0),(31136,2,14067,0),(31137,10,14067,0),(31138,2,14068,0),(31139,10,14068,0),(31140,2,14069,0),(31141,10,14069,0),(31142,2,14070,0),(31143,10,14070,0),(31144,2,14071,0),(31145,10,14071,0),(31146,2,14072,0),(31147,10,14072,0),(31148,2,14073,0),(31149,10,14073,0),(31150,2,14074,0),(31151,10,14074,0),(31152,2,14075,0),(31153,10,14075,0),(31154,2,14076,0),(31155,10,14076,0),(31156,2,14077,0),(31157,10,14077,0),(31158,2,14078,0),(31159,10,14078,0),(31160,2,14079,0),(31161,10,14079,0),(31162,2,14080,0),(31163,10,14080,0),(31164,2,14081,0),(31165,10,14081,0),(31166,2,14082,0),(31167,10,14082,0),(31168,2,14083,0),(31169,10,14083,0),(31170,2,14084,0),(31171,10,14084,0),(31172,2,14085,0),(31173,10,14085,0),(31174,2,14086,0),(31175,10,14086,0),(31176,2,14087,0),(31177,10,14087,0),(31178,2,14088,0),(31179,10,14088,0),(31180,2,14089,0),(31181,10,14089,0),(31182,2,14090,0),(31183,10,14090,0),(31184,2,14091,0),(31185,10,14091,0),(31186,2,14092,0),(31187,10,14092,0),(31188,2,14093,0),(31189,10,14093,0),(31190,2,14094,0),(31191,10,14094,0),(31192,2,14095,0),(31193,10,14095,0),(31194,2,14096,0),(31195,10,14096,0),(31196,2,14097,0),(31197,10,14097,0),(31198,2,14098,0),(31199,10,14098,0),(31200,2,14099,0),(31201,10,14099,0),(31202,2,14100,0),(31203,10,14100,0),(31204,2,14101,0),(31205,10,14101,0),(31206,2,14102,0),(31207,10,14102,0),(31208,2,14103,0),(31209,10,14103,0),(31210,2,14104,0),(31211,10,14104,0),(31212,2,14105,0),(31213,10,14105,0),(31214,2,14106,0),(31215,10,14106,0),(31216,2,14107,0),(31217,10,14107,0),(31218,2,14108,0),(31219,10,14108,0),(31220,2,14109,0),(31221,10,14109,0),(31222,2,14110,0),(31223,10,14110,0),(31224,2,14111,0),(31225,10,14111,0),(31226,2,14112,0),(31227,10,14112,0),(31228,2,14113,0),(31229,10,14113,0),(31230,2,14114,0),(31231,10,14114,0),(31232,2,14115,0),(31233,10,14115,0),(31234,2,14116,0),(31235,10,14116,0),(31236,2,14117,0),(31237,10,14117,0),(31238,2,14118,0),(31239,10,14118,0),(31240,2,14119,0),(31241,10,14119,0),(31242,2,14120,0),(31243,10,14120,0),(31244,2,14121,0),(31245,10,14121,0),(31246,2,14122,0),(31247,10,14122,0),(31248,2,14123,0),(31249,10,14123,0),(31250,2,14124,0),(31251,10,14124,0),(31252,2,14125,0),(31253,10,14125,0),(31254,2,14126,0),(31255,10,14126,0),(31256,2,14127,0),(31257,10,14127,0),(31258,2,14128,0),(31259,10,14128,0),(31260,2,14129,0),(31261,10,14129,0),(31262,2,14130,0),(31263,10,14130,0),(31264,2,14131,0),(31265,10,14131,0),(31266,2,14132,0),(31267,10,14132,0),(31268,2,14133,0),(31269,10,14133,0),(31270,2,14134,0),(31271,10,14134,0),(31272,2,14135,0),(31273,10,14135,0),(31274,2,14136,0),(31275,10,14136,0),(31276,2,14137,0),(31277,10,14137,0),(31278,2,14138,0),(31279,10,14138,0),(31280,2,14139,0),(31281,10,14139,0),(31282,2,14140,0),(31283,10,14140,0),(31284,2,14141,0),(31285,10,14141,0),(31286,2,14142,0),(31287,10,14142,0),(31288,2,14143,0),(31289,10,14143,0),(31290,2,14144,0),(31291,10,14144,0),(31292,2,14145,0),(31293,10,14145,0),(31294,2,14146,0),(31295,10,14146,0),(31296,2,14147,0),(31297,10,14147,0),(31298,2,14148,0),(31299,10,14148,0),(31300,2,14149,0),(31301,10,14149,0),(31302,2,14150,0),(31303,10,14150,0),(31304,2,14151,0),(31305,10,14151,0),(31306,2,14152,0),(31307,10,14152,0),(31308,2,14153,0),(31309,10,14153,0),(31310,2,14154,0),(31311,10,14154,0),(31312,2,14155,0),(31313,10,14155,0),(31314,2,14156,0),(31315,10,14156,0),(31316,2,14157,0),(31317,10,14157,0),(31318,2,14158,0),(31319,10,14158,0),(31320,2,14159,0),(31321,10,14159,0),(31322,2,14160,0),(31323,10,14160,0),(31324,2,14161,0),(31325,10,14161,0),(31326,2,14162,0),(31327,10,14162,0),(31328,2,14163,0),(31329,10,14163,0),(31330,2,14164,0),(31331,10,14164,0),(31332,2,14165,0),(31333,10,14165,0),(31334,2,14166,0),(31335,10,14166,0),(31336,2,14167,0),(31337,10,14167,0),(31338,2,14168,0),(31339,10,14168,0),(31340,2,14169,0),(31341,10,14169,0),(31342,2,14170,0),(31343,10,14170,0),(31344,2,14171,0),(31345,10,14171,0),(31346,2,14172,0),(31347,10,14172,0),(31348,2,14173,0),(31349,10,14173,0),(31350,2,14174,0),(31351,10,14174,0),(31352,2,14175,0),(31353,10,14175,0),(31354,2,14176,0),(31355,10,14176,0),(31356,2,14177,0),(31357,10,14177,0),(31358,2,14178,0),(31359,10,14178,0),(31360,2,14179,0),(31361,10,14179,0),(31362,2,14180,0),(31363,10,14180,0),(31364,2,14181,0),(31365,10,14181,0),(31366,2,14182,0),(31367,10,14182,0),(31368,2,14183,0),(31369,10,14183,0),(31370,2,14184,0),(31371,10,14184,0),(31372,2,14185,0),(31373,10,14185,0),(31374,2,14186,0),(31375,10,14186,0),(31376,2,14187,0),(31377,10,14187,0),(31378,2,14188,0),(31379,10,14188,0),(31380,2,14189,0),(31381,10,14189,0),(31382,2,14190,0),(31383,10,14190,0),(31384,2,14191,0),(31385,10,14191,0),(31386,2,14192,0),(31387,10,14192,0),(31388,2,14193,0),(31389,10,14193,0),(31390,2,14194,0),(31391,10,14194,0),(31392,2,14195,0),(31393,10,14195,0),(31394,2,14196,0),(31395,10,14196,0),(31396,2,14197,0),(31397,10,14197,0),(31398,2,14198,0),(31399,10,14198,0),(31400,2,14199,0),(31401,10,14199,0),(31402,2,14200,0),(31403,10,14200,0),(31404,2,14201,0),(31405,10,14201,0),(31406,2,14202,0),(31407,10,14202,0),(31408,2,14203,0),(31409,10,14203,0),(31410,2,14204,0),(31411,10,14204,0),(31412,2,14205,0),(31413,10,14205,0),(31414,2,14206,0),(31415,10,14206,0),(31416,2,14207,0),(31417,10,14207,0),(31418,2,14208,0),(31419,10,14208,0),(31420,2,14209,0),(31421,10,14209,0),(31422,2,14210,0),(31423,10,14210,0),(31424,2,14211,0),(31425,10,14211,0),(31426,2,14212,0),(31427,10,14212,0),(31428,2,14213,0),(31429,10,14213,0),(31430,2,14214,0),(31431,10,14214,0),(31432,2,14215,0),(31433,10,14215,0),(31434,2,14216,0),(31435,10,14216,0),(31436,2,14217,0),(31437,10,14217,0),(31438,2,14218,0),(31439,10,14218,0),(31440,2,14219,0),(31441,10,14219,0),(31442,2,14220,0),(31443,10,14220,0),(31444,2,14221,0),(31445,10,14221,0),(31446,2,14222,0),(31447,10,14222,0),(31448,2,14223,0),(31449,10,14223,0),(31450,2,14224,0),(31451,10,14224,0),(31452,2,14225,0),(31453,10,14225,0),(31454,2,14226,0),(31455,10,14226,0),(31456,2,14227,0),(31457,10,14227,0),(31458,2,14228,0),(31459,10,14228,0),(31460,2,14229,0),(31461,10,14229,0),(31462,2,14230,0),(31463,10,14230,0),(31464,2,14231,0),(31465,10,14231,0),(31466,2,14232,0),(31467,10,14232,0),(31468,2,14233,0),(31469,10,14233,0),(31470,2,14234,0),(31471,10,14234,0),(31472,2,14235,0),(31473,10,14235,0),(31474,2,14236,0),(31475,10,14236,0),(31476,2,14237,0),(31477,10,14237,0),(31478,2,14238,0),(31479,10,14238,0),(31480,2,14239,0),(31481,10,14239,0),(31482,2,14240,0),(31483,10,14240,0),(31484,2,14241,0),(31485,10,14241,0),(31486,2,14242,0),(31487,10,14242,0),(31488,2,14243,0),(31489,10,14243,0),(31490,2,14244,0),(31491,10,14244,0),(31492,2,14245,0),(31493,10,14245,0),(31494,2,14246,0),(31495,10,14246,0),(31496,2,14247,0),(31497,10,14247,0),(31498,2,14248,0),(31499,10,14248,0),(31500,2,14249,0),(31501,10,14249,0),(31502,2,14250,0),(31503,10,14250,0),(31504,2,14251,0),(31505,10,14251,0),(31506,2,14252,0),(31507,10,14252,0),(31508,2,14253,0),(31509,10,14253,0),(31510,2,14254,0),(31511,10,14254,0),(31512,2,14255,0),(31513,10,14255,0),(31514,2,14256,0),(31515,10,14256,0),(31516,2,14257,0),(31517,10,14257,0),(31518,2,14258,0),(31519,10,14258,0),(31520,2,14259,0),(31521,10,14259,0),(31522,2,14260,0),(31523,10,14260,0),(31524,2,14261,0),(31525,10,14261,0),(31526,2,14262,0),(31527,10,14262,0),(31528,2,14263,0),(31529,10,14263,0),(31530,2,14264,0),(31531,10,14264,0),(31532,2,14265,0),(31533,10,14265,0),(31534,2,14266,0),(31535,10,14266,0),(31536,2,14267,0),(31537,10,14267,0),(31538,2,14268,0),(31539,10,14268,0),(31540,2,14269,0),(31541,10,14269,0),(31542,2,14270,0),(31543,10,14270,0),(31544,2,14271,0),(31545,10,14271,0),(31546,2,14272,0),(31547,10,14272,0),(31548,2,14273,0),(31549,10,14273,0),(31550,2,14274,0),(31551,10,14274,0),(31552,2,14275,0),(31553,10,14275,0),(31554,2,14276,0),(31555,10,14276,0),(31556,2,14277,0),(31557,10,14277,0),(31558,2,14278,0),(31559,10,14278,0),(31560,2,14279,0),(31561,10,14279,0),(31562,2,14280,0),(31563,10,14280,0),(31564,2,14281,0),(31565,10,14281,0),(31566,2,14282,0),(31567,10,14282,0),(31568,2,14283,0),(31569,10,14283,0),(31570,2,14284,0),(31571,10,14284,0),(31572,2,14285,0),(31573,10,14285,0),(31574,2,14286,0),(31575,10,14286,0),(31576,2,14287,0),(31577,10,14287,0),(31578,2,14288,0),(31579,10,14288,0),(31580,2,14289,0),(31581,10,14289,0),(31582,2,14290,0),(31583,10,14290,0),(31584,2,14291,0),(31585,10,14291,0),(31586,2,14292,0),(31587,10,14292,0),(31588,2,14293,0),(31589,10,14293,0),(31590,2,14294,0),(31591,10,14294,0),(31592,2,14295,0),(31593,10,14295,0),(31594,2,14296,0),(31595,10,14296,0),(31596,2,14297,0),(31597,10,14297,0),(31598,2,14298,0),(31599,10,14298,0),(31600,2,14299,0),(31601,10,14299,0),(31602,2,14300,0),(31603,10,14300,0),(31604,2,14301,0),(31605,10,14301,0),(31606,2,14302,0),(31607,10,14302,0),(31608,2,14303,0),(31609,10,14303,0),(31610,2,14304,0),(31611,10,14304,0),(31612,2,14305,0),(31613,10,14305,0),(31614,2,14306,0),(31615,10,14306,0),(31616,2,14307,0),(31617,10,14307,0),(31618,2,14308,0),(31619,10,14308,0),(31620,2,14309,0),(31621,10,14309,0),(31622,2,14310,0),(31623,10,14310,0),(31624,2,14311,0),(31625,10,14311,0),(31626,2,14312,0),(31627,10,14312,0),(31628,2,14313,0),(31629,10,14313,0),(31630,2,14314,0),(31631,10,14314,0),(31632,2,14315,0),(31633,10,14315,0),(31634,2,14316,0),(31635,10,14316,0),(31636,2,14317,0),(31637,10,14317,0),(31638,2,14318,0),(31639,10,14318,0),(31640,2,14319,0),(31641,10,14319,0),(31642,2,14320,0),(31643,10,14320,0),(31644,2,14321,0),(31645,10,14321,0),(31646,2,14322,0),(31647,10,14322,0),(31648,2,14323,0),(31649,10,14323,0),(31650,2,14324,0),(31651,10,14324,0),(31652,2,14325,0),(31653,10,14325,0),(31654,2,14326,0),(31655,10,14326,0),(31656,2,14327,0),(31657,10,14327,0),(31658,2,14328,0),(31659,10,14328,0),(31660,2,14329,0),(31661,10,14329,0),(31662,2,14330,0),(31663,10,14330,0),(31664,2,14331,0),(31665,10,14331,0),(31666,2,14332,0),(31667,10,14332,0),(31668,2,14333,0),(31669,10,14333,0),(31670,2,14334,0),(31671,10,14334,0),(31672,2,14335,0),(31673,10,14335,0),(31674,2,14336,0),(31675,10,14336,0),(31676,2,14337,0),(31677,10,14337,0),(31678,2,14338,0),(31679,10,14338,0),(31680,2,14339,0),(31681,10,14339,0),(31682,2,14340,0),(31683,10,14340,0),(31684,2,14341,0),(31685,10,14341,0),(31686,2,14342,0),(31687,10,14342,0),(31688,2,14343,0),(31689,10,14343,0),(31690,2,14344,0),(31691,10,14344,0),(31692,2,14345,0),(31693,10,14345,0),(31694,2,14346,0),(31695,10,14346,0),(31696,2,14347,0),(31697,10,14347,0),(31698,2,14348,0),(31699,10,14348,0),(31700,2,14349,0),(31701,10,14349,0),(31702,2,14350,0),(31703,10,14350,0),(31704,2,14351,0),(31705,10,14351,0),(31706,2,14352,0),(31707,10,14352,0),(31708,2,14353,0),(31709,10,14353,0),(31710,2,14354,0),(31711,10,14354,0),(31712,2,14355,0),(31713,10,14355,0),(31714,2,14356,0),(31715,10,14356,0),(31716,2,14357,0),(31717,10,14357,0),(31718,2,14358,0),(31719,10,14358,0),(31720,2,14359,0),(31721,10,14359,0),(31722,2,14360,0),(31723,10,14360,0),(31724,2,14361,0),(31725,10,14361,0),(31726,2,14362,0),(31727,10,14362,0),(31728,2,14363,0),(31729,10,14363,0),(31730,2,14364,0),(31731,10,14364,0),(31732,2,14365,0),(31733,10,14365,0),(31734,2,14366,0),(31735,10,14366,0),(31736,2,14367,0),(31737,10,14367,0),(31738,2,14368,0),(31739,10,14368,0),(31740,2,14369,0),(31741,10,14369,0),(31742,2,14370,0),(31743,10,14370,0),(31744,2,14371,0),(31745,10,14371,0),(31746,2,14372,0),(31747,10,14372,0),(31748,2,14373,0),(31749,10,14373,0),(31750,2,14374,0),(31751,10,14374,0),(31752,2,14375,0),(31753,10,14375,0),(31754,2,14376,0),(31755,10,14376,0),(31756,2,14377,0),(31757,10,14377,0),(31758,2,14378,0),(31759,10,14378,0),(31760,2,14379,0),(31761,10,14379,0),(31762,2,14380,0),(31763,10,14380,0),(31764,2,14381,0),(31765,10,14381,0),(31766,2,14382,0),(31767,10,14382,0),(31768,2,14383,0),(31769,10,14383,0),(31770,2,14384,0),(31771,10,14384,0),(31772,2,14385,0),(31773,10,14385,0),(31774,2,14386,0),(31775,10,14386,0),(31776,2,14387,0),(31777,10,14387,0),(31778,2,14388,0),(31779,10,14388,0),(31780,2,14389,0),(31781,10,14389,0),(31782,2,14390,0),(31783,10,14390,0),(31784,2,14391,0),(31785,10,14391,0),(31786,2,14392,0),(31787,10,14392,0),(31788,2,14393,0),(31789,10,14393,0),(31790,2,14394,0),(31791,10,14394,0),(31792,2,14395,0),(31793,10,14395,0),(31794,2,14396,0),(31795,10,14396,0),(31796,2,14397,0),(31797,10,14397,0),(31798,2,14398,0),(31799,10,14398,0),(31800,2,14399,0),(31801,10,14399,0),(31802,2,14400,0),(31803,10,14400,0),(31804,2,14401,0),(31805,10,14401,0),(31806,2,14402,0),(31807,10,14402,0),(31808,2,14403,0),(31809,10,14403,0),(31810,2,14404,0),(31811,10,14404,0),(31812,2,14405,0),(31813,10,14405,0),(31814,2,14406,0),(31815,10,14406,0),(31816,2,14407,0),(31817,10,14407,0),(31818,2,14408,0),(31819,10,14408,0),(31820,2,14409,0),(31821,10,14409,0),(31822,2,14410,0),(31823,10,14410,0),(31824,2,14411,0),(31825,10,14411,0),(31826,2,14412,0),(31827,10,14412,0),(31828,2,14413,0),(31829,10,14413,0),(31830,2,14414,0),(31831,10,14414,0),(31832,2,14415,0),(31833,10,14415,0),(31834,2,14416,0),(31835,10,14416,0),(31836,2,14417,0),(31837,10,14417,0),(31838,2,14418,0),(31839,10,14418,0),(31840,2,14419,0),(31841,10,14419,0),(31842,2,14420,0),(31843,10,14420,0),(31844,2,14421,0),(31845,10,14421,0),(31846,2,14422,0),(31847,10,14422,0),(31848,2,14423,0),(31849,10,14423,0),(31850,2,14424,0),(31851,10,14424,0),(31852,2,14425,0),(31853,10,14425,0),(31854,2,14426,0),(31855,10,14426,0),(31856,2,14427,0),(31857,10,14427,0),(31858,2,14428,0),(31859,10,14428,0),(31860,2,14429,0),(31861,10,14429,0),(31862,2,14430,0),(31863,10,14430,0),(31864,2,14431,0),(31865,10,14431,0),(31866,2,14432,0),(31867,10,14432,0),(31868,2,14433,0),(31869,10,14433,0),(31870,2,14434,0),(31871,10,14434,0),(31872,2,14435,0),(31873,10,14435,0),(31874,2,14436,0),(31875,10,14436,0),(31876,2,14437,0),(31877,10,14437,0),(31878,2,14438,0),(31879,10,14438,0),(31880,2,14439,0),(31881,10,14439,0),(31882,2,14440,0),(31883,10,14440,0),(31884,2,14441,0),(31885,10,14441,0),(31886,2,14442,0),(31887,10,14442,0),(31888,2,14443,0),(31889,10,14443,0),(31890,2,14444,0),(31891,10,14444,0),(31892,2,14445,0),(31893,10,14445,0),(31894,2,14446,0),(31895,10,14446,0),(31896,2,14447,0),(31897,10,14447,0),(31898,2,14448,0),(31899,10,14448,0),(31900,2,14449,0),(31901,10,14449,0),(31902,2,14450,0),(31903,10,14450,0),(31904,2,14451,0),(31905,10,14451,0),(31906,2,14452,0),(31907,10,14452,0),(31908,2,14453,0),(31909,10,14453,0),(31910,2,14454,0),(31911,10,14454,0),(31912,2,14455,0),(31913,10,14455,0),(31914,2,14456,0),(31915,10,14456,0),(31916,2,14457,0),(31917,10,14457,0),(31918,2,14458,0),(31919,10,14458,0),(31920,2,14459,0),(31921,10,14459,0),(31922,2,14460,0),(31923,10,14460,0),(31924,2,14461,0),(31925,10,14461,0),(31926,2,14462,0),(31927,10,14462,0),(31928,2,14463,0),(31929,10,14463,0),(31930,2,14464,0),(31931,10,14464,0),(31932,2,14465,0),(31933,10,14465,0),(31934,2,14466,0),(31935,10,14466,0),(31936,2,14467,0),(31937,10,14467,0),(31938,2,14468,0),(31939,10,14468,0),(31940,2,14469,0),(31941,10,14469,0),(31942,2,14470,0),(31943,10,14470,0),(31944,2,14471,0),(31945,10,14471,0),(31946,2,14472,0),(31947,10,14472,0),(31948,2,14473,0),(31949,10,14473,0),(31950,2,14474,0),(31951,10,14474,0),(31952,2,14475,0),(31953,10,14475,0),(31954,2,14476,0),(31955,10,14476,0),(31956,2,14477,0),(31957,10,14477,0),(31958,2,14478,0),(31959,10,14478,0),(31960,2,14479,0),(31961,10,14479,0),(31962,2,14480,0),(31963,10,14480,0),(31964,2,14481,0),(31965,10,14481,0),(31966,2,14482,0),(31967,10,14482,0),(31968,2,14483,0),(31969,10,14483,0),(31970,2,14484,0),(31971,10,14484,0),(31972,2,14485,0),(31973,10,14485,0),(31974,2,14486,0),(31975,10,14486,0),(31976,2,14487,0),(31977,10,14487,0),(31978,2,14488,0),(31979,10,14488,0),(31980,2,14489,0),(31981,10,14489,0),(31982,2,14490,0),(31983,10,14490,0),(31984,2,14491,0),(31985,10,14491,0),(31986,2,14492,0),(31987,10,14492,0),(31988,2,14493,0),(31989,10,14493,0),(31990,2,14494,0),(31991,10,14494,0),(31992,2,14495,0),(31993,10,14495,0),(31994,2,14496,0),(31995,10,14496,0),(31996,2,14497,0),(31997,10,14497,0),(31998,2,14498,0),(31999,10,14498,0),(32000,2,14499,0),(32001,10,14499,0),(32002,2,14500,0),(32003,10,14500,0),(32004,2,14501,0),(32005,10,14501,0),(32006,2,14502,0),(32007,10,14502,0),(32008,2,14503,0),(32009,10,14503,0),(32010,2,14504,0),(32011,10,14504,0),(32012,2,14505,0),(32013,10,14505,0),(32014,2,14506,0),(32015,10,14506,0),(32016,2,14507,0),(32017,10,14507,0),(32018,2,14508,0),(32019,10,14508,0),(32020,2,14509,0),(32021,10,14509,0),(32022,2,14510,0),(32023,10,14510,0),(32024,2,14511,0),(32025,10,14511,0),(32026,2,14512,0),(32027,10,14512,0),(32028,2,14513,0),(32029,10,14513,0),(32030,2,14514,0),(32031,10,14514,0),(32032,2,14515,0),(32033,10,14515,0),(32034,2,14516,0),(32035,10,14516,0),(32036,2,14517,0),(32037,10,14517,0),(32038,2,14518,0),(32039,10,14518,0),(32040,2,14519,0),(32041,10,14519,0),(32042,2,14520,0),(32043,10,14520,0),(32044,2,14521,0),(32045,10,14521,0),(32046,2,14522,0),(32047,10,14522,0),(32048,2,14523,0),(32049,10,14523,0),(32050,2,14524,0),(32051,10,14524,0),(32052,2,14525,0),(32053,10,14525,0),(32054,2,14526,0),(32055,10,14526,0),(32056,2,14527,0),(32057,10,14527,0),(32058,2,14528,0),(32059,10,14528,0),(32060,2,14529,0),(32061,10,14529,0),(32062,2,14530,0),(32063,10,14530,0),(32064,2,14531,0),(32065,10,14531,0),(32066,2,14532,0),(32067,10,14532,0),(32068,2,14533,0),(32069,10,14533,0),(32070,2,14534,0),(32071,10,14534,0),(32072,2,14535,0),(32073,10,14535,0),(32074,2,14536,0),(32075,10,14536,0),(32076,2,14537,0),(32077,10,14537,0),(32078,2,14538,0),(32079,10,14538,0),(32080,2,14539,0),(32081,10,14539,0),(32082,2,14540,0),(32083,10,14540,0),(32084,2,14541,0),(32085,10,14541,0),(32086,2,14542,0),(32087,10,14542,0),(32088,2,14543,0),(32089,10,14543,0),(32090,2,14544,0),(32091,10,14544,0),(32092,2,14545,0),(32093,10,14545,0),(32094,2,14546,0),(32095,10,14546,0),(32096,2,14547,0),(32097,10,14547,0),(32098,2,14548,0),(32099,10,14548,0),(32100,2,14549,0),(32101,10,14549,0),(32102,2,14550,0),(32103,10,14550,0),(32104,2,14551,0),(32105,10,14551,0),(32106,2,14552,0),(32107,10,14552,0),(32108,2,14553,0),(32109,10,14553,0),(32110,2,14554,0),(32111,10,14554,0),(32112,2,14555,0),(32113,10,14555,0),(32114,2,14556,0),(32115,10,14556,0),(32116,2,14557,0),(32117,10,14557,0),(32118,2,14558,0),(32119,10,14558,0),(32120,2,14559,0),(32121,10,14559,0),(32122,2,14560,0),(32123,10,14560,0),(32124,2,14561,0),(32125,10,14561,0),(32126,2,14562,0),(32127,10,14562,0),(32128,2,14563,0),(32129,10,14563,0),(32130,2,14564,0),(32131,10,14564,0),(32132,2,14565,0),(32133,10,14565,0),(32134,2,14566,0),(32135,10,14566,0),(32136,2,14567,0),(32137,10,14567,0),(32138,2,14568,0),(32139,10,14568,0),(32140,2,14569,0),(32141,10,14569,0),(32142,2,14570,0),(32143,10,14570,0),(32144,2,14571,0),(32145,10,14571,0),(32146,2,14572,0),(32147,10,14572,0),(32148,2,14573,0),(32149,10,14573,0),(32150,2,14574,0),(32151,10,14574,0),(32152,2,14575,0),(32153,10,14575,0),(32154,2,14576,0),(32155,10,14576,0),(32156,2,14577,0),(32157,10,14577,0),(32158,2,14578,0),(32159,10,14578,0),(32160,2,14579,0),(32161,10,14579,0),(32162,2,14580,0),(32163,10,14580,0),(32164,2,14581,0),(32165,10,14581,0),(32166,2,14582,0),(32167,10,14582,0),(32168,2,14583,0),(32169,10,14583,0),(32170,2,14584,0),(32171,10,14584,0),(32172,2,14585,0),(32173,10,14585,0),(32174,2,14586,0),(32175,10,14586,0),(32176,2,14587,0),(32177,10,14587,0),(32178,2,14588,0),(32179,10,14588,0),(32180,2,14589,0),(32181,10,14589,0),(32182,2,14590,0),(32183,10,14590,0),(32184,2,14591,0),(32185,10,14591,0),(32186,2,14592,0),(32187,10,14592,0),(32188,2,14593,0),(32189,10,14593,0),(32190,2,14594,0),(32191,10,14594,0),(32192,2,14595,0),(32193,10,14595,0),(32194,2,14596,0),(32195,10,14596,0),(32196,2,14597,0),(32197,10,14597,0),(32198,2,14598,0),(32199,10,14598,0),(32200,2,14599,0),(32201,10,14599,0),(32202,2,14600,0),(32203,10,14600,0),(32204,2,14601,0),(32205,10,14601,0),(32206,2,14602,0),(32207,10,14602,0),(32208,2,14603,0),(32209,10,14603,0),(32210,2,14604,0),(32211,10,14604,0),(32212,2,14605,0),(32213,10,14605,0),(32214,2,14606,0),(32215,10,14606,0),(32216,2,14607,0),(32217,10,14607,0),(32218,2,14608,0),(32219,10,14608,0),(32220,2,14609,0),(32221,10,14609,0),(32222,2,14610,0),(32223,10,14610,0),(32224,2,14611,0),(32225,10,14611,0),(32226,2,14612,0),(32227,10,14612,0),(32228,2,14613,0),(32229,10,14613,0),(32230,2,14614,0),(32231,10,14614,0),(32232,2,14615,0),(32233,10,14615,0),(32234,2,14616,0),(32235,10,14616,0),(32236,2,14617,0),(32237,10,14617,0),(32238,2,14618,0),(32239,10,14618,0),(32240,2,14619,0),(32241,10,14619,0),(32242,2,14620,0),(32243,10,14620,0),(32244,2,14621,0),(32245,10,14621,0),(32246,2,14622,0),(32247,10,14622,0),(32248,2,14623,0),(32249,10,14623,0),(32250,2,14624,0),(32251,10,14624,0),(32252,2,14625,0),(32253,10,14625,0),(32254,2,14626,0),(32255,10,14626,0),(32256,2,14627,0),(32257,10,14627,0),(32258,2,14628,0),(32259,10,14628,0),(32260,2,14629,0),(32261,10,14629,0),(32262,2,14630,0),(32263,10,14630,0),(32264,2,14631,0),(32265,10,14631,0),(32266,2,14632,0),(32267,10,14632,0),(32268,2,14633,0),(32269,10,14633,0),(32270,2,14634,0),(32271,10,14634,0),(32272,2,14635,0),(32273,10,14635,0),(32274,2,14636,0),(32275,10,14636,0),(32276,2,14637,0),(32277,10,14637,0),(32278,2,14638,0),(32279,10,14638,0),(32280,2,14639,0),(32281,10,14639,0),(32282,2,14640,0),(32283,10,14640,0),(32284,2,14641,0),(32285,10,14641,0),(32286,2,14642,0),(32287,10,14642,0),(32288,2,14643,0),(32289,10,14643,0),(32290,2,14644,0),(32291,10,14644,0),(32292,2,14645,0),(32293,10,14645,0),(32294,2,14646,0),(32295,10,14646,0),(32296,2,14647,0),(32297,10,14647,0),(32298,2,14648,0),(32299,10,14648,0),(32300,2,14649,0),(32301,10,14649,0),(32302,2,14650,0),(32303,10,14650,0),(32304,2,14651,0),(32305,10,14651,0),(32306,2,14652,0),(32307,10,14652,0),(32308,2,14653,0),(32309,10,14653,0),(32310,2,14654,0),(32311,10,14654,0),(32312,2,14655,0),(32313,10,14655,0),(32314,2,14656,0),(32315,10,14656,0),(32316,2,14657,0),(32317,10,14657,0),(32318,2,14658,0),(32319,10,14658,0),(32320,2,14659,0),(32321,10,14659,0),(32322,2,14660,0),(32323,10,14660,0),(32324,2,14661,0),(32325,10,14661,0),(32326,2,14662,0),(32327,10,14662,0),(32328,2,14663,0),(32329,10,14663,0),(32330,2,14664,0),(32331,10,14664,0),(32332,2,14665,0),(32333,10,14665,0),(32334,2,14666,0),(32335,10,14666,0),(32336,2,14667,0),(32337,10,14667,0),(32338,2,14668,0),(32339,10,14668,0),(32340,2,14669,0),(32341,10,14669,0),(32342,2,14670,0),(32343,10,14670,0),(32344,2,14671,0),(32345,10,14671,0),(32346,2,14672,0),(32347,10,14672,0),(32348,2,14673,0),(32349,10,14673,0),(32350,2,14674,0),(32351,10,14674,0),(32352,2,14675,0),(32353,10,14675,0),(32354,2,14676,0),(32355,10,14676,0),(32356,2,14677,0),(32357,10,14677,0),(32358,2,14678,0),(32359,10,14678,0),(32360,2,14679,0),(32361,10,14679,0),(32362,2,14680,0),(32363,10,14680,0),(32364,2,14681,0),(32365,10,14681,0),(32366,2,14682,0),(32367,10,14682,0),(32368,2,14683,0),(32369,10,14683,0),(32370,2,14684,0),(32371,10,14684,0),(32372,2,14685,0),(32373,10,14685,0),(32374,2,14686,0),(32375,10,14686,0),(32376,2,14687,0),(32377,10,14687,0),(32378,2,14688,0),(32379,10,14688,0),(32380,2,14689,0),(32381,10,14689,0),(32382,2,14690,0),(32383,10,14690,0),(32384,2,14691,0),(32385,10,14691,0),(32386,2,14692,0),(32387,10,14692,0),(32388,2,14693,0),(32389,10,14693,0),(32390,2,14694,0),(32391,10,14694,0),(32392,2,14695,0),(32393,10,14695,0),(32394,2,14696,0),(32395,10,14696,0),(32396,2,14697,0),(32397,10,14697,0),(32398,2,14698,0),(32399,10,14698,0),(32400,2,14699,0),(32401,10,14699,0),(32402,2,14700,0),(32403,10,14700,0),(32404,2,14701,0),(32405,10,14701,0),(32406,2,14702,0),(32407,10,14702,0),(32408,2,14703,0),(32409,10,14703,0),(32410,2,14704,0),(32411,10,14704,0),(32412,2,14705,0),(32413,10,14705,0),(32414,2,14706,0),(32415,10,14706,0),(32416,2,14707,0),(32417,10,14707,0),(32418,2,14708,0),(32419,10,14708,0),(32420,2,14709,0),(32421,10,14709,0),(32422,2,14710,0),(32423,10,14710,0),(32424,2,14711,0),(32425,10,14711,0),(32426,2,14712,0),(32427,10,14712,0),(32428,2,14713,0),(32429,10,14713,0),(32430,2,14714,0),(32431,10,14714,0),(32432,2,14715,0),(32433,10,14715,0),(32434,2,14716,0),(32435,10,14716,0),(32436,2,14717,0),(32437,10,14717,0),(32438,2,14718,0),(32439,10,14718,0),(32440,2,14719,0),(32441,10,14719,0),(32442,2,14720,0),(32443,10,14720,0),(32444,2,14721,0),(32445,10,14721,0),(32446,2,14722,0),(32447,10,14722,0),(32448,2,14723,0),(32449,10,14723,0),(32450,2,14724,0),(32451,10,14724,0),(32452,2,14725,0),(32453,10,14725,0),(32454,2,14726,0),(32455,10,14726,0),(32456,2,14727,0),(32457,10,14727,0),(32458,2,14728,0),(32459,10,14728,0),(32460,2,14729,0),(32461,10,14729,0),(32462,2,14730,0),(32463,10,14730,0),(32464,2,14731,0),(32465,10,14731,0),(32466,2,14732,0),(32467,10,14732,0),(32468,2,14733,0),(32469,10,14733,0),(32470,2,14734,0),(32471,10,14734,0),(32472,2,14735,0),(32473,10,14735,0),(32474,2,14736,0),(32475,10,14736,0),(32476,2,14737,0),(32477,10,14737,0),(32478,2,14738,0),(32479,10,14738,0),(32480,2,14739,0),(32481,10,14739,0),(32482,2,14740,0),(32483,10,14740,0),(32484,2,14741,0),(32485,10,14741,0),(32486,2,14742,0),(32487,10,14742,0),(32488,2,14743,0),(32489,10,14743,0),(32490,2,14744,0),(32491,10,14744,0),(32492,2,14745,0),(32493,10,14745,0),(32494,2,14746,0),(32495,10,14746,0),(32496,2,14747,0),(32497,10,14747,0),(32498,2,14748,0),(32499,10,14748,0),(32500,2,14749,0),(32501,10,14749,0),(32502,2,14750,0),(32503,10,14750,0),(32504,2,14751,0),(32505,10,14751,0),(32506,2,14752,0),(32507,10,14752,0),(32508,2,14753,0),(32509,10,14753,0),(32510,2,14754,0),(32511,10,14754,0),(32512,2,14755,0),(32513,10,14755,0),(32514,2,14756,0),(32515,10,14756,0),(32516,2,14757,0),(32517,10,14757,0),(32518,2,14758,0),(32519,10,14758,0),(32520,2,14759,0),(32521,10,14759,0),(32522,2,14760,0),(32523,10,14760,0),(32524,2,14761,0),(32525,10,14761,0),(32526,2,14762,0),(32527,10,14762,0),(32528,2,14763,0),(32529,10,14763,0),(32530,2,14764,0),(32531,10,14764,0),(32532,2,14765,0),(32533,10,14765,0),(32534,2,14766,0),(32535,10,14766,0),(32536,2,14767,0),(32537,10,14767,0),(32538,2,14768,0),(32539,10,14768,0),(32540,2,14769,0),(32541,10,14769,0),(32542,2,14770,0),(32543,10,14770,0),(32544,2,14771,0),(32545,10,14771,0),(32546,2,14772,0),(32547,10,14772,0),(32548,2,14773,0),(32549,10,14773,0),(32550,2,14774,0),(32551,10,14774,0),(32552,2,14775,0),(32553,10,14775,0),(32554,2,14776,0),(32555,10,14776,0),(32556,2,14777,0),(32557,10,14777,0),(32558,2,14778,0),(32559,10,14778,0),(32560,2,14779,0),(32561,10,14779,0),(32562,2,14780,0),(32563,10,14780,0),(32564,2,14781,0),(32565,10,14781,0),(32566,2,14782,0),(32567,10,14782,0),(32568,2,14783,0),(32569,10,14783,0),(32570,2,14784,0),(32571,10,14784,0),(32572,2,14785,0),(32573,10,14785,0),(32574,2,14786,0),(32575,10,14786,0),(32576,2,14787,0),(32577,10,14787,0),(32578,2,14788,0),(32579,10,14788,0),(32580,2,14789,0),(32581,10,14789,0),(32582,2,14790,0),(32583,10,14790,0),(32584,2,14791,0),(32585,10,14791,0),(32586,2,14792,0),(32587,10,14792,0),(32588,2,14793,0),(32589,10,14793,0),(32590,2,14794,0),(32591,10,14794,0),(32592,2,14795,0),(32593,10,14795,0),(32594,2,14796,0),(32595,10,14796,0),(32596,2,14797,0),(32597,10,14797,0),(32598,2,14798,0),(32599,10,14798,0),(32600,2,14799,0),(32601,10,14799,0),(32602,2,14800,0),(32603,10,14800,0),(32604,2,14801,0),(32605,10,14801,0),(32606,2,14802,0),(32607,10,14802,0),(32608,2,14803,0),(32609,10,14803,0),(32610,2,14804,0),(32611,10,14804,0),(32612,2,14805,0),(32613,10,14805,0),(32614,2,14806,0),(32615,10,14806,0),(32616,2,14807,0),(32617,10,14807,0),(32618,2,14808,0),(32619,10,14808,0),(32620,2,14809,0),(32621,10,14809,0),(32622,2,14810,0),(32623,10,14810,0),(32624,2,14811,0),(32625,10,14811,0),(32626,2,14812,0),(32627,10,14812,0),(32628,2,14813,0),(32629,10,14813,0),(32630,2,14814,0),(32631,10,14814,0),(32632,2,14815,0),(32633,10,14815,0),(32634,2,14816,0),(32635,10,14816,0),(32636,2,14817,0),(32637,10,14817,0),(32638,2,14818,0),(32639,10,14818,0),(32640,2,14819,0),(32641,10,14819,0),(32642,2,14820,0),(32643,10,14820,0),(32644,2,14821,0),(32645,10,14821,0),(32646,2,14822,0),(32647,10,14822,0),(32648,2,14823,0),(32649,10,14823,0),(32650,2,14824,0),(32651,10,14824,0),(32652,2,14825,0),(32653,10,14825,0),(32654,2,14826,0),(32655,10,14826,0),(32656,2,14827,0),(32657,10,14827,0),(32658,2,14828,0),(32659,10,14828,0),(32660,2,14829,0),(32661,10,14829,0),(32662,2,14830,0),(32663,10,14830,0),(32664,2,14831,0),(32665,10,14831,0),(32666,2,14832,0),(32667,10,14832,0),(32668,2,14833,0),(32669,10,14833,0),(32670,2,14834,0),(32671,10,14834,0),(32672,2,14835,0),(32673,10,14835,0),(32674,2,14836,0),(32675,10,14836,0),(32676,2,14837,0),(32677,10,14837,0),(32678,2,14838,0),(32679,10,14838,0),(32680,2,14839,0),(32681,10,14839,0),(32682,2,14840,0),(32683,10,14840,0),(32684,2,14841,0),(32685,10,14841,0),(32686,2,14842,0),(32687,10,14842,0),(32688,2,14843,0),(32689,10,14843,0),(32690,2,14844,0),(32691,10,14844,0),(32692,2,14845,0),(32693,10,14845,0),(32694,2,14846,0),(32695,10,14846,0),(32696,2,14847,0),(32697,10,14847,0),(32698,2,14848,0),(32699,10,14848,0),(32700,2,14849,0),(32701,10,14849,0),(32702,2,14850,0),(32703,10,14850,0),(32704,2,14851,0),(32705,10,14851,0),(32706,2,14852,0),(32707,10,14852,0),(32708,2,14853,0),(32709,10,14853,0),(32710,2,14854,0),(32711,10,14854,0),(32712,2,14855,0),(32713,10,14855,0),(32714,2,14856,0),(32715,10,14856,0),(32716,2,14857,0),(32717,10,14857,0),(32718,2,14858,0),(32719,10,14858,0),(32720,2,14859,0),(32721,10,14859,0),(32722,2,14860,0),(32723,10,14860,0),(32724,2,14861,0),(32725,10,14861,0),(32726,2,14862,0),(32727,10,14862,0),(32728,2,14863,0),(32729,10,14863,0),(32730,2,14864,0),(32731,10,14864,0),(32732,2,14865,0),(32733,10,14865,0),(32734,2,14866,0),(32735,10,14866,0),(32736,2,14867,0),(32737,10,14867,0),(32738,2,14868,0),(32739,10,14868,0),(32740,2,14869,0),(32741,10,14869,0),(32742,2,14870,0),(32743,10,14870,0),(32744,2,14871,0),(32745,10,14871,0),(32746,2,14872,0),(32747,10,14872,0),(32748,2,14873,0),(32749,10,14873,0),(32750,2,14874,0),(32751,10,14874,0),(32752,2,14875,0),(32753,10,14875,0),(32754,2,14876,0),(32755,10,14876,0),(32756,2,14877,0),(32757,10,14877,0),(32758,2,14878,0),(32759,10,14878,0),(32760,2,14879,0),(32761,10,14879,0),(32762,2,14880,0),(32763,10,14880,0),(32764,2,14881,0),(32765,10,14881,0),(32766,2,14882,0),(32767,10,14882,0),(32768,2,14883,0),(32769,10,14883,0),(32770,2,14884,0),(32771,10,14884,0),(32772,2,14885,0),(32773,10,14885,0),(32774,2,14886,0),(32775,10,14886,0),(32776,2,14887,0),(32777,10,14887,0),(32778,2,14888,0),(32779,10,14888,0),(32780,2,14889,0),(32781,10,14889,0),(32782,2,14890,0),(32783,10,14890,0),(32784,2,14891,0),(32785,10,14891,0),(32786,2,14892,0),(32787,10,14892,0),(32788,2,14893,0),(32789,10,14893,0),(32790,2,14894,0),(32791,10,14894,0),(32792,2,14895,0),(32793,10,14895,0),(32794,2,14896,0),(32795,10,14896,0),(32796,2,14897,0),(32797,10,14897,0),(32798,2,14898,0),(32799,10,14898,0),(32800,2,14899,0),(32801,10,14899,0),(32802,2,14900,0),(32803,10,14900,0),(32804,2,14901,0),(32805,10,14901,0),(32806,2,14902,0),(32807,10,14902,0),(32808,2,14903,0),(32809,10,14903,0),(32810,2,14904,0),(32811,10,14904,0),(32812,2,14905,0),(32813,10,14905,0),(32814,2,14906,0),(32815,10,14906,0),(32816,2,14907,0),(32817,10,14907,0),(32818,2,14908,0),(32819,10,14908,0),(32820,2,14909,0),(32821,10,14909,0),(32822,2,14910,0),(32823,10,14910,0),(32824,2,14911,0),(32825,10,14911,0),(32826,2,14912,0),(32827,10,14912,0),(32828,2,14913,0),(32829,10,14913,0),(32830,2,14914,0),(32831,10,14914,0),(32832,2,14915,0),(32833,10,14915,0),(32834,2,14916,0),(32835,10,14916,0),(32836,2,14917,0),(32837,10,14917,0),(32838,2,14918,0),(32839,10,14918,0),(32840,2,14919,0),(32841,10,14919,0),(32842,2,14920,0),(32843,10,14920,0),(32844,2,14921,0),(32845,10,14921,0),(32846,2,14922,0),(32847,10,14922,0),(32848,2,14923,0),(32849,10,14923,0),(32850,2,14924,0),(32851,10,14924,0),(32852,2,14925,0),(32853,10,14925,0),(32854,2,14926,0),(32855,10,14926,0),(32856,2,14927,0),(32857,10,14927,0),(32858,2,14928,0),(32859,10,14928,0),(32860,2,14929,0),(32861,10,14929,0),(32862,2,14930,0),(32863,10,14930,0),(32864,2,14931,0),(32865,10,14931,0),(32866,2,14932,0),(32867,10,14932,0),(32868,2,14933,0),(32869,10,14933,0),(32870,2,14934,0),(32871,10,14934,0),(32872,2,14935,0),(32873,10,14935,0),(32874,2,14936,0),(32875,10,14936,0),(32876,2,14937,0),(32877,10,14937,0),(32878,2,14938,0),(32879,10,14938,0),(32880,2,14939,0),(32881,10,14939,0),(32882,2,14940,0),(32883,10,14940,0),(32884,2,14941,0),(32885,10,14941,0),(32886,2,14942,0),(32887,10,14942,0),(32888,2,14943,0),(32889,10,14943,0),(32890,2,14944,0),(32891,10,14944,0),(32892,2,14945,0),(32893,10,14945,0),(32894,2,14946,0),(32895,10,14946,0),(32896,2,14947,0),(32897,10,14947,0),(32898,2,14948,0),(32899,10,14948,0),(32900,2,14949,0),(32901,10,14949,0),(32902,2,14950,0),(32903,10,14950,0),(32904,2,14951,0),(32905,10,14951,0),(32906,2,14952,0),(32907,10,14952,0),(32908,2,14953,0),(32909,10,14953,0),(32910,2,14954,0),(32911,10,14954,0),(32912,2,14955,0),(32913,10,14955,0),(32914,2,14956,0),(32915,10,14956,0),(32916,2,14957,0),(32917,10,14957,0),(32918,2,14958,0),(32919,10,14958,0),(32920,2,14959,0),(32921,10,14959,0),(32922,2,14960,0),(32923,10,14960,0),(32924,2,14961,0),(32925,10,14961,0),(32926,2,14962,0),(32927,10,14962,0),(32928,2,14963,0),(32929,10,14963,0),(32930,2,14964,0),(32931,10,14964,0),(32932,2,14965,0),(32933,10,14965,0),(32934,2,14966,0),(32935,10,14966,0),(32936,2,14967,0),(32937,10,14967,0),(32938,2,14968,0),(32939,10,14968,0),(32940,2,14969,0),(32941,10,14969,0),(32942,2,14970,0),(32943,10,14970,0),(32944,2,14971,0),(32945,10,14971,0),(32946,2,14972,0),(32947,10,14972,0),(32948,2,14973,0),(32949,10,14973,0),(32950,2,14974,0),(32951,10,14974,0),(32952,2,14975,0),(32953,10,14975,0),(32954,2,14976,0),(32955,10,14976,0),(32956,2,14977,0),(32957,10,14977,0),(32958,2,14978,0),(32959,10,14978,0),(32960,2,14979,0),(32961,10,14979,0),(32962,2,14980,0),(32963,10,14980,0),(32964,2,14981,0),(32965,10,14981,0),(32966,2,14982,0),(32967,10,14982,0),(32968,2,14983,0),(32969,10,14983,0),(32970,2,14984,0),(32971,10,14984,0),(32972,2,14985,0),(32973,10,14985,0),(32974,2,14986,0),(32975,10,14986,0),(32976,2,14987,0),(32977,10,14987,0),(32978,2,14988,0),(32979,10,14988,0),(32980,2,14989,0),(32981,10,14989,0),(32982,2,14990,0),(32983,10,14990,0),(32984,2,14991,0),(32985,10,14991,0),(32986,2,14992,0),(32987,10,14992,0),(32988,2,14993,0),(32989,10,14993,0),(32990,2,14994,0),(32991,10,14994,0),(32992,2,14995,0),(32993,10,14995,0),(32994,2,14996,0),(32995,10,14996,0),(32996,2,14997,0),(32997,10,14997,0),(32998,2,14998,0),(32999,10,14998,0),(33000,2,14999,0),(33001,10,14999,0),(33002,2,15000,0),(33003,10,15000,0),(33004,2,15001,0),(33005,10,15001,0),(33006,2,15002,0),(33007,10,15002,0),(33008,2,15003,0),(33009,10,15003,0),(33010,2,15004,0),(33011,10,15004,0),(33012,2,15005,0),(33013,10,15005,0),(33014,2,15006,0),(33015,10,15006,0),(33016,2,15007,0),(33017,10,15007,0),(33018,2,15008,0),(33019,10,15008,0),(33020,2,15009,0),(33021,10,15009,0),(33022,2,15010,0),(33023,10,15010,0),(33024,2,15011,0),(33025,10,15011,0),(33026,2,15012,0),(33027,10,15012,0),(33028,2,15013,0),(33029,10,15013,0),(33030,2,15014,0),(33031,10,15014,0),(33032,2,15015,0),(33033,10,15015,0),(33034,2,15016,0),(33035,10,15016,0),(33036,2,15017,0),(33037,10,15017,0),(33038,2,15018,0),(33039,10,15018,0),(33040,2,15019,0),(33041,10,15019,0),(33042,2,15020,0),(33043,10,15020,0),(33044,2,15021,0),(33045,10,15021,0),(33046,2,15022,0),(33047,10,15022,0),(33048,2,15023,0),(33049,10,15023,0),(33050,2,15024,0),(33051,10,15024,0),(33052,2,15025,0),(33053,10,15025,0),(33054,2,15026,0),(33055,10,15026,0),(33056,2,15027,0),(33057,10,15027,0),(33058,2,15028,0),(33059,10,15028,0),(33060,2,15029,0),(33061,10,15029,0),(33062,2,15030,0),(33063,10,15030,0),(33064,2,15031,0),(33065,10,15031,0),(33066,2,15032,0),(33067,10,15032,0),(33068,2,15033,0),(33069,10,15033,0),(33070,2,15034,0),(33071,10,15034,0),(33072,2,15035,0),(33073,10,15035,0),(33074,2,15036,0),(33075,10,15036,0),(33076,2,15037,0),(33077,10,15037,0),(33078,2,15038,0),(33079,10,15038,0),(33080,2,15039,0),(33081,10,15039,0),(33082,2,15040,0),(33083,10,15040,0),(33084,2,15041,0),(33085,10,15041,0),(33086,2,15042,0),(33087,10,15042,0),(33088,2,15043,0),(33089,10,15043,0),(33090,2,15044,0),(33091,10,15044,0),(33092,2,15045,0),(33093,10,15045,0),(33094,2,15046,0),(33095,10,15046,0),(33096,2,15047,0),(33097,10,15047,0),(33098,2,15048,0),(33099,10,15048,0),(33100,2,15049,0),(33101,10,15049,0),(33102,2,15050,0),(33103,10,15050,0),(33104,2,15051,0),(33105,10,15051,0),(33106,2,15052,0),(33107,10,15052,0),(33108,2,15053,0),(33109,10,15053,0),(33110,2,15054,0),(33111,10,15054,0),(33112,2,15055,0),(33113,10,15055,0),(33114,2,15056,0),(33115,10,15056,0),(33116,2,15057,0),(33117,10,15057,0),(33118,2,15058,0),(33119,10,15058,0),(33120,2,15059,0),(33121,10,15059,0),(33122,2,15060,0),(33123,10,15060,0),(33124,2,15061,0),(33125,10,15061,0),(33126,2,15062,0),(33127,10,15062,0),(33128,2,15063,0),(33129,10,15063,0),(33130,2,15064,0),(33131,10,15064,0),(33132,2,15065,0),(33133,10,15065,0),(33134,2,15066,0),(33135,10,15066,0),(33136,2,15067,0),(33137,10,15067,0),(33138,2,15068,0),(33139,10,15068,0),(33140,2,15069,0),(33141,10,15069,0),(33142,2,15070,0),(33143,10,15070,0),(33144,2,15071,0),(33145,10,15071,0),(33146,2,15072,0),(33147,10,15072,0),(33148,2,15073,0),(33149,10,15073,0),(33150,2,15074,0),(33151,10,15074,0),(33152,2,15075,0),(33153,10,15075,0),(33154,2,15076,0),(33155,10,15076,0),(33156,2,15077,0),(33157,10,15077,0),(33158,2,15078,0),(33159,10,15078,0),(33160,2,15079,0),(33161,10,15079,0),(33162,2,15080,0),(33163,10,15080,0),(33164,2,15081,0),(33165,10,15081,0),(33166,2,15082,0),(33167,10,15082,0),(33168,2,15083,0),(33169,10,15083,0),(33170,2,15084,0),(33171,10,15084,0),(33172,2,15085,0),(33173,10,15085,0),(33174,2,15086,0),(33175,10,15086,0),(33176,2,15087,0),(33177,10,15087,0),(33178,2,15088,0),(33179,10,15088,0),(33180,2,15089,0),(33181,10,15089,0),(33182,2,15090,0),(33183,10,15090,0),(33184,2,15091,0),(33185,10,15091,0),(33186,2,15092,0),(33187,10,15092,0),(33188,2,15093,0),(33189,10,15093,0),(33190,2,15094,0),(33191,10,15094,0),(33192,2,15095,0),(33193,10,15095,0),(33194,2,15096,0),(33195,10,15096,0),(33196,2,15097,0),(33197,10,15097,0),(33198,2,15098,0),(33199,10,15098,0),(33200,2,15099,0),(33201,10,15099,0),(33202,2,15100,0),(33203,10,15100,0),(33204,2,15101,0),(33205,10,15101,0),(33206,2,15102,0),(33207,10,15102,0),(33208,2,15103,0),(33209,10,15103,0),(33210,2,15104,0),(33211,10,15104,0),(33212,2,15105,0),(33213,10,15105,0),(33214,2,15106,0),(33215,10,15106,0),(33216,2,15107,0),(33217,10,15107,0),(33218,2,15108,0),(33219,10,15108,0),(33220,2,15109,0),(33221,10,15109,0),(33222,2,15110,0),(33223,10,15110,0),(33224,2,15111,0),(33225,10,15111,0),(33226,2,15112,0),(33227,10,15112,0),(33228,2,15113,0),(33229,10,15113,0),(33230,2,15114,0),(33231,10,15114,0),(33232,2,15115,0),(33233,10,15115,0),(33234,2,15116,0),(33235,10,15116,0),(33236,2,15117,0),(33237,10,15117,0),(33238,2,15118,0),(33239,10,15118,0),(33240,2,15119,0),(33241,10,15119,0),(33242,2,15120,0),(33243,10,15120,0),(33244,2,15121,0),(33245,10,15121,0),(33246,2,15122,0),(33247,10,15122,0),(33248,2,15123,0),(33249,10,15123,0),(33250,2,15124,0),(33251,10,15124,0),(33252,2,15125,0),(33253,10,15125,0),(33254,2,15126,0),(33255,10,15126,0),(33256,2,15127,0),(33257,10,15127,0),(33258,2,15128,0),(33259,10,15128,0),(33260,2,15129,0),(33261,10,15129,0),(33262,2,15130,0),(33263,10,15130,0),(33264,2,15131,0),(33265,10,15131,0),(33266,2,15132,0),(33267,10,15132,0),(33268,2,15133,0),(33269,10,15133,0),(33270,2,15134,0),(33271,10,15134,0),(33272,2,15135,0),(33273,10,15135,0),(33274,2,15136,0),(33275,10,15136,0),(33276,2,15137,0),(33277,10,15137,0),(33278,2,15138,0),(33279,10,15138,0),(33280,2,15139,0),(33281,10,15139,0),(33282,2,15140,0),(33283,10,15140,0),(33284,2,15141,0),(33285,10,15141,0),(33286,2,15142,0),(33287,10,15142,0),(33288,2,15143,0),(33289,10,15143,0),(33290,2,15144,0),(33291,10,15144,0),(33292,2,15145,0),(33293,10,15145,0),(33294,2,15146,0),(33295,10,15146,0),(33296,2,15147,0),(33297,10,15147,0),(33298,2,15148,0),(33299,10,15148,0),(33300,2,15149,0),(33301,10,15149,0),(33302,2,15150,0),(33303,10,15150,0),(33304,2,15151,0),(33305,10,15151,0),(33306,2,15152,0),(33307,10,15152,0),(33308,2,15153,0),(33309,10,15153,0),(33310,2,15154,0),(33311,10,15154,0),(33312,2,15155,0),(33313,10,15155,0),(33314,2,15156,0),(33315,10,15156,0),(33316,2,15157,0),(33317,10,15157,0),(33318,2,15158,0),(33319,10,15158,0),(33320,2,15159,0),(33321,10,15159,0),(33322,2,15160,0),(33323,10,15160,0),(33324,2,15161,0),(33325,10,15161,0),(33326,2,15162,0),(33327,10,15162,0),(33328,2,15163,0),(33329,10,15163,0),(33330,2,15164,0),(33331,10,15164,0),(33332,2,15165,0),(33333,10,15165,0),(33334,2,15166,0),(33335,10,15166,0),(33336,2,15167,0),(33337,10,15167,0),(33338,2,15168,0),(33339,10,15168,0),(33340,2,15169,0),(33341,10,15169,0),(33342,2,15170,0),(33343,10,15170,0),(33344,2,15171,0),(33345,10,15171,0),(33346,2,15172,0),(33347,10,15172,0),(33348,2,15173,0),(33349,10,15173,0),(33350,2,15174,0),(33351,10,15174,0),(33352,2,15175,0),(33353,10,15175,0),(33354,2,15176,0),(33355,10,15176,0),(33356,2,15177,0),(33357,10,15177,0),(33358,2,15178,0),(33359,10,15178,0),(33360,2,15179,0),(33361,10,15179,0),(33362,2,15180,0),(33363,10,15180,0),(33364,2,15181,0),(33365,10,15181,0),(33366,2,15182,0),(33367,10,15182,0),(33368,2,15183,0),(33369,10,15183,0),(33370,2,15184,0),(33371,10,15184,0),(33372,2,15185,0),(33373,10,15185,0),(33374,2,15186,0),(33375,10,15186,0),(33376,2,15187,0),(33377,10,15187,0),(33378,2,15188,0),(33379,10,15188,0),(33380,2,15189,0),(33381,10,15189,0),(33382,2,15190,0),(33383,10,15190,0),(33384,2,15191,0),(33385,10,15191,0),(33386,2,15192,0),(33387,10,15192,0),(33388,2,15193,0),(33389,10,15193,0),(33390,2,15194,0),(33391,10,15194,0),(33392,2,15195,0),(33393,10,15195,0),(33394,2,15196,0),(33395,10,15196,0),(33396,2,15197,0),(33397,10,15197,0),(33398,2,15198,0),(33399,10,15198,0),(33400,2,15199,0),(33401,10,15199,0),(33402,2,15200,0),(33403,10,15200,0),(33404,2,15201,0),(33405,10,15201,0),(33406,2,15202,0),(33407,10,15202,0),(33408,2,15203,0),(33409,10,15203,0),(33410,2,15204,0),(33411,10,15204,0),(33412,2,15205,0),(33413,10,15205,0),(33414,2,15206,0),(33415,10,15206,0),(33416,2,15207,0),(33417,10,15207,0),(33418,2,15208,0),(33419,10,15208,0),(33420,2,15209,0),(33421,10,15209,0),(33422,2,15210,0),(33423,10,15210,0),(33424,2,15211,0),(33425,10,15211,0),(33426,2,15212,0),(33427,10,15212,0),(33428,2,15213,0),(33429,10,15213,0),(33430,2,15214,0),(33431,10,15214,0),(33432,2,15215,0),(33433,10,15215,0),(33434,2,15216,0),(33435,10,15216,0),(33436,2,15217,0),(33437,10,15217,0),(33438,2,15218,0),(33439,10,15218,0),(33440,2,15219,0),(33441,10,15219,0),(33442,2,15220,0),(33443,10,15220,0),(33444,2,15221,0),(33445,10,15221,0),(33446,2,15222,0),(33447,10,15222,0),(33448,2,15223,0),(33449,10,15223,0),(33450,2,15224,0),(33451,10,15224,0),(33452,2,15225,0),(33453,10,15225,0),(33454,2,15226,0),(33455,10,15226,0),(33456,2,15227,0),(33457,10,15227,0),(33458,2,15228,0),(33459,10,15228,0),(33460,2,15229,0),(33461,10,15229,0),(33462,2,15230,0),(33463,10,15230,0),(33464,2,15231,0),(33465,10,15231,0),(33466,2,15232,0),(33467,10,15232,0),(33468,2,15233,0),(33469,10,15233,0),(33470,2,15234,0),(33471,10,15234,0),(33472,2,15235,0),(33473,10,15235,0),(33474,2,15236,0),(33475,10,15236,0),(33476,2,15237,0),(33477,10,15237,0),(33478,2,15238,0),(33479,10,15238,0),(33480,2,15239,0),(33481,10,15239,0),(33482,2,15240,0),(33483,10,15240,0),(33484,2,15241,0),(33485,10,15241,0),(33486,2,15242,0),(33487,10,15242,0),(33488,2,15243,0),(33489,10,15243,0),(33490,2,15244,0),(33491,10,15244,0),(33492,2,15245,0),(33493,10,15245,0),(33494,2,15246,0),(33495,10,15246,0),(33496,2,15247,0),(33497,10,15247,0),(33498,2,15248,0),(33499,10,15248,0),(33500,2,15249,0),(33501,10,15249,0),(33502,2,15250,0),(33503,10,15250,0),(33504,2,15251,0),(33505,10,15251,0),(33506,2,15252,0),(33507,10,15252,0),(33508,2,15253,0),(33509,10,15253,0),(33510,2,15254,0),(33511,10,15254,0),(33512,2,15255,0),(33513,10,15255,0),(33514,2,15256,0),(33515,10,15256,0),(33516,2,15257,0),(33517,10,15257,0),(33518,2,15258,0),(33519,10,15258,0),(33520,2,15259,0),(33521,10,15259,0),(33522,2,15260,0),(33523,10,15260,0),(33524,2,15261,0),(33525,10,15261,0),(33526,2,15262,0),(33527,10,15262,0),(33528,2,15263,0),(33529,10,15263,0),(33530,2,15264,0),(33531,10,15264,0),(33532,2,15265,0),(33533,10,15265,0),(33534,2,15266,0),(33535,10,15266,0),(33536,2,15267,0),(33537,10,15267,0),(33538,2,15268,0),(33539,10,15268,0),(33540,2,15269,0),(33541,10,15269,0),(33542,2,15270,0),(33543,10,15270,0),(33544,2,15271,0),(33545,10,15271,0),(33546,2,15272,0),(33547,10,15272,0),(33548,2,15273,0),(33549,10,15273,0),(33550,2,15274,0),(33551,10,15274,0),(33552,2,15275,0),(33553,10,15275,0),(33554,2,15276,0),(33555,10,15276,0),(33556,2,15277,0),(33557,10,15277,0),(33558,2,15278,0),(33559,10,15278,0),(33560,2,15279,0),(33561,10,15279,0),(33562,2,15280,0),(33563,10,15280,0),(33564,2,15281,0),(33565,10,15281,0),(33566,2,15282,0),(33567,10,15282,0),(33568,2,15283,0),(33569,10,15283,0),(33570,2,15284,0),(33571,10,15284,0),(33572,2,15285,0),(33573,10,15285,0),(33574,2,15286,0),(33575,10,15286,0),(33576,2,15287,0),(33577,10,15287,0),(33578,2,15288,0),(33579,10,15288,0),(33580,2,15289,0),(33581,10,15289,0),(33582,2,15290,0),(33583,10,15290,0),(33584,2,15291,0),(33585,10,15291,0),(33586,2,15292,0),(33587,10,15292,0),(33588,2,15293,0),(33589,10,15293,0),(33590,2,15294,0),(33591,10,15294,0),(33592,2,15295,0),(33593,10,15295,0),(33594,2,15296,0),(33595,10,15296,0),(33596,2,15297,0),(33597,10,15297,0),(33598,2,15298,0),(33599,10,15298,0),(33600,2,15299,0),(33601,10,15299,0),(33602,2,15300,0),(33603,10,15300,0),(33604,2,15301,0),(33605,10,15301,0),(33606,2,15302,0),(33607,10,15302,0),(33608,2,15303,0),(33609,10,15303,0),(33610,2,15304,0),(33611,10,15304,0),(33612,2,15305,0),(33613,10,15305,0),(33614,2,15306,0),(33615,10,15306,0),(33616,2,15307,0),(33617,10,15307,0),(33618,2,15308,0),(33619,10,15308,0),(33620,2,15309,0),(33621,10,15309,0),(33622,2,15310,0),(33623,10,15310,0),(33624,2,15311,0),(33625,10,15311,0),(33626,2,15312,0),(33627,10,15312,0),(33628,2,15313,0),(33629,10,15313,0),(33630,2,15314,0),(33631,10,15314,0),(33632,2,15315,0),(33633,10,15315,0),(33634,2,15316,0),(33635,10,15316,0),(33636,2,15317,0),(33637,10,15317,0),(33638,2,15318,0),(33639,10,15318,0),(33640,2,15319,0),(33641,10,15319,0),(33642,2,15320,0),(33643,10,15320,0),(33644,2,15321,0),(33645,10,15321,0),(33646,2,15322,0),(33647,10,15322,0),(33648,2,15323,0),(33649,10,15323,0),(33650,2,15324,0),(33651,10,15324,0),(33652,2,15325,0),(33653,10,15325,0),(33654,2,15326,0),(33655,10,15326,0),(33656,2,15327,0),(33657,10,15327,0),(33658,2,15328,0),(33659,10,15328,0),(33660,2,15329,0),(33661,10,15329,0),(33662,2,15330,0),(33663,10,15330,0),(33664,2,15331,0),(33665,10,15331,0),(33666,2,15332,0),(33667,10,15332,0),(33668,2,15333,0),(33669,10,15333,0),(33670,2,15334,0),(33671,10,15334,0),(33672,2,15335,0),(33673,10,15335,0),(33674,2,15336,0),(33675,10,15336,0),(33676,2,15337,0),(33677,10,15337,0),(33678,2,15338,0),(33679,10,15338,0),(33680,2,15339,0),(33681,10,15339,0),(33682,2,15340,0),(33683,10,15340,0),(33684,2,15341,0),(33685,10,15341,0),(33686,2,15342,0),(33687,10,15342,0),(33688,2,15343,0),(33689,10,15343,0),(33690,2,15344,0),(33691,10,15344,0),(33692,2,15345,0),(33693,10,15345,0),(33694,2,15346,0),(33695,10,15346,0),(33696,2,15347,0),(33697,10,15347,0),(33698,2,15348,0),(33699,10,15348,0),(33700,2,15349,0),(33701,10,15349,0),(33702,2,15350,0),(33703,10,15350,0),(33704,2,15351,0),(33705,10,15351,0),(33706,2,15352,0),(33707,10,15352,0),(33708,2,15353,0),(33709,10,15353,0),(33710,2,15354,0),(33711,10,15354,0),(33712,2,15355,0),(33713,10,15355,0),(33714,2,15356,0),(33715,10,15356,0),(33716,2,15357,0),(33717,10,15357,0),(33718,2,15358,0),(33719,10,15358,0),(33720,2,15359,0),(33721,10,15359,0),(33722,2,15360,0),(33723,10,15360,0),(33724,2,15361,0),(33725,10,15361,0),(33726,2,15362,0),(33727,10,15362,0),(33728,2,15363,0),(33729,10,15363,0),(33730,2,15364,0),(33731,10,15364,0),(33732,2,15365,0),(33733,10,15365,0),(33734,2,15366,0),(33735,10,15366,0),(33736,2,15367,0),(33737,10,15367,0),(33738,2,15368,0),(33739,10,15368,0),(33740,2,15369,0),(33741,10,15369,0),(33742,2,15370,0),(33743,10,15370,0),(33744,2,15371,0),(33745,10,15371,0),(33746,2,15372,0),(33747,10,15372,0),(33748,2,15373,0),(33749,10,15373,0),(33750,2,15374,0),(33751,10,15374,0),(33752,2,15375,0),(33753,10,15375,0),(33754,2,15376,0),(33755,10,15376,0),(33756,2,15377,0),(33757,10,15377,0),(33758,2,15378,0),(33759,10,15378,0),(33760,2,15379,0),(33761,10,15379,0),(33762,2,15380,0),(33763,10,15380,0),(33764,2,15381,0),(33765,10,15381,0),(33766,2,15382,0),(33767,10,15382,0),(33768,2,15383,0),(33769,10,15383,0),(33770,2,15384,0),(33771,10,15384,0),(33772,2,15385,0),(33773,10,15385,0),(33774,2,15386,0),(33775,10,15386,0),(33776,2,15387,0),(33777,10,15387,0),(33778,2,15388,0),(33779,10,15388,0),(33780,2,15389,0),(33781,10,15389,0),(33782,2,15390,0),(33783,10,15390,0),(33784,2,15391,0),(33785,10,15391,0),(33786,2,15392,0),(33787,10,15392,0),(33788,2,15393,0),(33789,10,15393,0),(33790,2,15394,0),(33791,10,15394,0),(33792,2,15395,0),(33793,10,15395,0),(33794,2,15396,0),(33795,10,15396,0),(33796,2,15397,0),(33797,10,15397,0),(33798,2,15398,0),(33799,10,15398,0),(33800,2,15399,0),(33801,10,15399,0),(33802,2,15400,0),(33803,10,15400,0),(33804,2,15401,0),(33805,10,15401,0),(33806,2,15402,0),(33807,10,15402,0),(33808,2,15403,0),(33809,10,15403,0),(33810,2,15404,0),(33811,10,15404,0),(33812,2,15405,0),(33813,10,15405,0),(33814,2,15406,0),(33815,10,15406,0),(33816,2,15407,0),(33817,10,15407,0),(33818,2,15408,0),(33819,10,15408,0),(33820,2,15409,0),(33821,10,15409,0),(33822,2,15410,0),(33823,10,15410,0),(33824,2,15411,0),(33825,10,15411,0),(33826,2,15412,0),(33827,10,15412,0),(33828,2,15413,0),(33829,10,15413,0),(33830,2,15414,0),(33831,10,15414,0),(33832,2,15415,0),(33833,10,15415,0),(33834,2,15416,0),(33835,10,15416,0),(33836,2,15417,0),(33837,10,15417,0),(33838,2,15418,0),(33839,10,15418,0),(33840,2,15419,0),(33841,10,15419,0),(33842,2,15420,0),(33843,10,15420,0),(33844,2,15421,0),(33845,10,15421,0),(33846,2,15422,0),(33847,10,15422,0),(33848,2,15423,0),(33849,10,15423,0),(33850,2,15424,0),(33851,10,15424,0),(33852,2,15425,0),(33853,10,15425,0),(33854,2,15426,0),(33855,10,15426,0),(33856,2,15427,0),(33857,10,15427,0),(33858,2,15428,0),(33859,10,15428,0),(33860,2,15429,0),(33861,10,15429,0),(33862,2,15430,0),(33863,10,15430,0),(33864,2,15431,0),(33865,10,15431,0),(33866,2,15432,0),(33867,10,15432,0),(33868,2,15433,0),(33869,10,15433,0),(33870,2,15434,0),(33871,10,15434,0),(33872,2,15435,0),(33873,10,15435,0),(33874,2,15436,0),(33875,10,15436,0),(33876,2,15437,0),(33877,10,15437,0),(33878,2,15438,0),(33879,10,15438,0),(33880,2,15439,0),(33881,10,15439,0),(33882,2,15440,0),(33883,10,15440,0),(33884,2,15441,0),(33885,10,15441,0),(33886,2,15442,0),(33887,10,15442,0),(33888,2,15443,0),(33889,10,15443,0),(33890,2,15444,0),(33891,10,15444,0),(33892,2,15445,0),(33893,10,15445,0),(33894,2,15446,0),(33895,10,15446,0),(33896,2,15447,0),(33897,10,15447,0),(33898,2,15448,0),(33899,10,15448,0),(33900,2,15449,0),(33901,10,15449,0),(33902,2,15450,0),(33903,10,15450,0),(33904,2,15451,0),(33905,10,15451,0),(33906,2,15452,0),(33907,10,15452,0),(33908,2,15453,0),(33909,10,15453,0),(33910,2,15454,0),(33911,10,15454,0),(33912,2,15455,0),(33913,10,15455,0),(33914,2,15456,0),(33915,10,15456,0),(33916,2,15457,0),(33917,10,15457,0),(33918,2,15458,0),(33919,10,15458,0),(33920,2,15459,0),(33921,10,15459,0),(33922,2,15460,0),(33923,10,15460,0),(33924,2,15461,0),(33925,10,15461,0),(33926,2,15462,0),(33927,10,15462,0),(33928,2,15463,0),(33929,10,15463,0),(33930,2,15464,0),(33931,10,15464,0),(33932,2,15465,0),(33933,10,15465,0),(33934,2,15466,0),(33935,10,15466,0),(33936,2,15467,0),(33937,10,15467,0),(33938,2,15468,0),(33939,10,15468,0),(33940,2,15469,0),(33941,10,15469,0),(33942,2,15470,0),(33943,10,15470,0),(33944,2,15471,0),(33945,10,15471,0),(33946,2,15472,0),(33947,10,15472,0),(33948,2,15473,0),(33949,10,15473,0),(33950,2,15474,0),(33951,10,15474,0),(33952,2,15475,0),(33953,10,15475,0),(33954,2,15476,0),(33955,10,15476,0),(33956,2,15477,0),(33957,10,15477,0),(33958,2,15478,0),(33959,10,15478,0),(33960,2,15479,0),(33961,10,15479,0),(33962,2,15480,0),(33963,10,15480,0),(33964,2,15481,0),(33965,10,15481,0),(33966,2,15482,0),(33967,10,15482,0),(33968,2,15483,0),(33969,10,15483,0),(33970,2,15484,0),(33971,10,15484,0),(33972,2,15485,0),(33973,10,15485,0),(33974,2,15486,0),(33975,10,15486,0),(33976,2,15487,0),(33977,10,15487,0),(33978,2,15488,0),(33979,10,15488,0),(33980,2,15489,0),(33981,10,15489,0),(33982,2,15490,0),(33983,10,15490,0),(33984,2,15491,0),(33985,10,15491,0),(33986,2,15492,0),(33987,10,15492,0),(33988,2,15493,0),(33989,10,15493,0),(33990,2,15494,0),(33991,10,15494,0),(33992,2,15495,0),(33993,10,15495,0),(33994,2,15496,0),(33995,10,15496,0),(33996,2,15497,0),(33997,10,15497,0),(33998,2,15498,0),(33999,10,15498,0),(34000,2,15499,0),(34001,10,15499,0),(34002,2,15500,0),(34003,10,15500,0),(34004,2,15501,0),(34005,10,15501,0),(34006,2,15502,0),(34007,10,15502,0),(34008,2,15503,0),(34009,10,15503,0),(34010,2,15504,0),(34011,10,15504,0),(34012,2,15505,0),(34013,10,15505,0),(34014,2,15506,0),(34015,10,15506,0),(34016,2,15507,0),(34017,10,15507,0),(34018,2,15508,0),(34019,10,15508,0),(34020,2,15509,0),(34021,10,15509,0),(34022,2,15510,0),(34023,10,15510,0),(34024,2,15511,0),(34025,10,15511,0),(34026,2,15512,0),(34027,10,15512,0),(34028,2,15513,0),(34029,10,15513,0),(34030,2,15514,0),(34031,10,15514,0),(34032,2,15515,0),(34033,10,15515,0),(34034,2,15516,0),(34035,10,15516,0),(34036,2,15517,0),(34037,10,15517,0),(34038,2,15518,0),(34039,10,15518,0),(34040,2,15519,0),(34041,10,15519,0),(34042,2,15520,0),(34043,10,15520,0),(34044,2,15521,0),(34045,10,15521,0),(34046,2,15522,0),(34047,10,15522,0),(34048,2,15523,0),(34049,10,15523,0),(34050,2,15524,0),(34051,10,15524,0),(34052,2,15525,0),(34053,10,15525,0),(34054,2,15526,0),(34055,10,15526,0),(34056,2,15527,0),(34057,10,15527,0),(34058,2,15528,0),(34059,10,15528,0),(34060,2,15529,0),(34061,10,15529,0),(34062,2,15530,0),(34063,10,15530,0),(34064,2,15531,0),(34065,10,15531,0),(34066,2,15532,0),(34067,10,15532,0),(34068,2,15533,0),(34069,10,15533,0),(34070,2,15534,0),(34071,10,15534,0),(34072,2,15535,0),(34073,10,15535,0),(34074,2,15536,0),(34075,10,15536,0),(34076,2,15537,0),(34077,10,15537,0),(34078,2,15538,0),(34079,10,15538,0),(34080,2,15539,0),(34081,10,15539,0),(34082,2,15540,0),(34083,10,15540,0),(34084,2,15541,0),(34085,10,15541,0),(34086,2,15542,0),(34087,10,15542,0),(34088,2,15543,0),(34089,10,15543,0),(34090,2,15544,0),(34091,10,15544,0),(34092,2,15545,0),(34093,10,15545,0),(34094,2,15546,0),(34095,10,15546,0),(34096,2,15547,0),(34097,10,15547,0),(34098,2,15548,0),(34099,10,15548,0),(34100,2,15549,0),(34101,10,15549,0),(34102,2,15550,0),(34103,10,15550,0),(34104,2,15551,0),(34105,10,15551,0),(34106,2,15552,0),(34107,10,15552,0),(34108,2,15553,0),(34109,10,15553,0),(34110,2,15554,0),(34111,10,15554,0),(34112,2,15555,0),(34113,10,15555,0),(34114,2,15556,0),(34115,10,15556,0),(34116,2,15557,0),(34117,10,15557,0),(34118,2,15558,0),(34119,10,15558,0),(34120,2,15559,0),(34121,10,15559,0),(34122,2,15560,0),(34123,10,15560,0),(34124,2,15561,0),(34125,10,15561,0),(34126,2,15562,0),(34127,10,15562,0),(34128,2,15563,0),(34129,10,15563,0),(34130,2,15564,0),(34131,10,15564,0),(34132,2,15565,0),(34133,10,15565,0),(34134,2,15566,0),(34135,10,15566,0),(34136,2,15567,0),(34137,10,15567,0),(34138,2,15568,0),(34139,10,15568,0),(34140,2,15569,0),(34141,10,15569,0),(34142,2,15570,0),(34143,10,15570,0),(34144,2,15571,0),(34145,10,15571,0),(34146,2,15572,0),(34147,10,15572,0),(34148,2,15573,0),(34149,10,15573,0),(34150,2,15574,0),(34151,10,15574,0),(34152,2,15575,0),(34153,10,15575,0),(34154,2,15576,0),(34155,10,15576,0),(34156,2,15577,0),(34157,10,15577,0),(34158,2,15578,0),(34159,10,15578,0),(34160,2,15579,0),(34161,10,15579,0),(34162,2,15580,0),(34163,10,15580,0),(34164,2,15581,0),(34165,10,15581,0),(34166,2,15582,0),(34167,10,15582,0),(34168,2,15583,0),(34169,10,15583,0),(34170,2,15584,0),(34171,10,15584,0),(34172,2,15585,0),(34173,10,15585,0),(34174,2,15586,0),(34175,10,15586,0),(34176,2,15587,0),(34177,10,15587,0),(34178,2,15588,0),(34179,10,15588,0),(34180,2,15589,0),(34181,10,15589,0),(34182,2,15590,0),(34183,10,15590,0),(34184,2,15591,0),(34185,10,15591,0),(34186,2,15592,0),(34187,10,15592,0),(34188,2,15593,0),(34189,10,15593,0),(34190,2,15594,0),(34191,10,15594,0),(34192,2,15595,0),(34193,10,15595,0),(34194,2,15596,0),(34195,10,15596,0),(34196,2,15597,0),(34197,10,15597,0),(34198,2,15598,0),(34199,10,15598,0),(34200,2,15599,0),(34201,10,15599,0),(34202,2,15600,0),(34203,10,15600,0),(34204,2,15601,0),(34205,10,15601,0),(34206,2,15602,0),(34207,10,15602,0),(34208,2,15603,0),(34209,10,15603,0),(34210,2,15604,0),(34211,10,15604,0),(34212,2,15605,0),(34213,10,15605,0),(34214,2,15606,0),(34215,10,15606,0),(34216,2,15607,0),(34217,10,15607,0),(34218,2,15608,0),(34219,10,15608,0),(34220,2,15609,0),(34221,10,15609,0),(34222,2,15610,0),(34223,10,15610,0),(34224,2,15611,0),(34225,10,15611,0),(34226,2,15612,0),(34227,10,15612,0),(34228,2,15613,0),(34229,10,15613,0),(34230,2,15614,0),(34231,10,15614,0),(34232,2,15615,0),(34233,10,15615,0),(34234,2,15616,0),(34235,10,15616,0),(34236,2,15617,0),(34237,10,15617,0),(34238,2,15618,0),(34239,10,15618,0),(34240,2,15619,0),(34241,10,15619,0),(34242,2,15620,0),(34243,10,15620,0),(34244,2,15621,0),(34245,10,15621,0),(34246,2,15622,0),(34247,10,15622,0),(34248,2,15623,0),(34249,10,15623,0),(34250,2,15624,0),(34251,10,15624,0),(34252,2,15625,0),(34253,10,15625,0),(34254,2,15626,0),(34255,10,15626,0),(34256,2,15627,0),(34257,10,15627,0),(34258,2,15628,0),(34259,10,15628,0),(34260,2,15629,0),(34261,10,15629,0),(34262,2,15630,0),(34263,10,15630,0),(34264,2,15631,0),(34265,10,15631,0),(34266,2,15632,0),(34267,10,15632,0),(34268,2,15633,0),(34269,10,15633,0),(34270,2,15634,0),(34271,10,15634,0),(34272,2,15635,0),(34273,10,15635,0),(34274,2,15636,0),(34275,10,15636,0),(34276,2,15637,0),(34277,10,15637,0),(34278,2,15638,0),(34279,10,15638,0),(34280,2,15639,0),(34281,10,15639,0),(34282,2,15640,0),(34283,10,15640,0),(34284,2,15641,0),(34285,10,15641,0),(34286,2,15642,0),(34287,10,15642,0),(34288,2,15643,0),(34289,10,15643,0),(34290,2,15644,0),(34291,10,15644,0),(34292,2,15645,0),(34293,10,15645,0),(34294,2,15646,0),(34295,10,15646,0),(34296,2,15647,0),(34297,10,15647,0),(34298,2,15648,0),(34299,10,15648,0),(34300,2,15649,0),(34301,10,15649,0),(34302,2,15650,0),(34303,10,15650,0),(34304,2,15651,0),(34305,10,15651,0),(34306,2,15652,0),(34307,10,15652,0),(34308,2,15653,0),(34309,10,15653,0),(34310,2,15654,0),(34311,10,15654,0),(34312,2,15655,0),(34313,10,15655,0),(34314,2,15656,0),(34315,10,15656,0),(34316,2,15657,0),(34317,10,15657,0),(34318,2,15658,0),(34319,10,15658,0),(34320,2,15659,0),(34321,10,15659,0),(34322,2,15660,0),(34323,10,15660,0),(34324,2,15661,0),(34325,10,15661,0),(34326,2,15662,0),(34327,10,15662,0),(34328,2,15663,0),(34329,10,15663,0),(34330,2,15664,0),(34331,10,15664,0),(34332,2,15665,0),(34333,10,15665,0),(34334,2,15666,0),(34335,10,15666,0),(34336,2,15667,0),(34337,10,15667,0),(34338,2,15668,0),(34339,10,15668,0),(34340,2,15669,0),(34341,10,15669,0),(34342,2,15670,0),(34343,10,15670,0),(34344,2,15671,0),(34345,10,15671,0),(34346,2,15672,0),(34347,10,15672,0),(34348,2,15673,0),(34349,10,15673,0),(34350,2,15674,0),(34351,10,15674,0),(34352,2,15675,0),(34353,10,15675,0),(34354,2,15676,0),(34355,10,15676,0),(34356,2,15677,0),(34357,10,15677,0),(34358,2,15678,0),(34359,10,15678,0),(34360,2,15679,0),(34361,10,15679,0),(34362,2,15680,0),(34363,10,15680,0),(34364,2,15681,0),(34365,10,15681,0),(34366,2,15682,0),(34367,10,15682,0),(34368,2,15683,0),(34369,10,15683,0),(34370,2,15684,0),(34371,10,15684,0),(34372,2,15685,0),(34373,10,15685,0),(34374,2,15686,0),(34375,10,15686,0),(34376,2,15687,0),(34377,10,15687,0),(34378,2,15688,0),(34379,10,15688,0),(34380,2,15689,0),(34381,10,15689,0),(34382,2,15690,0),(34383,10,15690,0),(34384,2,15691,0),(34385,10,15691,0),(34386,2,15692,0),(34387,10,15692,0),(34388,2,15693,0),(34389,10,15693,0),(34390,2,15694,0),(34391,10,15694,0),(34392,2,15695,0),(34393,10,15695,0),(34394,2,15696,0),(34395,10,15696,0),(34396,2,15697,0),(34397,10,15697,0),(34398,2,15698,0),(34399,10,15698,0),(34400,2,15699,0),(34401,10,15699,0),(34402,2,15700,0),(34403,10,15700,0),(34404,2,15701,0),(34405,10,15701,0),(34406,2,15702,0),(34407,10,15702,0),(34408,2,15703,0),(34409,10,15703,0),(34410,2,15704,0),(34411,10,15704,0),(34412,2,15705,0),(34413,10,15705,0),(34414,2,15706,0),(34415,10,15706,0),(34416,2,15707,0),(34417,10,15707,0),(34418,2,15708,0),(34419,10,15708,0),(34420,2,15709,0),(34421,10,15709,0),(34422,2,15710,0),(34423,10,15710,0),(34424,2,15711,0),(34425,10,15711,0),(34426,2,15712,0),(34427,10,15712,0),(34428,2,15713,0),(34429,10,15713,0),(34430,2,15714,0),(34431,10,15714,0),(34432,2,15715,0),(34433,10,15715,0),(34434,2,15716,0),(34435,10,15716,0),(34436,2,15717,0),(34437,10,15717,0),(34438,2,15718,0),(34439,10,15718,0),(34440,2,15719,0),(34441,10,15719,0),(34442,2,15720,0),(34443,10,15720,0),(34444,2,15721,0),(34445,10,15721,0),(34446,2,15722,0),(34447,10,15722,0),(34448,2,15723,0),(34449,10,15723,0),(34450,2,15724,0),(34451,10,15724,0),(34452,2,15725,0),(34453,10,15725,0),(34454,2,15726,0),(34455,10,15726,0),(34456,2,15727,0),(34457,10,15727,0),(34458,2,15728,0),(34459,10,15728,0),(34460,2,15729,0),(34461,10,15729,0),(34462,2,15730,0),(34463,10,15730,0),(34464,2,15731,0),(34465,10,15731,0),(34466,2,15732,0),(34467,10,15732,0),(34468,2,15733,0),(34469,10,15733,0),(34470,2,15734,0),(34471,10,15734,0),(34472,2,15735,0),(34473,10,15735,0),(34474,2,15736,0),(34475,10,15736,0),(34476,2,15737,0),(34477,10,15737,0),(34478,2,15738,0),(34479,10,15738,0),(34480,2,15739,0),(34481,10,15739,0),(34482,2,15740,0),(34483,10,15740,0),(34484,2,15741,0),(34485,10,15741,0),(34486,2,15742,0),(34487,10,15742,0),(34488,2,15743,0),(34489,10,15743,0),(34490,2,15744,0),(34491,10,15744,0),(34492,2,15745,0),(34493,10,15745,0),(34494,2,15746,0),(34495,10,15746,0),(34496,2,15747,0),(34497,10,15747,0),(34498,2,15748,0),(34499,10,15748,0),(34500,2,15749,0),(34501,10,15749,0),(34502,2,15750,0),(34503,10,15750,0),(34504,2,15751,0),(34505,10,15751,0),(34506,2,15752,0),(34507,10,15752,0),(34508,2,15753,0),(34509,10,15753,0),(34510,2,15754,0),(34511,10,15754,0),(34512,2,15755,0),(34513,10,15755,0),(34514,2,15756,0),(34515,10,15756,0),(34516,2,15757,0),(34517,10,15757,0),(34518,2,15758,0),(34519,10,15758,0),(34520,2,15759,0),(34521,10,15759,0),(34522,2,15760,0),(34523,10,15760,0),(34524,2,15761,0),(34525,10,15761,0),(34526,2,15762,0),(34527,10,15762,0),(34528,2,15763,0),(34529,10,15763,0),(34530,2,15764,0),(34531,10,15764,0),(34532,2,15765,0),(34533,10,15765,0),(34534,2,15766,0),(34535,10,15766,0),(34536,2,15767,0),(34537,10,15767,0),(34538,2,15768,0),(34539,10,15768,0),(34540,2,15769,0),(34541,10,15769,0),(34542,2,15770,0),(34543,10,15770,0),(34544,2,15771,0),(34545,10,15771,0),(34546,2,15772,0),(34547,10,15772,0),(34548,2,15773,0),(34549,10,15773,0),(34550,2,15774,0),(34551,10,15774,0),(34552,2,15775,0),(34553,10,15775,0),(34554,2,15776,0),(34555,10,15776,0),(34556,2,15777,0),(34557,10,15777,0),(34558,2,15778,0),(34559,10,15778,0),(34560,2,15779,0),(34561,10,15779,0),(34562,2,15780,0),(34563,10,15780,0),(34564,2,15781,0),(34565,10,15781,0),(34566,2,15782,0),(34567,10,15782,0),(34568,2,15783,0),(34569,10,15783,0),(34570,2,15784,0),(34571,10,15784,0),(34572,2,15785,0),(34573,10,15785,0),(34574,2,15786,0),(34575,10,15786,0),(34576,2,15787,0),(34577,10,15787,0),(34578,2,15788,0),(34579,10,15788,0),(34580,2,15789,0),(34581,10,15789,0),(34582,2,15790,0),(34583,10,15790,0),(34584,2,15791,0),(34585,10,15791,0),(34586,2,15792,0),(34587,10,15792,0),(34588,2,15793,0),(34589,10,15793,0),(34590,2,15794,0),(34591,10,15794,0),(34592,2,15795,0),(34593,10,15795,0),(34594,2,15796,0),(34595,10,15796,0),(34596,2,15797,0),(34597,10,15797,0),(34598,2,15798,0),(34599,10,15798,0),(34600,2,15799,0),(34601,10,15799,0),(34602,2,15800,0),(34603,10,15800,0),(34604,2,15801,0),(34605,10,15801,0),(34606,2,15802,0),(34607,10,15802,0),(34608,2,15803,0),(34609,10,15803,0),(34610,2,15804,0),(34611,10,15804,0),(34612,2,15805,0),(34613,10,15805,0),(34614,2,15806,0),(34615,10,15806,0),(34616,2,15807,0),(34617,10,15807,0),(34618,2,15808,0),(34619,10,15808,0),(34620,2,15809,0),(34621,10,15809,0),(34622,2,15810,0),(34623,10,15810,0),(34624,2,15811,0),(34625,10,15811,0),(34626,2,15812,0),(34627,10,15812,0),(34628,2,15813,0),(34629,10,15813,0),(34630,2,15814,0),(34631,10,15814,0),(34632,2,15815,0),(34633,10,15815,0),(34634,2,15816,0),(34635,10,15816,0),(34636,2,15817,0),(34637,10,15817,0),(34638,2,15818,0),(34639,10,15818,0),(34640,2,15819,0),(34641,10,15819,0),(34642,2,15820,0),(34643,10,15820,0),(34644,2,15821,0),(34645,10,15821,0),(34646,2,15822,0),(34647,10,15822,0),(34648,2,15823,0),(34649,10,15823,0),(34650,2,15824,0),(34651,10,15824,0),(34652,2,15825,0),(34653,10,15825,0),(34654,2,15826,0),(34655,10,15826,0),(34656,2,15827,0),(34657,10,15827,0),(34658,2,15828,0),(34659,10,15828,0),(34660,2,15829,0),(34661,10,15829,0),(34662,2,15830,0),(34663,10,15830,0),(34664,2,15831,0),(34665,10,15831,0),(34666,2,15832,0),(34667,10,15832,0),(34668,2,15833,0),(34669,10,15833,0),(34670,2,15834,0),(34671,10,15834,0),(34672,2,15835,0),(34673,10,15835,0),(34674,2,15836,0),(34675,10,15836,0),(34676,2,15837,0),(34677,10,15837,0),(34678,2,15838,0),(34679,10,15838,0),(34680,2,15839,0),(34681,10,15839,0),(34682,2,15840,0),(34683,10,15840,0),(34684,2,15841,0),(34685,10,15841,0),(34686,2,15842,0),(34687,10,15842,0),(34688,2,15843,0),(34689,10,15843,0),(34690,2,15844,0),(34691,10,15844,0),(34692,2,15845,0),(34693,10,15845,0),(34694,2,15846,0),(34695,10,15846,0),(34696,2,15847,0),(34697,10,15847,0),(34698,2,15848,0),(34699,10,15848,0),(34700,2,15849,0),(34701,10,15849,0),(34702,2,15850,0),(34703,10,15850,0),(34704,2,15851,0),(34705,10,15851,0),(34706,2,15852,0),(34707,10,15852,0),(34708,2,15853,0),(34709,10,15853,0),(34710,2,15854,0),(34711,10,15854,0),(34712,2,15855,0),(34713,10,15855,0),(34714,2,15856,0),(34715,10,15856,0),(34716,2,15857,0),(34717,10,15857,0),(34718,2,15858,0),(34719,10,15858,0),(34720,2,15859,0),(34721,10,15859,0),(34722,2,15860,0),(34723,10,15860,0),(34724,2,15861,0),(34725,10,15861,0),(34726,2,15862,0),(34727,10,15862,0),(34728,2,15863,0),(34729,10,15863,0),(34730,2,15864,0),(34731,10,15864,0),(34732,2,15865,0),(34733,10,15865,0),(34734,2,15866,0),(34735,10,15866,0),(34736,2,15867,0),(34737,10,15867,0),(34738,2,15868,0),(34739,10,15868,0),(34740,2,15869,0),(34741,10,15869,0),(34742,2,15870,0),(34743,10,15870,0),(34744,2,15871,0),(34745,10,15871,0),(34746,2,15872,0),(34747,10,15872,0),(34748,2,15873,0),(34749,10,15873,0),(34750,2,15874,0),(34751,10,15874,0),(34752,2,15875,0),(34753,10,15875,0),(34754,2,15876,0),(34755,10,15876,0),(34756,2,15877,0),(34757,10,15877,0),(34758,2,15878,0),(34759,10,15878,0),(34760,2,15879,0),(34761,10,15879,0),(34762,2,15880,0),(34763,10,15880,0),(34764,2,15881,0),(34765,10,15881,0),(34766,2,15882,0),(34767,10,15882,0),(34768,2,15883,0),(34769,10,15883,0),(34770,2,15884,0),(34771,10,15884,0),(34772,2,15885,0),(34773,10,15885,0),(34774,2,15886,0),(34775,10,15886,0),(34776,2,15887,0),(34777,10,15887,0),(34778,2,15888,0),(34779,10,15888,0),(34780,2,15889,0),(34781,10,15889,0),(34782,2,15890,0),(34783,10,15890,0),(34784,2,15891,0),(34785,10,15891,0),(34786,2,15892,0),(34787,10,15892,0),(34788,2,15893,0),(34789,10,15893,0),(34790,2,15894,0),(34791,10,15894,0),(34792,2,15895,0),(34793,10,15895,0),(34794,2,15896,0),(34795,10,15896,0),(34796,2,15897,0),(34797,10,15897,0),(34798,2,15898,0),(34799,10,15898,0),(34800,2,15899,0),(34801,10,15899,0),(34802,2,15900,0),(34803,10,15900,0),(34804,2,15901,0),(34805,10,15901,0),(34806,2,15902,0),(34807,10,15902,0),(34808,2,15903,0),(34809,10,15903,0),(34810,2,15904,0),(34811,10,15904,0),(34812,2,15905,0),(34813,10,15905,0),(34814,2,15906,0),(34815,10,15906,0),(34816,2,15907,0),(34817,10,15907,0),(34818,2,15908,0),(34819,10,15908,0),(34820,2,15909,0),(34821,10,15909,0),(34822,2,15910,0),(34823,10,15910,0),(34824,2,15911,0),(34825,10,15911,0),(34826,2,15912,0),(34827,10,15912,0),(34828,2,15913,0),(34829,10,15913,0),(34830,2,15914,0),(34831,10,15914,0),(34832,2,15915,0),(34833,10,15915,0),(34834,2,15916,0),(34835,10,15916,0),(34836,2,15917,0),(34837,10,15917,0),(34838,2,15918,0),(34839,10,15918,0),(34840,2,15919,0),(34841,10,15919,0),(34842,2,15920,0),(34843,10,15920,0),(34844,2,15921,0),(34845,10,15921,0),(34846,2,15922,0),(34847,10,15922,0),(34848,2,15923,0),(34849,10,15923,0),(34850,2,15924,0),(34851,10,15924,0),(34852,2,15925,0),(34853,10,15925,0),(34854,2,15926,0),(34855,10,15926,0),(34856,2,15927,0),(34857,10,15927,0),(34858,2,15928,0),(34859,10,15928,0),(34860,2,15929,0),(34861,10,15929,0),(34862,2,15930,0),(34863,10,15930,0),(34864,2,15931,0),(34865,10,15931,0),(34866,2,15932,0),(34867,10,15932,0),(34868,2,15933,0),(34869,10,15933,0),(34870,2,15934,0),(34871,10,15934,0),(34872,2,15935,0),(34873,10,15935,0),(34874,2,15936,0),(34875,10,15936,0),(34876,2,15937,0),(34877,10,15937,0),(34878,2,15938,0),(34879,10,15938,0),(34880,2,15939,0),(34881,10,15939,0),(34882,2,15940,0),(34883,10,15940,0),(34884,2,15941,0),(34885,10,15941,0),(34886,2,15942,0),(34887,10,15942,0),(34888,2,15943,0),(34889,10,15943,0),(34890,2,15944,0),(34891,10,15944,0),(34892,2,15945,0),(34893,10,15945,0),(34894,2,15946,0),(34895,10,15946,0),(34896,2,15947,0),(34897,10,15947,0),(34898,2,15948,0),(34899,10,15948,0),(34900,2,15949,0),(34901,10,15949,0),(34902,2,15950,0),(34903,10,15950,0),(34904,2,15951,0),(34905,10,15951,0),(34906,2,15952,0),(34907,10,15952,0),(34908,2,15953,0),(34909,10,15953,0),(34910,2,15954,0),(34911,10,15954,0),(34912,2,15955,0),(34913,10,15955,0),(34914,2,15956,0),(34915,10,15956,0),(34916,2,15957,0),(34917,10,15957,0),(34918,2,15958,0),(34919,10,15958,0),(34920,2,15959,0),(34921,10,15959,0),(34922,2,15960,0),(34923,10,15960,0),(34924,2,15961,0),(34925,10,15961,0),(34926,2,15962,0),(34927,10,15962,0),(34928,2,15963,0),(34929,10,15963,0),(34930,2,15964,0),(34931,10,15964,0),(34932,2,15965,0),(34933,10,15965,0),(34934,2,15966,0),(34935,10,15966,0),(34936,2,15967,0),(34937,10,15967,0),(34938,2,15968,0),(34939,10,15968,0),(34940,2,15969,0),(34941,10,15969,0),(34942,2,15970,0),(34943,10,15970,0),(34944,2,15971,0),(34945,10,15971,0),(34946,2,15972,0),(34947,10,15972,0),(34948,2,15973,0),(34949,10,15973,0),(34950,2,15974,0),(34951,10,15974,0),(34952,2,15975,0),(34953,10,15975,0),(34954,2,15976,0),(34955,10,15976,0),(34956,2,15977,0),(34957,10,15977,0),(34958,2,15978,0),(34959,10,15978,0),(34960,2,15979,0),(34961,10,15979,0),(34962,2,15980,0),(34963,10,15980,0),(34964,2,15981,0),(34965,10,15981,0),(34966,2,15982,0),(34967,10,15982,0),(34968,2,15983,0),(34969,10,15983,0),(34970,2,15984,0),(34971,10,15984,0),(34972,2,15985,0),(34973,10,15985,0),(34974,2,15986,0),(34975,10,15986,0),(34976,2,15987,0),(34977,10,15987,0),(34978,2,15988,0),(34979,10,15988,0),(34980,2,15989,0),(34981,10,15989,0),(34982,2,15990,0),(34983,10,15990,0),(34984,2,15991,0),(34985,10,15991,0),(34986,2,15992,0),(34987,10,15992,0),(34988,2,15993,0),(34989,10,15993,0),(34990,2,15994,0),(34991,10,15994,0),(34992,2,15995,0),(34993,10,15995,0),(34994,2,15996,0),(34995,10,15996,0),(34996,2,15997,0),(34997,10,15997,0),(34998,2,15998,0),(34999,10,15998,0),(35000,2,15999,0),(35001,10,15999,0),(35002,2,16000,0),(35003,10,16000,0),(35004,2,16001,0),(35005,10,16001,0),(35006,2,16002,0),(35007,10,16002,0),(35008,2,16003,0),(35009,10,16003,0),(35010,2,16004,0),(35011,10,16004,0),(35012,2,16005,0),(35013,10,16005,0),(35014,2,16006,0),(35015,10,16006,0),(35016,2,16007,0),(35017,10,16007,0),(35018,2,16008,0),(35019,10,16008,0),(35020,2,16009,0),(35021,10,16009,0),(35022,2,16010,0),(35023,10,16010,0),(35024,2,16011,0),(35025,10,16011,0),(35026,2,16012,0),(35027,10,16012,0),(35028,2,16013,0),(35029,10,16013,0),(35030,2,16014,0),(35031,10,16014,0),(35032,2,16015,0),(35033,10,16015,0),(35034,2,16016,0),(35035,10,16016,0),(35036,2,16017,0),(35037,10,16017,0),(35038,2,16018,0),(35039,10,16018,0),(35040,2,16019,0),(35041,10,16019,0),(35042,2,16020,0),(35043,10,16020,0),(35044,2,16021,0),(35045,10,16021,0),(35046,2,16022,0),(35047,10,16022,0),(35048,2,16023,0),(35049,10,16023,0),(35050,2,16024,0),(35051,10,16024,0),(35052,2,16025,0),(35053,10,16025,0),(35054,2,16026,0),(35055,10,16026,0),(35056,2,16027,0),(35057,10,16027,0),(35058,2,16028,0),(35059,10,16028,0),(35060,2,16029,0),(35061,10,16029,0),(35062,2,16030,0),(35063,10,16030,0),(35064,2,16031,0),(35065,10,16031,0),(35066,2,16032,0),(35067,10,16032,0),(35068,2,16033,0),(35069,10,16033,0),(35070,2,16034,0),(35071,10,16034,0),(35072,2,16035,0),(35073,10,16035,0),(35074,2,16036,0),(35075,10,16036,0),(35076,2,16037,0),(35077,10,16037,0),(35078,2,16038,0),(35079,10,16038,0),(35080,2,16039,0),(35081,10,16039,0),(35082,2,16040,0),(35083,10,16040,0),(35084,2,16041,0),(35085,10,16041,0),(35086,2,16042,0),(35087,10,16042,0),(35088,2,16043,0),(35089,10,16043,0),(35090,2,16044,0),(35091,10,16044,0),(35092,2,16045,0),(35093,10,16045,0),(35094,2,16046,0),(35095,10,16046,0),(35096,2,16047,0),(35097,10,16047,0),(35098,2,16048,0),(35099,10,16048,0),(35100,2,16049,0),(35101,10,16049,0),(35102,2,16050,0),(35103,10,16050,0),(35104,2,16051,0),(35105,10,16051,0),(35106,2,16052,0),(35107,10,16052,0),(35108,2,16053,0),(35109,10,16053,0),(35110,2,16054,0),(35111,10,16054,0),(35112,2,16055,0),(35113,10,16055,0),(35114,2,16056,0),(35115,10,16056,0),(35116,2,16057,0),(35117,10,16057,0),(35118,2,16058,0),(35119,10,16058,0),(35120,2,16059,0),(35121,10,16059,0),(35122,2,16060,0),(35123,10,16060,0),(35124,2,16061,0),(35125,10,16061,0),(35126,2,16062,0),(35127,10,16062,0),(35128,2,16063,0),(35129,10,16063,0),(35130,2,16064,0),(35131,10,16064,0),(35132,2,16065,0),(35133,10,16065,0),(35134,2,16066,0),(35135,10,16066,0),(35136,2,16067,0),(35137,10,16067,0),(35138,2,16068,0),(35139,10,16068,0),(35140,2,16069,0),(35141,10,16069,0),(35142,2,16070,0),(35143,10,16070,0),(35144,2,16071,0),(35145,10,16071,0),(35146,2,16072,0),(35147,10,16072,0),(35148,2,16073,0),(35149,10,16073,0),(35150,2,16074,0),(35151,10,16074,0),(35152,2,16075,0),(35153,10,16075,0),(35154,2,16076,0),(35155,10,16076,0),(35156,2,16077,0),(35157,10,16077,0),(35158,2,16078,0),(35159,10,16078,0),(35160,2,16079,0),(35161,10,16079,0),(35162,2,16080,0),(35163,10,16080,0),(35164,2,16081,0),(35165,10,16081,0),(35166,2,16082,0),(35167,10,16082,0),(35168,2,16083,0),(35169,10,16083,0),(35170,2,16084,0),(35171,10,16084,0),(35172,2,16085,0),(35173,10,16085,0),(35174,2,16086,0),(35175,10,16086,0),(35176,2,16087,0),(35177,10,16087,0),(35178,2,16088,0),(35179,10,16088,0),(35180,2,16089,0),(35181,10,16089,0),(35182,2,16090,0),(35183,10,16090,0),(35184,2,16091,0),(35185,10,16091,0),(35186,2,16092,0),(35187,10,16092,0),(35188,2,16093,0),(35189,10,16093,0),(35190,2,16094,0),(35191,10,16094,0),(35192,2,16095,0),(35193,10,16095,0),(35194,2,16096,0),(35195,10,16096,0),(35196,2,16097,0),(35197,10,16097,0),(35198,2,16098,0),(35199,10,16098,0),(35200,2,16099,0),(35201,10,16099,0),(35202,2,16100,0),(35203,10,16100,0),(35204,2,16101,0),(35205,10,16101,0),(35206,2,16102,0),(35207,10,16102,0),(35208,2,16103,0),(35209,10,16103,0),(35210,2,16104,0),(35211,10,16104,0),(35212,2,16105,0),(35213,10,16105,0),(35214,2,16106,0),(35215,10,16106,0),(35216,2,16107,0),(35217,10,16107,0),(35218,2,16108,0),(35219,10,16108,0),(35220,2,16109,0),(35221,10,16109,0),(35222,2,16110,0),(35223,10,16110,0),(35224,2,16111,0),(35225,10,16111,0),(35226,2,16112,0),(35227,10,16112,0),(35228,2,16113,0),(35229,10,16113,0),(35230,2,16114,0),(35231,10,16114,0),(35232,2,16115,0),(35233,10,16115,0),(35234,2,16116,0),(35235,10,16116,0),(35236,2,16117,0),(35237,10,16117,0),(35238,2,16118,0),(35239,10,16118,0),(35240,2,16119,0),(35241,10,16119,0),(35242,2,16120,0),(35243,10,16120,0),(35244,2,16121,0),(35245,10,16121,0),(35246,2,16122,0),(35247,10,16122,0),(35248,2,16123,0),(35249,10,16123,0),(35250,2,16124,0),(35251,10,16124,0),(35252,2,16125,0),(35253,10,16125,0),(35254,2,16126,0),(35255,10,16126,0),(35256,2,16127,0),(35257,10,16127,0),(35258,2,16128,0),(35259,10,16128,0),(35260,2,16129,0),(35261,10,16129,0),(35262,2,16130,0),(35263,10,16130,0),(35264,2,16131,0),(35265,10,16131,0),(35266,2,16132,0),(35267,10,16132,0),(35268,2,16133,0),(35269,10,16133,0),(35270,2,16134,0),(35271,10,16134,0),(35272,2,16135,0),(35273,10,16135,0),(35274,2,16136,0),(35275,10,16136,0),(35276,2,16137,0),(35277,10,16137,0),(35278,2,16138,0),(35279,10,16138,0),(35280,2,16139,0),(35281,10,16139,0),(35282,2,16140,0),(35283,10,16140,0),(35284,2,16141,0),(35285,10,16141,0),(35286,2,16142,0),(35287,10,16142,0),(35288,2,16143,0),(35289,10,16143,0),(35290,2,16144,0),(35291,10,16144,0),(35292,2,16145,0),(35293,10,16145,0),(35294,2,16146,0),(35295,10,16146,0),(35296,2,16147,0),(35297,10,16147,0),(35298,2,16148,0),(35299,10,16148,0),(35300,2,16149,0),(35301,10,16149,0),(35302,2,16150,0),(35303,10,16150,0),(35304,2,16151,0),(35305,10,16151,0),(35306,2,16152,0),(35307,10,16152,0),(35308,2,16153,0),(35309,10,16153,0),(35310,2,16154,0),(35311,10,16154,0),(35312,2,16155,0),(35313,10,16155,0),(35314,2,16156,0),(35315,10,16156,0),(35316,2,16157,0),(35317,10,16157,0),(35318,2,16158,0),(35319,10,16158,0),(35320,2,16159,0),(35321,10,16159,0),(35322,2,16160,0),(35323,10,16160,0),(35324,2,16161,0),(35325,10,16161,0),(35326,2,16162,0),(35327,10,16162,0),(35328,2,16163,0),(35329,10,16163,0),(35330,2,16164,0),(35331,10,16164,0),(35332,2,16165,0),(35333,10,16165,0),(35334,2,16166,0),(35335,10,16166,0),(35336,2,16167,0),(35337,10,16167,0),(35338,2,16168,0),(35339,10,16168,0),(35340,2,16169,0),(35341,10,16169,0),(35342,2,16170,0),(35343,10,16170,0),(35344,2,16171,0),(35345,10,16171,0),(35346,2,16172,0),(35347,10,16172,0),(35348,2,16173,0),(35349,10,16173,0),(35350,2,16174,0),(35351,10,16174,0),(35352,2,16175,0),(35353,10,16175,0),(35354,2,16176,0),(35355,10,16176,0),(35356,2,16177,0),(35357,10,16177,0),(35358,2,16178,0),(35359,10,16178,0),(35360,2,16179,0),(35361,10,16179,0),(35362,2,16180,0),(35363,10,16180,0),(35364,2,16181,0),(35365,10,16181,0),(35366,2,16182,0),(35367,10,16182,0),(35368,2,16183,0),(35369,10,16183,0),(35370,2,16184,0),(35371,10,16184,0),(35372,2,16185,0),(35373,10,16185,0),(35374,2,16186,0),(35375,10,16186,0),(35376,2,16187,0),(35377,10,16187,0),(35378,2,16188,0),(35379,10,16188,0),(35380,2,16189,0),(35381,10,16189,0),(35382,2,16190,0),(35383,10,16190,0),(35384,2,16191,0),(35385,10,16191,0),(35386,2,16192,0),(35387,10,16192,0),(35388,2,16193,0),(35389,10,16193,0),(35390,2,16194,0),(35391,10,16194,0),(35392,2,16195,0),(35393,10,16195,0),(35394,2,16196,0),(35395,10,16196,0),(35396,2,16197,0),(35397,10,16197,0),(35398,2,16198,0),(35399,10,16198,0),(35400,2,16199,0),(35401,10,16199,0),(35402,2,16200,0),(35403,10,16200,0),(35404,2,16201,0),(35405,10,16201,0),(35406,2,16202,0),(35407,10,16202,0),(35408,2,16203,0),(35409,10,16203,0),(35410,2,16204,0),(35411,10,16204,0),(35412,2,16205,0),(35413,10,16205,0),(35414,2,16206,0),(35415,10,16206,0),(35416,2,16207,0),(35417,10,16207,0),(35418,2,16208,0),(35419,10,16208,0),(35420,2,16209,0),(35421,10,16209,0),(35422,2,16210,0),(35423,10,16210,0),(35424,2,16211,0),(35425,10,16211,0),(35426,2,16212,0),(35427,10,16212,0),(35428,2,16213,0),(35429,10,16213,0),(35430,2,16214,0),(35431,10,16214,0),(35432,2,16215,0),(35433,10,16215,0),(35434,2,16216,0),(35435,10,16216,0),(35436,2,16217,0),(35437,10,16217,0),(35438,2,16218,0),(35439,10,16218,0),(35440,2,16219,0),(35441,10,16219,0),(35442,2,16220,0),(35443,10,16220,0),(35444,2,16221,0),(35445,10,16221,0),(35446,2,16222,0),(35447,10,16222,0),(35448,2,16223,0),(35449,10,16223,0),(35450,2,16224,0),(35451,10,16224,0),(35452,2,16225,0),(35453,10,16225,0),(35454,2,16226,0),(35455,10,16226,0),(35456,2,16227,0),(35457,10,16227,0),(35458,2,16228,0),(35459,10,16228,0),(35460,2,16229,0),(35461,10,16229,0),(35462,2,16230,0),(35463,10,16230,0),(35464,2,16231,0),(35465,10,16231,0),(35466,2,16232,0),(35467,10,16232,0),(35468,2,16233,0),(35469,10,16233,0),(35470,2,16234,0),(35471,10,16234,0),(35472,2,16235,0),(35473,10,16235,0),(35474,2,16236,0),(35475,10,16236,0),(35476,2,16237,0),(35477,10,16237,0),(35478,2,16238,0),(35479,10,16238,0),(35480,2,16239,0),(35481,10,16239,0),(35482,2,16240,0),(35483,10,16240,0),(35484,2,16241,0),(35485,10,16241,0),(35486,2,16242,0),(35487,10,16242,0),(35488,2,16243,0),(35489,10,16243,0),(35490,2,16244,0),(35491,10,16244,0),(35492,2,16245,0),(35493,10,16245,0),(35494,2,16246,0),(35495,10,16246,0),(35496,2,16247,0),(35497,10,16247,0),(35498,2,16248,0),(35499,10,16248,0),(35500,2,16249,0),(35501,10,16249,0),(35502,2,16250,0),(35503,10,16250,0),(35504,2,16251,0),(35505,10,16251,0),(35506,2,16252,0),(35507,10,16252,0),(35508,2,16253,0),(35509,10,16253,0),(35510,2,16254,0),(35511,10,16254,0),(35512,2,16255,0),(35513,10,16255,0),(35514,2,16256,0),(35515,10,16256,0),(35516,2,16257,0),(35517,10,16257,0),(35518,2,16258,0),(35519,10,16258,0),(35520,2,16259,0),(35521,10,16259,0),(35522,2,16260,0),(35523,10,16260,0),(35524,2,16261,0),(35525,10,16261,0),(35526,2,16262,0),(35527,10,16262,0),(35528,2,16263,0),(35529,10,16263,0),(35530,2,16264,0),(35531,10,16264,0),(35532,2,16265,0),(35533,10,16265,0),(35534,2,16266,0),(35535,10,16266,0),(35536,2,16267,0),(35537,10,16267,0),(35538,2,16268,0),(35539,10,16268,0),(35540,2,16269,0),(35541,10,16269,0),(35542,2,16270,0),(35543,10,16270,0),(35544,2,16271,0),(35545,10,16271,0),(35546,2,16272,0),(35547,10,16272,0),(35548,2,16273,0),(35549,10,16273,0),(35550,2,16274,0),(35551,10,16274,0),(35552,2,16275,0),(35553,10,16275,0),(35554,2,16276,0),(35555,10,16276,0),(35556,2,16277,0),(35557,10,16277,0),(35558,2,16278,0),(35559,10,16278,0),(35560,2,16279,0),(35561,10,16279,0),(35562,2,16280,0),(35563,10,16280,0),(35564,2,16281,0),(35565,10,16281,0),(35566,2,16282,0),(35567,10,16282,0),(35568,2,16283,0),(35569,10,16283,0),(35570,2,16284,0),(35571,10,16284,0),(35572,2,16285,0),(35573,10,16285,0),(35574,2,16286,0),(35575,10,16286,0),(35576,2,16287,0),(35577,10,16287,0),(35578,2,16288,0),(35579,10,16288,0),(35580,2,16289,0),(35581,10,16289,0),(35582,2,16290,0),(35583,10,16290,0),(35584,2,16291,0),(35585,10,16291,0),(35586,2,16292,0),(35587,10,16292,0),(35588,2,16293,0),(35589,10,16293,0),(35590,2,16294,0),(35591,10,16294,0),(35592,2,16295,0),(35593,10,16295,0),(35594,2,16296,0),(35595,10,16296,0),(35596,2,16297,0),(35597,10,16297,0),(35598,2,16298,0),(35599,10,16298,0),(35600,2,16299,0),(35601,10,16299,0),(35602,2,16300,0),(35603,10,16300,0),(35604,2,16301,0),(35605,10,16301,0),(35606,2,16302,0),(35607,10,16302,0),(35608,2,16303,0),(35609,10,16303,0),(35610,2,16304,0),(35611,10,16304,0),(35612,2,16305,0),(35613,10,16305,0),(35614,2,16306,0),(35615,10,16306,0),(35616,2,16307,0),(35617,10,16307,0),(35618,2,16308,0),(35619,10,16308,0),(35620,2,16309,0),(35621,10,16309,0),(35622,2,16310,0),(35623,10,16310,0),(35624,2,16311,0),(35625,10,16311,0),(35626,2,16312,0),(35627,10,16312,0),(35628,2,16313,0),(35629,10,16313,0),(35630,2,16314,0),(35631,10,16314,0),(35632,2,16315,0),(35633,10,16315,0),(35634,2,16316,0),(35635,10,16316,0),(35636,2,16317,0),(35637,10,16317,0),(35638,2,16318,0),(35639,10,16318,0),(35640,2,16319,0),(35641,10,16319,0),(35642,2,16320,0),(35643,10,16320,0),(35644,2,16321,0),(35645,10,16321,0),(35646,2,16322,0),(35647,10,16322,0),(35648,2,16323,0),(35649,10,16323,0),(35650,2,16324,0),(35651,10,16324,0),(35652,2,16325,0),(35653,10,16325,0),(35654,2,16326,0),(35655,10,16326,0),(35656,2,16327,0),(35657,10,16327,0),(35658,2,16328,0),(35659,10,16328,0),(35660,2,16329,0),(35661,10,16329,0),(35662,2,16330,0),(35663,10,16330,0),(35664,2,16331,0),(35665,10,16331,0),(35666,2,16332,0),(35667,10,16332,0),(35668,2,16333,0),(35669,10,16333,0),(35670,2,16334,0),(35671,10,16334,0),(35672,2,16335,0),(35673,10,16335,0),(35674,2,16336,0),(35675,10,16336,0),(35676,2,16337,0),(35677,10,16337,0),(35678,2,16338,0),(35679,10,16338,0),(35680,2,16339,0),(35681,10,16339,0),(35682,2,16340,0),(35683,10,16340,0),(35684,2,16341,0),(35685,10,16341,0),(35686,2,16342,0),(35687,10,16342,0),(35688,2,16343,0),(35689,10,16343,0),(35690,2,16344,0),(35691,10,16344,0),(35692,2,16345,0),(35693,10,16345,0),(35694,2,16346,0),(35695,10,16346,0),(35696,2,16347,0),(35697,10,16347,0),(35698,2,16348,0),(35699,10,16348,0),(35700,2,16349,0),(35701,10,16349,0),(35702,2,16350,0),(35703,10,16350,0),(35704,2,16351,0),(35705,10,16351,0),(35706,2,16352,0),(35707,10,16352,0),(35708,2,16353,0),(35709,10,16353,0),(35710,2,16354,0),(35711,10,16354,0),(35712,2,16355,0),(35713,10,16355,0),(35714,2,16356,0),(35715,10,16356,0),(35716,2,16357,0),(35717,10,16357,0),(35718,2,16358,0),(35719,10,16358,0),(35720,2,16359,0),(35721,10,16359,0),(35722,2,16360,0),(35723,10,16360,0),(35724,2,16361,0),(35725,10,16361,0),(35726,2,16362,0),(35727,10,16362,0),(35728,2,16363,0),(35729,10,16363,0),(35730,2,16364,0),(35731,10,16364,0),(35732,2,16365,0),(35733,10,16365,0),(35734,2,16366,0),(35735,10,16366,0),(35736,2,16367,0),(35737,10,16367,0),(35738,2,16368,0),(35739,10,16368,0),(35740,2,16369,0),(35741,10,16369,0),(35742,2,16370,0),(35743,10,16370,0),(35744,2,16371,0),(35745,10,16371,0),(35746,2,16372,0),(35747,10,16372,0),(35748,2,16373,0),(35749,10,16373,0),(35750,2,16374,0),(35751,10,16374,0),(35752,2,16375,0),(35753,10,16375,0),(35754,2,16376,0),(35755,10,16376,0),(35756,2,16377,0),(35757,10,16377,0),(35758,2,16378,0),(35759,10,16378,0),(35760,2,16379,0),(35761,10,16379,0),(35762,2,16380,0),(35763,10,16380,0),(35764,2,16381,0),(35765,10,16381,0),(35766,2,16382,0),(35767,10,16382,0),(35768,2,16383,0),(35769,10,16383,0),(35770,2,16384,0),(35771,10,16384,0),(35772,2,16385,0),(35773,10,16385,0),(35774,2,16386,0),(35775,10,16386,0),(35776,2,16387,0),(35777,10,16387,0),(35778,2,16388,0),(35779,10,16388,0),(35780,2,16389,0),(35781,10,16389,0),(35782,2,16390,0),(35783,10,16390,0),(35784,2,16391,0),(35785,10,16391,0),(35786,2,16392,0),(35787,10,16392,0),(35788,2,16393,0),(35789,10,16393,0),(35790,2,16394,0),(35791,10,16394,0),(35792,2,16395,0),(35793,10,16395,0),(35794,2,16396,0),(35795,10,16396,0),(35796,2,16397,0),(35797,10,16397,0),(35798,2,16398,0),(35799,10,16398,0),(35800,2,16399,0),(35801,10,16399,0),(35802,2,16400,0),(35803,10,16400,0),(35804,2,16401,0),(35805,10,16401,0),(35806,2,16402,0),(35807,10,16402,0),(35808,2,16403,0),(35809,10,16403,0),(35810,2,16404,0),(35811,10,16404,0),(35812,2,16405,0),(35813,10,16405,0),(35814,2,16406,0),(35815,10,16406,0),(35816,2,16407,0),(35817,10,16407,0),(35818,2,16408,0),(35819,10,16408,0),(35820,2,16409,0),(35821,10,16409,0),(35822,2,16410,0),(35823,10,16410,0),(35824,2,16411,0),(35825,10,16411,0),(35826,2,16412,0),(35827,10,16412,0),(35828,2,16413,0),(35829,10,16413,0),(35830,2,16414,0),(35831,10,16414,0),(35832,2,16415,0),(35833,10,16415,0),(35834,2,16416,0),(35835,10,16416,0),(35836,2,16417,0),(35837,10,16417,0),(35838,2,16418,0),(35839,10,16418,0),(35840,2,16419,0),(35841,10,16419,0),(35842,2,16420,0),(35843,10,16420,0),(35844,2,16421,0),(35845,10,16421,0),(35846,2,16422,0),(35847,10,16422,0),(35848,2,16423,0),(35849,10,16423,0),(35850,2,16424,0),(35851,10,16424,0),(35852,2,16425,0),(35853,10,16425,0),(35854,2,16426,0),(35855,10,16426,0),(35856,2,16427,0),(35857,10,16427,0),(35858,2,16428,0),(35859,10,16428,0),(35860,2,16429,0),(35861,10,16429,0),(35862,2,16430,0),(35863,10,16430,0),(35864,2,16431,0),(35865,10,16431,0),(35866,2,16432,0),(35867,10,16432,0),(35868,2,16433,0),(35869,10,16433,0),(35870,2,16434,0),(35871,10,16434,0),(35872,2,16435,0),(35873,10,16435,0),(35874,2,16436,0),(35875,10,16436,0),(35876,2,16437,0),(35877,10,16437,0),(35878,2,16438,0),(35879,10,16438,0),(35880,2,16439,0),(35881,10,16439,0),(35882,2,16440,0),(35883,10,16440,0),(35884,2,16441,0),(35885,10,16441,0),(35886,2,16442,0),(35887,10,16442,0),(35888,2,16443,0),(35889,10,16443,0),(35890,2,16444,0),(35891,10,16444,0),(35892,2,16445,0),(35893,10,16445,0),(35894,2,16446,0),(35895,10,16446,0),(35896,2,16447,0),(35897,10,16447,0),(35898,2,16448,0),(35899,10,16448,0),(35900,2,16449,0),(35901,10,16449,0),(35902,2,16450,0),(35903,10,16450,0),(35904,2,16451,0),(35905,10,16451,0),(35906,2,16452,0),(35907,10,16452,0),(35908,2,16453,0),(35909,10,16453,0),(35910,2,16454,0),(35911,10,16454,0),(35912,2,16455,0),(35913,10,16455,0),(35914,2,16456,0),(35915,10,16456,0),(35916,2,16457,0),(35917,10,16457,0),(35918,2,16458,0),(35919,10,16458,0),(35920,2,16459,0),(35921,10,16459,0),(35922,2,16460,0),(35923,10,16460,0),(35924,2,16461,0),(35925,10,16461,0),(35926,2,16462,0),(35927,10,16462,0),(35928,2,16463,0),(35929,10,16463,0),(35930,2,16464,0),(35931,10,16464,0),(35932,2,16465,0),(35933,10,16465,0),(35934,2,16466,0),(35935,10,16466,0),(35936,2,16467,0),(35937,10,16467,0),(35938,2,16468,0),(35939,10,16468,0),(35940,2,16469,0),(35941,10,16469,0),(35942,2,16470,0),(35943,10,16470,0),(35944,2,16471,0),(35945,10,16471,0),(35946,2,16472,0),(35947,10,16472,0),(35948,2,16473,0),(35949,10,16473,0),(35950,2,16474,0),(35951,10,16474,0),(35952,2,16475,0),(35953,10,16475,0),(35954,2,16476,0),(35955,10,16476,0),(35956,2,16477,0),(35957,10,16477,0),(35958,2,16478,0),(35959,10,16478,0),(35960,2,16479,0),(35961,10,16479,0),(35962,2,16480,0),(35963,10,16480,0),(35964,2,16481,0),(35965,10,16481,0),(35966,2,16482,0),(35967,10,16482,0),(35968,2,16483,0),(35969,10,16483,0),(35970,2,16484,0),(35971,10,16484,0),(35972,2,16485,0),(35973,10,16485,0),(35974,2,16486,0),(35975,10,16486,0),(35976,2,16487,0),(35977,10,16487,0),(35978,2,16488,0),(35979,10,16488,0),(35980,2,16489,0),(35981,10,16489,0),(35982,2,16490,0),(35983,10,16490,0),(35984,2,16491,0),(35985,10,16491,0),(35986,2,16492,0),(35987,10,16492,0),(35988,2,16493,0),(35989,10,16493,0),(35990,2,16494,0),(35991,10,16494,0),(35992,2,16495,0),(35993,10,16495,0),(35994,2,16496,0),(35995,10,16496,0),(35996,2,16497,0),(35997,10,16497,0),(35998,2,16498,0),(35999,10,16498,0),(36000,2,16499,0),(36001,10,16499,0),(36002,2,16500,0),(36003,10,16500,0),(36004,2,16501,0),(36005,10,16501,0),(36006,2,16502,0),(36007,10,16502,0),(36008,2,16503,0),(36009,10,16503,0),(36010,2,16504,0),(36011,10,16504,0),(36012,2,16505,0),(36013,10,16505,0),(36014,2,16506,0),(36015,10,16506,0),(36016,2,16507,0),(36017,10,16507,0),(36018,2,16508,0),(36019,10,16508,0),(36020,2,16509,0),(36021,10,16509,0),(36022,2,16510,0),(36023,10,16510,0),(36024,2,16511,0),(36025,10,16511,0),(36026,2,16512,0),(36027,10,16512,0),(36028,2,16513,0),(36029,10,16513,0),(36030,2,16514,0),(36031,10,16514,0),(36032,2,16515,0),(36033,10,16515,0),(36034,2,16516,0),(36035,10,16516,0),(36036,2,16517,0),(36037,10,16517,0),(36038,2,16518,0),(36039,10,16518,0),(36040,2,16519,0),(36041,10,16519,0),(36042,2,16520,0),(36043,10,16520,0),(36044,2,16521,0),(36045,10,16521,0),(36046,2,16522,0),(36047,10,16522,0),(36048,2,16523,0),(36049,10,16523,0),(36050,2,16524,0),(36051,10,16524,0),(36052,2,16525,0),(36053,10,16525,0),(36054,2,16526,0),(36055,10,16526,0),(36056,2,16527,0),(36057,10,16527,0),(36058,2,16528,0),(36059,10,16528,0),(36060,2,16529,0),(36061,10,16529,0),(36062,2,16530,0),(36063,10,16530,0),(36064,2,16531,0),(36065,10,16531,0),(36066,2,16532,0),(36067,10,16532,0),(36068,2,16533,0),(36069,10,16533,0),(36070,2,16534,0),(36071,10,16534,0),(36072,2,16535,0),(36073,10,16535,0),(36074,2,16536,0),(36075,10,16536,0),(36076,2,16537,0),(36077,10,16537,0),(36078,2,16538,0),(36079,10,16538,0),(36080,2,16539,0),(36081,10,16539,0),(36082,2,16540,0),(36083,10,16540,0),(36084,2,16541,0),(36085,10,16541,0),(36086,2,16542,0),(36087,10,16542,0),(36088,2,16543,0),(36089,10,16543,0),(36090,2,16544,0),(36091,10,16544,0),(36092,2,16545,0),(36093,10,16545,0),(36094,2,16546,0),(36095,10,16546,0),(36096,2,16547,0),(36097,10,16547,0),(36098,2,16548,0),(36099,10,16548,0),(36100,2,16549,0),(36101,10,16549,0),(36102,2,16550,0),(36103,10,16550,0),(36104,2,16551,0),(36105,10,16551,0),(36106,2,16552,0),(36107,10,16552,0),(36108,2,16553,0),(36109,10,16553,0),(36110,2,16554,0),(36111,10,16554,0),(36112,2,16555,0),(36113,10,16555,0),(36114,2,16556,0),(36115,10,16556,0),(36116,2,16557,0),(36117,10,16557,0),(36118,2,16558,0),(36119,10,16558,0),(36120,2,16559,0),(36121,10,16559,0),(36122,2,16560,0),(36123,10,16560,0),(36124,2,16561,0),(36125,10,16561,0),(36126,2,16562,0),(36127,10,16562,0),(36128,2,16563,0),(36129,10,16563,0),(36130,2,16564,0),(36131,10,16564,0),(36132,2,16565,0),(36133,10,16565,0),(36134,2,16566,0),(36135,10,16566,0),(36136,2,16567,0),(36137,10,16567,0),(36138,2,16568,0),(36139,10,16568,0),(36140,2,16569,0),(36141,10,16569,0),(36142,2,16570,0),(36143,10,16570,0),(36144,2,16571,0),(36145,10,16571,0),(36146,2,16572,0),(36147,10,16572,0),(36148,2,16573,0),(36149,10,16573,0),(36150,2,16574,0),(36151,10,16574,0),(36152,2,16575,0),(36153,10,16575,0),(36154,2,16576,0),(36155,10,16576,0),(36156,2,16577,0),(36157,10,16577,0),(36158,2,16578,0),(36159,10,16578,0),(36160,2,16579,0),(36161,10,16579,0),(36162,2,16580,0),(36163,10,16580,0),(36164,2,16581,0),(36165,10,16581,0),(36166,2,16582,0),(36167,10,16582,0),(36168,2,16583,0),(36169,10,16583,0),(36170,2,16584,0),(36171,10,16584,0),(36172,2,16585,0),(36173,10,16585,0),(36174,2,16586,0),(36175,10,16586,0),(36176,2,16587,0),(36177,10,16587,0),(36178,2,16588,0),(36179,10,16588,0),(36180,2,16589,0),(36181,10,16589,0),(36182,2,16590,0),(36183,10,16590,0),(36184,2,16591,0),(36185,10,16591,0),(36186,2,16592,0),(36187,10,16592,0),(36188,2,16593,0),(36189,10,16593,0),(36190,2,16594,0),(36191,10,16594,0),(36192,2,16595,0),(36193,10,16595,0),(36194,2,16596,0),(36195,10,16596,0),(36196,2,16597,0),(36197,10,16597,0),(36198,2,16598,0),(36199,10,16598,0),(36200,2,16599,0),(36201,10,16599,0),(36202,2,16600,0),(36203,10,16600,0),(36204,2,16601,0),(36205,10,16601,0),(36206,2,16602,0),(36207,10,16602,0),(36208,2,16603,0),(36209,10,16603,0),(36210,2,16604,0),(36211,10,16604,0),(36212,2,16605,0),(36213,10,16605,0),(36214,2,16606,0),(36215,10,16606,0),(36216,2,16607,0),(36217,10,16607,0),(36218,2,16608,0),(36219,10,16608,0),(36220,2,16609,0),(36221,10,16609,0),(36222,2,16610,0),(36223,10,16610,0),(36224,2,16611,0),(36225,10,16611,0),(36226,2,16612,0),(36227,10,16612,0),(36228,2,16613,0),(36229,10,16613,0),(36230,2,16614,0),(36231,10,16614,0),(36232,2,16615,0),(36233,10,16615,0),(36234,2,16616,0),(36235,10,16616,0),(36236,2,16617,0),(36237,10,16617,0),(36238,2,16618,0),(36239,10,16618,0),(36240,2,16619,0),(36241,10,16619,0),(36242,2,16620,0),(36243,10,16620,0),(36244,2,16621,0),(36245,10,16621,0),(36246,2,16622,0),(36247,10,16622,0),(36248,2,16623,0),(36249,10,16623,0),(36250,2,16624,0),(36251,10,16624,0),(36252,2,16625,0),(36253,10,16625,0),(36254,2,16626,0),(36255,10,16626,0),(36256,2,16627,0),(36257,10,16627,0),(36258,2,16628,0),(36259,10,16628,0),(36260,2,16629,0),(36261,10,16629,0),(36262,2,16630,0),(36263,10,16630,0),(36264,2,16631,0),(36265,10,16631,0),(36266,2,16632,0),(36267,10,16632,0),(36268,2,16633,0),(36269,10,16633,0),(36270,2,16634,0),(36271,10,16634,0),(36272,2,16635,0),(36273,10,16635,0),(36274,2,16636,0),(36275,10,16636,0),(36276,2,16637,0),(36277,10,16637,0),(36278,2,16638,0),(36279,10,16638,0),(36280,2,16639,0),(36281,10,16639,0),(36282,2,16640,0),(36283,10,16640,0),(36284,2,16641,0),(36285,10,16641,0),(36286,2,16642,0),(36287,10,16642,0),(36288,2,16643,0),(36289,10,16643,0),(36290,2,16644,0),(36291,10,16644,0),(36292,2,16645,0),(36293,10,16645,0),(36294,2,16646,0),(36295,10,16646,0),(36296,2,16647,0),(36297,10,16647,0),(36298,2,16648,0),(36299,10,16648,0),(36300,2,16649,0),(36301,10,16649,0),(36302,2,16650,0),(36303,10,16650,0),(36304,2,16651,0),(36305,10,16651,0),(36306,2,16652,0),(36307,10,16652,0),(36308,2,16653,0),(36309,10,16653,0),(36310,2,16654,0),(36311,10,16654,0),(36312,2,16655,0),(36313,10,16655,0),(36314,2,16656,0),(36315,10,16656,0),(36316,2,16657,0),(36317,10,16657,0),(36318,2,16658,0),(36319,10,16658,0),(36320,2,16659,0),(36321,10,16659,0),(36322,2,16660,0),(36323,10,16660,0),(36324,2,16661,0),(36325,10,16661,0),(36326,2,16662,0),(36327,10,16662,0),(36328,2,16663,0),(36329,10,16663,0),(36330,2,16664,0),(36331,10,16664,0),(36332,2,16665,0),(36333,10,16665,0),(36334,2,16666,0),(36335,10,16666,0),(36336,2,16667,0),(36337,10,16667,0),(36338,2,16668,0),(36339,10,16668,0),(36340,2,16669,0),(36341,10,16669,0),(36342,2,16670,0),(36343,10,16670,0),(36344,2,16671,0),(36345,10,16671,0),(36346,2,16672,0),(36347,10,16672,0),(36348,2,16673,0),(36349,10,16673,0),(36350,2,16674,0),(36351,10,16674,0),(36352,2,16675,0),(36353,10,16675,0),(36354,2,16676,0),(36355,10,16676,0),(36356,2,16677,0),(36357,10,16677,0),(36358,2,16678,0),(36359,10,16678,0),(36360,2,16679,0),(36361,10,16679,0),(36362,2,16680,0),(36363,10,16680,0),(36364,2,16681,0),(36365,10,16681,0),(36366,2,16682,0),(36367,10,16682,0),(36368,2,16683,0),(36369,10,16683,0),(36370,2,16684,0),(36371,10,16684,0),(36372,2,16685,0),(36373,10,16685,0),(36374,2,16686,0),(36375,10,16686,0),(36376,2,16687,0),(36377,10,16687,0),(36378,2,16688,0),(36379,10,16688,0),(36380,2,16689,0),(36381,10,16689,0),(36382,2,16690,0),(36383,10,16690,0),(36384,2,16691,0),(36385,10,16691,0),(36386,2,16692,0),(36387,10,16692,0),(36388,2,16693,0),(36389,10,16693,0),(36390,2,16694,0),(36391,10,16694,0),(36392,2,16695,0),(36393,10,16695,0),(36394,2,16696,0),(36395,10,16696,0),(36396,2,16697,0),(36397,10,16697,0),(36398,2,16698,0),(36399,10,16698,0),(36400,2,16699,0),(36401,10,16699,0),(36402,2,16700,0),(36403,10,16700,0),(36404,2,16701,0),(36405,10,16701,0),(36406,2,16702,0),(36407,10,16702,0),(36408,2,16703,0),(36409,10,16703,0),(36410,2,16704,0),(36411,10,16704,0),(36412,2,16705,0),(36413,10,16705,0),(36414,2,16706,0),(36415,10,16706,0),(36416,2,16707,0),(36417,10,16707,0),(36418,2,16708,0),(36419,10,16708,0),(36420,2,16709,0),(36421,10,16709,0),(36422,2,16710,0),(36423,10,16710,0),(36424,2,16711,0),(36425,10,16711,0),(36426,2,16712,0),(36427,10,16712,0),(36428,2,16713,0),(36429,10,16713,0),(36430,2,16714,0),(36431,10,16714,0),(36432,2,16715,0),(36433,10,16715,0),(36434,2,16716,0),(36435,10,16716,0),(36436,2,16717,0),(36437,10,16717,0),(36438,2,16718,0),(36439,10,16718,0),(36440,2,16719,0),(36441,10,16719,0),(36442,2,16720,0),(36443,10,16720,0),(36444,2,16721,0),(36445,10,16721,0),(36446,2,16722,0),(36447,10,16722,0),(36448,2,16723,0),(36449,10,16723,0),(36450,2,16724,0),(36451,10,16724,0),(36452,2,16725,0),(36453,10,16725,0),(36454,2,16726,0),(36455,10,16726,0),(36456,2,16727,0),(36457,10,16727,0),(36458,2,16728,0),(36459,10,16728,0),(36460,2,16729,0),(36461,10,16729,0),(36462,2,16730,0),(36463,10,16730,0),(36464,2,16731,0),(36465,10,16731,0),(36466,2,16732,0),(36467,10,16732,0),(36468,2,16733,0),(36469,10,16733,0),(36470,2,16734,0),(36471,10,16734,0),(36472,2,16735,0),(36473,10,16735,0),(36474,2,16736,0),(36475,10,16736,0),(36476,2,16737,0),(36477,10,16737,0),(36478,2,16738,0),(36479,10,16738,0),(36480,2,16739,0),(36481,10,16739,0),(36482,2,16740,0),(36483,10,16740,0),(36484,2,16741,0),(36485,10,16741,0),(36486,2,16742,0),(36487,10,16742,0),(36488,2,16743,0),(36489,10,16743,0),(36490,2,16744,0),(36491,10,16744,0),(36492,2,16745,0),(36493,10,16745,0),(36494,2,16746,0),(36495,10,16746,0),(36496,2,16747,0),(36497,10,16747,0),(36498,2,16748,0),(36499,10,16748,0),(36500,2,16749,0),(36501,10,16749,0),(36502,2,16750,0),(36503,10,16750,0),(36504,2,16751,0),(36505,10,16751,0),(36506,2,16752,0),(36507,10,16752,0),(36508,2,16753,0),(36509,10,16753,0),(36510,2,16754,0),(36511,10,16754,0),(36512,2,16755,0),(36513,10,16755,0),(36514,2,16756,0),(36515,10,16756,0),(36516,2,16757,0),(36517,10,16757,0),(36518,2,16758,0),(36519,10,16758,0),(36520,2,16759,0),(36521,10,16759,0),(36522,2,16760,0),(36523,10,16760,0),(36524,2,16761,0),(36525,10,16761,0),(36526,2,16762,0),(36527,10,16762,0),(36528,2,16763,0),(36529,10,16763,0),(36530,2,16764,0),(36531,10,16764,0),(36532,2,16765,0),(36533,10,16765,0),(36534,2,16766,0),(36535,10,16766,0),(36536,2,16767,0),(36537,10,16767,0),(36538,2,16768,0),(36539,10,16768,0),(36540,2,16769,0),(36541,10,16769,0),(36542,2,16770,0),(36543,10,16770,0),(36544,2,16771,0),(36545,10,16771,0),(36546,2,16772,0),(36547,10,16772,0),(36548,2,16773,0),(36549,10,16773,0),(36550,2,16774,0),(36551,10,16774,0),(36552,2,16775,0),(36553,10,16775,0),(36554,2,16776,0),(36555,10,16776,0),(36556,2,16777,0),(36557,10,16777,0),(36558,2,16778,0),(36559,10,16778,0),(36560,2,16779,0),(36561,10,16779,0),(36562,2,16780,0),(36563,10,16780,0),(36564,2,16781,0),(36565,10,16781,0),(36566,2,16782,0),(36567,10,16782,0),(36568,2,16783,0),(36569,10,16783,0),(36570,2,16784,0),(36571,10,16784,0),(36572,2,16785,0),(36573,10,16785,0),(36574,2,16786,0),(36575,10,16786,0),(36576,2,16787,0),(36577,10,16787,0),(36578,2,16788,0),(36579,10,16788,0),(36580,2,16789,0),(36581,10,16789,0),(36582,2,16790,0),(36583,10,16790,0),(36584,2,16791,0),(36585,10,16791,0),(36586,2,16792,0),(36587,10,16792,0),(36588,2,16793,0),(36589,10,16793,0),(36590,2,16794,0),(36591,10,16794,0),(36592,2,16795,0),(36593,10,16795,0),(36594,2,16796,0),(36595,10,16796,0),(36596,2,16797,0),(36597,10,16797,0),(36598,2,16798,0),(36599,10,16798,0),(36600,2,16799,0),(36601,10,16799,0),(36602,2,16800,0),(36603,10,16800,0),(36604,2,16801,0),(36605,10,16801,0),(36606,2,16802,0),(36607,10,16802,0),(36608,2,16803,0),(36609,10,16803,0),(36610,2,16804,0),(36611,10,16804,0),(36612,2,16805,0),(36613,10,16805,0),(36614,2,16806,0),(36615,10,16806,0),(36616,2,16807,0),(36617,10,16807,0),(36618,2,16808,0),(36619,10,16808,0),(36620,2,16809,0),(36621,10,16809,0),(36622,2,16810,0),(36623,10,16810,0),(36624,2,16811,0),(36625,10,16811,0),(36626,2,16812,0),(36627,10,16812,0),(36628,2,16813,0),(36629,10,16813,0),(36630,2,16814,0),(36631,10,16814,0),(36632,2,16815,0),(36633,10,16815,0),(36634,2,16816,0),(36635,10,16816,0),(36636,2,16817,0),(36637,10,16817,0),(36638,2,16818,0),(36639,10,16818,0),(36640,2,16819,0),(36641,10,16819,0),(36642,2,16820,0),(36643,10,16820,0),(36644,2,16821,0),(36645,10,16821,0),(36646,2,16822,0),(36647,10,16822,0),(36648,2,16823,0),(36649,10,16823,0),(36650,2,16824,0),(36651,10,16824,0),(36652,2,16825,0),(36653,10,16825,0),(36654,2,16826,0),(36655,10,16826,0),(36656,2,16827,0),(36657,10,16827,0),(36658,2,16828,0),(36659,10,16828,0),(36660,2,16829,0),(36661,10,16829,0),(36662,2,16830,0),(36663,10,16830,0),(36664,2,16831,0),(36665,10,16831,0),(36666,2,16832,0),(36667,10,16832,0),(36668,2,16833,0),(36669,10,16833,0),(36670,2,16834,0),(36671,10,16834,0),(36672,2,16835,0),(36673,10,16835,0),(36674,2,16836,0),(36675,10,16836,0),(36676,2,16837,0),(36677,10,16837,0),(36678,2,16838,0),(36679,10,16838,0),(36680,2,16839,0),(36681,10,16839,0),(36682,2,16840,0),(36683,10,16840,0),(36684,2,16841,0),(36685,10,16841,0),(36686,2,16842,0),(36687,10,16842,0),(36688,2,16843,0),(36689,10,16843,0),(36690,2,16844,0),(36691,10,16844,0),(36692,2,16845,0),(36693,10,16845,0),(36694,2,16846,0),(36695,10,16846,0),(36696,2,16847,0),(36697,10,16847,0),(36698,2,16848,0),(36699,10,16848,0),(36700,2,16849,0),(36701,10,16849,0),(36702,2,16850,0),(36703,10,16850,0),(36704,2,16851,0),(36705,10,16851,0),(36706,2,16852,0),(36707,10,16852,0),(36708,2,16853,0),(36709,10,16853,0),(36710,2,16854,0),(36711,10,16854,0),(36712,2,16855,0),(36713,10,16855,0),(36714,2,16856,0),(36715,10,16856,0),(36716,2,16857,0),(36717,10,16857,0),(36718,2,16858,0),(36719,10,16858,0),(36720,2,16859,0),(36721,10,16859,0),(36722,2,16860,0),(36723,10,16860,0),(36724,2,16861,0),(36725,10,16861,0),(36726,2,16862,0),(36727,10,16862,0),(36728,2,16863,0),(36729,10,16863,0),(36730,2,16864,0),(36731,10,16864,0),(36732,2,16865,0),(36733,10,16865,0),(36734,2,16866,0),(36735,10,16866,0),(36736,2,16867,0),(36737,10,16867,0),(36738,2,16868,0),(36739,10,16868,0),(36740,2,16869,0),(36741,10,16869,0),(36742,2,16870,0),(36743,10,16870,0),(36744,2,16871,0),(36745,10,16871,0),(36746,2,16872,0),(36747,10,16872,0),(36748,2,16873,0),(36749,10,16873,0),(36750,2,16874,0),(36751,10,16874,0),(36752,2,16875,0),(36753,10,16875,0),(36754,2,16876,0),(36755,10,16876,0),(36756,2,16877,0),(36757,10,16877,0),(36758,2,16878,0),(36759,10,16878,0),(36760,2,16879,0),(36761,10,16879,0),(36762,2,16880,0),(36763,10,16880,0),(36764,2,16881,0),(36765,10,16881,0),(36766,2,16882,0),(36767,10,16882,0),(36768,2,16883,0),(36769,10,16883,0),(36770,2,16884,0),(36771,10,16884,0),(36772,2,16885,0),(36773,10,16885,0),(36774,2,16886,0),(36775,10,16886,0),(36776,2,16887,0),(36777,10,16887,0),(36778,2,16888,0),(36779,10,16888,0),(36780,2,16889,0),(36781,10,16889,0),(36782,2,16890,0),(36783,10,16890,0),(36784,2,16891,0),(36785,10,16891,0),(36786,2,16892,0),(36787,10,16892,0),(36788,2,16893,0),(36789,10,16893,0),(36790,2,16894,0),(36791,10,16894,0),(36792,2,16895,0),(36793,10,16895,0),(36794,2,16896,0),(36795,10,16896,0),(36796,2,16897,0),(36797,10,16897,0),(36798,2,16898,0),(36799,10,16898,0),(36800,2,16899,0),(36801,10,16899,0),(36802,2,16900,0),(36803,10,16900,0),(36804,2,16901,0),(36805,10,16901,0),(36806,2,16902,0),(36807,10,16902,0),(36808,2,16903,0),(36809,10,16903,0),(36810,2,16904,0),(36811,10,16904,0),(36812,2,16905,0),(36813,10,16905,0),(36814,2,16906,0),(36815,10,16906,0),(36816,2,16907,0),(36817,10,16907,0),(36818,2,16908,0),(36819,10,16908,0),(36820,2,16909,0),(36821,10,16909,0),(36822,2,16910,0),(36823,10,16910,0),(36824,2,16911,0),(36825,10,16911,0),(36826,2,16912,0),(36827,10,16912,0),(36828,2,16913,0),(36829,10,16913,0),(36830,2,16914,0),(36831,10,16914,0),(36832,2,16915,0),(36833,10,16915,0),(36834,2,16916,0),(36835,10,16916,0),(36836,2,16917,0),(36837,10,16917,0),(36838,2,16918,0),(36839,10,16918,0),(36840,2,16919,0),(36841,10,16919,0),(36842,2,16920,0),(36843,10,16920,0),(36844,2,16921,0),(36845,10,16921,0),(36846,2,16922,0),(36847,10,16922,0),(36848,2,16923,0),(36849,10,16923,0),(36850,2,16924,0),(36851,10,16924,0),(36852,2,16925,0),(36853,10,16925,0),(36854,2,16926,0),(36855,10,16926,0),(36856,2,16927,0),(36857,10,16927,0),(36858,2,16928,0),(36859,10,16928,0),(36860,2,16929,0),(36861,10,16929,0),(36862,2,16930,0),(36863,10,16930,0),(36864,2,16931,0),(36865,10,16931,0),(36866,2,16932,0),(36867,10,16932,0),(36868,2,16933,0),(36869,10,16933,0),(36870,2,16934,0),(36871,10,16934,0),(36872,2,16935,0),(36873,10,16935,0),(36874,2,16936,0),(36875,10,16936,0),(36876,2,16937,0),(36877,10,16937,0),(36878,2,16938,0),(36879,10,16938,0),(36880,2,16939,0),(36881,10,16939,0),(36882,2,16940,0),(36883,10,16940,0),(36884,2,16941,0),(36885,10,16941,0),(36886,2,16942,0),(36887,10,16942,0),(36888,2,16943,0),(36889,10,16943,0),(36890,2,16944,0),(36891,10,16944,0),(36892,2,16945,0),(36893,10,16945,0),(36894,2,16946,0),(36895,10,16946,0),(36896,2,16947,0),(36897,10,16947,0),(36898,2,16948,0),(36899,10,16948,0),(36900,2,16949,0),(36901,10,16949,0),(36902,2,16950,0),(36903,10,16950,0),(36904,2,16951,0),(36905,10,16951,0),(36906,2,16952,0),(36907,10,16952,0),(36908,2,16953,0),(36909,10,16953,0),(36910,2,16954,0),(36911,10,16954,0),(36912,2,16955,0),(36913,10,16955,0),(36914,2,16956,0),(36915,10,16956,0),(36916,2,16957,0),(36917,10,16957,0),(36918,2,16958,0),(36919,10,16958,0),(36920,2,16959,0),(36921,10,16959,0),(36922,2,16960,0),(36923,10,16960,0),(36924,2,16961,0),(36925,10,16961,0),(36926,2,16962,0),(36927,10,16962,0),(36928,2,16963,0),(36929,10,16963,0),(36930,2,16964,0),(36931,10,16964,0),(36932,2,16965,0),(36933,10,16965,0),(36934,2,16966,0),(36935,10,16966,0),(36936,2,16967,0),(36937,10,16967,0),(36938,2,16968,0),(36939,10,16968,0),(36940,2,16969,0),(36941,10,16969,0),(36942,2,16970,0),(36943,10,16970,0),(36944,2,16971,0),(36945,10,16971,0),(36946,2,16972,0),(36947,10,16972,0),(36948,2,16973,0),(36949,10,16973,0),(36950,2,16974,0),(36951,10,16974,0),(36952,2,16975,0),(36953,10,16975,0),(36954,2,16976,0),(36955,10,16976,0),(36956,2,16977,0),(36957,10,16977,0),(36958,2,16978,0),(36959,10,16978,0),(36960,2,16979,0),(36961,10,16979,0),(36962,2,16980,0),(36963,10,16980,0),(36964,2,16981,0),(36965,10,16981,0),(36966,2,16982,0),(36967,10,16982,0),(36968,2,16983,0),(36969,10,16983,0),(36970,2,16984,0),(36971,10,16984,0),(36972,2,16985,0),(36973,10,16985,0),(36974,2,16986,0),(36975,10,16986,0),(36976,2,16987,0),(36977,10,16987,0),(36978,2,16988,0),(36979,10,16988,0),(36980,2,16989,0),(36981,10,16989,0),(36982,2,16990,0),(36983,10,16990,0),(36984,2,16991,0),(36985,10,16991,0),(36986,2,16992,0),(36987,10,16992,0),(36988,2,16993,0),(36989,10,16993,0),(36990,2,16994,0),(36991,10,16994,0),(36992,2,16995,0),(36993,10,16995,0),(36994,2,16996,0),(36995,10,16996,0),(36996,2,16997,0),(36997,10,16997,0),(36998,2,16998,0),(36999,10,16998,0),(37000,2,16999,0),(37001,10,16999,0),(37002,2,17000,0),(37003,10,17000,0),(37004,2,17001,0),(37005,10,17001,0),(37006,2,17002,0),(37007,10,17002,0),(37008,2,17003,0),(37009,10,17003,0),(37010,2,17004,0),(37011,10,17004,0),(37012,2,17005,0),(37013,10,17005,0),(37014,2,17006,0),(37015,10,17006,0),(37016,2,17007,0),(37017,10,17007,0),(37018,2,17008,0),(37019,10,17008,0),(37020,2,17009,0),(37021,10,17009,0),(37022,2,17010,0),(37023,10,17010,0),(37024,2,17011,0),(37025,10,17011,0),(37026,2,17012,0),(37027,10,17012,0),(37028,2,17013,0),(37029,10,17013,0),(37030,2,17014,0),(37031,10,17014,0),(37032,2,17015,0),(37033,10,17015,0),(37034,2,17016,0),(37035,10,17016,0),(37036,2,17017,0),(37037,10,17017,0),(37038,2,17018,0),(37039,10,17018,0),(37040,2,17019,0),(37041,10,17019,0),(37042,2,17020,0),(37043,10,17020,0),(37044,2,17021,0),(37045,10,17021,0),(37046,2,17022,0),(37047,10,17022,0),(37048,2,17023,0),(37049,10,17023,0),(37050,2,17024,0),(37051,10,17024,0),(37052,2,17025,0),(37053,10,17025,0),(37054,2,17026,0),(37055,10,17026,0),(37056,2,17027,0),(37057,10,17027,0),(37058,2,17028,0),(37059,10,17028,0),(37060,2,17029,0),(37061,10,17029,0),(37062,2,17030,0),(37063,10,17030,0),(37064,2,17031,0),(37065,10,17031,0),(37066,2,17032,0),(37067,10,17032,0),(37068,2,17033,0),(37069,10,17033,0),(37070,2,17034,0),(37071,10,17034,0),(37072,2,17035,0),(37073,10,17035,0),(37074,2,17036,0),(37075,10,17036,0),(37076,2,17037,0),(37077,10,17037,0),(37078,2,17038,0),(37079,10,17038,0),(37080,2,17039,0),(37081,10,17039,0),(37082,2,17040,0),(37083,10,17040,0),(37084,2,17041,0),(37085,10,17041,0),(37086,2,17042,0),(37087,10,17042,0),(37088,2,17043,0),(37089,10,17043,0),(37090,2,17044,0),(37091,10,17044,0),(37092,2,17045,0),(37093,10,17045,0),(37094,2,17046,0),(37095,10,17046,0),(37096,2,17047,0),(37097,10,17047,0),(37098,2,17048,0),(37099,10,17048,0),(37100,2,17049,0),(37101,10,17049,0),(37102,2,17050,0),(37103,10,17050,0),(37104,2,17051,0),(37105,10,17051,0),(37106,2,17052,0),(37107,10,17052,0),(37108,2,17053,0),(37109,10,17053,0),(37110,2,17054,0),(37111,10,17054,0),(37112,2,17055,0),(37113,10,17055,0),(37114,2,17056,0),(37115,10,17056,0),(37116,2,17057,0),(37117,10,17057,0),(37118,2,17058,0),(37119,10,17058,0),(37120,2,17059,0),(37121,10,17059,0),(37122,2,17060,0),(37123,10,17060,0),(37124,2,17061,0),(37125,10,17061,0),(37126,2,17062,0),(37127,10,17062,0),(37128,2,17063,0),(37129,10,17063,0),(37130,2,17064,0),(37131,10,17064,0),(37132,2,17065,0),(37133,10,17065,0),(37134,2,17066,0),(37135,10,17066,0),(37136,2,17067,0),(37137,10,17067,0),(37138,2,17068,0),(37139,10,17068,0),(37140,2,17069,0),(37141,10,17069,0),(37142,2,17070,0),(37143,10,17070,0),(37144,2,17071,0),(37145,10,17071,0),(37146,2,17072,0),(37147,10,17072,0),(37148,2,17073,0),(37149,10,17073,0),(37150,2,17074,0),(37151,10,17074,0),(37152,2,17075,0),(37153,10,17075,0),(37154,2,17076,0),(37155,10,17076,0),(37156,2,17077,0),(37157,10,17077,0),(37158,2,17078,0),(37159,10,17078,0),(37160,2,17079,0),(37161,10,17079,0),(37162,2,17080,0),(37163,10,17080,0),(37164,2,17081,0),(37165,10,17081,0),(37166,2,17082,0),(37167,10,17082,0),(37168,2,17083,0),(37169,10,17083,0),(37170,2,17084,0),(37171,10,17084,0),(37172,2,17085,0),(37173,10,17085,0),(37174,2,17086,0),(37175,10,17086,0),(37176,2,17087,0),(37177,10,17087,0),(37178,2,17088,0),(37179,10,17088,0),(37180,2,17089,0),(37181,10,17089,0),(37182,2,17090,0),(37183,10,17090,0),(37184,2,17091,0),(37185,10,17091,0),(37186,2,17092,0),(37187,10,17092,0),(37188,2,17093,0),(37189,10,17093,0),(37190,2,17094,0),(37191,10,17094,0),(37192,2,17095,0),(37193,10,17095,0),(37194,2,17096,0),(37195,10,17096,0),(37196,2,17097,0),(37197,10,17097,0),(37198,2,17098,0),(37199,10,17098,0),(37200,2,17099,0),(37201,10,17099,0),(37202,2,17100,0),(37203,10,17100,0),(37204,2,17101,0),(37205,10,17101,0),(37206,2,17102,0),(37207,10,17102,0),(37208,2,17103,0),(37209,10,17103,0),(37210,2,17104,0),(37211,10,17104,0),(37212,2,17105,0),(37213,10,17105,0),(37214,2,17106,0),(37215,10,17106,0),(37216,2,17107,0),(37217,10,17107,0),(37218,2,17108,0),(37219,10,17108,0),(37220,2,17109,0),(37221,10,17109,0),(37222,2,17110,0),(37223,10,17110,0),(37224,2,17111,0),(37225,10,17111,0),(37226,2,17112,0),(37227,10,17112,0),(37228,2,17113,0),(37229,10,17113,0),(37230,2,17114,0),(37231,10,17114,0),(37232,2,17115,0),(37233,10,17115,0),(37234,2,17116,0),(37235,10,17116,0),(37236,2,17117,0),(37237,10,17117,0),(37238,2,17118,0),(37239,10,17118,0),(37240,2,17119,0),(37241,10,17119,0),(37242,2,17120,0),(37243,10,17120,0),(37244,2,17121,0),(37245,10,17121,0),(37246,2,17122,0),(37247,10,17122,0),(37248,2,17123,0),(37249,10,17123,0),(37250,2,17124,0),(37251,10,17124,0),(37252,2,17125,0),(37253,10,17125,0),(37254,2,17126,0),(37255,10,17126,0),(37256,2,17127,0),(37257,10,17127,0),(37258,2,17128,0),(37259,10,17128,0),(37260,2,17129,0),(37261,10,17129,0),(37262,2,17130,0),(37263,10,17130,0),(37264,2,17131,0),(37265,10,17131,0),(37266,2,17132,0),(37267,10,17132,0),(37268,2,17133,0),(37269,10,17133,0),(37270,2,17134,0),(37271,10,17134,0),(37272,2,17135,0),(37273,10,17135,0),(37274,2,17136,0),(37275,10,17136,0),(37276,2,17137,0),(37277,10,17137,0),(37278,2,17138,0),(37279,10,17138,0),(37280,2,17139,0),(37281,10,17139,0),(37282,2,17140,0),(37283,10,17140,0),(37284,2,17141,0),(37285,10,17141,0),(37286,2,17142,0),(37287,10,17142,0),(37288,2,17143,0),(37289,10,17143,0),(37290,2,17144,0),(37291,10,17144,0),(37292,2,17145,0),(37293,10,17145,0),(37294,2,17146,0),(37295,10,17146,0),(37296,2,17147,0),(37297,10,17147,0),(37298,2,17148,0),(37299,10,17148,0),(37300,2,17149,0),(37301,10,17149,0),(37302,2,17150,0),(37303,10,17150,0),(37304,2,17151,0),(37305,10,17151,0),(37306,2,17152,0),(37307,10,17152,0),(37308,2,17153,0),(37309,10,17153,0),(37310,2,17154,0),(37311,10,17154,0),(37312,2,17155,0),(37313,10,17155,0),(37314,2,17156,0),(37315,10,17156,0),(37316,2,17157,0),(37317,10,17157,0),(37318,2,17158,0),(37319,10,17158,0),(37320,2,17159,0),(37321,10,17159,0),(37322,2,17160,0),(37323,10,17160,0),(37324,2,17161,0),(37325,10,17161,0),(37326,2,17162,0),(37327,10,17162,0),(37328,2,17163,0),(37329,10,17163,0),(37330,2,17164,0),(37331,10,17164,0),(37332,2,17165,0),(37333,10,17165,0),(37334,2,17166,0),(37335,10,17166,0),(37336,2,17167,0),(37337,10,17167,0),(37338,2,17168,0),(37339,10,17168,0),(37340,2,17169,0),(37341,10,17169,0),(37342,2,17170,0),(37343,10,17170,0),(37344,2,17171,0),(37345,10,17171,0),(37346,2,17172,0),(37347,10,17172,0),(37348,2,17173,0),(37349,10,17173,0),(37350,2,17174,0),(37351,10,17174,0),(37352,2,17175,0),(37353,10,17175,0),(37354,2,17176,0),(37355,10,17176,0),(37356,2,17177,0),(37357,10,17177,0),(37358,2,17178,0),(37359,10,17178,0),(37360,2,17179,0),(37361,10,17179,0),(37362,2,17180,0),(37363,10,17180,0),(37364,2,17181,0),(37365,10,17181,0),(37366,2,17182,0),(37367,10,17182,0),(37368,2,17183,0),(37369,10,17183,0),(37370,2,17184,0),(37371,10,17184,0),(37372,2,17185,0),(37373,10,17185,0),(37374,2,17186,0),(37375,10,17186,0),(37376,2,17187,0),(37377,10,17187,0),(37378,2,17188,0),(37379,10,17188,0),(37380,2,17189,0),(37381,10,17189,0),(37382,2,17190,0),(37383,10,17190,0),(37384,2,17191,0),(37385,10,17191,0),(37386,2,17192,0),(37387,10,17192,0),(37388,2,17193,0),(37389,10,17193,0),(37390,2,17194,0),(37391,10,17194,0),(37392,2,17195,0),(37393,10,17195,0),(37394,2,17196,0),(37395,10,17196,0),(37396,2,17197,0),(37397,10,17197,0),(37398,2,17198,0),(37399,10,17198,0),(37400,2,17199,0),(37401,10,17199,0),(37402,2,17200,0),(37403,10,17200,0),(37404,2,17201,0),(37405,10,17201,0),(37406,2,17202,0),(37407,10,17202,0),(37408,2,17203,0),(37409,10,17203,0),(37410,2,17204,0),(37411,10,17204,0),(37412,2,17205,0),(37413,10,17205,0),(37414,2,17206,0),(37415,10,17206,0),(37416,2,17207,0),(37417,10,17207,0),(37418,2,17208,0),(37419,10,17208,0),(37420,2,17209,0),(37421,10,17209,0),(37422,2,17210,0),(37423,10,17210,0),(37424,2,17211,0),(37425,10,17211,0),(37426,2,17212,0),(37427,10,17212,0),(37428,2,17213,0),(37429,10,17213,0),(37430,2,17214,0),(37431,10,17214,0),(37432,2,17215,0),(37433,10,17215,0),(37434,2,17216,0),(37435,10,17216,0),(37436,2,17217,0),(37437,10,17217,0),(37438,2,17218,0),(37439,10,17218,0),(37440,2,17219,0),(37441,10,17219,0),(37442,2,17220,0),(37443,10,17220,0),(37444,2,17221,0),(37445,10,17221,0),(37446,2,17222,0),(37447,10,17222,0),(37448,2,17223,0),(37449,10,17223,0),(37450,2,17224,0),(37451,10,17224,0),(37452,2,17225,0),(37453,10,17225,0),(37454,2,17226,0),(37455,10,17226,0),(37456,2,17227,0),(37457,10,17227,0),(37458,2,17228,0),(37459,10,17228,0),(37460,2,17229,0),(37461,10,17229,0),(37462,2,17230,0),(37463,10,17230,0),(37464,2,17231,0),(37465,10,17231,0),(37466,2,17232,0),(37467,10,17232,0),(37468,2,17233,0),(37469,10,17233,0),(37470,2,17234,0),(37471,10,17234,0),(37472,2,17235,0),(37473,10,17235,0),(37474,2,17236,0),(37475,10,17236,0),(37476,2,17237,0),(37477,10,17237,0),(37478,2,17238,0),(37479,10,17238,0),(37480,2,17239,0),(37481,10,17239,0),(37482,2,17240,0),(37483,10,17240,0),(37484,2,17241,0),(37485,10,17241,0),(37486,2,17242,0),(37487,10,17242,0),(37488,2,17243,0),(37489,10,17243,0),(37490,2,17244,0),(37491,10,17244,0),(37492,2,17245,0),(37493,10,17245,0),(37494,2,17246,0),(37495,10,17246,0),(37496,2,17247,0),(37497,10,17247,0),(37498,2,17248,0),(37499,10,17248,0),(37500,2,17249,0),(37501,10,17249,0),(37502,2,17250,0),(37503,10,17250,0),(37504,2,17251,0),(37505,10,17251,0),(37506,2,17252,0),(37507,10,17252,0),(37508,2,17253,0),(37509,10,17253,0),(37510,2,17254,0),(37511,10,17254,0),(37512,2,17255,0),(37513,10,17255,0),(37514,2,17256,0),(37515,10,17256,0),(37516,2,17257,0),(37517,10,17257,0),(37518,2,17258,0),(37519,10,17258,0),(37520,2,17259,0),(37521,10,17259,0),(37522,2,17260,0),(37523,10,17260,0),(37524,2,17261,0),(37525,10,17261,0),(37526,2,17262,0),(37527,10,17262,0),(37528,2,17263,0),(37529,10,17263,0),(37530,2,17264,0),(37531,10,17264,0),(37532,2,17265,0),(37533,10,17265,0),(37534,2,17266,0),(37535,10,17266,0),(37536,2,17267,0),(37537,10,17267,0),(37538,2,17268,0),(37539,10,17268,0),(37540,2,17269,0),(37541,10,17269,0),(37542,2,17270,0),(37543,10,17270,0),(37544,2,17271,0),(37545,10,17271,0),(37546,2,17272,0),(37547,10,17272,0),(37548,2,17273,0),(37549,10,17273,0),(37550,2,17274,0),(37551,10,17274,0),(37552,2,17275,0),(37553,10,17275,0),(37554,2,17276,0),(37555,10,17276,0),(37556,2,17277,0),(37557,10,17277,0),(37558,2,17278,0),(37559,10,17278,0),(37560,2,17279,0),(37561,10,17279,0),(37562,2,17280,0),(37563,10,17280,0),(37564,2,17281,0),(37565,10,17281,0),(37566,2,17282,0),(37567,10,17282,0),(37568,2,17283,0),(37569,10,17283,0),(37570,2,17284,0),(37571,10,17284,0),(37572,2,17285,0),(37573,10,17285,0),(37574,2,17286,0),(37575,10,17286,0),(37576,2,17287,0),(37577,10,17287,0),(37578,2,17288,0),(37579,10,17288,0),(37580,2,17289,0),(37581,10,17289,0),(37582,2,17290,0),(37583,10,17290,0),(37584,2,17291,0),(37585,10,17291,0),(37586,2,17292,0),(37587,10,17292,0),(37588,2,17293,0),(37589,10,17293,0),(37590,2,17294,0),(37591,10,17294,0),(37592,2,17295,0),(37593,10,17295,0),(37594,2,17296,0),(37595,10,17296,0),(37596,2,17297,0),(37597,10,17297,0),(37598,2,17298,0),(37599,10,17298,0),(37600,2,17299,0),(37601,10,17299,0),(37602,2,17300,0),(37603,10,17300,0),(37604,2,17301,0),(37605,10,17301,0),(37606,2,17302,0),(37607,10,17302,0),(37608,2,17303,0),(37609,10,17303,0),(37610,2,17304,0),(37611,10,17304,0),(37612,2,17305,0),(37613,10,17305,0),(37614,2,17306,0),(37615,10,17306,0),(37616,2,17307,0),(37617,10,17307,0),(37618,2,17308,0),(37619,10,17308,0),(37620,2,17309,0),(37621,10,17309,0),(37622,2,17310,0),(37623,10,17310,0),(37624,2,17311,0),(37625,10,17311,0),(37626,2,17312,0),(37627,10,17312,0),(37628,2,17313,0),(37629,10,17313,0),(37630,2,17314,0),(37631,10,17314,0),(37632,2,17315,0),(37633,10,17315,0),(37634,2,17316,0),(37635,10,17316,0),(37636,2,17317,0),(37637,10,17317,0),(37638,2,17318,0),(37639,10,17318,0),(37640,2,17319,0),(37641,10,17319,0),(37642,2,17320,0),(37643,10,17320,0),(37644,2,17321,0),(37645,10,17321,0),(37646,2,17322,0),(37647,10,17322,0),(37648,2,17323,0),(37649,10,17323,0),(37650,2,17324,0),(37651,10,17324,0),(37652,2,17325,0),(37653,10,17325,0),(37654,2,17326,0),(37655,10,17326,0),(37656,2,17327,0),(37657,10,17327,0),(37658,2,17328,0),(37659,10,17328,0),(37660,2,17329,0),(37661,10,17329,0),(37662,2,17330,0),(37663,10,17330,0),(37664,2,17331,0),(37665,10,17331,0),(37666,2,17332,0),(37667,10,17332,0),(37668,2,17333,0),(37669,10,17333,0),(37670,2,17334,0),(37671,10,17334,0),(37672,2,17335,0),(37673,10,17335,0),(37674,2,17336,0),(37675,10,17336,0),(37676,2,17337,0),(37677,10,17337,0),(37678,2,17338,0),(37679,10,17338,0),(37680,2,17339,0),(37681,10,17339,0),(37682,2,17340,0),(37683,10,17340,0),(37684,2,17341,0),(37685,10,17341,0),(37686,2,17342,0),(37687,10,17342,0),(37688,2,17343,0),(37689,10,17343,0),(37690,2,17344,0),(37691,10,17344,0),(37692,2,17345,0),(37693,10,17345,0),(37694,2,17346,0),(37695,10,17346,0),(37696,2,17347,0),(37697,10,17347,0),(37698,2,17348,0),(37699,10,17348,0),(37700,2,17349,0),(37701,10,17349,0),(37702,2,17350,0),(37703,10,17350,0),(37704,2,17351,0),(37705,10,17351,0),(37706,2,17352,0),(37707,10,17352,0),(37708,2,17353,0),(37709,10,17353,0),(37710,2,17354,0),(37711,10,17354,0),(37712,2,17355,0),(37713,10,17355,0),(37714,2,17356,0),(37715,10,17356,0),(37716,2,17357,0),(37717,10,17357,0),(37718,2,17358,0),(37719,10,17358,0),(37720,2,17359,0),(37721,10,17359,0),(37722,2,17360,0),(37723,10,17360,0),(37724,2,17361,0),(37725,10,17361,0),(37726,2,17362,0),(37727,10,17362,0),(37728,2,17363,0),(37729,10,17363,0),(37730,2,17364,0),(37731,10,17364,0),(37732,2,17365,0),(37733,10,17365,0),(37734,2,17366,0),(37735,10,17366,0),(37736,2,17367,0),(37737,10,17367,0),(37738,2,17368,0),(37739,10,17368,0),(37740,2,17369,0),(37741,10,17369,0),(37742,2,17370,0),(37743,10,17370,0),(37744,2,17371,0),(37745,10,17371,0),(37746,2,17372,0),(37747,10,17372,0),(37748,2,17373,0),(37749,10,17373,0),(37750,2,17374,0),(37751,10,17374,0),(37752,2,17375,0),(37753,10,17375,0),(37754,2,17376,0),(37755,10,17376,0),(37756,2,17377,0),(37757,10,17377,0),(37758,2,17378,0),(37759,10,17378,0),(37760,2,17379,0),(37761,10,17379,0),(37762,2,17380,0),(37763,10,17380,0),(37764,2,17381,0),(37765,10,17381,0),(37766,2,17382,0),(37767,10,17382,0),(37768,2,17383,0),(37769,10,17383,0),(37770,2,17384,0),(37771,10,17384,0),(37772,2,17385,0),(37773,10,17385,0),(37774,2,17386,0),(37775,10,17386,0),(37776,2,17387,0),(37777,10,17387,0),(37778,2,17388,0),(37779,10,17388,0),(37780,2,17389,0),(37781,10,17389,0),(37782,2,17390,0),(37783,10,17390,0),(37784,2,17391,0),(37785,10,17391,0),(37786,2,17392,0),(37787,10,17392,0),(37788,2,17393,0),(37789,10,17393,0),(37790,2,17394,0),(37791,10,17394,0),(37792,2,17395,0),(37793,10,17395,0),(37794,2,17396,0),(37795,10,17396,0),(37796,2,17397,0),(37797,10,17397,0),(37798,2,17398,0),(37799,10,17398,0),(37800,2,17399,0),(37801,10,17399,0),(37802,2,17400,0),(37803,10,17400,0),(37804,2,17401,0),(37805,10,17401,0),(37806,2,17402,0),(37807,10,17402,0),(37808,2,17403,0),(37809,10,17403,0),(37810,2,17404,0),(37811,10,17404,0),(37812,2,17405,0),(37813,10,17405,0),(37814,2,17406,0),(37815,10,17406,0),(37816,2,17407,0),(37817,10,17407,0),(37818,2,17408,0),(37819,10,17408,0),(37820,2,17409,0),(37821,10,17409,0),(37822,2,17410,0),(37823,10,17410,0),(37824,2,17411,0),(37825,10,17411,0),(37826,2,17412,0),(37827,10,17412,0),(37828,2,17413,0),(37829,10,17413,0),(37830,2,17414,0),(37831,10,17414,0),(37832,2,17415,0),(37833,10,17415,0),(37834,2,17416,0),(37835,10,17416,0),(37836,2,17417,0),(37837,10,17417,0),(37838,2,17418,0),(37839,10,17418,0),(37840,2,17419,0),(37841,10,17419,0),(37842,2,17420,0),(37843,10,17420,0),(37844,2,17421,0),(37845,10,17421,0),(37846,2,17422,0),(37847,10,17422,0),(37848,2,17423,0),(37849,10,17423,0),(37850,2,17424,0),(37851,10,17424,0),(37852,2,17425,0),(37853,10,17425,0),(37854,2,17426,0),(37855,10,17426,0),(37856,2,17427,0),(37857,10,17427,0),(37858,2,17428,0),(37859,10,17428,0),(37860,2,17429,0),(37861,10,17429,0),(37862,2,17430,0),(37863,10,17430,0),(37864,2,17431,0),(37865,10,17431,0),(37866,2,17432,0),(37867,10,17432,0),(37868,2,17433,0),(37869,10,17433,0),(37870,2,17434,0),(37871,10,17434,0),(37872,2,17435,0),(37873,10,17435,0),(37874,2,17436,0),(37875,10,17436,0),(37876,2,17437,0),(37877,10,17437,0),(37878,2,17438,0),(37879,10,17438,0),(37880,2,17439,0),(37881,10,17439,0),(37882,2,17440,0),(37883,10,17440,0),(37884,2,17441,0),(37885,10,17441,0),(37886,2,17442,0),(37887,10,17442,0),(37888,2,17443,0),(37889,10,17443,0),(37890,2,17444,0),(37891,10,17444,0),(37892,2,17445,0),(37893,10,17445,0),(37894,2,17446,0),(37895,10,17446,0),(37896,2,17447,0),(37897,10,17447,0),(37898,2,17448,0),(37899,10,17448,0),(37900,2,17449,0),(37901,10,17449,0),(37902,2,17450,0),(37903,10,17450,0),(37904,2,17451,0),(37905,10,17451,0),(37906,2,17452,0),(37907,10,17452,0),(37908,2,17453,0),(37909,10,17453,0),(37910,2,17454,0),(37911,10,17454,0),(37912,2,17455,0),(37913,10,17455,0),(37914,2,17456,0),(37915,10,17456,0),(37916,2,17457,0),(37917,10,17457,0),(37918,2,17458,0),(37919,10,17458,0),(37920,2,17459,0),(37921,10,17459,0),(37922,2,17460,0),(37923,10,17460,0),(37924,2,17461,0),(37925,10,17461,0),(37926,2,17462,0),(37927,10,17462,0),(37928,2,17463,0),(37929,10,17463,0),(37930,2,17464,0),(37931,10,17464,0),(37932,2,17465,0),(37933,10,17465,0),(37934,2,17466,0),(37935,10,17466,0),(37936,2,17467,0),(37937,10,17467,0),(37938,2,17468,0),(37939,10,17468,0),(37940,2,17469,0),(37941,10,17469,0),(37942,2,17470,0),(37943,10,17470,0),(37944,2,17471,0),(37945,10,17471,0),(37946,2,17472,0),(37947,10,17472,0),(37948,2,17473,0),(37949,10,17473,0),(37950,2,17474,0),(37951,10,17474,0),(37952,2,17475,0),(37953,10,17475,0),(37954,2,17476,0),(37955,10,17476,0),(37956,2,17477,0),(37957,10,17477,0),(37958,2,17478,0),(37959,10,17478,0),(37960,2,17479,0),(37961,10,17479,0),(37962,2,17480,0),(37963,10,17480,0),(37964,2,17481,0),(37965,10,17481,0),(37966,2,17482,0),(37967,10,17482,0),(37968,2,17483,0),(37969,10,17483,0),(37970,2,17484,0),(37971,10,17484,0),(37972,2,17485,0),(37973,10,17485,0),(37974,2,17486,0),(37975,10,17486,0),(37976,2,17487,0),(37977,10,17487,0),(37978,2,17488,0),(37979,10,17488,0),(37980,2,17489,0),(37981,10,17489,0),(37982,2,17490,0),(37983,10,17490,0),(37984,2,17491,0),(37985,10,17491,0),(37986,2,17492,0),(37987,10,17492,0),(37988,2,17493,0),(37989,10,17493,0),(37990,2,17494,0),(37991,10,17494,0),(37992,2,17495,0),(37993,10,17495,0),(37994,2,17496,0),(37995,10,17496,0),(37996,2,17497,0),(37997,10,17497,0),(37998,2,17498,0),(37999,10,17498,0),(38000,2,17499,0),(38001,10,17499,0),(38002,2,17500,0),(38003,10,17500,0),(38004,2,17501,0),(38005,10,17501,0),(38006,2,17502,0),(38007,10,17502,0),(38008,2,17503,0),(38009,10,17503,0),(38010,2,17504,0),(38011,10,17504,0),(38012,2,17505,0),(38013,10,17505,0),(38014,2,17506,0),(38015,10,17506,0),(38016,2,17507,0),(38017,10,17507,0),(38018,2,17508,0),(38019,10,17508,0),(38020,2,17509,0),(38021,10,17509,0),(38022,2,17510,0),(38023,10,17510,0),(38024,2,17511,0),(38025,10,17511,0),(38026,2,17512,0),(38027,10,17512,0),(38028,2,17513,0),(38029,10,17513,0),(38030,2,17514,0),(38031,10,17514,0),(38032,2,17515,0),(38033,10,17515,0),(38034,2,17516,0),(38035,10,17516,0),(38036,2,17517,0),(38037,10,17517,0),(38038,2,17518,0),(38039,10,17518,0),(38040,2,17519,0),(38041,10,17519,0),(38042,2,17520,0),(38043,10,17520,0),(38044,2,17521,0),(38045,10,17521,0),(38046,2,17522,0),(38047,10,17522,0),(38048,2,17523,0),(38049,10,17523,0),(38050,2,17524,0),(38051,10,17524,0),(38052,2,17525,0),(38053,10,17525,0),(38054,2,17526,0),(38055,10,17526,0),(38056,2,17527,0),(38057,10,17527,0),(38058,2,17528,0),(38059,10,17528,0),(38060,2,17529,0),(38061,10,17529,0),(38062,2,17530,0),(38063,10,17530,0),(38064,2,17531,0),(38065,10,17531,0),(38066,2,17532,0),(38067,10,17532,0),(38068,2,17533,0),(38069,10,17533,0),(38070,2,17534,0),(38071,10,17534,0),(38072,2,17535,0),(38073,10,17535,0),(38074,2,17536,0),(38075,10,17536,0),(38076,2,17537,0),(38077,10,17537,0),(38078,2,17538,0),(38079,10,17538,0),(38080,2,17539,0),(38081,10,17539,0),(38082,2,17540,0),(38083,10,17540,0),(38084,2,17541,0),(38085,10,17541,0),(38086,2,17542,0),(38087,10,17542,0),(38088,2,17543,0),(38089,10,17543,0),(38090,2,17544,0),(38091,10,17544,0),(38092,2,17545,0),(38093,10,17545,0),(38094,2,17546,0),(38095,10,17546,0),(38096,2,17547,0),(38097,10,17547,0),(38098,2,17548,0),(38099,10,17548,0),(38100,2,17549,0),(38101,10,17549,0),(38102,2,17550,0),(38103,10,17550,0),(38104,2,17551,0),(38105,10,17551,0),(38106,2,17552,0),(38107,10,17552,0),(38108,2,17553,0),(38109,10,17553,0),(38110,2,17554,0),(38111,10,17554,0),(38112,2,17555,0),(38113,10,17555,0),(38114,2,17556,0),(38115,10,17556,0),(38116,2,17557,0),(38117,10,17557,0),(38118,2,17558,0),(38119,10,17558,0),(38120,2,17559,0),(38121,10,17559,0),(38122,2,17560,0),(38123,10,17560,0),(38124,2,17561,0),(38125,10,17561,0),(38126,2,17562,0),(38127,10,17562,0),(38128,2,17563,0),(38129,10,17563,0),(38130,2,17564,0),(38131,10,17564,0),(38132,2,17565,0),(38133,10,17565,0),(38134,2,17566,0),(38135,10,17566,0),(38136,2,17567,0),(38137,10,17567,0),(38138,2,17568,0),(38139,10,17568,0),(38140,2,17569,0),(38141,10,17569,0),(38142,2,17570,0),(38143,10,17570,0),(38144,2,17571,0),(38145,10,17571,0),(38146,2,17572,0),(38147,10,17572,0),(38148,2,17573,0),(38149,10,17573,0),(38150,2,17574,0),(38151,10,17574,0),(38152,2,17575,0),(38153,10,17575,0),(38154,2,17576,0),(38155,10,17576,0),(38156,2,17577,0),(38157,10,17577,0),(38158,2,17578,0),(38159,10,17578,0),(38160,2,17579,0),(38161,10,17579,0),(38162,2,17580,0),(38163,10,17580,0),(38164,2,17581,0),(38165,10,17581,0),(38166,2,17582,0),(38167,10,17582,0),(38168,2,17583,0),(38169,10,17583,0),(38170,2,17584,0),(38171,10,17584,0),(38172,2,17585,0),(38173,10,17585,0),(38174,2,17586,0),(38175,10,17586,0),(38176,2,17587,0),(38177,10,17587,0),(38178,2,17588,0),(38179,10,17588,0),(38180,2,17589,0),(38181,10,17589,0),(38182,2,17590,0),(38183,10,17590,0),(38184,2,17591,0),(38185,10,17591,0),(38186,2,17592,0),(38187,10,17592,0),(38188,2,17593,0),(38189,10,17593,0),(38190,2,17594,0),(38191,10,17594,0),(38192,2,17595,0),(38193,10,17595,0),(38194,2,17596,0),(38195,10,17596,0),(38196,2,17597,0),(38197,10,17597,0),(38198,2,17598,0),(38199,10,17598,0),(38200,2,17599,0),(38201,10,17599,0),(38202,2,17600,0),(38203,10,17600,0),(38204,2,17601,0),(38205,10,17601,0),(38206,2,17602,0),(38207,10,17602,0),(38208,2,17603,0),(38209,10,17603,0),(38210,2,17604,0),(38211,10,17604,0),(38212,2,17605,0),(38213,10,17605,0),(38214,2,17606,0),(38215,10,17606,0),(38216,2,17607,0),(38217,10,17607,0),(38218,2,17608,0),(38219,10,17608,0),(38220,2,17609,0),(38221,10,17609,0),(38222,2,17610,0),(38223,10,17610,0),(38224,2,17611,0),(38225,10,17611,0),(38226,2,17612,0),(38227,10,17612,0),(38228,2,17613,0),(38229,10,17613,0),(38230,2,17614,0),(38231,10,17614,0),(38232,2,17615,0),(38233,10,17615,0),(38234,2,17616,0),(38235,10,17616,0),(38236,2,17617,0),(38237,10,17617,0),(38238,2,17618,0),(38239,10,17618,0),(38240,2,17619,0),(38241,10,17619,0),(38242,2,17620,0),(38243,10,17620,0),(38244,2,17621,0),(38245,10,17621,0),(38246,2,17622,0),(38247,10,17622,0),(38248,2,17623,0),(38249,10,17623,0),(38250,2,17624,0),(38251,10,17624,0),(38252,2,17625,0),(38253,10,17625,0),(38254,2,17626,0),(38255,10,17626,0),(38256,2,17627,0),(38257,10,17627,0),(38258,2,17628,0),(38259,10,17628,0),(38260,2,17629,0),(38261,10,17629,0),(38262,2,17630,0),(38263,10,17630,0),(38264,2,17631,0),(38265,10,17631,0),(38266,2,17632,0),(38267,10,17632,0),(38268,2,17633,0),(38269,10,17633,0),(38270,2,17634,0),(38271,10,17634,0),(38272,2,17635,0),(38273,10,17635,0),(38274,2,17636,0),(38275,10,17636,0),(38276,2,17637,0),(38277,10,17637,0),(38278,2,17638,0),(38279,10,17638,0),(38280,2,17639,0),(38281,10,17639,0),(38282,2,17640,0),(38283,10,17640,0),(38284,2,17641,0),(38285,10,17641,0),(38286,2,17642,0),(38287,10,17642,0),(38288,2,17643,0),(38289,10,17643,0),(38290,2,17644,0),(38291,10,17644,0),(38292,2,17645,0),(38293,10,17645,0),(38294,2,17646,0),(38295,10,17646,0),(38296,2,17647,0),(38297,10,17647,0),(38298,2,17648,0),(38299,10,17648,0),(38300,2,17649,0),(38301,10,17649,0),(38302,2,17650,0),(38303,10,17650,0),(38304,2,17651,0),(38305,10,17651,0),(38306,2,17652,0),(38307,10,17652,0),(38308,2,17653,0),(38309,10,17653,0),(38310,2,17654,0),(38311,10,17654,0),(38312,2,17655,0),(38313,10,17655,0),(38314,2,17656,0),(38315,10,17656,0),(38316,2,17657,0),(38317,10,17657,0),(38318,2,17658,0),(38319,10,17658,0),(38320,2,17659,0),(38321,10,17659,0),(38322,2,17660,0),(38323,10,17660,0),(38324,2,17661,0),(38325,10,17661,0),(38326,2,17662,0),(38327,10,17662,0),(38328,2,17663,0),(38329,10,17663,0),(38330,2,17664,0),(38331,10,17664,0),(38332,2,17665,0),(38333,10,17665,0),(38334,2,17666,0),(38335,10,17666,0),(38336,2,17667,0),(38337,10,17667,0),(38338,2,17668,0),(38339,10,17668,0),(38340,2,17669,0),(38341,10,17669,0),(38342,2,17670,0),(38343,10,17670,0),(38344,2,17671,0),(38345,10,17671,0),(38346,2,17672,0),(38347,10,17672,0),(38348,2,17673,0),(38349,10,17673,0),(38350,2,17674,0),(38351,10,17674,0),(38352,2,17675,0),(38353,10,17675,0),(38354,2,17676,0),(38355,10,17676,0),(38356,2,17677,0),(38357,10,17677,0),(38358,2,17678,0),(38359,10,17678,0),(38360,2,17679,0),(38361,10,17679,0),(38362,2,17680,0),(38363,10,17680,0),(38364,2,17681,0),(38365,10,17681,0),(38366,2,17682,0),(38367,10,17682,0),(38368,2,17683,0),(38369,10,17683,0),(38370,2,17684,0),(38371,10,17684,0),(38372,2,17685,0),(38373,10,17685,0),(38374,2,17686,0),(38375,10,17686,0),(38376,2,17687,0),(38377,10,17687,0),(38378,2,17688,0),(38379,10,17688,0),(38380,2,17689,0),(38381,10,17689,0),(38382,2,17690,0),(38383,10,17690,0),(38384,2,17691,0),(38385,10,17691,0),(38386,2,17692,0),(38387,10,17692,0),(38388,2,17693,0),(38389,10,17693,0),(38390,2,17694,0),(38391,10,17694,0),(38392,2,17695,0),(38393,10,17695,0),(38394,2,17696,0),(38395,10,17696,0),(38396,2,17697,0),(38397,10,17697,0),(38398,2,17698,0),(38399,10,17698,0),(38400,2,17699,0),(38401,10,17699,0),(38402,2,17700,0),(38403,10,17700,0),(38404,2,17701,0),(38405,10,17701,0),(38406,2,17702,0),(38407,10,17702,0),(38408,2,17703,0),(38409,10,17703,0),(38410,2,17704,0),(38411,10,17704,0),(38412,2,17705,0),(38413,10,17705,0),(38414,2,17706,0),(38415,10,17706,0),(38416,2,17707,0),(38417,10,17707,0),(38418,2,17708,0),(38419,10,17708,0),(38420,2,17709,0),(38421,10,17709,0),(38422,2,17710,0),(38423,10,17710,0),(38424,2,17711,0),(38425,10,17711,0),(38426,2,17712,0),(38427,10,17712,0),(38428,2,17713,0),(38429,10,17713,0),(38430,2,17714,0),(38431,10,17714,0),(38432,2,17715,0),(38433,10,17715,0),(38434,2,17716,0),(38435,10,17716,0),(38436,2,17717,0),(38437,10,17717,0),(38438,2,17718,0),(38439,10,17718,0),(38440,2,17719,0),(38441,10,17719,0),(38442,2,17720,0),(38443,10,17720,0),(38444,2,17721,0),(38445,10,17721,0),(38446,2,17722,0),(38447,10,17722,0),(38448,2,17723,0),(38449,10,17723,0),(38450,2,17724,0),(38451,10,17724,0),(38452,2,17725,0),(38453,10,17725,0),(38454,2,17726,0),(38455,10,17726,0),(38456,2,17727,0),(38457,10,17727,0),(38458,2,17728,0),(38459,10,17728,0),(38460,2,17729,0),(38461,10,17729,0),(38462,2,17730,0),(38463,10,17730,0),(38464,2,17731,0),(38465,10,17731,0),(38466,2,17732,0),(38467,10,17732,0),(38468,2,17733,0),(38469,10,17733,0),(38470,2,17734,0),(38471,10,17734,0),(38472,2,17735,0),(38473,10,17735,0),(38474,2,17736,0),(38475,10,17736,0),(38476,2,17737,0),(38477,10,17737,0),(38478,2,17738,0),(38479,10,17738,0),(38480,2,17739,0),(38481,10,17739,0),(38482,2,17740,0),(38483,10,17740,0),(38484,2,17741,0),(38485,10,17741,0),(38486,2,17742,0),(38487,10,17742,0),(38488,2,17743,0),(38489,10,17743,0),(38490,2,17744,0),(38491,10,17744,0),(38492,2,17745,0),(38493,10,17745,0),(38494,2,17746,0),(38495,10,17746,0),(38496,2,17747,0),(38497,10,17747,0),(38498,2,17748,0),(38499,10,17748,0),(38500,2,17749,0),(38501,10,17749,0),(38502,2,17750,0),(38503,10,17750,0),(38504,2,17751,0),(38505,10,17751,0),(38506,2,17752,0),(38507,10,17752,0),(38508,2,17753,0),(38509,10,17753,0),(38510,2,17754,0),(38511,10,17754,0),(38512,2,17755,0),(38513,10,17755,0),(38514,2,17756,0),(38515,10,17756,0),(38516,2,17757,0),(38517,10,17757,0),(38518,2,17758,0),(38519,10,17758,0),(38520,2,17759,0),(38521,10,17759,0),(38522,2,17760,0),(38523,10,17760,0),(38524,2,17761,0),(38525,10,17761,0),(38526,2,17762,0),(38527,10,17762,0),(38528,2,17763,0),(38529,10,17763,0),(38530,2,17764,0),(38531,10,17764,0),(38532,2,17765,0),(38533,10,17765,0),(38534,2,17766,0),(38535,10,17766,0),(38536,2,17767,0),(38537,10,17767,0),(38538,2,17768,0),(38539,10,17768,0),(38540,2,17769,0),(38541,10,17769,0),(38542,2,17770,0),(38543,10,17770,0),(38544,2,17771,0),(38545,10,17771,0),(38546,2,17772,0),(38547,10,17772,0),(38548,2,17773,0),(38549,10,17773,0),(38550,2,17774,0),(38551,10,17774,0),(38552,2,17775,0),(38553,10,17775,0),(38554,2,17776,0),(38555,10,17776,0),(38556,2,17777,0),(38557,10,17777,0),(38558,2,17778,0),(38559,10,17778,0),(38560,2,17779,0),(38561,10,17779,0),(38562,2,17780,0),(38563,10,17780,0),(38564,2,17781,0),(38565,10,17781,0),(38566,2,17782,0),(38567,10,17782,0),(38568,2,17783,0),(38569,10,17783,0),(38570,2,17784,0),(38571,10,17784,0),(38572,2,17785,0),(38573,10,17785,0),(38574,2,17786,0),(38575,10,17786,0),(38576,2,17787,0),(38577,10,17787,0),(38578,2,17788,0),(38579,10,17788,0),(38580,2,17789,0),(38581,10,17789,0),(38582,2,17790,0),(38583,10,17790,0),(38584,2,17791,0),(38585,10,17791,0),(38586,2,17792,0),(38587,10,17792,0),(38588,2,17793,0),(38589,10,17793,0),(38590,2,17794,0),(38591,10,17794,0),(38592,2,17795,0),(38593,10,17795,0),(38594,2,17796,0),(38595,10,17796,0),(38596,2,17797,0),(38597,10,17797,0),(38598,2,17798,0),(38599,10,17798,0),(38600,2,17799,0),(38601,10,17799,0),(38602,2,17800,0),(38603,10,17800,0),(38604,2,17801,0),(38605,10,17801,0),(38606,2,17802,0),(38607,10,17802,0),(38608,2,17803,0),(38609,10,17803,0),(38610,2,17804,0),(38611,10,17804,0),(38612,2,17805,0),(38613,10,17805,0),(38614,2,17806,0),(38615,10,17806,0),(38616,2,17807,0),(38617,10,17807,0),(38618,2,17808,0),(38619,10,17808,0),(38620,2,17809,0),(38621,10,17809,0),(38622,2,17810,0),(38623,10,17810,0),(38624,2,17811,0),(38625,10,17811,0),(38626,2,17812,0),(38627,10,17812,0),(38628,2,17813,0),(38629,10,17813,0),(38630,2,17814,0),(38631,10,17814,0),(38632,2,17815,0),(38633,10,17815,0),(38634,2,17816,0),(38635,10,17816,0),(38636,2,17817,0),(38637,10,17817,0),(38638,2,17818,0),(38639,10,17818,0),(38640,2,17819,0),(38641,10,17819,0),(38642,2,17820,0),(38643,10,17820,0),(38644,2,17821,0),(38645,10,17821,0),(38646,2,17822,0),(38647,10,17822,0),(38648,2,17823,0),(38649,10,17823,0),(38650,2,17824,0),(38651,10,17824,0),(38652,2,17825,0),(38653,10,17825,0),(38654,2,17826,0),(38655,10,17826,0),(38656,2,17827,0),(38657,10,17827,0),(38658,2,17828,0),(38659,10,17828,0),(38660,2,17829,0),(38661,10,17829,0),(38662,2,17830,0),(38663,10,17830,0),(38664,2,17831,0),(38665,10,17831,0),(38666,2,17832,0),(38667,10,17832,0),(38668,2,17833,0),(38669,10,17833,0),(38670,2,17834,0),(38671,10,17834,0),(38672,2,17835,0),(38673,10,17835,0),(38674,2,17836,0),(38675,10,17836,0),(38676,2,17837,0),(38677,10,17837,0),(38678,2,17838,0),(38679,10,17838,0),(38680,2,17839,0),(38681,10,17839,0),(38682,2,17840,0),(38683,10,17840,0),(38684,2,17841,0),(38685,10,17841,0),(38686,2,17842,0),(38687,10,17842,0),(38688,2,17843,0),(38689,10,17843,0),(38690,2,17844,0),(38691,10,17844,0),(38692,2,17845,0),(38693,10,17845,0),(38694,2,17846,0),(38695,10,17846,0),(38696,2,17847,0),(38697,10,17847,0),(38698,2,17848,0),(38699,10,17848,0),(38700,2,17849,0),(38701,10,17849,0),(38702,2,17850,0),(38703,10,17850,0),(38704,2,17851,0),(38705,10,17851,0),(38706,2,17852,0),(38707,10,17852,0),(38708,2,17853,0),(38709,10,17853,0),(38710,2,17854,0),(38711,10,17854,0),(38712,2,17855,0),(38713,10,17855,0),(38714,2,17856,0),(38715,10,17856,0),(38716,2,17857,0),(38717,10,17857,0),(38718,2,17858,0),(38719,10,17858,0),(38720,2,17859,0),(38721,10,17859,0),(38722,2,17860,0),(38723,10,17860,0),(38724,2,17861,0),(38725,10,17861,0),(38726,2,17862,0),(38727,10,17862,0),(38728,2,17863,0),(38729,10,17863,0),(38730,2,17864,0),(38731,10,17864,0),(38732,2,17865,0),(38733,10,17865,0),(38734,2,17866,0),(38735,10,17866,0),(38736,2,17867,0),(38737,10,17867,0),(38738,2,17868,0),(38739,10,17868,0),(38740,2,17869,0),(38741,10,17869,0),(38742,2,17870,0),(38743,10,17870,0),(38744,2,17871,0),(38745,10,17871,0),(38746,2,17872,0),(38747,10,17872,0),(38748,2,17873,0),(38749,10,17873,0),(38750,2,17874,0),(38751,10,17874,0),(38752,2,17875,0),(38753,10,17875,0),(38754,2,17876,0),(38755,10,17876,0),(38756,2,17877,0),(38757,10,17877,0),(38758,2,17878,0),(38759,10,17878,0),(38760,2,17879,0),(38761,10,17879,0),(38762,2,17880,0),(38763,10,17880,0),(38764,2,17881,0),(38765,10,17881,0),(38766,2,17882,0),(38767,10,17882,0),(38768,2,17883,0),(38769,10,17883,0),(38770,2,17884,0),(38771,10,17884,0),(38772,2,17885,0),(38773,10,17885,0),(38774,2,17886,0),(38775,10,17886,0),(38776,2,17887,0),(38777,10,17887,0),(38778,2,17888,0),(38779,10,17888,0),(38780,2,17889,0),(38781,10,17889,0),(38782,2,17890,0),(38783,10,17890,0),(38784,2,17891,0),(38785,10,17891,0),(38786,2,17892,0),(38787,10,17892,0),(38788,2,17893,0),(38789,10,17893,0),(38790,2,17894,0),(38791,10,17894,0),(38792,2,17895,0),(38793,10,17895,0),(38794,2,17896,0),(38795,10,17896,0),(38796,2,17897,0),(38797,10,17897,0),(38798,2,17898,0),(38799,10,17898,0),(38800,2,17899,0),(38801,10,17899,0),(38802,2,17900,0),(38803,10,17900,0),(38804,2,17901,0),(38805,10,17901,0),(38806,2,17902,0),(38807,10,17902,0),(38808,2,17903,0),(38809,10,17903,0),(38810,2,17904,0),(38811,10,17904,0),(38812,2,17905,0),(38813,10,17905,0),(38814,2,17906,0),(38815,10,17906,0),(38816,2,17907,0),(38817,10,17907,0),(38818,2,17908,0),(38819,10,17908,0),(38820,2,17909,0),(38821,10,17909,0),(38822,2,17910,0),(38823,10,17910,0),(38824,2,17911,0),(38825,10,17911,0),(38826,2,17912,0),(38827,10,17912,0),(38828,2,17913,0),(38829,10,17913,0),(38830,2,17914,0),(38831,10,17914,0),(38832,2,17915,0),(38833,10,17915,0),(38834,2,17916,0),(38835,10,17916,0),(38836,2,17917,0),(38837,10,17917,0),(38838,2,17918,0),(38839,10,17918,0),(38840,2,17919,0),(38841,10,17919,0),(38842,2,17920,0),(38843,10,17920,0),(38844,2,17921,0),(38845,10,17921,0),(38846,2,17922,0),(38847,10,17922,0),(38848,2,17923,0),(38849,10,17923,0),(38850,2,17924,0),(38851,10,17924,0),(38852,2,17925,0),(38853,10,17925,0),(38854,2,17926,0),(38855,10,17926,0),(38856,2,17927,0),(38857,10,17927,0),(38858,2,17928,0),(38859,10,17928,0),(38860,2,17929,0),(38861,10,17929,0),(38862,2,17930,0),(38863,10,17930,0),(38864,2,17931,0),(38865,10,17931,0),(38866,2,17932,0),(38867,10,17932,0),(38868,2,17933,0),(38869,10,17933,0),(38870,2,17934,0),(38871,10,17934,0),(38872,2,17935,0),(38873,10,17935,0),(38874,2,17936,0),(38875,10,17936,0),(38876,2,17937,0),(38877,10,17937,0),(38878,2,17938,0),(38879,10,17938,0),(38880,2,17939,0),(38881,10,17939,0),(38882,2,17940,0),(38883,10,17940,0),(38884,2,17941,0),(38885,10,17941,0),(38886,2,17942,0),(38887,10,17942,0),(38888,2,17943,0),(38889,10,17943,0),(38890,2,17944,0),(38891,10,17944,0),(38892,2,17945,0),(38893,10,17945,0),(38894,2,17946,0),(38895,10,17946,0),(38896,2,17947,0),(38897,10,17947,0),(38898,2,17948,0),(38899,10,17948,0),(38900,2,17949,0),(38901,10,17949,0),(38902,2,17950,0),(38903,10,17950,0),(38904,2,17951,0),(38905,10,17951,0),(38906,2,17952,0),(38907,10,17952,0),(38908,2,17953,0),(38909,10,17953,0),(38910,2,17954,0),(38911,10,17954,0),(38912,2,17955,0),(38913,10,17955,0),(38914,2,17956,0),(38915,10,17956,0),(38916,2,17957,0),(38917,10,17957,0),(38918,2,17958,0),(38919,10,17958,0),(38920,2,17959,0),(38921,10,17959,0),(38922,2,17960,0),(38923,10,17960,0),(38924,2,17961,0),(38925,10,17961,0),(38926,2,17962,0),(38927,10,17962,0),(38928,2,17963,0),(38929,10,17963,0),(38930,2,17964,0),(38931,10,17964,0),(38932,2,17965,0),(38933,10,17965,0),(38934,2,17966,0),(38935,10,17966,0),(38936,2,17967,0),(38937,10,17967,0),(38938,2,17968,0),(38939,10,17968,0),(38940,2,17969,0),(38941,10,17969,0),(38942,2,17970,0),(38943,10,17970,0),(38944,2,17971,0),(38945,10,17971,0),(38946,2,17972,0),(38947,10,17972,0),(38948,2,17973,0),(38949,10,17973,0),(38950,2,17974,0),(38951,10,17974,0),(38952,2,17975,0),(38953,10,17975,0),(38954,2,17976,0),(38955,10,17976,0),(38956,2,17977,0),(38957,10,17977,0),(38958,2,17978,0),(38959,10,17978,0),(38960,2,17979,0),(38961,10,17979,0),(38962,2,17980,0),(38963,10,17980,0),(38964,2,17981,0),(38965,10,17981,0),(38966,2,17982,0),(38967,10,17982,0),(38968,2,17983,0),(38969,10,17983,0),(38970,2,17984,0),(38971,10,17984,0),(38972,2,17985,0),(38973,10,17985,0),(38974,2,17986,0),(38975,10,17986,0),(38976,2,17987,0),(38977,10,17987,0),(38978,2,17988,0),(38979,10,17988,0),(38980,2,17989,0),(38981,10,17989,0),(38982,2,17990,0),(38983,10,17990,0),(38984,2,17991,0),(38985,10,17991,0),(38986,2,17992,0),(38987,10,17992,0),(38988,2,17993,0),(38989,10,17993,0),(38990,2,17994,0),(38991,10,17994,0),(38992,2,17995,0),(38993,10,17995,0),(38994,2,17996,0),(38995,10,17996,0),(38996,2,17997,0),(38997,10,17997,0),(38998,2,17998,0),(38999,10,17998,0),(39000,2,17999,0),(39001,10,17999,0),(39002,2,18000,0),(39003,10,18000,0),(39004,2,18001,0),(39005,10,18001,0),(39006,2,18002,0),(39007,10,18002,0),(39008,2,18003,0),(39009,10,18003,0),(39010,2,18004,0),(39011,10,18004,0),(39012,2,18005,0),(39013,10,18005,0),(39014,2,18006,0),(39015,10,18006,0),(39016,2,18007,0),(39017,10,18007,0),(39018,2,18008,0),(39019,10,18008,0),(39020,2,18009,0),(39021,10,18009,0),(39022,2,18010,0),(39023,10,18010,0),(39024,2,18011,0),(39025,10,18011,0),(39026,2,18012,0),(39027,10,18012,0),(39028,2,18013,0),(39029,10,18013,0),(39030,2,18014,0),(39031,10,18014,0),(39032,2,18015,0),(39033,10,18015,0),(39034,2,18016,0),(39035,10,18016,0),(39036,2,18017,0),(39037,10,18017,0),(39038,2,18018,0),(39039,10,18018,0),(39040,2,18019,0),(39041,10,18019,0),(39042,2,18020,0),(39043,10,18020,0),(39044,2,18021,0),(39045,10,18021,0),(39046,2,18022,0),(39047,10,18022,0),(39048,2,18023,0),(39049,10,18023,0),(39050,2,18024,0),(39051,10,18024,0),(39052,2,18025,0),(39053,10,18025,0),(39054,2,18026,0),(39055,10,18026,0),(39056,2,18027,0),(39057,10,18027,0),(39058,2,18028,0),(39059,10,18028,0),(39060,2,18029,0),(39061,10,18029,0),(39062,2,18030,0),(39063,10,18030,0),(39064,2,18031,0),(39065,10,18031,0),(39066,2,18032,0),(39067,10,18032,0),(39068,2,18033,0),(39069,10,18033,0),(39070,2,18034,0),(39071,10,18034,0),(39072,2,18035,0),(39073,10,18035,0),(39074,2,18036,0),(39075,10,18036,0),(39076,2,18037,0),(39077,10,18037,0),(39078,2,18038,0),(39079,10,18038,0),(39080,2,18039,0),(39081,10,18039,0),(39082,2,18040,0),(39083,10,18040,0),(39084,2,18041,0),(39085,10,18041,0),(39086,2,18042,0),(39087,10,18042,0),(39088,2,18043,0),(39089,10,18043,0),(39090,2,18044,0),(39091,10,18044,0),(39092,2,18045,0),(39093,10,18045,0),(39094,2,18046,0),(39095,10,18046,0),(39096,2,18047,0),(39097,10,18047,0),(39098,2,18048,0),(39099,10,18048,0),(39100,2,18049,0),(39101,10,18049,0),(39102,2,18050,0),(39103,10,18050,0),(39104,2,18051,0),(39105,10,18051,0),(39106,2,18052,0),(39107,10,18052,0),(39108,2,18053,0),(39109,10,18053,0),(39110,2,18054,0),(39111,10,18054,0),(39112,2,18055,0),(39113,10,18055,0),(39114,2,18056,0),(39115,10,18056,0),(39116,2,18057,0),(39117,10,18057,0),(39118,2,18058,0),(39119,10,18058,0),(39120,2,18059,0),(39121,10,18059,0),(39122,2,18060,0),(39123,10,18060,0),(39124,2,18061,0),(39125,10,18061,0),(39126,2,18062,0),(39127,10,18062,0),(39128,2,18063,0),(39129,10,18063,0),(39130,2,18064,0),(39131,10,18064,0),(39132,2,18065,0),(39133,10,18065,0),(39134,2,18066,0),(39135,10,18066,0),(39136,2,18067,0),(39137,10,18067,0),(39138,2,18068,0),(39139,10,18068,0),(39140,2,18069,0),(39141,10,18069,0),(39142,2,18070,0),(39143,10,18070,0),(39144,2,18071,0),(39145,10,18071,0),(39146,2,18072,0),(39147,10,18072,0),(39148,2,18073,0),(39149,10,18073,0),(39150,2,18074,0),(39151,10,18074,0),(39152,2,18075,0),(39153,10,18075,0),(39154,2,18076,0),(39155,10,18076,0),(39156,2,18077,0),(39157,10,18077,0),(39158,2,18078,0),(39159,10,18078,0),(39160,2,18079,0),(39161,10,18079,0),(39162,2,18080,0),(39163,10,18080,0),(39164,2,18081,0),(39165,10,18081,0),(39166,2,18082,0),(39167,10,18082,0),(39168,2,18083,0),(39169,10,18083,0),(39170,2,18084,0),(39171,10,18084,0),(39172,2,18085,0),(39173,10,18085,0),(39174,2,18086,0),(39175,10,18086,0),(39176,2,18087,0),(39177,10,18087,0),(39178,2,18088,0),(39179,10,18088,0),(39180,2,18089,0),(39181,10,18089,0),(39182,2,18090,0),(39183,2,18091,0),(39184,2,18092,0),(39185,2,18093,0),(39186,2,18094,0),(39187,2,18095,0),(39188,2,18096,0),(39189,2,18097,0),(39190,2,18098,0),(39200,2,18099,0),(39201,2,18100,0),(39202,2,18101,0),(39203,2,18102,0),(39204,2,18103,0),(39205,2,18104,0),(39206,2,18105,0),(39207,2,18106,0),(39208,2,18107,0),(39209,2,18108,0),(39210,2,18109,0),(39211,2,18110,0),(39212,2,18111,0),(39213,2,18112,0),(39214,2,18113,0),(39215,2,18114,0),(39216,2,18115,0),(39217,2,18116,0),(39218,2,18117,0),(39219,2,18118,0),(39220,2,18119,0),(39221,2,18120,0),(39222,2,18121,0),(39223,2,18122,0),(39224,2,18123,0),(39225,2,18124,0),(39226,2,18125,0),(39227,2,18126,0),(39228,2,18127,0),(39229,2,18128,0),(39230,2,18129,0),(39231,2,18130,0),(39232,2,18131,0),(39233,2,18132,0),(39234,2,18133,0),(39235,2,18134,0),(39236,2,18135,0),(39237,2,18136,0),(39238,2,18137,0),(39239,2,18138,0),(39240,2,18139,0),(39241,2,18140,0),(39242,2,18141,0),(39243,2,18142,0),(39244,2,18143,0),(39245,2,18144,0),(39246,2,18145,0),(39247,2,18146,0),(39248,2,18147,0),(39249,2,18148,0),(39250,2,18149,0),(39251,2,18150,0),(39252,2,18151,0),(39253,2,18152,0),(39254,2,18153,0),(39255,2,18154,0),(39256,2,18155,0),(39257,2,18156,0),(39258,2,18157,0),(39259,2,18158,0),(39260,2,18159,0),(39261,2,18160,0),(39262,2,18161,0),(39263,2,18162,0),(39264,2,18163,0),(39265,2,18164,0),(39266,2,18165,0),(39267,2,18166,0),(39268,2,18167,0),(39269,2,18168,0),(39270,2,18169,0),(39271,2,18170,0),(39272,2,18171,0),(39273,2,18172,0),(39274,2,18173,0),(39275,2,18174,0),(39276,2,18175,0),(39277,2,18176,0),(39278,2,18177,0),(39279,2,18178,0),(39280,2,18179,0),(39281,2,18180,0),(39282,2,18181,0),(39283,2,18182,0),(39284,2,18183,0),(39285,2,18184,0),(39286,2,18185,0),(39287,2,18186,0),(39288,2,18187,0),(39289,2,18188,0),(39290,2,18189,0),(39291,2,18190,0),(39292,2,18191,0),(39293,2,18192,0),(39294,2,18193,0),(39295,2,18194,0),(39296,2,18195,0),(39297,2,18196,0),(39298,2,18197,0),(39299,2,18198,0),(39400,2,18199,0),(39401,2,18200,0),(39402,2,18201,0),(39403,2,18202,0),(39404,2,18203,0),(39405,2,18204,0),(39406,2,18205,0),(39407,2,18206,0),(39408,2,18207,0),(39409,2,18208,0),(39410,2,18209,0),(39411,2,18210,0),(39412,2,18211,0),(39413,2,18212,0),(39414,2,18213,0),(39415,2,18214,0),(39416,2,18215,0),(39417,2,18216,0),(39418,2,18217,0),(39419,2,18218,0),(39420,2,18219,0),(39421,2,18220,0),(39422,2,18221,0),(39423,2,18222,0),(39424,2,18223,0),(39425,2,18224,0),(39426,2,18225,0),(39427,2,18226,0),(39428,2,18227,0),(39429,2,18228,0),(39430,2,18229,0),(39431,2,18230,0),(39432,2,18231,0),(39433,2,18232,0),(39434,2,18233,0),(39435,2,18234,0),(39436,2,18235,0),(39437,2,18236,0),(39438,2,18237,0),(39439,2,18238,0),(39440,2,18239,0),(39441,2,18240,0),(39442,2,18241,0),(39443,2,18242,0),(39444,2,18243,0),(39445,2,18244,0),(39446,2,18245,0),(39447,2,18246,0),(39448,2,18247,0),(39449,2,18248,0),(39450,2,18249,0),(39451,2,18250,0),(39452,2,18251,0),(39453,2,18252,0),(39454,2,18253,0),(39455,2,18254,0),(39456,2,18255,0),(39457,2,18256,0),(39458,2,18257,0),(39459,2,18258,0),(39460,2,18259,0),(39461,2,18260,0),(39462,2,18261,0),(39463,2,18262,0),(39464,2,18263,0),(39465,2,18264,0),(39466,2,18265,0),(39467,2,18266,0),(39468,2,18267,0),(39469,2,18268,0),(39470,2,18269,0),(39471,2,18270,0),(39472,2,18271,0),(39473,2,18272,0),(39474,2,18273,0),(39475,2,18274,0),(39476,2,18275,0),(39477,2,18276,0),(39478,2,18277,0),(39479,2,18278,0),(39480,2,18279,0),(39481,2,18280,0),(39482,2,18281,0),(39483,2,18282,0),(39484,2,18283,0),(39485,2,18284,0),(39486,2,18285,0),(39487,2,18286,0),(39488,2,18287,0),(39489,2,18288,0),(39490,2,18289,0),(39491,2,18290,0),(39492,2,18291,0),(39493,2,18292,0),(39494,2,18293,0),(39495,2,18294,0),(39496,2,18295,0),(39497,2,18296,0),(39498,2,18297,0),(39499,2,18298,0),(39600,2,18299,0),(39601,2,18300,0),(39602,2,18301,0),(39603,2,18302,0),(39604,2,18303,0),(39605,2,18304,0),(39606,2,18305,0),(39607,2,18306,0),(39608,2,18307,0),(39609,2,18308,0),(39610,2,18309,0),(45214,10,19518,0),(45215,10,19519,0),(45216,10,19520,0),(45217,10,19521,0),(45218,10,19522,0),(45219,10,19523,0),(45220,10,19524,0),(45221,10,19525,0),(45222,10,19526,0),(45223,10,19527,0),(45224,10,19528,0),(45225,10,19529,0),(45226,10,19530,0),(45227,10,19531,0),(45228,10,19532,0),(45229,10,19533,0),(45230,10,19534,0),(45231,10,19535,0),(45232,10,19536,0),(45233,10,19537,0),(45234,2,19517,0),(45235,2,19518,0),(45236,2,19519,0),(45237,2,19520,0),(45238,2,19521,0),(45239,2,19522,0),(45240,2,19523,0),(45241,2,19524,0),(45242,2,19525,0),(45243,2,19526,0),(45244,2,19527,0),(45245,2,19528,0),(45246,2,19529,0),(45247,2,19530,0),(45248,2,19532,0),(45249,2,19533,0),(45250,2,19534,0),(45251,2,19535,0),(45252,2,19536,0),(45253,2,19537,0),(45254,2,19510,0),(45255,2,19511,0),(45256,2,19512,0),(45257,2,19513,0),(45258,2,19514,0),(45259,2,19515,0),(45260,2,19516,0),(45261,10,19510,0),(45262,10,19511,0),(45263,10,19512,0),(45264,10,19513,0),(45265,10,19514,0),(45266,10,19515,0),(45267,10,19516,0),(45268,10,19517,0),(57506,2,19549,0),(57507,10,19549,0),(57508,2,19550,0),(57509,10,19550,0),(57510,2,19551,0),(57511,10,19551,0),(57512,2,19552,0),(57513,10,19552,0),(57548,2,19561,0),(57549,10,19561,0),(57556,2,19556,0),(57557,10,19556,0),(57558,2,19557,0),(57559,10,19557,0),(57560,2,19563,0),(57561,10,19563,0),(57562,2,19564,0),(57563,10,19564,0),(57564,2,19565,0),(57565,10,19565,0),(57566,2,19566,0),(57567,10,19566,0),(57568,2,19567,0),(57569,10,19567,0),(57578,2,19570,0),(57579,10,19570,0),(57580,2,19571,0),(57581,10,19571,0),(57584,2,19573,0),(57592,2,19576,0),(57593,10,19576,0),(57901,2,19579,0),(57902,10,19579,0),(57903,2,19580,0);
/*!40000 ALTER TABLE `catalog_category_product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index`
--

DROP TABLE IF EXISTS `catalog_category_product_index`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_product_index` (
  `category_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Category ID',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `position` int(11) DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `visibility` smallint(5) unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `CAT_CTGR_PRD_IDX_PRD_ID_STORE_ID_CTGR_ID_VISIBILITY` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `CAT_CTGR_PRD_IDX_STORE_ID_CTGR_ID_VISIBILITY_IS_PARENT_POSITION` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Product Index';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index`
--

LOCK TABLES `catalog_category_product_index` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_category_product_index` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index_replica`
--

DROP TABLE IF EXISTS `catalog_category_product_index_replica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_product_index_replica` (
  `category_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Category ID',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `position` int(11) DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `visibility` smallint(5) unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `CAT_CTGR_PRD_IDX_PRD_ID_STORE_ID_CTGR_ID_VISIBILITY` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `CAT_CTGR_PRD_IDX_STORE_ID_CTGR_ID_VISIBILITY_IS_PARENT_POSITION` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Product Index';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index_replica`
--

LOCK TABLES `catalog_category_product_index_replica` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index_replica` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_category_product_index_replica` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index_store5`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store5`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_product_index_store5` (
  `category_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int(11) DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint(5) unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `IDX_78288F76D618C4C378D1DE1DB362C05F` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_04B1890D19F381013371F9182F62C602` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Product Index Store5 Replica';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index_store5`
--

LOCK TABLES `catalog_category_product_index_store5` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index_store5` DISABLE KEYS */;
INSERT INTO `catalog_category_product_index_store5` VALUES (2,477,0,0,5,4),(2,478,0,0,5,4),(2,479,0,0,5,4),(2,696,0,0,5,4),(2,697,0,0,5,4),(2,739,0,0,5,4),(2,860,0,0,5,4),(2,966,0,0,5,4),(2,971,0,0,5,4),(2,998,0,0,5,4),(2,1001,0,0,5,4),(2,1002,0,0,5,4),(2,1003,0,0,5,4),(2,1005,0,0,5,4),(2,1006,0,0,5,4),(2,1007,0,0,5,4),(2,1008,0,0,5,4),(2,1011,0,0,5,4),(2,1012,0,0,5,4),(2,1014,0,0,5,4),(2,1020,0,0,5,4),(2,1022,0,0,5,4),(2,1024,0,0,5,4),(2,1029,0,0,5,4),(2,1030,0,0,5,4),(2,1127,0,0,5,4),(2,1134,0,0,5,4),(2,1135,0,0,5,4),(2,1136,0,0,5,4),(2,1421,0,0,5,4),(2,1429,0,0,5,4),(2,1430,0,0,5,4),(2,1431,0,0,5,4),(2,1432,0,0,5,4),(2,1433,0,0,5,4),(2,1437,0,0,5,4),(2,1470,0,0,5,4),(2,1471,0,0,5,4),(2,1472,0,0,5,4),(2,1473,0,0,5,4),(2,1616,0,0,5,4),(2,1617,0,0,5,4),(2,1622,0,0,5,4),(2,1623,0,0,5,4),(2,1626,0,0,5,4),(2,1651,0,0,5,4),(2,1667,0,0,5,4),(2,1668,0,0,5,4),(2,1669,0,0,5,4),(2,1670,0,0,5,4),(2,1671,0,0,5,4),(2,1672,0,0,5,4),(2,1675,0,0,5,4),(2,1678,0,0,5,4),(2,1679,0,0,5,4),(2,1680,0,0,5,4),(2,1681,0,0,5,4),(2,1682,0,0,5,4),(2,1683,0,0,5,4),(2,1684,0,0,5,4),(2,1685,0,0,5,4),(2,1686,0,0,5,4),(2,1687,0,0,5,4),(2,1688,0,0,5,4),(2,1689,0,0,5,4),(2,1690,0,0,5,4),(2,1691,0,0,5,4),(2,1692,0,0,5,4),(2,1693,0,0,5,4),(2,1694,0,0,5,4),(2,1695,0,0,5,4),(2,1696,0,0,5,4),(2,1697,0,0,5,4),(2,1699,0,0,5,4),(2,1700,0,0,5,4),(2,1702,0,0,5,4),(2,1703,0,0,5,4),(2,1708,0,0,5,4),(2,1709,0,0,5,4),(2,1710,0,0,5,4),(2,1711,0,0,5,4),(2,1712,0,0,5,4),(2,1714,0,0,5,4),(2,1715,0,0,5,4),(2,1716,0,0,5,4),(2,1717,0,0,5,4),(2,1718,0,0,5,4),(2,1719,0,0,5,4),(2,1720,0,0,5,4),(2,1721,0,0,5,4),(2,1734,0,0,5,4),(2,1735,0,0,5,4),(2,1849,0,0,5,4),(2,1851,0,0,5,4),(2,1852,0,0,5,4),(2,1853,0,0,5,4),(2,1863,0,0,5,4),(2,1871,0,0,5,4),(2,1872,0,0,5,4),(2,1893,0,0,5,4),(2,1919,0,0,5,4),(2,1920,0,0,5,4),(2,1937,0,0,5,4),(2,1938,0,0,5,4),(2,1940,0,0,5,4),(2,1942,0,0,5,4),(2,1943,0,0,5,4),(2,1944,0,0,5,4),(2,1945,0,0,5,4),(2,1946,0,0,5,4),(2,2000,0,0,5,4),(2,2001,0,0,5,4),(2,2002,0,0,5,4),(2,2003,0,0,5,4),(2,2004,0,0,5,4),(2,2005,0,0,5,4),(2,2006,0,0,5,4),(2,2007,0,0,5,4),(2,2008,0,0,5,4),(2,2011,0,0,5,4),(2,2015,0,0,5,4),(2,2016,0,0,5,4),(2,2017,0,0,5,4),(2,2019,0,0,5,4),(2,2020,0,0,5,4),(2,2021,0,0,5,4),(2,2022,0,0,5,4),(2,2023,0,0,5,4),(2,2024,0,0,5,4),(2,2025,0,0,5,4),(2,2026,0,0,5,4),(2,2027,0,0,5,4),(2,2029,0,0,5,4),(2,2030,0,0,5,4),(2,2031,0,0,5,4),(2,2032,0,0,5,4),(2,2033,0,0,5,4),(2,2034,0,0,5,4),(2,2035,0,0,5,4),(2,2036,0,0,5,4),(2,2037,0,0,5,4),(2,2039,0,0,5,4),(2,2040,0,0,5,4),(2,2041,0,0,5,4),(2,2042,0,0,5,4),(2,2043,0,0,5,4),(2,2044,0,0,5,4),(2,2045,0,0,5,4),(2,2046,0,0,5,4),(2,2047,0,0,5,4),(2,2048,0,0,5,4),(2,2049,0,0,5,4),(2,2051,0,0,5,4),(2,2052,0,0,5,4),(2,2053,0,0,5,4),(2,2054,0,0,5,4),(2,2055,0,0,5,4),(2,2057,0,0,5,4),(2,2058,0,0,5,4),(2,2059,0,0,5,4),(2,2060,0,0,5,4),(2,2069,0,0,5,4),(2,2073,0,0,5,4),(2,2074,0,0,5,4),(2,2075,0,0,5,4),(2,2076,0,0,5,4),(2,2077,0,0,5,4),(2,2078,0,0,5,4),(2,2079,0,0,5,4),(2,2080,0,0,5,4),(2,2084,0,0,5,4),(2,2085,0,0,5,4),(2,2088,0,0,5,4),(2,2089,0,0,5,4),(2,2090,0,0,5,4),(2,2092,0,0,5,4),(2,2093,0,0,5,4),(2,2096,0,0,5,4),(2,2097,0,0,5,4),(2,2098,0,0,5,4),(2,2101,0,0,5,4),(2,2102,0,0,5,4),(2,2103,0,0,5,4),(2,2104,0,0,5,4),(2,2105,0,0,5,4),(2,2106,0,0,5,4),(2,2107,0,0,5,4),(2,2233,0,0,5,4),(2,2529,0,0,5,4),(2,2530,0,0,5,4),(2,2531,0,0,5,4),(2,2532,0,0,5,4),(2,2535,0,0,5,4),(2,2536,0,0,5,4),(2,2537,0,0,5,4),(2,2538,0,0,5,4),(2,2539,0,0,5,4),(2,2540,0,0,5,4),(2,2601,0,0,5,4),(2,2602,0,0,5,4),(2,2603,0,0,5,4),(2,2604,0,0,5,4),(2,2605,0,0,5,4),(2,2611,0,0,5,4),(2,2612,0,0,5,4),(2,2621,0,0,5,4),(2,2622,0,0,5,4),(2,2623,0,0,5,4),(2,2624,0,0,5,4),(2,2625,0,0,5,4),(2,2626,0,0,5,4),(2,2627,0,0,5,4),(2,2631,0,0,5,4),(2,2632,0,0,5,4),(2,2633,0,0,5,4),(2,2638,0,0,5,4),(2,2640,0,0,5,4),(2,2642,0,0,5,4),(2,2643,0,0,5,4),(2,2647,0,0,5,4),(2,2649,0,0,5,4),(2,2650,0,0,5,4),(2,2665,0,0,5,4),(2,2666,0,0,5,4),(2,2667,0,0,5,4),(2,2668,0,0,5,4),(2,2669,0,0,5,4),(2,2674,0,0,5,4),(2,2675,0,0,5,4),(2,2764,0,0,5,4),(2,2886,0,0,5,4),(2,2887,0,0,5,4),(2,2923,0,0,5,4),(2,2935,0,0,5,4),(2,2936,0,0,5,4),(2,2937,0,0,5,4),(2,3035,0,0,5,4),(2,3153,0,0,5,4),(2,3154,0,0,5,4),(2,3476,0,0,5,4),(2,3689,0,0,5,4),(2,3828,0,0,5,4),(2,3829,0,0,5,4),(2,3836,0,0,5,4),(2,3837,0,0,5,4),(2,3838,0,0,5,4),(2,3839,0,0,5,4),(2,3840,0,0,5,4),(2,3841,0,0,5,4),(2,3842,0,0,5,4),(2,3843,0,0,5,4),(2,3844,0,0,5,4),(2,3846,0,0,5,4),(2,3847,0,0,5,4),(2,3848,0,0,5,4),(2,3849,0,0,5,4),(2,3850,0,0,5,4),(2,3851,0,0,5,4),(2,3852,0,0,5,4),(2,3853,0,0,5,4),(2,3854,0,0,5,4),(2,3855,0,0,5,4),(2,3856,0,0,5,4),(2,3857,0,0,5,4),(2,3858,0,0,5,4),(2,3859,0,0,5,4),(2,3863,0,0,5,4),(2,3865,0,0,5,4),(2,3879,0,0,5,4),(2,3880,0,0,5,4),(2,3881,0,0,5,4),(2,3886,0,0,5,4),(2,3888,0,0,5,4),(2,3889,0,0,5,4),(2,3890,0,0,5,4),(2,3891,0,0,5,4),(2,4056,0,0,5,4),(2,4058,0,0,5,4),(2,4059,0,0,5,4),(2,4265,0,0,5,4),(2,4315,0,0,5,4),(2,4316,0,0,5,4),(2,4317,0,0,5,4),(2,4318,0,0,5,4),(2,4319,0,0,5,4),(2,4321,0,0,5,4),(2,4322,0,0,5,4),(2,4323,0,0,5,4),(2,4546,0,0,5,4),(2,4628,0,0,5,4),(2,4643,0,0,5,4),(2,4645,0,0,5,4),(2,4749,0,0,5,4),(2,4750,0,0,5,4),(2,4751,0,0,5,4),(2,4752,0,0,5,4),(2,4762,0,0,5,4),(2,4763,0,0,5,4),(2,7740,0,0,5,4),(2,7741,0,0,5,4),(2,7742,0,0,5,4),(2,7743,0,0,5,4),(2,7744,0,0,5,4),(2,7745,0,0,5,4),(2,7746,0,0,5,4),(2,7747,0,0,5,4),(2,7748,0,0,5,4),(2,7749,0,0,5,4),(2,7750,0,0,5,4),(2,7771,0,0,5,4),(2,7846,0,0,5,4),(2,9709,0,0,5,4),(2,9723,0,0,5,4),(2,9735,0,0,5,4),(2,9736,0,0,5,4),(2,9739,0,0,5,4),(2,9743,0,0,5,4),(2,9745,0,0,5,4),(2,9747,0,0,5,4),(2,9763,0,0,5,4),(2,9834,0,0,5,4),(2,9897,0,0,5,4),(2,9920,0,0,5,4),(2,9922,0,0,5,4),(2,9923,0,0,5,4),(2,9929,0,0,5,4),(2,9941,0,0,5,4),(2,10000,0,0,5,4),(2,10001,0,0,5,4),(2,10002,0,0,5,4),(2,10004,0,0,5,4),(2,10005,0,0,5,4),(2,10006,0,0,5,4),(2,10007,0,0,5,4),(2,10008,0,0,5,4),(2,10010,0,0,5,4),(2,10013,0,0,5,4),(2,10014,0,0,5,4),(2,10015,0,0,5,4),(2,10016,0,0,5,4),(2,10018,0,0,5,4),(2,10019,0,0,5,4),(2,10020,0,0,5,4),(2,10021,0,0,5,4),(2,10022,0,0,5,4),(2,10023,0,0,5,4),(2,10024,0,0,5,4),(2,10029,0,0,5,4),(2,10035,0,0,5,4),(2,10036,0,0,5,4),(2,10037,0,0,5,4),(2,10040,0,0,5,4),(2,10041,0,0,5,4),(2,10043,0,0,5,4),(2,10044,0,0,5,4),(2,10047,0,0,5,4),(2,10068,0,0,5,4),(2,10156,0,0,5,4),(2,10157,0,0,5,4),(2,10237,0,0,5,4),(2,10432,0,0,5,4),(2,10434,0,0,5,4),(2,10435,0,0,5,4),(2,10584,0,0,5,4),(2,10681,0,0,5,4),(2,10683,0,0,5,4),(2,10891,0,0,5,4),(2,10905,0,0,5,4),(2,11057,0,0,5,4),(2,11076,0,0,5,4),(2,11155,0,0,5,4),(2,11233,0,0,5,4),(2,11270,0,0,5,4),(2,11407,0,0,5,4),(2,11511,0,0,5,4),(2,11520,0,0,5,4),(2,11571,0,0,5,4),(2,11630,0,0,5,4),(2,11636,0,0,5,4),(2,11640,0,0,5,4),(2,11641,0,0,5,4),(2,11644,0,0,5,4),(2,11651,0,0,5,4),(2,11653,0,0,5,4),(2,11686,0,0,5,4),(2,11787,0,0,5,4),(2,12227,0,0,5,4),(2,12239,0,0,5,4),(2,12240,0,0,5,4),(2,12241,0,0,5,4),(2,12242,0,0,5,4),(2,12243,0,0,5,4),(2,12244,0,0,5,4),(2,12245,0,0,5,4),(2,12246,0,0,5,4),(2,12247,0,0,5,4),(2,12248,0,0,5,4),(2,12249,0,0,5,4),(2,12250,0,0,5,4),(2,12251,0,0,5,4),(2,12252,0,0,5,4),(2,12253,0,0,5,4),(2,12254,0,0,5,4),(2,12414,0,0,5,4),(2,12423,0,0,5,4),(2,12503,0,0,5,4),(2,12535,0,0,5,4),(2,12618,0,0,5,4),(2,12619,0,0,5,4),(2,12627,0,0,5,4),(2,12644,0,0,5,4),(2,12658,0,0,5,4),(2,12659,0,0,5,4),(2,12660,0,0,5,4),(2,12661,0,0,5,4),(2,12662,0,0,5,4),(2,12663,0,0,5,4),(2,12664,0,0,5,4),(2,12837,0,0,5,4),(2,12882,0,0,5,4),(2,12883,0,0,5,4),(2,12884,0,0,5,4),(2,12965,0,0,5,4),(2,12966,0,0,5,4),(2,12968,0,0,5,4),(2,13160,0,0,5,4),(2,13274,0,0,5,4),(2,13348,0,0,5,4),(2,13371,0,0,5,4),(2,13668,0,0,5,4),(2,13670,0,0,5,4),(2,13827,0,0,5,4),(2,13883,0,0,5,4),(2,13884,0,0,5,4),(2,13885,0,0,5,4),(2,13887,0,0,5,4),(2,13889,0,0,5,4),(2,13924,0,0,5,4),(2,14080,0,0,5,4),(2,14081,0,0,5,4),(2,14370,0,0,5,4),(2,14471,0,0,5,4),(2,14473,0,0,5,4),(2,14474,0,0,5,4),(2,14476,0,0,5,4),(2,14501,0,0,5,4),(2,14514,0,0,5,4),(2,14530,0,0,5,4),(2,14538,0,0,5,4),(2,14722,0,0,5,4),(2,14727,0,0,5,4),(2,14728,0,0,5,4),(2,14730,0,0,5,4),(2,14731,0,0,5,4),(2,14732,0,0,5,4),(2,14867,0,0,5,4),(2,14934,0,0,5,4),(2,14955,0,0,5,4),(2,15043,0,0,5,4),(2,15063,0,0,5,4),(2,15082,0,0,5,4),(2,15133,0,0,5,4),(2,15228,0,0,5,4),(2,15236,0,0,5,4),(2,15237,0,0,5,4),(2,15238,0,0,5,4),(2,15239,0,0,5,4),(2,15240,0,0,5,4),(2,15241,0,0,5,4),(2,15310,0,0,5,4),(2,15355,0,0,5,4),(2,15362,0,0,5,4),(2,15363,0,0,5,4),(2,15366,0,0,5,4),(2,15368,0,0,5,4),(2,15382,0,0,5,4),(2,15499,0,0,5,4),(2,15544,0,0,5,4),(2,15595,0,0,5,4),(2,15596,0,0,5,4),(2,15597,0,0,5,4),(2,15598,0,0,5,4),(2,15669,0,0,5,4),(2,15671,0,0,5,4),(2,15672,0,0,5,4),(2,15683,0,0,5,4),(2,15684,0,0,5,4),(2,15746,0,0,5,4),(2,15786,0,0,5,4),(2,15787,0,0,5,4),(2,15838,0,0,5,4),(2,15839,0,0,5,4),(2,15840,0,0,5,4),(2,15841,0,0,5,4),(2,15842,0,0,5,4),(2,15843,0,0,5,4),(2,15844,0,0,5,4),(2,15876,0,0,5,4),(2,15877,0,0,5,4),(2,15878,0,0,5,4),(2,15880,0,0,5,4),(2,15881,0,0,5,4),(2,15885,0,0,5,4),(2,15886,0,0,5,4),(2,15903,0,0,5,4),(2,15905,0,0,5,4),(2,15928,0,0,5,4),(2,15929,0,0,5,4),(2,15930,0,0,5,4),(2,15931,0,0,5,4),(2,15956,0,0,5,4),(2,15957,0,0,5,4),(2,15958,0,0,5,4),(2,15959,0,0,5,4),(2,15960,0,0,5,4),(2,15961,0,0,5,4),(2,15967,0,0,5,4),(2,15968,0,0,5,4),(2,15969,0,0,5,4),(2,15971,0,0,5,4),(2,15978,0,0,5,4),(2,15979,0,0,5,4),(2,15980,0,0,5,4),(2,15995,0,0,5,4),(2,16010,0,0,5,4),(2,16196,0,0,5,4),(2,16255,0,0,5,4),(2,16256,0,0,5,4),(2,16257,0,0,5,4),(2,16270,0,0,5,4),(2,16302,0,0,5,4),(2,16303,0,0,5,4),(2,16308,0,0,5,4),(2,16338,0,0,5,4),(2,16356,0,0,5,4),(2,16357,0,0,5,4),(2,16358,0,0,5,4),(2,16451,0,0,5,4),(2,16452,0,0,5,4),(2,16453,0,0,5,4),(2,16458,0,0,5,4),(2,16779,0,0,5,4),(2,16782,0,0,5,4),(2,17041,0,0,5,4),(2,17043,0,0,5,4),(2,17044,0,0,5,4),(2,17230,0,0,5,4),(2,17405,0,0,5,4),(2,17406,0,0,5,4),(2,17407,0,0,5,4),(2,17408,0,0,5,4),(2,17409,0,0,5,4),(2,17410,0,0,5,4),(2,17411,0,0,5,4),(2,17412,0,0,5,4),(2,17413,0,0,5,4),(2,17414,0,0,5,4),(2,17415,0,0,5,4),(2,17416,0,0,5,4),(2,17417,0,0,5,4),(2,17418,0,0,5,4),(2,17419,0,0,5,4),(2,17420,0,0,5,4),(2,17421,0,0,5,4),(2,17422,0,0,5,4),(2,17423,0,0,5,4),(2,17424,0,0,5,4),(2,17425,0,0,5,4),(2,17426,0,0,5,4),(2,17427,0,0,5,4),(2,17428,0,0,5,4),(2,17429,0,0,5,4),(2,17430,0,0,5,4),(2,17431,0,0,5,4),(2,17432,0,0,5,4),(2,17433,0,0,5,4),(2,17434,0,0,5,4),(2,17435,0,0,5,4),(2,17436,0,0,5,4),(2,17659,0,0,5,4),(2,17661,0,0,5,4),(2,17663,0,0,5,4),(2,17732,0,0,5,4),(2,17733,0,0,5,4),(2,17785,0,0,5,4),(2,18160,0,0,5,4),(2,18715,0,0,5,4),(2,18906,0,0,5,4),(2,19084,0,0,5,4),(2,19085,0,0,5,4),(2,19258,0,0,5,4),(2,19259,0,0,5,4),(2,19395,0,0,5,4),(2,19487,0,0,5,4),(2,19488,0,0,5,4),(2,19510,0,0,5,4),(2,19511,0,0,5,4),(2,19512,0,0,5,4),(2,19515,0,0,5,4),(2,19516,0,0,5,4),(2,19517,0,0,5,4),(2,19518,0,0,5,4),(2,19519,0,0,5,4),(2,19520,0,0,5,4),(2,19549,0,0,5,4),(2,19550,0,0,5,4),(2,19552,0,0,5,4),(2,19556,0,0,5,4),(2,19557,0,0,5,4),(2,19558,0,0,5,4),(2,19560,0,0,5,4),(2,19561,0,0,5,4),(2,19562,0,0,5,4),(2,19563,0,0,5,4),(2,19564,0,0,5,4),(2,19565,0,0,5,4),(2,19566,0,0,5,4),(2,19568,0,0,5,4),(2,19570,0,0,5,4),(2,19571,0,0,5,4),(2,19572,0,0,5,4),(2,19574,0,0,5,4),(2,19575,0,0,5,4),(2,19576,0,0,5,4),(2,19577,0,0,5,4),(2,19578,0,0,5,4),(2,19579,0,0,5,4),(2,19581,0,0,5,4),(10,477,0,1,5,4),(10,478,0,1,5,4),(10,479,0,1,5,4),(10,696,0,1,5,4),(10,697,0,1,5,4),(10,739,0,1,5,4),(10,860,0,1,5,4),(10,966,0,1,5,4),(10,971,0,1,5,4),(10,998,0,1,5,4),(10,1001,0,1,5,4),(10,1002,0,1,5,4),(10,1003,0,1,5,4),(10,1005,0,1,5,4),(10,1006,0,1,5,4),(10,1007,0,1,5,4),(10,1008,0,1,5,4),(10,1011,0,1,5,4),(10,1012,0,1,5,4),(10,1014,0,1,5,4),(10,1020,0,1,5,4),(10,1022,0,1,5,4),(10,1024,0,1,5,4),(10,1029,0,1,5,4),(10,1030,0,1,5,4),(10,1127,0,1,5,4),(10,1134,0,1,5,4),(10,1135,0,1,5,4),(10,1136,0,1,5,4),(10,1421,0,1,5,4),(10,1429,0,1,5,4),(10,1430,0,1,5,4),(10,1431,0,1,5,4),(10,1432,0,1,5,4),(10,1433,0,1,5,4),(10,1437,0,1,5,4),(10,1470,0,1,5,4),(10,1471,0,1,5,4),(10,1472,0,1,5,4),(10,1473,0,1,5,4),(10,1616,0,1,5,4),(10,1617,0,1,5,4),(10,1622,0,1,5,4),(10,1623,0,1,5,4),(10,1626,0,1,5,4),(10,1651,0,1,5,4),(10,1667,0,1,5,4),(10,1668,0,1,5,4),(10,1669,0,1,5,4),(10,1670,0,1,5,4),(10,1671,0,1,5,4),(10,1672,0,1,5,4),(10,1675,0,1,5,4),(10,1678,0,1,5,4),(10,1679,0,1,5,4),(10,1680,0,1,5,4),(10,1681,0,1,5,4),(10,1682,0,1,5,4),(10,1683,0,1,5,4),(10,1684,0,1,5,4),(10,1685,0,1,5,4),(10,1686,0,1,5,4),(10,1687,0,1,5,4),(10,1688,0,1,5,4),(10,1689,0,1,5,4),(10,1690,0,1,5,4),(10,1691,0,1,5,4),(10,1692,0,1,5,4),(10,1693,0,1,5,4),(10,1694,0,1,5,4),(10,1695,0,1,5,4),(10,1696,0,1,5,4),(10,1697,0,1,5,4),(10,1699,0,1,5,4),(10,1700,0,1,5,4),(10,1702,0,1,5,4),(10,1703,0,1,5,4),(10,1708,0,1,5,4),(10,1709,0,1,5,4),(10,1710,0,1,5,4),(10,1711,0,1,5,4),(10,1712,0,1,5,4),(10,1714,0,1,5,4),(10,1715,0,1,5,4),(10,1716,0,1,5,4),(10,1717,0,1,5,4),(10,1718,0,1,5,4),(10,1719,0,1,5,4),(10,1720,0,1,5,4),(10,1721,0,1,5,4),(10,1734,0,1,5,4),(10,1735,0,1,5,4),(10,1849,0,1,5,4),(10,1851,0,1,5,4),(10,1852,0,1,5,4),(10,1853,0,1,5,4),(10,1863,0,1,5,4),(10,1871,0,1,5,4),(10,1872,0,1,5,4),(10,1893,0,1,5,4),(10,1919,0,1,5,4),(10,1920,0,1,5,4),(10,1937,0,1,5,4),(10,1938,0,1,5,4),(10,1940,0,1,5,4),(10,1942,0,1,5,4),(10,1943,0,1,5,4),(10,1944,0,1,5,4),(10,1945,0,1,5,4),(10,1946,0,1,5,4),(10,2000,0,1,5,4),(10,2001,0,1,5,4),(10,2002,0,1,5,4),(10,2003,0,1,5,4),(10,2004,0,1,5,4),(10,2005,0,1,5,4),(10,2006,0,1,5,4),(10,2007,0,1,5,4),(10,2008,0,1,5,4),(10,2011,0,1,5,4),(10,2015,0,1,5,4),(10,2016,0,1,5,4),(10,2017,0,1,5,4),(10,2019,0,1,5,4),(10,2020,0,1,5,4),(10,2021,0,1,5,4),(10,2022,0,1,5,4),(10,2023,0,1,5,4),(10,2024,0,1,5,4),(10,2025,0,1,5,4),(10,2026,0,1,5,4),(10,2027,0,1,5,4),(10,2029,0,1,5,4),(10,2030,0,1,5,4),(10,2031,0,1,5,4),(10,2032,0,1,5,4),(10,2033,0,1,5,4),(10,2034,0,1,5,4),(10,2035,0,1,5,4),(10,2036,0,1,5,4),(10,2037,0,1,5,4),(10,2039,0,1,5,4),(10,2040,0,1,5,4),(10,2041,0,1,5,4),(10,2042,0,1,5,4),(10,2043,0,1,5,4),(10,2044,0,1,5,4),(10,2045,0,1,5,4),(10,2046,0,1,5,4),(10,2047,0,1,5,4),(10,2048,0,1,5,4),(10,2049,0,1,5,4),(10,2051,0,1,5,4),(10,2052,0,1,5,4),(10,2053,0,1,5,4),(10,2054,0,1,5,4),(10,2055,0,1,5,4),(10,2057,0,1,5,4),(10,2058,0,1,5,4),(10,2059,0,1,5,4),(10,2060,0,1,5,4),(10,2069,0,1,5,4),(10,2073,0,1,5,4),(10,2074,0,1,5,4),(10,2075,0,1,5,4),(10,2076,0,1,5,4),(10,2077,0,1,5,4),(10,2078,0,1,5,4),(10,2079,0,1,5,4),(10,2080,0,1,5,4),(10,2084,0,1,5,4),(10,2085,0,1,5,4),(10,2088,0,1,5,4),(10,2089,0,1,5,4),(10,2090,0,1,5,4),(10,2092,0,1,5,4),(10,2093,0,1,5,4),(10,2096,0,1,5,4),(10,2097,0,1,5,4),(10,2098,0,1,5,4),(10,2101,0,1,5,4),(10,2102,0,1,5,4),(10,2103,0,1,5,4),(10,2104,0,1,5,4),(10,2105,0,1,5,4),(10,2106,0,1,5,4),(10,2107,0,1,5,4),(10,2233,0,1,5,4),(10,2529,0,1,5,4),(10,2530,0,1,5,4),(10,2531,0,1,5,4),(10,2532,0,1,5,4),(10,2535,0,1,5,4),(10,2536,0,1,5,4),(10,2537,0,1,5,4),(10,2538,0,1,5,4),(10,2539,0,1,5,4),(10,2540,0,1,5,4),(10,2601,0,1,5,4),(10,2602,0,1,5,4),(10,2603,0,1,5,4),(10,2604,0,1,5,4),(10,2605,0,1,5,4),(10,2611,0,1,5,4),(10,2612,0,1,5,4),(10,2621,0,1,5,4),(10,2622,0,1,5,4),(10,2623,0,1,5,4),(10,2624,0,1,5,4),(10,2625,0,1,5,4),(10,2626,0,1,5,4),(10,2627,0,1,5,4),(10,2631,0,1,5,4),(10,2632,0,1,5,4),(10,2633,0,1,5,4),(10,2638,0,1,5,4),(10,2640,0,1,5,4),(10,2642,0,1,5,4),(10,2643,0,1,5,4),(10,2647,0,1,5,4),(10,2649,0,1,5,4),(10,2650,0,1,5,4),(10,2665,0,1,5,4),(10,2666,0,1,5,4),(10,2667,0,1,5,4),(10,2668,0,1,5,4),(10,2669,0,1,5,4),(10,2674,0,1,5,4),(10,2675,0,1,5,4),(10,2764,0,1,5,4),(10,2886,0,1,5,4),(10,2887,0,1,5,4),(10,2923,0,1,5,4),(10,2935,0,1,5,4),(10,2936,0,1,5,4),(10,2937,0,1,5,4),(10,3035,0,1,5,4),(10,3153,0,1,5,4),(10,3154,0,1,5,4),(10,3476,0,1,5,4),(10,3689,0,1,5,4),(10,3828,0,1,5,4),(10,3829,0,1,5,4),(10,3836,0,1,5,4),(10,3837,0,1,5,4),(10,3838,0,1,5,4),(10,3839,0,1,5,4),(10,3840,0,1,5,4),(10,3841,0,1,5,4),(10,3842,0,1,5,4),(10,3843,0,1,5,4),(10,3844,0,1,5,4),(10,3846,0,1,5,4),(10,3847,0,1,5,4),(10,3848,0,1,5,4),(10,3849,0,1,5,4),(10,3850,0,1,5,4),(10,3851,0,1,5,4),(10,3852,0,1,5,4),(10,3853,0,1,5,4),(10,3854,0,1,5,4),(10,3855,0,1,5,4),(10,3856,0,1,5,4),(10,3857,0,1,5,4),(10,3858,0,1,5,4),(10,3859,0,1,5,4),(10,3863,0,1,5,4),(10,3865,0,1,5,4),(10,3879,0,1,5,4),(10,3880,0,1,5,4),(10,3881,0,1,5,4),(10,3886,0,1,5,4),(10,3888,0,1,5,4),(10,3889,0,1,5,4),(10,3890,0,1,5,4),(10,3891,0,1,5,4),(10,4056,0,1,5,4),(10,4058,0,1,5,4),(10,4059,0,1,5,4),(10,4265,0,1,5,4),(10,4315,0,1,5,4),(10,4316,0,1,5,4),(10,4317,0,1,5,4),(10,4318,0,1,5,4),(10,4319,0,1,5,4),(10,4321,0,1,5,4),(10,4322,0,1,5,4),(10,4323,0,1,5,4),(10,4546,0,1,5,4),(10,4628,0,1,5,4),(10,4643,0,1,5,4),(10,4645,0,1,5,4),(10,4749,0,1,5,4),(10,4750,0,1,5,4),(10,4751,0,1,5,4),(10,4752,0,1,5,4),(10,4762,0,1,5,4),(10,4763,0,1,5,4),(10,7740,0,1,5,4),(10,7741,0,1,5,4),(10,7742,0,1,5,4),(10,7743,0,1,5,4),(10,7744,0,1,5,4),(10,7745,0,1,5,4),(10,7746,0,1,5,4),(10,7747,0,1,5,4),(10,7748,0,1,5,4),(10,7749,0,1,5,4),(10,7750,0,1,5,4),(10,7771,0,1,5,4),(10,7846,0,1,5,4),(10,9709,0,1,5,4),(10,9723,0,1,5,4),(10,9735,0,1,5,4),(10,9736,0,1,5,4),(10,9739,0,1,5,4),(10,9743,0,1,5,4),(10,9745,0,1,5,4),(10,9747,0,1,5,4),(10,9763,0,1,5,4),(10,9834,0,1,5,4),(10,9897,0,1,5,4),(10,9920,0,1,5,4),(10,9922,0,1,5,4),(10,9923,0,1,5,4),(10,9929,0,1,5,4),(10,9941,0,1,5,4),(10,10000,0,1,5,4),(10,10001,0,1,5,4),(10,10002,0,1,5,4),(10,10004,0,1,5,4),(10,10005,0,1,5,4),(10,10006,0,1,5,4),(10,10007,0,1,5,4),(10,10008,0,1,5,4),(10,10010,0,1,5,4),(10,10013,0,1,5,4),(10,10014,0,1,5,4),(10,10015,0,1,5,4),(10,10016,0,1,5,4),(10,10018,0,1,5,4),(10,10019,0,1,5,4),(10,10020,0,1,5,4),(10,10021,0,1,5,4),(10,10022,0,1,5,4),(10,10023,0,1,5,4),(10,10024,0,1,5,4),(10,10029,0,1,5,4),(10,10035,0,1,5,4),(10,10036,0,1,5,4),(10,10037,0,1,5,4),(10,10040,0,1,5,4),(10,10041,0,1,5,4),(10,10043,0,1,5,4),(10,10044,0,1,5,4),(10,10047,0,1,5,4),(10,10068,0,1,5,4),(10,10156,0,1,5,4),(10,10157,0,1,5,4),(10,10237,0,1,5,4),(10,10432,0,1,5,4),(10,10434,0,1,5,4),(10,10435,0,1,5,4),(10,10584,0,1,5,4),(10,10681,0,1,5,4),(10,10683,0,1,5,4),(10,10891,0,1,5,4),(10,10905,0,1,5,4),(10,11057,0,1,5,4),(10,11076,0,1,5,4),(10,11155,0,1,5,4),(10,11233,0,1,5,4),(10,11270,0,1,5,4),(10,11407,0,1,5,4),(10,11511,0,1,5,4),(10,11520,0,1,5,4),(10,11571,0,1,5,4),(10,11630,0,1,5,4),(10,11636,0,1,5,4),(10,11640,0,1,5,4),(10,11641,0,1,5,4),(10,11644,0,1,5,4),(10,11651,0,1,5,4),(10,11653,0,1,5,4),(10,11686,0,1,5,4),(10,11787,0,1,5,4),(10,12227,0,1,5,4),(10,12239,0,1,5,4),(10,12240,0,1,5,4),(10,12241,0,1,5,4),(10,12242,0,1,5,4),(10,12243,0,1,5,4),(10,12244,0,1,5,4),(10,12245,0,1,5,4),(10,12246,0,1,5,4),(10,12247,0,1,5,4),(10,12248,0,1,5,4),(10,12249,0,1,5,4),(10,12250,0,1,5,4),(10,12251,0,1,5,4),(10,12252,0,1,5,4),(10,12253,0,1,5,4),(10,12254,0,1,5,4),(10,12414,0,1,5,4),(10,12423,0,1,5,4),(10,12503,0,1,5,4),(10,12535,0,1,5,4),(10,12618,0,1,5,4),(10,12619,0,1,5,4),(10,12627,0,1,5,4),(10,12644,0,1,5,4),(10,12658,0,1,5,4),(10,12659,0,1,5,4),(10,12660,0,1,5,4),(10,12661,0,1,5,4),(10,12662,0,1,5,4),(10,12663,0,1,5,4),(10,12664,0,1,5,4),(10,12837,0,1,5,4),(10,12882,0,1,5,4),(10,12883,0,1,5,4),(10,12884,0,1,5,4),(10,12965,0,1,5,4),(10,12966,0,1,5,4),(10,12968,0,1,5,4),(10,13160,0,1,5,4),(10,13274,0,1,5,4),(10,13348,0,1,5,4),(10,13371,0,1,5,4),(10,13668,0,1,5,4),(10,13670,0,1,5,4),(10,13827,0,1,5,4),(10,13883,0,1,5,4),(10,13884,0,1,5,4),(10,13885,0,1,5,4),(10,13887,0,1,5,4),(10,13889,0,1,5,4),(10,13924,0,1,5,4),(10,14080,0,1,5,4),(10,14081,0,1,5,4),(10,14370,0,1,5,4),(10,14471,0,1,5,4),(10,14473,0,1,5,4),(10,14474,0,1,5,4),(10,14476,0,1,5,4),(10,14501,0,1,5,4),(10,14514,0,1,5,4),(10,14530,0,1,5,4),(10,14538,0,1,5,4),(10,14722,0,1,5,4),(10,14727,0,1,5,4),(10,14728,0,1,5,4),(10,14730,0,1,5,4),(10,14731,0,1,5,4),(10,14732,0,1,5,4),(10,14867,0,1,5,4),(10,14934,0,1,5,4),(10,14955,0,1,5,4),(10,15043,0,1,5,4),(10,15063,0,1,5,4),(10,15082,0,1,5,4),(10,15133,0,1,5,4),(10,15228,0,1,5,4),(10,15236,0,1,5,4),(10,15237,0,1,5,4),(10,15238,0,1,5,4),(10,15239,0,1,5,4),(10,15240,0,1,5,4),(10,15241,0,1,5,4),(10,15310,0,1,5,4),(10,15355,0,1,5,4),(10,15362,0,1,5,4),(10,15363,0,1,5,4),(10,15366,0,1,5,4),(10,15368,0,1,5,4),(10,15382,0,1,5,4),(10,15499,0,1,5,4),(10,15544,0,1,5,4),(10,15595,0,1,5,4),(10,15596,0,1,5,4),(10,15597,0,1,5,4),(10,15598,0,1,5,4),(10,15669,0,1,5,4),(10,15671,0,1,5,4),(10,15672,0,1,5,4),(10,15683,0,1,5,4),(10,15684,0,1,5,4),(10,15746,0,1,5,4),(10,15786,0,1,5,4),(10,15787,0,1,5,4),(10,15838,0,1,5,4),(10,15839,0,1,5,4),(10,15840,0,1,5,4),(10,15841,0,1,5,4),(10,15842,0,1,5,4),(10,15843,0,1,5,4),(10,15844,0,1,5,4),(10,15876,0,1,5,4),(10,15877,0,1,5,4),(10,15878,0,1,5,4),(10,15880,0,1,5,4),(10,15881,0,1,5,4),(10,15885,0,1,5,4),(10,15886,0,1,5,4),(10,15903,0,1,5,4),(10,15905,0,1,5,4),(10,15928,0,1,5,4),(10,15929,0,1,5,4),(10,15930,0,1,5,4),(10,15931,0,1,5,4),(10,15956,0,1,5,4),(10,15957,0,1,5,4),(10,15958,0,1,5,4),(10,15959,0,1,5,4),(10,15960,0,1,5,4),(10,15961,0,1,5,4),(10,15967,0,1,5,4),(10,15968,0,1,5,4),(10,15969,0,1,5,4),(10,15971,0,1,5,4),(10,15978,0,1,5,4),(10,15979,0,1,5,4),(10,15980,0,1,5,4),(10,15995,0,1,5,4),(10,16010,0,1,5,4),(10,16196,0,1,5,4),(10,16255,0,1,5,4),(10,16256,0,1,5,4),(10,16257,0,1,5,4),(10,16270,0,1,5,4),(10,16302,0,1,5,4),(10,16303,0,1,5,4),(10,16308,0,1,5,4),(10,16338,0,1,5,4),(10,16356,0,1,5,4),(10,16357,0,1,5,4),(10,16358,0,1,5,4),(10,16451,0,1,5,4),(10,16452,0,1,5,4),(10,16453,0,1,5,4),(10,16458,0,1,5,4),(10,16779,0,1,5,4),(10,16782,0,1,5,4),(10,17041,0,1,5,4),(10,17043,0,1,5,4),(10,17044,0,1,5,4),(10,17230,0,1,5,4),(10,17405,0,1,5,4),(10,17406,0,1,5,4),(10,17407,0,1,5,4),(10,17408,0,1,5,4),(10,17409,0,1,5,4),(10,17410,0,1,5,4),(10,17411,0,1,5,4),(10,17412,0,1,5,4),(10,17413,0,1,5,4),(10,17414,0,1,5,4),(10,17415,0,1,5,4),(10,17416,0,1,5,4),(10,17417,0,1,5,4),(10,17418,0,1,5,4),(10,17419,0,1,5,4),(10,17420,0,1,5,4),(10,17421,0,1,5,4),(10,17422,0,1,5,4),(10,17423,0,1,5,4),(10,17424,0,1,5,4),(10,17425,0,1,5,4),(10,17426,0,1,5,4),(10,17427,0,1,5,4),(10,17428,0,1,5,4),(10,17429,0,1,5,4),(10,17430,0,1,5,4),(10,17431,0,1,5,4),(10,17432,0,1,5,4),(10,17433,0,1,5,4),(10,17434,0,1,5,4),(10,17435,0,1,5,4),(10,17436,0,1,5,4),(10,17659,0,1,5,4),(10,17661,0,1,5,4),(10,17663,0,1,5,4),(10,17732,0,1,5,4),(10,17733,0,1,5,4),(10,17785,0,1,5,4),(10,18160,0,1,5,4),(10,18715,0,1,5,4),(10,18906,0,1,5,4),(10,19084,0,1,5,4),(10,19085,0,1,5,4),(10,19258,0,1,5,4),(10,19259,0,1,5,4),(10,19395,0,1,5,4),(10,19487,0,1,5,4),(10,19488,0,1,5,4),(10,19510,0,1,5,4),(10,19511,0,1,5,4),(10,19512,0,1,5,4),(10,19515,0,1,5,4),(10,19516,0,1,5,4),(10,19517,0,1,5,4),(10,19518,0,1,5,4),(10,19519,0,1,5,4),(10,19520,0,1,5,4),(10,19549,0,1,5,4),(10,19550,0,1,5,4),(10,19552,0,1,5,4),(10,19556,0,1,5,4),(10,19557,0,1,5,4),(10,19561,0,1,5,4),(10,19563,0,1,5,4),(10,19564,0,1,5,4),(10,19565,0,1,5,4),(10,19566,0,1,5,4),(10,19570,0,1,5,4),(10,19571,0,1,5,4),(10,19576,0,1,5,4),(10,19579,0,1,5,4);
/*!40000 ALTER TABLE `catalog_category_product_index_store5` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index_store5_replica`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store5_replica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_product_index_store5_replica` (
  `category_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int(11) DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint(5) unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `CAT_CTGR_PRD_IDX_STORE5_PRD_ID_STORE_ID_CTGR_ID_VISIBILITY` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_D66B6557126C2DE627A049511C72BE10` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Product Index Store5';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index_store5_replica`
--

LOCK TABLES `catalog_category_product_index_store5_replica` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index_store5_replica` DISABLE KEYS */;
INSERT INTO `catalog_category_product_index_store5_replica` VALUES (2,477,0,0,5,4),(2,478,0,0,5,4),(2,479,0,0,5,4),(2,696,0,0,5,4),(2,697,0,0,5,4),(2,739,0,0,5,4),(2,860,0,0,5,4),(2,966,0,0,5,4),(2,971,0,0,5,4),(2,998,0,0,5,4),(2,1001,0,0,5,4),(2,1002,0,0,5,4),(2,1003,0,0,5,4),(2,1005,0,0,5,4),(2,1006,0,0,5,4),(2,1007,0,0,5,4),(2,1008,0,0,5,4),(2,1011,0,0,5,4),(2,1012,0,0,5,4),(2,1014,0,0,5,4),(2,1020,0,0,5,4),(2,1022,0,0,5,4),(2,1024,0,0,5,4),(2,1029,0,0,5,4),(2,1030,0,0,5,4),(2,1127,0,0,5,4),(2,1134,0,0,5,4),(2,1135,0,0,5,4),(2,1136,0,0,5,4),(2,1421,0,0,5,4),(2,1429,0,0,5,4),(2,1430,0,0,5,4),(2,1431,0,0,5,4),(2,1432,0,0,5,4),(2,1433,0,0,5,4),(2,1437,0,0,5,4),(2,1470,0,0,5,4),(2,1471,0,0,5,4),(2,1472,0,0,5,4),(2,1473,0,0,5,4),(2,1616,0,0,5,4),(2,1617,0,0,5,4),(2,1622,0,0,5,4),(2,1623,0,0,5,4),(2,1626,0,0,5,4),(2,1651,0,0,5,4),(2,1667,0,0,5,4),(2,1668,0,0,5,4),(2,1669,0,0,5,4),(2,1670,0,0,5,4),(2,1671,0,0,5,4),(2,1672,0,0,5,4),(2,1675,0,0,5,4),(2,1678,0,0,5,4),(2,1679,0,0,5,4),(2,1680,0,0,5,4),(2,1681,0,0,5,4),(2,1682,0,0,5,4),(2,1683,0,0,5,4),(2,1684,0,0,5,4),(2,1685,0,0,5,4),(2,1686,0,0,5,4),(2,1687,0,0,5,4),(2,1688,0,0,5,4),(2,1689,0,0,5,4),(2,1690,0,0,5,4),(2,1691,0,0,5,4),(2,1692,0,0,5,4),(2,1693,0,0,5,4),(2,1694,0,0,5,4),(2,1695,0,0,5,4),(2,1696,0,0,5,4),(2,1697,0,0,5,4),(2,1699,0,0,5,4),(2,1700,0,0,5,4),(2,1702,0,0,5,4),(2,1703,0,0,5,4),(2,1708,0,0,5,4),(2,1709,0,0,5,4),(2,1710,0,0,5,4),(2,1711,0,0,5,4),(2,1712,0,0,5,4),(2,1714,0,0,5,4),(2,1715,0,0,5,4),(2,1716,0,0,5,4),(2,1717,0,0,5,4),(2,1718,0,0,5,4),(2,1719,0,0,5,4),(2,1720,0,0,5,4),(2,1721,0,0,5,4),(2,1734,0,0,5,4),(2,1735,0,0,5,4),(2,1849,0,0,5,4),(2,1851,0,0,5,4),(2,1852,0,0,5,4),(2,1853,0,0,5,4),(2,1863,0,0,5,4),(2,1871,0,0,5,4),(2,1872,0,0,5,4),(2,1893,0,0,5,4),(2,1919,0,0,5,4),(2,1920,0,0,5,4),(2,1937,0,0,5,4),(2,1938,0,0,5,4),(2,1940,0,0,5,4),(2,1942,0,0,5,4),(2,1943,0,0,5,4),(2,1944,0,0,5,4),(2,1945,0,0,5,4),(2,1946,0,0,5,4),(2,2000,0,0,5,4),(2,2001,0,0,5,4),(2,2002,0,0,5,4),(2,2003,0,0,5,4),(2,2004,0,0,5,4),(2,2005,0,0,5,4),(2,2006,0,0,5,4),(2,2007,0,0,5,4),(2,2008,0,0,5,4),(2,2011,0,0,5,4),(2,2015,0,0,5,4),(2,2016,0,0,5,4),(2,2017,0,0,5,4),(2,2019,0,0,5,4),(2,2020,0,0,5,4),(2,2021,0,0,5,4),(2,2022,0,0,5,4),(2,2023,0,0,5,4),(2,2024,0,0,5,4),(2,2025,0,0,5,4),(2,2026,0,0,5,4),(2,2027,0,0,5,4),(2,2029,0,0,5,4),(2,2030,0,0,5,4),(2,2031,0,0,5,4),(2,2032,0,0,5,4),(2,2033,0,0,5,4),(2,2034,0,0,5,4),(2,2035,0,0,5,4),(2,2036,0,0,5,4),(2,2037,0,0,5,4),(2,2039,0,0,5,4),(2,2040,0,0,5,4),(2,2041,0,0,5,4),(2,2042,0,0,5,4),(2,2043,0,0,5,4),(2,2044,0,0,5,4),(2,2045,0,0,5,4),(2,2046,0,0,5,4),(2,2047,0,0,5,4),(2,2048,0,0,5,4),(2,2049,0,0,5,4),(2,2051,0,0,5,4),(2,2052,0,0,5,4),(2,2053,0,0,5,4),(2,2054,0,0,5,4),(2,2055,0,0,5,4),(2,2057,0,0,5,4),(2,2058,0,0,5,4),(2,2059,0,0,5,4),(2,2060,0,0,5,4),(2,2069,0,0,5,4),(2,2073,0,0,5,4),(2,2074,0,0,5,4),(2,2075,0,0,5,4),(2,2076,0,0,5,4),(2,2077,0,0,5,4),(2,2078,0,0,5,4),(2,2079,0,0,5,4),(2,2080,0,0,5,4),(2,2084,0,0,5,4),(2,2085,0,0,5,4),(2,2088,0,0,5,4),(2,2089,0,0,5,4),(2,2090,0,0,5,4),(2,2092,0,0,5,4),(2,2093,0,0,5,4),(2,2096,0,0,5,4),(2,2097,0,0,5,4),(2,2098,0,0,5,4),(2,2101,0,0,5,4),(2,2102,0,0,5,4),(2,2103,0,0,5,4),(2,2104,0,0,5,4),(2,2105,0,0,5,4),(2,2106,0,0,5,4),(2,2107,0,0,5,4),(2,2233,0,0,5,4),(2,2529,0,0,5,4),(2,2530,0,0,5,4),(2,2531,0,0,5,4),(2,2532,0,0,5,4),(2,2535,0,0,5,4),(2,2536,0,0,5,4),(2,2537,0,0,5,4),(2,2538,0,0,5,4),(2,2539,0,0,5,4),(2,2540,0,0,5,4),(2,2601,0,0,5,4),(2,2602,0,0,5,4),(2,2603,0,0,5,4),(2,2604,0,0,5,4),(2,2605,0,0,5,4),(2,2611,0,0,5,4),(2,2612,0,0,5,4),(2,2621,0,0,5,4),(2,2622,0,0,5,4),(2,2623,0,0,5,4),(2,2624,0,0,5,4),(2,2625,0,0,5,4),(2,2626,0,0,5,4),(2,2627,0,0,5,4),(2,2631,0,0,5,4),(2,2632,0,0,5,4),(2,2633,0,0,5,4),(2,2638,0,0,5,4),(2,2640,0,0,5,4),(2,2642,0,0,5,4),(2,2643,0,0,5,4),(2,2647,0,0,5,4),(2,2649,0,0,5,4),(2,2650,0,0,5,4),(2,2665,0,0,5,4),(2,2666,0,0,5,4),(2,2667,0,0,5,4),(2,2668,0,0,5,4),(2,2669,0,0,5,4),(2,2674,0,0,5,4),(2,2675,0,0,5,4),(2,2764,0,0,5,4),(2,2886,0,0,5,4),(2,2887,0,0,5,4),(2,2923,0,0,5,4),(2,2935,0,0,5,4),(2,2936,0,0,5,4),(2,2937,0,0,5,4),(2,3035,0,0,5,4),(2,3153,0,0,5,4),(2,3154,0,0,5,4),(2,3476,0,0,5,4),(2,3689,0,0,5,4),(2,3828,0,0,5,4),(2,3829,0,0,5,4),(2,3836,0,0,5,4),(2,3837,0,0,5,4),(2,3838,0,0,5,4),(2,3839,0,0,5,4),(2,3840,0,0,5,4),(2,3841,0,0,5,4),(2,3842,0,0,5,4),(2,3843,0,0,5,4),(2,3844,0,0,5,4),(2,3846,0,0,5,4),(2,3847,0,0,5,4),(2,3848,0,0,5,4),(2,3849,0,0,5,4),(2,3850,0,0,5,4),(2,3851,0,0,5,4),(2,3852,0,0,5,4),(2,3853,0,0,5,4),(2,3854,0,0,5,4),(2,3855,0,0,5,4),(2,3856,0,0,5,4),(2,3857,0,0,5,4),(2,3858,0,0,5,4),(2,3859,0,0,5,4),(2,3863,0,0,5,4),(2,3865,0,0,5,4),(2,3879,0,0,5,4),(2,3880,0,0,5,4),(2,3881,0,0,5,4),(2,3886,0,0,5,4),(2,3888,0,0,5,4),(2,3889,0,0,5,4),(2,3890,0,0,5,4),(2,3891,0,0,5,4),(2,4056,0,0,5,4),(2,4058,0,0,5,4),(2,4059,0,0,5,4),(2,4265,0,0,5,4),(2,4315,0,0,5,4),(2,4316,0,0,5,4),(2,4317,0,0,5,4),(2,4318,0,0,5,4),(2,4319,0,0,5,4),(2,4321,0,0,5,4),(2,4322,0,0,5,4),(2,4323,0,0,5,4),(2,4546,0,0,5,4),(2,4628,0,0,5,4),(2,4643,0,0,5,4),(2,4645,0,0,5,4),(2,4749,0,0,5,4),(2,4750,0,0,5,4),(2,4751,0,0,5,4),(2,4752,0,0,5,4),(2,4762,0,0,5,4),(2,4763,0,0,5,4),(2,7740,0,0,5,4),(2,7741,0,0,5,4),(2,7742,0,0,5,4),(2,7743,0,0,5,4),(2,7744,0,0,5,4),(2,7745,0,0,5,4),(2,7746,0,0,5,4),(2,7747,0,0,5,4),(2,7748,0,0,5,4),(2,7749,0,0,5,4),(2,7750,0,0,5,4),(2,7771,0,0,5,4),(2,7846,0,0,5,4),(2,9709,0,0,5,4),(2,9723,0,0,5,4),(2,9735,0,0,5,4),(2,9736,0,0,5,4),(2,9739,0,0,5,4),(2,9743,0,0,5,4),(2,9745,0,0,5,4),(2,9747,0,0,5,4),(2,9763,0,0,5,4),(2,9834,0,0,5,4),(2,9897,0,0,5,4),(2,9920,0,0,5,4),(2,9922,0,0,5,4),(2,9923,0,0,5,4),(2,9929,0,0,5,4),(2,9941,0,0,5,4),(2,10000,0,0,5,4),(2,10001,0,0,5,4),(2,10002,0,0,5,4),(2,10004,0,0,5,4),(2,10005,0,0,5,4),(2,10006,0,0,5,4),(2,10007,0,0,5,4),(2,10008,0,0,5,4),(2,10010,0,0,5,4),(2,10013,0,0,5,4),(2,10014,0,0,5,4),(2,10015,0,0,5,4),(2,10016,0,0,5,4),(2,10018,0,0,5,4),(2,10019,0,0,5,4),(2,10020,0,0,5,4),(2,10021,0,0,5,4),(2,10022,0,0,5,4),(2,10023,0,0,5,4),(2,10024,0,0,5,4),(2,10029,0,0,5,4),(2,10035,0,0,5,4),(2,10036,0,0,5,4),(2,10037,0,0,5,4),(2,10040,0,0,5,4),(2,10041,0,0,5,4),(2,10043,0,0,5,4),(2,10044,0,0,5,4),(2,10047,0,0,5,4),(2,10068,0,0,5,4),(2,10156,0,0,5,4),(2,10157,0,0,5,4),(2,10237,0,0,5,4),(2,10432,0,0,5,4),(2,10434,0,0,5,4),(2,10435,0,0,5,4),(2,10584,0,0,5,4),(2,10681,0,0,5,4),(2,10683,0,0,5,4),(2,10891,0,0,5,4),(2,10905,0,0,5,4),(2,11057,0,0,5,4),(2,11076,0,0,5,4),(2,11155,0,0,5,4),(2,11233,0,0,5,4),(2,11270,0,0,5,4),(2,11407,0,0,5,4),(2,11511,0,0,5,4),(2,11520,0,0,5,4),(2,11571,0,0,5,4),(2,11630,0,0,5,4),(2,11636,0,0,5,4),(2,11640,0,0,5,4),(2,11641,0,0,5,4),(2,11644,0,0,5,4),(2,11651,0,0,5,4),(2,11653,0,0,5,4),(2,11686,0,0,5,4),(2,11787,0,0,5,4),(2,12227,0,0,5,4),(2,12239,0,0,5,4),(2,12240,0,0,5,4),(2,12241,0,0,5,4),(2,12242,0,0,5,4),(2,12243,0,0,5,4),(2,12244,0,0,5,4),(2,12245,0,0,5,4),(2,12246,0,0,5,4),(2,12247,0,0,5,4),(2,12248,0,0,5,4),(2,12249,0,0,5,4),(2,12250,0,0,5,4),(2,12251,0,0,5,4),(2,12252,0,0,5,4),(2,12253,0,0,5,4),(2,12254,0,0,5,4),(2,12414,0,0,5,4),(2,12423,0,0,5,4),(2,12503,0,0,5,4),(2,12535,0,0,5,4),(2,12618,0,0,5,4),(2,12619,0,0,5,4),(2,12627,0,0,5,4),(2,12644,0,0,5,4),(2,12658,0,0,5,4),(2,12659,0,0,5,4),(2,12660,0,0,5,4),(2,12661,0,0,5,4),(2,12662,0,0,5,4),(2,12663,0,0,5,4),(2,12664,0,0,5,4),(2,12837,0,0,5,4),(2,12882,0,0,5,4),(2,12883,0,0,5,4),(2,12884,0,0,5,4),(2,12965,0,0,5,4),(2,12966,0,0,5,4),(2,12968,0,0,5,4),(2,13160,0,0,5,4),(2,13274,0,0,5,4),(2,13348,0,0,5,4),(2,13371,0,0,5,4),(2,13668,0,0,5,4),(2,13670,0,0,5,4),(2,13827,0,0,5,4),(2,13883,0,0,5,4),(2,13884,0,0,5,4),(2,13885,0,0,5,4),(2,13887,0,0,5,4),(2,13889,0,0,5,4),(2,13924,0,0,5,4),(2,14080,0,0,5,4),(2,14081,0,0,5,4),(2,14370,0,0,5,4),(2,14471,0,0,5,4),(2,14473,0,0,5,4),(2,14474,0,0,5,4),(2,14476,0,0,5,4),(2,14501,0,0,5,4),(2,14514,0,0,5,4),(2,14530,0,0,5,4),(2,14538,0,0,5,4),(2,14722,0,0,5,4),(2,14727,0,0,5,4),(2,14728,0,0,5,4),(2,14730,0,0,5,4),(2,14731,0,0,5,4),(2,14732,0,0,5,4),(2,14867,0,0,5,4),(2,14934,0,0,5,4),(2,14955,0,0,5,4),(2,15043,0,0,5,4),(2,15063,0,0,5,4),(2,15082,0,0,5,4),(2,15133,0,0,5,4),(2,15228,0,0,5,4),(2,15236,0,0,5,4),(2,15237,0,0,5,4),(2,15238,0,0,5,4),(2,15239,0,0,5,4),(2,15240,0,0,5,4),(2,15241,0,0,5,4),(2,15310,0,0,5,4),(2,15355,0,0,5,4),(2,15362,0,0,5,4),(2,15363,0,0,5,4),(2,15366,0,0,5,4),(2,15368,0,0,5,4),(2,15382,0,0,5,4),(2,15499,0,0,5,4),(2,15544,0,0,5,4),(2,15595,0,0,5,4),(2,15596,0,0,5,4),(2,15597,0,0,5,4),(2,15598,0,0,5,4),(2,15669,0,0,5,4),(2,15671,0,0,5,4),(2,15672,0,0,5,4),(2,15683,0,0,5,4),(2,15684,0,0,5,4),(2,15746,0,0,5,4),(2,15786,0,0,5,4),(2,15787,0,0,5,4),(2,15838,0,0,5,4),(2,15839,0,0,5,4),(2,15840,0,0,5,4),(2,15841,0,0,5,4),(2,15842,0,0,5,4),(2,15843,0,0,5,4),(2,15844,0,0,5,4),(2,15876,0,0,5,4),(2,15877,0,0,5,4),(2,15878,0,0,5,4),(2,15880,0,0,5,4),(2,15881,0,0,5,4),(2,15885,0,0,5,4),(2,15886,0,0,5,4),(2,15903,0,0,5,4),(2,15905,0,0,5,4),(2,15928,0,0,5,4),(2,15929,0,0,5,4),(2,15930,0,0,5,4),(2,15931,0,0,5,4),(2,15956,0,0,5,4),(2,15957,0,0,5,4),(2,15958,0,0,5,4),(2,15959,0,0,5,4),(2,15960,0,0,5,4),(2,15961,0,0,5,4),(2,15967,0,0,5,4),(2,15968,0,0,5,4),(2,15969,0,0,5,4),(2,15971,0,0,5,4),(2,15978,0,0,5,4),(2,15979,0,0,5,4),(2,15980,0,0,5,4),(2,15995,0,0,5,4),(2,16010,0,0,5,4),(2,16196,0,0,5,4),(2,16255,0,0,5,4),(2,16256,0,0,5,4),(2,16257,0,0,5,4),(2,16270,0,0,5,4),(2,16302,0,0,5,4),(2,16303,0,0,5,4),(2,16308,0,0,5,4),(2,16338,0,0,5,4),(2,16356,0,0,5,4),(2,16357,0,0,5,4),(2,16358,0,0,5,4),(2,16451,0,0,5,4),(2,16452,0,0,5,4),(2,16453,0,0,5,4),(2,16458,0,0,5,4),(2,16779,0,0,5,4),(2,16782,0,0,5,4),(2,17041,0,0,5,4),(2,17043,0,0,5,4),(2,17044,0,0,5,4),(2,17230,0,0,5,4),(2,17405,0,0,5,4),(2,17406,0,0,5,4),(2,17407,0,0,5,4),(2,17408,0,0,5,4),(2,17409,0,0,5,4),(2,17410,0,0,5,4),(2,17411,0,0,5,4),(2,17412,0,0,5,4),(2,17413,0,0,5,4),(2,17414,0,0,5,4),(2,17415,0,0,5,4),(2,17416,0,0,5,4),(2,17417,0,0,5,4),(2,17418,0,0,5,4),(2,17419,0,0,5,4),(2,17420,0,0,5,4),(2,17421,0,0,5,4),(2,17422,0,0,5,4),(2,17423,0,0,5,4),(2,17424,0,0,5,4),(2,17425,0,0,5,4),(2,17426,0,0,5,4),(2,17427,0,0,5,4),(2,17428,0,0,5,4),(2,17429,0,0,5,4),(2,17430,0,0,5,4),(2,17431,0,0,5,4),(2,17432,0,0,5,4),(2,17433,0,0,5,4),(2,17434,0,0,5,4),(2,17435,0,0,5,4),(2,17436,0,0,5,4),(2,17659,0,0,5,4),(2,17661,0,0,5,4),(2,17663,0,0,5,4),(2,17732,0,0,5,4),(2,17733,0,0,5,4),(2,17785,0,0,5,4),(2,18160,0,0,5,4),(2,18715,0,0,5,4),(2,18906,0,0,5,4),(2,19084,0,0,5,4),(2,19085,0,0,5,4),(2,19258,0,0,5,4),(2,19259,0,0,5,4),(2,19395,0,0,5,4),(2,19487,0,0,5,4),(2,19488,0,0,5,4),(2,19510,0,0,5,4),(2,19511,0,0,5,4),(2,19512,0,0,5,4),(2,19515,0,0,5,4),(2,19516,0,0,5,4),(2,19517,0,0,5,4),(2,19518,0,0,5,4),(2,19519,0,0,5,4),(2,19520,0,0,5,4),(2,19549,0,0,5,4),(2,19550,0,0,5,4),(2,19552,0,0,5,4),(2,19556,0,0,5,4),(2,19557,0,0,5,4),(2,19558,0,0,5,4),(2,19560,0,0,5,4),(2,19561,0,0,5,4),(2,19562,0,0,5,4),(2,19563,0,0,5,4),(2,19564,0,0,5,4),(2,19565,0,0,5,4),(2,19566,0,0,5,4),(2,19568,0,0,5,4),(2,19570,0,0,5,4),(2,19571,0,0,5,4),(2,19572,0,0,5,4),(2,19574,0,0,5,4),(2,19575,0,0,5,4),(2,19576,0,0,5,4),(2,19577,0,0,5,4),(2,19578,0,0,5,4),(2,19579,0,0,5,4),(10,477,0,1,5,4),(10,478,0,1,5,4),(10,479,0,1,5,4),(10,696,0,1,5,4),(10,697,0,1,5,4),(10,739,0,1,5,4),(10,860,0,1,5,4),(10,966,0,1,5,4),(10,971,0,1,5,4),(10,998,0,1,5,4),(10,1001,0,1,5,4),(10,1002,0,1,5,4),(10,1003,0,1,5,4),(10,1005,0,1,5,4),(10,1006,0,1,5,4),(10,1007,0,1,5,4),(10,1008,0,1,5,4),(10,1011,0,1,5,4),(10,1012,0,1,5,4),(10,1014,0,1,5,4),(10,1020,0,1,5,4),(10,1022,0,1,5,4),(10,1024,0,1,5,4),(10,1029,0,1,5,4),(10,1030,0,1,5,4),(10,1127,0,1,5,4),(10,1134,0,1,5,4),(10,1135,0,1,5,4),(10,1136,0,1,5,4),(10,1421,0,1,5,4),(10,1429,0,1,5,4),(10,1430,0,1,5,4),(10,1431,0,1,5,4),(10,1432,0,1,5,4),(10,1433,0,1,5,4),(10,1437,0,1,5,4),(10,1470,0,1,5,4),(10,1471,0,1,5,4),(10,1472,0,1,5,4),(10,1473,0,1,5,4),(10,1616,0,1,5,4),(10,1617,0,1,5,4),(10,1622,0,1,5,4),(10,1623,0,1,5,4),(10,1626,0,1,5,4),(10,1651,0,1,5,4),(10,1667,0,1,5,4),(10,1668,0,1,5,4),(10,1669,0,1,5,4),(10,1670,0,1,5,4),(10,1671,0,1,5,4),(10,1672,0,1,5,4),(10,1675,0,1,5,4),(10,1678,0,1,5,4),(10,1679,0,1,5,4),(10,1680,0,1,5,4),(10,1681,0,1,5,4),(10,1682,0,1,5,4),(10,1683,0,1,5,4),(10,1684,0,1,5,4),(10,1685,0,1,5,4),(10,1686,0,1,5,4),(10,1687,0,1,5,4),(10,1688,0,1,5,4),(10,1689,0,1,5,4),(10,1690,0,1,5,4),(10,1691,0,1,5,4),(10,1692,0,1,5,4),(10,1693,0,1,5,4),(10,1694,0,1,5,4),(10,1695,0,1,5,4),(10,1696,0,1,5,4),(10,1697,0,1,5,4),(10,1699,0,1,5,4),(10,1700,0,1,5,4),(10,1702,0,1,5,4),(10,1703,0,1,5,4),(10,1708,0,1,5,4),(10,1709,0,1,5,4),(10,1710,0,1,5,4),(10,1711,0,1,5,4),(10,1712,0,1,5,4),(10,1714,0,1,5,4),(10,1715,0,1,5,4),(10,1716,0,1,5,4),(10,1717,0,1,5,4),(10,1718,0,1,5,4),(10,1719,0,1,5,4),(10,1720,0,1,5,4),(10,1721,0,1,5,4),(10,1734,0,1,5,4),(10,1735,0,1,5,4),(10,1849,0,1,5,4),(10,1851,0,1,5,4),(10,1852,0,1,5,4),(10,1853,0,1,5,4),(10,1863,0,1,5,4),(10,1871,0,1,5,4),(10,1872,0,1,5,4),(10,1893,0,1,5,4),(10,1919,0,1,5,4),(10,1920,0,1,5,4),(10,1937,0,1,5,4),(10,1938,0,1,5,4),(10,1940,0,1,5,4),(10,1942,0,1,5,4),(10,1943,0,1,5,4),(10,1944,0,1,5,4),(10,1945,0,1,5,4),(10,1946,0,1,5,4),(10,2000,0,1,5,4),(10,2001,0,1,5,4),(10,2002,0,1,5,4),(10,2003,0,1,5,4),(10,2004,0,1,5,4),(10,2005,0,1,5,4),(10,2006,0,1,5,4),(10,2007,0,1,5,4),(10,2008,0,1,5,4),(10,2011,0,1,5,4),(10,2015,0,1,5,4),(10,2016,0,1,5,4),(10,2017,0,1,5,4),(10,2019,0,1,5,4),(10,2020,0,1,5,4),(10,2021,0,1,5,4),(10,2022,0,1,5,4),(10,2023,0,1,5,4),(10,2024,0,1,5,4),(10,2025,0,1,5,4),(10,2026,0,1,5,4),(10,2027,0,1,5,4),(10,2029,0,1,5,4),(10,2030,0,1,5,4),(10,2031,0,1,5,4),(10,2032,0,1,5,4),(10,2033,0,1,5,4),(10,2034,0,1,5,4),(10,2035,0,1,5,4),(10,2036,0,1,5,4),(10,2037,0,1,5,4),(10,2039,0,1,5,4),(10,2040,0,1,5,4),(10,2041,0,1,5,4),(10,2042,0,1,5,4),(10,2043,0,1,5,4),(10,2044,0,1,5,4),(10,2045,0,1,5,4),(10,2046,0,1,5,4),(10,2047,0,1,5,4),(10,2048,0,1,5,4),(10,2049,0,1,5,4),(10,2051,0,1,5,4),(10,2052,0,1,5,4),(10,2053,0,1,5,4),(10,2054,0,1,5,4),(10,2055,0,1,5,4),(10,2057,0,1,5,4),(10,2058,0,1,5,4),(10,2059,0,1,5,4),(10,2060,0,1,5,4),(10,2069,0,1,5,4),(10,2073,0,1,5,4),(10,2074,0,1,5,4),(10,2075,0,1,5,4),(10,2076,0,1,5,4),(10,2077,0,1,5,4),(10,2078,0,1,5,4),(10,2079,0,1,5,4),(10,2080,0,1,5,4),(10,2084,0,1,5,4),(10,2085,0,1,5,4),(10,2088,0,1,5,4),(10,2089,0,1,5,4),(10,2090,0,1,5,4),(10,2092,0,1,5,4),(10,2093,0,1,5,4),(10,2096,0,1,5,4),(10,2097,0,1,5,4),(10,2098,0,1,5,4),(10,2101,0,1,5,4),(10,2102,0,1,5,4),(10,2103,0,1,5,4),(10,2104,0,1,5,4),(10,2105,0,1,5,4),(10,2106,0,1,5,4),(10,2107,0,1,5,4),(10,2233,0,1,5,4),(10,2529,0,1,5,4),(10,2530,0,1,5,4),(10,2531,0,1,5,4),(10,2532,0,1,5,4),(10,2535,0,1,5,4),(10,2536,0,1,5,4),(10,2537,0,1,5,4),(10,2538,0,1,5,4),(10,2539,0,1,5,4),(10,2540,0,1,5,4),(10,2601,0,1,5,4),(10,2602,0,1,5,4),(10,2603,0,1,5,4),(10,2604,0,1,5,4),(10,2605,0,1,5,4),(10,2611,0,1,5,4),(10,2612,0,1,5,4),(10,2621,0,1,5,4),(10,2622,0,1,5,4),(10,2623,0,1,5,4),(10,2624,0,1,5,4),(10,2625,0,1,5,4),(10,2626,0,1,5,4),(10,2627,0,1,5,4),(10,2631,0,1,5,4),(10,2632,0,1,5,4),(10,2633,0,1,5,4),(10,2638,0,1,5,4),(10,2640,0,1,5,4),(10,2642,0,1,5,4),(10,2643,0,1,5,4),(10,2647,0,1,5,4),(10,2649,0,1,5,4),(10,2650,0,1,5,4),(10,2665,0,1,5,4),(10,2666,0,1,5,4),(10,2667,0,1,5,4),(10,2668,0,1,5,4),(10,2669,0,1,5,4),(10,2674,0,1,5,4),(10,2675,0,1,5,4),(10,2764,0,1,5,4),(10,2886,0,1,5,4),(10,2887,0,1,5,4),(10,2923,0,1,5,4),(10,2935,0,1,5,4),(10,2936,0,1,5,4),(10,2937,0,1,5,4),(10,3035,0,1,5,4),(10,3153,0,1,5,4),(10,3154,0,1,5,4),(10,3476,0,1,5,4),(10,3689,0,1,5,4),(10,3828,0,1,5,4),(10,3829,0,1,5,4),(10,3836,0,1,5,4),(10,3837,0,1,5,4),(10,3838,0,1,5,4),(10,3839,0,1,5,4),(10,3840,0,1,5,4),(10,3841,0,1,5,4),(10,3842,0,1,5,4),(10,3843,0,1,5,4),(10,3844,0,1,5,4),(10,3846,0,1,5,4),(10,3847,0,1,5,4),(10,3848,0,1,5,4),(10,3849,0,1,5,4),(10,3850,0,1,5,4),(10,3851,0,1,5,4),(10,3852,0,1,5,4),(10,3853,0,1,5,4),(10,3854,0,1,5,4),(10,3855,0,1,5,4),(10,3856,0,1,5,4),(10,3857,0,1,5,4),(10,3858,0,1,5,4),(10,3859,0,1,5,4),(10,3863,0,1,5,4),(10,3865,0,1,5,4),(10,3879,0,1,5,4),(10,3880,0,1,5,4),(10,3881,0,1,5,4),(10,3886,0,1,5,4),(10,3888,0,1,5,4),(10,3889,0,1,5,4),(10,3890,0,1,5,4),(10,3891,0,1,5,4),(10,4056,0,1,5,4),(10,4058,0,1,5,4),(10,4059,0,1,5,4),(10,4265,0,1,5,4),(10,4315,0,1,5,4),(10,4316,0,1,5,4),(10,4317,0,1,5,4),(10,4318,0,1,5,4),(10,4319,0,1,5,4),(10,4321,0,1,5,4),(10,4322,0,1,5,4),(10,4323,0,1,5,4),(10,4546,0,1,5,4),(10,4628,0,1,5,4),(10,4643,0,1,5,4),(10,4645,0,1,5,4),(10,4749,0,1,5,4),(10,4750,0,1,5,4),(10,4751,0,1,5,4),(10,4752,0,1,5,4),(10,4762,0,1,5,4),(10,4763,0,1,5,4),(10,7740,0,1,5,4),(10,7741,0,1,5,4),(10,7742,0,1,5,4),(10,7743,0,1,5,4),(10,7744,0,1,5,4),(10,7745,0,1,5,4),(10,7746,0,1,5,4),(10,7747,0,1,5,4),(10,7748,0,1,5,4),(10,7749,0,1,5,4),(10,7750,0,1,5,4),(10,7771,0,1,5,4),(10,7846,0,1,5,4),(10,9709,0,1,5,4),(10,9723,0,1,5,4),(10,9735,0,1,5,4),(10,9736,0,1,5,4),(10,9739,0,1,5,4),(10,9743,0,1,5,4),(10,9745,0,1,5,4),(10,9747,0,1,5,4),(10,9763,0,1,5,4),(10,9834,0,1,5,4),(10,9897,0,1,5,4),(10,9920,0,1,5,4),(10,9922,0,1,5,4),(10,9923,0,1,5,4),(10,9929,0,1,5,4),(10,9941,0,1,5,4),(10,10000,0,1,5,4),(10,10001,0,1,5,4),(10,10002,0,1,5,4),(10,10004,0,1,5,4),(10,10005,0,1,5,4),(10,10006,0,1,5,4),(10,10007,0,1,5,4),(10,10008,0,1,5,4),(10,10010,0,1,5,4),(10,10013,0,1,5,4),(10,10014,0,1,5,4),(10,10015,0,1,5,4),(10,10016,0,1,5,4),(10,10018,0,1,5,4),(10,10019,0,1,5,4),(10,10020,0,1,5,4),(10,10021,0,1,5,4),(10,10022,0,1,5,4),(10,10023,0,1,5,4),(10,10024,0,1,5,4),(10,10029,0,1,5,4),(10,10035,0,1,5,4),(10,10036,0,1,5,4),(10,10037,0,1,5,4),(10,10040,0,1,5,4),(10,10041,0,1,5,4),(10,10043,0,1,5,4),(10,10044,0,1,5,4),(10,10047,0,1,5,4),(10,10068,0,1,5,4),(10,10156,0,1,5,4),(10,10157,0,1,5,4),(10,10237,0,1,5,4),(10,10432,0,1,5,4),(10,10434,0,1,5,4),(10,10435,0,1,5,4),(10,10584,0,1,5,4),(10,10681,0,1,5,4),(10,10683,0,1,5,4),(10,10891,0,1,5,4),(10,10905,0,1,5,4),(10,11057,0,1,5,4),(10,11076,0,1,5,4),(10,11155,0,1,5,4),(10,11233,0,1,5,4),(10,11270,0,1,5,4),(10,11407,0,1,5,4),(10,11511,0,1,5,4),(10,11520,0,1,5,4),(10,11571,0,1,5,4),(10,11630,0,1,5,4),(10,11636,0,1,5,4),(10,11640,0,1,5,4),(10,11641,0,1,5,4),(10,11644,0,1,5,4),(10,11651,0,1,5,4),(10,11653,0,1,5,4),(10,11686,0,1,5,4),(10,11787,0,1,5,4),(10,12227,0,1,5,4),(10,12239,0,1,5,4),(10,12240,0,1,5,4),(10,12241,0,1,5,4),(10,12242,0,1,5,4),(10,12243,0,1,5,4),(10,12244,0,1,5,4),(10,12245,0,1,5,4),(10,12246,0,1,5,4),(10,12247,0,1,5,4),(10,12248,0,1,5,4),(10,12249,0,1,5,4),(10,12250,0,1,5,4),(10,12251,0,1,5,4),(10,12252,0,1,5,4),(10,12253,0,1,5,4),(10,12254,0,1,5,4),(10,12414,0,1,5,4),(10,12423,0,1,5,4),(10,12503,0,1,5,4),(10,12535,0,1,5,4),(10,12618,0,1,5,4),(10,12619,0,1,5,4),(10,12627,0,1,5,4),(10,12644,0,1,5,4),(10,12658,0,1,5,4),(10,12659,0,1,5,4),(10,12660,0,1,5,4),(10,12661,0,1,5,4),(10,12662,0,1,5,4),(10,12663,0,1,5,4),(10,12664,0,1,5,4),(10,12837,0,1,5,4),(10,12882,0,1,5,4),(10,12883,0,1,5,4),(10,12884,0,1,5,4),(10,12965,0,1,5,4),(10,12966,0,1,5,4),(10,12968,0,1,5,4),(10,13160,0,1,5,4),(10,13274,0,1,5,4),(10,13348,0,1,5,4),(10,13371,0,1,5,4),(10,13668,0,1,5,4),(10,13670,0,1,5,4),(10,13827,0,1,5,4),(10,13883,0,1,5,4),(10,13884,0,1,5,4),(10,13885,0,1,5,4),(10,13887,0,1,5,4),(10,13889,0,1,5,4),(10,13924,0,1,5,4),(10,14080,0,1,5,4),(10,14081,0,1,5,4),(10,14370,0,1,5,4),(10,14471,0,1,5,4),(10,14473,0,1,5,4),(10,14474,0,1,5,4),(10,14476,0,1,5,4),(10,14501,0,1,5,4),(10,14514,0,1,5,4),(10,14530,0,1,5,4),(10,14538,0,1,5,4),(10,14722,0,1,5,4),(10,14727,0,1,5,4),(10,14728,0,1,5,4),(10,14730,0,1,5,4),(10,14731,0,1,5,4),(10,14732,0,1,5,4),(10,14867,0,1,5,4),(10,14934,0,1,5,4),(10,14955,0,1,5,4),(10,15043,0,1,5,4),(10,15063,0,1,5,4),(10,15082,0,1,5,4),(10,15133,0,1,5,4),(10,15228,0,1,5,4),(10,15236,0,1,5,4),(10,15237,0,1,5,4),(10,15238,0,1,5,4),(10,15239,0,1,5,4),(10,15240,0,1,5,4),(10,15241,0,1,5,4),(10,15310,0,1,5,4),(10,15355,0,1,5,4),(10,15362,0,1,5,4),(10,15363,0,1,5,4),(10,15366,0,1,5,4),(10,15368,0,1,5,4),(10,15382,0,1,5,4),(10,15499,0,1,5,4),(10,15544,0,1,5,4),(10,15595,0,1,5,4),(10,15596,0,1,5,4),(10,15597,0,1,5,4),(10,15598,0,1,5,4),(10,15669,0,1,5,4),(10,15671,0,1,5,4),(10,15672,0,1,5,4),(10,15683,0,1,5,4),(10,15684,0,1,5,4),(10,15746,0,1,5,4),(10,15786,0,1,5,4),(10,15787,0,1,5,4),(10,15838,0,1,5,4),(10,15839,0,1,5,4),(10,15840,0,1,5,4),(10,15841,0,1,5,4),(10,15842,0,1,5,4),(10,15843,0,1,5,4),(10,15844,0,1,5,4),(10,15876,0,1,5,4),(10,15877,0,1,5,4),(10,15878,0,1,5,4),(10,15880,0,1,5,4),(10,15881,0,1,5,4),(10,15885,0,1,5,4),(10,15886,0,1,5,4),(10,15903,0,1,5,4),(10,15905,0,1,5,4),(10,15928,0,1,5,4),(10,15929,0,1,5,4),(10,15930,0,1,5,4),(10,15931,0,1,5,4),(10,15956,0,1,5,4),(10,15957,0,1,5,4),(10,15958,0,1,5,4),(10,15959,0,1,5,4),(10,15960,0,1,5,4),(10,15961,0,1,5,4),(10,15967,0,1,5,4),(10,15968,0,1,5,4),(10,15969,0,1,5,4),(10,15971,0,1,5,4),(10,15978,0,1,5,4),(10,15979,0,1,5,4),(10,15980,0,1,5,4),(10,15995,0,1,5,4),(10,16010,0,1,5,4),(10,16196,0,1,5,4),(10,16255,0,1,5,4),(10,16256,0,1,5,4),(10,16257,0,1,5,4),(10,16270,0,1,5,4),(10,16302,0,1,5,4),(10,16303,0,1,5,4),(10,16308,0,1,5,4),(10,16338,0,1,5,4),(10,16356,0,1,5,4),(10,16357,0,1,5,4),(10,16358,0,1,5,4),(10,16451,0,1,5,4),(10,16452,0,1,5,4),(10,16453,0,1,5,4),(10,16458,0,1,5,4),(10,16779,0,1,5,4),(10,16782,0,1,5,4),(10,17041,0,1,5,4),(10,17043,0,1,5,4),(10,17044,0,1,5,4),(10,17230,0,1,5,4),(10,17405,0,1,5,4),(10,17406,0,1,5,4),(10,17407,0,1,5,4),(10,17408,0,1,5,4),(10,17409,0,1,5,4),(10,17410,0,1,5,4),(10,17411,0,1,5,4),(10,17412,0,1,5,4),(10,17413,0,1,5,4),(10,17414,0,1,5,4),(10,17415,0,1,5,4),(10,17416,0,1,5,4),(10,17417,0,1,5,4),(10,17418,0,1,5,4),(10,17419,0,1,5,4),(10,17420,0,1,5,4),(10,17421,0,1,5,4),(10,17422,0,1,5,4),(10,17423,0,1,5,4),(10,17424,0,1,5,4),(10,17425,0,1,5,4),(10,17426,0,1,5,4),(10,17427,0,1,5,4),(10,17428,0,1,5,4),(10,17429,0,1,5,4),(10,17430,0,1,5,4),(10,17431,0,1,5,4),(10,17432,0,1,5,4),(10,17433,0,1,5,4),(10,17434,0,1,5,4),(10,17435,0,1,5,4),(10,17436,0,1,5,4),(10,17659,0,1,5,4),(10,17661,0,1,5,4),(10,17663,0,1,5,4),(10,17732,0,1,5,4),(10,17733,0,1,5,4),(10,17785,0,1,5,4),(10,18160,0,1,5,4),(10,18715,0,1,5,4),(10,18906,0,1,5,4),(10,19084,0,1,5,4),(10,19085,0,1,5,4),(10,19258,0,1,5,4),(10,19259,0,1,5,4),(10,19395,0,1,5,4),(10,19487,0,1,5,4),(10,19488,0,1,5,4),(10,19510,0,1,5,4),(10,19511,0,1,5,4),(10,19512,0,1,5,4),(10,19515,0,1,5,4),(10,19516,0,1,5,4),(10,19517,0,1,5,4),(10,19518,0,1,5,4),(10,19519,0,1,5,4),(10,19520,0,1,5,4),(10,19549,0,1,5,4),(10,19550,0,1,5,4),(10,19552,0,1,5,4),(10,19556,0,1,5,4),(10,19557,0,1,5,4),(10,19561,0,1,5,4),(10,19563,0,1,5,4),(10,19564,0,1,5,4),(10,19565,0,1,5,4),(10,19566,0,1,5,4),(10,19570,0,1,5,4),(10,19571,0,1,5,4),(10,19576,0,1,5,4),(10,19579,0,1,5,4);
/*!40000 ALTER TABLE `catalog_category_product_index_store5_replica` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index_tmp`
--

DROP TABLE IF EXISTS `catalog_category_product_index_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_product_index_tmp` (
  `category_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Category ID',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `position` int(11) NOT NULL DEFAULT '0' COMMENT 'Position',
  `is_parent` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `visibility` smallint(5) unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `CAT_CTGR_PRD_IDX_TMP_PRD_ID_CTGR_ID_STORE_ID` (`product_id`,`category_id`,`store_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Product Indexer temporary table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index_tmp`
--

LOCK TABLES `catalog_category_product_index_tmp` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index_tmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_category_product_index_tmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_compare_item`
--

DROP TABLE IF EXISTS `catalog_compare_item`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_compare_item` (
  `catalog_compare_item_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Compare Item ID',
  `visitor_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Visitor ID',
  `customer_id` int(10) unsigned DEFAULT NULL COMMENT 'Customer ID',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `store_id` smallint(5) unsigned DEFAULT NULL COMMENT 'Store ID',
  `list_id` int(10) unsigned DEFAULT NULL COMMENT 'List ID',
  PRIMARY KEY (`catalog_compare_item_id`),
  KEY `CATALOG_COMPARE_ITEM_PRODUCT_ID` (`product_id`),
  KEY `CATALOG_COMPARE_ITEM_VISITOR_ID_PRODUCT_ID` (`visitor_id`,`product_id`),
  KEY `CATALOG_COMPARE_ITEM_CUSTOMER_ID_PRODUCT_ID` (`customer_id`,`product_id`),
  KEY `CATALOG_COMPARE_ITEM_STORE_ID` (`store_id`),
  KEY `CATALOG_COMPARE_ITEM_LIST_ID_CATALOG_COMPARE_LIST_LIST_ID` (`list_id`),
  CONSTRAINT `CATALOG_COMPARE_ITEM_CUSTOMER_ID_CUSTOMER_ENTITY_ENTITY_ID` FOREIGN KEY (`customer_id`) REFERENCES `customer_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CATALOG_COMPARE_ITEM_LIST_ID_CATALOG_COMPARE_LIST_LIST_ID` FOREIGN KEY (`list_id`) REFERENCES `catalog_compare_list` (`list_id`) ON DELETE CASCADE,
  CONSTRAINT `CATALOG_COMPARE_ITEM_PRODUCT_ID_CATALOG_PRODUCT_ENTITY_ENTITY_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CATALOG_COMPARE_ITEM_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='Catalog Compare Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_compare_item`
--

LOCK TABLES `catalog_compare_item` WRITE;
/*!40000 ALTER TABLE `catalog_compare_item` DISABLE KEYS */;
INSERT INTO `catalog_compare_item` VALUES (3,504,14,10016,5,NULL);
/*!40000 ALTER TABLE `catalog_compare_item` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_compare_list`
--

DROP TABLE IF EXISTS `catalog_compare_list`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_compare_list` (
  `list_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Compare List ID',
  `list_id_mask` varchar(32) DEFAULT NULL COMMENT 'Masked ID',
  `customer_id` int(10) unsigned DEFAULT NULL COMMENT 'Customer ID',
  PRIMARY KEY (`list_id`),
  UNIQUE KEY `CATALOG_COMPARE_LIST_CUSTOMER_ID` (`customer_id`),
  KEY `CATALOG_COMPARE_LIST_LIST_ID_MASK` (`list_id_mask`),
  CONSTRAINT `CATALOG_COMPARE_LIST_CUSTOMER_ID_CUSTOMER_ENTITY_ENTITY_ID` FOREIGN KEY (`customer_id`) REFERENCES `customer_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Compare List with hash Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_compare_list`
--

LOCK TABLES `catalog_compare_list` WRITE;
/*!40000 ALTER TABLE `catalog_compare_list` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_compare_list` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_eav_attribute`
--

DROP TABLE IF EXISTS `catalog_eav_attribute`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_eav_attribute` (
  `attribute_id` smallint(5) unsigned NOT NULL COMMENT 'Attribute ID',
  `frontend_input_renderer` varchar(255) DEFAULT NULL COMMENT 'Frontend Input Renderer',
  `is_global` smallint(5) unsigned NOT NULL DEFAULT '1' COMMENT 'Is Global',
  `is_visible` smallint(5) unsigned NOT NULL DEFAULT '1' COMMENT 'Is Visible',
  `is_searchable` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Searchable',
  `is_filterable` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Filterable',
  `is_comparable` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Comparable',
  `is_visible_on_front` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Visible On Front',
  `is_html_allowed_on_front` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is HTML Allowed On Front',
  `is_used_for_price_rules` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Used For Price Rules',
  `is_filterable_in_search` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Filterable In Search',
  `used_in_product_listing` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Used In Product Listing',
  `used_for_sort_by` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Used For Sorting',
  `apply_to` varchar(255) DEFAULT NULL COMMENT 'Apply To',
  `is_visible_in_advanced_search` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Visible In Advanced Search',
  `position` int(11) NOT NULL DEFAULT '0' COMMENT 'Position',
  `is_wysiwyg_enabled` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is WYSIWYG Enabled',
  `is_used_for_promo_rules` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Used For Promo Rules',
  `is_required_in_admin_store` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Required In Admin Store',
  `is_used_in_grid` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Used in Grid',
  `is_visible_in_grid` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Visible in Grid',
  `is_filterable_in_grid` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Filterable in Grid',
  `search_weight` float NOT NULL DEFAULT '1' COMMENT 'Search Weight',
  `additional_data` text COMMENT 'Additional swatch attributes data',
  `is_pagebuilder_enabled` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Is PageBuilder Enabled',
  PRIMARY KEY (`attribute_id`),
  KEY `CATALOG_EAV_ATTRIBUTE_USED_FOR_SORT_BY` (`used_for_sort_by`),
  KEY `CATALOG_EAV_ATTRIBUTE_USED_IN_PRODUCT_LISTING` (`used_in_product_listing`),
  CONSTRAINT `CATALOG_EAV_ATTRIBUTE_ATTRIBUTE_ID_EAV_ATTRIBUTE_ATTRIBUTE_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog EAV Attribute Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_eav_attribute`
--

LOCK TABLES `catalog_eav_attribute` WRITE;
/*!40000 ALTER TABLE `catalog_eav_attribute` DISABLE KEYS */;
INSERT INTO `catalog_eav_attribute` VALUES (45,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL,0),(46,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL,0),(47,NULL,0,1,0,0,0,0,1,0,0,0,0,NULL,0,0,1,0,0,0,0,0,1,NULL,0),(48,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL,0),(49,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL,0),(50,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL,0),(51,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL,0),(52,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL,0),(53,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL,0),(54,NULL,1,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL,0),(55,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL,0),(56,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL,0),(57,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL,0),(58,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL,0),(59,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL,0),(60,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL,0),(61,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL,0),(62,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL,0),(63,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL,0),(64,NULL,0,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL,0),(65,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL,0),(66,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL,0),(67,'Magento\\Catalog\\Block\\Adminhtml\\Category\\Helper\\Sortby\\Available',0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL,0),(68,'Magento\\Catalog\\Block\\Adminhtml\\Category\\Helper\\Sortby\\DefaultSortby',0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL,0),(69,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL,0),(70,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL,0),(71,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL,0),(72,'Magento\\Catalog\\Block\\Adminhtml\\Category\\Helper\\Pricestep',0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL,0),(73,NULL,0,1,1,0,0,0,0,0,0,1,1,NULL,1,0,0,0,0,0,0,0,5,NULL,0),(74,NULL,1,1,1,0,1,0,0,0,0,0,0,NULL,1,0,0,0,0,0,0,0,6,NULL,0),(75,NULL,0,1,1,0,1,0,1,0,0,0,0,NULL,1,0,1,0,0,0,0,0,1,NULL,1),(76,NULL,0,1,1,0,1,0,1,0,0,1,0,NULL,1,0,1,0,0,1,0,0,1,NULL,0),(77,NULL,1,1,1,1,0,0,0,0,0,1,1,'simple,virtual,downloadable,configurable,bundle',1,0,0,0,0,0,0,0,1,NULL,0),(78,NULL,1,1,0,0,0,0,0,0,0,1,0,'simple,virtual,downloadable,configurable,bundle',0,0,0,0,0,1,0,1,1,NULL,0),(79,NULL,2,1,0,0,0,0,0,0,0,1,0,'simple,virtual,downloadable,configurable,bundle',0,0,0,0,0,1,0,0,1,NULL,0),(80,NULL,2,1,0,0,0,0,0,0,0,1,0,'simple,virtual,downloadable,configurable,bundle',0,0,0,0,0,1,0,0,1,NULL,0),(81,NULL,1,1,0,0,0,0,0,0,0,0,0,'simple,virtual,downloadable',0,0,0,0,0,1,0,1,1,NULL,0),(82,'Magento\\Catalog\\Block\\Adminhtml\\Product\\Helper\\Form\\Weight',1,1,0,0,0,0,0,0,0,0,0,'simple,virtual,downloadable,configurable,bundle',0,0,0,0,0,1,0,1,1,NULL,0),(83,NULL,1,1,1,1,1,1,1,0,1,1,0,'simple,configurable',1,0,0,1,0,1,0,1,1,NULL,0),(84,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,1,0,1,1,NULL,0),(85,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,1,0,1,1,NULL,0),(86,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,1,0,1,1,NULL,0),(87,NULL,0,1,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,0,0,0,1,NULL,0),(88,NULL,0,1,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,0,0,0,1,NULL,0),(89,NULL,0,1,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,0,0,0,1,NULL,0),(90,NULL,1,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL,0),(91,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL,0),(92,NULL,2,1,0,0,0,0,0,0,0,0,0,'simple,virtual,downloadable,bundle',0,0,0,0,0,0,0,0,1,NULL,0),(93,NULL,1,1,1,1,1,1,0,0,1,1,0,'simple,virtual,configurable',1,0,0,1,0,1,0,1,1,'{\"swatch_input_type\":\"visual\",\"update_product_preview_image\":\"1\",\"use_product_image_for_swatch\":\"0\"}',0),(94,NULL,2,1,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,1,0,0,1,NULL,0),(95,NULL,2,1,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,1,0,0,1,NULL,0),(96,NULL,1,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL,0),(97,'Magento\\Framework\\Data\\Form\\Element\\Hidden',2,1,1,0,0,0,0,0,0,1,0,NULL,0,0,0,0,1,0,0,0,1,NULL,0),(98,NULL,1,0,0,0,0,0,0,0,0,0,0,'simple,virtual,downloadable,configurable,bundle',0,0,0,0,0,0,0,0,1,NULL,0),(99,NULL,1,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,1,0,0,0,1,NULL,0),(100,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,1,0,1,1,NULL,0),(101,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,1,0,0,1,NULL,0),(102,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,1,0,0,1,NULL,0),(103,NULL,0,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL,0),(104,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,1,0,0,1,NULL,0),(105,'Magento\\Catalog\\Block\\Adminhtml\\Product\\Helper\\Form\\Category',1,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL,0),(106,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL,0),(107,NULL,1,0,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,0,0,0,1,NULL,0),(108,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL,0),(109,NULL,0,0,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,0,0,0,1,NULL,0),(110,NULL,0,0,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,0,0,0,1,NULL,0),(111,NULL,0,0,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,0,0,0,1,NULL,0),(112,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL,0),(113,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL,0),(114,NULL,2,1,0,0,0,0,0,0,0,0,0,'simple,bundle,configurable,grouped',0,0,0,0,0,1,0,1,1,NULL,0),(115,'Magento\\CatalogInventory\\Block\\Adminhtml\\Form\\Field\\Stock',1,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL,0),(116,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,1,0,0,1,NULL,0),(117,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL,0),(118,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL,0),(119,NULL,0,1,1,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL,0),(120,NULL,0,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL,0),(121,NULL,0,1,1,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,1,0,1,1,NULL,0),(122,NULL,0,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL,0),(123,'Magento\\Msrp\\Block\\Adminhtml\\Product\\Helper\\Form\\Type',1,1,0,0,0,0,0,0,0,1,0,'simple,virtual,downloadable,bundle,configurable',0,0,0,0,0,1,0,1,1,NULL,0),(124,'Magento\\Msrp\\Block\\Adminhtml\\Product\\Helper\\Form\\Type\\Price',2,1,0,0,0,0,0,0,0,1,0,'simple,virtual,downloadable,bundle,configurable',0,0,0,0,0,0,0,0,1,NULL,0),(125,NULL,1,0,0,0,0,0,0,0,0,1,0,'downloadable',0,0,0,0,0,0,0,0,1,NULL,0),(126,NULL,0,0,0,0,0,0,0,0,0,0,0,'downloadable',0,0,0,0,0,0,0,0,1,NULL,0),(127,NULL,0,0,0,0,0,0,0,0,0,0,0,'downloadable',0,0,0,0,0,0,0,0,1,NULL,0),(128,NULL,1,0,0,0,0,0,0,0,0,1,0,'downloadable',0,0,0,0,0,0,0,0,1,NULL,0),(129,'Magento\\GiftMessage\\Block\\Adminhtml\\Product\\Helper\\Form\\Config',1,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,1,0,0,1,NULL,0),(130,NULL,1,1,0,0,0,0,0,0,0,1,0,'bundle',0,0,0,0,0,0,0,0,1,NULL,0),(131,NULL,1,1,0,0,0,0,0,0,0,0,0,'bundle',0,0,0,0,0,0,0,0,1,NULL,0),(132,NULL,1,1,0,0,0,0,0,0,0,1,0,'bundle',0,0,0,0,0,0,0,0,1,NULL,0),(133,NULL,1,1,0,0,0,0,0,0,0,1,0,'bundle',0,0,0,0,0,0,0,0,1,NULL,0),(134,NULL,1,1,0,0,0,0,0,0,0,1,0,'bundle',0,0,0,0,0,0,0,0,1,NULL,0),(135,NULL,0,1,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,0,0,0,1,NULL,0),(136,NULL,2,1,1,0,0,0,0,0,0,1,0,'simple,virtual,downloadable,configurable,bundle',0,0,0,0,0,1,0,1,1,NULL,0),(137,NULL,1,1,0,0,0,0,0,0,0,1,0,'simple,configurable,virtual,bundle,downloadable',0,0,0,0,0,0,0,0,1,NULL,0),(138,NULL,1,1,0,1,0,1,1,0,1,1,0,NULL,0,0,0,1,0,0,1,0,1,'{\"swatch_input_type\":\"text\",\"update_product_preview_image\":\"1\",\"use_product_image_for_swatch\":0}',0),(139,NULL,1,1,0,0,0,0,0,0,0,1,0,'simple,configurable,virtual,bundle,downloadable',0,0,0,0,0,0,0,0,1,NULL,0),(140,NULL,1,1,1,1,0,1,1,0,1,1,0,NULL,1,0,0,0,0,1,1,1,1,NULL,0),(141,NULL,1,1,1,1,0,1,1,0,1,1,0,NULL,1,0,0,0,0,1,1,1,1,NULL,0),(142,NULL,1,1,1,1,0,1,1,0,1,1,0,NULL,0,0,0,0,0,1,1,1,1,NULL,0),(143,NULL,1,1,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,0,0,0,1,NULL,0),(144,NULL,1,1,0,0,0,0,0,0,0,1,0,'simple,configurable,virtual,bundle,downloadable',0,0,0,0,0,0,0,0,1,NULL,0),(145,NULL,1,1,0,0,0,0,0,0,0,1,0,'simple,configurable,virtual,bundle,downloadable',0,0,0,0,0,0,0,0,1,NULL,0),(146,NULL,1,1,0,0,0,0,0,0,0,1,0,'simple,configurable,virtual,bundle,downloadable',0,0,0,0,0,0,0,0,1,NULL,0),(147,NULL,1,1,0,0,0,0,0,0,0,1,0,'simple,configurable,virtual,bundle,downloadable',0,0,0,0,0,0,0,0,1,NULL,0),(148,NULL,1,1,0,0,0,0,0,0,0,1,0,'simple,configurable,virtual,bundle,downloadable',0,0,0,0,0,0,0,0,1,NULL,0),(149,NULL,1,1,1,1,1,1,0,0,0,1,0,'simple,configurable,virtual,downloadable,bundle',1,0,0,0,0,1,0,1,1,NULL,0),(150,NULL,0,1,0,0,1,0,1,0,0,0,0,NULL,0,0,0,0,0,1,1,1,1,NULL,0),(151,NULL,0,1,0,0,0,0,1,0,0,0,0,NULL,0,0,0,0,0,1,1,1,1,NULL,0),(152,NULL,1,1,0,0,0,0,1,0,0,0,0,NULL,0,0,0,0,0,1,1,1,1,NULL,0);
/*!40000 ALTER TABLE `catalog_eav_attribute` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_bundle_option`
--

DROP TABLE IF EXISTS `catalog_product_bundle_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_bundle_option` (
  `option_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Option ID',
  `parent_id` int(10) unsigned NOT NULL COMMENT 'Parent ID',
  `required` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Required',
  `position` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Position',
  `type` varchar(255) DEFAULT NULL COMMENT 'Type',
  PRIMARY KEY (`option_id`),
  KEY `CATALOG_PRODUCT_BUNDLE_OPTION_PARENT_ID` (`parent_id`),
  CONSTRAINT `CAT_PRD_BNDL_OPT_PARENT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`parent_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Bundle Option';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_bundle_option`
--

LOCK TABLES `catalog_product_bundle_option` WRITE;
/*!40000 ALTER TABLE `catalog_product_bundle_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_bundle_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_bundle_option_value`
--

DROP TABLE IF EXISTS `catalog_product_bundle_option_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_bundle_option_value` (
  `value_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `option_id` int(10) unsigned NOT NULL COMMENT 'Option ID',
  `store_id` smallint(5) unsigned NOT NULL COMMENT 'Store ID',
  `title` varchar(255) DEFAULT NULL COMMENT 'Title',
  `parent_product_id` int(10) unsigned NOT NULL COMMENT 'Parent Product ID',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CAT_PRD_BNDL_OPT_VAL_OPT_ID_PARENT_PRD_ID_STORE_ID` (`option_id`,`parent_product_id`,`store_id`),
  CONSTRAINT `CAT_PRD_BNDL_OPT_VAL_OPT_ID_CAT_PRD_BNDL_OPT_OPT_ID` FOREIGN KEY (`option_id`) REFERENCES `catalog_product_bundle_option` (`option_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Bundle Option Value';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_bundle_option_value`
--

LOCK TABLES `catalog_product_bundle_option_value` WRITE;
/*!40000 ALTER TABLE `catalog_product_bundle_option_value` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_bundle_option_value` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_bundle_price_index`
--

DROP TABLE IF EXISTS `catalog_product_bundle_price_index`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_bundle_price_index` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website ID',
  `customer_group_id` int(10) unsigned NOT NULL COMMENT 'Customer Group ID',
  `min_price` decimal(20,6) NOT NULL COMMENT 'Min Price',
  `max_price` decimal(20,6) NOT NULL COMMENT 'Max Price',
  PRIMARY KEY (`entity_id`,`website_id`,`customer_group_id`),
  KEY `CATALOG_PRODUCT_BUNDLE_PRICE_INDEX_WEBSITE_ID` (`website_id`),
  KEY `CATALOG_PRODUCT_BUNDLE_PRICE_INDEX_CUSTOMER_GROUP_ID` (`customer_group_id`),
  CONSTRAINT `CAT_PRD_BNDL_PRICE_IDX_CSTR_GROUP_ID_CSTR_GROUP_CSTR_GROUP_ID` FOREIGN KEY (`customer_group_id`) REFERENCES `customer_group` (`customer_group_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_PRD_BNDL_PRICE_IDX_ENTT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_PRD_BNDL_PRICE_IDX_WS_ID_STORE_WS_WS_ID` FOREIGN KEY (`website_id`) REFERENCES `store_website` (`website_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Bundle Price Index';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_bundle_price_index`
--

LOCK TABLES `catalog_product_bundle_price_index` WRITE;
/*!40000 ALTER TABLE `catalog_product_bundle_price_index` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_bundle_price_index` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_bundle_selection`
--

DROP TABLE IF EXISTS `catalog_product_bundle_selection`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_bundle_selection` (
  `selection_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Selection ID',
  `option_id` int(10) unsigned NOT NULL COMMENT 'Option ID',
  `parent_product_id` int(10) unsigned NOT NULL COMMENT 'Parent Product ID',
  `product_id` int(10) unsigned NOT NULL COMMENT 'Product ID',
  `position` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Position',
  `is_default` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Default',
  `selection_price_type` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Selection Price Type',
  `selection_price_value` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Selection Price Value',
  `selection_qty` decimal(12,4) DEFAULT NULL COMMENT 'Selection Qty',
  `selection_can_change_qty` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Selection Can Change Qty',
  PRIMARY KEY (`selection_id`),
  KEY `CATALOG_PRODUCT_BUNDLE_SELECTION_OPTION_ID` (`option_id`),
  KEY `CATALOG_PRODUCT_BUNDLE_SELECTION_PRODUCT_ID` (`product_id`),
  CONSTRAINT `CAT_PRD_BNDL_SELECTION_OPT_ID_CAT_PRD_BNDL_OPT_OPT_ID` FOREIGN KEY (`option_id`) REFERENCES `catalog_product_bundle_option` (`option_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_PRD_BNDL_SELECTION_PRD_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Bundle Selection';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_bundle_selection`
--

LOCK TABLES `catalog_product_bundle_selection` WRITE;
/*!40000 ALTER TABLE `catalog_product_bundle_selection` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_bundle_selection` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_bundle_selection_price`
--

DROP TABLE IF EXISTS `catalog_product_bundle_selection_price`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_bundle_selection_price` (
  `selection_id` int(10) unsigned NOT NULL COMMENT 'Selection ID',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website ID',
  `selection_price_type` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Selection Price Type',
  `selection_price_value` decimal(20,6) NOT NULL DEFAULT '0.000000' COMMENT 'Selection Price Value',
  `parent_product_id` int(10) unsigned NOT NULL COMMENT 'Parent Product ID',
  PRIMARY KEY (`selection_id`,`parent_product_id`,`website_id`),
  KEY `CATALOG_PRODUCT_BUNDLE_SELECTION_PRICE_WEBSITE_ID` (`website_id`),
  CONSTRAINT `CAT_PRD_BNDL_SELECTION_PRICE_WS_ID_STORE_WS_WS_ID` FOREIGN KEY (`website_id`) REFERENCES `store_website` (`website_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_DCF37523AA05D770A70AA4ED7C2616E4` FOREIGN KEY (`selection_id`) REFERENCES `catalog_product_bundle_selection` (`selection_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Bundle Selection Price';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_bundle_selection_price`
--

LOCK TABLES `catalog_product_bundle_selection_price` WRITE;
/*!40000 ALTER TABLE `catalog_product_bundle_selection_price` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_bundle_selection_price` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_bundle_stock_index`
--

DROP TABLE IF EXISTS `catalog_product_bundle_stock_index`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_bundle_stock_index` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website ID',
  `stock_id` smallint(5) unsigned NOT NULL COMMENT 'Stock ID',
  `option_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Option ID',
  `stock_status` smallint(6) DEFAULT '0' COMMENT 'Stock Status',
  PRIMARY KEY (`entity_id`,`website_id`,`stock_id`,`option_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Bundle Stock Index';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_bundle_stock_index`
--

LOCK TABLES `catalog_product_bundle_stock_index` WRITE;
/*!40000 ALTER TABLE `catalog_product_bundle_stock_index` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_bundle_stock_index` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity`
--

DROP TABLE IF EXISTS `catalog_product_entity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_entity` (
  `entity_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `attribute_set_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute Set ID',
  `type_id` varchar(32) NOT NULL DEFAULT 'simple' COMMENT 'Type ID',
  `sku` varchar(64) NOT NULL COMMENT 'SKU',
  `has_options` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Has Options',
  `required_options` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Required Options',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Creation Time',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Update Time',
  PRIMARY KEY (`entity_id`),
  KEY `CATALOG_PRODUCT_ENTITY_ATTRIBUTE_SET_ID` (`attribute_set_id`),
  KEY `CATALOG_PRODUCT_ENTITY_SKU` (`sku`)
) ENGINE=InnoDB AUTO_INCREMENT=19582 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_entity`
--

LOCK TABLES `catalog_product_entity` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity` DISABLE KEYS */;
INSERT INTO `catalog_product_entity` VALUES (298,4,'simple','test121',0,0,'2022-05-13 06:09:40','2022-08-04 06:51:54'),(299,4,'simple','7071484',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(300,4,'simple','1054073',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(301,4,'simple','1040042',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(302,4,'simple','1030223',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(303,4,'simple','7073634',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(304,4,'simple','7010275',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(305,4,'simple','1041077',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(306,4,'simple','1110410',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(307,4,'simple','1118849',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(308,4,'simple','1127892',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(309,4,'simple','1049280',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(310,4,'simple','1107122',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(311,4,'simple','1127898',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(312,4,'simple','1127899',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(313,4,'simple','7032301',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(314,4,'simple','1127903',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(315,4,'simple','1117972',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(316,4,'simple','1127900',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(317,4,'simple','1127891',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(318,4,'simple','7114325',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(319,4,'simple','7114306',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(320,4,'simple','7004408-R',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(321,4,'simple','7005233',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(322,4,'simple','7003117',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(323,4,'simple','1117973',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(324,4,'simple','1129300',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(325,4,'simple','7018932',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(326,4,'simple','1048810',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(327,4,'simple','7059765',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(328,4,'simple','7089453',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(329,4,'simple','7086323',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(330,4,'simple','1094189',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(331,4,'simple','1119108',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(332,4,'simple','7078904',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(333,4,'simple','1129301',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(334,4,'simple','7051591',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(335,4,'simple','1024040',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(336,4,'simple','1025021',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(337,4,'simple','1065842',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(338,4,'simple','1130304',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(339,4,'simple','1119106',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(340,4,'simple','1119107',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(341,4,'simple','7001289',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(342,4,'simple','7017739',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(343,4,'simple','7019604',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(344,4,'simple','7024730',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(345,4,'simple','7026582',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(346,4,'simple','7036749',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(347,4,'simple','7036764',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(348,4,'simple','7040891',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(349,4,'simple','7056111',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(350,4,'simple','7064635',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(351,4,'simple','7067960',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(352,4,'simple','7070014',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(353,4,'simple','7070324',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(354,4,'simple','7074142',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(355,4,'simple','7074143',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(356,4,'simple','7077381',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(357,4,'simple','7077382',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(358,4,'simple','7088776',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(359,4,'simple','7089141',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(360,4,'simple','7089152',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(361,4,'simple','7089162',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(362,4,'simple','7089269',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(363,4,'simple','7089529',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(364,4,'simple','7089531',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(365,4,'simple','7099933',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(366,4,'simple','7099935',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(367,4,'simple','7108288',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(368,4,'simple','7117408',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(369,4,'simple','7122980',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(370,4,'simple','7123674',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(371,4,'simple','7125236',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(372,4,'simple','7126931',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(373,4,'simple','7130686',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(374,4,'simple','1118544',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(375,4,'simple','1118545',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(376,4,'simple','1118542',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(377,4,'simple','1118543',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(378,4,'simple','7018804',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(379,4,'simple','7099425',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(380,4,'simple','1125108',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(381,4,'simple','7009830',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(382,4,'simple','7040898',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(383,4,'simple','7016620',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(384,4,'simple','7040897',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(385,4,'simple','7043030',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(386,4,'simple','7048292',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(387,4,'simple','7076691',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(388,4,'simple','7058536',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(389,4,'simple','7134078',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(390,4,'simple','7100965',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(391,4,'simple','7078893',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(392,4,'simple','7009828',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(393,4,'simple','7009837',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(394,4,'simple','7045965',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(395,4,'simple','7009835',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(396,4,'simple','1130020',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(397,4,'simple','1130153',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(398,4,'simple','7100892',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:14'),(399,4,'simple','16001262-01',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(400,4,'simple','16001267-01',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(401,4,'simple','7039429',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(402,4,'simple','7082330',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(403,4,'simple','7007996',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(404,4,'simple','7004111',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(405,4,'simple','7010776',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(406,4,'simple','7004112',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(407,4,'simple','7017090',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(408,4,'simple','7072445',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(409,4,'simple','7029239',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(410,4,'simple','7066426',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(411,4,'simple','901069',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(412,4,'simple','1113308',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(413,4,'simple','30003218',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(414,4,'simple','30003219',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(415,4,'simple','30003213',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(416,4,'simple','30003217',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(417,4,'simple','1049186',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(418,4,'simple','16000361-01',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(419,4,'simple','16001236-01',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(420,4,'simple','16001237-01',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(421,4,'simple','7078178',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(422,4,'simple','901129',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(423,4,'simple','1075649',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(424,4,'simple','7009821',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(425,4,'simple','1040814',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(426,4,'simple','1119874',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(427,4,'simple','7005202',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(428,4,'simple','1115743',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(429,4,'simple','1066445',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(430,4,'simple','1119021',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(431,4,'simple','1118922',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(432,4,'simple','1117607',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(433,4,'simple','13000268-01',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(434,4,'simple','7087500',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(435,4,'simple','1099455',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(436,4,'simple','14095',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(437,4,'simple','6014F-03',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(438,4,'simple','7131733',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(439,4,'simple','7131734',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(440,4,'simple','900954',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(441,4,'simple','7022216',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(442,4,'simple','1039556',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(443,4,'simple','1113890',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(444,4,'simple','7103285',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(445,4,'simple','1050374',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(446,4,'simple','1049223',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(447,4,'simple','7014720',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(448,4,'simple','1032711',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(449,4,'simple','30003047',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(450,4,'simple','1076153',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(451,4,'simple','7035911',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(452,4,'simple','1030298',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(453,4,'simple','1039574',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(454,4,'simple','1115644',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(455,4,'simple','7118225',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(456,4,'simple','1054912',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(457,4,'simple','7120858',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(458,4,'simple','1049109',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(459,4,'simple','1086261',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(460,4,'simple','1067674',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(461,4,'simple','1067673',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(462,4,'simple','1097304',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(463,4,'simple','7138563',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(464,4,'simple','1116758',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(465,4,'simple','1116759',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(466,4,'simple','1116763',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(467,4,'simple','1091110',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(468,4,'simple','1091115',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(469,4,'simple','1091111',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(470,4,'simple','1091113',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(471,4,'simple','1100998',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(472,4,'simple','7016397',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(473,4,'simple','1020426',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(474,4,'simple','1086698',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(475,4,'simple','7140372',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(476,4,'simple','1095810',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(477,4,'simple','1111015',0,0,'2022-05-13 09:42:21','2022-07-20 06:33:12'),(478,4,'simple','1111011',0,0,'2022-05-13 09:42:21','2022-07-20 06:33:12'),(479,4,'simple','1111013',0,0,'2022-05-13 09:42:21','2022-07-20 06:33:12'),(480,4,'simple','1049125',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(481,4,'simple','1080482',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(482,4,'simple','7114498',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(483,4,'simple','7117882',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(484,4,'simple','1078825',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(485,4,'simple','1059298',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(486,4,'simple','1116363',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(487,4,'simple','1053618',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(488,4,'simple','1056784',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(489,4,'simple','1081496',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(490,4,'simple','1056785',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(491,4,'simple','1056786',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(492,4,'simple','1056787',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(493,4,'simple','1083038',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(494,4,'simple','1083037',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(495,4,'simple','1083039',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(496,4,'simple','1083125',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(497,4,'simple','1083122',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(498,4,'simple','1083119',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:16'),(499,4,'simple','1083042',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(500,4,'simple','1083040',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(501,4,'simple','1083124',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(502,4,'simple','1083121',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(503,4,'simple','7123296',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(504,4,'simple','7123297',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(505,4,'simple','1056855',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(506,4,'simple','1056856',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(507,4,'simple','1056788',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(508,4,'simple','1083776',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(509,4,'simple','1085853',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(510,4,'simple','1113530',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(511,4,'simple','7043111',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(512,4,'simple','7041891',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(513,4,'simple','7043112',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(514,4,'simple','7123647',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(515,4,'simple','7123648',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(516,4,'simple','1039309',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(517,4,'simple','1069768',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(518,4,'simple','7016398',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(519,4,'simple','1037603',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(520,4,'simple','1121289',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(521,4,'simple','500038',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(522,4,'simple','1059576',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(523,4,'simple','1059574',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(524,4,'simple','1059572',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(525,4,'simple','1059571',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(526,4,'simple','1059569',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(527,4,'simple','1059568',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(528,4,'simple','1059562',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(529,4,'simple','1059561',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(530,4,'simple','1059559',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(531,4,'simple','1059557',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(532,4,'simple','1059555',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(533,4,'simple','1087276',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(534,4,'simple','1056859',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(535,4,'simple','1068955',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(536,4,'simple','1069096',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(537,4,'simple','1115358',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(538,4,'simple','7138877',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(539,4,'simple','1096750',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(540,4,'simple','1096458',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(541,4,'simple','1099451',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(542,4,'simple','1097763',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(543,4,'simple','1063550',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(544,4,'simple','1111817',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(545,4,'simple','1059551',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(546,4,'simple','7130970',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(547,4,'simple','1051285',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(548,4,'simple','1113367',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(549,4,'simple','1026876',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(550,4,'simple','1111486',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(551,4,'simple','1059548',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(552,4,'simple','7020204',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(553,4,'simple','1026861',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(554,4,'simple','1059546',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(555,4,'simple','1026868',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(556,4,'simple','1026877',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(557,4,'simple','1100682',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(558,4,'simple','1026870',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(559,4,'simple','1034459',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(560,4,'simple','1113303',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(561,4,'simple','1059545',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(562,4,'simple','1026864',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(563,4,'simple','1059544',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(564,4,'simple','1026866',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(565,4,'simple','1113366',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(566,4,'simple','7120934',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(567,4,'simple','1026881',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(568,4,'simple','1111489',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(569,4,'simple','1059543',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(570,4,'simple','1111485',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(571,4,'simple','1026862',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(572,4,'simple','1105658',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(573,4,'simple','1104970',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(574,4,'simple','7138749',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(575,4,'simple','1026878',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(576,4,'simple','1059540',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(577,4,'simple','1059541',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(578,4,'simple','86000166',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(579,4,'simple','86002096',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(580,4,'simple','86000463',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(581,4,'simple','1063572',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(582,4,'simple','1026869',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(583,4,'simple','1026867',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(584,4,'simple','1111490',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(585,4,'simple','1026879',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(586,4,'simple','1104968',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(587,4,'simple','1026871',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(588,4,'simple','1070533',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(589,4,'simple','1063577',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(590,4,'simple','1026872',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(591,4,'simple','1026873',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(592,4,'simple','1026874',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(593,4,'simple','1026875',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(594,4,'simple','1034097',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(595,4,'simple','1034098',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(596,4,'simple','1119709',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(597,4,'simple','1113368',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(598,4,'simple','7121650',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:17'),(599,4,'simple','1083139',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:18'),(600,4,'simple','1049423',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:18'),(601,4,'simple','1059538',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:18'),(602,4,'simple','1093557',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:18'),(603,4,'simple','1068921',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:18'),(604,4,'simple','1052030',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:18'),(605,4,'simple','1069113',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:18'),(606,4,'simple','1026863',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:18'),(607,4,'simple','1069115',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:18'),(608,4,'simple','1053403',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:18'),(609,4,'simple','1059536',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:18'),(610,4,'simple','1034471',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:18'),(611,4,'simple','7047855',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:18'),(612,4,'simple','1034483',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:18'),(613,4,'simple','1104129',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:18'),(614,4,'simple','1059534',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:18'),(615,4,'simple','1069112',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:18'),(616,4,'simple','1026865',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:18'),(617,4,'simple','7048014',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:18'),(618,4,'simple','1068918',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:18'),(619,4,'simple','1068920',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:18'),(620,4,'simple','1068917',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:18'),(621,4,'simple','1092630',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:18'),(622,4,'simple','1068655',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:18'),(623,4,'simple','7031858',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:18'),(624,4,'simple','1068656',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:18'),(625,4,'simple','1113369',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:18'),(626,4,'simple','7075664',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:18'),(627,4,'simple','1063534',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:18'),(628,4,'simple','1029759',0,0,'2022-05-13 09:42:21','2022-05-13 10:27:18'),(629,4,'simple','1053402',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(630,4,'simple','7127299',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(631,4,'simple','7104103',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(632,4,'simple','7086403',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(633,4,'simple','7086405',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(634,4,'simple','7086409',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(635,4,'simple','1027006',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(636,4,'simple','1059453',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(637,4,'simple','1056861',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(638,4,'simple','7123645',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(639,4,'simple','1059454',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(640,4,'simple','1081446',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(641,4,'simple','7122383',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(642,4,'simple','1081444',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(643,4,'simple','1056792',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(644,4,'simple','7122363',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(645,4,'simple','1113371',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(646,4,'simple','1113376',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(647,4,'simple','1113373',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(648,4,'simple','1113374',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(649,4,'simple','1059530',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(650,4,'simple','1059529',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(651,4,'simple','1059528',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(652,4,'simple','1059527',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(653,4,'simple','1113375',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(654,4,'simple','1095913',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(655,4,'simple','1059526',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(656,4,'simple','1059525',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(657,4,'simple','1059577',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(658,4,'simple','1116286',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(659,4,'simple','7086307',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(660,4,'simple','1114883',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(661,4,'simple','1043401',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(662,4,'simple','7105843',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(663,4,'simple','1128148',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(664,4,'simple','1081448',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(665,4,'simple','1081450',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(666,4,'simple','1081451',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(667,4,'simple','1059455',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(668,4,'simple','1056794',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(669,4,'simple','1036758',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(670,4,'simple','7061863',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(671,4,'simple','7086407',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(672,4,'simple','7086408',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(673,4,'simple','7104117',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(674,4,'simple','1081481',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(675,4,'simple','1081479',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(676,4,'simple','7122301',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(677,4,'simple','1019981',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(678,4,'simple','1056795',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(679,4,'simple','1056796',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(680,4,'simple','1056860',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(681,4,'simple','1056862',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(682,4,'simple','7122360',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(683,4,'simple','1056863',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(684,4,'simple','1056864',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(685,4,'simple','7026946',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(686,4,'simple','7026945',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(687,4,'simple','7128023',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(688,4,'simple','1056985',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(689,4,'simple','1056988',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(690,4,'simple','1056999',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(691,4,'simple','1057000',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(692,4,'simple','1056867',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(693,4,'simple','7039801',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(694,4,'simple','7052868',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(695,4,'simple','1096748',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(696,4,'simple','1096790',0,0,'2022-05-13 09:42:22','2022-07-20 06:33:07'),(697,4,'simple','1096791',0,0,'2022-05-13 09:42:22','2022-07-20 06:33:07'),(698,4,'simple','1035037',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:18'),(699,4,'simple','1035035',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(700,4,'simple','7022272',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(701,4,'simple','7098194',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(702,4,'simple','7045688',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(703,4,'simple','7131714',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(704,4,'simple','7098639',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(705,4,'simple','7008679',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(706,4,'simple','7010198',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(707,4,'simple','1045983',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(708,4,'simple','1046031',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(709,4,'simple','7114116',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(710,4,'simple','7088162',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(711,4,'simple','7129840',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(712,4,'simple','1046165',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(713,4,'simple','7009700',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(714,4,'simple','7007416',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(715,4,'simple','901034',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(716,4,'simple','30002266',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(717,4,'simple','1050300',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(718,4,'simple','1050760',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(719,4,'simple','1077786',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(720,4,'simple','7108007',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(721,4,'simple','7114503',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(722,4,'simple','7139122',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(723,4,'simple','7015967',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(724,4,'simple','7016457',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(725,4,'simple','7100074',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(726,4,'simple','1035453',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(727,4,'simple','7042471',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(728,4,'simple','7042856',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(729,4,'simple','7057515',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(730,4,'simple','7057515-L',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(731,4,'simple','7099421',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(732,4,'simple','7128019',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(733,4,'simple','7058045',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(734,4,'simple','1053531',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(735,4,'simple','1053523',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(736,4,'simple','1116287',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(737,4,'simple','1050761',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(738,4,'simple','1091523',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(739,4,'simple','1096762',0,0,'2022-05-13 09:42:22','2022-07-20 06:33:07'),(740,4,'simple','1030042',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(741,4,'simple','1030038',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(742,4,'simple','7073619',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(743,4,'simple','1030032',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(744,4,'simple','1030045',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(745,4,'simple','7010245',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(746,4,'simple','7042855',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(747,4,'simple','1057001',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(748,4,'simple','1057003',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(749,4,'simple','1056797',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(750,4,'simple','7123298',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(751,4,'simple','1056798',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(752,4,'simple','1056789',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(753,4,'simple','1056868',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(754,4,'simple','1056871',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(755,4,'simple','1056872',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(756,4,'simple','1056790',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(757,4,'simple','1056791',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(758,4,'simple','1056912',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(759,4,'simple','1056913',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(760,4,'simple','1056914',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(761,4,'simple','1081485',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(762,4,'simple','1081487',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(763,4,'simple','1056916',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(764,4,'simple','1056917',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(765,4,'simple','1056040',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(766,4,'simple','1056041',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(767,4,'simple','1025342',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(768,4,'simple','7114502',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(769,4,'simple','7133004',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(770,4,'simple','1056042',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(771,4,'simple','1056043',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(772,4,'simple','7122364',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(773,4,'simple','7104104',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(774,4,'simple','7007433',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(775,4,'simple','1056044',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(776,4,'simple','1056045',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(777,4,'simple','1101375',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(778,4,'simple','1101330',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(779,4,'simple','1100498',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(780,4,'simple','7086406',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(781,4,'simple','7026949',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(782,4,'simple','1115646',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(783,4,'simple','1035041',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(784,4,'simple','7134704',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(785,4,'simple','1101331',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(786,4,'simple','1101329',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(787,4,'simple','1101484',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(788,4,'simple','1101482',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(789,4,'simple','1101469',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(790,4,'simple','7073521',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(791,4,'simple','1031205',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(792,4,'simple','1092132',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(793,4,'simple','1033491',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(794,4,'simple','7135812',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(795,4,'simple','7108384',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(796,4,'simple','1078819',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(797,4,'simple','1114644',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(798,4,'simple','7126482',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:19'),(799,4,'simple','1068654',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(800,4,'simple','7020674',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(801,4,'simple','901037',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(802,4,'simple','7016381',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(803,4,'simple','7000500',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(804,4,'simple','901092',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(805,4,'simple','901090',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(806,4,'simple','7043332',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(807,4,'simple','901036',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(808,4,'simple','7047153',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(809,4,'simple','7002246',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(810,4,'simple','7023792',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(811,4,'simple','7085265',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(812,4,'simple','7010196',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(813,4,'simple','901159',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(814,4,'simple','901065',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(815,4,'simple','7114099',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(816,4,'simple','7024058',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(817,4,'simple','7016918',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(818,4,'simple','7114134',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(819,4,'simple','7096874',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(820,4,'simple','7063771',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(821,4,'simple','7127916',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(822,4,'simple','7139114',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(823,4,'simple','1039597',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(824,4,'simple','1046169',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(825,4,'simple','7048175',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(826,4,'simple','901113',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(827,4,'simple','900864',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(828,4,'simple','1041837',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(829,4,'simple','1110436',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(830,4,'simple','7023483',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(831,4,'simple','1123951',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(832,4,'simple','1029100',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(833,4,'simple','1041375',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(834,4,'simple','1050758',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(835,4,'simple','1073337',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(836,4,'simple','7035098',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(837,4,'simple','7049388',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(838,4,'simple','7059000',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(839,4,'simple','7063674',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(840,4,'simple','07082129-01',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(841,4,'simple','7082129',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(842,4,'simple','7089527',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(843,4,'simple','07096060-02',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(844,4,'simple','7098505',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(845,4,'simple','7108660',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(846,4,'simple','7115975',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(847,4,'simple','7140395',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(848,4,'simple','30002619',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(849,4,'simple','7010441',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(850,4,'simple','1031204',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(851,4,'simple','1051160',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(852,4,'simple','1047239',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(853,4,'simple','1046400',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(854,4,'simple','7026243',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(855,4,'simple','901066',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(856,4,'simple','901072',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(857,4,'simple','7020548',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(858,4,'simple','7020544',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(859,4,'simple','7020541',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(860,4,'simple','1097600',0,0,'2022-05-13 09:42:22','2022-07-20 06:33:04'),(861,4,'simple','1101486',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(862,4,'simple','1101478',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(863,4,'simple','1101474',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(864,4,'simple','1101376',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(865,4,'simple','1101373',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(866,4,'simple','1101369',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(867,4,'simple','1101471',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(868,4,'simple','1101332',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(869,4,'simple','1101816',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(870,4,'simple','1101815',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(871,4,'simple','1101377',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(872,4,'simple','1101823',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(873,4,'simple','1101819',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(874,4,'simple','1101821',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(875,4,'simple','1101476',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(876,4,'simple','1101379',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(877,4,'simple','1101812',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(878,4,'simple','1101818',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(879,4,'simple','1101480',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(880,4,'simple','1101328',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(881,4,'simple','1101477',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(882,4,'simple','1101485',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(883,4,'simple','1101470',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(884,4,'simple','1115798',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(885,4,'simple','1029006',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(886,4,'simple','1082863',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(887,4,'simple','1021118',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(888,4,'simple','7134386',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(889,4,'simple','7098571',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(890,4,'simple','1092140',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(891,4,'simple','7098570',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(892,4,'simple','1116561',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(893,4,'simple','7138593',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(894,4,'simple','1027098',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(895,4,'simple','1088036',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(896,4,'simple','1033179',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(897,4,'simple','7073835',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(898,4,'simple','7004499',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:20'),(899,4,'simple','7029328',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(900,4,'simple','1032326',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(901,4,'simple','7001321',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(902,4,'simple','7007237',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(903,4,'simple','7083071',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(904,4,'simple','7001322',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(905,4,'simple','1076212',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(906,4,'simple','7013307',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(907,4,'simple','7008896',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(908,4,'simple','1027234',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(909,4,'simple','1028402',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(910,4,'simple','7126565',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(911,4,'simple','1101457',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(912,4,'simple','1080127',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(913,4,'simple','7115287',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(914,4,'simple','1091288',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(915,4,'simple','1043793',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(916,4,'simple','1091286',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(917,4,'simple','1091141',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(918,4,'simple','7126765',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(919,4,'simple','74272132',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(920,4,'simple','1122270',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(921,4,'simple','7114689',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(922,4,'simple','7135248',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(923,4,'simple','1091218',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(924,4,'simple','7115761',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(925,4,'simple','1099283',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(926,4,'simple','1091666',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(927,4,'simple','1091569',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(928,4,'simple','1091278',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(929,4,'simple','7105844',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(930,4,'simple','1092844',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(931,4,'simple','1096623',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(932,4,'simple','7128249',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(933,4,'simple','1091161',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(934,4,'simple','1023711',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(935,4,'simple','7120135',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(936,4,'simple','1091157',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(937,4,'simple','1091159',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(938,4,'simple','1091217',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(939,4,'simple','1064199',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(940,4,'simple','1073483',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(941,4,'simple','16001234-01',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(942,4,'simple','16001235-01',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(943,4,'simple','7087599',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(944,4,'simple','1064651',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(945,4,'simple','7029259',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(946,4,'simple','7117967',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(947,4,'simple','1021387',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(948,4,'simple','1029507',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(949,4,'simple','7067871',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(950,4,'simple','1104777',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(951,4,'simple','1033400',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(952,4,'simple','1040109',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(953,4,'simple','1033418',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(954,4,'simple','7080654',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(955,4,'simple','7114229',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(956,4,'simple','1117031',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(957,4,'simple','1116983',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(958,4,'simple','1101019',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(959,4,'simple','16000515-01',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(960,4,'simple','1097697',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(961,4,'simple','1047269',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(962,4,'simple','1054000',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(963,4,'simple','1053999',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(964,4,'simple','7114173',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(965,4,'simple','7115494',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(966,4,'simple','1093690',0,0,'2022-05-13 09:42:22','2022-07-20 06:33:12'),(967,4,'simple','7088679',0,0,'2022-05-13 09:42:22','2022-08-08 12:28:29'),(968,4,'simple','42000625-01',0,0,'2022-05-13 09:42:22','2022-07-20 06:33:10'),(969,4,'simple','42000622-01',0,0,'2022-05-13 09:42:22','2022-07-20 06:33:09'),(970,4,'simple','42000619-01',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(971,4,'simple','7088675',0,0,'2022-05-13 09:42:22','2022-07-20 06:33:04'),(972,4,'simple','42000623-01',0,0,'2022-05-13 09:42:22','2022-07-20 06:33:09'),(973,4,'simple','1055982',0,0,'2022-05-13 09:42:22','2022-07-20 06:33:09'),(974,4,'simple','7135155',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(975,4,'simple','7044666',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(976,4,'simple','1049482',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(977,4,'simple','7131993',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(978,4,'simple','901220',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(979,4,'simple','7036235',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(980,4,'simple','1098713',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(981,4,'simple','1019583-01',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(982,4,'simple','1019583-02',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(983,4,'simple','1019963',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(984,4,'simple','1093563',0,0,'2022-05-13 09:42:22','2022-06-24 07:19:12'),(985,4,'simple','1031970',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(986,4,'simple','7115286',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(987,4,'simple','1020668',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(988,4,'simple','1020948-05',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(989,4,'simple','1021809-05',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(990,4,'simple','7120053',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(991,4,'simple','7120136',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(992,4,'simple','1059016',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(993,4,'simple','1056757',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(994,4,'simple','7088638',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:21'),(995,4,'simple','42000624-01',0,0,'2022-05-13 09:42:22','2022-08-08 12:28:29'),(996,4,'simple','1056029',0,0,'2022-05-13 09:42:22','2022-08-08 12:28:29'),(997,4,'simple','1049126',0,0,'2022-05-13 09:42:22','2022-06-24 07:19:11'),(998,4,'simple','1049319',0,0,'2022-05-13 09:42:22','2022-07-20 06:33:01'),(999,4,'simple','1076155',0,0,'2022-05-13 09:42:22','2022-08-08 12:28:29'),(1000,4,'simple','1033582',0,0,'2022-05-13 09:42:22','2022-08-08 12:28:29'),(1001,4,'simple','1049320',0,0,'2022-05-13 09:42:22','2022-07-20 06:33:01'),(1002,4,'simple','1033577',0,0,'2022-05-13 09:42:22','2022-07-20 06:33:04'),(1003,4,'simple','1049321',0,0,'2022-05-13 09:42:22','2022-07-20 06:33:01'),(1004,4,'simple','1033495',0,0,'2022-05-13 09:42:22','2022-07-20 06:33:01'),(1005,4,'simple','1049322',0,0,'2022-05-13 09:42:22','2022-07-20 06:33:01'),(1006,4,'simple','1049323',0,0,'2022-05-13 09:42:22','2022-07-20 06:33:01'),(1007,4,'simple','1033578',0,0,'2022-05-13 09:42:22','2022-07-20 06:33:04'),(1008,4,'simple','1076156',0,0,'2022-05-13 09:42:22','2022-07-20 06:33:03'),(1009,4,'simple','1033490',0,0,'2022-05-13 09:42:22','2022-07-20 06:33:10'),(1010,4,'simple','1080561',0,0,'2022-05-13 09:42:22','2022-08-08 12:28:29'),(1011,4,'simple','1049324',0,0,'2022-05-13 09:42:22','2022-07-20 06:33:01'),(1012,4,'simple','1080562',0,0,'2022-05-13 09:42:22','2022-07-20 06:33:03'),(1013,4,'simple','1076157',0,0,'2022-05-13 09:42:22','2022-08-08 12:28:29'),(1014,4,'simple','1080563',0,0,'2022-05-13 09:42:22','2022-07-20 06:33:03'),(1015,4,'simple','1041316',0,0,'2022-05-13 09:42:22','2022-07-20 06:33:10'),(1016,4,'simple','1041317',0,0,'2022-05-13 09:42:22','2022-07-20 06:33:10'),(1017,4,'simple','1111194',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1018,4,'simple','1093723',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1019,4,'simple','1093915',0,0,'2022-05-13 09:42:22','2022-07-20 06:33:09'),(1020,4,'simple','1093917',0,0,'2022-05-13 09:42:22','2022-07-20 06:33:12'),(1021,4,'simple','1091078',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1022,4,'simple','1054149',0,0,'2022-05-13 09:42:22','2022-07-20 06:33:12'),(1023,4,'simple','42000626-01',0,0,'2022-05-13 09:42:22','2022-07-20 06:33:10'),(1024,4,'simple','7088699',0,0,'2022-05-13 09:42:22','2022-07-20 06:33:10'),(1025,4,'simple','1028216-06',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1026,4,'simple','1028454-04',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1027,4,'simple','1119712',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1028,4,'simple','1091664',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1029,4,'simple','1043645',0,0,'2022-05-13 09:42:22','2022-07-20 06:33:12'),(1030,4,'simple','1054150',0,0,'2022-05-13 09:42:22','2022-07-20 06:33:01'),(1031,4,'simple','1030422-02',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1032,4,'simple','1030423-03',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1033,4,'simple','1066873',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1034,4,'simple','7131048',0,0,'2022-05-13 09:42:22','2022-07-20 06:33:09'),(1035,4,'simple','1031245',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1036,4,'simple','1031247',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1037,4,'simple','1031248',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1038,4,'simple','1031250',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1039,4,'simple','1031253',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1040,4,'simple','1031255',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1041,4,'simple','1031256',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1042,4,'simple','1031258',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1043,4,'simple','1031259',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1044,4,'simple','1031261',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1045,4,'simple','1031266-01',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1046,4,'simple','1031269',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1047,4,'simple','1031270-01',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1048,4,'simple','1031273',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1049,4,'simple','1031274',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1050,4,'simple','1031284',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1051,4,'simple','1032260',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1052,4,'simple','1032498-01',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1053,4,'simple','1032501-01',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1054,4,'simple','1032577-01',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1055,4,'simple','1032582-01',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1056,4,'simple','1032584-02',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1057,4,'simple','1032589',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1058,4,'simple','1066390',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1059,4,'simple','1035533',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1060,4,'simple','1035708-02',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1061,4,'simple','1099460',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1062,4,'simple','1053134',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1063,4,'simple','1036395-01',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1064,4,'simple','1036398-01',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1065,4,'simple','1036409-01',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1066,4,'simple','1036417-03',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1067,4,'simple','1036474-03',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1068,4,'simple','1036476-03',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1069,4,'simple','1037419',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1070,4,'simple','1037422',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1071,4,'simple','1037981',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1072,4,'simple','1039208-04',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1073,4,'simple','1039209-03',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1074,4,'simple','1043795',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1075,4,'simple','1044926',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1076,4,'simple','1044927',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1077,4,'simple','1040392',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1078,4,'simple','1111401',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1079,4,'simple','1125087',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1080,4,'simple','1115670',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1081,4,'simple','1115666',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1082,4,'simple','1115669',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1083,4,'simple','1115701',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1084,4,'simple','1115671',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1085,4,'simple','104319',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1086,4,'simple','1086860',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1087,4,'simple','1047171-01',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1088,4,'simple','1047845',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1089,4,'simple','1047986',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1090,4,'simple','1048338-04',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1091,4,'simple','1048391',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1092,4,'simple','1048920',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1093,4,'simple','1101006',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1094,4,'simple','1055258',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1095,4,'simple','1064213',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1096,4,'simple','1055259',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1097,4,'simple','1051371',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1098,4,'simple','1052275',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:22'),(1099,4,'simple','1052276',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1100,4,'simple','1044187',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1101,4,'simple','1053601',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1102,4,'simple','1053603',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1103,4,'simple','1053605',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1104,4,'simple','1053608-01',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1105,4,'simple','1053610',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1106,4,'simple','1114051',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1107,4,'simple','1114053',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1108,4,'simple','1114056',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1109,4,'simple','1114049',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1110,4,'simple','1114047',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1111,4,'simple','1114044',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1112,4,'simple','1114045',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1113,4,'simple','1114043',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1114,4,'simple','1054227',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1115,4,'simple','1114048',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1116,4,'simple','1114042',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1117,4,'simple','7100887',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1118,4,'simple','7008989',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1119,4,'simple','7120893',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1120,4,'simple','1119232',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1121,4,'simple','1114807',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1122,4,'simple','1055260',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1123,4,'simple','1064214',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1124,4,'simple','1064215',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1125,4,'simple','7026743',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1126,4,'simple','1060739',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1127,4,'simple','1113888',0,0,'2022-05-13 09:42:22','2022-07-20 06:33:11'),(1128,4,'simple','1084495',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1129,4,'simple','1111617',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1130,4,'simple','1063535',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1131,4,'simple','1111615',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1132,4,'simple','11000598-01',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1133,4,'simple','1065843',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1134,4,'simple','7130676',0,0,'2022-05-13 09:42:22','2022-07-20 06:33:04'),(1135,4,'simple','7117118',0,0,'2022-05-13 09:42:22','2022-07-20 06:33:01'),(1136,4,'simple','7122777',0,0,'2022-05-13 09:42:22','2022-07-20 06:33:04'),(1137,4,'simple','7122773',0,0,'2022-05-13 09:42:22','2022-07-20 06:33:09'),(1138,4,'simple','7117119',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1139,4,'simple','1070025',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1140,4,'simple','6040218',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1141,4,'simple','7132185',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1142,4,'simple','1052245',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1143,4,'simple','7132187',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1144,4,'simple','1052267',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1145,4,'simple','7132188',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1146,4,'simple','7132186',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1147,4,'simple','1019873',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1148,4,'simple','7132174',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1149,4,'simple','1037021',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1150,4,'simple','7130670',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1151,4,'simple','7034519',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1152,4,'simple','7132192',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1153,4,'simple','900671',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1154,4,'simple','1028366',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1155,4,'simple','1097648',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1156,4,'simple','1081593',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1157,4,'simple','1084436',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1158,4,'simple','1085611',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1159,4,'simple','1086692',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1160,4,'simple','1086839',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1161,4,'simple','1117774',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1162,4,'simple','7004108',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1163,4,'simple','1094262',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1164,4,'simple','1095224',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1165,4,'simple','7138784',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1166,4,'simple','1080495',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1167,4,'simple','1080151',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1168,4,'simple','7002196',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1169,4,'simple','7026253',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1170,4,'simple','1069770',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1171,4,'simple','1110482',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1172,4,'simple','7130428',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1173,4,'simple','7130430',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1174,4,'simple','7130431',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1175,4,'simple','7130429',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1176,4,'simple','7130432',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1177,4,'simple','7002121',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1178,4,'simple','1026190',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1179,4,'simple','7130406',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1180,4,'simple','1031046',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1181,4,'simple','1031044',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1182,4,'simple','1031043',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1183,4,'simple','1031033',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1184,4,'simple','1031045',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1185,4,'simple','1117777',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1186,4,'simple','1087911',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1187,4,'simple','1087994',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1188,4,'simple','1092110',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1189,4,'simple','11000077-01',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1190,4,'simple','11000389-01',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1191,4,'simple','1046659',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1192,4,'simple','1029527',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1193,4,'simple','7048580',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1194,4,'simple','1029526',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1195,4,'simple','1106994',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1196,4,'simple','1113941',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1197,4,'simple','1101020',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1198,4,'simple','7097091',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:24'),(1199,4,'simple','1041992',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:25'),(1200,4,'simple','1116562',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:25'),(1201,4,'simple','1110961',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:25'),(1202,4,'simple','1110965',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:25'),(1203,4,'simple','1110967',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:25'),(1204,4,'simple','1110969',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:25'),(1205,4,'simple','1110973',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:25'),(1206,4,'simple','1110974',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:25'),(1207,4,'simple','1110978',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:25'),(1208,4,'simple','1111089',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:25'),(1209,4,'simple','1111202',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:25'),(1210,4,'simple','1111697',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:25'),(1211,4,'simple','1111700',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:25'),(1212,4,'simple','1112028-01',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:25'),(1213,4,'simple','1112654',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:25'),(1214,4,'simple','1112760',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:25'),(1215,4,'simple','1037245',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:25'),(1216,4,'simple','1037244',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:25'),(1217,4,'simple','1037243',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:25'),(1218,4,'simple','1037246',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:25'),(1219,4,'simple','1037242',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:25'),(1220,4,'simple','1113570',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:25'),(1221,4,'simple','1113572',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:25'),(1222,4,'simple','1113593-01',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:25'),(1223,4,'simple','1114241',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:25'),(1224,4,'simple','1114258',0,0,'2022-05-13 09:42:22','2022-07-20 06:33:13'),(1225,4,'simple','1114616',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:25'),(1226,4,'simple','1114617',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:25'),(1227,4,'simple','1114618',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:25'),(1228,4,'simple','1114619',0,0,'2022-05-13 09:42:22','2022-05-13 10:27:25'),(1229,4,'simple','1114620',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1230,4,'simple','1114621',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1231,4,'simple','1114622',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1232,4,'simple','1114623',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1233,4,'simple','1115625',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1234,4,'simple','1115626',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1235,4,'simple','1115627',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1236,4,'simple','1115629',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1237,4,'simple','1115631',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1238,4,'simple','1115632',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1239,4,'simple','1115633',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1240,4,'simple','1115635',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1241,4,'simple','1115636',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1242,4,'simple','1115637',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1243,4,'simple','1115638',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1244,4,'simple','1115639',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1245,4,'simple','1115640',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1246,4,'simple','1115641',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1247,4,'simple','1115698',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1248,4,'simple','7005264',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1249,4,'simple','1118080',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1250,4,'simple','1088423',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1251,4,'simple','1021307',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1252,4,'simple','1034949',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1253,4,'simple','1055261',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1254,4,'simple','1055262',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1255,4,'simple','1064216',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1256,4,'simple','1064217',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1257,4,'simple','1055264',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1258,4,'simple','1070743',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1259,4,'simple','1111420',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1260,4,'simple','1113313',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1261,4,'simple','7106509',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1262,4,'simple','7106510',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1263,4,'simple','1070733',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1264,4,'simple','1113314',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1265,4,'simple','500037',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1266,4,'simple','500036',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1267,4,'simple','1024824',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1268,4,'simple','1055265',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1269,4,'simple','1064183',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1270,4,'simple','1024123',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1271,4,'simple','1024124',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1272,4,'simple','7040843',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1273,4,'simple','1118437',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1274,4,'simple','1097206',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1275,4,'simple','1085164',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1276,4,'simple','1021385',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1277,4,'simple','1119038',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1278,4,'simple','1118966',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1279,4,'simple','1118926',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1280,4,'simple','1119036',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1281,4,'simple','1119037',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1282,4,'simple','1118965',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1283,4,'simple','1113409',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1284,4,'simple','7088712',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1285,4,'simple','7104146',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1286,4,'simple','1103164',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1287,4,'simple','1103168',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1288,4,'simple','1105792',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1289,4,'simple','1077583',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1290,4,'simple','1076158',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1291,4,'simple','1091924',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1292,4,'simple','7123343',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1293,4,'simple','7123346',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1294,4,'simple','1086009',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1295,4,'simple','7106508',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1296,4,'simple','7106506',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1297,4,'simple','1115356',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1298,4,'simple','1115612',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:25'),(1299,4,'simple','1115613',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1300,4,'simple','7035907',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1301,4,'simple','1076159',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1302,4,'simple','1064218',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1303,4,'simple','1064219',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1304,4,'simple','1064220',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1305,4,'simple','1064221',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1306,4,'simple','1064222',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1307,4,'simple','1064223',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1308,4,'simple','1055266',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1309,4,'simple','1055237',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1310,4,'simple','1055238',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1311,4,'simple','1055239',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1312,4,'simple','1055240',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1313,4,'simple','1048729',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1314,4,'simple','1093934',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1315,4,'simple','7131775',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1316,4,'simple','7133776',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1317,4,'simple','1029028',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1318,4,'simple','1115614',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1319,4,'simple','1115615',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1320,4,'simple','1071828',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1321,4,'simple','1096517',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1322,4,'simple','1119347',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1323,4,'simple','1119345',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1324,4,'simple','1119338',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1325,4,'simple','1096363',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1326,4,'simple','1096390',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1327,4,'simple','1029497',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1328,4,'simple','1022137',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1329,4,'simple','7042270',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1330,4,'simple','1046885',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1331,4,'simple','1069771',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1332,4,'simple','1069772',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1333,4,'simple','1100512',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1334,4,'simple','1100504',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1335,4,'simple','1088032',0,0,'2022-05-13 09:42:23','2022-06-24 07:19:12'),(1336,4,'simple','7036245',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1337,4,'simple','12000046-06',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1338,4,'simple','12000050-05',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1339,4,'simple','12000051-03',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1340,4,'simple','12000052-04',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1341,4,'simple','12000053-03',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1342,4,'simple','12000057-02',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1343,4,'simple','12000058-04',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1344,4,'simple','12000062-04',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1345,4,'simple','12000062-05',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1346,4,'simple','12000083-04',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1347,4,'simple','12000105-03',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1348,4,'simple','12000130-01',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1349,4,'simple','12000130-03',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1350,4,'simple','12000130-04',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1351,4,'simple','12000135-02',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1352,4,'simple','12000136-05',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1353,4,'simple','12000139-03',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1354,4,'simple','12000142-04',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1355,4,'simple','12000144-04',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1356,4,'simple','12000145-05',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1357,4,'simple','12000146-04',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1358,4,'simple','12000147-04',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1359,4,'simple','12000149-02',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1360,4,'simple','12000149-03',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1361,4,'simple','12000151-02',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1362,4,'simple','12000314-01',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1363,4,'simple','12000321-05',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1364,4,'simple','12000321-06',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1365,4,'simple','12000321-07',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1366,4,'simple','12000325-01',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1367,4,'simple','12000345-01',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1368,4,'simple','12000346-01',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1369,4,'simple','12000347-02',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1370,4,'simple','12000348-06',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1371,4,'simple','12000378-03',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1372,4,'simple','7088657',0,0,'2022-05-13 09:42:23','2022-08-08 12:28:29'),(1373,4,'simple','7140622',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1374,4,'simple','1115616',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1375,4,'simple','7088695',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:10'),(1376,4,'simple','7131052',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:11'),(1377,4,'simple','7011751',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1378,4,'simple','7087049',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1379,4,'simple','7015045',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1380,4,'simple','7054509',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1381,4,'simple','1048725',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1382,4,'simple','1051846',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1383,4,'simple','1051263',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1384,4,'simple','7139016',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1385,4,'simple','901041',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1386,4,'simple','1035793',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1387,4,'simple','1110708',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1388,4,'simple','7003763',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1389,4,'simple','7076564',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1390,4,'simple','1059193',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1391,4,'simple','1064224',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1392,4,'simple','1055242',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1393,4,'simple','7103342',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1394,4,'simple','13000163-01',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1395,4,'simple','7047431',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1396,4,'simple','7034541',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1397,4,'simple','1114433',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1398,4,'simple','1067141',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:26'),(1399,4,'simple','1101011',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1400,4,'simple','1064225',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1401,4,'simple','1064226',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1402,4,'simple','1055243',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1403,4,'simple','1055244',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1404,4,'simple','7085272',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1405,4,'simple','7105122',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1406,4,'simple','7140690',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1407,4,'simple','7140691',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1408,4,'simple','1092811',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1409,4,'simple','7124474',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1410,4,'simple','7124477',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1411,4,'simple','1080268',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1412,4,'simple','1104832',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1413,4,'simple','7000539',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1414,4,'simple','1106968',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1415,4,'simple','7132780',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1416,4,'simple','1117468',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1417,4,'simple','1064211',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1418,4,'simple','7007304',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1419,4,'simple','1084498',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1420,4,'simple','7088697',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1421,4,'simple','7088696',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:08'),(1422,4,'simple','1114470',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1423,4,'simple','1097955',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1424,4,'simple','1067142',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1425,4,'simple','1067145',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1426,4,'simple','1069773',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1427,4,'simple','1033599',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1428,4,'simple','1029041',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1429,4,'simple','1093518',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:04'),(1430,4,'simple','7088680',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:02'),(1431,4,'simple','7088698',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:03'),(1432,4,'simple','7088678',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:03'),(1433,4,'simple','1054151',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:02'),(1434,4,'simple','1085502',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1435,4,'simple','7067350',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1436,4,'simple','7131940-M',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1437,4,'simple','1093519',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:04'),(1438,4,'simple','1119713',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1439,4,'simple','1119714',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1440,4,'simple','1120096',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1441,4,'simple','1120097',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1442,4,'simple','1080074',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1443,4,'simple','7121336',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1444,4,'simple','1052410',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1445,4,'simple','1054274',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1446,4,'simple','7015145',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1447,4,'simple','1028457-05',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1448,4,'simple','1120095',0,0,'2022-05-13 09:42:23','2022-08-08 12:28:29'),(1449,4,'simple','1121249',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1450,4,'simple','1120863',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1451,4,'simple','7085131',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1452,4,'simple','7085129',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1453,4,'simple','1052374',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1454,4,'simple','1116563',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1455,4,'simple','1116564',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1456,4,'simple','1116565',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1457,4,'simple','7124476',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1458,4,'simple','7087714',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1459,4,'simple','7030699',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1460,4,'simple','7049922',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1461,4,'simple','1101834',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1462,4,'simple','1100574',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1463,4,'simple','7108527',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1464,4,'simple','7010393',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1465,4,'simple','7091775',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1466,4,'simple','1106528',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1467,4,'simple','7038476',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1468,4,'simple','1064281',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1469,4,'simple','1064227',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1470,4,'simple','7065781',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:08'),(1471,4,'simple','1097620',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:07'),(1472,4,'simple','1110886',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:08'),(1473,4,'simple','1097623',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:04'),(1474,4,'simple','1080425',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1475,4,'simple','1024921',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1476,4,'simple','1030622',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1477,4,'simple','1021268',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1478,4,'simple','7036352',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1479,4,'simple','7131952',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1480,4,'simple','7132047',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1481,4,'simple','1115667',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1482,4,'simple','1071890',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1483,4,'simple','1115603',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1484,4,'simple','1100429',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1485,4,'simple','1064228',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1486,4,'simple','1055245',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1487,4,'simple','1064229',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1488,4,'simple','1120098',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1489,4,'simple','1120103',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1490,4,'simple','1020347',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1491,4,'simple','1106655',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1492,4,'simple','1067147',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1493,4,'simple','1098087',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1494,4,'simple','1098083',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1495,4,'simple','1088454',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1496,4,'simple','13000341-01',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1497,4,'simple','1064230',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1498,4,'simple','1055248',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:27'),(1499,4,'simple','1055249',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1500,4,'simple','1115605',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1501,4,'simple','1088323',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1502,4,'simple','7078828',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1503,4,'simple','1113298',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1504,4,'simple','7074771',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1505,4,'simple','1030301',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1506,4,'simple','30001152-001',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1507,4,'simple','30001152-002',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1508,4,'simple','30001152-003',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1509,4,'simple','30001152-004',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1510,4,'simple','30001152-005',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1511,4,'simple','30001152-006',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1512,4,'simple','30001152-007',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1513,4,'simple','30001152-008',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1514,4,'simple','30001152-009',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1515,4,'simple','30001152-010',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1516,4,'simple','30001152-011',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1517,4,'simple','30001152-012',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1518,4,'simple','30001152-013',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1519,4,'simple','30001152-014',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1520,4,'simple','30001152-015',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1521,4,'simple','30001152-016',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1522,4,'simple','30001152-017',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1523,4,'simple','30001152-018',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1524,4,'simple','30001152-019',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1525,4,'simple','30001152-020',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1526,4,'simple','30001152-021',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1527,4,'simple','30001152-022',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1528,4,'simple','30001152-023',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1529,4,'simple','30001152-024',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1530,4,'simple','30001152-025',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1531,4,'simple','30001152-026',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1532,4,'simple','30001152-027',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1533,4,'simple','30001152-028',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1534,4,'simple','30001152-029',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1535,4,'simple','30001152-030',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1536,4,'simple','30001152-031',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1537,4,'simple','30001152-032',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1538,4,'simple','30001152-033',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1539,4,'simple','30001152-034',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1540,4,'simple','30001152-035',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1541,4,'simple','30001152-036',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1542,4,'simple','30001152-037',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1543,4,'simple','30001152-038',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1544,4,'simple','30001152-039',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1545,4,'simple','30001152-040',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1546,4,'simple','30001152-041',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1547,4,'simple','30001152-042',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1548,4,'simple','30001152-043',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1549,4,'simple','30001152-044',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1550,4,'simple','30001152-045',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1551,4,'simple','30001152-046',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1552,4,'simple','30001152-047',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1553,4,'simple','30001152-048',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1554,4,'simple','30001152-049',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1555,4,'simple','30001152-050',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1556,4,'simple','30001152-051',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1557,4,'simple','30001152-052',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1558,4,'simple','30001152-053',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1559,4,'simple','30001152-054',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1560,4,'simple','30001152-055',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1561,4,'simple','30001152-056',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1562,4,'simple','30001152-057',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1563,4,'simple','30001152-058',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1564,4,'simple','30001152-059',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1565,4,'simple','30001152-060',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1566,4,'simple','30001152-061',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1567,4,'simple','30001152-062',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1568,4,'simple','30001152-063',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1569,4,'simple','30001152-064',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1570,4,'simple','30001152-065',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1571,4,'simple','30001152-066',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1572,4,'simple','30001152-067',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1573,4,'simple','30001152-068',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1574,4,'simple','30001152-069',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1575,4,'simple','30001152-070',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1576,4,'simple','30001152-071',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1577,4,'simple','30001152-072',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1578,4,'simple','30001152-073',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1579,4,'simple','30001152-074',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1580,4,'simple','30001152-075',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1581,4,'simple','30001152-076',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1582,4,'simple','30001152-077',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1583,4,'simple','30001152-078',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1584,4,'simple','30001152-079',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1585,4,'simple','30001152-080',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1586,4,'simple','30001152-081',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1587,4,'simple','30001152-082',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1588,4,'simple','30001152-083',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1589,4,'simple','30001152-084',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1590,4,'simple','30001152-085',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1591,4,'simple','30001152-086',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1592,4,'simple','30001152-087',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1593,4,'simple','30001152-088',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1594,4,'simple','30001152-089',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1595,4,'simple','30001152-090',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1596,4,'simple','30001152-091',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1597,4,'simple','30001152-092',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1598,4,'simple','30001152-093',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:28'),(1599,4,'simple','30001152-094',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1600,4,'simple','30001152-095',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1601,4,'simple','30001152-096',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1602,4,'simple','30001152-097',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1603,4,'simple','30001152-098',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1604,4,'simple','30001152-099',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1605,4,'simple','30001152-100',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1606,4,'simple','30001152-101',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1607,4,'simple','30001152-102',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1608,4,'simple','30001152-103',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1609,4,'simple','30001152-104',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1610,4,'simple','1110888',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1611,4,'simple','1110889',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1612,4,'simple','1115355',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1613,4,'simple','1115606',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1614,4,'simple','7090479',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1615,4,'simple','7108040',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1616,4,'simple','1116489',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:12'),(1617,4,'simple','1115764',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:13'),(1618,4,'simple','1116313-RO',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:08'),(1619,4,'simple','1116313-T',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1620,4,'simple','1116315-RO',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:08'),(1621,4,'simple','1116315-T',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1622,4,'simple','7120187',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:05'),(1623,4,'simple','7120188',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:05'),(1624,4,'simple','1110890',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1625,4,'simple','7043215',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1626,4,'simple','1115325',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:12'),(1627,4,'simple','7043217',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1628,4,'simple','1110891',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1629,4,'simple','7043216',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1630,4,'simple','1110903',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1631,4,'simple','1064212',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1632,4,'simple','7049663',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1633,4,'simple','1041307',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1634,4,'simple','7115595',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1635,4,'simple','7115596',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1636,4,'simple','1115607',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1637,4,'simple','1064203',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1638,4,'simple','7139759',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1639,4,'simple','7139760',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1640,4,'simple','7139761',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1641,4,'simple','7139762',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1642,4,'simple','1117467',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1643,4,'simple','7013271',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1644,4,'simple','1103152',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1645,4,'simple','1103154',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1646,4,'simple','1115354',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1647,4,'simple','1115353',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1648,4,'simple','1115361',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:09'),(1649,4,'simple','7124478',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1650,4,'simple','7047616',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1651,4,'simple','7088676',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:08'),(1652,4,'simple','1117536',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1653,4,'simple','1115347',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1654,4,'simple','7076757',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1655,4,'simple','13000350-01',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1656,4,'simple','13000349-01',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1657,4,'simple','1076160',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1658,4,'simple','1064231',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1659,4,'simple','1027272',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1660,4,'simple','1027273',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1661,4,'simple','1054190',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1662,4,'simple','1101751',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1663,4,'simple','1029494',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1664,4,'simple','1110905',0,0,'2022-05-13 09:42:23','2022-06-24 07:19:16'),(1665,4,'simple','1021795',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1666,4,'simple','1069321',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1667,4,'simple','7068578',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:05'),(1668,4,'simple','7068577',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:07'),(1669,4,'simple','1069269',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:07'),(1670,4,'simple','1069270',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:08'),(1671,4,'simple','1069265',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:07'),(1672,4,'simple','1069266',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:07'),(1673,4,'simple','1069268',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:10'),(1674,4,'simple','7068576',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1675,4,'simple','7068579',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:08'),(1676,4,'simple','1121815',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1677,4,'simple','1067151',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1678,4,'simple','7113821',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:08'),(1679,4,'simple','7073025',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:05'),(1680,4,'simple','7069293',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:04'),(1681,4,'simple','1054206',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:05'),(1682,4,'simple','7058763',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:08'),(1683,4,'simple','7073027',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:10'),(1684,4,'simple','7069294',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:04'),(1685,4,'simple','1069097',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:02'),(1686,4,'simple','1111227',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:08'),(1687,4,'simple','1111210',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:08'),(1688,4,'simple','1111211',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:08'),(1689,4,'simple','7113829',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:06'),(1690,4,'simple','7117961',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:06'),(1691,4,'simple','7117962',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:06'),(1692,4,'simple','7113828',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:06'),(1693,4,'simple','7117963',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:06'),(1694,4,'simple','7117964',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:06'),(1695,4,'simple','7113825',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:08'),(1696,4,'simple','7113826',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:08'),(1697,4,'simple','1112998',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:08'),(1698,4,'simple','7123074',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:29'),(1699,4,'simple','7058800',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:11'),(1700,4,'simple','1069109',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:06'),(1701,4,'simple','7123076',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1702,4,'simple','1069110',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:06'),(1703,4,'simple','7113824',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:06'),(1704,4,'simple','1116566',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:09'),(1705,4,'simple','1116567',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:09'),(1706,4,'simple','1116568',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:09'),(1707,4,'simple','1116569',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:09'),(1708,4,'simple','7113823',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:06'),(1709,4,'simple','7113827',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:06'),(1710,4,'simple','1116570',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:12'),(1711,4,'simple','1116571',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:12'),(1712,4,'simple','1116572',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:12'),(1713,4,'simple','1116573',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:10'),(1714,4,'simple','1110911',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:08'),(1715,4,'simple','1114304',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:08'),(1716,4,'simple','1110912',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:08'),(1717,4,'simple','1110914',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:08'),(1718,4,'simple','1097633',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:11'),(1719,4,'simple','1097625',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:07'),(1720,4,'simple','1110915',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:11'),(1721,4,'simple','1097630',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:04'),(1722,4,'simple','7039962',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1723,4,'simple','7039963',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1724,4,'simple','7078378',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1725,4,'simple','1068237',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1726,4,'simple','1068238',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1727,4,'simple','1068222',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1728,4,'simple','1098700',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1729,4,'simple','7037658',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1730,4,'simple','14000072-01',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1731,4,'simple','1100938',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1732,4,'simple','7005358',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1733,4,'simple','7005357',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1734,4,'simple','7119923',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:04'),(1735,4,'simple','7117918',0,0,'2022-05-13 09:42:23','2022-07-20 06:33:05'),(1736,4,'simple','1099017',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1737,4,'simple','1065383',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1738,4,'simple','7115590',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1739,4,'simple','7089365',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1740,4,'simple','1070173',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1741,4,'simple','30001814-002',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1742,4,'simple','30001814-003',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1743,4,'simple','30001814-004',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1744,4,'simple','30001814-006',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1745,4,'simple','30001814-008',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1746,4,'simple','30001814-010',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1747,4,'simple','30001814-012',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1748,4,'simple','30001814-014',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1749,4,'simple','30001814-016',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1750,4,'simple','30001814-018',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1751,4,'simple','30001814-020',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1752,4,'simple','30001814-022',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1753,4,'simple','30001814-024',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1754,4,'simple','30001814-026',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1755,4,'simple','30001814-028',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1756,4,'simple','30001814-030',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1757,4,'simple','30001814-032',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1758,4,'simple','30001814-034',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1759,4,'simple','30001814-036',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1760,4,'simple','30001814-038',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1761,4,'simple','30001814-040',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1762,4,'simple','30001814-042',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1763,4,'simple','30001814-044',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1764,4,'simple','30001814-046',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1765,4,'simple','30001814-048',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1766,4,'simple','30001814-050',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1767,4,'simple','30001814-052',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1768,4,'simple','30001814-054',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1769,4,'simple','30001814-056',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1770,4,'simple','30001814-058',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1771,4,'simple','30001814-060',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1772,4,'simple','30001814-062',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1773,4,'simple','30001814-064',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1774,4,'simple','30001814-066',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1775,4,'simple','30001814-068',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1776,4,'simple','30001814-070',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1777,4,'simple','30001814-072',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1778,4,'simple','30001814-074',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1779,4,'simple','30001814-076',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1780,4,'simple','30001814-078',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1781,4,'simple','30001814-080',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1782,4,'simple','30001814-082',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1783,4,'simple','30001814-084',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1784,4,'simple','30001814-086',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1785,4,'simple','30001814-088',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1786,4,'simple','30001814-090',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1787,4,'simple','30001814-092',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1788,4,'simple','30001814-094',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1789,4,'simple','30001814-096',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1790,4,'simple','30001814-098',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1791,4,'simple','30001814-100',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1792,4,'simple','30001814-102',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1793,4,'simple','30001814-104',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1794,4,'simple','30001814-106',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1795,4,'simple','30001814-108',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1796,4,'simple','30001814-110',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1797,4,'simple','30001814-112',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1798,4,'simple','30001814-114',0,0,'2022-05-13 09:42:23','2022-05-13 10:27:30'),(1799,4,'simple','30001814-116',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1800,4,'simple','30001814-118',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1801,4,'simple','30001814-120',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1802,4,'simple','30001814-122',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1803,4,'simple','30001814-124',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1804,4,'simple','30001814-126',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1805,4,'simple','30001814-128',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1806,4,'simple','30001814-130',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1807,4,'simple','30001814-132',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1808,4,'simple','30001814-134',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1809,4,'simple','30001814-136',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1810,4,'simple','30001814-138',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1811,4,'simple','30001814-140',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1812,4,'simple','30001814-142',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1813,4,'simple','30001814-144',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1814,4,'simple','30001814-146',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1815,4,'simple','30001814-148',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1816,4,'simple','30001814-150',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1817,4,'simple','30001814-152',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1818,4,'simple','30001814-154',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1819,4,'simple','30001814-156',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1820,4,'simple','30001814-158',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1821,4,'simple','30001814-160',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1822,4,'simple','30001814-162',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1823,4,'simple','30001814-164',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1824,4,'simple','30001814-166',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1825,4,'simple','30001814-168',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1826,4,'simple','30001814-170',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1827,4,'simple','30001814-172',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1828,4,'simple','30001814-174',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1829,4,'simple','30001814-176',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1830,4,'simple','30001814-178',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1831,4,'simple','30001814-180',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1832,4,'simple','30001814-182',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1833,4,'simple','30001814-184',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1834,4,'simple','30001814-186',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1835,4,'simple','30001814-188',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1836,4,'simple','30001814-190',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1837,4,'simple','30001814-192',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1838,4,'simple','30001814-194',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1839,4,'simple','30001814-196',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1840,4,'simple','30001814-198',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1841,4,'simple','30001814-200',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1842,4,'simple','30001814-202',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1843,4,'simple','30001814-204',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1844,4,'simple','1035177',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1845,4,'simple','86006708',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1846,4,'simple','7005257',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1847,4,'simple','11000619-01',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1848,4,'simple','7024852',0,0,'2022-05-13 09:42:24','2022-08-08 12:28:29'),(1849,4,'simple','7088694',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:03'),(1850,4,'simple','7117752',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1851,4,'simple','7024853',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:02'),(1852,4,'simple','7088700',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:03'),(1853,4,'simple','7088692',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:10'),(1854,4,'simple','1027296',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1855,4,'simple','1027294',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1856,4,'simple','1025737',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1857,4,'simple','1078875',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1858,4,'simple','1116932',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1859,4,'simple','1116931',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1860,4,'simple','1116933',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1861,4,'simple','7030610',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1862,4,'simple','1069111',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:10'),(1863,4,'simple','1054152',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:01'),(1864,4,'simple','7088681',0,0,'2022-05-13 09:42:24','2022-08-08 12:28:29'),(1865,4,'simple','1078876',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1866,4,'simple','1070824',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1867,4,'simple','1067152',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1868,4,'simple','1067155',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1869,4,'simple','1067156',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1870,4,'simple','1067157',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1871,4,'simple','1093521',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:04'),(1872,4,'simple','1093522',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:04'),(1873,4,'simple','1093523',0,0,'2022-05-13 09:42:24','2022-06-24 07:19:12'),(1874,4,'simple','1025888',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1875,4,'simple','1024527',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1876,4,'simple','7092858',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1877,4,'simple','7036385',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1878,4,'simple','7119966',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1879,4,'simple','7054150',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1880,4,'simple','1068242',0,0,'2022-05-13 09:42:24','2022-06-24 06:46:47'),(1881,4,'simple','7005295',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1882,4,'simple','1083764',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1883,4,'simple','7119939',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1884,4,'simple','7007426',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1885,4,'simple','1033398',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1886,4,'simple','7005291',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1887,4,'simple','7086932',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1888,4,'simple','7021755',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1889,4,'simple','1126544',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1890,4,'simple','1122274',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1891,4,'simple','1122273',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1892,4,'simple','1122271',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1893,4,'simple','1103640',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:05'),(1894,4,'simple','1078863',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1895,4,'simple','1117469',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1896,4,'simple','1042079',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1897,4,'simple','7119968',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1898,4,'simple','1069774',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:31'),(1899,4,'simple','1069775',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1900,4,'simple','1069776',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1901,4,'simple','1069777',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1902,4,'simple','1069778',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1903,4,'simple','1069779',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1904,4,'simple','1069780',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1905,4,'simple','1069781',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1906,4,'simple','1069782',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1907,4,'simple','1069783',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1908,4,'simple','1069784',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1909,4,'simple','1069785',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1910,4,'simple','1069786',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1911,4,'simple','1069787',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1912,4,'simple','1069950',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1913,4,'simple','1069951',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1914,4,'simple','1069952',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1915,4,'simple','1118681',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1916,4,'simple','1056984',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1917,4,'simple','1056986',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1918,4,'simple','1056987',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1919,4,'simple','1081028',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:02'),(1920,4,'simple','1081027',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:02'),(1921,4,'simple','1081523',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1922,4,'simple','1029604',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1923,4,'simple','1116574',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1924,4,'simple','7039987-CH',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1925,4,'simple','16000091-01',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1926,4,'simple','16000092-03',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1927,4,'simple','1105312',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1928,4,'simple','16000287-02',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1929,4,'simple','16000634-01',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1930,4,'simple','16001184-01',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1931,4,'simple','7039988-CH',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1932,4,'simple','1067113',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1933,4,'simple','1081456',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1934,4,'simple','1070172',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1935,4,'simple','1111186',0,0,'2022-05-13 09:42:24','2022-06-24 07:19:16'),(1936,4,'simple','1111138',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1937,4,'simple','1092726',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:04'),(1938,4,'simple','1106028',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:07'),(1939,4,'simple','7123068',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1940,4,'simple','13000330-01',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:05'),(1941,4,'simple','7123069',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1942,4,'simple','13000346-01',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:05'),(1943,4,'simple','1117461',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:12'),(1944,4,'simple','7134350',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:06'),(1945,4,'simple','1106029',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:07'),(1946,4,'simple','1044194',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:06'),(1947,4,'simple','13000051-01',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1948,4,'simple','7115285',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1949,4,'simple','1106654',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1950,4,'simple','1091716',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1951,4,'simple','7103343',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1952,4,'simple','7003764',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1953,4,'simple','1064297',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1954,4,'simple','1059073',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1955,4,'simple','7036249',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1956,4,'simple','7038558',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1957,4,'simple','1042070',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1958,4,'simple','1035794',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1959,4,'simple','1040215',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1960,4,'simple','1034004',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1961,4,'simple','1107158',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1962,4,'simple','1110879',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1963,4,'simple','1087007',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1964,4,'simple','1039223',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1965,4,'simple','7066244',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1966,4,'simple','1094881',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1967,4,'simple','1034003',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1968,4,'simple','1051902',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1969,4,'simple','1091559',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1970,4,'simple','1083818',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1971,4,'simple','1083819',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1972,4,'simple','1083820',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1973,4,'simple','7139017',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1974,4,'simple','7016383',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1975,4,'simple','7082974',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1976,4,'simple','7101447',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1977,4,'simple','7100090',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1978,4,'simple','7086735',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1979,4,'simple','7082970',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1980,4,'simple','7115413',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1981,4,'simple','7074099',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1982,4,'simple','1087838',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1983,4,'simple','1105263',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1984,4,'simple','1045411',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1985,4,'simple','1095031',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1986,4,'simple','1052468',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1987,4,'simple','1053021',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1988,4,'simple','1125646',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1989,4,'simple','1078877',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1990,4,'simple','1092137',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1991,4,'simple','1034507',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1992,4,'simple','1026255',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1993,4,'simple','7070744',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1994,4,'simple','1027993',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1995,4,'simple','7020551',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1996,4,'simple','1100628',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1997,4,'simple','1111199',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1998,4,'simple','1088583',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:32'),(1999,4,'simple','7125568',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:33'),(2000,4,'simple','1069137',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:06'),(2001,4,'simple','1106030',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:07'),(2002,4,'simple','1069141',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:06'),(2003,4,'simple','1106031',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:07'),(2004,4,'simple','1069142',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:06'),(2005,4,'simple','1069423',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:06'),(2006,4,'simple','1106032',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:07'),(2007,4,'simple','1070518',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:06'),(2008,4,'simple','1070455',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:02'),(2009,4,'simple','1054153',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:33'),(2010,4,'simple','7127591',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:33'),(2011,4,'simple','1114483',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:08'),(2012,4,'simple','7115857',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:33'),(2013,4,'simple','7141419',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:33'),(2014,4,'simple','1063754',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:33'),(2015,4,'simple','7069296',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:01'),(2016,4,'simple','7113817',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:06'),(2017,4,'simple','1032129',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:05'),(2018,4,'simple','7132093',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:33'),(2019,4,'simple','7068561',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:05'),(2020,4,'simple','7068564',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:02'),(2021,4,'simple','1064412',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:05'),(2022,4,'simple','1076161',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:06'),(2023,4,'simple','7058544',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:06'),(2024,4,'simple','1111716',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:07'),(2025,4,'simple','1093186',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:04'),(2026,4,'simple','1094709',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:06'),(2027,4,'simple','1080959',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:06'),(2028,4,'simple','7123073',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:33'),(2029,4,'simple','7127264',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:05'),(2030,4,'simple','7058657',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:01'),(2031,4,'simple','1080964',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:06'),(2032,4,'simple','7134347',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:06'),(2033,4,'simple','7113818',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:06'),(2034,4,'simple','1020964',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:05'),(2035,4,'simple','1055801',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:06'),(2036,4,'simple','7065985',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:03'),(2037,4,'simple','7058541',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:07'),(2038,4,'simple','1116582',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:09'),(2039,4,'simple','1069301',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:04'),(2040,4,'simple','7058686',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:11'),(2041,4,'simple','1069936',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:05'),(2042,4,'simple','7127265',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:05'),(2043,4,'simple','1080969',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:06'),(2044,4,'simple','1069938',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:06'),(2045,4,'simple','7058681',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:06'),(2046,4,'simple','1080972',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:07'),(2047,4,'simple','7058511',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:06'),(2048,4,'simple','1080982',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:04'),(2049,4,'simple','1076162',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:06'),(2050,4,'simple','7068562',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:09'),(2051,4,'simple','7058512',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:11'),(2052,4,'simple','1099196',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:07'),(2053,4,'simple','1106033',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:07'),(2054,4,'simple','1106034',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:07'),(2055,4,'simple','7058549',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:11'),(2056,4,'simple','7058545',0,0,'2022-05-13 09:42:24','2022-06-24 07:19:14'),(2057,4,'simple','7123017',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:01'),(2058,4,'simple','7068565',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:05'),(2059,4,'simple','7113822',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:05'),(2060,4,'simple','7134348',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:02'),(2061,4,'simple','7117789',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:33'),(2062,4,'simple','7128104',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:33'),(2063,4,'simple','1090929',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:33'),(2064,4,'simple','1063755',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:33'),(2065,4,'simple','7063881',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:33'),(2066,4,'simple','7129757',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:33'),(2067,4,'simple','1067158',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:33'),(2068,4,'simple','1068043',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:33'),(2069,4,'simple','1081790',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:05'),(2070,4,'simple','1087692',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:33'),(2071,4,'simple','7140705',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:33'),(2072,4,'simple','1059081',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:33'),(2073,4,'simple','1103562',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:05'),(2074,4,'simple','1103559',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:05'),(2075,4,'simple','1103556',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:07'),(2076,4,'simple','1059091',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:02'),(2077,4,'simple','1103560',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:05'),(2078,4,'simple','1103558',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:05'),(2079,4,'simple','1070403',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:02'),(2080,4,'simple','1059093',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:02'),(2081,4,'simple','1026189',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:33'),(2082,4,'simple','1055603',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:33'),(2083,4,'simple','7015190',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:33'),(2084,4,'simple','7127504',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:05'),(2085,4,'simple','1080984',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:04'),(2086,4,'simple','7065986',0,0,'2022-05-13 09:42:24','2022-06-24 07:19:14'),(2087,4,'simple','7123070',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:33'),(2088,4,'simple','1069304',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:06'),(2089,4,'simple','1114321',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:08'),(2090,4,'simple','1069429',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:05'),(2091,4,'simple','1115650',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:09'),(2092,4,'simple','1097838',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:07'),(2093,4,'simple','1069841',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:06'),(2094,4,'simple','7134349',0,0,'2022-05-13 09:42:24','2022-06-24 07:19:14'),(2095,4,'simple','1092361',0,0,'2022-05-13 09:42:24','2022-06-24 07:19:15'),(2096,4,'simple','1069840',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:06'),(2097,4,'simple','7127493',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:05'),(2098,4,'simple','1069842',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:06'),(2099,4,'simple','7123098',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2100,4,'simple','1111226',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2101,4,'simple','1116584',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:09'),(2102,4,'simple','1069843',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:06'),(2103,4,'simple','1069844',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:06'),(2104,4,'simple','1069845',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:06'),(2105,4,'simple','1080956',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:04'),(2106,4,'simple','1103553',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:07'),(2107,4,'simple','1111063',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:08'),(2108,4,'simple','1040813-01',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2109,4,'simple','1024076',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2110,4,'simple','1117747',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2111,4,'simple','7103961',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2112,4,'simple','1106996',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2113,4,'simple','1029472',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2114,4,'simple','1112164',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2115,4,'simple','1112163',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2116,4,'simple','1105044',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2117,4,'simple','7114177',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2118,4,'simple','7007224',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2119,4,'simple','1081534',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2120,4,'simple','7056170',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2121,4,'simple','1052142',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2122,4,'simple','1052144',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2123,4,'simple','7042463',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2124,4,'simple','7073208',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2125,4,'simple','7016623',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2126,4,'simple','7103578',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2127,4,'simple','7138559',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2128,4,'simple','1039691',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2129,4,'simple','7005099',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2130,4,'simple','1106035',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2131,4,'simple','7132799',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2132,4,'simple','7072352',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2133,4,'simple','1111118',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2134,4,'simple','1063504',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2135,4,'simple','1019872',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2136,4,'simple','1103834',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2137,4,'simple','7103350',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2138,4,'simple','7031129',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2139,4,'simple','7049657',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2140,4,'simple','7141595',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2141,4,'simple','1033819',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2142,4,'simple','1121688',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2143,4,'simple','1104872',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2144,4,'simple','1104874',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2145,4,'simple','1033422',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2146,4,'simple','1040241',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2147,4,'simple','7011637',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2148,4,'simple','1097543',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2149,4,'simple','1088082',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2150,4,'simple','7055237',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2151,4,'simple','1121698',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2152,4,'simple','1104876',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2153,4,'simple','1104877',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2154,4,'simple','1069846',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2155,4,'simple','7055236',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2156,4,'simple','1111491',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2157,4,'simple','7117983',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2158,4,'simple','1028364',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2159,4,'simple','1028361',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2160,4,'simple','1028365',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2161,4,'simple','7055238',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2162,4,'simple','1060727',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2163,4,'simple','7105295',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2164,4,'simple','7117632',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2165,4,'simple','7125369',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2166,4,'simple','7001606',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2167,4,'simple','7009060',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2168,4,'simple','1097831',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2169,4,'simple','7140364',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2170,4,'simple','7140363',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2171,4,'simple','7065439',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2172,4,'simple','1022313',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2173,4,'simple','7043406',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2174,4,'simple','7133778',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2175,4,'simple','1106036',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2176,4,'simple','1067419',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2177,4,'simple','1073426',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2178,4,'simple','1035272',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2179,4,'simple','1035507',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2180,4,'simple','7140284',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2181,4,'simple','7106920',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2182,4,'simple','7106921',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2183,4,'simple','7106922',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2184,4,'simple','7103543',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2185,4,'simple','1114247',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2186,4,'simple','7078242',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2187,4,'simple','1120596',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2188,4,'simple','500035',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2189,4,'simple','1076163',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2190,4,'simple','1076164',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2191,4,'simple','500034',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2192,4,'simple','1120599',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2193,4,'simple','1069940',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2194,4,'simple','1093930',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2195,4,'simple','1093931',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2196,4,'simple','1093932',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2197,4,'simple','1076165',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2198,4,'simple','1120600',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:35'),(2199,4,'simple','1083756',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2200,4,'simple','1002367-01',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2201,4,'simple','7007365',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2202,4,'simple','1121797',0,0,'2022-05-13 09:42:24','2022-08-08 12:28:29'),(2203,4,'simple','7103328',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2204,4,'simple','1053137',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2205,4,'simple','7041880',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2206,4,'simple','1034009',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2207,4,'simple','1034011',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2208,4,'simple','7115795',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2209,4,'simple','7092860',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2210,4,'simple','7092853',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2211,4,'simple','1098723',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2212,4,'simple','1042005',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2213,4,'simple','1096638',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2214,4,'simple','7124470',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2215,4,'simple','7124472',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2216,4,'simple','7124469',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2217,4,'simple','7126666',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2218,4,'simple','1057434',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2219,4,'simple','1068044',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2220,4,'simple','1068047',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2221,4,'simple','7031804',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2222,4,'simple','1118863',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2223,4,'simple','7138635',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2224,4,'simple','7001329',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2225,4,'simple','7001581',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2226,4,'simple','7001553',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2227,4,'simple','1067084',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2228,4,'simple','1068053',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2229,4,'simple','1041320',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:10'),(2230,4,'simple','1068054',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2231,4,'simple','1068055',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2232,4,'simple','1068056',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2233,4,'simple','1053888',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:01'),(2234,4,'simple','1110998',0,0,'2022-05-13 09:42:24','2022-08-08 12:28:29'),(2235,4,'simple','1110997',0,0,'2022-05-13 09:42:24','2022-07-20 06:33:09'),(2236,4,'simple','7036389',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2237,4,'simple','7107827',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2238,4,'simple','1081005',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2239,4,'simple','7034544',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2240,4,'simple','1068057',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2241,4,'simple','1039090',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2242,4,'simple','7040051-G',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2243,4,'simple','1053733',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2244,4,'simple','7027419',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2245,4,'simple','1048137',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2246,4,'simple','1048139',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2247,4,'simple','1101186',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2248,4,'simple','1101147',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2249,4,'simple','1044176',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2250,4,'simple','7030622-G',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2251,4,'simple','7040060',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2252,4,'simple','7040059',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2253,4,'simple','7135994',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2254,4,'simple','1097875',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2255,4,'simple','7120907',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2256,4,'simple','1117451',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2257,4,'simple','7017836',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2258,4,'simple','1046656',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2259,4,'simple','1101215',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2260,4,'simple','1085519',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2261,4,'simple','1086355',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2262,4,'simple','1036153',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2263,4,'simple','7097304',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2264,4,'simple','7114193',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2265,4,'simple','7016335',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2266,4,'simple','901051',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2267,4,'simple','7039988-G',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2268,4,'simple','1046655',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2269,4,'simple','7076673',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2270,4,'simple','7021173',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2271,4,'simple','7103457',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2272,4,'simple','7131088',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2273,4,'simple','7135185',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2274,4,'simple','7103455',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2275,4,'simple','1039426',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2276,4,'simple','1111435',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2277,4,'simple','7040049-G',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2278,4,'simple','7040048-G',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2279,4,'simple','1024073',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2280,4,'simple','7119984',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2281,4,'simple','1078852',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2282,4,'simple','1078827',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2283,4,'simple','1027105',0,0,'2022-05-13 09:42:24','2022-05-13 10:27:36'),(2284,4,'sim