<?php

namespace Vendor\CustomSearch\Controller\Ajax;

use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Catalog\Model\ResourceModel\Product\CollectionFactory;
use Magento\Framework\Controller\Result\JsonFactory;
use Magento\Eav\Model\Config as EavConfig;

class ManufacturerCount extends Action
{
    protected $collectionFactory;
    protected $resultJsonFactory;
    protected $eavConfig;

    public function __construct(
        Context $context,
        CollectionFactory $collectionFactory,
        JsonFactory $resultJsonFactory,
        EavConfig $eavConfig
    ) {
        $this->collectionFactory = $collectionFactory;
        $this->resultJsonFactory = $resultJsonFactory;
        $this->eavConfig = $eavConfig;
        parent::__construct($context);
    }

    public function execute()
    {
        $resultJson = $this->resultJsonFactory->create();

        // Optionally skip if 'q' parameter exists
        if ($this->getRequest()->getParam('q', false)) {
            return $resultJson->setData([]);
        }

        $ids = $this->getRequest()->getParam('manufacturers');
        // var_dump(json_decode($ids,1)); die;
        $output = [];
        $productIds = $ids;//[477, 478, 479, 860, 1001, 1616]; // Replace with your actual logic
        // var_dump($productIds ); die;
        // $_SESSION['ids'] = $productIds;

        // var_dump($productIds); die;

        $collection = $this->collectionFactory->create()
            ->addAttributeToSelect('manufacturer')
            ->addAttributeToFilter('entity_id', ['in' => $productIds]);

        $manufacturerCounts = [];

        foreach ($collection as $product) {
            $manufacturerId = $product->getData('manufacturer');
            if ($manufacturerId) {
                $manufacturerCounts[$manufacturerId] = ($manufacturerCounts[$manufacturerId] ?? 0) + 1;
            }
        }

        $attribute = $this->eavConfig->getAttribute('catalog_product', 'manufacturer');

        if ($attribute && $attribute->usesSource()) {
            foreach ($manufacturerCounts as $id => $count) {
                $label = $attribute->getSource()->getOptionText($id);
                $output[] = [
                    'value' => $id,
                    'label' => $label,
                    'count' => $count
                ];
            }
        }

        return $resultJson->setData($output);
    }
}