<?php

/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

namespace Vendor\CustomSearch\SearchAdapter;

use Magento\Framework\ObjectManagerInterface;

/**
 * Query Response Factory
 * @api
 * @since 100.1.0
 */
class ResponseFactory extends \Magento\Elasticsearch\SearchAdapter\ResponseFactory
{
    /**
     * Object Manager instance
     *
     * @var ObjectManagerInterface
     * @since 100.1.0
     */
    protected $objectManager;

    /**
     * Document Factory to create Search Document instance
     *
     * @var DocumentFactory
     * @since 100.1.0
     */
    protected $documentFactory;

    /**
     * Aggregation Factory to create Aggregation instance
     *
     * @var AggregationFactory
     * @since 100.1.0
     */
    protected $aggregationFactory;

    /**
     * Create Query Response instance
     *
     * @param array $response
     * @return \Magento\Framework\Search\Response\QueryResponse
     * @since 100.1.0
     */
    public function create($response)
    {
        $documents = [];

        $scores = [];

        // print_r($_SESSION["favcolor"]); die;

        // if (isset($_GET['q'])) {
        //     foreach ($response['documents'] as $rawDocument) {
        //         if (!array_key_exists('_id', $rawDocument) && isset($rawDocument['fields']['_id'][0])) {
        //             $rawDocument['_id'] = $rawDocument['fields']['_id'][0];

        //             // if ($this->checkData($rawDocument['_id'])) {
        //                 // $rawDocument['_id'] = $rawDocument['fields']['_id'][0] = $rawDocument['_id'];
        //                 // array_push($scores, $rawDocument['_id']);
        //                 // unset($response['documents']);
        //                 // $documents[] = $this->documentFactory->create(
        //                 //     $rawDocument
        //                 // );
        //             // }

        //             unset($rawDocument['fields']);
        //         }
        //         $documents[] = $this->documentFactory->create(
        //             $rawDocument
        //         );
        //     }
        // } else {

        // $dummyArray1 = array(
        //     array(
        //         '_index' => 'market123_product_5_v10',
        //         '_type' => 'document',
        //         '_id' => 255047,
        //         '_score' => 342.7137
        //     )
        // );
        
        // Create the second dummy array (with a slightly different content)
        // $dummyArray2 = array(
        //     array(
        //         '_index' => 'market123_product_5_v10',
        //         '_type' => 'document',
        //         '_id' => 1699,
        //         '_score' => 342.7137
        //     )
        // );
        
        // Combine both arrays into a single array
        // $combinedArray = array_merge($dummyArray1, $dummyArray2);
        
        // Output the combined array for verification
        // print_r($combinedArray);


        // $response['documents'] = $combinedArray;
        // echo "<pre>";print_r($response['documents']); die;
            foreach ($response['documents'] as $rawDocument) {
                if (!array_key_exists('_id', $rawDocument) && isset($rawDocument['fields']['_id'][0])) {

                    $rawDocument['_id'] = $rawDocument['fields']['_id'][0];

                    // echo $rawDocument['_id']; 

                    unset($rawDocument['fields']);
                }

                $documents[] = $this->documentFactory->create(
                    $rawDocument
                );
            }

            // die;
        // }

        
        // $_debug = array(
        //     'results'=> count($response['documents']),
        //     'scores' => $scores,
        //     // 'min_relevance_score' => $this->configuration->getMinScore(),
        //     'min_score' => min($scores),
        //     'max_score' => max($scores)
        // );
        // echo "<pre>"; print_r($_debug); die;

        /** @var \Magento\Framework\Search\Response\Aggregation $aggregations */
        $aggregations = $this->aggregationFactory->create($response['aggregations']);
        return $this->objectManager->create(
            \Magento\Framework\Search\Response\QueryResponse::class,
            [
                'documents' => $documents,
                'aggregations' => $aggregations,
                'total' => (isset($_GET["q"])) ? count([1,1]) : $response['total']
            ]
        );
    }
}
