<?php

namespace Rahi\DashboardNew\Helper;

use Magento\Directory\Model\RegionFactory;
use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Framework\App\Helper\Context;
use Magento\Sales\Model\OrderFactory;
use Magento\Framework\App\Cache\TypeListInterface;
use Magento\Framework\App\Cache\Frontend\Pool;

class Data extends AbstractHelper
{
    protected $orderFactory;
    protected $regionFactory;
    protected $cacheTypeList;
    protected $cacheFrontendPool;

    public function __construct(
        Context $context,
        OrderFactory $orderFactory,
        TypeListInterface $cacheTypeList,
        Pool $cacheFrontendPool,
        RegionFactory $regionFactory
    ) {
        $this->orderFactory = $orderFactory;
        $this->regionFactory = $regionFactory;
        $this->_cacheTypeList = $cacheTypeList;
        $this->_cacheFrontendPool = $cacheFrontendPool;
        parent::__construct($context);
    }

    public function getOrderRegionData($orderId)
    {
        $order = $this->orderFactory->create()->load($orderId);
        $billingAddress = $order->getBillingAddress()->getData();
        $shippingAddress = $order->getShippingAddress()->getData();
        $region = $this->regionFactory->create()->load($shippingAddress['region_id']);
        $countryShippingId = $order->getShippingAddress()->getData('country_id');
        $objectManager =  \Magento\Framework\App\ObjectManager::getInstance();
        $countryName = $objectManager->create('\Magento\Directory\Model\Country')->load($countryShippingId)->getName();
        $orderRegion = $this->countryCodeToCountry($countryName);
        return $orderRegion;
    }

    function countryCodeToCountry($code)
    {
        if ($code == 'Australia') return 'APAC';
        if ($code == 'China') return 'APAC';
        if ($code == 'Hong Kong') return 'APAC';
        if ($code == 'Japan') return 'APAC';
        if ($code == 'Korea') return 'APAC';
        if ($code == 'Malaysia') return 'APAC';
        if ($code == 'New Zealand') return 'APAC';
        if ($code == 'Philippines') return 'APAC';
        if ($code == 'Singapore') return 'APAC';
        if ($code == 'Taiwan') return 'APAC';
        if ($code == 'Thailand') return 'APAC';
        if ($code == 'India') return 'APAC';
        if ($code == 'Indonesia') return 'APAC';
        if ($code == 'Korea, Republic of') return 'APAC';
        if ($code == 'South Korea') return 'APAC';
        if ($code == 'Austria') return 'EMEA';
        if ($code == 'Belgium') return 'EMEA';
        if ($code == 'Bulgaria') return 'EMEA';
        if ($code == 'Central African Republic') return 'EMEA';
        if ($code == 'Croatia') return 'EMEA';
        if ($code == 'Czech Republic') return 'EMEA';
        if ($code == 'Denmark') return 'EMEA';
        if ($code == 'Egypt') return 'EMEA';
        if ($code == 'Estonia') return 'EMEA';
        if ($code == 'Finland') return 'EMEA';
        if ($code == 'France') return 'EMEA';
        if ($code == 'Germany') return 'EMEA';
        if ($code == 'Greece') return 'EMEA';
        if ($code == 'Hungary') return 'EMEA';
        if ($code == 'Ireland') return 'EMEA';
        if ($code == 'Israel') return 'EMEA';
        if ($code == 'Italy') return 'EMEA';
        if ($code == 'Kenya') return 'EMEA';
        if ($code == 'Latvia') return 'EMEA';
        if ($code == 'Lithuania') return 'EMEA';
        if ($code == 'Macedonia') return 'EMEA';
        if ($code == 'Netherlands') return 'EMEA';
        if ($code == 'Nigeria') return 'EMEA';
        if ($code == 'Norway') return 'EMEA';
        if ($code == 'Oman') return 'EMEA';
        if ($code == 'Poland') return 'EMEA';
        if ($code == 'Portugal') return 'EMEA';
        if ($code == 'Qatar') return 'EMEA';
        if ($code == 'Romania') return 'EMEA';
        if ($code == 'Russian Federation') return 'EMEA';
        if ($code == 'Saint Helena') return 'EMEA';
        if ($code == 'Saudi Arabia') return 'EMEA';
        if ($code == 'Slovakia') return 'EMEA';
        if ($code == 'Slovenia') return 'EMEA';
        if ($code == 'South Africa') return 'EMEA';
        if ($code == 'Spain') return 'EMEA';
        if ($code == 'Sweden') return 'EMEA';
        if ($code == 'Switzerland') return 'EMEA';
        if ($code == 'Ukraine') return 'EMEA';
        if ($code == 'United Arab Emirates') return 'EMEA';
        if ($code == 'United Kingdom') return 'EMEA';
        if ($code == 'Argentina') return 'NASA';
        if ($code == 'Brazil') return 'NASA';
        if ($code == 'Canada') return 'NASA';
        if ($code == 'Colombia') return 'NASA';
        if ($code == 'Mexico') return 'NASA';
        if ($code == 'Panama') return 'NASA';
        if ($code == 'Uruguay') return 'NASA';
        if ($code == 'USA') return 'NASA';
        if ($code == 'Chile') return 'NASA';
        if ($code == 'United States') return 'NASA';
        return '';
    }

    function convertToPst($dateRequested, $defaultTz, $finalTimezone)
    { //echo $defaultTz; echo $finalTimezone;die;
        $dateReceived = new \DateTime($dateRequested, new \DateTimeZone($defaultTz));
        $dateReceived->setTimezone(new \DateTimeZone($finalTimezone));
        $dateTime = $dateReceived->format('Y-m-d H:i:s');
        return $dateTime;
    }
    function getEasyClean($response)
    {
        // error_log("message");
        if ($response === true) {
            $types = array('layout', 'block_html', 'collections','full_page');
            foreach ($types as $type) {
                $this->_cacheTypeList->cleanType($type);
            }
            foreach ($this->_cacheFrontendPool as $cacheFrontend) {
                $cacheFrontend->getBackend()->clean();
            }
        }
        return true;
    }
        /**
     * @return object
     */
    public function getStatus($id)
    {
        $data = '';
        if ($id == 0) {
            $data = __('Close');
        } elseif ($id == 1) {
            $data = __('Open');
        } elseif ($id == 2) {
            $data = __('Processing');
        } elseif ($id == 3) {
            $data = __('Done');
        }elseif ($id == 4) {
            $data = __('Esaclated');
        }

        return $data;
    }
}


