<?php
namespace Rahi\Equote\Controller\Customer;

use Magento\Framework\App\Filesystem\DirectoryList;
use Magento\Framework\Controller\ResultFactory;

class Savecomments extends \Magento\Framework\App\Action\Action
{

    protected $resultPageFactory;
    protected $_transportBuilder;
    protected $_inlineTranslation;
    protected $_customerSession;

    public function __construct(
        \Magento\Framework\App\Action\Context $context,
        \Magento\Customer\Model\Session $customerSession,
        \Magento\Framework\View\Result\PageFactory $resultPageFactory,
        \Magento\Framework\Mail\Template\TransportBuilder $transportBuilder,
        \Magento\Framework\Translate\Inline\StateInterface $inlineTranslation,
        \Rahi\Equote\Model\EquoteComments $commentsFactory
    )
    {
        $this->resultPageFactory = $resultPageFactory;
        $this->commentsFactory = $commentsFactory;
        $this->_transportBuilder = $transportBuilder;
        $this->_inlineTranslation = $inlineTranslation;
        $this->_customerSession = $customerSession;
        parent::__construct($context);
    }

    public function execute()
    {  
	if(!$this->_customerSession->getCustomer()->getId()){
		$this->messageManager->addError(__('Please sign in to add comment.'));
		return $this->_redirect('equote/customer/');
	}
        $data = $this->getRequest()->getPostValue();
        if ($data) {
            $commentModel = $this->_objectManager->create('Rahi\Equote\Model\EquoteComments');
            $commentModel->setData($data)->save();
            $equote = $this->_objectManager->create('Rahi\Equote\Model\Equote')->load($data['equote_id'])->getData();
	    $watchlist = array_filter(explode(",",$equote['watchlist_emails']));
            $this->sendemail($commentModel,$watchlist);
        }
//        $this->_redirect('equote/customer/view/equote_id/' . $data['equote_id']);
        return $this->_redirect('equote/customer/view/equote_id/' . $data['equote_id']);
    }


    public function sendEmail($commentModel,$watchlist){
        $template = 'new_comment';

        $recipient_address = $this->_customerSession->getCustomer()->getEmail();
        $recipient_name = $this->_customerSession->getCustomer()->getFirstname();
        $from_address = [
            'name' => "Punchout Portal",
            'email' => "no-reply@rahisystems.com"
        ];
        $vars = [
            'customer_name' => $this->_customerSession->getCustomer()->getFirstname(),
            'store_name' => 'Punchout Portal',
            'store_email' => 'GoogleAriba.Support@rahisystems.com',
            'equote_id'=>  $commentModel->getEquoteId(),
            'status' => $commentModel->getStatus(),
            'created_at' => date("d/m/Y",$commentModel->getCreatedAt()),
            'comment' => $commentModel->getComment()
        ];
        $this->_inlineTranslation->suspend();
        $this->_transportBuilder->setTemplateIdentifier(
            $template
        )->setTemplateOptions(
            [
              'area'  => \Magento\Framework\App\Area::AREA_FRONTEND,
              'store' =>  \Magento\Store\Model\Store::DEFAULT_STORE_ID,
          ]
      )->setTemplateVars(
        $vars
    )->setFrom(
        $from_address
    )->addTo(
        $recipient_address,
        $recipient_name
    )->addCc(
       'GoogleAriba.Support@rahisystems.com',
       'Admin'
    )->addCc($watchlist);

    if (!isset($transport)) {
        $transport = $this->_transportBuilder->getTransport();
    }
    try {
        $transport->sendMessage();
        $this->_inlineTranslation->resume();
    } catch (\Exception $exception) {

    }
}
}


