<?php

namespace Rahi\Equote\Block\Customer\Listing;

use Magento\Framework\View\Element\Template;
use Rahi\Equote\Model\ResourceModel\Equote\CollectionFactory;
use Magento\Catalog\Model\Product;

class Watchlist extends Template
{

    protected $scopeConfig;
    protected $collection;
    protected $product;

    public function __construct(
        \Magento\Framework\View\Element\Template\Context $context,
        \Magento\Customer\Model\Session $customerSession,
        \Magento\Framework\Message\ManagerInterface $messageManager,
        \Rahi\Equote\Model\Equote $_equote_model,
        CollectionFactory $blockCollectionFactory,
        Product $product
    )
    {
        $this->scopeConfig = $context->getScopeConfig();
        $this->product = $product;
        $this->customerSession = $customerSession;
        $this->messageManager = $messageManager;
        $this->_equote_model = $_equote_model;
        $this->collection = $blockCollectionFactory->create();
        parent::__construct($context);
    }

   public function getCustomerId()
    {
        return $this->customerSession->getCustomer()->getId();
    }

   public function getCustomerEmailId()
    {
        return $this->customerSession->getCustomer()->getEmail();
    }

    public function getCollection()
    {
        $itemsCollection = $this->collection->getItems();
        return $itemsCollection;
    }
    public function getAvailableStatus()
    {
        $availableOptions = $this->_equote_model->getAvailableStatuses();
        return $availableOptions;
    }
    public function getViewUrl($equoteId)
    {
        return $this->getUrl('equote/customer/view', ['equote_id' => $equoteId]);
    }
    public function getPunchoutUrl($equoteId)
    {
        return $this->getUrl('equote/customer/punchout/',['equote_id'=>$equoteId]);
    }

    public function getEquoteCollection()
    {
        $page=($this->getRequest()->getParam('p'))? $this->getRequest()->getParam('p') : 1;
        $pageSize=($this->getRequest()->getParam('limit'))? $this->getRequest()->getParam('limit') : 10;
        $equoteCollection = $this->collection;
	$equoteCollection->addFieldToFilter('watchlist_emails', array('regexp' => '[[:<:]]'.$this->getCustomerEmailId().'[[:>:]]'));
	$equoteCollection->setOrder('equote_id','DESC');
	$equoteCollection->setPageSize($pageSize);
	$equoteCollection->setCurPage($page);
        return $equoteCollection;
    }

    protected function _prepareLayout()
    {
      parent::_prepareLayout();
      $this->pageConfig->getTitle()->set(__('My Equotes'));


       if ($this->getEquoteCollection()) {
        $pager = $this->getLayout()->createBlock(
            'Magento\Theme\Block\Html\Pager',
            'custom.equote.pager'
        )->setAvailableLimit(array(5=>5,10=>10,15=>15))->setShowPerPage(true)->setCollection(
            $this->getEquoteCollection()
        );
        $this->setChild('pager', $pager);
        $this->getEquoteCollection()->load();
    }
    return $this;
}

public function getPagerHtml()
{
    return $this->getChildHtml('pager');
}



}

