<?php

namespace Rahi\Equote\Helper;

class Data extends \Magento\Framework\App\Helper\AbstractHelper
{

    protected $scopeConfig;
    protected $_objectManager = null;
    protected $_attributes        = [];
    protected $_eavSetup        = null;


    public function __construct(
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Magento\Framework\ObjectManagerInterface $objectmanager
    ) {
        $this->scopeConfig = $scopeConfig;
        $this->_objectManager = $objectmanager;
    }

    public function getAttribute($_code, $_force = false)
    {
        if (!isset($this->_attributes[$_code]) || $_force) {
            $_attribute = $this->_objectManager->get("Magento\Catalog\Model\ResourceModel\Eav\AttributeFactory")->create();
            $this->_attributes[$_code] = $_attribute->loadByCode(\Magento\Catalog\Api\Data\ProductAttributeInterface::ENTITY_TYPE_CODE, $_code);
        }

        return $this->_attributes[$_code];
    }

    public function getEavSetup()
    {
        if (!$this->_eavSetup) {
            $this->_eavSetup = $this->_objectManager->get('Magento\Eav\Setup\EavSetupFactory')->create([
                'setup' => $this->_objectManager->get('Magento\Framework\Setup\ModuleDataSetupInterface')
            ]);
        }
        return $this->_eavSetup;
    }

    public function getAttributeOptionId($_code, $_value)
    {
        $attribute = $this->getAttribute($_code);
        if (!$_value || !$attribute || !$attribute->getId()) {
            return '';
        }

        $optionId = '';
        $options = $attribute->getSource()->getAllOptions(false);

        if ($options && count($options) > 0) {
            foreach ($options as $option) {
                if (strtolower($option['label']) ==  trim(strtolower($_value))) {
                    $optionId = $option['value'];
                    break;
                }
            }
        }

        if (!$optionId) {
            $option = [];
            $option['attribute_id'] = $attribute->getAttributeId();
            $option['value']['option'][0] = $_value;
            $option['value']['option'][1] = $_value;
            $option['order']['option'] = '';
            // $this->getEavSetup()->addAttributeOption($option);
            $objectManagerFactorys = \Magento\Framework\App\Bootstrap::createObjectManagerFactory(BP, []);
            $objectManagers = $objectManagerFactorys->create([]);
            $state = $objectManagers->get('Magento\Framework\App\State');
            $state->setAreaCode('global');
            $optionFactory  = $objectManagers->create('\Magento\Eav\Api\Data\AttributeOptionInterfaceFactory');
            $option = $optionFactory->create();
            $option->setLabel($_value);
            $option->setIsDefault(false);
            $attributeOptionManagement = $objectManagers->create('\Magento\Eav\Api\AttributeOptionManagementInterface');
            $attributeOptionManagement->add(
                'catalog_product',
                $_code,
                $option
            );
            $attribute = $this->getAttribute($_code, true);
            $options = $attribute->getSource()->getAllOptions(false);
            if ($options && count($options) > 0) {
                foreach ($options as $option) {
                    if (trim(strtolower($option['label'])) ==  strtolower($_value)) {
                        $optionId = $option['value'];
                        break;
                    }
                }
            }
        }
        return $optionId;
    }
}
