<?php

namespace Vendor\CustomSearch\Model\Layer;

use Magento\Catalog\Model\Layer as CatalogLayer;

class CustomLayer extends CatalogLayer
{
    public function getCurrentCategory()
    {
        // Override to return a real category (like ID 2 or a custom one)
        return $this->categoryRepository->get(2);
    }

    public function getProductCollection()
    {
        // Create a collection and apply custom product IDs here
        if (!isset($this->_productCollections[$this->getCurrentCategory()->getId()])) {
            $collection = $this->collectionProvider->getCollection($this->getCurrentCategory());

            $customIds = [1001, 1616];

            $collection->addAttributeToSelect('*')
                ->addFieldToFilter('entity_id', ['in' => $customIds])
                ->addAttributeToFilter('status', 1)
                ->addAttributeToFilter('visibility', ['in' => [2, 3, 4]])
                ->addStoreFilter()
                ->setFlag('layered_navigation_filter_only', true);

            $this->_productCollections[$this->getCurrentCategory()->getId()] = $collection;
        }

        return $this->_productCollections[$this->getCurrentCategory()->getId()];
    }
}
