<?php

namespace Vendor\CustomSearch\Model;

use Magento\CatalogSearch\Model\ResourceModel\Fulltext\Collection\SearchResultApplierInterface;
use Magento\Framework\Api\Search\SearchResultInterface;
use Magento\Framework\Data\Collection;

class SearchResultApplier implements SearchResultApplierInterface
{
    private $collection;
    private $searchResult;
    private $size;
    private $currentPage;

    public function __construct(
        Collection $collection,
        SearchResultInterface $searchResult,
        int $size,
        int $currentPage
    ) {
        $this->collection = $collection;
        $this->searchResult = $searchResult;
        $this->size = $size;
        $this->currentPage = $currentPage;
    }

    public function apply()
    {
        // echo "<pre>";
        // print_r($this->searchResult->getItems());

        $customProductIds = [];
        if (isset($_GET['q'])) {
            $objectManager = \Magento\Framework\App\ObjectManager::getInstance();

            $customProductIds = $_SESSION['ids'];//[477, 478, 479, 860, 1001, 1616];
            // $_SESSION['ids'] = $customProductIds;
            $documents = [];

            // foreach ($customProductIds as $id) {
            //     $documents[] = $objectManager->create(\Magento\Framework\Api\Search\Document::class, [
            //         'data' => ['id' => $id]
            //     ]);
            // }
            foreach ($customProductIds as $id) {
                $documents[] = $objectManager->create(\Magento\Framework\Api\Search\Document::class, [
                    'data' => [
                        'id' => $id,
                        'custom_attributes' => [
                            'score' => $objectManager->create(\Magento\Framework\Api\AttributeValue::class, [
                                'data' => [
                                    'attribute_code' => '_score',
                                    'value' => 18.685278 // or dynamically set this
                                ]
                            ])
                        ]
                    ]
                ]);
            }
            // echo "<pre>"; print_r($documents); die;
            $items = $this->sliceItems($documents, $this->size, $this->currentPage);
            $ids = [];
            foreach ($items as $item) {
                $ids[] = (int)$item->getId();
            }
            // var_dump($customProductIds);


            $this->collection->getSelect()
                ->where('e.entity_id IN (?)', $ids)
                ->reset(\Magento\Framework\DB\Select::ORDER);
                
                // $this->collection->getSelect()->group('e.entity_id');
// var_dump($this->collection->getSize()); die;
            // $this->collection->addAttributeToFilter('entity_id', ['in' => $ids]);


            $this->collection->addAttributeToFilter('entity_id', ['in' => $ids]);

                // $this->collection->setPageSize(count($ids));
// $this->collection->setCurPage($this->currentPage);
            if (isset($_GET['manufacturer']) && is_numeric($_GET['manufacturer'])) {
                $manufacturerId = (int) $_GET['manufacturer'];
                $this->collection->addAttributeToFilter('manufacturer', $manufacturerId);
            }

            //-------------------
            // $layer = \Magento\Framework\App\ObjectManager::getInstance()
            //     ->create(\Magento\Catalog\Model\Layer\Resolver::class)
            //     ->get();
            // // Needed so the layer uses your custom collection
            // $defaultCategoryId = 2; // Usually Root Category
            // $category = $objectManager->create(\Magento\Catalog\Model\Category::class)->load($defaultCategoryId);
            // if ($category->getId()) {
            //     $layer->setCurrentCategory($category);
            // }
            // $layer->setCurrentCategory($category);
            // // $layer->setCurrentCategory(false);
            // $layer->setProductCollection($this->collection);
            //--------------------
        } else {

            // default code

            if (empty($this->searchResult->getItems())) {
                $this->collection->getSelect()->where('NULL');
                return;
            }

            $items = $this->sliceItems($this->searchResult->getItems(), $this->size, $this->currentPage);
            $ids = [];
            foreach ($items as $item) {
                $ids[] = (int)$item->getId();
            }

            $this->collection->getSelect()
                ->where('e.entity_id IN (?)', $ids)
                ->reset(\Magento\Framework\DB\Select::ORDER);
        }

        $sortOrder = $this->searchResult->getSearchCriteria()->getSortOrders();

        if (!empty($sortOrder['price']) && $this->collection->getLimitationFilters()->isUsingPriceIndex()) {
            $sortDirection = $sortOrder['price'];
            $this->collection->getSelect()
                ->order(new \Zend_Db_Expr("price_index.min_price = 0, price_index.min_price {$sortDirection}"));
        } else {
            $orderList = join(',', $ids);
            // print_r($orderList); die;
            $this->collection->getSelect()
                ->order(new \Zend_Db_Expr("FIELD(e.entity_id,{$orderList})"));
        }
    }

    private function sliceItems(array $items, int $size, int $currentPage): array
    {
        if ($size !== 0) {
            $itemsCount = count($items);
            $maxAllowedPage = ceil($itemsCount / $size);
            $currentPage = max(1, min($currentPage, $maxAllowedPage));
            $offset = $this->getOffset($currentPage, $size);
            $items = array_slice($items, $offset, $size);
        }

        return $items;
    }

    private function getOffset(int $pageNumber, int $pageSize): int
    {
        return ($pageNumber - 1) * $pageSize;
    }
}
