<?php

/**
 * @author Paras Suryawanshi <paras.suryawanshi@rahisystems.com>
 */

namespace Vendor\CustomSearch\Plugin;

use Magento\CatalogSearch\Controller\Result\Index as Subject;
use Magento\Search\Model\QueryFactory;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Store\Model\ScopeInterface;

class SearchResultIndexPlugin
{
    /**
     * @var QueryFactory
     */
    protected $queryFactory;

    /**
     *
     * @var ScopeConfigInterface
     */
    protected $scopeConfig;

    /**
     *
     * @param QueryFactory $queryFactory
     * @param ScopeConfigInterface $scopeConfig
     */
    public function __construct(
        QueryFactory $queryFactory,
        ScopeConfigInterface $scopeConfig,
        \Vendor\CustomSearch\Helper\Data $helper
    ) {
        $this->queryFactory = $queryFactory;
        $this->scopeConfig = $scopeConfig;
        $this->helper = $helper;
    }

    /**
     * Before plugin method for execute
     *
     * @param Subject $subject
     * @return void
     */
    public function beforeExecute(Subject $subject)
    {
        // sudo php bin/magento module:disable Vendor_CustomSearch

        // Get the QueryFactory instance from the subject
        $query = $this->queryFactory->get();

        //below enabled 20 products 

        $products = array(
            array(
                "product_id" => 248,
                "product_name" => 7004014,
                "description" => "CYCL, RJ45 DB9F ADAPTER ADB0036",
                "sku" => "ADB0036",
                "gpn" => 7004014,
                "mfc" => "Rahi",
                "price" => 15.000000,
                "lead_time" => 40
            ),
            array(
                "product_id" => 255,
                "product_name" => 7003903,
                "description" => "POWER CORD L6-20P TO C19 8FT, 250V",
                "sku" => "ECX-C19L620-8FT",
                "gpn" => 7003903,
                "mfc" => "Enconnex",
                "price" => 37.000000,
                "lead_time" => 182
            ),
            array(
                "product_id" => 258,
                "product_name" => 7001319,
                "description" => "ADAPTER, CSC COMM. DB9F-RJ45 NULL",
                "sku" => "A-D945-NM",
                "gpn" => 7001319,
                "mfc" => "Technical Cable Applications Inc",
                "price" => 17.000000,
                "lead_time" => 40
            ),
            array(
                "product_id" => 259,
                "product_name" => 1063892,
                "description" => "Assy, Cord, Pwr, 20A, 250VAC, NEMA L6-20P x IEC 320/C19, 14-3, SJT Insulation, Blk, 10 ft, for use with L6-20R outlets wired with standard Line-to-Line power, 250V",
                "sku" => "ECX-C19L620-10FT",
                "gpn" => 1063892,
                "mfc" => "Enconnex",
                "price" => 36.000000,
                "lead_time" => 55
            ),
            array(
                "product_id" => 260,
                "product_name" => 7003904,
                "description" => "POWER CORD L6-20P TO C19 12FT, 250V",
                "sku" => "ECX-C19L620-12FT",
                "gpn" => 7003904,
                "mfc" => "Enconnex",
                "price" => 42.000000,
                "lead_time" => 105
            ),
            array(
                "product_id" => 274,
                "product_name" => 7004015,
                "description" => "CYCL, RJ45 DB9F ADAPTER ADB0037",
                "sku" => "ADB0037",
                "gpn" => 7004015,
                "mfc" => "Rahi",
                "price" => 18.000000,
                "lead_time" => 45
            ),
            array(
                "product_id" => 275,
                "product_name" => 7004100,
                "description" => "CYCL, RJ45 DB9F ADAPTER ADB0038",
                "sku" => "ADB0038",
                "gpn" => 7004100,
                "mfc" => "Rahi",
                "price" => 19.000000,
                "lead_time" => 50
            ),
            array(
                "product_id" => 280,
                "product_name" => 7004205,
                "description" => "CYCL, RJ45 DB9F ADAPTER ADB0039",
                "sku" => "ADB0039",
                "gpn" => 7004205,
                "mfc" => "Rahi",
                "price" => 20.000000,
                "lead_time" => 30
            ),
            array(
                "product_id" => 281,
                "product_name" => 7004310,
                "description" => "CYCL, RJ45 DB9F ADAPTER ADB0040",
                "sku" => "ADB0040",
                "gpn" => 7004310,
                "mfc" => "Rahi",
                "price" => 21.000000,
                "lead_time" => 60
            ),
            array(
                "product_id" => 289,
                "product_name" => 7004440,
                "description" => "CYCL, RJ45 DB9F ADAPTER ADB0041",
                "sku" => "ADB0041",
                "gpn" => 7004440,
                "mfc" => "Rahi",
                "price" => 22.000000,
                "lead_time" => 70
            ),
            array(
                "product_id" => 290,
                "product_name" => 7004555,
                "description" => "CYCL, RJ45 DB9F ADAPTER ADB0042",
                "sku" => "ADB0042",
                "gpn" => 7004555,
                "mfc" => "Rahi",
                "price" => 23.000000,
                "lead_time" => 80
            ),
            array(
                "product_id" => 294,
                "product_name" => 7004700,
                "description" => "CYCL, RJ45 DB9F ADAPTER ADB0043",
                "sku" => "ADB0043",
                "gpn" => 7004700,
                "mfc" => "Rahi",
                "price" => 24.000000,
                "lead_time" => 90
            ),
            array(
                "product_id" => 295,
                "product_name" => 7004805,
                "description" => "CYCL, RJ45 DB9F ADAPTER ADB0044",
                "sku" => "ADB0044",
                "gpn" => 7004805,
                "mfc" => "Rahi",
                "price" => 25.000000,
                "lead_time" => 100
            ),
            array(
                "product_id" => 296,
                "product_name" => 7004900,
                "description" => "CYCL, RJ45 DB9F ADAPTER ADB0045",
                "sku" => "ADB0045",
                "gpn" => 7004900,
                "mfc" => "Rahi",
                "price" => 26.000000,
                "lead_time" => 110
            ),
            array(
                "product_id" => 300,
                "product_name" => 7005010,
                "description" => "CYCL, RJ45 DB9F ADAPTER ADB0046",
                "sku" => "ADB0046",
                "gpn" => 7005010,
                "mfc" => "Rahi",
                "price" => 27.000000,
                "lead_time" => 120
            ),
            array(
                "product_id" => 304,
                "product_name" => 7005100,
                "description" => "CYCL, RJ45 DB9F ADAPTER ADB0047",
                "sku" => "ADB0047",
                "gpn" => 7005100,
                "mfc" => "Rahi",
                "price" => 28.000000,
                "lead_time" => 130
            ),
            array(
                "product_id" => 308,
                "product_name" => 7005200,
                "description" => "CYCL, RJ45 DB9F ADAPTER ADB0048",
                "sku" => "ADB0048",
                "gpn" => 7005200,
                "mfc" => "Rahi",
                "price" => 29.000000,
                "lead_time" => 140
            ),
            array(
                "product_id" => 312,
                "product_name" => 7005300,
                "description" => "CYCL, RJ45 DB9F ADAPTER ADB0049",
                "sku" => "ADB0049",
                "gpn" => 7005300,
                "mfc" => "Rahi",
                "price" => 30.000000,
                "lead_time" => 150
            ),
            array(
                "product_id" => 315,
                "product_name" => 7005400,
                "description" => "CYCL, RJ45 DB9F ADAPTER ADB0050",
                "sku" => "ADB0050",
                "gpn" => 7005400,
                "mfc" => "Rahi",
                "price" => 31.000000,
                "lead_time" => 160
            ),
            array(
                "product_id" => 316,
                "product_name" => 7005500,
                "description" => "CYCL, RJ45 DB9F ADAPTER ADB0051",
                "sku" => "ADB0051",
                "gpn" => 7005500,
                "mfc" => "Rahi",
                "price" => 32.000000,
                "lead_time" => 170
            )
        );

        // Extract GPN values

        // below code for balnk result
        // $query->setQueryText('***************************');
        // $_SESSION["product_ids"] = NULL;

        $query->setQueryText('7140284, 07054957, 07097392, 1020861, 1020976, 1021048, 1021051, 1021190, 1021385, 1023582');
        // echo $query->getQueryText(); die;
        // echo "sdsdsdsdsd"; die;

        // Modify the query text
        /**
         * custom code below, modifing search query
         */

        // send and get the api response and request here...

        // if (preg_match('/[^A-Za-z0-9\-_]/', $_GET['q'])) {

            // $pids = $this->helper->getValue('pids');

            // var_dump($pids); die;

            // $this->helper->setValue('pids', null);
            
        // } else {
            // $pids = $this->helper->getValue('pids');
            // var_dump($pids); die;

            $response = $this->sendApi(str_replace(' ', '+', $_GET['q']));
            $data = $products;//json_decode($response, 1);
            // echo "dddddd"; die;
            if ($response == "Invalid HTTP request received.") {
                // print_r($response);
                $this->helper->setValue('pids', null);
                return;
            } else if (isset($data['detail']) &&  $data['detail'] == "Query parameter is required") {
                $this->helper->setValue('pids', null);
                return;
            } else {
                if ($response) {
                    // $gpn_values = array_column($products, 'gpn');
                    $id_values = array_column($data, 'product_id');
                    $this->helper->setValue('pids', $id_values);
                    // Convert the array to a comma-separated string
                    // $gpn_string = implode(', ', $gpn_values);
                    // $ids_string = implode(', ', $id_values);
                } else {
                    $this->helper->setValue('pids', null);
                }
            }
        // }
        //------------------------------------------
        // Here you could also add any additional modifications or logging if needed
    }


    public function sendApi($query)
    {
        //&top_k=30
        // Retrieve API Key and API URL from the system configuration
        $apiKey = $this->scopeConfig->getValue('customsearch_api/api_settings/api_key', ScopeInterface::SCOPE_STORE);
        $apiUrl = $this->scopeConfig->getValue('customsearch_api/api_settings/api_url', ScopeInterface::SCOPE_STORE);
        $topK = $this->scopeConfig->getValue('customsearch_api/api_ranks/top_k', ScopeInterface::SCOPE_STORE);

        $limit = (is_numeric($topK) && $topK > 0) ? $topK : 0;

        // Create the full URL for the API request
        $url = $apiUrl . 'search?query=' . $query . "&" . $limit;

        // Initialize the cURL session
        $curl = curl_init();

        // Set cURL options
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'x-api-key: ' . $apiKey  // Use the API Key from the configuration
            ),
        ));

        // Execute the cURL request and get the response
        $response = curl_exec($curl);
        curl_close($curl);

        return $response;
    }
}
